/* nibbles-view.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from nibbles-view.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 * Gnome Nibbles: Gnome Worm Game
 * Copyright (C) 2015 Iulian-Gabriel Radu <iulian.radu67@gmail.com>
 * Copyright (C) 2023-2025 Ben Corby <bcorby@new-ms.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/*
 * Coding style.
 *
 * To help you comply with the coding style in this project use the
 * following greps. Any lines returned should be adjusted so they
 * don't match. The convoluted regular expressions are so they don't
 * match them self.
 *
 * grep -ne '[^][~)(}{_!$ "-](' *.vala
 * grep -ne '[(] ' *.vala
 * grep -ne '[ ])' *.vala
 * grep -ne ' $' *.vala
 *
 */

#include <glib.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gsk/gsk.h>
#include <graphene-gobject.h>
#include <gdk/gdk.h>
#include <gobject/gvaluecollector.h>
#include <gee.h>

#define NIBBLES_VIEW_WIDTH ((guint8) 92)
#define NIBBLES_VIEW_HEIGHT ((guint8) 66)
#define NIBBLES_VIEW_NUM_COLORS 6
#define NIBBLES_GAME_WARPCHAR 'W'
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_TRANSPARENT_CONTAINER (transparent_container_get_type ())
#define TRANSPARENT_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRANSPARENT_CONTAINER, TransparentContainer))
#define TRANSPARENT_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRANSPARENT_CONTAINER, TransparentContainerClass))
#define IS_TRANSPARENT_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRANSPARENT_CONTAINER))
#define IS_TRANSPARENT_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRANSPARENT_CONTAINER))
#define TRANSPARENT_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRANSPARENT_CONTAINER, TransparentContainerClass))

typedef struct _TransparentContainer TransparentContainer;
typedef struct _TransparentContainerClass TransparentContainerClass;
typedef struct _TransparentContainerPrivate TransparentContainerPrivate;

#define TYPE_NIBBLES_VIEW (nibbles_view_get_type ())
#define NIBBLES_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NIBBLES_VIEW, NibblesView))
#define NIBBLES_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NIBBLES_VIEW, NibblesViewClass))
#define IS_NIBBLES_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NIBBLES_VIEW))
#define IS_NIBBLES_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NIBBLES_VIEW))
#define NIBBLES_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NIBBLES_VIEW, NibblesViewClass))

typedef struct _NibblesView NibblesView;
typedef struct _NibblesViewClass NibblesViewClass;
typedef struct _NibblesViewPrivate NibblesViewPrivate;

#define TYPE_NIBBLES_GAME (nibbles_game_get_type ())
#define NIBBLES_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NIBBLES_GAME, NibblesGame))
#define NIBBLES_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NIBBLES_GAME, NibblesGameClass))
#define IS_NIBBLES_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NIBBLES_GAME))
#define IS_NIBBLES_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NIBBLES_GAME))
#define NIBBLES_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NIBBLES_GAME, NibblesGameClass))

typedef struct _NibblesGame NibblesGame;
typedef struct _NibblesGameClass NibblesGameClass;
typedef gint (*NibblesViewCountdownActiveFunction) (gpointer user_data);
typedef gboolean (*NibblesViewFullscreenActiveFunction) (gpointer user_data);

#define NIBBLES_VIEW_TYPE_STATIC_VIEW (nibbles_view_static_view_get_type ())
#define NIBBLES_VIEW_STATIC_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NIBBLES_VIEW_TYPE_STATIC_VIEW, NibblesViewStaticView))
#define NIBBLES_VIEW_STATIC_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NIBBLES_VIEW_TYPE_STATIC_VIEW, NibblesViewStaticViewClass))
#define NIBBLES_VIEW_IS_STATIC_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NIBBLES_VIEW_TYPE_STATIC_VIEW))
#define NIBBLES_VIEW_IS_STATIC_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NIBBLES_VIEW_TYPE_STATIC_VIEW))
#define NIBBLES_VIEW_STATIC_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NIBBLES_VIEW_TYPE_STATIC_VIEW, NibblesViewStaticViewClass))

typedef struct _NibblesViewStaticView NibblesViewStaticView;
typedef struct _NibblesViewStaticViewClass NibblesViewStaticViewClass;

#define NIBBLES_VIEW_TYPE_ACTIVE_VIEW (nibbles_view_active_view_get_type ())
#define NIBBLES_VIEW_ACTIVE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NIBBLES_VIEW_TYPE_ACTIVE_VIEW, NibblesViewActiveView))
#define NIBBLES_VIEW_ACTIVE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NIBBLES_VIEW_TYPE_ACTIVE_VIEW, NibblesViewActiveViewClass))
#define NIBBLES_VIEW_IS_ACTIVE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NIBBLES_VIEW_TYPE_ACTIVE_VIEW))
#define NIBBLES_VIEW_IS_ACTIVE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NIBBLES_VIEW_TYPE_ACTIVE_VIEW))
#define NIBBLES_VIEW_ACTIVE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NIBBLES_VIEW_TYPE_ACTIVE_VIEW, NibblesViewActiveViewClass))

typedef struct _NibblesViewActiveView NibblesViewActiveView;
typedef struct _NibblesViewActiveViewClass NibblesViewActiveViewClass;
enum  {
	NIBBLES_VIEW_0_PROPERTY,
	NIBBLES_VIEW_NUM_PROPERTIES
};
static GParamSpec* nibbles_view_properties[NIBBLES_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define NIBBLES_VIEW_TYPE_VIEW3_D (nibbles_view_view3_d_get_type ())
#define NIBBLES_VIEW_VIEW3_D(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NIBBLES_VIEW_TYPE_VIEW3_D, NibblesViewView3D))
#define NIBBLES_VIEW_VIEW3_D_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NIBBLES_VIEW_TYPE_VIEW3_D, NibblesViewView3DClass))
#define NIBBLES_VIEW_IS_VIEW3_D(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NIBBLES_VIEW_TYPE_VIEW3_D))
#define NIBBLES_VIEW_IS_VIEW3_D_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NIBBLES_VIEW_TYPE_VIEW3_D))
#define NIBBLES_VIEW_VIEW3_D_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NIBBLES_VIEW_TYPE_VIEW3_D, NibblesViewView3DClass))

typedef struct _NibblesViewView3D NibblesViewView3D;
typedef struct _NibblesViewView3DClass NibblesViewView3DClass;

#define NIBBLES_VIEW_TYPE_POINT3_D (nibbles_view_point3_d_get_type ())
typedef struct _NibblesViewPoint3D NibblesViewPoint3D;
#define _gsk_path_builder_unref0(var) ((var == NULL) ? NULL : (var = (gsk_path_builder_unref (var), NULL)))
#define _gsk_path_unref0(var) ((var == NULL) ? NULL : (var = (gsk_path_unref (var), NULL)))

#define TYPE_BONUS (bonus_get_type ())
#define BONUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BONUS, Bonus))
#define BONUS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BONUS, BonusClass))
#define IS_BONUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BONUS))
#define IS_BONUS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BONUS))
#define BONUS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BONUS, BonusClass))

typedef struct _Bonus Bonus;
typedef struct _BonusClass BonusClass;
typedef enum  {
	BONUS_ETYPE_REGULAR,
	BONUS_ETYPE_HALF,
	BONUS_ETYPE_DOUBLE,
	BONUS_ETYPE_LIFE,
	BONUS_ETYPE_REVERSE,
	BONUS_ETYPE_WARP
} BonuseType;

#define BONUS_TYPE_ETYPE (bonus_etype_get_type ())
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))
typedef struct _NibblesViewView3DPrivate NibblesViewView3DPrivate;
typedef struct _NibblesViewParamSpecView3D NibblesViewParamSpecView3D;
typedef struct _NibblesViewStaticViewPrivate NibblesViewStaticViewPrivate;
enum  {
	NIBBLES_VIEW_STATIC_VIEW_0_PROPERTY,
	NIBBLES_VIEW_STATIC_VIEW_NUM_PROPERTIES
};
static GParamSpec* nibbles_view_static_view_properties[NIBBLES_VIEW_STATIC_VIEW_NUM_PROPERTIES];
#define _nibbles_view_view3_d_unref0(var) ((var == NULL) ? NULL : (var = (nibbles_view_view3_d_unref (var), NULL)))
typedef struct _NibblesGamePrivate NibblesGamePrivate;
typedef struct _NibblesViewActiveViewPrivate NibblesViewActiveViewPrivate;
enum  {
	NIBBLES_VIEW_ACTIVE_VIEW_0_PROPERTY,
	NIBBLES_VIEW_ACTIVE_VIEW_NUM_PROPERTIES
};
static GParamSpec* nibbles_view_active_view_properties[NIBBLES_VIEW_ACTIVE_VIEW_NUM_PROPERTIES];

#define TYPE_WORM (worm_get_type ())
#define WORM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORM, Worm))
#define WORM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORM, WormClass))
#define IS_WORM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORM))
#define IS_WORM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORM))
#define WORM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORM, WormClass))

typedef struct _Worm Worm;
typedef struct _WormClass WormClass;
typedef struct _WormPrivate WormPrivate;

#define TYPE_POSITION (position_get_type ())
typedef struct _Position Position;

#define TYPE_WORM_POSITIONS (worm_positions_get_type ())
#define WORM_POSITIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORM_POSITIONS, WormPositions))
#define WORM_POSITIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORM_POSITIONS, WormPositionsClass))
#define IS_WORM_POSITIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORM_POSITIONS))
#define IS_WORM_POSITIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORM_POSITIONS))
#define WORM_POSITIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORM_POSITIONS, WormPositionsClass))

typedef struct _WormPositions WormPositions;
typedef struct _WormPositionsClass WormPositionsClass;

#define TYPE_WORM_PROPERTIES (worm_properties_get_type ())
#define WORM_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORM_PROPERTIES, WormProperties))
#define WORM_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORM_PROPERTIES, WormPropertiesClass))
#define IS_WORM_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORM_PROPERTIES))
#define IS_WORM_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORM_PROPERTIES))
#define WORM_PROPERTIES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORM_PROPERTIES, WormPropertiesClass))

typedef struct _WormProperties WormProperties;
typedef struct _WormPropertiesClass WormPropertiesClass;
typedef enum  {
	WORM_DIRECTION_NONE,
	WORM_DIRECTION_RIGHT,
	WORM_DIRECTION_EAST = WORM_DIRECTION_RIGHT,
	WORM_DIRECTION_DOWN,
	WORM_DIRECTION_SOUTH = WORM_DIRECTION_DOWN,
	WORM_DIRECTION_LEFT,
	WORM_DIRECTION_WEST = WORM_DIRECTION_LEFT,
	WORM_DIRECTION_UP,
	WORM_DIRECTION_NORTH = WORM_DIRECTION_UP
} WormDirection;

#define TYPE_WORM_DIRECTION (worm_direction_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

struct _TransparentContainer {
	GtkWidget parent_instance;
	TransparentContainerPrivate * priv;
};

struct _TransparentContainerClass {
	GtkWidgetClass parent_class;
};

struct _NibblesView {
	TransparentContainer parent_instance;
	NibblesViewPrivate * priv;
	NibblesGame* game;
};

struct _NibblesViewClass {
	TransparentContainerClass parent_class;
};

struct _NibblesViewPrivate {
	NibblesViewCountdownActiveFunction countdown_active;
	gpointer countdown_active_target;
	NibblesViewFullscreenActiveFunction fullscreen_active;
	gpointer fullscreen_active_target;
	NibblesViewStaticView* static_view;
	NibblesViewActiveView* active_view;
};

struct _NibblesViewPoint3D {
	gdouble x;
	gdouble y;
	gdouble z;
};

struct _NibblesViewView3D {
	GTypeInstance parent_instance;
	volatile int ref_count;
	NibblesViewView3DPrivate * priv;
};

struct _NibblesViewView3DClass {
	GTypeClass parent_class;
	void (*finalize) (NibblesViewView3D *self);
};

struct _NibblesViewView3DPrivate {
	gdouble view_plain_y;
	gboolean has_view_plain_been_set;
	gdouble view_plain_z_height;
	gboolean has_view_plain_z_height_been_set;
	NibblesViewPoint3D view_point;
	gdouble x_scale;
	gdouble y_scale;
};

struct _NibblesViewParamSpecView3D {
	GParamSpec parent_instance;
};

struct _NibblesViewStaticView {
	GtkWidget parent_instance;
	NibblesViewStaticViewPrivate * priv;
};

struct _NibblesViewStaticViewClass {
	GtkWidgetClass parent_class;
};

struct _NibblesViewStaticViewPrivate {
	NibblesView* view;
};

struct _NibblesGame {
	GObject parent_instance;
	NibblesGamePrivate * priv;
	gint _progress;
	gint* levels_uncompleated;
	gint levels_uncompleated_length1;
	gint _levels_uncompleated_size_;
	gint* board;
	gint board_length1;
	gint board_length2;
	gboolean added_keypress_handler;
};

struct _NibblesGameClass {
	GObjectClass parent_class;
};

struct _NibblesViewActiveView {
	GtkWidget parent_instance;
	NibblesViewActiveViewPrivate * priv;
};

struct _NibblesViewActiveViewClass {
	GtkWidgetClass parent_class;
};

struct _NibblesViewActiveViewPrivate {
	guint64 animate;
	NibblesView* view;
};

struct _Position {
	guint8 x;
	guint8 y;
};

struct _Worm {
	GObject parent_instance;
	WormPrivate * priv;
	gboolean is_human;
	gint rounds_to_stay_still;
	gboolean is_stopped;
	Position warp_position;
	gboolean warp_bonus;
	WormPositions* list;
};

struct _WormClass {
	GObjectClass parent_class;
};

static gint NibblesView_private_offset;
static gpointer nibbles_view_parent_class = NULL;
static gchar** nibbles_view_color_lookup;
static gint nibbles_view_color_lookup_length1;
static gint nibbles_view_color_lookup_length2;
static gchar** nibbles_view_color_lookup = NULL;
static gint nibbles_view_color_lookup_length1 = 0;
static gint nibbles_view_color_lookup_length2 = 0;
static gint NibblesViewView3D_private_offset;
static gpointer nibbles_view_view3_d_parent_class = NULL;
static gint NibblesViewStaticView_private_offset;
static gpointer nibbles_view_static_view_parent_class = NULL;
static gint NibblesViewActiveView_private_offset;
static gpointer nibbles_view_active_view_parent_class = NULL;

VALA_EXTERN void get_worm_rgb (gint color,
                   gboolean bright,
                   gdouble* r,
                   gdouble* g,
                   gdouble* b);
VALA_EXTERN void get_worm_pango_color (gint color,
                           gboolean bright,
                           PangoColor* c);
VALA_EXTERN GType transparent_container_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TransparentContainer, g_object_unref)
VALA_EXTERN GType nibbles_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NibblesView, g_object_unref)
VALA_EXTERN GType nibbles_game_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NibblesGame, g_object_unref)
VALA_EXTERN GType nibbles_view_static_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NibblesViewStaticView, g_object_unref)
VALA_EXTERN GType nibbles_view_active_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NibblesViewActiveView, g_object_unref)
VALA_EXTERN NibblesView* nibbles_view_new (NibblesGame* game,
                               NibblesViewCountdownActiveFunction countdown_active,
                               gpointer countdown_active_target,
                               NibblesViewFullscreenActiveFunction fullscreen_active,
                               gpointer fullscreen_active_target);
VALA_EXTERN NibblesView* nibbles_view_construct (GType object_type,
                                     NibblesGame* game,
                                     NibblesViewCountdownActiveFunction countdown_active,
                                     gpointer countdown_active_target,
                                     NibblesViewFullscreenActiveFunction fullscreen_active,
                                     gpointer fullscreen_active_target);
VALA_EXTERN TransparentContainer* transparent_container_new (void);
VALA_EXTERN TransparentContainer* transparent_container_construct (GType object_type);
VALA_EXTERN NibblesViewStaticView* nibbles_view_static_view_new (NibblesView* view);
VALA_EXTERN NibblesViewStaticView* nibbles_view_static_view_construct (GType object_type,
                                                           NibblesView* view);
VALA_EXTERN NibblesViewActiveView* nibbles_view_active_view_new (NibblesView* view);
VALA_EXTERN NibblesViewActiveView* nibbles_view_active_view_construct (GType object_type,
                                                           NibblesView* view);
VALA_EXTERN void transparent_container_set_child (TransparentContainer* self,
                                      GtkWidget* value);
VALA_EXTERN void nibbles_view_connect_game_signals (NibblesView* self,
                                        NibblesGame* game);
static gchar* nibbles_view_seconds_string (NibblesView* self,
                                    gint s);
static gchar* nibbles_view_worm_name (NibblesView* self,
                               gint id);
VALA_EXTERN void nibbles_view_redraw (NibblesView* self,
                          gboolean AnimateStep);
VALA_EXTERN void nibbles_view_active_view_redraw (NibblesViewActiveView* self,
                                      gboolean AnimateStep);
VALA_EXTERN void nibbles_view_redraw_all (NibblesView* self);
VALA_EXTERN void nibbles_view_static_view_redraw (NibblesViewStaticView* self);
static void _nibbles_view_redraw_nibbles_game_redraw (NibblesGame* _sender,
                                               gboolean animate,
                                               gpointer self);
static gpointer nibbles_view_view3_d_ref (gpointer instance);
static void nibbles_view_view3_d_unref (gpointer instance);
static GParamSpec* nibbles_view_param_spec_view3_d (const gchar* name,
                                             const gchar* nick,
                                             const gchar* blurb,
                                             GType object_type,
                                             GParamFlags flags) G_GNUC_UNUSED ;
static void nibbles_view_value_set_view3_d (GValue* value,
                                     gpointer v_object) G_GNUC_UNUSED ;
static void nibbles_view_value_take_view3_d (GValue* value,
                                      gpointer v_object) G_GNUC_UNUSED ;
static gpointer nibbles_view_value_get_view3_d (const GValue* value) G_GNUC_UNUSED ;
static GType nibbles_view_view3_d_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NibblesViewView3D, nibbles_view_view3_d_unref)
static GType nibbles_view_point3_d_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static NibblesViewPoint3D* nibbles_view_point3_d_dup (const NibblesViewPoint3D* self);
static void nibbles_view_point3_d_free (NibblesViewPoint3D* self);
static GskPath* nibbles_view_draw_oval (NibblesView* self,
                                 NibblesViewView3D* v,
                                 NibblesViewPoint3D* a,
                                 NibblesViewPoint3D* b,
                                 NibblesViewPoint3D* c,
                                 NibblesViewPoint3D* d);
static void nibbles_view_mid_point (NibblesView* self,
                             NibblesViewPoint3D* a,
                             NibblesViewPoint3D* b,
                             NibblesViewPoint3D* result);
static void nibbles_view_view3_d_to_view_plain (NibblesViewView3D* self,
                                         NibblesViewPoint3D* point,
                                         gdouble* x_at_plain,
                                         gdouble* z_at_plain);
static void nibbles_view_draw_sphere (NibblesView* self,
                               GtkSnapshot* s,
                               NibblesViewView3D* v,
                               gint x,
                               gint y,
                               gdouble r,
                               gdouble g,
                               gdouble b,
                               gdouble size);
static gdouble nibbles_view_view3_d_2D_diff (NibblesViewView3D* self,
                                      NibblesViewPoint3D* a,
                                      NibblesViewPoint3D* b);
static void nibbles_view_get_bounds (NibblesView* self,
                              GskPath* path,
                              graphene_rect_t* result);
static void nibbles_view_draw_eyes_front (NibblesView* self,
                                   GtkSnapshot* s,
                                   NibblesViewView3D* v,
                                   gint x,
                                   gint y,
                                   gboolean blink);
static void nibbles_view_draw_eyes_left (NibblesView* self,
                                  GtkSnapshot* s,
                                  NibblesViewView3D* v,
                                  gint x,
                                  gint y,
                                  gboolean blink);
static void nibbles_view_draw_eyes_right (NibblesView* self,
                                   GtkSnapshot* s,
                                   NibblesViewView3D* v,
                                   gint x,
                                   gint y,
                                   gboolean blink);
VALA_EXTERN GType bonus_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Bonus, g_object_unref)
static void nibbles_view_draw_3D_bonus (NibblesView* self,
                                 GtkSnapshot* s,
                                 NibblesViewView3D* v,
                                 gint x,
                                 gint y,
                                 Bonus* bonus);
VALA_EXTERN GType bonus_etype_get_type (void) G_GNUC_CONST ;
VALA_EXTERN BonuseType bonus_get_etype (Bonus* self);
static void nibbles_view_draw_apple (NibblesView* self,
                              GtkSnapshot* s,
                              NibblesViewView3D* v,
                              gdouble x,
                              gdouble y);
static void nibbles_view_draw_cherry (NibblesView* self,
                               GtkSnapshot* s,
                               NibblesViewView3D* v,
                               gdouble x,
                               gdouble y);
static void nibbles_view_draw_banana (NibblesView* self,
                               GtkSnapshot* s,
                               NibblesViewView3D* v,
                               gdouble x,
                               gdouble y);
static void nibbles_view_draw_heart (NibblesView* self,
                              GtkSnapshot* s,
                              NibblesViewView3D* v,
                              gdouble x,
                              gdouble y);
static void nibbles_view_draw_diamond (NibblesView* self,
                                GtkSnapshot* s,
                                NibblesViewView3D* v,
                                gdouble x,
                                gdouble y);
static void nibbles_view_draw_wall_segment (NibblesView* self,
                                     gint i,
                                     GtkSnapshot* s,
                                     gint x,
                                     gint y,
                                     gint x_size,
                                     gint y_size);
static void nibbles_view_draw_worm_segment (NibblesView* self,
                                     GtkSnapshot* s,
                                     gint x,
                                     gint y,
                                     gint x_size,
                                     gint y_size,
                                     gint color,
                                     gboolean is_materialized,
                                     gboolean eaten_bonus);
static void nibbles_view_draw_bonus (NibblesView* self,
                              GtkSnapshot* s,
                              gint x,
                              gint y,
                              gint x_size,
                              gint y_size,
                              BonuseType type,
                              guint64 animate);
static void nibbles_view_draw_text_target_width (NibblesView* self,
                                          GtkSnapshot* snapshot,
                                          gint x,
                                          gint y,
                                          const gchar* text,
                                          gint target_width,
                                          gint color);
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
static PangoFontDescription* _vala_PangoFontDescription_copy (PangoFontDescription* self);
static void nibbles_view_calculate_text_size (NibblesView* self,
                                       const gchar* text,
                                       gint font_size,
                                       gdouble* width,
                                       gdouble* height);
static void nibbles_view_draw_text_font_size (NibblesView* self,
                                       GtkSnapshot* snapshot,
                                       gint x,
                                       gint y,
                                       const gchar* text,
                                       gint font_size);
static void nibbles_view_get_text_offsets (NibblesView* self,
                                    const gchar* text,
                                    gint font_size,
                                    gint* x_offset,
                                    gint* y_offset);
VALA_EXTERN gchar* nibbles_view_colorval_name_untranslated (gint colorval);
static void nibbles_view_view3_d_set_view_plain (NibblesViewView3D* self,
                                          gdouble y);
static void nibbles_view_view3_d_set_view_point (NibblesViewView3D* self,
                                          NibblesViewPoint3D* point,
                                          gdouble max_object_height);
static void nibbles_view_view3_d_set_scale_x (NibblesViewView3D* self,
                                       gdouble scale);
static void nibbles_view_view3_d_set_scale_y (NibblesViewView3D* self,
                                       gdouble scale);
static gdouble nibbles_view_view3_d_view_point_x (NibblesViewView3D* self);
static NibblesViewView3D* nibbles_view_view3_d_new (void);
static NibblesViewView3D* nibbles_view_view3_d_construct (GType object_type);
static void nibbles_view_view3_d_finalize (NibblesViewView3D * obj);
static GType nibbles_view_view3_d_get_type_once (void);
static GskPath* nibbles_view_static_view_rectangle (NibblesViewStaticView* self,
                                             guint x,
                                             guint y,
                                             guint width,
                                             guint height);
static void nibbles_view_static_view_real_snapshot (GtkWidget* base,
                                             GtkSnapshot* s);
VALA_EXTERN gboolean nibbles_game_get_three_dimensional_view (NibblesGame* self);
static void nibbles_view_static_view_finalize (GObject * obj);
static GType nibbles_view_static_view_get_type_once (void);
static void nibbles_view_active_view_real_snapshot (GtkWidget* base,
                                             GtkSnapshot* s);
VALA_EXTERN GType worm_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Worm, g_object_unref)
VALA_EXTERN GeeLinkedList* nibbles_game_get_worms (NibblesGame* self);
VALA_EXTERN GType position_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Position* position_dup (const Position* self);
VALA_EXTERN void position_free (Position* self);
VALA_EXTERN GType worm_positions_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WormPositions, g_object_unref)
VALA_EXTERN gboolean worm_get_is_materialized (Worm* self);
static void _vala_array_add5 (Worm** * array,
                       gint* length,
                       gint* size,
                       Worm* value);
VALA_EXTERN GeeList* nibbles_game_get_bonuses (NibblesGame* self);
VALA_EXTERN guint8 bonus_get_x (Bonus* self);
VALA_EXTERN guint8 bonus_get_y (Bonus* self);
VALA_EXTERN GType worm_properties_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WormProperties, g_object_unref)
VALA_EXTERN GeeHashMap* nibbles_game_get_worm_props (NibblesGame* self);
VALA_EXTERN gint worm_properties_get_color (WormProperties* self);
VALA_EXTERN gboolean worm_was_bonus_eaten_at_this_position (Worm* self,
                                                guint16 position);
VALA_EXTERN void worm_get_head (Worm* self,
                    Position * result);
VALA_EXTERN GType worm_direction_get_type (void) G_GNUC_CONST ;
VALA_EXTERN WormDirection worm_get_direction (Worm* self);
VALA_EXTERN gint worm_get_id (Worm* self);
VALA_EXTERN gint worm_get_length (Worm* self);
static void _vala_array_add6 (gint* * array,
                       gint* length,
                       gint* size,
                       gint value);
static void nibbles_view_active_view_finalize (GObject * obj);
static GType nibbles_view_active_view_get_type_once (void);
static void nibbles_view_finalize (GObject * obj);
static GType nibbles_view_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

void
get_worm_rgb (gint color,
              gboolean bright,
              gdouble* r,
              gdouble* g,
              gdouble* b)
{
	gdouble _vala_r = 0.0;
	gdouble _vala_g = 0.0;
	gdouble _vala_b = 0.0;
	switch (color) {
		case 0:
		{
			gdouble _tmp0_ = 0.0;
			if (bright) {
				_tmp0_ = (gdouble) 1;
			} else {
				_tmp0_ = 0.75;
			}
			_vala_r = _tmp0_;
			_vala_g = (gdouble) 0;
			_vala_b = (gdouble) 0;
			break;
		}
		case 1:
		{
			gdouble _tmp1_ = 0.0;
			_vala_r = (gdouble) 0;
			if (bright) {
				_tmp1_ = 0.75;
			} else {
				_tmp1_ = 0.5;
			}
			_vala_g = _tmp1_;
			_vala_b = (gdouble) 0;
			break;
		}
		case 2:
		{
			gdouble _tmp2_ = 0.0;
			gdouble _tmp3_ = 0.0;
			_vala_r = (gdouble) 0;
			if (bright) {
				_tmp2_ = 0.5;
			} else {
				_tmp2_ = 0.25;
			}
			_vala_g = _tmp2_;
			if (bright) {
				_tmp3_ = (gdouble) 1;
			} else {
				_tmp3_ = 0.75;
			}
			_vala_b = _tmp3_;
			break;
		}
		case 3:
		{
			gdouble _tmp4_ = 0.0;
			gdouble _tmp5_ = 0.0;
			if (bright) {
				_tmp4_ = 0.9;
			} else {
				_tmp4_ = 0.75;
			}
			_vala_r = _tmp4_;
			if (bright) {
				_tmp5_ = 0.9;
			} else {
				_tmp5_ = 0.75;
			}
			_vala_g = _tmp5_;
			_vala_b = (gdouble) 0;
			break;
		}
		case 4:
		{
			gdouble _tmp6_ = 0.0;
			gdouble _tmp7_ = 0.0;
			_vala_r = (gdouble) 0;
			if (bright) {
				_tmp6_ = (gdouble) 1;
			} else {
				_tmp6_ = 0.75;
			}
			_vala_g = _tmp6_;
			if (bright) {
				_tmp7_ = (gdouble) 1;
			} else {
				_tmp7_ = 0.75;
			}
			_vala_b = _tmp7_;
			break;
		}
		case 5:
		{
			gdouble _tmp8_ = 0.0;
			gdouble _tmp9_ = 0.0;
			if (bright) {
				_tmp8_ = 0.75;
			} else {
				_tmp8_ = 0.5;
			}
			_vala_r = _tmp8_;
			_vala_g = (gdouble) 0;
			if (bright) {
				_tmp9_ = 0.75;
			} else {
				_tmp9_ = 0.5;
			}
			_vala_b = _tmp9_;
			break;
		}
		default:
		{
			gdouble _tmp10_ = 0.0;
			gdouble _tmp11_ = 0.0;
			gdouble _tmp12_ = 0.0;
			if (bright) {
				_tmp10_ = (gdouble) 1;
			} else {
				_tmp10_ = 0.75;
			}
			_vala_r = _tmp10_;
			if (bright) {
				_tmp11_ = (gdouble) 1;
			} else {
				_tmp11_ = 0.75;
			}
			_vala_g = _tmp11_;
			if (bright) {
				_tmp12_ = (gdouble) 1;
			} else {
				_tmp12_ = 0.75;
			}
			_vala_b = _tmp12_;
			break;
		}
	}
	if (r) {
		*r = _vala_r;
	}
	if (g) {
		*g = _vala_g;
	}
	if (b) {
		*b = _vala_b;
	}
}

void
get_worm_pango_color (gint color,
                      gboolean bright,
                      PangoColor* c)
{
	gdouble r = 0.0;
	gdouble g = 0.0;
	gdouble b = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	g_return_if_fail (c != NULL);
	get_worm_rgb (color, bright, &_tmp0_, &_tmp1_, &_tmp2_);
	r = _tmp0_;
	g = _tmp1_;
	b = _tmp2_;
	(*c).red = (guint16) (r * 0xffff);
	(*c).green = (guint16) (g * 0xffff);
	(*c).blue = (guint16) (b * 0xffff);
}

static inline gpointer
nibbles_view_get_instance_private (NibblesView* self)
{
	return G_STRUCT_MEMBER_P (self, NibblesView_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

NibblesView*
nibbles_view_construct (GType object_type,
                        NibblesGame* game,
                        NibblesViewCountdownActiveFunction countdown_active,
                        gpointer countdown_active_target,
                        NibblesViewFullscreenActiveFunction fullscreen_active,
                        gpointer fullscreen_active_target)
{
	NibblesView * self = NULL;
	NibblesGame* _tmp0_;
	NibblesViewStaticView* _tmp1_;
	NibblesViewActiveView* _tmp2_;
	GtkOverlay* overlay = NULL;
	GtkOverlay* _tmp3_;
	NibblesViewStaticView* _tmp4_;
	NibblesViewActiveView* _tmp5_;
	g_return_val_if_fail (game != NULL, NULL);
	self = (NibblesView*) transparent_container_construct (object_type);
	_tmp0_ = _g_object_ref0 (game);
	_g_object_unref0 (self->game);
	self->game = _tmp0_;
	self->priv->countdown_active = countdown_active;
	self->priv->countdown_active_target = countdown_active_target;
	self->priv->fullscreen_active = fullscreen_active;
	self->priv->fullscreen_active_target = fullscreen_active_target;
	_tmp1_ = nibbles_view_static_view_new (self);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->static_view);
	self->priv->static_view = _tmp1_;
	_tmp2_ = nibbles_view_active_view_new (self);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->active_view);
	self->priv->active_view = _tmp2_;
	_tmp3_ = (GtkOverlay*) gtk_overlay_new ();
	g_object_ref_sink (_tmp3_);
	overlay = _tmp3_;
	_tmp4_ = self->priv->static_view;
	gtk_overlay_set_child (overlay, (GtkWidget*) _tmp4_);
	_tmp5_ = self->priv->active_view;
	gtk_overlay_add_overlay (overlay, (GtkWidget*) _tmp5_);
	transparent_container_set_child ((TransparentContainer*) self, (GtkWidget*) overlay);
	gtk_widget_set_focusable ((GtkWidget*) self, TRUE);
	nibbles_view_connect_game_signals (self, game);
	_g_object_unref0 (overlay);
	return self;
}

NibblesView*
nibbles_view_new (NibblesGame* game,
                  NibblesViewCountdownActiveFunction countdown_active,
                  gpointer countdown_active_target,
                  NibblesViewFullscreenActiveFunction fullscreen_active,
                  gpointer fullscreen_active_target)
{
	return nibbles_view_construct (TYPE_NIBBLES_VIEW, game, countdown_active, countdown_active_target, fullscreen_active, fullscreen_active_target);
}

static gchar*
nibbles_view_seconds_string (NibblesView* self,
                             gint s)
{
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	switch (s) {
		case 1:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup (_ ("1"));
			result = _tmp0_;
			return result;
		}
		case 2:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup (_ ("2"));
			result = _tmp1_;
			return result;
		}
		case 3:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup (_ ("3"));
			result = _tmp2_;
			return result;
		}
		default:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("");
			result = _tmp3_;
			return result;
		}
	}
}

static gchar*
nibbles_view_worm_name (NibblesView* self,
                        gint id)
{
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	switch (id) {
		case 1:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup (_ ("Worm 1"));
			result = _tmp0_;
			return result;
		}
		case 2:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup (_ ("Worm 2"));
			result = _tmp1_;
			return result;
		}
		case 3:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup (_ ("Worm 3"));
			result = _tmp2_;
			return result;
		}
		case 4:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup (_ ("Worm 4"));
			result = _tmp3_;
			return result;
		}
		case 5:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup (_ ("Worm 5"));
			result = _tmp4_;
			return result;
		}
		case 6:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup (_ ("Worm 6"));
			result = _tmp5_;
			return result;
		}
		default:
		{
			gchar* _tmp6_;
			_tmp6_ = g_strdup ("");
			result = _tmp6_;
			return result;
		}
	}
}

void
nibbles_view_redraw (NibblesView* self,
                     gboolean AnimateStep)
{
	NibblesViewActiveView* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->active_view;
	if (NULL != _tmp0_) {
		NibblesViewActiveView* _tmp1_;
		_tmp1_ = self->priv->active_view;
		nibbles_view_active_view_redraw (_tmp1_, AnimateStep);
	}
}

void
nibbles_view_redraw_all (NibblesView* self)
{
	NibblesViewActiveView* _tmp0_;
	NibblesViewStaticView* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->active_view;
	if (NULL != _tmp0_) {
		NibblesViewActiveView* _tmp1_;
		_tmp1_ = self->priv->active_view;
		nibbles_view_active_view_redraw (_tmp1_, FALSE);
	}
	_tmp2_ = self->priv->static_view;
	if (NULL != _tmp2_) {
		NibblesViewStaticView* _tmp3_;
		_tmp3_ = self->priv->static_view;
		nibbles_view_static_view_redraw (_tmp3_);
	}
}

static void
_nibbles_view_redraw_nibbles_game_redraw (NibblesGame* _sender,
                                          gboolean animate,
                                          gpointer self)
{
	nibbles_view_redraw ((NibblesView*) self, animate);
}

void
nibbles_view_connect_game_signals (NibblesView* self,
                                   NibblesGame* game)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	g_signal_connect_object (game, "redraw", (GCallback) _nibbles_view_redraw_nibbles_game_redraw, self, 0);
}

static GskPath*
nibbles_view_draw_oval (NibblesView* self,
                        NibblesViewView3D* v,
                        NibblesViewPoint3D* a,
                        NibblesViewPoint3D* b,
                        NibblesViewPoint3D* c,
                        NibblesViewPoint3D* d)
{
	gdouble x[3] = {0};
	gdouble y[3] = {0};
	NibblesViewPoint3D p[8] = {0};
	NibblesViewPoint3D _tmp0_;
	NibblesViewPoint3D _tmp1_;
	NibblesViewPoint3D _tmp2_;
	NibblesViewPoint3D _tmp3_ = {0};
	NibblesViewPoint3D _tmp4_;
	NibblesViewPoint3D _tmp5_;
	NibblesViewPoint3D _tmp6_;
	NibblesViewPoint3D _tmp7_ = {0};
	NibblesViewPoint3D _tmp8_;
	NibblesViewPoint3D _tmp9_;
	NibblesViewPoint3D _tmp10_;
	NibblesViewPoint3D _tmp11_ = {0};
	NibblesViewPoint3D _tmp12_;
	NibblesViewPoint3D _tmp13_;
	NibblesViewPoint3D _tmp14_;
	NibblesViewPoint3D _tmp15_ = {0};
	NibblesViewPoint3D _tmp16_[8] = {0};
	guint lowest_y_midpoint_index = 0U;
	guint second_lowest_y_midpoint_index = 0U;
	GskPathBuilder* path = NULL;
	GskPathBuilder* _tmp26_;
	gint _tmp27_ = 0;
	gint direction = 0;
	GskPathBuilder* _tmp48_;
	GskPath* _tmp49_;
	GskPath* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (v != NULL, NULL);
	g_return_val_if_fail (a != NULL, NULL);
	g_return_val_if_fail (b != NULL, NULL);
	g_return_val_if_fail (c != NULL, NULL);
	g_return_val_if_fail (d != NULL, NULL);
	_tmp0_ = *a;
	_tmp1_ = *a;
	_tmp2_ = *b;
	nibbles_view_mid_point (self, &_tmp1_, &_tmp2_, &_tmp3_);
	_tmp4_ = *b;
	_tmp5_ = *b;
	_tmp6_ = *c;
	nibbles_view_mid_point (self, &_tmp5_, &_tmp6_, &_tmp7_);
	_tmp8_ = *c;
	_tmp9_ = *c;
	_tmp10_ = *d;
	nibbles_view_mid_point (self, &_tmp9_, &_tmp10_, &_tmp11_);
	_tmp12_ = *d;
	_tmp13_ = *d;
	_tmp14_ = *a;
	nibbles_view_mid_point (self, &_tmp13_, &_tmp14_, &_tmp15_);
	_tmp16_[0] = _tmp0_;
	_tmp16_[1] = _tmp3_;
	_tmp16_[2] = _tmp4_;
	_tmp16_[3] = _tmp7_;
	_tmp16_[4] = _tmp8_;
	_tmp16_[5] = _tmp11_;
	_tmp16_[6] = _tmp12_;
	_tmp16_[7] = _tmp15_;
	memcpy (p, _tmp16_, 8 * sizeof (NibblesViewPoint3D));
	lowest_y_midpoint_index = G_MAXUINT;
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp17_ = FALSE;
			_tmp17_ = TRUE;
			while (TRUE) {
				gboolean _tmp18_ = FALSE;
				if (!_tmp17_) {
					i += 2;
				}
				_tmp17_ = FALSE;
				if (!(i < 8)) {
					break;
				}
				if (lowest_y_midpoint_index == G_MAXUINT) {
					_tmp18_ = TRUE;
				} else {
					NibblesViewPoint3D _tmp19_;
					NibblesViewPoint3D _tmp20_;
					_tmp19_ = p[lowest_y_midpoint_index];
					_tmp20_ = p[i];
					_tmp18_ = _tmp19_.y > _tmp20_.y;
				}
				if (_tmp18_) {
					lowest_y_midpoint_index = (guint) i;
				}
			}
		}
	}
	second_lowest_y_midpoint_index = G_MAXUINT;
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp21_ = FALSE;
			_tmp21_ = TRUE;
			while (TRUE) {
				gboolean _tmp22_ = FALSE;
				if (!_tmp21_) {
					i += 2;
				}
				_tmp21_ = FALSE;
				if (!(i < 8)) {
					break;
				}
				if (((guint) i) != lowest_y_midpoint_index) {
					gboolean _tmp23_ = FALSE;
					if (second_lowest_y_midpoint_index == G_MAXUINT) {
						_tmp23_ = TRUE;
					} else {
						NibblesViewPoint3D _tmp24_;
						NibblesViewPoint3D _tmp25_;
						_tmp24_ = p[second_lowest_y_midpoint_index];
						_tmp25_ = p[i];
						_tmp23_ = _tmp24_.y > _tmp25_.y;
					}
					_tmp22_ = _tmp23_;
				} else {
					_tmp22_ = FALSE;
				}
				if (_tmp22_) {
					second_lowest_y_midpoint_index = (guint) i;
				}
			}
		}
	}
	_tmp26_ = gsk_path_builder_new ();
	path = _tmp26_;
	if (second_lowest_y_midpoint_index > lowest_y_midpoint_index) {
		_tmp27_ = -1;
	} else {
		_tmp27_ = 1;
	}
	direction = _tmp27_;
	{
		guint i = 0U;
		i = second_lowest_y_midpoint_index;
		{
			gboolean _tmp28_ = FALSE;
			_tmp28_ = TRUE;
			while (TRUE) {
				gint between_point = 0;
				gint next_index = 0;
				NibblesViewPoint3D _tmp29_;
				gdouble _tmp30_ = 0.0;
				gdouble _tmp31_ = 0.0;
				NibblesViewPoint3D _tmp32_;
				gdouble _tmp33_ = 0.0;
				gdouble _tmp34_ = 0.0;
				NibblesViewPoint3D _tmp35_;
				gdouble _tmp36_ = 0.0;
				gdouble _tmp37_ = 0.0;
				GskPathBuilder* _tmp41_;
				gdouble _tmp42_;
				gdouble _tmp43_;
				gdouble _tmp44_;
				gdouble _tmp45_;
				gdouble _tmp46_;
				gdouble _tmp47_;
				if (!_tmp28_) {
				}
				_tmp28_ = FALSE;
				between_point = ((gint) i) + direction;
				next_index = between_point + direction;
				if (between_point < 0) {
					between_point += 8;
				} else {
					if (between_point > 7) {
						between_point -= 8;
					}
				}
				if (next_index < 0) {
					next_index += 8;
				} else {
					if (next_index > 7) {
						next_index -= 8;
					}
				}
				_tmp29_ = p[i];
				nibbles_view_view3_d_to_view_plain (v, &_tmp29_, &_tmp30_, &_tmp31_);
				x[0] = _tmp30_;
				y[0] = _tmp31_;
				_tmp32_ = p[between_point];
				nibbles_view_view3_d_to_view_plain (v, &_tmp32_, &_tmp33_, &_tmp34_);
				x[1] = _tmp33_;
				y[1] = _tmp34_;
				_tmp35_ = p[next_index];
				nibbles_view_view3_d_to_view_plain (v, &_tmp35_, &_tmp36_, &_tmp37_);
				x[2] = _tmp36_;
				y[2] = _tmp37_;
				if (i == second_lowest_y_midpoint_index) {
					GskPathBuilder* _tmp38_;
					gdouble _tmp39_;
					gdouble _tmp40_;
					_tmp38_ = path;
					_tmp39_ = x[0];
					_tmp40_ = y[0];
					gsk_path_builder_move_to (_tmp38_, (gfloat) _tmp39_, (gfloat) _tmp40_);
				}
				_tmp41_ = path;
				_tmp42_ = x[0];
				_tmp43_ = y[0];
				_tmp44_ = x[1];
				_tmp45_ = y[1];
				_tmp46_ = x[2];
				_tmp47_ = y[2];
				gsk_path_builder_cubic_to (_tmp41_, (gfloat) _tmp42_, (gfloat) _tmp43_, (gfloat) _tmp44_, (gfloat) _tmp45_, (gfloat) _tmp46_, (gfloat) _tmp47_);
				i = (guint) next_index;
				if (i == second_lowest_y_midpoint_index) {
					break;
				}
			}
		}
	}
	_tmp48_ = path;
	_tmp49_ = gsk_path_builder_to_path (_tmp48_);
	result = _tmp49_;
	_gsk_path_builder_unref0 (path);
	return result;
}

static void
nibbles_view_mid_point (NibblesView* self,
                        NibblesViewPoint3D* a,
                        NibblesViewPoint3D* b,
                        NibblesViewPoint3D* result)
{
	gdouble _tmp0_ = 0.0;
	NibblesViewPoint3D _tmp1_;
	NibblesViewPoint3D _tmp2_;
	gdouble _tmp9_ = 0.0;
	NibblesViewPoint3D _tmp10_;
	NibblesViewPoint3D _tmp11_;
	gdouble _tmp18_ = 0.0;
	NibblesViewPoint3D _tmp19_;
	NibblesViewPoint3D _tmp20_;
	NibblesViewPoint3D _tmp27_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (a != NULL);
	g_return_if_fail (b != NULL);
	_tmp1_ = *a;
	_tmp2_ = *b;
	if (_tmp1_.x > _tmp2_.x) {
		NibblesViewPoint3D _tmp3_;
		NibblesViewPoint3D _tmp4_;
		NibblesViewPoint3D _tmp5_;
		_tmp3_ = *a;
		_tmp4_ = *b;
		_tmp5_ = *b;
		_tmp0_ = ((_tmp3_.x - _tmp4_.x) / 2) + _tmp5_.x;
	} else {
		NibblesViewPoint3D _tmp6_;
		NibblesViewPoint3D _tmp7_;
		NibblesViewPoint3D _tmp8_;
		_tmp6_ = *b;
		_tmp7_ = *a;
		_tmp8_ = *a;
		_tmp0_ = ((_tmp6_.x - _tmp7_.x) / 2) + _tmp8_.x;
	}
	_tmp10_ = *a;
	_tmp11_ = *b;
	if (_tmp10_.y > _tmp11_.y) {
		NibblesViewPoint3D _tmp12_;
		NibblesViewPoint3D _tmp13_;
		NibblesViewPoint3D _tmp14_;
		_tmp12_ = *a;
		_tmp13_ = *b;
		_tmp14_ = *b;
		_tmp9_ = ((_tmp12_.y - _tmp13_.y) / 2) + _tmp14_.y;
	} else {
		NibblesViewPoint3D _tmp15_;
		NibblesViewPoint3D _tmp16_;
		NibblesViewPoint3D _tmp17_;
		_tmp15_ = *b;
		_tmp16_ = *a;
		_tmp17_ = *a;
		_tmp9_ = ((_tmp15_.y - _tmp16_.y) / 2) + _tmp17_.y;
	}
	_tmp19_ = *a;
	_tmp20_ = *b;
	if (_tmp19_.z > _tmp20_.z) {
		NibblesViewPoint3D _tmp21_;
		NibblesViewPoint3D _tmp22_;
		NibblesViewPoint3D _tmp23_;
		_tmp21_ = *a;
		_tmp22_ = *b;
		_tmp23_ = *b;
		_tmp18_ = ((_tmp21_.z - _tmp22_.z) / 2) + _tmp23_.z;
	} else {
		NibblesViewPoint3D _tmp24_;
		NibblesViewPoint3D _tmp25_;
		NibblesViewPoint3D _tmp26_;
		_tmp24_ = *b;
		_tmp25_ = *a;
		_tmp26_ = *a;
		_tmp18_ = ((_tmp24_.z - _tmp25_.z) / 2) + _tmp26_.z;
	}
	_tmp27_.x = _tmp0_;
	_tmp27_.y = _tmp9_;
	_tmp27_.z = _tmp18_;
	*result = _tmp27_;
	return;
}

static void
nibbles_view_draw_sphere (NibblesView* self,
                          GtkSnapshot* s,
                          NibblesViewView3D* v,
                          gint x,
                          gint y,
                          gdouble r,
                          gdouble g,
                          gdouble b,
                          gdouble size)
{
	gdouble increase = 0.0;
	GskPath* path = NULL;
	NibblesViewPoint3D _tmp0_ = {0};
	NibblesViewPoint3D _tmp1_ = {0};
	NibblesViewPoint3D _tmp2_ = {0};
	NibblesViewPoint3D _tmp3_ = {0};
	GskPath* _tmp4_;
	gdouble radius_x = 0.0;
	gdouble radius_y = 0.0;
	gdouble d = 0.0;
	gdouble top_x = 0.0;
	gdouble top_y = 0.0;
	NibblesViewPoint3D _tmp5_ = {0};
	NibblesViewPoint3D _tmp6_ = {0};
	NibblesViewPoint3D _tmp7_ = {0};
	NibblesViewPoint3D _tmp8_ = {0};
	NibblesViewPoint3D _tmp9_ = {0};
	NibblesViewPoint3D _tmp10_ = {0};
	NibblesViewPoint3D _tmp11_ = {0};
	NibblesViewPoint3D _tmp12_ = {0};
	NibblesViewPoint3D _tmp13_ = {0};
	gdouble _tmp14_ = 0.0;
	gdouble _tmp15_ = 0.0;
	GskPath* _tmp16_;
	GskPath* _tmp17_;
	graphene_rect_t _tmp18_ = {0};
	graphene_point_t _tmp19_ = {0};
	GdkRGBA _tmp20_ = {0};
	GskColorStop _tmp21_ = {0};
	GdkRGBA _tmp22_ = {0};
	GskColorStop _tmp23_ = {0};
	GdkRGBA _tmp24_ = {0};
	GskColorStop _tmp25_ = {0};
	GskColorStop* _tmp26_;
	GskColorStop* _tmp27_;
	gint _tmp27__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	g_return_if_fail (v != NULL);
	increase = (size - 1) / 2;
	_tmp0_.x = (x + 0) - increase;
	_tmp0_.y = (y + 1.0) + increase;
	_tmp0_.z = 0 - increase;
	_tmp1_.x = (x + 0) - increase;
	_tmp1_.y = (y + 0.0) - increase;
	_tmp1_.z = 1 + increase;
	_tmp2_.x = (x + 1) + increase;
	_tmp2_.y = (y + 0.0) - increase;
	_tmp2_.z = 1 + increase;
	_tmp3_.x = (x + 1) + increase;
	_tmp3_.y = (y + 1.0) + increase;
	_tmp3_.z = 0 - increase;
	_tmp4_ = nibbles_view_draw_oval (self, v, &_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_);
	path = _tmp4_;
	_tmp5_.x = x + 0.5;
	_tmp5_.y = y + 0.5;
	_tmp5_.z = 0.5;
	_tmp6_.x = x + 0.5;
	_tmp6_.y = (y + 0.0) - increase;
	_tmp6_.z = 1 + increase;
	radius_y = nibbles_view_view3_d_2D_diff (v, &_tmp5_, &_tmp6_);
	_tmp7_.x = x + 0.5;
	_tmp7_.y = y + 0.5;
	_tmp7_.z = 0.5;
	_tmp8_.x = x + 0.5;
	_tmp8_.y = (y + 1.0) + increase;
	_tmp8_.z = 0.0 - increase;
	d = nibbles_view_view3_d_2D_diff (v, &_tmp7_, &_tmp8_);
	if (d > radius_y) {
		radius_y = d;
	}
	_tmp9_.x = x + 0.5;
	_tmp9_.y = y + 0.5;
	_tmp9_.z = 0.5;
	_tmp10_.x = (x + 0.0) - increase;
	_tmp10_.y = y + 0.5;
	_tmp10_.z = 0.5;
	radius_x = nibbles_view_view3_d_2D_diff (v, &_tmp9_, &_tmp10_);
	_tmp11_.x = x + 0.5;
	_tmp11_.y = y + 0.5;
	_tmp11_.z = 0.5;
	_tmp12_.x = (x + 1.0) + increase;
	_tmp12_.y = y + 0.5;
	_tmp12_.z = 0.5;
	d = nibbles_view_view3_d_2D_diff (v, &_tmp11_, &_tmp12_);
	if (d > radius_x) {
		radius_x = d;
	}
	_tmp13_.x = x + 0.5;
	_tmp13_.y = y + 0.5;
	_tmp13_.z = (gdouble) 1;
	nibbles_view_view3_d_to_view_plain (v, &_tmp13_, &_tmp14_, &_tmp15_);
	top_x = _tmp14_;
	top_y = _tmp15_;
	_tmp16_ = path;
	gtk_snapshot_push_fill (s, _tmp16_, GSK_FILL_RULE_EVEN_ODD);
	_tmp17_ = path;
	nibbles_view_get_bounds (self, _tmp17_, &_tmp18_);
	_tmp19_.x = (gfloat) top_x;
	_tmp19_.y = (gfloat) top_y;
	_tmp20_.red = ((1 - ((gfloat) r)) / 2) + ((gfloat) r);
	_tmp20_.green = ((1 - ((gfloat) g)) / 2) + ((gfloat) g);
	_tmp20_.blue = ((1 - ((gfloat) b)) / 2) + ((gfloat) b);
	_tmp20_.alpha = (gfloat) 1;
	memset (&_tmp21_, 0, sizeof (GskColorStop));
	_tmp21_.offset = (gfloat) 0;
	_tmp21_.color = _tmp20_;
	_tmp22_.red = (gfloat) r;
	_tmp22_.green = (gfloat) g;
	_tmp22_.blue = (gfloat) b;
	_tmp22_.alpha = (gfloat) 1;
	memset (&_tmp23_, 0, sizeof (GskColorStop));
	_tmp23_.offset = 0.1f;
	_tmp23_.color = _tmp22_;
	_tmp24_.red = ((gfloat) r) / 10.0f;
	_tmp24_.green = ((gfloat) g) / 10.0f;
	_tmp24_.blue = ((gfloat) b) / 10.0f;
	_tmp24_.alpha = (gfloat) 1;
	memset (&_tmp25_, 0, sizeof (GskColorStop));
	_tmp25_.offset = (gfloat) 1;
	_tmp25_.color = _tmp24_;
	_tmp26_ = g_new0 (GskColorStop, 3);
	_tmp26_[0] = _tmp21_;
	_tmp26_[1] = _tmp23_;
	_tmp26_[2] = _tmp25_;
	_tmp27_ = _tmp26_;
	_tmp27__length1 = 3;
	gtk_snapshot_append_radial_gradient (s, &_tmp18_, &_tmp19_, ((gfloat) radius_x) / 80.0f, ((gfloat) radius_y) / 80.0f, (gfloat) 0, (gfloat) 100, _tmp27_, (gsize) 3);
	_tmp27_ = (g_free (_tmp27_), NULL);
	gtk_snapshot_pop (s);
	_gsk_path_unref0 (path);
}

static void
nibbles_view_draw_eyes_front (NibblesView* self,
                              GtkSnapshot* s,
                              NibblesViewView3D* v,
                              gint x,
                              gint y,
                              gboolean blink)
{
	gdouble e = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble b = 0.0;
	NibblesViewPoint3D centre = {0};
	NibblesViewPoint3D _tmp1_ = {0};
	NibblesViewPoint3D _tmp2_;
	NibblesViewPoint3D _tmp3_;
	NibblesViewPoint3D _tmp4_;
	NibblesViewPoint3D _tmp5_ = {0};
	NibblesViewPoint3D _tmp6_;
	NibblesViewPoint3D _tmp7_;
	NibblesViewPoint3D _tmp8_;
	NibblesViewPoint3D _tmp9_ = {0};
	NibblesViewPoint3D _tmp10_;
	NibblesViewPoint3D _tmp11_;
	NibblesViewPoint3D _tmp12_;
	NibblesViewPoint3D _tmp13_ = {0};
	NibblesViewPoint3D _tmp14_;
	NibblesViewPoint3D _tmp15_;
	NibblesViewPoint3D _tmp16_;
	NibblesViewPoint3D _tmp17_ = {0};
	GskPath* _tmp18_;
	GskPath* _tmp19_;
	GdkRGBA _tmp20_ = {0};
	NibblesViewPoint3D _tmp21_ = {0};
	NibblesViewPoint3D _tmp22_;
	NibblesViewPoint3D _tmp23_;
	NibblesViewPoint3D _tmp24_;
	NibblesViewPoint3D _tmp25_ = {0};
	NibblesViewPoint3D _tmp26_;
	NibblesViewPoint3D _tmp27_;
	NibblesViewPoint3D _tmp28_;
	NibblesViewPoint3D _tmp29_ = {0};
	NibblesViewPoint3D _tmp30_;
	NibblesViewPoint3D _tmp31_;
	NibblesViewPoint3D _tmp32_;
	NibblesViewPoint3D _tmp33_ = {0};
	NibblesViewPoint3D _tmp34_;
	NibblesViewPoint3D _tmp35_;
	NibblesViewPoint3D _tmp36_;
	NibblesViewPoint3D _tmp37_ = {0};
	GskPath* _tmp38_;
	GskPath* _tmp39_;
	GdkRGBA _tmp40_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	g_return_if_fail (v != NULL);
	e = sqrt (0.125);
	if (blink) {
		_tmp0_ = 0.025;
	} else {
		_tmp0_ = 0.1;
	}
	b = _tmp0_;
	_tmp1_.x = (x + 0.5) - (e / 2);
	_tmp1_.y = (y + 0.5) + e;
	_tmp1_.z = 0.5 + (e / 2);
	centre = _tmp1_;
	_tmp2_ = centre;
	_tmp3_ = centre;
	_tmp4_ = centre;
	_tmp5_.x = _tmp2_.x - 0.1;
	_tmp5_.y = _tmp3_.y + b;
	_tmp5_.z = _tmp4_.z - b;
	_tmp6_ = centre;
	_tmp7_ = centre;
	_tmp8_ = centre;
	_tmp9_.x = _tmp6_.x - 0.1;
	_tmp9_.y = _tmp7_.y - b;
	_tmp9_.z = _tmp8_.z + b;
	_tmp10_ = centre;
	_tmp11_ = centre;
	_tmp12_ = centre;
	_tmp13_.x = _tmp10_.x + 0.1;
	_tmp13_.y = _tmp11_.y - b;
	_tmp13_.z = _tmp12_.z + b;
	_tmp14_ = centre;
	_tmp15_ = centre;
	_tmp16_ = centre;
	_tmp17_.x = _tmp14_.x + 0.1;
	_tmp17_.y = _tmp15_.y + b;
	_tmp17_.z = _tmp16_.z - b;
	_tmp18_ = nibbles_view_draw_oval (self, v, &_tmp5_, &_tmp9_, &_tmp13_, &_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_.red = 0.0f;
	_tmp20_.green = 0.0f;
	_tmp20_.blue = 0.0f;
	_tmp20_.alpha = 1.0f;
	gtk_snapshot_append_fill (s, _tmp19_, GSK_FILL_RULE_EVEN_ODD, &_tmp20_);
	_gsk_path_unref0 (_tmp19_);
	_tmp21_.x = (x + 0.5) + (e / 2);
	_tmp21_.y = (y + 0.5) + e;
	_tmp21_.z = 0.5 + (e / 2);
	centre = _tmp21_;
	_tmp22_ = centre;
	_tmp23_ = centre;
	_tmp24_ = centre;
	_tmp25_.x = _tmp22_.x - 0.1;
	_tmp25_.y = _tmp23_.y + b;
	_tmp25_.z = _tmp24_.z - b;
	_tmp26_ = centre;
	_tmp27_ = centre;
	_tmp28_ = centre;
	_tmp29_.x = _tmp26_.x - 0.1;
	_tmp29_.y = _tmp27_.y - b;
	_tmp29_.z = _tmp28_.z + b;
	_tmp30_ = centre;
	_tmp31_ = centre;
	_tmp32_ = centre;
	_tmp33_.x = _tmp30_.x + 0.1;
	_tmp33_.y = _tmp31_.y - b;
	_tmp33_.z = _tmp32_.z + b;
	_tmp34_ = centre;
	_tmp35_ = centre;
	_tmp36_ = centre;
	_tmp37_.x = _tmp34_.x + 0.1;
	_tmp37_.y = _tmp35_.y + b;
	_tmp37_.z = _tmp36_.z - b;
	_tmp38_ = nibbles_view_draw_oval (self, v, &_tmp25_, &_tmp29_, &_tmp33_, &_tmp37_);
	_tmp39_ = _tmp38_;
	_tmp40_.red = 0.0f;
	_tmp40_.green = 0.0f;
	_tmp40_.blue = 0.0f;
	_tmp40_.alpha = 1.0f;
	gtk_snapshot_append_fill (s, _tmp39_, GSK_FILL_RULE_EVEN_ODD, &_tmp40_);
	_gsk_path_unref0 (_tmp39_);
}

static void
nibbles_view_draw_eyes_left (NibblesView* self,
                             GtkSnapshot* s,
                             NibblesViewView3D* v,
                             gint x,
                             gint y,
                             gboolean blink)
{
	gdouble e = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble b = 0.0;
	NibblesViewPoint3D centre = {0};
	NibblesViewPoint3D _tmp1_ = {0};
	NibblesViewPoint3D _tmp2_;
	NibblesViewPoint3D _tmp3_;
	NibblesViewPoint3D _tmp4_;
	NibblesViewPoint3D _tmp5_ = {0};
	NibblesViewPoint3D _tmp6_;
	NibblesViewPoint3D _tmp7_;
	NibblesViewPoint3D _tmp8_;
	NibblesViewPoint3D _tmp9_ = {0};
	NibblesViewPoint3D _tmp10_;
	NibblesViewPoint3D _tmp11_;
	NibblesViewPoint3D _tmp12_;
	NibblesViewPoint3D _tmp13_ = {0};
	NibblesViewPoint3D _tmp14_;
	NibblesViewPoint3D _tmp15_;
	NibblesViewPoint3D _tmp16_;
	NibblesViewPoint3D _tmp17_ = {0};
	GskPath* _tmp18_;
	GskPath* _tmp19_;
	GdkRGBA _tmp20_ = {0};
	NibblesViewPoint3D _tmp21_ = {0};
	NibblesViewPoint3D _tmp22_;
	NibblesViewPoint3D _tmp23_;
	NibblesViewPoint3D _tmp24_;
	NibblesViewPoint3D _tmp25_ = {0};
	NibblesViewPoint3D _tmp26_;
	NibblesViewPoint3D _tmp27_;
	NibblesViewPoint3D _tmp28_;
	NibblesViewPoint3D _tmp29_ = {0};
	NibblesViewPoint3D _tmp30_;
	NibblesViewPoint3D _tmp31_;
	NibblesViewPoint3D _tmp32_;
	NibblesViewPoint3D _tmp33_ = {0};
	NibblesViewPoint3D _tmp34_;
	NibblesViewPoint3D _tmp35_;
	NibblesViewPoint3D _tmp36_;
	NibblesViewPoint3D _tmp37_ = {0};
	GskPath* _tmp38_;
	GskPath* _tmp39_;
	GdkRGBA _tmp40_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	g_return_if_fail (v != NULL);
	e = sqrt (0.125);
	if (blink) {
		_tmp0_ = 0.025;
	} else {
		_tmp0_ = 0.1;
	}
	b = _tmp0_;
	_tmp1_.x = (x + 0.5) - e;
	_tmp1_.y = (y + 0.5) - (e / 2);
	_tmp1_.z = 0.5 + (e / 2);
	centre = _tmp1_;
	_tmp2_ = centre;
	_tmp3_ = centre;
	_tmp4_ = centre;
	_tmp5_.x = _tmp2_.x - b;
	_tmp5_.y = _tmp3_.y - 0.1;
	_tmp5_.z = _tmp4_.z - b;
	_tmp6_ = centre;
	_tmp7_ = centre;
	_tmp8_ = centre;
	_tmp9_.x = _tmp6_.x + b;
	_tmp9_.y = _tmp7_.y - 0.1;
	_tmp9_.z = _tmp8_.z + b;
	_tmp10_ = centre;
	_tmp11_ = centre;
	_tmp12_ = centre;
	_tmp13_.x = _tmp10_.x + b;
	_tmp13_.y = _tmp11_.y + 0.1;
	_tmp13_.z = _tmp12_.z + b;
	_tmp14_ = centre;
	_tmp15_ = centre;
	_tmp16_ = centre;
	_tmp17_.x = _tmp14_.x - b;
	_tmp17_.y = _tmp15_.y + 0.1;
	_tmp17_.z = _tmp16_.z - b;
	_tmp18_ = nibbles_view_draw_oval (self, v, &_tmp5_, &_tmp9_, &_tmp13_, &_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_.red = 0.0f;
	_tmp20_.green = 0.0f;
	_tmp20_.blue = 0.0f;
	_tmp20_.alpha = 1.0f;
	gtk_snapshot_append_fill (s, _tmp19_, GSK_FILL_RULE_EVEN_ODD, &_tmp20_);
	_gsk_path_unref0 (_tmp19_);
	_tmp21_.x = (x + 0.5) - e;
	_tmp21_.y = (y + 0.5) + (e / 2);
	_tmp21_.z = 0.5 + (e / 2);
	centre = _tmp21_;
	_tmp22_ = centre;
	_tmp23_ = centre;
	_tmp24_ = centre;
	_tmp25_.x = _tmp22_.x - b;
	_tmp25_.y = _tmp23_.y - 0.1;
	_tmp25_.z = _tmp24_.z - b;
	_tmp26_ = centre;
	_tmp27_ = centre;
	_tmp28_ = centre;
	_tmp29_.x = _tmp26_.x + b;
	_tmp29_.y = _tmp27_.y - 0.1;
	_tmp29_.z = _tmp28_.z + b;
	_tmp30_ = centre;
	_tmp31_ = centre;
	_tmp32_ = centre;
	_tmp33_.x = _tmp30_.x + b;
	_tmp33_.y = _tmp31_.y + 0.1;
	_tmp33_.z = _tmp32_.z + b;
	_tmp34_ = centre;
	_tmp35_ = centre;
	_tmp36_ = centre;
	_tmp37_.x = _tmp34_.x - b;
	_tmp37_.y = _tmp35_.y + 0.1;
	_tmp37_.z = _tmp36_.z - b;
	_tmp38_ = nibbles_view_draw_oval (self, v, &_tmp25_, &_tmp29_, &_tmp33_, &_tmp37_);
	_tmp39_ = _tmp38_;
	_tmp40_.red = 0.0f;
	_tmp40_.green = 0.0f;
	_tmp40_.blue = 0.0f;
	_tmp40_.alpha = 1.0f;
	gtk_snapshot_append_fill (s, _tmp39_, GSK_FILL_RULE_EVEN_ODD, &_tmp40_);
	_gsk_path_unref0 (_tmp39_);
}

static void
nibbles_view_draw_eyes_right (NibblesView* self,
                              GtkSnapshot* s,
                              NibblesViewView3D* v,
                              gint x,
                              gint y,
                              gboolean blink)
{
	gdouble e = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble b = 0.0;
	NibblesViewPoint3D centre = {0};
	NibblesViewPoint3D _tmp1_ = {0};
	NibblesViewPoint3D _tmp2_;
	NibblesViewPoint3D _tmp3_;
	NibblesViewPoint3D _tmp4_;
	NibblesViewPoint3D _tmp5_ = {0};
	NibblesViewPoint3D _tmp6_;
	NibblesViewPoint3D _tmp7_;
	NibblesViewPoint3D _tmp8_;
	NibblesViewPoint3D _tmp9_ = {0};
	NibblesViewPoint3D _tmp10_;
	NibblesViewPoint3D _tmp11_;
	NibblesViewPoint3D _tmp12_;
	NibblesViewPoint3D _tmp13_ = {0};
	NibblesViewPoint3D _tmp14_;
	NibblesViewPoint3D _tmp15_;
	NibblesViewPoint3D _tmp16_;
	NibblesViewPoint3D _tmp17_ = {0};
	GskPath* _tmp18_;
	GskPath* _tmp19_;
	GdkRGBA _tmp20_ = {0};
	NibblesViewPoint3D _tmp21_ = {0};
	NibblesViewPoint3D _tmp22_;
	NibblesViewPoint3D _tmp23_;
	NibblesViewPoint3D _tmp24_;
	NibblesViewPoint3D _tmp25_ = {0};
	NibblesViewPoint3D _tmp26_;
	NibblesViewPoint3D _tmp27_;
	NibblesViewPoint3D _tmp28_;
	NibblesViewPoint3D _tmp29_ = {0};
	NibblesViewPoint3D _tmp30_;
	NibblesViewPoint3D _tmp31_;
	NibblesViewPoint3D _tmp32_;
	NibblesViewPoint3D _tmp33_ = {0};
	NibblesViewPoint3D _tmp34_;
	NibblesViewPoint3D _tmp35_;
	NibblesViewPoint3D _tmp36_;
	NibblesViewPoint3D _tmp37_ = {0};
	GskPath* _tmp38_;
	GskPath* _tmp39_;
	GdkRGBA _tmp40_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	g_return_if_fail (v != NULL);
	e = sqrt (0.125);
	if (blink) {
		_tmp0_ = 0.025;
	} else {
		_tmp0_ = 0.1;
	}
	b = _tmp0_;
	_tmp1_.x = (x + 0.5) + e;
	_tmp1_.y = (y + 0.5) - (e / 2);
	_tmp1_.z = 0.5 + (e / 2);
	centre = _tmp1_;
	_tmp2_ = centre;
	_tmp3_ = centre;
	_tmp4_ = centre;
	_tmp5_.x = _tmp2_.x + b;
	_tmp5_.y = _tmp3_.y - 0.1;
	_tmp5_.z = _tmp4_.z - b;
	_tmp6_ = centre;
	_tmp7_ = centre;
	_tmp8_ = centre;
	_tmp9_.x = _tmp6_.x - b;
	_tmp9_.y = _tmp7_.y - 0.1;
	_tmp9_.z = _tmp8_.z + b;
	_tmp10_ = centre;
	_tmp11_ = centre;
	_tmp12_ = centre;
	_tmp13_.x = _tmp10_.x - b;
	_tmp13_.y = _tmp11_.y + 0.1;
	_tmp13_.z = _tmp12_.z + b;
	_tmp14_ = centre;
	_tmp15_ = centre;
	_tmp16_ = centre;
	_tmp17_.x = _tmp14_.x + b;
	_tmp17_.y = _tmp15_.y + 0.1;
	_tmp17_.z = _tmp16_.z - b;
	_tmp18_ = nibbles_view_draw_oval (self, v, &_tmp5_, &_tmp9_, &_tmp13_, &_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_.red = 0.0f;
	_tmp20_.green = 0.0f;
	_tmp20_.blue = 0.0f;
	_tmp20_.alpha = 1.0f;
	gtk_snapshot_append_fill (s, _tmp19_, GSK_FILL_RULE_EVEN_ODD, &_tmp20_);
	_gsk_path_unref0 (_tmp19_);
	_tmp21_.x = (x + 0.5) + e;
	_tmp21_.y = (y + 0.5) + (e / 2);
	_tmp21_.z = 0.5 + (e / 2);
	centre = _tmp21_;
	_tmp22_ = centre;
	_tmp23_ = centre;
	_tmp24_ = centre;
	_tmp25_.x = _tmp22_.x + b;
	_tmp25_.y = _tmp23_.y - 0.1;
	_tmp25_.z = _tmp24_.z - b;
	_tmp26_ = centre;
	_tmp27_ = centre;
	_tmp28_ = centre;
	_tmp29_.x = _tmp26_.x - b;
	_tmp29_.y = _tmp27_.y - 0.1;
	_tmp29_.z = _tmp28_.z + b;
	_tmp30_ = centre;
	_tmp31_ = centre;
	_tmp32_ = centre;
	_tmp33_.x = _tmp30_.x - b;
	_tmp33_.y = _tmp31_.y + 0.1;
	_tmp33_.z = _tmp32_.z + b;
	_tmp34_ = centre;
	_tmp35_ = centre;
	_tmp36_ = centre;
	_tmp37_.x = _tmp34_.x + b;
	_tmp37_.y = _tmp35_.y + 0.1;
	_tmp37_.z = _tmp36_.z - b;
	_tmp38_ = nibbles_view_draw_oval (self, v, &_tmp25_, &_tmp29_, &_tmp33_, &_tmp37_);
	_tmp39_ = _tmp38_;
	_tmp40_.red = 0.0f;
	_tmp40_.green = 0.0f;
	_tmp40_.blue = 0.0f;
	_tmp40_.alpha = 1.0f;
	gtk_snapshot_append_fill (s, _tmp39_, GSK_FILL_RULE_EVEN_ODD, &_tmp40_);
	_gsk_path_unref0 (_tmp39_);
}

static void
nibbles_view_draw_3D_bonus (NibblesView* self,
                            GtkSnapshot* s,
                            NibblesViewView3D* v,
                            gint x,
                            gint y,
                            Bonus* bonus)
{
	BonuseType _tmp0_;
	BonuseType _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	g_return_if_fail (v != NULL);
	g_return_if_fail (bonus != NULL);
	_tmp0_ = bonus_get_etype (bonus);
	_tmp1_ = _tmp0_;
	switch (_tmp1_) {
		case BONUS_ETYPE_REGULAR:
		{
			nibbles_view_draw_apple (self, s, v, (gdouble) x, (gdouble) y);
			break;
		}
		case BONUS_ETYPE_HALF:
		{
			nibbles_view_draw_cherry (self, s, v, (gdouble) x, (gdouble) y);
			break;
		}
		case BONUS_ETYPE_DOUBLE:
		{
			nibbles_view_draw_banana (self, s, v, (gdouble) x, (gdouble) y);
			break;
		}
		case BONUS_ETYPE_LIFE:
		{
			nibbles_view_draw_heart (self, s, v, (gdouble) x, (gdouble) y);
			break;
		}
		case BONUS_ETYPE_REVERSE:
		{
			nibbles_view_draw_diamond (self, s, v, (gdouble) x, (gdouble) y);
			break;
		}
		case BONUS_ETYPE_WARP:
		{
			break;
		}
		case 6:
		{
			break;
		}
		case 7:
		{
			break;
		}
		default:
		{
			break;
		}
	}
}

static void
nibbles_view_draw_banana (NibblesView* self,
                          GtkSnapshot* s,
                          NibblesViewView3D* v,
                          gdouble x,
                          gdouble y)
{
	gdouble cx[3] = {0};
	gdouble cy[3] = {0};
	GskPathBuilder* dark_side = NULL;
	GskPathBuilder* _tmp0_;
	NibblesViewPoint3D _tmp1_ = {0};
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	NibblesViewPoint3D _tmp4_ = {0};
	gdouble _tmp5_ = 0.0;
	gdouble _tmp6_ = 0.0;
	NibblesViewPoint3D _tmp7_ = {0};
	gdouble _tmp8_ = 0.0;
	gdouble _tmp9_ = 0.0;
	gdouble _tmp10_;
	gdouble _tmp11_;
	gdouble _tmp12_;
	gdouble _tmp13_;
	gdouble _tmp14_;
	gdouble _tmp15_;
	gdouble _tmp16_;
	gdouble _tmp17_;
	NibblesViewPoint3D _tmp18_ = {0};
	gdouble _tmp19_ = 0.0;
	gdouble _tmp20_ = 0.0;
	NibblesViewPoint3D _tmp21_ = {0};
	gdouble _tmp22_ = 0.0;
	gdouble _tmp23_ = 0.0;
	NibblesViewPoint3D _tmp24_ = {0};
	gdouble _tmp25_ = 0.0;
	gdouble _tmp26_ = 0.0;
	gdouble _tmp27_;
	gdouble _tmp28_;
	gdouble _tmp29_;
	gdouble _tmp30_;
	gdouble _tmp31_;
	gdouble _tmp32_;
	NibblesViewPoint3D _tmp33_ = {0};
	gdouble _tmp34_ = 0.0;
	gdouble _tmp35_ = 0.0;
	gdouble _tmp36_;
	gdouble _tmp37_;
	NibblesViewPoint3D _tmp38_ = {0};
	gdouble _tmp39_ = 0.0;
	gdouble _tmp40_ = 0.0;
	gdouble _tmp41_;
	gdouble _tmp42_;
	NibblesViewPoint3D _tmp43_ = {0};
	gdouble _tmp44_ = 0.0;
	gdouble _tmp45_ = 0.0;
	NibblesViewPoint3D _tmp46_ = {0};
	gdouble _tmp47_ = 0.0;
	gdouble _tmp48_ = 0.0;
	NibblesViewPoint3D _tmp49_ = {0};
	gdouble _tmp50_ = 0.0;
	gdouble _tmp51_ = 0.0;
	gdouble _tmp52_;
	gdouble _tmp53_;
	gdouble _tmp54_;
	gdouble _tmp55_;
	gdouble _tmp56_;
	gdouble _tmp57_;
	NibblesViewPoint3D _tmp58_ = {0};
	gdouble _tmp59_ = 0.0;
	gdouble _tmp60_ = 0.0;
	NibblesViewPoint3D _tmp61_ = {0};
	gdouble _tmp62_ = 0.0;
	gdouble _tmp63_ = 0.0;
	NibblesViewPoint3D _tmp64_ = {0};
	gdouble _tmp65_ = 0.0;
	gdouble _tmp66_ = 0.0;
	gdouble _tmp67_;
	gdouble _tmp68_;
	gdouble _tmp69_;
	gdouble _tmp70_;
	gdouble _tmp71_;
	gdouble _tmp72_;
	GskPath* _tmp73_;
	GskPath* _tmp74_;
	GdkRGBA _tmp75_ = {0};
	GskPathBuilder* light_side = NULL;
	GskPathBuilder* _tmp76_;
	NibblesViewPoint3D _tmp77_ = {0};
	gdouble _tmp78_ = 0.0;
	gdouble _tmp79_ = 0.0;
	gdouble _tmp80_;
	gdouble _tmp81_;
	NibblesViewPoint3D _tmp82_ = {0};
	gdouble _tmp83_ = 0.0;
	gdouble _tmp84_ = 0.0;
	gdouble _tmp85_;
	gdouble _tmp86_;
	NibblesViewPoint3D _tmp87_ = {0};
	gdouble _tmp88_ = 0.0;
	gdouble _tmp89_ = 0.0;
	NibblesViewPoint3D _tmp90_ = {0};
	gdouble _tmp91_ = 0.0;
	gdouble _tmp92_ = 0.0;
	NibblesViewPoint3D _tmp93_ = {0};
	gdouble _tmp94_ = 0.0;
	gdouble _tmp95_ = 0.0;
	gdouble _tmp96_;
	gdouble _tmp97_;
	gdouble _tmp98_;
	gdouble _tmp99_;
	gdouble _tmp100_;
	gdouble _tmp101_;
	NibblesViewPoint3D _tmp102_ = {0};
	gdouble _tmp103_ = 0.0;
	gdouble _tmp104_ = 0.0;
	NibblesViewPoint3D _tmp105_ = {0};
	gdouble _tmp106_ = 0.0;
	gdouble _tmp107_ = 0.0;
	NibblesViewPoint3D _tmp108_ = {0};
	gdouble _tmp109_ = 0.0;
	gdouble _tmp110_ = 0.0;
	gdouble _tmp111_;
	gdouble _tmp112_;
	gdouble _tmp113_;
	gdouble _tmp114_;
	gdouble _tmp115_;
	gdouble _tmp116_;
	NibblesViewPoint3D _tmp117_ = {0};
	gdouble _tmp118_ = 0.0;
	gdouble _tmp119_ = 0.0;
	gdouble _tmp120_;
	gdouble _tmp121_;
	NibblesViewPoint3D _tmp122_ = {0};
	gdouble _tmp123_ = 0.0;
	gdouble _tmp124_ = 0.0;
	gdouble _tmp125_;
	gdouble _tmp126_;
	NibblesViewPoint3D _tmp127_ = {0};
	gdouble _tmp128_ = 0.0;
	gdouble _tmp129_ = 0.0;
	gdouble _tmp130_;
	gdouble _tmp131_;
	NibblesViewPoint3D _tmp132_ = {0};
	gdouble _tmp133_ = 0.0;
	gdouble _tmp134_ = 0.0;
	gdouble _tmp135_;
	gdouble _tmp136_;
	NibblesViewPoint3D _tmp137_ = {0};
	gdouble _tmp138_ = 0.0;
	gdouble _tmp139_ = 0.0;
	NibblesViewPoint3D _tmp140_ = {0};
	gdouble _tmp141_ = 0.0;
	gdouble _tmp142_ = 0.0;
	NibblesViewPoint3D _tmp143_ = {0};
	gdouble _tmp144_ = 0.0;
	gdouble _tmp145_ = 0.0;
	gdouble _tmp146_;
	gdouble _tmp147_;
	gdouble _tmp148_;
	gdouble _tmp149_;
	gdouble _tmp150_;
	gdouble _tmp151_;
	NibblesViewPoint3D _tmp152_ = {0};
	gdouble _tmp153_ = 0.0;
	gdouble _tmp154_ = 0.0;
	NibblesViewPoint3D _tmp155_ = {0};
	gdouble _tmp156_ = 0.0;
	gdouble _tmp157_ = 0.0;
	NibblesViewPoint3D _tmp158_ = {0};
	gdouble _tmp159_ = 0.0;
	gdouble _tmp160_ = 0.0;
	gdouble _tmp161_;
	gdouble _tmp162_;
	gdouble _tmp163_;
	gdouble _tmp164_;
	gdouble _tmp165_;
	gdouble _tmp166_;
	GskPath* _tmp167_;
	GskPath* _tmp168_;
	GdkRGBA _tmp169_ = {0};
	GskPathBuilder* path = NULL;
	GskPathBuilder* _tmp170_;
	NibblesViewPoint3D _tmp171_ = {0};
	gdouble _tmp172_ = 0.0;
	gdouble _tmp173_ = 0.0;
	gdouble _tmp174_;
	gdouble _tmp175_;
	NibblesViewPoint3D _tmp176_ = {0};
	gdouble _tmp177_ = 0.0;
	gdouble _tmp178_ = 0.0;
	gdouble _tmp179_;
	gdouble _tmp180_;
	NibblesViewPoint3D _tmp181_ = {0};
	gdouble _tmp182_ = 0.0;
	gdouble _tmp183_ = 0.0;
	gdouble _tmp184_;
	gdouble _tmp185_;
	NibblesViewPoint3D _tmp186_ = {0};
	gdouble _tmp187_ = 0.0;
	gdouble _tmp188_ = 0.0;
	gdouble _tmp189_;
	gdouble _tmp190_;
	GskPath* _tmp191_;
	GskPath* _tmp192_;
	GdkRGBA _tmp193_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	g_return_if_fail (v != NULL);
	_tmp0_ = gsk_path_builder_new ();
	dark_side = _tmp0_;
	_tmp1_.x = x + 0;
	_tmp1_.y = (y + 1) + 0.25;
	_tmp1_.z = (gdouble) 1;
	nibbles_view_view3_d_to_view_plain (v, &_tmp1_, &_tmp2_, &_tmp3_);
	cx[0] = _tmp2_;
	cy[0] = _tmp3_;
	_tmp4_.x = x + 0;
	_tmp4_.y = (y + 1) + 0.25;
	_tmp4_.z = (gdouble) 0;
	nibbles_view_view3_d_to_view_plain (v, &_tmp4_, &_tmp5_, &_tmp6_);
	cx[1] = _tmp5_;
	cy[1] = _tmp6_;
	_tmp7_.x = x + 1;
	_tmp7_.y = (y + 1) + 0.25;
	_tmp7_.z = (gdouble) 0;
	nibbles_view_view3_d_to_view_plain (v, &_tmp7_, &_tmp8_, &_tmp9_);
	cx[2] = _tmp8_;
	cy[2] = _tmp9_;
	_tmp10_ = cx[0];
	_tmp11_ = cy[0];
	gsk_path_builder_move_to (dark_side, (gfloat) _tmp10_, (gfloat) _tmp11_);
	_tmp12_ = cx[0];
	_tmp13_ = cy[0];
	_tmp14_ = cx[1];
	_tmp15_ = cy[1];
	_tmp16_ = cx[2];
	_tmp17_ = cy[2];
	gsk_path_builder_cubic_to (dark_side, (gfloat) _tmp12_, (gfloat) _tmp13_, (gfloat) _tmp14_, (gfloat) _tmp15_, (gfloat) _tmp16_, (gfloat) _tmp17_);
	_tmp18_.x = x + 1;
	_tmp18_.y = (y + 1) + 0.25;
	_tmp18_.z = (gdouble) 0;
	nibbles_view_view3_d_to_view_plain (v, &_tmp18_, &_tmp19_, &_tmp20_);
	cx[0] = _tmp19_;
	cy[0] = _tmp20_;
	_tmp21_.x = x + 2;
	_tmp21_.y = (y + 1) + 0.25;
	_tmp21_.z = (gdouble) 0;
	nibbles_view_view3_d_to_view_plain (v, &_tmp21_, &_tmp22_, &_tmp23_);
	cx[1] = _tmp22_;
	cy[1] = _tmp23_;
	_tmp24_.x = x + 2;
	_tmp24_.y = (y + 1) + 0.25;
	_tmp24_.z = (gdouble) 1;
	nibbles_view_view3_d_to_view_plain (v, &_tmp24_, &_tmp25_, &_tmp26_);
	cx[2] = _tmp25_;
	cy[2] = _tmp26_;
	_tmp27_ = cx[0];
	_tmp28_ = cy[0];
	_tmp29_ = cx[1];
	_tmp30_ = cy[1];
	_tmp31_ = cx[2];
	_tmp32_ = cy[2];
	gsk_path_builder_cubic_to (dark_side, (gfloat) _tmp27_, (gfloat) _tmp28_, (gfloat) _tmp29_, (gfloat) _tmp30_, (gfloat) _tmp31_, (gfloat) _tmp32_);
	_tmp33_.x = (x + 2) - 0.1;
	_tmp33_.y = (y + 1) + 0.25;
	_tmp33_.z = 1 + 0.5;
	nibbles_view_view3_d_to_view_plain (v, &_tmp33_, &_tmp34_, &_tmp35_);
	cx[0] = _tmp34_;
	cy[0] = _tmp35_;
	_tmp36_ = cx[0];
	_tmp37_ = cy[0];
	gsk_path_builder_line_to (dark_side, (gfloat) _tmp36_, (gfloat) _tmp37_);
	_tmp38_.x = (x + 2) - 0.2;
	_tmp38_.y = (y + 1) + 0.25;
	_tmp38_.z = 1 + 0.5;
	nibbles_view_view3_d_to_view_plain (v, &_tmp38_, &_tmp39_, &_tmp40_);
	cx[0] = _tmp39_;
	cy[0] = _tmp40_;
	_tmp41_ = cx[0];
	_tmp42_ = cy[0];
	gsk_path_builder_line_to (dark_side, (gfloat) _tmp41_, (gfloat) _tmp42_);
	_tmp43_.x = (x + 2) - 0.2;
	_tmp43_.y = (y + 1) + 0.25;
	_tmp43_.z = 1 + 0.5;
	nibbles_view_view3_d_to_view_plain (v, &_tmp43_, &_tmp44_, &_tmp45_);
	cx[0] = _tmp44_;
	cy[0] = _tmp45_;
	_tmp46_.x = (x + 2) - 0.2;
	_tmp46_.y = (y + 1) + 0.25;
	_tmp46_.z = 0.5;
	nibbles_view_view3_d_to_view_plain (v, &_tmp46_, &_tmp47_, &_tmp48_);
	cx[1] = _tmp47_;
	cy[1] = _tmp48_;
	_tmp49_.x = x + 1;
	_tmp49_.y = (y + 1) + 0.25;
	_tmp49_.z = 0.5;
	nibbles_view_view3_d_to_view_plain (v, &_tmp49_, &_tmp50_, &_tmp51_);
	cx[2] = _tmp50_;
	cy[2] = _tmp51_;
	_tmp52_ = cx[0];
	_tmp53_ = cy[0];
	_tmp54_ = cx[1];
	_tmp55_ = cy[1];
	_tmp56_ = cx[2];
	_tmp57_ = cy[2];
	gsk_path_builder_cubic_to (dark_side, (gfloat) _tmp52_, (gfloat) _tmp53_, (gfloat) _tmp54_, (gfloat) _tmp55_, (gfloat) _tmp56_, (gfloat) _tmp57_);
	_tmp58_.x = x + 1;
	_tmp58_.y = (y + 1) + 0.25;
	_tmp58_.z = 0.5;
	nibbles_view_view3_d_to_view_plain (v, &_tmp58_, &_tmp59_, &_tmp60_);
	cx[0] = _tmp59_;
	cy[0] = _tmp60_;
	_tmp61_.x = x + 0.2;
	_tmp61_.y = (y + 1) + 0.25;
	_tmp61_.z = 0.5;
	nibbles_view_view3_d_to_view_plain (v, &_tmp61_, &_tmp62_, &_tmp63_);
	cx[1] = _tmp62_;
	cy[1] = _tmp63_;
	_tmp64_.x = x + 0.1;
	_tmp64_.y = (y + 1) + 0.25;
	_tmp64_.z = 1 + 0.1;
	nibbles_view_view3_d_to_view_plain (v, &_tmp64_, &_tmp65_, &_tmp66_);
	cx[2] = _tmp65_;
	cy[2] = _tmp66_;
	_tmp67_ = cx[0];
	_tmp68_ = cy[0];
	_tmp69_ = cx[1];
	_tmp70_ = cy[1];
	_tmp71_ = cx[2];
	_tmp72_ = cy[2];
	gsk_path_builder_cubic_to (dark_side, (gfloat) _tmp67_, (gfloat) _tmp68_, (gfloat) _tmp69_, (gfloat) _tmp70_, (gfloat) _tmp71_, (gfloat) _tmp72_);
	_tmp73_ = gsk_path_builder_to_path (dark_side);
	_tmp74_ = _tmp73_;
	_tmp75_.red = 0.6f;
	_tmp75_.green = 0.6f;
	_tmp75_.blue = 0.0f;
	_tmp75_.alpha = 1.0f;
	gtk_snapshot_append_fill (s, _tmp74_, GSK_FILL_RULE_EVEN_ODD, &_tmp75_);
	_gsk_path_unref0 (_tmp74_);
	_tmp76_ = gsk_path_builder_new ();
	light_side = _tmp76_;
	_tmp77_.x = x + 0.1;
	_tmp77_.y = (y + 1) + 0.25;
	_tmp77_.z = 1 + 0.1;
	nibbles_view_view3_d_to_view_plain (v, &_tmp77_, &_tmp78_, &_tmp79_);
	cx[0] = _tmp78_;
	cy[0] = _tmp79_;
	_tmp80_ = cx[0];
	_tmp81_ = cy[0];
	gsk_path_builder_move_to (light_side, (gfloat) _tmp80_, (gfloat) _tmp81_);
	_tmp82_.x = x + 0.1;
	_tmp82_.y = (y + 1) + 0.15;
	_tmp82_.z = 1 + 0.1;
	nibbles_view_view3_d_to_view_plain (v, &_tmp82_, &_tmp83_, &_tmp84_);
	cx[0] = _tmp83_;
	cy[0] = _tmp84_;
	_tmp85_ = cx[0];
	_tmp86_ = cy[0];
	gsk_path_builder_line_to (light_side, (gfloat) _tmp85_, (gfloat) _tmp86_);
	_tmp87_.x = x + 0.1;
	_tmp87_.y = (y + 1) + 0.15;
	_tmp87_.z = 1 + 0.1;
	nibbles_view_view3_d_to_view_plain (v, &_tmp87_, &_tmp88_, &_tmp89_);
	cx[0] = _tmp88_;
	cy[0] = _tmp89_;
	_tmp90_.x = x + 0.2;
	_tmp90_.y = (y + 1) + 0.15;
	_tmp90_.z = 0.5;
	nibbles_view_view3_d_to_view_plain (v, &_tmp90_, &_tmp91_, &_tmp92_);
	cx[1] = _tmp91_;
	cy[1] = _tmp92_;
	_tmp93_.x = x + 1;
	_tmp93_.y = (y + 1) + 0.15;
	_tmp93_.z = 0.5;
	nibbles_view_view3_d_to_view_plain (v, &_tmp93_, &_tmp94_, &_tmp95_);
	cx[2] = _tmp94_;
	cy[2] = _tmp95_;
	_tmp96_ = cx[0];
	_tmp97_ = cy[0];
	_tmp98_ = cx[1];
	_tmp99_ = cy[1];
	_tmp100_ = cx[2];
	_tmp101_ = cy[2];
	gsk_path_builder_cubic_to (light_side, (gfloat) _tmp96_, (gfloat) _tmp97_, (gfloat) _tmp98_, (gfloat) _tmp99_, (gfloat) _tmp100_, (gfloat) _tmp101_);
	_tmp102_.x = x + 1;
	_tmp102_.y = (y + 1) + 0.15;
	_tmp102_.z = 0.5;
	nibbles_view_view3_d_to_view_plain (v, &_tmp102_, &_tmp103_, &_tmp104_);
	cx[0] = _tmp103_;
	cy[0] = _tmp104_;
	_tmp105_.x = (x + 2) - 0.2;
	_tmp105_.y = (y + 1) + 0.15;
	_tmp105_.z = 0.5;
	nibbles_view_view3_d_to_view_plain (v, &_tmp105_, &_tmp106_, &_tmp107_);
	cx[1] = _tmp106_;
	cy[1] = _tmp107_;
	_tmp108_.x = (x + 2) - 0.2;
	_tmp108_.y = (y + 1) + 0.15;
	_tmp108_.z = 1 + 0.5;
	nibbles_view_view3_d_to_view_plain (v, &_tmp108_, &_tmp109_, &_tmp110_);
	cx[2] = _tmp109_;
	cy[2] = _tmp110_;
	_tmp111_ = cx[0];
	_tmp112_ = cy[0];
	_tmp113_ = cx[1];
	_tmp114_ = cy[1];
	_tmp115_ = cx[2];
	_tmp116_ = cy[2];
	gsk_path_builder_cubic_to (light_side, (gfloat) _tmp111_, (gfloat) _tmp112_, (gfloat) _tmp113_, (gfloat) _tmp114_, (gfloat) _tmp115_, (gfloat) _tmp116_);
	_tmp117_.x = (x + 2) - 0.2;
	_tmp117_.y = (y + 1) + 0.15;
	_tmp117_.z = 1 + 0.5;
	nibbles_view_view3_d_to_view_plain (v, &_tmp117_, &_tmp118_, &_tmp119_);
	cx[0] = _tmp118_;
	cy[0] = _tmp119_;
	_tmp120_ = cx[0];
	_tmp121_ = cy[0];
	gsk_path_builder_line_to (light_side, (gfloat) _tmp120_, (gfloat) _tmp121_);
	_tmp122_.x = (x + 2) - 0.1;
	_tmp122_.y = (y + 1) + 0.15;
	_tmp122_.z = 1 + 0.5;
	nibbles_view_view3_d_to_view_plain (v, &_tmp122_, &_tmp123_, &_tmp124_);
	cx[0] = _tmp123_;
	cy[0] = _tmp124_;
	_tmp125_ = cx[0];
	_tmp126_ = cy[0];
	gsk_path_builder_line_to (light_side, (gfloat) _tmp125_, (gfloat) _tmp126_);
	_tmp127_.x = (x + 2) - 0.1;
	_tmp127_.y = (y + 1) + 0.25;
	_tmp127_.z = 1 + 0.5;
	nibbles_view_view3_d_to_view_plain (v, &_tmp127_, &_tmp128_, &_tmp129_);
	cx[0] = _tmp128_;
	cy[0] = _tmp129_;
	_tmp130_ = cx[0];
	_tmp131_ = cy[0];
	gsk_path_builder_line_to (light_side, (gfloat) _tmp130_, (gfloat) _tmp131_);
	_tmp132_.x = (x + 2) - 0.2;
	_tmp132_.y = (y + 1) + 0.25;
	_tmp132_.z = 1 + 0.5;
	nibbles_view_view3_d_to_view_plain (v, &_tmp132_, &_tmp133_, &_tmp134_);
	cx[0] = _tmp133_;
	cy[0] = _tmp134_;
	_tmp135_ = cx[0];
	_tmp136_ = cy[0];
	gsk_path_builder_line_to (light_side, (gfloat) _tmp135_, (gfloat) _tmp136_);
	_tmp137_.x = (x + 2) - 0.2;
	_tmp137_.y = (y + 1) + 0.25;
	_tmp137_.z = 1 + 0.5;
	nibbles_view_view3_d_to_view_plain (v, &_tmp137_, &_tmp138_, &_tmp139_);
	cx[0] = _tmp138_;
	cy[0] = _tmp139_;
	_tmp140_.x = (x + 2) - 0.2;
	_tmp140_.y = (y + 1) + 0.25;
	_tmp140_.z = 0.5;
	nibbles_view_view3_d_to_view_plain (v, &_tmp140_, &_tmp141_, &_tmp142_);
	cx[1] = _tmp141_;
	cy[1] = _tmp142_;
	_tmp143_.x = x + 1;
	_tmp143_.y = (y + 1) + 0.25;
	_tmp143_.z = 0.5;
	nibbles_view_view3_d_to_view_plain (v, &_tmp143_, &_tmp144_, &_tmp145_);
	cx[2] = _tmp144_;
	cy[2] = _tmp145_;
	_tmp146_ = cx[0];
	_tmp147_ = cy[0];
	_tmp148_ = cx[1];
	_tmp149_ = cy[1];
	_tmp150_ = cx[2];
	_tmp151_ = cy[2];
	gsk_path_builder_cubic_to (light_side, (gfloat) _tmp146_, (gfloat) _tmp147_, (gfloat) _tmp148_, (gfloat) _tmp149_, (gfloat) _tmp150_, (gfloat) _tmp151_);
	_tmp152_.x = x + 1;
	_tmp152_.y = (y + 1) + 0.25;
	_tmp152_.z = 0.5;
	nibbles_view_view3_d_to_view_plain (v, &_tmp152_, &_tmp153_, &_tmp154_);
	cx[0] = _tmp153_;
	cy[0] = _tmp154_;
	_tmp155_.x = x + 0.2;
	_tmp155_.y = (y + 1) + 0.25;
	_tmp155_.z = 0.5;
	nibbles_view_view3_d_to_view_plain (v, &_tmp155_, &_tmp156_, &_tmp157_);
	cx[1] = _tmp156_;
	cy[1] = _tmp157_;
	_tmp158_.x = x + 0.1;
	_tmp158_.y = (y + 1) + 0.25;
	_tmp158_.z = 1 + 0.1;
	nibbles_view_view3_d_to_view_plain (v, &_tmp158_, &_tmp159_, &_tmp160_);
	cx[2] = _tmp159_;
	cy[2] = _tmp160_;
	_tmp161_ = cx[0];
	_tmp162_ = cy[0];
	_tmp163_ = cx[1];
	_tmp164_ = cy[1];
	_tmp165_ = cx[2];
	_tmp166_ = cy[2];
	gsk_path_builder_cubic_to (light_side, (gfloat) _tmp161_, (gfloat) _tmp162_, (gfloat) _tmp163_, (gfloat) _tmp164_, (gfloat) _tmp165_, (gfloat) _tmp166_);
	_tmp167_ = gsk_path_builder_to_path (light_side);
	_tmp168_ = _tmp167_;
	_tmp169_.red = 0.8f;
	_tmp169_.green = 0.8f;
	_tmp169_.blue = 0.0f;
	_tmp169_.alpha = 1.0f;
	gtk_snapshot_append_fill (s, _tmp168_, GSK_FILL_RULE_EVEN_ODD, &_tmp169_);
	_gsk_path_unref0 (_tmp168_);
	_tmp170_ = gsk_path_builder_new ();
	path = _tmp170_;
	_tmp171_.x = x + 0;
	_tmp171_.y = (y + 1) + 0.25;
	_tmp171_.z = (gdouble) 1;
	nibbles_view_view3_d_to_view_plain (v, &_tmp171_, &_tmp172_, &_tmp173_);
	cx[0] = _tmp172_;
	cy[0] = _tmp173_;
	_tmp174_ = cx[0];
	_tmp175_ = cy[0];
	gsk_path_builder_move_to (path, (gfloat) _tmp174_, (gfloat) _tmp175_);
	_tmp176_.x = x + 0.1;
	_tmp176_.y = (y + 1) + 0.25;
	_tmp176_.z = 1 + 0.1;
	nibbles_view_view3_d_to_view_plain (v, &_tmp176_, &_tmp177_, &_tmp178_);
	cx[0] = _tmp177_;
	cy[0] = _tmp178_;
	_tmp179_ = cx[0];
	_tmp180_ = cy[0];
	gsk_path_builder_line_to (path, (gfloat) _tmp179_, (gfloat) _tmp180_);
	_tmp181_.x = x + 0.1;
	_tmp181_.y = (y + 1) + 0.15;
	_tmp181_.z = 1 + 0.1;
	nibbles_view_view3_d_to_view_plain (v, &_tmp181_, &_tmp182_, &_tmp183_);
	cx[0] = _tmp182_;
	cy[0] = _tmp183_;
	_tmp184_ = cx[0];
	_tmp185_ = cy[0];
	gsk_path_builder_line_to (path, (gfloat) _tmp184_, (gfloat) _tmp185_);
	_tmp186_.x = x + 0;
	_tmp186_.y = (y + 1) + 0.15;
	_tmp186_.z = (gdouble) 1;
	nibbles_view_view3_d_to_view_plain (v, &_tmp186_, &_tmp187_, &_tmp188_);
	cx[0] = _tmp187_;
	cy[0] = _tmp188_;
	_tmp189_ = cx[0];
	_tmp190_ = cy[0];
	gsk_path_builder_line_to (path, (gfloat) _tmp189_, (gfloat) _tmp190_);
	_tmp191_ = gsk_path_builder_to_path (path);
	_tmp192_ = _tmp191_;
	_tmp193_.red = 0.3f;
	_tmp193_.green = 0.3f;
	_tmp193_.blue = 0.4f;
	_tmp193_.alpha = 1.0f;
	gtk_snapshot_append_fill (s, _tmp192_, GSK_FILL_RULE_EVEN_ODD, &_tmp193_);
	_gsk_path_unref0 (_tmp192_);
	_gsk_path_builder_unref0 (path);
	_gsk_path_builder_unref0 (light_side);
	_gsk_path_builder_unref0 (dark_side);
}

static void
nibbles_view_draw_diamond (NibblesView* self,
                           GtkSnapshot* s,
                           NibblesViewView3D* v,
                           gdouble x,
                           gdouble y)
{
	static const gdouble cos60 = 0.5;
	static const gdouble sin60 = 0.866025403784;
	NibblesViewPoint3D top[6] = {0};
	NibblesViewPoint3D _tmp0_ = {0};
	NibblesViewPoint3D _tmp1_ = {0};
	NibblesViewPoint3D _tmp2_ = {0};
	NibblesViewPoint3D _tmp3_ = {0};
	NibblesViewPoint3D _tmp4_ = {0};
	NibblesViewPoint3D _tmp5_ = {0};
	NibblesViewPoint3D _tmp6_[6] = {0};
	NibblesViewPoint3D middle[6] = {0};
	NibblesViewPoint3D _tmp7_ = {0};
	NibblesViewPoint3D _tmp8_ = {0};
	NibblesViewPoint3D _tmp9_ = {0};
	NibblesViewPoint3D _tmp10_ = {0};
	NibblesViewPoint3D _tmp11_ = {0};
	NibblesViewPoint3D _tmp12_ = {0};
	NibblesViewPoint3D _tmp13_[6] = {0};
	gdouble X = 0.0;
	gdouble Y = 0.0;
	GskPathBuilder* p0 = NULL;
	GskPathBuilder* _tmp14_;
	NibblesViewPoint3D _tmp15_;
	gdouble _tmp16_ = 0.0;
	gdouble _tmp17_ = 0.0;
	NibblesViewPoint3D _tmp18_;
	gdouble _tmp19_ = 0.0;
	gdouble _tmp20_ = 0.0;
	NibblesViewPoint3D _tmp21_;
	gdouble _tmp22_ = 0.0;
	gdouble _tmp23_ = 0.0;
	NibblesViewPoint3D _tmp24_;
	gdouble _tmp25_ = 0.0;
	gdouble _tmp26_ = 0.0;
	NibblesViewPoint3D _tmp27_;
	gdouble _tmp28_ = 0.0;
	gdouble _tmp29_ = 0.0;
	NibblesViewPoint3D _tmp30_;
	gdouble _tmp31_ = 0.0;
	gdouble _tmp32_ = 0.0;
	GskPath* _tmp33_;
	GskPath* _tmp34_;
	GdkRGBA _tmp35_ = {0};
	GskPathBuilder* p1 = NULL;
	GskPathBuilder* _tmp36_;
	NibblesViewPoint3D _tmp37_;
	gdouble _tmp38_ = 0.0;
	gdouble _tmp39_ = 0.0;
	NibblesViewPoint3D _tmp40_;
	gdouble _tmp41_ = 0.0;
	gdouble _tmp42_ = 0.0;
	NibblesViewPoint3D _tmp43_;
	gdouble _tmp44_ = 0.0;
	gdouble _tmp45_ = 0.0;
	NibblesViewPoint3D _tmp46_;
	gdouble _tmp47_ = 0.0;
	gdouble _tmp48_ = 0.0;
	GskPath* _tmp49_;
	GskPath* _tmp50_;
	GdkRGBA _tmp51_ = {0};
	GskPathBuilder* p2 = NULL;
	GskPathBuilder* _tmp52_;
	NibblesViewPoint3D _tmp53_;
	gdouble _tmp54_ = 0.0;
	gdouble _tmp55_ = 0.0;
	NibblesViewPoint3D _tmp56_;
	gdouble _tmp57_ = 0.0;
	gdouble _tmp58_ = 0.0;
	NibblesViewPoint3D _tmp59_;
	gdouble _tmp60_ = 0.0;
	gdouble _tmp61_ = 0.0;
	NibblesViewPoint3D _tmp62_;
	gdouble _tmp63_ = 0.0;
	gdouble _tmp64_ = 0.0;
	GskPath* _tmp65_;
	GskPath* _tmp66_;
	GdkRGBA _tmp67_ = {0};
	GskPathBuilder* p3 = NULL;
	GskPathBuilder* _tmp68_;
	NibblesViewPoint3D _tmp69_;
	gdouble _tmp70_ = 0.0;
	gdouble _tmp71_ = 0.0;
	NibblesViewPoint3D _tmp72_;
	gdouble _tmp73_ = 0.0;
	gdouble _tmp74_ = 0.0;
	NibblesViewPoint3D _tmp75_;
	gdouble _tmp76_ = 0.0;
	gdouble _tmp77_ = 0.0;
	NibblesViewPoint3D _tmp78_;
	gdouble _tmp79_ = 0.0;
	gdouble _tmp80_ = 0.0;
	GskPath* _tmp81_;
	GskPath* _tmp82_;
	GdkRGBA _tmp83_ = {0};
	GskPathBuilder* p4 = NULL;
	GskPathBuilder* _tmp84_;
	NibblesViewPoint3D _tmp85_;
	gdouble _tmp86_ = 0.0;
	gdouble _tmp87_ = 0.0;
	NibblesViewPoint3D _tmp88_;
	gdouble _tmp89_ = 0.0;
	gdouble _tmp90_ = 0.0;
	NibblesViewPoint3D _tmp91_;
	gdouble _tmp92_ = 0.0;
	gdouble _tmp93_ = 0.0;
	NibblesViewPoint3D _tmp94_;
	gdouble _tmp95_ = 0.0;
	gdouble _tmp96_ = 0.0;
	GskPath* _tmp97_;
	GskPath* _tmp98_;
	GdkRGBA _tmp99_ = {0};
	GskPathBuilder* p5 = NULL;
	GskPathBuilder* _tmp100_;
	NibblesViewPoint3D _tmp101_;
	gdouble _tmp102_ = 0.0;
	gdouble _tmp103_ = 0.0;
	NibblesViewPoint3D _tmp104_;
	gdouble _tmp105_ = 0.0;
	gdouble _tmp106_ = 0.0;
	NibblesViewPoint3D _tmp107_;
	gdouble _tmp108_ = 0.0;
	gdouble _tmp109_ = 0.0;
	NibblesViewPoint3D _tmp110_;
	gdouble _tmp111_ = 0.0;
	gdouble _tmp112_ = 0.0;
	GskPath* _tmp113_;
	GskPath* _tmp114_;
	GdkRGBA _tmp115_ = {0};
	GskPathBuilder* p6 = NULL;
	GskPathBuilder* _tmp116_;
	NibblesViewPoint3D _tmp117_;
	gdouble _tmp118_ = 0.0;
	gdouble _tmp119_ = 0.0;
	NibblesViewPoint3D _tmp120_;
	gdouble _tmp121_ = 0.0;
	gdouble _tmp122_ = 0.0;
	NibblesViewPoint3D _tmp123_;
	gdouble _tmp124_ = 0.0;
	gdouble _tmp125_ = 0.0;
	NibblesViewPoint3D _tmp126_;
	gdouble _tmp127_ = 0.0;
	gdouble _tmp128_ = 0.0;
	GskPath* _tmp129_;
	GskPath* _tmp130_;
	GdkRGBA _tmp131_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	g_return_if_fail (v != NULL);
	memset (&_tmp0_, 0, sizeof (NibblesViewPoint3D));
	_tmp0_.x = x + 0;
	_tmp0_.y = y + 1;
	_tmp0_.z = 1.5;
	memset (&_tmp1_, 0, sizeof (NibblesViewPoint3D));
	_tmp1_.x = x + cos60;
	_tmp1_.y = (y + 1.0) - sin60;
	_tmp1_.z = 1.5;
	memset (&_tmp2_, 0, sizeof (NibblesViewPoint3D));
	_tmp2_.x = (x + cos60) + 1;
	_tmp2_.y = (y + 1.0) - sin60;
	_tmp2_.z = 1.5;
	memset (&_tmp3_, 0, sizeof (NibblesViewPoint3D));
	_tmp3_.x = x + 2;
	_tmp3_.y = y + 1;
	_tmp3_.z = 1.5;
	memset (&_tmp4_, 0, sizeof (NibblesViewPoint3D));
	_tmp4_.x = (x + cos60) + 1;
	_tmp4_.y = (y + 1.0) + sin60;
	_tmp4_.z = 1.5;
	memset (&_tmp5_, 0, sizeof (NibblesViewPoint3D));
	_tmp5_.x = x + cos60;
	_tmp5_.y = (y + 1.0) + sin60;
	_tmp5_.z = 1.5;
	_tmp6_[0] = _tmp0_;
	_tmp6_[1] = _tmp1_;
	_tmp6_[2] = _tmp2_;
	_tmp6_[3] = _tmp3_;
	_tmp6_[4] = _tmp4_;
	_tmp6_[5] = _tmp5_;
	memcpy (top, _tmp6_, 6 * sizeof (NibblesViewPoint3D));
	memset (&_tmp7_, 0, sizeof (NibblesViewPoint3D));
	_tmp7_.x = x + 0.5;
	_tmp7_.y = y + 1;
	_tmp7_.z = (gdouble) 2;
	memset (&_tmp8_, 0, sizeof (NibblesViewPoint3D));
	_tmp8_.x = x + (1.0 - (0.5 * cos60));
	_tmp8_.y = (y + 1.0) - (0.5 * sin60);
	_tmp8_.z = (gdouble) 2;
	memset (&_tmp9_, 0, sizeof (NibblesViewPoint3D));
	_tmp9_.x = (x + (0.5 * cos60)) + 1;
	_tmp9_.y = (y + 1.0) - (0.5 * sin60);
	_tmp9_.z = (gdouble) 2;
	memset (&_tmp10_, 0, sizeof (NibblesViewPoint3D));
	_tmp10_.x = x + 1.5;
	_tmp10_.y = y + 1;
	_tmp10_.z = (gdouble) 2;
	memset (&_tmp11_, 0, sizeof (NibblesViewPoint3D));
	_tmp11_.x = (x + (0.5 * cos60)) + 1;
	_tmp11_.y = (y + 1.0) + (0.5 * sin60);
	_tmp11_.z = (gdouble) 2;
	memset (&_tmp12_, 0, sizeof (NibblesViewPoint3D));
	_tmp12_.x = x + (1.0 - (0.5 * cos60));
	_tmp12_.y = (y + 1.0) + (0.5 * sin60);
	_tmp12_.z = (gdouble) 2;
	_tmp13_[0] = _tmp7_;
	_tmp13_[1] = _tmp8_;
	_tmp13_[2] = _tmp9_;
	_tmp13_[3] = _tmp10_;
	_tmp13_[4] = _tmp11_;
	_tmp13_[5] = _tmp12_;
	memcpy (middle, _tmp13_, 6 * sizeof (NibblesViewPoint3D));
	_tmp14_ = gsk_path_builder_new ();
	p0 = _tmp14_;
	_tmp15_ = top[0];
	nibbles_view_view3_d_to_view_plain (v, &_tmp15_, &_tmp16_, &_tmp17_);
	X = _tmp16_;
	Y = _tmp17_;
	gsk_path_builder_move_to (p0, (gfloat) X, (gfloat) Y);
	_tmp18_ = top[1];
	nibbles_view_view3_d_to_view_plain (v, &_tmp18_, &_tmp19_, &_tmp20_);
	X = _tmp19_;
	Y = _tmp20_;
	gsk_path_builder_line_to (p0, (gfloat) X, (gfloat) Y);
	_tmp21_ = top[2];
	nibbles_view_view3_d_to_view_plain (v, &_tmp21_, &_tmp22_, &_tmp23_);
	X = _tmp22_;
	Y = _tmp23_;
	gsk_path_builder_line_to (p0, (gfloat) X, (gfloat) Y);
	_tmp24_ = top[3];
	nibbles_view_view3_d_to_view_plain (v, &_tmp24_, &_tmp25_, &_tmp26_);
	X = _tmp25_;
	Y = _tmp26_;
	gsk_path_builder_line_to (p0, (gfloat) X, (gfloat) Y);
	_tmp27_ = top[4];
	nibbles_view_view3_d_to_view_plain (v, &_tmp27_, &_tmp28_, &_tmp29_);
	X = _tmp28_;
	Y = _tmp29_;
	gsk_path_builder_line_to (p0, (gfloat) X, (gfloat) Y);
	_tmp30_ = top[5];
	nibbles_view_view3_d_to_view_plain (v, &_tmp30_, &_tmp31_, &_tmp32_);
	X = _tmp31_;
	Y = _tmp32_;
	gsk_path_builder_line_to (p0, (gfloat) X, (gfloat) Y);
	_tmp33_ = gsk_path_builder_to_path (p0);
	_tmp34_ = _tmp33_;
	_tmp35_.red = 0.8f;
	_tmp35_.green = 0.9f;
	_tmp35_.blue = 1.0f;
	_tmp35_.alpha = 1.0f;
	gtk_snapshot_append_fill (s, _tmp34_, GSK_FILL_RULE_EVEN_ODD, &_tmp35_);
	_gsk_path_unref0 (_tmp34_);
	_tmp36_ = gsk_path_builder_new ();
	p1 = _tmp36_;
	_tmp37_ = middle[1];
	nibbles_view_view3_d_to_view_plain (v, &_tmp37_, &_tmp38_, &_tmp39_);
	X = _tmp38_;
	Y = _tmp39_;
	gsk_path_builder_move_to (p1, (gfloat) X, (gfloat) Y);
	_tmp40_ = middle[2];
	nibbles_view_view3_d_to_view_plain (v, &_tmp40_, &_tmp41_, &_tmp42_);
	X = _tmp41_;
	Y = _tmp42_;
	gsk_path_builder_line_to (p1, (gfloat) X, (gfloat) Y);
	_tmp43_ = top[2];
	nibbles_view_view3_d_to_view_plain (v, &_tmp43_, &_tmp44_, &_tmp45_);
	X = _tmp44_;
	Y = _tmp45_;
	gsk_path_builder_line_to (p1, (gfloat) X, (gfloat) Y);
	_tmp46_ = top[1];
	nibbles_view_view3_d_to_view_plain (v, &_tmp46_, &_tmp47_, &_tmp48_);
	X = _tmp47_;
	Y = _tmp48_;
	gsk_path_builder_line_to (p1, (gfloat) X, (gfloat) Y);
	_tmp49_ = gsk_path_builder_to_path (p1);
	_tmp50_ = _tmp49_;
	_tmp51_.red = 0.618f;
	_tmp51_.green = 0.708f;
	_tmp51_.blue = 0.802f;
	_tmp51_.alpha = 1.0f;
	gtk_snapshot_append_fill (s, _tmp50_, GSK_FILL_RULE_EVEN_ODD, &_tmp51_);
	_gsk_path_unref0 (_tmp50_);
	_tmp52_ = gsk_path_builder_new ();
	p2 = _tmp52_;
	_tmp53_ = middle[1];
	nibbles_view_view3_d_to_view_plain (v, &_tmp53_, &_tmp54_, &_tmp55_);
	X = _tmp54_;
	Y = _tmp55_;
	gsk_path_builder_move_to (p2, (gfloat) X, (gfloat) Y);
	_tmp56_ = middle[0];
	nibbles_view_view3_d_to_view_plain (v, &_tmp56_, &_tmp57_, &_tmp58_);
	X = _tmp57_;
	Y = _tmp58_;
	gsk_path_builder_line_to (p2, (gfloat) X, (gfloat) Y);
	_tmp59_ = top[0];
	nibbles_view_view3_d_to_view_plain (v, &_tmp59_, &_tmp60_, &_tmp61_);
	X = _tmp60_;
	Y = _tmp61_;
	gsk_path_builder_line_to (p2, (gfloat) X, (gfloat) Y);
	_tmp62_ = top[1];
	nibbles_view_view3_d_to_view_plain (v, &_tmp62_, &_tmp63_, &_tmp64_);
	X = _tmp63_;
	Y = _tmp64_;
	gsk_path_builder_line_to (p2, (gfloat) X, (gfloat) Y);
	_tmp65_ = gsk_path_builder_to_path (p2);
	_tmp66_ = _tmp65_;
	_tmp67_.red = 0.347f;
	_tmp67_.green = 0.524f;
	_tmp67_.blue = 0.712f;
	_tmp67_.alpha = 1.0f;
	gtk_snapshot_append_fill (s, _tmp66_, GSK_FILL_RULE_EVEN_ODD, &_tmp67_);
	_gsk_path_unref0 (_tmp66_);
	_tmp68_ = gsk_path_builder_new ();
	p3 = _tmp68_;
	_tmp69_ = middle[2];
	nibbles_view_view3_d_to_view_plain (v, &_tmp69_, &_tmp70_, &_tmp71_);
	X = _tmp70_;
	Y = _tmp71_;
	gsk_path_builder_move_to (p3, (gfloat) X, (gfloat) Y);
	_tmp72_ = middle[3];
	nibbles_view_view3_d_to_view_plain (v, &_tmp72_, &_tmp73_, &_tmp74_);
	X = _tmp73_;
	Y = _tmp74_;
	gsk_path_builder_line_to (p3, (gfloat) X, (gfloat) Y);
	_tmp75_ = top[3];
	nibbles_view_view3_d_to_view_plain (v, &_tmp75_, &_tmp76_, &_tmp77_);
	X = _tmp76_;
	Y = _tmp77_;
	gsk_path_builder_line_to (p3, (gfloat) X, (gfloat) Y);
	_tmp78_ = top[2];
	nibbles_view_view3_d_to_view_plain (v, &_tmp78_, &_tmp79_, &_tmp80_);
	X = _tmp79_;
	Y = _tmp80_;
	gsk_path_builder_line_to (p3, (gfloat) X, (gfloat) Y);
	_tmp81_ = gsk_path_builder_to_path (p3);
	_tmp82_ = _tmp81_;
	_tmp83_.red = 0.347f;
	_tmp83_.green = 0.524f;
	_tmp83_.blue = 0.712f;
	_tmp83_.alpha = 1.0f;
	gtk_snapshot_append_fill (s, _tmp82_, GSK_FILL_RULE_EVEN_ODD, &_tmp83_);
	_gsk_path_unref0 (_tmp82_);
	_tmp84_ = gsk_path_builder_new ();
	p4 = _tmp84_;
	_tmp85_ = middle[3];
	nibbles_view_view3_d_to_view_plain (v, &_tmp85_, &_tmp86_, &_tmp87_);
	X = _tmp86_;
	Y = _tmp87_;
	gsk_path_builder_move_to (p4, (gfloat) X, (gfloat) Y);
	_tmp88_ = middle[4];
	nibbles_view_view3_d_to_view_plain (v, &_tmp88_, &_tmp89_, &_tmp90_);
	X = _tmp89_;
	Y = _tmp90_;
	gsk_path_builder_line_to (p4, (gfloat) X, (gfloat) Y);
	_tmp91_ = top[4];
	nibbles_view_view3_d_to_view_plain (v, &_tmp91_, &_tmp92_, &_tmp93_);
	X = _tmp92_;
	Y = _tmp93_;
	gsk_path_builder_line_to (p4, (gfloat) X, (gfloat) Y);
	_tmp94_ = top[3];
	nibbles_view_view3_d_to_view_plain (v, &_tmp94_, &_tmp95_, &_tmp96_);
	X = _tmp95_;
	Y = _tmp96_;
	gsk_path_builder_line_to (p4, (gfloat) X, (gfloat) Y);
	_tmp97_ = gsk_path_builder_to_path (p4);
	_tmp98_ = _tmp97_;
	_tmp99_.red = 0.447f;
	_tmp99_.green = 0.624f;
	_tmp99_.blue = 0.812f;
	_tmp99_.alpha = 1.0f;
	gtk_snapshot_append_fill (s, _tmp98_, GSK_FILL_RULE_EVEN_ODD, &_tmp99_);
	_gsk_path_unref0 (_tmp98_);
	_tmp100_ = gsk_path_builder_new ();
	p5 = _tmp100_;
	_tmp101_ = middle[5];
	nibbles_view_view3_d_to_view_plain (v, &_tmp101_, &_tmp102_, &_tmp103_);
	X = _tmp102_;
	Y = _tmp103_;
	gsk_path_builder_move_to (p5, (gfloat) X, (gfloat) Y);
	_tmp104_ = middle[0];
	nibbles_view_view3_d_to_view_plain (v, &_tmp104_, &_tmp105_, &_tmp106_);
	X = _tmp105_;
	Y = _tmp106_;
	gsk_path_builder_line_to (p5, (gfloat) X, (gfloat) Y);
	_tmp107_ = top[0];
	nibbles_view_view3_d_to_view_plain (v, &_tmp107_, &_tmp108_, &_tmp109_);
	X = _tmp108_;
	Y = _tmp109_;
	gsk_path_builder_line_to (p5, (gfloat) X, (gfloat) Y);
	_tmp110_ = top[5];
	nibbles_view_view3_d_to_view_plain (v, &_tmp110_, &_tmp111_, &_tmp112_);
	X = _tmp111_;
	Y = _tmp112_;
	gsk_path_builder_line_to (p5, (gfloat) X, (gfloat) Y);
	_tmp113_ = gsk_path_builder_to_path (p5);
	_tmp114_ = _tmp113_;
	_tmp115_.red = 0.447f;
	_tmp115_.green = 0.624f;
	_tmp115_.blue = 0.812f;
	_tmp115_.alpha = 1.0f;
	gtk_snapshot_append_fill (s, _tmp114_, GSK_FILL_RULE_EVEN_ODD, &_tmp115_);
	_gsk_path_unref0 (_tmp114_);
	_tmp116_ = gsk_path_builder_new ();
	p6 = _tmp116_;
	_tmp117_ = middle[4];
	nibbles_view_view3_d_to_view_plain (v, &_tmp117_, &_tmp118_, &_tmp119_);
	X = _tmp118_;
	Y = _tmp119_;
	gsk_path_builder_move_to (p6, (gfloat) X, (gfloat) Y);
	_tmp120_ = middle[5];
	nibbles_view_view3_d_to_view_plain (v, &_tmp120_, &_tmp121_, &_tmp122_);
	X = _tmp121_;
	Y = _tmp122_;
	gsk_path_builder_line_to (p6, (gfloat) X, (gfloat) Y);
	_tmp123_ = top[5];
	nibbles_view_view3_d_to_view_plain (v, &_tmp123_, &_tmp124_, &_tmp125_);
	X = _tmp124_;
	Y = _tmp125_;
	gsk_path_builder_line_to (p6, (gfloat) X, (gfloat) Y);
	_tmp126_ = top[4];
	nibbles_view_view3_d_to_view_plain (v, &_tmp126_, &_tmp127_, &_tmp128_);
	X = _tmp127_;
	Y = _tmp128_;
	gsk_path_builder_line_to (p6, (gfloat) X, (gfloat) Y);
	_tmp129_ = gsk_path_builder_to_path (p6);
	_tmp130_ = _tmp129_;
	_tmp131_.red = 0.718f;
	_tmp131_.green = 0.808f;
	_tmp131_.blue = 0.902f;
	_tmp131_.alpha = 1.0f;
	gtk_snapshot_append_fill (s, _tmp130_, GSK_FILL_RULE_EVEN_ODD, &_tmp131_);
	_gsk_path_unref0 (_tmp130_);
	_gsk_path_builder_unref0 (p6);
	_gsk_path_builder_unref0 (p5);
	_gsk_path_builder_unref0 (p4);
	_gsk_path_builder_unref0 (p3);
	_gsk_path_builder_unref0 (p2);
	_gsk_path_builder_unref0 (p1);
	_gsk_path_builder_unref0 (p0);
}

static void
nibbles_view_draw_heart (NibblesView* self,
                         GtkSnapshot* s,
                         NibblesViewView3D* v,
                         gdouble x,
                         gdouble y)
{
	gdouble H = 0.0;
	gdouble h = 0.0;
	gdouble cx[3] = {0};
	gdouble cy[3] = {0};
	GskPathBuilder* path = NULL;
	GskPathBuilder* _tmp0_;
	NibblesViewPoint3D _tmp1_ = {0};
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	NibblesViewPoint3D _tmp4_ = {0};
	gdouble _tmp5_ = 0.0;
	gdouble _tmp6_ = 0.0;
	NibblesViewPoint3D _tmp7_ = {0};
	gdouble _tmp8_ = 0.0;
	gdouble _tmp9_ = 0.0;
	gdouble _tmp10_;
	gdouble _tmp11_;
	gdouble _tmp12_;
	gdouble _tmp13_;
	gdouble _tmp14_;
	gdouble _tmp15_;
	gdouble _tmp16_;
	gdouble _tmp17_;
	NibblesViewPoint3D _tmp18_ = {0};
	gdouble _tmp19_ = 0.0;
	gdouble _tmp20_ = 0.0;
	NibblesViewPoint3D _tmp21_ = {0};
	gdouble _tmp22_ = 0.0;
	gdouble _tmp23_ = 0.0;
	NibblesViewPoint3D _tmp24_ = {0};
	gdouble _tmp25_ = 0.0;
	gdouble _tmp26_ = 0.0;
	gdouble _tmp27_;
	gdouble _tmp28_;
	gdouble _tmp29_;
	gdouble _tmp30_;
	gdouble _tmp31_;
	gdouble _tmp32_;
	NibblesViewPoint3D _tmp33_ = {0};
	gdouble _tmp34_ = 0.0;
	gdouble _tmp35_ = 0.0;
	NibblesViewPoint3D _tmp36_ = {0};
	gdouble _tmp37_ = 0.0;
	gdouble _tmp38_ = 0.0;
	NibblesViewPoint3D _tmp39_ = {0};
	gdouble _tmp40_ = 0.0;
	gdouble _tmp41_ = 0.0;
	gdouble _tmp42_;
	gdouble _tmp43_;
	gdouble _tmp44_;
	gdouble _tmp45_;
	gdouble _tmp46_;
	gdouble _tmp47_;
	NibblesViewPoint3D _tmp48_ = {0};
	gdouble _tmp49_ = 0.0;
	gdouble _tmp50_ = 0.0;
	NibblesViewPoint3D _tmp51_ = {0};
	gdouble _tmp52_ = 0.0;
	gdouble _tmp53_ = 0.0;
	NibblesViewPoint3D _tmp54_ = {0};
	gdouble _tmp55_ = 0.0;
	gdouble _tmp56_ = 0.0;
	gdouble _tmp57_;
	gdouble _tmp58_;
	gdouble _tmp59_;
	gdouble _tmp60_;
	gdouble _tmp61_;
	gdouble _tmp62_;
	NibblesViewPoint3D _tmp63_ = {0};
	gdouble _tmp64_ = 0.0;
	gdouble _tmp65_ = 0.0;
	NibblesViewPoint3D _tmp66_ = {0};
	gdouble _tmp67_ = 0.0;
	gdouble _tmp68_ = 0.0;
	NibblesViewPoint3D _tmp69_ = {0};
	gdouble _tmp70_ = 0.0;
	gdouble _tmp71_ = 0.0;
	gdouble _tmp72_;
	gdouble _tmp73_;
	gdouble _tmp74_;
	gdouble _tmp75_;
	gdouble _tmp76_;
	gdouble _tmp77_;
	NibblesViewPoint3D _tmp78_ = {0};
	gdouble _tmp79_ = 0.0;
	gdouble _tmp80_ = 0.0;
	NibblesViewPoint3D _tmp81_ = {0};
	gdouble _tmp82_ = 0.0;
	gdouble _tmp83_ = 0.0;
	NibblesViewPoint3D _tmp84_ = {0};
	gdouble _tmp85_ = 0.0;
	gdouble _tmp86_ = 0.0;
	gdouble _tmp87_;
	gdouble _tmp88_;
	gdouble _tmp89_;
	gdouble _tmp90_;
	gdouble _tmp91_;
	gdouble _tmp92_;
	NibblesViewPoint3D _tmp93_ = {0};
	gdouble _tmp94_ = 0.0;
	gdouble _tmp95_ = 0.0;
	gdouble _tmp96_;
	gdouble _tmp97_;
	NibblesViewPoint3D _tmp98_ = {0};
	gdouble _tmp99_ = 0.0;
	gdouble _tmp100_ = 0.0;
	gdouble _tmp101_;
	gdouble _tmp102_;
	NibblesViewPoint3D _tmp103_ = {0};
	gdouble _tmp104_ = 0.0;
	gdouble _tmp105_ = 0.0;
	NibblesViewPoint3D _tmp106_ = {0};
	gdouble _tmp107_ = 0.0;
	gdouble _tmp108_ = 0.0;
	gdouble radius = 0.0;
	NibblesViewPoint3D _tmp109_ = {0};
	NibblesViewPoint3D _tmp110_ = {0};
	GskPath* _tmp111_;
	GskPath* _tmp112_;
	GskPath* _tmp113_;
	GskPath* _tmp114_;
	graphene_rect_t _tmp115_ = {0};
	gdouble _tmp116_;
	gdouble _tmp117_;
	graphene_point_t _tmp118_ = {0};
	GdkRGBA _tmp119_ = {0};
	GskColorStop _tmp120_ = {0};
	GdkRGBA _tmp121_ = {0};
	GskColorStop _tmp122_ = {0};
	GdkRGBA _tmp123_ = {0};
	GskColorStop _tmp124_ = {0};
	GskColorStop* _tmp125_;
	GskColorStop* _tmp126_;
	gint _tmp126__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	g_return_if_fail (v != NULL);
	H = sqrt (0.125);
	h = 0.5 - H;
	_tmp0_ = gsk_path_builder_new ();
	path = _tmp0_;
	_tmp1_.x = x + h;
	_tmp1_.y = y + 1;
	_tmp1_.z = 1 + h;
	nibbles_view_view3_d_to_view_plain (v, &_tmp1_, &_tmp2_, &_tmp3_);
	cx[0] = _tmp2_;
	cy[0] = _tmp3_;
	_tmp4_.x = x - 0.207106781187;
	_tmp4_.y = y + 1;
	_tmp4_.z = 1.5;
	nibbles_view_view3_d_to_view_plain (v, &_tmp4_, &_tmp5_, &_tmp6_);
	cx[1] = _tmp5_;
	cy[1] = _tmp6_;
	_tmp7_.x = x + h;
	_tmp7_.y = y + 1;
	_tmp7_.z = 2.0 - h;
	nibbles_view_view3_d_to_view_plain (v, &_tmp7_, &_tmp8_, &_tmp9_);
	cx[2] = _tmp8_;
	cy[2] = _tmp9_;
	_tmp10_ = cx[0];
	_tmp11_ = cy[0];
	gsk_path_builder_move_to (path, (gfloat) _tmp10_, (gfloat) _tmp11_);
	_tmp12_ = cx[0];
	_tmp13_ = cy[0];
	_tmp14_ = cx[1];
	_tmp15_ = cy[1];
	_tmp16_ = cx[2];
	_tmp17_ = cy[2];
	gsk_path_builder_cubic_to (path, (gfloat) _tmp12_, (gfloat) _tmp13_, (gfloat) _tmp14_, (gfloat) _tmp15_, (gfloat) _tmp16_, (gfloat) _tmp17_);
	_tmp18_.x = x + h;
	_tmp18_.y = y + 1;
	_tmp18_.z = 2.0 - h;
	nibbles_view_view3_d_to_view_plain (v, &_tmp18_, &_tmp19_, &_tmp20_);
	cx[0] = _tmp19_;
	cy[0] = _tmp20_;
	_tmp21_.x = x + 0.5;
	_tmp21_.y = y + 1;
	_tmp21_.z = 2.0 + 0.207106781187;
	nibbles_view_view3_d_to_view_plain (v, &_tmp21_, &_tmp22_, &_tmp23_);
	cx[1] = _tmp22_;
	cy[1] = _tmp23_;
	_tmp24_.x = (x + 1) - h;
	_tmp24_.y = y + 1;
	_tmp24_.z = 2.0 - h;
	nibbles_view_view3_d_to_view_plain (v, &_tmp24_, &_tmp25_, &_tmp26_);
	cx[2] = _tmp25_;
	cy[2] = _tmp26_;
	_tmp27_ = cx[0];
	_tmp28_ = cy[0];
	_tmp29_ = cx[1];
	_tmp30_ = cy[1];
	_tmp31_ = cx[2];
	_tmp32_ = cy[2];
	gsk_path_builder_cubic_to (path, (gfloat) _tmp27_, (gfloat) _tmp28_, (gfloat) _tmp29_, (gfloat) _tmp30_, (gfloat) _tmp31_, (gfloat) _tmp32_);
	_tmp33_.x = (x + 1) - h;
	_tmp33_.y = y + 1;
	_tmp33_.z = 2.0 - h;
	nibbles_view_view3_d_to_view_plain (v, &_tmp33_, &_tmp34_, &_tmp35_);
	cx[0] = _tmp34_;
	cy[0] = _tmp35_;
	_tmp36_.x = x + 1;
	_tmp36_.y = y + 1;
	_tmp36_.z = (((2.0 - h) - 1.5) / 2) + 1.5;
	nibbles_view_view3_d_to_view_plain (v, &_tmp36_, &_tmp37_, &_tmp38_);
	cx[1] = _tmp37_;
	cy[1] = _tmp38_;
	_tmp39_.x = x + 1;
	_tmp39_.y = y + 1;
	_tmp39_.z = 1.5;
	nibbles_view_view3_d_to_view_plain (v, &_tmp39_, &_tmp40_, &_tmp41_);
	cx[2] = _tmp40_;
	cy[2] = _tmp41_;
	_tmp42_ = cx[0];
	_tmp43_ = cy[0];
	_tmp44_ = cx[1];
	_tmp45_ = cy[1];
	_tmp46_ = cx[2];
	_tmp47_ = cy[2];
	gsk_path_builder_cubic_to (path, (gfloat) _tmp42_, (gfloat) _tmp43_, (gfloat) _tmp44_, (gfloat) _tmp45_, (gfloat) _tmp46_, (gfloat) _tmp47_);
	_tmp48_.x = x + 1;
	_tmp48_.y = y + 1;
	_tmp48_.z = 1.5;
	nibbles_view_view3_d_to_view_plain (v, &_tmp48_, &_tmp49_, &_tmp50_);
	cx[0] = _tmp49_;
	cy[0] = _tmp50_;
	_tmp51_.x = x + 1;
	_tmp51_.y = y + 1;
	_tmp51_.z = (((2.0 - h) - 1.5) / 2) + 1.5;
	nibbles_view_view3_d_to_view_plain (v, &_tmp51_, &_tmp52_, &_tmp53_);
	cx[1] = _tmp52_;
	cy[1] = _tmp53_;
	_tmp54_.x = (x + 1) + h;
	_tmp54_.y = y + 1;
	_tmp54_.z = 2.0 - h;
	nibbles_view_view3_d_to_view_plain (v, &_tmp54_, &_tmp55_, &_tmp56_);
	cx[2] = _tmp55_;
	cy[2] = _tmp56_;
	_tmp57_ = cx[0];
	_tmp58_ = cy[0];
	_tmp59_ = cx[1];
	_tmp60_ = cy[1];
	_tmp61_ = cx[2];
	_tmp62_ = cy[2];
	gsk_path_builder_cubic_to (path, (gfloat) _tmp57_, (gfloat) _tmp58_, (gfloat) _tmp59_, (gfloat) _tmp60_, (gfloat) _tmp61_, (gfloat) _tmp62_);
	_tmp63_.x = (x + 1) + h;
	_tmp63_.y = y + 1;
	_tmp63_.z = 2.0 - h;
	nibbles_view_view3_d_to_view_plain (v, &_tmp63_, &_tmp64_, &_tmp65_);
	cx[0] = _tmp64_;
	cy[0] = _tmp65_;
	_tmp66_.x = x + 1.5;
	_tmp66_.y = y + 1;
	_tmp66_.z = 2.0 + 0.207106781187;
	nibbles_view_view3_d_to_view_plain (v, &_tmp66_, &_tmp67_, &_tmp68_);
	cx[1] = _tmp67_;
	cy[1] = _tmp68_;
	_tmp69_.x = (x + 2) - h;
	_tmp69_.y = y + 1;
	_tmp69_.z = 2.0 - h;
	nibbles_view_view3_d_to_view_plain (v, &_tmp69_, &_tmp70_, &_tmp71_);
	cx[2] = _tmp70_;
	cy[2] = _tmp71_;
	_tmp72_ = cx[0];
	_tmp73_ = cy[0];
	_tmp74_ = cx[1];
	_tmp75_ = cy[1];
	_tmp76_ = cx[2];
	_tmp77_ = cy[2];
	gsk_path_builder_cubic_to (path, (gfloat) _tmp72_, (gfloat) _tmp73_, (gfloat) _tmp74_, (gfloat) _tmp75_, (gfloat) _tmp76_, (gfloat) _tmp77_);
	_tmp78_.x = (x + 2) - h;
	_tmp78_.y = y + 1;
	_tmp78_.z = 2.0 - h;
	nibbles_view_view3_d_to_view_plain (v, &_tmp78_, &_tmp79_, &_tmp80_);
	cx[0] = _tmp79_;
	cy[0] = _tmp80_;
	_tmp81_.x = (x + 2) + 0.207106781187;
	_tmp81_.y = y + 1;
	_tmp81_.z = 1.5;
	nibbles_view_view3_d_to_view_plain (v, &_tmp81_, &_tmp82_, &_tmp83_);
	cx[1] = _tmp82_;
	cy[1] = _tmp83_;
	_tmp84_.x = (x + 2) - h;
	_tmp84_.y = y + 1;
	_tmp84_.z = 1 + h;
	nibbles_view_view3_d_to_view_plain (v, &_tmp84_, &_tmp85_, &_tmp86_);
	cx[2] = _tmp85_;
	cy[2] = _tmp86_;
	_tmp87_ = cx[0];
	_tmp88_ = cy[0];
	_tmp89_ = cx[1];
	_tmp90_ = cy[1];
	_tmp91_ = cx[2];
	_tmp92_ = cy[2];
	gsk_path_builder_cubic_to (path, (gfloat) _tmp87_, (gfloat) _tmp88_, (gfloat) _tmp89_, (gfloat) _tmp90_, (gfloat) _tmp91_, (gfloat) _tmp92_);
	_tmp93_.x = x + 1;
	_tmp93_.y = y + 1;
	_tmp93_.z = (gdouble) 0;
	nibbles_view_view3_d_to_view_plain (v, &_tmp93_, &_tmp94_, &_tmp95_);
	cx[0] = _tmp94_;
	cy[0] = _tmp95_;
	_tmp96_ = cx[0];
	_tmp97_ = cy[0];
	gsk_path_builder_line_to (path, (gfloat) _tmp96_, (gfloat) _tmp97_);
	_tmp98_.x = x + h;
	_tmp98_.y = y + 1;
	_tmp98_.z = 1 + h;
	nibbles_view_view3_d_to_view_plain (v, &_tmp98_, &_tmp99_, &_tmp100_);
	cx[0] = _tmp99_;
	cy[0] = _tmp100_;
	_tmp101_ = cx[0];
	_tmp102_ = cy[0];
	gsk_path_builder_line_to (path, (gfloat) _tmp101_, (gfloat) _tmp102_);
	_tmp103_.x = x + 1;
	_tmp103_.y = y + 1;
	_tmp103_.z = 1 + h;
	nibbles_view_view3_d_to_view_plain (v, &_tmp103_, &_tmp104_, &_tmp105_);
	cx[0] = _tmp104_;
	cy[0] = _tmp105_;
	_tmp106_.x = x + 0.875;
	_tmp106_.y = y + 1;
	_tmp106_.z = 1.5;
	nibbles_view_view3_d_to_view_plain (v, &_tmp106_, &_tmp107_, &_tmp108_);
	cx[1] = _tmp107_;
	cy[1] = _tmp108_;
	_tmp109_.x = x + 1;
	_tmp109_.y = y + 1;
	_tmp109_.z = 1 + h;
	_tmp110_.x = x + 1;
	_tmp110_.y = y + 1;
	_tmp110_.z = 0.0;
	radius = nibbles_view_view3_d_2D_diff (v, &_tmp109_, &_tmp110_);
	_tmp111_ = gsk_path_builder_to_path (path);
	_tmp112_ = _tmp111_;
	gtk_snapshot_push_fill (s, _tmp112_, GSK_FILL_RULE_EVEN_ODD);
	_gsk_path_unref0 (_tmp112_);
	_tmp113_ = gsk_path_builder_to_path (path);
	_tmp114_ = _tmp113_;
	nibbles_view_get_bounds (self, _tmp114_, &_tmp115_);
	_tmp116_ = cx[0];
	_tmp117_ = cy[0];
	_tmp118_.x = (gfloat) _tmp116_;
	_tmp118_.y = (gfloat) _tmp117_;
	_tmp119_.red = (gfloat) 1;
	_tmp119_.green = 0.5f;
	_tmp119_.blue = 0.5f;
	_tmp119_.alpha = (gfloat) 1;
	memset (&_tmp120_, 0, sizeof (GskColorStop));
	_tmp120_.offset = (gfloat) 0;
	_tmp120_.color = _tmp119_;
	_tmp121_.red = (gfloat) 1;
	_tmp121_.green = (gfloat) 0;
	_tmp121_.blue = (gfloat) 0;
	_tmp121_.alpha = (gfloat) 1;
	memset (&_tmp122_, 0, sizeof (GskColorStop));
	_tmp122_.offset = 0.1f;
	_tmp122_.color = _tmp121_;
	_tmp123_.red = (gfloat) (1 / 10);
	_tmp123_.green = (gfloat) 0;
	_tmp123_.blue = (gfloat) 0;
	_tmp123_.alpha = (gfloat) 1;
	memset (&_tmp124_, 0, sizeof (GskColorStop));
	_tmp124_.offset = (gfloat) 1;
	_tmp124_.color = _tmp123_;
	_tmp125_ = g_new0 (GskColorStop, 3);
	_tmp125_[0] = _tmp120_;
	_tmp125_[1] = _tmp122_;
	_tmp125_[2] = _tmp124_;
	_tmp126_ = _tmp125_;
	_tmp126__length1 = 3;
	gtk_snapshot_append_radial_gradient (s, &_tmp115_, &_tmp118_, ((gfloat) radius) / 40.0f, ((gfloat) radius) / 40.0f, (gfloat) 0, (gfloat) 100, _tmp126_, (gsize) 3);
	_tmp126_ = (g_free (_tmp126_), NULL);
	_gsk_path_unref0 (_tmp114_);
	gtk_snapshot_pop (s);
	_gsk_path_builder_unref0 (path);
}

static void
nibbles_view_draw_cherry (NibblesView* self,
                          GtkSnapshot* s,
                          NibblesViewView3D* v,
                          gdouble x,
                          gdouble y)
{
	GskPath* left_cherry = NULL;
	NibblesViewPoint3D _tmp0_ = {0};
	NibblesViewPoint3D _tmp1_ = {0};
	NibblesViewPoint3D _tmp2_ = {0};
	NibblesViewPoint3D _tmp3_ = {0};
	GskPath* _tmp4_;
	gdouble X = 0.0;
	gdouble Y = 0.0;
	gdouble radius = 0.0;
	gdouble d = 0.0;
	gdouble top_x = 0.0;
	gdouble top_y = 0.0;
	NibblesViewPoint3D _tmp5_ = {0};
	gdouble _tmp6_ = 0.0;
	gdouble _tmp7_ = 0.0;
	NibblesViewPoint3D _tmp8_ = {0};
	NibblesViewPoint3D _tmp9_ = {0};
	NibblesViewPoint3D _tmp10_ = {0};
	NibblesViewPoint3D _tmp11_ = {0};
	NibblesViewPoint3D _tmp12_ = {0};
	NibblesViewPoint3D _tmp13_ = {0};
	NibblesViewPoint3D _tmp14_ = {0};
	NibblesViewPoint3D _tmp15_ = {0};
	NibblesViewPoint3D _tmp16_ = {0};
	gdouble _tmp17_ = 0.0;
	gdouble _tmp18_ = 0.0;
	GskPath* _tmp19_;
	GskPath* _tmp20_;
	graphene_rect_t _tmp21_ = {0};
	graphene_point_t _tmp22_ = {0};
	GdkRGBA _tmp23_ = {0};
	GskColorStop _tmp24_ = {0};
	GdkRGBA _tmp25_ = {0};
	GskColorStop _tmp26_ = {0};
	GdkRGBA _tmp27_ = {0};
	GskColorStop _tmp28_ = {0};
	GskColorStop* _tmp29_;
	GskColorStop* _tmp30_;
	gint _tmp30__length1;
	GskPathBuilder* left_stalk = NULL;
	GskPathBuilder* _tmp31_;
	gdouble cx[3] = {0};
	gdouble cy[3] = {0};
	NibblesViewPoint3D _tmp32_ = {0};
	gdouble _tmp33_ = 0.0;
	gdouble _tmp34_ = 0.0;
	NibblesViewPoint3D _tmp35_ = {0};
	gdouble _tmp36_ = 0.0;
	gdouble _tmp37_ = 0.0;
	NibblesViewPoint3D _tmp38_ = {0};
	gdouble _tmp39_ = 0.0;
	gdouble _tmp40_ = 0.0;
	GskPathBuilder* _tmp41_;
	gdouble _tmp42_;
	gdouble _tmp43_;
	GskPathBuilder* _tmp44_;
	gdouble _tmp45_;
	gdouble _tmp46_;
	gdouble _tmp47_;
	gdouble _tmp48_;
	gdouble _tmp49_;
	gdouble _tmp50_;
	NibblesViewPoint3D _tmp51_ = {0};
	gdouble _tmp52_ = 0.0;
	gdouble _tmp53_ = 0.0;
	NibblesViewPoint3D _tmp54_ = {0};
	gdouble _tmp55_ = 0.0;
	gdouble _tmp56_ = 0.0;
	NibblesViewPoint3D _tmp57_ = {0};
	gdouble _tmp58_ = 0.0;
	gdouble _tmp59_ = 0.0;
	GskPathBuilder* _tmp60_;
	gdouble _tmp61_;
	gdouble _tmp62_;
	gdouble _tmp63_;
	gdouble _tmp64_;
	gdouble _tmp65_;
	gdouble _tmp66_;
	GskPathBuilder* _tmp67_;
	GskPath* _tmp68_;
	GskPath* _tmp69_;
	GdkRGBA _tmp70_ = {0};
	GskPath* right_cherry = NULL;
	NibblesViewPoint3D _tmp71_ = {0};
	NibblesViewPoint3D _tmp72_ = {0};
	NibblesViewPoint3D _tmp73_ = {0};
	NibblesViewPoint3D _tmp74_ = {0};
	GskPath* _tmp75_;
	NibblesViewPoint3D _tmp76_ = {0};
	gdouble _tmp77_ = 0.0;
	gdouble _tmp78_ = 0.0;
	NibblesViewPoint3D _tmp79_ = {0};
	NibblesViewPoint3D _tmp80_ = {0};
	NibblesViewPoint3D _tmp81_ = {0};
	NibblesViewPoint3D _tmp82_ = {0};
	NibblesViewPoint3D _tmp83_ = {0};
	NibblesViewPoint3D _tmp84_ = {0};
	NibblesViewPoint3D _tmp85_ = {0};
	NibblesViewPoint3D _tmp86_ = {0};
	NibblesViewPoint3D _tmp87_ = {0};
	gdouble _tmp88_ = 0.0;
	gdouble _tmp89_ = 0.0;
	GskPath* _tmp90_;
	GskPath* _tmp91_;
	graphene_rect_t _tmp92_ = {0};
	graphene_point_t _tmp93_ = {0};
	GdkRGBA _tmp94_ = {0};
	GskColorStop _tmp95_ = {0};
	GdkRGBA _tmp96_ = {0};
	GskColorStop _tmp97_ = {0};
	GdkRGBA _tmp98_ = {0};
	GskColorStop _tmp99_ = {0};
	GskColorStop* _tmp100_;
	GskColorStop* _tmp101_;
	gint _tmp101__length1;
	GskPathBuilder* right_stalk = NULL;
	GskPathBuilder* _tmp102_;
	NibblesViewPoint3D _tmp103_ = {0};
	gdouble _tmp104_ = 0.0;
	gdouble _tmp105_ = 0.0;
	NibblesViewPoint3D _tmp106_ = {0};
	gdouble _tmp107_ = 0.0;
	gdouble _tmp108_ = 0.0;
	NibblesViewPoint3D _tmp109_ = {0};
	gdouble _tmp110_ = 0.0;
	gdouble _tmp111_ = 0.0;
	gdouble _tmp112_;
	gdouble _tmp113_;
	gdouble _tmp114_;
	gdouble _tmp115_;
	gdouble _tmp116_;
	gdouble _tmp117_;
	gdouble _tmp118_;
	gdouble _tmp119_;
	NibblesViewPoint3D _tmp120_ = {0};
	gdouble _tmp121_ = 0.0;
	gdouble _tmp122_ = 0.0;
	NibblesViewPoint3D _tmp123_ = {0};
	gdouble _tmp124_ = 0.0;
	gdouble _tmp125_ = 0.0;
	NibblesViewPoint3D _tmp126_ = {0};
	gdouble _tmp127_ = 0.0;
	gdouble _tmp128_ = 0.0;
	gdouble _tmp129_;
	gdouble _tmp130_;
	gdouble _tmp131_;
	gdouble _tmp132_;
	gdouble _tmp133_;
	gdouble _tmp134_;
	GskPath* _tmp135_;
	GskPath* _tmp136_;
	GdkRGBA _tmp137_ = {0};
	GskPathBuilder* leaf = NULL;
	GskPathBuilder* _tmp138_;
	NibblesViewPoint3D _tmp139_ = {0};
	gdouble _tmp140_ = 0.0;
	gdouble _tmp141_ = 0.0;
	NibblesViewPoint3D _tmp142_ = {0};
	gdouble _tmp143_ = 0.0;
	gdouble _tmp144_ = 0.0;
	NibblesViewPoint3D _tmp145_ = {0};
	gdouble _tmp146_ = 0.0;
	gdouble _tmp147_ = 0.0;
	gdouble _tmp148_;
	gdouble _tmp149_;
	gdouble _tmp150_;
	gdouble _tmp151_;
	gdouble _tmp152_;
	gdouble _tmp153_;
	gdouble _tmp154_;
	gdouble _tmp155_;
	NibblesViewPoint3D _tmp156_ = {0};
	gdouble _tmp157_ = 0.0;
	gdouble _tmp158_ = 0.0;
	NibblesViewPoint3D _tmp159_ = {0};
	gdouble _tmp160_ = 0.0;
	gdouble _tmp161_ = 0.0;
	NibblesViewPoint3D _tmp162_ = {0};
	gdouble _tmp163_ = 0.0;
	gdouble _tmp164_ = 0.0;
	gdouble _tmp165_;
	gdouble _tmp166_;
	gdouble _tmp167_;
	gdouble _tmp168_;
	gdouble _tmp169_;
	gdouble _tmp170_;
	GskPath* _tmp171_;
	GskPath* _tmp172_;
	GdkRGBA _tmp173_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	g_return_if_fail (v != NULL);
	_tmp0_.x = x;
	_tmp0_.y = 1.5 + y;
	_tmp0_.z = (gdouble) 0;
	_tmp1_.x = x;
	_tmp1_.y = 0.5 + y;
	_tmp1_.z = (gdouble) 1;
	_tmp2_.x = 1.0 + x;
	_tmp2_.y = 0.5 + y;
	_tmp2_.z = (gdouble) 1;
	_tmp3_.x = 1.0 + x;
	_tmp3_.y = 1.5 + y;
	_tmp3_.z = (gdouble) 0;
	_tmp4_ = nibbles_view_draw_oval (self, v, &_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_);
	left_cherry = _tmp4_;
	_tmp5_.x = x + 0.5;
	_tmp5_.y = y + 1.0;
	_tmp5_.z = 0.5;
	nibbles_view_view3_d_to_view_plain (v, &_tmp5_, &_tmp6_, &_tmp7_);
	X = _tmp6_;
	Y = _tmp7_;
	_tmp8_.x = x + 0.5;
	_tmp8_.y = y + 1.0;
	_tmp8_.z = 0.5;
	_tmp9_.x = x + 0.5;
	_tmp9_.y = y + 0.5;
	_tmp9_.z = 1.0;
	radius = nibbles_view_view3_d_2D_diff (v, &_tmp8_, &_tmp9_);
	_tmp10_.x = x + 0.5;
	_tmp10_.y = y + 1.0;
	_tmp10_.z = 0.5;
	_tmp11_.x = x + 0.0;
	_tmp11_.y = y + 1.0;
	_tmp11_.z = 0.5;
	d = nibbles_view_view3_d_2D_diff (v, &_tmp10_, &_tmp11_);
	if (d > radius) {
		radius = d;
	}
	_tmp12_.x = x + 0.5;
	_tmp12_.y = y + 1.0;
	_tmp12_.z = 0.5;
	_tmp13_.x = x + 1.0;
	_tmp13_.y = y + 1.0;
	_tmp13_.z = 0.5;
	d = nibbles_view_view3_d_2D_diff (v, &_tmp12_, &_tmp13_);
	if (d > radius) {
		radius = d;
	}
	_tmp14_.x = x + 0.5;
	_tmp14_.y = y + 1.0;
	_tmp14_.z = 0.5;
	_tmp15_.x = x + 0.5;
	_tmp15_.y = y + 1.5;
	_tmp15_.z = 0.0;
	d = nibbles_view_view3_d_2D_diff (v, &_tmp14_, &_tmp15_);
	if (d > radius) {
		radius = d;
	}
	_tmp16_.x = x + 0.5;
	_tmp16_.y = y + 1.0;
	_tmp16_.z = 1.0;
	nibbles_view_view3_d_to_view_plain (v, &_tmp16_, &_tmp17_, &_tmp18_);
	top_x = _tmp17_;
	top_y = _tmp18_;
	_tmp19_ = left_cherry;
	gtk_snapshot_push_fill (s, _tmp19_, GSK_FILL_RULE_EVEN_ODD);
	_tmp20_ = left_cherry;
	nibbles_view_get_bounds (self, _tmp20_, &_tmp21_);
	_tmp22_.x = (gfloat) top_x;
	_tmp22_.y = (gfloat) top_y;
	_tmp23_.red = (gfloat) 1;
	_tmp23_.green = 0.5f;
	_tmp23_.blue = 0.5f;
	_tmp23_.alpha = (gfloat) 1;
	memset (&_tmp24_, 0, sizeof (GskColorStop));
	_tmp24_.offset = (gfloat) 0;
	_tmp24_.color = _tmp23_;
	_tmp25_.red = (gfloat) 1;
	_tmp25_.green = (gfloat) 0;
	_tmp25_.blue = (gfloat) 0;
	_tmp25_.alpha = (gfloat) 1;
	memset (&_tmp26_, 0, sizeof (GskColorStop));
	_tmp26_.offset = 0.1f;
	_tmp26_.color = _tmp25_;
	_tmp27_.red = 0.1f;
	_tmp27_.green = (gfloat) 0;
	_tmp27_.blue = (gfloat) 0;
	_tmp27_.alpha = (gfloat) 1;
	memset (&_tmp28_, 0, sizeof (GskColorStop));
	_tmp28_.offset = (gfloat) 1;
	_tmp28_.color = _tmp27_;
	_tmp29_ = g_new0 (GskColorStop, 3);
	_tmp29_[0] = _tmp24_;
	_tmp29_[1] = _tmp26_;
	_tmp29_[2] = _tmp28_;
	_tmp30_ = _tmp29_;
	_tmp30__length1 = 3;
	gtk_snapshot_append_radial_gradient (s, &_tmp21_, &_tmp22_, ((gfloat) radius) / 80.0f, ((gfloat) radius) / 80.0f, (gfloat) 0, (gfloat) 100, _tmp30_, (gsize) 3);
	_tmp30_ = (g_free (_tmp30_), NULL);
	gtk_snapshot_pop (s);
	_tmp31_ = gsk_path_builder_new ();
	left_stalk = _tmp31_;
	_tmp32_.x = x + 0.45;
	_tmp32_.y = y + 1.0;
	_tmp32_.z = 1.0;
	nibbles_view_view3_d_to_view_plain (v, &_tmp32_, &_tmp33_, &_tmp34_);
	cx[0] = _tmp33_;
	cy[0] = _tmp34_;
	_tmp35_.x = x + 0.45;
	_tmp35_.y = y + 1.0;
	_tmp35_.z = 2.0;
	nibbles_view_view3_d_to_view_plain (v, &_tmp35_, &_tmp36_, &_tmp37_);
	cx[1] = _tmp36_;
	cy[1] = _tmp37_;
	_tmp38_.x = x + 1.15;
	_tmp38_.y = y + 1.0;
	_tmp38_.z = 2.0;
	nibbles_view_view3_d_to_view_plain (v, &_tmp38_, &_tmp39_, &_tmp40_);
	cx[2] = _tmp39_;
	cy[2] = _tmp40_;
	_tmp41_ = left_stalk;
	_tmp42_ = cx[0];
	_tmp43_ = cy[0];
	gsk_path_builder_move_to (_tmp41_, (gfloat) _tmp42_, (gfloat) _tmp43_);
	_tmp44_ = left_stalk;
	_tmp45_ = cx[0];
	_tmp46_ = cy[0];
	_tmp47_ = cx[1];
	_tmp48_ = cy[1];
	_tmp49_ = cx[2];
	_tmp50_ = cy[2];
	gsk_path_builder_cubic_to (_tmp44_, (gfloat) _tmp45_, (gfloat) _tmp46_, (gfloat) _tmp47_, (gfloat) _tmp48_, (gfloat) _tmp49_, (gfloat) _tmp50_);
	_tmp51_.x = x + 1.25;
	_tmp51_.y = y + 1.0;
	_tmp51_.z = 2.0;
	nibbles_view_view3_d_to_view_plain (v, &_tmp51_, &_tmp52_, &_tmp53_);
	cx[0] = _tmp52_;
	cy[0] = _tmp53_;
	_tmp54_.x = x + 0.55;
	_tmp54_.y = y + 1.0;
	_tmp54_.z = 2.0;
	nibbles_view_view3_d_to_view_plain (v, &_tmp54_, &_tmp55_, &_tmp56_);
	cx[1] = _tmp55_;
	cy[1] = _tmp56_;
	_tmp57_.x = x + 0.55;
	_tmp57_.y = y + 1.0;
	_tmp57_.z = 1.0;
	nibbles_view_view3_d_to_view_plain (v, &_tmp57_, &_tmp58_, &_tmp59_);
	cx[2] = _tmp58_;
	cy[2] = _tmp59_;
	_tmp60_ = left_stalk;
	_tmp61_ = cx[0];
	_tmp62_ = cy[0];
	_tmp63_ = cx[1];
	_tmp64_ = cy[1];
	_tmp65_ = cx[2];
	_tmp66_ = cy[2];
	gsk_path_builder_cubic_to (_tmp60_, (gfloat) _tmp61_, (gfloat) _tmp62_, (gfloat) _tmp63_, (gfloat) _tmp64_, (gfloat) _tmp65_, (gfloat) _tmp66_);
	_tmp67_ = left_stalk;
	_tmp68_ = gsk_path_builder_to_path (_tmp67_);
	_tmp69_ = _tmp68_;
	_tmp70_.red = 0.5f;
	_tmp70_.green = 0.5f;
	_tmp70_.blue = 0.0f;
	_tmp70_.alpha = 1.0f;
	gtk_snapshot_append_fill (s, _tmp69_, GSK_FILL_RULE_EVEN_ODD, &_tmp70_);
	_gsk_path_unref0 (_tmp69_);
	_tmp71_.x = 1.0 + x;
	_tmp71_.y = 1.5 + y;
	_tmp71_.z = (gdouble) 0;
	_tmp72_.x = 1.0 + x;
	_tmp72_.y = 0.5 + y;
	_tmp72_.z = (gdouble) 1;
	_tmp73_.x = 2.0 + x;
	_tmp73_.y = 0.5 + y;
	_tmp73_.z = (gdouble) 1;
	_tmp74_.x = 2.0 + x;
	_tmp74_.y = 1.5 + y;
	_tmp74_.z = (gdouble) 0;
	_tmp75_ = nibbles_view_draw_oval (self, v, &_tmp71_, &_tmp72_, &_tmp73_, &_tmp74_);
	right_cherry = _tmp75_;
	_tmp76_.x = x + 1.5;
	_tmp76_.y = y + 1.0;
	_tmp76_.z = 0.5;
	nibbles_view_view3_d_to_view_plain (v, &_tmp76_, &_tmp77_, &_tmp78_);
	X = _tmp77_;
	Y = _tmp78_;
	_tmp79_.x = x + 1.5;
	_tmp79_.y = y + 1.0;
	_tmp79_.z = 0.5;
	_tmp80_.x = x + 1.5;
	_tmp80_.y = y + 0.5;
	_tmp80_.z = 1.0;
	radius = nibbles_view_view3_d_2D_diff (v, &_tmp79_, &_tmp80_);
	_tmp81_.x = x + 1.5;
	_tmp81_.y = y + 1.0;
	_tmp81_.z = 0.5;
	_tmp82_.x = x + 1.0;
	_tmp82_.y = y + 1.0;
	_tmp82_.z = 0.5;
	d = nibbles_view_view3_d_2D_diff (v, &_tmp81_, &_tmp82_);
	if (d > radius) {
		radius = d;
	}
	_tmp83_.x = x + 1.5;
	_tmp83_.y = y + 1.0;
	_tmp83_.z = 0.5;
	_tmp84_.x = x + 2.0;
	_tmp84_.y = y + 1.0;
	_tmp84_.z = 0.5;
	d = nibbles_view_view3_d_2D_diff (v, &_tmp83_, &_tmp84_);
	if (d > radius) {
		radius = d;
	}
	_tmp85_.x = x + 1.5;
	_tmp85_.y = y + 1.0;
	_tmp85_.z = 0.5;
	_tmp86_.x = x + 1.5;
	_tmp86_.y = y + 1.5;
	_tmp86_.z = 0.0;
	d = nibbles_view_view3_d_2D_diff (v, &_tmp85_, &_tmp86_);
	if (d > radius) {
		radius = d;
	}
	_tmp87_.x = x + 1.5;
	_tmp87_.y = y + 1.0;
	_tmp87_.z = 1.0;
	nibbles_view_view3_d_to_view_plain (v, &_tmp87_, &_tmp88_, &_tmp89_);
	top_x = _tmp88_;
	top_y = _tmp89_;
	_tmp90_ = right_cherry;
	gtk_snapshot_push_fill (s, _tmp90_, GSK_FILL_RULE_EVEN_ODD);
	_tmp91_ = right_cherry;
	nibbles_view_get_bounds (self, _tmp91_, &_tmp92_);
	_tmp93_.x = (gfloat) top_x;
	_tmp93_.y = (gfloat) top_y;
	_tmp94_.red = (gfloat) 1;
	_tmp94_.green = 0.5f;
	_tmp94_.blue = 0.5f;
	_tmp94_.alpha = (gfloat) 1;
	memset (&_tmp95_, 0, sizeof (GskColorStop));
	_tmp95_.offset = (gfloat) 0;
	_tmp95_.color = _tmp94_;
	_tmp96_.red = (gfloat) 1;
	_tmp96_.green = (gfloat) 0;
	_tmp96_.blue = (gfloat) 0;
	_tmp96_.alpha = (gfloat) 1;
	memset (&_tmp97_, 0, sizeof (GskColorStop));
	_tmp97_.offset = 0.1f;
	_tmp97_.color = _tmp96_;
	_tmp98_.red = 0.1f;
	_tmp98_.green = (gfloat) 0;
	_tmp98_.blue = (gfloat) 0;
	_tmp98_.alpha = (gfloat) 1;
	memset (&_tmp99_, 0, sizeof (GskColorStop));
	_tmp99_.offset = (gfloat) 1;
	_tmp99_.color = _tmp98_;
	_tmp100_ = g_new0 (GskColorStop, 3);
	_tmp100_[0] = _tmp95_;
	_tmp100_[1] = _tmp97_;
	_tmp100_[2] = _tmp99_;
	_tmp101_ = _tmp100_;
	_tmp101__length1 = 3;
	gtk_snapshot_append_radial_gradient (s, &_tmp92_, &_tmp93_, ((gfloat) radius) / 80.0f, ((gfloat) radius) / 80.0f, (gfloat) 0, (gfloat) 100, _tmp101_, (gsize) 3);
	_tmp101_ = (g_free (_tmp101_), NULL);
	gtk_snapshot_pop (s);
	_tmp102_ = gsk_path_builder_new ();
	right_stalk = _tmp102_;
	_tmp103_.x = x + 1.45;
	_tmp103_.y = y + 1.0;
	_tmp103_.z = 1.0;
	nibbles_view_view3_d_to_view_plain (v, &_tmp103_, &_tmp104_, &_tmp105_);
	cx[0] = _tmp104_;
	cy[0] = _tmp105_;
	_tmp106_.x = x + 1.45;
	_tmp106_.y = y + 1.0;
	_tmp106_.z = 2.0;
	nibbles_view_view3_d_to_view_plain (v, &_tmp106_, &_tmp107_, &_tmp108_);
	cx[1] = _tmp107_;
	cy[1] = _tmp108_;
	_tmp109_.x = x + 1.15;
	_tmp109_.y = y + 1.0;
	_tmp109_.z = 2.0;
	nibbles_view_view3_d_to_view_plain (v, &_tmp109_, &_tmp110_, &_tmp111_);
	cx[2] = _tmp110_;
	cy[2] = _tmp111_;
	_tmp112_ = cx[0];
	_tmp113_ = cy[0];
	gsk_path_builder_move_to (right_stalk, (gfloat) _tmp112_, (gfloat) _tmp113_);
	_tmp114_ = cx[0];
	_tmp115_ = cy[0];
	_tmp116_ = cx[1];
	_tmp117_ = cy[1];
	_tmp118_ = cx[2];
	_tmp119_ = cy[2];
	gsk_path_builder_cubic_to (right_stalk, (gfloat) _tmp114_, (gfloat) _tmp115_, (gfloat) _tmp116_, (gfloat) _tmp117_, (gfloat) _tmp118_, (gfloat) _tmp119_);
	_tmp120_.x = x + 1.25;
	_tmp120_.y = y + 1.0;
	_tmp120_.z = 2.0;
	nibbles_view_view3_d_to_view_plain (v, &_tmp120_, &_tmp121_, &_tmp122_);
	cx[0] = _tmp121_;
	cy[0] = _tmp122_;
	_tmp123_.x = x + 1.55;
	_tmp123_.y = y + 1.0;
	_tmp123_.z = 2.0;
	nibbles_view_view3_d_to_view_plain (v, &_tmp123_, &_tmp124_, &_tmp125_);
	cx[1] = _tmp124_;
	cy[1] = _tmp125_;
	_tmp126_.x = x + 1.55;
	_tmp126_.y = y + 1.0;
	_tmp126_.z = 1.0;
	nibbles_view_view3_d_to_view_plain (v, &_tmp126_, &_tmp127_, &_tmp128_);
	cx[2] = _tmp127_;
	cy[2] = _tmp128_;
	_tmp129_ = cx[0];
	_tmp130_ = cy[0];
	_tmp131_ = cx[1];
	_tmp132_ = cy[1];
	_tmp133_ = cx[2];
	_tmp134_ = cy[2];
	gsk_path_builder_cubic_to (right_stalk, (gfloat) _tmp129_, (gfloat) _tmp130_, (gfloat) _tmp131_, (gfloat) _tmp132_, (gfloat) _tmp133_, (gfloat) _tmp134_);
	_tmp135_ = gsk_path_builder_to_path (right_stalk);
	_tmp136_ = _tmp135_;
	_tmp137_.red = 0.5f;
	_tmp137_.green = 0.5f;
	_tmp137_.blue = 0.0f;
	_tmp137_.alpha = 1.0f;
	gtk_snapshot_append_fill (s, _tmp136_, GSK_FILL_RULE_EVEN_ODD, &_tmp137_);
	_gsk_path_unref0 (_tmp136_);
	_tmp138_ = gsk_path_builder_new ();
	leaf = _tmp138_;
	_tmp139_.x = x + 1.20;
	_tmp139_.y = y + 1.0;
	_tmp139_.z = 2.0;
	nibbles_view_view3_d_to_view_plain (v, &_tmp139_, &_tmp140_, &_tmp141_);
	cx[0] = _tmp140_;
	cy[0] = _tmp141_;
	_tmp142_.x = (x + 1.20) - 0.5;
	_tmp142_.y = y + 1.0;
	_tmp142_.z = 2.0;
	nibbles_view_view3_d_to_view_plain (v, &_tmp142_, &_tmp143_, &_tmp144_);
	cx[1] = _tmp143_;
	cy[1] = _tmp144_;
	_tmp145_.x = (x + 1.20) - 0.5;
	_tmp145_.y = (y + 1.0) - 0.5;
	_tmp145_.z = 2.0;
	nibbles_view_view3_d_to_view_plain (v, &_tmp145_, &_tmp146_, &_tmp147_);
	cx[2] = _tmp146_;
	cy[2] = _tmp147_;
	_tmp148_ = cx[0];
	_tmp149_ = cy[0];
	gsk_path_builder_move_to (leaf, (gfloat) _tmp148_, (gfloat) _tmp149_);
	_tmp150_ = cx[0];
	_tmp151_ = cy[0];
	_tmp152_ = cx[1];
	_tmp153_ = cy[1];
	_tmp154_ = cx[2];
	_tmp155_ = cy[2];
	gsk_path_builder_cubic_to (leaf, (gfloat) _tmp150_, (gfloat) _tmp151_, (gfloat) _tmp152_, (gfloat) _tmp153_, (gfloat) _tmp154_, (gfloat) _tmp155_);
	_tmp156_.x = (x + 1.20) - 0.5;
	_tmp156_.y = (y + 1.0) - 0.5;
	_tmp156_.z = 2.0;
	nibbles_view_view3_d_to_view_plain (v, &_tmp156_, &_tmp157_, &_tmp158_);
	cx[0] = _tmp157_;
	cy[0] = _tmp158_;
	_tmp159_.x = x + 1.20;
	_tmp159_.y = (y + 1.0) - 0.5;
	_tmp159_.z = 2.0;
	nibbles_view_view3_d_to_view_plain (v, &_tmp159_, &_tmp160_, &_tmp161_);
	cx[1] = _tmp160_;
	cy[1] = _tmp161_;
	_tmp162_.x = x + 1.20;
	_tmp162_.y = y + 1.0;
	_tmp162_.z = 2.0;
	nibbles_view_view3_d_to_view_plain (v, &_tmp162_, &_tmp163_, &_tmp164_);
	cx[2] = _tmp163_;
	cy[2] = _tmp164_;
	_tmp165_ = cx[0];
	_tmp166_ = cy[0];
	_tmp167_ = cx[1];
	_tmp168_ = cy[1];
	_tmp169_ = cx[2];
	_tmp170_ = cy[2];
	gsk_path_builder_cubic_to (leaf, (gfloat) _tmp165_, (gfloat) _tmp166_, (gfloat) _tmp167_, (gfloat) _tmp168_, (gfloat) _tmp169_, (gfloat) _tmp170_);
	_tmp171_ = gsk_path_builder_to_path (leaf);
	_tmp172_ = _tmp171_;
	_tmp173_.red = 0.0f;
	_tmp173_.green = 0.75f;
	_tmp173_.blue = 0.0f;
	_tmp173_.alpha = 1.0f;
	gtk_snapshot_append_fill (s, _tmp172_, GSK_FILL_RULE_EVEN_ODD, &_tmp173_);
	_gsk_path_unref0 (_tmp172_);
	_gsk_path_builder_unref0 (leaf);
	_gsk_path_builder_unref0 (right_stalk);
	_gsk_path_unref0 (right_cherry);
	_gsk_path_builder_unref0 (left_stalk);
	_gsk_path_unref0 (left_cherry);
}

static void
nibbles_view_draw_apple (NibblesView* self,
                         GtkSnapshot* s,
                         NibblesViewView3D* v,
                         gdouble x,
                         gdouble y)
{
	gdouble cx[3] = {0};
	gdouble cy[3] = {0};
	gdouble top_x = 0.0;
	gdouble top_y = 0.0;
	GskPathBuilder* apple = NULL;
	GskPathBuilder* _tmp0_;
	NibblesViewPoint3D _tmp1_ = {0};
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	NibblesViewPoint3D _tmp4_ = {0};
	gdouble _tmp5_ = 0.0;
	gdouble _tmp6_ = 0.0;
	NibblesViewPoint3D _tmp7_ = {0};
	gdouble _tmp8_ = 0.0;
	gdouble _tmp9_ = 0.0;
	GskPathBuilder* _tmp10_;
	gdouble _tmp11_;
	gdouble _tmp12_;
	GskPathBuilder* _tmp13_;
	gdouble _tmp14_;
	gdouble _tmp15_;
	gdouble _tmp16_;
	gdouble _tmp17_;
	gdouble _tmp18_;
	gdouble _tmp19_;
	NibblesViewPoint3D _tmp20_ = {0};
	gdouble _tmp21_ = 0.0;
	gdouble _tmp22_ = 0.0;
	NibblesViewPoint3D _tmp23_ = {0};
	gdouble _tmp24_ = 0.0;
	gdouble _tmp25_ = 0.0;
	NibblesViewPoint3D _tmp26_ = {0};
	gdouble _tmp27_ = 0.0;
	gdouble _tmp28_ = 0.0;
	GskPathBuilder* _tmp29_;
	gdouble _tmp30_;
	gdouble _tmp31_;
	gdouble _tmp32_;
	gdouble _tmp33_;
	gdouble _tmp34_;
	gdouble _tmp35_;
	NibblesViewPoint3D _tmp36_ = {0};
	gdouble _tmp37_ = 0.0;
	gdouble _tmp38_ = 0.0;
	NibblesViewPoint3D _tmp39_ = {0};
	gdouble _tmp40_ = 0.0;
	gdouble _tmp41_ = 0.0;
	NibblesViewPoint3D _tmp42_ = {0};
	gdouble _tmp43_ = 0.0;
	gdouble _tmp44_ = 0.0;
	GskPathBuilder* _tmp45_;
	gdouble _tmp46_;
	gdouble _tmp47_;
	gdouble _tmp48_;
	gdouble _tmp49_;
	gdouble _tmp50_;
	gdouble _tmp51_;
	NibblesViewPoint3D _tmp52_ = {0};
	gdouble _tmp53_ = 0.0;
	gdouble _tmp54_ = 0.0;
	NibblesViewPoint3D _tmp55_ = {0};
	gdouble _tmp56_ = 0.0;
	gdouble _tmp57_ = 0.0;
	NibblesViewPoint3D _tmp58_ = {0};
	gdouble _tmp59_ = 0.0;
	gdouble _tmp60_ = 0.0;
	GskPathBuilder* _tmp61_;
	gdouble _tmp62_;
	gdouble _tmp63_;
	gdouble _tmp64_;
	gdouble _tmp65_;
	gdouble _tmp66_;
	gdouble _tmp67_;
	NibblesViewPoint3D _tmp68_ = {0};
	gdouble _tmp69_ = 0.0;
	gdouble _tmp70_ = 0.0;
	gdouble radius = 0.0;
	NibblesViewPoint3D _tmp71_ = {0};
	NibblesViewPoint3D _tmp72_ = {0};
	GskPath* path = NULL;
	GskPathBuilder* _tmp73_;
	GskPath* _tmp74_;
	GskPath* _tmp75_;
	GskPath* _tmp76_;
	graphene_rect_t _tmp77_ = {0};
	graphene_point_t _tmp78_ = {0};
	GdkRGBA _tmp79_ = {0};
	GskColorStop _tmp80_ = {0};
	GdkRGBA _tmp81_ = {0};
	GskColorStop _tmp82_ = {0};
	GdkRGBA _tmp83_ = {0};
	GskColorStop _tmp84_ = {0};
	GskColorStop* _tmp85_;
	GskColorStop* _tmp86_;
	gint _tmp86__length1;
	GskPathBuilder* left_leaf = NULL;
	GskPathBuilder* _tmp160_;
	NibblesViewPoint3D _tmp161_ = {0};
	gdouble _tmp162_ = 0.0;
	gdouble _tmp163_ = 0.0;
	NibblesViewPoint3D _tmp164_ = {0};
	gdouble _tmp165_ = 0.0;
	gdouble _tmp166_ = 0.0;
	NibblesViewPoint3D _tmp167_ = {0};
	gdouble _tmp168_ = 0.0;
	gdouble _tmp169_ = 0.0;
	gdouble _tmp170_;
	gdouble _tmp171_;
	gdouble _tmp172_;
	gdouble _tmp173_;
	gdouble _tmp174_;
	gdouble _tmp175_;
	gdouble _tmp176_;
	gdouble _tmp177_;
	NibblesViewPoint3D _tmp178_ = {0};
	gdouble _tmp179_ = 0.0;
	gdouble _tmp180_ = 0.0;
	NibblesViewPoint3D _tmp181_ = {0};
	gdouble _tmp182_ = 0.0;
	gdouble _tmp183_ = 0.0;
	NibblesViewPoint3D _tmp184_ = {0};
	gdouble _tmp185_ = 0.0;
	gdouble _tmp186_ = 0.0;
	gdouble _tmp187_;
	gdouble _tmp188_;
	gdouble _tmp189_;
	gdouble _tmp190_;
	gdouble _tmp191_;
	gdouble _tmp192_;
	GskPath* _tmp193_;
	GskPath* _tmp194_;
	GdkRGBA _tmp195_ = {0};
	GskPathBuilder* right_leaf = NULL;
	GskPathBuilder* _tmp196_;
	NibblesViewPoint3D _tmp197_ = {0};
	gdouble _tmp198_ = 0.0;
	gdouble _tmp199_ = 0.0;
	NibblesViewPoint3D _tmp200_ = {0};
	gdouble _tmp201_ = 0.0;
	gdouble _tmp202_ = 0.0;
	NibblesViewPoint3D _tmp203_ = {0};
	gdouble _tmp204_ = 0.0;
	gdouble _tmp205_ = 0.0;
	gdouble _tmp206_;
	gdouble _tmp207_;
	gdouble _tmp208_;
	gdouble _tmp209_;
	gdouble _tmp210_;
	gdouble _tmp211_;
	gdouble _tmp212_;
	gdouble _tmp213_;
	NibblesViewPoint3D _tmp214_ = {0};
	gdouble _tmp215_ = 0.0;
	gdouble _tmp216_ = 0.0;
	NibblesViewPoint3D _tmp217_ = {0};
	gdouble _tmp218_ = 0.0;
	gdouble _tmp219_ = 0.0;
	NibblesViewPoint3D _tmp220_ = {0};
	gdouble _tmp221_ = 0.0;
	gdouble _tmp222_ = 0.0;
	gdouble _tmp223_;
	gdouble _tmp224_;
	gdouble _tmp225_;
	gdouble _tmp226_;
	gdouble _tmp227_;
	gdouble _tmp228_;
	GskPath* _tmp229_;
	GskPath* _tmp230_;
	GdkRGBA _tmp231_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	g_return_if_fail (v != NULL);
	_tmp0_ = gsk_path_builder_new ();
	apple = _tmp0_;
	_tmp1_.x = x + 0;
	_tmp1_.y = y + 1;
	_tmp1_.z = (gdouble) 1;
	nibbles_view_view3_d_to_view_plain (v, &_tmp1_, &_tmp2_, &_tmp3_);
	cx[0] = _tmp2_;
	cy[0] = _tmp3_;
	_tmp4_.x = x + 0;
	_tmp4_.y = y + 1;
	_tmp4_.z = (gdouble) 0;
	nibbles_view_view3_d_to_view_plain (v, &_tmp4_, &_tmp5_, &_tmp6_);
	cx[1] = _tmp5_;
	cy[1] = _tmp6_;
	_tmp7_.x = x + 1;
	_tmp7_.y = y + 1;
	_tmp7_.z = (gdouble) 0;
	nibbles_view_view3_d_to_view_plain (v, &_tmp7_, &_tmp8_, &_tmp9_);
	cx[2] = _tmp8_;
	cy[2] = _tmp9_;
	_tmp10_ = apple;
	_tmp11_ = cx[0];
	_tmp12_ = cy[0];
	gsk_path_builder_move_to (_tmp10_, (gfloat) _tmp11_, (gfloat) _tmp12_);
	_tmp13_ = apple;
	_tmp14_ = cx[0];
	_tmp15_ = cy[0];
	_tmp16_ = cx[1];
	_tmp17_ = cy[1];
	_tmp18_ = cx[2];
	_tmp19_ = cy[2];
	gsk_path_builder_cubic_to (_tmp13_, (gfloat) _tmp14_, (gfloat) _tmp15_, (gfloat) _tmp16_, (gfloat) _tmp17_, (gfloat) _tmp18_, (gfloat) _tmp19_);
	_tmp20_.x = x + 1;
	_tmp20_.y = y + 1;
	_tmp20_.z = (gdouble) 0;
	nibbles_view_view3_d_to_view_plain (v, &_tmp20_, &_tmp21_, &_tmp22_);
	cx[0] = _tmp21_;
	cy[0] = _tmp22_;
	_tmp23_.x = x + 2;
	_tmp23_.y = y + 1;
	_tmp23_.z = (gdouble) 0;
	nibbles_view_view3_d_to_view_plain (v, &_tmp23_, &_tmp24_, &_tmp25_);
	cx[1] = _tmp24_;
	cy[1] = _tmp25_;
	_tmp26_.x = x + 2;
	_tmp26_.y = y + 1;
	_tmp26_.z = (gdouble) 1;
	nibbles_view_view3_d_to_view_plain (v, &_tmp26_, &_tmp27_, &_tmp28_);
	cx[2] = _tmp27_;
	cy[2] = _tmp28_;
	_tmp29_ = apple;
	_tmp30_ = cx[0];
	_tmp31_ = cy[0];
	_tmp32_ = cx[1];
	_tmp33_ = cy[1];
	_tmp34_ = cx[2];
	_tmp35_ = cy[2];
	gsk_path_builder_cubic_to (_tmp29_, (gfloat) _tmp30_, (gfloat) _tmp31_, (gfloat) _tmp32_, (gfloat) _tmp33_, (gfloat) _tmp34_, (gfloat) _tmp35_);
	_tmp36_.x = x + 2;
	_tmp36_.y = y + 1;
	_tmp36_.z = (gdouble) 1;
	nibbles_view_view3_d_to_view_plain (v, &_tmp36_, &_tmp37_, &_tmp38_);
	cx[0] = _tmp37_;
	cy[0] = _tmp38_;
	_tmp39_.x = x + 2;
	_tmp39_.y = y + 1.0;
	_tmp39_.z = (gdouble) 2;
	nibbles_view_view3_d_to_view_plain (v, &_tmp39_, &_tmp40_, &_tmp41_);
	cx[1] = _tmp40_;
	cy[1] = _tmp41_;
	_tmp42_.x = x + 1.0;
	_tmp42_.y = y + 1;
	_tmp42_.z = (gdouble) 2;
	nibbles_view_view3_d_to_view_plain (v, &_tmp42_, &_tmp43_, &_tmp44_);
	cx[2] = _tmp43_;
	cy[2] = _tmp44_;
	_tmp45_ = apple;
	_tmp46_ = cx[0];
	_tmp47_ = cy[0];
	_tmp48_ = cx[1];
	_tmp49_ = cy[1];
	_tmp50_ = cx[2];
	_tmp51_ = cy[2];
	gsk_path_builder_cubic_to (_tmp45_, (gfloat) _tmp46_, (gfloat) _tmp47_, (gfloat) _tmp48_, (gfloat) _tmp49_, (gfloat) _tmp50_, (gfloat) _tmp51_);
	_tmp52_.x = x + 1.0;
	_tmp52_.y = y + 1;
	_tmp52_.z = (gdouble) 2;
	nibbles_view_view3_d_to_view_plain (v, &_tmp52_, &_tmp53_, &_tmp54_);
	cx[0] = _tmp53_;
	cy[0] = _tmp54_;
	_tmp55_.x = x + 0;
	_tmp55_.y = y + 1;
	_tmp55_.z = (gdouble) 2;
	nibbles_view_view3_d_to_view_plain (v, &_tmp55_, &_tmp56_, &_tmp57_);
	cx[1] = _tmp56_;
	cy[1] = _tmp57_;
	_tmp58_.x = x + 0;
	_tmp58_.y = y + 1;
	_tmp58_.z = (gdouble) 1;
	nibbles_view_view3_d_to_view_plain (v, &_tmp58_, &_tmp59_, &_tmp60_);
	cx[2] = _tmp59_;
	cy[2] = _tmp60_;
	_tmp61_ = apple;
	_tmp62_ = cx[0];
	_tmp63_ = cy[0];
	_tmp64_ = cx[1];
	_tmp65_ = cy[1];
	_tmp66_ = cx[2];
	_tmp67_ = cy[2];
	gsk_path_builder_cubic_to (_tmp61_, (gfloat) _tmp62_, (gfloat) _tmp63_, (gfloat) _tmp64_, (gfloat) _tmp65_, (gfloat) _tmp66_, (gfloat) _tmp67_);
	_tmp68_.x = x + 1;
	_tmp68_.y = y + 1.0;
	_tmp68_.z = 1.5;
	nibbles_view_view3_d_to_view_plain (v, &_tmp68_, &_tmp69_, &_tmp70_);
	top_x = _tmp69_;
	top_y = _tmp70_;
	_tmp71_.x = x + 1;
	_tmp71_.y = y + 1.0;
	_tmp71_.z = 1.5;
	_tmp72_.x = x + 1;
	_tmp72_.y = y + 1.0;
	_tmp72_.z = (gdouble) 0;
	radius = nibbles_view_view3_d_2D_diff (v, &_tmp71_, &_tmp72_);
	_tmp73_ = apple;
	_tmp74_ = gsk_path_builder_to_path (_tmp73_);
	path = _tmp74_;
	_tmp75_ = path;
	gtk_snapshot_push_fill (s, _tmp75_, GSK_FILL_RULE_EVEN_ODD);
	_tmp76_ = path;
	nibbles_view_get_bounds (self, _tmp76_, &_tmp77_);
	_tmp78_.x = (gfloat) top_x;
	_tmp78_.y = (gfloat) top_y;
	_tmp79_.red = 0.5f;
	_tmp79_.green = (gfloat) 1;
	_tmp79_.blue = 0.5f;
	_tmp79_.alpha = (gfloat) 1;
	memset (&_tmp80_, 0, sizeof (GskColorStop));
	_tmp80_.offset = (gfloat) 0;
	_tmp80_.color = _tmp79_;
	_tmp81_.red = (gfloat) 0;
	_tmp81_.green = (gfloat) 1;
	_tmp81_.blue = (gfloat) 0;
	_tmp81_.alpha = (gfloat) 1;
	memset (&_tmp82_, 0, sizeof (GskColorStop));
	_tmp82_.offset = 0.1f;
	_tmp82_.color = _tmp81_;
	_tmp83_.red = (gfloat) 0;
	_tmp83_.green = 0.1f;
	_tmp83_.blue = (gfloat) 0;
	_tmp83_.alpha = (gfloat) 1;
	memset (&_tmp84_, 0, sizeof (GskColorStop));
	_tmp84_.offset = (gfloat) 1;
	_tmp84_.color = _tmp83_;
	_tmp85_ = g_new0 (GskColorStop, 3);
	_tmp85_[0] = _tmp80_;
	_tmp85_[1] = _tmp82_;
	_tmp85_[2] = _tmp84_;
	_tmp86_ = _tmp85_;
	_tmp86__length1 = 3;
	gtk_snapshot_append_radial_gradient (s, &_tmp77_, &_tmp78_, ((gfloat) radius) / 80.0f, ((gfloat) radius) / 80.0f, (gfloat) 0, (gfloat) 100, _tmp86_, (gsize) 3);
	_tmp86_ = (g_free (_tmp86_), NULL);
	gtk_snapshot_pop (s);
	{
		gdouble _3D_radius_ = 0.0;
		_3D_radius_ = 0.2;
		{
			gboolean _tmp87_ = FALSE;
			_tmp87_ = TRUE;
			while (TRUE) {
				GskPathBuilder* _tmp88_;
				NibblesViewPoint3D _tmp89_ = {0};
				gdouble _tmp90_ = 0.0;
				gdouble _tmp91_ = 0.0;
				NibblesViewPoint3D _tmp92_ = {0};
				gdouble _tmp93_ = 0.0;
				gdouble _tmp94_ = 0.0;
				NibblesViewPoint3D _tmp95_ = {0};
				gdouble _tmp96_ = 0.0;
				gdouble _tmp97_ = 0.0;
				GskPathBuilder* _tmp98_;
				gdouble _tmp99_;
				gdouble _tmp100_;
				GskPathBuilder* _tmp101_;
				gdouble _tmp102_;
				gdouble _tmp103_;
				gdouble _tmp104_;
				gdouble _tmp105_;
				gdouble _tmp106_;
				gdouble _tmp107_;
				NibblesViewPoint3D _tmp108_ = {0};
				gdouble _tmp109_ = 0.0;
				gdouble _tmp110_ = 0.0;
				NibblesViewPoint3D _tmp111_ = {0};
				gdouble _tmp112_ = 0.0;
				gdouble _tmp113_ = 0.0;
				NibblesViewPoint3D _tmp114_ = {0};
				gdouble _tmp115_ = 0.0;
				gdouble _tmp116_ = 0.0;
				GskPathBuilder* _tmp117_;
				gdouble _tmp118_;
				gdouble _tmp119_;
				gdouble _tmp120_;
				gdouble _tmp121_;
				gdouble _tmp122_;
				gdouble _tmp123_;
				NibblesViewPoint3D _tmp124_ = {0};
				gdouble _tmp125_ = 0.0;
				gdouble _tmp126_ = 0.0;
				NibblesViewPoint3D _tmp127_ = {0};
				gdouble _tmp128_ = 0.0;
				gdouble _tmp129_ = 0.0;
				NibblesViewPoint3D _tmp130_ = {0};
				gdouble _tmp131_ = 0.0;
				gdouble _tmp132_ = 0.0;
				GskPathBuilder* _tmp133_;
				gdouble _tmp134_;
				gdouble _tmp135_;
				gdouble _tmp136_;
				gdouble _tmp137_;
				gdouble _tmp138_;
				gdouble _tmp139_;
				NibblesViewPoint3D _tmp140_ = {0};
				gdouble _tmp141_ = 0.0;
				gdouble _tmp142_ = 0.0;
				NibblesViewPoint3D _tmp143_ = {0};
				gdouble _tmp144_ = 0.0;
				gdouble _tmp145_ = 0.0;
				NibblesViewPoint3D _tmp146_ = {0};
				gdouble _tmp147_ = 0.0;
				gdouble _tmp148_ = 0.0;
				GskPathBuilder* _tmp149_;
				gdouble _tmp150_;
				gdouble _tmp151_;
				gdouble _tmp152_;
				gdouble _tmp153_;
				gdouble _tmp154_;
				gdouble _tmp155_;
				GskPathBuilder* _tmp156_;
				GskPath* _tmp157_;
				GskPath* _tmp158_;
				GdkRGBA _tmp159_ = {0};
				if (!_tmp87_) {
					_3D_radius_ -= 0.01;
				}
				_tmp87_ = FALSE;
				if (!(_3D_radius_ > 0.01)) {
					break;
				}
				_tmp88_ = gsk_path_builder_new ();
				_gsk_path_builder_unref0 (apple);
				apple = _tmp88_;
				_tmp89_.x = x + (1 - _3D_radius_);
				_tmp89_.y = y + 1.0;
				_tmp89_.z = 1.75;
				nibbles_view_view3_d_to_view_plain (v, &_tmp89_, &_tmp90_, &_tmp91_);
				cx[0] = _tmp90_;
				cy[0] = _tmp91_;
				_tmp92_.x = x + (1 - _3D_radius_);
				_tmp92_.y = y + (1 - _3D_radius_);
				_tmp92_.z = 1.75;
				nibbles_view_view3_d_to_view_plain (v, &_tmp92_, &_tmp93_, &_tmp94_);
				cx[1] = _tmp93_;
				cy[1] = _tmp94_;
				_tmp95_.x = x + 1.00;
				_tmp95_.y = y + (1 - _3D_radius_);
				_tmp95_.z = 1.75;
				nibbles_view_view3_d_to_view_plain (v, &_tmp95_, &_tmp96_, &_tmp97_);
				cx[2] = _tmp96_;
				cy[2] = _tmp97_;
				_tmp98_ = apple;
				_tmp99_ = cx[0];
				_tmp100_ = cy[0];
				gsk_path_builder_move_to (_tmp98_, (gfloat) _tmp99_, (gfloat) _tmp100_);
				_tmp101_ = apple;
				_tmp102_ = cx[0];
				_tmp103_ = cy[0];
				_tmp104_ = cx[1];
				_tmp105_ = cy[1];
				_tmp106_ = cx[2];
				_tmp107_ = cy[2];
				gsk_path_builder_cubic_to (_tmp101_, (gfloat) _tmp102_, (gfloat) _tmp103_, (gfloat) _tmp104_, (gfloat) _tmp105_, (gfloat) _tmp106_, (gfloat) _tmp107_);
				_tmp108_.x = x + 1.00;
				_tmp108_.y = y + (1 - _3D_radius_);
				_tmp108_.z = 1.75;
				nibbles_view_view3_d_to_view_plain (v, &_tmp108_, &_tmp109_, &_tmp110_);
				cx[0] = _tmp109_;
				cy[0] = _tmp110_;
				_tmp111_.x = x + (1 + _3D_radius_);
				_tmp111_.y = y + (1 - _3D_radius_);
				_tmp111_.z = 1.75;
				nibbles_view_view3_d_to_view_plain (v, &_tmp111_, &_tmp112_, &_tmp113_);
				cx[1] = _tmp112_;
				cy[1] = _tmp113_;
				_tmp114_.x = x + (1 + _3D_radius_);
				_tmp114_.y = y + 1.0;
				_tmp114_.z = 1.75;
				nibbles_view_view3_d_to_view_plain (v, &_tmp114_, &_tmp115_, &_tmp116_);
				cx[2] = _tmp115_;
				cy[2] = _tmp116_;
				_tmp117_ = apple;
				_tmp118_ = cx[0];
				_tmp119_ = cy[0];
				_tmp120_ = cx[1];
				_tmp121_ = cy[1];
				_tmp122_ = cx[2];
				_tmp123_ = cy[2];
				gsk_path_builder_cubic_to (_tmp117_, (gfloat) _tmp118_, (gfloat) _tmp119_, (gfloat) _tmp120_, (gfloat) _tmp121_, (gfloat) _tmp122_, (gfloat) _tmp123_);
				_tmp124_.x = x + (1 + _3D_radius_);
				_tmp124_.y = y + 1.0;
				_tmp124_.z = 1.75;
				nibbles_view_view3_d_to_view_plain (v, &_tmp124_, &_tmp125_, &_tmp126_);
				cx[0] = _tmp125_;
				cy[0] = _tmp126_;
				_tmp127_.x = x + (1 + _3D_radius_);
				_tmp127_.y = y + (1 + _3D_radius_);
				_tmp127_.z = 1.75;
				nibbles_view_view3_d_to_view_plain (v, &_tmp127_, &_tmp128_, &_tmp129_);
				cx[1] = _tmp128_;
				cy[1] = _tmp129_;
				_tmp130_.x = x + 1;
				_tmp130_.y = y + (1 + _3D_radius_);
				_tmp130_.z = 1.75;
				nibbles_view_view3_d_to_view_plain (v, &_tmp130_, &_tmp131_, &_tmp132_);
				cx[2] = _tmp131_;
				cy[2] = _tmp132_;
				_tmp133_ = apple;
				_tmp134_ = cx[0];
				_tmp135_ = cy[0];
				_tmp136_ = cx[1];
				_tmp137_ = cy[1];
				_tmp138_ = cx[2];
				_tmp139_ = cy[2];
				gsk_path_builder_cubic_to (_tmp133_, (gfloat) _tmp134_, (gfloat) _tmp135_, (gfloat) _tmp136_, (gfloat) _tmp137_, (gfloat) _tmp138_, (gfloat) _tmp139_);
				_tmp140_.x = x + 1;
				_tmp140_.y = y + (1 + _3D_radius_);
				_tmp140_.z = 1.75;
				nibbles_view_view3_d_to_view_plain (v, &_tmp140_, &_tmp141_, &_tmp142_);
				cx[0] = _tmp141_;
				cy[0] = _tmp142_;
				_tmp143_.x = x + (1 - _3D_radius_);
				_tmp143_.y = y + (1 + _3D_radius_);
				_tmp143_.z = 1.75;
				nibbles_view_view3_d_to_view_plain (v, &_tmp143_, &_tmp144_, &_tmp145_);
				cx[1] = _tmp144_;
				cy[1] = _tmp145_;
				_tmp146_.x = x + (1 - _3D_radius_);
				_tmp146_.y = y + 1.0;
				_tmp146_.z = 1.75;
				nibbles_view_view3_d_to_view_plain (v, &_tmp146_, &_tmp147_, &_tmp148_);
				cx[2] = _tmp147_;
				cy[2] = _tmp148_;
				_tmp149_ = apple;
				_tmp150_ = cx[0];
				_tmp151_ = cy[0];
				_tmp152_ = cx[1];
				_tmp153_ = cy[1];
				_tmp154_ = cx[2];
				_tmp155_ = cy[2];
				gsk_path_builder_cubic_to (_tmp149_, (gfloat) _tmp150_, (gfloat) _tmp151_, (gfloat) _tmp152_, (gfloat) _tmp153_, (gfloat) _tmp154_, (gfloat) _tmp155_);
				_tmp156_ = apple;
				_tmp157_ = gsk_path_builder_to_path (_tmp156_);
				_tmp158_ = _tmp157_;
				_tmp159_.red = 0.4f;
				_tmp159_.green = 0.8f - ((0.2f - ((gfloat) _3D_radius_)) * 3);
				_tmp159_.blue = 0.4f - ((0.2f - ((gfloat) _3D_radius_)) * 2);
				_tmp159_.alpha = 1.0f;
				gtk_snapshot_append_fill (s, _tmp158_, GSK_FILL_RULE_EVEN_ODD, &_tmp159_);
				_gsk_path_unref0 (_tmp158_);
			}
		}
	}
	_tmp160_ = gsk_path_builder_new ();
	left_leaf = _tmp160_;
	_tmp161_.x = x + 1.0;
	_tmp161_.y = y + 1.0;
	_tmp161_.z = 1.75;
	nibbles_view_view3_d_to_view_plain (v, &_tmp161_, &_tmp162_, &_tmp163_);
	cx[0] = _tmp162_;
	cy[0] = _tmp163_;
	_tmp164_.x = (x + 1.0) - 0.5;
	_tmp164_.y = y + 1.0;
	_tmp164_.z = 1.75;
	nibbles_view_view3_d_to_view_plain (v, &_tmp164_, &_tmp165_, &_tmp166_);
	cx[1] = _tmp165_;
	cy[1] = _tmp166_;
	_tmp167_.x = (x + 1.0) - 0.5;
	_tmp167_.y = (y + 1.0) - 0.5;
	_tmp167_.z = 1.75;
	nibbles_view_view3_d_to_view_plain (v, &_tmp167_, &_tmp168_, &_tmp169_);
	cx[2] = _tmp168_;
	cy[2] = _tmp169_;
	_tmp170_ = cx[0];
	_tmp171_ = cy[0];
	gsk_path_builder_move_to (left_leaf, (gfloat) _tmp170_, (gfloat) _tmp171_);
	_tmp172_ = cx[0];
	_tmp173_ = cy[0];
	_tmp174_ = cx[1];
	_tmp175_ = cy[1];
	_tmp176_ = cx[2];
	_tmp177_ = cy[2];
	gsk_path_builder_cubic_to (left_leaf, (gfloat) _tmp172_, (gfloat) _tmp173_, (gfloat) _tmp174_, (gfloat) _tmp175_, (gfloat) _tmp176_, (gfloat) _tmp177_);
	_tmp178_.x = (x + 1.0) - 0.5;
	_tmp178_.y = (y + 1.0) - 0.5;
	_tmp178_.z = 1.75;
	nibbles_view_view3_d_to_view_plain (v, &_tmp178_, &_tmp179_, &_tmp180_);
	cx[0] = _tmp179_;
	cy[0] = _tmp180_;
	_tmp181_.x = x + 1.0;
	_tmp181_.y = (y + 1.0) - 0.5;
	_tmp181_.z = 1.75;
	nibbles_view_view3_d_to_view_plain (v, &_tmp181_, &_tmp182_, &_tmp183_);
	cx[1] = _tmp182_;
	cy[1] = _tmp183_;
	_tmp184_.x = x + 1.0;
	_tmp184_.y = y + 1.0;
	_tmp184_.z = 1.75;
	nibbles_view_view3_d_to_view_plain (v, &_tmp184_, &_tmp185_, &_tmp186_);
	cx[2] = _tmp185_;
	cy[2] = _tmp186_;
	_tmp187_ = cx[0];
	_tmp188_ = cy[0];
	_tmp189_ = cx[1];
	_tmp190_ = cy[1];
	_tmp191_ = cx[2];
	_tmp192_ = cy[2];
	gsk_path_builder_cubic_to (left_leaf, (gfloat) _tmp187_, (gfloat) _tmp188_, (gfloat) _tmp189_, (gfloat) _tmp190_, (gfloat) _tmp191_, (gfloat) _tmp192_);
	_tmp193_ = gsk_path_builder_to_path (left_leaf);
	_tmp194_ = _tmp193_;
	_tmp195_.red = 0.25f;
	_tmp195_.green = 0.5f;
	_tmp195_.blue = 0.0f;
	_tmp195_.alpha = (gfloat) 1;
	gtk_snapshot_append_fill (s, _tmp194_, GSK_FILL_RULE_EVEN_ODD, &_tmp195_);
	_gsk_path_unref0 (_tmp194_);
	_tmp196_ = gsk_path_builder_new ();
	right_leaf = _tmp196_;
	_tmp197_.x = x + 1.0;
	_tmp197_.y = y + 1.0;
	_tmp197_.z = 1.75;
	nibbles_view_view3_d_to_view_plain (v, &_tmp197_, &_tmp198_, &_tmp199_);
	cx[0] = _tmp198_;
	cy[0] = _tmp199_;
	_tmp200_.x = (x + 1.0) + 0.5;
	_tmp200_.y = y + 1.0;
	_tmp200_.z = 1.75;
	nibbles_view_view3_d_to_view_plain (v, &_tmp200_, &_tmp201_, &_tmp202_);
	cx[1] = _tmp201_;
	cy[1] = _tmp202_;
	_tmp203_.x = (x + 1.0) + 0.5;
	_tmp203_.y = (y + 1.0) - 0.5;
	_tmp203_.z = 1.75;
	nibbles_view_view3_d_to_view_plain (v, &_tmp203_, &_tmp204_, &_tmp205_);
	cx[2] = _tmp204_;
	cy[2] = _tmp205_;
	_tmp206_ = cx[0];
	_tmp207_ = cy[0];
	gsk_path_builder_move_to (right_leaf, (gfloat) _tmp206_, (gfloat) _tmp207_);
	_tmp208_ = cx[0];
	_tmp209_ = cy[0];
	_tmp210_ = cx[1];
	_tmp211_ = cy[1];
	_tmp212_ = cx[2];
	_tmp213_ = cy[2];
	gsk_path_builder_cubic_to (right_leaf, (gfloat) _tmp208_, (gfloat) _tmp209_, (gfloat) _tmp210_, (gfloat) _tmp211_, (gfloat) _tmp212_, (gfloat) _tmp213_);
	_tmp214_.x = (x + 1.0) + 0.5;
	_tmp214_.y = (y + 1.0) - 0.5;
	_tmp214_.z = 1.75;
	nibbles_view_view3_d_to_view_plain (v, &_tmp214_, &_tmp215_, &_tmp216_);
	cx[0] = _tmp215_;
	cy[0] = _tmp216_;
	_tmp217_.x = x + 1.0;
	_tmp217_.y = (y + 1.0) - 0.5;
	_tmp217_.z = 1.75;
	nibbles_view_view3_d_to_view_plain (v, &_tmp217_, &_tmp218_, &_tmp219_);
	cx[1] = _tmp218_;
	cy[1] = _tmp219_;
	_tmp220_.x = x + 1.0;
	_tmp220_.y = y + 1.0;
	_tmp220_.z = 1.75;
	nibbles_view_view3_d_to_view_plain (v, &_tmp220_, &_tmp221_, &_tmp222_);
	cx[2] = _tmp221_;
	cy[2] = _tmp222_;
	_tmp223_ = cx[0];
	_tmp224_ = cy[0];
	_tmp225_ = cx[1];
	_tmp226_ = cy[1];
	_tmp227_ = cx[2];
	_tmp228_ = cy[2];
	gsk_path_builder_cubic_to (right_leaf, (gfloat) _tmp223_, (gfloat) _tmp224_, (gfloat) _tmp225_, (gfloat) _tmp226_, (gfloat) _tmp227_, (gfloat) _tmp228_);
	_tmp229_ = gsk_path_builder_to_path (right_leaf);
	_tmp230_ = _tmp229_;
	_tmp231_.red = 0.0f;
	_tmp231_.green = 0.5f;
	_tmp231_.blue = 0.25f;
	_tmp231_.alpha = (gfloat) 1;
	gtk_snapshot_append_fill (s, _tmp230_, GSK_FILL_RULE_EVEN_ODD, &_tmp231_);
	_gsk_path_unref0 (_tmp230_);
	_gsk_path_builder_unref0 (right_leaf);
	_gsk_path_builder_unref0 (left_leaf);
	_gsk_path_unref0 (path);
	_gsk_path_builder_unref0 (apple);
}

static void
nibbles_view_draw_wall_segment (NibblesView* self,
                                gint i,
                                GtkSnapshot* s,
                                gint x,
                                gint y,
                                gint x_size,
                                gint y_size)
{
	gint x_s13 = 0;
	gint x_remainder = 0;
	gint y_s13 = 0;
	gint y_remainder = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp28_ = FALSE;
	gboolean _tmp29_ = FALSE;
	gboolean _tmp30_ = FALSE;
	gboolean _tmp31_ = FALSE;
	gboolean _tmp32_ = FALSE;
	gboolean _tmp33_ = FALSE;
	gboolean _tmp44_ = FALSE;
	gboolean _tmp45_ = FALSE;
	gboolean _tmp46_ = FALSE;
	gboolean _tmp47_ = FALSE;
	gboolean _tmp48_ = FALSE;
	gboolean _tmp49_ = FALSE;
	gboolean _tmp60_ = FALSE;
	gboolean _tmp61_ = FALSE;
	gboolean _tmp62_ = FALSE;
	gboolean _tmp63_ = FALSE;
	gboolean _tmp64_ = FALSE;
	gboolean _tmp65_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	x_s13 = x_size / 3;
	x_remainder = x_size - (x_s13 * 3);
	y_s13 = y_size / 3;
	y_remainder = y_size - (y_s13 * 3);
	if (i >= ((gint) 'b')) {
		_tmp0_ = i <= ((gint) 'l');
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GskPathBuilder* center_square = NULL;
		GskPathBuilder* _tmp1_;
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		GskPathBuilder* _tmp6_;
		graphene_rect_t _tmp7_ = {0};
		GskPathBuilder* _tmp8_;
		GskPath* _tmp9_;
		GskPath* _tmp10_;
		GdkRGBA _tmp11_ = {0};
		_tmp1_ = gsk_path_builder_new ();
		center_square = _tmp1_;
		if (x_remainder == 2) {
			_tmp2_ = (x_s13 + x) + x_remainder;
		} else {
			_tmp2_ = x_s13 + x;
		}
		if (y_remainder == 2) {
			_tmp3_ = (y_s13 + y) + y_remainder;
		} else {
			_tmp3_ = y_s13 + y;
		}
		if (x_remainder == 2) {
			_tmp4_ = x_s13;
		} else {
			_tmp4_ = x_s13 + x_remainder;
		}
		if (y_remainder == 2) {
			_tmp5_ = y_s13;
		} else {
			_tmp5_ = y_s13 + y_remainder;
		}
		_tmp6_ = center_square;
		_tmp7_.origin = (graphene_point_t) {(gfloat) _tmp2_, (gfloat) _tmp3_};
		_tmp7_.size = (graphene_size_t) {(gfloat) _tmp4_, (gfloat) _tmp5_};
		gsk_path_builder_add_rect (_tmp6_, &_tmp7_);
		_tmp8_ = center_square;
		_tmp9_ = gsk_path_builder_to_path (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_.red = 0.5f;
		_tmp11_.green = 0.5f;
		_tmp11_.blue = 0.5f;
		_tmp11_.alpha = 1.0f;
		gtk_snapshot_append_fill (s, _tmp10_, GSK_FILL_RULE_EVEN_ODD, &_tmp11_);
		_gsk_path_unref0 (_tmp10_);
		_gsk_path_builder_unref0 (center_square);
	}
	if (i == ((gint) 'b')) {
		_tmp17_ = TRUE;
	} else {
		_tmp17_ = i == ((gint) 'd');
	}
	if (_tmp17_) {
		_tmp16_ = TRUE;
	} else {
		_tmp16_ = i == ((gint) 'e');
	}
	if (_tmp16_) {
		_tmp15_ = TRUE;
	} else {
		_tmp15_ = i == ((gint) 'h');
	}
	if (_tmp15_) {
		_tmp14_ = TRUE;
	} else {
		_tmp14_ = i == ((gint) 'i');
	}
	if (_tmp14_) {
		_tmp13_ = TRUE;
	} else {
		_tmp13_ = i == ((gint) 'j');
	}
	if (_tmp13_) {
		_tmp12_ = TRUE;
	} else {
		_tmp12_ = i == ((gint) 'l');
	}
	if (_tmp12_) {
		GskPathBuilder* top_square = NULL;
		GskPathBuilder* _tmp18_;
		gint _tmp19_ = 0;
		gint _tmp20_ = 0;
		gint _tmp21_ = 0;
		GskPathBuilder* _tmp22_;
		graphene_rect_t _tmp23_ = {0};
		GskPathBuilder* _tmp24_;
		GskPath* _tmp25_;
		GskPath* _tmp26_;
		GdkRGBA _tmp27_ = {0};
		_tmp18_ = gsk_path_builder_new ();
		top_square = _tmp18_;
		if (x_remainder == 2) {
			_tmp19_ = (x_s13 + x) + x_remainder;
		} else {
			_tmp19_ = x_s13 + x;
		}
		if (x_remainder == 2) {
			_tmp20_ = x_s13;
		} else {
			_tmp20_ = x_s13 + x_remainder;
		}
		if (y_remainder == 2) {
			_tmp21_ = y_s13 + y_remainder;
		} else {
			_tmp21_ = y_s13;
		}
		_tmp22_ = top_square;
		_tmp23_.origin = (graphene_point_t) {(gfloat) _tmp19_, (gfloat) y};
		_tmp23_.size = (graphene_size_t) {(gfloat) _tmp20_, (gfloat) _tmp21_};
		gsk_path_builder_add_rect (_tmp22_, &_tmp23_);
		_tmp24_ = top_square;
		_tmp25_ = gsk_path_builder_to_path (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_.red = 0.5f;
		_tmp27_.green = 0.5f;
		_tmp27_.blue = 0.5f;
		_tmp27_.alpha = 1.0f;
		gtk_snapshot_append_fill (s, _tmp26_, GSK_FILL_RULE_EVEN_ODD, &_tmp27_);
		_gsk_path_unref0 (_tmp26_);
		_gsk_path_builder_unref0 (top_square);
	}
	if (i == ((gint) 'c')) {
		_tmp33_ = TRUE;
	} else {
		_tmp33_ = i == ((gint) 'd');
	}
	if (_tmp33_) {
		_tmp32_ = TRUE;
	} else {
		_tmp32_ = i == ((gint) 'f');
	}
	if (_tmp32_) {
		_tmp31_ = TRUE;
	} else {
		_tmp31_ = i == ((gint) 'h');
	}
	if (_tmp31_) {
		_tmp30_ = TRUE;
	} else {
		_tmp30_ = i == ((gint) 'i');
	}
	if (_tmp30_) {
		_tmp29_ = TRUE;
	} else {
		_tmp29_ = i == ((gint) 'k');
	}
	if (_tmp29_) {
		_tmp28_ = TRUE;
	} else {
		_tmp28_ = i == ((gint) 'l');
	}
	if (_tmp28_) {
		GskPathBuilder* right_square = NULL;
		GskPathBuilder* _tmp34_;
		gint _tmp35_ = 0;
		gint _tmp36_ = 0;
		gint _tmp37_ = 0;
		GskPathBuilder* _tmp38_;
		graphene_rect_t _tmp39_ = {0};
		GskPathBuilder* _tmp40_;
		GskPath* _tmp41_;
		GskPath* _tmp42_;
		GdkRGBA _tmp43_ = {0};
		_tmp34_ = gsk_path_builder_new ();
		right_square = _tmp34_;
		if (y_remainder == 2) {
			_tmp35_ = (y_s13 + y_remainder) + y;
		} else {
			_tmp35_ = y_s13 + y;
		}
		if (x_remainder == 2) {
			_tmp36_ = x_s13 + x_remainder;
		} else {
			_tmp36_ = x_s13;
		}
		if (y_remainder == 2) {
			_tmp37_ = y_s13;
		} else {
			_tmp37_ = y_s13 + y_remainder;
		}
		_tmp38_ = right_square;
		_tmp39_.origin = (graphene_point_t) {(gfloat) (((x_s13 + x_s13) + x_remainder) + x), (gfloat) _tmp35_};
		_tmp39_.size = (graphene_size_t) {(gfloat) _tmp36_, (gfloat) _tmp37_};
		gsk_path_builder_add_rect (_tmp38_, &_tmp39_);
		_tmp40_ = right_square;
		_tmp41_ = gsk_path_builder_to_path (_tmp40_);
		_tmp42_ = _tmp41_;
		_tmp43_.red = 0.5f;
		_tmp43_.green = 0.5f;
		_tmp43_.blue = 0.5f;
		_tmp43_.alpha = 1.0f;
		gtk_snapshot_append_fill (s, _tmp42_, GSK_FILL_RULE_EVEN_ODD, &_tmp43_);
		_gsk_path_unref0 (_tmp42_);
		_gsk_path_builder_unref0 (right_square);
	}
	if (i == ((gint) 'b')) {
		_tmp49_ = TRUE;
	} else {
		_tmp49_ = i == ((gint) 'f');
	}
	if (_tmp49_) {
		_tmp48_ = TRUE;
	} else {
		_tmp48_ = i == ((gint) 'g');
	}
	if (_tmp48_) {
		_tmp47_ = TRUE;
	} else {
		_tmp47_ = i == ((gint) 'i');
	}
	if (_tmp47_) {
		_tmp46_ = TRUE;
	} else {
		_tmp46_ = i == ((gint) 'j');
	}
	if (_tmp46_) {
		_tmp45_ = TRUE;
	} else {
		_tmp45_ = i == ((gint) 'k');
	}
	if (_tmp45_) {
		_tmp44_ = TRUE;
	} else {
		_tmp44_ = i == ((gint) 'l');
	}
	if (_tmp44_) {
		GskPathBuilder* bottom_square = NULL;
		GskPathBuilder* _tmp50_;
		gint _tmp51_ = 0;
		gint _tmp52_ = 0;
		gint _tmp53_ = 0;
		GskPathBuilder* _tmp54_;
		graphene_rect_t _tmp55_ = {0};
		GskPathBuilder* _tmp56_;
		GskPath* _tmp57_;
		GskPath* _tmp58_;
		GdkRGBA _tmp59_ = {0};
		_tmp50_ = gsk_path_builder_new ();
		bottom_square = _tmp50_;
		if (x_remainder == 2) {
			_tmp51_ = (x_s13 + x) + x_remainder;
		} else {
			_tmp51_ = x_s13 + x;
		}
		if (x_remainder == 2) {
			_tmp52_ = x_s13;
		} else {
			_tmp52_ = x_s13 + x_remainder;
		}
		if (y_remainder == 2) {
			_tmp53_ = y_s13 + y_remainder;
		} else {
			_tmp53_ = y_s13;
		}
		_tmp54_ = bottom_square;
		_tmp55_.origin = (graphene_point_t) {(gfloat) _tmp51_, (gfloat) (((y_s13 + y_s13) + y_remainder) + y)};
		_tmp55_.size = (graphene_size_t) {(gfloat) _tmp52_, (gfloat) _tmp53_};
		gsk_path_builder_add_rect (_tmp54_, &_tmp55_);
		_tmp56_ = bottom_square;
		_tmp57_ = gsk_path_builder_to_path (_tmp56_);
		_tmp58_ = _tmp57_;
		_tmp59_.red = 0.5f;
		_tmp59_.green = 0.5f;
		_tmp59_.blue = 0.5f;
		_tmp59_.alpha = 1.0f;
		gtk_snapshot_append_fill (s, _tmp58_, GSK_FILL_RULE_EVEN_ODD, &_tmp59_);
		_gsk_path_unref0 (_tmp58_);
		_gsk_path_builder_unref0 (bottom_square);
	}
	if (i == ((gint) 'c')) {
		_tmp65_ = TRUE;
	} else {
		_tmp65_ = i == ((gint) 'e');
	}
	if (_tmp65_) {
		_tmp64_ = TRUE;
	} else {
		_tmp64_ = i == ((gint) 'g');
	}
	if (_tmp64_) {
		_tmp63_ = TRUE;
	} else {
		_tmp63_ = i == ((gint) 'h');
	}
	if (_tmp63_) {
		_tmp62_ = TRUE;
	} else {
		_tmp62_ = i == ((gint) 'j');
	}
	if (_tmp62_) {
		_tmp61_ = TRUE;
	} else {
		_tmp61_ = i == ((gint) 'k');
	}
	if (_tmp61_) {
		_tmp60_ = TRUE;
	} else {
		_tmp60_ = i == ((gint) 'l');
	}
	if (_tmp60_) {
		GskPathBuilder* left_square = NULL;
		GskPathBuilder* _tmp66_;
		gint _tmp67_ = 0;
		gint _tmp68_ = 0;
		gint _tmp69_ = 0;
		GskPathBuilder* _tmp70_;
		graphene_rect_t _tmp71_ = {0};
		GskPathBuilder* _tmp72_;
		GskPath* _tmp73_;
		GskPath* _tmp74_;
		GdkRGBA _tmp75_ = {0};
		_tmp66_ = gsk_path_builder_new ();
		left_square = _tmp66_;
		if (y_remainder == 2) {
			_tmp67_ = (y_s13 + y) + y_remainder;
		} else {
			_tmp67_ = y_s13 + y;
		}
		if (x_remainder == 2) {
			_tmp68_ = x_s13 + x_remainder;
		} else {
			_tmp68_ = x_s13;
		}
		if (y_remainder == 2) {
			_tmp69_ = y_s13;
		} else {
			_tmp69_ = y_s13 + y_remainder;
		}
		_tmp70_ = left_square;
		_tmp71_.origin = (graphene_point_t) {(gfloat) x, (gfloat) _tmp67_};
		_tmp71_.size = (graphene_size_t) {(gfloat) _tmp68_, (gfloat) _tmp69_};
		gsk_path_builder_add_rect (_tmp70_, &_tmp71_);
		_tmp72_ = left_square;
		_tmp73_ = gsk_path_builder_to_path (_tmp72_);
		_tmp74_ = _tmp73_;
		_tmp75_.red = 0.5f;
		_tmp75_.green = 0.5f;
		_tmp75_.blue = 0.5f;
		_tmp75_.alpha = 1.0f;
		gtk_snapshot_append_fill (s, _tmp74_, GSK_FILL_RULE_EVEN_ODD, &_tmp75_);
		_gsk_path_unref0 (_tmp74_);
		_gsk_path_builder_unref0 (left_square);
	}
}

static void
nibbles_view_draw_worm_segment (NibblesView* self,
                                GtkSnapshot* s,
                                gint x,
                                gint y,
                                gint x_size,
                                gint y_size,
                                gint color,
                                gboolean is_materialized,
                                gboolean eaten_bonus)
{
	static const gfloat PI2 = 1.570796326794896619231321691639751442f;
	gfloat x_s13 = 0.0F;
	gfloat x_s23 = 0.0F;
	gfloat y_s13 = 0.0F;
	gfloat y_s23 = 0.0F;
	GskPathBuilder* path = NULL;
	GskPathBuilder* _tmp2_;
	gdouble r = 0.0;
	gdouble g = 0.0;
	gdouble b = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	GskPath* _tmp6_;
	GskPath* _tmp7_;
	GdkRGBA _tmp8_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	if (eaten_bonus) {
		gint a = 0;
		a = x_size + (x_size / 5);
		if (a < (x_size + 1)) {
			x_size = x_size + 1;
		} else {
			x = x - ((a - x_size) / 2);
			x_size = a;
		}
		a = y_size + (y_size / 5);
		if (a < (y_size + 1)) {
			y_size = y_size + 1;
		} else {
			y = y - ((a - y_size) / 2);
			y_size = a;
		}
	} else {
		gint _tmp0_;
		gint _tmp1_;
		x = x + 1;
		_tmp0_ = x;
		y = y + 1;
		_tmp1_ = y;
		x_size = x_size - 1;
		y_size = y_size - 1;
	}
	x_s13 = x_size / 3.0f;
	x_s23 = x_s13 + x_s13;
	y_s13 = y_size / 3.0f;
	y_s23 = y_s13 + y_s13;
	_tmp2_ = gsk_path_builder_new ();
	path = _tmp2_;
	gsk_path_builder_move_to (path, x + x_s23, (gfloat) (y + 0));
	gsk_path_builder_svg_arc_to (path, x_s13, y_s13, PI2, FALSE, TRUE, (gfloat) (x + x_size), y + y_s13);
	gsk_path_builder_line_to (path, (gfloat) (x + x_size), y + y_s23);
	gsk_path_builder_svg_arc_to (path, x_s13, y_s13, PI2, FALSE, TRUE, x + x_s23, (gfloat) (y + y_size));
	gsk_path_builder_line_to (path, x + x_s13, (gfloat) (y + y_size));
	gsk_path_builder_svg_arc_to (path, x_s13, y_s13, PI2, FALSE, TRUE, (gfloat) (x + 0), y + y_s23);
	gsk_path_builder_line_to (path, (gfloat) (x + 0), y + y_s13);
	gsk_path_builder_svg_arc_to (path, x_s13, y_s13, PI2, FALSE, TRUE, x + x_s13, (gfloat) (y + 0));
	get_worm_rgb (color, is_materialized, &_tmp3_, &_tmp4_, &_tmp5_);
	r = _tmp3_;
	g = _tmp4_;
	b = _tmp5_;
	_tmp6_ = gsk_path_builder_to_path (path);
	_tmp7_ = _tmp6_;
	_tmp8_.red = (gfloat) r;
	_tmp8_.green = (gfloat) g;
	_tmp8_.blue = (gfloat) b;
	_tmp8_.alpha = 1.0f;
	gtk_snapshot_append_fill (s, _tmp7_, GSK_FILL_RULE_EVEN_ODD, &_tmp8_);
	_gsk_path_unref0 (_tmp7_);
	_gsk_path_builder_unref0 (path);
}

static void
nibbles_view_draw_bonus (NibblesView* self,
                         GtkSnapshot* s,
                         gint x,
                         gint y,
                         gint x_size,
                         gint y_size,
                         BonuseType type,
                         guint64 animate)
{
	gfloat x_m = 0.0F;
	gfloat y_m = 0.0F;
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	x_m = (gfloat) x_size;
	y_m = (gfloat) y_size;
	switch (type) {
		case BONUS_ETYPE_REGULAR:
		{
			GskPathBuilder* p0 = NULL;
			GskPathBuilder* _tmp0_;
			GskPathBuilder* _tmp1_;
			GskPathBuilder* _tmp2_;
			GskPathBuilder* _tmp3_;
			GskPathBuilder* _tmp4_;
			GskPathBuilder* _tmp5_;
			GskPathBuilder* _tmp6_;
			GskPath* _tmp7_;
			GskPath* _tmp8_;
			GdkRGBA _tmp9_ = {0};
			GskPathBuilder* p1 = NULL;
			GskPathBuilder* _tmp10_;
			GskPathBuilder* _tmp11_;
			GskPathBuilder* _tmp12_;
			GskPathBuilder* _tmp13_;
			GskPath* _tmp14_;
			GskPath* _tmp15_;
			GdkRGBA _tmp16_ = {0};
			x_m /= (gfloat) 18;
			y_m /= (gfloat) 18;
			_tmp0_ = gsk_path_builder_new ();
			p0 = _tmp0_;
			_tmp1_ = p0;
			gsk_path_builder_move_to (_tmp1_, x + (x_m * 15), y + (y_m * 8));
			_tmp2_ = p0;
			gsk_path_builder_cubic_to (_tmp2_, x + (x_m * 15.023438f), y + (y_m * 10.035156f), x + (x_m * 13.953125f), y + (y_m * 17.1875f), x + (x_m * 8), y + (y_m * 14.429688f));
			_tmp3_ = p0;
			gsk_path_builder_cubic_to (_tmp3_, x + (x_m * 1.90625f), y + (y_m * 17.109375f), x + (x_m * 1.03125f), y + (y_m * 9.921875f), x + (x_m * 1), y + (y_m * 8));
			_tmp4_ = p0;
			gsk_path_builder_cubic_to (_tmp4_, x + (x_m * 1.007813f), y + (y_m * 5.109375f), x + (x_m * 3.300781f), y + (y_m * 1.355469f), x + (x_m * 8), y + (y_m * 4.3125f));
			_tmp5_ = p0;
			gsk_path_builder_cubic_to (_tmp5_, x + (x_m * 12.933594f), y + (y_m * 1.394531f), x + (x_m * 15.0625f), y + (y_m * 5), x + (x_m * 15), y + (y_m * 8));
			_tmp6_ = p0;
			_tmp7_ = gsk_path_builder_to_path (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_.red = 0.0f;
			_tmp9_.green = 1.0f;
			_tmp9_.blue = 0.0f;
			_tmp9_.alpha = 1.0f;
			gtk_snapshot_append_fill (s, _tmp8_, GSK_FILL_RULE_EVEN_ODD, &_tmp9_);
			_gsk_path_unref0 (_tmp8_);
			_tmp10_ = gsk_path_builder_new ();
			p1 = _tmp10_;
			_tmp11_ = p1;
			gsk_path_builder_move_to (_tmp11_, x + (x_m * 9.65625f), y + (y_m * 1.34375f));
			_tmp12_ = p1;
			gsk_path_builder_cubic_to (_tmp12_, x + (x_m * 8), y + (y_m * 2), x + (x_m * 8), y + (y_m * 3.667969f), x + (x_m * 8), y + (y_m * 5));
			_tmp13_ = p1;
			_tmp14_ = gsk_path_builder_to_path (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_.red = 0.0f;
			_tmp16_.green = 1.0f;
			_tmp16_.blue = 0.0f;
			_tmp16_.alpha = 1.0f;
			gtk_snapshot_append_fill (s, _tmp15_, GSK_FILL_RULE_EVEN_ODD, &_tmp16_);
			_gsk_path_unref0 (_tmp15_);
			_gsk_path_builder_unref0 (p1);
			_gsk_path_builder_unref0 (p0);
			break;
		}
		case BONUS_ETYPE_HALF:
		{
			GskPathBuilder* p0 = NULL;
			GskPathBuilder* _tmp17_;
			GskPathBuilder* _tmp18_;
			GskPathBuilder* _tmp19_;
			GskPathBuilder* _tmp20_;
			GskPath* _tmp21_;
			GskPath* _tmp22_;
			GdkRGBA _tmp23_ = {0};
			GskPathBuilder* p1 = NULL;
			GskPathBuilder* _tmp24_;
			GskPathBuilder* _tmp25_;
			GskPathBuilder* _tmp26_;
			GskPathBuilder* _tmp27_;
			GskPath* _tmp28_;
			GskPath* _tmp29_;
			GdkRGBA _tmp30_ = {0};
			GskPathBuilder* p2 = NULL;
			GskPathBuilder* _tmp31_;
			GskPathBuilder* _tmp32_;
			GskPathBuilder* _tmp33_;
			GskPathBuilder* _tmp34_;
			GskPathBuilder* _tmp35_;
			GskPathBuilder* _tmp36_;
			GskPathBuilder* _tmp37_;
			GskPath* _tmp38_;
			GskPath* _tmp39_;
			GdkRGBA _tmp40_ = {0};
			GskPathBuilder* p3 = NULL;
			GskPathBuilder* _tmp41_;
			GskPathBuilder* _tmp42_;
			GskPathBuilder* _tmp43_;
			GskPathBuilder* _tmp44_;
			GskPathBuilder* _tmp45_;
			GskPathBuilder* _tmp46_;
			GskPathBuilder* _tmp47_;
			GskPath* _tmp48_;
			GskPath* _tmp49_;
			GdkRGBA _tmp50_ = {0};
			x_m /= (gfloat) 16;
			y_m /= (gfloat) 16;
			_tmp17_ = gsk_path_builder_new ();
			p0 = _tmp17_;
			_tmp18_ = p0;
			gsk_path_builder_move_to (_tmp18_, x + (x_m * 10.253906f), y + (y_m * 1.3125f));
			_tmp19_ = p0;
			gsk_path_builder_cubic_to (_tmp19_, x + (x_m * 9.472656f), y + (y_m * 4.730469f), x + (x_m * 9.445313f), y + (y_m * 8.015625f), x + (x_m * 11.625f), y + (y_m * 10.683594f));
			_tmp20_ = p0;
			_tmp21_ = gsk_path_builder_to_path (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_.red = 0.305882f;
			_tmp23_.green = 0.603922f;
			_tmp23_.blue = 0.0235294f;
			_tmp23_.alpha = 1.0f;
			gtk_snapshot_append_fill (s, _tmp22_, GSK_FILL_RULE_EVEN_ODD, &_tmp23_);
			_gsk_path_unref0 (_tmp22_);
			_tmp24_ = gsk_path_builder_new ();
			p1 = _tmp24_;
			_tmp25_ = p1;
			gsk_path_builder_move_to (_tmp25_, x + (x_m * 10.296875f), y + (y_m * 1.152344f));
			_tmp26_ = p1;
			gsk_path_builder_cubic_to (_tmp26_, x + (x_m * 9.046875f), y + (y_m * 7.132813f), x + (x_m * 6.023438f), y + (y_m * 7.765625f), x + (x_m * 3.84375f), y + (y_m * 10.429688f));
			_tmp27_ = p1;
			_tmp28_ = gsk_path_builder_to_path (_tmp27_);
			_tmp29_ = _tmp28_;
			_tmp30_.red = 0.305882f;
			_tmp30_.green = 0.603922f;
			_tmp30_.blue = 0.0235294f;
			_tmp30_.alpha = 1.0f;
			gtk_snapshot_append_fill (s, _tmp29_, GSK_FILL_RULE_EVEN_ODD, &_tmp30_);
			_gsk_path_unref0 (_tmp29_);
			_tmp31_ = gsk_path_builder_new ();
			p2 = _tmp31_;
			_tmp32_ = p2;
			gsk_path_builder_move_to (_tmp32_, x + (x_m * 7), y + (y_m * 10));
			_tmp33_ = p2;
			gsk_path_builder_cubic_to (_tmp33_, x + (x_m * 7), y + (y_m * 11.65625f), x + (x_m * 5.65625f), y + (y_m * 13), x + (x_m * 4), y + (y_m * 13));
			_tmp34_ = p2;
			gsk_path_builder_cubic_to (_tmp34_, x + (x_m * 2.34375f), y + (y_m * 13), x + (x_m * 1), y + (y_m * 11.65625f), x + (x_m * 1), y + (y_m * 10));
			_tmp35_ = p2;
			gsk_path_builder_cubic_to (_tmp35_, x + (x_m * 1), y + (y_m * 8.34375f), x + (x_m * 2.34375f), y + (y_m * 7), x + (x_m * 4), y + (y_m * 7));
			_tmp36_ = p2;
			gsk_path_builder_cubic_to (_tmp36_, x + (x_m * 5.65625f), y + (y_m * 7), x + (x_m * 7), y + (y_m * 8.34375f), x + (x_m * 7), y + (y_m * 10));
			_tmp37_ = p2;
			_tmp38_ = gsk_path_builder_to_path (_tmp37_);
			_tmp39_ = _tmp38_;
			_tmp40_.red = 0.8f;
			_tmp40_.green = 0.0f;
			_tmp40_.blue = 0.0f;
			_tmp40_.alpha = 1.0f;
			gtk_snapshot_append_fill (s, _tmp39_, GSK_FILL_RULE_EVEN_ODD, &_tmp40_);
			_gsk_path_unref0 (_tmp39_);
			_tmp41_ = gsk_path_builder_new ();
			p3 = _tmp41_;
			_tmp42_ = p3;
			gsk_path_builder_move_to (_tmp42_, x + (x_m * 15), y + (y_m * 12));
			_tmp43_ = p3;
			gsk_path_builder_cubic_to (_tmp43_, x + (x_m * 15), y + (y_m * 13.65625f), x + (x_m * 13.65625f), y + (y_m * 15), x + (x_m * 12), y + (y_m * 15));
			_tmp44_ = p3;
			gsk_path_builder_cubic_to (_tmp44_, x + (x_m * 10.34375f), y + (y_m * 15), x + (x_m * 9), y + (y_m * 13.65625f), x + (x_m * 9), y + (y_m * 12));
			_tmp45_ = p3;
			gsk_path_builder_cubic_to (_tmp45_, x + (x_m * 9), y + (y_m * 10.34375f), x + (x_m * 10.34375f), y + (y_m * 9), x + (x_m * 12), y + (y_m * 9));
			_tmp46_ = p3;
			gsk_path_builder_cubic_to (_tmp46_, x + (x_m * 13.65625f), y + (y_m * 9), x + (x_m * 15), y + (y_m * 10.34375f), x + (x_m * 15), y + (y_m * 12));
			_tmp47_ = p3;
			_tmp48_ = gsk_path_builder_to_path (_tmp47_);
			_tmp49_ = _tmp48_;
			_tmp50_.red = 0.8f;
			_tmp50_.green = 0.0f;
			_tmp50_.blue = 0.0f;
			_tmp50_.alpha = 1.0f;
			gtk_snapshot_append_fill (s, _tmp49_, GSK_FILL_RULE_EVEN_ODD, &_tmp50_);
			_gsk_path_unref0 (_tmp49_);
			_gsk_path_builder_unref0 (p3);
			_gsk_path_builder_unref0 (p2);
			_gsk_path_builder_unref0 (p1);
			_gsk_path_builder_unref0 (p0);
			break;
		}
		case BONUS_ETYPE_DOUBLE:
		{
			GskPathBuilder* p0 = NULL;
			GskPathBuilder* _tmp51_;
			GskPathBuilder* _tmp52_;
			GskPathBuilder* _tmp53_;
			GskPathBuilder* _tmp54_;
			GskPathBuilder* _tmp55_;
			GskPathBuilder* _tmp56_;
			GskPathBuilder* _tmp57_;
			GskPathBuilder* _tmp58_;
			GskPathBuilder* _tmp59_;
			GskPath* _tmp60_;
			GskPath* _tmp61_;
			GdkRGBA _tmp62_ = {0};
			x_m /= (gfloat) 18;
			y_m /= (gfloat) 18;
			_tmp51_ = gsk_path_builder_new ();
			p0 = _tmp51_;
			_tmp52_ = p0;
			gsk_path_builder_move_to (_tmp52_, x + (x_m * 0.695313f), y + (y_m * 8.425781f));
			_tmp53_ = p0;
			gsk_path_builder_cubic_to (_tmp53_, x + (x_m * 8.914063f), y + (y_m * 11.246094f), x + (x_m * 13.257813f), y + (y_m * 5.894531f), x + (x_m * 13.847656f), y + (y_m * 4.394531f));
			_tmp54_ = p0;
			gsk_path_builder_cubic_to (_tmp54_, x + (x_m * 14.285156f), y + (y_m * 3.351563f), x + (x_m * 14.308594f), y + (y_m * 3.082031f), x + (x_m * 14.402344f), y + (y_m * 2.535156f));
			_tmp55_ = p0;
			gsk_path_builder_cubic_to (_tmp55_, x + (x_m * 14.941406f), y + (y_m * 2.433594f), x + (x_m * 15.613281f), y + (y_m * 2.71875f), x + (x_m * 16), y + (y_m * 3.0625f));
			_tmp56_ = p0;
			gsk_path_builder_cubic_to (_tmp56_, x + (x_m * 15.566406f), y + (y_m * 3.535156f), x + (x_m * 15.261719f), y + (y_m * 4.246094f), x + (x_m * 15.167969f), y + (y_m * 4.984375f));
			_tmp57_ = p0;
			gsk_path_builder_cubic_to (_tmp57_, x + (x_m * 15.675781f), y + (y_m * 11.316406f), x + (x_m * 7.71875f), y + (y_m * 17.683594f), x + (x_m * 0), y + (y_m * 9.972656f));
			_tmp58_ = p0;
			gsk_path_builder_cubic_to (_tmp58_, x + (x_m * 0.03125f), y + (y_m * 9.433594f), x + (x_m * 0.210938f), y + (y_m * 8.84375f), x + (x_m * 0.695313f), y + (y_m * 8.425781f));
			_tmp59_ = p0;
			_tmp60_ = gsk_path_builder_to_path (_tmp59_);
			_tmp61_ = _tmp60_;
			_tmp62_.red = 0.988235f;
			_tmp62_.green = 0.913725f;
			_tmp62_.blue = 0.309804f;
			_tmp62_.alpha = 1.0f;
			gtk_snapshot_append_fill (s, _tmp61_, GSK_FILL_RULE_EVEN_ODD, &_tmp62_);
			_gsk_path_unref0 (_tmp61_);
			_gsk_path_builder_unref0 (p0);
			break;
		}
		case BONUS_ETYPE_LIFE:
		{
			GskPathBuilder* p0 = NULL;
			GskPathBuilder* _tmp63_;
			GskPathBuilder* _tmp64_;
			GskPathBuilder* _tmp65_;
			GskPathBuilder* _tmp66_;
			GskPathBuilder* _tmp67_;
			GskPathBuilder* _tmp68_;
			GskPathBuilder* _tmp69_;
			GskPathBuilder* _tmp70_;
			GskPath* _tmp71_;
			GskPath* _tmp72_;
			GdkRGBA _tmp73_ = {0};
			x_m /= (gfloat) 16;
			y_m /= (gfloat) 16;
			_tmp63_ = gsk_path_builder_new ();
			p0 = _tmp63_;
			_tmp64_ = p0;
			gsk_path_builder_move_to (_tmp64_, x + (x_m * 4.753906f), y + (y_m * 1.828125f));
			_tmp65_ = p0;
			gsk_path_builder_cubic_to (_tmp65_, x + (x_m * 2.652344f), y + (y_m * 1.851563f), x + (x_m * 1.019531f), y + (y_m * 3.648438f), x + (x_m * 1), y + (y_m * 5.8125f));
			_tmp66_ = p0;
			gsk_path_builder_cubic_to (_tmp66_, x + (x_m * 0.972656f), y + (y_m * 8.890625f), x + (x_m * 2.808594f), y + (y_m * 9.882813f), x + (x_m * 8.015625f), y + (y_m * 14.171875f));
			_tmp67_ = p0;
			gsk_path_builder_cubic_to (_tmp67_, x + (x_m * 12.992188f), y + (y_m * 9.558594f), x + (x_m * 14.976563f), y + (y_m * 8.316406f), x + (x_m * 15), y + (y_m * 5.722656f));
			_tmp68_ = p0;
			gsk_path_builder_cubic_to (_tmp68_, x + (x_m * 15.027344f), y + (y_m * 2.886719f), x + (x_m * 10.90625f), y + (y_m * 0.128906f), x + (x_m * 7.910156f), y + (y_m * 3.121094f));
			_tmp69_ = p0;
			gsk_path_builder_cubic_to (_tmp69_, x + (x_m * 6.835938f), y + (y_m * 2.199219f), x + (x_m * 5.742188f), y + (y_m * 1.816406f), x + (x_m * 4.753906f), y + (y_m * 1.828125f));
			_tmp70_ = p0;
			_tmp71_ = gsk_path_builder_to_path (_tmp70_);
			_tmp72_ = _tmp71_;
			_tmp73_.red = 1.0f;
			_tmp73_.green = 0.0f;
			_tmp73_.blue = 0.0f;
			_tmp73_.alpha = 1.0f;
			gtk_snapshot_append_fill (s, _tmp72_, GSK_FILL_RULE_EVEN_ODD, &_tmp73_);
			_gsk_path_unref0 (_tmp72_);
			_gsk_path_builder_unref0 (p0);
			break;
		}
		case BONUS_ETYPE_REVERSE:
		{
			GskPathBuilder* p0 = NULL;
			GskPathBuilder* _tmp74_;
			GskPathBuilder* _tmp75_;
			GskPathBuilder* _tmp76_;
			GskPathBuilder* _tmp77_;
			GskPathBuilder* _tmp78_;
			GskPathBuilder* _tmp79_;
			GskPathBuilder* _tmp80_;
			GskPath* _tmp81_;
			GskPath* _tmp82_;
			GdkRGBA _tmp83_ = {0};
			GskPathBuilder* p1 = NULL;
			GskPathBuilder* _tmp84_;
			GskPathBuilder* _tmp85_;
			GskPathBuilder* _tmp86_;
			GskPathBuilder* _tmp87_;
			GskPathBuilder* _tmp88_;
			GskPath* _tmp89_;
			GskPath* _tmp90_;
			GdkRGBA _tmp91_ = {0};
			GskPathBuilder* p2 = NULL;
			GskPathBuilder* _tmp92_;
			GskPathBuilder* _tmp93_;
			GskPathBuilder* _tmp94_;
			GskPathBuilder* _tmp95_;
			GskPathBuilder* _tmp96_;
			GskPathBuilder* _tmp97_;
			GskPath* _tmp98_;
			GskPath* _tmp99_;
			GdkRGBA _tmp100_ = {0};
			GskPathBuilder* p3 = NULL;
			GskPathBuilder* _tmp101_;
			GskPathBuilder* _tmp102_;
			GskPathBuilder* _tmp103_;
			GskPathBuilder* _tmp104_;
			GskPathBuilder* _tmp105_;
			GskPathBuilder* _tmp106_;
			GskPath* _tmp107_;
			GskPath* _tmp108_;
			GdkRGBA _tmp109_ = {0};
			x_m /= (gfloat) 16;
			y_m /= (gfloat) 16;
			_tmp74_ = gsk_path_builder_new ();
			p0 = _tmp74_;
			_tmp75_ = p0;
			gsk_path_builder_move_to (_tmp75_, x + (x_m * 4), y + (y_m * 2));
			_tmp76_ = p0;
			gsk_path_builder_line_to (_tmp76_, x + (x_m * 12), y + (y_m * 2));
			_tmp77_ = p0;
			gsk_path_builder_line_to (_tmp77_, x + (x_m * 15), y + (y_m * 6));
			_tmp78_ = p0;
			gsk_path_builder_line_to (_tmp78_, x + (x_m * 8), y + (y_m * 15));
			_tmp79_ = p0;
			gsk_path_builder_line_to (_tmp79_, x + (x_m * 1), y + (y_m * 6));
			_tmp80_ = p0;
			_tmp81_ = gsk_path_builder_to_path (_tmp80_);
			_tmp82_ = _tmp81_;
			_tmp83_.red = 0.717647f;
			_tmp83_.green = 0.807843f;
			_tmp83_.blue = 0.901961f;
			_tmp83_.alpha = 1.0f;
			gtk_snapshot_append_fill (s, _tmp82_, GSK_FILL_RULE_EVEN_ODD, &_tmp83_);
			_gsk_path_unref0 (_tmp82_);
			_tmp84_ = gsk_path_builder_new ();
			p1 = _tmp84_;
			_tmp85_ = p1;
			gsk_path_builder_move_to (_tmp85_, x + (x_m * 11), y + (y_m * 6));
			_tmp86_ = p1;
			gsk_path_builder_line_to (_tmp86_, x + (x_m * 8), y + (y_m * 15));
			_tmp87_ = p1;
			gsk_path_builder_line_to (_tmp87_, x + (x_m * 5), y + (y_m * 6));
			_tmp88_ = p1;
			_tmp89_ = gsk_path_builder_to_path (_tmp88_);
			_tmp90_ = _tmp89_;
			_tmp91_.red = 0.447059f;
			_tmp91_.green = 0.623529f;
			_tmp91_.blue = 0.811765f;
			_tmp91_.alpha = 1.0f;
			gtk_snapshot_append_fill (s, _tmp90_, GSK_FILL_RULE_EVEN_ODD, &_tmp91_);
			_gsk_path_unref0 (_tmp90_);
			_tmp92_ = gsk_path_builder_new ();
			p2 = _tmp92_;
			_tmp93_ = p2;
			gsk_path_builder_move_to (_tmp93_, x + (x_m * 4), y + (y_m * 2));
			_tmp94_ = p2;
			gsk_path_builder_line_to (_tmp94_, x + (x_m * 8), y + (y_m * 2));
			_tmp95_ = p2;
			gsk_path_builder_line_to (_tmp95_, x + (x_m * 5), y + (y_m * 6));
			_tmp96_ = p2;
			gsk_path_builder_line_to (_tmp96_, x + (x_m * 1), y + (y_m * 6));
			_tmp97_ = p2;
			_tmp98_ = gsk_path_builder_to_path (_tmp97_);
			_tmp99_ = _tmp98_;
			_tmp100_.red = 0.447059f;
			_tmp100_.green = 0.623529f;
			_tmp100_.blue = 0.811765f;
			_tmp100_.alpha = 1.0f;
			gtk_snapshot_append_fill (s, _tmp99_, GSK_FILL_RULE_EVEN_ODD, &_tmp100_);
			_gsk_path_unref0 (_tmp99_);
			_tmp101_ = gsk_path_builder_new ();
			p3 = _tmp101_;
			_tmp102_ = p3;
			gsk_path_builder_move_to (_tmp102_, x + (x_m * 12), y + (y_m * 2));
			_tmp103_ = p3;
			gsk_path_builder_line_to (_tmp103_, x + (x_m * 8), y + (y_m * 2));
			_tmp104_ = p3;
			gsk_path_builder_line_to (_tmp104_, x + (x_m * 11), y + (y_m * 6));
			_tmp105_ = p3;
			gsk_path_builder_line_to (_tmp105_, x + (x_m * 15), y + (y_m * 6));
			_tmp106_ = p3;
			_tmp107_ = gsk_path_builder_to_path (_tmp106_);
			_tmp108_ = _tmp107_;
			_tmp109_.red = 0.447059f;
			_tmp109_.green = 0.623529f;
			_tmp109_.blue = 0.811765f;
			_tmp109_.alpha = 1.0f;
			gtk_snapshot_append_fill (s, _tmp108_, GSK_FILL_RULE_EVEN_ODD, &_tmp109_);
			_gsk_path_unref0 (_tmp108_);
			_gsk_path_builder_unref0 (p3);
			_gsk_path_builder_unref0 (p2);
			_gsk_path_builder_unref0 (p1);
			_gsk_path_builder_unref0 (p0);
			break;
		}
		case BONUS_ETYPE_WARP:
		{
			GskPathBuilder* p0 = NULL;
			GskPathBuilder* _tmp110_;
			GskPathBuilder* _tmp111_;
			GskPathBuilder* _tmp112_;
			GskPathBuilder* _tmp113_;
			GskPathBuilder* _tmp114_;
			GskPathBuilder* _tmp115_;
			GskPathBuilder* _tmp116_;
			GskPathBuilder* _tmp117_;
			GskPathBuilder* _tmp118_;
			GskPathBuilder* _tmp119_;
			GskPathBuilder* _tmp120_;
			GskPathBuilder* _tmp121_;
			GskPathBuilder* _tmp122_;
			GskPathBuilder* _tmp123_;
			GskPathBuilder* _tmp124_;
			GskPathBuilder* _tmp125_;
			GskPathBuilder* _tmp126_;
			gfloat r = 0.0F;
			gfloat g = 0.0F;
			gfloat b = 0.0F;
			gfloat _tmp127_ = 0.0F;
			gfloat _tmp129_ = 0.0F;
			gfloat _tmp131_ = 0.0F;
			GskPathBuilder* _tmp133_;
			GskPath* _tmp134_;
			GskPath* _tmp135_;
			GdkRGBA _tmp136_ = {0};
			GskPathBuilder* p1 = NULL;
			GskPathBuilder* _tmp137_;
			GskPathBuilder* _tmp138_;
			GskPathBuilder* _tmp139_;
			GskPathBuilder* _tmp140_;
			GskPathBuilder* _tmp141_;
			GskPathBuilder* _tmp142_;
			GskPathBuilder* _tmp143_;
			GskPath* _tmp144_;
			GskPath* _tmp145_;
			GdkRGBA _tmp146_ = {0};
			x_m /= (gfloat) 16;
			y_m /= (gfloat) 16;
			_tmp110_ = gsk_path_builder_new ();
			p0 = _tmp110_;
			_tmp111_ = p0;
			gsk_path_builder_move_to (_tmp111_, x + (x_m * 8.664063f), y + (y_m * 0.621094f));
			_tmp112_ = p0;
			gsk_path_builder_cubic_to (_tmp112_, x + (x_m * 6.179688f), y + (y_m * 0.761719f), x + (x_m * 4.265625f), y + (y_m * 2.679688f), x + (x_m * 4.40625f), y + (y_m * 5.164063f));
			_tmp113_ = p0;
			gsk_path_builder_line_to (_tmp113_, x + (x_m * 7.433594f), y + (y_m * 5.164063f));
			_tmp114_ = p0;
			gsk_path_builder_cubic_to (_tmp114_, x + (x_m * 7.386719f), y + (y_m * 4.3125f), x + (x_m * 8.003906f), y + (y_m * 3.699219f), x + (x_m * 8.855469f), y + (y_m * 3.652344f));
			_tmp115_ = p0;
			gsk_path_builder_cubic_to (_tmp115_, x + (x_m * 9.707031f), y + (y_m * 3.601563f), x + (x_m * 10.417969f), y + (y_m * 4.21875f), x + (x_m * 10.464844f), y + (y_m * 5.070313f));
			_tmp116_ = p0;
			gsk_path_builder_line_to (_tmp116_, x + (x_m * 10.464844f), y + (y_m * 5.117188f));
			_tmp117_ = p0;
			gsk_path_builder_cubic_to (_tmp117_, x + (x_m * 10.46875f), y + (y_m * 5.316406f), x + (x_m * 10.417969f), y + (y_m * 5.609375f), x + (x_m * 10.273438f), y + (y_m * 5.78125f));
			_tmp118_ = p0;
			gsk_path_builder_cubic_to (_tmp118_, x + (x_m * 9.929688f), y + (y_m * 6.191406f), x + (x_m * 9.542969f), y + (y_m * 6.53125f), x + (x_m * 9.234375f), y + (y_m * 6.773438f));
			_tmp119_ = p0;
			gsk_path_builder_cubic_to (_tmp119_, x + (x_m * 8.890625f), y + (y_m * 7.035156f), x + (x_m * 8.515625f), y + (y_m * 7.351563f), x + (x_m * 8.144531f), y + (y_m * 7.816406f));
			_tmp120_ = p0;
			gsk_path_builder_cubic_to (_tmp120_, x + (x_m * 7.773438f), y + (y_m * 8.28125f), x + (x_m * 7.433594f), y + (y_m * 8.949219f), x + (x_m * 7.433594f), y + (y_m * 9.710938f));
			_tmp121_ = p0;
			gsk_path_builder_cubic_to (_tmp121_, x + (x_m * 7.425781f), y + (y_m * 10.507813f), x + (x_m * 8.148438f), y + (y_m * 11.222656f), x + (x_m * 8.949219f), y + (y_m * 11.222656f));
			_tmp122_ = p0;
			gsk_path_builder_cubic_to (_tmp122_, x + (x_m * 9.75f), y + (y_m * 11.222656f), x + (x_m * 10.476563f), y + (y_m * 10.507813f), x + (x_m * 10.464844f), y + (y_m * 9.710938f));
			_tmp123_ = p0;
			gsk_path_builder_cubic_to (_tmp123_, x + (x_m * 10.464844f), y + (y_m * 9.710938f), x + (x_m * 10.4375f), y + (y_m * 9.753906f), x + (x_m * 10.511719f), y + (y_m * 9.664063f));
			_tmp124_ = p0;
			gsk_path_builder_cubic_to (_tmp124_, x + (x_m * 10.585938f), y + (y_m * 9.566406f), x + (x_m * 10.789063f), y + (y_m * 9.40625f), x + (x_m * 11.078125f), y + (y_m * 9.1875f));
			_tmp125_ = p0;
			gsk_path_builder_cubic_to (_tmp125_, x + (x_m * 12.921875f), y + (y_m * 7.792969f), x + (x_m * 13.492188f), y + (y_m * 7.003906f), x + (x_m * 13.492188f), y + (y_m * 4.882813f));
			_tmp126_ = p0;
			gsk_path_builder_cubic_to (_tmp126_, x + (x_m * 13.355469f), y + (y_m * 2.394531f), x + (x_m * 11.152344f), y + (y_m * 0.484375f), x + (x_m * 8.664063f), y + (y_m * 0.621094f));
			if ((animate % 30) < ((guint64) 10)) {
				_tmp127_ = (animate % 30) / 10.0f;
			} else {
				gfloat _tmp128_ = 0.0F;
				if ((animate % 30) >= ((guint64) 20)) {
					_tmp128_ = (gfloat) 0;
				} else {
					_tmp128_ = (20 - (animate % 30)) / 10.0f;
				}
				_tmp127_ = _tmp128_;
			}
			r = _tmp127_;
			if (((animate + 10) % 30) < ((guint64) 10)) {
				_tmp129_ = ((animate + 10) % 30) / 10.0f;
			} else {
				gfloat _tmp130_ = 0.0F;
				if (((animate + 10) % 30) >= ((guint64) 20)) {
					_tmp130_ = (gfloat) 0;
				} else {
					_tmp130_ = (20 - ((animate + 10) % 30)) / 10.0f;
				}
				_tmp129_ = _tmp130_;
			}
			g = _tmp129_;
			if (((animate + 20) % 30) < ((guint64) 10)) {
				_tmp131_ = ((animate + 20) % 30) / 10.0f;
			} else {
				gfloat _tmp132_ = 0.0F;
				if (((animate + 20) % 30) >= ((guint64) 20)) {
					_tmp132_ = (gfloat) 0;
				} else {
					_tmp132_ = (20 - ((animate + 20) % 30)) / 10.0f;
				}
				_tmp131_ = _tmp132_;
			}
			b = _tmp131_;
			_tmp133_ = p0;
			_tmp134_ = gsk_path_builder_to_path (_tmp133_);
			_tmp135_ = _tmp134_;
			_tmp136_.red = r;
			_tmp136_.green = g;
			_tmp136_.blue = b;
			_tmp136_.alpha = 1.0f;
			gtk_snapshot_append_fill (s, _tmp135_, GSK_FILL_RULE_EVEN_ODD, &_tmp136_);
			_gsk_path_unref0 (_tmp135_);
			_tmp137_ = gsk_path_builder_new ();
			p1 = _tmp137_;
			_tmp138_ = p1;
			gsk_path_builder_move_to (_tmp138_, x + (x_m * 8.949219f), y + (y_m * 12.738281f));
			_tmp139_ = p1;
			gsk_path_builder_cubic_to (_tmp139_, x + (x_m * 8.113281f), y + (y_m * 12.738281f), x + (x_m * 7.433594f), y + (y_m * 13.417969f), x + (x_m * 7.433594f), y + (y_m * 14.253906f));
			_tmp140_ = p1;
			gsk_path_builder_cubic_to (_tmp140_, x + (x_m * 7.433594f), y + (y_m * 15.089844f), x + (x_m * 8.113281f), y + (y_m * 15.769531f), x + (x_m * 8.949219f), y + (y_m * 15.769531f));
			_tmp141_ = p1;
			gsk_path_builder_cubic_to (_tmp141_, x + (x_m * 9.785156f), y + (y_m * 15.769531f), x + (x_m * 10.464844f), y + (y_m * 15.089844f), x + (x_m * 10.464844f), y + (y_m * 14.253906f));
			_tmp142_ = p1;
			gsk_path_builder_cubic_to (_tmp142_, x + (x_m * 10.464844f), y + (y_m * 13.417969f), x + (x_m * 9.785156f), y + (y_m * 12.738281f), x + (x_m * 8.949219f), y + (y_m * 12.738281f));
			_tmp143_ = p1;
			_tmp144_ = gsk_path_builder_to_path (_tmp143_);
			_tmp145_ = _tmp144_;
			_tmp146_.red = r;
			_tmp146_.green = g;
			_tmp146_.blue = b;
			_tmp146_.alpha = 1.0f;
			gtk_snapshot_append_fill (s, _tmp145_, GSK_FILL_RULE_EVEN_ODD, &_tmp146_);
			_gsk_path_unref0 (_tmp145_);
			_gsk_path_builder_unref0 (p1);
			_gsk_path_builder_unref0 (p0);
			break;
		}
		case 6:
		{
			GskPathBuilder* p0 = NULL;
			GskPathBuilder* _tmp147_;
			GskPathBuilder* _tmp148_;
			GskPathBuilder* _tmp149_;
			GskPathBuilder* _tmp150_;
			GskPathBuilder* _tmp151_;
			GskPathBuilder* _tmp152_;
			GskPath* _tmp153_;
			GskPath* _tmp154_;
			GdkRGBA _tmp155_ = {0};
			GskPathBuilder* p1 = NULL;
			GskPathBuilder* _tmp156_;
			GskPathBuilder* _tmp157_;
			GskPathBuilder* _tmp158_;
			GskPathBuilder* _tmp159_;
			GskPathBuilder* _tmp160_;
			GskPathBuilder* _tmp161_;
			GskPathBuilder* _tmp162_;
			GskPath* _tmp163_;
			GskPath* _tmp164_;
			GdkRGBA _tmp165_ = {0};
			x_m /= (gfloat) 16;
			y_m /= (gfloat) 16;
			_tmp147_ = gsk_path_builder_new ();
			p0 = _tmp147_;
			_tmp148_ = p0;
			gsk_path_builder_move_to (_tmp148_, x + (x_m * 8.902344f), y + (y_m * 0.160156f));
			_tmp149_ = p0;
			gsk_path_builder_cubic_to (_tmp149_, x + (x_m * 6.953125f), y + (y_m * 1.15625f), x + (x_m * 7.480469f), y + (y_m * 3.089844f), x + (x_m * 7.453125f), y + (y_m * 5.019531f));
			_tmp150_ = p0;
			gsk_path_builder_line_to (_tmp150_, x + (x_m * 8.257813f), y + (y_m * 4.8125f));
			_tmp151_ = p0;
			gsk_path_builder_cubic_to (_tmp151_, x + (x_m * 8.144531f), y + (y_m * 3.507813f), x + (x_m * 9.359375f), y + (y_m * 1.511719f), x + (x_m * 10.742188f), y + (y_m * 1.675781f));
			_tmp152_ = p0;
			_tmp153_ = gsk_path_builder_to_path (_tmp152_);
			_tmp154_ = _tmp153_;
			_tmp155_.red = 0.305882f;
			_tmp155_.green = 0.603922f;
			_tmp155_.blue = 0.0235294f;
			_tmp155_.alpha = 1.0f;
			gtk_snapshot_append_fill (s, _tmp154_, GSK_FILL_RULE_EVEN_ODD, &_tmp155_);
			_gsk_path_unref0 (_tmp154_);
			_tmp156_ = gsk_path_builder_new ();
			p1 = _tmp156_;
			_tmp157_ = p1;
			gsk_path_builder_move_to (_tmp157_, x + (x_m * 14), y + (y_m * 9));
			_tmp158_ = p1;
			gsk_path_builder_cubic_to (_tmp158_, x + (x_m * 14), y + (y_m * 5.6875f), x + (x_m * 11.3125f), y + (y_m * 3), x + (x_m * 8), y + (y_m * 3));
			_tmp159_ = p1;
			gsk_path_builder_cubic_to (_tmp159_, x + (x_m * 4.6875f), y + (y_m * 3), x + (x_m * 2), y + (y_m * 5.6875f), x + (x_m * 2), y + (y_m * 9));
			_tmp160_ = p1;
			gsk_path_builder_cubic_to (_tmp160_, x + (x_m * 2), y + (y_m * 12.3125f), x + (x_m * 4.6875f), y + (y_m * 15), x + (x_m * 8), y + (y_m * 15));
			_tmp161_ = p1;
			gsk_path_builder_cubic_to (_tmp161_, x + (x_m * 11.3125f), y + (y_m * 15), x + (x_m * 14), y + (y_m * 12.3125f), x + (x_m * 14), y + (y_m * 9));
			_tmp162_ = p1;
			_tmp163_ = gsk_path_builder_to_path (_tmp162_);
			_tmp164_ = _tmp163_;
			_tmp165_.red = 0.960784f;
			_tmp165_.green = 0.47451f;
			_tmp165_.blue = 0.0f;
			_tmp165_.alpha = 1.0f;
			gtk_snapshot_append_fill (s, _tmp164_, GSK_FILL_RULE_EVEN_ODD, &_tmp165_);
			_gsk_path_unref0 (_tmp164_);
			_gsk_path_builder_unref0 (p1);
			_gsk_path_builder_unref0 (p0);
			break;
		}
		case 7:
		{
			GskPathBuilder* p0 = NULL;
			GskPathBuilder* _tmp166_;
			GskPathBuilder* _tmp167_;
			GskPathBuilder* _tmp168_;
			GskPathBuilder* _tmp169_;
			GskPathBuilder* _tmp170_;
			GskPathBuilder* _tmp171_;
			GskPath* _tmp172_;
			GskPath* _tmp173_;
			GdkRGBA _tmp174_ = {0};
			GskPathBuilder* p1 = NULL;
			GskPathBuilder* _tmp175_;
			GskPathBuilder* _tmp176_;
			GskPathBuilder* _tmp177_;
			GskPathBuilder* _tmp178_;
			GskPathBuilder* _tmp179_;
			GskPathBuilder* _tmp180_;
			GskPathBuilder* _tmp181_;
			GskPathBuilder* _tmp182_;
			GskPathBuilder* _tmp183_;
			GskPath* _tmp184_;
			GskPath* _tmp185_;
			GdkRGBA _tmp186_ = {0};
			x_m /= (gfloat) 16;
			y_m /= (gfloat) 16;
			_tmp166_ = gsk_path_builder_new ();
			p0 = _tmp166_;
			_tmp167_ = p0;
			gsk_path_builder_move_to (_tmp167_, x + (x_m * 4.585938f), y + (y_m * 0.96875f));
			_tmp168_ = p0;
			gsk_path_builder_cubic_to (_tmp168_, x + (x_m * 3.914063f), y + (y_m * 3.050781f), x + (x_m * 5.65625f), y + (y_m * 4.042969f), x + (x_m * 7), y + (y_m * 5.429688f));
			_tmp169_ = p0;
			gsk_path_builder_line_to (_tmp169_, x + (x_m * 7.421875f), y + (y_m * 4.710938f));
			_tmp170_ = p0;
			gsk_path_builder_cubic_to (_tmp170_, x + (x_m * 6.417969f), y + (y_m * 3.871094f), x + (x_m * 5.867188f), y + (y_m * 1.597656f), x + (x_m * 6.960938f), y + (y_m * 0.738281f));
			_tmp171_ = p0;
			_tmp172_ = gsk_path_builder_to_path (_tmp171_);
			_tmp173_ = _tmp172_;
			_tmp174_.red = 0.305882f;
			_tmp174_.green = 0.603922f;
			_tmp174_.blue = 0.0235294f;
			_tmp174_.alpha = 1.0f;
			gtk_snapshot_append_fill (s, _tmp173_, GSK_FILL_RULE_EVEN_ODD, &_tmp174_);
			_gsk_path_unref0 (_tmp173_);
			_tmp175_ = gsk_path_builder_new ();
			p1 = _tmp175_;
			_tmp176_ = p1;
			gsk_path_builder_move_to (_tmp176_, x + (x_m * 12.933594f), y + (y_m * 5.347656f));
			_tmp177_ = p1;
			gsk_path_builder_cubic_to (_tmp177_, x + (x_m * 13.652344f), y + (y_m * 7.882813f), x + (x_m * 12.867188f), y + (y_m * 8.753906f), x + (x_m * 12.871094f), y + (y_m * 10.476563f));
			_tmp178_ = p1;
			gsk_path_builder_cubic_to (_tmp178_, x + (x_m * 12.875f), y + (y_m * 12.890625f), x + (x_m * 13.015625f), y + (y_m * 14.386719f), x + (x_m * 11.148438f), y + (y_m * 15.089844f));
			_tmp179_ = p1;
			gsk_path_builder_cubic_to (_tmp179_, x + (x_m * 9.941406f), y + (y_m * 15.492188f), x + (x_m * 8.785156f), y + (y_m * 15.382813f), x + (x_m * 6.539063f), y + (y_m * 12.617188f));
			_tmp180_ = p1;
			gsk_path_builder_cubic_to (_tmp180_, x + (x_m * 5.886719f), y + (y_m * 11.765625f), x + (x_m * 4.117188f), y + (y_m * 11.683594f), x + (x_m * 3.226563f), y + (y_m * 10.214844f));
			_tmp181_ = p1;
			gsk_path_builder_cubic_to (_tmp181_, x + (x_m * 2.117188f), y + (y_m * 8.375f), x + (x_m * 2.902344f), y + (y_m * 5.152344f), x + (x_m * 6.707031f), y + (y_m * 4.464844f));
			_tmp182_ = p1;
			gsk_path_builder_cubic_to (_tmp182_, x + (x_m * 8.609375f), y + (y_m * 2.308594f), x + (x_m * 11.933594f), y + (y_m * 3.136719f), x + (x_m * 12.933594f), y + (y_m * 5.347656f));
			_tmp183_ = p1;
			_tmp184_ = gsk_path_builder_to_path (_tmp183_);
			_tmp185_ = _tmp184_;
			_tmp186_.red = 0.937255f;
			_tmp186_.green = 0.160784f;
			_tmp186_.blue = 0.160784f;
			_tmp186_.alpha = 1.0f;
			gtk_snapshot_append_fill (s, _tmp185_, GSK_FILL_RULE_EVEN_ODD, &_tmp186_);
			_gsk_path_unref0 (_tmp185_);
			_gsk_path_builder_unref0 (p1);
			_gsk_path_builder_unref0 (p0);
			break;
		}
		default:
		{
			break;
		}
	}
}

static void
_vala_PangoFontDescription_free (PangoFontDescription* self)
{
	g_boxed_free (pango_font_description_get_type (), self);
}

static PangoFontDescription*
_vala_PangoFontDescription_copy (PangoFontDescription* self)
{
	return g_boxed_copy (pango_font_description_get_type (), self);
}

static gpointer
__vala_PangoFontDescription_copy0 (gpointer self)
{
	return self ? _vala_PangoFontDescription_copy (self) : NULL;
}

static void
nibbles_view_draw_text_target_width (NibblesView* self,
                                     GtkSnapshot* snapshot,
                                     gint x,
                                     gint y,
                                     const gchar* text,
                                     gint target_width,
                                     gint color)
{
	gint target_font_size = 0;
	guint target_width_diff = 0U;
	PangoRectangle a = {0};
	PangoRectangle _tmp0_ = {0};
	PangoRectangle _tmp21_;
	PangoRectangle _tmp22_;
	graphene_point_t _tmp23_ = {0};
	PangoLayout* layout = NULL;
	PangoLayout* _tmp24_;
	PangoFontDescription* _tmp25_ = NULL;
	PangoLayout* _tmp26_;
	PangoFontDescription* _tmp27_;
	PangoFontDescription* font = NULL;
	PangoFontDescription* _tmp32_;
	PangoLayout* _tmp33_;
	PangoLayout* _tmp34_;
	PangoLayout* _tmp35_;
	GdkRGBA _tmp36_ = {0};
	PangoRectangle _tmp37_;
	PangoRectangle _tmp38_;
	graphene_point_t _tmp39_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (snapshot != NULL);
	g_return_if_fail (text != NULL);
	target_font_size = 1;
	target_width_diff = G_MAXUINT;
	_tmp0_.x = 0;
	_tmp0_.y = 0;
	_tmp0_.width = 0;
	_tmp0_.height = 0;
	a = _tmp0_;
	{
		gint font_size = 0;
		font_size = 1;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				PangoLayout* layout = NULL;
				PangoLayout* _tmp3_;
				PangoFontDescription* _tmp4_ = NULL;
				PangoLayout* _tmp5_;
				PangoFontDescription* _tmp6_;
				PangoFontDescription* font = NULL;
				PangoFontDescription* _tmp11_;
				PangoFontDescription* _tmp12_;
				PangoLayout* _tmp13_;
				PangoFontDescription* _tmp14_;
				PangoLayout* _tmp15_;
				PangoRectangle b = {0};
				PangoLayout* _tmp16_;
				PangoRectangle _tmp17_ = {0};
				PangoRectangle _tmp18_ = {0};
				guint width_diff = 0U;
				PangoRectangle _tmp19_;
				gboolean _tmp20_ = FALSE;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = font_size;
					font_size = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(font_size < 200)) {
					break;
				}
				_tmp3_ = gtk_widget_create_pango_layout ((GtkWidget*) self, text);
				layout = _tmp3_;
				_tmp5_ = layout;
				_tmp6_ = pango_layout_get_font_description (_tmp5_);
				if (NULL == _tmp6_) {
					PangoFontDescription* _tmp7_;
					_tmp7_ = pango_font_description_from_string ("Sans Bold 1pt");
					__vala_PangoFontDescription_free0 (_tmp4_);
					_tmp4_ = _tmp7_;
				} else {
					PangoLayout* _tmp8_;
					PangoFontDescription* _tmp9_;
					PangoFontDescription* _tmp10_;
					_tmp8_ = layout;
					_tmp9_ = pango_layout_get_font_description (_tmp8_);
					_tmp10_ = pango_font_description_copy (_tmp9_);
					__vala_PangoFontDescription_free0 (_tmp4_);
					_tmp4_ = _tmp10_;
				}
				_tmp11_ = __vala_PangoFontDescription_copy0 (_tmp4_);
				font = _tmp11_;
				_tmp12_ = font;
				pango_font_description_set_size (_tmp12_, PANGO_SCALE * font_size);
				_tmp13_ = layout;
				_tmp14_ = font;
				pango_layout_set_font_description (_tmp13_, _tmp14_);
				_tmp15_ = layout;
				pango_layout_set_text (_tmp15_, text, -1);
				_tmp16_ = layout;
				pango_layout_get_extents (_tmp16_, &_tmp17_, &_tmp18_);
				a = _tmp17_;
				b = _tmp18_;
				_tmp19_ = a;
				width_diff = (guint) abs (target_width - (((gint) _tmp19_.width) / PANGO_SCALE));
				if (width_diff > target_width_diff) {
					_tmp20_ = (width_diff - target_width_diff) > ((guint) 2);
				} else {
					_tmp20_ = FALSE;
				}
				if (_tmp20_) {
					__vala_PangoFontDescription_free0 (font);
					__vala_PangoFontDescription_free0 (_tmp4_);
					_g_object_unref0 (layout);
					break;
				} else {
					if (width_diff < target_width_diff) {
						target_width_diff = width_diff;
						target_font_size = font_size;
					}
				}
				__vala_PangoFontDescription_free0 (font);
				__vala_PangoFontDescription_free0 (_tmp4_);
				_g_object_unref0 (layout);
			}
		}
	}
	_tmp21_ = a;
	_tmp22_ = a;
	_tmp23_.x = (gfloat) (x - (_tmp21_.x / PANGO_SCALE));
	_tmp23_.y = (gfloat) (y - (_tmp22_.y / PANGO_SCALE));
	gtk_snapshot_translate (snapshot, &_tmp23_);
	_tmp24_ = gtk_widget_create_pango_layout ((GtkWidget*) self, text);
	layout = _tmp24_;
	_tmp26_ = layout;
	_tmp27_ = pango_layout_get_font_description (_tmp26_);
	if (NULL == _tmp27_) {
		PangoFontDescription* _tmp28_;
		_tmp28_ = pango_font_description_from_string ("Sans Bold 1pt");
		__vala_PangoFontDescription_free0 (_tmp25_);
		_tmp25_ = _tmp28_;
	} else {
		PangoLayout* _tmp29_;
		PangoFontDescription* _tmp30_;
		PangoFontDescription* _tmp31_;
		_tmp29_ = layout;
		_tmp30_ = pango_layout_get_font_description (_tmp29_);
		_tmp31_ = pango_font_description_copy (_tmp30_);
		__vala_PangoFontDescription_free0 (_tmp25_);
		_tmp25_ = _tmp31_;
	}
	_tmp32_ = __vala_PangoFontDescription_copy0 (_tmp25_);
	font = _tmp32_;
	pango_font_description_set_size (font, PANGO_SCALE * target_font_size);
	_tmp33_ = layout;
	pango_layout_set_font_description (_tmp33_, font);
	_tmp34_ = layout;
	pango_layout_set_text (_tmp34_, text, -1);
	_tmp35_ = layout;
	_tmp36_.red = (gfloat) 1;
	_tmp36_.green = (gfloat) 1;
	_tmp36_.blue = (gfloat) 1;
	_tmp36_.alpha = (gfloat) 1;
	gtk_snapshot_append_layout (snapshot, _tmp35_, &_tmp36_);
	_tmp37_ = a;
	_tmp38_ = a;
	_tmp39_.x = (gfloat) (-(x - (_tmp37_.x / PANGO_SCALE)));
	_tmp39_.y = (gfloat) (-(y - (_tmp38_.y / PANGO_SCALE)));
	gtk_snapshot_translate (snapshot, &_tmp39_);
	__vala_PangoFontDescription_free0 (font);
	__vala_PangoFontDescription_free0 (_tmp25_);
	_g_object_unref0 (layout);
}

static void
nibbles_view_calculate_text_size (NibblesView* self,
                                  const gchar* text,
                                  gint font_size,
                                  gdouble* width,
                                  gdouble* height)
{
	gdouble _vala_width = 0.0;
	gdouble _vala_height = 0.0;
	PangoLayout* layout = NULL;
	PangoLayout* _tmp0_;
	PangoFontDescription* _tmp1_ = NULL;
	PangoLayout* _tmp2_;
	PangoFontDescription* _tmp3_;
	PangoFontDescription* font = NULL;
	PangoFontDescription* _tmp8_;
	PangoLayout* _tmp9_;
	PangoLayout* _tmp10_;
	PangoRectangle a = {0};
	PangoRectangle b = {0};
	PangoLayout* _tmp11_;
	PangoRectangle _tmp12_ = {0};
	PangoRectangle _tmp13_ = {0};
	PangoRectangle _tmp14_;
	PangoRectangle _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = gtk_widget_create_pango_layout ((GtkWidget*) self, text);
	layout = _tmp0_;
	_tmp2_ = layout;
	_tmp3_ = pango_layout_get_font_description (_tmp2_);
	if (NULL == _tmp3_) {
		PangoFontDescription* _tmp4_;
		_tmp4_ = pango_font_description_from_string ("Sans Bold 1pt");
		__vala_PangoFontDescription_free0 (_tmp1_);
		_tmp1_ = _tmp4_;
	} else {
		PangoLayout* _tmp5_;
		PangoFontDescription* _tmp6_;
		PangoFontDescription* _tmp7_;
		_tmp5_ = layout;
		_tmp6_ = pango_layout_get_font_description (_tmp5_);
		_tmp7_ = pango_font_description_copy (_tmp6_);
		__vala_PangoFontDescription_free0 (_tmp1_);
		_tmp1_ = _tmp7_;
	}
	_tmp8_ = __vala_PangoFontDescription_copy0 (_tmp1_);
	font = _tmp8_;
	pango_font_description_set_size (font, PANGO_SCALE * font_size);
	_tmp9_ = layout;
	pango_layout_set_font_description (_tmp9_, font);
	_tmp10_ = layout;
	pango_layout_set_text (_tmp10_, text, -1);
	_tmp11_ = layout;
	pango_layout_get_extents (_tmp11_, &_tmp12_, &_tmp13_);
	a = _tmp12_;
	b = _tmp13_;
	_tmp14_ = a;
	_vala_width = (gdouble) (_tmp14_.width / PANGO_SCALE);
	_tmp15_ = a;
	_vala_height = (gdouble) (_tmp15_.height / PANGO_SCALE);
	__vala_PangoFontDescription_free0 (font);
	__vala_PangoFontDescription_free0 (_tmp1_);
	_g_object_unref0 (layout);
	if (width) {
		*width = _vala_width;
	}
	if (height) {
		*height = _vala_height;
	}
}

static void
nibbles_view_draw_text_font_size (NibblesView* self,
                                  GtkSnapshot* snapshot,
                                  gint x,
                                  gint y,
                                  const gchar* text,
                                  gint font_size)
{
	gint x_offset = 0;
	gint y_offset = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	graphene_point_t _tmp2_ = {0};
	PangoLayout* layout = NULL;
	PangoLayout* _tmp3_;
	PangoLayout* _tmp4_;
	PangoFontDescription* _tmp5_ = NULL;
	PangoLayout* _tmp6_;
	PangoFontDescription* _tmp7_;
	PangoFontDescription* font = NULL;
	PangoFontDescription* _tmp12_;
	PangoLayout* _tmp13_;
	PangoLayout* _tmp14_;
	PangoLayout* _tmp15_;
	GdkRGBA _tmp16_ = {0};
	graphene_point_t _tmp17_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (snapshot != NULL);
	g_return_if_fail (text != NULL);
	nibbles_view_get_text_offsets (self, text, font_size, &_tmp0_, &_tmp1_);
	x_offset = _tmp0_;
	y_offset = _tmp1_;
	_tmp2_.x = (gfloat) (x - x_offset);
	_tmp2_.y = (gfloat) (y - y_offset);
	gtk_snapshot_translate (snapshot, &_tmp2_);
	_tmp3_ = gtk_widget_create_pango_layout ((GtkWidget*) self, text);
	layout = _tmp3_;
	_tmp4_ = layout;
	pango_layout_set_alignment (_tmp4_, 1);
	_tmp6_ = layout;
	_tmp7_ = pango_layout_get_font_description (_tmp6_);
	if (NULL == _tmp7_) {
		PangoFontDescription* _tmp8_;
		_tmp8_ = pango_font_description_from_string ("Sans Bold 1pt");
		__vala_PangoFontDescription_free0 (_tmp5_);
		_tmp5_ = _tmp8_;
	} else {
		PangoLayout* _tmp9_;
		PangoFontDescription* _tmp10_;
		PangoFontDescription* _tmp11_;
		_tmp9_ = layout;
		_tmp10_ = pango_layout_get_font_description (_tmp9_);
		_tmp11_ = pango_font_description_copy (_tmp10_);
		__vala_PangoFontDescription_free0 (_tmp5_);
		_tmp5_ = _tmp11_;
	}
	_tmp12_ = __vala_PangoFontDescription_copy0 (_tmp5_);
	font = _tmp12_;
	pango_font_description_set_size (font, PANGO_SCALE * font_size);
	_tmp13_ = layout;
	pango_layout_set_font_description (_tmp13_, font);
	_tmp14_ = layout;
	pango_layout_set_text (_tmp14_, text, -1);
	_tmp15_ = layout;
	_tmp16_.red = (gfloat) 1;
	_tmp16_.green = (gfloat) 1;
	_tmp16_.blue = (gfloat) 1;
	_tmp16_.alpha = (gfloat) 1;
	gtk_snapshot_append_layout (snapshot, _tmp15_, &_tmp16_);
	_tmp17_.x = (gfloat) (-(x - x_offset));
	_tmp17_.y = (gfloat) (-(y - y_offset));
	gtk_snapshot_translate (snapshot, &_tmp17_);
	__vala_PangoFontDescription_free0 (font);
	__vala_PangoFontDescription_free0 (_tmp5_);
	_g_object_unref0 (layout);
}

static void
nibbles_view_get_text_offsets (NibblesView* self,
                               const gchar* text,
                               gint font_size,
                               gint* x_offset,
                               gint* y_offset)
{
	gint _vala_x_offset = 0;
	gint _vala_y_offset = 0;
	PangoLayout* layout = NULL;
	PangoLayout* _tmp0_;
	PangoFontDescription* _tmp1_ = NULL;
	PangoLayout* _tmp2_;
	PangoFontDescription* _tmp3_;
	PangoFontDescription* font = NULL;
	PangoFontDescription* _tmp8_;
	PangoLayout* _tmp9_;
	PangoLayout* _tmp10_;
	PangoRectangle a = {0};
	PangoRectangle b = {0};
	PangoLayout* _tmp11_;
	PangoRectangle _tmp12_ = {0};
	PangoRectangle _tmp13_ = {0};
	PangoRectangle _tmp14_;
	PangoRectangle _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = gtk_widget_create_pango_layout ((GtkWidget*) self, text);
	layout = _tmp0_;
	_tmp2_ = layout;
	_tmp3_ = pango_layout_get_font_description (_tmp2_);
	if (NULL == _tmp3_) {
		PangoFontDescription* _tmp4_;
		_tmp4_ = pango_font_description_from_string ("Sans Bold 1pt");
		__vala_PangoFontDescription_free0 (_tmp1_);
		_tmp1_ = _tmp4_;
	} else {
		PangoLayout* _tmp5_;
		PangoFontDescription* _tmp6_;
		PangoFontDescription* _tmp7_;
		_tmp5_ = layout;
		_tmp6_ = pango_layout_get_font_description (_tmp5_);
		_tmp7_ = pango_font_description_copy (_tmp6_);
		__vala_PangoFontDescription_free0 (_tmp1_);
		_tmp1_ = _tmp7_;
	}
	_tmp8_ = __vala_PangoFontDescription_copy0 (_tmp1_);
	font = _tmp8_;
	pango_font_description_set_size (font, PANGO_SCALE * font_size);
	_tmp9_ = layout;
	pango_layout_set_font_description (_tmp9_, font);
	_tmp10_ = layout;
	pango_layout_set_text (_tmp10_, text, -1);
	_tmp11_ = layout;
	pango_layout_get_extents (_tmp11_, &_tmp12_, &_tmp13_);
	a = _tmp12_;
	b = _tmp13_;
	_tmp14_ = a;
	_vala_x_offset = _tmp14_.x / PANGO_SCALE;
	_tmp15_ = a;
	_vala_y_offset = _tmp15_.y / PANGO_SCALE;
	__vala_PangoFontDescription_free0 (font);
	__vala_PangoFontDescription_free0 (_tmp1_);
	_g_object_unref0 (layout);
	if (x_offset) {
		*x_offset = _vala_x_offset;
	}
	if (y_offset) {
		*y_offset = _vala_y_offset;
	}
}

gchar*
nibbles_view_colorval_name_untranslated (gint colorval)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	_tmp0_ = nibbles_view_color_lookup;
	_tmp0__length1 = nibbles_view_color_lookup_length1;
	_tmp0__length2 = nibbles_view_color_lookup_length2;
	_tmp1_ = _tmp0_[(colorval * _tmp0__length2) + 0];
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}

static void
nibbles_view_get_bounds (NibblesView* self,
                         GskPath* path,
                         graphene_rect_t* result)
{
	graphene_rect_t bounds = {0};
	graphene_rect_t _tmp0_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	gsk_path_get_bounds (path, &_tmp0_);
	bounds = _tmp0_;
	*result = bounds;
	return;
}

static inline gpointer
nibbles_view_view3_d_get_instance_private (NibblesViewView3D* self)
{
	return G_STRUCT_MEMBER_P (self, NibblesViewView3D_private_offset);
}

static void
nibbles_view_view3_d_set_view_plain (NibblesViewView3D* self,
                                     gdouble y)
{
	g_return_if_fail (self != NULL);
	self->priv->view_plain_y = y;
	self->priv->has_view_plain_been_set = TRUE;
}

static void
nibbles_view_view3_d_set_view_point (NibblesViewView3D* self,
                                     NibblesViewPoint3D* point,
                                     gdouble max_object_height)
{
	NibblesViewPoint3D _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (point != NULL);
	_tmp0_ = *point;
	self->priv->view_point = _tmp0_;
	if (self->priv->has_view_plain_been_set) {
		_tmp1_ = !self->priv->has_view_plain_z_height_been_set;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		NibblesViewPoint3D _tmp2_;
		NibblesViewPoint3D _tmp3_;
		_tmp2_ = *point;
		_tmp3_ = *point;
		self->priv->view_plain_z_height = (((_tmp2_.z - max_object_height) * self->priv->view_plain_y) / _tmp3_.y) + max_object_height;
	}
}

static void
nibbles_view_view3_d_set_scale_x (NibblesViewView3D* self,
                                  gdouble scale)
{
	g_return_if_fail (self != NULL);
	self->priv->x_scale = scale;
}

static void
nibbles_view_view3_d_set_scale_y (NibblesViewView3D* self,
                                  gdouble scale)
{
	g_return_if_fail (self != NULL);
	self->priv->y_scale = scale;
}

static void
nibbles_view_view3_d_to_view_plain (NibblesViewView3D* self,
                                    NibblesViewPoint3D* point,
                                    gdouble* x_at_plain,
                                    gdouble* z_at_plain)
{
	gdouble _vala_x_at_plain = 0.0;
	gdouble _vala_z_at_plain = 0.0;
	gdouble base_length = 0.0;
	NibblesViewPoint3D _tmp0_;
	NibblesViewPoint3D _tmp1_;
	NibblesViewPoint3D _tmp2_;
	NibblesViewPoint3D _tmp3_;
	NibblesViewPoint3D _tmp4_;
	NibblesViewPoint3D _tmp5_;
	NibblesViewPoint3D _tmp6_;
	NibblesViewPoint3D _tmp7_;
	gdouble z_length = 0.0;
	NibblesViewPoint3D _tmp8_;
	NibblesViewPoint3D _tmp9_;
	gdouble base_length_to_view_plain = 0.0;
	NibblesViewPoint3D _tmp10_;
	NibblesViewPoint3D _tmp11_;
	NibblesViewPoint3D _tmp12_;
	NibblesViewPoint3D _tmp13_;
	gdouble x_length = 0.0;
	NibblesViewPoint3D _tmp14_;
	NibblesViewPoint3D _tmp15_;
	NibblesViewPoint3D _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (point != NULL);
	_tmp0_ = self->priv->view_point;
	_tmp1_ = *point;
	_tmp2_ = self->priv->view_point;
	_tmp3_ = *point;
	_tmp4_ = self->priv->view_point;
	_tmp5_ = *point;
	_tmp6_ = self->priv->view_point;
	_tmp7_ = *point;
	base_length = sqrt (((_tmp0_.x - _tmp1_.x) * (_tmp2_.x - _tmp3_.x)) + ((_tmp4_.y - _tmp5_.y) * (_tmp6_.y - _tmp7_.y)));
	_tmp8_ = self->priv->view_point;
	_tmp9_ = *point;
	z_length = _tmp8_.z - _tmp9_.z;
	_tmp10_ = *point;
	_tmp11_ = self->priv->view_point;
	_tmp12_ = *point;
	base_length_to_view_plain = ((self->priv->view_plain_y - _tmp10_.y) / (_tmp11_.y - _tmp12_.y)) * base_length;
	_tmp13_ = *point;
	_vala_z_at_plain = (self->priv->view_plain_z_height - (_tmp13_.z + ((base_length_to_view_plain / base_length) * z_length))) * self->priv->y_scale;
	_tmp14_ = self->priv->view_point;
	_tmp15_ = *point;
	x_length = _tmp14_.x - _tmp15_.x;
	_tmp16_ = *point;
	_vala_x_at_plain = (_tmp16_.x + ((base_length_to_view_plain / base_length) * x_length)) * self->priv->x_scale;
	if (x_at_plain) {
		*x_at_plain = _vala_x_at_plain;
	}
	if (z_at_plain) {
		*z_at_plain = _vala_z_at_plain;
	}
}

static gdouble
nibbles_view_view3_d_view_point_x (NibblesViewView3D* self)
{
	NibblesViewPoint3D _tmp0_;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->priv->view_point;
	result = _tmp0_.x;
	return result;
}

static gdouble
nibbles_view_view3_d_2D_diff (NibblesViewView3D* self,
                              NibblesViewPoint3D* a,
                              NibblesViewPoint3D* b)
{
	gdouble ax = 0.0;
	gdouble ay = 0.0;
	gdouble bx = 0.0;
	gdouble by = 0.0;
	NibblesViewPoint3D _tmp0_;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	NibblesViewPoint3D _tmp3_;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	g_return_val_if_fail (a != NULL, 0.0);
	g_return_val_if_fail (b != NULL, 0.0);
	_tmp0_ = *a;
	nibbles_view_view3_d_to_view_plain (self, &_tmp0_, &_tmp1_, &_tmp2_);
	ax = _tmp1_;
	ay = _tmp2_;
	_tmp3_ = *b;
	nibbles_view_view3_d_to_view_plain (self, &_tmp3_, &_tmp4_, &_tmp5_);
	bx = _tmp4_;
	by = _tmp5_;
	result = sqrt (((ax - bx) * (ax - bx)) + ((ay - by) * (ay - by)));
	return result;
}

static NibblesViewView3D*
nibbles_view_view3_d_construct (GType object_type)
{
	NibblesViewView3D* self = NULL;
	self = (NibblesViewView3D*) g_type_create_instance (object_type);
	return self;
}

static NibblesViewView3D*
nibbles_view_view3_d_new (void)
{
	return nibbles_view_view3_d_construct (NIBBLES_VIEW_TYPE_VIEW3_D);
}

static void
nibbles_view_value_view3_d_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
nibbles_view_value_view3_d_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		nibbles_view_view3_d_unref (value->data[0].v_pointer);
	}
}

static void
nibbles_view_value_view3_d_copy_value (const GValue* src_value,
                                       GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = nibbles_view_view3_d_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
nibbles_view_value_view3_d_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
nibbles_view_value_view3_d_collect_value (GValue* value,
                                          guint n_collect_values,
                                          GTypeCValue* collect_values,
                                          guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		NibblesViewView3D * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = nibbles_view_view3_d_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
nibbles_view_value_view3_d_lcopy_value (const GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
	NibblesViewView3D ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = nibbles_view_view3_d_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
nibbles_view_param_spec_view3_d (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags)
{
	NibblesViewParamSpecView3D* spec;
	g_return_val_if_fail (g_type_is_a (object_type, NIBBLES_VIEW_TYPE_VIEW3_D), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
nibbles_view_value_get_view3_d (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, NIBBLES_VIEW_TYPE_VIEW3_D), NULL);
	return value->data[0].v_pointer;
}

static void
nibbles_view_value_set_view3_d (GValue* value,
                                gpointer v_object)
{
	NibblesViewView3D * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, NIBBLES_VIEW_TYPE_VIEW3_D));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, NIBBLES_VIEW_TYPE_VIEW3_D));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		nibbles_view_view3_d_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		nibbles_view_view3_d_unref (old);
	}
}

static void
nibbles_view_value_take_view3_d (GValue* value,
                                 gpointer v_object)
{
	NibblesViewView3D * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, NIBBLES_VIEW_TYPE_VIEW3_D));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, NIBBLES_VIEW_TYPE_VIEW3_D));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		nibbles_view_view3_d_unref (old);
	}
}

static void
nibbles_view_view3_d_class_init (NibblesViewView3DClass * klass,
                                 gpointer klass_data)
{
	nibbles_view_view3_d_parent_class = g_type_class_peek_parent (klass);
	((NibblesViewView3DClass *) klass)->finalize = nibbles_view_view3_d_finalize;
	g_type_class_adjust_private_offset (klass, &NibblesViewView3D_private_offset);
}

static void
nibbles_view_view3_d_instance_init (NibblesViewView3D * self,
                                    gpointer klass)
{
	self->priv = nibbles_view_view3_d_get_instance_private (self);
	self->priv->has_view_plain_been_set = FALSE;
	self->priv->has_view_plain_z_height_been_set = FALSE;
	self->priv->x_scale = (gdouble) 1;
	self->priv->y_scale = (gdouble) 1;
	self->ref_count = 1;
}

static void
nibbles_view_view3_d_finalize (NibblesViewView3D * obj)
{
	NibblesViewView3D * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NIBBLES_VIEW_TYPE_VIEW3_D, NibblesViewView3D);
	g_signal_handlers_destroy (self);
}

 G_GNUC_NO_INLINE static GType
nibbles_view_view3_d_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { nibbles_view_value_view3_d_init, nibbles_view_value_view3_d_free_value, nibbles_view_value_view3_d_copy_value, nibbles_view_value_view3_d_peek_pointer, "p", nibbles_view_value_view3_d_collect_value, "p", nibbles_view_value_view3_d_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (NibblesViewView3DClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) nibbles_view_view3_d_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NibblesViewView3D), 0, (GInstanceInitFunc) nibbles_view_view3_d_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType nibbles_view_view3_d_type_id;
	nibbles_view_view3_d_type_id = g_type_register_fundamental (g_type_fundamental_next (), "NibblesViewView3D", &g_define_type_info, &g_define_type_fundamental_info, 0);
	NibblesViewView3D_private_offset = g_type_add_instance_private (nibbles_view_view3_d_type_id, sizeof (NibblesViewView3DPrivate));
	return nibbles_view_view3_d_type_id;
}

static GType
nibbles_view_view3_d_get_type (void)
{
	static gsize nibbles_view_view3_d_type_id__once = 0;
	if (g_once_init_enter (&nibbles_view_view3_d_type_id__once)) {
		GType nibbles_view_view3_d_type_id;
		nibbles_view_view3_d_type_id = nibbles_view_view3_d_get_type_once ();
		g_once_init_leave (&nibbles_view_view3_d_type_id__once, nibbles_view_view3_d_type_id);
	}
	return nibbles_view_view3_d_type_id__once;
}

static gpointer
nibbles_view_view3_d_ref (gpointer instance)
{
	NibblesViewView3D * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
nibbles_view_view3_d_unref (gpointer instance)
{
	NibblesViewView3D * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		NIBBLES_VIEW_VIEW3_D_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
nibbles_view_static_view_get_instance_private (NibblesViewStaticView* self)
{
	return G_STRUCT_MEMBER_P (self, NibblesViewStaticView_private_offset);
}

void
nibbles_view_static_view_redraw (NibblesViewStaticView* self)
{
	g_return_if_fail (self != NULL);
	gtk_widget_queue_draw ((GtkWidget*) self);
}

NibblesViewStaticView*
nibbles_view_static_view_construct (GType object_type,
                                    NibblesView* view)
{
	NibblesViewStaticView * self = NULL;
	g_return_val_if_fail (view != NULL, NULL);
	self = (NibblesViewStaticView*) g_object_new (object_type, NULL);
	self->priv->view = view;
	return self;
}

NibblesViewStaticView*
nibbles_view_static_view_new (NibblesView* view)
{
	return nibbles_view_static_view_construct (NIBBLES_VIEW_TYPE_STATIC_VIEW, view);
}

static GskPath*
nibbles_view_static_view_rectangle (NibblesViewStaticView* self,
                                    guint x,
                                    guint y,
                                    guint width,
                                    guint height)
{
	GskPathBuilder* r = NULL;
	GskPathBuilder* _tmp0_;
	graphene_rect_t _tmp1_ = {0};
	GskPath* _tmp2_;
	GskPath* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gsk_path_builder_new ();
	r = _tmp0_;
	_tmp1_.origin = (graphene_point_t) {(gfloat) x, (gfloat) y};
	_tmp1_.size = (graphene_size_t) {(gfloat) width, (gfloat) height};
	gsk_path_builder_add_rect (r, &_tmp1_);
	_tmp2_ = gsk_path_builder_to_path (r);
	result = _tmp2_;
	_gsk_path_builder_unref0 (r);
	return result;
}

static void
nibbles_view_static_view_real_snapshot (GtkWidget* base,
                                        GtkSnapshot* s)
{
	NibblesViewStaticView * self;
	NibblesView* _tmp0_;
	NibblesGame* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	self = (NibblesViewStaticView*) base;
	g_return_if_fail (s != NULL);
	_tmp0_ = self->priv->view;
	_tmp1_ = _tmp0_->game;
	_tmp2_ = nibbles_game_get_three_dimensional_view (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		gdouble x2d = 0.0;
		gdouble y2d = 0.0;
		NibblesViewView3D* v = NULL;
		NibblesViewView3D* _tmp4_;
		NibblesViewView3D* _tmp5_;
		NibblesViewView3D* _tmp6_;
		NibblesViewPoint3D _tmp7_ = {0};
		NibblesViewView3D* _tmp8_;
		NibblesViewView3D* _tmp9_;
		NibblesView* _tmp10_;
		NibblesViewFullscreenActiveFunction _tmp11_;
		gpointer _tmp11__target;
		_tmp4_ = nibbles_view_view3_d_new ();
		v = _tmp4_;
		_tmp5_ = v;
		nibbles_view_view3_d_set_view_plain (_tmp5_, (gdouble) NIBBLES_VIEW_HEIGHT);
		_tmp6_ = v;
		_tmp7_.x = ((gdouble) NIBBLES_VIEW_WIDTH) / 2.0;
		_tmp7_.y = 2.0 * ((gdouble) NIBBLES_VIEW_HEIGHT);
		_tmp7_.z = 2.0 * ((gdouble) NIBBLES_VIEW_HEIGHT);
		nibbles_view_view3_d_set_view_point (_tmp6_, &_tmp7_, (gdouble) 1);
		_tmp8_ = v;
		nibbles_view_view3_d_set_scale_x (_tmp8_, (gdouble) (gtk_widget_get_width ((GtkWidget*) self) / NIBBLES_VIEW_WIDTH));
		_tmp9_ = v;
		nibbles_view_view3_d_set_scale_y (_tmp9_, (gdouble) (gtk_widget_get_height ((GtkWidget*) self) / NIBBLES_VIEW_HEIGHT));
		_tmp10_ = self->priv->view;
		_tmp11_ = _tmp10_->priv->fullscreen_active;
		_tmp11__target = _tmp10_->priv->fullscreen_active_target;
		if (_tmp11_ (_tmp11__target)) {
			GskPath* _tmp12_;
			GskPath* _tmp13_;
			GdkRGBA _tmp14_ = {0};
			_tmp12_ = nibbles_view_static_view_rectangle (self, (guint) 0, (guint) 0, (guint) gtk_widget_get_width ((GtkWidget*) self), (guint) gtk_widget_get_height ((GtkWidget*) self));
			_tmp13_ = _tmp12_;
			_tmp14_.red = 0.0f;
			_tmp14_.green = 0.0f;
			_tmp14_.blue = 0.0f;
			_tmp14_.alpha = 1.0f;
			gtk_snapshot_append_fill (s, _tmp13_, GSK_FILL_RULE_EVEN_ODD, &_tmp14_);
			_gsk_path_unref0 (_tmp13_);
		} else {
			GskPathBuilder* background = NULL;
			GskPathBuilder* _tmp15_;
			NibblesViewView3D* _tmp16_;
			NibblesViewPoint3D _tmp17_ = {0};
			gdouble _tmp18_ = 0.0;
			gdouble _tmp19_ = 0.0;
			GskPathBuilder* _tmp20_;
			NibblesViewView3D* _tmp21_;
			NibblesViewPoint3D _tmp22_ = {0};
			gdouble _tmp23_ = 0.0;
			gdouble _tmp24_ = 0.0;
			GskPathBuilder* _tmp25_;
			NibblesViewView3D* _tmp26_;
			NibblesViewPoint3D _tmp27_ = {0};
			gdouble _tmp28_ = 0.0;
			gdouble _tmp29_ = 0.0;
			GskPathBuilder* _tmp30_;
			NibblesViewView3D* _tmp31_;
			NibblesViewPoint3D _tmp32_ = {0};
			gdouble _tmp33_ = 0.0;
			gdouble _tmp34_ = 0.0;
			GskPathBuilder* _tmp35_;
			GskPathBuilder* _tmp36_;
			GskPath* _tmp37_;
			GskPath* _tmp38_;
			GdkRGBA _tmp39_ = {0};
			_tmp15_ = gsk_path_builder_new ();
			background = _tmp15_;
			_tmp16_ = v;
			_tmp17_.x = (gdouble) 0;
			_tmp17_.y = (gdouble) 0;
			_tmp17_.z = (gdouble) 0;
			nibbles_view_view3_d_to_view_plain (_tmp16_, &_tmp17_, &_tmp18_, &_tmp19_);
			x2d = _tmp18_;
			y2d = _tmp19_;
			_tmp20_ = background;
			gsk_path_builder_move_to (_tmp20_, (gfloat) x2d, (gfloat) y2d);
			_tmp21_ = v;
			_tmp22_.x = (gdouble) NIBBLES_VIEW_WIDTH;
			_tmp22_.y = (gdouble) 0;
			_tmp22_.z = (gdouble) 0;
			nibbles_view_view3_d_to_view_plain (_tmp21_, &_tmp22_, &_tmp23_, &_tmp24_);
			x2d = _tmp23_;
			y2d = _tmp24_;
			_tmp25_ = background;
			gsk_path_builder_line_to (_tmp25_, (gfloat) x2d, (gfloat) y2d);
			_tmp26_ = v;
			_tmp27_.x = (gdouble) NIBBLES_VIEW_WIDTH;
			_tmp27_.y = (gdouble) NIBBLES_VIEW_HEIGHT;
			_tmp27_.z = (gdouble) 0;
			nibbles_view_view3_d_to_view_plain (_tmp26_, &_tmp27_, &_tmp28_, &_tmp29_);
			x2d = _tmp28_;
			y2d = _tmp29_;
			_tmp30_ = background;
			gsk_path_builder_line_to (_tmp30_, (gfloat) x2d, (gfloat) y2d);
			_tmp31_ = v;
			_tmp32_.x = (gdouble) 0;
			_tmp32_.y = (gdouble) NIBBLES_VIEW_HEIGHT;
			_tmp32_.z = (gdouble) 0;
			nibbles_view_view3_d_to_view_plain (_tmp31_, &_tmp32_, &_tmp33_, &_tmp34_);
			x2d = _tmp33_;
			y2d = _tmp34_;
			_tmp35_ = background;
			gsk_path_builder_line_to (_tmp35_, (gfloat) x2d, (gfloat) y2d);
			_tmp36_ = background;
			_tmp37_ = gsk_path_builder_to_path (_tmp36_);
			_tmp38_ = _tmp37_;
			_tmp39_.red = 0.0f;
			_tmp39_.green = 0.0f;
			_tmp39_.blue = 0.0f;
			_tmp39_.alpha = 1.0f;
			gtk_snapshot_append_fill (s, _tmp38_, GSK_FILL_RULE_EVEN_ODD, &_tmp39_);
			_gsk_path_unref0 (_tmp38_);
			_gsk_path_builder_unref0 (background);
		}
		_nibbles_view_view3_d_unref0 (v);
	} else {
		static const gdouble max_delta_deviation = 1.15;
		gint x_delta = 0;
		gint y_delta = 0;
		gint x_offset = 0;
		gint y_offset = 0;
		NibblesView* _tmp40_;
		NibblesViewFullscreenActiveFunction _tmp41_;
		gpointer _tmp41__target;
		x_delta = gtk_widget_get_width ((GtkWidget*) self) / NIBBLES_VIEW_WIDTH;
		y_delta = gtk_widget_get_height ((GtkWidget*) self) / NIBBLES_VIEW_HEIGHT;
		if (((gdouble) x_delta) > (max_delta_deviation * y_delta)) {
			x_delta = (gint) (y_delta * max_delta_deviation);
		} else {
			if (((gdouble) y_delta) > (max_delta_deviation * x_delta)) {
				y_delta = (gint) (x_delta * max_delta_deviation);
			}
		}
		x_offset = (gtk_widget_get_width ((GtkWidget*) self) - (x_delta * NIBBLES_VIEW_WIDTH)) / 2;
		y_offset = (gtk_widget_get_height ((GtkWidget*) self) - (y_delta * NIBBLES_VIEW_HEIGHT)) / 2;
		_tmp40_ = self->priv->view;
		_tmp41_ = _tmp40_->priv->fullscreen_active;
		_tmp41__target = _tmp40_->priv->fullscreen_active_target;
		if (_tmp41_ (_tmp41__target)) {
			GskPath* _tmp42_;
			GskPath* _tmp43_;
			GdkRGBA _tmp44_ = {0};
			_tmp42_ = nibbles_view_static_view_rectangle (self, (guint) 0, (guint) 0, (guint) gtk_widget_get_width ((GtkWidget*) self), (guint) gtk_widget_get_height ((GtkWidget*) self));
			_tmp43_ = _tmp42_;
			_tmp44_.red = 0.0f;
			_tmp44_.green = 0.0f;
			_tmp44_.blue = 0.0f;
			_tmp44_.alpha = 1.0f;
			gtk_snapshot_append_fill (s, _tmp43_, GSK_FILL_RULE_EVEN_ODD, &_tmp44_);
			_gsk_path_unref0 (_tmp43_);
		} else {
			GskPath* _tmp45_;
			GskPath* _tmp46_;
			GdkRGBA _tmp47_ = {0};
			_tmp45_ = nibbles_view_static_view_rectangle (self, (guint) x_offset, (guint) y_offset, (guint) (x_delta * NIBBLES_VIEW_WIDTH), (guint) (y_delta * NIBBLES_VIEW_HEIGHT));
			_tmp46_ = _tmp45_;
			_tmp47_.red = 0.0f;
			_tmp47_.green = 0.0f;
			_tmp47_.blue = 0.0f;
			_tmp47_.alpha = 1.0f;
			gtk_snapshot_append_fill (s, _tmp46_, GSK_FILL_RULE_EVEN_ODD, &_tmp47_);
			_gsk_path_unref0 (_tmp46_);
		}
		{
			gint x = 0;
			x = 0;
			{
				gboolean _tmp48_ = FALSE;
				_tmp48_ = TRUE;
				while (TRUE) {
					if (!_tmp48_) {
						gint _tmp49_;
						_tmp49_ = x;
						x = _tmp49_ + 1;
					}
					_tmp48_ = FALSE;
					if (!(x < ((gint) NIBBLES_VIEW_WIDTH))) {
						break;
					}
					{
						gint y = 0;
						y = 0;
						{
							gboolean _tmp50_ = FALSE;
							_tmp50_ = TRUE;
							while (TRUE) {
								gboolean _tmp52_ = FALSE;
								NibblesView* _tmp53_;
								NibblesGame* _tmp54_;
								gint* _tmp55_;
								gint _tmp55__length1;
								gint _tmp55__length2;
								gint _tmp56_;
								if (!_tmp50_) {
									gint _tmp51_;
									_tmp51_ = y;
									y = _tmp51_ + 1;
								}
								_tmp50_ = FALSE;
								if (!(y < ((gint) NIBBLES_VIEW_HEIGHT))) {
									break;
								}
								_tmp53_ = self->priv->view;
								_tmp54_ = _tmp53_->game;
								_tmp55_ = _tmp54_->board;
								_tmp55__length1 = _tmp54_->board_length1;
								_tmp55__length2 = _tmp54_->board_length2;
								_tmp56_ = _tmp55_[(x * _tmp55__length2) + y];
								if (_tmp56_ >= ((gint) 'b')) {
									NibblesView* _tmp57_;
									NibblesGame* _tmp58_;
									gint* _tmp59_;
									gint _tmp59__length1;
									gint _tmp59__length2;
									gint _tmp60_;
									_tmp57_ = self->priv->view;
									_tmp58_ = _tmp57_->game;
									_tmp59_ = _tmp58_->board;
									_tmp59__length1 = _tmp58_->board_length1;
									_tmp59__length2 = _tmp58_->board_length2;
									_tmp60_ = _tmp59_[(x * _tmp59__length2) + y];
									_tmp52_ = _tmp60_ <= ((gint) 'l');
								} else {
									_tmp52_ = FALSE;
								}
								if (_tmp52_) {
									NibblesView* _tmp61_;
									NibblesView* _tmp62_;
									NibblesGame* _tmp63_;
									gint* _tmp64_;
									gint _tmp64__length1;
									gint _tmp64__length2;
									gint _tmp65_;
									_tmp61_ = self->priv->view;
									_tmp62_ = self->priv->view;
									_tmp63_ = _tmp62_->game;
									_tmp64_ = _tmp63_->board;
									_tmp64__length1 = _tmp63_->board_length1;
									_tmp64__length2 = _tmp63_->board_length2;
									_tmp65_ = _tmp64_[(x * _tmp64__length2) + y];
									nibbles_view_draw_wall_segment (_tmp61_, _tmp65_, s, (x_delta * x) + x_offset, (y_delta * y) + y_offset, x_delta, y_delta);
								}
							}
						}
					}
				}
			}
		}
	}
}

static void
nibbles_view_static_view_class_init (NibblesViewStaticViewClass * klass,
                                     gpointer klass_data)
{
	nibbles_view_static_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NibblesViewStaticView_private_offset);
	((GtkWidgetClass *) klass)->snapshot = (void (*) (GtkWidget*, GtkSnapshot*)) nibbles_view_static_view_real_snapshot;
	G_OBJECT_CLASS (klass)->finalize = nibbles_view_static_view_finalize;
}

static void
nibbles_view_static_view_instance_init (NibblesViewStaticView * self,
                                        gpointer klass)
{
	self->priv = nibbles_view_static_view_get_instance_private (self);
}

static void
nibbles_view_static_view_finalize (GObject * obj)
{
	NibblesViewStaticView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NIBBLES_VIEW_TYPE_STATIC_VIEW, NibblesViewStaticView);
	G_OBJECT_CLASS (nibbles_view_static_view_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
nibbles_view_static_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NibblesViewStaticViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) nibbles_view_static_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NibblesViewStaticView), 0, (GInstanceInitFunc) nibbles_view_static_view_instance_init, NULL };
	GType nibbles_view_static_view_type_id;
	nibbles_view_static_view_type_id = g_type_register_static (gtk_widget_get_type (), "NibblesViewStaticView", &g_define_type_info, 0);
	NibblesViewStaticView_private_offset = g_type_add_instance_private (nibbles_view_static_view_type_id, sizeof (NibblesViewStaticViewPrivate));
	return nibbles_view_static_view_type_id;
}

GType
nibbles_view_static_view_get_type (void)
{
	static gsize nibbles_view_static_view_type_id__once = 0;
	if (g_once_init_enter (&nibbles_view_static_view_type_id__once)) {
		GType nibbles_view_static_view_type_id;
		nibbles_view_static_view_type_id = nibbles_view_static_view_get_type_once ();
		g_once_init_leave (&nibbles_view_static_view_type_id__once, nibbles_view_static_view_type_id);
	}
	return nibbles_view_static_view_type_id__once;
}

static inline gpointer
nibbles_view_active_view_get_instance_private (NibblesViewActiveView* self)
{
	return G_STRUCT_MEMBER_P (self, NibblesViewActiveView_private_offset);
}

void
nibbles_view_active_view_redraw (NibblesViewActiveView* self,
                                 gboolean AnimateStep)
{
	g_return_if_fail (self != NULL);
	if (AnimateStep) {
		guint64 _tmp0_;
		self->priv->animate = self->priv->animate + 1;
		_tmp0_ = self->priv->animate;
	}
	gtk_widget_queue_draw ((GtkWidget*) self);
}

NibblesViewActiveView*
nibbles_view_active_view_construct (GType object_type,
                                    NibblesView* view)
{
	NibblesViewActiveView * self = NULL;
	g_return_val_if_fail (view != NULL, NULL);
	self = (NibblesViewActiveView*) g_object_new (object_type, NULL);
	self->priv->view = view;
	return self;
}

NibblesViewActiveView*
nibbles_view_active_view_new (NibblesView* view)
{
	return nibbles_view_active_view_construct (NIBBLES_VIEW_TYPE_ACTIVE_VIEW, view);
}

static void
_vala_array_add5 (Worm** * array,
                  gint* length,
                  gint* size,
                  Worm* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (Worm*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add6 (gint* * array,
                  gint* length,
                  gint* size,
                  gint value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gint, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static void
nibbles_view_active_view_real_snapshot (GtkWidget* base,
                                        GtkSnapshot* s)
{
	NibblesViewActiveView * self;
	NibblesView* _tmp0_;
	NibblesGame* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	self = (NibblesViewActiveView*) base;
	g_return_if_fail (s != NULL);
	_tmp0_ = self->priv->view;
	_tmp1_ = _tmp0_->game;
	_tmp2_ = nibbles_game_get_three_dimensional_view (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		gdouble x2d = 0.0;
		gdouble y2d = 0.0;
		gdouble r = 0.0;
		gdouble g = 0.0;
		gdouble b = 0.0;
		NibblesViewView3D* v = NULL;
		NibblesViewView3D* _tmp4_;
		NibblesViewView3D* _tmp5_;
		NibblesViewView3D* _tmp6_;
		NibblesViewPoint3D _tmp7_ = {0};
		NibblesViewView3D* _tmp8_;
		NibblesViewView3D* _tmp9_;
		Worm** dematerialized_worms = NULL;
		Worm** _tmp10_;
		gint dematerialized_worms_length1;
		gint _dematerialized_worms_size_;
		Worm** worm_at = NULL;
		Worm** _tmp11_;
		gint worm_at_length1;
		gint worm_at_length2;
		Worm** _tmp41_;
		gint _tmp41__length1;
		Bonus** bonus_at = NULL;
		Bonus** _tmp57_;
		gint bonus_at_length1;
		gint bonus_at_length2;
		NibblesView* _tmp314_;
		NibblesViewCountdownActiveFunction _tmp315_;
		gpointer _tmp315__target;
		_tmp4_ = nibbles_view_view3_d_new ();
		v = _tmp4_;
		_tmp5_ = v;
		nibbles_view_view3_d_set_view_plain (_tmp5_, (gdouble) NIBBLES_VIEW_HEIGHT);
		_tmp6_ = v;
		_tmp7_.x = ((gdouble) NIBBLES_VIEW_WIDTH) / 2.0;
		_tmp7_.y = 2.0 * ((gdouble) NIBBLES_VIEW_HEIGHT);
		_tmp7_.z = 2.0 * ((gdouble) NIBBLES_VIEW_HEIGHT);
		nibbles_view_view3_d_set_view_point (_tmp6_, &_tmp7_, (gdouble) 1);
		_tmp8_ = v;
		nibbles_view_view3_d_set_scale_x (_tmp8_, (gdouble) (gtk_widget_get_width ((GtkWidget*) self) / NIBBLES_VIEW_WIDTH));
		_tmp9_ = v;
		nibbles_view_view3_d_set_scale_y (_tmp9_, (gdouble) (gtk_widget_get_height ((GtkWidget*) self) / NIBBLES_VIEW_HEIGHT));
		_tmp10_ = g_new0 (Worm*, 0 + 1);
		dematerialized_worms = _tmp10_;
		dematerialized_worms_length1 = 0;
		_dematerialized_worms_size_ = dematerialized_worms_length1;
		_tmp11_ = g_new0 (Worm*, (NIBBLES_VIEW_WIDTH * NIBBLES_VIEW_HEIGHT) + 1);
		worm_at = _tmp11_;
		worm_at_length1 = NIBBLES_VIEW_WIDTH;
		worm_at_length2 = NIBBLES_VIEW_HEIGHT;
		{
			GeeLinkedList* _worm_list = NULL;
			NibblesView* _tmp12_;
			NibblesGame* _tmp13_;
			GeeLinkedList* _tmp14_;
			GeeLinkedList* _tmp15_;
			gint _worm_size = 0;
			GeeLinkedList* _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			gint _worm_index = 0;
			_tmp12_ = self->priv->view;
			_tmp13_ = _tmp12_->game;
			_tmp14_ = nibbles_game_get_worms (_tmp13_);
			_tmp15_ = _tmp14_;
			_worm_list = _tmp15_;
			_tmp16_ = _worm_list;
			_tmp17_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp16_);
			_tmp18_ = _tmp17_;
			_worm_size = _tmp18_;
			_worm_index = -1;
			while (TRUE) {
				gint _tmp19_;
				gint _tmp20_;
				Worm* worm = NULL;
				GeeLinkedList* _tmp21_;
				gpointer _tmp22_;
				Worm* _tmp23_;
				_worm_index = _worm_index + 1;
				_tmp19_ = _worm_index;
				_tmp20_ = _worm_size;
				if (!(_tmp19_ < _tmp20_)) {
					break;
				}
				_tmp21_ = _worm_list;
				_tmp22_ = gee_abstract_list_get ((GeeAbstractList*) _tmp21_, _worm_index);
				worm = (Worm*) _tmp22_;
				_tmp23_ = worm;
				if (!_tmp23_->is_stopped) {
					Worm* _tmp24_;
					gboolean _tmp25_;
					gboolean _tmp26_;
					_tmp24_ = worm;
					_tmp25_ = worm_get_is_materialized (_tmp24_);
					_tmp26_ = _tmp25_;
					if (_tmp26_) {
						{
							WormPositions* _p_list = NULL;
							Worm* _tmp27_;
							WormPositions* _tmp28_;
							gint _p_size = 0;
							WormPositions* _tmp29_;
							gint _tmp30_;
							gint _tmp31_;
							gint _p_index = 0;
							_tmp27_ = worm;
							_tmp28_ = _tmp27_->list;
							_p_list = _tmp28_;
							_tmp29_ = _p_list;
							_tmp30_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp29_);
							_tmp31_ = _tmp30_;
							_p_size = _tmp31_;
							_p_index = -1;
							while (TRUE) {
								gint _tmp32_;
								gint _tmp33_;
								guint16 p = 0U;
								WormPositions* _tmp34_;
								gpointer _tmp35_;
								Worm** _tmp36_;
								gint _tmp36__length1;
								gint _tmp36__length2;
								Worm* _tmp37_;
								Worm* _tmp38_;
								_p_index = _p_index + 1;
								_tmp32_ = _p_index;
								_tmp33_ = _p_size;
								if (!(_tmp32_ < _tmp33_)) {
									break;
								}
								_tmp34_ = _p_list;
								_tmp35_ = gee_abstract_list_get ((GeeAbstractList*) _tmp34_, _p_index);
								p = (guint16) ((guintptr) _tmp35_);
								_tmp36_ = worm_at;
								_tmp36__length1 = worm_at_length1;
								_tmp36__length2 = worm_at_length2;
								_tmp37_ = worm;
								_tmp38_ = _g_object_ref0 (_tmp37_);
								_g_object_unref0 (_tmp36_[((p >> 8) * _tmp36__length2) + ((guint8) p)]);
								_tmp36_[((p >> 8) * _tmp36__length2) + ((guint8) p)] = _tmp38_;
							}
						}
					} else {
						Worm* _tmp39_;
						Worm* _tmp40_;
						_tmp39_ = worm;
						_tmp40_ = _g_object_ref0 (_tmp39_);
						_vala_array_add5 (&dematerialized_worms, &dematerialized_worms_length1, &_dematerialized_worms_size_, _tmp40_);
					}
				}
				_g_object_unref0 (worm);
			}
		}
		_tmp41_ = dematerialized_worms;
		_tmp41__length1 = dematerialized_worms_length1;
		{
			Worm** worm_collection = NULL;
			gint worm_collection_length1 = 0;
			gint _worm_collection_size_ = 0;
			gint worm_it = 0;
			worm_collection = _tmp41_;
			worm_collection_length1 = _tmp41__length1;
			for (worm_it = 0; worm_it < worm_collection_length1; worm_it = worm_it + 1) {
				Worm* _tmp42_;
				Worm* worm = NULL;
				_tmp42_ = _g_object_ref0 (worm_collection[worm_it]);
				worm = _tmp42_;
				{
					{
						WormPositions* _p_list = NULL;
						Worm* _tmp43_;
						WormPositions* _tmp44_;
						gint _p_size = 0;
						WormPositions* _tmp45_;
						gint _tmp46_;
						gint _tmp47_;
						gint _p_index = 0;
						_tmp43_ = worm;
						_tmp44_ = _tmp43_->list;
						_p_list = _tmp44_;
						_tmp45_ = _p_list;
						_tmp46_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp45_);
						_tmp47_ = _tmp46_;
						_p_size = _tmp47_;
						_p_index = -1;
						while (TRUE) {
							gint _tmp48_;
							gint _tmp49_;
							guint16 p = 0U;
							WormPositions* _tmp50_;
							gpointer _tmp51_;
							Worm** _tmp52_;
							gint _tmp52__length1;
							gint _tmp52__length2;
							Worm* _tmp53_;
							_p_index = _p_index + 1;
							_tmp48_ = _p_index;
							_tmp49_ = _p_size;
							if (!(_tmp48_ < _tmp49_)) {
								break;
							}
							_tmp50_ = _p_list;
							_tmp51_ = gee_abstract_list_get ((GeeAbstractList*) _tmp50_, _p_index);
							p = (guint16) ((guintptr) _tmp51_);
							_tmp52_ = worm_at;
							_tmp52__length1 = worm_at_length1;
							_tmp52__length2 = worm_at_length2;
							_tmp53_ = _tmp52_[((p >> 8) * _tmp52__length2) + ((guint8) p)];
							if (_tmp53_ == NULL) {
								Worm** _tmp54_;
								gint _tmp54__length1;
								gint _tmp54__length2;
								Worm* _tmp55_;
								Worm* _tmp56_;
								_tmp54_ = worm_at;
								_tmp54__length1 = worm_at_length1;
								_tmp54__length2 = worm_at_length2;
								_tmp55_ = worm;
								_tmp56_ = _g_object_ref0 (_tmp55_);
								_g_object_unref0 (_tmp54_[((p >> 8) * _tmp54__length2) + ((guint8) p)]);
								_tmp54_[((p >> 8) * _tmp54__length2) + ((guint8) p)] = _tmp56_;
							}
						}
					}
					_g_object_unref0 (worm);
				}
			}
		}
		_tmp57_ = g_new0 (Bonus*, (NIBBLES_VIEW_WIDTH * NIBBLES_VIEW_HEIGHT) + 1);
		bonus_at = _tmp57_;
		bonus_at_length1 = NIBBLES_VIEW_WIDTH;
		bonus_at_length2 = NIBBLES_VIEW_HEIGHT;
		{
			GeeList* _bonus_list = NULL;
			NibblesView* _tmp58_;
			NibblesGame* _tmp59_;
			GeeList* _tmp60_;
			gint _bonus_size = 0;
			GeeList* _tmp61_;
			gint _tmp62_;
			gint _tmp63_;
			gint _bonus_index = 0;
			_tmp58_ = self->priv->view;
			_tmp59_ = _tmp58_->game;
			_tmp60_ = nibbles_game_get_bonuses (_tmp59_);
			_bonus_list = _tmp60_;
			_tmp61_ = _bonus_list;
			_tmp62_ = gee_collection_get_size ((GeeCollection*) _tmp61_);
			_tmp63_ = _tmp62_;
			_bonus_size = _tmp63_;
			_bonus_index = -1;
			while (TRUE) {
				gint _tmp64_;
				gint _tmp65_;
				Bonus* bonus = NULL;
				GeeList* _tmp66_;
				gpointer _tmp67_;
				Bonus** _tmp68_;
				gint _tmp68__length1;
				gint _tmp68__length2;
				Bonus* _tmp69_;
				guint8 _tmp70_;
				guint8 _tmp71_;
				Bonus* _tmp72_;
				guint8 _tmp73_;
				guint8 _tmp74_;
				Bonus* _tmp75_;
				Bonus* _tmp76_;
				_bonus_index = _bonus_index + 1;
				_tmp64_ = _bonus_index;
				_tmp65_ = _bonus_size;
				if (!(_tmp64_ < _tmp65_)) {
					break;
				}
				_tmp66_ = _bonus_list;
				_tmp67_ = gee_list_get (_tmp66_, _bonus_index);
				bonus = (Bonus*) _tmp67_;
				_tmp68_ = bonus_at;
				_tmp68__length1 = bonus_at_length1;
				_tmp68__length2 = bonus_at_length2;
				_tmp69_ = bonus;
				_tmp70_ = bonus_get_x (_tmp69_);
				_tmp71_ = _tmp70_;
				_tmp72_ = bonus;
				_tmp73_ = bonus_get_y (_tmp72_);
				_tmp74_ = _tmp73_;
				_tmp75_ = bonus;
				_tmp76_ = _g_object_ref0 (_tmp75_);
				_g_object_unref0 (_tmp68_[(_tmp71_ * _tmp68__length2) + _tmp74_]);
				_tmp68_[(_tmp71_ * _tmp68__length2) + _tmp74_] = _tmp76_;
				_g_object_unref0 (bonus);
			}
			_g_object_unref0 (_bonus_list);
		}
		{
			gint y = 0;
			y = 0;
			{
				gboolean _tmp77_ = FALSE;
				_tmp77_ = TRUE;
				while (TRUE) {
					if (!_tmp77_) {
						gint _tmp78_;
						_tmp78_ = y;
						y = _tmp78_ + 1;
					}
					_tmp77_ = FALSE;
					if (!(y < ((gint) NIBBLES_VIEW_HEIGHT))) {
						break;
					}
					{
						gint x = 0;
						x = 0;
						{
							gboolean _tmp79_ = FALSE;
							_tmp79_ = TRUE;
							while (TRUE) {
								Worm** _tmp81_;
								gint _tmp81__length1;
								gint _tmp81__length2;
								Worm* _tmp82_;
								gboolean _tmp132_ = FALSE;
								NibblesView* _tmp133_;
								NibblesGame* _tmp134_;
								gint* _tmp135_;
								gint _tmp135__length1;
								gint _tmp135__length2;
								gint _tmp136_;
								gboolean _tmp262_ = FALSE;
								gboolean _tmp263_ = FALSE;
								gboolean _tmp264_ = FALSE;
								NibblesView* _tmp265_;
								NibblesGame* _tmp266_;
								gint* _tmp267_;
								gint _tmp267__length1;
								gint _tmp267__length2;
								gint _tmp268_;
								Bonus** _tmp308_;
								gint _tmp308__length1;
								gint _tmp308__length2;
								Bonus* _tmp309_;
								if (!_tmp79_) {
									gint _tmp80_ = 0;
									if (x < (NIBBLES_VIEW_WIDTH / 2)) {
										_tmp80_ = (NIBBLES_VIEW_WIDTH - 1) - x;
									} else {
										_tmp80_ = NIBBLES_VIEW_WIDTH - x;
									}
									x = _tmp80_;
								}
								_tmp79_ = FALSE;
								_tmp81_ = worm_at;
								_tmp81__length1 = worm_at_length1;
								_tmp81__length2 = worm_at_length2;
								_tmp82_ = _tmp81_[(x * _tmp81__length2) + y];
								if (_tmp82_ != NULL) {
									NibblesView* _tmp83_;
									NibblesGame* _tmp84_;
									GeeHashMap* _tmp85_;
									GeeHashMap* _tmp86_;
									Worm** _tmp87_;
									gint _tmp87__length1;
									gint _tmp87__length2;
									Worm* _tmp88_;
									gpointer _tmp89_;
									WormProperties* _tmp90_;
									gint _tmp91_;
									gint _tmp92_;
									gdouble _tmp93_ = 0.0;
									gdouble _tmp94_ = 0.0;
									gdouble _tmp95_ = 0.0;
									Worm** _tmp96_;
									gint _tmp96__length1;
									gint _tmp96__length2;
									Worm* _tmp97_;
									gdouble _tmp98_ = 0.0;
									Worm** _tmp99_;
									gint _tmp99__length1;
									gint _tmp99__length2;
									Worm* _tmp100_;
									NibblesView* _tmp101_;
									NibblesViewView3D* _tmp102_;
									Position head = {0};
									Worm** _tmp103_;
									gint _tmp103__length1;
									gint _tmp103__length2;
									Worm* _tmp104_;
									Position _tmp105_ = {0};
									Position _tmp106_;
									gboolean _tmp107_ = FALSE;
									Position _tmp108_;
									_tmp83_ = self->priv->view;
									_tmp84_ = _tmp83_->game;
									_tmp85_ = nibbles_game_get_worm_props (_tmp84_);
									_tmp86_ = _tmp85_;
									_tmp87_ = worm_at;
									_tmp87__length1 = worm_at_length1;
									_tmp87__length2 = worm_at_length2;
									_tmp88_ = _tmp87_[(x * _tmp87__length2) + y];
									_tmp89_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp86_, _tmp88_);
									_tmp90_ = (WormProperties*) _tmp89_;
									_tmp91_ = worm_properties_get_color (_tmp90_);
									_tmp92_ = _tmp91_;
									get_worm_rgb (_tmp92_, TRUE, &_tmp93_, &_tmp94_, &_tmp95_);
									r = _tmp93_;
									g = _tmp94_;
									b = _tmp95_;
									_g_object_unref0 (_tmp90_);
									_tmp96_ = worm_at;
									_tmp96__length1 = worm_at_length1;
									_tmp96__length2 = worm_at_length2;
									_tmp97_ = _tmp96_[(x * _tmp96__length2) + y];
									worm_was_bonus_eaten_at_this_position (_tmp97_, (guint16) ((x << 8) | y));
									_tmp99_ = worm_at;
									_tmp99__length1 = worm_at_length1;
									_tmp99__length2 = worm_at_length2;
									_tmp100_ = _tmp99_[(x * _tmp99__length2) + y];
									if (worm_was_bonus_eaten_at_this_position (_tmp100_, (guint16) ((x << 8) | y))) {
										_tmp98_ = 1.25;
									} else {
										_tmp98_ = (gdouble) 1;
									}
									_tmp101_ = self->priv->view;
									_tmp102_ = v;
									nibbles_view_draw_sphere (_tmp101_, s, _tmp102_, x, y, r, g, b, _tmp98_);
									_tmp103_ = worm_at;
									_tmp103__length1 = worm_at_length1;
									_tmp103__length2 = worm_at_length2;
									_tmp104_ = _tmp103_[(x * _tmp103__length2) + y];
									worm_get_head (_tmp104_, &_tmp105_);
									_tmp106_ = _tmp105_;
									head = _tmp106_;
									_tmp108_ = head;
									if (((gint) _tmp108_.x) == x) {
										Position _tmp109_;
										_tmp109_ = head;
										_tmp107_ = ((gint) _tmp109_.y) == y;
									} else {
										_tmp107_ = FALSE;
									}
									if (_tmp107_) {
										Worm** _tmp110_;
										gint _tmp110__length1;
										gint _tmp110__length2;
										Worm* _tmp111_;
										WormDirection _tmp112_;
										WormDirection _tmp113_;
										_tmp110_ = worm_at;
										_tmp110__length1 = worm_at_length1;
										_tmp110__length2 = worm_at_length2;
										_tmp111_ = _tmp110_[(x * _tmp110__length2) + y];
										_tmp112_ = worm_get_direction (_tmp111_);
										_tmp113_ = _tmp112_;
										switch (_tmp113_) {
											case WORM_DIRECTION_SOUTH:
											{
												NibblesView* _tmp114_;
												NibblesViewView3D* _tmp115_;
												Worm** _tmp116_;
												gint _tmp116__length1;
												gint _tmp116__length2;
												Worm* _tmp117_;
												gint _tmp118_;
												gint _tmp119_;
												_tmp114_ = self->priv->view;
												_tmp115_ = v;
												_tmp116_ = worm_at;
												_tmp116__length1 = worm_at_length1;
												_tmp116__length2 = worm_at_length2;
												_tmp117_ = _tmp116_[(x * _tmp116__length2) + y];
												_tmp118_ = worm_get_id (_tmp117_);
												_tmp119_ = _tmp118_;
												nibbles_view_draw_eyes_front (_tmp114_, s, _tmp115_, x, y, ((self->priv->animate % 30) / 5) == ((guint64) _tmp119_));
												break;
											}
											case WORM_DIRECTION_EAST:
											{
												NibblesView* _tmp120_;
												NibblesViewView3D* _tmp121_;
												Worm** _tmp122_;
												gint _tmp122__length1;
												gint _tmp122__length2;
												Worm* _tmp123_;
												gint _tmp124_;
												gint _tmp125_;
												_tmp120_ = self->priv->view;
												_tmp121_ = v;
												_tmp122_ = worm_at;
												_tmp122__length1 = worm_at_length1;
												_tmp122__length2 = worm_at_length2;
												_tmp123_ = _tmp122_[(x * _tmp122__length2) + y];
												_tmp124_ = worm_get_id (_tmp123_);
												_tmp125_ = _tmp124_;
												nibbles_view_draw_eyes_right (_tmp120_, s, _tmp121_, x, y, ((self->priv->animate % 30) / 5) == ((guint64) _tmp125_));
												break;
											}
											case WORM_DIRECTION_WEST:
											{
												NibblesView* _tmp126_;
												NibblesViewView3D* _tmp127_;
												Worm** _tmp128_;
												gint _tmp128__length1;
												gint _tmp128__length2;
												Worm* _tmp129_;
												gint _tmp130_;
												gint _tmp131_;
												_tmp126_ = self->priv->view;
												_tmp127_ = v;
												_tmp128_ = worm_at;
												_tmp128__length1 = worm_at_length1;
												_tmp128__length2 = worm_at_length2;
												_tmp129_ = _tmp128_[(x * _tmp128__length2) + y];
												_tmp130_ = worm_get_id (_tmp129_);
												_tmp131_ = _tmp130_;
												nibbles_view_draw_eyes_left (_tmp126_, s, _tmp127_, x, y, ((self->priv->animate % 30) / 5) == ((guint64) _tmp131_));
												break;
											}
											default:
											{
												break;
											}
										}
									}
								}
								_tmp133_ = self->priv->view;
								_tmp134_ = _tmp133_->game;
								_tmp135_ = _tmp134_->board;
								_tmp135__length1 = _tmp134_->board_length1;
								_tmp135__length2 = _tmp134_->board_length2;
								_tmp136_ = _tmp135_[(x * _tmp135__length2) + y];
								if (_tmp136_ >= ((gint) 'b')) {
									NibblesView* _tmp137_;
									NibblesGame* _tmp138_;
									gint* _tmp139_;
									gint _tmp139__length1;
									gint _tmp139__length2;
									gint _tmp140_;
									_tmp137_ = self->priv->view;
									_tmp138_ = _tmp137_->game;
									_tmp139_ = _tmp138_->board;
									_tmp139__length1 = _tmp138_->board_length1;
									_tmp139__length2 = _tmp138_->board_length2;
									_tmp140_ = _tmp139_[(x * _tmp139__length2) + y];
									_tmp132_ = _tmp140_ <= ((gint) 'l');
								} else {
									_tmp132_ = FALSE;
								}
								if (_tmp132_) {
									GskPathBuilder* wall_top_path = NULL;
									GskPathBuilder* _tmp141_;
									NibblesViewView3D* _tmp142_;
									NibblesViewPoint3D _tmp143_ = {0};
									gdouble _tmp144_ = 0.0;
									gdouble _tmp145_ = 0.0;
									GskPathBuilder* _tmp146_;
									NibblesViewView3D* _tmp147_;
									NibblesViewPoint3D _tmp148_ = {0};
									gdouble _tmp149_ = 0.0;
									gdouble _tmp150_ = 0.0;
									GskPathBuilder* _tmp151_;
									NibblesViewView3D* _tmp152_;
									NibblesViewPoint3D _tmp153_ = {0};
									gdouble _tmp154_ = 0.0;
									gdouble _tmp155_ = 0.0;
									GskPathBuilder* _tmp156_;
									NibblesViewView3D* _tmp157_;
									NibblesViewPoint3D _tmp158_ = {0};
									gdouble _tmp159_ = 0.0;
									gdouble _tmp160_ = 0.0;
									GskPathBuilder* _tmp161_;
									GskPathBuilder* _tmp162_;
									GskPath* _tmp163_;
									GskPath* _tmp164_;
									GdkRGBA _tmp165_ = {0};
									GskPathBuilder* wall_inside_path = NULL;
									GskPathBuilder* _tmp166_;
									gboolean _tmp167_ = FALSE;
									NibblesViewView3D* _tmp168_;
									GskPathBuilder* wall_front_path = NULL;
									GskPathBuilder* _tmp237_;
									NibblesViewView3D* _tmp238_;
									NibblesViewPoint3D _tmp239_ = {0};
									gdouble _tmp240_ = 0.0;
									gdouble _tmp241_ = 0.0;
									GskPathBuilder* _tmp242_;
									NibblesViewView3D* _tmp243_;
									NibblesViewPoint3D _tmp244_ = {0};
									gdouble _tmp245_ = 0.0;
									gdouble _tmp246_ = 0.0;
									GskPathBuilder* _tmp247_;
									NibblesViewView3D* _tmp248_;
									NibblesViewPoint3D _tmp249_ = {0};
									gdouble _tmp250_ = 0.0;
									gdouble _tmp251_ = 0.0;
									GskPathBuilder* _tmp252_;
									NibblesViewView3D* _tmp253_;
									NibblesViewPoint3D _tmp254_ = {0};
									gdouble _tmp255_ = 0.0;
									gdouble _tmp256_ = 0.0;
									GskPathBuilder* _tmp257_;
									GskPathBuilder* _tmp258_;
									GskPath* _tmp259_;
									GskPath* _tmp260_;
									GdkRGBA _tmp261_ = {0};
									_tmp141_ = gsk_path_builder_new ();
									wall_top_path = _tmp141_;
									_tmp142_ = v;
									_tmp143_.x = (gdouble) x;
									_tmp143_.y = (gdouble) y;
									_tmp143_.z = (gdouble) 1;
									nibbles_view_view3_d_to_view_plain (_tmp142_, &_tmp143_, &_tmp144_, &_tmp145_);
									x2d = _tmp144_;
									y2d = _tmp145_;
									_tmp146_ = wall_top_path;
									gsk_path_builder_move_to (_tmp146_, (gfloat) x2d, (gfloat) y2d);
									_tmp147_ = v;
									_tmp148_.x = (gdouble) (x + 1);
									_tmp148_.y = (gdouble) y;
									_tmp148_.z = (gdouble) 1;
									nibbles_view_view3_d_to_view_plain (_tmp147_, &_tmp148_, &_tmp149_, &_tmp150_);
									x2d = _tmp149_;
									y2d = _tmp150_;
									_tmp151_ = wall_top_path;
									gsk_path_builder_line_to (_tmp151_, (gfloat) x2d, (gfloat) y2d);
									_tmp152_ = v;
									_tmp153_.x = (gdouble) (x + 1);
									_tmp153_.y = (gdouble) (y + 1);
									_tmp153_.z = (gdouble) 1;
									nibbles_view_view3_d_to_view_plain (_tmp152_, &_tmp153_, &_tmp154_, &_tmp155_);
									x2d = _tmp154_;
									y2d = _tmp155_;
									_tmp156_ = wall_top_path;
									gsk_path_builder_line_to (_tmp156_, (gfloat) x2d, (gfloat) y2d);
									_tmp157_ = v;
									_tmp158_.x = (gdouble) x;
									_tmp158_.y = (gdouble) (y + 1);
									_tmp158_.z = (gdouble) 1;
									nibbles_view_view3_d_to_view_plain (_tmp157_, &_tmp158_, &_tmp159_, &_tmp160_);
									x2d = _tmp159_;
									y2d = _tmp160_;
									_tmp161_ = wall_top_path;
									gsk_path_builder_line_to (_tmp161_, (gfloat) x2d, (gfloat) y2d);
									_tmp162_ = wall_top_path;
									_tmp163_ = gsk_path_builder_to_path (_tmp162_);
									_tmp164_ = _tmp163_;
									_tmp165_.red = 0.95f;
									_tmp165_.green = 0.95f;
									_tmp165_.blue = 0.95f;
									_tmp165_.alpha = 1.0f;
									gtk_snapshot_append_fill (s, _tmp164_, GSK_FILL_RULE_EVEN_ODD, &_tmp165_);
									_gsk_path_unref0 (_tmp164_);
									_tmp166_ = gsk_path_builder_new ();
									wall_inside_path = _tmp166_;
									_tmp168_ = v;
									if (((gdouble) x) < nibbles_view_view3_d_view_point_x (_tmp168_)) {
										gboolean _tmp169_ = FALSE;
										NibblesView* _tmp170_;
										NibblesGame* _tmp171_;
										gint* _tmp172_;
										gint _tmp172__length1;
										gint _tmp172__length2;
										gint _tmp173_;
										_tmp170_ = self->priv->view;
										_tmp171_ = _tmp170_->game;
										_tmp172_ = _tmp171_->board;
										_tmp172__length1 = _tmp171_->board_length1;
										_tmp172__length2 = _tmp171_->board_length2;
										_tmp173_ = _tmp172_[((x + 1) * _tmp172__length2) + y];
										if (_tmp173_ >= ((gint) 'b')) {
											NibblesView* _tmp174_;
											NibblesGame* _tmp175_;
											gint* _tmp176_;
											gint _tmp176__length1;
											gint _tmp176__length2;
											gint _tmp177_;
											_tmp174_ = self->priv->view;
											_tmp175_ = _tmp174_->game;
											_tmp176_ = _tmp175_->board;
											_tmp176__length1 = _tmp175_->board_length1;
											_tmp176__length2 = _tmp175_->board_length2;
											_tmp177_ = _tmp176_[((x + 1) * _tmp176__length2) + y];
											_tmp169_ = _tmp177_ <= ((gint) 'l');
										} else {
											_tmp169_ = FALSE;
										}
										_tmp167_ = !_tmp169_;
									} else {
										_tmp167_ = FALSE;
									}
									if (_tmp167_) {
										NibblesViewView3D* _tmp178_;
										NibblesViewPoint3D _tmp179_ = {0};
										gdouble _tmp180_ = 0.0;
										gdouble _tmp181_ = 0.0;
										GskPathBuilder* _tmp182_;
										NibblesViewView3D* _tmp183_;
										NibblesViewPoint3D _tmp184_ = {0};
										gdouble _tmp185_ = 0.0;
										gdouble _tmp186_ = 0.0;
										GskPathBuilder* _tmp187_;
										NibblesViewView3D* _tmp188_;
										NibblesViewPoint3D _tmp189_ = {0};
										gdouble _tmp190_ = 0.0;
										gdouble _tmp191_ = 0.0;
										GskPathBuilder* _tmp192_;
										NibblesViewView3D* _tmp193_;
										NibblesViewPoint3D _tmp194_ = {0};
										gdouble _tmp195_ = 0.0;
										gdouble _tmp196_ = 0.0;
										GskPathBuilder* _tmp197_;
										GskPathBuilder* _tmp198_;
										GskPath* _tmp199_;
										GskPath* _tmp200_;
										GdkRGBA _tmp201_ = {0};
										_tmp178_ = v;
										_tmp179_.x = (gdouble) (x + 1);
										_tmp179_.y = (gdouble) y;
										_tmp179_.z = (gdouble) 0;
										nibbles_view_view3_d_to_view_plain (_tmp178_, &_tmp179_, &_tmp180_, &_tmp181_);
										x2d = _tmp180_;
										y2d = _tmp181_;
										_tmp182_ = wall_inside_path;
										gsk_path_builder_move_to (_tmp182_, (gfloat) x2d, (gfloat) y2d);
										_tmp183_ = v;
										_tmp184_.x = (gdouble) (x + 1);
										_tmp184_.y = (gdouble) (y + 1);
										_tmp184_.z = (gdouble) 0;
										nibbles_view_view3_d_to_view_plain (_tmp183_, &_tmp184_, &_tmp185_, &_tmp186_);
										x2d = _tmp185_;
										y2d = _tmp186_;
										_tmp187_ = wall_inside_path;
										gsk_path_builder_line_to (_tmp187_, (gfloat) x2d, (gfloat) y2d);
										_tmp188_ = v;
										_tmp189_.x = (gdouble) (x + 1);
										_tmp189_.y = (gdouble) (y + 1);
										_tmp189_.z = (gdouble) 1;
										nibbles_view_view3_d_to_view_plain (_tmp188_, &_tmp189_, &_tmp190_, &_tmp191_);
										x2d = _tmp190_;
										y2d = _tmp191_;
										_tmp192_ = wall_inside_path;
										gsk_path_builder_line_to (_tmp192_, (gfloat) x2d, (gfloat) y2d);
										_tmp193_ = v;
										_tmp194_.x = (gdouble) (x + 1);
										_tmp194_.y = (gdouble) y;
										_tmp194_.z = (gdouble) 1;
										nibbles_view_view3_d_to_view_plain (_tmp193_, &_tmp194_, &_tmp195_, &_tmp196_);
										x2d = _tmp195_;
										y2d = _tmp196_;
										_tmp197_ = wall_inside_path;
										gsk_path_builder_line_to (_tmp197_, (gfloat) x2d, (gfloat) y2d);
										_tmp198_ = wall_inside_path;
										_tmp199_ = gsk_path_builder_to_path (_tmp198_);
										_tmp200_ = _tmp199_;
										_tmp201_.red = 0.5f;
										_tmp201_.green = 0.5f;
										_tmp201_.blue = 0.5f;
										_tmp201_.alpha = 1.0f;
										gtk_snapshot_append_fill (s, _tmp200_, GSK_FILL_RULE_EVEN_ODD, &_tmp201_);
										_gsk_path_unref0 (_tmp200_);
									} else {
										gboolean _tmp202_ = FALSE;
										NibblesViewView3D* _tmp203_;
										_tmp203_ = v;
										if (((gdouble) x) > nibbles_view_view3_d_view_point_x (_tmp203_)) {
											gboolean _tmp204_ = FALSE;
											NibblesView* _tmp205_;
											NibblesGame* _tmp206_;
											gint* _tmp207_;
											gint _tmp207__length1;
											gint _tmp207__length2;
											gint _tmp208_;
											_tmp205_ = self->priv->view;
											_tmp206_ = _tmp205_->game;
											_tmp207_ = _tmp206_->board;
											_tmp207__length1 = _tmp206_->board_length1;
											_tmp207__length2 = _tmp206_->board_length2;
											_tmp208_ = _tmp207_[((x - 1) * _tmp207__length2) + y];
											if (_tmp208_ >= ((gint) 'b')) {
												NibblesView* _tmp209_;
												NibblesGame* _tmp210_;
												gint* _tmp211_;
												gint _tmp211__length1;
												gint _tmp211__length2;
												gint _tmp212_;
												_tmp209_ = self->priv->view;
												_tmp210_ = _tmp209_->game;
												_tmp211_ = _tmp210_->board;
												_tmp211__length1 = _tmp210_->board_length1;
												_tmp211__length2 = _tmp210_->board_length2;
												_tmp212_ = _tmp211_[((x - 1) * _tmp211__length2) + y];
												_tmp204_ = _tmp212_ <= ((gint) 'l');
											} else {
												_tmp204_ = FALSE;
											}
											_tmp202_ = !_tmp204_;
										} else {
											_tmp202_ = FALSE;
										}
										if (_tmp202_) {
											NibblesViewView3D* _tmp213_;
											NibblesViewPoint3D _tmp214_ = {0};
											gdouble _tmp215_ = 0.0;
											gdouble _tmp216_ = 0.0;
											GskPathBuilder* _tmp217_;
											NibblesViewView3D* _tmp218_;
											NibblesViewPoint3D _tmp219_ = {0};
											gdouble _tmp220_ = 0.0;
											gdouble _tmp221_ = 0.0;
											GskPathBuilder* _tmp222_;
											NibblesViewView3D* _tmp223_;
											NibblesViewPoint3D _tmp224_ = {0};
											gdouble _tmp225_ = 0.0;
											gdouble _tmp226_ = 0.0;
											GskPathBuilder* _tmp227_;
											NibblesViewView3D* _tmp228_;
											NibblesViewPoint3D _tmp229_ = {0};
											gdouble _tmp230_ = 0.0;
											gdouble _tmp231_ = 0.0;
											GskPathBuilder* _tmp232_;
											GskPathBuilder* _tmp233_;
											GskPath* _tmp234_;
											GskPath* _tmp235_;
											GdkRGBA _tmp236_ = {0};
											_tmp213_ = v;
											_tmp214_.x = (gdouble) x;
											_tmp214_.y = (gdouble) y;
											_tmp214_.z = (gdouble) 0;
											nibbles_view_view3_d_to_view_plain (_tmp213_, &_tmp214_, &_tmp215_, &_tmp216_);
											x2d = _tmp215_;
											y2d = _tmp216_;
											_tmp217_ = wall_inside_path;
											gsk_path_builder_move_to (_tmp217_, (gfloat) x2d, (gfloat) y2d);
											_tmp218_ = v;
											_tmp219_.x = (gdouble) x;
											_tmp219_.y = (gdouble) (y + 1);
											_tmp219_.z = (gdouble) 0;
											nibbles_view_view3_d_to_view_plain (_tmp218_, &_tmp219_, &_tmp220_, &_tmp221_);
											x2d = _tmp220_;
											y2d = _tmp221_;
											_tmp222_ = wall_inside_path;
											gsk_path_builder_line_to (_tmp222_, (gfloat) x2d, (gfloat) y2d);
											_tmp223_ = v;
											_tmp224_.x = (gdouble) x;
											_tmp224_.y = (gdouble) (y + 1);
											_tmp224_.z = (gdouble) 1;
											nibbles_view_view3_d_to_view_plain (_tmp223_, &_tmp224_, &_tmp225_, &_tmp226_);
											x2d = _tmp225_;
											y2d = _tmp226_;
											_tmp227_ = wall_inside_path;
											gsk_path_builder_line_to (_tmp227_, (gfloat) x2d, (gfloat) y2d);
											_tmp228_ = v;
											_tmp229_.x = (gdouble) x;
											_tmp229_.y = (gdouble) y;
											_tmp229_.z = (gdouble) 1;
											nibbles_view_view3_d_to_view_plain (_tmp228_, &_tmp229_, &_tmp230_, &_tmp231_);
											x2d = _tmp230_;
											y2d = _tmp231_;
											_tmp232_ = wall_inside_path;
											gsk_path_builder_line_to (_tmp232_, (gfloat) x2d, (gfloat) y2d);
											_tmp233_ = wall_inside_path;
											_tmp234_ = gsk_path_builder_to_path (_tmp233_);
											_tmp235_ = _tmp234_;
											_tmp236_.red = 0.5f;
											_tmp236_.green = 0.5f;
											_tmp236_.blue = 0.5f;
											_tmp236_.alpha = 1.0f;
											gtk_snapshot_append_fill (s, _tmp235_, GSK_FILL_RULE_EVEN_ODD, &_tmp236_);
											_gsk_path_unref0 (_tmp235_);
										} else {
										}
									}
									_tmp237_ = gsk_path_builder_new ();
									wall_front_path = _tmp237_;
									_tmp238_ = v;
									_tmp239_.x = (gdouble) x;
									_tmp239_.y = (gdouble) (y + 1);
									_tmp239_.z = (gdouble) 0;
									nibbles_view_view3_d_to_view_plain (_tmp238_, &_tmp239_, &_tmp240_, &_tmp241_);
									x2d = _tmp240_;
									y2d = _tmp241_;
									_tmp242_ = wall_front_path;
									gsk_path_builder_move_to (_tmp242_, (gfloat) x2d, (gfloat) y2d);
									_tmp243_ = v;
									_tmp244_.x = (gdouble) (x + 1);
									_tmp244_.y = (gdouble) (y + 1);
									_tmp244_.z = (gdouble) 0;
									nibbles_view_view3_d_to_view_plain (_tmp243_, &_tmp244_, &_tmp245_, &_tmp246_);
									x2d = _tmp245_;
									y2d = _tmp246_;
									_tmp247_ = wall_front_path;
									gsk_path_builder_line_to (_tmp247_, (gfloat) x2d, (gfloat) y2d);
									_tmp248_ = v;
									_tmp249_.x = (gdouble) (x + 1);
									_tmp249_.y = (gdouble) (y + 1);
									_tmp249_.z = (gdouble) 1;
									nibbles_view_view3_d_to_view_plain (_tmp248_, &_tmp249_, &_tmp250_, &_tmp251_);
									x2d = _tmp250_;
									y2d = _tmp251_;
									_tmp252_ = wall_front_path;
									gsk_path_builder_line_to (_tmp252_, (gfloat) x2d, (gfloat) y2d);
									_tmp253_ = v;
									_tmp254_.x = (gdouble) x;
									_tmp254_.y = (gdouble) (y + 1);
									_tmp254_.z = (gdouble) 1;
									nibbles_view_view3_d_to_view_plain (_tmp253_, &_tmp254_, &_tmp255_, &_tmp256_);
									x2d = _tmp255_;
									y2d = _tmp256_;
									_tmp257_ = wall_front_path;
									gsk_path_builder_line_to (_tmp257_, (gfloat) x2d, (gfloat) y2d);
									_tmp258_ = wall_front_path;
									_tmp259_ = gsk_path_builder_to_path (_tmp258_);
									_tmp260_ = _tmp259_;
									_tmp261_.red = 0.95f;
									_tmp261_.green = 0.95f;
									_tmp261_.blue = 0.95f;
									_tmp261_.alpha = 1.0f;
									gtk_snapshot_append_fill (s, _tmp260_, GSK_FILL_RULE_EVEN_ODD, &_tmp261_);
									_gsk_path_unref0 (_tmp260_);
									_gsk_path_builder_unref0 (wall_front_path);
									_gsk_path_builder_unref0 (wall_inside_path);
									_gsk_path_builder_unref0 (wall_top_path);
								}
								_tmp265_ = self->priv->view;
								_tmp266_ = _tmp265_->game;
								_tmp267_ = _tmp266_->board;
								_tmp267__length1 = _tmp266_->board_length1;
								_tmp267__length2 = _tmp266_->board_length2;
								_tmp268_ = _tmp267_[((x + 0) * _tmp267__length2) + (y + 0)];
								if (_tmp268_ == ((gint) NIBBLES_GAME_WARPCHAR)) {
									NibblesView* _tmp269_;
									NibblesGame* _tmp270_;
									gint* _tmp271_;
									gint _tmp271__length1;
									gint _tmp271__length2;
									gint _tmp272_;
									_tmp269_ = self->priv->view;
									_tmp270_ = _tmp269_->game;
									_tmp271_ = _tmp270_->board;
									_tmp271__length1 = _tmp270_->board_length1;
									_tmp271__length2 = _tmp270_->board_length2;
									_tmp272_ = _tmp271_[((x + 1) * _tmp271__length2) + (y + 0)];
									_tmp264_ = _tmp272_ == ((gint) NIBBLES_GAME_WARPCHAR);
								} else {
									_tmp264_ = FALSE;
								}
								if (_tmp264_) {
									NibblesView* _tmp273_;
									NibblesGame* _tmp274_;
									gint* _tmp275_;
									gint _tmp275__length1;
									gint _tmp275__length2;
									gint _tmp276_;
									_tmp273_ = self->priv->view;
									_tmp274_ = _tmp273_->game;
									_tmp275_ = _tmp274_->board;
									_tmp275__length1 = _tmp274_->board_length1;
									_tmp275__length2 = _tmp274_->board_length2;
									_tmp276_ = _tmp275_[((x + 0) * _tmp275__length2) + (y + 1)];
									_tmp263_ = _tmp276_ == ((gint) NIBBLES_GAME_WARPCHAR);
								} else {
									_tmp263_ = FALSE;
								}
								if (_tmp263_) {
									NibblesView* _tmp277_;
									NibblesGame* _tmp278_;
									gint* _tmp279_;
									gint _tmp279__length1;
									gint _tmp279__length2;
									gint _tmp280_;
									_tmp277_ = self->priv->view;
									_tmp278_ = _tmp277_->game;
									_tmp279_ = _tmp278_->board;
									_tmp279__length1 = _tmp278_->board_length1;
									_tmp279__length2 = _tmp278_->board_length2;
									_tmp280_ = _tmp279_[((x + 1) * _tmp279__length2) + (y + 1)];
									_tmp262_ = _tmp280_ == ((gint) NIBBLES_GAME_WARPCHAR);
								} else {
									_tmp262_ = FALSE;
								}
								if (_tmp262_) {
									{
										gint z = 0;
										z = 0;
										{
											gboolean _tmp281_ = FALSE;
											_tmp281_ = TRUE;
											while (TRUE) {
												guint64 a40 = 0ULL;
												guint64 a20 = 0ULL;
												guint64 a20o = 0ULL;
												gdouble a10 = 0.0;
												gdouble _tmp283_ = 0.0;
												gdouble _tmp285_ = 0.0;
												gboolean _tmp286_ = FALSE;
												gdouble _tmp288_ = 0.0;
												gboolean _tmp289_ = FALSE;
												gdouble _tmp291_ = 0.0;
												gboolean _tmp292_ = FALSE;
												gdouble angle[4] = {0};
												gdouble _tmp294_[4] = {0};
												NibblesView* _tmp295_;
												NibblesViewView3D* _tmp296_;
												gdouble _tmp297_;
												NibblesViewPoint3D _tmp298_ = {0};
												gdouble _tmp299_;
												NibblesViewPoint3D _tmp300_ = {0};
												gdouble _tmp301_;
												NibblesViewPoint3D _tmp302_ = {0};
												gdouble _tmp303_;
												NibblesViewPoint3D _tmp304_ = {0};
												GskPath* _tmp305_;
												GskPath* _tmp306_;
												GdkRGBA _tmp307_ = {0};
												if (!_tmp281_) {
													gint _tmp282_;
													_tmp282_ = z;
													z = _tmp282_ + 1;
												}
												_tmp281_ = FALSE;
												if (!(z < 6)) {
													break;
												}
												a40 = self->priv->animate % 40;
												a20 = self->priv->animate % 20;
												a20o = (self->priv->animate + 10) % 20;
												a10 = (gdouble) (self->priv->animate % 10);
												if (a40 < ((guint64) 20)) {
													gdouble _tmp284_ = 0.0;
													if (a20 < ((guint64) 10)) {
														_tmp284_ = a10;
													} else {
														_tmp284_ = 10.0 - a10;
													}
													_tmp283_ = _tmp284_ / 5.0;
												} else {
													_tmp283_ = (gdouble) 0;
												}
												if (a40 >= ((guint64) 10)) {
													_tmp286_ = a40 < ((guint64) 30);
												} else {
													_tmp286_ = FALSE;
												}
												if (_tmp286_) {
													gdouble _tmp287_ = 0.0;
													if (a20o < ((guint64) 10)) {
														_tmp287_ = a10;
													} else {
														_tmp287_ = 10.0 - a10;
													}
													_tmp285_ = _tmp287_ / 5.0;
												} else {
													_tmp285_ = (gdouble) 0;
												}
												if (a40 >= ((guint64) 20)) {
													_tmp289_ = a40 < ((guint64) 40);
												} else {
													_tmp289_ = FALSE;
												}
												if (_tmp289_) {
													gdouble _tmp290_ = 0.0;
													if (a20 < ((guint64) 10)) {
														_tmp290_ = a10;
													} else {
														_tmp290_ = 10.0 - a10;
													}
													_tmp288_ = _tmp290_ / 5.0;
												} else {
													_tmp288_ = (gdouble) 0;
												}
												if (a40 >= ((guint64) 30)) {
													_tmp292_ = TRUE;
												} else {
													_tmp292_ = a40 < ((guint64) 10);
												}
												if (_tmp292_) {
													gdouble _tmp293_ = 0.0;
													if (a20o < ((guint64) 10)) {
														_tmp293_ = a10;
													} else {
														_tmp293_ = 10.0 - a10;
													}
													_tmp291_ = _tmp293_ / 5.0;
												} else {
													_tmp291_ = (gdouble) 0;
												}
												_tmp294_[0] = _tmp283_;
												_tmp294_[1] = _tmp285_;
												_tmp294_[2] = _tmp288_;
												_tmp294_[3] = _tmp291_;
												memcpy (angle, _tmp294_, 4 * sizeof (gdouble));
												_tmp295_ = self->priv->view;
												_tmp296_ = v;
												_tmp297_ = angle[0];
												_tmp298_.x = ((gdouble) x) + (0.1 * z);
												_tmp298_.y = ((gdouble) y) + (0.1 * z);
												_tmp298_.z = _tmp297_;
												_tmp299_ = angle[1];
												_tmp300_.x = (((gdouble) x) + 2) - (0.1 * z);
												_tmp300_.y = ((gdouble) y) + (0.1 * z);
												_tmp300_.z = _tmp299_;
												_tmp301_ = angle[2];
												_tmp302_.x = (((gdouble) x) + 2) - (0.1 * z);
												_tmp302_.y = (((gdouble) y) + 2) - (0.1 * z);
												_tmp302_.z = _tmp301_;
												_tmp303_ = angle[3];
												_tmp304_.x = ((gdouble) x) + (0.1 * z);
												_tmp304_.y = (((gdouble) y) + 2) - (0.1 * z);
												_tmp304_.z = _tmp303_;
												_tmp305_ = nibbles_view_draw_oval (_tmp295_, _tmp296_, &_tmp298_, &_tmp300_, &_tmp302_, &_tmp304_);
												_tmp306_ = _tmp305_;
												_tmp307_.red = 0.0f;
												_tmp307_.green = 0.0f;
												_tmp307_.blue = 0.6f - (0.1f * z);
												_tmp307_.alpha = (gfloat) 1;
												gtk_snapshot_append_fill (s, _tmp306_, GSK_FILL_RULE_EVEN_ODD, &_tmp307_);
												_gsk_path_unref0 (_tmp306_);
											}
										}
									}
								}
								_tmp308_ = bonus_at;
								_tmp308__length1 = bonus_at_length1;
								_tmp308__length2 = bonus_at_length2;
								_tmp309_ = _tmp308_[(x * _tmp308__length2) + y];
								if (_tmp309_ != NULL) {
									NibblesView* _tmp310_;
									NibblesViewView3D* _tmp311_;
									Bonus** _tmp312_;
									gint _tmp312__length1;
									gint _tmp312__length2;
									Bonus* _tmp313_;
									_tmp310_ = self->priv->view;
									_tmp311_ = v;
									_tmp312_ = bonus_at;
									_tmp312__length1 = bonus_at_length1;
									_tmp312__length2 = bonus_at_length2;
									_tmp313_ = _tmp312_[(x * _tmp312__length2) + y];
									nibbles_view_draw_3D_bonus (_tmp310_, s, _tmp311_, x, y, _tmp313_);
								}
								if (x == (NIBBLES_VIEW_WIDTH / 2)) {
									break;
								}
							}
						}
					}
				}
			}
		}
		_tmp314_ = self->priv->view;
		_tmp315_ = _tmp314_->priv->countdown_active;
		_tmp315__target = _tmp314_->priv->countdown_active_target;
		if (_tmp315_ (_tmp315__target) > 0) {
			gchar* text = NULL;
			NibblesView* _tmp316_;
			NibblesView* _tmp317_;
			NibblesViewCountdownActiveFunction _tmp318_;
			gpointer _tmp318__target;
			gchar* _tmp319_;
			gdouble w = 0.0;
			gdouble h = 0.0;
			gint font_size = 0;
			NibblesView* _tmp320_;
			const gchar* _tmp321_;
			gdouble _tmp322_ = 0.0;
			gdouble _tmp323_ = 0.0;
			gdouble center_x = 0.0;
			gdouble center_y = 0.0;
			NibblesViewView3D* _tmp324_;
			NibblesViewPoint3D _tmp325_ = {0};
			gdouble _tmp326_ = 0.0;
			gdouble _tmp327_ = 0.0;
			NibblesView* _tmp328_;
			const gchar* _tmp329_;
			_tmp316_ = self->priv->view;
			_tmp317_ = self->priv->view;
			_tmp318_ = _tmp317_->priv->countdown_active;
			_tmp318__target = _tmp317_->priv->countdown_active_target;
			_tmp319_ = nibbles_view_seconds_string (_tmp316_, _tmp318_ (_tmp318__target));
			text = _tmp319_;
			font_size = 252;
			_tmp320_ = self->priv->view;
			_tmp321_ = text;
			nibbles_view_calculate_text_size (_tmp320_, _tmp321_, font_size, &_tmp322_, &_tmp323_);
			w = _tmp322_;
			h = _tmp323_;
			_tmp324_ = v;
			_tmp325_.x = (gdouble) (NIBBLES_VIEW_WIDTH / 2);
			_tmp325_.y = (gdouble) (NIBBLES_VIEW_HEIGHT / 2);
			_tmp325_.z = (gdouble) 0;
			nibbles_view_view3_d_to_view_plain (_tmp324_, &_tmp325_, &_tmp326_, &_tmp327_);
			center_x = _tmp326_;
			center_y = _tmp327_;
			_tmp328_ = self->priv->view;
			_tmp329_ = text;
			nibbles_view_draw_text_font_size (_tmp328_, s, (gint) (center_x - (w / 2)), (gint) (center_y - (h / 2)), _tmp329_, font_size);
			{
				GeeLinkedList* _worm_list = NULL;
				NibblesView* _tmp330_;
				NibblesGame* _tmp331_;
				GeeLinkedList* _tmp332_;
				GeeLinkedList* _tmp333_;
				gint _worm_size = 0;
				GeeLinkedList* _tmp334_;
				gint _tmp335_;
				gint _tmp336_;
				gint _worm_index = 0;
				_tmp330_ = self->priv->view;
				_tmp331_ = _tmp330_->game;
				_tmp332_ = nibbles_game_get_worms (_tmp331_);
				_tmp333_ = _tmp332_;
				_worm_list = _tmp333_;
				_tmp334_ = _worm_list;
				_tmp335_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp334_);
				_tmp336_ = _tmp335_;
				_worm_size = _tmp336_;
				_worm_index = -1;
				while (TRUE) {
					gint _tmp337_;
					gint _tmp338_;
					Worm* worm = NULL;
					GeeLinkedList* _tmp339_;
					gpointer _tmp340_;
					Worm* _tmp341_;
					WormPositions* _tmp342_;
					gboolean _tmp343_;
					gboolean _tmp344_;
					_worm_index = _worm_index + 1;
					_tmp337_ = _worm_index;
					_tmp338_ = _worm_size;
					if (!(_tmp337_ < _tmp338_)) {
						break;
					}
					_tmp339_ = _worm_list;
					_tmp340_ = gee_abstract_list_get ((GeeAbstractList*) _tmp339_, _worm_index);
					worm = (Worm*) _tmp340_;
					_tmp341_ = worm;
					_tmp342_ = _tmp341_->list;
					_tmp343_ = gee_collection_get_is_empty ((GeeCollection*) _tmp342_);
					_tmp344_ = _tmp343_;
					if (!_tmp344_) {
						gint color = 0;
						NibblesView* _tmp345_;
						NibblesGame* _tmp346_;
						GeeHashMap* _tmp347_;
						GeeHashMap* _tmp348_;
						Worm* _tmp349_;
						gpointer _tmp350_;
						WormProperties* _tmp351_;
						gint _tmp352_;
						gint _tmp353_;
						gint _tmp354_;
						gboolean _tmp355_ = FALSE;
						Worm* _tmp356_;
						WormDirection _tmp357_;
						WormDirection _tmp358_;
						_tmp345_ = self->priv->view;
						_tmp346_ = _tmp345_->game;
						_tmp347_ = nibbles_game_get_worm_props (_tmp346_);
						_tmp348_ = _tmp347_;
						_tmp349_ = worm;
						_tmp350_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp348_, _tmp349_);
						_tmp351_ = (WormProperties*) _tmp350_;
						_tmp352_ = worm_properties_get_color (_tmp351_);
						_tmp353_ = _tmp352_;
						_tmp354_ = _tmp353_;
						_g_object_unref0 (_tmp351_);
						color = _tmp354_;
						_tmp356_ = worm;
						_tmp357_ = worm_get_direction (_tmp356_);
						_tmp358_ = _tmp357_;
						if (_tmp358_ == WORM_DIRECTION_UP) {
							_tmp355_ = TRUE;
						} else {
							Worm* _tmp359_;
							WormDirection _tmp360_;
							WormDirection _tmp361_;
							_tmp359_ = worm;
							_tmp360_ = worm_get_direction (_tmp359_);
							_tmp361_ = _tmp360_;
							_tmp355_ = _tmp361_ == WORM_DIRECTION_DOWN;
						}
						if (_tmp355_) {
							gint middle = 0;
							Worm* _tmp362_;
							gint _tmp363_;
							gint _tmp364_;
							NibblesViewView3D* _tmp365_;
							Worm* _tmp366_;
							WormPositions* _tmp367_;
							gpointer _tmp368_;
							Worm* _tmp369_;
							WormPositions* _tmp370_;
							gpointer _tmp371_;
							NibblesViewPoint3D _tmp372_ = {0};
							gdouble _tmp373_ = 0.0;
							gdouble _tmp374_ = 0.0;
							NibblesView* _tmp375_;
							NibblesView* _tmp376_;
							Worm* _tmp377_;
							gint _tmp378_;
							gint _tmp379_;
							gchar* _tmp380_;
							gchar* _tmp381_;
							NibblesViewView3D* _tmp382_;
							Worm* _tmp383_;
							WormPositions* _tmp384_;
							gpointer _tmp385_;
							Worm* _tmp386_;
							WormPositions* _tmp387_;
							gpointer _tmp388_;
							NibblesViewPoint3D _tmp389_ = {0};
							Worm* _tmp390_;
							WormPositions* _tmp391_;
							Worm* _tmp392_;
							gint _tmp393_;
							gint _tmp394_;
							gpointer _tmp395_;
							Worm* _tmp396_;
							WormPositions* _tmp397_;
							Worm* _tmp398_;
							gint _tmp399_;
							gint _tmp400_;
							gpointer _tmp401_;
							NibblesViewPoint3D _tmp402_ = {0};
							_tmp362_ = worm;
							_tmp363_ = worm_get_length (_tmp362_);
							_tmp364_ = _tmp363_;
							middle = _tmp364_ / 2;
							_tmp365_ = v;
							_tmp366_ = worm;
							_tmp367_ = _tmp366_->list;
							_tmp368_ = gee_abstract_list_get ((GeeAbstractList*) _tmp367_, middle);
							_tmp369_ = worm;
							_tmp370_ = _tmp369_->list;
							_tmp371_ = gee_abstract_list_get ((GeeAbstractList*) _tmp370_, middle);
							_tmp372_.x = (((guint16) ((guintptr) _tmp368_)) >> 8) + 1.5;
							_tmp372_.y = (gdouble) ((guint8) ((guint16) ((guintptr) _tmp371_)));
							_tmp372_.z = (gdouble) 0;
							nibbles_view_view3_d_to_view_plain (_tmp365_, &_tmp372_, &_tmp373_, &_tmp374_);
							x2d = _tmp373_;
							y2d = _tmp374_;
							_tmp375_ = self->priv->view;
							_tmp376_ = self->priv->view;
							_tmp377_ = worm;
							_tmp378_ = worm_get_id (_tmp377_);
							_tmp379_ = _tmp378_;
							_tmp380_ = nibbles_view_worm_name (_tmp376_, _tmp379_ + 1);
							_tmp381_ = _tmp380_;
							_tmp382_ = v;
							_tmp383_ = worm;
							_tmp384_ = _tmp383_->list;
							_tmp385_ = gee_abstract_list_get ((GeeAbstractList*) _tmp384_, 0);
							_tmp386_ = worm;
							_tmp387_ = _tmp386_->list;
							_tmp388_ = gee_abstract_list_get ((GeeAbstractList*) _tmp387_, 0);
							_tmp389_.x = (gdouble) (((guint16) ((guintptr) _tmp385_)) >> 8);
							_tmp389_.y = (gdouble) ((guint8) ((guint16) ((guintptr) _tmp388_)));
							_tmp389_.z = (gdouble) 0;
							_tmp390_ = worm;
							_tmp391_ = _tmp390_->list;
							_tmp392_ = worm;
							_tmp393_ = worm_get_length (_tmp392_);
							_tmp394_ = _tmp393_;
							_tmp395_ = gee_abstract_list_get ((GeeAbstractList*) _tmp391_, _tmp394_ - 1);
							_tmp396_ = worm;
							_tmp397_ = _tmp396_->list;
							_tmp398_ = worm;
							_tmp399_ = worm_get_length (_tmp398_);
							_tmp400_ = _tmp399_;
							_tmp401_ = gee_abstract_list_get ((GeeAbstractList*) _tmp397_, _tmp400_ - 1);
							_tmp402_.x = (gdouble) (((guint16) ((guintptr) _tmp395_)) >> 8);
							_tmp402_.y = (gdouble) (((guint8) ((guint16) ((guintptr) _tmp401_))) + 1);
							_tmp402_.z = (gdouble) 0;
							nibbles_view_draw_text_target_width (_tmp375_, s, (gint) x2d, (gint) y2d, _tmp381_, (gint) nibbles_view_view3_d_2D_diff (_tmp382_, &_tmp389_, &_tmp402_), color);
							_g_free0 (_tmp381_);
						} else {
							gboolean _tmp403_ = FALSE;
							Worm* _tmp404_;
							WormDirection _tmp405_;
							WormDirection _tmp406_;
							_tmp404_ = worm;
							_tmp405_ = worm_get_direction (_tmp404_);
							_tmp406_ = _tmp405_;
							if (_tmp406_ == WORM_DIRECTION_LEFT) {
								_tmp403_ = TRUE;
							} else {
								Worm* _tmp407_;
								WormDirection _tmp408_;
								WormDirection _tmp409_;
								_tmp407_ = worm;
								_tmp408_ = worm_get_direction (_tmp407_);
								_tmp409_ = _tmp408_;
								_tmp403_ = _tmp409_ == WORM_DIRECTION_RIGHT;
							}
							if (_tmp403_) {
								gdouble x_2d[2] = {0};
								gdouble y_2d[2] = {0};
								gint x = 0;
								Worm* _tmp410_;
								WormPositions* _tmp411_;
								gpointer _tmp412_;
								gint x_max = 0;
								Worm* _tmp413_;
								WormPositions* _tmp414_;
								Worm* _tmp415_;
								gint _tmp416_;
								gint _tmp417_;
								gpointer _tmp418_;
								NibblesViewView3D* _tmp419_;
								Worm* _tmp420_;
								WormPositions* _tmp421_;
								gpointer _tmp422_;
								NibblesViewPoint3D _tmp423_ = {0};
								gdouble _tmp424_ = 0.0;
								gdouble _tmp425_ = 0.0;
								NibblesViewView3D* _tmp426_;
								Worm* _tmp427_;
								WormPositions* _tmp428_;
								gpointer _tmp429_;
								NibblesViewPoint3D _tmp430_ = {0};
								gdouble _tmp431_ = 0.0;
								gdouble _tmp432_ = 0.0;
								NibblesView* _tmp433_;
								gdouble _tmp434_;
								gdouble _tmp435_;
								NibblesView* _tmp436_;
								Worm* _tmp437_;
								gint _tmp438_;
								gint _tmp439_;
								gchar* _tmp440_;
								gchar* _tmp441_;
								gdouble _tmp442_;
								gdouble _tmp443_;
								_tmp410_ = worm;
								_tmp411_ = _tmp410_->list;
								_tmp412_ = gee_abstract_list_get ((GeeAbstractList*) _tmp411_, 0);
								x = ((guint16) ((guintptr) _tmp412_)) >> 8;
								_tmp413_ = worm;
								_tmp414_ = _tmp413_->list;
								_tmp415_ = worm;
								_tmp416_ = worm_get_length (_tmp415_);
								_tmp417_ = _tmp416_;
								_tmp418_ = gee_abstract_list_get ((GeeAbstractList*) _tmp414_, _tmp417_ - 1);
								x_max = ((guint16) ((guintptr) _tmp418_)) >> 8;
								if (x > x_max) {
									gint swap = 0;
									swap = x;
									x = x_max;
									x_max = swap;
								}
								_tmp419_ = v;
								_tmp420_ = worm;
								_tmp421_ = _tmp420_->list;
								_tmp422_ = gee_abstract_list_get ((GeeAbstractList*) _tmp421_, 0);
								_tmp423_.x = (gdouble) x;
								_tmp423_.y = (gdouble) ((guint8) ((guint16) ((guintptr) _tmp422_)));
								_tmp423_.z = (gdouble) 3;
								nibbles_view_view3_d_to_view_plain (_tmp419_, &_tmp423_, &_tmp424_, &_tmp425_);
								x_2d[0] = _tmp424_;
								y_2d[0] = _tmp425_;
								_tmp426_ = v;
								_tmp427_ = worm;
								_tmp428_ = _tmp427_->list;
								_tmp429_ = gee_abstract_list_get ((GeeAbstractList*) _tmp428_, 0);
								_tmp430_.x = (gdouble) (x_max + 1);
								_tmp430_.y = (gdouble) ((guint8) ((guint16) ((guintptr) _tmp429_)));
								_tmp430_.z = (gdouble) 3;
								nibbles_view_view3_d_to_view_plain (_tmp426_, &_tmp430_, &_tmp431_, &_tmp432_);
								x_2d[1] = _tmp431_;
								y_2d[1] = _tmp432_;
								_tmp433_ = self->priv->view;
								_tmp434_ = x_2d[0];
								_tmp435_ = y_2d[0];
								_tmp436_ = self->priv->view;
								_tmp437_ = worm;
								_tmp438_ = worm_get_id (_tmp437_);
								_tmp439_ = _tmp438_;
								_tmp440_ = nibbles_view_worm_name (_tmp436_, _tmp439_ + 1);
								_tmp441_ = _tmp440_;
								_tmp442_ = x_2d[1];
								_tmp443_ = x_2d[0];
								nibbles_view_draw_text_target_width (_tmp433_, s, (gint) _tmp434_, (gint) _tmp435_, _tmp441_, (gint) (_tmp442_ - _tmp443_), color);
								_g_free0 (_tmp441_);
							}
						}
					}
					_g_object_unref0 (worm);
				}
			}
			_g_free0 (text);
		}
		bonus_at = (_vala_array_free (bonus_at, bonus_at_length1 * bonus_at_length2, (GDestroyNotify) g_object_unref), NULL);
		worm_at = (_vala_array_free (worm_at, worm_at_length1 * worm_at_length2, (GDestroyNotify) g_object_unref), NULL);
		dematerialized_worms = (_vala_array_free (dematerialized_worms, dematerialized_worms_length1, (GDestroyNotify) g_object_unref), NULL);
		_nibbles_view_view3_d_unref0 (v);
	} else {
		static const gdouble max_delta_deviation = 1.15;
		gint x_delta = 0;
		gint y_delta = 0;
		gint x_offset = 0;
		gint y_offset = 0;
		GeeArrayList* materialized_worm_positions = NULL;
		GeeArrayList* _tmp468_;
		gint* dematerialized_worms = NULL;
		gint* _tmp469_;
		gint dematerialized_worms_length1;
		gint _dematerialized_worms_size_;
		NibblesView* _tmp578_;
		NibblesViewCountdownActiveFunction _tmp579_;
		gpointer _tmp579__target;
		x_delta = gtk_widget_get_width ((GtkWidget*) self) / NIBBLES_VIEW_WIDTH;
		y_delta = gtk_widget_get_height ((GtkWidget*) self) / NIBBLES_VIEW_HEIGHT;
		if (((gdouble) x_delta) > (max_delta_deviation * y_delta)) {
			x_delta = (gint) (y_delta * max_delta_deviation);
		} else {
			if (((gdouble) y_delta) > (max_delta_deviation * x_delta)) {
				y_delta = (gint) (x_delta * max_delta_deviation);
			}
		}
		x_offset = (gtk_widget_get_width ((GtkWidget*) self) - (x_delta * NIBBLES_VIEW_WIDTH)) / 2;
		y_offset = (gtk_widget_get_height ((GtkWidget*) self) - (y_delta * NIBBLES_VIEW_HEIGHT)) / 2;
		{
			gint x = 0;
			x = 0;
			{
				gboolean _tmp444_ = FALSE;
				_tmp444_ = TRUE;
				while (TRUE) {
					if (!_tmp444_) {
						gint _tmp445_;
						_tmp445_ = x;
						x = _tmp445_ + 1;
					}
					_tmp444_ = FALSE;
					if (!(x < ((gint) NIBBLES_VIEW_WIDTH))) {
						break;
					}
					{
						gint y = 0;
						y = 0;
						{
							gboolean _tmp446_ = FALSE;
							_tmp446_ = TRUE;
							while (TRUE) {
								gboolean _tmp448_ = FALSE;
								gboolean _tmp449_ = FALSE;
								gboolean _tmp450_ = FALSE;
								NibblesView* _tmp451_;
								NibblesGame* _tmp452_;
								gint* _tmp453_;
								gint _tmp453__length1;
								gint _tmp453__length2;
								gint _tmp454_;
								if (!_tmp446_) {
									gint _tmp447_;
									_tmp447_ = y;
									y = _tmp447_ + 1;
								}
								_tmp446_ = FALSE;
								if (!(y < ((gint) NIBBLES_VIEW_HEIGHT))) {
									break;
								}
								_tmp451_ = self->priv->view;
								_tmp452_ = _tmp451_->game;
								_tmp453_ = _tmp452_->board;
								_tmp453__length1 = _tmp452_->board_length1;
								_tmp453__length2 = _tmp452_->board_length2;
								_tmp454_ = _tmp453_[((x + 0) * _tmp453__length2) + (y + 0)];
								if (_tmp454_ == ((gint) NIBBLES_GAME_WARPCHAR)) {
									NibblesView* _tmp455_;
									NibblesGame* _tmp456_;
									gint* _tmp457_;
									gint _tmp457__length1;
									gint _tmp457__length2;
									gint _tmp458_;
									_tmp455_ = self->priv->view;
									_tmp456_ = _tmp455_->game;
									_tmp457_ = _tmp456_->board;
									_tmp457__length1 = _tmp456_->board_length1;
									_tmp457__length2 = _tmp456_->board_length2;
									_tmp458_ = _tmp457_[((x + 1) * _tmp457__length2) + (y + 0)];
									_tmp450_ = _tmp458_ == ((gint) NIBBLES_GAME_WARPCHAR);
								} else {
									_tmp450_ = FALSE;
								}
								if (_tmp450_) {
									NibblesView* _tmp459_;
									NibblesGame* _tmp460_;
									gint* _tmp461_;
									gint _tmp461__length1;
									gint _tmp461__length2;
									gint _tmp462_;
									_tmp459_ = self->priv->view;
									_tmp460_ = _tmp459_->game;
									_tmp461_ = _tmp460_->board;
									_tmp461__length1 = _tmp460_->board_length1;
									_tmp461__length2 = _tmp460_->board_length2;
									_tmp462_ = _tmp461_[((x + 0) * _tmp461__length2) + (y + 1)];
									_tmp449_ = _tmp462_ == ((gint) NIBBLES_GAME_WARPCHAR);
								} else {
									_tmp449_ = FALSE;
								}
								if (_tmp449_) {
									NibblesView* _tmp463_;
									NibblesGame* _tmp464_;
									gint* _tmp465_;
									gint _tmp465__length1;
									gint _tmp465__length2;
									gint _tmp466_;
									_tmp463_ = self->priv->view;
									_tmp464_ = _tmp463_->game;
									_tmp465_ = _tmp464_->board;
									_tmp465__length1 = _tmp464_->board_length1;
									_tmp465__length2 = _tmp464_->board_length2;
									_tmp466_ = _tmp465_[((x + 1) * _tmp465__length2) + (y + 1)];
									_tmp448_ = _tmp466_ == ((gint) NIBBLES_GAME_WARPCHAR);
								} else {
									_tmp448_ = FALSE;
								}
								if (_tmp448_) {
									NibblesView* _tmp467_;
									_tmp467_ = self->priv->view;
									nibbles_view_draw_bonus (_tmp467_, s, (x_delta * x) + x_offset, (y_delta * y) + y_offset, x_delta + x_delta, y_delta + y_delta, BONUS_ETYPE_WARP, self->priv->animate);
								}
							}
						}
					}
				}
			}
		}
		_tmp468_ = gee_array_list_new (G_TYPE_UINT, NULL, NULL, NULL, NULL, NULL);
		materialized_worm_positions = _tmp468_;
		_tmp469_ = g_new0 (gint, 0);
		dematerialized_worms = _tmp469_;
		dematerialized_worms_length1 = 0;
		_dematerialized_worms_size_ = dematerialized_worms_length1;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp470_ = FALSE;
				_tmp470_ = TRUE;
				while (TRUE) {
					NibblesView* _tmp472_;
					NibblesGame* _tmp473_;
					GeeLinkedList* _tmp474_;
					GeeLinkedList* _tmp475_;
					gint _tmp476_;
					gint _tmp477_;
					NibblesView* _tmp478_;
					NibblesGame* _tmp479_;
					GeeLinkedList* _tmp480_;
					GeeLinkedList* _tmp481_;
					gpointer _tmp482_;
					Worm* _tmp483_;
					gboolean _tmp484_;
					gboolean _tmp485_;
					gboolean _tmp486_;
					if (!_tmp470_) {
						gint _tmp471_;
						_tmp471_ = i;
						i = _tmp471_ + 1;
					}
					_tmp470_ = FALSE;
					_tmp472_ = self->priv->view;
					_tmp473_ = _tmp472_->game;
					_tmp474_ = nibbles_game_get_worms (_tmp473_);
					_tmp475_ = _tmp474_;
					_tmp476_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp475_);
					_tmp477_ = _tmp476_;
					if (!(i < _tmp477_)) {
						break;
					}
					_tmp478_ = self->priv->view;
					_tmp479_ = _tmp478_->game;
					_tmp480_ = nibbles_game_get_worms (_tmp479_);
					_tmp481_ = _tmp480_;
					_tmp482_ = gee_abstract_list_get ((GeeAbstractList*) _tmp481_, i);
					_tmp483_ = (Worm*) _tmp482_;
					_tmp484_ = worm_get_is_materialized (_tmp483_);
					_tmp485_ = _tmp484_;
					_tmp486_ = _tmp485_;
					_g_object_unref0 (_tmp483_);
					if (_tmp486_) {
						{
							WormPositions* _position_list = NULL;
							NibblesView* _tmp487_;
							NibblesGame* _tmp488_;
							GeeLinkedList* _tmp489_;
							GeeLinkedList* _tmp490_;
							gpointer _tmp491_;
							Worm* _tmp492_;
							WormPositions* _tmp493_;
							WormPositions* _tmp494_;
							gint _position_size = 0;
							WormPositions* _tmp495_;
							gint _tmp496_;
							gint _tmp497_;
							gint _position_index = 0;
							_tmp487_ = self->priv->view;
							_tmp488_ = _tmp487_->game;
							_tmp489_ = nibbles_game_get_worms (_tmp488_);
							_tmp490_ = _tmp489_;
							_tmp491_ = gee_abstract_list_get ((GeeAbstractList*) _tmp490_, i);
							_tmp492_ = (Worm*) _tmp491_;
							_tmp493_ = _tmp492_->list;
							_tmp494_ = _tmp493_;
							_g_object_unref0 (_tmp492_);
							_position_list = _tmp494_;
							_tmp495_ = _position_list;
							_tmp496_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp495_);
							_tmp497_ = _tmp496_;
							_position_size = _tmp497_;
							_position_index = -1;
							while (TRUE) {
								gint _tmp498_;
								gint _tmp499_;
								guint16 position = 0U;
								WormPositions* _tmp500_;
								gpointer _tmp501_;
								guint8 x = 0U;
								guint8 y = 0U;
								NibblesView* _tmp502_;
								NibblesView* _tmp503_;
								NibblesGame* _tmp504_;
								GeeHashMap* _tmp505_;
								GeeHashMap* _tmp506_;
								NibblesView* _tmp507_;
								NibblesGame* _tmp508_;
								GeeLinkedList* _tmp509_;
								GeeLinkedList* _tmp510_;
								gpointer _tmp511_;
								Worm* _tmp512_;
								gpointer _tmp513_;
								WormProperties* _tmp514_;
								gint _tmp515_;
								gint _tmp516_;
								NibblesView* _tmp517_;
								NibblesGame* _tmp518_;
								GeeLinkedList* _tmp519_;
								GeeLinkedList* _tmp520_;
								gpointer _tmp521_;
								Worm* _tmp522_;
								GeeArrayList* _tmp523_;
								_position_index = _position_index + 1;
								_tmp498_ = _position_index;
								_tmp499_ = _position_size;
								if (!(_tmp498_ < _tmp499_)) {
									break;
								}
								_tmp500_ = _position_list;
								_tmp501_ = gee_abstract_list_get ((GeeAbstractList*) _tmp500_, _position_index);
								position = (guint16) ((guintptr) _tmp501_);
								x = (guint8) (position >> 8);
								y = (guint8) position;
								_tmp502_ = self->priv->view;
								_tmp503_ = self->priv->view;
								_tmp504_ = _tmp503_->game;
								_tmp505_ = nibbles_game_get_worm_props (_tmp504_);
								_tmp506_ = _tmp505_;
								_tmp507_ = self->priv->view;
								_tmp508_ = _tmp507_->game;
								_tmp509_ = nibbles_game_get_worms (_tmp508_);
								_tmp510_ = _tmp509_;
								_tmp511_ = gee_abstract_list_get ((GeeAbstractList*) _tmp510_, i);
								_tmp512_ = (Worm*) _tmp511_;
								_tmp513_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp506_, _tmp512_);
								_tmp514_ = (WormProperties*) _tmp513_;
								_tmp515_ = worm_properties_get_color (_tmp514_);
								_tmp516_ = _tmp515_;
								_tmp517_ = self->priv->view;
								_tmp518_ = _tmp517_->game;
								_tmp519_ = nibbles_game_get_worms (_tmp518_);
								_tmp520_ = _tmp519_;
								_tmp521_ = gee_abstract_list_get ((GeeAbstractList*) _tmp520_, i);
								_tmp522_ = (Worm*) _tmp521_;
								nibbles_view_draw_worm_segment (_tmp502_, s, (x_delta * x) + x_offset, (y_delta * y) + y_offset, x_delta, y_delta, _tmp516_, TRUE, worm_was_bonus_eaten_at_this_position (_tmp522_, position));
								_g_object_unref0 (_tmp522_);
								_g_object_unref0 (_tmp514_);
								_g_object_unref0 (_tmp512_);
								_tmp523_ = materialized_worm_positions;
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp523_, (gpointer) ((guintptr) position));
							}
						}
					} else {
						_vala_array_add6 (&dematerialized_worms, &dematerialized_worms_length1, &_dematerialized_worms_size_, i);
					}
				}
			}
		}
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp524_ = FALSE;
				_tmp524_ = TRUE;
				while (TRUE) {
					gint* _tmp526_;
					gint _tmp526__length1;
					if (!_tmp524_) {
						gint _tmp525_;
						_tmp525_ = i;
						i = _tmp525_ + 1;
					}
					_tmp524_ = FALSE;
					_tmp526_ = dematerialized_worms;
					_tmp526__length1 = dematerialized_worms_length1;
					if (!(i < _tmp526__length1)) {
						break;
					}
					{
						WormPositions* _position_list = NULL;
						NibblesView* _tmp527_;
						NibblesGame* _tmp528_;
						GeeLinkedList* _tmp529_;
						GeeLinkedList* _tmp530_;
						gpointer _tmp531_;
						Worm* _tmp532_;
						WormPositions* _tmp533_;
						WormPositions* _tmp534_;
						gint _position_size = 0;
						WormPositions* _tmp535_;
						gint _tmp536_;
						gint _tmp537_;
						gint _position_index = 0;
						_tmp527_ = self->priv->view;
						_tmp528_ = _tmp527_->game;
						_tmp529_ = nibbles_game_get_worms (_tmp528_);
						_tmp530_ = _tmp529_;
						_tmp531_ = gee_abstract_list_get ((GeeAbstractList*) _tmp530_, i);
						_tmp532_ = (Worm*) _tmp531_;
						_tmp533_ = _tmp532_->list;
						_tmp534_ = _tmp533_;
						_g_object_unref0 (_tmp532_);
						_position_list = _tmp534_;
						_tmp535_ = _position_list;
						_tmp536_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp535_);
						_tmp537_ = _tmp536_;
						_position_size = _tmp537_;
						_position_index = -1;
						while (TRUE) {
							gint _tmp538_;
							gint _tmp539_;
							guint16 position = 0U;
							WormPositions* _tmp540_;
							gpointer _tmp541_;
							GeeArrayList* _tmp542_;
							_position_index = _position_index + 1;
							_tmp538_ = _position_index;
							_tmp539_ = _position_size;
							if (!(_tmp538_ < _tmp539_)) {
								break;
							}
							_tmp540_ = _position_list;
							_tmp541_ = gee_abstract_list_get ((GeeAbstractList*) _tmp540_, _position_index);
							position = (guint16) ((guintptr) _tmp541_);
							_tmp542_ = materialized_worm_positions;
							if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp542_, (gpointer) ((guintptr) position))) {
								guint8 x = 0U;
								guint8 y = 0U;
								NibblesView* _tmp543_;
								NibblesView* _tmp544_;
								NibblesGame* _tmp545_;
								GeeHashMap* _tmp546_;
								GeeHashMap* _tmp547_;
								NibblesView* _tmp548_;
								NibblesGame* _tmp549_;
								GeeLinkedList* _tmp550_;
								GeeLinkedList* _tmp551_;
								gpointer _tmp552_;
								Worm* _tmp553_;
								gpointer _tmp554_;
								WormProperties* _tmp555_;
								gint _tmp556_;
								gint _tmp557_;
								x = (guint8) (position >> 8);
								y = (guint8) position;
								_tmp543_ = self->priv->view;
								_tmp544_ = self->priv->view;
								_tmp545_ = _tmp544_->game;
								_tmp546_ = nibbles_game_get_worm_props (_tmp545_);
								_tmp547_ = _tmp546_;
								_tmp548_ = self->priv->view;
								_tmp549_ = _tmp548_->game;
								_tmp550_ = nibbles_game_get_worms (_tmp549_);
								_tmp551_ = _tmp550_;
								_tmp552_ = gee_abstract_list_get ((GeeAbstractList*) _tmp551_, i);
								_tmp553_ = (Worm*) _tmp552_;
								_tmp554_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp547_, _tmp553_);
								_tmp555_ = (WormProperties*) _tmp554_;
								_tmp556_ = worm_properties_get_color (_tmp555_);
								_tmp557_ = _tmp556_;
								nibbles_view_draw_worm_segment (_tmp543_, s, (x_delta * x) + x_offset, (y_delta * y) + y_offset, x_delta, y_delta, _tmp557_, FALSE, FALSE);
								_g_object_unref0 (_tmp555_);
								_g_object_unref0 (_tmp553_);
							}
						}
					}
				}
			}
		}
		{
			GeeList* _bonus_list = NULL;
			NibblesView* _tmp558_;
			NibblesGame* _tmp559_;
			GeeList* _tmp560_;
			gint _bonus_size = 0;
			GeeList* _tmp561_;
			gint _tmp562_;
			gint _tmp563_;
			gint _bonus_index = 0;
			_tmp558_ = self->priv->view;
			_tmp559_ = _tmp558_->game;
			_tmp560_ = nibbles_game_get_bonuses (_tmp559_);
			_bonus_list = _tmp560_;
			_tmp561_ = _bonus_list;
			_tmp562_ = gee_collection_get_size ((GeeCollection*) _tmp561_);
			_tmp563_ = _tmp562_;
			_bonus_size = _tmp563_;
			_bonus_index = -1;
			while (TRUE) {
				gint _tmp564_;
				gint _tmp565_;
				Bonus* bonus = NULL;
				GeeList* _tmp566_;
				gpointer _tmp567_;
				NibblesView* _tmp568_;
				Bonus* _tmp569_;
				guint8 _tmp570_;
				guint8 _tmp571_;
				Bonus* _tmp572_;
				guint8 _tmp573_;
				guint8 _tmp574_;
				Bonus* _tmp575_;
				BonuseType _tmp576_;
				BonuseType _tmp577_;
				_bonus_index = _bonus_index + 1;
				_tmp564_ = _bonus_index;
				_tmp565_ = _bonus_size;
				if (!(_tmp564_ < _tmp565_)) {
					break;
				}
				_tmp566_ = _bonus_list;
				_tmp567_ = gee_list_get (_tmp566_, _bonus_index);
				bonus = (Bonus*) _tmp567_;
				_tmp568_ = self->priv->view;
				_tmp569_ = bonus;
				_tmp570_ = bonus_get_x (_tmp569_);
				_tmp571_ = _tmp570_;
				_tmp572_ = bonus;
				_tmp573_ = bonus_get_y (_tmp572_);
				_tmp574_ = _tmp573_;
				_tmp575_ = bonus;
				_tmp576_ = bonus_get_etype (_tmp575_);
				_tmp577_ = _tmp576_;
				nibbles_view_draw_bonus (_tmp568_, s, (x_delta * _tmp571_) + x_offset, (y_delta * _tmp574_) + y_offset, x_delta + x_delta, y_delta + y_delta, _tmp577_, self->priv->animate);
				_g_object_unref0 (bonus);
			}
			_g_object_unref0 (_bonus_list);
		}
		_tmp578_ = self->priv->view;
		_tmp579_ = _tmp578_->priv->countdown_active;
		_tmp579__target = _tmp578_->priv->countdown_active_target;
		if (_tmp579_ (_tmp579__target) > 0) {
			gchar* text = NULL;
			NibblesView* _tmp580_;
			NibblesView* _tmp581_;
			NibblesViewCountdownActiveFunction _tmp582_;
			gpointer _tmp582__target;
			gchar* _tmp583_;
			gdouble w = 0.0;
			gdouble h = 0.0;
			gint font_size = 0;
			NibblesView* _tmp584_;
			const gchar* _tmp585_;
			gdouble _tmp586_ = 0.0;
			gdouble _tmp587_ = 0.0;
			NibblesView* _tmp588_;
			const gchar* _tmp589_;
			_tmp580_ = self->priv->view;
			_tmp581_ = self->priv->view;
			_tmp582_ = _tmp581_->priv->countdown_active;
			_tmp582__target = _tmp581_->priv->countdown_active_target;
			_tmp583_ = nibbles_view_seconds_string (_tmp580_, _tmp582_ (_tmp582__target));
			text = _tmp583_;
			font_size = 252;
			_tmp584_ = self->priv->view;
			_tmp585_ = text;
			nibbles_view_calculate_text_size (_tmp584_, _tmp585_, font_size, &_tmp586_, &_tmp587_);
			w = _tmp586_;
			h = _tmp587_;
			_tmp588_ = self->priv->view;
			_tmp589_ = text;
			nibbles_view_draw_text_font_size (_tmp588_, s, (gint) ((x_offset + (x_delta * (NIBBLES_VIEW_WIDTH / 2))) - (w / 2)), (gint) ((y_offset + (y_delta * (NIBBLES_VIEW_HEIGHT / 2))) - (h / 2)), _tmp589_, font_size);
			{
				GeeLinkedList* _worm_list = NULL;
				NibblesView* _tmp590_;
				NibblesGame* _tmp591_;
				GeeLinkedList* _tmp592_;
				GeeLinkedList* _tmp593_;
				gint _worm_size = 0;
				GeeLinkedList* _tmp594_;
				gint _tmp595_;
				gint _tmp596_;
				gint _worm_index = 0;
				_tmp590_ = self->priv->view;
				_tmp591_ = _tmp590_->game;
				_tmp592_ = nibbles_game_get_worms (_tmp591_);
				_tmp593_ = _tmp592_;
				_worm_list = _tmp593_;
				_tmp594_ = _worm_list;
				_tmp595_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp594_);
				_tmp596_ = _tmp595_;
				_worm_size = _tmp596_;
				_worm_index = -1;
				while (TRUE) {
					gint _tmp597_;
					gint _tmp598_;
					Worm* worm = NULL;
					GeeLinkedList* _tmp599_;
					gpointer _tmp600_;
					Worm* _tmp601_;
					WormPositions* _tmp602_;
					gboolean _tmp603_;
					gboolean _tmp604_;
					_worm_index = _worm_index + 1;
					_tmp597_ = _worm_index;
					_tmp598_ = _worm_size;
					if (!(_tmp597_ < _tmp598_)) {
						break;
					}
					_tmp599_ = _worm_list;
					_tmp600_ = gee_abstract_list_get ((GeeAbstractList*) _tmp599_, _worm_index);
					worm = (Worm*) _tmp600_;
					_tmp601_ = worm;
					_tmp602_ = _tmp601_->list;
					_tmp603_ = gee_collection_get_is_empty ((GeeCollection*) _tmp602_);
					_tmp604_ = _tmp603_;
					if (!_tmp604_) {
						gint color = 0;
						NibblesView* _tmp605_;
						NibblesGame* _tmp606_;
						GeeHashMap* _tmp607_;
						GeeHashMap* _tmp608_;
						Worm* _tmp609_;
						gpointer _tmp610_;
						WormProperties* _tmp611_;
						gint _tmp612_;
						gint _tmp613_;
						gint _tmp614_;
						gboolean _tmp615_ = FALSE;
						Worm* _tmp616_;
						WormDirection _tmp617_;
						WormDirection _tmp618_;
						_tmp605_ = self->priv->view;
						_tmp606_ = _tmp605_->game;
						_tmp607_ = nibbles_game_get_worm_props (_tmp606_);
						_tmp608_ = _tmp607_;
						_tmp609_ = worm;
						_tmp610_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp608_, _tmp609_);
						_tmp611_ = (WormProperties*) _tmp610_;
						_tmp612_ = worm_properties_get_color (_tmp611_);
						_tmp613_ = _tmp612_;
						_tmp614_ = _tmp613_;
						_g_object_unref0 (_tmp611_);
						color = _tmp614_;
						_tmp616_ = worm;
						_tmp617_ = worm_get_direction (_tmp616_);
						_tmp618_ = _tmp617_;
						if (_tmp618_ == WORM_DIRECTION_UP) {
							_tmp615_ = TRUE;
						} else {
							Worm* _tmp619_;
							WormDirection _tmp620_;
							WormDirection _tmp621_;
							_tmp619_ = worm;
							_tmp620_ = worm_get_direction (_tmp619_);
							_tmp621_ = _tmp620_;
							_tmp615_ = _tmp621_ == WORM_DIRECTION_DOWN;
						}
						if (_tmp615_) {
							gint middle = 0;
							Worm* _tmp622_;
							gint _tmp623_;
							gint _tmp624_;
							NibblesView* _tmp625_;
							Worm* _tmp626_;
							WormPositions* _tmp627_;
							gpointer _tmp628_;
							Worm* _tmp629_;
							WormPositions* _tmp630_;
							gpointer _tmp631_;
							NibblesView* _tmp632_;
							Worm* _tmp633_;
							gint _tmp634_;
							gint _tmp635_;
							gchar* _tmp636_;
							gchar* _tmp637_;
							Worm* _tmp638_;
							gint _tmp639_;
							gint _tmp640_;
							_tmp622_ = worm;
							_tmp623_ = worm_get_length (_tmp622_);
							_tmp624_ = _tmp623_;
							middle = _tmp624_ / 2;
							_tmp625_ = self->priv->view;
							_tmp626_ = worm;
							_tmp627_ = _tmp626_->list;
							_tmp628_ = gee_abstract_list_get ((GeeAbstractList*) _tmp627_, middle);
							_tmp629_ = worm;
							_tmp630_ = _tmp629_->list;
							_tmp631_ = gee_abstract_list_get ((GeeAbstractList*) _tmp630_, middle);
							_tmp632_ = self->priv->view;
							_tmp633_ = worm;
							_tmp634_ = worm_get_id (_tmp633_);
							_tmp635_ = _tmp634_;
							_tmp636_ = nibbles_view_worm_name (_tmp632_, _tmp635_ + 1);
							_tmp637_ = _tmp636_;
							_tmp638_ = worm;
							_tmp639_ = worm_get_length (_tmp638_);
							_tmp640_ = _tmp639_;
							nibbles_view_draw_text_target_width (_tmp625_, s, (x_offset + (x_delta * ((((guint16) ((guintptr) _tmp628_)) >> 8) + 1))) + (x_delta / 2), y_offset + (y_delta * ((guint8) ((guint16) ((guintptr) _tmp631_)))), _tmp637_, x_delta * _tmp640_, color);
							_g_free0 (_tmp637_);
						} else {
							gboolean _tmp641_ = FALSE;
							Worm* _tmp642_;
							WormDirection _tmp643_;
							WormDirection _tmp644_;
							_tmp642_ = worm;
							_tmp643_ = worm_get_direction (_tmp642_);
							_tmp644_ = _tmp643_;
							if (_tmp644_ == WORM_DIRECTION_LEFT) {
								_tmp641_ = TRUE;
							} else {
								Worm* _tmp645_;
								WormDirection _tmp646_;
								WormDirection _tmp647_;
								_tmp645_ = worm;
								_tmp646_ = worm_get_direction (_tmp645_);
								_tmp647_ = _tmp646_;
								_tmp641_ = _tmp647_ == WORM_DIRECTION_RIGHT;
							}
							if (_tmp641_) {
								gint x = 0;
								Worm* _tmp648_;
								WormPositions* _tmp649_;
								gpointer _tmp650_;
								Worm* _tmp651_;
								WormPositions* _tmp652_;
								Worm* _tmp653_;
								gint _tmp654_;
								gint _tmp655_;
								gpointer _tmp656_;
								NibblesView* _tmp663_;
								Worm* _tmp664_;
								WormPositions* _tmp665_;
								gpointer _tmp666_;
								NibblesView* _tmp667_;
								Worm* _tmp668_;
								gint _tmp669_;
								gint _tmp670_;
								gchar* _tmp671_;
								gchar* _tmp672_;
								Worm* _tmp673_;
								gint _tmp674_;
								gint _tmp675_;
								_tmp648_ = worm;
								_tmp649_ = _tmp648_->list;
								_tmp650_ = gee_abstract_list_get ((GeeAbstractList*) _tmp649_, 0);
								x = ((guint16) ((guintptr) _tmp650_)) >> 8;
								_tmp651_ = worm;
								_tmp652_ = _tmp651_->list;
								_tmp653_ = worm;
								_tmp654_ = worm_get_length (_tmp653_);
								_tmp655_ = _tmp654_;
								_tmp656_ = gee_abstract_list_get ((GeeAbstractList*) _tmp652_, _tmp655_ - 1);
								if (x > (((guint16) ((guintptr) _tmp656_)) >> 8)) {
									Worm* _tmp657_;
									WormPositions* _tmp658_;
									Worm* _tmp659_;
									gint _tmp660_;
									gint _tmp661_;
									gpointer _tmp662_;
									_tmp657_ = worm;
									_tmp658_ = _tmp657_->list;
									_tmp659_ = worm;
									_tmp660_ = worm_get_length (_tmp659_);
									_tmp661_ = _tmp660_;
									_tmp662_ = gee_abstract_list_get ((GeeAbstractList*) _tmp658_, _tmp661_ - 1);
									x = ((guint16) ((guintptr) _tmp662_)) >> 8;
								}
								_tmp663_ = self->priv->view;
								_tmp664_ = worm;
								_tmp665_ = _tmp664_->list;
								_tmp666_ = gee_abstract_list_get ((GeeAbstractList*) _tmp665_, 0);
								_tmp667_ = self->priv->view;
								_tmp668_ = worm;
								_tmp669_ = worm_get_id (_tmp668_);
								_tmp670_ = _tmp669_;
								_tmp671_ = nibbles_view_worm_name (_tmp667_, _tmp670_ + 1);
								_tmp672_ = _tmp671_;
								_tmp673_ = worm;
								_tmp674_ = worm_get_length (_tmp673_);
								_tmp675_ = _tmp674_;
								nibbles_view_draw_text_target_width (_tmp663_, s, x_offset + (x_delta * x), (y_offset + (y_delta * ((guint8) ((guint16) ((guintptr) _tmp666_))))) - y_delta, _tmp672_, x_delta * _tmp675_, color);
								_g_free0 (_tmp672_);
							}
						}
					}
					_g_object_unref0 (worm);
				}
			}
			_g_free0 (text);
		}
		dematerialized_worms = (g_free (dematerialized_worms), NULL);
		_g_object_unref0 (materialized_worm_positions);
	}
}

static void
nibbles_view_active_view_class_init (NibblesViewActiveViewClass * klass,
                                     gpointer klass_data)
{
	nibbles_view_active_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NibblesViewActiveView_private_offset);
	((GtkWidgetClass *) klass)->snapshot = (void (*) (GtkWidget*, GtkSnapshot*)) nibbles_view_active_view_real_snapshot;
	G_OBJECT_CLASS (klass)->finalize = nibbles_view_active_view_finalize;
}

static void
nibbles_view_active_view_instance_init (NibblesViewActiveView * self,
                                        gpointer klass)
{
	self->priv = nibbles_view_active_view_get_instance_private (self);
	self->priv->animate = (guint64) 0;
}

static void
nibbles_view_active_view_finalize (GObject * obj)
{
	NibblesViewActiveView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NIBBLES_VIEW_TYPE_ACTIVE_VIEW, NibblesViewActiveView);
	G_OBJECT_CLASS (nibbles_view_active_view_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
nibbles_view_active_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NibblesViewActiveViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) nibbles_view_active_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NibblesViewActiveView), 0, (GInstanceInitFunc) nibbles_view_active_view_instance_init, NULL };
	GType nibbles_view_active_view_type_id;
	nibbles_view_active_view_type_id = g_type_register_static (gtk_widget_get_type (), "NibblesViewActiveView", &g_define_type_info, 0);
	NibblesViewActiveView_private_offset = g_type_add_instance_private (nibbles_view_active_view_type_id, sizeof (NibblesViewActiveViewPrivate));
	return nibbles_view_active_view_type_id;
}

GType
nibbles_view_active_view_get_type (void)
{
	static gsize nibbles_view_active_view_type_id__once = 0;
	if (g_once_init_enter (&nibbles_view_active_view_type_id__once)) {
		GType nibbles_view_active_view_type_id;
		nibbles_view_active_view_type_id = nibbles_view_active_view_get_type_once ();
		g_once_init_leave (&nibbles_view_active_view_type_id__once, nibbles_view_active_view_type_id);
	}
	return nibbles_view_active_view_type_id__once;
}

static NibblesViewPoint3D*
nibbles_view_point3_d_dup (const NibblesViewPoint3D* self)
{
	NibblesViewPoint3D* dup;
	dup = g_new0 (NibblesViewPoint3D, 1);
	memcpy (dup, self, sizeof (NibblesViewPoint3D));
	return dup;
}

static void
nibbles_view_point3_d_free (NibblesViewPoint3D* self)
{
	g_free (self);
}

 G_GNUC_NO_INLINE static GType
nibbles_view_point3_d_get_type_once (void)
{
	GType nibbles_view_point3_d_type_id;
	nibbles_view_point3_d_type_id = g_boxed_type_register_static ("NibblesViewPoint3D", (GBoxedCopyFunc) nibbles_view_point3_d_dup, (GBoxedFreeFunc) nibbles_view_point3_d_free);
	return nibbles_view_point3_d_type_id;
}

static GType
nibbles_view_point3_d_get_type (void)
{
	static gsize nibbles_view_point3_d_type_id__once = 0;
	if (g_once_init_enter (&nibbles_view_point3_d_type_id__once)) {
		GType nibbles_view_point3_d_type_id;
		nibbles_view_point3_d_type_id = nibbles_view_point3_d_get_type_once ();
		g_once_init_leave (&nibbles_view_point3_d_type_id__once, nibbles_view_point3_d_type_id);
	}
	return nibbles_view_point3_d_type_id__once;
}

static void
nibbles_view_class_init (NibblesViewClass * klass,
                         gpointer klass_data)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar** _tmp12_;
	nibbles_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NibblesView_private_offset);
	G_OBJECT_CLASS (klass)->finalize = nibbles_view_finalize;
	_tmp0_ = g_strdup ("red");
	_tmp1_ = g_strdup (N_ ("red"));
	_tmp2_ = g_strdup ("green");
	_tmp3_ = g_strdup (N_ ("green"));
	_tmp4_ = g_strdup ("blue");
	_tmp5_ = g_strdup (N_ ("blue"));
	_tmp6_ = g_strdup ("yellow");
	_tmp7_ = g_strdup (N_ ("yellow"));
	_tmp8_ = g_strdup ("cyan");
	_tmp9_ = g_strdup (N_ ("cyan"));
	_tmp10_ = g_strdup ("purple");
	_tmp11_ = g_strdup (N_ ("purple"));
	_tmp12_ = g_new0 (gchar*, (6 * 2) + 1);
	_tmp12_[0] = _tmp0_;
	_tmp12_[1] = _tmp1_;
	_tmp12_[2] = _tmp2_;
	_tmp12_[3] = _tmp3_;
	_tmp12_[4] = _tmp4_;
	_tmp12_[5] = _tmp5_;
	_tmp12_[6] = _tmp6_;
	_tmp12_[7] = _tmp7_;
	_tmp12_[8] = _tmp8_;
	_tmp12_[9] = _tmp9_;
	_tmp12_[10] = _tmp10_;
	_tmp12_[11] = _tmp11_;
	nibbles_view_color_lookup = _tmp12_;
	nibbles_view_color_lookup_length1 = 6;
	nibbles_view_color_lookup_length2 = 2;
}

static void
nibbles_view_instance_init (NibblesView * self,
                            gpointer klass)
{
	self->priv = nibbles_view_get_instance_private (self);
	self->priv->static_view = NULL;
	self->priv->active_view = NULL;
}

static void
nibbles_view_finalize (GObject * obj)
{
	NibblesView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NIBBLES_VIEW, NibblesView);
	_g_object_unref0 (self->game);
	_g_object_unref0 (self->priv->static_view);
	_g_object_unref0 (self->priv->active_view);
	G_OBJECT_CLASS (nibbles_view_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
nibbles_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NibblesViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) nibbles_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NibblesView), 0, (GInstanceInitFunc) nibbles_view_instance_init, NULL };
	GType nibbles_view_type_id;
	nibbles_view_type_id = g_type_register_static (TYPE_TRANSPARENT_CONTAINER, "NibblesView", &g_define_type_info, 0);
	NibblesView_private_offset = g_type_add_instance_private (nibbles_view_type_id, sizeof (NibblesViewPrivate));
	return nibbles_view_type_id;
}

GType
nibbles_view_get_type (void)
{
	static gsize nibbles_view_type_id__once = 0;
	if (g_once_init_enter (&nibbles_view_type_id__once)) {
		GType nibbles_view_type_id;
		nibbles_view_type_id = nibbles_view_get_type_once ();
		g_once_init_leave (&nibbles_view_type_id__once, nibbles_view_type_id);
	}
	return nibbles_view_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

