/* util-generic-capabilities.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from util-generic-capabilities.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GEARY_GENERIC_CAPABILITIES_0_PROPERTY,
	GEARY_GENERIC_CAPABILITIES_NAME_SEPARATOR_PROPERTY,
	GEARY_GENERIC_CAPABILITIES_VALUE_SEPARATOR_PROPERTY,
	GEARY_GENERIC_CAPABILITIES_NUM_PROPERTIES
};
static GParamSpec* geary_generic_capabilities_properties[GEARY_GENERIC_CAPABILITIES_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GearyGenericCapabilitiesPrivate {
	gchar* _name_separator;
	gchar* _value_separator;
	GeeHashMultiMap* map;
};

static gint GearyGenericCapabilities_private_offset;
static gpointer geary_generic_capabilities_parent_class = NULL;

static void geary_generic_capabilities_set_name_separator (GearyGenericCapabilities* self,
                                                    const gchar* value);
static void geary_generic_capabilities_set_value_separator (GearyGenericCapabilities* self,
                                                     const gchar* value);
static guint _geary_ascii_nullable_stri_hash_gee_hash_data_func (gconstpointer v,
                                                          gpointer self);
static gboolean _geary_ascii_nullable_stri_equal_gee_equal_data_func (gconstpointer a,
                                                               gconstpointer b,
                                                               gpointer self);
static gchar* geary_generic_capabilities_real_to_string (GearyGenericCapabilities* self);
static inline void geary_generic_capabilities_append (GearyGenericCapabilities* self,
                                        GString* builder,
                                        const gchar* text);
static inline void geary_generic_capabilities_add_capability (GearyGenericCapabilities* self,
                                                const gchar* name,
                                                const gchar* setting);
static void geary_generic_capabilities_finalize (GObject * obj);
static GType geary_generic_capabilities_get_type_once (void);
static void _vala_geary_generic_capabilities_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec);
static void _vala_geary_generic_capabilities_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
geary_generic_capabilities_get_instance_private (GearyGenericCapabilities* self)
{
	return G_STRUCT_MEMBER_P (self, GearyGenericCapabilities_private_offset);
}

const gchar*
geary_generic_capabilities_get_name_separator (GearyGenericCapabilities* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (GEARY_IS_GENERIC_CAPABILITIES (self), NULL);
	_tmp0_ = self->priv->_name_separator;
	result = _tmp0_;
	return result;
}

static void
geary_generic_capabilities_set_name_separator (GearyGenericCapabilities* self,
                                               const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (GEARY_IS_GENERIC_CAPABILITIES (self));
	old_value = geary_generic_capabilities_get_name_separator (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_name_separator);
		self->priv->_name_separator = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_generic_capabilities_properties[GEARY_GENERIC_CAPABILITIES_NAME_SEPARATOR_PROPERTY]);
	}
}

const gchar*
geary_generic_capabilities_get_value_separator (GearyGenericCapabilities* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (GEARY_IS_GENERIC_CAPABILITIES (self), NULL);
	_tmp0_ = self->priv->_value_separator;
	result = _tmp0_;
	return result;
}

static void
geary_generic_capabilities_set_value_separator (GearyGenericCapabilities* self,
                                                const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (GEARY_IS_GENERIC_CAPABILITIES (self));
	old_value = geary_generic_capabilities_get_value_separator (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_value_separator);
		self->priv->_value_separator = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_generic_capabilities_properties[GEARY_GENERIC_CAPABILITIES_VALUE_SEPARATOR_PROPERTY]);
	}
}

static guint
_geary_ascii_nullable_stri_hash_gee_hash_data_func (gconstpointer v,
                                                    gpointer self)
{
	guint result;
	result = geary_ascii_nullable_stri_hash ((const gchar*) v);
	return result;
}

static gboolean
_geary_ascii_nullable_stri_equal_gee_equal_data_func (gconstpointer a,
                                                      gconstpointer b,
                                                      gpointer self)
{
	gboolean result;
	result = geary_ascii_nullable_stri_equal ((const gchar*) a, (const gchar*) b);
	return result;
}

/**
     * Creates an empty set of capabilities.
     */
GearyGenericCapabilities*
geary_generic_capabilities_construct (GType object_type,
                                      const gchar* name_separator,
                                      const gchar* value_separator)
{
	GearyGenericCapabilities * self = NULL;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (name_separator != NULL, NULL);
	self = (GearyGenericCapabilities*) geary_base_object_construct (object_type);
	_vala_assert (!geary_string_is_empty (name_separator), "!String.is_empty(name_separator)");
	geary_generic_capabilities_set_name_separator (self, name_separator);
	if (!geary_string_is_empty (value_separator)) {
		_tmp0_ = value_separator;
	} else {
		_tmp0_ = NULL;
	}
	geary_generic_capabilities_set_value_separator (self, _tmp0_);
	return self;
}

GearyGenericCapabilities*
geary_generic_capabilities_new (const gchar* name_separator,
                                const gchar* value_separator)
{
	return geary_generic_capabilities_construct (GEARY_TYPE_GENERIC_CAPABILITIES, name_separator, value_separator);
}

gboolean
geary_generic_capabilities_is_empty (GearyGenericCapabilities* self)
{
	GeeHashMultiMap* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gboolean result;
	g_return_val_if_fail (GEARY_IS_GENERIC_CAPABILITIES (self), FALSE);
	_tmp0_ = self->priv->map;
	_tmp1_ = gee_multi_map_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_MULTI_MAP, GeeMultiMap));
	_tmp2_ = _tmp1_;
	result = _tmp2_ == 0;
	return result;
}

/**
     * Returns true only if the capability was named as available by the server.
     */
gboolean
geary_generic_capabilities_has_capability (GearyGenericCapabilities* self,
                                           const gchar* name)
{
	GeeHashMultiMap* _tmp0_;
	gboolean result;
	g_return_val_if_fail (GEARY_IS_GENERIC_CAPABILITIES (self), FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = self->priv->map;
	result = gee_multi_map_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_MULTI_MAP, GeeMultiMap), name);
	return result;
}

/**
     * Returns true only if the capability and the associated setting were both named as available
     * by the server.
     */
gboolean
geary_generic_capabilities_has_setting (GearyGenericCapabilities* self,
                                        const gchar* name,
                                        const gchar* setting)
{
	GeeHashMultiMap* _tmp0_;
	GeeHashMultiMap* _tmp1_;
	GeeCollection* _tmp2_;
	GeeCollection* _tmp3_;
	gboolean _tmp4_;
	gboolean result;
	g_return_val_if_fail (GEARY_IS_GENERIC_CAPABILITIES (self), FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = self->priv->map;
	if (!gee_multi_map_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_MULTI_MAP, GeeMultiMap), name)) {
		result = FALSE;
		return result;
	}
	if (geary_string_is_empty (setting)) {
		result = TRUE;
		return result;
	}
	_tmp1_ = self->priv->map;
	_tmp2_ = gee_multi_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_MULTI_MAP, GeeMultiMap), name);
	_tmp3_ = _tmp2_;
	_tmp4_ = gee_collection_contains (_tmp3_, setting);
	_g_object_unref0 (_tmp3_);
	result = _tmp4_;
	return result;
}

/**
     * Returns null if either the capability is available but has no associated settings, or if the
     * capability is not available.  Thus, use has_capability() to determine if available, then
     * this method to get its value (if one is expected).  Often has_setting() is a better choice.
     */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GeeCollection*
geary_generic_capabilities_get_settings (GearyGenericCapabilities* self,
                                         const gchar* name)
{
	GeeCollection* settings = NULL;
	GeeHashMultiMap* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_ = NULL;
	GeeCollection* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GeeCollection* _tmp7_;
	GeeCollection* result;
	g_return_val_if_fail (GEARY_IS_GENERIC_CAPABILITIES (self), NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->priv->map;
	_tmp1_ = gee_multi_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_MULTI_MAP, GeeMultiMap), name);
	settings = _tmp1_;
	_tmp3_ = settings;
	_tmp4_ = gee_collection_get_size (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ > 0) {
		GeeCollection* _tmp6_;
		_tmp6_ = settings;
		_tmp2_ = _tmp6_;
	} else {
		_tmp2_ = NULL;
	}
	_tmp7_ = _g_object_ref0 (_tmp2_);
	result = _tmp7_;
	_g_object_unref0 (settings);
	return result;
}

GeeSet*
geary_generic_capabilities_get_all_names (GearyGenericCapabilities* self)
{
	GeeSet* names = NULL;
	GeeHashMultiMap* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_ = NULL;
	GeeSet* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GeeSet* _tmp7_;
	GeeSet* result;
	g_return_val_if_fail (GEARY_IS_GENERIC_CAPABILITIES (self), NULL);
	_tmp0_ = self->priv->map;
	_tmp1_ = gee_multi_map_get_keys (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_MULTI_MAP, GeeMultiMap));
	names = _tmp1_;
	_tmp3_ = names;
	_tmp4_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp5_ = _tmp4_;
	if (_tmp5_ > 0) {
		GeeSet* _tmp6_;
		_tmp6_ = names;
		_tmp2_ = _tmp6_;
	} else {
		_tmp2_ = NULL;
	}
	_tmp7_ = _g_object_ref0 (_tmp2_);
	result = _tmp7_;
	_g_object_unref0 (names);
	return result;
}

static gchar*
geary_generic_capabilities_real_to_string (GearyGenericCapabilities* self)
{
	GeeSet* names = NULL;
	GeeSet* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GeeSet* _tmp2_;
	GString* builder = NULL;
	GString* _tmp7_;
	GString* _tmp36_;
	const gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* result;
	_tmp0_ = geary_generic_capabilities_get_all_names (self);
	names = _tmp0_;
	_tmp2_ = names;
	if (_tmp2_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		GeeSet* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		_tmp3_ = names;
		_tmp4_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp5_ = _tmp4_;
		_tmp1_ = _tmp5_ == 0;
	}
	if (_tmp1_) {
		gchar* _tmp6_;
		_tmp6_ = g_strdup ("");
		result = _tmp6_;
		_g_object_unref0 (names);
		return result;
	}
	_tmp7_ = g_string_new ("");
	builder = _tmp7_;
	{
		GeeIterator* _name_it = NULL;
		GeeSet* _tmp8_;
		GeeIterator* _tmp9_;
		_tmp8_ = names;
		_tmp9_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ITERABLE, GeeIterable));
		_name_it = _tmp9_;
		while (TRUE) {
			GeeIterator* _tmp10_;
			gchar* name = NULL;
			GeeIterator* _tmp11_;
			gpointer _tmp12_;
			GeeCollection* settings = NULL;
			const gchar* _tmp13_;
			GeeCollection* _tmp14_;
			gboolean _tmp15_ = FALSE;
			GeeCollection* _tmp16_;
			_tmp10_ = _name_it;
			if (!gee_iterator_next (_tmp10_)) {
				break;
			}
			_tmp11_ = _name_it;
			_tmp12_ = gee_iterator_get (_tmp11_);
			name = (gchar*) _tmp12_;
			_tmp13_ = name;
			_tmp14_ = geary_generic_capabilities_get_settings (self, _tmp13_);
			settings = _tmp14_;
			_tmp16_ = settings;
			if (_tmp16_ == NULL) {
				_tmp15_ = TRUE;
			} else {
				GeeCollection* _tmp17_;
				gint _tmp18_;
				gint _tmp19_;
				_tmp17_ = settings;
				_tmp18_ = gee_collection_get_size (_tmp17_);
				_tmp19_ = _tmp18_;
				_tmp15_ = _tmp19_ == 0;
			}
			if (_tmp15_) {
				GString* _tmp20_;
				const gchar* _tmp21_;
				_tmp20_ = builder;
				_tmp21_ = name;
				geary_generic_capabilities_append (self, _tmp20_, _tmp21_);
			} else {
				{
					GeeIterator* _setting_it = NULL;
					GeeCollection* _tmp22_;
					GeeIterator* _tmp23_;
					_tmp22_ = settings;
					_tmp23_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, GEE_TYPE_ITERABLE, GeeIterable));
					_setting_it = _tmp23_;
					while (TRUE) {
						GeeIterator* _tmp24_;
						gchar* setting = NULL;
						GeeIterator* _tmp25_;
						gpointer _tmp26_;
						const gchar* _tmp27_;
						_tmp24_ = _setting_it;
						if (!gee_iterator_next (_tmp24_)) {
							break;
						}
						_tmp25_ = _setting_it;
						_tmp26_ = gee_iterator_get (_tmp25_);
						setting = (gchar*) _tmp26_;
						_tmp27_ = setting;
						if (geary_string_is_empty (_tmp27_)) {
							GString* _tmp28_;
							const gchar* _tmp29_;
							_tmp28_ = builder;
							_tmp29_ = name;
							geary_generic_capabilities_append (self, _tmp28_, _tmp29_);
						} else {
							GString* _tmp30_;
							const gchar* _tmp31_;
							const gchar* _tmp32_;
							const gchar* _tmp33_;
							gchar* _tmp34_;
							gchar* _tmp35_;
							_tmp30_ = builder;
							_tmp31_ = name;
							_tmp32_ = self->priv->_name_separator;
							_tmp33_ = setting;
							_tmp34_ = g_strdup_printf ("\"%s%s%s\"", _tmp31_, _tmp32_, _tmp33_);
							_tmp35_ = _tmp34_;
							geary_generic_capabilities_append (self, _tmp30_, _tmp35_);
							_g_free0 (_tmp35_);
						}
						_g_free0 (setting);
					}
					_g_object_unref0 (_setting_it);
				}
			}
			_g_object_unref0 (settings);
			_g_free0 (name);
		}
		_g_object_unref0 (_name_it);
	}
	_tmp36_ = builder;
	_tmp37_ = _tmp36_->str;
	_tmp38_ = g_strdup (_tmp37_);
	result = _tmp38_;
	_g_string_free0 (builder);
	_g_object_unref0 (names);
	return result;
}

gchar*
geary_generic_capabilities_to_string (GearyGenericCapabilities* self)
{
	GearyGenericCapabilitiesClass* _klass_;
	g_return_val_if_fail (GEARY_IS_GENERIC_CAPABILITIES (self), NULL);
	_klass_ = GEARY_GENERIC_CAPABILITIES_GET_CLASS (self);
	if (_klass_->to_string) {
		return _klass_->to_string (self);
	}
	return NULL;
}

static inline void
geary_generic_capabilities_append (GearyGenericCapabilities* self,
                                   GString* builder,
                                   const gchar* text)
{
	const gchar* _tmp0_;
	g_return_if_fail (GEARY_IS_GENERIC_CAPABILITIES (self));
	g_return_if_fail (builder != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = builder->str;
	if (!geary_string_is_empty (_tmp0_)) {
		const gchar* _tmp1_ = NULL;
		const gchar* _tmp2_;
		_tmp2_ = self->priv->_value_separator;
		if (geary_string_is_empty (_tmp2_)) {
			_tmp1_ = " ";
		} else {
			const gchar* _tmp3_;
			_tmp3_ = self->priv->_value_separator;
			_tmp1_ = _tmp3_;
		}
		g_string_append (builder, _tmp1_);
	}
	g_string_append (builder, text);
}

gboolean
geary_generic_capabilities_parse_and_add_capability (GearyGenericCapabilities* self,
                                                     const gchar* text)
{
	gchar** name_values = NULL;
	const gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint name_values_length1;
	gint _name_values_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gboolean result;
	g_return_val_if_fail (GEARY_IS_GENERIC_CAPABILITIES (self), FALSE);
	g_return_val_if_fail (text != NULL, FALSE);
	_tmp0_ = self->priv->_name_separator;
	_tmp2_ = _tmp1_ = g_strsplit (text, _tmp0_, 2);
	name_values = _tmp2_;
	name_values_length1 = _vala_array_length (_tmp1_);
	_name_values_size_ = name_values_length1;
	_tmp3_ = name_values;
	_tmp3__length1 = name_values_length1;
	switch (_tmp3__length1) {
		case 1:
		{
			gchar** _tmp4_;
			gint _tmp4__length1;
			const gchar* _tmp5_;
			_tmp4_ = name_values;
			_tmp4__length1 = name_values_length1;
			_tmp5_ = _tmp4_[0];
			geary_generic_capabilities_add_capability (self, _tmp5_, NULL);
			break;
		}
		case 2:
		{
			const gchar* _tmp6_;
			_tmp6_ = self->priv->_value_separator;
			if (_tmp6_ == NULL) {
				gchar** _tmp7_;
				gint _tmp7__length1;
				const gchar* _tmp8_;
				gchar** _tmp9_;
				gint _tmp9__length1;
				const gchar* _tmp10_;
				_tmp7_ = name_values;
				_tmp7__length1 = name_values_length1;
				_tmp8_ = _tmp7_[0];
				_tmp9_ = name_values;
				_tmp9__length1 = name_values_length1;
				_tmp10_ = _tmp9_[1];
				geary_generic_capabilities_add_capability (self, _tmp8_, _tmp10_);
			} else {
				gchar** values = NULL;
				gchar** _tmp11_;
				gint _tmp11__length1;
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				gchar** _tmp14_;
				gchar** _tmp15_;
				gint values_length1;
				gint _values_size_;
				gchar** _tmp16_;
				gint _tmp16__length1;
				_tmp11_ = name_values;
				_tmp11__length1 = name_values_length1;
				_tmp12_ = _tmp11_[1];
				_tmp13_ = self->priv->_value_separator;
				_tmp15_ = _tmp14_ = g_strsplit (_tmp12_, _tmp13_, 0);
				values = _tmp15_;
				values_length1 = _vala_array_length (_tmp14_);
				_values_size_ = values_length1;
				_tmp16_ = values;
				_tmp16__length1 = values_length1;
				if (_tmp16__length1 <= 1) {
					gchar** _tmp17_;
					gint _tmp17__length1;
					const gchar* _tmp18_;
					gchar** _tmp19_;
					gint _tmp19__length1;
					const gchar* _tmp20_;
					_tmp17_ = name_values;
					_tmp17__length1 = name_values_length1;
					_tmp18_ = _tmp17_[0];
					_tmp19_ = name_values;
					_tmp19__length1 = name_values_length1;
					_tmp20_ = _tmp19_[1];
					geary_generic_capabilities_add_capability (self, _tmp18_, _tmp20_);
				} else {
					gchar** _tmp21_;
					gint _tmp21__length1;
					_tmp21_ = values;
					_tmp21__length1 = values_length1;
					{
						gchar** value_collection = NULL;
						gint value_collection_length1 = 0;
						gint _value_collection_size_ = 0;
						gint value_it = 0;
						value_collection = _tmp21_;
						value_collection_length1 = _tmp21__length1;
						for (value_it = 0; value_it < value_collection_length1; value_it = value_it + 1) {
							gchar* _tmp22_;
							gchar* value = NULL;
							_tmp22_ = g_strdup (value_collection[value_it]);
							value = _tmp22_;
							{
								gchar** _tmp23_;
								gint _tmp23__length1;
								const gchar* _tmp24_;
								const gchar* _tmp25_;
								_tmp23_ = name_values;
								_tmp23__length1 = name_values_length1;
								_tmp24_ = _tmp23_[0];
								_tmp25_ = value;
								geary_generic_capabilities_add_capability (self, _tmp24_, _tmp25_);
								_g_free0 (value);
							}
						}
					}
				}
				values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
			}
			break;
		}
		default:
		{
			result = FALSE;
			name_values = (_vala_array_free (name_values, name_values_length1, (GDestroyNotify) g_free), NULL);
			return result;
		}
	}
	result = TRUE;
	name_values = (_vala_array_free (name_values, name_values_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static inline void
geary_generic_capabilities_add_capability (GearyGenericCapabilities* self,
                                           const gchar* name,
                                           const gchar* setting)
{
	const gchar* _tmp0_ = NULL;
	GeeHashMultiMap* _tmp1_;
	g_return_if_fail (GEARY_IS_GENERIC_CAPABILITIES (self));
	g_return_if_fail (name != NULL);
	if (geary_string_is_empty (setting)) {
		_tmp0_ = NULL;
	} else {
		_tmp0_ = setting;
	}
	_tmp1_ = self->priv->map;
	gee_multi_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_MULTI_MAP, GeeMultiMap), name, _tmp0_);
}

static void
geary_generic_capabilities_class_init (GearyGenericCapabilitiesClass * klass,
                                       gpointer klass_data)
{
	geary_generic_capabilities_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyGenericCapabilities_private_offset);
	((GearyGenericCapabilitiesClass *) klass)->to_string = (gchar* (*) (GearyGenericCapabilities*)) geary_generic_capabilities_real_to_string;
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_generic_capabilities_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_generic_capabilities_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_generic_capabilities_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_GENERIC_CAPABILITIES_NAME_SEPARATOR_PROPERTY, geary_generic_capabilities_properties[GEARY_GENERIC_CAPABILITIES_NAME_SEPARATOR_PROPERTY] = g_param_spec_string ("name-separator", "name-separator", "name-separator", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_GENERIC_CAPABILITIES_VALUE_SEPARATOR_PROPERTY, geary_generic_capabilities_properties[GEARY_GENERIC_CAPABILITIES_VALUE_SEPARATOR_PROPERTY] = g_param_spec_string ("value-separator", "value-separator", "value-separator", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
geary_generic_capabilities_instance_init (GearyGenericCapabilities * self,
                                          gpointer klass)
{
	GeeHashMultiMap* _tmp0_;
	self->priv = geary_generic_capabilities_get_instance_private (self);
	_tmp0_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _geary_ascii_nullable_stri_hash_gee_hash_data_func, NULL, NULL, _geary_ascii_nullable_stri_equal_gee_equal_data_func, NULL, NULL, _geary_ascii_nullable_stri_hash_gee_hash_data_func, NULL, NULL, _geary_ascii_nullable_stri_equal_gee_equal_data_func, NULL, NULL);
	self->priv->map = _tmp0_;
}

static void
geary_generic_capabilities_finalize (GObject * obj)
{
	GearyGenericCapabilities * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_TYPE_GENERIC_CAPABILITIES, GearyGenericCapabilities);
	_g_free0 (self->priv->_name_separator);
	_g_free0 (self->priv->_value_separator);
	_g_object_unref0 (self->priv->map);
	G_OBJECT_CLASS (geary_generic_capabilities_parent_class)->finalize (obj);
}

/**
 * Stores a map of name-values pairs as ''ASCII'' (i.e. 7-bit) strings.
 */
 G_GNUC_NO_INLINE static GType
geary_generic_capabilities_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyGenericCapabilitiesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_generic_capabilities_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyGenericCapabilities), 0, (GInstanceInitFunc) geary_generic_capabilities_instance_init, NULL };
	GType geary_generic_capabilities_type_id;
	geary_generic_capabilities_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "GearyGenericCapabilities", &g_define_type_info, 0);
	GearyGenericCapabilities_private_offset = g_type_add_instance_private (geary_generic_capabilities_type_id, sizeof (GearyGenericCapabilitiesPrivate));
	return geary_generic_capabilities_type_id;
}

GType
geary_generic_capabilities_get_type (void)
{
	static gsize geary_generic_capabilities_type_id__once = 0;
	if (g_once_init_enter (&geary_generic_capabilities_type_id__once)) {
		GType geary_generic_capabilities_type_id;
		geary_generic_capabilities_type_id = geary_generic_capabilities_get_type_once ();
		g_once_init_leave (&geary_generic_capabilities_type_id__once, geary_generic_capabilities_type_id);
	}
	return geary_generic_capabilities_type_id__once;
}

static void
_vala_geary_generic_capabilities_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec)
{
	GearyGenericCapabilities * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_TYPE_GENERIC_CAPABILITIES, GearyGenericCapabilities);
	switch (property_id) {
		case GEARY_GENERIC_CAPABILITIES_NAME_SEPARATOR_PROPERTY:
		g_value_set_string (value, geary_generic_capabilities_get_name_separator (self));
		break;
		case GEARY_GENERIC_CAPABILITIES_VALUE_SEPARATOR_PROPERTY:
		g_value_set_string (value, geary_generic_capabilities_get_value_separator (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_generic_capabilities_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec)
{
	GearyGenericCapabilities * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_TYPE_GENERIC_CAPABILITIES, GearyGenericCapabilities);
	switch (property_id) {
		case GEARY_GENERIC_CAPABILITIES_NAME_SEPARATOR_PROPERTY:
		geary_generic_capabilities_set_name_separator (self, g_value_get_string (value));
		break;
		case GEARY_GENERIC_CAPABILITIES_VALUE_SEPARATOR_PROPERTY:
		geary_generic_capabilities_set_value_separator (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

