/* smtp-greeting.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from smtp-greeting.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))

struct _GearySmtpGreetingPrivate {
	gchar* _domain;
	GearySmtpGreetingServerFlavor _flavor;
	gchar* _message;
};

static gint GearySmtpGreeting_private_offset;
static gpointer geary_smtp_greeting_parent_class = NULL;

static void geary_smtp_greeting_set_domain (GearySmtpGreeting* self,
                                     const gchar* value);
static void geary_smtp_greeting_set_flavor (GearySmtpGreeting* self,
                                     GearySmtpGreetingServerFlavor value);
static void geary_smtp_greeting_set_message (GearySmtpGreeting* self,
                                      const gchar* value);
static void geary_smtp_greeting_finalize (GearySmtpResponse * obj);
static GType geary_smtp_greeting_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
geary_smtp_greeting_get_instance_private (GearySmtpGreeting* self)
{
	return G_STRUCT_MEMBER_P (self, GearySmtpGreeting_private_offset);
}

/**
         * Returns an empty string if UNSPECIFIED.
         */
gchar*
geary_smtp_greeting_server_flavor_serialize (GearySmtpGreetingServerFlavor self)
{
	gchar* result;
	switch (self) {
		case GEARY_SMTP_GREETING_SERVER_FLAVOR_SMTP:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("SMTP");
			result = _tmp0_;
			return result;
		}
		case GEARY_SMTP_GREETING_SERVER_FLAVOR_ESMTP:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("ESMTP");
			result = _tmp1_;
			return result;
		}
		default:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("");
			result = _tmp2_;
			return result;
		}
	}
}

GearySmtpGreetingServerFlavor
geary_smtp_greeting_server_flavor_deserialize (const gchar* str)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	GearySmtpGreetingServerFlavor result;
	g_return_val_if_fail (str != NULL, 0);
	_tmp0_ = geary_ascii_strup (str);
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	g_free (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("SMTP")))) {
		switch (0) {
			default:
			{
				result = GEARY_SMTP_GREETING_SERVER_FLAVOR_SMTP;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("ESMTP")))) {
		switch (0) {
			default:
			{
				result = GEARY_SMTP_GREETING_SERVER_FLAVOR_ESMTP;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = GEARY_SMTP_GREETING_SERVER_FLAVOR_UNSPECIFIED;
				return result;
			}
		}
	}
}

 G_GNUC_NO_INLINE static GType
geary_smtp_greeting_server_flavor_get_type_once (void)
{
	static const GEnumValue values[] = {{GEARY_SMTP_GREETING_SERVER_FLAVOR_SMTP, "GEARY_SMTP_GREETING_SERVER_FLAVOR_SMTP", "smtp"}, {GEARY_SMTP_GREETING_SERVER_FLAVOR_ESMTP, "GEARY_SMTP_GREETING_SERVER_FLAVOR_ESMTP", "esmtp"}, {GEARY_SMTP_GREETING_SERVER_FLAVOR_UNSPECIFIED, "GEARY_SMTP_GREETING_SERVER_FLAVOR_UNSPECIFIED", "unspecified"}, {0, NULL, NULL}};
	GType geary_smtp_greeting_server_flavor_type_id;
	geary_smtp_greeting_server_flavor_type_id = g_enum_register_static ("GearySmtpGreetingServerFlavor", values);
	return geary_smtp_greeting_server_flavor_type_id;
}

GType
geary_smtp_greeting_server_flavor_get_type (void)
{
	static gsize geary_smtp_greeting_server_flavor_type_id__once = 0;
	if (g_once_init_enter (&geary_smtp_greeting_server_flavor_type_id__once)) {
		GType geary_smtp_greeting_server_flavor_type_id;
		geary_smtp_greeting_server_flavor_type_id = geary_smtp_greeting_server_flavor_get_type_once ();
		g_once_init_leave (&geary_smtp_greeting_server_flavor_type_id__once, geary_smtp_greeting_server_flavor_type_id);
	}
	return geary_smtp_greeting_server_flavor_type_id__once;
}

const gchar*
geary_smtp_greeting_get_domain (GearySmtpGreeting* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (GEARY_SMTP_IS_GREETING (self), NULL);
	_tmp0_ = self->priv->_domain;
	result = _tmp0_;
	return result;
}

static void
geary_smtp_greeting_set_domain (GearySmtpGreeting* self,
                                const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (GEARY_SMTP_IS_GREETING (self));
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_domain);
	self->priv->_domain = _tmp0_;
}

GearySmtpGreetingServerFlavor
geary_smtp_greeting_get_flavor (GearySmtpGreeting* self)
{
	GearySmtpGreetingServerFlavor result;
	g_return_val_if_fail (GEARY_SMTP_IS_GREETING (self), 0);
	result = self->priv->_flavor;
	return result;
}

static void
geary_smtp_greeting_set_flavor (GearySmtpGreeting* self,
                                GearySmtpGreetingServerFlavor value)
{
	g_return_if_fail (GEARY_SMTP_IS_GREETING (self));
	self->priv->_flavor = value;
}

const gchar*
geary_smtp_greeting_get_message (GearySmtpGreeting* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (GEARY_SMTP_IS_GREETING (self), NULL);
	_tmp0_ = self->priv->_message;
	result = _tmp0_;
	return result;
}

static void
geary_smtp_greeting_set_message (GearySmtpGreeting* self,
                                 const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (GEARY_SMTP_IS_GREETING (self));
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_message);
	self->priv->_message = _tmp0_;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

GearySmtpGreeting*
geary_smtp_greeting_construct (GType object_type,
                               GeeList* lines)
{
	GearySmtpGreeting* self = NULL;
	GearySmtpResponseLine* _tmp0_;
	GearySmtpResponseLine* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (lines, GEE_TYPE_LIST), NULL);
	self = (GearySmtpGreeting*) geary_smtp_response_construct (object_type, lines);
	_tmp0_ = geary_smtp_response_get_first_line (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_SMTP_TYPE_RESPONSE, GearySmtpResponse));
	_tmp1_ = _tmp0_;
	_tmp2_ = geary_smtp_response_line_get_explanation (_tmp1_);
	_tmp3_ = _tmp2_;
	if (!geary_string_is_empty (_tmp3_)) {
		gchar** tokens = NULL;
		GearySmtpResponseLine* _tmp4_;
		GearySmtpResponseLine* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar** _tmp10_;
		gchar** _tmp11_;
		gchar** _tmp12_;
		gint _tmp12__length1;
		gint tokens_length1;
		gint _tokens_size_;
		gint length = 0;
		gchar** _tmp13_;
		gint _tmp13__length1;
		gint index = 0;
		_tmp4_ = geary_smtp_response_get_first_line (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_SMTP_TYPE_RESPONSE, GearySmtpResponse));
		_tmp5_ = _tmp4_;
		_tmp6_ = geary_smtp_response_line_get_explanation (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = string_substring (_tmp7_, (glong) (GEARY_SMTP_RESPONSE_CODE_STRLEN + 1), (glong) -1);
		_tmp9_ = _tmp8_;
		_tmp11_ = _tmp10_ = g_strsplit (_tmp9_, " ", 0);
		_tmp12_ = _tmp11_;
		_tmp12__length1 = _vala_array_length (_tmp10_);
		_g_free0 (_tmp9_);
		tokens = _tmp12_;
		tokens_length1 = _tmp12__length1;
		_tokens_size_ = tokens_length1;
		_tmp13_ = tokens;
		_tmp13__length1 = tokens_length1;
		length = _tmp13__length1;
		index = 0;
		if (index < length) {
			gchar** _tmp14_;
			gint _tmp14__length1;
			gint _tmp15_;
			const gchar* _tmp16_;
			_tmp14_ = tokens;
			_tmp14__length1 = tokens_length1;
			_tmp15_ = index;
			index = _tmp15_ + 1;
			_tmp16_ = _tmp14_[_tmp15_];
			geary_smtp_greeting_set_domain (self, _tmp16_);
		}
		if (index < length) {
			gchar* f = NULL;
			gchar** _tmp17_;
			gint _tmp17__length1;
			gint _tmp18_;
			const gchar* _tmp19_;
			gchar* _tmp20_;
			const gchar* _tmp21_;
			GearySmtpGreetingServerFlavor _tmp22_;
			_tmp17_ = tokens;
			_tmp17__length1 = tokens_length1;
			_tmp18_ = index;
			index = _tmp18_ + 1;
			_tmp19_ = _tmp17_[_tmp18_];
			_tmp20_ = g_strdup (_tmp19_);
			f = _tmp20_;
			_tmp21_ = f;
			geary_smtp_greeting_set_flavor (self, geary_smtp_greeting_server_flavor_deserialize (_tmp21_));
			_tmp22_ = self->priv->_flavor;
			if (_tmp22_ == GEARY_SMTP_GREETING_SERVER_FLAVOR_UNSPECIFIED) {
				const gchar* _tmp23_;
				_tmp23_ = f;
				geary_smtp_greeting_set_message (self, _tmp23_);
			}
			_g_free0 (f);
		}
		while (TRUE) {
			const gchar* _tmp24_;
			if (!(index < length)) {
				break;
			}
			_tmp24_ = self->priv->_message;
			if (geary_string_is_empty (_tmp24_)) {
				gchar** _tmp25_;
				gint _tmp25__length1;
				gint _tmp26_;
				const gchar* _tmp27_;
				_tmp25_ = tokens;
				_tmp25__length1 = tokens_length1;
				_tmp26_ = index;
				index = _tmp26_ + 1;
				_tmp27_ = _tmp25_[_tmp26_];
				geary_smtp_greeting_set_message (self, _tmp27_);
			} else {
				const gchar* _tmp28_;
				gchar** _tmp29_;
				gint _tmp29__length1;
				gint _tmp30_;
				const gchar* _tmp31_;
				gchar* _tmp32_;
				gchar* _tmp33_;
				gchar* _tmp34_;
				gchar* _tmp35_;
				_tmp28_ = self->priv->_message;
				_tmp29_ = tokens;
				_tmp29__length1 = tokens_length1;
				_tmp30_ = index;
				index = _tmp30_ + 1;
				_tmp31_ = _tmp29_[_tmp30_];
				_tmp32_ = g_strconcat (" ", _tmp31_, NULL);
				_tmp33_ = _tmp32_;
				_tmp34_ = g_strconcat (_tmp28_, _tmp33_, NULL);
				_tmp35_ = _tmp34_;
				geary_smtp_greeting_set_message (self, _tmp35_);
				_g_free0 (_tmp35_);
				_g_free0 (_tmp33_);
			}
		}
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
	}
	return self;
}

GearySmtpGreeting*
geary_smtp_greeting_new (GeeList* lines)
{
	return geary_smtp_greeting_construct (GEARY_SMTP_TYPE_GREETING, lines);
}

static void
geary_smtp_greeting_class_init (GearySmtpGreetingClass * klass,
                                gpointer klass_data)
{
	geary_smtp_greeting_parent_class = g_type_class_peek_parent (klass);
	((GearySmtpResponseClass *) klass)->finalize = geary_smtp_greeting_finalize;
	g_type_class_adjust_private_offset (klass, &GearySmtpGreeting_private_offset);
}

static void
geary_smtp_greeting_instance_init (GearySmtpGreeting * self,
                                   gpointer klass)
{
	self->priv = geary_smtp_greeting_get_instance_private (self);
	self->priv->_domain = NULL;
	self->priv->_flavor = GEARY_SMTP_GREETING_SERVER_FLAVOR_UNSPECIFIED;
	self->priv->_message = NULL;
}

static void
geary_smtp_greeting_finalize (GearySmtpResponse * obj)
{
	GearySmtpGreeting * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_SMTP_TYPE_GREETING, GearySmtpGreeting);
	_g_free0 (self->priv->_domain);
	_g_free0 (self->priv->_message);
	GEARY_SMTP_RESPONSE_CLASS (geary_smtp_greeting_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
geary_smtp_greeting_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearySmtpGreetingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_smtp_greeting_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearySmtpGreeting), 0, (GInstanceInitFunc) geary_smtp_greeting_instance_init, NULL };
	GType geary_smtp_greeting_type_id;
	geary_smtp_greeting_type_id = g_type_register_static (GEARY_SMTP_TYPE_RESPONSE, "GearySmtpGreeting", &g_define_type_info, 0);
	GearySmtpGreeting_private_offset = g_type_add_instance_private (geary_smtp_greeting_type_id, sizeof (GearySmtpGreetingPrivate));
	return geary_smtp_greeting_type_id;
}

GType
geary_smtp_greeting_get_type (void)
{
	static gsize geary_smtp_greeting_type_id__once = 0;
	if (g_once_init_enter (&geary_smtp_greeting_type_id__once)) {
		GType geary_smtp_greeting_type_id;
		geary_smtp_greeting_type_id = geary_smtp_greeting_get_type_once ();
		g_once_init_leave (&geary_smtp_greeting_type_id__once, geary_smtp_greeting_type_id);
	}
	return geary_smtp_greeting_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

