/* imap-flags.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from imap-flags.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GEARY_IMAP_FLAGS_0_PROPERTY,
	GEARY_IMAP_FLAGS_SIZE_PROPERTY,
	GEARY_IMAP_FLAGS_NUM_PROPERTIES
};
static GParamSpec* geary_imap_flags_properties[GEARY_IMAP_FLAGS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block31Data Block31Data;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _Block31Data {
	int _ref_count_;
	GearyImapFlags* self;
	GearyImapFlags* other;
};

static gpointer geary_imap_flags_parent_class = NULL;
static GearyImapMessageDataIface * geary_imap_flags_geary_imap_message_data_parent_iface = NULL;
static GeeHashableIface * geary_imap_flags_gee_hashable_parent_iface = NULL;

static gchar* geary_imap_flags_real_serialize (GearyImapFlags* self);
static GearyImapParameter* geary_imap_flags_real_to_parameter (GearyImapFlags* self);
static gboolean geary_imap_flags_real_equal_to (GeeHashable* base,
                                         GearyImapFlags* other);
static Block31Data* block31_data_ref (Block31Data* _data31_);
static void block31_data_unref (void * _userdata_);
static gboolean __lambda41_ (Block31Data* _data31_,
                      GearyImapFlag* f);
static gboolean ___lambda41__gee_predicate (gconstpointer g,
                                     gpointer self);
static gchar* geary_imap_flags_real_to_string (GearyMessageDataAbstractMessageData* base);
static guint geary_imap_flags_real_hash (GeeHashable* base);
static void geary_imap_flags_finalize (GObject * obj);
static GType geary_imap_flags_get_type_once (void);
static void _vala_geary_imap_flags_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);

gint
geary_imap_flags_get_size (GearyImapFlags* self)
{
	gint result;
	GeeSet* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (GEARY_IMAP_IS_FLAGS (self), 0);
	_tmp0_ = self->list;
	_tmp1_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

GearyImapFlags*
geary_imap_flags_construct (GType object_type,
                            GeeCollection* flags)
{
	GearyImapFlags * self = NULL;
	GeeHashSet* _tmp0_;
	GeeSet* _tmp1_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (flags, GEE_TYPE_COLLECTION), NULL);
	self = (GearyImapFlags*) geary_message_data_abstract_message_data_construct (object_type);
	_tmp0_ = gee_hash_set_new (GEARY_IMAP_TYPE_FLAG, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->list);
	self->list = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_SET, GeeSet);
	_tmp1_ = self->list;
	gee_collection_add_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection), flags);
	return self;
}

gboolean
geary_imap_flags_contains (GearyImapFlags* self,
                           GearyImapFlag* flag)
{
	GeeSet* _tmp0_;
	gboolean result;
	g_return_val_if_fail (GEARY_IMAP_IS_FLAGS (self), FALSE);
	g_return_val_if_fail (GEARY_IMAP_IS_FLAG (flag), FALSE);
	_tmp0_ = self->list;
	result = gee_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection), flag);
	return result;
}

GeeSet*
geary_imap_flags_get_all (GearyImapFlags* self)
{
	GeeSet* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	GeeSet* result;
	g_return_val_if_fail (GEARY_IMAP_IS_FLAGS (self), NULL);
	_tmp0_ = self->list;
	_tmp1_ = gee_set_get_read_only_view (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

/**
     * Returns the flags in serialized form, which is each flag separated by a space (legal in
     * IMAP, as flags must be atoms and atoms prohibit spaces).
     */
static gchar*
geary_imap_flags_real_serialize (GearyImapFlags* self)
{
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = geary_message_data_abstract_message_data_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_MESSAGE_DATA_TYPE_ABSTRACT_MESSAGE_DATA, GearyMessageDataAbstractMessageData));
	result = _tmp0_;
	return result;
}

gchar*
geary_imap_flags_serialize (GearyImapFlags* self)
{
	GearyImapFlagsClass* _klass_;
	g_return_val_if_fail (GEARY_IMAP_IS_FLAGS (self), NULL);
	_klass_ = GEARY_IMAP_FLAGS_GET_CLASS (self);
	if (_klass_->serialize) {
		return _klass_->serialize (self);
	}
	return NULL;
}

/**
     * Returns a {@link ListParameter} representation of these flags.
     *
     * If empty, this returns an empty ListParameter.
     */
static GearyImapParameter*
geary_imap_flags_real_to_parameter (GearyImapFlags* self)
{
	GearyImapListParameter* listp = NULL;
	GearyImapListParameter* _tmp0_;
	GError* _inner_error0_ = NULL;
	GearyImapParameter* result;
	_tmp0_ = geary_imap_list_parameter_new ();
	listp = _tmp0_;
	{
		GeeIterator* _flag_it = NULL;
		GeeSet* _tmp1_;
		GeeIterator* _tmp2_;
		_tmp1_ = self->list;
		_tmp2_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ITERABLE, GeeIterable));
		_flag_it = _tmp2_;
		while (TRUE) {
			GeeIterator* _tmp3_;
			GearyImapFlag* flag = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			_tmp3_ = _flag_it;
			if (!gee_iterator_next (_tmp3_)) {
				break;
			}
			_tmp4_ = _flag_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			flag = (GearyImapFlag*) _tmp5_;
			{
				GearyImapStringParameter* _tmp6_ = NULL;
				GearyImapFlag* _tmp7_;
				GearyImapStringParameter* _tmp8_;
				GearyImapListParameter* _tmp9_;
				_tmp7_ = flag;
				_tmp8_ = geary_imap_flag_to_parameter (_tmp7_, &_inner_error0_);
				_tmp6_ = _tmp8_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
						goto __catch0_geary_imap_error;
					}
					_g_object_unref0 (flag);
					_g_object_unref0 (_flag_it);
					_g_object_unref0 (listp);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
				_tmp9_ = listp;
				geary_imap_list_parameter_add (_tmp9_, G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
				_g_object_unref0 (_tmp6_);
			}
			goto __finally0;
			__catch0_geary_imap_error:
			{
				GError* ierr = NULL;
				GearyImapFlag* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				GError* _tmp13_;
				const gchar* _tmp14_;
				ierr = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp10_ = flag;
				_tmp11_ = geary_imap_flag_to_string (_tmp10_);
				_tmp12_ = _tmp11_;
				_tmp13_ = ierr;
				_tmp14_ = _tmp13_->message;
				g_message ("imap-flags.vala:50: Unable to parameterize flag \"%s\": %s", _tmp12_, _tmp14_);
				_g_free0 (_tmp12_);
				_g_error_free0 (ierr);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (flag);
				_g_object_unref0 (_flag_it);
				_g_object_unref0 (listp);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_g_object_unref0 (flag);
		}
		_g_object_unref0 (_flag_it);
	}
	result = G_TYPE_CHECK_INSTANCE_CAST (listp, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter);
	return result;
}

GearyImapParameter*
geary_imap_flags_to_parameter (GearyImapFlags* self)
{
	GearyImapFlagsClass* _klass_;
	g_return_val_if_fail (GEARY_IMAP_IS_FLAGS (self), NULL);
	_klass_ = GEARY_IMAP_FLAGS_GET_CLASS (self);
	if (_klass_->to_parameter) {
		return _klass_->to_parameter (self);
	}
	return NULL;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block31Data*
block31_data_ref (Block31Data* _data31_)
{
	g_atomic_int_inc (&_data31_->_ref_count_);
	return _data31_;
}

static void
block31_data_unref (void * _userdata_)
{
	Block31Data* _data31_;
	_data31_ = (Block31Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data31_->_ref_count_)) {
		GearyImapFlags* self;
		self = _data31_->self;
		_g_object_unref0 (_data31_->other);
		_g_object_unref0 (self);
		g_slice_free (Block31Data, _data31_);
	}
}

static gboolean
__lambda41_ (Block31Data* _data31_,
             GearyImapFlag* f)
{
	GearyImapFlags* self;
	gboolean result;
	self = _data31_->self;
	g_return_val_if_fail (GEARY_IMAP_IS_FLAG (f), FALSE);
	result = geary_imap_flags_contains (_data31_->other, f);
	return result;
}

static gboolean
___lambda41__gee_predicate (gconstpointer g,
                            gpointer self)
{
	gboolean result;
	result = __lambda41_ (self, (GearyImapFlag*) g);
	return result;
}

static gboolean
geary_imap_flags_real_equal_to (GeeHashable* base,
                                GearyImapFlags* other)
{
	GearyImapFlags * self;
	Block31Data* _data31_;
	GearyImapFlags* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GeeSet* _tmp5_;
	GearyIterable* _tmp6_;
	GearyIterable* _tmp7_;
	gboolean _tmp8_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_TYPE_FLAGS, GearyImapFlags);
	g_return_val_if_fail (GEARY_IMAP_IS_FLAGS (other), FALSE);
	_data31_ = g_slice_new0 (Block31Data);
	_data31_->_ref_count_ = 1;
	_data31_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (other);
	_g_object_unref0 (_data31_->other);
	_data31_->other = _tmp0_;
	if (self == _data31_->other) {
		result = TRUE;
		block31_data_unref (_data31_);
		_data31_ = NULL;
		return result;
	}
	_tmp1_ = geary_imap_flags_get_size (_data31_->other);
	_tmp2_ = _tmp1_;
	_tmp3_ = geary_imap_flags_get_size (self);
	_tmp4_ = _tmp3_;
	if (_tmp2_ != _tmp4_) {
		result = FALSE;
		block31_data_unref (_data31_);
		_data31_ = NULL;
		return result;
	}
	_tmp5_ = self->list;
	_tmp6_ = geary_traverse (GEARY_IMAP_TYPE_FLAG, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_ITERABLE, GeeIterable));
	_tmp7_ = _tmp6_;
	_tmp8_ = geary_iterable_all (_tmp7_, ___lambda41__gee_predicate, block31_data_ref (_data31_), block31_data_unref);
	_g_object_unref0 (_tmp7_);
	result = _tmp8_;
	block31_data_unref (_data31_);
	_data31_ = NULL;
	return result;
}

static gchar*
geary_imap_flags_real_to_string (GearyMessageDataAbstractMessageData* base)
{
	GearyImapFlags * self;
	GString* builder = NULL;
	GString* _tmp0_;
	GString* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_TYPE_FLAGS, GearyImapFlags);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	{
		GeeIterator* _flag_it = NULL;
		GeeSet* _tmp1_;
		GeeIterator* _tmp2_;
		_tmp1_ = self->list;
		_tmp2_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ITERABLE, GeeIterable));
		_flag_it = _tmp2_;
		while (TRUE) {
			GeeIterator* _tmp3_;
			GearyImapFlag* flag = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			GString* _tmp6_;
			const gchar* _tmp7_;
			GString* _tmp9_;
			GearyImapFlag* _tmp10_;
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			_tmp3_ = _flag_it;
			if (!gee_iterator_next (_tmp3_)) {
				break;
			}
			_tmp4_ = _flag_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			flag = (GearyImapFlag*) _tmp5_;
			_tmp6_ = builder;
			_tmp7_ = _tmp6_->str;
			if (!geary_string_is_empty (_tmp7_)) {
				GString* _tmp8_;
				_tmp8_ = builder;
				g_string_append_c (_tmp8_, ' ');
			}
			_tmp9_ = builder;
			_tmp10_ = flag;
			_tmp11_ = geary_imap_flag_get_value (_tmp10_);
			_tmp12_ = _tmp11_;
			g_string_append (_tmp9_, _tmp12_);
			_g_object_unref0 (flag);
		}
		_g_object_unref0 (_flag_it);
	}
	_tmp13_ = builder;
	_tmp14_ = _tmp13_->str;
	_tmp15_ = g_strdup (_tmp14_);
	result = _tmp15_;
	_g_string_free0 (builder);
	return result;
}

static guint
geary_imap_flags_real_hash (GeeHashable* base)
{
	GearyImapFlags * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	guint _tmp2_;
	guint result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_TYPE_FLAGS, GearyImapFlags);
	_tmp0_ = geary_message_data_abstract_message_data_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_MESSAGE_DATA_TYPE_ABSTRACT_MESSAGE_DATA, GearyMessageDataAbstractMessageData));
	_tmp1_ = _tmp0_;
	_tmp2_ = geary_ascii_stri_hash (_tmp1_);
	_g_free0 (_tmp1_);
	result = _tmp2_;
	return result;
}

static void
geary_imap_flags_class_init (GearyImapFlagsClass * klass,
                             gpointer klass_data)
{
	geary_imap_flags_parent_class = g_type_class_peek_parent (klass);
	((GearyImapFlagsClass *) klass)->serialize = (gchar* (*) (GearyImapFlags*)) geary_imap_flags_real_serialize;
	((GearyImapFlagsClass *) klass)->to_parameter = (GearyImapParameter* (*) (GearyImapFlags*)) geary_imap_flags_real_to_parameter;
	((GearyMessageDataAbstractMessageDataClass *) klass)->to_string = (gchar* (*) (GearyMessageDataAbstractMessageData*)) geary_imap_flags_real_to_string;
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_imap_flags_get_property;
	G_OBJECT_CLASS (klass)->finalize = geary_imap_flags_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_FLAGS_SIZE_PROPERTY, geary_imap_flags_properties[GEARY_IMAP_FLAGS_SIZE_PROPERTY] = g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
geary_imap_flags_geary_imap_message_data_interface_init (GearyImapMessageDataIface * iface,
                                                         gpointer iface_data)
{
	geary_imap_flags_geary_imap_message_data_parent_iface = g_type_interface_peek_parent (iface);
}

static void
geary_imap_flags_gee_hashable_interface_init (GeeHashableIface * iface,
                                              gpointer iface_data)
{
	geary_imap_flags_gee_hashable_parent_iface = g_type_interface_peek_parent (iface);
	iface->equal_to = (gboolean (*) (GeeHashable*, gconstpointer)) geary_imap_flags_real_equal_to;
	iface->hash = (guint (*) (GeeHashable*)) geary_imap_flags_real_hash;
}

static void
geary_imap_flags_instance_init (GearyImapFlags * self,
                                gpointer klass)
{
}

static void
geary_imap_flags_finalize (GObject * obj)
{
	GearyImapFlags * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_IMAP_TYPE_FLAGS, GearyImapFlags);
	_g_object_unref0 (self->list);
	G_OBJECT_CLASS (geary_imap_flags_parent_class)->finalize (obj);
}

/**
 * A generic collection of {@link Flags}.
 */
 G_GNUC_NO_INLINE static GType
geary_imap_flags_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyImapFlagsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_imap_flags_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyImapFlags), 0, (GInstanceInitFunc) geary_imap_flags_instance_init, NULL };
	static const GInterfaceInfo geary_imap_message_data_info = { (GInterfaceInitFunc) geary_imap_flags_geary_imap_message_data_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo gee_hashable_info = { (GInterfaceInitFunc) geary_imap_flags_gee_hashable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType geary_imap_flags_type_id;
	geary_imap_flags_type_id = g_type_register_static (GEARY_MESSAGE_DATA_TYPE_ABSTRACT_MESSAGE_DATA, "GearyImapFlags", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	g_type_add_interface_static (geary_imap_flags_type_id, GEARY_IMAP_TYPE_MESSAGE_DATA, &geary_imap_message_data_info);
	g_type_add_interface_static (geary_imap_flags_type_id, GEE_TYPE_HASHABLE, &gee_hashable_info);
	return geary_imap_flags_type_id;
}

GType
geary_imap_flags_get_type (void)
{
	static gsize geary_imap_flags_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_flags_type_id__once)) {
		GType geary_imap_flags_type_id;
		geary_imap_flags_type_id = geary_imap_flags_get_type_once ();
		g_once_init_leave (&geary_imap_flags_type_id__once, geary_imap_flags_type_id);
	}
	return geary_imap_flags_type_id__once;
}

static void
_vala_geary_imap_flags_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	GearyImapFlags * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_TYPE_FLAGS, GearyImapFlags);
	switch (property_id) {
		case GEARY_IMAP_FLAGS_SIZE_PROPERTY:
		g_value_set_int (value, geary_imap_flags_get_size (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

