/* composer-web-view.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from composer-web-view.vala, do not modify */

/*
 * Copyright 2016 Software Freedom Conservancy Inc.
 * Copyright 2016 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-client-46.0.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <webkit2/webkit2.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gio/gio.h>
#include "geary-engine.h"
#include <gee.h>
#include <float.h>
#include <math.h>

#define COMPOSER_WEB_VIEW_HTML_PRE "<html><body class=\"%s\">"
#define COMPOSER_WEB_VIEW_HTML_POST "</body></html>"
#define COMPOSER_WEB_VIEW_BODY_PRE "\n<div id=\"%s\" dir=\"auto\">"
#define COMPOSER_WEB_VIEW_BODY_POST "</div>\n" \
"<div id=\"%s\" class=\"geary-no-display\" dir=\"auto\"></div>\n"
#define COMPOSER_WEB_VIEW_QUOTE "\n<div id=\"%s\" dir=\"auto\"><br />%s</div>\n"
#define COMPOSER_WEB_VIEW_CURSOR "<div><span id=\"cursormarker\"></span><br /></div>"
#define COMPOSER_WEB_VIEW_SPACER "<div><br /></div>"
#define COMPOSER_WEB_VIEW_CURSOR_CONTEXT_CHANGED "cursor_context_changed"
#define COMPOSER_WEB_VIEW_DRAG_DROP_RECEIVED "drag_drop_received"
#define COMPOSER_WEB_VIEW_EDIT_CONTEXT_LINK_MASK ((guint) (1 << 0))
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	COMPOSER_WEB_VIEW_0_PROPERTY,
	COMPOSER_WEB_VIEW_IS_EMPTY_PROPERTY,
	COMPOSER_WEB_VIEW_IS_RICH_TEXT_PROPERTY,
	COMPOSER_WEB_VIEW_NUM_PROPERTIES
};
static GParamSpec* composer_web_view_properties[COMPOSER_WEB_VIEW_NUM_PROPERTIES];
#define _webkit_user_style_sheet_unref0(var) ((var == NULL) ? NULL : (var = (webkit_user_style_sheet_unref (var), NULL)))
#define _webkit_user_script_unref0(var) ((var == NULL) ? NULL : (var = (webkit_user_script_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _util_js_callable_unref0(var) ((var == NULL) ? NULL : (var = (util_js_callable_unref (var), NULL)))
typedef struct _ComposerWebViewGetHtmlForDraftData ComposerWebViewGetHtmlForDraftData;
typedef struct _ComposerWebViewSaveSelectionData ComposerWebViewSaveSelectionData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ComposerWebViewContainsAttachmentKeywordsData ComposerWebViewContainsAttachmentKeywordsData;
typedef struct _ComposerWebViewCleanContentData ComposerWebViewCleanContentData;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _ComposerWebViewGetTextData ComposerWebViewGetTextData;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_dict_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_dict_unref (var), NULL)))
enum  {
	COMPOSER_WEB_VIEW_EDIT_CONTEXT_0_PROPERTY,
	COMPOSER_WEB_VIEW_EDIT_CONTEXT_IS_LINK_PROPERTY,
	COMPOSER_WEB_VIEW_EDIT_CONTEXT_LINK_URL_PROPERTY,
	COMPOSER_WEB_VIEW_EDIT_CONTEXT_FONT_FAMILY_PROPERTY,
	COMPOSER_WEB_VIEW_EDIT_CONTEXT_FONT_SIZE_PROPERTY,
	COMPOSER_WEB_VIEW_EDIT_CONTEXT_FONT_COLOR_PROPERTY,
	COMPOSER_WEB_VIEW_EDIT_CONTEXT_NUM_PROPERTIES
};
static GParamSpec* composer_web_view_edit_context_properties[COMPOSER_WEB_VIEW_EDIT_CONTEXT_NUM_PROPERTIES];
enum  {
	COMPOSER_WEB_VIEW_CURSOR_CONTEXT_CHANGED_SIGNAL,
	COMPOSER_WEB_VIEW_IMAGE_FILE_DROPPED_SIGNAL,
	COMPOSER_WEB_VIEW_NUM_SIGNALS
};
static guint composer_web_view_signals[COMPOSER_WEB_VIEW_NUM_SIGNALS] = {0};

struct _ComposerWebViewPrivate {
	gboolean _is_empty;
	gboolean _is_rich_text;
};

struct _ComposerWebViewGetHtmlForDraftData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ComposerWebView* self;
	gchar* result;
	gchar* _tmp0_;
	UtilJSCallable* _tmp1_;
	UtilJSCallable* _tmp2_;
	UtilJSCallable* _tmp3_;
	UtilJSCallable* _tmp4_;
	gpointer _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GError* _inner_error0_;
};

struct _ComposerWebViewSaveSelectionData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ComposerWebView* self;
	gchar* result;
	gchar* _tmp0_;
	UtilJSCallable* _tmp1_;
	UtilJSCallable* _tmp2_;
	gpointer _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GError* _inner_error0_;
};

struct _ComposerWebViewContainsAttachmentKeywordsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ComposerWebView* self;
	gchar* keyword_spec;
	gchar* subject;
	gboolean* result;
	gboolean* _tmp0_;
	UtilJSCallable* _tmp1_;
	UtilJSCallable* _tmp2_;
	UtilJSCallable* _tmp3_;
	UtilJSCallable* _tmp4_;
	UtilJSCallable* _tmp5_;
	UtilJSCallable* _tmp6_;
	gpointer _tmp7_;
	gboolean* _tmp8_;
	gboolean* _tmp9_;
	GError* err;
	GError* _tmp10_;
	const gchar* _tmp11_;
	gboolean _tmp12_;
	gboolean* _tmp13_;
	GError* _inner_error0_;
};

struct _ComposerWebViewCleanContentData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ComposerWebView* self;
	UtilJSCallable* _tmp0_;
	UtilJSCallable* _tmp1_;
};

struct _ComposerWebViewGetTextData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ComposerWebView* self;
	gchar* result;
	gchar* body_text;
	UtilJSCallable* _tmp0_;
	UtilJSCallable* _tmp1_;
	gpointer _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar** lines;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gint lines_length1;
	gint _lines_size_;
	GString* flowed;
	gint _tmp7_;
	gint _tmp8_;
	GString* _tmp9_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	gchar** line_collection;
	gint line_collection_length1;
	gint _line_collection_size_;
	gint line_it;
	gchar* _tmp11_;
	gchar* line;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gint quote_level;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* prefix;
	gchar* _tmp26_;
	gint max_breakable;
	const gchar* _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	gint max_unbreakable;
	const gchar* _tmp30_;
	gint _tmp31_;
	gint _tmp32_;
	gboolean _tmp33_;
	const gchar* _tmp34_;
	gint _tmp35_;
	gint _tmp36_;
	gint start_ind;
	gboolean _tmp37_;
	gboolean _tmp38_;
	const gchar* _tmp39_;
	const gchar* _tmp40_;
	const gchar* _tmp41_;
	gchar* _tmp42_;
	gint cut_ind;
	const gchar* _tmp43_;
	gint _tmp44_;
	gint _tmp45_;
	gchar* beg;
	const gchar* _tmp46_;
	gchar* _tmp47_;
	const gchar* _tmp48_;
	const gchar* _tmp49_;
	const gchar* _tmp50_;
	gint _tmp51_;
	gint _tmp52_;
	GString* _tmp53_;
	const gchar* _tmp54_;
	const gchar* _tmp55_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	gchar* _tmp58_;
	gchar* _tmp59_;
	gchar* _tmp60_;
	gchar* _tmp61_;
	const gchar* _tmp62_;
	const gchar* _tmp63_;
	gint _tmp64_;
	gint _tmp65_;
	gchar* _tmp66_;
	GString* _tmp67_;
	const gchar* _tmp68_;
	gchar* _tmp69_;
	GError* _inner_error0_;
};

struct _ComposerWebViewEditContextPrivate {
	gchar* _link_url;
	gchar* _font_family;
	guint _font_size;
	GdkRGBA _font_color;
	guint context;
};

static gint ComposerWebView_private_offset;
static gpointer composer_web_view_parent_class = NULL;
static WebKitUserStyleSheet* composer_web_view_app_style;
static WebKitUserStyleSheet* composer_web_view_app_style = NULL;
static WebKitUserScript* composer_web_view_app_script;
static WebKitUserScript* composer_web_view_app_script = NULL;
static gint ComposerWebViewEditContext_private_offset;
static gpointer composer_web_view_edit_context_parent_class = NULL;
static GeeHashMap* composer_web_view_edit_context_font_family_map;
static GeeHashMap* composer_web_view_edit_context_font_family_map = NULL;

static void composer_web_view_set_is_empty (ComposerWebView* self,
                                     gboolean value);
static void composer_web_view_set_is_rich_text (ComposerWebView* self,
                                         gboolean value);
static void g_cclosure_user_marshal_VOID__STRING_STRING_POINTER_INT (GClosure * closure,
                                                              GValue * return_value,
                                                              guint n_param_values,
                                                              const GValue * param_values,
                                                              gpointer invocation_hint,
                                                              gpointer marshal_data);
static void composer_web_view_on_cursor_context_changed (ComposerWebView* self,
                                                  GVariant* parameters);
static void _composer_web_view_on_cursor_context_changed_components_web_view_message_callback (GVariant* parameters,
                                                                                        gpointer self);
static void composer_web_view_on_drag_drop_received (ComposerWebView* self,
                                              GVariant* parameters);
static void _composer_web_view_on_drag_drop_received_components_web_view_message_callback (GVariant* parameters,
                                                                                    gpointer self);
static void __lambda172_ (ComposerWebView* self,
                   gboolean can_undo,
                   gboolean can_redo);
static void ___lambda172__components_web_view_command_stack_changed (ComponentsWebView* _sender,
                                                              gboolean can_undo,
                                                              gboolean can_redo,
                                                              gpointer self);
static gchar* composer_web_view_get_internal_html (ComposerWebView* self,
                                            const gchar* body,
                                            const gchar* quote,
                                            gboolean top_posting,
                                            gboolean body_complete);
static void composer_web_view_get_html_for_draft_data_free (gpointer _data);
static gboolean composer_web_view_get_html_for_draft_co (ComposerWebViewGetHtmlForDraftData* _data_);
static void composer_web_view_get_html_for_draft_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_);
static void composer_web_view_save_selection_data_free (gpointer _data);
static gboolean composer_web_view_save_selection_co (ComposerWebViewSaveSelectionData* _data_);
static void composer_web_view_save_selection_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_);
static void __lambda173_ (ComposerWebView* self,
                   GtkClipboard* clipboard,
                   const gchar* text);
static void ___lambda173__gtk_clipboard_text_received_func (GtkClipboard* clipboard,
                                                     const gchar* text,
                                                     gpointer self);
static void composer_web_view_contains_attachment_keywords_data_free (gpointer _data);
static gboolean composer_web_view_contains_attachment_keywords_co (ComposerWebViewContainsAttachmentKeywordsData* _data_);
static gboolean* _bool_dup (gboolean* self);
static void composer_web_view_contains_attachment_keywords_ready (GObject* source_object,
                                                           GAsyncResult* _res_,
                                                           gpointer _user_data_);
static void composer_web_view_clean_content_data_free (gpointer _data);
static gboolean composer_web_view_clean_content_co (ComposerWebViewCleanContentData* _data_);
static void composer_web_view_get_text_data_free (gpointer _data);
static gboolean composer_web_view_get_text_co (ComposerWebViewGetTextData* _data_);
static void composer_web_view_get_text_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_);
static gchar* _variant_get14 (GVariant* value);
static void composer_web_view_edit_context_set_link_url (ComposerWebViewEditContext* self,
                                                  const gchar* value);
static void composer_web_view_edit_context_set_font_family (ComposerWebViewEditContext* self,
                                                     const gchar* value);
static void composer_web_view_edit_context_set_font_size (ComposerWebViewEditContext* self,
                                                   guint value);
static void composer_web_view_edit_context_set_font_color (ComposerWebViewEditContext* self,
                                                    GdkRGBA * value);
static gboolean _gdk_rgba_equal (const GdkRGBA * s1,
                          const GdkRGBA * s2);
static void composer_web_view_edit_context_finalize (GObject * obj);
static GType composer_web_view_edit_context_get_type_once (void);
static void _vala_composer_web_view_edit_context_get_property (GObject * object,
                                                        guint property_id,
                                                        GValue * value,
                                                        GParamSpec * pspec);
static void _vala_composer_web_view_edit_context_set_property (GObject * object,
                                                        guint property_id,
                                                        const GValue * value,
                                                        GParamSpec * pspec);
static void composer_web_view_finalize (GObject * obj);
static GType composer_web_view_get_type_once (void);
static void _vala_composer_web_view_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_composer_web_view_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static const gchar* COMPOSER_WEB_VIEW_EDIT_CONTEXT_SANS_FAMILY_NAMES[4] = {"sans", "arial", "trebuchet", "helvetica"};
static const gchar* COMPOSER_WEB_VIEW_EDIT_CONTEXT_SERIF_FAMILY_NAMES[3] = {"serif", "georgia", "times"};
static const gchar* COMPOSER_WEB_VIEW_EDIT_CONTEXT_MONO_FAMILY_NAMES[3] = {"monospace", "courier", "console"};

static inline gpointer
composer_web_view_get_instance_private (ComposerWebView* self)
{
	return G_STRUCT_MEMBER_P (self, ComposerWebView_private_offset);
}

void
composer_web_view_load_resources (GError** error)
{
	WebKitUserStyleSheet* _tmp0_ = NULL;
	WebKitUserStyleSheet* _tmp1_;
	WebKitUserStyleSheet* _tmp2_;
	WebKitUserScript* _tmp3_ = NULL;
	WebKitUserScript* _tmp4_;
	WebKitUserScript* _tmp5_;
	GError* _inner_error0_ = NULL;
	_tmp1_ = components_web_view_load_app_stylesheet ("composer-web-view.css", &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	_webkit_user_style_sheet_unref0 (composer_web_view_app_style);
	composer_web_view_app_style = _tmp2_;
	_tmp4_ = components_web_view_load_app_script ("composer-web-view.js", &_inner_error0_);
	_tmp3_ = _tmp4_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_webkit_user_style_sheet_unref0 (_tmp0_);
		return;
	}
	_tmp5_ = _tmp3_;
	_tmp3_ = NULL;
	_webkit_user_script_unref0 (composer_web_view_app_script);
	composer_web_view_app_script = _tmp5_;
	_webkit_user_script_unref0 (_tmp3_);
	_webkit_user_style_sheet_unref0 (_tmp0_);
}

gboolean
composer_web_view_get_is_empty (ComposerWebView* self)
{
	gboolean result;
	g_return_val_if_fail (COMPOSER_IS_WEB_VIEW (self), FALSE);
	result = self->priv->_is_empty;
	return result;
}

static void
composer_web_view_set_is_empty (ComposerWebView* self,
                                gboolean value)
{
	gboolean old_value;
	g_return_if_fail (COMPOSER_IS_WEB_VIEW (self));
	old_value = composer_web_view_get_is_empty (self);
	if (old_value != value) {
		self->priv->_is_empty = value;
		g_object_notify_by_pspec ((GObject *) self, composer_web_view_properties[COMPOSER_WEB_VIEW_IS_EMPTY_PROPERTY]);
	}
}

gboolean
composer_web_view_get_is_rich_text (ComposerWebView* self)
{
	gboolean result;
	g_return_val_if_fail (COMPOSER_IS_WEB_VIEW (self), FALSE);
	result = self->priv->_is_rich_text;
	return result;
}

static void
composer_web_view_set_is_rich_text (ComposerWebView* self,
                                    gboolean value)
{
	gboolean old_value;
	g_return_if_fail (COMPOSER_IS_WEB_VIEW (self));
	old_value = composer_web_view_get_is_rich_text (self);
	if (old_value != value) {
		self->priv->_is_rich_text = value;
		g_object_notify_by_pspec ((GObject *) self, composer_web_view_properties[COMPOSER_WEB_VIEW_IS_RICH_TEXT_PROPERTY]);
	}
}

static void
g_cclosure_user_marshal_VOID__STRING_STRING_POINTER_INT (GClosure * closure,
                                                         GValue * return_value,
                                                         guint n_param_values,
                                                         const GValue * param_values,
                                                         gpointer invocation_hint,
                                                         gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__STRING_STRING_POINTER_INT) (gpointer data1, const char* arg_1, const char* arg_2, gpointer arg_3, gint arg_4, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING_POINTER_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 5);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_STRING_POINTER_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), g_value_get_pointer (param_values + 3), g_value_get_int (param_values + 4), data2);
}

static void
_composer_web_view_on_cursor_context_changed_components_web_view_message_callback (GVariant* parameters,
                                                                                   gpointer self)
{
	composer_web_view_on_cursor_context_changed ((ComposerWebView*) self, parameters);
}

static void
_composer_web_view_on_drag_drop_received_components_web_view_message_callback (GVariant* parameters,
                                                                               gpointer self)
{
	composer_web_view_on_drag_drop_received ((ComposerWebView*) self, parameters);
}

static void
__lambda172_ (ComposerWebView* self,
              gboolean can_undo,
              gboolean can_redo)
{
	composer_web_view_set_is_empty (self, !can_undo);
}

static void
___lambda172__components_web_view_command_stack_changed (ComponentsWebView* _sender,
                                                         gboolean can_undo,
                                                         gboolean can_redo,
                                                         gpointer self)
{
	__lambda172_ ((ComposerWebView*) self, can_undo, can_redo);
}

ComposerWebView*
composer_web_view_construct (GType object_type,
                             ApplicationConfiguration* config)
{
	ComposerWebView * self = NULL;
	WebKitUserContentManager* _tmp0_;
	WebKitUserContentManager* _tmp1_;
	WebKitUserStyleSheet* _tmp2_;
	WebKitUserContentManager* _tmp3_;
	WebKitUserContentManager* _tmp4_;
	WebKitUserScript* _tmp5_;
	g_return_val_if_fail (APPLICATION_IS_CONFIGURATION (config), NULL);
	self = (ComposerWebView*) components_web_view_construct (object_type, config, NULL, NULL);
	gtk_widget_add_events (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), (gint) (GDK_KEY_PRESS_MASK | GDK_KEY_RELEASE_MASK));
	_tmp0_ = webkit_web_view_get_user_content_manager (G_TYPE_CHECK_INSTANCE_CAST (self, webkit_web_view_get_type (), WebKitWebView));
	_tmp1_ = _tmp0_;
	_tmp2_ = composer_web_view_app_style;
	webkit_user_content_manager_add_style_sheet (_tmp1_, _tmp2_);
	_tmp3_ = webkit_web_view_get_user_content_manager (G_TYPE_CHECK_INSTANCE_CAST (self, webkit_web_view_get_type (), WebKitWebView));
	_tmp4_ = _tmp3_;
	_tmp5_ = composer_web_view_app_script;
	webkit_user_content_manager_add_script (_tmp4_, _tmp5_);
	components_web_view_register_message_callback (G_TYPE_CHECK_INSTANCE_CAST (self, COMPONENTS_TYPE_WEB_VIEW, ComponentsWebView), COMPOSER_WEB_VIEW_CURSOR_CONTEXT_CHANGED, _composer_web_view_on_cursor_context_changed_components_web_view_message_callback, self);
	components_web_view_register_message_callback (G_TYPE_CHECK_INSTANCE_CAST (self, COMPONENTS_TYPE_WEB_VIEW, ComponentsWebView), COMPOSER_WEB_VIEW_DRAG_DROP_RECEIVED, _composer_web_view_on_drag_drop_received_components_web_view_message_callback, self);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, COMPONENTS_TYPE_WEB_VIEW, ComponentsWebView), "command-stack-changed", (GCallback) ___lambda172__components_web_view_command_stack_changed, self, 0);
	return self;
}

ComposerWebView*
composer_web_view_new (ApplicationConfiguration* config)
{
	return composer_web_view_construct (COMPOSER_TYPE_WEB_VIEW, config);
}

/**
     * Loads a message HTML body into the view.
     */
void
composer_web_view_load_html (ComposerWebView* self,
                             const gchar* body,
                             const gchar* quote,
                             gboolean top_posting,
                             gboolean body_complete)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (COMPOSER_IS_WEB_VIEW (self));
	g_return_if_fail (body != NULL);
	g_return_if_fail (quote != NULL);
	_tmp0_ = composer_web_view_get_internal_html (self, body, quote, top_posting, body_complete);
	_tmp1_ = _tmp0_;
	components_web_view_load_html (G_TYPE_CHECK_INSTANCE_CAST (self, COMPONENTS_TYPE_WEB_VIEW, ComponentsWebView), _tmp1_, NULL);
	_g_free0 (_tmp1_);
}

/**
     * Loads a message HTML body into the view.
     */
void
composer_web_view_load_html_headless (ComposerWebView* self,
                                      const gchar* body,
                                      const gchar* quote,
                                      gboolean top_posting,
                                      gboolean body_complete)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (COMPOSER_IS_WEB_VIEW (self));
	g_return_if_fail (body != NULL);
	g_return_if_fail (quote != NULL);
	_tmp0_ = composer_web_view_get_internal_html (self, body, quote, top_posting, body_complete);
	_tmp1_ = _tmp0_;
	components_web_view_load_html_headless (G_TYPE_CHECK_INSTANCE_CAST (self, COMPONENTS_TYPE_WEB_VIEW, ComponentsWebView), _tmp1_, NULL);
	_g_free0 (_tmp1_);
}

static void
composer_web_view_get_html_for_draft_data_free (gpointer _data)
{
	ComposerWebViewGetHtmlForDraftData* _data_;
	_data_ = _data;
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (ComposerWebViewGetHtmlForDraftData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
composer_web_view_get_html_for_draft (ComposerWebView* self,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	ComposerWebViewGetHtmlForDraftData* _data_;
	ComposerWebView* _tmp0_;
	g_return_if_fail (COMPOSER_IS_WEB_VIEW (self));
	_data_ = g_slice_new0 (ComposerWebViewGetHtmlForDraftData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, composer_web_view_get_html_for_draft_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	composer_web_view_get_html_for_draft_co (_data_);
}

gchar*
composer_web_view_get_html_for_draft_finish (ComposerWebView* self,
                                             GAsyncResult* _res_,
                                             GError** error)
{
	gchar* result;
	ComposerWebViewGetHtmlForDraftData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

/**
     * Returns the view's content as HTML without being cleaned.
     */
static void
composer_web_view_get_html_for_draft_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_)
{
	ComposerWebViewGetHtmlForDraftData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	composer_web_view_get_html_for_draft_co (_data_);
}

static gboolean
composer_web_view_get_html_for_draft_co (ComposerWebViewGetHtmlForDraftData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = util_js_callable ("getHtml");
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = util_js_callable_bool (_data_->_tmp2_, FALSE);
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_state_ = 1;
	components_web_view_call_returning (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, COMPONENTS_TYPE_WEB_VIEW, ComponentsWebView), G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _data_->_tmp4_, NULL, composer_web_view_get_html_for_draft_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp5_ = components_web_view_call_returning_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, COMPONENTS_TYPE_WEB_VIEW, ComponentsWebView), _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp6_ = (gchar*) _data_->_tmp5_;
	_util_js_callable_unref0 (_data_->_tmp4_);
	_util_js_callable_unref0 (_data_->_tmp2_);
	_data_->_tmp0_ = _data_->_tmp6_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp7_ = _data_->_tmp0_;
	_data_->_tmp0_ = NULL;
	_data_->result = _data_->_tmp7_;
	_g_free0 (_data_->_tmp0_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/**
     * Sets whether the editor is in rich text or plain text mode.
     */
void
composer_web_view_set_rich_text (ComposerWebView* self,
                                 gboolean enabled)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (COMPOSER_IS_WEB_VIEW (self));
	composer_web_view_set_is_rich_text (self, enabled);
	_tmp0_ = components_web_view_get_is_content_loaded (G_TYPE_CHECK_INSTANCE_CAST (self, COMPONENTS_TYPE_WEB_VIEW, ComponentsWebView));
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		UtilJSCallable* _tmp2_;
		UtilJSCallable* _tmp3_;
		UtilJSCallable* _tmp4_;
		UtilJSCallable* _tmp5_;
		_tmp2_ = util_js_callable ("setRichText");
		_tmp3_ = _tmp2_;
		_tmp4_ = util_js_callable_bool (_tmp3_, enabled);
		_tmp5_ = _tmp4_;
		components_web_view_call_void (G_TYPE_CHECK_INSTANCE_CAST (self, COMPONENTS_TYPE_WEB_VIEW, ComponentsWebView), _tmp5_, NULL, NULL, NULL);
		_util_js_callable_unref0 (_tmp5_);
		_util_js_callable_unref0 (_tmp3_);
	}
}

/**
     * Undoes the last edit operation.
     */
void
composer_web_view_undo (ComposerWebView* self)
{
	UtilJSCallable* _tmp0_;
	UtilJSCallable* _tmp1_;
	g_return_if_fail (COMPOSER_IS_WEB_VIEW (self));
	_tmp0_ = util_js_callable ("undo");
	_tmp1_ = _tmp0_;
	components_web_view_call_void (G_TYPE_CHECK_INSTANCE_CAST (self, COMPONENTS_TYPE_WEB_VIEW, ComponentsWebView), _tmp1_, NULL, NULL, NULL);
	_util_js_callable_unref0 (_tmp1_);
}

/**
     * Redoes the last undone edit operation.
     */
void
composer_web_view_redo (ComposerWebView* self)
{
	UtilJSCallable* _tmp0_;
	UtilJSCallable* _tmp1_;
	g_return_if_fail (COMPOSER_IS_WEB_VIEW (self));
	_tmp0_ = util_js_callable ("redo");
	_tmp1_ = _tmp0_;
	components_web_view_call_void (G_TYPE_CHECK_INSTANCE_CAST (self, COMPONENTS_TYPE_WEB_VIEW, ComponentsWebView), _tmp1_, NULL, NULL, NULL);
	_util_js_callable_unref0 (_tmp1_);
}

static void
composer_web_view_save_selection_data_free (gpointer _data)
{
	ComposerWebViewSaveSelectionData* _data_;
	_data_ = _data;
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (ComposerWebViewSaveSelectionData, _data_);
}

void
composer_web_view_save_selection (ComposerWebView* self,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_)
{
	ComposerWebViewSaveSelectionData* _data_;
	ComposerWebView* _tmp0_;
	g_return_if_fail (COMPOSER_IS_WEB_VIEW (self));
	_data_ = g_slice_new0 (ComposerWebViewSaveSelectionData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, composer_web_view_save_selection_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	composer_web_view_save_selection_co (_data_);
}

gchar*
composer_web_view_save_selection_finish (ComposerWebView* self,
                                         GAsyncResult* _res_,
                                         GError** error)
{
	gchar* result;
	ComposerWebViewSaveSelectionData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

/**
     * Saves the current text selection so it can be restored later.
     *
     * Returns an id to be used to refer to the selection in
     * subsequent calls.
     */
static void
composer_web_view_save_selection_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_)
{
	ComposerWebViewSaveSelectionData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	composer_web_view_save_selection_co (_data_);
}

static gboolean
composer_web_view_save_selection_co (ComposerWebViewSaveSelectionData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = util_js_callable ("saveSelection");
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_state_ = 1;
	components_web_view_call_returning (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, COMPONENTS_TYPE_WEB_VIEW, ComponentsWebView), G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _data_->_tmp2_, NULL, composer_web_view_save_selection_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp3_ = components_web_view_call_returning_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, COMPONENTS_TYPE_WEB_VIEW, ComponentsWebView), _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp4_ = (gchar*) _data_->_tmp3_;
	_util_js_callable_unref0 (_data_->_tmp2_);
	_data_->_tmp0_ = _data_->_tmp4_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = _data_->_tmp0_;
	_data_->_tmp0_ = NULL;
	_data_->result = _data_->_tmp5_;
	_g_free0 (_data_->_tmp0_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/**
     * Removes a saved selection.
     */
void
composer_web_view_free_selection (ComposerWebView* self,
                                  const gchar* id)
{
	UtilJSCallable* _tmp0_;
	UtilJSCallable* _tmp1_;
	UtilJSCallable* _tmp2_;
	UtilJSCallable* _tmp3_;
	g_return_if_fail (COMPOSER_IS_WEB_VIEW (self));
	g_return_if_fail (id != NULL);
	_tmp0_ = util_js_callable ("freeSelection");
	_tmp1_ = _tmp0_;
	_tmp2_ = util_js_callable_string (_tmp1_, id);
	_tmp3_ = _tmp2_;
	components_web_view_call_void (G_TYPE_CHECK_INSTANCE_CAST (self, COMPONENTS_TYPE_WEB_VIEW, ComponentsWebView), _tmp3_, NULL, NULL, NULL);
	_util_js_callable_unref0 (_tmp3_);
	_util_js_callable_unref0 (_tmp1_);
}

/**
     * Cuts selected content and sends it to the clipboard.
     */
void
composer_web_view_cut_clipboard (ComposerWebView* self)
{
	g_return_if_fail (COMPOSER_IS_WEB_VIEW (self));
	webkit_web_view_execute_editing_command (G_TYPE_CHECK_INSTANCE_CAST (self, webkit_web_view_get_type (), WebKitWebView), WEBKIT_EDITING_COMMAND_CUT);
}

/**
     * Pastes plain text from the clipboard into the view.
     */
static void
__lambda173_ (ComposerWebView* self,
              GtkClipboard* clipboard,
              const gchar* text)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (clipboard, gtk_clipboard_get_type ()));
	if (text != NULL) {
		composer_web_view_insert_text (self, text);
	}
}

static void
___lambda173__gtk_clipboard_text_received_func (GtkClipboard* clipboard,
                                                const gchar* text,
                                                gpointer self)
{
	__lambda173_ ((ComposerWebView*) self, clipboard, text);
	g_object_unref (self);
}

void
composer_web_view_paste_plain_text (ComposerWebView* self)
{
	GtkClipboard* _tmp0_;
	g_return_if_fail (COMPOSER_IS_WEB_VIEW (self));
	_tmp0_ = gtk_widget_get_clipboard (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), GDK_SELECTION_CLIPBOARD);
	gtk_clipboard_request_text (_tmp0_, ___lambda173__gtk_clipboard_text_received_func, g_object_ref (self));
}

/**
     * Pastes rich text from the clipboard into the view.
     */
void
composer_web_view_paste_rich_text (ComposerWebView* self)
{
	g_return_if_fail (COMPOSER_IS_WEB_VIEW (self));
	webkit_web_view_execute_editing_command (G_TYPE_CHECK_INSTANCE_CAST (self, webkit_web_view_get_type (), WebKitWebView), WEBKIT_EDITING_COMMAND_PASTE);
}

/**
     * Inserts some text at the current text cursor location.
     */
void
composer_web_view_insert_text (ComposerWebView* self,
                               const gchar* text)
{
	g_return_if_fail (COMPOSER_IS_WEB_VIEW (self));
	g_return_if_fail (text != NULL);
	webkit_web_view_execute_editing_command_with_argument (G_TYPE_CHECK_INSTANCE_CAST (self, webkit_web_view_get_type (), WebKitWebView), "inserttext", text);
}

/**
     * Inserts some HTML at the current text cursor location.
     */
void
composer_web_view_insert_html (ComposerWebView* self,
                               const gchar* markup)
{
	g_return_if_fail (COMPOSER_IS_WEB_VIEW (self));
	g_return_if_fail (markup != NULL);
	webkit_web_view_execute_editing_command_with_argument (G_TYPE_CHECK_INSTANCE_CAST (self, webkit_web_view_get_type (), WebKitWebView), "insertHTML", markup);
}

/**
     * Inserts or updates an A element at the current text cursor location.
     *
     * If the cursor is located on an A element, the element's HREF
     * will be updated, else if some text is selected, an A element
     * will be inserted wrapping the selection.
     */
void
composer_web_view_insert_link (ComposerWebView* self,
                               const gchar* href,
                               const gchar* selection_id)
{
	UtilJSCallable* _tmp0_;
	UtilJSCallable* _tmp1_;
	UtilJSCallable* _tmp2_;
	UtilJSCallable* _tmp3_;
	UtilJSCallable* _tmp4_;
	UtilJSCallable* _tmp5_;
	g_return_if_fail (COMPOSER_IS_WEB_VIEW (self));
	g_return_if_fail (href != NULL);
	g_return_if_fail (selection_id != NULL);
	_tmp0_ = util_js_callable ("insertLink");
	_tmp1_ = _tmp0_;
	_tmp2_ = util_js_callable_string (_tmp1_, href);
	_tmp3_ = _tmp2_;
	_tmp4_ = util_js_callable_string (_tmp3_, selection_id);
	_tmp5_ = _tmp4_;
	components_web_view_call_void (G_TYPE_CHECK_INSTANCE_CAST (self, COMPONENTS_TYPE_WEB_VIEW, ComponentsWebView), _tmp5_, NULL, NULL, NULL);
	_util_js_callable_unref0 (_tmp5_);
	_util_js_callable_unref0 (_tmp3_);
	_util_js_callable_unref0 (_tmp1_);
}

/**
     * Removes the A element at the current text cursor location.
     *
     * If only part of the A element is selected, only that part is
     * unlinked, possibly creating two new A elements flanking the
     * unlinked section.
     */
void
composer_web_view_delete_link (ComposerWebView* self,
                               const gchar* selection_id)
{
	UtilJSCallable* _tmp0_;
	UtilJSCallable* _tmp1_;
	UtilJSCallable* _tmp2_;
	UtilJSCallable* _tmp3_;
	g_return_if_fail (COMPOSER_IS_WEB_VIEW (self));
	g_return_if_fail (selection_id != NULL);
	_tmp0_ = util_js_callable ("deleteLink");
	_tmp1_ = _tmp0_;
	_tmp2_ = util_js_callable_string (_tmp1_, selection_id);
	_tmp3_ = _tmp2_;
	components_web_view_call_void (G_TYPE_CHECK_INSTANCE_CAST (self, COMPONENTS_TYPE_WEB_VIEW, ComponentsWebView), _tmp3_, NULL, NULL, NULL);
	_util_js_callable_unref0 (_tmp3_);
	_util_js_callable_unref0 (_tmp1_);
}

/**
     * Inserts an IMG element at the current text cursor location.
     */
static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

void
composer_web_view_insert_image (ComposerWebView* self,
                                const gchar* src)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (COMPOSER_IS_WEB_VIEW (self));
	g_return_if_fail (src != NULL);
	_tmp0_ = string_to_string (src);
	_tmp1_ = g_strconcat ("<img style=\"max-width: 100%\" src=\"", _tmp0_, "\">", NULL);
	_tmp2_ = _tmp1_;
	webkit_web_view_execute_editing_command_with_argument (G_TYPE_CHECK_INSTANCE_CAST (self, webkit_web_view_get_type (), WebKitWebView), "insertHTML", _tmp2_);
	_g_free0 (_tmp2_);
}

/**
     * Indents the line at the current text cursor location.
     */
void
composer_web_view_indent_line (ComposerWebView* self)
{
	UtilJSCallable* _tmp0_;
	UtilJSCallable* _tmp1_;
	g_return_if_fail (COMPOSER_IS_WEB_VIEW (self));
	_tmp0_ = util_js_callable ("indentLine");
	_tmp1_ = _tmp0_;
	components_web_view_call_void (G_TYPE_CHECK_INSTANCE_CAST (self, COMPONENTS_TYPE_WEB_VIEW, ComponentsWebView), _tmp1_, NULL, NULL, NULL);
	_util_js_callable_unref0 (_tmp1_);
}

void
composer_web_view_insert_olist (ComposerWebView* self)
{
	UtilJSCallable* _tmp0_;
	UtilJSCallable* _tmp1_;
	g_return_if_fail (COMPOSER_IS_WEB_VIEW (self));
	_tmp0_ = util_js_callable ("insertOrderedList");
	_tmp1_ = _tmp0_;
	components_web_view_call_void (G_TYPE_CHECK_INSTANCE_CAST (self, COMPONENTS_TYPE_WEB_VIEW, ComponentsWebView), _tmp1_, NULL, NULL, NULL);
	_util_js_callable_unref0 (_tmp1_);
}

void
composer_web_view_insert_ulist (ComposerWebView* self)
{
	UtilJSCallable* _tmp0_;
	UtilJSCallable* _tmp1_;
	g_return_if_fail (COMPOSER_IS_WEB_VIEW (self));
	_tmp0_ = util_js_callable ("insertUnorderedList");
	_tmp1_ = _tmp0_;
	components_web_view_call_void (G_TYPE_CHECK_INSTANCE_CAST (self, COMPONENTS_TYPE_WEB_VIEW, ComponentsWebView), _tmp1_, NULL, NULL, NULL);
	_util_js_callable_unref0 (_tmp1_);
}

/**
     * Updates the signature block if it has not been deleted.
     */
void
composer_web_view_update_signature (ComposerWebView* self,
                                    const gchar* signature)
{
	UtilJSCallable* _tmp0_;
	UtilJSCallable* _tmp1_;
	UtilJSCallable* _tmp2_;
	UtilJSCallable* _tmp3_;
	g_return_if_fail (COMPOSER_IS_WEB_VIEW (self));
	g_return_if_fail (signature != NULL);
	_tmp0_ = util_js_callable ("updateSignature");
	_tmp1_ = _tmp0_;
	_tmp2_ = util_js_callable_string (_tmp1_, signature);
	_tmp3_ = _tmp2_;
	components_web_view_call_void (G_TYPE_CHECK_INSTANCE_CAST (self, COMPONENTS_TYPE_WEB_VIEW, ComponentsWebView), _tmp3_, NULL, NULL, NULL);
	_util_js_callable_unref0 (_tmp3_);
	_util_js_callable_unref0 (_tmp1_);
}

/**
     * Removes the quoted message (if any) from the composer.
     */
void
composer_web_view_delete_quoted_message (ComposerWebView* self)
{
	UtilJSCallable* _tmp0_;
	UtilJSCallable* _tmp1_;
	g_return_if_fail (COMPOSER_IS_WEB_VIEW (self));
	_tmp0_ = util_js_callable ("deleteQuotedMessage");
	_tmp1_ = _tmp0_;
	components_web_view_call_void (G_TYPE_CHECK_INSTANCE_CAST (self, COMPONENTS_TYPE_WEB_VIEW, ComponentsWebView), _tmp1_, NULL, NULL, NULL);
	_util_js_callable_unref0 (_tmp1_);
}

static void
composer_web_view_contains_attachment_keywords_data_free (gpointer _data)
{
	ComposerWebViewContainsAttachmentKeywordsData* _data_;
	_data_ = _data;
	_g_free0 (_data_->keyword_spec);
	_g_free0 (_data_->subject);
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (ComposerWebViewContainsAttachmentKeywordsData, _data_);
}

void
composer_web_view_contains_attachment_keywords (ComposerWebView* self,
                                                const gchar* keyword_spec,
                                                const gchar* subject,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_)
{
	ComposerWebViewContainsAttachmentKeywordsData* _data_;
	ComposerWebView* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (COMPOSER_IS_WEB_VIEW (self));
	g_return_if_fail (keyword_spec != NULL);
	g_return_if_fail (subject != NULL);
	_data_ = g_slice_new0 (ComposerWebViewContainsAttachmentKeywordsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, composer_web_view_contains_attachment_keywords_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (keyword_spec);
	_g_free0 (_data_->keyword_spec);
	_data_->keyword_spec = _tmp1_;
	_tmp2_ = g_strdup (subject);
	_g_free0 (_data_->subject);
	_data_->subject = _tmp2_;
	composer_web_view_contains_attachment_keywords_co (_data_);
}

gboolean*
composer_web_view_contains_attachment_keywords_finish (ComposerWebView* self,
                                                       GAsyncResult* _res_)
{
	gboolean* result;
	ComposerWebViewContainsAttachmentKeywordsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

/**
     * Determines if the editor content contains an attachment keyword.
     */
static gboolean*
_bool_dup (gboolean* self)
{
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}

static void
composer_web_view_contains_attachment_keywords_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_)
{
	ComposerWebViewContainsAttachmentKeywordsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	composer_web_view_contains_attachment_keywords_co (_data_);
}

static gpointer
__bool_dup0 (gpointer self)
{
	return self ? _bool_dup (self) : NULL;
}

static gboolean
composer_web_view_contains_attachment_keywords_co (ComposerWebViewContainsAttachmentKeywordsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp1_ = util_js_callable ("containsAttachmentKeyword");
		_data_->_tmp2_ = _data_->_tmp1_;
		_data_->_tmp3_ = util_js_callable_string (_data_->_tmp2_, _data_->keyword_spec);
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_tmp5_ = util_js_callable_string (_data_->_tmp4_, _data_->subject);
		_data_->_tmp6_ = _data_->_tmp5_;
		_data_->_state_ = 1;
		components_web_view_call_returning (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, COMPONENTS_TYPE_WEB_VIEW, ComponentsWebView), G_TYPE_BOOLEAN, (GBoxedCopyFunc) _bool_dup, (GDestroyNotify) g_free, _data_->_tmp6_, NULL, composer_web_view_contains_attachment_keywords_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp7_ = components_web_view_call_returning_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, COMPONENTS_TYPE_WEB_VIEW, ComponentsWebView), _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp8_ = (gboolean*) _data_->_tmp7_;
		_util_js_callable_unref0 (_data_->_tmp6_);
		_util_js_callable_unref0 (_data_->_tmp4_);
		_util_js_callable_unref0 (_data_->_tmp2_);
		_data_->_tmp0_ = _data_->_tmp8_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp9_ = _data_->_tmp0_;
		_data_->_tmp0_ = NULL;
		_data_->result = _data_->_tmp9_;
		_g_free0 (_data_->_tmp0_);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp10_ = _data_->err;
		_data_->_tmp11_ = _data_->_tmp10_->message;
		g_debug ("composer-web-view.vala:422: Error checking or attachment keywords: %s", _data_->_tmp11_);
		_data_->_tmp12_ = FALSE;
		_data_->_tmp13_ = __bool_dup0 (&_data_->_tmp12_);
		_data_->result = _data_->_tmp13_;
		_g_error_free0 (_data_->err);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
	g_clear_error (&_data_->_inner_error0_);
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
composer_web_view_clean_content_data_free (gpointer _data)
{
	ComposerWebViewCleanContentData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ComposerWebViewCleanContentData, _data_);
}

void
composer_web_view_clean_content (ComposerWebView* self,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	ComposerWebViewCleanContentData* _data_;
	ComposerWebView* _tmp0_;
	g_return_if_fail (COMPOSER_IS_WEB_VIEW (self));
	_data_ = g_slice_new0 (ComposerWebViewCleanContentData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, composer_web_view_clean_content_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	composer_web_view_clean_content_co (_data_);
}

void
composer_web_view_clean_content_finish (ComposerWebView* self,
                                        GAsyncResult* _res_,
                                        GError** error)
{
	ComposerWebViewCleanContentData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Cleans the editor content ready for sending.
     *
     * This modifies the DOM, so there's no going back after calling
     * this.
     */
static gboolean
composer_web_view_clean_content_co (ComposerWebViewCleanContentData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = util_js_callable ("cleanContent");
	_data_->_tmp1_ = _data_->_tmp0_;
	components_web_view_call_void (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, COMPONENTS_TYPE_WEB_VIEW, ComponentsWebView), _data_->_tmp1_, NULL, NULL, NULL);
	_util_js_callable_unref0 (_data_->_tmp1_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
composer_web_view_get_text_data_free (gpointer _data)
{
	ComposerWebViewGetTextData* _data_;
	_data_ = _data;
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (ComposerWebViewGetTextData, _data_);
}

void
composer_web_view_get_text (ComposerWebView* self,
                            GAsyncReadyCallback _callback_,
                            gpointer _user_data_)
{
	ComposerWebViewGetTextData* _data_;
	ComposerWebView* _tmp0_;
	g_return_if_fail (COMPOSER_IS_WEB_VIEW (self));
	_data_ = g_slice_new0 (ComposerWebViewGetTextData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, composer_web_view_get_text_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	composer_web_view_get_text_co (_data_);
}

gchar*
composer_web_view_get_text_finish (ComposerWebView* self,
                                   GAsyncResult* _res_,
                                   GError** error)
{
	gchar* result;
	ComposerWebViewGetTextData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

/**
     * Returns the editor text as RFC 3676 format=flowed text.
     */
static void
composer_web_view_get_text_ready (GObject* source_object,
                                  GAsyncResult* _res_,
                                  gpointer _user_data_)
{
	ComposerWebViewGetTextData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	composer_web_view_get_text_co (_data_);
}

static gchar*
string_chomp (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strchomp (_result_);
	result = _result_;
	return result;
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static gint
string_last_index_of (const gchar* self,
                      const gchar* needle,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = g_strrstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gboolean
composer_web_view_get_text_co (ComposerWebViewGetTextData* _data_)
{
	static const gint MAX_BREAKABLE_LEN = 72;
	static const gint MAX_UNBREAKABLE_LEN = 998;
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = util_js_callable ("getText");
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_state_ = 1;
	components_web_view_call_returning (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, COMPONENTS_TYPE_WEB_VIEW, ComponentsWebView), G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _data_->_tmp1_, NULL, composer_web_view_get_text_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp2_ = components_web_view_call_returning_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, COMPONENTS_TYPE_WEB_VIEW, ComponentsWebView), _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp3_ = (gchar*) _data_->_tmp2_;
	_util_js_callable_unref0 (_data_->_tmp1_);
	_data_->body_text = _data_->_tmp3_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = _data_->body_text;
	if (_data_->_tmp4_ == NULL) {
		_data_->_tmp4_ = "";
	}
	_data_->_tmp6_ = _data_->_tmp5_ = g_strsplit (_data_->_tmp4_, "\n", 0);
	_data_->lines = _data_->_tmp6_;
	_data_->lines_length1 = _vala_array_length (_data_->_tmp5_);
	_data_->_lines_size_ = _data_->lines_length1;
	_data_->_tmp7_ = strlen (_data_->body_text);
	_data_->_tmp8_ = _data_->_tmp7_;
	_data_->_tmp9_ = g_string_sized_new ((gsize) _data_->_tmp8_);
	_data_->flowed = _data_->_tmp9_;
	_data_->_tmp10_ = _data_->lines;
	_data_->_tmp10__length1 = _data_->lines_length1;
	{
		_data_->line_collection_length1 = 0;
		_data_->_line_collection_size_ = 0;
		_data_->line_collection = _data_->_tmp10_;
		_data_->line_collection_length1 = _data_->_tmp10__length1;
		for (_data_->line_it = 0; _data_->line_it < _data_->line_collection_length1; _data_->line_it = _data_->line_it + 1) {
			_data_->_tmp11_ = g_strdup (_data_->line_collection[_data_->line_it]);
			_data_->line = _data_->_tmp11_;
			{
				_data_->_tmp12_ = _data_->line;
				if (g_strcmp0 (_data_->_tmp12_, "-- ") != 0) {
					_data_->_tmp13_ = _data_->line;
					_data_->_tmp14_ = string_chomp (_data_->_tmp13_);
					_g_free0 (_data_->line);
					_data_->line = _data_->_tmp14_;
				}
				_data_->quote_level = 0;
				while (TRUE) {
					_data_->_tmp15_ = _data_->line;
					if (!(string_get (_data_->_tmp15_, (glong) _data_->quote_level) == GEARY_RF_C822_UTILS_QUOTE_MARKER)) {
						break;
					}
					_data_->quote_level += 1;
				}
				_data_->_tmp16_ = _data_->line;
				_data_->_tmp17_ = _data_->line;
				_data_->_tmp18_ = strlen (_data_->_tmp17_);
				_data_->_tmp19_ = _data_->_tmp18_;
				_data_->_tmp20_ = string_slice (_data_->_tmp16_, (glong) _data_->quote_level, (glong) _data_->_tmp19_);
				_g_free0 (_data_->line);
				_data_->line = _data_->_tmp20_;
				if (_data_->quote_level > 0) {
					_data_->_tmp22_ = g_strnfill ((gsize) _data_->quote_level, '>');
					_data_->_tmp23_ = _data_->_tmp22_;
					_data_->_tmp24_ = g_strconcat (_data_->_tmp23_, " ", NULL);
					_g_free0 (_data_->_tmp21_);
					_data_->_tmp21_ = _data_->_tmp24_;
					_g_free0 (_data_->_tmp23_);
				} else {
					_data_->_tmp25_ = g_strdup ("");
					_g_free0 (_data_->_tmp21_);
					_data_->_tmp21_ = _data_->_tmp25_;
				}
				_data_->_tmp26_ = g_strdup (_data_->_tmp21_);
				_data_->prefix = _data_->_tmp26_;
				_data_->_tmp27_ = _data_->prefix;
				_data_->_tmp28_ = strlen (_data_->_tmp27_);
				_data_->_tmp29_ = _data_->_tmp28_;
				_data_->max_breakable = MAX_BREAKABLE_LEN - _data_->_tmp29_;
				_data_->_tmp30_ = _data_->prefix;
				_data_->_tmp31_ = strlen (_data_->_tmp30_);
				_data_->_tmp32_ = _data_->_tmp31_;
				_data_->max_unbreakable = MAX_UNBREAKABLE_LEN - _data_->_tmp32_;
				{
					_data_->_tmp33_ = TRUE;
					while (TRUE) {
						if (!_data_->_tmp33_) {
							_data_->_tmp34_ = _data_->line;
							_data_->_tmp35_ = strlen (_data_->_tmp34_);
							_data_->_tmp36_ = _data_->_tmp35_;
							if (!(_data_->_tmp36_ > 0)) {
								break;
							}
						}
						_data_->_tmp33_ = FALSE;
						_data_->start_ind = 0;
						if (_data_->quote_level == 0) {
							_data_->_tmp39_ = _data_->line;
							if (g_str_has_prefix (_data_->_tmp39_, ">")) {
								_data_->_tmp38_ = TRUE;
							} else {
								_data_->_tmp40_ = _data_->line;
								_data_->_tmp38_ = g_str_has_prefix (_data_->_tmp40_, "From");
							}
							_data_->_tmp37_ = _data_->_tmp38_;
						} else {
							_data_->_tmp37_ = FALSE;
						}
						if (_data_->_tmp37_) {
							_data_->_tmp41_ = _data_->line;
							_data_->_tmp42_ = g_strconcat (" ", _data_->_tmp41_, NULL);
							_g_free0 (_data_->line);
							_data_->line = _data_->_tmp42_;
							_data_->start_ind = 1;
						}
						_data_->_tmp43_ = _data_->line;
						_data_->_tmp44_ = strlen (_data_->_tmp43_);
						_data_->_tmp45_ = _data_->_tmp44_;
						_data_->cut_ind = _data_->_tmp45_;
						if (_data_->cut_ind > _data_->max_breakable) {
							_data_->_tmp46_ = _data_->line;
							_data_->_tmp47_ = string_slice (_data_->_tmp46_, (glong) 0, (glong) _data_->max_breakable);
							_data_->beg = _data_->_tmp47_;
							_data_->_tmp48_ = _data_->beg;
							_data_->cut_ind = string_last_index_of (_data_->_tmp48_, " ", _data_->start_ind) + 1;
							if (_data_->cut_ind == 0) {
								_data_->_tmp49_ = _data_->line;
								_data_->cut_ind = string_index_of (_data_->_tmp49_, " ", _data_->start_ind) + 1;
								if (_data_->cut_ind == 0) {
									_data_->_tmp50_ = _data_->line;
									_data_->_tmp51_ = strlen (_data_->_tmp50_);
									_data_->_tmp52_ = _data_->_tmp51_;
									_data_->cut_ind = _data_->_tmp52_;
								}
								if (_data_->cut_ind > _data_->max_unbreakable) {
									_data_->cut_ind = _data_->max_unbreakable;
								}
							}
							_g_free0 (_data_->beg);
						}
						_data_->_tmp53_ = _data_->flowed;
						_data_->_tmp54_ = _data_->prefix;
						_data_->_tmp55_ = _data_->line;
						_data_->_tmp56_ = string_slice (_data_->_tmp55_, (glong) 0, (glong) _data_->cut_ind);
						_data_->_tmp57_ = _data_->_tmp56_;
						_data_->_tmp58_ = g_strconcat (_data_->_tmp54_, _data_->_tmp57_, NULL);
						_data_->_tmp59_ = _data_->_tmp58_;
						_data_->_tmp60_ = g_strconcat (_data_->_tmp59_, "\n", NULL);
						_data_->_tmp61_ = _data_->_tmp60_;
						g_string_append (_data_->_tmp53_, _data_->_tmp61_);
						_g_free0 (_data_->_tmp61_);
						_g_free0 (_data_->_tmp59_);
						_g_free0 (_data_->_tmp57_);
						_data_->_tmp62_ = _data_->line;
						_data_->_tmp63_ = _data_->line;
						_data_->_tmp64_ = strlen (_data_->_tmp63_);
						_data_->_tmp65_ = _data_->_tmp64_;
						_data_->_tmp66_ = string_slice (_data_->_tmp62_, (glong) _data_->cut_ind, (glong) _data_->_tmp65_);
						_g_free0 (_data_->line);
						_data_->line = _data_->_tmp66_;
					}
				}
				_g_free0 (_data_->prefix);
				_g_free0 (_data_->_tmp21_);
				_g_free0 (_data_->line);
			}
		}
	}
	_data_->_tmp67_ = _data_->flowed;
	_data_->_tmp68_ = _data_->_tmp67_->str;
	_data_->_tmp69_ = g_strdup (_data_->_tmp68_);
	_data_->result = _data_->_tmp69_;
	_g_string_free0 (_data_->flowed);
	_data_->lines = (_vala_array_free (_data_->lines, _data_->lines_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (_data_->body_text);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static guint8*
g_string_get_data (GString* self,
                   gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	const gchar* _tmp0_;
	gint res_length1;
	gint _res_size_;
	guint8* _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->str;
	res = (guint8*) _tmp0_;
	res_length1 = -1;
	_res_size_ = res_length1;
	res_length1 = (gint) self->len;
	_tmp1_ = res;
	_tmp1__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

static gchar*
composer_web_view_get_internal_html (ComposerWebView* self,
                                     const gchar* body,
                                     const gchar* quote,
                                     gboolean top_posting,
                                     gboolean body_complete)
{
	GString* html = NULL;
	GString* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_;
	gchar* body_class = NULL;
	gchar* _tmp3_;
	GString* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GString* _tmp23_;
	GString* _tmp24_;
	guint8* _tmp25_;
	gint _tmp25__length1;
	gint _tmp26_ = 0;
	guint8* _tmp27_;
	gint _tmp27__length1;
	gchar* _tmp28_;
	gchar* result;
	g_return_val_if_fail (COMPOSER_IS_WEB_VIEW (self), NULL);
	g_return_val_if_fail (body != NULL, NULL);
	g_return_val_if_fail (quote != NULL, NULL);
	_tmp0_ = g_string_new ("");
	html = _tmp0_;
	_tmp2_ = self->priv->_is_rich_text;
	if (_tmp2_) {
		_tmp1_ = "";
	} else {
		_tmp1_ = "plain";
	}
	_tmp3_ = g_strdup (_tmp1_);
	body_class = _tmp3_;
	_tmp4_ = html;
	_tmp5_ = body_class;
	_tmp6_ = g_strdup_printf (COMPOSER_WEB_VIEW_HTML_PRE, _tmp5_);
	_tmp7_ = _tmp6_;
	g_string_append (_tmp4_, _tmp7_);
	_g_free0 (_tmp7_);
	if (!body_complete) {
		GString* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gboolean have_body = FALSE;
		gboolean _tmp13_ = FALSE;
		GString* _tmp16_;
		GString* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gboolean _tmp20_ = FALSE;
		_tmp8_ = html;
		_tmp9_ = g_strdup_printf (COMPOSER_WEB_VIEW_BODY_PRE, COMPOSER_WEB_VIEW_BODY_HTML_ID);
		_tmp10_ = _tmp9_;
		g_string_append (_tmp8_, _tmp10_);
		_g_free0 (_tmp10_);
		have_body = !geary_string_is_empty (body);
		if (have_body) {
			GString* _tmp11_;
			GString* _tmp12_;
			_tmp11_ = html;
			g_string_append (_tmp11_, body);
			_tmp12_ = html;
			g_string_append (_tmp12_, COMPOSER_WEB_VIEW_SPACER);
		}
		if (!top_posting) {
			_tmp13_ = !geary_string_is_empty (quote);
		} else {
			_tmp13_ = FALSE;
		}
		if (_tmp13_) {
			GString* _tmp14_;
			GString* _tmp15_;
			_tmp14_ = html;
			g_string_append (_tmp14_, quote);
			_tmp15_ = html;
			g_string_append (_tmp15_, COMPOSER_WEB_VIEW_SPACER);
		}
		_tmp16_ = html;
		g_string_append (_tmp16_, COMPOSER_WEB_VIEW_CURSOR);
		_tmp17_ = html;
		_tmp18_ = g_strdup_printf (COMPOSER_WEB_VIEW_BODY_POST, COMPOSER_WEB_VIEW_SIGNATURE_HTML_ID);
		_tmp19_ = _tmp18_;
		g_string_append (_tmp17_, _tmp19_);
		_g_free0 (_tmp19_);
		if (top_posting) {
			_tmp20_ = !geary_string_is_empty (quote);
		} else {
			_tmp20_ = FALSE;
		}
		if (_tmp20_) {
			GString* _tmp21_;
			_tmp21_ = html;
			g_string_append_printf (_tmp21_, COMPOSER_WEB_VIEW_QUOTE, COMPOSER_WEB_VIEW_QUOTE_HTML_ID, quote);
		}
	} else {
		GString* _tmp22_;
		_tmp22_ = html;
		g_string_append (_tmp22_, body);
	}
	_tmp23_ = html;
	g_string_append (_tmp23_, COMPOSER_WEB_VIEW_HTML_POST);
	_tmp24_ = html;
	_tmp25_ = g_string_get_data (_tmp24_, &_tmp26_);
	_tmp25__length1 = _tmp26_;
	_tmp27_ = _tmp25_;
	_tmp27__length1 = _tmp25__length1;
	_tmp28_ = g_strdup ((const gchar*) _tmp27_);
	result = _tmp28_;
	_g_free0 (body_class);
	_g_string_free0 (html);
	return result;
}

static gchar*
_variant_get14 (GVariant* value)
{
	if (value && g_variant_is_of_type (value, G_VARIANT_TYPE_STRING)) {
		return g_variant_dup_string (value, NULL);
	} else {
		return NULL;
	}
}

static void
composer_web_view_on_cursor_context_changed (ComposerWebView* self,
                                             GVariant* parameters)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (COMPOSER_IS_WEB_VIEW (self));
	if (parameters != NULL) {
		_tmp0_ = g_variant_classify (parameters) == G_VARIANT_CLASS_STRING;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		ComposerWebViewEditContext* _tmp3_;
		ComposerWebViewEditContext* _tmp4_;
		_tmp1_ = _variant_get14 (parameters);
		_tmp2_ = _tmp1_;
		_tmp3_ = composer_web_view_edit_context_new (_tmp2_);
		_tmp4_ = _tmp3_;
		g_signal_emit (self, composer_web_view_signals[COMPOSER_WEB_VIEW_CURSOR_CONTEXT_CHANGED_SIGNAL], 0, _tmp4_);
		_g_object_unref0 (_tmp4_);
		_g_free0 (_tmp2_);
	} else {
		g_warning ("composer-web-view.vala:546: Could not get text cursor style");
	}
}

/**
     *  Handle a dropped image
     */
static void
composer_web_view_on_drag_drop_received (ComposerWebView* self,
                                         GVariant* parameters)
{
	GVariantDict* dict = NULL;
	GVariantDict* _tmp0_;
	gchar* file_name = NULL;
	GVariantDict* _tmp1_;
	const GVariantType* _tmp2_;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* file_name_unescaped = NULL;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* file_type = NULL;
	GVariantDict* _tmp10_;
	const GVariantType* _tmp11_;
	GVariant* _tmp12_;
	GVariant* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* content_base64 = NULL;
	GVariantDict* _tmp17_;
	const GVariantType* _tmp18_;
	GVariant* _tmp19_;
	GVariant* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	guint8* image = NULL;
	const gchar* _tmp24_;
	gsize _tmp25_ = 0;
	guchar* _tmp26_;
	gint image_length1;
	gint _image_size_;
	guint8* _tmp27_;
	gint _tmp27__length1;
	const gchar* _tmp29_;
	g_return_if_fail (COMPOSER_IS_WEB_VIEW (self));
	_tmp0_ = g_variant_dict_new (parameters);
	dict = _tmp0_;
	_tmp1_ = dict;
	_tmp2_ = G_VARIANT_TYPE_STRING;
	_tmp3_ = g_variant_dict_lookup_value (_tmp1_, "fileName", _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_variant_get_string (_tmp4_, NULL);
	_tmp6_ = g_strdup (_tmp5_);
	_tmp7_ = _tmp6_;
	_g_variant_unref0 (_tmp4_);
	file_name = _tmp7_;
	_tmp8_ = file_name;
	_tmp9_ = g_uri_unescape_string (_tmp8_, NULL);
	file_name_unescaped = _tmp9_;
	_tmp10_ = dict;
	_tmp11_ = G_VARIANT_TYPE_STRING;
	_tmp12_ = g_variant_dict_lookup_value (_tmp10_, "fileType", _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_variant_get_string (_tmp13_, NULL);
	_tmp15_ = g_strdup (_tmp14_);
	_tmp16_ = _tmp15_;
	_g_variant_unref0 (_tmp13_);
	file_type = _tmp16_;
	_tmp17_ = dict;
	_tmp18_ = G_VARIANT_TYPE_STRING;
	_tmp19_ = g_variant_dict_lookup_value (_tmp17_, "content", _tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = g_variant_get_string (_tmp20_, NULL);
	_tmp22_ = g_strdup (_tmp21_);
	_tmp23_ = _tmp22_;
	_g_variant_unref0 (_tmp20_);
	content_base64 = _tmp23_;
	_tmp24_ = content_base64;
	_tmp26_ = g_base64_decode (_tmp24_, &_tmp25_);
	image = _tmp26_;
	image_length1 = _tmp25_;
	_image_size_ = image_length1;
	_tmp27_ = image;
	_tmp27__length1 = image_length1;
	if (_tmp27__length1 == 0) {
		const gchar* _tmp28_;
		_tmp28_ = file_name;
		g_warning ("composer-web-view.vala:570: %s is empty", _tmp28_);
		image = (g_free (image), NULL);
		_g_free0 (content_base64);
		_g_free0 (file_type);
		_g_free0 (file_name_unescaped);
		_g_free0 (file_name);
		_g_variant_dict_unref0 (dict);
		return;
	}
	_tmp29_ = file_type;
	if (string_index_of (_tmp29_, "image/", 0) == 0) {
		const gchar* _tmp30_;
		const gchar* _tmp31_;
		guint8* _tmp32_;
		gint _tmp32__length1;
		_tmp30_ = file_name_unescaped;
		_tmp31_ = file_type;
		_tmp32_ = image;
		_tmp32__length1 = image_length1;
		g_signal_emit (self, composer_web_view_signals[COMPOSER_WEB_VIEW_IMAGE_FILE_DROPPED_SIGNAL], 0, _tmp30_, _tmp31_, _tmp32_, (gint) _tmp32__length1);
	}
	image = (g_free (image), NULL);
	_g_free0 (content_base64);
	_g_free0 (file_type);
	_g_free0 (file_name_unescaped);
	_g_free0 (file_name);
	_g_variant_dict_unref0 (dict);
}

static inline gpointer
composer_web_view_edit_context_get_instance_private (ComposerWebViewEditContext* self)
{
	return G_STRUCT_MEMBER_P (self, ComposerWebViewEditContext_private_offset);
}

gboolean
composer_web_view_edit_context_get_is_link (ComposerWebViewEditContext* self)
{
	gboolean result;
	g_return_val_if_fail (COMPOSER_WEB_VIEW_IS_EDIT_CONTEXT (self), FALSE);
	result = (self->priv->context & COMPOSER_WEB_VIEW_EDIT_CONTEXT_LINK_MASK) > ((guint) 0);
	return result;
}

const gchar*
composer_web_view_edit_context_get_link_url (ComposerWebViewEditContext* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (COMPOSER_WEB_VIEW_IS_EDIT_CONTEXT (self), NULL);
	_tmp0_ = self->priv->_link_url;
	result = _tmp0_;
	return result;
}

static void
composer_web_view_edit_context_set_link_url (ComposerWebViewEditContext* self,
                                             const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (COMPOSER_WEB_VIEW_IS_EDIT_CONTEXT (self));
	old_value = composer_web_view_edit_context_get_link_url (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_link_url);
		self->priv->_link_url = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, composer_web_view_edit_context_properties[COMPOSER_WEB_VIEW_EDIT_CONTEXT_LINK_URL_PROPERTY]);
	}
}

const gchar*
composer_web_view_edit_context_get_font_family (ComposerWebViewEditContext* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (COMPOSER_WEB_VIEW_IS_EDIT_CONTEXT (self), NULL);
	_tmp0_ = self->priv->_font_family;
	result = _tmp0_;
	return result;
}

static void
composer_web_view_edit_context_set_font_family (ComposerWebViewEditContext* self,
                                                const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (COMPOSER_WEB_VIEW_IS_EDIT_CONTEXT (self));
	old_value = composer_web_view_edit_context_get_font_family (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_font_family);
		self->priv->_font_family = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, composer_web_view_edit_context_properties[COMPOSER_WEB_VIEW_EDIT_CONTEXT_FONT_FAMILY_PROPERTY]);
	}
}

guint
composer_web_view_edit_context_get_font_size (ComposerWebViewEditContext* self)
{
	guint result;
	g_return_val_if_fail (COMPOSER_WEB_VIEW_IS_EDIT_CONTEXT (self), 0U);
	result = self->priv->_font_size;
	return result;
}

static void
composer_web_view_edit_context_set_font_size (ComposerWebViewEditContext* self,
                                              guint value)
{
	guint old_value;
	g_return_if_fail (COMPOSER_WEB_VIEW_IS_EDIT_CONTEXT (self));
	old_value = composer_web_view_edit_context_get_font_size (self);
	if (old_value != value) {
		self->priv->_font_size = value;
		g_object_notify_by_pspec ((GObject *) self, composer_web_view_edit_context_properties[COMPOSER_WEB_VIEW_EDIT_CONTEXT_FONT_SIZE_PROPERTY]);
	}
}

void
composer_web_view_edit_context_get_font_color (ComposerWebViewEditContext* self,
                                               GdkRGBA * result)
{
	GdkRGBA _tmp0_;
	g_return_if_fail (COMPOSER_WEB_VIEW_IS_EDIT_CONTEXT (self));
	_tmp0_ = self->priv->_font_color;
	*result = _tmp0_;
	return;
}

static gboolean
_gdk_rgba_equal (const GdkRGBA * s1,
                 const GdkRGBA * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	if (s1->red != s2->red) {
		return FALSE;
	}
	if (s1->green != s2->green) {
		return FALSE;
	}
	if (s1->blue != s2->blue) {
		return FALSE;
	}
	if (s1->alpha != s2->alpha) {
		return FALSE;
	}
	return TRUE;
}

static void
composer_web_view_edit_context_set_font_color (ComposerWebViewEditContext* self,
                                               GdkRGBA * value)
{
	GdkRGBA old_value;
	g_return_if_fail (COMPOSER_WEB_VIEW_IS_EDIT_CONTEXT (self));
	composer_web_view_edit_context_get_font_color (self, &old_value);
	if (_gdk_rgba_equal (value, &old_value) != TRUE) {
		GdkRGBA _tmp0_;
		_tmp0_ = *value;
		self->priv->_font_color = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, composer_web_view_edit_context_properties[COMPOSER_WEB_VIEW_EDIT_CONTEXT_FONT_COLOR_PROPERTY]);
	}
}

static guint64
uint64_parse (const gchar* str,
              guint _base)
{
	guint64 result;
	g_return_val_if_fail (str != NULL, 0ULL);
	result = g_ascii_strtoull (str, NULL, _base);
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

ComposerWebViewEditContext*
composer_web_view_edit_context_construct (GType object_type,
                                          const gchar* message)
{
	ComposerWebViewEditContext * self = NULL;
	gchar** values = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint values_length1;
	gint _values_size_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	const gchar* _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	const gchar* _tmp5_;
	gchar* view_name = NULL;
	gchar** _tmp6_;
	gint _tmp6__length1;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar** _tmp24_;
	gint _tmp24__length1;
	const gchar* _tmp25_;
	GdkRGBA font_color = {0};
	GdkRGBA _tmp26_ = {0};
	gchar** _tmp27_;
	gint _tmp27__length1;
	const gchar* _tmp28_;
	GdkRGBA _tmp29_;
	g_return_val_if_fail (message != NULL, NULL);
	self = (ComposerWebViewEditContext*) g_object_new (object_type, NULL);
	_tmp1_ = _tmp0_ = g_strsplit (message, ";", 0);
	values = _tmp1_;
	values_length1 = _vala_array_length (_tmp0_);
	_values_size_ = values_length1;
	_tmp2_ = values;
	_tmp2__length1 = values_length1;
	_tmp3_ = _tmp2_[0];
	self->priv->context = (guint) uint64_parse (_tmp3_, (guint) 0);
	_tmp4_ = values;
	_tmp4__length1 = values_length1;
	_tmp5_ = _tmp4_[1];
	composer_web_view_edit_context_set_link_url (self, _tmp5_);
	_tmp6_ = values;
	_tmp6__length1 = values_length1;
	_tmp7_ = _tmp6_[2];
	_tmp8_ = g_utf8_strdown (_tmp7_, (gssize) -1);
	view_name = _tmp8_;
	{
		GeeIterator* _specific_name_it = NULL;
		GeeHashMap* _tmp9_;
		GeeSet* _tmp10_;
		GeeSet* _tmp11_;
		GeeSet* _tmp12_;
		GeeIterator* _tmp13_;
		GeeIterator* _tmp14_;
		_tmp9_ = composer_web_view_edit_context_font_family_map;
		_tmp10_ = gee_abstract_map_get_keys (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
		_tmp11_ = _tmp10_;
		_tmp12_ = _tmp11_;
		_tmp13_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp14_ = _tmp13_;
		_g_object_unref0 (_tmp12_);
		_specific_name_it = _tmp14_;
		while (TRUE) {
			GeeIterator* _tmp15_;
			gchar* specific_name = NULL;
			GeeIterator* _tmp16_;
			gpointer _tmp17_;
			const gchar* _tmp18_;
			const gchar* _tmp19_;
			_tmp15_ = _specific_name_it;
			if (!gee_iterator_next (_tmp15_)) {
				break;
			}
			_tmp16_ = _specific_name_it;
			_tmp17_ = gee_iterator_get (_tmp16_);
			specific_name = (gchar*) _tmp17_;
			_tmp18_ = view_name;
			_tmp19_ = specific_name;
			if (string_contains (_tmp18_, _tmp19_)) {
				GeeHashMap* _tmp20_;
				const gchar* _tmp21_;
				gpointer _tmp22_;
				gchar* _tmp23_;
				_tmp20_ = composer_web_view_edit_context_font_family_map;
				_tmp21_ = specific_name;
				_tmp22_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp21_);
				_tmp23_ = (gchar*) _tmp22_;
				composer_web_view_edit_context_set_font_family (self, _tmp23_);
				_g_free0 (_tmp23_);
				_g_free0 (specific_name);
				break;
			}
			_g_free0 (specific_name);
		}
		_g_object_unref0 (_specific_name_it);
	}
	_tmp24_ = values;
	_tmp24__length1 = values_length1;
	_tmp25_ = _tmp24_[3];
	composer_web_view_edit_context_set_font_size (self, (guint) uint64_parse (_tmp25_, (guint) 0));
	_tmp26_.red = (gdouble) 0;
	_tmp26_.green = (gdouble) 0;
	_tmp26_.blue = (gdouble) 0;
	_tmp26_.alpha = (gdouble) 0;
	font_color = _tmp26_;
	_tmp27_ = values;
	_tmp27__length1 = values_length1;
	_tmp28_ = _tmp27_[4];
	gdk_rgba_parse (&font_color, _tmp28_);
	_tmp29_ = font_color;
	composer_web_view_edit_context_set_font_color (self, &_tmp29_);
	_g_free0 (view_name);
	values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_free), NULL);
	return self;
}

ComposerWebViewEditContext*
composer_web_view_edit_context_new (const gchar* message)
{
	return composer_web_view_edit_context_construct (COMPOSER_WEB_VIEW_TYPE_EDIT_CONTEXT, message);
}

static void
composer_web_view_edit_context_class_init (ComposerWebViewEditContextClass * klass,
                                           gpointer klass_data)
{
	GeeHashMap* _tmp0_;
	composer_web_view_edit_context_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ComposerWebViewEditContext_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_composer_web_view_edit_context_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_composer_web_view_edit_context_set_property;
	G_OBJECT_CLASS (klass)->finalize = composer_web_view_edit_context_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), COMPOSER_WEB_VIEW_EDIT_CONTEXT_IS_LINK_PROPERTY, composer_web_view_edit_context_properties[COMPOSER_WEB_VIEW_EDIT_CONTEXT_IS_LINK_PROPERTY] = g_param_spec_boolean ("is-link", "is-link", "is-link", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), COMPOSER_WEB_VIEW_EDIT_CONTEXT_LINK_URL_PROPERTY, composer_web_view_edit_context_properties[COMPOSER_WEB_VIEW_EDIT_CONTEXT_LINK_URL_PROPERTY] = g_param_spec_string ("link-url", "link-url", "link-url", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), COMPOSER_WEB_VIEW_EDIT_CONTEXT_FONT_FAMILY_PROPERTY, composer_web_view_edit_context_properties[COMPOSER_WEB_VIEW_EDIT_CONTEXT_FONT_FAMILY_PROPERTY] = g_param_spec_string ("font-family", "font-family", "font-family", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), COMPOSER_WEB_VIEW_EDIT_CONTEXT_FONT_SIZE_PROPERTY, composer_web_view_edit_context_properties[COMPOSER_WEB_VIEW_EDIT_CONTEXT_FONT_SIZE_PROPERTY] = g_param_spec_uint ("font-size", "font-size", "font-size", 0, G_MAXUINT, (guint) 12, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), COMPOSER_WEB_VIEW_EDIT_CONTEXT_FONT_COLOR_PROPERTY, composer_web_view_edit_context_properties[COMPOSER_WEB_VIEW_EDIT_CONTEXT_FONT_COLOR_PROPERTY] = g_param_spec_boxed ("font-color", "font-color", "font-color", gdk_rgba_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	composer_web_view_edit_context_font_family_map = _tmp0_;
	{
		const gchar** name_collection = NULL;
		gint name_collection_length1 = 0;
		gint _name_collection_size_ = 0;
		gint name_it = 0;
		name_collection = COMPOSER_WEB_VIEW_EDIT_CONTEXT_SANS_FAMILY_NAMES;
		name_collection_length1 = G_N_ELEMENTS (COMPOSER_WEB_VIEW_EDIT_CONTEXT_SANS_FAMILY_NAMES);
		for (name_it = 0; name_it < name_collection_length1; name_it = name_it + 1) {
			gchar* _tmp1_;
			gchar* name = NULL;
			_tmp1_ = g_strdup (name_collection[name_it]);
			name = _tmp1_;
			{
				GeeHashMap* _tmp2_;
				const gchar* _tmp3_;
				_tmp2_ = composer_web_view_edit_context_font_family_map;
				_tmp3_ = name;
				gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp3_, "sans");
				_g_free0 (name);
			}
		}
	}
	{
		const gchar** name_collection = NULL;
		gint name_collection_length1 = 0;
		gint _name_collection_size_ = 0;
		gint name_it = 0;
		name_collection = COMPOSER_WEB_VIEW_EDIT_CONTEXT_SERIF_FAMILY_NAMES;
		name_collection_length1 = G_N_ELEMENTS (COMPOSER_WEB_VIEW_EDIT_CONTEXT_SERIF_FAMILY_NAMES);
		for (name_it = 0; name_it < name_collection_length1; name_it = name_it + 1) {
			gchar* _tmp4_;
			gchar* name = NULL;
			_tmp4_ = g_strdup (name_collection[name_it]);
			name = _tmp4_;
			{
				GeeHashMap* _tmp5_;
				const gchar* _tmp6_;
				_tmp5_ = composer_web_view_edit_context_font_family_map;
				_tmp6_ = name;
				gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp6_, "serif");
				_g_free0 (name);
			}
		}
	}
	{
		const gchar** name_collection = NULL;
		gint name_collection_length1 = 0;
		gint _name_collection_size_ = 0;
		gint name_it = 0;
		name_collection = COMPOSER_WEB_VIEW_EDIT_CONTEXT_MONO_FAMILY_NAMES;
		name_collection_length1 = G_N_ELEMENTS (COMPOSER_WEB_VIEW_EDIT_CONTEXT_MONO_FAMILY_NAMES);
		for (name_it = 0; name_it < name_collection_length1; name_it = name_it + 1) {
			gchar* _tmp7_;
			gchar* name = NULL;
			_tmp7_ = g_strdup (name_collection[name_it]);
			name = _tmp7_;
			{
				GeeHashMap* _tmp8_;
				const gchar* _tmp9_;
				_tmp8_ = composer_web_view_edit_context_font_family_map;
				_tmp9_ = name;
				gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp9_, "monospace");
				_g_free0 (name);
			}
		}
	}
}

static void
composer_web_view_edit_context_instance_init (ComposerWebViewEditContext * self,
                                              gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	GdkRGBA _tmp2_ = {0};
	self->priv = composer_web_view_edit_context_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->_link_url = _tmp0_;
	_tmp1_ = g_strdup ("sans");
	self->priv->_font_family = _tmp1_;
	self->priv->_font_size = (guint) 12;
	util_gtk_rgba ((gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 1, &_tmp2_);
	self->priv->_font_color = _tmp2_;
	self->priv->context = (guint) 0;
}

static void
composer_web_view_edit_context_finalize (GObject * obj)
{
	ComposerWebViewEditContext * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, COMPOSER_WEB_VIEW_TYPE_EDIT_CONTEXT, ComposerWebViewEditContext);
	_g_free0 (self->priv->_link_url);
	_g_free0 (self->priv->_font_family);
	G_OBJECT_CLASS (composer_web_view_edit_context_parent_class)->finalize (obj);
}

/**
     * Encapsulates editing-related state for a specific DOM node.
     *
     * This must be kept in sync with the JS object of the same name.
     */
static GType
composer_web_view_edit_context_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ComposerWebViewEditContextClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) composer_web_view_edit_context_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ComposerWebViewEditContext), 0, (GInstanceInitFunc) composer_web_view_edit_context_instance_init, NULL };
	GType composer_web_view_edit_context_type_id;
	composer_web_view_edit_context_type_id = g_type_register_static (G_TYPE_OBJECT, "ComposerWebViewEditContext", &g_define_type_info, 0);
	ComposerWebViewEditContext_private_offset = g_type_add_instance_private (composer_web_view_edit_context_type_id, sizeof (ComposerWebViewEditContextPrivate));
	return composer_web_view_edit_context_type_id;
}

GType
composer_web_view_edit_context_get_type (void)
{
	static volatile gsize composer_web_view_edit_context_type_id__once = 0;
	if (g_once_init_enter (&composer_web_view_edit_context_type_id__once)) {
		GType composer_web_view_edit_context_type_id;
		composer_web_view_edit_context_type_id = composer_web_view_edit_context_get_type_once ();
		g_once_init_leave (&composer_web_view_edit_context_type_id__once, composer_web_view_edit_context_type_id);
	}
	return composer_web_view_edit_context_type_id__once;
}

static void
_vala_composer_web_view_edit_context_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec)
{
	ComposerWebViewEditContext * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, COMPOSER_WEB_VIEW_TYPE_EDIT_CONTEXT, ComposerWebViewEditContext);
	switch (property_id) {
		case COMPOSER_WEB_VIEW_EDIT_CONTEXT_IS_LINK_PROPERTY:
		g_value_set_boolean (value, composer_web_view_edit_context_get_is_link (self));
		break;
		case COMPOSER_WEB_VIEW_EDIT_CONTEXT_LINK_URL_PROPERTY:
		g_value_set_string (value, composer_web_view_edit_context_get_link_url (self));
		break;
		case COMPOSER_WEB_VIEW_EDIT_CONTEXT_FONT_FAMILY_PROPERTY:
		g_value_set_string (value, composer_web_view_edit_context_get_font_family (self));
		break;
		case COMPOSER_WEB_VIEW_EDIT_CONTEXT_FONT_SIZE_PROPERTY:
		g_value_set_uint (value, composer_web_view_edit_context_get_font_size (self));
		break;
		case COMPOSER_WEB_VIEW_EDIT_CONTEXT_FONT_COLOR_PROPERTY:
		{
			GdkRGBA boxed;
			composer_web_view_edit_context_get_font_color (self, &boxed);
			g_value_set_boxed (value, &boxed);
		}
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_composer_web_view_edit_context_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec)
{
	ComposerWebViewEditContext * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, COMPOSER_WEB_VIEW_TYPE_EDIT_CONTEXT, ComposerWebViewEditContext);
	switch (property_id) {
		case COMPOSER_WEB_VIEW_EDIT_CONTEXT_LINK_URL_PROPERTY:
		composer_web_view_edit_context_set_link_url (self, g_value_get_string (value));
		break;
		case COMPOSER_WEB_VIEW_EDIT_CONTEXT_FONT_FAMILY_PROPERTY:
		composer_web_view_edit_context_set_font_family (self, g_value_get_string (value));
		break;
		case COMPOSER_WEB_VIEW_EDIT_CONTEXT_FONT_SIZE_PROPERTY:
		composer_web_view_edit_context_set_font_size (self, g_value_get_uint (value));
		break;
		case COMPOSER_WEB_VIEW_EDIT_CONTEXT_FONT_COLOR_PROPERTY:
		composer_web_view_edit_context_set_font_color (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
composer_web_view_class_init (ComposerWebViewClass * klass,
                              gpointer klass_data)
{
	composer_web_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ComposerWebView_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_composer_web_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_composer_web_view_set_property;
	G_OBJECT_CLASS (klass)->finalize = composer_web_view_finalize;
	/**
	     * Determines if the body contains any non-boilerplate content.
	     *
	     * Currently, only a signatures are considered to be boilerplate.
	     * Any user-made changes or message body content from a
	     * forwarded/replied-to message present will make the view
	     * considered to be non-empty.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), COMPOSER_WEB_VIEW_IS_EMPTY_PROPERTY, composer_web_view_properties[COMPOSER_WEB_VIEW_IS_EMPTY_PROPERTY] = g_param_spec_boolean ("is-empty", "is-empty", "is-empty", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** Determines if the view is in rich text mode. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), COMPOSER_WEB_VIEW_IS_RICH_TEXT_PROPERTY, composer_web_view_properties[COMPOSER_WEB_VIEW_IS_RICH_TEXT_PROPERTY] = g_param_spec_boolean ("is-rich-text", "is-rich-text", "is-rich-text", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** Emitted when the cursor's edit context has changed. */
	composer_web_view_signals[COMPOSER_WEB_VIEW_CURSOR_CONTEXT_CHANGED_SIGNAL] = g_signal_new ("cursor-context-changed", COMPOSER_TYPE_WEB_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, COMPOSER_WEB_VIEW_TYPE_EDIT_CONTEXT);
	/** Emitted when an image file has been dropped on the composer */
	composer_web_view_signals[COMPOSER_WEB_VIEW_IMAGE_FILE_DROPPED_SIGNAL] = g_signal_new ("image-file-dropped", COMPOSER_TYPE_WEB_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING_POINTER_INT, G_TYPE_NONE, 4, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_POINTER, G_TYPE_INT);
}

static void
composer_web_view_instance_init (ComposerWebView * self,
                                 gpointer klass)
{
	self->priv = composer_web_view_get_instance_private (self);
	self->priv->_is_empty = TRUE;
	self->priv->_is_rich_text = TRUE;
}

static void
composer_web_view_finalize (GObject * obj)
{
	ComposerWebView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, COMPOSER_TYPE_WEB_VIEW, ComposerWebView);
	G_OBJECT_CLASS (composer_web_view_parent_class)->finalize (obj);
}

/**
 * A WebView for editing messages in the composer.
 */
static GType
composer_web_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ComposerWebViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) composer_web_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ComposerWebView), 0, (GInstanceInitFunc) composer_web_view_instance_init, NULL };
	GType composer_web_view_type_id;
	composer_web_view_type_id = g_type_register_static (COMPONENTS_TYPE_WEB_VIEW, "ComposerWebView", &g_define_type_info, 0);
	ComposerWebView_private_offset = g_type_add_instance_private (composer_web_view_type_id, sizeof (ComposerWebViewPrivate));
	return composer_web_view_type_id;
}

GType
composer_web_view_get_type (void)
{
	static volatile gsize composer_web_view_type_id__once = 0;
	if (g_once_init_enter (&composer_web_view_type_id__once)) {
		GType composer_web_view_type_id;
		composer_web_view_type_id = composer_web_view_get_type_once ();
		g_once_init_leave (&composer_web_view_type_id__once, composer_web_view_type_id);
	}
	return composer_web_view_type_id__once;
}

static void
_vala_composer_web_view_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	ComposerWebView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, COMPOSER_TYPE_WEB_VIEW, ComposerWebView);
	switch (property_id) {
		case COMPOSER_WEB_VIEW_IS_EMPTY_PROPERTY:
		g_value_set_boolean (value, composer_web_view_get_is_empty (self));
		break;
		case COMPOSER_WEB_VIEW_IS_RICH_TEXT_PROPERTY:
		g_value_set_boolean (value, composer_web_view_get_is_rich_text (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_composer_web_view_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	ComposerWebView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, COMPOSER_TYPE_WEB_VIEW, ComposerWebView);
	switch (property_id) {
		case COMPOSER_WEB_VIEW_IS_EMPTY_PROPERTY:
		composer_web_view_set_is_empty (self, g_value_get_boolean (value));
		break;
		case COMPOSER_WEB_VIEW_IS_RICH_TEXT_PROPERTY:
		composer_web_view_set_is_rich_text (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

