/* application-contact.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from application-contact.vala, do not modify */

/*
 * Copyright 2019 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-client-46.0.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include "geary-engine.h"
#include <folks/folks.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	APPLICATION_CONTACT_0_PROPERTY,
	APPLICATION_CONTACT_DISPLAY_NAME_PROPERTY,
	APPLICATION_CONTACT_AVATAR_PROPERTY,
	APPLICATION_CONTACT_DISPLAY_NAME_IS_EMAIL_PROPERTY,
	APPLICATION_CONTACT_IS_DESKTOP_CONTACT_PROPERTY,
	APPLICATION_CONTACT_IS_TRUSTED_PROPERTY,
	APPLICATION_CONTACT_IS_FAVOURITE_PROPERTY,
	APPLICATION_CONTACT_LOAD_REMOTE_RESOURCES_PROPERTY,
	APPLICATION_CONTACT_EMAIL_ADDRESSES_PROPERTY,
	APPLICATION_CONTACT_INDIVIDUAL_PROPERTY,
	APPLICATION_CONTACT_NUM_PROPERTIES
};
static GParamSpec* application_contact_properties[APPLICATION_CONTACT_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _ApplicationContactSaveToDesktopData ApplicationContactSaveToDesktopData;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _ApplicationContactOpenOnDesktopData ApplicationContactOpenOnDesktopData;
typedef struct _ApplicationContactSetRemoteResourceLoadingData ApplicationContactSetRemoteResourceLoadingData;
typedef struct _ApplicationContactSetFavouriteData ApplicationContactSetFavouriteData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ApplicationContactUpdateReplacementData ApplicationContactUpdateReplacementData;
enum  {
	APPLICATION_CONTACT_CHANGED_SIGNAL,
	APPLICATION_CONTACT_NUM_SIGNALS
};
static guint application_contact_signals[APPLICATION_CONTACT_NUM_SIGNALS] = {0};

struct _ApplicationContactPrivate {
	gchar* _display_name;
	gboolean _display_name_is_email;
	gboolean _is_desktop_contact;
	gboolean _is_trusted;
	gboolean _is_favourite;
	gboolean _load_remote_resources;
	GeeCollection* _email_addresses;
	FolksIndividual* _individual;
	GearyContact* engine;
	ApplicationContactStore* store;
};

struct _ApplicationContactSaveToDesktopData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ApplicationContact* self;
	GCancellable* cancellable;
	FolksPersona* persona;
	ApplicationContactStore* contacts;
	ApplicationContactStore* _tmp0_;
	ApplicationContactStore* _tmp1_;
	ApplicationContactStore* _tmp2_;
	FolksPersonaStore* personas;
	ApplicationContactStore* _tmp3_;
	FolksIndividualAggregator* _tmp4_;
	FolksPersonaStore* _tmp5_;
	FolksPersonaStore* _tmp6_;
	FolksPersonaStore* _tmp7_;
	gboolean _tmp8_;
	FolksPersonaStore* _tmp9_;
	FolksPersonaStore* _tmp10_;
	FolksMaybeBool _tmp11_;
	FolksMaybeBool _tmp12_;
	GHashTable* details;
	GHashFunc _tmp13_;
	GEqualFunc _tmp14_;
	GHashTable* _tmp15_;
	GValue name_value;
	GValue _tmp16_;
	const gchar* _tmp17_;
	GHashTable* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	GValue _tmp21_;
	GValue _tmp22_;
	GValue* _tmp23_;
	GeeSet* email_addresses;
	GeeHashSet* _tmp24_;
	GValue email_value;
	GValue _tmp25_;
	GeeIterator* _addr_it;
	GeeCollection* _tmp26_;
	GeeCollection* _tmp27_;
	GeeIterator* _tmp28_;
	GeeIterator* _tmp29_;
	GearyRFC822MailboxAddress* addr;
	GeeIterator* _tmp30_;
	gpointer _tmp31_;
	GeeSet* _tmp32_;
	GearyRFC822MailboxAddress* _tmp33_;
	const gchar* _tmp34_;
	const gchar* _tmp35_;
	FolksEmailFieldDetails* _tmp36_;
	FolksEmailFieldDetails* _tmp37_;
	GeeSet* _tmp38_;
	GHashTable* _tmp39_;
	const gchar* _tmp40_;
	gchar* _tmp41_;
	GValue _tmp42_;
	GValue _tmp43_;
	GValue* _tmp44_;
	FolksPersona* _tmp45_;
	FolksPersonaStore* _tmp46_;
	GHashTable* _tmp47_;
	FolksPersona* _tmp48_;
	FolksPersona* _tmp49_;
	FolksPersona* _tmp50_;
	GError* _tmp51_;
	FolksIndividual* individual;
	FolksPersona* _tmp52_;
	FolksIndividual* _tmp53_;
	FolksIndividual* _tmp54_;
	FolksIndividual* _tmp55_;
	FolksIndividual* _tmp56_;
	GError* _tmp57_;
	FolksIndividual* _tmp58_;
	GError* _inner_error0_;
};

struct _ApplicationContactOpenOnDesktopData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ApplicationContact* self;
	GCancellable* cancellable;
	GDBusConnection* dbus;
	GDBusConnection* _tmp0_;
	GDBusActionGroup* contacts;
	GDBusActionGroup* _tmp1_;
	GDBusActionGroup* _tmp2_;
	FolksIndividual* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GVariant* _tmp6_;
	GVariant* _tmp7_;
	GError* _inner_error0_;
};

struct _ApplicationContactSetRemoteResourceLoadingData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ApplicationContact* self;
	gboolean enabled;
	GCancellable* cancellable;
	ApplicationContactStore* store;
	ApplicationContactStore* _tmp0_;
	ApplicationContactStore* _tmp1_;
	ApplicationContactStore* _tmp2_;
	GeeCollection* contacts;
	GeeLinkedList* _tmp3_;
	GeeIterator* _mailbox_it;
	GeeCollection* _tmp4_;
	GeeCollection* _tmp5_;
	GeeIterator* _tmp6_;
	GeeIterator* _tmp7_;
	GearyRFC822MailboxAddress* mailbox;
	GeeIterator* _tmp8_;
	gpointer _tmp9_;
	GearyContact* contact;
	ApplicationContactStore* _tmp10_;
	GearyRFC822MailboxAddress* _tmp11_;
	GearyContact* _tmp12_;
	GearyContact* _tmp13_;
	GearyContactFlags* _tmp14_;
	GearyContactFlags* _tmp15_;
	GearyNamedFlag* _tmp16_;
	GearyNamedFlag* _tmp17_;
	GearyContact* _tmp18_;
	GearyContactFlags* _tmp19_;
	GearyContactFlags* _tmp20_;
	GearyNamedFlag* _tmp21_;
	GearyNamedFlag* _tmp22_;
	GeeCollection* _tmp23_;
	GearyContact* _tmp24_;
	ApplicationContactStore* _tmp25_;
	GearyAccount* _tmp26_;
	GearyAccount* _tmp27_;
	GearyContactStore* _tmp28_;
	GearyContactStore* _tmp29_;
	GeeCollection* _tmp30_;
	GError* _inner_error0_;
};

struct _ApplicationContactSetFavouriteData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ApplicationContact* self;
	gboolean is_favourite;
	GCancellable* cancellable;
	FolksIndividual* _tmp0_;
	GError* _inner_error0_;
};

struct _ApplicationContactUpdateReplacementData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ApplicationContact* self;
	FolksIndividual* replacement;
	ApplicationContactStore* store;
	ApplicationContactStore* _tmp0_;
	ApplicationContactStore* _tmp1_;
	ApplicationContactStore* _tmp2_;
	FolksIndividual* _tmp3_;
	ApplicationContactStore* _tmp4_;
	FolksIndividualAggregator* _tmp5_;
	FolksIndividual* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	FolksIndividual* _tmp9_;
	GError* err;
	FolksIndividual* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	GError* _tmp14_;
	const gchar* _tmp15_;
	GError* _inner_error0_;
};

static gint ApplicationContact_private_offset;
static gpointer application_contact_parent_class = NULL;

static void application_contact_update_from_individual (ApplicationContact* self,
                                                 FolksIndividual* replacement);
static void application_contact_on_engine_flags_changed (ApplicationContact* self);
static void _application_contact_on_engine_flags_changed_geary_named_flags_added (GearyNamedFlags* _sender,
                                                                           GeeCollection* flags,
                                                                           gpointer self);
static void _application_contact_on_engine_flags_changed_geary_named_flags_removed (GearyNamedFlags* _sender,
                                                                             GeeCollection* flags,
                                                                             gpointer self);
static void application_contact_set_display_name (ApplicationContact* self,
                                           const gchar* value);
VALA_EXTERN FolksIndividual* application_contact_get_individual (ApplicationContact* self);
static void application_contact_set_display_name_is_email (ApplicationContact* self,
                                                    gboolean value);
static void application_contact_set_is_desktop_contact (ApplicationContact* self,
                                                 gboolean value);
static void application_contact_set_is_trusted (ApplicationContact* self,
                                         gboolean value);
static void application_contact_set_is_favourite (ApplicationContact* self,
                                           gboolean value);
static void application_contact_set_load_remote_resources (ApplicationContact* self,
                                                    gboolean value);
static void application_contact_set_individual (ApplicationContact* self,
                                         FolksIndividual* value);
static ApplicationContact* application_contact_new (ApplicationContactStore* store,
                                             FolksIndividual* source);
static ApplicationContact* application_contact_construct (GType object_type,
                                                   ApplicationContactStore* store,
                                                   FolksIndividual* source);
static void application_contact_update (ApplicationContact* self);
VALA_EXTERN ApplicationContact* application_contact_new_for_folks (ApplicationContactStore* store,
                                                       FolksIndividual* source);
VALA_EXTERN ApplicationContact* application_contact_construct_for_folks (GType object_type,
                                                             ApplicationContactStore* store,
                                                             FolksIndividual* source);
VALA_EXTERN ApplicationContact* application_contact_new_for_engine (ApplicationContactStore* store,
                                                        const gchar* display_name,
                                                        GearyContact* source);
VALA_EXTERN ApplicationContact* application_contact_construct_for_engine (GType object_type,
                                                              ApplicationContactStore* store,
                                                              const gchar* display_name,
                                                              GearyContact* source);
static void application_contact_update_name (ApplicationContact* self,
                                      const gchar* name);
static void application_contact_update_from_engine (ApplicationContact* self);
static void application_contact_save_to_desktop_data_free (gpointer _data);
static gboolean application_contact_save_to_desktop_co (ApplicationContactSaveToDesktopData* _data_);
static void _g_free0_ (gpointer var);
static void _vala_GValue_free (GValue* self);
static void __vala_GValue_free0_ (gpointer var);
static GValue* _g_value_dup (GValue* self);
static void application_contact_save_to_desktop_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_);
static void application_contact_open_on_desktop_data_free (gpointer _data);
static gboolean application_contact_open_on_desktop_co (ApplicationContactOpenOnDesktopData* _data_);
static void application_contact_open_on_desktop_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_);
static void application_contact_set_remote_resource_loading_data_free (gpointer _data);
static gboolean application_contact_set_remote_resource_loading_co (ApplicationContactSetRemoteResourceLoadingData* _data_);
VALA_EXTERN void application_contact_store_lookup_engine_contact (ApplicationContactStore* self,
                                                      GearyRFC822MailboxAddress* mailbox,
                                                      GCancellable* cancellable,
                                                      GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_);
VALA_EXTERN GearyContact* application_contact_store_lookup_engine_contact_finish (ApplicationContactStore* self,
                                                                      GAsyncResult* _res_,
                                                                      GError** error);
static void application_contact_set_remote_resource_loading_ready (GObject* source_object,
                                                            GAsyncResult* _res_,
                                                            gpointer _user_data_);
static void application_contact_set_favourite_data_free (gpointer _data);
static gboolean application_contact_set_favourite_co (ApplicationContactSetFavouriteData* _data_);
static void application_contact_set_favourite_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_);
static void application_contact_on_individual_avatar_notify (ApplicationContact* self);
static void _application_contact_on_individual_avatar_notify_g_object_notify (GObject* _sender,
                                                                       GParamSpec* pspec,
                                                                       gpointer self);
static void application_contact_on_individual_notify (ApplicationContact* self);
static void _application_contact_on_individual_notify_g_object_notify (GObject* _sender,
                                                                GParamSpec* pspec,
                                                                gpointer self);
static void application_contact_on_individual_removed (ApplicationContact* self,
                                                FolksIndividual* replacement);
static void _application_contact_on_individual_removed_folks_individual_removed (FolksIndividual* _sender,
                                                                          FolksIndividual* replacement_individual,
                                                                          gpointer self);
static void application_contact_update_replacement_data_free (gpointer _data);
static void application_contact_update_replacement (ApplicationContact* self,
                                             FolksIndividual* replacement,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
static void application_contact_update_replacement_finish (ApplicationContact* self,
                                                    GAsyncResult* _res_);
static gboolean application_contact_update_replacement_co (ApplicationContactUpdateReplacementData* _data_);
static void application_contact_update_replacement_ready (GObject* source_object,
                                                   GAsyncResult* _res_,
                                                   gpointer _user_data_);
static void application_contact_finalize (GObject * obj);
static GType application_contact_get_type_once (void);
static void _vala_application_contact_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_application_contact_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);

static inline gpointer
application_contact_get_instance_private (ApplicationContact* self)
{
	return G_STRUCT_MEMBER_P (self, ApplicationContact_private_offset);
}

static void
_application_contact_on_engine_flags_changed_geary_named_flags_added (GearyNamedFlags* _sender,
                                                                      GeeCollection* flags,
                                                                      gpointer self)
{
	application_contact_on_engine_flags_changed ((ApplicationContact*) self);
}

static void
_application_contact_on_engine_flags_changed_geary_named_flags_removed (GearyNamedFlags* _sender,
                                                                        GeeCollection* flags,
                                                                        gpointer self)
{
	application_contact_on_engine_flags_changed ((ApplicationContact*) self);
}

const gchar*
application_contact_get_display_name (ApplicationContact* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (APPLICATION_IS_CONTACT (self), NULL);
	_tmp0_ = self->priv->_display_name;
	result = _tmp0_;
	return result;
}

static void
application_contact_set_display_name (ApplicationContact* self,
                                      const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (APPLICATION_IS_CONTACT (self));
	old_value = application_contact_get_display_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_display_name);
		self->priv->_display_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, application_contact_properties[APPLICATION_CONTACT_DISPLAY_NAME_PROPERTY]);
	}
}

GLoadableIcon*
application_contact_get_avatar (ApplicationContact* self)
{
	GLoadableIcon* result;
	FolksIndividual* _tmp0_;
	g_return_val_if_fail (APPLICATION_IS_CONTACT (self), NULL);
	_tmp0_ = self->priv->_individual;
	if (_tmp0_ != NULL) {
		FolksIndividual* _tmp1_;
		GLoadableIcon* _tmp2_;
		GLoadableIcon* _tmp3_;
		_tmp1_ = self->priv->_individual;
		_tmp2_ = folks_avatar_details_get_avatar (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, FOLKS_TYPE_AVATAR_DETAILS, FolksAvatarDetails));
		_tmp3_ = _tmp2_;
		result = _tmp3_;
		return result;
	} else {
		result = NULL;
		return result;
	}
}

gboolean
application_contact_get_display_name_is_email (ApplicationContact* self)
{
	gboolean result;
	g_return_val_if_fail (APPLICATION_IS_CONTACT (self), FALSE);
	result = self->priv->_display_name_is_email;
	return result;
}

static void
application_contact_set_display_name_is_email (ApplicationContact* self,
                                               gboolean value)
{
	gboolean old_value;
	g_return_if_fail (APPLICATION_IS_CONTACT (self));
	old_value = application_contact_get_display_name_is_email (self);
	if (old_value != value) {
		self->priv->_display_name_is_email = value;
		g_object_notify_by_pspec ((GObject *) self, application_contact_properties[APPLICATION_CONTACT_DISPLAY_NAME_IS_EMAIL_PROPERTY]);
	}
}

gboolean
application_contact_get_is_desktop_contact (ApplicationContact* self)
{
	gboolean result;
	g_return_val_if_fail (APPLICATION_IS_CONTACT (self), FALSE);
	result = self->priv->_is_desktop_contact;
	return result;
}

static void
application_contact_set_is_desktop_contact (ApplicationContact* self,
                                            gboolean value)
{
	gboolean old_value;
	g_return_if_fail (APPLICATION_IS_CONTACT (self));
	old_value = application_contact_get_is_desktop_contact (self);
	if (old_value != value) {
		self->priv->_is_desktop_contact = value;
		g_object_notify_by_pspec ((GObject *) self, application_contact_properties[APPLICATION_CONTACT_IS_DESKTOP_CONTACT_PROPERTY]);
	}
}

gboolean
application_contact_get_is_trusted (ApplicationContact* self)
{
	gboolean result;
	g_return_val_if_fail (APPLICATION_IS_CONTACT (self), FALSE);
	result = self->priv->_is_trusted;
	return result;
}

static void
application_contact_set_is_trusted (ApplicationContact* self,
                                    gboolean value)
{
	gboolean old_value;
	g_return_if_fail (APPLICATION_IS_CONTACT (self));
	old_value = application_contact_get_is_trusted (self);
	if (old_value != value) {
		self->priv->_is_trusted = value;
		g_object_notify_by_pspec ((GObject *) self, application_contact_properties[APPLICATION_CONTACT_IS_TRUSTED_PROPERTY]);
	}
}

gboolean
application_contact_get_is_favourite (ApplicationContact* self)
{
	gboolean result;
	g_return_val_if_fail (APPLICATION_IS_CONTACT (self), FALSE);
	result = self->priv->_is_favourite;
	return result;
}

static void
application_contact_set_is_favourite (ApplicationContact* self,
                                      gboolean value)
{
	gboolean old_value;
	g_return_if_fail (APPLICATION_IS_CONTACT (self));
	old_value = application_contact_get_is_favourite (self);
	if (old_value != value) {
		self->priv->_is_favourite = value;
		g_object_notify_by_pspec ((GObject *) self, application_contact_properties[APPLICATION_CONTACT_IS_FAVOURITE_PROPERTY]);
	}
}

gboolean
application_contact_get_load_remote_resources (ApplicationContact* self)
{
	gboolean result;
	g_return_val_if_fail (APPLICATION_IS_CONTACT (self), FALSE);
	result = self->priv->_load_remote_resources;
	return result;
}

static void
application_contact_set_load_remote_resources (ApplicationContact* self,
                                               gboolean value)
{
	gboolean old_value;
	g_return_if_fail (APPLICATION_IS_CONTACT (self));
	old_value = application_contact_get_load_remote_resources (self);
	if (old_value != value) {
		self->priv->_load_remote_resources = value;
		g_object_notify_by_pspec ((GObject *) self, application_contact_properties[APPLICATION_CONTACT_LOAD_REMOTE_RESOURCES_PROPERTY]);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GeeCollection*
application_contact_get_email_addresses (ApplicationContact* self)
{
	GeeCollection* result;
	GeeCollection* addrs = NULL;
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	GeeCollection* _tmp20_;
	g_return_val_if_fail (APPLICATION_IS_CONTACT (self), NULL);
	_tmp0_ = self->priv->_email_addresses;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	addrs = _tmp1_;
	_tmp2_ = addrs;
	if (_tmp2_ == NULL) {
		GeeLinkedList* _tmp3_;
		GeeCollection* _tmp18_;
		GeeCollection* _tmp19_;
		_tmp3_ = gee_linked_list_new (GEARY_RF_C822_TYPE_MAILBOX_ADDRESS, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
		_g_object_unref0 (addrs);
		addrs = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection);
		{
			GeeIterator* _email_it = NULL;
			FolksIndividual* _tmp4_;
			GeeSet* _tmp5_;
			GeeSet* _tmp6_;
			GeeIterator* _tmp7_;
			_tmp4_ = self->priv->_individual;
			_tmp5_ = folks_email_details_get_email_addresses (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, FOLKS_TYPE_EMAIL_DETAILS, FolksEmailDetails));
			_tmp6_ = _tmp5_;
			_tmp7_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ITERABLE, GeeIterable));
			_email_it = _tmp7_;
			while (TRUE) {
				GeeIterator* _tmp8_;
				FolksEmailFieldDetails* email = NULL;
				GeeIterator* _tmp9_;
				gpointer _tmp10_;
				GeeCollection* _tmp11_;
				const gchar* _tmp12_;
				FolksEmailFieldDetails* _tmp13_;
				gconstpointer _tmp14_;
				gconstpointer _tmp15_;
				GearyRFC822MailboxAddress* _tmp16_;
				GearyRFC822MailboxAddress* _tmp17_;
				_tmp8_ = _email_it;
				if (!gee_iterator_next (_tmp8_)) {
					break;
				}
				_tmp9_ = _email_it;
				_tmp10_ = gee_iterator_get (_tmp9_);
				email = (FolksEmailFieldDetails*) _tmp10_;
				_tmp11_ = addrs;
				_tmp12_ = self->priv->_display_name;
				_tmp13_ = email;
				_tmp14_ = folks_abstract_field_details_get_value (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetails));
				_tmp15_ = _tmp14_;
				_tmp16_ = geary_rf_c822_mailbox_address_new (_tmp12_, (const gchar*) _tmp15_);
				_tmp17_ = _tmp16_;
				gee_collection_add (_tmp11_, _tmp17_);
				_g_object_unref0 (_tmp17_);
				_g_object_unref0 (email);
			}
			_g_object_unref0 (_email_it);
		}
		_tmp18_ = addrs;
		_tmp19_ = _g_object_ref0 (_tmp18_);
		_g_object_unref0 (self->priv->_email_addresses);
		self->priv->_email_addresses = _tmp19_;
	}
	_tmp20_ = self->priv->_email_addresses;
	result = _tmp20_;
	_g_object_unref0 (addrs);
	return result;
}

FolksIndividual*
application_contact_get_individual (ApplicationContact* self)
{
	FolksIndividual* result;
	FolksIndividual* _tmp0_;
	g_return_val_if_fail (APPLICATION_IS_CONTACT (self), NULL);
	_tmp0_ = self->priv->_individual;
	result = _tmp0_;
	return result;
}

static void
application_contact_set_individual (ApplicationContact* self,
                                    FolksIndividual* value)
{
	FolksIndividual* old_value;
	g_return_if_fail (APPLICATION_IS_CONTACT (self));
	old_value = application_contact_get_individual (self);
	if (old_value != value) {
		FolksIndividual* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_individual);
		self->priv->_individual = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, application_contact_properties[APPLICATION_CONTACT_INDIVIDUAL_PROPERTY]);
	}
}

static ApplicationContact*
application_contact_construct (GType object_type,
                               ApplicationContactStore* store,
                               FolksIndividual* source)
{
	ApplicationContact * self = NULL;
	g_return_val_if_fail (APPLICATION_IS_CONTACT_STORE (store), NULL);
	g_return_val_if_fail ((source == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (source, FOLKS_TYPE_INDIVIDUAL), NULL);
	self = (ApplicationContact*) geary_base_object_construct (object_type);
	self->priv->store = store;
	application_contact_update_from_individual (self, source);
	application_contact_update (self);
	return self;
}

static ApplicationContact*
application_contact_new (ApplicationContactStore* store,
                         FolksIndividual* source)
{
	return application_contact_construct (APPLICATION_TYPE_CONTACT, store, source);
}

ApplicationContact*
application_contact_construct_for_folks (GType object_type,
                                         ApplicationContactStore* store,
                                         FolksIndividual* source)
{
	ApplicationContact * self = NULL;
	g_return_val_if_fail (APPLICATION_IS_CONTACT_STORE (store), NULL);
	g_return_val_if_fail ((source == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (source, FOLKS_TYPE_INDIVIDUAL), NULL);
	self = (ApplicationContact*) application_contact_construct (object_type, store, source);
	return self;
}

ApplicationContact*
application_contact_new_for_folks (ApplicationContactStore* store,
                                   FolksIndividual* source)
{
	return application_contact_construct_for_folks (APPLICATION_TYPE_CONTACT, store, source);
}

ApplicationContact*
application_contact_construct_for_engine (GType object_type,
                                          ApplicationContactStore* store,
                                          const gchar* display_name,
                                          GearyContact* source)
{
	ApplicationContact * self = NULL;
	GearyContact* _tmp0_;
	GearyContact* _tmp1_;
	GearyContactFlags* _tmp2_;
	GearyContactFlags* _tmp3_;
	GearyContact* _tmp4_;
	GearyContactFlags* _tmp5_;
	GearyContactFlags* _tmp6_;
	g_return_val_if_fail (APPLICATION_IS_CONTACT_STORE (store), NULL);
	g_return_val_if_fail (display_name != NULL, NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (source, GEARY_TYPE_CONTACT), NULL);
	self = (ApplicationContact*) application_contact_construct (object_type, store, NULL);
	_tmp0_ = _g_object_ref0 (source);
	_g_object_unref0 (self->priv->engine);
	self->priv->engine = _tmp0_;
	_tmp1_ = self->priv->engine;
	_tmp2_ = geary_contact_get_flags (_tmp1_);
	_tmp3_ = _tmp2_;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEARY_TYPE_NAMED_FLAGS, GearyNamedFlags), "added", (GCallback) _application_contact_on_engine_flags_changed_geary_named_flags_added, self, 0);
	_tmp4_ = self->priv->engine;
	_tmp5_ = geary_contact_get_flags (_tmp4_);
	_tmp6_ = _tmp5_;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEARY_TYPE_NAMED_FLAGS, GearyNamedFlags), "removed", (GCallback) _application_contact_on_engine_flags_changed_geary_named_flags_removed, self, 0);
	application_contact_update_name (self, display_name);
	application_contact_update_from_engine (self);
	return self;
}

ApplicationContact*
application_contact_new_for_engine (ApplicationContactStore* store,
                                    const gchar* display_name,
                                    GearyContact* source)
{
	return application_contact_construct_for_engine (APPLICATION_TYPE_CONTACT, store, display_name, source);
}

/**
     * Determines if this contact is equal to another.
     *
     * Returns true if the other contact has the same Folks
     * individual, engine contact, or if none of the above display
     * name.
     */
gboolean
application_contact_equal_to (ApplicationContact* self,
                              ApplicationContact* other)
{
	FolksIndividual* _tmp0_;
	gboolean _tmp9_ = FALSE;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gboolean result;
	g_return_val_if_fail (APPLICATION_IS_CONTACT (self), FALSE);
	g_return_val_if_fail ((other == NULL) || APPLICATION_IS_CONTACT (other), FALSE);
	if (other == NULL) {
		result = FALSE;
		return result;
	}
	if (self == other) {
		result = TRUE;
		return result;
	}
	_tmp0_ = self->priv->_individual;
	if (_tmp0_ != NULL) {
		gboolean _tmp1_ = FALSE;
		FolksIndividual* _tmp2_;
		_tmp2_ = other->priv->_individual;
		if (_tmp2_ != NULL) {
			FolksIndividual* _tmp3_;
			const gchar* _tmp4_;
			const gchar* _tmp5_;
			FolksIndividual* _tmp6_;
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			_tmp3_ = self->priv->_individual;
			_tmp4_ = folks_individual_get_id (_tmp3_);
			_tmp5_ = _tmp4_;
			_tmp6_ = other->priv->_individual;
			_tmp7_ = folks_individual_get_id (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp1_ = g_strcmp0 (_tmp5_, _tmp8_) == 0;
		} else {
			_tmp1_ = FALSE;
		}
		result = _tmp1_;
		return result;
	}
	_tmp10_ = self->priv->_display_name;
	_tmp11_ = other->priv->_display_name;
	if (g_strcmp0 (_tmp10_, _tmp11_) != 0) {
		_tmp9_ = TRUE;
	} else {
		GeeCollection* _tmp12_;
		GeeCollection* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		GeeCollection* _tmp16_;
		GeeCollection* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		_tmp12_ = application_contact_get_email_addresses (self);
		_tmp13_ = _tmp12_;
		_tmp14_ = gee_collection_get_size (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = application_contact_get_email_addresses (other);
		_tmp17_ = _tmp16_;
		_tmp18_ = gee_collection_get_size (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp9_ = _tmp15_ != _tmp19_;
	}
	if (_tmp9_) {
		result = FALSE;
		return result;
	}
	{
		GeeIterator* _this_addr_it = NULL;
		GeeCollection* _tmp20_;
		GeeCollection* _tmp21_;
		GeeIterator* _tmp22_;
		_tmp20_ = application_contact_get_email_addresses (self);
		_tmp21_ = _tmp20_;
		_tmp22_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, GEE_TYPE_ITERABLE, GeeIterable));
		_this_addr_it = _tmp22_;
		while (TRUE) {
			GeeIterator* _tmp23_;
			GearyRFC822MailboxAddress* this_addr = NULL;
			GeeIterator* _tmp24_;
			gpointer _tmp25_;
			gboolean found = FALSE;
			_tmp23_ = _this_addr_it;
			if (!gee_iterator_next (_tmp23_)) {
				break;
			}
			_tmp24_ = _this_addr_it;
			_tmp25_ = gee_iterator_get (_tmp24_);
			this_addr = (GearyRFC822MailboxAddress*) _tmp25_;
			found = FALSE;
			{
				GeeIterator* _other_addr_it = NULL;
				GeeCollection* _tmp26_;
				GeeCollection* _tmp27_;
				GeeIterator* _tmp28_;
				_tmp26_ = application_contact_get_email_addresses (other);
				_tmp27_ = _tmp26_;
				_tmp28_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, GEE_TYPE_ITERABLE, GeeIterable));
				_other_addr_it = _tmp28_;
				while (TRUE) {
					GeeIterator* _tmp29_;
					GearyRFC822MailboxAddress* other_addr = NULL;
					GeeIterator* _tmp30_;
					gpointer _tmp31_;
					GearyRFC822MailboxAddress* _tmp32_;
					GearyRFC822MailboxAddress* _tmp33_;
					_tmp29_ = _other_addr_it;
					if (!gee_iterator_next (_tmp29_)) {
						break;
					}
					_tmp30_ = _other_addr_it;
					_tmp31_ = gee_iterator_get (_tmp30_);
					other_addr = (GearyRFC822MailboxAddress*) _tmp31_;
					_tmp32_ = this_addr;
					_tmp33_ = other_addr;
					if (gee_hashable_equal_to (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, GEE_TYPE_HASHABLE, GeeHashable), _tmp33_)) {
						found = TRUE;
						_g_object_unref0 (other_addr);
						break;
					}
					_g_object_unref0 (other_addr);
				}
				_g_object_unref0 (_other_addr_it);
			}
			if (!found) {
				result = FALSE;
				_g_object_unref0 (this_addr);
				_g_object_unref0 (_this_addr_it);
				return result;
			}
			_g_object_unref0 (this_addr);
		}
		_g_object_unref0 (_this_addr_it);
	}
	result = TRUE;
	return result;
}

static void
application_contact_save_to_desktop_data_free (gpointer _data)
{
	ApplicationContactSaveToDesktopData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (ApplicationContactSaveToDesktopData, _data_);
}

void
application_contact_save_to_desktop (ApplicationContact* self,
                                     GCancellable* cancellable,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	ApplicationContactSaveToDesktopData* _data_;
	ApplicationContact* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (APPLICATION_IS_CONTACT (self));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (ApplicationContactSaveToDesktopData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, application_contact_save_to_desktop_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	application_contact_save_to_desktop_co (_data_);
}

void
application_contact_save_to_desktop_finish (ApplicationContact* self,
                                            GAsyncResult* _res_,
                                            GError** error)
{
	ApplicationContactSaveToDesktopData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/** Invokes the desktop contacts application to save this contact. */
static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_vala_GValue_free (GValue* self)
{
	g_boxed_free (G_TYPE_VALUE, self);
}

static void
__vala_GValue_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL));
}

static GValue*
_g_value_dup (GValue* self)
{
	return g_boxed_copy (G_TYPE_VALUE, self);
}

static gpointer
__g_value_dup0 (gpointer self)
{
	return self ? _g_value_dup (self) : NULL;
}

static void
application_contact_save_to_desktop_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_)
{
	ApplicationContactSaveToDesktopData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	application_contact_save_to_desktop_co (_data_);
}

static gboolean
application_contact_save_to_desktop_co (ApplicationContactSaveToDesktopData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->persona = NULL;
	_data_->_tmp0_ = _data_->self->priv->store;
	_data_->_tmp1_ = _g_object_ref0 (_data_->_tmp0_);
	_data_->contacts = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->contacts;
	if (_data_->_tmp2_ != NULL) {
		_data_->_tmp3_ = _data_->contacts;
		_data_->_tmp4_ = _data_->_tmp3_->individuals;
		_data_->_tmp5_ = folks_individual_aggregator_get_primary_store (_data_->_tmp4_);
		_data_->_tmp6_ = _data_->_tmp5_;
		_data_->_tmp7_ = _g_object_ref0 (_data_->_tmp6_);
		_data_->personas = _data_->_tmp7_;
		_data_->_tmp9_ = _data_->personas;
		if (_data_->_tmp9_ != NULL) {
			_data_->_tmp10_ = _data_->personas;
			_data_->_tmp11_ = folks_persona_store_get_can_add_personas (_data_->_tmp10_);
			_data_->_tmp12_ = _data_->_tmp11_;
			_data_->_tmp8_ = _data_->_tmp12_ == FOLKS_MAYBE_BOOL_TRUE;
		} else {
			_data_->_tmp8_ = FALSE;
		}
		if (_data_->_tmp8_) {
			_data_->_tmp13_ = g_str_hash;
			_data_->_tmp14_ = g_str_equal;
			_data_->_tmp15_ = g_hash_table_new_full (_data_->_tmp13_, _data_->_tmp14_, _g_free0_, __vala_GValue_free0_);
			_data_->details = _data_->_tmp15_;
			memset (&_data_->_tmp16_, 0, sizeof (GValue));
			g_value_init (&_data_->_tmp16_, G_TYPE_STRING);
			_data_->name_value = _data_->_tmp16_;
			_data_->_tmp17_ = _data_->self->priv->_display_name;
			g_value_set_string (&_data_->name_value, _data_->_tmp17_);
			_data_->_tmp18_ = _data_->details;
			_data_->_tmp19_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_FULL_NAME);
			_data_->_tmp20_ = g_strdup (_data_->_tmp19_);
			_data_->_tmp21_ = _data_->name_value;
			_data_->_tmp22_ = _data_->_tmp21_;
			_data_->_tmp23_ = __g_value_dup0 (&_data_->_tmp22_);
			g_hash_table_insert (_data_->_tmp18_, _data_->_tmp20_, _data_->_tmp23_);
			_data_->_tmp24_ = gee_hash_set_new (FOLKS_TYPE_EMAIL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
			_data_->email_addresses = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp24_, GEE_TYPE_SET, GeeSet);
			memset (&_data_->_tmp25_, 0, sizeof (GValue));
			g_value_init (&_data_->_tmp25_, GEE_TYPE_SET);
			_data_->email_value = _data_->_tmp25_;
			{
				_data_->_tmp26_ = application_contact_get_email_addresses (_data_->self);
				_data_->_tmp27_ = _data_->_tmp26_;
				_data_->_tmp28_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp27_, GEE_TYPE_ITERABLE, GeeIterable));
				_data_->_addr_it = _data_->_tmp28_;
				while (TRUE) {
					_data_->_tmp29_ = _data_->_addr_it;
					if (!gee_iterator_next (_data_->_tmp29_)) {
						break;
					}
					_data_->_tmp30_ = _data_->_addr_it;
					_data_->_tmp31_ = gee_iterator_get (_data_->_tmp30_);
					_data_->addr = (GearyRFC822MailboxAddress*) _data_->_tmp31_;
					_data_->_tmp32_ = _data_->email_addresses;
					_data_->_tmp33_ = _data_->addr;
					_data_->_tmp34_ = geary_rf_c822_mailbox_address_get_address (_data_->_tmp33_);
					_data_->_tmp35_ = _data_->_tmp34_;
					_data_->_tmp36_ = folks_email_field_details_new (_data_->_tmp35_, NULL);
					_data_->_tmp37_ = _data_->_tmp36_;
					gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp32_, GEE_TYPE_COLLECTION, GeeCollection), _data_->_tmp37_);
					_g_object_unref0 (_data_->_tmp37_);
					_g_object_unref0 (_data_->addr);
				}
				_g_object_unref0 (_data_->_addr_it);
			}
			_data_->_tmp38_ = _data_->email_addresses;
			g_value_set_object (&_data_->email_value, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp38_, G_TYPE_OBJECT, GObject));
			_data_->_tmp39_ = _data_->details;
			_data_->_tmp40_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_EMAIL_ADDRESSES);
			_data_->_tmp41_ = g_strdup (_data_->_tmp40_);
			_data_->_tmp42_ = _data_->email_value;
			_data_->_tmp43_ = _data_->_tmp42_;
			_data_->_tmp44_ = __g_value_dup0 (&_data_->_tmp43_);
			g_hash_table_insert (_data_->_tmp39_, _data_->_tmp41_, _data_->_tmp44_);
			_data_->_tmp46_ = _data_->personas;
			_data_->_tmp47_ = _data_->details;
			_data_->_state_ = 1;
			folks_persona_store_add_persona_from_details (_data_->_tmp46_, _data_->_tmp47_, application_contact_save_to_desktop_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp48_ = folks_persona_store_add_persona_from_details_finish (_data_->_tmp46_, _data_->_res_, &_data_->_inner_error0_);
			_data_->_tmp45_ = _data_->_tmp48_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				G_IS_VALUE (&_data_->email_value) ? (g_value_unset (&_data_->email_value), NULL) : NULL;
				_g_object_unref0 (_data_->email_addresses);
				G_IS_VALUE (&_data_->name_value) ? (g_value_unset (&_data_->name_value), NULL) : NULL;
				_g_hash_table_unref0 (_data_->details);
				_g_object_unref0 (_data_->personas);
				_g_object_unref0 (_data_->contacts);
				_g_object_unref0 (_data_->persona);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp49_ = _data_->_tmp45_;
			_data_->_tmp45_ = NULL;
			_g_object_unref0 (_data_->persona);
			_data_->persona = _data_->_tmp49_;
			_g_object_unref0 (_data_->_tmp45_);
			G_IS_VALUE (&_data_->email_value) ? (g_value_unset (&_data_->email_value), NULL) : NULL;
			_g_object_unref0 (_data_->email_addresses);
			G_IS_VALUE (&_data_->name_value) ? (g_value_unset (&_data_->name_value), NULL) : NULL;
			_g_hash_table_unref0 (_data_->details);
		}
		_g_object_unref0 (_data_->personas);
	}
	_data_->_tmp50_ = _data_->persona;
	if (_data_->_tmp50_ == NULL) {
		_data_->_tmp51_ = g_error_new_literal (GEARY_ENGINE_ERROR, GEARY_ENGINE_ERROR_UNSUPPORTED, "Supported persona store not found");
		_data_->_inner_error0_ = _data_->_tmp51_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->contacts);
		_g_object_unref0 (_data_->persona);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp52_ = _data_->persona;
	_data_->_tmp53_ = folks_persona_get_individual (_data_->_tmp52_);
	_data_->_tmp54_ = _data_->_tmp53_;
	_data_->_tmp55_ = _g_object_ref0 (_data_->_tmp54_);
	_data_->individual = _data_->_tmp55_;
	_data_->_tmp56_ = _data_->individual;
	if (_data_->_tmp56_ == NULL) {
		_data_->_tmp57_ = g_error_new_literal (GEARY_ENGINE_ERROR, GEARY_ENGINE_ERROR_UNSUPPORTED, "Individual not created for persona");
		_data_->_inner_error0_ = _data_->_tmp57_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->individual);
		_g_object_unref0 (_data_->contacts);
		_g_object_unref0 (_data_->persona);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp58_ = _data_->individual;
	application_contact_update_from_individual (_data_->self, _data_->_tmp58_);
	application_contact_update (_data_->self);
	g_signal_emit (_data_->self, application_contact_signals[APPLICATION_CONTACT_CHANGED_SIGNAL], 0);
	_data_->_state_ = 2;
	application_contact_open_on_desktop (_data_->self, _data_->cancellable, application_contact_save_to_desktop_ready, _data_);
	return FALSE;
	_state_2:
	application_contact_open_on_desktop_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->individual);
		_g_object_unref0 (_data_->contacts);
		_g_object_unref0 (_data_->persona);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->individual);
	_g_object_unref0 (_data_->contacts);
	_g_object_unref0 (_data_->persona);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
application_contact_open_on_desktop_data_free (gpointer _data)
{
	ApplicationContactOpenOnDesktopData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (ApplicationContactOpenOnDesktopData, _data_);
}

void
application_contact_open_on_desktop (ApplicationContact* self,
                                     GCancellable* cancellable,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	ApplicationContactOpenOnDesktopData* _data_;
	ApplicationContact* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (APPLICATION_IS_CONTACT (self));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (ApplicationContactOpenOnDesktopData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, application_contact_open_on_desktop_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	application_contact_open_on_desktop_co (_data_);
}

void
application_contact_open_on_desktop_finish (ApplicationContact* self,
                                            GAsyncResult* _res_,
                                            GError** error)
{
	ApplicationContactOpenOnDesktopData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/** Invokes the desktop contacts application to open this contact. */
static void
application_contact_open_on_desktop_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_)
{
	ApplicationContactOpenOnDesktopData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	application_contact_open_on_desktop_co (_data_);
}

static gboolean
application_contact_open_on_desktop_co (ApplicationContactOpenOnDesktopData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	g_bus_get (G_BUS_TYPE_SESSION, _data_->cancellable, application_contact_open_on_desktop_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp0_ = g_bus_get_finish (_data_->_res_, &_data_->_inner_error0_);
	_data_->dbus = _data_->_tmp0_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = g_dbus_action_group_get (_data_->dbus, "org.gnome.Contacts", "/org/gnome/Contacts");
	_data_->contacts = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->contacts;
	_data_->_tmp3_ = _data_->self->priv->_individual;
	_data_->_tmp4_ = folks_individual_get_id (_data_->_tmp3_);
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_tmp6_ = g_variant_new_string (_data_->_tmp5_);
	g_variant_ref_sink (_data_->_tmp6_);
	_data_->_tmp7_ = _data_->_tmp6_;
	g_action_group_activate_action (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp2_, g_action_group_get_type (), GActionGroup), "show-contact", _data_->_tmp7_);
	_g_variant_unref0 (_data_->_tmp7_);
	_g_object_unref0 (_data_->contacts);
	_g_object_unref0 (_data_->dbus);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
application_contact_set_remote_resource_loading_data_free (gpointer _data)
{
	ApplicationContactSetRemoteResourceLoadingData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (ApplicationContactSetRemoteResourceLoadingData, _data_);
}

void
application_contact_set_remote_resource_loading (ApplicationContact* self,
                                                 gboolean enabled,
                                                 GCancellable* cancellable,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_)
{
	ApplicationContactSetRemoteResourceLoadingData* _data_;
	ApplicationContact* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (APPLICATION_IS_CONTACT (self));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (ApplicationContactSetRemoteResourceLoadingData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, application_contact_set_remote_resource_loading_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->enabled = enabled;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	application_contact_set_remote_resource_loading_co (_data_);
}

void
application_contact_set_remote_resource_loading_finish (ApplicationContact* self,
                                                        GAsyncResult* _res_,
                                                        GError** error)
{
	ApplicationContactSetRemoteResourceLoadingData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/** Sets remote resource loading for this contact. */
static void
application_contact_set_remote_resource_loading_ready (GObject* source_object,
                                                       GAsyncResult* _res_,
                                                       gpointer _user_data_)
{
	ApplicationContactSetRemoteResourceLoadingData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	application_contact_set_remote_resource_loading_co (_data_);
}

static gboolean
application_contact_set_remote_resource_loading_co (ApplicationContactSetRemoteResourceLoadingData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->store;
	_data_->_tmp1_ = _g_object_ref0 (_data_->_tmp0_);
	_data_->store = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->store;
	if (_data_->_tmp2_ != NULL) {
		_data_->_tmp3_ = gee_linked_list_new (GEARY_TYPE_CONTACT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
		_data_->contacts = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp3_, GEE_TYPE_COLLECTION, GeeCollection);
		{
			_data_->_tmp4_ = application_contact_get_email_addresses (_data_->self);
			_data_->_tmp5_ = _data_->_tmp4_;
			_data_->_tmp6_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp5_, GEE_TYPE_ITERABLE, GeeIterable));
			_data_->_mailbox_it = _data_->_tmp6_;
			while (TRUE) {
				_data_->_tmp7_ = _data_->_mailbox_it;
				if (!gee_iterator_next (_data_->_tmp7_)) {
					break;
				}
				_data_->_tmp8_ = _data_->_mailbox_it;
				_data_->_tmp9_ = gee_iterator_get (_data_->_tmp8_);
				_data_->mailbox = (GearyRFC822MailboxAddress*) _data_->_tmp9_;
				_data_->_tmp10_ = _data_->store;
				_data_->_tmp11_ = _data_->mailbox;
				_data_->_state_ = 1;
				application_contact_store_lookup_engine_contact (_data_->_tmp10_, _data_->_tmp11_, _data_->cancellable, application_contact_set_remote_resource_loading_ready, _data_);
				return FALSE;
				_state_1:
				_data_->_tmp12_ = application_contact_store_lookup_engine_contact_finish (_data_->_tmp10_, _data_->_res_, &_data_->_inner_error0_);
				_data_->contact = _data_->_tmp12_;
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
					_g_object_unref0 (_data_->mailbox);
					_g_object_unref0 (_data_->_mailbox_it);
					_g_object_unref0 (_data_->contacts);
					_g_object_unref0 (_data_->store);
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				if (_data_->enabled) {
					_data_->_tmp13_ = _data_->contact;
					_data_->_tmp14_ = geary_contact_get_flags (_data_->_tmp13_);
					_data_->_tmp15_ = _data_->_tmp14_;
					_data_->_tmp16_ = geary_contact_flags_get_ALWAYS_LOAD_REMOTE_IMAGES ();
					_data_->_tmp17_ = _data_->_tmp16_;
					geary_named_flags_add (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp15_, GEARY_TYPE_NAMED_FLAGS, GearyNamedFlags), _data_->_tmp17_);
				} else {
					_data_->_tmp18_ = _data_->contact;
					_data_->_tmp19_ = geary_contact_get_flags (_data_->_tmp18_);
					_data_->_tmp20_ = _data_->_tmp19_;
					_data_->_tmp21_ = geary_contact_flags_get_ALWAYS_LOAD_REMOTE_IMAGES ();
					_data_->_tmp22_ = _data_->_tmp21_;
					geary_named_flags_remove (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp20_, GEARY_TYPE_NAMED_FLAGS, GearyNamedFlags), _data_->_tmp22_);
				}
				_data_->_tmp23_ = _data_->contacts;
				_data_->_tmp24_ = _data_->contact;
				gee_collection_add (_data_->_tmp23_, _data_->_tmp24_);
				_g_object_unref0 (_data_->contact);
				_g_object_unref0 (_data_->mailbox);
			}
			_g_object_unref0 (_data_->_mailbox_it);
		}
		_data_->_tmp25_ = _data_->store;
		_data_->_tmp26_ = application_contact_store_get_account (_data_->_tmp25_);
		_data_->_tmp27_ = _data_->_tmp26_;
		_data_->_tmp28_ = geary_account_get_contact_store (_data_->_tmp27_);
		_data_->_tmp29_ = _data_->_tmp28_;
		_data_->_tmp30_ = _data_->contacts;
		_data_->_state_ = 2;
		geary_contact_store_update_contacts (_data_->_tmp29_, _data_->_tmp30_, _data_->cancellable, application_contact_set_remote_resource_loading_ready, _data_);
		return FALSE;
		_state_2:
		geary_contact_store_update_contacts_finish (_data_->_tmp29_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->contacts);
			_g_object_unref0 (_data_->store);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		application_contact_set_load_remote_resources (_data_->self, _data_->enabled);
		_g_object_unref0 (_data_->contacts);
	}
	g_signal_emit (_data_->self, application_contact_signals[APPLICATION_CONTACT_CHANGED_SIGNAL], 0);
	_g_object_unref0 (_data_->store);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
application_contact_set_favourite_data_free (gpointer _data)
{
	ApplicationContactSetFavouriteData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (ApplicationContactSetFavouriteData, _data_);
}

void
application_contact_set_favourite (ApplicationContact* self,
                                   gboolean is_favourite,
                                   GCancellable* cancellable,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	ApplicationContactSetFavouriteData* _data_;
	ApplicationContact* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (APPLICATION_IS_CONTACT (self));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (ApplicationContactSetFavouriteData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, application_contact_set_favourite_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->is_favourite = is_favourite;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	application_contact_set_favourite_co (_data_);
}

void
application_contact_set_favourite_finish (ApplicationContact* self,
                                          GAsyncResult* _res_,
                                          GError** error)
{
	ApplicationContactSetFavouriteData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/** Sets remote resource loading for this contact. */
static void
application_contact_set_favourite_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_)
{
	ApplicationContactSetFavouriteData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	application_contact_set_favourite_co (_data_);
}

static gboolean
application_contact_set_favourite_co (ApplicationContactSetFavouriteData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_individual;
	_data_->_state_ = 1;
	folks_favourite_details_change_is_favourite (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp0_, FOLKS_TYPE_FAVOURITE_DETAILS, FolksFavouriteDetails), _data_->is_favourite, application_contact_set_favourite_ready, _data_);
	return FALSE;
	_state_1:
	folks_favourite_details_change_is_favourite_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp0_, FOLKS_TYPE_FAVOURITE_DETAILS, FolksFavouriteDetails), _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/** Returns a string representation for debugging */
gchar*
application_contact_to_string (ApplicationContact* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (APPLICATION_IS_CONTACT (self), NULL);
	_tmp0_ = self->priv->_display_name;
	_tmp1_ = g_strdup_printf ("Contact(\"%s\")", _tmp0_);
	result = _tmp1_;
	return result;
}

static void
application_contact_update_name (ApplicationContact* self,
                                 const gchar* name)
{
	g_return_if_fail (APPLICATION_IS_CONTACT (self));
	g_return_if_fail (name != NULL);
	application_contact_set_display_name (self, name);
	application_contact_set_display_name_is_email (self, geary_rf_c822_mailbox_address_is_valid_address (name));
}

static void
application_contact_on_individual_avatar_notify (ApplicationContact* self)
{
	g_return_if_fail (APPLICATION_IS_CONTACT (self));
	g_object_notify (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), "avatar");
}

static void
_application_contact_on_individual_avatar_notify_g_object_notify (GObject* _sender,
                                                                  GParamSpec* pspec,
                                                                  gpointer self)
{
	application_contact_on_individual_avatar_notify ((ApplicationContact*) self);
}

static void
_application_contact_on_individual_notify_g_object_notify (GObject* _sender,
                                                           GParamSpec* pspec,
                                                           gpointer self)
{
	application_contact_on_individual_notify ((ApplicationContact*) self);
}

static void
_application_contact_on_individual_removed_folks_individual_removed (FolksIndividual* _sender,
                                                                     FolksIndividual* replacement_individual,
                                                                     gpointer self)
{
	application_contact_on_individual_removed ((ApplicationContact*) self, replacement_individual);
}

static void
application_contact_update_from_individual (ApplicationContact* self,
                                            FolksIndividual* replacement)
{
	FolksIndividual* _tmp0_;
	FolksIndividual* _tmp8_;
	g_return_if_fail (APPLICATION_IS_CONTACT (self));
	g_return_if_fail ((replacement == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (replacement, FOLKS_TYPE_INDIVIDUAL));
	_tmp0_ = self->priv->_individual;
	if (_tmp0_ != NULL) {
		FolksIndividual* _tmp1_;
		guint _tmp2_;
		GQuark _tmp3_;
		FolksIndividual* _tmp4_;
		guint _tmp5_;
		FolksIndividual* _tmp6_;
		guint _tmp7_;
		_tmp1_ = self->priv->_individual;
		g_signal_parse_name ("notify::avatar", G_TYPE_OBJECT, &_tmp2_, &_tmp3_, TRUE);
		g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, G_TYPE_OBJECT, GObject), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, _tmp3_, NULL, (GCallback) _application_contact_on_individual_avatar_notify_g_object_notify, self);
		_tmp4_ = self->priv->_individual;
		g_signal_parse_name ("notify", G_TYPE_OBJECT, &_tmp5_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, G_TYPE_OBJECT, GObject), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _application_contact_on_individual_notify_g_object_notify, self);
		_tmp6_ = self->priv->_individual;
		g_signal_parse_name ("removed", FOLKS_TYPE_INDIVIDUAL, &_tmp7_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _application_contact_on_individual_removed_folks_individual_removed, self);
	}
	application_contact_set_individual (self, replacement);
	_tmp8_ = self->priv->_individual;
	if (_tmp8_ != NULL) {
		FolksIndividual* _tmp9_;
		FolksIndividual* _tmp10_;
		FolksIndividual* _tmp11_;
		_tmp9_ = self->priv->_individual;
		g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, G_TYPE_OBJECT, GObject), "notify::avatar", (GCallback) _application_contact_on_individual_avatar_notify_g_object_notify, self, 0);
		_tmp10_ = self->priv->_individual;
		g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, G_TYPE_OBJECT, GObject), "notify", (GCallback) _application_contact_on_individual_notify_g_object_notify, self, 0);
		_tmp11_ = self->priv->_individual;
		g_signal_connect_object (_tmp11_, "removed", (GCallback) _application_contact_on_individual_removed_folks_individual_removed, self, 0);
	}
}

static void
application_contact_update_from_engine (ApplicationContact* self)
{
	GearyRFC822MailboxAddress* mailbox = NULL;
	GearyContact* _tmp0_;
	GearyRFC822MailboxAddress* _tmp1_;
	GeeCollection* _tmp2_;
	GearyContact* _tmp3_;
	GearyContactFlags* _tmp4_;
	GearyContactFlags* _tmp5_;
	g_return_if_fail (APPLICATION_IS_CONTACT (self));
	_tmp0_ = self->priv->engine;
	_tmp1_ = geary_contact_get_rfc822_address (_tmp0_);
	mailbox = _tmp1_;
	_tmp2_ = geary_collection_single (GEARY_RF_C822_TYPE_MAILBOX_ADDRESS, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, mailbox);
	_g_object_unref0 (self->priv->_email_addresses);
	self->priv->_email_addresses = _tmp2_;
	_tmp3_ = self->priv->engine;
	_tmp4_ = geary_contact_get_flags (_tmp3_);
	_tmp5_ = _tmp4_;
	application_contact_set_load_remote_resources (self, geary_contact_flags_always_load_remote_images (_tmp5_));
	_g_object_unref0 (mailbox);
}

static void
application_contact_update (ApplicationContact* self)
{
	FolksIndividual* _tmp0_;
	g_return_if_fail (APPLICATION_IS_CONTACT (self));
	_tmp0_ = self->priv->_individual;
	if (_tmp0_ != NULL) {
		FolksIndividual* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		FolksIndividual* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		FolksIndividual* _tmp7_;
		FolksTrustLevel _tmp8_;
		FolksTrustLevel _tmp9_;
		_tmp1_ = self->priv->_individual;
		_tmp2_ = folks_individual_get_display_name (_tmp1_);
		_tmp3_ = _tmp2_;
		application_contact_update_name (self, _tmp3_);
		_tmp4_ = self->priv->_individual;
		_tmp5_ = folks_favourite_details_get_is_favourite (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, FOLKS_TYPE_FAVOURITE_DETAILS, FolksFavouriteDetails));
		_tmp6_ = _tmp5_;
		application_contact_set_is_favourite (self, _tmp6_);
		_tmp7_ = self->priv->_individual;
		_tmp8_ = folks_individual_get_trust_level (_tmp7_);
		_tmp9_ = _tmp8_;
		application_contact_set_is_trusted (self, _tmp9_ == FOLKS_TRUST_LEVEL_PERSONAS);
		application_contact_set_is_desktop_contact (self, TRUE);
		application_contact_set_load_remote_resources (self, TRUE);
	} else {
		application_contact_set_is_favourite (self, FALSE);
		application_contact_set_is_trusted (self, FALSE);
		application_contact_set_is_desktop_contact (self, FALSE);
		application_contact_set_load_remote_resources (self, FALSE);
	}
}

static void
application_contact_update_replacement_data_free (gpointer _data)
{
	ApplicationContactUpdateReplacementData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->replacement);
	_g_object_unref0 (_data_->self);
	g_slice_free (ApplicationContactUpdateReplacementData, _data_);
}

static void
application_contact_update_replacement (ApplicationContact* self,
                                        FolksIndividual* replacement,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	ApplicationContactUpdateReplacementData* _data_;
	ApplicationContact* _tmp0_;
	FolksIndividual* _tmp1_;
	g_return_if_fail (APPLICATION_IS_CONTACT (self));
	g_return_if_fail ((replacement == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (replacement, FOLKS_TYPE_INDIVIDUAL));
	_data_ = g_slice_new0 (ApplicationContactUpdateReplacementData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, application_contact_update_replacement_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (replacement);
	_g_object_unref0 (_data_->replacement);
	_data_->replacement = _tmp1_;
	application_contact_update_replacement_co (_data_);
}

static void
application_contact_update_replacement_finish (ApplicationContact* self,
                                               GAsyncResult* _res_)
{
	ApplicationContactUpdateReplacementData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
application_contact_update_replacement_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_)
{
	ApplicationContactUpdateReplacementData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	application_contact_update_replacement_co (_data_);
}

static gboolean
application_contact_update_replacement_co (ApplicationContactUpdateReplacementData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->replacement == NULL) {
		_data_->_tmp0_ = _data_->self->priv->store;
		_data_->_tmp1_ = _g_object_ref0 (_data_->_tmp0_);
		_data_->store = _data_->_tmp1_;
		_data_->_tmp2_ = _data_->store;
		if (_data_->_tmp2_ != NULL) {
			{
				FolksIndividual* _tmp10_;
				_data_->_tmp4_ = _data_->store;
				_data_->_tmp5_ = _data_->_tmp4_->individuals;
				_data_->_tmp6_ = _data_->self->priv->_individual;
				_data_->_tmp7_ = folks_individual_get_id (_data_->_tmp6_);
				_data_->_tmp8_ = _data_->_tmp7_;
				_data_->_state_ = 1;
				folks_individual_aggregator_look_up_individual (_data_->_tmp5_, _data_->_tmp8_, application_contact_update_replacement_ready, _data_);
				return FALSE;
				_state_1:
				_data_->_tmp9_ = folks_individual_aggregator_look_up_individual_finish (_data_->_tmp5_, _data_->_res_, &_data_->_inner_error0_);
				_data_->_tmp3_ = _data_->_tmp9_;
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_tmp10_ = _g_object_ref0 (_data_->_tmp3_);
				_g_object_unref0 (_data_->replacement);
				_data_->replacement = _tmp10_;
				_g_object_unref0 (_data_->_tmp3_);
			}
			goto __finally0;
			__catch0_g_error:
			{
				_data_->err = _data_->_inner_error0_;
				_data_->_inner_error0_ = NULL;
				_data_->_tmp11_ = _data_->self->priv->_individual;
				_data_->_tmp12_ = folks_individual_get_id (_data_->_tmp11_);
				_data_->_tmp13_ = _data_->_tmp12_;
				_data_->_tmp14_ = _data_->err;
				_data_->_tmp15_ = _data_->_tmp14_->message;
				g_debug ("application-contact.vala:378: Error loading replacement for Folks %s: " \
"%s", _data_->_tmp13_, _data_->_tmp15_);
				_g_error_free0 (_data_->err);
			}
			__finally0:
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_object_unref0 (_data_->store);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
		_g_object_unref0 (_data_->store);
	}
	application_contact_update_from_individual (_data_->self, _data_->replacement);
	application_contact_update (_data_->self);
	g_signal_emit (_data_->self, application_contact_signals[APPLICATION_CONTACT_CHANGED_SIGNAL], 0);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
application_contact_on_individual_notify (ApplicationContact* self)
{
	g_return_if_fail (APPLICATION_IS_CONTACT (self));
	application_contact_update (self);
	g_signal_emit (self, application_contact_signals[APPLICATION_CONTACT_CHANGED_SIGNAL], 0);
}

static void
application_contact_on_individual_removed (ApplicationContact* self,
                                           FolksIndividual* replacement)
{
	g_return_if_fail (APPLICATION_IS_CONTACT (self));
	g_return_if_fail ((replacement == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (replacement, FOLKS_TYPE_INDIVIDUAL));
	application_contact_update_replacement (self, replacement, NULL, NULL);
}

static void
application_contact_on_engine_flags_changed (ApplicationContact* self)
{
	g_return_if_fail (APPLICATION_IS_CONTACT (self));
	application_contact_update_from_engine (self);
}

static void
application_contact_class_init (ApplicationContactClass * klass,
                                gpointer klass_data)
{
	application_contact_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ApplicationContact_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_application_contact_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_application_contact_set_property;
	G_OBJECT_CLASS (klass)->finalize = application_contact_finalize;
	/** The human-readable name of the contact. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_CONTACT_DISPLAY_NAME_PROPERTY, application_contact_properties[APPLICATION_CONTACT_DISPLAY_NAME_PROPERTY] = g_param_spec_string ("display-name", "display-name", "display-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** The avatar of the contact. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_CONTACT_AVATAR_PROPERTY, application_contact_properties[APPLICATION_CONTACT_AVATAR_PROPERTY] = g_param_spec_object ("avatar", "avatar", "avatar", g_loadable_icon_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** Determines if {@link display_name} the same as its email address. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_CONTACT_DISPLAY_NAME_IS_EMAIL_PROPERTY, application_contact_properties[APPLICATION_CONTACT_DISPLAY_NAME_IS_EMAIL_PROPERTY] = g_param_spec_boolean ("display-name-is-email", "display-name-is-email", "display-name-is-email", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** Determines if this contact was loaded from Folks. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_CONTACT_IS_DESKTOP_CONTACT_PROPERTY, application_contact_properties[APPLICATION_CONTACT_IS_DESKTOP_CONTACT_PROPERTY] = g_param_spec_boolean ("is-desktop-contact", "is-desktop-contact", "is-desktop-contact", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * Determines if this contact is trusted.
	     *
	     * Contacts loaded from Folks that are trusted are trusted, all
	     * other contacts are not.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_CONTACT_IS_TRUSTED_PROPERTY, application_contact_properties[APPLICATION_CONTACT_IS_TRUSTED_PROPERTY] = g_param_spec_boolean ("is-trusted", "is-trusted", "is-trusted", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * Determines if this contact has been marked as a favourite.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_CONTACT_IS_FAVOURITE_PROPERTY, application_contact_properties[APPLICATION_CONTACT_IS_FAVOURITE_PROPERTY] = g_param_spec_boolean ("is-favourite", "is-favourite", "is-favourite", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * Determines if email from this contact should load remote resources.
	     *
	     * Will automatically load resources from contacts in the desktop
	     * database, or if the Engine's contact has been flagged to do so.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_CONTACT_LOAD_REMOTE_RESOURCES_PROPERTY, application_contact_properties[APPLICATION_CONTACT_LOAD_REMOTE_RESOURCES_PROPERTY] = g_param_spec_boolean ("load-remote-resources", "load-remote-resources", "load-remote-resources", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** The set of email addresses associated with this contact. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_CONTACT_EMAIL_ADDRESSES_PROPERTY, application_contact_properties[APPLICATION_CONTACT_EMAIL_ADDRESSES_PROPERTY] = g_param_spec_object ("email-addresses", "email-addresses", "email-addresses", GEE_TYPE_COLLECTION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** The Folks individual for the contact, if any. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_CONTACT_INDIVIDUAL_PROPERTY, application_contact_properties[APPLICATION_CONTACT_INDIVIDUAL_PROPERTY] = g_param_spec_object ("individual", "individual", "individual", FOLKS_TYPE_INDIVIDUAL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** Fired when the contact has changed in some way. */
	application_contact_signals[APPLICATION_CONTACT_CHANGED_SIGNAL] = g_signal_new ("changed", APPLICATION_TYPE_CONTACT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
application_contact_instance_init (ApplicationContact * self,
                                   gpointer klass)
{
	self->priv = application_contact_get_instance_private (self);
	self->priv->_display_name_is_email = FALSE;
	self->priv->_is_desktop_contact = FALSE;
	self->priv->_is_trusted = FALSE;
	self->priv->_is_favourite = FALSE;
	self->priv->_email_addresses = NULL;
	self->priv->engine = NULL;
}

static void
application_contact_finalize (GObject * obj)
{
	ApplicationContact * self;
	GearyContact* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, APPLICATION_TYPE_CONTACT, ApplicationContact);
	application_contact_update_from_individual (self, NULL);
	_tmp0_ = self->priv->engine;
	if (_tmp0_ != NULL) {
		GearyContact* _tmp1_;
		GearyContactFlags* _tmp2_;
		GearyContactFlags* _tmp3_;
		guint _tmp4_;
		GearyContact* _tmp5_;
		GearyContactFlags* _tmp6_;
		GearyContactFlags* _tmp7_;
		guint _tmp8_;
		_tmp1_ = self->priv->engine;
		_tmp2_ = geary_contact_get_flags (_tmp1_);
		_tmp3_ = _tmp2_;
		g_signal_parse_name ("added", GEARY_TYPE_NAMED_FLAGS, &_tmp4_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEARY_TYPE_NAMED_FLAGS, GearyNamedFlags), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _application_contact_on_engine_flags_changed_geary_named_flags_added, self);
		_tmp5_ = self->priv->engine;
		_tmp6_ = geary_contact_get_flags (_tmp5_);
		_tmp7_ = _tmp6_;
		g_signal_parse_name ("removed", GEARY_TYPE_NAMED_FLAGS, &_tmp8_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEARY_TYPE_NAMED_FLAGS, GearyNamedFlags), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp8_, 0, NULL, (GCallback) _application_contact_on_engine_flags_changed_geary_named_flags_removed, self);
	}
	_g_free0 (self->priv->_display_name);
	_g_object_unref0 (self->priv->_email_addresses);
	_g_object_unref0 (self->priv->_individual);
	_g_object_unref0 (self->priv->engine);
	G_OBJECT_CLASS (application_contact_parent_class)->finalize (obj);
}

/**
 * Contact information for an individual.
 *
 * This class aggregates data from for both the Engine and Folks,
 * allowing contacts information for a specific mailbox to be
 * queried. Contacts are obtained from the {@link ContactStore} for an
 * account.
 */
static GType
application_contact_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ApplicationContactClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) application_contact_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ApplicationContact), 0, (GInstanceInitFunc) application_contact_instance_init, NULL };
	GType application_contact_type_id;
	application_contact_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "ApplicationContact", &g_define_type_info, 0);
	ApplicationContact_private_offset = g_type_add_instance_private (application_contact_type_id, sizeof (ApplicationContactPrivate));
	return application_contact_type_id;
}

GType
application_contact_get_type (void)
{
	static volatile gsize application_contact_type_id__once = 0;
	if (g_once_init_enter (&application_contact_type_id__once)) {
		GType application_contact_type_id;
		application_contact_type_id = application_contact_get_type_once ();
		g_once_init_leave (&application_contact_type_id__once, application_contact_type_id);
	}
	return application_contact_type_id__once;
}

static void
_vala_application_contact_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	ApplicationContact * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, APPLICATION_TYPE_CONTACT, ApplicationContact);
	switch (property_id) {
		case APPLICATION_CONTACT_DISPLAY_NAME_PROPERTY:
		g_value_set_string (value, application_contact_get_display_name (self));
		break;
		case APPLICATION_CONTACT_AVATAR_PROPERTY:
		g_value_set_object (value, application_contact_get_avatar (self));
		break;
		case APPLICATION_CONTACT_DISPLAY_NAME_IS_EMAIL_PROPERTY:
		g_value_set_boolean (value, application_contact_get_display_name_is_email (self));
		break;
		case APPLICATION_CONTACT_IS_DESKTOP_CONTACT_PROPERTY:
		g_value_set_boolean (value, application_contact_get_is_desktop_contact (self));
		break;
		case APPLICATION_CONTACT_IS_TRUSTED_PROPERTY:
		g_value_set_boolean (value, application_contact_get_is_trusted (self));
		break;
		case APPLICATION_CONTACT_IS_FAVOURITE_PROPERTY:
		g_value_set_boolean (value, application_contact_get_is_favourite (self));
		break;
		case APPLICATION_CONTACT_LOAD_REMOTE_RESOURCES_PROPERTY:
		g_value_set_boolean (value, application_contact_get_load_remote_resources (self));
		break;
		case APPLICATION_CONTACT_EMAIL_ADDRESSES_PROPERTY:
		g_value_set_object (value, application_contact_get_email_addresses (self));
		break;
		case APPLICATION_CONTACT_INDIVIDUAL_PROPERTY:
		g_value_set_object (value, application_contact_get_individual (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_application_contact_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	ApplicationContact * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, APPLICATION_TYPE_CONTACT, ApplicationContact);
	switch (property_id) {
		case APPLICATION_CONTACT_DISPLAY_NAME_PROPERTY:
		application_contact_set_display_name (self, g_value_get_string (value));
		break;
		case APPLICATION_CONTACT_DISPLAY_NAME_IS_EMAIL_PROPERTY:
		application_contact_set_display_name_is_email (self, g_value_get_boolean (value));
		break;
		case APPLICATION_CONTACT_IS_DESKTOP_CONTACT_PROPERTY:
		application_contact_set_is_desktop_contact (self, g_value_get_boolean (value));
		break;
		case APPLICATION_CONTACT_IS_TRUSTED_PROPERTY:
		application_contact_set_is_trusted (self, g_value_get_boolean (value));
		break;
		case APPLICATION_CONTACT_IS_FAVOURITE_PROPERTY:
		application_contact_set_is_favourite (self, g_value_get_boolean (value));
		break;
		case APPLICATION_CONTACT_LOAD_REMOTE_RESOURCES_PROPERTY:
		application_contact_set_load_remote_resources (self, g_value_get_boolean (value));
		break;
		case APPLICATION_CONTACT_INDIVIDUAL_PROPERTY:
		application_contact_set_individual (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

