/* auto-generated, do not modify */
#include "config.h"

#include <glib.h>

#include "fu-synaptics-mst-struct.h"
#include "fu-byte-array.h"
#include "fu-bytes.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"

/**
 * fu_synaptics_mst_family_to_string:
 * @val: value, e.g. %FU_SYNAPTICS_MST_FAMILY_TESLA
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
const gchar *
fu_synaptics_mst_family_to_string(FuSynapticsMstFamily val)
{
    if (val == FU_SYNAPTICS_MST_FAMILY_TESLA)
        return "tesla";
    if (val == FU_SYNAPTICS_MST_FAMILY_LEAF)
        return "leaf";
    if (val == FU_SYNAPTICS_MST_FAMILY_PANAMERA)
        return "panamera";
    if (val == FU_SYNAPTICS_MST_FAMILY_CAYENNE)
        return "cayenne";
    if (val == FU_SYNAPTICS_MST_FAMILY_SPYDER)
        return "spyder";
    if (val == FU_SYNAPTICS_MST_FAMILY_CARRERA)
        return "carrera";
    return NULL;
}

/**
 * fu_synaptics_mst_updc_rc_to_string:
 * @val: value, e.g. %FU_SYNAPTICS_MST_UPDC_RC_INVALID
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
const gchar *
fu_synaptics_mst_updc_rc_to_string(FuSynapticsMstUpdcRc val)
{
    if (val == FU_SYNAPTICS_MST_UPDC_RC_SUCCESS)
        return "success";
    if (val == FU_SYNAPTICS_MST_UPDC_RC_INVALID)
        return "invalid";
    if (val == FU_SYNAPTICS_MST_UPDC_RC_UNSUPPORTED)
        return "unsupported";
    if (val == FU_SYNAPTICS_MST_UPDC_RC_FAILED)
        return "failed";
    if (val == FU_SYNAPTICS_MST_UPDC_RC_DISABLED)
        return "disabled";
    if (val == FU_SYNAPTICS_MST_UPDC_RC_CONFIGURE_SIGN_FAILED)
        return "configure-sign-failed";
    if (val == FU_SYNAPTICS_MST_UPDC_RC_FIRMWARE_SIGN_FAILED)
        return "firmware-sign-failed";
    if (val == FU_SYNAPTICS_MST_UPDC_RC_ROLLBACK_FAILED)
        return "rollback-failed";
    return NULL;
}

/**
 * fu_synaptics_mst_updc_cmd_to_string:
 * @val: value, e.g. %FU_SYNAPTICS_MST_UPDC_CMD_DISABLE_RC
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
const gchar *
fu_synaptics_mst_updc_cmd_to_string(FuSynapticsMstUpdcCmd val)
{
    if (val == FU_SYNAPTICS_MST_UPDC_CMD_ENABLE_RC)
        return "enable-rc";
    if (val == FU_SYNAPTICS_MST_UPDC_CMD_DISABLE_RC)
        return "disable-rc";
    if (val == FU_SYNAPTICS_MST_UPDC_CMD_GET_ID)
        return "get-id";
    if (val == FU_SYNAPTICS_MST_UPDC_CMD_GET_VERSION)
        return "get-version";
    if (val == FU_SYNAPTICS_MST_UPDC_CMD_FLASH_MAPPING)
        return "flash-mapping";
    if (val == FU_SYNAPTICS_MST_UPDC_CMD_ENABLE_FLASH_CHIP_ERASE)
        return "enable-flash-chip-erase";
    if (val == FU_SYNAPTICS_MST_UPDC_CMD_CAL_EEPROM_CHECKSUM)
        return "cal-eeprom-checksum";
    if (val == FU_SYNAPTICS_MST_UPDC_CMD_FLASH_ERASE)
        return "flash-erase";
    if (val == FU_SYNAPTICS_MST_UPDC_CMD_CAL_EEPROM_CHECK_CRC8)
        return "cal-eeprom-check-crc8";
    if (val == FU_SYNAPTICS_MST_UPDC_CMD_CAL_EEPROM_CHECK_CRC16)
        return "cal-eeprom-check-crc16";
    if (val == FU_SYNAPTICS_MST_UPDC_CMD_ACTIVATE_FIRMWARE)
        return "activate-firmware";
    if (val == FU_SYNAPTICS_MST_UPDC_CMD_WRITE_TO_EEPROM)
        return "write-to-eeprom";
    if (val == FU_SYNAPTICS_MST_UPDC_CMD_WRITE_TO_MEMORY)
        return "write-to-memory";
    if (val == FU_SYNAPTICS_MST_UPDC_CMD_WRITE_TO_TX_DPCD)
        return "write-to-tx-dpcd";
    if (val == FU_SYNAPTICS_MST_UPDC_CMD_WRITE_TO_TX_DPCD_TX1)
        return "write-to-tx-dpcd-tx1";
    if (val == FU_SYNAPTICS_MST_UPDC_CMD_WRITE_TO_TX_DPCD_TX2)
        return "write-to-tx-dpcd-tx2";
    if (val == FU_SYNAPTICS_MST_UPDC_CMD_WRITE_TO_TX_DPCD_TX3)
        return "write-to-tx-dpcd-tx3";
    if (val == FU_SYNAPTICS_MST_UPDC_CMD_READ_FROM_EEPROM)
        return "read-from-eeprom";
    if (val == FU_SYNAPTICS_MST_UPDC_CMD_READ_FROM_MEMORY)
        return "read-from-memory";
    if (val == FU_SYNAPTICS_MST_UPDC_CMD_READ_FROM_TX_DPCD)
        return "read-from-tx-dpcd";
    if (val == FU_SYNAPTICS_MST_UPDC_CMD_READ_FROM_TX_DPCD_TX1)
        return "read-from-tx-dpcd-tx1";
    if (val == FU_SYNAPTICS_MST_UPDC_CMD_READ_FROM_TX_DPCD_TX2)
        return "read-from-tx-dpcd-tx2";
    if (val == FU_SYNAPTICS_MST_UPDC_CMD_READ_FROM_TX_DPCD_TX3)
        return "read-from-tx-dpcd-tx3";
    return NULL;
}

/**
 * fu_struct_synaptics_firmware_config_ref: (skip):
 **/
FuStructSynapticsFirmwareConfig *
fu_struct_synaptics_firmware_config_ref(FuStructSynapticsFirmwareConfig *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_synaptics_firmware_config_unref: (skip):
 **/
void
fu_struct_synaptics_firmware_config_unref(FuStructSynapticsFirmwareConfig *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructSynapticsFirmwareConfig refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_synaptics_firmware_config_new_internal: (skip):
 **/
static FuStructSynapticsFirmwareConfig *
fu_struct_synaptics_firmware_config_new_internal(void)
{
    FuStructSynapticsFirmwareConfig *st = g_new0(FuStructSynapticsFirmwareConfig, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_synaptics_firmware_config_get_version: (skip):
 **/
guint8
fu_struct_synaptics_firmware_config_get_version(const FuStructSynapticsFirmwareConfig *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_synaptics_firmware_config_get_magic1: (skip):
 **/
guint8
fu_struct_synaptics_firmware_config_get_magic1(const FuStructSynapticsFirmwareConfig *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[2];
}
/**
 * fu_struct_synaptics_firmware_config_get_magic2: (skip):
 **/
guint8
fu_struct_synaptics_firmware_config_get_magic2(const FuStructSynapticsFirmwareConfig *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[3];
}

/* setters */
/**
 * fu_struct_synaptics_firmware_config_to_string: (skip):
 **/
static gchar *
fu_struct_synaptics_firmware_config_to_string(const FuStructSynapticsFirmwareConfig *st)
{
    g_autoptr(GString) str = g_string_new("FuStructSynapticsFirmwareConfig:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  version: 0x%x\n",
                           (guint) fu_struct_synaptics_firmware_config_get_version(st));
    g_string_append_printf(str, "  magic1: 0x%x\n",
                           (guint) fu_struct_synaptics_firmware_config_get_magic1(st));
    g_string_append_printf(str, "  magic2: 0x%x\n",
                           (guint) fu_struct_synaptics_firmware_config_get_magic2(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_synaptics_firmware_config_validate_internal(FuStructSynapticsFirmwareConfig *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_synaptics_firmware_config_parse_internal(FuStructSynapticsFirmwareConfig *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_synaptics_firmware_config_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_synaptics_firmware_config_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_synaptics_firmware_config_parse_stream: (skip):
 **/
FuStructSynapticsFirmwareConfig *
fu_struct_synaptics_firmware_config_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructSynapticsFirmwareConfig) st = fu_struct_synaptics_firmware_config_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 4, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructSynapticsFirmwareConfig failed read of 0x%x: ", (guint) 4);
        return NULL;
    }
    if (st->buf->len != 4) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructSynapticsFirmwareConfig requested 0x%x and got 0x%x",
                    (guint) 4,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_synaptics_firmware_config_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
