/* auto-generated, do not modify */
#include "config.h"

#include <glib.h>

#include "fu-ccgx-dmc-struct.h"
#include "fu-byte-array.h"
#include "fu-bytes.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"


/**
 * fu_ccgx_dmc_img_status_to_string:
 * @val: value, e.g. %FU_CCGX_DMC_IMG_STATUS_VALID
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
const gchar *
fu_ccgx_dmc_img_status_to_string(FuCcgxDmcImgStatus val)
{
    if (val == FU_CCGX_DMC_IMG_STATUS_VALID)
        return "valid";
    if (val == FU_CCGX_DMC_IMG_STATUS_INVALID)
        return "invalid";
    if (val == FU_CCGX_DMC_IMG_STATUS_RECOVERY)
        return "recovery";
    if (val == FU_CCGX_DMC_IMG_STATUS_RECOVERED_FROM_SECONDARY)
        return "recovered-from-secondary";
    if (val == FU_CCGX_DMC_IMG_STATUS_NOT_SUPPORTED)
        return "not-supported";
    return NULL;
}

/**
 * fu_ccgx_dmc_img_mode_to_string:
 * @val: value, e.g. %FU_CCGX_DMC_IMG_MODE_DUAL_IMG_SYM
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
const gchar *
fu_ccgx_dmc_img_mode_to_string(FuCcgxDmcImgMode val)
{
    if (val == FU_CCGX_DMC_IMG_MODE_SINGLE_IMG)
        return "single-img";
    if (val == FU_CCGX_DMC_IMG_MODE_DUAL_IMG_SYM)
        return "dual-img-sym";
    if (val == FU_CCGX_DMC_IMG_MODE_DUAL_IMG_ASYM)
        return "dual-img-asym";
    if (val == FU_CCGX_DMC_IMG_MODE_SINGLE_IMG_WITH_RAM_IMG)
        return "single-img-with-ram-img";
    return NULL;
}

/**
 * fu_ccgx_dmc_device_status_to_string:
 * @val: value, e.g. %FU_CCGX_DMC_DEVICE_STATUS_UPDATE_PHASE1_IN_PROGRESS
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
const gchar *
fu_ccgx_dmc_device_status_to_string(FuCcgxDmcDeviceStatus val)
{
    if (val == FU_CCGX_DMC_DEVICE_STATUS_IDLE)
        return "idle";
    if (val == FU_CCGX_DMC_DEVICE_STATUS_UPDATE_PHASE1_IN_PROGRESS)
        return "update-phase1-in-progress";
    if (val == FU_CCGX_DMC_DEVICE_STATUS_UPDATE_PHASE1_PARTIAL)
        return "update-phase1-partial";
    if (val == FU_CCGX_DMC_DEVICE_STATUS_UPDATE_COMPLETE_FULL)
        return "update-complete-full";
    if (val == FU_CCGX_DMC_DEVICE_STATUS_UPDATE_PHASE1_COMPLETE_PARTIAL)
        return "update-phase1-complete-partial";
    if (val == FU_CCGX_DMC_DEVICE_STATUS_UPDATE_PHASE1_COMPLETE_FULL_PHASE2_NOT_DONE)
        return "update-phase1-complete-full-phase2-not-done";
    if (val == FU_CCGX_DMC_DEVICE_STATUS_FW_DOWNLOADED_UPDATE_PEND)
        return "fw-downloaded-update-pend";
    if (val == FU_CCGX_DMC_DEVICE_STATUS_FW_DOWNLOADED_PARTIAL_UPDATE_PEND)
        return "fw-downloaded-partial-update-pend";
    if (val == FU_CCGX_DMC_DEVICE_STATUS_PHASE2_UPDATE_IN_PROGRESS)
        return "phase2-update-in-progress";
    if (val == FU_CCGX_DMC_DEVICE_STATUS_PHASE2_UPDATE_PARTIAL)
        return "phase2-update-partial";
    if (val == FU_CCGX_DMC_DEVICE_STATUS_PHASE2_UPDATE_FACTORY_BACKUP)
        return "phase2-update-factory-backup";
    if (val == FU_CCGX_DMC_DEVICE_STATUS_PHASE2_UPDATE_COMPLETE_PARTIAL)
        return "phase2-update-complete-partial";
    if (val == FU_CCGX_DMC_DEVICE_STATUS_PHASE2_UPDATE_COMPLETE_FULL)
        return "phase2-update-complete-full";
    if (val == FU_CCGX_DMC_DEVICE_STATUS_PHASE2_UPDATE_FAIL_INVALID_FWCT)
        return "phase2-update-fail-invalid-fwct";
    if (val == FU_CCGX_DMC_DEVICE_STATUS_PHASE2_UPDATE_FAIL_INVALID_DOCK_IDENTITY)
        return "phase2-update-fail-invalid-dock-identity";
    if (val == FU_CCGX_DMC_DEVICE_STATUS_PHASE2_UPDATE_FAIL_INVALID_COMPOSITE_VER)
        return "phase2-update-fail-invalid-composite-ver";
    if (val == FU_CCGX_DMC_DEVICE_STATUS_PHASE2_UPDATE_FAIL_AUTHENTICATION_FAILED)
        return "phase2-update-fail-authentication-failed";
    if (val == FU_CCGX_DMC_DEVICE_STATUS_PHASE2_UPDATE_FAIL_INVALID_ALGORITHM)
        return "phase2-update-fail-invalid-algorithm";
    if (val == FU_CCGX_DMC_DEVICE_STATUS_PHASE2_UPDATE_FAIL_SPI_READ_FAILED)
        return "phase2-update-fail-spi-read-failed";
    if (val == FU_CCGX_DMC_DEVICE_STATUS_PHASE2_UPDATE_FAIL_NO_VALID_KEY)
        return "phase2-update-fail-no-valid-key";
    if (val == FU_CCGX_DMC_DEVICE_STATUS_PHASE2_UPDATE_FAIL_NO_VALID_SPI_PACKAGE)
        return "phase2-update-fail-no-valid-spi-package";
    if (val == FU_CCGX_DMC_DEVICE_STATUS_PHASE2_UPDATE_FAIL_RAM_INIT_FAILED)
        return "phase2-update-fail-ram-init-failed";
    if (val == FU_CCGX_DMC_DEVICE_STATUS_PHASE2_UPDATE_FAIL_FACTORY_BACKUP_FAILED)
        return "phase2-update-fail-factory-backup-failed";
    if (val == FU_CCGX_DMC_DEVICE_STATUS_PHASE2_UPDATE_FAIL_NO_VALID_FACTORY_PACKAGE)
        return "phase2-update-fail-no-valid-factory-package";
    if (val == FU_CCGX_DMC_DEVICE_STATUS_UPDATE_FAIL)
        return "update-fail";
    return NULL;
}

/**
 * fu_ccgx_dmc_devx_device_type_to_string:
 * @val: value, e.g. %FU_CCGX_DMC_DEVX_DEVICE_TYPE_CCG3
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
const gchar *
fu_ccgx_dmc_devx_device_type_to_string(FuCcgxDmcDevxDeviceType val)
{
    if (val == FU_CCGX_DMC_DEVX_DEVICE_TYPE_INVALID)
        return "invalid";
    if (val == FU_CCGX_DMC_DEVX_DEVICE_TYPE_CCG3)
        return "ccg3";
    if (val == FU_CCGX_DMC_DEVX_DEVICE_TYPE_DMC)
        return "dmc";
    if (val == FU_CCGX_DMC_DEVX_DEVICE_TYPE_CCG4)
        return "ccg4";
    if (val == FU_CCGX_DMC_DEVX_DEVICE_TYPE_CCG5)
        return "ccg5";
    if (val == FU_CCGX_DMC_DEVX_DEVICE_TYPE_HX3)
        return "hx3";
    if (val == FU_CCGX_DMC_DEVX_DEVICE_TYPE_HX3_PD)
        return "hx3-pd";
    if (val == FU_CCGX_DMC_DEVX_DEVICE_TYPE_DMC_PD)
        return "dmc-pd";
    if (val == FU_CCGX_DMC_DEVX_DEVICE_TYPE_CCG6)
        return "ccg6";
    if (val == FU_CCGX_DMC_DEVX_DEVICE_TYPE_PMG1S3)
        return "pmg1s3";
    if (val == FU_CCGX_DMC_DEVX_DEVICE_TYPE_CCG7SC)
        return "ccg7sc";
    if (val == FU_CCGX_DMC_DEVX_DEVICE_TYPE_CCG6SF)
        return "ccg6sf";
    if (val == FU_CCGX_DMC_DEVX_DEVICE_TYPE_CCG8)
        return "ccg8";
    if (val == FU_CCGX_DMC_DEVX_DEVICE_TYPE_SPI)
        return "spi";
    return NULL;
}


/**
 * fu_ccgx_dmc_int_opcode_to_string:
 * @val: value, e.g. %FU_CCGX_DMC_INT_OPCODE_FW_UPGRADE_STATUS
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
const gchar *
fu_ccgx_dmc_int_opcode_to_string(FuCcgxDmcIntOpcode val)
{
    if (val == FU_CCGX_DMC_INT_OPCODE_FW_UPGRADE_RQT)
        return "fw-upgrade-rqt";
    if (val == FU_CCGX_DMC_INT_OPCODE_FW_UPGRADE_STATUS)
        return "fw-upgrade-status";
    if (val == FU_CCGX_DMC_INT_OPCODE_IMG_WRITE_STATUS)
        return "img-write-status";
    if (val == FU_CCGX_DMC_INT_OPCODE_REENUM)
        return "reenum";
    if (val == FU_CCGX_DMC_INT_OPCODE_FWCT_ANALYSIS_STATUS)
        return "fwct-analysis-status";
    return NULL;
}

/**
 * fu_ccgx_dmc_fwct_analysis_status_to_string:
 * @val: value, e.g. %FU_CCGX_DMC_FWCT_ANALYSIS_STATUS_INVALID_DOCK_IDENTITY
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
const gchar *
fu_ccgx_dmc_fwct_analysis_status_to_string(FuCcgxDmcFwctAnalysisStatus val)
{
    if (val == FU_CCGX_DMC_FWCT_ANALYSIS_STATUS_INVALID_FWCT)
        return "invalid-fwct";
    if (val == FU_CCGX_DMC_FWCT_ANALYSIS_STATUS_INVALID_DOCK_IDENTITY)
        return "invalid-dock-identity";
    if (val == FU_CCGX_DMC_FWCT_ANALYSIS_STATUS_INVALID_COMPOSITE_VERSION)
        return "invalid-composite-version";
    if (val == FU_CCGX_DMC_FWCT_ANALYSIS_STATUS_AUTHENTICATION_FAILED)
        return "authentication-failed";
    if (val == FU_CCGX_DMC_FWCT_ANALYSIS_STATUS_INVALID_ALGORITHM)
        return "invalid-algorithm";
    if (val == FU_CCGX_DMC_FWCT_ANALYSIS_STATUS_INVALID_FENCE)
        return "invalid-fence";
    return NULL;
}

/**
 * fu_ccgx_dmc_update_model_to_string:
 * @val: value, e.g. %FU_CCGX_DMC_UPDATE_MODEL_DOWNLOAD_TRIGGER
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
const gchar *
fu_ccgx_dmc_update_model_to_string(FuCcgxDmcUpdateModel val)
{
    if (val == FU_CCGX_DMC_UPDATE_MODEL_NONE)
        return "none";
    if (val == FU_CCGX_DMC_UPDATE_MODEL_DOWNLOAD_TRIGGER)
        return "download-trigger";
    if (val == FU_CCGX_DMC_UPDATE_MODEL_PENDING_RESET)
        return "pending-reset";
    return NULL;
}
/**
 * fu_struct_ccgx_dmc_dock_identity_ref: (skip):
 **/
FuStructCcgxDmcDockIdentity *
fu_struct_ccgx_dmc_dock_identity_ref(FuStructCcgxDmcDockIdentity *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_ccgx_dmc_dock_identity_unref: (skip):
 **/
void
fu_struct_ccgx_dmc_dock_identity_unref(FuStructCcgxDmcDockIdentity *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructCcgxDmcDockIdentity refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_ccgx_dmc_dock_identity_new_internal: (skip):
 **/
static FuStructCcgxDmcDockIdentity *
fu_struct_ccgx_dmc_dock_identity_new_internal(void)
{
    FuStructCcgxDmcDockIdentity *st = g_new0(FuStructCcgxDmcDockIdentity, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_ccgx_dmc_dock_identity_get_structure_version: (skip):
 **/
guint8
fu_struct_ccgx_dmc_dock_identity_get_structure_version(const FuStructCcgxDmcDockIdentity *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_ccgx_dmc_dock_identity_get_cdtt_version: (skip):
 **/
guint8
fu_struct_ccgx_dmc_dock_identity_get_cdtt_version(const FuStructCcgxDmcDockIdentity *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}
/**
 * fu_struct_ccgx_dmc_dock_identity_get_vid: (skip):
 **/
guint16
fu_struct_ccgx_dmc_dock_identity_get_vid(const FuStructCcgxDmcDockIdentity *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 2, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ccgx_dmc_dock_identity_get_pid: (skip):
 **/
guint16
fu_struct_ccgx_dmc_dock_identity_get_pid(const FuStructCcgxDmcDockIdentity *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ccgx_dmc_dock_identity_get_device_id: (skip):
 **/
guint16
fu_struct_ccgx_dmc_dock_identity_get_device_id(const FuStructCcgxDmcDockIdentity *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 6, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ccgx_dmc_dock_identity_get_vendor_string: (skip):
 **/
gchar *
fu_struct_ccgx_dmc_dock_identity_get_vendor_string(const FuStructCcgxDmcDockIdentity *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 8, 32, NULL);
}
/**
 * fu_struct_ccgx_dmc_dock_identity_get_product_string: (skip):
 **/
gchar *
fu_struct_ccgx_dmc_dock_identity_get_product_string(const FuStructCcgxDmcDockIdentity *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 40, 32, NULL);
}
/**
 * fu_struct_ccgx_dmc_dock_identity_get_custom_meta_data_flag: (skip):
 **/
guint8
fu_struct_ccgx_dmc_dock_identity_get_custom_meta_data_flag(const FuStructCcgxDmcDockIdentity *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[72];
}
/**
 * fu_struct_ccgx_dmc_dock_identity_get_model: (skip):
 **/
guint8
fu_struct_ccgx_dmc_dock_identity_get_model(const FuStructCcgxDmcDockIdentity *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[73];
}

/* setters */
/**
 * fu_struct_ccgx_dmc_dock_identity_set_structure_version: (skip):
 **/
void
fu_struct_ccgx_dmc_dock_identity_set_structure_version(FuStructCcgxDmcDockIdentity *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_ccgx_dmc_dock_identity_set_cdtt_version: (skip):
 **/
void
fu_struct_ccgx_dmc_dock_identity_set_cdtt_version(FuStructCcgxDmcDockIdentity *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_ccgx_dmc_dock_identity_set_vid: (skip):
 **/
void
fu_struct_ccgx_dmc_dock_identity_set_vid(FuStructCcgxDmcDockIdentity *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 2, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ccgx_dmc_dock_identity_set_pid: (skip):
 **/
void
fu_struct_ccgx_dmc_dock_identity_set_pid(FuStructCcgxDmcDockIdentity *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ccgx_dmc_dock_identity_set_device_id: (skip):
 **/
void
fu_struct_ccgx_dmc_dock_identity_set_device_id(FuStructCcgxDmcDockIdentity *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 6, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ccgx_dmc_dock_identity_set_vendor_string: (skip):
 **/
gboolean
fu_struct_ccgx_dmc_dock_identity_set_vendor_string(FuStructCcgxDmcDockIdentity *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->buf->data + 8, 0x0, 32);
        return TRUE;
    }
    len = strlen(value);
    if (len > 32) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in FuStructCcgxDmcDockIdentity.vendor_string (0x%x bytes)",
                    value, (guint) len, (guint) 32);
        return FALSE;
    }
    return fu_memcpy_safe(st->buf->data, st->buf->len, 8, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_ccgx_dmc_dock_identity_set_product_string: (skip):
 **/
gboolean
fu_struct_ccgx_dmc_dock_identity_set_product_string(FuStructCcgxDmcDockIdentity *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->buf->data + 40, 0x0, 32);
        return TRUE;
    }
    len = strlen(value);
    if (len > 32) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in FuStructCcgxDmcDockIdentity.product_string (0x%x bytes)",
                    value, (guint) len, (guint) 32);
        return FALSE;
    }
    return fu_memcpy_safe(st->buf->data, st->buf->len, 40, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_ccgx_dmc_dock_identity_set_custom_meta_data_flag: (skip):
 **/
void
fu_struct_ccgx_dmc_dock_identity_set_custom_meta_data_flag(FuStructCcgxDmcDockIdentity *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[72] = value;
}
/**
 * fu_struct_ccgx_dmc_dock_identity_set_model: (skip):
 **/
void
fu_struct_ccgx_dmc_dock_identity_set_model(FuStructCcgxDmcDockIdentity *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[73] = value;
}
/**
 * fu_struct_ccgx_dmc_dock_identity_new: (skip):
 **/
FuStructCcgxDmcDockIdentity *
fu_struct_ccgx_dmc_dock_identity_new(void)
{
    FuStructCcgxDmcDockIdentity *st = fu_struct_ccgx_dmc_dock_identity_new_internal();
    st->buf = g_byte_array_sized_new(74);
    fu_byte_array_set_size(st->buf, 74, 0x0);
    return st;
}
/**
 * fu_struct_ccgx_dmc_devx_status_ref: (skip):
 **/
FuStructCcgxDmcDevxStatus *
fu_struct_ccgx_dmc_devx_status_ref(FuStructCcgxDmcDevxStatus *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_ccgx_dmc_devx_status_unref: (skip):
 **/
void
fu_struct_ccgx_dmc_devx_status_unref(FuStructCcgxDmcDevxStatus *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructCcgxDmcDevxStatus refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_ccgx_dmc_devx_status_new_internal: (skip):
 **/
static FuStructCcgxDmcDevxStatus *
fu_struct_ccgx_dmc_devx_status_new_internal(void)
{
    FuStructCcgxDmcDevxStatus *st = g_new0(FuStructCcgxDmcDevxStatus, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_ccgx_dmc_devx_status_get_device_type: (skip):
 **/
FuCcgxDmcDevxDeviceType
fu_struct_ccgx_dmc_devx_status_get_device_type(const FuStructCcgxDmcDevxStatus *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_ccgx_dmc_devx_status_get_component_id: (skip):
 **/
guint8
fu_struct_ccgx_dmc_devx_status_get_component_id(const FuStructCcgxDmcDevxStatus *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}
/**
 * fu_struct_ccgx_dmc_devx_status_get_image_mode: (skip):
 **/
FuCcgxDmcImgMode
fu_struct_ccgx_dmc_devx_status_get_image_mode(const FuStructCcgxDmcDevxStatus *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[2];
}
/**
 * fu_struct_ccgx_dmc_devx_status_get_current_image: (skip):
 **/
guint8
fu_struct_ccgx_dmc_devx_status_get_current_image(const FuStructCcgxDmcDevxStatus *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[3];
}
/**
 * fu_struct_ccgx_dmc_devx_status_get_img_status: (skip):
 **/
guint8
fu_struct_ccgx_dmc_devx_status_get_img_status(const FuStructCcgxDmcDevxStatus *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[4];
}
/**
 * fu_struct_ccgx_dmc_devx_status_get_fw_version: (skip):
 **/
const guint8 *
fu_struct_ccgx_dmc_devx_status_get_fw_version(const FuStructCcgxDmcDevxStatus *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 24;
    return st->buf->data + 8;
}

/* setters */
/**
 * fu_struct_ccgx_dmc_devx_status_to_string: (skip):
 **/
static gchar *
fu_struct_ccgx_dmc_devx_status_to_string(const FuStructCcgxDmcDevxStatus *st)
{
    g_autoptr(GString) str = g_string_new("FuStructCcgxDmcDevxStatus:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        const gchar *tmp = fu_ccgx_dmc_devx_device_type_to_string(fu_struct_ccgx_dmc_devx_status_get_device_type(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  device_type: 0x%x [%s]\n", (guint) fu_struct_ccgx_dmc_devx_status_get_device_type(st), tmp);
        } else {
            g_string_append_printf(str, "  device_type: 0x%x\n", (guint) fu_struct_ccgx_dmc_devx_status_get_device_type(st));
        }
    }
    g_string_append_printf(str, "  component_id: 0x%x\n",
                           (guint) fu_struct_ccgx_dmc_devx_status_get_component_id(st));
    {
        const gchar *tmp = fu_ccgx_dmc_img_mode_to_string(fu_struct_ccgx_dmc_devx_status_get_image_mode(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  image_mode: 0x%x [%s]\n", (guint) fu_struct_ccgx_dmc_devx_status_get_image_mode(st), tmp);
        } else {
            g_string_append_printf(str, "  image_mode: 0x%x\n", (guint) fu_struct_ccgx_dmc_devx_status_get_image_mode(st));
        }
    }
    g_string_append_printf(str, "  current_image: 0x%x\n",
                           (guint) fu_struct_ccgx_dmc_devx_status_get_current_image(st));
    g_string_append_printf(str, "  img_status: 0x%x\n",
                           (guint) fu_struct_ccgx_dmc_devx_status_get_img_status(st));
    {
        gsize bufsz = 0;
        const guint8 *buf = fu_struct_ccgx_dmc_devx_status_get_fw_version(st, &bufsz);
        g_autoptr(GString) tmp = g_string_new(NULL);
        for (gsize i = 0; i < bufsz; i++)
            g_string_append_printf(tmp, "%02X", buf[i]);
        g_string_append_printf(str, "  fw_version: 0x%s\n", tmp->str);
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_ccgx_dmc_devx_status_validate_internal(FuStructCcgxDmcDevxStatus *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_ccgx_dmc_devx_status_parse_internal(FuStructCcgxDmcDevxStatus *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_ccgx_dmc_devx_status_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_ccgx_dmc_devx_status_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_ccgx_dmc_devx_status_parse: (skip):
 **/
FuStructCcgxDmcDevxStatus *
fu_struct_ccgx_dmc_devx_status_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructCcgxDmcDevxStatus) st = fu_struct_ccgx_dmc_devx_status_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 32, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructCcgxDmcDevxStatus: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 32);
    if (!fu_struct_ccgx_dmc_devx_status_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_ccgx_dmc_dock_status_ref: (skip):
 **/
FuStructCcgxDmcDockStatus *
fu_struct_ccgx_dmc_dock_status_ref(FuStructCcgxDmcDockStatus *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_ccgx_dmc_dock_status_unref: (skip):
 **/
void
fu_struct_ccgx_dmc_dock_status_unref(FuStructCcgxDmcDockStatus *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructCcgxDmcDockStatus refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_ccgx_dmc_dock_status_new_internal: (skip):
 **/
static FuStructCcgxDmcDockStatus *
fu_struct_ccgx_dmc_dock_status_new_internal(void)
{
    FuStructCcgxDmcDockStatus *st = g_new0(FuStructCcgxDmcDockStatus, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_ccgx_dmc_dock_status_get_device_status: (skip):
 **/
FuCcgxDmcDeviceStatus
fu_struct_ccgx_dmc_dock_status_get_device_status(const FuStructCcgxDmcDockStatus *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_ccgx_dmc_dock_status_get_device_count: (skip):
 **/
guint8
fu_struct_ccgx_dmc_dock_status_get_device_count(const FuStructCcgxDmcDockStatus *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}
/**
 * fu_struct_ccgx_dmc_dock_status_get_status_length: (skip):
 **/
guint16
fu_struct_ccgx_dmc_dock_status_get_status_length(const FuStructCcgxDmcDockStatus *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 2, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ccgx_dmc_dock_status_get_composite_version: (skip):
 **/
guint32
fu_struct_ccgx_dmc_dock_status_get_composite_version(const FuStructCcgxDmcDockStatus *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 4, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_ccgx_dmc_dock_status_set_device_status: (skip):
 **/
void
fu_struct_ccgx_dmc_dock_status_set_device_status(FuStructCcgxDmcDockStatus *st, FuCcgxDmcDeviceStatus value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_ccgx_dmc_dock_status_set_device_count: (skip):
 **/
void
fu_struct_ccgx_dmc_dock_status_set_device_count(FuStructCcgxDmcDockStatus *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_ccgx_dmc_dock_status_set_status_length: (skip):
 **/
void
fu_struct_ccgx_dmc_dock_status_set_status_length(FuStructCcgxDmcDockStatus *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 2, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ccgx_dmc_dock_status_set_composite_version: (skip):
 **/
void
fu_struct_ccgx_dmc_dock_status_set_composite_version(FuStructCcgxDmcDockStatus *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ccgx_dmc_dock_status_new: (skip):
 **/
FuStructCcgxDmcDockStatus *
fu_struct_ccgx_dmc_dock_status_new(void)
{
    FuStructCcgxDmcDockStatus *st = fu_struct_ccgx_dmc_dock_status_new_internal();
    st->buf = g_byte_array_sized_new(8);
    fu_byte_array_set_size(st->buf, 8, 0x0);
    return st;
}
/**
 * fu_struct_ccgx_dmc_int_rqt_ref: (skip):
 **/
FuStructCcgxDmcIntRqt *
fu_struct_ccgx_dmc_int_rqt_ref(FuStructCcgxDmcIntRqt *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_ccgx_dmc_int_rqt_unref: (skip):
 **/
void
fu_struct_ccgx_dmc_int_rqt_unref(FuStructCcgxDmcIntRqt *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructCcgxDmcIntRqt refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_ccgx_dmc_int_rqt_new_internal: (skip):
 **/
static FuStructCcgxDmcIntRqt *
fu_struct_ccgx_dmc_int_rqt_new_internal(void)
{
    FuStructCcgxDmcIntRqt *st = g_new0(FuStructCcgxDmcIntRqt, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_ccgx_dmc_int_rqt_get_opcode: (skip):
 **/
FuCcgxDmcIntOpcode
fu_struct_ccgx_dmc_int_rqt_get_opcode(const FuStructCcgxDmcIntRqt *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_ccgx_dmc_int_rqt_get_length: (skip):
 **/
guint8
fu_struct_ccgx_dmc_int_rqt_get_length(const FuStructCcgxDmcIntRqt *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}
/**
 * fu_struct_ccgx_dmc_int_rqt_get_data: (skip):
 **/
const guint8 *
fu_struct_ccgx_dmc_int_rqt_get_data(const FuStructCcgxDmcIntRqt *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 8;
    return st->buf->data + 2;
}

/* setters */
/**
 * fu_struct_ccgx_dmc_int_rqt_set_opcode: (skip):
 **/
void
fu_struct_ccgx_dmc_int_rqt_set_opcode(FuStructCcgxDmcIntRqt *st, FuCcgxDmcIntOpcode value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_ccgx_dmc_int_rqt_set_length: (skip):
 **/
void
fu_struct_ccgx_dmc_int_rqt_set_length(FuStructCcgxDmcIntRqt *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_ccgx_dmc_int_rqt_set_data: (skip):
 **/
gboolean
fu_struct_ccgx_dmc_int_rqt_set_data(FuStructCcgxDmcIntRqt *st, const guint8 *buf, gsize bufsz, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    return fu_memcpy_safe(st->buf->data, st->buf->len, 2, buf, bufsz, 0x0, bufsz, error);
}
/**
 * fu_struct_ccgx_dmc_int_rqt_new: (skip):
 **/
FuStructCcgxDmcIntRqt *
fu_struct_ccgx_dmc_int_rqt_new(void)
{
    FuStructCcgxDmcIntRqt *st = fu_struct_ccgx_dmc_int_rqt_new_internal();
    st->buf = g_byte_array_sized_new(10);
    fu_byte_array_set_size(st->buf, 10, 0x0);
    return st;
}
/**
 * fu_struct_ccgx_dmc_fwct_info_ref: (skip):
 **/
FuStructCcgxDmcFwctInfo *
fu_struct_ccgx_dmc_fwct_info_ref(FuStructCcgxDmcFwctInfo *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_ccgx_dmc_fwct_info_unref: (skip):
 **/
void
fu_struct_ccgx_dmc_fwct_info_unref(FuStructCcgxDmcFwctInfo *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructCcgxDmcFwctInfo refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_ccgx_dmc_fwct_info_new_internal: (skip):
 **/
static FuStructCcgxDmcFwctInfo *
fu_struct_ccgx_dmc_fwct_info_new_internal(void)
{
    FuStructCcgxDmcFwctInfo *st = g_new0(FuStructCcgxDmcFwctInfo, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_ccgx_dmc_fwct_info_get_signature: (skip):
 **/
static gchar *
fu_struct_ccgx_dmc_fwct_info_get_signature(const FuStructCcgxDmcFwctInfo *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 0, 4, NULL);
}
/**
 * fu_struct_ccgx_dmc_fwct_info_get_size: (skip):
 **/
guint16
fu_struct_ccgx_dmc_fwct_info_get_size(const FuStructCcgxDmcFwctInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ccgx_dmc_fwct_info_get_checksum: (skip):
 **/
guint8
fu_struct_ccgx_dmc_fwct_info_get_checksum(const FuStructCcgxDmcFwctInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[6];
}
/**
 * fu_struct_ccgx_dmc_fwct_info_get_version: (skip):
 **/
guint8
fu_struct_ccgx_dmc_fwct_info_get_version(const FuStructCcgxDmcFwctInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[7];
}
/**
 * fu_struct_ccgx_dmc_fwct_info_get_custom_meta_type: (skip):
 **/
guint8
fu_struct_ccgx_dmc_fwct_info_get_custom_meta_type(const FuStructCcgxDmcFwctInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[8];
}
/**
 * fu_struct_ccgx_dmc_fwct_info_get_cdtt_version: (skip):
 **/
guint8
fu_struct_ccgx_dmc_fwct_info_get_cdtt_version(const FuStructCcgxDmcFwctInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[9];
}
/**
 * fu_struct_ccgx_dmc_fwct_info_get_vid: (skip):
 **/
guint16
fu_struct_ccgx_dmc_fwct_info_get_vid(const FuStructCcgxDmcFwctInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 10, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ccgx_dmc_fwct_info_get_pid: (skip):
 **/
guint16
fu_struct_ccgx_dmc_fwct_info_get_pid(const FuStructCcgxDmcFwctInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 12, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ccgx_dmc_fwct_info_get_device_id: (skip):
 **/
guint16
fu_struct_ccgx_dmc_fwct_info_get_device_id(const FuStructCcgxDmcFwctInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 14, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ccgx_dmc_fwct_info_get_composite_version: (skip):
 **/
guint32
fu_struct_ccgx_dmc_fwct_info_get_composite_version(const FuStructCcgxDmcFwctInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 32, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ccgx_dmc_fwct_info_get_image_count: (skip):
 **/
guint8
fu_struct_ccgx_dmc_fwct_info_get_image_count(const FuStructCcgxDmcFwctInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[36];
}

/* setters */
/**
 * fu_struct_ccgx_dmc_fwct_info_set_signature: (skip):
 **/
static gboolean
fu_struct_ccgx_dmc_fwct_info_set_signature(FuStructCcgxDmcFwctInfo *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->buf->data + 0, 0x0, 4);
        return TRUE;
    }
    len = strlen(value);
    if (len > 4) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in FuStructCcgxDmcFwctInfo.signature (0x%x bytes)",
                    value, (guint) len, (guint) 4);
        return FALSE;
    }
    return fu_memcpy_safe(st->buf->data, st->buf->len, 0, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_ccgx_dmc_fwct_info_set_size: (skip):
 **/
void
fu_struct_ccgx_dmc_fwct_info_set_size(FuStructCcgxDmcFwctInfo *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ccgx_dmc_fwct_info_set_checksum: (skip):
 **/
void
fu_struct_ccgx_dmc_fwct_info_set_checksum(FuStructCcgxDmcFwctInfo *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[6] = value;
}
/**
 * fu_struct_ccgx_dmc_fwct_info_set_version: (skip):
 **/
void
fu_struct_ccgx_dmc_fwct_info_set_version(FuStructCcgxDmcFwctInfo *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[7] = value;
}
/**
 * fu_struct_ccgx_dmc_fwct_info_set_custom_meta_type: (skip):
 **/
void
fu_struct_ccgx_dmc_fwct_info_set_custom_meta_type(FuStructCcgxDmcFwctInfo *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[8] = value;
}
/**
 * fu_struct_ccgx_dmc_fwct_info_set_cdtt_version: (skip):
 **/
void
fu_struct_ccgx_dmc_fwct_info_set_cdtt_version(FuStructCcgxDmcFwctInfo *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[9] = value;
}
/**
 * fu_struct_ccgx_dmc_fwct_info_set_vid: (skip):
 **/
void
fu_struct_ccgx_dmc_fwct_info_set_vid(FuStructCcgxDmcFwctInfo *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 10, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ccgx_dmc_fwct_info_set_pid: (skip):
 **/
void
fu_struct_ccgx_dmc_fwct_info_set_pid(FuStructCcgxDmcFwctInfo *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 12, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ccgx_dmc_fwct_info_set_device_id: (skip):
 **/
void
fu_struct_ccgx_dmc_fwct_info_set_device_id(FuStructCcgxDmcFwctInfo *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 14, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ccgx_dmc_fwct_info_set_composite_version: (skip):
 **/
void
fu_struct_ccgx_dmc_fwct_info_set_composite_version(FuStructCcgxDmcFwctInfo *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 32, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ccgx_dmc_fwct_info_set_image_count: (skip):
 **/
void
fu_struct_ccgx_dmc_fwct_info_set_image_count(FuStructCcgxDmcFwctInfo *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[36] = value;
}
/**
 * fu_struct_ccgx_dmc_fwct_info_new: (skip):
 **/
FuStructCcgxDmcFwctInfo *
fu_struct_ccgx_dmc_fwct_info_new(void)
{
    FuStructCcgxDmcFwctInfo *st = fu_struct_ccgx_dmc_fwct_info_new_internal();
    st->buf = g_byte_array_sized_new(40);
    fu_byte_array_set_size(st->buf, 40, 0x0);
    fu_struct_ccgx_dmc_fwct_info_set_signature(st, "FWCT", NULL);
    return st;
}
/**
 * fu_struct_ccgx_dmc_fwct_info_to_string: (skip):
 **/
static gchar *
fu_struct_ccgx_dmc_fwct_info_to_string(const FuStructCcgxDmcFwctInfo *st)
{
    g_autoptr(GString) str = g_string_new("FuStructCcgxDmcFwctInfo:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  size: 0x%x\n",
                           (guint) fu_struct_ccgx_dmc_fwct_info_get_size(st));
    g_string_append_printf(str, "  checksum: 0x%x\n",
                           (guint) fu_struct_ccgx_dmc_fwct_info_get_checksum(st));
    g_string_append_printf(str, "  version: 0x%x\n",
                           (guint) fu_struct_ccgx_dmc_fwct_info_get_version(st));
    g_string_append_printf(str, "  custom_meta_type: 0x%x\n",
                           (guint) fu_struct_ccgx_dmc_fwct_info_get_custom_meta_type(st));
    g_string_append_printf(str, "  cdtt_version: 0x%x\n",
                           (guint) fu_struct_ccgx_dmc_fwct_info_get_cdtt_version(st));
    g_string_append_printf(str, "  vid: 0x%x\n",
                           (guint) fu_struct_ccgx_dmc_fwct_info_get_vid(st));
    g_string_append_printf(str, "  pid: 0x%x\n",
                           (guint) fu_struct_ccgx_dmc_fwct_info_get_pid(st));
    g_string_append_printf(str, "  device_id: 0x%x\n",
                           (guint) fu_struct_ccgx_dmc_fwct_info_get_device_id(st));
    g_string_append_printf(str, "  composite_version: 0x%x\n",
                           (guint) fu_struct_ccgx_dmc_fwct_info_get_composite_version(st));
    g_string_append_printf(str, "  image_count: 0x%x\n",
                           (guint) fu_struct_ccgx_dmc_fwct_info_get_image_count(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_ccgx_dmc_fwct_info_validate_internal(FuStructCcgxDmcFwctInfo *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (strncmp((const gchar *) (st->buf->data + 0), "FWCT", 4) != 0) {
        g_autofree gchar *str = fu_struct_ccgx_dmc_fwct_info_get_signature(st);
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructCcgxDmcFwctInfo.signature was not valid, "
                    "expected 'FWCT' and got '%s'",
                    str);
        return FALSE;
    }
    return TRUE;
}
/**
 * fu_struct_ccgx_dmc_fwct_info_validate_stream: (skip):
 **/
gboolean
fu_struct_ccgx_dmc_fwct_info_validate_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructCcgxDmcFwctInfo) st = fu_struct_ccgx_dmc_fwct_info_new_internal();
    g_return_val_if_fail(G_IS_INPUT_STREAM(stream), FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    st->buf = fu_input_stream_read_byte_array(stream, offset, 40, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructCcgxDmcFwctInfo failed read of 0x%x: ", (guint) 40);
        return FALSE;
    }
    if (st->buf->len != 40) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructCcgxDmcFwctInfo requested 0x%x and got 0x%x",
                    (guint) 40,
                    (guint) st->buf->len);
        return FALSE;
    }
    return fu_struct_ccgx_dmc_fwct_info_validate_internal(st, error);
}
static gboolean
fu_struct_ccgx_dmc_fwct_info_parse_internal(FuStructCcgxDmcFwctInfo *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_ccgx_dmc_fwct_info_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_ccgx_dmc_fwct_info_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_ccgx_dmc_fwct_info_parse_stream: (skip):
 **/
FuStructCcgxDmcFwctInfo *
fu_struct_ccgx_dmc_fwct_info_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructCcgxDmcFwctInfo) st = fu_struct_ccgx_dmc_fwct_info_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 40, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructCcgxDmcFwctInfo failed read of 0x%x: ", (guint) 40);
        return NULL;
    }
    if (st->buf->len != 40) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructCcgxDmcFwctInfo requested 0x%x and got 0x%x",
                    (guint) 40,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_ccgx_dmc_fwct_info_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_ccgx_dmc_fwct_image_info_ref: (skip):
 **/
FuStructCcgxDmcFwctImageInfo *
fu_struct_ccgx_dmc_fwct_image_info_ref(FuStructCcgxDmcFwctImageInfo *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_ccgx_dmc_fwct_image_info_unref: (skip):
 **/
void
fu_struct_ccgx_dmc_fwct_image_info_unref(FuStructCcgxDmcFwctImageInfo *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructCcgxDmcFwctImageInfo refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_ccgx_dmc_fwct_image_info_new_internal: (skip):
 **/
static FuStructCcgxDmcFwctImageInfo *
fu_struct_ccgx_dmc_fwct_image_info_new_internal(void)
{
    FuStructCcgxDmcFwctImageInfo *st = g_new0(FuStructCcgxDmcFwctImageInfo, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_ccgx_dmc_fwct_image_info_get_device_type: (skip):
 **/
guint8
fu_struct_ccgx_dmc_fwct_image_info_get_device_type(const FuStructCcgxDmcFwctImageInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_ccgx_dmc_fwct_image_info_get_img_type: (skip):
 **/
guint8
fu_struct_ccgx_dmc_fwct_image_info_get_img_type(const FuStructCcgxDmcFwctImageInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}
/**
 * fu_struct_ccgx_dmc_fwct_image_info_get_comp_id: (skip):
 **/
guint8
fu_struct_ccgx_dmc_fwct_image_info_get_comp_id(const FuStructCcgxDmcFwctImageInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[2];
}
/**
 * fu_struct_ccgx_dmc_fwct_image_info_get_row_size: (skip):
 **/
guint8
fu_struct_ccgx_dmc_fwct_image_info_get_row_size(const FuStructCcgxDmcFwctImageInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[3];
}
/**
 * fu_struct_ccgx_dmc_fwct_image_info_get_fw_version: (skip):
 **/
guint32
fu_struct_ccgx_dmc_fwct_image_info_get_fw_version(const FuStructCcgxDmcFwctImageInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 8, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ccgx_dmc_fwct_image_info_get_app_version: (skip):
 **/
guint32
fu_struct_ccgx_dmc_fwct_image_info_get_app_version(const FuStructCcgxDmcFwctImageInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 12, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ccgx_dmc_fwct_image_info_get_img_offset: (skip):
 **/
guint32
fu_struct_ccgx_dmc_fwct_image_info_get_img_offset(const FuStructCcgxDmcFwctImageInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 16, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ccgx_dmc_fwct_image_info_get_img_size: (skip):
 **/
guint32
fu_struct_ccgx_dmc_fwct_image_info_get_img_size(const FuStructCcgxDmcFwctImageInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 20, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ccgx_dmc_fwct_image_info_get_img_digest: (skip):
 **/
const guint8 *
fu_struct_ccgx_dmc_fwct_image_info_get_img_digest(const FuStructCcgxDmcFwctImageInfo *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 32;
    return st->buf->data + 24;
}
/**
 * fu_struct_ccgx_dmc_fwct_image_info_get_num_img_segments: (skip):
 **/
guint8
fu_struct_ccgx_dmc_fwct_image_info_get_num_img_segments(const FuStructCcgxDmcFwctImageInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[56];
}

/* setters */
/**
 * fu_struct_ccgx_dmc_fwct_image_info_set_device_type: (skip):
 **/
void
fu_struct_ccgx_dmc_fwct_image_info_set_device_type(FuStructCcgxDmcFwctImageInfo *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_ccgx_dmc_fwct_image_info_set_img_type: (skip):
 **/
void
fu_struct_ccgx_dmc_fwct_image_info_set_img_type(FuStructCcgxDmcFwctImageInfo *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_ccgx_dmc_fwct_image_info_set_comp_id: (skip):
 **/
void
fu_struct_ccgx_dmc_fwct_image_info_set_comp_id(FuStructCcgxDmcFwctImageInfo *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[2] = value;
}
/**
 * fu_struct_ccgx_dmc_fwct_image_info_set_row_size: (skip):
 **/
void
fu_struct_ccgx_dmc_fwct_image_info_set_row_size(FuStructCcgxDmcFwctImageInfo *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[3] = value;
}
/**
 * fu_struct_ccgx_dmc_fwct_image_info_set_fw_version: (skip):
 **/
void
fu_struct_ccgx_dmc_fwct_image_info_set_fw_version(FuStructCcgxDmcFwctImageInfo *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 8, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ccgx_dmc_fwct_image_info_set_app_version: (skip):
 **/
void
fu_struct_ccgx_dmc_fwct_image_info_set_app_version(FuStructCcgxDmcFwctImageInfo *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 12, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ccgx_dmc_fwct_image_info_set_img_offset: (skip):
 **/
void
fu_struct_ccgx_dmc_fwct_image_info_set_img_offset(FuStructCcgxDmcFwctImageInfo *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 16, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ccgx_dmc_fwct_image_info_set_img_size: (skip):
 **/
void
fu_struct_ccgx_dmc_fwct_image_info_set_img_size(FuStructCcgxDmcFwctImageInfo *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 20, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ccgx_dmc_fwct_image_info_set_img_digest: (skip):
 **/
gboolean
fu_struct_ccgx_dmc_fwct_image_info_set_img_digest(FuStructCcgxDmcFwctImageInfo *st, const guint8 *buf, gsize bufsz, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    return fu_memcpy_safe(st->buf->data, st->buf->len, 24, buf, bufsz, 0x0, bufsz, error);
}
/**
 * fu_struct_ccgx_dmc_fwct_image_info_set_num_img_segments: (skip):
 **/
void
fu_struct_ccgx_dmc_fwct_image_info_set_num_img_segments(FuStructCcgxDmcFwctImageInfo *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[56] = value;
}
/**
 * fu_struct_ccgx_dmc_fwct_image_info_new: (skip):
 **/
FuStructCcgxDmcFwctImageInfo *
fu_struct_ccgx_dmc_fwct_image_info_new(void)
{
    FuStructCcgxDmcFwctImageInfo *st = fu_struct_ccgx_dmc_fwct_image_info_new_internal();
    st->buf = g_byte_array_sized_new(60);
    fu_byte_array_set_size(st->buf, 60, 0x0);
    return st;
}
/**
 * fu_struct_ccgx_dmc_fwct_image_info_to_string: (skip):
 **/
static gchar *
fu_struct_ccgx_dmc_fwct_image_info_to_string(const FuStructCcgxDmcFwctImageInfo *st)
{
    g_autoptr(GString) str = g_string_new("FuStructCcgxDmcFwctImageInfo:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  device_type: 0x%x\n",
                           (guint) fu_struct_ccgx_dmc_fwct_image_info_get_device_type(st));
    g_string_append_printf(str, "  img_type: 0x%x\n",
                           (guint) fu_struct_ccgx_dmc_fwct_image_info_get_img_type(st));
    g_string_append_printf(str, "  comp_id: 0x%x\n",
                           (guint) fu_struct_ccgx_dmc_fwct_image_info_get_comp_id(st));
    g_string_append_printf(str, "  row_size: 0x%x\n",
                           (guint) fu_struct_ccgx_dmc_fwct_image_info_get_row_size(st));
    g_string_append_printf(str, "  fw_version: 0x%x\n",
                           (guint) fu_struct_ccgx_dmc_fwct_image_info_get_fw_version(st));
    g_string_append_printf(str, "  app_version: 0x%x\n",
                           (guint) fu_struct_ccgx_dmc_fwct_image_info_get_app_version(st));
    g_string_append_printf(str, "  img_offset: 0x%x\n",
                           (guint) fu_struct_ccgx_dmc_fwct_image_info_get_img_offset(st));
    g_string_append_printf(str, "  img_size: 0x%x\n",
                           (guint) fu_struct_ccgx_dmc_fwct_image_info_get_img_size(st));
    {
        gsize bufsz = 0;
        const guint8 *buf = fu_struct_ccgx_dmc_fwct_image_info_get_img_digest(st, &bufsz);
        g_autoptr(GString) tmp = g_string_new(NULL);
        for (gsize i = 0; i < bufsz; i++)
            g_string_append_printf(tmp, "%02X", buf[i]);
        g_string_append_printf(str, "  img_digest: 0x%s\n", tmp->str);
    }
    g_string_append_printf(str, "  num_img_segments: 0x%x\n",
                           (guint) fu_struct_ccgx_dmc_fwct_image_info_get_num_img_segments(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_ccgx_dmc_fwct_image_info_validate_internal(FuStructCcgxDmcFwctImageInfo *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_ccgx_dmc_fwct_image_info_parse_internal(FuStructCcgxDmcFwctImageInfo *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_ccgx_dmc_fwct_image_info_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_ccgx_dmc_fwct_image_info_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_ccgx_dmc_fwct_image_info_parse_stream: (skip):
 **/
FuStructCcgxDmcFwctImageInfo *
fu_struct_ccgx_dmc_fwct_image_info_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructCcgxDmcFwctImageInfo) st = fu_struct_ccgx_dmc_fwct_image_info_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 60, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructCcgxDmcFwctImageInfo failed read of 0x%x: ", (guint) 60);
        return NULL;
    }
    if (st->buf->len != 60) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructCcgxDmcFwctImageInfo requested 0x%x and got 0x%x",
                    (guint) 60,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_ccgx_dmc_fwct_image_info_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_ccgx_dmc_fwct_segmentation_info_ref: (skip):
 **/
FuStructCcgxDmcFwctSegmentationInfo *
fu_struct_ccgx_dmc_fwct_segmentation_info_ref(FuStructCcgxDmcFwctSegmentationInfo *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_ccgx_dmc_fwct_segmentation_info_unref: (skip):
 **/
void
fu_struct_ccgx_dmc_fwct_segmentation_info_unref(FuStructCcgxDmcFwctSegmentationInfo *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructCcgxDmcFwctSegmentationInfo refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_ccgx_dmc_fwct_segmentation_info_new_internal: (skip):
 **/
static FuStructCcgxDmcFwctSegmentationInfo *
fu_struct_ccgx_dmc_fwct_segmentation_info_new_internal(void)
{
    FuStructCcgxDmcFwctSegmentationInfo *st = g_new0(FuStructCcgxDmcFwctSegmentationInfo, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_ccgx_dmc_fwct_segmentation_info_get_img_id: (skip):
 **/
guint8
fu_struct_ccgx_dmc_fwct_segmentation_info_get_img_id(const FuStructCcgxDmcFwctSegmentationInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_ccgx_dmc_fwct_segmentation_info_get_type: (skip):
 **/
guint8
fu_struct_ccgx_dmc_fwct_segmentation_info_get_type(const FuStructCcgxDmcFwctSegmentationInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}
/**
 * fu_struct_ccgx_dmc_fwct_segmentation_info_get_start_row: (skip):
 **/
guint16
fu_struct_ccgx_dmc_fwct_segmentation_info_get_start_row(const FuStructCcgxDmcFwctSegmentationInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 2, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ccgx_dmc_fwct_segmentation_info_get_num_rows: (skip):
 **/
guint16
fu_struct_ccgx_dmc_fwct_segmentation_info_get_num_rows(const FuStructCcgxDmcFwctSegmentationInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 4, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_ccgx_dmc_fwct_segmentation_info_set_img_id: (skip):
 **/
void
fu_struct_ccgx_dmc_fwct_segmentation_info_set_img_id(FuStructCcgxDmcFwctSegmentationInfo *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_ccgx_dmc_fwct_segmentation_info_set_type: (skip):
 **/
void
fu_struct_ccgx_dmc_fwct_segmentation_info_set_type(FuStructCcgxDmcFwctSegmentationInfo *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_ccgx_dmc_fwct_segmentation_info_set_start_row: (skip):
 **/
void
fu_struct_ccgx_dmc_fwct_segmentation_info_set_start_row(FuStructCcgxDmcFwctSegmentationInfo *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 2, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ccgx_dmc_fwct_segmentation_info_set_num_rows: (skip):
 **/
void
fu_struct_ccgx_dmc_fwct_segmentation_info_set_num_rows(FuStructCcgxDmcFwctSegmentationInfo *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ccgx_dmc_fwct_segmentation_info_new: (skip):
 **/
FuStructCcgxDmcFwctSegmentationInfo *
fu_struct_ccgx_dmc_fwct_segmentation_info_new(void)
{
    FuStructCcgxDmcFwctSegmentationInfo *st = fu_struct_ccgx_dmc_fwct_segmentation_info_new_internal();
    st->buf = g_byte_array_sized_new(8);
    fu_byte_array_set_size(st->buf, 8, 0x0);
    return st;
}
/**
 * fu_struct_ccgx_dmc_fwct_segmentation_info_to_string: (skip):
 **/
static gchar *
fu_struct_ccgx_dmc_fwct_segmentation_info_to_string(const FuStructCcgxDmcFwctSegmentationInfo *st)
{
    g_autoptr(GString) str = g_string_new("FuStructCcgxDmcFwctSegmentationInfo:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  img_id: 0x%x\n",
                           (guint) fu_struct_ccgx_dmc_fwct_segmentation_info_get_img_id(st));
    g_string_append_printf(str, "  type: 0x%x\n",
                           (guint) fu_struct_ccgx_dmc_fwct_segmentation_info_get_type(st));
    g_string_append_printf(str, "  start_row: 0x%x\n",
                           (guint) fu_struct_ccgx_dmc_fwct_segmentation_info_get_start_row(st));
    g_string_append_printf(str, "  num_rows: 0x%x\n",
                           (guint) fu_struct_ccgx_dmc_fwct_segmentation_info_get_num_rows(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_ccgx_dmc_fwct_segmentation_info_validate_internal(FuStructCcgxDmcFwctSegmentationInfo *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_ccgx_dmc_fwct_segmentation_info_parse_internal(FuStructCcgxDmcFwctSegmentationInfo *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_ccgx_dmc_fwct_segmentation_info_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_ccgx_dmc_fwct_segmentation_info_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_ccgx_dmc_fwct_segmentation_info_parse_stream: (skip):
 **/
FuStructCcgxDmcFwctSegmentationInfo *
fu_struct_ccgx_dmc_fwct_segmentation_info_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructCcgxDmcFwctSegmentationInfo) st = fu_struct_ccgx_dmc_fwct_segmentation_info_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 8, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructCcgxDmcFwctSegmentationInfo failed read of 0x%x: ", (guint) 8);
        return NULL;
    }
    if (st->buf->len != 8) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructCcgxDmcFwctSegmentationInfo requested 0x%x and got 0x%x",
                    (guint) 8,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_ccgx_dmc_fwct_segmentation_info_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
