#include "sysconfig.h"
#include "sysdeps.h"
#include "options.h"
#include "uae/memory.h"
#include "custom.h"
#include "events.h"
#include "newcpu.h"
#include "cpu_prefetch.h"
#include "cputbl.h"
#define CPUFUNC(x) x##_ff
#define SET_CFLG_ALWAYS(x) SET_CFLG(x)
#define SET_NFLG_ALWAYS(x) SET_NFLG(x)
#ifdef NOFLAGS
#include "noflags.h"
#endif

#ifdef CPUEMU_11

#pragma GCC diagnostic ignored "-Wunused-variable"
#if !defined __clang_analyzer__

#if !defined(PART_1) && !defined(PART_2) && !defined(PART_3) && !defined(PART_4) && !defined(PART_5) && !defined(PART_6) && !defined(PART_7) && !defined(PART_8)
#define PART_1 1
#define PART_2 1
#define PART_3 1
#define PART_4 1
#define PART_5 1
#define PART_6 1
#define PART_7 1
#define PART_8 1
#endif

#ifdef PART_1
/* OR.B #<data>.B,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_0000_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_000_prefetch (4);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}	m68k_incpci (4);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (2/0) */

/* OR.B #<data>.B,(An) */
uae_u32 REGPARAM2 CPUFUNC(op_0010_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_000 (dsta);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	put_byte_000 (dsta, src);
}}}}	m68k_incpci (4);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* OR.B #<data>.B,(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_0018_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_000 (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	put_byte_000 (dsta, src);
}}}}	m68k_incpci (4);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* OR.B #<data>.B,-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_0020_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte_000 (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	put_byte_000 (dsta, src);
}}}}	m68k_incpci (4);
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/1) */

/* OR.B #<data>.B,(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_0028_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (6);
{	uae_s8 dst = get_byte_000 (dsta);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	put_byte_000 (dsta, src);
}}}}	m68k_incpci (6);
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* OR.B #<data>.B,(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_0030_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (6));
{	uae_s8 dst = get_byte_000 (dsta);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	put_byte_000 (dsta, src);
}}}}	m68k_incpci (6);
return 22 * CYCLE_UNIT / 2 + count_cycles;
} /* 22 (4/1) */

/* OR.B #<data>.B,(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_0038_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uae_s8 src = (uae_u8)get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (6);
{	uae_s8 dst = get_byte_000 (dsta);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	put_byte_000 (dsta, src);
}}}}	m68k_incpci (6);
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* OR.B #<data>.B,(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_0039_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uae_s8 src = (uae_u8)get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = get_word_000_prefetch (6) << 16;
	dsta |= get_word_000_prefetch (8);
{	uae_s8 dst = get_byte_000 (dsta);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (10);
	put_byte_000 (dsta, src);
}}}}	m68k_incpci (8);
return 24 * CYCLE_UNIT / 2 + count_cycles;
} /* 24 (5/1) */

/* ORSR.B #<data>.W */
uae_u32 REGPARAM2 CPUFUNC(op_003c_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{	MakeSR ();
{	uae_s16 src = get_word_000_prefetch (4);
	src &= 0xFF;
	m68k_incpci (4);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
	regs.sr |= src;
	MakeFromSR();
}}return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (3/0) */

/* OR.W #<data>.W,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_0040_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}	m68k_incpci (4);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (2/0) */

/* OR.W #<data>.W,(An) */
uae_u32 REGPARAM2 CPUFUNC(op_0050_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_110011;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	put_word_000 (dsta, src);
}}}}}	m68k_incpci (4);
l_110011: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* OR.W #<data>.W,(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_0058_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_110012;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	m68k_areg (regs, dstreg) += 2;
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	put_word_000 (dsta, src);
}}}}}	m68k_incpci (4);
l_110012: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* OR.W #<data>.W,-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_0060_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_110013;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	put_word_000 (dsta, src);
}}}}}	m68k_incpci (4);
l_110013: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/1) */

/* OR.W #<data>.W,(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_0068_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_110014;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	put_word_000 (dsta, src);
}}}}}	m68k_incpci (6);
l_110014: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* OR.W #<data>.W,(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_0070_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (6));
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_110015;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	put_word_000 (dsta, src);
}}}}}	m68k_incpci (6);
l_110015: ;
return 22 * CYCLE_UNIT / 2 + count_cycles;
} /* 22 (4/1) */

/* OR.W #<data>.W,(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_0078_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_110016;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	put_word_000 (dsta, src);
}}}}}	m68k_incpci (6);
l_110016: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* OR.W #<data>.W,(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_0079_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = get_word_000_prefetch (6) << 16;
	dsta |= get_word_000_prefetch (8);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_read(opcode, dsta);
		goto l_110017;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (10);
	put_word_000 (dsta, src);
}}}}}	m68k_incpci (8);
l_110017: ;
return 24 * CYCLE_UNIT / 2 + count_cycles;
} /* 24 (5/1) */

/* ORSR.W #<data>.W */
uae_u32 REGPARAM2 CPUFUNC(op_007c_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{if (!regs.s) { Exception (8); goto l_110018; }
{	MakeSR ();
{	uae_s16 src = get_word_000_prefetch (4);
	m68k_incpci (4);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
	regs.sr |= src;
	MakeFromSR();
}}}l_110018: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (3/0) */

/* OR.L #<data>.L,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_0080_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_000_prefetch (4) << 16;
	src |= get_word_000_prefetch (6);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	m68k_dreg (regs, dstreg) = (src);
}}}	m68k_incpci (6);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/0) */

/* OR.L #<data>.L,(An) */
uae_u32 REGPARAM2 CPUFUNC(op_0090_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_000_prefetch (4) << 16;
	src |= get_word_000_prefetch (6);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_110020;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	put_word_000 (dsta + 2, src); put_word_000 (dsta, src >> 16);
}}}}}	m68k_incpci (6);
l_110020: ;
return 28 * CYCLE_UNIT / 2 + count_cycles;
} /* 28 (5/2) */

/* OR.L #<data>.L,(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_0098_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_000_prefetch (4) << 16;
	src |= get_word_000_prefetch (6);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_110021;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	m68k_areg (regs, dstreg) += 4;
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	put_word_000 (dsta + 2, src); put_word_000 (dsta, src >> 16);
}}}}}	m68k_incpci (6);
l_110021: ;
return 28 * CYCLE_UNIT / 2 + count_cycles;
} /* 28 (5/2) */

/* OR.L #<data>.L,-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_00a0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_000_prefetch (4) << 16;
	src |= get_word_000_prefetch (6);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_110022;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	m68k_areg (regs, dstreg) = dsta;
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	put_word_000 (dsta + 2, src); put_word_000 (dsta, src >> 16);
}}}}}	m68k_incpci (6);
l_110022: ;
return 30 * CYCLE_UNIT / 2 + count_cycles;
} /* 30 (5/2) */

/* OR.L #<data>.L,(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_00a8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_000_prefetch (4) << 16;
	src |= get_word_000_prefetch (6);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (8);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_110023;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (10);
	put_word_000 (dsta + 2, src); put_word_000 (dsta, src >> 16);
}}}}}	m68k_incpci (8);
l_110023: ;
return 32 * CYCLE_UNIT / 2 + count_cycles;
} /* 32 (6/2) */

/* OR.L #<data>.L,(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_00b0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_000_prefetch (4) << 16;
	src |= get_word_000_prefetch (6);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (8));
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_110024;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (10);
	put_word_000 (dsta + 2, src); put_word_000 (dsta, src >> 16);
}}}}}	m68k_incpci (8);
l_110024: ;
return 34 * CYCLE_UNIT / 2 + count_cycles;
} /* 34 (6/2) */

/* OR.L #<data>.L,(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_00b8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uae_s32 src;
	src = get_word_000_prefetch (4) << 16;
	src |= get_word_000_prefetch (6);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (8);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_110025;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (10);
	put_word_000 (dsta + 2, src); put_word_000 (dsta, src >> 16);
}}}}}	m68k_incpci (8);
l_110025: ;
return 32 * CYCLE_UNIT / 2 + count_cycles;
} /* 32 (6/2) */

/* OR.L #<data>.L,(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_00b9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uae_s32 src;
	src = get_word_000_prefetch (4) << 16;
	src |= get_word_000_prefetch (6);
{	uaecptr dsta;
	dsta = get_word_000_prefetch (8) << 16;
	dsta |= get_word_000_prefetch (10);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_read(opcode, dsta);
		goto l_110026;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (12);
	put_word_000 (dsta + 2, src); put_word_000 (dsta, src >> 16);
}}}}}	m68k_incpci (10);
l_110026: ;
return 36 * CYCLE_UNIT / 2 + count_cycles;
} /* 36 (7/2) */

/* BTST.L Dn,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_0100_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	src &= 31;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}	m68k_incpci (2);
return 6 * CYCLE_UNIT / 2 + count_cycles;
} /* 6 (1/0) */

/* MVPMR.W (d16,An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_0108_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr memp = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_u16 val = ((get_byte_000 (memp) & 0xff) << 8) + (get_byte_000 (memp + 2) & 0xff);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((val) & 0xffff);
}}	m68k_incpci (4);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (4/0) */

/* BTST.B Dn,(An) */
uae_u32 REGPARAM2 CPUFUNC(op_0110_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (2/0) */

/* BTST.B Dn,(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_0118_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_000 (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (2/0) */

/* BTST.B Dn,-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_0120_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte_000 (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}	m68k_incpci (2);
return 10 * CYCLE_UNIT / 2 + count_cycles;
} /* 10 (2/0) */

/* BTST.B Dn,(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_0128_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}	m68k_incpci (4);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (3/0) */

/* BTST.B Dn,(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_0130_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (4));
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}	m68k_incpci (4);
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (3/0) */

/* BTST.B Dn,(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_0138_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}	m68k_incpci (4);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (3/0) */

/* BTST.B Dn,(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_0139_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_word_000_prefetch (4) << 16;
	dsta |= get_word_000_prefetch (6);
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}	m68k_incpci (6);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (4/0) */

/* BTST.B Dn,(d16,PC) */
uae_u32 REGPARAM2 CPUFUNC(op_013a_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = 2;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_getpci () + 2;
	dsta += (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}	m68k_incpci (4);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (3/0) */

/* BTST.B Dn,(d8,PC,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_013b_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = 3;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr tmppc;
	uaecptr dsta;
	tmppc = m68k_getpci () + 2;
	dsta = get_disp_ea_000 (tmppc, get_word_000_prefetch (4));
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}	m68k_incpci (4);
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (3/0) */

/* BTST.B Dn,#<data>.B */
uae_u32 REGPARAM2 CPUFUNC(op_013c_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uae_s8 dst = (uae_u8)get_word_000_prefetch (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}	m68k_incpci (4);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (2/0) */

/* BCHG.L Dn,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_0140_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	src &= 31;
	if (src > 15) count_cycles += 2 * CYCLE_UNIT / 2;
	dst ^= (1 << src);
	SET_ZFLG (((uae_u32)dst & (1 << src)) >> src);
	m68k_dreg (regs, dstreg) = (dst);
}}}	m68k_incpci (2);
return 6 * CYCLE_UNIT / 2 + count_cycles;
} /* 6+ (1/0) */

/* MVPMR.L (d16,An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_0148_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{	uaecptr memp = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_u32 val = ((get_byte_000 (memp) & 0xff) << 24) + ((get_byte_000 (memp + 2) & 0xff) << 16)
              + ((get_byte_000 (memp + 4) & 0xff) << 8) + (get_byte_000 (memp + 6) & 0xff);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	m68k_dreg (regs, dstreg) = (val);
}}	m68k_incpci (4);
return 24 * CYCLE_UNIT / 2 + count_cycles;
} /* 24 (6/0) */

/* BCHG.B Dn,(An) */
uae_u32 REGPARAM2 CPUFUNC(op_0150_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uae_u32)dst & (1 << src)) >> src);
	put_byte_000 (dsta, dst);
}}}}	m68k_incpci (2);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* BCHG.B Dn,(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_0158_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_000 (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uae_u32)dst & (1 << src)) >> src);
	put_byte_000 (dsta, dst);
}}}}	m68k_incpci (2);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* BCHG.B Dn,-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_0160_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte_000 (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uae_u32)dst & (1 << src)) >> src);
	put_byte_000 (dsta, dst);
}}}}	m68k_incpci (2);
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (2/1) */

/* BCHG.B Dn,(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_0168_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uae_u32)dst & (1 << src)) >> src);
	put_byte_000 (dsta, dst);
}}}}	m68k_incpci (4);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* BCHG.B Dn,(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_0170_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (4));
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uae_u32)dst & (1 << src)) >> src);
	put_byte_000 (dsta, dst);
}}}}	m68k_incpci (4);
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/1) */

/* BCHG.B Dn,(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_0178_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uae_u32)dst & (1 << src)) >> src);
	put_byte_000 (dsta, dst);
}}}}	m68k_incpci (4);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* BCHG.B Dn,(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_0179_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_word_000_prefetch (4) << 16;
	dsta |= get_word_000_prefetch (6);
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uae_u32)dst & (1 << src)) >> src);
	put_byte_000 (dsta, dst);
}}}}	m68k_incpci (6);
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* BCLR.L Dn,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_0180_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	src &= 31;
	if (src > 15) count_cycles += 2 * CYCLE_UNIT / 2;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	m68k_dreg (regs, dstreg) = (dst);
}}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8+ (1/0) */

/* MVPRM.W Dn,(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_0188_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
	uaecptr memp = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	put_byte_000 (memp, src >> 8);
	put_byte_000 (memp + 2, src);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
}}	m68k_incpci (4);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (2/2) */

/* BCLR.B Dn,(An) */
uae_u32 REGPARAM2 CPUFUNC(op_0190_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte_000 (dsta, dst);
}}}}	m68k_incpci (2);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* BCLR.B Dn,(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_0198_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_000 (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte_000 (dsta, dst);
}}}}	m68k_incpci (2);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* BCLR.B Dn,-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_01a0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte_000 (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte_000 (dsta, dst);
}}}}	m68k_incpci (2);
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (2/1) */

/* BCLR.B Dn,(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_01a8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte_000 (dsta, dst);
}}}}	m68k_incpci (4);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* BCLR.B Dn,(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_01b0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (4));
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte_000 (dsta, dst);
}}}}	m68k_incpci (4);
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/1) */

/* BCLR.B Dn,(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_01b8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte_000 (dsta, dst);
}}}}	m68k_incpci (4);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* BCLR.B Dn,(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_01b9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_word_000_prefetch (4) << 16;
	dsta |= get_word_000_prefetch (6);
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte_000 (dsta, dst);
}}}}	m68k_incpci (6);
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* BSET.L Dn,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_01c0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	src &= 31;
	if (src > 15) count_cycles += 2 * CYCLE_UNIT / 2;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	m68k_dreg (regs, dstreg) = (dst);
}}}	m68k_incpci (2);
return 6 * CYCLE_UNIT / 2 + count_cycles;
} /* 6+ (1/0) */

/* MVPRM.L Dn,(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_01c8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
	uaecptr memp = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	put_byte_000 (memp, src >> 24);
	put_byte_000 (memp + 2, src >> 16);
	put_byte_000 (memp + 4, src >> 8);
	put_byte_000 (memp + 6, src);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
}}	m68k_incpci (4);
return 24 * CYCLE_UNIT / 2 + count_cycles;
} /* 24 (2/4) */

/* BSET.B Dn,(An) */
uae_u32 REGPARAM2 CPUFUNC(op_01d0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte_000 (dsta, dst);
}}}}	m68k_incpci (2);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* BSET.B Dn,(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_01d8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_000 (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte_000 (dsta, dst);
}}}}	m68k_incpci (2);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* BSET.B Dn,-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_01e0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte_000 (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte_000 (dsta, dst);
}}}}	m68k_incpci (2);
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (2/1) */

/* BSET.B Dn,(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_01e8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte_000 (dsta, dst);
}}}}	m68k_incpci (4);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* BSET.B Dn,(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_01f0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (4));
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte_000 (dsta, dst);
}}}}	m68k_incpci (4);
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/1) */

/* BSET.B Dn,(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_01f8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte_000 (dsta, dst);
}}}}	m68k_incpci (4);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* BSET.B Dn,(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_01f9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_word_000_prefetch (4) << 16;
	dsta |= get_word_000_prefetch (6);
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte_000 (dsta, dst);
}}}}	m68k_incpci (6);
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* AND.B #<data>.B,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_0200_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_000_prefetch (4);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}	m68k_incpci (4);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (2/0) */

/* AND.B #<data>.B,(An) */
uae_u32 REGPARAM2 CPUFUNC(op_0210_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_000 (dsta);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	put_byte_000 (dsta, src);
}}}}	m68k_incpci (4);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* AND.B #<data>.B,(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_0218_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_000 (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	put_byte_000 (dsta, src);
}}}}	m68k_incpci (4);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* AND.B #<data>.B,-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_0220_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte_000 (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	put_byte_000 (dsta, src);
}}}}	m68k_incpci (4);
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/1) */

/* AND.B #<data>.B,(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_0228_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (6);
{	uae_s8 dst = get_byte_000 (dsta);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	put_byte_000 (dsta, src);
}}}}	m68k_incpci (6);
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* AND.B #<data>.B,(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_0230_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (6));
{	uae_s8 dst = get_byte_000 (dsta);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	put_byte_000 (dsta, src);
}}}}	m68k_incpci (6);
return 22 * CYCLE_UNIT / 2 + count_cycles;
} /* 22 (4/1) */

/* AND.B #<data>.B,(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_0238_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uae_s8 src = (uae_u8)get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (6);
{	uae_s8 dst = get_byte_000 (dsta);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	put_byte_000 (dsta, src);
}}}}	m68k_incpci (6);
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* AND.B #<data>.B,(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_0239_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uae_s8 src = (uae_u8)get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = get_word_000_prefetch (6) << 16;
	dsta |= get_word_000_prefetch (8);
{	uae_s8 dst = get_byte_000 (dsta);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (10);
	put_byte_000 (dsta, src);
}}}}	m68k_incpci (8);
return 24 * CYCLE_UNIT / 2 + count_cycles;
} /* 24 (5/1) */

/* ANDSR.B #<data>.W */
uae_u32 REGPARAM2 CPUFUNC(op_023c_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{	MakeSR ();
{	uae_s16 src = get_word_000_prefetch (4);
	src |= 0xFF00;
	m68k_incpci (4);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
	regs.sr &= src;
	MakeFromSR();
}}return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (3/0) */

/* AND.W #<data>.W,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_0240_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}	m68k_incpci (4);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (2/0) */

/* AND.W #<data>.W,(An) */
uae_u32 REGPARAM2 CPUFUNC(op_0250_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_110076;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	put_word_000 (dsta, src);
}}}}}	m68k_incpci (4);
l_110076: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* AND.W #<data>.W,(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_0258_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_110077;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	m68k_areg (regs, dstreg) += 2;
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	put_word_000 (dsta, src);
}}}}}	m68k_incpci (4);
l_110077: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* AND.W #<data>.W,-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_0260_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_110078;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	put_word_000 (dsta, src);
}}}}}	m68k_incpci (4);
l_110078: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/1) */

/* AND.W #<data>.W,(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_0268_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_110079;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	put_word_000 (dsta, src);
}}}}}	m68k_incpci (6);
l_110079: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* AND.W #<data>.W,(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_0270_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (6));
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_110080;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	put_word_000 (dsta, src);
}}}}}	m68k_incpci (6);
l_110080: ;
return 22 * CYCLE_UNIT / 2 + count_cycles;
} /* 22 (4/1) */

/* AND.W #<data>.W,(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_0278_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_110081;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	put_word_000 (dsta, src);
}}}}}	m68k_incpci (6);
l_110081: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* AND.W #<data>.W,(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_0279_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = get_word_000_prefetch (6) << 16;
	dsta |= get_word_000_prefetch (8);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_read(opcode, dsta);
		goto l_110082;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (10);
	put_word_000 (dsta, src);
}}}}}	m68k_incpci (8);
l_110082: ;
return 24 * CYCLE_UNIT / 2 + count_cycles;
} /* 24 (5/1) */

/* ANDSR.W #<data>.W */
uae_u32 REGPARAM2 CPUFUNC(op_027c_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{if (!regs.s) { Exception (8); goto l_110083; }
{	MakeSR ();
{	uae_s16 src = get_word_000_prefetch (4);
	m68k_incpci (4);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
	regs.sr &= src;
	MakeFromSR();
}}}l_110083: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (3/0) */

/* AND.L #<data>.L,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_0280_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_000_prefetch (4) << 16;
	src |= get_word_000_prefetch (6);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	m68k_dreg (regs, dstreg) = (src);
}}}	m68k_incpci (6);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/0) */

/* AND.L #<data>.L,(An) */
uae_u32 REGPARAM2 CPUFUNC(op_0290_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_000_prefetch (4) << 16;
	src |= get_word_000_prefetch (6);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_110085;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	put_word_000 (dsta + 2, src); put_word_000 (dsta, src >> 16);
}}}}}	m68k_incpci (6);
l_110085: ;
return 28 * CYCLE_UNIT / 2 + count_cycles;
} /* 28 (5/2) */

/* AND.L #<data>.L,(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_0298_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_000_prefetch (4) << 16;
	src |= get_word_000_prefetch (6);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_110086;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	m68k_areg (regs, dstreg) += 4;
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	put_word_000 (dsta + 2, src); put_word_000 (dsta, src >> 16);
}}}}}	m68k_incpci (6);
l_110086: ;
return 28 * CYCLE_UNIT / 2 + count_cycles;
} /* 28 (5/2) */

/* AND.L #<data>.L,-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_02a0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_000_prefetch (4) << 16;
	src |= get_word_000_prefetch (6);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_110087;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	m68k_areg (regs, dstreg) = dsta;
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	put_word_000 (dsta + 2, src); put_word_000 (dsta, src >> 16);
}}}}}	m68k_incpci (6);
l_110087: ;
return 30 * CYCLE_UNIT / 2 + count_cycles;
} /* 30 (5/2) */

/* AND.L #<data>.L,(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_02a8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_000_prefetch (4) << 16;
	src |= get_word_000_prefetch (6);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (8);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_110088;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (10);
	put_word_000 (dsta + 2, src); put_word_000 (dsta, src >> 16);
}}}}}	m68k_incpci (8);
l_110088: ;
return 32 * CYCLE_UNIT / 2 + count_cycles;
} /* 32 (6/2) */

/* AND.L #<data>.L,(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_02b0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_000_prefetch (4) << 16;
	src |= get_word_000_prefetch (6);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (8));
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_110089;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (10);
	put_word_000 (dsta + 2, src); put_word_000 (dsta, src >> 16);
}}}}}	m68k_incpci (8);
l_110089: ;
return 34 * CYCLE_UNIT / 2 + count_cycles;
} /* 34 (6/2) */

/* AND.L #<data>.L,(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_02b8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uae_s32 src;
	src = get_word_000_prefetch (4) << 16;
	src |= get_word_000_prefetch (6);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (8);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_110090;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (10);
	put_word_000 (dsta + 2, src); put_word_000 (dsta, src >> 16);
}}}}}	m68k_incpci (8);
l_110090: ;
return 32 * CYCLE_UNIT / 2 + count_cycles;
} /* 32 (6/2) */

/* AND.L #<data>.L,(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_02b9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uae_s32 src;
	src = get_word_000_prefetch (4) << 16;
	src |= get_word_000_prefetch (6);
{	uaecptr dsta;
	dsta = get_word_000_prefetch (8) << 16;
	dsta |= get_word_000_prefetch (10);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_read(opcode, dsta);
		goto l_110091;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (12);
	put_word_000 (dsta + 2, src); put_word_000 (dsta, src >> 16);
}}}}}	m68k_incpci (10);
l_110091: ;
return 36 * CYCLE_UNIT / 2 + count_cycles;
} /* 36 (7/2) */

/* SUB.B #<data>.B,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_0400_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_000_prefetch (4);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}	m68k_incpci (4);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (2/0) */

/* SUB.B #<data>.B,(An) */
uae_u32 REGPARAM2 CPUFUNC(op_0410_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_byte_000 (dsta, newv);
}}}}}}}	m68k_incpci (4);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* SUB.B #<data>.B,(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_0418_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_000 (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_byte_000 (dsta, newv);
}}}}}}}	m68k_incpci (4);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* SUB.B #<data>.B,-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_0420_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte_000 (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_byte_000 (dsta, newv);
}}}}}}}	m68k_incpci (4);
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/1) */

/* SUB.B #<data>.B,(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_0428_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (6);
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_byte_000 (dsta, newv);
}}}}}}}	m68k_incpci (6);
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* SUB.B #<data>.B,(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_0430_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (6));
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_byte_000 (dsta, newv);
}}}}}}}	m68k_incpci (6);
return 22 * CYCLE_UNIT / 2 + count_cycles;
} /* 22 (4/1) */

/* SUB.B #<data>.B,(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_0438_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uae_s8 src = (uae_u8)get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (6);
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_byte_000 (dsta, newv);
}}}}}}}	m68k_incpci (6);
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* SUB.B #<data>.B,(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_0439_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uae_s8 src = (uae_u8)get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = get_word_000_prefetch (6) << 16;
	dsta |= get_word_000_prefetch (8);
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (10);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_byte_000 (dsta, newv);
}}}}}}}	m68k_incpci (8);
return 24 * CYCLE_UNIT / 2 + count_cycles;
} /* 24 (5/1) */

/* SUB.W #<data>.W,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_0440_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}	m68k_incpci (4);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (2/0) */

/* SUB.W #<data>.W,(An) */
uae_u32 REGPARAM2 CPUFUNC(op_0450_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_110101;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta, newv);
}}}}}}}}	m68k_incpci (4);
l_110101: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* SUB.W #<data>.W,(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_0458_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_110102;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	m68k_areg (regs, dstreg) += 2;
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta, newv);
}}}}}}}}	m68k_incpci (4);
l_110102: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* SUB.W #<data>.W,-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_0460_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_110103;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta, newv);
}}}}}}}}	m68k_incpci (4);
l_110103: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/1) */

/* SUB.W #<data>.W,(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_0468_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_110104;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta, newv);
}}}}}}}}	m68k_incpci (6);
l_110104: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* SUB.W #<data>.W,(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_0470_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (6));
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_110105;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta, newv);
}}}}}}}}	m68k_incpci (6);
l_110105: ;
return 22 * CYCLE_UNIT / 2 + count_cycles;
} /* 22 (4/1) */

/* SUB.W #<data>.W,(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_0478_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_110106;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta, newv);
}}}}}}}}	m68k_incpci (6);
l_110106: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* SUB.W #<data>.W,(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_0479_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = get_word_000_prefetch (6) << 16;
	dsta |= get_word_000_prefetch (8);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_read(opcode, dsta);
		goto l_110107;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (10);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta, newv);
}}}}}}}}	m68k_incpci (8);
l_110107: ;
return 24 * CYCLE_UNIT / 2 + count_cycles;
} /* 24 (5/1) */

/* SUB.L #<data>.L,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_0480_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_000_prefetch (4) << 16;
	src |= get_word_000_prefetch (6);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (6);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/0) */

/* SUB.L #<data>.L,(An) */
uae_u32 REGPARAM2 CPUFUNC(op_0490_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_000_prefetch (4) << 16;
	src |= get_word_000_prefetch (6);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_110109;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta + 2, newv); put_word_000 (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (6);
l_110109: ;
return 28 * CYCLE_UNIT / 2 + count_cycles;
} /* 28 (5/2) */

/* SUB.L #<data>.L,(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_0498_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_000_prefetch (4) << 16;
	src |= get_word_000_prefetch (6);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_110110;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	m68k_areg (regs, dstreg) += 4;
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta + 2, newv); put_word_000 (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (6);
l_110110: ;
return 28 * CYCLE_UNIT / 2 + count_cycles;
} /* 28 (5/2) */

/* SUB.L #<data>.L,-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_04a0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_000_prefetch (4) << 16;
	src |= get_word_000_prefetch (6);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_110111;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta + 2, newv); put_word_000 (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (6);
l_110111: ;
return 30 * CYCLE_UNIT / 2 + count_cycles;
} /* 30 (5/2) */

/* SUB.L #<data>.L,(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_04a8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_000_prefetch (4) << 16;
	src |= get_word_000_prefetch (6);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (8);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_110112;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	regs.ir = regs.irc;
	get_word_000_prefetch (10);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta + 2, newv); put_word_000 (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (8);
l_110112: ;
return 32 * CYCLE_UNIT / 2 + count_cycles;
} /* 32 (6/2) */

/* SUB.L #<data>.L,(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_04b0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_000_prefetch (4) << 16;
	src |= get_word_000_prefetch (6);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (8));
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_110113;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	regs.ir = regs.irc;
	get_word_000_prefetch (10);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta + 2, newv); put_word_000 (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (8);
l_110113: ;
return 34 * CYCLE_UNIT / 2 + count_cycles;
} /* 34 (6/2) */

/* SUB.L #<data>.L,(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_04b8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uae_s32 src;
	src = get_word_000_prefetch (4) << 16;
	src |= get_word_000_prefetch (6);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (8);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_110114;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	regs.ir = regs.irc;
	get_word_000_prefetch (10);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta + 2, newv); put_word_000 (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (8);
l_110114: ;
return 32 * CYCLE_UNIT / 2 + count_cycles;
} /* 32 (6/2) */

/* SUB.L #<data>.L,(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_04b9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uae_s32 src;
	src = get_word_000_prefetch (4) << 16;
	src |= get_word_000_prefetch (6);
{	uaecptr dsta;
	dsta = get_word_000_prefetch (8) << 16;
	dsta |= get_word_000_prefetch (10);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_read(opcode, dsta);
		goto l_110115;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	regs.ir = regs.irc;
	get_word_000_prefetch (12);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta + 2, newv); put_word_000 (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (10);
l_110115: ;
return 36 * CYCLE_UNIT / 2 + count_cycles;
} /* 36 (7/2) */

/* ADD.B #<data>.B,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_0600_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_000_prefetch (4);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}	m68k_incpci (4);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (2/0) */

/* ADD.B #<data>.B,(An) */
uae_u32 REGPARAM2 CPUFUNC(op_0610_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_byte_000 (dsta, newv);
}}}}}}}	m68k_incpci (4);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* ADD.B #<data>.B,(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_0618_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_000 (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_byte_000 (dsta, newv);
}}}}}}}	m68k_incpci (4);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* ADD.B #<data>.B,-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_0620_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte_000 (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_byte_000 (dsta, newv);
}}}}}}}	m68k_incpci (4);
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/1) */

/* ADD.B #<data>.B,(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_0628_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (6);
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_byte_000 (dsta, newv);
}}}}}}}	m68k_incpci (6);
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* ADD.B #<data>.B,(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_0630_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (6));
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_byte_000 (dsta, newv);
}}}}}}}	m68k_incpci (6);
return 22 * CYCLE_UNIT / 2 + count_cycles;
} /* 22 (4/1) */

/* ADD.B #<data>.B,(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_0638_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uae_s8 src = (uae_u8)get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (6);
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_byte_000 (dsta, newv);
}}}}}}}	m68k_incpci (6);
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* ADD.B #<data>.B,(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_0639_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uae_s8 src = (uae_u8)get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = get_word_000_prefetch (6) << 16;
	dsta |= get_word_000_prefetch (8);
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (10);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_byte_000 (dsta, newv);
}}}}}}}	m68k_incpci (8);
return 24 * CYCLE_UNIT / 2 + count_cycles;
} /* 24 (5/1) */

/* ADD.W #<data>.W,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_0640_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}	m68k_incpci (4);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (2/0) */

/* ADD.W #<data>.W,(An) */
uae_u32 REGPARAM2 CPUFUNC(op_0650_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_110125;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta, newv);
}}}}}}}}	m68k_incpci (4);
l_110125: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* ADD.W #<data>.W,(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_0658_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_110126;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	m68k_areg (regs, dstreg) += 2;
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta, newv);
}}}}}}}}	m68k_incpci (4);
l_110126: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* ADD.W #<data>.W,-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_0660_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_110127;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta, newv);
}}}}}}}}	m68k_incpci (4);
l_110127: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/1) */

/* ADD.W #<data>.W,(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_0668_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_110128;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta, newv);
}}}}}}}}	m68k_incpci (6);
l_110128: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* ADD.W #<data>.W,(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_0670_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (6));
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_110129;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta, newv);
}}}}}}}}	m68k_incpci (6);
l_110129: ;
return 22 * CYCLE_UNIT / 2 + count_cycles;
} /* 22 (4/1) */

/* ADD.W #<data>.W,(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_0678_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_110130;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta, newv);
}}}}}}}}	m68k_incpci (6);
l_110130: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* ADD.W #<data>.W,(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_0679_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = get_word_000_prefetch (6) << 16;
	dsta |= get_word_000_prefetch (8);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_read(opcode, dsta);
		goto l_110131;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (10);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta, newv);
}}}}}}}}	m68k_incpci (8);
l_110131: ;
return 24 * CYCLE_UNIT / 2 + count_cycles;
} /* 24 (5/1) */

/* ADD.L #<data>.L,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_0680_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_000_prefetch (4) << 16;
	src |= get_word_000_prefetch (6);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (6);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/0) */

/* ADD.L #<data>.L,(An) */
uae_u32 REGPARAM2 CPUFUNC(op_0690_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_000_prefetch (4) << 16;
	src |= get_word_000_prefetch (6);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_110133;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta + 2, newv); put_word_000 (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (6);
l_110133: ;
return 28 * CYCLE_UNIT / 2 + count_cycles;
} /* 28 (5/2) */

/* ADD.L #<data>.L,(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_0698_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_000_prefetch (4) << 16;
	src |= get_word_000_prefetch (6);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_110134;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	m68k_areg (regs, dstreg) += 4;
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta + 2, newv); put_word_000 (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (6);
l_110134: ;
return 28 * CYCLE_UNIT / 2 + count_cycles;
} /* 28 (5/2) */

/* ADD.L #<data>.L,-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_06a0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_000_prefetch (4) << 16;
	src |= get_word_000_prefetch (6);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_110135;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta + 2, newv); put_word_000 (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (6);
l_110135: ;
return 30 * CYCLE_UNIT / 2 + count_cycles;
} /* 30 (5/2) */

/* ADD.L #<data>.L,(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_06a8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_000_prefetch (4) << 16;
	src |= get_word_000_prefetch (6);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (8);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_110136;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	regs.ir = regs.irc;
	get_word_000_prefetch (10);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta + 2, newv); put_word_000 (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (8);
l_110136: ;
return 32 * CYCLE_UNIT / 2 + count_cycles;
} /* 32 (6/2) */

/* ADD.L #<data>.L,(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_06b0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_000_prefetch (4) << 16;
	src |= get_word_000_prefetch (6);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (8));
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_110137;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	regs.ir = regs.irc;
	get_word_000_prefetch (10);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta + 2, newv); put_word_000 (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (8);
l_110137: ;
return 34 * CYCLE_UNIT / 2 + count_cycles;
} /* 34 (6/2) */

/* ADD.L #<data>.L,(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_06b8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uae_s32 src;
	src = get_word_000_prefetch (4) << 16;
	src |= get_word_000_prefetch (6);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (8);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_110138;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	regs.ir = regs.irc;
	get_word_000_prefetch (10);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta + 2, newv); put_word_000 (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (8);
l_110138: ;
return 32 * CYCLE_UNIT / 2 + count_cycles;
} /* 32 (6/2) */

/* ADD.L #<data>.L,(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_06b9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uae_s32 src;
	src = get_word_000_prefetch (4) << 16;
	src |= get_word_000_prefetch (6);
{	uaecptr dsta;
	dsta = get_word_000_prefetch (8) << 16;
	dsta |= get_word_000_prefetch (10);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_read(opcode, dsta);
		goto l_110139;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	regs.ir = regs.irc;
	get_word_000_prefetch (12);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta + 2, newv); put_word_000 (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (10);
l_110139: ;
return 36 * CYCLE_UNIT / 2 + count_cycles;
} /* 36 (7/2) */

/* BTST.L #<data>.W,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_0800_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	src &= 31;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}	m68k_incpci (4);
return 10 * CYCLE_UNIT / 2 + count_cycles;
} /* 10 (2/0) */

/* BTST.B #<data>.W,(An) */
uae_u32 REGPARAM2 CPUFUNC(op_0810_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}	m68k_incpci (4);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (3/0) */

/* BTST.B #<data>.W,(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_0818_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_000 (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}	m68k_incpci (4);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (3/0) */

/* BTST.B #<data>.W,-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_0820_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte_000 (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}	m68k_incpci (4);
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (3/0) */

/* BTST.B #<data>.W,(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_0828_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (6);
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}	m68k_incpci (6);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (4/0) */

/* BTST.B #<data>.W,(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_0830_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (6));
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}	m68k_incpci (6);
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (4/0) */

/* BTST.B #<data>.W,(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_0838_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (6);
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}	m68k_incpci (6);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (4/0) */

/* BTST.B #<data>.W,(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_0839_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = get_word_000_prefetch (6) << 16;
	dsta |= get_word_000_prefetch (8);
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (10);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}	m68k_incpci (8);
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (5/0) */

/* BTST.B #<data>.W,(d16,PC) */
uae_u32 REGPARAM2 CPUFUNC(op_083a_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 2;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_getpci () + 4;
	dsta += (uae_s32)(uae_s16)get_word_000_prefetch (6);
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}	m68k_incpci (6);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (4/0) */

/* BTST.B #<data>.W,(d8,PC,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_083b_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 3;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr tmppc;
	uaecptr dsta;
	tmppc = m68k_getpci () + 4;
	dsta = get_disp_ea_000 (tmppc, get_word_000_prefetch (6));
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
}}}}	m68k_incpci (6);
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (4/0) */

/* BCHG.L #<data>.W,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_0840_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	src &= 31;
	if (src > 15) count_cycles += 2 * CYCLE_UNIT / 2;
	dst ^= (1 << src);
	SET_ZFLG (((uae_u32)dst & (1 << src)) >> src);
	m68k_dreg (regs, dstreg) = (dst);
}}}	m68k_incpci (4);
return 10 * CYCLE_UNIT / 2 + count_cycles;
} /* 10+ (2/0) */

/* BCHG.B #<data>.W,(An) */
uae_u32 REGPARAM2 CPUFUNC(op_0850_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uae_u32)dst & (1 << src)) >> src);
	put_byte_000 (dsta, dst);
}}}}	m68k_incpci (4);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* BCHG.B #<data>.W,(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_0858_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_000 (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uae_u32)dst & (1 << src)) >> src);
	put_byte_000 (dsta, dst);
}}}}	m68k_incpci (4);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* BCHG.B #<data>.W,-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_0860_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte_000 (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uae_u32)dst & (1 << src)) >> src);
	put_byte_000 (dsta, dst);
}}}}	m68k_incpci (4);
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/1) */

/* BCHG.B #<data>.W,(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_0868_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (6);
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uae_u32)dst & (1 << src)) >> src);
	put_byte_000 (dsta, dst);
}}}}	m68k_incpci (6);
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* BCHG.B #<data>.W,(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_0870_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (6));
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uae_u32)dst & (1 << src)) >> src);
	put_byte_000 (dsta, dst);
}}}}	m68k_incpci (6);
return 22 * CYCLE_UNIT / 2 + count_cycles;
} /* 22 (4/1) */

/* BCHG.B #<data>.W,(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_0878_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (6);
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uae_u32)dst & (1 << src)) >> src);
	put_byte_000 (dsta, dst);
}}}}	m68k_incpci (6);
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* BCHG.B #<data>.W,(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_0879_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = get_word_000_prefetch (6) << 16;
	dsta |= get_word_000_prefetch (8);
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (10);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG (((uae_u32)dst & (1 << src)) >> src);
	put_byte_000 (dsta, dst);
}}}}	m68k_incpci (8);
return 24 * CYCLE_UNIT / 2 + count_cycles;
} /* 24 (5/1) */

/* BCLR.L #<data>.W,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_0880_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	src &= 31;
	if (src > 15) count_cycles += 2 * CYCLE_UNIT / 2;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	m68k_dreg (regs, dstreg) = (dst);
}}}	m68k_incpci (4);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12+ (2/0) */

/* BCLR.B #<data>.W,(An) */
uae_u32 REGPARAM2 CPUFUNC(op_0890_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte_000 (dsta, dst);
}}}}	m68k_incpci (4);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* BCLR.B #<data>.W,(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_0898_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_000 (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte_000 (dsta, dst);
}}}}	m68k_incpci (4);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* BCLR.B #<data>.W,-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_08a0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte_000 (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte_000 (dsta, dst);
}}}}	m68k_incpci (4);
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/1) */

/* BCLR.B #<data>.W,(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_08a8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (6);
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte_000 (dsta, dst);
}}}}	m68k_incpci (6);
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* BCLR.B #<data>.W,(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_08b0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (6));
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte_000 (dsta, dst);
}}}}	m68k_incpci (6);
return 22 * CYCLE_UNIT / 2 + count_cycles;
} /* 22 (4/1) */

/* BCLR.B #<data>.W,(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_08b8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (6);
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte_000 (dsta, dst);
}}}}	m68k_incpci (6);
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* BCLR.B #<data>.W,(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_08b9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = get_word_000_prefetch (6) << 16;
	dsta |= get_word_000_prefetch (8);
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (10);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	put_byte_000 (dsta, dst);
}}}}	m68k_incpci (8);
return 24 * CYCLE_UNIT / 2 + count_cycles;
} /* 24 (5/1) */

/* BSET.L #<data>.W,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_08c0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	src &= 31;
	if (src > 15) count_cycles += 2 * CYCLE_UNIT / 2;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	m68k_dreg (regs, dstreg) = (dst);
}}}	m68k_incpci (4);
return 10 * CYCLE_UNIT / 2 + count_cycles;
} /* 10+ (2/0) */

/* BSET.B #<data>.W,(An) */
uae_u32 REGPARAM2 CPUFUNC(op_08d0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte_000 (dsta, dst);
}}}}	m68k_incpci (4);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* BSET.B #<data>.W,(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_08d8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_000 (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte_000 (dsta, dst);
}}}}	m68k_incpci (4);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* BSET.B #<data>.W,-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_08e0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte_000 (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte_000 (dsta, dst);
}}}}	m68k_incpci (4);
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/1) */

/* BSET.B #<data>.W,(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_08e8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (6);
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte_000 (dsta, dst);
}}}}	m68k_incpci (6);
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* BSET.B #<data>.W,(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_08f0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (6));
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte_000 (dsta, dst);
}}}}	m68k_incpci (6);
return 22 * CYCLE_UNIT / 2 + count_cycles;
} /* 22 (4/1) */

/* BSET.B #<data>.W,(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_08f8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (6);
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte_000 (dsta, dst);
}}}}	m68k_incpci (6);
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* BSET.B #<data>.W,(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_08f9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = get_word_000_prefetch (6) << 16;
	dsta |= get_word_000_prefetch (8);
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (10);
	src &= 7;
	SET_ZFLG (1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	put_byte_000 (dsta, dst);
}}}}	m68k_incpci (8);
return 24 * CYCLE_UNIT / 2 + count_cycles;
} /* 24 (5/1) */

/* EOR.B #<data>.B,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_0a00_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_000_prefetch (4);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}	m68k_incpci (4);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (2/0) */

/* EOR.B #<data>.B,(An) */
uae_u32 REGPARAM2 CPUFUNC(op_0a10_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_000 (dsta);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	put_byte_000 (dsta, src);
}}}}	m68k_incpci (4);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* EOR.B #<data>.B,(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_0a18_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_000 (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	put_byte_000 (dsta, src);
}}}}	m68k_incpci (4);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* EOR.B #<data>.B,-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_0a20_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte_000 (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	put_byte_000 (dsta, src);
}}}}	m68k_incpci (4);
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/1) */

/* EOR.B #<data>.B,(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_0a28_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (6);
{	uae_s8 dst = get_byte_000 (dsta);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	put_byte_000 (dsta, src);
}}}}	m68k_incpci (6);
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* EOR.B #<data>.B,(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_0a30_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (6));
{	uae_s8 dst = get_byte_000 (dsta);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	put_byte_000 (dsta, src);
}}}}	m68k_incpci (6);
return 22 * CYCLE_UNIT / 2 + count_cycles;
} /* 22 (4/1) */

/* EOR.B #<data>.B,(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_0a38_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uae_s8 src = (uae_u8)get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (6);
{	uae_s8 dst = get_byte_000 (dsta);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	put_byte_000 (dsta, src);
}}}}	m68k_incpci (6);
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* EOR.B #<data>.B,(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_0a39_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uae_s8 src = (uae_u8)get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = get_word_000_prefetch (6) << 16;
	dsta |= get_word_000_prefetch (8);
{	uae_s8 dst = get_byte_000 (dsta);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (10);
	put_byte_000 (dsta, src);
}}}}	m68k_incpci (8);
return 24 * CYCLE_UNIT / 2 + count_cycles;
} /* 24 (5/1) */

/* EORSR.B #<data>.W */
uae_u32 REGPARAM2 CPUFUNC(op_0a3c_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{	MakeSR ();
{	uae_s16 src = get_word_000_prefetch (4);
	src &= 0xFF;
	m68k_incpci (4);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
	regs.sr ^= src;
	MakeFromSR();
}}return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (3/0) */

/* EOR.W #<data>.W,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_0a40_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}	m68k_incpci (4);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (2/0) */

/* EOR.W #<data>.W,(An) */
uae_u32 REGPARAM2 CPUFUNC(op_0a50_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_110184;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	put_word_000 (dsta, src);
}}}}}	m68k_incpci (4);
l_110184: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* EOR.W #<data>.W,(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_0a58_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_110185;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	m68k_areg (regs, dstreg) += 2;
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	put_word_000 (dsta, src);
}}}}}	m68k_incpci (4);
l_110185: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* EOR.W #<data>.W,-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_0a60_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_110186;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	put_word_000 (dsta, src);
}}}}}	m68k_incpci (4);
l_110186: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/1) */

/* EOR.W #<data>.W,(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_0a68_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_110187;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	put_word_000 (dsta, src);
}}}}}	m68k_incpci (6);
l_110187: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* EOR.W #<data>.W,(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_0a70_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (6));
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_110188;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	put_word_000 (dsta, src);
}}}}}	m68k_incpci (6);
l_110188: ;
return 22 * CYCLE_UNIT / 2 + count_cycles;
} /* 22 (4/1) */

/* EOR.W #<data>.W,(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_0a78_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_110189;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	put_word_000 (dsta, src);
}}}}}	m68k_incpci (6);
l_110189: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* EOR.W #<data>.W,(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_0a79_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = get_word_000_prefetch (6) << 16;
	dsta |= get_word_000_prefetch (8);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_read(opcode, dsta);
		goto l_110190;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (10);
	put_word_000 (dsta, src);
}}}}}	m68k_incpci (8);
l_110190: ;
return 24 * CYCLE_UNIT / 2 + count_cycles;
} /* 24 (5/1) */

/* EORSR.W #<data>.W */
uae_u32 REGPARAM2 CPUFUNC(op_0a7c_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{if (!regs.s) { Exception (8); goto l_110191; }
{	MakeSR ();
{	uae_s16 src = get_word_000_prefetch (4);
	m68k_incpci (4);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
	regs.sr ^= src;
	MakeFromSR();
}}}l_110191: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (3/0) */

/* EOR.L #<data>.L,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_0a80_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_000_prefetch (4) << 16;
	src |= get_word_000_prefetch (6);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	m68k_dreg (regs, dstreg) = (src);
}}}	m68k_incpci (6);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/0) */

/* EOR.L #<data>.L,(An) */
uae_u32 REGPARAM2 CPUFUNC(op_0a90_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_000_prefetch (4) << 16;
	src |= get_word_000_prefetch (6);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_110193;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	put_word_000 (dsta + 2, src); put_word_000 (dsta, src >> 16);
}}}}}	m68k_incpci (6);
l_110193: ;
return 28 * CYCLE_UNIT / 2 + count_cycles;
} /* 28 (5/2) */

/* EOR.L #<data>.L,(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_0a98_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_000_prefetch (4) << 16;
	src |= get_word_000_prefetch (6);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_110194;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	m68k_areg (regs, dstreg) += 4;
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	put_word_000 (dsta + 2, src); put_word_000 (dsta, src >> 16);
}}}}}	m68k_incpci (6);
l_110194: ;
return 28 * CYCLE_UNIT / 2 + count_cycles;
} /* 28 (5/2) */

/* EOR.L #<data>.L,-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_0aa0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_000_prefetch (4) << 16;
	src |= get_word_000_prefetch (6);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_110195;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	m68k_areg (regs, dstreg) = dsta;
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	put_word_000 (dsta + 2, src); put_word_000 (dsta, src >> 16);
}}}}}	m68k_incpci (6);
l_110195: ;
return 30 * CYCLE_UNIT / 2 + count_cycles;
} /* 30 (5/2) */

/* EOR.L #<data>.L,(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_0aa8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_000_prefetch (4) << 16;
	src |= get_word_000_prefetch (6);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (8);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_110196;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (10);
	put_word_000 (dsta + 2, src); put_word_000 (dsta, src >> 16);
}}}}}	m68k_incpci (8);
l_110196: ;
return 32 * CYCLE_UNIT / 2 + count_cycles;
} /* 32 (6/2) */

/* EOR.L #<data>.L,(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_0ab0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_000_prefetch (4) << 16;
	src |= get_word_000_prefetch (6);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (8));
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_110197;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (10);
	put_word_000 (dsta + 2, src); put_word_000 (dsta, src >> 16);
}}}}}	m68k_incpci (8);
l_110197: ;
return 34 * CYCLE_UNIT / 2 + count_cycles;
} /* 34 (6/2) */

/* EOR.L #<data>.L,(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_0ab8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uae_s32 src;
	src = get_word_000_prefetch (4) << 16;
	src |= get_word_000_prefetch (6);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (8);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_110198;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (10);
	put_word_000 (dsta + 2, src); put_word_000 (dsta, src >> 16);
}}}}}	m68k_incpci (8);
l_110198: ;
return 32 * CYCLE_UNIT / 2 + count_cycles;
} /* 32 (6/2) */

/* EOR.L #<data>.L,(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_0ab9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uae_s32 src;
	src = get_word_000_prefetch (4) << 16;
	src |= get_word_000_prefetch (6);
{	uaecptr dsta;
	dsta = get_word_000_prefetch (8) << 16;
	dsta |= get_word_000_prefetch (10);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_read(opcode, dsta);
		goto l_110199;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (12);
	put_word_000 (dsta + 2, src); put_word_000 (dsta, src >> 16);
}}}}}	m68k_incpci (10);
l_110199: ;
return 36 * CYCLE_UNIT / 2 + count_cycles;
} /* 36 (7/2) */

#endif

#ifdef PART_2
/* CMP.B #<data>.B,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_0c00_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_000_prefetch (4);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}	m68k_incpci (4);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (2/0) */

/* CMP.B #<data>.B,(An) */
uae_u32 REGPARAM2 CPUFUNC(op_0c10_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (4);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (3/0) */

/* CMP.B #<data>.B,(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_0c18_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_000 (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (4);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (3/0) */

/* CMP.B #<data>.B,-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_0c20_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte_000 (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (4);
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (3/0) */

/* CMP.B #<data>.B,(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_0c28_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (6);
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (6);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (4/0) */

/* CMP.B #<data>.B,(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_0c30_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = (uae_u8)get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (6));
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (6);
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (4/0) */

/* CMP.B #<data>.B,(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_0c38_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uae_s8 src = (uae_u8)get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (6);
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (6);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (4/0) */

/* CMP.B #<data>.B,(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_0c39_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uae_s8 src = (uae_u8)get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = get_word_000_prefetch (6) << 16;
	dsta |= get_word_000_prefetch (8);
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (10);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (8);
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (5/0) */

/* CMP.W #<data>.W,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_0c40_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}	m68k_incpci (4);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (2/0) */

/* CMP.W #<data>.W,(An) */
uae_u32 REGPARAM2 CPUFUNC(op_0c50_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_110209;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (4);
l_110209: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (3/0) */

/* CMP.W #<data>.W,(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_0c58_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_110210;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	m68k_areg (regs, dstreg) += 2;
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (4);
l_110210: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (3/0) */

/* CMP.W #<data>.W,-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_0c60_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_110211;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (4);
l_110211: ;
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (3/0) */

/* CMP.W #<data>.W,(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_0c68_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_110212;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (6);
l_110212: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (4/0) */

/* CMP.W #<data>.W,(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_0c70_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (6));
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_110213;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (6);
l_110213: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (4/0) */

/* CMP.W #<data>.W,(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_0c78_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_110214;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (6);
l_110214: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (4/0) */

/* CMP.W #<data>.W,(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_0c79_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = get_word_000_prefetch (6) << 16;
	dsta |= get_word_000_prefetch (8);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_read(opcode, dsta);
		goto l_110215;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (10);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (8);
l_110215: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (5/0) */

/* CMP.L #<data>.L,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_0c80_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_000_prefetch (4) << 16;
	src |= get_word_000_prefetch (6);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}	m68k_incpci (6);
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (3/0) */

/* CMP.L #<data>.L,(An) */
uae_u32 REGPARAM2 CPUFUNC(op_0c90_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_000_prefetch (4) << 16;
	src |= get_word_000_prefetch (6);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_110217;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (6);
l_110217: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (5/0) */

/* CMP.L #<data>.L,(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_0c98_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_000_prefetch (4) << 16;
	src |= get_word_000_prefetch (6);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_110218;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	m68k_areg (regs, dstreg) += 4;
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (6);
l_110218: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (5/0) */

/* CMP.L #<data>.L,-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_0ca0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_000_prefetch (4) << 16;
	src |= get_word_000_prefetch (6);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_110219;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (6);
l_110219: ;
return 22 * CYCLE_UNIT / 2 + count_cycles;
} /* 22 (5/0) */

/* CMP.L #<data>.L,(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_0ca8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_000_prefetch (4) << 16;
	src |= get_word_000_prefetch (6);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (8);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_110220;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	regs.ir = regs.irc;
	get_word_000_prefetch (10);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (8);
l_110220: ;
return 24 * CYCLE_UNIT / 2 + count_cycles;
} /* 24 (6/0) */

/* CMP.L #<data>.L,(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_0cb0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src;
	src = get_word_000_prefetch (4) << 16;
	src |= get_word_000_prefetch (6);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (8));
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_110221;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	regs.ir = regs.irc;
	get_word_000_prefetch (10);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (8);
l_110221: ;
return 26 * CYCLE_UNIT / 2 + count_cycles;
} /* 26 (6/0) */

/* CMP.L #<data>.L,(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_0cb8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uae_s32 src;
	src = get_word_000_prefetch (4) << 16;
	src |= get_word_000_prefetch (6);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (8);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_110222;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	regs.ir = regs.irc;
	get_word_000_prefetch (10);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (8);
l_110222: ;
return 24 * CYCLE_UNIT / 2 + count_cycles;
} /* 24 (6/0) */

/* CMP.L #<data>.L,(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_0cb9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uae_s32 src;
	src = get_word_000_prefetch (4) << 16;
	src |= get_word_000_prefetch (6);
{	uaecptr dsta;
	dsta = get_word_000_prefetch (8) << 16;
	dsta |= get_word_000_prefetch (10);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_read(opcode, dsta);
		goto l_110223;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	regs.ir = regs.irc;
	get_word_000_prefetch (12);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (10);
l_110223: ;
return 28 * CYCLE_UNIT / 2 + count_cycles;
} /* 28 (7/0) */

/* MOVE.B Dn,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_1000_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4 (1/0) */

/* MOVE.B (An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_1010_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_000 (srca);
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (2/0) */

/* MOVE.B (An)+,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_1018_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_000 (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (2/0) */

/* MOVE.B -(An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_1020_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte_000 (srca);
	m68k_areg (regs, srcreg) = srca;
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}return 10 * CYCLE_UNIT / 2 + count_cycles;
} /* 10 (2/0) */

/* MOVE.B (d16,An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_1028_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 src = get_byte_000 (srca);
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (3/0) */

/* MOVE.B (d8,An,Xn),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_1030_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
{	uae_s8 src = get_byte_000 (srca);
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (3/0) */

/* MOVE.B (xxx).W,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_1038_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 src = get_byte_000 (srca);
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (3/0) */

/* MOVE.B (xxx).L,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_1039_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
{	uae_s8 src = get_byte_000 (srca);
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (4/0) */

/* MOVE.B (d16,PC),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_103a_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 src = get_byte_000 (srca);
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (3/0) */

/* MOVE.B (d8,PC,Xn),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_103b_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	srca = get_disp_ea_000 (tmppc, get_word_000_prefetch (4));
{	uae_s8 src = get_byte_000 (srca);
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (3/0) */

/* MOVE.B #<data>.B,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_103c_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = (uae_u8)get_word_000_prefetch (4);
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (2/0) */

/* MOVE.B Dn,(An) */
uae_u32 REGPARAM2 CPUFUNC(op_1080_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/1) */

/* MOVE.B (An),(An) */
uae_u32 REGPARAM2 CPUFUNC(op_1090_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_000 (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* MOVE.B (An)+,(An) */
uae_u32 REGPARAM2 CPUFUNC(op_1098_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_000 (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* MOVE.B -(An),(An) */
uae_u32 REGPARAM2 CPUFUNC(op_10a0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte_000 (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (2/1) */

/* MOVE.B (d16,An),(An) */
uae_u32 REGPARAM2 CPUFUNC(op_10a8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 src = get_byte_000 (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* MOVE.B (d8,An,Xn),(An) */
uae_u32 REGPARAM2 CPUFUNC(op_10b0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
{	uae_s8 src = get_byte_000 (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/1) */

/* MOVE.B (xxx).W,(An) */
uae_u32 REGPARAM2 CPUFUNC(op_10b8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 src = get_byte_000 (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* MOVE.B (xxx).L,(An) */
uae_u32 REGPARAM2 CPUFUNC(op_10b9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
{	uae_s8 src = get_byte_000 (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* MOVE.B (d16,PC),(An) */
uae_u32 REGPARAM2 CPUFUNC(op_10ba_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 src = get_byte_000 (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* MOVE.B (d8,PC,Xn),(An) */
uae_u32 REGPARAM2 CPUFUNC(op_10bb_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	srca = get_disp_ea_000 (tmppc, get_word_000_prefetch (4));
{	uae_s8 src = get_byte_000 (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/1) */

/* MOVE.B #<data>.B,(An) */
uae_u32 REGPARAM2 CPUFUNC(op_10bc_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = (uae_u8)get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* MOVE.B Dn,(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_10c0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/1) */

/* MOVE.B (An),(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_10d0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_000 (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* MOVE.B (An)+,(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_10d8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_000 (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* MOVE.B -(An),(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_10e0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte_000 (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (2/1) */

/* MOVE.B (d16,An),(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_10e8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 src = get_byte_000 (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* MOVE.B (d8,An,Xn),(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_10f0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
{	uae_s8 src = get_byte_000 (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/1) */

/* MOVE.B (xxx).W,(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_10f8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 src = get_byte_000 (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* MOVE.B (xxx).L,(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_10f9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
{	uae_s8 src = get_byte_000 (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* MOVE.B (d16,PC),(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_10fa_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 src = get_byte_000 (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* MOVE.B (d8,PC,Xn),(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_10fb_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	srca = get_disp_ea_000 (tmppc, get_word_000_prefetch (4));
{	uae_s8 src = get_byte_000 (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/1) */

/* MOVE.B #<data>.B,(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_10fc_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = (uae_u8)get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* MOVE.B Dn,-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_1100_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (2);
}}}return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/1) */

/* MOVE.B (An),-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_1110_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_000 (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (2);
}}}}return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* MOVE.B (An)+,-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_1118_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_000 (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (2);
}}}}return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* MOVE.B -(An),-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_1120_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte_000 (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (2);
}}}}return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (2/1) */

/* MOVE.B (d16,An),-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_1128_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 src = get_byte_000 (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (4);
}}}}return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* MOVE.B (d8,An,Xn),-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_1130_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
{	uae_s8 src = get_byte_000 (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (4);
}}}}return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/1) */

/* MOVE.B (xxx).W,-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_1138_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 src = get_byte_000 (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (4);
}}}}return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* MOVE.B (xxx).L,-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_1139_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
{	uae_s8 src = get_byte_000 (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (6);
}}}}return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* MOVE.B (d16,PC),-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_113a_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 src = get_byte_000 (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (4);
}}}}return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* MOVE.B (d8,PC,Xn),-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_113b_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	srca = get_disp_ea_000 (tmppc, get_word_000_prefetch (4));
{	uae_s8 src = get_byte_000 (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (4);
}}}}return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/1) */

/* MOVE.B #<data>.B,-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_113c_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = (uae_u8)get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (4);
}}}return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* MOVE.B Dn,(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_1140_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* MOVE.B (An),(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_1150_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_000 (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* MOVE.B (An)+,(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_1158_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_000 (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* MOVE.B -(An),(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_1160_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte_000 (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/1) */

/* MOVE.B (d16,An),(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_1168_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 src = get_byte_000 (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* MOVE.B (d8,An,Xn),(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_1170_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
{	uae_s8 src = get_byte_000 (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}return 22 * CYCLE_UNIT / 2 + count_cycles;
} /* 22 (4/1) */

/* MOVE.B (xxx).W,(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_1178_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 src = get_byte_000 (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* MOVE.B (xxx).L,(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_1179_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
{	uae_s8 src = get_byte_000 (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (8);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (8);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}return 24 * CYCLE_UNIT / 2 + count_cycles;
} /* 24 (5/1) */

/* MOVE.B (d16,PC),(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_117a_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 src = get_byte_000 (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* MOVE.B (d8,PC,Xn),(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_117b_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	srca = get_disp_ea_000 (tmppc, get_word_000_prefetch (4));
{	uae_s8 src = get_byte_000 (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}return 22 * CYCLE_UNIT / 2 + count_cycles;
} /* 22 (4/1) */

/* MOVE.B #<data>.B,(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_117c_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = (uae_u8)get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* MOVE.B Dn,(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_1180_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (4));
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (2/1) */

/* MOVE.B (An),(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_1190_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_000 (srca);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (4));
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/1) */

/* MOVE.B (An)+,(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_1198_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_000 (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (4));
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/1) */

/* MOVE.B -(An),(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_11a0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte_000 (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (4));
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (3/1) */

/* MOVE.B (d16,An),(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_11a8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 src = get_byte_000 (srca);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (6));
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}return 22 * CYCLE_UNIT / 2 + count_cycles;
} /* 22 (4/1) */

/* MOVE.B (d8,An,Xn),(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_11b0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
{	uae_s8 src = get_byte_000 (srca);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (6));
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}return 24 * CYCLE_UNIT / 2 + count_cycles;
} /* 24 (4/1) */

/* MOVE.B (xxx).W,(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_11b8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 src = get_byte_000 (srca);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (6));
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}return 22 * CYCLE_UNIT / 2 + count_cycles;
} /* 22 (4/1) */

/* MOVE.B (xxx).L,(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_11b9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
{	uae_s8 src = get_byte_000 (srca);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (8));
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (8);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}return 26 * CYCLE_UNIT / 2 + count_cycles;
} /* 26 (5/1) */

/* MOVE.B (d16,PC),(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_11ba_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 src = get_byte_000 (srca);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (6));
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}return 22 * CYCLE_UNIT / 2 + count_cycles;
} /* 22 (4/1) */

/* MOVE.B (d8,PC,Xn),(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_11bb_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	srca = get_disp_ea_000 (tmppc, get_word_000_prefetch (4));
{	uae_s8 src = get_byte_000 (srca);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (6));
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}return 24 * CYCLE_UNIT / 2 + count_cycles;
} /* 24 (4/1) */

/* MOVE.B #<data>.B,(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_11bc_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = (uae_u8)get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (6));
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/1) */

/* MOVE.B Dn,(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_11c0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* MOVE.B (An),(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_11d0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_000 (srca);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* MOVE.B (An)+,(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_11d8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_000 (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* MOVE.B -(An),(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_11e0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte_000 (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/1) */

/* MOVE.B (d16,An),(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_11e8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 src = get_byte_000 (srca);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* MOVE.B (d8,An,Xn),(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_11f0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
{	uae_s8 src = get_byte_000 (srca);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}return 22 * CYCLE_UNIT / 2 + count_cycles;
} /* 22 (4/1) */

/* MOVE.B (xxx).W,(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_11f8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 src = get_byte_000 (srca);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* MOVE.B (xxx).L,(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_11f9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
{	uae_s8 src = get_byte_000 (srca);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (8);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (8);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}return 24 * CYCLE_UNIT / 2 + count_cycles;
} /* 24 (5/1) */

/* MOVE.B (d16,PC),(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_11fa_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 src = get_byte_000 (srca);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* MOVE.B (d8,PC,Xn),(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_11fb_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	srca = get_disp_ea_000 (tmppc, get_word_000_prefetch (4));
{	uae_s8 src = get_byte_000 (srca);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}return 22 * CYCLE_UNIT / 2 + count_cycles;
} /* 22 (4/1) */

/* MOVE.B #<data>.B,(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_11fc_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uae_s8 src = (uae_u8)get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* MOVE.B Dn,(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_13c0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_word_000_prefetch (4) << 16;
	dsta |= get_word_000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* MOVE.B (An),(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_13d0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_000 (srca);
{	uaecptr dsta;
	dsta = get_word_000_prefetch (4) << 16;
	dsta |= regs.irc;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (6);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* MOVE.B (An)+,(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_13d8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_000 (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uaecptr dsta;
	dsta = get_word_000_prefetch (4) << 16;
	dsta |= regs.irc;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (6);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* MOVE.B -(An),(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_13e0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte_000 (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = get_word_000_prefetch (4) << 16;
	dsta |= regs.irc;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (6);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}return 22 * CYCLE_UNIT / 2 + count_cycles;
} /* 22 (4/1) */

/* MOVE.B (d16,An),(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_13e8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 src = get_byte_000 (srca);
{	uaecptr dsta;
	dsta = get_word_000_prefetch (6) << 16;
	dsta |= regs.irc;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (8);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}return 24 * CYCLE_UNIT / 2 + count_cycles;
} /* 24 (5/1) */

/* MOVE.B (d8,An,Xn),(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_13f0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
{	uae_s8 src = get_byte_000 (srca);
{	uaecptr dsta;
	dsta = get_word_000_prefetch (6) << 16;
	dsta |= regs.irc;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (8);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}return 26 * CYCLE_UNIT / 2 + count_cycles;
} /* 26 (5/1) */

/* MOVE.B (xxx).W,(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_13f8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 src = get_byte_000 (srca);
{	uaecptr dsta;
	dsta = get_word_000_prefetch (6) << 16;
	dsta |= regs.irc;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (8);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}return 24 * CYCLE_UNIT / 2 + count_cycles;
} /* 24 (5/1) */

/* MOVE.B (xxx).L,(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_13f9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
{	uae_s8 src = get_byte_000 (srca);
{	uaecptr dsta;
	dsta = get_word_000_prefetch (8) << 16;
	dsta |= regs.irc;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (10);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}return 28 * CYCLE_UNIT / 2 + count_cycles;
} /* 28 (6/1) */

/* MOVE.B (d16,PC),(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_13fa_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 src = get_byte_000 (srca);
{	uaecptr dsta;
	dsta = get_word_000_prefetch (6) << 16;
	dsta |= regs.irc;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (8);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}return 24 * CYCLE_UNIT / 2 + count_cycles;
} /* 24 (5/1) */

/* MOVE.B (d8,PC,Xn),(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_13fb_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	srca = get_disp_ea_000 (tmppc, get_word_000_prefetch (4));
{	uae_s8 src = get_byte_000 (srca);
{	uaecptr dsta;
	dsta = get_word_000_prefetch (6) << 16;
	dsta |= regs.irc;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (8);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}return 26 * CYCLE_UNIT / 2 + count_cycles;
} /* 26 (5/1) */

/* MOVE.B #<data>.B,(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_13fc_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uae_s8 src = (uae_u8)get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = get_word_000_prefetch (6) << 16;
	dsta |= get_word_000_prefetch (8);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	put_byte_000 (dsta, src);
	m68k_incpci (8);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* MOVE.L Dn,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_2000_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg (regs, dstreg) = (src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4 (1/0) */

/* MOVE.L An,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_2008_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg (regs, dstreg) = (src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4 (1/0) */

/* MOVE.L (An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_2010_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110314;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg (regs, dstreg) = (src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}l_110314: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (3/0) */

/* MOVE.L (An)+,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_2018_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110315;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
	m68k_areg (regs, srcreg) += 4;
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg (regs, dstreg) = (src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}l_110315: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (3/0) */

/* MOVE.L -(An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_2020_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_110316;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
	m68k_areg (regs, srcreg) = srca;
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg (regs, dstreg) = (src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}l_110316: ;
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (3/0) */

/* MOVE.L (d16,An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_2028_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110317;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg (regs, dstreg) = (src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}l_110317: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (4/0) */

/* MOVE.L (d8,An,Xn),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_2030_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110318;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg (regs, dstreg) = (src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}l_110318: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (4/0) */

/* MOVE.L (xxx).W,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_2038_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_110319;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg (regs, dstreg) = (src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}l_110319: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (4/0) */

/* MOVE.L (xxx).L,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_2039_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_110320;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg (regs, dstreg) = (src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}l_110320: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (5/0) */

/* MOVE.L (d16,PC),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_203a_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110321;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg (regs, dstreg) = (src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}l_110321: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (4/0) */

/* MOVE.L (d8,PC,Xn),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_203b_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	srca = get_disp_ea_000 (tmppc, get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110322;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg (regs, dstreg) = (src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}l_110322: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (4/0) */

/* MOVE.L #<data>.L,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_203c_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src;
	src = get_word_000_prefetch (4) << 16;
	src |= get_word_000_prefetch (6);
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg (regs, dstreg) = (src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (3/0) */

/* MOVEA.L Dn,An */
uae_u32 REGPARAM2 CPUFUNC(op_2040_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	m68k_areg (regs, dstreg) = (src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4 (1/0) */

/* MOVEA.L An,An */
uae_u32 REGPARAM2 CPUFUNC(op_2048_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	m68k_areg (regs, dstreg) = (src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4 (1/0) */

/* MOVEA.L (An),An */
uae_u32 REGPARAM2 CPUFUNC(op_2050_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110326;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	m68k_areg (regs, dstreg) = (src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}l_110326: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (3/0) */

/* MOVEA.L (An)+,An */
uae_u32 REGPARAM2 CPUFUNC(op_2058_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110327;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
	m68k_areg (regs, srcreg) += 4;
{	m68k_areg (regs, dstreg) = (src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}l_110327: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (3/0) */

/* MOVEA.L -(An),An */
uae_u32 REGPARAM2 CPUFUNC(op_2060_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_110328;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
	m68k_areg (regs, srcreg) = srca;
{	m68k_areg (regs, dstreg) = (src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}l_110328: ;
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (3/0) */

/* MOVEA.L (d16,An),An */
uae_u32 REGPARAM2 CPUFUNC(op_2068_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110329;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	m68k_areg (regs, dstreg) = (src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}l_110329: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (4/0) */

/* MOVEA.L (d8,An,Xn),An */
uae_u32 REGPARAM2 CPUFUNC(op_2070_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110330;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	m68k_areg (regs, dstreg) = (src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}l_110330: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (4/0) */

/* MOVEA.L (xxx).W,An */
uae_u32 REGPARAM2 CPUFUNC(op_2078_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_110331;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	m68k_areg (regs, dstreg) = (src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}l_110331: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (4/0) */

/* MOVEA.L (xxx).L,An */
uae_u32 REGPARAM2 CPUFUNC(op_2079_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_110332;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	m68k_areg (regs, dstreg) = (src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}l_110332: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (5/0) */

/* MOVEA.L (d16,PC),An */
uae_u32 REGPARAM2 CPUFUNC(op_207a_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110333;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	m68k_areg (regs, dstreg) = (src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}l_110333: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (4/0) */

/* MOVEA.L (d8,PC,Xn),An */
uae_u32 REGPARAM2 CPUFUNC(op_207b_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	srca = get_disp_ea_000 (tmppc, get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110334;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	m68k_areg (regs, dstreg) = (src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}l_110334: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (4/0) */

/* MOVEA.L #<data>.L,An */
uae_u32 REGPARAM2 CPUFUNC(op_207c_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src;
	src = get_word_000_prefetch (4) << 16;
	src |= get_word_000_prefetch (6);
{	m68k_areg (regs, dstreg) = (src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (3/0) */

/* MOVE.L Dn,(An) */
uae_u32 REGPARAM2 CPUFUNC(op_2080_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_110336;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}l_110336: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (1/2) */

/* MOVE.L An,(An) */
uae_u32 REGPARAM2 CPUFUNC(op_2088_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_110337;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}l_110337: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (1/2) */

/* MOVE.L (An),(An) */
uae_u32 REGPARAM2 CPUFUNC(op_2090_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110338;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_110338;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110338: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (3/2) */

/* MOVE.L (An)+,(An) */
uae_u32 REGPARAM2 CPUFUNC(op_2098_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110339;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
	m68k_areg (regs, srcreg) += 4;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_110339;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110339: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (3/2) */

/* MOVE.L -(An),(An) */
uae_u32 REGPARAM2 CPUFUNC(op_20a0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_110340;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_110340;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110340: ;
return 22 * CYCLE_UNIT / 2 + count_cycles;
} /* 22 (3/2) */

/* MOVE.L (d16,An),(An) */
uae_u32 REGPARAM2 CPUFUNC(op_20a8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110341;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110341;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110341: ;
return 24 * CYCLE_UNIT / 2 + count_cycles;
} /* 24 (4/2) */

/* MOVE.L (d8,An,Xn),(An) */
uae_u32 REGPARAM2 CPUFUNC(op_20b0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110342;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110342;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110342: ;
return 26 * CYCLE_UNIT / 2 + count_cycles;
} /* 26 (4/2) */

/* MOVE.L (xxx).W,(An) */
uae_u32 REGPARAM2 CPUFUNC(op_20b8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_110343;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110343;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110343: ;
return 24 * CYCLE_UNIT / 2 + count_cycles;
} /* 24 (4/2) */

/* MOVE.L (xxx).L,(An) */
uae_u32 REGPARAM2 CPUFUNC(op_20b9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_110344;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (8);
		exception3_write(opcode, dsta);
		goto l_110344;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110344: ;
return 28 * CYCLE_UNIT / 2 + count_cycles;
} /* 28 (5/2) */

/* MOVE.L (d16,PC),(An) */
uae_u32 REGPARAM2 CPUFUNC(op_20ba_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110345;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110345;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110345: ;
return 24 * CYCLE_UNIT / 2 + count_cycles;
} /* 24 (4/2) */

/* MOVE.L (d8,PC,Xn),(An) */
uae_u32 REGPARAM2 CPUFUNC(op_20bb_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	srca = get_disp_ea_000 (tmppc, get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110346;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110346;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110346: ;
return 26 * CYCLE_UNIT / 2 + count_cycles;
} /* 26 (4/2) */

/* MOVE.L #<data>.L,(An) */
uae_u32 REGPARAM2 CPUFUNC(op_20bc_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src;
	src = get_word_000_prefetch (4) << 16;
	src |= get_word_000_prefetch (6);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (8);
		exception3_write(opcode, dsta);
		goto l_110347;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}l_110347: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (3/2) */

/* MOVE.L Dn,(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_20c0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_110348;
	}
{	m68k_areg (regs, dstreg) += 4;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}l_110348: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (1/2) */

/* MOVE.L An,(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_20c8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_110349;
	}
{	m68k_areg (regs, dstreg) += 4;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}l_110349: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (1/2) */

/* MOVE.L (An),(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_20d0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110350;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_110350;
	}
{	m68k_areg (regs, dstreg) += 4;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110350: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (3/2) */

/* MOVE.L (An)+,(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_20d8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110351;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
	m68k_areg (regs, srcreg) += 4;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_110351;
	}
{	m68k_areg (regs, dstreg) += 4;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110351: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (3/2) */

/* MOVE.L -(An),(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_20e0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_110352;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_110352;
	}
{	m68k_areg (regs, dstreg) += 4;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110352: ;
return 22 * CYCLE_UNIT / 2 + count_cycles;
} /* 22 (3/2) */

/* MOVE.L (d16,An),(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_20e8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110353;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110353;
	}
{	m68k_areg (regs, dstreg) += 4;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110353: ;
return 24 * CYCLE_UNIT / 2 + count_cycles;
} /* 24 (4/2) */

/* MOVE.L (d8,An,Xn),(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_20f0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110354;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110354;
	}
{	m68k_areg (regs, dstreg) += 4;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110354: ;
return 26 * CYCLE_UNIT / 2 + count_cycles;
} /* 26 (4/2) */

/* MOVE.L (xxx).W,(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_20f8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_110355;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110355;
	}
{	m68k_areg (regs, dstreg) += 4;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110355: ;
return 24 * CYCLE_UNIT / 2 + count_cycles;
} /* 24 (4/2) */

/* MOVE.L (xxx).L,(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_20f9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_110356;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (8);
		exception3_write(opcode, dsta);
		goto l_110356;
	}
{	m68k_areg (regs, dstreg) += 4;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110356: ;
return 28 * CYCLE_UNIT / 2 + count_cycles;
} /* 28 (5/2) */

/* MOVE.L (d16,PC),(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_20fa_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110357;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110357;
	}
{	m68k_areg (regs, dstreg) += 4;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110357: ;
return 24 * CYCLE_UNIT / 2 + count_cycles;
} /* 24 (4/2) */

/* MOVE.L (d8,PC,Xn),(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_20fb_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	srca = get_disp_ea_000 (tmppc, get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110358;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110358;
	}
{	m68k_areg (regs, dstreg) += 4;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110358: ;
return 26 * CYCLE_UNIT / 2 + count_cycles;
} /* 26 (4/2) */

/* MOVE.L #<data>.L,(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_20fc_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src;
	src = get_word_000_prefetch (4) << 16;
	src |= get_word_000_prefetch (6);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (8);
		exception3_write(opcode, dsta);
		goto l_110359;
	}
{	m68k_areg (regs, dstreg) += 4;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}l_110359: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (3/2) */

/* MOVE.L Dn,-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_2100_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_110360;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (2);
}}}}l_110360: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (1/2) */

/* MOVE.L An,-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_2108_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_110361;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (2);
}}}}l_110361: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (1/2) */

/* MOVE.L (An),-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_2110_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110362;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_110362;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (2);
}}}}}}l_110362: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (3/2) */

/* MOVE.L (An)+,-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_2118_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110363;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
	m68k_areg (regs, srcreg) += 4;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_110363;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (2);
}}}}}}l_110363: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (3/2) */

/* MOVE.L -(An),-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_2120_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_110364;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_110364;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (2);
}}}}}}l_110364: ;
return 22 * CYCLE_UNIT / 2 + count_cycles;
} /* 22 (3/2) */

/* MOVE.L (d16,An),-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_2128_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110365;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110365;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (4);
}}}}}}l_110365: ;
return 24 * CYCLE_UNIT / 2 + count_cycles;
} /* 24 (4/2) */

/* MOVE.L (d8,An,Xn),-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_2130_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110366;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110366;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (4);
}}}}}}l_110366: ;
return 26 * CYCLE_UNIT / 2 + count_cycles;
} /* 26 (4/2) */

/* MOVE.L (xxx).W,-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_2138_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_110367;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110367;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (4);
}}}}}}l_110367: ;
return 24 * CYCLE_UNIT / 2 + count_cycles;
} /* 24 (4/2) */

/* MOVE.L (xxx).L,-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_2139_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_110368;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	if (dsta & 1) {
	m68k_incpci (8);
		exception3_write(opcode, dsta);
		goto l_110368;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (6);
}}}}}}l_110368: ;
return 28 * CYCLE_UNIT / 2 + count_cycles;
} /* 28 (5/2) */

/* MOVE.L (d16,PC),-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_213a_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110369;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110369;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (4);
}}}}}}l_110369: ;
return 24 * CYCLE_UNIT / 2 + count_cycles;
} /* 24 (4/2) */

/* MOVE.L (d8,PC,Xn),-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_213b_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	srca = get_disp_ea_000 (tmppc, get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110370;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110370;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (4);
}}}}}}l_110370: ;
return 26 * CYCLE_UNIT / 2 + count_cycles;
} /* 26 (4/2) */

/* MOVE.L #<data>.L,-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_213c_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src;
	src = get_word_000_prefetch (4) << 16;
	src |= get_word_000_prefetch (6);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	if (dsta & 1) {
	m68k_incpci (8);
		exception3_write(opcode, dsta);
		goto l_110371;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (6);
}}}}l_110371: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (3/2) */

/* MOVE.L Dn,(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_2140_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_110372;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}l_110372: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (2/2) */

/* MOVE.L An,(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_2148_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_110373;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}l_110373: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (2/2) */

/* MOVE.L (An),(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_2150_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110374;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_110374;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110374: ;
return 24 * CYCLE_UNIT / 2 + count_cycles;
} /* 24 (4/2) */

/* MOVE.L (An)+,(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_2158_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110375;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
	m68k_areg (regs, srcreg) += 4;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_110375;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110375: ;
return 24 * CYCLE_UNIT / 2 + count_cycles;
} /* 24 (4/2) */

/* MOVE.L -(An),(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_2160_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_110376;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_110376;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110376: ;
return 26 * CYCLE_UNIT / 2 + count_cycles;
} /* 26 (4/2) */

/* MOVE.L (d16,An),(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_2168_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110377;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110377;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110377: ;
return 28 * CYCLE_UNIT / 2 + count_cycles;
} /* 28 (5/2) */

/* MOVE.L (d8,An,Xn),(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_2170_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110378;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110378;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110378: ;
return 30 * CYCLE_UNIT / 2 + count_cycles;
} /* 30 (5/2) */

/* MOVE.L (xxx).W,(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_2178_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_110379;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110379;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110379: ;
return 28 * CYCLE_UNIT / 2 + count_cycles;
} /* 28 (5/2) */

/* MOVE.L (xxx).L,(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_2179_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_110380;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (8);
	if (dsta & 1) {
	m68k_incpci (8);
		exception3_write(opcode, dsta);
		goto l_110380;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (8);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110380: ;
return 32 * CYCLE_UNIT / 2 + count_cycles;
} /* 32 (6/2) */

/* MOVE.L (d16,PC),(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_217a_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110381;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110381;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110381: ;
return 28 * CYCLE_UNIT / 2 + count_cycles;
} /* 28 (5/2) */

/* MOVE.L (d8,PC,Xn),(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_217b_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	srca = get_disp_ea_000 (tmppc, get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110382;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110382;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110382: ;
return 30 * CYCLE_UNIT / 2 + count_cycles;
} /* 30 (5/2) */

/* MOVE.L #<data>.L,(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_217c_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src;
	src = get_word_000_prefetch (4) << 16;
	src |= get_word_000_prefetch (6);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (8);
	if (dsta & 1) {
	m68k_incpci (8);
		exception3_write(opcode, dsta);
		goto l_110383;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (8);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}l_110383: ;
return 24 * CYCLE_UNIT / 2 + count_cycles;
} /* 24 (4/2) */

/* MOVE.L Dn,(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_2180_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (4));
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_110384;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}l_110384: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (2/2) */

/* MOVE.L An,(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_2188_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (4));
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_110385;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}l_110385: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (2/2) */

/* MOVE.L (An),(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_2190_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110386;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (4));
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_110386;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110386: ;
return 26 * CYCLE_UNIT / 2 + count_cycles;
} /* 26 (4/2) */

/* MOVE.L (An)+,(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_2198_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110387;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
	m68k_areg (regs, srcreg) += 4;
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (4));
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_110387;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110387: ;
return 26 * CYCLE_UNIT / 2 + count_cycles;
} /* 26 (4/2) */

#endif

#ifdef PART_3
/* MOVE.L -(An),(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_21a0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_110388;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (4));
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_110388;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110388: ;
return 28 * CYCLE_UNIT / 2 + count_cycles;
} /* 28 (4/2) */

/* MOVE.L (d16,An),(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_21a8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110389;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (6));
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110389;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110389: ;
return 30 * CYCLE_UNIT / 2 + count_cycles;
} /* 30 (5/2) */

/* MOVE.L (d8,An,Xn),(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_21b0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110390;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (6));
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110390;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110390: ;
return 32 * CYCLE_UNIT / 2 + count_cycles;
} /* 32 (5/2) */

/* MOVE.L (xxx).W,(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_21b8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_110391;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (6));
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110391;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110391: ;
return 30 * CYCLE_UNIT / 2 + count_cycles;
} /* 30 (5/2) */

/* MOVE.L (xxx).L,(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_21b9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_110392;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (8));
	if (dsta & 1) {
	m68k_incpci (8);
		exception3_write(opcode, dsta);
		goto l_110392;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (8);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110392: ;
return 34 * CYCLE_UNIT / 2 + count_cycles;
} /* 34 (6/2) */

/* MOVE.L (d16,PC),(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_21ba_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110393;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (6));
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110393;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110393: ;
return 30 * CYCLE_UNIT / 2 + count_cycles;
} /* 30 (5/2) */

/* MOVE.L (d8,PC,Xn),(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_21bb_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	srca = get_disp_ea_000 (tmppc, get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110394;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (6));
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110394;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110394: ;
return 32 * CYCLE_UNIT / 2 + count_cycles;
} /* 32 (5/2) */

/* MOVE.L #<data>.L,(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_21bc_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src;
	src = get_word_000_prefetch (4) << 16;
	src |= get_word_000_prefetch (6);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (8));
	if (dsta & 1) {
	m68k_incpci (8);
		exception3_write(opcode, dsta);
		goto l_110395;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (8);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}l_110395: ;
return 26 * CYCLE_UNIT / 2 + count_cycles;
} /* 26 (4/2) */

/* MOVE.L Dn,(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_21c0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_110396;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}l_110396: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (2/2) */

/* MOVE.L An,(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_21c8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_110397;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}l_110397: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (2/2) */

/* MOVE.L (An),(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_21d0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110398;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_110398;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110398: ;
return 24 * CYCLE_UNIT / 2 + count_cycles;
} /* 24 (4/2) */

/* MOVE.L (An)+,(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_21d8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110399;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
	m68k_areg (regs, srcreg) += 4;
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_110399;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110399: ;
return 24 * CYCLE_UNIT / 2 + count_cycles;
} /* 24 (4/2) */

/* MOVE.L -(An),(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_21e0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_110400;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_110400;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110400: ;
return 26 * CYCLE_UNIT / 2 + count_cycles;
} /* 26 (4/2) */

/* MOVE.L (d16,An),(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_21e8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110401;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110401;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110401: ;
return 28 * CYCLE_UNIT / 2 + count_cycles;
} /* 28 (5/2) */

/* MOVE.L (d8,An,Xn),(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_21f0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110402;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110402;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110402: ;
return 30 * CYCLE_UNIT / 2 + count_cycles;
} /* 30 (5/2) */

/* MOVE.L (xxx).W,(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_21f8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_110403;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110403;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110403: ;
return 28 * CYCLE_UNIT / 2 + count_cycles;
} /* 28 (5/2) */

/* MOVE.L (xxx).L,(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_21f9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_110404;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (8);
	if (dsta & 1) {
	m68k_incpci (8);
		exception3_write(opcode, dsta);
		goto l_110404;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (8);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110404: ;
return 32 * CYCLE_UNIT / 2 + count_cycles;
} /* 32 (6/2) */

/* MOVE.L (d16,PC),(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_21fa_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110405;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110405;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110405: ;
return 28 * CYCLE_UNIT / 2 + count_cycles;
} /* 28 (5/2) */

/* MOVE.L (d8,PC,Xn),(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_21fb_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	srca = get_disp_ea_000 (tmppc, get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110406;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110406;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110406: ;
return 30 * CYCLE_UNIT / 2 + count_cycles;
} /* 30 (5/2) */

/* MOVE.L #<data>.L,(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_21fc_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uae_s32 src;
	src = get_word_000_prefetch (4) << 16;
	src |= get_word_000_prefetch (6);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (8);
	if (dsta & 1) {
	m68k_incpci (8);
		exception3_write(opcode, dsta);
		goto l_110407;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (8);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}l_110407: ;
return 24 * CYCLE_UNIT / 2 + count_cycles;
} /* 24 (4/2) */

/* MOVE.L Dn,(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_23c0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_word_000_prefetch (4) << 16;
	dsta |= get_word_000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110408;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}l_110408: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (3/2) */

/* MOVE.L An,(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_23c8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_word_000_prefetch (4) << 16;
	dsta |= get_word_000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110409;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}l_110409: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (3/2) */

/* MOVE.L (An),(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_23d0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110410;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uaecptr dsta;
	dsta = get_word_000_prefetch (4) << 16;
	dsta |= regs.irc;
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110410;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (6);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110410: ;
return 28 * CYCLE_UNIT / 2 + count_cycles;
} /* 28 (5/2) */

/* MOVE.L (An)+,(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_23d8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110411;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
	m68k_areg (regs, srcreg) += 4;
{	uaecptr dsta;
	dsta = get_word_000_prefetch (4) << 16;
	dsta |= regs.irc;
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110411;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (6);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110411: ;
return 28 * CYCLE_UNIT / 2 + count_cycles;
} /* 28 (5/2) */

/* MOVE.L -(An),(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_23e0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_110412;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = get_word_000_prefetch (4) << 16;
	dsta |= regs.irc;
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110412;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (6);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110412: ;
return 30 * CYCLE_UNIT / 2 + count_cycles;
} /* 30 (5/2) */

/* MOVE.L (d16,An),(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_23e8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110413;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uaecptr dsta;
	dsta = get_word_000_prefetch (6) << 16;
	dsta |= regs.irc;
	if (dsta & 1) {
	m68k_incpci (8);
		exception3_write(opcode, dsta);
		goto l_110413;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (8);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110413: ;
return 32 * CYCLE_UNIT / 2 + count_cycles;
} /* 32 (6/2) */

/* MOVE.L (d8,An,Xn),(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_23f0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110414;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uaecptr dsta;
	dsta = get_word_000_prefetch (6) << 16;
	dsta |= regs.irc;
	if (dsta & 1) {
	m68k_incpci (8);
		exception3_write(opcode, dsta);
		goto l_110414;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (8);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110414: ;
return 34 * CYCLE_UNIT / 2 + count_cycles;
} /* 34 (6/2) */

/* MOVE.L (xxx).W,(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_23f8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_110415;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uaecptr dsta;
	dsta = get_word_000_prefetch (6) << 16;
	dsta |= regs.irc;
	if (dsta & 1) {
	m68k_incpci (8);
		exception3_write(opcode, dsta);
		goto l_110415;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (8);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110415: ;
return 32 * CYCLE_UNIT / 2 + count_cycles;
} /* 32 (6/2) */

/* MOVE.L (xxx).L,(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_23f9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_110416;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uaecptr dsta;
	dsta = get_word_000_prefetch (8) << 16;
	dsta |= regs.irc;
	if (dsta & 1) {
	m68k_incpci (10);
		exception3_write(opcode, dsta);
		goto l_110416;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (10);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110416: ;
return 36 * CYCLE_UNIT / 2 + count_cycles;
} /* 36 (7/2) */

/* MOVE.L (d16,PC),(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_23fa_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110417;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uaecptr dsta;
	dsta = get_word_000_prefetch (6) << 16;
	dsta |= regs.irc;
	if (dsta & 1) {
	m68k_incpci (8);
		exception3_write(opcode, dsta);
		goto l_110417;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (8);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110417: ;
return 32 * CYCLE_UNIT / 2 + count_cycles;
} /* 32 (6/2) */

/* MOVE.L (d8,PC,Xn),(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_23fb_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	srca = get_disp_ea_000 (tmppc, get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110418;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uaecptr dsta;
	dsta = get_word_000_prefetch (6) << 16;
	dsta |= regs.irc;
	if (dsta & 1) {
	m68k_incpci (8);
		exception3_write(opcode, dsta);
		goto l_110418;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (8);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110418: ;
return 34 * CYCLE_UNIT / 2 + count_cycles;
} /* 34 (6/2) */

/* MOVE.L #<data>.L,(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_23fc_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uae_s32 src;
	src = get_word_000_prefetch (4) << 16;
	src |= get_word_000_prefetch (6);
{	uaecptr dsta;
	dsta = get_word_000_prefetch (8) << 16;
	dsta |= get_word_000_prefetch (10);
	if (dsta & 1) {
	m68k_incpci (10);
		exception3_write(opcode, dsta);
		goto l_110419;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	put_word_000 (dsta, src >> 16); put_word_000 (dsta + 2, src);
	m68k_incpci (10);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}l_110419: ;
return 28 * CYCLE_UNIT / 2 + count_cycles;
} /* 28 (5/2) */

/* MOVE.W Dn,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_3000_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4 (1/0) */

/* MOVE.W An,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_3008_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_areg (regs, srcreg);
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4 (1/0) */

/* MOVE.W (An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_3010_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110422;
	}
{{	uae_s16 src = get_word_000 (srca);
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}l_110422: ;
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (2/0) */

/* MOVE.W (An)+,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_3018_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110423;
	}
{{	uae_s16 src = get_word_000 (srca);
	m68k_areg (regs, srcreg) += 2;
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}l_110423: ;
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (2/0) */

/* MOVE.W -(An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_3020_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_110424;
	}
{{	uae_s16 src = get_word_000 (srca);
	m68k_areg (regs, srcreg) = srca;
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}l_110424: ;
return 10 * CYCLE_UNIT / 2 + count_cycles;
} /* 10 (2/0) */

/* MOVE.W (d16,An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_3028_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110425;
	}
{{	uae_s16 src = get_word_000 (srca);
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}l_110425: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (3/0) */

/* MOVE.W (d8,An,Xn),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_3030_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110426;
	}
{{	uae_s16 src = get_word_000 (srca);
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}l_110426: ;
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (3/0) */

/* MOVE.W (xxx).W,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_3038_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_110427;
	}
{{	uae_s16 src = get_word_000 (srca);
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}l_110427: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (3/0) */

/* MOVE.W (xxx).L,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_3039_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_110428;
	}
{{	uae_s16 src = get_word_000 (srca);
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}l_110428: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (4/0) */

/* MOVE.W (d16,PC),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_303a_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110429;
	}
{{	uae_s16 src = get_word_000 (srca);
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}l_110429: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (3/0) */

/* MOVE.W (d8,PC,Xn),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_303b_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	srca = get_disp_ea_000 (tmppc, get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110430;
	}
{{	uae_s16 src = get_word_000 (srca);
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}l_110430: ;
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (3/0) */

/* MOVE.W #<data>.W,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_303c_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (2/0) */

/* MOVEA.W Dn,An */
uae_u32 REGPARAM2 CPUFUNC(op_3040_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	src = (uae_s32)(uae_s16)src;
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4 (1/0) */

/* MOVEA.W An,An */
uae_u32 REGPARAM2 CPUFUNC(op_3048_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_areg (regs, srcreg);
{	src = (uae_s32)(uae_s16)src;
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4 (1/0) */

/* MOVEA.W (An),An */
uae_u32 REGPARAM2 CPUFUNC(op_3050_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110434;
	}
{{	uae_s16 src = get_word_000 (srca);
{	src = (uae_s32)(uae_s16)src;
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}l_110434: ;
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (2/0) */

/* MOVEA.W (An)+,An */
uae_u32 REGPARAM2 CPUFUNC(op_3058_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110435;
	}
{{	uae_s16 src = get_word_000 (srca);
	m68k_areg (regs, srcreg) += 2;
{	src = (uae_s32)(uae_s16)src;
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}l_110435: ;
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (2/0) */

/* MOVEA.W -(An),An */
uae_u32 REGPARAM2 CPUFUNC(op_3060_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_110436;
	}
{{	uae_s16 src = get_word_000 (srca);
	m68k_areg (regs, srcreg) = srca;
{	src = (uae_s32)(uae_s16)src;
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}l_110436: ;
return 10 * CYCLE_UNIT / 2 + count_cycles;
} /* 10 (2/0) */

/* MOVEA.W (d16,An),An */
uae_u32 REGPARAM2 CPUFUNC(op_3068_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110437;
	}
{{	uae_s16 src = get_word_000 (srca);
{	src = (uae_s32)(uae_s16)src;
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}l_110437: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (3/0) */

/* MOVEA.W (d8,An,Xn),An */
uae_u32 REGPARAM2 CPUFUNC(op_3070_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110438;
	}
{{	uae_s16 src = get_word_000 (srca);
{	src = (uae_s32)(uae_s16)src;
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}l_110438: ;
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (3/0) */

/* MOVEA.W (xxx).W,An */
uae_u32 REGPARAM2 CPUFUNC(op_3078_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_110439;
	}
{{	uae_s16 src = get_word_000 (srca);
{	src = (uae_s32)(uae_s16)src;
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}l_110439: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (3/0) */

/* MOVEA.W (xxx).L,An */
uae_u32 REGPARAM2 CPUFUNC(op_3079_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_110440;
	}
{{	uae_s16 src = get_word_000 (srca);
{	src = (uae_s32)(uae_s16)src;
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}l_110440: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (4/0) */

/* MOVEA.W (d16,PC),An */
uae_u32 REGPARAM2 CPUFUNC(op_307a_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110441;
	}
{{	uae_s16 src = get_word_000 (srca);
{	src = (uae_s32)(uae_s16)src;
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}l_110441: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (3/0) */

/* MOVEA.W (d8,PC,Xn),An */
uae_u32 REGPARAM2 CPUFUNC(op_307b_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	srca = get_disp_ea_000 (tmppc, get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110442;
	}
{{	uae_s16 src = get_word_000 (srca);
{	src = (uae_s32)(uae_s16)src;
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}l_110442: ;
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (3/0) */

/* MOVEA.W #<data>.W,An */
uae_u32 REGPARAM2 CPUFUNC(op_307c_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	src = (uae_s32)(uae_s16)src;
	m68k_areg (regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (2/0) */

/* MOVE.W Dn,(An) */
uae_u32 REGPARAM2 CPUFUNC(op_3080_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_110444;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}l_110444: ;
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/1) */

/* MOVE.W An,(An) */
uae_u32 REGPARAM2 CPUFUNC(op_3088_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_areg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_110445;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}l_110445: ;
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/1) */

/* MOVE.W (An),(An) */
uae_u32 REGPARAM2 CPUFUNC(op_3090_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110446;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_110446;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110446: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* MOVE.W (An)+,(An) */
uae_u32 REGPARAM2 CPUFUNC(op_3098_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110447;
	}
{{	uae_s16 src = get_word_000 (srca);
	m68k_areg (regs, srcreg) += 2;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_110447;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110447: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* MOVE.W -(An),(An) */
uae_u32 REGPARAM2 CPUFUNC(op_30a0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_110448;
	}
{{	uae_s16 src = get_word_000 (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_110448;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110448: ;
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (2/1) */

/* MOVE.W (d16,An),(An) */
uae_u32 REGPARAM2 CPUFUNC(op_30a8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110449;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110449;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110449: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* MOVE.W (d8,An,Xn),(An) */
uae_u32 REGPARAM2 CPUFUNC(op_30b0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110450;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110450;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110450: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/1) */

/* MOVE.W (xxx).W,(An) */
uae_u32 REGPARAM2 CPUFUNC(op_30b8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_110451;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110451;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110451: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* MOVE.W (xxx).L,(An) */
uae_u32 REGPARAM2 CPUFUNC(op_30b9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_110452;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (8);
		exception3_write(opcode, dsta);
		goto l_110452;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110452: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* MOVE.W (d16,PC),(An) */
uae_u32 REGPARAM2 CPUFUNC(op_30ba_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110453;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110453;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110453: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* MOVE.W (d8,PC,Xn),(An) */
uae_u32 REGPARAM2 CPUFUNC(op_30bb_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	srca = get_disp_ea_000 (tmppc, get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110454;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110454;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110454: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/1) */

/* MOVE.W #<data>.W,(An) */
uae_u32 REGPARAM2 CPUFUNC(op_30bc_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110455;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}l_110455: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* MOVE.W Dn,(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_30c0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_110456;
	}
{	m68k_areg (regs, dstreg) += 2;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}l_110456: ;
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/1) */

/* MOVE.W An,(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_30c8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_areg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_110457;
	}
{	m68k_areg (regs, dstreg) += 2;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}l_110457: ;
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/1) */

/* MOVE.W (An),(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_30d0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110458;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_110458;
	}
{	m68k_areg (regs, dstreg) += 2;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110458: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* MOVE.W (An)+,(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_30d8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110459;
	}
{{	uae_s16 src = get_word_000 (srca);
	m68k_areg (regs, srcreg) += 2;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_110459;
	}
{	m68k_areg (regs, dstreg) += 2;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110459: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* MOVE.W -(An),(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_30e0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_110460;
	}
{{	uae_s16 src = get_word_000 (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_110460;
	}
{	m68k_areg (regs, dstreg) += 2;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110460: ;
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (2/1) */

/* MOVE.W (d16,An),(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_30e8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110461;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110461;
	}
{	m68k_areg (regs, dstreg) += 2;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110461: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* MOVE.W (d8,An,Xn),(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_30f0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110462;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110462;
	}
{	m68k_areg (regs, dstreg) += 2;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110462: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/1) */

/* MOVE.W (xxx).W,(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_30f8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_110463;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110463;
	}
{	m68k_areg (regs, dstreg) += 2;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110463: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* MOVE.W (xxx).L,(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_30f9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_110464;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (8);
		exception3_write(opcode, dsta);
		goto l_110464;
	}
{	m68k_areg (regs, dstreg) += 2;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110464: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* MOVE.W (d16,PC),(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_30fa_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110465;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110465;
	}
{	m68k_areg (regs, dstreg) += 2;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110465: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* MOVE.W (d8,PC,Xn),(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_30fb_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	srca = get_disp_ea_000 (tmppc, get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110466;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110466;
	}
{	m68k_areg (regs, dstreg) += 2;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110466: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/1) */

/* MOVE.W #<data>.W,(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_30fc_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110467;
	}
{	m68k_areg (regs, dstreg) += 2;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}l_110467: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* MOVE.W Dn,-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_3100_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_110468;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (2);
}}}}l_110468: ;
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/1) */

/* MOVE.W An,-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_3108_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_areg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_110469;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (2);
}}}}l_110469: ;
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/1) */

/* MOVE.W (An),-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_3110_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110470;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_110470;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (2);
}}}}}}l_110470: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* MOVE.W (An)+,-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_3118_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110471;
	}
{{	uae_s16 src = get_word_000 (srca);
	m68k_areg (regs, srcreg) += 2;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_110471;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (2);
}}}}}}l_110471: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* MOVE.W -(An),-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_3120_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_110472;
	}
{{	uae_s16 src = get_word_000 (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_110472;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (2);
}}}}}}l_110472: ;
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (2/1) */

/* MOVE.W (d16,An),-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_3128_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110473;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110473;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (4);
}}}}}}l_110473: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* MOVE.W (d8,An,Xn),-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_3130_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110474;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110474;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (4);
}}}}}}l_110474: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/1) */

/* MOVE.W (xxx).W,-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_3138_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_110475;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110475;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (4);
}}}}}}l_110475: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* MOVE.W (xxx).L,-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_3139_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_110476;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	if (dsta & 1) {
	m68k_incpci (8);
		exception3_write(opcode, dsta);
		goto l_110476;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (6);
}}}}}}l_110476: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* MOVE.W (d16,PC),-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_313a_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110477;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110477;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (4);
}}}}}}l_110477: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* MOVE.W (d8,PC,Xn),-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_313b_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	srca = get_disp_ea_000 (tmppc, get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110478;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110478;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (4);
}}}}}}l_110478: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/1) */

/* MOVE.W #<data>.W,-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_313c_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110479;
	}
{	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (4);
}}}}l_110479: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* MOVE.W Dn,(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_3140_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_110480;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}l_110480: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* MOVE.W An,(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_3148_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_areg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_110481;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}l_110481: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* MOVE.W (An),(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_3150_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110482;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_110482;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110482: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* MOVE.W (An)+,(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_3158_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110483;
	}
{{	uae_s16 src = get_word_000 (srca);
	m68k_areg (regs, srcreg) += 2;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_110483;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110483: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* MOVE.W -(An),(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_3160_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_110484;
	}
{{	uae_s16 src = get_word_000 (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_110484;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110484: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/1) */

/* MOVE.W (d16,An),(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_3168_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110485;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110485;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110485: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* MOVE.W (d8,An,Xn),(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_3170_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110486;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110486;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110486: ;
return 22 * CYCLE_UNIT / 2 + count_cycles;
} /* 22 (4/1) */

/* MOVE.W (xxx).W,(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_3178_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_110487;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110487;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110487: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* MOVE.W (xxx).L,(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_3179_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_110488;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (8);
	if (dsta & 1) {
	m68k_incpci (8);
		exception3_write(opcode, dsta);
		goto l_110488;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (8);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110488: ;
return 24 * CYCLE_UNIT / 2 + count_cycles;
} /* 24 (5/1) */

/* MOVE.W (d16,PC),(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_317a_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110489;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110489;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110489: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* MOVE.W (d8,PC,Xn),(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_317b_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	srca = get_disp_ea_000 (tmppc, get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110490;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110490;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110490: ;
return 22 * CYCLE_UNIT / 2 + count_cycles;
} /* 22 (4/1) */

/* MOVE.W #<data>.W,(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_317c_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110491;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}l_110491: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* MOVE.W Dn,(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_3180_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (4));
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_110492;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}l_110492: ;
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (2/1) */

/* MOVE.W An,(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_3188_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_areg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (4));
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_110493;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}l_110493: ;
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (2/1) */

/* MOVE.W (An),(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_3190_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110494;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (4));
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_110494;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110494: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/1) */

/* MOVE.W (An)+,(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_3198_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110495;
	}
{{	uae_s16 src = get_word_000 (srca);
	m68k_areg (regs, srcreg) += 2;
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (4));
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_110495;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110495: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/1) */

/* MOVE.W -(An),(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_31a0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_110496;
	}
{{	uae_s16 src = get_word_000 (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (4));
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_110496;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110496: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (3/1) */

/* MOVE.W (d16,An),(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_31a8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110497;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (6));
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110497;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110497: ;
return 22 * CYCLE_UNIT / 2 + count_cycles;
} /* 22 (4/1) */

/* MOVE.W (d8,An,Xn),(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_31b0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110498;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (6));
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110498;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110498: ;
return 24 * CYCLE_UNIT / 2 + count_cycles;
} /* 24 (4/1) */

/* MOVE.W (xxx).W,(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_31b8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_110499;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (6));
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110499;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110499: ;
return 22 * CYCLE_UNIT / 2 + count_cycles;
} /* 22 (4/1) */

/* MOVE.W (xxx).L,(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_31b9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_110500;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (8));
	if (dsta & 1) {
	m68k_incpci (8);
		exception3_write(opcode, dsta);
		goto l_110500;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (8);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110500: ;
return 26 * CYCLE_UNIT / 2 + count_cycles;
} /* 26 (5/1) */

/* MOVE.W (d16,PC),(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_31ba_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110501;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (6));
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110501;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110501: ;
return 22 * CYCLE_UNIT / 2 + count_cycles;
} /* 22 (4/1) */

/* MOVE.W (d8,PC,Xn),(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_31bb_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	srca = get_disp_ea_000 (tmppc, get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110502;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (6));
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110502;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110502: ;
return 24 * CYCLE_UNIT / 2 + count_cycles;
} /* 24 (4/1) */

/* MOVE.W #<data>.W,(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_31bc_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (6));
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110503;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}l_110503: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/1) */

/* MOVE.W Dn,(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_31c0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_110504;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}l_110504: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* MOVE.W An,(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_31c8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_areg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_110505;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}l_110505: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* MOVE.W (An),(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_31d0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110506;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_110506;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110506: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* MOVE.W (An)+,(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_31d8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110507;
	}
{{	uae_s16 src = get_word_000 (srca);
	m68k_areg (regs, srcreg) += 2;
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_110507;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110507: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* MOVE.W -(An),(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_31e0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_110508;
	}
{{	uae_s16 src = get_word_000 (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_110508;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110508: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/1) */

/* MOVE.W (d16,An),(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_31e8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110509;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110509;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110509: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* MOVE.W (d8,An,Xn),(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_31f0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110510;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110510;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110510: ;
return 22 * CYCLE_UNIT / 2 + count_cycles;
} /* 22 (4/1) */

/* MOVE.W (xxx).W,(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_31f8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_110511;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110511;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110511: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* MOVE.W (xxx).L,(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_31f9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_110512;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (8);
	if (dsta & 1) {
	m68k_incpci (8);
		exception3_write(opcode, dsta);
		goto l_110512;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (8);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110512: ;
return 24 * CYCLE_UNIT / 2 + count_cycles;
} /* 24 (5/1) */

/* MOVE.W (d16,PC),(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_31fa_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110513;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110513;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110513: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* MOVE.W (d8,PC,Xn),(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_31fb_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	srca = get_disp_ea_000 (tmppc, get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110514;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110514;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110514: ;
return 22 * CYCLE_UNIT / 2 + count_cycles;
} /* 22 (4/1) */

/* MOVE.W #<data>.W,(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_31fc_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110515;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}l_110515: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* MOVE.W Dn,(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_33c0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_word_000_prefetch (4) << 16;
	dsta |= get_word_000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110516;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}l_110516: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* MOVE.W An,(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_33c8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_areg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_word_000_prefetch (4) << 16;
	dsta |= get_word_000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110517;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}l_110517: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* MOVE.W (An),(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_33d0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110518;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uaecptr dsta;
	dsta = get_word_000_prefetch (4) << 16;
	dsta |= regs.irc;
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110518;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (6);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110518: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* MOVE.W (An)+,(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_33d8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110519;
	}
{{	uae_s16 src = get_word_000 (srca);
	m68k_areg (regs, srcreg) += 2;
{	uaecptr dsta;
	dsta = get_word_000_prefetch (4) << 16;
	dsta |= regs.irc;
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110519;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (6);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110519: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* MOVE.W -(An),(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_33e0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_110520;
	}
{{	uae_s16 src = get_word_000 (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = get_word_000_prefetch (4) << 16;
	dsta |= regs.irc;
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110520;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (6);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110520: ;
return 22 * CYCLE_UNIT / 2 + count_cycles;
} /* 22 (4/1) */

/* MOVE.W (d16,An),(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_33e8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110521;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uaecptr dsta;
	dsta = get_word_000_prefetch (6) << 16;
	dsta |= regs.irc;
	if (dsta & 1) {
	m68k_incpci (8);
		exception3_write(opcode, dsta);
		goto l_110521;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (8);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110521: ;
return 24 * CYCLE_UNIT / 2 + count_cycles;
} /* 24 (5/1) */

/* MOVE.W (d8,An,Xn),(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_33f0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110522;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uaecptr dsta;
	dsta = get_word_000_prefetch (6) << 16;
	dsta |= regs.irc;
	if (dsta & 1) {
	m68k_incpci (8);
		exception3_write(opcode, dsta);
		goto l_110522;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (8);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110522: ;
return 26 * CYCLE_UNIT / 2 + count_cycles;
} /* 26 (5/1) */

/* MOVE.W (xxx).W,(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_33f8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_110523;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uaecptr dsta;
	dsta = get_word_000_prefetch (6) << 16;
	dsta |= regs.irc;
	if (dsta & 1) {
	m68k_incpci (8);
		exception3_write(opcode, dsta);
		goto l_110523;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (8);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110523: ;
return 24 * CYCLE_UNIT / 2 + count_cycles;
} /* 24 (5/1) */

/* MOVE.W (xxx).L,(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_33f9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_110524;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uaecptr dsta;
	dsta = get_word_000_prefetch (8) << 16;
	dsta |= regs.irc;
	if (dsta & 1) {
	m68k_incpci (10);
		exception3_write(opcode, dsta);
		goto l_110524;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (10);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110524: ;
return 28 * CYCLE_UNIT / 2 + count_cycles;
} /* 28 (6/1) */

/* MOVE.W (d16,PC),(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_33fa_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110525;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uaecptr dsta;
	dsta = get_word_000_prefetch (6) << 16;
	dsta |= regs.irc;
	if (dsta & 1) {
	m68k_incpci (8);
		exception3_write(opcode, dsta);
		goto l_110525;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (8);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110525: ;
return 24 * CYCLE_UNIT / 2 + count_cycles;
} /* 24 (5/1) */

/* MOVE.W (d8,PC,Xn),(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_33fb_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	srca = get_disp_ea_000 (tmppc, get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110526;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uaecptr dsta;
	dsta = get_word_000_prefetch (6) << 16;
	dsta |= regs.irc;
	if (dsta & 1) {
	m68k_incpci (8);
		exception3_write(opcode, dsta);
		goto l_110526;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (8);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}l_110526: ;
return 26 * CYCLE_UNIT / 2 + count_cycles;
} /* 26 (5/1) */

/* MOVE.W #<data>.W,(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_33fc_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = get_word_000_prefetch (6) << 16;
	dsta |= get_word_000_prefetch (8);
	if (dsta & 1) {
	m68k_incpci (8);
		exception3_write(opcode, dsta);
		goto l_110527;
	}
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	put_word_000 (dsta, src);
	m68k_incpci (8);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}l_110527: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* NEGX.B Dn */
uae_u32 REGPARAM2 CPUFUNC(op_4000_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((newv) & 0xff);
}}}}	m68k_incpci (2);
return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4 (1/0) */

/* NEGX.B (An) */
uae_u32 REGPARAM2 CPUFUNC(op_4010_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_000 (srca);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	put_byte_000 (srca, newv);
}}}}}	m68k_incpci (2);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* NEGX.B (An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_4018_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_000 (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	put_byte_000 (srca, newv);
}}}}}	m68k_incpci (2);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* NEGX.B -(An) */
uae_u32 REGPARAM2 CPUFUNC(op_4020_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte_000 (srca);
	m68k_areg (regs, srcreg) = srca;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	put_byte_000 (srca, newv);
}}}}}	m68k_incpci (2);
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (2/1) */

/* NEGX.B (d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_4028_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 src = get_byte_000 (srca);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	put_byte_000 (srca, newv);
}}}}}	m68k_incpci (4);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* NEGX.B (d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_4030_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
{	uae_s8 src = get_byte_000 (srca);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	put_byte_000 (srca, newv);
}}}}}	m68k_incpci (4);
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/1) */

/* NEGX.B (xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_4038_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 src = get_byte_000 (srca);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	put_byte_000 (srca, newv);
}}}}}	m68k_incpci (4);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* NEGX.B (xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_4039_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
{	uae_s8 src = get_byte_000 (srca);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	put_byte_000 (srca, newv);
}}}}}	m68k_incpci (6);
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* NEGX.W Dn */
uae_u32 REGPARAM2 CPUFUNC(op_4040_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s16)(newv)) == 0));
	SET_NFLG (((uae_s16)(newv)) < 0);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | ((newv) & 0xffff);
}}}}	m68k_incpci (2);
return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4 (1/0) */

/* NEGX.W (An) */
uae_u32 REGPARAM2 CPUFUNC(op_4050_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110537;
	}
{{	uae_s16 src = get_word_000 (srca);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s16)(newv)) == 0));
	SET_NFLG (((uae_s16)(newv)) < 0);
	put_word_000 (srca, newv);
}}}}}}	m68k_incpci (2);
l_110537: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* NEGX.W (An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_4058_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110538;
	}
{{	uae_s16 src = get_word_000 (srca);
	m68k_areg (regs, srcreg) += 2;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s16)(newv)) == 0));
	SET_NFLG (((uae_s16)(newv)) < 0);
	put_word_000 (srca, newv);
}}}}}}	m68k_incpci (2);
l_110538: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* NEGX.W -(An) */
uae_u32 REGPARAM2 CPUFUNC(op_4060_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_110539;
	}
{{	uae_s16 src = get_word_000 (srca);
	m68k_areg (regs, srcreg) = srca;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s16)(newv)) == 0));
	SET_NFLG (((uae_s16)(newv)) < 0);
	put_word_000 (srca, newv);
}}}}}}	m68k_incpci (2);
l_110539: ;
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (2/1) */

/* NEGX.W (d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_4068_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110540;
	}
{{	uae_s16 src = get_word_000 (srca);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s16)(newv)) == 0));
	SET_NFLG (((uae_s16)(newv)) < 0);
	put_word_000 (srca, newv);
}}}}}}	m68k_incpci (4);
l_110540: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* NEGX.W (d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_4070_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110541;
	}
{{	uae_s16 src = get_word_000 (srca);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s16)(newv)) == 0));
	SET_NFLG (((uae_s16)(newv)) < 0);
	put_word_000 (srca, newv);
}}}}}}	m68k_incpci (4);
l_110541: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/1) */

/* NEGX.W (xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_4078_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_110542;
	}
{{	uae_s16 src = get_word_000 (srca);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s16)(newv)) == 0));
	SET_NFLG (((uae_s16)(newv)) < 0);
	put_word_000 (srca, newv);
}}}}}}	m68k_incpci (4);
l_110542: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* NEGX.W (xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_4079_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_110543;
	}
{{	uae_s16 src = get_word_000 (srca);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s16)(newv)) == 0));
	SET_NFLG (((uae_s16)(newv)) < 0);
	put_word_000 (srca, newv);
}}}}}}	m68k_incpci (6);
l_110543: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* NEGX.L Dn */
uae_u32 REGPARAM2 CPUFUNC(op_4080_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s32)(newv)) == 0));
	SET_NFLG (((uae_s32)(newv)) < 0);
	m68k_dreg (regs, srcreg) = (newv);
}}}}	m68k_incpci (2);
return 6 * CYCLE_UNIT / 2 + count_cycles;
} /* 6 (1/0) */

/* NEGX.L (An) */
uae_u32 REGPARAM2 CPUFUNC(op_4090_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110545;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s32)(newv)) == 0));
	SET_NFLG (((uae_s32)(newv)) < 0);
	put_word_000 (srca + 2, newv); put_word_000 (srca, newv >> 16);
}}}}}}	m68k_incpci (2);
l_110545: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (3/2) */

/* NEGX.L (An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_4098_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110546;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
	m68k_areg (regs, srcreg) += 4;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s32)(newv)) == 0));
	SET_NFLG (((uae_s32)(newv)) < 0);
	put_word_000 (srca + 2, newv); put_word_000 (srca, newv >> 16);
}}}}}}	m68k_incpci (2);
l_110546: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (3/2) */

/* NEGX.L -(An) */
uae_u32 REGPARAM2 CPUFUNC(op_40a0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_110547;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
	m68k_areg (regs, srcreg) = srca;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s32)(newv)) == 0));
	SET_NFLG (((uae_s32)(newv)) < 0);
	put_word_000 (srca + 2, newv); put_word_000 (srca, newv >> 16);
}}}}}}	m68k_incpci (2);
l_110547: ;
return 22 * CYCLE_UNIT / 2 + count_cycles;
} /* 22 (3/2) */

/* NEGX.L (d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_40a8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110548;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s32)(newv)) == 0));
	SET_NFLG (((uae_s32)(newv)) < 0);
	put_word_000 (srca + 2, newv); put_word_000 (srca, newv >> 16);
}}}}}}	m68k_incpci (4);
l_110548: ;
return 24 * CYCLE_UNIT / 2 + count_cycles;
} /* 24 (4/2) */

/* NEGX.L (d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_40b0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110549;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s32)(newv)) == 0));
	SET_NFLG (((uae_s32)(newv)) < 0);
	put_word_000 (srca + 2, newv); put_word_000 (srca, newv >> 16);
}}}}}}	m68k_incpci (4);
l_110549: ;
return 26 * CYCLE_UNIT / 2 + count_cycles;
} /* 26 (4/2) */

/* NEGX.L (xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_40b8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_110550;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s32)(newv)) == 0));
	SET_NFLG (((uae_s32)(newv)) < 0);
	put_word_000 (srca + 2, newv); put_word_000 (srca, newv >> 16);
}}}}}}	m68k_incpci (4);
l_110550: ;
return 24 * CYCLE_UNIT / 2 + count_cycles;
} /* 24 (4/2) */

/* NEGX.L (xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_40b9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_110551;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{	uae_u32 newv = 0 - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s32)(newv)) == 0));
	SET_NFLG (((uae_s32)(newv)) < 0);
	put_word_000 (srca + 2, newv); put_word_000 (srca, newv >> 16);
}}}}}}	m68k_incpci (6);
l_110551: ;
return 28 * CYCLE_UNIT / 2 + count_cycles;
} /* 28 (5/2) */

/* MVSR2.W Dn */
uae_u32 REGPARAM2 CPUFUNC(op_40c0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{if (!regs.s) { Exception (8); goto l_110552; }
{{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	MakeSR ();
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | ((regs.sr) & 0xffff);
}}}	m68k_incpci (2);
l_110552: ;
return 6 * CYCLE_UNIT / 2 + count_cycles;
} /* 6 (1/0) */

/* MVSR2.W (An) */
uae_u32 REGPARAM2 CPUFUNC(op_40d0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{if (!regs.s) { Exception (8); goto l_110553; }
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_write(opcode, srca);
		goto l_110553;
	}
{	put_word_000 (srca, regs.sr | 0x0010);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	MakeSR ();
	put_word_000 (srca, regs.sr);
}}}}	m68k_incpci (2);
l_110553: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (1/2) */

/* MVSR2.W (An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_40d8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{if (!regs.s) { Exception (8); goto l_110554; }
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_write(opcode, srca);
		goto l_110554;
	}
{	m68k_areg (regs, srcreg) += 2;
	put_word_000 (srca, regs.sr | 0x0010);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	MakeSR ();
	put_word_000 (srca, regs.sr);
}}}}	m68k_incpci (2);
l_110554: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (1/2) */

/* MVSR2.W -(An) */
uae_u32 REGPARAM2 CPUFUNC(op_40e0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{if (!regs.s) { Exception (8); goto l_110555; }
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	if (srca & 1) {
	m68k_incpci (4);
		exception3_write(opcode, srca);
		goto l_110555;
	}
{	m68k_areg (regs, srcreg) = srca;
	put_word_000 (srca, regs.sr | 0x0010);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	MakeSR ();
	put_word_000 (srca, regs.sr);
}}}}	m68k_incpci (2);
l_110555: ;
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (1/2) */

/* MVSR2.W (d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_40e8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{if (!regs.s) { Exception (8); goto l_110556; }
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_write(opcode, srca);
		goto l_110556;
	}
{	put_word_000 (srca, regs.sr | 0x0010);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	MakeSR ();
	put_word_000 (srca, regs.sr);
}}}}	m68k_incpci (4);
l_110556: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (2/2) */

/* MVSR2.W (d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_40f0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{if (!regs.s) { Exception (8); goto l_110557; }
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (4);
		exception3_write(opcode, srca);
		goto l_110557;
	}
{	put_word_000 (srca, regs.sr | 0x0010);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	MakeSR ();
	put_word_000 (srca, regs.sr);
}}}}	m68k_incpci (4);
l_110557: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (2/2) */

/* MVSR2.W (xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_40f8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{if (!regs.s) { Exception (8); goto l_110558; }
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_write(opcode, srca);
		goto l_110558;
	}
{	put_word_000 (srca, regs.sr | 0x0010);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	MakeSR ();
	put_word_000 (srca, regs.sr);
}}}}	m68k_incpci (4);
l_110558: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (2/2) */

/* MVSR2.W (xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_40f9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{if (!regs.s) { Exception (8); goto l_110559; }
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_write(opcode, srca);
		goto l_110559;
	}
{	put_word_000 (srca, regs.sr | 0x0010);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	MakeSR ();
	put_word_000 (srca, regs.sr);
}}}}	m68k_incpci (6);
l_110559: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (3/2) */

/* CHK.W Dn,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_4180_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	m68k_incpci (2);
	if (dst > src) {
		SET_NFLG (0);
		Exception (6);
		goto l_110560;
	}
	if ((uae_s32)dst < 0) {
		SET_NFLG (1);
		Exception (6);
		goto l_110560;
	}
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}l_110560: ;
return 10 * CYCLE_UNIT / 2 + count_cycles;
} /* 10 (1/0) */

/* CHK.W (An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_4190_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110561;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	m68k_incpci (2);
	if (dst > src) {
		SET_NFLG (0);
		Exception (6);
		goto l_110561;
	}
	if ((uae_s32)dst < 0) {
		SET_NFLG (1);
		Exception (6);
		goto l_110561;
	}
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}l_110561: ;
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (2/0) */

/* CHK.W (An)+,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_4198_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110562;
	}
{{	uae_s16 src = get_word_000 (srca);
	m68k_areg (regs, srcreg) += 2;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	m68k_incpci (2);
	if (dst > src) {
		SET_NFLG (0);
		Exception (6);
		goto l_110562;
	}
	if ((uae_s32)dst < 0) {
		SET_NFLG (1);
		Exception (6);
		goto l_110562;
	}
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}l_110562: ;
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (2/0) */

/* CHK.W -(An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_41a0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_110563;
	}
{{	uae_s16 src = get_word_000 (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	m68k_incpci (2);
	if (dst > src) {
		SET_NFLG (0);
		Exception (6);
		goto l_110563;
	}
	if ((uae_s32)dst < 0) {
		SET_NFLG (1);
		Exception (6);
		goto l_110563;
	}
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}l_110563: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (2/0) */

/* CHK.W (d16,An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_41a8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110564;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	m68k_incpci (4);
	if (dst > src) {
		SET_NFLG (0);
		Exception (6);
		goto l_110564;
	}
	if ((uae_s32)dst < 0) {
		SET_NFLG (1);
		Exception (6);
		goto l_110564;
	}
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}l_110564: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/0) */

/* CHK.W (d8,An,Xn),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_41b0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110565;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	m68k_incpci (4);
	if (dst > src) {
		SET_NFLG (0);
		Exception (6);
		goto l_110565;
	}
	if ((uae_s32)dst < 0) {
		SET_NFLG (1);
		Exception (6);
		goto l_110565;
	}
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}l_110565: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (3/0) */

/* CHK.W (xxx).W,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_41b8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_110566;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	m68k_incpci (4);
	if (dst > src) {
		SET_NFLG (0);
		Exception (6);
		goto l_110566;
	}
	if ((uae_s32)dst < 0) {
		SET_NFLG (1);
		Exception (6);
		goto l_110566;
	}
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}l_110566: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/0) */

/* CHK.W (xxx).L,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_41b9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_110567;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	m68k_incpci (6);
	if (dst > src) {
		SET_NFLG (0);
		Exception (6);
		goto l_110567;
	}
	if ((uae_s32)dst < 0) {
		SET_NFLG (1);
		Exception (6);
		goto l_110567;
	}
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}l_110567: ;
return 22 * CYCLE_UNIT / 2 + count_cycles;
} /* 22 (4/0) */

/* CHK.W (d16,PC),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_41ba_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110568;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	m68k_incpci (4);
	if (dst > src) {
		SET_NFLG (0);
		Exception (6);
		goto l_110568;
	}
	if ((uae_s32)dst < 0) {
		SET_NFLG (1);
		Exception (6);
		goto l_110568;
	}
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}l_110568: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/0) */

/* CHK.W (d8,PC,Xn),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_41bb_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	srca = get_disp_ea_000 (tmppc, get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110569;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	m68k_incpci (4);
	if (dst > src) {
		SET_NFLG (0);
		Exception (6);
		goto l_110569;
	}
	if ((uae_s32)dst < 0) {
		SET_NFLG (1);
		Exception (6);
		goto l_110569;
	}
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}l_110569: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (3/0) */

/* CHK.W #<data>.W,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_41bc_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	m68k_incpci (4);
	if (dst > src) {
		SET_NFLG (0);
		Exception (6);
		goto l_110570;
	}
	if ((uae_s32)dst < 0) {
		SET_NFLG (1);
		Exception (6);
		goto l_110570;
	}
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}l_110570: ;
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (2/0) */

/* LEA.L (An),An */
uae_u32 REGPARAM2 CPUFUNC(op_41d0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	m68k_areg (regs, dstreg) = (srca);
}}}	m68k_incpci (2);
return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4 (1/0) */

/* LEA.L (d16,An),An */
uae_u32 REGPARAM2 CPUFUNC(op_41e8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	m68k_areg (regs, dstreg) = (srca);
}}}	m68k_incpci (4);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (2/0) */

/* LEA.L (d8,An,Xn),An */
uae_u32 REGPARAM2 CPUFUNC(op_41f0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
{	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	m68k_areg (regs, dstreg) = (srca);
}}}	m68k_incpci (4);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/0) */

/* LEA.L (xxx).W,An */
uae_u32 REGPARAM2 CPUFUNC(op_41f8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	m68k_areg (regs, dstreg) = (srca);
}}}	m68k_incpci (4);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (2/0) */

/* LEA.L (xxx).L,An */
uae_u32 REGPARAM2 CPUFUNC(op_41f9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
{	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	m68k_areg (regs, dstreg) = (srca);
}}}	m68k_incpci (6);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (3/0) */

/* LEA.L (d16,PC),An */
uae_u32 REGPARAM2 CPUFUNC(op_41fa_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	m68k_areg (regs, dstreg) = (srca);
}}}	m68k_incpci (4);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (2/0) */

/* LEA.L (d8,PC,Xn),An */
uae_u32 REGPARAM2 CPUFUNC(op_41fb_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	srca = get_disp_ea_000 (tmppc, get_word_000_prefetch (4));
{	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	m68k_areg (regs, dstreg) = (srca);
}}}	m68k_incpci (4);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/0) */

/* CLR.B Dn */
uae_u32 REGPARAM2 CPUFUNC(op_4200_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(0)) == 0);
	SET_NFLG (((uae_s8)(0)) < 0);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((0) & 0xff);
}}	m68k_incpci (2);
return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4 (1/0) */

/* CLR.B (An) */
uae_u32 REGPARAM2 CPUFUNC(op_4210_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(0)) == 0);
	SET_NFLG (((uae_s8)(0)) < 0);
	put_byte_000 (srca, 0);
}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/1) */

/* CLR.B (An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_4218_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(0)) == 0);
	SET_NFLG (((uae_s8)(0)) < 0);
	put_byte_000 (srca, 0);
}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/1) */

/* CLR.B -(An) */
uae_u32 REGPARAM2 CPUFUNC(op_4220_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(0)) == 0);
	SET_NFLG (((uae_s8)(0)) < 0);
	put_byte_000 (srca, 0);
}}	m68k_incpci (2);
return 10 * CYCLE_UNIT / 2 + count_cycles;
} /* 10 (1/1) */

/* CLR.B (d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_4228_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(0)) == 0);
	SET_NFLG (((uae_s8)(0)) < 0);
	put_byte_000 (srca, 0);
}}	m68k_incpci (4);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* CLR.B (d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_4230_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(0)) == 0);
	SET_NFLG (((uae_s8)(0)) < 0);
	put_byte_000 (srca, 0);
}}	m68k_incpci (4);
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (2/1) */

/* CLR.B (xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_4238_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(0)) == 0);
	SET_NFLG (((uae_s8)(0)) < 0);
	put_byte_000 (srca, 0);
}}	m68k_incpci (4);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* CLR.B (xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_4239_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(0)) == 0);
	SET_NFLG (((uae_s8)(0)) < 0);
	put_byte_000 (srca, 0);
}}	m68k_incpci (6);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* CLR.W Dn */
uae_u32 REGPARAM2 CPUFUNC(op_4240_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(0)) == 0);
	SET_NFLG (((uae_s16)(0)) < 0);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | ((0) & 0xffff);
}}	m68k_incpci (2);
return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4 (1/0) */

/* CLR.W (An) */
uae_u32 REGPARAM2 CPUFUNC(op_4250_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_write(opcode, srca);
		goto l_110587;
	}
{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(0)) == 0);
	SET_NFLG (((uae_s16)(0)) < 0);
	put_word_000 (srca, 0);
}}}	m68k_incpci (2);
l_110587: ;
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/1) */

/* CLR.W (An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_4258_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_write(opcode, srca);
		goto l_110588;
	}
{	m68k_areg (regs, srcreg) += 2;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(0)) == 0);
	SET_NFLG (((uae_s16)(0)) < 0);
	put_word_000 (srca, 0);
}}}	m68k_incpci (2);
l_110588: ;
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/1) */

/* CLR.W -(An) */
uae_u32 REGPARAM2 CPUFUNC(op_4260_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	if (srca & 1) {
	m68k_incpci (4);
		exception3_write(opcode, srca);
		goto l_110589;
	}
{	m68k_areg (regs, srcreg) = srca;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(0)) == 0);
	SET_NFLG (((uae_s16)(0)) < 0);
	put_word_000 (srca, 0);
}}}	m68k_incpci (2);
l_110589: ;
return 10 * CYCLE_UNIT / 2 + count_cycles;
} /* 10 (1/1) */

/* CLR.W (d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_4268_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_write(opcode, srca);
		goto l_110590;
	}
{	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(0)) == 0);
	SET_NFLG (((uae_s16)(0)) < 0);
	put_word_000 (srca, 0);
}}}	m68k_incpci (4);
l_110590: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* CLR.W (d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_4270_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (4);
		exception3_write(opcode, srca);
		goto l_110591;
	}
{	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(0)) == 0);
	SET_NFLG (((uae_s16)(0)) < 0);
	put_word_000 (srca, 0);
}}}	m68k_incpci (4);
l_110591: ;
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (2/1) */

/* CLR.W (xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_4278_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_write(opcode, srca);
		goto l_110592;
	}
{	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(0)) == 0);
	SET_NFLG (((uae_s16)(0)) < 0);
	put_word_000 (srca, 0);
}}}	m68k_incpci (4);
l_110592: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* CLR.W (xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_4279_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_write(opcode, srca);
		goto l_110593;
	}
{	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(0)) == 0);
	SET_NFLG (((uae_s16)(0)) < 0);
	put_word_000 (srca, 0);
}}}	m68k_incpci (6);
l_110593: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* CLR.L Dn */
uae_u32 REGPARAM2 CPUFUNC(op_4280_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(0)) == 0);
	SET_NFLG (((uae_s32)(0)) < 0);
	m68k_dreg (regs, srcreg) = (0);
}}	m68k_incpci (2);
return 6 * CYCLE_UNIT / 2 + count_cycles;
} /* 6 (1/0) */

/* CLR.L (An) */
uae_u32 REGPARAM2 CPUFUNC(op_4290_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_write(opcode, srca);
		goto l_110595;
	}
{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(0)) == 0);
	SET_NFLG (((uae_s32)(0)) < 0);
	put_word_000 (srca + 2, 0); put_word_000 (srca, 0 >> 16);
}}}	m68k_incpci (2);
l_110595: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (1/2) */

/* CLR.L (An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_4298_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_write(opcode, srca);
		goto l_110596;
	}
{	m68k_areg (regs, srcreg) += 4;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(0)) == 0);
	SET_NFLG (((uae_s32)(0)) < 0);
	put_word_000 (srca + 2, 0); put_word_000 (srca, 0 >> 16);
}}}	m68k_incpci (2);
l_110596: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (1/2) */

/* CLR.L -(An) */
uae_u32 REGPARAM2 CPUFUNC(op_42a0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	if (srca & 1) {
	m68k_incpci (4);
		exception3_write(opcode, srca);
		goto l_110597;
	}
{	m68k_areg (regs, srcreg) = srca;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(0)) == 0);
	SET_NFLG (((uae_s32)(0)) < 0);
	put_word_000 (srca + 2, 0); put_word_000 (srca, 0 >> 16);
}}}	m68k_incpci (2);
l_110597: ;
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (1/2) */

/* CLR.L (d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_42a8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_write(opcode, srca);
		goto l_110598;
	}
{	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(0)) == 0);
	SET_NFLG (((uae_s32)(0)) < 0);
	put_word_000 (srca + 2, 0); put_word_000 (srca, 0 >> 16);
}}}	m68k_incpci (4);
l_110598: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (2/2) */

/* CLR.L (d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_42b0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (4);
		exception3_write(opcode, srca);
		goto l_110599;
	}
{	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(0)) == 0);
	SET_NFLG (((uae_s32)(0)) < 0);
	put_word_000 (srca + 2, 0); put_word_000 (srca, 0 >> 16);
}}}	m68k_incpci (4);
l_110599: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (2/2) */

/* CLR.L (xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_42b8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_write(opcode, srca);
		goto l_110600;
	}
{	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(0)) == 0);
	SET_NFLG (((uae_s32)(0)) < 0);
	put_word_000 (srca + 2, 0); put_word_000 (srca, 0 >> 16);
}}}	m68k_incpci (4);
l_110600: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (2/2) */

/* CLR.L (xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_42b9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_write(opcode, srca);
		goto l_110601;
	}
{	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(0)) == 0);
	SET_NFLG (((uae_s32)(0)) < 0);
	put_word_000 (srca + 2, 0); put_word_000 (srca, 0 >> 16);
}}}	m68k_incpci (6);
l_110601: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (3/2) */

/* MVSR2.B Dn */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 CPUFUNC(op_42c0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	MakeSR ();
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | ((regs.sr & 0xff) & 0xffff);
}}	m68k_incpci (2);
return 6 * CYCLE_UNIT / 2 + count_cycles;
} /* 6 (1/0) */

#endif
/* MVSR2.B (An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 CPUFUNC(op_42d0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_write(opcode, srca);
		goto l_110603;
	}
{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	MakeSR ();
	put_word_000 (srca, regs.sr & 0xff);
}}}	m68k_incpci (2);
l_110603: ;
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/1) */

#endif
/* MVSR2.B (An)+ */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 CPUFUNC(op_42d8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_write(opcode, srca);
		goto l_110604;
	}
{	m68k_areg (regs, srcreg) += 2;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	MakeSR ();
	put_word_000 (srca, regs.sr & 0xff);
}}}	m68k_incpci (2);
l_110604: ;
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/1) */

#endif
/* MVSR2.B -(An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 CPUFUNC(op_42e0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	if (srca & 1) {
	m68k_incpci (4);
		exception3_write(opcode, srca);
		goto l_110605;
	}
{	m68k_areg (regs, srcreg) = srca;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	MakeSR ();
	put_word_000 (srca, regs.sr & 0xff);
}}}	m68k_incpci (2);
l_110605: ;
return 10 * CYCLE_UNIT / 2 + count_cycles;
} /* 10 (1/1) */

#endif
/* MVSR2.B (d16,An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 CPUFUNC(op_42e8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_write(opcode, srca);
		goto l_110606;
	}
{	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	MakeSR ();
	put_word_000 (srca, regs.sr & 0xff);
}}}	m68k_incpci (4);
l_110606: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

#endif
/* MVSR2.B (d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 CPUFUNC(op_42f0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (4);
		exception3_write(opcode, srca);
		goto l_110607;
	}
{	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	MakeSR ();
	put_word_000 (srca, regs.sr & 0xff);
}}}	m68k_incpci (4);
l_110607: ;
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (2/1) */

#endif
/* MVSR2.B (xxx).W */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 CPUFUNC(op_42f8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_write(opcode, srca);
		goto l_110608;
	}
{	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	MakeSR ();
	put_word_000 (srca, regs.sr & 0xff);
}}}	m68k_incpci (4);
l_110608: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

#endif
/* MVSR2.B (xxx).L */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 CPUFUNC(op_42f9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_write(opcode, srca);
		goto l_110609;
	}
{	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	MakeSR ();
	put_word_000 (srca, regs.sr & 0xff);
}}}	m68k_incpci (6);
l_110609: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

#endif
/* NEG.B Dn */
uae_u32 REGPARAM2 CPUFUNC(op_4400_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((dst) & 0xff);
}}}}}	m68k_incpci (2);
return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4 (1/0) */

#endif

#ifdef PART_4
/* NEG.B (An) */
uae_u32 REGPARAM2 CPUFUNC(op_4410_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_000 (srca);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_byte_000 (srca, dst);
}}}}}}	m68k_incpci (2);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* NEG.B (An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_4418_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_000 (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_byte_000 (srca, dst);
}}}}}}	m68k_incpci (2);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* NEG.B -(An) */
uae_u32 REGPARAM2 CPUFUNC(op_4420_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte_000 (srca);
	m68k_areg (regs, srcreg) = srca;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_byte_000 (srca, dst);
}}}}}}	m68k_incpci (2);
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (2/1) */

/* NEG.B (d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_4428_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 src = get_byte_000 (srca);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_byte_000 (srca, dst);
}}}}}}	m68k_incpci (4);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* NEG.B (d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_4430_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
{	uae_s8 src = get_byte_000 (srca);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_byte_000 (srca, dst);
}}}}}}	m68k_incpci (4);
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/1) */

/* NEG.B (xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_4438_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 src = get_byte_000 (srca);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_byte_000 (srca, dst);
}}}}}}	m68k_incpci (4);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* NEG.B (xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_4439_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
{	uae_s8 src = get_byte_000 (srca);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{{uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_byte_000 (srca, dst);
}}}}}}	m68k_incpci (6);
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* NEG.W Dn */
uae_u32 REGPARAM2 CPUFUNC(op_4440_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | ((dst) & 0xffff);
}}}}}	m68k_incpci (2);
return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4 (1/0) */

/* NEG.W (An) */
uae_u32 REGPARAM2 CPUFUNC(op_4450_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110619;
	}
{{	uae_s16 src = get_word_000 (srca);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (srca, dst);
}}}}}}}	m68k_incpci (2);
l_110619: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* NEG.W (An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_4458_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110620;
	}
{{	uae_s16 src = get_word_000 (srca);
	m68k_areg (regs, srcreg) += 2;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (srca, dst);
}}}}}}}	m68k_incpci (2);
l_110620: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* NEG.W -(An) */
uae_u32 REGPARAM2 CPUFUNC(op_4460_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_110621;
	}
{{	uae_s16 src = get_word_000 (srca);
	m68k_areg (regs, srcreg) = srca;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (srca, dst);
}}}}}}}	m68k_incpci (2);
l_110621: ;
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (2/1) */

/* NEG.W (d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_4468_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110622;
	}
{{	uae_s16 src = get_word_000 (srca);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (srca, dst);
}}}}}}}	m68k_incpci (4);
l_110622: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* NEG.W (d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_4470_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110623;
	}
{{	uae_s16 src = get_word_000 (srca);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (srca, dst);
}}}}}}}	m68k_incpci (4);
l_110623: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/1) */

/* NEG.W (xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_4478_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_110624;
	}
{{	uae_s16 src = get_word_000 (srca);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (srca, dst);
}}}}}}}	m68k_incpci (4);
l_110624: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* NEG.W (xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_4479_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_110625;
	}
{{	uae_s16 src = get_word_000 (srca);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{{uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (srca, dst);
}}}}}}}	m68k_incpci (6);
l_110625: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* NEG.L Dn */
uae_u32 REGPARAM2 CPUFUNC(op_4480_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, srcreg) = (dst);
}}}}}	m68k_incpci (2);
return 6 * CYCLE_UNIT / 2 + count_cycles;
} /* 6 (1/0) */

/* NEG.L (An) */
uae_u32 REGPARAM2 CPUFUNC(op_4490_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110627;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (srca + 2, dst); put_word_000 (srca, dst >> 16);
}}}}}}}	m68k_incpci (2);
l_110627: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (3/2) */

/* NEG.L (An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_4498_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110628;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
	m68k_areg (regs, srcreg) += 4;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (srca + 2, dst); put_word_000 (srca, dst >> 16);
}}}}}}}	m68k_incpci (2);
l_110628: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (3/2) */

/* NEG.L -(An) */
uae_u32 REGPARAM2 CPUFUNC(op_44a0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_110629;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
	m68k_areg (regs, srcreg) = srca;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (srca + 2, dst); put_word_000 (srca, dst >> 16);
}}}}}}}	m68k_incpci (2);
l_110629: ;
return 22 * CYCLE_UNIT / 2 + count_cycles;
} /* 22 (3/2) */

/* NEG.L (d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_44a8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110630;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (srca + 2, dst); put_word_000 (srca, dst >> 16);
}}}}}}}	m68k_incpci (4);
l_110630: ;
return 24 * CYCLE_UNIT / 2 + count_cycles;
} /* 24 (4/2) */

/* NEG.L (d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_44b0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110631;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (srca + 2, dst); put_word_000 (srca, dst >> 16);
}}}}}}}	m68k_incpci (4);
l_110631: ;
return 26 * CYCLE_UNIT / 2 + count_cycles;
} /* 26 (4/2) */

/* NEG.L (xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_44b8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_110632;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (srca + 2, dst); put_word_000 (srca, dst >> 16);
}}}}}}}	m68k_incpci (4);
l_110632: ;
return 24 * CYCLE_UNIT / 2 + count_cycles;
} /* 24 (4/2) */

/* NEG.L (xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_44b9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_110633;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{{uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (srca + 2, dst); put_word_000 (srca, dst >> 16);
}}}}}}}	m68k_incpci (6);
l_110633: ;
return 28 * CYCLE_UNIT / 2 + count_cycles;
} /* 28 (5/2) */

/* MV2SR.B Dn */
uae_u32 REGPARAM2 CPUFUNC(op_44c0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
	MakeSR ();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	m68k_incpci (2);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/0) */

/* MV2SR.B (An) */
uae_u32 REGPARAM2 CPUFUNC(op_44d0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110635;
	}
{{	uae_s16 src = get_word_000 (srca);
	MakeSR ();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	m68k_incpci (2);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}l_110635: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/0) */

/* MV2SR.B (An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_44d8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110636;
	}
{{	uae_s16 src = get_word_000 (srca);
	m68k_areg (regs, srcreg) += 2;
	MakeSR ();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	m68k_incpci (2);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}l_110636: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/0) */

/* MV2SR.B -(An) */
uae_u32 REGPARAM2 CPUFUNC(op_44e0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_110637;
	}
{{	uae_s16 src = get_word_000 (srca);
	m68k_areg (regs, srcreg) = srca;
	MakeSR ();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	m68k_incpci (2);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}l_110637: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/0) */

/* MV2SR.B (d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_44e8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110638;
	}
{{	uae_s16 src = get_word_000 (srca);
	MakeSR ();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	m68k_incpci (4);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}l_110638: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/0) */

/* MV2SR.B (d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_44f0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110639;
	}
{{	uae_s16 src = get_word_000 (srca);
	MakeSR ();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	m68k_incpci (4);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}l_110639: ;
return 22 * CYCLE_UNIT / 2 + count_cycles;
} /* 22 (4/0) */

/* MV2SR.B (xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_44f8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_110640;
	}
{{	uae_s16 src = get_word_000 (srca);
	MakeSR ();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	m68k_incpci (4);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}l_110640: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/0) */

/* MV2SR.B (xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_44f9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_110641;
	}
{{	uae_s16 src = get_word_000 (srca);
	MakeSR ();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	m68k_incpci (6);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}l_110641: ;
return 24 * CYCLE_UNIT / 2 + count_cycles;
} /* 24 (5/0) */

/* MV2SR.B (d16,PC) */
uae_u32 REGPARAM2 CPUFUNC(op_44fa_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110642;
	}
{{	uae_s16 src = get_word_000 (srca);
	MakeSR ();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	m68k_incpci (4);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}l_110642: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/0) */

/* MV2SR.B (d8,PC,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_44fb_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	srca = get_disp_ea_000 (tmppc, get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110643;
	}
{{	uae_s16 src = get_word_000 (srca);
	MakeSR ();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	m68k_incpci (4);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}l_110643: ;
return 22 * CYCLE_UNIT / 2 + count_cycles;
} /* 22 (4/0) */

/* MV2SR.B #<data>.B */
uae_u32 REGPARAM2 CPUFUNC(op_44fc_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uae_s16 src = get_word_000_prefetch (4);
	MakeSR ();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	m68k_incpci (4);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/0) */

/* NOT.B Dn */
uae_u32 REGPARAM2 CPUFUNC(op_4600_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_NFLG (((uae_s8)(dst)) < 0);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((dst) & 0xff);
}}}	m68k_incpci (2);
return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4 (1/0) */

/* NOT.B (An) */
uae_u32 REGPARAM2 CPUFUNC(op_4610_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_000 (srca);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_NFLG (((uae_s8)(dst)) < 0);
	put_byte_000 (srca, dst);
}}}}	m68k_incpci (2);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* NOT.B (An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_4618_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_000 (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_NFLG (((uae_s8)(dst)) < 0);
	put_byte_000 (srca, dst);
}}}}	m68k_incpci (2);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* NOT.B -(An) */
uae_u32 REGPARAM2 CPUFUNC(op_4620_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte_000 (srca);
	m68k_areg (regs, srcreg) = srca;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_NFLG (((uae_s8)(dst)) < 0);
	put_byte_000 (srca, dst);
}}}}	m68k_incpci (2);
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (2/1) */

/* NOT.B (d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_4628_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 src = get_byte_000 (srca);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_NFLG (((uae_s8)(dst)) < 0);
	put_byte_000 (srca, dst);
}}}}	m68k_incpci (4);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* NOT.B (d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_4630_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
{	uae_s8 src = get_byte_000 (srca);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_NFLG (((uae_s8)(dst)) < 0);
	put_byte_000 (srca, dst);
}}}}	m68k_incpci (4);
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/1) */

/* NOT.B (xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_4638_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 src = get_byte_000 (srca);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_NFLG (((uae_s8)(dst)) < 0);
	put_byte_000 (srca, dst);
}}}}	m68k_incpci (4);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* NOT.B (xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_4639_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
{	uae_s8 src = get_byte_000 (srca);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(dst)) == 0);
	SET_NFLG (((uae_s8)(dst)) < 0);
	put_byte_000 (srca, dst);
}}}}	m68k_incpci (6);
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* NOT.W Dn */
uae_u32 REGPARAM2 CPUFUNC(op_4640_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_NFLG (((uae_s16)(dst)) < 0);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | ((dst) & 0xffff);
}}}	m68k_incpci (2);
return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4 (1/0) */

/* NOT.W (An) */
uae_u32 REGPARAM2 CPUFUNC(op_4650_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110654;
	}
{{	uae_s16 src = get_word_000 (srca);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_NFLG (((uae_s16)(dst)) < 0);
	put_word_000 (srca, dst);
}}}}}	m68k_incpci (2);
l_110654: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* NOT.W (An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_4658_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110655;
	}
{{	uae_s16 src = get_word_000 (srca);
	m68k_areg (regs, srcreg) += 2;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_NFLG (((uae_s16)(dst)) < 0);
	put_word_000 (srca, dst);
}}}}}	m68k_incpci (2);
l_110655: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* NOT.W -(An) */
uae_u32 REGPARAM2 CPUFUNC(op_4660_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_110656;
	}
{{	uae_s16 src = get_word_000 (srca);
	m68k_areg (regs, srcreg) = srca;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_NFLG (((uae_s16)(dst)) < 0);
	put_word_000 (srca, dst);
}}}}}	m68k_incpci (2);
l_110656: ;
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (2/1) */

/* NOT.W (d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_4668_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110657;
	}
{{	uae_s16 src = get_word_000 (srca);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_NFLG (((uae_s16)(dst)) < 0);
	put_word_000 (srca, dst);
}}}}}	m68k_incpci (4);
l_110657: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* NOT.W (d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_4670_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110658;
	}
{{	uae_s16 src = get_word_000 (srca);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_NFLG (((uae_s16)(dst)) < 0);
	put_word_000 (srca, dst);
}}}}}	m68k_incpci (4);
l_110658: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/1) */

/* NOT.W (xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_4678_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_110659;
	}
{{	uae_s16 src = get_word_000 (srca);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_NFLG (((uae_s16)(dst)) < 0);
	put_word_000 (srca, dst);
}}}}}	m68k_incpci (4);
l_110659: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* NOT.W (xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_4679_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_110660;
	}
{{	uae_s16 src = get_word_000 (srca);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_NFLG (((uae_s16)(dst)) < 0);
	put_word_000 (srca, dst);
}}}}}	m68k_incpci (6);
l_110660: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* NOT.L Dn */
uae_u32 REGPARAM2 CPUFUNC(op_4680_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_NFLG (((uae_s32)(dst)) < 0);
	m68k_dreg (regs, srcreg) = (dst);
}}}	m68k_incpci (2);
return 6 * CYCLE_UNIT / 2 + count_cycles;
} /* 6 (1/0) */

/* NOT.L (An) */
uae_u32 REGPARAM2 CPUFUNC(op_4690_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110662;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_NFLG (((uae_s32)(dst)) < 0);
	put_word_000 (srca + 2, dst); put_word_000 (srca, dst >> 16);
}}}}}	m68k_incpci (2);
l_110662: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (3/2) */

/* NOT.L (An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_4698_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110663;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
	m68k_areg (regs, srcreg) += 4;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_NFLG (((uae_s32)(dst)) < 0);
	put_word_000 (srca + 2, dst); put_word_000 (srca, dst >> 16);
}}}}}	m68k_incpci (2);
l_110663: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (3/2) */

/* NOT.L -(An) */
uae_u32 REGPARAM2 CPUFUNC(op_46a0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_110664;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
	m68k_areg (regs, srcreg) = srca;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_NFLG (((uae_s32)(dst)) < 0);
	put_word_000 (srca + 2, dst); put_word_000 (srca, dst >> 16);
}}}}}	m68k_incpci (2);
l_110664: ;
return 22 * CYCLE_UNIT / 2 + count_cycles;
} /* 22 (3/2) */

/* NOT.L (d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_46a8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110665;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_NFLG (((uae_s32)(dst)) < 0);
	put_word_000 (srca + 2, dst); put_word_000 (srca, dst >> 16);
}}}}}	m68k_incpci (4);
l_110665: ;
return 24 * CYCLE_UNIT / 2 + count_cycles;
} /* 24 (4/2) */

/* NOT.L (d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_46b0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110666;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_NFLG (((uae_s32)(dst)) < 0);
	put_word_000 (srca + 2, dst); put_word_000 (srca, dst >> 16);
}}}}}	m68k_incpci (4);
l_110666: ;
return 26 * CYCLE_UNIT / 2 + count_cycles;
} /* 26 (4/2) */

/* NOT.L (xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_46b8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_110667;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_NFLG (((uae_s32)(dst)) < 0);
	put_word_000 (srca + 2, dst); put_word_000 (srca, dst >> 16);
}}}}}	m68k_incpci (4);
l_110667: ;
return 24 * CYCLE_UNIT / 2 + count_cycles;
} /* 24 (4/2) */

/* NOT.L (xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_46b9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_110668;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{	uae_u32 dst = ~src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_NFLG (((uae_s32)(dst)) < 0);
	put_word_000 (srca + 2, dst); put_word_000 (srca, dst >> 16);
}}}}}	m68k_incpci (6);
l_110668: ;
return 28 * CYCLE_UNIT / 2 + count_cycles;
} /* 28 (5/2) */

/* MV2SR.W Dn */
uae_u32 REGPARAM2 CPUFUNC(op_46c0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{if (!regs.s) { Exception (8); goto l_110669; }
{{	uae_s16 src = m68k_dreg (regs, srcreg);
	regs.sr = src;
	MakeFromSR();
	m68k_incpci (2);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}l_110669: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/0) */

/* MV2SR.W (An) */
uae_u32 REGPARAM2 CPUFUNC(op_46d0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{if (!regs.s) { Exception (8); goto l_110670; }
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110670;
	}
{{	uae_s16 src = get_word_000 (srca);
	regs.sr = src;
	MakeFromSR();
	m68k_incpci (2);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}l_110670: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/0) */

/* MV2SR.W (An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_46d8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{if (!regs.s) { Exception (8); goto l_110671; }
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110671;
	}
{{	uae_s16 src = get_word_000 (srca);
	m68k_areg (regs, srcreg) += 2;
	regs.sr = src;
	MakeFromSR();
	m68k_incpci (2);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}l_110671: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/0) */

/* MV2SR.W -(An) */
uae_u32 REGPARAM2 CPUFUNC(op_46e0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{if (!regs.s) { Exception (8); goto l_110672; }
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_110672;
	}
{{	uae_s16 src = get_word_000 (srca);
	m68k_areg (regs, srcreg) = srca;
	regs.sr = src;
	MakeFromSR();
	m68k_incpci (2);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}l_110672: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/0) */

/* MV2SR.W (d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_46e8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{if (!regs.s) { Exception (8); goto l_110673; }
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110673;
	}
{{	uae_s16 src = get_word_000 (srca);
	regs.sr = src;
	MakeFromSR();
	m68k_incpci (4);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}l_110673: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/0) */

/* MV2SR.W (d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_46f0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{if (!regs.s) { Exception (8); goto l_110674; }
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110674;
	}
{{	uae_s16 src = get_word_000 (srca);
	regs.sr = src;
	MakeFromSR();
	m68k_incpci (4);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}l_110674: ;
return 22 * CYCLE_UNIT / 2 + count_cycles;
} /* 22 (4/0) */

/* MV2SR.W (xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_46f8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{if (!regs.s) { Exception (8); goto l_110675; }
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_110675;
	}
{{	uae_s16 src = get_word_000 (srca);
	regs.sr = src;
	MakeFromSR();
	m68k_incpci (4);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}l_110675: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/0) */

/* MV2SR.W (xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_46f9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{if (!regs.s) { Exception (8); goto l_110676; }
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_110676;
	}
{{	uae_s16 src = get_word_000 (srca);
	regs.sr = src;
	MakeFromSR();
	m68k_incpci (6);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}l_110676: ;
return 24 * CYCLE_UNIT / 2 + count_cycles;
} /* 24 (5/0) */

/* MV2SR.W (d16,PC) */
uae_u32 REGPARAM2 CPUFUNC(op_46fa_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{if (!regs.s) { Exception (8); goto l_110677; }
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110677;
	}
{{	uae_s16 src = get_word_000 (srca);
	regs.sr = src;
	MakeFromSR();
	m68k_incpci (4);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}l_110677: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/0) */

/* MV2SR.W (d8,PC,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_46fb_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{if (!regs.s) { Exception (8); goto l_110678; }
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	srca = get_disp_ea_000 (tmppc, get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110678;
	}
{{	uae_s16 src = get_word_000 (srca);
	regs.sr = src;
	MakeFromSR();
	m68k_incpci (4);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}l_110678: ;
return 22 * CYCLE_UNIT / 2 + count_cycles;
} /* 22 (4/0) */

/* MV2SR.W #<data>.W */
uae_u32 REGPARAM2 CPUFUNC(op_46fc_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{if (!regs.s) { Exception (8); goto l_110679; }
{{	uae_s16 src = get_word_000_prefetch (4);
	regs.sr = src;
	MakeFromSR();
	m68k_incpci (4);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}l_110679: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/0) */

/* NBCD.B Dn */
uae_u32 REGPARAM2 CPUFUNC(op_4800_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG () ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	if (newv_lo > 9) { newv_lo -= 6; }
	tmp_newv = newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG (cflg);
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	SET_VFLG ((tmp_newv & 0x80) != 0 && (newv & 0x80) == 0);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((newv) & 0xff);
}}}	m68k_incpci (2);
return 6 * CYCLE_UNIT / 2 + count_cycles;
} /* 6 (1/0) */

/* NBCD.B (An) */
uae_u32 REGPARAM2 CPUFUNC(op_4810_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_000 (srca);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG () ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	if (newv_lo > 9) { newv_lo -= 6; }
	tmp_newv = newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG (cflg);
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	SET_VFLG ((tmp_newv & 0x80) != 0 && (newv & 0x80) == 0);
	put_byte_000 (srca, newv);
}}}}	m68k_incpci (2);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* NBCD.B (An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_4818_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_000 (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG () ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	if (newv_lo > 9) { newv_lo -= 6; }
	tmp_newv = newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG (cflg);
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	SET_VFLG ((tmp_newv & 0x80) != 0 && (newv & 0x80) == 0);
	put_byte_000 (srca, newv);
}}}}	m68k_incpci (2);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* NBCD.B -(An) */
uae_u32 REGPARAM2 CPUFUNC(op_4820_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte_000 (srca);
	m68k_areg (regs, srcreg) = srca;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG () ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	if (newv_lo > 9) { newv_lo -= 6; }
	tmp_newv = newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG (cflg);
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	SET_VFLG ((tmp_newv & 0x80) != 0 && (newv & 0x80) == 0);
	put_byte_000 (srca, newv);
}}}}	m68k_incpci (2);
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (2/1) */

/* NBCD.B (d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_4828_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 src = get_byte_000 (srca);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG () ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	if (newv_lo > 9) { newv_lo -= 6; }
	tmp_newv = newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG (cflg);
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	SET_VFLG ((tmp_newv & 0x80) != 0 && (newv & 0x80) == 0);
	put_byte_000 (srca, newv);
}}}}	m68k_incpci (4);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* NBCD.B (d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_4830_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
{	uae_s8 src = get_byte_000 (srca);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG () ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	if (newv_lo > 9) { newv_lo -= 6; }
	tmp_newv = newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG (cflg);
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	SET_VFLG ((tmp_newv & 0x80) != 0 && (newv & 0x80) == 0);
	put_byte_000 (srca, newv);
}}}}	m68k_incpci (4);
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/1) */

/* NBCD.B (xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_4838_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 src = get_byte_000 (srca);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG () ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	if (newv_lo > 9) { newv_lo -= 6; }
	tmp_newv = newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG (cflg);
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	SET_VFLG ((tmp_newv & 0x80) != 0 && (newv & 0x80) == 0);
	put_byte_000 (srca, newv);
}}}}	m68k_incpci (4);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* NBCD.B (xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_4839_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
{	uae_s8 src = get_byte_000 (srca);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG () ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	if (newv_lo > 9) { newv_lo -= 6; }
	tmp_newv = newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG (cflg);
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	SET_VFLG ((tmp_newv & 0x80) != 0 && (newv & 0x80) == 0);
	put_byte_000 (srca, newv);
}}}}	m68k_incpci (6);
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* SWAP.W Dn */
uae_u32 REGPARAM2 CPUFUNC(op_4840_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 dst = ((src >> 16)&0xFFFF) | ((src&0xFFFF)<<16);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_NFLG (((uae_s32)(dst)) < 0);
	m68k_dreg (regs, srcreg) = (dst);
}}}	m68k_incpci (2);
return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4 (1/0) */

/* PEA.L (An) */
uae_u32 REGPARAM2 CPUFUNC(op_4850_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, 7) - 4;
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_write(opcode, dsta);
		goto l_110689;
	}
{	m68k_areg (regs, 7) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	put_word_000 (dsta, srca >> 16); put_word_000 (dsta + 2, srca);
}}}}	m68k_incpci (2);
l_110689: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (1/2) */

/* PEA.L (d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_4868_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, 7) - 4;
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110690;
	}
{	m68k_areg (regs, 7) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	put_word_000 (dsta, srca >> 16); put_word_000 (dsta + 2, srca);
}}}}	m68k_incpci (4);
l_110690: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (2/2) */

/* PEA.L (d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_4870_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
{	uaecptr dsta;
	dsta = m68k_areg (regs, 7) - 4;
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110691;
	}
{	m68k_areg (regs, 7) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	put_word_000 (dsta, srca >> 16); put_word_000 (dsta + 2, srca);
}}}}	m68k_incpci (4);
l_110691: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (2/2) */

/* PEA.L (xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_4878_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, 7) - 4;
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110692;
	}
{	m68k_areg (regs, 7) = dsta;
	put_word_000 (dsta, srca >> 16); put_word_000 (dsta + 2, srca);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
}}}}	m68k_incpci (4);
l_110692: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (2/2) */

/* PEA.L (xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_4879_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
{	uaecptr dsta;
	dsta = m68k_areg (regs, 7) - 4;
	if (dsta & 1) {
	m68k_incpci (8);
		exception3_write(opcode, dsta);
		goto l_110693;
	}
{	m68k_areg (regs, 7) = dsta;
	put_word_000 (dsta, srca >> 16); put_word_000 (dsta + 2, srca);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
}}}}	m68k_incpci (6);
l_110693: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (3/2) */

/* PEA.L (d16,PC) */
uae_u32 REGPARAM2 CPUFUNC(op_487a_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uaecptr dsta;
	dsta = m68k_areg (regs, 7) - 4;
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110694;
	}
{	m68k_areg (regs, 7) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	put_word_000 (dsta, srca >> 16); put_word_000 (dsta + 2, srca);
}}}}	m68k_incpci (4);
l_110694: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (2/2) */

/* PEA.L (d8,PC,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_487b_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	srca = get_disp_ea_000 (tmppc, get_word_000_prefetch (4));
{	uaecptr dsta;
	dsta = m68k_areg (regs, 7) - 4;
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_write(opcode, dsta);
		goto l_110695;
	}
{	m68k_areg (regs, 7) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	put_word_000 (dsta, srca >> 16); put_word_000 (dsta + 2, srca);
}}}}	m68k_incpci (4);
l_110695: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (2/2) */

/* EXT.W Dn */
uae_u32 REGPARAM2 CPUFUNC(op_4880_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u16 dst = (uae_s16)(uae_s8)src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(dst)) == 0);
	SET_NFLG (((uae_s16)(dst)) < 0);
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | ((dst) & 0xffff);
}}}	m68k_incpci (2);
return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4 (1/0) */

/* MVMLE.W #<data>.W,(An) */
uae_u32 REGPARAM2 CPUFUNC(op_4890_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_000_prefetch (4);
{	uaecptr srca;
	srca = m68k_areg (regs, dstreg);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_write(opcode, srca);
		goto l_110697;
	}
{{	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) {
		put_word_000 (srca, m68k_dreg (regs, movem_index1[dmask]));
		srca += 2;
		dmask = movem_next[dmask];
		count_cycles += 4 * CYCLE_UNIT / 2;
	}
	while (amask) {
		put_word_000 (srca, m68k_areg (regs, movem_index1[amask]));
		srca += 2;
		amask = movem_next[amask];
		count_cycles += 4 * CYCLE_UNIT / 2;
	}
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
}}}}	m68k_incpci (4);
l_110697: ;
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8+ (2/0) */

/* MVMLE.W #<data>.W,-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_48a0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_000_prefetch (4);
{	uaecptr srca;
	srca = m68k_areg (regs, dstreg) - 0;
	if (srca & 1) {
	m68k_incpci (6);
		exception3_write(opcode, srca);
		goto l_110698;
	}
{{	uae_u16 amask = mask & 0xff, dmask = (mask >> 8) & 0xff;
	while (amask) {
		srca -= 2;
		put_word_000 (srca, m68k_areg (regs, movem_index2[amask]));
	amask = movem_next[amask];
		count_cycles += 4 * CYCLE_UNIT / 2;
	}
	while (dmask) {
		srca -= 2;
		put_word_000 (srca, m68k_dreg (regs, movem_index2[dmask]));
		dmask = movem_next[dmask];
		count_cycles += 4 * CYCLE_UNIT / 2;
	}
	m68k_areg (regs, dstreg) = srca;
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
}}}}	m68k_incpci (4);
l_110698: ;
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8+ (2/0) */

/* MVMLE.W #<data>.W,(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_48a8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_000_prefetch (4);
{	uaecptr srca;
	srca = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_write(opcode, srca);
		goto l_110699;
	}
{{	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) {
		put_word_000 (srca, m68k_dreg (regs, movem_index1[dmask]));
		srca += 2;
		dmask = movem_next[dmask];
		count_cycles += 4 * CYCLE_UNIT / 2;
	}
	while (amask) {
		put_word_000 (srca, m68k_areg (regs, movem_index1[amask]));
		srca += 2;
		amask = movem_next[amask];
		count_cycles += 4 * CYCLE_UNIT / 2;
	}
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
}}}}	m68k_incpci (6);
l_110699: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12+ (3/0) */

/* MVMLE.W #<data>.W,(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_48b0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_000_prefetch (4);
{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (6));
	if (srca & 1) {
	m68k_incpci (6);
		exception3_write(opcode, srca);
		goto l_110700;
	}
{{	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) {
		put_word_000 (srca, m68k_dreg (regs, movem_index1[dmask]));
		srca += 2;
		dmask = movem_next[dmask];
		count_cycles += 4 * CYCLE_UNIT / 2;
	}
	while (amask) {
		put_word_000 (srca, m68k_areg (regs, movem_index1[amask]));
		srca += 2;
		amask = movem_next[amask];
		count_cycles += 4 * CYCLE_UNIT / 2;
	}
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
}}}}	m68k_incpci (6);
l_110700: ;
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14+ (3/0) */

/* MVMLE.W #<data>.W,(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_48b8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{	uae_u16 mask = get_word_000_prefetch (4);
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_write(opcode, srca);
		goto l_110701;
	}
{{	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) {
		put_word_000 (srca, m68k_dreg (regs, movem_index1[dmask]));
		srca += 2;
		dmask = movem_next[dmask];
		count_cycles += 4 * CYCLE_UNIT / 2;
	}
	while (amask) {
		put_word_000 (srca, m68k_areg (regs, movem_index1[amask]));
		srca += 2;
		amask = movem_next[amask];
		count_cycles += 4 * CYCLE_UNIT / 2;
	}
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
}}}}	m68k_incpci (6);
l_110701: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12+ (3/0) */

/* MVMLE.W #<data>.W,(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_48b9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{	uae_u16 mask = get_word_000_prefetch (4);
{	uaecptr srca;
	srca = get_word_000_prefetch (6) << 16;
	srca |= get_word_000_prefetch (8);
	if (srca & 1) {
	m68k_incpci (8);
		exception3_write(opcode, srca);
		goto l_110702;
	}
{{	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) {
		put_word_000 (srca, m68k_dreg (regs, movem_index1[dmask]));
		srca += 2;
		dmask = movem_next[dmask];
		count_cycles += 4 * CYCLE_UNIT / 2;
	}
	while (amask) {
		put_word_000 (srca, m68k_areg (regs, movem_index1[amask]));
		srca += 2;
		amask = movem_next[amask];
		count_cycles += 4 * CYCLE_UNIT / 2;
	}
	regs.ir = regs.irc;
	get_word_000_prefetch (10);
}}}}	m68k_incpci (8);
l_110702: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16+ (4/0) */

/* EXT.L Dn */
uae_u32 REGPARAM2 CPUFUNC(op_48c0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 dst = (uae_s32)(uae_s16)src;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(dst)) == 0);
	SET_NFLG (((uae_s32)(dst)) < 0);
	m68k_dreg (regs, srcreg) = (dst);
}}}	m68k_incpci (2);
return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4 (1/0) */

/* MVMLE.L #<data>.W,(An) */
uae_u32 REGPARAM2 CPUFUNC(op_48d0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_000_prefetch (4);
{	uaecptr srca;
	srca = m68k_areg (regs, dstreg);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_write(opcode, srca);
		goto l_110704;
	}
{{	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) {
		put_word_000 (srca, m68k_dreg (regs, movem_index1[dmask]) >> 16);
		put_word_000 (srca + 2, m68k_dreg (regs, movem_index1[dmask]));
		srca += 4;
		dmask = movem_next[dmask];
		count_cycles += 8 * CYCLE_UNIT / 2;
	}
	while (amask) {
		put_word_000 (srca, m68k_areg (regs, movem_index1[amask]) >> 16);
		put_word_000 (srca + 2, m68k_areg (regs, movem_index1[amask]));
		srca += 4;
		amask = movem_next[amask];
		count_cycles += 8 * CYCLE_UNIT / 2;
	}
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
}}}}	m68k_incpci (4);
l_110704: ;
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8+ (2/0) */

/* MVMLE.L #<data>.W,-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_48e0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_000_prefetch (4);
{	uaecptr srca;
	srca = m68k_areg (regs, dstreg) - 0;
	if (srca & 1) {
	m68k_incpci (6);
		exception3_write(opcode, srca);
		goto l_110705;
	}
{{	uae_u16 amask = mask & 0xff, dmask = (mask >> 8) & 0xff;
	while (amask) {
		srca -= 4;
		put_word_000 (srca, m68k_areg (regs, movem_index2[amask]) >> 16);
		put_word_000 (srca + 2, m68k_areg (regs, movem_index2[amask]));
		amask = movem_next[amask];
		count_cycles += 8 * CYCLE_UNIT / 2;
	}
	while (dmask) {
		srca -= 4;
		put_word_000 (srca, m68k_dreg (regs, movem_index2[dmask]) >> 16);
		put_word_000 (srca + 2, m68k_dreg (regs, movem_index2[dmask]));
		dmask = movem_next[dmask];
		count_cycles += 8 * CYCLE_UNIT / 2;
	}
	m68k_areg (regs, dstreg) = srca;
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
}}}}	m68k_incpci (4);
l_110705: ;
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8+ (2/0) */

/* MVMLE.L #<data>.W,(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_48e8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_000_prefetch (4);
{	uaecptr srca;
	srca = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_write(opcode, srca);
		goto l_110706;
	}
{{	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) {
		put_word_000 (srca, m68k_dreg (regs, movem_index1[dmask]) >> 16);
		put_word_000 (srca + 2, m68k_dreg (regs, movem_index1[dmask]));
		srca += 4;
		dmask = movem_next[dmask];
		count_cycles += 8 * CYCLE_UNIT / 2;
	}
	while (amask) {
		put_word_000 (srca, m68k_areg (regs, movem_index1[amask]) >> 16);
		put_word_000 (srca + 2, m68k_areg (regs, movem_index1[amask]));
		srca += 4;
		amask = movem_next[amask];
		count_cycles += 8 * CYCLE_UNIT / 2;
	}
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
}}}}	m68k_incpci (6);
l_110706: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12+ (3/0) */

/* MVMLE.L #<data>.W,(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_48f0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_000_prefetch (4);
{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (6));
	if (srca & 1) {
	m68k_incpci (6);
		exception3_write(opcode, srca);
		goto l_110707;
	}
{{	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) {
		put_word_000 (srca, m68k_dreg (regs, movem_index1[dmask]) >> 16);
		put_word_000 (srca + 2, m68k_dreg (regs, movem_index1[dmask]));
		srca += 4;
		dmask = movem_next[dmask];
		count_cycles += 8 * CYCLE_UNIT / 2;
	}
	while (amask) {
		put_word_000 (srca, m68k_areg (regs, movem_index1[amask]) >> 16);
		put_word_000 (srca + 2, m68k_areg (regs, movem_index1[amask]));
		srca += 4;
		amask = movem_next[amask];
		count_cycles += 8 * CYCLE_UNIT / 2;
	}
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
}}}}	m68k_incpci (6);
l_110707: ;
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14+ (3/0) */

/* MVMLE.L #<data>.W,(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_48f8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{	uae_u16 mask = get_word_000_prefetch (4);
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_write(opcode, srca);
		goto l_110708;
	}
{{	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) {
		put_word_000 (srca, m68k_dreg (regs, movem_index1[dmask]) >> 16);
		put_word_000 (srca + 2, m68k_dreg (regs, movem_index1[dmask]));
		srca += 4;
		dmask = movem_next[dmask];
		count_cycles += 8 * CYCLE_UNIT / 2;
	}
	while (amask) {
		put_word_000 (srca, m68k_areg (regs, movem_index1[amask]) >> 16);
		put_word_000 (srca + 2, m68k_areg (regs, movem_index1[amask]));
		srca += 4;
		amask = movem_next[amask];
		count_cycles += 8 * CYCLE_UNIT / 2;
	}
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
}}}}	m68k_incpci (6);
l_110708: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12+ (3/0) */

/* MVMLE.L #<data>.W,(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_48f9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{	uae_u16 mask = get_word_000_prefetch (4);
{	uaecptr srca;
	srca = get_word_000_prefetch (6) << 16;
	srca |= get_word_000_prefetch (8);
	if (srca & 1) {
	m68k_incpci (8);
		exception3_write(opcode, srca);
		goto l_110709;
	}
{{	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) {
		put_word_000 (srca, m68k_dreg (regs, movem_index1[dmask]) >> 16);
		put_word_000 (srca + 2, m68k_dreg (regs, movem_index1[dmask]));
		srca += 4;
		dmask = movem_next[dmask];
		count_cycles += 8 * CYCLE_UNIT / 2;
	}
	while (amask) {
		put_word_000 (srca, m68k_areg (regs, movem_index1[amask]) >> 16);
		put_word_000 (srca + 2, m68k_areg (regs, movem_index1[amask]));
		srca += 4;
		amask = movem_next[amask];
		count_cycles += 8 * CYCLE_UNIT / 2;
	}
	regs.ir = regs.irc;
	get_word_000_prefetch (10);
}}}}	m68k_incpci (8);
l_110709: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16+ (4/0) */

/* TST.B Dn */
uae_u32 REGPARAM2 CPUFUNC(op_4a00_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
}}	m68k_incpci (2);
return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4 (1/0) */

/* TST.B (An) */
uae_u32 REGPARAM2 CPUFUNC(op_4a10_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_000 (srca);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
}}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (2/0) */

/* TST.B (An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_4a18_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_000 (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
}}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (2/0) */

/* TST.B -(An) */
uae_u32 REGPARAM2 CPUFUNC(op_4a20_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte_000 (srca);
	m68k_areg (regs, srcreg) = srca;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
}}}	m68k_incpci (2);
return 10 * CYCLE_UNIT / 2 + count_cycles;
} /* 10 (2/0) */

/* TST.B (d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_4a28_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 src = get_byte_000 (srca);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
}}}	m68k_incpci (4);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (3/0) */

/* TST.B (d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_4a30_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
{	uae_s8 src = get_byte_000 (srca);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
}}}	m68k_incpci (4);
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (3/0) */

/* TST.B (xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_4a38_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 src = get_byte_000 (srca);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
}}}	m68k_incpci (4);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (3/0) */

/* TST.B (xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_4a39_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
{	uae_s8 src = get_byte_000 (srca);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
}}}	m68k_incpci (6);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (4/0) */

/* TST.W Dn */
uae_u32 REGPARAM2 CPUFUNC(op_4a40_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
}}	m68k_incpci (2);
return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4 (1/0) */

/* TST.W (An) */
uae_u32 REGPARAM2 CPUFUNC(op_4a50_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110719;
	}
{{	uae_s16 src = get_word_000 (srca);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
}}}}	m68k_incpci (2);
l_110719: ;
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (2/0) */

/* TST.W (An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_4a58_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110720;
	}
{{	uae_s16 src = get_word_000 (srca);
	m68k_areg (regs, srcreg) += 2;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
}}}}	m68k_incpci (2);
l_110720: ;
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (2/0) */

/* TST.W -(An) */
uae_u32 REGPARAM2 CPUFUNC(op_4a60_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_110721;
	}
{{	uae_s16 src = get_word_000 (srca);
	m68k_areg (regs, srcreg) = srca;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
}}}}	m68k_incpci (2);
l_110721: ;
return 10 * CYCLE_UNIT / 2 + count_cycles;
} /* 10 (2/0) */

/* TST.W (d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_4a68_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110722;
	}
{{	uae_s16 src = get_word_000 (srca);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
}}}}	m68k_incpci (4);
l_110722: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (3/0) */

/* TST.W (d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_4a70_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110723;
	}
{{	uae_s16 src = get_word_000 (srca);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
}}}}	m68k_incpci (4);
l_110723: ;
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (3/0) */

/* TST.W (xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_4a78_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_110724;
	}
{{	uae_s16 src = get_word_000 (srca);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
}}}}	m68k_incpci (4);
l_110724: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (3/0) */

/* TST.W (xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_4a79_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_110725;
	}
{{	uae_s16 src = get_word_000 (srca);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
}}}}	m68k_incpci (6);
l_110725: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (4/0) */

/* TST.L Dn */
uae_u32 REGPARAM2 CPUFUNC(op_4a80_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
}}	m68k_incpci (2);
return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4 (1/0) */

/* TST.L (An) */
uae_u32 REGPARAM2 CPUFUNC(op_4a90_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110727;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
}}}}	m68k_incpci (2);
l_110727: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (3/0) */

/* TST.L (An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_4a98_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110728;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
	m68k_areg (regs, srcreg) += 4;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
}}}}	m68k_incpci (2);
l_110728: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (3/0) */

/* TST.L -(An) */
uae_u32 REGPARAM2 CPUFUNC(op_4aa0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_110729;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
	m68k_areg (regs, srcreg) = srca;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
}}}}	m68k_incpci (2);
l_110729: ;
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (3/0) */

/* TST.L (d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_4aa8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110730;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
}}}}	m68k_incpci (4);
l_110730: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (4/0) */

/* TST.L (d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_4ab0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_110731;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
}}}}	m68k_incpci (4);
l_110731: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (4/0) */

/* TST.L (xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_4ab8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_110732;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
}}}}	m68k_incpci (4);
l_110732: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (4/0) */

/* TST.L (xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_4ab9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_110733;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
}}}}	m68k_incpci (6);
l_110733: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (5/0) */

/* TAS.B Dn */
uae_u32 REGPARAM2 CPUFUNC(op_4ac0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	src |= 0x80;
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((src) & 0xff);
}}	m68k_incpci (2);
return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4 (1/0) */

/* TAS.B (An) */
uae_u32 REGPARAM2 CPUFUNC(op_4ad0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_000 (srca);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	src |= 0x80;
	put_byte_000 (srca, src);
}}}	m68k_incpci (2);
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (2/1) */

/* TAS.B (An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_4ad8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_000 (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	src |= 0x80;
	put_byte_000 (srca, src);
}}}	m68k_incpci (2);
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (2/1) */

/* TAS.B -(An) */
uae_u32 REGPARAM2 CPUFUNC(op_4ae0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte_000 (srca);
	m68k_areg (regs, srcreg) = srca;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	src |= 0x80;
	put_byte_000 (srca, src);
}}}	m68k_incpci (2);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (2/1) */

/* TAS.B (d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_4ae8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 src = get_byte_000 (srca);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	src |= 0x80;
	put_byte_000 (srca, src);
}}}	m68k_incpci (4);
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/1) */

/* TAS.B (d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_4af0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
{	uae_s8 src = get_byte_000 (srca);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	src |= 0x80;
	put_byte_000 (srca, src);
}}}	m68k_incpci (4);
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (3/1) */

/* TAS.B (xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_4af8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 src = get_byte_000 (srca);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	src |= 0x80;
	put_byte_000 (srca, src);
}}}	m68k_incpci (4);
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/1) */

/* TAS.B (xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_4af9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
{	uae_s8 src = get_byte_000 (srca);
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	src |= 0x80;
	put_byte_000 (srca, src);
}}}	m68k_incpci (6);
return 22 * CYCLE_UNIT / 2 + count_cycles;
} /* 22 (4/1) */

/* MVMEL.W #<data>.W,(An) */
uae_u32 REGPARAM2 CPUFUNC(op_4c90_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_000_prefetch (4);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uae_u32 v;
{	uaecptr srca;
	srca = m68k_areg (regs, dstreg);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_write(opcode, srca);
		goto l_110742;
	}
{{	while (dmask) {
		m68k_dreg (regs, movem_index1[dmask]) = (uae_s32)(uae_s16)get_word_000 (srca);
		srca += 2;
		dmask = movem_next[dmask];
		count_cycles += 4 * CYCLE_UNIT / 2;
	}
	while (amask) {
		m68k_areg (regs, movem_index1[amask]) = (uae_s32)(uae_s16)get_word_000 (srca);
		srca += 2;
		amask = movem_next[amask];
		count_cycles += 4 * CYCLE_UNIT / 2;
	}
	get_word_000 (srca);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
}}}}	m68k_incpci (4);
l_110742: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12+ (3/0) */

/* MVMEL.W #<data>.W,(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_4c98_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_000_prefetch (4);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uae_u32 v;
{	uaecptr srca;
	srca = m68k_areg (regs, dstreg);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_write(opcode, srca);
		goto l_110743;
	}
{{	while (dmask) {
		m68k_dreg (regs, movem_index1[dmask]) = (uae_s32)(uae_s16)get_word_000 (srca);
		srca += 2;
		dmask = movem_next[dmask];
		count_cycles += 4 * CYCLE_UNIT / 2;
	}
	while (amask) {
		m68k_areg (regs, movem_index1[amask]) = (uae_s32)(uae_s16)get_word_000 (srca);
		srca += 2;
		amask = movem_next[amask];
		count_cycles += 4 * CYCLE_UNIT / 2;
	}
	get_word_000 (srca);
	m68k_areg (regs, dstreg) = srca;
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
}}}}	m68k_incpci (4);
l_110743: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12+ (3/0) */

/* MVMEL.W #<data>.W,(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_4ca8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_000_prefetch (4);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uae_u32 v;
{	uaecptr srca;
	srca = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_write(opcode, srca);
		goto l_110744;
	}
{{	while (dmask) {
		m68k_dreg (regs, movem_index1[dmask]) = (uae_s32)(uae_s16)get_word_000 (srca);
		srca += 2;
		dmask = movem_next[dmask];
		count_cycles += 4 * CYCLE_UNIT / 2;
	}
	while (amask) {
		m68k_areg (regs, movem_index1[amask]) = (uae_s32)(uae_s16)get_word_000 (srca);
		srca += 2;
		amask = movem_next[amask];
		count_cycles += 4 * CYCLE_UNIT / 2;
	}
	get_word_000 (srca);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
}}}}	m68k_incpci (6);
l_110744: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16+ (4/0) */

/* MVMEL.W #<data>.W,(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_4cb0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_000_prefetch (4);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uae_u32 v;
{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (6));
	if (srca & 1) {
	m68k_incpci (6);
		exception3_write(opcode, srca);
		goto l_110745;
	}
{{	while (dmask) {
		m68k_dreg (regs, movem_index1[dmask]) = (uae_s32)(uae_s16)get_word_000 (srca);
		srca += 2;
		dmask = movem_next[dmask];
		count_cycles += 4 * CYCLE_UNIT / 2;
	}
	while (amask) {
		m68k_areg (regs, movem_index1[amask]) = (uae_s32)(uae_s16)get_word_000 (srca);
		srca += 2;
		amask = movem_next[amask];
		count_cycles += 4 * CYCLE_UNIT / 2;
	}
	get_word_000 (srca);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
}}}}	m68k_incpci (6);
l_110745: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18+ (4/0) */

/* MVMEL.W #<data>.W,(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_4cb8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{	uae_u16 mask = get_word_000_prefetch (4);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uae_u32 v;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_write(opcode, srca);
		goto l_110746;
	}
{{	while (dmask) {
		m68k_dreg (regs, movem_index1[dmask]) = (uae_s32)(uae_s16)get_word_000 (srca);
		srca += 2;
		dmask = movem_next[dmask];
		count_cycles += 4 * CYCLE_UNIT / 2;
	}
	while (amask) {
		m68k_areg (regs, movem_index1[amask]) = (uae_s32)(uae_s16)get_word_000 (srca);
		srca += 2;
		amask = movem_next[amask];
		count_cycles += 4 * CYCLE_UNIT / 2;
	}
	get_word_000 (srca);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
}}}}	m68k_incpci (6);
l_110746: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16+ (4/0) */

/* MVMEL.W #<data>.W,(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_4cb9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{	uae_u16 mask = get_word_000_prefetch (4);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uae_u32 v;
{	uaecptr srca;
	srca = get_word_000_prefetch (6) << 16;
	srca |= get_word_000_prefetch (8);
	if (srca & 1) {
	m68k_incpci (8);
		exception3_write(opcode, srca);
		goto l_110747;
	}
{{	while (dmask) {
		m68k_dreg (regs, movem_index1[dmask]) = (uae_s32)(uae_s16)get_word_000 (srca);
		srca += 2;
		dmask = movem_next[dmask];
		count_cycles += 4 * CYCLE_UNIT / 2;
	}
	while (amask) {
		m68k_areg (regs, movem_index1[amask]) = (uae_s32)(uae_s16)get_word_000 (srca);
		srca += 2;
		amask = movem_next[amask];
		count_cycles += 4 * CYCLE_UNIT / 2;
	}
	get_word_000 (srca);
	regs.ir = regs.irc;
	get_word_000_prefetch (10);
}}}}	m68k_incpci (8);
l_110747: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20+ (5/0) */

/* MVMEL.W #<data>.W,(d16,PC) */
uae_u32 REGPARAM2 CPUFUNC(op_4cba_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 2;
{	uae_u16 mask = get_word_000_prefetch (4);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uae_u32 v;
{	uaecptr srca;
	srca = m68k_getpci () + 4;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_write(opcode, srca);
		goto l_110748;
	}
{{	while (dmask) {
		m68k_dreg (regs, movem_index1[dmask]) = (uae_s32)(uae_s16)get_word_000 (srca);
		srca += 2;
		dmask = movem_next[dmask];
		count_cycles += 4 * CYCLE_UNIT / 2;
	}
	while (amask) {
		m68k_areg (regs, movem_index1[amask]) = (uae_s32)(uae_s16)get_word_000 (srca);
		srca += 2;
		amask = movem_next[amask];
		count_cycles += 4 * CYCLE_UNIT / 2;
	}
	get_word_000 (srca);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
}}}}	m68k_incpci (6);
l_110748: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16+ (4/0) */

/* MVMEL.W #<data>.W,(d8,PC,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_4cbb_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 3;
{	uae_u16 mask = get_word_000_prefetch (4);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uae_u32 v;
{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 4;
	srca = get_disp_ea_000 (tmppc, get_word_000_prefetch (6));
	if (srca & 1) {
	m68k_incpci (6);
		exception3_write(opcode, srca);
		goto l_110749;
	}
{{	while (dmask) {
		m68k_dreg (regs, movem_index1[dmask]) = (uae_s32)(uae_s16)get_word_000 (srca);
		srca += 2;
		dmask = movem_next[dmask];
		count_cycles += 4 * CYCLE_UNIT / 2;
	}
	while (amask) {
		m68k_areg (regs, movem_index1[amask]) = (uae_s32)(uae_s16)get_word_000 (srca);
		srca += 2;
		amask = movem_next[amask];
		count_cycles += 4 * CYCLE_UNIT / 2;
	}
	get_word_000 (srca);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
}}}}	m68k_incpci (6);
l_110749: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18+ (4/0) */

/* MVMEL.L #<data>.W,(An) */
uae_u32 REGPARAM2 CPUFUNC(op_4cd0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_000_prefetch (4);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uae_u32 v;
{	uaecptr srca;
	srca = m68k_areg (regs, dstreg);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_write(opcode, srca);
		goto l_110750;
	}
{{	while (dmask) {
		v = get_word_000 (srca) << 16;
		v |= get_word_000 (srca + 2);
		m68k_dreg (regs, movem_index1[dmask]) = v;
		srca += 4;
		dmask = movem_next[dmask];
		count_cycles += 8 * CYCLE_UNIT / 2;
	}
	while (amask) {
		v = get_word_000 (srca) << 16;
		v |= get_word_000 (srca + 2);
		m68k_areg (regs, movem_index1[amask]) = v;
		srca += 4;
		amask = movem_next[amask];
		count_cycles += 8 * CYCLE_UNIT / 2;
	}
	get_word_000 (srca);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
}}}}	m68k_incpci (4);
l_110750: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12+ (3/0) */

/* MVMEL.L #<data>.W,(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_4cd8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_000_prefetch (4);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uae_u32 v;
{	uaecptr srca;
	srca = m68k_areg (regs, dstreg);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_write(opcode, srca);
		goto l_110751;
	}
{{	while (dmask) {
		v = get_word_000 (srca) << 16;
		v |= get_word_000 (srca + 2);
		m68k_dreg (regs, movem_index1[dmask]) = v;
		srca += 4;
		dmask = movem_next[dmask];
		count_cycles += 8 * CYCLE_UNIT / 2;
	}
	while (amask) {
		v = get_word_000 (srca) << 16;
		v |= get_word_000 (srca + 2);
		m68k_areg (regs, movem_index1[amask]) = v;
		srca += 4;
		amask = movem_next[amask];
		count_cycles += 8 * CYCLE_UNIT / 2;
	}
	get_word_000 (srca);
	m68k_areg (regs, dstreg) = srca;
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
}}}}	m68k_incpci (4);
l_110751: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12+ (3/0) */

/* MVMEL.L #<data>.W,(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_4ce8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_000_prefetch (4);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uae_u32 v;
{	uaecptr srca;
	srca = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_write(opcode, srca);
		goto l_110752;
	}
{{	while (dmask) {
		v = get_word_000 (srca) << 16;
		v |= get_word_000 (srca + 2);
		m68k_dreg (regs, movem_index1[dmask]) = v;
		srca += 4;
		dmask = movem_next[dmask];
		count_cycles += 8 * CYCLE_UNIT / 2;
	}
	while (amask) {
		v = get_word_000 (srca) << 16;
		v |= get_word_000 (srca + 2);
		m68k_areg (regs, movem_index1[amask]) = v;
		srca += 4;
		amask = movem_next[amask];
		count_cycles += 8 * CYCLE_UNIT / 2;
	}
	get_word_000 (srca);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
}}}}	m68k_incpci (6);
l_110752: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16+ (4/0) */

/* MVMEL.L #<data>.W,(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_4cf0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = opcode & 7;
{	uae_u16 mask = get_word_000_prefetch (4);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uae_u32 v;
{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (6));
	if (srca & 1) {
	m68k_incpci (6);
		exception3_write(opcode, srca);
		goto l_110753;
	}
{{	while (dmask) {
		v = get_word_000 (srca) << 16;
		v |= get_word_000 (srca + 2);
		m68k_dreg (regs, movem_index1[dmask]) = v;
		srca += 4;
		dmask = movem_next[dmask];
		count_cycles += 8 * CYCLE_UNIT / 2;
	}
	while (amask) {
		v = get_word_000 (srca) << 16;
		v |= get_word_000 (srca + 2);
		m68k_areg (regs, movem_index1[amask]) = v;
		srca += 4;
		amask = movem_next[amask];
		count_cycles += 8 * CYCLE_UNIT / 2;
	}
	get_word_000 (srca);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
}}}}	m68k_incpci (6);
l_110753: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18+ (4/0) */

/* MVMEL.L #<data>.W,(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_4cf8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{	uae_u16 mask = get_word_000_prefetch (4);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uae_u32 v;
{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_write(opcode, srca);
		goto l_110754;
	}
{{	while (dmask) {
		v = get_word_000 (srca) << 16;
		v |= get_word_000 (srca + 2);
		m68k_dreg (regs, movem_index1[dmask]) = v;
		srca += 4;
		dmask = movem_next[dmask];
		count_cycles += 8 * CYCLE_UNIT / 2;
	}
	while (amask) {
		v = get_word_000 (srca) << 16;
		v |= get_word_000 (srca + 2);
		m68k_areg (regs, movem_index1[amask]) = v;
		srca += 4;
		amask = movem_next[amask];
		count_cycles += 8 * CYCLE_UNIT / 2;
	}
	get_word_000 (srca);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
}}}}	m68k_incpci (6);
l_110754: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16+ (4/0) */

/* MVMEL.L #<data>.W,(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_4cf9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{	uae_u16 mask = get_word_000_prefetch (4);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uae_u32 v;
{	uaecptr srca;
	srca = get_word_000_prefetch (6) << 16;
	srca |= get_word_000_prefetch (8);
	if (srca & 1) {
	m68k_incpci (8);
		exception3_write(opcode, srca);
		goto l_110755;
	}
{{	while (dmask) {
		v = get_word_000 (srca) << 16;
		v |= get_word_000 (srca + 2);
		m68k_dreg (regs, movem_index1[dmask]) = v;
		srca += 4;
		dmask = movem_next[dmask];
		count_cycles += 8 * CYCLE_UNIT / 2;
	}
	while (amask) {
		v = get_word_000 (srca) << 16;
		v |= get_word_000 (srca + 2);
		m68k_areg (regs, movem_index1[amask]) = v;
		srca += 4;
		amask = movem_next[amask];
		count_cycles += 8 * CYCLE_UNIT / 2;
	}
	get_word_000 (srca);
	regs.ir = regs.irc;
	get_word_000_prefetch (10);
}}}}	m68k_incpci (8);
l_110755: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20+ (5/0) */

/* MVMEL.L #<data>.W,(d16,PC) */
uae_u32 REGPARAM2 CPUFUNC(op_4cfa_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 2;
{	uae_u16 mask = get_word_000_prefetch (4);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uae_u32 v;
{	uaecptr srca;
	srca = m68k_getpci () + 4;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_write(opcode, srca);
		goto l_110756;
	}
{{	while (dmask) {
		v = get_word_000 (srca) << 16;
		v |= get_word_000 (srca + 2);
		m68k_dreg (regs, movem_index1[dmask]) = v;
		srca += 4;
		dmask = movem_next[dmask];
		count_cycles += 8 * CYCLE_UNIT / 2;
	}
	while (amask) {
		v = get_word_000 (srca) << 16;
		v |= get_word_000 (srca + 2);
		m68k_areg (regs, movem_index1[amask]) = v;
		srca += 4;
		amask = movem_next[amask];
		count_cycles += 8 * CYCLE_UNIT / 2;
	}
	get_word_000 (srca);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
}}}}	m68k_incpci (6);
l_110756: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16+ (4/0) */

/* MVMEL.L #<data>.W,(d8,PC,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_4cfb_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 3;
{	uae_u16 mask = get_word_000_prefetch (4);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uae_u32 v;
{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 4;
	srca = get_disp_ea_000 (tmppc, get_word_000_prefetch (6));
	if (srca & 1) {
	m68k_incpci (6);
		exception3_write(opcode, srca);
		goto l_110757;
	}
{{	while (dmask) {
		v = get_word_000 (srca) << 16;
		v |= get_word_000 (srca + 2);
		m68k_dreg (regs, movem_index1[dmask]) = v;
		srca += 4;
		dmask = movem_next[dmask];
		count_cycles += 8 * CYCLE_UNIT / 2;
	}
	while (amask) {
		v = get_word_000 (srca) << 16;
		v |= get_word_000 (srca + 2);
		m68k_areg (regs, movem_index1[amask]) = v;
		srca += 4;
		amask = movem_next[amask];
		count_cycles += 8 * CYCLE_UNIT / 2;
	}
	get_word_000 (srca);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
}}}}	m68k_incpci (6);
l_110757: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18+ (4/0) */

/* TRAPQ.L #<data> */
uae_u32 REGPARAM2 CPUFUNC(op_4e40_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 15);
{{	uae_u32 src = srcreg;
	m68k_incpci (2);
	Exception (src + 32);
}}return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4 (0/0) */

/* LINK.W An,#<data>.W */
uae_u32 REGPARAM2 CPUFUNC(op_4e50_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr olda;
	olda = m68k_areg (regs, 7) - 4;
	if (olda & 1) {
	m68k_incpci (4);
		exception3_write(opcode, olda);
		goto l_110759;
	}
{	m68k_areg (regs, 7) = olda;
{	uae_s32 src = m68k_areg (regs, srcreg);
{	uae_s16 offs = get_word_000_prefetch (4);
	put_word_000 (olda, src >> 16); put_word_000 (olda + 2, src);
	m68k_areg (regs, srcreg) = (m68k_areg (regs, 7));
	m68k_areg (regs, 7) += offs;
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
}}}}}	m68k_incpci (4);
l_110759: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (2/2) */

/* UNLK.L An */
uae_u32 REGPARAM2 CPUFUNC(op_4e58_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uae_s32 src = m68k_areg (regs, srcreg);
	m68k_areg (regs, 7) = src;
{	uaecptr olda;
	olda = m68k_areg (regs, 7);
	if (olda & 1) {
	m68k_incpci (2);
		exception3_read(opcode, olda);
		goto l_110760;
	}
{{	uae_s32 old = get_word_000 (olda) << 16; old |= get_word_000 (olda + 2);
	m68k_areg (regs, 7) += 4;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	m68k_areg (regs, srcreg) = (old);
}}}}}	m68k_incpci (2);
l_110760: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (3/0) */

/* MVR2USP.L An */
uae_u32 REGPARAM2 CPUFUNC(op_4e60_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{if (!regs.s) { Exception (8); goto l_110761; }
{{	uae_s32 src = m68k_areg (regs, srcreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	regs.usp = src;
}}}	m68k_incpci (2);
l_110761: ;
return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4 (1/0) */

/* MVUSP2R.L An */
uae_u32 REGPARAM2 CPUFUNC(op_4e68_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{if (!regs.s) { Exception (8); goto l_110762; }
{{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	m68k_areg (regs, srcreg) = (regs.usp);
}}}	m68k_incpci (2);
l_110762: ;
return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4 (1/0) */

/* RESET.L  */
uae_u32 REGPARAM2 CPUFUNC(op_4e70_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{if (!regs.s) { Exception (8); goto l_110763; }
{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	cpureset ();
	m68k_incpci (2);
	get_word_000_prefetch (2);
}}l_110763: ;
return 132 * CYCLE_UNIT / 2 + count_cycles;
} /* 132 (1/0) */

/* NOP.L  */
uae_u32 REGPARAM2 CPUFUNC(op_4e71_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
}	m68k_incpci (2);
return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4 (1/0) */

/* STOP.L #<data>.W */
uae_u32 REGPARAM2 CPUFUNC(op_4e72_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{if (!regs.s) { Exception (8); goto l_110765; }
{	regs.sr = regs.irc;
	MakeFromSR();
	m68k_setstopped ();
	m68k_incpci (4);
}}l_110765: ;
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (0/0) */

/* RTE.L  */
uae_u32 REGPARAM2 CPUFUNC(op_4e73_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{if (!regs.s) { Exception (8); goto l_110766; }
{	uae_u16 newsr; uae_u32 newpc;
	for (;;) {
		uaecptr a = m68k_areg (regs, 7);
		uae_u16 sr = get_word_000 (a);
		uae_u32 pc = get_word_000 (a + 2) << 16; pc |= get_word_000 (a + 4);
		uae_u16 format = get_word_000 (a + 2 + 4);
		int frame = format >> 12;
		int offset = 8;
		newsr = sr; newpc = pc;
		if (frame == 0x0) { m68k_areg (regs, 7) += offset; break; }
		else if (frame == 0x8) { m68k_areg (regs, 7) += offset + 50; break; }
		else { m68k_areg (regs, 7) += offset; Exception (14); goto l_110766; }
		regs.sr = newsr; MakeFromSR ();
}
	regs.sr = newsr;
	MakeFromSR();
	if (newpc & 1) {
		exception3i (0x4E73, newpc);
		goto l_110766;
	}
	m68k_setpci (newpc);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}l_110766: ;
return 24 * CYCLE_UNIT / 2 + count_cycles;
} /* 24 (6/0) */

/* RTD.L #<data>.W */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 CPUFUNC(op_4e74_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr pca;
	pca = m68k_areg (regs, 7);
	if (pca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, pca);
		goto l_110767;
	}
{{	uae_s32 pc = get_word_000 (pca) << 16; pc |= get_word_000 (pca + 2);
	m68k_areg (regs, 7) += 4;
{	uae_s16 offs = get_word_000_prefetch (4);
	m68k_areg (regs, 7) += offs;
	if (pc & 1) {
		exception3i (0x4E74, pc);
		goto l_110767;
	}
	m68k_setpci (pc);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}l_110767: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (5/0) */

#endif
/* RTS.L  */
uae_u32 REGPARAM2 CPUFUNC(op_4e75_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{	uaecptr pc = m68k_getpci ();
	m68k_do_rtsi ();
	if (m68k_getpci () & 1) {
		uaecptr faultpc = m68k_getpci ();
	m68k_setpci (pc);
		exception3i (0x4E75, faultpc);
		goto l_110768;
	}
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}l_110768: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (4/0) */

/* TRAPV.L  */
uae_u32 REGPARAM2 CPUFUNC(op_4e76_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
	if (GET_VFLG ()) {
		Exception (7);
		goto l_110769;
	}
}l_110769: ;
return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4 (1/0) */

/* RTR.L  */
uae_u32 REGPARAM2 CPUFUNC(op_4e77_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{	uaecptr oldpc = m68k_getpci ();
	MakeSR ();
{	uaecptr sra;
	sra = m68k_areg (regs, 7);
	if (sra & 1) {
	m68k_incpci (2);
		exception3_read(opcode, sra);
		goto l_110770;
	}
{{	uae_s16 sr = get_word_000 (sra);
	m68k_areg (regs, 7) += 2;
{	uaecptr pca;
	pca = m68k_areg (regs, 7);
	if (pca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, pca);
		goto l_110770;
	}
{{	uae_s32 pc = get_word_000 (pca) << 16; pc |= get_word_000 (pca + 2);
	m68k_areg (regs, 7) += 4;
	regs.sr &= 0xFF00; sr &= 0xFF;
	regs.sr |= sr;
	m68k_setpci (pc);
	MakeFromSR();
	if (m68k_getpci () & 1) {
		uaecptr faultpc = m68k_getpci ();
	m68k_setpci (oldpc);
		exception3i (0x4E77, faultpc);
		goto l_110770;
	}
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}}}}}l_110770: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (5/0) */

/* MOVEC2.L #<data>.W */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 CPUFUNC(op_4e7a_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{if (!regs.s) { Exception (8); goto l_110771; }
{{	uae_s16 src = get_word_000_prefetch (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	int regno = (src >> 12) & 15;
	uae_u32 *regp = regs.regs + regno;
	if (! m68k_movec2(src & 0xFFF, regp)) goto l_110771;
}}}}	m68k_incpci (4);
l_110771: ;
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (2/0) */

#endif
/* MOVE2C.L #<data>.W */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 CPUFUNC(op_4e7b_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{if (!regs.s) { Exception (8); goto l_110772; }
{{	uae_s16 src = get_word_000_prefetch (4);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	int regno = (src >> 12) & 15;
	uae_u32 *regp = regs.regs + regno;
	if (! m68k_move2c(src & 0xFFF, regp)) goto l_110772;
}}}}	m68k_incpci (4);
l_110772: ;
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (2/0) */

#endif
/* JSR.L (An) */
uae_u32 REGPARAM2 CPUFUNC(op_4e90_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uaecptr oldpc = m68k_getpci () + 2;
	if (srca & 1) {
		exception3i (opcode, srca);
		goto l_110773;
	}
	m68k_setpci (srca);
	get_word_000_prefetch (0);
	m68k_areg (regs, 7) -= 4;
	put_word_000 (m68k_areg (regs, 7), oldpc >> 16);
	put_word_000 (m68k_areg (regs, 7) + 2, oldpc);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}l_110773: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (2/2) */

/* JSR.L (d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_4ea8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)regs.irc;
{	uaecptr oldpc = m68k_getpci () + 4;
	if (srca & 1) {
		exception3i (opcode, srca);
		goto l_110774;
	}
	m68k_setpci (srca);
	get_word_000_prefetch (0);
	m68k_areg (regs, 7) -= 4;
	put_word_000 (m68k_areg (regs, 7), oldpc >> 16);
	put_word_000 (m68k_areg (regs, 7) + 2, oldpc);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}l_110774: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (2/2) */

/* JSR.L (d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_4eb0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), regs.irc);
{	uaecptr oldpc = m68k_getpci () + 2;
	if (srca & 1) {
		exception3i (opcode, srca);
		goto l_110775;
	}
	oldpc += 2;
	m68k_setpci (srca);
	get_word_000_prefetch (0);
	m68k_areg (regs, 7) -= 4;
	put_word_000 (m68k_areg (regs, 7), oldpc >> 16);
	put_word_000 (m68k_areg (regs, 7) + 2, oldpc);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}l_110775: ;
return 22 * CYCLE_UNIT / 2 + count_cycles;
} /* 22 (2/2) */

/* JSR.L (xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_4eb8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)regs.irc;
{	uaecptr oldpc = m68k_getpci () + 4;
	if (srca & 1) {
		exception3i (opcode, srca);
		goto l_110776;
	}
	m68k_setpci (srca);
	get_word_000_prefetch (0);
	m68k_areg (regs, 7) -= 4;
	put_word_000 (m68k_areg (regs, 7), oldpc >> 16);
	put_word_000 (m68k_areg (regs, 7) + 2, oldpc);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}l_110776: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (2/2) */

/* JSR.L (xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_4eb9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= regs.irc;
{	uaecptr oldpc = m68k_getpci () + 6;
	if (srca & 1) {
		exception3i (opcode, srca);
		goto l_110777;
	}
	m68k_setpci (srca);
	get_word_000_prefetch (0);
	m68k_areg (regs, 7) -= 4;
	put_word_000 (m68k_areg (regs, 7), oldpc >> 16);
	put_word_000 (m68k_areg (regs, 7) + 2, oldpc);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}l_110777: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (3/2) */

/* JSR.L (d16,PC) */
uae_u32 REGPARAM2 CPUFUNC(op_4eba_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)regs.irc;
{	uaecptr oldpc = m68k_getpci () + 4;
	if (srca & 1) {
		exception3i (opcode, srca);
		goto l_110778;
	}
	m68k_setpci (srca);
	get_word_000_prefetch (0);
	m68k_areg (regs, 7) -= 4;
	put_word_000 (m68k_areg (regs, 7), oldpc >> 16);
	put_word_000 (m68k_areg (regs, 7) + 2, oldpc);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}l_110778: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (2/2) */

/* JSR.L (d8,PC,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_4ebb_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	srca = get_disp_ea_000 (tmppc, regs.irc);
{	uaecptr oldpc = m68k_getpci () + 2;
	if (srca & 1) {
		exception3i (opcode, srca);
		goto l_110779;
	}
	oldpc += 2;
	m68k_setpci (srca);
	get_word_000_prefetch (0);
	m68k_areg (regs, 7) -= 4;
	put_word_000 (m68k_areg (regs, 7), oldpc >> 16);
	put_word_000 (m68k_areg (regs, 7) + 2, oldpc);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}l_110779: ;
return 22 * CYCLE_UNIT / 2 + count_cycles;
} /* 22 (2/2) */

/* JMP.L (An) */
uae_u32 REGPARAM2 CPUFUNC(op_4ed0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
		exception3i (opcode, srca);
		goto l_110780;
	}
	m68k_setpci (srca);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}l_110780: ;
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (2/0) */

/* JMP.L (d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_4ee8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)regs.irc;
	if (srca & 1) {
		exception3i (opcode, srca);
		goto l_110781;
	}
	m68k_setpci (srca);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}l_110781: ;
return 10 * CYCLE_UNIT / 2 + count_cycles;
} /* 10 (2/0) */

/* JMP.L (d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_4ef0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), regs.irc);
	if (srca & 1) {
		exception3i (opcode, srca);
		goto l_110782;
	}
	m68k_setpci (srca);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}l_110782: ;
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (2/0) */

/* JMP.L (xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_4ef8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)regs.irc;
	if (srca & 1) {
		exception3i (opcode, srca);
		goto l_110783;
	}
	m68k_setpci (srca);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}l_110783: ;
return 10 * CYCLE_UNIT / 2 + count_cycles;
} /* 10 (2/0) */

/* JMP.L (xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_4ef9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= regs.irc;
	if (srca & 1) {
		exception3i (opcode, srca);
		goto l_110784;
	}
	m68k_setpci (srca);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}l_110784: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (3/0) */

/* JMP.L (d16,PC) */
uae_u32 REGPARAM2 CPUFUNC(op_4efa_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)regs.irc;
	if (srca & 1) {
		exception3i (opcode, srca);
		goto l_110785;
	}
	m68k_setpci (srca);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}l_110785: ;
return 10 * CYCLE_UNIT / 2 + count_cycles;
} /* 10 (2/0) */

/* JMP.L (d8,PC,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_4efb_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	srca = get_disp_ea_000 (tmppc, regs.irc);
	if (srca & 1) {
		exception3i (opcode, srca);
		goto l_110786;
	}
	m68k_setpci (srca);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}l_110786: ;
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (2/0) */

/* ADDQ.B #<data>,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_5000_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}	m68k_incpci (2);
return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4 (1/0) */

/* ADDQ.B #<data>,(An) */
uae_u32 REGPARAM2 CPUFUNC(op_5010_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_byte_000 (dsta, newv);
}}}}}}}	m68k_incpci (2);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* ADDQ.B #<data>,(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_5018_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_000 (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_byte_000 (dsta, newv);
}}}}}}}	m68k_incpci (2);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* ADDQ.B #<data>,-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_5020_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte_000 (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_byte_000 (dsta, newv);
}}}}}}}	m68k_incpci (2);
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (2/1) */

/* ADDQ.B #<data>,(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_5028_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_byte_000 (dsta, newv);
}}}}}}}	m68k_incpci (4);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* ADDQ.B #<data>,(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_5030_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (4));
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_byte_000 (dsta, newv);
}}}}}}}	m68k_incpci (4);
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/1) */

/* ADDQ.B #<data>,(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_5038_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_byte_000 (dsta, newv);
}}}}}}}	m68k_incpci (4);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* ADDQ.B #<data>,(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_5039_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = get_word_000_prefetch (4) << 16;
	dsta |= get_word_000_prefetch (6);
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_byte_000 (dsta, newv);
}}}}}}}	m68k_incpci (6);
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* ADDQ.W #<data>,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_5040_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}	m68k_incpci (2);
return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4 (1/0) */

/* ADDAQ.W #<data>,An */
uae_u32 REGPARAM2 CPUFUNC(op_5048_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/0) */

/* ADDQ.W #<data>,(An) */
uae_u32 REGPARAM2 CPUFUNC(op_5050_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_110797;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta, newv);
}}}}}}}}	m68k_incpci (2);
l_110797: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* ADDQ.W #<data>,(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_5058_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_110798;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	m68k_areg (regs, dstreg) += 2;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta, newv);
}}}}}}}}	m68k_incpci (2);
l_110798: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* ADDQ.W #<data>,-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_5060_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_110799;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta, newv);
}}}}}}}}	m68k_incpci (2);
l_110799: ;
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (2/1) */

/* ADDQ.W #<data>,(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_5068_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_110800;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta, newv);
}}}}}}}}	m68k_incpci (4);
l_110800: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* ADDQ.W #<data>,(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_5070_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (4));
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_110801;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta, newv);
}}}}}}}}	m68k_incpci (4);
l_110801: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/1) */

/* ADDQ.W #<data>,(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_5078_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_110802;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta, newv);
}}}}}}}}	m68k_incpci (4);
l_110802: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* ADDQ.W #<data>,(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_5079_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = get_word_000_prefetch (4) << 16;
	dsta |= get_word_000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_read(opcode, dsta);
		goto l_110803;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta, newv);
}}}}}}}}	m68k_incpci (6);
l_110803: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* ADDQ.L #<data>,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_5080_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/0) */

/* ADDAQ.L #<data>,An */
uae_u32 REGPARAM2 CPUFUNC(op_5088_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/0) */

/* ADDQ.L #<data>,(An) */
uae_u32 REGPARAM2 CPUFUNC(op_5090_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_110806;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta + 2, newv); put_word_000 (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (2);
l_110806: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (3/2) */

/* ADDQ.L #<data>,(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_5098_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_110807;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	m68k_areg (regs, dstreg) += 4;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta + 2, newv); put_word_000 (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (2);
l_110807: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (3/2) */

/* ADDQ.L #<data>,-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_50a0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_110808;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta + 2, newv); put_word_000 (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (2);
l_110808: ;
return 22 * CYCLE_UNIT / 2 + count_cycles;
} /* 22 (3/2) */

#endif

#ifdef PART_5
/* ADDQ.L #<data>,(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_50a8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_110809;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta + 2, newv); put_word_000 (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (4);
l_110809: ;
return 24 * CYCLE_UNIT / 2 + count_cycles;
} /* 24 (4/2) */

/* ADDQ.L #<data>,(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_50b0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (4));
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_110810;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta + 2, newv); put_word_000 (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (4);
l_110810: ;
return 26 * CYCLE_UNIT / 2 + count_cycles;
} /* 26 (4/2) */

/* ADDQ.L #<data>,(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_50b8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_110811;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta + 2, newv); put_word_000 (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (4);
l_110811: ;
return 24 * CYCLE_UNIT / 2 + count_cycles;
} /* 24 (4/2) */

/* ADDQ.L #<data>,(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_50b9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = get_word_000_prefetch (4) << 16;
	dsta |= get_word_000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_read(opcode, dsta);
		goto l_110812;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta + 2, newv); put_word_000 (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (6);
l_110812: ;
return 28 * CYCLE_UNIT / 2 + count_cycles;
} /* 28 (5/2) */

/* Scc.B Dn (T) */
uae_u32 REGPARAM2 CPUFUNC(op_50c0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	int val = cctrue (0) ? 0xff : 0;
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4+ (1/0) */

/* DBcc.W Dn,#<data>.W (T) */
uae_u32 REGPARAM2 CPUFUNC(op_50c8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = regs.irc;
	uaecptr oldpc = m68k_getpci ();
	if (!cctrue (0)) {
	m68k_incpci ((uae_s32)offs + 2);
		get_word_000_prefetch (0);
		m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpci () + 2 + (uae_s32)offs + 2);
				goto l_110814;
			}
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
			return 10 * CYCLE_UNIT / 2 + count_cycles;
		}
		count_cycles += 4 * CYCLE_UNIT / 2;
	} else {
		count_cycles += 2 * CYCLE_UNIT / 2;
	}
	m68k_setpci (oldpc + 4);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}l_110814: ;
return 10 * CYCLE_UNIT / 2 + count_cycles;
} /* 10 (2/0) */

/* Scc.B (An) (T) */
uae_u32 REGPARAM2 CPUFUNC(op_50d0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	int val = cctrue (0) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/1) */

/* Scc.B (An)+ (T) */
uae_u32 REGPARAM2 CPUFUNC(op_50d8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	int val = cctrue (0) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/1) */

/* Scc.B -(An) (T) */
uae_u32 REGPARAM2 CPUFUNC(op_50e0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	int val = cctrue (0) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (2);
return 10 * CYCLE_UNIT / 2 + count_cycles;
} /* 10 (1/1) */

/* Scc.B (d16,An) (T) */
uae_u32 REGPARAM2 CPUFUNC(op_50e8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	int val = cctrue (0) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (4);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* Scc.B (d8,An,Xn) (T) */
uae_u32 REGPARAM2 CPUFUNC(op_50f0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
{	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	int val = cctrue (0) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (4);
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (2/1) */

/* Scc.B (xxx).W (T) */
uae_u32 REGPARAM2 CPUFUNC(op_50f8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	int val = cctrue (0) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (4);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* Scc.B (xxx).L (T) */
uae_u32 REGPARAM2 CPUFUNC(op_50f9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
{	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{	int val = cctrue (0) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (6);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* SUBQ.B #<data>,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_5100_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}	m68k_incpci (2);
return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4 (1/0) */

/* SUBQ.B #<data>,(An) */
uae_u32 REGPARAM2 CPUFUNC(op_5110_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_byte_000 (dsta, newv);
}}}}}}}	m68k_incpci (2);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* SUBQ.B #<data>,(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_5118_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_000 (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_byte_000 (dsta, newv);
}}}}}}}	m68k_incpci (2);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* SUBQ.B #<data>,-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_5120_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte_000 (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_byte_000 (dsta, newv);
}}}}}}}	m68k_incpci (2);
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (2/1) */

/* SUBQ.B #<data>,(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_5128_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_byte_000 (dsta, newv);
}}}}}}}	m68k_incpci (4);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* SUBQ.B #<data>,(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_5130_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (4));
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_byte_000 (dsta, newv);
}}}}}}}	m68k_incpci (4);
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/1) */

/* SUBQ.B #<data>,(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_5138_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_byte_000 (dsta, newv);
}}}}}}}	m68k_incpci (4);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* SUBQ.B #<data>,(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_5139_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = get_word_000_prefetch (4) << 16;
	dsta |= get_word_000_prefetch (6);
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_byte_000 (dsta, newv);
}}}}}}}	m68k_incpci (6);
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* SUBQ.W #<data>,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_5140_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}	m68k_incpci (2);
return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4 (1/0) */

/* SUBAQ.W #<data>,An */
uae_u32 REGPARAM2 CPUFUNC(op_5148_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/0) */

/* SUBQ.W #<data>,(An) */
uae_u32 REGPARAM2 CPUFUNC(op_5150_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_110832;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta, newv);
}}}}}}}}	m68k_incpci (2);
l_110832: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* SUBQ.W #<data>,(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_5158_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_110833;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	m68k_areg (regs, dstreg) += 2;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta, newv);
}}}}}}}}	m68k_incpci (2);
l_110833: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* SUBQ.W #<data>,-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_5160_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_110834;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta, newv);
}}}}}}}}	m68k_incpci (2);
l_110834: ;
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (2/1) */

/* SUBQ.W #<data>,(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_5168_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_110835;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta, newv);
}}}}}}}}	m68k_incpci (4);
l_110835: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* SUBQ.W #<data>,(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_5170_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (4));
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_110836;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta, newv);
}}}}}}}}	m68k_incpci (4);
l_110836: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/1) */

/* SUBQ.W #<data>,(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_5178_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_110837;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta, newv);
}}}}}}}}	m68k_incpci (4);
l_110837: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* SUBQ.W #<data>,(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_5179_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = get_word_000_prefetch (4) << 16;
	dsta |= get_word_000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_read(opcode, dsta);
		goto l_110838;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta, newv);
}}}}}}}}	m68k_incpci (6);
l_110838: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* SUBQ.L #<data>,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_5180_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/0) */

/* SUBAQ.L #<data>,An */
uae_u32 REGPARAM2 CPUFUNC(op_5188_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/0) */

/* SUBQ.L #<data>,(An) */
uae_u32 REGPARAM2 CPUFUNC(op_5190_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_110841;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta + 2, newv); put_word_000 (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (2);
l_110841: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (3/2) */

/* SUBQ.L #<data>,(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_5198_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_110842;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	m68k_areg (regs, dstreg) += 4;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta + 2, newv); put_word_000 (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (2);
l_110842: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (3/2) */

/* SUBQ.L #<data>,-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_51a0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_110843;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta + 2, newv); put_word_000 (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (2);
l_110843: ;
return 22 * CYCLE_UNIT / 2 + count_cycles;
} /* 22 (3/2) */

/* SUBQ.L #<data>,(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_51a8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_110844;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta + 2, newv); put_word_000 (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (4);
l_110844: ;
return 24 * CYCLE_UNIT / 2 + count_cycles;
} /* 24 (4/2) */

/* SUBQ.L #<data>,(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_51b0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (4));
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_110845;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta + 2, newv); put_word_000 (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (4);
l_110845: ;
return 26 * CYCLE_UNIT / 2 + count_cycles;
} /* 26 (4/2) */

/* SUBQ.L #<data>,(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_51b8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_110846;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta + 2, newv); put_word_000 (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (4);
l_110846: ;
return 24 * CYCLE_UNIT / 2 + count_cycles;
} /* 24 (4/2) */

/* SUBQ.L #<data>,(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_51b9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
{{	uae_u32 src = srcreg;
{	uaecptr dsta;
	dsta = get_word_000_prefetch (4) << 16;
	dsta |= get_word_000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_read(opcode, dsta);
		goto l_110847;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta + 2, newv); put_word_000 (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (6);
l_110847: ;
return 28 * CYCLE_UNIT / 2 + count_cycles;
} /* 28 (5/2) */

/* Scc.B Dn (F) */
uae_u32 REGPARAM2 CPUFUNC(op_51c0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	int val = cctrue (1) ? 0xff : 0;
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4+ (1/0) */

/* DBcc.W Dn,#<data>.W (F) */
uae_u32 REGPARAM2 CPUFUNC(op_51c8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = regs.irc;
	uaecptr oldpc = m68k_getpci ();
	if (!cctrue (1)) {
	m68k_incpci ((uae_s32)offs + 2);
		get_word_000_prefetch (0);
		m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpci () + 2 + (uae_s32)offs + 2);
				goto l_110849;
			}
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
			return 10 * CYCLE_UNIT / 2 + count_cycles;
		}
		count_cycles += 4 * CYCLE_UNIT / 2;
	} else {
		count_cycles += 2 * CYCLE_UNIT / 2;
	}
	m68k_setpci (oldpc + 4);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}l_110849: ;
return 10 * CYCLE_UNIT / 2 + count_cycles;
} /* 10 (2/0) */

/* Scc.B (An) (F) */
uae_u32 REGPARAM2 CPUFUNC(op_51d0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	int val = cctrue (1) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/1) */

/* Scc.B (An)+ (F) */
uae_u32 REGPARAM2 CPUFUNC(op_51d8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	int val = cctrue (1) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/1) */

/* Scc.B -(An) (F) */
uae_u32 REGPARAM2 CPUFUNC(op_51e0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	int val = cctrue (1) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (2);
return 10 * CYCLE_UNIT / 2 + count_cycles;
} /* 10 (1/1) */

/* Scc.B (d16,An) (F) */
uae_u32 REGPARAM2 CPUFUNC(op_51e8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	int val = cctrue (1) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (4);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* Scc.B (d8,An,Xn) (F) */
uae_u32 REGPARAM2 CPUFUNC(op_51f0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
{	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	int val = cctrue (1) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (4);
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (2/1) */

/* Scc.B (xxx).W (F) */
uae_u32 REGPARAM2 CPUFUNC(op_51f8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	int val = cctrue (1) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (4);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* Scc.B (xxx).L (F) */
uae_u32 REGPARAM2 CPUFUNC(op_51f9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
{	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{	int val = cctrue (1) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (6);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* Scc.B Dn (HI) */
uae_u32 REGPARAM2 CPUFUNC(op_52c0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	int val = cctrue (2) ? 0xff : 0;
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4+ (1/0) */

/* DBcc.W Dn,#<data>.W (HI) */
uae_u32 REGPARAM2 CPUFUNC(op_52c8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = regs.irc;
	uaecptr oldpc = m68k_getpci ();
	if (!cctrue (2)) {
	m68k_incpci ((uae_s32)offs + 2);
		get_word_000_prefetch (0);
		m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpci () + 2 + (uae_s32)offs + 2);
				goto l_110858;
			}
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
			return 10 * CYCLE_UNIT / 2 + count_cycles;
		}
		count_cycles += 4 * CYCLE_UNIT / 2;
	} else {
		count_cycles += 2 * CYCLE_UNIT / 2;
	}
	m68k_setpci (oldpc + 4);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}l_110858: ;
return 10 * CYCLE_UNIT / 2 + count_cycles;
} /* 10 (2/0) */

/* Scc.B (An) (HI) */
uae_u32 REGPARAM2 CPUFUNC(op_52d0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	int val = cctrue (2) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/1) */

/* Scc.B (An)+ (HI) */
uae_u32 REGPARAM2 CPUFUNC(op_52d8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	int val = cctrue (2) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/1) */

/* Scc.B -(An) (HI) */
uae_u32 REGPARAM2 CPUFUNC(op_52e0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	int val = cctrue (2) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (2);
return 10 * CYCLE_UNIT / 2 + count_cycles;
} /* 10 (1/1) */

/* Scc.B (d16,An) (HI) */
uae_u32 REGPARAM2 CPUFUNC(op_52e8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	int val = cctrue (2) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (4);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* Scc.B (d8,An,Xn) (HI) */
uae_u32 REGPARAM2 CPUFUNC(op_52f0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
{	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	int val = cctrue (2) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (4);
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (2/1) */

/* Scc.B (xxx).W (HI) */
uae_u32 REGPARAM2 CPUFUNC(op_52f8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	int val = cctrue (2) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (4);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* Scc.B (xxx).L (HI) */
uae_u32 REGPARAM2 CPUFUNC(op_52f9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
{	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{	int val = cctrue (2) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (6);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* Scc.B Dn (LS) */
uae_u32 REGPARAM2 CPUFUNC(op_53c0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	int val = cctrue (3) ? 0xff : 0;
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4+ (1/0) */

/* DBcc.W Dn,#<data>.W (LS) */
uae_u32 REGPARAM2 CPUFUNC(op_53c8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = regs.irc;
	uaecptr oldpc = m68k_getpci ();
	if (!cctrue (3)) {
	m68k_incpci ((uae_s32)offs + 2);
		get_word_000_prefetch (0);
		m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpci () + 2 + (uae_s32)offs + 2);
				goto l_110867;
			}
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
			return 10 * CYCLE_UNIT / 2 + count_cycles;
		}
		count_cycles += 4 * CYCLE_UNIT / 2;
	} else {
		count_cycles += 2 * CYCLE_UNIT / 2;
	}
	m68k_setpci (oldpc + 4);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}l_110867: ;
return 10 * CYCLE_UNIT / 2 + count_cycles;
} /* 10 (2/0) */

/* Scc.B (An) (LS) */
uae_u32 REGPARAM2 CPUFUNC(op_53d0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	int val = cctrue (3) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/1) */

/* Scc.B (An)+ (LS) */
uae_u32 REGPARAM2 CPUFUNC(op_53d8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	int val = cctrue (3) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/1) */

/* Scc.B -(An) (LS) */
uae_u32 REGPARAM2 CPUFUNC(op_53e0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	int val = cctrue (3) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (2);
return 10 * CYCLE_UNIT / 2 + count_cycles;
} /* 10 (1/1) */

/* Scc.B (d16,An) (LS) */
uae_u32 REGPARAM2 CPUFUNC(op_53e8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	int val = cctrue (3) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (4);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* Scc.B (d8,An,Xn) (LS) */
uae_u32 REGPARAM2 CPUFUNC(op_53f0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
{	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	int val = cctrue (3) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (4);
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (2/1) */

/* Scc.B (xxx).W (LS) */
uae_u32 REGPARAM2 CPUFUNC(op_53f8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	int val = cctrue (3) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (4);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* Scc.B (xxx).L (LS) */
uae_u32 REGPARAM2 CPUFUNC(op_53f9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
{	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{	int val = cctrue (3) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (6);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* Scc.B Dn (CC) */
uae_u32 REGPARAM2 CPUFUNC(op_54c0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	int val = cctrue (4) ? 0xff : 0;
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4+ (1/0) */

/* DBcc.W Dn,#<data>.W (CC) */
uae_u32 REGPARAM2 CPUFUNC(op_54c8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = regs.irc;
	uaecptr oldpc = m68k_getpci ();
	if (!cctrue (4)) {
	m68k_incpci ((uae_s32)offs + 2);
		get_word_000_prefetch (0);
		m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpci () + 2 + (uae_s32)offs + 2);
				goto l_110876;
			}
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
			return 10 * CYCLE_UNIT / 2 + count_cycles;
		}
		count_cycles += 4 * CYCLE_UNIT / 2;
	} else {
		count_cycles += 2 * CYCLE_UNIT / 2;
	}
	m68k_setpci (oldpc + 4);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}l_110876: ;
return 10 * CYCLE_UNIT / 2 + count_cycles;
} /* 10 (2/0) */

/* Scc.B (An) (CC) */
uae_u32 REGPARAM2 CPUFUNC(op_54d0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	int val = cctrue (4) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/1) */

/* Scc.B (An)+ (CC) */
uae_u32 REGPARAM2 CPUFUNC(op_54d8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	int val = cctrue (4) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/1) */

/* Scc.B -(An) (CC) */
uae_u32 REGPARAM2 CPUFUNC(op_54e0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	int val = cctrue (4) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (2);
return 10 * CYCLE_UNIT / 2 + count_cycles;
} /* 10 (1/1) */

/* Scc.B (d16,An) (CC) */
uae_u32 REGPARAM2 CPUFUNC(op_54e8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	int val = cctrue (4) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (4);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* Scc.B (d8,An,Xn) (CC) */
uae_u32 REGPARAM2 CPUFUNC(op_54f0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
{	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	int val = cctrue (4) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (4);
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (2/1) */

/* Scc.B (xxx).W (CC) */
uae_u32 REGPARAM2 CPUFUNC(op_54f8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	int val = cctrue (4) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (4);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* Scc.B (xxx).L (CC) */
uae_u32 REGPARAM2 CPUFUNC(op_54f9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
{	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{	int val = cctrue (4) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (6);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* Scc.B Dn (CS) */
uae_u32 REGPARAM2 CPUFUNC(op_55c0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	int val = cctrue (5) ? 0xff : 0;
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4+ (1/0) */

/* DBcc.W Dn,#<data>.W (CS) */
uae_u32 REGPARAM2 CPUFUNC(op_55c8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = regs.irc;
	uaecptr oldpc = m68k_getpci ();
	if (!cctrue (5)) {
	m68k_incpci ((uae_s32)offs + 2);
		get_word_000_prefetch (0);
		m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpci () + 2 + (uae_s32)offs + 2);
				goto l_110885;
			}
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
			return 10 * CYCLE_UNIT / 2 + count_cycles;
		}
		count_cycles += 4 * CYCLE_UNIT / 2;
	} else {
		count_cycles += 2 * CYCLE_UNIT / 2;
	}
	m68k_setpci (oldpc + 4);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}l_110885: ;
return 10 * CYCLE_UNIT / 2 + count_cycles;
} /* 10 (2/0) */

/* Scc.B (An) (CS) */
uae_u32 REGPARAM2 CPUFUNC(op_55d0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	int val = cctrue (5) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/1) */

/* Scc.B (An)+ (CS) */
uae_u32 REGPARAM2 CPUFUNC(op_55d8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	int val = cctrue (5) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/1) */

/* Scc.B -(An) (CS) */
uae_u32 REGPARAM2 CPUFUNC(op_55e0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	int val = cctrue (5) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (2);
return 10 * CYCLE_UNIT / 2 + count_cycles;
} /* 10 (1/1) */

/* Scc.B (d16,An) (CS) */
uae_u32 REGPARAM2 CPUFUNC(op_55e8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	int val = cctrue (5) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (4);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* Scc.B (d8,An,Xn) (CS) */
uae_u32 REGPARAM2 CPUFUNC(op_55f0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
{	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	int val = cctrue (5) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (4);
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (2/1) */

/* Scc.B (xxx).W (CS) */
uae_u32 REGPARAM2 CPUFUNC(op_55f8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	int val = cctrue (5) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (4);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* Scc.B (xxx).L (CS) */
uae_u32 REGPARAM2 CPUFUNC(op_55f9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
{	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{	int val = cctrue (5) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (6);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* Scc.B Dn (NE) */
uae_u32 REGPARAM2 CPUFUNC(op_56c0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	int val = cctrue (6) ? 0xff : 0;
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4+ (1/0) */

/* DBcc.W Dn,#<data>.W (NE) */
uae_u32 REGPARAM2 CPUFUNC(op_56c8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = regs.irc;
	uaecptr oldpc = m68k_getpci ();
	if (!cctrue (6)) {
	m68k_incpci ((uae_s32)offs + 2);
		get_word_000_prefetch (0);
		m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpci () + 2 + (uae_s32)offs + 2);
				goto l_110894;
			}
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
			return 10 * CYCLE_UNIT / 2 + count_cycles;
		}
		count_cycles += 4 * CYCLE_UNIT / 2;
	} else {
		count_cycles += 2 * CYCLE_UNIT / 2;
	}
	m68k_setpci (oldpc + 4);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}l_110894: ;
return 10 * CYCLE_UNIT / 2 + count_cycles;
} /* 10 (2/0) */

/* Scc.B (An) (NE) */
uae_u32 REGPARAM2 CPUFUNC(op_56d0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	int val = cctrue (6) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/1) */

/* Scc.B (An)+ (NE) */
uae_u32 REGPARAM2 CPUFUNC(op_56d8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	int val = cctrue (6) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/1) */

/* Scc.B -(An) (NE) */
uae_u32 REGPARAM2 CPUFUNC(op_56e0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	int val = cctrue (6) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (2);
return 10 * CYCLE_UNIT / 2 + count_cycles;
} /* 10 (1/1) */

/* Scc.B (d16,An) (NE) */
uae_u32 REGPARAM2 CPUFUNC(op_56e8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	int val = cctrue (6) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (4);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* Scc.B (d8,An,Xn) (NE) */
uae_u32 REGPARAM2 CPUFUNC(op_56f0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
{	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	int val = cctrue (6) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (4);
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (2/1) */

/* Scc.B (xxx).W (NE) */
uae_u32 REGPARAM2 CPUFUNC(op_56f8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	int val = cctrue (6) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (4);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* Scc.B (xxx).L (NE) */
uae_u32 REGPARAM2 CPUFUNC(op_56f9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
{	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{	int val = cctrue (6) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (6);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* Scc.B Dn (EQ) */
uae_u32 REGPARAM2 CPUFUNC(op_57c0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	int val = cctrue (7) ? 0xff : 0;
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4+ (1/0) */

/* DBcc.W Dn,#<data>.W (EQ) */
uae_u32 REGPARAM2 CPUFUNC(op_57c8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = regs.irc;
	uaecptr oldpc = m68k_getpci ();
	if (!cctrue (7)) {
	m68k_incpci ((uae_s32)offs + 2);
		get_word_000_prefetch (0);
		m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpci () + 2 + (uae_s32)offs + 2);
				goto l_110903;
			}
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
			return 10 * CYCLE_UNIT / 2 + count_cycles;
		}
		count_cycles += 4 * CYCLE_UNIT / 2;
	} else {
		count_cycles += 2 * CYCLE_UNIT / 2;
	}
	m68k_setpci (oldpc + 4);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}l_110903: ;
return 10 * CYCLE_UNIT / 2 + count_cycles;
} /* 10 (2/0) */

/* Scc.B (An) (EQ) */
uae_u32 REGPARAM2 CPUFUNC(op_57d0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	int val = cctrue (7) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/1) */

/* Scc.B (An)+ (EQ) */
uae_u32 REGPARAM2 CPUFUNC(op_57d8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	int val = cctrue (7) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/1) */

/* Scc.B -(An) (EQ) */
uae_u32 REGPARAM2 CPUFUNC(op_57e0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	int val = cctrue (7) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (2);
return 10 * CYCLE_UNIT / 2 + count_cycles;
} /* 10 (1/1) */

/* Scc.B (d16,An) (EQ) */
uae_u32 REGPARAM2 CPUFUNC(op_57e8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	int val = cctrue (7) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (4);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* Scc.B (d8,An,Xn) (EQ) */
uae_u32 REGPARAM2 CPUFUNC(op_57f0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
{	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	int val = cctrue (7) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (4);
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (2/1) */

/* Scc.B (xxx).W (EQ) */
uae_u32 REGPARAM2 CPUFUNC(op_57f8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	int val = cctrue (7) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (4);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* Scc.B (xxx).L (EQ) */
uae_u32 REGPARAM2 CPUFUNC(op_57f9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
{	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{	int val = cctrue (7) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (6);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* Scc.B Dn (VC) */
uae_u32 REGPARAM2 CPUFUNC(op_58c0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	int val = cctrue (8) ? 0xff : 0;
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4+ (1/0) */

/* DBcc.W Dn,#<data>.W (VC) */
uae_u32 REGPARAM2 CPUFUNC(op_58c8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = regs.irc;
	uaecptr oldpc = m68k_getpci ();
	if (!cctrue (8)) {
	m68k_incpci ((uae_s32)offs + 2);
		get_word_000_prefetch (0);
		m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpci () + 2 + (uae_s32)offs + 2);
				goto l_110912;
			}
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
			return 10 * CYCLE_UNIT / 2 + count_cycles;
		}
		count_cycles += 4 * CYCLE_UNIT / 2;
	} else {
		count_cycles += 2 * CYCLE_UNIT / 2;
	}
	m68k_setpci (oldpc + 4);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}l_110912: ;
return 10 * CYCLE_UNIT / 2 + count_cycles;
} /* 10 (2/0) */

/* Scc.B (An) (VC) */
uae_u32 REGPARAM2 CPUFUNC(op_58d0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	int val = cctrue (8) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/1) */

/* Scc.B (An)+ (VC) */
uae_u32 REGPARAM2 CPUFUNC(op_58d8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	int val = cctrue (8) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/1) */

/* Scc.B -(An) (VC) */
uae_u32 REGPARAM2 CPUFUNC(op_58e0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	int val = cctrue (8) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (2);
return 10 * CYCLE_UNIT / 2 + count_cycles;
} /* 10 (1/1) */

/* Scc.B (d16,An) (VC) */
uae_u32 REGPARAM2 CPUFUNC(op_58e8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	int val = cctrue (8) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (4);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* Scc.B (d8,An,Xn) (VC) */
uae_u32 REGPARAM2 CPUFUNC(op_58f0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
{	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	int val = cctrue (8) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (4);
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (2/1) */

/* Scc.B (xxx).W (VC) */
uae_u32 REGPARAM2 CPUFUNC(op_58f8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	int val = cctrue (8) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (4);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* Scc.B (xxx).L (VC) */
uae_u32 REGPARAM2 CPUFUNC(op_58f9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
{	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{	int val = cctrue (8) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (6);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* Scc.B Dn (VS) */
uae_u32 REGPARAM2 CPUFUNC(op_59c0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	int val = cctrue (9) ? 0xff : 0;
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4+ (1/0) */

/* DBcc.W Dn,#<data>.W (VS) */
uae_u32 REGPARAM2 CPUFUNC(op_59c8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = regs.irc;
	uaecptr oldpc = m68k_getpci ();
	if (!cctrue (9)) {
	m68k_incpci ((uae_s32)offs + 2);
		get_word_000_prefetch (0);
		m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpci () + 2 + (uae_s32)offs + 2);
				goto l_110921;
			}
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
			return 10 * CYCLE_UNIT / 2 + count_cycles;
		}
		count_cycles += 4 * CYCLE_UNIT / 2;
	} else {
		count_cycles += 2 * CYCLE_UNIT / 2;
	}
	m68k_setpci (oldpc + 4);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}l_110921: ;
return 10 * CYCLE_UNIT / 2 + count_cycles;
} /* 10 (2/0) */

/* Scc.B (An) (VS) */
uae_u32 REGPARAM2 CPUFUNC(op_59d0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	int val = cctrue (9) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/1) */

/* Scc.B (An)+ (VS) */
uae_u32 REGPARAM2 CPUFUNC(op_59d8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	int val = cctrue (9) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/1) */

/* Scc.B -(An) (VS) */
uae_u32 REGPARAM2 CPUFUNC(op_59e0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	int val = cctrue (9) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (2);
return 10 * CYCLE_UNIT / 2 + count_cycles;
} /* 10 (1/1) */

/* Scc.B (d16,An) (VS) */
uae_u32 REGPARAM2 CPUFUNC(op_59e8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	int val = cctrue (9) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (4);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* Scc.B (d8,An,Xn) (VS) */
uae_u32 REGPARAM2 CPUFUNC(op_59f0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
{	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	int val = cctrue (9) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (4);
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (2/1) */

/* Scc.B (xxx).W (VS) */
uae_u32 REGPARAM2 CPUFUNC(op_59f8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	int val = cctrue (9) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (4);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* Scc.B (xxx).L (VS) */
uae_u32 REGPARAM2 CPUFUNC(op_59f9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
{	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{	int val = cctrue (9) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (6);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* Scc.B Dn (PL) */
uae_u32 REGPARAM2 CPUFUNC(op_5ac0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	int val = cctrue (10) ? 0xff : 0;
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4+ (1/0) */

/* DBcc.W Dn,#<data>.W (PL) */
uae_u32 REGPARAM2 CPUFUNC(op_5ac8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = regs.irc;
	uaecptr oldpc = m68k_getpci ();
	if (!cctrue (10)) {
	m68k_incpci ((uae_s32)offs + 2);
		get_word_000_prefetch (0);
		m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpci () + 2 + (uae_s32)offs + 2);
				goto l_110930;
			}
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
			return 10 * CYCLE_UNIT / 2 + count_cycles;
		}
		count_cycles += 4 * CYCLE_UNIT / 2;
	} else {
		count_cycles += 2 * CYCLE_UNIT / 2;
	}
	m68k_setpci (oldpc + 4);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}l_110930: ;
return 10 * CYCLE_UNIT / 2 + count_cycles;
} /* 10 (2/0) */

/* Scc.B (An) (PL) */
uae_u32 REGPARAM2 CPUFUNC(op_5ad0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	int val = cctrue (10) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/1) */

/* Scc.B (An)+ (PL) */
uae_u32 REGPARAM2 CPUFUNC(op_5ad8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	int val = cctrue (10) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/1) */

/* Scc.B -(An) (PL) */
uae_u32 REGPARAM2 CPUFUNC(op_5ae0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	int val = cctrue (10) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (2);
return 10 * CYCLE_UNIT / 2 + count_cycles;
} /* 10 (1/1) */

/* Scc.B (d16,An) (PL) */
uae_u32 REGPARAM2 CPUFUNC(op_5ae8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	int val = cctrue (10) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (4);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* Scc.B (d8,An,Xn) (PL) */
uae_u32 REGPARAM2 CPUFUNC(op_5af0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
{	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	int val = cctrue (10) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (4);
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (2/1) */

/* Scc.B (xxx).W (PL) */
uae_u32 REGPARAM2 CPUFUNC(op_5af8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	int val = cctrue (10) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (4);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* Scc.B (xxx).L (PL) */
uae_u32 REGPARAM2 CPUFUNC(op_5af9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
{	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{	int val = cctrue (10) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (6);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* Scc.B Dn (MI) */
uae_u32 REGPARAM2 CPUFUNC(op_5bc0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	int val = cctrue (11) ? 0xff : 0;
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4+ (1/0) */

/* DBcc.W Dn,#<data>.W (MI) */
uae_u32 REGPARAM2 CPUFUNC(op_5bc8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = regs.irc;
	uaecptr oldpc = m68k_getpci ();
	if (!cctrue (11)) {
	m68k_incpci ((uae_s32)offs + 2);
		get_word_000_prefetch (0);
		m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpci () + 2 + (uae_s32)offs + 2);
				goto l_110939;
			}
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
			return 10 * CYCLE_UNIT / 2 + count_cycles;
		}
		count_cycles += 4 * CYCLE_UNIT / 2;
	} else {
		count_cycles += 2 * CYCLE_UNIT / 2;
	}
	m68k_setpci (oldpc + 4);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}l_110939: ;
return 10 * CYCLE_UNIT / 2 + count_cycles;
} /* 10 (2/0) */

/* Scc.B (An) (MI) */
uae_u32 REGPARAM2 CPUFUNC(op_5bd0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	int val = cctrue (11) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/1) */

/* Scc.B (An)+ (MI) */
uae_u32 REGPARAM2 CPUFUNC(op_5bd8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	int val = cctrue (11) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/1) */

/* Scc.B -(An) (MI) */
uae_u32 REGPARAM2 CPUFUNC(op_5be0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	int val = cctrue (11) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (2);
return 10 * CYCLE_UNIT / 2 + count_cycles;
} /* 10 (1/1) */

/* Scc.B (d16,An) (MI) */
uae_u32 REGPARAM2 CPUFUNC(op_5be8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	int val = cctrue (11) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (4);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* Scc.B (d8,An,Xn) (MI) */
uae_u32 REGPARAM2 CPUFUNC(op_5bf0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
{	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	int val = cctrue (11) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (4);
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (2/1) */

/* Scc.B (xxx).W (MI) */
uae_u32 REGPARAM2 CPUFUNC(op_5bf8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	int val = cctrue (11) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (4);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* Scc.B (xxx).L (MI) */
uae_u32 REGPARAM2 CPUFUNC(op_5bf9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
{	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{	int val = cctrue (11) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (6);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* Scc.B Dn (GE) */
uae_u32 REGPARAM2 CPUFUNC(op_5cc0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	int val = cctrue (12) ? 0xff : 0;
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4+ (1/0) */

/* DBcc.W Dn,#<data>.W (GE) */
uae_u32 REGPARAM2 CPUFUNC(op_5cc8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = regs.irc;
	uaecptr oldpc = m68k_getpci ();
	if (!cctrue (12)) {
	m68k_incpci ((uae_s32)offs + 2);
		get_word_000_prefetch (0);
		m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpci () + 2 + (uae_s32)offs + 2);
				goto l_110948;
			}
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
			return 10 * CYCLE_UNIT / 2 + count_cycles;
		}
		count_cycles += 4 * CYCLE_UNIT / 2;
	} else {
		count_cycles += 2 * CYCLE_UNIT / 2;
	}
	m68k_setpci (oldpc + 4);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}l_110948: ;
return 10 * CYCLE_UNIT / 2 + count_cycles;
} /* 10 (2/0) */

/* Scc.B (An) (GE) */
uae_u32 REGPARAM2 CPUFUNC(op_5cd0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	int val = cctrue (12) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/1) */

/* Scc.B (An)+ (GE) */
uae_u32 REGPARAM2 CPUFUNC(op_5cd8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	int val = cctrue (12) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/1) */

/* Scc.B -(An) (GE) */
uae_u32 REGPARAM2 CPUFUNC(op_5ce0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	int val = cctrue (12) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (2);
return 10 * CYCLE_UNIT / 2 + count_cycles;
} /* 10 (1/1) */

/* Scc.B (d16,An) (GE) */
uae_u32 REGPARAM2 CPUFUNC(op_5ce8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	int val = cctrue (12) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (4);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* Scc.B (d8,An,Xn) (GE) */
uae_u32 REGPARAM2 CPUFUNC(op_5cf0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
{	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	int val = cctrue (12) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (4);
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (2/1) */

/* Scc.B (xxx).W (GE) */
uae_u32 REGPARAM2 CPUFUNC(op_5cf8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	int val = cctrue (12) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (4);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* Scc.B (xxx).L (GE) */
uae_u32 REGPARAM2 CPUFUNC(op_5cf9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
{	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{	int val = cctrue (12) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (6);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* Scc.B Dn (LT) */
uae_u32 REGPARAM2 CPUFUNC(op_5dc0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	int val = cctrue (13) ? 0xff : 0;
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4+ (1/0) */

/* DBcc.W Dn,#<data>.W (LT) */
uae_u32 REGPARAM2 CPUFUNC(op_5dc8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = regs.irc;
	uaecptr oldpc = m68k_getpci ();
	if (!cctrue (13)) {
	m68k_incpci ((uae_s32)offs + 2);
		get_word_000_prefetch (0);
		m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpci () + 2 + (uae_s32)offs + 2);
				goto l_110957;
			}
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
			return 10 * CYCLE_UNIT / 2 + count_cycles;
		}
		count_cycles += 4 * CYCLE_UNIT / 2;
	} else {
		count_cycles += 2 * CYCLE_UNIT / 2;
	}
	m68k_setpci (oldpc + 4);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}l_110957: ;
return 10 * CYCLE_UNIT / 2 + count_cycles;
} /* 10 (2/0) */

/* Scc.B (An) (LT) */
uae_u32 REGPARAM2 CPUFUNC(op_5dd0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	int val = cctrue (13) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/1) */

/* Scc.B (An)+ (LT) */
uae_u32 REGPARAM2 CPUFUNC(op_5dd8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	int val = cctrue (13) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/1) */

/* Scc.B -(An) (LT) */
uae_u32 REGPARAM2 CPUFUNC(op_5de0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	int val = cctrue (13) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (2);
return 10 * CYCLE_UNIT / 2 + count_cycles;
} /* 10 (1/1) */

/* Scc.B (d16,An) (LT) */
uae_u32 REGPARAM2 CPUFUNC(op_5de8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	int val = cctrue (13) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (4);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* Scc.B (d8,An,Xn) (LT) */
uae_u32 REGPARAM2 CPUFUNC(op_5df0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
{	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	int val = cctrue (13) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (4);
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (2/1) */

/* Scc.B (xxx).W (LT) */
uae_u32 REGPARAM2 CPUFUNC(op_5df8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	int val = cctrue (13) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (4);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* Scc.B (xxx).L (LT) */
uae_u32 REGPARAM2 CPUFUNC(op_5df9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
{	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{	int val = cctrue (13) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (6);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* Scc.B Dn (GT) */
uae_u32 REGPARAM2 CPUFUNC(op_5ec0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	int val = cctrue (14) ? 0xff : 0;
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4+ (1/0) */

/* DBcc.W Dn,#<data>.W (GT) */
uae_u32 REGPARAM2 CPUFUNC(op_5ec8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = regs.irc;
	uaecptr oldpc = m68k_getpci ();
	if (!cctrue (14)) {
	m68k_incpci ((uae_s32)offs + 2);
		get_word_000_prefetch (0);
		m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpci () + 2 + (uae_s32)offs + 2);
				goto l_110966;
			}
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
			return 10 * CYCLE_UNIT / 2 + count_cycles;
		}
		count_cycles += 4 * CYCLE_UNIT / 2;
	} else {
		count_cycles += 2 * CYCLE_UNIT / 2;
	}
	m68k_setpci (oldpc + 4);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}l_110966: ;
return 10 * CYCLE_UNIT / 2 + count_cycles;
} /* 10 (2/0) */

/* Scc.B (An) (GT) */
uae_u32 REGPARAM2 CPUFUNC(op_5ed0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	int val = cctrue (14) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/1) */

/* Scc.B (An)+ (GT) */
uae_u32 REGPARAM2 CPUFUNC(op_5ed8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	int val = cctrue (14) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/1) */

/* Scc.B -(An) (GT) */
uae_u32 REGPARAM2 CPUFUNC(op_5ee0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	int val = cctrue (14) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (2);
return 10 * CYCLE_UNIT / 2 + count_cycles;
} /* 10 (1/1) */

/* Scc.B (d16,An) (GT) */
uae_u32 REGPARAM2 CPUFUNC(op_5ee8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	int val = cctrue (14) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (4);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* Scc.B (d8,An,Xn) (GT) */
uae_u32 REGPARAM2 CPUFUNC(op_5ef0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
{	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	int val = cctrue (14) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (4);
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (2/1) */

/* Scc.B (xxx).W (GT) */
uae_u32 REGPARAM2 CPUFUNC(op_5ef8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	int val = cctrue (14) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (4);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* Scc.B (xxx).L (GT) */
uae_u32 REGPARAM2 CPUFUNC(op_5ef9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
{	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{	int val = cctrue (14) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (6);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* Scc.B Dn (LE) */
uae_u32 REGPARAM2 CPUFUNC(op_5fc0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	int val = cctrue (15) ? 0xff : 0;
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4+ (1/0) */

/* DBcc.W Dn,#<data>.W (LE) */
uae_u32 REGPARAM2 CPUFUNC(op_5fc8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 offs = regs.irc;
	uaecptr oldpc = m68k_getpci ();
	if (!cctrue (15)) {
	m68k_incpci ((uae_s32)offs + 2);
		get_word_000_prefetch (0);
		m68k_dreg (regs, srcreg) = (m68k_dreg (regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (src) {
			if (offs & 1) {
				exception3i (opcode, m68k_getpci () + 2 + (uae_s32)offs + 2);
				goto l_110975;
			}
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
			return 10 * CYCLE_UNIT / 2 + count_cycles;
		}
		count_cycles += 4 * CYCLE_UNIT / 2;
	} else {
		count_cycles += 2 * CYCLE_UNIT / 2;
	}
	m68k_setpci (oldpc + 4);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}l_110975: ;
return 10 * CYCLE_UNIT / 2 + count_cycles;
} /* 10 (2/0) */

/* Scc.B (An) (LE) */
uae_u32 REGPARAM2 CPUFUNC(op_5fd0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	int val = cctrue (15) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/1) */

/* Scc.B (An)+ (LE) */
uae_u32 REGPARAM2 CPUFUNC(op_5fd8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	int val = cctrue (15) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/1) */

/* Scc.B -(An) (LE) */
uae_u32 REGPARAM2 CPUFUNC(op_5fe0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg (regs, srcreg) = srca;
{	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	int val = cctrue (15) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (2);
return 10 * CYCLE_UNIT / 2 + count_cycles;
} /* 10 (1/1) */

/* Scc.B (d16,An) (LE) */
uae_u32 REGPARAM2 CPUFUNC(op_5fe8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	int val = cctrue (15) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (4);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* Scc.B (d8,An,Xn) (LE) */
uae_u32 REGPARAM2 CPUFUNC(op_5ff0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
{	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	int val = cctrue (15) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (4);
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (2/1) */

/* Scc.B (xxx).W (LE) */
uae_u32 REGPARAM2 CPUFUNC(op_5ff8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	int val = cctrue (15) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (4);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* Scc.B (xxx).L (LE) */
uae_u32 REGPARAM2 CPUFUNC(op_5ff9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
{	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{	int val = cctrue (15) ? 0xff : 0;
	put_byte_000 (srca, val);
}}}}	m68k_incpci (6);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* Bcc.W #<data>.W (T) */
uae_u32 REGPARAM2 CPUFUNC(op_6000_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uae_s16 src = regs.irc;
	if (!cctrue (0)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_110983;
	}
	m68k_incpci ((uae_s32)src + 2);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
	return 10 * CYCLE_UNIT / 2;
didnt_jump:;
	m68k_incpci (4);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}l_110983: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/0) */

/* BccQ.B #<data> (T) */
uae_u32 REGPARAM2 CPUFUNC(op_6001_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	if (!cctrue (0)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_110984;
	}
	m68k_incpci ((uae_s32)src + 2);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
	return 10 * CYCLE_UNIT / 2;
didnt_jump:;
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}l_110984: ;
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/0) */

/* Bcc.L #<data>.L (T) */
uae_u32 REGPARAM2 CPUFUNC(op_60ff_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{	if (cctrue (0)) {
		exception3i (opcode, m68k_getpci () + 1);
		goto l_110985;
	}
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}l_110985: ;
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/0) */

/* BSR.W #<data>.W */
uae_u32 REGPARAM2 CPUFUNC(op_6100_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{	uae_s32 s;
{	uae_s16 src = regs.irc;
	s = (uae_s32)src + 2;
	if (src & 1) {
		exception3b (opcode, m68k_getpci () + s, 0, 1, m68k_getpci () + s);
		goto l_110986;
	}
	m68k_do_bsri (m68k_getpci () + 4, s);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}l_110986: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (2/2) */

/* BSRQ.B #<data> */
uae_u32 REGPARAM2 CPUFUNC(op_6101_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{	uae_s32 s;
{	uae_u32 src = srcreg;
	s = (uae_s32)src + 2;
	if (src & 1) {
		exception3b (opcode, m68k_getpci () + s, 0, 1, m68k_getpci () + s);
		goto l_110987;
	}
	m68k_do_bsri (m68k_getpci () + 2, s);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}l_110987: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (2/2) */

/* BSR.L #<data>.L */
uae_u32 REGPARAM2 CPUFUNC(op_61ff_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{	uae_s32 s;
	uae_u32 src = 0xffffffff;
	s = (uae_s32)src + 2;
	if (src & 1) {
		exception3b (opcode, m68k_getpci () + s, 0, 1, m68k_getpci () + s);
		goto l_110988;
	}
	m68k_do_bsri (m68k_getpci () + 2, s);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}l_110988: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (2/2) */

/* Bcc.W #<data>.W (HI) */
uae_u32 REGPARAM2 CPUFUNC(op_6200_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uae_s16 src = regs.irc;
	if (!cctrue (2)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_110989;
	}
	m68k_incpci ((uae_s32)src + 2);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
	return 10 * CYCLE_UNIT / 2;
didnt_jump:;
	m68k_incpci (4);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}l_110989: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/0) */

/* BccQ.B #<data> (HI) */
uae_u32 REGPARAM2 CPUFUNC(op_6201_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	if (!cctrue (2)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_110990;
	}
	m68k_incpci ((uae_s32)src + 2);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
	return 10 * CYCLE_UNIT / 2;
didnt_jump:;
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}l_110990: ;
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/0) */

/* Bcc.L #<data>.L (HI) */
uae_u32 REGPARAM2 CPUFUNC(op_62ff_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{	if (cctrue (2)) {
		exception3i (opcode, m68k_getpci () + 1);
		goto l_110991;
	}
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}l_110991: ;
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/0) */

/* Bcc.W #<data>.W (LS) */
uae_u32 REGPARAM2 CPUFUNC(op_6300_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uae_s16 src = regs.irc;
	if (!cctrue (3)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_110992;
	}
	m68k_incpci ((uae_s32)src + 2);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
	return 10 * CYCLE_UNIT / 2;
didnt_jump:;
	m68k_incpci (4);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}l_110992: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/0) */

/* BccQ.B #<data> (LS) */
uae_u32 REGPARAM2 CPUFUNC(op_6301_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	if (!cctrue (3)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_110993;
	}
	m68k_incpci ((uae_s32)src + 2);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
	return 10 * CYCLE_UNIT / 2;
didnt_jump:;
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}l_110993: ;
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/0) */

#endif

#ifdef PART_6
/* Bcc.L #<data>.L (LS) */
uae_u32 REGPARAM2 CPUFUNC(op_63ff_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{	if (cctrue (3)) {
		exception3i (opcode, m68k_getpci () + 1);
		goto l_110994;
	}
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}l_110994: ;
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/0) */

/* Bcc.W #<data>.W (CC) */
uae_u32 REGPARAM2 CPUFUNC(op_6400_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uae_s16 src = regs.irc;
	if (!cctrue (4)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_110995;
	}
	m68k_incpci ((uae_s32)src + 2);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
	return 10 * CYCLE_UNIT / 2;
didnt_jump:;
	m68k_incpci (4);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}l_110995: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/0) */

/* BccQ.B #<data> (CC) */
uae_u32 REGPARAM2 CPUFUNC(op_6401_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	if (!cctrue (4)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_110996;
	}
	m68k_incpci ((uae_s32)src + 2);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
	return 10 * CYCLE_UNIT / 2;
didnt_jump:;
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}l_110996: ;
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/0) */

/* Bcc.L #<data>.L (CC) */
uae_u32 REGPARAM2 CPUFUNC(op_64ff_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{	if (cctrue (4)) {
		exception3i (opcode, m68k_getpci () + 1);
		goto l_110997;
	}
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}l_110997: ;
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/0) */

/* Bcc.W #<data>.W (CS) */
uae_u32 REGPARAM2 CPUFUNC(op_6500_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uae_s16 src = regs.irc;
	if (!cctrue (5)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_110998;
	}
	m68k_incpci ((uae_s32)src + 2);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
	return 10 * CYCLE_UNIT / 2;
didnt_jump:;
	m68k_incpci (4);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}l_110998: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/0) */

/* BccQ.B #<data> (CS) */
uae_u32 REGPARAM2 CPUFUNC(op_6501_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	if (!cctrue (5)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_110999;
	}
	m68k_incpci ((uae_s32)src + 2);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
	return 10 * CYCLE_UNIT / 2;
didnt_jump:;
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}l_110999: ;
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/0) */

/* Bcc.L #<data>.L (CS) */
uae_u32 REGPARAM2 CPUFUNC(op_65ff_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{	if (cctrue (5)) {
		exception3i (opcode, m68k_getpci () + 1);
		goto l_111000;
	}
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}l_111000: ;
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/0) */

/* Bcc.W #<data>.W (NE) */
uae_u32 REGPARAM2 CPUFUNC(op_6600_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uae_s16 src = regs.irc;
	if (!cctrue (6)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_111001;
	}
	m68k_incpci ((uae_s32)src + 2);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
	return 10 * CYCLE_UNIT / 2;
didnt_jump:;
	m68k_incpci (4);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}l_111001: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/0) */

/* BccQ.B #<data> (NE) */
uae_u32 REGPARAM2 CPUFUNC(op_6601_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	if (!cctrue (6)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_111002;
	}
	m68k_incpci ((uae_s32)src + 2);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
	return 10 * CYCLE_UNIT / 2;
didnt_jump:;
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}l_111002: ;
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/0) */

/* Bcc.L #<data>.L (NE) */
uae_u32 REGPARAM2 CPUFUNC(op_66ff_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{	if (cctrue (6)) {
		exception3i (opcode, m68k_getpci () + 1);
		goto l_111003;
	}
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}l_111003: ;
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/0) */

/* Bcc.W #<data>.W (EQ) */
uae_u32 REGPARAM2 CPUFUNC(op_6700_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uae_s16 src = regs.irc;
	if (!cctrue (7)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_111004;
	}
	m68k_incpci ((uae_s32)src + 2);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
	return 10 * CYCLE_UNIT / 2;
didnt_jump:;
	m68k_incpci (4);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}l_111004: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/0) */

/* BccQ.B #<data> (EQ) */
uae_u32 REGPARAM2 CPUFUNC(op_6701_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	if (!cctrue (7)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_111005;
	}
	m68k_incpci ((uae_s32)src + 2);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
	return 10 * CYCLE_UNIT / 2;
didnt_jump:;
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}l_111005: ;
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/0) */

/* Bcc.L #<data>.L (EQ) */
uae_u32 REGPARAM2 CPUFUNC(op_67ff_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{	if (cctrue (7)) {
		exception3i (opcode, m68k_getpci () + 1);
		goto l_111006;
	}
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}l_111006: ;
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/0) */

/* Bcc.W #<data>.W (VC) */
uae_u32 REGPARAM2 CPUFUNC(op_6800_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uae_s16 src = regs.irc;
	if (!cctrue (8)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_111007;
	}
	m68k_incpci ((uae_s32)src + 2);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
	return 10 * CYCLE_UNIT / 2;
didnt_jump:;
	m68k_incpci (4);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}l_111007: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/0) */

/* BccQ.B #<data> (VC) */
uae_u32 REGPARAM2 CPUFUNC(op_6801_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	if (!cctrue (8)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_111008;
	}
	m68k_incpci ((uae_s32)src + 2);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
	return 10 * CYCLE_UNIT / 2;
didnt_jump:;
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}l_111008: ;
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/0) */

/* Bcc.L #<data>.L (VC) */
uae_u32 REGPARAM2 CPUFUNC(op_68ff_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{	if (cctrue (8)) {
		exception3i (opcode, m68k_getpci () + 1);
		goto l_111009;
	}
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}l_111009: ;
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/0) */

/* Bcc.W #<data>.W (VS) */
uae_u32 REGPARAM2 CPUFUNC(op_6900_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uae_s16 src = regs.irc;
	if (!cctrue (9)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_111010;
	}
	m68k_incpci ((uae_s32)src + 2);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
	return 10 * CYCLE_UNIT / 2;
didnt_jump:;
	m68k_incpci (4);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}l_111010: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/0) */

/* BccQ.B #<data> (VS) */
uae_u32 REGPARAM2 CPUFUNC(op_6901_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	if (!cctrue (9)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_111011;
	}
	m68k_incpci ((uae_s32)src + 2);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
	return 10 * CYCLE_UNIT / 2;
didnt_jump:;
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}l_111011: ;
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/0) */

/* Bcc.L #<data>.L (VS) */
uae_u32 REGPARAM2 CPUFUNC(op_69ff_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{	if (cctrue (9)) {
		exception3i (opcode, m68k_getpci () + 1);
		goto l_111012;
	}
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}l_111012: ;
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/0) */

/* Bcc.W #<data>.W (PL) */
uae_u32 REGPARAM2 CPUFUNC(op_6a00_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uae_s16 src = regs.irc;
	if (!cctrue (10)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_111013;
	}
	m68k_incpci ((uae_s32)src + 2);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
	return 10 * CYCLE_UNIT / 2;
didnt_jump:;
	m68k_incpci (4);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}l_111013: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/0) */

/* BccQ.B #<data> (PL) */
uae_u32 REGPARAM2 CPUFUNC(op_6a01_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	if (!cctrue (10)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_111014;
	}
	m68k_incpci ((uae_s32)src + 2);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
	return 10 * CYCLE_UNIT / 2;
didnt_jump:;
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}l_111014: ;
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/0) */

/* Bcc.L #<data>.L (PL) */
uae_u32 REGPARAM2 CPUFUNC(op_6aff_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{	if (cctrue (10)) {
		exception3i (opcode, m68k_getpci () + 1);
		goto l_111015;
	}
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}l_111015: ;
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/0) */

/* Bcc.W #<data>.W (MI) */
uae_u32 REGPARAM2 CPUFUNC(op_6b00_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uae_s16 src = regs.irc;
	if (!cctrue (11)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_111016;
	}
	m68k_incpci ((uae_s32)src + 2);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
	return 10 * CYCLE_UNIT / 2;
didnt_jump:;
	m68k_incpci (4);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}l_111016: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/0) */

/* BccQ.B #<data> (MI) */
uae_u32 REGPARAM2 CPUFUNC(op_6b01_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	if (!cctrue (11)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_111017;
	}
	m68k_incpci ((uae_s32)src + 2);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
	return 10 * CYCLE_UNIT / 2;
didnt_jump:;
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}l_111017: ;
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/0) */

/* Bcc.L #<data>.L (MI) */
uae_u32 REGPARAM2 CPUFUNC(op_6bff_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{	if (cctrue (11)) {
		exception3i (opcode, m68k_getpci () + 1);
		goto l_111018;
	}
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}l_111018: ;
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/0) */

/* Bcc.W #<data>.W (GE) */
uae_u32 REGPARAM2 CPUFUNC(op_6c00_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uae_s16 src = regs.irc;
	if (!cctrue (12)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_111019;
	}
	m68k_incpci ((uae_s32)src + 2);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
	return 10 * CYCLE_UNIT / 2;
didnt_jump:;
	m68k_incpci (4);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}l_111019: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/0) */

/* BccQ.B #<data> (GE) */
uae_u32 REGPARAM2 CPUFUNC(op_6c01_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	if (!cctrue (12)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_111020;
	}
	m68k_incpci ((uae_s32)src + 2);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
	return 10 * CYCLE_UNIT / 2;
didnt_jump:;
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}l_111020: ;
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/0) */

/* Bcc.L #<data>.L (GE) */
uae_u32 REGPARAM2 CPUFUNC(op_6cff_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{	if (cctrue (12)) {
		exception3i (opcode, m68k_getpci () + 1);
		goto l_111021;
	}
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}l_111021: ;
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/0) */

/* Bcc.W #<data>.W (LT) */
uae_u32 REGPARAM2 CPUFUNC(op_6d00_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uae_s16 src = regs.irc;
	if (!cctrue (13)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_111022;
	}
	m68k_incpci ((uae_s32)src + 2);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
	return 10 * CYCLE_UNIT / 2;
didnt_jump:;
	m68k_incpci (4);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}l_111022: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/0) */

/* BccQ.B #<data> (LT) */
uae_u32 REGPARAM2 CPUFUNC(op_6d01_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	if (!cctrue (13)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_111023;
	}
	m68k_incpci ((uae_s32)src + 2);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
	return 10 * CYCLE_UNIT / 2;
didnt_jump:;
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}l_111023: ;
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/0) */

/* Bcc.L #<data>.L (LT) */
uae_u32 REGPARAM2 CPUFUNC(op_6dff_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{	if (cctrue (13)) {
		exception3i (opcode, m68k_getpci () + 1);
		goto l_111024;
	}
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}l_111024: ;
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/0) */

/* Bcc.W #<data>.W (GT) */
uae_u32 REGPARAM2 CPUFUNC(op_6e00_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uae_s16 src = regs.irc;
	if (!cctrue (14)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_111025;
	}
	m68k_incpci ((uae_s32)src + 2);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
	return 10 * CYCLE_UNIT / 2;
didnt_jump:;
	m68k_incpci (4);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}l_111025: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/0) */

/* BccQ.B #<data> (GT) */
uae_u32 REGPARAM2 CPUFUNC(op_6e01_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	if (!cctrue (14)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_111026;
	}
	m68k_incpci ((uae_s32)src + 2);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
	return 10 * CYCLE_UNIT / 2;
didnt_jump:;
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}l_111026: ;
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/0) */

/* Bcc.L #<data>.L (GT) */
uae_u32 REGPARAM2 CPUFUNC(op_6eff_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{	if (cctrue (14)) {
		exception3i (opcode, m68k_getpci () + 1);
		goto l_111027;
	}
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}l_111027: ;
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/0) */

/* Bcc.W #<data>.W (LE) */
uae_u32 REGPARAM2 CPUFUNC(op_6f00_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{{	uae_s16 src = regs.irc;
	if (!cctrue (15)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_111028;
	}
	m68k_incpci ((uae_s32)src + 2);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
	return 10 * CYCLE_UNIT / 2;
didnt_jump:;
	m68k_incpci (4);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}l_111028: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/0) */

/* BccQ.B #<data> (LE) */
uae_u32 REGPARAM2 CPUFUNC(op_6f01_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
{{	uae_u32 src = srcreg;
	if (!cctrue (15)) goto didnt_jump;
	if (src & 1) {
		exception3i (opcode, m68k_getpci () + 2 + (uae_s32)src);
		goto l_111029;
	}
	m68k_incpci ((uae_s32)src + 2);
	get_word_000_prefetch (0);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
	return 10 * CYCLE_UNIT / 2;
didnt_jump:;
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}l_111029: ;
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/0) */

/* Bcc.L #<data>.L (LE) */
uae_u32 REGPARAM2 CPUFUNC(op_6fff_11)(uae_u32 opcode)
{
	int count_cycles = 0;
{	if (cctrue (15)) {
		exception3i (opcode, m68k_getpci () + 1);
		goto l_111030;
	}
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}l_111030: ;
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/0) */

/* MOVEQ.L #<data>,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_7000_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (uae_s32)(uae_s8)(opcode & 255);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_u32 src = srcreg;
{	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	m68k_dreg (regs, dstreg) = (src);
	m68k_incpci (2);
	regs.ir = regs.irc;
	get_word_000_prefetch (2);
}}}return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4 (1/0) */

/* OR.B Dn,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_8000_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}	m68k_incpci (2);
return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4 (1/0) */

/* OR.B (An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_8010_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_000 (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (2/0) */

/* OR.B (An)+,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_8018_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_000 (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (2/0) */

/* OR.B -(An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_8020_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte_000 (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpci (2);
return 10 * CYCLE_UNIT / 2 + count_cycles;
} /* 10 (2/0) */

/* OR.B (d16,An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_8028_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 src = get_byte_000 (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpci (4);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (3/0) */

/* OR.B (d8,An,Xn),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_8030_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
{	uae_s8 src = get_byte_000 (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpci (4);
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (3/0) */

/* OR.B (xxx).W,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_8038_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 src = get_byte_000 (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpci (4);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (3/0) */

/* OR.B (xxx).L,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_8039_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
{	uae_s8 src = get_byte_000 (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpci (6);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (4/0) */

/* OR.B (d16,PC),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_803a_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 src = get_byte_000 (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpci (4);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (3/0) */

/* OR.B (d8,PC,Xn),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_803b_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	srca = get_disp_ea_000 (tmppc, get_word_000_prefetch (4));
{	uae_s8 src = get_byte_000 (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpci (4);
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (3/0) */

/* OR.B #<data>.B,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_803c_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = (uae_u8)get_word_000_prefetch (4);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}	m68k_incpci (4);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (2/0) */

/* OR.W Dn,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_8040_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}	m68k_incpci (2);
return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4 (1/0) */

/* OR.W (An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_8050_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111044;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}	m68k_incpci (2);
l_111044: ;
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (2/0) */

/* OR.W (An)+,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_8058_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111045;
	}
{{	uae_s16 src = get_word_000 (srca);
	m68k_areg (regs, srcreg) += 2;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}	m68k_incpci (2);
l_111045: ;
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (2/0) */

/* OR.W -(An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_8060_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_111046;
	}
{{	uae_s16 src = get_word_000 (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}	m68k_incpci (2);
l_111046: ;
return 10 * CYCLE_UNIT / 2 + count_cycles;
} /* 10 (2/0) */

/* OR.W (d16,An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_8068_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111047;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}	m68k_incpci (4);
l_111047: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (3/0) */

/* OR.W (d8,An,Xn),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_8070_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111048;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}	m68k_incpci (4);
l_111048: ;
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (3/0) */

/* OR.W (xxx).W,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_8078_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_111049;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}	m68k_incpci (4);
l_111049: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (3/0) */

/* OR.W (xxx).L,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_8079_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_111050;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}	m68k_incpci (6);
l_111050: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (4/0) */

/* OR.W (d16,PC),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_807a_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111051;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}	m68k_incpci (4);
l_111051: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (3/0) */

/* OR.W (d8,PC,Xn),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_807b_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	srca = get_disp_ea_000 (tmppc, get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111052;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}	m68k_incpci (4);
l_111052: ;
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (3/0) */

/* OR.W #<data>.W,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_807c_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}	m68k_incpci (4);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (2/0) */

/* OR.L Dn,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_8080_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	m68k_dreg (regs, dstreg) = (src);
}}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/0) */

/* OR.L (An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_8090_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111055;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	m68k_dreg (regs, dstreg) = (src);
}}}}}	m68k_incpci (2);
l_111055: ;
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (3/0) */

/* OR.L (An)+,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_8098_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111056;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
	m68k_areg (regs, srcreg) += 4;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	m68k_dreg (regs, dstreg) = (src);
}}}}}	m68k_incpci (2);
l_111056: ;
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (3/0) */

/* OR.L -(An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_80a0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_111057;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	m68k_dreg (regs, dstreg) = (src);
}}}}}	m68k_incpci (2);
l_111057: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/0) */

/* OR.L (d16,An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_80a8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111058;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	m68k_dreg (regs, dstreg) = (src);
}}}}}	m68k_incpci (4);
l_111058: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (4/0) */

/* OR.L (d8,An,Xn),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_80b0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111059;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	m68k_dreg (regs, dstreg) = (src);
}}}}}	m68k_incpci (4);
l_111059: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/0) */

/* OR.L (xxx).W,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_80b8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_111060;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	m68k_dreg (regs, dstreg) = (src);
}}}}}	m68k_incpci (4);
l_111060: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (4/0) */

/* OR.L (xxx).L,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_80b9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_111061;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	m68k_dreg (regs, dstreg) = (src);
}}}}}	m68k_incpci (6);
l_111061: ;
return 22 * CYCLE_UNIT / 2 + count_cycles;
} /* 22 (5/0) */

/* OR.L (d16,PC),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_80ba_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111062;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	m68k_dreg (regs, dstreg) = (src);
}}}}}	m68k_incpci (4);
l_111062: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (4/0) */

/* OR.L (d8,PC,Xn),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_80bb_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	srca = get_disp_ea_000 (tmppc, get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111063;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	m68k_dreg (regs, dstreg) = (src);
}}}}}	m68k_incpci (4);
l_111063: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/0) */

/* OR.L #<data>.L,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_80bc_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src;
	src = get_word_000_prefetch (4) << 16;
	src |= get_word_000_prefetch (6);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	m68k_dreg (regs, dstreg) = (src);
}}}	m68k_incpci (6);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/0) */

/* DIVU.W Dn,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_80c0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	CLEAR_CZNV ();
	if (src == 0) {
	m68k_incpci (2);
		Exception (5);
		goto l_111065;
	} else {
		uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
		uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
		count_cycles += ((getDivu68kCycles((uae_u32)dst, (uae_u16)src)) - 4) * CYCLE_UNIT / 2;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
		if (newv > 0xffff) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	m68k_incpci (2);
	}
}}}l_111065: ;
return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4+ (1/0) */

/* DIVU.W (An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_80d0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111066;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	CLEAR_CZNV ();
	if (src == 0) {
	m68k_incpci (2);
		Exception (5);
		goto l_111066;
	} else {
		uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
		uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
		count_cycles += ((getDivu68kCycles((uae_u32)dst, (uae_u16)src)) - 4) * CYCLE_UNIT / 2;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
		if (newv > 0xffff) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	m68k_incpci (2);
	}
}}}}}l_111066: ;
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8+ (2/0) */

/* DIVU.W (An)+,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_80d8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111067;
	}
{{	uae_s16 src = get_word_000 (srca);
	m68k_areg (regs, srcreg) += 2;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	CLEAR_CZNV ();
	if (src == 0) {
	m68k_incpci (2);
		Exception (5);
		goto l_111067;
	} else {
		uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
		uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
		count_cycles += ((getDivu68kCycles((uae_u32)dst, (uae_u16)src)) - 4) * CYCLE_UNIT / 2;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
		if (newv > 0xffff) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	m68k_incpci (2);
	}
}}}}}l_111067: ;
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8+ (2/0) */

/* DIVU.W -(An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_80e0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_111068;
	}
{{	uae_s16 src = get_word_000 (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	CLEAR_CZNV ();
	if (src == 0) {
	m68k_incpci (2);
		Exception (5);
		goto l_111068;
	} else {
		uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
		uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
		count_cycles += ((getDivu68kCycles((uae_u32)dst, (uae_u16)src)) - 4) * CYCLE_UNIT / 2;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
		if (newv > 0xffff) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	m68k_incpci (2);
	}
}}}}}l_111068: ;
return 10 * CYCLE_UNIT / 2 + count_cycles;
} /* 10+ (2/0) */

/* DIVU.W (d16,An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_80e8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111069;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	CLEAR_CZNV ();
	if (src == 0) {
	m68k_incpci (4);
		Exception (5);
		goto l_111069;
	} else {
		uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
		uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
		count_cycles += ((getDivu68kCycles((uae_u32)dst, (uae_u16)src)) - 4) * CYCLE_UNIT / 2;
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
		if (newv > 0xffff) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	m68k_incpci (4);
	}
}}}}}l_111069: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12+ (3/0) */

/* DIVU.W (d8,An,Xn),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_80f0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111070;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	CLEAR_CZNV ();
	if (src == 0) {
	m68k_incpci (4);
		Exception (5);
		goto l_111070;
	} else {
		uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
		uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
		count_cycles += ((getDivu68kCycles((uae_u32)dst, (uae_u16)src)) - 4) * CYCLE_UNIT / 2;
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
		if (newv > 0xffff) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	m68k_incpci (4);
	}
}}}}}l_111070: ;
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14+ (3/0) */

/* DIVU.W (xxx).W,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_80f8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_111071;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	CLEAR_CZNV ();
	if (src == 0) {
	m68k_incpci (4);
		Exception (5);
		goto l_111071;
	} else {
		uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
		uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
		count_cycles += ((getDivu68kCycles((uae_u32)dst, (uae_u16)src)) - 4) * CYCLE_UNIT / 2;
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
		if (newv > 0xffff) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	m68k_incpci (4);
	}
}}}}}l_111071: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12+ (3/0) */

/* DIVU.W (xxx).L,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_80f9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_111072;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	CLEAR_CZNV ();
	if (src == 0) {
	m68k_incpci (6);
		Exception (5);
		goto l_111072;
	} else {
		uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
		uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
		count_cycles += ((getDivu68kCycles((uae_u32)dst, (uae_u16)src)) - 4) * CYCLE_UNIT / 2;
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
		if (newv > 0xffff) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	m68k_incpci (6);
	}
}}}}}l_111072: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16+ (4/0) */

/* DIVU.W (d16,PC),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_80fa_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111073;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	CLEAR_CZNV ();
	if (src == 0) {
	m68k_incpci (4);
		Exception (5);
		goto l_111073;
	} else {
		uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
		uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
		count_cycles += ((getDivu68kCycles((uae_u32)dst, (uae_u16)src)) - 4) * CYCLE_UNIT / 2;
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
		if (newv > 0xffff) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	m68k_incpci (4);
	}
}}}}}l_111073: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12+ (3/0) */

/* DIVU.W (d8,PC,Xn),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_80fb_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	srca = get_disp_ea_000 (tmppc, get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111074;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	CLEAR_CZNV ();
	if (src == 0) {
	m68k_incpci (4);
		Exception (5);
		goto l_111074;
	} else {
		uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
		uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
		count_cycles += ((getDivu68kCycles((uae_u32)dst, (uae_u16)src)) - 4) * CYCLE_UNIT / 2;
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
		if (newv > 0xffff) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	m68k_incpci (4);
	}
}}}}}l_111074: ;
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14+ (3/0) */

/* DIVU.W #<data>.W,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_80fc_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	CLEAR_CZNV ();
	if (src == 0) {
	m68k_incpci (4);
		Exception (5);
		goto l_111075;
	} else {
		uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
		uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
		count_cycles += ((getDivu68kCycles((uae_u32)dst, (uae_u16)src)) - 4) * CYCLE_UNIT / 2;
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
		if (newv > 0xffff) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	m68k_incpci (4);
	}
}}}l_111075: ;
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8+ (2/0) */

/* SBCD.B Dn,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_8100_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u16 newv_lo = (dst & 0xF) - (src & 0xF) - (GET_XFLG () ? 1 : 0);
	uae_u16 newv_hi = (dst & 0xF0) - (src & 0xF0);
	uae_u16 newv, tmp_newv;
	int bcd = 0;
	newv = tmp_newv = newv_hi + newv_lo;
	if (newv_lo & 0xF0) { newv -= 6; bcd = 6; };
	if ((((dst & 0xFF) - (src & 0xFF) - (GET_XFLG () ? 1 : 0)) & 0x100) > 0xFF) { newv -= 0x60; }
	SET_CFLG ((((dst & 0xFF) - (src & 0xFF) - bcd - (GET_XFLG () ? 1 : 0)) & 0x300) > 0xFF);
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	SET_VFLG ((tmp_newv & 0x80) != 0 && (newv & 0x80) == 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}	m68k_incpci (2);
return 6 * CYCLE_UNIT / 2 + count_cycles;
} /* 6 (1/0) */

/* SBCD.B -(An),-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_8108_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte_000 (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte_000 (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u16 newv_lo = (dst & 0xF) - (src & 0xF) - (GET_XFLG () ? 1 : 0);
	uae_u16 newv_hi = (dst & 0xF0) - (src & 0xF0);
	uae_u16 newv, tmp_newv;
	int bcd = 0;
	newv = tmp_newv = newv_hi + newv_lo;
	if (newv_lo & 0xF0) { newv -= 6; bcd = 6; };
	if ((((dst & 0xFF) - (src & 0xFF) - (GET_XFLG () ? 1 : 0)) & 0x100) > 0xFF) { newv -= 0x60; }
	SET_CFLG ((((dst & 0xFF) - (src & 0xFF) - bcd - (GET_XFLG () ? 1 : 0)) & 0x300) > 0xFF);
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	SET_VFLG ((tmp_newv & 0x80) != 0 && (newv & 0x80) == 0);
	put_byte_000 (dsta, newv);
}}}}}}	m68k_incpci (2);
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/1) */

/* OR.B Dn,(An) */
uae_u32 REGPARAM2 CPUFUNC(op_8110_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_000 (dsta);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	put_byte_000 (dsta, src);
}}}}	m68k_incpci (2);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* OR.B Dn,(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_8118_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_000 (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	put_byte_000 (dsta, src);
}}}}	m68k_incpci (2);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* OR.B Dn,-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_8120_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte_000 (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	put_byte_000 (dsta, src);
}}}}	m68k_incpci (2);
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (2/1) */

/* OR.B Dn,(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_8128_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 dst = get_byte_000 (dsta);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	put_byte_000 (dsta, src);
}}}}	m68k_incpci (4);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* OR.B Dn,(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_8130_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (4));
{	uae_s8 dst = get_byte_000 (dsta);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	put_byte_000 (dsta, src);
}}}}	m68k_incpci (4);
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/1) */

/* OR.B Dn,(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_8138_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 dst = get_byte_000 (dsta);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	put_byte_000 (dsta, src);
}}}}	m68k_incpci (4);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* OR.B Dn,(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_8139_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_word_000_prefetch (4) << 16;
	dsta |= get_word_000_prefetch (6);
{	uae_s8 dst = get_byte_000 (dsta);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	put_byte_000 (dsta, src);
}}}}	m68k_incpci (6);
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* OR.W Dn,(An) */
uae_u32 REGPARAM2 CPUFUNC(op_8150_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_111085;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	put_word_000 (dsta, src);
}}}}}	m68k_incpci (2);
l_111085: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* OR.W Dn,(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_8158_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_111086;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	m68k_areg (regs, dstreg) += 2;
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	put_word_000 (dsta, src);
}}}}}	m68k_incpci (2);
l_111086: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* OR.W Dn,-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_8160_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_111087;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	put_word_000 (dsta, src);
}}}}}	m68k_incpci (2);
l_111087: ;
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (2/1) */

/* OR.W Dn,(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_8168_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_111088;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	put_word_000 (dsta, src);
}}}}}	m68k_incpci (4);
l_111088: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* OR.W Dn,(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_8170_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (4));
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_111089;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	put_word_000 (dsta, src);
}}}}}	m68k_incpci (4);
l_111089: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/1) */

/* OR.W Dn,(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_8178_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_111090;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	put_word_000 (dsta, src);
}}}}}	m68k_incpci (4);
l_111090: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* OR.W Dn,(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_8179_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_word_000_prefetch (4) << 16;
	dsta |= get_word_000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_read(opcode, dsta);
		goto l_111091;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	put_word_000 (dsta, src);
}}}}}	m68k_incpci (6);
l_111091: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* OR.L Dn,(An) */
uae_u32 REGPARAM2 CPUFUNC(op_8190_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_111092;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	put_word_000 (dsta + 2, src); put_word_000 (dsta, src >> 16);
}}}}}	m68k_incpci (2);
l_111092: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (3/2) */

/* OR.L Dn,(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_8198_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_111093;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	m68k_areg (regs, dstreg) += 4;
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	put_word_000 (dsta + 2, src); put_word_000 (dsta, src >> 16);
}}}}}	m68k_incpci (2);
l_111093: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (3/2) */

/* OR.L Dn,-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_81a0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_111094;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	m68k_areg (regs, dstreg) = dsta;
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	put_word_000 (dsta + 2, src); put_word_000 (dsta, src >> 16);
}}}}}	m68k_incpci (2);
l_111094: ;
return 22 * CYCLE_UNIT / 2 + count_cycles;
} /* 22 (3/2) */

/* OR.L Dn,(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_81a8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_111095;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	put_word_000 (dsta + 2, src); put_word_000 (dsta, src >> 16);
}}}}}	m68k_incpci (4);
l_111095: ;
return 24 * CYCLE_UNIT / 2 + count_cycles;
} /* 24 (4/2) */

/* OR.L Dn,(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_81b0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (4));
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_111096;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	put_word_000 (dsta + 2, src); put_word_000 (dsta, src >> 16);
}}}}}	m68k_incpci (4);
l_111096: ;
return 26 * CYCLE_UNIT / 2 + count_cycles;
} /* 26 (4/2) */

/* OR.L Dn,(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_81b8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_111097;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	put_word_000 (dsta + 2, src); put_word_000 (dsta, src >> 16);
}}}}}	m68k_incpci (4);
l_111097: ;
return 24 * CYCLE_UNIT / 2 + count_cycles;
} /* 24 (4/2) */

/* OR.L Dn,(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_81b9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_word_000_prefetch (4) << 16;
	dsta |= get_word_000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_read(opcode, dsta);
		goto l_111098;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	src |= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	put_word_000 (dsta + 2, src); put_word_000 (dsta, src >> 16);
}}}}}	m68k_incpci (6);
l_111098: ;
return 28 * CYCLE_UNIT / 2 + count_cycles;
} /* 28 (5/2) */

/* DIVS.W Dn,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_81c0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	if (src == 0) {
	m68k_incpci (2);
		Exception (5);
		goto l_111099;
	}
	CLEAR_CZNV ();
		count_cycles += ((getDivs68kCycles((uae_s32)dst, (uae_s16)src)) - 4) * CYCLE_UNIT / 2;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	if (dst == 0x80000000 && src == -1) {
		SET_VFLG (1);
		SET_NFLG (1);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	}
	m68k_incpci (2);
}}}l_111099: ;
return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4+ (1/0) */

/* DIVS.W (An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_81d0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111100;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	if (src == 0) {
	m68k_incpci (2);
		Exception (5);
		goto l_111100;
	}
	CLEAR_CZNV ();
		count_cycles += ((getDivs68kCycles((uae_s32)dst, (uae_s16)src)) - 4) * CYCLE_UNIT / 2;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	if (dst == 0x80000000 && src == -1) {
		SET_VFLG (1);
		SET_NFLG (1);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	}
	m68k_incpci (2);
}}}}}l_111100: ;
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8+ (2/0) */

/* DIVS.W (An)+,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_81d8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111101;
	}
{{	uae_s16 src = get_word_000 (srca);
	m68k_areg (regs, srcreg) += 2;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	if (src == 0) {
	m68k_incpci (2);
		Exception (5);
		goto l_111101;
	}
	CLEAR_CZNV ();
		count_cycles += ((getDivs68kCycles((uae_s32)dst, (uae_s16)src)) - 4) * CYCLE_UNIT / 2;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	if (dst == 0x80000000 && src == -1) {
		SET_VFLG (1);
		SET_NFLG (1);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	}
	m68k_incpci (2);
}}}}}l_111101: ;
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8+ (2/0) */

/* DIVS.W -(An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_81e0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_111102;
	}
{{	uae_s16 src = get_word_000 (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	if (src == 0) {
	m68k_incpci (2);
		Exception (5);
		goto l_111102;
	}
	CLEAR_CZNV ();
		count_cycles += ((getDivs68kCycles((uae_s32)dst, (uae_s16)src)) - 4) * CYCLE_UNIT / 2;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	if (dst == 0x80000000 && src == -1) {
		SET_VFLG (1);
		SET_NFLG (1);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	}
	m68k_incpci (2);
}}}}}l_111102: ;
return 10 * CYCLE_UNIT / 2 + count_cycles;
} /* 10+ (2/0) */

/* DIVS.W (d16,An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_81e8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111103;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	if (src == 0) {
	m68k_incpci (4);
		Exception (5);
		goto l_111103;
	}
	CLEAR_CZNV ();
		count_cycles += ((getDivs68kCycles((uae_s32)dst, (uae_s16)src)) - 4) * CYCLE_UNIT / 2;
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	if (dst == 0x80000000 && src == -1) {
		SET_VFLG (1);
		SET_NFLG (1);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	}
	m68k_incpci (4);
}}}}}l_111103: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12+ (3/0) */

/* DIVS.W (d8,An,Xn),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_81f0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111104;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	if (src == 0) {
	m68k_incpci (4);
		Exception (5);
		goto l_111104;
	}
	CLEAR_CZNV ();
		count_cycles += ((getDivs68kCycles((uae_s32)dst, (uae_s16)src)) - 4) * CYCLE_UNIT / 2;
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	if (dst == 0x80000000 && src == -1) {
		SET_VFLG (1);
		SET_NFLG (1);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	}
	m68k_incpci (4);
}}}}}l_111104: ;
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14+ (3/0) */

/* DIVS.W (xxx).W,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_81f8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_111105;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	if (src == 0) {
	m68k_incpci (4);
		Exception (5);
		goto l_111105;
	}
	CLEAR_CZNV ();
		count_cycles += ((getDivs68kCycles((uae_s32)dst, (uae_s16)src)) - 4) * CYCLE_UNIT / 2;
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	if (dst == 0x80000000 && src == -1) {
		SET_VFLG (1);
		SET_NFLG (1);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	}
	m68k_incpci (4);
}}}}}l_111105: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12+ (3/0) */

/* DIVS.W (xxx).L,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_81f9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_111106;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	if (src == 0) {
	m68k_incpci (6);
		Exception (5);
		goto l_111106;
	}
	CLEAR_CZNV ();
		count_cycles += ((getDivs68kCycles((uae_s32)dst, (uae_s16)src)) - 4) * CYCLE_UNIT / 2;
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	if (dst == 0x80000000 && src == -1) {
		SET_VFLG (1);
		SET_NFLG (1);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	}
	m68k_incpci (6);
}}}}}l_111106: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16+ (4/0) */

/* DIVS.W (d16,PC),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_81fa_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111107;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	if (src == 0) {
	m68k_incpci (4);
		Exception (5);
		goto l_111107;
	}
	CLEAR_CZNV ();
		count_cycles += ((getDivs68kCycles((uae_s32)dst, (uae_s16)src)) - 4) * CYCLE_UNIT / 2;
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	if (dst == 0x80000000 && src == -1) {
		SET_VFLG (1);
		SET_NFLG (1);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	}
	m68k_incpci (4);
}}}}}l_111107: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12+ (3/0) */

/* DIVS.W (d8,PC,Xn),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_81fb_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	srca = get_disp_ea_000 (tmppc, get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111108;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	if (src == 0) {
	m68k_incpci (4);
		Exception (5);
		goto l_111108;
	}
	CLEAR_CZNV ();
		count_cycles += ((getDivs68kCycles((uae_s32)dst, (uae_s16)src)) - 4) * CYCLE_UNIT / 2;
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	if (dst == 0x80000000 && src == -1) {
		SET_VFLG (1);
		SET_NFLG (1);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	}
	m68k_incpci (4);
}}}}}l_111108: ;
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14+ (3/0) */

/* DIVS.W #<data>.W,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_81fc_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	if (src == 0) {
	m68k_incpci (4);
		Exception (5);
		goto l_111109;
	}
	CLEAR_CZNV ();
		count_cycles += ((getDivs68kCycles((uae_s32)dst, (uae_s16)src)) - 4) * CYCLE_UNIT / 2;
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	if (dst == 0x80000000 && src == -1) {
		SET_VFLG (1);
		SET_NFLG (1);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			SET_VFLG (1);
			SET_NFLG (1);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_NFLG (((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg (regs, dstreg) = (newv);
		}
	}
	m68k_incpci (4);
}}}l_111109: ;
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8+ (2/0) */

/* SUB.B Dn,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_9000_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}	m68k_incpci (2);
return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4 (1/0) */

/* SUB.B (An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_9010_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_000 (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (2/0) */

/* SUB.B (An)+,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_9018_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_000 (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (2/0) */

/* SUB.B -(An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_9020_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte_000 (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpci (2);
return 10 * CYCLE_UNIT / 2 + count_cycles;
} /* 10 (2/0) */

/* SUB.B (d16,An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_9028_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 src = get_byte_000 (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpci (4);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (3/0) */

/* SUB.B (d8,An,Xn),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_9030_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
{	uae_s8 src = get_byte_000 (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpci (4);
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (3/0) */

/* SUB.B (xxx).W,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_9038_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 src = get_byte_000 (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpci (4);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (3/0) */

/* SUB.B (xxx).L,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_9039_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
{	uae_s8 src = get_byte_000 (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpci (6);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (4/0) */

/* SUB.B (d16,PC),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_903a_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 src = get_byte_000 (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpci (4);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (3/0) */

/* SUB.B (d8,PC,Xn),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_903b_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	srca = get_disp_ea_000 (tmppc, get_word_000_prefetch (4));
{	uae_s8 src = get_byte_000 (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpci (4);
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (3/0) */

/* SUB.B #<data>.B,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_903c_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = (uae_u8)get_word_000_prefetch (4);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}	m68k_incpci (4);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (2/0) */

/* SUB.W Dn,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_9040_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}	m68k_incpci (2);
return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4 (1/0) */

/* SUB.W An,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_9048_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_areg (regs, srcreg);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}	m68k_incpci (2);
return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4 (1/0) */

/* SUB.W (An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_9050_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111123;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}}	m68k_incpci (2);
l_111123: ;
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (2/0) */

/* SUB.W (An)+,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_9058_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111124;
	}
{{	uae_s16 src = get_word_000 (srca);
	m68k_areg (regs, srcreg) += 2;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}}	m68k_incpci (2);
l_111124: ;
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (2/0) */

/* SUB.W -(An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_9060_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_111125;
	}
{{	uae_s16 src = get_word_000 (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}}	m68k_incpci (2);
l_111125: ;
return 10 * CYCLE_UNIT / 2 + count_cycles;
} /* 10 (2/0) */

/* SUB.W (d16,An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_9068_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111126;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}}	m68k_incpci (4);
l_111126: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (3/0) */

/* SUB.W (d8,An,Xn),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_9070_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111127;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}}	m68k_incpci (4);
l_111127: ;
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (3/0) */

/* SUB.W (xxx).W,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_9078_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_111128;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}}	m68k_incpci (4);
l_111128: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (3/0) */

/* SUB.W (xxx).L,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_9079_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_111129;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}}	m68k_incpci (6);
l_111129: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (4/0) */

/* SUB.W (d16,PC),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_907a_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111130;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}}	m68k_incpci (4);
l_111130: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (3/0) */

/* SUB.W (d8,PC,Xn),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_907b_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	srca = get_disp_ea_000 (tmppc, get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111131;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}}	m68k_incpci (4);
l_111131: ;
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (3/0) */

/* SUB.W #<data>.W,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_907c_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}	m68k_incpci (4);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (2/0) */

/* SUB.L Dn,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_9080_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/0) */

/* SUB.L An,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_9088_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/0) */

/* SUB.L (An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_9090_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111135;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}}	m68k_incpci (2);
l_111135: ;
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (3/0) */

/* SUB.L (An)+,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_9098_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111136;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
	m68k_areg (regs, srcreg) += 4;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}}	m68k_incpci (2);
l_111136: ;
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (3/0) */

/* SUB.L -(An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_90a0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_111137;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}}	m68k_incpci (2);
l_111137: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/0) */

/* SUB.L (d16,An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_90a8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111138;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}}	m68k_incpci (4);
l_111138: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (4/0) */

/* SUB.L (d8,An,Xn),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_90b0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111139;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}}	m68k_incpci (4);
l_111139: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/0) */

/* SUB.L (xxx).W,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_90b8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_111140;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}}	m68k_incpci (4);
l_111140: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (4/0) */

/* SUB.L (xxx).L,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_90b9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_111141;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}}	m68k_incpci (6);
l_111141: ;
return 22 * CYCLE_UNIT / 2 + count_cycles;
} /* 22 (5/0) */

/* SUB.L (d16,PC),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_90ba_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111142;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}}	m68k_incpci (4);
l_111142: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (4/0) */

/* SUB.L (d8,PC,Xn),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_90bb_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	srca = get_disp_ea_000 (tmppc, get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111143;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}}	m68k_incpci (4);
l_111143: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/0) */

/* SUB.L #<data>.L,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_90bc_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src;
	src = get_word_000_prefetch (4) << 16;
	src |= get_word_000_prefetch (6);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (6);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/0) */

/* SUBA.W Dn,An */
uae_u32 REGPARAM2 CPUFUNC(op_90c0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/0) */

/* SUBA.W An,An */
uae_u32 REGPARAM2 CPUFUNC(op_90c8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_areg (regs, srcreg);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/0) */

/* SUBA.W (An),An */
uae_u32 REGPARAM2 CPUFUNC(op_90d0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111147;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (2);
l_111147: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/0) */

/* SUBA.W (An)+,An */
uae_u32 REGPARAM2 CPUFUNC(op_90d8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111148;
	}
{{	uae_s16 src = get_word_000 (srca);
	m68k_areg (regs, srcreg) += 2;
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (2);
l_111148: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/0) */

/* SUBA.W -(An),An */
uae_u32 REGPARAM2 CPUFUNC(op_90e0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_111149;
	}
{{	uae_s16 src = get_word_000 (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (2);
l_111149: ;
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (2/0) */

/* SUBA.W (d16,An),An */
uae_u32 REGPARAM2 CPUFUNC(op_90e8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111150;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (4);
l_111150: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/0) */

/* SUBA.W (d8,An,Xn),An */
uae_u32 REGPARAM2 CPUFUNC(op_90f0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111151;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (4);
l_111151: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/0) */

/* SUBA.W (xxx).W,An */
uae_u32 REGPARAM2 CPUFUNC(op_90f8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_111152;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (4);
l_111152: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/0) */

/* SUBA.W (xxx).L,An */
uae_u32 REGPARAM2 CPUFUNC(op_90f9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_111153;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (6);
l_111153: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/0) */

/* SUBA.W (d16,PC),An */
uae_u32 REGPARAM2 CPUFUNC(op_90fa_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111154;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (4);
l_111154: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/0) */

/* SUBA.W (d8,PC,Xn),An */
uae_u32 REGPARAM2 CPUFUNC(op_90fb_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	srca = get_disp_ea_000 (tmppc, get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111155;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (4);
l_111155: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/0) */

/* SUBA.W #<data>.W,An */
uae_u32 REGPARAM2 CPUFUNC(op_90fc_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpci (4);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/0) */

/* SUBX.B Dn,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_9100_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 newv = dst - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}	m68k_incpci (2);
return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4 (1/0) */

/* SUBX.B -(An),-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_9108_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte_000 (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte_000 (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 newv = dst - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	put_byte_000 (dsta, newv);
}}}}}}}	m68k_incpci (2);
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/1) */

/* SUB.B Dn,(An) */
uae_u32 REGPARAM2 CPUFUNC(op_9110_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_byte_000 (dsta, newv);
}}}}}}}	m68k_incpci (2);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* SUB.B Dn,(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_9118_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_000 (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_byte_000 (dsta, newv);
}}}}}}}	m68k_incpci (2);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* SUB.B Dn,-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_9120_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte_000 (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_byte_000 (dsta, newv);
}}}}}}}	m68k_incpci (2);
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (2/1) */

/* SUB.B Dn,(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_9128_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_byte_000 (dsta, newv);
}}}}}}}	m68k_incpci (4);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* SUB.B Dn,(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_9130_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (4));
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_byte_000 (dsta, newv);
}}}}}}}	m68k_incpci (4);
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/1) */

/* SUB.B Dn,(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_9138_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_byte_000 (dsta, newv);
}}}}}}}	m68k_incpci (4);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* SUB.B Dn,(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_9139_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_word_000_prefetch (4) << 16;
	dsta |= get_word_000_prefetch (6);
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_byte_000 (dsta, newv);
}}}}}}}	m68k_incpci (6);
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* SUBX.W Dn,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_9140_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 newv = dst - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s16)(newv)) == 0));
	SET_NFLG (((uae_s16)(newv)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}	m68k_incpci (2);
return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4 (1/0) */

/* SUBX.W -(An),-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_9148_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111167;
	}
{{	uae_s16 src = get_word_000 (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_111167;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 newv = dst - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s16)(newv)) == 0));
	SET_NFLG (((uae_s16)(newv)) < 0);
	put_word_000 (dsta, newv);
}}}}}}}}}	m68k_incpci (2);
l_111167: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/1) */

/* SUB.W Dn,(An) */
uae_u32 REGPARAM2 CPUFUNC(op_9150_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_111168;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta, newv);
}}}}}}}}	m68k_incpci (2);
l_111168: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* SUB.W Dn,(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_9158_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_111169;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	m68k_areg (regs, dstreg) += 2;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta, newv);
}}}}}}}}	m68k_incpci (2);
l_111169: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* SUB.W Dn,-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_9160_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_111170;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta, newv);
}}}}}}}}	m68k_incpci (2);
l_111170: ;
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (2/1) */

/* SUB.W Dn,(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_9168_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_111171;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta, newv);
}}}}}}}}	m68k_incpci (4);
l_111171: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* SUB.W Dn,(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_9170_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (4));
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_111172;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta, newv);
}}}}}}}}	m68k_incpci (4);
l_111172: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/1) */

/* SUB.W Dn,(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_9178_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_111173;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta, newv);
}}}}}}}}	m68k_incpci (4);
l_111173: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* SUB.W Dn,(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_9179_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_word_000_prefetch (4) << 16;
	dsta |= get_word_000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_read(opcode, dsta);
		goto l_111174;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta, newv);
}}}}}}}}	m68k_incpci (6);
l_111174: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* SUBX.L Dn,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_9180_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 newv = dst - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s32)(newv)) == 0));
	SET_NFLG (((uae_s32)(newv)) < 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/0) */

/* SUBX.L -(An),-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_9188_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111176;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_111176;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 newv = dst - src - (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG ((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s32)(newv)) == 0));
	SET_NFLG (((uae_s32)(newv)) < 0);
	put_word_000 (dsta, newv >> 16); put_word_000 (dsta + 2, newv);
}}}}}}}}}	m68k_incpci (2);
l_111176: ;
return 30 * CYCLE_UNIT / 2 + count_cycles;
} /* 30 (5/2) */

/* SUB.L Dn,(An) */
uae_u32 REGPARAM2 CPUFUNC(op_9190_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_111177;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta + 2, newv); put_word_000 (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (2);
l_111177: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (3/2) */

/* SUB.L Dn,(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_9198_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_111178;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	m68k_areg (regs, dstreg) += 4;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta + 2, newv); put_word_000 (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (2);
l_111178: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (3/2) */

/* SUB.L Dn,-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_91a0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_111179;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta + 2, newv); put_word_000 (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (2);
l_111179: ;
return 22 * CYCLE_UNIT / 2 + count_cycles;
} /* 22 (3/2) */

/* SUB.L Dn,(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_91a8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_111180;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta + 2, newv); put_word_000 (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (4);
l_111180: ;
return 24 * CYCLE_UNIT / 2 + count_cycles;
} /* 24 (4/2) */

/* SUB.L Dn,(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_91b0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (4));
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_111181;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta + 2, newv); put_word_000 (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (4);
l_111181: ;
return 26 * CYCLE_UNIT / 2 + count_cycles;
} /* 26 (4/2) */

/* SUB.L Dn,(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_91b8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_111182;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta + 2, newv); put_word_000 (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (4);
l_111182: ;
return 24 * CYCLE_UNIT / 2 + count_cycles;
} /* 24 (4/2) */

/* SUB.L Dn,(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_91b9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_word_000_prefetch (4) << 16;
	dsta |= get_word_000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_read(opcode, dsta);
		goto l_111183;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta + 2, newv); put_word_000 (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (6);
l_111183: ;
return 28 * CYCLE_UNIT / 2 + count_cycles;
} /* 28 (5/2) */

/* SUBA.L Dn,An */
uae_u32 REGPARAM2 CPUFUNC(op_91c0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/0) */

/* SUBA.L An,An */
uae_u32 REGPARAM2 CPUFUNC(op_91c8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/0) */

/* SUBA.L (An),An */
uae_u32 REGPARAM2 CPUFUNC(op_91d0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111186;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (2);
l_111186: ;
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (3/0) */

/* SUBA.L (An)+,An */
uae_u32 REGPARAM2 CPUFUNC(op_91d8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111187;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
	m68k_areg (regs, srcreg) += 4;
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (2);
l_111187: ;
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (3/0) */

/* SUBA.L -(An),An */
uae_u32 REGPARAM2 CPUFUNC(op_91e0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_111188;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (2);
l_111188: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/0) */

/* SUBA.L (d16,An),An */
uae_u32 REGPARAM2 CPUFUNC(op_91e8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111189;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (4);
l_111189: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (4/0) */

/* SUBA.L (d8,An,Xn),An */
uae_u32 REGPARAM2 CPUFUNC(op_91f0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111190;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (4);
l_111190: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/0) */

/* SUBA.L (xxx).W,An */
uae_u32 REGPARAM2 CPUFUNC(op_91f8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_111191;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (4);
l_111191: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (4/0) */

/* SUBA.L (xxx).L,An */
uae_u32 REGPARAM2 CPUFUNC(op_91f9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_111192;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (6);
l_111192: ;
return 22 * CYCLE_UNIT / 2 + count_cycles;
} /* 22 (5/0) */

/* SUBA.L (d16,PC),An */
uae_u32 REGPARAM2 CPUFUNC(op_91fa_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111193;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (4);
l_111193: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (4/0) */

/* SUBA.L (d8,PC,Xn),An */
uae_u32 REGPARAM2 CPUFUNC(op_91fb_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	srca = get_disp_ea_000 (tmppc, get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111194;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (4);
l_111194: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/0) */

/* SUBA.L #<data>.L,An */
uae_u32 REGPARAM2 CPUFUNC(op_91fc_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src;
	src = get_word_000_prefetch (4) << 16;
	src |= get_word_000_prefetch (6);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{	uae_u32 newv = dst - src;
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpci (6);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/0) */

/* CMP.B Dn,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_b000_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}	m68k_incpci (2);
return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4 (1/0) */

/* CMP.B (An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_b010_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_000 (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (2/0) */

/* CMP.B (An)+,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_b018_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_000 (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (2/0) */

/* CMP.B -(An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_b020_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte_000 (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (2);
return 10 * CYCLE_UNIT / 2 + count_cycles;
} /* 10 (2/0) */

/* CMP.B (d16,An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_b028_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 src = get_byte_000 (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (4);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (3/0) */

/* CMP.B (d8,An,Xn),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_b030_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
{	uae_s8 src = get_byte_000 (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (4);
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (3/0) */

/* CMP.B (xxx).W,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_b038_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 src = get_byte_000 (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (4);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (3/0) */

/* CMP.B (xxx).L,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_b039_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
{	uae_s8 src = get_byte_000 (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (6);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (4/0) */

/* CMP.B (d16,PC),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_b03a_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 src = get_byte_000 (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (4);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (3/0) */

/* CMP.B (d8,PC,Xn),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_b03b_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	srca = get_disp_ea_000 (tmppc, get_word_000_prefetch (4));
{	uae_s8 src = get_byte_000 (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}	m68k_incpci (4);
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (3/0) */

/* CMP.B #<data>.B,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_b03c_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = (uae_u8)get_word_000_prefetch (4);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}	m68k_incpci (4);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (2/0) */

/* CMP.W Dn,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_b040_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}	m68k_incpci (2);
return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4 (1/0) */

/* CMP.W An,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_b048_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_areg (regs, srcreg);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}	m68k_incpci (2);
return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4 (1/0) */

/* CMP.W (An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_b050_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111209;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (2);
l_111209: ;
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (2/0) */

/* CMP.W (An)+,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_b058_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111210;
	}
{{	uae_s16 src = get_word_000 (srca);
	m68k_areg (regs, srcreg) += 2;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (2);
l_111210: ;
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (2/0) */

/* CMP.W -(An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_b060_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_111211;
	}
{{	uae_s16 src = get_word_000 (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (2);
l_111211: ;
return 10 * CYCLE_UNIT / 2 + count_cycles;
} /* 10 (2/0) */

/* CMP.W (d16,An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_b068_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111212;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (4);
l_111212: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (3/0) */

/* CMP.W (d8,An,Xn),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_b070_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111213;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (4);
l_111213: ;
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (3/0) */

/* CMP.W (xxx).W,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_b078_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_111214;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (4);
l_111214: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (3/0) */

/* CMP.W (xxx).L,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_b079_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_111215;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (6);
l_111215: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (4/0) */

/* CMP.W (d16,PC),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_b07a_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111216;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (4);
l_111216: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (3/0) */

/* CMP.W (d8,PC,Xn),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_b07b_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	srca = get_disp_ea_000 (tmppc, get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111217;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (4);
l_111217: ;
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (3/0) */

/* CMP.W #<data>.W,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_b07c_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}	m68k_incpci (4);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (2/0) */

/* CMP.L Dn,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_b080_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}	m68k_incpci (2);
return 6 * CYCLE_UNIT / 2 + count_cycles;
} /* 6 (1/0) */

/* CMP.L An,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_b088_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}	m68k_incpci (2);
return 6 * CYCLE_UNIT / 2 + count_cycles;
} /* 6 (1/0) */

/* CMP.L (An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_b090_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111221;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (2);
l_111221: ;
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (3/0) */

/* CMP.L (An)+,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_b098_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111222;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
	m68k_areg (regs, srcreg) += 4;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (2);
l_111222: ;
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (3/0) */

/* CMP.L -(An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_b0a0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_111223;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (2);
l_111223: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/0) */

#endif

#ifdef PART_7
/* CMP.L (d16,An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_b0a8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111224;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (4);
l_111224: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (4/0) */

/* CMP.L (d8,An,Xn),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_b0b0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111225;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (4);
l_111225: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/0) */

/* CMP.L (xxx).W,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_b0b8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_111226;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (4);
l_111226: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (4/0) */

/* CMP.L (xxx).L,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_b0b9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_111227;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (6);
l_111227: ;
return 22 * CYCLE_UNIT / 2 + count_cycles;
} /* 22 (5/0) */

/* CMP.L (d16,PC),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_b0ba_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111228;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (4);
l_111228: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (4/0) */

/* CMP.L (d8,PC,Xn),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_b0bb_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	srca = get_disp_ea_000 (tmppc, get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111229;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (4);
l_111229: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/0) */

/* CMP.L #<data>.L,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_b0bc_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src;
	src = get_word_000_prefetch (4) << 16;
	src |= get_word_000_prefetch (6);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}	m68k_incpci (6);
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (3/0) */

/* CMPA.W Dn,An */
uae_u32 REGPARAM2 CPUFUNC(op_b0c0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}	m68k_incpci (2);
return 6 * CYCLE_UNIT / 2 + count_cycles;
} /* 6 (1/0) */

/* CMPA.W An,An */
uae_u32 REGPARAM2 CPUFUNC(op_b0c8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_areg (regs, srcreg);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}	m68k_incpci (2);
return 6 * CYCLE_UNIT / 2 + count_cycles;
} /* 6 (1/0) */

/* CMPA.W (An),An */
uae_u32 REGPARAM2 CPUFUNC(op_b0d0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111233;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (2);
l_111233: ;
return 10 * CYCLE_UNIT / 2 + count_cycles;
} /* 10 (2/0) */

/* CMPA.W (An)+,An */
uae_u32 REGPARAM2 CPUFUNC(op_b0d8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111234;
	}
{{	uae_s16 src = get_word_000 (srca);
	m68k_areg (regs, srcreg) += 2;
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (2);
l_111234: ;
return 10 * CYCLE_UNIT / 2 + count_cycles;
} /* 10 (2/0) */

/* CMPA.W -(An),An */
uae_u32 REGPARAM2 CPUFUNC(op_b0e0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_111235;
	}
{{	uae_s16 src = get_word_000 (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (2);
l_111235: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/0) */

/* CMPA.W (d16,An),An */
uae_u32 REGPARAM2 CPUFUNC(op_b0e8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111236;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (4);
l_111236: ;
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (3/0) */

/* CMPA.W (d8,An,Xn),An */
uae_u32 REGPARAM2 CPUFUNC(op_b0f0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111237;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (4);
l_111237: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/0) */

/* CMPA.W (xxx).W,An */
uae_u32 REGPARAM2 CPUFUNC(op_b0f8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_111238;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (4);
l_111238: ;
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (3/0) */

/* CMPA.W (xxx).L,An */
uae_u32 REGPARAM2 CPUFUNC(op_b0f9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_111239;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (6);
l_111239: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (4/0) */

/* CMPA.W (d16,PC),An */
uae_u32 REGPARAM2 CPUFUNC(op_b0fa_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111240;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (4);
l_111240: ;
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (3/0) */

/* CMPA.W (d8,PC,Xn),An */
uae_u32 REGPARAM2 CPUFUNC(op_b0fb_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	srca = get_disp_ea_000 (tmppc, get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111241;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (4);
l_111241: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/0) */

/* CMPA.W #<data>.W,An */
uae_u32 REGPARAM2 CPUFUNC(op_b0fc_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}	m68k_incpci (4);
return 10 * CYCLE_UNIT / 2 + count_cycles;
} /* 10 (2/0) */

/* EOR.B Dn,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_b100_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}	m68k_incpci (2);
return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4 (1/0) */

/* CMPM.B (An)+,(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_b108_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_000 (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_000 (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (2);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (3/0) */

/* EOR.B Dn,(An) */
uae_u32 REGPARAM2 CPUFUNC(op_b110_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_000 (dsta);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	put_byte_000 (dsta, src);
}}}}	m68k_incpci (2);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* EOR.B Dn,(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_b118_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_000 (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	put_byte_000 (dsta, src);
}}}}	m68k_incpci (2);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* EOR.B Dn,-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_b120_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte_000 (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	put_byte_000 (dsta, src);
}}}}	m68k_incpci (2);
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (2/1) */

/* EOR.B Dn,(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_b128_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 dst = get_byte_000 (dsta);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	put_byte_000 (dsta, src);
}}}}	m68k_incpci (4);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* EOR.B Dn,(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_b130_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (4));
{	uae_s8 dst = get_byte_000 (dsta);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	put_byte_000 (dsta, src);
}}}}	m68k_incpci (4);
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/1) */

/* EOR.B Dn,(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_b138_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 dst = get_byte_000 (dsta);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	put_byte_000 (dsta, src);
}}}}	m68k_incpci (4);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* EOR.B Dn,(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_b139_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_word_000_prefetch (4) << 16;
	dsta |= get_word_000_prefetch (6);
{	uae_s8 dst = get_byte_000 (dsta);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	put_byte_000 (dsta, src);
}}}}	m68k_incpci (6);
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* EOR.W Dn,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_b140_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}	m68k_incpci (2);
return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4 (1/0) */

/* CMPM.W (An)+,(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_b148_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111253;
	}
{{	uae_s16 src = get_word_000 (srca);
	m68k_areg (regs, srcreg) += 2;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_111253;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	m68k_areg (regs, dstreg) += 2;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}}}	m68k_incpci (2);
l_111253: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (3/0) */

/* EOR.W Dn,(An) */
uae_u32 REGPARAM2 CPUFUNC(op_b150_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_111254;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	put_word_000 (dsta, src);
}}}}}	m68k_incpci (2);
l_111254: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* EOR.W Dn,(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_b158_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_111255;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	m68k_areg (regs, dstreg) += 2;
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	put_word_000 (dsta, src);
}}}}}	m68k_incpci (2);
l_111255: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* EOR.W Dn,-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_b160_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_111256;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	put_word_000 (dsta, src);
}}}}}	m68k_incpci (2);
l_111256: ;
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (2/1) */

/* EOR.W Dn,(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_b168_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_111257;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	put_word_000 (dsta, src);
}}}}}	m68k_incpci (4);
l_111257: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* EOR.W Dn,(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_b170_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (4));
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_111258;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	put_word_000 (dsta, src);
}}}}}	m68k_incpci (4);
l_111258: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/1) */

/* EOR.W Dn,(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_b178_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_111259;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	put_word_000 (dsta, src);
}}}}}	m68k_incpci (4);
l_111259: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* EOR.W Dn,(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_b179_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_word_000_prefetch (4) << 16;
	dsta |= get_word_000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_read(opcode, dsta);
		goto l_111260;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	put_word_000 (dsta, src);
}}}}}	m68k_incpci (6);
l_111260: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* EOR.L Dn,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_b180_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	m68k_dreg (regs, dstreg) = (src);
}}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/0) */

/* CMPM.L (An)+,(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_b188_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111262;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
	m68k_areg (regs, srcreg) += 4;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_111262;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	m68k_areg (regs, dstreg) += 4;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}}}	m68k_incpci (2);
l_111262: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (5/0) */

/* EOR.L Dn,(An) */
uae_u32 REGPARAM2 CPUFUNC(op_b190_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_111263;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	put_word_000 (dsta + 2, src); put_word_000 (dsta, src >> 16);
}}}}}	m68k_incpci (2);
l_111263: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (3/2) */

/* EOR.L Dn,(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_b198_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_111264;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	m68k_areg (regs, dstreg) += 4;
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	put_word_000 (dsta + 2, src); put_word_000 (dsta, src >> 16);
}}}}}	m68k_incpci (2);
l_111264: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (3/2) */

/* EOR.L Dn,-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_b1a0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_111265;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	m68k_areg (regs, dstreg) = dsta;
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	put_word_000 (dsta + 2, src); put_word_000 (dsta, src >> 16);
}}}}}	m68k_incpci (2);
l_111265: ;
return 22 * CYCLE_UNIT / 2 + count_cycles;
} /* 22 (3/2) */

/* EOR.L Dn,(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_b1a8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_111266;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	put_word_000 (dsta + 2, src); put_word_000 (dsta, src >> 16);
}}}}}	m68k_incpci (4);
l_111266: ;
return 24 * CYCLE_UNIT / 2 + count_cycles;
} /* 24 (4/2) */

/* EOR.L Dn,(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_b1b0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (4));
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_111267;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	put_word_000 (dsta + 2, src); put_word_000 (dsta, src >> 16);
}}}}}	m68k_incpci (4);
l_111267: ;
return 26 * CYCLE_UNIT / 2 + count_cycles;
} /* 26 (4/2) */

/* EOR.L Dn,(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_b1b8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_111268;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	put_word_000 (dsta + 2, src); put_word_000 (dsta, src >> 16);
}}}}}	m68k_incpci (4);
l_111268: ;
return 24 * CYCLE_UNIT / 2 + count_cycles;
} /* 24 (4/2) */

/* EOR.L Dn,(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_b1b9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_word_000_prefetch (4) << 16;
	dsta |= get_word_000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_read(opcode, dsta);
		goto l_111269;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	src ^= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	put_word_000 (dsta + 2, src); put_word_000 (dsta, src >> 16);
}}}}}	m68k_incpci (6);
l_111269: ;
return 28 * CYCLE_UNIT / 2 + count_cycles;
} /* 28 (5/2) */

/* CMPA.L Dn,An */
uae_u32 REGPARAM2 CPUFUNC(op_b1c0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}	m68k_incpci (2);
return 6 * CYCLE_UNIT / 2 + count_cycles;
} /* 6 (1/0) */

/* CMPA.L An,An */
uae_u32 REGPARAM2 CPUFUNC(op_b1c8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}	m68k_incpci (2);
return 6 * CYCLE_UNIT / 2 + count_cycles;
} /* 6 (1/0) */

/* CMPA.L (An),An */
uae_u32 REGPARAM2 CPUFUNC(op_b1d0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111272;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (2);
l_111272: ;
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (3/0) */

/* CMPA.L (An)+,An */
uae_u32 REGPARAM2 CPUFUNC(op_b1d8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111273;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
	m68k_areg (regs, srcreg) += 4;
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (2);
l_111273: ;
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (3/0) */

/* CMPA.L -(An),An */
uae_u32 REGPARAM2 CPUFUNC(op_b1e0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_111274;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (2);
l_111274: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/0) */

/* CMPA.L (d16,An),An */
uae_u32 REGPARAM2 CPUFUNC(op_b1e8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111275;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (4);
l_111275: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (4/0) */

/* CMPA.L (d8,An,Xn),An */
uae_u32 REGPARAM2 CPUFUNC(op_b1f0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111276;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (4);
l_111276: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/0) */

/* CMPA.L (xxx).W,An */
uae_u32 REGPARAM2 CPUFUNC(op_b1f8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_111277;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (4);
l_111277: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (4/0) */

/* CMPA.L (xxx).L,An */
uae_u32 REGPARAM2 CPUFUNC(op_b1f9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_111278;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (6);
l_111278: ;
return 22 * CYCLE_UNIT / 2 + count_cycles;
} /* 22 (5/0) */

/* CMPA.L (d16,PC),An */
uae_u32 REGPARAM2 CPUFUNC(op_b1fa_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111279;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (4);
l_111279: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (4/0) */

/* CMPA.L (d8,PC,Xn),An */
uae_u32 REGPARAM2 CPUFUNC(op_b1fb_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	srca = get_disp_ea_000 (tmppc, get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111280;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}}}	m68k_incpci (4);
l_111280: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/0) */

/* CMPA.L #<data>.L,An */
uae_u32 REGPARAM2 CPUFUNC(op_b1fc_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src;
	src = get_word_000_prefetch (4) << 16;
	src |= get_word_000_prefetch (6);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{{uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs != flgo) && (flgn != flgo));
	SET_CFLG (((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG (flgn != 0);
}}}}}}	m68k_incpci (6);
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (3/0) */

/* AND.B Dn,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_c000_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}	m68k_incpci (2);
return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4 (1/0) */

/* AND.B (An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_c010_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_000 (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (2/0) */

/* AND.B (An)+,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_c018_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_000 (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (2/0) */

/* AND.B -(An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_c020_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte_000 (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpci (2);
return 10 * CYCLE_UNIT / 2 + count_cycles;
} /* 10 (2/0) */

/* AND.B (d16,An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_c028_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 src = get_byte_000 (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpci (4);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (3/0) */

/* AND.B (d8,An,Xn),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_c030_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
{	uae_s8 src = get_byte_000 (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpci (4);
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (3/0) */

/* AND.B (xxx).W,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_c038_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 src = get_byte_000 (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpci (4);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (3/0) */

/* AND.B (xxx).L,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_c039_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
{	uae_s8 src = get_byte_000 (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpci (6);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (4/0) */

/* AND.B (d16,PC),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_c03a_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 src = get_byte_000 (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpci (4);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (3/0) */

/* AND.B (d8,PC,Xn),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_c03b_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	srca = get_disp_ea_000 (tmppc, get_word_000_prefetch (4));
{	uae_s8 src = get_byte_000 (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}}	m68k_incpci (4);
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (3/0) */

/* AND.B #<data>.B,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_c03c_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = (uae_u8)get_word_000_prefetch (4);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((src) & 0xff);
}}}	m68k_incpci (4);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (2/0) */

/* AND.W Dn,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_c040_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}	m68k_incpci (2);
return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4 (1/0) */

/* AND.W (An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_c050_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111294;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}	m68k_incpci (2);
l_111294: ;
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (2/0) */

/* AND.W (An)+,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_c058_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111295;
	}
{{	uae_s16 src = get_word_000 (srca);
	m68k_areg (regs, srcreg) += 2;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}	m68k_incpci (2);
l_111295: ;
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (2/0) */

/* AND.W -(An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_c060_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_111296;
	}
{{	uae_s16 src = get_word_000 (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}	m68k_incpci (2);
l_111296: ;
return 10 * CYCLE_UNIT / 2 + count_cycles;
} /* 10 (2/0) */

/* AND.W (d16,An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_c068_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111297;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}	m68k_incpci (4);
l_111297: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (3/0) */

/* AND.W (d8,An,Xn),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_c070_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111298;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}	m68k_incpci (4);
l_111298: ;
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (3/0) */

/* AND.W (xxx).W,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_c078_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_111299;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}	m68k_incpci (4);
l_111299: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (3/0) */

/* AND.W (xxx).L,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_c079_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_111300;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}	m68k_incpci (6);
l_111300: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (4/0) */

/* AND.W (d16,PC),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_c07a_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111301;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}	m68k_incpci (4);
l_111301: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (3/0) */

/* AND.W (d8,PC,Xn),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_c07b_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	srca = get_disp_ea_000 (tmppc, get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111302;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}}}	m68k_incpci (4);
l_111302: ;
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (3/0) */

/* AND.W #<data>.W,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_c07c_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((src) & 0xffff);
}}}	m68k_incpci (4);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (2/0) */

/* AND.L Dn,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_c080_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	m68k_dreg (regs, dstreg) = (src);
}}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/0) */

/* AND.L (An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_c090_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111305;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	m68k_dreg (regs, dstreg) = (src);
}}}}}	m68k_incpci (2);
l_111305: ;
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (3/0) */

/* AND.L (An)+,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_c098_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111306;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
	m68k_areg (regs, srcreg) += 4;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	m68k_dreg (regs, dstreg) = (src);
}}}}}	m68k_incpci (2);
l_111306: ;
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (3/0) */

/* AND.L -(An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_c0a0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_111307;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	m68k_dreg (regs, dstreg) = (src);
}}}}}	m68k_incpci (2);
l_111307: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/0) */

/* AND.L (d16,An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_c0a8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111308;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	m68k_dreg (regs, dstreg) = (src);
}}}}}	m68k_incpci (4);
l_111308: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (4/0) */

/* AND.L (d8,An,Xn),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_c0b0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111309;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	m68k_dreg (regs, dstreg) = (src);
}}}}}	m68k_incpci (4);
l_111309: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/0) */

/* AND.L (xxx).W,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_c0b8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_111310;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	m68k_dreg (regs, dstreg) = (src);
}}}}}	m68k_incpci (4);
l_111310: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (4/0) */

/* AND.L (xxx).L,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_c0b9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_111311;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	m68k_dreg (regs, dstreg) = (src);
}}}}}	m68k_incpci (6);
l_111311: ;
return 22 * CYCLE_UNIT / 2 + count_cycles;
} /* 22 (5/0) */

/* AND.L (d16,PC),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_c0ba_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111312;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	m68k_dreg (regs, dstreg) = (src);
}}}}}	m68k_incpci (4);
l_111312: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (4/0) */

/* AND.L (d8,PC,Xn),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_c0bb_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	srca = get_disp_ea_000 (tmppc, get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111313;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	m68k_dreg (regs, dstreg) = (src);
}}}}}	m68k_incpci (4);
l_111313: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/0) */

/* AND.L #<data>.L,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_c0bc_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src;
	src = get_word_000_prefetch (4) << 16;
	src |= get_word_000_prefetch (6);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	m68k_dreg (regs, dstreg) = (src);
}}}	m68k_incpci (6);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/0) */

/* MULU.W Dn,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_c0c0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	int bits;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	for(bits = 0; bits < 16 && src; bits++, src >>= 1)
		if (src & 1) count_cycles += 2 * CYCLE_UNIT / 2;
	m68k_dreg (regs, dstreg) = (newv);
	m68k_incpci (2);
}}}}return 38 * CYCLE_UNIT / 2 + count_cycles;
} /* 38+ (1/0) */

/* MULU.W (An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_c0d0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111316;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	int bits;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	for(bits = 0; bits < 16 && src; bits++, src >>= 1)
		if (src & 1) count_cycles += 2 * CYCLE_UNIT / 2;
	m68k_dreg (regs, dstreg) = (newv);
	m68k_incpci (2);
}}}}}}l_111316: ;
return 42 * CYCLE_UNIT / 2 + count_cycles;
} /* 42+ (2/0) */

/* MULU.W (An)+,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_c0d8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111317;
	}
{{	uae_s16 src = get_word_000 (srca);
	m68k_areg (regs, srcreg) += 2;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	int bits;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	for(bits = 0; bits < 16 && src; bits++, src >>= 1)
		if (src & 1) count_cycles += 2 * CYCLE_UNIT / 2;
	m68k_dreg (regs, dstreg) = (newv);
	m68k_incpci (2);
}}}}}}l_111317: ;
return 42 * CYCLE_UNIT / 2 + count_cycles;
} /* 42+ (2/0) */

/* MULU.W -(An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_c0e0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_111318;
	}
{{	uae_s16 src = get_word_000 (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	int bits;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	for(bits = 0; bits < 16 && src; bits++, src >>= 1)
		if (src & 1) count_cycles += 2 * CYCLE_UNIT / 2;
	m68k_dreg (regs, dstreg) = (newv);
	m68k_incpci (2);
}}}}}}l_111318: ;
return 44 * CYCLE_UNIT / 2 + count_cycles;
} /* 44+ (2/0) */

/* MULU.W (d16,An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_c0e8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111319;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	int bits;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	for(bits = 0; bits < 16 && src; bits++, src >>= 1)
		if (src & 1) count_cycles += 2 * CYCLE_UNIT / 2;
	m68k_dreg (regs, dstreg) = (newv);
	m68k_incpci (4);
}}}}}}l_111319: ;
return 46 * CYCLE_UNIT / 2 + count_cycles;
} /* 46+ (3/0) */

/* MULU.W (d8,An,Xn),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_c0f0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111320;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	int bits;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	for(bits = 0; bits < 16 && src; bits++, src >>= 1)
		if (src & 1) count_cycles += 2 * CYCLE_UNIT / 2;
	m68k_dreg (regs, dstreg) = (newv);
	m68k_incpci (4);
}}}}}}l_111320: ;
return 48 * CYCLE_UNIT / 2 + count_cycles;
} /* 48+ (3/0) */

/* MULU.W (xxx).W,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_c0f8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_111321;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	int bits;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	for(bits = 0; bits < 16 && src; bits++, src >>= 1)
		if (src & 1) count_cycles += 2 * CYCLE_UNIT / 2;
	m68k_dreg (regs, dstreg) = (newv);
	m68k_incpci (4);
}}}}}}l_111321: ;
return 46 * CYCLE_UNIT / 2 + count_cycles;
} /* 46+ (3/0) */

/* MULU.W (xxx).L,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_c0f9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_111322;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	int bits;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	for(bits = 0; bits < 16 && src; bits++, src >>= 1)
		if (src & 1) count_cycles += 2 * CYCLE_UNIT / 2;
	m68k_dreg (regs, dstreg) = (newv);
	m68k_incpci (6);
}}}}}}l_111322: ;
return 50 * CYCLE_UNIT / 2 + count_cycles;
} /* 50+ (4/0) */

/* MULU.W (d16,PC),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_c0fa_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111323;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	int bits;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	for(bits = 0; bits < 16 && src; bits++, src >>= 1)
		if (src & 1) count_cycles += 2 * CYCLE_UNIT / 2;
	m68k_dreg (regs, dstreg) = (newv);
	m68k_incpci (4);
}}}}}}l_111323: ;
return 46 * CYCLE_UNIT / 2 + count_cycles;
} /* 46+ (3/0) */

/* MULU.W (d8,PC,Xn),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_c0fb_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	srca = get_disp_ea_000 (tmppc, get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111324;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	int bits;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	for(bits = 0; bits < 16 && src; bits++, src >>= 1)
		if (src & 1) count_cycles += 2 * CYCLE_UNIT / 2;
	m68k_dreg (regs, dstreg) = (newv);
	m68k_incpci (4);
}}}}}}l_111324: ;
return 48 * CYCLE_UNIT / 2 + count_cycles;
} /* 48+ (3/0) */

/* MULU.W #<data>.W,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_c0fc_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	int bits;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	for(bits = 0; bits < 16 && src; bits++, src >>= 1)
		if (src & 1) count_cycles += 2 * CYCLE_UNIT / 2;
	m68k_dreg (regs, dstreg) = (newv);
	m68k_incpci (4);
}}}}return 42 * CYCLE_UNIT / 2 + count_cycles;
} /* 42+ (2/0) */

/* ABCD.B Dn,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_c100_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u16 newv_lo = (src & 0xF) + (dst & 0xF) + (GET_XFLG () ? 1 : 0);
	uae_u16 newv_hi = (src & 0xF0) + (dst & 0xF0);
	uae_u16 newv, tmp_newv;
	int cflg;
	newv = tmp_newv = newv_hi + newv_lo;	if (newv_lo > 9) { newv += 6; }
	cflg = (newv & 0x3F0) > 0x90;
	if (cflg) newv += 0x60;
	SET_CFLG (cflg);
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	SET_VFLG ((tmp_newv & 0x80) == 0 && (newv & 0x80) != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}	m68k_incpci (2);
return 6 * CYCLE_UNIT / 2 + count_cycles;
} /* 6 (1/0) */

/* ABCD.B -(An),-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_c108_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte_000 (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte_000 (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u16 newv_lo = (src & 0xF) + (dst & 0xF) + (GET_XFLG () ? 1 : 0);
	uae_u16 newv_hi = (src & 0xF0) + (dst & 0xF0);
	uae_u16 newv, tmp_newv;
	int cflg;
	newv = tmp_newv = newv_hi + newv_lo;	if (newv_lo > 9) { newv += 6; }
	cflg = (newv & 0x3F0) > 0x90;
	if (cflg) newv += 0x60;
	SET_CFLG (cflg);
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	SET_VFLG ((tmp_newv & 0x80) == 0 && (newv & 0x80) != 0);
	put_byte_000 (dsta, newv);
}}}}}}	m68k_incpci (2);
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/1) */

/* AND.B Dn,(An) */
uae_u32 REGPARAM2 CPUFUNC(op_c110_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_000 (dsta);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	put_byte_000 (dsta, src);
}}}}	m68k_incpci (2);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* AND.B Dn,(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_c118_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_000 (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	put_byte_000 (dsta, src);
}}}}	m68k_incpci (2);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* AND.B Dn,-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_c120_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte_000 (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	put_byte_000 (dsta, src);
}}}}	m68k_incpci (2);
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (2/1) */

/* AND.B Dn,(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_c128_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 dst = get_byte_000 (dsta);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	put_byte_000 (dsta, src);
}}}}	m68k_incpci (4);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* AND.B Dn,(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_c130_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (4));
{	uae_s8 dst = get_byte_000 (dsta);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	put_byte_000 (dsta, src);
}}}}	m68k_incpci (4);
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/1) */

/* AND.B Dn,(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_c138_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 dst = get_byte_000 (dsta);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	put_byte_000 (dsta, src);
}}}}	m68k_incpci (4);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* AND.B Dn,(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_c139_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_word_000_prefetch (4) << 16;
	dsta |= get_word_000_prefetch (6);
{	uae_s8 dst = get_byte_000 (dsta);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s8)(src)) == 0);
	SET_NFLG (((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	put_byte_000 (dsta, src);
}}}}	m68k_incpci (6);
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* EXG.L Dn,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_c140_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	m68k_dreg (regs, srcreg) = (dst);
	m68k_dreg (regs, dstreg) = (src);
}}}	m68k_incpci (2);
return 6 * CYCLE_UNIT / 2 + count_cycles;
} /* 6 (1/0) */

/* EXG.L An,An */
uae_u32 REGPARAM2 CPUFUNC(op_c148_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	m68k_areg (regs, srcreg) = (dst);
	m68k_areg (regs, dstreg) = (src);
}}}	m68k_incpci (2);
return 6 * CYCLE_UNIT / 2 + count_cycles;
} /* 6 (1/0) */

/* AND.W Dn,(An) */
uae_u32 REGPARAM2 CPUFUNC(op_c150_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_111337;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	put_word_000 (dsta, src);
}}}}}	m68k_incpci (2);
l_111337: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* AND.W Dn,(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_c158_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_111338;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	m68k_areg (regs, dstreg) += 2;
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	put_word_000 (dsta, src);
}}}}}	m68k_incpci (2);
l_111338: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* AND.W Dn,-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_c160_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_111339;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	m68k_areg (regs, dstreg) = dsta;
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	put_word_000 (dsta, src);
}}}}}	m68k_incpci (2);
l_111339: ;
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (2/1) */

/* AND.W Dn,(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_c168_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_111340;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	put_word_000 (dsta, src);
}}}}}	m68k_incpci (4);
l_111340: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* AND.W Dn,(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_c170_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (4));
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_111341;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	put_word_000 (dsta, src);
}}}}}	m68k_incpci (4);
l_111341: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/1) */

/* AND.W Dn,(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_c178_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_111342;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	put_word_000 (dsta, src);
}}}}}	m68k_incpci (4);
l_111342: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* AND.W Dn,(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_c179_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_word_000_prefetch (4) << 16;
	dsta |= get_word_000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_read(opcode, dsta);
		goto l_111343;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s16)(src)) == 0);
	SET_NFLG (((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	put_word_000 (dsta, src);
}}}}}	m68k_incpci (6);
l_111343: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* EXG.L Dn,An */
uae_u32 REGPARAM2 CPUFUNC(op_c188_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	m68k_dreg (regs, srcreg) = (dst);
	m68k_areg (regs, dstreg) = (src);
}}}	m68k_incpci (2);
return 6 * CYCLE_UNIT / 2 + count_cycles;
} /* 6 (1/0) */

/* AND.L Dn,(An) */
uae_u32 REGPARAM2 CPUFUNC(op_c190_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_111345;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	put_word_000 (dsta + 2, src); put_word_000 (dsta, src >> 16);
}}}}}	m68k_incpci (2);
l_111345: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (3/2) */

/* AND.L Dn,(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_c198_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_111346;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	m68k_areg (regs, dstreg) += 4;
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	put_word_000 (dsta + 2, src); put_word_000 (dsta, src >> 16);
}}}}}	m68k_incpci (2);
l_111346: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (3/2) */

/* AND.L Dn,-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_c1a0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_111347;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	m68k_areg (regs, dstreg) = dsta;
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
	put_word_000 (dsta + 2, src); put_word_000 (dsta, src >> 16);
}}}}}	m68k_incpci (2);
l_111347: ;
return 22 * CYCLE_UNIT / 2 + count_cycles;
} /* 22 (3/2) */

/* AND.L Dn,(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_c1a8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_111348;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	put_word_000 (dsta + 2, src); put_word_000 (dsta, src >> 16);
}}}}}	m68k_incpci (4);
l_111348: ;
return 24 * CYCLE_UNIT / 2 + count_cycles;
} /* 24 (4/2) */

/* AND.L Dn,(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_c1b0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (4));
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_111349;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	put_word_000 (dsta + 2, src); put_word_000 (dsta, src >> 16);
}}}}}	m68k_incpci (4);
l_111349: ;
return 26 * CYCLE_UNIT / 2 + count_cycles;
} /* 26 (4/2) */

/* AND.L Dn,(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_c1b8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_111350;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
	put_word_000 (dsta + 2, src); put_word_000 (dsta, src >> 16);
}}}}}	m68k_incpci (4);
l_111350: ;
return 24 * CYCLE_UNIT / 2 + count_cycles;
} /* 24 (4/2) */

/* AND.L Dn,(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_c1b9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_word_000_prefetch (4) << 16;
	dsta |= get_word_000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_read(opcode, dsta);
		goto l_111351;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	src &= dst;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(src)) == 0);
	SET_NFLG (((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
	put_word_000 (dsta + 2, src); put_word_000 (dsta, src >> 16);
}}}}}	m68k_incpci (6);
l_111351: ;
return 28 * CYCLE_UNIT / 2 + count_cycles;
} /* 28 (5/2) */

/* MULS.W Dn,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_c1c0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	int bits;
	uae_u32 usrc;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	usrc = ((uae_u32)src) << 1;
	for(bits = 0; bits < 16 && usrc; bits++, usrc >>= 1)
		if ((usrc & 3) == 1 || (usrc & 3) == 2) count_cycles += 2 * CYCLE_UNIT / 2;
	m68k_dreg (regs, dstreg) = (newv);
}}}}	m68k_incpci (2);
return 38 * CYCLE_UNIT / 2 + count_cycles;
} /* 38+ (1/0) */

/* MULS.W (An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_c1d0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111353;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	int bits;
	uae_u32 usrc;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	usrc = ((uae_u32)src) << 1;
	for(bits = 0; bits < 16 && usrc; bits++, usrc >>= 1)
		if ((usrc & 3) == 1 || (usrc & 3) == 2) count_cycles += 2 * CYCLE_UNIT / 2;
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (2);
l_111353: ;
return 42 * CYCLE_UNIT / 2 + count_cycles;
} /* 42+ (2/0) */

/* MULS.W (An)+,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_c1d8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111354;
	}
{{	uae_s16 src = get_word_000 (srca);
	m68k_areg (regs, srcreg) += 2;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	int bits;
	uae_u32 usrc;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	usrc = ((uae_u32)src) << 1;
	for(bits = 0; bits < 16 && usrc; bits++, usrc >>= 1)
		if ((usrc & 3) == 1 || (usrc & 3) == 2) count_cycles += 2 * CYCLE_UNIT / 2;
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (2);
l_111354: ;
return 42 * CYCLE_UNIT / 2 + count_cycles;
} /* 42+ (2/0) */

/* MULS.W -(An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_c1e0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_111355;
	}
{{	uae_s16 src = get_word_000 (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	int bits;
	uae_u32 usrc;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	usrc = ((uae_u32)src) << 1;
	for(bits = 0; bits < 16 && usrc; bits++, usrc >>= 1)
		if ((usrc & 3) == 1 || (usrc & 3) == 2) count_cycles += 2 * CYCLE_UNIT / 2;
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (2);
l_111355: ;
return 44 * CYCLE_UNIT / 2 + count_cycles;
} /* 44+ (2/0) */

/* MULS.W (d16,An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_c1e8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111356;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	int bits;
	uae_u32 usrc;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	usrc = ((uae_u32)src) << 1;
	for(bits = 0; bits < 16 && usrc; bits++, usrc >>= 1)
		if ((usrc & 3) == 1 || (usrc & 3) == 2) count_cycles += 2 * CYCLE_UNIT / 2;
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (4);
l_111356: ;
return 46 * CYCLE_UNIT / 2 + count_cycles;
} /* 46+ (3/0) */

/* MULS.W (d8,An,Xn),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_c1f0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111357;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	int bits;
	uae_u32 usrc;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	usrc = ((uae_u32)src) << 1;
	for(bits = 0; bits < 16 && usrc; bits++, usrc >>= 1)
		if ((usrc & 3) == 1 || (usrc & 3) == 2) count_cycles += 2 * CYCLE_UNIT / 2;
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (4);
l_111357: ;
return 48 * CYCLE_UNIT / 2 + count_cycles;
} /* 48+ (3/0) */

/* MULS.W (xxx).W,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_c1f8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_111358;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	int bits;
	uae_u32 usrc;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	usrc = ((uae_u32)src) << 1;
	for(bits = 0; bits < 16 && usrc; bits++, usrc >>= 1)
		if ((usrc & 3) == 1 || (usrc & 3) == 2) count_cycles += 2 * CYCLE_UNIT / 2;
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (4);
l_111358: ;
return 46 * CYCLE_UNIT / 2 + count_cycles;
} /* 46+ (3/0) */

/* MULS.W (xxx).L,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_c1f9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_111359;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	int bits;
	uae_u32 usrc;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	usrc = ((uae_u32)src) << 1;
	for(bits = 0; bits < 16 && usrc; bits++, usrc >>= 1)
		if ((usrc & 3) == 1 || (usrc & 3) == 2) count_cycles += 2 * CYCLE_UNIT / 2;
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (6);
l_111359: ;
return 50 * CYCLE_UNIT / 2 + count_cycles;
} /* 50+ (4/0) */

/* MULS.W (d16,PC),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_c1fa_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111360;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	int bits;
	uae_u32 usrc;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	usrc = ((uae_u32)src) << 1;
	for(bits = 0; bits < 16 && usrc; bits++, usrc >>= 1)
		if ((usrc & 3) == 1 || (usrc & 3) == 2) count_cycles += 2 * CYCLE_UNIT / 2;
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (4);
l_111360: ;
return 46 * CYCLE_UNIT / 2 + count_cycles;
} /* 46+ (3/0) */

/* MULS.W (d8,PC,Xn),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_c1fb_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	srca = get_disp_ea_000 (tmppc, get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111361;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	int bits;
	uae_u32 usrc;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	usrc = ((uae_u32)src) << 1;
	for(bits = 0; bits < 16 && usrc; bits++, usrc >>= 1)
		if ((usrc & 3) == 1 || (usrc & 3) == 2) count_cycles += 2 * CYCLE_UNIT / 2;
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (4);
l_111361: ;
return 48 * CYCLE_UNIT / 2 + count_cycles;
} /* 48+ (3/0) */

/* MULS.W #<data>.W,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_c1fc_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	int bits;
	uae_u32 usrc;
	CLEAR_CZNV ();
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_NFLG (((uae_s32)(newv)) < 0);
	usrc = ((uae_u32)src) << 1;
	for(bits = 0; bits < 16 && usrc; bits++, usrc >>= 1)
		if ((usrc & 3) == 1 || (usrc & 3) == 2) count_cycles += 2 * CYCLE_UNIT / 2;
	m68k_dreg (regs, dstreg) = (newv);
}}}}	m68k_incpci (4);
return 42 * CYCLE_UNIT / 2 + count_cycles;
} /* 42+ (2/0) */

/* ADD.B Dn,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_d000_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}	m68k_incpci (2);
return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4 (1/0) */

/* ADD.B (An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_d010_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_000 (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (2/0) */

/* ADD.B (An)+,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_d018_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
{	uae_s8 src = get_byte_000 (srca);
	m68k_areg (regs, srcreg) += areg_byteinc[srcreg];
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (2/0) */

/* ADD.B -(An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_d020_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte_000 (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpci (2);
return 10 * CYCLE_UNIT / 2 + count_cycles;
} /* 10 (2/0) */

/* ADD.B (d16,An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_d028_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 src = get_byte_000 (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpci (4);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (3/0) */

/* ADD.B (d8,An,Xn),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_d030_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
{	uae_s8 src = get_byte_000 (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpci (4);
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (3/0) */

/* ADD.B (xxx).W,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_d038_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 src = get_byte_000 (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpci (4);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (3/0) */

/* ADD.B (xxx).L,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_d039_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
{	uae_s8 src = get_byte_000 (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpci (6);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (4/0) */

/* ADD.B (d16,PC),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_d03a_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 src = get_byte_000 (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpci (4);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (3/0) */

/* ADD.B (d8,PC,Xn),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_d03b_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	srca = get_disp_ea_000 (tmppc, get_word_000_prefetch (4));
{	uae_s8 src = get_byte_000 (srca);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}}	m68k_incpci (4);
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (3/0) */

/* ADD.B #<data>.B,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_d03c_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = (uae_u8)get_word_000_prefetch (4);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}}	m68k_incpci (4);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (2/0) */

/* ADD.W Dn,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_d040_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}	m68k_incpci (2);
return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4 (1/0) */

/* ADD.W An,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_d048_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_areg (regs, srcreg);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}	m68k_incpci (2);
return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4 (1/0) */

/* ADD.W (An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_d050_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111376;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}}	m68k_incpci (2);
l_111376: ;
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (2/0) */

/* ADD.W (An)+,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_d058_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111377;
	}
{{	uae_s16 src = get_word_000 (srca);
	m68k_areg (regs, srcreg) += 2;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}}	m68k_incpci (2);
l_111377: ;
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (2/0) */

/* ADD.W -(An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_d060_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_111378;
	}
{{	uae_s16 src = get_word_000 (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}}	m68k_incpci (2);
l_111378: ;
return 10 * CYCLE_UNIT / 2 + count_cycles;
} /* 10 (2/0) */

/* ADD.W (d16,An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_d068_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111379;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}}	m68k_incpci (4);
l_111379: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (3/0) */

/* ADD.W (d8,An,Xn),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_d070_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111380;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}}	m68k_incpci (4);
l_111380: ;
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (3/0) */

/* ADD.W (xxx).W,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_d078_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_111381;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}}	m68k_incpci (4);
l_111381: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (3/0) */

/* ADD.W (xxx).L,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_d079_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_111382;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}}	m68k_incpci (6);
l_111382: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (4/0) */

/* ADD.W (d16,PC),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_d07a_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111383;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}}	m68k_incpci (4);
l_111383: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (3/0) */

/* ADD.W (d8,PC,Xn),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_d07b_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	srca = get_disp_ea_000 (tmppc, get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111384;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}}}	m68k_incpci (4);
l_111384: ;
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (3/0) */

/* ADD.W #<data>.W,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_d07c_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}}	m68k_incpci (4);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (2/0) */

/* ADD.L Dn,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_d080_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/0) */

/* ADD.L An,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_d088_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/0) */

/* ADD.L (An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_d090_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111388;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}}	m68k_incpci (2);
l_111388: ;
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (3/0) */

/* ADD.L (An)+,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_d098_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111389;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
	m68k_areg (regs, srcreg) += 4;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}}	m68k_incpci (2);
l_111389: ;
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (3/0) */

/* ADD.L -(An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_d0a0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_111390;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}}	m68k_incpci (2);
l_111390: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/0) */

/* ADD.L (d16,An),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_d0a8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111391;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}}	m68k_incpci (4);
l_111391: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (4/0) */

/* ADD.L (d8,An,Xn),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_d0b0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111392;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}}	m68k_incpci (4);
l_111392: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/0) */

/* ADD.L (xxx).W,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_d0b8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_111393;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}}	m68k_incpci (4);
l_111393: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (4/0) */

/* ADD.L (xxx).L,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_d0b9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_111394;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}}	m68k_incpci (6);
l_111394: ;
return 22 * CYCLE_UNIT / 2 + count_cycles;
} /* 22 (5/0) */

/* ADD.L (d16,PC),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_d0ba_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111395;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}}	m68k_incpci (4);
l_111395: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (4/0) */

/* ADD.L (d8,PC,Xn),Dn */
uae_u32 REGPARAM2 CPUFUNC(op_d0bb_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	srca = get_disp_ea_000 (tmppc, get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111396;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}}}	m68k_incpci (4);
l_111396: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/0) */

/* ADD.L #<data>.L,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_d0bc_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src;
	src = get_word_000_prefetch (4) << 16;
	src |= get_word_000_prefetch (6);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (6);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/0) */

/* ADDA.W Dn,An */
uae_u32 REGPARAM2 CPUFUNC(op_d0c0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/0) */

/* ADDA.W An,An */
uae_u32 REGPARAM2 CPUFUNC(op_d0c8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_areg (regs, srcreg);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/0) */

/* ADDA.W (An),An */
uae_u32 REGPARAM2 CPUFUNC(op_d0d0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111400;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (2);
l_111400: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/0) */

/* ADDA.W (An)+,An */
uae_u32 REGPARAM2 CPUFUNC(op_d0d8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111401;
	}
{{	uae_s16 src = get_word_000 (srca);
	m68k_areg (regs, srcreg) += 2;
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (2);
l_111401: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/0) */

/* ADDA.W -(An),An */
uae_u32 REGPARAM2 CPUFUNC(op_d0e0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_111402;
	}
{{	uae_s16 src = get_word_000 (srca);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (2);
l_111402: ;
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (2/0) */

/* ADDA.W (d16,An),An */
uae_u32 REGPARAM2 CPUFUNC(op_d0e8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111403;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (4);
l_111403: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/0) */

/* ADDA.W (d8,An,Xn),An */
uae_u32 REGPARAM2 CPUFUNC(op_d0f0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111404;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (4);
l_111404: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/0) */

/* ADDA.W (xxx).W,An */
uae_u32 REGPARAM2 CPUFUNC(op_d0f8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_111405;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (4);
l_111405: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/0) */

/* ADDA.W (xxx).L,An */
uae_u32 REGPARAM2 CPUFUNC(op_d0f9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_111406;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (6);
l_111406: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/0) */

/* ADDA.W (d16,PC),An */
uae_u32 REGPARAM2 CPUFUNC(op_d0fa_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111407;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (4);
l_111407: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/0) */

/* ADDA.W (d8,PC,Xn),An */
uae_u32 REGPARAM2 CPUFUNC(op_d0fb_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	srca = get_disp_ea_000 (tmppc, get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111408;
	}
{{	uae_s16 src = get_word_000 (srca);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (4);
l_111408: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/0) */

/* ADDA.W #<data>.W,An */
uae_u32 REGPARAM2 CPUFUNC(op_d0fc_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = get_word_000_prefetch (4);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpci (4);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/0) */

/* ADDX.B Dn,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_d100_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uae_s8 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 newv = dst + src + (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgo) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((newv) & 0xff);
}}}}}	m68k_incpci (2);
return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4 (1/0) */

/* ADDX.B -(An),-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_d108_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - areg_byteinc[srcreg];
{	uae_s8 src = get_byte_000 (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte_000 (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 newv = dst + src + (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgo) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s8)(newv)) == 0));
	SET_NFLG (((uae_s8)(newv)) < 0);
	put_byte_000 (dsta, newv);
}}}}}}}	m68k_incpci (2);
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/1) */

/* ADD.B Dn,(An) */
uae_u32 REGPARAM2 CPUFUNC(op_d110_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_byte_000 (dsta, newv);
}}}}}}}	m68k_incpci (2);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* ADD.B Dn,(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_d118_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
{	uae_s8 dst = get_byte_000 (dsta);
	m68k_areg (regs, dstreg) += areg_byteinc[dstreg];
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_byte_000 (dsta, newv);
}}}}}}}	m68k_incpci (2);
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* ADD.B Dn,-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_d120_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - areg_byteinc[dstreg];
{	uae_s8 dst = get_byte_000 (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_byte_000 (dsta, newv);
}}}}}}}	m68k_incpci (2);
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (2/1) */

/* ADD.B Dn,(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_d128_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_byte_000 (dsta, newv);
}}}}}}}	m68k_incpci (4);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* ADD.B Dn,(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_d130_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (4));
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_byte_000 (dsta, newv);
}}}}}}}	m68k_incpci (4);
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/1) */

/* ADD.B Dn,(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_d138_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (4);
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_byte_000 (dsta, newv);
}}}}}}}	m68k_incpci (4);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* ADD.B Dn,(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_d139_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s8 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_word_000_prefetch (4) << 16;
	dsta |= get_word_000_prefetch (6);
{	uae_s8 dst = get_byte_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{{uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
{	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG (((uae_s8)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_byte_000 (dsta, newv);
}}}}}}}	m68k_incpci (6);
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* ADDX.W Dn,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_d140_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uae_s16 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 newv = dst + src + (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgo) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s16)(newv)) == 0));
	SET_NFLG (((uae_s16)(newv)) < 0);
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
}}}}}	m68k_incpci (2);
return 4 * CYCLE_UNIT / 2 + count_cycles;
} /* 4 (1/0) */

/* ADDX.W -(An),-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_d148_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 2;
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111420;
	}
{{	uae_s16 src = get_word_000 (srca);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_111420;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 newv = dst + src + (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgo) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s16)(newv)) == 0));
	SET_NFLG (((uae_s16)(newv)) < 0);
	put_word_000 (dsta, newv);
}}}}}}}}}	m68k_incpci (2);
l_111420: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/1) */

/* ADD.W Dn,(An) */
uae_u32 REGPARAM2 CPUFUNC(op_d150_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_111421;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta, newv);
}}}}}}}}	m68k_incpci (2);
l_111421: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* ADD.W Dn,(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_d158_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_111422;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	m68k_areg (regs, dstreg) += 2;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta, newv);
}}}}}}}}	m68k_incpci (2);
l_111422: ;
return 12 * CYCLE_UNIT / 2 + count_cycles;
} /* 12 (2/1) */

/* ADD.W Dn,-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_d160_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 2;
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_111423;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta, newv);
}}}}}}}}	m68k_incpci (2);
l_111423: ;
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (2/1) */

/* ADD.W Dn,(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_d168_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_111424;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta, newv);
}}}}}}}}	m68k_incpci (4);
l_111424: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* ADD.W Dn,(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_d170_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (4));
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_111425;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta, newv);
}}}}}}}}	m68k_incpci (4);
l_111425: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (3/1) */

/* ADD.W Dn,(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_d178_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_111426;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta, newv);
}}}}}}}}	m68k_incpci (4);
l_111426: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/1) */

/* ADD.W Dn,(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_d179_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s16 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_word_000_prefetch (4) << 16;
	dsta |= get_word_000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_read(opcode, dsta);
		goto l_111427;
	}
{{	uae_s16 dst = get_word_000 (dsta);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{{uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
{	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG (((uae_s16)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta, newv);
}}}}}}}}	m68k_incpci (6);
l_111427: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/1) */

/* ADDX.L Dn,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_d180_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 newv = dst + src + (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgo) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s32)(newv)) == 0));
	SET_NFLG (((uae_s32)(newv)) < 0);
	m68k_dreg (regs, dstreg) = (newv);
}}}}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/0) */

/* ADDX.L -(An),-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_d188_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111429;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
	m68k_areg (regs, srcreg) = srca;
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_111429;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 newv = dst + src + (GET_XFLG () ? 1 : 0);
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (flgs ^ ((flgs ^ flgo) & (flgo ^ flgn)));
	COPY_CARRY ();
	SET_ZFLG (GET_ZFLG () & (((uae_s32)(newv)) == 0));
	SET_NFLG (((uae_s32)(newv)) < 0);
	put_word_000 (dsta, newv >> 16); put_word_000 (dsta + 2, newv);
}}}}}}}}}	m68k_incpci (2);
l_111429: ;
return 30 * CYCLE_UNIT / 2 + count_cycles;
} /* 30 (5/2) */

/* ADD.L Dn,(An) */
uae_u32 REGPARAM2 CPUFUNC(op_d190_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_111430;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta + 2, newv); put_word_000 (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (2);
l_111430: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (3/2) */

/* ADD.L Dn,(An)+ */
uae_u32 REGPARAM2 CPUFUNC(op_d198_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_111431;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	m68k_areg (regs, dstreg) += 4;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta + 2, newv); put_word_000 (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (2);
l_111431: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (3/2) */

/* ADD.L Dn,-(An) */
uae_u32 REGPARAM2 CPUFUNC(op_d1a0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) - 4;
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_111432;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	m68k_areg (regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta + 2, newv); put_word_000 (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (2);
l_111432: ;
return 22 * CYCLE_UNIT / 2 + count_cycles;
} /* 22 (3/2) */

/* ADD.L Dn,(d16,An) */
uae_u32 REGPARAM2 CPUFUNC(op_d1a8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = m68k_areg (regs, dstreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_111433;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta + 2, newv); put_word_000 (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (4);
l_111433: ;
return 24 * CYCLE_UNIT / 2 + count_cycles;
} /* 24 (4/2) */

/* ADD.L Dn,(d8,An,Xn) */
uae_u32 REGPARAM2 CPUFUNC(op_d1b0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
	uae_u32 dstreg = opcode & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_disp_ea_000 (m68k_areg (regs, dstreg), get_word_000_prefetch (4));
	if (dsta & 1) {
	m68k_incpci (2);
		exception3_read(opcode, dsta);
		goto l_111434;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta + 2, newv); put_word_000 (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (4);
l_111434: ;
return 26 * CYCLE_UNIT / 2 + count_cycles;
} /* 26 (4/2) */

/* ADD.L Dn,(xxx).W */
uae_u32 REGPARAM2 CPUFUNC(op_d1b8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (dsta & 1) {
	m68k_incpci (4);
		exception3_read(opcode, dsta);
		goto l_111435;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta + 2, newv); put_word_000 (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (4);
l_111435: ;
return 24 * CYCLE_UNIT / 2 + count_cycles;
} /* 24 (4/2) */

/* ADD.L Dn,(xxx).L */
uae_u32 REGPARAM2 CPUFUNC(op_d1b9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = ((opcode >> 9) & 7);
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uaecptr dsta;
	dsta = get_word_000_prefetch (4) << 16;
	dsta |= get_word_000_prefetch (6);
	if (dsta & 1) {
	m68k_incpci (6);
		exception3_read(opcode, dsta);
		goto l_111436;
	}
{{	uae_s32 dst = get_word_000 (dsta) << 16; dst |= get_word_000 (dsta + 2);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{{uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
{	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG (((uae_s32)(newv)) == 0);
	SET_VFLG ((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG (((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY ();
	SET_NFLG (flgn != 0);
	put_word_000 (dsta + 2, newv); put_word_000 (dsta, newv >> 16);
}}}}}}}}	m68k_incpci (6);
l_111436: ;
return 28 * CYCLE_UNIT / 2 + count_cycles;
} /* 28 (5/2) */

/* ADDA.L Dn,An */
uae_u32 REGPARAM2 CPUFUNC(op_d1c0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_dreg (regs, srcreg);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/0) */

/* ADDA.L An,An */
uae_u32 REGPARAM2 CPUFUNC(op_d1c8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src = m68k_areg (regs, srcreg);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpci (2);
return 8 * CYCLE_UNIT / 2 + count_cycles;
} /* 8 (1/0) */

/* ADDA.L (An),An */
uae_u32 REGPARAM2 CPUFUNC(op_d1d0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111439;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (2);
l_111439: ;
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (3/0) */

/* ADDA.L (An)+,An */
uae_u32 REGPARAM2 CPUFUNC(op_d1d8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111440;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
	m68k_areg (regs, srcreg) += 4;
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (2);
l_111440: ;
return 14 * CYCLE_UNIT / 2 + count_cycles;
} /* 14 (3/0) */

/* ADDA.L -(An),An */
uae_u32 REGPARAM2 CPUFUNC(op_d1e0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) - 4;
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_111441;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
	m68k_areg (regs, srcreg) = srca;
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (2);
l_111441: ;
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/0) */

/* ADDA.L (d16,An),An */
uae_u32 REGPARAM2 CPUFUNC(op_d1e8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_areg (regs, srcreg) + (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111442;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (4);
l_111442: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (4/0) */

/* ADDA.L (d8,An,Xn),An */
uae_u32 REGPARAM2 CPUFUNC(op_d1f0_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = (opcode & 7);
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_disp_ea_000 (m68k_areg (regs, srcreg), get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111443;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (4);
l_111443: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/0) */

/* ADDA.L (xxx).W,An */
uae_u32 REGPARAM2 CPUFUNC(op_d1f8_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (4);
		exception3_read(opcode, srca);
		goto l_111444;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (4);
l_111444: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (4/0) */

/* ADDA.L (xxx).L,An */
uae_u32 REGPARAM2 CPUFUNC(op_d1f9_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = get_word_000_prefetch (4) << 16;
	srca |= get_word_000_prefetch (6);
	if (srca & 1) {
	m68k_incpci (6);
		exception3_read(opcode, srca);
		goto l_111445;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (6);
l_111445: ;
return 22 * CYCLE_UNIT / 2 + count_cycles;
} /* 22 (5/0) */

/* ADDA.L (d16,PC),An */
uae_u32 REGPARAM2 CPUFUNC(op_d1fa_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr srca;
	srca = m68k_getpci () + 2;
	srca += (uae_s32)(uae_s16)get_word_000_prefetch (4);
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111446;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (4);
l_111446: ;
return 18 * CYCLE_UNIT / 2 + count_cycles;
} /* 18 (4/0) */

/* ADDA.L (d8,PC,Xn),An */
uae_u32 REGPARAM2 CPUFUNC(op_d1fb_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uaecptr tmppc;
	uaecptr srca;
	tmppc = m68k_getpci () + 2;
	srca = get_disp_ea_000 (tmppc, get_word_000_prefetch (4));
	if (srca & 1) {
	m68k_incpci (2);
		exception3_read(opcode, srca);
		goto l_111447;
	}
{{	uae_s32 src = get_word_000 (srca) << 16; src |= get_word_000 (srca + 2);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (6);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}}}	m68k_incpci (4);
l_111447: ;
return 20 * CYCLE_UNIT / 2 + count_cycles;
} /* 20 (4/0) */

/* ADDA.L #<data>.L,An */
uae_u32 REGPARAM2 CPUFUNC(op_d1fc_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = (opcode >> 9) & 7;
{{	uae_s32 src;
	src = get_word_000_prefetch (4) << 16;
	src |= get_word_000_prefetch (6);
{	uae_s32 dst = m68k_areg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (8);
{	uae_u32 newv = dst + src;
	m68k_areg (regs, dstreg) = (newv);
}}}}	m68k_incpci (6);
return 16 * CYCLE_UNIT / 2 + count_cycles;
} /* 16 (3/0) */

/* ASRQ.B #<data>,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_e000_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 cnt = srcreg;
{	uae_s8 data = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 val = (uae_u8)data;
	uae_u32 sign = (0x80 & val) >> 7;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV ();
	if (cnt >= 8) {
		val = 0xff & (uae_u32)-sign;
		SET_CFLG (sign);
		COPY_CARRY ();
	} else {
		val >>= cnt - 1;
		SET_CFLG (val & 1);
		COPY_CARRY ();
		val >>= 1;
		val |= (0xff << (8 - cnt)) & (uae_u32)-sign;
		val &= 0xff;
	}
	SET_ZFLG (((uae_s8)(val)) == 0);
	SET_NFLG (((uae_s8)(val)) < 0);
	count_cycles += (2 * ccnt) * CYCLE_UNIT / 2;
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return 6 * CYCLE_UNIT / 2 + count_cycles;
} /* 6+ (1/0) */

/* LSRQ.B #<data>,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_e008_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 cnt = srcreg;
{	uae_s8 data = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 val = (uae_u8)data;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV ();
	if (cnt >= 8) {
		SET_CFLG ((cnt == 8) & (val >> 7));
		COPY_CARRY ();
		val = 0;
	} else {
		val >>= cnt - 1;
		SET_CFLG (val & 1);
		COPY_CARRY ();
		val >>= 1;
	}
	SET_ZFLG (((uae_s8)(val)) == 0);
	SET_NFLG (((uae_s8)(val)) < 0);
	count_cycles += (2 * ccnt) * CYCLE_UNIT / 2;
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return 6 * CYCLE_UNIT / 2 + count_cycles;
} /* 6+ (1/0) */

/* ROXRQ.B #<data>,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_e010_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 cnt = srcreg;
{	uae_s8 data = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 val = (uae_u8)data;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV ();
{	cnt--;
	{
	uae_u32 carry;
	uae_u32 hival = (val << 1) | GET_XFLG ();
	hival <<= (7 - cnt);
	val >>= cnt;
	carry = val & 1;
	val >>= 1;
	val |= hival;
	SET_XFLG (carry);
	val &= 0xff;
	} }
	SET_CFLG (GET_XFLG ());
	SET_ZFLG (((uae_s8)(val)) == 0);
	SET_NFLG (((uae_s8)(val)) < 0);
	count_cycles += (2 * ccnt) * CYCLE_UNIT / 2;
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return 6 * CYCLE_UNIT / 2 + count_cycles;
} /* 6+ (1/0) */

/* RORQ.B #<data>,Dn */
uae_u32 REGPARAM2 CPUFUNC(op_e018_11)(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 srcreg = imm8_table[((opcode >> 9) & 7)];
	uae_u32 dstreg = opcode & 7;
{{	uae_u32 cnt = srcreg;
{	uae_s8 data = m68k_dreg (regs, dstreg);
	regs.ir = regs.irc;
	get_word_000_prefetch (4);
{	uae_u32 val = (uae_u8)data;
	int ccnt = cnt & 63;
	cnt &= 63;
	CLEAR_CZNV ();
{	uae_u32 hival;
	cnt &= 7;
	hival = val << (8 - cnt);
	val >>= cnt;
	val |= hival;
	val &= 0xff;
	SET_CFLG ((val & 0x80) >> 7);
	}
	SET_ZFLG (((uae_s8)(val)) == 0);
	SET_NFLG (((uae_s8)(val)) < 0);
	count_cycles += (2 * ccnt) * CYCLE_UNIT / 2;
	m68k_dreg (regs, dstreg) = (m68k_dreg (regs, dstreg) & ~0xff) | ((val) & 0xff);
}}}}	m68k_incpci (2);
return 6 * CYCLE_UNIT / 2 + count_cycles;
} /* 6+ (1