/* UserSources.c generated by valac 0.56.18, the Vala compiler
 * generated from UserSources.vala, do not modify */

/* UserSources.vala
 *
 * Copyright (C) 2009-2025 Jerry Casiano
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.
 *
 * If not, see <http://www.gnu.org/licenses/gpl-3.0.txt>.
*/

#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include "font-manager.h"
#include <stdlib.h>
#include <string.h>
#include <sqlite3.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>

#define FONT_MANAGER_USER_SOURCE_LIST_help_text _ ("Fonts in any folders listed here will be available within the applicat" \
"ion.\n" \
"\n" \
"They will not be visible to other applications until the source is act" \
"ually enabled.")
#define FONT_MANAGER_FONTCONFIG_DISCLAIMER _ ("A Fontconfig configuration file will be generated from these settings." \
"\n" \
"\n" \
"Running applications may require a restart to reflect any changes.\n" \
"\n" \
"Note that not all environments/applications will honor these settings.")
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define FONT_MANAGER_TYPE_USER_SOURCE_MODEL (font_manager_user_source_model_get_type ())
#define FONT_MANAGER_USER_SOURCE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_USER_SOURCE_MODEL, FontManagerUserSourceModel))
#define FONT_MANAGER_USER_SOURCE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_USER_SOURCE_MODEL, FontManagerUserSourceModelClass))
#define FONT_MANAGER_IS_USER_SOURCE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_USER_SOURCE_MODEL))
#define FONT_MANAGER_IS_USER_SOURCE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_USER_SOURCE_MODEL))
#define FONT_MANAGER_USER_SOURCE_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_USER_SOURCE_MODEL, FontManagerUserSourceModelClass))

typedef struct _FontManagerUserSourceModel FontManagerUserSourceModel;
typedef struct _FontManagerUserSourceModelClass FontManagerUserSourceModelClass;
typedef struct _FontManagerUserSourceModelPrivate FontManagerUserSourceModelPrivate;
enum  {
	FONT_MANAGER_USER_SOURCE_MODEL_0_PROPERTY,
	FONT_MANAGER_USER_SOURCE_MODEL_ITEMS_PROPERTY,
	FONT_MANAGER_USER_SOURCE_MODEL_NUM_PROPERTIES
};
static GParamSpec* font_manager_user_source_model_properties[FONT_MANAGER_USER_SOURCE_MODEL_NUM_PROPERTIES];
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block10Data Block10Data;
typedef struct _Block31Data Block31Data;
typedef struct _Block32Data Block32Data;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define FONT_MANAGER_TYPE_PREFERENCE_LIST (font_manager_preference_list_get_type ())
#define FONT_MANAGER_PREFERENCE_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_PREFERENCE_LIST, FontManagerPreferenceList))
#define FONT_MANAGER_PREFERENCE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_PREFERENCE_LIST, FontManagerPreferenceListClass))
#define FONT_MANAGER_IS_PREFERENCE_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_PREFERENCE_LIST))
#define FONT_MANAGER_IS_PREFERENCE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_PREFERENCE_LIST))
#define FONT_MANAGER_PREFERENCE_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_PREFERENCE_LIST, FontManagerPreferenceListClass))

typedef struct _FontManagerPreferenceList FontManagerPreferenceList;
typedef struct _FontManagerPreferenceListClass FontManagerPreferenceListClass;
typedef struct _FontManagerPreferenceListPrivate FontManagerPreferenceListPrivate;

#define FONT_MANAGER_TYPE_BASE_CONTROLS (font_manager_base_controls_get_type ())
#define FONT_MANAGER_BASE_CONTROLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_BASE_CONTROLS, FontManagerBaseControls))
#define FONT_MANAGER_BASE_CONTROLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_BASE_CONTROLS, FontManagerBaseControlsClass))
#define FONT_MANAGER_IS_BASE_CONTROLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_BASE_CONTROLS))
#define FONT_MANAGER_IS_BASE_CONTROLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_BASE_CONTROLS))
#define FONT_MANAGER_BASE_CONTROLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_BASE_CONTROLS, FontManagerBaseControlsClass))

typedef struct _FontManagerBaseControls FontManagerBaseControls;
typedef struct _FontManagerBaseControlsClass FontManagerBaseControlsClass;

#define FONT_MANAGER_TYPE_USER_SOURCE_LIST (font_manager_user_source_list_get_type ())
#define FONT_MANAGER_USER_SOURCE_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_USER_SOURCE_LIST, FontManagerUserSourceList))
#define FONT_MANAGER_USER_SOURCE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_USER_SOURCE_LIST, FontManagerUserSourceListClass))
#define FONT_MANAGER_IS_USER_SOURCE_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_USER_SOURCE_LIST))
#define FONT_MANAGER_IS_USER_SOURCE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_USER_SOURCE_LIST))
#define FONT_MANAGER_USER_SOURCE_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_USER_SOURCE_LIST, FontManagerUserSourceListClass))

typedef struct _FontManagerUserSourceList FontManagerUserSourceList;
typedef struct _FontManagerUserSourceListClass FontManagerUserSourceListClass;
typedef struct _FontManagerUserSourceListPrivate FontManagerUserSourceListPrivate;
enum  {
	FONT_MANAGER_USER_SOURCE_LIST_0_PROPERTY,
	FONT_MANAGER_USER_SOURCE_LIST_MODEL_PROPERTY,
	FONT_MANAGER_USER_SOURCE_LIST_NUM_PROPERTIES
};
static GParamSpec* font_manager_user_source_list_properties[FONT_MANAGER_USER_SOURCE_LIST_NUM_PROPERTIES];

#define FONT_MANAGER_TYPE_APPLICATION (font_manager_application_get_type ())
#define FONT_MANAGER_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_APPLICATION, FontManagerApplication))
#define FONT_MANAGER_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_APPLICATION, FontManagerApplicationClass))
#define FONT_MANAGER_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_APPLICATION))
#define FONT_MANAGER_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_APPLICATION))
#define FONT_MANAGER_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_APPLICATION, FontManagerApplicationClass))

typedef struct _FontManagerApplication FontManagerApplication;
typedef struct _FontManagerApplicationClass FontManagerApplicationClass;
typedef struct _Block33Data Block33Data;

struct _FontManagerUserSourceModel {
	GObject parent_instance;
	FontManagerUserSourceModelPrivate * priv;
};

struct _FontManagerUserSourceModelClass {
	GObjectClass parent_class;
};

struct _FontManagerUserSourceModelPrivate {
	GPtrArray* _items;
	FontManagerDirectories* sources;
};

struct _Block10Data {
	int _ref_count_;
	GPtrArray* self;
	GCompareFunc compare_func;
};

struct _Block31Data {
	int _ref_count_;
	FontManagerUserSourceModel* self;
	guint position;
};

struct _Block32Data {
	int _ref_count_;
	FontManagerUserSourceModel* self;
	FontManagerDirectories* active;
};

struct _FontManagerPreferenceList {
	GtkBox parent_instance;
	FontManagerPreferenceListPrivate * priv;
	GtkListBox* list;
	FontManagerBaseControls* controls;
	GtkSeparator* separator;
};

struct _FontManagerPreferenceListClass {
	GtkBoxClass parent_class;
	void (*on_add_selected) (FontManagerPreferenceList* self);
	void (*on_list_row_selected) (FontManagerPreferenceList* self, GtkListBox* box, GtkListBoxRow* row);
	void (*on_map) (FontManagerPreferenceList* self);
	void (*on_remove_selected) (FontManagerPreferenceList* self);
	void (*on_unmap) (FontManagerPreferenceList* self);
};

struct _FontManagerUserSourceList {
	FontManagerPreferenceList parent_instance;
	FontManagerUserSourceListPrivate * priv;
};

struct _FontManagerUserSourceListClass {
	FontManagerPreferenceListClass parent_class;
};

struct _FontManagerUserSourceListPrivate {
	gboolean refresh_required;
	FontManagerUserSourceModel* _model;
};

struct _Block33Data {
	int _ref_count_;
	FontManagerUserSourceList* self;
	FontManagerSource* source;
	FontManagerPreferenceRow* row;
};

static gint FontManagerUserSourceModel_private_offset;
static gpointer font_manager_user_source_model_parent_class = NULL;
static GListModelInterface * font_manager_user_source_model_g_list_model_parent_iface = NULL;
static gint FontManagerUserSourceList_private_offset;
static gpointer font_manager_user_source_list_parent_class = NULL;

VALA_EXTERN GType font_manager_user_source_model_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerUserSourceModel, g_object_unref)
static void _g_object_unref0_ (gpointer var);
VALA_EXTERN void font_manager_user_source_model_clear (FontManagerUserSourceModel* self);
static void font_manager_user_source_model_set_items (FontManagerUserSourceModel* self,
                                               GPtrArray* value);
VALA_EXTERN void font_manager_user_source_model_reload (FontManagerUserSourceModel* self);
VALA_EXTERN void font_manager_user_source_model_add_item (FontManagerUserSourceModel* self,
                                              FontManagerSource* item);
VALA_EXTERN GPtrArray* font_manager_user_source_model_get_items (FontManagerUserSourceModel* self);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
static gint ___lambda0__gcompare_data_func (gconstpointer a,
                                     gconstpointer b,
                                     gpointer self);
static gint __lambda16_ (FontManagerSource* a,
                  FontManagerSource* b);
static gint ___lambda16__gcompare_func (gconstpointer a,
                                 gconstpointer b);
static void __lambda17_ (FontManagerUserSourceModel* self);
static gboolean __lambda18_ (FontManagerUserSourceModel* self);
static void font_manager_user_source_model_save_active_items (FontManagerUserSourceModel* self);
static gboolean ___lambda18__gsource_func (gpointer self);
static void ___lambda17__g_list_model_items_changed (GListModel* _sender,
                                              guint position,
                                              guint removed,
                                              guint added,
                                              gpointer self);
static GType font_manager_user_source_model_real_get_item_type (GListModel* base);
static guint font_manager_user_source_model_real_get_n_items (GListModel* base);
static GObject* font_manager_user_source_model_real_get_item (GListModel* base,
                                                       guint position);
static Block31Data* block31_data_ref (Block31Data* _data31_);
static void block31_data_unref (void * _userdata_);
static void __lambda14_ (Block31Data* _data31_);
static void ___lambda14__font_manager_source_changed (FontManagerSource* _sender,
                                               GFile* file,
                                               GFile* other_file,
                                               GFileMonitorEvent event_type,
                                               gpointer self);
static void __lambda15_ (Block31Data* _data31_);
static void ___lambda15__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
VALA_EXTERN void font_manager_user_source_model_remove_item (FontManagerUserSourceModel* self,
                                                 guint position);
static void font_manager_user_source_model_on_database_purged (FontManagerUserSourceModel* self,
                                                        GObject* unused_object,
                                                        GTask* unused_task);
static void _font_manager_user_source_model_on_database_purged_gasync_ready_callback (GObject* source_object,
                                                                               GTask* task,
                                                                               gpointer self);
static void font_manager_user_source_model_purge_database_entries (GTask* task,
                                                            GObject* unused_source,
                                                            void* data,
                                                            GCancellable* cancellable);
static void _font_manager_user_source_model_purge_database_entries_gtask_thread_func (GTask* task,
                                                                               GObject* source_object,
                                                                               void* task_data,
                                                                               GCancellable* cancellable);
static Block32Data* block32_data_ref (Block32Data* _data32_);
static void block32_data_unref (void * _userdata_);
static void __lambda19_ (Block32Data* _data32_,
                  FontManagerSource* item);
static void ___lambda19__gfunc (gconstpointer data,
                         gpointer self);
VALA_EXTERN FontManagerDatabase* font_manager_database_proxy_get_default_db (void);
VALA_EXTERN FontManagerUserSourceModel* font_manager_user_source_model_new (void);
VALA_EXTERN FontManagerUserSourceModel* font_manager_user_source_model_construct (GType object_type);
static GObject * font_manager_user_source_model_constructor (GType type,
                                                      guint n_construct_properties,
                                                      GObjectConstructParam * construct_properties);
static void font_manager_user_source_model_finalize (GObject * obj);
static GType font_manager_user_source_model_get_type_once (void);
static void _vala_font_manager_user_source_model_get_property (GObject * object,
                                                        guint property_id,
                                                        GValue * value,
                                                        GParamSpec * pspec);
static void _vala_font_manager_user_source_model_set_property (GObject * object,
                                                        guint property_id,
                                                        const GValue * value,
                                                        GParamSpec * pspec);
VALA_EXTERN GType font_manager_preference_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerPreferenceList, g_object_unref)
VALA_EXTERN GType font_manager_base_controls_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerBaseControls, g_object_unref)
VALA_EXTERN GType font_manager_user_source_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerUserSourceList, g_object_unref)
VALA_EXTERN void font_manager_preference_list_on_add_selected (FontManagerPreferenceList* self);
VALA_EXTERN void font_manager_preference_list_on_remove_selected (FontManagerPreferenceList* self);
VALA_EXTERN void font_manager_preference_list_on_map (FontManagerPreferenceList* self);
VALA_EXTERN void font_manager_preference_list_on_unmap (FontManagerPreferenceList* self);
VALA_EXTERN FontManagerUserSourceList* font_manager_user_source_list_new (void);
VALA_EXTERN FontManagerUserSourceList* font_manager_user_source_list_construct (GType object_type);
VALA_EXTERN FontManagerPreferenceList* font_manager_preference_list_new (void);
VALA_EXTERN FontManagerPreferenceList* font_manager_preference_list_construct (GType object_type);
static void __lambda154_ (FontManagerUserSourceList* self);
VALA_EXTERN FontManagerUserSourceModel* font_manager_user_source_list_get_model (FontManagerUserSourceList* self);
static GtkWidget* font_manager_user_source_list_row_from_item (FontManagerUserSourceList* self,
                                                        GObject* item);
static GtkWidget* _font_manager_user_source_list_row_from_item_gtk_list_box_create_widget_func (GObject* item,
                                                                                         gpointer self);
static void ___lambda154__g_object_notify (GObject* _sender,
                                    GParamSpec* pspec,
                                    gpointer self);
VALA_EXTERN void font_manager_user_source_list_set_model (FontManagerUserSourceList* self,
                                              FontManagerUserSourceModel* value);
VALA_EXTERN GtkImage* font_manager_inline_help_widget (const gchar* message);
static gboolean font_manager_user_source_list_on_drag_data_received (FontManagerUserSourceList* self,
                                                              GValue* value,
                                                              gdouble x,
                                                              gdouble y);
static gboolean _font_manager_user_source_list_on_drag_data_received_gtk_drop_target_drop (GtkDropTarget* _sender,
                                                                                    GValue* value,
                                                                                    gdouble x,
                                                                                    gdouble y,
                                                                                    gpointer self);
static void __lambda156_ (FontManagerUserSourceList* self);
static void ___lambda156__g_list_model_items_changed (GListModel* _sender,
                                               guint position,
                                               guint removed,
                                               guint added,
                                               gpointer self);
static void font_manager_user_source_list_on_file_selections_ready (FontManagerUserSourceList* self,
                                                             GObject* obj,
                                                             GAsyncResult* res);
static void font_manager_user_source_list_real_on_add_selected (FontManagerPreferenceList* base);
VALA_EXTERN GtkFileDialog* font_manager_file_selector_get_selected_sources (void);
VALA_EXTERN GtkWindow* font_manager_get_parent_window (GtkWidget* widget);
static void _font_manager_user_source_list_on_file_selections_ready_gasync_ready_callback (GObject* source_object,
                                                                                    GAsyncResult* res,
                                                                                    gpointer self);
static void font_manager_user_source_list_real_on_remove_selected (FontManagerPreferenceList* base);
static void font_manager_user_source_list_real_on_map (FontManagerPreferenceList* base);
static void font_manager_user_source_list_real_on_unmap (FontManagerPreferenceList* base);
static gboolean __lambda157_ (FontManagerUserSourceList* self);
VALA_EXTERN GType font_manager_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerApplication, g_object_unref)
VALA_EXTERN guint font_manager_application_register_object (void* object,
                                                GDBusConnection* connection,
                                                const gchar* path,
                                                GError** error);
VALA_EXTERN FontManagerApplication* font_manager_get_default_application (void);
VALA_EXTERN void font_manager_application_reload (FontManagerApplication* self);
static gboolean ___lambda157__gsource_func (gpointer self);
static Block33Data* block33_data_ref (Block33Data* _data33_);
static void block33_data_unref (void * _userdata_);
static void __lambda155_ (Block33Data* _data33_);
static void ___lambda155__g_object_notify (GObject* _sender,
                                    GParamSpec* pspec,
                                    gpointer self);
static void font_manager_user_source_list_finalize (GObject * obj);
static GType font_manager_user_source_list_get_type_once (void);
static void _vala_font_manager_user_source_list_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec);
static void _vala_font_manager_user_source_list_set_property (GObject * object,
                                                       guint property_id,
                                                       const GValue * value,
                                                       GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
font_manager_user_source_model_get_instance_private (FontManagerUserSourceModel* self)
{
	return G_STRUCT_MEMBER_P (self, FontManagerUserSourceModel_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

void
font_manager_user_source_model_clear (FontManagerUserSourceModel* self)
{
	guint n_items = 0U;
	GPtrArray* _tmp0_;
	GPtrArray* _tmp1_;
	g_return_if_fail (self != NULL);
	n_items = g_list_model_get_n_items ((GListModel*) self);
	font_manager_user_source_model_set_items (self, NULL);
	g_list_model_items_changed ((GListModel*) self, (guint) 0, n_items, (guint) 0);
	_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	_tmp1_ = _tmp0_;
	font_manager_user_source_model_set_items (self, _tmp1_);
	_g_ptr_array_unref0 (_tmp1_);
	return;
}

static Block10Data*
block10_data_ref (Block10Data* _data10_)
{
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}

static void
block10_data_unref (void * _userdata_)
{
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		GPtrArray* self;
		self = _data10_->self;
		_g_ptr_array_unref0 (self);
		g_slice_free (Block10Data, _data10_);
	}
}

static gint
__lambda0_ (Block10Data* _data10_,
            gconstpointer** a,
            gconstpointer** b)
{
	GPtrArray* self;
	gint result;
	self = _data10_->self;
	result = _data10_->compare_func ((gconstpointer**) (*a), (gconstpointer**) (*b));
	return result;
}

static gint
___lambda0__gcompare_data_func (gconstpointer a,
                                gconstpointer b,
                                gpointer self)
{
	gint result;
	result = __lambda0_ (self, a, b);
	return result;
}

static void
vala_g_ptr_array_sort (GPtrArray* self,
                       GCompareFunc compare_func)
{
	Block10Data* _data10_;
	g_return_if_fail (self != NULL);
	_data10_ = g_slice_new0 (Block10Data);
	_data10_->_ref_count_ = 1;
	_data10_->self = g_ptr_array_ref (self);
	_data10_->compare_func = compare_func;
	g_ptr_array_sort_with_data (self, ___lambda0__gcompare_data_func, _data10_);
	block10_data_unref (_data10_);
	_data10_ = NULL;
}

static gint
__lambda16_ (FontManagerSource* a,
             FontManagerSource* b)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gint _tmp6_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	g_object_get (a, "name", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	g_object_get (b, "name", &_tmp3_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp6_ = font_manager_natural_sort (_tmp2_, _tmp5_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp2_);
	result = _tmp6_;
	return result;
}

static gint
___lambda16__gcompare_func (gconstpointer a,
                            gconstpointer b)
{
	gint result;
	result = __lambda16_ ((FontManagerSource*) a, (FontManagerSource*) b);
	return result;
}

static gboolean
__lambda18_ (FontManagerUserSourceModel* self)
{
	FontManagerDirectories* _tmp0_;
	gboolean result;
	_tmp0_ = self->priv->sources;
	font_manager_selections_save ((FontManagerSelections*) _tmp0_);
	font_manager_user_source_model_save_active_items (self);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda18__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda18_ ((FontManagerUserSourceModel*) self);
	return result;
}

static void
__lambda17_ (FontManagerUserSourceModel* self)
{
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda18__gsource_func, g_object_ref (self), g_object_unref);
}

static void
___lambda17__g_list_model_items_changed (GListModel* _sender,
                                         guint position,
                                         guint removed,
                                         guint added,
                                         gpointer self)
{
	__lambda17_ ((FontManagerUserSourceModel*) self);
}

void
font_manager_user_source_model_reload (FontManagerUserSourceModel* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	FontManagerDirectories* _tmp3_ = NULL;
	FontManagerDirectories* _tmp4_;
	FontManagerDirectories* active = NULL;
	FontManagerDirectories* _tmp5_;
	FontManagerDirectories* _tmp6_;
	GPtrArray* _tmp29_;
	g_return_if_fail (self != NULL);
	font_manager_user_source_model_clear (self);
	_tmp0_ = font_manager_get_package_config_directory ();
	_tmp1_ = g_strdup ("source");
	_tmp2_ = g_strdup ("Sources.xml");
	_tmp3_ = font_manager_directories_new ();
	g_object_set ((FontManagerSelections*) _tmp3_, "config-dir", _tmp0_, NULL);
	_g_free0 (_tmp0_);
	g_object_set ((FontManagerSelections*) _tmp3_, "target-element", _tmp1_, NULL);
	_g_free0 (_tmp1_);
	g_object_set ((FontManagerSelections*) _tmp3_, "target-file", _tmp2_, NULL);
	_g_free0 (_tmp2_);
	_g_object_unref0 (self->priv->sources);
	self->priv->sources = _tmp3_;
	_tmp4_ = self->priv->sources;
	font_manager_selections_load ((FontManagerSelections*) _tmp4_);
	_tmp5_ = font_manager_directories_new ();
	active = _tmp5_;
	_tmp6_ = active;
	font_manager_selections_load ((FontManagerSelections*) _tmp6_);
	{
		FontManagerDirectories* _path_list = NULL;
		FontManagerDirectories* _tmp7_;
		guint _path_size = 0U;
		FontManagerDirectories* _tmp8_;
		guint _tmp9_;
		guint _tmp10_;
		gint _path_index = 0;
		_tmp7_ = self->priv->sources;
		_path_list = _tmp7_;
		_tmp8_ = _path_list;
		g_object_get ((FontManagerStringSet*) _tmp8_, "size", &_tmp9_, NULL);
		_tmp10_ = _tmp9_;
		_path_size = _tmp10_;
		_path_index = -1;
		while (TRUE) {
			gint _tmp11_;
			guint _tmp12_;
			gchar* path = NULL;
			FontManagerDirectories* _tmp13_;
			const gchar* _tmp14_;
			gchar* _tmp15_;
			const gchar* _tmp16_;
			FontManagerSource* item = NULL;
			const gchar* _tmp17_;
			GFile* _tmp18_;
			GFile* _tmp19_;
			FontManagerSource* _tmp20_;
			FontManagerSource* _tmp21_;
			FontManagerSource* _tmp22_;
			FontManagerDirectories* _tmp23_;
			FontManagerSource* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			FontManagerSource* _tmp28_;
			_path_index = _path_index + 1;
			_tmp11_ = _path_index;
			_tmp12_ = _path_size;
			if (!(((guint) _tmp11_) < _tmp12_)) {
				break;
			}
			_tmp13_ = _path_list;
			_tmp14_ = font_manager_string_set_get ((FontManagerStringSet*) _tmp13_, (guint) _path_index);
			_tmp15_ = g_strdup (_tmp14_);
			path = _tmp15_;
			_tmp16_ = path;
			if (_tmp16_ == NULL) {
				_g_free0 (path);
				continue;
			}
			_tmp17_ = path;
			_tmp18_ = g_file_new_for_path (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = font_manager_source_new (_tmp19_);
			_tmp21_ = _tmp20_;
			_g_object_unref0 (_tmp19_);
			item = _tmp21_;
			_tmp22_ = item;
			_tmp23_ = active;
			_tmp24_ = item;
			g_object_get (_tmp24_, "path", &_tmp25_, NULL);
			_tmp26_ = _tmp25_;
			_tmp27_ = _tmp26_;
			g_object_set (_tmp22_, "active", font_manager_string_set_contains ((FontManagerStringSet*) _tmp23_, _tmp27_), NULL);
			_g_free0 (_tmp27_);
			_tmp28_ = item;
			font_manager_user_source_model_add_item (self, _tmp28_);
			_g_object_unref0 (item);
			_g_free0 (path);
		}
	}
	_tmp29_ = self->priv->_items;
	vala_g_ptr_array_sort (_tmp29_, ___lambda16__gcompare_func);
	g_signal_connect_object ((GListModel*) self, "items-changed", (GCallback) ___lambda17__g_list_model_items_changed, self, G_CONNECT_AFTER);
	_g_object_unref0 (active);
	return;
}

static GType
font_manager_user_source_model_real_get_item_type (GListModel* base)
{
	FontManagerUserSourceModel * self;
	GType result;
	self = (FontManagerUserSourceModel*) base;
	result = font_manager_source_get_type ();
	return result;
}

static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

static guint
font_manager_user_source_model_real_get_n_items (GListModel* base)
{
	FontManagerUserSourceModel * self;
	gint _tmp0_ = 0;
	GPtrArray* _tmp1_;
	guint result;
	self = (FontManagerUserSourceModel*) base;
	_tmp1_ = self->priv->_items;
	if (_tmp1_ != NULL) {
		GPtrArray* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		_tmp2_ = self->priv->_items;
		_tmp3_ = vala_g_ptr_array_get_length (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = 0;
	}
	result = (guint) _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GObject*
font_manager_user_source_model_real_get_item (GListModel* base,
                                              guint position)
{
	FontManagerUserSourceModel * self;
	GPtrArray* _tmp0_;
	gconstpointer _tmp1_;
	GObject* _tmp2_;
	GObject* result;
	self = (FontManagerUserSourceModel*) base;
	_tmp0_ = self->priv->_items;
	_tmp1_ = g_ptr_array_index (_tmp0_, position);
	_tmp2_ = _g_object_ref0 ((GObject*) ((FontManagerSource*) _tmp1_));
	result = _tmp2_;
	return result;
}

static Block31Data*
block31_data_ref (Block31Data* _data31_)
{
	g_atomic_int_inc (&_data31_->_ref_count_);
	return _data31_;
}

static void
block31_data_unref (void * _userdata_)
{
	Block31Data* _data31_;
	_data31_ = (Block31Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data31_->_ref_count_)) {
		FontManagerUserSourceModel* self;
		self = _data31_->self;
		_g_object_unref0 (self);
		g_slice_free (Block31Data, _data31_);
	}
}

static void
__lambda14_ (Block31Data* _data31_)
{
	FontManagerUserSourceModel* self;
	self = _data31_->self;
	g_list_model_items_changed ((GListModel*) self, _data31_->position, (guint) 0, (guint) 0);
}

static void
___lambda14__font_manager_source_changed (FontManagerSource* _sender,
                                          GFile* file,
                                          GFile* other_file,
                                          GFileMonitorEvent event_type,
                                          gpointer self)
{
	__lambda14_ (self);
}

static void
__lambda15_ (Block31Data* _data31_)
{
	FontManagerUserSourceModel* self;
	self = _data31_->self;
	g_list_model_items_changed ((GListModel*) self, _data31_->position, (guint) 0, (guint) 0);
}

static void
___lambda15__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda15_ (self);
}

void
font_manager_user_source_model_add_item (FontManagerUserSourceModel* self,
                                         FontManagerSource* item)
{
	Block31Data* _data31_;
	FontManagerDirectories* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GPtrArray* _tmp4_;
	FontManagerSource* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_data31_ = g_slice_new0 (Block31Data);
	_data31_->_ref_count_ = 1;
	_data31_->self = g_object_ref (self);
	_tmp0_ = self->priv->sources;
	g_object_get (item, "path", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	font_manager_string_set_add ((FontManagerStringSet*) _tmp0_, _tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = self->priv->_items;
	_tmp5_ = _g_object_ref0 (item);
	g_ptr_array_add (_tmp4_, _tmp5_);
	_data31_->position = g_list_model_get_n_items ((GListModel*) self) - 1;
	g_list_model_items_changed ((GListModel*) self, _data31_->position, (guint) 0, (guint) 1);
	g_signal_connect_data (item, "changed", (GCallback) ___lambda14__font_manager_source_changed, block31_data_ref (_data31_), (GClosureNotify) block31_data_unref, 0);
	g_signal_connect_data ((GObject*) item, "notify::active", (GCallback) ___lambda15__g_object_notify, block31_data_ref (_data31_), (GClosureNotify) block31_data_unref, 0);
	block31_data_unref (_data31_);
	_data31_ = NULL;
	return;
}

static void
_font_manager_user_source_model_on_database_purged_gasync_ready_callback (GObject* source_object,
                                                                          GTask* task,
                                                                          gpointer self)
{
	font_manager_user_source_model_on_database_purged ((FontManagerUserSourceModel*) self, source_object, task);
	g_object_unref (self);
}

static void
_font_manager_user_source_model_purge_database_entries_gtask_thread_func (GTask* task,
                                                                          GObject* source_object,
                                                                          void* task_data,
                                                                          GCancellable* cancellable)
{
	font_manager_user_source_model_purge_database_entries (task, source_object, task_data, cancellable);
}

void
font_manager_user_source_model_remove_item (FontManagerUserSourceModel* self,
                                            guint position)
{
	FontManagerSource* item = NULL;
	GPtrArray* _tmp0_;
	gconstpointer _tmp1_;
	FontManagerSource* _tmp2_;
	FontManagerDirectories* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GPtrArray* _tmp7_;
	GTask* task = NULL;
	GTask* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_items;
	_tmp1_ = g_ptr_array_index (_tmp0_, position);
	_tmp2_ = _g_object_ref0 ((FontManagerSource*) _tmp1_);
	item = _tmp2_;
	_tmp3_ = self->priv->sources;
	g_object_get (item, "path", &_tmp4_, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	font_manager_string_set_remove ((FontManagerStringSet*) _tmp3_, _tmp6_);
	_g_free0 (_tmp6_);
	_tmp7_ = self->priv->_items;
	g_ptr_array_remove (_tmp7_, item);
	g_list_model_items_changed ((GListModel*) self, position, (guint) 1, (guint) 0);
	_tmp8_ = g_task_new ((GObject*) self, NULL, _font_manager_user_source_model_on_database_purged_gasync_ready_callback, g_object_ref (self));
	task = _tmp8_;
	g_object_get (item, "path", &_tmp9_, NULL);
	_tmp10_ = _tmp9_;
	g_task_set_task_data (task, _tmp10_, NULL);
	g_task_run_in_thread (task, _font_manager_user_source_model_purge_database_entries_gtask_thread_func);
	_g_object_unref0 (task);
	_g_object_unref0 (item);
	return;
}

static Block32Data*
block32_data_ref (Block32Data* _data32_)
{
	g_atomic_int_inc (&_data32_->_ref_count_);
	return _data32_;
}

static void
block32_data_unref (void * _userdata_)
{
	Block32Data* _data32_;
	_data32_ = (Block32Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data32_->_ref_count_)) {
		FontManagerUserSourceModel* self;
		self = _data32_->self;
		_g_object_unref0 (_data32_->active);
		_g_object_unref0 (self);
		g_slice_free (Block32Data, _data32_);
	}
}

static void
__lambda19_ (Block32Data* _data32_,
             FontManagerSource* item)
{
	FontManagerUserSourceModel* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = _data32_->self;
	g_return_if_fail (item != NULL);
	g_object_get (item, "active", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		g_object_get (item, "path", &_tmp2_, NULL);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		font_manager_string_set_add ((FontManagerStringSet*) _data32_->active, _tmp4_);
		_g_free0 (_tmp4_);
	}
}

static void
___lambda19__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda19_ (self, (FontManagerSource*) data);
}

static void
font_manager_user_source_model_save_active_items (FontManagerUserSourceModel* self)
{
	Block32Data* _data32_;
	FontManagerDirectories* _tmp0_;
	GPtrArray* _tmp1_;
	g_return_if_fail (self != NULL);
	_data32_ = g_slice_new0 (Block32Data);
	_data32_->_ref_count_ = 1;
	_data32_->self = g_object_ref (self);
	_tmp0_ = font_manager_directories_new ();
	_data32_->active = _tmp0_;
	_tmp1_ = self->priv->_items;
	g_ptr_array_foreach (_tmp1_, ___lambda19__gfunc, _data32_);
	font_manager_selections_save ((FontManagerSelections*) _data32_->active);
	block32_data_unref (_data32_);
	_data32_ = NULL;
	return;
}

static void
font_manager_user_source_model_on_database_purged (FontManagerUserSourceModel* self,
                                                   GObject* unused_object,
                                                   GTask* unused_task)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (unused_task != NULL);
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
font_manager_user_source_model_purge_database_entries (GTask* task,
                                                       GObject* unused_source,
                                                       void* data,
                                                       GCancellable* cancellable)
{
	gchar* path = NULL;
	gchar* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (task != NULL);
	g_return_if_fail (unused_source != NULL);
	_tmp0_ = string_replace ((const gchar*) data, "'", "''");
	path = _tmp0_;
	{
		FontManagerDatabase* db = NULL;
		FontManagerDatabase* _tmp1_;
		gchar** tables = NULL;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar** _tmp6_;
		gint tables_length1;
		gint _tables_size_;
		gchar** _tmp7_;
		gint _tmp7__length1;
		FontManagerDatabase* _tmp19_;
		_tmp1_ = font_manager_database_proxy_get_default_db ();
		db = _tmp1_;
		_tmp2_ = g_strdup ("Fonts");
		_tmp3_ = g_strdup ("Metadata");
		_tmp4_ = g_strdup ("Orthography");
		_tmp5_ = g_strdup ("Panose");
		_tmp6_ = g_new0 (gchar*, 4 + 1);
		_tmp6_[0] = _tmp2_;
		_tmp6_[1] = _tmp3_;
		_tmp6_[2] = _tmp4_;
		_tmp6_[3] = _tmp5_;
		tables = _tmp6_;
		tables_length1 = 4;
		_tables_size_ = tables_length1;
		_tmp7_ = tables;
		_tmp7__length1 = tables_length1;
		{
			gchar** table_collection = NULL;
			gint table_collection_length1 = 0;
			gint _table_collection_size_ = 0;
			gint table_it = 0;
			table_collection = _tmp7_;
			table_collection_length1 = _tmp7__length1;
			for (table_it = 0; table_it < table_collection_length1; table_it = table_it + 1) {
				gchar* _tmp8_;
				gchar* table = NULL;
				_tmp8_ = g_strdup (table_collection[table_it]);
				table = _tmp8_;
				{
					FontManagerDatabase* _tmp9_;
					const gchar* _tmp10_;
					const gchar* _tmp11_;
					const gchar* _tmp12_;
					const gchar* _tmp13_;
					gchar* _tmp14_;
					gchar* _tmp15_;
					FontManagerDatabase* _tmp16_;
					sqlite3_stmt* _tmp17_;
					FontManagerDatabase* _tmp18_;
					_tmp9_ = db;
					_tmp10_ = table;
					_tmp11_ = string_to_string (_tmp10_);
					_tmp12_ = path;
					_tmp13_ = string_to_string (_tmp12_);
					_tmp14_ = g_strconcat ("DELETE FROM ", _tmp11_, " WHERE filepath LIKE '%", _tmp13_, "%'", NULL);
					_tmp15_ = _tmp14_;
					font_manager_database_execute_query (_tmp9_, _tmp15_, &_inner_error0_);
					_g_free0 (_tmp15_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_free0 (table);
						tables = (_vala_array_free (tables, tables_length1, (GDestroyNotify) g_free), NULL);
						_g_object_unref0 (db);
						goto __catch0_g_error;
					}
					_tmp16_ = db;
					_tmp17_ = font_manager_database_get_cursor (_tmp16_);
					sqlite3_step (_tmp17_);
					_tmp18_ = db;
					font_manager_database_end_query (_tmp18_);
					_g_free0 (table);
				}
			}
		}
		_tmp19_ = db;
		font_manager_database_vacuum (_tmp19_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			tables = (_vala_array_free (tables, tables_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (db);
			goto __catch0_g_error;
		}
		tables = (_vala_array_free (tables, tables_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (db);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp20_;
		GError* _tmp21_;
		const gchar* _tmp22_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp20_ = path;
		_tmp21_ = e;
		_tmp22_ = _tmp21_->message;
		g_warning ("UserSources.vala:133: Failed to remove database entries for %s : %s", _tmp20_, _tmp22_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (path);
	return;
}

FontManagerUserSourceModel*
font_manager_user_source_model_construct (GType object_type)
{
	FontManagerUserSourceModel * self = NULL;
	self = (FontManagerUserSourceModel*) g_object_new (object_type, NULL);
	return self;
}

FontManagerUserSourceModel*
font_manager_user_source_model_new (void)
{
	return font_manager_user_source_model_construct (FONT_MANAGER_TYPE_USER_SOURCE_MODEL);
}

GPtrArray*
font_manager_user_source_model_get_items (FontManagerUserSourceModel* self)
{
	GPtrArray* result;
	GPtrArray* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_items;
	result = _tmp0_;
	return result;
}

static gpointer
_g_ptr_array_ref0 (gpointer self)
{
	return self ? g_ptr_array_ref (self) : NULL;
}

static void
font_manager_user_source_model_set_items (FontManagerUserSourceModel* self,
                                          GPtrArray* value)
{
	GPtrArray* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_user_source_model_get_items (self);
	if (old_value != value) {
		GPtrArray* _tmp0_;
		_tmp0_ = _g_ptr_array_ref0 (value);
		_g_ptr_array_unref0 (self->priv->_items);
		self->priv->_items = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_user_source_model_properties[FONT_MANAGER_USER_SOURCE_MODEL_ITEMS_PROPERTY]);
	}
}

static GObject *
font_manager_user_source_model_constructor (GType type,
                                            guint n_construct_properties,
                                            GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	FontManagerUserSourceModel * self;
	parent_class = G_OBJECT_CLASS (font_manager_user_source_model_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FONT_MANAGER_TYPE_USER_SOURCE_MODEL, FontManagerUserSourceModel);
	font_manager_user_source_model_reload (self);
	return obj;
}

static void
font_manager_user_source_model_class_init (FontManagerUserSourceModelClass * klass,
                                           gpointer klass_data)
{
	font_manager_user_source_model_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FontManagerUserSourceModel_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_font_manager_user_source_model_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_font_manager_user_source_model_set_property;
	G_OBJECT_CLASS (klass)->constructor = font_manager_user_source_model_constructor;
	G_OBJECT_CLASS (klass)->finalize = font_manager_user_source_model_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_USER_SOURCE_MODEL_ITEMS_PROPERTY, font_manager_user_source_model_properties[FONT_MANAGER_USER_SOURCE_MODEL_ITEMS_PROPERTY] = g_param_spec_boxed ("items", "items", "items", G_TYPE_PTR_ARRAY, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
font_manager_user_source_model_g_list_model_interface_init (GListModelInterface * iface,
                                                            gpointer iface_data)
{
	font_manager_user_source_model_g_list_model_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_item_type = (GType (*) (GListModel*)) font_manager_user_source_model_real_get_item_type;
	iface->get_n_items = (guint (*) (GListModel*)) font_manager_user_source_model_real_get_n_items;
	iface->get_item = (GObject* (*) (GListModel*, guint)) font_manager_user_source_model_real_get_item;
}

static void
font_manager_user_source_model_instance_init (FontManagerUserSourceModel * self,
                                              gpointer klass)
{
	GPtrArray* _tmp0_;
	self->priv = font_manager_user_source_model_get_instance_private (self);
	_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	self->priv->_items = _tmp0_;
}

static void
font_manager_user_source_model_finalize (GObject * obj)
{
	FontManagerUserSourceModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FONT_MANAGER_TYPE_USER_SOURCE_MODEL, FontManagerUserSourceModel);
	_g_ptr_array_unref0 (self->priv->_items);
	_g_object_unref0 (self->priv->sources);
	G_OBJECT_CLASS (font_manager_user_source_model_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
font_manager_user_source_model_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FontManagerUserSourceModelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) font_manager_user_source_model_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FontManagerUserSourceModel), 0, (GInstanceInitFunc) font_manager_user_source_model_instance_init, NULL };
	static const GInterfaceInfo g_list_model_info = { (GInterfaceInitFunc) font_manager_user_source_model_g_list_model_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType font_manager_user_source_model_type_id;
	font_manager_user_source_model_type_id = g_type_register_static (G_TYPE_OBJECT, "FontManagerUserSourceModel", &g_define_type_info, 0);
	g_type_add_interface_static (font_manager_user_source_model_type_id, g_list_model_get_type (), &g_list_model_info);
	FontManagerUserSourceModel_private_offset = g_type_add_instance_private (font_manager_user_source_model_type_id, sizeof (FontManagerUserSourceModelPrivate));
	return font_manager_user_source_model_type_id;
}

GType
font_manager_user_source_model_get_type (void)
{
	static volatile gsize font_manager_user_source_model_type_id__once = 0;
	if (g_once_init_enter (&font_manager_user_source_model_type_id__once)) {
		GType font_manager_user_source_model_type_id;
		font_manager_user_source_model_type_id = font_manager_user_source_model_get_type_once ();
		g_once_init_leave (&font_manager_user_source_model_type_id__once, font_manager_user_source_model_type_id);
	}
	return font_manager_user_source_model_type_id__once;
}

static void
_vala_font_manager_user_source_model_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec)
{
	FontManagerUserSourceModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_TYPE_USER_SOURCE_MODEL, FontManagerUserSourceModel);
	switch (property_id) {
		case FONT_MANAGER_USER_SOURCE_MODEL_ITEMS_PROPERTY:
		g_value_set_boxed (value, font_manager_user_source_model_get_items (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_font_manager_user_source_model_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec)
{
	FontManagerUserSourceModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_TYPE_USER_SOURCE_MODEL, FontManagerUserSourceModel);
	switch (property_id) {
		case FONT_MANAGER_USER_SOURCE_MODEL_ITEMS_PROPERTY:
		font_manager_user_source_model_set_items (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
font_manager_user_source_list_get_instance_private (FontManagerUserSourceList* self)
{
	return G_STRUCT_MEMBER_P (self, FontManagerUserSourceList_private_offset);
}

static GtkWidget*
_font_manager_user_source_list_row_from_item_gtk_list_box_create_widget_func (GObject* item,
                                                                              gpointer self)
{
	GtkWidget* result;
	result = font_manager_user_source_list_row_from_item ((FontManagerUserSourceList*) self, item);
	return result;
}

static void
__lambda154_ (FontManagerUserSourceList* self)
{
	GtkListBox* _tmp0_;
	FontManagerUserSourceModel* _tmp1_;
	_tmp0_ = ((FontManagerPreferenceList*) self)->list;
	_tmp1_ = self->priv->_model;
	gtk_list_box_bind_model (_tmp0_, (GListModel*) _tmp1_, _font_manager_user_source_list_row_from_item_gtk_list_box_create_widget_func, g_object_ref (self), g_object_unref);
}

static void
___lambda154__g_object_notify (GObject* _sender,
                               GParamSpec* pspec,
                               gpointer self)
{
	__lambda154_ ((FontManagerUserSourceList*) self);
}

static gboolean
_font_manager_user_source_list_on_drag_data_received_gtk_drop_target_drop (GtkDropTarget* _sender,
                                                                           GValue* value,
                                                                           gdouble x,
                                                                           gdouble y,
                                                                           gpointer self)
{
	gboolean result;
	result = font_manager_user_source_list_on_drag_data_received ((FontManagerUserSourceList*) self, value, x, y);
	return result;
}

static void
__lambda156_ (FontManagerUserSourceList* self)
{
	self->priv->refresh_required = TRUE;
}

static void
___lambda156__g_list_model_items_changed (GListModel* _sender,
                                          guint position,
                                          guint removed,
                                          guint added,
                                          gpointer self)
{
	__lambda156_ ((FontManagerUserSourceList*) self);
}

FontManagerUserSourceList*
font_manager_user_source_list_construct (GType object_type)
{
	FontManagerUserSourceList * self = NULL;
	FontManagerBaseControls* _tmp0_;
	FontManagerUserSourceModel* _tmp1_;
	FontManagerUserSourceModel* _tmp2_;
	gchar* w1 = NULL;
	gchar* _tmp3_;
	gchar* w2 = NULL;
	gchar* _tmp4_;
	gchar* w3 = NULL;
	gchar* _tmp5_;
	FontManagerPlaceHolder* place_holder = NULL;
	FontManagerPlaceHolder* _tmp6_;
	GtkListBox* _tmp7_;
	FontManagerBaseControls* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GtkImage* _tmp13_;
	GtkImage* _tmp14_;
	GtkDropTarget* drop_target = NULL;
	GtkDropTarget* _tmp15_;
	GtkEventController* _tmp16_;
	FontManagerUserSourceModel* _tmp17_;
	self = (FontManagerUserSourceList*) font_manager_preference_list_construct (object_type);
	font_manager_widget_set_name ((GtkWidget*) self, "FontManagerUserSourceList");
	_tmp0_ = ((FontManagerPreferenceList*) self)->controls;
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, TRUE);
	g_signal_connect_object ((GObject*) self, "notify::model", (GCallback) ___lambda154__g_object_notify, self, 0);
	_tmp1_ = font_manager_user_source_model_new ();
	_tmp2_ = _tmp1_;
	font_manager_user_source_list_set_model (self, _tmp2_);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = g_strdup (_ ("Font Sources"));
	w1 = _tmp3_;
	_tmp4_ = g_strdup (_ ("Easily add or preview fonts without actually installing them."));
	w2 = _tmp4_;
	_tmp5_ = g_strdup (_ ("To add a new source simply drag a folder onto this area or click the a" \
"dd button in the toolbar."));
	w3 = _tmp5_;
	_tmp6_ = (FontManagerPlaceHolder*) font_manager_place_holder_new (w1, w2, w3, "folder-symbolic");
	g_object_ref_sink (_tmp6_);
	place_holder = _tmp6_;
	_tmp7_ = ((FontManagerPreferenceList*) self)->list;
	gtk_list_box_set_placeholder (_tmp7_, (GtkWidget*) place_holder);
	_tmp8_ = ((FontManagerPreferenceList*) self)->controls;
	_tmp9_ = string_to_string (FONT_MANAGER_USER_SOURCE_LIST_help_text);
	_tmp10_ = string_to_string (FONT_MANAGER_FONTCONFIG_DISCLAIMER);
	_tmp11_ = g_strconcat (_tmp9_, "\n\n", _tmp10_, NULL);
	_tmp12_ = _tmp11_;
	_tmp13_ = font_manager_inline_help_widget (_tmp12_);
	_tmp14_ = _tmp13_;
	gtk_box_append ((GtkBox*) _tmp8_, (GtkWidget*) _tmp14_);
	_g_object_unref0 (_tmp14_);
	_g_free0 (_tmp12_);
	_tmp15_ = gtk_drop_target_new (gdk_file_list_get_type (), GDK_ACTION_COPY);
	drop_target = _tmp15_;
	_tmp16_ = _g_object_ref0 ((GtkEventController*) drop_target);
	gtk_widget_add_controller ((GtkWidget*) self, _tmp16_);
	g_signal_connect_object (drop_target, "drop", (GCallback) _font_manager_user_source_list_on_drag_data_received_gtk_drop_target_drop, self, 0);
	_tmp17_ = self->priv->_model;
	g_signal_connect_object ((GListModel*) _tmp17_, "items-changed", (GCallback) ___lambda156__g_list_model_items_changed, self, 0);
	_g_object_unref0 (drop_target);
	_g_object_unref0 (place_holder);
	_g_free0 (w3);
	_g_free0 (w2);
	_g_free0 (w1);
	return self;
}

FontManagerUserSourceList*
font_manager_user_source_list_new (void)
{
	return font_manager_user_source_list_construct (FONT_MANAGER_TYPE_USER_SOURCE_LIST);
}

static void
font_manager_user_source_list_on_file_selections_ready (FontManagerUserSourceList* self,
                                                        GObject* obj,
                                                        GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (res != NULL);
	g_return_if_fail (obj != NULL);
	{
		GtkFileDialog* dialog = NULL;
		GtkFileDialog* _tmp0_;
		GListModel* files = NULL;
		GtkFileDialog* _tmp1_;
		GListModel* _tmp2_;
		_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (obj, gtk_file_dialog_get_type (), GtkFileDialog));
		dialog = _tmp0_;
		_tmp1_ = dialog;
		_tmp2_ = gtk_file_dialog_select_multiple_folders_finish (_tmp1_, res, &_inner_error0_);
		files = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (dialog);
			goto __catch0_g_error;
		}
		{
			guint i = 0U;
			i = (guint) 0;
			{
				gboolean _tmp3_ = FALSE;
				_tmp3_ = TRUE;
				while (TRUE) {
					GListModel* _tmp5_;
					GFile* file = NULL;
					GListModel* _tmp6_;
					GObject* _tmp7_;
					FontManagerSource* source = NULL;
					GFile* _tmp8_;
					FontManagerSource* _tmp9_;
					FontManagerUserSourceModel* _tmp10_;
					FontManagerSource* _tmp11_;
					if (!_tmp3_) {
						guint _tmp4_;
						_tmp4_ = i;
						i = _tmp4_ + 1;
					}
					_tmp3_ = FALSE;
					_tmp5_ = files;
					if (!(i < g_list_model_get_n_items (_tmp5_))) {
						break;
					}
					_tmp6_ = files;
					_tmp7_ = g_list_model_get_item (_tmp6_, i);
					file = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, g_file_get_type (), GFile);
					_tmp8_ = file;
					_tmp9_ = font_manager_source_new (_tmp8_);
					source = _tmp9_;
					_tmp10_ = self->priv->_model;
					_tmp11_ = source;
					font_manager_user_source_model_add_item (_tmp10_, _tmp11_);
					_g_object_unref0 (source);
					_g_object_unref0 (file);
				}
			}
		}
		_g_object_unref0 (files);
		_g_object_unref0 (dialog);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp12_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp12_ = e;
		if (_tmp12_->code == GTK_DIALOG_ERROR_FAILED) {
			GError* _tmp13_;
			const gchar* _tmp14_;
			_tmp13_ = e;
			_tmp14_ = _tmp13_->message;
			g_warning ("UserSources.vala:182: %s", _tmp14_);
		} else {
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			GError* _tmp17_;
			const gchar* _tmp18_;
			_tmp15_ = gtk_widget_get_name ((GtkWidget*) self);
			_tmp16_ = _tmp15_;
			_tmp17_ = e;
			_tmp18_ = _tmp17_->message;
			g_debug ("UserSources.vala:184: %s.on_file_selections_ready : %s", _tmp16_, _tmp18_);
		}
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	return;
}

static void
_font_manager_user_source_list_on_file_selections_ready_gasync_ready_callback (GObject* source_object,
                                                                               GAsyncResult* res,
                                                                               gpointer self)
{
	font_manager_user_source_list_on_file_selections_ready ((FontManagerUserSourceList*) self, source_object, res);
	g_object_unref (self);
}

static void
font_manager_user_source_list_real_on_add_selected (FontManagerPreferenceList* base)
{
	FontManagerUserSourceList * self;
	GtkFileDialog* dialog = NULL;
	GtkFileDialog* _tmp0_;
	GtkWindow* _tmp1_;
	GtkWindow* _tmp2_;
	self = (FontManagerUserSourceList*) base;
	_tmp0_ = font_manager_file_selector_get_selected_sources ();
	dialog = _tmp0_;
	_tmp1_ = font_manager_get_parent_window ((GtkWidget*) self);
	_tmp2_ = _tmp1_;
	gtk_file_dialog_select_multiple_folders (dialog, _tmp2_, NULL, _font_manager_user_source_list_on_file_selections_ready_gasync_ready_callback, g_object_ref (self));
	_g_object_unref0 (_tmp2_);
	_g_object_unref0 (dialog);
	return;
}

static void
font_manager_user_source_list_real_on_remove_selected (FontManagerPreferenceList* base)
{
	FontManagerUserSourceList * self;
	GtkListBox* _tmp0_;
	GtkListBoxRow* _tmp1_;
	guint position = 0U;
	GtkListBox* _tmp2_;
	GtkListBoxRow* _tmp3_;
	FontManagerUserSourceModel* _tmp4_;
	GtkListBox* _tmp8_;
	GtkListBox* _tmp9_;
	GtkListBoxRow* _tmp10_;
	self = (FontManagerUserSourceList*) base;
	_tmp0_ = ((FontManagerPreferenceList*) self)->list;
	_tmp1_ = gtk_list_box_get_selected_row (_tmp0_);
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp2_ = ((FontManagerPreferenceList*) self)->list;
	_tmp3_ = gtk_list_box_get_selected_row (_tmp2_);
	position = (guint) gtk_list_box_row_get_index (_tmp3_);
	_tmp4_ = self->priv->_model;
	font_manager_user_source_model_remove_item (_tmp4_, position);
	while (TRUE) {
		gboolean _tmp5_ = FALSE;
		guint _tmp7_;
		if (position > ((guint) 0)) {
			FontManagerUserSourceModel* _tmp6_;
			_tmp6_ = self->priv->_model;
			_tmp5_ = position >= g_list_model_get_n_items ((GListModel*) _tmp6_);
		} else {
			_tmp5_ = FALSE;
		}
		if (!_tmp5_) {
			break;
		}
		_tmp7_ = position;
		position = _tmp7_ - 1;
	}
	_tmp8_ = ((FontManagerPreferenceList*) self)->list;
	_tmp9_ = ((FontManagerPreferenceList*) self)->list;
	_tmp10_ = gtk_list_box_get_row_at_index (_tmp9_, (gint) position);
	gtk_list_box_select_row (_tmp8_, _tmp10_);
	return;
}

static void
font_manager_user_source_list_real_on_map (FontManagerPreferenceList* base)
{
	FontManagerUserSourceList * self;
	FontManagerUserSourceModel* _tmp0_;
	self = (FontManagerUserSourceList*) base;
	_tmp0_ = self->priv->_model;
	font_manager_user_source_model_reload (_tmp0_);
	FONT_MANAGER_PREFERENCE_LIST_CLASS (font_manager_user_source_list_parent_class)->on_map (G_TYPE_CHECK_INSTANCE_CAST (self, FONT_MANAGER_TYPE_PREFERENCE_LIST, FontManagerPreferenceList));
	return;
}

static gboolean
__lambda157_ (FontManagerUserSourceList* self)
{
	FontManagerApplication* _tmp0_;
	FontManagerApplication* _tmp1_;
	gboolean result;
	_tmp0_ = font_manager_get_default_application ();
	_tmp1_ = _tmp0_;
	font_manager_application_reload (_tmp1_);
	_g_object_unref0 (_tmp1_);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda157__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda157_ ((FontManagerUserSourceList*) self);
	return result;
}

static void
font_manager_user_source_list_real_on_unmap (FontManagerPreferenceList* base)
{
	FontManagerUserSourceList * self;
	self = (FontManagerUserSourceList*) base;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda157__gsource_func, g_object_ref (self), g_object_unref);
	return;
}

static Block33Data*
block33_data_ref (Block33Data* _data33_)
{
	g_atomic_int_inc (&_data33_->_ref_count_);
	return _data33_;
}

static void
block33_data_unref (void * _userdata_)
{
	Block33Data* _data33_;
	_data33_ = (Block33Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data33_->_ref_count_)) {
		FontManagerUserSourceList* self;
		self = _data33_->self;
		_g_object_unref0 (_data33_->row);
		_g_object_unref0 (_data33_->source);
		_g_object_unref0 (self);
		g_slice_free (Block33Data, _data33_);
	}
}

static void
__lambda155_ (Block33Data* _data33_)
{
	FontManagerUserSourceList* self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	self = _data33_->self;
	_tmp0_ = font_manager_source_get_status_message (_data33_->source);
	_tmp1_ = _tmp0_;
	g_object_set (_data33_->row, "subtitle", _tmp1_, NULL);
	_g_free0 (_tmp1_);
}

static void
___lambda155__g_object_notify (GObject* _sender,
                               GParamSpec* pspec,
                               gpointer self)
{
	__lambda155_ (self);
}

static GtkWidget*
font_manager_user_source_list_row_from_item (FontManagerUserSourceList* self,
                                             GObject* item)
{
	Block33Data* _data33_;
	FontManagerSource* _tmp0_;
	GtkSwitch* control = NULL;
	GtkSwitch* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	FontManagerPreferenceRow* _tmp11_;
	FontManagerPreferenceRow* _tmp12_;
	GBindingFlags flags = 0U;
	GtkWidget* _tmp13_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (item != NULL, NULL);
	_data33_ = g_slice_new0 (Block33Data);
	_data33_->_ref_count_ = 1;
	_data33_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (item, font_manager_source_get_type (), FontManagerSource));
	_data33_->source = _tmp0_;
	_tmp1_ = (GtkSwitch*) gtk_switch_new ();
	g_object_ref_sink (_tmp1_);
	control = _tmp1_;
	g_object_get (_data33_->source, "name", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	g_object_get (_data33_->source, "path", &_tmp5_, NULL);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_;
	g_object_get (_data33_->source, "icon-name", &_tmp8_, NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = _tmp9_;
	_tmp11_ = (FontManagerPreferenceRow*) font_manager_preference_row_new (_tmp4_, _tmp7_, _tmp10_, (GtkWidget*) control);
	g_object_ref_sink (_tmp11_);
	_tmp12_ = _tmp11_;
	_g_free0 (_tmp10_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp4_);
	_data33_->row = _tmp12_;
	flags = G_BINDING_DEFAULT | G_BINDING_SYNC_CREATE;
	g_object_bind_property_with_closures ((GObject*) _data33_->source, "icon-name", (GObject*) _data33_->row, "icon-name", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	g_object_bind_property_with_closures ((GObject*) _data33_->source, "name", (GObject*) _data33_->row, "title", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	g_object_bind_property_with_closures ((GObject*) _data33_->source, "active", (GObject*) control, "active", G_BINDING_BIDIRECTIONAL | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	g_object_bind_property_with_closures ((GObject*) _data33_->source, "available", (GObject*) control, "sensitive", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	g_signal_connect_data ((GObject*) _data33_->source, "notify::available", (GCallback) ___lambda155__g_object_notify, block33_data_ref (_data33_), (GClosureNotify) block33_data_unref, 0);
	_tmp13_ = _g_object_ref0 ((GtkWidget*) _data33_->row);
	result = _tmp13_;
	_g_object_unref0 (control);
	block33_data_unref (_data33_);
	_data33_ = NULL;
	return result;
}

static gboolean
font_manager_user_source_list_on_drag_data_received (FontManagerUserSourceList* self,
                                                     GValue* value,
                                                     gdouble x,
                                                     gdouble y)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (value != NULL, FALSE);
	if (G_VALUE_HOLDS (value, gdk_file_list_get_type ())) {
		GSList* filelist = NULL;
		void* _tmp0_;
		_tmp0_ = g_value_get_boxed (value);
		filelist = _tmp0_;
		{
			GSList* files = NULL;
			GSList* _tmp1_;
			_tmp1_ = filelist;
			files = _tmp1_;
			{
				gboolean _tmp2_ = FALSE;
				_tmp2_ = TRUE;
				while (TRUE) {
					GSList* _tmp5_;
					GFile* file = NULL;
					GSList* _tmp6_;
					gconstpointer _tmp7_;
					FontManagerSource* source = NULL;
					GFile* _tmp8_;
					FontManagerSource* _tmp9_;
					FontManagerUserSourceModel* _tmp10_;
					FontManagerSource* _tmp11_;
					if (!_tmp2_) {
						GSList* _tmp3_;
						GSList* _tmp4_;
						_tmp3_ = files;
						_tmp4_ = _tmp3_->next;
						files = _tmp4_;
					}
					_tmp2_ = FALSE;
					_tmp5_ = files;
					if (!(_tmp5_ != NULL)) {
						break;
					}
					_tmp6_ = files;
					_tmp7_ = _tmp6_->data;
					file = (GFile*) _tmp7_;
					_tmp8_ = file;
					_tmp9_ = font_manager_source_new (_tmp8_);
					source = _tmp9_;
					_tmp10_ = self->priv->_model;
					_tmp11_ = source;
					font_manager_user_source_model_add_item (_tmp10_, _tmp11_);
					_g_object_unref0 (source);
				}
			}
		}
	}
	result = TRUE;
	return result;
}

FontManagerUserSourceModel*
font_manager_user_source_list_get_model (FontManagerUserSourceList* self)
{
	FontManagerUserSourceModel* result;
	FontManagerUserSourceModel* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_model;
	result = _tmp0_;
	return result;
}

void
font_manager_user_source_list_set_model (FontManagerUserSourceList* self,
                                         FontManagerUserSourceModel* value)
{
	FontManagerUserSourceModel* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_user_source_list_get_model (self);
	if (old_value != value) {
		FontManagerUserSourceModel* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_model);
		self->priv->_model = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_user_source_list_properties[FONT_MANAGER_USER_SOURCE_LIST_MODEL_PROPERTY]);
	}
}

static void
font_manager_user_source_list_class_init (FontManagerUserSourceListClass * klass,
                                          gpointer klass_data)
{
	font_manager_user_source_list_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FontManagerUserSourceList_private_offset);
	((FontManagerPreferenceListClass *) klass)->on_add_selected = (void (*) (FontManagerPreferenceList*)) font_manager_user_source_list_real_on_add_selected;
	((FontManagerPreferenceListClass *) klass)->on_remove_selected = (void (*) (FontManagerPreferenceList*)) font_manager_user_source_list_real_on_remove_selected;
	((FontManagerPreferenceListClass *) klass)->on_map = (void (*) (FontManagerPreferenceList*)) font_manager_user_source_list_real_on_map;
	((FontManagerPreferenceListClass *) klass)->on_unmap = (void (*) (FontManagerPreferenceList*)) font_manager_user_source_list_real_on_unmap;
	G_OBJECT_CLASS (klass)->get_property = _vala_font_manager_user_source_list_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_font_manager_user_source_list_set_property;
	G_OBJECT_CLASS (klass)->finalize = font_manager_user_source_list_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_USER_SOURCE_LIST_MODEL_PROPERTY, font_manager_user_source_list_properties[FONT_MANAGER_USER_SOURCE_LIST_MODEL_PROPERTY] = g_param_spec_object ("model", "model", "model", FONT_MANAGER_TYPE_USER_SOURCE_MODEL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
font_manager_user_source_list_instance_init (FontManagerUserSourceList * self,
                                             gpointer klass)
{
	self->priv = font_manager_user_source_list_get_instance_private (self);
	self->priv->refresh_required = FALSE;
}

static void
font_manager_user_source_list_finalize (GObject * obj)
{
	FontManagerUserSourceList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FONT_MANAGER_TYPE_USER_SOURCE_LIST, FontManagerUserSourceList);
	_g_object_unref0 (self->priv->_model);
	G_OBJECT_CLASS (font_manager_user_source_list_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
font_manager_user_source_list_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FontManagerUserSourceListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) font_manager_user_source_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FontManagerUserSourceList), 0, (GInstanceInitFunc) font_manager_user_source_list_instance_init, NULL };
	GType font_manager_user_source_list_type_id;
	font_manager_user_source_list_type_id = g_type_register_static (FONT_MANAGER_TYPE_PREFERENCE_LIST, "FontManagerUserSourceList", &g_define_type_info, 0);
	FontManagerUserSourceList_private_offset = g_type_add_instance_private (font_manager_user_source_list_type_id, sizeof (FontManagerUserSourceListPrivate));
	return font_manager_user_source_list_type_id;
}

GType
font_manager_user_source_list_get_type (void)
{
	static volatile gsize font_manager_user_source_list_type_id__once = 0;
	if (g_once_init_enter (&font_manager_user_source_list_type_id__once)) {
		GType font_manager_user_source_list_type_id;
		font_manager_user_source_list_type_id = font_manager_user_source_list_get_type_once ();
		g_once_init_leave (&font_manager_user_source_list_type_id__once, font_manager_user_source_list_type_id);
	}
	return font_manager_user_source_list_type_id__once;
}

static void
_vala_font_manager_user_source_list_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec)
{
	FontManagerUserSourceList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_TYPE_USER_SOURCE_LIST, FontManagerUserSourceList);
	switch (property_id) {
		case FONT_MANAGER_USER_SOURCE_LIST_MODEL_PROPERTY:
		g_value_set_object (value, font_manager_user_source_list_get_model (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_font_manager_user_source_list_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec)
{
	FontManagerUserSourceList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_TYPE_USER_SOURCE_LIST, FontManagerUserSourceList);
	switch (property_id) {
		case FONT_MANAGER_USER_SOURCE_LIST_MODEL_PROPERTY:
		font_manager_user_source_list_set_model (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

