/* ArchiveManager.c generated by valac 0.56.18, the Vala compiler
 * generated from ArchiveManager.vala, do not modify */

/* ArchiveManager.vala
 *
 * Copyright (C) 2009-2025 Jerry Casiano
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.
 *
 * If not, see <http://www.gnu.org/licenses/gpl-3.0.txt>.
*/

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <archive.h>
#include <gio/gio.h>
#include <archive_entry.h>
#include <time.h>
#include "font-manager.h"
#include <glib/gstdio.h>
#include <sys/types.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define FONT_MANAGER_TYPE_ARCHIVE_MANAGER (font_manager_archive_manager_get_type ())
#define FONT_MANAGER_ARCHIVE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_ARCHIVE_MANAGER, FontManagerArchiveManager))
#define FONT_MANAGER_ARCHIVE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_ARCHIVE_MANAGER, FontManagerArchiveManagerClass))
#define FONT_MANAGER_IS_ARCHIVE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_ARCHIVE_MANAGER))
#define FONT_MANAGER_IS_ARCHIVE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_ARCHIVE_MANAGER))
#define FONT_MANAGER_ARCHIVE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_ARCHIVE_MANAGER, FontManagerArchiveManagerClass))

typedef struct _FontManagerArchiveManager FontManagerArchiveManager;
typedef struct _FontManagerArchiveManagerClass FontManagerArchiveManagerClass;
typedef struct _FontManagerArchiveManagerPrivate FontManagerArchiveManagerPrivate;
enum  {
	FONT_MANAGER_ARCHIVE_MANAGER_0_PROPERTY,
	FONT_MANAGER_ARCHIVE_MANAGER_NUM_PROPERTIES
};
static GParamSpec* font_manager_archive_manager_properties[FONT_MANAGER_ARCHIVE_MANAGER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _archive_entry_free0(var) ((var == NULL) ? NULL : (var = (archive_entry_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _archive_write_free0(var) ((var == NULL) ? NULL : (var = (archive_write_free (var), NULL)))
#define _archive_read_free0(var) ((var == NULL) ? NULL : (var = (archive_read_free (var), NULL)))

struct _FontManagerArchiveManager {
	GObject parent_instance;
	FontManagerArchiveManagerPrivate * priv;
};

struct _FontManagerArchiveManagerClass {
	GObjectClass parent_class;
};

static gpointer font_manager_archive_manager_parent_class = NULL;

VALA_EXTERN GType font_manager_archive_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerArchiveManager, g_object_unref)
static struct archive_entry* font_manager_archive_manager_add_entry (FontManagerArchiveManager* self,
                                                              struct archive* archive,
                                                              GFile* file,
                                                              GFileInfo* file_info,
                                                              const gchar* path);
static gint64 font_manager_archive_manager_add_data (FontManagerArchiveManager* self,
                                              struct archive* archive,
                                              GFile* file,
                                              GFileInfo* file_info,
                                              const gchar* path);
static void font_manager_archive_manager_add_directory (FontManagerArchiveManager* self,
                                                 struct archive* archive,
                                                 GFile* file,
                                                 GFileInfo* file_info,
                                                 const gchar* path);
VALA_EXTERN gboolean font_manager_archive_manager_compress (FontManagerArchiveManager* self,
                                                FontManagerStringSet* filelist,
                                                GFile* output_file);
VALA_EXTERN gboolean font_manager_archive_manager_extract (FontManagerArchiveManager* self,
                                               GFile* file,
                                               GFile* dest_dir);
static guint8* _vala_array_dup1 (guint8* self,
                          gssize length);
VALA_EXTERN FontManagerArchiveManager* font_manager_archive_manager_new (void);
VALA_EXTERN FontManagerArchiveManager* font_manager_archive_manager_construct (GType object_type);
static GType font_manager_archive_manager_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

const gchar* FONT_MANAGER_LIBARCHIVE_MIME_TYPES[26] = {"application/epub+zip", "application/vnd.debian.binary-package", "application/vnd.ms-cab-compressed", "application/vnd.rar", "application/x-7z-compressed", "application/x-ar", "application/x-bzip-compressed-tar", "application/x-cbr", "application/x-cbz", "application/x-cd-image", "application/x-compressed-tar", "application/x-cpio", "application/x-deb", "application/x-lha", "application/x-lrzip-compressed-tar", "application/x-lzip-compressed-tar", "application/x-lzma-compressed-tar", "application/x-rar", "application/x-rpm", "application/x-tar", "application/x-tarz", "application/x-tzo", "application/x-xar", "application/x-xz-compressed-tar", "application/x-zstd-compressed-tar", "application/zip"};

static struct archive_entry*
font_manager_archive_manager_add_entry (FontManagerArchiveManager* self,
                                        struct archive* archive,
                                        GFile* file,
                                        GFileInfo* file_info,
                                        const gchar* path)
{
	struct archive_entry* entry = NULL;
	struct archive_entry* _tmp0_;
	struct archive_entry* _tmp1_;
	struct archive_entry* _tmp2_;
	gboolean IFREG = FALSE;
	__LA_MODE_T _tmp3_ = 0;
	struct archive_entry* _tmp4_;
	struct archive_entry* _tmp5_;
	struct archive_entry* _tmp6_;
	struct archive_entry* _tmp7_;
	struct archive_entry* _tmp8_;
	struct archive_entry* _tmp9_;
	struct archive_entry* _tmp10_;
	struct archive_entry* _tmp11_;
	struct archive_entry* _tmp12_;
	struct archive_entry* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (archive != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (file_info != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = archive_entry_new2 (NULL);
	entry = _tmp0_;
	_tmp1_ = entry;
	archive_entry_set_pathname (_tmp1_, path);
	_tmp2_ = entry;
	archive_entry_set_size (_tmp2_, (la_int64_t) g_file_info_get_size (file_info));
	IFREG = g_file_info_get_file_type (file_info) == G_FILE_TYPE_REGULAR;
	if (IFREG) {
		_tmp3_ = AE_IFREG;
	} else {
		_tmp3_ = AE_IFDIR;
	}
	_tmp4_ = entry;
	archive_entry_set_filetype (_tmp4_, _tmp3_);
	_tmp5_ = entry;
	archive_entry_unset_birthtime (_tmp5_);
	_tmp6_ = entry;
	archive_entry_set_atime (_tmp6_, (time_t) g_file_info_get_attribute_uint64 (file_info, G_FILE_ATTRIBUTE_TIME_ACCESS), (glong) (g_file_info_get_attribute_uint32 (file_info, G_FILE_ATTRIBUTE_TIME_ACCESS_USEC) * 1000));
	_tmp7_ = entry;
	archive_entry_set_ctime (_tmp7_, (time_t) g_file_info_get_attribute_uint64 (file_info, G_FILE_ATTRIBUTE_TIME_CREATED), (glong) (g_file_info_get_attribute_uint32 (file_info, G_FILE_ATTRIBUTE_TIME_CREATED_USEC) * 1000));
	_tmp8_ = entry;
	archive_entry_set_mtime (_tmp8_, (time_t) g_file_info_get_attribute_uint64 (file_info, G_FILE_ATTRIBUTE_TIME_MODIFIED), (glong) (g_file_info_get_attribute_uint32 (file_info, G_FILE_ATTRIBUTE_TIME_MODIFIED_USEC) * 1000));
	_tmp9_ = entry;
	archive_entry_set_uid (_tmp9_, (la_int64_t) g_file_info_get_attribute_uint32 (file_info, G_FILE_ATTRIBUTE_UNIX_UID));
	_tmp10_ = entry;
	archive_entry_set_gid (_tmp10_, (la_int64_t) g_file_info_get_attribute_uint32 (file_info, G_FILE_ATTRIBUTE_UNIX_GID));
	_tmp11_ = entry;
	archive_entry_set_mode (_tmp11_, (__LA_MODE_T) g_file_info_get_attribute_uint32 (file_info, G_FILE_ATTRIBUTE_UNIX_MODE));
	_tmp12_ = entry;
	if (archive_write_header (archive, _tmp12_) != ARCHIVE_OK) {
		gchar* _tmp13_;
		gchar* _tmp14_;
		const gchar* _tmp15_;
		_tmp13_ = g_file_get_path (file);
		_tmp14_ = _tmp13_;
		_tmp15_ = archive_error_string (archive);
		g_critical ("ArchiveManager.vala:73: Error adding entry for '%s': %s (%d)", _tmp14_, _tmp15_, archive_errno (archive));
		_g_free0 (_tmp14_);
	}
	result = entry;
	return result;
}

static gint64
font_manager_archive_manager_add_data (FontManagerArchiveManager* self,
                                       struct archive* archive,
                                       GFile* file,
                                       GFileInfo* file_info,
                                       const gchar* path)
{
	gint64 size = 0LL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	struct archive_entry* _tmp4_;
	struct archive_entry* _tmp5_;
	GError* _inner_error0_ = NULL;
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	g_return_val_if_fail (archive != NULL, 0LL);
	g_return_val_if_fail (file != NULL, 0LL);
	g_return_val_if_fail (file_info != NULL, 0LL);
	g_return_val_if_fail (path != NULL, 0LL);
	size = (gint64) 0;
	_tmp0_ = g_file_get_basename (file);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_build_filename (path, _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = font_manager_archive_manager_add_entry (self, archive, file, file_info, _tmp3_);
	_tmp5_ = _tmp4_;
	_archive_entry_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	{
		GFileInputStream* input_stream = NULL;
		GFileInputStream* _tmp6_;
		GDataInputStream* data_input_stream = NULL;
		GFileInputStream* _tmp7_;
		GDataInputStream* _tmp8_;
		gsize bytes_read = 0UL;
		guint8* buffer = NULL;
		guint8* _tmp9_;
		gint buffer_length1;
		gint _buffer_size_;
		_tmp6_ = g_file_read (file, NULL, &_inner_error0_);
		input_stream = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp7_ = input_stream;
		_tmp8_ = g_data_input_stream_new ((GInputStream*) _tmp7_);
		data_input_stream = _tmp8_;
		_tmp9_ = g_new0 (guint8, 1024);
		buffer = _tmp9_;
		buffer_length1 = 1024;
		_buffer_size_ = buffer_length1;
		while (TRUE) {
			gboolean _tmp10_ = FALSE;
			GDataInputStream* _tmp11_;
			guint8* _tmp12_;
			gint _tmp12__length1;
			gsize _tmp13_ = 0UL;
			gboolean _tmp14_;
			guint8* _tmp15_;
			gint _tmp15__length1;
			_tmp11_ = data_input_stream;
			_tmp12_ = buffer;
			_tmp12__length1 = buffer_length1;
			_tmp14_ = g_input_stream_read_all ((GInputStream*) _tmp11_, _tmp12_, (gsize) _tmp12__length1, &_tmp13_, NULL, &_inner_error0_);
			bytes_read = _tmp13_;
			_tmp10_ = _tmp14_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				buffer = (g_free (buffer), NULL);
				_g_object_unref0 (data_input_stream);
				_g_object_unref0 (input_stream);
				goto __catch0_g_error;
			}
			if (!_tmp10_) {
				break;
			}
			if (bytes_read <= ((gsize) 0)) {
				break;
			}
			_tmp15_ = buffer;
			_tmp15__length1 = buffer_length1;
			archive_write_data (archive, _tmp15_, (size_t) _tmp15__length1);
			size += (gint64) bytes_read;
		}
		buffer = (g_free (buffer), NULL);
		_g_object_unref0 (data_input_stream);
		_g_object_unref0 (input_stream);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		gchar* _tmp16_;
		gchar* _tmp17_;
		const gchar* _tmp18_;
		GError* _tmp19_;
		const gchar* _tmp20_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp16_ = g_file_get_path (file);
		_tmp17_ = _tmp16_;
		_tmp18_ = archive_error_string (archive);
		g_critical ("ArchiveManager.vala:92: Error adding data for '%s' : %s (%d)", _tmp17_, _tmp18_, archive_errno (archive));
		_g_free0 (_tmp17_);
		_tmp19_ = e;
		_tmp20_ = _tmp19_->message;
		g_critical ("ArchiveManager.vala:93: %s", _tmp20_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint64 _tmp21_ = -1LL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp21_;
	}
	result = size;
	return result;
}

static void
font_manager_archive_manager_add_directory (FontManagerArchiveManager* self,
                                            struct archive* archive,
                                            GFile* file,
                                            GFileInfo* file_info,
                                            const gchar* path)
{
	gchar* root = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	struct archive_entry* _tmp5_;
	struct archive_entry* _tmp6_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (archive != NULL);
	g_return_if_fail (file != NULL);
	g_return_if_fail (file_info != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = g_file_get_basename (file);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_build_filename (path, _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	root = _tmp3_;
	_tmp4_ = root;
	_tmp5_ = font_manager_archive_manager_add_entry (self, archive, file, file_info, _tmp4_);
	_tmp6_ = _tmp5_;
	_archive_entry_free0 (_tmp6_);
	{
		GFileEnumerator* enumerator = NULL;
		GFileEnumerator* _tmp7_;
		GFileInfo* child_info = NULL;
		GFileEnumerator* _tmp8_;
		GFileInfo* _tmp9_;
		_tmp7_ = g_file_enumerate_children (file, "*", G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
		enumerator = _tmp7_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp8_ = enumerator;
		_tmp9_ = g_file_enumerator_next_file (_tmp8_, NULL, &_inner_error0_);
		child_info = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (enumerator);
			goto __catch0_g_error;
		}
		while (TRUE) {
			GFileInfo* _tmp10_;
			GFileType child_type = 0;
			GFileInfo* _tmp11_;
			GFile* child = NULL;
			GFileInfo* _tmp12_;
			const gchar* _tmp13_;
			GFile* _tmp14_;
			GFileInfo* _tmp21_ = NULL;
			GFileEnumerator* _tmp22_;
			GFileInfo* _tmp23_;
			GFileInfo* _tmp24_;
			_tmp10_ = child_info;
			if (!(_tmp10_ != NULL)) {
				break;
			}
			_tmp11_ = child_info;
			child_type = g_file_info_get_file_type (_tmp11_);
			_tmp12_ = child_info;
			_tmp13_ = g_file_info_get_name (_tmp12_);
			_tmp14_ = g_file_get_child (file, _tmp13_);
			child = _tmp14_;
			if (child_type == G_FILE_TYPE_DIRECTORY) {
				GFile* _tmp15_;
				GFileInfo* _tmp16_;
				const gchar* _tmp17_;
				_tmp15_ = child;
				_tmp16_ = child_info;
				_tmp17_ = root;
				font_manager_archive_manager_add_directory (self, archive, _tmp15_, _tmp16_, _tmp17_);
			} else {
				if (child_type == G_FILE_TYPE_REGULAR) {
					GFile* _tmp18_;
					GFileInfo* _tmp19_;
					const gchar* _tmp20_;
					_tmp18_ = child;
					_tmp19_ = child_info;
					_tmp20_ = root;
					font_manager_archive_manager_add_data (self, archive, _tmp18_, _tmp19_, _tmp20_);
				}
			}
			_tmp22_ = enumerator;
			_tmp23_ = g_file_enumerator_next_file (_tmp22_, NULL, &_inner_error0_);
			_tmp21_ = _tmp23_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (child);
				_g_object_unref0 (child_info);
				_g_object_unref0 (enumerator);
				goto __catch0_g_error;
			}
			_tmp24_ = _tmp21_;
			_tmp21_ = NULL;
			_g_object_unref0 (child_info);
			child_info = _tmp24_;
			_g_object_unref0 (_tmp21_);
			_g_object_unref0 (child);
		}
		_g_object_unref0 (child_info);
		_g_object_unref0 (enumerator);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		gchar* _tmp25_;
		gchar* _tmp26_;
		const gchar* _tmp27_;
		GError* _tmp28_;
		const gchar* _tmp29_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp25_ = g_file_get_path (file);
		_tmp26_ = _tmp25_;
		_tmp27_ = archive_error_string (archive);
		g_critical ("ArchiveManager.vala:114: Error adding directory '%s' : %s (%d)", _tmp26_, _tmp27_, archive_errno (archive));
		_g_free0 (_tmp26_);
		_tmp28_ = e;
		_tmp29_ = _tmp28_->message;
		g_critical ("ArchiveManager.vala:115: %s", _tmp29_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (root);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (root);
	return;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

gboolean
font_manager_archive_manager_compress (FontManagerArchiveManager* self,
                                       FontManagerStringSet* filelist,
                                       GFile* output_file)
{
	guint _tmp0_;
	guint _tmp1_;
	GFile* output_dir = NULL;
	GFile* _tmp2_;
	GFile* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	GFile* _tmp8_;
	struct archive* archive = NULL;
	struct archive* _tmp9_;
	struct archive* _tmp10_;
	gchar* root = NULL;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* filename = NULL;
	GFile* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	struct archive* _tmp28_;
	const gchar* _tmp29_;
	struct archive* _tmp59_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (filelist != NULL, FALSE);
	g_return_val_if_fail (output_file != NULL, FALSE);
	g_object_get (filelist, "size", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	g_return_val_if_fail (_tmp1_ > ((guint) 0), FALSE);
	_tmp2_ = g_file_get_parent (output_file);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_file_get_path (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_file_new_for_path (_tmp5_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	_g_object_unref0 (_tmp3_);
	output_dir = _tmp7_;
	_tmp8_ = output_dir;
	g_return_val_if_fail (g_file_query_exists (_tmp8_, NULL), FALSE);
	_tmp9_ = archive_write_new ();
	archive = _tmp9_;
	_tmp10_ = archive;
	archive_write_set_format_zip (_tmp10_);
	_tmp11_ = g_file_get_basename (output_file);
	root = _tmp11_;
	_tmp12_ = root;
	if (string_contains (_tmp12_, ".")) {
		const gchar* _tmp13_;
		gchar** _tmp14_;
		gchar** _tmp15_;
		gchar** _tmp16_;
		gint _tmp16__length1;
		const gchar* _tmp17_;
		gchar* _tmp18_;
		_tmp13_ = root;
		_tmp15_ = _tmp14_ = g_strsplit (_tmp13_, ".", 0);
		_tmp16_ = _tmp15_;
		_tmp16__length1 = _vala_array_length (_tmp14_);
		_tmp17_ = _tmp16_[0];
		_tmp18_ = g_strdup (_tmp17_);
		_g_free0 (root);
		root = _tmp18_;
		_tmp16_ = (_vala_array_free (_tmp16_, _tmp16__length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp19_ = output_dir;
	_tmp20_ = g_file_get_path (_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = root;
	_tmp23_ = string_to_string (_tmp22_);
	_tmp24_ = g_strconcat (_tmp23_, ".zip", NULL);
	_tmp25_ = _tmp24_;
	_tmp26_ = g_build_filename (_tmp21_, _tmp25_, NULL);
	_tmp27_ = _tmp26_;
	_g_free0 (_tmp25_);
	_g_free0 (_tmp21_);
	filename = _tmp27_;
	_tmp28_ = archive;
	_tmp29_ = filename;
	if (archive_write_open_filename (_tmp28_, _tmp29_) != ARCHIVE_OK) {
		gchar* _tmp30_;
		gchar* _tmp31_;
		struct archive* _tmp32_;
		const gchar* _tmp33_;
		struct archive* _tmp34_;
		_tmp30_ = g_file_get_path (output_file);
		_tmp31_ = _tmp30_;
		_tmp32_ = archive;
		_tmp33_ = archive_error_string (_tmp32_);
		_tmp34_ = archive;
		g_critical ("ArchiveManager.vala:136: Error opening '%s' : %s (%d)", _tmp31_, _tmp33_, archive_errno (_tmp34_));
		_g_free0 (_tmp31_);
		result = FALSE;
		_g_free0 (filename);
		_g_free0 (root);
		_archive_write_free0 (archive);
		_g_object_unref0 (output_dir);
		return result;
	}
	{
		FontManagerStringSet* _filepath_list = NULL;
		guint _filepath_size = 0U;
		FontManagerStringSet* _tmp35_;
		guint _tmp36_;
		guint _tmp37_;
		gint _filepath_index = 0;
		_filepath_list = filelist;
		_tmp35_ = _filepath_list;
		g_object_get (_tmp35_, "size", &_tmp36_, NULL);
		_tmp37_ = _tmp36_;
		_filepath_size = _tmp37_;
		_filepath_index = -1;
		while (TRUE) {
			gint _tmp38_;
			guint _tmp39_;
			gchar* filepath = NULL;
			FontManagerStringSet* _tmp40_;
			const gchar* _tmp41_;
			gchar* _tmp42_;
			GFile* file = NULL;
			const gchar* _tmp43_;
			GFile* _tmp44_;
			_filepath_index = _filepath_index + 1;
			_tmp38_ = _filepath_index;
			_tmp39_ = _filepath_size;
			if (!(((guint) _tmp38_) < _tmp39_)) {
				break;
			}
			_tmp40_ = _filepath_list;
			_tmp41_ = font_manager_string_set_get (_tmp40_, (guint) _filepath_index);
			_tmp42_ = g_strdup (_tmp41_);
			filepath = _tmp42_;
			_tmp43_ = filepath;
			_tmp44_ = g_file_new_for_path (_tmp43_);
			file = _tmp44_;
			{
				GFileInfo* file_info = NULL;
				GFile* _tmp45_;
				GFileInfo* _tmp46_;
				GFileType file_type = 0;
				GFileInfo* _tmp47_;
				_tmp45_ = file;
				_tmp46_ = g_file_query_info (_tmp45_, "*", G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
				file_info = _tmp46_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_tmp47_ = file_info;
				file_type = g_file_info_get_file_type (_tmp47_);
				if (file_type == G_FILE_TYPE_REGULAR) {
					struct archive* _tmp48_;
					GFile* _tmp49_;
					GFileInfo* _tmp50_;
					const gchar* _tmp51_;
					_tmp48_ = archive;
					_tmp49_ = file;
					_tmp50_ = file_info;
					_tmp51_ = root;
					font_manager_archive_manager_add_data (self, _tmp48_, _tmp49_, _tmp50_, _tmp51_);
				} else {
					if (file_type == G_FILE_TYPE_DIRECTORY) {
						struct archive* _tmp52_;
						GFile* _tmp53_;
						GFileInfo* _tmp54_;
						const gchar* _tmp55_;
						_tmp52_ = archive;
						_tmp53_ = file;
						_tmp54_ = file_info;
						_tmp55_ = root;
						font_manager_archive_manager_add_directory (self, _tmp52_, _tmp53_, _tmp54_, _tmp55_);
					}
				}
				_g_object_unref0 (file_info);
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				GError* _tmp56_;
				const gchar* _tmp57_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp56_ = e;
				_tmp57_ = _tmp56_->message;
				g_critical ("ArchiveManager.vala:150: %s", _tmp57_);
				result = FALSE;
				_g_error_free0 (e);
				_g_object_unref0 (file);
				_g_free0 (filepath);
				_g_free0 (filename);
				_g_free0 (root);
				_archive_write_free0 (archive);
				_g_object_unref0 (output_dir);
				return result;
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp58_ = FALSE;
				_g_object_unref0 (file);
				_g_free0 (filepath);
				_g_free0 (filename);
				_g_free0 (root);
				_archive_write_free0 (archive);
				_g_object_unref0 (output_dir);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp58_;
			}
			_g_object_unref0 (file);
			_g_free0 (filepath);
		}
	}
	_tmp59_ = archive;
	if (archive_write_close (_tmp59_) != ARCHIVE_OK) {
		const gchar* _tmp60_;
		struct archive* _tmp61_;
		const gchar* _tmp62_;
		struct archive* _tmp63_;
		_tmp60_ = filename;
		_tmp61_ = archive;
		_tmp62_ = archive_error_string (_tmp61_);
		_tmp63_ = archive;
		g_critical ("ArchiveManager.vala:156: Error closing '%s' : %s (%d)", _tmp60_, _tmp62_, archive_errno (_tmp63_));
		result = FALSE;
		_g_free0 (filename);
		_g_free0 (root);
		_archive_write_free0 (archive);
		_g_object_unref0 (output_dir);
		return result;
	}
	result = TRUE;
	_g_free0 (filename);
	_g_free0 (root);
	_archive_write_free0 (archive);
	_g_object_unref0 (output_dir);
	return result;
}

static guint8*
_vala_array_dup1 (guint8* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

gboolean
font_manager_archive_manager_extract (FontManagerArchiveManager* self,
                                      GFile* file,
                                      GFile* dest_dir)
{
	int EXTRACT_FLAGS = 0;
	struct archive* archive = NULL;
	struct archive* _tmp0_;
	struct archive* extractor = NULL;
	struct archive* _tmp1_;
	struct archive* _tmp2_;
	struct archive* _tmp3_;
	struct archive* _tmp4_;
	struct archive* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* filepath = NULL;
	gchar* _tmp8_;
	struct archive* _tmp9_;
	const gchar* _tmp10_;
	struct archive_entry* entry = NULL;
	int last_result = 0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (file != NULL, FALSE);
	g_return_val_if_fail (dest_dir != NULL, FALSE);
	g_return_val_if_fail (g_file_query_exists (file, NULL), FALSE);
	g_return_val_if_fail (g_file_query_exists (dest_dir, NULL), FALSE);
	EXTRACT_FLAGS = ARCHIVE_EXTRACT_TIME;
	EXTRACT_FLAGS |= ARCHIVE_EXTRACT_PERM;
	EXTRACT_FLAGS |= ARCHIVE_EXTRACT_ACL;
	EXTRACT_FLAGS |= ARCHIVE_EXTRACT_FFLAGS;
	_tmp0_ = archive_read_new ();
	archive = _tmp0_;
	_tmp1_ = archive_write_disk_new ();
	extractor = _tmp1_;
	_tmp2_ = archive;
	archive_read_support_format_all (_tmp2_);
	_tmp3_ = archive;
	archive_read_support_filter_all (_tmp3_);
	_tmp4_ = extractor;
	archive_write_disk_set_options (_tmp4_, EXTRACT_FLAGS);
	_tmp5_ = extractor;
	archive_write_disk_set_standard_lookup (_tmp5_);
	_tmp6_ = g_file_get_path (dest_dir);
	_tmp7_ = _tmp6_;
	g_chdir (_tmp7_);
	_g_free0 (_tmp7_);
	_tmp8_ = g_file_get_path (file);
	filepath = _tmp8_;
	_tmp9_ = archive;
	_tmp10_ = filepath;
	if (archive_read_open_filename (_tmp9_, _tmp10_, (gsize) 10240) != ARCHIVE_OK) {
		const gchar* _tmp11_;
		struct archive* _tmp12_;
		const gchar* _tmp13_;
		struct archive* _tmp14_;
		_tmp11_ = filepath;
		_tmp12_ = archive;
		_tmp13_ = archive_error_string (_tmp12_);
		_tmp14_ = archive;
		g_critical ("ArchiveManager.vala:185: Error opening '%s' : %s (%d)", _tmp11_, _tmp13_, archive_errno (_tmp14_));
		result = FALSE;
		_g_free0 (filepath);
		_archive_write_free0 (extractor);
		_archive_read_free0 (archive);
		return result;
	}
	while (TRUE) {
		struct archive* _tmp15_;
		struct archive_entry* _tmp16_ = NULL;
		int _tmp17_;
		struct archive* _tmp18_;
		struct archive_entry* _tmp19_;
		off_t offset = {0};
		guint8* buffer = NULL;
		gint buffer_length1;
		gint _buffer_size_;
		_tmp15_ = archive;
		_tmp17_ = archive_read_next_header (_tmp15_, &_tmp16_);
		entry = _tmp16_;
		last_result = _tmp17_;
		if (!(last_result == ARCHIVE_OK)) {
			break;
		}
		_tmp18_ = extractor;
		_tmp19_ = entry;
		if (archive_write_header (_tmp18_, _tmp19_) != ARCHIVE_OK) {
			const gchar* archived_path = NULL;
			struct archive_entry* _tmp20_;
			const gchar* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			_tmp20_ = entry;
			_tmp21_ = archive_entry_pathname (_tmp20_);
			archived_path = _tmp21_;
			_tmp22_ = archived_path;
			_tmp23_ = string_to_string (_tmp22_);
			_tmp24_ = g_strconcat ("Failed to write header entry for ", _tmp23_, NULL);
			_tmp25_ = _tmp24_;
			g_critical ("ArchiveManager.vala:195: %s", _tmp25_);
			_g_free0 (_tmp25_);
			continue;
		}
		buffer = NULL;
		buffer_length1 = 0;
		_buffer_size_ = buffer_length1;
		while (TRUE) {
			struct archive* _tmp26_;
			guint8* _tmp27_ = NULL;
			size_t _tmp28_ = 0;
			la_int64_t _tmp29_ = {0};
			int _tmp30_;
			guint8* _tmp31_;
			gint _tmp31__length1;
			struct archive* _tmp32_;
			guint8* _tmp33_;
			gint _tmp33__length1;
			_tmp26_ = archive;
			_tmp30_ = archive_read_data_block (_tmp26_, &_tmp27_, &_tmp28_, &_tmp29_);
			buffer = (g_free (buffer), NULL);
			_tmp31_ = (_tmp27_ != NULL) ? _vala_array_dup1 (_tmp27_, _tmp28_) : _tmp27_;
			_tmp31__length1 = _tmp28_;
			buffer = _tmp31_;
			buffer_length1 = _tmp31__length1;
			_buffer_size_ = buffer_length1;
			offset = (off_t) _tmp29_;
			if (!(_tmp30_ == ARCHIVE_OK)) {
				break;
			}
			_tmp32_ = extractor;
			_tmp33_ = buffer;
			_tmp33__length1 = buffer_length1;
			if (archive_write_data_block (_tmp32_, _tmp33_, (size_t) _tmp33__length1, (la_int64_t) offset) < ((gssize) ARCHIVE_OK)) {
				break;
			}
		}
		buffer = (g_free (buffer), NULL);
	}
	if (last_result != ARCHIVE_EOF) {
		const gchar* _tmp34_;
		struct archive* _tmp35_;
		const gchar* _tmp36_;
		struct archive* _tmp37_;
		_tmp34_ = filepath;
		_tmp35_ = archive;
		_tmp36_ = archive_error_string (_tmp35_);
		_tmp37_ = archive;
		g_critical ("ArchiveManager.vala:208: Error extracting '%s' : %s (%d)", _tmp34_, _tmp36_, archive_errno (_tmp37_));
		result = FALSE;
		_g_free0 (filepath);
		_archive_write_free0 (extractor);
		_archive_read_free0 (archive);
		return result;
	}
	result = TRUE;
	_g_free0 (filepath);
	_archive_write_free0 (extractor);
	_archive_read_free0 (archive);
	return result;
}

FontManagerArchiveManager*
font_manager_archive_manager_construct (GType object_type)
{
	FontManagerArchiveManager * self = NULL;
	self = (FontManagerArchiveManager*) g_object_new (object_type, NULL);
	return self;
}

FontManagerArchiveManager*
font_manager_archive_manager_new (void)
{
	return font_manager_archive_manager_construct (FONT_MANAGER_TYPE_ARCHIVE_MANAGER);
}

static void
font_manager_archive_manager_class_init (FontManagerArchiveManagerClass * klass,
                                         gpointer klass_data)
{
	font_manager_archive_manager_parent_class = g_type_class_peek_parent (klass);
}

static void
font_manager_archive_manager_instance_init (FontManagerArchiveManager * self,
                                            gpointer klass)
{
}

 G_GNUC_NO_INLINE static GType
font_manager_archive_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FontManagerArchiveManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) font_manager_archive_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FontManagerArchiveManager), 0, (GInstanceInitFunc) font_manager_archive_manager_instance_init, NULL };
	GType font_manager_archive_manager_type_id;
	font_manager_archive_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "FontManagerArchiveManager", &g_define_type_info, 0);
	return font_manager_archive_manager_type_id;
}

GType
font_manager_archive_manager_get_type (void)
{
	static volatile gsize font_manager_archive_manager_type_id__once = 0;
	if (g_once_init_enter (&font_manager_archive_manager_type_id__once)) {
		GType font_manager_archive_manager_type_id;
		font_manager_archive_manager_type_id = font_manager_archive_manager_get_type_once ();
		g_once_init_leave (&font_manager_archive_manager_type_id__once, font_manager_archive_manager_type_id);
	}
	return font_manager_archive_manager_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

