/* BackendFile.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from BackendFile.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*-
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: Michael Terry
 */

#include "deja.h"
#include <glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	DEJA_DUP_BACKEND_FILE_0_PROPERTY,
	DEJA_DUP_BACKEND_FILE_UNMOUNT_WHEN_DONE_PROPERTY,
	DEJA_DUP_BACKEND_FILE_NUM_PROPERTIES
};
static GParamSpec* deja_dup_backend_file_properties[DEJA_DUP_BACKEND_FILE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _DejaDupBackendFileCleanupData DejaDupBackendFileCleanupData;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _DejaDupBackendFileQueryExistsAsyncData DejaDupBackendFileQueryExistsAsyncData;
typedef struct _DejaDupBackendFilePeekAtFilesData DejaDupBackendFilePeekAtFilesData;
typedef struct _DejaDupBackendFilePrepareData DejaDupBackendFilePrepareData;
typedef struct _DejaDupBackendFileMountData DejaDupBackendFileMountData;
typedef struct _DejaDupBackendFileUnmountData DejaDupBackendFileUnmountData;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _DejaDupBackendFileGetSpaceData DejaDupBackendFileGetSpaceData;

struct _DejaDupBackendFilePrivate {
	gboolean _unmount_when_done;
	gboolean will_unmount;
};

struct _DejaDupBackendFileCleanupData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DejaDupBackendFile* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
};

struct _DejaDupBackendFileQueryExistsAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DejaDupBackendFile* self;
	GFile* file;
	gboolean result;
	GFileInfo* _tmp0_;
	GFileInfo* _tmp1_;
	GError* _inner_error0_;
};

struct _DejaDupBackendFilePeekAtFilesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DejaDupBackendFile* self;
	GList* result;
	GList* filenames;
	GFile* gfile;
	GFile* _tmp0_;
	GFileEnumerator* enumerator;
	GFile* _tmp1_;
	GFileEnumerator* _tmp2_;
	GList* _tmp3_;
	GList* infos;
	GFileEnumerator* _tmp4_;
	GList* _tmp5_;
	GList* _tmp6_;
	GList* _tmp7_;
	GList* info_collection;
	GList* info_it;
	GFileInfo* _tmp8_;
	GFileInfo* info;
	GFileInfo* _tmp9_;
	GFileInfo* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	GError* _inner_error0_;
};

struct _DejaDupBackendFilePrepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DejaDupBackendFile* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GFile* gfile;
	GFile* _tmp2_;
	gboolean _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	GError* _inner_error0_;
};

struct _DejaDupBackendFileMountData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DejaDupBackendFile* self;
	gboolean result;
};

struct _DejaDupBackendFileUnmountData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DejaDupBackendFile* self;
	GFile* root;
	GFile* _tmp0_;
	GMount* mount;
	GFile* _tmp1_;
	GMount* _tmp2_;
	gboolean _tmp3_;
	GMount* _tmp4_;
	GMount* _tmp5_;
	GMount* _tmp6_;
	GError* _inner_error0_;
};

struct _DejaDupBackendFileGetSpaceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DejaDupBackendFile* self;
	guint64 free;
	guint64 total;
	guint64 _tmp0_;
	guint64 _tmp1_;
	GFile* file;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFileInfo* info;
	GFileInfo* _tmp4_;
	GFile* _tmp5_;
	GFileInfo* _tmp6_;
	GFileInfo* _tmp7_;
	GError* e;
	GError* _tmp8_;
	const gchar* _tmp9_;
	gboolean _tmp10_;
	const gchar* _tmp11_;
	gchar* free_str;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar** free_list;
	const gchar* _tmp14_;
	gchar** _tmp15_;
	gchar** _tmp16_;
	gint free_list_length1;
	gint _free_list_size_;
	gchar** _tmp17_;
	gint _tmp17__length1;
	const gchar* _tmp18_;
	gchar** _tmp19_;
	gint _tmp19__length1;
	const gchar* _tmp20_;
	gchar* space_free;
	gchar** _tmp21_;
	gint _tmp21__length1;
	gchar** _tmp22_;
	gint _tmp22__length1;
	gchar* _tmp23_;
	const gchar* _tmp24_;
	GFileInfo* _tmp25_;
	GFileInfo* _tmp26_;
	GFileInfo* _tmp27_;
	GFileInfo* _tmp28_;
	gboolean _tmp29_;
	GError* _inner_error0_;
};

static gint DejaDupBackendFile_private_offset;
static gpointer deja_dup_backend_file_parent_class = NULL;

VALA_EXTERN GFile* deja_dup_backend_file_get_file_from_settings (DejaDupBackendFile* self);
static void deja_dup_backend_file_real_cleanup_data_free (gpointer _data);
static void deja_dup_backend_file_real_cleanup (DejaDupBackend* base,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
static gboolean deja_dup_backend_file_real_cleanup_co (DejaDupBackendFileCleanupData* _data_);
static void deja_dup_backend_file_cleanup_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_);
static gchar** deja_dup_backend_file_real_get_dependencies (DejaDupBackend* base,
                                                     gint* result_length1);
static GFile* deja_dup_backend_file_real_get_root_from_settings (DejaDupBackendFile* self);
static GFile* deja_dup_backend_file_real_get_file_from_settings (DejaDupBackendFile* self);
static gchar* deja_dup_backend_file_real_get_location_pretty (DejaDupBackend* base);
static gchar* deja_dup_backend_file_real_get_unique_location (DejaDupBackend* base);
static gboolean deja_dup_backend_file_real_is_native (DejaDupBackend* base);
static void deja_dup_backend_file_real_add_excludes (DejaDupBackend* base,
                                              GList** excludes);
static void deja_dup_backend_file_query_exists_async_data_free (gpointer _data);
static void deja_dup_backend_file_query_exists_async (DejaDupBackendFile* self,
                                               GFile* file,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
static gboolean deja_dup_backend_file_query_exists_finish (DejaDupBackendFile* self,
                                                    GAsyncResult* _res_);
static gboolean deja_dup_backend_file_query_exists_async_co (DejaDupBackendFileQueryExistsAsyncData* _data_);
static void deja_dup_backend_file_query_exists_async_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_);
static void _g_free0_ (gpointer var);
static inline void _g_list_free__g_free0_ (GList* self);
static void deja_dup_backend_file_real_peek_at_files_data_free (gpointer _data);
static void deja_dup_backend_file_real_peek_at_files (DejaDupBackend* base,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
static gboolean deja_dup_backend_file_real_peek_at_files_co (DejaDupBackendFilePeekAtFilesData* _data_);
static void deja_dup_backend_file_peek_at_files_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void deja_dup_backend_file_real_prepare_data_free (gpointer _data);
static void deja_dup_backend_file_real_prepare (DejaDupBackend* base,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
static gboolean deja_dup_backend_file_real_prepare_co (DejaDupBackendFilePrepareData* _data_);
static void deja_dup_backend_file_prepare_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_);
static void deja_dup_backend_file_real_mount_data_free (gpointer _data);
static void deja_dup_backend_file_real_mount (DejaDupBackendFile* self,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_);
static gboolean deja_dup_backend_file_real_mount_co (DejaDupBackendFileMountData* _data_);
static void deja_dup_backend_file_real_unmount_data_free (gpointer _data);
static void deja_dup_backend_file_real_unmount (DejaDupBackendFile* self,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
static gboolean deja_dup_backend_file_real_unmount_co (DejaDupBackendFileUnmountData* _data_);
static void deja_dup_backend_file_unmount_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_);
static void deja_dup_backend_file_real_get_space_data_free (gpointer _data);
static void deja_dup_backend_file_real_get_space (DejaDupBackend* base,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
static gboolean deja_dup_backend_file_real_get_space_co (DejaDupBackendFileGetSpaceData* _data_);
static void deja_dup_backend_file_get_space_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_);
static void deja_dup_backend_file_finalize (GObject * obj);
static GType deja_dup_backend_file_get_type_once (void);
static void _vala_deja_dup_backend_file_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_deja_dup_backend_file_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
deja_dup_backend_file_get_instance_private (DejaDupBackendFile* self)
{
	return G_STRUCT_MEMBER_P (self, DejaDupBackendFile_private_offset);
}

static void
deja_dup_backend_file_real_cleanup_data_free (gpointer _data)
{
	DejaDupBackendFileCleanupData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupBackendFileCleanupData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
deja_dup_backend_file_real_cleanup (DejaDupBackend* base,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_)
{
	DejaDupBackendFile * self;
	DejaDupBackendFileCleanupData* _data_;
	DejaDupBackendFile* _tmp0_;
	self = (DejaDupBackendFile*) base;
	_data_ = g_slice_new0 (DejaDupBackendFileCleanupData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, deja_dup_backend_file_real_cleanup_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	deja_dup_backend_file_real_cleanup_co (_data_);
}

static void
deja_dup_backend_file_cleanup_finish (DejaDupBackend* base,
                                      GAsyncResult* _res_)
{
	DejaDupBackendFileCleanupData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
deja_dup_backend_file_cleanup_ready (GObject* source_object,
                                     GAsyncResult* _res_,
                                     gpointer _user_data_)
{
	DejaDupBackendFileCleanupData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_backend_file_real_cleanup_co (_data_);
}

static gboolean
deja_dup_backend_file_real_cleanup_co (DejaDupBackendFileCleanupData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->self->priv->will_unmount) {
		_data_->_tmp1_ = _data_->self->priv->_unmount_when_done;
		_data_->_tmp0_ = _data_->_tmp1_;
	} else {
		_data_->_tmp0_ = FALSE;
	}
	if (_data_->_tmp0_) {
		_data_->_state_ = 1;
		deja_dup_backend_file_unmount (_data_->self, deja_dup_backend_file_cleanup_ready, _data_);
		return FALSE;
		_state_1:
		deja_dup_backend_file_unmount_finish (_data_->self, _data_->_res_);
		_data_->self->priv->will_unmount = FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gchar**
deja_dup_backend_file_real_get_dependencies (DejaDupBackend* base,
                                             gint* result_length1)
{
	DejaDupBackendFile * self;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** result;
	self = (DejaDupBackendFile*) base;
	_tmp1_ = _tmp0_ = g_strsplit (GVFS_PACKAGES, ",", 0);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _vala_array_length (_tmp0_);
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static GFile*
deja_dup_backend_file_real_get_root_from_settings (DejaDupBackendFile* self)
{
	g_critical ("Type `%s' does not implement abstract method `deja_dup_backend_file_get_root_from_settings'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

GFile*
deja_dup_backend_file_get_root_from_settings (DejaDupBackendFile* self)
{
	DejaDupBackendFileClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = DEJA_DUP_BACKEND_FILE_GET_CLASS (self);
	if (_klass_->get_root_from_settings) {
		return _klass_->get_root_from_settings (self);
	}
	return NULL;
}

static GFile*
deja_dup_backend_file_real_get_file_from_settings (DejaDupBackendFile* self)
{
	g_critical ("Type `%s' does not implement abstract method `deja_dup_backend_file_get_file_from_settings'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

GFile*
deja_dup_backend_file_get_file_from_settings (DejaDupBackendFile* self)
{
	DejaDupBackendFileClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = DEJA_DUP_BACKEND_FILE_GET_CLASS (self);
	if (_klass_->get_file_from_settings) {
		return _klass_->get_file_from_settings (self);
	}
	return NULL;
}

static gchar*
deja_dup_backend_file_real_get_location_pretty (DejaDupBackend* base)
{
	DejaDupBackendFile * self;
	GFile* file = NULL;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp4_;
	gchar* _tmp5_;
	gchar* result;
	self = (DejaDupBackendFile*) base;
	if (deja_dup_in_demo_mode ()) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("hostname on Google Drive");
		result = _tmp0_;
		return result;
	}
	_tmp1_ = deja_dup_backend_file_get_file_from_settings (self);
	file = _tmp1_;
	_tmp2_ = file;
	if (_tmp2_ == NULL) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ("");
		result = _tmp3_;
		_g_object_unref0 (file);
		return result;
	}
	_tmp4_ = file;
	_tmp5_ = deja_dup_get_file_desc (_tmp4_);
	result = _tmp5_;
	_g_object_unref0 (file);
	return result;
}

static gchar*
deja_dup_backend_file_real_get_unique_location (DejaDupBackend* base)
{
	DejaDupBackendFile * self;
	GFile* file = NULL;
	GFile* _tmp0_;
	gchar* _tmp1_ = NULL;
	GFile* _tmp2_;
	gchar* uri = NULL;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* result;
	self = (DejaDupBackendFile*) base;
	_tmp0_ = deja_dup_backend_file_get_file_from_settings (self);
	file = _tmp0_;
	_tmp2_ = file;
	if (_tmp2_ == NULL) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ("");
		_g_free0 (_tmp1_);
		_tmp1_ = _tmp3_;
	} else {
		GFile* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = file;
		_tmp5_ = g_file_get_uri (_tmp4_);
		_g_free0 (_tmp1_);
		_tmp1_ = _tmp5_;
	}
	_tmp6_ = g_strdup (_tmp1_);
	uri = _tmp6_;
	_tmp7_ = g_strconcat ("file:", uri, NULL);
	result = _tmp7_;
	_g_free0 (uri);
	_g_free0 (_tmp1_);
	_g_object_unref0 (file);
	return result;
}

static gboolean
deja_dup_backend_file_real_is_native (DejaDupBackend* base)
{
	DejaDupBackendFile * self;
	gboolean result;
	self = (DejaDupBackendFile*) base;
	result = TRUE;
	return result;
}

static void
deja_dup_backend_file_real_add_excludes (DejaDupBackend* base,
                                         GList** excludes)
{
	DejaDupBackendFile * self;
	GFile* file = NULL;
	GFile* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GFile* _tmp2_;
	self = (DejaDupBackendFile*) base;
	_tmp0_ = deja_dup_backend_file_get_file_from_settings (self);
	file = _tmp0_;
	_tmp2_ = file;
	if (_tmp2_ != NULL) {
		GFile* _tmp3_;
		_tmp3_ = file;
		_tmp1_ = g_file_is_native (_tmp3_);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GFile* _tmp4_;
		GFile* _tmp5_;
		_tmp4_ = file;
		_tmp5_ = _g_object_ref0 (_tmp4_);
		*excludes = g_list_append (*excludes, _tmp5_);
	}
	_g_object_unref0 (file);
}

static void
deja_dup_backend_file_query_exists_async_data_free (gpointer _data)
{
	DejaDupBackendFileQueryExistsAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->file);
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupBackendFileQueryExistsAsyncData, _data_);
}

static void
deja_dup_backend_file_query_exists_async (DejaDupBackendFile* self,
                                          GFile* file,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	DejaDupBackendFileQueryExistsAsyncData* _data_;
	DejaDupBackendFile* _tmp0_;
	GFile* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_data_ = g_slice_new0 (DejaDupBackendFileQueryExistsAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, deja_dup_backend_file_query_exists_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (file);
	_g_object_unref0 (_data_->file);
	_data_->file = _tmp1_;
	deja_dup_backend_file_query_exists_async_co (_data_);
}

static gboolean
deja_dup_backend_file_query_exists_finish (DejaDupBackendFile* self,
                                           GAsyncResult* _res_)
{
	gboolean result;
	DejaDupBackendFileQueryExistsAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static void
deja_dup_backend_file_query_exists_async_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_)
{
	DejaDupBackendFileQueryExistsAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_backend_file_query_exists_async_co (_data_);
}

static gboolean
deja_dup_backend_file_query_exists_async_co (DejaDupBackendFileQueryExistsAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_state_ = 1;
		g_file_query_info_async (_data_->file, G_FILE_ATTRIBUTE_STANDARD_TYPE, G_FILE_QUERY_INFO_NONE, G_PRIORITY_LOW, NULL, deja_dup_backend_file_query_exists_async_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp0_ = g_file_query_info_finish (_data_->file, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp1_ = _data_->_tmp0_;
		_g_object_unref0 (_data_->_tmp1_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->result = TRUE;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_data_->_inner_error0_);
		_data_->result = FALSE;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
	g_clear_error (&_data_->_inner_error0_);
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static inline void
_g_list_free__g_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_free0_);
}

static void
deja_dup_backend_file_real_peek_at_files_data_free (gpointer _data)
{
	DejaDupBackendFilePeekAtFilesData* _data_;
	_data_ = _data;
	(_data_->result == NULL) ? NULL : (_data_->result = (_g_list_free__g_free0_ (_data_->result), NULL));
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupBackendFilePeekAtFilesData, _data_);
}

static void
deja_dup_backend_file_real_peek_at_files (DejaDupBackend* base,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	DejaDupBackendFile * self;
	DejaDupBackendFilePeekAtFilesData* _data_;
	DejaDupBackendFile* _tmp0_;
	self = (DejaDupBackendFile*) base;
	_data_ = g_slice_new0 (DejaDupBackendFilePeekAtFilesData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, deja_dup_backend_file_real_peek_at_files_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	deja_dup_backend_file_real_peek_at_files_co (_data_);
}

static GList*
deja_dup_backend_file_peek_at_files_finish (DejaDupBackend* base,
                                            GAsyncResult* _res_)
{
	GList* result;
	DejaDupBackendFilePeekAtFilesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
deja_dup_backend_file_peek_at_files_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_)
{
	DejaDupBackendFilePeekAtFilesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_backend_file_real_peek_at_files_co (_data_);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static gboolean
deja_dup_backend_file_real_peek_at_files_co (DejaDupBackendFilePeekAtFilesData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->filenames = NULL;
	_data_->_tmp0_ = deja_dup_backend_file_get_file_from_settings (_data_->self);
	_data_->gfile = _data_->_tmp0_;
	{
		_data_->_tmp1_ = _data_->gfile;
		_data_->_state_ = 1;
		g_file_enumerate_children_async (_data_->_tmp1_, G_FILE_ATTRIBUTE_STANDARD_NAME "," G_FILE_ATTRIBUTE_STANDARD_IS_HIDDEN, G_FILE_QUERY_INFO_NONE, G_PRIORITY_LOW, NULL, deja_dup_backend_file_peek_at_files_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp2_ = g_file_enumerate_children_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error0_);
		_data_->enumerator = _data_->_tmp2_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		while (TRUE) {
			_data_->_tmp3_ = _data_->filenames;
			if (!(g_list_length (_data_->_tmp3_) < ((guint) 20))) {
				break;
			}
			_data_->_tmp4_ = _data_->enumerator;
			_data_->_state_ = 2;
			g_file_enumerator_next_files_async (_data_->_tmp4_, 20, G_PRIORITY_LOW, NULL, deja_dup_backend_file_peek_at_files_ready, _data_);
			return FALSE;
			_state_2:
			_data_->_tmp5_ = g_file_enumerator_next_files_finish (_data_->_tmp4_, _data_->_res_, &_data_->_inner_error0_);
			_data_->infos = _data_->_tmp5_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_object_unref0 (_data_->enumerator);
				goto __catch0_g_error;
			}
			_data_->_tmp6_ = _data_->infos;
			if (g_list_length (_data_->_tmp6_) == ((guint) 0)) {
				(_data_->infos == NULL) ? NULL : (_data_->infos = (_g_list_free__g_object_unref0_ (_data_->infos), NULL));
				break;
			}
			_data_->_tmp7_ = _data_->infos;
			{
				_data_->info_collection = _data_->_tmp7_;
				for (_data_->info_it = _data_->info_collection; _data_->info_it != NULL; _data_->info_it = _data_->info_it->next) {
					_data_->_tmp8_ = _g_object_ref0 ((GFileInfo*) _data_->info_it->data);
					_data_->info = _data_->_tmp8_;
					{
						_data_->_tmp9_ = _data_->info;
						if (!g_file_info_get_is_hidden (_data_->_tmp9_)) {
							_data_->_tmp10_ = _data_->info;
							_data_->_tmp11_ = g_file_info_get_name (_data_->_tmp10_);
							_data_->_tmp12_ = g_strdup (_data_->_tmp11_);
							_data_->filenames = g_list_append (_data_->filenames, _data_->_tmp12_);
						}
						_g_object_unref0 (_data_->info);
					}
				}
			}
			(_data_->infos == NULL) ? NULL : (_data_->infos = (_g_list_free__g_object_unref0_ (_data_->infos), NULL));
		}
		_data_->result = _data_->filenames;
		_g_object_unref0 (_data_->enumerator);
		_g_object_unref0 (_data_->gfile);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_data_->_inner_error0_);
		_data_->result = _data_->filenames;
		_g_object_unref0 (_data_->gfile);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	_g_object_unref0 (_data_->gfile);
	(_data_->filenames == NULL) ? NULL : (_data_->filenames = (_g_list_free__g_free0_ (_data_->filenames), NULL));
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
	g_clear_error (&_data_->_inner_error0_);
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
deja_dup_backend_file_real_prepare_data_free (gpointer _data)
{
	DejaDupBackendFilePrepareData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupBackendFilePrepareData, _data_);
}

static void
deja_dup_backend_file_real_prepare (DejaDupBackend* base,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_)
{
	DejaDupBackendFile * self;
	DejaDupBackendFilePrepareData* _data_;
	DejaDupBackendFile* _tmp0_;
	self = (DejaDupBackendFile*) base;
	_data_ = g_slice_new0 (DejaDupBackendFilePrepareData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, deja_dup_backend_file_real_prepare_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	deja_dup_backend_file_real_prepare_co (_data_);
}

static void
deja_dup_backend_file_prepare_finish (DejaDupBackend* base,
                                      GAsyncResult* _res_,
                                      GError** error)
{
	DejaDupBackendFilePrepareData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
deja_dup_backend_file_prepare_ready (GObject* source_object,
                                     GAsyncResult* _res_,
                                     gpointer _user_data_)
{
	DejaDupBackendFilePrepareData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_backend_file_real_prepare_co (_data_);
}

static gboolean
deja_dup_backend_file_real_prepare_co (DejaDupBackendFilePrepareData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	deja_dup_backend_file_mount (_data_->self, deja_dup_backend_file_prepare_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp1_ = deja_dup_backend_file_mount_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (_data_->_tmp1_) {
		_data_->_tmp0_ = TRUE;
	} else {
		_data_->_tmp0_ = _data_->self->priv->will_unmount;
	}
	_data_->self->priv->will_unmount = _data_->_tmp0_;
	_data_->_tmp2_ = deja_dup_backend_file_get_file_from_settings (_data_->self);
	_data_->gfile = _data_->_tmp2_;
	_data_->_tmp4_ = _data_->gfile;
	if (_data_->_tmp4_ != NULL) {
		_data_->_tmp5_ = _data_->gfile;
		_data_->_state_ = 2;
		deja_dup_backend_file_query_exists_async (_data_->self, _data_->_tmp5_, deja_dup_backend_file_prepare_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp3_ = !deja_dup_backend_file_query_exists_finish (_data_->self, _data_->_res_);
	} else {
		_data_->_tmp3_ = FALSE;
	}
	if (_data_->_tmp3_) {
		{
			_data_->_tmp6_ = _data_->gfile;
			g_file_make_directory_with_parents (_data_->_tmp6_, NULL, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				if (g_error_matches (_data_->_inner_error0_, G_IO_ERROR, G_IO_ERROR_EXISTS)) {
					goto __catch0_g_io_error_exists;
				}
				goto __finally0;
			}
		}
		goto __finally0;
		__catch0_g_io_error_exists:
		{
			g_clear_error (&_data_->_inner_error0_);
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->gfile);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_g_object_unref0 (_data_->gfile);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
deja_dup_backend_file_real_mount_data_free (gpointer _data)
{
	DejaDupBackendFileMountData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupBackendFileMountData, _data_);
}

static void
deja_dup_backend_file_real_mount (DejaDupBackendFile* self,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_)
{
	DejaDupBackendFileMountData* _data_;
	DejaDupBackendFile* _tmp0_;
	_data_ = g_slice_new0 (DejaDupBackendFileMountData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, deja_dup_backend_file_real_mount_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	deja_dup_backend_file_real_mount_co (_data_);
}

static gboolean
deja_dup_backend_file_real_mount_finish (DejaDupBackendFile* self,
                                         GAsyncResult* _res_,
                                         GError** error)
{
	gboolean result;
	DejaDupBackendFileMountData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

static gboolean
deja_dup_backend_file_real_mount_co (DejaDupBackendFileMountData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->result = FALSE;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
deja_dup_backend_file_mount (DejaDupBackendFile* self,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_)
{
	DejaDupBackendFileClass* _klass_;
	_klass_ = DEJA_DUP_BACKEND_FILE_GET_CLASS (self);
	if (_klass_->mount) {
		_klass_->mount (self, _callback_, _user_data_);
	}
}

gboolean
deja_dup_backend_file_mount_finish (DejaDupBackendFile* self,
                                    GAsyncResult* _res_,
                                    GError** error)
{
	DejaDupBackendFileClass* _klass_;
	_klass_ = DEJA_DUP_BACKEND_FILE_GET_CLASS (self);
	if (_klass_->mount_finish) {
		return _klass_->mount_finish (self, _res_, error);
	}
	return FALSE;
}

static void
deja_dup_backend_file_real_unmount_data_free (gpointer _data)
{
	DejaDupBackendFileUnmountData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupBackendFileUnmountData, _data_);
}

static void
deja_dup_backend_file_real_unmount (DejaDupBackendFile* self,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_)
{
	DejaDupBackendFileUnmountData* _data_;
	DejaDupBackendFile* _tmp0_;
	_data_ = g_slice_new0 (DejaDupBackendFileUnmountData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, deja_dup_backend_file_real_unmount_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	deja_dup_backend_file_real_unmount_co (_data_);
}

static void
deja_dup_backend_file_real_unmount_finish (DejaDupBackendFile* self,
                                           GAsyncResult* _res_)
{
	DejaDupBackendFileUnmountData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
deja_dup_backend_file_unmount_ready (GObject* source_object,
                                     GAsyncResult* _res_,
                                     gpointer _user_data_)
{
	DejaDupBackendFileUnmountData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_backend_file_real_unmount_co (_data_);
}

static gboolean
deja_dup_backend_file_real_unmount_co (DejaDupBackendFileUnmountData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = deja_dup_backend_file_get_root_from_settings (_data_->self);
	_data_->root = _data_->_tmp0_;
	{
		_data_->_tmp1_ = _data_->root;
		_data_->_state_ = 1;
		g_file_find_enclosing_mount_async (_data_->_tmp1_, G_PRIORITY_DEFAULT, NULL, deja_dup_backend_file_unmount_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp2_ = g_file_find_enclosing_mount_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error0_);
		_data_->mount = _data_->_tmp2_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp4_ = _data_->mount;
		if (_data_->_tmp4_ != NULL) {
			_data_->_tmp5_ = _data_->mount;
			_data_->_tmp3_ = g_mount_can_unmount (_data_->_tmp5_);
		} else {
			_data_->_tmp3_ = FALSE;
		}
		if (_data_->_tmp3_) {
			_data_->_tmp6_ = _data_->mount;
			_data_->_state_ = 2;
			g_mount_unmount_with_operation (_data_->_tmp6_, G_MOUNT_UNMOUNT_NONE, NULL, NULL, deja_dup_backend_file_unmount_ready, _data_);
			return FALSE;
			_state_2:
			g_mount_unmount_with_operation_finish (_data_->_tmp6_, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_object_unref0 (_data_->mount);
				goto __catch0_g_error;
			}
		}
		_g_object_unref0 (_data_->mount);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_data_->_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->root);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->root);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
deja_dup_backend_file_unmount (DejaDupBackendFile* self,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_)
{
	DejaDupBackendFileClass* _klass_;
	_klass_ = DEJA_DUP_BACKEND_FILE_GET_CLASS (self);
	if (_klass_->unmount) {
		_klass_->unmount (self, _callback_, _user_data_);
	}
}

void
deja_dup_backend_file_unmount_finish (DejaDupBackendFile* self,
                                      GAsyncResult* _res_)
{
	DejaDupBackendFileClass* _klass_;
	_klass_ = DEJA_DUP_BACKEND_FILE_GET_CLASS (self);
	if (_klass_->unmount_finish) {
		_klass_->unmount_finish (self, _res_);
	}
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gchar*
deja_dup_backend_file_escape_uri_chars (const gchar* path)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* result;
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = string_replace (path, "%", "%25");
	_tmp1_ = _tmp0_;
	_tmp2_ = string_replace (_tmp1_, "?", "%3F");
	_tmp3_ = _tmp2_;
	_tmp4_ = string_replace (_tmp3_, "#", "%23");
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	result = _tmp5_;
	return result;
}

gchar*
deja_dup_backend_file_get_path_as_url (DejaDupBackendFile* self)
{
	GFile* file = NULL;
	GFile* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GFile* _tmp2_;
	gchar* escaped = NULL;
	GFile* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = deja_dup_backend_file_get_file_from_settings (self);
	file = _tmp0_;
	_tmp2_ = file;
	if (_tmp2_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		GFile* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp3_ = file;
		_tmp4_ = g_file_get_path (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp1_ = _tmp5_ == NULL;
		_g_free0 (_tmp5_);
	}
	if (_tmp1_) {
		result = NULL;
		_g_object_unref0 (file);
		return result;
	}
	_tmp6_ = file;
	_tmp7_ = g_file_get_path (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = deja_dup_backend_file_escape_uri_chars (_tmp8_);
	_tmp10_ = _tmp9_;
	_g_free0 (_tmp8_);
	escaped = _tmp10_;
	_tmp11_ = escaped;
	_tmp12_ = g_strconcat ("file://", _tmp11_, NULL);
	result = _tmp12_;
	_g_free0 (escaped);
	_g_object_unref0 (file);
	return result;
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

gchar*
deja_dup_backend_file_replace_path_with_uri (DejaDupBackendFile* self,
                                             const gchar* message)
{
	GFile* file = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	gchar* path = NULL;
	GFile* _tmp3_;
	gchar* _tmp4_;
	gchar* uri = NULL;
	GFile* _tmp5_;
	gchar* _tmp6_;
	gboolean _tmp7_ = FALSE;
	const gchar* _tmp8_;
	const gchar* _tmp11_;
	guint8* _tmp12_;
	gint _tmp12__length1;
	gint _tmp13_ = 0;
	guint8* _tmp14_;
	gint _tmp14__length1;
	const gchar* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	guint8 _tmp18_;
	const gchar* _tmp26_;
	guint8* _tmp27_;
	gint _tmp27__length1;
	gint _tmp28_ = 0;
	guint8* _tmp29_;
	gint _tmp29__length1;
	const gchar* _tmp30_;
	gint _tmp31_;
	gint _tmp32_;
	guint8 _tmp33_;
	const gchar* _tmp41_;
	const gchar* _tmp42_;
	gchar* _tmp43_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (message == NULL) {
		result = NULL;
		return result;
	}
	_tmp0_ = deja_dup_backend_file_get_file_from_settings (self);
	file = _tmp0_;
	_tmp1_ = file;
	if (_tmp1_ == NULL) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (message);
		result = _tmp2_;
		_g_object_unref0 (file);
		return result;
	}
	_tmp3_ = file;
	_tmp4_ = g_file_get_path (_tmp3_);
	path = _tmp4_;
	_tmp5_ = file;
	_tmp6_ = g_file_get_uri (_tmp5_);
	uri = _tmp6_;
	_tmp8_ = path;
	if (_tmp8_ == NULL) {
		_tmp7_ = TRUE;
	} else {
		const gchar* _tmp9_;
		_tmp9_ = uri;
		_tmp7_ = _tmp9_ == NULL;
	}
	if (_tmp7_) {
		gchar* _tmp10_;
		_tmp10_ = g_strdup (message);
		result = _tmp10_;
		_g_free0 (uri);
		_g_free0 (path);
		_g_object_unref0 (file);
		return result;
	}
	_tmp11_ = path;
	_tmp12_ = string_get_data (_tmp11_, &_tmp13_);
	_tmp12__length1 = _tmp13_;
	_tmp14_ = _tmp12_;
	_tmp14__length1 = _tmp12__length1;
	_tmp15_ = path;
	_tmp16_ = strlen (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = _tmp14_[_tmp17_ - 1];
	if (_tmp18_ == ((guint8) '/')) {
		const gchar* _tmp19_;
		guint8* _tmp20_;
		gint _tmp20__length1;
		gint _tmp21_ = 0;
		guint8* _tmp22_;
		gint _tmp22__length1;
		const gchar* _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		_tmp19_ = path;
		_tmp20_ = string_get_data (_tmp19_, &_tmp21_);
		_tmp20__length1 = _tmp21_;
		_tmp22_ = _tmp20_;
		_tmp22__length1 = _tmp20__length1;
		_tmp23_ = path;
		_tmp24_ = strlen (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp22_[_tmp25_ - 1] = (guint8) 0;
	}
	_tmp26_ = uri;
	_tmp27_ = string_get_data (_tmp26_, &_tmp28_);
	_tmp27__length1 = _tmp28_;
	_tmp29_ = _tmp27_;
	_tmp29__length1 = _tmp27__length1;
	_tmp30_ = uri;
	_tmp31_ = strlen (_tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = _tmp29_[_tmp32_ - 1];
	if (_tmp33_ == ((guint8) '/')) {
		const gchar* _tmp34_;
		guint8* _tmp35_;
		gint _tmp35__length1;
		gint _tmp36_ = 0;
		guint8* _tmp37_;
		gint _tmp37__length1;
		const gchar* _tmp38_;
		gint _tmp39_;
		gint _tmp40_;
		_tmp34_ = uri;
		_tmp35_ = string_get_data (_tmp34_, &_tmp36_);
		_tmp35__length1 = _tmp36_;
		_tmp37_ = _tmp35_;
		_tmp37__length1 = _tmp35__length1;
		_tmp38_ = uri;
		_tmp39_ = strlen (_tmp38_);
		_tmp40_ = _tmp39_;
		_tmp37_[_tmp40_ - 1] = (guint8) 0;
	}
	_tmp41_ = path;
	_tmp42_ = uri;
	_tmp43_ = string_replace (message, _tmp41_, _tmp42_);
	result = _tmp43_;
	_g_free0 (uri);
	_g_free0 (path);
	_g_object_unref0 (file);
	return result;
}

static void
deja_dup_backend_file_real_get_space_data_free (gpointer _data)
{
	DejaDupBackendFileGetSpaceData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupBackendFileGetSpaceData, _data_);
}

static void
deja_dup_backend_file_real_get_space (DejaDupBackend* base,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	DejaDupBackendFile * self;
	DejaDupBackendFileGetSpaceData* _data_;
	DejaDupBackendFile* _tmp0_;
	self = (DejaDupBackendFile*) base;
	_data_ = g_slice_new0 (DejaDupBackendFileGetSpaceData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, deja_dup_backend_file_real_get_space_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	deja_dup_backend_file_real_get_space_co (_data_);
}

static void
deja_dup_backend_file_get_space_finish (DejaDupBackend* base,
                                        GAsyncResult* _res_,
                                        guint64* free,
                                        guint64* total)
{
	DejaDupBackendFileGetSpaceData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	if (free) {
		*free = _data_->free;
	}
	if (total) {
		*total = _data_->total;
	}
}

static void
deja_dup_backend_file_get_space_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_)
{
	DejaDupBackendFileGetSpaceData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_backend_file_real_get_space_co (_data_);
}

static guint64
uint64_parse (const gchar* str,
              guint _base)
{
	guint64 result;
	g_return_val_if_fail (str != NULL, 0ULL);
	result = g_ascii_strtoull (str, NULL, _base);
	return result;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

static gboolean
deja_dup_backend_file_real_get_space_co (DejaDupBackendFileGetSpaceData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = 0ULL;
	_data_->_tmp1_ = 0ULL;
	_data_->_state_ = 1;
	DEJA_DUP_BACKEND_CLASS (deja_dup_backend_file_parent_class)->get_space (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, DEJA_DUP_TYPE_BACKEND, DejaDupBackend), deja_dup_backend_file_get_space_ready, _data_);
	return FALSE;
	_state_1:
	DEJA_DUP_BACKEND_CLASS (deja_dup_backend_file_parent_class)->get_space_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, DEJA_DUP_TYPE_BACKEND, DejaDupBackend), _data_->_res_, &_data_->_tmp0_, &_data_->_tmp1_);
	_data_->free = _data_->_tmp0_;
	_data_->total = _data_->_tmp1_;
	_data_->_tmp2_ = deja_dup_backend_file_get_file_from_settings (_data_->self);
	_data_->file = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->file;
	if (_data_->_tmp3_ == NULL) {
		_g_object_unref0 (_data_->file);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp5_ = _data_->file;
		_data_->_state_ = 2;
		g_file_query_filesystem_info_async (_data_->_tmp5_, G_FILE_ATTRIBUTE_FILESYSTEM_FREE "," G_FILE_ATTRIBUTE_FILESYSTEM_SIZE, G_PRIORITY_LOW, NULL, deja_dup_backend_file_get_space_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp6_ = g_file_query_filesystem_info_finish (_data_->_tmp5_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp4_ = _data_->_tmp6_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp7_ = _data_->_tmp4_;
		_data_->_tmp4_ = NULL;
		_g_object_unref0 (_data_->info);
		_data_->info = _data_->_tmp7_;
		_g_object_unref0 (_data_->_tmp4_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp8_ = _data_->e;
		_data_->_tmp9_ = _data_->_tmp8_->message;
		g_warning ("BackendFile.vala:199: Could not query GVfs space: %s\n", _data_->_tmp9_);
		_g_error_free0 (_data_->e);
		_g_object_unref0 (_data_->info);
		_g_object_unref0 (_data_->file);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->info);
		_g_object_unref0 (_data_->file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (deja_dup_in_testing_mode ()) {
		_data_->_tmp11_ = g_getenv ("DEJA_DUP_TEST_SPACE_FREE");
		_data_->_tmp10_ = _data_->_tmp11_ != NULL;
	} else {
		_data_->_tmp10_ = FALSE;
	}
	if (_data_->_tmp10_) {
		_data_->_tmp12_ = g_getenv ("DEJA_DUP_TEST_SPACE_FREE");
		_data_->_tmp13_ = g_strdup (_data_->_tmp12_);
		_data_->free_str = _data_->_tmp13_;
		_data_->_tmp14_ = _data_->free_str;
		_data_->_tmp16_ = _data_->_tmp15_ = g_strsplit (_data_->_tmp14_, ";", 0);
		_data_->free_list = _data_->_tmp16_;
		_data_->free_list_length1 = _vala_array_length (_data_->_tmp15_);
		_data_->_free_list_size_ = _data_->free_list_length1;
		_data_->_tmp17_ = _data_->free_list;
		_data_->_tmp17__length1 = _data_->free_list_length1;
		_data_->_tmp18_ = _data_->_tmp17_[0];
		_data_->free = uint64_parse (_data_->_tmp18_, (guint) 0);
		_data_->_tmp19_ = _data_->free_list;
		_data_->_tmp19__length1 = _data_->free_list_length1;
		_data_->_tmp20_ = _data_->_tmp19_[1];
		if (_data_->_tmp20_ != NULL) {
			_data_->_tmp21_ = _data_->free_list;
			_data_->_tmp21__length1 = _data_->free_list_length1;
			_data_->_tmp22_ = _data_->free_list;
			_data_->_tmp22__length1 = _data_->free_list_length1;
			_data_->_tmp23_ = _vala_g_strjoinv (";", _data_->_tmp21_ + 1, (gint) (_data_->_tmp22__length1 - 1));
			_data_->space_free = _data_->_tmp23_;
			_data_->_tmp24_ = _data_->space_free;
			g_setenv ("DEJA_DUP_TEST_SPACE_FREE", _data_->_tmp24_, TRUE);
			_g_free0 (_data_->space_free);
		}
		_data_->free_list = (_vala_array_free (_data_->free_list, _data_->free_list_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (_data_->free_str);
	} else {
		_data_->_tmp25_ = _data_->info;
		if (g_file_info_has_attribute (_data_->_tmp25_, G_FILE_ATTRIBUTE_FILESYSTEM_FREE)) {
			_data_->_tmp26_ = _data_->info;
			_data_->free = g_file_info_get_attribute_uint64 (_data_->_tmp26_, G_FILE_ATTRIBUTE_FILESYSTEM_FREE);
			if (_data_->free == DEJA_DUP_BACKEND_INFINITE_SPACE) {
				_data_->free = _data_->free - 1;
			}
		}
	}
	_data_->_tmp27_ = _data_->info;
	if (g_file_info_has_attribute (_data_->_tmp27_, G_FILE_ATTRIBUTE_FILESYSTEM_SIZE)) {
		_data_->_tmp28_ = _data_->info;
		_data_->total = g_file_info_get_attribute_uint64 (_data_->_tmp28_, G_FILE_ATTRIBUTE_FILESYSTEM_SIZE);
		if (_data_->total == DEJA_DUP_BACKEND_INFINITE_SPACE) {
			_data_->total = _data_->total - 1;
		}
	}
	if (_data_->free != DEJA_DUP_BACKEND_INFINITE_SPACE) {
		_data_->_tmp29_ = _data_->free > _data_->total;
	} else {
		_data_->_tmp29_ = FALSE;
	}
	if (_data_->_tmp29_) {
		_data_->total = _data_->free;
	}
	_g_object_unref0 (_data_->info);
	_g_object_unref0 (_data_->file);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

DejaDupBackendFile*
deja_dup_backend_file_construct (GType object_type)
{
	DejaDupBackendFile * self = NULL;
	self = (DejaDupBackendFile*) deja_dup_backend_construct (object_type);
	return self;
}

gboolean
deja_dup_backend_file_get_unmount_when_done (DejaDupBackendFile* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_unmount_when_done;
	return result;
}

void
deja_dup_backend_file_set_unmount_when_done (DejaDupBackendFile* self,
                                             gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = deja_dup_backend_file_get_unmount_when_done (self);
	if (old_value != value) {
		self->priv->_unmount_when_done = value;
		g_object_notify_by_pspec ((GObject *) self, deja_dup_backend_file_properties[DEJA_DUP_BACKEND_FILE_UNMOUNT_WHEN_DONE_PROPERTY]);
	}
}

static void
deja_dup_backend_file_class_init (DejaDupBackendFileClass * klass,
                                  gpointer klass_data)
{
	deja_dup_backend_file_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DejaDupBackendFile_private_offset);
	((DejaDupBackendClass *) klass)->cleanup = (void (*) (DejaDupBackend*, GAsyncReadyCallback, gpointer)) deja_dup_backend_file_real_cleanup;
	((DejaDupBackendClass *) klass)->cleanup_finish = (void (*) (DejaDupBackend*, GAsyncResult*)) deja_dup_backend_file_cleanup_finish;
	((DejaDupBackendClass *) klass)->get_dependencies = (gchar** (*) (DejaDupBackend*, gint*)) deja_dup_backend_file_real_get_dependencies;
	((DejaDupBackendFileClass *) klass)->get_root_from_settings = (GFile* (*) (DejaDupBackendFile*)) deja_dup_backend_file_real_get_root_from_settings;
	((DejaDupBackendFileClass *) klass)->get_file_from_settings = (GFile* (*) (DejaDupBackendFile*)) deja_dup_backend_file_real_get_file_from_settings;
	((DejaDupBackendClass *) klass)->get_location_pretty = (gchar* (*) (DejaDupBackend*)) deja_dup_backend_file_real_get_location_pretty;
	((DejaDupBackendClass *) klass)->get_unique_location = (gchar* (*) (DejaDupBackend*)) deja_dup_backend_file_real_get_unique_location;
	((DejaDupBackendClass *) klass)->is_native = (gboolean (*) (DejaDupBackend*)) deja_dup_backend_file_real_is_native;
	((DejaDupBackendClass *) klass)->add_excludes = (void (*) (DejaDupBackend*, GList**)) deja_dup_backend_file_real_add_excludes;
	((DejaDupBackendClass *) klass)->peek_at_files = (void (*) (DejaDupBackend*, GAsyncReadyCallback, gpointer)) deja_dup_backend_file_real_peek_at_files;
	((DejaDupBackendClass *) klass)->peek_at_files_finish = (GList* (*) (DejaDupBackend*, GAsyncResult*)) deja_dup_backend_file_peek_at_files_finish;
	((DejaDupBackendClass *) klass)->prepare = (void (*) (DejaDupBackend*, GAsyncReadyCallback, gpointer)) deja_dup_backend_file_real_prepare;
	((DejaDupBackendClass *) klass)->prepare_finish = (void (*) (DejaDupBackend*, GAsyncResult*, GError**)) deja_dup_backend_file_prepare_finish;
	((DejaDupBackendFileClass *) klass)->mount = (void (*) (DejaDupBackendFile*, GAsyncReadyCallback, gpointer)) deja_dup_backend_file_real_mount;
	((DejaDupBackendFileClass *) klass)->mount_finish = (gboolean (*) (DejaDupBackendFile*, GAsyncResult*, GError**)) deja_dup_backend_file_real_mount_finish;
	((DejaDupBackendFileClass *) klass)->unmount = (void (*) (DejaDupBackendFile*, GAsyncReadyCallback, gpointer)) deja_dup_backend_file_real_unmount;
	((DejaDupBackendFileClass *) klass)->unmount_finish = (void (*) (DejaDupBackendFile*, GAsyncResult*)) deja_dup_backend_file_real_unmount_finish;
	((DejaDupBackendClass *) klass)->get_space = (void (*) (DejaDupBackend*, GAsyncReadyCallback, gpointer)) deja_dup_backend_file_real_get_space;
	((DejaDupBackendClass *) klass)->get_space_finish = (void (*) (DejaDupBackend*, GAsyncResult*, guint64*, guint64*)) deja_dup_backend_file_get_space_finish;
	G_OBJECT_CLASS (klass)->get_property = _vala_deja_dup_backend_file_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_deja_dup_backend_file_set_property;
	G_OBJECT_CLASS (klass)->finalize = deja_dup_backend_file_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_BACKEND_FILE_UNMOUNT_WHEN_DONE_PROPERTY, deja_dup_backend_file_properties[DEJA_DUP_BACKEND_FILE_UNMOUNT_WHEN_DONE_PROPERTY] = g_param_spec_boolean ("unmount-when-done", "unmount-when-done", "unmount-when-done", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
deja_dup_backend_file_instance_init (DejaDupBackendFile * self,
                                     gpointer klass)
{
	self->priv = deja_dup_backend_file_get_instance_private (self);
	self->priv->_unmount_when_done = TRUE;
	self->priv->will_unmount = FALSE;
}

static void
deja_dup_backend_file_finalize (GObject * obj)
{
	DejaDupBackendFile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DEJA_DUP_TYPE_BACKEND_FILE, DejaDupBackendFile);
	G_OBJECT_CLASS (deja_dup_backend_file_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
deja_dup_backend_file_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DejaDupBackendFileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deja_dup_backend_file_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DejaDupBackendFile), 0, (GInstanceInitFunc) deja_dup_backend_file_instance_init, NULL };
	GType deja_dup_backend_file_type_id;
	deja_dup_backend_file_type_id = g_type_register_static (DEJA_DUP_TYPE_BACKEND, "DejaDupBackendFile", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	DejaDupBackendFile_private_offset = g_type_add_instance_private (deja_dup_backend_file_type_id, sizeof (DejaDupBackendFilePrivate));
	return deja_dup_backend_file_type_id;
}

GType
deja_dup_backend_file_get_type (void)
{
	static gsize deja_dup_backend_file_type_id__once = 0;
	if (g_once_init_enter (&deja_dup_backend_file_type_id__once)) {
		GType deja_dup_backend_file_type_id;
		deja_dup_backend_file_type_id = deja_dup_backend_file_get_type_once ();
		g_once_init_leave (&deja_dup_backend_file_type_id__once, deja_dup_backend_file_type_id);
	}
	return deja_dup_backend_file_type_id__once;
}

static void
_vala_deja_dup_backend_file_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	DejaDupBackendFile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DEJA_DUP_TYPE_BACKEND_FILE, DejaDupBackendFile);
	switch (property_id) {
		case DEJA_DUP_BACKEND_FILE_UNMOUNT_WHEN_DONE_PROPERTY:
		g_value_set_boolean (value, deja_dup_backend_file_get_unmount_when_done (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_deja_dup_backend_file_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	DejaDupBackendFile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DEJA_DUP_TYPE_BACKEND_FILE, DejaDupBackendFile);
	switch (property_id) {
		case DEJA_DUP_BACKEND_FILE_UNMOUNT_WHEN_DONE_PROPERTY:
		deja_dup_backend_file_set_unmount_when_done (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

