/* Generated by wayland-scanner 1.24.0 */

#ifndef PLUGIN_MANAGER_V1_CLIENT_PROTOCOL_H
#define PLUGIN_MANAGER_V1_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_plugin_manager_v1 The plugin_manager_v1 protocol
 * @section page_ifaces_plugin_manager_v1 Interfaces
 * - @subpage page_iface_plugin_manager_v1 - plugin manager
 * - @subpage page_iface_plugin_popup - 
 * - @subpage page_iface_plugin - 
 * @section page_copyright_plugin_manager_v1 Copyright
 * <pre>
 *
 * Copyright © 2024 Uniontech
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct plugin;
struct plugin_manager_v1;
struct plugin_popup;
struct wl_callback;
struct wl_surface;

#ifndef PLUGIN_MANAGER_V1_INTERFACE
#define PLUGIN_MANAGER_V1_INTERFACE
/**
 * @page page_iface_plugin_manager_v1 plugin_manager_v1
 * @section page_iface_plugin_manager_v1_desc Description
 *
 * This interface allows a client to get server(dock) some info and create plugins to compositor.
 * @section page_iface_plugin_manager_v1_api API
 * See @ref iface_plugin_manager_v1.
 */
/**
 * @defgroup iface_plugin_manager_v1 The plugin_manager_v1 interface
 *
 * This interface allows a client to get server(dock) some info and create plugins to compositor.
 */
extern const struct wl_interface plugin_manager_v1_interface;
#endif
#ifndef PLUGIN_POPUP_INTERFACE
#define PLUGIN_POPUP_INTERFACE
/**
 * @page page_iface_plugin_popup plugin_popup
 * @section page_iface_plugin_popup_api API
 * See @ref iface_plugin_popup.
 */
/**
 * @defgroup iface_plugin_popup The plugin_popup interface
 */
extern const struct wl_interface plugin_popup_interface;
#endif
#ifndef PLUGIN_INTERFACE
#define PLUGIN_INTERFACE
/**
 * @page page_iface_plugin plugin
 * @section page_iface_plugin_api API
 * See @ref iface_plugin.
 */
/**
 * @defgroup iface_plugin The plugin interface
 */
extern const struct wl_interface plugin_interface;
#endif

#ifndef PLUGIN_MANAGER_V1_ERROR_ENUM
#define PLUGIN_MANAGER_V1_ERROR_ENUM
enum plugin_manager_v1_error {
	/**
	 * given wl_surface has another role
	 */
	PLUGIN_MANAGER_V1_ERROR_ROLE = 0,
	/**
	 * given wl_surface has another plugin_id
	 */
	PLUGIN_MANAGER_V1_ERROR_PLUGIN_ID = 1,
};
#endif /* PLUGIN_MANAGER_V1_ERROR_ENUM */

/**
 * @ingroup iface_plugin_manager_v1
 * @struct plugin_manager_v1_listener
 */
struct plugin_manager_v1_listener {
	/**
	 */
	void (*position_changed)(void *data,
				 struct plugin_manager_v1 *plugin_manager_v1,
				 uint32_t dock_position);
	/**
	 */
	void (*color_theme_changed)(void *data,
				    struct plugin_manager_v1 *plugin_manager_v1,
				    uint32_t dock_color_theme);
	/**
	 * active color
	 *
	 * sync active color from server.
	 */
	void (*active_color_changed)(void *data,
				     struct plugin_manager_v1 *plugin_manager_v1,
				     const char *active_color,
				     const char *dark_active_color);
	/**
	 * font information
	 *
	 * sync font information from server.
	 */
	void (*font_changed)(void *data,
			     struct plugin_manager_v1 *plugin_manager_v1,
			     const char *font_name,
			     int32_t font_point_size);
	/**
	 * theme information
	 *
	 * sync theme information from server.
	 */
	void (*theme_changed)(void *data,
			      struct plugin_manager_v1 *plugin_manager_v1,
			      const char *theme_name,
			      const char *icon_theme_name);
	/**
	 * a message sent from server (dock)
	 *
	 * This event will emitted when server(dock) send message to
	 * plugin. Such as dock position/themeType/overflowStatus and other
	 * event defined in server(dock) interface
	 */
	void (*event_message)(void *data,
			      struct plugin_manager_v1 *plugin_manager_v1,
			      const char *msg);
};

/**
 * @ingroup iface_plugin_manager_v1
 */
static inline int
plugin_manager_v1_add_listener(struct plugin_manager_v1 *plugin_manager_v1,
			       const struct plugin_manager_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) plugin_manager_v1,
				     (void (**)(void)) listener, data);
}

#define PLUGIN_MANAGER_V1_DESTROY 0
#define PLUGIN_MANAGER_V1_REQUEST_MESSAGE 1
#define PLUGIN_MANAGER_V1_CREATE_POPUP_AT 2
#define PLUGIN_MANAGER_V1_CREATE_PLUGIN 3
#define PLUGIN_MANAGER_V1_MOVE_XEMBED_WINDOW 4

/**
 * @ingroup iface_plugin_manager_v1
 */
#define PLUGIN_MANAGER_V1_POSITION_CHANGED_SINCE_VERSION 1
/**
 * @ingroup iface_plugin_manager_v1
 */
#define PLUGIN_MANAGER_V1_COLOR_THEME_CHANGED_SINCE_VERSION 1
/**
 * @ingroup iface_plugin_manager_v1
 */
#define PLUGIN_MANAGER_V1_ACTIVE_COLOR_CHANGED_SINCE_VERSION 1
/**
 * @ingroup iface_plugin_manager_v1
 */
#define PLUGIN_MANAGER_V1_FONT_CHANGED_SINCE_VERSION 1
/**
 * @ingroup iface_plugin_manager_v1
 */
#define PLUGIN_MANAGER_V1_THEME_CHANGED_SINCE_VERSION 1
/**
 * @ingroup iface_plugin_manager_v1
 */
#define PLUGIN_MANAGER_V1_EVENT_MESSAGE_SINCE_VERSION 1

/**
 * @ingroup iface_plugin_manager_v1
 */
#define PLUGIN_MANAGER_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_plugin_manager_v1
 */
#define PLUGIN_MANAGER_V1_REQUEST_MESSAGE_SINCE_VERSION 1
/**
 * @ingroup iface_plugin_manager_v1
 */
#define PLUGIN_MANAGER_V1_CREATE_POPUP_AT_SINCE_VERSION 1
/**
 * @ingroup iface_plugin_manager_v1
 */
#define PLUGIN_MANAGER_V1_CREATE_PLUGIN_SINCE_VERSION 1
/**
 * @ingroup iface_plugin_manager_v1
 */
#define PLUGIN_MANAGER_V1_MOVE_XEMBED_WINDOW_SINCE_VERSION 1

/** @ingroup iface_plugin_manager_v1 */
static inline void
plugin_manager_v1_set_user_data(struct plugin_manager_v1 *plugin_manager_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) plugin_manager_v1, user_data);
}

/** @ingroup iface_plugin_manager_v1 */
static inline void *
plugin_manager_v1_get_user_data(struct plugin_manager_v1 *plugin_manager_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) plugin_manager_v1);
}

static inline uint32_t
plugin_manager_v1_get_version(struct plugin_manager_v1 *plugin_manager_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) plugin_manager_v1);
}

/**
 * @ingroup iface_plugin_manager_v1
 */
static inline void
plugin_manager_v1_destroy(struct plugin_manager_v1 *plugin_manager_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) plugin_manager_v1,
			 PLUGIN_MANAGER_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) plugin_manager_v1), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_plugin_manager_v1
 *
 * This event will emitted when client send message to server.
 * Such as plugin status interface defined.
 */
static inline void
plugin_manager_v1_request_message(struct plugin_manager_v1 *plugin_manager_v1, const char *plugin_id, const char *item_key, const char *msg)
{
	wl_proxy_marshal_flags((struct wl_proxy *) plugin_manager_v1,
			 PLUGIN_MANAGER_V1_REQUEST_MESSAGE, NULL, wl_proxy_get_version((struct wl_proxy *) plugin_manager_v1), 0, plugin_id, item_key, msg);
}

/**
 * @ingroup iface_plugin_manager_v1
 *
 * This will created a popup window at (x, y) pos relative to ouput.
 */
static inline struct plugin_popup *
plugin_manager_v1_create_popup_at(struct plugin_manager_v1 *plugin_manager_v1, const char *plugin_id, const char *item_key, int32_t type, int32_t x, int32_t y, struct wl_surface *surface)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) plugin_manager_v1,
			 PLUGIN_MANAGER_V1_CREATE_POPUP_AT, &plugin_popup_interface, wl_proxy_get_version((struct wl_proxy *) plugin_manager_v1), 0, plugin_id, item_key, type, x, y, surface, NULL);

	return (struct plugin_popup *) id;
}

/**
 * @ingroup iface_plugin_manager_v1
 */
static inline struct plugin *
plugin_manager_v1_create_plugin(struct plugin_manager_v1 *plugin_manager_v1, const char *plugin_id, const char *item_key, const char *display_name, int32_t plugin_flags, int32_t type, int32_t size_policy, struct wl_surface *surface)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) plugin_manager_v1,
			 PLUGIN_MANAGER_V1_CREATE_PLUGIN, &plugin_interface, wl_proxy_get_version((struct wl_proxy *) plugin_manager_v1), 0, plugin_id, item_key, display_name, plugin_flags, type, size_policy, surface, NULL);

	return (struct plugin *) id;
}

/**
 * @ingroup iface_plugin_manager_v1
 *
 * This requests dde-shell to forward a request to the compositor (treeland) to move a xembed window to position.
 * dde-shell knows the xembed window's relative position, and then can request treeland to move the window to an absolute position based on a relative position.
 */
static inline struct wl_callback *
plugin_manager_v1_move_xembed_window(struct plugin_manager_v1 *plugin_manager_v1, uint32_t xembed_winid, const char *plugin_id, const char *item_key)
{
	struct wl_proxy *callback;

	callback = wl_proxy_marshal_flags((struct wl_proxy *) plugin_manager_v1,
			 PLUGIN_MANAGER_V1_MOVE_XEMBED_WINDOW, &wl_callback_interface, wl_proxy_get_version((struct wl_proxy *) plugin_manager_v1), 0, xembed_winid, plugin_id, item_key, NULL);

	return (struct wl_callback *) callback;
}

/**
 * @ingroup iface_plugin_popup
 * @struct plugin_popup_listener
 */
struct plugin_popup_listener {
	/**
	 */
	void (*close)(void *data,
		      struct plugin_popup *plugin_popup);
	/**
	 */
	void (*geometry)(void *data,
			 struct plugin_popup *plugin_popup,
			 int32_t x,
			 int32_t y,
			 int32_t width,
			 int32_t height);
};

/**
 * @ingroup iface_plugin_popup
 */
static inline int
plugin_popup_add_listener(struct plugin_popup *plugin_popup,
			  const struct plugin_popup_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) plugin_popup,
				     (void (**)(void)) listener, data);
}

#define PLUGIN_POPUP_DESTROY 0
#define PLUGIN_POPUP_SET_POSITION 1
#define PLUGIN_POPUP_SOURCE_SIZE 2

/**
 * @ingroup iface_plugin_popup
 */
#define PLUGIN_POPUP_CLOSE_SINCE_VERSION 1
/**
 * @ingroup iface_plugin_popup
 */
#define PLUGIN_POPUP_GEOMETRY_SINCE_VERSION 1

/**
 * @ingroup iface_plugin_popup
 */
#define PLUGIN_POPUP_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_plugin_popup
 */
#define PLUGIN_POPUP_SET_POSITION_SINCE_VERSION 1
/**
 * @ingroup iface_plugin_popup
 */
#define PLUGIN_POPUP_SOURCE_SIZE_SINCE_VERSION 1

/** @ingroup iface_plugin_popup */
static inline void
plugin_popup_set_user_data(struct plugin_popup *plugin_popup, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) plugin_popup, user_data);
}

/** @ingroup iface_plugin_popup */
static inline void *
plugin_popup_get_user_data(struct plugin_popup *plugin_popup)
{
	return wl_proxy_get_user_data((struct wl_proxy *) plugin_popup);
}

static inline uint32_t
plugin_popup_get_version(struct plugin_popup *plugin_popup)
{
	return wl_proxy_get_version((struct wl_proxy *) plugin_popup);
}

/**
 * @ingroup iface_plugin_popup
 */
static inline void
plugin_popup_destroy(struct plugin_popup *plugin_popup)
{
	wl_proxy_marshal_flags((struct wl_proxy *) plugin_popup,
			 PLUGIN_POPUP_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) plugin_popup), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_plugin_popup
 */
static inline void
plugin_popup_set_position(struct plugin_popup *plugin_popup, int32_t x, int32_t y)
{
	wl_proxy_marshal_flags((struct wl_proxy *) plugin_popup,
			 PLUGIN_POPUP_SET_POSITION, NULL, wl_proxy_get_version((struct wl_proxy *) plugin_popup), 0, x, y);
}

/**
 * @ingroup iface_plugin_popup
 */
static inline void
plugin_popup_source_size(struct plugin_popup *plugin_popup, int32_t width, int32_t height)
{
	wl_proxy_marshal_flags((struct wl_proxy *) plugin_popup,
			 PLUGIN_POPUP_SOURCE_SIZE, NULL, wl_proxy_get_version((struct wl_proxy *) plugin_popup), 0, width, height);
}

/**
 * @ingroup iface_plugin
 * @struct plugin_listener
 */
struct plugin_listener {
	/**
	 */
	void (*close)(void *data,
		      struct plugin *plugin);
	/**
	 */
	void (*geometry)(void *data,
			 struct plugin *plugin,
			 int32_t x,
			 int32_t y,
			 int32_t width,
			 int32_t height);
	/**
	 */
	void (*margin)(void *data,
		       struct plugin *plugin,
		       int32_t spacing);
	/**
	 */
	void (*raw_global_pos)(void *data,
			       struct plugin *plugin,
			       int32_t x,
			       int32_t y);
};

/**
 * @ingroup iface_plugin
 */
static inline int
plugin_add_listener(struct plugin *plugin,
		    const struct plugin_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) plugin,
				     (void (**)(void)) listener, data);
}

#define PLUGIN_DESTROY 0
#define PLUGIN_MOUSE_EVENT 1
#define PLUGIN_DCC_ICON 2
#define PLUGIN_REQUEST_SHUTDOWN 3
#define PLUGIN_SOURCE_SIZE 4
#define PLUGIN_CLOSE_QUICK_PANEL 5

/**
 * @ingroup iface_plugin
 */
#define PLUGIN_CLOSE_SINCE_VERSION 1
/**
 * @ingroup iface_plugin
 */
#define PLUGIN_GEOMETRY_SINCE_VERSION 1
/**
 * @ingroup iface_plugin
 */
#define PLUGIN_MARGIN_SINCE_VERSION 1
/**
 * @ingroup iface_plugin
 */
#define PLUGIN_RAW_GLOBAL_POS_SINCE_VERSION 1

/**
 * @ingroup iface_plugin
 */
#define PLUGIN_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_plugin
 */
#define PLUGIN_MOUSE_EVENT_SINCE_VERSION 1
/**
 * @ingroup iface_plugin
 */
#define PLUGIN_DCC_ICON_SINCE_VERSION 1
/**
 * @ingroup iface_plugin
 */
#define PLUGIN_REQUEST_SHUTDOWN_SINCE_VERSION 1
/**
 * @ingroup iface_plugin
 */
#define PLUGIN_SOURCE_SIZE_SINCE_VERSION 1
/**
 * @ingroup iface_plugin
 */
#define PLUGIN_CLOSE_QUICK_PANEL_SINCE_VERSION 1

/** @ingroup iface_plugin */
static inline void
plugin_set_user_data(struct plugin *plugin, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) plugin, user_data);
}

/** @ingroup iface_plugin */
static inline void *
plugin_get_user_data(struct plugin *plugin)
{
	return wl_proxy_get_user_data((struct wl_proxy *) plugin);
}

static inline uint32_t
plugin_get_version(struct plugin *plugin)
{
	return wl_proxy_get_version((struct wl_proxy *) plugin);
}

/**
 * @ingroup iface_plugin
 */
static inline void
plugin_destroy(struct plugin *plugin)
{
	wl_proxy_marshal_flags((struct wl_proxy *) plugin,
			 PLUGIN_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) plugin), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_plugin
 */
static inline void
plugin_mouse_event(struct plugin *plugin, int32_t type)
{
	wl_proxy_marshal_flags((struct wl_proxy *) plugin,
			 PLUGIN_MOUSE_EVENT, NULL, wl_proxy_get_version((struct wl_proxy *) plugin), 0, type);
}

/**
 * @ingroup iface_plugin
 */
static inline void
plugin_dcc_icon(struct plugin *plugin, const char *type)
{
	wl_proxy_marshal_flags((struct wl_proxy *) plugin,
			 PLUGIN_DCC_ICON, NULL, wl_proxy_get_version((struct wl_proxy *) plugin), 0, type);
}

/**
 * @ingroup iface_plugin
 */
static inline void
plugin_request_shutdown(struct plugin *plugin, const char *type)
{
	wl_proxy_marshal_flags((struct wl_proxy *) plugin,
			 PLUGIN_REQUEST_SHUTDOWN, NULL, wl_proxy_get_version((struct wl_proxy *) plugin), 0, type);
}

/**
 * @ingroup iface_plugin
 */
static inline void
plugin_source_size(struct plugin *plugin, int32_t width, int32_t height)
{
	wl_proxy_marshal_flags((struct wl_proxy *) plugin,
			 PLUGIN_SOURCE_SIZE, NULL, wl_proxy_get_version((struct wl_proxy *) plugin), 0, width, height);
}

/**
 * @ingroup iface_plugin
 */
static inline void
plugin_close_quick_panel(struct plugin *plugin)
{
	wl_proxy_marshal_flags((struct wl_proxy *) plugin,
			 PLUGIN_CLOSE_QUICK_PANEL, NULL, wl_proxy_get_version((struct wl_proxy *) plugin), 0);
}

#ifdef  __cplusplus
}
#endif

#endif
