/* Reference article: Bart Wronski, "Dithering part three – real world 2D quantization dithering"
 *  https://bartwronski.com/2016/10/30/dithering-part-three-real-world-2d-quantization-dithering/
 *  Sample code for the article can be seen at
 *  https://github.com/bartwronski/BlogPostsExtraMaterial/tree/master/DitheringPostSeries .
 *
 *  Blue noise generator is based on https://github.com/bartwronski/BlueNoiseGenerator (my fork
 *  that compiles and works on Linux/GCC: https://github.com/10110111/BlueNoiseGenerator ).
 *
 *  This array is the blue noise taken from the generator output file noise.txt and undergone the
 *  triangular remapping described in the article as the following Wolfram Language function:
 *  remaptri[v_] = Piecewise[{{Sqrt[2*v] - 1, v <= 1/2}, {1 - Sqrt[2 - 2*v], v > 1/2}}];
 */
inline const float blueNoiseTriangleRemapped[64][64]=
{{-0.192223f, 0.011173f, -0.558557f, -0.086661f, -0.446622f, 0.334433f, -0.154990f, -0.348899f, -0.101215f, -0.507318f, -0.329680f, -0.171037f, -0.685126f, -0.091755f, 0.427534f, -0.209334f, 0.029872f, 0.464564f, -0.430528f, 0.068395f, -0.314194f, 0.109951f, -0.173397f, -0.506823f, -0.322793f, 0.524469f, -0.452388f, -0.224615f, 0.073916f, -0.737579f, -0.304295f, 0.100943f, 0.452835f, -0.384768f, 0.128808f, -0.785734f, 0.206559f, -0.048425f, 0.026856f, 0.188002f, -0.553059f, 0.274063f, -0.474229f, -0.066562f, 0.252844f, -0.500427f, 0.157015f, -0.400447f, 0.789181f, 0.084524f, -0.596111f, -0.242457f, -0.096878f, 0.086661f, 0.261390f, -0.142368f, -0.343297f, 0.239883f, 0.120995f, 0.373752f, -0.539072f, -0.145792f, -0.262714f, 0.267366f},
{-0.099315f, 0.174283f, 0.280483f, 0.403305f, 0.640241f, -0.253498f, 0.239561f, 0.113525f, -0.712702f, 0.843730f, 0.233166f, 0.118498f, 0.004282f, 0.824588f, -0.486447f, 0.264372f, 0.146650f, 0.802333f, -0.180220f, 0.244071f, -0.396793f, 0.564684f, 0.218654f, 0.409063f, -0.057968f, 0.968746f, 0.259739f, -0.577206f, -0.106119f, 0.401671f, 0.901166f, -0.595507f, -0.229671f, 0.068919f, 0.695375f, -0.016373f, -0.440041f, -0.168096f, 0.310288f, 0.535378f, 0.107759f, 0.662661f, 0.404534f, 0.110226f, 0.815099f, 0.421593f, -0.851750f, -0.225560f, 0.320633f, -0.082659f, -0.470526f, 0.420749f, 0.210570f, -0.344414f, -0.816425f, 0.519361f, 0.046886f, 0.707647f, -0.724859f, -0.076028f, 0.066038f, 0.628224f, 0.125172f, -0.563005f},
{-0.414459f, 0.716984f, -0.281502f, -0.010186f, -0.118221f, -0.855082f, 0.574902f, -0.473765f, 0.375314f, -0.010679f, 0.478894f, -0.258750f, 0.349650f, -0.351153f, 0.507814f, -0.046886f, -0.311706f, -0.521908f, 0.437865f, -0.664840f, -0.104208f, -0.021101f, -0.746092f, -0.212428f, -0.615946f, 0.151241f, -0.162537f, 0.495079f, 0.185000f, 0.017864f, 0.271042f, 0.167216f, -0.082925f, -0.480302f, 0.338850f, -0.266034f, 0.441789f, 0.836103f, -0.361014f, -0.961722f, -0.131335f, 0.058486f, -0.240525f, -0.700223f, -0.350777f, 0.032140f, -0.031888f, 0.198901f, -0.174875f, 0.044328f, 0.603433f, -0.002567f, -0.412794f, 0.711007f, 0.136410f, -0.053313f, -0.218654f, 0.179029f, -0.498476f, 0.520888f, -0.217717f, -0.391553f, -0.045094f, 0.389149f},
{0.084257f, -0.678982f, 0.132741f, -0.406588f, 0.074707f, 0.223042f, -0.038976f, -0.274736f, 0.284567f, -0.362927f, -0.086928f, -0.734802f, 0.244717f, -0.160208f, 0.070494f, -0.657631f, 0.344042f, 0.077615f, -0.055121f, 0.133586f, 0.318480f, 0.797452f, 0.194039f, 0.019855f, -0.265036f, 0.059524f, -0.344042f, -0.012409f, -0.368317f, -0.189507f, -0.462743f, -0.011914f, 0.551968f, -0.159626f, -0.624303f, 0.223985f, 0.123777f, -0.599146f, -0.077085f, 0.374533f, -0.302192f, -0.581268f, -0.052540f, 0.308520f, -0.127968f, 0.524983f, -0.294535f, -0.617220f, 0.447505f, 0.237637f, -0.751930f, -0.215846f, 0.319915f, -0.252844f, -0.609014f, 0.331139f, -0.414877f, 0.423284f, -0.301842f, -0.042031f, 0.331869f, -0.633516f, 0.236037f, 0.539072f},
{-0.205021f, -0.064732f, 0.350025f, 0.482185f, -0.553606f, -0.201344f, 0.408650f, 0.093100f, -0.167802f, 0.051767f, 0.552513f, -0.523956f, -0.050737f, 0.615946f, -0.397603f, 0.186499f, -0.109129f, -0.213980f, 0.607145f, -0.313482f, -0.483602f, -0.179922f, -0.423708f, 0.367158f, 0.518853f, 0.282862f, 0.701857f, -0.689028f, 0.353416f, 0.647787f, -0.817760f, 0.416548f, -0.373362f, 0.051252f, 0.663386f, -0.063949f, -0.220532f, 0.056932f, 0.257105f, 0.020852f, -0.198292f, 0.219592f, 0.483602f, 0.142084f, -0.527560f, 0.233803f, 0.080266f, 0.773544f, -0.103663f, -0.518853f, 0.175763f, -0.094447f, 0.528595f, 0.028363f, -0.102574f, 0.082925f, 0.584195f, -0.150953f, 0.011420f, 0.104754f, 0.671463f, 0.146936f, -0.250885f, -0.001833f},
{-0.433538f, 0.243425f, -0.149804f, -0.308167f, 0.183802f, 0.723973f, -0.404945f, 0.621067f, -0.614043f, 0.200122f, -0.417805f, 0.164581f, 0.091755f, 0.309580f, -0.231257f, 0.702677f, 0.419906f, -0.860228f, 0.035172f, 0.184401f, 0.461381f, -0.076821f, 0.641601f, 0.120717f, -0.374142f, -0.113250f, -0.475159f, 0.097419f, -0.138391f, 0.063949f, -0.268366f, -0.086126f, 0.285934f, 0.163704f, -0.777899f, 0.459571f, -0.342554f, 0.644337f, -0.412378f, 0.467766f, 0.856777f, -0.424556f, 0.004527f, 0.675200f, -0.318122f, -0.166337f, 0.382786f, -0.485022f, -0.273726f, -0.017864f, 0.626912f, 0.103936f, -0.462289f, 0.205021f, 0.416130f, -0.261721f, -0.489786f, 0.298701f, -0.701039f, 0.254480f, -0.472837f, -0.124614f, -0.723973f, 0.769271f},
{0.056673f, 0.615311f, -0.765076f, 0.526012f, 0.006738f, -0.069706f, -0.977900f, 0.019108f, 0.326409f, -0.123777f, 0.837600f, -0.186199f, -0.289362f, -0.834620f, 0.041776f, -0.018859f, -0.465020f, -0.292116f, 0.257434f, -0.586550f, -0.023349f, -0.251864f, -0.563564f, 0.040248f, -0.715264f, -0.044328f, 0.211808f, 0.559664f, -0.386357f, 0.273726f, 0.152969f, 0.772468f, -0.222100f, 0.011667f, -0.415294f, 0.088266f, 0.341812f, -0.122663f, -0.661938f, 0.115456f, -0.135844f, 0.298353f, -0.268700f, -0.097960f, -0.654083f, 0.505339f, 0.052282f, 0.296962f, 0.020353f, 0.474229f, -0.179326f, -0.315263f, -0.754901f, -0.131897f, 0.741328f, -0.653378f, 0.174579f, -0.113525f, 0.807338f, -0.294881f, -0.065516f, 0.475624f, -0.316691f, 0.399633f},
{-0.487875f, 0.004773f, -0.263045f, 0.119607f, -0.576629f, 0.347401f, -0.198901f, -0.298005f, 0.486447f, -0.349274f, -0.014884f, 0.371417f, 0.548709f, -0.528595f, 0.391954f, -0.128808f, 0.137825f, 0.501896f, -0.083458f, 0.630199f, 0.316333f, 0.161954f, 0.560775f, -0.168683f, 0.317406f, 0.144935f, -0.238278f, 0.411133f, -0.062906f, -0.560219f, -0.305349f, -0.009199f, -0.651271f, 0.491224f, -0.135562f, 0.207483f, -0.508807f, -0.000610f, -0.309227f, 0.214913f, -0.774625f, 0.063688f, -0.513804f, 0.346653f, 0.117114f, -0.032140f, -0.371806f, -0.815099f, 0.116008f, -0.427534f, 0.322433f, -0.058486f, 0.380811f, 0.238278f, -0.411547f, 0.055638f, -0.047912f, 0.392356f, -0.389949f, 0.071283f, 0.315263f, -0.006000f, 0.218029f, 0.140094f},
{-0.051767f, 0.317764f, -0.119052f, 0.213359f, -0.387154f, 0.076028f, 0.579522f, 0.170742f, 0.057450f, -0.687461f, 0.173988f, -0.463198f, 0.024350f, 0.191619f, 0.782342f, -0.382786f, 0.289018f, -0.167216f, -0.519869f, 0.069181f, -0.366772f, -0.763006f, -0.009692f, -0.325684f, 0.430528f, 1., -0.456866f, -0.769271f, 0.041011f, 0.628881f, 0.443541f, 0.231257f, -0.347401f, 0.307109f, 0.676708f, -0.281841f, 0.555250f, 0.135279f, 0.390751f, -0.038214f, 0.558557f, -0.194039f, 0.171626f, -0.058227f, 0.601590f, -0.195252f, 0.236677f, 0.729334f, -0.086393f, 0.180518f, -0.641601f, 0.923444f, 0.104481f, 0.008953f, -0.182606f, -0.291082f, 0.265036f, 0.604667f, -0.232529f, -0.791511f, 0.594301f, -0.442226f, -0.148656f, -0.609639f},
{-0.256448f, 0.742274f, -0.427108f, 0.449276f, 0.669979f, -0.166923f, 0.285250f, -0.593700f, -0.035426f, 0.688244f, -0.201650f, 0.277435f, -0.155279f, -0.048938f, -0.236677f, 0.098502f, -0.631522f, 0.008707f, 0.809890f, -0.276421f, -0.116284f, 0.432676f, 0.234760f, -0.509803f, 0.043561f, -0.083991f, 0.102302f, 0.300444f, -0.324960f, -0.142938f, 0.079735f, -0.495563f, -0.104481f, 0.052540f, -0.544937f, -0.057450f, -0.748023f, -0.176653f, 0.808610f, -0.235717f, -0.431816f, 0.394772f, 0.885166f, -0.764038f, -0.296962f, 0.407824f, -0.492666f, -0.138108f, -0.358344f, 0.551423f, 0.016373f, -0.322073f, -0.208716f, 0.542262f, 0.407000f, -0.735724f, 0.124335f, -0.540664f, 0.095527f, -0.024099f, 0.164289f, -0.313126f, 0.365232f, 0.549251f},
{-0.003057f, 0.241813f, -0.840636f, 0.053829f, -0.275410f, -0.059784f, -0.411132f, 0.446622f, -0.114076f, -0.435265f, 0.485022f, -0.780109f, 0.138958f, 0.370640f, -0.327498f, 0.588326f, 0.312061f, -0.421171f, 0.204100f, 0.357964f, 0.128528f, -0.074443f, 0.780109f, -0.172216f, -0.632186f, -0.267033f, 0.569763f, -0.186799f, 0.182606f, -0.607767f, 0.788026f, -0.035679f, 0.205329f, -0.198597f, 0.391151f, 0.109129f, 0.245364f, 0.345906f, -0.632850f, 0.018361f, 0.272047f, -0.536430f, -0.149517f, 0.027107f, 0.209334f, -0.623654f, 0.069444f, 0.494595f, 0.311351f, 0.122942f, -0.098773f, 0.359487f, -0.423284f, -0.623005f, -0.076556f, 0.790343f, 0.319197f, -0.096067f, -0.182307f, 0.718715f, 0.269368f, -0.042541f, -0.727535f, 0.081595f},
{0.426256f, -0.123220f, -0.341441f, 0.161663f, 0.324599f, -0.728433f, 0.031635f, -0.218342f, 0.267699f, 0.092562f, -0.004527f, -0.394772f, 0.713554f, -0.555799f, 0.017366f, -0.876953f, -0.088802f, -0.257434f, 0.597929f, -0.655498f, -0.452835f, -0.247308f, 0.048168f, 0.466849f, 0.166337f, 0.369478f, -0.468225f, -0.039739f, 0.431386f, 0.008214f, 0.278111f, -0.387552f, 0.555799f, -0.674449f, 0.705981f, -0.396388f, -0.267366f, 0.054862f, -0.101486f, -0.315619f, 0.223671f, 0.090680f, 0.491704f, -0.072598f, 0.308873f, -0.404124f, -0.051509f, -0.176356f, -0.322433f, -0.831693f, -0.484548f, 0.672207f, 0.165166f, 0.291771f, 0.090411f, -0.477023f, 0.010679f, -0.329316f, 0.339959f, -0.483129f, -0.122107f, -0.230622f, 0.785734f, -0.464564f},
{0.120439f, -0.597929f, 0.522419f, -0.144935f, -0.006738f, 0.799877f, 0.193433f, -0.503369f, 0.593099f, -0.277097f, 0.201650f, 0.378842f, -0.061604f, -0.196163f, 0.523443f, 0.112424f, 0.442226f, 0.024600f, -0.144079f, 0.065516f, 0.530152f, 0.310642f, -0.694574f, -0.378449f, -0.032897f, 0.250885f, -0.784597f, 0.619780f, -0.407000f, -0.226191f, -0.839111f, 0.468225f, -0.286618f, 0.159917f, -0.112975f, 0.072072f, 0.587141f, -0.567498f, 0.404945f, 0.620423f, -0.034666f, -0.358725f, -0.594301f, -0.238919f, 0.699410f, 0.133305f, 0.529632f, 0.211499f, -0.007230f, 0.234122f, -0.228720f, 0.068133f, -0.041776f, -0.185599f, -0.320274f, 0.205636f, -0.214913f, 0.460023f, -0.843730f, 0.149517f, 0.389549f, 0.049195f, 0.212428f, -0.300794f},
{0.354550f, -0.028111f, 0.708483f, -0.239883f, -0.626258f, 0.489786f, -0.346653f, 0.337743f, -0.024850f, -0.619780f, -0.133868f, -0.330409f, 0.065777f, 0.224300f, -0.395579f, 0.314194f, -0.591303f, -0.343669f, 0.228720f, -0.223042f, -0.039231f, 0.198292f, -0.290393f, 0.570331f, 0.106665f, -0.134432f, -0.316333f, 0.062125f, 0.303243f, 0.135562f, -0.143223f, 0.058746f, 0.263377f, -0.225245f, -0.016125f, -0.469605f, 0.168390f, -0.044839f, -0.209025f, 0.142938f, -0.874984f, 0.758919f, 0.332601f, 0.047912f, -0.355686f, -0.651972f, -0.218967f, -0.520378f, 0.811179f, 0.414043f, -0.110500f, 0.515817f, -0.717848f, 0.373362f, -0.102302f, 0.568629f, -0.603433f, 0.081063f, -0.068919f, 0.602818f, -0.280822f, -0.437865f, 0.557452f, -0.155568f},
{-0.364847f, 0.157305f, -0.467766f, 0.335167f, 0.170153f, -0.200427f, 0.061084f, -0.098231f, 0.147509f, 0.743223f, 0.422861f, -0.830248f, 0.642283f, -0.256776f, -0.100943f, -0.008707f, 0.179326f, 0.759934f, -0.716984f, 0.411547f, -0.539602f, 0.851750f, 0.075499f, -0.160789f, -0.495079f, 0.871137f, 0.169271f, -0.079470f, -0.531192f, 0.896342f, -0.045606f, -0.333333f, -0.662661f, 0.344414f, 0.833150f, 0.446181f, -0.914407f, 0.293152f, 0.488830f, -0.461381f, -0.264372f, 0.194342f, -0.184101f, -0.095527f, 0.246984f, 0.399227f, -0.094178f, 0.054604f, -0.401671f, 0.287303f, -0.590110f, 0.152681f, -0.378842f, 0.861986f, -0.463653f, 0.042796f, 0.274736f, 0.850111f, -0.163704f, -0.533804f, 0.020104f, 0.264704f, -0.654790f, 0.029117f},
{0.451943f, -0.166044f, 0.068657f, -0.353038f, -0.017366f, -0.498963f, 0.377272f, -0.733883f, -0.165751f, -0.403715f, 0.018859f, 0.122107f, 0.248282f, -0.572610f, 0.572039f, -0.502877f, -0.323876f, -0.099586f, 0.253498f, 0.118775f, -0.133305f, -0.072862f, 0.249257f, -0.926703f, 0.003547f, 0.351153f, -0.280143f, 0.510800f, -0.117944f, 0.406177f, 0.219905f, 0.635521f, -0.441351f, 0.101215f, -0.145220f, -0.367158f, -0.246659f, -0.081595f, 0.050737f, -0.120162f, 0.556900f, 0.000366f, 0.419486f, -0.528077f, 0.617859f, 0.095797f, -0.908880f, 0.572610f, 0.170448f, -0.177246f, -0.331139f, 0.025101f, 0.248607f, -0.022100f, 0.410304f, 0.129650f, -0.353416f, -0.038722f, -0.283544f, 0.130773f, 0.452388f, -0.181114f, -0.081063f, 0.234441f},
{-0.858492f, -0.564124f, 0.605285f, 0.256448f, 0.475159f, -0.139242f, 0.761978f, 0.215535f, 0.497017f, -0.239561f, 0.329316f, -0.473301f, -0.148082f, -0.040502f, 0.385562f, 0.101758f, 0.017118f, 0.548168f, -0.272718f, -0.405766f, 0.566934f, 0.380023f, -0.548709f, -0.218029f, 0.486923f, 0.226823f, -0.601590f, 0.036439f, -0.891733f, -0.354171f, -0.175467f, 0.171331f, -0.066038f, 0.560219f, 0.036185f, 0.247632f, 0.390350f, -0.581852f, 0.683579f, 0.125451f, -0.331869f, -0.719585f, 0.090949f, -0.031635f, -0.339589f, -0.157015f, 0.343669f, -0.062125f, -0.277435f, 0.002812f, 0.362544f, 0.569195f, -0.148943f, -0.260729f, -0.673700f, -0.173988f, 0.518346f, -0.819105f, 0.393563f, 0.270372f, -0.683579f, 0.751930f, -0.340329f, 0.618498f},
{-0.111599f, -0.003302f, -0.253171f, -0.080266f, -0.699410f, 0.127408f, 0.012161f, -0.369477f, -0.045350f, -0.648481f, -0.108581f, 0.453728f, -0.312771f, 0.715264f, 0.179624f, -0.676708f, 0.276759f, -0.174283f, -0.043051f, -0.856777f, 0.044072f, -0.284567f, 0.684351f, 0.115732f, -0.085325f, -0.295921f, 0.678222f, 0.139810f, -0.234440f, 0.335902f, 0.002077f, -0.565808f, -0.222414f, -0.894013f, -0.458668f, -0.189808f, 0.008460f, -0.362544f, 0.213980f, -0.211808f, 0.302192f, 0.493148f, -0.399227f, 0.842175f, 0.166044f, -0.659061f, 0.032645f, -0.536958f, 0.395579f, 0.765076f, -0.796250f, 0.079205f, -0.532235f, 0.599755f, 0.103118f, 0.328224f, -0.469144f, 0.202568f, 0.013151f, -0.387951f, -0.238599f, -0.006984f, 0.192828f, 0.086928f},
{-0.395176f, 0.352284f, 0.190713f, 0.732967f, -0.388350f, -0.215224f, -0.583608f, 0.559110f, 0.339589f, 0.114628f, 0.926703f, -0.002077f, -0.811179f, 0.077085f, -0.250234f, -0.080001f, -0.422015f, 0.647094f, 0.415294f, 0.301492f, -0.486923f, 0.231575f, -0.014141f, -0.450608f, 0.180816f, -0.418225f, -0.013151f, 0.414459f, -0.447063f, 0.105299f, 0.813783f, 0.262052f, 0.379235f, 0.086393f, 0.445740f, 0.831693f, 0.148656f, 0.477958f, -0.941529f, -0.012161f, -0.542262f, 0.182307f, -0.147796f, -0.265369f, 0.279465f, -0.208099f, 0.660496f, 0.108855f, -0.366387f, -0.143508f, -0.425405f, 0.217093f, -0.034919f, -0.402487f, 0.176356f, -0.000366f, -0.278449f, 0.801101f, -0.185899f, 0.610266f, 0.102030f, -0.477490f, -0.135279f, 0.405355f},
{0.554701f, 0.134432f, -0.492185f, 0.060304f, 0.431816f, 0.291427f, -0.091217f, 0.161372f, -0.301492f, 0.033402f, 0.405766f, -0.399633f, 0.200732f, -0.141230f, 0.495563f, 0.327135f, -0.533281f, 0.159336f, 0.005755f, -0.262052f, 0.145506f, 0.517333f, -0.185299f, -0.714407f, 0.442664f, -0.171921f, 0.247957f, -0.096607f, 0.558004f, -0.269368f, -0.711854f, -0.113801f, -0.436563f, -0.044072f, -0.295574f, -0.636191f, -0.164581f, -0.053829f, 0.341070f, -0.126569f, 0.619139f, 0.030879f, -0.071282f, 0.425830f, -0.531713f, 0.485972f, -0.090949f, 0.257763f, 0.015132f, 0.513804f, 0.313838f, -0.233166f, 0.402896f, 0.950583f, -0.074707f, 0.526527f, -0.128248f, -0.541729f, 0.134715f, -0.081329f, 0.496047f, 0.309934f, -0.591901f, -0.282182f},
{-0.194342f, -0.087731f, -0.968746f, -0.033402f, -0.287646f, 0.202262f, 0.664840f, -0.151817f, -0.455071f, -0.663386f, -0.133023f, -0.223356f, 0.290049f, -0.564684f, 0.658345f, 0.042286f, -0.129930f, -0.345906f, 0.770332f, -0.677464f, -0.030375f, -0.126289f, 0.933700f, 0.039739f, 0.293497f, 0.653378f, -0.845301f, -0.514307f, -0.002322f, 0.230622f, 0.037961f, 0.574328f, 0.156436f, 0.503861f, 0.208716f, 0.030124f, 0.541729f, -0.488830f, -0.298353f, 0.078144f, -0.484075f, 0.337006f, -0.732967f, 0.195252f, 0.010926f, 0.143793f, -0.432246f, -0.255791f, -0.588920f, 0.155857f, -0.088534f, -0.307814f, 0.047143f, -0.187400f, -0.580686f, -0.318480f, 0.280143f, -0.029872f, 0.227139f, -0.808610f, -0.297657f, 0.036946f, 0.776803f, 0.245040f},
{-0.012903f, -0.334800f, 0.305349f, 0.607767f, -0.549251f, 0.013893f, -0.760954f, -0.021850f, 0.328588f, 0.182009f, 0.621712f, 0.101486f, 0.460475f, -0.033908f, -0.336270f, -0.743223f, 0.263708f, 0.103391f, -0.091486f, 0.254152f, -0.414043f, 0.300095f, -0.261390f, -0.532758f, -0.320993f, 0.139526f, -0.150378f, 0.088534f, 0.409476f, -0.360632f, -0.547089f, -0.204100f, -0.327861f, -0.108033f, -0.424132f, 0.307814f, -0.264704f, 0.089875f, 0.768215f, 0.174875f, -0.368703f, -0.154412f, 0.752916f, -0.337006f, -0.646403f, -0.134997f, 0.793866f, 0.398009f, -0.017615f, 0.636863f, -0.903669f, -0.517839f, 0.542796f, 0.153258f, 0.363695f, -0.713554f, 0.080001f, 0.444859f, -0.250559f, 0.356444f, -0.439170f, -0.110226f, 0.112699f, -0.682039f},
{0.651271f, 0.064210f, 0.481714f, -0.206559f, -0.105299f, 0.073125f, 0.534853f, -0.224300f, 0.775711f, -0.324599f, -0.090680f, -0.923444f, -0.418645f, 0.031383f, 0.173692f, 0.384768f, -0.202874f, 0.448390f, -0.600366f, -0.222728f, 0.571469f, 0.061604f, 0.404124f, 0.227455f, -0.116837f, 0.543330f, -0.436130f, -0.242135f, 0.804819f, -0.078674f, 0.304295f, 0.078409f, 0.720457f, 0.258092f, -0.889501f, 0.600978f, -0.049452f, 0.240847f, -0.709322f, -0.056931f, 0.534328f, 0.228087f, 0.071020f, -0.191618f, 0.565808f, 0.322073f, 0.054087f, -0.697789f, -0.202568f, 0.232211f, 0.073388f, -0.043561f, 0.281162f, -0.458217f, -0.151241f, 0.006984f, 0.869255f, -0.182009f, -0.614677f, 0.705152f, -0.008460f, 0.271377f, -0.183802f, 0.412378f},
{-0.426256f, -0.566934f, 0.124056f, 0.243748f, -0.398414f, 0.416967f, -0.551968f, 0.277097f, -0.489308f, 0.061344f, 0.385959f, 0.564124f, -0.248932f, -0.172511f, 0.795055f, -0.067085f, -0.444420f, 0.669240f, -0.026354f, 0.324961f, 0.124893f, -0.786877f, -0.075499f, -0.640920f, 0.100400f, -0.041011f, 0.343297f, 0.255463f, -0.647094f, 0.177543f, 0.498476f, -0.649176f, -0.037199f, -0.454175f, 0.021850f, -0.191921f, -0.545474f, 0.461835f, -0.217093f, 0.368317f, -0.573754f, -0.269703f, 0.454623f, -0.017118f, -0.534328f, -0.073388f, -0.314550f, 0.276084f, -0.499938f, -0.105026f, 0.418225f, -0.356824f, 0.680507f, -0.227455f, 0.092831f, 0.437431f, -0.089606f, -0.377664f, 0.209952f, 0.056414f, 0.490265f, -0.393563f, -0.271042f, 0.158755f},
{0.290738f, -0.263708f, -0.027609f, -0.738511f, 0.880988f, -0.242779f, 0.173101f, -0.082393f, 0.129089f, -0.191015f, -0.013398f, -0.602818f, 0.165458f, 0.313482f, 0.072862f, -0.671463f, -0.287303f, 0.041266f, 0.175467f, -0.471450f, -0.279804f, 0.777899f, 0.014884f, -0.317764f, 0.704325f, -0.453728f, 0.012409f, 0.480302f, -0.299050f, 0.009939f, -0.229037f, -0.124335f, 0.191316f, 0.388350f, 0.661216f, 0.136975f, 0.218342f, -0.402896f, -0.107486f, 0.129930f, 0.014141f, -0.093639f, -0.426681f, 0.301143f, 0.106938f, -0.211498f, 0.178732f, 0.537485f, 0.106119f, 0.724859f, -0.176060f, 0.145221f, -0.587141f, 0.233484f, -0.340700f, -0.799877f, 0.176653f, 0.610893f, -0.534853f, -0.143793f, -0.027358f, -0.621712f, 0.612780f, -0.068395f},
{0.820460f, -0.111050f, 0.203180f, 0.372194f, 0.022349f, -0.142653f, 0.345532f, -0.381995f, -0.806075f, 0.639563f, 0.231893f, -0.303944f, -0.032392f, 0.438300f, -0.377272f, 0.531713f, 0.249582f, -0.144649f, -0.570331f, 0.485497f, -0.049709f, -0.158175f, 0.466392f, 0.349274f, -0.130211f, 0.173397f, -0.937492f, -0.140946f, 0.120162f, -0.411962f, 0.355307f, 0.898726f, -0.244717f, -0.373752f, -0.053055f, -0.618498f, 0.054346f, 0.614677f, -0.305700f, 0.261060f, 0.677464f, -0.744176f, 0.189808f, 0.883058f, -0.647787f, 0.415712f, -0.451497f, -0.349650f, 0.021600f, -0.270707f, -0.807338f, 0.325322f, 0.010432f, -0.136410f, 0.507318f, -0.004773f, -0.284908f, 0.323876f, -0.217405f, 0.130492f, 0.298005f, 0.449719f, 0.094987f, -0.749969f},
{0.332235f, -0.365616f, -0.166630f, -0.488352f, -0.300095f, 0.545474f, 0.113250f, 0.748994f, 0.016621f, -0.260069f, 0.348524f, -0.442664f, 0.088802f, -0.111324f, -0.543865f, -0.216469f, 0.129369f, 0.350777f, 0.614043f, -0.351530f, 0.100671f, 0.256776f, -0.470065f, 0.052024f, -0.568063f, 0.590706f, -0.346279f, 0.030627f, 0.668503f, -0.566370f, 0.145792f, -0.447947f, 0.031131f, 0.252190f, -0.107759f, 0.304646f, -0.186499f, -0.028614f, 0.468685f, -0.493148f, -0.119329f, 0.109403f, -0.291426f, -0.161372f, 0.217717f, 0.019606f, 0.698599f, -0.071545f, 0.386357f, -0.510301f, 0.532235f, -0.097689f, -0.407824f, 0.930114f, 0.281842f, -0.439605f, 0.130211f, -0.046630f, 0.492666f, -0.955800f, -0.416130f, -0.248607f, -0.181412f, 0.028865f},
{-0.554153f, 0.096878f, 0.441351f, 0.685903f, 0.072598f, -0.626912f, -0.033655f, -0.478426f, 0.155279f, -0.063167f, 0.501406f, -0.722210f, 0.279126f, 0.748023f, 0.235079f, 0.024850f, -0.092293f, -0.781223f, -0.036439f, 0.199511f, -0.211189f, -0.871137f, -0.248282f, 0.232529f, -0.034161f, -0.206251f, 0.286960f, 0.400040f, -0.229354f, 0.244394f, -0.054862f, 0.467308f, 0.111874f, -0.853406f, 0.527043f, -0.438300f, 0.395176f, -0.756902f, 0.107212f, 0.357583f, -0.375314f, 0.577206f, 0.425405f, -0.039485f, -0.400040f, -0.120717f, -0.873046f, 0.154412f, -0.167509f, 0.251538f, -0.020852f, 0.131897f, 0.435265f, 0.114077f, -0.274399f, -0.736650f, 0.391553f, 0.629540f, -0.359106f, -0.097148f, 0.196163f, 0.384371f, -0.043306f, 0.553606f},
{-0.278788f, 0.224615f, -0.054346f, -0.824588f, 0.295228f, -0.162246f, 0.470988f, -0.223985f, 0.268366f, -0.459119f, -0.184401f, 0.049709f, -0.319915f, -0.139526f, -0.620423f, 0.479363f, -0.279465f, 0.689814f, -0.511299f, 0.432246f, -0.103118f, 0.387951f, 0.714407f, -0.397198f, 0.453281f, -0.621067f, 0.162829f, -0.065254f, -0.701857f, 0.585371f, -0.150666f, -0.616583f, -0.290049f, 0.596111f, -0.172806f, 0.192223f, -0.323154f, 0.712702f, -0.234122f, -0.592500f, -0.020104f, 0.052797f, -0.664112f, 0.172216f, 0.627567f, 0.253825f, 0.476090f, -0.544401f, 0.039993f, 0.636191f, -0.308520f, -0.635521f, -0.204714f, -0.501406f, -0.129369f, 0.038976f, -0.103391f, -0.246984f, 0.071546f, -0.012656f, 0.535904f, -0.590706f, 0.253171f, -0.422438f},
{-0.105845f, 0.638210f, -0.187100f, 0.111599f, -0.350025f, 0.195555f, -0.548168f, 0.363311f, -0.797452f, 0.716123f, -0.087463f, 0.588920f, 0.123499f, 0.341441f, -0.010926f, 0.168977f, -0.451943f, 0.326047f, 0.093639f, -0.362161f, -0.003792f, 0.074179f, -0.153546f, 0.126010f, 0.045094f, -0.106392f, 0.798661f, -0.308873f, 0.094448f, -0.457766f, 0.156725f, 0.359868f, 0.057968f, -0.030627f, -0.556900f, 0.019357f, 0.089606f, 0.326772f, -0.069181f, 0.221786f, -0.197074f, 0.287646f, -0.254152f, -0.513302f, -0.194645f, 0.092293f, -0.367544f, -0.241169f, 0.201038f, -0.429243f, 0.359106f, 0.220845f, 0.691393f, -0.025602f, 0.230940f, 0.587733f, 0.290393f, -0.696983f, 0.863767f, -0.510800f, 0.140946f, -0.119607f, 0.786877f, 0.050995f},
{0.337374f, -0.639563f, -0.321353f, 0.402487f, 0.026354f, 0.596716f, -0.092562f, 0.085592f, -0.006246f, 0.141515f, 0.426682f, -0.251211f, -0.395984f, -0.688244f, 0.606524f, -0.221472f, -0.084524f, 0.237317f, -0.153835f, 0.512801f, -0.629540f, 0.223356f, -0.512801f, 0.590110f, -0.331504f, 0.263045f, -0.437431f, 0.015876f, 0.540133f, -0.029620f, -0.237637f, 0.749969f, -0.408650f, 0.288675f, -0.100671f, 0.685126f, -0.497017f, -0.170448f, 0.126289f, -0.383974f, 0.945866f, 0.369865f, 0.108581f, 0.536958f, -0.052282f, -0.642967f, 0.288332f, -0.029368f, 0.917310f, -0.148369f, -0.704325f, -0.072072f, 0.063427f, -0.354550f, 0.428388f, -0.537485f, 0.104208f, -0.277773f, 0.211189f, 0.314550f, -0.375705f, -0.256119f, -0.748994f, 0.194948f},
{0.529113f, -0.020602f, 0.220532f, -0.526527f, -0.022349f, -0.422861f, 0.955800f, -0.493630f, -0.137825f, -0.352661f, -0.645024f, 0.216158f, -0.049966f, 0.398414f, -0.417386f, 0.074971f, 0.878954f, -0.574328f, 0.041521f, -0.237317f, 0.830248f, -0.339959f, 0.463653f, -0.209642f, -0.025853f, -0.930114f, 0.489308f, 0.342183f, -0.207175f, 0.309227f, -0.802333f, 0.177246f, -0.259409f, 0.536431f, -0.880988f, 0.366772f, -0.307109f, 0.439605f, -0.745132f, 0.496532f, 0.035426f, -0.689814f, -0.357203f, 0.018610f, 0.381995f, 0.665569f, -0.118498f, 0.440914f, 0.154990f, 0.034919f, 0.470065f, -0.232211f, 0.538542f, -0.605285f, 0.160499f, -0.176949f, -0.037453f, -0.420328f, 0.649873f, -0.100400f, 0.096337f, 0.605904f, 0.023849f, -0.156146f},
{0.112975f, -0.392356f, 0.779002f, -0.107212f, 0.455968f, 0.307461f, -0.266699f, 0.243102f, 0.377664f, 0.591901f, 0.066300f, 0.301842f, -0.157885f, 0.162246f, -0.015876f, -0.290738f, 0.447947f, 0.136692f, -0.801101f, -0.069444f, 0.268700f, 0.122385f, -0.665569f, 0.435697f, 0.177840f, 0.060564f, -0.161663f, -0.644337f, 0.133023f, -0.371029f, 0.578362f, -0.122385f, -0.024600f, 0.123220f, -0.425830f, 0.048425f, 0.150378f, -0.116008f, -0.006492f, 0.259409f, -0.454623f, -0.077615f, 0.214602f, -0.146078f, -0.276759f, 0.046118f, -0.385959f, -0.216158f, -0.540133f, -0.328588f, 0.247308f, -0.440914f, 0.122663f, -0.076292f, 0.812477f, -0.306756f, 0.350401f, 0.464108f, 0.007230f, -0.710164f, -0.188904f, 0.383578f, -0.504353f, -0.294189f},
{-0.887312f, 0.361779f, 0.097689f, -0.249257f, -0.711007f, -0.165166f, 0.119052f, -0.605904f, 0.001833f, -0.227771f, -0.085058f, -0.448832f, 0.654790f, -0.821825f, 0.514307f, -0.535904f, -0.193433f, 0.368703f, -0.339220f, 0.634183f, 0.009199f, -0.273390f, -0.159336f, -0.063688f, -0.400855f, 0.623654f, -0.283203f, 0.209025f, -0.134150f, -0.001099f, -0.599755f, 0.271712f, -0.474694f, 0.238919f, -0.137541f, -0.255463f, 0.599146f, -0.606524f, 0.717848f, -0.292806f, -0.188302f, 0.366001f, 0.693776f, -0.575476f, 0.300794f, -0.776803f, 0.360250f, 0.117667f, 0.633516f, -0.136975f, -0.906238f, 0.369090f, -0.115456f, 0.294189f, 0.023349f, -0.793866f, 0.082659f, -0.479363f, 0.148943f, -0.289705f, 0.227771f, 0.470526f, -0.054604f, 0.277773f},
{-0.228404f, -0.096337f, -0.506328f, 0.561888f, 0.060824f, 0.204407f, -0.075235f, 0.502386f, -0.359868f, 0.216781f, 0.434400f, -0.565246f, 0.028111f, -0.271712f, 0.100128f, 0.258421f, -0.087195f, 0.210879f, -0.152105f, 0.473301f, -0.455519f, 0.347775f, 0.021351f, 0.213049f, -0.661216f, 0.319556f, -0.515313f, 0.891733f, 0.480772f, 0.037453f, -0.278111f, 0.673700f, 0.462289f, 0.016125f, 0.422015f, -0.693776f, 0.322793f, 0.183204f, 0.053313f, -0.525497f, 0.566370f, 0.119884f, -0.001588f, -0.213049f, 0.140378f, 0.784597f, -0.125730f, -0.630860f, 0.278449f, -0.029117f, 0.080532f, 0.733883f, -0.380811f, -0.572039f, 0.484075f, -0.120439f, 0.292116f, -0.183204f, 0.562446f, -0.078144f, -0.607145f, -0.338112f, 0.153835f, 0.638886f},
{-0.617858f, 0.458217f, -0.010432f, 0.262383f, -0.383182f, -0.551423f, 0.734802f, -0.850111f, 0.045606f, -0.270037f, 0.858492f, 0.184700f, -0.200122f, 0.419065f, -0.393966f, 0.746092f, -0.026103f, -0.585371f, 0.057709f, -0.703500f, -0.042796f, 0.546550f, -0.348524f, 0.692980f, -0.145506f, 0.006246f, 0.133868f, -0.062646f, -0.485972f, 0.318838f, 0.169565f, -0.157305f, -0.504846f, -0.230940f, 0.840636f, -0.025101f, -0.341812f, -0.209952f, -0.071020f, 0.222100f, -0.140093f, -0.833150f, -0.342926f, 0.500916f, -0.494595f, -0.023599f, 0.229671f, 0.036692f, -0.268033f, 0.547089f, -0.084257f, -0.283885f, 0.229037f, -0.213359f, 0.121273f, -0.335534f, 0.642967f, -0.684351f, 0.053055f, 0.267033f, 0.703500f, -0.457316f, 0.010186f, 0.093369f},
{-0.189205f, 0.212118f, 0.726640f, -0.291771f, -0.055379f, 0.327861f, -0.170742f, -0.046118f, 0.355686f, 0.153546f, -0.658345f, -0.055638f, 0.289705f, 0.000610f, -0.140378f, -0.579522f, 0.497503f, -0.247632f, 0.285592f, 0.168683f, -0.221158f, -0.538014f, 0.073652f, 0.242135f, -0.430099f, 0.540664f, -0.233803f, 0.371029f, -0.147509f, -0.323515f, 0.079470f, -0.783467f, -0.047399f, 0.197987f, 0.354928f, -0.435697f, 0.159626f, 0.533804f, -0.668503f, 0.400855f, 0.032392f, 0.299050f, -0.061864f, 0.187701f, 0.085058f, -0.285250f, -0.384371f, 0.487399f, -0.516827f, 0.357203f, -0.419906f, 0.134150f, 0.427961f, 0.000855f, 0.754901f, -0.502386f, 0.175171f, -0.280483f, 0.430957f, -0.233484f, -0.036185f, -0.140662f, 0.381600f, -0.385562f},
{-0.061344f, 0.361396f, -0.432676f, 0.165751f, -0.212738f, 0.457766f, 0.059005f, -0.433107f, 0.604049f, -0.173692f, -0.481243f, 0.074443f, 0.573754f, -0.933700f, 0.367544f, 0.157885f, 0.039485f, -0.394369f, 0.371806f, 0.706813f, 0.116561f, -0.115180f, 0.339220f, -1., -0.184700f, 0.358725f, -0.345532f, 0.048938f, -0.732054f, 0.471450f, 0.750948f, 0.262714f, 0.039231f, -0.367930f, -0.576052f, -0.154123f, 0.061864f, 0.275073f, -0.260399f, 0.848491f, -0.326409f, -0.471912f, 0.694574f, -0.669979f, -0.171626f, 0.438735f, 0.696178f, -0.067870f, 0.155568f, -0.190411f, -0.612780f, 0.645713f, -0.803572f, -0.158755f, -0.079205f, 0.241491f, 0.027860f, -0.021351f, -0.602203f, 0.199816f, 0.530672f, -0.716123f, 0.937492f, 0.181412f},
{-0.499450f, 0.075235f, -0.795055f, 0.001099f, 0.586550f, -0.628224f, 0.202874f, -0.310642f, 0.276421f, -0.090143f, 0.445299f, -0.196770f, -0.403305f, -0.313838f, -0.072335f, -0.281162f, 0.583022f, -0.060564f, -0.559110f, -0.321712f, 0.434832f, -0.445740f, 0.764038f, 0.193130f, -0.045862f, 0.081329f, -0.577784f, 0.696983f, 0.232847f, -0.104754f, -0.535378f, -0.255135f, 0.444420f, 0.650571f, 0.102846f, -0.073916f, 0.645024f, -0.476556f, -0.022849f, -0.110775f, 0.103663f, 0.421171f, -0.196466f, 0.383974f, 0.014637f, 0.282522f, -0.470988f, -0.823201f, 0.258750f, -0.114904f, 0.077880f, -0.028865f, 0.203487f, -0.354928f, -0.597322f, 0.323154f, 0.523956f, -0.132178f, -0.431386f, 0.096067f, -0.352283f, 0.236357f, 0.020602f, -0.246335f},
{0.583608f, -0.170153f, 0.796250f, -0.089338f, -0.508310f, 0.114352f, -0.102846f, 0.766117f, -0.705981f, 0.078674f, -0.446180f, 0.710164f, 0.230305f, 0.142368f, 0.860228f, 0.316691f, -0.731144f, 0.105845f, -0.174579f, 0.076292f, -0.063427f, -0.221786f, -0.016621f, -0.314906f, -0.557452f, 0.499450f, -0.158465f, 0.164873f, -0.449719f, -0.007722f, 0.321713f, -0.381600f, -0.046374f, -0.193130f, 0.360632f, -0.747056f, 0.210261f, -0.319197f, 0.302542f, 0.151817f, -0.792685f, 0.005018f, -0.408237f, 0.218967f, -0.356065f, -0.103936f, 0.078939f, -0.033150f, 0.550879f, -0.369090f, 0.379629f, -0.273054f, 0.328952f, 0.573182f, 0.150091f, -0.231893f, -0.345159f, 0.792685f, 0.261721f, -0.055896f, 0.406588f, -0.149230f, -0.596716f, 0.436563f},
{0.303593f, 0.207791f, -0.300444f, 0.389949f, 0.266034f, -0.235398f, 0.412794f, -0.465934f, 0.168096f, 0.001588f, 0.381206f, -0.074971f, -0.682808f, -0.130772f, 0.035932f, -0.208408f, -0.404534f, 0.182905f, 0.906238f, 0.323515f, -0.705152f, 0.527560f, 0.274399f, 0.063167f, 0.608390f, 0.112149f, 0.279804f, -0.053571f, -0.219592f, 0.581852f, 0.137258f, 0.023599f, -0.788026f, 0.238599f, -0.317406f, 0.025853f, -0.146650f, 0.423708f, -0.615311f, 0.617220f, -0.227139f, 0.479832f, 0.090143f, 0.678982f, -0.718715f, 0.144364f, -0.285592f, 0.345159f, -0.578942f, 0.017615f, 0.914407f, 0.124614f, -0.666300f, -0.004282f, -0.156436f, 0.387552f, -0.667033f, 0.044583f, -0.286960f, -0.517333f, 0.664112f, 0.047655f, -0.333699f, -0.030124f},
{-0.707647f, -0.117114f, 0.117390f, -0.376096f, 0.046630f, -0.159917f, -0.388750f, -0.043817f, 0.623005f, -0.182905f, -0.292461f, 0.099044f, 0.266699f, 0.597322f, -0.522419f, -0.015132f, 0.456866f, 0.256119f, -0.507814f, -0.013646f, -0.364463f, 0.127688f, -0.619139f, -0.124056f, -0.444859f, -0.289018f, -0.758919f, 0.459119f, -0.315976f, -0.672953f, 0.353038f, -0.169271f, 0.561331f, 0.140662f, 0.454175f, -0.552513f, 0.550335f, 0.083724f, -0.390750f, 0.225561f, -0.065777f, -0.546550f, -0.027860f, -0.131616f, 0.312416f, 0.515313f, -0.161954f, 0.611521f, 0.186199f, -0.244394f, -0.529113f, -0.112424f, -0.371417f, 0.067085f, 0.686681f, -0.389149f, 0.107486f, 0.508807f, 0.330409f, -0.192828f, -0.804819f, 0.296268f, 0.131054f, -0.195555f},
{0.042541f, -0.409890f, 0.519869f, -0.798661f, 0.666300f, 0.472837f, 0.067347f, 0.294535f, -0.945866f, 0.393966f, -0.600977f, 0.510301f, -0.347775f, -0.168977f, 0.304997f, 0.121828f, -0.271377f, -0.078939f, -0.205329f, 0.482657f, 0.286276f, -0.147223f, 0.825986f, 0.420328f, 0.220218f, -0.000122f, 0.816425f, 0.053571f, -0.093908f, 0.099315f, 0.791511f, -0.530152f, -0.398008f, -0.070231f, -0.236997f, -0.420749f, -0.066300f, 0.167509f, -0.272383f, -0.126010f, 0.911600f, 0.338481f, -0.269034f, -0.627567f, 0.181114f, -0.440478f, 0.045862f, -0.759934f, -0.099044f, 0.087731f, 0.655498f, 0.283544f, 0.539602f, -0.093369f, -0.730237f, 0.179922f, -0.068133f, -0.249582f, -0.013893f, 0.185299f, 0.082393f, -0.460475f, 0.490745f, 0.887312f},
{-0.571469f, -0.054087f, 0.226191f, -0.241491f, -0.077880f, -0.523443f, 0.186800f, -0.249908f, -0.126848f, 0.157595f, 0.059265f, -0.020353f, -0.541196f, 0.169859f, -0.771398f, 0.514810f, -0.583022f, 0.723090f, 0.135844f, -0.723090f, 0.080797f, -0.245364f, -0.014389f, -0.550879f, -0.088266f, -0.192525f, 0.324237f, -0.578362f, 0.221472f, -0.342183f, -0.027107f, 0.254807f, 0.043817f, 0.667767f, 0.207175f, 0.062646f, 0.876953f, -0.789181f, 0.299398f, 0.505833f, 0.062906f, -0.353793f, 0.144649f, 0.616583f, -0.210261f, -0.018610f, 0.781223f, 0.273054f, -0.450163f, 0.414877f, -0.177840f, -0.288675f, 0.151529f, -0.430957f, 0.287988f, 0.478426f, -0.521398f, 0.755899f, -0.680507f, -0.108307f, 0.448832f, -0.047142f, -0.243425f, 0.163996f},
{0.351530f, 0.651972f, 0.076821f, 0.409890f, 0.003057f, -0.338850f, 0.725748f, -0.613411f, 0.424132f, -0.369865f, 0.612150f, -0.199511f, 0.347027f, 0.873046f, -0.112149f, 0.005264f, -0.405355f, 0.315619f, -0.284226f, -0.039993f, 0.624303f, -0.326047f, 0.366387f, 0.148082f, 0.517839f, -0.336638f, 0.138391f, -0.472374f, 0.473765f, -0.163121f, -0.612150f, 0.424980f, -0.327135f, -0.134715f, -0.695375f, 0.378449f, -0.194948f, -0.009446f, -0.543330f, -0.214291f, -0.048681f, -0.898726f, 0.443980f, 0.047399f, -0.562446f, 0.338112f, -0.175763f, -0.309934f, 0.007968f, 0.209643f, -0.040248f, -0.920318f, 0.034666f, 0.387154f, -0.279126f, -0.155857f, 0.014389f, 0.236997f, -0.416967f, 0.273390f, 0.682039f, -0.378056f, 0.264040f, -0.095797f},
{-0.201038f, -0.460023f, -0.133586f, -0.598537f, 0.311706f, 0.128248f, -0.085592f, 0.266367f, 0.027358f, -0.505339f, 0.109677f, -0.332235f, -0.058746f, 0.085325f, -0.288332f, 0.374923f, -0.151529f, 0.083191f, 0.516322f, -0.441789f, 0.195859f, -0.585960f, 0.027609f, -0.372973f, -0.773544f, 0.659061f, -0.070757f, -0.267699f, 0.613411f, 0.272718f, 0.087998f, -0.212118f, 0.576052f, 0.160208f, 0.306756f, -0.380417f, 0.544937f, 0.196770f, 0.380417f, 0.125730f, -0.409476f, 0.310996f, -0.127408f, -0.264040f, 0.520378f, 0.183503f, -0.456417f, 0.126569f, 0.554153f, -0.550335f, -0.364078f, 0.512300f, -0.106938f, -0.561888f, 0.681272f, 0.180220f, -0.338481f, 0.413210f, 0.029620f, -0.259080f, -0.570899f, -0.157595f, -0.770332f, 0.509803f},
{-0.360250f, 0.023099f, 0.265701f, -0.282522f, 0.570899f, -0.861986f, -0.225876f, 0.513302f, -0.064993f, 0.763006f, 0.246335f, 0.447063f, -0.679743f, -0.467308f, 0.251211f, 0.654083f, 0.201344f, -0.742274f, -0.089070f, 0.049966f, 0.294881f, -0.162829f, 0.436997f, -0.223671f, 0.283885f, 0.191015f, 0.045350f, -0.002812f, -0.398820f, -0.109403f, 0.172511f, -0.761978f, -0.021600f, -0.514810f, -0.275073f, 0.033908f, -0.041266f, -0.468685f, -0.275747f, 0.477023f, 0.728433f, -0.007968f, -0.460928f, 0.235398f, -0.052024f, -0.950583f, -0.121550f, 0.362927f, -0.246011f, 0.731144f, 0.315976f, 0.084791f, 0.200427f, -0.206867f, -0.023849f, 0.095257f, -0.837600f, -0.060044f, 0.631522f, 0.191921f, 0.108307f, -0.026856f, 0.038214f, 0.215224f},
{0.149230f, -0.755899f, 0.760954f, 0.119329f, -0.210570f, -0.005755f, -0.428388f, 0.188302f, -0.293152f, -0.611521f, -0.187701f, -0.015628f, 0.197379f, 0.499938f, -0.214602f, -0.569195f, 0.013646f, -0.235079f, 0.402079f, -0.628881f, -0.302542f, 0.908880f, -0.052797f, 0.111324f, -0.522931f, -0.124893f, 0.450608f, -0.650571f, 0.803572f, 0.372973f, -0.307461f, 0.455071f, 0.070231f, 0.740386f, -0.099857f, 0.595507f, 0.132460f, -0.828815f, -0.123499f, -0.057190f, 0.057190f, -0.667767f, 0.131616f, 0.977900f, -0.372584f, 0.632850f, -0.003547f, -0.608390f, 0.055896f, -0.092831f, -0.183503f, -0.669240f, 0.941529f, -0.487399f, 0.508310f, -0.410718f, 0.318122f, -0.193736f, -0.538542f, -0.117667f, 0.547628f, 0.330774f, 0.865572f, -0.282862f},
{0.577784f, 0.320993f, -0.116561f, -0.546012f, 0.443102f, 0.284908f, 0.845301f, -0.150091f, 0.417805f, 0.018112f, -0.382391f, 0.602203f, -0.153258f, -0.069969f, 0.035679f, 0.575477f, -0.409063f, 0.139242f, 0.701039f, -0.125172f, 0.193736f, 0.043051f, -0.698599f, 0.364847f, 0.674449f, -0.303593f, -0.443102f, 0.306404f, 0.089070f, -0.047655f, -0.459571f, -0.171331f, 0.190109f, -0.376880f, -0.681272f, -0.178434f, 0.353793f, 0.697790f, 0.286618f, -0.365232f, 0.241169f, -0.197987f, 0.424556f, -0.241813f, 0.011914f, 0.185899f, -0.302892f, 0.533281f, 0.225245f, -0.500916f, 0.260069f, 0.009692f, -0.304997f, 0.392758f, 0.246011f, -0.127128f, 0.834620f, 0.141230f, 0.440041f, -0.306052f, -0.675953f, -0.203180f, -0.490265f, -0.064210f},
{0.099857f, -0.451052f, 0.012656f, -0.304646f, -0.093100f, 0.143223f, -0.482657f, 0.098231f, -0.757908f, 0.331504f, 0.221158f, 0.113801f, -0.729334f, -0.372194f, 0.105026f, -0.293497f, 0.269703f, -0.066823f, -0.524983f, 0.336270f, -0.438735f, 0.494112f, -0.348150f, -0.146936f, 0.022599f, 0.248932f, 0.131335f, -0.205943f, -0.136692f, -0.686681f, 0.334800f, 0.589514f, -0.067347f, 0.321353f, 0.093908f, 0.212738f, -0.407412f, -0.199816f, 0.092024f, -0.527043f, 0.630860f, -0.078409f, -0.479832f, 0.224930f, 0.487875f, -0.652674f, -0.178137f, 0.110775f, 0.408237f, -0.056673f, -0.415712f, 0.591303f, 0.121550f, -0.073652f, -0.706813f, -0.005264f, -0.253825f, -0.410304f, 0.280822f, -0.083191f, 0.098773f, 0.219279f, 0.471912f, -0.636863f},
{-0.108855f, 0.393160f, 0.190411f, 0.656208f, -0.883058f, 0.042031f, 0.553059f, -0.259739f, -0.092024f, 0.700223f, -0.505833f, -0.261060f, 0.344787f, 0.823201f, 0.199206f, 0.401263f, -0.739447f, 0.531192f, -0.164289f, 0.150666f, -0.036946f, -0.252190f, 0.272383f, -0.624954f, 0.457316f, -0.240204f, -0.865572f, 0.497989f, 0.643651f, 0.229988f, 0.015628f, -0.239240f, -0.524469f, 0.504353f, -0.257105f, 0.003302f, 0.433107f, -0.465477f, 0.184101f, -0.011420f, 0.340700f, -0.330774f, 0.059784f, -0.790343f, 0.295921f, -0.060824f, -0.449276f, 0.894013f, 0.026103f, -0.885166f, -0.254480f, 0.346279f, -0.202262f, 0.208099f, -0.443541f, 0.114904f, 0.598537f, 0.022849f, -0.917310f, -0.008214f, 0.682808f, -0.350401f, 0.034161f, -0.243748f},
{0.690603f, -0.389549f, -0.019357f, -0.228087f, 0.222728f, -0.380023f, -0.016870f, 0.255135f, -0.433969f, 0.046374f, 0.481243f, -0.071809f, 0.028614f, -0.117390f, -0.482185f, -0.180816f, -0.040757f, 0.083991f, -0.337743f, 0.429671f, -0.813783f, 0.670720f, 0.094178f, -0.101758f, -0.019606f, 0.649176f, 0.086126f, -0.037707f, -0.416548f, -0.584782f, 0.118221f, 0.819105f, 0.260399f, -0.767164f, -0.102030f, 0.753907f, -0.649873f, -0.122941f, 0.659778f, -0.809890f, -0.163996f, 0.525497f, -0.041521f, 0.115180f, -0.236357f, 0.582436f, 0.142653f, -0.301143f, -0.097419f, 0.176060f, 0.687461f, 0.060044f, -0.638886f, 0.477490f, -0.138675f, 0.397603f, -0.593099f, 0.342926f, -0.160499f, 0.506328f, -0.556349f, 0.354171f, -0.146364f, 0.275747f},
{0.062385f, 0.503369f, -0.678222f, 0.292461f, 0.440478f, -0.164873f, -0.640241f, 0.367930f, 0.143508f, -0.179624f, -0.634183f, 0.187400f, -0.391151f, 0.383182f, -0.660496f, 0.576629f, 0.250559f, 0.744176f, -0.610266f, -0.216781f, 0.029369f, 0.178137f, -0.191316f, 0.333699f, -0.549793f, -0.351907f, 0.278788f, -0.266367f, 0.303944f, -0.044583f, -0.319556f, -0.004037f, -0.413626f, 0.066562f, 0.370253f, -0.379235f, 0.284226f, -0.075763f, 0.064471f, -0.318838f, 0.410718f, 0.178434f, -0.520888f, 0.757908f, -0.366001f, 0.348150f, -0.136127f, 0.521398f, -0.625605f, 0.427108f, -0.163412f, -0.332601f, -0.001344f, -0.392758f, 0.867401f, -0.210879f, 0.148369f, -0.287988f, 0.217405f, -0.376488f, -0.068657f, 0.127128f, -0.768215f, -0.481714f},
{0.163121f, -0.334433f, -0.120995f, -0.478894f, 0.087463f, 0.626258f, -0.073125f, -0.306404f, 0.821825f, -0.050994f, 0.302892f, -0.237957f, 0.521908f, 0.116284f, 0.025351f, -0.270372f, -0.436997f, 0.005509f, 0.376096f, -0.080797f, 0.568063f, -0.357583f, -0.476090f, 0.889501f, 0.197074f, 0.037707f, -0.622358f, -0.138958f, 0.418645f, 0.166923f, 0.593700f, -0.111874f, 0.439170f, 0.171037f, -0.245040f, 0.012903f, 0.132178f, -0.258421f, 0.483129f, 0.159045f, -0.443980f, -0.226507f, -0.132741f, 0.240204f, 0.013398f, -0.725748f, 0.075763f, -0.501896f, 0.265369f, -0.385165f, 0.196466f, 0.096607f, 0.609639f, 0.275410f, -0.070494f, 0.033655f, -0.526012f, 0.067609f, 0.736650f, 0.050223f, -0.203794f, 0.458668f, 0.771398f, -0.050223f},
{0.386755f, -0.080532f, 0.188603f, 0.730237f, -0.244071f, 0.033150f, 0.203794f, 0.465477f, -0.692979f, -0.356444f, -0.014637f, 0.675953f, -0.812477f, -0.156725f, 0.352661f, -0.067609f, 0.158465f, -0.185000f, 0.198597f, -0.496532f, 0.255791f, 0.070757f, 0.398820f, -0.245687f, -0.084791f, 0.378056f, 0.516827f, 0.920318f, -0.391954f, -0.190713f, -0.901166f, -0.518346f, -0.312416f, -0.042285f, -0.643651f, 0.417386f, -0.491224f, 0.732054f, -0.610893f, 0.308167f, -0.057709f, 0.656919f, -0.670720f, 0.469605f, -0.082126f, 0.192525f, 0.433538f, -0.207483f, 0.034413f, -0.036692f, 0.549793f, -0.825986f, -0.232847f, -0.466849f, 0.206251f, -0.324237f, 0.436130f, 0.252517f, -0.836103f, -0.475624f, 0.289362f, 0.001344f, -0.344787f, -0.220218f},
{0.037199f, 0.580686f, -0.299398f, -0.848491f, 0.340329f, -0.370253f, -0.511799f, -0.169859f, 0.065254f, 0.543865f, 0.138675f, -0.497989f, 0.240525f, -0.325322f, 0.828815f, -0.515817f, 0.297310f, -0.685903f, -0.310288f, 0.500427f, -0.114352f, -0.752916f, -0.028363f, -0.574902f, 0.127968f, -0.303243f, -0.750948f, -0.077350f, 0.049452f, 0.134997f, 0.270707f, 0.430099f, 0.194645f, 0.903669f, 0.528077f, -0.188002f, 0.216469f, -0.007476f, -0.317048f, -0.121272f, 0.067871f, 0.372584f, 0.026605f, -0.297310f, -0.555250f, -0.231575f, -0.413210f, 0.817760f, -0.141515f, 0.335534f, -0.594904f, -0.098502f, 0.364463f, 0.156147f, -0.634851f, 0.511299f, -0.230305f, -0.015380f, -0.115732f, 0.563564f, -0.258092f, 0.189205f, -0.604049f, 0.295574f},
{-0.672207f, -0.477958f, 0.007476f, 0.250234f, -0.142084f, -0.025351f, 0.411962f, -0.062385f, 0.297657f, -0.254807f, 0.356824f, -0.190109f, 0.030375f, -0.106665f, 0.089338f, 0.407412f, -0.131053f, 0.711854f, 0.147796f, 0.016870f, -0.205636f, 0.737579f, 0.158175f, 0.541196f, -0.178732f, 0.004037f, 0.204714f, 0.314906f, -0.530672f, 0.648481f, -0.374923f, -0.079735f, -0.252517f, -0.137258f, 0.102574f, -0.361779f, -0.090411f, 0.546012f, 0.116837f, -0.863767f, -0.234760f, -0.480772f, 0.246659f, 0.783467f, 0.325684f, 0.038722f, 0.502877f, 0.166630f, -0.587733f, 0.066823f, -0.328952f, 0.498963f, -0.204407f, 0.624954f, -0.109677f, 0.007722f, 0.722210f, -0.573182f, 0.293843f, -0.049195f, 0.375705f, -0.461835f, 0.094717f, 0.692185f},
{-0.048168f, 0.413626f, -0.197683f, 0.465934f, 0.048681f, -0.582436f, 0.138108f, 0.853406f, -0.827395f, -0.393160f, 0.071809f, 0.433969f, -0.645713f, 0.625605f, -0.361396f, -0.589514f, 0.044839f, -0.030879f, 0.356065f, -0.424980f, -0.568629f, 0.394369f, -0.311351f, 0.336638f, -0.429671f, 0.667033f, -0.363695f, -0.199206f, -0.026605f, -0.293843f, 0.009446f, 0.091217f, -0.580104f, 0.330044f, 0.024099f, -0.878954f, 0.282182f, -0.503861f, 0.362161f, 0.161081f, 0.609014f, 0.188904f, -0.341070f, -0.011173f, -0.195859f, 0.110500f, -0.741328f, -0.059005f, -0.236037f, 0.634851f, 0.136127f, 0.031888f, -0.024350f, -0.379629f, 0.105572f, -0.702677f, 0.259080f, 0.152393f, -0.159045f, -0.370640f, 0.015380f, 0.580104f, -0.286276f, -0.168390f},
{0.226507f, -0.337374f, 0.091486f, -0.428815f, 0.652674f, 0.152105f, -0.247957f, -0.447505f, 0.245688f, -0.105572f, 0.735725f, -0.326772f, -0.034413f, 0.163412f, 0.270037f, 0.538014f, -0.200732f, -0.846888f, -0.296615f, 0.637536f, 0.215846f, -0.059265f, 0.038468f, -0.842175f, -0.125451f, 0.106392f, 0.374142f, 0.544401f, -0.630199f, 0.235718f, 0.476556f, -0.434400f, 0.228404f, 0.465020f, -0.421593f, 0.622358f, -0.152681f, 0.058227f, -0.359487f, -0.188603f, 0.472374f, -0.094717f, -0.656208f, -0.262383f, 0.567498f, -0.031131f, 0.268033f, -0.332967f, 0.376880f, 0.208408f, -0.427961f, 0.305700f, -0.782342f, 0.222414f, -0.240847f, 0.456417f, -0.299747f, -0.485497f, 0.055379f, 0.484548f, -0.726640f, -0.129649f, 0.451497f, 0.006000f},
{-0.775711f, 0.146364f, 0.594904f, -0.059524f, -0.820460f, -0.152969f, 0.506823f, 0.043306f, -0.038468f, 0.334066f, -0.692185f, 0.205943f, 0.504846f, -0.464108f, -0.085859f, -0.310996f, 0.087195f, 0.185599f, -0.094987f, 0.099586f, -0.141799f, 0.292806f, -0.496047f, 0.747056f, -0.031383f, 0.237957f, -0.466391f, -0.119884f, 0.085859f, 0.332967f, -0.161080f, 0.689028f, -0.720457f, 0.137541f, -0.032645f, -0.257762f, 0.396388f, -0.019855f, 0.745132f, -0.542796f, -0.035172f, 0.064732f, 0.376488f, 0.162537f, -0.455968f, 0.201956f, -0.130492f, 0.756902f, -0.512300f, -0.165458f, -0.095257f, 0.460928f, -0.519361f, 0.767164f, -0.132460f, 0.585960f, -0.037961f, 0.327498f, -0.229988f, 0.855082f, 0.225876f, 0.076556f, -0.558004f, 0.333333f},
{0.774625f, -0.118775f, -0.569763f, -0.251537f, 0.283203f, 0.006492f, 0.351907f, -0.296268f, 0.679743f, -0.494112f, 0.108033f, -0.263377f, -0.152393f, 0.077350f, 0.388750f, -0.529632f, 0.961722f, 0.291082f, -0.638210f, 0.451052f, -0.312060f, -0.181710f, 0.396793f, 0.083458f, -0.561331f, -0.243102f, 0.022100f, 0.839111f, -0.779002f, -0.274063f, -0.490744f, 0.055121f, -0.100128f, -0.215535f, 0.827395f, -0.559664f, 0.172806f, -0.696178f, 0.239240f, -0.309580f, 0.296615f, -0.753907f, -0.386755f, 0.738511f, -0.061084f, -0.637536f, 0.450163f, -0.220845f, 0.056155f, -0.604667f, 0.672953f, 0.097960f, -0.328224f, -0.056155f, 0.269034f, -0.381206f, 0.189507f, -0.642283f, 0.397198f, -0.056414f, -0.401263f, 0.400447f, -0.298701f, -0.197379f},
{-0.509305f, 0.403715f, 0.317048f, 0.032897f, 0.187100f, -0.406177f, -0.554701f, 0.141799f, -0.089875f, -0.357964f, 0.422438f, -0.050480f, 0.721332f, -0.772468f, -0.005509f, -0.179029f, 0.365616f, -0.035932f, -0.390350f, 0.709322f, -0.008953f, -0.419065f, 0.167802f, 0.493630f, -0.334066f, 0.581268f, 0.320274f, 0.154701f, -0.083724f, 0.532758f, -0.023099f, 0.176949f, 0.509305f, -0.335902f, 0.249908f, 0.051509f, -0.121828f, 0.463198f, -0.081860f, 0.082127f, -0.203487f, 0.385165f, 0.002322f, -0.180518f, 0.306052f, 0.040757f, -0.448390f, 0.146078f, 0.281502f, 0.429243f, 0.003792f, 0.229354f, -0.276084f, 0.171921f, 0.040502f, -0.869255f, 0.072335f, -0.127688f, 0.154123f, -0.497503f, -0.169565f, 0.181710f, 0.565246f, -0.064471f},
{-0.018112f, 0.160789f, -0.175171f, -0.335167f, 0.474694f, 0.846888f, -0.207791f, -0.675200f, 0.584782f, 0.299747f, -0.219905f, -0.560775f, 0.147223f, 0.342554f, -0.295228f, 0.600366f, 0.214291f, -0.272047f, 0.149804f, 0.025602f, -0.584195f, 0.242779f, -0.867401f, -0.219279f, -0.051252f, -0.708483f, -0.144364f, -0.347027f, -0.547628f, 0.213669f, 0.313126f, -0.453281f, -0.659778f, -0.005018f, 0.395984f, -0.491704f, -0.320633f, 0.661938f, 0.144079f, -0.445299f, 0.806075f, 0.492185f, 0.206867f, -0.691393f, 0.578942f, -0.330044f, 0.646403f, -0.074179f, -0.766117f, -0.129088f, -0.419486f, -0.173101f, -0.690603f, 0.488353f, -0.213669f, 0.632186f, -0.434832f, 0.462743f, 0.719585f, 0.064993f, -0.911600f, -0.011667f, -0.363311f, 0.111050f},
{0.469144f, -0.402079f, 0.657631f, 0.117944f, -0.740386f, -0.019108f, 0.069969f, 0.455519f, 0.197683f, 0.000122f, 0.069706f, 0.563005f, 0.242457f, -0.383578f, 0.097148f, -0.588326f, -0.060304f, -0.896342f, -0.128528f, 0.522931f, 0.358344f, -0.109951f, 0.739447f, 0.050480f, 0.312771f, 0.126848f, -0.000855f, 0.382391f, 0.640921f, 0.002567f, -0.177543f, 0.592500f, -0.087998f, 0.260730f, -0.154701f, 0.556349f, -0.201955f, 0.364078f, -0.656919f, -0.265701f, -0.112699f, -0.018361f, -0.355307f, -0.224930f, 0.081861f, -0.139810f, 0.361014f, 0.021101f, -0.285934f, 0.511799f, 0.150954f, 0.348899f, 0.874984f, -0.022599f, -0.516322f, 0.329680f, -0.009939f, -0.226823f, -0.374533f, -0.114628f, 0.251864f, 0.428815f, 0.727535f, -0.721332f}};
