/* Generated by wayland-scanner 1.24.0 */

#ifndef COSMIC_TOPLEVEL_MANAGEMENT_UNSTABLE_V1_CLIENT_PROTOCOL_H
#define COSMIC_TOPLEVEL_MANAGEMENT_UNSTABLE_V1_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_cosmic_toplevel_management_unstable_v1 The cosmic_toplevel_management_unstable_v1 protocol
 * @section page_ifaces_cosmic_toplevel_management_unstable_v1 Interfaces
 * - @subpage page_iface_zcosmic_toplevel_manager_v1 - control open apps
 * @section page_copyright_cosmic_toplevel_management_unstable_v1 Copyright
 * <pre>
 *
 * Copyright © 2018 Ilia Bozhinov
 * Copyright © 2020 Isaac Freund
 * Copyright © 2022 wb9688
 * Copyright © 2024 Victoria Brekenfeld
 *
 * Permission to use, copy, modify, distribute, and sell this
 * software and its documentation for any purpose is hereby granted
 * without fee, provided that the above copyright notice appear in
 * all copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the name of
 * the copyright holders not be used in advertising or publicity
 * pertaining to distribution of the software without specific,
 * written prior permission.  The copyright holders make no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.
 *
 * THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
 * THIS SOFTWARE.
 * </pre>
 */
struct ext_workspace_handle_v1;
struct wl_output;
struct wl_seat;
struct wl_surface;
struct zcosmic_toplevel_handle_v1;
struct zcosmic_toplevel_manager_v1;
struct zcosmic_workspace_handle_v1;

#ifndef ZCOSMIC_TOPLEVEL_MANAGER_V1_INTERFACE
#define ZCOSMIC_TOPLEVEL_MANAGER_V1_INTERFACE
/**
 * @page page_iface_zcosmic_toplevel_manager_v1 zcosmic_toplevel_manager_v1
 * @section page_iface_zcosmic_toplevel_manager_v1_desc Description
 *
 * This protocol allows clients such as a taskbar to request the compositor
 * to preform typical actions on open toplevels. The compositor is in all
 * cases free to ignore the request.
 * @section page_iface_zcosmic_toplevel_manager_v1_api API
 * See @ref iface_zcosmic_toplevel_manager_v1.
 */
/**
 * @defgroup iface_zcosmic_toplevel_manager_v1 The zcosmic_toplevel_manager_v1 interface
 *
 * This protocol allows clients such as a taskbar to request the compositor
 * to preform typical actions on open toplevels. The compositor is in all
 * cases free to ignore the request.
 */
extern const struct wl_interface zcosmic_toplevel_manager_v1_interface;
#endif

#ifndef ZCOSMIC_TOPLEVEL_MANAGER_V1_ZCOSMIC_TOPLELEVEL_MANAGEMENT_CAPABILITIES_V1_ENUM
#define ZCOSMIC_TOPLEVEL_MANAGER_V1_ZCOSMIC_TOPLELEVEL_MANAGEMENT_CAPABILITIES_V1_ENUM
enum zcosmic_toplevel_manager_v1_zcosmic_toplelevel_management_capabilities_v1 {
	/**
	 * close request is available
	 */
	ZCOSMIC_TOPLEVEL_MANAGER_V1_ZCOSMIC_TOPLELEVEL_MANAGEMENT_CAPABILITIES_V1_CLOSE = 1,
	/**
	 * activate request is available
	 */
	ZCOSMIC_TOPLEVEL_MANAGER_V1_ZCOSMIC_TOPLELEVEL_MANAGEMENT_CAPABILITIES_V1_ACTIVATE = 2,
	/**
	 * set_maximized and unset_maximized requests are available
	 */
	ZCOSMIC_TOPLEVEL_MANAGER_V1_ZCOSMIC_TOPLELEVEL_MANAGEMENT_CAPABILITIES_V1_MAXIMIZE = 3,
	/**
	 * set_minimized and unset_minimized requests are available
	 */
	ZCOSMIC_TOPLEVEL_MANAGER_V1_ZCOSMIC_TOPLELEVEL_MANAGEMENT_CAPABILITIES_V1_MINIMIZE = 4,
	/**
	 * set_fullscreen and unset_fullscreen requests are available
	 */
	ZCOSMIC_TOPLEVEL_MANAGER_V1_ZCOSMIC_TOPLELEVEL_MANAGEMENT_CAPABILITIES_V1_FULLSCREEN = 5,
	/**
	 * move_to_workspace request is available
	 * @since 2
	 */
	ZCOSMIC_TOPLEVEL_MANAGER_V1_ZCOSMIC_TOPLELEVEL_MANAGEMENT_CAPABILITIES_V1_MOVE_TO_WORKSPACE = 6,
	/**
	 * set_sticky and unset_sticky requests are available
	 * @since 3
	 */
	ZCOSMIC_TOPLEVEL_MANAGER_V1_ZCOSMIC_TOPLELEVEL_MANAGEMENT_CAPABILITIES_V1_STICKY = 7,
	/**
	 * move_to_ext_workspace request is available
	 * @since 4
	 */
	ZCOSMIC_TOPLEVEL_MANAGER_V1_ZCOSMIC_TOPLELEVEL_MANAGEMENT_CAPABILITIES_V1_MOVE_TO_EXT_WORKSPACE = 8,
};
/**
 * @ingroup iface_zcosmic_toplevel_manager_v1
 */
#define ZCOSMIC_TOPLEVEL_MANAGER_V1_ZCOSMIC_TOPLELEVEL_MANAGEMENT_CAPABILITIES_V1_MOVE_TO_WORKSPACE_SINCE_VERSION 2
/**
 * @ingroup iface_zcosmic_toplevel_manager_v1
 */
#define ZCOSMIC_TOPLEVEL_MANAGER_V1_ZCOSMIC_TOPLELEVEL_MANAGEMENT_CAPABILITIES_V1_STICKY_SINCE_VERSION 3
/**
 * @ingroup iface_zcosmic_toplevel_manager_v1
 */
#define ZCOSMIC_TOPLEVEL_MANAGER_V1_ZCOSMIC_TOPLELEVEL_MANAGEMENT_CAPABILITIES_V1_MOVE_TO_EXT_WORKSPACE_SINCE_VERSION 4
#endif /* ZCOSMIC_TOPLEVEL_MANAGER_V1_ZCOSMIC_TOPLELEVEL_MANAGEMENT_CAPABILITIES_V1_ENUM */

#ifndef ZCOSMIC_TOPLEVEL_MANAGER_V1_ERROR_ENUM
#define ZCOSMIC_TOPLEVEL_MANAGER_V1_ERROR_ENUM
enum zcosmic_toplevel_manager_v1_error {
	/**
	 * the provided rectangle is invalid
	 */
	ZCOSMIC_TOPLEVEL_MANAGER_V1_ERROR_INVALID_RECTANGLE = 0,
};
#endif /* ZCOSMIC_TOPLEVEL_MANAGER_V1_ERROR_ENUM */

/**
 * @ingroup iface_zcosmic_toplevel_manager_v1
 * @struct zcosmic_toplevel_manager_v1_listener
 */
struct zcosmic_toplevel_manager_v1_listener {
	/**
	 * compositor capabilities
	 *
	 * This event advertises the capabilities supported by the
	 * compositor. If a capability isn't supported, clients should hide
	 * or disable the UI elements that expose this functionality. For
	 * instance, if the compositor doesn't advertise support for
	 * closing toplevels, a button triggering the close request should
	 * not be displayed.
	 *
	 * The compositor will ignore requests it doesn't support. For
	 * instance, a compositor which doesn't advertise support for
	 * closing toplevels will ignore close requests.
	 *
	 * Compositors must send this event once after creation of an
	 * zcosmic_toplevel_manager_v1 . When the capabilities change,
	 * compositors must send this event again.
	 *
	 * The capabilities are sent as an array of 32-bit unsigned
	 * integers in native endianness.
	 * @param capabilities array of 32-bit capabilities
	 */
	void (*capabilities)(void *data,
			     struct zcosmic_toplevel_manager_v1 *zcosmic_toplevel_manager_v1,
			     struct wl_array *capabilities);
};

/**
 * @ingroup iface_zcosmic_toplevel_manager_v1
 */
static inline int
zcosmic_toplevel_manager_v1_add_listener(struct zcosmic_toplevel_manager_v1 *zcosmic_toplevel_manager_v1,
					 const struct zcosmic_toplevel_manager_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) zcosmic_toplevel_manager_v1,
				     (void (**)(void)) listener, data);
}

#define ZCOSMIC_TOPLEVEL_MANAGER_V1_DESTROY 0
#define ZCOSMIC_TOPLEVEL_MANAGER_V1_CLOSE 1
#define ZCOSMIC_TOPLEVEL_MANAGER_V1_ACTIVATE 2
#define ZCOSMIC_TOPLEVEL_MANAGER_V1_SET_MAXIMIZED 3
#define ZCOSMIC_TOPLEVEL_MANAGER_V1_UNSET_MAXIMIZED 4
#define ZCOSMIC_TOPLEVEL_MANAGER_V1_SET_MINIMIZED 5
#define ZCOSMIC_TOPLEVEL_MANAGER_V1_UNSET_MINIMIZED 6
#define ZCOSMIC_TOPLEVEL_MANAGER_V1_SET_FULLSCREEN 7
#define ZCOSMIC_TOPLEVEL_MANAGER_V1_UNSET_FULLSCREEN 8
#define ZCOSMIC_TOPLEVEL_MANAGER_V1_SET_RECTANGLE 9
#define ZCOSMIC_TOPLEVEL_MANAGER_V1_MOVE_TO_WORKSPACE 10
#define ZCOSMIC_TOPLEVEL_MANAGER_V1_SET_STICKY 11
#define ZCOSMIC_TOPLEVEL_MANAGER_V1_UNSET_STICKY 12
#define ZCOSMIC_TOPLEVEL_MANAGER_V1_MOVE_TO_EXT_WORKSPACE 13

/**
 * @ingroup iface_zcosmic_toplevel_manager_v1
 */
#define ZCOSMIC_TOPLEVEL_MANAGER_V1_CAPABILITIES_SINCE_VERSION 1

/**
 * @ingroup iface_zcosmic_toplevel_manager_v1
 */
#define ZCOSMIC_TOPLEVEL_MANAGER_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_zcosmic_toplevel_manager_v1
 */
#define ZCOSMIC_TOPLEVEL_MANAGER_V1_CLOSE_SINCE_VERSION 1
/**
 * @ingroup iface_zcosmic_toplevel_manager_v1
 */
#define ZCOSMIC_TOPLEVEL_MANAGER_V1_ACTIVATE_SINCE_VERSION 1
/**
 * @ingroup iface_zcosmic_toplevel_manager_v1
 */
#define ZCOSMIC_TOPLEVEL_MANAGER_V1_SET_MAXIMIZED_SINCE_VERSION 1
/**
 * @ingroup iface_zcosmic_toplevel_manager_v1
 */
#define ZCOSMIC_TOPLEVEL_MANAGER_V1_UNSET_MAXIMIZED_SINCE_VERSION 1
/**
 * @ingroup iface_zcosmic_toplevel_manager_v1
 */
#define ZCOSMIC_TOPLEVEL_MANAGER_V1_SET_MINIMIZED_SINCE_VERSION 1
/**
 * @ingroup iface_zcosmic_toplevel_manager_v1
 */
#define ZCOSMIC_TOPLEVEL_MANAGER_V1_UNSET_MINIMIZED_SINCE_VERSION 1
/**
 * @ingroup iface_zcosmic_toplevel_manager_v1
 */
#define ZCOSMIC_TOPLEVEL_MANAGER_V1_SET_FULLSCREEN_SINCE_VERSION 1
/**
 * @ingroup iface_zcosmic_toplevel_manager_v1
 */
#define ZCOSMIC_TOPLEVEL_MANAGER_V1_UNSET_FULLSCREEN_SINCE_VERSION 1
/**
 * @ingroup iface_zcosmic_toplevel_manager_v1
 */
#define ZCOSMIC_TOPLEVEL_MANAGER_V1_SET_RECTANGLE_SINCE_VERSION 1
/**
 * @ingroup iface_zcosmic_toplevel_manager_v1
 */
#define ZCOSMIC_TOPLEVEL_MANAGER_V1_MOVE_TO_WORKSPACE_SINCE_VERSION 2
/**
 * @ingroup iface_zcosmic_toplevel_manager_v1
 */
#define ZCOSMIC_TOPLEVEL_MANAGER_V1_SET_STICKY_SINCE_VERSION 3
/**
 * @ingroup iface_zcosmic_toplevel_manager_v1
 */
#define ZCOSMIC_TOPLEVEL_MANAGER_V1_UNSET_STICKY_SINCE_VERSION 3
/**
 * @ingroup iface_zcosmic_toplevel_manager_v1
 */
#define ZCOSMIC_TOPLEVEL_MANAGER_V1_MOVE_TO_EXT_WORKSPACE_SINCE_VERSION 4

/** @ingroup iface_zcosmic_toplevel_manager_v1 */
static inline void
zcosmic_toplevel_manager_v1_set_user_data(struct zcosmic_toplevel_manager_v1 *zcosmic_toplevel_manager_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) zcosmic_toplevel_manager_v1, user_data);
}

/** @ingroup iface_zcosmic_toplevel_manager_v1 */
static inline void *
zcosmic_toplevel_manager_v1_get_user_data(struct zcosmic_toplevel_manager_v1 *zcosmic_toplevel_manager_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) zcosmic_toplevel_manager_v1);
}

static inline uint32_t
zcosmic_toplevel_manager_v1_get_version(struct zcosmic_toplevel_manager_v1 *zcosmic_toplevel_manager_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) zcosmic_toplevel_manager_v1);
}

/**
 * @ingroup iface_zcosmic_toplevel_manager_v1
 *
 * This request indicates that the client has finished using the
 * zcosmic_toplevel_manager_v1 object and that it can be safely
 * destroyed.
 */
static inline void
zcosmic_toplevel_manager_v1_destroy(struct zcosmic_toplevel_manager_v1 *zcosmic_toplevel_manager_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zcosmic_toplevel_manager_v1,
			 ZCOSMIC_TOPLEVEL_MANAGER_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) zcosmic_toplevel_manager_v1), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_zcosmic_toplevel_manager_v1
 *
 * If the compositor honors this request, the
 * zcosmic_toplevel_handle_v1.closed event will be sent.
 */
static inline void
zcosmic_toplevel_manager_v1_close(struct zcosmic_toplevel_manager_v1 *zcosmic_toplevel_manager_v1, struct zcosmic_toplevel_handle_v1 *toplevel)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zcosmic_toplevel_manager_v1,
			 ZCOSMIC_TOPLEVEL_MANAGER_V1_CLOSE, NULL, wl_proxy_get_version((struct wl_proxy *) zcosmic_toplevel_manager_v1), 0, toplevel);
}

/**
 * @ingroup iface_zcosmic_toplevel_manager_v1
 *
 * If the compositor honors this request, the
 * zcosmic_toplevel_handle_v1.state event will be sent.
 */
static inline void
zcosmic_toplevel_manager_v1_activate(struct zcosmic_toplevel_manager_v1 *zcosmic_toplevel_manager_v1, struct zcosmic_toplevel_handle_v1 *toplevel, struct wl_seat *seat)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zcosmic_toplevel_manager_v1,
			 ZCOSMIC_TOPLEVEL_MANAGER_V1_ACTIVATE, NULL, wl_proxy_get_version((struct wl_proxy *) zcosmic_toplevel_manager_v1), 0, toplevel, seat);
}

/**
 * @ingroup iface_zcosmic_toplevel_manager_v1
 *
 * If the compositor honors this request, the
 * zcosmic_toplevel_handle_v1.state event will be sent.
 */
static inline void
zcosmic_toplevel_manager_v1_set_maximized(struct zcosmic_toplevel_manager_v1 *zcosmic_toplevel_manager_v1, struct zcosmic_toplevel_handle_v1 *toplevel)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zcosmic_toplevel_manager_v1,
			 ZCOSMIC_TOPLEVEL_MANAGER_V1_SET_MAXIMIZED, NULL, wl_proxy_get_version((struct wl_proxy *) zcosmic_toplevel_manager_v1), 0, toplevel);
}

/**
 * @ingroup iface_zcosmic_toplevel_manager_v1
 *
 * If the compositor honors this request, the
 * zcosmic_toplevel_handle_v1.state event will be sent.
 */
static inline void
zcosmic_toplevel_manager_v1_unset_maximized(struct zcosmic_toplevel_manager_v1 *zcosmic_toplevel_manager_v1, struct zcosmic_toplevel_handle_v1 *toplevel)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zcosmic_toplevel_manager_v1,
			 ZCOSMIC_TOPLEVEL_MANAGER_V1_UNSET_MAXIMIZED, NULL, wl_proxy_get_version((struct wl_proxy *) zcosmic_toplevel_manager_v1), 0, toplevel);
}

/**
 * @ingroup iface_zcosmic_toplevel_manager_v1
 *
 * If the compositor honors this request, the
 * zcosmic_toplevel_handle_v1.state event will be sent.
 */
static inline void
zcosmic_toplevel_manager_v1_set_minimized(struct zcosmic_toplevel_manager_v1 *zcosmic_toplevel_manager_v1, struct zcosmic_toplevel_handle_v1 *toplevel)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zcosmic_toplevel_manager_v1,
			 ZCOSMIC_TOPLEVEL_MANAGER_V1_SET_MINIMIZED, NULL, wl_proxy_get_version((struct wl_proxy *) zcosmic_toplevel_manager_v1), 0, toplevel);
}

/**
 * @ingroup iface_zcosmic_toplevel_manager_v1
 *
 * If the compositor honors this request, the
 * zcosmic_toplevel_handle_v1.state event will be sent.
 */
static inline void
zcosmic_toplevel_manager_v1_unset_minimized(struct zcosmic_toplevel_manager_v1 *zcosmic_toplevel_manager_v1, struct zcosmic_toplevel_handle_v1 *toplevel)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zcosmic_toplevel_manager_v1,
			 ZCOSMIC_TOPLEVEL_MANAGER_V1_UNSET_MINIMIZED, NULL, wl_proxy_get_version((struct wl_proxy *) zcosmic_toplevel_manager_v1), 0, toplevel);
}

/**
 * @ingroup iface_zcosmic_toplevel_manager_v1
 *
 * If the compositor honors this request, the
 * zcosmic_toplevel_handle_v1.state and potentially the
 * zcosmic_toplevel_handle_v1.output_enter/output_leave events will
 * be sent.
 *
 * The output parameter a hint to the compositor and may be ignored. A
 * value of NULL indicates that the compositor should choose the target
 * output, if it honors the fullscreen request.
 */
static inline void
zcosmic_toplevel_manager_v1_set_fullscreen(struct zcosmic_toplevel_manager_v1 *zcosmic_toplevel_manager_v1, struct zcosmic_toplevel_handle_v1 *toplevel, struct wl_output *output)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zcosmic_toplevel_manager_v1,
			 ZCOSMIC_TOPLEVEL_MANAGER_V1_SET_FULLSCREEN, NULL, wl_proxy_get_version((struct wl_proxy *) zcosmic_toplevel_manager_v1), 0, toplevel, output);
}

/**
 * @ingroup iface_zcosmic_toplevel_manager_v1
 *
 * If the compositor honors this request, the
 * zcosmic_toplevel_handle_v1.state event will be sent.
 */
static inline void
zcosmic_toplevel_manager_v1_unset_fullscreen(struct zcosmic_toplevel_manager_v1 *zcosmic_toplevel_manager_v1, struct zcosmic_toplevel_handle_v1 *toplevel)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zcosmic_toplevel_manager_v1,
			 ZCOSMIC_TOPLEVEL_MANAGER_V1_UNSET_FULLSCREEN, NULL, wl_proxy_get_version((struct wl_proxy *) zcosmic_toplevel_manager_v1), 0, toplevel);
}

/**
 * @ingroup iface_zcosmic_toplevel_manager_v1
 *
 * If a client using this protocol displays UI elements corresponding
 * to toplevels, it may use this request to inform the server about such
 * a relation. This information may be used by the server, for example as
 * the target for a minimize animation.
 *
 * If the client sets more than one rectangle, only the most recently
 * set rectangle is considered.
 *
 * The dimensions are given in surface-local coordinates.
 *
 * Setting width=height=0 removes the current rectangle if one was set.
 */
static inline void
zcosmic_toplevel_manager_v1_set_rectangle(struct zcosmic_toplevel_manager_v1 *zcosmic_toplevel_manager_v1, struct zcosmic_toplevel_handle_v1 *toplevel, struct wl_surface *surface, int32_t x, int32_t y, int32_t width, int32_t height)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zcosmic_toplevel_manager_v1,
			 ZCOSMIC_TOPLEVEL_MANAGER_V1_SET_RECTANGLE, NULL, wl_proxy_get_version((struct wl_proxy *) zcosmic_toplevel_manager_v1), 0, toplevel, surface, x, y, width, height);
}

/**
 * @ingroup iface_zcosmic_toplevel_manager_v1
 *
 * Move window to workspace, on given output.
 */
static inline void
zcosmic_toplevel_manager_v1_move_to_workspace(struct zcosmic_toplevel_manager_v1 *zcosmic_toplevel_manager_v1, struct zcosmic_toplevel_handle_v1 *toplevel, struct zcosmic_workspace_handle_v1 *workspace, struct wl_output *output)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zcosmic_toplevel_manager_v1,
			 ZCOSMIC_TOPLEVEL_MANAGER_V1_MOVE_TO_WORKSPACE, NULL, wl_proxy_get_version((struct wl_proxy *) zcosmic_toplevel_manager_v1), 0, toplevel, workspace, output);
}

/**
 * @ingroup iface_zcosmic_toplevel_manager_v1
 *
 * If the compositor honors this request, the
 * zcosmic_toplevel_handle_v1.state event will be sent.
 */
static inline void
zcosmic_toplevel_manager_v1_set_sticky(struct zcosmic_toplevel_manager_v1 *zcosmic_toplevel_manager_v1, struct zcosmic_toplevel_handle_v1 *toplevel)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zcosmic_toplevel_manager_v1,
			 ZCOSMIC_TOPLEVEL_MANAGER_V1_SET_STICKY, NULL, wl_proxy_get_version((struct wl_proxy *) zcosmic_toplevel_manager_v1), 0, toplevel);
}

/**
 * @ingroup iface_zcosmic_toplevel_manager_v1
 *
 * If the compositor honors this request, the
 * zcosmic_toplevel_handle_v1.state event will be sent.
 */
static inline void
zcosmic_toplevel_manager_v1_unset_sticky(struct zcosmic_toplevel_manager_v1 *zcosmic_toplevel_manager_v1, struct zcosmic_toplevel_handle_v1 *toplevel)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zcosmic_toplevel_manager_v1,
			 ZCOSMIC_TOPLEVEL_MANAGER_V1_UNSET_STICKY, NULL, wl_proxy_get_version((struct wl_proxy *) zcosmic_toplevel_manager_v1), 0, toplevel);
}

/**
 * @ingroup iface_zcosmic_toplevel_manager_v1
 *
 * Move window to workspace, on given output.
 */
static inline void
zcosmic_toplevel_manager_v1_move_to_ext_workspace(struct zcosmic_toplevel_manager_v1 *zcosmic_toplevel_manager_v1, struct zcosmic_toplevel_handle_v1 *toplevel, struct ext_workspace_handle_v1 *workspace, struct wl_output *output)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zcosmic_toplevel_manager_v1,
			 ZCOSMIC_TOPLEVEL_MANAGER_V1_MOVE_TO_EXT_WORKSPACE, NULL, wl_proxy_get_version((struct wl_proxy *) zcosmic_toplevel_manager_v1), 0, toplevel, workspace, output);
}

#ifdef  __cplusplus
}
#endif

#endif
