/* database.c generated by valac 0.56.18, the Vala compiler
 * generated from database.vala, do not modify */

/* Copyright 2017 Siddhartha Das (bablu.boy@gmail.com)
*
* This file is part of Bookworm and manages all the Database interactions
*
* Bookworm is free software: you can redistribute it
* and/or modify it under the terms of the GNU General Public License as
* published by the Free Software Foundation, either version 3 of the
* License, or (at your option) any later version.
*
* Bookworm is distributed in the hope that it will be
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
* Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with Bookworm. If not, see http://www.gnu.org/licenses/.
*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <sqlite3.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>

#define BOOKWORM_APP_DB_BOOKWORM_TABLE_BASE_NAME "BOOK_LIBRARY_TABLE"
#define BOOKWORM_APP_DB_BOOKWORM_TABLE_VERSION "6"
#define BOOKWORM_APP_DB_BOOKMETADATA_TABLE_BASE_NAME "BOOK_METADATA_TABLE"
#define BOOKWORM_APP_DB_BOOKMETADATA_TABLE_VERSION "1"
#define BOOKWORM_APP_DB_VERSION_TABLE_BASE_NAME "VERSION_TABLE"
#define BOOKWORM_APP_DB_VERSION_TABLE_VERSION "1"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BOOKWORM_APP_TYPE_DB (bookworm_app_db_get_type ())
#define BOOKWORM_APP_DB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOOKWORM_APP_TYPE_DB, BookwormAppDB))
#define BOOKWORM_APP_DB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOOKWORM_APP_TYPE_DB, BookwormAppDBClass))
#define BOOKWORM_APP_IS_DB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOOKWORM_APP_TYPE_DB))
#define BOOKWORM_APP_IS_DB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOOKWORM_APP_TYPE_DB))
#define BOOKWORM_APP_DB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOOKWORM_APP_TYPE_DB, BookwormAppDBClass))

typedef struct _BookwormAppDB BookwormAppDB;
typedef struct _BookwormAppDBClass BookwormAppDBClass;
typedef struct _BookwormAppDBPrivate BookwormAppDBPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _sqlite3_close0(var) ((var == NULL) ? NULL : (var = (sqlite3_close (var), NULL)))
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define BOOKWORM_APP_TYPE_BOOK (bookworm_app_book_get_type ())
#define BOOKWORM_APP_BOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOOKWORM_APP_TYPE_BOOK, BookwormAppBook))
#define BOOKWORM_APP_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOOKWORM_APP_TYPE_BOOK, BookwormAppBookClass))
#define BOOKWORM_APP_IS_BOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOOKWORM_APP_TYPE_BOOK))
#define BOOKWORM_APP_IS_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOOKWORM_APP_TYPE_BOOK))
#define BOOKWORM_APP_BOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOOKWORM_APP_TYPE_BOOK, BookwormAppBookClass))

typedef struct _BookwormAppBook BookwormAppBook;
typedef struct _BookwormAppBookClass BookwormAppBookClass;
#define _bookworm_app_book_unref0(var) ((var == NULL) ? NULL : (var = (bookworm_app_book_unref (var), NULL)))
typedef struct _BookwormAppParamSpecDB BookwormAppParamSpecDB;

struct _BookwormAppDB {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BookwormAppDBPrivate * priv;
};

struct _BookwormAppDBClass {
	GTypeClass parent_class;
	void (*finalize) (BookwormAppDB *self);
};

struct _BookwormAppParamSpecDB {
	GParamSpec parent_instance;
};

static gpointer bookworm_app_db_parent_class = NULL;
static sqlite3* bookworm_app_db_bookwormDB;
static sqlite3* bookworm_app_db_bookwormDB = NULL;
static gchar* bookworm_app_db_errmsg;
static gchar* bookworm_app_db_errmsg = NULL;
static gchar* bookworm_app_db_queryString;
static gchar* bookworm_app_db_queryString = NULL;
static gint bookworm_app_db_executionStatus;
static gint bookworm_app_db_executionStatus = 0;
VALA_EXTERN gchar* bookworm_app_bookworm_no_of_books_per_page;
VALA_EXTERN GString* bookworm_app_bookworm_pathsOfBooksInLibraryOnLoadStr;
VALA_EXTERN GeeArrayList* bookworm_app_bookworm_paginationlist;

VALA_EXTERN gpointer bookworm_app_db_ref (gpointer instance);
VALA_EXTERN void bookworm_app_db_unref (gpointer instance);
VALA_EXTERN GParamSpec* bookworm_app_param_spec_db (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void bookworm_app_value_set_db (GValue* value,
                                gpointer v_object);
VALA_EXTERN void bookworm_app_value_take_db (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer bookworm_app_value_get_db (const GValue* value);
VALA_EXTERN GType bookworm_app_db_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookwormAppDB, bookworm_app_db_unref)
VALA_EXTERN gboolean bookworm_app_db_initializeBookWormDB (const gchar* bookworm_config_path);
VALA_EXTERN gpointer bookworm_app_book_ref (gpointer instance);
VALA_EXTERN void bookworm_app_book_unref (gpointer instance);
VALA_EXTERN GParamSpec* bookworm_app_param_spec_book (const gchar* name,
                                          const gchar* nick,
                                          const gchar* blurb,
                                          GType object_type,
                                          GParamFlags flags);
VALA_EXTERN void bookworm_app_value_set_book (GValue* value,
                                  gpointer v_object);
VALA_EXTERN void bookworm_app_value_take_book (GValue* value,
                                   gpointer v_object);
VALA_EXTERN gpointer bookworm_app_value_get_book (const GValue* value);
VALA_EXTERN GType bookworm_app_book_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookwormAppBook, bookworm_app_book_unref)
VALA_EXTERN GeeArrayList* bookworm_app_db_getBooksFromDB (const gchar* criteria,
                                              const gchar* mode);
VALA_EXTERN BookwormAppBook* bookworm_app_book_new (void);
VALA_EXTERN BookwormAppBook* bookworm_app_book_construct (GType object_type);
VALA_EXTERN void bookworm_app_book_setBookId (BookwormAppBook* self,
                                  gint aBookId);
VALA_EXTERN void bookworm_app_book_setBookLocation (BookwormAppBook* self,
                                        const gchar* aBookLocation);
VALA_EXTERN void bookworm_app_book_setBookTitle (BookwormAppBook* self,
                                     const gchar* aBookTitle);
VALA_EXTERN void bookworm_app_book_setBookAuthor (BookwormAppBook* self,
                                      const gchar* aBookAuthor);
VALA_EXTERN void bookworm_app_book_setBookCoverLocation (BookwormAppBook* self,
                                             const gchar* aBookCoverLocation);
VALA_EXTERN void bookworm_app_book_setIsBookCoverImagePresent (BookwormAppBook* self,
                                                   gboolean isABookCoverImagePresent);
VALA_EXTERN void bookworm_app_book_setBookPageNumber (BookwormAppBook* self,
                                          gint aBookPageNumber);
VALA_EXTERN void bookworm_app_book_setBookPublishDate (BookwormAppBook* self,
                                           const gchar* aBookPublishDate);
VALA_EXTERN void bookworm_app_book_setBookTags (BookwormAppBook* self,
                                    const gchar* aBookTags);
VALA_EXTERN void bookworm_app_book_setAnnotationTags (BookwormAppBook* self,
                                          const gchar* anAnnotationTags);
VALA_EXTERN void bookworm_app_book_setBookRating (BookwormAppBook* self,
                                      gint aBookRating);
VALA_EXTERN void bookworm_app_book_setBookExtractionLocation (BookwormAppBook* self,
                                                  const gchar* aBookExtractionLocation);
VALA_EXTERN void bookworm_app_book_setBookTotalPages (BookwormAppBook* self,
                                          gint aBookTotalPages);
VALA_EXTERN void bookworm_app_book_setBookCreationDate (BookwormAppBook* self,
                                            const gchar* aBookCreationDate);
VALA_EXTERN void bookworm_app_book_setBookLastModificationDate (BookwormAppBook* self,
                                                    const gchar* aBookLastModificationDate);
VALA_EXTERN gchar* bookworm_app_book_getBookLocation (BookwormAppBook* self);
VALA_EXTERN gchar* bookworm_app_book_getBookLastModificationDate (BookwormAppBook* self);
VALA_EXTERN BookwormAppBook* bookworm_app_db_getBookFromDB (const gchar* book_location);
VALA_EXTERN BookwormAppBook* bookworm_app_db_getBookMetaDataFromDB (BookwormAppBook* aBook);
VALA_EXTERN gint bookworm_app_book_getBookId (BookwormAppBook* self);
VALA_EXTERN BookwormAppBook* bookworm_app_utils_convertStringToTOC (BookwormAppBook* aBook,
                                                        const gchar* tocString);
VALA_EXTERN void bookworm_app_book_setBookmark (BookwormAppBook* self,
                                    gint pageNumber,
                                    const gchar* action);
VALA_EXTERN BookwormAppBook* bookworm_app_utils_convertStringToContentList (BookwormAppBook* aBook,
                                                                const gchar* contentListString);
VALA_EXTERN void bookworm_app_book_setBookScrollPos (BookwormAppBook* self,
                                         gint aBookScrollPos);
VALA_EXTERN void bookworm_app_book_setAnnotationList (BookwormAppBook* self,
                                          GeeTreeMap* aTreeMap);
VALA_EXTERN GeeTreeMap* bookworm_app_utils_convertStringToTreeMap (const gchar* stringForTreeMap);
VALA_EXTERN gint bookworm_app_db_addBookToDataBase (BookwormAppBook* aBook);
VALA_EXTERN gchar* bookworm_app_book_getBookTitle (BookwormAppBook* self);
VALA_EXTERN gchar* bookworm_app_book_getBookAuthor (BookwormAppBook* self);
VALA_EXTERN gchar* bookworm_app_book_getBookCoverLocation (BookwormAppBook* self);
VALA_EXTERN gboolean bookworm_app_book_getIsBookCoverImagePresent (BookwormAppBook* self);
VALA_EXTERN gchar* bookworm_app_book_getBookExtractionLocation (BookwormAppBook* self);
VALA_EXTERN gboolean bookworm_app_db_removeBookFromDB (BookwormAppBook* aBook);
VALA_EXTERN gboolean bookworm_app_db_updateBookToDataBase (BookwormAppBook* aBook);
VALA_EXTERN gchar* bookworm_app_book_to_string (BookwormAppBook* self);
VALA_EXTERN gint bookworm_app_book_getBookPageNumber (BookwormAppBook* self);
VALA_EXTERN gchar* bookworm_app_book_getBookTags (BookwormAppBook* self);
VALA_EXTERN gchar* bookworm_app_book_getAnnotationTags (BookwormAppBook* self);
VALA_EXTERN gint bookworm_app_book_getBookRating (BookwormAppBook* self);
VALA_EXTERN gint bookworm_app_book_getBookTotalPages (BookwormAppBook* self);
VALA_EXTERN gchar* bookworm_app_utils_convertTOCToString (BookwormAppBook* aBook);
VALA_EXTERN gchar* bookworm_app_book_getBookmark (BookwormAppBook* self);
VALA_EXTERN gchar* bookworm_app_utils_convertContentListToString (BookwormAppBook* aBook);
VALA_EXTERN gint bookworm_app_book_getBookScrollPos (BookwormAppBook* self);
VALA_EXTERN gchar* bookworm_app_utils_convertTreeMapToString (GeeTreeMap* aMap);
VALA_EXTERN GeeTreeMap* bookworm_app_book_getAnnotationList (BookwormAppBook* self);
VALA_EXTERN GeeArrayList* bookworm_app_db_getBookIDListFromDB (void);
VALA_EXTERN BookwormAppDB* bookworm_app_db_new (void);
VALA_EXTERN BookwormAppDB* bookworm_app_db_construct (GType object_type);
static void bookworm_app_db_finalize (BookwormAppDB * obj);
static GType bookworm_app_db_get_type_once (void);

static gint
_sqlite3_exec (sqlite3* self,
               const gchar* sql,
               sqlite3_callback callback,
               gpointer callback_target,
               gchar** errmsg)
{
	gchar* _vala_errmsg = NULL;
	const gchar* sqlite_errmsg = NULL;
	gint ec = 0;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_;
	const gchar* _tmp4_;
	gint result;
#line 34 "sqlite3.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 34 "sqlite3.vapi"
	g_return_val_if_fail (sql != NULL, 0);
#line 36 "sqlite3.vapi"
	_tmp1_ = sqlite3_exec (self, sql, callback, callback_target, (char**) (&_tmp0_));
#line 36 "sqlite3.vapi"
	sqlite_errmsg = _tmp0_;
#line 36 "sqlite3.vapi"
	ec = _tmp1_;
#line 37 "sqlite3.vapi"
	if ((&_vala_errmsg) != NULL) {
#line 242 "database.c"
		const gchar* _tmp2_;
		gchar* _tmp3_;
#line 38 "sqlite3.vapi"
		_tmp2_ = sqlite_errmsg;
#line 38 "sqlite3.vapi"
		_tmp3_ = g_strdup (_tmp2_);
#line 38 "sqlite3.vapi"
		_g_free0 (_vala_errmsg);
#line 38 "sqlite3.vapi"
		_vala_errmsg = _tmp3_;
#line 253 "database.c"
	} else {
#line 40 "sqlite3.vapi"
		_g_free0 (_vala_errmsg);
#line 40 "sqlite3.vapi"
		_vala_errmsg = NULL;
#line 259 "database.c"
	}
#line 42 "sqlite3.vapi"
	_tmp4_ = sqlite_errmsg;
#line 42 "sqlite3.vapi"
	sqlite3_free ((void*) _tmp4_);
#line 43 "sqlite3.vapi"
	result = ec;
#line 43 "sqlite3.vapi"
	if (errmsg) {
#line 43 "sqlite3.vapi"
		*errmsg = _vala_errmsg;
#line 271 "database.c"
	} else {
#line 43 "sqlite3.vapi"
		_g_free0 (_vala_errmsg);
#line 275 "database.c"
	}
#line 43 "sqlite3.vapi"
	return result;
#line 279 "database.c"
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
#line 1413 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1414 "glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1414 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1415 "glib-2.0.vapi"
	g_strstrip (_result_);
#line 1416 "glib-2.0.vapi"
	result = _result_;
#line 1416 "glib-2.0.vapi"
	return result;
#line 300 "database.c"
}

gboolean
bookworm_app_db_initializeBookWormDB (const gchar* bookworm_config_path)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	sqlite3_stmt* stmt = NULL;
	gint dbOpenStatus = 0;
	gchar* _tmp2_;
	gchar* _tmp3_;
	sqlite3* _tmp4_ = NULL;
	gint _tmp5_;
	gint _tmp6_;
	gchar* _tmp16_;
	sqlite3* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_ = NULL;
	gint _tmp20_;
	gchar* _tmp25_;
	sqlite3* _tmp26_;
	const gchar* _tmp27_;
	gchar* _tmp28_ = NULL;
	gint _tmp29_;
	GeeArrayList* listOfTables = NULL;
	GeeArrayList* _tmp34_;
	gchar* _tmp35_;
	sqlite3* _tmp36_;
	const gchar* _tmp37_;
	const gchar* _tmp38_;
	gint _tmp39_;
	gint _tmp40_;
	sqlite3_stmt* _tmp41_ = NULL;
	gint _tmp42_;
	sqlite3_stmt* _tmp55_;
	GeeArrayList* _tmp56_;
	GeeArrayList* _tmp57_;
	gboolean result;
#line 34 "../src/database.vala"
	g_return_val_if_fail (bookworm_config_path != NULL, FALSE);
#line 35 "../src/database.vala"
	_tmp0_ = g_strconcat ("[START] [FUNCTION:initializeBookWormDB] bookworm_config_path=", bookworm_config_path, NULL);
#line 35 "../src/database.vala"
	_tmp1_ = _tmp0_;
#line 35 "../src/database.vala"
	g_info ("database.vala:35: %s", _tmp1_);
#line 35 "../src/database.vala"
	_g_free0 (_tmp1_);
#line 37 "../src/database.vala"
	g_debug ("database.vala:37: Checking BookWorm DB or creating it if the DB does n" \
"ot exist...");
#line 38 "../src/database.vala"
	_tmp2_ = g_strconcat (bookworm_config_path, "/bookworm.db", NULL);
#line 38 "../src/database.vala"
	_tmp3_ = _tmp2_;
#line 38 "../src/database.vala"
	_tmp5_ = sqlite3_open_v2 (_tmp3_, &_tmp4_, SQLITE_OPEN_READWRITE | SQLITE_OPEN_CREATE, NULL);
#line 38 "../src/database.vala"
	_sqlite3_close0 (bookworm_app_db_bookwormDB);
#line 38 "../src/database.vala"
	bookworm_app_db_bookwormDB = _tmp4_;
#line 38 "../src/database.vala"
	_tmp6_ = _tmp5_;
#line 38 "../src/database.vala"
	_g_free0 (_tmp3_);
#line 38 "../src/database.vala"
	dbOpenStatus = _tmp6_;
#line 40 "../src/database.vala"
	if (dbOpenStatus != SQLITE_OK) {
#line 369 "database.c"
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		sqlite3* _tmp13_;
		sqlite3* _tmp14_;
		const gchar* _tmp15_;
#line 41 "../src/database.vala"
		_tmp7_ = g_strconcat ("Error in opening database[", bookworm_config_path, NULL);
#line 41 "../src/database.vala"
		_tmp8_ = _tmp7_;
#line 41 "../src/database.vala"
		_tmp9_ = g_strconcat (_tmp8_, "/bookworm.db", NULL);
#line 41 "../src/database.vala"
		_tmp10_ = _tmp9_;
#line 41 "../src/database.vala"
		_tmp11_ = g_strconcat (_tmp10_, "]: %d: %s\n", NULL);
#line 41 "../src/database.vala"
		_tmp12_ = _tmp11_;
#line 41 "../src/database.vala"
		_tmp13_ = bookworm_app_db_bookwormDB;
#line 41 "../src/database.vala"
		_tmp14_ = bookworm_app_db_bookwormDB;
#line 41 "../src/database.vala"
		_tmp15_ = sqlite3_errmsg (_tmp14_);
#line 41 "../src/database.vala"
		g_warning (_tmp12_, sqlite3_errcode (_tmp13_), _tmp15_);
#line 41 "../src/database.vala"
		_g_free0 (_tmp12_);
#line 41 "../src/database.vala"
		_g_free0 (_tmp10_);
#line 41 "../src/database.vala"
		_g_free0 (_tmp8_);
#line 44 "../src/database.vala"
		result = FALSE;
#line 44 "../src/database.vala"
		_sqlite3_finalize0 (stmt);
#line 44 "../src/database.vala"
		return result;
#line 411 "database.c"
	} else {
#line 46 "../src/database.vala"
		g_debug ("database.vala:46: Successfully checked/created DB for Bookworm.....");
#line 415 "database.c"
	}
#line 49 "../src/database.vala"
	g_debug ("database.vala:49: Creating latest version for Library table if it does" \
" not exists");
#line 50 "../src/database.vala"
	_tmp16_ = g_strdup ("CREATE TABLE IF NOT EXISTS " BOOKWORM_APP_DB_BOOKWORM_TABLE_BASE_NAME BOOKWORM_APP_DB_BOOKWORM_TABLE_VERSION " (" "id INTEGER PRIMARY KEY AUTOINCREMENT, " "BOOK_LOCATION TEXT NOT NULL DEFAULT '', " "BOOK_TITLE TEXT NOT NULL DEFAULT '', " "BOOK_AUTHOR TEXT NOT NULL DEFAULT '', " "BOOK_COVER_IMAGE_LOCATION TEXT NOT NULL DEFAULT '', " "IS_BOOK_COVER_IMAGE_PRESENT TEXT NOT NULL DEFAULT '', " "BOOK_PUBLISH_DATE TEXT NOT NULL DEFAULT '', " "BOOK_TOTAL_NUMBER_OF_PAGES TEXT NOT NULL DEFAULT '', " "BOOK_LAST_READ_PAGE_NUMBER TEXT NOT NULL DEFAULT '', " "BOOK_TOTAL_PAGES TEXT NOT NULL DEFAULT '', " "TAGS TEXT NOT NULL DEFAULT '', " "ANNOTATION_TAGS TEXT NOT NULL DEFAULT '', " "RATINGS TEXT NOT NULL DEFAULT '', " "CONTENT_EXTRACTION_LOCATION TEXT NOT NULL DEFAULT '', " "creation_date INTEGER," "modification_date INTEGER)");
#line 50 "../src/database.vala"
	_g_free0 (bookworm_app_db_queryString);
#line 50 "../src/database.vala"
	bookworm_app_db_queryString = _tmp16_;
#line 67 "../src/database.vala"
	_tmp17_ = bookworm_app_db_bookwormDB;
#line 67 "../src/database.vala"
	_tmp18_ = bookworm_app_db_queryString;
#line 67 "../src/database.vala"
	_tmp20_ = _sqlite3_exec (_tmp17_, _tmp18_, NULL, NULL, &_tmp19_);
#line 67 "../src/database.vala"
	_g_free0 (bookworm_app_db_errmsg);
#line 67 "../src/database.vala"
	bookworm_app_db_errmsg = _tmp19_;
#line 67 "../src/database.vala"
	bookworm_app_db_executionStatus = _tmp20_;
#line 68 "../src/database.vala"
	if (bookworm_app_db_executionStatus != SQLITE_OK) {
#line 439 "database.c"
		const gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		const gchar* _tmp24_;
#line 69 "../src/database.vala"
		_tmp21_ = bookworm_app_db_queryString;
#line 69 "../src/database.vala"
		_tmp22_ = g_strconcat ("Error on executing Query:", _tmp21_, NULL);
#line 69 "../src/database.vala"
		_tmp23_ = _tmp22_;
#line 69 "../src/database.vala"
		g_debug ("database.vala:69: %s", _tmp23_);
#line 69 "../src/database.vala"
		_g_free0 (_tmp23_);
#line 70 "../src/database.vala"
		_tmp24_ = bookworm_app_db_errmsg;
#line 70 "../src/database.vala"
		g_warning ("database.vala:70: Error details: %s\n", _tmp24_);
#line 71 "../src/database.vala"
		result = FALSE;
#line 71 "../src/database.vala"
		_sqlite3_finalize0 (stmt);
#line 71 "../src/database.vala"
		return result;
#line 464 "database.c"
	} else {
#line 73 "../src/database.vala"
		g_debug ("database.vala:73: %s", "Successfully checked/created table:" BOOKWORM_APP_DB_BOOKWORM_TABLE_BASE_NAME BOOKWORM_APP_DB_BOOKWORM_TABLE_VERSION);
#line 468 "database.c"
	}
#line 76 "../src/database.vala"
	g_debug ("database.vala:76: Creating latest version for Book Metadata table if i" \
"t does not exists");
#line 77 "../src/database.vala"
	_tmp25_ = g_strdup ("CREATE TABLE IF NOT EXISTS " BOOKWORM_APP_DB_BOOKMETADATA_TABLE_BASE_NAME BOOKWORM_APP_DB_BOOKMETADATA_TABLE_VERSION " (" "id INTEGER PRIMARY KEY, " "BOOK_TOC_DATA TEXT NOT NULL DEFAULT '', " "BOOKMARKS TEXT NOT NULL DEFAULT '', " "CONTENT_DATA_LIST TEXT NOT NULL DEFAULT '', " "BOOK_LAST_SCROLL_POSITION TEXT NOT NULL DEFAULT '', " "BOOK_ANNOTATIONS TEXT NOT NULL DEFAULT '', " "creation_date INTEGER," "modification_date INTEGER)");
#line 77 "../src/database.vala"
	_g_free0 (bookworm_app_db_queryString);
#line 77 "../src/database.vala"
	bookworm_app_db_queryString = _tmp25_;
#line 86 "../src/database.vala"
	_tmp26_ = bookworm_app_db_bookwormDB;
#line 86 "../src/database.vala"
	_tmp27_ = bookworm_app_db_queryString;
#line 86 "../src/database.vala"
	_tmp29_ = _sqlite3_exec (_tmp26_, _tmp27_, NULL, NULL, &_tmp28_);
#line 86 "../src/database.vala"
	_g_free0 (bookworm_app_db_errmsg);
#line 86 "../src/database.vala"
	bookworm_app_db_errmsg = _tmp28_;
#line 86 "../src/database.vala"
	bookworm_app_db_executionStatus = _tmp29_;
#line 87 "../src/database.vala"
	if (bookworm_app_db_executionStatus != SQLITE_OK) {
#line 492 "database.c"
		const gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		const gchar* _tmp33_;
#line 88 "../src/database.vala"
		_tmp30_ = bookworm_app_db_queryString;
#line 88 "../src/database.vala"
		_tmp31_ = g_strconcat ("Error on executing Query:", _tmp30_, NULL);
#line 88 "../src/database.vala"
		_tmp32_ = _tmp31_;
#line 88 "../src/database.vala"
		g_debug ("database.vala:88: %s", _tmp32_);
#line 88 "../src/database.vala"
		_g_free0 (_tmp32_);
#line 89 "../src/database.vala"
		_tmp33_ = bookworm_app_db_errmsg;
#line 89 "../src/database.vala"
		g_warning ("database.vala:89: Error details: %s\n", _tmp33_);
#line 90 "../src/database.vala"
		result = FALSE;
#line 90 "../src/database.vala"
		_sqlite3_finalize0 (stmt);
#line 90 "../src/database.vala"
		return result;
#line 517 "database.c"
	} else {
#line 92 "../src/database.vala"
		g_debug ("database.vala:92: %s", "Successfully checked/created table:" BOOKWORM_APP_DB_BOOKMETADATA_TABLE_BASE_NAME BOOKWORM_APP_DB_BOOKMETADATA_TABLE_VERSION);
#line 521 "database.c"
	}
#line 96 "../src/database.vala"
	_tmp34_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
#line 96 "../src/database.vala"
	listOfTables = _tmp34_;
#line 97 "../src/database.vala"
	_tmp35_ = g_strdup ("SELECT NAME FROM SQLITE_MASTER WHERE TYPE='table' ORDER BY NAME");
#line 97 "../src/database.vala"
	_g_free0 (bookworm_app_db_queryString);
#line 97 "../src/database.vala"
	bookworm_app_db_queryString = _tmp35_;
#line 98 "../src/database.vala"
	_tmp36_ = bookworm_app_db_bookwormDB;
#line 98 "../src/database.vala"
	_tmp37_ = bookworm_app_db_queryString;
#line 98 "../src/database.vala"
	_tmp38_ = bookworm_app_db_queryString;
#line 98 "../src/database.vala"
	_tmp39_ = strlen (_tmp38_);
#line 98 "../src/database.vala"
	_tmp40_ = _tmp39_;
#line 98 "../src/database.vala"
	_tmp42_ = sqlite3_prepare_v2 (_tmp36_, _tmp37_, _tmp40_, &_tmp41_, NULL);
#line 98 "../src/database.vala"
	_sqlite3_finalize0 (stmt);
#line 98 "../src/database.vala"
	stmt = _tmp41_;
#line 98 "../src/database.vala"
	bookworm_app_db_executionStatus = _tmp42_;
#line 99 "../src/database.vala"
	if (bookworm_app_db_executionStatus != SQLITE_OK) {
#line 553 "database.c"
		const gchar* _tmp43_;
		gchar* _tmp44_;
		gchar* _tmp45_;
		sqlite3* _tmp46_;
		sqlite3* _tmp47_;
		const gchar* _tmp48_;
#line 100 "../src/database.vala"
		_tmp43_ = bookworm_app_db_queryString;
#line 100 "../src/database.vala"
		_tmp44_ = g_strconcat ("Error on executing Query:", _tmp43_, NULL);
#line 100 "../src/database.vala"
		_tmp45_ = _tmp44_;
#line 100 "../src/database.vala"
		g_debug ("database.vala:100: %s", _tmp45_);
#line 100 "../src/database.vala"
		_g_free0 (_tmp45_);
#line 101 "../src/database.vala"
		_tmp46_ = bookworm_app_db_bookwormDB;
#line 101 "../src/database.vala"
		_tmp47_ = bookworm_app_db_bookwormDB;
#line 101 "../src/database.vala"
		_tmp48_ = sqlite3_errmsg (_tmp47_);
#line 101 "../src/database.vala"
		g_warning ("database.vala:101: Error details: %d: %s\n", sqlite3_errcode (_tmp46_), _tmp48_);
#line 578 "database.c"
	}
#line 103 "../src/database.vala"
	while (TRUE) {
#line 582 "database.c"
		sqlite3_stmt* _tmp49_;
		GeeArrayList* _tmp50_;
		sqlite3_stmt* _tmp51_;
		const gchar* _tmp52_;
		gchar* _tmp53_;
		gchar* _tmp54_;
#line 103 "../src/database.vala"
		_tmp49_ = stmt;
#line 103 "../src/database.vala"
		if (!(sqlite3_step (_tmp49_) == SQLITE_ROW)) {
#line 103 "../src/database.vala"
			break;
#line 595 "database.c"
		}
#line 104 "../src/database.vala"
		_tmp50_ = listOfTables;
#line 104 "../src/database.vala"
		_tmp51_ = stmt;
#line 104 "../src/database.vala"
		_tmp52_ = (const gchar*) sqlite3_column_text (_tmp51_, 0);
#line 104 "../src/database.vala"
		_tmp53_ = string_strip (_tmp52_);
#line 104 "../src/database.vala"
		_tmp54_ = _tmp53_;
#line 104 "../src/database.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp50_, _tmp54_);
#line 104 "../src/database.vala"
		_g_free0 (_tmp54_);
#line 611 "database.c"
	}
#line 106 "../src/database.vala"
	_tmp55_ = stmt;
#line 106 "../src/database.vala"
	sqlite3_reset (_tmp55_);
#line 109 "../src/database.vala"
	_tmp56_ = listOfTables;
#line 109 "../src/database.vala"
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp56_, BOOKWORM_APP_DB_BOOKWORM_TABLE_BASE_NAME BOOKWORM_APP_DB_BOOKWORM_TABLE_VERSION);
#line 110 "../src/database.vala"
	_tmp57_ = listOfTables;
#line 110 "../src/database.vala"
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp57_, BOOKWORM_APP_DB_BOOKMETADATA_TABLE_BASE_NAME BOOKWORM_APP_DB_BOOKMETADATA_TABLE_VERSION);
#line 625 "database.c"
	{
		GeeArrayList* _old_table_name_list = NULL;
		GeeArrayList* _tmp58_;
		gint _old_table_name_size = 0;
		GeeArrayList* _tmp59_;
		gint _tmp60_;
		gint _tmp61_;
		gint _old_table_name_index = 0;
#line 114 "../src/database.vala"
		_tmp58_ = listOfTables;
#line 114 "../src/database.vala"
		_old_table_name_list = _tmp58_;
#line 114 "../src/database.vala"
		_tmp59_ = _old_table_name_list;
#line 114 "../src/database.vala"
		_tmp60_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp59_);
#line 114 "../src/database.vala"
		_tmp61_ = _tmp60_;
#line 114 "../src/database.vala"
		_old_table_name_size = _tmp61_;
#line 114 "../src/database.vala"
		_old_table_name_index = -1;
#line 114 "../src/database.vala"
		while (TRUE) {
#line 650 "database.c"
			gint _tmp62_;
			gint _tmp63_;
			gchar* old_table_name = NULL;
			GeeArrayList* _tmp64_;
			gpointer _tmp65_;
			const gchar* _tmp66_;
			const gchar* _tmp122_;
#line 114 "../src/database.vala"
			_old_table_name_index = _old_table_name_index + 1;
#line 114 "../src/database.vala"
			_tmp62_ = _old_table_name_index;
#line 114 "../src/database.vala"
			_tmp63_ = _old_table_name_size;
#line 114 "../src/database.vala"
			if (!(_tmp62_ < _tmp63_)) {
#line 114 "../src/database.vala"
				break;
#line 668 "database.c"
			}
#line 114 "../src/database.vala"
			_tmp64_ = _old_table_name_list;
#line 114 "../src/database.vala"
			_tmp65_ = gee_abstract_list_get ((GeeAbstractList*) _tmp64_, _old_table_name_index);
#line 114 "../src/database.vala"
			old_table_name = (gchar*) _tmp65_;
#line 116 "../src/database.vala"
			_tmp66_ = old_table_name;
#line 116 "../src/database.vala"
			if (g_strcmp0 (_tmp66_, "BOOK_LIBRARY_TABLE5") == 0) {
#line 680 "database.c"
				gchar* _tmp67_;
				sqlite3* _tmp68_;
				const gchar* _tmp69_;
				gchar* _tmp70_ = NULL;
				gint _tmp71_;
#line 118 "../src/database.vala"
				_tmp67_ = g_strdup (" INSERT INTO " BOOKWORM_APP_DB_BOOKWORM_TABLE_BASE_NAME BOOKWORM_APP_DB_BOOKWORM_TABLE_VERSION " ( id, BOOK_LOCATION, BOOK_TITLE, BOOK_AUTHOR, BOOK_COVER_IMAGE_LOCATI" \
"ON, IS_BOOK_COVER_IMAGE_PRESENT,BOOK_PUBLISH_DATE, BOOK_TOTAL_NUMBER_O" \
"F_PAGES, BOOK_LAST_READ_PAGE_NUMBER, TAGS, RATINGS,CONTENT_EXTRACTION_" \
"LOCATION, creation_date, modification_date) SELECT id, BOOK_LOCATION, " \
"BOOK_TITLE, BOOK_AUTHOR, BOOK_COVER_IMAGE_LOCATION, IS_BOOK_COVER_IMAG" \
"E_PRESENT, BOOK_PUBLISH_DATE, BOOK_TOTAL_NUMBER_OF_PAGES, BOOK_LAST_RE" \
"AD_PAGE_NUMBER, TAGS, RATINGS, CONTENT_EXTRACTION_LOCATION, creation_d" \
"ate, modification_date FROM BOOK_LIBRARY_TABLE5");
#line 118 "../src/database.vala"
				_g_free0 (bookworm_app_db_queryString);
#line 118 "../src/database.vala"
				bookworm_app_db_queryString = _tmp67_;
#line 120 "../src/database.vala"
				_tmp68_ = bookworm_app_db_bookwormDB;
#line 120 "../src/database.vala"
				_tmp69_ = bookworm_app_db_queryString;
#line 120 "../src/database.vala"
				_tmp71_ = _sqlite3_exec (_tmp68_, _tmp69_, NULL, NULL, &_tmp70_);
#line 120 "../src/database.vala"
				_g_free0 (bookworm_app_db_errmsg);
#line 120 "../src/database.vala"
				bookworm_app_db_errmsg = _tmp70_;
#line 120 "../src/database.vala"
				bookworm_app_db_executionStatus = _tmp71_;
#line 121 "../src/database.vala"
				if (bookworm_app_db_executionStatus != SQLITE_OK) {
#line 706 "database.c"
					const gchar* _tmp72_;
					gchar* _tmp73_;
					gchar* _tmp74_;
					sqlite3* _tmp75_;
					sqlite3* _tmp76_;
					const gchar* _tmp77_;
#line 122 "../src/database.vala"
					_tmp72_ = bookworm_app_db_queryString;
#line 122 "../src/database.vala"
					_tmp73_ = g_strconcat ("Executed Query:", _tmp72_, NULL);
#line 122 "../src/database.vala"
					_tmp74_ = _tmp73_;
#line 122 "../src/database.vala"
					g_debug ("database.vala:122: %s", _tmp74_);
#line 122 "../src/database.vala"
					_g_free0 (_tmp74_);
#line 123 "../src/database.vala"
					_tmp75_ = bookworm_app_db_bookwormDB;
#line 123 "../src/database.vala"
					_tmp76_ = bookworm_app_db_bookwormDB;
#line 123 "../src/database.vala"
					_tmp77_ = sqlite3_errmsg (_tmp76_);
#line 123 "../src/database.vala"
					g_warning ("database.vala:123: Error: %d: %s\n", sqlite3_errcode (_tmp75_), _tmp77_);
#line 731 "database.c"
				} else {
					sqlite3* _tmp78_;
					gchar* _tmp79_;
					gchar* _tmp80_;
					gchar* _tmp81_;
					gchar* _tmp82_;
					gchar* _tmp83_;
					gchar* _tmp84_;
					gchar* _tmp85_;
					gchar* _tmp86_;
					gchar* _tmp87_;
					gchar* _tmp88_;
					gchar* _tmp89_;
					sqlite3* _tmp90_;
					const gchar* _tmp91_;
					gchar* _tmp92_ = NULL;
					gint _tmp93_;
#line 125 "../src/database.vala"
					_tmp78_ = bookworm_app_db_bookwormDB;
#line 125 "../src/database.vala"
					_tmp79_ = g_strdup_printf ("%i", sqlite3_changes (_tmp78_));
#line 125 "../src/database.vala"
					_tmp80_ = _tmp79_;
#line 125 "../src/database.vala"
					_tmp81_ = g_strconcat ("Successfully migrated ", _tmp80_, NULL);
#line 125 "../src/database.vala"
					_tmp82_ = _tmp81_;
#line 125 "../src/database.vala"
					_tmp83_ = g_strconcat (_tmp82_, " rows from BOOK_LIBRARY_TABLE5 into ", NULL);
#line 125 "../src/database.vala"
					_tmp84_ = _tmp83_;
#line 125 "../src/database.vala"
					_tmp85_ = g_strconcat (_tmp84_, BOOKWORM_APP_DB_BOOKWORM_TABLE_BASE_NAME, NULL);
#line 125 "../src/database.vala"
					_tmp86_ = _tmp85_;
#line 125 "../src/database.vala"
					_tmp87_ = g_strconcat (_tmp86_, BOOKWORM_APP_DB_BOOKWORM_TABLE_VERSION, NULL);
#line 125 "../src/database.vala"
					_tmp88_ = _tmp87_;
#line 125 "../src/database.vala"
					g_debug ("database.vala:125: %s", _tmp88_);
#line 125 "../src/database.vala"
					_g_free0 (_tmp88_);
#line 125 "../src/database.vala"
					_g_free0 (_tmp86_);
#line 125 "../src/database.vala"
					_g_free0 (_tmp84_);
#line 125 "../src/database.vala"
					_g_free0 (_tmp82_);
#line 125 "../src/database.vala"
					_g_free0 (_tmp80_);
#line 127 "../src/database.vala"
					_tmp89_ = g_strdup (" INSERT INTO " BOOKWORM_APP_DB_BOOKMETADATA_TABLE_BASE_NAME BOOKWORM_APP_DB_BOOKMETADATA_TABLE_VERSION "      ( id, BOOK_TOC_DATA, BOOKMARKS, CONTENT_DATA_LIST, BOOK_LAST_SCR" \
"OLL_POSITION, creation_date, modification_date) SELECT id, BOOK_TOC_DA" \
"TA, BOOKMARKS, CONTENT_DATA_LIST, BOOK_LAST_SCROLL_POSITION, creation_" \
"date, modification_date FROM BOOK_LIBRARY_TABLE5");
#line 127 "../src/database.vala"
					_g_free0 (bookworm_app_db_queryString);
#line 127 "../src/database.vala"
					bookworm_app_db_queryString = _tmp89_;
#line 129 "../src/database.vala"
					_tmp90_ = bookworm_app_db_bookwormDB;
#line 129 "../src/database.vala"
					_tmp91_ = bookworm_app_db_queryString;
#line 129 "../src/database.vala"
					_tmp93_ = _sqlite3_exec (_tmp90_, _tmp91_, NULL, NULL, &_tmp92_);
#line 129 "../src/database.vala"
					_g_free0 (bookworm_app_db_errmsg);
#line 129 "../src/database.vala"
					bookworm_app_db_errmsg = _tmp92_;
#line 129 "../src/database.vala"
					bookworm_app_db_executionStatus = _tmp93_;
#line 130 "../src/database.vala"
					if (bookworm_app_db_executionStatus != SQLITE_OK) {
#line 803 "database.c"
						const gchar* _tmp94_;
						gchar* _tmp95_;
						gchar* _tmp96_;
						sqlite3* _tmp97_;
						sqlite3* _tmp98_;
						const gchar* _tmp99_;
#line 131 "../src/database.vala"
						_tmp94_ = bookworm_app_db_queryString;
#line 131 "../src/database.vala"
						_tmp95_ = g_strconcat ("Executed Query:", _tmp94_, NULL);
#line 131 "../src/database.vala"
						_tmp96_ = _tmp95_;
#line 131 "../src/database.vala"
						g_debug ("database.vala:131: %s", _tmp96_);
#line 131 "../src/database.vala"
						_g_free0 (_tmp96_);
#line 132 "../src/database.vala"
						_tmp97_ = bookworm_app_db_bookwormDB;
#line 132 "../src/database.vala"
						_tmp98_ = bookworm_app_db_bookwormDB;
#line 132 "../src/database.vala"
						_tmp99_ = sqlite3_errmsg (_tmp98_);
#line 132 "../src/database.vala"
						g_warning ("database.vala:132: Error: %d: %s\n", sqlite3_errcode (_tmp97_), _tmp99_);
#line 828 "database.c"
					} else {
						sqlite3* _tmp100_;
						gchar* _tmp101_;
						gchar* _tmp102_;
						gchar* _tmp103_;
						gchar* _tmp104_;
						gchar* _tmp105_;
						gchar* _tmp106_;
						gchar* _tmp107_;
						gchar* _tmp108_;
						gchar* _tmp109_;
						gchar* _tmp110_;
						gchar* _tmp111_;
						sqlite3* _tmp112_;
						const gchar* _tmp113_;
						gchar* _tmp114_ = NULL;
						gint _tmp115_;
#line 134 "../src/database.vala"
						_tmp100_ = bookworm_app_db_bookwormDB;
#line 134 "../src/database.vala"
						_tmp101_ = g_strdup_printf ("%i", sqlite3_changes (_tmp100_));
#line 134 "../src/database.vala"
						_tmp102_ = _tmp101_;
#line 134 "../src/database.vala"
						_tmp103_ = g_strconcat ("Successfully migrated ", _tmp102_, NULL);
#line 134 "../src/database.vala"
						_tmp104_ = _tmp103_;
#line 134 "../src/database.vala"
						_tmp105_ = g_strconcat (_tmp104_, " rows from BOOK_LIBRARY_TABLE5 into", NULL);
#line 134 "../src/database.vala"
						_tmp106_ = _tmp105_;
#line 134 "../src/database.vala"
						_tmp107_ = g_strconcat (_tmp106_, BOOKWORM_APP_DB_BOOKMETADATA_TABLE_BASE_NAME, NULL);
#line 134 "../src/database.vala"
						_tmp108_ = _tmp107_;
#line 134 "../src/database.vala"
						_tmp109_ = g_strconcat (_tmp108_, BOOKWORM_APP_DB_BOOKMETADATA_TABLE_VERSION, NULL);
#line 134 "../src/database.vala"
						_tmp110_ = _tmp109_;
#line 134 "../src/database.vala"
						g_debug ("database.vala:134: %s", _tmp110_);
#line 134 "../src/database.vala"
						_g_free0 (_tmp110_);
#line 134 "../src/database.vala"
						_g_free0 (_tmp108_);
#line 134 "../src/database.vala"
						_g_free0 (_tmp106_);
#line 134 "../src/database.vala"
						_g_free0 (_tmp104_);
#line 134 "../src/database.vala"
						_g_free0 (_tmp102_);
#line 137 "../src/database.vala"
						_tmp111_ = g_strdup ("DROP TABLE IF EXISTS BOOK_LIBRARY_TABLE5");
#line 137 "../src/database.vala"
						_g_free0 (bookworm_app_db_queryString);
#line 137 "../src/database.vala"
						bookworm_app_db_queryString = _tmp111_;
#line 138 "../src/database.vala"
						_tmp112_ = bookworm_app_db_bookwormDB;
#line 138 "../src/database.vala"
						_tmp113_ = bookworm_app_db_queryString;
#line 138 "../src/database.vala"
						_tmp115_ = _sqlite3_exec (_tmp112_, _tmp113_, NULL, NULL, &_tmp114_);
#line 138 "../src/database.vala"
						_g_free0 (bookworm_app_db_errmsg);
#line 138 "../src/database.vala"
						bookworm_app_db_errmsg = _tmp114_;
#line 138 "../src/database.vala"
						bookworm_app_db_executionStatus = _tmp115_;
#line 139 "../src/database.vala"
						if (bookworm_app_db_executionStatus != SQLITE_OK) {
#line 900 "database.c"
							const gchar* _tmp116_;
							gchar* _tmp117_;
							gchar* _tmp118_;
							sqlite3* _tmp119_;
							sqlite3* _tmp120_;
							const gchar* _tmp121_;
#line 140 "../src/database.vala"
							_tmp116_ = bookworm_app_db_queryString;
#line 140 "../src/database.vala"
							_tmp117_ = g_strconcat ("Executed Query:", _tmp116_, NULL);
#line 140 "../src/database.vala"
							_tmp118_ = _tmp117_;
#line 140 "../src/database.vala"
							g_debug ("database.vala:140: %s", _tmp118_);
#line 140 "../src/database.vala"
							_g_free0 (_tmp118_);
#line 141 "../src/database.vala"
							_tmp119_ = bookworm_app_db_bookwormDB;
#line 141 "../src/database.vala"
							_tmp120_ = bookworm_app_db_bookwormDB;
#line 141 "../src/database.vala"
							_tmp121_ = sqlite3_errmsg (_tmp120_);
#line 141 "../src/database.vala"
							g_warning ("database.vala:141: Error: %d: %s\n", sqlite3_errcode (_tmp119_), _tmp121_);
#line 925 "database.c"
						} else {
#line 143 "../src/database.vala"
							g_debug ("database.vala:143: Successfully dropped old table LIBRARY_TABLE5");
#line 929 "database.c"
						}
					}
				}
			}
#line 149 "../src/database.vala"
			_tmp122_ = old_table_name;
#line 149 "../src/database.vala"
			if (g_strcmp0 (_tmp122_, "VERSION_TABLE") == 0) {
#line 938 "database.c"
				gchar* _tmp123_;
				sqlite3* _tmp124_;
				const gchar* _tmp125_;
				gchar* _tmp126_ = NULL;
				gint _tmp127_;
#line 151 "../src/database.vala"
				_tmp123_ = g_strdup ("DROP TABLE IF EXISTS VERSION_TABLE");
#line 151 "../src/database.vala"
				_g_free0 (bookworm_app_db_queryString);
#line 151 "../src/database.vala"
				bookworm_app_db_queryString = _tmp123_;
#line 152 "../src/database.vala"
				_tmp124_ = bookworm_app_db_bookwormDB;
#line 152 "../src/database.vala"
				_tmp125_ = bookworm_app_db_queryString;
#line 152 "../src/database.vala"
				_tmp127_ = _sqlite3_exec (_tmp124_, _tmp125_, NULL, NULL, &_tmp126_);
#line 152 "../src/database.vala"
				_g_free0 (bookworm_app_db_errmsg);
#line 152 "../src/database.vala"
				bookworm_app_db_errmsg = _tmp126_;
#line 152 "../src/database.vala"
				bookworm_app_db_executionStatus = _tmp127_;
#line 153 "../src/database.vala"
				if (bookworm_app_db_executionStatus != SQLITE_OK) {
#line 964 "database.c"
					const gchar* _tmp128_;
					gchar* _tmp129_;
					gchar* _tmp130_;
					sqlite3* _tmp131_;
					sqlite3* _tmp132_;
					const gchar* _tmp133_;
#line 154 "../src/database.vala"
					_tmp128_ = bookworm_app_db_queryString;
#line 154 "../src/database.vala"
					_tmp129_ = g_strconcat ("Executed Query:", _tmp128_, NULL);
#line 154 "../src/database.vala"
					_tmp130_ = _tmp129_;
#line 154 "../src/database.vala"
					g_debug ("database.vala:154: %s", _tmp130_);
#line 154 "../src/database.vala"
					_g_free0 (_tmp130_);
#line 155 "../src/database.vala"
					_tmp131_ = bookworm_app_db_bookwormDB;
#line 155 "../src/database.vala"
					_tmp132_ = bookworm_app_db_bookwormDB;
#line 155 "../src/database.vala"
					_tmp133_ = sqlite3_errmsg (_tmp132_);
#line 155 "../src/database.vala"
					g_warning ("database.vala:155: Error: %d: %s\n", sqlite3_errcode (_tmp131_), _tmp133_);
#line 989 "database.c"
				} else {
#line 157 "../src/database.vala"
					g_debug ("database.vala:157: Successfully dropped old table VERSION_TABLE");
#line 993 "database.c"
				}
			}
#line 114 "../src/database.vala"
			_g_free0 (old_table_name);
#line 998 "database.c"
		}
	}
#line 162 "../src/database.vala"
	g_info ("database.vala:162: [END] [FUNCTION:initializeBookWormDB]");
#line 163 "../src/database.vala"
	result = TRUE;
#line 163 "../src/database.vala"
	_g_object_unref0 (listOfTables);
#line 163 "../src/database.vala"
	_sqlite3_finalize0 (stmt);
#line 163 "../src/database.vala"
	return result;
#line 1011 "database.c"
}

GeeArrayList*
bookworm_app_db_getBooksFromDB (const gchar* criteria,
                                const gchar* mode)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GeeArrayList* listOfBooks = NULL;
	GeeArrayList* _tmp8_;
	sqlite3_stmt* stmt = NULL;
	gchar* last_modification_date = NULL;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gboolean _tmp11_ = FALSE;
	sqlite3* _tmp81_;
	const gchar* _tmp82_;
	const gchar* _tmp83_;
	gint _tmp84_;
	gint _tmp85_;
	sqlite3_stmt* _tmp86_ = NULL;
	gint _tmp87_;
	GeeArrayList* _tmp246_;
	gint _tmp247_;
	gint _tmp248_;
	gchar* _tmp249_;
	gchar* _tmp250_;
	gchar* _tmp251_;
	gchar* _tmp252_;
	gchar* _tmp253_;
	gchar* _tmp254_;
	const gchar* _tmp255_;
	gchar* _tmp256_;
	gchar* _tmp257_;
	gchar* _tmp258_;
	gchar* _tmp259_;
	GeeArrayList* result;
#line 166 "../src/database.vala"
	g_return_val_if_fail (criteria != NULL, NULL);
#line 166 "../src/database.vala"
	g_return_val_if_fail (mode != NULL, NULL);
#line 167 "../src/database.vala"
	_tmp0_ = g_strconcat ("[START] [FUNCTION:getBooksFromDB] Quering with mode[", mode, NULL);
#line 167 "../src/database.vala"
	_tmp1_ = _tmp0_;
#line 167 "../src/database.vala"
	_tmp2_ = g_strconcat (_tmp1_, "] and criteria[", NULL);
#line 167 "../src/database.vala"
	_tmp3_ = _tmp2_;
#line 167 "../src/database.vala"
	_tmp4_ = g_strconcat (_tmp3_, criteria, NULL);
#line 167 "../src/database.vala"
	_tmp5_ = _tmp4_;
#line 167 "../src/database.vala"
	_tmp6_ = g_strconcat (_tmp5_, "]", NULL);
#line 167 "../src/database.vala"
	_tmp7_ = _tmp6_;
#line 167 "../src/database.vala"
	g_info ("database.vala:167: %s", _tmp7_);
#line 167 "../src/database.vala"
	_g_free0 (_tmp7_);
#line 167 "../src/database.vala"
	_g_free0 (_tmp5_);
#line 167 "../src/database.vala"
	_g_free0 (_tmp3_);
#line 167 "../src/database.vala"
	_g_free0 (_tmp1_);
#line 168 "../src/database.vala"
	_tmp8_ = gee_array_list_new (BOOKWORM_APP_TYPE_BOOK, (GBoxedCopyFunc) bookworm_app_book_ref, (GDestroyNotify) bookworm_app_book_unref, NULL, NULL, NULL);
#line 168 "../src/database.vala"
	listOfBooks = _tmp8_;
#line 170 "../src/database.vala"
	_tmp9_ = g_strdup ("-1");
#line 170 "../src/database.vala"
	last_modification_date = _tmp9_;
#line 171 "../src/database.vala"
	_tmp10_ = g_strdup ("SELECT id, BOOK_LOCATION, BOOK_TITLE, BOOK_AUTHOR, BOOK_COVER_IMAGE_LO" \
"CATION, IS_BOOK_COVER_IMAGE_PRESENT, BOOK_LAST_READ_PAGE_NUMBER, BOOK_" \
"PUBLISH_DATE, TAGS, ANNOTATION_TAGS, RATINGS, CONTENT_EXTRACTION_LOCAT" \
"ION, BOOK_TOTAL_PAGES, creation_date, modification_date FROM " BOOKWORM_APP_DB_BOOKWORM_TABLE_BASE_NAME BOOKWORM_APP_DB_BOOKWORM_TABLE_VERSION);
#line 171 "../src/database.vala"
	_g_free0 (bookworm_app_db_queryString);
#line 171 "../src/database.vala"
	bookworm_app_db_queryString = _tmp10_;
#line 172 "../src/database.vala"
	if (g_strcmp0 (criteria, "") == 0) {
#line 172 "../src/database.vala"
		_tmp11_ = g_strcmp0 (mode, "PAGINATED_SEARCH") == 0;
#line 1103 "database.c"
	} else {
#line 172 "../src/database.vala"
		_tmp11_ = FALSE;
#line 1107 "database.c"
	}
#line 172 "../src/database.vala"
	if (_tmp11_) {
#line 1111 "database.c"
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		const gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
#line 174 "../src/database.vala"
		_tmp12_ = bookworm_app_db_queryString;
#line 174 "../src/database.vala"
		_tmp13_ = g_strconcat (_tmp12_, " ORDER BY modification_date DESC LIMIT ", NULL);
#line 174 "../src/database.vala"
		_tmp14_ = _tmp13_;
#line 174 "../src/database.vala"
		_tmp15_ = bookworm_app_bookworm_no_of_books_per_page;
#line 174 "../src/database.vala"
		_tmp16_ = g_strconcat (_tmp14_, _tmp15_, NULL);
#line 174 "../src/database.vala"
		_g_free0 (bookworm_app_db_queryString);
#line 174 "../src/database.vala"
		bookworm_app_db_queryString = _tmp16_;
#line 174 "../src/database.vala"
		_g_free0 (_tmp14_);
#line 175 "../src/database.vala"
		_tmp17_ = g_strconcat ("Paginated Query with last_modification_date[", criteria, NULL);
#line 175 "../src/database.vala"
		_tmp18_ = _tmp17_;
#line 175 "../src/database.vala"
		_tmp19_ = g_strconcat (_tmp18_, "]:", NULL);
#line 175 "../src/database.vala"
		_tmp20_ = _tmp19_;
#line 175 "../src/database.vala"
		_tmp21_ = bookworm_app_db_queryString;
#line 175 "../src/database.vala"
		_tmp22_ = g_strconcat (_tmp20_, _tmp21_, NULL);
#line 175 "../src/database.vala"
		_tmp23_ = _tmp22_;
#line 175 "../src/database.vala"
		g_debug ("database.vala:175: %s", _tmp23_);
#line 175 "../src/database.vala"
		_g_free0 (_tmp23_);
#line 175 "../src/database.vala"
		_g_free0 (_tmp20_);
#line 175 "../src/database.vala"
		_g_free0 (_tmp18_);
#line 1162 "database.c"
	} else {
#line 176 "../src/database.vala"
		if (g_strcmp0 (mode, "LIBRARY_SEARCH") == 0) {
#line 1166 "database.c"
			const gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			gchar* _tmp45_;
			gchar* _tmp46_;
			gchar* _tmp47_;
			gchar* _tmp48_;
			gchar* _tmp49_;
			gchar* _tmp50_;
			gchar* _tmp51_;
			gchar* _tmp52_;
			gchar* _tmp53_;
			gchar* _tmp54_;
			gchar* _tmp55_;
			gchar* _tmp56_;
			gchar* _tmp57_;
			gchar* _tmp58_;
			gchar* _tmp59_;
			const gchar* _tmp60_;
			gchar* _tmp61_;
			gchar* _tmp62_;
#line 178 "../src/database.vala"
			_tmp24_ = bookworm_app_db_queryString;
#line 178 "../src/database.vala"
			_tmp25_ = g_strconcat (_tmp24_, " WHERE ", NULL);
#line 178 "../src/database.vala"
			_tmp26_ = _tmp25_;
#line 178 "../src/database.vala"
			_tmp27_ = g_strconcat (_tmp26_, " BOOK_TITLE LIKE '%", NULL);
#line 178 "../src/database.vala"
			_tmp28_ = _tmp27_;
#line 178 "../src/database.vala"
			_tmp29_ = g_strconcat (_tmp28_, criteria, NULL);
#line 178 "../src/database.vala"
			_tmp30_ = _tmp29_;
#line 178 "../src/database.vala"
			_tmp31_ = g_strconcat (_tmp30_, "%' OR ", NULL);
#line 178 "../src/database.vala"
			_tmp32_ = _tmp31_;
#line 178 "../src/database.vala"
			_tmp33_ = g_strconcat (_tmp32_, " BOOK_LOCATION LIKE '%", NULL);
#line 178 "../src/database.vala"
			_tmp34_ = _tmp33_;
#line 178 "../src/database.vala"
			_tmp35_ = g_strconcat (_tmp34_, criteria, NULL);
#line 178 "../src/database.vala"
			_tmp36_ = _tmp35_;
#line 178 "../src/database.vala"
			_tmp37_ = g_strconcat (_tmp36_, "%' OR ", NULL);
#line 178 "../src/database.vala"
			_tmp38_ = _tmp37_;
#line 178 "../src/database.vala"
			_tmp39_ = g_strconcat (_tmp38_, " BOOK_AUTHOR LIKE '%", NULL);
#line 178 "../src/database.vala"
			_tmp40_ = _tmp39_;
#line 178 "../src/database.vala"
			_tmp41_ = g_strconcat (_tmp40_, criteria, NULL);
#line 178 "../src/database.vala"
			_tmp42_ = _tmp41_;
#line 178 "../src/database.vala"
			_tmp43_ = g_strconcat (_tmp42_, "%' OR ", NULL);
#line 178 "../src/database.vala"
			_tmp44_ = _tmp43_;
#line 178 "../src/database.vala"
			_tmp45_ = g_strconcat (_tmp44_, " TAGS LIKE '%", NULL);
#line 178 "../src/database.vala"
			_tmp46_ = _tmp45_;
#line 178 "../src/database.vala"
			_tmp47_ = g_strconcat (_tmp46_, criteria, NULL);
#line 178 "../src/database.vala"
			_tmp48_ = _tmp47_;
#line 178 "../src/database.vala"
			_tmp49_ = g_strconcat (_tmp48_, "%' OR ", NULL);
#line 178 "../src/database.vala"
			_tmp50_ = _tmp49_;
#line 178 "../src/database.vala"
			_tmp51_ = g_strconcat (_tmp50_, " ANNOTATION_TAGS LIKE '%", NULL);
#line 178 "../src/database.vala"
			_tmp52_ = _tmp51_;
#line 178 "../src/database.vala"
			_tmp53_ = g_strconcat (_tmp52_, criteria, NULL);
#line 178 "../src/database.vala"
			_tmp54_ = _tmp53_;
#line 178 "../src/database.vala"
			_tmp55_ = g_strconcat (_tmp54_, "%'", NULL);
#line 178 "../src/database.vala"
			_g_free0 (bookworm_app_db_queryString);
#line 178 "../src/database.vala"
			bookworm_app_db_queryString = _tmp55_;
#line 178 "../src/database.vala"
			_g_free0 (_tmp54_);
#line 178 "../src/database.vala"
			_g_free0 (_tmp52_);
#line 178 "../src/database.vala"
			_g_free0 (_tmp50_);
#line 178 "../src/database.vala"
			_g_free0 (_tmp48_);
#line 178 "../src/database.vala"
			_g_free0 (_tmp46_);
#line 178 "../src/database.vala"
			_g_free0 (_tmp44_);
#line 178 "../src/database.vala"
			_g_free0 (_tmp42_);
#line 178 "../src/database.vala"
			_g_free0 (_tmp40_);
#line 178 "../src/database.vala"
			_g_free0 (_tmp38_);
#line 178 "../src/database.vala"
			_g_free0 (_tmp36_);
#line 178 "../src/database.vala"
			_g_free0 (_tmp34_);
#line 178 "../src/database.vala"
			_g_free0 (_tmp32_);
#line 178 "../src/database.vala"
			_g_free0 (_tmp30_);
#line 178 "../src/database.vala"
			_g_free0 (_tmp28_);
#line 178 "../src/database.vala"
			_g_free0 (_tmp26_);
#line 184 "../src/database.vala"
			_tmp56_ = g_strconcat ("Library Search Query with criteria[", criteria, NULL);
#line 184 "../src/database.vala"
			_tmp57_ = _tmp56_;
#line 184 "../src/database.vala"
			_tmp58_ = g_strconcat (_tmp57_, "]:", NULL);
#line 184 "../src/database.vala"
			_tmp59_ = _tmp58_;
#line 184 "../src/database.vala"
			_tmp60_ = bookworm_app_db_queryString;
#line 184 "../src/database.vala"
			_tmp61_ = g_strconcat (_tmp59_, _tmp60_, NULL);
#line 184 "../src/database.vala"
			_tmp62_ = _tmp61_;
#line 184 "../src/database.vala"
			g_debug ("database.vala:184: %s", _tmp62_);
#line 184 "../src/database.vala"
			_g_free0 (_tmp62_);
#line 184 "../src/database.vala"
			_g_free0 (_tmp59_);
#line 184 "../src/database.vala"
			_g_free0 (_tmp57_);
#line 1326 "database.c"
		} else {
#line 185 "../src/database.vala"
			if (g_strcmp0 (mode, "PAGINATED_SEARCH") == 0) {
#line 1330 "database.c"
				const gchar* _tmp63_;
				gchar* _tmp64_;
				gchar* _tmp65_;
				gchar* _tmp66_;
				gchar* _tmp67_;
				gchar* _tmp68_;
				gchar* _tmp69_;
				gchar* _tmp70_;
				gchar* _tmp71_;
				const gchar* _tmp72_;
				gchar* _tmp73_;
				gchar* _tmp74_;
				gchar* _tmp75_;
				gchar* _tmp76_;
				gchar* _tmp77_;
				const gchar* _tmp78_;
				gchar* _tmp79_;
				gchar* _tmp80_;
#line 187 "../src/database.vala"
				_tmp63_ = bookworm_app_db_queryString;
#line 187 "../src/database.vala"
				_tmp64_ = g_strconcat (_tmp63_, " where modification_date  < CAST('", NULL);
#line 187 "../src/database.vala"
				_tmp65_ = _tmp64_;
#line 187 "../src/database.vala"
				_tmp66_ = g_strconcat (_tmp65_, criteria, NULL);
#line 187 "../src/database.vala"
				_tmp67_ = _tmp66_;
#line 187 "../src/database.vala"
				_tmp68_ = g_strconcat (_tmp67_, "' AS INT) ", NULL);
#line 187 "../src/database.vala"
				_tmp69_ = _tmp68_;
#line 187 "../src/database.vala"
				_tmp70_ = g_strconcat (_tmp69_, "ORDER BY modification_date DESC LIMIT ", NULL);
#line 187 "../src/database.vala"
				_tmp71_ = _tmp70_;
#line 187 "../src/database.vala"
				_tmp72_ = bookworm_app_bookworm_no_of_books_per_page;
#line 187 "../src/database.vala"
				_tmp73_ = g_strconcat (_tmp71_, _tmp72_, NULL);
#line 187 "../src/database.vala"
				_g_free0 (bookworm_app_db_queryString);
#line 187 "../src/database.vala"
				bookworm_app_db_queryString = _tmp73_;
#line 187 "../src/database.vala"
				_g_free0 (_tmp71_);
#line 187 "../src/database.vala"
				_g_free0 (_tmp69_);
#line 187 "../src/database.vala"
				_g_free0 (_tmp67_);
#line 187 "../src/database.vala"
				_g_free0 (_tmp65_);
#line 189 "../src/database.vala"
				_tmp74_ = g_strconcat ("Paginated Query with last_modification_date[", criteria, NULL);
#line 189 "../src/database.vala"
				_tmp75_ = _tmp74_;
#line 189 "../src/database.vala"
				_tmp76_ = g_strconcat (_tmp75_, "]:", NULL);
#line 189 "../src/database.vala"
				_tmp77_ = _tmp76_;
#line 189 "../src/database.vala"
				_tmp78_ = bookworm_app_db_queryString;
#line 189 "../src/database.vala"
				_tmp79_ = g_strconcat (_tmp77_, _tmp78_, NULL);
#line 189 "../src/database.vala"
				_tmp80_ = _tmp79_;
#line 189 "../src/database.vala"
				g_debug ("database.vala:189: %s", _tmp80_);
#line 189 "../src/database.vala"
				_g_free0 (_tmp80_);
#line 189 "../src/database.vala"
				_g_free0 (_tmp77_);
#line 189 "../src/database.vala"
				_g_free0 (_tmp75_);
#line 1405 "database.c"
			}
		}
	}
#line 191 "../src/database.vala"
	_tmp81_ = bookworm_app_db_bookwormDB;
#line 191 "../src/database.vala"
	_tmp82_ = bookworm_app_db_queryString;
#line 191 "../src/database.vala"
	_tmp83_ = bookworm_app_db_queryString;
#line 191 "../src/database.vala"
	_tmp84_ = strlen (_tmp83_);
#line 191 "../src/database.vala"
	_tmp85_ = _tmp84_;
#line 191 "../src/database.vala"
	_tmp87_ = sqlite3_prepare_v2 (_tmp81_, _tmp82_, _tmp85_, &_tmp86_, NULL);
#line 191 "../src/database.vala"
	_sqlite3_finalize0 (stmt);
#line 191 "../src/database.vala"
	stmt = _tmp86_;
#line 191 "../src/database.vala"
	bookworm_app_db_executionStatus = _tmp87_;
#line 192 "../src/database.vala"
	if (bookworm_app_db_executionStatus != SQLITE_OK) {
#line 1429 "database.c"
		const gchar* _tmp88_;
		gchar* _tmp89_;
		gchar* _tmp90_;
		sqlite3* _tmp91_;
		sqlite3* _tmp92_;
		const gchar* _tmp93_;
#line 193 "../src/database.vala"
		_tmp88_ = bookworm_app_db_queryString;
#line 193 "../src/database.vala"
		_tmp89_ = g_strconcat ("Error on executing Query:", _tmp88_, NULL);
#line 193 "../src/database.vala"
		_tmp90_ = _tmp89_;
#line 193 "../src/database.vala"
		g_debug ("database.vala:193: %s", _tmp90_);
#line 193 "../src/database.vala"
		_g_free0 (_tmp90_);
#line 194 "../src/database.vala"
		_tmp91_ = bookworm_app_db_bookwormDB;
#line 194 "../src/database.vala"
		_tmp92_ = bookworm_app_db_bookwormDB;
#line 194 "../src/database.vala"
		_tmp93_ = sqlite3_errmsg (_tmp92_);
#line 194 "../src/database.vala"
		g_warning ("database.vala:194: Error details: %d: %s\n", sqlite3_errcode (_tmp91_), _tmp93_);
#line 1454 "database.c"
	} else {
		sqlite3_stmt* _tmp245_;
#line 196 "../src/database.vala"
		while (TRUE) {
#line 1459 "database.c"
			sqlite3_stmt* _tmp94_;
			BookwormAppBook* aBook = NULL;
			BookwormAppBook* _tmp95_;
			BookwormAppBook* _tmp96_;
			sqlite3_stmt* _tmp97_;
			BookwormAppBook* _tmp98_;
			sqlite3_stmt* _tmp99_;
			const gchar* _tmp100_;
			BookwormAppBook* _tmp101_;
			sqlite3_stmt* _tmp102_;
			const gchar* _tmp103_;
			BookwormAppBook* _tmp104_;
			sqlite3_stmt* _tmp105_;
			const gchar* _tmp106_;
			BookwormAppBook* _tmp107_;
			sqlite3_stmt* _tmp108_;
			const gchar* _tmp109_;
			gboolean _tmp110_ = FALSE;
			sqlite3_stmt* _tmp111_;
			const gchar* _tmp112_;
			BookwormAppBook* _tmp113_;
			BookwormAppBook* _tmp114_;
			sqlite3_stmt* _tmp115_;
			const gchar* _tmp116_;
			BookwormAppBook* _tmp117_;
			sqlite3_stmt* _tmp118_;
			const gchar* _tmp119_;
			BookwormAppBook* _tmp120_;
			sqlite3_stmt* _tmp121_;
			const gchar* _tmp122_;
			BookwormAppBook* _tmp123_;
			sqlite3_stmt* _tmp124_;
			const gchar* _tmp125_;
			BookwormAppBook* _tmp126_;
			sqlite3_stmt* _tmp127_;
			const gchar* _tmp128_;
			BookwormAppBook* _tmp129_;
			sqlite3_stmt* _tmp130_;
			const gchar* _tmp131_;
			BookwormAppBook* _tmp132_;
			sqlite3_stmt* _tmp133_;
			const gchar* _tmp134_;
			BookwormAppBook* _tmp135_;
			sqlite3_stmt* _tmp136_;
			const gchar* _tmp137_;
			BookwormAppBook* _tmp138_;
			sqlite3_stmt* _tmp139_;
			const gchar* _tmp140_;
			sqlite3_stmt* _tmp141_;
			gchar* _tmp142_;
			gchar* _tmp143_;
			gchar* _tmp144_;
			gchar* _tmp145_;
			gchar* _tmp146_;
			gchar* _tmp147_;
			sqlite3_stmt* _tmp148_;
			const gchar* _tmp149_;
			gchar* _tmp150_;
			gchar* _tmp151_;
			gchar* _tmp152_;
			gchar* _tmp153_;
			sqlite3_stmt* _tmp154_;
			const gchar* _tmp155_;
			gchar* _tmp156_;
			gchar* _tmp157_;
			gchar* _tmp158_;
			gchar* _tmp159_;
			sqlite3_stmt* _tmp160_;
			const gchar* _tmp161_;
			gchar* _tmp162_;
			gchar* _tmp163_;
			gchar* _tmp164_;
			gchar* _tmp165_;
			sqlite3_stmt* _tmp166_;
			const gchar* _tmp167_;
			gchar* _tmp168_;
			gchar* _tmp169_;
			gchar* _tmp170_;
			gchar* _tmp171_;
			sqlite3_stmt* _tmp172_;
			const gchar* _tmp173_;
			gchar* _tmp174_;
			gchar* _tmp175_;
			gchar* _tmp176_;
			gchar* _tmp177_;
			sqlite3_stmt* _tmp178_;
			const gchar* _tmp179_;
			gchar* _tmp180_;
			gchar* _tmp181_;
			gchar* _tmp182_;
			gchar* _tmp183_;
			sqlite3_stmt* _tmp184_;
			const gchar* _tmp185_;
			gchar* _tmp186_;
			gchar* _tmp187_;
			gchar* _tmp188_;
			gchar* _tmp189_;
			sqlite3_stmt* _tmp190_;
			const gchar* _tmp191_;
			gchar* _tmp192_;
			gchar* _tmp193_;
			gchar* _tmp194_;
			gchar* _tmp195_;
			sqlite3_stmt* _tmp196_;
			const gchar* _tmp197_;
			gchar* _tmp198_;
			gchar* _tmp199_;
			gchar* _tmp200_;
			gchar* _tmp201_;
			sqlite3_stmt* _tmp202_;
			const gchar* _tmp203_;
			gchar* _tmp204_;
			gchar* _tmp205_;
			gchar* _tmp206_;
			gchar* _tmp207_;
			sqlite3_stmt* _tmp208_;
			const gchar* _tmp209_;
			gchar* _tmp210_;
			gchar* _tmp211_;
			gchar* _tmp212_;
			gchar* _tmp213_;
			sqlite3_stmt* _tmp214_;
			const gchar* _tmp215_;
			gchar* _tmp216_;
			gchar* _tmp217_;
			gchar* _tmp218_;
			gchar* _tmp219_;
			sqlite3_stmt* _tmp220_;
			const gchar* _tmp221_;
			gchar* _tmp222_;
			gchar* _tmp223_;
			gchar* _tmp224_;
			gchar* _tmp225_;
			sqlite3_stmt* _tmp226_;
			const gchar* _tmp227_;
			gchar* _tmp228_;
			gchar* _tmp229_;
			GeeArrayList* _tmp230_;
			BookwormAppBook* _tmp231_;
			GString* _tmp232_;
			BookwormAppBook* _tmp233_;
			gchar* _tmp234_;
			gchar* _tmp235_;
			BookwormAppBook* _tmp236_;
			gchar* _tmp237_;
#line 196 "../src/database.vala"
			_tmp94_ = stmt;
#line 196 "../src/database.vala"
			if (!(sqlite3_step (_tmp94_) == SQLITE_ROW)) {
#line 196 "../src/database.vala"
				break;
#line 1611 "database.c"
			}
#line 197 "../src/database.vala"
			_tmp95_ = bookworm_app_book_new ();
#line 197 "../src/database.vala"
			aBook = _tmp95_;
#line 198 "../src/database.vala"
			_tmp96_ = aBook;
#line 198 "../src/database.vala"
			_tmp97_ = stmt;
#line 198 "../src/database.vala"
			bookworm_app_book_setBookId (_tmp96_, sqlite3_column_int (_tmp97_, 0));
#line 199 "../src/database.vala"
			_tmp98_ = aBook;
#line 199 "../src/database.vala"
			_tmp99_ = stmt;
#line 199 "../src/database.vala"
			_tmp100_ = (const gchar*) sqlite3_column_text (_tmp99_, 1);
#line 199 "../src/database.vala"
			bookworm_app_book_setBookLocation (_tmp98_, _tmp100_);
#line 200 "../src/database.vala"
			_tmp101_ = aBook;
#line 200 "../src/database.vala"
			_tmp102_ = stmt;
#line 200 "../src/database.vala"
			_tmp103_ = (const gchar*) sqlite3_column_text (_tmp102_, 2);
#line 200 "../src/database.vala"
			bookworm_app_book_setBookTitle (_tmp101_, _tmp103_);
#line 201 "../src/database.vala"
			_tmp104_ = aBook;
#line 201 "../src/database.vala"
			_tmp105_ = stmt;
#line 201 "../src/database.vala"
			_tmp106_ = (const gchar*) sqlite3_column_text (_tmp105_, 3);
#line 201 "../src/database.vala"
			bookworm_app_book_setBookAuthor (_tmp104_, _tmp106_);
#line 202 "../src/database.vala"
			_tmp107_ = aBook;
#line 202 "../src/database.vala"
			_tmp108_ = stmt;
#line 202 "../src/database.vala"
			_tmp109_ = (const gchar*) sqlite3_column_text (_tmp108_, 4);
#line 202 "../src/database.vala"
			bookworm_app_book_setBookCoverLocation (_tmp107_, _tmp109_);
#line 203 "../src/database.vala"
			_tmp111_ = stmt;
#line 203 "../src/database.vala"
			_tmp112_ = (const gchar*) sqlite3_column_text (_tmp111_, 5);
#line 203 "../src/database.vala"
			if (g_strcmp0 (_tmp112_, "true") == 0) {
#line 203 "../src/database.vala"
				_tmp110_ = TRUE;
#line 1663 "database.c"
			} else {
#line 203 "../src/database.vala"
				_tmp110_ = FALSE;
#line 1667 "database.c"
			}
#line 203 "../src/database.vala"
			_tmp113_ = aBook;
#line 203 "../src/database.vala"
			bookworm_app_book_setIsBookCoverImagePresent (_tmp113_, _tmp110_);
#line 204 "../src/database.vala"
			_tmp114_ = aBook;
#line 204 "../src/database.vala"
			_tmp115_ = stmt;
#line 204 "../src/database.vala"
			_tmp116_ = (const gchar*) sqlite3_column_text (_tmp115_, 6);
#line 204 "../src/database.vala"
			bookworm_app_book_setBookPageNumber (_tmp114_, atoi (_tmp116_));
#line 205 "../src/database.vala"
			_tmp117_ = aBook;
#line 205 "../src/database.vala"
			_tmp118_ = stmt;
#line 205 "../src/database.vala"
			_tmp119_ = (const gchar*) sqlite3_column_text (_tmp118_, 7);
#line 205 "../src/database.vala"
			bookworm_app_book_setBookPublishDate (_tmp117_, _tmp119_);
#line 206 "../src/database.vala"
			_tmp120_ = aBook;
#line 206 "../src/database.vala"
			_tmp121_ = stmt;
#line 206 "../src/database.vala"
			_tmp122_ = (const gchar*) sqlite3_column_text (_tmp121_, 8);
#line 206 "../src/database.vala"
			bookworm_app_book_setBookTags (_tmp120_, _tmp122_);
#line 207 "../src/database.vala"
			_tmp123_ = aBook;
#line 207 "../src/database.vala"
			_tmp124_ = stmt;
#line 207 "../src/database.vala"
			_tmp125_ = (const gchar*) sqlite3_column_text (_tmp124_, 9);
#line 207 "../src/database.vala"
			bookworm_app_book_setAnnotationTags (_tmp123_, _tmp125_);
#line 208 "../src/database.vala"
			_tmp126_ = aBook;
#line 208 "../src/database.vala"
			_tmp127_ = stmt;
#line 208 "../src/database.vala"
			_tmp128_ = (const gchar*) sqlite3_column_text (_tmp127_, 10);
#line 208 "../src/database.vala"
			bookworm_app_book_setBookRating (_tmp126_, atoi (_tmp128_));
#line 209 "../src/database.vala"
			_tmp129_ = aBook;
#line 209 "../src/database.vala"
			_tmp130_ = stmt;
#line 209 "../src/database.vala"
			_tmp131_ = (const gchar*) sqlite3_column_text (_tmp130_, 11);
#line 209 "../src/database.vala"
			bookworm_app_book_setBookExtractionLocation (_tmp129_, _tmp131_);
#line 210 "../src/database.vala"
			_tmp132_ = aBook;
#line 210 "../src/database.vala"
			_tmp133_ = stmt;
#line 210 "../src/database.vala"
			_tmp134_ = (const gchar*) sqlite3_column_text (_tmp133_, 12);
#line 210 "../src/database.vala"
			bookworm_app_book_setBookTotalPages (_tmp132_, atoi (_tmp134_));
#line 211 "../src/database.vala"
			_tmp135_ = aBook;
#line 211 "../src/database.vala"
			_tmp136_ = stmt;
#line 211 "../src/database.vala"
			_tmp137_ = (const gchar*) sqlite3_column_text (_tmp136_, 13);
#line 211 "../src/database.vala"
			bookworm_app_book_setBookCreationDate (_tmp135_, _tmp137_);
#line 212 "../src/database.vala"
			_tmp138_ = aBook;
#line 212 "../src/database.vala"
			_tmp139_ = stmt;
#line 212 "../src/database.vala"
			_tmp140_ = (const gchar*) sqlite3_column_text (_tmp139_, 14);
#line 212 "../src/database.vala"
			bookworm_app_book_setBookLastModificationDate (_tmp138_, _tmp140_);
#line 213 "../src/database.vala"
			_tmp141_ = stmt;
#line 213 "../src/database.vala"
			_tmp142_ = g_strdup_printf ("%i", sqlite3_column_int (_tmp141_, 0));
#line 213 "../src/database.vala"
			_tmp143_ = _tmp142_;
#line 213 "../src/database.vala"
			_tmp144_ = g_strconcat ("Book details fetched from DB: id=", _tmp143_, NULL);
#line 213 "../src/database.vala"
			_tmp145_ = _tmp144_;
#line 213 "../src/database.vala"
			_tmp146_ = g_strconcat (_tmp145_, ",BOOK_LOCATION=", NULL);
#line 213 "../src/database.vala"
			_tmp147_ = _tmp146_;
#line 213 "../src/database.vala"
			_tmp148_ = stmt;
#line 213 "../src/database.vala"
			_tmp149_ = (const gchar*) sqlite3_column_text (_tmp148_, 1);
#line 213 "../src/database.vala"
			_tmp150_ = g_strconcat (_tmp147_, _tmp149_, NULL);
#line 213 "../src/database.vala"
			_tmp151_ = _tmp150_;
#line 213 "../src/database.vala"
			_tmp152_ = g_strconcat (_tmp151_, ",BOOK_TITLE=", NULL);
#line 213 "../src/database.vala"
			_tmp153_ = _tmp152_;
#line 213 "../src/database.vala"
			_tmp154_ = stmt;
#line 213 "../src/database.vala"
			_tmp155_ = (const gchar*) sqlite3_column_text (_tmp154_, 2);
#line 213 "../src/database.vala"
			_tmp156_ = g_strconcat (_tmp153_, _tmp155_, NULL);
#line 213 "../src/database.vala"
			_tmp157_ = _tmp156_;
#line 213 "../src/database.vala"
			_tmp158_ = g_strconcat (_tmp157_, ",BOOK_AUTHOR=", NULL);
#line 213 "../src/database.vala"
			_tmp159_ = _tmp158_;
#line 213 "../src/database.vala"
			_tmp160_ = stmt;
#line 213 "../src/database.vala"
			_tmp161_ = (const gchar*) sqlite3_column_text (_tmp160_, 3);
#line 213 "../src/database.vala"
			_tmp162_ = g_strconcat (_tmp159_, _tmp161_, NULL);
#line 213 "../src/database.vala"
			_tmp163_ = _tmp162_;
#line 213 "../src/database.vala"
			_tmp164_ = g_strconcat (_tmp163_, ",BOOK_COVER_IMAGE_LOCATION=", NULL);
#line 213 "../src/database.vala"
			_tmp165_ = _tmp164_;
#line 213 "../src/database.vala"
			_tmp166_ = stmt;
#line 213 "../src/database.vala"
			_tmp167_ = (const gchar*) sqlite3_column_text (_tmp166_, 4);
#line 213 "../src/database.vala"
			_tmp168_ = g_strconcat (_tmp165_, _tmp167_, NULL);
#line 213 "../src/database.vala"
			_tmp169_ = _tmp168_;
#line 213 "../src/database.vala"
			_tmp170_ = g_strconcat (_tmp169_, ",IS_BOOK_COVER_IMAGE_PRESENT=", NULL);
#line 213 "../src/database.vala"
			_tmp171_ = _tmp170_;
#line 213 "../src/database.vala"
			_tmp172_ = stmt;
#line 213 "../src/database.vala"
			_tmp173_ = (const gchar*) sqlite3_column_text (_tmp172_, 5);
#line 213 "../src/database.vala"
			_tmp174_ = g_strconcat (_tmp171_, _tmp173_, NULL);
#line 213 "../src/database.vala"
			_tmp175_ = _tmp174_;
#line 213 "../src/database.vala"
			_tmp176_ = g_strconcat (_tmp175_, ",BOOK_LAST_READ_PAGE_NUMBER=", NULL);
#line 213 "../src/database.vala"
			_tmp177_ = _tmp176_;
#line 213 "../src/database.vala"
			_tmp178_ = stmt;
#line 213 "../src/database.vala"
			_tmp179_ = (const gchar*) sqlite3_column_text (_tmp178_, 6);
#line 213 "../src/database.vala"
			_tmp180_ = g_strconcat (_tmp177_, _tmp179_, NULL);
#line 213 "../src/database.vala"
			_tmp181_ = _tmp180_;
#line 213 "../src/database.vala"
			_tmp182_ = g_strconcat (_tmp181_, ",BOOK_PUBLISH_DATE=", NULL);
#line 213 "../src/database.vala"
			_tmp183_ = _tmp182_;
#line 213 "../src/database.vala"
			_tmp184_ = stmt;
#line 213 "../src/database.vala"
			_tmp185_ = (const gchar*) sqlite3_column_text (_tmp184_, 7);
#line 213 "../src/database.vala"
			_tmp186_ = g_strconcat (_tmp183_, _tmp185_, NULL);
#line 213 "../src/database.vala"
			_tmp187_ = _tmp186_;
#line 213 "../src/database.vala"
			_tmp188_ = g_strconcat (_tmp187_, ",TAGS=", NULL);
#line 213 "../src/database.vala"
			_tmp189_ = _tmp188_;
#line 213 "../src/database.vala"
			_tmp190_ = stmt;
#line 213 "../src/database.vala"
			_tmp191_ = (const gchar*) sqlite3_column_text (_tmp190_, 8);
#line 213 "../src/database.vala"
			_tmp192_ = g_strconcat (_tmp189_, _tmp191_, NULL);
#line 213 "../src/database.vala"
			_tmp193_ = _tmp192_;
#line 213 "../src/database.vala"
			_tmp194_ = g_strconcat (_tmp193_, ",ANNOTATION_TAGS=", NULL);
#line 213 "../src/database.vala"
			_tmp195_ = _tmp194_;
#line 213 "../src/database.vala"
			_tmp196_ = stmt;
#line 213 "../src/database.vala"
			_tmp197_ = (const gchar*) sqlite3_column_text (_tmp196_, 9);
#line 213 "../src/database.vala"
			_tmp198_ = g_strconcat (_tmp195_, _tmp197_, NULL);
#line 213 "../src/database.vala"
			_tmp199_ = _tmp198_;
#line 213 "../src/database.vala"
			_tmp200_ = g_strconcat (_tmp199_, ",RATINGS=", NULL);
#line 213 "../src/database.vala"
			_tmp201_ = _tmp200_;
#line 213 "../src/database.vala"
			_tmp202_ = stmt;
#line 213 "../src/database.vala"
			_tmp203_ = (const gchar*) sqlite3_column_text (_tmp202_, 10);
#line 213 "../src/database.vala"
			_tmp204_ = g_strconcat (_tmp201_, _tmp203_, NULL);
#line 213 "../src/database.vala"
			_tmp205_ = _tmp204_;
#line 213 "../src/database.vala"
			_tmp206_ = g_strconcat (_tmp205_, ",CONTENT_EXTRACTION_LOCATION=", NULL);
#line 213 "../src/database.vala"
			_tmp207_ = _tmp206_;
#line 213 "../src/database.vala"
			_tmp208_ = stmt;
#line 213 "../src/database.vala"
			_tmp209_ = (const gchar*) sqlite3_column_text (_tmp208_, 11);
#line 213 "../src/database.vala"
			_tmp210_ = g_strconcat (_tmp207_, _tmp209_, NULL);
#line 213 "../src/database.vala"
			_tmp211_ = _tmp210_;
#line 213 "../src/database.vala"
			_tmp212_ = g_strconcat (_tmp211_, ",BOOK_TOTAL_PAGES=", NULL);
#line 213 "../src/database.vala"
			_tmp213_ = _tmp212_;
#line 213 "../src/database.vala"
			_tmp214_ = stmt;
#line 213 "../src/database.vala"
			_tmp215_ = (const gchar*) sqlite3_column_text (_tmp214_, 12);
#line 213 "../src/database.vala"
			_tmp216_ = g_strconcat (_tmp213_, _tmp215_, NULL);
#line 213 "../src/database.vala"
			_tmp217_ = _tmp216_;
#line 213 "../src/database.vala"
			_tmp218_ = g_strconcat (_tmp217_, ",creation_date=", NULL);
#line 213 "../src/database.vala"
			_tmp219_ = _tmp218_;
#line 213 "../src/database.vala"
			_tmp220_ = stmt;
#line 213 "../src/database.vala"
			_tmp221_ = (const gchar*) sqlite3_column_text (_tmp220_, 13);
#line 213 "../src/database.vala"
			_tmp222_ = g_strconcat (_tmp219_, _tmp221_, NULL);
#line 213 "../src/database.vala"
			_tmp223_ = _tmp222_;
#line 213 "../src/database.vala"
			_tmp224_ = g_strconcat (_tmp223_, ",modification_date=", NULL);
#line 213 "../src/database.vala"
			_tmp225_ = _tmp224_;
#line 213 "../src/database.vala"
			_tmp226_ = stmt;
#line 213 "../src/database.vala"
			_tmp227_ = (const gchar*) sqlite3_column_text (_tmp226_, 14);
#line 213 "../src/database.vala"
			_tmp228_ = g_strconcat (_tmp225_, _tmp227_, NULL);
#line 213 "../src/database.vala"
			_tmp229_ = _tmp228_;
#line 213 "../src/database.vala"
			g_debug ("database.vala:213: %s", _tmp229_);
#line 213 "../src/database.vala"
			_g_free0 (_tmp229_);
#line 213 "../src/database.vala"
			_g_free0 (_tmp225_);
#line 213 "../src/database.vala"
			_g_free0 (_tmp223_);
#line 213 "../src/database.vala"
			_g_free0 (_tmp219_);
#line 213 "../src/database.vala"
			_g_free0 (_tmp217_);
#line 213 "../src/database.vala"
			_g_free0 (_tmp213_);
#line 213 "../src/database.vala"
			_g_free0 (_tmp211_);
#line 213 "../src/database.vala"
			_g_free0 (_tmp207_);
#line 213 "../src/database.vala"
			_g_free0 (_tmp205_);
#line 213 "../src/database.vala"
			_g_free0 (_tmp201_);
#line 213 "../src/database.vala"
			_g_free0 (_tmp199_);
#line 213 "../src/database.vala"
			_g_free0 (_tmp195_);
#line 213 "../src/database.vala"
			_g_free0 (_tmp193_);
#line 213 "../src/database.vala"
			_g_free0 (_tmp189_);
#line 213 "../src/database.vala"
			_g_free0 (_tmp187_);
#line 213 "../src/database.vala"
			_g_free0 (_tmp183_);
#line 213 "../src/database.vala"
			_g_free0 (_tmp181_);
#line 213 "../src/database.vala"
			_g_free0 (_tmp177_);
#line 213 "../src/database.vala"
			_g_free0 (_tmp175_);
#line 213 "../src/database.vala"
			_g_free0 (_tmp171_);
#line 213 "../src/database.vala"
			_g_free0 (_tmp169_);
#line 213 "../src/database.vala"
			_g_free0 (_tmp165_);
#line 213 "../src/database.vala"
			_g_free0 (_tmp163_);
#line 213 "../src/database.vala"
			_g_free0 (_tmp159_);
#line 213 "../src/database.vala"
			_g_free0 (_tmp157_);
#line 213 "../src/database.vala"
			_g_free0 (_tmp153_);
#line 213 "../src/database.vala"
			_g_free0 (_tmp151_);
#line 213 "../src/database.vala"
			_g_free0 (_tmp147_);
#line 213 "../src/database.vala"
			_g_free0 (_tmp145_);
#line 213 "../src/database.vala"
			_g_free0 (_tmp143_);
#line 230 "../src/database.vala"
			_tmp230_ = listOfBooks;
#line 230 "../src/database.vala"
			_tmp231_ = aBook;
#line 230 "../src/database.vala"
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp230_, _tmp231_);
#line 232 "../src/database.vala"
			_tmp232_ = bookworm_app_bookworm_pathsOfBooksInLibraryOnLoadStr;
#line 232 "../src/database.vala"
			_tmp233_ = aBook;
#line 232 "../src/database.vala"
			_tmp234_ = bookworm_app_book_getBookLocation (_tmp233_);
#line 232 "../src/database.vala"
			_tmp235_ = _tmp234_;
#line 232 "../src/database.vala"
			g_string_append (_tmp232_, _tmp235_);
#line 232 "../src/database.vala"
			_g_free0 (_tmp235_);
#line 234 "../src/database.vala"
			_tmp236_ = aBook;
#line 234 "../src/database.vala"
			_tmp237_ = bookworm_app_book_getBookLastModificationDate (_tmp236_);
#line 234 "../src/database.vala"
			_g_free0 (last_modification_date);
#line 234 "../src/database.vala"
			last_modification_date = _tmp237_;
#line 196 "../src/database.vala"
			_bookworm_app_book_unref0 (aBook);
#line 2013 "database.c"
		}
#line 236 "../src/database.vala"
		if (g_strcmp0 (mode, "PAGINATED_SEARCH") == 0) {
#line 2017 "database.c"
			GeeArrayList* _tmp238_;
			gint _tmp239_;
			gint _tmp240_;
			const gchar* _tmp241_;
#line 238 "../src/database.vala"
			_tmp238_ = listOfBooks;
#line 238 "../src/database.vala"
			_tmp239_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp238_);
#line 238 "../src/database.vala"
			_tmp240_ = _tmp239_;
#line 238 "../src/database.vala"
			_tmp241_ = bookworm_app_bookworm_no_of_books_per_page;
#line 238 "../src/database.vala"
			if (_tmp240_ == atoi (_tmp241_)) {
#line 2032 "database.c"
				GeeArrayList* _tmp242_;
				const gchar* _tmp243_;
#line 240 "../src/database.vala"
				_tmp242_ = bookworm_app_bookworm_paginationlist;
#line 240 "../src/database.vala"
				_tmp243_ = last_modification_date;
#line 240 "../src/database.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp242_, _tmp243_);
#line 2041 "database.c"
			} else {
				GeeArrayList* _tmp244_;
#line 242 "../src/database.vala"
				_tmp244_ = bookworm_app_bookworm_paginationlist;
#line 242 "../src/database.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp244_, "-1");
#line 2048 "database.c"
			}
		}
#line 245 "../src/database.vala"
		_tmp245_ = stmt;
#line 245 "../src/database.vala"
		sqlite3_reset (_tmp245_);
#line 2055 "database.c"
	}
#line 247 "../src/database.vala"
	_tmp246_ = listOfBooks;
#line 247 "../src/database.vala"
	_tmp247_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp246_);
#line 247 "../src/database.vala"
	_tmp248_ = _tmp247_;
#line 247 "../src/database.vala"
	_tmp249_ = g_strdup_printf ("%i", _tmp248_);
#line 247 "../src/database.vala"
	_tmp250_ = _tmp249_;
#line 247 "../src/database.vala"
	_tmp251_ = g_strconcat ("[END] [FUNCTION:getBooksFromDB] no. of books fetched [", _tmp250_, NULL);
#line 247 "../src/database.vala"
	_tmp252_ = _tmp251_;
#line 247 "../src/database.vala"
	_tmp253_ = g_strconcat (_tmp252_, "], last_modification_date of books fetched[", NULL);
#line 247 "../src/database.vala"
	_tmp254_ = _tmp253_;
#line 247 "../src/database.vala"
	_tmp255_ = last_modification_date;
#line 247 "../src/database.vala"
	_tmp256_ = g_strconcat (_tmp254_, _tmp255_, NULL);
#line 247 "../src/database.vala"
	_tmp257_ = _tmp256_;
#line 247 "../src/database.vala"
	_tmp258_ = g_strconcat (_tmp257_, "]", NULL);
#line 247 "../src/database.vala"
	_tmp259_ = _tmp258_;
#line 247 "../src/database.vala"
	g_info ("database.vala:247: %s", _tmp259_);
#line 247 "../src/database.vala"
	_g_free0 (_tmp259_);
#line 247 "../src/database.vala"
	_g_free0 (_tmp257_);
#line 247 "../src/database.vala"
	_g_free0 (_tmp254_);
#line 247 "../src/database.vala"
	_g_free0 (_tmp252_);
#line 247 "../src/database.vala"
	_g_free0 (_tmp250_);
#line 248 "../src/database.vala"
	result = listOfBooks;
#line 248 "../src/database.vala"
	_g_free0 (last_modification_date);
#line 248 "../src/database.vala"
	_sqlite3_finalize0 (stmt);
#line 248 "../src/database.vala"
	return result;
#line 2105 "database.c"
}

BookwormAppBook*
bookworm_app_db_getBookFromDB (const gchar* book_location)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	sqlite3_stmt* stmt = NULL;
	BookwormAppBook* aBook = NULL;
	BookwormAppBook* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	sqlite3* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	sqlite3_stmt* _tmp24_ = NULL;
	gint _tmp25_;
	sqlite3_stmt* _tmp167_;
	BookwormAppBook* _tmp168_;
	gchar* _tmp169_;
	gchar* _tmp170_;
	gchar* _tmp171_;
	gchar* _tmp172_;
	gchar* _tmp173_;
	gchar* _tmp174_;
	BookwormAppBook* result;
#line 251 "../src/database.vala"
	g_return_val_if_fail (book_location != NULL, NULL);
#line 252 "../src/database.vala"
	_tmp0_ = g_strconcat ("[START] [FUNCTION:getBookFromDB] Attempting to search DB for book.loca" \
"tion=", book_location, NULL);
#line 252 "../src/database.vala"
	_tmp1_ = _tmp0_;
#line 252 "../src/database.vala"
	g_info ("database.vala:252: %s", _tmp1_);
#line 252 "../src/database.vala"
	_g_free0 (_tmp1_);
#line 254 "../src/database.vala"
	_tmp2_ = bookworm_app_book_new ();
#line 254 "../src/database.vala"
	aBook = _tmp2_;
#line 255 "../src/database.vala"
	_tmp3_ = g_strdup ("SELECT id, BOOK_LOCATION, BOOK_TITLE, BOOK_AUTHOR, BOOK_COVER_IMAGE_LO" \
"CATION, IS_BOOK_COVER_IMAGE_PRESENT, BOOK_LAST_READ_PAGE_NUMBER, BOOK_" \
"PUBLISH_DATE, TAGS, ANNOTATION_TAGS, RATINGS, CONTENT_EXTRACTION_LOCAT" \
"ION, BOOK_TOTAL_PAGES, creation_date, modification_date FROM " BOOKWORM_APP_DB_BOOKWORM_TABLE_BASE_NAME BOOKWORM_APP_DB_BOOKWORM_TABLE_VERSION);
#line 255 "../src/database.vala"
	_g_free0 (bookworm_app_db_queryString);
#line 255 "../src/database.vala"
	bookworm_app_db_queryString = _tmp3_;
#line 257 "../src/database.vala"
	_tmp4_ = bookworm_app_db_queryString;
#line 257 "../src/database.vala"
	_tmp5_ = g_strconcat (_tmp4_, " WHERE ", NULL);
#line 257 "../src/database.vala"
	_tmp6_ = _tmp5_;
#line 257 "../src/database.vala"
	_tmp7_ = g_strconcat (_tmp6_, " BOOK_LOCATION LIKE '", NULL);
#line 257 "../src/database.vala"
	_tmp8_ = _tmp7_;
#line 257 "../src/database.vala"
	_tmp9_ = g_strconcat (_tmp8_, book_location, NULL);
#line 257 "../src/database.vala"
	_tmp10_ = _tmp9_;
#line 257 "../src/database.vala"
	_tmp11_ = g_strconcat (_tmp10_, "'", NULL);
#line 257 "../src/database.vala"
	_g_free0 (bookworm_app_db_queryString);
#line 257 "../src/database.vala"
	bookworm_app_db_queryString = _tmp11_;
#line 257 "../src/database.vala"
	_g_free0 (_tmp10_);
#line 257 "../src/database.vala"
	_g_free0 (_tmp8_);
#line 257 "../src/database.vala"
	_g_free0 (_tmp6_);
#line 258 "../src/database.vala"
	_tmp12_ = g_strconcat ("Library Search Query with criteria[", book_location, NULL);
#line 258 "../src/database.vala"
	_tmp13_ = _tmp12_;
#line 258 "../src/database.vala"
	_tmp14_ = g_strconcat (_tmp13_, "]:", NULL);
#line 258 "../src/database.vala"
	_tmp15_ = _tmp14_;
#line 258 "../src/database.vala"
	_tmp16_ = bookworm_app_db_queryString;
#line 258 "../src/database.vala"
	_tmp17_ = g_strconcat (_tmp15_, _tmp16_, NULL);
#line 258 "../src/database.vala"
	_tmp18_ = _tmp17_;
#line 258 "../src/database.vala"
	g_debug ("database.vala:258: %s", _tmp18_);
#line 258 "../src/database.vala"
	_g_free0 (_tmp18_);
#line 258 "../src/database.vala"
	_g_free0 (_tmp15_);
#line 258 "../src/database.vala"
	_g_free0 (_tmp13_);
#line 259 "../src/database.vala"
	_tmp19_ = bookworm_app_db_bookwormDB;
#line 259 "../src/database.vala"
	_tmp20_ = bookworm_app_db_queryString;
#line 259 "../src/database.vala"
	_tmp21_ = bookworm_app_db_queryString;
#line 259 "../src/database.vala"
	_tmp22_ = strlen (_tmp21_);
#line 259 "../src/database.vala"
	_tmp23_ = _tmp22_;
#line 259 "../src/database.vala"
	_tmp25_ = sqlite3_prepare_v2 (_tmp19_, _tmp20_, _tmp23_, &_tmp24_, NULL);
#line 259 "../src/database.vala"
	_sqlite3_finalize0 (stmt);
#line 259 "../src/database.vala"
	stmt = _tmp24_;
#line 259 "../src/database.vala"
	bookworm_app_db_executionStatus = _tmp25_;
#line 260 "../src/database.vala"
	if (bookworm_app_db_executionStatus != SQLITE_OK) {
#line 2236 "database.c"
		const gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		sqlite3* _tmp29_;
		sqlite3* _tmp30_;
		const gchar* _tmp31_;
#line 261 "../src/database.vala"
		_tmp26_ = bookworm_app_db_queryString;
#line 261 "../src/database.vala"
		_tmp27_ = g_strconcat ("Error on executing Query:", _tmp26_, NULL);
#line 261 "../src/database.vala"
		_tmp28_ = _tmp27_;
#line 261 "../src/database.vala"
		g_debug ("database.vala:261: %s", _tmp28_);
#line 261 "../src/database.vala"
		_g_free0 (_tmp28_);
#line 262 "../src/database.vala"
		_tmp29_ = bookworm_app_db_bookwormDB;
#line 262 "../src/database.vala"
		_tmp30_ = bookworm_app_db_bookwormDB;
#line 262 "../src/database.vala"
		_tmp31_ = sqlite3_errmsg (_tmp30_);
#line 262 "../src/database.vala"
		g_warning ("database.vala:262: Error details: %d: %s\n", sqlite3_errcode (_tmp29_), _tmp31_);
#line 2261 "database.c"
	} else {
#line 264 "../src/database.vala"
		while (TRUE) {
#line 2265 "database.c"
			sqlite3_stmt* _tmp32_;
			BookwormAppBook* _tmp33_;
			sqlite3_stmt* _tmp34_;
			BookwormAppBook* _tmp35_;
			sqlite3_stmt* _tmp36_;
			const gchar* _tmp37_;
			BookwormAppBook* _tmp38_;
			sqlite3_stmt* _tmp39_;
			const gchar* _tmp40_;
			BookwormAppBook* _tmp41_;
			sqlite3_stmt* _tmp42_;
			const gchar* _tmp43_;
			BookwormAppBook* _tmp44_;
			sqlite3_stmt* _tmp45_;
			const gchar* _tmp46_;
			gboolean _tmp47_ = FALSE;
			sqlite3_stmt* _tmp48_;
			const gchar* _tmp49_;
			BookwormAppBook* _tmp50_;
			BookwormAppBook* _tmp51_;
			sqlite3_stmt* _tmp52_;
			const gchar* _tmp53_;
			BookwormAppBook* _tmp54_;
			sqlite3_stmt* _tmp55_;
			const gchar* _tmp56_;
			BookwormAppBook* _tmp57_;
			sqlite3_stmt* _tmp58_;
			const gchar* _tmp59_;
			BookwormAppBook* _tmp60_;
			sqlite3_stmt* _tmp61_;
			const gchar* _tmp62_;
			BookwormAppBook* _tmp63_;
			sqlite3_stmt* _tmp64_;
			const gchar* _tmp65_;
			BookwormAppBook* _tmp66_;
			sqlite3_stmt* _tmp67_;
			const gchar* _tmp68_;
			BookwormAppBook* _tmp69_;
			sqlite3_stmt* _tmp70_;
			const gchar* _tmp71_;
			BookwormAppBook* _tmp72_;
			sqlite3_stmt* _tmp73_;
			const gchar* _tmp74_;
			BookwormAppBook* _tmp75_;
			sqlite3_stmt* _tmp76_;
			const gchar* _tmp77_;
			sqlite3_stmt* _tmp78_;
			gchar* _tmp79_;
			gchar* _tmp80_;
			gchar* _tmp81_;
			gchar* _tmp82_;
			gchar* _tmp83_;
			gchar* _tmp84_;
			sqlite3_stmt* _tmp85_;
			const gchar* _tmp86_;
			gchar* _tmp87_;
			gchar* _tmp88_;
			gchar* _tmp89_;
			gchar* _tmp90_;
			sqlite3_stmt* _tmp91_;
			const gchar* _tmp92_;
			gchar* _tmp93_;
			gchar* _tmp94_;
			gchar* _tmp95_;
			gchar* _tmp96_;
			sqlite3_stmt* _tmp97_;
			const gchar* _tmp98_;
			gchar* _tmp99_;
			gchar* _tmp100_;
			gchar* _tmp101_;
			gchar* _tmp102_;
			sqlite3_stmt* _tmp103_;
			const gchar* _tmp104_;
			gchar* _tmp105_;
			gchar* _tmp106_;
			gchar* _tmp107_;
			gchar* _tmp108_;
			sqlite3_stmt* _tmp109_;
			const gchar* _tmp110_;
			gchar* _tmp111_;
			gchar* _tmp112_;
			gchar* _tmp113_;
			gchar* _tmp114_;
			sqlite3_stmt* _tmp115_;
			const gchar* _tmp116_;
			gchar* _tmp117_;
			gchar* _tmp118_;
			gchar* _tmp119_;
			gchar* _tmp120_;
			sqlite3_stmt* _tmp121_;
			const gchar* _tmp122_;
			gchar* _tmp123_;
			gchar* _tmp124_;
			gchar* _tmp125_;
			gchar* _tmp126_;
			sqlite3_stmt* _tmp127_;
			const gchar* _tmp128_;
			gchar* _tmp129_;
			gchar* _tmp130_;
			gchar* _tmp131_;
			gchar* _tmp132_;
			sqlite3_stmt* _tmp133_;
			const gchar* _tmp134_;
			gchar* _tmp135_;
			gchar* _tmp136_;
			gchar* _tmp137_;
			gchar* _tmp138_;
			sqlite3_stmt* _tmp139_;
			const gchar* _tmp140_;
			gchar* _tmp141_;
			gchar* _tmp142_;
			gchar* _tmp143_;
			gchar* _tmp144_;
			sqlite3_stmt* _tmp145_;
			const gchar* _tmp146_;
			gchar* _tmp147_;
			gchar* _tmp148_;
			gchar* _tmp149_;
			gchar* _tmp150_;
			sqlite3_stmt* _tmp151_;
			const gchar* _tmp152_;
			gchar* _tmp153_;
			gchar* _tmp154_;
			gchar* _tmp155_;
			gchar* _tmp156_;
			sqlite3_stmt* _tmp157_;
			const gchar* _tmp158_;
			gchar* _tmp159_;
			gchar* _tmp160_;
			gchar* _tmp161_;
			gchar* _tmp162_;
			sqlite3_stmt* _tmp163_;
			const gchar* _tmp164_;
			gchar* _tmp165_;
			gchar* _tmp166_;
#line 264 "../src/database.vala"
			_tmp32_ = stmt;
#line 264 "../src/database.vala"
			if (!(sqlite3_step (_tmp32_) == SQLITE_ROW)) {
#line 264 "../src/database.vala"
				break;
#line 2407 "database.c"
			}
#line 265 "../src/database.vala"
			_tmp33_ = aBook;
#line 265 "../src/database.vala"
			_tmp34_ = stmt;
#line 265 "../src/database.vala"
			bookworm_app_book_setBookId (_tmp33_, sqlite3_column_int (_tmp34_, 0));
#line 266 "../src/database.vala"
			_tmp35_ = aBook;
#line 266 "../src/database.vala"
			_tmp36_ = stmt;
#line 266 "../src/database.vala"
			_tmp37_ = (const gchar*) sqlite3_column_text (_tmp36_, 1);
#line 266 "../src/database.vala"
			bookworm_app_book_setBookLocation (_tmp35_, _tmp37_);
#line 267 "../src/database.vala"
			_tmp38_ = aBook;
#line 267 "../src/database.vala"
			_tmp39_ = stmt;
#line 267 "../src/database.vala"
			_tmp40_ = (const gchar*) sqlite3_column_text (_tmp39_, 2);
#line 267 "../src/database.vala"
			bookworm_app_book_setBookTitle (_tmp38_, _tmp40_);
#line 268 "../src/database.vala"
			_tmp41_ = aBook;
#line 268 "../src/database.vala"
			_tmp42_ = stmt;
#line 268 "../src/database.vala"
			_tmp43_ = (const gchar*) sqlite3_column_text (_tmp42_, 3);
#line 268 "../src/database.vala"
			bookworm_app_book_setBookAuthor (_tmp41_, _tmp43_);
#line 269 "../src/database.vala"
			_tmp44_ = aBook;
#line 269 "../src/database.vala"
			_tmp45_ = stmt;
#line 269 "../src/database.vala"
			_tmp46_ = (const gchar*) sqlite3_column_text (_tmp45_, 4);
#line 269 "../src/database.vala"
			bookworm_app_book_setBookCoverLocation (_tmp44_, _tmp46_);
#line 270 "../src/database.vala"
			_tmp48_ = stmt;
#line 270 "../src/database.vala"
			_tmp49_ = (const gchar*) sqlite3_column_text (_tmp48_, 5);
#line 270 "../src/database.vala"
			if (g_strcmp0 (_tmp49_, "true") == 0) {
#line 270 "../src/database.vala"
				_tmp47_ = TRUE;
#line 2455 "database.c"
			} else {
#line 270 "../src/database.vala"
				_tmp47_ = FALSE;
#line 2459 "database.c"
			}
#line 270 "../src/database.vala"
			_tmp50_ = aBook;
#line 270 "../src/database.vala"
			bookworm_app_book_setIsBookCoverImagePresent (_tmp50_, _tmp47_);
#line 271 "../src/database.vala"
			_tmp51_ = aBook;
#line 271 "../src/database.vala"
			_tmp52_ = stmt;
#line 271 "../src/database.vala"
			_tmp53_ = (const gchar*) sqlite3_column_text (_tmp52_, 6);
#line 271 "../src/database.vala"
			bookworm_app_book_setBookPageNumber (_tmp51_, atoi (_tmp53_));
#line 272 "../src/database.vala"
			_tmp54_ = aBook;
#line 272 "../src/database.vala"
			_tmp55_ = stmt;
#line 272 "../src/database.vala"
			_tmp56_ = (const gchar*) sqlite3_column_text (_tmp55_, 7);
#line 272 "../src/database.vala"
			bookworm_app_book_setBookPublishDate (_tmp54_, _tmp56_);
#line 273 "../src/database.vala"
			_tmp57_ = aBook;
#line 273 "../src/database.vala"
			_tmp58_ = stmt;
#line 273 "../src/database.vala"
			_tmp59_ = (const gchar*) sqlite3_column_text (_tmp58_, 8);
#line 273 "../src/database.vala"
			bookworm_app_book_setBookTags (_tmp57_, _tmp59_);
#line 274 "../src/database.vala"
			_tmp60_ = aBook;
#line 274 "../src/database.vala"
			_tmp61_ = stmt;
#line 274 "../src/database.vala"
			_tmp62_ = (const gchar*) sqlite3_column_text (_tmp61_, 9);
#line 274 "../src/database.vala"
			bookworm_app_book_setAnnotationTags (_tmp60_, _tmp62_);
#line 275 "../src/database.vala"
			_tmp63_ = aBook;
#line 275 "../src/database.vala"
			_tmp64_ = stmt;
#line 275 "../src/database.vala"
			_tmp65_ = (const gchar*) sqlite3_column_text (_tmp64_, 10);
#line 275 "../src/database.vala"
			bookworm_app_book_setBookRating (_tmp63_, atoi (_tmp65_));
#line 276 "../src/database.vala"
			_tmp66_ = aBook;
#line 276 "../src/database.vala"
			_tmp67_ = stmt;
#line 276 "../src/database.vala"
			_tmp68_ = (const gchar*) sqlite3_column_text (_tmp67_, 11);
#line 276 "../src/database.vala"
			bookworm_app_book_setBookExtractionLocation (_tmp66_, _tmp68_);
#line 277 "../src/database.vala"
			_tmp69_ = aBook;
#line 277 "../src/database.vala"
			_tmp70_ = stmt;
#line 277 "../src/database.vala"
			_tmp71_ = (const gchar*) sqlite3_column_text (_tmp70_, 12);
#line 277 "../src/database.vala"
			bookworm_app_book_setBookTotalPages (_tmp69_, atoi (_tmp71_));
#line 278 "../src/database.vala"
			_tmp72_ = aBook;
#line 278 "../src/database.vala"
			_tmp73_ = stmt;
#line 278 "../src/database.vala"
			_tmp74_ = (const gchar*) sqlite3_column_text (_tmp73_, 13);
#line 278 "../src/database.vala"
			bookworm_app_book_setBookCreationDate (_tmp72_, _tmp74_);
#line 279 "../src/database.vala"
			_tmp75_ = aBook;
#line 279 "../src/database.vala"
			_tmp76_ = stmt;
#line 279 "../src/database.vala"
			_tmp77_ = (const gchar*) sqlite3_column_text (_tmp76_, 14);
#line 279 "../src/database.vala"
			bookworm_app_book_setBookLastModificationDate (_tmp75_, _tmp77_);
#line 280 "../src/database.vala"
			_tmp78_ = stmt;
#line 280 "../src/database.vala"
			_tmp79_ = g_strdup_printf ("%i", sqlite3_column_int (_tmp78_, 0));
#line 280 "../src/database.vala"
			_tmp80_ = _tmp79_;
#line 280 "../src/database.vala"
			_tmp81_ = g_strconcat ("Book details fetched from DB: id=", _tmp80_, NULL);
#line 280 "../src/database.vala"
			_tmp82_ = _tmp81_;
#line 280 "../src/database.vala"
			_tmp83_ = g_strconcat (_tmp82_, ",BOOK_LOCATION=", NULL);
#line 280 "../src/database.vala"
			_tmp84_ = _tmp83_;
#line 280 "../src/database.vala"
			_tmp85_ = stmt;
#line 280 "../src/database.vala"
			_tmp86_ = (const gchar*) sqlite3_column_text (_tmp85_, 1);
#line 280 "../src/database.vala"
			_tmp87_ = g_strconcat (_tmp84_, _tmp86_, NULL);
#line 280 "../src/database.vala"
			_tmp88_ = _tmp87_;
#line 280 "../src/database.vala"
			_tmp89_ = g_strconcat (_tmp88_, ",BOOK_TITLE=", NULL);
#line 280 "../src/database.vala"
			_tmp90_ = _tmp89_;
#line 280 "../src/database.vala"
			_tmp91_ = stmt;
#line 280 "../src/database.vala"
			_tmp92_ = (const gchar*) sqlite3_column_text (_tmp91_, 2);
#line 280 "../src/database.vala"
			_tmp93_ = g_strconcat (_tmp90_, _tmp92_, NULL);
#line 280 "../src/database.vala"
			_tmp94_ = _tmp93_;
#line 280 "../src/database.vala"
			_tmp95_ = g_strconcat (_tmp94_, ",BOOK_AUTHOR=", NULL);
#line 280 "../src/database.vala"
			_tmp96_ = _tmp95_;
#line 280 "../src/database.vala"
			_tmp97_ = stmt;
#line 280 "../src/database.vala"
			_tmp98_ = (const gchar*) sqlite3_column_text (_tmp97_, 3);
#line 280 "../src/database.vala"
			_tmp99_ = g_strconcat (_tmp96_, _tmp98_, NULL);
#line 280 "../src/database.vala"
			_tmp100_ = _tmp99_;
#line 280 "../src/database.vala"
			_tmp101_ = g_strconcat (_tmp100_, ",BOOK_COVER_IMAGE_LOCATION=", NULL);
#line 280 "../src/database.vala"
			_tmp102_ = _tmp101_;
#line 280 "../src/database.vala"
			_tmp103_ = stmt;
#line 280 "../src/database.vala"
			_tmp104_ = (const gchar*) sqlite3_column_text (_tmp103_, 4);
#line 280 "../src/database.vala"
			_tmp105_ = g_strconcat (_tmp102_, _tmp104_, NULL);
#line 280 "../src/database.vala"
			_tmp106_ = _tmp105_;
#line 280 "../src/database.vala"
			_tmp107_ = g_strconcat (_tmp106_, ",IS_BOOK_COVER_IMAGE_PRESENT=", NULL);
#line 280 "../src/database.vala"
			_tmp108_ = _tmp107_;
#line 280 "../src/database.vala"
			_tmp109_ = stmt;
#line 280 "../src/database.vala"
			_tmp110_ = (const gchar*) sqlite3_column_text (_tmp109_, 5);
#line 280 "../src/database.vala"
			_tmp111_ = g_strconcat (_tmp108_, _tmp110_, NULL);
#line 280 "../src/database.vala"
			_tmp112_ = _tmp111_;
#line 280 "../src/database.vala"
			_tmp113_ = g_strconcat (_tmp112_, ",BOOK_LAST_READ_PAGE_NUMBER=", NULL);
#line 280 "../src/database.vala"
			_tmp114_ = _tmp113_;
#line 280 "../src/database.vala"
			_tmp115_ = stmt;
#line 280 "../src/database.vala"
			_tmp116_ = (const gchar*) sqlite3_column_text (_tmp115_, 6);
#line 280 "../src/database.vala"
			_tmp117_ = g_strconcat (_tmp114_, _tmp116_, NULL);
#line 280 "../src/database.vala"
			_tmp118_ = _tmp117_;
#line 280 "../src/database.vala"
			_tmp119_ = g_strconcat (_tmp118_, ",BOOK_PUBLISH_DATE=", NULL);
#line 280 "../src/database.vala"
			_tmp120_ = _tmp119_;
#line 280 "../src/database.vala"
			_tmp121_ = stmt;
#line 280 "../src/database.vala"
			_tmp122_ = (const gchar*) sqlite3_column_text (_tmp121_, 7);
#line 280 "../src/database.vala"
			_tmp123_ = g_strconcat (_tmp120_, _tmp122_, NULL);
#line 280 "../src/database.vala"
			_tmp124_ = _tmp123_;
#line 280 "../src/database.vala"
			_tmp125_ = g_strconcat (_tmp124_, ",TAGS=", NULL);
#line 280 "../src/database.vala"
			_tmp126_ = _tmp125_;
#line 280 "../src/database.vala"
			_tmp127_ = stmt;
#line 280 "../src/database.vala"
			_tmp128_ = (const gchar*) sqlite3_column_text (_tmp127_, 8);
#line 280 "../src/database.vala"
			_tmp129_ = g_strconcat (_tmp126_, _tmp128_, NULL);
#line 280 "../src/database.vala"
			_tmp130_ = _tmp129_;
#line 280 "../src/database.vala"
			_tmp131_ = g_strconcat (_tmp130_, ",ANNOTATION_TAGS=", NULL);
#line 280 "../src/database.vala"
			_tmp132_ = _tmp131_;
#line 280 "../src/database.vala"
			_tmp133_ = stmt;
#line 280 "../src/database.vala"
			_tmp134_ = (const gchar*) sqlite3_column_text (_tmp133_, 9);
#line 280 "../src/database.vala"
			_tmp135_ = g_strconcat (_tmp132_, _tmp134_, NULL);
#line 280 "../src/database.vala"
			_tmp136_ = _tmp135_;
#line 280 "../src/database.vala"
			_tmp137_ = g_strconcat (_tmp136_, ",RATINGS=", NULL);
#line 280 "../src/database.vala"
			_tmp138_ = _tmp137_;
#line 280 "../src/database.vala"
			_tmp139_ = stmt;
#line 280 "../src/database.vala"
			_tmp140_ = (const gchar*) sqlite3_column_text (_tmp139_, 10);
#line 280 "../src/database.vala"
			_tmp141_ = g_strconcat (_tmp138_, _tmp140_, NULL);
#line 280 "../src/database.vala"
			_tmp142_ = _tmp141_;
#line 280 "../src/database.vala"
			_tmp143_ = g_strconcat (_tmp142_, ",CONTENT_EXTRACTION_LOCATION=", NULL);
#line 280 "../src/database.vala"
			_tmp144_ = _tmp143_;
#line 280 "../src/database.vala"
			_tmp145_ = stmt;
#line 280 "../src/database.vala"
			_tmp146_ = (const gchar*) sqlite3_column_text (_tmp145_, 11);
#line 280 "../src/database.vala"
			_tmp147_ = g_strconcat (_tmp144_, _tmp146_, NULL);
#line 280 "../src/database.vala"
			_tmp148_ = _tmp147_;
#line 280 "../src/database.vala"
			_tmp149_ = g_strconcat (_tmp148_, ",BOOK_TOTAL_PAGES=", NULL);
#line 280 "../src/database.vala"
			_tmp150_ = _tmp149_;
#line 280 "../src/database.vala"
			_tmp151_ = stmt;
#line 280 "../src/database.vala"
			_tmp152_ = (const gchar*) sqlite3_column_text (_tmp151_, 12);
#line 280 "../src/database.vala"
			_tmp153_ = g_strconcat (_tmp150_, _tmp152_, NULL);
#line 280 "../src/database.vala"
			_tmp154_ = _tmp153_;
#line 280 "../src/database.vala"
			_tmp155_ = g_strconcat (_tmp154_, ",creation_date=", NULL);
#line 280 "../src/database.vala"
			_tmp156_ = _tmp155_;
#line 280 "../src/database.vala"
			_tmp157_ = stmt;
#line 280 "../src/database.vala"
			_tmp158_ = (const gchar*) sqlite3_column_text (_tmp157_, 13);
#line 280 "../src/database.vala"
			_tmp159_ = g_strconcat (_tmp156_, _tmp158_, NULL);
#line 280 "../src/database.vala"
			_tmp160_ = _tmp159_;
#line 280 "../src/database.vala"
			_tmp161_ = g_strconcat (_tmp160_, ",modification_date=", NULL);
#line 280 "../src/database.vala"
			_tmp162_ = _tmp161_;
#line 280 "../src/database.vala"
			_tmp163_ = stmt;
#line 280 "../src/database.vala"
			_tmp164_ = (const gchar*) sqlite3_column_text (_tmp163_, 14);
#line 280 "../src/database.vala"
			_tmp165_ = g_strconcat (_tmp162_, _tmp164_, NULL);
#line 280 "../src/database.vala"
			_tmp166_ = _tmp165_;
#line 280 "../src/database.vala"
			g_debug ("database.vala:280: %s", _tmp166_);
#line 280 "../src/database.vala"
			_g_free0 (_tmp166_);
#line 280 "../src/database.vala"
			_g_free0 (_tmp162_);
#line 280 "../src/database.vala"
			_g_free0 (_tmp160_);
#line 280 "../src/database.vala"
			_g_free0 (_tmp156_);
#line 280 "../src/database.vala"
			_g_free0 (_tmp154_);
#line 280 "../src/database.vala"
			_g_free0 (_tmp150_);
#line 280 "../src/database.vala"
			_g_free0 (_tmp148_);
#line 280 "../src/database.vala"
			_g_free0 (_tmp144_);
#line 280 "../src/database.vala"
			_g_free0 (_tmp142_);
#line 280 "../src/database.vala"
			_g_free0 (_tmp138_);
#line 280 "../src/database.vala"
			_g_free0 (_tmp136_);
#line 280 "../src/database.vala"
			_g_free0 (_tmp132_);
#line 280 "../src/database.vala"
			_g_free0 (_tmp130_);
#line 280 "../src/database.vala"
			_g_free0 (_tmp126_);
#line 280 "../src/database.vala"
			_g_free0 (_tmp124_);
#line 280 "../src/database.vala"
			_g_free0 (_tmp120_);
#line 280 "../src/database.vala"
			_g_free0 (_tmp118_);
#line 280 "../src/database.vala"
			_g_free0 (_tmp114_);
#line 280 "../src/database.vala"
			_g_free0 (_tmp112_);
#line 280 "../src/database.vala"
			_g_free0 (_tmp108_);
#line 280 "../src/database.vala"
			_g_free0 (_tmp106_);
#line 280 "../src/database.vala"
			_g_free0 (_tmp102_);
#line 280 "../src/database.vala"
			_g_free0 (_tmp100_);
#line 280 "../src/database.vala"
			_g_free0 (_tmp96_);
#line 280 "../src/database.vala"
			_g_free0 (_tmp94_);
#line 280 "../src/database.vala"
			_g_free0 (_tmp90_);
#line 280 "../src/database.vala"
			_g_free0 (_tmp88_);
#line 280 "../src/database.vala"
			_g_free0 (_tmp84_);
#line 280 "../src/database.vala"
			_g_free0 (_tmp82_);
#line 280 "../src/database.vala"
			_g_free0 (_tmp80_);
#line 2777 "database.c"
		}
	}
#line 298 "../src/database.vala"
	_tmp167_ = stmt;
#line 298 "../src/database.vala"
	sqlite3_reset (_tmp167_);
#line 299 "../src/database.vala"
	_tmp168_ = aBook;
#line 299 "../src/database.vala"
	_tmp169_ = bookworm_app_book_getBookLocation (_tmp168_);
#line 299 "../src/database.vala"
	_tmp170_ = _tmp169_;
#line 299 "../src/database.vala"
	_tmp171_ = g_strconcat ("[END] [FUNCTION:getBookFromDB] Book fetched [", _tmp170_, NULL);
#line 299 "../src/database.vala"
	_tmp172_ = _tmp171_;
#line 299 "../src/database.vala"
	_tmp173_ = g_strconcat (_tmp172_, "]", NULL);
#line 299 "../src/database.vala"
	_tmp174_ = _tmp173_;
#line 299 "../src/database.vala"
	g_info ("database.vala:299: %s", _tmp174_);
#line 299 "../src/database.vala"
	_g_free0 (_tmp174_);
#line 299 "../src/database.vala"
	_g_free0 (_tmp172_);
#line 299 "../src/database.vala"
	_g_free0 (_tmp170_);
#line 300 "../src/database.vala"
	result = aBook;
#line 300 "../src/database.vala"
	_sqlite3_finalize0 (stmt);
#line 300 "../src/database.vala"
	return result;
#line 2812 "database.c"
}

static gpointer
_bookworm_app_book_ref0 (gpointer self)
{
#line 314 "../src/database.vala"
	return self ? bookworm_app_book_ref (self) : NULL;
#line 2820 "database.c"
}

BookwormAppBook*
bookworm_app_db_getBookMetaDataFromDB (BookwormAppBook* aBook)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	sqlite3_stmt* stmt = NULL;
	gchar* _tmp4_;
	sqlite3* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	sqlite3_stmt* _tmp10_ = NULL;
	gint _tmp11_;
	sqlite3_stmt* _tmp18_;
	sqlite3_stmt* _tmp70_;
	gchar* _tmp71_;
	gchar* _tmp72_;
	gchar* _tmp73_;
	gchar* _tmp74_;
	BookwormAppBook* _tmp75_;
	BookwormAppBook* result;
#line 303 "../src/database.vala"
	g_return_val_if_fail (aBook != NULL, NULL);
#line 304 "../src/database.vala"
	_tmp0_ = bookworm_app_book_getBookLocation (aBook);
#line 304 "../src/database.vala"
	_tmp1_ = _tmp0_;
#line 304 "../src/database.vala"
	_tmp2_ = g_strconcat ("[START] [FUNCTION:getBookMetaDataFromDB] book.location=", _tmp1_, NULL);
#line 304 "../src/database.vala"
	_tmp3_ = _tmp2_;
#line 304 "../src/database.vala"
	g_info ("database.vala:304: %s", _tmp3_);
#line 304 "../src/database.vala"
	_g_free0 (_tmp3_);
#line 304 "../src/database.vala"
	_g_free0 (_tmp1_);
#line 306 "../src/database.vala"
	_tmp4_ = g_strdup ("SELECT BOOK_TOC_DATA, BOOKMARKS, CONTENT_DATA_LIST, BOOK_LAST_SCROLL_P" \
"OSITION, BOOK_ANNOTATIONS FROM " BOOKWORM_APP_DB_BOOKMETADATA_TABLE_BASE_NAME BOOKWORM_APP_DB_BOOKMETADATA_TABLE_VERSION " WHERE id = ?");
#line 306 "../src/database.vala"
	_g_free0 (bookworm_app_db_queryString);
#line 306 "../src/database.vala"
	bookworm_app_db_queryString = _tmp4_;
#line 307 "../src/database.vala"
	_tmp5_ = bookworm_app_db_bookwormDB;
#line 307 "../src/database.vala"
	_tmp6_ = bookworm_app_db_queryString;
#line 307 "../src/database.vala"
	_tmp7_ = bookworm_app_db_queryString;
#line 307 "../src/database.vala"
	_tmp8_ = strlen (_tmp7_);
#line 307 "../src/database.vala"
	_tmp9_ = _tmp8_;
#line 307 "../src/database.vala"
	_tmp11_ = sqlite3_prepare_v2 (_tmp5_, _tmp6_, _tmp9_, &_tmp10_, NULL);
#line 307 "../src/database.vala"
	_sqlite3_finalize0 (stmt);
#line 307 "../src/database.vala"
	stmt = _tmp10_;
#line 307 "../src/database.vala"
	bookworm_app_db_executionStatus = _tmp11_;
#line 308 "../src/database.vala"
	if (bookworm_app_db_executionStatus != SQLITE_OK) {
#line 2889 "database.c"
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		sqlite3* _tmp15_;
		sqlite3* _tmp16_;
		const gchar* _tmp17_;
#line 309 "../src/database.vala"
		_tmp12_ = bookworm_app_db_queryString;
#line 309 "../src/database.vala"
		_tmp13_ = g_strconcat ("Error on executing Query:", _tmp12_, NULL);
#line 309 "../src/database.vala"
		_tmp14_ = _tmp13_;
#line 309 "../src/database.vala"
		g_debug ("database.vala:309: %s", _tmp14_);
#line 309 "../src/database.vala"
		_g_free0 (_tmp14_);
#line 310 "../src/database.vala"
		_tmp15_ = bookworm_app_db_bookwormDB;
#line 310 "../src/database.vala"
		_tmp16_ = bookworm_app_db_bookwormDB;
#line 310 "../src/database.vala"
		_tmp17_ = sqlite3_errmsg (_tmp16_);
#line 310 "../src/database.vala"
		g_warning ("database.vala:310: Error details: %d: %s\n", sqlite3_errcode (_tmp15_), _tmp17_);
#line 2914 "database.c"
	}
#line 312 "../src/database.vala"
	_tmp18_ = stmt;
#line 312 "../src/database.vala"
	sqlite3_bind_int (_tmp18_, 1, bookworm_app_book_getBookId (aBook));
#line 313 "../src/database.vala"
	while (TRUE) {
#line 2922 "database.c"
		sqlite3_stmt* _tmp19_;
		BookwormAppBook* _tmp20_;
		sqlite3_stmt* _tmp21_;
		const gchar* _tmp22_;
		BookwormAppBook* _tmp23_;
		sqlite3_stmt* _tmp24_;
		const gchar* _tmp25_;
		BookwormAppBook* _tmp26_;
		sqlite3_stmt* _tmp27_;
		const gchar* _tmp28_;
		BookwormAppBook* _tmp29_;
		sqlite3_stmt* _tmp30_;
		const gchar* _tmp31_;
		sqlite3_stmt* _tmp32_;
		const gchar* _tmp33_;
		GeeTreeMap* _tmp34_;
		GeeTreeMap* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		gchar* _tmp41_;
		sqlite3_stmt* _tmp42_;
		const gchar* _tmp43_;
		gchar* _tmp44_;
		gchar* _tmp45_;
		gchar* _tmp46_;
		gchar* _tmp47_;
		sqlite3_stmt* _tmp48_;
		const gchar* _tmp49_;
		gchar* _tmp50_;
		gchar* _tmp51_;
		gchar* _tmp52_;
		gchar* _tmp53_;
		sqlite3_stmt* _tmp54_;
		const gchar* _tmp55_;
		gchar* _tmp56_;
		gchar* _tmp57_;
		gchar* _tmp58_;
		gchar* _tmp59_;
		sqlite3_stmt* _tmp60_;
		const gchar* _tmp61_;
		gchar* _tmp62_;
		gchar* _tmp63_;
		gchar* _tmp64_;
		gchar* _tmp65_;
		sqlite3_stmt* _tmp66_;
		const gchar* _tmp67_;
		gchar* _tmp68_;
		gchar* _tmp69_;
#line 313 "../src/database.vala"
		_tmp19_ = stmt;
#line 313 "../src/database.vala"
		if (!(sqlite3_step (_tmp19_) == SQLITE_ROW)) {
#line 313 "../src/database.vala"
			break;
#line 2980 "database.c"
		}
#line 314 "../src/database.vala"
		_tmp20_ = _bookworm_app_book_ref0 (aBook);
#line 314 "../src/database.vala"
		_tmp21_ = stmt;
#line 314 "../src/database.vala"
		_tmp22_ = (const gchar*) sqlite3_column_text (_tmp21_, 0);
#line 314 "../src/database.vala"
		_tmp23_ = bookworm_app_utils_convertStringToTOC (_tmp20_, _tmp22_);
#line 314 "../src/database.vala"
		_bookworm_app_book_unref0 (aBook);
#line 314 "../src/database.vala"
		aBook = _tmp23_;
#line 315 "../src/database.vala"
		_tmp24_ = stmt;
#line 315 "../src/database.vala"
		_tmp25_ = (const gchar*) sqlite3_column_text (_tmp24_, 1);
#line 315 "../src/database.vala"
		bookworm_app_book_setBookmark (aBook, -10, _tmp25_);
#line 316 "../src/database.vala"
		_tmp26_ = _bookworm_app_book_ref0 (aBook);
#line 316 "../src/database.vala"
		_tmp27_ = stmt;
#line 316 "../src/database.vala"
		_tmp28_ = (const gchar*) sqlite3_column_text (_tmp27_, 2);
#line 316 "../src/database.vala"
		_tmp29_ = bookworm_app_utils_convertStringToContentList (_tmp26_, _tmp28_);
#line 316 "../src/database.vala"
		_bookworm_app_book_unref0 (aBook);
#line 316 "../src/database.vala"
		aBook = _tmp29_;
#line 317 "../src/database.vala"
		_tmp30_ = stmt;
#line 317 "../src/database.vala"
		_tmp31_ = (const gchar*) sqlite3_column_text (_tmp30_, 3);
#line 317 "../src/database.vala"
		bookworm_app_book_setBookScrollPos (aBook, atoi (_tmp31_));
#line 318 "../src/database.vala"
		_tmp32_ = stmt;
#line 318 "../src/database.vala"
		_tmp33_ = (const gchar*) sqlite3_column_text (_tmp32_, 4);
#line 318 "../src/database.vala"
		_tmp34_ = bookworm_app_utils_convertStringToTreeMap (_tmp33_);
#line 318 "../src/database.vala"
		_tmp35_ = _tmp34_;
#line 318 "../src/database.vala"
		bookworm_app_book_setAnnotationList (aBook, _tmp35_);
#line 318 "../src/database.vala"
		_g_object_unref0 (_tmp35_);
#line 319 "../src/database.vala"
		_tmp36_ = g_strdup_printf ("%i", bookworm_app_book_getBookId (aBook));
#line 319 "../src/database.vala"
		_tmp37_ = _tmp36_;
#line 319 "../src/database.vala"
		_tmp38_ = g_strconcat ("Book MetaData details fetched from DB: id=", _tmp37_, NULL);
#line 319 "../src/database.vala"
		_tmp39_ = _tmp38_;
#line 319 "../src/database.vala"
		_tmp40_ = g_strconcat (_tmp39_, ",BOOK_TOC_DATA=", NULL);
#line 319 "../src/database.vala"
		_tmp41_ = _tmp40_;
#line 319 "../src/database.vala"
		_tmp42_ = stmt;
#line 319 "../src/database.vala"
		_tmp43_ = (const gchar*) sqlite3_column_text (_tmp42_, 0);
#line 319 "../src/database.vala"
		_tmp44_ = g_strconcat (_tmp41_, _tmp43_, NULL);
#line 319 "../src/database.vala"
		_tmp45_ = _tmp44_;
#line 319 "../src/database.vala"
		_tmp46_ = g_strconcat (_tmp45_, ",BOOKMARKS=", NULL);
#line 319 "../src/database.vala"
		_tmp47_ = _tmp46_;
#line 319 "../src/database.vala"
		_tmp48_ = stmt;
#line 319 "../src/database.vala"
		_tmp49_ = (const gchar*) sqlite3_column_text (_tmp48_, 1);
#line 319 "../src/database.vala"
		_tmp50_ = g_strconcat (_tmp47_, _tmp49_, NULL);
#line 319 "../src/database.vala"
		_tmp51_ = _tmp50_;
#line 319 "../src/database.vala"
		_tmp52_ = g_strconcat (_tmp51_, ",CONTENT_DATA_LIST=", NULL);
#line 319 "../src/database.vala"
		_tmp53_ = _tmp52_;
#line 319 "../src/database.vala"
		_tmp54_ = stmt;
#line 319 "../src/database.vala"
		_tmp55_ = (const gchar*) sqlite3_column_text (_tmp54_, 2);
#line 319 "../src/database.vala"
		_tmp56_ = g_strconcat (_tmp53_, _tmp55_, NULL);
#line 319 "../src/database.vala"
		_tmp57_ = _tmp56_;
#line 319 "../src/database.vala"
		_tmp58_ = g_strconcat (_tmp57_, ",BOOK_LAST_SCROLL_POSITION=", NULL);
#line 319 "../src/database.vala"
		_tmp59_ = _tmp58_;
#line 319 "../src/database.vala"
		_tmp60_ = stmt;
#line 319 "../src/database.vala"
		_tmp61_ = (const gchar*) sqlite3_column_text (_tmp60_, 3);
#line 319 "../src/database.vala"
		_tmp62_ = g_strconcat (_tmp59_, _tmp61_, NULL);
#line 319 "../src/database.vala"
		_tmp63_ = _tmp62_;
#line 319 "../src/database.vala"
		_tmp64_ = g_strconcat (_tmp63_, ",BOOK_ANNOTATIONS=", NULL);
#line 319 "../src/database.vala"
		_tmp65_ = _tmp64_;
#line 319 "../src/database.vala"
		_tmp66_ = stmt;
#line 319 "../src/database.vala"
		_tmp67_ = (const gchar*) sqlite3_column_text (_tmp66_, 4);
#line 319 "../src/database.vala"
		_tmp68_ = g_strconcat (_tmp65_, _tmp67_, NULL);
#line 319 "../src/database.vala"
		_tmp69_ = _tmp68_;
#line 319 "../src/database.vala"
		g_debug ("database.vala:319: %s", _tmp69_);
#line 319 "../src/database.vala"
		_g_free0 (_tmp69_);
#line 319 "../src/database.vala"
		_g_free0 (_tmp65_);
#line 319 "../src/database.vala"
		_g_free0 (_tmp63_);
#line 319 "../src/database.vala"
		_g_free0 (_tmp59_);
#line 319 "../src/database.vala"
		_g_free0 (_tmp57_);
#line 319 "../src/database.vala"
		_g_free0 (_tmp53_);
#line 319 "../src/database.vala"
		_g_free0 (_tmp51_);
#line 319 "../src/database.vala"
		_g_free0 (_tmp47_);
#line 319 "../src/database.vala"
		_g_free0 (_tmp45_);
#line 319 "../src/database.vala"
		_g_free0 (_tmp41_);
#line 319 "../src/database.vala"
		_g_free0 (_tmp39_);
#line 319 "../src/database.vala"
		_g_free0 (_tmp37_);
#line 3124 "database.c"
	}
#line 327 "../src/database.vala"
	_tmp70_ = stmt;
#line 327 "../src/database.vala"
	sqlite3_reset (_tmp70_);
#line 328 "../src/database.vala"
	_tmp71_ = bookworm_app_book_getBookLocation (aBook);
#line 328 "../src/database.vala"
	_tmp72_ = _tmp71_;
#line 328 "../src/database.vala"
	_tmp73_ = g_strconcat ("[END] [FUNCTION:getBookMetaDataFromDB] book.location=", _tmp72_, NULL);
#line 328 "../src/database.vala"
	_tmp74_ = _tmp73_;
#line 328 "../src/database.vala"
	g_info ("database.vala:328: %s", _tmp74_);
#line 328 "../src/database.vala"
	_g_free0 (_tmp74_);
#line 328 "../src/database.vala"
	_g_free0 (_tmp72_);
#line 329 "../src/database.vala"
	_tmp75_ = _bookworm_app_book_ref0 (aBook);
#line 329 "../src/database.vala"
	result = _tmp75_;
#line 329 "../src/database.vala"
	_sqlite3_finalize0 (stmt);
#line 329 "../src/database.vala"
	_bookworm_app_book_unref0 (aBook);
#line 329 "../src/database.vala"
	return result;
#line 3154 "database.c"
}

static gchar*
bool_to_string (gboolean self)
{
	gchar* result;
#line 37 "glib-2.0.vapi"
	if (self) {
#line 3163 "database.c"
		gchar* _tmp0_;
#line 38 "glib-2.0.vapi"
		_tmp0_ = g_strdup ("true");
#line 38 "glib-2.0.vapi"
		result = _tmp0_;
#line 38 "glib-2.0.vapi"
		return result;
#line 3171 "database.c"
	} else {
		gchar* _tmp1_;
#line 40 "glib-2.0.vapi"
		_tmp1_ = g_strdup ("false");
#line 40 "glib-2.0.vapi"
		result = _tmp1_;
#line 40 "glib-2.0.vapi"
		return result;
#line 3180 "database.c"
	}
}

gint
bookworm_app_db_addBookToDataBase (BookwormAppBook* aBook)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	sqlite3_stmt* stmt = NULL;
	gint insertedBookID = 0;
	gchar* _tmp4_;
	sqlite3* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	sqlite3_stmt* _tmp10_ = NULL;
	gint _tmp11_;
	sqlite3_stmt* _tmp18_;
	gchar* _tmp19_;
	GDestroyNotify _tmp20_;
	sqlite3_stmt* _tmp21_;
	gchar* _tmp22_;
	GDestroyNotify _tmp23_;
	sqlite3_stmt* _tmp24_;
	gchar* _tmp25_;
	GDestroyNotify _tmp26_;
	sqlite3_stmt* _tmp27_;
	gchar* _tmp28_;
	GDestroyNotify _tmp29_;
	sqlite3_stmt* _tmp30_;
	gchar* _tmp31_;
	GDestroyNotify _tmp32_;
	sqlite3_stmt* _tmp33_;
	gchar* _tmp34_;
	GDestroyNotify _tmp35_;
	sqlite3_stmt* _tmp36_;
	sqlite3_stmt* _tmp37_;
	gchar* _tmp38_;
	sqlite3* _tmp39_;
	const gchar* _tmp40_;
	const gchar* _tmp41_;
	gint _tmp42_;
	gint _tmp43_;
	sqlite3_stmt* _tmp44_ = NULL;
	gint _tmp45_;
	sqlite3_stmt* _tmp52_;
	gchar* _tmp53_;
	GDestroyNotify _tmp54_;
	sqlite3_stmt* _tmp57_;
	gchar* _tmp58_;
	gchar* _tmp59_;
	gchar* _tmp60_;
	gchar* _tmp61_;
	gint result;
#line 332 "../src/database.vala"
	g_return_val_if_fail (aBook != NULL, 0);
#line 333 "../src/database.vala"
	_tmp0_ = bookworm_app_book_getBookLocation (aBook);
#line 333 "../src/database.vala"
	_tmp1_ = _tmp0_;
#line 333 "../src/database.vala"
	_tmp2_ = g_strconcat ("[START] [FUNCTION:addBookToDataBase] book.location=", _tmp1_, NULL);
#line 333 "../src/database.vala"
	_tmp3_ = _tmp2_;
#line 333 "../src/database.vala"
	g_info ("database.vala:333: %s", _tmp3_);
#line 333 "../src/database.vala"
	_g_free0 (_tmp3_);
#line 333 "../src/database.vala"
	_g_free0 (_tmp1_);
#line 335 "../src/database.vala"
	insertedBookID = 0;
#line 336 "../src/database.vala"
	_tmp4_ = g_strdup ("INSERT INTO " BOOKWORM_APP_DB_BOOKWORM_TABLE_BASE_NAME BOOKWORM_APP_DB_BOOKWORM_TABLE_VERSION "(BOOK_LOCATION, BOOK_TITLE, BOOK_AUTHOR, BOOK_COVER_IMAGE_LOCATION, IS" \
"_BOOK_COVER_IMAGE_PRESENT, CONTENT_EXTRACTION_LOCATION, creation_date," \
" modification_date) " "VALUES (?,?,?,?,?,?, CAST(strftime('%s', 'now') AS INT), CAST(strftime" \
"('%s', 'now') AS INT))");
#line 336 "../src/database.vala"
	_g_free0 (bookworm_app_db_queryString);
#line 336 "../src/database.vala"
	bookworm_app_db_queryString = _tmp4_;
#line 337 "../src/database.vala"
	_tmp5_ = bookworm_app_db_bookwormDB;
#line 337 "../src/database.vala"
	_tmp6_ = bookworm_app_db_queryString;
#line 337 "../src/database.vala"
	_tmp7_ = bookworm_app_db_queryString;
#line 337 "../src/database.vala"
	_tmp8_ = strlen (_tmp7_);
#line 337 "../src/database.vala"
	_tmp9_ = _tmp8_;
#line 337 "../src/database.vala"
	_tmp11_ = sqlite3_prepare_v2 (_tmp5_, _tmp6_, _tmp9_, &_tmp10_, NULL);
#line 337 "../src/database.vala"
	_sqlite3_finalize0 (stmt);
#line 337 "../src/database.vala"
	stmt = _tmp10_;
#line 337 "../src/database.vala"
	bookworm_app_db_executionStatus = _tmp11_;
#line 338 "../src/database.vala"
	if (bookworm_app_db_executionStatus != SQLITE_OK) {
#line 3282 "database.c"
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		sqlite3* _tmp15_;
		sqlite3* _tmp16_;
		const gchar* _tmp17_;
#line 339 "../src/database.vala"
		_tmp12_ = bookworm_app_db_queryString;
#line 339 "../src/database.vala"
		_tmp13_ = g_strconcat ("Error on executing Query:", _tmp12_, NULL);
#line 339 "../src/database.vala"
		_tmp14_ = _tmp13_;
#line 339 "../src/database.vala"
		g_debug ("database.vala:339: %s", _tmp14_);
#line 339 "../src/database.vala"
		_g_free0 (_tmp14_);
#line 340 "../src/database.vala"
		_tmp15_ = bookworm_app_db_bookwormDB;
#line 340 "../src/database.vala"
		_tmp16_ = bookworm_app_db_bookwormDB;
#line 340 "../src/database.vala"
		_tmp17_ = sqlite3_errmsg (_tmp16_);
#line 340 "../src/database.vala"
		g_warning ("database.vala:340: Error details: %d: %s\n", sqlite3_errcode (_tmp15_), _tmp17_);
#line 341 "../src/database.vala"
		result = -1;
#line 341 "../src/database.vala"
		_sqlite3_finalize0 (stmt);
#line 341 "../src/database.vala"
		return result;
#line 3313 "database.c"
	}
#line 343 "../src/database.vala"
	_tmp18_ = stmt;
#line 343 "../src/database.vala"
	_tmp19_ = bookworm_app_book_getBookLocation (aBook);
#line 343 "../src/database.vala"
	_tmp20_ = g_free;
#line 343 "../src/database.vala"
	sqlite3_bind_text (_tmp18_, 1, _tmp19_, -1, _tmp20_);
#line 344 "../src/database.vala"
	_tmp21_ = stmt;
#line 344 "../src/database.vala"
	_tmp22_ = bookworm_app_book_getBookTitle (aBook);
#line 344 "../src/database.vala"
	_tmp23_ = g_free;
#line 344 "../src/database.vala"
	sqlite3_bind_text (_tmp21_, 2, _tmp22_, -1, _tmp23_);
#line 345 "../src/database.vala"
	_tmp24_ = stmt;
#line 345 "../src/database.vala"
	_tmp25_ = bookworm_app_book_getBookAuthor (aBook);
#line 345 "../src/database.vala"
	_tmp26_ = g_free;
#line 345 "../src/database.vala"
	sqlite3_bind_text (_tmp24_, 3, _tmp25_, -1, _tmp26_);
#line 346 "../src/database.vala"
	_tmp27_ = stmt;
#line 346 "../src/database.vala"
	_tmp28_ = bookworm_app_book_getBookCoverLocation (aBook);
#line 346 "../src/database.vala"
	_tmp29_ = g_free;
#line 346 "../src/database.vala"
	sqlite3_bind_text (_tmp27_, 4, _tmp28_, -1, _tmp29_);
#line 347 "../src/database.vala"
	_tmp30_ = stmt;
#line 347 "../src/database.vala"
	_tmp31_ = bool_to_string (bookworm_app_book_getIsBookCoverImagePresent (aBook));
#line 347 "../src/database.vala"
	_tmp32_ = g_free;
#line 347 "../src/database.vala"
	sqlite3_bind_text (_tmp30_, 5, _tmp31_, -1, _tmp32_);
#line 348 "../src/database.vala"
	_tmp33_ = stmt;
#line 348 "../src/database.vala"
	_tmp34_ = bookworm_app_book_getBookExtractionLocation (aBook);
#line 348 "../src/database.vala"
	_tmp35_ = g_free;
#line 348 "../src/database.vala"
	sqlite3_bind_text (_tmp33_, 6, _tmp34_, -1, _tmp35_);
#line 350 "../src/database.vala"
	_tmp36_ = stmt;
#line 350 "../src/database.vala"
	sqlite3_step (_tmp36_);
#line 351 "../src/database.vala"
	_tmp37_ = stmt;
#line 351 "../src/database.vala"
	sqlite3_reset (_tmp37_);
#line 353 "../src/database.vala"
	_tmp38_ = g_strdup ("SELECT id FROM " BOOKWORM_APP_DB_BOOKWORM_TABLE_BASE_NAME BOOKWORM_APP_DB_BOOKWORM_TABLE_VERSION " WHERE BOOK_LOCATION = ?");
#line 353 "../src/database.vala"
	_g_free0 (bookworm_app_db_queryString);
#line 353 "../src/database.vala"
	bookworm_app_db_queryString = _tmp38_;
#line 356 "../src/database.vala"
	_tmp39_ = bookworm_app_db_bookwormDB;
#line 356 "../src/database.vala"
	_tmp40_ = bookworm_app_db_queryString;
#line 356 "../src/database.vala"
	_tmp41_ = bookworm_app_db_queryString;
#line 356 "../src/database.vala"
	_tmp42_ = strlen (_tmp41_);
#line 356 "../src/database.vala"
	_tmp43_ = _tmp42_;
#line 356 "../src/database.vala"
	_tmp45_ = sqlite3_prepare_v2 (_tmp39_, _tmp40_, _tmp43_, &_tmp44_, NULL);
#line 356 "../src/database.vala"
	_sqlite3_finalize0 (stmt);
#line 356 "../src/database.vala"
	stmt = _tmp44_;
#line 356 "../src/database.vala"
	bookworm_app_db_executionStatus = _tmp45_;
#line 357 "../src/database.vala"
	if (bookworm_app_db_executionStatus != SQLITE_OK) {
#line 3397 "database.c"
		const gchar* _tmp46_;
		gchar* _tmp47_;
		gchar* _tmp48_;
		sqlite3* _tmp49_;
		sqlite3* _tmp50_;
		const gchar* _tmp51_;
#line 358 "../src/database.vala"
		_tmp46_ = bookworm_app_db_queryString;
#line 358 "../src/database.vala"
		_tmp47_ = g_strconcat ("Error on executing Query:", _tmp46_, NULL);
#line 358 "../src/database.vala"
		_tmp48_ = _tmp47_;
#line 358 "../src/database.vala"
		g_debug ("database.vala:358: %s", _tmp48_);
#line 358 "../src/database.vala"
		_g_free0 (_tmp48_);
#line 359 "../src/database.vala"
		_tmp49_ = bookworm_app_db_bookwormDB;
#line 359 "../src/database.vala"
		_tmp50_ = bookworm_app_db_bookwormDB;
#line 359 "../src/database.vala"
		_tmp51_ = sqlite3_errmsg (_tmp50_);
#line 359 "../src/database.vala"
		g_warning ("database.vala:359: Error details: %d: %s\n", sqlite3_errcode (_tmp49_), _tmp51_);
#line 3422 "database.c"
	}
#line 361 "../src/database.vala"
	_tmp52_ = stmt;
#line 361 "../src/database.vala"
	_tmp53_ = bookworm_app_book_getBookLocation (aBook);
#line 361 "../src/database.vala"
	_tmp54_ = g_free;
#line 361 "../src/database.vala"
	sqlite3_bind_text (_tmp52_, 1, _tmp53_, -1, _tmp54_);
#line 362 "../src/database.vala"
	while (TRUE) {
#line 3434 "database.c"
		sqlite3_stmt* _tmp55_;
		sqlite3_stmt* _tmp56_;
#line 362 "../src/database.vala"
		_tmp55_ = stmt;
#line 362 "../src/database.vala"
		if (!(sqlite3_step (_tmp55_) == SQLITE_ROW)) {
#line 362 "../src/database.vala"
			break;
#line 3443 "database.c"
		}
#line 363 "../src/database.vala"
		_tmp56_ = stmt;
#line 363 "../src/database.vala"
		insertedBookID = sqlite3_column_int (_tmp56_, 0);
#line 3449 "database.c"
	}
#line 365 "../src/database.vala"
	_tmp57_ = stmt;
#line 365 "../src/database.vala"
	sqlite3_reset (_tmp57_);
#line 366 "../src/database.vala"
	_tmp58_ = bookworm_app_book_getBookLocation (aBook);
#line 366 "../src/database.vala"
	_tmp59_ = _tmp58_;
#line 366 "../src/database.vala"
	_tmp60_ = g_strconcat ("[END] [FUNCTION:addBookToDataBase] book.location=", _tmp59_, NULL);
#line 366 "../src/database.vala"
	_tmp61_ = _tmp60_;
#line 366 "../src/database.vala"
	g_info ("database.vala:366: %s", _tmp61_);
#line 366 "../src/database.vala"
	_g_free0 (_tmp61_);
#line 366 "../src/database.vala"
	_g_free0 (_tmp59_);
#line 367 "../src/database.vala"
	result = insertedBookID;
#line 367 "../src/database.vala"
	_sqlite3_finalize0 (stmt);
#line 367 "../src/database.vala"
	return result;
#line 3475 "database.c"
}

gboolean
bookworm_app_db_removeBookFromDB (BookwormAppBook* aBook)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	sqlite3_stmt* stmt = NULL;
	gchar* _tmp4_;
	sqlite3* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	sqlite3_stmt* _tmp10_ = NULL;
	gint _tmp11_;
	gchar* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	gchar* _tmp53_;
	gboolean result;
#line 370 "../src/database.vala"
	g_return_val_if_fail (aBook != NULL, FALSE);
#line 371 "../src/database.vala"
	_tmp0_ = bookworm_app_book_getBookLocation (aBook);
#line 371 "../src/database.vala"
	_tmp1_ = _tmp0_;
#line 371 "../src/database.vala"
	_tmp2_ = g_strconcat ("[START] [FUNCTION:removeBookFromDB] book.location=", _tmp1_, NULL);
#line 371 "../src/database.vala"
	_tmp3_ = _tmp2_;
#line 371 "../src/database.vala"
	g_info ("database.vala:371: %s", _tmp3_);
#line 371 "../src/database.vala"
	_g_free0 (_tmp3_);
#line 371 "../src/database.vala"
	_g_free0 (_tmp1_);
#line 374 "../src/database.vala"
	_tmp4_ = g_strdup ("DELETE FROM " BOOKWORM_APP_DB_BOOKWORM_TABLE_BASE_NAME BOOKWORM_APP_DB_BOOKWORM_TABLE_VERSION " WHERE id = ?");
#line 374 "../src/database.vala"
	_g_free0 (bookworm_app_db_queryString);
#line 374 "../src/database.vala"
	bookworm_app_db_queryString = _tmp4_;
#line 375 "../src/database.vala"
	_tmp5_ = bookworm_app_db_bookwormDB;
#line 375 "../src/database.vala"
	_tmp6_ = bookworm_app_db_queryString;
#line 375 "../src/database.vala"
	_tmp7_ = bookworm_app_db_queryString;
#line 375 "../src/database.vala"
	_tmp8_ = strlen (_tmp7_);
#line 375 "../src/database.vala"
	_tmp9_ = _tmp8_;
#line 375 "../src/database.vala"
	_tmp11_ = sqlite3_prepare_v2 (_tmp5_, _tmp6_, _tmp9_, &_tmp10_, NULL);
#line 375 "../src/database.vala"
	_sqlite3_finalize0 (stmt);
#line 375 "../src/database.vala"
	stmt = _tmp10_;
#line 375 "../src/database.vala"
	bookworm_app_db_executionStatus = _tmp11_;
#line 376 "../src/database.vala"
	if (bookworm_app_db_executionStatus != SQLITE_OK) {
#line 3541 "database.c"
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		sqlite3* _tmp15_;
		sqlite3* _tmp16_;
		const gchar* _tmp17_;
#line 377 "../src/database.vala"
		_tmp12_ = bookworm_app_db_queryString;
#line 377 "../src/database.vala"
		_tmp13_ = g_strconcat ("Error on executing Query:", _tmp12_, NULL);
#line 377 "../src/database.vala"
		_tmp14_ = _tmp13_;
#line 377 "../src/database.vala"
		g_debug ("database.vala:377: %s", _tmp14_);
#line 377 "../src/database.vala"
		_g_free0 (_tmp14_);
#line 378 "../src/database.vala"
		_tmp15_ = bookworm_app_db_bookwormDB;
#line 378 "../src/database.vala"
		_tmp16_ = bookworm_app_db_bookwormDB;
#line 378 "../src/database.vala"
		_tmp17_ = sqlite3_errmsg (_tmp16_);
#line 378 "../src/database.vala"
		g_warning ("database.vala:378: Error details: %d: %s\n", sqlite3_errcode (_tmp15_), _tmp17_);
#line 379 "../src/database.vala"
		result = FALSE;
#line 379 "../src/database.vala"
		_sqlite3_finalize0 (stmt);
#line 379 "../src/database.vala"
		return result;
#line 3572 "database.c"
	} else {
		sqlite3_stmt* _tmp18_;
		sqlite3_stmt* _tmp19_;
		sqlite3_stmt* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		sqlite3* _tmp34_;
		const gchar* _tmp35_;
		const gchar* _tmp36_;
		gint _tmp37_;
		gint _tmp38_;
		sqlite3_stmt* _tmp39_ = NULL;
		gint _tmp40_;
#line 381 "../src/database.vala"
		_tmp18_ = stmt;
#line 381 "../src/database.vala"
		sqlite3_bind_int (_tmp18_, 1, bookworm_app_book_getBookId (aBook));
#line 382 "../src/database.vala"
		_tmp19_ = stmt;
#line 382 "../src/database.vala"
		sqlite3_step (_tmp19_);
#line 383 "../src/database.vala"
		_tmp20_ = stmt;
#line 383 "../src/database.vala"
		sqlite3_reset (_tmp20_);
#line 384 "../src/database.vala"
		_tmp21_ = bookworm_app_book_getBookTitle (aBook);
#line 384 "../src/database.vala"
		_tmp22_ = _tmp21_;
#line 384 "../src/database.vala"
		_tmp23_ = g_strconcat ("Removed this book from library table:", _tmp22_, NULL);
#line 384 "../src/database.vala"
		_tmp24_ = _tmp23_;
#line 384 "../src/database.vala"
		_tmp25_ = g_strconcat (_tmp24_, "[", NULL);
#line 384 "../src/database.vala"
		_tmp26_ = _tmp25_;
#line 384 "../src/database.vala"
		_tmp27_ = g_strdup_printf ("%i", bookworm_app_book_getBookId (aBook));
#line 384 "../src/database.vala"
		_tmp28_ = _tmp27_;
#line 384 "../src/database.vala"
		_tmp29_ = g_strconcat (_tmp26_, _tmp28_, NULL);
#line 384 "../src/database.vala"
		_tmp30_ = _tmp29_;
#line 384 "../src/database.vala"
		_tmp31_ = g_strconcat (_tmp30_, "]", NULL);
#line 384 "../src/database.vala"
		_tmp32_ = _tmp31_;
#line 384 "../src/database.vala"
		g_debug ("database.vala:384: %s", _tmp32_);
#line 384 "../src/database.vala"
		_g_free0 (_tmp32_);
#line 384 "../src/database.vala"
		_g_free0 (_tmp30_);
#line 384 "../src/database.vala"
		_g_free0 (_tmp28_);
#line 384 "../src/database.vala"
		_g_free0 (_tmp26_);
#line 384 "../src/database.vala"
		_g_free0 (_tmp24_);
#line 384 "../src/database.vala"
		_g_free0 (_tmp22_);
#line 387 "../src/database.vala"
		_tmp33_ = g_strdup ("DELETE FROM " BOOKWORM_APP_DB_BOOKMETADATA_TABLE_BASE_NAME BOOKWORM_APP_DB_BOOKMETADATA_TABLE_VERSION " WHERE id = ?");
#line 387 "../src/database.vala"
		_g_free0 (bookworm_app_db_queryString);
#line 387 "../src/database.vala"
		bookworm_app_db_queryString = _tmp33_;
#line 388 "../src/database.vala"
		_tmp34_ = bookworm_app_db_bookwormDB;
#line 388 "../src/database.vala"
		_tmp35_ = bookworm_app_db_queryString;
#line 388 "../src/database.vala"
		_tmp36_ = bookworm_app_db_queryString;
#line 388 "../src/database.vala"
		_tmp37_ = strlen (_tmp36_);
#line 388 "../src/database.vala"
		_tmp38_ = _tmp37_;
#line 388 "../src/database.vala"
		_tmp40_ = sqlite3_prepare_v2 (_tmp34_, _tmp35_, _tmp38_, &_tmp39_, NULL);
#line 388 "../src/database.vala"
		_sqlite3_finalize0 (stmt);
#line 388 "../src/database.vala"
		stmt = _tmp39_;
#line 388 "../src/database.vala"
		bookworm_app_db_executionStatus = _tmp40_;
#line 389 "../src/database.vala"
		if (bookworm_app_db_executionStatus != SQLITE_OK) {
#line 3673 "database.c"
			const gchar* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			sqlite3* _tmp44_;
			sqlite3* _tmp45_;
			const gchar* _tmp46_;
#line 390 "../src/database.vala"
			_tmp41_ = bookworm_app_db_queryString;
#line 390 "../src/database.vala"
			_tmp42_ = g_strconcat ("Error on executing Query:", _tmp41_, NULL);
#line 390 "../src/database.vala"
			_tmp43_ = _tmp42_;
#line 390 "../src/database.vala"
			g_debug ("database.vala:390: %s", _tmp43_);
#line 390 "../src/database.vala"
			_g_free0 (_tmp43_);
#line 391 "../src/database.vala"
			_tmp44_ = bookworm_app_db_bookwormDB;
#line 391 "../src/database.vala"
			_tmp45_ = bookworm_app_db_bookwormDB;
#line 391 "../src/database.vala"
			_tmp46_ = sqlite3_errmsg (_tmp45_);
#line 391 "../src/database.vala"
			g_warning ("database.vala:391: Error details: %d: %s\n", sqlite3_errcode (_tmp44_), _tmp46_);
#line 392 "../src/database.vala"
			result = FALSE;
#line 392 "../src/database.vala"
			_sqlite3_finalize0 (stmt);
#line 392 "../src/database.vala"
			return result;
#line 3704 "database.c"
		} else {
			sqlite3_stmt* _tmp47_;
			sqlite3_stmt* _tmp48_;
			sqlite3_stmt* _tmp49_;
#line 394 "../src/database.vala"
			_tmp47_ = stmt;
#line 394 "../src/database.vala"
			sqlite3_bind_int (_tmp47_, 1, bookworm_app_book_getBookId (aBook));
#line 395 "../src/database.vala"
			_tmp48_ = stmt;
#line 395 "../src/database.vala"
			sqlite3_step (_tmp48_);
#line 396 "../src/database.vala"
			_tmp49_ = stmt;
#line 396 "../src/database.vala"
			sqlite3_reset (_tmp49_);
#line 3721 "database.c"
		}
	}
#line 399 "../src/database.vala"
	_tmp50_ = bookworm_app_book_getBookLocation (aBook);
#line 399 "../src/database.vala"
	_tmp51_ = _tmp50_;
#line 399 "../src/database.vala"
	_tmp52_ = g_strconcat ("[END] [FUNCTION:removeBookFromDB] book.location=", _tmp51_, NULL);
#line 399 "../src/database.vala"
	_tmp53_ = _tmp52_;
#line 399 "../src/database.vala"
	g_info ("database.vala:399: %s", _tmp53_);
#line 399 "../src/database.vala"
	_g_free0 (_tmp53_);
#line 399 "../src/database.vala"
	_g_free0 (_tmp51_);
#line 400 "../src/database.vala"
	result = TRUE;
#line 400 "../src/database.vala"
	_sqlite3_finalize0 (stmt);
#line 400 "../src/database.vala"
	return result;
#line 3744 "database.c"
}

gboolean
bookworm_app_db_updateBookToDataBase (BookwormAppBook* aBook)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	sqlite3_stmt* stmt = NULL;
	gchar* _tmp4_;
	sqlite3* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	sqlite3_stmt* _tmp10_ = NULL;
	gint _tmp11_;
	sqlite3_stmt* _tmp18_;
	gchar* _tmp19_;
	GDestroyNotify _tmp20_;
	sqlite3_stmt* _tmp21_;
	gchar* _tmp22_;
	GDestroyNotify _tmp23_;
	sqlite3_stmt* _tmp24_;
	gchar* _tmp25_;
	GDestroyNotify _tmp26_;
	sqlite3_stmt* _tmp27_;
	gchar* _tmp28_;
	GDestroyNotify _tmp29_;
	sqlite3_stmt* _tmp30_;
	gchar* _tmp31_;
	GDestroyNotify _tmp32_;
	sqlite3_stmt* _tmp33_;
	gchar* _tmp34_;
	GDestroyNotify _tmp35_;
	sqlite3_stmt* _tmp36_;
	gchar* _tmp37_;
	GDestroyNotify _tmp38_;
	sqlite3_stmt* _tmp39_;
	gchar* _tmp40_;
	GDestroyNotify _tmp41_;
	sqlite3_stmt* _tmp42_;
	gchar* _tmp43_;
	GDestroyNotify _tmp44_;
	sqlite3_stmt* _tmp45_;
	gchar* _tmp46_;
	GDestroyNotify _tmp47_;
	sqlite3_stmt* _tmp48_;
	gchar* _tmp49_;
	GDestroyNotify _tmp50_;
	sqlite3_stmt* _tmp51_;
	sqlite3_stmt* _tmp52_;
	sqlite3_stmt* _tmp53_;
	gchar* _tmp54_;
	gchar* _tmp55_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	gchar* _tmp58_;
	gchar* _tmp59_;
	gchar* _tmp60_;
	gchar* _tmp61_;
	gchar* _tmp62_;
	gchar* _tmp63_;
	gchar* _tmp64_;
	gchar* _tmp65_;
	gchar* _tmp66_;
	sqlite3* _tmp67_;
	const gchar* _tmp68_;
	const gchar* _tmp69_;
	gint _tmp70_;
	gint _tmp71_;
	sqlite3_stmt* _tmp72_ = NULL;
	gint _tmp73_;
	sqlite3_stmt* _tmp80_;
	gchar* _tmp81_;
	GDestroyNotify _tmp82_;
	sqlite3_stmt* _tmp83_;
	gchar* _tmp84_;
	GDestroyNotify _tmp85_;
	sqlite3_stmt* _tmp86_;
	gchar* _tmp87_;
	GDestroyNotify _tmp88_;
	sqlite3_stmt* _tmp89_;
	gchar* _tmp90_;
	GDestroyNotify _tmp91_;
	sqlite3_stmt* _tmp92_;
	GeeTreeMap* _tmp93_;
	GeeTreeMap* _tmp94_;
	gchar* _tmp95_;
	GDestroyNotify _tmp96_;
	sqlite3_stmt* _tmp97_;
	sqlite3_stmt* _tmp98_;
	sqlite3_stmt* _tmp99_;
	sqlite3* _tmp100_;
	gchar* _tmp159_;
	gchar* _tmp160_;
	gchar* _tmp161_;
	gchar* _tmp162_;
	gboolean result;
#line 403 "../src/database.vala"
	g_return_val_if_fail (aBook != NULL, FALSE);
#line 404 "../src/database.vala"
	_tmp0_ = bookworm_app_book_to_string (aBook);
#line 404 "../src/database.vala"
	_tmp1_ = _tmp0_;
#line 404 "../src/database.vala"
	_tmp2_ = g_strconcat ("[START] [FUNCTION:updateBookToDataBase] Updating book to DB for the fo" \
"llowing details:", _tmp1_, NULL);
#line 404 "../src/database.vala"
	_tmp3_ = _tmp2_;
#line 404 "../src/database.vala"
	g_info ("database.vala:404: %s", _tmp3_);
#line 404 "../src/database.vala"
	_g_free0 (_tmp3_);
#line 404 "../src/database.vala"
	_g_free0 (_tmp1_);
#line 406 "../src/database.vala"
	_tmp4_ = g_strdup ("UPDATE " BOOKWORM_APP_DB_BOOKWORM_TABLE_BASE_NAME BOOKWORM_APP_DB_BOOKWORM_TABLE_VERSION " SET BOOK_LAST_READ_PAGE_NUMBER = ?, BOOK_TITLE = ?, BOOK_AUTHOR = ?, " \
"BOOK_COVER_IMAGE_LOCATION = ?, IS_BOOK_COVER_IMAGE_PRESENT = ?, TAGS =" \
" ?, ANNOTATION_TAGS = ?, RATINGS = ?, CONTENT_EXTRACTION_LOCATION = ?," \
" BOOK_TOTAL_PAGES = ?, modification_date = CAST(? AS INT) WHERE ID = ?" \
" ");
#line 406 "../src/database.vala"
	_g_free0 (bookworm_app_db_queryString);
#line 406 "../src/database.vala"
	bookworm_app_db_queryString = _tmp4_;
#line 408 "../src/database.vala"
	_tmp5_ = bookworm_app_db_bookwormDB;
#line 408 "../src/database.vala"
	_tmp6_ = bookworm_app_db_queryString;
#line 408 "../src/database.vala"
	_tmp7_ = bookworm_app_db_queryString;
#line 408 "../src/database.vala"
	_tmp8_ = strlen (_tmp7_);
#line 408 "../src/database.vala"
	_tmp9_ = _tmp8_;
#line 408 "../src/database.vala"
	_tmp11_ = sqlite3_prepare_v2 (_tmp5_, _tmp6_, _tmp9_, &_tmp10_, NULL);
#line 408 "../src/database.vala"
	_sqlite3_finalize0 (stmt);
#line 408 "../src/database.vala"
	stmt = _tmp10_;
#line 408 "../src/database.vala"
	bookworm_app_db_executionStatus = _tmp11_;
#line 409 "../src/database.vala"
	if (bookworm_app_db_executionStatus != SQLITE_OK) {
#line 3887 "database.c"
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		sqlite3* _tmp15_;
		sqlite3* _tmp16_;
		const gchar* _tmp17_;
#line 410 "../src/database.vala"
		_tmp12_ = bookworm_app_db_queryString;
#line 410 "../src/database.vala"
		_tmp13_ = g_strconcat ("Error on executing Query:", _tmp12_, NULL);
#line 410 "../src/database.vala"
		_tmp14_ = _tmp13_;
#line 410 "../src/database.vala"
		g_debug ("database.vala:410: %s", _tmp14_);
#line 410 "../src/database.vala"
		_g_free0 (_tmp14_);
#line 411 "../src/database.vala"
		_tmp15_ = bookworm_app_db_bookwormDB;
#line 411 "../src/database.vala"
		_tmp16_ = bookworm_app_db_bookwormDB;
#line 411 "../src/database.vala"
		_tmp17_ = sqlite3_errmsg (_tmp16_);
#line 411 "../src/database.vala"
		g_warning ("database.vala:411: Error details: %d: %s\n", sqlite3_errcode (_tmp15_), _tmp17_);
#line 412 "../src/database.vala"
		result = FALSE;
#line 412 "../src/database.vala"
		_sqlite3_finalize0 (stmt);
#line 412 "../src/database.vala"
		return result;
#line 3918 "database.c"
	}
#line 414 "../src/database.vala"
	_tmp18_ = stmt;
#line 414 "../src/database.vala"
	_tmp19_ = g_strdup_printf ("%i", bookworm_app_book_getBookPageNumber (aBook));
#line 414 "../src/database.vala"
	_tmp20_ = g_free;
#line 414 "../src/database.vala"
	sqlite3_bind_text (_tmp18_, 1, _tmp19_, -1, _tmp20_);
#line 415 "../src/database.vala"
	_tmp21_ = stmt;
#line 415 "../src/database.vala"
	_tmp22_ = bookworm_app_book_getBookTitle (aBook);
#line 415 "../src/database.vala"
	_tmp23_ = g_free;
#line 415 "../src/database.vala"
	sqlite3_bind_text (_tmp21_, 2, _tmp22_, -1, _tmp23_);
#line 416 "../src/database.vala"
	_tmp24_ = stmt;
#line 416 "../src/database.vala"
	_tmp25_ = bookworm_app_book_getBookAuthor (aBook);
#line 416 "../src/database.vala"
	_tmp26_ = g_free;
#line 416 "../src/database.vala"
	sqlite3_bind_text (_tmp24_, 3, _tmp25_, -1, _tmp26_);
#line 417 "../src/database.vala"
	_tmp27_ = stmt;
#line 417 "../src/database.vala"
	_tmp28_ = bookworm_app_book_getBookCoverLocation (aBook);
#line 417 "../src/database.vala"
	_tmp29_ = g_free;
#line 417 "../src/database.vala"
	sqlite3_bind_text (_tmp27_, 4, _tmp28_, -1, _tmp29_);
#line 418 "../src/database.vala"
	_tmp30_ = stmt;
#line 418 "../src/database.vala"
	_tmp31_ = bool_to_string (bookworm_app_book_getIsBookCoverImagePresent (aBook));
#line 418 "../src/database.vala"
	_tmp32_ = g_free;
#line 418 "../src/database.vala"
	sqlite3_bind_text (_tmp30_, 5, _tmp31_, -1, _tmp32_);
#line 419 "../src/database.vala"
	_tmp33_ = stmt;
#line 419 "../src/database.vala"
	_tmp34_ = bookworm_app_book_getBookTags (aBook);
#line 419 "../src/database.vala"
	_tmp35_ = g_free;
#line 419 "../src/database.vala"
	sqlite3_bind_text (_tmp33_, 6, _tmp34_, -1, _tmp35_);
#line 420 "../src/database.vala"
	_tmp36_ = stmt;
#line 420 "../src/database.vala"
	_tmp37_ = bookworm_app_book_getAnnotationTags (aBook);
#line 420 "../src/database.vala"
	_tmp38_ = g_free;
#line 420 "../src/database.vala"
	sqlite3_bind_text (_tmp36_, 7, _tmp37_, -1, _tmp38_);
#line 421 "../src/database.vala"
	_tmp39_ = stmt;
#line 421 "../src/database.vala"
	_tmp40_ = g_strdup_printf ("%i", bookworm_app_book_getBookRating (aBook));
#line 421 "../src/database.vala"
	_tmp41_ = g_free;
#line 421 "../src/database.vala"
	sqlite3_bind_text (_tmp39_, 8, _tmp40_, -1, _tmp41_);
#line 422 "../src/database.vala"
	_tmp42_ = stmt;
#line 422 "../src/database.vala"
	_tmp43_ = bookworm_app_book_getBookExtractionLocation (aBook);
#line 422 "../src/database.vala"
	_tmp44_ = g_free;
#line 422 "../src/database.vala"
	sqlite3_bind_text (_tmp42_, 9, _tmp43_, -1, _tmp44_);
#line 423 "../src/database.vala"
	_tmp45_ = stmt;
#line 423 "../src/database.vala"
	_tmp46_ = g_strdup_printf ("%i", bookworm_app_book_getBookTotalPages (aBook));
#line 423 "../src/database.vala"
	_tmp47_ = g_free;
#line 423 "../src/database.vala"
	sqlite3_bind_text (_tmp45_, 10, _tmp46_, -1, _tmp47_);
#line 424 "../src/database.vala"
	_tmp48_ = stmt;
#line 424 "../src/database.vala"
	_tmp49_ = bookworm_app_book_getBookLastModificationDate (aBook);
#line 424 "../src/database.vala"
	_tmp50_ = g_free;
#line 424 "../src/database.vala"
	sqlite3_bind_text (_tmp48_, 11, _tmp49_, -1, _tmp50_);
#line 425 "../src/database.vala"
	_tmp51_ = stmt;
#line 425 "../src/database.vala"
	sqlite3_bind_int (_tmp51_, 12, bookworm_app_book_getBookId (aBook));
#line 426 "../src/database.vala"
	_tmp52_ = stmt;
#line 426 "../src/database.vala"
	sqlite3_step (_tmp52_);
#line 427 "../src/database.vala"
	_tmp53_ = stmt;
#line 427 "../src/database.vala"
	sqlite3_reset (_tmp53_);
#line 428 "../src/database.vala"
	_tmp54_ = bookworm_app_book_getBookTitle (aBook);
#line 428 "../src/database.vala"
	_tmp55_ = _tmp54_;
#line 428 "../src/database.vala"
	_tmp56_ = g_strconcat ("Updated library details to " BOOKWORM_APP_DB_BOOKWORM_TABLE_BASE_NAME BOOKWORM_APP_DB_BOOKWORM_TABLE_VERSION " for book:", _tmp55_, NULL);
#line 428 "../src/database.vala"
	_tmp57_ = _tmp56_;
#line 428 "../src/database.vala"
	_tmp58_ = g_strconcat (_tmp57_, "[", NULL);
#line 428 "../src/database.vala"
	_tmp59_ = _tmp58_;
#line 428 "../src/database.vala"
	_tmp60_ = g_strdup_printf ("%i", bookworm_app_book_getBookId (aBook));
#line 428 "../src/database.vala"
	_tmp61_ = _tmp60_;
#line 428 "../src/database.vala"
	_tmp62_ = g_strconcat (_tmp59_, _tmp61_, NULL);
#line 428 "../src/database.vala"
	_tmp63_ = _tmp62_;
#line 428 "../src/database.vala"
	_tmp64_ = g_strconcat (_tmp63_, "]", NULL);
#line 428 "../src/database.vala"
	_tmp65_ = _tmp64_;
#line 428 "../src/database.vala"
	g_debug ("database.vala:428: %s", _tmp65_);
#line 428 "../src/database.vala"
	_g_free0 (_tmp65_);
#line 428 "../src/database.vala"
	_g_free0 (_tmp63_);
#line 428 "../src/database.vala"
	_g_free0 (_tmp61_);
#line 428 "../src/database.vala"
	_g_free0 (_tmp59_);
#line 428 "../src/database.vala"
	_g_free0 (_tmp57_);
#line 428 "../src/database.vala"
	_g_free0 (_tmp55_);
#line 431 "../src/database.vala"
	_tmp66_ = g_strdup ("INSERT OR IGNORE INTO " BOOKWORM_APP_DB_BOOKMETADATA_TABLE_BASE_NAME BOOKWORM_APP_DB_BOOKMETADATA_TABLE_VERSION " (BOOK_TOC_DATA, BOOKMARKS, CONTENT_DATA_LIST, BOOK_LAST_SCROLL_POSITI" \
"ON, BOOK_ANNOTATIONS, modification_date, id) " "VALUES (?,?,?,?,?,CAST(strftime('%s', 'now') AS INT),?);");
#line 431 "../src/database.vala"
	_g_free0 (bookworm_app_db_queryString);
#line 431 "../src/database.vala"
	bookworm_app_db_queryString = _tmp66_;
#line 433 "../src/database.vala"
	_tmp67_ = bookworm_app_db_bookwormDB;
#line 433 "../src/database.vala"
	_tmp68_ = bookworm_app_db_queryString;
#line 433 "../src/database.vala"
	_tmp69_ = bookworm_app_db_queryString;
#line 433 "../src/database.vala"
	_tmp70_ = strlen (_tmp69_);
#line 433 "../src/database.vala"
	_tmp71_ = _tmp70_;
#line 433 "../src/database.vala"
	_tmp73_ = sqlite3_prepare_v2 (_tmp67_, _tmp68_, _tmp71_, &_tmp72_, NULL);
#line 433 "../src/database.vala"
	_sqlite3_finalize0 (stmt);
#line 433 "../src/database.vala"
	stmt = _tmp72_;
#line 433 "../src/database.vala"
	bookworm_app_db_executionStatus = _tmp73_;
#line 434 "../src/database.vala"
	if (bookworm_app_db_executionStatus != SQLITE_OK) {
#line 4084 "database.c"
		const gchar* _tmp74_;
		gchar* _tmp75_;
		gchar* _tmp76_;
		sqlite3* _tmp77_;
		sqlite3* _tmp78_;
		const gchar* _tmp79_;
#line 435 "../src/database.vala"
		_tmp74_ = bookworm_app_db_queryString;
#line 435 "../src/database.vala"
		_tmp75_ = g_strconcat ("Error on executing Query:", _tmp74_, NULL);
#line 435 "../src/database.vala"
		_tmp76_ = _tmp75_;
#line 435 "../src/database.vala"
		g_debug ("database.vala:435: %s", _tmp76_);
#line 435 "../src/database.vala"
		_g_free0 (_tmp76_);
#line 436 "../src/database.vala"
		_tmp77_ = bookworm_app_db_bookwormDB;
#line 436 "../src/database.vala"
		_tmp78_ = bookworm_app_db_bookwormDB;
#line 436 "../src/database.vala"
		_tmp79_ = sqlite3_errmsg (_tmp78_);
#line 436 "../src/database.vala"
		g_warning ("database.vala:436: Error details: %d: %s\n", sqlite3_errcode (_tmp77_), _tmp79_);
#line 437 "../src/database.vala"
		result = FALSE;
#line 437 "../src/database.vala"
		_sqlite3_finalize0 (stmt);
#line 437 "../src/database.vala"
		return result;
#line 4115 "database.c"
	}
#line 439 "../src/database.vala"
	_tmp80_ = stmt;
#line 439 "../src/database.vala"
	_tmp81_ = bookworm_app_utils_convertTOCToString (aBook);
#line 439 "../src/database.vala"
	_tmp82_ = g_free;
#line 439 "../src/database.vala"
	sqlite3_bind_text (_tmp80_, 1, _tmp81_, -1, _tmp82_);
#line 440 "../src/database.vala"
	_tmp83_ = stmt;
#line 440 "../src/database.vala"
	_tmp84_ = bookworm_app_book_getBookmark (aBook);
#line 440 "../src/database.vala"
	_tmp85_ = g_free;
#line 440 "../src/database.vala"
	sqlite3_bind_text (_tmp83_, 2, _tmp84_, -1, _tmp85_);
#line 441 "../src/database.vala"
	_tmp86_ = stmt;
#line 441 "../src/database.vala"
	_tmp87_ = bookworm_app_utils_convertContentListToString (aBook);
#line 441 "../src/database.vala"
	_tmp88_ = g_free;
#line 441 "../src/database.vala"
	sqlite3_bind_text (_tmp86_, 3, _tmp87_, -1, _tmp88_);
#line 442 "../src/database.vala"
	_tmp89_ = stmt;
#line 442 "../src/database.vala"
	_tmp90_ = g_strdup_printf ("%i", bookworm_app_book_getBookScrollPos (aBook));
#line 442 "../src/database.vala"
	_tmp91_ = g_free;
#line 442 "../src/database.vala"
	sqlite3_bind_text (_tmp89_, 4, _tmp90_, -1, _tmp91_);
#line 443 "../src/database.vala"
	_tmp92_ = stmt;
#line 443 "../src/database.vala"
	_tmp93_ = bookworm_app_book_getAnnotationList (aBook);
#line 443 "../src/database.vala"
	_tmp94_ = _tmp93_;
#line 443 "../src/database.vala"
	_tmp95_ = bookworm_app_utils_convertTreeMapToString (_tmp94_);
#line 443 "../src/database.vala"
	_tmp96_ = g_free;
#line 443 "../src/database.vala"
	sqlite3_bind_text (_tmp92_, 5, _tmp95_, -1, _tmp96_);
#line 443 "../src/database.vala"
	_g_object_unref0 (_tmp94_);
#line 444 "../src/database.vala"
	_tmp97_ = stmt;
#line 444 "../src/database.vala"
	sqlite3_bind_int (_tmp97_, 6, bookworm_app_book_getBookId (aBook));
#line 445 "../src/database.vala"
	_tmp98_ = stmt;
#line 445 "../src/database.vala"
	sqlite3_step (_tmp98_);
#line 446 "../src/database.vala"
	_tmp99_ = stmt;
#line 446 "../src/database.vala"
	sqlite3_reset (_tmp99_);
#line 447 "../src/database.vala"
	_tmp100_ = bookworm_app_db_bookwormDB;
#line 447 "../src/database.vala"
	if (sqlite3_changes (_tmp100_) == 0) {
#line 4179 "database.c"
		gchar* _tmp101_;
		sqlite3* _tmp102_;
		const gchar* _tmp103_;
		const gchar* _tmp104_;
		gint _tmp105_;
		gint _tmp106_;
		sqlite3_stmt* _tmp107_ = NULL;
		gint _tmp108_;
		sqlite3_stmt* _tmp115_;
		gchar* _tmp116_;
		GDestroyNotify _tmp117_;
		sqlite3_stmt* _tmp118_;
		gchar* _tmp119_;
		GDestroyNotify _tmp120_;
		sqlite3_stmt* _tmp121_;
		gchar* _tmp122_;
		GDestroyNotify _tmp123_;
		sqlite3_stmt* _tmp124_;
		gchar* _tmp125_;
		GDestroyNotify _tmp126_;
		sqlite3_stmt* _tmp127_;
		GeeTreeMap* _tmp128_;
		GeeTreeMap* _tmp129_;
		gchar* _tmp130_;
		GDestroyNotify _tmp131_;
		sqlite3_stmt* _tmp132_;
		sqlite3_stmt* _tmp133_;
		sqlite3_stmt* _tmp134_;
		gchar* _tmp135_;
		gchar* _tmp136_;
		gchar* _tmp137_;
		gchar* _tmp138_;
		gchar* _tmp139_;
		gchar* _tmp140_;
		gchar* _tmp141_;
		gchar* _tmp142_;
		gchar* _tmp143_;
		gchar* _tmp144_;
		gchar* _tmp145_;
		gchar* _tmp146_;
#line 449 "../src/database.vala"
		_tmp101_ = g_strdup ("UPDATE " BOOKWORM_APP_DB_BOOKMETADATA_TABLE_BASE_NAME BOOKWORM_APP_DB_BOOKMETADATA_TABLE_VERSION " SET BOOK_TOC_DATA = ?, BOOKMARKS = ?, CONTENT_DATA_LIST = ?, BOOK_LAS" \
"T_SCROLL_POSITION = ?, BOOK_ANNOTATIONS = ?, modification_date = CAST(" \
"strftime('%s', 'now') AS INT) WHERE id = ? ");
#line 449 "../src/database.vala"
		_g_free0 (bookworm_app_db_queryString);
#line 449 "../src/database.vala"
		bookworm_app_db_queryString = _tmp101_;
#line 451 "../src/database.vala"
		_tmp102_ = bookworm_app_db_bookwormDB;
#line 451 "../src/database.vala"
		_tmp103_ = bookworm_app_db_queryString;
#line 451 "../src/database.vala"
		_tmp104_ = bookworm_app_db_queryString;
#line 451 "../src/database.vala"
		_tmp105_ = strlen (_tmp104_);
#line 451 "../src/database.vala"
		_tmp106_ = _tmp105_;
#line 451 "../src/database.vala"
		_tmp108_ = sqlite3_prepare_v2 (_tmp102_, _tmp103_, _tmp106_, &_tmp107_, NULL);
#line 451 "../src/database.vala"
		_sqlite3_finalize0 (stmt);
#line 451 "../src/database.vala"
		stmt = _tmp107_;
#line 451 "../src/database.vala"
		bookworm_app_db_executionStatus = _tmp108_;
#line 452 "../src/database.vala"
		if (bookworm_app_db_executionStatus != SQLITE_OK) {
#line 4246 "database.c"
			const gchar* _tmp109_;
			gchar* _tmp110_;
			gchar* _tmp111_;
			sqlite3* _tmp112_;
			sqlite3* _tmp113_;
			const gchar* _tmp114_;
#line 453 "../src/database.vala"
			_tmp109_ = bookworm_app_db_queryString;
#line 453 "../src/database.vala"
			_tmp110_ = g_strconcat ("Error on executing Query:", _tmp109_, NULL);
#line 453 "../src/database.vala"
			_tmp111_ = _tmp110_;
#line 453 "../src/database.vala"
			g_debug ("database.vala:453: %s", _tmp111_);
#line 453 "../src/database.vala"
			_g_free0 (_tmp111_);
#line 454 "../src/database.vala"
			_tmp112_ = bookworm_app_db_bookwormDB;
#line 454 "../src/database.vala"
			_tmp113_ = bookworm_app_db_bookwormDB;
#line 454 "../src/database.vala"
			_tmp114_ = sqlite3_errmsg (_tmp113_);
#line 454 "../src/database.vala"
			g_warning ("database.vala:454: Error details: %d: %s\n", sqlite3_errcode (_tmp112_), _tmp114_);
#line 455 "../src/database.vala"
			result = FALSE;
#line 455 "../src/database.vala"
			_sqlite3_finalize0 (stmt);
#line 455 "../src/database.vala"
			return result;
#line 4277 "database.c"
		}
#line 457 "../src/database.vala"
		_tmp115_ = stmt;
#line 457 "../src/database.vala"
		_tmp116_ = bookworm_app_utils_convertTOCToString (aBook);
#line 457 "../src/database.vala"
		_tmp117_ = g_free;
#line 457 "../src/database.vala"
		sqlite3_bind_text (_tmp115_, 1, _tmp116_, -1, _tmp117_);
#line 458 "../src/database.vala"
		_tmp118_ = stmt;
#line 458 "../src/database.vala"
		_tmp119_ = bookworm_app_book_getBookmark (aBook);
#line 458 "../src/database.vala"
		_tmp120_ = g_free;
#line 458 "../src/database.vala"
		sqlite3_bind_text (_tmp118_, 2, _tmp119_, -1, _tmp120_);
#line 459 "../src/database.vala"
		_tmp121_ = stmt;
#line 459 "../src/database.vala"
		_tmp122_ = bookworm_app_utils_convertContentListToString (aBook);
#line 459 "../src/database.vala"
		_tmp123_ = g_free;
#line 459 "../src/database.vala"
		sqlite3_bind_text (_tmp121_, 3, _tmp122_, -1, _tmp123_);
#line 460 "../src/database.vala"
		_tmp124_ = stmt;
#line 460 "../src/database.vala"
		_tmp125_ = g_strdup_printf ("%i", bookworm_app_book_getBookScrollPos (aBook));
#line 460 "../src/database.vala"
		_tmp126_ = g_free;
#line 460 "../src/database.vala"
		sqlite3_bind_text (_tmp124_, 4, _tmp125_, -1, _tmp126_);
#line 461 "../src/database.vala"
		_tmp127_ = stmt;
#line 461 "../src/database.vala"
		_tmp128_ = bookworm_app_book_getAnnotationList (aBook);
#line 461 "../src/database.vala"
		_tmp129_ = _tmp128_;
#line 461 "../src/database.vala"
		_tmp130_ = bookworm_app_utils_convertTreeMapToString (_tmp129_);
#line 461 "../src/database.vala"
		_tmp131_ = g_free;
#line 461 "../src/database.vala"
		sqlite3_bind_text (_tmp127_, 5, _tmp130_, -1, _tmp131_);
#line 461 "../src/database.vala"
		_g_object_unref0 (_tmp129_);
#line 462 "../src/database.vala"
		_tmp132_ = stmt;
#line 462 "../src/database.vala"
		sqlite3_bind_int (_tmp132_, 6, bookworm_app_book_getBookId (aBook));
#line 463 "../src/database.vala"
		_tmp133_ = stmt;
#line 463 "../src/database.vala"
		sqlite3_step (_tmp133_);
#line 464 "../src/database.vala"
		_tmp134_ = stmt;
#line 464 "../src/database.vala"
		sqlite3_reset (_tmp134_);
#line 465 "../src/database.vala"
		_tmp135_ = bookworm_app_book_getBookTitle (aBook);
#line 465 "../src/database.vala"
		_tmp136_ = _tmp135_;
#line 465 "../src/database.vala"
		_tmp137_ = g_strconcat ("Updated book meta data details to " BOOKWORM_APP_DB_BOOKMETADATA_TABLE_BASE_NAME BOOKWORM_APP_DB_BOOKMETADATA_TABLE_VERSION " for book:", _tmp136_, NULL);
#line 465 "../src/database.vala"
		_tmp138_ = _tmp137_;
#line 465 "../src/database.vala"
		_tmp139_ = g_strconcat (_tmp138_, "[", NULL);
#line 465 "../src/database.vala"
		_tmp140_ = _tmp139_;
#line 465 "../src/database.vala"
		_tmp141_ = g_strdup_printf ("%i", bookworm_app_book_getBookId (aBook));
#line 465 "../src/database.vala"
		_tmp142_ = _tmp141_;
#line 465 "../src/database.vala"
		_tmp143_ = g_strconcat (_tmp140_, _tmp142_, NULL);
#line 465 "../src/database.vala"
		_tmp144_ = _tmp143_;
#line 465 "../src/database.vala"
		_tmp145_ = g_strconcat (_tmp144_, "]", NULL);
#line 465 "../src/database.vala"
		_tmp146_ = _tmp145_;
#line 465 "../src/database.vala"
		g_debug ("database.vala:465: %s", _tmp146_);
#line 465 "../src/database.vala"
		_g_free0 (_tmp146_);
#line 465 "../src/database.vala"
		_g_free0 (_tmp144_);
#line 465 "../src/database.vala"
		_g_free0 (_tmp142_);
#line 465 "../src/database.vala"
		_g_free0 (_tmp140_);
#line 465 "../src/database.vala"
		_g_free0 (_tmp138_);
#line 465 "../src/database.vala"
		_g_free0 (_tmp136_);
#line 4375 "database.c"
	} else {
		gchar* _tmp147_;
		gchar* _tmp148_;
		gchar* _tmp149_;
		gchar* _tmp150_;
		gchar* _tmp151_;
		gchar* _tmp152_;
		gchar* _tmp153_;
		gchar* _tmp154_;
		gchar* _tmp155_;
		gchar* _tmp156_;
		gchar* _tmp157_;
		gchar* _tmp158_;
#line 467 "../src/database.vala"
		_tmp147_ = bookworm_app_book_getBookTitle (aBook);
#line 467 "../src/database.vala"
		_tmp148_ = _tmp147_;
#line 467 "../src/database.vala"
		_tmp149_ = g_strconcat ("Inserted book meta data details to " BOOKWORM_APP_DB_BOOKMETADATA_TABLE_BASE_NAME BOOKWORM_APP_DB_BOOKMETADATA_TABLE_VERSION " for book:", _tmp148_, NULL);
#line 467 "../src/database.vala"
		_tmp150_ = _tmp149_;
#line 467 "../src/database.vala"
		_tmp151_ = g_strconcat (_tmp150_, "[", NULL);
#line 467 "../src/database.vala"
		_tmp152_ = _tmp151_;
#line 467 "../src/database.vala"
		_tmp153_ = g_strdup_printf ("%i", bookworm_app_book_getBookId (aBook));
#line 467 "../src/database.vala"
		_tmp154_ = _tmp153_;
#line 467 "../src/database.vala"
		_tmp155_ = g_strconcat (_tmp152_, _tmp154_, NULL);
#line 467 "../src/database.vala"
		_tmp156_ = _tmp155_;
#line 467 "../src/database.vala"
		_tmp157_ = g_strconcat (_tmp156_, "]", NULL);
#line 467 "../src/database.vala"
		_tmp158_ = _tmp157_;
#line 467 "../src/database.vala"
		g_debug ("database.vala:467: %s", _tmp158_);
#line 467 "../src/database.vala"
		_g_free0 (_tmp158_);
#line 467 "../src/database.vala"
		_g_free0 (_tmp156_);
#line 467 "../src/database.vala"
		_g_free0 (_tmp154_);
#line 467 "../src/database.vala"
		_g_free0 (_tmp152_);
#line 467 "../src/database.vala"
		_g_free0 (_tmp150_);
#line 467 "../src/database.vala"
		_g_free0 (_tmp148_);
#line 4427 "database.c"
	}
#line 469 "../src/database.vala"
	_tmp159_ = bookworm_app_book_getBookLocation (aBook);
#line 469 "../src/database.vala"
	_tmp160_ = _tmp159_;
#line 469 "../src/database.vala"
	_tmp161_ = g_strconcat ("[END] [FUNCTION:updateBookToDataBase] book.location=", _tmp160_, NULL);
#line 469 "../src/database.vala"
	_tmp162_ = _tmp161_;
#line 469 "../src/database.vala"
	g_info ("database.vala:469: %s", _tmp162_);
#line 469 "../src/database.vala"
	_g_free0 (_tmp162_);
#line 469 "../src/database.vala"
	_g_free0 (_tmp160_);
#line 470 "../src/database.vala"
	result = TRUE;
#line 470 "../src/database.vala"
	_sqlite3_finalize0 (stmt);
#line 470 "../src/database.vala"
	return result;
#line 4449 "database.c"
}

GeeArrayList*
bookworm_app_db_getBookIDListFromDB (void)
{
	GeeArrayList* bookIDList = NULL;
	GeeArrayList* _tmp0_;
	sqlite3_stmt* stmt = NULL;
	gchar* _tmp1_;
	sqlite3* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	sqlite3_stmt* _tmp7_ = NULL;
	gint _tmp8_;
	sqlite3_stmt* _tmp26_;
	GeeArrayList* _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	GeeArrayList* result;
#line 474 "../src/database.vala"
	g_info ("database.vala:474: [START] [FUNCTION:getBookIDListFromDB]");
#line 475 "../src/database.vala"
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
#line 475 "../src/database.vala"
	bookIDList = _tmp0_;
#line 477 "../src/database.vala"
	_tmp1_ = g_strdup ("SELECT id,BOOK_LOCATION FROM " BOOKWORM_APP_DB_BOOKWORM_TABLE_BASE_NAME BOOKWORM_APP_DB_BOOKWORM_TABLE_VERSION " ORDER BY id DESC");
#line 477 "../src/database.vala"
	_g_free0 (bookworm_app_db_queryString);
#line 477 "../src/database.vala"
	bookworm_app_db_queryString = _tmp1_;
#line 480 "../src/database.vala"
	_tmp2_ = bookworm_app_db_bookwormDB;
#line 480 "../src/database.vala"
	_tmp3_ = bookworm_app_db_queryString;
#line 480 "../src/database.vala"
	_tmp4_ = bookworm_app_db_queryString;
#line 480 "../src/database.vala"
	_tmp5_ = strlen (_tmp4_);
#line 480 "../src/database.vala"
	_tmp6_ = _tmp5_;
#line 480 "../src/database.vala"
	_tmp8_ = sqlite3_prepare_v2 (_tmp2_, _tmp3_, _tmp6_, &_tmp7_, NULL);
#line 480 "../src/database.vala"
	_sqlite3_finalize0 (stmt);
#line 480 "../src/database.vala"
	stmt = _tmp7_;
#line 480 "../src/database.vala"
	bookworm_app_db_executionStatus = _tmp8_;
#line 481 "../src/database.vala"
	if (bookworm_app_db_executionStatus != SQLITE_OK) {
#line 4507 "database.c"
		const gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		sqlite3* _tmp12_;
		sqlite3* _tmp13_;
		const gchar* _tmp14_;
#line 482 "../src/database.vala"
		_tmp9_ = bookworm_app_db_queryString;
#line 482 "../src/database.vala"
		_tmp10_ = g_strconcat ("Error on executing Query:", _tmp9_, NULL);
#line 482 "../src/database.vala"
		_tmp11_ = _tmp10_;
#line 482 "../src/database.vala"
		g_debug ("database.vala:482: %s", _tmp11_);
#line 482 "../src/database.vala"
		_g_free0 (_tmp11_);
#line 483 "../src/database.vala"
		_tmp12_ = bookworm_app_db_bookwormDB;
#line 483 "../src/database.vala"
		_tmp13_ = bookworm_app_db_bookwormDB;
#line 483 "../src/database.vala"
		_tmp14_ = sqlite3_errmsg (_tmp13_);
#line 483 "../src/database.vala"
		g_warning ("database.vala:483: Error details: %d: %s\n", sqlite3_errcode (_tmp12_), _tmp14_);
#line 4532 "database.c"
	}
#line 485 "../src/database.vala"
	while (TRUE) {
#line 4536 "database.c"
		sqlite3_stmt* _tmp15_;
		GeeArrayList* _tmp16_;
		sqlite3_stmt* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		sqlite3_stmt* _tmp22_;
		const gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
#line 485 "../src/database.vala"
		_tmp15_ = stmt;
#line 485 "../src/database.vala"
		if (!(sqlite3_step (_tmp15_) == SQLITE_ROW)) {
#line 485 "../src/database.vala"
			break;
#line 4554 "database.c"
		}
#line 486 "../src/database.vala"
		_tmp16_ = bookIDList;
#line 486 "../src/database.vala"
		_tmp17_ = stmt;
#line 486 "../src/database.vala"
		_tmp18_ = g_strdup_printf ("%i", sqlite3_column_int (_tmp17_, 0));
#line 486 "../src/database.vala"
		_tmp19_ = _tmp18_;
#line 486 "../src/database.vala"
		_tmp20_ = g_strconcat (_tmp19_, "::", NULL);
#line 486 "../src/database.vala"
		_tmp21_ = _tmp20_;
#line 486 "../src/database.vala"
		_tmp22_ = stmt;
#line 486 "../src/database.vala"
		_tmp23_ = (const gchar*) sqlite3_column_text (_tmp22_, 1);
#line 486 "../src/database.vala"
		_tmp24_ = g_strconcat (_tmp21_, _tmp23_, NULL);
#line 486 "../src/database.vala"
		_tmp25_ = _tmp24_;
#line 486 "../src/database.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp16_, _tmp25_);
#line 486 "../src/database.vala"
		_g_free0 (_tmp25_);
#line 486 "../src/database.vala"
		_g_free0 (_tmp21_);
#line 486 "../src/database.vala"
		_g_free0 (_tmp19_);
#line 4584 "database.c"
	}
#line 488 "../src/database.vala"
	_tmp26_ = stmt;
#line 488 "../src/database.vala"
	sqlite3_reset (_tmp26_);
#line 489 "../src/database.vala"
	_tmp27_ = bookIDList;
#line 489 "../src/database.vala"
	_tmp28_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp27_);
#line 489 "../src/database.vala"
	_tmp29_ = _tmp28_;
#line 489 "../src/database.vala"
	_tmp30_ = g_strdup_printf ("%i", _tmp29_);
#line 489 "../src/database.vala"
	_tmp31_ = _tmp30_;
#line 489 "../src/database.vala"
	_tmp32_ = g_strconcat ("[END] [FUNCTION:getBookIDListFromDB] bookIDList.size", _tmp31_, NULL);
#line 489 "../src/database.vala"
	_tmp33_ = _tmp32_;
#line 489 "../src/database.vala"
	g_info ("database.vala:489: %s", _tmp33_);
#line 489 "../src/database.vala"
	_g_free0 (_tmp33_);
#line 489 "../src/database.vala"
	_g_free0 (_tmp31_);
#line 490 "../src/database.vala"
	result = bookIDList;
#line 490 "../src/database.vala"
	_sqlite3_finalize0 (stmt);
#line 490 "../src/database.vala"
	return result;
#line 4616 "database.c"
}

BookwormAppDB*
bookworm_app_db_construct (GType object_type)
{
	BookwormAppDB* self = NULL;
#line 22 "../src/database.vala"
	self = (BookwormAppDB*) g_type_create_instance (object_type);
#line 22 "../src/database.vala"
	return self;
#line 4627 "database.c"
}

BookwormAppDB*
bookworm_app_db_new (void)
{
#line 22 "../src/database.vala"
	return bookworm_app_db_construct (BOOKWORM_APP_TYPE_DB);
#line 4635 "database.c"
}

static void
bookworm_app_value_db_init (GValue* value)
{
#line 22 "../src/database.vala"
	value->data[0].v_pointer = NULL;
#line 4643 "database.c"
}

static void
bookworm_app_value_db_free_value (GValue* value)
{
#line 22 "../src/database.vala"
	if (value->data[0].v_pointer) {
#line 22 "../src/database.vala"
		bookworm_app_db_unref (value->data[0].v_pointer);
#line 4653 "database.c"
	}
}

static void
bookworm_app_value_db_copy_value (const GValue* src_value,
                                  GValue* dest_value)
{
#line 22 "../src/database.vala"
	if (src_value->data[0].v_pointer) {
#line 22 "../src/database.vala"
		dest_value->data[0].v_pointer = bookworm_app_db_ref (src_value->data[0].v_pointer);
#line 4665 "database.c"
	} else {
#line 22 "../src/database.vala"
		dest_value->data[0].v_pointer = NULL;
#line 4669 "database.c"
	}
}

static gpointer
bookworm_app_value_db_peek_pointer (const GValue* value)
{
#line 22 "../src/database.vala"
	return value->data[0].v_pointer;
#line 4678 "database.c"
}

static gchar*
bookworm_app_value_db_collect_value (GValue* value,
                                     guint n_collect_values,
                                     GTypeCValue* collect_values,
                                     guint collect_flags)
{
#line 22 "../src/database.vala"
	if (collect_values[0].v_pointer) {
#line 4689 "database.c"
		BookwormAppDB * object;
		object = collect_values[0].v_pointer;
#line 22 "../src/database.vala"
		if (object->parent_instance.g_class == NULL) {
#line 22 "../src/database.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4696 "database.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 22 "../src/database.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4700 "database.c"
		}
#line 22 "../src/database.vala"
		value->data[0].v_pointer = bookworm_app_db_ref (object);
#line 4704 "database.c"
	} else {
#line 22 "../src/database.vala"
		value->data[0].v_pointer = NULL;
#line 4708 "database.c"
	}
#line 22 "../src/database.vala"
	return NULL;
#line 4712 "database.c"
}

static gchar*
bookworm_app_value_db_lcopy_value (const GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
	BookwormAppDB ** object_p;
	object_p = collect_values[0].v_pointer;
#line 22 "../src/database.vala"
	if (!object_p) {
#line 22 "../src/database.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 4727 "database.c"
	}
#line 22 "../src/database.vala"
	if (!value->data[0].v_pointer) {
#line 22 "../src/database.vala"
		*object_p = NULL;
#line 4733 "database.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 22 "../src/database.vala"
		*object_p = value->data[0].v_pointer;
#line 4737 "database.c"
	} else {
#line 22 "../src/database.vala"
		*object_p = bookworm_app_db_ref (value->data[0].v_pointer);
#line 4741 "database.c"
	}
#line 22 "../src/database.vala"
	return NULL;
#line 4745 "database.c"
}

GParamSpec*
bookworm_app_param_spec_db (const gchar* name,
                            const gchar* nick,
                            const gchar* blurb,
                            GType object_type,
                            GParamFlags flags)
{
	BookwormAppParamSpecDB* spec;
#line 22 "../src/database.vala"
	g_return_val_if_fail (g_type_is_a (object_type, BOOKWORM_APP_TYPE_DB), NULL);
#line 22 "../src/database.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 22 "../src/database.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 22 "../src/database.vala"
	return G_PARAM_SPEC (spec);
#line 4764 "database.c"
}

gpointer
bookworm_app_value_get_db (const GValue* value)
{
#line 22 "../src/database.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOOKWORM_APP_TYPE_DB), NULL);
#line 22 "../src/database.vala"
	return value->data[0].v_pointer;
#line 4774 "database.c"
}

void
bookworm_app_value_set_db (GValue* value,
                           gpointer v_object)
{
	BookwormAppDB * old;
#line 22 "../src/database.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOOKWORM_APP_TYPE_DB));
#line 22 "../src/database.vala"
	old = value->data[0].v_pointer;
#line 22 "../src/database.vala"
	if (v_object) {
#line 22 "../src/database.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BOOKWORM_APP_TYPE_DB));
#line 22 "../src/database.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 22 "../src/database.vala"
		value->data[0].v_pointer = v_object;
#line 22 "../src/database.vala"
		bookworm_app_db_ref (value->data[0].v_pointer);
#line 4796 "database.c"
	} else {
#line 22 "../src/database.vala"
		value->data[0].v_pointer = NULL;
#line 4800 "database.c"
	}
#line 22 "../src/database.vala"
	if (old) {
#line 22 "../src/database.vala"
		bookworm_app_db_unref (old);
#line 4806 "database.c"
	}
}

void
bookworm_app_value_take_db (GValue* value,
                            gpointer v_object)
{
	BookwormAppDB * old;
#line 22 "../src/database.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOOKWORM_APP_TYPE_DB));
#line 22 "../src/database.vala"
	old = value->data[0].v_pointer;
#line 22 "../src/database.vala"
	if (v_object) {
#line 22 "../src/database.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BOOKWORM_APP_TYPE_DB));
#line 22 "../src/database.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 22 "../src/database.vala"
		value->data[0].v_pointer = v_object;
#line 4827 "database.c"
	} else {
#line 22 "../src/database.vala"
		value->data[0].v_pointer = NULL;
#line 4831 "database.c"
	}
#line 22 "../src/database.vala"
	if (old) {
#line 22 "../src/database.vala"
		bookworm_app_db_unref (old);
#line 4837 "database.c"
	}
}

static void
bookworm_app_db_class_init (BookwormAppDBClass * klass,
                            gpointer klass_data)
{
#line 22 "../src/database.vala"
	bookworm_app_db_parent_class = g_type_class_peek_parent (klass);
#line 22 "../src/database.vala"
	((BookwormAppDBClass *) klass)->finalize = bookworm_app_db_finalize;
#line 4849 "database.c"
}

static void
bookworm_app_db_instance_init (BookwormAppDB * self,
                               gpointer klass)
{
#line 22 "../src/database.vala"
	self->ref_count = 1;
#line 4858 "database.c"
}

static void
bookworm_app_db_finalize (BookwormAppDB * obj)
{
	BookwormAppDB * self;
#line 22 "../src/database.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOOKWORM_APP_TYPE_DB, BookwormAppDB);
#line 22 "../src/database.vala"
	g_signal_handlers_destroy (self);
#line 4869 "database.c"
}

static GType
bookworm_app_db_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { bookworm_app_value_db_init, bookworm_app_value_db_free_value, bookworm_app_value_db_copy_value, bookworm_app_value_db_peek_pointer, "p", bookworm_app_value_db_collect_value, "p", bookworm_app_value_db_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (BookwormAppDBClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bookworm_app_db_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BookwormAppDB), 0, (GInstanceInitFunc) bookworm_app_db_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType bookworm_app_db_type_id;
	bookworm_app_db_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BookwormAppDB", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return bookworm_app_db_type_id;
}

GType
bookworm_app_db_get_type (void)
{
	static volatile gsize bookworm_app_db_type_id__once = 0;
	if (g_once_init_enter (&bookworm_app_db_type_id__once)) {
		GType bookworm_app_db_type_id;
		bookworm_app_db_type_id = bookworm_app_db_get_type_once ();
		g_once_init_leave (&bookworm_app_db_type_id__once, bookworm_app_db_type_id);
	}
	return bookworm_app_db_type_id__once;
}

gpointer
bookworm_app_db_ref (gpointer instance)
{
	BookwormAppDB * self;
	self = instance;
#line 22 "../src/database.vala"
	g_atomic_int_inc (&self->ref_count);
#line 22 "../src/database.vala"
	return instance;
#line 4904 "database.c"
}

void
bookworm_app_db_unref (gpointer instance)
{
	BookwormAppDB * self;
	self = instance;
#line 22 "../src/database.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 22 "../src/database.vala"
		BOOKWORM_APP_DB_GET_CLASS (self)->finalize (self);
#line 22 "../src/database.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 4918 "database.c"
	}
}

