/* src/bazaar.p/bz-pride-flag-spec.c
 *
 * Copyright 2026 AUTOGEN
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include "src/bazaar.p/bz-pride-flag-spec.h"



struct _BzPrideFlagSpec
{
  GObject parent_instance;

  char *id;
  char *name;
  gboolean homogeneous;
  char *direction;
  GListModel *stripes;
};

G_DEFINE_FINAL_TYPE (BzPrideFlagSpec, bz_pride_flag_spec, G_TYPE_OBJECT);

enum
{
  PROP_0,

  PROP_ID,
  PROP_NAME,
  PROP_HOMOGENEOUS,
  PROP_DIRECTION,
  PROP_STRIPES,

  LAST_PROP
};
static GParamSpec *props[LAST_PROP] = { 0 };

static void
bz_pride_flag_spec_dispose (GObject *object)
{
  BzPrideFlagSpec *self = BZ_PRIDE_FLAG_SPEC (object);

  g_clear_pointer (&self->id, g_free);
  g_clear_pointer (&self->name, g_free);
  g_clear_pointer (&self->direction, g_free);
  g_clear_pointer (&self->stripes, g_object_unref);

  G_OBJECT_CLASS (bz_pride_flag_spec_parent_class)->dispose (object);
}

static void
bz_pride_flag_spec_get_property (GObject    *object,
                       guint       prop_id,
                       GValue     *value,
                       GParamSpec *pspec)
{
  BzPrideFlagSpec *self = BZ_PRIDE_FLAG_SPEC (object);

  switch (prop_id)
    {
    case PROP_ID:
      g_value_set_string (value, bz_pride_flag_spec_get_id (self));
      break;
    case PROP_NAME:
      g_value_set_string (value, bz_pride_flag_spec_get_name (self));
      break;
    case PROP_HOMOGENEOUS:
      g_value_set_boolean (value, bz_pride_flag_spec_get_homogeneous (self));
      break;
    case PROP_DIRECTION:
      g_value_set_string (value, bz_pride_flag_spec_get_direction (self));
      break;
    case PROP_STRIPES:
      g_value_set_object (value, bz_pride_flag_spec_get_stripes (self));
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
    }
}

static void
bz_pride_flag_spec_set_property (GObject      *object,
                       guint         prop_id,
                       const GValue *value,
                       GParamSpec   *pspec)
{
  BzPrideFlagSpec *self = BZ_PRIDE_FLAG_SPEC (object);

  switch (prop_id)
    {
    case PROP_ID:
      bz_pride_flag_spec_set_id (self, g_value_get_string (value));
      break;
    case PROP_NAME:
      bz_pride_flag_spec_set_name (self, g_value_get_string (value));
      break;
    case PROP_HOMOGENEOUS:
      bz_pride_flag_spec_set_homogeneous (self, g_value_get_boolean (value));
      break;
    case PROP_DIRECTION:
      bz_pride_flag_spec_set_direction (self, g_value_get_string (value));
      break;
    case PROP_STRIPES:
      bz_pride_flag_spec_set_stripes (self, g_value_get_object (value));
      break;
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
    }
}

static void
bz_pride_flag_spec_class_init (BzPrideFlagSpecClass *klass)
{
  GObjectClass *object_class = G_OBJECT_CLASS (klass);

  g_type_ensure (BZ_TYPE_PRIDE_FLAG_STRIPE_SPEC);

  object_class->set_property = bz_pride_flag_spec_set_property;
  object_class->get_property = bz_pride_flag_spec_get_property;
  object_class->dispose      = bz_pride_flag_spec_dispose;

  props[PROP_ID] =
      g_param_spec_string (
          "id",
          NULL, NULL, NULL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_NAME] =
      g_param_spec_string (
          "name",
          NULL, NULL, NULL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_HOMOGENEOUS] =
      g_param_spec_boolean (
          "homogeneous",
          NULL, NULL, FALSE,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_DIRECTION] =
      g_param_spec_string (
          "direction",
          NULL, NULL, NULL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  props[PROP_STRIPES] =
      g_param_spec_object (
          "stripes",
          NULL, NULL,
          G_TYPE_LIST_MODEL,
          G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS | G_PARAM_EXPLICIT_NOTIFY);

  g_object_class_install_properties (object_class, LAST_PROP, props);
}

static void
bz_pride_flag_spec_init (BzPrideFlagSpec *self)
{
}

BzPrideFlagSpec *
bz_pride_flag_spec_new (void){
  return g_object_new (BZ_TYPE_PRIDE_FLAG_SPEC, NULL);
}

const char *
bz_pride_flag_spec_get_id (BzPrideFlagSpec *self){
  g_return_val_if_fail (BZ_IS_PRIDE_FLAG_SPEC (self), NULL);
  return self->id;
}

const char *
bz_pride_flag_spec_get_name (BzPrideFlagSpec *self){
  g_return_val_if_fail (BZ_IS_PRIDE_FLAG_SPEC (self), NULL);
  return self->name;
}

gboolean
bz_pride_flag_spec_get_homogeneous (BzPrideFlagSpec *self){
  g_return_val_if_fail (BZ_IS_PRIDE_FLAG_SPEC (self), FALSE);
  return self->homogeneous;
}

const char *
bz_pride_flag_spec_get_direction (BzPrideFlagSpec *self){
  g_return_val_if_fail (BZ_IS_PRIDE_FLAG_SPEC (self), NULL);
  return self->direction;
}

GListModel *
bz_pride_flag_spec_get_stripes (BzPrideFlagSpec *self){
  g_return_val_if_fail (BZ_IS_PRIDE_FLAG_SPEC (self), NULL);
  return self->stripes;
}

void
bz_pride_flag_spec_set_id (BzPrideFlagSpec *self,
    const char *id){
  g_return_if_fail (BZ_IS_PRIDE_FLAG_SPEC (self));

  if (id == self->id || (id != NULL && self->id != NULL && g_strcmp0(id, self->id) == 0))
    return;

  g_clear_pointer (&self->id, g_free);
  if (id != NULL)
    self->id = g_strdup (id);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_ID]);
}

void
bz_pride_flag_spec_set_name (BzPrideFlagSpec *self,
    const char *name){
  g_return_if_fail (BZ_IS_PRIDE_FLAG_SPEC (self));

  if (name == self->name || (name != NULL && self->name != NULL && g_strcmp0(name, self->name) == 0))
    return;

  g_clear_pointer (&self->name, g_free);
  if (name != NULL)
    self->name = g_strdup (name);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_NAME]);
}

void
bz_pride_flag_spec_set_homogeneous (BzPrideFlagSpec *self,
    gboolean homogeneous){
  g_return_if_fail (BZ_IS_PRIDE_FLAG_SPEC (self));

  if (!!homogeneous == !!self->homogeneous)
    return;

  self->homogeneous = homogeneous;

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_HOMOGENEOUS]);
}

void
bz_pride_flag_spec_set_direction (BzPrideFlagSpec *self,
    const char *direction){
  g_return_if_fail (BZ_IS_PRIDE_FLAG_SPEC (self));

  if (direction == self->direction || (direction != NULL && self->direction != NULL && g_strcmp0(direction, self->direction) == 0))
    return;

  g_clear_pointer (&self->direction, g_free);
  if (direction != NULL)
    self->direction = g_strdup (direction);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_DIRECTION]);
}

void
bz_pride_flag_spec_set_stripes (BzPrideFlagSpec *self,
    GListModel *stripes){
  g_return_if_fail (BZ_IS_PRIDE_FLAG_SPEC (self));

  if (stripes == self->stripes)
    return;

  g_clear_pointer (&self->stripes, g_object_unref);
  if (stripes != NULL)
    self->stripes = g_object_ref (stripes);

  g_object_notify_by_pspec (G_OBJECT (self), props[PROP_STRIPES]);
}

/* End of src/bazaar.p/bz-pride-flag-spec.c */
