//
// Copyright (c) ZeroC, Inc. All rights reserved.
//
//
// Ice version 3.7.10
//
// <auto-generated>
//
// Generated from file `IceStormInternal.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

#ifndef __IceStorm_IceStormInternal_h__
#define __IceStorm_IceStormInternal_h__

#include <IceUtil/PushDisableWarnings.h>
#include <Ice/ProxyF.h>
#include <Ice/ObjectF.h>
#include <Ice/ValueF.h>
#include <Ice/Exception.h>
#include <Ice/LocalObject.h>
#include <Ice/StreamHelpers.h>
#include <Ice/Comparable.h>
#include <Ice/Proxy.h>
#include <Ice/Object.h>
#include <Ice/GCObject.h>
#include <Ice/Value.h>
#include <Ice/Incoming.h>
#include <Ice/FactoryTableInit.h>
#include <IceUtil/ScopedArray.h>
#include <Ice/Optional.h>
#include <Ice/ExceptionHelpers.h>
#include <IceStorm/IceStorm.h>
#include <IceStorm/Election.h>
#include <Ice/Current.h>
#include <IceUtil/UndefSysMacros.h>
#include <deque>

#ifndef ICE_IGNORE_VERSION
#   if ICE_INT_VERSION / 100 != 307
#       error Ice version mismatch!
#   endif
#   if ICE_INT_VERSION % 100 >= 50
#       error Beta header file detected
#   endif
#   if ICE_INT_VERSION % 100 < 10
#       error Ice patch level mismatch!
#   endif
#endif

#ifdef ICE_CPP11_MAPPING // C++11 mapping

namespace IceStorm
{

class TopicLink;
class TopicLinkPrx;
class TopicInternal;
class TopicInternalPrx;
class TopicManagerInternal;
class TopicManagerInternalPrx;

}

namespace IceStorm
{

/**
 * The event data.
 */
struct EventData
{
    /**
     * The operation name.
     */
    ::std::string op;
    /**
     * The operation mode.
     */
    ::Ice::OperationMode mode;
    /**
     * The encoded data for the operation's input parameters.
     */
    ::Ice::ByteSeq data;
    /**
     * The Ice::Current::Context data from the originating request.
     */
    ::Ice::Context context;

    /**
     * Obtains a tuple containing all of the struct's data members.
     * @return The data members in a tuple.
     */
    std::tuple<const ::std::string&, const ::Ice::OperationMode&, const ::Ice::ByteSeq&, const ::Ice::Context&> ice_tuple() const
    {
        return std::tie(op, mode, data, context);
    }
};

class SendQueueSizeMaxReached : public ::Ice::LocalExceptionHelper<SendQueueSizeMaxReached, ::Ice::LocalException>
{
public:

    virtual ~SendQueueSizeMaxReached();

    SendQueueSizeMaxReached(const SendQueueSizeMaxReached&) = default;

    /**
     * The file and line number are required for all local exceptions.
     * @param file The file name in which the exception was raised, typically __FILE__.
     * @param line The line number at which the exception was raised, typically __LINE__.
     */
    SendQueueSizeMaxReached(const char* file, int line) : ::Ice::LocalExceptionHelper<SendQueueSizeMaxReached, ::Ice::LocalException>(file, line)
    {
    }

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */
    std::tuple<> ice_tuple() const
    {
        return std::tie();
    }

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();
};

/**
 * A sequence of EventData.
 */
using EventDataSeq = std::deque< ::IceStorm::EventDataPtr>;

/**
 * Thrown if the reap call would block.
 */
class ReapWouldBlock : public ::Ice::UserExceptionHelper<ReapWouldBlock, ::Ice::UserException>
{
public:

    virtual ~ReapWouldBlock();

    ReapWouldBlock(const ReapWouldBlock&) = default;

    ReapWouldBlock() = default;

    /**
     * Obtains a tuple containing all of the exception's data members.
     * @return The data members in a tuple.
     */
    std::tuple<> ice_tuple() const
    {
        return std::tie();
    }

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();
};

/// \cond INTERNAL
static ReapWouldBlock _iceS_ReapWouldBlock_init;
/// \endcond

using Ice::operator<;
using Ice::operator<=;
using Ice::operator>;
using Ice::operator>=;
using Ice::operator==;
using Ice::operator!=;

}

namespace IceStorm
{

/**
 * The TopicLink interface. This is used to forward events between
 * federated Topic instances.
 * @see TopicInternal
 */
class TopicLink : public virtual ::Ice::Object
{
public:

    using ProxyType = TopicLinkPrx;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(::std::string id, const ::Ice::Current& current) const override;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current& current) const override;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual ::std::string ice_id(const ::Ice::Current& current) const override;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Forward a sequence of events.
     * @param events The events to forward.
     * @param current The Current object for the invocation.
     */
    virtual void forward(EventDataSeq events, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_forward(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
    /// \endcond
};

/**
 * Internal operations for a topic.
 * @see Topic
 */
class TopicInternal : public virtual Topic
{
public:

    using ProxyType = TopicInternalPrx;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(::std::string id, const ::Ice::Current& current) const override;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current& current) const override;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual ::std::string ice_id(const ::Ice::Current& current) const override;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Retrieve a proxy to the TopicLink interface.
     * @param current The Current object for the invocation.
     * @return The TopicLink for the Topic.
     */
    virtual ::std::shared_ptr<TopicLinkPrx> getLinkProxy(const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_getLinkProxy(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Reap the given identities.
     * @param id The sequence of identities.
     * @param current The Current object for the invocation.
     * @throws IceStorm::ReapWouldBlock Raised if the reap call would block.
     */
    virtual void reap(::Ice::IdentitySeq id, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_reap(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
    /// \endcond
};

/**
 * Internal operations for a topic manager.
 * @see TopicManager
 */
class TopicManagerInternal : public virtual TopicManager
{
public:

    using ProxyType = TopicManagerInternalPrx;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(::std::string id, const ::Ice::Current& current) const override;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current& current) const override;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual ::std::string ice_id(const ::Ice::Current& current) const override;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Return the replica node proxy for this topic manager.
     * @param current The Current object for the invocation.
     * @return The replica proxy, or null if this instance is not
     * replicated.
     */
    virtual ::std::shared_ptr<::IceStormElection::NodePrx> getReplicaNode(const ::Ice::Current& current) const = 0;
    /// \cond INTERNAL
    bool _iceD_getReplicaNode(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
    /// \endcond
};

}

namespace IceStorm
{

/**
 * The TopicLink interface. This is used to forward events between
 * federated Topic instances.
 * @see TopicInternal
 */
class TopicLinkPrx : public virtual ::Ice::Proxy<TopicLinkPrx, ::Ice::ObjectPrx>
{
public:

    /**
     * Forward a sequence of events.
     * @param events The events to forward.
     * @param context The Context map to send with the invocation.
     */
    void forward(const EventDataSeq& events, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &TopicLinkPrx::_iceI_forward, events, context).get();
    }

    /**
     * Forward a sequence of events.
     * @param events The events to forward.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto forwardAsync(const EventDataSeq& events, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &TopicLinkPrx::_iceI_forward, events, context);
    }

    /**
     * Forward a sequence of events.
     * @param events The events to forward.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    forwardAsync(const EventDataSeq& events,
                 ::std::function<void()> response,
                 ::std::function<void(::std::exception_ptr)> ex = nullptr,
                 ::std::function<void(bool)> sent = nullptr,
                 const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceStorm::TopicLinkPrx::_iceI_forward, events, context);
    }

    /// \cond INTERNAL
    void _iceI_forward(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const EventDataSeq&, const ::Ice::Context&);
    /// \endcond

    /**
     * Obtains the Slice type ID of this interface.
     * @return The fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

protected:

    /// \cond INTERNAL
    TopicLinkPrx() = default;
    friend ::std::shared_ptr<TopicLinkPrx> IceInternal::createProxy<TopicLinkPrx>();

    virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
    /// \endcond
};

/**
 * Internal operations for a topic.
 * @see Topic
 */
class TopicInternalPrx : public virtual ::Ice::Proxy<TopicInternalPrx, TopicPrx>
{
public:

    /**
     * Retrieve a proxy to the TopicLink interface.
     * @param context The Context map to send with the invocation.
     * @return The TopicLink for the Topic.
     */
    ::std::shared_ptr<TopicLinkPrx> getLinkProxy(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceStorm::TopicLinkPrx>>(true, this, &TopicInternalPrx::_iceI_getLinkProxy, context).get();
    }

    /**
     * Retrieve a proxy to the TopicLink interface.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getLinkProxyAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::IceStorm::TopicLinkPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceStorm::TopicLinkPrx>, P>(false, this, &TopicInternalPrx::_iceI_getLinkProxy, context);
    }

    /**
     * Retrieve a proxy to the TopicLink interface.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getLinkProxyAsync(::std::function<void(::std::shared_ptr<::IceStorm::TopicLinkPrx>)> response,
                      ::std::function<void(::std::exception_ptr)> ex = nullptr,
                      ::std::function<void(bool)> sent = nullptr,
                      const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::IceStorm::TopicLinkPrx>>(std::move(response), std::move(ex), std::move(sent), this, &IceStorm::TopicInternalPrx::_iceI_getLinkProxy, context);
    }

    /// \cond INTERNAL
    void _iceI_getLinkProxy(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::IceStorm::TopicLinkPrx>>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Reap the given identities.
     * @param id The sequence of identities.
     * @param context The Context map to send with the invocation.
     * @throws IceStorm::ReapWouldBlock Raised if the reap call would block.
     */
    void reap(const ::Ice::IdentitySeq& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &TopicInternalPrx::_iceI_reap, id, context).get();
    }

    /**
     * Reap the given identities.
     * @param id The sequence of identities.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto reapAsync(const ::Ice::IdentitySeq& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &TopicInternalPrx::_iceI_reap, id, context);
    }

    /**
     * Reap the given identities.
     * @param id The sequence of identities.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    reapAsync(const ::Ice::IdentitySeq& id,
              ::std::function<void()> response,
              ::std::function<void(::std::exception_ptr)> ex = nullptr,
              ::std::function<void(bool)> sent = nullptr,
              const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceStorm::TopicInternalPrx::_iceI_reap, id, context);
    }

    /// \cond INTERNAL
    void _iceI_reap(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::Ice::IdentitySeq&, const ::Ice::Context&);
    /// \endcond

    /**
     * Obtains the Slice type ID of this interface.
     * @return The fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

protected:

    /// \cond INTERNAL
    TopicInternalPrx() = default;
    friend ::std::shared_ptr<TopicInternalPrx> IceInternal::createProxy<TopicInternalPrx>();

    virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
    /// \endcond
};

/**
 * Internal operations for a topic manager.
 * @see TopicManager
 */
class TopicManagerInternalPrx : public virtual ::Ice::Proxy<TopicManagerInternalPrx, TopicManagerPrx>
{
public:

    /**
     * Return the replica node proxy for this topic manager.
     * @param context The Context map to send with the invocation.
     * @return The replica proxy, or null if this instance is not
     * replicated.
     */
    ::std::shared_ptr<::IceStormElection::NodePrx> getReplicaNode(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceStormElection::NodePrx>>(true, this, &TopicManagerInternalPrx::_iceI_getReplicaNode, context).get();
    }

    /**
     * Return the replica node proxy for this topic manager.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getReplicaNodeAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::IceStormElection::NodePrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::IceStormElection::NodePrx>, P>(false, this, &TopicManagerInternalPrx::_iceI_getReplicaNode, context);
    }

    /**
     * Return the replica node proxy for this topic manager.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getReplicaNodeAsync(::std::function<void(::std::shared_ptr<::IceStormElection::NodePrx>)> response,
                        ::std::function<void(::std::exception_ptr)> ex = nullptr,
                        ::std::function<void(bool)> sent = nullptr,
                        const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::IceStormElection::NodePrx>>(std::move(response), std::move(ex), std::move(sent), this, &IceStorm::TopicManagerInternalPrx::_iceI_getReplicaNode, context);
    }

    /// \cond INTERNAL
    void _iceI_getReplicaNode(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::IceStormElection::NodePrx>>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Obtains the Slice type ID of this interface.
     * @return The fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

protected:

    /// \cond INTERNAL
    TopicManagerInternalPrx() = default;
    friend ::std::shared_ptr<TopicManagerInternalPrx> IceInternal::createProxy<TopicManagerInternalPrx>();

    virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
    /// \endcond
};

}

/// \cond STREAM
namespace Ice
{

template<>
struct StreamableTraits<::IceStorm::EventData>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 4;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::IceStorm::EventData, S>
{
    static void read(S* istr, ::IceStorm::EventData& v)
    {
        istr->readAll(v.op, v.mode, v.data, v.context);
    }
};

}
/// \endcond

/// \cond INTERNAL
namespace IceStorm
{

using TopicLinkPtr = ::std::shared_ptr<TopicLink>;
using TopicLinkPrxPtr = ::std::shared_ptr<TopicLinkPrx>;

using TopicInternalPtr = ::std::shared_ptr<TopicInternal>;
using TopicInternalPrxPtr = ::std::shared_ptr<TopicInternalPrx>;

using TopicManagerInternalPtr = ::std::shared_ptr<TopicManagerInternal>;
using TopicManagerInternalPrxPtr = ::std::shared_ptr<TopicManagerInternalPrx>;

}
/// \endcond

#else // C++98 mapping

namespace IceProxy
{

namespace IceStorm
{

class TopicLink;
/// \cond INTERNAL
void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< TopicLink>&);
::IceProxy::Ice::Object* upCast(TopicLink*);
/// \endcond

class TopicInternal;
/// \cond INTERNAL
void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< TopicInternal>&);
::IceProxy::Ice::Object* upCast(TopicInternal*);
/// \endcond

class TopicManagerInternal;
/// \cond INTERNAL
void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< TopicManagerInternal>&);
::IceProxy::Ice::Object* upCast(TopicManagerInternal*);
/// \endcond

}

}

namespace IceStorm
{

class TopicLink;
/// \cond INTERNAL
::Ice::Object* upCast(TopicLink*);
/// \endcond
typedef ::IceInternal::Handle< TopicLink> TopicLinkPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceStorm::TopicLink> TopicLinkPrx;
typedef TopicLinkPrx TopicLinkPrxPtr;
/// \cond INTERNAL
void _icePatchObjectPtr(TopicLinkPtr&, const ::Ice::ObjectPtr&);
/// \endcond

class TopicInternal;
/// \cond INTERNAL
::Ice::Object* upCast(TopicInternal*);
/// \endcond
typedef ::IceInternal::Handle< TopicInternal> TopicInternalPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceStorm::TopicInternal> TopicInternalPrx;
typedef TopicInternalPrx TopicInternalPrxPtr;
/// \cond INTERNAL
void _icePatchObjectPtr(TopicInternalPtr&, const ::Ice::ObjectPtr&);
/// \endcond

class TopicManagerInternal;
/// \cond INTERNAL
::Ice::Object* upCast(TopicManagerInternal*);
/// \endcond
typedef ::IceInternal::Handle< TopicManagerInternal> TopicManagerInternalPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceStorm::TopicManagerInternal> TopicManagerInternalPrx;
typedef TopicManagerInternalPrx TopicManagerInternalPrxPtr;
/// \cond INTERNAL
void _icePatchObjectPtr(TopicManagerInternalPtr&, const ::Ice::ObjectPtr&);
/// \endcond

}

namespace IceStorm
{

/**
 * The event data.
 */
class EventData : public IceUtil::Shared
{
public:
    
    EventData() {}
    /**
     * One-shot constructor to initialize all data members.
     * @param op The operation name.
     * @param mode The operation mode.
     * @param data The encoded data for the operation's input parameters.
     * @param context The Ice::Current::Context data from the originating request.
     */
    EventData(const ::std::string& op, ::Ice::OperationMode mode, const ::Ice::ByteSeq& data, const ::Ice::Context& context) :
        op(op),
        mode(mode),
        data(data),
        context(context)
    {
    }
    

    /**
     * The operation name.
     */
    ::std::string op;
    /**
     * The operation mode.
     */
    ::Ice::OperationMode mode;
    /**
     * The encoded data for the operation's input parameters.
     */
    ::Ice::ByteSeq data;
    /**
     * The Ice::Current::Context data from the originating request.
     */
    ::Ice::Context context;
};

typedef ::IceUtil::Handle< ::IceStorm::EventData> EventDataPtr;

class SendQueueSizeMaxReached : public ::Ice::LocalException
{
public:

    /**
     * The file and line number are required for all local exceptions.
     * @param file The file name in which the exception was raised, typically __FILE__.
     * @param line The line number at which the exception was raised, typically __LINE__.
     */
    SendQueueSizeMaxReached(const char* file, int line);

#ifdef ICE_CPP11_COMPILER
    SendQueueSizeMaxReached(const SendQueueSizeMaxReached&) = default;
    virtual ~SendQueueSizeMaxReached();
#else
    virtual ~SendQueueSizeMaxReached() throw();
#endif

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    virtual ::std::string ice_id() const;
    /**
     * Polymorphically clones this exception.
     * @return A shallow copy of this exception.
     */
    virtual SendQueueSizeMaxReached* ice_clone() const;
    /**
     * Throws this exception.
     */
    virtual void ice_throw() const;
};

/**
 * A sequence of EventData.
 */
typedef std::deque< ::IceStorm::EventDataPtr> EventDataSeq;

/**
 * Thrown if the reap call would block.
 */
class ReapWouldBlock : public ::Ice::UserException
{
public:

    ReapWouldBlock() {}

#ifdef ICE_CPP11_COMPILER
    ReapWouldBlock(const ReapWouldBlock&) = default;
    virtual ~ReapWouldBlock();
#else
    virtual ~ReapWouldBlock() throw();
#endif

    /**
     * Obtains the Slice type ID of this exception.
     * @return The fully-scoped type ID.
     */
    virtual ::std::string ice_id() const;
    /**
     * Polymorphically clones this exception.
     * @return A shallow copy of this exception.
     */
    virtual ReapWouldBlock* ice_clone() const;
    /**
     * Throws this exception.
     */
    virtual void ice_throw() const;

protected:

    /// \cond STREAM
    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
    /// \endcond
};

/// \cond INTERNAL
static ReapWouldBlock _iceS_ReapWouldBlock_init;
/// \endcond

}

namespace IceStorm
{

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceStorm::TopicLink::begin_forward.
 * Create a wrapper instance by calling ::IceStorm::newCallback_TopicLink_forward.
 */
class Callback_TopicLink_forward_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_TopicLink_forward_Base> Callback_TopicLink_forwardPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceStorm::TopicInternal::begin_getLinkProxy.
 * Create a wrapper instance by calling ::IceStorm::newCallback_TopicInternal_getLinkProxy.
 */
class Callback_TopicInternal_getLinkProxy_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_TopicInternal_getLinkProxy_Base> Callback_TopicInternal_getLinkProxyPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceStorm::TopicInternal::begin_reap.
 * Create a wrapper instance by calling ::IceStorm::newCallback_TopicInternal_reap.
 */
class Callback_TopicInternal_reap_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_TopicInternal_reap_Base> Callback_TopicInternal_reapPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceStorm::TopicManagerInternal::begin_getReplicaNode.
 * Create a wrapper instance by calling ::IceStorm::newCallback_TopicManagerInternal_getReplicaNode.
 */
class Callback_TopicManagerInternal_getReplicaNode_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_TopicManagerInternal_getReplicaNode_Base> Callback_TopicManagerInternal_getReplicaNodePtr;

}

namespace IceProxy
{

namespace IceStorm
{

class TopicLink : public virtual ::Ice::Proxy<TopicLink, ::IceProxy::Ice::Object>
{
public:

    /**
     * Forward a sequence of events.
     * @param events The events to forward.
     * @param context The Context map to send with the invocation.
     */
    void forward(const ::IceStorm::EventDataSeq& events, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_forward(_iceI_begin_forward(events, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Forward a sequence of events.
     * @param events The events to forward.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_forward(const ::IceStorm::EventDataSeq& events, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_forward(events, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Forward a sequence of events.
     * @param events The events to forward.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_forward(const ::IceStorm::EventDataSeq& events, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_forward(events, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Forward a sequence of events.
     * @param events The events to forward.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_forward(const ::IceStorm::EventDataSeq& events, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_forward(events, context, cb, cookie);
    }

    /**
     * Forward a sequence of events.
     * @param events The events to forward.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_forward(const ::IceStorm::EventDataSeq& events, const ::IceStorm::Callback_TopicLink_forwardPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_forward(events, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Forward a sequence of events.
     * @param events The events to forward.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_forward(const ::IceStorm::EventDataSeq& events, const ::Ice::Context& context, const ::IceStorm::Callback_TopicLink_forwardPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_forward(events, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_forward.
     * @param result The asynchronous result object for the invocation.
     */
    void end_forward(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_forward(const ::IceStorm::EventDataSeq&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Obtains the Slice type ID corresponding to this interface.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

class TopicInternal : public virtual ::Ice::Proxy<TopicInternal, ::IceProxy::IceStorm::Topic>
{
public:

    /**
     * Retrieve a proxy to the TopicLink interface.
     * @param context The Context map to send with the invocation.
     * @return The TopicLink for the Topic.
     */
    ::IceStorm::TopicLinkPrx getLinkProxy(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getLinkProxy(_iceI_begin_getLinkProxy(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Retrieve a proxy to the TopicLink interface.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getLinkProxy(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getLinkProxy(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Retrieve a proxy to the TopicLink interface.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getLinkProxy(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLinkProxy(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Retrieve a proxy to the TopicLink interface.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getLinkProxy(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLinkProxy(context, cb, cookie);
    }

    /**
     * Retrieve a proxy to the TopicLink interface.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getLinkProxy(const ::IceStorm::Callback_TopicInternal_getLinkProxyPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLinkProxy(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Retrieve a proxy to the TopicLink interface.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getLinkProxy(const ::Ice::Context& context, const ::IceStorm::Callback_TopicInternal_getLinkProxyPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getLinkProxy(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getLinkProxy.
     * @param result The asynchronous result object for the invocation.
     * @return The TopicLink for the Topic.
     */
    ::IceStorm::TopicLinkPrx end_getLinkProxy(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_getLinkProxy(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Reap the given identities.
     * @param id The sequence of identities.
     * @param context The Context map to send with the invocation.
     * @throws IceStorm::ReapWouldBlock Raised if the reap call would block.
     */
    void reap(const ::Ice::IdentitySeq& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_reap(_iceI_begin_reap(id, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Reap the given identities.
     * @param id The sequence of identities.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_reap(const ::Ice::IdentitySeq& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_reap(id, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Reap the given identities.
     * @param id The sequence of identities.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_reap(const ::Ice::IdentitySeq& id, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_reap(id, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Reap the given identities.
     * @param id The sequence of identities.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_reap(const ::Ice::IdentitySeq& id, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_reap(id, context, cb, cookie);
    }

    /**
     * Reap the given identities.
     * @param id The sequence of identities.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_reap(const ::Ice::IdentitySeq& id, const ::IceStorm::Callback_TopicInternal_reapPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_reap(id, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Reap the given identities.
     * @param id The sequence of identities.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_reap(const ::Ice::IdentitySeq& id, const ::Ice::Context& context, const ::IceStorm::Callback_TopicInternal_reapPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_reap(id, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_reap.
     * @param result The asynchronous result object for the invocation.
     * @throws IceStorm::ReapWouldBlock Raised if the reap call would block.
     */
    void end_reap(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_reap(const ::Ice::IdentitySeq&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Obtains the Slice type ID corresponding to this interface.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

class TopicManagerInternal : public virtual ::Ice::Proxy<TopicManagerInternal, ::IceProxy::IceStorm::TopicManager>
{
public:

    /**
     * Return the replica node proxy for this topic manager.
     * @param context The Context map to send with the invocation.
     * @return The replica proxy, or null if this instance is not
     * replicated.
     */
    ::IceStormElection::NodePrx getReplicaNode(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getReplicaNode(_iceI_begin_getReplicaNode(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Return the replica node proxy for this topic manager.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getReplicaNode(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getReplicaNode(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Return the replica node proxy for this topic manager.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getReplicaNode(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getReplicaNode(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Return the replica node proxy for this topic manager.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getReplicaNode(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getReplicaNode(context, cb, cookie);
    }

    /**
     * Return the replica node proxy for this topic manager.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getReplicaNode(const ::IceStorm::Callback_TopicManagerInternal_getReplicaNodePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getReplicaNode(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Return the replica node proxy for this topic manager.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getReplicaNode(const ::Ice::Context& context, const ::IceStorm::Callback_TopicManagerInternal_getReplicaNodePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getReplicaNode(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getReplicaNode.
     * @param result The asynchronous result object for the invocation.
     * @return The replica proxy, or null if this instance is not
     * replicated.
     */
    ::IceStormElection::NodePrx end_getReplicaNode(const ::Ice::AsyncResultPtr& result);

private:

    ::Ice::AsyncResultPtr _iceI_begin_getReplicaNode(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Obtains the Slice type ID corresponding to this interface.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

}

}

namespace IceStorm
{

/**
 * The TopicLink interface. This is used to forward events between
 * federated Topic instances.
 * @see TopicInternal
 */
class TopicLink : public virtual ::Ice::Object
{
public:

    typedef TopicLinkPrx ProxyType;
    typedef TopicLinkPtr PointerType;

    virtual ~TopicLink();

#ifdef ICE_CPP11_COMPILER
    TopicLink() = default;
    TopicLink(const TopicLink&) = default;
    TopicLink& operator=(const TopicLink&) = default;
#endif

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Forward a sequence of events.
     * @param events The events to forward.
     * @param current The Current object for the invocation.
     */
    virtual void forward(const EventDataSeq& events, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_forward(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond
};

/// \cond INTERNAL
inline bool operator==(const TopicLink& lhs, const TopicLink& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const TopicLink& lhs, const TopicLink& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

/**
 * Internal operations for a topic.
 * @see Topic
 */
class TopicInternal : virtual public Topic
{
public:

    typedef TopicInternalPrx ProxyType;
    typedef TopicInternalPtr PointerType;

    virtual ~TopicInternal();

#ifdef ICE_CPP11_COMPILER
    TopicInternal() = default;
    TopicInternal(const TopicInternal&) = default;
    TopicInternal& operator=(const TopicInternal&) = default;
#endif

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Retrieve a proxy to the TopicLink interface.
     * @param current The Current object for the invocation.
     * @return The TopicLink for the Topic.
     */
    virtual TopicLinkPrx getLinkProxy(const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_getLinkProxy(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Reap the given identities.
     * @param id The sequence of identities.
     * @param current The Current object for the invocation.
     * @throws IceStorm::ReapWouldBlock Raised if the reap call would block.
     */
    virtual void reap(const ::Ice::IdentitySeq& id, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_reap(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond
};

/// \cond INTERNAL
inline bool operator==(const TopicInternal& lhs, const TopicInternal& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const TopicInternal& lhs, const TopicInternal& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

/**
 * Internal operations for a topic manager.
 * @see TopicManager
 */
class TopicManagerInternal : virtual public TopicManager
{
public:

    typedef TopicManagerInternalPrx ProxyType;
    typedef TopicManagerInternalPtr PointerType;

    virtual ~TopicManagerInternal();

#ifdef ICE_CPP11_COMPILER
    TopicManagerInternal() = default;
    TopicManagerInternal(const TopicManagerInternal&) = default;
    TopicManagerInternal& operator=(const TopicManagerInternal&) = default;
#endif

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Return the replica node proxy for this topic manager.
     * @param current The Current object for the invocation.
     * @return The replica proxy, or null if this instance is not
     * replicated.
     */
    virtual ::IceStormElection::NodePrx getReplicaNode(const ::Ice::Current& current = ::Ice::emptyCurrent) const = 0;
    /// \cond INTERNAL
    bool _iceD_getReplicaNode(::IceInternal::Incoming&, const ::Ice::Current&) const;
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond
};

/// \cond INTERNAL
inline bool operator==(const TopicManagerInternal& lhs, const TopicManagerInternal& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const TopicManagerInternal& lhs, const TopicManagerInternal& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

}

/// \cond STREAM
namespace Ice
{

template<>
struct StreamableTraits< ::IceStorm::EventDataPtr>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStructClass;
    static const int minWireSize = 4;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::IceStorm::EventDataPtr, S>
{
    static void write(S* ostr, const ::IceStorm::EventDataPtr& v)
    {
        ostr->write(v->op);
        ostr->write(v->mode);
        ostr->write(v->data);
        ostr->write(v->context);
    }
};

template<typename S>
struct StreamReader< ::IceStorm::EventDataPtr, S>
{
    static void read(S* istr, ::IceStorm::EventDataPtr& v)
    {
        istr->read(v->op);
        istr->read(v->mode);
        istr->read(v->data);
        istr->read(v->context);
    }
};

template<>
struct StreamableTraits< ::IceStorm::ReapWouldBlock>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

}
/// \endcond

namespace IceStorm
{

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceStorm::TopicLink::begin_forward.
 * Create a wrapper instance by calling ::IceStorm::newCallback_TopicLink_forward.
 */
template<class T>
class CallbackNC_TopicLink_forward : public Callback_TopicLink_forward_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_TopicLink_forward(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::TopicLink::begin_forward.
 */
template<class T> Callback_TopicLink_forwardPtr
newCallback_TopicLink_forward(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_TopicLink_forward<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::TopicLink::begin_forward.
 */
template<class T> Callback_TopicLink_forwardPtr
newCallback_TopicLink_forward(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_TopicLink_forward<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::TopicLink::begin_forward.
 */
template<class T> Callback_TopicLink_forwardPtr
newCallback_TopicLink_forward(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_TopicLink_forward<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::TopicLink::begin_forward.
 */
template<class T> Callback_TopicLink_forwardPtr
newCallback_TopicLink_forward(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_TopicLink_forward<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceStorm::TopicLink::begin_forward.
 * Create a wrapper instance by calling ::IceStorm::newCallback_TopicLink_forward.
 */
template<class T, typename CT>
class Callback_TopicLink_forward : public Callback_TopicLink_forward_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_TopicLink_forward(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::TopicLink::begin_forward.
 */
template<class T, typename CT> Callback_TopicLink_forwardPtr
newCallback_TopicLink_forward(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_TopicLink_forward<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::TopicLink::begin_forward.
 */
template<class T, typename CT> Callback_TopicLink_forwardPtr
newCallback_TopicLink_forward(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_TopicLink_forward<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::TopicLink::begin_forward.
 */
template<class T, typename CT> Callback_TopicLink_forwardPtr
newCallback_TopicLink_forward(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_TopicLink_forward<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::TopicLink::begin_forward.
 */
template<class T, typename CT> Callback_TopicLink_forwardPtr
newCallback_TopicLink_forward(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_TopicLink_forward<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceStorm::TopicInternal::begin_getLinkProxy.
 * Create a wrapper instance by calling ::IceStorm::newCallback_TopicInternal_getLinkProxy.
 */
template<class T>
class CallbackNC_TopicInternal_getLinkProxy : public Callback_TopicInternal_getLinkProxy_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const TopicLinkPrx&);

    CallbackNC_TopicInternal_getLinkProxy(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        TopicInternalPrx proxy = TopicInternalPrx::uncheckedCast(result->getProxy());
        TopicLinkPrx ret;
        try
        {
            ret = proxy->end_getLinkProxy(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::TopicInternal::begin_getLinkProxy.
 */
template<class T> Callback_TopicInternal_getLinkProxyPtr
newCallback_TopicInternal_getLinkProxy(const IceUtil::Handle<T>& instance, void (T::*cb)(const TopicLinkPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_TopicInternal_getLinkProxy<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::TopicInternal::begin_getLinkProxy.
 */
template<class T> Callback_TopicInternal_getLinkProxyPtr
newCallback_TopicInternal_getLinkProxy(T* instance, void (T::*cb)(const TopicLinkPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_TopicInternal_getLinkProxy<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceStorm::TopicInternal::begin_getLinkProxy.
 * Create a wrapper instance by calling ::IceStorm::newCallback_TopicInternal_getLinkProxy.
 */
template<class T, typename CT>
class Callback_TopicInternal_getLinkProxy : public Callback_TopicInternal_getLinkProxy_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const TopicLinkPrx&, const CT&);

    Callback_TopicInternal_getLinkProxy(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        TopicInternalPrx proxy = TopicInternalPrx::uncheckedCast(result->getProxy());
        TopicLinkPrx ret;
        try
        {
            ret = proxy->end_getLinkProxy(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::TopicInternal::begin_getLinkProxy.
 */
template<class T, typename CT> Callback_TopicInternal_getLinkProxyPtr
newCallback_TopicInternal_getLinkProxy(const IceUtil::Handle<T>& instance, void (T::*cb)(const TopicLinkPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_TopicInternal_getLinkProxy<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::TopicInternal::begin_getLinkProxy.
 */
template<class T, typename CT> Callback_TopicInternal_getLinkProxyPtr
newCallback_TopicInternal_getLinkProxy(T* instance, void (T::*cb)(const TopicLinkPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_TopicInternal_getLinkProxy<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceStorm::TopicInternal::begin_reap.
 * Create a wrapper instance by calling ::IceStorm::newCallback_TopicInternal_reap.
 */
template<class T>
class CallbackNC_TopicInternal_reap : public Callback_TopicInternal_reap_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_TopicInternal_reap(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        TopicInternalPrx proxy = TopicInternalPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_reap(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::TopicInternal::begin_reap.
 */
template<class T> Callback_TopicInternal_reapPtr
newCallback_TopicInternal_reap(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_TopicInternal_reap<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::TopicInternal::begin_reap.
 */
template<class T> Callback_TopicInternal_reapPtr
newCallback_TopicInternal_reap(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_TopicInternal_reap<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::TopicInternal::begin_reap.
 */
template<class T> Callback_TopicInternal_reapPtr
newCallback_TopicInternal_reap(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_TopicInternal_reap<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::TopicInternal::begin_reap.
 */
template<class T> Callback_TopicInternal_reapPtr
newCallback_TopicInternal_reap(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_TopicInternal_reap<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceStorm::TopicInternal::begin_reap.
 * Create a wrapper instance by calling ::IceStorm::newCallback_TopicInternal_reap.
 */
template<class T, typename CT>
class Callback_TopicInternal_reap : public Callback_TopicInternal_reap_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_TopicInternal_reap(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        TopicInternalPrx proxy = TopicInternalPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_reap(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::TopicInternal::begin_reap.
 */
template<class T, typename CT> Callback_TopicInternal_reapPtr
newCallback_TopicInternal_reap(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_TopicInternal_reap<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::TopicInternal::begin_reap.
 */
template<class T, typename CT> Callback_TopicInternal_reapPtr
newCallback_TopicInternal_reap(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_TopicInternal_reap<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::TopicInternal::begin_reap.
 */
template<class T, typename CT> Callback_TopicInternal_reapPtr
newCallback_TopicInternal_reap(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_TopicInternal_reap<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::TopicInternal::begin_reap.
 */
template<class T, typename CT> Callback_TopicInternal_reapPtr
newCallback_TopicInternal_reap(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_TopicInternal_reap<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceStorm::TopicManagerInternal::begin_getReplicaNode.
 * Create a wrapper instance by calling ::IceStorm::newCallback_TopicManagerInternal_getReplicaNode.
 */
template<class T>
class CallbackNC_TopicManagerInternal_getReplicaNode : public Callback_TopicManagerInternal_getReplicaNode_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::IceStormElection::NodePrx&);

    CallbackNC_TopicManagerInternal_getReplicaNode(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        TopicManagerInternalPrx proxy = TopicManagerInternalPrx::uncheckedCast(result->getProxy());
        ::IceStormElection::NodePrx ret;
        try
        {
            ret = proxy->end_getReplicaNode(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::TopicManagerInternal::begin_getReplicaNode.
 */
template<class T> Callback_TopicManagerInternal_getReplicaNodePtr
newCallback_TopicManagerInternal_getReplicaNode(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IceStormElection::NodePrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_TopicManagerInternal_getReplicaNode<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::TopicManagerInternal::begin_getReplicaNode.
 */
template<class T> Callback_TopicManagerInternal_getReplicaNodePtr
newCallback_TopicManagerInternal_getReplicaNode(T* instance, void (T::*cb)(const ::IceStormElection::NodePrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_TopicManagerInternal_getReplicaNode<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceStorm::TopicManagerInternal::begin_getReplicaNode.
 * Create a wrapper instance by calling ::IceStorm::newCallback_TopicManagerInternal_getReplicaNode.
 */
template<class T, typename CT>
class Callback_TopicManagerInternal_getReplicaNode : public Callback_TopicManagerInternal_getReplicaNode_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::IceStormElection::NodePrx&, const CT&);

    Callback_TopicManagerInternal_getReplicaNode(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        TopicManagerInternalPrx proxy = TopicManagerInternalPrx::uncheckedCast(result->getProxy());
        ::IceStormElection::NodePrx ret;
        try
        {
            ret = proxy->end_getReplicaNode(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::TopicManagerInternal::begin_getReplicaNode.
 */
template<class T, typename CT> Callback_TopicManagerInternal_getReplicaNodePtr
newCallback_TopicManagerInternal_getReplicaNode(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IceStormElection::NodePrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_TopicManagerInternal_getReplicaNode<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceStorm::TopicManagerInternal::begin_getReplicaNode.
 */
template<class T, typename CT> Callback_TopicManagerInternal_getReplicaNodePtr
newCallback_TopicManagerInternal_getReplicaNode(T* instance, void (T::*cb)(const ::IceStormElection::NodePrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_TopicManagerInternal_getReplicaNode<T, CT>(instance, cb, excb, sentcb);
}

}

#endif

#include <IceUtil/PopDisableWarnings.h>
#endif
