/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(OFFSCREEN_CANVAS)

#include "JSOffscreenCanvasRenderingContext2D.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "InspectorCanvasCallTracer.h"
#include "JSCSSStyleImageValue.h"
#include "JSCanvasDirection.h"
#include "JSCanvasFillRule.h"
#include "JSCanvasGradient.h"
#include "JSCanvasLineCap.h"
#include "JSCanvasLineJoin.h"
#include "JSCanvasPattern.h"
#include "JSCanvasTextAlign.h"
#include "JSCanvasTextBaseline.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMMatrix.h"
#include "JSDOMMatrix2DInit.h"
#include "JSDOMOperation.h"
#include "JSDOMPointInit.h"
#include "JSDOMWrapperCache.h"
#include "JSHTMLCanvasElement.h"
#include "JSHTMLImageElement.h"
#include "JSHTMLVideoElement.h"
#include "JSImageBitmap.h"
#include "JSImageData.h"
#include "JSImageDataSettings.h"
#include "JSImageSmoothingQuality.h"
#include "JSOffscreenCanvas.h"
#include "JSPath2D.h"
#include "JSSVGImageElement.h"
#include "JSTextMetrics.h"
#include "JSWebCodecsVideoFrame.h"
#include "ScriptExecutionContext.h"
#include "Settings.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/IteratorOperations.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/Variant.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_drawImage);
static JSC_DECLARE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_beginPath);
static JSC_DECLARE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_fill);
static JSC_DECLARE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_stroke);
static JSC_DECLARE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_clip);
static JSC_DECLARE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_isPointInPath);
static JSC_DECLARE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_isPointInStroke);
static JSC_DECLARE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_createLinearGradient);
static JSC_DECLARE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_createRadialGradient);
static JSC_DECLARE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_createConicGradient);
static JSC_DECLARE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_createPattern);
static JSC_DECLARE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_createImageData);
static JSC_DECLARE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_getImageData);
static JSC_DECLARE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_putImageData);
static JSC_DECLARE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_beginLayer);
static JSC_DECLARE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_endLayer);
static JSC_DECLARE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_closePath);
static JSC_DECLARE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_moveTo);
static JSC_DECLARE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_lineTo);
static JSC_DECLARE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_quadraticCurveTo);
static JSC_DECLARE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_bezierCurveTo);
static JSC_DECLARE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_arcTo);
static JSC_DECLARE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_rect);
static JSC_DECLARE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_roundRect);
static JSC_DECLARE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_arc);
static JSC_DECLARE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_ellipse);
static JSC_DECLARE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_setLineDash);
static JSC_DECLARE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_getLineDash);
static JSC_DECLARE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_clearRect);
static JSC_DECLARE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_fillRect);
static JSC_DECLARE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_strokeRect);
static JSC_DECLARE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_save);
static JSC_DECLARE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_restore);
static JSC_DECLARE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_reset);
static JSC_DECLARE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_fillText);
static JSC_DECLARE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_strokeText);
static JSC_DECLARE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_measureText);
static JSC_DECLARE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_scale);
static JSC_DECLARE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_rotate);
static JSC_DECLARE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_translate);
static JSC_DECLARE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_transform);
static JSC_DECLARE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_getTransform);
static JSC_DECLARE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_setTransform);
static JSC_DECLARE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_resetTransform);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsOffscreenCanvasRenderingContext2DConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsOffscreenCanvasRenderingContext2D_canvas);
static JSC_DECLARE_CUSTOM_GETTER(jsOffscreenCanvasRenderingContext2D_globalAlpha);
static JSC_DECLARE_CUSTOM_SETTER(setJSOffscreenCanvasRenderingContext2D_globalAlpha);
static JSC_DECLARE_CUSTOM_GETTER(jsOffscreenCanvasRenderingContext2D_globalCompositeOperation);
static JSC_DECLARE_CUSTOM_SETTER(setJSOffscreenCanvasRenderingContext2D_globalCompositeOperation);
static JSC_DECLARE_CUSTOM_GETTER(jsOffscreenCanvasRenderingContext2D_strokeStyle);
static JSC_DECLARE_CUSTOM_SETTER(setJSOffscreenCanvasRenderingContext2D_strokeStyle);
static JSC_DECLARE_CUSTOM_GETTER(jsOffscreenCanvasRenderingContext2D_fillStyle);
static JSC_DECLARE_CUSTOM_SETTER(setJSOffscreenCanvasRenderingContext2D_fillStyle);
static JSC_DECLARE_CUSTOM_GETTER(jsOffscreenCanvasRenderingContext2D_filter);
static JSC_DECLARE_CUSTOM_SETTER(setJSOffscreenCanvasRenderingContext2D_filter);
static JSC_DECLARE_CUSTOM_GETTER(jsOffscreenCanvasRenderingContext2D_imageSmoothingEnabled);
static JSC_DECLARE_CUSTOM_SETTER(setJSOffscreenCanvasRenderingContext2D_imageSmoothingEnabled);
static JSC_DECLARE_CUSTOM_GETTER(jsOffscreenCanvasRenderingContext2D_imageSmoothingQuality);
static JSC_DECLARE_CUSTOM_SETTER(setJSOffscreenCanvasRenderingContext2D_imageSmoothingQuality);
static JSC_DECLARE_CUSTOM_GETTER(jsOffscreenCanvasRenderingContext2D_lineWidth);
static JSC_DECLARE_CUSTOM_SETTER(setJSOffscreenCanvasRenderingContext2D_lineWidth);
static JSC_DECLARE_CUSTOM_GETTER(jsOffscreenCanvasRenderingContext2D_lineCap);
static JSC_DECLARE_CUSTOM_SETTER(setJSOffscreenCanvasRenderingContext2D_lineCap);
static JSC_DECLARE_CUSTOM_GETTER(jsOffscreenCanvasRenderingContext2D_lineJoin);
static JSC_DECLARE_CUSTOM_SETTER(setJSOffscreenCanvasRenderingContext2D_lineJoin);
static JSC_DECLARE_CUSTOM_GETTER(jsOffscreenCanvasRenderingContext2D_miterLimit);
static JSC_DECLARE_CUSTOM_SETTER(setJSOffscreenCanvasRenderingContext2D_miterLimit);
static JSC_DECLARE_CUSTOM_GETTER(jsOffscreenCanvasRenderingContext2D_lineDashOffset);
static JSC_DECLARE_CUSTOM_SETTER(setJSOffscreenCanvasRenderingContext2D_lineDashOffset);
static JSC_DECLARE_CUSTOM_GETTER(jsOffscreenCanvasRenderingContext2D_shadowOffsetX);
static JSC_DECLARE_CUSTOM_SETTER(setJSOffscreenCanvasRenderingContext2D_shadowOffsetX);
static JSC_DECLARE_CUSTOM_GETTER(jsOffscreenCanvasRenderingContext2D_shadowOffsetY);
static JSC_DECLARE_CUSTOM_SETTER(setJSOffscreenCanvasRenderingContext2D_shadowOffsetY);
static JSC_DECLARE_CUSTOM_GETTER(jsOffscreenCanvasRenderingContext2D_shadowBlur);
static JSC_DECLARE_CUSTOM_SETTER(setJSOffscreenCanvasRenderingContext2D_shadowBlur);
static JSC_DECLARE_CUSTOM_GETTER(jsOffscreenCanvasRenderingContext2D_shadowColor);
static JSC_DECLARE_CUSTOM_SETTER(setJSOffscreenCanvasRenderingContext2D_shadowColor);
static JSC_DECLARE_CUSTOM_GETTER(jsOffscreenCanvasRenderingContext2D_font);
static JSC_DECLARE_CUSTOM_SETTER(setJSOffscreenCanvasRenderingContext2D_font);
static JSC_DECLARE_CUSTOM_GETTER(jsOffscreenCanvasRenderingContext2D_textAlign);
static JSC_DECLARE_CUSTOM_SETTER(setJSOffscreenCanvasRenderingContext2D_textAlign);
static JSC_DECLARE_CUSTOM_GETTER(jsOffscreenCanvasRenderingContext2D_textBaseline);
static JSC_DECLARE_CUSTOM_SETTER(setJSOffscreenCanvasRenderingContext2D_textBaseline);
static JSC_DECLARE_CUSTOM_GETTER(jsOffscreenCanvasRenderingContext2D_direction);
static JSC_DECLARE_CUSTOM_SETTER(setJSOffscreenCanvasRenderingContext2D_direction);
static JSC_DECLARE_CUSTOM_GETTER(jsOffscreenCanvasRenderingContext2D_letterSpacing);
static JSC_DECLARE_CUSTOM_SETTER(setJSOffscreenCanvasRenderingContext2D_letterSpacing);
static JSC_DECLARE_CUSTOM_GETTER(jsOffscreenCanvasRenderingContext2D_wordSpacing);
static JSC_DECLARE_CUSTOM_SETTER(setJSOffscreenCanvasRenderingContext2D_wordSpacing);

class JSOffscreenCanvasRenderingContext2DPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSOffscreenCanvasRenderingContext2DPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSOffscreenCanvasRenderingContext2DPrototype* ptr = new (NotNull, JSC::allocateCell<JSOffscreenCanvasRenderingContext2DPrototype>(vm)) JSOffscreenCanvasRenderingContext2DPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSOffscreenCanvasRenderingContext2DPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSOffscreenCanvasRenderingContext2DPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSOffscreenCanvasRenderingContext2DPrototype, JSOffscreenCanvasRenderingContext2DPrototype::Base);

using JSOffscreenCanvasRenderingContext2DDOMConstructor = JSDOMConstructorNotConstructable<JSOffscreenCanvasRenderingContext2D>;

template<> const ClassInfo JSOffscreenCanvasRenderingContext2DDOMConstructor::s_info = { "OffscreenCanvasRenderingContext2D"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSOffscreenCanvasRenderingContext2DDOMConstructor) };

template<> JSValue JSOffscreenCanvasRenderingContext2DDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSOffscreenCanvasRenderingContext2DDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "OffscreenCanvasRenderingContext2D"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSOffscreenCanvasRenderingContext2D::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 68> JSOffscreenCanvasRenderingContext2DPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsOffscreenCanvasRenderingContext2DConstructor, 0 } },
    HashTableValue { "canvas"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsOffscreenCanvasRenderingContext2D_canvas, 0 } },
    HashTableValue { "globalAlpha"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsOffscreenCanvasRenderingContext2D_globalAlpha, setJSOffscreenCanvasRenderingContext2D_globalAlpha } },
    HashTableValue { "globalCompositeOperation"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsOffscreenCanvasRenderingContext2D_globalCompositeOperation, setJSOffscreenCanvasRenderingContext2D_globalCompositeOperation } },
    HashTableValue { "strokeStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsOffscreenCanvasRenderingContext2D_strokeStyle, setJSOffscreenCanvasRenderingContext2D_strokeStyle } },
    HashTableValue { "fillStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsOffscreenCanvasRenderingContext2D_fillStyle, setJSOffscreenCanvasRenderingContext2D_fillStyle } },
    HashTableValue { "filter"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsOffscreenCanvasRenderingContext2D_filter, setJSOffscreenCanvasRenderingContext2D_filter } },
    HashTableValue { "imageSmoothingEnabled"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsOffscreenCanvasRenderingContext2D_imageSmoothingEnabled, setJSOffscreenCanvasRenderingContext2D_imageSmoothingEnabled } },
    HashTableValue { "imageSmoothingQuality"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsOffscreenCanvasRenderingContext2D_imageSmoothingQuality, setJSOffscreenCanvasRenderingContext2D_imageSmoothingQuality } },
    HashTableValue { "lineWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsOffscreenCanvasRenderingContext2D_lineWidth, setJSOffscreenCanvasRenderingContext2D_lineWidth } },
    HashTableValue { "lineCap"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsOffscreenCanvasRenderingContext2D_lineCap, setJSOffscreenCanvasRenderingContext2D_lineCap } },
    HashTableValue { "lineJoin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsOffscreenCanvasRenderingContext2D_lineJoin, setJSOffscreenCanvasRenderingContext2D_lineJoin } },
    HashTableValue { "miterLimit"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsOffscreenCanvasRenderingContext2D_miterLimit, setJSOffscreenCanvasRenderingContext2D_miterLimit } },
    HashTableValue { "lineDashOffset"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsOffscreenCanvasRenderingContext2D_lineDashOffset, setJSOffscreenCanvasRenderingContext2D_lineDashOffset } },
    HashTableValue { "shadowOffsetX"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsOffscreenCanvasRenderingContext2D_shadowOffsetX, setJSOffscreenCanvasRenderingContext2D_shadowOffsetX } },
    HashTableValue { "shadowOffsetY"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsOffscreenCanvasRenderingContext2D_shadowOffsetY, setJSOffscreenCanvasRenderingContext2D_shadowOffsetY } },
    HashTableValue { "shadowBlur"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsOffscreenCanvasRenderingContext2D_shadowBlur, setJSOffscreenCanvasRenderingContext2D_shadowBlur } },
    HashTableValue { "shadowColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsOffscreenCanvasRenderingContext2D_shadowColor, setJSOffscreenCanvasRenderingContext2D_shadowColor } },
    HashTableValue { "font"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsOffscreenCanvasRenderingContext2D_font, setJSOffscreenCanvasRenderingContext2D_font } },
    HashTableValue { "textAlign"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsOffscreenCanvasRenderingContext2D_textAlign, setJSOffscreenCanvasRenderingContext2D_textAlign } },
    HashTableValue { "textBaseline"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsOffscreenCanvasRenderingContext2D_textBaseline, setJSOffscreenCanvasRenderingContext2D_textBaseline } },
    HashTableValue { "direction"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsOffscreenCanvasRenderingContext2D_direction, setJSOffscreenCanvasRenderingContext2D_direction } },
    HashTableValue { "letterSpacing"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsOffscreenCanvasRenderingContext2D_letterSpacing, setJSOffscreenCanvasRenderingContext2D_letterSpacing } },
    HashTableValue { "wordSpacing"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsOffscreenCanvasRenderingContext2D_wordSpacing, setJSOffscreenCanvasRenderingContext2D_wordSpacing } },
    HashTableValue { "drawImage"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsOffscreenCanvasRenderingContext2DPrototypeFunction_drawImage, 3 } },
    HashTableValue { "beginPath"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsOffscreenCanvasRenderingContext2DPrototypeFunction_beginPath, 0 } },
    HashTableValue { "fill"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsOffscreenCanvasRenderingContext2DPrototypeFunction_fill, 0 } },
    HashTableValue { "stroke"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsOffscreenCanvasRenderingContext2DPrototypeFunction_stroke, 0 } },
    HashTableValue { "clip"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsOffscreenCanvasRenderingContext2DPrototypeFunction_clip, 0 } },
    HashTableValue { "isPointInPath"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsOffscreenCanvasRenderingContext2DPrototypeFunction_isPointInPath, 2 } },
    HashTableValue { "isPointInStroke"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsOffscreenCanvasRenderingContext2DPrototypeFunction_isPointInStroke, 2 } },
    HashTableValue { "createLinearGradient"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsOffscreenCanvasRenderingContext2DPrototypeFunction_createLinearGradient, 4 } },
    HashTableValue { "createRadialGradient"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsOffscreenCanvasRenderingContext2DPrototypeFunction_createRadialGradient, 6 } },
    HashTableValue { "createConicGradient"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsOffscreenCanvasRenderingContext2DPrototypeFunction_createConicGradient, 3 } },
    HashTableValue { "createPattern"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsOffscreenCanvasRenderingContext2DPrototypeFunction_createPattern, 2 } },
    HashTableValue { "createImageData"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsOffscreenCanvasRenderingContext2DPrototypeFunction_createImageData, 1 } },
    HashTableValue { "getImageData"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsOffscreenCanvasRenderingContext2DPrototypeFunction_getImageData, 4 } },
    HashTableValue { "putImageData"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsOffscreenCanvasRenderingContext2DPrototypeFunction_putImageData, 3 } },
    HashTableValue { "beginLayer"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsOffscreenCanvasRenderingContext2DPrototypeFunction_beginLayer, 0 } },
    HashTableValue { "endLayer"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsOffscreenCanvasRenderingContext2DPrototypeFunction_endLayer, 0 } },
    HashTableValue { "closePath"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsOffscreenCanvasRenderingContext2DPrototypeFunction_closePath, 0 } },
    HashTableValue { "moveTo"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsOffscreenCanvasRenderingContext2DPrototypeFunction_moveTo, 2 } },
    HashTableValue { "lineTo"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsOffscreenCanvasRenderingContext2DPrototypeFunction_lineTo, 2 } },
    HashTableValue { "quadraticCurveTo"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsOffscreenCanvasRenderingContext2DPrototypeFunction_quadraticCurveTo, 4 } },
    HashTableValue { "bezierCurveTo"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsOffscreenCanvasRenderingContext2DPrototypeFunction_bezierCurveTo, 6 } },
    HashTableValue { "arcTo"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsOffscreenCanvasRenderingContext2DPrototypeFunction_arcTo, 5 } },
    HashTableValue { "rect"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsOffscreenCanvasRenderingContext2DPrototypeFunction_rect, 4 } },
    HashTableValue { "roundRect"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsOffscreenCanvasRenderingContext2DPrototypeFunction_roundRect, 5 } },
    HashTableValue { "arc"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsOffscreenCanvasRenderingContext2DPrototypeFunction_arc, 5 } },
    HashTableValue { "ellipse"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsOffscreenCanvasRenderingContext2DPrototypeFunction_ellipse, 7 } },
    HashTableValue { "setLineDash"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsOffscreenCanvasRenderingContext2DPrototypeFunction_setLineDash, 1 } },
    HashTableValue { "getLineDash"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsOffscreenCanvasRenderingContext2DPrototypeFunction_getLineDash, 0 } },
    HashTableValue { "clearRect"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsOffscreenCanvasRenderingContext2DPrototypeFunction_clearRect, 4 } },
    HashTableValue { "fillRect"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsOffscreenCanvasRenderingContext2DPrototypeFunction_fillRect, 4 } },
    HashTableValue { "strokeRect"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsOffscreenCanvasRenderingContext2DPrototypeFunction_strokeRect, 4 } },
    HashTableValue { "save"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsOffscreenCanvasRenderingContext2DPrototypeFunction_save, 0 } },
    HashTableValue { "restore"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsOffscreenCanvasRenderingContext2DPrototypeFunction_restore, 0 } },
    HashTableValue { "reset"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsOffscreenCanvasRenderingContext2DPrototypeFunction_reset, 0 } },
    HashTableValue { "fillText"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsOffscreenCanvasRenderingContext2DPrototypeFunction_fillText, 3 } },
    HashTableValue { "strokeText"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsOffscreenCanvasRenderingContext2DPrototypeFunction_strokeText, 3 } },
    HashTableValue { "measureText"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsOffscreenCanvasRenderingContext2DPrototypeFunction_measureText, 1 } },
    HashTableValue { "scale"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsOffscreenCanvasRenderingContext2DPrototypeFunction_scale, 2 } },
    HashTableValue { "rotate"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsOffscreenCanvasRenderingContext2DPrototypeFunction_rotate, 1 } },
    HashTableValue { "translate"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsOffscreenCanvasRenderingContext2DPrototypeFunction_translate, 2 } },
    HashTableValue { "transform"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsOffscreenCanvasRenderingContext2DPrototypeFunction_transform, 6 } },
    HashTableValue { "getTransform"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsOffscreenCanvasRenderingContext2DPrototypeFunction_getTransform, 0 } },
    HashTableValue { "setTransform"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsOffscreenCanvasRenderingContext2DPrototypeFunction_setTransform, 0 } },
    HashTableValue { "resetTransform"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsOffscreenCanvasRenderingContext2DPrototypeFunction_resetTransform, 0 } },
};

const ClassInfo JSOffscreenCanvasRenderingContext2DPrototype::s_info = { "OffscreenCanvasRenderingContext2D"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSOffscreenCanvasRenderingContext2DPrototype) };

void JSOffscreenCanvasRenderingContext2DPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSOffscreenCanvasRenderingContext2D::info(), JSOffscreenCanvasRenderingContext2DPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().canvasLayersEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "beginLayer"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().canvasLayersEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "endLayer"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().canvasFiltersEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "filter"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSOffscreenCanvasRenderingContext2D::s_info = { "OffscreenCanvasRenderingContext2D"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSOffscreenCanvasRenderingContext2D) };

JSOffscreenCanvasRenderingContext2D::JSOffscreenCanvasRenderingContext2D(Structure* structure, JSDOMGlobalObject& globalObject, Ref<OffscreenCanvasRenderingContext2D>&& impl)
    : JSDOMWrapper<OffscreenCanvasRenderingContext2D, SignedPtrTraits<OffscreenCanvasRenderingContext2D, OffscreenCanvasRenderingContext2DPtrTag>>(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSOffscreenCanvasRenderingContext2D::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSOffscreenCanvasRenderingContext2DPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSOffscreenCanvasRenderingContext2DPrototype::create(vm, &globalObject, structure);
}

JSObject* JSOffscreenCanvasRenderingContext2D::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSOffscreenCanvasRenderingContext2D>(vm, globalObject);
}

JSValue JSOffscreenCanvasRenderingContext2D::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSOffscreenCanvasRenderingContext2DDOMConstructor, DOMConstructorID::OffscreenCanvasRenderingContext2D>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSOffscreenCanvasRenderingContext2D::destroy(JSC::JSCell* cell)
{
    JSOffscreenCanvasRenderingContext2D* thisObject = static_cast<JSOffscreenCanvasRenderingContext2D*>(cell);
    thisObject->JSOffscreenCanvasRenderingContext2D::~JSOffscreenCanvasRenderingContext2D();
}

JSC_DEFINE_CUSTOM_GETTER(jsOffscreenCanvasRenderingContext2DConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSOffscreenCanvasRenderingContext2DPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSOffscreenCanvasRenderingContext2D::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsOffscreenCanvasRenderingContext2D_canvasGetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<OffscreenCanvas>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.canvas())));
}

JSC_DEFINE_CUSTOM_GETTER(jsOffscreenCanvasRenderingContext2D_canvas, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::get<jsOffscreenCanvasRenderingContext2D_canvasGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsOffscreenCanvasRenderingContext2D_globalAlphaGetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "globalAlpha"_s);
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.globalAlpha())));
}

JSC_DEFINE_CUSTOM_GETTER(jsOffscreenCanvasRenderingContext2D_globalAlpha, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::get<jsOffscreenCanvasRenderingContext2D_globalAlphaGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSOffscreenCanvasRenderingContext2D_globalAlphaSetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "globalAlpha"_s, { InspectorCanvasCallTracer::processArgument(impl, nativeValueConversionResult.returnValue()) });
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setGlobalAlpha(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSOffscreenCanvasRenderingContext2D_globalAlpha, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::set<setJSOffscreenCanvasRenderingContext2D_globalAlphaSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsOffscreenCanvasRenderingContext2D_globalCompositeOperationGetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "globalCompositeOperation"_s);
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.globalCompositeOperation())));
}

JSC_DEFINE_CUSTOM_GETTER(jsOffscreenCanvasRenderingContext2D_globalCompositeOperation, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::get<jsOffscreenCanvasRenderingContext2D_globalCompositeOperationGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSOffscreenCanvasRenderingContext2D_globalCompositeOperationSetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLDOMString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "globalCompositeOperation"_s, { InspectorCanvasCallTracer::processArgument(impl, nativeValueConversionResult.returnValue()) });
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setGlobalCompositeOperation(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSOffscreenCanvasRenderingContext2D_globalCompositeOperation, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::set<setJSOffscreenCanvasRenderingContext2D_globalCompositeOperationSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsOffscreenCanvasRenderingContext2D_strokeStyleGetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "strokeStyle"_s);
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnion<IDLDOMString, IDLInterface<CanvasGradient>, IDLInterface<CanvasPattern>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.strokeStyle())));
}

JSC_DEFINE_CUSTOM_GETTER(jsOffscreenCanvasRenderingContext2D_strokeStyle, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::get<jsOffscreenCanvasRenderingContext2D_strokeStyleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSOffscreenCanvasRenderingContext2D_strokeStyleSetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnion<IDLDOMString, IDLInterface<CanvasGradient>, IDLInterface<CanvasPattern>>>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "strokeStyle"_s, { InspectorCanvasCallTracer::processArgument(impl, nativeValueConversionResult.returnValue()) });
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setStrokeStyle(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSOffscreenCanvasRenderingContext2D_strokeStyle, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::set<setJSOffscreenCanvasRenderingContext2D_strokeStyleSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsOffscreenCanvasRenderingContext2D_fillStyleGetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "fillStyle"_s);
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnion<IDLDOMString, IDLInterface<CanvasGradient>, IDLInterface<CanvasPattern>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.fillStyle())));
}

JSC_DEFINE_CUSTOM_GETTER(jsOffscreenCanvasRenderingContext2D_fillStyle, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::get<jsOffscreenCanvasRenderingContext2D_fillStyleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSOffscreenCanvasRenderingContext2D_fillStyleSetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnion<IDLDOMString, IDLInterface<CanvasGradient>, IDLInterface<CanvasPattern>>>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "fillStyle"_s, { InspectorCanvasCallTracer::processArgument(impl, nativeValueConversionResult.returnValue()) });
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setFillStyle(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSOffscreenCanvasRenderingContext2D_fillStyle, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::set<setJSOffscreenCanvasRenderingContext2D_fillStyleSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsOffscreenCanvasRenderingContext2D_filterGetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "filter"_s);
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.filterString())));
}

JSC_DEFINE_CUSTOM_GETTER(jsOffscreenCanvasRenderingContext2D_filter, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::get<jsOffscreenCanvasRenderingContext2D_filterGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSOffscreenCanvasRenderingContext2D_filterSetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLDOMString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "filter"_s, { InspectorCanvasCallTracer::processArgument(impl, nativeValueConversionResult.returnValue()) });
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setFilterString(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSOffscreenCanvasRenderingContext2D_filter, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::set<setJSOffscreenCanvasRenderingContext2D_filterSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsOffscreenCanvasRenderingContext2D_imageSmoothingEnabledGetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "imageSmoothingEnabled"_s);
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.imageSmoothingEnabled())));
}

JSC_DEFINE_CUSTOM_GETTER(jsOffscreenCanvasRenderingContext2D_imageSmoothingEnabled, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::get<jsOffscreenCanvasRenderingContext2D_imageSmoothingEnabledGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSOffscreenCanvasRenderingContext2D_imageSmoothingEnabledSetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLBoolean>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "imageSmoothingEnabled"_s, { InspectorCanvasCallTracer::processArgument(impl, nativeValueConversionResult.returnValue()) });
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setImageSmoothingEnabled(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSOffscreenCanvasRenderingContext2D_imageSmoothingEnabled, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::set<setJSOffscreenCanvasRenderingContext2D_imageSmoothingEnabledSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsOffscreenCanvasRenderingContext2D_imageSmoothingQualityGetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "imageSmoothingQuality"_s);
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<ImageSmoothingQuality>>(lexicalGlobalObject, throwScope, impl.imageSmoothingQuality())));
}

JSC_DEFINE_CUSTOM_GETTER(jsOffscreenCanvasRenderingContext2D_imageSmoothingQuality, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::get<jsOffscreenCanvasRenderingContext2D_imageSmoothingQualityGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSOffscreenCanvasRenderingContext2D_imageSmoothingQualitySetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto optionalNativeValue = parseEnumeration<ImageSmoothingQuality>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (!optionalNativeValue) [[unlikely]]
        return false;
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "imageSmoothingQuality"_s, { InspectorCanvasCallTracer::processArgument(impl, optionalNativeValue.value()) });
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setImageSmoothingQuality(optionalNativeValue.value());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSOffscreenCanvasRenderingContext2D_imageSmoothingQuality, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::set<setJSOffscreenCanvasRenderingContext2D_imageSmoothingQualitySetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsOffscreenCanvasRenderingContext2D_lineWidthGetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "lineWidth"_s);
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.lineWidth())));
}

JSC_DEFINE_CUSTOM_GETTER(jsOffscreenCanvasRenderingContext2D_lineWidth, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::get<jsOffscreenCanvasRenderingContext2D_lineWidthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSOffscreenCanvasRenderingContext2D_lineWidthSetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "lineWidth"_s, { InspectorCanvasCallTracer::processArgument(impl, nativeValueConversionResult.returnValue()) });
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setLineWidth(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSOffscreenCanvasRenderingContext2D_lineWidth, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::set<setJSOffscreenCanvasRenderingContext2D_lineWidthSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsOffscreenCanvasRenderingContext2D_lineCapGetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "lineCap"_s);
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<CanvasLineCap>>(lexicalGlobalObject, throwScope, impl.lineCap())));
}

JSC_DEFINE_CUSTOM_GETTER(jsOffscreenCanvasRenderingContext2D_lineCap, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::get<jsOffscreenCanvasRenderingContext2D_lineCapGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSOffscreenCanvasRenderingContext2D_lineCapSetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto optionalNativeValue = parseEnumeration<CanvasLineCap>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (!optionalNativeValue) [[unlikely]]
        return false;
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "lineCap"_s, { InspectorCanvasCallTracer::processArgument(impl, optionalNativeValue.value()) });
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setLineCap(optionalNativeValue.value());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSOffscreenCanvasRenderingContext2D_lineCap, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::set<setJSOffscreenCanvasRenderingContext2D_lineCapSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsOffscreenCanvasRenderingContext2D_lineJoinGetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "lineJoin"_s);
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<CanvasLineJoin>>(lexicalGlobalObject, throwScope, impl.lineJoin())));
}

JSC_DEFINE_CUSTOM_GETTER(jsOffscreenCanvasRenderingContext2D_lineJoin, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::get<jsOffscreenCanvasRenderingContext2D_lineJoinGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSOffscreenCanvasRenderingContext2D_lineJoinSetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto optionalNativeValue = parseEnumeration<CanvasLineJoin>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (!optionalNativeValue) [[unlikely]]
        return false;
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "lineJoin"_s, { InspectorCanvasCallTracer::processArgument(impl, optionalNativeValue.value()) });
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setLineJoin(optionalNativeValue.value());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSOffscreenCanvasRenderingContext2D_lineJoin, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::set<setJSOffscreenCanvasRenderingContext2D_lineJoinSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsOffscreenCanvasRenderingContext2D_miterLimitGetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "miterLimit"_s);
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.miterLimit())));
}

JSC_DEFINE_CUSTOM_GETTER(jsOffscreenCanvasRenderingContext2D_miterLimit, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::get<jsOffscreenCanvasRenderingContext2D_miterLimitGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSOffscreenCanvasRenderingContext2D_miterLimitSetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "miterLimit"_s, { InspectorCanvasCallTracer::processArgument(impl, nativeValueConversionResult.returnValue()) });
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setMiterLimit(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSOffscreenCanvasRenderingContext2D_miterLimit, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::set<setJSOffscreenCanvasRenderingContext2D_miterLimitSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsOffscreenCanvasRenderingContext2D_lineDashOffsetGetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "lineDashOffset"_s);
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.lineDashOffset())));
}

JSC_DEFINE_CUSTOM_GETTER(jsOffscreenCanvasRenderingContext2D_lineDashOffset, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::get<jsOffscreenCanvasRenderingContext2D_lineDashOffsetGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSOffscreenCanvasRenderingContext2D_lineDashOffsetSetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "lineDashOffset"_s, { InspectorCanvasCallTracer::processArgument(impl, nativeValueConversionResult.returnValue()) });
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setLineDashOffset(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSOffscreenCanvasRenderingContext2D_lineDashOffset, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::set<setJSOffscreenCanvasRenderingContext2D_lineDashOffsetSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsOffscreenCanvasRenderingContext2D_shadowOffsetXGetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "shadowOffsetX"_s);
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.shadowOffsetX())));
}

JSC_DEFINE_CUSTOM_GETTER(jsOffscreenCanvasRenderingContext2D_shadowOffsetX, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::get<jsOffscreenCanvasRenderingContext2D_shadowOffsetXGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSOffscreenCanvasRenderingContext2D_shadowOffsetXSetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "shadowOffsetX"_s, { InspectorCanvasCallTracer::processArgument(impl, nativeValueConversionResult.returnValue()) });
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setShadowOffsetX(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSOffscreenCanvasRenderingContext2D_shadowOffsetX, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::set<setJSOffscreenCanvasRenderingContext2D_shadowOffsetXSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsOffscreenCanvasRenderingContext2D_shadowOffsetYGetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "shadowOffsetY"_s);
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.shadowOffsetY())));
}

JSC_DEFINE_CUSTOM_GETTER(jsOffscreenCanvasRenderingContext2D_shadowOffsetY, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::get<jsOffscreenCanvasRenderingContext2D_shadowOffsetYGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSOffscreenCanvasRenderingContext2D_shadowOffsetYSetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "shadowOffsetY"_s, { InspectorCanvasCallTracer::processArgument(impl, nativeValueConversionResult.returnValue()) });
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setShadowOffsetY(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSOffscreenCanvasRenderingContext2D_shadowOffsetY, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::set<setJSOffscreenCanvasRenderingContext2D_shadowOffsetYSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsOffscreenCanvasRenderingContext2D_shadowBlurGetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "shadowBlur"_s);
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.shadowBlur())));
}

JSC_DEFINE_CUSTOM_GETTER(jsOffscreenCanvasRenderingContext2D_shadowBlur, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::get<jsOffscreenCanvasRenderingContext2D_shadowBlurGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSOffscreenCanvasRenderingContext2D_shadowBlurSetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "shadowBlur"_s, { InspectorCanvasCallTracer::processArgument(impl, nativeValueConversionResult.returnValue()) });
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setShadowBlur(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSOffscreenCanvasRenderingContext2D_shadowBlur, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::set<setJSOffscreenCanvasRenderingContext2D_shadowBlurSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsOffscreenCanvasRenderingContext2D_shadowColorGetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "shadowColor"_s);
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.shadowColor())));
}

JSC_DEFINE_CUSTOM_GETTER(jsOffscreenCanvasRenderingContext2D_shadowColor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::get<jsOffscreenCanvasRenderingContext2D_shadowColorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSOffscreenCanvasRenderingContext2D_shadowColorSetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLDOMString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "shadowColor"_s, { InspectorCanvasCallTracer::processArgument(impl, nativeValueConversionResult.returnValue()) });
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setShadowColor(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSOffscreenCanvasRenderingContext2D_shadowColor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::set<setJSOffscreenCanvasRenderingContext2D_shadowColorSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsOffscreenCanvasRenderingContext2D_fontGetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "font"_s);
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.font())));
}

JSC_DEFINE_CUSTOM_GETTER(jsOffscreenCanvasRenderingContext2D_font, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::get<jsOffscreenCanvasRenderingContext2D_fontGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSOffscreenCanvasRenderingContext2D_fontSetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLDOMString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "font"_s, { InspectorCanvasCallTracer::processArgument(impl, nativeValueConversionResult.returnValue()) });
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setFont(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSOffscreenCanvasRenderingContext2D_font, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::set<setJSOffscreenCanvasRenderingContext2D_fontSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsOffscreenCanvasRenderingContext2D_textAlignGetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "textAlign"_s);
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<CanvasTextAlign>>(lexicalGlobalObject, throwScope, impl.textAlign())));
}

JSC_DEFINE_CUSTOM_GETTER(jsOffscreenCanvasRenderingContext2D_textAlign, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::get<jsOffscreenCanvasRenderingContext2D_textAlignGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSOffscreenCanvasRenderingContext2D_textAlignSetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto optionalNativeValue = parseEnumeration<CanvasTextAlign>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (!optionalNativeValue) [[unlikely]]
        return false;
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "textAlign"_s, { InspectorCanvasCallTracer::processArgument(impl, optionalNativeValue.value()) });
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setTextAlign(optionalNativeValue.value());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSOffscreenCanvasRenderingContext2D_textAlign, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::set<setJSOffscreenCanvasRenderingContext2D_textAlignSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsOffscreenCanvasRenderingContext2D_textBaselineGetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "textBaseline"_s);
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<CanvasTextBaseline>>(lexicalGlobalObject, throwScope, impl.textBaseline())));
}

JSC_DEFINE_CUSTOM_GETTER(jsOffscreenCanvasRenderingContext2D_textBaseline, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::get<jsOffscreenCanvasRenderingContext2D_textBaselineGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSOffscreenCanvasRenderingContext2D_textBaselineSetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto optionalNativeValue = parseEnumeration<CanvasTextBaseline>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (!optionalNativeValue) [[unlikely]]
        return false;
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "textBaseline"_s, { InspectorCanvasCallTracer::processArgument(impl, optionalNativeValue.value()) });
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setTextBaseline(optionalNativeValue.value());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSOffscreenCanvasRenderingContext2D_textBaseline, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::set<setJSOffscreenCanvasRenderingContext2D_textBaselineSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsOffscreenCanvasRenderingContext2D_directionGetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "direction"_s);
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<CanvasDirection>>(lexicalGlobalObject, throwScope, impl.direction())));
}

JSC_DEFINE_CUSTOM_GETTER(jsOffscreenCanvasRenderingContext2D_direction, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::get<jsOffscreenCanvasRenderingContext2D_directionGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSOffscreenCanvasRenderingContext2D_directionSetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto optionalNativeValue = parseEnumeration<CanvasDirection>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (!optionalNativeValue) [[unlikely]]
        return false;
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "direction"_s, { InspectorCanvasCallTracer::processArgument(impl, optionalNativeValue.value()) });
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setDirection(optionalNativeValue.value());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSOffscreenCanvasRenderingContext2D_direction, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::set<setJSOffscreenCanvasRenderingContext2D_directionSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsOffscreenCanvasRenderingContext2D_letterSpacingGetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "letterSpacing"_s);
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.letterSpacing())));
}

JSC_DEFINE_CUSTOM_GETTER(jsOffscreenCanvasRenderingContext2D_letterSpacing, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::get<jsOffscreenCanvasRenderingContext2D_letterSpacingGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSOffscreenCanvasRenderingContext2D_letterSpacingSetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLDOMString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "letterSpacing"_s, { InspectorCanvasCallTracer::processArgument(impl, nativeValueConversionResult.returnValue()) });
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setLetterSpacing(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSOffscreenCanvasRenderingContext2D_letterSpacing, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::set<setJSOffscreenCanvasRenderingContext2D_letterSpacingSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsOffscreenCanvasRenderingContext2D_wordSpacingGetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "wordSpacing"_s);
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.wordSpacing())));
}

JSC_DEFINE_CUSTOM_GETTER(jsOffscreenCanvasRenderingContext2D_wordSpacing, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::get<jsOffscreenCanvasRenderingContext2D_wordSpacingGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSOffscreenCanvasRenderingContext2D_wordSpacingSetter(JSGlobalObject& lexicalGlobalObject, JSOffscreenCanvasRenderingContext2D& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLDOMString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "wordSpacing"_s, { InspectorCanvasCallTracer::processArgument(impl, nativeValueConversionResult.returnValue()) });
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setWordSpacing(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSOffscreenCanvasRenderingContext2D_wordSpacing, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSOffscreenCanvasRenderingContext2D>::set<setJSOffscreenCanvasRenderingContext2D_wordSpacingSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunction_drawImage1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto imageConversionResult = convert<IDLUnion<IDLInterface<HTMLImageElement>, IDLInterface<SVGImageElement>, IDLInterface<HTMLCanvasElement>, IDLInterface<ImageBitmap>, IDLInterface<CSSStyleImageValue>, IDLInterface<OffscreenCanvas>, IDLInterface<HTMLVideoElement>, IDLInterface<WebCodecsVideoFrame>>>(*lexicalGlobalObject, argument0.value());
    if (imageConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto dxConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument1.value());
    if (dxConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto dyConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument2.value());
    if (dyConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "drawImage"_s, { InspectorCanvasCallTracer::processArgument(impl, imageConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, dxConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, dyConversionResult.returnValue()) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.drawImage(imageConversionResult.releaseReturnValue(), dxConversionResult.releaseReturnValue(), dyConversionResult.releaseReturnValue()); })));
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunction_drawImage2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto imageConversionResult = convert<IDLUnion<IDLInterface<HTMLImageElement>, IDLInterface<SVGImageElement>, IDLInterface<HTMLCanvasElement>, IDLInterface<ImageBitmap>, IDLInterface<CSSStyleImageValue>, IDLInterface<OffscreenCanvas>, IDLInterface<HTMLVideoElement>, IDLInterface<WebCodecsVideoFrame>>>(*lexicalGlobalObject, argument0.value());
    if (imageConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto dxConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument1.value());
    if (dxConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto dyConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument2.value());
    if (dyConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto dwConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument3.value());
    if (dwConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument4 = callFrame->uncheckedArgument(4);
    auto dhConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument4.value());
    if (dhConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "drawImage"_s, { InspectorCanvasCallTracer::processArgument(impl, imageConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, dxConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, dyConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, dwConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, dhConversionResult.returnValue()) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.drawImage(imageConversionResult.releaseReturnValue(), dxConversionResult.releaseReturnValue(), dyConversionResult.releaseReturnValue(), dwConversionResult.releaseReturnValue(), dhConversionResult.releaseReturnValue()); })));
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunction_drawImage3Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto imageConversionResult = convert<IDLUnion<IDLInterface<HTMLImageElement>, IDLInterface<SVGImageElement>, IDLInterface<HTMLCanvasElement>, IDLInterface<ImageBitmap>, IDLInterface<CSSStyleImageValue>, IDLInterface<OffscreenCanvas>, IDLInterface<HTMLVideoElement>, IDLInterface<WebCodecsVideoFrame>>>(*lexicalGlobalObject, argument0.value());
    if (imageConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto sxConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument1.value());
    if (sxConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto syConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument2.value());
    if (syConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto swConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument3.value());
    if (swConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument4 = callFrame->uncheckedArgument(4);
    auto shConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument4.value());
    if (shConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument5 = callFrame->uncheckedArgument(5);
    auto dxConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument5.value());
    if (dxConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument6 = callFrame->uncheckedArgument(6);
    auto dyConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument6.value());
    if (dyConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument7 = callFrame->uncheckedArgument(7);
    auto dwConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument7.value());
    if (dwConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument8 = callFrame->uncheckedArgument(8);
    auto dhConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument8.value());
    if (dhConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "drawImage"_s, { InspectorCanvasCallTracer::processArgument(impl, imageConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, sxConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, syConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, swConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, shConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, dxConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, dyConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, dwConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, dhConversionResult.returnValue()) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.drawImage(imageConversionResult.releaseReturnValue(), sxConversionResult.releaseReturnValue(), syConversionResult.releaseReturnValue(), swConversionResult.releaseReturnValue(), shConversionResult.releaseReturnValue(), dxConversionResult.releaseReturnValue(), dyConversionResult.releaseReturnValue(), dwConversionResult.releaseReturnValue(), dhConversionResult.releaseReturnValue()); })));
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunction_drawImageOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    size_t argsCount = std::min<size_t>(9, callFrame->argumentCount());
    if (argsCount == 3) {
        RELEASE_AND_RETURN(throwScope, (jsOffscreenCanvasRenderingContext2DPrototypeFunction_drawImage1Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    if (argsCount == 5) {
        RELEASE_AND_RETURN(throwScope, (jsOffscreenCanvasRenderingContext2DPrototypeFunction_drawImage2Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    if (argsCount == 9) {
        RELEASE_AND_RETURN(throwScope, (jsOffscreenCanvasRenderingContext2DPrototypeFunction_drawImage3Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    return argsCount < 3 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

JSC_DEFINE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_drawImage, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunction_drawImageOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "drawImage");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunction_beginPathBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "beginPath"_s);
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.beginPath(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_beginPath, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunction_beginPathBody>(*lexicalGlobalObject, *callFrame, "beginPath");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunction_fill1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto fillRuleConversionResult = convertOptionalWithDefault<IDLEnumeration<CanvasFillRule>>(*lexicalGlobalObject, argument0.value(), [&]() -> ConversionResult<IDLEnumeration<CanvasFillRule>> { return Converter<IDLEnumeration<CanvasFillRule>>::ReturnType { CanvasFillRule::Nonzero }; }, [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 0, "fillRule"_s, "OffscreenCanvasRenderingContext2D"_s, "fill"_s, expectedEnumerationValues<CanvasFillRule>()); });
    if (fillRuleConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "fill"_s, { InspectorCanvasCallTracer::processArgument(impl, fillRuleConversionResult.returnValue()) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.fill(fillRuleConversionResult.releaseReturnValue()); })));
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunction_fill2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto pathConversionResult = convert<IDLInterface<Path2D>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "path"_s, "OffscreenCanvasRenderingContext2D"_s, "fill"_s, "Path2D"_s); });
    if (pathConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto fillRuleConversionResult = convertOptionalWithDefault<IDLEnumeration<CanvasFillRule>>(*lexicalGlobalObject, argument1.value(), [&]() -> ConversionResult<IDLEnumeration<CanvasFillRule>> { return Converter<IDLEnumeration<CanvasFillRule>>::ReturnType { CanvasFillRule::Nonzero }; }, [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 1, "fillRule"_s, "OffscreenCanvasRenderingContext2D"_s, "fill"_s, expectedEnumerationValues<CanvasFillRule>()); });
    if (fillRuleConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "fill"_s, { InspectorCanvasCallTracer::processArgument(impl, pathConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, fillRuleConversionResult.returnValue()) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.fill(*pathConversionResult.releaseReturnValue(), fillRuleConversionResult.releaseReturnValue()); })));
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunction_fillOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    size_t argsCount = std::min<size_t>(2, callFrame->argumentCount());
    if (argsCount == 0) {
        RELEASE_AND_RETURN(throwScope, (jsOffscreenCanvasRenderingContext2DPrototypeFunction_fill1Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    if (argsCount == 1) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isUndefined())
            RELEASE_AND_RETURN(throwScope, (jsOffscreenCanvasRenderingContext2DPrototypeFunction_fill1Body(lexicalGlobalObject, callFrame, castedThis)));
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSPath2D>())
            RELEASE_AND_RETURN(throwScope, (jsOffscreenCanvasRenderingContext2DPrototypeFunction_fill2Body(lexicalGlobalObject, callFrame, castedThis)));
        RELEASE_AND_RETURN(throwScope, (jsOffscreenCanvasRenderingContext2DPrototypeFunction_fill1Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    if (argsCount == 2) {
        RELEASE_AND_RETURN(throwScope, (jsOffscreenCanvasRenderingContext2DPrototypeFunction_fill2Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    return throwVMTypeError(lexicalGlobalObject, throwScope);
}

JSC_DEFINE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_fill, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunction_fillOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "fill");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunction_stroke1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "stroke"_s);
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.stroke(); })));
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunction_stroke2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto pathConversionResult = convert<IDLInterface<Path2D>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "path"_s, "OffscreenCanvasRenderingContext2D"_s, "stroke"_s, "Path2D"_s); });
    if (pathConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "stroke"_s, { InspectorCanvasCallTracer::processArgument(impl, pathConversionResult.returnValue()) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.stroke(*pathConversionResult.releaseReturnValue()); })));
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunction_strokeOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    size_t argsCount = std::min<size_t>(1, callFrame->argumentCount());
    if (argsCount == 0) {
        RELEASE_AND_RETURN(throwScope, (jsOffscreenCanvasRenderingContext2DPrototypeFunction_stroke1Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    if (argsCount == 1) {
        RELEASE_AND_RETURN(throwScope, (jsOffscreenCanvasRenderingContext2DPrototypeFunction_stroke2Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    return throwVMTypeError(lexicalGlobalObject, throwScope);
}

JSC_DEFINE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_stroke, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunction_strokeOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "stroke");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunction_clip1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto fillRuleConversionResult = convertOptionalWithDefault<IDLEnumeration<CanvasFillRule>>(*lexicalGlobalObject, argument0.value(), [&]() -> ConversionResult<IDLEnumeration<CanvasFillRule>> { return Converter<IDLEnumeration<CanvasFillRule>>::ReturnType { CanvasFillRule::Nonzero }; }, [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 0, "fillRule"_s, "OffscreenCanvasRenderingContext2D"_s, "clip"_s, expectedEnumerationValues<CanvasFillRule>()); });
    if (fillRuleConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "clip"_s, { InspectorCanvasCallTracer::processArgument(impl, fillRuleConversionResult.returnValue()) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.clip(fillRuleConversionResult.releaseReturnValue()); })));
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunction_clip2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto pathConversionResult = convert<IDLInterface<Path2D>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "path"_s, "OffscreenCanvasRenderingContext2D"_s, "clip"_s, "Path2D"_s); });
    if (pathConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto fillRuleConversionResult = convertOptionalWithDefault<IDLEnumeration<CanvasFillRule>>(*lexicalGlobalObject, argument1.value(), [&]() -> ConversionResult<IDLEnumeration<CanvasFillRule>> { return Converter<IDLEnumeration<CanvasFillRule>>::ReturnType { CanvasFillRule::Nonzero }; }, [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 1, "fillRule"_s, "OffscreenCanvasRenderingContext2D"_s, "clip"_s, expectedEnumerationValues<CanvasFillRule>()); });
    if (fillRuleConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "clip"_s, { InspectorCanvasCallTracer::processArgument(impl, pathConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, fillRuleConversionResult.returnValue()) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.clip(*pathConversionResult.releaseReturnValue(), fillRuleConversionResult.releaseReturnValue()); })));
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunction_clipOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    size_t argsCount = std::min<size_t>(2, callFrame->argumentCount());
    if (argsCount == 0) {
        RELEASE_AND_RETURN(throwScope, (jsOffscreenCanvasRenderingContext2DPrototypeFunction_clip1Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    if (argsCount == 1) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isUndefined())
            RELEASE_AND_RETURN(throwScope, (jsOffscreenCanvasRenderingContext2DPrototypeFunction_clip1Body(lexicalGlobalObject, callFrame, castedThis)));
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSPath2D>())
            RELEASE_AND_RETURN(throwScope, (jsOffscreenCanvasRenderingContext2DPrototypeFunction_clip2Body(lexicalGlobalObject, callFrame, castedThis)));
        RELEASE_AND_RETURN(throwScope, (jsOffscreenCanvasRenderingContext2DPrototypeFunction_clip1Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    if (argsCount == 2) {
        RELEASE_AND_RETURN(throwScope, (jsOffscreenCanvasRenderingContext2DPrototypeFunction_clip2Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    return throwVMTypeError(lexicalGlobalObject, throwScope);
}

JSC_DEFINE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_clip, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunction_clipOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "clip");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunction_isPointInPath1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto xConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument0.value());
    if (xConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto yConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument1.value());
    if (yConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto fillRuleConversionResult = convertOptionalWithDefault<IDLEnumeration<CanvasFillRule>>(*lexicalGlobalObject, argument2.value(), [&]() -> ConversionResult<IDLEnumeration<CanvasFillRule>> { return Converter<IDLEnumeration<CanvasFillRule>>::ReturnType { CanvasFillRule::Nonzero }; }, [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 2, "fillRule"_s, "OffscreenCanvasRenderingContext2D"_s, "isPointInPath"_s, expectedEnumerationValues<CanvasFillRule>()); });
    if (fillRuleConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "isPointInPath"_s, { InspectorCanvasCallTracer::processArgument(impl, xConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, yConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, fillRuleConversionResult.returnValue()) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.isPointInPath(xConversionResult.releaseReturnValue(), yConversionResult.releaseReturnValue(), fillRuleConversionResult.releaseReturnValue()))));
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunction_isPointInPath2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto pathConversionResult = convert<IDLInterface<Path2D>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "path"_s, "OffscreenCanvasRenderingContext2D"_s, "isPointInPath"_s, "Path2D"_s); });
    if (pathConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto xConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument1.value());
    if (xConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto yConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument2.value());
    if (yConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->argument(3);
    auto fillRuleConversionResult = convertOptionalWithDefault<IDLEnumeration<CanvasFillRule>>(*lexicalGlobalObject, argument3.value(), [&]() -> ConversionResult<IDLEnumeration<CanvasFillRule>> { return Converter<IDLEnumeration<CanvasFillRule>>::ReturnType { CanvasFillRule::Nonzero }; }, [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 3, "fillRule"_s, "OffscreenCanvasRenderingContext2D"_s, "isPointInPath"_s, expectedEnumerationValues<CanvasFillRule>()); });
    if (fillRuleConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "isPointInPath"_s, { InspectorCanvasCallTracer::processArgument(impl, pathConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, xConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, yConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, fillRuleConversionResult.returnValue()) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.isPointInPath(*pathConversionResult.releaseReturnValue(), xConversionResult.releaseReturnValue(), yConversionResult.releaseReturnValue(), fillRuleConversionResult.releaseReturnValue()))));
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunction_isPointInPathOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    size_t argsCount = std::min<size_t>(4, callFrame->argumentCount());
    if (argsCount == 2) {
        RELEASE_AND_RETURN(throwScope, (jsOffscreenCanvasRenderingContext2DPrototypeFunction_isPointInPath1Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    if (argsCount == 3) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSPath2D>())
            RELEASE_AND_RETURN(throwScope, (jsOffscreenCanvasRenderingContext2DPrototypeFunction_isPointInPath2Body(lexicalGlobalObject, callFrame, castedThis)));
        if (distinguishingArg.isNumber())
            RELEASE_AND_RETURN(throwScope, (jsOffscreenCanvasRenderingContext2DPrototypeFunction_isPointInPath1Body(lexicalGlobalObject, callFrame, castedThis)));
        RELEASE_AND_RETURN(throwScope, (jsOffscreenCanvasRenderingContext2DPrototypeFunction_isPointInPath1Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    if (argsCount == 4) {
        RELEASE_AND_RETURN(throwScope, (jsOffscreenCanvasRenderingContext2DPrototypeFunction_isPointInPath2Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    return argsCount < 2 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

JSC_DEFINE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_isPointInPath, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunction_isPointInPathOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "isPointInPath");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunction_isPointInStroke1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto xConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument0.value());
    if (xConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto yConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument1.value());
    if (yConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "isPointInStroke"_s, { InspectorCanvasCallTracer::processArgument(impl, xConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, yConversionResult.returnValue()) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.isPointInStroke(xConversionResult.releaseReturnValue(), yConversionResult.releaseReturnValue()))));
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunction_isPointInStroke2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto pathConversionResult = convert<IDLInterface<Path2D>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "path"_s, "OffscreenCanvasRenderingContext2D"_s, "isPointInStroke"_s, "Path2D"_s); });
    if (pathConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto xConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument1.value());
    if (xConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto yConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument2.value());
    if (yConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "isPointInStroke"_s, { InspectorCanvasCallTracer::processArgument(impl, pathConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, xConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, yConversionResult.returnValue()) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.isPointInStroke(*pathConversionResult.releaseReturnValue(), xConversionResult.releaseReturnValue(), yConversionResult.releaseReturnValue()))));
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunction_isPointInStrokeOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    size_t argsCount = std::min<size_t>(3, callFrame->argumentCount());
    if (argsCount == 2) {
        RELEASE_AND_RETURN(throwScope, (jsOffscreenCanvasRenderingContext2DPrototypeFunction_isPointInStroke1Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    if (argsCount == 3) {
        RELEASE_AND_RETURN(throwScope, (jsOffscreenCanvasRenderingContext2DPrototypeFunction_isPointInStroke2Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    return argsCount < 2 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

JSC_DEFINE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_isPointInStroke, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunction_isPointInStrokeOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "isPointInStroke");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunction_createLinearGradientBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 4) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto x0ConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (x0ConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto y0ConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument1.value());
    if (y0ConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto x1ConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument2.value());
    if (x1ConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto y1ConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument3.value());
    if (y1ConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "createLinearGradient"_s, { InspectorCanvasCallTracer::processArgument(impl, x0ConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, y0ConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, x1ConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, y1ConversionResult.returnValue()) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CanvasGradient>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createLinearGradient(x0ConversionResult.releaseReturnValue(), y0ConversionResult.releaseReturnValue(), x1ConversionResult.releaseReturnValue(), y1ConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_createLinearGradient, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunction_createLinearGradientBody>(*lexicalGlobalObject, *callFrame, "createLinearGradient");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunction_createRadialGradientBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 6) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto x0ConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (x0ConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto y0ConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument1.value());
    if (y0ConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto r0ConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument2.value());
    if (r0ConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto x1ConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument3.value());
    if (x1ConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument4 = callFrame->uncheckedArgument(4);
    auto y1ConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument4.value());
    if (y1ConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument5 = callFrame->uncheckedArgument(5);
    auto r1ConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument5.value());
    if (r1ConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "createRadialGradient"_s, { InspectorCanvasCallTracer::processArgument(impl, x0ConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, y0ConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, r0ConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, x1ConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, y1ConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, r1ConversionResult.returnValue()) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CanvasGradient>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createRadialGradient(x0ConversionResult.releaseReturnValue(), y0ConversionResult.releaseReturnValue(), r0ConversionResult.releaseReturnValue(), x1ConversionResult.releaseReturnValue(), y1ConversionResult.releaseReturnValue(), r1ConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_createRadialGradient, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunction_createRadialGradientBody>(*lexicalGlobalObject, *callFrame, "createRadialGradient");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunction_createConicGradientBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 3) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto angleConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (angleConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto xConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument1.value());
    if (xConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto yConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument2.value());
    if (yConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "createConicGradient"_s, { InspectorCanvasCallTracer::processArgument(impl, angleConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, xConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, yConversionResult.returnValue()) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<CanvasGradient>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createConicGradient(angleConversionResult.releaseReturnValue(), xConversionResult.releaseReturnValue(), yConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_createConicGradient, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunction_createConicGradientBody>(*lexicalGlobalObject, *callFrame, "createConicGradient");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunction_createPatternBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 2) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto imageConversionResult = convert<IDLUnion<IDLInterface<HTMLImageElement>, IDLInterface<SVGImageElement>, IDLInterface<HTMLCanvasElement>, IDLInterface<ImageBitmap>, IDLInterface<CSSStyleImageValue>, IDLInterface<OffscreenCanvas>, IDLInterface<HTMLVideoElement>, IDLInterface<WebCodecsVideoFrame>>>(*lexicalGlobalObject, argument0.value());
    if (imageConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto repetitionConversionResult = convert<IDLLegacyNullToEmptyStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, argument1.value());
    if (repetitionConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "createPattern"_s, { InspectorCanvasCallTracer::processArgument(impl, imageConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, repetitionConversionResult.returnValue()) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLNullable<IDLInterface<CanvasPattern>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createPattern(imageConversionResult.releaseReturnValue(), repetitionConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_createPattern, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunction_createPatternBody>(*lexicalGlobalObject, *callFrame, "createPattern");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunction_createImageData1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto swConversionResult = convert<IDLEnforceRangeAdaptor<IDLLong>>(*lexicalGlobalObject, argument0.value());
    if (swConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto shConversionResult = convert<IDLEnforceRangeAdaptor<IDLLong>>(*lexicalGlobalObject, argument1.value());
    if (shConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto settingsConversionResult = convert<IDLDictionary<ImageDataSettings>>(*lexicalGlobalObject, argument2.value());
    if (settingsConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "createImageData"_s, { InspectorCanvasCallTracer::processArgument(impl, swConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, shConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, settingsConversionResult.returnValue()) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<ImageData>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createImageData(swConversionResult.releaseReturnValue(), shConversionResult.releaseReturnValue(), settingsConversionResult.releaseReturnValue()))));
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunction_createImageData2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto imagedataConversionResult = convert<IDLInterface<ImageData>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "imagedata"_s, "OffscreenCanvasRenderingContext2D"_s, "createImageData"_s, "ImageData"_s); });
    if (imagedataConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "createImageData"_s, { InspectorCanvasCallTracer::processArgument(impl, imagedataConversionResult.returnValue()) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<ImageData>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.createImageData(*imagedataConversionResult.releaseReturnValue()))));
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunction_createImageDataOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    size_t argsCount = std::min<size_t>(3, callFrame->argumentCount());
    if (argsCount == 1) {
        RELEASE_AND_RETURN(throwScope, (jsOffscreenCanvasRenderingContext2DPrototypeFunction_createImageData2Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    if (argsCount == 2) {
        RELEASE_AND_RETURN(throwScope, (jsOffscreenCanvasRenderingContext2DPrototypeFunction_createImageData1Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    if (argsCount == 3) {
        RELEASE_AND_RETURN(throwScope, (jsOffscreenCanvasRenderingContext2DPrototypeFunction_createImageData1Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    return argsCount < 1 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

JSC_DEFINE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_createImageData, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunction_createImageDataOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "createImageData");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunction_getImageDataBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 4) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto sxConversionResult = convert<IDLEnforceRangeAdaptor<IDLLong>>(*lexicalGlobalObject, argument0.value());
    if (sxConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto syConversionResult = convert<IDLEnforceRangeAdaptor<IDLLong>>(*lexicalGlobalObject, argument1.value());
    if (syConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto swConversionResult = convert<IDLEnforceRangeAdaptor<IDLLong>>(*lexicalGlobalObject, argument2.value());
    if (swConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto shConversionResult = convert<IDLEnforceRangeAdaptor<IDLLong>>(*lexicalGlobalObject, argument3.value());
    if (shConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument4 = callFrame->argument(4);
    auto settingsConversionResult = convert<IDLDictionary<ImageDataSettings>>(*lexicalGlobalObject, argument4.value());
    if (settingsConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "getImageData"_s, { InspectorCanvasCallTracer::processArgument(impl, sxConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, syConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, swConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, shConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, settingsConversionResult.returnValue()) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<ImageData>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getImageData(sxConversionResult.releaseReturnValue(), syConversionResult.releaseReturnValue(), swConversionResult.releaseReturnValue(), shConversionResult.releaseReturnValue(), settingsConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_getImageData, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunction_getImageDataBody>(*lexicalGlobalObject, *callFrame, "getImageData");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunction_putImageData1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto imagedataConversionResult = convert<IDLInterface<ImageData>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "imagedata"_s, "OffscreenCanvasRenderingContext2D"_s, "putImageData"_s, "ImageData"_s); });
    if (imagedataConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto dxConversionResult = convert<IDLEnforceRangeAdaptor<IDLLong>>(*lexicalGlobalObject, argument1.value());
    if (dxConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto dyConversionResult = convert<IDLEnforceRangeAdaptor<IDLLong>>(*lexicalGlobalObject, argument2.value());
    if (dyConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "putImageData"_s, { InspectorCanvasCallTracer::processArgument(impl, imagedataConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, dxConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, dyConversionResult.returnValue()) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.putImageData(*imagedataConversionResult.releaseReturnValue(), dxConversionResult.releaseReturnValue(), dyConversionResult.releaseReturnValue()); })));
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunction_putImageData2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto imagedataConversionResult = convert<IDLInterface<ImageData>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "imagedata"_s, "OffscreenCanvasRenderingContext2D"_s, "putImageData"_s, "ImageData"_s); });
    if (imagedataConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto dxConversionResult = convert<IDLEnforceRangeAdaptor<IDLLong>>(*lexicalGlobalObject, argument1.value());
    if (dxConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto dyConversionResult = convert<IDLEnforceRangeAdaptor<IDLLong>>(*lexicalGlobalObject, argument2.value());
    if (dyConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto dirtyXConversionResult = convert<IDLEnforceRangeAdaptor<IDLLong>>(*lexicalGlobalObject, argument3.value());
    if (dirtyXConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument4 = callFrame->uncheckedArgument(4);
    auto dirtyYConversionResult = convert<IDLEnforceRangeAdaptor<IDLLong>>(*lexicalGlobalObject, argument4.value());
    if (dirtyYConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument5 = callFrame->uncheckedArgument(5);
    auto dirtyWidthConversionResult = convert<IDLEnforceRangeAdaptor<IDLLong>>(*lexicalGlobalObject, argument5.value());
    if (dirtyWidthConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument6 = callFrame->uncheckedArgument(6);
    auto dirtyHeightConversionResult = convert<IDLEnforceRangeAdaptor<IDLLong>>(*lexicalGlobalObject, argument6.value());
    if (dirtyHeightConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "putImageData"_s, { InspectorCanvasCallTracer::processArgument(impl, imagedataConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, dxConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, dyConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, dirtyXConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, dirtyYConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, dirtyWidthConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, dirtyHeightConversionResult.returnValue()) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.putImageData(*imagedataConversionResult.releaseReturnValue(), dxConversionResult.releaseReturnValue(), dyConversionResult.releaseReturnValue(), dirtyXConversionResult.releaseReturnValue(), dirtyYConversionResult.releaseReturnValue(), dirtyWidthConversionResult.releaseReturnValue(), dirtyHeightConversionResult.releaseReturnValue()); })));
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunction_putImageDataOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    size_t argsCount = std::min<size_t>(7, callFrame->argumentCount());
    if (argsCount == 3) {
        RELEASE_AND_RETURN(throwScope, (jsOffscreenCanvasRenderingContext2DPrototypeFunction_putImageData1Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    if (argsCount == 7) {
        RELEASE_AND_RETURN(throwScope, (jsOffscreenCanvasRenderingContext2DPrototypeFunction_putImageData2Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    return argsCount < 3 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

JSC_DEFINE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_putImageData, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunction_putImageDataOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "putImageData");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunction_beginLayerBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "beginLayer"_s);
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.beginLayer(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_beginLayer, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunction_beginLayerBody>(*lexicalGlobalObject, *callFrame, "beginLayer");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunction_endLayerBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "endLayer"_s);
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.endLayer(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_endLayer, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunction_endLayerBody>(*lexicalGlobalObject, *callFrame, "endLayer");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunction_closePathBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "closePath"_s);
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.closePath(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_closePath, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunction_closePathBody>(*lexicalGlobalObject, *callFrame, "closePath");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunction_moveToBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 2) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto xConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument0.value());
    if (xConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto yConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument1.value());
    if (yConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "moveTo"_s, { InspectorCanvasCallTracer::processArgument(impl, xConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, yConversionResult.returnValue()) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.moveTo(xConversionResult.releaseReturnValue(), yConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_moveTo, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunction_moveToBody>(*lexicalGlobalObject, *callFrame, "moveTo");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunction_lineToBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 2) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto xConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument0.value());
    if (xConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto yConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument1.value());
    if (yConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "lineTo"_s, { InspectorCanvasCallTracer::processArgument(impl, xConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, yConversionResult.returnValue()) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.lineTo(xConversionResult.releaseReturnValue(), yConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_lineTo, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunction_lineToBody>(*lexicalGlobalObject, *callFrame, "lineTo");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunction_quadraticCurveToBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 4) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto cpxConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument0.value());
    if (cpxConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto cpyConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument1.value());
    if (cpyConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto xConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument2.value());
    if (xConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto yConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument3.value());
    if (yConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "quadraticCurveTo"_s, { InspectorCanvasCallTracer::processArgument(impl, cpxConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, cpyConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, xConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, yConversionResult.returnValue()) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.quadraticCurveTo(cpxConversionResult.releaseReturnValue(), cpyConversionResult.releaseReturnValue(), xConversionResult.releaseReturnValue(), yConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_quadraticCurveTo, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunction_quadraticCurveToBody>(*lexicalGlobalObject, *callFrame, "quadraticCurveTo");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunction_bezierCurveToBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 6) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto cp1xConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument0.value());
    if (cp1xConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto cp1yConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument1.value());
    if (cp1yConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto cp2xConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument2.value());
    if (cp2xConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto cp2yConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument3.value());
    if (cp2yConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument4 = callFrame->uncheckedArgument(4);
    auto xConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument4.value());
    if (xConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument5 = callFrame->uncheckedArgument(5);
    auto yConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument5.value());
    if (yConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "bezierCurveTo"_s, { InspectorCanvasCallTracer::processArgument(impl, cp1xConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, cp1yConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, cp2xConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, cp2yConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, xConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, yConversionResult.returnValue()) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.bezierCurveTo(cp1xConversionResult.releaseReturnValue(), cp1yConversionResult.releaseReturnValue(), cp2xConversionResult.releaseReturnValue(), cp2yConversionResult.releaseReturnValue(), xConversionResult.releaseReturnValue(), yConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_bezierCurveTo, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunction_bezierCurveToBody>(*lexicalGlobalObject, *callFrame, "bezierCurveTo");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunction_arcToBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 5) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto x1ConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument0.value());
    if (x1ConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto y1ConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument1.value());
    if (y1ConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto x2ConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument2.value());
    if (x2ConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto y2ConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument3.value());
    if (y2ConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument4 = callFrame->uncheckedArgument(4);
    auto radiusConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument4.value());
    if (radiusConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "arcTo"_s, { InspectorCanvasCallTracer::processArgument(impl, x1ConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, y1ConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, x2ConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, y2ConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, radiusConversionResult.returnValue()) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.arcTo(x1ConversionResult.releaseReturnValue(), y1ConversionResult.releaseReturnValue(), x2ConversionResult.releaseReturnValue(), y2ConversionResult.releaseReturnValue(), radiusConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_arcTo, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunction_arcToBody>(*lexicalGlobalObject, *callFrame, "arcTo");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunction_rectBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 4) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto xConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument0.value());
    if (xConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto yConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument1.value());
    if (yConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto wConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument2.value());
    if (wConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto hConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument3.value());
    if (hConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "rect"_s, { InspectorCanvasCallTracer::processArgument(impl, xConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, yConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, wConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, hConversionResult.returnValue()) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.rect(xConversionResult.releaseReturnValue(), yConversionResult.releaseReturnValue(), wConversionResult.releaseReturnValue(), hConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_rect, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunction_rectBody>(*lexicalGlobalObject, *callFrame, "rect");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunction_roundRect1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto xConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument0.value());
    if (xConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto yConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument1.value());
    if (yConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto wConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument2.value());
    if (wConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto hConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument3.value());
    if (hConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument4 = callFrame->uncheckedArgument(4);
    auto radiiConversionResult = convert<IDLSequence<IDLUnion<IDLUnrestrictedDouble, IDLDictionary<DOMPointInit>>>>(*lexicalGlobalObject, argument4.value());
    if (radiiConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "roundRect"_s, { InspectorCanvasCallTracer::processArgument(impl, xConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, yConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, wConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, hConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, radiiConversionResult.returnValue()) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.roundRect(xConversionResult.releaseReturnValue(), yConversionResult.releaseReturnValue(), wConversionResult.releaseReturnValue(), hConversionResult.releaseReturnValue(), radiiConversionResult.releaseReturnValue()); })));
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunction_roundRect2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto xConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument0.value());
    if (xConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto yConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument1.value());
    if (yConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto wConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument2.value());
    if (wConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto hConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument3.value());
    if (hConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument4 = callFrame->uncheckedArgument(4);
    auto radiiConversionResult = convert<IDLUnion<IDLUnrestrictedDouble, IDLDictionary<DOMPointInit>>>(*lexicalGlobalObject, argument4.value());
    if (radiiConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "roundRect"_s, { InspectorCanvasCallTracer::processArgument(impl, xConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, yConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, wConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, hConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, radiiConversionResult.returnValue()) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.roundRect(xConversionResult.releaseReturnValue(), yConversionResult.releaseReturnValue(), wConversionResult.releaseReturnValue(), hConversionResult.releaseReturnValue(), radiiConversionResult.releaseReturnValue()); })));
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunction_roundRectOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    size_t argsCount = std::min<size_t>(5, callFrame->argumentCount());
    if (argsCount == 5) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(4);
        if (distinguishingArg.isUndefinedOrNull())
            RELEASE_AND_RETURN(throwScope, (jsOffscreenCanvasRenderingContext2DPrototypeFunction_roundRect2Body(lexicalGlobalObject, callFrame, castedThis)));
        {
            bool success = hasIteratorMethod(lexicalGlobalObject, distinguishingArg);
            RETURN_IF_EXCEPTION(throwScope, { });
            if (success)
                RELEASE_AND_RETURN(throwScope, (jsOffscreenCanvasRenderingContext2DPrototypeFunction_roundRect1Body(lexicalGlobalObject, callFrame, castedThis)));
        }
        if (distinguishingArg.isObject())
            RELEASE_AND_RETURN(throwScope, (jsOffscreenCanvasRenderingContext2DPrototypeFunction_roundRect2Body(lexicalGlobalObject, callFrame, castedThis)));
        if (distinguishingArg.isNumber())
            RELEASE_AND_RETURN(throwScope, (jsOffscreenCanvasRenderingContext2DPrototypeFunction_roundRect2Body(lexicalGlobalObject, callFrame, castedThis)));
        RELEASE_AND_RETURN(throwScope, (jsOffscreenCanvasRenderingContext2DPrototypeFunction_roundRect2Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    return argsCount < 5 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

JSC_DEFINE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_roundRect, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunction_roundRectOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "roundRect");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunction_arcBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 5) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto xConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument0.value());
    if (xConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto yConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument1.value());
    if (yConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto radiusConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument2.value());
    if (radiusConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto startAngleConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument3.value());
    if (startAngleConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument4 = callFrame->uncheckedArgument(4);
    auto endAngleConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument4.value());
    if (endAngleConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument5 = callFrame->argument(5);
    auto anticlockwiseConversionResult = convert<IDLBoolean>(*lexicalGlobalObject, argument5.value());
    if (anticlockwiseConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "arc"_s, { InspectorCanvasCallTracer::processArgument(impl, xConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, yConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, radiusConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, startAngleConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, endAngleConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, anticlockwiseConversionResult.returnValue()) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.arc(xConversionResult.releaseReturnValue(), yConversionResult.releaseReturnValue(), radiusConversionResult.releaseReturnValue(), startAngleConversionResult.releaseReturnValue(), endAngleConversionResult.releaseReturnValue(), anticlockwiseConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_arc, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunction_arcBody>(*lexicalGlobalObject, *callFrame, "arc");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunction_ellipseBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 7) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto xConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument0.value());
    if (xConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto yConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument1.value());
    if (yConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto radiusXConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument2.value());
    if (radiusXConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto radiusYConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument3.value());
    if (radiusYConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument4 = callFrame->uncheckedArgument(4);
    auto rotationConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument4.value());
    if (rotationConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument5 = callFrame->uncheckedArgument(5);
    auto startAngleConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument5.value());
    if (startAngleConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument6 = callFrame->uncheckedArgument(6);
    auto endAngleConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument6.value());
    if (endAngleConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument7 = callFrame->argument(7);
    auto anticlockwiseConversionResult = convert<IDLBoolean>(*lexicalGlobalObject, argument7.value());
    if (anticlockwiseConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "ellipse"_s, { InspectorCanvasCallTracer::processArgument(impl, xConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, yConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, radiusXConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, radiusYConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, rotationConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, startAngleConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, endAngleConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, anticlockwiseConversionResult.returnValue()) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.ellipse(xConversionResult.releaseReturnValue(), yConversionResult.releaseReturnValue(), radiusXConversionResult.releaseReturnValue(), radiusYConversionResult.releaseReturnValue(), rotationConversionResult.releaseReturnValue(), startAngleConversionResult.releaseReturnValue(), endAngleConversionResult.releaseReturnValue(), anticlockwiseConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_ellipse, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunction_ellipseBody>(*lexicalGlobalObject, *callFrame, "ellipse");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunction_setLineDashBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto segmentsConversionResult = convert<IDLSequence<IDLUnrestrictedDouble>>(*lexicalGlobalObject, argument0.value());
    if (segmentsConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "setLineDash"_s, { InspectorCanvasCallTracer::processArgument(impl, segmentsConversionResult.returnValue()) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.setLineDash(segmentsConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_setLineDash, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunction_setLineDashBody>(*lexicalGlobalObject, *callFrame, "setLineDash");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunction_getLineDashBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "getLineDash"_s);
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLSequence<IDLUnrestrictedDouble>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getLineDash())));
}

JSC_DEFINE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_getLineDash, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunction_getLineDashBody>(*lexicalGlobalObject, *callFrame, "getLineDash");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunction_clearRectBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 4) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto xConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument0.value());
    if (xConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto yConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument1.value());
    if (yConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto wConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument2.value());
    if (wConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto hConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument3.value());
    if (hConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "clearRect"_s, { InspectorCanvasCallTracer::processArgument(impl, xConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, yConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, wConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, hConversionResult.returnValue()) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.clearRect(xConversionResult.releaseReturnValue(), yConversionResult.releaseReturnValue(), wConversionResult.releaseReturnValue(), hConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_clearRect, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunction_clearRectBody>(*lexicalGlobalObject, *callFrame, "clearRect");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunction_fillRectBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 4) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto xConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument0.value());
    if (xConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto yConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument1.value());
    if (yConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto wConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument2.value());
    if (wConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto hConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument3.value());
    if (hConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "fillRect"_s, { InspectorCanvasCallTracer::processArgument(impl, xConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, yConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, wConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, hConversionResult.returnValue()) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.fillRect(xConversionResult.releaseReturnValue(), yConversionResult.releaseReturnValue(), wConversionResult.releaseReturnValue(), hConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_fillRect, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunction_fillRectBody>(*lexicalGlobalObject, *callFrame, "fillRect");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunction_strokeRectBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 4) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto xConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument0.value());
    if (xConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto yConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument1.value());
    if (yConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto wConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument2.value());
    if (wConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto hConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument3.value());
    if (hConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "strokeRect"_s, { InspectorCanvasCallTracer::processArgument(impl, xConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, yConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, wConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, hConversionResult.returnValue()) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.strokeRect(xConversionResult.releaseReturnValue(), yConversionResult.releaseReturnValue(), wConversionResult.releaseReturnValue(), hConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_strokeRect, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunction_strokeRectBody>(*lexicalGlobalObject, *callFrame, "strokeRect");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunction_saveBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "save"_s);
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.save(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_save, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunction_saveBody>(*lexicalGlobalObject, *callFrame, "save");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunction_restoreBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "restore"_s);
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.restore(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_restore, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunction_restoreBody>(*lexicalGlobalObject, *callFrame, "restore");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunction_resetBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "reset"_s);
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.reset(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_reset, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunction_resetBody>(*lexicalGlobalObject, *callFrame, "reset");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunction_fillTextBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 3) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto textConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    if (textConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto xConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument1.value());
    if (xConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto yConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument2.value());
    if (yConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->argument(3);
    auto maxWidthConversionResult = convert<IDLOptional<IDLUnrestrictedDouble>>(*lexicalGlobalObject, argument3.value());
    if (maxWidthConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "fillText"_s, { InspectorCanvasCallTracer::processArgument(impl, textConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, xConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, yConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, maxWidthConversionResult.returnValue()) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.fillText(textConversionResult.releaseReturnValue(), xConversionResult.releaseReturnValue(), yConversionResult.releaseReturnValue(), maxWidthConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_fillText, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunction_fillTextBody>(*lexicalGlobalObject, *callFrame, "fillText");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunction_strokeTextBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 3) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto textConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    if (textConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto xConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument1.value());
    if (xConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto yConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument2.value());
    if (yConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->argument(3);
    auto maxWidthConversionResult = convert<IDLOptional<IDLUnrestrictedDouble>>(*lexicalGlobalObject, argument3.value());
    if (maxWidthConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "strokeText"_s, { InspectorCanvasCallTracer::processArgument(impl, textConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, xConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, yConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, maxWidthConversionResult.returnValue()) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.strokeText(textConversionResult.releaseReturnValue(), xConversionResult.releaseReturnValue(), yConversionResult.releaseReturnValue(), maxWidthConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_strokeText, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunction_strokeTextBody>(*lexicalGlobalObject, *callFrame, "strokeText");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunction_measureTextBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto textConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    if (textConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "measureText"_s, { InspectorCanvasCallTracer::processArgument(impl, textConversionResult.returnValue()) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<TextMetrics>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.measureText(textConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_measureText, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunction_measureTextBody>(*lexicalGlobalObject, *callFrame, "measureText");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunction_scaleBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 2) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto xConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument0.value());
    if (xConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto yConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument1.value());
    if (yConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "scale"_s, { InspectorCanvasCallTracer::processArgument(impl, xConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, yConversionResult.returnValue()) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.scale(xConversionResult.releaseReturnValue(), yConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_scale, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunction_scaleBody>(*lexicalGlobalObject, *callFrame, "scale");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunction_rotateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto angleConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument0.value());
    if (angleConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "rotate"_s, { InspectorCanvasCallTracer::processArgument(impl, angleConversionResult.returnValue()) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.rotate(angleConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_rotate, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunction_rotateBody>(*lexicalGlobalObject, *callFrame, "rotate");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunction_translateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 2) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto xConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument0.value());
    if (xConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto yConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument1.value());
    if (yConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "translate"_s, { InspectorCanvasCallTracer::processArgument(impl, xConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, yConversionResult.returnValue()) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.translate(xConversionResult.releaseReturnValue(), yConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_translate, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunction_translateBody>(*lexicalGlobalObject, *callFrame, "translate");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunction_transformBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 6) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto aConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument0.value());
    if (aConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto bConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument1.value());
    if (bConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto cConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument2.value());
    if (cConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto dConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument3.value());
    if (dConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument4 = callFrame->uncheckedArgument(4);
    auto eConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument4.value());
    if (eConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument5 = callFrame->uncheckedArgument(5);
    auto fConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument5.value());
    if (fConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "transform"_s, { InspectorCanvasCallTracer::processArgument(impl, aConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, bConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, cConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, dConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, eConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, fConversionResult.returnValue()) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.transform(aConversionResult.releaseReturnValue(), bConversionResult.releaseReturnValue(), cConversionResult.releaseReturnValue(), dConversionResult.releaseReturnValue(), eConversionResult.releaseReturnValue(), fConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_transform, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunction_transformBody>(*lexicalGlobalObject, *callFrame, "transform");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunction_getTransformBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "getTransform"_s);
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<DOMMatrix>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getTransform())));
}

JSC_DEFINE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_getTransform, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunction_getTransformBody>(*lexicalGlobalObject, *callFrame, "getTransform");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunction_setTransform1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto aConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument0.value());
    if (aConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto bConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument1.value());
    if (bConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto cConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument2.value());
    if (cConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->uncheckedArgument(3);
    auto dConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument3.value());
    if (dConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument4 = callFrame->uncheckedArgument(4);
    auto eConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument4.value());
    if (eConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument5 = callFrame->uncheckedArgument(5);
    auto fConversionResult = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, argument5.value());
    if (fConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "setTransform"_s, { InspectorCanvasCallTracer::processArgument(impl, aConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, bConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, cConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, dConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, eConversionResult.returnValue()), InspectorCanvasCallTracer::processArgument(impl, fConversionResult.returnValue()) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.setTransform(aConversionResult.releaseReturnValue(), bConversionResult.releaseReturnValue(), cConversionResult.releaseReturnValue(), dConversionResult.releaseReturnValue(), eConversionResult.releaseReturnValue(), fConversionResult.releaseReturnValue()); })));
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunction_setTransform2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto transformConversionResult = convert<IDLDictionary<DOMMatrix2DInit>>(*lexicalGlobalObject, argument0.value());
    if (transformConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "setTransform"_s, { InspectorCanvasCallTracer::processArgument(impl, transformConversionResult.returnValue()) });
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.setTransform(transformConversionResult.releaseReturnValue()); })));
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunction_setTransformOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    size_t argsCount = std::min<size_t>(6, callFrame->argumentCount());
    if (argsCount == 0) {
        RELEASE_AND_RETURN(throwScope, (jsOffscreenCanvasRenderingContext2DPrototypeFunction_setTransform2Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    if (argsCount == 1) {
        RELEASE_AND_RETURN(throwScope, (jsOffscreenCanvasRenderingContext2DPrototypeFunction_setTransform2Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    if (argsCount == 6) {
        RELEASE_AND_RETURN(throwScope, (jsOffscreenCanvasRenderingContext2DPrototypeFunction_setTransform1Body(lexicalGlobalObject, callFrame, castedThis)));
    }
    return throwVMTypeError(lexicalGlobalObject, throwScope);
}

JSC_DEFINE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_setTransform, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunction_setTransformOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "setTransform");
}

static inline JSC::EncodedJSValue jsOffscreenCanvasRenderingContext2DPrototypeFunction_resetTransformBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSOffscreenCanvasRenderingContext2D>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (impl.hasActiveInspectorCanvasCallTracer()) [[unlikely]]
        InspectorCanvasCallTracer::recordAction(impl, "resetTransform"_s);
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.resetTransform(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsOffscreenCanvasRenderingContext2DPrototypeFunction_resetTransform, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSOffscreenCanvasRenderingContext2D>::call<jsOffscreenCanvasRenderingContext2DPrototypeFunction_resetTransformBody>(*lexicalGlobalObject, *callFrame, "resetTransform");
}

JSC::GCClient::IsoSubspace* JSOffscreenCanvasRenderingContext2D::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSOffscreenCanvasRenderingContext2D, UseCustomHeapCellType::No>(vm, "JSOffscreenCanvasRenderingContext2D"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForOffscreenCanvasRenderingContext2D.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForOffscreenCanvasRenderingContext2D = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForOffscreenCanvasRenderingContext2D.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForOffscreenCanvasRenderingContext2D = std::forward<decltype(space)>(space); }
    );
}

template<typename Visitor>
void JSOffscreenCanvasRenderingContext2D::visitChildrenImpl(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSOffscreenCanvasRenderingContext2D*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

DEFINE_VISIT_CHILDREN(JSOffscreenCanvasRenderingContext2D);

template<typename Visitor>
void JSOffscreenCanvasRenderingContext2D::visitOutputConstraints(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSOffscreenCanvasRenderingContext2D*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

template void JSOffscreenCanvasRenderingContext2D::visitOutputConstraints(JSCell*, AbstractSlotVisitor&);
template void JSOffscreenCanvasRenderingContext2D::visitOutputConstraints(JSCell*, SlotVisitor&);
void JSOffscreenCanvasRenderingContext2D::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSOffscreenCanvasRenderingContext2D*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

void JSOffscreenCanvasRenderingContext2DOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsOffscreenCanvasRenderingContext2D = static_cast<JSOffscreenCanvasRenderingContext2D*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsOffscreenCanvasRenderingContext2D->protectedWrapped().ptr(), jsOffscreenCanvasRenderingContext2D);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7OffscreenCanvasRenderingContext2D@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore33OffscreenCanvasRenderingContext2DE[]; }
#endif
template<std::same_as<OffscreenCanvasRenderingContext2D> T>
static inline void verifyVTable(OffscreenCanvasRenderingContext2D* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7OffscreenCanvasRenderingContext2D@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore33OffscreenCanvasRenderingContext2DE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // OffscreenCanvasRenderingContext2D has subclasses. If OffscreenCanvasRenderingContext2D has subclasses that get passed
        // to toJS() we currently require OffscreenCanvasRenderingContext2D you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<OffscreenCanvasRenderingContext2D>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<OffscreenCanvasRenderingContext2D>(impl.ptr());
#endif
    return createWrapper<OffscreenCanvasRenderingContext2D>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, OffscreenCanvasRenderingContext2D& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

OffscreenCanvasRenderingContext2D* JSOffscreenCanvasRenderingContext2D::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSOffscreenCanvasRenderingContext2D*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(OFFSCREEN_CANVAS)
