/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSEXTFragDepth.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

class JSEXTFragDepthPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSEXTFragDepthPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSEXTFragDepthPrototype* ptr = new (NotNull, JSC::allocateCell<JSEXTFragDepthPrototype>(vm)) JSEXTFragDepthPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSEXTFragDepthPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSEXTFragDepthPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSEXTFragDepthPrototype, JSEXTFragDepthPrototype::Base);

/* Hash table for prototype */
const ClassInfo JSEXTFragDepthPrototype::s_info = { "EXTFragDepth"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSEXTFragDepthPrototype) };

void JSEXTFragDepthPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSEXTFragDepth::s_info = { "EXTFragDepth"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSEXTFragDepth) };

JSEXTFragDepth::JSEXTFragDepth(Structure* structure, JSDOMGlobalObject& globalObject, Ref<EXTFragDepth>&& impl)
    : JSDOMWrapper<EXTFragDepth>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, EXTFragDepth>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSEXTFragDepth::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSEXTFragDepthPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSEXTFragDepthPrototype::create(vm, &globalObject, structure);
}

JSObject* JSEXTFragDepth::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSEXTFragDepth>(vm, globalObject);
}

void JSEXTFragDepth::destroy(JSC::JSCell* cell)
{
    JSEXTFragDepth* thisObject = static_cast<JSEXTFragDepth*>(cell);
    thisObject->JSEXTFragDepth::~JSEXTFragDepth();
}

JSC::GCClient::IsoSubspace* JSEXTFragDepth::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSEXTFragDepth, UseCustomHeapCellType::No>(vm, "JSEXTFragDepth"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForEXTFragDepth.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForEXTFragDepth = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForEXTFragDepth.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForEXTFragDepth = std::forward<decltype(space)>(space); }
    );
}

void JSEXTFragDepth::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSEXTFragDepth*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSEXTFragDepthOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    auto* jsEXTFragDepth = jsCast<JSEXTFragDepth*>(handle.slot()->asCell());
    auto& owner = jsEXTFragDepth->wrapped();
    if (reason) [[unlikely]]
        *reason = "Reachable from jsEXTFragDepth"_s;
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSEXTFragDepthOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsEXTFragDepth = static_cast<JSEXTFragDepth*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsEXTFragDepth->protectedWrapped().ptr(), jsEXTFragDepth);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7EXTFragDepth@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore12EXTFragDepthE[]; }
#endif
template<std::same_as<EXTFragDepth> T>
static inline void verifyVTable(EXTFragDepth* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7EXTFragDepth@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore12EXTFragDepthE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // EXTFragDepth has subclasses. If EXTFragDepth has subclasses that get passed
        // to toJS() we currently require EXTFragDepth you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<EXTFragDepth>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<EXTFragDepth>(impl.ptr());
#endif
    return createWrapper<EXTFragDepth>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, EXTFragDepth& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

EXTFragDepth* JSEXTFragDepth::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSEXTFragDepth*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
