/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSDynamicsCompressorOptions.h"

#include "JSChannelCountMode.h"
#include "JSChannelInterpretation.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include <JavaScriptCore/JSCInlines.h>



namespace WebCore {
using namespace JSC;

#if ENABLE(WEB_AUDIO)

template<> ConversionResult<IDLDictionary<DynamicsCompressorOptions>> convertDictionary<DynamicsCompressorOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    DynamicsCompressorOptions result;
    JSValue channelCountValue;
    if (isNullOrUndefined)
        channelCountValue = jsUndefined();
    else {
        channelCountValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "channelCount"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!channelCountValue.isUndefined()) {
        auto channelCountConversionResult = convert<IDLUnsignedLong>(lexicalGlobalObject, channelCountValue);
        if (channelCountConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.channelCount = channelCountConversionResult.releaseReturnValue();
    }
    JSValue channelCountModeValue;
    if (isNullOrUndefined)
        channelCountModeValue = jsUndefined();
    else {
        channelCountModeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "channelCountMode"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!channelCountModeValue.isUndefined()) {
        auto channelCountModeConversionResult = convert<IDLEnumeration<ChannelCountMode>>(lexicalGlobalObject, channelCountModeValue);
        if (channelCountModeConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.channelCountMode = channelCountModeConversionResult.releaseReturnValue();
    }
    JSValue channelInterpretationValue;
    if (isNullOrUndefined)
        channelInterpretationValue = jsUndefined();
    else {
        channelInterpretationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "channelInterpretation"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!channelInterpretationValue.isUndefined()) {
        auto channelInterpretationConversionResult = convert<IDLEnumeration<ChannelInterpretation>>(lexicalGlobalObject, channelInterpretationValue);
        if (channelInterpretationConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.channelInterpretation = channelInterpretationConversionResult.releaseReturnValue();
    }
    JSValue attackValue;
    if (isNullOrUndefined)
        attackValue = jsUndefined();
    else {
        attackValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "attack"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto attackConversionResult = convertOptionalWithDefault<IDLFloat>(lexicalGlobalObject, attackValue, [&]() -> ConversionResult<IDLFloat> { return Converter<IDLFloat>::ReturnType { 0.003 }; });
    if (attackConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.attack = attackConversionResult.releaseReturnValue();
    JSValue kneeValue;
    if (isNullOrUndefined)
        kneeValue = jsUndefined();
    else {
        kneeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "knee"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto kneeConversionResult = convertOptionalWithDefault<IDLFloat>(lexicalGlobalObject, kneeValue, [&]() -> ConversionResult<IDLFloat> { return Converter<IDLFloat>::ReturnType { 30 }; });
    if (kneeConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.knee = kneeConversionResult.releaseReturnValue();
    JSValue ratioValue;
    if (isNullOrUndefined)
        ratioValue = jsUndefined();
    else {
        ratioValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "ratio"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto ratioConversionResult = convertOptionalWithDefault<IDLFloat>(lexicalGlobalObject, ratioValue, [&]() -> ConversionResult<IDLFloat> { return Converter<IDLFloat>::ReturnType { 12 }; });
    if (ratioConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.ratio = ratioConversionResult.releaseReturnValue();
    JSValue releaseValue;
    if (isNullOrUndefined)
        releaseValue = jsUndefined();
    else {
        releaseValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "release"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto releaseConversionResult = convertOptionalWithDefault<IDLFloat>(lexicalGlobalObject, releaseValue, [&]() -> ConversionResult<IDLFloat> { return Converter<IDLFloat>::ReturnType { 0.25 }; });
    if (releaseConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.release = releaseConversionResult.releaseReturnValue();
    JSValue thresholdValue;
    if (isNullOrUndefined)
        thresholdValue = jsUndefined();
    else {
        thresholdValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "threshold"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto thresholdConversionResult = convertOptionalWithDefault<IDLFloat>(lexicalGlobalObject, thresholdValue, [&]() -> ConversionResult<IDLFloat> { return Converter<IDLFloat>::ReturnType { -24 }; });
    if (thresholdConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.threshold = thresholdConversionResult.releaseReturnValue();
    return result;
}

#endif

} // namespace WebCore


#endif // ENABLE(WEB_AUDIO)
