/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSColorGamut.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>



namespace WebCore {
using namespace JSC;

String convertEnumerationToString(ColorGamut enumerationValue)
{
    static const std::array<NeverDestroyed<String>, 3> values {
        MAKE_STATIC_STRING_IMPL("srgb"),
        MAKE_STATIC_STRING_IMPL("p3"),
        MAKE_STATIC_STRING_IMPL("rec2020"),
    };
    static_assert(static_cast<size_t>(ColorGamut::SRGB) == 0, "ColorGamut::SRGB is not 0 as expected");
    static_assert(static_cast<size_t>(ColorGamut::P3) == 1, "ColorGamut::P3 is not 1 as expected");
    static_assert(static_cast<size_t>(ColorGamut::Rec2020) == 2, "ColorGamut::Rec2020 is not 2 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, ColorGamut enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<ColorGamut> parseEnumerationFromString<ColorGamut>(const String& stringValue)
{
    static constexpr std::array<std::pair<ComparableASCIILiteral, ColorGamut>, 3> mappings {
        std::pair<ComparableASCIILiteral, ColorGamut> { "p3"_s, ColorGamut::P3 },
        std::pair<ComparableASCIILiteral, ColorGamut> { "rec2020"_s, ColorGamut::Rec2020 },
        std::pair<ComparableASCIILiteral, ColorGamut> { "srgb"_s, ColorGamut::SRGB },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); enumerationValue) [[likely]]
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<ColorGamut> parseEnumeration<ColorGamut>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<ColorGamut>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<ColorGamut>()
{
    return "\"srgb\", \"p3\", \"rec2020\""_s;
}

} // namespace WebCore

