// Copyright 2022-2025 The sacloud/iaas-api-go Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// generated by 'github.com/sacloud/iaas-api-go/internal/tools/gen-api-fake-op'; DO NOT EDIT

package fake

import (
	"sync"

	"github.com/sacloud/iaas-api-go"
)

var switchOnce sync.Once

// SwitchFactoryFuncToFake switches iaas.xxxAPI's factory methods to use fake client
func SwitchFactoryFuncToFake() {
	switchOnce.Do(func() {
		switchFactoryFuncToFake()
	})
}

func switchFactoryFuncToFake() {
	iaas.SetClientFactoryFunc(ResourceArchive, func(caller iaas.APICaller) interface{} {
		return NewArchiveOp()
	})
	iaas.SetClientFactoryFunc(ResourceAuthStatus, func(caller iaas.APICaller) interface{} {
		return NewAuthStatusOp()
	})
	iaas.SetClientFactoryFunc(ResourceAutoBackup, func(caller iaas.APICaller) interface{} {
		return NewAutoBackupOp()
	})
	iaas.SetClientFactoryFunc(ResourceAutoScale, func(caller iaas.APICaller) interface{} {
		return NewAutoScaleOp()
	})
	iaas.SetClientFactoryFunc(ResourceBill, func(caller iaas.APICaller) interface{} {
		return NewBillOp()
	})
	iaas.SetClientFactoryFunc(ResourceBridge, func(caller iaas.APICaller) interface{} {
		return NewBridgeOp()
	})
	iaas.SetClientFactoryFunc(ResourceCDROM, func(caller iaas.APICaller) interface{} {
		return NewCDROMOp()
	})
	iaas.SetClientFactoryFunc(ResourceCertificateAuthority, func(caller iaas.APICaller) interface{} {
		return NewCertificateAuthorityOp()
	})
	iaas.SetClientFactoryFunc(ResourceContainerRegistry, func(caller iaas.APICaller) interface{} {
		return NewContainerRegistryOp()
	})
	iaas.SetClientFactoryFunc(ResourceCoupon, func(caller iaas.APICaller) interface{} {
		return NewCouponOp()
	})
	iaas.SetClientFactoryFunc(ResourceDatabase, func(caller iaas.APICaller) interface{} {
		return NewDatabaseOp()
	})
	iaas.SetClientFactoryFunc(ResourceDisk, func(caller iaas.APICaller) interface{} {
		return NewDiskOp()
	})
	iaas.SetClientFactoryFunc(ResourceDiskPlan, func(caller iaas.APICaller) interface{} {
		return NewDiskPlanOp()
	})
	iaas.SetClientFactoryFunc(ResourceDNS, func(caller iaas.APICaller) interface{} {
		return NewDNSOp()
	})
	iaas.SetClientFactoryFunc(ResourceEnhancedDB, func(caller iaas.APICaller) interface{} {
		return NewEnhancedDBOp()
	})
	iaas.SetClientFactoryFunc(ResourceESME, func(caller iaas.APICaller) interface{} {
		return NewESMEOp()
	})
	iaas.SetClientFactoryFunc(ResourceGSLB, func(caller iaas.APICaller) interface{} {
		return NewGSLBOp()
	})
	iaas.SetClientFactoryFunc(ResourceIcon, func(caller iaas.APICaller) interface{} {
		return NewIconOp()
	})
	iaas.SetClientFactoryFunc(ResourceInterface, func(caller iaas.APICaller) interface{} {
		return NewInterfaceOp()
	})
	iaas.SetClientFactoryFunc(ResourceInternet, func(caller iaas.APICaller) interface{} {
		return NewInternetOp()
	})
	iaas.SetClientFactoryFunc(ResourceInternetPlan, func(caller iaas.APICaller) interface{} {
		return NewInternetPlanOp()
	})
	iaas.SetClientFactoryFunc(ResourceIPAddress, func(caller iaas.APICaller) interface{} {
		return NewIPAddressOp()
	})
	iaas.SetClientFactoryFunc(ResourceIPv6Net, func(caller iaas.APICaller) interface{} {
		return NewIPv6NetOp()
	})
	iaas.SetClientFactoryFunc(ResourceIPv6Addr, func(caller iaas.APICaller) interface{} {
		return NewIPv6AddrOp()
	})
	iaas.SetClientFactoryFunc(ResourceLicense, func(caller iaas.APICaller) interface{} {
		return NewLicenseOp()
	})
	iaas.SetClientFactoryFunc(ResourceLicenseInfo, func(caller iaas.APICaller) interface{} {
		return NewLicenseInfoOp()
	})
	iaas.SetClientFactoryFunc(ResourceLoadBalancer, func(caller iaas.APICaller) interface{} {
		return NewLoadBalancerOp()
	})
	iaas.SetClientFactoryFunc(ResourceLocalRouter, func(caller iaas.APICaller) interface{} {
		return NewLocalRouterOp()
	})
	iaas.SetClientFactoryFunc(ResourceMobileGateway, func(caller iaas.APICaller) interface{} {
		return NewMobileGatewayOp()
	})
	iaas.SetClientFactoryFunc(ResourceNFS, func(caller iaas.APICaller) interface{} {
		return NewNFSOp()
	})
	iaas.SetClientFactoryFunc(ResourceNote, func(caller iaas.APICaller) interface{} {
		return NewNoteOp()
	})
	iaas.SetClientFactoryFunc(ResourcePacketFilter, func(caller iaas.APICaller) interface{} {
		return NewPacketFilterOp()
	})
	iaas.SetClientFactoryFunc(ResourcePrivateHost, func(caller iaas.APICaller) interface{} {
		return NewPrivateHostOp()
	})
	iaas.SetClientFactoryFunc(ResourcePrivateHostPlan, func(caller iaas.APICaller) interface{} {
		return NewPrivateHostPlanOp()
	})
	iaas.SetClientFactoryFunc(ResourceProxyLB, func(caller iaas.APICaller) interface{} {
		return NewProxyLBOp()
	})
	iaas.SetClientFactoryFunc(ResourceRegion, func(caller iaas.APICaller) interface{} {
		return NewRegionOp()
	})
	iaas.SetClientFactoryFunc(ResourceServer, func(caller iaas.APICaller) interface{} {
		return NewServerOp()
	})
	iaas.SetClientFactoryFunc(ResourceServerPlan, func(caller iaas.APICaller) interface{} {
		return NewServerPlanOp()
	})
	iaas.SetClientFactoryFunc(ResourceServiceClass, func(caller iaas.APICaller) interface{} {
		return NewServiceClassOp()
	})
	iaas.SetClientFactoryFunc(ResourceSIM, func(caller iaas.APICaller) interface{} {
		return NewSIMOp()
	})
	iaas.SetClientFactoryFunc(ResourceSimpleMonitor, func(caller iaas.APICaller) interface{} {
		return NewSimpleMonitorOp()
	})
	iaas.SetClientFactoryFunc(ResourceSimpleNotificationDestination, func(caller iaas.APICaller) interface{} {
		return NewSimpleNotificationDestinationOp()
	})
	iaas.SetClientFactoryFunc(ResourceSimpleNotificationGroup, func(caller iaas.APICaller) interface{} {
		return NewSimpleNotificationGroupOp()
	})
	iaas.SetClientFactoryFunc(ResourceSSHKey, func(caller iaas.APICaller) interface{} {
		return NewSSHKeyOp()
	})
	iaas.SetClientFactoryFunc(ResourceSubnet, func(caller iaas.APICaller) interface{} {
		return NewSubnetOp()
	})
	iaas.SetClientFactoryFunc(ResourceSwitch, func(caller iaas.APICaller) interface{} {
		return NewSwitchOp()
	})
	iaas.SetClientFactoryFunc(ResourceVPCRouter, func(caller iaas.APICaller) interface{} {
		return NewVPCRouterOp()
	})
	iaas.SetClientFactoryFunc(ResourceZone, func(caller iaas.APICaller) interface{} {
		return NewZoneOp()
	})
}

/*************************************************
* ArchiveOp
*************************************************/

// ArchiveOp is fake implementation of ArchiveAPI interface
type ArchiveOp struct {
	key string
}

// NewArchiveOp creates new ArchiveOp instance
func NewArchiveOp() iaas.ArchiveAPI {
	return &ArchiveOp{
		key: ResourceArchive,
	}
}

/*************************************************
* AuthStatusOp
*************************************************/

// AuthStatusOp is fake implementation of AuthStatusAPI interface
type AuthStatusOp struct {
	key string
}

// NewAuthStatusOp creates new AuthStatusOp instance
func NewAuthStatusOp() iaas.AuthStatusAPI {
	return &AuthStatusOp{
		key: ResourceAuthStatus,
	}
}

/*************************************************
* AutoBackupOp
*************************************************/

// AutoBackupOp is fake implementation of AutoBackupAPI interface
type AutoBackupOp struct {
	key string
}

// NewAutoBackupOp creates new AutoBackupOp instance
func NewAutoBackupOp() iaas.AutoBackupAPI {
	return &AutoBackupOp{
		key: ResourceAutoBackup,
	}
}

/*************************************************
* AutoScaleOp
*************************************************/

// AutoScaleOp is fake implementation of AutoScaleAPI interface
type AutoScaleOp struct {
	key string
}

// NewAutoScaleOp creates new AutoScaleOp instance
func NewAutoScaleOp() iaas.AutoScaleAPI {
	return &AutoScaleOp{
		key: ResourceAutoScale,
	}
}

/*************************************************
* BillOp
*************************************************/

// BillOp is fake implementation of BillAPI interface
type BillOp struct {
	key string
}

// NewBillOp creates new BillOp instance
func NewBillOp() iaas.BillAPI {
	return &BillOp{
		key: ResourceBill,
	}
}

/*************************************************
* BridgeOp
*************************************************/

// BridgeOp is fake implementation of BridgeAPI interface
type BridgeOp struct {
	key string
}

// NewBridgeOp creates new BridgeOp instance
func NewBridgeOp() iaas.BridgeAPI {
	return &BridgeOp{
		key: ResourceBridge,
	}
}

/*************************************************
* CDROMOp
*************************************************/

// CDROMOp is fake implementation of CDROMAPI interface
type CDROMOp struct {
	key string
}

// NewCDROMOp creates new CDROMOp instance
func NewCDROMOp() iaas.CDROMAPI {
	return &CDROMOp{
		key: ResourceCDROM,
	}
}

/*************************************************
* CertificateAuthorityOp
*************************************************/

// CertificateAuthorityOp is fake implementation of CertificateAuthorityAPI interface
type CertificateAuthorityOp struct {
	key string
}

// NewCertificateAuthorityOp creates new CertificateAuthorityOp instance
func NewCertificateAuthorityOp() iaas.CertificateAuthorityAPI {
	return &CertificateAuthorityOp{
		key: ResourceCertificateAuthority,
	}
}

/*************************************************
* ContainerRegistryOp
*************************************************/

// ContainerRegistryOp is fake implementation of ContainerRegistryAPI interface
type ContainerRegistryOp struct {
	key string
}

// NewContainerRegistryOp creates new ContainerRegistryOp instance
func NewContainerRegistryOp() iaas.ContainerRegistryAPI {
	return &ContainerRegistryOp{
		key: ResourceContainerRegistry,
	}
}

/*************************************************
* CouponOp
*************************************************/

// CouponOp is fake implementation of CouponAPI interface
type CouponOp struct {
	key string
}

// NewCouponOp creates new CouponOp instance
func NewCouponOp() iaas.CouponAPI {
	return &CouponOp{
		key: ResourceCoupon,
	}
}

/*************************************************
* DatabaseOp
*************************************************/

// DatabaseOp is fake implementation of DatabaseAPI interface
type DatabaseOp struct {
	key string
}

// NewDatabaseOp creates new DatabaseOp instance
func NewDatabaseOp() iaas.DatabaseAPI {
	return &DatabaseOp{
		key: ResourceDatabase,
	}
}

/*************************************************
* DiskOp
*************************************************/

// DiskOp is fake implementation of DiskAPI interface
type DiskOp struct {
	key string
}

// NewDiskOp creates new DiskOp instance
func NewDiskOp() iaas.DiskAPI {
	return &DiskOp{
		key: ResourceDisk,
	}
}

/*************************************************
* DiskPlanOp
*************************************************/

// DiskPlanOp is fake implementation of DiskPlanAPI interface
type DiskPlanOp struct {
	key string
}

// NewDiskPlanOp creates new DiskPlanOp instance
func NewDiskPlanOp() iaas.DiskPlanAPI {
	return &DiskPlanOp{
		key: ResourceDiskPlan,
	}
}

/*************************************************
* DNSOp
*************************************************/

// DNSOp is fake implementation of DNSAPI interface
type DNSOp struct {
	key string
}

// NewDNSOp creates new DNSOp instance
func NewDNSOp() iaas.DNSAPI {
	return &DNSOp{
		key: ResourceDNS,
	}
}

/*************************************************
* EnhancedDBOp
*************************************************/

// EnhancedDBOp is fake implementation of EnhancedDBAPI interface
type EnhancedDBOp struct {
	key string
}

// NewEnhancedDBOp creates new EnhancedDBOp instance
func NewEnhancedDBOp() iaas.EnhancedDBAPI {
	return &EnhancedDBOp{
		key: ResourceEnhancedDB,
	}
}

/*************************************************
* ESMEOp
*************************************************/

// ESMEOp is fake implementation of ESMEAPI interface
type ESMEOp struct {
	key string
}

// NewESMEOp creates new ESMEOp instance
func NewESMEOp() iaas.ESMEAPI {
	return &ESMEOp{
		key: ResourceESME,
	}
}

/*************************************************
* GSLBOp
*************************************************/

// GSLBOp is fake implementation of GSLBAPI interface
type GSLBOp struct {
	key string
}

// NewGSLBOp creates new GSLBOp instance
func NewGSLBOp() iaas.GSLBAPI {
	return &GSLBOp{
		key: ResourceGSLB,
	}
}

/*************************************************
* IconOp
*************************************************/

// IconOp is fake implementation of IconAPI interface
type IconOp struct {
	key string
}

// NewIconOp creates new IconOp instance
func NewIconOp() iaas.IconAPI {
	return &IconOp{
		key: ResourceIcon,
	}
}

/*************************************************
* InterfaceOp
*************************************************/

// InterfaceOp is fake implementation of InterfaceAPI interface
type InterfaceOp struct {
	key string
}

// NewInterfaceOp creates new InterfaceOp instance
func NewInterfaceOp() iaas.InterfaceAPI {
	return &InterfaceOp{
		key: ResourceInterface,
	}
}

/*************************************************
* InternetOp
*************************************************/

// InternetOp is fake implementation of InternetAPI interface
type InternetOp struct {
	key string
}

// NewInternetOp creates new InternetOp instance
func NewInternetOp() iaas.InternetAPI {
	return &InternetOp{
		key: ResourceInternet,
	}
}

/*************************************************
* InternetPlanOp
*************************************************/

// InternetPlanOp is fake implementation of InternetPlanAPI interface
type InternetPlanOp struct {
	key string
}

// NewInternetPlanOp creates new InternetPlanOp instance
func NewInternetPlanOp() iaas.InternetPlanAPI {
	return &InternetPlanOp{
		key: ResourceInternetPlan,
	}
}

/*************************************************
* IPAddressOp
*************************************************/

// IPAddressOp is fake implementation of IPAddressAPI interface
type IPAddressOp struct {
	key string
}

// NewIPAddressOp creates new IPAddressOp instance
func NewIPAddressOp() iaas.IPAddressAPI {
	return &IPAddressOp{
		key: ResourceIPAddress,
	}
}

/*************************************************
* IPv6NetOp
*************************************************/

// IPv6NetOp is fake implementation of IPv6NetAPI interface
type IPv6NetOp struct {
	key string
}

// NewIPv6NetOp creates new IPv6NetOp instance
func NewIPv6NetOp() iaas.IPv6NetAPI {
	return &IPv6NetOp{
		key: ResourceIPv6Net,
	}
}

/*************************************************
* IPv6AddrOp
*************************************************/

// IPv6AddrOp is fake implementation of IPv6AddrAPI interface
type IPv6AddrOp struct {
	key string
}

// NewIPv6AddrOp creates new IPv6AddrOp instance
func NewIPv6AddrOp() iaas.IPv6AddrAPI {
	return &IPv6AddrOp{
		key: ResourceIPv6Addr,
	}
}

/*************************************************
* LicenseOp
*************************************************/

// LicenseOp is fake implementation of LicenseAPI interface
type LicenseOp struct {
	key string
}

// NewLicenseOp creates new LicenseOp instance
func NewLicenseOp() iaas.LicenseAPI {
	return &LicenseOp{
		key: ResourceLicense,
	}
}

/*************************************************
* LicenseInfoOp
*************************************************/

// LicenseInfoOp is fake implementation of LicenseInfoAPI interface
type LicenseInfoOp struct {
	key string
}

// NewLicenseInfoOp creates new LicenseInfoOp instance
func NewLicenseInfoOp() iaas.LicenseInfoAPI {
	return &LicenseInfoOp{
		key: ResourceLicenseInfo,
	}
}

/*************************************************
* LoadBalancerOp
*************************************************/

// LoadBalancerOp is fake implementation of LoadBalancerAPI interface
type LoadBalancerOp struct {
	key string
}

// NewLoadBalancerOp creates new LoadBalancerOp instance
func NewLoadBalancerOp() iaas.LoadBalancerAPI {
	return &LoadBalancerOp{
		key: ResourceLoadBalancer,
	}
}

/*************************************************
* LocalRouterOp
*************************************************/

// LocalRouterOp is fake implementation of LocalRouterAPI interface
type LocalRouterOp struct {
	key string
}

// NewLocalRouterOp creates new LocalRouterOp instance
func NewLocalRouterOp() iaas.LocalRouterAPI {
	return &LocalRouterOp{
		key: ResourceLocalRouter,
	}
}

/*************************************************
* MobileGatewayOp
*************************************************/

// MobileGatewayOp is fake implementation of MobileGatewayAPI interface
type MobileGatewayOp struct {
	key string
}

// NewMobileGatewayOp creates new MobileGatewayOp instance
func NewMobileGatewayOp() iaas.MobileGatewayAPI {
	return &MobileGatewayOp{
		key: ResourceMobileGateway,
	}
}

/*************************************************
* NFSOp
*************************************************/

// NFSOp is fake implementation of NFSAPI interface
type NFSOp struct {
	key string
}

// NewNFSOp creates new NFSOp instance
func NewNFSOp() iaas.NFSAPI {
	return &NFSOp{
		key: ResourceNFS,
	}
}

/*************************************************
* NoteOp
*************************************************/

// NoteOp is fake implementation of NoteAPI interface
type NoteOp struct {
	key string
}

// NewNoteOp creates new NoteOp instance
func NewNoteOp() iaas.NoteAPI {
	return &NoteOp{
		key: ResourceNote,
	}
}

/*************************************************
* PacketFilterOp
*************************************************/

// PacketFilterOp is fake implementation of PacketFilterAPI interface
type PacketFilterOp struct {
	key string
}

// NewPacketFilterOp creates new PacketFilterOp instance
func NewPacketFilterOp() iaas.PacketFilterAPI {
	return &PacketFilterOp{
		key: ResourcePacketFilter,
	}
}

/*************************************************
* PrivateHostOp
*************************************************/

// PrivateHostOp is fake implementation of PrivateHostAPI interface
type PrivateHostOp struct {
	key string
}

// NewPrivateHostOp creates new PrivateHostOp instance
func NewPrivateHostOp() iaas.PrivateHostAPI {
	return &PrivateHostOp{
		key: ResourcePrivateHost,
	}
}

/*************************************************
* PrivateHostPlanOp
*************************************************/

// PrivateHostPlanOp is fake implementation of PrivateHostPlanAPI interface
type PrivateHostPlanOp struct {
	key string
}

// NewPrivateHostPlanOp creates new PrivateHostPlanOp instance
func NewPrivateHostPlanOp() iaas.PrivateHostPlanAPI {
	return &PrivateHostPlanOp{
		key: ResourcePrivateHostPlan,
	}
}

/*************************************************
* ProxyLBOp
*************************************************/

// ProxyLBOp is fake implementation of ProxyLBAPI interface
type ProxyLBOp struct {
	key string
}

// NewProxyLBOp creates new ProxyLBOp instance
func NewProxyLBOp() iaas.ProxyLBAPI {
	return &ProxyLBOp{
		key: ResourceProxyLB,
	}
}

/*************************************************
* RegionOp
*************************************************/

// RegionOp is fake implementation of RegionAPI interface
type RegionOp struct {
	key string
}

// NewRegionOp creates new RegionOp instance
func NewRegionOp() iaas.RegionAPI {
	return &RegionOp{
		key: ResourceRegion,
	}
}

/*************************************************
* ServerOp
*************************************************/

// ServerOp is fake implementation of ServerAPI interface
type ServerOp struct {
	key string
}

// NewServerOp creates new ServerOp instance
func NewServerOp() iaas.ServerAPI {
	return &ServerOp{
		key: ResourceServer,
	}
}

/*************************************************
* ServerPlanOp
*************************************************/

// ServerPlanOp is fake implementation of ServerPlanAPI interface
type ServerPlanOp struct {
	key string
}

// NewServerPlanOp creates new ServerPlanOp instance
func NewServerPlanOp() iaas.ServerPlanAPI {
	return &ServerPlanOp{
		key: ResourceServerPlan,
	}
}

/*************************************************
* ServiceClassOp
*************************************************/

// ServiceClassOp is fake implementation of ServiceClassAPI interface
type ServiceClassOp struct {
	key string
}

// NewServiceClassOp creates new ServiceClassOp instance
func NewServiceClassOp() iaas.ServiceClassAPI {
	return &ServiceClassOp{
		key: ResourceServiceClass,
	}
}

/*************************************************
* SIMOp
*************************************************/

// SIMOp is fake implementation of SIMAPI interface
type SIMOp struct {
	key string
}

// NewSIMOp creates new SIMOp instance
func NewSIMOp() iaas.SIMAPI {
	return &SIMOp{
		key: ResourceSIM,
	}
}

/*************************************************
* SimpleMonitorOp
*************************************************/

// SimpleMonitorOp is fake implementation of SimpleMonitorAPI interface
type SimpleMonitorOp struct {
	key string
}

// NewSimpleMonitorOp creates new SimpleMonitorOp instance
func NewSimpleMonitorOp() iaas.SimpleMonitorAPI {
	return &SimpleMonitorOp{
		key: ResourceSimpleMonitor,
	}
}

/*************************************************
* SimpleNotificationDestinationOp
*************************************************/

// SimpleNotificationDestinationOp is fake implementation of SimpleNotificationDestinationAPI interface
type SimpleNotificationDestinationOp struct {
	key string
}

// NewSimpleNotificationDestinationOp creates new SimpleNotificationDestinationOp instance
func NewSimpleNotificationDestinationOp() iaas.SimpleNotificationDestinationAPI {
	return &SimpleNotificationDestinationOp{
		key: ResourceSimpleNotificationDestination,
	}
}

/*************************************************
* SimpleNotificationGroupOp
*************************************************/

// SimpleNotificationGroupOp is fake implementation of SimpleNotificationGroupAPI interface
type SimpleNotificationGroupOp struct {
	key string
}

// NewSimpleNotificationGroupOp creates new SimpleNotificationGroupOp instance
func NewSimpleNotificationGroupOp() iaas.SimpleNotificationGroupAPI {
	return &SimpleNotificationGroupOp{
		key: ResourceSimpleNotificationGroup,
	}
}

/*************************************************
* SSHKeyOp
*************************************************/

// SSHKeyOp is fake implementation of SSHKeyAPI interface
type SSHKeyOp struct {
	key string
}

// NewSSHKeyOp creates new SSHKeyOp instance
func NewSSHKeyOp() iaas.SSHKeyAPI {
	return &SSHKeyOp{
		key: ResourceSSHKey,
	}
}

/*************************************************
* SubnetOp
*************************************************/

// SubnetOp is fake implementation of SubnetAPI interface
type SubnetOp struct {
	key string
}

// NewSubnetOp creates new SubnetOp instance
func NewSubnetOp() iaas.SubnetAPI {
	return &SubnetOp{
		key: ResourceSubnet,
	}
}

/*************************************************
* SwitchOp
*************************************************/

// SwitchOp is fake implementation of SwitchAPI interface
type SwitchOp struct {
	key string
}

// NewSwitchOp creates new SwitchOp instance
func NewSwitchOp() iaas.SwitchAPI {
	return &SwitchOp{
		key: ResourceSwitch,
	}
}

/*************************************************
* VPCRouterOp
*************************************************/

// VPCRouterOp is fake implementation of VPCRouterAPI interface
type VPCRouterOp struct {
	key string
}

// NewVPCRouterOp creates new VPCRouterOp instance
func NewVPCRouterOp() iaas.VPCRouterAPI {
	return &VPCRouterOp{
		key: ResourceVPCRouter,
	}
}

/*************************************************
* ZoneOp
*************************************************/

// ZoneOp is fake implementation of ZoneAPI interface
type ZoneOp struct {
	key string
}

// NewZoneOp creates new ZoneOp instance
func NewZoneOp() iaas.ZoneAPI {
	return &ZoneOp{
		key: ResourceZone,
	}
}
