const char metrics_plugins_prometheus_lua[] =
"local metrics = require('metrics')\n"
"require('checks')\n"
"\n"
"local prometheus = {}\n"
"\n"
"local function escape(str)\n"
"    return str\n"
"        :gsub(\"\\\\\", \"\\\\\\\\\")\n"
"        :gsub(\"\\n\", \"\\\\n\")\n"
"        :gsub('\"', '\\\\\"')\n"
"end\n"
"\n"
"local function serialize_name(name)\n"
"    return escape(name)\n"
"end\n"
"\n"
"local function serialize_value(value)\n"
"    local result\n"
"    if type(value) == 'cdata' then\n"
"        result = tostring(value)\n"
"        -- Luajit cdata type inserts some postfix in the end of the number after tostring() operation\n"
"        result = result:gsub(\"U*LL\", \"\")\n"
"    elseif value == metrics.INF then\n"
"        result = '+Inf'\n"
"    elseif value == -metrics.INF then\n"
"        result = '-Inf'\n"
"    elseif value ~= value then\n"
"        result = 'Nan'\n"
"    else\n"
"        result = tostring(value)\n"
"    end\n"
"    return escape(result)\n"
"end\n"
"\n"
"local function serialize_label_pairs(label_pairs)\n"
"    if next(label_pairs) == nil then\n"
"        return ''\n"
"    end\n"
"\n"
"    local parts = {}\n"
"    for name, value in pairs(label_pairs) do\n"
"        local s = string.format('%s=\"%s\"',\n"
"            serialize_value(name), serialize_value(value))\n"
"        table.insert(parts, s)\n"
"    end\n"
"\n"
"    local enumerated_via_comma = table.concat(parts, ',')\n"
"    return string.format('{%s}', enumerated_via_comma)\n"
"end\n"
"\n"
"local function collect_and_serialize()\n"
"    metrics.invoke_callbacks()\n"
"    local parts = {}\n"
"    for _, c in pairs(metrics.collectors()) do\n"
"        table.insert(parts, string.format(\"# HELP %s %s\", c.name, c.help))\n"
"        table.insert(parts, string.format(\"# TYPE %s %s\", c.name, c.kind))\n"
"        for _, obs in ipairs(c:collect()) do\n"
"            local s = string.format('%s%s %s',\n"
"                serialize_name(obs.metric_name),\n"
"                serialize_label_pairs(obs.label_pairs),\n"
"                serialize_value(obs.value)\n"
"            )\n"
"            table.insert(parts, s)\n"
"        end\n"
"    end\n"
"    return table.concat(parts, '\\n') .. '\\n'\n"
"end\n"
"\n"
"function prometheus.collect_http()\n"
"    return {\n"
"        status = 200,\n"
"        headers = { ['content-type'] = 'text/plain; charset=utf8' },\n"
"        body = collect_and_serialize(),\n"
"    }\n"
"end\n"
"\n"
"return prometheus\n"
""
;
