const char table_lua[] =
"local function table_deepcopy_internal(orig, cyclic)\n"
"    cyclic = cyclic or {}\n"
"    local copy = orig\n"
"    if type(orig) == 'table' then\n"
"        local mt, copy_function = getmetatable(orig), nil\n"
"        if mt then copy_function = mt.__copy end\n"
"        if copy_function == nil then\n"
"            copy = {}\n"
"            if cyclic[orig] ~= nil then\n"
"                copy = cyclic[orig]\n"
"            else\n"
"                cyclic[orig] = copy\n"
"                for orig_key, orig_value in pairs(orig) do\n"
"                    local key = table_deepcopy_internal(orig_key, cyclic)\n"
"                    copy[key] = table_deepcopy_internal(orig_value, cyclic)\n"
"                end\n"
"                if mt ~= nil then setmetatable(copy, mt) end\n"
"            end\n"
"        else\n"
"            copy = copy_function(orig)\n"
"        end\n"
"    end\n"
"    return copy\n"
"end\n"
"\n"
"--- Deepcopy lua table (all levels)\n"
"-- Supports __copy metamethod for copying custom tables with metatables\n"
"-- @function deepcopy\n"
"-- @table         inp  original table\n"
"-- @shallow[opt]  sep  flag for shallow copy\n"
"-- @returns            table (copy)\n"
"local function table_deepcopy(orig)\n"
"    return table_deepcopy_internal(orig, nil)\n"
"end\n"
"\n"
"--- Copy any table (only top level)\n"
"-- Supports __copy metamethod for copying custom tables with metatables\n"
"-- @function copy\n"
"-- @table         inp  original table\n"
"-- @shallow[opt]  sep  flag for shallow copy\n"
"-- @returns            table (copy)\n"
"local function table_shallowcopy(orig)\n"
"    local copy = orig\n"
"    if type(orig) == 'table' then\n"
"        local mt, copy_function = getmetatable(orig), nil\n"
"        if mt then copy_function = mt.__copy end\n"
"        if copy_function == nil then\n"
"            copy = {}\n"
"            for orig_key, orig_value in pairs(orig) do\n"
"                copy[orig_key] = orig_value\n"
"            end\n"
"            if mt ~= nil then setmetatable(copy, mt) end\n"
"        else\n"
"            copy = copy_function(orig)\n"
"        end\n"
"    end\n"
"    return copy\n"
"end\n"
"\n"
"--- Compare two lua tables\n"
"-- Supports __eq metamethod for comparing custom tables with metatables\n"
"-- @function equals\n"
"-- @return true when the two tables are equal (false otherwise).\n"
"local function table_equals(a, b)\n"
"    if type(a) ~= 'table' or type(b) ~= 'table' then\n"
"        return type(a) == type(b) and a == b\n"
"    end\n"
"    local mta = getmetatable(a)\n"
"    local mtb = getmetatable(b)\n"
"    -- Let Lua decide what should happen when at least one of the tables has a\n"
"    -- metatable.\n"
"    if mta and mta.__eq or mtb and mtb.__eq then\n"
"        return a == b\n"
"    end\n"
"    for k, v in pairs(a) do\n"
"        if not table_equals(v, b[k]) then\n"
"            return false\n"
"        end\n"
"    end\n"
"    for k, _ in pairs(b) do\n"
"        if type(a[k]) == 'nil' then\n"
"            return false\n"
"        end\n"
"    end\n"
"    return true\n"
"end\n"
"\n"
"-- table library extension\n"
"local table = require('table')\n"
"-- require modifies global \"table\" module and adds functions \"clear\" and \"new\".\n"
"-- Lua applications like Cartridge rely on it.\n"
"require('table.clear')\n"
"require('table.new')\n"
"\n"
"table.copy     = table_shallowcopy\n"
"table.deepcopy = table_deepcopy\n"
"table.equals   = table_equals\n"
""
;
