/* Plug.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Plug.vala, do not modify */

/*
 * SPDX-License-Identifier: LGPL-3.0-or-later
 * SPDX-FileCopyrightText: 2015-2023 elementary, Inc. (https://elementary.io)
 *
 * Authored by: Corentin Noël <corentin@elementary.io>
 */

#include "io.elementary.settings.printers.h"
#include <gtk/gtk.h>
#include <switchboard.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <gee.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <adwaita.h>
#include <granite-7.h>
#include <gmodule.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PRINTERS_PLUG_0_PROPERTY,
	PRINTERS_PLUG_NUM_PROPERTIES
};
static GParamSpec* printers_plug_properties[PRINTERS_PLUG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_settings_schema_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_unref (var), NULL)))
typedef struct _PrintersPlugSearchData PrintersPlugSearchData;

struct _PrintersPlugPrivate {
	GtkPaned* main_paned;
	GtkStack* main_stack;
	PrintersPrinterList* list;
};

struct _PrintersPlugSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PrintersPlug* self;
	gchar* search;
	GeeTreeMap* result;
	GeeTreeMap* _tmp0_;
};

static gint PrintersPlug_private_offset;
static gpointer printers_plug_parent_class = NULL;

static GtkWidget* printers_plug_real_get_widget (SwitchboardPlug* base);
static void printers_plug_update_alert_visible (PrintersPlug* self);
static void ___lambda46_ (PrintersPlug* self);
static void ____lambda46__g_object_notify (GObject* _sender,
                                    GParamSpec* pspec,
                                    gpointer self);
static void printers_plug_real_shown (SwitchboardPlug* base);
static void printers_plug_real_hidden (SwitchboardPlug* base);
static void printers_plug_real_search_callback (SwitchboardPlug* base,
                                         const gchar* location);
static void printers_plug_real_search_data_free (gpointer _data);
static void printers_plug_real_search (SwitchboardPlug* base,
                                const gchar* search,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_);
static gboolean printers_plug_real_search_co (PrintersPlugSearchData* _data_);
static void printers_plug_finalize (GObject * obj);
static GType printers_plug_get_type_once (void);

static inline gpointer
printers_plug_get_instance_private (PrintersPlug* self)
{
	return G_STRUCT_MEMBER_P (self, PrintersPlug_private_offset);
}

PrintersPlug*
printers_plug_construct (GType object_type)
{
	PrintersPlug * self = NULL;
	GeeTreeMap* settings = NULL;
	GeeTreeMap* _tmp0_;
	bindtextdomain (BUILD_GETTEXT_PACKAGE, BUILD_LOCALEDIR);
	bind_textdomain_codeset (BUILD_GETTEXT_PACKAGE, "UTF-8");
	_tmp0_ = gee_tree_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	settings = _tmp0_;
	gee_abstract_map_set ((GeeAbstractMap*) settings, "printer", NULL);
	self = (PrintersPlug*) g_object_new (object_type, "category", SWITCHBOARD_PLUG_CATEGORY_HARDWARE, "code-name", "io.elementary.settings.printers", "display-name", _ ("Printers"), "description", _ ("Configure printers, manage print queues, and view ink levels"), "icon", "printer", "supported-settings", settings, NULL);
	_g_object_unref0 (settings);
	return self;
}

PrintersPlug*
printers_plug_new (void)
{
	return printers_plug_construct (PRINTERS_TYPE_PLUG);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
___lambda46_ (PrintersPlug* self)
{
	printers_plug_update_alert_visible (self);
}

static void
____lambda46__g_object_notify (GObject* _sender,
                               GParamSpec* pspec,
                               gpointer self)
{
	___lambda46_ ((PrintersPlug*) self);
}

static GtkWidget*
printers_plug_real_get_widget (SwitchboardPlug* base)
{
	PrintersPlug * self;
	GtkPaned* _tmp0_;
	GtkPaned* _tmp33_;
	GtkWidget* _tmp34_;
	GtkWidget* result;
	self = (PrintersPlug*) base;
	_tmp0_ = self->priv->main_paned;
	if (_tmp0_ == NULL) {
		GtkStack* stack = NULL;
		GtkStack* _tmp1_ = NULL;
		GtkStack* _tmp2_;
		PrintersPrinterList* _tmp3_;
		AdwHeaderBar* header_bar = NULL;
		AdwHeaderBar* _tmp4_ = NULL;
		AdwHeaderBar* _tmp5_;
		GranitePlaceholder* empty_alert = NULL;
		gchar* _tmp6_;
		GThemedIcon* _tmp7_;
		GranitePlaceholder* _tmp8_ = NULL;
		GtkBox* placeholder_box = NULL;
		GtkBox* _tmp9_;
		GtkBox* _tmp10_;
		AdwHeaderBar* _tmp11_;
		GtkBox* _tmp12_;
		GranitePlaceholder* _tmp13_;
		GtkStack* _tmp14_ = NULL;
		GtkStack* _tmp15_;
		GtkBox* _tmp16_;
		GtkStack* _tmp17_;
		GtkStack* _tmp18_;
		PrintersPrinterList* _tmp19_;
		GtkWidget* _tmp20_;
		GtkStack* _tmp21_;
		GtkWidget* _tmp22_;
		GtkPaned* _tmp23_ = NULL;
		GSettingsSchema* sss = NULL;
		GSettingsSchemaSource* _tmp24_;
		GSettingsSchema* _tmp25_;
		gboolean _tmp26_ = FALSE;
		GSettingsSchema* _tmp27_;
		PrintersPrinterList* _tmp32_;
		_tmp1_ = (GtkStack*) gtk_stack_new ();
		gtk_widget_set_visible ((GtkWidget*) _tmp1_, TRUE);
		g_object_ref_sink (_tmp1_);
		stack = _tmp1_;
		_tmp2_ = stack;
		_tmp3_ = printers_printer_list_new (_tmp2_);
		g_object_ref_sink (_tmp3_);
		_g_object_unref0 (self->priv->list);
		self->priv->list = _tmp3_;
		_tmp4_ = (AdwHeaderBar*) adw_header_bar_new ();
		adw_header_bar_set_show_title (_tmp4_, FALSE);
		adw_header_bar_set_show_start_title_buttons (_tmp4_, FALSE);
		adw_header_bar_set_show_back_button (_tmp4_, FALSE);
		g_object_ref_sink (_tmp4_);
		header_bar = _tmp4_;
		_tmp5_ = header_bar;
		gtk_widget_add_css_class ((GtkWidget*) _tmp5_, GRANITE_STYLE_CLASS_FLAT);
		_tmp6_ = g_strdup (_ ("Connect to a printer by clicking the icon in the toolbar below."));
		_tmp7_ = (GThemedIcon*) g_themed_icon_new ("printer-error");
		_tmp8_ = granite_placeholder_new (_ ("No Printers Available"));
		granite_placeholder_set_description (_tmp8_, _tmp6_);
		_g_free0 (_tmp6_);
		granite_placeholder_set_icon (_tmp8_, (GIcon*) _tmp7_);
		_g_object_unref0 (_tmp7_);
		gtk_widget_set_vexpand ((GtkWidget*) _tmp8_, TRUE);
		g_object_ref_sink (_tmp8_);
		empty_alert = _tmp8_;
		_tmp9_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
		g_object_ref_sink (_tmp9_);
		placeholder_box = _tmp9_;
		_tmp10_ = placeholder_box;
		_tmp11_ = header_bar;
		gtk_box_append (_tmp10_, (GtkWidget*) _tmp11_);
		_tmp12_ = placeholder_box;
		_tmp13_ = empty_alert;
		gtk_box_append (_tmp12_, (GtkWidget*) _tmp13_);
		_tmp14_ = (GtkStack*) gtk_stack_new ();
		gtk_stack_set_transition_type (_tmp14_, GTK_STACK_TRANSITION_TYPE_CROSSFADE);
		g_object_ref_sink (_tmp14_);
		_g_object_unref0 (self->priv->main_stack);
		self->priv->main_stack = _tmp14_;
		_tmp15_ = self->priv->main_stack;
		_tmp16_ = placeholder_box;
		gtk_stack_add_named (_tmp15_, (GtkWidget*) _tmp16_, "empty-alert");
		_tmp17_ = self->priv->main_stack;
		_tmp18_ = stack;
		gtk_stack_add_named (_tmp17_, (GtkWidget*) _tmp18_, "main-paned");
		_tmp19_ = self->priv->list;
		_tmp20_ = _g_object_ref0 ((GtkWidget*) _tmp19_);
		_tmp21_ = self->priv->main_stack;
		_tmp22_ = _g_object_ref0 ((GtkWidget*) _tmp21_);
		_tmp23_ = (GtkPaned*) gtk_paned_new (GTK_ORIENTATION_HORIZONTAL);
		gtk_paned_set_start_child (_tmp23_, _tmp20_);
		_g_object_unref0 (_tmp20_);
		gtk_paned_set_resize_start_child (_tmp23_, FALSE);
		gtk_paned_set_shrink_start_child (_tmp23_, FALSE);
		gtk_paned_set_end_child (_tmp23_, _tmp22_);
		_g_object_unref0 (_tmp22_);
		gtk_paned_set_resize_end_child (_tmp23_, TRUE);
		gtk_paned_set_shrink_end_child (_tmp23_, FALSE);
		g_object_ref_sink (_tmp23_);
		_g_object_unref0 (self->priv->main_paned);
		self->priv->main_paned = _tmp23_;
		_tmp24_ = g_settings_schema_source_get_default ();
		_tmp25_ = g_settings_schema_source_lookup (_tmp24_, "io.elementary.settings", TRUE);
		sss = _tmp25_;
		_tmp27_ = sss;
		if (_tmp27_ != NULL) {
			GSettingsSchema* _tmp28_;
			_tmp28_ = sss;
			_tmp26_ = g_settings_schema_has_key (_tmp28_, "sidebar-position");
		} else {
			_tmp26_ = FALSE;
		}
		if (_tmp26_) {
			GSettings* settings = NULL;
			GSettings* _tmp29_;
			GSettings* _tmp30_;
			GtkPaned* _tmp31_;
			_tmp29_ = g_settings_new ("io.elementary.settings");
			settings = _tmp29_;
			_tmp30_ = settings;
			_tmp31_ = self->priv->main_paned;
			g_settings_bind (_tmp30_, "sidebar-position", (GObject*) _tmp31_, "position", G_SETTINGS_BIND_DEFAULT);
			_g_object_unref0 (settings);
		}
		printers_plug_update_alert_visible (self);
		_tmp32_ = self->priv->list;
		g_signal_connect_object ((GObject*) _tmp32_, "notify::has-child", (GCallback) ____lambda46__g_object_notify, self, 0);
		_g_settings_schema_unref0 (sss);
		_g_object_unref0 (placeholder_box);
		_g_object_unref0 (empty_alert);
		_g_object_unref0 (header_bar);
		_g_object_unref0 (stack);
	}
	_tmp33_ = self->priv->main_paned;
	_tmp34_ = _g_object_ref0 ((GtkWidget*) _tmp33_);
	result = _tmp34_;
	return result;
}

static void
printers_plug_update_alert_visible (PrintersPlug* self)
{
	PrintersPrinterList* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->list;
	_tmp1_ = printers_printer_list_get_has_child (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GtkStack* _tmp3_;
		_tmp3_ = self->priv->main_stack;
		gtk_stack_set_visible_child_name (_tmp3_, "main-paned");
	} else {
		GtkStack* _tmp4_;
		_tmp4_ = self->priv->main_stack;
		gtk_stack_set_visible_child_name (_tmp4_, "empty-alert");
	}
}

static void
printers_plug_real_shown (SwitchboardPlug* base)
{
	PrintersPlug * self;
	self = (PrintersPlug*) base;
}

static void
printers_plug_real_hidden (SwitchboardPlug* base)
{
	PrintersPlug * self;
	self = (PrintersPlug*) base;
}

static void
printers_plug_real_search_callback (SwitchboardPlug* base,
                                    const gchar* location)
{
	PrintersPlug * self;
	self = (PrintersPlug*) base;
	g_return_if_fail (location != NULL);
}

static void
printers_plug_real_search_data_free (gpointer _data)
{
	PrintersPlugSearchData* _data_;
	_data_ = _data;
	_g_free0 (_data_->search);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (PrintersPlugSearchData, _data_);
}

static void
printers_plug_real_search (SwitchboardPlug* base,
                           const gchar* search,
                           GAsyncReadyCallback _callback_,
                           gpointer _user_data_)
{
	PrintersPlug * self;
	PrintersPlugSearchData* _data_;
	PrintersPlug* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (search != NULL);
	self = (PrintersPlug*) base;
	_data_ = g_slice_new0 (PrintersPlugSearchData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, printers_plug_real_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (search);
	_g_free0 (_data_->search);
	_data_->search = _tmp1_;
	printers_plug_real_search_co (_data_);
}

static GeeTreeMap*
printers_plug_search_finish (SwitchboardPlug* base,
                             GAsyncResult* _res_)
{
	GeeTreeMap* result;
	PrintersPlugSearchData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static gboolean
printers_plug_real_search_co (PrintersPlugSearchData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = gee_tree_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	_data_->result = _data_->_tmp0_;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
printers_plug_class_init (PrintersPlugClass * klass,
                          gpointer klass_data)
{
	printers_plug_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PrintersPlug_private_offset);
	((SwitchboardPlugClass *) klass)->get_widget = (GtkWidget* (*) (SwitchboardPlug*)) printers_plug_real_get_widget;
	((SwitchboardPlugClass *) klass)->shown = (void (*) (SwitchboardPlug*)) printers_plug_real_shown;
	((SwitchboardPlugClass *) klass)->hidden = (void (*) (SwitchboardPlug*)) printers_plug_real_hidden;
	((SwitchboardPlugClass *) klass)->search_callback = (void (*) (SwitchboardPlug*, const gchar*)) printers_plug_real_search_callback;
	((SwitchboardPlugClass *) klass)->search = (void (*) (SwitchboardPlug*, const gchar*, GAsyncReadyCallback, gpointer)) printers_plug_real_search;
	((SwitchboardPlugClass *) klass)->search_finish = (GeeTreeMap* (*) (SwitchboardPlug*, GAsyncResult*)) printers_plug_search_finish;
	G_OBJECT_CLASS (klass)->finalize = printers_plug_finalize;
}

static void
printers_plug_instance_init (PrintersPlug * self,
                             gpointer klass)
{
	self->priv = printers_plug_get_instance_private (self);
}

static void
printers_plug_finalize (GObject * obj)
{
	PrintersPlug * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PRINTERS_TYPE_PLUG, PrintersPlug);
	_g_object_unref0 (self->priv->main_paned);
	_g_object_unref0 (self->priv->main_stack);
	_g_object_unref0 (self->priv->list);
	G_OBJECT_CLASS (printers_plug_parent_class)->finalize (obj);
}

static GType
printers_plug_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PrintersPlugClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) printers_plug_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PrintersPlug), 0, (GInstanceInitFunc) printers_plug_instance_init, NULL };
	GType printers_plug_type_id;
	printers_plug_type_id = g_type_register_static (SWITCHBOARD_TYPE_PLUG, "PrintersPlug", &g_define_type_info, 0);
	PrintersPlug_private_offset = g_type_add_instance_private (printers_plug_type_id, sizeof (PrintersPlugPrivate));
	return printers_plug_type_id;
}

GType
printers_plug_get_type (void)
{
	static volatile gsize printers_plug_type_id__once = 0;
	if (g_once_init_enter (&printers_plug_type_id__once)) {
		GType printers_plug_type_id;
		printers_plug_type_id = printers_plug_get_type_once ();
		g_once_init_leave (&printers_plug_type_id__once, printers_plug_type_id);
	}
	return printers_plug_type_id__once;
}

SwitchboardPlug*
get_plug (GModule* module)
{
	PrintersPlug* plug = NULL;
	PrintersPlug* _tmp0_;
	SwitchboardPlug* result;
	g_return_val_if_fail (module != NULL, NULL);
	g_debug ("Plug.vala:113: Activating Printers plug");
	_tmp0_ = printers_plug_new ();
	plug = _tmp0_;
	result = (SwitchboardPlug*) plug;
	return result;
}

