/* Manager.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Manager.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*-
 * Copyright (c) 2016 elementary LLC.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Corentin Noël <corentin@elementary.io>
 */

#include "bluetooth.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <gee.h>
#include <gtk/gtk.h>

#define BLUETOOTH_SERVICES_OBJECT_MANAGER_DAEMON_SCHEMA "io.elementary.desktop.bluetooth"
#define BLUETOOTH_SERVICES_OBJECT_MANAGER_PANEL_SCHEMA "io.elementary.desktop.wingpanel.bluetooth"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

typedef GDBusProxy BluetoothServicesAgentManagerProxy;
typedef GDBusProxyClass BluetoothServicesAgentManagerProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	BLUETOOTH_SERVICES_OBJECT_MANAGER_0_PROPERTY,
	BLUETOOTH_SERVICES_OBJECT_MANAGER_DISCOVERABLE_PROPERTY,
	BLUETOOTH_SERVICES_OBJECT_MANAGER_HAS_OBJECT_PROPERTY,
	BLUETOOTH_SERVICES_OBJECT_MANAGER_RETRIEVE_FINISHED_PROPERTY,
	BLUETOOTH_SERVICES_OBJECT_MANAGER_IS_DISCOVERING_PROPERTY,
	BLUETOOTH_SERVICES_OBJECT_MANAGER_IS_POWERED_PROPERTY,
	BLUETOOTH_SERVICES_OBJECT_MANAGER_IS_CONNECTED_PROPERTY,
	BLUETOOTH_SERVICES_OBJECT_MANAGER_NUM_PROPERTIES
};
static GParamSpec* bluetooth_services_object_manager_properties[BLUETOOTH_SERVICES_OBJECT_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;
typedef struct _Block6Data Block6Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _BluetoothServicesObjectManagerCreateManagerData BluetoothServicesObjectManagerCreateManagerData;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _Block7Data Block7Data;
typedef struct _Block8Data Block8Data;
typedef struct _Block9Data Block9Data;
typedef struct _BluetoothServicesObjectManagerCreateAgentData BluetoothServicesObjectManagerCreateAgentData;
typedef struct _BluetoothServicesObjectManagerRegisterAgentData BluetoothServicesObjectManagerRegisterAgentData;
typedef struct _BluetoothServicesObjectManagerUnregisterAgentData BluetoothServicesObjectManagerUnregisterAgentData;
typedef struct _BluetoothServicesObjectManagerStartDiscoveryData BluetoothServicesObjectManagerStartDiscoveryData;
typedef struct _BluetoothServicesObjectManagerStopDiscoveryData BluetoothServicesObjectManagerStopDiscoveryData;
typedef struct _BluetoothServicesObjectManagerSetGlobalStateData BluetoothServicesObjectManagerSetGlobalStateData;
#define _g_settings_schema_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_unref (var), NULL)))
enum  {
	BLUETOOTH_SERVICES_OBJECT_MANAGER_ADAPTER_ADDED_SIGNAL,
	BLUETOOTH_SERVICES_OBJECT_MANAGER_ADAPTER_REMOVED_SIGNAL,
	BLUETOOTH_SERVICES_OBJECT_MANAGER_DEVICE_ADDED_SIGNAL,
	BLUETOOTH_SERVICES_OBJECT_MANAGER_DEVICE_REMOVED_SIGNAL,
	BLUETOOTH_SERVICES_OBJECT_MANAGER_NUM_SIGNALS
};
static guint bluetooth_services_object_manager_signals[BLUETOOTH_SERVICES_OBJECT_MANAGER_NUM_SIGNALS] = {0};

struct _BluetoothServicesObjectManagerPrivate {
	gboolean _discoverable;
	gboolean _has_object;
	gboolean _retrieve_finished;
	gboolean _is_discovering;
	gboolean _is_powered;
	gboolean _is_connected;
	gboolean is_registered;
	gchar* enabled_key;
	GSettings* settings;
	GDBusObjectManagerClient* object_manager;
	BluetoothServicesAgentManager* agent_manager;
	BluetoothServicesAgent* agent;
};

struct _Block4Data {
	int _ref_count_;
	BluetoothServicesObjectManager* self;
	GDBusObject* object;
};

struct _Block5Data {
	int _ref_count_;
	BluetoothServicesObjectManager* self;
	GDBusObject* object;
};

struct _Block6Data {
	int _ref_count_;
	BluetoothServicesObjectManager* self;
	GDBusObject* object;
};

struct _BluetoothServicesObjectManagerCreateManagerData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BluetoothServicesObjectManager* self;
	GDBusObjectManagerClient* _tmp0_;
	GDBusObjectManagerClient* _tmp1_;
	GDBusObjectManagerClient* _tmp2_;
	GDBusObjectManagerClient* _tmp3_;
	GDBusObjectManagerClient* _tmp4_;
	GList* _tmp5_;
	GList* _tmp6_;
	GDBusObjectManagerClient* _tmp7_;
	GDBusObjectManagerClient* _tmp8_;
	GDBusObjectManagerClient* _tmp9_;
	GDBusObjectManagerClient* _tmp10_;
	GError* e;
	GError* _tmp11_;
	const gchar* _tmp12_;
	GError* _inner_error0_;
};

struct _Block7Data {
	int _ref_count_;
	BluetoothServicesObjectManager* self;
	GeeLinkedList* adapters;
};

struct _Block8Data {
	int _ref_count_;
	BluetoothServicesObjectManager* self;
	GeeLinkedList* devices;
};

struct _Block9Data {
	int _ref_count_;
	BluetoothServicesObjectManager* self;
	GtkWindow* window;
	gpointer _async_data_;
};

struct _BluetoothServicesObjectManagerCreateAgentData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BluetoothServicesObjectManager* self;
	GtkWindow* window;
	Block9Data* _data9_;
	GDBusObjectManagerClient* _tmp0_;
	GDBusObject* bluez_object;
	GDBusObjectManagerClient* _tmp1_;
	GDBusObject* _tmp2_;
	GDBusObject* _tmp3_;
	GDBusObject* _tmp4_;
	GDBusInterface* _tmp5_;
	BluetoothServicesAgent* _tmp6_;
	BluetoothServicesAgent* _tmp7_;
	BluetoothServicesAgent* _tmp8_;
};

struct _BluetoothServicesObjectManagerRegisterAgentData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BluetoothServicesObjectManager* self;
	GtkWindow* window;
	BluetoothServicesAgentManager* _tmp0_;
	gboolean _tmp1_;
	BluetoothServicesAgentManager* _tmp2_;
	BluetoothServicesAgent* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	BluetoothServicesAgentManager* _tmp6_;
	BluetoothServicesAgent* _tmp7_;
	char* _tmp8_;
	char* _tmp9_;
	BluetoothServicesAgentManager* _tmp10_;
	BluetoothServicesAgent* _tmp11_;
	char* _tmp12_;
	char* _tmp13_;
	GError* e;
	GError* _tmp14_;
	const gchar* _tmp15_;
	GError* _inner_error0_;
};

struct _BluetoothServicesObjectManagerUnregisterAgentData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BluetoothServicesObjectManager* self;
	gboolean _tmp0_;
	BluetoothServicesAgentManager* _tmp1_;
	BluetoothServicesAgent* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	BluetoothServicesAgentManager* _tmp5_;
	BluetoothServicesAgent* _tmp6_;
	char* _tmp7_;
	char* _tmp8_;
	GError* e;
	GError* _tmp9_;
	const gchar* _tmp10_;
	GError* _inner_error0_;
};

struct _BluetoothServicesObjectManagerStartDiscoveryData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BluetoothServicesObjectManager* self;
	GeeLinkedList* adapters;
	GeeLinkedList* _tmp0_;
	GeeLinkedList* _adapter_list;
	GeeLinkedList* _tmp1_;
	gint _adapter_size;
	GeeLinkedList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _adapter_index;
	gint _tmp5_;
	gint _tmp6_;
	BluetoothServicesAdapter* adapter;
	GeeLinkedList* _tmp7_;
	gpointer _tmp8_;
	BluetoothServicesAdapter* _tmp9_;
	BluetoothServicesAdapter* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GError* e;
	GError* _tmp14_;
	const gchar* _tmp15_;
	GError* _inner_error0_;
};

struct _BluetoothServicesObjectManagerStopDiscoveryData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BluetoothServicesObjectManager* self;
	GeeLinkedList* adapters;
	GeeLinkedList* _tmp0_;
	GeeLinkedList* _adapter_list;
	GeeLinkedList* _tmp1_;
	gint _adapter_size;
	GeeLinkedList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _adapter_index;
	gint _tmp5_;
	gint _tmp6_;
	BluetoothServicesAdapter* adapter;
	GeeLinkedList* _tmp7_;
	gpointer _tmp8_;
	gboolean _tmp9_;
	BluetoothServicesAdapter* _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	BluetoothServicesAdapter* _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	BluetoothServicesAdapter* _tmp16_;
	BluetoothServicesAdapter* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	GError* e;
	GError* _tmp21_;
	const gchar* _tmp22_;
	GError* _inner_error0_;
};

struct _BluetoothServicesObjectManagerSetGlobalStateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BluetoothServicesObjectManager* self;
	gboolean state;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GeeLinkedList* adapters;
	GeeLinkedList* _tmp5_;
	GeeLinkedList* _adapter_list;
	GeeLinkedList* _tmp6_;
	gint _adapter_size;
	GeeLinkedList* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gint _adapter_index;
	gint _tmp10_;
	gint _tmp11_;
	BluetoothServicesAdapter* adapter;
	GeeLinkedList* _tmp12_;
	gpointer _tmp13_;
	BluetoothServicesAdapter* _tmp14_;
	BluetoothServicesAdapter* _tmp15_;
	GSettings* _tmp16_;
	GSettings* _tmp17_;
	const gchar* _tmp18_;
	GeeCollection* devices;
	GeeCollection* _tmp19_;
	GeeIterator* _device_it;
	GeeCollection* _tmp20_;
	GeeIterator* _tmp21_;
	GeeIterator* _tmp22_;
	BluetoothServicesDevice* device;
	GeeIterator* _tmp23_;
	gpointer _tmp24_;
	BluetoothServicesDevice* _tmp25_;
	gboolean _tmp26_;
	gboolean _tmp27_;
	BluetoothServicesDevice* _tmp28_;
	GError* e;
	GError* _tmp29_;
	const gchar* _tmp30_;
	GError* _inner_error0_;
};

static gint BluetoothServicesObjectManager_private_offset;
static gpointer bluetooth_services_object_manager_parent_class = NULL;
static GOnce bluetooth_services_object_manager_instance;
static GOnce bluetooth_services_object_manager_instance = G_ONCE_INIT;

static GType bluetooth_services_agent_manager_get_type_once (void);
static void bluetooth_services_agent_manager_proxy_g_signal (GDBusProxy* proxy,
                                                      const gchar* sender_name,
                                                      const gchar* signal_name,
                                                      GVariant* parameters);
static void bluetooth_services_agent_manager_proxy_register_agent (BluetoothServicesAgentManager* self,
                                                            const char* agent,
                                                            const gchar* capability,
                                                            GError** error);
static void bluetooth_services_agent_manager_proxy_request_default_agent (BluetoothServicesAgentManager* self,
                                                                   const char* agent,
                                                                   GError** error);
static void bluetooth_services_agent_manager_proxy_unregister_agent (BluetoothServicesAgentManager* self,
                                                              const char* agent,
                                                              GError** error);
static void bluetooth_services_agent_manager_proxy_bluetooth_services_agent_manager_interface_init (BluetoothServicesAgentManagerIface* iface);
static void _dbus_bluetooth_services_agent_manager_register_agent (BluetoothServicesAgentManager* self,
                                                            GVariant* _parameters_,
                                                            GDBusMethodInvocation* invocation);
static void _dbus_bluetooth_services_agent_manager_request_default_agent (BluetoothServicesAgentManager* self,
                                                                   GVariant* _parameters_,
                                                                   GDBusMethodInvocation* invocation);
static void _dbus_bluetooth_services_agent_manager_unregister_agent (BluetoothServicesAgentManager* self,
                                                              GVariant* _parameters_,
                                                              GDBusMethodInvocation* invocation);
static void bluetooth_services_agent_manager_dbus_interface_method_call (GDBusConnection* connection,
                                                                  const gchar* sender,
                                                                  const gchar* object_path,
                                                                  const gchar* interface_name,
                                                                  const gchar* method_name,
                                                                  GVariant* parameters,
                                                                  GDBusMethodInvocation* invocation,
                                                                  gpointer user_data);
static GVariant* bluetooth_services_agent_manager_dbus_interface_get_property (GDBusConnection* connection,
                                                                        const gchar* sender,
                                                                        const gchar* object_path,
                                                                        const gchar* interface_name,
                                                                        const gchar* property_name,
                                                                        GError** error,
                                                                        gpointer user_data);
static gboolean bluetooth_services_agent_manager_dbus_interface_set_property (GDBusConnection* connection,
                                                                       const gchar* sender,
                                                                       const gchar* object_path,
                                                                       const gchar* interface_name,
                                                                       const gchar* property_name,
                                                                       GVariant* value,
                                                                       GError** error,
                                                                       gpointer user_data);
static void _bluetooth_services_agent_manager_unregister_object (gpointer user_data);
static BluetoothServicesObjectManager* __lambda9_ (void);
static BluetoothServicesObjectManager* bluetooth_services_object_manager_new (void);
static BluetoothServicesObjectManager* bluetooth_services_object_manager_construct (GType object_type);
static gpointer ___lambda9__gthread_func (gpointer self);
static void bluetooth_services_object_manager_create_manager_data_free (gpointer _data);
static void bluetooth_services_object_manager_create_manager (BluetoothServicesObjectManager* self,
                                                       GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_);
static void bluetooth_services_object_manager_create_manager_finish (BluetoothServicesObjectManager* self,
                                                              GAsyncResult* _res_);
static gboolean bluetooth_services_object_manager_create_manager_co (BluetoothServicesObjectManagerCreateManagerData* _data_);
static GType bluetooth_services_object_manager_object_manager_proxy_get_type (BluetoothServicesObjectManager* self,
                                                                       GDBusObjectManagerClient* manager,
                                                                       const gchar* object_path,
                                                                       const gchar* interface_name);
static GType _bluetooth_services_object_manager_object_manager_proxy_get_type_gd_bus_proxy_type_func (GDBusObjectManagerClient* manager,
                                                                                               const gchar* object_path,
                                                                                               const gchar* interface_name,
                                                                                               gpointer self);
static void bluetooth_services_object_manager_create_manager_ready (GObject* source_object,
                                                             GAsyncResult* _res_,
                                                             gpointer _user_data_);
static void ___lambda10_ (BluetoothServicesObjectManager* self,
                   GDBusObject* object);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void __lambda11_ (Block4Data* _data4_,
                  GDBusInterface* iface);
static void bluetooth_services_object_manager_on_interface_added (BluetoothServicesObjectManager* self,
                                                           GDBusObject* object,
                                                           GDBusInterface* iface);
static void ___lambda11__gfunc (gconstpointer data,
                         gpointer self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void ____lambda10__gfunc (gconstpointer data,
                          gpointer self);
static void _bluetooth_services_object_manager_on_interface_added_g_dbus_object_manager_interface_added (GDBusObjectManager* _sender,
                                                                                                  GDBusObject* object,
                                                                                                  GDBusInterface* interface_,
                                                                                                  gpointer self);
static void bluetooth_services_object_manager_on_interface_removed (BluetoothServicesObjectManager* self,
                                                             GDBusObject* object,
                                                             GDBusInterface* iface);
static void _bluetooth_services_object_manager_on_interface_removed_g_dbus_object_manager_interface_removed (GDBusObjectManager* _sender,
                                                                                                      GDBusObject* object,
                                                                                                      GDBusInterface* interface_,
                                                                                                      gpointer self);
static void ___lambda17_ (BluetoothServicesObjectManager* self,
                   GDBusObject* object);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void __lambda18_ (Block5Data* _data5_,
                  GDBusInterface* iface);
static void ___lambda18__gfunc (gconstpointer data,
                         gpointer self);
static void ____lambda17__g_dbus_object_manager_object_added (GDBusObjectManager* _sender,
                                                       GDBusObject* object,
                                                       gpointer self);
static void ___lambda19_ (BluetoothServicesObjectManager* self,
                   GDBusObject* object);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void __lambda20_ (Block6Data* _data6_,
                  GDBusInterface* iface);
static void ___lambda20__gfunc (gconstpointer data,
                         gpointer self);
static void ____lambda19__g_dbus_object_manager_object_removed (GDBusObjectManager* _sender,
                                                         GDBusObject* object,
                                                         gpointer self);
static void bluetooth_services_object_manager_set_retrieve_finished (BluetoothServicesObjectManager* self,
                                                              gboolean value);
GType bluetooth_services_device_proxy_get_type (void);
GType bluetooth_services_adapter_proxy_get_type (void);
static void ___lambda12_ (BluetoothServicesObjectManager* self,
                   GVariant* changed,
                   gchar** invalid);
static void ____lambda12__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                      GVariant* changed_properties,
                                                      gchar** invalidated_properties,
                                                      gpointer self);
static void bluetooth_services_object_manager_set_has_object (BluetoothServicesObjectManager* self,
                                                       gboolean value);
static void ____lambda16_ (BluetoothServicesObjectManager* self,
                    GVariant* changed,
                    gchar** invalid);
static void _____lambda16__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                       GVariant* changed_properties,
                                                       gchar** invalidated_properties,
                                                       gpointer self);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void ___lambda14_ (Block7Data* _data7_,
                   GDBusObject* object);
static void ____lambda14__gfunc (gconstpointer data,
                          gpointer self);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static void ___lambda15_ (Block8Data* _data8_,
                   GDBusObject* object);
static void ____lambda15__gfunc (gconstpointer data,
                          gpointer self);
static void bluetooth_services_object_manager_create_agent_data_free (gpointer _data);
static void bluetooth_services_object_manager_create_agent (BluetoothServicesObjectManager* self,
                                                     GtkWindow* window,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_);
static void bluetooth_services_object_manager_create_agent_finish (BluetoothServicesObjectManager* self,
                                                            GAsyncResult* _res_);
static gboolean bluetooth_services_object_manager_create_agent_co (BluetoothServicesObjectManagerCreateAgentData* _data_);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static void __lambda21_ (Block9Data* _data9_);
static void ___lambda21__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda22_ (BluetoothServicesObjectManager* self);
static void ___lambda22__bluetooth_services_agent_unregistered (BluetoothServicesAgent* _sender,
                                                         gpointer self);
static void bluetooth_services_object_manager_register_agent_data_free (gpointer _data);
static gboolean bluetooth_services_object_manager_register_agent_co (BluetoothServicesObjectManagerRegisterAgentData* _data_);
static void bluetooth_services_object_manager_register_agent_ready (GObject* source_object,
                                                             GAsyncResult* _res_,
                                                             gpointer _user_data_);
static void bluetooth_services_object_manager_unregister_agent_data_free (gpointer _data);
static gboolean bluetooth_services_object_manager_unregister_agent_co (BluetoothServicesObjectManagerUnregisterAgentData* _data_);
static gboolean __lambda13_ (BluetoothServicesObjectManager* self);
static void bluetooth_services_object_manager_set_is_connected (BluetoothServicesObjectManager* self,
                                                         gboolean value);
static void bluetooth_services_object_manager_set_is_powered (BluetoothServicesObjectManager* self,
                                                       gboolean value);
static gboolean ___lambda13__gsource_func (gpointer self);
static void bluetooth_services_object_manager_start_discovery_data_free (gpointer _data);
static gboolean bluetooth_services_object_manager_start_discovery_co (BluetoothServicesObjectManagerStartDiscoveryData* _data_);
static void bluetooth_services_object_manager_set_is_discovering (BluetoothServicesObjectManager* self,
                                                           gboolean value);
static void bluetooth_services_object_manager_start_discovery_ready (GObject* source_object,
                                                              GAsyncResult* _res_,
                                                              gpointer _user_data_);
static void bluetooth_services_object_manager_stop_discovery_data_free (gpointer _data);
static gboolean bluetooth_services_object_manager_stop_discovery_co (BluetoothServicesObjectManagerStopDiscoveryData* _data_);
static void bluetooth_services_object_manager_stop_discovery_ready (GObject* source_object,
                                                             GAsyncResult* _res_,
                                                             gpointer _user_data_);
static void bluetooth_services_object_manager_set_global_state_data_free (gpointer _data);
static gboolean bluetooth_services_object_manager_set_global_state_co (BluetoothServicesObjectManagerSetGlobalStateData* _data_);
static void bluetooth_services_object_manager_set_global_state_ready (GObject* source_object,
                                                               GAsyncResult* _res_,
                                                               gpointer _user_data_);
static GObject * bluetooth_services_object_manager_constructor (GType type,
                                                         guint n_construct_properties,
                                                         GObjectConstructParam * construct_properties);
static void _bluetooth_services_object_manager___lambda23_ (BluetoothServicesObjectManager* self);
static gboolean __lambda24_ (BluetoothServicesObjectManager* self,
                      BluetoothServicesAdapter* adapter);
static gboolean ___lambda24__gee_forall_func (gpointer g,
                                       gpointer self);
static void __bluetooth_services_object_manager___lambda23__g_object_notify (GObject* _sender,
                                                                      GParamSpec* pspec,
                                                                      gpointer self);
static void bluetooth_services_object_manager_finalize (GObject * obj);
static GType bluetooth_services_object_manager_get_type_once (void);
static void _vala_bluetooth_services_object_manager_get_property (GObject * object,
                                                           guint property_id,
                                                           GValue * value,
                                                           GParamSpec * pspec);
static void _vala_bluetooth_services_object_manager_set_property (GObject * object,
                                                           guint property_id,
                                                           const GValue * value,
                                                           GParamSpec * pspec);

static const GDBusArgInfo _bluetooth_services_agent_manager_dbus_arg_info_register_agent_agent = {-1, "agent", "o", NULL};
static const GDBusArgInfo _bluetooth_services_agent_manager_dbus_arg_info_register_agent_capability = {-1, "capability", "s", NULL};
static const GDBusArgInfo * const _bluetooth_services_agent_manager_dbus_arg_info_register_agent_in[] = {&_bluetooth_services_agent_manager_dbus_arg_info_register_agent_agent, &_bluetooth_services_agent_manager_dbus_arg_info_register_agent_capability, NULL};
static const GDBusArgInfo * const _bluetooth_services_agent_manager_dbus_arg_info_register_agent_out[] = {NULL};
static const GDBusMethodInfo _bluetooth_services_agent_manager_dbus_method_info_register_agent = {-1, "RegisterAgent", (GDBusArgInfo **) (&_bluetooth_services_agent_manager_dbus_arg_info_register_agent_in), (GDBusArgInfo **) (&_bluetooth_services_agent_manager_dbus_arg_info_register_agent_out), NULL};
static const GDBusArgInfo _bluetooth_services_agent_manager_dbus_arg_info_request_default_agent_agent = {-1, "agent", "o", NULL};
static const GDBusArgInfo * const _bluetooth_services_agent_manager_dbus_arg_info_request_default_agent_in[] = {&_bluetooth_services_agent_manager_dbus_arg_info_request_default_agent_agent, NULL};
static const GDBusArgInfo * const _bluetooth_services_agent_manager_dbus_arg_info_request_default_agent_out[] = {NULL};
static const GDBusMethodInfo _bluetooth_services_agent_manager_dbus_method_info_request_default_agent = {-1, "RequestDefaultAgent", (GDBusArgInfo **) (&_bluetooth_services_agent_manager_dbus_arg_info_request_default_agent_in), (GDBusArgInfo **) (&_bluetooth_services_agent_manager_dbus_arg_info_request_default_agent_out), NULL};
static const GDBusArgInfo _bluetooth_services_agent_manager_dbus_arg_info_unregister_agent_agent = {-1, "agent", "o", NULL};
static const GDBusArgInfo * const _bluetooth_services_agent_manager_dbus_arg_info_unregister_agent_in[] = {&_bluetooth_services_agent_manager_dbus_arg_info_unregister_agent_agent, NULL};
static const GDBusArgInfo * const _bluetooth_services_agent_manager_dbus_arg_info_unregister_agent_out[] = {NULL};
static const GDBusMethodInfo _bluetooth_services_agent_manager_dbus_method_info_unregister_agent = {-1, "UnregisterAgent", (GDBusArgInfo **) (&_bluetooth_services_agent_manager_dbus_arg_info_unregister_agent_in), (GDBusArgInfo **) (&_bluetooth_services_agent_manager_dbus_arg_info_unregister_agent_out), NULL};
static const GDBusMethodInfo * const _bluetooth_services_agent_manager_dbus_method_info[] = {&_bluetooth_services_agent_manager_dbus_method_info_register_agent, &_bluetooth_services_agent_manager_dbus_method_info_request_default_agent, &_bluetooth_services_agent_manager_dbus_method_info_unregister_agent, NULL};
static const GDBusSignalInfo * const _bluetooth_services_agent_manager_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _bluetooth_services_agent_manager_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _bluetooth_services_agent_manager_dbus_interface_info = {-1, "org.bluez.AgentManager1", (GDBusMethodInfo **) (&_bluetooth_services_agent_manager_dbus_method_info), (GDBusSignalInfo **) (&_bluetooth_services_agent_manager_dbus_signal_info), (GDBusPropertyInfo **) (&_bluetooth_services_agent_manager_dbus_property_info), NULL};
static const GDBusInterfaceVTable _bluetooth_services_agent_manager_dbus_interface_vtable = {bluetooth_services_agent_manager_dbus_interface_method_call, bluetooth_services_agent_manager_dbus_interface_get_property, bluetooth_services_agent_manager_dbus_interface_set_property};

void
bluetooth_services_agent_manager_register_agent (BluetoothServicesAgentManager* self,
                                                 const char* agent,
                                                 const gchar* capability,
                                                 GError** error)
{
	BluetoothServicesAgentManagerIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = BLUETOOTH_SERVICES_AGENT_MANAGER_GET_INTERFACE (self);
	if (_iface_->register_agent) {
		_iface_->register_agent (self, agent, capability, error);
	}
}

void
bluetooth_services_agent_manager_request_default_agent (BluetoothServicesAgentManager* self,
                                                        const char* agent,
                                                        GError** error)
{
	BluetoothServicesAgentManagerIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = BLUETOOTH_SERVICES_AGENT_MANAGER_GET_INTERFACE (self);
	if (_iface_->request_default_agent) {
		_iface_->request_default_agent (self, agent, error);
	}
}

void
bluetooth_services_agent_manager_unregister_agent (BluetoothServicesAgentManager* self,
                                                   const char* agent,
                                                   GError** error)
{
	BluetoothServicesAgentManagerIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = BLUETOOTH_SERVICES_AGENT_MANAGER_GET_INTERFACE (self);
	if (_iface_->unregister_agent) {
		_iface_->unregister_agent (self, agent, error);
	}
}

static void
bluetooth_services_agent_manager_default_init (BluetoothServicesAgentManagerIface * iface,
                                               gpointer iface_data)
{
}

static GType
bluetooth_services_agent_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BluetoothServicesAgentManagerIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bluetooth_services_agent_manager_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType bluetooth_services_agent_manager_type_id;
	bluetooth_services_agent_manager_type_id = g_type_register_static (G_TYPE_INTERFACE, "BluetoothServicesAgentManager", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (bluetooth_services_agent_manager_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (bluetooth_services_agent_manager_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) bluetooth_services_agent_manager_proxy_get_type);
	g_type_set_qdata (bluetooth_services_agent_manager_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.bluez.AgentManager1");
	g_type_set_qdata (bluetooth_services_agent_manager_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_bluetooth_services_agent_manager_dbus_interface_info));
	g_type_set_qdata (bluetooth_services_agent_manager_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) bluetooth_services_agent_manager_register_object);
	return bluetooth_services_agent_manager_type_id;
}

GType
bluetooth_services_agent_manager_get_type (void)
{
	static volatile gsize bluetooth_services_agent_manager_type_id__once = 0;
	if (g_once_init_enter (&bluetooth_services_agent_manager_type_id__once)) {
		GType bluetooth_services_agent_manager_type_id;
		bluetooth_services_agent_manager_type_id = bluetooth_services_agent_manager_get_type_once ();
		g_once_init_leave (&bluetooth_services_agent_manager_type_id__once, bluetooth_services_agent_manager_type_id);
	}
	return bluetooth_services_agent_manager_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (BluetoothServicesAgentManagerProxy, bluetooth_services_agent_manager_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (BLUETOOTH_SERVICES_TYPE_AGENT_MANAGER, bluetooth_services_agent_manager_proxy_bluetooth_services_agent_manager_interface_init) )
static void
bluetooth_services_agent_manager_proxy_class_init (BluetoothServicesAgentManagerProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = bluetooth_services_agent_manager_proxy_g_signal;
}

static void
bluetooth_services_agent_manager_proxy_g_signal (GDBusProxy* proxy,
                                                 const gchar* sender_name,
                                                 const gchar* signal_name,
                                                 GVariant* parameters)
{
}

static void
bluetooth_services_agent_manager_proxy_init (BluetoothServicesAgentManagerProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_bluetooth_services_agent_manager_dbus_interface_info));
}

static void
bluetooth_services_agent_manager_proxy_register_agent (BluetoothServicesAgentManager* self,
                                                       const char* agent,
                                                       const gchar* capability,
                                                       GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.bluez.AgentManager1", "RegisterAgent");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_object_path (agent));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (capability));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
bluetooth_services_agent_manager_proxy_request_default_agent (BluetoothServicesAgentManager* self,
                                                              const char* agent,
                                                              GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.bluez.AgentManager1", "RequestDefaultAgent");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_object_path (agent));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
bluetooth_services_agent_manager_proxy_unregister_agent (BluetoothServicesAgentManager* self,
                                                         const char* agent,
                                                         GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.bluez.AgentManager1", "UnregisterAgent");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_object_path (agent));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
bluetooth_services_agent_manager_proxy_bluetooth_services_agent_manager_interface_init (BluetoothServicesAgentManagerIface* iface)
{
	iface->register_agent = bluetooth_services_agent_manager_proxy_register_agent;
	iface->request_default_agent = bluetooth_services_agent_manager_proxy_request_default_agent;
	iface->unregister_agent = bluetooth_services_agent_manager_proxy_unregister_agent;
}

static void
_dbus_bluetooth_services_agent_manager_register_agent (BluetoothServicesAgentManager* self,
                                                       GVariant* _parameters_,
                                                       GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	char* agent = NULL;
	GVariant* _tmp12_;
	gchar* capability = NULL;
	GVariant* _tmp13_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp12_ = g_variant_iter_next_value (&_arguments_iter);
	agent = g_variant_dup_string (_tmp12_, NULL);
	g_variant_unref (_tmp12_);
	_tmp13_ = g_variant_iter_next_value (&_arguments_iter);
	capability = g_variant_dup_string (_tmp13_, NULL);
	g_variant_unref (_tmp13_);
	bluetooth_services_agent_manager_register_agent (self, agent, capability, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (agent);
	_g_free0 (capability);
	;
}

static void
_dbus_bluetooth_services_agent_manager_request_default_agent (BluetoothServicesAgentManager* self,
                                                              GVariant* _parameters_,
                                                              GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	char* agent = NULL;
	GVariant* _tmp14_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp14_ = g_variant_iter_next_value (&_arguments_iter);
	agent = g_variant_dup_string (_tmp14_, NULL);
	g_variant_unref (_tmp14_);
	bluetooth_services_agent_manager_request_default_agent (self, agent, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (agent);
	;
}

static void
_dbus_bluetooth_services_agent_manager_unregister_agent (BluetoothServicesAgentManager* self,
                                                         GVariant* _parameters_,
                                                         GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	char* agent = NULL;
	GVariant* _tmp15_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp15_ = g_variant_iter_next_value (&_arguments_iter);
	agent = g_variant_dup_string (_tmp15_, NULL);
	g_variant_unref (_tmp15_);
	bluetooth_services_agent_manager_unregister_agent (self, agent, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (agent);
	;
}

static void
bluetooth_services_agent_manager_dbus_interface_method_call (GDBusConnection* connection,
                                                             const gchar* sender,
                                                             const gchar* object_path,
                                                             const gchar* interface_name,
                                                             const gchar* method_name,
                                                             GVariant* parameters,
                                                             GDBusMethodInvocation* invocation,
                                                             gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "RegisterAgent") == 0) {
		_dbus_bluetooth_services_agent_manager_register_agent (object, parameters, invocation);
	} else if (strcmp (method_name, "RequestDefaultAgent") == 0) {
		_dbus_bluetooth_services_agent_manager_request_default_agent (object, parameters, invocation);
	} else if (strcmp (method_name, "UnregisterAgent") == 0) {
		_dbus_bluetooth_services_agent_manager_unregister_agent (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
bluetooth_services_agent_manager_dbus_interface_get_property (GDBusConnection* connection,
                                                              const gchar* sender,
                                                              const gchar* object_path,
                                                              const gchar* interface_name,
                                                              const gchar* property_name,
                                                              GError** error,
                                                              gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
bluetooth_services_agent_manager_dbus_interface_set_property (GDBusConnection* connection,
                                                              const gchar* sender,
                                                              const gchar* object_path,
                                                              const gchar* interface_name,
                                                              const gchar* property_name,
                                                              GVariant* value,
                                                              GError** error,
                                                              gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
bluetooth_services_agent_manager_register_object (gpointer object,
                                                  GDBusConnection* connection,
                                                  const gchar* path,
                                                  GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_bluetooth_services_agent_manager_dbus_interface_info), &_bluetooth_services_agent_manager_dbus_interface_vtable, data, _bluetooth_services_agent_manager_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_bluetooth_services_agent_manager_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static inline gpointer
bluetooth_services_object_manager_get_instance_private (BluetoothServicesObjectManager* self)
{
	return G_STRUCT_MEMBER_P (self, BluetoothServicesObjectManager_private_offset);
}

static BluetoothServicesObjectManager*
__lambda9_ (void)
{
	BluetoothServicesObjectManager* _tmp0_;
	BluetoothServicesObjectManager* result;
	_tmp0_ = bluetooth_services_object_manager_new ();
	result = _tmp0_;
	return result;
}

static gpointer
___lambda9__gthread_func (gpointer self)
{
	gpointer result;
	result = __lambda9_ ();
	return result;
}

BluetoothServicesObjectManager*
bluetooth_services_object_manager_get_default (void)
{
	gconstpointer _tmp0_;
	BluetoothServicesObjectManager* result;
	_tmp0_ = g_once (&bluetooth_services_object_manager_instance, ___lambda9__gthread_func, NULL);
	result = (BluetoothServicesObjectManager*) _tmp0_;
	return result;
}

static BluetoothServicesObjectManager*
bluetooth_services_object_manager_construct (GType object_type)
{
	BluetoothServicesObjectManager * self = NULL;
	self = (BluetoothServicesObjectManager*) g_object_new (object_type, NULL);
	return self;
}

static BluetoothServicesObjectManager*
bluetooth_services_object_manager_new (void)
{
	return bluetooth_services_object_manager_construct (BLUETOOTH_SERVICES_TYPE_OBJECT_MANAGER);
}

static void
bluetooth_services_object_manager_create_manager_data_free (gpointer _data)
{
	BluetoothServicesObjectManagerCreateManagerData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (BluetoothServicesObjectManagerCreateManagerData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
bluetooth_services_object_manager_create_manager (BluetoothServicesObjectManager* self,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_)
{
	BluetoothServicesObjectManagerCreateManagerData* _data_;
	BluetoothServicesObjectManager* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (BluetoothServicesObjectManagerCreateManagerData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, bluetooth_services_object_manager_create_manager_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	bluetooth_services_object_manager_create_manager_co (_data_);
}

static void
bluetooth_services_object_manager_create_manager_finish (BluetoothServicesObjectManager* self,
                                                         GAsyncResult* _res_)
{
	BluetoothServicesObjectManagerCreateManagerData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static GType
_bluetooth_services_object_manager_object_manager_proxy_get_type_gd_bus_proxy_type_func (GDBusObjectManagerClient* manager,
                                                                                         const gchar* object_path,
                                                                                         const gchar* interface_name,
                                                                                         gpointer self)
{
	GType result;
	result = bluetooth_services_object_manager_object_manager_proxy_get_type ((BluetoothServicesObjectManager*) self, manager, object_path, interface_name);
	return result;
}

static void
bluetooth_services_object_manager_create_manager_ready (GObject* source_object,
                                                        GAsyncResult* _res_,
                                                        gpointer _user_data_)
{
	BluetoothServicesObjectManagerCreateManagerData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	bluetooth_services_object_manager_create_manager_co (_data_);
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		BluetoothServicesObjectManager* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->object);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
__lambda11_ (Block4Data* _data4_,
             GDBusInterface* iface)
{
	BluetoothServicesObjectManager* self;
	self = _data4_->self;
	g_return_if_fail (iface != NULL);
	bluetooth_services_object_manager_on_interface_added (self, _data4_->object, iface);
}

static void
___lambda11__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda11_ (self, (GDBusInterface*) data);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
___lambda10_ (BluetoothServicesObjectManager* self,
              GDBusObject* object)
{
	Block4Data* _data4_;
	GDBusObject* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	g_return_if_fail (object != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (object);
	_g_object_unref0 (_data4_->object);
	_data4_->object = _tmp0_;
	_tmp1_ = g_dbus_object_get_interfaces (_data4_->object);
	_tmp2_ = _tmp1_;
	g_list_foreach (_tmp2_, ___lambda11__gfunc, _data4_);
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (_g_list_free__g_object_unref0_ (_tmp2_), NULL));
	block4_data_unref (_data4_);
	_data4_ = NULL;
}

static void
____lambda10__gfunc (gconstpointer data,
                     gpointer self)
{
	___lambda10_ ((BluetoothServicesObjectManager*) self, (GDBusObject*) data);
}

static void
_bluetooth_services_object_manager_on_interface_added_g_dbus_object_manager_interface_added (GDBusObjectManager* _sender,
                                                                                             GDBusObject* object,
                                                                                             GDBusInterface* interface_,
                                                                                             gpointer self)
{
	bluetooth_services_object_manager_on_interface_added ((BluetoothServicesObjectManager*) self, object, interface_);
}

static void
_bluetooth_services_object_manager_on_interface_removed_g_dbus_object_manager_interface_removed (GDBusObjectManager* _sender,
                                                                                                 GDBusObject* object,
                                                                                                 GDBusInterface* interface_,
                                                                                                 gpointer self)
{
	bluetooth_services_object_manager_on_interface_removed ((BluetoothServicesObjectManager*) self, object, interface_);
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		BluetoothServicesObjectManager* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->object);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static void
__lambda18_ (Block5Data* _data5_,
             GDBusInterface* iface)
{
	BluetoothServicesObjectManager* self;
	self = _data5_->self;
	g_return_if_fail (iface != NULL);
	bluetooth_services_object_manager_on_interface_added (self, _data5_->object, iface);
}

static void
___lambda18__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda18_ (self, (GDBusInterface*) data);
}

static void
___lambda17_ (BluetoothServicesObjectManager* self,
              GDBusObject* object)
{
	Block5Data* _data5_;
	GDBusObject* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	g_return_if_fail (object != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (object);
	_g_object_unref0 (_data5_->object);
	_data5_->object = _tmp0_;
	_tmp1_ = g_dbus_object_get_interfaces (_data5_->object);
	_tmp2_ = _tmp1_;
	g_list_foreach (_tmp2_, ___lambda18__gfunc, _data5_);
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (_g_list_free__g_object_unref0_ (_tmp2_), NULL));
	block5_data_unref (_data5_);
	_data5_ = NULL;
}

static void
____lambda17__g_dbus_object_manager_object_added (GDBusObjectManager* _sender,
                                                  GDBusObject* object,
                                                  gpointer self)
{
	___lambda17_ ((BluetoothServicesObjectManager*) self, object);
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		BluetoothServicesObjectManager* self;
		self = _data6_->self;
		_g_object_unref0 (_data6_->object);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static void
__lambda20_ (Block6Data* _data6_,
             GDBusInterface* iface)
{
	BluetoothServicesObjectManager* self;
	self = _data6_->self;
	g_return_if_fail (iface != NULL);
	bluetooth_services_object_manager_on_interface_removed (self, _data6_->object, iface);
}

static void
___lambda20__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda20_ (self, (GDBusInterface*) data);
}

static void
___lambda19_ (BluetoothServicesObjectManager* self,
              GDBusObject* object)
{
	Block6Data* _data6_;
	GDBusObject* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	g_return_if_fail (object != NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (object);
	_g_object_unref0 (_data6_->object);
	_data6_->object = _tmp0_;
	_tmp1_ = g_dbus_object_get_interfaces (_data6_->object);
	_tmp2_ = _tmp1_;
	g_list_foreach (_tmp2_, ___lambda20__gfunc, _data6_);
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (_g_list_free__g_object_unref0_ (_tmp2_), NULL));
	block6_data_unref (_data6_);
	_data6_ = NULL;
}

static void
____lambda19__g_dbus_object_manager_object_removed (GDBusObjectManager* _sender,
                                                    GDBusObject* object,
                                                    gpointer self)
{
	___lambda19_ ((BluetoothServicesObjectManager*) self, object);
}

static gboolean
bluetooth_services_object_manager_create_manager_co (BluetoothServicesObjectManagerCreateManagerData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_state_ = 1;
		g_dbus_object_manager_client_new_for_bus (G_BUS_TYPE_SYSTEM, G_DBUS_OBJECT_MANAGER_CLIENT_FLAGS_NONE, "org.bluez", "/", _bluetooth_services_object_manager_object_manager_proxy_get_type_gd_bus_proxy_type_func, g_object_ref (_data_->self), g_object_unref, NULL, bluetooth_services_object_manager_create_manager_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp1_ = g_dbus_object_manager_client_new_for_bus_finish (_data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp0_ = _data_->_tmp1_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp2_ = _data_->_tmp0_;
		_data_->_tmp0_ = NULL;
		_g_object_unref0 (_data_->self->priv->object_manager);
		_data_->self->priv->object_manager = _data_->_tmp2_;
		_data_->_tmp3_ = _data_->self->priv->object_manager;
		if (_data_->_tmp3_ == NULL) {
			_g_object_unref0 (_data_->_tmp0_);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp4_ = _data_->self->priv->object_manager;
		_data_->_tmp5_ = g_dbus_object_manager_get_objects ((GDBusObjectManager*) _data_->_tmp4_);
		_data_->_tmp6_ = _data_->_tmp5_;
		g_list_foreach (_data_->_tmp6_, ____lambda10__gfunc, _data_->self);
		(_data_->_tmp6_ == NULL) ? NULL : (_data_->_tmp6_ = (_g_list_free__g_object_unref0_ (_data_->_tmp6_), NULL));
		_data_->_tmp7_ = _data_->self->priv->object_manager;
		g_signal_connect_object ((GDBusObjectManager*) _data_->_tmp7_, "interface-added", (GCallback) _bluetooth_services_object_manager_on_interface_added_g_dbus_object_manager_interface_added, _data_->self, 0);
		_data_->_tmp8_ = _data_->self->priv->object_manager;
		g_signal_connect_object ((GDBusObjectManager*) _data_->_tmp8_, "interface-removed", (GCallback) _bluetooth_services_object_manager_on_interface_removed_g_dbus_object_manager_interface_removed, _data_->self, 0);
		_data_->_tmp9_ = _data_->self->priv->object_manager;
		g_signal_connect_object ((GDBusObjectManager*) _data_->_tmp9_, "object-added", (GCallback) ____lambda17__g_dbus_object_manager_object_added, _data_->self, 0);
		_data_->_tmp10_ = _data_->self->priv->object_manager;
		g_signal_connect_object ((GDBusObjectManager*) _data_->_tmp10_, "object-removed", (GCallback) ____lambda19__g_dbus_object_manager_object_removed, _data_->self, 0);
		_g_object_unref0 (_data_->_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp11_ = _data_->e;
		_data_->_tmp12_ = _data_->_tmp11_->message;
		g_critical ("Manager.vala:102: %s", _data_->_tmp12_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	bluetooth_services_object_manager_set_retrieve_finished (_data_->self, TRUE);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static GType
bluetooth_services_object_manager_object_manager_proxy_get_type (BluetoothServicesObjectManager* self,
                                                                 GDBusObjectManagerClient* manager,
                                                                 const gchar* object_path,
                                                                 const gchar* interface_name)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	GType result;
	g_return_val_if_fail (self != NULL, 0UL);
	g_return_val_if_fail (manager != NULL, 0UL);
	g_return_val_if_fail (object_path != NULL, 0UL);
	if (interface_name == NULL) {
		result = g_dbus_object_proxy_get_type ();
		return result;
	}
	_tmp0_ = interface_name;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("org.bluez.Device1")))) {
		switch (0) {
			default:
			{
				result = bluetooth_services_device_proxy_get_type ();
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("org.bluez.Adapter1")))) {
		switch (0) {
			default:
			{
				result = bluetooth_services_adapter_proxy_get_type ();
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("org.bluez.AgentManager1")))) {
		switch (0) {
			default:
			{
				result = bluetooth_services_agent_manager_proxy_get_type ();
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = g_dbus_proxy_get_type ();
				return result;
			}
		}
	}
}

static void
___lambda12_ (BluetoothServicesObjectManager* self,
              GVariant* changed,
              gchar** invalid)
{
	GVariant* connected = NULL;
	const GVariantType* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	GVariant* paired = NULL;
	const GVariantType* _tmp3_;
	GVariant* _tmp4_;
	GVariant* _tmp5_;
	g_return_if_fail (changed != NULL);
	_tmp0_ = G_VARIANT_TYPE_BOOLEAN;
	_tmp1_ = g_variant_lookup_value (changed, "Connected", _tmp0_);
	connected = _tmp1_;
	_tmp2_ = connected;
	if (_tmp2_ != NULL) {
		bluetooth_services_object_manager_check_global_state (self);
	}
	_tmp3_ = G_VARIANT_TYPE_BOOLEAN;
	_tmp4_ = g_variant_lookup_value (changed, "Paired", _tmp3_);
	paired = _tmp4_;
	_tmp5_ = paired;
	if (_tmp5_ != NULL) {
		bluetooth_services_object_manager_check_global_state (self);
	}
	_g_variant_unref0 (paired);
	_g_variant_unref0 (connected);
}

static void
____lambda12__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                 GVariant* changed_properties,
                                                 gchar** invalidated_properties,
                                                 gpointer self)
{
	___lambda12_ ((BluetoothServicesObjectManager*) self, changed_properties, invalidated_properties);
}

static void
____lambda16_ (BluetoothServicesObjectManager* self,
               GVariant* changed,
               gchar** invalid)
{
	GVariant* powered = NULL;
	const GVariantType* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	GVariant* discovering = NULL;
	const GVariantType* _tmp3_;
	GVariant* _tmp4_;
	GVariant* _tmp5_;
	GVariant* adapter_discoverable = NULL;
	const GVariantType* _tmp6_;
	GVariant* _tmp7_;
	GVariant* _tmp8_;
	g_return_if_fail (changed != NULL);
	_tmp0_ = G_VARIANT_TYPE_BOOLEAN;
	_tmp1_ = g_variant_lookup_value (changed, "Powered", _tmp0_);
	powered = _tmp1_;
	_tmp2_ = powered;
	if (_tmp2_ != NULL) {
		bluetooth_services_object_manager_check_global_state (self);
	}
	_tmp3_ = G_VARIANT_TYPE_BOOLEAN;
	_tmp4_ = g_variant_lookup_value (changed, "Discovering", _tmp3_);
	discovering = _tmp4_;
	_tmp5_ = discovering;
	if (_tmp5_ != NULL) {
		bluetooth_services_object_manager_check_discovering (self);
	}
	_tmp6_ = G_VARIANT_TYPE_BOOLEAN;
	_tmp7_ = g_variant_lookup_value (changed, "Discoverable", _tmp6_);
	adapter_discoverable = _tmp7_;
	_tmp8_ = adapter_discoverable;
	if (_tmp8_ != NULL) {
		bluetooth_services_object_manager_check_discoverable (self);
	}
	_g_variant_unref0 (adapter_discoverable);
	_g_variant_unref0 (discovering);
	_g_variant_unref0 (powered);
}

static void
_____lambda16__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                  GVariant* changed_properties,
                                                  gchar** invalidated_properties,
                                                  gpointer self)
{
	____lambda16_ ((BluetoothServicesObjectManager*) self, changed_properties, invalidated_properties);
}

static void
bluetooth_services_object_manager_on_interface_added (BluetoothServicesObjectManager* self,
                                                      GDBusObject* object,
                                                      GDBusInterface* iface)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	g_return_if_fail (iface != NULL);
	if (BLUETOOTH_SERVICES_IS_DEVICE (iface)) {
		BluetoothServicesDevice* device = NULL;
		BluetoothServicesDevice* _tmp0_;
		BluetoothServicesDevice* _tmp1_;
		device = G_TYPE_CHECK_INSTANCE_CAST (iface, BLUETOOTH_SERVICES_TYPE_DEVICE, BluetoothServicesDevice);
		_tmp0_ = device;
		g_signal_emit (self, bluetooth_services_object_manager_signals[BLUETOOTH_SERVICES_OBJECT_MANAGER_DEVICE_ADDED_SIGNAL], 0, _tmp0_);
		_tmp1_ = device;
		g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_dbus_proxy_get_type (), GDBusProxy), "g-properties-changed", (GCallback) ____lambda12__g_dbus_proxy_g_properties_changed, self, 0);
		bluetooth_services_object_manager_check_global_state (self);
	} else {
		if (BLUETOOTH_SERVICES_IS_ADAPTER (iface)) {
			BluetoothServicesAdapter* adapter = NULL;
			BluetoothServicesAdapter* _tmp2_;
			BluetoothServicesAdapter* _tmp3_;
			adapter = G_TYPE_CHECK_INSTANCE_CAST (iface, BLUETOOTH_SERVICES_TYPE_ADAPTER, BluetoothServicesAdapter);
			bluetooth_services_object_manager_set_has_object (self, TRUE);
			_tmp2_ = adapter;
			g_signal_emit (self, bluetooth_services_object_manager_signals[BLUETOOTH_SERVICES_OBJECT_MANAGER_ADAPTER_ADDED_SIGNAL], 0, _tmp2_);
			_tmp3_ = adapter;
			g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, g_dbus_proxy_get_type (), GDBusProxy), "g-properties-changed", (GCallback) _____lambda16__g_dbus_proxy_g_properties_changed, self, 0);
			bluetooth_services_object_manager_check_global_state (self);
		}
	}
}

static void
bluetooth_services_object_manager_on_interface_removed (BluetoothServicesObjectManager* self,
                                                        GDBusObject* object,
                                                        GDBusInterface* iface)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	g_return_if_fail (iface != NULL);
	if (BLUETOOTH_SERVICES_IS_DEVICE (iface)) {
		g_signal_emit (self, bluetooth_services_object_manager_signals[BLUETOOTH_SERVICES_OBJECT_MANAGER_DEVICE_REMOVED_SIGNAL], 0, G_TYPE_CHECK_INSTANCE_CAST (iface, BLUETOOTH_SERVICES_TYPE_DEVICE, BluetoothServicesDevice));
	} else {
		if (BLUETOOTH_SERVICES_IS_ADAPTER (iface)) {
			GeeLinkedList* _tmp0_;
			GeeLinkedList* _tmp1_;
			gboolean _tmp2_;
			gboolean _tmp3_;
			g_signal_emit (self, bluetooth_services_object_manager_signals[BLUETOOTH_SERVICES_OBJECT_MANAGER_ADAPTER_REMOVED_SIGNAL], 0, G_TYPE_CHECK_INSTANCE_CAST (iface, BLUETOOTH_SERVICES_TYPE_ADAPTER, BluetoothServicesAdapter));
			_tmp0_ = bluetooth_services_object_manager_get_adapters (self);
			_tmp1_ = _tmp0_;
			_tmp2_ = gee_collection_get_is_empty ((GeeCollection*) _tmp1_);
			_tmp3_ = _tmp2_;
			bluetooth_services_object_manager_set_has_object (self, !_tmp3_);
			_g_object_unref0 (_tmp1_);
		}
	}
}

void
bluetooth_services_object_manager_check_discovering (BluetoothServicesObjectManager* self)
{
	GeeLinkedList* adapters = NULL;
	GeeLinkedList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bluetooth_services_object_manager_get_adapters (self);
	adapters = _tmp0_;
	{
		GeeLinkedList* _adapter_list = NULL;
		GeeLinkedList* _tmp1_;
		gint _adapter_size = 0;
		GeeLinkedList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _adapter_index = 0;
		_tmp1_ = adapters;
		_adapter_list = _tmp1_;
		_tmp2_ = _adapter_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_adapter_size = _tmp4_;
		_adapter_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			BluetoothServicesAdapter* adapter = NULL;
			GeeLinkedList* _tmp7_;
			gpointer _tmp8_;
			BluetoothServicesAdapter* _tmp9_;
			gboolean _tmp10_;
			gboolean _tmp11_;
			gboolean _tmp12_;
			_adapter_index = _adapter_index + 1;
			_tmp5_ = _adapter_index;
			_tmp6_ = _adapter_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _adapter_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _adapter_index);
			adapter = (BluetoothServicesAdapter*) _tmp8_;
			_tmp9_ = adapter;
			_tmp10_ = bluetooth_services_adapter_get_discovering (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = self->priv->_is_discovering;
			if (_tmp11_ != _tmp12_) {
				gboolean _tmp13_;
				_tmp13_ = self->priv->_is_discovering;
				if (_tmp13_) {
					BluetoothServicesAdapter* _tmp14_;
					_tmp14_ = adapter;
					bluetooth_services_adapter_start_discovery (_tmp14_, NULL, NULL);
				} else {
					BluetoothServicesAdapter* _tmp15_;
					_tmp15_ = adapter;
					bluetooth_services_adapter_stop_discovery (_tmp15_, NULL, NULL);
				}
			}
			_g_object_unref0 (adapter);
		}
	}
	_g_object_unref0 (adapters);
}

void
bluetooth_services_object_manager_check_discoverable (BluetoothServicesObjectManager* self)
{
	GeeLinkedList* adapters = NULL;
	GeeLinkedList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bluetooth_services_object_manager_get_adapters (self);
	adapters = _tmp0_;
	{
		GeeLinkedList* _adapter_list = NULL;
		GeeLinkedList* _tmp1_;
		gint _adapter_size = 0;
		GeeLinkedList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _adapter_index = 0;
		_tmp1_ = adapters;
		_adapter_list = _tmp1_;
		_tmp2_ = _adapter_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_adapter_size = _tmp4_;
		_adapter_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			BluetoothServicesAdapter* adapter = NULL;
			GeeLinkedList* _tmp7_;
			gpointer _tmp8_;
			BluetoothServicesAdapter* _tmp9_;
			gboolean _tmp10_;
			gboolean _tmp11_;
			gboolean _tmp12_;
			_adapter_index = _adapter_index + 1;
			_tmp5_ = _adapter_index;
			_tmp6_ = _adapter_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _adapter_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _adapter_index);
			adapter = (BluetoothServicesAdapter*) _tmp8_;
			_tmp9_ = adapter;
			_tmp10_ = bluetooth_services_adapter_get_discoverable (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = self->priv->_discoverable;
			if (_tmp11_ != _tmp12_) {
				BluetoothServicesAdapter* _tmp13_;
				gboolean _tmp14_;
				_tmp13_ = adapter;
				_tmp14_ = self->priv->_discoverable;
				bluetooth_services_adapter_set_discoverable (_tmp13_, _tmp14_);
			}
			_g_object_unref0 (adapter);
		}
	}
	_g_object_unref0 (adapters);
}

gchar*
bluetooth_services_object_manager_get_name (BluetoothServicesObjectManager* self)
{
	GeeLinkedList* adapters = NULL;
	GeeLinkedList* _tmp0_;
	GeeLinkedList* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = bluetooth_services_object_manager_get_adapters (self);
	adapters = _tmp0_;
	_tmp1_ = adapters;
	_tmp2_ = gee_collection_get_is_empty ((GeeCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		result = NULL;
		_g_object_unref0 (adapters);
		return result;
	} else {
		GeeLinkedList* _tmp4_;
		gpointer _tmp5_;
		BluetoothServicesAdapter* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp4_ = adapters;
		_tmp5_ = gee_linked_list_first (_tmp4_);
		_tmp6_ = (BluetoothServicesAdapter*) _tmp5_;
		_tmp7_ = bluetooth_services_adapter_get_name (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = _tmp8_;
		_g_object_unref0 (_tmp6_);
		result = _tmp9_;
		_g_object_unref0 (adapters);
		return result;
	}
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		BluetoothServicesObjectManager* self;
		self = _data7_->self;
		_g_object_unref0 (_data7_->adapters);
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}

static void
___lambda14_ (Block7Data* _data7_,
              GDBusObject* object)
{
	BluetoothServicesObjectManager* self;
	GDBusInterface* iface = NULL;
	GDBusInterface* _tmp0_;
	GDBusInterface* _tmp1_;
	GeeLinkedList* _tmp2_;
	GDBusInterface* _tmp3_;
	self = _data7_->self;
	g_return_if_fail (object != NULL);
	_tmp0_ = g_dbus_object_get_interface (object, "org.bluez.Adapter1");
	iface = _tmp0_;
	_tmp1_ = iface;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (iface);
		return;
	}
	_tmp2_ = _data7_->adapters;
	_tmp3_ = iface;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp2_, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, BLUETOOTH_SERVICES_TYPE_ADAPTER, BluetoothServicesAdapter));
	_g_object_unref0 (iface);
}

static void
____lambda14__gfunc (gconstpointer data,
                     gpointer self)
{
	___lambda14_ (self, (GDBusObject*) data);
}

GeeLinkedList*
bluetooth_services_object_manager_get_adapters (BluetoothServicesObjectManager* self)
{
	Block7Data* _data7_;
	GeeLinkedList* _tmp0_;
	GDBusObjectManagerClient* _tmp1_;
	GeeLinkedList* _tmp5_;
	GeeLinkedList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	_tmp0_ = gee_linked_list_new (BLUETOOTH_SERVICES_TYPE_ADAPTER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_data7_->adapters = _tmp0_;
	_tmp1_ = self->priv->object_manager;
	if (_tmp1_ != NULL) {
		GDBusObjectManagerClient* _tmp2_;
		GList* _tmp3_;
		GList* _tmp4_;
		_tmp2_ = self->priv->object_manager;
		_tmp3_ = g_dbus_object_manager_get_objects ((GDBusObjectManager*) _tmp2_);
		_tmp4_ = _tmp3_;
		g_list_foreach (_tmp4_, ____lambda14__gfunc, _data7_);
		(_tmp4_ == NULL) ? NULL : (_tmp4_ = (_g_list_free__g_object_unref0_ (_tmp4_), NULL));
	}
	_tmp5_ = _data7_->adapters;
	_data7_->adapters = NULL;
	result = _tmp5_;
	block7_data_unref (_data7_);
	_data7_ = NULL;
	return result;
}

static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}

static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		BluetoothServicesObjectManager* self;
		self = _data8_->self;
		_g_object_unref0 (_data8_->devices);
		_g_object_unref0 (self);
		g_slice_free (Block8Data, _data8_);
	}
}

static void
___lambda15_ (Block8Data* _data8_,
              GDBusObject* object)
{
	BluetoothServicesObjectManager* self;
	GDBusInterface* iface = NULL;
	GDBusInterface* _tmp0_;
	GDBusInterface* _tmp1_;
	GeeLinkedList* _tmp2_;
	GDBusInterface* _tmp3_;
	self = _data8_->self;
	g_return_if_fail (object != NULL);
	_tmp0_ = g_dbus_object_get_interface (object, "org.bluez.Device1");
	iface = _tmp0_;
	_tmp1_ = iface;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (iface);
		return;
	}
	_tmp2_ = _data8_->devices;
	_tmp3_ = iface;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp2_, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, BLUETOOTH_SERVICES_TYPE_DEVICE, BluetoothServicesDevice));
	_g_object_unref0 (iface);
}

static void
____lambda15__gfunc (gconstpointer data,
                     gpointer self)
{
	___lambda15_ (self, (GDBusObject*) data);
}

GeeCollection*
bluetooth_services_object_manager_get_devices (BluetoothServicesObjectManager* self)
{
	Block8Data* _data8_;
	GeeLinkedList* _tmp0_;
	GDBusObjectManagerClient* _tmp1_;
	GeeLinkedList* _tmp5_;
	GeeCollection* result;
	g_return_val_if_fail (self != NULL, NULL);
	_data8_ = g_slice_new0 (Block8Data);
	_data8_->_ref_count_ = 1;
	_data8_->self = g_object_ref (self);
	_tmp0_ = gee_linked_list_new (BLUETOOTH_SERVICES_TYPE_DEVICE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_data8_->devices = _tmp0_;
	_tmp1_ = self->priv->object_manager;
	if (_tmp1_ != NULL) {
		GDBusObjectManagerClient* _tmp2_;
		GList* _tmp3_;
		GList* _tmp4_;
		_tmp2_ = self->priv->object_manager;
		_tmp3_ = g_dbus_object_manager_get_objects ((GDBusObjectManager*) _tmp2_);
		_tmp4_ = _tmp3_;
		g_list_foreach (_tmp4_, ____lambda15__gfunc, _data8_);
		(_tmp4_ == NULL) ? NULL : (_tmp4_ = (_g_list_free__g_object_unref0_ (_tmp4_), NULL));
	}
	_tmp5_ = _data8_->devices;
	_data8_->devices = NULL;
	result = (GeeCollection*) _tmp5_;
	block8_data_unref (_data8_);
	_data8_ = NULL;
	return result;
}

BluetoothServicesAdapter*
bluetooth_services_object_manager_get_adapter_from_path (BluetoothServicesObjectManager* self,
                                                         const gchar* path)
{
	GDBusObject* object = NULL;
	GDBusObjectManagerClient* _tmp0_;
	GDBusObject* _tmp1_;
	GDBusObject* _tmp2_;
	BluetoothServicesAdapter* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = self->priv->object_manager;
	_tmp1_ = g_dbus_object_manager_get_object ((GDBusObjectManager*) _tmp0_, path);
	object = _tmp1_;
	_tmp2_ = object;
	if (_tmp2_ != NULL) {
		GDBusObject* _tmp3_;
		GDBusInterface* _tmp4_;
		_tmp3_ = object;
		_tmp4_ = g_dbus_object_get_interface (_tmp3_, "org.bluez.Adapter1");
		result = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, BLUETOOTH_SERVICES_TYPE_ADAPTER, BluetoothServicesAdapter);
		_g_object_unref0 (object);
		return result;
	}
	result = NULL;
	_g_object_unref0 (object);
	return result;
}

static void
bluetooth_services_object_manager_create_agent_data_free (gpointer _data)
{
	BluetoothServicesObjectManagerCreateAgentData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (BluetoothServicesObjectManagerCreateAgentData, _data_);
}

static void
bluetooth_services_object_manager_create_agent (BluetoothServicesObjectManager* self,
                                                GtkWindow* window,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_)
{
	BluetoothServicesObjectManagerCreateAgentData* _data_;
	BluetoothServicesObjectManager* _tmp0_;
	GtkWindow* _tmp1_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (BluetoothServicesObjectManagerCreateAgentData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, bluetooth_services_object_manager_create_agent_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (window);
	_g_object_unref0 (_data_->window);
	_data_->window = _tmp1_;
	bluetooth_services_object_manager_create_agent_co (_data_);
}

static void
bluetooth_services_object_manager_create_agent_finish (BluetoothServicesObjectManager* self,
                                                       GAsyncResult* _res_)
{
	BluetoothServicesObjectManagerCreateAgentData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block9Data*
block9_data_ref (Block9Data* _data9_)
{
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}

static void
block9_data_unref (void * _userdata_)
{
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		BluetoothServicesObjectManager* self;
		self = _data9_->self;
		_g_object_unref0 (_data9_->window);
		_g_object_unref0 (self);
		g_slice_free (Block9Data, _data9_);
	}
}

static void
__lambda21_ (Block9Data* _data9_)
{
	BluetoothServicesObjectManager* self;
	self = _data9_->self;
	if (self->priv->is_registered) {
		bluetooth_services_object_manager_register_agent (self, _data9_->window, NULL, NULL);
	}
}

static void
___lambda21__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda21_ (self);
}

static void
__lambda22_ (BluetoothServicesObjectManager* self)
{
	self->priv->is_registered = FALSE;
}

static void
___lambda22__bluetooth_services_agent_unregistered (BluetoothServicesAgent* _sender,
                                                    gpointer self)
{
	__lambda22_ ((BluetoothServicesObjectManager*) self);
}

static gboolean
bluetooth_services_object_manager_create_agent_co (BluetoothServicesObjectManagerCreateAgentData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data9_ = g_slice_new0 (Block9Data);
	_data_->_data9_->_ref_count_ = 1;
	_data_->_data9_->self = g_object_ref (_data_->self);
	_g_object_unref0 (_data_->_data9_->window);
	_data_->_data9_->window = _data_->window;
	_data_->_data9_->_async_data_ = _data_;
	_data_->_tmp0_ = _data_->self->priv->object_manager;
	if (_data_->_tmp0_ == NULL) {
		block9_data_unref (_data_->_data9_);
		_data_->_data9_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = _data_->self->priv->object_manager;
	_data_->_tmp2_ = g_dbus_object_manager_get_object ((GDBusObjectManager*) _data_->_tmp1_, "/org/bluez");
	_data_->bluez_object = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->bluez_object;
	if (_data_->_tmp3_ != NULL) {
		_data_->_tmp4_ = _data_->bluez_object;
		_data_->_tmp5_ = g_dbus_object_get_interface (_data_->_tmp4_, "org.bluez.AgentManager1");
		_g_object_unref0 (_data_->self->priv->agent_manager);
		_data_->self->priv->agent_manager = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp5_, BLUETOOTH_SERVICES_TYPE_AGENT_MANAGER, BluetoothServicesAgentManager);
	}
	_data_->_tmp6_ = bluetooth_services_agent_new (_data_->_data9_->window);
	_g_object_unref0 (_data_->self->priv->agent);
	_data_->self->priv->agent = _data_->_tmp6_;
	_data_->_tmp7_ = _data_->self->priv->agent;
	g_signal_connect_data ((GObject*) _data_->_tmp7_, "notify::ready", (GCallback) ___lambda21__g_object_notify, block9_data_ref (_data_->_data9_), (GClosureNotify) block9_data_unref, 0);
	_data_->_tmp8_ = _data_->self->priv->agent;
	g_signal_connect_object (_data_->_tmp8_, "unregistered", (GCallback) ___lambda22__bluetooth_services_agent_unregistered, _data_->self, 0);
	_g_object_unref0 (_data_->bluez_object);
	block9_data_unref (_data_->_data9_);
	_data_->_data9_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
bluetooth_services_object_manager_register_agent_data_free (gpointer _data)
{
	BluetoothServicesObjectManagerRegisterAgentData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->window);
	_g_object_unref0 (_data_->self);
	g_slice_free (BluetoothServicesObjectManagerRegisterAgentData, _data_);
}

void
bluetooth_services_object_manager_register_agent (BluetoothServicesObjectManager* self,
                                                  GtkWindow* window,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_)
{
	BluetoothServicesObjectManagerRegisterAgentData* _data_;
	BluetoothServicesObjectManager* _tmp0_;
	GtkWindow* _tmp1_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (BluetoothServicesObjectManagerRegisterAgentData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, bluetooth_services_object_manager_register_agent_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (window);
	_g_object_unref0 (_data_->window);
	_data_->window = _tmp1_;
	bluetooth_services_object_manager_register_agent_co (_data_);
}

void
bluetooth_services_object_manager_register_agent_finish (BluetoothServicesObjectManager* self,
                                                         GAsyncResult* _res_)
{
	BluetoothServicesObjectManagerRegisterAgentData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
bluetooth_services_object_manager_register_agent_ready (GObject* source_object,
                                                        GAsyncResult* _res_,
                                                        gpointer _user_data_)
{
	BluetoothServicesObjectManagerRegisterAgentData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	bluetooth_services_object_manager_register_agent_co (_data_);
}

static gboolean
bluetooth_services_object_manager_register_agent_co (BluetoothServicesObjectManagerRegisterAgentData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->self->priv->is_registered = TRUE;
	_data_->_tmp0_ = _data_->self->priv->agent_manager;
	if (_data_->_tmp0_ == NULL) {
		_data_->_state_ = 1;
		bluetooth_services_object_manager_create_agent (_data_->self, _data_->window, bluetooth_services_object_manager_register_agent_ready, _data_);
		return FALSE;
		_state_1:
		bluetooth_services_object_manager_create_agent_finish (_data_->self, _data_->_res_);
	}
	_data_->_tmp2_ = _data_->self->priv->agent_manager;
	if (_data_->_tmp2_ != NULL) {
		_data_->_tmp3_ = _data_->self->priv->agent;
		_data_->_tmp4_ = bluetooth_services_agent_get_ready (_data_->_tmp3_);
		_data_->_tmp5_ = _data_->_tmp4_;
		_data_->_tmp1_ = _data_->_tmp5_;
	} else {
		_data_->_tmp1_ = FALSE;
	}
	if (_data_->_tmp1_) {
		{
			_data_->_tmp6_ = _data_->self->priv->agent_manager;
			_data_->_tmp7_ = _data_->self->priv->agent;
			_data_->_tmp8_ = bluetooth_services_agent_get_path (_data_->_tmp7_);
			_data_->_tmp9_ = _data_->_tmp8_;
			bluetooth_services_agent_manager_register_agent (_data_->_tmp6_, _data_->_tmp9_, "DisplayYesNo", &_data_->_inner_error0_);
			_g_free0 (_data_->_tmp9_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_data_->_tmp10_ = _data_->self->priv->agent_manager;
			_data_->_tmp11_ = _data_->self->priv->agent;
			_data_->_tmp12_ = bluetooth_services_agent_get_path (_data_->_tmp11_);
			_data_->_tmp13_ = _data_->_tmp12_;
			bluetooth_services_agent_manager_request_default_agent (_data_->_tmp10_, _data_->_tmp13_, &_data_->_inner_error0_);
			_g_free0 (_data_->_tmp13_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->e = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp14_ = _data_->e;
			_data_->_tmp15_ = _data_->_tmp14_->message;
			g_critical ("Manager.vala:289: %s", _data_->_tmp15_);
			_g_error_free0 (_data_->e);
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
bluetooth_services_object_manager_unregister_agent_data_free (gpointer _data)
{
	BluetoothServicesObjectManagerUnregisterAgentData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (BluetoothServicesObjectManagerUnregisterAgentData, _data_);
}

void
bluetooth_services_object_manager_unregister_agent (BluetoothServicesObjectManager* self,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_)
{
	BluetoothServicesObjectManagerUnregisterAgentData* _data_;
	BluetoothServicesObjectManager* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (BluetoothServicesObjectManagerUnregisterAgentData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, bluetooth_services_object_manager_unregister_agent_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	bluetooth_services_object_manager_unregister_agent_co (_data_);
}

void
bluetooth_services_object_manager_unregister_agent_finish (BluetoothServicesObjectManager* self,
                                                           GAsyncResult* _res_)
{
	BluetoothServicesObjectManagerUnregisterAgentData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static gboolean
bluetooth_services_object_manager_unregister_agent_co (BluetoothServicesObjectManagerUnregisterAgentData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->self->priv->is_registered = FALSE;
	_data_->_tmp1_ = _data_->self->priv->agent_manager;
	if (_data_->_tmp1_ != NULL) {
		_data_->_tmp2_ = _data_->self->priv->agent;
		_data_->_tmp3_ = bluetooth_services_agent_get_ready (_data_->_tmp2_);
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_tmp0_ = _data_->_tmp4_;
	} else {
		_data_->_tmp0_ = FALSE;
	}
	if (_data_->_tmp0_) {
		{
			_data_->_tmp5_ = _data_->self->priv->agent_manager;
			_data_->_tmp6_ = _data_->self->priv->agent;
			_data_->_tmp7_ = bluetooth_services_agent_get_path (_data_->_tmp6_);
			_data_->_tmp8_ = _data_->_tmp7_;
			bluetooth_services_agent_manager_unregister_agent (_data_->_tmp5_, _data_->_tmp8_, &_data_->_inner_error0_);
			_g_free0 (_data_->_tmp8_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->e = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp9_ = _data_->e;
			_data_->_tmp10_ = _data_->_tmp9_->message;
			g_critical ("Manager.vala:300: %s", _data_->_tmp10_);
			_g_error_free0 (_data_->e);
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gboolean
__lambda13_ (BluetoothServicesObjectManager* self)
{
	gboolean powered = FALSE;
	gboolean connected = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean result;
	powered = bluetooth_services_object_manager_get_global_state (self);
	connected = bluetooth_services_object_manager_get_connected (self);
	_tmp1_ = self->priv->_is_powered;
	if (powered != _tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_;
		_tmp2_ = self->priv->_is_connected;
		_tmp0_ = connected != _tmp2_;
	}
	if (_tmp0_) {
		if (!powered) {
			bluetooth_services_object_manager_set_discoverable (self, FALSE);
		}
		bluetooth_services_object_manager_set_is_connected (self, connected);
		bluetooth_services_object_manager_set_is_powered (self, powered);
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda13__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda13_ ((BluetoothServicesObjectManager*) self);
	return result;
}

void
bluetooth_services_object_manager_check_global_state (BluetoothServicesObjectManager* self)
{
	g_return_if_fail (self != NULL);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda13__gsource_func, g_object_ref (self), g_object_unref);
}

static void
bluetooth_services_object_manager_start_discovery_data_free (gpointer _data)
{
	BluetoothServicesObjectManagerStartDiscoveryData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (BluetoothServicesObjectManagerStartDiscoveryData, _data_);
}

void
bluetooth_services_object_manager_start_discovery (BluetoothServicesObjectManager* self,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_)
{
	BluetoothServicesObjectManagerStartDiscoveryData* _data_;
	BluetoothServicesObjectManager* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (BluetoothServicesObjectManagerStartDiscoveryData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, bluetooth_services_object_manager_start_discovery_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	bluetooth_services_object_manager_start_discovery_co (_data_);
}

void
bluetooth_services_object_manager_start_discovery_finish (BluetoothServicesObjectManager* self,
                                                          GAsyncResult* _res_)
{
	BluetoothServicesObjectManagerStartDiscoveryData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
bluetooth_services_object_manager_start_discovery_ready (GObject* source_object,
                                                         GAsyncResult* _res_,
                                                         gpointer _user_data_)
{
	BluetoothServicesObjectManagerStartDiscoveryData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	bluetooth_services_object_manager_start_discovery_co (_data_);
}

static gboolean
bluetooth_services_object_manager_start_discovery_co (BluetoothServicesObjectManagerStartDiscoveryData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = bluetooth_services_object_manager_get_adapters (_data_->self);
	_data_->adapters = _data_->_tmp0_;
	bluetooth_services_object_manager_set_is_discovering (_data_->self, TRUE);
	{
		_data_->_tmp1_ = _data_->adapters;
		_data_->_adapter_list = _data_->_tmp1_;
		_data_->_tmp2_ = _data_->_adapter_list;
		_data_->_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp2_);
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_adapter_size = _data_->_tmp4_;
		_data_->_adapter_index = -1;
		while (TRUE) {
			_data_->_adapter_index = _data_->_adapter_index + 1;
			_data_->_tmp5_ = _data_->_adapter_index;
			_data_->_tmp6_ = _data_->_adapter_size;
			if (!(_data_->_tmp5_ < _data_->_tmp6_)) {
				break;
			}
			_data_->_tmp7_ = _data_->_adapter_list;
			_data_->_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp7_, _data_->_adapter_index);
			_data_->adapter = (BluetoothServicesAdapter*) _data_->_tmp8_;
			{
				_data_->_tmp9_ = _data_->adapter;
				_data_->_state_ = 1;
				bluetooth_services_adapter_start_discovery (_data_->_tmp9_, bluetooth_services_object_manager_start_discovery_ready, _data_);
				return FALSE;
				_state_1:
				bluetooth_services_adapter_start_discovery_finish (_data_->_tmp9_, _data_->_res_, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_data_->_tmp10_ = _data_->adapter;
				_data_->_tmp11_ = bluetooth_services_adapter_get_name (_data_->_tmp10_);
				_data_->_tmp12_ = _data_->_tmp11_;
				_data_->_tmp13_ = _data_->_tmp12_;
				g_debug ("Manager.vala:332: Adapter %s started", _data_->_tmp13_);
				_g_free0 (_data_->_tmp13_);
			}
			goto __finally0;
			__catch0_g_error:
			{
				_data_->e = _data_->_inner_error0_;
				_data_->_inner_error0_ = NULL;
				_data_->_tmp14_ = _data_->e;
				_data_->_tmp15_ = _data_->_tmp14_->message;
				g_critical ("Manager.vala:334: %s", _data_->_tmp15_);
				_g_error_free0 (_data_->e);
			}
			__finally0:
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_object_unref0 (_data_->adapter);
				_g_object_unref0 (_data_->adapters);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_g_object_unref0 (_data_->adapter);
		}
	}
	_g_object_unref0 (_data_->adapters);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
bluetooth_services_object_manager_stop_discovery_data_free (gpointer _data)
{
	BluetoothServicesObjectManagerStopDiscoveryData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (BluetoothServicesObjectManagerStopDiscoveryData, _data_);
}

void
bluetooth_services_object_manager_stop_discovery (BluetoothServicesObjectManager* self,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_)
{
	BluetoothServicesObjectManagerStopDiscoveryData* _data_;
	BluetoothServicesObjectManager* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (BluetoothServicesObjectManagerStopDiscoveryData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, bluetooth_services_object_manager_stop_discovery_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	bluetooth_services_object_manager_stop_discovery_co (_data_);
}

void
bluetooth_services_object_manager_stop_discovery_finish (BluetoothServicesObjectManager* self,
                                                         GAsyncResult* _res_)
{
	BluetoothServicesObjectManagerStopDiscoveryData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
bluetooth_services_object_manager_stop_discovery_ready (GObject* source_object,
                                                        GAsyncResult* _res_,
                                                        gpointer _user_data_)
{
	BluetoothServicesObjectManagerStopDiscoveryData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	bluetooth_services_object_manager_stop_discovery_co (_data_);
}

static gboolean
bluetooth_services_object_manager_stop_discovery_co (BluetoothServicesObjectManagerStopDiscoveryData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = bluetooth_services_object_manager_get_adapters (_data_->self);
	_data_->adapters = _data_->_tmp0_;
	bluetooth_services_object_manager_set_is_discovering (_data_->self, FALSE);
	{
		_data_->_tmp1_ = _data_->adapters;
		_data_->_adapter_list = _data_->_tmp1_;
		_data_->_tmp2_ = _data_->_adapter_list;
		_data_->_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp2_);
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_adapter_size = _data_->_tmp4_;
		_data_->_adapter_index = -1;
		while (TRUE) {
			_data_->_adapter_index = _data_->_adapter_index + 1;
			_data_->_tmp5_ = _data_->_adapter_index;
			_data_->_tmp6_ = _data_->_adapter_size;
			if (!(_data_->_tmp5_ < _data_->_tmp6_)) {
				break;
			}
			_data_->_tmp7_ = _data_->_adapter_list;
			_data_->_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp7_, _data_->_adapter_index);
			_data_->adapter = (BluetoothServicesAdapter*) _data_->_tmp8_;
			{
				_data_->_tmp10_ = _data_->adapter;
				_data_->_tmp11_ = bluetooth_services_adapter_get_powered (_data_->_tmp10_);
				_data_->_tmp12_ = _data_->_tmp11_;
				if (_data_->_tmp12_) {
					_data_->_tmp13_ = _data_->adapter;
					_data_->_tmp14_ = bluetooth_services_adapter_get_discovering (_data_->_tmp13_);
					_data_->_tmp15_ = _data_->_tmp14_;
					_data_->_tmp9_ = _data_->_tmp15_;
				} else {
					_data_->_tmp9_ = FALSE;
				}
				if (_data_->_tmp9_) {
					_data_->_tmp16_ = _data_->adapter;
					_data_->_state_ = 1;
					bluetooth_services_adapter_stop_discovery (_data_->_tmp16_, bluetooth_services_object_manager_stop_discovery_ready, _data_);
					return FALSE;
					_state_1:
					bluetooth_services_adapter_stop_discovery_finish (_data_->_tmp16_, _data_->_res_, &_data_->_inner_error0_);
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
					_data_->_tmp17_ = _data_->adapter;
					_data_->_tmp18_ = bluetooth_services_adapter_get_name (_data_->_tmp17_);
					_data_->_tmp19_ = _data_->_tmp18_;
					_data_->_tmp20_ = _data_->_tmp19_;
					g_debug ("Manager.vala:346: Adapter %s stopped", _data_->_tmp20_);
					_g_free0 (_data_->_tmp20_);
				}
			}
			goto __finally0;
			__catch0_g_error:
			{
				_data_->e = _data_->_inner_error0_;
				_data_->_inner_error0_ = NULL;
				_data_->_tmp21_ = _data_->e;
				_data_->_tmp22_ = _data_->_tmp21_->message;
				g_critical ("Manager.vala:349: %s", _data_->_tmp22_);
				_g_error_free0 (_data_->e);
			}
			__finally0:
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_object_unref0 (_data_->adapter);
				_g_object_unref0 (_data_->adapters);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_g_object_unref0 (_data_->adapter);
		}
	}
	_g_object_unref0 (_data_->adapters);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

gboolean
bluetooth_services_object_manager_get_connected (BluetoothServicesObjectManager* self)
{
	GeeCollection* devices = NULL;
	GeeCollection* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = bluetooth_services_object_manager_get_devices (self);
	devices = _tmp0_;
	{
		GeeIterator* _device_it = NULL;
		GeeCollection* _tmp1_;
		GeeIterator* _tmp2_;
		_tmp1_ = devices;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
		_device_it = _tmp2_;
		while (TRUE) {
			GeeIterator* _tmp3_;
			BluetoothServicesDevice* device = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			BluetoothServicesDevice* _tmp6_;
			gboolean _tmp7_;
			gboolean _tmp8_;
			_tmp3_ = _device_it;
			if (!gee_iterator_next (_tmp3_)) {
				break;
			}
			_tmp4_ = _device_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			device = (BluetoothServicesDevice*) _tmp5_;
			_tmp6_ = device;
			_tmp7_ = bluetooth_services_device_get_connected (_tmp6_);
			_tmp8_ = _tmp7_;
			if (_tmp8_) {
				result = TRUE;
				_g_object_unref0 (device);
				_g_object_unref0 (_device_it);
				_g_object_unref0 (devices);
				return result;
			}
			_g_object_unref0 (device);
		}
		_g_object_unref0 (_device_it);
	}
	result = FALSE;
	_g_object_unref0 (devices);
	return result;
}

gboolean
bluetooth_services_object_manager_get_global_state (BluetoothServicesObjectManager* self)
{
	GeeLinkedList* adapters = NULL;
	GeeLinkedList* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = bluetooth_services_object_manager_get_adapters (self);
	adapters = _tmp0_;
	{
		GeeLinkedList* _adapter_list = NULL;
		GeeLinkedList* _tmp1_;
		gint _adapter_size = 0;
		GeeLinkedList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _adapter_index = 0;
		_tmp1_ = adapters;
		_adapter_list = _tmp1_;
		_tmp2_ = _adapter_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_adapter_size = _tmp4_;
		_adapter_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			BluetoothServicesAdapter* adapter = NULL;
			GeeLinkedList* _tmp7_;
			gpointer _tmp8_;
			BluetoothServicesAdapter* _tmp9_;
			gboolean _tmp10_;
			gboolean _tmp11_;
			_adapter_index = _adapter_index + 1;
			_tmp5_ = _adapter_index;
			_tmp6_ = _adapter_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _adapter_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _adapter_index);
			adapter = (BluetoothServicesAdapter*) _tmp8_;
			_tmp9_ = adapter;
			_tmp10_ = bluetooth_services_adapter_get_powered (_tmp9_);
			_tmp11_ = _tmp10_;
			if (_tmp11_) {
				result = TRUE;
				_g_object_unref0 (adapter);
				_g_object_unref0 (adapters);
				return result;
			}
			_g_object_unref0 (adapter);
		}
	}
	result = FALSE;
	_g_object_unref0 (adapters);
	return result;
}

static void
bluetooth_services_object_manager_set_global_state_data_free (gpointer _data)
{
	BluetoothServicesObjectManagerSetGlobalStateData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (BluetoothServicesObjectManagerSetGlobalStateData, _data_);
}

void
bluetooth_services_object_manager_set_global_state (BluetoothServicesObjectManager* self,
                                                    gboolean state,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_)
{
	BluetoothServicesObjectManagerSetGlobalStateData* _data_;
	BluetoothServicesObjectManager* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (BluetoothServicesObjectManagerSetGlobalStateData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, bluetooth_services_object_manager_set_global_state_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->state = state;
	bluetooth_services_object_manager_set_global_state_co (_data_);
}

void
bluetooth_services_object_manager_set_global_state_finish (BluetoothServicesObjectManager* self,
                                                           GAsyncResult* _res_)
{
	BluetoothServicesObjectManagerSetGlobalStateData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
bluetooth_services_object_manager_set_global_state_ready (GObject* source_object,
                                                          GAsyncResult* _res_,
                                                          gpointer _user_data_)
{
	BluetoothServicesObjectManagerSetGlobalStateData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	bluetooth_services_object_manager_set_global_state_co (_data_);
}

static gboolean
bluetooth_services_object_manager_set_global_state_co (BluetoothServicesObjectManagerSetGlobalStateData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp2_ = _data_->self->priv->_is_powered;
	if (_data_->state == _data_->_tmp2_) {
		_data_->_tmp3_ = _data_->self->priv->_discoverable;
		_data_->_tmp1_ = _data_->_tmp3_ == _data_->state;
	} else {
		_data_->_tmp1_ = FALSE;
	}
	if (_data_->_tmp1_) {
		_data_->_tmp4_ = _data_->self->priv->_is_discovering;
		_data_->_tmp0_ = _data_->_tmp4_ == _data_->state;
	} else {
		_data_->_tmp0_ = FALSE;
	}
	if (_data_->_tmp0_) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	bluetooth_services_object_manager_set_discoverable (_data_->self, _data_->state);
	bluetooth_services_object_manager_set_is_powered (_data_->self, _data_->state);
	if (!_data_->state) {
		_data_->_state_ = 1;
		bluetooth_services_object_manager_stop_discovery (_data_->self, bluetooth_services_object_manager_set_global_state_ready, _data_);
		return FALSE;
		_state_1:
		bluetooth_services_object_manager_stop_discovery_finish (_data_->self, _data_->_res_);
	}
	_data_->_tmp5_ = bluetooth_services_object_manager_get_adapters (_data_->self);
	_data_->adapters = _data_->_tmp5_;
	{
		_data_->_tmp6_ = _data_->adapters;
		_data_->_adapter_list = _data_->_tmp6_;
		_data_->_tmp7_ = _data_->_adapter_list;
		_data_->_tmp8_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp7_);
		_data_->_tmp9_ = _data_->_tmp8_;
		_data_->_adapter_size = _data_->_tmp9_;
		_data_->_adapter_index = -1;
		while (TRUE) {
			_data_->_adapter_index = _data_->_adapter_index + 1;
			_data_->_tmp10_ = _data_->_adapter_index;
			_data_->_tmp11_ = _data_->_adapter_size;
			if (!(_data_->_tmp10_ < _data_->_tmp11_)) {
				break;
			}
			_data_->_tmp12_ = _data_->_adapter_list;
			_data_->_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp12_, _data_->_adapter_index);
			_data_->adapter = (BluetoothServicesAdapter*) _data_->_tmp13_;
			_data_->_tmp14_ = _data_->adapter;
			bluetooth_services_adapter_set_powered (_data_->_tmp14_, _data_->state);
			_data_->_tmp15_ = _data_->adapter;
			bluetooth_services_adapter_set_discoverable (_data_->_tmp15_, _data_->state);
			_g_object_unref0 (_data_->adapter);
		}
	}
	_data_->_tmp16_ = _data_->self->priv->settings;
	if (_data_->_tmp16_ != NULL) {
		_data_->_tmp17_ = _data_->self->priv->settings;
		_data_->_tmp18_ = _data_->self->priv->enabled_key;
		g_settings_set_boolean (_data_->_tmp17_, _data_->_tmp18_, _data_->state);
	}
	if (!_data_->state) {
		_data_->_tmp19_ = bluetooth_services_object_manager_get_devices (_data_->self);
		_data_->devices = _data_->_tmp19_;
		{
			_data_->_tmp20_ = _data_->devices;
			_data_->_tmp21_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp20_);
			_data_->_device_it = _data_->_tmp21_;
			while (TRUE) {
				_data_->_tmp22_ = _data_->_device_it;
				if (!gee_iterator_next (_data_->_tmp22_)) {
					break;
				}
				_data_->_tmp23_ = _data_->_device_it;
				_data_->_tmp24_ = gee_iterator_get (_data_->_tmp23_);
				_data_->device = (BluetoothServicesDevice*) _data_->_tmp24_;
				_data_->_tmp25_ = _data_->device;
				_data_->_tmp26_ = bluetooth_services_device_get_connected (_data_->_tmp25_);
				_data_->_tmp27_ = _data_->_tmp26_;
				if (_data_->_tmp27_) {
					{
						_data_->_tmp28_ = _data_->device;
						_data_->_state_ = 2;
						bluetooth_services_device_disconnect (_data_->_tmp28_, bluetooth_services_object_manager_set_global_state_ready, _data_);
						return FALSE;
						_state_2:
						bluetooth_services_device_disconnect_finish (_data_->_tmp28_, _data_->_res_, &_data_->_inner_error0_);
						if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
							goto __catch0_g_error;
						}
					}
					goto __finally0;
					__catch0_g_error:
					{
						_data_->e = _data_->_inner_error0_;
						_data_->_inner_error0_ = NULL;
						_data_->_tmp29_ = _data_->e;
						_data_->_tmp30_ = _data_->_tmp29_->message;
						g_critical ("Manager.vala:406: %s", _data_->_tmp30_);
						_g_error_free0 (_data_->e);
					}
					__finally0:
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						_g_object_unref0 (_data_->device);
						_g_object_unref0 (_data_->_device_it);
						_g_object_unref0 (_data_->devices);
						_g_object_unref0 (_data_->adapters);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
						g_clear_error (&_data_->_inner_error0_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
				}
				_g_object_unref0 (_data_->device);
			}
			_g_object_unref0 (_data_->_device_it);
		}
		_g_object_unref0 (_data_->devices);
	} else {
		bluetooth_services_object_manager_start_discovery (_data_->self, NULL, NULL);
	}
	_g_object_unref0 (_data_->adapters);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

gboolean
bluetooth_services_object_manager_get_discoverable (BluetoothServicesObjectManager* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_discoverable;
	return result;
}

void
bluetooth_services_object_manager_set_discoverable (BluetoothServicesObjectManager* self,
                                                    gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = bluetooth_services_object_manager_get_discoverable (self);
	if (old_value != value) {
		self->priv->_discoverable = value;
		g_object_notify_by_pspec ((GObject *) self, bluetooth_services_object_manager_properties[BLUETOOTH_SERVICES_OBJECT_MANAGER_DISCOVERABLE_PROPERTY]);
	}
}

gboolean
bluetooth_services_object_manager_get_has_object (BluetoothServicesObjectManager* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_object;
	return result;
}

static void
bluetooth_services_object_manager_set_has_object (BluetoothServicesObjectManager* self,
                                                  gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = bluetooth_services_object_manager_get_has_object (self);
	if (old_value != value) {
		self->priv->_has_object = value;
		g_object_notify_by_pspec ((GObject *) self, bluetooth_services_object_manager_properties[BLUETOOTH_SERVICES_OBJECT_MANAGER_HAS_OBJECT_PROPERTY]);
	}
}

gboolean
bluetooth_services_object_manager_get_retrieve_finished (BluetoothServicesObjectManager* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_retrieve_finished;
	return result;
}

static void
bluetooth_services_object_manager_set_retrieve_finished (BluetoothServicesObjectManager* self,
                                                         gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = bluetooth_services_object_manager_get_retrieve_finished (self);
	if (old_value != value) {
		self->priv->_retrieve_finished = value;
		g_object_notify_by_pspec ((GObject *) self, bluetooth_services_object_manager_properties[BLUETOOTH_SERVICES_OBJECT_MANAGER_RETRIEVE_FINISHED_PROPERTY]);
	}
}

gboolean
bluetooth_services_object_manager_get_is_discovering (BluetoothServicesObjectManager* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_discovering;
	return result;
}

static void
bluetooth_services_object_manager_set_is_discovering (BluetoothServicesObjectManager* self,
                                                      gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = bluetooth_services_object_manager_get_is_discovering (self);
	if (old_value != value) {
		self->priv->_is_discovering = value;
		g_object_notify_by_pspec ((GObject *) self, bluetooth_services_object_manager_properties[BLUETOOTH_SERVICES_OBJECT_MANAGER_IS_DISCOVERING_PROPERTY]);
	}
}

gboolean
bluetooth_services_object_manager_get_is_powered (BluetoothServicesObjectManager* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_powered;
	return result;
}

static void
bluetooth_services_object_manager_set_is_powered (BluetoothServicesObjectManager* self,
                                                  gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = bluetooth_services_object_manager_get_is_powered (self);
	if (old_value != value) {
		self->priv->_is_powered = value;
		g_object_notify_by_pspec ((GObject *) self, bluetooth_services_object_manager_properties[BLUETOOTH_SERVICES_OBJECT_MANAGER_IS_POWERED_PROPERTY]);
	}
}

gboolean
bluetooth_services_object_manager_get_is_connected (BluetoothServicesObjectManager* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_connected;
	return result;
}

static void
bluetooth_services_object_manager_set_is_connected (BluetoothServicesObjectManager* self,
                                                    gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = bluetooth_services_object_manager_get_is_connected (self);
	if (old_value != value) {
		self->priv->_is_connected = value;
		g_object_notify_by_pspec ((GObject *) self, bluetooth_services_object_manager_properties[BLUETOOTH_SERVICES_OBJECT_MANAGER_IS_CONNECTED_PROPERTY]);
	}
}

static gboolean
__lambda24_ (BluetoothServicesObjectManager* self,
             BluetoothServicesAdapter* adapter)
{
	gboolean _tmp0_;
	gboolean result;
	g_return_val_if_fail (adapter != NULL, FALSE);
	_tmp0_ = self->priv->_discoverable;
	bluetooth_services_adapter_set_discoverable (adapter, _tmp0_);
	result = _tmp0_;
	_g_object_unref0 (adapter);
	return result;
}

static gboolean
___lambda24__gee_forall_func (gpointer g,
                              gpointer self)
{
	gboolean result;
	result = __lambda24_ ((BluetoothServicesObjectManager*) self, (BluetoothServicesAdapter*) g);
	return result;
}

static void
_bluetooth_services_object_manager___lambda23_ (BluetoothServicesObjectManager* self)
{
	GeeLinkedList* _tmp0_;
	GeeLinkedList* _tmp1_;
	_tmp0_ = bluetooth_services_object_manager_get_adapters (self);
	_tmp1_ = _tmp0_;
	gee_abstract_collection_foreach ((GeeAbstractCollection*) _tmp1_, ___lambda24__gee_forall_func, self);
	_g_object_unref0 (_tmp1_);
}

static void
__bluetooth_services_object_manager___lambda23__g_object_notify (GObject* _sender,
                                                                 GParamSpec* pspec,
                                                                 gpointer self)
{
	_bluetooth_services_object_manager___lambda23_ ((BluetoothServicesObjectManager*) self);
}

static GObject *
bluetooth_services_object_manager_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	BluetoothServicesObjectManager * self;
	GSettingsSchema* settings_schema = NULL;
	GSettingsSchemaSource* _tmp0_;
	GSettingsSchema* _tmp1_;
	GSettingsSchema* _tmp2_;
	parent_class = G_OBJECT_CLASS (bluetooth_services_object_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BLUETOOTH_SERVICES_TYPE_OBJECT_MANAGER, BluetoothServicesObjectManager);
	_tmp0_ = g_settings_schema_source_get_default ();
	_tmp1_ = g_settings_schema_source_lookup (_tmp0_, BLUETOOTH_SERVICES_OBJECT_MANAGER_DAEMON_SCHEMA, TRUE);
	settings_schema = _tmp1_;
	_tmp2_ = settings_schema;
	if (_tmp2_ != NULL) {
		GSettings* _tmp3_;
		_tmp3_ = g_settings_new (BLUETOOTH_SERVICES_OBJECT_MANAGER_DAEMON_SCHEMA);
		_g_object_unref0 (self->priv->settings);
		self->priv->settings = _tmp3_;
	} else {
		GSettingsSchemaSource* _tmp4_;
		GSettingsSchema* _tmp5_;
		GSettingsSchema* _tmp6_;
		_tmp4_ = g_settings_schema_source_get_default ();
		_tmp5_ = g_settings_schema_source_lookup (_tmp4_, BLUETOOTH_SERVICES_OBJECT_MANAGER_PANEL_SCHEMA, TRUE);
		_g_settings_schema_unref0 (settings_schema);
		settings_schema = _tmp5_;
		_tmp6_ = settings_schema;
		if (_tmp6_ != NULL) {
			GSettings* _tmp7_;
			gchar* _tmp8_;
			_tmp7_ = g_settings_new (BLUETOOTH_SERVICES_OBJECT_MANAGER_PANEL_SCHEMA);
			_g_object_unref0 (self->priv->settings);
			self->priv->settings = _tmp7_;
			_tmp8_ = g_strdup ("bluetooth-enabled");
			_g_free0 (self->priv->enabled_key);
			self->priv->enabled_key = _tmp8_;
		}
	}
	bluetooth_services_object_manager_create_manager (self, NULL, NULL);
	g_signal_connect_object ((GObject*) self, "notify::discoverable", (GCallback) __bluetooth_services_object_manager___lambda23__g_object_notify, self, 0);
	_g_settings_schema_unref0 (settings_schema);
	return obj;
}

static void
bluetooth_services_object_manager_class_init (BluetoothServicesObjectManagerClass * klass,
                                              gpointer klass_data)
{
	bluetooth_services_object_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BluetoothServicesObjectManager_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_bluetooth_services_object_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_bluetooth_services_object_manager_set_property;
	G_OBJECT_CLASS (klass)->constructor = bluetooth_services_object_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = bluetooth_services_object_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BLUETOOTH_SERVICES_OBJECT_MANAGER_DISCOVERABLE_PROPERTY, bluetooth_services_object_manager_properties[BLUETOOTH_SERVICES_OBJECT_MANAGER_DISCOVERABLE_PROPERTY] = g_param_spec_boolean ("discoverable", "discoverable", "discoverable", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BLUETOOTH_SERVICES_OBJECT_MANAGER_HAS_OBJECT_PROPERTY, bluetooth_services_object_manager_properties[BLUETOOTH_SERVICES_OBJECT_MANAGER_HAS_OBJECT_PROPERTY] = g_param_spec_boolean ("has-object", "has-object", "has-object", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BLUETOOTH_SERVICES_OBJECT_MANAGER_RETRIEVE_FINISHED_PROPERTY, bluetooth_services_object_manager_properties[BLUETOOTH_SERVICES_OBJECT_MANAGER_RETRIEVE_FINISHED_PROPERTY] = g_param_spec_boolean ("retrieve-finished", "retrieve-finished", "retrieve-finished", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BLUETOOTH_SERVICES_OBJECT_MANAGER_IS_DISCOVERING_PROPERTY, bluetooth_services_object_manager_properties[BLUETOOTH_SERVICES_OBJECT_MANAGER_IS_DISCOVERING_PROPERTY] = g_param_spec_boolean ("is-discovering", "is-discovering", "is-discovering", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BLUETOOTH_SERVICES_OBJECT_MANAGER_IS_POWERED_PROPERTY, bluetooth_services_object_manager_properties[BLUETOOTH_SERVICES_OBJECT_MANAGER_IS_POWERED_PROPERTY] = g_param_spec_boolean ("is-powered", "is-powered", "is-powered", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BLUETOOTH_SERVICES_OBJECT_MANAGER_IS_CONNECTED_PROPERTY, bluetooth_services_object_manager_properties[BLUETOOTH_SERVICES_OBJECT_MANAGER_IS_CONNECTED_PROPERTY] = g_param_spec_boolean ("is-connected", "is-connected", "is-connected", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	bluetooth_services_object_manager_signals[BLUETOOTH_SERVICES_OBJECT_MANAGER_ADAPTER_ADDED_SIGNAL] = g_signal_new ("adapter-added", BLUETOOTH_SERVICES_TYPE_OBJECT_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, BLUETOOTH_SERVICES_TYPE_ADAPTER);
	bluetooth_services_object_manager_signals[BLUETOOTH_SERVICES_OBJECT_MANAGER_ADAPTER_REMOVED_SIGNAL] = g_signal_new ("adapter-removed", BLUETOOTH_SERVICES_TYPE_OBJECT_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, BLUETOOTH_SERVICES_TYPE_ADAPTER);
	bluetooth_services_object_manager_signals[BLUETOOTH_SERVICES_OBJECT_MANAGER_DEVICE_ADDED_SIGNAL] = g_signal_new ("device-added", BLUETOOTH_SERVICES_TYPE_OBJECT_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, BLUETOOTH_SERVICES_TYPE_DEVICE);
	bluetooth_services_object_manager_signals[BLUETOOTH_SERVICES_OBJECT_MANAGER_DEVICE_REMOVED_SIGNAL] = g_signal_new ("device-removed", BLUETOOTH_SERVICES_TYPE_OBJECT_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, BLUETOOTH_SERVICES_TYPE_DEVICE);
}

static void
bluetooth_services_object_manager_instance_init (BluetoothServicesObjectManager * self,
                                                 gpointer klass)
{
	gchar* _tmp0_;
	self->priv = bluetooth_services_object_manager_get_instance_private (self);
	self->priv->_discoverable = FALSE;
	self->priv->_has_object = FALSE;
	self->priv->_retrieve_finished = FALSE;
	self->priv->_is_discovering = FALSE;
	self->priv->_is_powered = FALSE;
	self->priv->_is_connected = FALSE;
	self->priv->is_registered = FALSE;
	_tmp0_ = g_strdup ("enabled");
	self->priv->enabled_key = _tmp0_;
	self->priv->settings = NULL;
}

static void
bluetooth_services_object_manager_finalize (GObject * obj)
{
	BluetoothServicesObjectManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BLUETOOTH_SERVICES_TYPE_OBJECT_MANAGER, BluetoothServicesObjectManager);
	_g_free0 (self->priv->enabled_key);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->object_manager);
	_g_object_unref0 (self->priv->agent_manager);
	_g_object_unref0 (self->priv->agent);
	G_OBJECT_CLASS (bluetooth_services_object_manager_parent_class)->finalize (obj);
}

static GType
bluetooth_services_object_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BluetoothServicesObjectManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bluetooth_services_object_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BluetoothServicesObjectManager), 0, (GInstanceInitFunc) bluetooth_services_object_manager_instance_init, NULL };
	GType bluetooth_services_object_manager_type_id;
	bluetooth_services_object_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "BluetoothServicesObjectManager", &g_define_type_info, 0);
	BluetoothServicesObjectManager_private_offset = g_type_add_instance_private (bluetooth_services_object_manager_type_id, sizeof (BluetoothServicesObjectManagerPrivate));
	return bluetooth_services_object_manager_type_id;
}

GType
bluetooth_services_object_manager_get_type (void)
{
	static volatile gsize bluetooth_services_object_manager_type_id__once = 0;
	if (g_once_init_enter (&bluetooth_services_object_manager_type_id__once)) {
		GType bluetooth_services_object_manager_type_id;
		bluetooth_services_object_manager_type_id = bluetooth_services_object_manager_get_type_once ();
		g_once_init_leave (&bluetooth_services_object_manager_type_id__once, bluetooth_services_object_manager_type_id);
	}
	return bluetooth_services_object_manager_type_id__once;
}

static void
_vala_bluetooth_services_object_manager_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec)
{
	BluetoothServicesObjectManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BLUETOOTH_SERVICES_TYPE_OBJECT_MANAGER, BluetoothServicesObjectManager);
	switch (property_id) {
		case BLUETOOTH_SERVICES_OBJECT_MANAGER_DISCOVERABLE_PROPERTY:
		g_value_set_boolean (value, bluetooth_services_object_manager_get_discoverable (self));
		break;
		case BLUETOOTH_SERVICES_OBJECT_MANAGER_HAS_OBJECT_PROPERTY:
		g_value_set_boolean (value, bluetooth_services_object_manager_get_has_object (self));
		break;
		case BLUETOOTH_SERVICES_OBJECT_MANAGER_RETRIEVE_FINISHED_PROPERTY:
		g_value_set_boolean (value, bluetooth_services_object_manager_get_retrieve_finished (self));
		break;
		case BLUETOOTH_SERVICES_OBJECT_MANAGER_IS_DISCOVERING_PROPERTY:
		g_value_set_boolean (value, bluetooth_services_object_manager_get_is_discovering (self));
		break;
		case BLUETOOTH_SERVICES_OBJECT_MANAGER_IS_POWERED_PROPERTY:
		g_value_set_boolean (value, bluetooth_services_object_manager_get_is_powered (self));
		break;
		case BLUETOOTH_SERVICES_OBJECT_MANAGER_IS_CONNECTED_PROPERTY:
		g_value_set_boolean (value, bluetooth_services_object_manager_get_is_connected (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_bluetooth_services_object_manager_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec)
{
	BluetoothServicesObjectManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BLUETOOTH_SERVICES_TYPE_OBJECT_MANAGER, BluetoothServicesObjectManager);
	switch (property_id) {
		case BLUETOOTH_SERVICES_OBJECT_MANAGER_DISCOVERABLE_PROPERTY:
		bluetooth_services_object_manager_set_discoverable (self, g_value_get_boolean (value));
		break;
		case BLUETOOTH_SERVICES_OBJECT_MANAGER_HAS_OBJECT_PROPERTY:
		bluetooth_services_object_manager_set_has_object (self, g_value_get_boolean (value));
		break;
		case BLUETOOTH_SERVICES_OBJECT_MANAGER_RETRIEVE_FINISHED_PROPERTY:
		bluetooth_services_object_manager_set_retrieve_finished (self, g_value_get_boolean (value));
		break;
		case BLUETOOTH_SERVICES_OBJECT_MANAGER_IS_DISCOVERING_PROPERTY:
		bluetooth_services_object_manager_set_is_discovering (self, g_value_get_boolean (value));
		break;
		case BLUETOOTH_SERVICES_OBJECT_MANAGER_IS_POWERED_PROPERTY:
		bluetooth_services_object_manager_set_is_powered (self, g_value_get_boolean (value));
		break;
		case BLUETOOTH_SERVICES_OBJECT_MANAGER_IS_CONNECTED_PROPERTY:
		bluetooth_services_object_manager_set_is_connected (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

