/* DownloadService.c generated by valac 0.56.17, the Vala compiler
 * generated from DownloadService.vala, do not modify */

/*
    DownloadService.vala
    Copyright (C) 2010 Maia Kozheva <sikon@ubuntu.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <stdio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define STEADYFLOW_CORE_TYPE_IDOWNLOAD_SERVICE (steadyflow_core_idownload_service_get_type ())
#define STEADYFLOW_CORE_IDOWNLOAD_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), STEADYFLOW_CORE_TYPE_IDOWNLOAD_SERVICE, SteadyflowCoreIDownloadService))
#define STEADYFLOW_CORE_IS_IDOWNLOAD_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), STEADYFLOW_CORE_TYPE_IDOWNLOAD_SERVICE))
#define STEADYFLOW_CORE_IDOWNLOAD_SERVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), STEADYFLOW_CORE_TYPE_IDOWNLOAD_SERVICE, SteadyflowCoreIDownloadServiceIface))

typedef struct _SteadyflowCoreIDownloadService SteadyflowCoreIDownloadService;
typedef struct _SteadyflowCoreIDownloadServiceIface SteadyflowCoreIDownloadServiceIface;

#define STEADYFLOW_CORE_TYPE_IDOWNLOAD_FILE (steadyflow_core_idownload_file_get_type ())
#define STEADYFLOW_CORE_IDOWNLOAD_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), STEADYFLOW_CORE_TYPE_IDOWNLOAD_FILE, SteadyflowCoreIDownloadFile))
#define STEADYFLOW_CORE_IS_IDOWNLOAD_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), STEADYFLOW_CORE_TYPE_IDOWNLOAD_FILE))
#define STEADYFLOW_CORE_IDOWNLOAD_FILE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), STEADYFLOW_CORE_TYPE_IDOWNLOAD_FILE, SteadyflowCoreIDownloadFileIface))

typedef struct _SteadyflowCoreIDownloadFile SteadyflowCoreIDownloadFile;
typedef struct _SteadyflowCoreIDownloadFileIface SteadyflowCoreIDownloadFileIface;
typedef enum  {
	STEADYFLOW_CORE_IDOWNLOAD_FILE_STATUS_CONNECTING = 0,
	STEADYFLOW_CORE_IDOWNLOAD_FILE_STATUS_DOWNLOADING,
	STEADYFLOW_CORE_IDOWNLOAD_FILE_STATUS_PAUSED,
	STEADYFLOW_CORE_IDOWNLOAD_FILE_STATUS_FINISHED,
	STEADYFLOW_CORE_IDOWNLOAD_FILE_STATUS_NETWORK_ERROR
} SteadyflowCoreIDownloadFileStatus;

#define STEADYFLOW_CORE_IDOWNLOAD_FILE_TYPE_STATUS (steadyflow_core_idownload_file_status_get_type ())
typedef enum  {
	STEADYFLOW_CORE_IDOWNLOAD_FILE_FINISH_ACTION_DO_NOTHING = 0,
	STEADYFLOW_CORE_IDOWNLOAD_FILE_FINISH_ACTION_OPEN_FILE,
	STEADYFLOW_CORE_IDOWNLOAD_FILE_FINISH_ACTION_OPEN_FOLDER,
	STEADYFLOW_CORE_IDOWNLOAD_FILE_FINISH_ACTION_RUN_COMMAND
} SteadyflowCoreIDownloadFileFinishAction;

#define STEADYFLOW_CORE_IDOWNLOAD_FILE_TYPE_FINISH_ACTION (steadyflow_core_idownload_file_finish_action_get_type ())

#define STEADYFLOW_CORE_TYPE_DOWNLOAD_SERVICE (steadyflow_core_download_service_get_type ())
#define STEADYFLOW_CORE_DOWNLOAD_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), STEADYFLOW_CORE_TYPE_DOWNLOAD_SERVICE, SteadyflowCoreDownloadService))
#define STEADYFLOW_CORE_DOWNLOAD_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), STEADYFLOW_CORE_TYPE_DOWNLOAD_SERVICE, SteadyflowCoreDownloadServiceClass))
#define STEADYFLOW_CORE_IS_DOWNLOAD_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), STEADYFLOW_CORE_TYPE_DOWNLOAD_SERVICE))
#define STEADYFLOW_CORE_IS_DOWNLOAD_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), STEADYFLOW_CORE_TYPE_DOWNLOAD_SERVICE))
#define STEADYFLOW_CORE_DOWNLOAD_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), STEADYFLOW_CORE_TYPE_DOWNLOAD_SERVICE, SteadyflowCoreDownloadServiceClass))

typedef struct _SteadyflowCoreDownloadService SteadyflowCoreDownloadService;
typedef struct _SteadyflowCoreDownloadServiceClass SteadyflowCoreDownloadServiceClass;
typedef struct _SteadyflowCoreDownloadServicePrivate SteadyflowCoreDownloadServicePrivate;
enum  {
	STEADYFLOW_CORE_DOWNLOAD_SERVICE_0_PROPERTY,
	STEADYFLOW_CORE_DOWNLOAD_SERVICE_FILES_PROPERTY,
	STEADYFLOW_CORE_DOWNLOAD_SERVICE_NUM_PROPERTIES
};
static GParamSpec* steadyflow_core_download_service_properties[STEADYFLOW_CORE_DOWNLOAD_SERVICE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define STEADYFLOW_CORE_TYPE_GIO_DOWNLOAD_FILE (steadyflow_core_gio_download_file_get_type ())
#define STEADYFLOW_CORE_GIO_DOWNLOAD_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), STEADYFLOW_CORE_TYPE_GIO_DOWNLOAD_FILE, SteadyflowCoreGioDownloadFile))
#define STEADYFLOW_CORE_GIO_DOWNLOAD_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), STEADYFLOW_CORE_TYPE_GIO_DOWNLOAD_FILE, SteadyflowCoreGioDownloadFileClass))
#define STEADYFLOW_CORE_IS_GIO_DOWNLOAD_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), STEADYFLOW_CORE_TYPE_GIO_DOWNLOAD_FILE))
#define STEADYFLOW_CORE_IS_GIO_DOWNLOAD_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), STEADYFLOW_CORE_TYPE_GIO_DOWNLOAD_FILE))
#define STEADYFLOW_CORE_GIO_DOWNLOAD_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), STEADYFLOW_CORE_TYPE_GIO_DOWNLOAD_FILE, SteadyflowCoreGioDownloadFileClass))

typedef struct _SteadyflowCoreGioDownloadFile SteadyflowCoreGioDownloadFile;
typedef struct _SteadyflowCoreGioDownloadFileClass SteadyflowCoreGioDownloadFileClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))

struct _SteadyflowCoreIDownloadFileIface {
	GTypeInterface parent_iface;
	void (*start) (SteadyflowCoreIDownloadFile* self, gboolean resume);
	void (*pause) (SteadyflowCoreIDownloadFile* self);
	void (*serialize) (SteadyflowCoreIDownloadFile* self, GKeyFile* file);
	SteadyflowCoreIDownloadFileStatus (*get_status) (SteadyflowCoreIDownloadFile* self);
	gint (*get_uid) (SteadyflowCoreIDownloadFile* self);
	const gchar* (*get_url) (SteadyflowCoreIDownloadFile* self);
	const gchar* (*get_local_name) (SteadyflowCoreIDownloadFile* self);
	const gchar* (*get_local_basename) (SteadyflowCoreIDownloadFile* self);
	gint64 (*get_size) (SteadyflowCoreIDownloadFile* self);
	gint64 (*get_downloaded_size) (SteadyflowCoreIDownloadFile* self);
	gint (*get_speed) (SteadyflowCoreIDownloadFile* self);
	const gchar* (*get_icon_name) (SteadyflowCoreIDownloadFile* self);
	SteadyflowCoreIDownloadFileFinishAction (*get_finish_action) (SteadyflowCoreIDownloadFile* self);
	const gchar* (*get_finish_command) (SteadyflowCoreIDownloadFile* self);
	GError* (*get_error) (SteadyflowCoreIDownloadFile* self);
};

struct _SteadyflowCoreIDownloadServiceIface {
	GTypeInterface parent_iface;
	SteadyflowCoreIDownloadFile* (*get_file_by_uid) (SteadyflowCoreIDownloadService* self, gint uid);
	SteadyflowCoreIDownloadFile* (*add_file) (SteadyflowCoreIDownloadService* self, const gchar* url, const gchar* local_name, SteadyflowCoreIDownloadFileFinishAction finish_action, const gchar* finish_command, GError** error);
	void (*remove_file) (SteadyflowCoreIDownloadService* self, SteadyflowCoreIDownloadFile* file);
	GeeList* (*get_files) (SteadyflowCoreIDownloadService* self);
};

struct _SteadyflowCoreDownloadService {
	GObject parent_instance;
	SteadyflowCoreDownloadServicePrivate * priv;
};

struct _SteadyflowCoreDownloadServiceClass {
	GObjectClass parent_class;
};

struct _SteadyflowCoreDownloadServicePrivate {
	GeeList* _files;
	gint last_uid;
};

static gint SteadyflowCoreDownloadService_private_offset;
static gpointer steadyflow_core_download_service_parent_class = NULL;
static SteadyflowCoreIDownloadServiceIface * steadyflow_core_download_service_steadyflow_core_idownload_service_parent_iface = NULL;

VALA_EXTERN GType steadyflow_core_idownload_file_status_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType steadyflow_core_idownload_file_finish_action_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType steadyflow_core_idownload_file_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SteadyflowCoreIDownloadFile, g_object_unref)
VALA_EXTERN GType steadyflow_core_idownload_service_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SteadyflowCoreIDownloadService, g_object_unref)
VALA_EXTERN GType steadyflow_core_download_service_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SteadyflowCoreDownloadService, g_object_unref)
static void steadyflow_core_download_service_save_state (SteadyflowCoreDownloadService* self);
VALA_EXTERN SteadyflowCoreDownloadService* steadyflow_core_download_service_new (void);
VALA_EXTERN SteadyflowCoreDownloadService* steadyflow_core_download_service_construct (GType object_type);
static void steadyflow_core_download_service_load_state (SteadyflowCoreDownloadService* self);
static SteadyflowCoreIDownloadFile* steadyflow_core_download_service_real_get_file_by_uid (SteadyflowCoreIDownloadService* base,
                                                                                    gint uid);
VALA_EXTERN GeeList* steadyflow_core_idownload_service_get_files (SteadyflowCoreIDownloadService* self);
VALA_EXTERN gint steadyflow_core_idownload_file_get_uid (SteadyflowCoreIDownloadFile* self);
static SteadyflowCoreIDownloadFile* steadyflow_core_download_service_real_add_file (SteadyflowCoreIDownloadService* base,
                                                                             const gchar* url,
                                                                             const gchar* local_name,
                                                                             SteadyflowCoreIDownloadFileFinishAction finish_action,
                                                                             const gchar* finish_command,
                                                                             GError** error);
VALA_EXTERN SteadyflowCoreGioDownloadFile* steadyflow_core_gio_download_file_new (const gchar* url,
                                                                      const gchar* local_name,
                                                                      gint uid,
                                                                      SteadyflowCoreIDownloadFileFinishAction finish_action,
                                                                      const gchar* finish_command);
VALA_EXTERN SteadyflowCoreGioDownloadFile* steadyflow_core_gio_download_file_construct (GType object_type,
                                                                            const gchar* url,
                                                                            const gchar* local_name,
                                                                            gint uid,
                                                                            SteadyflowCoreIDownloadFileFinishAction finish_action,
                                                                            const gchar* finish_command);
VALA_EXTERN GType steadyflow_core_gio_download_file_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SteadyflowCoreGioDownloadFile, g_object_unref)
VALA_EXTERN void steadyflow_core_idownload_file_start (SteadyflowCoreIDownloadFile* self,
                                           gboolean resume);
static void __lambda5_ (SteadyflowCoreDownloadService* self,
                 SteadyflowCoreIDownloadFileStatus status);
static void ___lambda5__steadyflow_core_idownload_file_status_changed (SteadyflowCoreIDownloadFile* _sender,
                                                                SteadyflowCoreIDownloadFileStatus old_status,
                                                                gpointer self);
static void steadyflow_core_download_service_real_remove_file (SteadyflowCoreIDownloadService* base,
                                                        SteadyflowCoreIDownloadFile* file);
static GFile* steadyflow_core_download_service_get_state_file (SteadyflowCoreDownloadService* self);
VALA_EXTERN void steadyflow_core_util_fatal_error (GError* e,
                                       const gchar* message);
VALA_EXTERN SteadyflowCoreIDownloadFile* steadyflow_core_gio_download_file_deserialize (GKeyFile* keys,
                                                                            gint uid,
                                                                            gboolean* should_start,
                                                                            GError** error);
static void _____lambda4_ (SteadyflowCoreDownloadService* self,
                    SteadyflowCoreIDownloadFileStatus status);
static void ______lambda4__steadyflow_core_idownload_file_status_changed (SteadyflowCoreIDownloadFile* _sender,
                                                                   SteadyflowCoreIDownloadFileStatus old_status,
                                                                   gpointer self);
VALA_EXTERN void steadyflow_core_idownload_file_serialize (SteadyflowCoreIDownloadFile* self,
                                               GKeyFile* file);
VALA_EXTERN SteadyflowCoreIDownloadFile* steadyflow_core_idownload_service_get_file_by_uid (SteadyflowCoreIDownloadService* self,
                                                                                gint uid);
VALA_EXTERN SteadyflowCoreIDownloadFile* steadyflow_core_idownload_service_add_file (SteadyflowCoreIDownloadService* self,
                                                                         const gchar* url,
                                                                         const gchar* local_name,
                                                                         SteadyflowCoreIDownloadFileFinishAction finish_action,
                                                                         const gchar* finish_command,
                                                                         GError** error);
VALA_EXTERN void steadyflow_core_idownload_service_remove_file (SteadyflowCoreIDownloadService* self,
                                                    SteadyflowCoreIDownloadFile* file);
static void steadyflow_core_download_service_finalize (GObject * obj);
static GType steadyflow_core_download_service_get_type_once (void);
static void _vala_steadyflow_core_download_service_get_property (GObject * object,
                                                          guint property_id,
                                                          GValue * value,
                                                          GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
steadyflow_core_download_service_get_instance_private (SteadyflowCoreDownloadService* self)
{
	return G_STRUCT_MEMBER_P (self, SteadyflowCoreDownloadService_private_offset);
}

SteadyflowCoreDownloadService*
steadyflow_core_download_service_construct (GType object_type)
{
	SteadyflowCoreDownloadService * self = NULL;
	GeeArrayList* _tmp0_;
	self = (SteadyflowCoreDownloadService*) g_object_new (object_type, NULL);
	_tmp0_ = gee_array_list_new (STEADYFLOW_CORE_TYPE_IDOWNLOAD_FILE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_files);
	self->priv->_files = (GeeList*) _tmp0_;
	self->priv->last_uid = 0;
	steadyflow_core_download_service_load_state (self);
	return self;
}

SteadyflowCoreDownloadService*
steadyflow_core_download_service_new (void)
{
	return steadyflow_core_download_service_construct (STEADYFLOW_CORE_TYPE_DOWNLOAD_SERVICE);
}

static SteadyflowCoreIDownloadFile*
steadyflow_core_download_service_real_get_file_by_uid (SteadyflowCoreIDownloadService* base,
                                                       gint uid)
{
	SteadyflowCoreDownloadService * self;
	SteadyflowCoreIDownloadFile* result;
	self = (SteadyflowCoreDownloadService*) base;
	{
		GeeList* _file_list = NULL;
		GeeList* _tmp0_;
		GeeList* _tmp1_;
		gint _file_size = 0;
		GeeList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _file_index = 0;
		_tmp0_ = steadyflow_core_idownload_service_get_files ((SteadyflowCoreIDownloadService*) self);
		_tmp1_ = _tmp0_;
		_file_list = _tmp1_;
		_tmp2_ = _file_list;
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_file_size = _tmp4_;
		_file_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			SteadyflowCoreIDownloadFile* file = NULL;
			GeeList* _tmp7_;
			gpointer _tmp8_;
			SteadyflowCoreIDownloadFile* _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			_file_index = _file_index + 1;
			_tmp5_ = _file_index;
			_tmp6_ = _file_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _file_list;
			_tmp8_ = gee_list_get (_tmp7_, _file_index);
			file = (SteadyflowCoreIDownloadFile*) _tmp8_;
			_tmp9_ = file;
			_tmp10_ = steadyflow_core_idownload_file_get_uid (_tmp9_);
			_tmp11_ = _tmp10_;
			if (_tmp11_ == uid) {
				result = file;
				_g_object_unref0 (_file_list);
				return result;
			}
			_g_object_unref0 (file);
		}
		_g_object_unref0 (_file_list);
	}
	result = NULL;
	return result;
}

static void
__lambda5_ (SteadyflowCoreDownloadService* self,
            SteadyflowCoreIDownloadFileStatus status)
{
	steadyflow_core_download_service_save_state (self);
}

static void
___lambda5__steadyflow_core_idownload_file_status_changed (SteadyflowCoreIDownloadFile* _sender,
                                                           SteadyflowCoreIDownloadFileStatus old_status,
                                                           gpointer self)
{
	__lambda5_ ((SteadyflowCoreDownloadService*) self, old_status);
}

static SteadyflowCoreIDownloadFile*
steadyflow_core_download_service_real_add_file (SteadyflowCoreIDownloadService* base,
                                                const gchar* url,
                                                const gchar* local_name,
                                                SteadyflowCoreIDownloadFileFinishAction finish_action,
                                                const gchar* finish_command,
                                                GError** error)
{
	SteadyflowCoreDownloadService * self;
	SteadyflowCoreIDownloadFile* file = NULL;
	SteadyflowCoreGioDownloadFile* _tmp0_;
	gint _tmp1_;
	GeeList* _tmp2_;
	SteadyflowCoreIDownloadFile* result;
	self = (SteadyflowCoreDownloadService*) base;
	g_return_val_if_fail (url != NULL, NULL);
	g_return_val_if_fail (local_name != NULL, NULL);
	_tmp0_ = steadyflow_core_gio_download_file_new (url, local_name, self->priv->last_uid, finish_action, finish_command);
	file = (SteadyflowCoreIDownloadFile*) _tmp0_;
	_tmp1_ = self->priv->last_uid;
	self->priv->last_uid = _tmp1_ + 1;
	steadyflow_core_idownload_file_start (file, FALSE);
	_tmp2_ = self->priv->_files;
	gee_collection_add ((GeeCollection*) _tmp2_, file);
	g_signal_emit_by_name ((SteadyflowCoreIDownloadService*) self, "file-added", file);
	g_signal_connect_object (file, "status-changed", (GCallback) ___lambda5__steadyflow_core_idownload_file_status_changed, self, 0);
	result = file;
	return result;
}

static void
steadyflow_core_download_service_real_remove_file (SteadyflowCoreIDownloadService* base,
                                                   SteadyflowCoreIDownloadFile* file)
{
	SteadyflowCoreDownloadService * self;
	GeeList* _tmp0_;
	self = (SteadyflowCoreDownloadService*) base;
	g_return_if_fail (file != NULL);
	_tmp0_ = self->priv->_files;
	gee_collection_remove ((GeeCollection*) _tmp0_, file);
	steadyflow_core_download_service_save_state (self);
	g_signal_emit_by_name ((SteadyflowCoreIDownloadService*) self, "file-removed", file);
}

static GFile*
steadyflow_core_download_service_get_state_file (SteadyflowCoreDownloadService* self)
{
	gchar* config_dir = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GFile* subdir = NULL;
	const gchar* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp11_;
	GFile* _tmp12_;
	GError* _inner_error0_ = NULL;
	GFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_get_user_data_dir ();
	_tmp1_ = g_strdup (_tmp0_);
	config_dir = _tmp1_;
	_tmp2_ = config_dir;
	_tmp3_ = g_file_new_for_path (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_file_get_child (_tmp4_, "steadyflow");
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp4_);
	subdir = _tmp6_;
	{
		GFile* _tmp7_;
		_tmp7_ = subdir;
		if (!g_file_query_exists (_tmp7_, NULL)) {
			GFile* _tmp8_;
			_tmp8_ = subdir;
			g_file_make_directory_with_parents (_tmp8_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		} else {
			GFile* _tmp9_;
			_tmp9_ = subdir;
			if (g_file_query_file_type (_tmp9_, G_FILE_QUERY_INFO_NONE, NULL) != G_FILE_TYPE_DIRECTORY) {
				GError* _tmp10_;
				_tmp10_ = g_error_new_literal (G_FILE_ERROR, G_FILE_ERROR_NOTDIR, _ ("Cannot create settings directory - a non-directory with that name alre" \
"ady exists"));
				_inner_error0_ = _tmp10_;
				goto __catch0_g_error;
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		steadyflow_core_util_fatal_error (e, NULL);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (subdir);
		_g_free0 (config_dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp11_ = subdir;
	_tmp12_ = g_file_get_child (_tmp11_, "downloads.ini");
	result = _tmp12_;
	_g_object_unref0 (subdir);
	_g_free0 (config_dir);
	return result;
}

static void
_____lambda4_ (SteadyflowCoreDownloadService* self,
               SteadyflowCoreIDownloadFileStatus status)
{
	steadyflow_core_download_service_save_state (self);
}

static void
______lambda4__steadyflow_core_idownload_file_status_changed (SteadyflowCoreIDownloadFile* _sender,
                                                              SteadyflowCoreIDownloadFileStatus old_status,
                                                              gpointer self)
{
	_____lambda4_ ((SteadyflowCoreDownloadService*) self, old_status);
}

static void
steadyflow_core_download_service_load_state (SteadyflowCoreDownloadService* self)
{
	GKeyFile* keys = NULL;
	GKeyFile* _tmp0_;
	gint max_uid = 0;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_key_file_new ();
	keys = _tmp0_;
	max_uid = 0;
	{
		GKeyFile* _tmp1_;
		GFile* _tmp2_;
		GFile* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		GKeyFile* _tmp6_;
		gsize _tmp7_ = 0;
		gchar** _tmp8_;
		_tmp1_ = keys;
		_tmp2_ = steadyflow_core_download_service_get_state_file (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_file_get_path (_tmp3_);
		_tmp5_ = _tmp4_;
		g_key_file_load_from_file (_tmp1_, _tmp5_, G_KEY_FILE_NONE, &_inner_error0_);
		_g_free0 (_tmp5_);
		_g_object_unref0 (_tmp3_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp6_ = keys;
		_tmp8_ = g_key_file_get_groups (_tmp6_, &_tmp7_);
		{
			gchar** group_collection = NULL;
			gint group_collection_length1 = 0;
			gint _group_collection_size_ = 0;
			gint group_it = 0;
			group_collection = _tmp8_;
			group_collection_length1 = _tmp7_;
			for (group_it = 0; group_it < group_collection_length1; group_it = group_it + 1) {
				gchar* _tmp9_;
				gchar* group = NULL;
				_tmp9_ = g_strdup (group_collection[group_it]);
				group = _tmp9_;
				{
					const gchar* _tmp10_;
					gboolean should_start = FALSE;
					gint uid = 0;
					const gchar* _tmp11_;
					SteadyflowCoreIDownloadFile* file = NULL;
					GKeyFile* _tmp12_;
					gboolean _tmp13_ = FALSE;
					SteadyflowCoreIDownloadFile* _tmp14_;
					GeeList* _tmp15_;
					SteadyflowCoreIDownloadFile* _tmp16_;
					SteadyflowCoreIDownloadFile* _tmp17_;
					_tmp10_ = group;
					if (g_strcmp0 (_tmp10_, "ROOT") == 0) {
						_g_free0 (group);
						continue;
					}
					should_start = FALSE;
					_tmp11_ = group;
					uid = atoi (_tmp11_);
					_tmp12_ = keys;
					_tmp14_ = steadyflow_core_gio_download_file_deserialize (_tmp12_, uid, &_tmp13_, &_inner_error0_);
					should_start = _tmp13_;
					file = _tmp14_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_free0 (group);
						group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
						goto __catch0_g_error;
					}
					if (uid > max_uid) {
						max_uid = uid;
					}
					_tmp15_ = self->priv->_files;
					_tmp16_ = file;
					gee_collection_add ((GeeCollection*) _tmp15_, _tmp16_);
					_tmp17_ = file;
					g_signal_connect_object (_tmp17_, "status-changed", (GCallback) ______lambda4__steadyflow_core_idownload_file_status_changed, self, 0);
					if (should_start) {
						SteadyflowCoreIDownloadFile* _tmp18_;
						_tmp18_ = file;
						steadyflow_core_idownload_file_start (_tmp18_, TRUE);
					}
					_g_object_unref0 (file);
					_g_free0 (group);
				}
			}
			group_collection = (_vala_array_free (group_collection, group_collection_length1, (GDestroyNotify) g_free), NULL);
		}
		self->priv->last_uid = max_uid + 1;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_key_file_unref0 (keys);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_key_file_unref0 (keys);
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static void
steadyflow_core_download_service_save_state (SteadyflowCoreDownloadService* self)
{
	GKeyFile* keys = NULL;
	GKeyFile* _tmp0_;
	gchar* file_contents = NULL;
	GKeyFile* _tmp12_;
	gchar* _tmp13_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_key_file_new ();
	keys = _tmp0_;
	{
		GeeList* _file_list = NULL;
		GeeList* _tmp1_;
		GeeList* _tmp2_;
		gint _file_size = 0;
		GeeList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _file_index = 0;
		_tmp1_ = steadyflow_core_idownload_service_get_files ((SteadyflowCoreIDownloadService*) self);
		_tmp2_ = _tmp1_;
		_file_list = _tmp2_;
		_tmp3_ = _file_list;
		_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_file_size = _tmp5_;
		_file_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			SteadyflowCoreIDownloadFile* file = NULL;
			GeeList* _tmp8_;
			gpointer _tmp9_;
			SteadyflowCoreIDownloadFile* _tmp10_;
			GKeyFile* _tmp11_;
			_file_index = _file_index + 1;
			_tmp6_ = _file_index;
			_tmp7_ = _file_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _file_list;
			_tmp9_ = gee_list_get (_tmp8_, _file_index);
			file = (SteadyflowCoreIDownloadFile*) _tmp9_;
			_tmp10_ = file;
			_tmp11_ = keys;
			steadyflow_core_idownload_file_serialize (_tmp10_, _tmp11_);
			_g_object_unref0 (file);
		}
		_g_object_unref0 (_file_list);
	}
	_tmp12_ = keys;
	_tmp13_ = g_key_file_to_data (_tmp12_, NULL, NULL);
	file_contents = _tmp13_;
	{
		GFile* _tmp14_;
		GFile* _tmp15_;
		guint8* _tmp16_;
		gint _tmp16__length1;
		gint _tmp17_ = 0;
		guint8* _tmp18_;
		gint _tmp18__length1;
		_tmp14_ = steadyflow_core_download_service_get_state_file (self);
		_tmp15_ = _tmp14_;
		_tmp16_ = string_get_data (file_contents, &_tmp17_);
		_tmp16__length1 = _tmp17_;
		_tmp18_ = _tmp16_;
		_tmp18__length1 = _tmp16__length1;
		g_file_replace_contents (_tmp15_, (const char*) _tmp18_, (gsize) _tmp18__length1, NULL, FALSE, G_FILE_CREATE_NONE, NULL, NULL, &_inner_error0_);
		_g_object_unref0 (_tmp15_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		FILE* _tmp19_;
		g_clear_error (&_inner_error0_);
		_tmp19_ = stderr;
		fprintf (_tmp19_, "Cannot save downloads state");
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (file_contents);
		_g_key_file_unref0 (keys);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (file_contents);
	_g_key_file_unref0 (keys);
}

static GeeList*
steadyflow_core_download_service_real_get_files (SteadyflowCoreIDownloadService* base)
{
	GeeList* result;
	SteadyflowCoreDownloadService* self;
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	GeeList* _tmp2_;
	self = (SteadyflowCoreDownloadService*) base;
	_tmp0_ = self->priv->_files;
	_tmp1_ = gee_list_get_read_only_view (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static void
steadyflow_core_download_service_class_init (SteadyflowCoreDownloadServiceClass * klass,
                                             gpointer klass_data)
{
	steadyflow_core_download_service_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SteadyflowCoreDownloadService_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_steadyflow_core_download_service_get_property;
	G_OBJECT_CLASS (klass)->finalize = steadyflow_core_download_service_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), STEADYFLOW_CORE_DOWNLOAD_SERVICE_FILES_PROPERTY, steadyflow_core_download_service_properties[STEADYFLOW_CORE_DOWNLOAD_SERVICE_FILES_PROPERTY] = g_param_spec_object ("files", "files", "files", GEE_TYPE_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
steadyflow_core_download_service_steadyflow_core_idownload_service_interface_init (SteadyflowCoreIDownloadServiceIface * iface,
                                                                                   gpointer iface_data)
{
	steadyflow_core_download_service_steadyflow_core_idownload_service_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_file_by_uid = (SteadyflowCoreIDownloadFile* (*) (SteadyflowCoreIDownloadService*, gint)) steadyflow_core_download_service_real_get_file_by_uid;
	iface->add_file = (SteadyflowCoreIDownloadFile* (*) (SteadyflowCoreIDownloadService*, const gchar*, const gchar*, SteadyflowCoreIDownloadFileFinishAction, const gchar*, GError**)) steadyflow_core_download_service_real_add_file;
	iface->remove_file = (void (*) (SteadyflowCoreIDownloadService*, SteadyflowCoreIDownloadFile*)) steadyflow_core_download_service_real_remove_file;
	iface->get_files = steadyflow_core_download_service_real_get_files;
}

static void
steadyflow_core_download_service_instance_init (SteadyflowCoreDownloadService * self,
                                                gpointer klass)
{
	self->priv = steadyflow_core_download_service_get_instance_private (self);
}

static void
steadyflow_core_download_service_finalize (GObject * obj)
{
	SteadyflowCoreDownloadService * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, STEADYFLOW_CORE_TYPE_DOWNLOAD_SERVICE, SteadyflowCoreDownloadService);
	steadyflow_core_download_service_save_state (self);
	_g_object_unref0 (self->priv->_files);
	G_OBJECT_CLASS (steadyflow_core_download_service_parent_class)->finalize (obj);
}

static GType
steadyflow_core_download_service_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SteadyflowCoreDownloadServiceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) steadyflow_core_download_service_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SteadyflowCoreDownloadService), 0, (GInstanceInitFunc) steadyflow_core_download_service_instance_init, NULL };
	static const GInterfaceInfo steadyflow_core_idownload_service_info = { (GInterfaceInitFunc) steadyflow_core_download_service_steadyflow_core_idownload_service_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType steadyflow_core_download_service_type_id;
	steadyflow_core_download_service_type_id = g_type_register_static (G_TYPE_OBJECT, "SteadyflowCoreDownloadService", &g_define_type_info, 0);
	g_type_add_interface_static (steadyflow_core_download_service_type_id, STEADYFLOW_CORE_TYPE_IDOWNLOAD_SERVICE, &steadyflow_core_idownload_service_info);
	SteadyflowCoreDownloadService_private_offset = g_type_add_instance_private (steadyflow_core_download_service_type_id, sizeof (SteadyflowCoreDownloadServicePrivate));
	return steadyflow_core_download_service_type_id;
}

GType
steadyflow_core_download_service_get_type (void)
{
	static volatile gsize steadyflow_core_download_service_type_id__once = 0;
	if (g_once_init_enter (&steadyflow_core_download_service_type_id__once)) {
		GType steadyflow_core_download_service_type_id;
		steadyflow_core_download_service_type_id = steadyflow_core_download_service_get_type_once ();
		g_once_init_leave (&steadyflow_core_download_service_type_id__once, steadyflow_core_download_service_type_id);
	}
	return steadyflow_core_download_service_type_id__once;
}

static void
_vala_steadyflow_core_download_service_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec)
{
	SteadyflowCoreDownloadService * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, STEADYFLOW_CORE_TYPE_DOWNLOAD_SERVICE, SteadyflowCoreDownloadService);
	switch (property_id) {
		case STEADYFLOW_CORE_DOWNLOAD_SERVICE_FILES_PROPERTY:
		g_value_take_object (value, steadyflow_core_idownload_service_get_files ((SteadyflowCoreIDownloadService*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

