// This file is generated by kconfig_compiler_kf6 from spectacle.kcfg.
// All changes you do to this file will be lost.
#ifndef SETTINGS_H
#define SETTINGS_H

#include <kconfigskeleton.h>
#include <QCoreApplication>
#include <QDebug>
#include <qqmlintegration.h>

#include <QStandardPaths>
#include <CaptureModeModel.h>
#include <Platforms/VideoPlatform.h>
#include <Gui/SettingsDialog/SettingsUtils.h>
#include <KLocalizedString>

class QQmlEngine;
class QJSEngine;

class Settings : public KConfigSkeleton
{
  Q_OBJECT
  QML_ELEMENT
  QML_SINGLETON
  public:
    enum EnumLaunchAction { TakeRectangularScreenshot, TakeFullscreenScreenshot, UseLastUsedCapturemode, DoNotTakeScreenshot };
    Q_ENUM(EnumLaunchAction)
    enum EnumPrintKeyRunningAction { TakeNewScreenshot, StartNewInstance, FocusWindow };
    Q_ENUM(EnumPrintKeyRunningAction)
    enum EnumClipboardGroup { PostScreenshotDoNothing, PostScreenshotCopyImage, PostScreenshotCopyLocation };
    Q_ENUM(EnumClipboardGroup)
    enum EnumShowMagnifier { ShowMagnifierNever, ShowMagnifierAlways, ShowMagnifierShiftHeld };
    Q_ENUM(EnumShowMagnifier)
    enum EnumRememberSelectionRect { Never, Always, UntilClosed };
    Q_ENUM(EnumRememberSelectionRect)

    static Settings *self();
    static Settings *create(QQmlEngine *, QJSEngine *);
    ~Settings() override;

    /**
      Set What to do when Spectacle is launched
    */
    static
    void setLaunchAction( int v )
    {
      if (v != self()->mLaunchAction && !self()->isLaunchActionImmutable()) {
        self()->mLaunchAction = v;
        Q_EMIT self()->launchActionChanged();
      }
    }

    Q_PROPERTY(int launchAction READ launchAction WRITE setLaunchAction NOTIFY launchActionChanged)
    Q_PROPERTY(bool isLaunchActionImmutable READ isLaunchActionImmutable CONSTANT)
    Q_PROPERTY(int defaultLaunchActionValue READ defaultLaunchActionValue CONSTANT)
    /**
      Get What to do when Spectacle is launched
    */
    static
    int launchAction()
    {
      return self()->mLaunchAction;
    }

    /**
      Is What to do when Spectacle is launched Immutable
    */
    static
    bool isLaunchActionImmutable()
    {
      return self()->isImmutable( QStringLiteral( "launchAction" ) );
    }

    /**
      Get What to do when Spectacle is launched default value
    */
    static
    int defaultLaunchActionValue()
    {
        return defaultLaunchActionValue_helper();
    }

    /**
      Set What should happen if print key is pressed when Spectacle is already running
    */
    static
    void setPrintKeyRunningAction( int v )
    {
      if (v != self()->mPrintKeyRunningAction && !self()->isPrintKeyRunningActionImmutable()) {
        self()->mPrintKeyRunningAction = v;
        Q_EMIT self()->printKeyRunningActionChanged();
      }
    }

    Q_PROPERTY(int printKeyRunningAction READ printKeyRunningAction WRITE setPrintKeyRunningAction NOTIFY printKeyRunningActionChanged)
    Q_PROPERTY(bool isPrintKeyRunningActionImmutable READ isPrintKeyRunningActionImmutable CONSTANT)
    Q_PROPERTY(int defaultPrintKeyRunningActionValue READ defaultPrintKeyRunningActionValue CONSTANT)
    /**
      Get What should happen if print key is pressed when Spectacle is already running
    */
    static
    int printKeyRunningAction()
    {
      return self()->mPrintKeyRunningAction;
    }

    /**
      Is What should happen if print key is pressed when Spectacle is already running Immutable
    */
    static
    bool isPrintKeyRunningActionImmutable()
    {
      return self()->isImmutable( QStringLiteral( "printKeyRunningAction" ) );
    }

    /**
      Get What should happen if print key is pressed when Spectacle is already running default value
    */
    static
    int defaultPrintKeyRunningActionValue()
    {
        return defaultPrintKeyRunningActionValue_helper();
    }

    /**
      Set Save screenshot automatically after it is taken
    */
    static
    void setAutoSaveImage( bool v )
    {
      if (v != self()->mAutoSaveImage && !self()->isAutoSaveImageImmutable()) {
        self()->mAutoSaveImage = v;
        Q_EMIT self()->autoSaveImageChanged();
      }
    }

    Q_PROPERTY(bool autoSaveImage READ autoSaveImage WRITE setAutoSaveImage NOTIFY autoSaveImageChanged)
    Q_PROPERTY(bool isAutoSaveImageImmutable READ isAutoSaveImageImmutable CONSTANT)
    Q_PROPERTY(bool defaultAutoSaveImageValue READ defaultAutoSaveImageValue CONSTANT)
    /**
      Get Save screenshot automatically after it is taken
    */
    static
    bool autoSaveImage()
    {
      return self()->mAutoSaveImage;
    }

    /**
      Is Save screenshot automatically after it is taken Immutable
    */
    static
    bool isAutoSaveImageImmutable()
    {
      return self()->isImmutable( QStringLiteral( "autoSaveImage" ) );
    }

    /**
      Get Save screenshot automatically after it is taken default value
    */
    static
    bool defaultAutoSaveImageValue()
    {
        return defaultAutoSaveImageValue_helper();
    }

    /**
      Set Close after extraction (skips auto-save)
    */
    static
    void setCloseAfterOcr( bool v )
    {
      if (v != self()->mCloseAfterOcr && !self()->isCloseAfterOcrImmutable()) {
        self()->mCloseAfterOcr = v;
        Q_EMIT self()->closeAfterOcrChanged();
      }
    }

    Q_PROPERTY(bool closeAfterOcr READ closeAfterOcr WRITE setCloseAfterOcr NOTIFY closeAfterOcrChanged)
    Q_PROPERTY(bool isCloseAfterOcrImmutable READ isCloseAfterOcrImmutable CONSTANT)
    Q_PROPERTY(bool defaultCloseAfterOcrValue READ defaultCloseAfterOcrValue CONSTANT)
    /**
      Get Close after extraction (skips auto-save)
    */
    static
    bool closeAfterOcr()
    {
      return self()->mCloseAfterOcr;
    }

    /**
      Is Close after extraction (skips auto-save) Immutable
    */
    static
    bool isCloseAfterOcrImmutable()
    {
      return self()->isImmutable( QStringLiteral( "closeAfterOcr" ) );
    }

    /**
      Get Close after extraction (skips auto-save) default value
    */
    static
    bool defaultCloseAfterOcrValue()
    {
        return defaultCloseAfterOcrValue_helper();
    }

    /**
      Set Clipboard action which should be executed after the screenshot is taken
    */
    static
    void setClipboardGroup( int v )
    {
      if (v != self()->mClipboardGroup && !self()->isClipboardGroupImmutable()) {
        self()->mClipboardGroup = v;
        Q_EMIT self()->clipboardGroupChanged();
      }
    }

    Q_PROPERTY(int clipboardGroup READ clipboardGroup WRITE setClipboardGroup NOTIFY clipboardGroupChanged)
    Q_PROPERTY(bool isClipboardGroupImmutable READ isClipboardGroupImmutable CONSTANT)
    Q_PROPERTY(int defaultClipboardGroupValue READ defaultClipboardGroupValue CONSTANT)
    /**
      Get Clipboard action which should be executed after the screenshot is taken
    */
    static
    int clipboardGroup()
    {
      return self()->mClipboardGroup;
    }

    /**
      Is Clipboard action which should be executed after the screenshot is taken Immutable
    */
    static
    bool isClipboardGroupImmutable()
    {
      return self()->isImmutable( QStringLiteral( "clipboardGroup" ) );
    }

    /**
      Get Clipboard action which should be executed after the screenshot is taken default value
    */
    static
    int defaultClipboardGroupValue()
    {
        return defaultClipboardGroupValue_helper();
    }

    /**
      Set Whether to use a light color mask in the region selection dialog
    */
    static
    void setUseLightMaskColor( bool v )
    {
      if (v != self()->mUseLightMaskColor && !self()->isUseLightMaskColorImmutable()) {
        self()->mUseLightMaskColor = v;
        Q_EMIT self()->useLightMaskColorChanged();
      }
    }

    Q_PROPERTY(bool useLightMaskColor READ useLightMaskColor WRITE setUseLightMaskColor NOTIFY useLightMaskColorChanged)
    Q_PROPERTY(bool isUseLightMaskColorImmutable READ isUseLightMaskColorImmutable CONSTANT)
    Q_PROPERTY(bool defaultUseLightMaskColorValue READ defaultUseLightMaskColorValue CONSTANT)
    /**
      Get Whether to use a light color mask in the region selection dialog
    */
    static
    bool useLightMaskColor()
    {
      return self()->mUseLightMaskColor;
    }

    /**
      Is Whether to use a light color mask in the region selection dialog Immutable
    */
    static
    bool isUseLightMaskColorImmutable()
    {
      return self()->isImmutable( QStringLiteral( "useLightMaskColor" ) );
    }

    /**
      Get Whether to use a light color mask in the region selection dialog default value
    */
    static
    bool defaultUseLightMaskColorValue()
    {
        return defaultUseLightMaskColorValue_helper();
    }

    /**
      Set Clipboard action which should be executed after the screenshot is taken
    */
    static
    void setShowMagnifier( int v )
    {
      if (v != self()->mShowMagnifier && !self()->isShowMagnifierImmutable()) {
        self()->mShowMagnifier = v;
        Q_EMIT self()->showMagnifierChanged();
      }
    }

    Q_PROPERTY(int showMagnifier READ showMagnifier WRITE setShowMagnifier NOTIFY showMagnifierChanged)
    Q_PROPERTY(bool isShowMagnifierImmutable READ isShowMagnifierImmutable CONSTANT)
    Q_PROPERTY(int defaultShowMagnifierValue READ defaultShowMagnifierValue CONSTANT)
    /**
      Get Clipboard action which should be executed after the screenshot is taken
    */
    static
    int showMagnifier()
    {
      return self()->mShowMagnifier;
    }

    /**
      Is Clipboard action which should be executed after the screenshot is taken Immutable
    */
    static
    bool isShowMagnifierImmutable()
    {
      return self()->isImmutable( QStringLiteral( "showMagnifier" ) );
    }

    /**
      Get Clipboard action which should be executed after the screenshot is taken default value
    */
    static
    int defaultShowMagnifierValue()
    {
        return defaultShowMagnifierValue_helper();
    }

    /**
      Set Whether the screenshot should be captured after selecting the region and releasing the mouse
    */
    static
    void setUseReleaseToCapture( bool v )
    {
      if (v != self()->mUseReleaseToCapture && !self()->isUseReleaseToCaptureImmutable()) {
        self()->mUseReleaseToCapture = v;
        Q_EMIT self()->useReleaseToCaptureChanged();
      }
    }

    Q_PROPERTY(bool useReleaseToCapture READ useReleaseToCapture WRITE setUseReleaseToCapture NOTIFY useReleaseToCaptureChanged)
    Q_PROPERTY(bool isUseReleaseToCaptureImmutable READ isUseReleaseToCaptureImmutable CONSTANT)
    Q_PROPERTY(bool defaultUseReleaseToCaptureValue READ defaultUseReleaseToCaptureValue CONSTANT)
    /**
      Get Whether the screenshot should be captured after selecting the region and releasing the mouse
    */
    static
    bool useReleaseToCapture()
    {
      return self()->mUseReleaseToCapture;
    }

    /**
      Is Whether the screenshot should be captured after selecting the region and releasing the mouse Immutable
    */
    static
    bool isUseReleaseToCaptureImmutable()
    {
      return self()->isImmutable( QStringLiteral( "useReleaseToCapture" ) );
    }

    /**
      Get Whether the screenshot should be captured after selecting the region and releasing the mouse default value
    */
    static
    bool defaultUseReleaseToCaptureValue()
    {
        return defaultUseReleaseToCaptureValue_helper();
    }

    /**
      Set Remember the last rectangular region
    */
    static
    void setRememberSelectionRect( int v )
    {
      if (v != self()->mRememberSelectionRect && !self()->isRememberSelectionRectImmutable()) {
        self()->mRememberSelectionRect = v;
        Q_EMIT self()->rememberSelectionRectChanged();
      }
    }

    Q_PROPERTY(int rememberSelectionRect READ rememberSelectionRect WRITE setRememberSelectionRect NOTIFY rememberSelectionRectChanged)
    Q_PROPERTY(bool isRememberSelectionRectImmutable READ isRememberSelectionRectImmutable CONSTANT)
    Q_PROPERTY(int defaultRememberSelectionRectValue READ defaultRememberSelectionRectValue CONSTANT)
    /**
      Get Remember the last rectangular region
    */
    static
    int rememberSelectionRect()
    {
      return self()->mRememberSelectionRect;
    }

    /**
      Is Remember the last rectangular region Immutable
    */
    static
    bool isRememberSelectionRectImmutable()
    {
      return self()->isImmutable( QStringLiteral( "rememberSelectionRect" ) );
    }

    /**
      Get Remember the last rectangular region default value
    */
    static
    int defaultRememberSelectionRectValue()
    {
        return defaultRememberSelectionRectValue_helper();
    }

    /**
      Set Default languages for OCR text recognition
    */
    static
    void setOcrLanguages( const QStringList & v )
    {
      if (v != self()->mOcrLanguages && !self()->isOcrLanguagesImmutable()) {
        self()->mOcrLanguages = v;
        Q_EMIT self()->ocrLanguagesChanged();
      }
    }

    Q_PROPERTY(QStringList ocrLanguages READ ocrLanguages WRITE setOcrLanguages NOTIFY ocrLanguagesChanged)
    Q_PROPERTY(bool isOcrLanguagesImmutable READ isOcrLanguagesImmutable CONSTANT)
    Q_PROPERTY(QStringList defaultOcrLanguagesValue READ defaultOcrLanguagesValue CONSTANT)
    /**
      Get Default languages for OCR text recognition
    */
    static
    QStringList ocrLanguages()
    {
      return self()->mOcrLanguages;
    }

    /**
      Is Default languages for OCR text recognition Immutable
    */
    static
    bool isOcrLanguagesImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ocrLanguages" ) );
    }

    /**
      Get Default languages for OCR text recognition default value
    */
    static
    QStringList defaultOcrLanguagesValue()
    {
        return defaultOcrLanguagesValue_helper();
    }

    /**
      Set The last used region the user selected
    */
    static
    void setSelectionRect( const QRectF & v )
    {
      if (v != self()->mSelectionRect && !self()->isSelectionRectImmutable()) {
        self()->mSelectionRect = v;
        Q_EMIT self()->selectionRectChanged();
      }
    }

    Q_PROPERTY(QRectF selectionRect READ selectionRect WRITE setSelectionRect NOTIFY selectionRectChanged)
    Q_PROPERTY(bool isSelectionRectImmutable READ isSelectionRectImmutable CONSTANT)
    Q_PROPERTY(QRectF defaultSelectionRectValue READ defaultSelectionRectValue CONSTANT)
    /**
      Get The last used region the user selected
    */
    static
    QRectF selectionRect()
    {
      return self()->mSelectionRect;
    }

    /**
      Is The last used region the user selected Immutable
    */
    static
    bool isSelectionRectImmutable()
    {
      return self()->isImmutable( QStringLiteral( "selectionRect" ) );
    }

    /**
      Get The last used region the user selected default value
    */
    static
    QRectF defaultSelectionRectValue()
    {
        return defaultSelectionRectValue_helper();
    }

    /**
      Set Take screenshot on click
    */
    static
    void setCaptureOnClick( bool v )
    {
      if (v != self()->mCaptureOnClick && !self()->isCaptureOnClickImmutable()) {
        self()->mCaptureOnClick = v;
        Q_EMIT self()->captureOnClickChanged();
      }
    }

    Q_PROPERTY(bool captureOnClick READ captureOnClick WRITE setCaptureOnClick NOTIFY captureOnClickChanged)
    Q_PROPERTY(bool isCaptureOnClickImmutable READ isCaptureOnClickImmutable CONSTANT)
    Q_PROPERTY(bool defaultCaptureOnClickValue READ defaultCaptureOnClickValue CONSTANT)
    /**
      Get Take screenshot on click
    */
    static
    bool captureOnClick()
    {
      return self()->mCaptureOnClick;
    }

    /**
      Is Take screenshot on click Immutable
    */
    static
    bool isCaptureOnClickImmutable()
    {
      return self()->isImmutable( QStringLiteral( "captureOnClick" ) );
    }

    /**
      Get Take screenshot on click default value
    */
    static
    bool defaultCaptureOnClickValue()
    {
        return defaultCaptureOnClickValue_helper();
    }

    /**
      Set Whether the mouse cursor is included in the screenshot
    */
    static
    void setIncludePointer( bool v )
    {
      if (v != self()->mIncludePointer && !self()->isIncludePointerImmutable()) {
        self()->mIncludePointer = v;
        Q_EMIT self()->includePointerChanged();
      }
    }

    Q_PROPERTY(bool includePointer READ includePointer WRITE setIncludePointer NOTIFY includePointerChanged)
    Q_PROPERTY(bool isIncludePointerImmutable READ isIncludePointerImmutable CONSTANT)
    Q_PROPERTY(bool defaultIncludePointerValue READ defaultIncludePointerValue CONSTANT)
    /**
      Get Whether the mouse cursor is included in the screenshot
    */
    static
    bool includePointer()
    {
      return self()->mIncludePointer;
    }

    /**
      Is Whether the mouse cursor is included in the screenshot Immutable
    */
    static
    bool isIncludePointerImmutable()
    {
      return self()->isImmutable( QStringLiteral( "includePointer" ) );
    }

    /**
      Get Whether the mouse cursor is included in the screenshot default value
    */
    static
    bool defaultIncludePointerValue()
    {
        return defaultIncludePointerValue_helper();
    }

    /**
      Set Whether the mouse cursor is included in the video
    */
    static
    void setVideoIncludePointer( bool v )
    {
      if (v != self()->mVideoIncludePointer && !self()->isVideoIncludePointerImmutable()) {
        self()->mVideoIncludePointer = v;
        Q_EMIT self()->videoIncludePointerChanged();
      }
    }

    Q_PROPERTY(bool videoIncludePointer READ videoIncludePointer WRITE setVideoIncludePointer NOTIFY videoIncludePointerChanged)
    Q_PROPERTY(bool isVideoIncludePointerImmutable READ isVideoIncludePointerImmutable CONSTANT)
    Q_PROPERTY(bool defaultVideoIncludePointerValue READ defaultVideoIncludePointerValue CONSTANT)
    /**
      Get Whether the mouse cursor is included in the video
    */
    static
    bool videoIncludePointer()
    {
      return self()->mVideoIncludePointer;
    }

    /**
      Is Whether the mouse cursor is included in the video Immutable
    */
    static
    bool isVideoIncludePointerImmutable()
    {
      return self()->isImmutable( QStringLiteral( "videoIncludePointer" ) );
    }

    /**
      Get Whether the mouse cursor is included in the video default value
    */
    static
    bool defaultVideoIncludePointerValue()
    {
        return defaultVideoIncludePointerValue_helper();
    }

    /**
      Set Whether the window decorations are included in the screenshot
    */
    static
    void setIncludeDecorations( bool v )
    {
      if (v != self()->mIncludeDecorations && !self()->isIncludeDecorationsImmutable()) {
        self()->mIncludeDecorations = v;
        Q_EMIT self()->includeDecorationsChanged();
      }
    }

    Q_PROPERTY(bool includeDecorations READ includeDecorations WRITE setIncludeDecorations NOTIFY includeDecorationsChanged)
    Q_PROPERTY(bool isIncludeDecorationsImmutable READ isIncludeDecorationsImmutable CONSTANT)
    Q_PROPERTY(bool defaultIncludeDecorationsValue READ defaultIncludeDecorationsValue CONSTANT)
    /**
      Get Whether the window decorations are included in the screenshot
    */
    static
    bool includeDecorations()
    {
      return self()->mIncludeDecorations;
    }

    /**
      Is Whether the window decorations are included in the screenshot Immutable
    */
    static
    bool isIncludeDecorationsImmutable()
    {
      return self()->isImmutable( QStringLiteral( "includeDecorations" ) );
    }

    /**
      Get Whether the window decorations are included in the screenshot default value
    */
    static
    bool defaultIncludeDecorationsValue()
    {
        return defaultIncludeDecorationsValue_helper();
    }

    /**
      Set Whether the window shadow is included in the screenshot
    */
    static
    void setIncludeShadow( bool v )
    {
      if (v != self()->mIncludeShadow && !self()->isIncludeShadowImmutable()) {
        self()->mIncludeShadow = v;
        Q_EMIT self()->includeShadowChanged();
      }
    }

    Q_PROPERTY(bool includeShadow READ includeShadow WRITE setIncludeShadow NOTIFY includeShadowChanged)
    Q_PROPERTY(bool isIncludeShadowImmutable READ isIncludeShadowImmutable CONSTANT)
    Q_PROPERTY(bool defaultIncludeShadowValue READ defaultIncludeShadowValue CONSTANT)
    /**
      Get Whether the window shadow is included in the screenshot
    */
    static
    bool includeShadow()
    {
      return self()->mIncludeShadow;
    }

    /**
      Is Whether the window shadow is included in the screenshot Immutable
    */
    static
    bool isIncludeShadowImmutable()
    {
      return self()->isImmutable( QStringLiteral( "includeShadow" ) );
    }

    /**
      Get Whether the window shadow is included in the screenshot default value
    */
    static
    bool defaultIncludeShadowValue()
    {
        return defaultIncludeShadowValue_helper();
    }

    /**
      Set Only capture the current pop up menu
    */
    static
    void setTransientOnly( bool v )
    {
      if (v != self()->mTransientOnly && !self()->isTransientOnlyImmutable()) {
        self()->mTransientOnly = v;
        Q_EMIT self()->transientOnlyChanged();
      }
    }

    Q_PROPERTY(bool transientOnly READ transientOnly WRITE setTransientOnly NOTIFY transientOnlyChanged)
    Q_PROPERTY(bool isTransientOnlyImmutable READ isTransientOnlyImmutable CONSTANT)
    Q_PROPERTY(bool defaultTransientOnlyValue READ defaultTransientOnlyValue CONSTANT)
    /**
      Get Only capture the current pop up menu
    */
    static
    bool transientOnly()
    {
      return self()->mTransientOnly;
    }

    /**
      Is Only capture the current pop up menu Immutable
    */
    static
    bool isTransientOnlyImmutable()
    {
      return self()->isImmutable( QStringLiteral( "transientOnly" ) );
    }

    /**
      Get Only capture the current pop up menu default value
    */
    static
    bool defaultTransientOnlyValue()
    {
        return defaultTransientOnlyValue_helper();
    }

    /**
      Set Quit after saving or copying an image
    */
    static
    void setQuitAfterSaveCopyExport( bool v )
    {
      if (v != self()->mQuitAfterSaveCopyExport && !self()->isQuitAfterSaveCopyExportImmutable()) {
        self()->mQuitAfterSaveCopyExport = v;
        Q_EMIT self()->quitAfterSaveCopyExportChanged();
      }
    }

    Q_PROPERTY(bool quitAfterSaveCopyExport READ quitAfterSaveCopyExport WRITE setQuitAfterSaveCopyExport NOTIFY quitAfterSaveCopyExportChanged)
    Q_PROPERTY(bool isQuitAfterSaveCopyExportImmutable READ isQuitAfterSaveCopyExportImmutable CONSTANT)
    Q_PROPERTY(bool defaultQuitAfterSaveCopyExportValue READ defaultQuitAfterSaveCopyExportValue CONSTANT)
    /**
      Get Quit after saving or copying an image
    */
    static
    bool quitAfterSaveCopyExport()
    {
      return self()->mQuitAfterSaveCopyExport;
    }

    /**
      Is Quit after saving or copying an image Immutable
    */
    static
    bool isQuitAfterSaveCopyExportImmutable()
    {
      return self()->isImmutable( QStringLiteral( "quitAfterSaveCopyExport" ) );
    }

    /**
      Get Quit after saving or copying an image default value
    */
    static
    bool defaultQuitAfterSaveCopyExportValue()
    {
        return defaultQuitAfterSaveCopyExportValue_helper();
    }

    /**
      Set Delay
    */
    static
    void setCaptureDelay( double v )
    {
      if (v < 0)
      {
        qDebug() << "setCaptureDelay: value " << v << " is less than the minimum value of 0";
        v = 0;
      }
      if (v != self()->mCaptureDelay && !self()->isCaptureDelayImmutable()) {
        self()->mCaptureDelay = v;
        Q_EMIT self()->captureDelayChanged();
      }
    }

    Q_PROPERTY(double captureDelay READ captureDelay WRITE setCaptureDelay NOTIFY captureDelayChanged)
    Q_PROPERTY(bool isCaptureDelayImmutable READ isCaptureDelayImmutable CONSTANT)
    Q_PROPERTY(double defaultCaptureDelayValue READ defaultCaptureDelayValue CONSTANT)
    /**
      Get Delay
    */
    static
    double captureDelay()
    {
      return self()->mCaptureDelay;
    }

    /**
      Is Delay Immutable
    */
    static
    bool isCaptureDelayImmutable()
    {
      return self()->isImmutable( QStringLiteral( "captureDelay" ) );
    }

    /**
      Get Delay default value
    */
    static
    double defaultCaptureDelayValue()
    {
        return defaultCaptureDelayValue_helper();
    }

    /**
      Set captureMode
    */
    static
    void setCaptureMode( int v )
    {
      if (v != self()->mCaptureMode && !self()->isCaptureModeImmutable()) {
        self()->mCaptureMode = v;
        Q_EMIT self()->captureModeChanged();
      }
    }

    Q_PROPERTY(int captureMode READ captureMode WRITE setCaptureMode NOTIFY captureModeChanged)
    Q_PROPERTY(bool isCaptureModeImmutable READ isCaptureModeImmutable CONSTANT)
    Q_PROPERTY(int defaultCaptureModeValue READ defaultCaptureModeValue CONSTANT)
    /**
      Get captureMode
    */
    static
    int captureMode()
    {
      return self()->mCaptureMode;
    }

    /**
      Is captureMode Immutable
    */
    static
    bool isCaptureModeImmutable()
    {
      return self()->isImmutable( QStringLiteral( "captureMode" ) );
    }

    /**
      Get captureMode default value
    */
    static
    int defaultCaptureModeValue()
    {
        return defaultCaptureModeValue_helper();
    }

    /**
      Set Default filename
    */
    static
    void setImageSaveLocation( const QUrl & v )
    {
      if (v != self()->mImageSaveLocation && !self()->isImageSaveLocationImmutable()) {
        self()->mImageSaveLocation = v;
        Q_EMIT self()->imageSaveLocationChanged();
      }
    }

    Q_PROPERTY(QUrl imageSaveLocation READ imageSaveLocation WRITE setImageSaveLocation NOTIFY imageSaveLocationChanged)
    Q_PROPERTY(bool isImageSaveLocationImmutable READ isImageSaveLocationImmutable CONSTANT)
    Q_PROPERTY(QUrl defaultImageSaveLocationValue READ defaultImageSaveLocationValue CONSTANT)
    /**
      Get Default filename
    */
    static
    QUrl imageSaveLocation()
    {
      return self()->mImageSaveLocation;
    }

    /**
      Is Default filename Immutable
    */
    static
    bool isImageSaveLocationImmutable()
    {
      return self()->isImmutable( QStringLiteral( "imageSaveLocation" ) );
    }

    /**
      Get Default filename default value
    */
    static
    QUrl defaultImageSaveLocationValue()
    {
        return defaultImageSaveLocationValue_helper();
    }

    /**
      Set Compression quality for lossy file formats
    */
    static
    void setImageCompressionQuality( uint v )
    {

      if (v > 100)
      {
        qDebug() << "setImageCompressionQuality: value " << v << " is greater than the maximum value of 100";
        v = 100;
      }

      if (v != self()->mImageCompressionQuality && !self()->isImageCompressionQualityImmutable()) {
        self()->mImageCompressionQuality = v;
        Q_EMIT self()->imageCompressionQualityChanged();
      }
    }

    Q_PROPERTY(uint imageCompressionQuality READ imageCompressionQuality WRITE setImageCompressionQuality NOTIFY imageCompressionQualityChanged)
    Q_PROPERTY(bool isImageCompressionQualityImmutable READ isImageCompressionQualityImmutable CONSTANT)
    Q_PROPERTY(uint defaultImageCompressionQualityValue READ defaultImageCompressionQualityValue CONSTANT)
    /**
      Get Compression quality for lossy file formats
    */
    static
    uint imageCompressionQuality()
    {
      return self()->mImageCompressionQuality;
    }

    /**
      Is Compression quality for lossy file formats Immutable
    */
    static
    bool isImageCompressionQualityImmutable()
    {
      return self()->isImmutable( QStringLiteral( "imageCompressionQuality" ) );
    }

    /**
      Get Compression quality for lossy file formats default value
    */
    static
    uint defaultImageCompressionQualityValue()
    {
        return defaultImageCompressionQualityValue_helper();
    }

    /**
      Set Default save image format
    */
    static
    void setPreferredImageFormat( const QString & v )
    {
      if (v != self()->mPreferredImageFormat && !self()->isPreferredImageFormatImmutable()) {
        self()->mPreferredImageFormat = v;
        Q_EMIT self()->preferredImageFormatChanged();
      }
    }

    Q_PROPERTY(QString preferredImageFormat READ preferredImageFormat WRITE setPreferredImageFormat NOTIFY preferredImageFormatChanged)
    Q_PROPERTY(bool isPreferredImageFormatImmutable READ isPreferredImageFormatImmutable CONSTANT)
    Q_PROPERTY(QString defaultPreferredImageFormatValue READ defaultPreferredImageFormatValue CONSTANT)
    /**
      Get Default save image format
    */
    static
    QString preferredImageFormat()
    {
      return self()->mPreferredImageFormat;
    }

    /**
      Is Default save image format Immutable
    */
    static
    bool isPreferredImageFormatImmutable()
    {
      return self()->isImmutable( QStringLiteral( "preferredImageFormat" ) );
    }

    /**
      Get Default save image format default value
    */
    static
    QString defaultPreferredImageFormatValue()
    {
        return defaultPreferredImageFormatValue_helper();
    }

    /**
      Set The filename template used when saving screenshots
    */
    static
    void setImageFilenameTemplate( const QString & v )
    {
      if (v != self()->mImageFilenameTemplate && !self()->isImageFilenameTemplateImmutable()) {
        self()->mImageFilenameTemplate = v;
        Q_EMIT self()->imageFilenameTemplateChanged();
      }
    }

    Q_PROPERTY(QString imageFilenameTemplate READ imageFilenameTemplate WRITE setImageFilenameTemplate NOTIFY imageFilenameTemplateChanged)
    Q_PROPERTY(bool isImageFilenameTemplateImmutable READ isImageFilenameTemplateImmutable CONSTANT)
    Q_PROPERTY(QString defaultImageFilenameTemplateValue READ defaultImageFilenameTemplateValue CONSTANT)
    /**
      Get The filename template used when saving screenshots
    */
    static
    QString imageFilenameTemplate()
    {
      return self()->mImageFilenameTemplate;
    }

    /**
      Is The filename template used when saving screenshots Immutable
    */
    static
    bool isImageFilenameTemplateImmutable()
    {
      return self()->isImmutable( QStringLiteral( "imageFilenameTemplate" ) );
    }

    /**
      Get The filename template used when saving screenshots default value
    */
    static
    QString defaultImageFilenameTemplateValue()
    {
        return defaultImageFilenameTemplateValue_helper();
    }

    /**
      Set The path of the file saved last
    */
    static
    void setLastImageSaveLocation( const QUrl & v )
    {
      if (v != self()->mLastImageSaveLocation && !self()->isLastImageSaveLocationImmutable()) {
        self()->mLastImageSaveLocation = v;
        Q_EMIT self()->lastImageSaveLocationChanged();
      }
    }

    Q_PROPERTY(QUrl lastImageSaveLocation READ lastImageSaveLocation WRITE setLastImageSaveLocation NOTIFY lastImageSaveLocationChanged)
    Q_PROPERTY(bool isLastImageSaveLocationImmutable READ isLastImageSaveLocationImmutable CONSTANT)
    Q_PROPERTY(QUrl defaultLastImageSaveLocationValue READ defaultLastImageSaveLocationValue CONSTANT)
    /**
      Get The path of the file saved last
    */
    static
    QUrl lastImageSaveLocation()
    {
      return self()->mLastImageSaveLocation;
    }

    /**
      Is The path of the file saved last Immutable
    */
    static
    bool isLastImageSaveLocationImmutable()
    {
      return self()->isImmutable( QStringLiteral( "lastImageSaveLocation" ) );
    }

    /**
      Get The path of the file saved last default value
    */
    static
    QUrl defaultLastImageSaveLocationValue()
    {
        return defaultLastImageSaveLocationValue_helper();
    }

    /**
      Set Last path used for "save as" action
    */
    static
    void setLastImageSaveAsLocation( const QUrl & v )
    {
      if (v != self()->mLastImageSaveAsLocation && !self()->isLastImageSaveAsLocationImmutable()) {
        self()->mLastImageSaveAsLocation = v;
        Q_EMIT self()->lastImageSaveAsLocationChanged();
      }
    }

    Q_PROPERTY(QUrl lastImageSaveAsLocation READ lastImageSaveAsLocation WRITE setLastImageSaveAsLocation NOTIFY lastImageSaveAsLocationChanged)
    Q_PROPERTY(bool isLastImageSaveAsLocationImmutable READ isLastImageSaveAsLocationImmutable CONSTANT)
    Q_PROPERTY(QUrl defaultLastImageSaveAsLocationValue READ defaultLastImageSaveAsLocationValue CONSTANT)
    /**
      Get Last path used for "save as" action
    */
    static
    QUrl lastImageSaveAsLocation()
    {
      return self()->mLastImageSaveAsLocation;
    }

    /**
      Is Last path used for "save as" action Immutable
    */
    static
    bool isLastImageSaveAsLocationImmutable()
    {
      return self()->isImmutable( QStringLiteral( "lastImageSaveAsLocation" ) );
    }

    /**
      Get Last path used for "save as" action default value
    */
    static
    QUrl defaultLastImageSaveAsLocationValue()
    {
        return defaultLastImageSaveAsLocationValue_helper();
    }

    /**
      Set Default filename
    */
    static
    void setVideoSaveLocation( const QUrl & v )
    {
      if (v != self()->mVideoSaveLocation && !self()->isVideoSaveLocationImmutable()) {
        self()->mVideoSaveLocation = v;
        Q_EMIT self()->videoSaveLocationChanged();
      }
    }

    Q_PROPERTY(QUrl videoSaveLocation READ videoSaveLocation WRITE setVideoSaveLocation NOTIFY videoSaveLocationChanged)
    Q_PROPERTY(bool isVideoSaveLocationImmutable READ isVideoSaveLocationImmutable CONSTANT)
    Q_PROPERTY(QUrl defaultVideoSaveLocationValue READ defaultVideoSaveLocationValue CONSTANT)
    /**
      Get Default filename
    */
    static
    QUrl videoSaveLocation()
    {
      return self()->mVideoSaveLocation;
    }

    /**
      Is Default filename Immutable
    */
    static
    bool isVideoSaveLocationImmutable()
    {
      return self()->isImmutable( QStringLiteral( "videoSaveLocation" ) );
    }

    /**
      Get Default filename default value
    */
    static
    QUrl defaultVideoSaveLocationValue()
    {
        return defaultVideoSaveLocationValue_helper();
    }

    /**
      Set Default video format
    */
    static
    void setPreferredVideoFormat( int v )
    {
      if (v != self()->mPreferredVideoFormat && !self()->isPreferredVideoFormatImmutable()) {
        self()->mPreferredVideoFormat = v;
        Q_EMIT self()->preferredVideoFormatChanged();
      }
    }

    Q_PROPERTY(int preferredVideoFormat READ preferredVideoFormat WRITE setPreferredVideoFormat NOTIFY preferredVideoFormatChanged)
    Q_PROPERTY(bool isPreferredVideoFormatImmutable READ isPreferredVideoFormatImmutable CONSTANT)
    Q_PROPERTY(int defaultPreferredVideoFormatValue READ defaultPreferredVideoFormatValue CONSTANT)
    /**
      Get Default video format
    */
    static
    int preferredVideoFormat()
    {
      return self()->mPreferredVideoFormat;
    }

    /**
      Is Default video format Immutable
    */
    static
    bool isPreferredVideoFormatImmutable()
    {
      return self()->isImmutable( QStringLiteral( "preferredVideoFormat" ) );
    }

    /**
      Get Default video format default value
    */
    static
    int defaultPreferredVideoFormatValue()
    {
        return defaultPreferredVideoFormatValue_helper();
    }

    /**
      Set The filename template used when saving screencasts
    */
    static
    void setVideoFilenameTemplate( const QString & v )
    {
      if (v != self()->mVideoFilenameTemplate && !self()->isVideoFilenameTemplateImmutable()) {
        self()->mVideoFilenameTemplate = v;
        Q_EMIT self()->videoFilenameTemplateChanged();
      }
    }

    Q_PROPERTY(QString videoFilenameTemplate READ videoFilenameTemplate WRITE setVideoFilenameTemplate NOTIFY videoFilenameTemplateChanged)
    Q_PROPERTY(bool isVideoFilenameTemplateImmutable READ isVideoFilenameTemplateImmutable CONSTANT)
    Q_PROPERTY(QString defaultVideoFilenameTemplateValue READ defaultVideoFilenameTemplateValue CONSTANT)
    /**
      Get The filename template used when saving screencasts
    */
    static
    QString videoFilenameTemplate()
    {
      return self()->mVideoFilenameTemplate;
    }

    /**
      Is The filename template used when saving screencasts Immutable
    */
    static
    bool isVideoFilenameTemplateImmutable()
    {
      return self()->isImmutable( QStringLiteral( "videoFilenameTemplate" ) );
    }

    /**
      Get The filename template used when saving screencasts default value
    */
    static
    QString defaultVideoFilenameTemplateValue()
    {
        return defaultVideoFilenameTemplateValue_helper();
    }

    /**
      Set The path of the file saved last
    */
    static
    void setLastVideoSaveLocation( const QUrl & v )
    {
      if (v != self()->mLastVideoSaveLocation && !self()->isLastVideoSaveLocationImmutable()) {
        self()->mLastVideoSaveLocation = v;
        Q_EMIT self()->lastVideoSaveLocationChanged();
      }
    }

    Q_PROPERTY(QUrl lastVideoSaveLocation READ lastVideoSaveLocation WRITE setLastVideoSaveLocation NOTIFY lastVideoSaveLocationChanged)
    Q_PROPERTY(bool isLastVideoSaveLocationImmutable READ isLastVideoSaveLocationImmutable CONSTANT)
    Q_PROPERTY(QUrl defaultLastVideoSaveLocationValue READ defaultLastVideoSaveLocationValue CONSTANT)
    /**
      Get The path of the file saved last
    */
    static
    QUrl lastVideoSaveLocation()
    {
      return self()->mLastVideoSaveLocation;
    }

    /**
      Is The path of the file saved last Immutable
    */
    static
    bool isLastVideoSaveLocationImmutable()
    {
      return self()->isImmutable( QStringLiteral( "lastVideoSaveLocation" ) );
    }

    /**
      Get The path of the file saved last default value
    */
    static
    QUrl defaultLastVideoSaveLocationValue()
    {
        return defaultLastVideoSaveLocationValue_helper();
    }

    /**
      Set Last path used for "save as" action
    */
    static
    void setLastVideoSaveAsLocation( const QUrl & v )
    {
      if (v != self()->mLastVideoSaveAsLocation && !self()->isLastVideoSaveAsLocationImmutable()) {
        self()->mLastVideoSaveAsLocation = v;
        Q_EMIT self()->lastVideoSaveAsLocationChanged();
      }
    }

    Q_PROPERTY(QUrl lastVideoSaveAsLocation READ lastVideoSaveAsLocation WRITE setLastVideoSaveAsLocation NOTIFY lastVideoSaveAsLocationChanged)
    Q_PROPERTY(bool isLastVideoSaveAsLocationImmutable READ isLastVideoSaveAsLocationImmutable CONSTANT)
    Q_PROPERTY(QUrl defaultLastVideoSaveAsLocationValue READ defaultLastVideoSaveAsLocationValue CONSTANT)
    /**
      Get Last path used for "save as" action
    */
    static
    QUrl lastVideoSaveAsLocation()
    {
      return self()->mLastVideoSaveAsLocation;
    }

    /**
      Is Last path used for "save as" action Immutable
    */
    static
    bool isLastVideoSaveAsLocationImmutable()
    {
      return self()->isImmutable( QStringLiteral( "lastVideoSaveAsLocation" ) );
    }

    /**
      Get Last path used for "save as" action default value
    */
    static
    QUrl defaultLastVideoSaveAsLocationValue()
    {
        return defaultLastVideoSaveAsLocationValue_helper();
    }


    enum {
      signalLaunchActionChanged = 1,
      signalPrintKeyRunningActionChanged = 2,
      signalAutoSaveImageChanged = 3,
      signalCloseAfterOcrChanged = 4,
      signalClipboardGroupChanged = 5,
      signalUseLightMaskColorChanged = 6,
      signalShowMagnifierChanged = 7,
      signalUseReleaseToCaptureChanged = 8,
      signalRememberSelectionRectChanged = 9,
      signalOcrLanguagesChanged = 10,
      signalSelectionRectChanged = 11,
      signalCaptureOnClickChanged = 12,
      signalIncludePointerChanged = 13,
      signalVideoIncludePointerChanged = 14,
      signalIncludeDecorationsChanged = 15,
      signalIncludeShadowChanged = 16,
      signalTransientOnlyChanged = 17,
      signalQuitAfterSaveCopyExportChanged = 18,
      signalCaptureDelayChanged = 19,
      signalCaptureModeChanged = 20,
      signalImageSaveLocationChanged = 21,
      signalImageCompressionQualityChanged = 22,
      signalPreferredImageFormatChanged = 23,
      signalImageFilenameTemplateChanged = 24,
      signalLastImageSaveLocationChanged = 25,
      signalLastImageSaveAsLocationChanged = 26,
      signalVideoSaveLocationChanged = 27,
      signalPreferredVideoFormatChanged = 28,
      signalVideoFilenameTemplateChanged = 29,
      signalLastVideoSaveLocationChanged = 30,
      signalLastVideoSaveAsLocationChanged = 31
    };

  Q_SIGNALS:
    void launchActionChanged();

    void printKeyRunningActionChanged();

    void autoSaveImageChanged();

    void closeAfterOcrChanged();

    void clipboardGroupChanged();

    void useLightMaskColorChanged();

    void showMagnifierChanged();

    void useReleaseToCaptureChanged();

    void rememberSelectionRectChanged();

    void ocrLanguagesChanged();

    void selectionRectChanged();

    void captureOnClickChanged();

    void includePointerChanged();

    void videoIncludePointerChanged();

    void includeDecorationsChanged();

    void includeShadowChanged();

    void transientOnlyChanged();

    void quitAfterSaveCopyExportChanged();

    void captureDelayChanged();

    void captureModeChanged();

    void imageSaveLocationChanged();

    void imageCompressionQualityChanged();

    void preferredImageFormatChanged();

    void imageFilenameTemplateChanged();

    void lastImageSaveLocationChanged();

    void lastImageSaveAsLocationChanged();

    void videoSaveLocationChanged();

    void preferredVideoFormatChanged();

    void videoFilenameTemplateChanged();

    void lastVideoSaveLocationChanged();

    void lastVideoSaveAsLocationChanged();

  private:
    void itemChanged(quint64 signalFlag);

  protected:
    Settings();
    friend class SettingsHelper;


    // General
    int mLaunchAction;
    static int defaultLaunchActionValue_helper();
    int mPrintKeyRunningAction;
    static int defaultPrintKeyRunningActionValue_helper();
    bool mAutoSaveImage;
    static bool defaultAutoSaveImageValue_helper();
    bool mCloseAfterOcr;
    static bool defaultCloseAfterOcrValue_helper();
    int mClipboardGroup;
    static int defaultClipboardGroupValue_helper();
    bool mUseLightMaskColor;
    static bool defaultUseLightMaskColorValue_helper();
    int mShowMagnifier;
    static int defaultShowMagnifierValue_helper();
    bool mUseReleaseToCapture;
    static bool defaultUseReleaseToCaptureValue_helper();
    int mRememberSelectionRect;
    static int defaultRememberSelectionRectValue_helper();
    QStringList mOcrLanguages;
    static QStringList defaultOcrLanguagesValue_helper();

    // GuiConfig
    QRectF mSelectionRect;
    static QRectF defaultSelectionRectValue_helper();
    bool mCaptureOnClick;
    static bool defaultCaptureOnClickValue_helper();
    bool mIncludePointer;
    static bool defaultIncludePointerValue_helper();
    bool mVideoIncludePointer;
    static bool defaultVideoIncludePointerValue_helper();
    bool mIncludeDecorations;
    static bool defaultIncludeDecorationsValue_helper();
    bool mIncludeShadow;
    static bool defaultIncludeShadowValue_helper();
    bool mTransientOnly;
    static bool defaultTransientOnlyValue_helper();
    bool mQuitAfterSaveCopyExport;
    static bool defaultQuitAfterSaveCopyExportValue_helper();
    double mCaptureDelay;
    static double defaultCaptureDelayValue_helper();
    int mCaptureMode;
    static int defaultCaptureModeValue_helper();

    // ImageSave
    QUrl mImageSaveLocation;
    static QUrl defaultImageSaveLocationValue_helper();
    uint mImageCompressionQuality;
    static uint defaultImageCompressionQualityValue_helper();
    QString mPreferredImageFormat;
    static QString defaultPreferredImageFormatValue_helper();
    QString mImageFilenameTemplate;
    static QString defaultImageFilenameTemplateValue_helper();
    QUrl mLastImageSaveLocation;
    static QUrl defaultLastImageSaveLocationValue_helper();
    QUrl mLastImageSaveAsLocation;
    static QUrl defaultLastImageSaveAsLocationValue_helper();

    // VideoSave
    QUrl mVideoSaveLocation;
    static QUrl defaultVideoSaveLocationValue_helper();
    int mPreferredVideoFormat;
    static int defaultPreferredVideoFormatValue_helper();
    QString mVideoFilenameTemplate;
    static QString defaultVideoFilenameTemplateValue_helper();
    QUrl mLastVideoSaveLocation;
    static QUrl defaultLastVideoSaveLocationValue_helper();
    QUrl mLastVideoSaveAsLocation;
    static QUrl defaultLastVideoSaveAsLocationValue_helper();
};

#endif

