/* MediaViewTracker.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from MediaViewTracker.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CORE_TYPE_TRACKER (core_tracker_get_type ())
#define CORE_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CORE_TYPE_TRACKER, CoreTracker))
#define CORE_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CORE_TYPE_TRACKER, CoreTrackerClass))
#define CORE_IS_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CORE_TYPE_TRACKER))
#define CORE_IS_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CORE_TYPE_TRACKER))
#define CORE_TRACKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CORE_TYPE_TRACKER, CoreTrackerClass))

typedef struct _CoreTracker CoreTracker;
typedef struct _CoreTrackerClass CoreTrackerClass;
typedef struct _CoreTrackerPrivate CoreTrackerPrivate;

#define CORE_TYPE_VIEW_TRACKER (core_view_tracker_get_type ())
#define CORE_VIEW_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CORE_TYPE_VIEW_TRACKER, CoreViewTracker))
#define CORE_VIEW_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CORE_TYPE_VIEW_TRACKER, CoreViewTrackerClass))
#define CORE_IS_VIEW_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CORE_TYPE_VIEW_TRACKER))
#define CORE_IS_VIEW_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CORE_TYPE_VIEW_TRACKER))
#define CORE_VIEW_TRACKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CORE_TYPE_VIEW_TRACKER, CoreViewTrackerClass))

typedef struct _CoreViewTracker CoreViewTracker;
typedef struct _CoreViewTrackerClass CoreViewTrackerClass;
typedef struct _CoreViewTrackerPrivate CoreViewTrackerPrivate;

#define TYPE_MEDIA_VIEW_TRACKER (media_view_tracker_get_type ())
#define MEDIA_VIEW_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_VIEW_TRACKER, MediaViewTracker))
#define MEDIA_VIEW_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_VIEW_TRACKER, MediaViewTrackerClass))
#define IS_MEDIA_VIEW_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_VIEW_TRACKER))
#define IS_MEDIA_VIEW_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_VIEW_TRACKER))
#define MEDIA_VIEW_TRACKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_VIEW_TRACKER, MediaViewTrackerClass))

typedef struct _MediaViewTracker MediaViewTracker;
typedef struct _MediaViewTrackerClass MediaViewTrackerClass;
typedef struct _MediaViewTrackerPrivate MediaViewTrackerPrivate;

#define TYPE_MEDIA_ACCUMULATOR (media_accumulator_get_type ())
#define MEDIA_ACCUMULATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_ACCUMULATOR, MediaAccumulator))
#define MEDIA_ACCUMULATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_ACCUMULATOR, MediaAccumulatorClass))
#define IS_MEDIA_ACCUMULATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_ACCUMULATOR))
#define IS_MEDIA_ACCUMULATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_ACCUMULATOR))
#define MEDIA_ACCUMULATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_ACCUMULATOR, MediaAccumulatorClass))

typedef struct _MediaAccumulator MediaAccumulator;
typedef struct _MediaAccumulatorClass MediaAccumulatorClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;

#define TYPE_VIEW_COLLECTION (view_collection_get_type ())
#define VIEW_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIEW_COLLECTION, ViewCollection))
#define VIEW_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIEW_COLLECTION, ViewCollectionClass))
#define IS_VIEW_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIEW_COLLECTION))
#define IS_VIEW_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIEW_COLLECTION))
#define VIEW_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIEW_COLLECTION, ViewCollectionClass))

typedef struct _ViewCollection ViewCollection;
typedef struct _ViewCollectionClass ViewCollectionClass;

#define CORE_TYPE_TRACKER_ACCUMULATOR (core_tracker_accumulator_get_type ())
#define CORE_TRACKER_ACCUMULATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CORE_TYPE_TRACKER_ACCUMULATOR, CoreTrackerAccumulator))
#define CORE_IS_TRACKER_ACCUMULATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CORE_TYPE_TRACKER_ACCUMULATOR))
#define CORE_TRACKER_ACCUMULATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CORE_TYPE_TRACKER_ACCUMULATOR, CoreTrackerAccumulatorIface))

typedef struct _CoreTrackerAccumulator CoreTrackerAccumulator;
typedef struct _CoreTrackerAccumulatorIface CoreTrackerAccumulatorIface;

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_ALTERATION (alteration_get_type ())
#define ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALTERATION, Alteration))
#define ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALTERATION, AlterationClass))
#define IS_ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALTERATION))
#define IS_ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALTERATION))
#define ALTERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALTERATION, AlterationClass))

typedef struct _Alteration Alteration;
typedef struct _AlterationClass AlterationClass;
typedef struct _MediaAccumulatorPrivate MediaAccumulatorPrivate;
enum  {
	MEDIA_ACCUMULATOR_0_PROPERTY,
	MEDIA_ACCUMULATOR_NUM_PROPERTIES
};
static GParamSpec* media_accumulator_properties[MEDIA_ACCUMULATOR_NUM_PROPERTIES];

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_DATA_VIEW (data_view_get_type ())
#define DATA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_VIEW, DataView))
#define DATA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_VIEW, DataViewClass))
#define IS_DATA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_VIEW))
#define IS_DATA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_VIEW))
#define DATA_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_VIEW, DataViewClass))

typedef struct _DataView DataView;
typedef struct _DataViewClass DataViewClass;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;

#define TYPE_PHOTO_SOURCE (photo_source_get_type ())
#define PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_SOURCE, PhotoSource))
#define PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_SOURCE, PhotoSourceClass))
#define IS_PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_SOURCE))
#define IS_PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_SOURCE))
#define PHOTO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_SOURCE, PhotoSourceClass))

typedef struct _PhotoSource PhotoSource;
typedef struct _PhotoSourceClass PhotoSourceClass;

#define TYPE_PHOTO (photo_get_type ())
#define PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO, Photo))
#define PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO, PhotoClass))
#define IS_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO))
#define IS_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO))
#define PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO, PhotoClass))

typedef struct _Photo Photo;
typedef struct _PhotoClass PhotoClass;
typedef enum  {
	PHOTO_FILE_FORMAT_JFIF,
	PHOTO_FILE_FORMAT_RAW,
	PHOTO_FILE_FORMAT_PNG,
	PHOTO_FILE_FORMAT_TIFF,
	PHOTO_FILE_FORMAT_BMP,
	PHOTO_FILE_FORMAT_GIF,
	PHOTO_FILE_FORMAT_WEBP,
	PHOTO_FILE_FORMAT_AVIF,
	PHOTO_FILE_FORMAT_HEIF,
	PHOTO_FILE_FORMAT_JPEGXL,
	PHOTO_FILE_FORMAT_UNKNOWN
} PhotoFileFormat;

#define TYPE_PHOTO_FILE_FORMAT (photo_file_format_get_type ())

#define TYPE_VIDEO_SOURCE (video_source_get_type ())
#define VIDEO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_SOURCE, VideoSource))
#define VIDEO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_SOURCE, VideoSourceClass))
#define IS_VIDEO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_SOURCE))
#define IS_VIDEO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_SOURCE))
#define VIDEO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_SOURCE, VideoSourceClass))

typedef struct _VideoSource VideoSource;
typedef struct _VideoSourceClass VideoSourceClass;

#define TYPE_FLAGGABLE (flaggable_get_type ())
#define FLAGGABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FLAGGABLE, Flaggable))
#define IS_FLAGGABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FLAGGABLE))
#define FLAGGABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_FLAGGABLE, FlaggableIface))

typedef struct _Flaggable Flaggable;
typedef struct _FlaggableIface FlaggableIface;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_VIDEO (video_get_type ())
#define VIDEO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO, Video))
#define VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO, VideoClass))
#define IS_VIDEO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO))
#define IS_VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO))
#define VIDEO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO, VideoClass))

typedef struct _Video Video;
typedef struct _VideoClass VideoClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _CoreTracker {
	GTypeInstance parent_instance;
	volatile int ref_count;
	CoreTrackerPrivate * priv;
};

struct _CoreTrackerClass {
	GTypeClass parent_class;
	void (*finalize) (CoreTracker *self);
	void (*updated) (CoreTracker* self);
};

struct _CoreViewTracker {
	CoreTracker parent_instance;
	CoreViewTrackerPrivate * priv;
};

struct _CoreViewTrackerClass {
	CoreTrackerClass parent_class;
};

struct _MediaViewTracker {
	CoreViewTracker parent_instance;
	MediaViewTrackerPrivate * priv;
	MediaAccumulator* all;
	MediaAccumulator* visible;
	MediaAccumulator* selected;
};

struct _MediaViewTrackerClass {
	CoreViewTrackerClass parent_class;
};

struct _CoreTrackerAccumulatorIface {
	GTypeInterface parent_iface;
	gboolean (*include) (CoreTrackerAccumulator* self, DataObject* object);
	gboolean (*uninclude) (CoreTrackerAccumulator* self, DataObject* object);
	gboolean (*altered) (CoreTrackerAccumulator* self, DataObject* object, Alteration* alteration);
};

struct _MediaAccumulator {
	GObject parent_instance;
	MediaAccumulatorPrivate * priv;
	gint total;
	gint photos;
	gint videos;
	gint raw;
	gint flagged;
};

struct _MediaAccumulatorClass {
	GObjectClass parent_class;
};

struct _FlaggableIface {
	GTypeInterface parent_iface;
	gboolean (*is_flagged) (Flaggable* self);
	void (*mark_flagged) (Flaggable* self);
	void (*mark_unflagged) (Flaggable* self);
};

static gpointer media_view_tracker_parent_class = NULL;
static gpointer media_accumulator_parent_class = NULL;
static CoreTrackerAccumulatorIface * media_accumulator_core_tracker_accumulator_parent_iface = NULL;

VALA_EXTERN gpointer core_tracker_ref (gpointer instance);
VALA_EXTERN void core_tracker_unref (gpointer instance);
VALA_EXTERN GParamSpec* core_param_spec_tracker (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags);
VALA_EXTERN void core_value_set_tracker (GValue* value,
                             gpointer v_object);
VALA_EXTERN void core_value_take_tracker (GValue* value,
                              gpointer v_object);
VALA_EXTERN gpointer core_value_get_tracker (const GValue* value);
VALA_EXTERN GType core_tracker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CoreTracker, core_tracker_unref)
VALA_EXTERN GType core_view_tracker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CoreViewTracker, core_tracker_unref)
VALA_EXTERN GType media_view_tracker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MediaViewTracker, core_tracker_unref)
VALA_EXTERN GType media_accumulator_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MediaAccumulator, g_object_unref)
VALA_EXTERN MediaAccumulator* media_accumulator_new (void);
VALA_EXTERN MediaAccumulator* media_accumulator_construct (GType object_type);
VALA_EXTERN gpointer data_collection_ref (gpointer instance);
VALA_EXTERN void data_collection_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_data_collection (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void value_set_data_collection (GValue* value,
                                gpointer v_object);
VALA_EXTERN void value_take_data_collection (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer value_get_data_collection (const GValue* value);
VALA_EXTERN GType data_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataCollection, data_collection_unref)
VALA_EXTERN GType view_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ViewCollection, data_collection_unref)
VALA_EXTERN MediaViewTracker* media_view_tracker_new (ViewCollection* collection);
VALA_EXTERN MediaViewTracker* media_view_tracker_construct (GType object_type,
                                                ViewCollection* collection);
VALA_EXTERN CoreViewTracker* core_view_tracker_new (ViewCollection* collection);
VALA_EXTERN CoreViewTracker* core_view_tracker_construct (GType object_type,
                                              ViewCollection* collection);
VALA_EXTERN GType data_object_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataObject, g_object_unref)
VALA_EXTERN gpointer alteration_ref (gpointer instance);
VALA_EXTERN void alteration_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_alteration (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
VALA_EXTERN void value_set_alteration (GValue* value,
                           gpointer v_object);
VALA_EXTERN void value_take_alteration (GValue* value,
                            gpointer v_object);
VALA_EXTERN gpointer value_get_alteration (const GValue* value);
VALA_EXTERN GType alteration_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Alteration, alteration_unref)
VALA_EXTERN GType core_tracker_accumulator_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CoreTrackerAccumulator, g_object_unref)
VALA_EXTERN void core_view_tracker_start (CoreViewTracker* self,
                              CoreTrackerAccumulator* all,
                              CoreTrackerAccumulator* visible,
                              CoreTrackerAccumulator* selected);
static void media_view_tracker_finalize (CoreTracker * obj);
static GType media_view_tracker_get_type_once (void);
static gboolean media_accumulator_real_include (CoreTrackerAccumulator* base,
                                         DataObject* object);
VALA_EXTERN GType data_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataSource, g_object_unref)
VALA_EXTERN GType data_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataView, g_object_unref)
VALA_EXTERN DataSource* data_view_get_source (DataView* self);
VALA_EXTERN GType thumbnail_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ThumbnailSource, g_object_unref)
VALA_EXTERN GType media_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MediaSource, g_object_unref)
VALA_EXTERN GType photo_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoSource, g_object_unref)
VALA_EXTERN GType photo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Photo, g_object_unref)
VALA_EXTERN GType photo_file_format_get_type (void) G_GNUC_CONST ;
VALA_EXTERN PhotoFileFormat photo_get_master_file_format (Photo* self);
VALA_EXTERN GType video_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VideoSource, g_object_unref)
VALA_EXTERN GType flaggable_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Flaggable, g_object_unref)
VALA_EXTERN gboolean flaggable_is_flagged (Flaggable* self);
static gboolean media_accumulator_real_uninclude (CoreTrackerAccumulator* base,
                                           DataObject* object);
VALA_EXTERN gchar* data_object_to_string (DataObject* self);
VALA_EXTERN gchar* media_accumulator_to_string (MediaAccumulator* self);
VALA_EXTERN GType video_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Video, g_object_unref)
static gboolean media_accumulator_real_altered (CoreTrackerAccumulator* base,
                                         DataObject* object,
                                         Alteration* alteration);
VALA_EXTERN gboolean alteration_has_detail (Alteration* self,
                                const gchar* subject,
                                const gchar* detail);
VALA_EXTERN gboolean core_tracker_accumulator_include (CoreTrackerAccumulator* self,
                                           DataObject* object);
VALA_EXTERN gboolean core_tracker_accumulator_uninclude (CoreTrackerAccumulator* self,
                                             DataObject* object);
VALA_EXTERN gboolean core_tracker_accumulator_altered (CoreTrackerAccumulator* self,
                                           DataObject* object,
                                           Alteration* alteration);
static void media_accumulator_finalize (GObject * obj);
static GType media_accumulator_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

MediaViewTracker*
media_view_tracker_construct (GType object_type,
                              ViewCollection* collection)
{
	MediaViewTracker* self = NULL;
	MediaAccumulator* _tmp0_;
	MediaAccumulator* _tmp1_;
	MediaAccumulator* _tmp2_;
	g_return_val_if_fail (IS_VIEW_COLLECTION (collection), NULL);
	self = (MediaViewTracker*) core_view_tracker_construct (object_type, collection);
	_tmp0_ = self->all;
	_tmp1_ = self->visible;
	_tmp2_ = self->selected;
	core_view_tracker_start (G_TYPE_CHECK_INSTANCE_CAST (self, CORE_TYPE_VIEW_TRACKER, CoreViewTracker), G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, CORE_TYPE_TRACKER_ACCUMULATOR, CoreTrackerAccumulator), G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, CORE_TYPE_TRACKER_ACCUMULATOR, CoreTrackerAccumulator), G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, CORE_TYPE_TRACKER_ACCUMULATOR, CoreTrackerAccumulator));
	return self;
}

MediaViewTracker*
media_view_tracker_new (ViewCollection* collection)
{
	return media_view_tracker_construct (TYPE_MEDIA_VIEW_TRACKER, collection);
}

static void
media_view_tracker_class_init (MediaViewTrackerClass * klass,
                               gpointer klass_data)
{
	media_view_tracker_parent_class = g_type_class_peek_parent (klass);
	((CoreTrackerClass *) klass)->finalize = media_view_tracker_finalize;
}

static void
media_view_tracker_instance_init (MediaViewTracker * self,
                                  gpointer klass)
{
	MediaAccumulator* _tmp0_;
	MediaAccumulator* _tmp1_;
	MediaAccumulator* _tmp2_;
	_tmp0_ = media_accumulator_new ();
	self->all = _tmp0_;
	_tmp1_ = media_accumulator_new ();
	self->visible = _tmp1_;
	_tmp2_ = media_accumulator_new ();
	self->selected = _tmp2_;
}

static void
media_view_tracker_finalize (CoreTracker * obj)
{
	MediaViewTracker * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MEDIA_VIEW_TRACKER, MediaViewTracker);
	_g_object_unref0 (self->all);
	_g_object_unref0 (self->visible);
	_g_object_unref0 (self->selected);
	CORE_TRACKER_CLASS (media_view_tracker_parent_class)->finalize (obj);
}

static GType
media_view_tracker_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MediaViewTrackerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) media_view_tracker_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MediaViewTracker), 0, (GInstanceInitFunc) media_view_tracker_instance_init, NULL };
	GType media_view_tracker_type_id;
	media_view_tracker_type_id = g_type_register_static (CORE_TYPE_VIEW_TRACKER, "MediaViewTracker", &g_define_type_info, 0);
	return media_view_tracker_type_id;
}

GType
media_view_tracker_get_type (void)
{
	static volatile gsize media_view_tracker_type_id__once = 0;
	if (g_once_init_enter (&media_view_tracker_type_id__once)) {
		GType media_view_tracker_type_id;
		media_view_tracker_type_id = media_view_tracker_get_type_once ();
		g_once_init_leave (&media_view_tracker_type_id__once, media_view_tracker_type_id);
	}
	return media_view_tracker_type_id__once;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
media_accumulator_real_include (CoreTrackerAccumulator* base,
                                DataObject* object)
{
	MediaAccumulator * self;
	DataSource* source = NULL;
	DataSource* _tmp0_;
	gint _tmp1_;
	Photo* photo = NULL;
	DataSource* _tmp2_;
	Photo* _tmp3_;
	Photo* _tmp4_;
	Flaggable* flaggable = NULL;
	DataSource* _tmp11_;
	Flaggable* _tmp12_;
	gboolean _tmp13_ = FALSE;
	Flaggable* _tmp14_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_MEDIA_ACCUMULATOR, MediaAccumulator);
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
	_tmp0_ = data_view_get_source (G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DATA_VIEW, DataView));
	source = _tmp0_;
	_tmp1_ = self->total;
	self->total = _tmp1_ + 1;
	_tmp2_ = source;
	_tmp3_ = _g_object_ref0 (IS_PHOTO (_tmp2_) ? ((Photo*) _tmp2_) : NULL);
	photo = _tmp3_;
	_tmp4_ = photo;
	if (_tmp4_ != NULL) {
		Photo* _tmp5_;
		Photo* _tmp7_;
		_tmp5_ = photo;
		if (photo_get_master_file_format (_tmp5_) == PHOTO_FILE_FORMAT_RAW) {
			gint _tmp6_;
			_tmp6_ = self->raw;
			self->raw = _tmp6_ + 1;
		}
		_tmp7_ = photo;
		if (photo_get_master_file_format (_tmp7_) != PHOTO_FILE_FORMAT_RAW) {
			gint _tmp8_;
			_tmp8_ = self->photos;
			self->photos = _tmp8_ + 1;
		}
	} else {
		DataSource* _tmp9_;
		_tmp9_ = source;
		if (IS_VIDEO_SOURCE (_tmp9_)) {
			gint _tmp10_;
			_tmp10_ = self->videos;
			self->videos = _tmp10_ + 1;
		}
	}
	_tmp11_ = source;
	_tmp12_ = _g_object_ref0 (IS_FLAGGABLE (_tmp11_) ? ((Flaggable*) _tmp11_) : NULL);
	flaggable = _tmp12_;
	_tmp14_ = flaggable;
	if (_tmp14_ != NULL) {
		Flaggable* _tmp15_;
		_tmp15_ = flaggable;
		_tmp13_ = flaggable_is_flagged (_tmp15_);
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		gint _tmp16_;
		_tmp16_ = self->flagged;
		self->flagged = _tmp16_ + 1;
	}
	result = TRUE;
	_g_object_unref0 (flaggable);
	_g_object_unref0 (photo);
	_g_object_unref0 (source);
	return result;
}

static gboolean
media_accumulator_real_uninclude (CoreTrackerAccumulator* base,
                                  DataObject* object)
{
	MediaAccumulator * self;
	DataSource* source = NULL;
	DataSource* _tmp0_;
	gint _tmp8_;
	Photo* photo = NULL;
	DataSource* _tmp9_;
	Photo* _tmp10_;
	Photo* _tmp11_;
	Flaggable* flaggable = NULL;
	DataSource* _tmp18_;
	Flaggable* _tmp19_;
	gboolean _tmp20_ = FALSE;
	Flaggable* _tmp21_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_MEDIA_ACCUMULATOR, MediaAccumulator);
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
	_tmp0_ = data_view_get_source (G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DATA_VIEW, DataView));
	source = _tmp0_;
	if (self->total < 1) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp1_ = data_object_to_string (object);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_type_name (G_TYPE_FROM_INSTANCE (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject)));
		_tmp4_ = media_accumulator_to_string (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strdup_printf ("Tried to remove DataObject %s from empty %s (%s)", _tmp2_, _tmp3_, _tmp5_);
		_tmp7_ = _tmp6_;
		g_warning ("MediaViewTracker.vala:56: %s", _tmp7_);
		_g_free0 (_tmp7_);
		_g_free0 (_tmp5_);
		_g_free0 (_tmp2_);
		result = FALSE;
		_g_object_unref0 (source);
		return result;
	}
	_tmp8_ = self->total;
	self->total = _tmp8_ - 1;
	_tmp9_ = source;
	_tmp10_ = _g_object_ref0 (IS_PHOTO (_tmp9_) ? ((Photo*) _tmp9_) : NULL);
	photo = _tmp10_;
	_tmp11_ = photo;
	if (_tmp11_ != NULL) {
		Photo* _tmp12_;
		Photo* _tmp14_;
		_tmp12_ = photo;
		if (photo_get_master_file_format (_tmp12_) == PHOTO_FILE_FORMAT_RAW) {
			gint _tmp13_;
			_vala_assert (self->raw > 0, "raw > 0");
			_tmp13_ = self->raw;
			self->raw = _tmp13_ - 1;
		}
		_tmp14_ = photo;
		if (photo_get_master_file_format (_tmp14_) != PHOTO_FILE_FORMAT_RAW) {
			gint _tmp15_;
			_vala_assert (self->photos > 0, "photos > 0");
			_tmp15_ = self->photos;
			self->photos = _tmp15_ - 1;
		}
	} else {
		DataSource* _tmp16_;
		_tmp16_ = source;
		if (IS_VIDEO (_tmp16_)) {
			gint _tmp17_;
			_vala_assert (self->videos > 0, "videos > 0");
			_tmp17_ = self->videos;
			self->videos = _tmp17_ - 1;
		}
	}
	_tmp18_ = source;
	_tmp19_ = _g_object_ref0 (IS_FLAGGABLE (_tmp18_) ? ((Flaggable*) _tmp18_) : NULL);
	flaggable = _tmp19_;
	_tmp21_ = flaggable;
	if (_tmp21_ != NULL) {
		Flaggable* _tmp22_;
		_tmp22_ = flaggable;
		_tmp20_ = flaggable_is_flagged (_tmp22_);
	} else {
		_tmp20_ = FALSE;
	}
	if (_tmp20_) {
		gint _tmp23_;
		_vala_assert (self->flagged > 0, "flagged > 0");
		_tmp23_ = self->flagged;
		self->flagged = _tmp23_ - 1;
	}
	result = TRUE;
	_g_object_unref0 (flaggable);
	_g_object_unref0 (photo);
	_g_object_unref0 (source);
	return result;
}

static gboolean
media_accumulator_real_altered (CoreTrackerAccumulator* base,
                                DataObject* object,
                                Alteration* alteration)
{
	MediaAccumulator * self;
	Flaggable* flaggable = NULL;
	DataSource* _tmp0_;
	Flaggable* _tmp1_;
	Flaggable* _tmp2_;
	Flaggable* _tmp3_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_MEDIA_ACCUMULATOR, MediaAccumulator);
	g_return_val_if_fail (IS_DATA_OBJECT (object), FALSE);
	g_return_val_if_fail (IS_ALTERATION (alteration), FALSE);
	if (!alteration_has_detail (alteration, "metadata", "flagged")) {
		result = FALSE;
		return result;
	}
	_tmp0_ = data_view_get_source (G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DATA_VIEW, DataView));
	_tmp1_ = IS_FLAGGABLE (_tmp0_) ? ((Flaggable*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (_tmp0_);
	}
	flaggable = _tmp1_;
	_tmp2_ = flaggable;
	if (_tmp2_ == NULL) {
		result = FALSE;
		_g_object_unref0 (flaggable);
		return result;
	}
	_tmp3_ = flaggable;
	if (flaggable_is_flagged (_tmp3_)) {
		gint _tmp4_;
		_tmp4_ = self->flagged;
		self->flagged = _tmp4_ + 1;
	} else {
		gint _tmp5_;
		_vala_assert (self->flagged > 0, "flagged > 0");
		_tmp5_ = self->flagged;
		self->flagged = _tmp5_ - 1;
	}
	result = TRUE;
	_g_object_unref0 (flaggable);
	return result;
}

gchar*
media_accumulator_to_string (MediaAccumulator* self)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (IS_MEDIA_ACCUMULATOR (self), NULL);
	_tmp0_ = g_strdup_printf ("%d photos/%d videos/%d raw/%d flagged", self->photos, self->videos, self->raw, self->flagged);
	result = _tmp0_;
	return result;
}

MediaAccumulator*
media_accumulator_construct (GType object_type)
{
	MediaAccumulator * self = NULL;
	self = (MediaAccumulator*) g_object_new (object_type, NULL);
	return self;
}

MediaAccumulator*
media_accumulator_new (void)
{
	return media_accumulator_construct (TYPE_MEDIA_ACCUMULATOR);
}

static void
media_accumulator_class_init (MediaAccumulatorClass * klass,
                              gpointer klass_data)
{
	media_accumulator_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = media_accumulator_finalize;
}

static void
media_accumulator_core_tracker_accumulator_interface_init (CoreTrackerAccumulatorIface * iface,
                                                           gpointer iface_data)
{
	media_accumulator_core_tracker_accumulator_parent_iface = g_type_interface_peek_parent (iface);
	iface->include = (gboolean (*) (CoreTrackerAccumulator*, DataObject*)) media_accumulator_real_include;
	iface->uninclude = (gboolean (*) (CoreTrackerAccumulator*, DataObject*)) media_accumulator_real_uninclude;
	iface->altered = (gboolean (*) (CoreTrackerAccumulator*, DataObject*, Alteration*)) media_accumulator_real_altered;
}

static void
media_accumulator_instance_init (MediaAccumulator * self,
                                 gpointer klass)
{
	self->total = 0;
	self->photos = 0;
	self->videos = 0;
	self->raw = 0;
	self->flagged = 0;
}

static void
media_accumulator_finalize (GObject * obj)
{
	MediaAccumulator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MEDIA_ACCUMULATOR, MediaAccumulator);
	G_OBJECT_CLASS (media_accumulator_parent_class)->finalize (obj);
}

static GType
media_accumulator_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MediaAccumulatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) media_accumulator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MediaAccumulator), 0, (GInstanceInitFunc) media_accumulator_instance_init, NULL };
	static const GInterfaceInfo core_tracker_accumulator_info = { (GInterfaceInitFunc) media_accumulator_core_tracker_accumulator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType media_accumulator_type_id;
	media_accumulator_type_id = g_type_register_static (G_TYPE_OBJECT, "MediaAccumulator", &g_define_type_info, 0);
	g_type_add_interface_static (media_accumulator_type_id, CORE_TYPE_TRACKER_ACCUMULATOR, &core_tracker_accumulator_info);
	return media_accumulator_type_id;
}

GType
media_accumulator_get_type (void)
{
	static volatile gsize media_accumulator_type_id__once = 0;
	if (g_once_init_enter (&media_accumulator_type_id__once)) {
		GType media_accumulator_type_id;
		media_accumulator_type_id = media_accumulator_get_type_once ();
		g_once_init_leave (&media_accumulator_type_id__once, media_accumulator_type_id);
	}
	return media_accumulator_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

