/* Generated by wayland-scanner 1.24.0 */

#ifndef XDG_FOREIGN_UNSTABLE_V2_CLIENT_PROTOCOL_H
#define XDG_FOREIGN_UNSTABLE_V2_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_xdg_foreign_unstable_v2 The xdg_foreign_unstable_v2 protocol
 * Protocol for exporting xdg surface handles
 *
 * @section page_desc_xdg_foreign_unstable_v2 Description
 *
 * This protocol specifies a way for making it possible to reference a surface
 * of a different client. With such a reference, a client can, by using the
 * interfaces provided by this protocol, manipulate the relationship between
 * its own surfaces and the surface of some other client. For example, stack
 * some of its own surface above the other clients surface.
 *
 * In order for a client A to get a reference of a surface of client B, client
 * B must first export its surface using xdg_exporter.export_toplevel. Upon
 * doing this, client B will receive a handle (a unique string) that it may
 * share with client A in some way (for example D-Bus). After client A has
 * received the handle from client B, it may use xdg_importer.import_toplevel
 * to create a reference to the surface client B just exported. See the
 * corresponding requests for details.
 *
 * A possible use case for this is out-of-process dialogs. For example when a
 * sandboxed client without file system access needs the user to select a file
 * on the file system, given sandbox environment support, it can export its
 * surface, passing the exported surface handle to an unsandboxed process that
 * can show a file browser dialog and stack it above the sandboxed client's
 * surface.
 *
 * Warning! The protocol described in this file is experimental and backward
 * incompatible changes may be made. Backward compatible changes may be added
 * together with the corresponding interface version bump. Backward
 * incompatible changes are done by bumping the version number in the protocol
 * and interface names and resetting the interface version. Once the protocol
 * is to be declared stable, the 'z' prefix and the version number in the
 * protocol and interface names are removed and the interface version number is
 * reset.
 *
 * @section page_ifaces_xdg_foreign_unstable_v2 Interfaces
 * - @subpage page_iface_zxdg_exporter_v2 - interface for exporting surfaces
 * - @subpage page_iface_zxdg_importer_v2 - interface for importing surfaces
 * - @subpage page_iface_zxdg_exported_v2 - an exported surface handle
 * - @subpage page_iface_zxdg_imported_v2 - an imported surface handle
 * @section page_copyright_xdg_foreign_unstable_v2 Copyright
 * <pre>
 *
 * Copyright © 2015-2016 Red Hat Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct wl_surface;
struct zxdg_exported_v2;
struct zxdg_exporter_v2;
struct zxdg_imported_v2;
struct zxdg_importer_v2;

#ifndef ZXDG_EXPORTER_V2_INTERFACE
#define ZXDG_EXPORTER_V2_INTERFACE
/**
 * @page page_iface_zxdg_exporter_v2 zxdg_exporter_v2
 * @section page_iface_zxdg_exporter_v2_desc Description
 *
 * A global interface used for exporting surfaces that can later be imported
 * using xdg_importer.
 * @section page_iface_zxdg_exporter_v2_api API
 * See @ref iface_zxdg_exporter_v2.
 */
/**
 * @defgroup iface_zxdg_exporter_v2 The zxdg_exporter_v2 interface
 *
 * A global interface used for exporting surfaces that can later be imported
 * using xdg_importer.
 */
extern const struct wl_interface zxdg_exporter_v2_interface;
#endif
#ifndef ZXDG_IMPORTER_V2_INTERFACE
#define ZXDG_IMPORTER_V2_INTERFACE
/**
 * @page page_iface_zxdg_importer_v2 zxdg_importer_v2
 * @section page_iface_zxdg_importer_v2_desc Description
 *
 * A global interface used for importing surfaces exported by xdg_exporter.
 * With this interface, a client can create a reference to a surface of
 * another client.
 * @section page_iface_zxdg_importer_v2_api API
 * See @ref iface_zxdg_importer_v2.
 */
/**
 * @defgroup iface_zxdg_importer_v2 The zxdg_importer_v2 interface
 *
 * A global interface used for importing surfaces exported by xdg_exporter.
 * With this interface, a client can create a reference to a surface of
 * another client.
 */
extern const struct wl_interface zxdg_importer_v2_interface;
#endif
#ifndef ZXDG_EXPORTED_V2_INTERFACE
#define ZXDG_EXPORTED_V2_INTERFACE
/**
 * @page page_iface_zxdg_exported_v2 zxdg_exported_v2
 * @section page_iface_zxdg_exported_v2_desc Description
 *
 * An xdg_exported object represents an exported reference to a surface. The
 * exported surface may be referenced as long as the xdg_exported object not
 * destroyed. Destroying the xdg_exported invalidates any relationship the
 * importer may have established using xdg_imported.
 * @section page_iface_zxdg_exported_v2_api API
 * See @ref iface_zxdg_exported_v2.
 */
/**
 * @defgroup iface_zxdg_exported_v2 The zxdg_exported_v2 interface
 *
 * An xdg_exported object represents an exported reference to a surface. The
 * exported surface may be referenced as long as the xdg_exported object not
 * destroyed. Destroying the xdg_exported invalidates any relationship the
 * importer may have established using xdg_imported.
 */
extern const struct wl_interface zxdg_exported_v2_interface;
#endif
#ifndef ZXDG_IMPORTED_V2_INTERFACE
#define ZXDG_IMPORTED_V2_INTERFACE
/**
 * @page page_iface_zxdg_imported_v2 zxdg_imported_v2
 * @section page_iface_zxdg_imported_v2_desc Description
 *
 * An xdg_imported object represents an imported reference to surface exported
 * by some client. A client can use this interface to manipulate
 * relationships between its own surfaces and the imported surface.
 * @section page_iface_zxdg_imported_v2_api API
 * See @ref iface_zxdg_imported_v2.
 */
/**
 * @defgroup iface_zxdg_imported_v2 The zxdg_imported_v2 interface
 *
 * An xdg_imported object represents an imported reference to surface exported
 * by some client. A client can use this interface to manipulate
 * relationships between its own surfaces and the imported surface.
 */
extern const struct wl_interface zxdg_imported_v2_interface;
#endif

#ifndef ZXDG_EXPORTER_V2_ERROR_ENUM
#define ZXDG_EXPORTER_V2_ERROR_ENUM
/**
 * @ingroup iface_zxdg_exporter_v2
 * error values
 *
 * These errors can be emitted in response to invalid xdg_exporter
 * requests.
 */
enum zxdg_exporter_v2_error {
	/**
	 * surface is not an xdg_toplevel
	 */
	ZXDG_EXPORTER_V2_ERROR_INVALID_SURFACE = 0,
};
#endif /* ZXDG_EXPORTER_V2_ERROR_ENUM */

#define ZXDG_EXPORTER_V2_DESTROY 0
#define ZXDG_EXPORTER_V2_EXPORT_TOPLEVEL 1


/**
 * @ingroup iface_zxdg_exporter_v2
 */
#define ZXDG_EXPORTER_V2_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_zxdg_exporter_v2
 */
#define ZXDG_EXPORTER_V2_EXPORT_TOPLEVEL_SINCE_VERSION 1

/** @ingroup iface_zxdg_exporter_v2 */
static inline void
zxdg_exporter_v2_set_user_data(struct zxdg_exporter_v2 *zxdg_exporter_v2, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) zxdg_exporter_v2, user_data);
}

/** @ingroup iface_zxdg_exporter_v2 */
static inline void *
zxdg_exporter_v2_get_user_data(struct zxdg_exporter_v2 *zxdg_exporter_v2)
{
	return wl_proxy_get_user_data((struct wl_proxy *) zxdg_exporter_v2);
}

static inline uint32_t
zxdg_exporter_v2_get_version(struct zxdg_exporter_v2 *zxdg_exporter_v2)
{
	return wl_proxy_get_version((struct wl_proxy *) zxdg_exporter_v2);
}

/**
 * @ingroup iface_zxdg_exporter_v2
 *
 * Notify the compositor that the xdg_exporter object will no longer be
 * used.
 */
static inline void
zxdg_exporter_v2_destroy(struct zxdg_exporter_v2 *zxdg_exporter_v2)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zxdg_exporter_v2,
			 ZXDG_EXPORTER_V2_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) zxdg_exporter_v2), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_zxdg_exporter_v2
 *
 * The export_toplevel request exports the passed surface so that it can later be
 * imported via xdg_importer. When called, a new xdg_exported object will
 * be created and xdg_exported.handle will be sent immediately. See the
 * corresponding interface and event for details.
 *
 * A surface may be exported multiple times, and each exported handle may
 * be used to create an xdg_imported multiple times. Only xdg_toplevel
 * equivalent surfaces may be exported, otherwise an invalid_surface
 * protocol error is sent.
 */
static inline struct zxdg_exported_v2 *
zxdg_exporter_v2_export_toplevel(struct zxdg_exporter_v2 *zxdg_exporter_v2, struct wl_surface *surface)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) zxdg_exporter_v2,
			 ZXDG_EXPORTER_V2_EXPORT_TOPLEVEL, &zxdg_exported_v2_interface, wl_proxy_get_version((struct wl_proxy *) zxdg_exporter_v2), 0, NULL, surface);

	return (struct zxdg_exported_v2 *) id;
}

#define ZXDG_IMPORTER_V2_DESTROY 0
#define ZXDG_IMPORTER_V2_IMPORT_TOPLEVEL 1


/**
 * @ingroup iface_zxdg_importer_v2
 */
#define ZXDG_IMPORTER_V2_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_zxdg_importer_v2
 */
#define ZXDG_IMPORTER_V2_IMPORT_TOPLEVEL_SINCE_VERSION 1

/** @ingroup iface_zxdg_importer_v2 */
static inline void
zxdg_importer_v2_set_user_data(struct zxdg_importer_v2 *zxdg_importer_v2, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) zxdg_importer_v2, user_data);
}

/** @ingroup iface_zxdg_importer_v2 */
static inline void *
zxdg_importer_v2_get_user_data(struct zxdg_importer_v2 *zxdg_importer_v2)
{
	return wl_proxy_get_user_data((struct wl_proxy *) zxdg_importer_v2);
}

static inline uint32_t
zxdg_importer_v2_get_version(struct zxdg_importer_v2 *zxdg_importer_v2)
{
	return wl_proxy_get_version((struct wl_proxy *) zxdg_importer_v2);
}

/**
 * @ingroup iface_zxdg_importer_v2
 *
 * Notify the compositor that the xdg_importer object will no longer be
 * used.
 */
static inline void
zxdg_importer_v2_destroy(struct zxdg_importer_v2 *zxdg_importer_v2)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zxdg_importer_v2,
			 ZXDG_IMPORTER_V2_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) zxdg_importer_v2), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_zxdg_importer_v2
 *
 * The import_toplevel request imports a surface from any client given a handle
 * retrieved by exporting said surface using xdg_exporter.export_toplevel.
 * When called, a new xdg_imported object will be created. This new object
 * represents the imported surface, and the importing client can
 * manipulate its relationship using it. See xdg_imported for details.
 */
static inline struct zxdg_imported_v2 *
zxdg_importer_v2_import_toplevel(struct zxdg_importer_v2 *zxdg_importer_v2, const char *handle)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) zxdg_importer_v2,
			 ZXDG_IMPORTER_V2_IMPORT_TOPLEVEL, &zxdg_imported_v2_interface, wl_proxy_get_version((struct wl_proxy *) zxdg_importer_v2), 0, NULL, handle);

	return (struct zxdg_imported_v2 *) id;
}

/**
 * @ingroup iface_zxdg_exported_v2
 * @struct zxdg_exported_v2_listener
 */
struct zxdg_exported_v2_listener {
	/**
	 * the exported surface handle
	 *
	 * The handle event contains the unique handle of this exported
	 * surface reference. It may be shared with any client, which then
	 * can use it to import the surface by calling
	 * xdg_importer.import_toplevel. A handle may be used to import the
	 * surface multiple times.
	 * @param handle the exported surface handle
	 */
	void (*handle)(void *data,
		       struct zxdg_exported_v2 *zxdg_exported_v2,
		       const char *handle);
};

/**
 * @ingroup iface_zxdg_exported_v2
 */
static inline int
zxdg_exported_v2_add_listener(struct zxdg_exported_v2 *zxdg_exported_v2,
			      const struct zxdg_exported_v2_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) zxdg_exported_v2,
				     (void (**)(void)) listener, data);
}

#define ZXDG_EXPORTED_V2_DESTROY 0

/**
 * @ingroup iface_zxdg_exported_v2
 */
#define ZXDG_EXPORTED_V2_HANDLE_SINCE_VERSION 1

/**
 * @ingroup iface_zxdg_exported_v2
 */
#define ZXDG_EXPORTED_V2_DESTROY_SINCE_VERSION 1

/** @ingroup iface_zxdg_exported_v2 */
static inline void
zxdg_exported_v2_set_user_data(struct zxdg_exported_v2 *zxdg_exported_v2, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) zxdg_exported_v2, user_data);
}

/** @ingroup iface_zxdg_exported_v2 */
static inline void *
zxdg_exported_v2_get_user_data(struct zxdg_exported_v2 *zxdg_exported_v2)
{
	return wl_proxy_get_user_data((struct wl_proxy *) zxdg_exported_v2);
}

static inline uint32_t
zxdg_exported_v2_get_version(struct zxdg_exported_v2 *zxdg_exported_v2)
{
	return wl_proxy_get_version((struct wl_proxy *) zxdg_exported_v2);
}

/**
 * @ingroup iface_zxdg_exported_v2
 *
 * Revoke the previously exported surface. This invalidates any
 * relationship the importer may have set up using the xdg_imported created
 * given the handle sent via xdg_exported.handle.
 */
static inline void
zxdg_exported_v2_destroy(struct zxdg_exported_v2 *zxdg_exported_v2)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zxdg_exported_v2,
			 ZXDG_EXPORTED_V2_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) zxdg_exported_v2), WL_MARSHAL_FLAG_DESTROY);
}

#ifndef ZXDG_IMPORTED_V2_ERROR_ENUM
#define ZXDG_IMPORTED_V2_ERROR_ENUM
/**
 * @ingroup iface_zxdg_imported_v2
 * error values
 *
 * These errors can be emitted in response to invalid xdg_imported
 * requests.
 */
enum zxdg_imported_v2_error {
	/**
	 * surface is not an xdg_toplevel
	 */
	ZXDG_IMPORTED_V2_ERROR_INVALID_SURFACE = 0,
};
#endif /* ZXDG_IMPORTED_V2_ERROR_ENUM */

/**
 * @ingroup iface_zxdg_imported_v2
 * @struct zxdg_imported_v2_listener
 */
struct zxdg_imported_v2_listener {
	/**
	 * the imported surface handle has been destroyed
	 *
	 * The imported surface handle has been destroyed and any
	 * relationship set up has been invalidated. This may happen for
	 * various reasons, for example if the exported surface or the
	 * exported surface handle has been destroyed, if the handle used
	 * for importing was invalid.
	 */
	void (*destroyed)(void *data,
			  struct zxdg_imported_v2 *zxdg_imported_v2);
};

/**
 * @ingroup iface_zxdg_imported_v2
 */
static inline int
zxdg_imported_v2_add_listener(struct zxdg_imported_v2 *zxdg_imported_v2,
			      const struct zxdg_imported_v2_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) zxdg_imported_v2,
				     (void (**)(void)) listener, data);
}

#define ZXDG_IMPORTED_V2_DESTROY 0
#define ZXDG_IMPORTED_V2_SET_PARENT_OF 1

/**
 * @ingroup iface_zxdg_imported_v2
 */
#define ZXDG_IMPORTED_V2_DESTROYED_SINCE_VERSION 1

/**
 * @ingroup iface_zxdg_imported_v2
 */
#define ZXDG_IMPORTED_V2_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_zxdg_imported_v2
 */
#define ZXDG_IMPORTED_V2_SET_PARENT_OF_SINCE_VERSION 1

/** @ingroup iface_zxdg_imported_v2 */
static inline void
zxdg_imported_v2_set_user_data(struct zxdg_imported_v2 *zxdg_imported_v2, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) zxdg_imported_v2, user_data);
}

/** @ingroup iface_zxdg_imported_v2 */
static inline void *
zxdg_imported_v2_get_user_data(struct zxdg_imported_v2 *zxdg_imported_v2)
{
	return wl_proxy_get_user_data((struct wl_proxy *) zxdg_imported_v2);
}

static inline uint32_t
zxdg_imported_v2_get_version(struct zxdg_imported_v2 *zxdg_imported_v2)
{
	return wl_proxy_get_version((struct wl_proxy *) zxdg_imported_v2);
}

/**
 * @ingroup iface_zxdg_imported_v2
 *
 * Notify the compositor that it will no longer use the xdg_imported
 * object. Any relationship that may have been set up will at this point
 * be invalidated.
 */
static inline void
zxdg_imported_v2_destroy(struct zxdg_imported_v2 *zxdg_imported_v2)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zxdg_imported_v2,
			 ZXDG_IMPORTED_V2_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) zxdg_imported_v2), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_zxdg_imported_v2
 *
 * Set the imported surface as the parent of some surface of the client.
 * The passed surface must be an xdg_toplevel equivalent, otherwise an
 * invalid_surface protocol error is sent. Calling this function sets up
 * a surface to surface relation with the same stacking and positioning
 * semantics as xdg_toplevel.set_parent.
 */
static inline void
zxdg_imported_v2_set_parent_of(struct zxdg_imported_v2 *zxdg_imported_v2, struct wl_surface *surface)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zxdg_imported_v2,
			 ZXDG_IMPORTED_V2_SET_PARENT_OF, NULL, wl_proxy_get_version((struct wl_proxy *) zxdg_imported_v2), 0, surface);
}

#ifdef  __cplusplus
}
#endif

#endif
