/* ApplicationDockItem.c generated by valac 0.56.17, the Vala compiler
 * generated from ApplicationDockItem.vala, do not modify */

/**/
/*  Copyright (C) 2011-2012 Robert Dyer, Rico Tzschichholz*/
/**/
/*  This file is part of Plank.*/
/**/
/*  Plank is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  Plank is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include "plank.h"
#include <libbamf/libbamf.h>
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include "plank-internal.h"
#include <glib/gi18n-lib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <float.h>
#include <math.h>

#define PLANK_APPLICATION_DOCK_ITEM_DESKTOP_ACTION_KEY "Actions"
#define PLANK_APPLICATION_DOCK_ITEM_DESKTOP_ACTION_GROUP_NAME "Desktop Action %s"
#define PLANK_APPLICATION_DOCK_ITEM_UNITY_QUICKLISTS_KEY "X-Ayatana-Desktop-Shortcuts"
#define PLANK_APPLICATION_DOCK_ITEM_UNITY_QUICKLISTS_SHORTCUT_GROUP_NAME "%s Shortcut Group"
#define PLANK_APPLICATION_DOCK_ITEM_UNITY_QUICKLISTS_TARGET_KEY "TargetEnvironment"
#define PLANK_APPLICATION_DOCK_ITEM_UNITY_QUICKLISTS_TARGET_VALUE "Unity"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PLANK_APPLICATION_DOCK_ITEM_0_PROPERTY,
	PLANK_APPLICATION_DOCK_ITEM_APP_PROPERTY,
	PLANK_APPLICATION_DOCK_ITEM_NUM_PROPERTIES
};
static GParamSpec* plank_application_dock_item_properties[PLANK_APPLICATION_DOCK_ITEM_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block7Data Block7Data;
typedef struct _Block8Data Block8Data;
typedef struct _Block9Data Block9Data;
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
enum  {
	PLANK_APPLICATION_DOCK_ITEM_PIN_LAUNCHER_SIGNAL,
	PLANK_APPLICATION_DOCK_ITEM_APP_CLOSED_SIGNAL,
	PLANK_APPLICATION_DOCK_ITEM_APP_WINDOW_ADDED_SIGNAL,
	PLANK_APPLICATION_DOCK_ITEM_APP_WINDOW_REMOVED_SIGNAL,
	PLANK_APPLICATION_DOCK_ITEM_NUM_SIGNALS
};
static guint plank_application_dock_item_signals[PLANK_APPLICATION_DOCK_ITEM_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _PlankApplicationDockItemPrivate {
	BamfApplication* app;
	GeeArrayList* supported_mime_types;
	GeeArrayList* actions;
	GeeHashMap* actions_map;
	gchar* unity_application_uri;
	gchar* unity_dbusname;
};

struct _Block7Data {
	int _ref_count_;
	PlankApplicationDockItem* self;
	guint32 event_time;
};

struct _Block8Data {
	int _ref_count_;
	Block7Data * _data7_;
	gchar** values;
	gint values_length1;
	gint _values_size_;
};

struct _Block9Data {
	int _ref_count_;
	Block7Data * _data7_;
	BamfWindow* window;
};

static gint PlankApplicationDockItem_private_offset;
static gpointer plank_application_dock_item_parent_class = NULL;

VALA_EXTERN void plank_application_dock_item_set_App (PlankApplicationDockItem* self,
                                          BamfApplication* value);
static void plank_application_dock_item_app_signals_connect (PlankApplicationDockItem* self,
                                                      BamfApplication* app);
static void plank_application_dock_item_handle_active_changed (PlankApplicationDockItem* self,
                                                        gboolean is_active);
static void _plank_application_dock_item_handle_active_changed_bamf_view_active_changed (BamfView* _sender,
                                                                                  gboolean active,
                                                                                  gpointer self);
static void plank_application_dock_item_handle_name_changed (PlankApplicationDockItem* self,
                                                      const gchar* old_name,
                                                      const gchar* new_name);
static void _plank_application_dock_item_handle_name_changed_bamf_view_name_changed (BamfView* _sender,
                                                                              const gchar* old_name,
                                                                              const gchar* new_name,
                                                                              gpointer self);
static void plank_application_dock_item_handle_running_changed (PlankApplicationDockItem* self,
                                                         gboolean is_running);
static void _plank_application_dock_item_handle_running_changed_bamf_view_running_changed (BamfView* _sender,
                                                                                    gboolean running,
                                                                                    gpointer self);
static void plank_application_dock_item_handle_urgent_changed (PlankApplicationDockItem* self,
                                                        gboolean is_urgent);
static void _plank_application_dock_item_handle_urgent_changed_bamf_view_urgent_changed (BamfView* _sender,
                                                                                  gboolean urgent,
                                                                                  gpointer self);
static void plank_application_dock_item_handle_user_visible_changed (PlankApplicationDockItem* self,
                                                              gboolean user_visible);
static void _plank_application_dock_item_handle_user_visible_changed_bamf_view_user_visible_changed (BamfView* _sender,
                                                                                              gboolean user_visible,
                                                                                              gpointer self);
static void plank_application_dock_item_handle_window_added (PlankApplicationDockItem* self,
                                                      BamfView* child);
static void _plank_application_dock_item_handle_window_added_bamf_view_child_added (BamfView* _sender,
                                                                             BamfView* child,
                                                                             gpointer self);
static void plank_application_dock_item_handle_window_removed (PlankApplicationDockItem* self,
                                                        BamfView* child);
static void _plank_application_dock_item_handle_window_removed_bamf_view_child_removed (BamfView* _sender,
                                                                                 BamfView* child,
                                                                                 gpointer self);
static void plank_application_dock_item_handle_closed (PlankApplicationDockItem* self);
static void _plank_application_dock_item_handle_closed_bamf_view_closed (BamfView* _sender,
                                                                  gpointer self);
static void plank_application_dock_item_app_signals_disconnect (PlankApplicationDockItem* self,
                                                         BamfApplication* app);
static void plank_application_dock_item_initialize_states (PlankApplicationDockItem* self);
VALA_EXTERN BamfApplication* plank_application_dock_item_get_App (PlankApplicationDockItem* self);
static void plank_application_dock_item_update_indicator (PlankApplicationDockItem* self);
static inline void plank_application_dock_item_reset_application_status (PlankApplicationDockItem* self);
static void plank_application_dock_item_launch (PlankApplicationDockItem* self);
static PlankAnimationType plank_application_dock_item_real_on_clicked (PlankDockElement* base,
                                                                PlankPopupButton button,
                                                                GdkModifierType mod,
                                                                guint32 event_time);
static PlankAnimationType plank_application_dock_item_real_on_scrolled (PlankDockElement* base,
                                                                 GdkScrollDirection direction,
                                                                 GdkModifierType mod,
                                                                 guint32 event_time);
static gchar* plank_application_dock_item_shorten_window_name (PlankApplicationDockItem* self,
                                                        const gchar* window_name);
static GeeArrayList* plank_application_dock_item_real_get_menu_items (PlankDockElement* base);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void ___lambda40_ (PlankApplicationDockItem* self);
static void ____lambda40__gtk_menu_item_activate (GtkMenuItem* _sender,
                                           gpointer self);
static void ___lambda41_ (Block7Data* _data7_);
static void ____lambda41__gtk_menu_item_activate (GtkMenuItem* _sender,
                                           gpointer self);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static void _____lambda42_ (Block8Data* _data8_);
static void ______lambda42__gtk_menu_item_activate (GtkMenuItem* _sender,
                                             gpointer self);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static void ______lambda43_ (Block9Data* _data9_);
static void _______lambda43__gtk_menu_item_activate (GtkMenuItem* _sender,
                                              gpointer self);
static gchar* plank_application_dock_item_real_get_drop_text (PlankDockElement* base);
static gboolean plank_application_dock_item_real_can_accept_drop (PlankDockElement* base,
                                                           GeeArrayList* uris);
static gboolean plank_application_dock_item_real_accept_drop (PlankDockElement* base,
                                                       GeeArrayList* uris);
static void plank_application_dock_item_real_load_from_launcher (PlankDockItem* base);
static void plank_application_dock_item_unity_update_application_uri (PlankApplicationDockItem* self);
static GObject * plank_application_dock_item_constructor (GType type,
                                                   guint n_construct_properties,
                                                   GObjectConstructParam * construct_properties);
static void plank_application_dock_item_finalize (GObject * obj);
static GType plank_application_dock_item_get_type_once (void);
static void _vala_plank_application_dock_item_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec);
static void _vala_plank_application_dock_item_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static const gchar* PLANK_APPLICATION_DOCK_ITEM_SUPPORTED_GETTEXT_DOMAINS_KEYS[2] = {"X-Ubuntu-Gettext-Domain", "X-GNOME-Gettext-Domain"};

static inline gpointer
plank_application_dock_item_get_instance_private (PlankApplicationDockItem* self)
{
	return G_STRUCT_MEMBER_P (self, PlankApplicationDockItem_private_offset);
}

/**
 * {@inheritDoc}
 */
PlankApplicationDockItem*
plank_application_dock_item_construct_with_dockitem_file (GType object_type,
                                                          GFile* file)
{
	PlankApplicationDockItem * self = NULL;
	PlankDockItemPreferences* _tmp0_;
	PlankDockItemPreferences* _tmp1_;
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = plank_dock_item_preferences_new_with_file (file);
	_tmp1_ = _tmp0_;
	self = (PlankApplicationDockItem*) g_object_new (object_type, "Prefs", _tmp1_, NULL);
	_g_object_unref0 (_tmp1_);
	return self;
}

PlankApplicationDockItem*
plank_application_dock_item_new_with_dockitem_file (GFile* file)
{
	return plank_application_dock_item_construct_with_dockitem_file (PLANK_TYPE_APPLICATION_DOCK_ITEM, file);
}

/**
 * {@inheritDoc}
 */
PlankApplicationDockItem*
plank_application_dock_item_construct_with_dockitem_filename (GType object_type,
                                                              const gchar* filename)
{
	PlankApplicationDockItem * self = NULL;
	PlankDockItemPreferences* _tmp0_;
	PlankDockItemPreferences* _tmp1_;
	g_return_val_if_fail (filename != NULL, NULL);
	_tmp0_ = plank_dock_item_preferences_new_with_filename (filename);
	_tmp1_ = _tmp0_;
	self = (PlankApplicationDockItem*) g_object_new (object_type, "Prefs", _tmp1_, NULL);
	_g_object_unref0 (_tmp1_);
	return self;
}

PlankApplicationDockItem*
plank_application_dock_item_new_with_dockitem_filename (const gchar* filename)
{
	return plank_application_dock_item_construct_with_dockitem_filename (PLANK_TYPE_APPLICATION_DOCK_ITEM, filename);
}

static void
_plank_application_dock_item_handle_active_changed_bamf_view_active_changed (BamfView* _sender,
                                                                             gboolean active,
                                                                             gpointer self)
{
	plank_application_dock_item_handle_active_changed ((PlankApplicationDockItem*) self, active);
}

static void
_plank_application_dock_item_handle_name_changed_bamf_view_name_changed (BamfView* _sender,
                                                                         const gchar* old_name,
                                                                         const gchar* new_name,
                                                                         gpointer self)
{
	plank_application_dock_item_handle_name_changed ((PlankApplicationDockItem*) self, old_name, new_name);
}

static void
_plank_application_dock_item_handle_running_changed_bamf_view_running_changed (BamfView* _sender,
                                                                               gboolean running,
                                                                               gpointer self)
{
	plank_application_dock_item_handle_running_changed ((PlankApplicationDockItem*) self, running);
}

static void
_plank_application_dock_item_handle_urgent_changed_bamf_view_urgent_changed (BamfView* _sender,
                                                                             gboolean urgent,
                                                                             gpointer self)
{
	plank_application_dock_item_handle_urgent_changed ((PlankApplicationDockItem*) self, urgent);
}

static void
_plank_application_dock_item_handle_user_visible_changed_bamf_view_user_visible_changed (BamfView* _sender,
                                                                                         gboolean user_visible,
                                                                                         gpointer self)
{
	plank_application_dock_item_handle_user_visible_changed ((PlankApplicationDockItem*) self, user_visible);
}

static void
_plank_application_dock_item_handle_window_added_bamf_view_child_added (BamfView* _sender,
                                                                        BamfView* child,
                                                                        gpointer self)
{
	plank_application_dock_item_handle_window_added ((PlankApplicationDockItem*) self, child);
}

static void
_plank_application_dock_item_handle_window_removed_bamf_view_child_removed (BamfView* _sender,
                                                                            BamfView* child,
                                                                            gpointer self)
{
	plank_application_dock_item_handle_window_removed ((PlankApplicationDockItem*) self, child);
}

static void
_plank_application_dock_item_handle_closed_bamf_view_closed (BamfView* _sender,
                                                             gpointer self)
{
	plank_application_dock_item_handle_closed ((PlankApplicationDockItem*) self);
}

static void
plank_application_dock_item_app_signals_connect (PlankApplicationDockItem* self,
                                                 BamfApplication* app)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (app != NULL);
	g_signal_connect_object ((BamfView*) app, "active-changed", (GCallback) _plank_application_dock_item_handle_active_changed_bamf_view_active_changed, self, G_CONNECT_AFTER);
	g_signal_connect_object ((BamfView*) app, "name-changed", (GCallback) _plank_application_dock_item_handle_name_changed_bamf_view_name_changed, self, G_CONNECT_AFTER);
	g_signal_connect_object ((BamfView*) app, "running-changed", (GCallback) _plank_application_dock_item_handle_running_changed_bamf_view_running_changed, self, G_CONNECT_AFTER);
	g_signal_connect_object ((BamfView*) app, "urgent-changed", (GCallback) _plank_application_dock_item_handle_urgent_changed_bamf_view_urgent_changed, self, G_CONNECT_AFTER);
	g_signal_connect_object ((BamfView*) app, "user-visible-changed", (GCallback) _plank_application_dock_item_handle_user_visible_changed_bamf_view_user_visible_changed, self, G_CONNECT_AFTER);
	g_signal_connect_object ((BamfView*) app, "child-added", (GCallback) _plank_application_dock_item_handle_window_added_bamf_view_child_added, self, G_CONNECT_AFTER);
	g_signal_connect_object ((BamfView*) app, "child-removed", (GCallback) _plank_application_dock_item_handle_window_removed_bamf_view_child_removed, self, G_CONNECT_AFTER);
	g_signal_connect_object ((BamfView*) app, "closed", (GCallback) _plank_application_dock_item_handle_closed_bamf_view_closed, self, G_CONNECT_AFTER);
}

static void
plank_application_dock_item_app_signals_disconnect (PlankApplicationDockItem* self,
                                                    BamfApplication* app)
{
	guint _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	guint _tmp5_;
	guint _tmp6_;
	guint _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (app != NULL);
	g_signal_parse_name ("active-changed", bamf_view_get_type (), &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((BamfView*) app, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _plank_application_dock_item_handle_active_changed_bamf_view_active_changed, self);
	g_signal_parse_name ("name-changed", bamf_view_get_type (), &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((BamfView*) app, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _plank_application_dock_item_handle_name_changed_bamf_view_name_changed, self);
	g_signal_parse_name ("running-changed", bamf_view_get_type (), &_tmp2_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((BamfView*) app, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _plank_application_dock_item_handle_running_changed_bamf_view_running_changed, self);
	g_signal_parse_name ("urgent-changed", bamf_view_get_type (), &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((BamfView*) app, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _plank_application_dock_item_handle_urgent_changed_bamf_view_urgent_changed, self);
	g_signal_parse_name ("user-visible-changed", bamf_view_get_type (), &_tmp4_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((BamfView*) app, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _plank_application_dock_item_handle_user_visible_changed_bamf_view_user_visible_changed, self);
	g_signal_parse_name ("child-added", bamf_view_get_type (), &_tmp5_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((BamfView*) app, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _plank_application_dock_item_handle_window_added_bamf_view_child_added, self);
	g_signal_parse_name ("child-removed", bamf_view_get_type (), &_tmp6_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((BamfView*) app, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) _plank_application_dock_item_handle_window_removed_bamf_view_child_removed, self);
	g_signal_parse_name ("closed", bamf_view_get_type (), &_tmp7_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((BamfView*) app, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _plank_application_dock_item_handle_closed_bamf_view_closed, self);
}

static void
plank_application_dock_item_initialize_states (PlankApplicationDockItem* self)
{
	BamfApplication* _tmp0_;
	BamfApplication* _tmp1_;
	BamfApplication* _tmp2_;
	BamfApplication* _tmp3_;
	BamfApplication* _tmp4_;
	BamfApplication* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = plank_application_dock_item_get_App (self);
	_tmp1_ = _tmp0_;
	_vala_return_if_fail (_tmp1_ != NULL, "App != null");
	_tmp2_ = plank_application_dock_item_get_App (self);
	_tmp3_ = _tmp2_;
	plank_application_dock_item_handle_active_changed (self, bamf_view_is_active ((BamfView*) _tmp3_));
	_tmp4_ = plank_application_dock_item_get_App (self);
	_tmp5_ = _tmp4_;
	plank_application_dock_item_handle_urgent_changed (self, bamf_view_is_urgent ((BamfView*) _tmp5_));
	plank_application_dock_item_update_indicator (self);
}

gboolean
plank_application_dock_item_is_running (PlankApplicationDockItem* self)
{
	gboolean _tmp0_ = FALSE;
	BamfApplication* _tmp1_;
	BamfApplication* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = plank_application_dock_item_get_App (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		BamfApplication* _tmp3_;
		BamfApplication* _tmp4_;
		_tmp3_ = plank_application_dock_item_get_App (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = bamf_view_is_running ((BamfView*) _tmp4_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gboolean
plank_application_dock_item_is_window (PlankApplicationDockItem* self)
{
	BamfApplication* _tmp0_;
	BamfApplication* _tmp1_;
	const gchar* desktop_file = NULL;
	BamfApplication* _tmp2_;
	BamfApplication* _tmp3_;
	const gchar* _tmp4_;
	gboolean _tmp5_ = FALSE;
	const gchar* _tmp6_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = plank_application_dock_item_get_App (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp2_ = plank_application_dock_item_get_App (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = bamf_application_get_desktop_file (_tmp3_);
	desktop_file = _tmp4_;
	_tmp6_ = desktop_file;
	if (_tmp6_ == NULL) {
		_tmp5_ = TRUE;
	} else {
		const gchar* _tmp7_;
		_tmp7_ = desktop_file;
		_tmp5_ = g_strcmp0 (_tmp7_, "") == 0;
	}
	result = _tmp5_;
	return result;
}

static void
plank_application_dock_item_handle_user_visible_changed (PlankApplicationDockItem* self,
                                                         gboolean user_visible)
{
	g_return_if_fail (self != NULL);
	if (user_visible) {
		g_signal_emit (self, plank_application_dock_item_signals[PLANK_APPLICATION_DOCK_ITEM_APP_WINDOW_ADDED_SIGNAL], 0);
	} else {
		g_signal_emit (self, plank_application_dock_item_signals[PLANK_APPLICATION_DOCK_ITEM_APP_WINDOW_REMOVED_SIGNAL], 0);
	}
}

static void
plank_application_dock_item_handle_closed (PlankApplicationDockItem* self)
{
	g_return_if_fail (self != NULL);
	plank_application_dock_item_set_App (self, NULL);
	g_signal_emit (self, plank_application_dock_item_signals[PLANK_APPLICATION_DOCK_ITEM_APP_CLOSED_SIGNAL], 0);
}

static void
plank_application_dock_item_handle_active_changed (PlankApplicationDockItem* self,
                                                   gboolean is_active)
{
	gboolean was_active = FALSE;
	PlankItemState _tmp0_;
	PlankItemState _tmp1_;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = plank_dock_item_get_State ((PlankDockItem*) self);
	_tmp1_ = _tmp0_;
	was_active = (_tmp1_ & PLANK_ITEM_STATE_ACTIVE) == PLANK_ITEM_STATE_ACTIVE;
	if (is_active) {
		_tmp2_ = !was_active;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		PlankItemState _tmp3_;
		PlankItemState _tmp4_;
		plank_dock_element_set_LastActive ((PlankDockElement*) self, g_get_monotonic_time ());
		_tmp3_ = plank_dock_item_get_State ((PlankDockItem*) self);
		_tmp4_ = _tmp3_;
		plank_dock_item_set_State ((PlankDockItem*) self, _tmp4_ | PLANK_ITEM_STATE_ACTIVE);
	} else {
		gboolean _tmp5_ = FALSE;
		if (!is_active) {
			_tmp5_ = was_active;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			PlankItemState _tmp6_;
			PlankItemState _tmp7_;
			plank_dock_element_set_LastActive ((PlankDockElement*) self, g_get_monotonic_time ());
			_tmp6_ = plank_dock_item_get_State ((PlankDockItem*) self);
			_tmp7_ = _tmp6_;
			plank_dock_item_set_State ((PlankDockItem*) self, _tmp7_ & (~PLANK_ITEM_STATE_ACTIVE));
		}
	}
}

static void
plank_application_dock_item_handle_name_changed (PlankApplicationDockItem* self,
                                                 const gchar* old_name,
                                                 const gchar* new_name)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (old_name != NULL);
	g_return_if_fail (new_name != NULL);
	if (PLANK_IS_TRANSIENT_DOCK_ITEM (self)) {
		plank_dock_element_set_Text ((PlankDockElement*) self, new_name);
	}
}

static void
plank_application_dock_item_handle_running_changed (PlankApplicationDockItem* self,
                                                    gboolean is_running)
{
	g_return_if_fail (self != NULL);
	if (!is_running) {
		plank_application_dock_item_reset_application_status (self);
		return;
	}
	plank_application_dock_item_update_indicator (self);
	g_signal_emit (self, plank_application_dock_item_signals[PLANK_APPLICATION_DOCK_ITEM_APP_WINDOW_ADDED_SIGNAL], 0);
}

void
plank_application_dock_item_set_urgent (PlankApplicationDockItem* self,
                                        gboolean is_urgent)
{
	g_return_if_fail (self != NULL);
	plank_application_dock_item_handle_urgent_changed (self, is_urgent);
}

static void
plank_application_dock_item_handle_urgent_changed (PlankApplicationDockItem* self,
                                                   gboolean is_urgent)
{
	gboolean was_urgent = FALSE;
	PlankItemState _tmp0_;
	PlankItemState _tmp1_;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = plank_dock_item_get_State ((PlankDockItem*) self);
	_tmp1_ = _tmp0_;
	was_urgent = (_tmp1_ & PLANK_ITEM_STATE_URGENT) == PLANK_ITEM_STATE_URGENT;
	if (is_urgent) {
		_tmp2_ = !was_urgent;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		PlankItemState _tmp3_;
		PlankItemState _tmp4_;
		plank_dock_element_set_LastUrgent ((PlankDockElement*) self, g_get_monotonic_time ());
		_tmp3_ = plank_dock_item_get_State ((PlankDockItem*) self);
		_tmp4_ = _tmp3_;
		plank_dock_item_set_State ((PlankDockItem*) self, _tmp4_ | PLANK_ITEM_STATE_URGENT);
	} else {
		gboolean _tmp5_ = FALSE;
		if (!is_urgent) {
			_tmp5_ = was_urgent;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			PlankItemState _tmp6_;
			PlankItemState _tmp7_;
			_tmp6_ = plank_dock_item_get_State ((PlankDockItem*) self);
			_tmp7_ = _tmp6_;
			plank_dock_item_set_State ((PlankDockItem*) self, _tmp7_ & (~PLANK_ITEM_STATE_URGENT));
		}
	}
}

static void
plank_application_dock_item_handle_window_added (PlankApplicationDockItem* self,
                                                 BamfView* child)
{
	g_return_if_fail (self != NULL);
	if (!G_TYPE_CHECK_INSTANCE_TYPE (child, bamf_window_get_type ())) {
		return;
	}
	plank_application_dock_item_update_indicator (self);
	g_signal_emit (self, plank_application_dock_item_signals[PLANK_APPLICATION_DOCK_ITEM_APP_WINDOW_ADDED_SIGNAL], 0);
}

static void
plank_application_dock_item_handle_window_removed (PlankApplicationDockItem* self,
                                                   BamfView* child)
{
	g_return_if_fail (self != NULL);
	if (!G_TYPE_CHECK_INSTANCE_TYPE (child, bamf_window_get_type ())) {
		return;
	}
	plank_application_dock_item_update_indicator (self);
	g_signal_emit (self, plank_application_dock_item_signals[PLANK_APPLICATION_DOCK_ITEM_APP_WINDOW_REMOVED_SIGNAL], 0);
}

static void
plank_application_dock_item_update_indicator (PlankApplicationDockItem* self)
{
	gboolean is_running = FALSE;
	guint window_count = 0U;
	BamfApplication* _tmp2_;
	BamfApplication* _tmp3_;
	GList* _tmp4_;
	GList* _tmp5_;
	guint _tmp6_;
	g_return_if_fail (self != NULL);
	is_running = plank_application_dock_item_is_running (self);
	if (!is_running) {
		PlankIndicatorState _tmp0_;
		PlankIndicatorState _tmp1_;
		_tmp0_ = plank_dock_item_get_Indicator ((PlankDockItem*) self);
		_tmp1_ = _tmp0_;
		if (_tmp1_ != PLANK_INDICATOR_STATE_NONE) {
			plank_dock_item_set_Indicator ((PlankDockItem*) self, PLANK_INDICATOR_STATE_NONE);
		}
		return;
	}
	_tmp2_ = plank_application_dock_item_get_App (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = bamf_application_get_windows (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_list_length (_tmp5_);
	(_tmp5_ == NULL) ? NULL : (_tmp5_ = (g_list_free (_tmp5_), NULL));
	window_count = _tmp6_;
	if (window_count <= ((guint) 1)) {
		PlankIndicatorState _tmp7_;
		PlankIndicatorState _tmp8_;
		_tmp7_ = plank_dock_item_get_Indicator ((PlankDockItem*) self);
		_tmp8_ = _tmp7_;
		if (_tmp8_ != PLANK_INDICATOR_STATE_SINGLE) {
			plank_dock_item_set_Indicator ((PlankDockItem*) self, PLANK_INDICATOR_STATE_SINGLE);
		}
	} else {
		PlankIndicatorState _tmp9_;
		PlankIndicatorState _tmp10_;
		_tmp9_ = plank_dock_item_get_Indicator ((PlankDockItem*) self);
		_tmp10_ = _tmp9_;
		if (_tmp10_ != PLANK_INDICATOR_STATE_SINGLE_PLUS) {
			plank_dock_item_set_Indicator ((PlankDockItem*) self, PLANK_INDICATOR_STATE_SINGLE_PLUS);
		}
	}
}

static inline void
plank_application_dock_item_reset_application_status (PlankApplicationDockItem* self)
{
	PlankIndicatorState _tmp0_;
	PlankIndicatorState _tmp1_;
	g_return_if_fail (self != NULL);
	plank_application_dock_item_handle_urgent_changed (self, FALSE);
	plank_application_dock_item_handle_active_changed (self, FALSE);
	_tmp0_ = plank_dock_item_get_Indicator ((PlankDockItem*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != PLANK_INDICATOR_STATE_NONE) {
		plank_dock_item_set_Indicator ((PlankDockItem*) self, PLANK_INDICATOR_STATE_NONE);
	}
}

static void
plank_application_dock_item_launch (PlankApplicationDockItem* self)
{
	PlankSystem* _tmp0_;
	PlankDockItemPreferences* _tmp1_;
	PlankDockItemPreferences* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = plank_system_get_default ();
	_tmp1_ = plank_dock_item_get_Prefs ((PlankDockItem*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = plank_dock_item_preferences_get_Launcher (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_file_new_for_uri (_tmp4_);
	_tmp6_ = _tmp5_;
	plank_system_launch (_tmp0_, _tmp6_);
	_g_object_unref0 (_tmp6_);
}

/**
 * {@inheritDoc}
 */
static PlankAnimationType
plank_application_dock_item_real_on_clicked (PlankDockElement* base,
                                             PlankPopupButton button,
                                             GdkModifierType mod,
                                             guint32 event_time)
{
	PlankApplicationDockItem * self;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	PlankAnimationType result;
	self = (PlankApplicationDockItem*) base;
	if (!plank_application_dock_item_is_window (self)) {
		gboolean _tmp0_ = FALSE;
		if (button == PLANK_POPUP_BUTTON_MIDDLE) {
			_tmp0_ = TRUE;
		} else {
			gboolean _tmp1_ = FALSE;
			if (button == PLANK_POPUP_BUTTON_LEFT) {
				gboolean _tmp2_ = FALSE;
				gboolean _tmp3_ = FALSE;
				BamfApplication* _tmp4_;
				BamfApplication* _tmp5_;
				_tmp4_ = plank_application_dock_item_get_App (self);
				_tmp5_ = _tmp4_;
				if (_tmp5_ == NULL) {
					_tmp3_ = TRUE;
				} else {
					BamfApplication* _tmp6_;
					BamfApplication* _tmp7_;
					GList* _tmp8_;
					GList* _tmp9_;
					_tmp6_ = plank_application_dock_item_get_App (self);
					_tmp7_ = _tmp6_;
					_tmp8_ = bamf_application_get_windows (_tmp7_);
					_tmp9_ = _tmp8_;
					_tmp3_ = g_list_length (_tmp9_) == ((guint) 0);
					(_tmp9_ == NULL) ? NULL : (_tmp9_ = (g_list_free (_tmp9_), NULL));
				}
				if (_tmp3_) {
					_tmp2_ = TRUE;
				} else {
					_tmp2_ = (mod & GDK_CONTROL_MASK) == GDK_CONTROL_MASK;
				}
				_tmp1_ = _tmp2_;
			} else {
				_tmp1_ = FALSE;
			}
			_tmp0_ = _tmp1_;
		}
		if (_tmp0_) {
			plank_application_dock_item_launch (self);
			result = PLANK_ANIMATION_TYPE_BOUNCE;
			return result;
		}
	}
	if (button == PLANK_POPUP_BUTTON_LEFT) {
		BamfApplication* _tmp12_;
		BamfApplication* _tmp13_;
		_tmp12_ = plank_application_dock_item_get_App (self);
		_tmp13_ = _tmp12_;
		_tmp11_ = _tmp13_ != NULL;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		BamfApplication* _tmp14_;
		BamfApplication* _tmp15_;
		GList* _tmp16_;
		GList* _tmp17_;
		_tmp14_ = plank_application_dock_item_get_App (self);
		_tmp15_ = _tmp14_;
		_tmp16_ = bamf_application_get_windows (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp10_ = g_list_length (_tmp17_) > ((guint) 0);
		(_tmp17_ == NULL) ? NULL : (_tmp17_ = (g_list_free (_tmp17_), NULL));
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		BamfApplication* _tmp18_;
		BamfApplication* _tmp19_;
		_tmp18_ = plank_application_dock_item_get_App (self);
		_tmp19_ = _tmp18_;
		plank_window_control_smart_focus (_tmp19_, event_time);
		result = PLANK_ANIMATION_TYPE_DARKEN;
		return result;
	}
	result = PLANK_ANIMATION_TYPE_NONE;
	return result;
}

/**
 * {@inheritDoc}
 */
static PlankAnimationType
plank_application_dock_item_real_on_scrolled (PlankDockElement* base,
                                              GdkScrollDirection direction,
                                              GdkModifierType mod,
                                              guint32 event_time)
{
	PlankApplicationDockItem * self;
	gboolean _tmp0_ = FALSE;
	BamfApplication* _tmp1_;
	BamfApplication* _tmp2_;
	gint64 _tmp7_;
	gint64 _tmp8_;
	gboolean _tmp9_ = FALSE;
	PlankAnimationType result;
	self = (PlankApplicationDockItem*) base;
	_tmp1_ = plank_application_dock_item_get_App (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		BamfApplication* _tmp3_;
		BamfApplication* _tmp4_;
		GList* _tmp5_;
		GList* _tmp6_;
		_tmp3_ = plank_application_dock_item_get_App (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = bamf_application_get_windows (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = g_list_length (_tmp6_) == ((guint) 0);
		(_tmp6_ == NULL) ? NULL : (_tmp6_ = (g_list_free (_tmp6_), NULL));
	}
	if (_tmp0_) {
		result = PLANK_ANIMATION_TYPE_NONE;
		return result;
	}
	_tmp7_ = plank_dock_element_get_LastScrolled ((PlankDockElement*) self);
	_tmp8_ = _tmp7_;
	if ((g_get_monotonic_time () - _tmp8_) < ((gint64) (PLANK_ITEM_SCROLL_DURATION * 1000))) {
		result = PLANK_ANIMATION_TYPE_DARKEN;
		return result;
	}
	plank_dock_element_set_LastScrolled ((PlankDockElement*) self, g_get_monotonic_time ());
	if (direction == GDK_SCROLL_UP) {
		_tmp9_ = TRUE;
	} else {
		_tmp9_ = direction == GDK_SCROLL_LEFT;
	}
	if (_tmp9_) {
		BamfApplication* _tmp10_;
		BamfApplication* _tmp11_;
		_tmp10_ = plank_application_dock_item_get_App (self);
		_tmp11_ = _tmp10_;
		plank_window_control_focus_previous (_tmp11_, event_time);
	} else {
		BamfApplication* _tmp12_;
		BamfApplication* _tmp13_;
		_tmp12_ = plank_application_dock_item_get_App (self);
		_tmp13_ = _tmp12_;
		plank_window_control_focus_next (_tmp13_, event_time);
	}
	result = PLANK_ANIMATION_TYPE_DARKEN;
	return result;
}

static gchar*
plank_application_dock_item_shorten_window_name (PlankApplicationDockItem* self,
                                                 const gchar* window_name)
{
	static const gchar* WINDOW_NAME_PATTERN[5] = {"%s - (.+)", "(.+) - %s", "%s – (.+)", "(.+) – %s", "%s: (.+)"};
	static const gchar* APP_NAME_DELIMITER[3] = {" ", "-", "–"};
	gchar** app_strings = NULL;
	gint app_strings_length1;
	gint _app_strings_size_;
	GMatchInfo* m = NULL;
	gchar* _tmp23_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (window_name != NULL, NULL);
	app_strings = NULL;
	app_strings_length1 = 0;
	_app_strings_size_ = app_strings_length1;
	{
		const gchar** d_collection = NULL;
		gint d_collection_length1 = 0;
		gint _d_collection_size_ = 0;
		gint d_it = 0;
		d_collection = APP_NAME_DELIMITER;
		d_collection_length1 = G_N_ELEMENTS (APP_NAME_DELIMITER);
		for (d_it = 0; d_it < d_collection_length1; d_it = d_it + 1) {
			const gchar* d = NULL;
			d = d_collection[d_it];
			{
				const gchar* _tmp0_;
				const gchar* _tmp1_;
				const gchar* _tmp2_;
				gint _tmp3_ = 0;
				gchar** _tmp4_;
				gchar** _tmp5_;
				gint _tmp5__length1;
				_tmp0_ = plank_dock_element_get_Text ((PlankDockElement*) self);
				_tmp1_ = _tmp0_;
				_tmp2_ = d;
				_tmp4_ = plank_string_split_combine (_tmp1_, _tmp2_, &_tmp3_);
				app_strings = (_vala_array_free (app_strings, app_strings_length1, (GDestroyNotify) g_free), NULL);
				app_strings = _tmp4_;
				app_strings_length1 = _tmp3_;
				_app_strings_size_ = app_strings_length1;
				_tmp5_ = app_strings;
				_tmp5__length1 = app_strings_length1;
				if (_tmp5__length1 > 1) {
					break;
				}
			}
		}
	}
	{
		const gchar** p_collection = NULL;
		gint p_collection_length1 = 0;
		gint _p_collection_size_ = 0;
		gint p_it = 0;
		p_collection = WINDOW_NAME_PATTERN;
		p_collection_length1 = G_N_ELEMENTS (WINDOW_NAME_PATTERN);
		for (p_it = 0; p_it < p_collection_length1; p_it = p_it + 1) {
			const gchar* p = NULL;
			p = p_collection[p_it];
			{
				gchar** _tmp6_;
				gint _tmp6__length1;
				_tmp6_ = app_strings;
				_tmp6__length1 = app_strings_length1;
				{
					gchar** s_collection = NULL;
					gint s_collection_length1 = 0;
					gint _s_collection_size_ = 0;
					gint s_it = 0;
					s_collection = _tmp6_;
					s_collection_length1 = _tmp6__length1;
					for (s_it = 0; s_it < s_collection_length1; s_it = s_it + 1) {
						const gchar* s = NULL;
						s = s_collection[s_it];
						{
							const gchar* _tmp7_;
							_tmp7_ = s;
							if (g_utf8_strlen (_tmp7_, (gssize) -1) < 3) {
								continue;
							}
							{
								GRegex* r = NULL;
								const gchar* _tmp8_;
								const gchar* _tmp9_;
								gchar* _tmp10_;
								gchar* _tmp11_;
								gchar* _tmp12_;
								gchar* _tmp13_;
								GRegex* _tmp14_;
								GRegex* _tmp15_;
								GRegex* _tmp16_;
								GMatchInfo* _tmp17_ = NULL;
								GMatchInfo* _tmp18_;
								_tmp8_ = p;
								_tmp9_ = s;
								_tmp10_ = g_strdup_printf (_tmp8_, _tmp9_);
								_tmp11_ = _tmp10_;
								_tmp12_ = g_strdup_printf ("^%s$", _tmp11_);
								_tmp13_ = _tmp12_;
								_tmp14_ = g_regex_new (_tmp13_, (G_REGEX_CASELESS | G_REGEX_ANCHORED) | G_REGEX_DOLLAR_ENDONLY, G_REGEX_MATCH_ANCHORED | G_REGEX_MATCH_NOTEMPTY, &_inner_error0_);
								_tmp15_ = _tmp14_;
								_g_free0 (_tmp13_);
								_g_free0 (_tmp11_);
								r = _tmp15_;
								if (G_UNLIKELY (_inner_error0_ != NULL)) {
									if (_inner_error0_->domain == G_REGEX_ERROR) {
										goto __catch0_g_regex_error;
									}
									_g_match_info_unref0 (m);
									app_strings = (_vala_array_free (app_strings, app_strings_length1, (GDestroyNotify) g_free), NULL);
									g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
									g_clear_error (&_inner_error0_);
									return NULL;
								}
								_tmp16_ = r;
								g_regex_match (_tmp16_, window_name, G_REGEX_MATCH_ANCHORED | G_REGEX_MATCH_NOTEMPTY, &_tmp17_);
								_g_match_info_unref0 (m);
								m = _tmp17_;
								_tmp18_ = m;
								if (g_match_info_matches (_tmp18_)) {
									GMatchInfo* _tmp19_;
									gchar* _tmp20_;
									_tmp19_ = m;
									_tmp20_ = g_match_info_fetch (_tmp19_, 1);
									result = _tmp20_;
									_g_regex_unref0 (r);
									_g_match_info_unref0 (m);
									app_strings = (_vala_array_free (app_strings, app_strings_length1, (GDestroyNotify) g_free), NULL);
									return result;
								}
								_g_regex_unref0 (r);
							}
							goto __finally0;
							__catch0_g_regex_error:
							{
								GError* e = NULL;
								GError* _tmp21_;
								const gchar* _tmp22_;
								e = _inner_error0_;
								_inner_error0_ = NULL;
								_tmp21_ = e;
								_tmp22_ = _tmp21_->message;
								g_warning ("ApplicationDockItem.vala:385: %s", _tmp22_);
								_g_error_free0 (e);
							}
							__finally0:
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								_g_match_info_unref0 (m);
								app_strings = (_vala_array_free (app_strings, app_strings_length1, (GDestroyNotify) g_free), NULL);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
								g_clear_error (&_inner_error0_);
								return NULL;
							}
						}
					}
				}
			}
		}
	}
	_tmp23_ = g_strdup (window_name);
	result = _tmp23_;
	_g_match_info_unref0 (m);
	app_strings = (_vala_array_free (app_strings, app_strings_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

/**
 * {@inheritDoc}
 */
static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		PlankApplicationDockItem* self;
		self = _data7_->self;
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}

static void
___lambda40_ (PlankApplicationDockItem* self)
{
	g_signal_emit (self, plank_application_dock_item_signals[PLANK_APPLICATION_DOCK_ITEM_PIN_LAUNCHER_SIGNAL], 0);
}

static void
____lambda40__gtk_menu_item_activate (GtkMenuItem* _sender,
                                      gpointer self)
{
	___lambda40_ ((PlankApplicationDockItem*) self);
}

static void
___lambda41_ (Block7Data* _data7_)
{
	PlankApplicationDockItem* self;
	BamfApplication* _tmp0_;
	BamfApplication* _tmp1_;
	self = _data7_->self;
	_tmp0_ = plank_application_dock_item_get_App (self);
	_tmp1_ = _tmp0_;
	plank_window_control_close_all (_tmp1_, _data7_->event_time);
}

static void
____lambda41__gtk_menu_item_activate (GtkMenuItem* _sender,
                                      gpointer self)
{
	___lambda41_ (self);
}

static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}

static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		PlankApplicationDockItem* self;
		self = _data8_->_data7_->self;
		_data8_->values = (_vala_array_free (_data8_->values, _data8_->values_length1, (GDestroyNotify) g_free), NULL);
		block7_data_unref (_data8_->_data7_);
		_data8_->_data7_ = NULL;
		g_slice_free (Block8Data, _data8_);
	}
}

static void
_____lambda42_ (Block8Data* _data8_)
{
	Block7Data* _data7_;
	PlankApplicationDockItem* self;
	GError* _inner_error0_ = NULL;
	_data7_ = _data8_->_data7_;
	self = _data7_->self;
	{
		GAppInfo* _tmp0_ = NULL;
		gchar** _tmp1_;
		gint _tmp1__length1;
		const gchar* _tmp2_;
		GAppInfo* _tmp3_;
		_tmp1_ = _data8_->values;
		_tmp1__length1 = _data8_->values_length1;
		_tmp2_ = _tmp1_[0];
		_tmp3_ = g_app_info_create_from_commandline (_tmp2_, NULL, G_APP_INFO_CREATE_NONE, &_inner_error0_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		g_app_info_launch (_tmp0_, NULL, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp0_);
			goto __catch0_g_error;
		}
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
______lambda42__gtk_menu_item_activate (GtkMenuItem* _sender,
                                        gpointer self)
{
	_____lambda42_ (self);
}

static Block9Data*
block9_data_ref (Block9Data* _data9_)
{
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}

static void
block9_data_unref (void * _userdata_)
{
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		PlankApplicationDockItem* self;
		self = _data9_->_data7_->self;
		block7_data_unref (_data9_->_data7_);
		_data9_->_data7_ = NULL;
		g_slice_free (Block9Data, _data9_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
______lambda43_ (Block9Data* _data9_)
{
	Block7Data* _data7_;
	PlankApplicationDockItem* self;
	BamfWindow* _tmp0_;
	_data7_ = _data9_->_data7_;
	self = _data7_->self;
	_tmp0_ = _data9_->window;
	plank_window_control_focus_window (_tmp0_, _data7_->event_time);
}

static void
_______lambda43__gtk_menu_item_activate (GtkMenuItem* _sender,
                                         gpointer self)
{
	______lambda43_ (self);
}

static GeeArrayList*
plank_application_dock_item_real_get_menu_items (PlankDockElement* base)
{
	PlankApplicationDockItem * self;
	Block7Data* _data7_;
	GeeArrayList* items = NULL;
	GeeArrayList* _tmp0_;
	GList* windows = NULL;
	BamfApplication* _tmp1_;
	BamfApplication* _tmp2_;
	guint window_count = 0U;
	GList* _tmp6_;
	PlankDefaultApplicationDockItemProvider* default_provider = NULL;
	PlankDockContainer* _tmp8_;
	PlankDockContainer* _tmp9_;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	PlankDefaultApplicationDockItemProvider* _tmp12_;
	gboolean _tmp23_ = FALSE;
	gboolean _tmp29_ = FALSE;
	gboolean _tmp61_ = FALSE;
	GeeArrayList* result;
	self = (PlankApplicationDockItem*) base;
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	_tmp0_ = gee_array_list_new (gtk_menu_item_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	items = _tmp0_;
	windows = NULL;
	_tmp1_ = plank_application_dock_item_get_App (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		BamfApplication* _tmp3_;
		BamfApplication* _tmp4_;
		GList* _tmp5_;
		_tmp3_ = plank_application_dock_item_get_App (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = bamf_application_get_windows (_tmp4_);
		(windows == NULL) ? NULL : (windows = (g_list_free (windows), NULL));
		windows = _tmp5_;
	}
	window_count = 0U;
	_tmp6_ = windows;
	if (_tmp6_ != NULL) {
		GList* _tmp7_;
		_tmp7_ = windows;
		window_count = g_list_length (_tmp7_);
	}
	_tmp8_ = plank_dock_element_get_Container ((PlankDockElement*) self);
	_tmp9_ = _tmp8_;
	default_provider = PLANK_IS_DEFAULT_APPLICATION_DOCK_ITEM_PROVIDER (_tmp9_) ? ((PlankDefaultApplicationDockItemProvider*) _tmp9_) : NULL;
	_tmp12_ = default_provider;
	if (_tmp12_ != NULL) {
		PlankDefaultApplicationDockItemProvider* _tmp13_;
		PlankDockPreferences* _tmp14_;
		PlankDockPreferences* _tmp15_;
		gboolean _tmp16_;
		gboolean _tmp17_;
		_tmp13_ = default_provider;
		_tmp14_ = plank_default_application_dock_item_provider_get_Prefs (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = plank_dock_preferences_get_LockItems (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp11_ = !_tmp17_;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		_tmp10_ = !plank_application_dock_item_is_window (self);
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		GtkCheckMenuItem* item = NULL;
		GtkCheckMenuItem* _tmp18_;
		GtkCheckMenuItem* _tmp19_;
		GtkCheckMenuItem* _tmp20_;
		GeeArrayList* _tmp21_;
		GtkCheckMenuItem* _tmp22_;
		_tmp18_ = (GtkCheckMenuItem*) gtk_check_menu_item_new_with_mnemonic (_ ("_Keep in Dock"));
		g_object_ref_sink (_tmp18_);
		item = _tmp18_;
		_tmp19_ = item;
		gtk_check_menu_item_set_active (_tmp19_, !PLANK_IS_TRANSIENT_DOCK_ITEM (self));
		_tmp20_ = item;
		g_signal_connect_object ((GtkMenuItem*) _tmp20_, "activate", (GCallback) ____lambda40__gtk_menu_item_activate, self, 0);
		_tmp21_ = items;
		_tmp22_ = item;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp21_, (GtkMenuItem*) _tmp22_);
		_g_object_unref0 (item);
	}
	_data7_->event_time = gtk_get_current_event_time ();
	if (plank_application_dock_item_is_running (self)) {
		_tmp23_ = window_count > ((guint) 0);
	} else {
		_tmp23_ = FALSE;
	}
	if (_tmp23_) {
		const gchar* _tmp24_ = NULL;
		GtkMenuItem* item = NULL;
		GtkMenuItem* _tmp25_;
		GtkMenuItem* _tmp26_;
		GeeArrayList* _tmp27_;
		GtkMenuItem* _tmp28_;
		if (window_count > ((guint) 1)) {
			_tmp24_ = _ ("_Close All");
		} else {
			_tmp24_ = _ ("_Close");
		}
		_tmp25_ = plank_dock_element_create_menu_item (_tmp24_, "window-close-symbolic;;window-close", FALSE);
		item = _tmp25_;
		_tmp26_ = item;
		g_signal_connect_data (_tmp26_, "activate", (GCallback) ____lambda41__gtk_menu_item_activate, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
		_tmp27_ = items;
		_tmp28_ = item;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp27_, _tmp28_);
		_g_object_unref0 (item);
	}
	if (!plank_application_dock_item_is_window (self)) {
		GeeArrayList* _tmp30_;
		gint _tmp31_;
		gint _tmp32_;
		_tmp30_ = self->priv->actions;
		_tmp31_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp30_);
		_tmp32_ = _tmp31_;
		_tmp29_ = _tmp32_ > 0;
	} else {
		_tmp29_ = FALSE;
	}
	if (_tmp29_) {
		GeeArrayList* _tmp33_;
		gint _tmp34_;
		gint _tmp35_;
		_tmp33_ = items;
		_tmp34_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp33_);
		_tmp35_ = _tmp34_;
		if (_tmp35_ > 0) {
			GeeArrayList* _tmp36_;
			GtkSeparatorMenuItem* _tmp37_;
			GtkSeparatorMenuItem* _tmp38_;
			_tmp36_ = items;
			_tmp37_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
			g_object_ref_sink (_tmp37_);
			_tmp38_ = _tmp37_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp36_, (GtkMenuItem*) _tmp38_);
			_g_object_unref0 (_tmp38_);
		}
		{
			GeeArrayList* _s_list = NULL;
			GeeArrayList* _tmp39_;
			gint _s_size = 0;
			GeeArrayList* _tmp40_;
			gint _tmp41_;
			gint _tmp42_;
			gint _s_index = 0;
			_tmp39_ = self->priv->actions;
			_s_list = _tmp39_;
			_tmp40_ = _s_list;
			_tmp41_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp40_);
			_tmp42_ = _tmp41_;
			_s_size = _tmp42_;
			_s_index = -1;
			while (TRUE) {
				Block8Data* _data8_;
				gint _tmp43_;
				gint _tmp44_;
				gchar* s = NULL;
				GeeArrayList* _tmp45_;
				gpointer _tmp46_;
				GeeHashMap* _tmp47_;
				const gchar* _tmp48_;
				gpointer _tmp49_;
				gchar* _tmp50_;
				gchar** _tmp51_;
				gchar** _tmp52_;
				gchar** _tmp53_;
				gint _tmp53__length1;
				GtkMenuItem* item = NULL;
				const gchar* _tmp54_;
				gchar** _tmp55_;
				gint _tmp55__length1;
				const gchar* _tmp56_;
				GtkMenuItem* _tmp57_;
				GtkMenuItem* _tmp58_;
				GeeArrayList* _tmp59_;
				GtkMenuItem* _tmp60_;
				_data8_ = g_slice_new0 (Block8Data);
				_data8_->_ref_count_ = 1;
				_data8_->_data7_ = block7_data_ref (_data7_);
				_s_index = _s_index + 1;
				_tmp43_ = _s_index;
				_tmp44_ = _s_size;
				if (!(_tmp43_ < _tmp44_)) {
					block8_data_unref (_data8_);
					_data8_ = NULL;
					break;
				}
				_tmp45_ = _s_list;
				_tmp46_ = gee_abstract_list_get ((GeeAbstractList*) _tmp45_, _s_index);
				s = (gchar*) _tmp46_;
				_tmp47_ = self->priv->actions_map;
				_tmp48_ = s;
				_tmp49_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp47_, _tmp48_);
				_tmp50_ = (gchar*) _tmp49_;
				_tmp52_ = _tmp51_ = g_strsplit (_tmp50_, ";;", 0);
				_tmp53_ = _tmp52_;
				_tmp53__length1 = _vala_array_length (_tmp51_);
				_g_free0 (_tmp50_);
				_data8_->values = _tmp53_;
				_data8_->values_length1 = _tmp53__length1;
				_data8_->_values_size_ = _data8_->values_length1;
				_tmp54_ = s;
				_tmp55_ = _data8_->values;
				_tmp55__length1 = _data8_->values_length1;
				_tmp56_ = _tmp55_[1];
				_tmp57_ = plank_dock_element_create_menu_item (_tmp54_, _tmp56_, TRUE);
				item = _tmp57_;
				_tmp58_ = item;
				g_signal_connect_data (_tmp58_, "activate", (GCallback) ______lambda42__gtk_menu_item_activate, block8_data_ref (_data8_), (GClosureNotify) block8_data_unref, 0);
				_tmp59_ = items;
				_tmp60_ = item;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp59_, _tmp60_);
				_g_object_unref0 (item);
				_g_free0 (s);
				block8_data_unref (_data8_);
				_data8_ = NULL;
			}
		}
	}
	if (plank_application_dock_item_is_running (self)) {
		_tmp61_ = window_count > ((guint) 1);
	} else {
		_tmp61_ = FALSE;
	}
	if (_tmp61_) {
		GeeArrayList* _tmp62_;
		gint _tmp63_;
		gint _tmp64_;
		GList* _tmp68_;
		_tmp62_ = items;
		_tmp63_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp62_);
		_tmp64_ = _tmp63_;
		if (_tmp64_ > 0) {
			GeeArrayList* _tmp65_;
			GtkSeparatorMenuItem* _tmp66_;
			GtkSeparatorMenuItem* _tmp67_;
			_tmp65_ = items;
			_tmp66_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
			g_object_ref_sink (_tmp66_);
			_tmp67_ = _tmp66_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp65_, (GtkMenuItem*) _tmp67_);
			_g_object_unref0 (_tmp67_);
		}
		_tmp68_ = windows;
		{
			GList* view_collection = NULL;
			GList* view_it = NULL;
			view_collection = _tmp68_;
			for (view_it = view_collection; view_it != NULL; view_it = view_it->next) {
				BamfView* view = NULL;
				view = (BamfView*) view_it->data;
				{
					Block9Data* _data9_;
					BamfView* _tmp69_;
					gboolean _tmp70_ = FALSE;
					BamfWindow* _tmp71_;
					GtkMenuItem* window_item = NULL;
					GdkPixbuf* pbuf = NULL;
					BamfWindow* _tmp74_;
					GdkPixbuf* _tmp75_;
					GdkPixbuf* _tmp76_;
					gchar* window_name = NULL;
					BamfWindow* _tmp77_;
					gchar* _tmp78_;
					const gchar* _tmp79_;
					gchar* _tmp80_;
					GdkPixbuf* _tmp81_;
					BamfWindow* _tmp90_;
					GeeArrayList* _tmp93_;
					GtkMenuItem* _tmp94_;
					_data9_ = g_slice_new0 (Block9Data);
					_data9_->_ref_count_ = 1;
					_data9_->_data7_ = block7_data_ref (_data7_);
					_tmp69_ = view;
					_data9_->window = G_TYPE_CHECK_INSTANCE_TYPE (_tmp69_, bamf_window_get_type ()) ? ((BamfWindow*) _tmp69_) : NULL;
					_tmp71_ = _data9_->window;
					if (_tmp71_ == NULL) {
						_tmp70_ = TRUE;
					} else {
						BamfWindow* _tmp72_;
						BamfWindow* _tmp73_;
						_tmp72_ = _data9_->window;
						_tmp73_ = bamf_window_get_transient (_tmp72_);
						_tmp70_ = _tmp73_ != NULL;
					}
					if (_tmp70_) {
						block9_data_unref (_data9_);
						_data9_ = NULL;
						continue;
					}
					_tmp74_ = _data9_->window;
					_tmp75_ = plank_window_control_get_window_icon (_tmp74_);
					_tmp76_ = _g_object_ref0 (_tmp75_);
					pbuf = _tmp76_;
					_tmp77_ = _data9_->window;
					_tmp78_ = bamf_view_get_name ((BamfView*) _tmp77_);
					window_name = _tmp78_;
					_tmp79_ = window_name;
					_tmp80_ = plank_application_dock_item_shorten_window_name (self, _tmp79_);
					_g_free0 (window_name);
					window_name = _tmp80_;
					_tmp81_ = pbuf;
					if (_tmp81_ != NULL) {
						const gchar* _tmp82_;
						GdkPixbuf* _tmp83_;
						GdkPixbuf* _tmp84_;
						GtkMenuItem* _tmp85_;
						_tmp82_ = window_name;
						_tmp83_ = pbuf;
						_tmp84_ = _g_object_ref0 (_tmp83_);
						_tmp85_ = plank_dock_element_create_literal_menu_item_with_pixbuf (_tmp82_, _tmp84_, TRUE);
						_g_object_unref0 (window_item);
						window_item = _tmp85_;
					} else {
						const gchar* _tmp86_;
						const gchar* _tmp87_;
						const gchar* _tmp88_;
						GtkMenuItem* _tmp89_;
						_tmp86_ = window_name;
						_tmp87_ = plank_dock_item_get_Icon ((PlankDockItem*) self);
						_tmp88_ = _tmp87_;
						_tmp89_ = plank_dock_element_create_literal_menu_item (_tmp86_, _tmp88_, TRUE);
						_g_object_unref0 (window_item);
						window_item = _tmp89_;
					}
					_tmp90_ = _data9_->window;
					if (bamf_view_is_active ((BamfView*) _tmp90_)) {
						GtkMenuItem* _tmp91_;
						_tmp91_ = window_item;
						gtk_widget_set_sensitive ((GtkWidget*) _tmp91_, FALSE);
					} else {
						GtkMenuItem* _tmp92_;
						_tmp92_ = window_item;
						g_signal_connect_data (_tmp92_, "activate", (GCallback) _______lambda43__gtk_menu_item_activate, block9_data_ref (_data9_), (GClosureNotify) block9_data_unref, 0);
					}
					_tmp93_ = items;
					_tmp94_ = window_item;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp93_, _tmp94_);
					_g_free0 (window_name);
					_g_object_unref0 (pbuf);
					_g_object_unref0 (window_item);
					block9_data_unref (_data9_);
					_data9_ = NULL;
				}
			}
		}
	}
	result = items;
	(windows == NULL) ? NULL : (windows = (g_list_free (windows), NULL));
	block7_data_unref (_data7_);
	_data7_ = NULL;
	return result;
}

/**
 * {@inheritDoc}
 */
static gchar*
plank_application_dock_item_real_get_drop_text (PlankDockElement* base)
{
	PlankApplicationDockItem * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	self = (PlankApplicationDockItem*) base;
	_tmp0_ = plank_dock_element_get_Text ((PlankDockElement*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf (_ ("Drop to open with %s"), _tmp1_);
	result = _tmp2_;
	return result;
}

/**
 * {@inheritDoc}
 */
static gboolean
plank_application_dock_item_real_can_accept_drop (PlankDockElement* base,
                                                  GeeArrayList* uris)
{
	PlankApplicationDockItem * self;
	gboolean _tmp0_ = FALSE;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (PlankApplicationDockItem*) base;
	g_return_val_if_fail (uris != NULL, FALSE);
	if (uris == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = plank_application_dock_item_is_window (self);
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp1_ = self->priv->supported_mime_types;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == 0) {
		result = TRUE;
		return result;
	}
	{
		{
			GeeArrayList* _uri_list = NULL;
			gint _uri_size = 0;
			GeeArrayList* _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			gint _uri_index = 0;
			_uri_list = uris;
			_tmp4_ = _uri_list;
			_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
			_tmp6_ = _tmp5_;
			_uri_size = _tmp6_;
			_uri_index = -1;
			while (TRUE) {
				gint _tmp7_;
				gint _tmp8_;
				gchar* uri = NULL;
				GeeArrayList* _tmp9_;
				gpointer _tmp10_;
				GFileInfo* info = NULL;
				const gchar* _tmp11_;
				GFile* _tmp12_;
				GFile* _tmp13_;
				GFileInfo* _tmp14_;
				GFileInfo* _tmp15_;
				const gchar* uri_content_type = NULL;
				GFileInfo* _tmp16_;
				const gchar* _tmp17_;
				_uri_index = _uri_index + 1;
				_tmp7_ = _uri_index;
				_tmp8_ = _uri_size;
				if (!(_tmp7_ < _tmp8_)) {
					break;
				}
				_tmp9_ = _uri_list;
				_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _uri_index);
				uri = (gchar*) _tmp10_;
				_tmp11_ = uri;
				_tmp12_ = g_file_new_for_uri (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = g_file_query_info (_tmp13_, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
				_tmp15_ = _tmp14_;
				_g_object_unref0 (_tmp13_);
				info = _tmp15_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (uri);
					goto __catch0_g_error;
				}
				_tmp16_ = info;
				_tmp17_ = g_file_info_get_content_type (_tmp16_);
				uri_content_type = _tmp17_;
				{
					GeeArrayList* _content_type_list = NULL;
					GeeArrayList* _tmp18_;
					gint _content_type_size = 0;
					GeeArrayList* _tmp19_;
					gint _tmp20_;
					gint _tmp21_;
					gint _content_type_index = 0;
					_tmp18_ = self->priv->supported_mime_types;
					_content_type_list = _tmp18_;
					_tmp19_ = _content_type_list;
					_tmp20_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp19_);
					_tmp21_ = _tmp20_;
					_content_type_size = _tmp21_;
					_content_type_index = -1;
					while (TRUE) {
						gint _tmp22_;
						gint _tmp23_;
						gchar* content_type = NULL;
						GeeArrayList* _tmp24_;
						gpointer _tmp25_;
						gboolean _tmp26_ = FALSE;
						const gchar* _tmp27_;
						const gchar* _tmp28_;
						_content_type_index = _content_type_index + 1;
						_tmp22_ = _content_type_index;
						_tmp23_ = _content_type_size;
						if (!(_tmp22_ < _tmp23_)) {
							break;
						}
						_tmp24_ = _content_type_list;
						_tmp25_ = gee_abstract_list_get ((GeeAbstractList*) _tmp24_, _content_type_index);
						content_type = (gchar*) _tmp25_;
						_tmp27_ = uri_content_type;
						_tmp28_ = content_type;
						if (g_content_type_is_a (_tmp27_, _tmp28_)) {
							_tmp26_ = TRUE;
						} else {
							const gchar* _tmp29_;
							const gchar* _tmp30_;
							_tmp29_ = uri_content_type;
							_tmp30_ = content_type;
							_tmp26_ = g_content_type_equals (_tmp29_, _tmp30_);
						}
						if (_tmp26_) {
							result = TRUE;
							_g_free0 (content_type);
							_g_object_unref0 (info);
							_g_free0 (uri);
							return result;
						}
						_g_free0 (content_type);
					}
				}
				_g_object_unref0 (info);
				_g_free0 (uri);
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp31_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp31_;
	}
	result = FALSE;
	return result;
}

/**
 * {@inheritDoc}
 */
static gboolean
plank_application_dock_item_real_accept_drop (PlankDockElement* base,
                                              GeeArrayList* uris)
{
	PlankApplicationDockItem * self;
	GeeArrayList* files = NULL;
	GeeArrayList* _tmp0_;
	PlankSystem* _tmp12_;
	PlankDockItemPreferences* _tmp13_;
	PlankDockItemPreferences* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	GFile* _tmp17_;
	GFile* _tmp18_;
	GeeArrayList* _tmp19_;
	gint _tmp20_ = 0;
	gpointer* _tmp21_;
	GFile** _tmp22_;
	gint _tmp22__length1;
	gboolean result;
	self = (PlankApplicationDockItem*) base;
	g_return_val_if_fail (uris != NULL, FALSE);
	_tmp0_ = gee_array_list_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	files = _tmp0_;
	{
		GeeArrayList* _uri_list = NULL;
		gint _uri_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _uri_index = 0;
		_uri_list = uris;
		_tmp1_ = _uri_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_uri_size = _tmp3_;
		_uri_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			gchar* uri = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			GeeArrayList* _tmp8_;
			const gchar* _tmp9_;
			GFile* _tmp10_;
			GFile* _tmp11_;
			_uri_index = _uri_index + 1;
			_tmp4_ = _uri_index;
			_tmp5_ = _uri_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _uri_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _uri_index);
			uri = (gchar*) _tmp7_;
			_tmp8_ = files;
			_tmp9_ = uri;
			_tmp10_ = g_file_new_for_uri (_tmp9_);
			_tmp11_ = _tmp10_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp8_, _tmp11_);
			_g_object_unref0 (_tmp11_);
			_g_free0 (uri);
		}
	}
	_tmp12_ = plank_system_get_default ();
	_tmp13_ = plank_dock_item_get_Prefs ((PlankDockItem*) self);
	_tmp14_ = _tmp13_;
	_tmp15_ = plank_dock_item_preferences_get_Launcher (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = g_file_new_for_uri (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = files;
	_tmp21_ = gee_collection_to_array ((GeeCollection*) _tmp19_, &_tmp20_);
	_tmp22_ = _tmp21_;
	_tmp22__length1 = _tmp20_;
	plank_system_launch_with_files (_tmp12_, _tmp18_, _tmp22_, (gint) _tmp20_);
	_tmp22_ = (_vala_array_free (_tmp22_, _tmp22__length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (_tmp18_);
	result = TRUE;
	_g_object_unref0 (files);
	return result;
}

/**
 * {@inheritDoc}
 */
static void
plank_application_dock_item_real_load_from_launcher (PlankDockItem* base)
{
	PlankApplicationDockItem * self;
	PlankDockItemPreferences* _tmp0_;
	PlankDockItemPreferences* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* icon = NULL;
	gchar* text = NULL;
	PlankDockItemPreferences* _tmp4_;
	PlankDockItemPreferences* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	GeeArrayList* _tmp8_;
	GeeHashMap* _tmp9_;
	GeeArrayList* _tmp10_;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	self = (PlankApplicationDockItem*) base;
	_tmp0_ = plank_dock_item_get_Prefs ((PlankDockItem*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = plank_dock_item_preferences_get_Launcher (_tmp1_);
	_tmp3_ = _tmp2_;
	if (g_strcmp0 (_tmp3_, "") == 0) {
		return;
	}
	plank_application_dock_item_unity_update_application_uri (self);
	_tmp4_ = plank_dock_item_get_Prefs ((PlankDockItem*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = plank_dock_item_preferences_get_Launcher (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = self->priv->actions;
	_tmp9_ = self->priv->actions_map;
	_tmp10_ = self->priv->supported_mime_types;
	plank_application_dock_item_parse_launcher (_tmp7_, &_tmp11_, &_tmp12_, _tmp8_, (GeeMap*) _tmp9_, _tmp10_);
	_g_free0 (icon);
	icon = _tmp11_;
	_g_free0 (text);
	text = _tmp12_;
	_tmp13_ = icon;
	plank_dock_item_set_Icon ((PlankDockItem*) self, _tmp13_);
	plank_dock_item_set_ForcePixbuf ((PlankDockItem*) self, NULL);
	_tmp14_ = text;
	plank_dock_element_set_Text ((PlankDockElement*) self, _tmp14_);
	_g_free0 (text);
	_g_free0 (icon);
}

/**
 * Parses a launcher to get the text, icon and actions.
 *
 * @param launcher the launcher file (.desktop file) to parse
 * @param icon the icon key from the launcher
 * @param text the text key from the launcher
 * @param actions a list of all actions by name
 * @param actions_map a map of actions from name to exec;;icon
 * @param mimes a list of all supported mime types
 */
void
plank_application_dock_item_parse_launcher (const gchar* launcher,
                                            gchar** icon,
                                            gchar** text,
                                            GeeArrayList* actions,
                                            GeeMap* actions_map,
                                            GeeArrayList* mimes)
{
	gchar* _vala_icon = NULL;
	gchar* _vala_text = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GKeyFile* file = NULL;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (launcher != NULL);
	_tmp0_ = g_strdup ("");
	_g_free0 (_vala_icon);
	_vala_icon = _tmp0_;
	_tmp1_ = g_strdup ("");
	_g_free0 (_vala_text);
	_vala_text = _tmp1_;
	if (launcher == NULL) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = g_strcmp0 (launcher, "") == 0;
	}
	if (_tmp2_) {
		if (icon) {
			*icon = _vala_icon;
		} else {
			_g_free0 (_vala_icon);
		}
		if (text) {
			*text = _vala_text;
		} else {
			_g_free0 (_vala_text);
		}
		return;
	}
	{
		GKeyFile* _tmp3_;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		GKeyFile* _tmp6_;
		_tmp3_ = g_key_file_new ();
		_g_key_file_unref0 (file);
		file = _tmp3_;
		_tmp5_ = g_filename_from_uri (launcher, NULL, &_inner_error0_);
		_tmp4_ = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp6_ = file;
		g_key_file_load_from_file (_tmp6_, _tmp4_, 0, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp4_);
			goto __catch0_g_error;
		}
		_g_free0 (_tmp4_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_critical ("ApplicationDockItem.vala:576: %s: %s", launcher, _tmp8_);
		_g_error_free0 (e);
		_g_key_file_unref0 (file);
		if (icon) {
			*icon = _vala_icon;
		} else {
			_g_free0 (_vala_icon);
		}
		if (text) {
			*text = _vala_text;
		} else {
			_g_free0 (_vala_text);
		}
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_key_file_unref0 (file);
		_g_free0 (_vala_icon);
		_g_free0 (_vala_text);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	{
		gchar* _tmp9_ = NULL;
		GKeyFile* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gboolean _tmp13_ = FALSE;
		GKeyFile* _tmp14_;
		gchar* type = NULL;
		GKeyFile* _tmp19_;
		gchar* _tmp20_;
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		GQuark _tmp24_ = 0U;
		static GQuark _tmp23_label0 = 0;
		static GQuark _tmp23_label1 = 0;
		_tmp10_ = file;
		_tmp11_ = g_key_file_get_locale_string (_tmp10_, G_KEY_FILE_DESKTOP_GROUP, G_KEY_FILE_DESKTOP_KEY_NAME, NULL, &_inner_error0_);
		_tmp9_ = _tmp11_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch1_g_key_file_error;
			}
			_g_key_file_unref0 (file);
			_g_free0 (_vala_icon);
			_g_free0 (_vala_text);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp12_ = _tmp9_;
		_tmp9_ = NULL;
		_g_free0 (_vala_text);
		_vala_text = _tmp12_;
		_tmp14_ = file;
		_tmp13_ = g_key_file_has_key (_tmp14_, G_KEY_FILE_DESKTOP_GROUP, G_KEY_FILE_DESKTOP_KEY_ICON, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp9_);
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch1_g_key_file_error;
			}
			_g_key_file_unref0 (file);
			_g_free0 (_vala_icon);
			_g_free0 (_vala_text);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		if (_tmp13_) {
			gchar* _tmp15_ = NULL;
			GKeyFile* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			_tmp16_ = file;
			_tmp17_ = g_key_file_get_locale_string (_tmp16_, G_KEY_FILE_DESKTOP_GROUP, G_KEY_FILE_DESKTOP_KEY_ICON, NULL, &_inner_error0_);
			_tmp15_ = _tmp17_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (_tmp9_);
				if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
					goto __catch1_g_key_file_error;
				}
				_g_key_file_unref0 (file);
				_g_free0 (_vala_icon);
				_g_free0 (_vala_text);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_tmp18_ = _tmp15_;
			_tmp15_ = NULL;
			_g_free0 (_vala_icon);
			_vala_icon = _tmp18_;
			_g_free0 (_tmp15_);
		}
		_tmp19_ = file;
		_tmp20_ = g_key_file_get_string (_tmp19_, G_KEY_FILE_DESKTOP_GROUP, G_KEY_FILE_DESKTOP_KEY_TYPE, &_inner_error0_);
		type = _tmp20_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp9_);
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch1_g_key_file_error;
			}
			_g_key_file_unref0 (file);
			_g_free0 (_vala_icon);
			_g_free0 (_vala_text);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp21_ = type;
		_tmp22_ = _tmp21_;
		_tmp24_ = (NULL == _tmp22_) ? 0 : g_quark_from_string (_tmp22_);
		if (_tmp24_ == ((0 != _tmp23_label0) ? _tmp23_label0 : (_tmp23_label0 = g_quark_from_static_string (G_KEY_FILE_DESKTOP_TYPE_DIRECTORY)))) {
			switch (0) {
				default:
				{
					const gchar* _tmp25_;
					_tmp25_ = _vala_icon;
					if (g_strcmp0 (_tmp25_, "") == 0) {
						gchar* _tmp26_;
						_tmp26_ = g_strdup ("inode-directory");
						_g_free0 (_vala_icon);
						_vala_icon = _tmp26_;
					}
					_g_free0 (type);
					_g_free0 (_tmp9_);
					_g_key_file_unref0 (file);
					if (icon) {
						*icon = _vala_icon;
					} else {
						_g_free0 (_vala_icon);
					}
					if (text) {
						*text = _vala_text;
					} else {
						_g_free0 (_vala_text);
					}
					return;
				}
			}
		} else if (_tmp24_ == ((0 != _tmp23_label1) ? _tmp23_label1 : (_tmp23_label1 = g_quark_from_static_string (G_KEY_FILE_DESKTOP_TYPE_LINK)))) {
			switch (0) {
				default:
				{
					const gchar* _tmp27_;
					_tmp27_ = _vala_icon;
					if (g_strcmp0 (_tmp27_, "") == 0) {
						gchar* _tmp28_;
						_tmp28_ = g_strdup ("document");
						_g_free0 (_vala_icon);
						_vala_icon = _tmp28_;
					}
					_g_free0 (type);
					_g_free0 (_tmp9_);
					_g_key_file_unref0 (file);
					if (icon) {
						*icon = _vala_icon;
					} else {
						_g_free0 (_vala_icon);
					}
					if (text) {
						*text = _vala_text;
					} else {
						_g_free0 (_vala_text);
					}
					return;
				}
			}
		} else {
			switch (0) {
				default:
				{
					break;
				}
			}
		}
		_g_free0 (type);
		_g_free0 (_tmp9_);
	}
	goto __finally1;
	__catch1_g_key_file_error:
	{
		GError* e = NULL;
		GError* _tmp29_;
		const gchar* _tmp30_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp29_ = e;
		_tmp30_ = _tmp29_->message;
		g_critical ("ApplicationDockItem.vala:601: %s: %s", launcher, _tmp30_);
		_g_error_free0 (e);
		_g_key_file_unref0 (file);
		if (icon) {
			*icon = _vala_icon;
		} else {
			_g_free0 (_vala_icon);
		}
		if (text) {
			*text = _vala_text;
		} else {
			_g_free0 (_vala_text);
		}
		return;
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_key_file_unref0 (file);
		_g_free0 (_vala_icon);
		_g_free0 (_vala_text);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	{
		gboolean _tmp31_ = FALSE;
		gchar* textdomain = NULL;
		gboolean _tmp49_ = FALSE;
		if (mimes != NULL) {
			gboolean _tmp32_ = FALSE;
			GKeyFile* _tmp33_;
			_tmp33_ = file;
			_tmp32_ = g_key_file_has_key (_tmp33_, G_KEY_FILE_DESKTOP_GROUP, G_KEY_FILE_DESKTOP_KEY_MIME_TYPE, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
					goto __catch2_g_key_file_error;
				}
				_g_key_file_unref0 (file);
				_g_free0 (_vala_icon);
				_g_free0 (_vala_text);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_tmp31_ = _tmp32_;
		} else {
			_tmp31_ = FALSE;
		}
		if (_tmp31_) {
			gchar** mimestrings = NULL;
			GKeyFile* _tmp34_;
			gsize _tmp35_ = 0;
			gchar** _tmp36_;
			gint mimestrings_length1;
			gint _mimestrings_size_;
			gchar** _tmp37_;
			gint _tmp37__length1;
			_tmp34_ = file;
			_tmp36_ = g_key_file_get_string_list (_tmp34_, G_KEY_FILE_DESKTOP_GROUP, G_KEY_FILE_DESKTOP_KEY_MIME_TYPE, &_tmp35_, &_inner_error0_);
			mimestrings = _tmp36_;
			mimestrings_length1 = _tmp35_;
			_mimestrings_size_ = mimestrings_length1;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
					goto __catch2_g_key_file_error;
				}
				_g_key_file_unref0 (file);
				_g_free0 (_vala_icon);
				_g_free0 (_vala_text);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_tmp37_ = mimestrings;
			_tmp37__length1 = mimestrings_length1;
			{
				gchar** mime_collection = NULL;
				gint mime_collection_length1 = 0;
				gint _mime_collection_size_ = 0;
				gint mime_it = 0;
				mime_collection = _tmp37_;
				mime_collection_length1 = _tmp37__length1;
				for (mime_it = 0; mime_it < mime_collection_length1; mime_it = mime_it + 1) {
					const gchar* mime = NULL;
					mime = mime_collection[mime_it];
					{
						const gchar* _tmp38_;
						gchar* _tmp39_;
						gchar* _tmp40_;
						_tmp38_ = mime;
						_tmp39_ = g_content_type_from_mime_type (_tmp38_);
						_tmp40_ = _tmp39_;
						gee_abstract_collection_add ((GeeAbstractCollection*) mimes, _tmp40_);
						_g_free0 (_tmp40_);
					}
				}
			}
			mimestrings = (_vala_array_free (mimestrings, mimestrings_length1, (GDestroyNotify) g_free), NULL);
		}
		textdomain = NULL;
		{
			const gchar** domain_key_collection = NULL;
			gint domain_key_collection_length1 = 0;
			gint _domain_key_collection_size_ = 0;
			gint domain_key_it = 0;
			domain_key_collection = PLANK_APPLICATION_DOCK_ITEM_SUPPORTED_GETTEXT_DOMAINS_KEYS;
			domain_key_collection_length1 = G_N_ELEMENTS (PLANK_APPLICATION_DOCK_ITEM_SUPPORTED_GETTEXT_DOMAINS_KEYS);
			for (domain_key_it = 0; domain_key_it < domain_key_collection_length1; domain_key_it = domain_key_it + 1) {
				const gchar* domain_key = NULL;
				domain_key = domain_key_collection[domain_key_it];
				{
					gboolean _tmp41_ = FALSE;
					GKeyFile* _tmp42_;
					const gchar* _tmp43_;
					_tmp42_ = file;
					_tmp43_ = domain_key;
					_tmp41_ = g_key_file_has_key (_tmp42_, G_KEY_FILE_DESKTOP_GROUP, _tmp43_, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_free0 (textdomain);
						if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
							goto __catch2_g_key_file_error;
						}
						_g_key_file_unref0 (file);
						_g_free0 (_vala_icon);
						_g_free0 (_vala_text);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
					if (_tmp41_) {
						gchar* _tmp44_ = NULL;
						GKeyFile* _tmp45_;
						const gchar* _tmp46_;
						gchar* _tmp47_;
						gchar* _tmp48_;
						_tmp45_ = file;
						_tmp46_ = domain_key;
						_tmp47_ = g_key_file_get_string (_tmp45_, G_KEY_FILE_DESKTOP_GROUP, _tmp46_, &_inner_error0_);
						_tmp44_ = _tmp47_;
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							_g_free0 (textdomain);
							if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
								goto __catch2_g_key_file_error;
							}
							_g_key_file_unref0 (file);
							_g_free0 (_vala_icon);
							_g_free0 (_vala_text);
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return;
						}
						_tmp48_ = _tmp44_;
						_tmp44_ = NULL;
						_g_free0 (textdomain);
						textdomain = _tmp48_;
						_g_free0 (_tmp44_);
						break;
					}
				}
			}
		}
		if (actions != NULL) {
			_tmp49_ = actions_map != NULL;
		} else {
			_tmp49_ = FALSE;
		}
		if (_tmp49_) {
			gchar** keys = NULL;
			gchar* _tmp50_;
			gchar* _tmp51_;
			gchar** _tmp52_;
			gint keys_length1;
			gint _keys_size_;
			gchar** _tmp53_;
			gint _tmp53__length1;
			gee_abstract_collection_clear ((GeeAbstractCollection*) actions);
			gee_map_clear (actions_map);
			_tmp50_ = g_strdup (PLANK_APPLICATION_DOCK_ITEM_DESKTOP_ACTION_KEY);
			_tmp51_ = g_strdup (PLANK_APPLICATION_DOCK_ITEM_UNITY_QUICKLISTS_KEY);
			_tmp52_ = g_new0 (gchar*, 2 + 1);
			_tmp52_[0] = _tmp50_;
			_tmp52_[1] = _tmp51_;
			keys = _tmp52_;
			keys_length1 = 2;
			_keys_size_ = keys_length1;
			_tmp53_ = keys;
			_tmp53__length1 = keys_length1;
			{
				gchar** key_collection = NULL;
				gint key_collection_length1 = 0;
				gint _key_collection_size_ = 0;
				gint key_it = 0;
				key_collection = _tmp53_;
				key_collection_length1 = _tmp53__length1;
				for (key_it = 0; key_it < key_collection_length1; key_it = key_it + 1) {
					const gchar* key = NULL;
					key = key_collection[key_it];
					{
						gboolean _tmp54_ = FALSE;
						GKeyFile* _tmp55_;
						const gchar* _tmp56_;
						gchar** _tmp57_ = NULL;
						GKeyFile* _tmp58_;
						const gchar* _tmp59_;
						gsize _tmp60_ = 0;
						gchar** _tmp61_;
						gint _tmp57__length1;
						gint __tmp57__size_;
						_tmp55_ = file;
						_tmp56_ = key;
						_tmp54_ = g_key_file_has_key (_tmp55_, G_KEY_FILE_DESKTOP_GROUP, _tmp56_, &_inner_error0_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (textdomain);
							if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
								goto __catch2_g_key_file_error;
							}
							_g_key_file_unref0 (file);
							_g_free0 (_vala_icon);
							_g_free0 (_vala_text);
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return;
						}
						if (!_tmp54_) {
							continue;
						}
						_tmp58_ = file;
						_tmp59_ = key;
						_tmp61_ = g_key_file_get_string_list (_tmp58_, G_KEY_FILE_DESKTOP_GROUP, _tmp59_, &_tmp60_, &_inner_error0_);
						_tmp57_ = _tmp61_;
						_tmp57__length1 = _tmp60_;
						__tmp57__size_ = _tmp57__length1;
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (textdomain);
							if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
								goto __catch2_g_key_file_error;
							}
							_g_key_file_unref0 (file);
							_g_free0 (_vala_icon);
							_g_free0 (_vala_text);
							g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return;
						}
						{
							gchar** action_collection = NULL;
							gint action_collection_length1 = 0;
							gint _action_collection_size_ = 0;
							gint action_it = 0;
							action_collection = _tmp57_;
							action_collection_length1 = _tmp57__length1;
							for (action_it = 0; action_it < action_collection_length1; action_it = action_it + 1) {
								const gchar* action = NULL;
								action = action_collection[action_it];
								{
									gchar* group = NULL;
									const gchar* _tmp62_;
									gchar* _tmp63_;
									GKeyFile* _tmp64_;
									const gchar* _tmp65_;
									gboolean _tmp70_ = FALSE;
									GKeyFile* _tmp71_;
									const gchar* _tmp72_;
									gboolean _tmp79_ = FALSE;
									GKeyFile* _tmp80_;
									const gchar* _tmp81_;
									gboolean _tmp88_ = FALSE;
									GKeyFile* _tmp89_;
									const gchar* _tmp90_;
									gchar* action_name = NULL;
									GKeyFile* _tmp99_;
									const gchar* _tmp100_;
									gchar* _tmp101_;
									gchar* action_icon = NULL;
									gchar* _tmp102_;
									gboolean _tmp103_ = FALSE;
									GKeyFile* _tmp104_;
									const gchar* _tmp105_;
									gchar* action_exec = NULL;
									gchar* _tmp111_;
									gboolean _tmp112_ = FALSE;
									GKeyFile* _tmp113_;
									const gchar* _tmp114_;
									const gchar* _tmp120_;
									const gchar* _tmp124_;
									const gchar* _tmp125_;
									const gchar* _tmp126_;
									const gchar* _tmp127_;
									gchar* _tmp128_;
									gchar* _tmp129_;
									_tmp62_ = action;
									_tmp63_ = g_strdup_printf (PLANK_APPLICATION_DOCK_ITEM_DESKTOP_ACTION_GROUP_NAME, _tmp62_);
									group = _tmp63_;
									_tmp64_ = file;
									_tmp65_ = group;
									if (!g_key_file_has_group (_tmp64_, _tmp65_)) {
										const gchar* _tmp66_;
										gchar* _tmp67_;
										GKeyFile* _tmp68_;
										const gchar* _tmp69_;
										_tmp66_ = action;
										_tmp67_ = g_strdup_printf (PLANK_APPLICATION_DOCK_ITEM_UNITY_QUICKLISTS_SHORTCUT_GROUP_NAME, _tmp66_);
										_g_free0 (group);
										group = _tmp67_;
										_tmp68_ = file;
										_tmp69_ = group;
										if (!g_key_file_has_group (_tmp68_, _tmp69_)) {
											_g_free0 (group);
											continue;
										}
									}
									_tmp71_ = file;
									_tmp72_ = group;
									_tmp70_ = g_key_file_has_key (_tmp71_, _tmp72_, PLANK_APPLICATION_DOCK_ITEM_UNITY_QUICKLISTS_TARGET_KEY, &_inner_error0_);
									if (G_UNLIKELY (_inner_error0_ != NULL)) {
										_g_free0 (group);
										_tmp57_ = (_vala_array_free (_tmp57_, _tmp57__length1, (GDestroyNotify) g_free), NULL);
										keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
										_g_free0 (textdomain);
										if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
											goto __catch2_g_key_file_error;
										}
										_g_key_file_unref0 (file);
										_g_free0 (_vala_icon);
										_g_free0 (_vala_text);
										g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
										g_clear_error (&_inner_error0_);
										return;
									}
									if (_tmp70_) {
										gchar* target = NULL;
										GKeyFile* _tmp73_;
										const gchar* _tmp74_;
										gchar* _tmp75_;
										gboolean _tmp76_ = FALSE;
										const gchar* _tmp77_;
										_tmp73_ = file;
										_tmp74_ = group;
										_tmp75_ = g_key_file_get_string (_tmp73_, _tmp74_, PLANK_APPLICATION_DOCK_ITEM_UNITY_QUICKLISTS_TARGET_KEY, &_inner_error0_);
										target = _tmp75_;
										if (G_UNLIKELY (_inner_error0_ != NULL)) {
											_g_free0 (group);
											_tmp57_ = (_vala_array_free (_tmp57_, _tmp57__length1, (GDestroyNotify) g_free), NULL);
											keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
											_g_free0 (textdomain);
											if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
												goto __catch2_g_key_file_error;
											}
											_g_key_file_unref0 (file);
											_g_free0 (_vala_icon);
											_g_free0 (_vala_text);
											g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
											g_clear_error (&_inner_error0_);
											return;
										}
										_tmp77_ = target;
										if (g_strcmp0 (_tmp77_, PLANK_APPLICATION_DOCK_ITEM_UNITY_QUICKLISTS_TARGET_VALUE) != 0) {
											const gchar* _tmp78_;
											_tmp78_ = target;
											_tmp76_ = g_strcmp0 (_tmp78_, "Plank") != 0;
										} else {
											_tmp76_ = FALSE;
										}
										if (_tmp76_) {
											_g_free0 (target);
											_g_free0 (group);
											continue;
										}
										_g_free0 (target);
									}
									_tmp80_ = file;
									_tmp81_ = group;
									_tmp79_ = g_key_file_has_key (_tmp80_, _tmp81_, G_KEY_FILE_DESKTOP_KEY_NOT_SHOW_IN, &_inner_error0_);
									if (G_UNLIKELY (_inner_error0_ != NULL)) {
										_g_free0 (group);
										_tmp57_ = (_vala_array_free (_tmp57_, _tmp57__length1, (GDestroyNotify) g_free), NULL);
										keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
										_g_free0 (textdomain);
										if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
											goto __catch2_g_key_file_error;
										}
										_g_key_file_unref0 (file);
										_g_free0 (_vala_icon);
										_g_free0 (_vala_text);
										g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
										g_clear_error (&_inner_error0_);
										return;
									}
									if (_tmp79_) {
										gboolean found = FALSE;
										gchar** _tmp82_ = NULL;
										GKeyFile* _tmp83_;
										const gchar* _tmp84_;
										gsize _tmp85_ = 0;
										gchar** _tmp86_;
										gint _tmp82__length1;
										gint __tmp82__size_;
										found = FALSE;
										_tmp83_ = file;
										_tmp84_ = group;
										_tmp86_ = g_key_file_get_string_list (_tmp83_, _tmp84_, G_KEY_FILE_DESKTOP_KEY_NOT_SHOW_IN, &_tmp85_, &_inner_error0_);
										_tmp82_ = _tmp86_;
										_tmp82__length1 = _tmp85_;
										__tmp82__size_ = _tmp82__length1;
										if (G_UNLIKELY (_inner_error0_ != NULL)) {
											_g_free0 (group);
											_tmp57_ = (_vala_array_free (_tmp57_, _tmp57__length1, (GDestroyNotify) g_free), NULL);
											keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
											_g_free0 (textdomain);
											if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
												goto __catch2_g_key_file_error;
											}
											_g_key_file_unref0 (file);
											_g_free0 (_vala_icon);
											_g_free0 (_vala_text);
											g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
											g_clear_error (&_inner_error0_);
											return;
										}
										{
											gchar** s_collection = NULL;
											gint s_collection_length1 = 0;
											gint _s_collection_size_ = 0;
											gint s_it = 0;
											s_collection = _tmp82_;
											s_collection_length1 = _tmp82__length1;
											for (s_it = 0; s_it < s_collection_length1; s_it = s_it + 1) {
												const gchar* s = NULL;
												s = s_collection[s_it];
												{
													const gchar* _tmp87_;
													_tmp87_ = s;
													if (g_strcmp0 (_tmp87_, "Plank") == 0) {
														found = TRUE;
														break;
													}
												}
											}
										}
										if (found) {
											_tmp82_ = (_vala_array_free (_tmp82_, _tmp82__length1, (GDestroyNotify) g_free), NULL);
											_g_free0 (group);
											continue;
										}
										_tmp82_ = (_vala_array_free (_tmp82_, _tmp82__length1, (GDestroyNotify) g_free), NULL);
									}
									_tmp89_ = file;
									_tmp90_ = group;
									_tmp88_ = g_key_file_has_key (_tmp89_, _tmp90_, G_KEY_FILE_DESKTOP_KEY_ONLY_SHOW_IN, &_inner_error0_);
									if (G_UNLIKELY (_inner_error0_ != NULL)) {
										_g_free0 (group);
										_tmp57_ = (_vala_array_free (_tmp57_, _tmp57__length1, (GDestroyNotify) g_free), NULL);
										keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
										_g_free0 (textdomain);
										if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
											goto __catch2_g_key_file_error;
										}
										_g_key_file_unref0 (file);
										_g_free0 (_vala_icon);
										_g_free0 (_vala_text);
										g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
										g_clear_error (&_inner_error0_);
										return;
									}
									if (_tmp88_) {
										gboolean found = FALSE;
										gchar** _tmp91_ = NULL;
										GKeyFile* _tmp92_;
										const gchar* _tmp93_;
										gsize _tmp94_ = 0;
										gchar** _tmp95_;
										gint _tmp91__length1;
										gint __tmp91__size_;
										found = FALSE;
										_tmp92_ = file;
										_tmp93_ = group;
										_tmp95_ = g_key_file_get_string_list (_tmp92_, _tmp93_, G_KEY_FILE_DESKTOP_KEY_ONLY_SHOW_IN, &_tmp94_, &_inner_error0_);
										_tmp91_ = _tmp95_;
										_tmp91__length1 = _tmp94_;
										__tmp91__size_ = _tmp91__length1;
										if (G_UNLIKELY (_inner_error0_ != NULL)) {
											_g_free0 (group);
											_tmp57_ = (_vala_array_free (_tmp57_, _tmp57__length1, (GDestroyNotify) g_free), NULL);
											keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
											_g_free0 (textdomain);
											if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
												goto __catch2_g_key_file_error;
											}
											_g_key_file_unref0 (file);
											_g_free0 (_vala_icon);
											_g_free0 (_vala_text);
											g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
											g_clear_error (&_inner_error0_);
											return;
										}
										{
											gchar** s_collection = NULL;
											gint s_collection_length1 = 0;
											gint _s_collection_size_ = 0;
											gint s_it = 0;
											s_collection = _tmp91_;
											s_collection_length1 = _tmp91__length1;
											for (s_it = 0; s_it < s_collection_length1; s_it = s_it + 1) {
												const gchar* s = NULL;
												s = s_collection[s_it];
												{
													gboolean _tmp96_ = FALSE;
													const gchar* _tmp97_;
													_tmp97_ = s;
													if (g_strcmp0 (_tmp97_, PLANK_APPLICATION_DOCK_ITEM_UNITY_QUICKLISTS_TARGET_VALUE) == 0) {
														_tmp96_ = TRUE;
													} else {
														const gchar* _tmp98_;
														_tmp98_ = s;
														_tmp96_ = g_strcmp0 (_tmp98_, "Plank") == 0;
													}
													if (_tmp96_) {
														found = TRUE;
														break;
													}
												}
											}
										}
										if (!found) {
											_tmp91_ = (_vala_array_free (_tmp91_, _tmp91__length1, (GDestroyNotify) g_free), NULL);
											_g_free0 (group);
											continue;
										}
										_tmp91_ = (_vala_array_free (_tmp91_, _tmp91__length1, (GDestroyNotify) g_free), NULL);
									}
									_tmp99_ = file;
									_tmp100_ = group;
									_tmp101_ = g_key_file_get_locale_string (_tmp99_, _tmp100_, G_KEY_FILE_DESKTOP_KEY_NAME, NULL, &_inner_error0_);
									action_name = _tmp101_;
									if (G_UNLIKELY (_inner_error0_ != NULL)) {
										_g_free0 (group);
										_tmp57_ = (_vala_array_free (_tmp57_, _tmp57__length1, (GDestroyNotify) g_free), NULL);
										keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
										_g_free0 (textdomain);
										if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
											goto __catch2_g_key_file_error;
										}
										_g_key_file_unref0 (file);
										_g_free0 (_vala_icon);
										_g_free0 (_vala_text);
										g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
										g_clear_error (&_inner_error0_);
										return;
									}
									_tmp102_ = g_strdup ("");
									action_icon = _tmp102_;
									_tmp104_ = file;
									_tmp105_ = group;
									_tmp103_ = g_key_file_has_key (_tmp104_, _tmp105_, G_KEY_FILE_DESKTOP_KEY_ICON, &_inner_error0_);
									if (G_UNLIKELY (_inner_error0_ != NULL)) {
										_g_free0 (action_icon);
										_g_free0 (action_name);
										_g_free0 (group);
										_tmp57_ = (_vala_array_free (_tmp57_, _tmp57__length1, (GDestroyNotify) g_free), NULL);
										keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
										_g_free0 (textdomain);
										if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
											goto __catch2_g_key_file_error;
										}
										_g_key_file_unref0 (file);
										_g_free0 (_vala_icon);
										_g_free0 (_vala_text);
										g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
										g_clear_error (&_inner_error0_);
										return;
									}
									if (_tmp103_) {
										gchar* _tmp106_ = NULL;
										GKeyFile* _tmp107_;
										const gchar* _tmp108_;
										gchar* _tmp109_;
										gchar* _tmp110_;
										_tmp107_ = file;
										_tmp108_ = group;
										_tmp109_ = g_key_file_get_locale_string (_tmp107_, _tmp108_, G_KEY_FILE_DESKTOP_KEY_ICON, NULL, &_inner_error0_);
										_tmp106_ = _tmp109_;
										if (G_UNLIKELY (_inner_error0_ != NULL)) {
											_g_free0 (action_icon);
											_g_free0 (action_name);
											_g_free0 (group);
											_tmp57_ = (_vala_array_free (_tmp57_, _tmp57__length1, (GDestroyNotify) g_free), NULL);
											keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
											_g_free0 (textdomain);
											if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
												goto __catch2_g_key_file_error;
											}
											_g_key_file_unref0 (file);
											_g_free0 (_vala_icon);
											_g_free0 (_vala_text);
											g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
											g_clear_error (&_inner_error0_);
											return;
										}
										_tmp110_ = _tmp106_;
										_tmp106_ = NULL;
										_g_free0 (action_icon);
										action_icon = _tmp110_;
										_g_free0 (_tmp106_);
									}
									_tmp111_ = g_strdup ("");
									action_exec = _tmp111_;
									_tmp113_ = file;
									_tmp114_ = group;
									_tmp112_ = g_key_file_has_key (_tmp113_, _tmp114_, G_KEY_FILE_DESKTOP_KEY_EXEC, &_inner_error0_);
									if (G_UNLIKELY (_inner_error0_ != NULL)) {
										_g_free0 (action_exec);
										_g_free0 (action_icon);
										_g_free0 (action_name);
										_g_free0 (group);
										_tmp57_ = (_vala_array_free (_tmp57_, _tmp57__length1, (GDestroyNotify) g_free), NULL);
										keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
										_g_free0 (textdomain);
										if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
											goto __catch2_g_key_file_error;
										}
										_g_key_file_unref0 (file);
										_g_free0 (_vala_icon);
										_g_free0 (_vala_text);
										g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
										g_clear_error (&_inner_error0_);
										return;
									}
									if (_tmp112_) {
										gchar* _tmp115_ = NULL;
										GKeyFile* _tmp116_;
										const gchar* _tmp117_;
										gchar* _tmp118_;
										gchar* _tmp119_;
										_tmp116_ = file;
										_tmp117_ = group;
										_tmp118_ = g_key_file_get_string (_tmp116_, _tmp117_, G_KEY_FILE_DESKTOP_KEY_EXEC, &_inner_error0_);
										_tmp115_ = _tmp118_;
										if (G_UNLIKELY (_inner_error0_ != NULL)) {
											_g_free0 (action_exec);
											_g_free0 (action_icon);
											_g_free0 (action_name);
											_g_free0 (group);
											_tmp57_ = (_vala_array_free (_tmp57_, _tmp57__length1, (GDestroyNotify) g_free), NULL);
											keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
											_g_free0 (textdomain);
											if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
												goto __catch2_g_key_file_error;
											}
											_g_key_file_unref0 (file);
											_g_free0 (_vala_icon);
											_g_free0 (_vala_text);
											g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
											g_clear_error (&_inner_error0_);
											return;
										}
										_tmp119_ = _tmp115_;
										_tmp115_ = NULL;
										_g_free0 (action_exec);
										action_exec = _tmp119_;
										_g_free0 (_tmp115_);
									}
									_tmp120_ = textdomain;
									if (_tmp120_ != NULL) {
										const gchar* _tmp121_;
										const gchar* _tmp122_;
										gchar* _tmp123_;
										_tmp121_ = textdomain;
										_tmp122_ = action_name;
										_tmp123_ = g_strdup (g_dgettext (_tmp121_, _tmp122_));
										_g_free0 (action_name);
										action_name = _tmp123_;
									}
									_tmp124_ = action_name;
									gee_abstract_collection_add ((GeeAbstractCollection*) actions, _tmp124_);
									_tmp125_ = action_name;
									_tmp126_ = action_exec;
									_tmp127_ = action_icon;
									_tmp128_ = g_strdup_printf ("%s;;%s", _tmp126_, _tmp127_);
									_tmp129_ = _tmp128_;
									gee_map_set (actions_map, _tmp125_, _tmp129_);
									_g_free0 (_tmp129_);
									_g_free0 (action_exec);
									_g_free0 (action_icon);
									_g_free0 (action_name);
									_g_free0 (group);
								}
							}
						}
						_tmp57_ = (_vala_array_free (_tmp57_, _tmp57__length1, (GDestroyNotify) g_free), NULL);
					}
				}
			}
			keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
		}
		_g_free0 (textdomain);
	}
	goto __finally2;
	__catch2_g_key_file_error:
	{
		GError* e = NULL;
		GError* _tmp130_;
		const gchar* _tmp131_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp130_ = e;
		_tmp131_ = _tmp130_->message;
		g_critical ("ApplicationDockItem.vala:696: %s: %s", launcher, _tmp131_);
		_g_error_free0 (e);
		_g_key_file_unref0 (file);
		if (icon) {
			*icon = _vala_icon;
		} else {
			_g_free0 (_vala_icon);
		}
		if (text) {
			*text = _vala_text;
		} else {
			_g_free0 (_vala_text);
		}
		return;
	}
	__finally2:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_key_file_unref0 (file);
		_g_free0 (_vala_icon);
		_g_free0 (_vala_text);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_key_file_unref0 (file);
	if (icon) {
		*icon = _vala_icon;
	} else {
		_g_free0 (_vala_icon);
	}
	if (text) {
		*text = _vala_text;
	} else {
		_g_free0 (_vala_text);
	}
}

static void
plank_application_dock_item_unity_update_application_uri (PlankApplicationDockItem* self)
{
	const gchar* _tmp0_ = NULL;
	BamfApplication* _tmp1_;
	BamfApplication* _tmp2_;
	const gchar* desktop_file = NULL;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp9_;
	gchar** p = NULL;
	const gchar* _tmp11_;
	gchar** _tmp12_;
	gchar** _tmp13_;
	gint p_length1;
	gint _p_size_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	gchar** _tmp15_;
	gint _tmp15__length1;
	gchar** _tmp16_;
	gint _tmp16__length1;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	g_return_if_fail (self != NULL);
	_g_free0 (self->priv->unity_application_uri);
	self->priv->unity_application_uri = NULL;
	_tmp1_ = plank_application_dock_item_get_App (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		BamfApplication* _tmp3_;
		BamfApplication* _tmp4_;
		const gchar* _tmp5_;
		_tmp3_ = plank_application_dock_item_get_App (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = bamf_application_get_desktop_file (_tmp4_);
		_tmp0_ = _tmp5_;
	} else {
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp6_ = plank_dock_item_get_Launcher ((PlankDockItem*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = _tmp7_;
	}
	desktop_file = _tmp0_;
	_tmp9_ = desktop_file;
	if (_tmp9_ == NULL) {
		_tmp8_ = TRUE;
	} else {
		const gchar* _tmp10_;
		_tmp10_ = desktop_file;
		_tmp8_ = g_strcmp0 (_tmp10_, "") == 0;
	}
	if (_tmp8_) {
		return;
	}
	_tmp11_ = desktop_file;
	_tmp13_ = _tmp12_ = g_strsplit (_tmp11_, "/", 0);
	p = _tmp13_;
	p_length1 = _vala_array_length (_tmp12_);
	_p_size_ = p_length1;
	_tmp14_ = p;
	_tmp14__length1 = p_length1;
	if (_tmp14__length1 == 0) {
		p = (_vala_array_free (p, p_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	_tmp15_ = p;
	_tmp15__length1 = p_length1;
	_tmp16_ = p;
	_tmp16__length1 = p_length1;
	_tmp17_ = _tmp15_[_tmp16__length1 - 1];
	_tmp18_ = g_strdup_printf ("application://%s", _tmp17_);
	_g_free0 (self->priv->unity_application_uri);
	self->priv->unity_application_uri = _tmp18_;
	p = (_vala_array_free (p, p_length1, (GDestroyNotify) g_free), NULL);
}

/**
 * Get libunity application URI
 *
 * @return the libunity application uri of this item, or NULL
 */
const gchar*
plank_application_dock_item_get_unity_application_uri (PlankApplicationDockItem* self)
{
	const gchar* _tmp0_;
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->unity_application_uri;
	result = _tmp0_;
	return result;
}

/**
 * Get current libunity dbusname
 *
 * @return the dbusname which provides the LauncherEntry interface, or NULL
 */
const gchar*
plank_application_dock_item_get_unity_dbusname (PlankApplicationDockItem* self)
{
	const gchar* _tmp0_;
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->unity_dbusname;
	result = _tmp0_;
	return result;
}

/**
 * Whether this item provides information worth showing
 */
gboolean
plank_application_dock_item_has_unity_info (PlankApplicationDockItem* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = plank_dock_item_get_ProgressVisible ((PlankDockItem*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp3_ = plank_dock_item_get_CountVisible ((PlankDockItem*) self);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	}
	result = _tmp0_;
	return result;
}

/**
 * Update this item's remote libunity value based on the given data
 *
 * @param sender_name the corressponding dbusname
 * @param prop_iter the data in a standardize format from libunity
 */
void
plank_application_dock_item_unity_update (PlankApplicationDockItem* self,
                                          const gchar* sender_name,
                                          GVariantIter* prop_iter)
{
	gchar* _tmp0_;
	gchar* prop_key = NULL;
	GVariant* prop_value = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sender_name != NULL);
	g_return_if_fail (prop_iter != NULL);
	_tmp0_ = g_strdup (sender_name);
	_g_free0 (self->priv->unity_dbusname);
	self->priv->unity_dbusname = _tmp0_;
	while (TRUE) {
		gchar* _tmp1_ = NULL;
		GVariant* _tmp2_ = NULL;
		gboolean _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = g_variant_iter_next (prop_iter, "{sv}", &_tmp1_, &_tmp2_, NULL);
		_g_free0 (prop_key);
		prop_key = _tmp1_;
		_g_variant_unref0 (prop_value);
		prop_value = _tmp2_;
		if (!_tmp3_) {
			break;
		}
		_tmp4_ = prop_key;
		if (g_strcmp0 (_tmp4_, "count") == 0) {
			gint64 val = 0LL;
			GVariant* _tmp5_;
			gint64 _tmp6_;
			gint64 _tmp7_;
			_tmp5_ = prop_value;
			val = g_variant_get_int64 (_tmp5_);
			_tmp6_ = plank_dock_item_get_Count ((PlankDockItem*) self);
			_tmp7_ = _tmp6_;
			if (_tmp7_ != val) {
				plank_dock_item_set_Count ((PlankDockItem*) self, val);
			}
		} else {
			const gchar* _tmp8_;
			_tmp8_ = prop_key;
			if (g_strcmp0 (_tmp8_, "count-visible") == 0) {
				gboolean val = FALSE;
				GVariant* _tmp9_;
				gboolean _tmp10_;
				gboolean _tmp11_;
				_tmp9_ = prop_value;
				val = g_variant_get_boolean (_tmp9_);
				_tmp10_ = plank_dock_item_get_CountVisible ((PlankDockItem*) self);
				_tmp11_ = _tmp10_;
				if (_tmp11_ != val) {
					plank_dock_item_set_CountVisible ((PlankDockItem*) self, val);
				}
			} else {
				const gchar* _tmp12_;
				_tmp12_ = prop_key;
				if (g_strcmp0 (_tmp12_, "progress") == 0) {
					gdouble val = 0.0;
					GVariant* _tmp13_;
					gdouble _tmp14_;
					gdouble _tmp15_;
					_tmp13_ = prop_value;
					val = plank_nround (g_variant_get_double (_tmp13_), 3U);
					_tmp14_ = plank_dock_item_get_Progress ((PlankDockItem*) self);
					_tmp15_ = _tmp14_;
					if (_tmp15_ != val) {
						plank_dock_item_set_Progress ((PlankDockItem*) self, val);
					}
				} else {
					const gchar* _tmp16_;
					_tmp16_ = prop_key;
					if (g_strcmp0 (_tmp16_, "progress-visible") == 0) {
						gboolean val = FALSE;
						GVariant* _tmp17_;
						gboolean _tmp18_;
						gboolean _tmp19_;
						_tmp17_ = prop_value;
						val = g_variant_get_boolean (_tmp17_);
						_tmp18_ = plank_dock_item_get_ProgressVisible ((PlankDockItem*) self);
						_tmp19_ = _tmp18_;
						if (_tmp19_ != val) {
							plank_dock_item_set_ProgressVisible ((PlankDockItem*) self, val);
						}
					} else {
						const gchar* _tmp20_;
						_tmp20_ = prop_key;
						if (g_strcmp0 (_tmp20_, "urgent") == 0) {
							GVariant* _tmp21_;
							_tmp21_ = prop_value;
							plank_application_dock_item_set_urgent (self, g_variant_get_boolean (_tmp21_));
						}
					}
				}
			}
		}
	}
	_g_variant_unref0 (prop_value);
	_g_free0 (prop_key);
}

/**
 * Reset this item's remote libunity values
 */
void
plank_application_dock_item_unity_reset (PlankApplicationDockItem* self)
{
	g_return_if_fail (self != NULL);
	_g_free0 (self->priv->unity_dbusname);
	self->priv->unity_dbusname = NULL;
	plank_dock_item_set_Count ((PlankDockItem*) self, (gint64) 0);
	plank_dock_item_set_CountVisible ((PlankDockItem*) self, FALSE);
	plank_dock_item_set_Progress ((PlankDockItem*) self, 0.0);
	plank_dock_item_set_ProgressVisible ((PlankDockItem*) self, FALSE);
	plank_application_dock_item_set_urgent (self, FALSE);
}

PlankApplicationDockItem*
plank_application_dock_item_construct (GType object_type)
{
	PlankApplicationDockItem * self = NULL;
	self = (PlankApplicationDockItem*) plank_dock_item_construct (object_type);
	return self;
}

PlankApplicationDockItem*
plank_application_dock_item_new (void)
{
	return plank_application_dock_item_construct (PLANK_TYPE_APPLICATION_DOCK_ITEM);
}

BamfApplication*
plank_application_dock_item_get_App (PlankApplicationDockItem* self)
{
	BamfApplication* result;
	gboolean _tmp0_ = FALSE;
	BamfApplication* _tmp1_;
	gboolean _tmp3_ = FALSE;
	BamfApplication* _tmp4_;
	BamfApplication* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->app;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		BamfApplication* _tmp2_;
		_tmp2_ = self->priv->app;
		_tmp0_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, bamf_application_get_type ());
	}
	g_warn_if_fail (_tmp0_);
	_tmp4_ = self->priv->app;
	if (_tmp4_ != NULL) {
		BamfApplication* _tmp5_;
		_tmp5_ = self->priv->app;
		_tmp3_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, bamf_application_get_type ());
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		_g_object_unref0 (self->priv->app);
		self->priv->app = NULL;
	}
	_tmp6_ = self->priv->app;
	result = _tmp6_;
	return result;
}

void
plank_application_dock_item_set_App (PlankApplicationDockItem* self,
                                     BamfApplication* value)
{
	BamfApplication* _tmp0_;
	BamfApplication* _tmp1_;
	BamfApplication* _tmp3_;
	BamfApplication* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->app;
	if (_tmp0_ == value) {
		return;
	}
	_tmp1_ = self->priv->app;
	if (_tmp1_ != NULL) {
		BamfApplication* _tmp2_;
		_tmp2_ = self->priv->app;
		plank_application_dock_item_app_signals_disconnect (self, _tmp2_);
	}
	_tmp3_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->app);
	self->priv->app = _tmp3_;
	_tmp4_ = self->priv->app;
	if (_tmp4_ != NULL) {
		BamfApplication* _tmp5_;
		gboolean _tmp6_ = FALSE;
		BamfApplication* _tmp7_;
		_tmp5_ = self->priv->app;
		plank_application_dock_item_app_signals_connect (self, _tmp5_);
		plank_application_dock_item_initialize_states (self);
		_tmp7_ = self->priv->app;
		if (bamf_view_is_running ((BamfView*) _tmp7_)) {
			BamfApplication* _tmp8_;
			_tmp8_ = self->priv->app;
			_tmp6_ = bamf_view_is_user_visible ((BamfView*) _tmp8_);
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			g_signal_emit (self, plank_application_dock_item_signals[PLANK_APPLICATION_DOCK_ITEM_APP_WINDOW_ADDED_SIGNAL], 0);
		}
	} else {
		plank_application_dock_item_reset_application_status (self);
	}
	plank_application_dock_item_unity_update_application_uri (self);
	g_object_notify_by_pspec ((GObject *) self, plank_application_dock_item_properties[PLANK_APPLICATION_DOCK_ITEM_APP_PROPERTY]);
}

static GObject *
plank_application_dock_item_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PlankApplicationDockItem * self;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeHashMap* _tmp2_;
	parent_class = G_OBJECT_CLASS (plank_application_dock_item_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_TYPE_APPLICATION_DOCK_ITEM, PlankApplicationDockItem);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->supported_mime_types);
	self->priv->supported_mime_types = _tmp0_;
	_tmp1_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->actions);
	self->priv->actions = _tmp1_;
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->actions_map);
	self->priv->actions_map = _tmp2_;
	plank_dock_item_load_from_launcher ((PlankDockItem*) self);
	return obj;
}

static void
plank_application_dock_item_class_init (PlankApplicationDockItemClass * klass,
                                        gpointer klass_data)
{
	plank_application_dock_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PlankApplicationDockItem_private_offset);
	((PlankDockElementClass *) klass)->on_clicked = (PlankAnimationType (*) (PlankDockElement*, PlankPopupButton, GdkModifierType, guint32)) plank_application_dock_item_real_on_clicked;
	((PlankDockElementClass *) klass)->on_scrolled = (PlankAnimationType (*) (PlankDockElement*, GdkScrollDirection, GdkModifierType, guint32)) plank_application_dock_item_real_on_scrolled;
	((PlankDockElementClass *) klass)->get_menu_items = (GeeArrayList* (*) (PlankDockElement*)) plank_application_dock_item_real_get_menu_items;
	((PlankDockElementClass *) klass)->get_drop_text = (gchar* (*) (PlankDockElement*)) plank_application_dock_item_real_get_drop_text;
	((PlankDockElementClass *) klass)->can_accept_drop = (gboolean (*) (PlankDockElement*, GeeArrayList*)) plank_application_dock_item_real_can_accept_drop;
	((PlankDockElementClass *) klass)->accept_drop = (gboolean (*) (PlankDockElement*, GeeArrayList*)) plank_application_dock_item_real_accept_drop;
	((PlankDockItemClass *) klass)->load_from_launcher = (void (*) (PlankDockItem*)) plank_application_dock_item_real_load_from_launcher;
	G_OBJECT_CLASS (klass)->get_property = _vala_plank_application_dock_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_plank_application_dock_item_set_property;
	G_OBJECT_CLASS (klass)->constructor = plank_application_dock_item_constructor;
	G_OBJECT_CLASS (klass)->finalize = plank_application_dock_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_APPLICATION_DOCK_ITEM_APP_PROPERTY, plank_application_dock_item_properties[PLANK_APPLICATION_DOCK_ITEM_APP_PROPERTY] = g_param_spec_object ("App", "App", "App", bamf_application_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	 * Signal fired when the item's 'keep in dock' menu item is pressed.
	 */
	plank_application_dock_item_signals[PLANK_APPLICATION_DOCK_ITEM_PIN_LAUNCHER_SIGNAL] = g_signal_new ("pin-launcher", PLANK_TYPE_APPLICATION_DOCK_ITEM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	/**
	 * Signal fired when the application associated with this item closes.
	 */
	plank_application_dock_item_signals[PLANK_APPLICATION_DOCK_ITEM_APP_CLOSED_SIGNAL] = g_signal_new ("app-closed", PLANK_TYPE_APPLICATION_DOCK_ITEM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	/**
	 * Signal fired when the application associated with this item opened a new window.
	 */
	plank_application_dock_item_signals[PLANK_APPLICATION_DOCK_ITEM_APP_WINDOW_ADDED_SIGNAL] = g_signal_new ("app-window-added", PLANK_TYPE_APPLICATION_DOCK_ITEM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	/**
	 * Signal fired when the application associated with this item closed a window.
	 */
	plank_application_dock_item_signals[PLANK_APPLICATION_DOCK_ITEM_APP_WINDOW_REMOVED_SIGNAL] = g_signal_new ("app-window-removed", PLANK_TYPE_APPLICATION_DOCK_ITEM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
plank_application_dock_item_instance_init (PlankApplicationDockItem * self,
                                           gpointer klass)
{
	self->priv = plank_application_dock_item_get_instance_private (self);
	self->priv->app = NULL;
	self->priv->unity_application_uri = NULL;
	self->priv->unity_dbusname = NULL;
}

static void
plank_application_dock_item_finalize (GObject * obj)
{
	PlankApplicationDockItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_TYPE_APPLICATION_DOCK_ITEM, PlankApplicationDockItem);
	_g_object_unref0 (self->priv->supported_mime_types);
	self->priv->supported_mime_types = NULL;
	_g_object_unref0 (self->priv->actions);
	self->priv->actions = NULL;
	_g_object_unref0 (self->priv->actions_map);
	self->priv->actions_map = NULL;
	plank_application_dock_item_set_App (self, NULL);
	_g_object_unref0 (self->priv->app);
	_g_object_unref0 (self->priv->supported_mime_types);
	_g_object_unref0 (self->priv->actions);
	_g_object_unref0 (self->priv->actions_map);
	_g_free0 (self->priv->unity_application_uri);
	_g_free0 (self->priv->unity_dbusname);
	G_OBJECT_CLASS (plank_application_dock_item_parent_class)->finalize (obj);
}

/**
 * A dock item for applications (with .desktop launchers).
 */
static GType
plank_application_dock_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PlankApplicationDockItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plank_application_dock_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PlankApplicationDockItem), 0, (GInstanceInitFunc) plank_application_dock_item_instance_init, NULL };
	GType plank_application_dock_item_type_id;
	plank_application_dock_item_type_id = g_type_register_static (PLANK_TYPE_DOCK_ITEM, "PlankApplicationDockItem", &g_define_type_info, 0);
	PlankApplicationDockItem_private_offset = g_type_add_instance_private (plank_application_dock_item_type_id, sizeof (PlankApplicationDockItemPrivate));
	return plank_application_dock_item_type_id;
}

GType
plank_application_dock_item_get_type (void)
{
	static volatile gsize plank_application_dock_item_type_id__once = 0;
	if (g_once_init_enter (&plank_application_dock_item_type_id__once)) {
		GType plank_application_dock_item_type_id;
		plank_application_dock_item_type_id = plank_application_dock_item_get_type_once ();
		g_once_init_leave (&plank_application_dock_item_type_id__once, plank_application_dock_item_type_id);
	}
	return plank_application_dock_item_type_id__once;
}

static void
_vala_plank_application_dock_item_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec)
{
	PlankApplicationDockItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PLANK_TYPE_APPLICATION_DOCK_ITEM, PlankApplicationDockItem);
	switch (property_id) {
		case PLANK_APPLICATION_DOCK_ITEM_APP_PROPERTY:
		g_value_set_object (value, plank_application_dock_item_get_App (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_plank_application_dock_item_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec)
{
	PlankApplicationDockItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PLANK_TYPE_APPLICATION_DOCK_ITEM, PlankApplicationDockItem);
	switch (property_id) {
		case PLANK_APPLICATION_DOCK_ITEM_APP_PROPERTY:
		plank_application_dock_item_set_App (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

