/* Renderer.c generated by valac 0.56.17, the Vala compiler
 * generated from Renderer.vala, do not modify */

/**/
/*  Copyright (C) 2011 Robert Dyer*/
/**/
/*  This file is part of Plank.*/
/**/
/*  Plank is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  Plank is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include "plank.h"
#include <gtk/gtk.h>
#include <glib.h>
#include <cairo-gobject.h>
#include <glib-object.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PLANK_RENDERER_0_PROPERTY,
	PLANK_RENDERER_WIDGET_PROPERTY,
	PLANK_RENDERER_FRAME_TIME_PROPERTY,
	PLANK_RENDERER_NUM_PROPERTIES
};
static GParamSpec* plank_renderer_properties[PLANK_RENDERER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _PlankRendererPrivate {
	GtkWidget* _widget;
	gint64 _frame_time;
	guint timer_id;
	gulong widget_realize_handler_id;
	gulong widget_draw_handler_id;
	gboolean is_updating;
};

static gint PlankRenderer_private_offset;
static gpointer plank_renderer_parent_class = NULL;

static gboolean plank_renderer_real_animation_needed (PlankRenderer* self,
                                               gint64 frame_time);
static void plank_renderer_real_initialize_frame (PlankRenderer* self,
                                           gint64 frame_time);
static void plank_renderer_real_draw (PlankRenderer* self,
                               cairo_t* cr,
                               gint64 frame_time);
static void plank_renderer_set_frame_time (PlankRenderer* self,
                                    gint64 value);
static gboolean plank_renderer_draw_timeout (GtkWidget* widget,
                                      GdkFrameClock* frame_clock,
                                      PlankRenderer* self);
static gboolean plank_renderer_on_widget_draw (GtkWidget* widget,
                                        cairo_t* cr,
                                        PlankRenderer* self);
static void plank_renderer_on_widget_realize (GtkWidget* widget,
                                       PlankRenderer* self);
static GObject * plank_renderer_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties);
static void _plank_renderer_on_widget_realize_gtk_widget_realize (GtkWidget* _sender,
                                                           gpointer self);
static gboolean _plank_renderer_on_widget_draw_gtk_widget_draw (GtkWidget* _sender,
                                                         cairo_t* cr,
                                                         gpointer self);
static void plank_renderer_finalize (GObject * obj);
static GType plank_renderer_get_type_once (void);
static void _vala_plank_renderer_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec);
static void _vala_plank_renderer_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec);

static inline gpointer
plank_renderer_get_instance_private (PlankRenderer* self)
{
	return G_STRUCT_MEMBER_P (self, PlankRenderer_private_offset);
}

/**
 * Creates a new animation renderer.
 */
PlankRenderer*
plank_renderer_construct (GType object_type,
                          GtkWidget* widget)
{
	PlankRenderer * self = NULL;
	g_return_val_if_fail (widget != NULL, NULL);
	self = (PlankRenderer*) g_object_new (object_type, "widget", widget, NULL);
	return self;
}

/**
 * Determines if animation should continue.
 *
 * @param frame_time the current time for this frame's render
 * @return if another animation frame is needed
 */
static gboolean
plank_renderer_real_animation_needed (PlankRenderer* self,
                                      gint64 frame_time)
{
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `plank_renderer_animation_needed'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gboolean
plank_renderer_animation_needed (PlankRenderer* self,
                                 gint64 frame_time)
{
	PlankRendererClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = PLANK_RENDERER_GET_CLASS (self);
	if (_klass_->animation_needed) {
		return _klass_->animation_needed (self, frame_time);
	}
	return FALSE;
}

/**
 * Preparations which are not requiring a drawing context yet.
 *
 * @param frame_time the current time for this frame's render
 */
static void
plank_renderer_real_initialize_frame (PlankRenderer* self,
                                      gint64 frame_time)
{
	g_critical ("Type `%s' does not implement abstract method `plank_renderer_initialize_frame'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
plank_renderer_initialize_frame (PlankRenderer* self,
                                 gint64 frame_time)
{
	PlankRendererClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = PLANK_RENDERER_GET_CLASS (self);
	if (_klass_->initialize_frame) {
		_klass_->initialize_frame (self, frame_time);
	}
}

/**
 * Draws onto a context.
 *
 * @param cr the context to use for drawing
 */
static void
plank_renderer_real_draw (PlankRenderer* self,
                          cairo_t* cr,
                          gint64 frame_time)
{
	g_critical ("Type `%s' does not implement abstract method `plank_renderer_draw'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
plank_renderer_draw (PlankRenderer* self,
                     cairo_t* cr,
                     gint64 frame_time)
{
	PlankRendererClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = PLANK_RENDERER_GET_CLASS (self);
	if (_klass_->draw) {
		_klass_->draw (self, cr, frame_time);
	}
}

/**
 * Force an immediate update of the frame_time property.
 */
void
plank_renderer_force_frame_time_update (PlankRenderer* self)
{
	g_return_if_fail (self != NULL);
	plank_renderer_set_frame_time (self, g_get_monotonic_time ());
}

/**
 * Request re-drawing.
 */
void
plank_renderer_animated_draw (PlankRenderer* self)
{
	gboolean _tmp0_ = FALSE;
	gint64 _tmp2_;
	GtkWidget* _tmp3_;
	gint64 _tmp4_;
	g_return_if_fail (self != NULL);
	if (self->priv->is_updating) {
		_tmp0_ = TRUE;
	} else {
		GtkWidget* _tmp1_;
		_tmp1_ = self->priv->_widget;
		_tmp0_ = !gtk_widget_get_realized (_tmp1_);
	}
	if (_tmp0_) {
		return;
	}
	plank_renderer_force_frame_time_update (self);
	_tmp2_ = self->priv->_frame_time;
	plank_renderer_initialize_frame (self, _tmp2_);
	_tmp3_ = self->priv->_widget;
	gtk_widget_queue_draw (_tmp3_);
	_tmp4_ = self->priv->_frame_time;
	if (plank_renderer_animation_needed (self, _tmp4_)) {
		GdkFrameClock* frame_clock = NULL;
		GtkWidget* _tmp5_;
		GdkFrameClock* _tmp6_;
		GdkFrameClock* _tmp7_;
		_tmp5_ = self->priv->_widget;
		_tmp6_ = gtk_widget_get_frame_clock (_tmp5_);
		frame_clock = _tmp6_;
		_tmp7_ = frame_clock;
		gdk_frame_clock_begin_updating (_tmp7_);
		self->priv->is_updating = TRUE;
	}
}

static gboolean
plank_renderer_draw_timeout (GtkWidget* widget,
                             GdkFrameClock* frame_clock,
                             PlankRenderer* self)
{
	gint64 _tmp0_;
	gint64 _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (frame_clock != NULL, FALSE);
	plank_renderer_set_frame_time (self, g_get_monotonic_time ());
	_tmp0_ = self->priv->_frame_time;
	plank_renderer_initialize_frame (self, _tmp0_);
	gtk_widget_queue_draw (widget);
	_tmp1_ = self->priv->_frame_time;
	if (plank_renderer_animation_needed (self, _tmp1_)) {
		result = TRUE;
		return result;
	}
	gdk_frame_clock_end_updating (frame_clock);
	self->priv->is_updating = FALSE;
	result = TRUE;
	return result;
}

static gboolean
plank_renderer_on_widget_draw (GtkWidget* widget,
                               cairo_t* cr,
                               PlankRenderer* self)
{
	gint64 _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (cr != NULL, FALSE);
	_tmp0_ = self->priv->_frame_time;
	plank_renderer_draw (self, cr, _tmp0_);
	result = GDK_EVENT_PROPAGATE;
	return result;
}

static void
plank_renderer_on_widget_realize (GtkWidget* widget,
                                  PlankRenderer* self)
{
	gint64 _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	plank_renderer_force_frame_time_update (self);
	_tmp0_ = self->priv->_frame_time;
	plank_renderer_initialize_frame (self, _tmp0_);
	if (self->priv->widget_realize_handler_id > 0UL) {
		g_signal_handler_disconnect ((GObject*) widget, self->priv->widget_realize_handler_id);
		self->priv->widget_realize_handler_id = 0UL;
	}
}

GtkWidget*
plank_renderer_get_widget (PlankRenderer* self)
{
	GtkWidget* result;
	GtkWidget* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_widget;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
plank_renderer_set_widget (PlankRenderer* self,
                           GtkWidget* value)
{
	GtkWidget* old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_renderer_get_widget (self);
	if (old_value != value) {
		GtkWidget* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_widget);
		self->priv->_widget = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plank_renderer_properties[PLANK_RENDERER_WIDGET_PROPERTY]);
	}
}

gint64
plank_renderer_get_frame_time (PlankRenderer* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_frame_time;
	return result;
}

static void
plank_renderer_set_frame_time (PlankRenderer* self,
                               gint64 value)
{
	g_return_if_fail (self != NULL);
	self->priv->_frame_time = value;
}

static void
_plank_renderer_on_widget_realize_gtk_widget_realize (GtkWidget* _sender,
                                                      gpointer self)
{
	plank_renderer_on_widget_realize (_sender, (PlankRenderer*) self);
}

static gboolean
_plank_renderer_on_widget_draw_gtk_widget_draw (GtkWidget* _sender,
                                                cairo_t* cr,
                                                gpointer self)
{
	gboolean result;
	result = plank_renderer_on_widget_draw (_sender, cr, (PlankRenderer*) self);
	return result;
}

static GObject *
plank_renderer_constructor (GType type,
                            guint n_construct_properties,
                            GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PlankRenderer * self;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	gulong _tmp2_;
	GtkWidget* _tmp3_;
	gulong _tmp4_;
	parent_class = G_OBJECT_CLASS (plank_renderer_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_TYPE_RENDERER, PlankRenderer);
	_tmp0_ = self->priv->_widget;
	self->priv->timer_id = gtk_widget_add_tick_callback (_tmp0_, (GtkTickCallback) plank_renderer_draw_timeout, g_object_ref (self), g_object_unref);
	_tmp1_ = self->priv->_widget;
	_tmp2_ = g_signal_connect_object (_tmp1_, "realize", (GCallback) _plank_renderer_on_widget_realize_gtk_widget_realize, self, 0);
	self->priv->widget_realize_handler_id = _tmp2_;
	_tmp3_ = self->priv->_widget;
	_tmp4_ = g_signal_connect_object (_tmp3_, "draw", (GCallback) _plank_renderer_on_widget_draw_gtk_widget_draw, self, 0);
	self->priv->widget_draw_handler_id = _tmp4_;
	return obj;
}

static void
plank_renderer_class_init (PlankRendererClass * klass,
                           gpointer klass_data)
{
	plank_renderer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PlankRenderer_private_offset);
	((PlankRendererClass *) klass)->animation_needed = (gboolean (*) (PlankRenderer*, gint64)) plank_renderer_real_animation_needed;
	((PlankRendererClass *) klass)->initialize_frame = (void (*) (PlankRenderer*, gint64)) plank_renderer_real_initialize_frame;
	((PlankRendererClass *) klass)->draw = (void (*) (PlankRenderer*, cairo_t*, gint64)) plank_renderer_real_draw;
	G_OBJECT_CLASS (klass)->get_property = _vala_plank_renderer_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_plank_renderer_set_property;
	G_OBJECT_CLASS (klass)->constructor = plank_renderer_constructor;
	G_OBJECT_CLASS (klass)->finalize = plank_renderer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_RENDERER_WIDGET_PROPERTY, plank_renderer_properties[PLANK_RENDERER_WIDGET_PROPERTY] = g_param_spec_object ("widget", "widget", "widget", gtk_widget_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_RENDERER_FRAME_TIME_PROPERTY, plank_renderer_properties[PLANK_RENDERER_FRAME_TIME_PROPERTY] = g_param_spec_int64 ("frame-time", "frame-time", "frame-time", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
}

static void
plank_renderer_instance_init (PlankRenderer * self,
                              gpointer klass)
{
	self->priv = plank_renderer_get_instance_private (self);
	self->priv->timer_id = 0U;
	self->priv->widget_realize_handler_id = 0UL;
	self->priv->widget_draw_handler_id = 0UL;
	self->priv->is_updating = FALSE;
}

static void
plank_renderer_finalize (GObject * obj)
{
	PlankRenderer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_TYPE_RENDERER, PlankRenderer);
	if (self->priv->timer_id > 0U) {
		GtkWidget* _tmp0_;
		_tmp0_ = self->priv->_widget;
		gtk_widget_remove_tick_callback (_tmp0_, self->priv->timer_id);
		self->priv->timer_id = 0U;
	}
	if (self->priv->widget_realize_handler_id > 0UL) {
		GtkWidget* _tmp1_;
		_tmp1_ = self->priv->_widget;
		g_signal_handler_disconnect ((GObject*) _tmp1_, self->priv->widget_realize_handler_id);
		self->priv->widget_realize_handler_id = 0UL;
	}
	if (self->priv->widget_draw_handler_id > 0UL) {
		GtkWidget* _tmp2_;
		_tmp2_ = self->priv->_widget;
		g_signal_handler_disconnect ((GObject*) _tmp2_, self->priv->widget_draw_handler_id);
		self->priv->widget_draw_handler_id = 0UL;
	}
	_g_object_unref0 (self->priv->_widget);
	G_OBJECT_CLASS (plank_renderer_parent_class)->finalize (obj);
}

/**
 * Handles animated rendering.  Uses a timer and continues requesting
 * redraws for a widget until no more animation is needed.
 */
static GType
plank_renderer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PlankRendererClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plank_renderer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PlankRenderer), 0, (GInstanceInitFunc) plank_renderer_instance_init, NULL };
	GType plank_renderer_type_id;
	plank_renderer_type_id = g_type_register_static (G_TYPE_OBJECT, "PlankRenderer", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	PlankRenderer_private_offset = g_type_add_instance_private (plank_renderer_type_id, sizeof (PlankRendererPrivate));
	return plank_renderer_type_id;
}

GType
plank_renderer_get_type (void)
{
	static volatile gsize plank_renderer_type_id__once = 0;
	if (g_once_init_enter (&plank_renderer_type_id__once)) {
		GType plank_renderer_type_id;
		plank_renderer_type_id = plank_renderer_get_type_once ();
		g_once_init_leave (&plank_renderer_type_id__once, plank_renderer_type_id);
	}
	return plank_renderer_type_id__once;
}

static void
_vala_plank_renderer_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec)
{
	PlankRenderer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PLANK_TYPE_RENDERER, PlankRenderer);
	switch (property_id) {
		case PLANK_RENDERER_WIDGET_PROPERTY:
		g_value_set_object (value, plank_renderer_get_widget (self));
		break;
		case PLANK_RENDERER_FRAME_TIME_PROPERTY:
		g_value_set_int64 (value, plank_renderer_get_frame_time (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_plank_renderer_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec)
{
	PlankRenderer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PLANK_TYPE_RENDERER, PlankRenderer);
	switch (property_id) {
		case PLANK_RENDERER_WIDGET_PROPERTY:
		plank_renderer_set_widget (self, g_value_get_object (value));
		break;
		case PLANK_RENDERER_FRAME_TIME_PROPERTY:
		plank_renderer_set_frame_time (self, g_value_get_int64 (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

