/* DockRenderer.c generated by valac 0.56.17, the Vala compiler
 * generated from DockRenderer.vala, do not modify */

/**/
/*  Copyright (C) 2011-2012 Robert Dyer, Rico Tzschichholz*/
/**/
/*  This file is part of Plank.*/
/**/
/*  Plank is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  Plank is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include "plank.h"
#include <glib.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <gee.h>
#include <glib-object.h>
#include <cairo-gobject.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include "plank-internal.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PLANK_DOCK_RENDERER_0_PROPERTY,
	PLANK_DOCK_RENDERER_CONTROLLER_PROPERTY,
	PLANK_DOCK_RENDERER_THEME_PROPERTY,
	PLANK_DOCK_RENDERER_HIDE_PROGRESS_PROPERTY,
	PLANK_DOCK_RENDERER_ZOOM_IN_PROGRESS_PROPERTY,
	PLANK_DOCK_RENDERER_NUM_PROPERTIES
};
static GParamSpec* plank_dock_renderer_properties[PLANK_DOCK_RENDERER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define PLANK_TYPE_ENVIRONMENT_SETTINGS (plank_environment_settings_get_type ())
#define PLANK_ENVIRONMENT_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PLANK_TYPE_ENVIRONMENT_SETTINGS, PlankEnvironmentSettings))
#define PLANK_ENVIRONMENT_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PLANK_TYPE_ENVIRONMENT_SETTINGS, PlankEnvironmentSettingsClass))
#define PLANK_IS_ENVIRONMENT_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PLANK_TYPE_ENVIRONMENT_SETTINGS))
#define PLANK_IS_ENVIRONMENT_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PLANK_TYPE_ENVIRONMENT_SETTINGS))
#define PLANK_ENVIRONMENT_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PLANK_TYPE_ENVIRONMENT_SETTINGS, PlankEnvironmentSettingsClass))

typedef struct _PlankEnvironmentSettings PlankEnvironmentSettings;
typedef struct _PlankEnvironmentSettingsClass PlankEnvironmentSettingsClass;
typedef struct _Block1Data Block1Data;
#define _plank_dock_item_draw_value_unref0(var) ((var == NULL) ? NULL : (var = (plank_dock_item_draw_value_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _PlankDockRendererPrivate {
	PlankDockController* _controller;
	PlankDockTheme* _theme;
	gdouble _hide_progress;
	gdouble _opacity;
	gdouble _zoom_in_progress;
	GdkPoint _local_cursor;
	PlankSurface* main_buffer;
	PlankSurface* fade_buffer;
	PlankSurface* item_buffer;
	PlankSurface* shadow_buffer;
	PlankSurface* background_buffer;
	GdkRectangle background_rect;
	PlankSurface* indicator_buffer;
	PlankSurface* urgent_indicator_buffer;
	PlankSurface* urgent_glow_buffer;
	gint64 last_hide;
	gint64 last_hovered_changed;
	gboolean screen_is_composited;
	gboolean show_notifications;
	guint reset_position_manager_timer_id;
	gint window_scale_factor;
	gboolean is_first_frame;
	gboolean zoom_changed;
	gulong gtk_theme_name_changed_handler_id;
	gdouble dynamic_animation_offset;
	GeeArrayList* current_items;
	GeeHashSet* transient_items;
};

struct _Block1Data {
	int _ref_count_;
	PlankDockRenderer* self;
	gint64 frame_time;
};

struct _Block2Data {
	int _ref_count_;
	PlankDockRenderer* self;
	GtkPositionType position;
	gdouble x_offset;
};

static gint PlankDockRenderer_private_offset;
static gpointer plank_dock_renderer_parent_class = NULL;

static PlankDockController* plank_dock_renderer_get_controller (PlankDockRenderer* self);
static void plank_dock_renderer_prefs_changed (PlankDockRenderer* self,
                                        GObject* prefs,
                                        GParamSpec* prop);
static void _plank_dock_renderer_prefs_changed_g_object_notify (GObject* _sender,
                                                         GParamSpec* pspec,
                                                         gpointer self);
static void plank_dock_renderer_theme_changed (PlankDockRenderer* self);
static void _plank_dock_renderer_theme_changed_g_object_notify (GObject* _sender,
                                                         GParamSpec* pspec,
                                                         gpointer self);
static void plank_dock_renderer_hidden_changed (PlankDockRenderer* self);
static void _plank_dock_renderer_hidden_changed_g_object_notify (GObject* _sender,
                                                          GParamSpec* pspec,
                                                          gpointer self);
static void plank_dock_renderer_hovered_changed (PlankDockRenderer* self);
static void _plank_dock_renderer_hovered_changed_g_object_notify (GObject* _sender,
                                                           GParamSpec* pspec,
                                                           gpointer self);
static void _plank_renderer_animated_draw_g_object_notify (GObject* _sender,
                                                    GParamSpec* pspec,
                                                    gpointer self);
static void plank_dock_renderer_reset_position_manager (PlankDockRenderer* self);
static void plank_dock_renderer_load_theme (PlankDockRenderer* self);
static gboolean __lambda45_ (PlankDockRenderer* self);
static void plank_dock_renderer_reset_item_buffers (PlankDockRenderer* self);
static gboolean ___lambda45__gsource_func (gpointer self);
static void _plank_dock_renderer_load_theme_g_object_notify (GObject* _sender,
                                                      GParamSpec* pspec,
                                                      gpointer self);
static void plank_dock_renderer_set_theme (PlankDockRenderer* self,
                                    PlankDockTheme* value);
static void plank_dock_renderer_real_initialize_frame (PlankRenderer* base,
                                                gint64 frame_time);
VALA_EXTERN GType plank_environment_settings_get_type (void) G_GNUC_CONST ;
VALA_EXTERN PlankEnvironmentSettings* plank_environment_settings_get_instance (void);
VALA_EXTERN gboolean plank_environment_settings_get_ShowNotifications (PlankEnvironmentSettings* self);
static void plank_dock_renderer_set_hide_progress (PlankDockRenderer* self,
                                            gdouble value);
static void plank_dock_renderer_set_zoom_in_progress (PlankDockRenderer* self,
                                               gdouble value);
static void plank_dock_renderer_set_opacity (PlankDockRenderer* self,
                                      gdouble value);
static gint plank_dock_renderer_compare_dock_item_position (PlankDockItem* i1,
                                                     PlankDockItem* i2);
static void plank_dock_renderer_animate_draw_value_for_item (PlankDockItem* item,
                                                      PlankDockItemDrawValue* draw_value,
                                                      PlankDockRenderer* self);
static void plank_dock_renderer_post_process_draw_values (GeeHashMap* draw_values,
                                                   PlankDockRenderer* self);
static void plank_dock_renderer_real_draw (PlankRenderer* base,
                                    cairo_t* cr,
                                    gint64 frame_time);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gdouble plank_dock_renderer_get_opacity (PlankDockRenderer* self);
static void plank_dock_renderer_draw_urgent_glow (PlankDockRenderer* self,
                                           PlankDockItem* item,
                                           cairo_t* cr,
                                           gint64 frame_time);
static void plank_dock_renderer_draw_dock_background (PlankDockRenderer* self,
                                               cairo_t* cr,
                                               GdkRectangle* background_rect,
                                               gint x_offset,
                                               gint y_offset);
static void plank_dock_renderer_draw_item (PlankDockRenderer* self,
                                    cairo_t* cr,
                                    PlankDockItem* item,
                                    PlankDockItemDrawValue* draw_value,
                                    gint64 frame_time);
static void plank_dock_renderer_draw_item_shadow (PlankDockRenderer* self,
                                           cairo_t* cr,
                                           PlankDockItem* item,
                                           PlankDockItemDrawValue* draw_value);
static const gchar* plank_dock_renderer_cairo_surface_type_to_string (cairo_surface_type_t type);
static gboolean ___lambda47_ (Block1Data* _data1_);
static gboolean ____lambda47__gsource_func (gpointer self);
static gdouble plank_dock_renderer_easing_bounce (gdouble t,
                                           gdouble d,
                                           gdouble n);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gboolean __lambda46_ (Block2Data* _data2_,
                      PlankDockElement* i,
                      PlankDockItemDrawValue* val);
static gboolean ___lambda46__gee_forall_map_func (gconstpointer k,
                                           gconstpointer v,
                                           gpointer self);
static inline PlankSurface* plank_dock_renderer_get_item_surface (PlankDockRenderer* self,
                                                    PlankDockItem* item,
                                                    gint icon_size);
static PlankSurface* plank_dock_renderer_draw_item_foreground (gint width,
                                                        gint height,
                                                        PlankSurface* model,
                                                        PlankDockItem* item,
                                                        PlankDockRenderer* self);
static void plank_dock_renderer_draw_indicator_state (PlankDockRenderer* self,
                                               cairo_t* cr,
                                               GdkRectangle* item_rect,
                                               PlankIndicatorState indicator,
                                               PlankItemState item_state);
static PlankSurface* plank_dock_renderer_draw_item_background (gint width,
                                                        gint height,
                                                        PlankSurface* model,
                                                        PlankDockItem* item,
                                                        PlankDockRenderer* self);
static void plank_dock_renderer_get_styled_color (PlankDockRenderer* self,
                                           PlankColor* result);
static gboolean _gdk_point_equal (const GdkPoint * s1,
                           const GdkPoint * s2);
static void plank_dock_renderer_set_local_cursor (PlankDockRenderer* self,
                                           GdkPoint * value);
static gboolean plank_dock_renderer_real_animation_needed (PlankRenderer* base,
                                                    gint64 frame_time);
static inline gboolean plank_dock_renderer_item_animation_needed (PlankDockRenderer* self,
                                                    PlankDockItem* item,
                                                    gint64 render_time);
static GObject * plank_dock_renderer_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties);
static void plank_dock_renderer_finalize (GObject * obj);
static GType plank_dock_renderer_get_type_once (void);
static void _vala_plank_dock_renderer_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_plank_dock_renderer_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);

static inline gpointer
plank_dock_renderer_get_instance_private (PlankDockRenderer* self)
{
	return G_STRUCT_MEMBER_P (self, PlankDockRenderer_private_offset);
}

static void
_plank_dock_renderer_prefs_changed_g_object_notify (GObject* _sender,
                                                    GParamSpec* pspec,
                                                    gpointer self)
{
	plank_dock_renderer_prefs_changed ((PlankDockRenderer*) self, _sender, pspec);
}

static void
_plank_dock_renderer_theme_changed_g_object_notify (GObject* _sender,
                                                    GParamSpec* pspec,
                                                    gpointer self)
{
	plank_dock_renderer_theme_changed ((PlankDockRenderer*) self);
}

static void
_plank_dock_renderer_hidden_changed_g_object_notify (GObject* _sender,
                                                     GParamSpec* pspec,
                                                     gpointer self)
{
	plank_dock_renderer_hidden_changed ((PlankDockRenderer*) self);
}

static void
_plank_dock_renderer_hovered_changed_g_object_notify (GObject* _sender,
                                                      GParamSpec* pspec,
                                                      gpointer self)
{
	plank_dock_renderer_hovered_changed ((PlankDockRenderer*) self);
}

static void
_plank_renderer_animated_draw_g_object_notify (GObject* _sender,
                                               GParamSpec* pspec,
                                               gpointer self)
{
	plank_renderer_animated_draw ((PlankRenderer*) self);
}

/**
 * Create a new dock renderer for a dock.
 *
 * @param controller the dock controller to manage drawing for
 * @param window the dock window to be animated
 */
PlankDockRenderer*
plank_dock_renderer_construct (GType object_type,
                               PlankDockController* controller,
                               GtkWindow* window)
{
	PlankDockRenderer * self = NULL;
	g_return_val_if_fail (controller != NULL, NULL);
	g_return_val_if_fail (window != NULL, NULL);
	self = (PlankDockRenderer*) g_object_new (object_type, "controller", controller, "widget", window, NULL);
	return self;
}

PlankDockRenderer*
plank_dock_renderer_new (PlankDockController* controller,
                         GtkWindow* window)
{
	return plank_dock_renderer_construct (PLANK_TYPE_DOCK_RENDERER, controller, window);
}

/**
 * Initializes the renderer.  Call after the DockWindow is constructed.
 */
void
plank_dock_renderer_initialize (PlankDockRenderer* self)
{
	PlankDockController* _tmp0_;
	PlankDockWindow* _tmp1_;
	PlankDockWindow* _tmp2_;
	PlankDockController* _tmp3_;
	PlankPositionManager* _tmp4_;
	PlankPositionManager* _tmp5_;
	PlankDockTheme* _tmp6_;
	PlankDockController* _tmp7_;
	PlankDockWindow* _tmp8_;
	PlankDockWindow* _tmp9_;
	PlankDockController* _tmp10_;
	PlankHideManager* _tmp11_;
	PlankHideManager* _tmp12_;
	PlankDockController* _tmp13_;
	PlankHideManager* _tmp14_;
	PlankHideManager* _tmp15_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_controller;
	_tmp1_ = plank_dock_controller_get_window (_tmp0_);
	_tmp2_ = _tmp1_;
	_vala_return_if_fail (_tmp2_ != NULL, "controller.window != null");
	_tmp3_ = self->priv->_controller;
	_tmp4_ = plank_dock_controller_get_position_manager (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->_theme;
	plank_position_manager_update (_tmp5_, _tmp6_);
	_tmp7_ = self->priv->_controller;
	_tmp8_ = plank_dock_controller_get_window (_tmp7_);
	_tmp9_ = _tmp8_;
	g_signal_connect_object ((GObject*) _tmp9_, "notify::HoveredItem", (GCallback) _plank_renderer_animated_draw_g_object_notify, (PlankRenderer*) self, 0);
	_tmp10_ = self->priv->_controller;
	_tmp11_ = plank_dock_controller_get_hide_manager (_tmp10_);
	_tmp12_ = _tmp11_;
	g_signal_connect_object ((GObject*) _tmp12_, "notify::Hidden", (GCallback) _plank_dock_renderer_hidden_changed_g_object_notify, self, 0);
	_tmp13_ = self->priv->_controller;
	_tmp14_ = plank_dock_controller_get_hide_manager (_tmp13_);
	_tmp15_ = _tmp14_;
	g_signal_connect_object ((GObject*) _tmp15_, "notify::Hovered", (GCallback) _plank_dock_renderer_hovered_changed_g_object_notify, self, 0);
}

static void
plank_dock_renderer_prefs_changed (PlankDockRenderer* self,
                                   GObject* prefs,
                                   GParamSpec* prop)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	static GQuark _tmp2_label4 = 0;
	static GQuark _tmp2_label5 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (prefs != NULL);
	g_return_if_fail (prop != NULL);
	_tmp0_ = prop->name;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (((((_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("Alignment")))) || (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("IconSize"))))) || (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("ItemsAlignment"))))) || (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("Offset"))))) || (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("Position"))))) {
		switch (0) {
			default:
			{
				plank_dock_renderer_reset_position_manager (self);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label5) ? _tmp2_label5 : (_tmp2_label5 = g_quark_from_static_string ("Theme")))) {
		switch (0) {
			default:
			{
				plank_dock_renderer_load_theme (self);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				break;
			}
		}
	}
}

static void
plank_dock_renderer_theme_changed (PlankDockRenderer* self)
{
	g_return_if_fail (self != NULL);
	plank_dock_renderer_reset_position_manager (self);
}

static gboolean
__lambda45_ (PlankDockRenderer* self)
{
	PlankDockController* _tmp0_;
	PlankPositionManager* _tmp1_;
	PlankPositionManager* _tmp2_;
	PlankDockTheme* _tmp3_;
	gboolean result;
	self->priv->reset_position_manager_timer_id = 0U;
	plank_dock_renderer_reset_buffers (self);
	plank_dock_renderer_reset_item_buffers (self);
	_tmp0_ = self->priv->_controller;
	_tmp1_ = plank_dock_controller_get_position_manager (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->_theme;
	plank_position_manager_update (_tmp2_, _tmp3_);
	result = FALSE;
	return result;
}

static gboolean
___lambda45__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda45_ ((PlankDockRenderer*) self);
	return result;
}

static void
plank_dock_renderer_reset_position_manager (PlankDockRenderer* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->reset_position_manager_timer_id > 0U) {
		g_source_remove (self->priv->reset_position_manager_timer_id);
	}
	self->priv->reset_position_manager_timer_id = gdk_threads_add_timeout ((guint) 50, ___lambda45__gsource_func, self);
}

static void
_plank_dock_renderer_load_theme_g_object_notify (GObject* _sender,
                                                 GParamSpec* pspec,
                                                 gpointer self)
{
	plank_dock_renderer_load_theme ((PlankDockRenderer*) self);
}

static void
plank_dock_renderer_load_theme (PlankDockRenderer* self)
{
	gboolean is_reload = FALSE;
	PlankDockTheme* _tmp0_;
	const gchar* name = NULL;
	PlankDockController* _tmp3_;
	PlankDockPreferences* _tmp4_;
	PlankDockPreferences* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp12_;
	PlankDockTheme* _tmp13_;
	PlankDockTheme* _tmp14_;
	PlankDockTheme* _tmp15_;
	PlankDockTheme* _tmp16_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_theme;
	is_reload = _tmp0_ != NULL;
	if (is_reload) {
		PlankDockTheme* _tmp1_;
		guint _tmp2_;
		_tmp1_ = self->priv->_theme;
		g_signal_parse_name ("notify", G_TYPE_OBJECT, &_tmp2_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((GObject*) _tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _plank_dock_renderer_theme_changed_g_object_notify, self);
	}
	_tmp3_ = self->priv->_controller;
	_tmp4_ = plank_dock_controller_get_prefs (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = plank_dock_preferences_get_Theme (_tmp5_);
	_tmp7_ = _tmp6_;
	name = _tmp7_;
	_tmp8_ = name;
	if (g_strcmp0 (_tmp8_, PLANK_THEME_GTK_THEME_NAME) == 0) {
		if (self->priv->gtk_theme_name_changed_handler_id == 0UL) {
			GtkSettings* _tmp9_;
			gulong _tmp10_;
			_tmp9_ = gtk_settings_get_default ();
			_tmp10_ = g_signal_connect_object ((GObject*) _tmp9_, "notify::gtk-theme-name", (GCallback) _plank_dock_renderer_load_theme_g_object_notify, self, 0);
			self->priv->gtk_theme_name_changed_handler_id = _tmp10_;
		}
	} else {
		if (self->priv->gtk_theme_name_changed_handler_id > 0UL) {
			GtkSettings* _tmp11_;
			_tmp11_ = gtk_settings_get_default ();
			g_signal_handler_disconnect (_tmp11_, self->priv->gtk_theme_name_changed_handler_id);
			self->priv->gtk_theme_name_changed_handler_id = 0UL;
		}
	}
	_tmp12_ = name;
	_tmp13_ = plank_dock_theme_new (_tmp12_);
	_tmp14_ = _tmp13_;
	plank_dock_renderer_set_theme (self, _tmp14_);
	_g_object_unref0 (_tmp14_);
	_tmp15_ = self->priv->_theme;
	plank_theme_load ((PlankTheme*) _tmp15_, "dock");
	_tmp16_ = self->priv->_theme;
	g_signal_connect_object ((GObject*) _tmp16_, "notify", (GCallback) _plank_dock_renderer_theme_changed_g_object_notify, self, 0);
	if (is_reload) {
		plank_dock_renderer_theme_changed (self);
	}
}

/**
 * Resets all internal buffers and forces a redraw.
 */
void
plank_dock_renderer_reset_buffers (PlankDockRenderer* self)
{
	g_return_if_fail (self != NULL);
	plank_logger_verbose ("DockRenderer.reset_buffers ()", NULL);
	_g_object_unref0 (self->priv->main_buffer);
	self->priv->main_buffer = NULL;
	_g_object_unref0 (self->priv->fade_buffer);
	self->priv->fade_buffer = NULL;
	_g_object_unref0 (self->priv->item_buffer);
	self->priv->item_buffer = NULL;
	_g_object_unref0 (self->priv->shadow_buffer);
	self->priv->shadow_buffer = NULL;
	_g_object_unref0 (self->priv->background_buffer);
	self->priv->background_buffer = NULL;
	_g_object_unref0 (self->priv->indicator_buffer);
	self->priv->indicator_buffer = NULL;
	_g_object_unref0 (self->priv->urgent_indicator_buffer);
	self->priv->urgent_indicator_buffer = NULL;
	_g_object_unref0 (self->priv->urgent_glow_buffer);
	self->priv->urgent_glow_buffer = NULL;
	plank_renderer_animated_draw ((PlankRenderer*) self);
}

/**
 * Resets all internal item buffers and forces a redraw.
 */
static void
plank_dock_renderer_reset_item_buffers (PlankDockRenderer* self)
{
	PlankDockController* _tmp0_;
	g_return_if_fail (self != NULL);
	plank_logger_verbose ("DockRenderer.reset_item_buffers ()", NULL);
	_tmp0_ = self->priv->_controller;
	plank_dock_element_reset_buffers ((PlankDockElement*) _tmp0_);
	plank_renderer_animated_draw ((PlankRenderer*) self);
}

/**
 * {@inheritDoc}
 */
static void
plank_dock_renderer_real_initialize_frame (PlankRenderer* base,
                                           gint64 frame_time)
{
	PlankDockRenderer * self;
	PlankDockTheme* _tmp0_;
	GeeArrayList* new_items = NULL;
	PlankDockController* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	PlankPositionManager* position_manager = NULL;
	PlankDockController* _tmp7_;
	PlankPositionManager* _tmp8_;
	PlankPositionManager* _tmp9_;
	PlankPositionManager* _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	PlankEnvironmentSettings* _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	gdouble fade_opacity = 0.0;
	PlankDockTheme* _tmp16_;
	gdouble _tmp17_;
	gdouble _tmp18_;
	GeeArrayList* _tmp50_;
	GeeArrayList* _tmp51_;
	GeeArrayList* _tmp52_;
	GeeArrayList* _tmp78_;
	PlankPositionManager* _tmp79_;
	GeeArrayList* _tmp80_;
	PlankPositionManager* _tmp81_;
	GdkRectangle _tmp82_ = {0};
	self = (PlankDockRenderer*) base;
	_tmp0_ = self->priv->_theme;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = self->priv->_controller;
	_tmp2_ = plank_dock_controller_get_VisibleItems (_tmp1_);
	_tmp3_ = _tmp2_;
	new_items = _tmp3_;
	_tmp4_ = new_items;
	_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ <= 0) {
		g_critical ("DockRenderer.vala:242: No items available to initialize frame");
		return;
	}
	_tmp7_ = self->priv->_controller;
	_tmp8_ = plank_dock_controller_get_position_manager (_tmp7_);
	_tmp9_ = _tmp8_;
	position_manager = _tmp9_;
	_tmp10_ = position_manager;
	_tmp11_ = plank_position_manager_get_screen_is_composited (_tmp10_);
	_tmp12_ = _tmp11_;
	self->priv->screen_is_composited = _tmp12_;
	_tmp13_ = plank_environment_settings_get_instance ();
	_tmp14_ = plank_environment_settings_get_ShowNotifications (_tmp13_);
	_tmp15_ = _tmp14_;
	self->priv->show_notifications = _tmp15_;
	self->priv->dynamic_animation_offset = 0.0;
	_tmp16_ = self->priv->_theme;
	_tmp17_ = plank_dock_theme_get_FadeOpacity (_tmp16_);
	_tmp18_ = _tmp17_;
	fade_opacity = _tmp18_;
	if (self->priv->screen_is_composited) {
		gint _tmp19_ = 0;
		gint hide_duration = 0;
		gint64 hide_time = 0LL;
		guint zoom_duration = 0U;
		gint64 zoom_time = 0LL;
		gdouble zoom_progress = 0.0;
		gdouble _tmp48_;
		if (fade_opacity == 1.0) {
			PlankDockTheme* _tmp20_;
			gint _tmp21_;
			gint _tmp22_;
			_tmp20_ = self->priv->_theme;
			_tmp21_ = plank_dock_theme_get_HideTime (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp19_ = _tmp22_;
		} else {
			PlankDockTheme* _tmp23_;
			gint _tmp24_;
			gint _tmp25_;
			_tmp23_ = self->priv->_theme;
			_tmp24_ = plank_dock_theme_get_FadeTime (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp19_ = _tmp25_;
		}
		hide_duration = _tmp19_ * 1000;
		hide_time = MAX (0LL, frame_time - self->priv->last_hide);
		if (hide_time < ((gint64) hide_duration)) {
			PlankDockController* _tmp26_;
			PlankHideManager* _tmp27_;
			PlankHideManager* _tmp28_;
			gboolean _tmp29_;
			gboolean _tmp30_;
			_tmp26_ = self->priv->_controller;
			_tmp27_ = plank_dock_controller_get_hide_manager (_tmp26_);
			_tmp28_ = _tmp27_;
			_tmp29_ = plank_hide_manager_get_Hidden (_tmp28_);
			_tmp30_ = _tmp29_;
			if (_tmp30_) {
				plank_dock_renderer_set_hide_progress (self, plank_easing_for_mode (PLANK_ANIMATION_MODE_EASE_IN_CUBIC, (gdouble) hide_time, (gdouble) hide_duration));
			} else {
				plank_dock_renderer_set_hide_progress (self, 1.0 - plank_easing_for_mode (PLANK_ANIMATION_MODE_EASE_OUT_CUBIC, (gdouble) hide_time, (gdouble) hide_duration));
			}
		} else {
			gdouble _tmp31_ = 0.0;
			PlankDockController* _tmp32_;
			PlankHideManager* _tmp33_;
			PlankHideManager* _tmp34_;
			gboolean _tmp35_;
			gboolean _tmp36_;
			_tmp32_ = self->priv->_controller;
			_tmp33_ = plank_dock_controller_get_hide_manager (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = plank_hide_manager_get_Hidden (_tmp34_);
			_tmp36_ = _tmp35_;
			if (_tmp36_) {
				_tmp31_ = 1.0;
			} else {
				_tmp31_ = 0.0;
			}
			plank_dock_renderer_set_hide_progress (self, _tmp31_);
		}
		zoom_duration = PLANK_DOCK_ZOOM_DURATION * 1000;
		zoom_time = MAX (0LL, frame_time - self->priv->last_hovered_changed);
		if (zoom_time < ((gint64) zoom_duration)) {
			PlankDockController* _tmp37_;
			PlankHideManager* _tmp38_;
			PlankHideManager* _tmp39_;
			gboolean _tmp40_;
			gboolean _tmp41_;
			_tmp37_ = self->priv->_controller;
			_tmp38_ = plank_dock_controller_get_hide_manager (_tmp37_);
			_tmp39_ = _tmp38_;
			_tmp40_ = plank_hide_manager_get_Hovered (_tmp39_);
			_tmp41_ = _tmp40_;
			if (_tmp41_) {
				zoom_progress = plank_easing_for_mode (PLANK_ANIMATION_MODE_EASE_OUT_CUBIC, (gdouble) zoom_time, (gdouble) zoom_duration);
			} else {
				zoom_progress = 1.0 - plank_easing_for_mode (PLANK_ANIMATION_MODE_EASE_IN_CUBIC, (gdouble) zoom_time, (gdouble) zoom_duration);
			}
		} else {
			gdouble _tmp42_ = 0.0;
			PlankDockController* _tmp43_;
			PlankHideManager* _tmp44_;
			PlankHideManager* _tmp45_;
			gboolean _tmp46_;
			gboolean _tmp47_;
			_tmp43_ = self->priv->_controller;
			_tmp44_ = plank_dock_controller_get_hide_manager (_tmp43_);
			_tmp45_ = _tmp44_;
			_tmp46_ = plank_hide_manager_get_Hovered (_tmp45_);
			_tmp47_ = _tmp46_;
			if (_tmp47_) {
				_tmp42_ = 1.0;
			} else {
				_tmp42_ = 0.0;
			}
			zoom_progress = _tmp42_;
		}
		_tmp48_ = self->priv->_hide_progress;
		plank_dock_renderer_set_zoom_in_progress (self, zoom_progress * (1.0 - _tmp48_));
	} else {
		plank_dock_renderer_set_hide_progress (self, 0.0);
		plank_dock_renderer_set_zoom_in_progress (self, 0.0);
	}
	if (fade_opacity < 1.0) {
		gdouble _tmp49_;
		_tmp49_ = self->priv->_hide_progress;
		plank_dock_renderer_set_opacity (self, 1.0 - ((1.0 - fade_opacity) * _tmp49_));
	} else {
		plank_dock_renderer_set_opacity (self, 1.0);
	}
	_tmp50_ = self->priv->current_items;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp50_);
	_tmp51_ = self->priv->current_items;
	_tmp52_ = new_items;
	gee_array_list_add_all (_tmp51_, (GeeCollection*) _tmp52_);
	if (self->priv->screen_is_composited) {
		gint64 add_time = 0LL;
		gint64 remove_time = 0LL;
		gint64 move_time = 0LL;
		gint move_duration = 0;
		PlankDockTheme* _tmp53_;
		gint _tmp54_;
		gint _tmp55_;
		GeeIterator* transient_items_it = NULL;
		GeeHashSet* _tmp56_;
		GeeIterator* _tmp57_;
		add_time = 0LL;
		remove_time = 0LL;
		move_time = 0LL;
		_tmp53_ = self->priv->_theme;
		_tmp54_ = plank_dock_theme_get_ItemMoveTime (_tmp53_);
		_tmp55_ = _tmp54_;
		move_duration = _tmp55_ * 1000;
		_tmp56_ = self->priv->transient_items;
		_tmp57_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp56_);
		transient_items_it = _tmp57_;
		while (TRUE) {
			GeeIterator* _tmp58_;
			PlankDockItem* item = NULL;
			GeeIterator* _tmp59_;
			gpointer _tmp60_;
			PlankDockItem* _tmp61_;
			gint64 _tmp62_;
			gint64 _tmp63_;
			PlankDockItem* _tmp64_;
			gint64 _tmp65_;
			gint64 _tmp66_;
			_tmp58_ = transient_items_it;
			if (!gee_iterator_next (_tmp58_)) {
				break;
			}
			_tmp59_ = transient_items_it;
			_tmp60_ = gee_iterator_get (_tmp59_);
			item = (PlankDockItem*) _tmp60_;
			_tmp61_ = item;
			_tmp62_ = plank_dock_element_get_AddTime ((PlankDockElement*) _tmp61_);
			_tmp63_ = _tmp62_;
			add_time = _tmp63_;
			_tmp64_ = item;
			_tmp65_ = plank_dock_element_get_RemoveTime ((PlankDockElement*) _tmp64_);
			_tmp66_ = _tmp65_;
			remove_time = _tmp66_;
			if (add_time > remove_time) {
				move_time = frame_time - add_time;
				if (move_time < ((gint64) move_duration)) {
					GeeArrayList* _tmp67_;
					PlankDockItem* _tmp68_;
					_tmp67_ = self->priv->current_items;
					_tmp68_ = item;
					if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp67_, _tmp68_)) {
						GeeArrayList* _tmp69_;
						PlankDockItem* _tmp70_;
						_tmp69_ = self->priv->current_items;
						_tmp70_ = item;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp69_, _tmp70_);
					}
				} else {
					GeeIterator* _tmp71_;
					_tmp71_ = transient_items_it;
					gee_iterator_remove (_tmp71_);
				}
			} else {
				if (remove_time > ((gint64) 0)) {
					move_time = frame_time - remove_time;
					if (move_time < ((gint64) move_duration)) {
						GeeArrayList* _tmp72_;
						PlankDockItem* _tmp73_;
						_tmp72_ = self->priv->current_items;
						_tmp73_ = item;
						if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp72_, _tmp73_)) {
							GeeArrayList* _tmp74_;
							PlankDockItem* _tmp75_;
							_tmp74_ = self->priv->current_items;
							_tmp75_ = item;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp74_, _tmp75_);
						}
					} else {
						GeeIterator* _tmp76_;
						_tmp76_ = transient_items_it;
						gee_iterator_remove (_tmp76_);
					}
				}
			}
			_g_object_unref0 (item);
		}
		_g_object_unref0 (transient_items_it);
	} else {
		GeeHashSet* _tmp77_;
		_tmp77_ = self->priv->transient_items;
		gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp77_);
	}
	_tmp78_ = self->priv->current_items;
	gee_list_sort ((GeeList*) _tmp78_, (GCompareDataFunc) plank_dock_renderer_compare_dock_item_position, NULL, NULL);
	_tmp79_ = position_manager;
	_tmp80_ = self->priv->current_items;
	plank_position_manager_update_draw_values (_tmp79_, _tmp80_, (PlankDrawValueFunc) plank_dock_renderer_animate_draw_value_for_item, self, (PlankDrawValuesFunc) plank_dock_renderer_post_process_draw_values, self);
	_tmp81_ = position_manager;
	plank_position_manager_get_background_region (_tmp81_, &_tmp82_);
	self->priv->background_rect = _tmp82_;
}

/**
 * {@inheritDoc}
 */
static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		PlankDockRenderer* self;
		self = _data1_->self;
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static gboolean
___lambda47_ (Block1Data* _data1_)
{
	PlankDockRenderer* self;
	PlankHideManager* hide_manager = NULL;
	PlankDockController* _tmp0_;
	PlankHideManager* _tmp1_;
	PlankHideManager* _tmp2_;
	PlankHideManager* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	PlankHideManager* _tmp6_;
	gboolean result;
	self = _data1_->self;
	_tmp0_ = self->priv->_controller;
	_tmp1_ = plank_dock_controller_get_hide_manager (_tmp0_);
	_tmp2_ = _tmp1_;
	hide_manager = _tmp2_;
	_tmp3_ = hide_manager;
	_tmp4_ = plank_hide_manager_get_Hidden (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_) {
		result = FALSE;
		return result;
	}
	_tmp6_ = hide_manager;
	plank_hide_manager_update_hovered (_tmp6_);
	plank_renderer_force_frame_time_update ((PlankRenderer*) self);
	self->priv->last_hide = _data1_->frame_time;
	plank_dock_renderer_hidden_changed (self);
	result = FALSE;
	return result;
}

static gboolean
____lambda47__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda47_ (self);
	return result;
}

static void
plank_dock_renderer_real_draw (PlankRenderer* base,
                               cairo_t* cr,
                               gint64 frame_time)
{
	PlankDockRenderer * self;
	Block1Data* _data1_;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	PlankDockController* _tmp3_;
	PlankDockWindow* _tmp4_;
	PlankDockWindow* _tmp5_;
	GdkWindow* _tmp6_;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean no_full_draw_needed = FALSE;
	PlankPositionManager* position_manager = NULL;
	PlankDockController* _tmp11_;
	PlankPositionManager* _tmp12_;
	PlankPositionManager* _tmp13_;
	PlankDockItem* dragged_item = NULL;
	PlankDockController* _tmp14_;
	PlankDragManager* _tmp15_;
	PlankDragManager* _tmp16_;
	PlankDockItem* _tmp17_;
	PlankDockItem* _tmp18_;
	GdkRectangle win_rect = {0};
	PlankPositionManager* _tmp19_;
	GdkRectangle _tmp20_ = {0};
	PlankSurface* _tmp21_;
	PlankSurface* _tmp29_;
	PlankSurface* _tmp37_;
	gboolean _tmp45_ = FALSE;
	gboolean _tmp46_ = FALSE;
	gboolean _tmp58_ = FALSE;
	gdouble _tmp59_;
	PlankSurface* _tmp68_;
	PlankSurface* _tmp69_;
	PlankSurface* _tmp70_;
	cairo_t* item_cr = NULL;
	PlankSurface* _tmp71_;
	cairo_t* _tmp72_;
	cairo_t* _tmp73_;
	cairo_t* shadow_cr = NULL;
	PlankSurface* _tmp74_;
	cairo_t* _tmp75_;
	cairo_t* _tmp76_;
	gint x_offset = 0;
	gint y_offset = 0;
	gdouble _tmp77_;
	PlankSurface* _tmp81_;
	cairo_t* main_cr = NULL;
	PlankSurface* _tmp82_;
	cairo_t* _tmp83_;
	cairo_t* _tmp84_;
	cairo_t* _tmp85_;
	cairo_t* _tmp86_;
	GdkRectangle _tmp87_;
	cairo_t* _tmp111_;
	PlankSurface* _tmp112_;
	cairo_surface_t* _tmp113_;
	cairo_surface_t* _tmp114_;
	cairo_t* _tmp115_;
	cairo_t* _tmp116_;
	PlankSurface* _tmp117_;
	cairo_surface_t* _tmp118_;
	cairo_surface_t* _tmp119_;
	cairo_t* _tmp120_;
	gdouble _tmp121_;
	gboolean _tmp139_ = FALSE;
	self = (PlankDockRenderer*) base;
	g_return_if_fail (cr != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_data1_->frame_time = frame_time;
	_tmp0_ = self->priv->current_items;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ <= 0) {
		g_critical ("DockRenderer.vala:343: No items available to draw frame");
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return;
	}
	_tmp3_ = self->priv->_controller;
	_tmp4_ = plank_dock_controller_get_window (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = gtk_widget_get_window ((GtkWidget*) _tmp5_);
	self->priv->window_scale_factor = gdk_window_get_scale_factor (_tmp6_);
	if (!self->priv->is_first_frame) {
		gdouble _tmp9_;
		_tmp9_ = self->priv->_hide_progress;
		_tmp8_ = _tmp9_ == 1.0;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		gdouble _tmp10_;
		_tmp10_ = self->priv->_opacity;
		_tmp7_ = _tmp10_ == 1.0;
	} else {
		_tmp7_ = FALSE;
	}
	no_full_draw_needed = _tmp7_;
	_tmp11_ = self->priv->_controller;
	_tmp12_ = plank_dock_controller_get_position_manager (_tmp11_);
	_tmp13_ = _tmp12_;
	position_manager = _tmp13_;
	_tmp14_ = self->priv->_controller;
	_tmp15_ = plank_dock_controller_get_drag_manager (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = plank_drag_manager_get_DragItem (_tmp16_);
	_tmp18_ = _tmp17_;
	dragged_item = _tmp18_;
	_tmp19_ = position_manager;
	plank_position_manager_get_dock_window_region (_tmp19_, &_tmp20_);
	win_rect = _tmp20_;
	_tmp21_ = self->priv->main_buffer;
	if (_tmp21_ == NULL) {
		GdkRectangle _tmp22_;
		GdkRectangle _tmp23_;
		cairo_surface_t* _tmp24_;
		PlankSurface* _tmp25_;
		PlankSurface* _tmp26_;
		cairo_surface_t* _tmp27_;
		cairo_surface_t* _tmp28_;
		_tmp22_ = win_rect;
		_tmp23_ = win_rect;
		_tmp24_ = cairo_get_target (cr);
		_tmp25_ = plank_surface_new_with_cairo_surface (_tmp22_.width, _tmp23_.height, _tmp24_);
		_g_object_unref0 (self->priv->main_buffer);
		self->priv->main_buffer = _tmp25_;
		_tmp26_ = self->priv->main_buffer;
		_tmp27_ = plank_surface_get_Internal (_tmp26_);
		_tmp28_ = _tmp27_;
		cairo_surface_set_device_scale (_tmp28_, (gdouble) self->priv->window_scale_factor, (gdouble) self->priv->window_scale_factor);
	}
	_tmp29_ = self->priv->item_buffer;
	if (_tmp29_ == NULL) {
		GdkRectangle _tmp30_;
		GdkRectangle _tmp31_;
		cairo_surface_t* _tmp32_;
		PlankSurface* _tmp33_;
		PlankSurface* _tmp34_;
		cairo_surface_t* _tmp35_;
		cairo_surface_t* _tmp36_;
		_tmp30_ = win_rect;
		_tmp31_ = win_rect;
		_tmp32_ = cairo_get_target (cr);
		_tmp33_ = plank_surface_new_with_cairo_surface (_tmp30_.width, _tmp31_.height, _tmp32_);
		_g_object_unref0 (self->priv->item_buffer);
		self->priv->item_buffer = _tmp33_;
		_tmp34_ = self->priv->item_buffer;
		_tmp35_ = plank_surface_get_Internal (_tmp34_);
		_tmp36_ = _tmp35_;
		cairo_surface_set_device_scale (_tmp36_, (gdouble) self->priv->window_scale_factor, (gdouble) self->priv->window_scale_factor);
	}
	_tmp37_ = self->priv->shadow_buffer;
	if (_tmp37_ == NULL) {
		GdkRectangle _tmp38_;
		GdkRectangle _tmp39_;
		cairo_surface_t* _tmp40_;
		PlankSurface* _tmp41_;
		PlankSurface* _tmp42_;
		cairo_surface_t* _tmp43_;
		cairo_surface_t* _tmp44_;
		_tmp38_ = win_rect;
		_tmp39_ = win_rect;
		_tmp40_ = cairo_get_target (cr);
		_tmp41_ = plank_surface_new_with_cairo_surface (_tmp38_.width, _tmp39_.height, _tmp40_);
		_g_object_unref0 (self->priv->shadow_buffer);
		self->priv->shadow_buffer = _tmp41_;
		_tmp42_ = self->priv->shadow_buffer;
		_tmp43_ = plank_surface_get_Internal (_tmp42_);
		_tmp44_ = _tmp43_;
		cairo_surface_set_device_scale (_tmp44_, (gdouble) self->priv->window_scale_factor, (gdouble) self->priv->window_scale_factor);
	}
	if (no_full_draw_needed) {
		gdouble _tmp47_;
		_tmp47_ = self->priv->_hide_progress;
		_tmp46_ = _tmp47_ == 1.0;
	} else {
		_tmp46_ = FALSE;
	}
	if (_tmp46_) {
		gdouble _tmp48_;
		_tmp48_ = self->priv->_opacity;
		_tmp45_ = _tmp48_ == 1.0;
	} else {
		_tmp45_ = FALSE;
	}
	if (_tmp45_) {
		cairo_save (cr);
		cairo_set_operator (cr, CAIRO_OPERATOR_CLEAR);
		cairo_paint (cr);
		cairo_restore (cr);
		if (self->priv->show_notifications) {
			{
				GeeArrayList* _item_list = NULL;
				GeeArrayList* _tmp49_;
				gint _item_size = 0;
				GeeArrayList* _tmp50_;
				gint _tmp51_;
				gint _tmp52_;
				gint _item_index = 0;
				_tmp49_ = self->priv->current_items;
				_item_list = _tmp49_;
				_tmp50_ = _item_list;
				_tmp51_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp50_);
				_tmp52_ = _tmp51_;
				_item_size = _tmp52_;
				_item_index = -1;
				while (TRUE) {
					gint _tmp53_;
					gint _tmp54_;
					PlankDockItem* item = NULL;
					GeeArrayList* _tmp55_;
					gpointer _tmp56_;
					PlankDockItem* _tmp57_;
					_item_index = _item_index + 1;
					_tmp53_ = _item_index;
					_tmp54_ = _item_size;
					if (!(_tmp53_ < _tmp54_)) {
						break;
					}
					_tmp55_ = _item_list;
					_tmp56_ = gee_abstract_list_get ((GeeAbstractList*) _tmp55_, _item_index);
					item = (PlankDockItem*) _tmp56_;
					_tmp57_ = item;
					plank_dock_renderer_draw_urgent_glow (self, _tmp57_, cr, _data1_->frame_time);
				}
			}
		}
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return;
	}
	_tmp59_ = self->priv->_opacity;
	if (_tmp59_ < 1.0) {
		PlankSurface* _tmp60_;
		_tmp60_ = self->priv->fade_buffer;
		_tmp58_ = _tmp60_ == NULL;
	} else {
		_tmp58_ = FALSE;
	}
	if (_tmp58_) {
		GdkRectangle _tmp61_;
		GdkRectangle _tmp62_;
		cairo_surface_t* _tmp63_;
		PlankSurface* _tmp64_;
		PlankSurface* _tmp65_;
		cairo_surface_t* _tmp66_;
		cairo_surface_t* _tmp67_;
		_tmp61_ = win_rect;
		_tmp62_ = win_rect;
		_tmp63_ = cairo_get_target (cr);
		_tmp64_ = plank_surface_new_with_cairo_surface (_tmp61_.width, _tmp62_.height, _tmp63_);
		_g_object_unref0 (self->priv->fade_buffer);
		self->priv->fade_buffer = _tmp64_;
		_tmp65_ = self->priv->fade_buffer;
		_tmp66_ = plank_surface_get_Internal (_tmp65_);
		_tmp67_ = _tmp66_;
		cairo_surface_set_device_scale (_tmp67_, (gdouble) self->priv->window_scale_factor, (gdouble) self->priv->window_scale_factor);
	}
	_tmp68_ = self->priv->main_buffer;
	plank_surface_clear (_tmp68_);
	_tmp69_ = self->priv->item_buffer;
	plank_surface_clear (_tmp69_);
	_tmp70_ = self->priv->shadow_buffer;
	plank_surface_clear (_tmp70_);
	_tmp71_ = self->priv->item_buffer;
	_tmp72_ = plank_surface_get_Context (_tmp71_);
	_tmp73_ = _tmp72_;
	item_cr = _tmp73_;
	_tmp74_ = self->priv->shadow_buffer;
	_tmp75_ = plank_surface_get_Context (_tmp74_);
	_tmp76_ = _tmp75_;
	shadow_cr = _tmp76_;
	x_offset = 0;
	y_offset = 0;
	_tmp77_ = self->priv->_opacity;
	if (_tmp77_ == 1.0) {
		PlankPositionManager* _tmp78_;
		gint _tmp79_ = 0;
		gint _tmp80_ = 0;
		_tmp78_ = position_manager;
		plank_position_manager_get_dock_draw_position (_tmp78_, &_tmp79_, &_tmp80_);
		x_offset = _tmp79_;
		y_offset = _tmp80_;
	}
	_tmp81_ = self->priv->main_buffer;
	plank_surface_clear (_tmp81_);
	_tmp82_ = self->priv->main_buffer;
	_tmp83_ = plank_surface_get_Context (_tmp82_);
	_tmp84_ = _tmp83_;
	main_cr = _tmp84_;
	_tmp85_ = main_cr;
	cairo_set_operator (_tmp85_, CAIRO_OPERATOR_OVER);
	_tmp86_ = main_cr;
	_tmp87_ = self->priv->background_rect;
	plank_dock_renderer_draw_dock_background (self, _tmp86_, &_tmp87_, x_offset, y_offset);
	{
		GeeArrayList* _item_list = NULL;
		GeeArrayList* _tmp88_;
		gint _item_size = 0;
		GeeArrayList* _tmp89_;
		gint _tmp90_;
		gint _tmp91_;
		gint _item_index = 0;
		_tmp88_ = self->priv->current_items;
		_item_list = _tmp88_;
		_tmp89_ = _item_list;
		_tmp90_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp89_);
		_tmp91_ = _tmp90_;
		_item_size = _tmp91_;
		_item_index = -1;
		while (TRUE) {
			gint _tmp92_;
			gint _tmp93_;
			PlankDockItem* item = NULL;
			GeeArrayList* _tmp94_;
			gpointer _tmp95_;
			gboolean _tmp96_ = FALSE;
			PlankDockItem* _tmp97_;
			gboolean _tmp98_;
			gboolean _tmp99_;
			_item_index = _item_index + 1;
			_tmp92_ = _item_index;
			_tmp93_ = _item_size;
			if (!(_tmp92_ < _tmp93_)) {
				break;
			}
			_tmp94_ = _item_list;
			_tmp95_ = gee_abstract_list_get ((GeeAbstractList*) _tmp94_, _item_index);
			item = (PlankDockItem*) _tmp95_;
			_tmp97_ = item;
			_tmp98_ = plank_dock_element_get_IsVisible ((PlankDockElement*) _tmp97_);
			_tmp99_ = _tmp98_;
			if (_tmp99_) {
				PlankDockItem* _tmp100_;
				PlankDockItem* _tmp101_;
				_tmp100_ = dragged_item;
				_tmp101_ = item;
				_tmp96_ = _tmp100_ != _tmp101_;
			} else {
				_tmp96_ = FALSE;
			}
			if (_tmp96_) {
				PlankDockItemDrawValue* draw_value = NULL;
				PlankPositionManager* _tmp102_;
				PlankDockItem* _tmp103_;
				PlankDockItemDrawValue* _tmp104_;
				cairo_t* _tmp105_;
				PlankDockItem* _tmp106_;
				PlankDockItemDrawValue* _tmp107_;
				cairo_t* _tmp108_;
				PlankDockItem* _tmp109_;
				PlankDockItemDrawValue* _tmp110_;
				_tmp102_ = position_manager;
				_tmp103_ = item;
				_tmp104_ = plank_position_manager_get_draw_value_for_item (_tmp102_, _tmp103_);
				draw_value = _tmp104_;
				_tmp105_ = item_cr;
				_tmp106_ = item;
				_tmp107_ = draw_value;
				plank_dock_renderer_draw_item (self, _tmp105_, _tmp106_, _tmp107_, _data1_->frame_time);
				_tmp108_ = shadow_cr;
				_tmp109_ = item;
				_tmp110_ = draw_value;
				plank_dock_renderer_draw_item_shadow (self, _tmp108_, _tmp109_, _tmp110_);
				_plank_dock_item_draw_value_unref0 (draw_value);
			}
		}
	}
	_tmp111_ = main_cr;
	_tmp112_ = self->priv->shadow_buffer;
	_tmp113_ = plank_surface_get_Internal (_tmp112_);
	_tmp114_ = _tmp113_;
	cairo_set_source_surface (_tmp111_, _tmp114_, (gdouble) x_offset, (gdouble) y_offset);
	_tmp115_ = main_cr;
	cairo_paint (_tmp115_);
	_tmp116_ = main_cr;
	_tmp117_ = self->priv->item_buffer;
	_tmp118_ = plank_surface_get_Internal (_tmp117_);
	_tmp119_ = _tmp118_;
	cairo_set_source_surface (_tmp116_, _tmp119_, (gdouble) x_offset, (gdouble) y_offset);
	_tmp120_ = main_cr;
	cairo_paint (_tmp120_);
	cairo_set_operator (cr, CAIRO_OPERATOR_SOURCE);
	_tmp121_ = self->priv->_opacity;
	if (_tmp121_ < 1.0) {
		PlankSurface* _tmp122_;
		cairo_t* fade_cr = NULL;
		PlankSurface* _tmp123_;
		cairo_t* _tmp124_;
		cairo_t* _tmp125_;
		cairo_t* _tmp126_;
		cairo_t* _tmp127_;
		PlankSurface* _tmp128_;
		cairo_surface_t* _tmp129_;
		cairo_surface_t* _tmp130_;
		cairo_t* _tmp131_;
		gdouble _tmp132_;
		PlankSurface* _tmp133_;
		cairo_surface_t* _tmp134_;
		cairo_surface_t* _tmp135_;
		_tmp122_ = self->priv->fade_buffer;
		plank_surface_clear (_tmp122_);
		_tmp123_ = self->priv->fade_buffer;
		_tmp124_ = plank_surface_get_Context (_tmp123_);
		_tmp125_ = _tmp124_;
		fade_cr = _tmp125_;
		_tmp126_ = fade_cr;
		cairo_set_operator (_tmp126_, CAIRO_OPERATOR_OVER);
		_tmp127_ = fade_cr;
		_tmp128_ = self->priv->main_buffer;
		_tmp129_ = plank_surface_get_Internal (_tmp128_);
		_tmp130_ = _tmp129_;
		cairo_set_source_surface (_tmp127_, _tmp130_, (gdouble) 0, (gdouble) 0);
		_tmp131_ = fade_cr;
		_tmp132_ = self->priv->_opacity;
		cairo_paint_with_alpha (_tmp131_, _tmp132_);
		_tmp133_ = self->priv->fade_buffer;
		_tmp134_ = plank_surface_get_Internal (_tmp133_);
		_tmp135_ = _tmp134_;
		cairo_set_source_surface (cr, _tmp135_, (gdouble) 0, (gdouble) 0);
	} else {
		PlankSurface* _tmp136_;
		cairo_surface_t* _tmp137_;
		cairo_surface_t* _tmp138_;
		_tmp136_ = self->priv->main_buffer;
		_tmp137_ = plank_surface_get_Internal (_tmp136_);
		_tmp138_ = _tmp137_;
		cairo_set_source_surface (cr, _tmp138_, (gdouble) 0, (gdouble) 0);
	}
	cairo_paint (cr);
	if (self->priv->show_notifications) {
		gdouble _tmp140_;
		_tmp140_ = self->priv->_hide_progress;
		_tmp139_ = _tmp140_ == 1.0;
	} else {
		_tmp139_ = FALSE;
	}
	if (_tmp139_) {
		{
			GeeArrayList* _item_list = NULL;
			GeeArrayList* _tmp141_;
			gint _item_size = 0;
			GeeArrayList* _tmp142_;
			gint _tmp143_;
			gint _tmp144_;
			gint _item_index = 0;
			_tmp141_ = self->priv->current_items;
			_item_list = _tmp141_;
			_tmp142_ = _item_list;
			_tmp143_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp142_);
			_tmp144_ = _tmp143_;
			_item_size = _tmp144_;
			_item_index = -1;
			while (TRUE) {
				gint _tmp145_;
				gint _tmp146_;
				PlankDockItem* item = NULL;
				GeeArrayList* _tmp147_;
				gpointer _tmp148_;
				PlankDockItem* _tmp149_;
				_item_index = _item_index + 1;
				_tmp145_ = _item_index;
				_tmp146_ = _item_size;
				if (!(_tmp145_ < _tmp146_)) {
					break;
				}
				_tmp147_ = _item_list;
				_tmp148_ = gee_abstract_list_get ((GeeAbstractList*) _tmp147_, _item_index);
				item = (PlankDockItem*) _tmp148_;
				_tmp149_ = item;
				plank_dock_renderer_draw_urgent_glow (self, _tmp149_, cr, _data1_->frame_time);
			}
		}
	}
	if (self->priv->is_first_frame) {
		cairo_surface_t* _tmp150_;
		const gchar* _tmp151_;
		_tmp150_ = cairo_get_target (cr);
		_tmp151_ = plank_dock_renderer_cairo_surface_type_to_string (cairo_surface_get_type (_tmp150_));
		g_message ("DockRenderer.vala:481: Cairo.SurfaceType: %s", _tmp151_);
		gdk_threads_add_idle_full (G_PRIORITY_LOW, ____lambda47__gsource_func, block1_data_ref (_data1_), block1_data_unref);
		self->priv->is_first_frame = FALSE;
	}
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

static void
plank_dock_renderer_draw_dock_background (PlankDockRenderer* self,
                                          cairo_t* cr,
                                          GdkRectangle* background_rect,
                                          gint x_offset,
                                          gint y_offset)
{
	PlankPositionManager* position_manager = NULL;
	PlankDockController* _tmp0_;
	PlankPositionManager* _tmp1_;
	PlankPositionManager* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GdkRectangle _tmp4_;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	PlankSurface* _tmp8_;
	gboolean _tmp25_ = FALSE;
	gdouble _tmp26_;
	PlankSurface* _tmp35_;
	cairo_surface_t* _tmp36_;
	cairo_surface_t* _tmp37_;
	GdkRectangle _tmp38_;
	GdkRectangle _tmp39_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	g_return_if_fail (background_rect != NULL);
	_tmp0_ = self->priv->_controller;
	_tmp1_ = plank_dock_controller_get_position_manager (_tmp0_);
	_tmp2_ = _tmp1_;
	position_manager = _tmp2_;
	_tmp4_ = *background_rect;
	if (_tmp4_.width <= 0) {
		_tmp3_ = TRUE;
	} else {
		GdkRectangle _tmp5_;
		_tmp5_ = *background_rect;
		_tmp3_ = _tmp5_.height <= 0;
	}
	if (_tmp3_) {
		_g_object_unref0 (self->priv->background_buffer);
		self->priv->background_buffer = NULL;
		return;
	}
	_tmp8_ = self->priv->background_buffer;
	if (_tmp8_ == NULL) {
		_tmp7_ = TRUE;
	} else {
		PlankSurface* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		GdkRectangle _tmp12_;
		_tmp9_ = self->priv->background_buffer;
		_tmp10_ = plank_surface_get_Width (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = *background_rect;
		_tmp7_ = _tmp11_ != _tmp12_.width;
	}
	if (_tmp7_) {
		_tmp6_ = TRUE;
	} else {
		PlankSurface* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		GdkRectangle _tmp16_;
		_tmp13_ = self->priv->background_buffer;
		_tmp14_ = plank_surface_get_Height (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = *background_rect;
		_tmp6_ = _tmp15_ != _tmp16_.height;
	}
	if (_tmp6_) {
		PlankDockTheme* _tmp17_;
		GdkRectangle _tmp18_;
		GdkRectangle _tmp19_;
		PlankPositionManager* _tmp20_;
		GtkPositionType _tmp21_;
		GtkPositionType _tmp22_;
		PlankSurface* _tmp23_;
		PlankSurface* _tmp24_;
		_tmp17_ = self->priv->_theme;
		_tmp18_ = *background_rect;
		_tmp19_ = *background_rect;
		_tmp20_ = position_manager;
		_tmp21_ = plank_position_manager_get_Position (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = self->priv->main_buffer;
		_tmp24_ = plank_dock_theme_create_background (_tmp17_, _tmp18_.width, _tmp19_.height, _tmp22_, _tmp23_);
		_g_object_unref0 (self->priv->background_buffer);
		self->priv->background_buffer = _tmp24_;
	}
	_tmp26_ = self->priv->_hide_progress;
	if (_tmp26_ > 0.0) {
		PlankDockTheme* _tmp27_;
		gboolean _tmp28_;
		gboolean _tmp29_;
		_tmp27_ = self->priv->_theme;
		_tmp28_ = plank_dock_theme_get_CascadeHide (_tmp27_);
		_tmp29_ = _tmp28_;
		_tmp25_ = _tmp29_;
	} else {
		_tmp25_ = FALSE;
	}
	if (_tmp25_) {
		gint x = 0;
		gint y = 0;
		PlankPositionManager* _tmp30_;
		gint _tmp31_ = 0;
		gint _tmp32_ = 0;
		gdouble _tmp33_;
		gdouble _tmp34_;
		_tmp30_ = position_manager;
		plank_position_manager_get_background_padding (_tmp30_, &_tmp31_, &_tmp32_);
		x = _tmp31_;
		y = _tmp32_;
		_tmp33_ = self->priv->_hide_progress;
		x_offset = x_offset - ((gint) (x * _tmp33_));
		_tmp34_ = self->priv->_hide_progress;
		y_offset = y_offset - ((gint) (y * _tmp34_));
	}
	_tmp35_ = self->priv->background_buffer;
	_tmp36_ = plank_surface_get_Internal (_tmp35_);
	_tmp37_ = _tmp36_;
	_tmp38_ = *background_rect;
	_tmp39_ = *background_rect;
	cairo_set_source_surface (cr, _tmp37_, (gdouble) (_tmp38_.x + x_offset), (gdouble) (_tmp39_.y + y_offset));
	cairo_paint (cr);
}

static void
plank_dock_renderer_animate_draw_value_for_item (PlankDockItem* item,
                                                 PlankDockItemDrawValue* draw_value,
                                                 PlankDockRenderer* self)
{
	PlankPositionManager* position_manager = NULL;
	PlankDockController* _tmp0_;
	PlankPositionManager* _tmp1_;
	PlankPositionManager* _tmp2_;
	PlankDockItem* hovered_item = NULL;
	PlankDockController* _tmp3_;
	PlankDockWindow* _tmp4_;
	PlankDockWindow* _tmp5_;
	PlankDockItem* _tmp6_;
	PlankDockItem* _tmp7_;
	PlankDragManager* drag_manager = NULL;
	PlankDockController* _tmp8_;
	PlankDragManager* _tmp9_;
	PlankDragManager* _tmp10_;
	gint icon_size = 0;
	GtkPositionType position = 0;
	PlankPositionManager* _tmp11_;
	GtkPositionType _tmp12_;
	GtkPositionType _tmp13_;
	gdouble x_offset = 0.0;
	gdouble y_offset = 0.0;
	gint _tmp14_ = 0;
	PlankAnimationType _tmp15_;
	PlankAnimationType _tmp16_;
	gint max_click_time = 0;
	gint64 click_time = 0LL;
	gint64 _tmp23_;
	gint64 _tmp24_;
	gint64 _tmp25_;
	gint64 _tmp26_;
	guint max_scroll_time = 0U;
	gint64 scroll_time = 0LL;
	gint64 _tmp32_;
	gint64 _tmp33_;
	gint64 _tmp34_;
	gint64 _tmp35_;
	guint max_hover_time = 0U;
	gint64 hover_time = 0LL;
	gint64 _tmp38_;
	gint64 _tmp39_;
	gint64 _tmp40_;
	gint64 _tmp41_;
	gboolean _tmp46_ = FALSE;
	PlankDockItem* _tmp47_;
	gboolean _tmp60_ = FALSE;
	gboolean _tmp61_ = FALSE;
	PlankDockContainer* container = NULL;
	PlankDockContainer* _tmp74_;
	PlankDockContainer* _tmp75_;
	gboolean _tmp76_ = FALSE;
	gboolean allow_animation = FALSE;
	gboolean _tmp84_ = FALSE;
	PlankItemState _tmp121_;
	PlankItemState _tmp122_;
	PlankItemState _tmp141_;
	PlankItemState _tmp142_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	g_return_if_fail (draw_value != NULL);
	_tmp0_ = self->priv->_controller;
	_tmp1_ = plank_dock_controller_get_position_manager (_tmp0_);
	_tmp2_ = _tmp1_;
	position_manager = _tmp2_;
	_tmp3_ = self->priv->_controller;
	_tmp4_ = plank_dock_controller_get_window (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = plank_dock_window_get_HoveredItem (_tmp5_);
	_tmp7_ = _tmp6_;
	hovered_item = _tmp7_;
	_tmp8_ = self->priv->_controller;
	_tmp9_ = plank_dock_controller_get_drag_manager (_tmp8_);
	_tmp10_ = _tmp9_;
	drag_manager = _tmp10_;
	icon_size = (gint) draw_value->icon_size;
	_tmp11_ = position_manager;
	_tmp12_ = plank_position_manager_get_Position (_tmp11_);
	_tmp13_ = _tmp12_;
	position = _tmp13_;
	x_offset = 0.0;
	y_offset = 0.0;
	_tmp15_ = plank_dock_element_get_ClickedAnimation ((PlankDockElement*) item);
	_tmp16_ = _tmp15_;
	if (_tmp16_ == PLANK_ANIMATION_TYPE_BOUNCE) {
		PlankDockTheme* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		_tmp17_ = self->priv->_theme;
		_tmp18_ = plank_dock_theme_get_LaunchBounceTime (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp14_ = _tmp19_;
	} else {
		PlankDockTheme* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		_tmp20_ = self->priv->_theme;
		_tmp21_ = plank_dock_theme_get_ClickTime (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp14_ = _tmp22_;
	}
	max_click_time = _tmp14_;
	max_click_time *= 1000;
	_tmp23_ = plank_renderer_get_frame_time ((PlankRenderer*) self);
	_tmp24_ = _tmp23_;
	_tmp25_ = plank_dock_element_get_LastClicked ((PlankDockElement*) item);
	_tmp26_ = _tmp25_;
	click_time = MAX (0LL, _tmp24_ - _tmp26_);
	if (click_time < ((gint64) max_click_time)) {
		gdouble click_animation_progress = 0.0;
		PlankAnimationType _tmp27_;
		PlankAnimationType _tmp28_;
		click_animation_progress = click_time / ((gdouble) max_click_time);
		_tmp27_ = plank_dock_element_get_ClickedAnimation ((PlankDockElement*) item);
		_tmp28_ = _tmp27_;
		switch (_tmp28_) {
			default:
			case PLANK_ANIMATION_TYPE_NONE:
			{
				break;
			}
			case PLANK_ANIMATION_TYPE_BOUNCE:
			{
				if (self->priv->screen_is_composited) {
					PlankPositionManager* _tmp29_;
					gint _tmp30_;
					gint _tmp31_;
					_tmp29_ = position_manager;
					_tmp30_ = plank_position_manager_get_LaunchBounceHeight (_tmp29_);
					_tmp31_ = _tmp30_;
					y_offset += _tmp31_ * plank_dock_renderer_easing_bounce ((gdouble) click_time, (gdouble) max_click_time, (gdouble) 2);
				}
				break;
			}
			case PLANK_ANIMATION_TYPE_DARKEN:
			{
				draw_value->darken = MAX ((gdouble) 0, sin (G_PI * click_animation_progress)) * 0.5;
				break;
			}
			case PLANK_ANIMATION_TYPE_LIGHTEN:
			{
				draw_value->lighten = MAX ((gdouble) 0, sin (G_PI * click_animation_progress)) * 0.5;
				break;
			}
		}
	}
	max_scroll_time = PLANK_ITEM_SCROLL_DURATION * 1000;
	_tmp32_ = plank_renderer_get_frame_time ((PlankRenderer*) self);
	_tmp33_ = _tmp32_;
	_tmp34_ = plank_dock_element_get_LastScrolled ((PlankDockElement*) item);
	_tmp35_ = _tmp34_;
	scroll_time = MAX (0LL, _tmp33_ - _tmp35_);
	if (scroll_time < ((gint64) max_scroll_time)) {
		gdouble scroll_animation_progress = 0.0;
		PlankAnimationType _tmp36_;
		PlankAnimationType _tmp37_;
		scroll_animation_progress = scroll_time / ((gdouble) max_scroll_time);
		_tmp36_ = plank_dock_element_get_ScrolledAnimation ((PlankDockElement*) item);
		_tmp37_ = _tmp36_;
		switch (_tmp37_) {
			default:
			case PLANK_ANIMATION_TYPE_NONE:
			{
				break;
			}
			case PLANK_ANIMATION_TYPE_DARKEN:
			{
				draw_value->darken = MAX ((gdouble) 0, sin (G_PI * scroll_animation_progress)) * 0.5;
				break;
			}
			case PLANK_ANIMATION_TYPE_LIGHTEN:
			{
				draw_value->lighten = MAX ((gdouble) 0, sin (G_PI * scroll_animation_progress)) * 0.5;
				break;
			}
		}
	}
	max_hover_time = PLANK_ITEM_HOVER_DURATION * 1000;
	_tmp38_ = plank_renderer_get_frame_time ((PlankRenderer*) self);
	_tmp39_ = _tmp38_;
	_tmp40_ = plank_dock_element_get_LastHovered ((PlankDockElement*) item);
	_tmp41_ = _tmp40_;
	hover_time = MAX (0LL, _tmp39_ - _tmp41_);
	if (hover_time < ((gint64) max_hover_time)) {
		gdouble hover_animation_progress = 0.0;
		PlankDockItem* _tmp42_;
		PlankAnimationType _tmp43_;
		PlankAnimationType _tmp44_;
		hover_animation_progress = 0.0;
		_tmp42_ = hovered_item;
		if (_tmp42_ == item) {
			hover_animation_progress = plank_easing_for_mode (PLANK_ANIMATION_MODE_LINEAR, (gdouble) hover_time, (gdouble) max_hover_time);
		} else {
			hover_animation_progress = 1.0 - plank_easing_for_mode (PLANK_ANIMATION_MODE_LINEAR, (gdouble) hover_time, (gdouble) max_hover_time);
		}
		_tmp43_ = plank_dock_element_get_HoveredAnimation ((PlankDockElement*) item);
		_tmp44_ = _tmp43_;
		switch (_tmp44_) {
			default:
			case PLANK_ANIMATION_TYPE_NONE:
			{
				break;
			}
			case PLANK_ANIMATION_TYPE_LIGHTEN:
			{
				draw_value->lighten = hover_animation_progress * 0.2;
				break;
			}
		}
	} else {
		PlankDockItem* _tmp45_;
		_tmp45_ = hovered_item;
		if (_tmp45_ == item) {
			draw_value->lighten = 0.2;
		}
	}
	_tmp47_ = hovered_item;
	if (_tmp47_ == item) {
		PlankDockController* _tmp48_;
		PlankDockWindow* _tmp49_;
		PlankDockWindow* _tmp50_;
		_tmp48_ = self->priv->_controller;
		_tmp49_ = plank_dock_controller_get_window (_tmp48_);
		_tmp50_ = _tmp49_;
		_tmp46_ = plank_dock_window_menu_is_visible (_tmp50_);
	} else {
		_tmp46_ = FALSE;
	}
	if (_tmp46_) {
		draw_value->darken = draw_value->darken + 0.4;
	} else {
		gboolean _tmp51_ = FALSE;
		gboolean _tmp52_ = FALSE;
		PlankDragManager* _tmp53_;
		gboolean _tmp54_;
		gboolean _tmp55_;
		_tmp53_ = drag_manager;
		_tmp54_ = plank_drag_manager_get_ExternalDragActive (_tmp53_);
		_tmp55_ = _tmp54_;
		if (_tmp55_) {
			PlankDragManager* _tmp56_;
			gboolean _tmp57_;
			gboolean _tmp58_;
			_tmp56_ = drag_manager;
			_tmp57_ = plank_drag_manager_get_DragNeedsCheck (_tmp56_);
			_tmp58_ = _tmp57_;
			_tmp52_ = _tmp58_;
		} else {
			_tmp52_ = FALSE;
		}
		if (_tmp52_) {
			PlankDragManager* _tmp59_;
			_tmp59_ = drag_manager;
			_tmp51_ = !plank_drag_manager_drop_is_accepted_by (_tmp59_, item);
		} else {
			_tmp51_ = FALSE;
		}
		if (_tmp51_) {
			draw_value->darken = draw_value->darken + 0.6;
		}
	}
	if (self->priv->screen_is_composited) {
		_tmp61_ = self->priv->show_notifications;
	} else {
		_tmp61_ = FALSE;
	}
	if (_tmp61_) {
		PlankItemState _tmp62_;
		PlankItemState _tmp63_;
		_tmp62_ = plank_dock_item_get_State (item);
		_tmp63_ = _tmp62_;
		_tmp60_ = (_tmp63_ & PLANK_ITEM_STATE_URGENT) != 0;
	} else {
		_tmp60_ = FALSE;
	}
	if (_tmp60_) {
		gint urgent_duration = 0;
		PlankDockTheme* _tmp64_;
		gint _tmp65_;
		gint _tmp66_;
		gint64 urgent_time = 0LL;
		gint64 _tmp67_;
		gint64 _tmp68_;
		gint64 _tmp69_;
		gint64 _tmp70_;
		_tmp64_ = self->priv->_theme;
		_tmp65_ = plank_dock_theme_get_UrgentBounceTime (_tmp64_);
		_tmp66_ = _tmp65_;
		urgent_duration = _tmp66_ * 1000;
		_tmp67_ = plank_renderer_get_frame_time ((PlankRenderer*) self);
		_tmp68_ = _tmp67_;
		_tmp69_ = plank_dock_element_get_LastUrgent ((PlankDockElement*) item);
		_tmp70_ = _tmp69_;
		urgent_time = MAX (0LL, _tmp68_ - _tmp70_);
		if (urgent_time < ((gint64) urgent_duration)) {
			PlankPositionManager* _tmp71_;
			gint _tmp72_;
			gint _tmp73_;
			_tmp71_ = position_manager;
			_tmp72_ = plank_position_manager_get_UrgentBounceHeight (_tmp71_);
			_tmp73_ = _tmp72_;
			y_offset += _tmp73_ * plank_dock_renderer_easing_bounce ((gdouble) urgent_time, (gdouble) urgent_duration, 1.0);
		}
	}
	_tmp74_ = plank_dock_element_get_Container ((PlankDockElement*) item);
	_tmp75_ = _tmp74_;
	container = _tmp75_;
	if (self->priv->screen_is_composited) {
		gboolean _tmp77_ = FALSE;
		PlankDockContainer* _tmp78_;
		_tmp78_ = container;
		if (_tmp78_ == NULL) {
			_tmp77_ = TRUE;
		} else {
			PlankDockContainer* _tmp79_;
			gint64 _tmp80_;
			gint64 _tmp81_;
			gint64 _tmp82_;
			gint64 _tmp83_;
			_tmp79_ = container;
			_tmp80_ = plank_dock_element_get_AddTime ((PlankDockElement*) _tmp79_);
			_tmp81_ = _tmp80_;
			_tmp82_ = plank_dock_element_get_AddTime ((PlankDockElement*) item);
			_tmp83_ = _tmp82_;
			_tmp77_ = _tmp81_ < _tmp83_;
		}
		_tmp76_ = _tmp77_;
	} else {
		_tmp76_ = FALSE;
	}
	allow_animation = _tmp76_;
	if (allow_animation) {
		gint64 _tmp85_;
		gint64 _tmp86_;
		gint64 _tmp87_;
		gint64 _tmp88_;
		_tmp85_ = plank_dock_element_get_AddTime ((PlankDockElement*) item);
		_tmp86_ = _tmp85_;
		_tmp87_ = plank_dock_element_get_RemoveTime ((PlankDockElement*) item);
		_tmp88_ = _tmp87_;
		_tmp84_ = _tmp86_ > _tmp88_;
	} else {
		_tmp84_ = FALSE;
	}
	if (_tmp84_) {
		gint move_duration = 0;
		PlankDockTheme* _tmp89_;
		gint _tmp90_;
		gint _tmp91_;
		gint64 move_time = 0LL;
		gint64 _tmp92_;
		gint64 _tmp93_;
		gint64 _tmp94_;
		gint64 _tmp95_;
		_tmp89_ = self->priv->_theme;
		_tmp90_ = plank_dock_theme_get_ItemMoveTime (_tmp89_);
		_tmp91_ = _tmp90_;
		move_duration = _tmp91_ * 1000;
		_tmp92_ = plank_renderer_get_frame_time ((PlankRenderer*) self);
		_tmp93_ = _tmp92_;
		_tmp94_ = plank_dock_element_get_AddTime ((PlankDockElement*) item);
		_tmp95_ = _tmp94_;
		move_time = MAX (0LL, _tmp93_ - _tmp95_);
		if (move_time < ((gint64) move_duration)) {
			gdouble move_animation_progress = 0.0;
			PlankPositionManager* _tmp96_;
			gint _tmp97_;
			gint _tmp98_;
			PlankPositionManager* _tmp99_;
			gint _tmp100_;
			gint _tmp101_;
			move_animation_progress = 1.0 - plank_easing_for_mode (PLANK_ANIMATION_MODE_LINEAR, (gdouble) move_time, (gdouble) move_duration);
			draw_value->opacity = plank_easing_for_mode (PLANK_ANIMATION_MODE_EASE_IN_EXPO, (gdouble) move_time, (gdouble) move_duration);
			_tmp96_ = position_manager;
			_tmp97_ = plank_position_manager_get_BottomPadding (_tmp96_);
			_tmp98_ = _tmp97_;
			y_offset -= move_animation_progress * (icon_size + _tmp98_);
			draw_value->show_indicator = FALSE;
			move_animation_progress = 1.0 - plank_easing_for_mode (PLANK_ANIMATION_MODE_EASE_OUT_QUINT, (gdouble) move_time, (gdouble) move_duration);
			_tmp99_ = position_manager;
			_tmp100_ = plank_position_manager_get_ItemPadding (_tmp99_);
			_tmp101_ = _tmp100_;
			self->priv->dynamic_animation_offset = self->priv->dynamic_animation_offset - (move_animation_progress * (icon_size + _tmp101_));
			x_offset += self->priv->dynamic_animation_offset;
		}
	} else {
		gboolean _tmp102_ = FALSE;
		if (allow_animation) {
			gint64 _tmp103_;
			gint64 _tmp104_;
			_tmp103_ = plank_dock_element_get_RemoveTime ((PlankDockElement*) item);
			_tmp104_ = _tmp103_;
			_tmp102_ = _tmp104_ > ((gint64) 0);
		} else {
			_tmp102_ = FALSE;
		}
		if (_tmp102_) {
			gint move_duration = 0;
			PlankDockTheme* _tmp105_;
			gint _tmp106_;
			gint _tmp107_;
			gint64 move_time = 0LL;
			gint64 _tmp108_;
			gint64 _tmp109_;
			gint64 _tmp110_;
			gint64 _tmp111_;
			_tmp105_ = self->priv->_theme;
			_tmp106_ = plank_dock_theme_get_ItemMoveTime (_tmp105_);
			_tmp107_ = _tmp106_;
			move_duration = _tmp107_ * 1000;
			_tmp108_ = plank_renderer_get_frame_time ((PlankRenderer*) self);
			_tmp109_ = _tmp108_;
			_tmp110_ = plank_dock_element_get_RemoveTime ((PlankDockElement*) item);
			_tmp111_ = _tmp110_;
			move_time = MAX (0LL, _tmp109_ - _tmp111_);
			if (move_time < ((gint64) move_duration)) {
				gdouble move_animation_progress = 0.0;
				PlankPositionManager* _tmp112_;
				gint _tmp113_;
				gint _tmp114_;
				PlankPositionManager* _tmp115_;
				gint _tmp116_;
				gint _tmp117_;
				PlankPositionManager* _tmp118_;
				gint _tmp119_;
				gint _tmp120_;
				move_animation_progress = plank_easing_for_mode (PLANK_ANIMATION_MODE_LINEAR, (gdouble) move_time, (gdouble) move_duration);
				draw_value->opacity = 1.0 - plank_easing_for_mode (PLANK_ANIMATION_MODE_EASE_OUT_EXPO, (gdouble) move_time, (gdouble) move_duration);
				_tmp112_ = position_manager;
				_tmp113_ = plank_position_manager_get_BottomPadding (_tmp112_);
				_tmp114_ = _tmp113_;
				y_offset -= move_animation_progress * (icon_size + _tmp114_);
				draw_value->show_indicator = FALSE;
				move_animation_progress = 1.0 - plank_easing_for_mode (PLANK_ANIMATION_MODE_EASE_IN_QUINT, (gdouble) move_time, (gdouble) move_duration);
				_tmp115_ = position_manager;
				_tmp116_ = plank_position_manager_get_ItemPadding (_tmp115_);
				_tmp117_ = _tmp116_;
				self->priv->dynamic_animation_offset = self->priv->dynamic_animation_offset + (move_animation_progress * (icon_size + _tmp117_));
				_tmp118_ = position_manager;
				_tmp119_ = plank_position_manager_get_ItemPadding (_tmp118_);
				_tmp120_ = _tmp119_;
				x_offset += self->priv->dynamic_animation_offset - (icon_size + _tmp120_);
			}
		}
	}
	_tmp121_ = plank_dock_item_get_State (item);
	_tmp122_ = _tmp121_;
	if ((_tmp122_ & PLANK_ITEM_STATE_MOVE) != 0) {
		gint move_duration = 0;
		PlankDockTheme* _tmp123_;
		gint _tmp124_;
		gint _tmp125_;
		gint64 move_time = 0LL;
		gint64 _tmp126_;
		gint64 _tmp127_;
		gint64 _tmp128_;
		gint64 _tmp129_;
		_tmp123_ = self->priv->_theme;
		_tmp124_ = plank_dock_theme_get_ItemMoveTime (_tmp123_);
		_tmp125_ = _tmp124_;
		move_duration = _tmp125_ * 1000;
		_tmp126_ = plank_renderer_get_frame_time ((PlankRenderer*) self);
		_tmp127_ = _tmp126_;
		_tmp128_ = plank_dock_element_get_LastMove ((PlankDockElement*) item);
		_tmp129_ = _tmp128_;
		move_time = MAX (0LL, _tmp127_ - _tmp129_);
		if (move_time < ((gint64) move_duration)) {
			gdouble move_animation_progress = 0.0;
			GeeHashSet* _tmp130_;
			gint _tmp131_;
			gint _tmp132_;
			gdouble change = 0.0;
			PlankPositionManager* _tmp133_;
			gint _tmp134_;
			gint _tmp135_;
			gdouble _tmp136_ = 0.0;
			gint _tmp137_;
			gint _tmp138_;
			gint _tmp139_;
			gint _tmp140_;
			move_animation_progress = 0.0;
			_tmp130_ = self->priv->transient_items;
			_tmp131_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp130_);
			_tmp132_ = _tmp131_;
			if (_tmp132_ > 0) {
				if (self->priv->dynamic_animation_offset > ((gdouble) 0)) {
					move_animation_progress = 1.0 - plank_easing_for_mode (PLANK_ANIMATION_MODE_EASE_IN_QUINT, (gdouble) move_time, (gdouble) move_duration);
				} else {
					move_animation_progress = 1.0 - plank_easing_for_mode (PLANK_ANIMATION_MODE_EASE_OUT_QUINT, (gdouble) move_time, (gdouble) move_duration);
				}
			} else {
				move_animation_progress = 1.0 - plank_easing_for_mode (PLANK_ANIMATION_MODE_EASE_OUT_CIRC, (gdouble) move_time, (gdouble) move_duration);
			}
			_tmp133_ = position_manager;
			_tmp134_ = plank_position_manager_get_ItemPadding (_tmp133_);
			_tmp135_ = _tmp134_;
			change = move_animation_progress * (icon_size + _tmp135_);
			_tmp137_ = plank_dock_item_get_Position (item);
			_tmp138_ = _tmp137_;
			_tmp139_ = plank_dock_item_get_LastPosition (item);
			_tmp140_ = _tmp139_;
			if (_tmp138_ < _tmp140_) {
				_tmp136_ = change;
			} else {
				_tmp136_ = -change;
			}
			x_offset += _tmp136_;
		} else {
			plank_dock_item_unset_move_state (item);
		}
	}
	_tmp141_ = plank_dock_item_get_State (item);
	_tmp142_ = _tmp141_;
	if ((_tmp142_ & PLANK_ITEM_STATE_INVALID) != 0) {
		guint invalid_duration = 0U;
		gint64 invalid_time = 0LL;
		gint64 _tmp143_;
		gint64 _tmp144_;
		gint64 _tmp145_;
		gint64 _tmp146_;
		invalid_duration = PLANK_ITEM_INVALID_DURATION * 1000;
		_tmp143_ = plank_renderer_get_frame_time ((PlankRenderer*) self);
		_tmp144_ = _tmp143_;
		_tmp145_ = plank_dock_element_get_LastValid ((PlankDockElement*) item);
		_tmp146_ = _tmp145_;
		invalid_time = MAX (0LL, _tmp144_ - _tmp146_);
		if (invalid_time < ((gint64) invalid_duration)) {
			draw_value->opacity = 0.10 + ((0.90 * (cos (((invalid_time / ((gdouble) invalid_duration)) * 4.5) * G_PI) + 1)) / 2);
		} else {
			draw_value->opacity = 0.10;
		}
	}
	if (x_offset != 0.0) {
		plank_dock_item_draw_value_move_right (draw_value, position, x_offset);
	}
	if (y_offset != 0.0) {
		plank_dock_item_draw_value_move_in (draw_value, position, y_offset);
	}
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		PlankDockRenderer* self;
		self = _data2_->self;
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static gboolean
__lambda46_ (Block2Data* _data2_,
             PlankDockElement* i,
             PlankDockItemDrawValue* val)
{
	PlankDockRenderer* self;
	gboolean result;
	self = _data2_->self;
	g_return_val_if_fail (i != NULL, FALSE);
	plank_dock_item_draw_value_move_right (val, _data2_->position, _data2_->x_offset);
	result = TRUE;
	return result;
}

static gboolean
___lambda46__gee_forall_map_func (gconstpointer k,
                                  gconstpointer v,
                                  gpointer self)
{
	gboolean result;
	result = __lambda46_ (self, (PlankDockElement*) k, (PlankDockItemDrawValue*) v);
	return result;
}

static void
plank_dock_renderer_post_process_draw_values (GeeHashMap* draw_values,
                                              PlankDockRenderer* self)
{
	Block2Data* _data2_;
	PlankPositionManager* position_manager = NULL;
	PlankDockController* _tmp0_;
	PlankPositionManager* _tmp1_;
	PlankPositionManager* _tmp2_;
	PlankPositionManager* _tmp3_;
	GtkPositionType _tmp4_;
	GtkPositionType _tmp5_;
	PlankPositionManager* _tmp6_;
	GtkAlign _tmp7_;
	GtkAlign _tmp8_;
	GeeMapIterator* _tmp12_;
	GeeMapIterator* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (draw_values != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	if (self->priv->dynamic_animation_offset == 0.0) {
		block2_data_unref (_data2_);
		_data2_ = NULL;
		return;
	}
	_tmp0_ = self->priv->_controller;
	_tmp1_ = plank_dock_controller_get_position_manager (_tmp0_);
	_tmp2_ = _tmp1_;
	position_manager = _tmp2_;
	_tmp3_ = position_manager;
	_tmp4_ = plank_position_manager_get_Position (_tmp3_);
	_tmp5_ = _tmp4_;
	_data2_->position = _tmp5_;
	_data2_->x_offset = 0.0;
	_tmp6_ = position_manager;
	_tmp7_ = plank_position_manager_get_Alignment (_tmp6_);
	_tmp8_ = _tmp7_;
	switch (_tmp8_) {
		default:
		case GTK_ALIGN_CENTER:
		{
			_data2_->x_offset -= round (self->priv->dynamic_animation_offset / 2.0);
			break;
		}
		case GTK_ALIGN_START:
		{
			break;
		}
		case GTK_ALIGN_END:
		{
			_data2_->x_offset -= round (self->priv->dynamic_animation_offset);
			break;
		}
		case GTK_ALIGN_FILL:
		{
			PlankPositionManager* _tmp9_;
			GtkAlign _tmp10_;
			GtkAlign _tmp11_;
			_tmp9_ = position_manager;
			_tmp10_ = plank_position_manager_get_ItemsAlignment (_tmp9_);
			_tmp11_ = _tmp10_;
			switch (_tmp11_) {
				default:
				case GTK_ALIGN_FILL:
				case GTK_ALIGN_CENTER:
				{
					_data2_->x_offset -= round (self->priv->dynamic_animation_offset / 2.0);
					break;
				}
				case GTK_ALIGN_START:
				{
					break;
				}
				case GTK_ALIGN_END:
				{
					_data2_->x_offset -= round (self->priv->dynamic_animation_offset);
					break;
				}
			}
			break;
		}
	}
	if (_data2_->x_offset == 0.0) {
		block2_data_unref (_data2_);
		_data2_ = NULL;
		return;
	}
	_tmp12_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) draw_values);
	_tmp13_ = _tmp12_;
	gee_map_iterator_foreach (_tmp13_, ___lambda46__gee_forall_map_func, _data2_);
	_g_object_unref0 (_tmp13_);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}

static inline PlankSurface*
plank_dock_renderer_get_item_surface (PlankDockRenderer* self,
                                      PlankDockItem* item,
                                      gint icon_size)
{
	PlankSurface* private_icon_surface = NULL;
	PlankSurface* _tmp0_;
	PlankSurface* _tmp1_;
	gchar* drawing_status = NULL;
	PlankPositionManager* position_manager = NULL;
	PlankDockController* _tmp2_;
	PlankPositionManager* _tmp3_;
	PlankPositionManager* _tmp4_;
	gint max_icon_size = 0;
	PlankPositionManager* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gboolean _tmp8_ = FALSE;
	PlankSurface* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (item != NULL, NULL);
	_tmp0_ = self->priv->item_buffer;
	_tmp1_ = plank_dock_item_get_surface (item, icon_size, icon_size, _tmp0_);
	private_icon_surface = _tmp1_;
	if (!self->priv->screen_is_composited) {
		result = private_icon_surface;
		return result;
	}
	_tmp2_ = self->priv->_controller;
	_tmp3_ = plank_dock_controller_get_position_manager (_tmp2_);
	_tmp4_ = _tmp3_;
	position_manager = _tmp4_;
	_tmp5_ = position_manager;
	_tmp6_ = plank_position_manager_get_ZoomIconSize (_tmp5_);
	_tmp7_ = _tmp6_;
	max_icon_size = _tmp7_ * self->priv->window_scale_factor;
	if (icon_size < max_icon_size) {
		gboolean _tmp9_ = FALSE;
		PlankSurface* _tmp10_;
		gpointer _tmp11_;
		const gchar* _tmp12_;
		_tmp10_ = private_icon_surface;
		_tmp11_ = g_object_steal_qdata ((GObject*) _tmp10_, plank_quark_surface_stats);
		_g_free0 (drawing_status);
		drawing_status = (gchar*) _tmp11_;
		_tmp12_ = drawing_status;
		if (_tmp12_ != NULL) {
			const gchar* _tmp13_;
			_tmp13_ = drawing_status;
			_tmp9_ = g_strcmp0 (_tmp13_, PLANK_SURFACE_STATS_DRAWING_TIME_EXCEEDED) == 0;
		} else {
			_tmp9_ = FALSE;
		}
		_tmp8_ = _tmp9_;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		PlankSurface* _tmp14_;
		PlankSurface* _tmp15_;
		PlankSurface* _tmp16_;
		_tmp14_ = self->priv->item_buffer;
		_tmp15_ = plank_dock_item_get_surface (item, max_icon_size, max_icon_size, _tmp14_);
		_tmp16_ = _tmp15_;
		_g_object_unref0 (_tmp16_);
	}
	result = private_icon_surface;
	_g_free0 (drawing_status);
	return result;
}

static void
plank_dock_renderer_draw_item (PlankDockRenderer* self,
                               cairo_t* cr,
                               PlankDockItem* item,
                               PlankDockItemDrawValue* draw_value,
                               gint64 frame_time)
{
	PlankPositionManager* position_manager = NULL;
	PlankDockController* _tmp0_;
	PlankPositionManager* _tmp1_;
	PlankPositionManager* _tmp2_;
	gint icon_size = 0;
	GtkPositionType position = 0;
	PlankPositionManager* _tmp3_;
	GtkPositionType _tmp4_;
	GtkPositionType _tmp5_;
	PlankSurface* icon_surface = NULL;
	PlankSurface* _tmp6_;
	PlankSurface* _tmp7_;
	PlankSurface* _tmp8_;
	PlankSurface* _tmp9_;
	cairo_t* icon_cr = NULL;
	PlankSurface* _tmp10_;
	cairo_t* _tmp11_;
	cairo_t* _tmp12_;
	PlankSurface* icon_overlay_surface = NULL;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_;
	gboolean _tmp15_;
	PlankSurface* _tmp20_;
	gint64 active_time = 0LL;
	gint64 _tmp40_;
	gint64 _tmp41_;
	gdouble opacity = 0.0;
	PlankDockTheme* _tmp42_;
	gint _tmp43_;
	gint _tmp44_;
	PlankItemState _tmp45_;
	PlankItemState _tmp46_;
	GdkRectangle draw_region = {0};
	GdkRectangle _tmp53_;
	PlankSurface* _tmp54_;
	cairo_surface_t* _tmp55_;
	cairo_surface_t* _tmp56_;
	GdkRectangle _tmp57_;
	GdkRectangle _tmp58_;
	gboolean _tmp59_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	g_return_if_fail (item != NULL);
	g_return_if_fail (draw_value != NULL);
	_tmp0_ = self->priv->_controller;
	_tmp1_ = plank_dock_controller_get_position_manager (_tmp0_);
	_tmp2_ = _tmp1_;
	position_manager = _tmp2_;
	icon_size = ((gint) draw_value->icon_size) * self->priv->window_scale_factor;
	_tmp3_ = position_manager;
	_tmp4_ = plank_position_manager_get_Position (_tmp3_);
	_tmp5_ = _tmp4_;
	position = _tmp5_;
	_tmp6_ = plank_dock_renderer_get_item_surface (self, item, icon_size);
	_tmp7_ = _tmp6_;
	_tmp8_ = plank_surface_copy (_tmp7_);
	_tmp9_ = _tmp8_;
	_g_object_unref0 (_tmp7_);
	icon_surface = _tmp9_;
	_tmp10_ = icon_surface;
	_tmp11_ = plank_surface_get_Context (_tmp10_);
	_tmp12_ = _tmp11_;
	icon_cr = _tmp12_;
	icon_overlay_surface = NULL;
	_tmp14_ = plank_dock_item_get_CountVisible (item);
	_tmp15_ = _tmp14_;
	if (_tmp15_) {
		_tmp13_ = TRUE;
	} else {
		gboolean _tmp16_;
		gboolean _tmp17_;
		_tmp16_ = plank_dock_item_get_ProgressVisible (item);
		_tmp17_ = _tmp16_;
		_tmp13_ = _tmp17_;
	}
	if (_tmp13_) {
		PlankSurface* _tmp18_;
		PlankSurface* _tmp19_;
		_tmp18_ = self->priv->item_buffer;
		_tmp19_ = plank_dock_item_get_foreground_surface (item, icon_size, icon_size, _tmp18_, (PlankDrawDataFunc) plank_dock_renderer_draw_item_foreground, self);
		_g_object_unref0 (icon_overlay_surface);
		icon_overlay_surface = _tmp19_;
	}
	_tmp20_ = icon_overlay_surface;
	if (_tmp20_ != NULL) {
		cairo_t* _tmp21_;
		PlankSurface* _tmp22_;
		cairo_surface_t* _tmp23_;
		cairo_surface_t* _tmp24_;
		cairo_t* _tmp25_;
		_tmp21_ = icon_cr;
		_tmp22_ = icon_overlay_surface;
		_tmp23_ = plank_surface_get_Internal (_tmp22_);
		_tmp24_ = _tmp23_;
		cairo_set_source_surface (_tmp21_, _tmp24_, (gdouble) 0, (gdouble) 0);
		_tmp25_ = icon_cr;
		cairo_paint (_tmp25_);
	}
	if (draw_value->lighten > ((gdouble) 0)) {
		cairo_t* _tmp26_;
		cairo_t* _tmp27_;
		cairo_t* _tmp28_;
		_tmp26_ = icon_cr;
		cairo_set_operator (_tmp26_, CAIRO_OPERATOR_ADD);
		_tmp27_ = icon_cr;
		cairo_paint_with_alpha (_tmp27_, draw_value->lighten);
		_tmp28_ = icon_cr;
		cairo_set_operator (_tmp28_, CAIRO_OPERATOR_OVER);
	}
	if (draw_value->darken > ((gdouble) 0)) {
		cairo_t* _tmp29_;
		PlankSurface* _tmp30_;
		gint _tmp31_;
		gint _tmp32_;
		PlankSurface* _tmp33_;
		gint _tmp34_;
		gint _tmp35_;
		cairo_t* _tmp36_;
		cairo_t* _tmp37_;
		cairo_t* _tmp38_;
		cairo_t* _tmp39_;
		_tmp29_ = icon_cr;
		_tmp30_ = icon_surface;
		_tmp31_ = plank_surface_get_Width (_tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = icon_surface;
		_tmp34_ = plank_surface_get_Height (_tmp33_);
		_tmp35_ = _tmp34_;
		cairo_rectangle (_tmp29_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp32_, (gdouble) _tmp35_);
		_tmp36_ = icon_cr;
		cairo_set_source_rgba (_tmp36_, (gdouble) 0, (gdouble) 0, (gdouble) 0, draw_value->darken);
		_tmp37_ = icon_cr;
		cairo_set_operator (_tmp37_, CAIRO_OPERATOR_ATOP);
		_tmp38_ = icon_cr;
		cairo_fill (_tmp38_);
		_tmp39_ = icon_cr;
		cairo_set_operator (_tmp39_, CAIRO_OPERATOR_OVER);
	}
	_tmp40_ = plank_dock_element_get_LastActive ((PlankDockElement*) item);
	_tmp41_ = _tmp40_;
	active_time = MAX (0LL, frame_time - _tmp41_);
	_tmp42_ = self->priv->_theme;
	_tmp43_ = plank_dock_theme_get_ActiveTime (_tmp42_);
	_tmp44_ = _tmp43_;
	opacity = MIN ((gdouble) 1, active_time / ((gdouble) (_tmp44_ * 1000)));
	_tmp45_ = plank_dock_item_get_State (item);
	_tmp46_ = _tmp45_;
	if ((_tmp46_ & PLANK_ITEM_STATE_ACTIVE) == 0) {
		opacity = 1 - opacity;
	}
	if (opacity > ((gdouble) 0)) {
		PlankDockTheme* _tmp47_;
		PlankSurface* _tmp48_;
		GdkRectangle _tmp49_;
		GdkRectangle _tmp50_;
		PlankColor _tmp51_ = {0};
		PlankColor _tmp52_;
		_tmp47_ = self->priv->_theme;
		_tmp48_ = self->priv->item_buffer;
		_tmp49_ = self->priv->background_rect;
		_tmp50_ = draw_value->background_region;
		plank_dock_item_get_AverageIconColor (item, &_tmp51_);
		_tmp52_ = _tmp51_;
		plank_dock_theme_draw_active_glow (_tmp47_, _tmp48_, &_tmp49_, &_tmp50_, &_tmp52_, opacity, position);
	}
	if (self->priv->window_scale_factor > 1) {
		cairo_save (cr);
		cairo_scale (cr, 1.0 / self->priv->window_scale_factor, 1.0 / self->priv->window_scale_factor);
	}
	_tmp53_ = draw_value->draw_region;
	draw_region = _tmp53_;
	_tmp54_ = icon_surface;
	_tmp55_ = plank_surface_get_Internal (_tmp54_);
	_tmp56_ = _tmp55_;
	_tmp57_ = draw_region;
	_tmp58_ = draw_region;
	cairo_set_source_surface (cr, _tmp56_, (gdouble) (_tmp57_.x * self->priv->window_scale_factor), (gdouble) (_tmp58_.y * self->priv->window_scale_factor));
	if (draw_value->opacity < 1.0) {
		cairo_paint_with_alpha (cr, draw_value->opacity);
	} else {
		cairo_paint (cr);
	}
	if (self->priv->window_scale_factor > 1) {
		cairo_restore (cr);
	}
	if (draw_value->show_indicator) {
		PlankIndicatorState _tmp60_;
		PlankIndicatorState _tmp61_;
		_tmp60_ = plank_dock_item_get_Indicator (item);
		_tmp61_ = _tmp60_;
		_tmp59_ = _tmp61_ != PLANK_INDICATOR_STATE_NONE;
	} else {
		_tmp59_ = FALSE;
	}
	if (_tmp59_) {
		GdkRectangle _tmp62_;
		PlankIndicatorState _tmp63_;
		PlankIndicatorState _tmp64_;
		PlankItemState _tmp65_;
		PlankItemState _tmp66_;
		_tmp62_ = draw_value->hover_region;
		_tmp63_ = plank_dock_item_get_Indicator (item);
		_tmp64_ = _tmp63_;
		_tmp65_ = plank_dock_item_get_State (item);
		_tmp66_ = _tmp65_;
		plank_dock_renderer_draw_indicator_state (self, cr, &_tmp62_, _tmp64_, _tmp66_);
	}
	_g_object_unref0 (icon_overlay_surface);
	_g_object_unref0 (icon_surface);
}

static void
plank_dock_renderer_draw_item_shadow (PlankDockRenderer* self,
                                      cairo_t* cr,
                                      PlankDockItem* item,
                                      PlankDockItemDrawValue* draw_value)
{
	PlankPositionManager* position_manager = NULL;
	PlankDockController* _tmp0_;
	PlankPositionManager* _tmp1_;
	PlankPositionManager* _tmp2_;
	gint shadow_size = 0;
	PlankPositionManager* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint icon_size = 0;
	PlankSurface* icon_shadow_surface = NULL;
	PlankSurface* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	g_return_if_fail (item != NULL);
	g_return_if_fail (draw_value != NULL);
	_tmp0_ = self->priv->_controller;
	_tmp1_ = plank_dock_controller_get_position_manager (_tmp0_);
	_tmp2_ = _tmp1_;
	position_manager = _tmp2_;
	_tmp3_ = position_manager;
	_tmp4_ = plank_position_manager_get_IconShadowSize (_tmp3_);
	_tmp5_ = _tmp4_;
	shadow_size = _tmp5_;
	icon_size = ((gint) (draw_value->icon_size + (2 * shadow_size))) * self->priv->window_scale_factor;
	icon_shadow_surface = NULL;
	if (shadow_size > 0) {
		PlankSurface* _tmp6_;
		PlankSurface* _tmp7_;
		_tmp6_ = self->priv->item_buffer;
		_tmp7_ = plank_dock_item_get_background_surface (item, icon_size, icon_size, _tmp6_, (PlankDrawDataFunc) plank_dock_renderer_draw_item_background, self);
		_g_object_unref0 (icon_shadow_surface);
		icon_shadow_surface = _tmp7_;
	}
	_tmp8_ = icon_shadow_surface;
	if (_tmp8_ != NULL) {
		GdkRectangle draw_region = {0};
		GdkRectangle _tmp9_;
		PlankSurface* _tmp10_;
		cairo_surface_t* _tmp11_;
		cairo_surface_t* _tmp12_;
		GdkRectangle _tmp13_;
		GdkRectangle _tmp14_;
		if (self->priv->window_scale_factor > 1) {
			cairo_save (cr);
			cairo_scale (cr, 1.0 / self->priv->window_scale_factor, 1.0 / self->priv->window_scale_factor);
		}
		_tmp9_ = draw_value->draw_region;
		draw_region = _tmp9_;
		cairo_set_operator (cr, CAIRO_OPERATOR_OVER);
		_tmp10_ = icon_shadow_surface;
		_tmp11_ = plank_surface_get_Internal (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = draw_region;
		_tmp14_ = draw_region;
		cairo_set_source_surface (cr, _tmp12_, (gdouble) ((_tmp13_.x - shadow_size) * self->priv->window_scale_factor), (gdouble) ((_tmp14_.y - shadow_size) * self->priv->window_scale_factor));
		if (draw_value->opacity < 1.0) {
			cairo_paint_with_alpha (cr, draw_value->opacity);
		} else {
			cairo_paint (cr);
		}
		if (self->priv->window_scale_factor > 1) {
			cairo_restore (cr);
		}
	}
	_g_object_unref0 (icon_shadow_surface);
}

static PlankSurface*
plank_dock_renderer_draw_item_foreground (gint width,
                                          gint height,
                                          PlankSurface* model,
                                          PlankDockItem* item,
                                          PlankDockRenderer* self)
{
	PlankSurface* surface = NULL;
	PlankSurface* _tmp0_;
	gint icon_size = 0;
	PlankColor urgent_color = {0};
	PlankDockTheme* _tmp1_;
	PlankColor _tmp2_ = {0};
	PlankColor _tmp3_;
	GdkRGBA _tmp4_ = {0};
	gboolean _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp16_;
	gboolean _tmp17_;
	PlankSurface* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (model != NULL, NULL);
	g_return_val_if_fail (item != NULL, NULL);
	plank_logger_verbose ("DockItem.draw_item_overlay (width = %i, height = %i)", width, height, NULL);
	_tmp0_ = plank_surface_new_with_surface (width, height, model);
	surface = _tmp0_;
	icon_size = MIN (width, height);
	_tmp1_ = self->priv->_theme;
	plank_dock_theme_get_BadgeColor (_tmp1_, &_tmp2_);
	_tmp3_ = _tmp2_;
	urgent_color = _tmp3_;
	_tmp4_.red = 0.0;
	_tmp4_.green = 0.0;
	_tmp4_.blue = 0.0;
	_tmp4_.alpha = 0.0;
	if (gdk_rgba_equal (&urgent_color, &_tmp4_)) {
		PlankColor _tmp5_ = {0};
		PlankDockTheme* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		plank_dock_renderer_get_styled_color (self, &_tmp5_);
		urgent_color = _tmp5_;
		_tmp6_ = self->priv->_theme;
		_tmp7_ = plank_dock_theme_get_UrgentHueShift (_tmp6_);
		_tmp8_ = _tmp7_;
		plank_color_add_hue (&urgent_color, (gdouble) _tmp8_);
	}
	_tmp9_ = plank_dock_item_get_CountVisible (item);
	_tmp10_ = _tmp9_;
	if (_tmp10_) {
		PlankDockTheme* _tmp11_;
		PlankSurface* _tmp12_;
		PlankColor _tmp13_;
		gint64 _tmp14_;
		gint64 _tmp15_;
		_tmp11_ = self->priv->_theme;
		_tmp12_ = surface;
		_tmp13_ = urgent_color;
		_tmp14_ = plank_dock_item_get_Count (item);
		_tmp15_ = _tmp14_;
		plank_dock_theme_draw_item_count (_tmp11_, _tmp12_, icon_size, &_tmp13_, _tmp15_);
	}
	_tmp16_ = plank_dock_item_get_ProgressVisible (item);
	_tmp17_ = _tmp16_;
	if (_tmp17_) {
		PlankDockTheme* _tmp18_;
		PlankSurface* _tmp19_;
		PlankColor _tmp20_;
		gdouble _tmp21_;
		gdouble _tmp22_;
		_tmp18_ = self->priv->_theme;
		_tmp19_ = surface;
		_tmp20_ = urgent_color;
		_tmp21_ = plank_dock_item_get_Progress (item);
		_tmp22_ = _tmp21_;
		plank_dock_theme_draw_item_progress (_tmp18_, _tmp19_, icon_size, &_tmp20_, _tmp22_);
	}
	result = surface;
	return result;
}

static PlankSurface*
plank_dock_renderer_draw_item_background (gint width,
                                          gint height,
                                          PlankSurface* model,
                                          PlankDockItem* item,
                                          PlankDockRenderer* self)
{
	PlankPositionManager* position_manager = NULL;
	PlankDockController* _tmp0_;
	PlankPositionManager* _tmp1_;
	PlankPositionManager* _tmp2_;
	gint shadow_size = 0;
	PlankPositionManager* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	PlankDockItemDrawValue* draw_value = NULL;
	PlankPositionManager* _tmp6_;
	PlankDockItemDrawValue* _tmp7_;
	gint icon_size = 0;
	PlankDockItemDrawValue* _tmp8_;
	PlankSurface* icon_surface = NULL;
	PlankSurface* _tmp9_;
	PlankSurface* surface = NULL;
	PlankSurface* _tmp10_;
	cairo_t* cr = NULL;
	PlankSurface* _tmp11_;
	cairo_t* _tmp12_;
	cairo_t* _tmp13_;
	PlankSurface* shadow_surface = NULL;
	PlankSurface* _tmp14_;
	PlankSurface* _tmp15_;
	gint xoffset = 0;
	gint yoffset = 0;
	PlankPositionManager* _tmp16_;
	GtkPositionType _tmp17_;
	GtkPositionType _tmp18_;
	cairo_t* _tmp19_;
	PlankSurface* _tmp20_;
	cairo_surface_t* _tmp21_;
	cairo_surface_t* _tmp22_;
	cairo_t* _tmp23_;
	PlankSurface* _tmp24_;
	PlankSurface* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (model != NULL, NULL);
	g_return_val_if_fail (item != NULL, NULL);
	_tmp0_ = self->priv->_controller;
	_tmp1_ = plank_dock_controller_get_position_manager (_tmp0_);
	_tmp2_ = _tmp1_;
	position_manager = _tmp2_;
	_tmp3_ = position_manager;
	_tmp4_ = plank_position_manager_get_IconShadowSize (_tmp3_);
	_tmp5_ = _tmp4_;
	shadow_size = _tmp5_ * self->priv->window_scale_factor;
	_tmp6_ = position_manager;
	_tmp7_ = plank_position_manager_get_draw_value_for_item (_tmp6_, item);
	draw_value = _tmp7_;
	_tmp8_ = draw_value;
	icon_size = ((gint) _tmp8_->icon_size) * self->priv->window_scale_factor;
	_tmp9_ = plank_dock_item_get_surface (item, icon_size, icon_size, model);
	icon_surface = _tmp9_;
	plank_logger_verbose ("DockItem.draw_icon_with_shadow (width = %i, height = %i, shadow_size =" \
" %i)", width, height, shadow_size, NULL);
	_tmp10_ = plank_surface_new_with_surface (width, height, model);
	surface = _tmp10_;
	_tmp11_ = surface;
	_tmp12_ = plank_surface_get_Context (_tmp11_);
	_tmp13_ = _tmp12_;
	cr = _tmp13_;
	_tmp14_ = icon_surface;
	_tmp15_ = plank_surface_create_mask (_tmp14_, 0.4, NULL);
	shadow_surface = _tmp15_;
	xoffset = 0;
	yoffset = 0;
	_tmp16_ = position_manager;
	_tmp17_ = plank_position_manager_get_Position (_tmp16_);
	_tmp18_ = _tmp17_;
	switch (_tmp18_) {
		default:
		case GTK_POS_BOTTOM:
		{
			yoffset = (-shadow_size) / 4;
			break;
		}
		case GTK_POS_TOP:
		{
			yoffset = shadow_size / 4;
			break;
		}
		case GTK_POS_LEFT:
		{
			xoffset = shadow_size / 4;
			break;
		}
		case GTK_POS_RIGHT:
		{
			xoffset = (-shadow_size) / 4;
			break;
		}
	}
	_tmp19_ = cr;
	_tmp20_ = shadow_surface;
	_tmp21_ = plank_surface_get_Internal (_tmp20_);
	_tmp22_ = _tmp21_;
	cairo_set_source_surface (_tmp19_, _tmp22_, (gdouble) (shadow_size + xoffset), (gdouble) (shadow_size + yoffset));
	_tmp23_ = cr;
	cairo_paint_with_alpha (_tmp23_, 0.44);
	_tmp24_ = surface;
	plank_surface_gaussian_blur (_tmp24_, shadow_size);
	result = surface;
	_g_object_unref0 (shadow_surface);
	_g_object_unref0 (icon_surface);
	_plank_dock_item_draw_value_unref0 (draw_value);
	return result;
}

static void
plank_dock_renderer_draw_indicator_state (PlankDockRenderer* self,
                                          cairo_t* cr,
                                          GdkRectangle* item_rect,
                                          PlankIndicatorState indicator,
                                          PlankItemState item_state)
{
	PlankPositionManager* position_manager = NULL;
	PlankDockController* _tmp0_;
	PlankPositionManager* _tmp1_;
	PlankPositionManager* _tmp2_;
	PlankSurface* _tmp3_;
	PlankSurface* _tmp12_;
	PlankSurface* _tmp24_ = NULL;
	PlankSurface* indicator_surface = NULL;
	gdouble x = 0.0;
	gdouble y = 0.0;
	PlankPositionManager* _tmp27_;
	GtkPositionType _tmp28_;
	GtkPositionType _tmp29_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	g_return_if_fail (item_rect != NULL);
	_tmp0_ = self->priv->_controller;
	_tmp1_ = plank_dock_controller_get_position_manager (_tmp0_);
	_tmp2_ = _tmp1_;
	position_manager = _tmp2_;
	_tmp3_ = self->priv->indicator_buffer;
	if (_tmp3_ == NULL) {
		PlankColor indicator_color = {0};
		PlankColor _tmp4_ = {0};
		PlankDockTheme* _tmp5_;
		PlankPositionManager* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		PlankColor _tmp9_;
		PlankSurface* _tmp10_;
		PlankSurface* _tmp11_;
		plank_dock_renderer_get_styled_color (self, &_tmp4_);
		indicator_color = _tmp4_;
		plank_color_set_min_sat (&indicator_color, 0.4);
		_tmp5_ = self->priv->_theme;
		_tmp6_ = position_manager;
		_tmp7_ = plank_position_manager_get_IndicatorSize (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = indicator_color;
		_tmp10_ = self->priv->item_buffer;
		_tmp11_ = plank_dock_theme_create_indicator (_tmp5_, _tmp8_, &_tmp9_, _tmp10_);
		_g_object_unref0 (self->priv->indicator_buffer);
		self->priv->indicator_buffer = _tmp11_;
	}
	_tmp12_ = self->priv->urgent_indicator_buffer;
	if (_tmp12_ == NULL) {
		PlankColor urgent_indicator_color = {0};
		PlankColor _tmp13_ = {0};
		PlankDockTheme* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		PlankDockTheme* _tmp17_;
		PlankPositionManager* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		PlankColor _tmp21_;
		PlankSurface* _tmp22_;
		PlankSurface* _tmp23_;
		plank_dock_renderer_get_styled_color (self, &_tmp13_);
		urgent_indicator_color = _tmp13_;
		_tmp14_ = self->priv->_theme;
		_tmp15_ = plank_dock_theme_get_UrgentHueShift (_tmp14_);
		_tmp16_ = _tmp15_;
		plank_color_add_hue (&urgent_indicator_color, (gdouble) _tmp16_);
		plank_color_set_sat (&urgent_indicator_color, 1.0);
		_tmp17_ = self->priv->_theme;
		_tmp18_ = position_manager;
		_tmp19_ = plank_position_manager_get_IndicatorSize (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = urgent_indicator_color;
		_tmp22_ = self->priv->item_buffer;
		_tmp23_ = plank_dock_theme_create_indicator (_tmp17_, _tmp20_, &_tmp21_, _tmp22_);
		_g_object_unref0 (self->priv->urgent_indicator_buffer);
		self->priv->urgent_indicator_buffer = _tmp23_;
	}
	if ((item_state & PLANK_ITEM_STATE_URGENT) != 0) {
		PlankSurface* _tmp25_;
		_tmp25_ = self->priv->urgent_indicator_buffer;
		_tmp24_ = _tmp25_;
	} else {
		PlankSurface* _tmp26_;
		_tmp26_ = self->priv->indicator_buffer;
		_tmp24_ = _tmp26_;
	}
	indicator_surface = _tmp24_;
	x = 0.0;
	y = 0.0;
	_tmp27_ = position_manager;
	_tmp28_ = plank_position_manager_get_Position (_tmp27_);
	_tmp29_ = _tmp28_;
	switch (_tmp29_) {
		default:
		case GTK_POS_BOTTOM:
		{
			GdkRectangle _tmp30_;
			GdkRectangle _tmp31_;
			PlankSurface* _tmp32_;
			gint _tmp33_;
			gint _tmp34_;
			PlankSurface* _tmp35_;
			gint _tmp36_;
			gint _tmp37_;
			PlankSurface* _tmp38_;
			gint _tmp39_;
			gint _tmp40_;
			PlankDockTheme* _tmp41_;
			PlankSurface* _tmp42_;
			gint _tmp43_;
			gint _tmp44_;
			_tmp30_ = *item_rect;
			_tmp31_ = *item_rect;
			_tmp32_ = indicator_surface;
			_tmp33_ = plank_surface_get_Width (_tmp32_);
			_tmp34_ = _tmp33_;
			x = (_tmp30_.x + (_tmp31_.width / 2.0)) - (_tmp34_ / 2.0);
			_tmp35_ = self->priv->item_buffer;
			_tmp36_ = plank_surface_get_Height (_tmp35_);
			_tmp37_ = _tmp36_;
			_tmp38_ = indicator_surface;
			_tmp39_ = plank_surface_get_Height (_tmp38_);
			_tmp40_ = _tmp39_;
			_tmp41_ = self->priv->_theme;
			_tmp42_ = indicator_surface;
			_tmp43_ = plank_surface_get_Height (_tmp42_);
			_tmp44_ = _tmp43_;
			y = ((_tmp37_ - (_tmp40_ / 2.0)) - (2.0 * plank_theme_get_bottom_offset ((PlankTheme*) _tmp41_))) - (_tmp44_ / 24.0);
			break;
		}
		case GTK_POS_TOP:
		{
			GdkRectangle _tmp45_;
			GdkRectangle _tmp46_;
			PlankSurface* _tmp47_;
			gint _tmp48_;
			gint _tmp49_;
			PlankSurface* _tmp50_;
			gint _tmp51_;
			gint _tmp52_;
			PlankDockTheme* _tmp53_;
			PlankSurface* _tmp54_;
			gint _tmp55_;
			gint _tmp56_;
			_tmp45_ = *item_rect;
			_tmp46_ = *item_rect;
			_tmp47_ = indicator_surface;
			_tmp48_ = plank_surface_get_Width (_tmp47_);
			_tmp49_ = _tmp48_;
			x = (_tmp45_.x + (_tmp46_.width / 2.0)) - (_tmp49_ / 2.0);
			_tmp50_ = indicator_surface;
			_tmp51_ = plank_surface_get_Height (_tmp50_);
			_tmp52_ = _tmp51_;
			_tmp53_ = self->priv->_theme;
			_tmp54_ = indicator_surface;
			_tmp55_ = plank_surface_get_Height (_tmp54_);
			_tmp56_ = _tmp55_;
			y = (((-_tmp52_) / 2.0) + (2.0 * plank_theme_get_bottom_offset ((PlankTheme*) _tmp53_))) + (_tmp56_ / 24.0);
			break;
		}
		case GTK_POS_LEFT:
		{
			PlankSurface* _tmp57_;
			gint _tmp58_;
			gint _tmp59_;
			PlankDockTheme* _tmp60_;
			PlankSurface* _tmp61_;
			gint _tmp62_;
			gint _tmp63_;
			GdkRectangle _tmp64_;
			GdkRectangle _tmp65_;
			PlankSurface* _tmp66_;
			gint _tmp67_;
			gint _tmp68_;
			_tmp57_ = indicator_surface;
			_tmp58_ = plank_surface_get_Width (_tmp57_);
			_tmp59_ = _tmp58_;
			_tmp60_ = self->priv->_theme;
			_tmp61_ = indicator_surface;
			_tmp62_ = plank_surface_get_Width (_tmp61_);
			_tmp63_ = _tmp62_;
			x = (((-_tmp59_) / 2.0) + (2.0 * plank_theme_get_bottom_offset ((PlankTheme*) _tmp60_))) + (_tmp63_ / 24.0);
			_tmp64_ = *item_rect;
			_tmp65_ = *item_rect;
			_tmp66_ = indicator_surface;
			_tmp67_ = plank_surface_get_Height (_tmp66_);
			_tmp68_ = _tmp67_;
			y = (_tmp64_.y + (_tmp65_.height / 2.0)) - (_tmp68_ / 2.0);
			break;
		}
		case GTK_POS_RIGHT:
		{
			PlankSurface* _tmp69_;
			gint _tmp70_;
			gint _tmp71_;
			PlankSurface* _tmp72_;
			gint _tmp73_;
			gint _tmp74_;
			PlankDockTheme* _tmp75_;
			PlankSurface* _tmp76_;
			gint _tmp77_;
			gint _tmp78_;
			GdkRectangle _tmp79_;
			GdkRectangle _tmp80_;
			PlankSurface* _tmp81_;
			gint _tmp82_;
			gint _tmp83_;
			_tmp69_ = self->priv->item_buffer;
			_tmp70_ = plank_surface_get_Width (_tmp69_);
			_tmp71_ = _tmp70_;
			_tmp72_ = indicator_surface;
			_tmp73_ = plank_surface_get_Width (_tmp72_);
			_tmp74_ = _tmp73_;
			_tmp75_ = self->priv->_theme;
			_tmp76_ = indicator_surface;
			_tmp77_ = plank_surface_get_Width (_tmp76_);
			_tmp78_ = _tmp77_;
			x = ((_tmp71_ - (_tmp74_ / 2.0)) - (2.0 * plank_theme_get_bottom_offset ((PlankTheme*) _tmp75_))) - (_tmp78_ / 24.0);
			_tmp79_ = *item_rect;
			_tmp80_ = *item_rect;
			_tmp81_ = indicator_surface;
			_tmp82_ = plank_surface_get_Height (_tmp81_);
			_tmp83_ = _tmp82_;
			y = (_tmp79_.y + (_tmp80_.height / 2.0)) - (_tmp83_ / 2.0);
			break;
		}
	}
	if (indicator == PLANK_INDICATOR_STATE_SINGLE) {
		PlankSurface* _tmp84_;
		cairo_surface_t* _tmp85_;
		cairo_surface_t* _tmp86_;
		_tmp84_ = indicator_surface;
		_tmp85_ = plank_surface_get_Internal (_tmp84_);
		_tmp86_ = _tmp85_;
		cairo_set_source_surface (cr, _tmp86_, x, y);
		cairo_paint (cr);
	} else {
		gdouble x_offset = 0.0;
		gdouble y_offset = 0.0;
		PlankPositionManager* _tmp87_;
		PlankSurface* _tmp94_;
		cairo_surface_t* _tmp95_;
		cairo_surface_t* _tmp96_;
		PlankSurface* _tmp97_;
		cairo_surface_t* _tmp98_;
		cairo_surface_t* _tmp99_;
		x_offset = 0.0;
		y_offset = 0.0;
		_tmp87_ = position_manager;
		if (plank_position_manager_is_horizontal_dock (_tmp87_)) {
			PlankPositionManager* _tmp88_;
			gint _tmp89_;
			gint _tmp90_;
			_tmp88_ = position_manager;
			_tmp89_ = plank_position_manager_get_IconSize (_tmp88_);
			_tmp90_ = _tmp89_;
			x_offset = _tmp90_ / 16.0;
		} else {
			PlankPositionManager* _tmp91_;
			gint _tmp92_;
			gint _tmp93_;
			_tmp91_ = position_manager;
			_tmp92_ = plank_position_manager_get_IconSize (_tmp91_);
			_tmp93_ = _tmp92_;
			y_offset = _tmp93_ / 16.0;
		}
		_tmp94_ = indicator_surface;
		_tmp95_ = plank_surface_get_Internal (_tmp94_);
		_tmp96_ = _tmp95_;
		cairo_set_source_surface (cr, _tmp96_, x - x_offset, y - y_offset);
		cairo_paint (cr);
		_tmp97_ = indicator_surface;
		_tmp98_ = plank_surface_get_Internal (_tmp97_);
		_tmp99_ = _tmp98_;
		cairo_set_source_surface (cr, _tmp99_, x + x_offset, y + y_offset);
		cairo_paint (cr);
	}
}

static void
plank_dock_renderer_draw_urgent_glow (PlankDockRenderer* self,
                                      PlankDockItem* item,
                                      cairo_t* cr,
                                      gint64 frame_time)
{
	PlankItemState _tmp0_;
	PlankItemState _tmp1_;
	gint64 diff = 0LL;
	gint64 _tmp2_;
	gint64 _tmp3_;
	PlankDockTheme* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	PlankPositionManager* position_manager = NULL;
	PlankDockController* _tmp7_;
	PlankPositionManager* _tmp8_;
	PlankPositionManager* _tmp9_;
	gint x_offset = 0;
	gint y_offset = 0;
	PlankSurface* _tmp10_;
	PlankPositionManager* _tmp22_;
	gint _tmp23_ = 0;
	gint _tmp24_ = 0;
	PlankSurface* _tmp25_;
	cairo_surface_t* _tmp26_;
	cairo_surface_t* _tmp27_;
	gdouble opacity = 0.0;
	PlankDockTheme* _tmp28_;
	gint _tmp29_;
	gint _tmp30_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = plank_dock_item_get_State (item);
	_tmp1_ = _tmp0_;
	if ((_tmp1_ & PLANK_ITEM_STATE_URGENT) == 0) {
		return;
	}
	_tmp2_ = plank_dock_element_get_LastUrgent ((PlankDockElement*) item);
	_tmp3_ = _tmp2_;
	diff = MAX (0LL, frame_time - _tmp3_);
	_tmp4_ = self->priv->_theme;
	_tmp5_ = plank_dock_theme_get_GlowTime (_tmp4_);
	_tmp6_ = _tmp5_;
	if (diff >= ((gint64) (_tmp6_ * 1000))) {
		return;
	}
	_tmp7_ = self->priv->_controller;
	_tmp8_ = plank_dock_controller_get_position_manager (_tmp7_);
	_tmp9_ = _tmp8_;
	position_manager = _tmp9_;
	x_offset = 0;
	y_offset = 0;
	_tmp10_ = self->priv->urgent_glow_buffer;
	if (_tmp10_ == NULL) {
		PlankColor urgent_color = {0};
		PlankColor _tmp11_ = {0};
		PlankDockTheme* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		PlankDockTheme* _tmp15_;
		PlankPositionManager* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		PlankColor _tmp19_;
		PlankSurface* _tmp20_;
		PlankSurface* _tmp21_;
		plank_dock_renderer_get_styled_color (self, &_tmp11_);
		urgent_color = _tmp11_;
		_tmp12_ = self->priv->_theme;
		_tmp13_ = plank_dock_theme_get_UrgentHueShift (_tmp12_);
		_tmp14_ = _tmp13_;
		plank_color_add_hue (&urgent_color, (gdouble) _tmp14_);
		plank_color_set_sat (&urgent_color, 1.0);
		_tmp15_ = self->priv->_theme;
		_tmp16_ = position_manager;
		_tmp17_ = plank_position_manager_get_GlowSize (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = urgent_color;
		_tmp20_ = self->priv->main_buffer;
		_tmp21_ = plank_dock_theme_create_urgent_glow (_tmp15_, _tmp18_, &_tmp19_, _tmp20_);
		_g_object_unref0 (self->priv->urgent_glow_buffer);
		self->priv->urgent_glow_buffer = _tmp21_;
	}
	_tmp22_ = position_manager;
	plank_position_manager_get_urgent_glow_position (_tmp22_, item, &_tmp23_, &_tmp24_);
	x_offset = _tmp23_;
	y_offset = _tmp24_;
	_tmp25_ = self->priv->urgent_glow_buffer;
	_tmp26_ = plank_surface_get_Internal (_tmp25_);
	_tmp27_ = _tmp26_;
	cairo_set_source_surface (cr, _tmp27_, (gdouble) x_offset, (gdouble) y_offset);
	_tmp28_ = self->priv->_theme;
	_tmp29_ = plank_dock_theme_get_GlowPulseTime (_tmp28_);
	_tmp30_ = _tmp29_;
	opacity = 0.2 + ((0.75 * (sin (((diff / ((gdouble) (_tmp30_ * 1000))) * 2) * G_PI) + 1)) / 2);
	cairo_paint_with_alpha (cr, opacity);
}

static void
plank_dock_renderer_get_styled_color (PlankDockRenderer* self,
                                      PlankColor* result)
{
	GtkStyleContext* context = NULL;
	PlankDockTheme* _tmp0_;
	GtkStyleContext* _tmp1_;
	PlankColor color = {0};
	GdkRGBA _tmp2_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_theme;
	_tmp1_ = plank_theme_get_style_context ((PlankTheme*) _tmp0_);
	context = _tmp1_;
	gtk_style_context_get_background_color (context, gtk_style_context_get_state (context), &_tmp2_);
	color = (PlankColor) _tmp2_;
	plank_color_set_min_val (&color, 90 / ((gdouble) G_MAXUINT16));
	*result = color;
	return;
}

static void
plank_dock_renderer_hidden_changed (PlankDockRenderer* self)
{
	gint64 now = 0LL;
	gint64 _tmp0_;
	gint64 _tmp1_;
	gint64 diff = 0LL;
	gint _tmp2_ = 0;
	PlankDockTheme* _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	gint time = 0;
	PlankDockController* _tmp18_;
	PlankDockWindow* _tmp19_;
	PlankDockWindow* _tmp20_;
	g_return_if_fail (self != NULL);
	plank_renderer_force_frame_time_update ((PlankRenderer*) self);
	_tmp0_ = plank_renderer_get_frame_time ((PlankRenderer*) self);
	_tmp1_ = _tmp0_;
	now = _tmp1_;
	diff = now - self->priv->last_hide;
	_tmp3_ = self->priv->_theme;
	_tmp4_ = plank_dock_theme_get_FadeOpacity (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == 1.0) {
		PlankDockTheme* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		_tmp6_ = self->priv->_theme;
		_tmp7_ = plank_dock_theme_get_HideTime (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp2_ = _tmp8_;
	} else {
		PlankDockTheme* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		_tmp9_ = self->priv->_theme;
		_tmp10_ = plank_dock_theme_get_FadeTime (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp2_ = _tmp11_;
	}
	time = _tmp2_ * 1000;
	if (diff < ((gint64) time)) {
		self->priv->last_hide = now + (diff - time);
	} else {
		self->priv->last_hide = now;
	}
	if (!self->priv->screen_is_composited) {
		PlankDockController* _tmp12_;
		PlankPositionManager* _tmp13_;
		PlankPositionManager* _tmp14_;
		PlankDockController* _tmp15_;
		PlankDockWindow* _tmp16_;
		PlankDockWindow* _tmp17_;
		_tmp12_ = self->priv->_controller;
		_tmp13_ = plank_dock_controller_get_position_manager (_tmp12_);
		_tmp14_ = _tmp13_;
		plank_position_manager_update_dock_position (_tmp14_);
		_tmp15_ = self->priv->_controller;
		_tmp16_ = plank_dock_controller_get_window (_tmp15_);
		_tmp17_ = _tmp16_;
		plank_dock_window_update_size_and_position (_tmp17_);
		return;
	}
	_tmp18_ = self->priv->_controller;
	_tmp19_ = plank_dock_controller_get_window (_tmp18_);
	_tmp20_ = _tmp19_;
	plank_dock_window_update_icon_regions (_tmp20_);
	plank_renderer_animated_draw ((PlankRenderer*) self);
}

static void
plank_dock_renderer_hovered_changed (PlankDockRenderer* self)
{
	gint64 now = 0LL;
	gint64 _tmp0_;
	gint64 _tmp1_;
	gint64 diff = 0LL;
	guint time = 0U;
	g_return_if_fail (self != NULL);
	plank_renderer_force_frame_time_update ((PlankRenderer*) self);
	_tmp0_ = plank_renderer_get_frame_time ((PlankRenderer*) self);
	_tmp1_ = _tmp0_;
	now = _tmp1_;
	diff = now - self->priv->last_hovered_changed;
	time = PLANK_DOCK_ZOOM_DURATION * 1000;
	if (diff < ((gint64) time)) {
		self->priv->last_hovered_changed = now + (diff - time);
	} else {
		self->priv->last_hovered_changed = now;
	}
	plank_renderer_animated_draw ((PlankRenderer*) self);
}

static gboolean
_gdk_point_equal (const GdkPoint * s1,
                  const GdkPoint * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	if (s1->x != s2->x) {
		return FALSE;
	}
	if (s1->y != s2->y) {
		return FALSE;
	}
	return TRUE;
}

void
plank_dock_renderer_update_local_cursor (PlankDockRenderer* self,
                                         gint x,
                                         gint y)
{
	GdkPoint new_cursor = {0};
	GdkPoint _tmp0_ = {0};
	GdkPoint _tmp1_;
	GdkPoint _tmp2_;
	GdkPoint _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_.x = x;
	_tmp0_.y = y;
	new_cursor = _tmp0_;
	_tmp1_ = self->priv->_local_cursor;
	_tmp2_ = new_cursor;
	if (_gdk_point_equal (&_tmp1_, &_tmp2_) == TRUE) {
		return;
	}
	_tmp3_ = new_cursor;
	plank_dock_renderer_set_local_cursor (self, &_tmp3_);
	if (self->priv->screen_is_composited) {
		self->priv->zoom_changed = TRUE;
		plank_renderer_animated_draw ((PlankRenderer*) self);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
plank_dock_renderer_animate_items (PlankDockRenderer* self,
                                   GeeList* elements)
{
	GeeHashSet* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (elements != NULL);
	if (!self->priv->screen_is_composited) {
		return;
	}
	{
		GeeList* _element_list = NULL;
		gint _element_size = 0;
		GeeList* _tmp0_;
		gint _tmp1_;
		gint _tmp2_;
		gint _element_index = 0;
		_element_list = elements;
		_tmp0_ = _element_list;
		_tmp1_ = gee_collection_get_size ((GeeCollection*) _tmp0_);
		_tmp2_ = _tmp1_;
		_element_size = _tmp2_;
		_element_index = -1;
		while (TRUE) {
			gint _tmp3_;
			gint _tmp4_;
			PlankDockElement* element = NULL;
			GeeList* _tmp5_;
			gpointer _tmp6_;
			PlankDockItem* item = NULL;
			PlankDockElement* _tmp7_;
			PlankDockItem* _tmp8_;
			PlankDockItem* _tmp9_;
			_element_index = _element_index + 1;
			_tmp3_ = _element_index;
			_tmp4_ = _element_size;
			if (!(_tmp3_ < _tmp4_)) {
				break;
			}
			_tmp5_ = _element_list;
			_tmp6_ = gee_list_get (_tmp5_, _element_index);
			element = (PlankDockElement*) _tmp6_;
			_tmp7_ = element;
			_tmp8_ = _g_object_ref0 (PLANK_IS_DOCK_ITEM (_tmp7_) ? ((PlankDockItem*) _tmp7_) : NULL);
			item = _tmp8_;
			_tmp9_ = item;
			if (_tmp9_ != NULL) {
				GeeHashSet* _tmp10_;
				PlankDockItem* _tmp11_;
				_tmp10_ = self->priv->transient_items;
				_tmp11_ = item;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, _tmp11_);
			}
			_g_object_unref0 (item);
			_g_object_unref0 (element);
		}
	}
	_tmp12_ = self->priv->transient_items;
	_tmp13_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp12_);
	_tmp14_ = _tmp13_;
	if (_tmp14_ > 0) {
		plank_renderer_animated_draw ((PlankRenderer*) self);
	}
}

/**
 * {@inheritDoc}
 */
static gboolean
plank_dock_renderer_real_animation_needed (PlankRenderer* base,
                                           gint64 frame_time)
{
	PlankDockRenderer * self;
	PlankDockTheme* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	GeeHashSet* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gboolean result;
	self = (PlankDockRenderer*) base;
	if (self->priv->zoom_changed) {
		self->priv->zoom_changed = FALSE;
		result = TRUE;
		return result;
	}
	if ((frame_time - self->priv->last_hovered_changed) <= ((gint64) (PLANK_DOCK_ZOOM_DURATION * 1000))) {
		result = TRUE;
		return result;
	}
	_tmp0_ = self->priv->_theme;
	_tmp1_ = plank_dock_theme_get_FadeOpacity (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 1.0) {
		PlankDockTheme* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		_tmp3_ = self->priv->_theme;
		_tmp4_ = plank_dock_theme_get_HideTime (_tmp3_);
		_tmp5_ = _tmp4_;
		if ((frame_time - self->priv->last_hide) <= ((gint64) (_tmp5_ * 1000))) {
			result = TRUE;
			return result;
		}
	} else {
		PlankDockTheme* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		_tmp6_ = self->priv->_theme;
		_tmp7_ = plank_dock_theme_get_FadeTime (_tmp6_);
		_tmp8_ = _tmp7_;
		if ((frame_time - self->priv->last_hide) <= ((gint64) (_tmp8_ * 1000))) {
			result = TRUE;
			return result;
		}
	}
	_tmp9_ = self->priv->transient_items;
	_tmp10_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp9_);
	_tmp11_ = _tmp10_;
	if (_tmp11_ > 0) {
		result = TRUE;
		return result;
	}
	{
		GeeArrayList* _item_list = NULL;
		GeeArrayList* _tmp12_;
		gint _item_size = 0;
		GeeArrayList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _item_index = 0;
		_tmp12_ = self->priv->current_items;
		_item_list = _tmp12_;
		_tmp13_ = _item_list;
		_tmp14_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		_item_size = _tmp15_;
		_item_index = -1;
		while (TRUE) {
			gint _tmp16_;
			gint _tmp17_;
			PlankDockItem* item = NULL;
			GeeArrayList* _tmp18_;
			gpointer _tmp19_;
			PlankDockItem* _tmp20_;
			PlankDockItem* _tmp21_;
			_item_index = _item_index + 1;
			_tmp16_ = _item_index;
			_tmp17_ = _item_size;
			if (!(_tmp16_ < _tmp17_)) {
				break;
			}
			_tmp18_ = _item_list;
			_tmp19_ = gee_abstract_list_get ((GeeAbstractList*) _tmp18_, _item_index);
			_tmp20_ = _g_object_ref0 ((PlankDockItem*) _tmp19_);
			item = _tmp20_;
			_tmp21_ = item;
			if (plank_dock_renderer_item_animation_needed (self, _tmp21_, frame_time)) {
				result = TRUE;
				_g_object_unref0 (item);
				return result;
			}
			_g_object_unref0 (item);
		}
	}
	result = FALSE;
	return result;
}

static inline gboolean
plank_dock_renderer_item_animation_needed (PlankDockRenderer* self,
                                           PlankDockItem* item,
                                           gint64 render_time)
{
	gboolean _tmp0_ = FALSE;
	PlankAnimationType _tmp1_;
	PlankAnimationType _tmp2_;
	gboolean _tmp14_ = FALSE;
	PlankAnimationType _tmp15_;
	PlankAnimationType _tmp16_;
	gboolean _tmp19_ = FALSE;
	PlankAnimationType _tmp20_;
	PlankAnimationType _tmp21_;
	gint64 _tmp24_;
	gint64 _tmp25_;
	PlankDockTheme* _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	gboolean _tmp29_ = FALSE;
	gint64 _tmp40_;
	gint64 _tmp41_;
	PlankDockTheme* _tmp42_;
	gint _tmp43_;
	gint _tmp44_;
	gint64 _tmp45_;
	gint64 _tmp46_;
	PlankDockTheme* _tmp47_;
	gint _tmp48_;
	gint _tmp49_;
	gint64 _tmp50_;
	gint64 _tmp51_;
	PlankDockTheme* _tmp52_;
	gint _tmp53_;
	gint _tmp54_;
	gint64 _tmp55_;
	gint64 _tmp56_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (item != NULL, FALSE);
	_tmp1_ = plank_dock_element_get_ClickedAnimation ((PlankDockElement*) item);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != PLANK_ANIMATION_TYPE_NONE) {
		gint _tmp3_ = 0;
		PlankAnimationType _tmp4_;
		PlankAnimationType _tmp5_;
		gint64 _tmp12_;
		gint64 _tmp13_;
		_tmp4_ = plank_dock_element_get_ClickedAnimation ((PlankDockElement*) item);
		_tmp5_ = _tmp4_;
		if (_tmp5_ == PLANK_ANIMATION_TYPE_BOUNCE) {
			PlankDockTheme* _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			_tmp6_ = self->priv->_theme;
			_tmp7_ = plank_dock_theme_get_LaunchBounceTime (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp3_ = _tmp8_;
		} else {
			PlankDockTheme* _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			_tmp9_ = self->priv->_theme;
			_tmp10_ = plank_dock_theme_get_ClickTime (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp3_ = _tmp11_;
		}
		_tmp12_ = plank_dock_element_get_LastClicked ((PlankDockElement*) item);
		_tmp13_ = _tmp12_;
		_tmp0_ = (render_time - _tmp13_) <= ((gint64) (_tmp3_ * 1000));
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	_tmp15_ = plank_dock_element_get_HoveredAnimation ((PlankDockElement*) item);
	_tmp16_ = _tmp15_;
	if (_tmp16_ != PLANK_ANIMATION_TYPE_NONE) {
		gint64 _tmp17_;
		gint64 _tmp18_;
		_tmp17_ = plank_dock_element_get_LastHovered ((PlankDockElement*) item);
		_tmp18_ = _tmp17_;
		_tmp14_ = (render_time - _tmp18_) <= ((gint64) (PLANK_ITEM_HOVER_DURATION * 1000));
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		result = TRUE;
		return result;
	}
	_tmp20_ = plank_dock_element_get_ScrolledAnimation ((PlankDockElement*) item);
	_tmp21_ = _tmp20_;
	if (_tmp21_ != PLANK_ANIMATION_TYPE_NONE) {
		gint64 _tmp22_;
		gint64 _tmp23_;
		_tmp22_ = plank_dock_element_get_LastScrolled ((PlankDockElement*) item);
		_tmp23_ = _tmp22_;
		_tmp19_ = (render_time - _tmp23_) <= ((gint64) (PLANK_ITEM_SCROLL_DURATION * 1000));
	} else {
		_tmp19_ = FALSE;
	}
	if (_tmp19_) {
		result = TRUE;
		return result;
	}
	_tmp24_ = plank_dock_element_get_LastActive ((PlankDockElement*) item);
	_tmp25_ = _tmp24_;
	_tmp26_ = self->priv->_theme;
	_tmp27_ = plank_dock_theme_get_ActiveTime (_tmp26_);
	_tmp28_ = _tmp27_;
	if ((render_time - _tmp25_) <= ((gint64) (_tmp28_ * 1000))) {
		result = TRUE;
		return result;
	}
	if (self->priv->show_notifications) {
		gint _tmp30_ = 0;
		gdouble _tmp31_;
		gint64 _tmp38_;
		gint64 _tmp39_;
		_tmp31_ = self->priv->_hide_progress;
		if (_tmp31_ == 1.0) {
			PlankDockTheme* _tmp32_;
			gint _tmp33_;
			gint _tmp34_;
			_tmp32_ = self->priv->_theme;
			_tmp33_ = plank_dock_theme_get_GlowTime (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp30_ = _tmp34_;
		} else {
			PlankDockTheme* _tmp35_;
			gint _tmp36_;
			gint _tmp37_;
			_tmp35_ = self->priv->_theme;
			_tmp36_ = plank_dock_theme_get_UrgentBounceTime (_tmp35_);
			_tmp37_ = _tmp36_;
			_tmp30_ = _tmp37_;
		}
		_tmp38_ = plank_dock_element_get_LastUrgent ((PlankDockElement*) item);
		_tmp39_ = _tmp38_;
		_tmp29_ = (render_time - _tmp39_) <= ((gint64) (_tmp30_ * 1000));
	} else {
		_tmp29_ = FALSE;
	}
	if (_tmp29_) {
		result = TRUE;
		return result;
	}
	_tmp40_ = plank_dock_element_get_LastMove ((PlankDockElement*) item);
	_tmp41_ = _tmp40_;
	_tmp42_ = self->priv->_theme;
	_tmp43_ = plank_dock_theme_get_ItemMoveTime (_tmp42_);
	_tmp44_ = _tmp43_;
	if ((render_time - _tmp41_) <= ((gint64) (_tmp44_ * 1000))) {
		result = TRUE;
		return result;
	}
	_tmp45_ = plank_dock_element_get_AddTime ((PlankDockElement*) item);
	_tmp46_ = _tmp45_;
	_tmp47_ = self->priv->_theme;
	_tmp48_ = plank_dock_theme_get_ItemMoveTime (_tmp47_);
	_tmp49_ = _tmp48_;
	if ((render_time - _tmp46_) <= ((gint64) (_tmp49_ * 1000))) {
		result = TRUE;
		return result;
	}
	_tmp50_ = plank_dock_element_get_RemoveTime ((PlankDockElement*) item);
	_tmp51_ = _tmp50_;
	_tmp52_ = self->priv->_theme;
	_tmp53_ = plank_dock_theme_get_ItemMoveTime (_tmp52_);
	_tmp54_ = _tmp53_;
	if ((render_time - _tmp51_) <= ((gint64) (_tmp54_ * 1000))) {
		result = TRUE;
		return result;
	}
	_tmp55_ = plank_dock_element_get_LastValid ((PlankDockElement*) item);
	_tmp56_ = _tmp55_;
	if ((render_time - _tmp56_) <= ((gint64) (PLANK_ITEM_INVALID_DURATION * 1000))) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gint
plank_dock_renderer_compare_dock_item_position (PlankDockItem* i1,
                                                PlankDockItem* i2)
{
	gint p_i1 = 0;
	gint _tmp0_;
	gint _tmp1_;
	gint p_i2 = 0;
	gint _tmp2_;
	gint _tmp3_;
	gint64 _tmp4_;
	gint64 _tmp5_;
	gint64 _tmp6_;
	gint64 _tmp7_;
	gint result;
	g_return_val_if_fail (i1 != NULL, 0);
	g_return_val_if_fail (i2 != NULL, 0);
	_tmp0_ = plank_dock_item_get_Position (i1);
	_tmp1_ = _tmp0_;
	p_i1 = _tmp1_;
	_tmp2_ = plank_dock_item_get_Position (i2);
	_tmp3_ = _tmp2_;
	p_i2 = _tmp3_;
	if (p_i1 > p_i2) {
		result = 1;
		return result;
	}
	if (p_i1 < p_i2) {
		result = -1;
		return result;
	}
	_tmp4_ = plank_dock_element_get_RemoveTime ((PlankDockElement*) i1);
	_tmp5_ = _tmp4_;
	_tmp6_ = plank_dock_element_get_RemoveTime ((PlankDockElement*) i2);
	_tmp7_ = _tmp6_;
	if (_tmp5_ > _tmp7_) {
		result = -1;
		return result;
	}
	result = 1;
	return result;
}

static gdouble
plank_dock_renderer_easing_bounce (gdouble t,
                                   gdouble d,
                                   gdouble n)
{
	gdouble p = 0.0;
	gdouble result;
	_vala_return_val_if_fail (((t >= 0.0) && (d > 0.0)) && (n >= 1.0), "t >= 0.0 && d > 0.0 && n >= 1.0", 0.0);
	_vala_return_val_if_fail (t <= d, "t <= d", 0.0);
	p = t / d;
	result = fabs (sin ((n * G_PI) * p) * MIN (1.0, ((1.0 - p) * (2.0 * n)) / ((2.0 * n) - 1.0)));
	return result;
}

static const gchar*
plank_dock_renderer_cairo_surface_type_to_string (cairo_surface_type_t type)
{
	const gchar* _result_ = NULL;
	const gchar* _tmp0_;
	const gchar* result;
	switch (type) {
		case CAIRO_SURFACE_TYPE_IMAGE:
		{
			_result_ = "IMAGE";
			break;
		}
		case CAIRO_SURFACE_TYPE_PDF:
		{
			_result_ = "PDF";
			break;
		}
		case CAIRO_SURFACE_TYPE_PS:
		{
			_result_ = "PS";
			break;
		}
		case CAIRO_SURFACE_TYPE_XLIB:
		{
			_result_ = "XLIB";
			break;
		}
		case CAIRO_SURFACE_TYPE_XCB:
		{
			_result_ = "XCB";
			break;
		}
		case CAIRO_SURFACE_TYPE_GLITZ:
		{
			_result_ = "GLITZ";
			break;
		}
		case CAIRO_SURFACE_TYPE_QUARTZ:
		{
			_result_ = "QUARTZ";
			break;
		}
		case CAIRO_SURFACE_TYPE_WIN32:
		{
			_result_ = "WIN32";
			break;
		}
		case CAIRO_SURFACE_TYPE_BEOS:
		{
			_result_ = "BEOS";
			break;
		}
		case CAIRO_SURFACE_TYPE_DIRECTFB:
		{
			_result_ = "DIRECTFB";
			break;
		}
		case CAIRO_SURFACE_TYPE_SVG:
		{
			_result_ = "SVG";
			break;
		}
		case CAIRO_SURFACE_TYPE_OS2:
		{
			_result_ = "OS2";
			break;
		}
		case CAIRO_SURFACE_TYPE_WIN32_PRINTING:
		{
			_result_ = "WIN32_PRINTING";
			break;
		}
		case CAIRO_SURFACE_TYPE_QUARTZ_IMAGE:
		{
			_result_ = "QUARTZ_IMAGE";
			break;
		}
		case CAIRO_SURFACE_TYPE_SCRIPT:
		{
			_result_ = "SCRIPT";
			break;
		}
		case CAIRO_SURFACE_TYPE_QT:
		{
			_result_ = "QT";
			break;
		}
		case CAIRO_SURFACE_TYPE_RECORDING:
		{
			_result_ = "RECORDING";
			break;
		}
		case CAIRO_SURFACE_TYPE_VG:
		{
			_result_ = "VG";
			break;
		}
		case CAIRO_SURFACE_TYPE_GL:
		{
			_result_ = "GL";
			break;
		}
		case CAIRO_SURFACE_TYPE_DRM:
		{
			_result_ = "DRM";
			break;
		}
		case CAIRO_SURFACE_TYPE_TEE:
		{
			_result_ = "TEE";
			break;
		}
		case CAIRO_SURFACE_TYPE_XML:
		{
			_result_ = "XML";
			break;
		}
		case CAIRO_SURFACE_TYPE_SKIA:
		{
			_result_ = "SKIA";
			break;
		}
		case CAIRO_SURFACE_TYPE_SUBSURFACE:
		{
			_result_ = "SUBSURFACE";
			break;
		}
		default:
		{
			_result_ = "???";
			break;
		}
	}
	_tmp0_ = _result_;
	result = _tmp0_;
	return result;
}

static PlankDockController*
plank_dock_renderer_get_controller (PlankDockRenderer* self)
{
	PlankDockController* result;
	PlankDockController* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_controller;
	result = _tmp0_;
	return result;
}

static void
plank_dock_renderer_set_controller (PlankDockRenderer* self,
                                    PlankDockController* value)
{
	PlankDockController* old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_renderer_get_controller (self);
	if (old_value != value) {
		PlankDockController* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_controller);
		self->priv->_controller = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_renderer_properties[PLANK_DOCK_RENDERER_CONTROLLER_PROPERTY]);
	}
}

PlankDockTheme*
plank_dock_renderer_get_theme (PlankDockRenderer* self)
{
	PlankDockTheme* result;
	PlankDockTheme* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_theme;
	result = _tmp0_;
	return result;
}

static void
plank_dock_renderer_set_theme (PlankDockRenderer* self,
                               PlankDockTheme* value)
{
	PlankDockTheme* old_value;
	g_return_if_fail (self != NULL);
	old_value = plank_dock_renderer_get_theme (self);
	if (old_value != value) {
		PlankDockTheme* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_theme);
		self->priv->_theme = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plank_dock_renderer_properties[PLANK_DOCK_RENDERER_THEME_PROPERTY]);
	}
}

gdouble
plank_dock_renderer_get_hide_progress (PlankDockRenderer* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_hide_progress;
	return result;
}

static void
plank_dock_renderer_set_hide_progress (PlankDockRenderer* self,
                                       gdouble value)
{
	g_return_if_fail (self != NULL);
	self->priv->_hide_progress = value;
}

static gdouble
plank_dock_renderer_get_opacity (PlankDockRenderer* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_opacity;
	return result;
}

static void
plank_dock_renderer_set_opacity (PlankDockRenderer* self,
                                 gdouble value)
{
	g_return_if_fail (self != NULL);
	self->priv->_opacity = value;
}

gdouble
plank_dock_renderer_get_zoom_in_progress (PlankDockRenderer* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_zoom_in_progress;
	return result;
}

static void
plank_dock_renderer_set_zoom_in_progress (PlankDockRenderer* self,
                                          gdouble value)
{
	g_return_if_fail (self != NULL);
	self->priv->_zoom_in_progress = value;
}

void
plank_dock_renderer_get_local_cursor (PlankDockRenderer* self,
                                      GdkPoint * result)
{
	GdkPoint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_local_cursor;
	*result = _tmp0_;
	return;
}

static void
plank_dock_renderer_set_local_cursor (PlankDockRenderer* self,
                                      GdkPoint * value)
{
	GdkPoint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = *value;
	self->priv->_local_cursor = _tmp0_;
}

static GObject *
plank_dock_renderer_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PlankDockRenderer * self;
	GeeHashSet* _tmp0_;
	GeeArrayList* _tmp1_;
	PlankDockController* _tmp2_;
	PlankDockPreferences* _tmp3_;
	PlankDockPreferences* _tmp4_;
	parent_class = G_OBJECT_CLASS (plank_dock_renderer_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_TYPE_DOCK_RENDERER, PlankDockRenderer);
	_tmp0_ = gee_hash_set_new (PLANK_TYPE_DOCK_ITEM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->transient_items);
	self->priv->transient_items = _tmp0_;
	_tmp1_ = gee_array_list_new (PLANK_TYPE_DOCK_ITEM, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->current_items);
	self->priv->current_items = _tmp1_;
	_tmp2_ = self->priv->_controller;
	_tmp3_ = plank_dock_controller_get_prefs (_tmp2_);
	_tmp4_ = _tmp3_;
	g_signal_connect_object ((GObject*) _tmp4_, "notify", (GCallback) _plank_dock_renderer_prefs_changed_g_object_notify, self, 0);
	plank_dock_renderer_load_theme (self);
	return obj;
}

static void
plank_dock_renderer_class_init (PlankDockRendererClass * klass,
                                gpointer klass_data)
{
	plank_dock_renderer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PlankDockRenderer_private_offset);
	((PlankRendererClass *) klass)->initialize_frame = (void (*) (PlankRenderer*, gint64)) plank_dock_renderer_real_initialize_frame;
	((PlankRendererClass *) klass)->draw = (void (*) (PlankRenderer*, cairo_t*, gint64)) plank_dock_renderer_real_draw;
	((PlankRendererClass *) klass)->animation_needed = (gboolean (*) (PlankRenderer*, gint64)) plank_dock_renderer_real_animation_needed;
	G_OBJECT_CLASS (klass)->get_property = _vala_plank_dock_renderer_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_plank_dock_renderer_set_property;
	G_OBJECT_CLASS (klass)->constructor = plank_dock_renderer_constructor;
	G_OBJECT_CLASS (klass)->finalize = plank_dock_renderer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_RENDERER_CONTROLLER_PROPERTY, plank_dock_renderer_properties[PLANK_DOCK_RENDERER_CONTROLLER_PROPERTY] = g_param_spec_object ("controller", "controller", "controller", PLANK_TYPE_DOCK_CONTROLLER, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_RENDERER_THEME_PROPERTY, plank_dock_renderer_properties[PLANK_DOCK_RENDERER_THEME_PROPERTY] = g_param_spec_object ("theme", "theme", "theme", PLANK_TYPE_DOCK_THEME, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * The current progress [0.0..1.0] of the hide-animation of the dock.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_RENDERER_HIDE_PROGRESS_PROPERTY, plank_dock_renderer_properties[PLANK_DOCK_RENDERER_HIDE_PROGRESS_PROPERTY] = g_param_spec_double ("hide-progress", "hide-progress", "hide-progress", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
	/**
	 * The current progress [0.0..1.0] of the zoom-in-animation of the dock.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLANK_DOCK_RENDERER_ZOOM_IN_PROGRESS_PROPERTY, plank_dock_renderer_properties[PLANK_DOCK_RENDERER_ZOOM_IN_PROGRESS_PROPERTY] = g_param_spec_double ("zoom-in-progress", "zoom-in-progress", "zoom-in-progress", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
}

static void
plank_dock_renderer_instance_init (PlankDockRenderer * self,
                                   gpointer klass)
{
	self->priv = plank_dock_renderer_get_instance_private (self);
	self->priv->main_buffer = NULL;
	self->priv->fade_buffer = NULL;
	self->priv->item_buffer = NULL;
	self->priv->shadow_buffer = NULL;
	self->priv->background_buffer = NULL;
	self->priv->indicator_buffer = NULL;
	self->priv->urgent_indicator_buffer = NULL;
	self->priv->urgent_glow_buffer = NULL;
	self->priv->last_hide = 0LL;
	self->priv->last_hovered_changed = 0LL;
	self->priv->screen_is_composited = FALSE;
	self->priv->show_notifications = TRUE;
	self->priv->reset_position_manager_timer_id = 0U;
	self->priv->window_scale_factor = 1;
	self->priv->is_first_frame = TRUE;
	self->priv->zoom_changed = FALSE;
	self->priv->gtk_theme_name_changed_handler_id = 0UL;
	self->priv->dynamic_animation_offset = 0.0;
}

static void
plank_dock_renderer_finalize (GObject * obj)
{
	PlankDockRenderer * self;
	PlankDockController* _tmp0_;
	PlankDockPreferences* _tmp1_;
	PlankDockPreferences* _tmp2_;
	guint _tmp3_;
	PlankDockTheme* _tmp4_;
	guint _tmp5_;
	PlankDockController* _tmp6_;
	PlankHideManager* _tmp7_;
	PlankHideManager* _tmp8_;
	guint _tmp9_;
	GQuark _tmp10_;
	PlankDockController* _tmp11_;
	PlankHideManager* _tmp12_;
	PlankHideManager* _tmp13_;
	guint _tmp14_;
	GQuark _tmp15_;
	PlankDockController* _tmp16_;
	PlankDockWindow* _tmp17_;
	PlankDockWindow* _tmp18_;
	guint _tmp19_;
	GQuark _tmp20_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLANK_TYPE_DOCK_RENDERER, PlankDockRenderer);
	_tmp0_ = self->priv->_controller;
	_tmp1_ = plank_dock_controller_get_prefs (_tmp0_);
	_tmp2_ = _tmp1_;
	g_signal_parse_name ("notify", G_TYPE_OBJECT, &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _plank_dock_renderer_prefs_changed_g_object_notify, self);
	_tmp4_ = self->priv->_theme;
	g_signal_parse_name ("notify", G_TYPE_OBJECT, &_tmp5_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _plank_dock_renderer_theme_changed_g_object_notify, self);
	_tmp6_ = self->priv->_controller;
	_tmp7_ = plank_dock_controller_get_hide_manager (_tmp6_);
	_tmp8_ = _tmp7_;
	g_signal_parse_name ("notify::Hidden", G_TYPE_OBJECT, &_tmp9_, &_tmp10_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp8_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp9_, _tmp10_, NULL, (GCallback) _plank_dock_renderer_hidden_changed_g_object_notify, self);
	_tmp11_ = self->priv->_controller;
	_tmp12_ = plank_dock_controller_get_hide_manager (_tmp11_);
	_tmp13_ = _tmp12_;
	g_signal_parse_name ("notify::Hovered", G_TYPE_OBJECT, &_tmp14_, &_tmp15_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp13_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp14_, _tmp15_, NULL, (GCallback) _plank_dock_renderer_hovered_changed_g_object_notify, self);
	_tmp16_ = self->priv->_controller;
	_tmp17_ = plank_dock_controller_get_window (_tmp16_);
	_tmp18_ = _tmp17_;
	g_signal_parse_name ("notify::HoveredItem", G_TYPE_OBJECT, &_tmp19_, &_tmp20_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp18_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp19_, _tmp20_, NULL, (GCallback) _plank_renderer_animated_draw_g_object_notify, (PlankRenderer*) self);
	_g_object_unref0 (self->priv->_controller);
	_g_object_unref0 (self->priv->_theme);
	_g_object_unref0 (self->priv->main_buffer);
	_g_object_unref0 (self->priv->fade_buffer);
	_g_object_unref0 (self->priv->item_buffer);
	_g_object_unref0 (self->priv->shadow_buffer);
	_g_object_unref0 (self->priv->background_buffer);
	_g_object_unref0 (self->priv->indicator_buffer);
	_g_object_unref0 (self->priv->urgent_indicator_buffer);
	_g_object_unref0 (self->priv->urgent_glow_buffer);
	_g_object_unref0 (self->priv->current_items);
	_g_object_unref0 (self->priv->transient_items);
	G_OBJECT_CLASS (plank_dock_renderer_parent_class)->finalize (obj);
}

/**
 * Handles all of the drawing for a dock.
 */
static GType
plank_dock_renderer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PlankDockRendererClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plank_dock_renderer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PlankDockRenderer), 0, (GInstanceInitFunc) plank_dock_renderer_instance_init, NULL };
	GType plank_dock_renderer_type_id;
	plank_dock_renderer_type_id = g_type_register_static (PLANK_TYPE_RENDERER, "PlankDockRenderer", &g_define_type_info, 0);
	PlankDockRenderer_private_offset = g_type_add_instance_private (plank_dock_renderer_type_id, sizeof (PlankDockRendererPrivate));
	return plank_dock_renderer_type_id;
}

GType
plank_dock_renderer_get_type (void)
{
	static volatile gsize plank_dock_renderer_type_id__once = 0;
	if (g_once_init_enter (&plank_dock_renderer_type_id__once)) {
		GType plank_dock_renderer_type_id;
		plank_dock_renderer_type_id = plank_dock_renderer_get_type_once ();
		g_once_init_leave (&plank_dock_renderer_type_id__once, plank_dock_renderer_type_id);
	}
	return plank_dock_renderer_type_id__once;
}

static void
_vala_plank_dock_renderer_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	PlankDockRenderer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PLANK_TYPE_DOCK_RENDERER, PlankDockRenderer);
	switch (property_id) {
		case PLANK_DOCK_RENDERER_CONTROLLER_PROPERTY:
		g_value_set_object (value, plank_dock_renderer_get_controller (self));
		break;
		case PLANK_DOCK_RENDERER_THEME_PROPERTY:
		g_value_set_object (value, plank_dock_renderer_get_theme (self));
		break;
		case PLANK_DOCK_RENDERER_HIDE_PROGRESS_PROPERTY:
		g_value_set_double (value, plank_dock_renderer_get_hide_progress (self));
		break;
		case PLANK_DOCK_RENDERER_ZOOM_IN_PROGRESS_PROPERTY:
		g_value_set_double (value, plank_dock_renderer_get_zoom_in_progress (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_plank_dock_renderer_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	PlankDockRenderer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PLANK_TYPE_DOCK_RENDERER, PlankDockRenderer);
	switch (property_id) {
		case PLANK_DOCK_RENDERER_CONTROLLER_PROPERTY:
		plank_dock_renderer_set_controller (self, g_value_get_object (value));
		break;
		case PLANK_DOCK_RENDERER_THEME_PROPERTY:
		plank_dock_renderer_set_theme (self, g_value_get_object (value));
		break;
		case PLANK_DOCK_RENDERER_HIDE_PROGRESS_PROPERTY:
		plank_dock_renderer_set_hide_progress (self, g_value_get_double (value));
		break;
		case PLANK_DOCK_RENDERER_ZOOM_IN_PROGRESS_PROPERTY:
		plank_dock_renderer_set_zoom_in_progress (self, g_value_get_double (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

