/* ImageManager.c generated by valac 0.56.18, the Vala compiler
 * generated from ImageManager.vala, do not modify */

/*
* Copyright (c) 2018 (https://github.com/phase1geo/Minder)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <glib-object.h>
#include <glib.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <libxml/tree.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <stdio.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_IMAGE_MANAGER (image_manager_get_type ())
#define IMAGE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IMAGE_MANAGER, ImageManager))
#define IMAGE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IMAGE_MANAGER, ImageManagerClass))
#define IS_IMAGE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IMAGE_MANAGER))
#define IS_IMAGE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IMAGE_MANAGER))
#define IMAGE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IMAGE_MANAGER, ImageManagerClass))

typedef struct _ImageManager ImageManager;
typedef struct _ImageManagerClass ImageManagerClass;
typedef struct _ImageManagerPrivate ImageManagerPrivate;

#define IMAGE_MANAGER_TYPE_IMAGE_ITEM (image_manager_image_item_get_type ())
#define IMAGE_MANAGER_IMAGE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), IMAGE_MANAGER_TYPE_IMAGE_ITEM, ImageManagerImageItem))
#define IMAGE_MANAGER_IMAGE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), IMAGE_MANAGER_TYPE_IMAGE_ITEM, ImageManagerImageItemClass))
#define IMAGE_MANAGER_IS_IMAGE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IMAGE_MANAGER_TYPE_IMAGE_ITEM))
#define IMAGE_MANAGER_IS_IMAGE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), IMAGE_MANAGER_TYPE_IMAGE_ITEM))
#define IMAGE_MANAGER_IMAGE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), IMAGE_MANAGER_TYPE_IMAGE_ITEM, ImageManagerImageItemClass))

typedef struct _ImageManagerImageItem ImageManagerImageItem;
typedef struct _ImageManagerImageItemClass ImageManagerImageItemClass;
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _image_manager_image_item_unref0(var) ((var == NULL) ? NULL : (var = (image_manager_image_item_unref (var), NULL)))
typedef struct _ImageManagerImageItemPrivate ImageManagerImageItemPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ImageManagerParamSpecImageItem ImageManagerParamSpecImageItem;
typedef struct _ParamSpecImageManager ParamSpecImageManager;

struct _ImageManager {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ImageManagerPrivate * priv;
};

struct _ImageManagerClass {
	GTypeClass parent_class;
	void (*finalize) (ImageManager *self);
};

struct _ImageManagerPrivate {
	GArray* _images;
	gboolean _available;
	GeeHashMap* _id_map;
};

struct _ImageManagerImageItem {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ImageManagerImageItemPrivate * priv;
};

struct _ImageManagerImageItemClass {
	GTypeClass parent_class;
	void (*finalize) (ImageManagerImageItem *self);
};

struct _ImageManagerImageItemPrivate {
	gint _id;
	gchar* _uri;
	gchar* _ext;
	gboolean _valid;
};

struct _ImageManagerParamSpecImageItem {
	GParamSpec parent_instance;
};

struct _ParamSpecImageManager {
	GParamSpec parent_instance;
};

static gint ImageManager_private_offset;
static gpointer image_manager_parent_class = NULL;
static gint ImageManagerImageItem_private_offset;
static gpointer image_manager_image_item_parent_class = NULL;
VALA_EXTERN GSettings* minder_settings;

VALA_EXTERN gpointer image_manager_ref (gpointer instance);
VALA_EXTERN void image_manager_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_image_manager (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
VALA_EXTERN void value_set_image_manager (GValue* value,
                              gpointer v_object);
VALA_EXTERN void value_take_image_manager (GValue* value,
                               gpointer v_object);
VALA_EXTERN gpointer value_get_image_manager (const GValue* value);
VALA_EXTERN GType image_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ImageManager, image_manager_unref)
static gpointer image_manager_image_item_ref (gpointer instance);
static void image_manager_image_item_unref (gpointer instance);
static GParamSpec* image_manager_param_spec_image_item (const gchar* name,
                                                 const gchar* nick,
                                                 const gchar* blurb,
                                                 GType object_type,
                                                 GParamFlags flags) G_GNUC_UNUSED ;
static void image_manager_value_set_image_item (GValue* value,
                                         gpointer v_object) G_GNUC_UNUSED ;
static void image_manager_value_take_image_item (GValue* value,
                                          gpointer v_object) G_GNUC_UNUSED ;
static gpointer image_manager_value_get_image_item (const GValue* value) G_GNUC_UNUSED ;
static GType image_manager_image_item_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ImageManagerImageItem, image_manager_image_item_unref)
static gchar* image_manager_get_storage_path (void);
VALA_EXTERN ImageManager* image_manager_new (void);
VALA_EXTERN ImageManager* image_manager_construct (GType object_type);
static void _image_manager_image_item_unref0_ (gpointer var);
static void _vala_ImageManagerImageItem_free_function_content_of (gpointer data);
VALA_EXTERN void image_manager_load (ImageManager* self,
                         xmlNode* n);
static ImageManagerImageItem* image_manager_image_item_new_from_xml (xmlNode* n);
static ImageManagerImageItem* image_manager_image_item_construct_from_xml (GType object_type,
                                                                    xmlNode* n);
static gint image_manager_image_item_get_id (ImageManagerImageItem* self);
VALA_EXTERN void image_manager_save (ImageManager* self,
                         xmlNode* n);
static gboolean image_manager_image_item_get_valid (ImageManagerImageItem* self);
static void image_manager_image_item_save (ImageManagerImageItem* self,
                                    xmlNode* parent);
static ImageManagerImageItem* image_manager_find_match (ImageManager* self,
                                                 gint id);
static ImageManagerImageItem* image_manager_find_uri_match (ImageManager* self,
                                                     const gchar* uri);
static const gchar* image_manager_image_item_get_uri (ImageManagerImageItem* self);
VALA_EXTERN gint image_manager_add_image (ImageManager* self,
                              const gchar* uri,
                              gint* orig_id);
static ImageManagerImageItem* image_manager_image_item_new (const gchar* uri);
static ImageManagerImageItem* image_manager_image_item_construct (GType object_type,
                                                           const gchar* uri);
static gboolean image_manager_image_item_copy_file (ImageManagerImageItem* self);
static gboolean image_manager_image_item_exists (ImageManagerImageItem* self);
VALA_EXTERN gint image_manager_add_pixbuf (ImageManager* self,
                               GdkPixbuf* buf,
                               gint* orig_id);
static gchar* image_manager_image_item_get_path (ImageManagerImageItem* self);
VALA_EXTERN gchar* image_manager_get_file (ImageManager* self,
                               gint id);
VALA_EXTERN gchar* image_manager_get_mime_type (ImageManager* self,
                                    gint id);
static gchar* image_manager_image_item_get_extension (ImageManagerImageItem* self);
VALA_EXTERN GArray* image_manager_get_ids (ImageManager* self);
VALA_EXTERN gchar* image_manager_get_uri (ImageManager* self,
                              gint id);
VALA_EXTERN void image_manager_set_valid (ImageManager* self,
                              gint id,
                              gboolean value);
static void image_manager_image_item_set_valid (ImageManagerImageItem* self,
                                         gboolean value);
VALA_EXTERN void image_manager_cleanup (ImageManager* self);
static void image_manager_image_item_cleanup (ImageManagerImageItem* self);
VALA_EXTERN gint image_manager_get_id (ImageManager* self,
                           gint id);
VALA_EXTERN gint image_manager_choose_image (ImageManager* self,
                                 GtkWindow* parent);
VALA_EXTERN void utils_set_chooser_folder (GtkFileChooser* chooser);
VALA_EXTERN void utils_store_chooser_folder (const gchar* file,
                                 gboolean is_dir);
static void image_manager_image_item_set_id (ImageManagerImageItem* self,
                                      gint value);
static void image_manager_image_item_set_uri (ImageManagerImageItem* self,
                                       const gchar* value);
static void image_manager_image_item_set_ext (ImageManagerImageItem* self,
                                       const gchar* value);
static const gchar* image_manager_image_item_get_ext (ImageManagerImageItem* self);
static void image_manager_image_item_finalize (ImageManagerImageItem * obj);
static GType image_manager_image_item_get_type_once (void);
static void image_manager_finalize (ImageManager * obj);
static GType image_manager_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
image_manager_get_instance_private (ImageManager* self)
{
	return G_STRUCT_MEMBER_P (self, ImageManager_private_offset);
}

static gchar*
image_manager_get_storage_path (void)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	_tmp0_ = g_get_user_data_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "minder", "images", NULL);
	result = _tmp1_;
	return result;
}

static void
_image_manager_image_item_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (image_manager_image_item_unref (var), NULL));
}

static void
_vala_ImageManagerImageItem_free_function_content_of (gpointer data)
{
	ImageManagerImageItem* self;
	self = *((ImageManagerImageItem**) data);
	_image_manager_image_item_unref0_ (self);
}

ImageManager*
image_manager_construct (GType object_type)
{
	ImageManager* self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	GArray* _tmp3_;
	GeeHashMap* _tmp4_;
	self = (ImageManager*) g_type_create_instance (object_type);
	_tmp0_ = image_manager_get_storage_path ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_mkdir_with_parents (_tmp1_, 0775) == 0;
	_g_free0 (_tmp1_);
	if (_tmp2_) {
		self->priv->_available = TRUE;
	}
	_tmp3_ = g_array_new (TRUE, TRUE, sizeof (ImageManagerImageItem*));
	g_array_set_clear_func (_tmp3_, (GDestroyNotify) _vala_ImageManagerImageItem_free_function_content_of);
	_g_array_unref0 (self->priv->_images);
	self->priv->_images = _tmp3_;
	_tmp4_ = gee_hash_map_new (G_TYPE_INT, NULL, NULL, G_TYPE_INT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_id_map);
	self->priv->_id_map = _tmp4_;
	return self;
}

ImageManager*
image_manager_new (void)
{
	return image_manager_construct (TYPE_IMAGE_MANAGER);
}

static gpointer
_image_manager_image_item_ref0 (gpointer self)
{
	return self ? image_manager_image_item_ref (self) : NULL;
}

void
image_manager_load (ImageManager* self,
                    xmlNode* n)
{
	g_return_if_fail (self != NULL);
	{
		xmlNode* it = NULL;
		xmlNode* _tmp0_;
		_tmp0_ = n->children;
		it = _tmp0_;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				xmlNode* _tmp4_;
				xmlNode* _tmp5_;
				if (!_tmp1_) {
					xmlNode* _tmp2_;
					xmlNode* _tmp3_;
					_tmp2_ = it;
					_tmp3_ = _tmp2_->next;
					it = _tmp3_;
				}
				_tmp1_ = FALSE;
				_tmp4_ = it;
				if (!(_tmp4_ != NULL)) {
					break;
				}
				_tmp5_ = it;
				if (_tmp5_->type == XML_ELEMENT_NODE) {
					xmlNode* _tmp6_;
					const gchar* _tmp7_;
					_tmp6_ = it;
					_tmp7_ = _tmp6_->name;
					if (g_strcmp0 (_tmp7_, "image") == 0) {
						ImageManagerImageItem* ii = NULL;
						xmlNode* _tmp8_;
						ImageManagerImageItem* _tmp9_;
						GeeHashMap* _tmp10_;
						ImageManagerImageItem* _tmp11_;
						gint _tmp12_;
						gint _tmp13_;
						_tmp8_ = it;
						_tmp9_ = image_manager_image_item_new_from_xml (_tmp8_);
						ii = _tmp9_;
						_tmp10_ = self->priv->_id_map;
						_tmp11_ = ii;
						_tmp12_ = image_manager_image_item_get_id (_tmp11_);
						_tmp13_ = _tmp12_;
						if (!gee_abstract_map_has_key ((GeeAbstractMap*) _tmp10_, (gpointer) ((gintptr) _tmp13_))) {
							GArray* _tmp14_;
							ImageManagerImageItem* _tmp15_;
							ImageManagerImageItem* _tmp16_;
							_tmp14_ = self->priv->_images;
							_tmp15_ = ii;
							_tmp16_ = _image_manager_image_item_ref0 (_tmp15_);
							g_array_append_val (_tmp14_, _tmp16_);
						}
						_image_manager_image_item_unref0 (ii);
					}
				}
			}
		}
	}
}

void
image_manager_save (ImageManager* self,
                    xmlNode* n)
{
	g_return_if_fail (self != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GArray* _tmp2_;
				GArray* _tmp3_;
				ImageManagerImageItem* _tmp4_;
				gboolean _tmp5_;
				gboolean _tmp6_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->_images;
				if (!(((guint) i) < _tmp2_->len)) {
					break;
				}
				_tmp3_ = self->priv->_images;
				_tmp4_ = g_array_index (_tmp3_, ImageManagerImageItem*, (guint) i);
				_tmp5_ = image_manager_image_item_get_valid (_tmp4_);
				_tmp6_ = _tmp5_;
				if (_tmp6_) {
					GArray* _tmp7_;
					ImageManagerImageItem* _tmp8_;
					_tmp7_ = self->priv->_images;
					_tmp8_ = g_array_index (_tmp7_, ImageManagerImageItem*, (guint) i);
					image_manager_image_item_save (_tmp8_, n);
				}
			}
		}
	}
}

static ImageManagerImageItem*
image_manager_find_match (ImageManager* self,
                          gint id)
{
	ImageManagerImageItem* result;
	g_return_val_if_fail (self != NULL, NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GArray* _tmp2_;
				GArray* _tmp3_;
				ImageManagerImageItem* _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->_images;
				if (!(((guint) i) < _tmp2_->len)) {
					break;
				}
				_tmp3_ = self->priv->_images;
				_tmp4_ = g_array_index (_tmp3_, ImageManagerImageItem*, (guint) i);
				_tmp5_ = image_manager_image_item_get_id (_tmp4_);
				_tmp6_ = _tmp5_;
				if (_tmp6_ == id) {
					GArray* _tmp7_;
					ImageManagerImageItem* _tmp8_;
					ImageManagerImageItem* _tmp9_;
					_tmp7_ = self->priv->_images;
					_tmp8_ = g_array_index (_tmp7_, ImageManagerImageItem*, (guint) i);
					_tmp9_ = _image_manager_image_item_ref0 (_tmp8_);
					result = _tmp9_;
					return result;
				}
			}
		}
	}
	result = NULL;
	return result;
}

static ImageManagerImageItem*
image_manager_find_uri_match (ImageManager* self,
                              const gchar* uri)
{
	ImageManagerImageItem* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GArray* _tmp2_;
				GArray* _tmp3_;
				ImageManagerImageItem* _tmp4_;
				const gchar* _tmp5_;
				const gchar* _tmp6_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->_images;
				if (!(((guint) i) < _tmp2_->len)) {
					break;
				}
				_tmp3_ = self->priv->_images;
				_tmp4_ = g_array_index (_tmp3_, ImageManagerImageItem*, (guint) i);
				_tmp5_ = image_manager_image_item_get_uri (_tmp4_);
				_tmp6_ = _tmp5_;
				if (g_strcmp0 (_tmp6_, uri) == 0) {
					GArray* _tmp7_;
					ImageManagerImageItem* _tmp8_;
					ImageManagerImageItem* _tmp9_;
					_tmp7_ = self->priv->_images;
					_tmp8_ = g_array_index (_tmp7_, ImageManagerImageItem*, (guint) i);
					_tmp9_ = _image_manager_image_item_ref0 (_tmp8_);
					result = _tmp9_;
					return result;
				}
			}
		}
	}
	result = NULL;
	return result;
}

gint
image_manager_add_image (ImageManager* self,
                         const gchar* uri,
                         gint* orig_id)
{
	ImageManagerImageItem* item = NULL;
	ImageManagerImageItem* _tmp0_;
	ImageManagerImageItem* _tmp1_;
	ImageManagerImageItem* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (uri != NULL, 0);
	_tmp0_ = image_manager_find_uri_match (self, uri);
	item = _tmp0_;
	_tmp1_ = item;
	if (_tmp1_ == NULL) {
		ImageManagerImageItem* _tmp2_;
		ImageManagerImageItem* _tmp3_;
		GArray* _tmp4_;
		ImageManagerImageItem* _tmp5_;
		ImageManagerImageItem* _tmp6_;
		_tmp2_ = image_manager_image_item_new (uri);
		_image_manager_image_item_unref0 (item);
		item = _tmp2_;
		_tmp3_ = item;
		if (!image_manager_image_item_copy_file (_tmp3_)) {
			result = -1;
			_image_manager_image_item_unref0 (item);
			return result;
		}
		_tmp4_ = self->priv->_images;
		_tmp5_ = item;
		_tmp6_ = _image_manager_image_item_ref0 (_tmp5_);
		g_array_append_val (_tmp4_, _tmp6_);
	} else {
		ImageManagerImageItem* _tmp7_;
		_tmp7_ = item;
		if (!image_manager_image_item_exists (_tmp7_)) {
			ImageManagerImageItem* _tmp8_;
			_tmp8_ = item;
			if (!image_manager_image_item_copy_file (_tmp8_)) {
				result = -1;
				_image_manager_image_item_unref0 (item);
				return result;
			}
		}
	}
	if (orig_id != NULL) {
		GeeHashMap* _tmp9_;
		ImageManagerImageItem* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		_tmp9_ = self->priv->_id_map;
		_tmp10_ = item;
		_tmp11_ = image_manager_image_item_get_id (_tmp10_);
		_tmp12_ = _tmp11_;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp9_, (gpointer) ((gintptr) (*orig_id)), (gpointer) ((gintptr) _tmp12_));
	}
	_tmp13_ = item;
	_tmp14_ = image_manager_image_item_get_id (_tmp13_);
	_tmp15_ = _tmp14_;
	result = _tmp15_;
	_image_manager_image_item_unref0 (item);
	return result;
}

gint
image_manager_add_pixbuf (ImageManager* self,
                          GdkPixbuf* buf,
                          gint* orig_id)
{
	ImageManagerImageItem* item = NULL;
	ImageManagerImageItem* _tmp0_;
	ImageManagerImageItem* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	GError* _inner_error0_ = NULL;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (buf != NULL, 0);
	_tmp0_ = image_manager_image_item_new ("");
	item = _tmp0_;
	{
		ImageManagerImageItem* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		GArray* _tmp4_;
		ImageManagerImageItem* _tmp5_;
		ImageManagerImageItem* _tmp6_;
		_tmp1_ = item;
		_tmp2_ = image_manager_image_item_get_path (_tmp1_);
		_tmp3_ = _tmp2_;
		gdk_pixbuf_save (buf, _tmp3_, "png", &_inner_error0_, NULL, NULL);
		_g_free0 (_tmp3_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp4_ = self->priv->_images;
		_tmp5_ = item;
		_tmp6_ = _image_manager_image_item_ref0 (_tmp5_);
		g_array_append_val (_tmp4_, _tmp6_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		result = -1;
		_image_manager_image_item_unref0 (item);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp7_ = -1;
		_image_manager_image_item_unref0 (item);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp7_;
	}
	_tmp8_ = item;
	_tmp9_ = image_manager_image_item_get_id (_tmp8_);
	_tmp10_ = _tmp9_;
	result = _tmp10_;
	_image_manager_image_item_unref0 (item);
	return result;
}

gchar*
image_manager_get_file (ImageManager* self,
                        gint id)
{
	ImageManagerImageItem* item = NULL;
	ImageManagerImageItem* _tmp0_;
	ImageManagerImageItem* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = image_manager_find_match (self, id);
	item = _tmp0_;
	_tmp1_ = item;
	if (_tmp1_ != NULL) {
		ImageManagerImageItem* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = item;
		_tmp3_ = image_manager_image_item_get_path (_tmp2_);
		result = _tmp3_;
		_image_manager_image_item_unref0 (item);
		return result;
	}
	result = NULL;
	_image_manager_image_item_unref0 (item);
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

gchar*
image_manager_get_mime_type (ImageManager* self,
                             gint id)
{
	ImageManagerImageItem* item = NULL;
	ImageManagerImageItem* _tmp0_;
	ImageManagerImageItem* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = image_manager_find_match (self, id);
	item = _tmp0_;
	_tmp1_ = item;
	if (_tmp1_ != NULL) {
		ImageManagerImageItem* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp2_ = item;
		_tmp3_ = image_manager_image_item_get_extension (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = string_substring (_tmp4_, (glong) 1, (glong) -1);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strdup_printf ("image/%s", _tmp6_);
		_tmp8_ = _tmp7_;
		_g_free0 (_tmp6_);
		_g_free0 (_tmp4_);
		result = _tmp8_;
		_image_manager_image_item_unref0 (item);
		return result;
	}
	result = NULL;
	_image_manager_image_item_unref0 (item);
	return result;
}

GArray*
image_manager_get_ids (ImageManager* self)
{
	GArray* ids = NULL;
	GArray* _tmp0_;
	GArray* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_array_new (TRUE, TRUE, sizeof (gint));
	ids = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				GArray* _tmp3_;
				GArray* _tmp4_;
				GArray* _tmp5_;
				ImageManagerImageItem* _tmp6_;
				gint _tmp7_;
				gint _tmp8_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = self->priv->_images;
				if (!(((guint) i) < _tmp3_->len)) {
					break;
				}
				_tmp4_ = ids;
				_tmp5_ = self->priv->_images;
				_tmp6_ = g_array_index (_tmp5_, ImageManagerImageItem*, (guint) i);
				_tmp7_ = image_manager_image_item_get_id (_tmp6_);
				_tmp8_ = _tmp7_;
				g_array_append_val (_tmp4_, _tmp8_);
			}
		}
	}
	result = ids;
	return result;
}

gchar*
image_manager_get_uri (ImageManager* self,
                       gint id)
{
	ImageManagerImageItem* item = NULL;
	ImageManagerImageItem* _tmp0_;
	ImageManagerImageItem* _tmp1_;
	gchar* _tmp6_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = image_manager_find_match (self, id);
	item = _tmp0_;
	_tmp1_ = item;
	if (_tmp1_ != NULL) {
		ImageManagerImageItem* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp2_ = item;
		_tmp3_ = image_manager_image_item_get_uri (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strdup (_tmp4_);
		result = _tmp5_;
		_image_manager_image_item_unref0 (item);
		return result;
	}
	_tmp6_ = g_strdup ("");
	result = _tmp6_;
	_image_manager_image_item_unref0 (item);
	return result;
}

void
image_manager_set_valid (ImageManager* self,
                         gint id,
                         gboolean value)
{
	ImageManagerImageItem* item = NULL;
	ImageManagerImageItem* _tmp0_;
	ImageManagerImageItem* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = image_manager_find_match (self, id);
	item = _tmp0_;
	_tmp1_ = item;
	if (_tmp1_ != NULL) {
		ImageManagerImageItem* _tmp2_;
		_tmp2_ = item;
		image_manager_image_item_set_valid (_tmp2_, value);
	}
	_image_manager_image_item_unref0 (item);
}

void
image_manager_cleanup (ImageManager* self)
{
	g_return_if_fail (self != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GArray* _tmp2_;
				GArray* _tmp3_;
				ImageManagerImageItem* _tmp4_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->_images;
				if (!(((guint) i) < _tmp2_->len)) {
					break;
				}
				_tmp3_ = self->priv->_images;
				_tmp4_ = g_array_index (_tmp3_, ImageManagerImageItem*, (guint) i);
				image_manager_image_item_cleanup (_tmp4_);
			}
		}
	}
}

gint
image_manager_get_id (ImageManager* self,
                      gint id)
{
	GeeHashMap* _tmp0_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_id_map;
	if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, (gpointer) ((gintptr) id))) {
		GeeHashMap* _tmp1_;
		gpointer _tmp2_;
		_tmp1_ = self->priv->_id_map;
		_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, (gpointer) ((gintptr) id));
		result = (gint) ((gintptr) _tmp2_);
		return result;
	}
	result = id;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

gint
image_manager_choose_image (ImageManager* self,
                            GtkWindow* parent)
{
	gint id = 0;
	GtkFileChooserNative* dialog = NULL;
	GtkFileChooserNative* _tmp0_;
	GtkFileChooserNative* _tmp1_;
	GtkFileFilter* filter = NULL;
	GtkFileFilter* _tmp2_;
	GtkFileFilter* _tmp3_;
	GtkFileFilter* _tmp4_;
	GtkFileFilter* _tmp5_;
	GtkFileFilter* _tmp6_;
	GtkFileFilter* _tmp7_;
	GtkFileFilter* _tmp8_;
	GtkFileChooserNative* _tmp9_;
	GtkFileFilter* _tmp10_;
	GtkFileFilter* _tmp11_;
	GtkFileChooserNative* _tmp12_;
	GtkFileChooserNative* _tmp19_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (parent != NULL, 0);
	id = -1;
	_tmp0_ = gtk_file_chooser_native_new (_ ("Select Image"), parent, GTK_FILE_CHOOSER_ACTION_OPEN, _ ("Select"), _ ("Cancel"));
	dialog = _tmp0_;
	_tmp1_ = dialog;
	utils_set_chooser_folder ((GtkFileChooser*) _tmp1_);
	_tmp2_ = gtk_file_filter_new ();
	g_object_ref_sink (_tmp2_);
	filter = _tmp2_;
	_tmp3_ = filter;
	gtk_file_filter_set_name (_tmp3_, _ ("Images"));
	_tmp4_ = filter;
	gtk_file_filter_add_pattern (_tmp4_, "*.bmp");
	_tmp5_ = filter;
	gtk_file_filter_add_pattern (_tmp5_, "*.png");
	_tmp6_ = filter;
	gtk_file_filter_add_pattern (_tmp6_, "*.jpg");
	_tmp7_ = filter;
	gtk_file_filter_add_pattern (_tmp7_, "*.jpeg");
	_tmp8_ = filter;
	gtk_file_filter_add_pattern (_tmp8_, "*.svg");
	_tmp9_ = dialog;
	_tmp10_ = filter;
	_tmp11_ = _g_object_ref0 (_tmp10_);
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp9_, _tmp11_);
	_tmp12_ = dialog;
	if (gtk_native_dialog_run ((GtkNativeDialog*) _tmp12_) == ((gint) GTK_RESPONSE_ACCEPT)) {
		GtkFileChooserNative* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		GtkFileChooserNative* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		_tmp13_ = dialog;
		_tmp14_ = gtk_file_chooser_get_uri ((GtkFileChooser*) _tmp13_);
		_tmp15_ = _tmp14_;
		id = image_manager_add_image (self, _tmp15_, NULL);
		_g_free0 (_tmp15_);
		_tmp16_ = dialog;
		_tmp17_ = gtk_file_chooser_get_filename ((GtkFileChooser*) _tmp16_);
		_tmp18_ = _tmp17_;
		utils_store_chooser_folder (_tmp18_, FALSE);
		_g_free0 (_tmp18_);
	}
	_tmp19_ = dialog;
	gtk_native_dialog_destroy ((GtkNativeDialog*) _tmp19_);
	result = id;
	_g_object_unref0 (filter);
	_g_object_unref0 (dialog);
	return result;
}

static inline gpointer
image_manager_image_item_get_instance_private (ImageManagerImageItem* self)
{
	return G_STRUCT_MEMBER_P (self, ImageManagerImageItem_private_offset);
}

static ImageManagerImageItem*
image_manager_image_item_construct (GType object_type,
                                    const gchar* uri)
{
	ImageManagerImageItem* self = NULL;
	GSettings* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GSettings* _tmp3_;
	gint _tmp4_;
	g_return_val_if_fail (uri != NULL, NULL);
	self = (ImageManagerImageItem*) g_type_create_instance (object_type);
	_tmp0_ = minder_settings;
	image_manager_image_item_set_id (self, g_settings_get_int (_tmp0_, "image-id"));
	image_manager_image_item_set_uri (self, uri);
	_tmp1_ = image_manager_image_item_get_extension (self);
	_tmp2_ = _tmp1_;
	image_manager_image_item_set_ext (self, _tmp2_);
	_g_free0 (_tmp2_);
	image_manager_image_item_set_valid (self, TRUE);
	_tmp3_ = minder_settings;
	_tmp4_ = self->priv->_id;
	g_settings_set_int (_tmp3_, "image-id", _tmp4_ + 1);
	return self;
}

static ImageManagerImageItem*
image_manager_image_item_new (const gchar* uri)
{
	return image_manager_image_item_construct (IMAGE_MANAGER_TYPE_IMAGE_ITEM, uri);
}

static ImageManagerImageItem*
image_manager_image_item_construct_from_xml (GType object_type,
                                             xmlNode* n)
{
	ImageManagerImageItem* self = NULL;
	gchar* i = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* u = NULL;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* e = NULL;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	self = (ImageManagerImageItem*) g_type_create_instance (object_type);
	_tmp0_ = (gchar*) xmlGetProp (n, (xmlChar*) "id");
	i = _tmp0_;
	_tmp1_ = i;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = i;
		image_manager_image_item_set_id (self, atoi (_tmp2_));
	}
	_tmp3_ = (gchar*) xmlGetProp (n, (xmlChar*) "uri");
	u = _tmp3_;
	_tmp4_ = u;
	if (_tmp4_ != NULL) {
		const gchar* _tmp5_;
		_tmp5_ = u;
		image_manager_image_item_set_uri (self, _tmp5_);
	}
	_tmp6_ = (gchar*) xmlGetProp (n, (xmlChar*) "ext");
	e = _tmp6_;
	_tmp7_ = e;
	if (_tmp7_ != NULL) {
		const gchar* _tmp8_;
		_tmp8_ = e;
		image_manager_image_item_set_ext (self, _tmp8_);
	}
	image_manager_image_item_set_valid (self, TRUE);
	_g_free0 (e);
	_g_free0 (u);
	_g_free0 (i);
	return self;
}

static ImageManagerImageItem*
image_manager_image_item_new_from_xml (xmlNode* n)
{
	return image_manager_image_item_construct_from_xml (IMAGE_MANAGER_TYPE_IMAGE_ITEM, n);
}

static void
image_manager_image_item_save (ImageManagerImageItem* self,
                               xmlNode* parent)
{
	xmlNode* n = NULL;
	xmlNode* _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = xmlNewNode (NULL, (xmlChar*) "image");
	n = _tmp0_;
	_tmp1_ = self->priv->_id;
	_tmp2_ = g_strdup_printf ("%i", _tmp1_);
	_tmp3_ = _tmp2_;
	xmlNewProp (n, (xmlChar*) "id", (xmlChar*) _tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = self->priv->_uri;
	xmlNewProp (n, (xmlChar*) "uri", (xmlChar*) _tmp4_);
	_tmp5_ = self->priv->_ext;
	xmlNewProp (n, (xmlChar*) "ext", (xmlChar*) _tmp5_);
	xmlAddChild (parent, n);
}

static gboolean
image_manager_image_item_exists (ImageManagerImageItem* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = image_manager_image_item_get_path (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_test (_tmp1_, G_FILE_TEST_EXISTS);
	_g_free0 (_tmp1_);
	result = _tmp2_;
	return result;
}

static gchar*
image_manager_image_item_get_extension (ImageManagerImageItem* self)
{
	const gchar* _tmp0_;
	gchar* _tmp25_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_uri;
	if (g_strcmp0 (_tmp0_, "") != 0) {
		gchar** parts = NULL;
		const gchar* _tmp1_;
		gchar** _tmp2_;
		gchar** _tmp3_;
		gint parts_length1;
		gint _parts_size_;
		gchar* ext = NULL;
		gchar** _tmp4_;
		gint _tmp4__length1;
		gchar** _tmp5_;
		gint _tmp5__length1;
		const gchar* _tmp6_;
		gchar** _tmp7_;
		gchar** _tmp8_;
		gchar** _tmp9_;
		gint _tmp9__length1;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_ = FALSE;
		gboolean _tmp16_ = FALSE;
		const gchar* _tmp17_;
		_tmp1_ = self->priv->_uri;
		_tmp3_ = _tmp2_ = g_strsplit (_tmp1_, ".", 0);
		parts = _tmp3_;
		parts_length1 = _vala_array_length (_tmp2_);
		_parts_size_ = parts_length1;
		_tmp4_ = parts;
		_tmp4__length1 = parts_length1;
		_tmp5_ = parts;
		_tmp5__length1 = parts_length1;
		_tmp6_ = _tmp4_[_tmp5__length1 - 1];
		_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, "?", 0);
		_tmp9_ = _tmp8_;
		_tmp9__length1 = _vala_array_length (_tmp7_);
		_tmp10_ = _tmp9_[0];
		_tmp11_ = g_strdup (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp9_ = (_vala_array_free (_tmp9_, _tmp9__length1, (GDestroyNotify) g_free), NULL);
		ext = _tmp12_;
		_tmp17_ = ext;
		if (g_strcmp0 (_tmp17_, "bmp") == 0) {
			_tmp16_ = TRUE;
		} else {
			const gchar* _tmp18_;
			_tmp18_ = ext;
			_tmp16_ = g_strcmp0 (_tmp18_, "png") == 0;
		}
		if (_tmp16_) {
			_tmp15_ = TRUE;
		} else {
			const gchar* _tmp19_;
			_tmp19_ = ext;
			_tmp15_ = g_strcmp0 (_tmp19_, "jpg") == 0;
		}
		if (_tmp15_) {
			_tmp14_ = TRUE;
		} else {
			const gchar* _tmp20_;
			_tmp20_ = ext;
			_tmp14_ = g_strcmp0 (_tmp20_, "jpeg") == 0;
		}
		if (_tmp14_) {
			_tmp13_ = TRUE;
		} else {
			const gchar* _tmp21_;
			_tmp21_ = ext;
			_tmp13_ = g_strcmp0 (_tmp21_, "svg") == 0;
		}
		if (_tmp13_) {
			const gchar* _tmp22_;
			gchar* _tmp23_;
			_tmp22_ = ext;
			_tmp23_ = g_strconcat (".", _tmp22_, NULL);
			result = _tmp23_;
			_g_free0 (ext);
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
			return result;
		}
		_g_free0 (ext);
		parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
	} else {
		gchar* _tmp24_;
		_tmp24_ = g_strdup (".png");
		result = _tmp24_;
		return result;
	}
	_tmp25_ = g_strdup ("");
	result = _tmp25_;
	return result;
}

static gchar*
image_manager_image_item_get_path (ImageManagerImageItem* self)
{
	gchar* basename = NULL;
	gint _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_id;
	_tmp1_ = self->priv->_ext;
	_tmp2_ = g_strdup_printf ("img%06x%s", (guint) _tmp0_, _tmp1_);
	basename = _tmp2_;
	_tmp3_ = image_manager_get_storage_path ();
	_tmp4_ = _tmp3_;
	_tmp5_ = g_build_filename (_tmp4_, basename, NULL);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	result = _tmp6_;
	_g_free0 (basename);
	return result;
}

static gboolean
image_manager_image_item_copy_file (ImageManagerImageItem* self)
{
	GFile* rfile = NULL;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	GFile* lfile = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_uri;
	_tmp1_ = g_file_new_for_uri (_tmp0_);
	rfile = _tmp1_;
	_tmp2_ = image_manager_image_item_get_path (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_file_new_for_path (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	lfile = _tmp5_;
	{
		GFile* _tmp6_;
		GFile* _tmp7_;
		_tmp6_ = rfile;
		_tmp7_ = lfile;
		g_file_copy (_tmp6_, _tmp7_, G_FILE_COPY_OVERWRITE, NULL, NULL, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp8_;
		GError* _tmp9_;
		const gchar* _tmp10_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = stdout;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		fprintf (_tmp8_, "Error: %s\n", _tmp10_);
		result = FALSE;
		_g_error_free0 (e);
		_g_object_unref0 (lfile);
		_g_object_unref0 (rfile);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp11_ = FALSE;
		_g_object_unref0 (lfile);
		_g_object_unref0 (rfile);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp11_;
	}
	result = TRUE;
	_g_object_unref0 (lfile);
	_g_object_unref0 (rfile);
	return result;
}

static void
image_manager_image_item_cleanup (ImageManagerImageItem* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->_valid;
	if (!_tmp1_) {
		_tmp0_ = image_manager_image_item_exists (self);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = image_manager_image_item_get_path (self);
		_tmp3_ = _tmp2_;
		g_unlink (_tmp3_);
		_g_free0 (_tmp3_);
	}
}

static gint
image_manager_image_item_get_id (ImageManagerImageItem* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_id;
	return result;
}

static void
image_manager_image_item_set_id (ImageManagerImageItem* self,
                                 gint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_id = value;
}

static const gchar*
image_manager_image_item_get_uri (ImageManagerImageItem* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_uri;
	result = _tmp0_;
	return result;
}

static void
image_manager_image_item_set_uri (ImageManagerImageItem* self,
                                  const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_uri);
	self->priv->_uri = _tmp0_;
}

static const gchar*
image_manager_image_item_get_ext (ImageManagerImageItem* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_ext;
	result = _tmp0_;
	return result;
}

static void
image_manager_image_item_set_ext (ImageManagerImageItem* self,
                                  const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_ext);
	self->priv->_ext = _tmp0_;
}

static gboolean
image_manager_image_item_get_valid (ImageManagerImageItem* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_valid;
	return result;
}

static void
image_manager_image_item_set_valid (ImageManagerImageItem* self,
                                    gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_valid = value;
}

static void
image_manager_value_image_item_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
image_manager_value_image_item_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		image_manager_image_item_unref (value->data[0].v_pointer);
	}
}

static void
image_manager_value_image_item_copy_value (const GValue* src_value,
                                           GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = image_manager_image_item_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
image_manager_value_image_item_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
image_manager_value_image_item_collect_value (GValue* value,
                                              guint n_collect_values,
                                              GTypeCValue* collect_values,
                                              guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ImageManagerImageItem * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = image_manager_image_item_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
image_manager_value_image_item_lcopy_value (const GValue* value,
                                            guint n_collect_values,
                                            GTypeCValue* collect_values,
                                            guint collect_flags)
{
	ImageManagerImageItem ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = image_manager_image_item_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
image_manager_param_spec_image_item (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags)
{
	ImageManagerParamSpecImageItem* spec;
	g_return_val_if_fail (g_type_is_a (object_type, IMAGE_MANAGER_TYPE_IMAGE_ITEM), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
image_manager_value_get_image_item (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, IMAGE_MANAGER_TYPE_IMAGE_ITEM), NULL);
	return value->data[0].v_pointer;
}

static void
image_manager_value_set_image_item (GValue* value,
                                    gpointer v_object)
{
	ImageManagerImageItem * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, IMAGE_MANAGER_TYPE_IMAGE_ITEM));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, IMAGE_MANAGER_TYPE_IMAGE_ITEM));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		image_manager_image_item_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		image_manager_image_item_unref (old);
	}
}

static void
image_manager_value_take_image_item (GValue* value,
                                     gpointer v_object)
{
	ImageManagerImageItem * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, IMAGE_MANAGER_TYPE_IMAGE_ITEM));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, IMAGE_MANAGER_TYPE_IMAGE_ITEM));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		image_manager_image_item_unref (old);
	}
}

static void
image_manager_image_item_class_init (ImageManagerImageItemClass * klass,
                                     gpointer klass_data)
{
	image_manager_image_item_parent_class = g_type_class_peek_parent (klass);
	((ImageManagerImageItemClass *) klass)->finalize = image_manager_image_item_finalize;
	g_type_class_adjust_private_offset (klass, &ImageManagerImageItem_private_offset);
}

static void
image_manager_image_item_instance_init (ImageManagerImageItem * self,
                                        gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	self->priv = image_manager_image_item_get_instance_private (self);
	self->priv->_id = -1;
	_tmp0_ = g_strdup ("");
	self->priv->_uri = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->priv->_ext = _tmp1_;
	self->priv->_valid = FALSE;
	self->ref_count = 1;
}

static void
image_manager_image_item_finalize (ImageManagerImageItem * obj)
{
	ImageManagerImageItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, IMAGE_MANAGER_TYPE_IMAGE_ITEM, ImageManagerImageItem);
	g_signal_handlers_destroy (self);
	_g_free0 (self->priv->_uri);
	_g_free0 (self->priv->_ext);
}

static GType
image_manager_image_item_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { image_manager_value_image_item_init, image_manager_value_image_item_free_value, image_manager_value_image_item_copy_value, image_manager_value_image_item_peek_pointer, "p", image_manager_value_image_item_collect_value, "p", image_manager_value_image_item_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ImageManagerImageItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) image_manager_image_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ImageManagerImageItem), 0, (GInstanceInitFunc) image_manager_image_item_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType image_manager_image_item_type_id;
	image_manager_image_item_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ImageManagerImageItem", &g_define_type_info, &g_define_type_fundamental_info, 0);
	ImageManagerImageItem_private_offset = g_type_add_instance_private (image_manager_image_item_type_id, sizeof (ImageManagerImageItemPrivate));
	return image_manager_image_item_type_id;
}

static GType
image_manager_image_item_get_type (void)
{
	static volatile gsize image_manager_image_item_type_id__once = 0;
	if (g_once_init_enter (&image_manager_image_item_type_id__once)) {
		GType image_manager_image_item_type_id;
		image_manager_image_item_type_id = image_manager_image_item_get_type_once ();
		g_once_init_leave (&image_manager_image_item_type_id__once, image_manager_image_item_type_id);
	}
	return image_manager_image_item_type_id__once;
}

static gpointer
image_manager_image_item_ref (gpointer instance)
{
	ImageManagerImageItem * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
image_manager_image_item_unref (gpointer instance)
{
	ImageManagerImageItem * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		IMAGE_MANAGER_IMAGE_ITEM_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
value_image_manager_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_image_manager_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		image_manager_unref (value->data[0].v_pointer);
	}
}

static void
value_image_manager_copy_value (const GValue* src_value,
                                GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = image_manager_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_image_manager_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_image_manager_collect_value (GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ImageManager * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = image_manager_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_image_manager_lcopy_value (const GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
	ImageManager ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = image_manager_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_image_manager (const gchar* name,
                          const gchar* nick,
                          const gchar* blurb,
                          GType object_type,
                          GParamFlags flags)
{
	ParamSpecImageManager* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_IMAGE_MANAGER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_image_manager (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_IMAGE_MANAGER), NULL);
	return value->data[0].v_pointer;
}

void
value_set_image_manager (GValue* value,
                         gpointer v_object)
{
	ImageManager * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_IMAGE_MANAGER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_IMAGE_MANAGER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		image_manager_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		image_manager_unref (old);
	}
}

void
value_take_image_manager (GValue* value,
                          gpointer v_object)
{
	ImageManager * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_IMAGE_MANAGER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_IMAGE_MANAGER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		image_manager_unref (old);
	}
}

static void
image_manager_class_init (ImageManagerClass * klass,
                          gpointer klass_data)
{
	image_manager_parent_class = g_type_class_peek_parent (klass);
	((ImageManagerClass *) klass)->finalize = image_manager_finalize;
	g_type_class_adjust_private_offset (klass, &ImageManager_private_offset);
}

static void
image_manager_instance_init (ImageManager * self,
                             gpointer klass)
{
	self->priv = image_manager_get_instance_private (self);
	self->priv->_available = TRUE;
	self->ref_count = 1;
}

static void
image_manager_finalize (ImageManager * obj)
{
	ImageManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_IMAGE_MANAGER, ImageManager);
	g_signal_handlers_destroy (self);
	_g_array_unref0 (self->priv->_images);
	_g_object_unref0 (self->priv->_id_map);
}

static GType
image_manager_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_image_manager_init, value_image_manager_free_value, value_image_manager_copy_value, value_image_manager_peek_pointer, "p", value_image_manager_collect_value, "p", value_image_manager_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ImageManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) image_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ImageManager), 0, (GInstanceInitFunc) image_manager_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType image_manager_type_id;
	image_manager_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ImageManager", &g_define_type_info, &g_define_type_fundamental_info, 0);
	ImageManager_private_offset = g_type_add_instance_private (image_manager_type_id, sizeof (ImageManagerPrivate));
	return image_manager_type_id;
}

GType
image_manager_get_type (void)
{
	static volatile gsize image_manager_type_id__once = 0;
	if (g_once_init_enter (&image_manager_type_id__once)) {
		GType image_manager_type_id;
		image_manager_type_id = image_manager_get_type_once ();
		g_once_init_leave (&image_manager_type_id__once, image_manager_type_id);
	}
	return image_manager_type_id__once;
}

gpointer
image_manager_ref (gpointer instance)
{
	ImageManager * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
image_manager_unref (gpointer instance)
{
	ImageManager * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		IMAGE_MANAGER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

