/* parsed class NVA26F */

#include "nvtypes.h"
#include "cla26f.h"

#include <assert.h>
#include <stdio.h>
#include "util/u_math.h"

struct nv_nva26f_SET_OBJECT {
    uint32_t nvclass;
    uint32_t engine;
};

static inline void
__NVA26F_SET_OBJECT(uint32_t *val_out, struct nv_nva26f_SET_OBJECT st)
{
    uint32_t val = 0;
    
    assert(st.nvclass < (1ULL << 16));
    val |= st.nvclass << 0;
    
    assert(st.engine < (1ULL << 5));
    val |= st.engine << 16;
    *val_out = val;
}

#define V_NVA26F_SET_OBJECT(val, args...) { \
    UNUSED uint32_t ENGINE_SW = NVA26F_SET_OBJECT_ENGINE_SW; \
    struct nv_nva26f_SET_OBJECT __data = args; \
    __NVA26F_SET_OBJECT(&val, __data); \
}

#define VA_NVA26F_SET_OBJECT V_NVA26F_SET_OBJECT

#define P_NVA26F_SET_OBJECT(push, args...) do { \
    UNUSED uint32_t ENGINE_SW = NVA26F_SET_OBJECT_ENGINE_SW; \
    uint32_t nvk_p_ret; \
    V_NVA26F_SET_OBJECT(nvk_p_ret, args); \
    nv_push_val(push, NVA26F_SET_OBJECT, nvk_p_ret); \
} while(0)

struct nv_nva26f_ILLEGAL {
    uint32_t handle;
};

static inline void
__NVA26F_ILLEGAL(uint32_t *val_out, struct nv_nva26f_ILLEGAL st)
{
    uint32_t val = 0;
    
    val |= st.handle;
    *val_out = val;
}

#define V_NVA26F_ILLEGAL(val, args...) { \
    struct nv_nva26f_ILLEGAL __data = { .handle = (args) }; \
    __NVA26F_ILLEGAL(&val, __data); \
}

#define VA_NVA26F_ILLEGAL V_NVA26F_ILLEGAL

#define P_NVA26F_ILLEGAL(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA26F_ILLEGAL(nvk_p_ret, args); \
    nv_push_val(push, NVA26F_ILLEGAL, nvk_p_ret); \
} while(0)

struct nv_nva26f_NOP {
    uint32_t handle;
};

static inline void
__NVA26F_NOP(uint32_t *val_out, struct nv_nva26f_NOP st)
{
    uint32_t val = 0;
    
    val |= st.handle;
    *val_out = val;
}

#define V_NVA26F_NOP(val, args...) { \
    struct nv_nva26f_NOP __data = { .handle = (args) }; \
    __NVA26F_NOP(&val, __data); \
}

#define VA_NVA26F_NOP V_NVA26F_NOP

#define P_NVA26F_NOP(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA26F_NOP(nvk_p_ret, args); \
    nv_push_val(push, NVA26F_NOP, nvk_p_ret); \
} while(0)

struct nv_nva26f_SEMAPHOREA {
    uint32_t offset_upper;
};

static inline void
__NVA26F_SEMAPHOREA(uint32_t *val_out, struct nv_nva26f_SEMAPHOREA st)
{
    uint32_t val = 0;
    
    assert(st.offset_upper < (1ULL << 8));
    val |= st.offset_upper << 0;
    *val_out = val;
}

#define V_NVA26F_SEMAPHOREA(val, args...) { \
    struct nv_nva26f_SEMAPHOREA __data = { .offset_upper = (args) }; \
    __NVA26F_SEMAPHOREA(&val, __data); \
}

#define VA_NVA26F_SEMAPHOREA V_NVA26F_SEMAPHOREA

#define P_NVA26F_SEMAPHOREA(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA26F_SEMAPHOREA(nvk_p_ret, args); \
    nv_push_val(push, NVA26F_SEMAPHOREA, nvk_p_ret); \
} while(0)

struct nv_nva26f_SEMAPHOREB {
    uint32_t offset_lower;
};

static inline void
__NVA26F_SEMAPHOREB(uint32_t *val_out, struct nv_nva26f_SEMAPHOREB st)
{
    uint32_t val = 0;
    
    assert(st.offset_lower < (1ULL << 30));
    val |= st.offset_lower << 2;
    *val_out = val;
}

#define V_NVA26F_SEMAPHOREB(val, args...) { \
    struct nv_nva26f_SEMAPHOREB __data = { .offset_lower = (args) }; \
    __NVA26F_SEMAPHOREB(&val, __data); \
}

#define VA_NVA26F_SEMAPHOREB V_NVA26F_SEMAPHOREB

#define P_NVA26F_SEMAPHOREB(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA26F_SEMAPHOREB(nvk_p_ret, args); \
    nv_push_val(push, NVA26F_SEMAPHOREB, nvk_p_ret); \
} while(0)

struct nv_nva26f_SEMAPHOREC {
    uint32_t payload;
};

static inline void
__NVA26F_SEMAPHOREC(uint32_t *val_out, struct nv_nva26f_SEMAPHOREC st)
{
    uint32_t val = 0;
    
    val |= st.payload;
    *val_out = val;
}

#define V_NVA26F_SEMAPHOREC(val, args...) { \
    struct nv_nva26f_SEMAPHOREC __data = { .payload = (args) }; \
    __NVA26F_SEMAPHOREC(&val, __data); \
}

#define VA_NVA26F_SEMAPHOREC V_NVA26F_SEMAPHOREC

#define P_NVA26F_SEMAPHOREC(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA26F_SEMAPHOREC(nvk_p_ret, args); \
    nv_push_val(push, NVA26F_SEMAPHOREC, nvk_p_ret); \
} while(0)

struct nv_nva26f_SEMAPHORED {
    uint32_t operation;
    uint32_t acquire_switch;
    uint32_t release_wfi;
    uint32_t release_size;
};

static inline void
__NVA26F_SEMAPHORED(uint32_t *val_out, struct nv_nva26f_SEMAPHORED st)
{
    uint32_t val = 0;
    
    assert(st.operation < (1ULL << 4));
    val |= st.operation << 0;
    
    assert(st.acquire_switch < (1ULL << 1));
    val |= st.acquire_switch << 12;
    
    assert(st.release_wfi < (1ULL << 1));
    val |= st.release_wfi << 20;
    
    assert(st.release_size < (1ULL << 1));
    val |= st.release_size << 24;
    *val_out = val;
}

#define V_NVA26F_SEMAPHORED(val, args...) { \
    UNUSED uint32_t OPERATION_ACQUIRE = NVA26F_SEMAPHORED_OPERATION_ACQUIRE; \
    UNUSED uint32_t OPERATION_RELEASE = NVA26F_SEMAPHORED_OPERATION_RELEASE; \
    UNUSED uint32_t OPERATION_ACQ_GEQ = NVA26F_SEMAPHORED_OPERATION_ACQ_GEQ; \
    UNUSED uint32_t OPERATION_ACQ_AND = NVA26F_SEMAPHORED_OPERATION_ACQ_AND; \
    UNUSED uint32_t ACQUIRE_SWITCH_DISABLED = NVA26F_SEMAPHORED_ACQUIRE_SWITCH_DISABLED; \
    UNUSED uint32_t ACQUIRE_SWITCH_ENABLED = NVA26F_SEMAPHORED_ACQUIRE_SWITCH_ENABLED; \
    UNUSED uint32_t RELEASE_WFI_EN = NVA26F_SEMAPHORED_RELEASE_WFI_EN; \
    UNUSED uint32_t RELEASE_WFI_DIS = NVA26F_SEMAPHORED_RELEASE_WFI_DIS; \
    UNUSED uint32_t RELEASE_SIZE_16BYTE = NVA26F_SEMAPHORED_RELEASE_SIZE_16BYTE; \
    UNUSED uint32_t RELEASE_SIZE_4BYTE = NVA26F_SEMAPHORED_RELEASE_SIZE_4BYTE; \
    struct nv_nva26f_SEMAPHORED __data = args; \
    __NVA26F_SEMAPHORED(&val, __data); \
}

#define VA_NVA26F_SEMAPHORED V_NVA26F_SEMAPHORED

#define P_NVA26F_SEMAPHORED(push, args...) do { \
    UNUSED uint32_t OPERATION_ACQUIRE = NVA26F_SEMAPHORED_OPERATION_ACQUIRE; \
    UNUSED uint32_t OPERATION_RELEASE = NVA26F_SEMAPHORED_OPERATION_RELEASE; \
    UNUSED uint32_t OPERATION_ACQ_GEQ = NVA26F_SEMAPHORED_OPERATION_ACQ_GEQ; \
    UNUSED uint32_t OPERATION_ACQ_AND = NVA26F_SEMAPHORED_OPERATION_ACQ_AND; \
    UNUSED uint32_t ACQUIRE_SWITCH_DISABLED = NVA26F_SEMAPHORED_ACQUIRE_SWITCH_DISABLED; \
    UNUSED uint32_t ACQUIRE_SWITCH_ENABLED = NVA26F_SEMAPHORED_ACQUIRE_SWITCH_ENABLED; \
    UNUSED uint32_t RELEASE_WFI_EN = NVA26F_SEMAPHORED_RELEASE_WFI_EN; \
    UNUSED uint32_t RELEASE_WFI_DIS = NVA26F_SEMAPHORED_RELEASE_WFI_DIS; \
    UNUSED uint32_t RELEASE_SIZE_16BYTE = NVA26F_SEMAPHORED_RELEASE_SIZE_16BYTE; \
    UNUSED uint32_t RELEASE_SIZE_4BYTE = NVA26F_SEMAPHORED_RELEASE_SIZE_4BYTE; \
    uint32_t nvk_p_ret; \
    V_NVA26F_SEMAPHORED(nvk_p_ret, args); \
    nv_push_val(push, NVA26F_SEMAPHORED, nvk_p_ret); \
} while(0)

struct nv_nva26f_NON_STALL_INTERRUPT {
    uint32_t handle;
};

static inline void
__NVA26F_NON_STALL_INTERRUPT(uint32_t *val_out, struct nv_nva26f_NON_STALL_INTERRUPT st)
{
    uint32_t val = 0;
    
    val |= st.handle;
    *val_out = val;
}

#define V_NVA26F_NON_STALL_INTERRUPT(val, args...) { \
    struct nv_nva26f_NON_STALL_INTERRUPT __data = { .handle = (args) }; \
    __NVA26F_NON_STALL_INTERRUPT(&val, __data); \
}

#define VA_NVA26F_NON_STALL_INTERRUPT V_NVA26F_NON_STALL_INTERRUPT

#define P_NVA26F_NON_STALL_INTERRUPT(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA26F_NON_STALL_INTERRUPT(nvk_p_ret, args); \
    nv_push_val(push, NVA26F_NON_STALL_INTERRUPT, nvk_p_ret); \
} while(0)

struct nv_nva26f_FB_FLUSH {
    uint32_t handle;
};

static inline void
__NVA26F_FB_FLUSH(uint32_t *val_out, struct nv_nva26f_FB_FLUSH st)
{
    uint32_t val = 0;
    
    val |= st.handle;
    *val_out = val;
}

#define V_NVA26F_FB_FLUSH(val, args...) { \
    struct nv_nva26f_FB_FLUSH __data = { .handle = (args) }; \
    __NVA26F_FB_FLUSH(&val, __data); \
}

#define VA_NVA26F_FB_FLUSH V_NVA26F_FB_FLUSH

#define P_NVA26F_FB_FLUSH(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA26F_FB_FLUSH(nvk_p_ret, args); \
    nv_push_val(push, NVA26F_FB_FLUSH, nvk_p_ret); \
} while(0)

struct nv_nva26f_MEM_OP_A {
    uint32_t operand_low;
    uint32_t tlb_invalidate_addr;
    uint32_t tlb_invalidate_target;
};

static inline void
__NVA26F_MEM_OP_A(uint32_t *val_out, struct nv_nva26f_MEM_OP_A st)
{
    uint32_t val = 0;
    
    assert(st.operand_low < (1ULL << 30));
    val |= st.operand_low << 2;
    
    assert(st.tlb_invalidate_addr < (1ULL << 28));
    val |= st.tlb_invalidate_addr << 2;
    
    assert(st.tlb_invalidate_target < (1ULL << 2));
    val |= st.tlb_invalidate_target << 30;
    *val_out = val;
}

#define V_NVA26F_MEM_OP_A(val, args...) { \
    UNUSED uint32_t TLB_INVALIDATE_TARGET_VID_MEM = NVA26F_MEM_OP_A_TLB_INVALIDATE_TARGET_VID_MEM; \
    UNUSED uint32_t TLB_INVALIDATE_TARGET_SYS_MEM_COHERENT = NVA26F_MEM_OP_A_TLB_INVALIDATE_TARGET_SYS_MEM_COHERENT; \
    UNUSED uint32_t TLB_INVALIDATE_TARGET_SYS_MEM_NONCOHERENT = NVA26F_MEM_OP_A_TLB_INVALIDATE_TARGET_SYS_MEM_NONCOHERENT; \
    struct nv_nva26f_MEM_OP_A __data = args; \
    __NVA26F_MEM_OP_A(&val, __data); \
}

#define VA_NVA26F_MEM_OP_A V_NVA26F_MEM_OP_A

#define P_NVA26F_MEM_OP_A(push, args...) do { \
    UNUSED uint32_t TLB_INVALIDATE_TARGET_VID_MEM = NVA26F_MEM_OP_A_TLB_INVALIDATE_TARGET_VID_MEM; \
    UNUSED uint32_t TLB_INVALIDATE_TARGET_SYS_MEM_COHERENT = NVA26F_MEM_OP_A_TLB_INVALIDATE_TARGET_SYS_MEM_COHERENT; \
    UNUSED uint32_t TLB_INVALIDATE_TARGET_SYS_MEM_NONCOHERENT = NVA26F_MEM_OP_A_TLB_INVALIDATE_TARGET_SYS_MEM_NONCOHERENT; \
    uint32_t nvk_p_ret; \
    V_NVA26F_MEM_OP_A(nvk_p_ret, args); \
    nv_push_val(push, NVA26F_MEM_OP_A, nvk_p_ret); \
} while(0)

struct nv_nva26f_MEM_OP_B {
    uint32_t operand_high;
    uint32_t operation;
    uint32_t mmu_tlb_invalidate_pdb;
    uint32_t mmu_tlb_invalidate_gpc;
};

static inline void
__NVA26F_MEM_OP_B(uint32_t *val_out, struct nv_nva26f_MEM_OP_B st)
{
    uint32_t val = 0;
    
    assert(st.operand_high < (1ULL << 8));
    val |= st.operand_high << 0;
    
    assert(st.operation < (1ULL << 5));
    val |= st.operation << 27;
    
    assert(st.mmu_tlb_invalidate_pdb < (1ULL << 1));
    val |= st.mmu_tlb_invalidate_pdb << 0;
    
    assert(st.mmu_tlb_invalidate_gpc < (1ULL << 1));
    val |= st.mmu_tlb_invalidate_gpc << 1;
    *val_out = val;
}

#define V_NVA26F_MEM_OP_B(val, args...) { \
    UNUSED uint32_t OPERATION_SYSMEMBAR_FLUSH = NVA26F_MEM_OP_B_OPERATION_SYSMEMBAR_FLUSH; \
    UNUSED uint32_t OPERATION_MMU_TLB_INVALIDATE = NVA26F_MEM_OP_B_OPERATION_MMU_TLB_INVALIDATE; \
    UNUSED uint32_t OPERATION_L2_INVALIDATE_CLEAN_LINES = NVA26F_MEM_OP_B_OPERATION_L2_INVALIDATE_CLEAN_LINES; \
    UNUSED uint32_t OPERATION_L2_CLEAN_COMPTAGS = NVA26F_MEM_OP_B_OPERATION_L2_CLEAN_COMPTAGS; \
    UNUSED uint32_t OPERATION_L2_FLUSH_DIRTY = NVA26F_MEM_OP_B_OPERATION_L2_FLUSH_DIRTY; \
    UNUSED uint32_t MMU_TLB_INVALIDATE_PDB_ONE = NVA26F_MEM_OP_B_MMU_TLB_INVALIDATE_PDB_ONE; \
    UNUSED uint32_t MMU_TLB_INVALIDATE_PDB_ALL = NVA26F_MEM_OP_B_MMU_TLB_INVALIDATE_PDB_ALL; \
    UNUSED uint32_t MMU_TLB_INVALIDATE_GPC_ENABLE = NVA26F_MEM_OP_B_MMU_TLB_INVALIDATE_GPC_ENABLE; \
    UNUSED uint32_t MMU_TLB_INVALIDATE_GPC_DISABLE = NVA26F_MEM_OP_B_MMU_TLB_INVALIDATE_GPC_DISABLE; \
    struct nv_nva26f_MEM_OP_B __data = args; \
    __NVA26F_MEM_OP_B(&val, __data); \
}

#define VA_NVA26F_MEM_OP_B V_NVA26F_MEM_OP_B

#define P_NVA26F_MEM_OP_B(push, args...) do { \
    UNUSED uint32_t OPERATION_SYSMEMBAR_FLUSH = NVA26F_MEM_OP_B_OPERATION_SYSMEMBAR_FLUSH; \
    UNUSED uint32_t OPERATION_MMU_TLB_INVALIDATE = NVA26F_MEM_OP_B_OPERATION_MMU_TLB_INVALIDATE; \
    UNUSED uint32_t OPERATION_L2_INVALIDATE_CLEAN_LINES = NVA26F_MEM_OP_B_OPERATION_L2_INVALIDATE_CLEAN_LINES; \
    UNUSED uint32_t OPERATION_L2_CLEAN_COMPTAGS = NVA26F_MEM_OP_B_OPERATION_L2_CLEAN_COMPTAGS; \
    UNUSED uint32_t OPERATION_L2_FLUSH_DIRTY = NVA26F_MEM_OP_B_OPERATION_L2_FLUSH_DIRTY; \
    UNUSED uint32_t MMU_TLB_INVALIDATE_PDB_ONE = NVA26F_MEM_OP_B_MMU_TLB_INVALIDATE_PDB_ONE; \
    UNUSED uint32_t MMU_TLB_INVALIDATE_PDB_ALL = NVA26F_MEM_OP_B_MMU_TLB_INVALIDATE_PDB_ALL; \
    UNUSED uint32_t MMU_TLB_INVALIDATE_GPC_ENABLE = NVA26F_MEM_OP_B_MMU_TLB_INVALIDATE_GPC_ENABLE; \
    UNUSED uint32_t MMU_TLB_INVALIDATE_GPC_DISABLE = NVA26F_MEM_OP_B_MMU_TLB_INVALIDATE_GPC_DISABLE; \
    uint32_t nvk_p_ret; \
    V_NVA26F_MEM_OP_B(nvk_p_ret, args); \
    nv_push_val(push, NVA26F_MEM_OP_B, nvk_p_ret); \
} while(0)

struct nv_nva26f_SET_REFERENCE {
    uint32_t count;
};

static inline void
__NVA26F_SET_REFERENCE(uint32_t *val_out, struct nv_nva26f_SET_REFERENCE st)
{
    uint32_t val = 0;
    
    val |= st.count;
    *val_out = val;
}

#define V_NVA26F_SET_REFERENCE(val, args...) { \
    struct nv_nva26f_SET_REFERENCE __data = { .count = (args) }; \
    __NVA26F_SET_REFERENCE(&val, __data); \
}

#define VA_NVA26F_SET_REFERENCE V_NVA26F_SET_REFERENCE

#define P_NVA26F_SET_REFERENCE(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA26F_SET_REFERENCE(nvk_p_ret, args); \
    nv_push_val(push, NVA26F_SET_REFERENCE, nvk_p_ret); \
} while(0)

struct nv_nva26f_SYNCPOINTA {
    uint32_t payload;
};

static inline void
__NVA26F_SYNCPOINTA(uint32_t *val_out, struct nv_nva26f_SYNCPOINTA st)
{
    uint32_t val = 0;
    
    val |= st.payload;
    *val_out = val;
}

#define V_NVA26F_SYNCPOINTA(val, args...) { \
    struct nv_nva26f_SYNCPOINTA __data = { .payload = (args) }; \
    __NVA26F_SYNCPOINTA(&val, __data); \
}

#define VA_NVA26F_SYNCPOINTA V_NVA26F_SYNCPOINTA

#define P_NVA26F_SYNCPOINTA(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA26F_SYNCPOINTA(nvk_p_ret, args); \
    nv_push_val(push, NVA26F_SYNCPOINTA, nvk_p_ret); \
} while(0)

struct nv_nva26f_SYNCPOINTB {
    uint32_t operation;
    uint32_t wait_switch;
    uint32_t base;
    uint32_t syncpt_index;
    uint32_t base_index;
};

static inline void
__NVA26F_SYNCPOINTB(uint32_t *val_out, struct nv_nva26f_SYNCPOINTB st)
{
    uint32_t val = 0;
    
    assert(st.operation < (1ULL << 2));
    val |= st.operation << 0;
    
    assert(st.wait_switch < (1ULL << 1));
    val |= st.wait_switch << 4;
    
    assert(st.base < (1ULL << 1));
    val |= st.base << 5;
    
    assert(st.syncpt_index < (1ULL << 8));
    val |= st.syncpt_index << 8;
    
    assert(st.base_index < (1ULL << 6));
    val |= st.base_index << 20;
    *val_out = val;
}

#define V_NVA26F_SYNCPOINTB(val, args...) { \
    UNUSED uint32_t OPERATION_WAIT = NVA26F_SYNCPOINTB_OPERATION_WAIT; \
    UNUSED uint32_t OPERATION_INCR = NVA26F_SYNCPOINTB_OPERATION_INCR; \
    UNUSED uint32_t OPERATION_BASE_ADD = NVA26F_SYNCPOINTB_OPERATION_BASE_ADD; \
    UNUSED uint32_t OPERATION_BASE_WRITE = NVA26F_SYNCPOINTB_OPERATION_BASE_WRITE; \
    UNUSED uint32_t WAIT_SWITCH_DIS = NVA26F_SYNCPOINTB_WAIT_SWITCH_DIS; \
    UNUSED uint32_t WAIT_SWITCH_EN = NVA26F_SYNCPOINTB_WAIT_SWITCH_EN; \
    UNUSED uint32_t BASE_DIS = NVA26F_SYNCPOINTB_BASE_DIS; \
    UNUSED uint32_t BASE_EN = NVA26F_SYNCPOINTB_BASE_EN; \
    struct nv_nva26f_SYNCPOINTB __data = args; \
    __NVA26F_SYNCPOINTB(&val, __data); \
}

#define VA_NVA26F_SYNCPOINTB V_NVA26F_SYNCPOINTB

#define P_NVA26F_SYNCPOINTB(push, args...) do { \
    UNUSED uint32_t OPERATION_WAIT = NVA26F_SYNCPOINTB_OPERATION_WAIT; \
    UNUSED uint32_t OPERATION_INCR = NVA26F_SYNCPOINTB_OPERATION_INCR; \
    UNUSED uint32_t OPERATION_BASE_ADD = NVA26F_SYNCPOINTB_OPERATION_BASE_ADD; \
    UNUSED uint32_t OPERATION_BASE_WRITE = NVA26F_SYNCPOINTB_OPERATION_BASE_WRITE; \
    UNUSED uint32_t WAIT_SWITCH_DIS = NVA26F_SYNCPOINTB_WAIT_SWITCH_DIS; \
    UNUSED uint32_t WAIT_SWITCH_EN = NVA26F_SYNCPOINTB_WAIT_SWITCH_EN; \
    UNUSED uint32_t BASE_DIS = NVA26F_SYNCPOINTB_BASE_DIS; \
    UNUSED uint32_t BASE_EN = NVA26F_SYNCPOINTB_BASE_EN; \
    uint32_t nvk_p_ret; \
    V_NVA26F_SYNCPOINTB(nvk_p_ret, args); \
    nv_push_val(push, NVA26F_SYNCPOINTB, nvk_p_ret); \
} while(0)

struct nv_nva26f_WFI {
    uint32_t handle;
};

static inline void
__NVA26F_WFI(uint32_t *val_out, struct nv_nva26f_WFI st)
{
    uint32_t val = 0;
    
    val |= st.handle;
    *val_out = val;
}

#define V_NVA26F_WFI(val, args...) { \
    struct nv_nva26f_WFI __data = { .handle = (args) }; \
    __NVA26F_WFI(&val, __data); \
}

#define VA_NVA26F_WFI V_NVA26F_WFI

#define P_NVA26F_WFI(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA26F_WFI(nvk_p_ret, args); \
    nv_push_val(push, NVA26F_WFI, nvk_p_ret); \
} while(0)

struct nv_nva26f_CRC_CHECK {
    uint32_t value;
};

static inline void
__NVA26F_CRC_CHECK(uint32_t *val_out, struct nv_nva26f_CRC_CHECK st)
{
    uint32_t val = 0;
    
    val |= st.value;
    *val_out = val;
}

#define V_NVA26F_CRC_CHECK(val, args...) { \
    struct nv_nva26f_CRC_CHECK __data = { .value = (args) }; \
    __NVA26F_CRC_CHECK(&val, __data); \
}

#define VA_NVA26F_CRC_CHECK V_NVA26F_CRC_CHECK

#define P_NVA26F_CRC_CHECK(push, args...) do { \
    uint32_t nvk_p_ret; \
    V_NVA26F_CRC_CHECK(nvk_p_ret, args); \
    nv_push_val(push, NVA26F_CRC_CHECK, nvk_p_ret); \
} while(0)

struct nv_nva26f_YIELD {
    uint32_t op;
};

static inline void
__NVA26F_YIELD(uint32_t *val_out, struct nv_nva26f_YIELD st)
{
    uint32_t val = 0;
    
    assert(st.op < (1ULL << 2));
    val |= st.op << 0;
    *val_out = val;
}

#define V_NVA26F_YIELD(val, args...) { \
    UNUSED uint32_t OP_NOP = NVA26F_YIELD_OP_NOP; \
    struct nv_nva26f_YIELD __data = { .op = (args) }; \
    __NVA26F_YIELD(&val, __data); \
}

#define VA_NVA26F_YIELD V_NVA26F_YIELD

#define P_NVA26F_YIELD(push, args...) do { \
    UNUSED uint32_t OP_NOP = NVA26F_YIELD_OP_NOP; \
    uint32_t nvk_p_ret; \
    V_NVA26F_YIELD(nvk_p_ret, args); \
    nv_push_val(push, NVA26F_YIELD, nvk_p_ret); \
} while(0)


const char *P_PARSE_NVA26F_MTHD(uint16_t idx) ATTRIBUTE_COLD;
void P_DUMP_NVA26F_MTHD_DATA(FILE *fp, uint16_t idx, uint32_t data,
                              const char *prefix) ATTRIBUTE_COLD;
