/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Global Instruction Selector for the PPC target                             *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_GLOBALISEL_PREDICATE_BITSET
const unsigned MAX_SUBTARGET_PREDICATES = 41;
using PredicateBitset = llvm::Bitset<MAX_SUBTARGET_PREDICATES>;
#endif // ifdef GET_GLOBALISEL_PREDICATE_BITSET

#ifdef GET_GLOBALISEL_TEMPORARIES_DECL
  mutable MatcherState State;
  typedef ComplexRendererFns(PPCInstructionSelector::*ComplexMatcherMemFn)(MachineOperand &) const;
  typedef void(PPCInstructionSelector::*CustomRendererFn)(MachineInstrBuilder &, const MachineInstr &, int) const;
  const ExecInfoTy<PredicateBitset, ComplexMatcherMemFn, CustomRendererFn> ExecInfo;
  static PPCInstructionSelector::ComplexMatcherMemFn ComplexPredicateFns[];
  static PPCInstructionSelector::CustomRendererFn CustomRenderers[];
  bool testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const override;
  bool testImmPredicate_APInt(unsigned PredicateID, const APInt &Imm) const override;
  bool testImmPredicate_APFloat(unsigned PredicateID, const APFloat &Imm) const override;
  const uint8_t *getMatchTable() const override;
  bool testMIPredicate_MI(unsigned PredicateID, const MachineInstr &MI, const MatcherState &State) const override;
  bool testSimplePredicate(unsigned PredicateID) const override;
  bool runCustomAction(unsigned FnID, const MatcherState &State, NewMIVector &OutMIs) const override;
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_DECL

#ifdef GET_GLOBALISEL_TEMPORARIES_INIT
, State(0),
ExecInfo(TypeObjects, NumTypeObjects, FeatureBitsets, ComplexPredicateFns, CustomRenderers)
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_INIT

#ifdef GET_GLOBALISEL_IMPL
// LLT Objects.
enum {
  GILLT_s1,
  GILLT_s32,
  GILLT_s64,
  GILLT_s128,
  GILLT_v2s64,
  GILLT_v4s32,
  GILLT_v8s16,
  GILLT_v16s8,
  GILLT_v256s1,
  GILLT_v512s1,
};
const static size_t NumTypeObjects = 10;
const static LLT TypeObjects[] = {
  LLT::scalar(1),
  LLT::scalar(32),
  LLT::scalar(64),
  LLT::scalar(128),
  LLT::vector(ElementCount::getFixed(2), 64),
  LLT::vector(ElementCount::getFixed(4), 32),
  LLT::vector(ElementCount::getFixed(8), 16),
  LLT::vector(ElementCount::getFixed(16), 8),
  LLT::vector(ElementCount::getFixed(256), 1),
  LLT::vector(ElementCount::getFixed(512), 1),
};

// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
  Feature_In32BitModeBit = 1,
  Feature_In64BitModeBit = 9,
  Feature_HasOnlyMSYNCBit = 23,
  Feature_HasSYNCBit = 22,
  Feature_HasSPEBit = 8,
  Feature_HasICBTBit = 21,
  Feature_HasBPERMDBit = 10,
  Feature_HasExtDivBit = 3,
  Feature_IsISA2_06Bit = 11,
  Feature_IsISA2_07Bit = 40,
  Feature_IsISA3_0Bit = 2,
  Feature_HasFPUBit = 0,
  Feature_PCRelativeMemopsBit = 37,
  Feature_IsNotISA3_1Bit = 39,
  Feature_IsAIXBit = 24,
  Feature_NotAIXBit = 25,
  Feature_IsISAFutureBit = 20,
  Feature_IsNotISAFutureBit = 18,
  Feature_HasAltivecBit = 4,
  Feature_HasP8AltivecBit = 5,
  Feature_HasP8CryptoBit = 6,
  Feature_HasP9AltivecBit = 7,
  Feature_HasVSXBit = 12,
  Feature_IsLittleEndianBit = 26,
  Feature_IsBigEndianBit = 27,
  Feature_IsPPC64Bit = 31,
  Feature_HasOnlySwappingMemOpsBit = 29,
  Feature_NoP8VectorBit = 30,
  Feature_HasP8VectorBit = 13,
  Feature_HasDirectMoveBit = 14,
  Feature_NoP9VectorBit = 28,
  Feature_HasP9VectorBit = 15,
  Feature_NoP9AltivecBit = 32,
  Feature_NoP10VectorBit = 33,
  Feature_HasP10VectorBit = 36,
  Feature_HasHTMBit = 34,
  Feature_IsPPC32Bit = 38,
  Feature_PrefixInstrsBit = 16,
  Feature_IsISA3_1Bit = 17,
  Feature_PairedVectorMemopsBit = 35,
  Feature_MMABit = 19,
};

PredicateBitset PPCInstructionSelector::
computeAvailableModuleFeatures(const PPCSubtarget *Subtarget) const {
  PredicateBitset Features{};
  if (!Subtarget->isPPC64())
    Features.set(Feature_In32BitModeBit);
  if (Subtarget->isPPC64())
    Features.set(Feature_In64BitModeBit);
  if (Subtarget->hasOnlyMSYNC())
    Features.set(Feature_HasOnlyMSYNCBit);
  if (!Subtarget->hasOnlyMSYNC())
    Features.set(Feature_HasSYNCBit);
  if (Subtarget->hasSPE())
    Features.set(Feature_HasSPEBit);
  if (Subtarget->hasICBT())
    Features.set(Feature_HasICBTBit);
  if (Subtarget->hasBPERMD())
    Features.set(Feature_HasBPERMDBit);
  if (Subtarget->hasExtDiv())
    Features.set(Feature_HasExtDivBit);
  if (Subtarget->isISA2_06())
    Features.set(Feature_IsISA2_06Bit);
  if (Subtarget->isISA2_07())
    Features.set(Feature_IsISA2_07Bit);
  if (Subtarget->isISA3_0())
    Features.set(Feature_IsISA3_0Bit);
  if (Subtarget->hasFPU())
    Features.set(Feature_HasFPUBit);
  if (Subtarget->hasPCRelativeMemops())
    Features.set(Feature_PCRelativeMemopsBit);
  if (!Subtarget->isISA3_1())
    Features.set(Feature_IsNotISA3_1Bit);
  if (Subtarget->isAIXABI())
    Features.set(Feature_IsAIXBit);
  if (!Subtarget->isAIXABI())
    Features.set(Feature_NotAIXBit);
  if (Subtarget->isISAFuture())
    Features.set(Feature_IsISAFutureBit);
  if (!Subtarget->isISAFuture())
    Features.set(Feature_IsNotISAFutureBit);
  if (Subtarget->hasAltivec())
    Features.set(Feature_HasAltivecBit);
  if (Subtarget->hasP8Altivec())
    Features.set(Feature_HasP8AltivecBit);
  if (Subtarget->hasP8Crypto())
    Features.set(Feature_HasP8CryptoBit);
  if (Subtarget->hasP9Altivec())
    Features.set(Feature_HasP9AltivecBit);
  if (Subtarget->hasVSX())
    Features.set(Feature_HasVSXBit);
  if (Subtarget->isLittleEndian())
    Features.set(Feature_IsLittleEndianBit);
  if (!Subtarget->isLittleEndian())
    Features.set(Feature_IsBigEndianBit);
  if (Subtarget->isPPC64())
    Features.set(Feature_IsPPC64Bit);
  if (!Subtarget->hasP9Vector())
    Features.set(Feature_HasOnlySwappingMemOpsBit);
  if (!Subtarget->hasP8Vector())
    Features.set(Feature_NoP8VectorBit);
  if (Subtarget->hasP8Vector())
    Features.set(Feature_HasP8VectorBit);
  if (Subtarget->hasDirectMove())
    Features.set(Feature_HasDirectMoveBit);
  if (!Subtarget->hasP9Vector())
    Features.set(Feature_NoP9VectorBit);
  if (Subtarget->hasP9Vector())
    Features.set(Feature_HasP9VectorBit);
  if (!Subtarget->hasP9Altivec())
    Features.set(Feature_NoP9AltivecBit);
  if (!Subtarget->hasP10Vector())
    Features.set(Feature_NoP10VectorBit);
  if (Subtarget->hasP10Vector())
    Features.set(Feature_HasP10VectorBit);
  if (Subtarget->hasHTM())
    Features.set(Feature_HasHTMBit);
  if (!Subtarget->isPPC64())
    Features.set(Feature_IsPPC32Bit);
  if (Subtarget->hasPrefixInstrs())
    Features.set(Feature_PrefixInstrsBit);
  if (Subtarget->isISA3_1())
    Features.set(Feature_IsISA3_1Bit);
  if (Subtarget->pairedVectorMemops())
    Features.set(Feature_PairedVectorMemopsBit);
  if (Subtarget->hasMMA())
    Features.set(Feature_MMABit);
  return Features;
}

void PPCInstructionSelector::setupGeneratedPerFunctionState(MachineFunction &MF) {
  AvailableFunctionFeatures = computeAvailableFunctionFeatures((const PPCSubtarget *)&MF.getSubtarget(), &MF);
}
PredicateBitset PPCInstructionSelector::
computeAvailableFunctionFeatures(const PPCSubtarget *Subtarget, const MachineFunction *MF) const {
  PredicateBitset Features{};
  return Features;
}

// Feature bitsets.
enum {
  GIFBS_Invalid,
  GIFBS_HasAltivec,
  GIFBS_HasBPERMD,
  GIFBS_HasExtDiv,
  GIFBS_HasFPU,
  GIFBS_HasHTM,
  GIFBS_HasOnlyMSYNC,
  GIFBS_HasP8Altivec,
  GIFBS_HasP8Crypto,
  GIFBS_HasP9Altivec,
  GIFBS_HasSPE,
  GIFBS_HasSYNC,
  GIFBS_HasVSX,
  GIFBS_In32BitMode,
  GIFBS_In64BitMode,
  GIFBS_IsAIX,
  GIFBS_IsISA3_0,
  GIFBS_IsISA3_1,
  GIFBS_IsNotISA3_1,
  GIFBS_NotAIX,
  GIFBS_HasDirectMove_HasVSX,
  GIFBS_HasFPU_IsISA3_1,
  GIFBS_HasP10Vector_PrefixInstrs,
  GIFBS_HasP8Altivec_HasVSX,
  GIFBS_HasP8Vector_HasVSX,
  GIFBS_HasP9Vector_HasVSX,
  GIFBS_HasVSX_IsISA3_1,
  GIFBS_In64BitMode_IsISA3_0,
  GIFBS_IsISAFuture_MMA,
  GIFBS_IsNotISAFuture_MMA,
  GIFBS_HasP8Altivec_HasVSX_IsBigEndian,
  GIFBS_HasP8Altivec_HasVSX_IsLittleEndian,
  GIFBS_IsISAFuture_MMA_PrefixInstrs,
  GIFBS_IsNotISAFuture_MMA_PrefixInstrs,
  GIFBS_HasDirectMove_HasVSX_IsISA3_0_IsLittleEndian,
  GIFBS_HasDirectMove_HasVSX_IsLittleEndian_NoP9Vector,
  GIFBS_HasVSX_IsBigEndian_IsISA3_1_IsPPC32,
  GIFBS_HasDirectMove_HasVSX_IsBigEndian_IsISA3_0_IsPPC64,
  GIFBS_HasDirectMove_HasVSX_IsBigEndian_IsPPC64_NoP9Vector,
};
constexpr static PredicateBitset FeatureBitsets[] {
  {}, // GIFBS_Invalid
  {Feature_HasAltivecBit, },
  {Feature_HasBPERMDBit, },
  {Feature_HasExtDivBit, },
  {Feature_HasFPUBit, },
  {Feature_HasHTMBit, },
  {Feature_HasOnlyMSYNCBit, },
  {Feature_HasP8AltivecBit, },
  {Feature_HasP8CryptoBit, },
  {Feature_HasP9AltivecBit, },
  {Feature_HasSPEBit, },
  {Feature_HasSYNCBit, },
  {Feature_HasVSXBit, },
  {Feature_In32BitModeBit, },
  {Feature_In64BitModeBit, },
  {Feature_IsAIXBit, },
  {Feature_IsISA3_0Bit, },
  {Feature_IsISA3_1Bit, },
  {Feature_IsNotISA3_1Bit, },
  {Feature_NotAIXBit, },
  {Feature_HasDirectMoveBit, Feature_HasVSXBit, },
  {Feature_HasFPUBit, Feature_IsISA3_1Bit, },
  {Feature_HasP10VectorBit, Feature_PrefixInstrsBit, },
  {Feature_HasP8AltivecBit, Feature_HasVSXBit, },
  {Feature_HasP8VectorBit, Feature_HasVSXBit, },
  {Feature_HasP9VectorBit, Feature_HasVSXBit, },
  {Feature_HasVSXBit, Feature_IsISA3_1Bit, },
  {Feature_In64BitModeBit, Feature_IsISA3_0Bit, },
  {Feature_IsISAFutureBit, Feature_MMABit, },
  {Feature_IsNotISAFutureBit, Feature_MMABit, },
  {Feature_HasP8AltivecBit, Feature_HasVSXBit, Feature_IsBigEndianBit, },
  {Feature_HasP8AltivecBit, Feature_HasVSXBit, Feature_IsLittleEndianBit, },
  {Feature_IsISAFutureBit, Feature_MMABit, Feature_PrefixInstrsBit, },
  {Feature_IsNotISAFutureBit, Feature_MMABit, Feature_PrefixInstrsBit, },
  {Feature_HasDirectMoveBit, Feature_HasVSXBit, Feature_IsISA3_0Bit, Feature_IsLittleEndianBit, },
  {Feature_HasDirectMoveBit, Feature_HasVSXBit, Feature_IsLittleEndianBit, Feature_NoP9VectorBit, },
  {Feature_HasVSXBit, Feature_IsBigEndianBit, Feature_IsISA3_1Bit, Feature_IsPPC32Bit, },
  {Feature_HasDirectMoveBit, Feature_HasVSXBit, Feature_IsBigEndianBit, Feature_IsISA3_0Bit, Feature_IsPPC64Bit, },
  {Feature_HasDirectMoveBit, Feature_HasVSXBit, Feature_IsBigEndianBit, Feature_IsPPC64Bit, Feature_NoP9VectorBit, },
};

// ComplexPattern predicates.
enum {
  GICP_Invalid,
};
// See constructor for table contents

PPCInstructionSelector::ComplexMatcherMemFn
PPCInstructionSelector::ComplexPredicateFns[] = {
  nullptr, // GICP_Invalid
};

// PatFrag predicates.
bool PPCInstructionSelector::testMIPredicate_MI(unsigned PredicateID, const MachineInstr & MI, const MatcherState &State) const {
  const MachineFunction &MF = *MI.getParent()->getParent();
  const MachineRegisterInfo &MRI = MF.getRegInfo();
  const auto &Operands = State.RecordedOperands;
  (void)Operands;
  (void)MRI;
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_I64_Predicate_Msk2Imm = GICXXPred_Invalid + 1,
  GICXXPred_I64_Predicate_Msk4Imm,
  GICXXPred_I64_Predicate_Msk8Imm,
  GICXXPred_I64_Predicate_i32immNonAllOneNonZero,
  GICXXPred_I64_Predicate_imm32SExt16,
  GICXXPred_I64_Predicate_imm64SExt16,
  GICXXPred_I64_Predicate_imm64ZExt32,
  GICXXPred_I64_Predicate_immNonAllOneAnyExt8,
  GICXXPred_I64_Predicate_immSExt5NonZero,
};
bool PPCInstructionSelector::testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const {
  switch (PredicateID) {
  case GICXXPred_I64_Predicate_Msk2Imm: {
     return isUInt<2>(Imm); 
  }
  case GICXXPred_I64_Predicate_Msk4Imm: {
     return isUInt<4>(Imm); 
  }
  case GICXXPred_I64_Predicate_Msk8Imm: {
     return isUInt<8>(Imm); 
  }
  case GICXXPred_I64_Predicate_i32immNonAllOneNonZero: {
     return Imm && (Imm != -1); 
  }
  case GICXXPred_I64_Predicate_imm32SExt16: {
    
      // imm32SExt16 predicate - True if the i32 immediate fits in a 16-bit
      // sign extended field.  Used by instructions like 'addi'.
      return (int32_t)Imm == (short)Imm;
    
    llvm_unreachable("imm32SExt16 should have returned");
  }
  case GICXXPred_I64_Predicate_imm64SExt16: {
    
      // imm64SExt16 predicate - True if the i64 immediate fits in a 16-bit
      // sign extended field.  Used by instructions like 'addi'.
      return (int64_t)Imm == (short)Imm;
    
    llvm_unreachable("imm64SExt16 should have returned");
  }
  case GICXXPred_I64_Predicate_imm64ZExt32: {
    
      // imm64ZExt32 predicate - True if the i64 immediate fits in a 32-bit
      // zero extended field.
      return isUInt<32>(Imm);
    
    llvm_unreachable("imm64ZExt32 should have returned");
  }
  case GICXXPred_I64_Predicate_immNonAllOneAnyExt8: {
    
      return (isInt<8>(Imm) && (Imm != -1)) || (isUInt<8>(Imm) && (Imm != 0xFF));
    
  }
  case GICXXPred_I64_Predicate_immSExt5NonZero: {
     return Imm && isInt<5>(Imm); 
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
bool PPCInstructionSelector::testImmPredicate_APFloat(unsigned PredicateID, const APFloat & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
bool PPCInstructionSelector::testImmPredicate_APInt(unsigned PredicateID, const APInt & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
bool PPCInstructionSelector::testSimplePredicate(unsigned) const {
    llvm_unreachable("PPCInstructionSelector does not support simple predicates!");
  return false;
}
// Custom renderers.
enum {
  GICR_Invalid,
};
PPCInstructionSelector::CustomRendererFn
PPCInstructionSelector::CustomRenderers[] = {
  nullptr, // GICR_Invalid
};

bool PPCInstructionSelector::selectImpl(MachineInstr &I, CodeGenCoverage &CoverageInfo) const {
  const PredicateBitset AvailableFeatures = getAvailableFeatures();
  MachineIRBuilder B(I);
  State.MIs.clear();
  State.MIs.push_back(&I);

  if (executeMatchTable(*this, State, ExecInfo, B, getMatchTable(), TII, MF->getRegInfo(), TRI, RBI, AvailableFeatures, &CoverageInfo)) {
    return true;
  }

  return false;
}

bool PPCInstructionSelector::runCustomAction(unsigned, const MatcherState&, NewMIVector &) const {
    llvm_unreachable("PPCInstructionSelector does not support custom C++ actions!");
}
#if __BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__
#define GIMT_Encode2(Val) uint8_t(Val), uint8_t((uint16_t)Val >> 8)
#define GIMT_Encode4(Val) uint8_t(Val), uint8_t((uint32_t)Val >> 8), uint8_t((uint32_t)Val >> 16), uint8_t((uint32_t)Val >> 24)
#define GIMT_Encode8(Val) uint8_t(Val), uint8_t((uint64_t)Val >> 8), uint8_t((uint64_t)Val >> 16), uint8_t((uint64_t)Val >> 24),  uint8_t((uint64_t)Val >> 32), uint8_t((uint64_t)Val >> 40), uint8_t((uint64_t)Val >> 48), uint8_t((uint64_t)Val >> 56)
#else
#define GIMT_Encode2(Val) uint8_t((uint16_t)Val >> 8), uint8_t(Val)
#define GIMT_Encode4(Val) uint8_t((uint32_t)Val >> 24), uint8_t((uint32_t)Val >> 16), uint8_t((uint32_t)Val >> 8), uint8_t(Val)
#define GIMT_Encode8(Val) uint8_t((uint64_t)Val >> 56), uint8_t((uint64_t)Val >> 48), uint8_t((uint64_t)Val >> 40), uint8_t((uint64_t)Val >> 32),  uint8_t((uint64_t)Val >> 24), uint8_t((uint64_t)Val >> 16), uint8_t((uint64_t)Val >> 8), uint8_t(Val)
#endif
const uint8_t *PPCInstructionSelector::getMatchTable() const {
  constexpr static uint8_t MatchTable0[] = {
    GIM_SwitchOpcode, /*MI*/0, /*[*/GIMT_Encode2(53), GIMT_Encode2(285), /*)*//*default:*//*Label 83*/ GIMT_Encode4(208634),
    /*TargetOpcode::G_ADD*//*Label 0*/ GIMT_Encode4(938),
    /*TargetOpcode::G_SUB*//*Label 1*/ GIMT_Encode4(1347),
    /*TargetOpcode::G_MUL*//*Label 2*/ GIMT_Encode4(1788),
    /*TargetOpcode::G_SDIV*//*Label 3*/ GIMT_Encode4(2070),
    /*TargetOpcode::G_UDIV*//*Label 4*/ GIMT_Encode4(2226),
    /*TargetOpcode::G_SREM*//*Label 5*/ GIMT_Encode4(2382),
    /*TargetOpcode::G_UREM*//*Label 6*/ GIMT_Encode4(2544), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_AND*//*Label 7*/ GIMT_Encode4(2706),
    /*TargetOpcode::G_OR*//*Label 8*/ GIMT_Encode4(5267),
    /*TargetOpcode::G_XOR*//*Label 9*/ GIMT_Encode4(48409), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_BUILD_VECTOR*//*Label 10*/ GIMT_Encode4(57516), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_BITCAST*//*Label 11*/ GIMT_Encode4(58483), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_INTRINSIC_TRUNC*//*Label 12*/ GIMT_Encode4(60760),
    /*TargetOpcode::G_INTRINSIC_ROUND*//*Label 13*/ GIMT_Encode4(61035),
    /*TargetOpcode::G_INTRINSIC_LRINT*//*Label 14*/ GIMT_Encode4(61285),
    /*TargetOpcode::G_INTRINSIC_LLRINT*//*Label 15*/ GIMT_Encode4(61416), GIMT_Encode4(0),
    /*TargetOpcode::G_READCYCLECOUNTER*//*Label 16*/ GIMT_Encode4(61547), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FENCE*//*Label 17*/ GIMT_Encode4(61567), GIMT_Encode4(0),
    /*TargetOpcode::G_BRCOND*//*Label 18*/ GIMT_Encode4(61692), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_INTRINSIC*//*Label 19*/ GIMT_Encode4(61755),
    /*TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS*//*Label 20*/ GIMT_Encode4(88360), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_ANYEXT*//*Label 21*/ GIMT_Encode4(91252),
    /*TargetOpcode::G_TRUNC*//*Label 22*/ GIMT_Encode4(112008),
    /*TargetOpcode::G_CONSTANT*//*Label 23*/ GIMT_Encode4(112194), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_SEXT*//*Label 24*/ GIMT_Encode4(112346),
    /*TargetOpcode::G_SEXT_INREG*//*Label 25*/ GIMT_Encode4(127378),
    /*TargetOpcode::G_ZEXT*//*Label 26*/ GIMT_Encode4(127731),
    /*TargetOpcode::G_SHL*//*Label 27*/ GIMT_Encode4(149201),
    /*TargetOpcode::G_LSHR*//*Label 28*/ GIMT_Encode4(149557),
    /*TargetOpcode::G_ASHR*//*Label 29*/ GIMT_Encode4(149979), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_ROTL*//*Label 30*/ GIMT_Encode4(150349),
    /*TargetOpcode::G_ICMP*//*Label 31*/ GIMT_Encode4(150657),
    /*TargetOpcode::G_FCMP*//*Label 32*/ GIMT_Encode4(154659), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_SELECT*//*Label 33*/ GIMT_Encode4(158110), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_UMULH*//*Label 34*/ GIMT_Encode4(159234),
    /*TargetOpcode::G_SMULH*//*Label 35*/ GIMT_Encode4(159364),
    /*TargetOpcode::G_UADDSAT*//*Label 36*/ GIMT_Encode4(159494),
    /*TargetOpcode::G_SADDSAT*//*Label 37*/ GIMT_Encode4(159596),
    /*TargetOpcode::G_USUBSAT*//*Label 38*/ GIMT_Encode4(159698),
    /*TargetOpcode::G_SSUBSAT*//*Label 39*/ GIMT_Encode4(159800), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FADD*//*Label 40*/ GIMT_Encode4(159902),
    /*TargetOpcode::G_FSUB*//*Label 41*/ GIMT_Encode4(160197),
    /*TargetOpcode::G_FMUL*//*Label 42*/ GIMT_Encode4(160492),
    /*TargetOpcode::G_FMA*//*Label 43*/ GIMT_Encode4(160842), GIMT_Encode4(0),
    /*TargetOpcode::G_FDIV*//*Label 44*/ GIMT_Encode4(161423), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FNEG*//*Label 45*/ GIMT_Encode4(161693),
    /*TargetOpcode::G_FPEXT*//*Label 46*/ GIMT_Encode4(164164),
    /*TargetOpcode::G_FPTRUNC*//*Label 47*/ GIMT_Encode4(164328),
    /*TargetOpcode::G_FPTOSI*//*Label 48*/ GIMT_Encode4(164485),
    /*TargetOpcode::G_FPTOUI*//*Label 49*/ GIMT_Encode4(164748),
    /*TargetOpcode::G_SITOFP*//*Label 50*/ GIMT_Encode4(165011),
    /*TargetOpcode::G_UITOFP*//*Label 51*/ GIMT_Encode4(165258), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FABS*//*Label 52*/ GIMT_Encode4(165505),
    /*TargetOpcode::G_FCOPYSIGN*//*Label 53*/ GIMT_Encode4(165797), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FMINNUM*//*Label 54*/ GIMT_Encode4(166113),
    /*TargetOpcode::G_FMAXNUM*//*Label 55*/ GIMT_Encode4(166193),
    /*TargetOpcode::G_FMINNUM_IEEE*//*Label 56*/ GIMT_Encode4(166273),
    /*TargetOpcode::G_FMAXNUM_IEEE*//*Label 57*/ GIMT_Encode4(166855), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_SMIN*//*Label 58*/ GIMT_Encode4(167437),
    /*TargetOpcode::G_SMAX*//*Label 59*/ GIMT_Encode4(167617),
    /*TargetOpcode::G_UMIN*//*Label 60*/ GIMT_Encode4(167797),
    /*TargetOpcode::G_UMAX*//*Label 61*/ GIMT_Encode4(167977), GIMT_Encode4(0),
    /*TargetOpcode::G_LROUND*//*Label 62*/ GIMT_Encode4(168157),
    /*TargetOpcode::G_LLROUND*//*Label 63*/ GIMT_Encode4(168459),
    /*TargetOpcode::G_BR*//*Label 64*/ GIMT_Encode4(168624), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_INSERT_VECTOR_ELT*//*Label 65*/ GIMT_Encode4(168640), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_CTTZ*//*Label 66*/ GIMT_Encode4(168758), GIMT_Encode4(0),
    /*TargetOpcode::G_CTLZ*//*Label 67*/ GIMT_Encode4(168936), GIMT_Encode4(0),
    /*TargetOpcode::G_CTPOP*//*Label 68*/ GIMT_Encode4(169108),
    /*TargetOpcode::G_BSWAP*//*Label 69*/ GIMT_Encode4(169280),
    /*TargetOpcode::G_BITREVERSE*//*Label 70*/ GIMT_Encode4(169544),
    /*TargetOpcode::G_FCEIL*//*Label 71*/ GIMT_Encode4(205550), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FSQRT*//*Label 72*/ GIMT_Encode4(205825),
    /*TargetOpcode::G_FFLOOR*//*Label 73*/ GIMT_Encode4(206042),
    /*TargetOpcode::G_FRINT*//*Label 74*/ GIMT_Encode4(206317),
    /*TargetOpcode::G_FNEARBYINT*//*Label 75*/ GIMT_Encode4(206529), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_STRICT_FADD*//*Label 76*/ GIMT_Encode4(206766),
    /*TargetOpcode::G_STRICT_FSUB*//*Label 77*/ GIMT_Encode4(207036),
    /*TargetOpcode::G_STRICT_FMUL*//*Label 78*/ GIMT_Encode4(207306),
    /*TargetOpcode::G_STRICT_FDIV*//*Label 79*/ GIMT_Encode4(207576), GIMT_Encode4(0),
    /*TargetOpcode::G_STRICT_FMA*//*Label 80*/ GIMT_Encode4(207846),
    /*TargetOpcode::G_STRICT_FSQRT*//*Label 81*/ GIMT_Encode4(208404), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_TRAP*//*Label 82*/ GIMT_Encode4(208621),
    // Label 0: @938
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(0), GIMT_Encode2(8), /*)*//*default:*//*Label 92*/ GIMT_Encode4(1346),
    /*GILLT_s1*//*Label 84*/ GIMT_Encode4(981),
    /*GILLT_s32*//*Label 85*/ GIMT_Encode4(1004),
    /*GILLT_s64*//*Label 86*/ GIMT_Encode4(1064),
    /*GILLT_s128*//*Label 87*/ GIMT_Encode4(1124),
    /*GILLT_v2s64*//*Label 88*/ GIMT_Encode4(1150),
    /*GILLT_v4s32*//*Label 89*/ GIMT_Encode4(1176),
    /*GILLT_v8s16*//*Label 90*/ GIMT_Encode4(1202),
    /*GILLT_v16s8*//*Label 91*/ GIMT_Encode4(1320),
    // Label 84: @981
    GIM_Try, /*On fail goto*//*Label 93*/ GIMT_Encode4(1003), // Rule ID 3628 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::CRBITRCRegClassID),
      // (add:{ *:[i1] } i1:{ *:[i1] }:$a, i1:{ *:[i1] }:$b)  =>  (CRXOR:{ *:[i1] } ?:{ *:[i1] }:$a, ?:{ *:[i1] }:$b)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::CRXOR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 3628,
      GIR_Done,
    // Label 93: @1003
    GIM_Reject,
    // Label 85: @1004
    GIM_Try, /*On fail goto*//*Label 94*/ GIMT_Encode4(1063),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
      GIM_Try, /*On fail goto*//*Label 95*/ GIMT_Encode4(1050), // Rule ID 107 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm32SExt16),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } i32:{ *:[i32] }:$RA, (imm:{ *:[i32] })<<P:Predicate_imm32SExt16>>:$D)  =>  (ADDI:{ *:[i32] } i32:{ *:[i32] }:$RA, (imm:{ *:[i32] }):$D)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::ADDI),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RST]
        GIR_RootToRootCopy, /*OpIdx*/1, // RA
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // D
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 107,
        GIR_EraseRootFromParent_Done,
      // Label 95: @1050
      GIM_Try, /*On fail goto*//*Label 96*/ GIMT_Encode4(1062), // Rule ID 199 //
        // (add:{ *:[i32] } i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)  =>  (ADD4:{ *:[i32] } i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::ADD4),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 199,
        GIR_Done,
      // Label 96: @1062
      GIM_Reject,
    // Label 94: @1063
    GIM_Reject,
    // Label 86: @1064
    GIM_Try, /*On fail goto*//*Label 97*/ GIMT_Encode4(1123),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
      GIM_Try, /*On fail goto*//*Label 98*/ GIMT_Encode4(1110), // Rule ID 659 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm64SExt16),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } i64:{ *:[i64] }:$RA, (imm:{ *:[i64] })<<P:Predicate_imm64SExt16>>:$D)  =>  (ADDI8:{ *:[i64] } i64:{ *:[i64] }:$RA, (imm:{ *:[i64] }):$D)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::ADDI8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RST]
        GIR_RootToRootCopy, /*OpIdx*/1, // RA
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // D
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 659,
        GIR_EraseRootFromParent_Done,
      // Label 98: @1110
      GIM_Try, /*On fail goto*//*Label 99*/ GIMT_Encode4(1122), // Rule ID 655 //
        // (add:{ *:[i64] } i64:{ *:[i64] }:$RA, i64:{ *:[i64] }:$RB)  =>  (ADD8:{ *:[i64] } i64:{ *:[i64] }:$RA, i64:{ *:[i64] }:$RB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::ADD8),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 655,
        GIR_Done,
      // Label 99: @1122
      GIM_Reject,
    // Label 97: @1123
    GIM_Reject,
    // Label 87: @1124
    GIM_Try, /*On fail goto*//*Label 100*/ GIMT_Encode4(1149), // Rule ID 470 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s128,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s128,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (add:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)  =>  (VADDUQM:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VADDUQM),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 470,
      GIR_Done,
    // Label 100: @1149
    GIM_Reject,
    // Label 88: @1150
    GIM_Try, /*On fail goto*//*Label 101*/ GIMT_Encode4(1175), // Rule ID 469 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (add:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VADDUDM:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VADDUDM),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 469,
      GIR_Done,
    // Label 101: @1175
    GIM_Reject,
    // Label 89: @1176
    GIM_Try, /*On fail goto*//*Label 102*/ GIMT_Encode4(1201), // Rule ID 303 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (add:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VADDUWM:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VADDUWM),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 303,
      GIR_Done,
    // Label 102: @1201
    GIM_Reject,
    // Label 90: @1202
    GIM_Try, /*On fail goto*//*Label 103*/ GIMT_Encode4(1319),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_Try, /*On fail goto*//*Label 104*/ GIMT_Encode4(1260), // Rule ID 1287 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v8i16] } (mul:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB), v8i16:{ *:[v8i16] }:$vC)  =>  (VMLADDUHM:{ *:[v8i16] } ?:{ *:[v8i16] }:$vA, ?:{ *:[v8i16] }:$vB, ?:{ *:[v8i16] }:$vC)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VMLADDUHM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vB
        GIR_RootToRootCopy, /*OpIdx*/2, // vC
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1287,
        GIR_EraseRootFromParent_Done,
      // Label 104: @1260
      GIM_Try, /*On fail goto*//*Label 105*/ GIMT_Encode4(1303), // Rule ID 4899 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$vC, (mul:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB))  =>  (VMLADDUHM:{ *:[v8i16] } ?:{ *:[v8i16] }:$vA, ?:{ *:[v8i16] }:$vB, ?:{ *:[v8i16] }:$vC)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VMLADDUHM),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vB
        GIR_RootToRootCopy, /*OpIdx*/1, // vC
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4899,
        GIR_EraseRootFromParent_Done,
      // Label 105: @1303
      GIM_Try, /*On fail goto*//*Label 106*/ GIMT_Encode4(1318), // Rule ID 302 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        // (add:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VADDUHM:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VADDUHM),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 302,
        GIR_Done,
      // Label 106: @1318
      GIM_Reject,
    // Label 103: @1319
    GIM_Reject,
    // Label 91: @1320
    GIM_Try, /*On fail goto*//*Label 107*/ GIMT_Encode4(1345), // Rule ID 301 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (add:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VADDUBM:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VADDUBM),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 301,
      GIR_Done,
    // Label 107: @1345
    GIM_Reject,
    // Label 92: @1346
    GIM_Reject,
    // Label 1: @1347
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(0), GIMT_Encode2(8), /*)*//*default:*//*Label 116*/ GIMT_Encode4(1787),
    /*GILLT_s1*//*Label 108*/ GIMT_Encode4(1390),
    /*GILLT_s32*//*Label 109*/ GIMT_Encode4(1413),
    /*GILLT_s64*//*Label 110*/ GIMT_Encode4(1498),
    /*GILLT_s128*//*Label 111*/ GIMT_Encode4(1583),
    /*GILLT_v2s64*//*Label 112*/ GIMT_Encode4(1609),
    /*GILLT_v4s32*//*Label 113*/ GIMT_Encode4(1672),
    /*GILLT_v8s16*//*Label 114*/ GIMT_Encode4(1735),
    /*GILLT_v16s8*//*Label 115*/ GIMT_Encode4(1761),
    // Label 108: @1390
    GIM_Try, /*On fail goto*//*Label 117*/ GIMT_Encode4(1412), // Rule ID 3629 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::CRBITRCRegClassID),
      // (sub:{ *:[i1] } i1:{ *:[i1] }:$a, i1:{ *:[i1] }:$b)  =>  (CRXOR:{ *:[i1] } ?:{ *:[i1] }:$a, ?:{ *:[i1] }:$b)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::CRXOR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 3629,
      GIR_Done,
    // Label 117: @1412
    GIM_Reject,
    // Label 109: @1413
    GIM_Try, /*On fail goto*//*Label 118*/ GIMT_Encode4(1497),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
      GIM_Try, /*On fail goto*//*Label 119*/ GIMT_Encode4(1446), // Rule ID 211 //
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
        // (sub:{ *:[i32] } 0:{ *:[i32] }, i32:{ *:[i32] }:$RA)  =>  (NEG:{ *:[i32] } i32:{ *:[i32] }:$RA)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::NEG),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RT]
        GIR_RootToRootCopy, /*OpIdx*/2, // RA
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 211,
        GIR_EraseRootFromParent_Done,
      // Label 119: @1446
      GIM_Try, /*On fail goto*//*Label 120*/ GIMT_Encode4(1480), // Rule ID 1208 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm32SExt16),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_imm32SExt16>>:$imm, i32:{ *:[i32] }:$in)  =>  (SUBFIC:{ *:[i32] }:{ *:[i32] } ?:{ *:[i32] }:$in, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::SUBFIC),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RST]
        GIR_RootToRootCopy, /*OpIdx*/2, // in
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for PPC::CARRY*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1208,
        GIR_EraseRootFromParent_Done,
      // Label 120: @1480
      GIM_Try, /*On fail goto*//*Label 121*/ GIMT_Encode4(1496), // Rule ID 209 //
        // (sub:{ *:[i32] } i32:{ *:[i32] }:$RB, i32:{ *:[i32] }:$RA)  =>  (SUBF:{ *:[i32] } i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::SUBF),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RT]
        GIR_RootToRootCopy, /*OpIdx*/2, // RA
        GIR_RootToRootCopy, /*OpIdx*/1, // RB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 209,
        GIR_EraseRootFromParent_Done,
      // Label 121: @1496
      GIM_Reject,
    // Label 118: @1497
    GIM_Reject,
    // Label 110: @1498
    GIM_Try, /*On fail goto*//*Label 122*/ GIMT_Encode4(1582),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
      GIM_Try, /*On fail goto*//*Label 123*/ GIMT_Encode4(1531), // Rule ID 665 //
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
        // (sub:{ *:[i64] } 0:{ *:[i64] }, i64:{ *:[i64] }:$RA)  =>  (NEG8:{ *:[i64] } i64:{ *:[i64] }:$RA)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::NEG8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RT]
        GIR_RootToRootCopy, /*OpIdx*/2, // RA
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 665,
        GIR_EraseRootFromParent_Done,
      // Label 123: @1531
      GIM_Try, /*On fail goto*//*Label 124*/ GIMT_Encode4(1565), // Rule ID 1530 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm64SExt16),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[i64] } (imm:{ *:[i64] })<<P:Predicate_imm64SExt16>>:$imm, i64:{ *:[i64] }:$in)  =>  (SUBFIC8:{ *:[i64] }:{ *:[i32] } ?:{ *:[i64] }:$in, (imm:{ *:[i64] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::SUBFIC8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RST]
        GIR_RootToRootCopy, /*OpIdx*/2, // in
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for PPC::CARRY*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1530,
        GIR_EraseRootFromParent_Done,
      // Label 124: @1565
      GIM_Try, /*On fail goto*//*Label 125*/ GIMT_Encode4(1581), // Rule ID 664 //
        // (sub:{ *:[i64] } i64:{ *:[i64] }:$RB, i64:{ *:[i64] }:$RA)  =>  (SUBF8:{ *:[i64] } i64:{ *:[i64] }:$RA, i64:{ *:[i64] }:$RB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::SUBF8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RT]
        GIR_RootToRootCopy, /*OpIdx*/2, // RA
        GIR_RootToRootCopy, /*OpIdx*/1, // RB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 664,
        GIR_EraseRootFromParent_Done,
      // Label 125: @1581
      GIM_Reject,
    // Label 122: @1582
    GIM_Reject,
    // Label 111: @1583
    GIM_Try, /*On fail goto*//*Label 126*/ GIMT_Encode4(1608), // Rule ID 475 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s128,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s128,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (sub:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)  =>  (VSUBUQM:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VSUBUQM),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 475,
      GIR_Done,
    // Label 126: @1608
    GIM_Reject,
    // Label 112: @1609
    GIM_Try, /*On fail goto*//*Label 127*/ GIMT_Encode4(1671),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_Try, /*On fail goto*//*Label 128*/ GIMT_Encode4(1655), // Rule ID 542 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Altivec),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllZeros, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[v2i64] } immAllZerosV:{ *:[v2i64] }, v2i64:{ *:[v2i64] }:$VB)  =>  (VNEGD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VNEGD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 542,
        GIR_EraseRootFromParent_Done,
      // Label 128: @1655
      GIM_Try, /*On fail goto*//*Label 129*/ GIMT_Encode4(1670), // Rule ID 474 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
        // (sub:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VSUBUDM:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VSUBUDM),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 474,
        GIR_Done,
      // Label 129: @1670
      GIM_Reject,
    // Label 127: @1671
    GIM_Reject,
    // Label 113: @1672
    GIM_Try, /*On fail goto*//*Label 130*/ GIMT_Encode4(1734),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      GIM_Try, /*On fail goto*//*Label 131*/ GIMT_Encode4(1718), // Rule ID 541 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Altivec),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllZeros, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[v4i32] } immAllZerosV:{ *:[v4i32] }, v4i32:{ *:[v4i32] }:$VB)  =>  (VNEGW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VNEGW),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 541,
        GIR_EraseRootFromParent_Done,
      // Label 131: @1718
      GIM_Try, /*On fail goto*//*Label 132*/ GIMT_Encode4(1733), // Rule ID 373 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        // (sub:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VSUBUWM:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VSUBUWM),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 373,
        GIR_Done,
      // Label 132: @1733
      GIM_Reject,
    // Label 130: @1734
    GIM_Reject,
    // Label 114: @1735
    GIM_Try, /*On fail goto*//*Label 133*/ GIMT_Encode4(1760), // Rule ID 372 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (sub:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VSUBUHM:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VSUBUHM),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 372,
      GIR_Done,
    // Label 133: @1760
    GIM_Reject,
    // Label 115: @1761
    GIM_Try, /*On fail goto*//*Label 134*/ GIMT_Encode4(1786), // Rule ID 371 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (sub:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VSUBUBM:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VSUBUBM),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 371,
      GIR_Done,
    // Label 134: @1786
    GIM_Reject,
    // Label 116: @1787
    GIM_Reject,
    // Label 2: @1788
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(0), GIMT_Encode2(7), /*)*//*default:*//*Label 141*/ GIMT_Encode4(2069),
    /*GILLT_s1*//*Label 135*/ GIMT_Encode4(1827),
    /*GILLT_s32*//*Label 136*/ GIMT_Encode4(1850),
    /*GILLT_s64*//*Label 137*/ GIMT_Encode4(1910), GIMT_Encode4(0),
    /*GILLT_v2s64*//*Label 138*/ GIMT_Encode4(1970),
    /*GILLT_v4s32*//*Label 139*/ GIMT_Encode4(1996),
    /*GILLT_v8s16*//*Label 140*/ GIMT_Encode4(2022),
    // Label 135: @1827
    GIM_Try, /*On fail goto*//*Label 142*/ GIMT_Encode4(1849), // Rule ID 3630 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::CRBITRCRegClassID),
      // (mul:{ *:[i1] } i1:{ *:[i1] }:$a, i1:{ *:[i1] }:$b)  =>  (CRAND:{ *:[i1] } ?:{ *:[i1] }:$a, ?:{ *:[i1] }:$b)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::CRAND),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 3630,
      GIR_Done,
    // Label 142: @1849
    GIM_Reject,
    // Label 136: @1850
    GIM_Try, /*On fail goto*//*Label 143*/ GIMT_Encode4(1909),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
      GIM_Try, /*On fail goto*//*Label 144*/ GIMT_Encode4(1896), // Rule ID 111 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm32SExt16),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (mul:{ *:[i32] } i32:{ *:[i32] }:$RA, (imm:{ *:[i32] })<<P:Predicate_imm32SExt16>>:$D)  =>  (MULLI:{ *:[i32] } i32:{ *:[i32] }:$RA, (imm:{ *:[i32] }):$D)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::MULLI),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RST]
        GIR_RootToRootCopy, /*OpIdx*/1, // RA
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // D
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 111,
        GIR_EraseRootFromParent_Done,
      // Label 144: @1896
      GIM_Try, /*On fail goto*//*Label 145*/ GIMT_Encode4(1908), // Rule ID 208 //
        // (mul:{ *:[i32] } i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)  =>  (MULLW:{ *:[i32] } i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::MULLW),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 208,
        GIR_Done,
      // Label 145: @1908
      GIM_Reject,
    // Label 143: @1909
    GIM_Reject,
    // Label 137: @1910
    GIM_Try, /*On fail goto*//*Label 146*/ GIMT_Encode4(1969),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
      GIM_Try, /*On fail goto*//*Label 147*/ GIMT_Encode4(1956), // Rule ID 702 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm64SExt16),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (mul:{ *:[i64] } i64:{ *:[i64] }:$RA, (imm:{ *:[i64] })<<P:Predicate_imm64SExt16>>:$D)  =>  (MULLI8:{ *:[i64] } i64:{ *:[i64] }:$RA, (imm:{ *:[i64] }):$D)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::MULLI8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RST]
        GIR_RootToRootCopy, /*OpIdx*/1, // RA
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // D
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 702,
        GIR_EraseRootFromParent_Done,
      // Label 147: @1956
      GIM_Try, /*On fail goto*//*Label 148*/ GIMT_Encode4(1968), // Rule ID 701 //
        // (mul:{ *:[i64] } i64:{ *:[i64] }:$RA, i64:{ *:[i64] }:$RB)  =>  (MULLD:{ *:[i64] } i64:{ *:[i64] }:$RA, i64:{ *:[i64] }:$RB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::MULLD),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 701,
        GIR_Done,
      // Label 148: @1968
      GIM_Reject,
    // Label 146: @1969
    GIM_Reject,
    // Label 138: @1970
    GIM_Try, /*On fail goto*//*Label 149*/ GIMT_Encode4(1995), // Rule ID 1120 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (mul:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VMULLD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMULLD),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1120,
      GIR_Done,
    // Label 149: @1995
    GIM_Reject,
    // Label 139: @1996
    GIM_Try, /*On fail goto*//*Label 150*/ GIMT_Encode4(2021), // Rule ID 461 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (mul:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VMULUWM:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMULUWM),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 461,
      GIR_Done,
    // Label 150: @2021
    GIM_Reject,
    // Label 140: @2022
    GIM_Try, /*On fail goto*//*Label 151*/ GIMT_Encode4(2068), // Rule ID 1286 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (mul:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB)  =>  (VMLADDUHM:{ *:[v8i16] } ?:{ *:[v8i16] }:$vA, ?:{ *:[v8i16] }:$vB, (V_SET0H:{ *:[v8i16] }))
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(PPC::V_SET0H),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VMLADDUHM),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RT]
      GIR_RootToRootCopy, /*OpIdx*/1, // vA
      GIR_RootToRootCopy, /*OpIdx*/2, // vB
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1286,
      GIR_EraseRootFromParent_Done,
    // Label 151: @2068
    GIM_Reject,
    // Label 141: @2069
    GIM_Reject,
    // Label 3: @2070
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(6), /*)*//*default:*//*Label 157*/ GIMT_Encode4(2225),
    /*GILLT_s32*//*Label 152*/ GIMT_Encode4(2101),
    /*GILLT_s64*//*Label 153*/ GIMT_Encode4(2124),
    /*GILLT_s128*//*Label 154*/ GIMT_Encode4(2147),
    /*GILLT_v2s64*//*Label 155*/ GIMT_Encode4(2173),
    /*GILLT_v4s32*//*Label 156*/ GIMT_Encode4(2199),
    // Label 152: @2101
    GIM_Try, /*On fail goto*//*Label 158*/ GIMT_Encode4(2123), // Rule ID 202 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
      // (sdiv:{ *:[i32] } i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)  =>  (DIVW:{ *:[i32] } i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::DIVW),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 202,
      GIR_Done,
    // Label 158: @2123
    GIM_Reject,
    // Label 153: @2124
    GIM_Try, /*On fail goto*//*Label 159*/ GIMT_Encode4(2146), // Rule ID 693 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
      // (sdiv:{ *:[i64] } i64:{ *:[i64] }:$RA, i64:{ *:[i64] }:$RB)  =>  (DIVD:{ *:[i64] } i64:{ *:[i64] }:$RA, i64:{ *:[i64] }:$RB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::DIVD),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 693,
      GIR_Done,
    // Label 159: @2146
    GIM_Reject,
    // Label 154: @2147
    GIM_Try, /*On fail goto*//*Label 160*/ GIMT_Encode4(2172), // Rule ID 1144 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s128,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s128,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (sdiv:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)  =>  (VDIVSQ:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VDIVSQ),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1144,
      GIR_Done,
    // Label 160: @2172
    GIM_Reject,
    // Label 155: @2173
    GIM_Try, /*On fail goto*//*Label 161*/ GIMT_Encode4(2198), // Rule ID 1131 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (sdiv:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VDIVSD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VDIVSD),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1131,
      GIR_Done,
    // Label 161: @2198
    GIM_Reject,
    // Label 156: @2199
    GIM_Try, /*On fail goto*//*Label 162*/ GIMT_Encode4(2224), // Rule ID 1129 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (sdiv:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VDIVSW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VDIVSW),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1129,
      GIR_Done,
    // Label 162: @2224
    GIM_Reject,
    // Label 157: @2225
    GIM_Reject,
    // Label 4: @2226
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(6), /*)*//*default:*//*Label 168*/ GIMT_Encode4(2381),
    /*GILLT_s32*//*Label 163*/ GIMT_Encode4(2257),
    /*GILLT_s64*//*Label 164*/ GIMT_Encode4(2280),
    /*GILLT_s128*//*Label 165*/ GIMT_Encode4(2303),
    /*GILLT_v2s64*//*Label 166*/ GIMT_Encode4(2329),
    /*GILLT_v4s32*//*Label 167*/ GIMT_Encode4(2355),
    // Label 163: @2257
    GIM_Try, /*On fail goto*//*Label 169*/ GIMT_Encode4(2279), // Rule ID 203 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
      // (udiv:{ *:[i32] } i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)  =>  (DIVWU:{ *:[i32] } i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::DIVWU),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 203,
      GIR_Done,
    // Label 169: @2279
    GIM_Reject,
    // Label 164: @2280
    GIM_Try, /*On fail goto*//*Label 170*/ GIMT_Encode4(2302), // Rule ID 694 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
      // (udiv:{ *:[i64] } i64:{ *:[i64] }:$RA, i64:{ *:[i64] }:$RB)  =>  (DIVDU:{ *:[i64] } i64:{ *:[i64] }:$RA, i64:{ *:[i64] }:$RB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::DIVDU),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 694,
      GIR_Done,
    // Label 170: @2302
    GIM_Reject,
    // Label 165: @2303
    GIM_Try, /*On fail goto*//*Label 171*/ GIMT_Encode4(2328), // Rule ID 1145 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s128,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s128,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (udiv:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)  =>  (VDIVUQ:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VDIVUQ),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1145,
      GIR_Done,
    // Label 171: @2328
    GIM_Reject,
    // Label 166: @2329
    GIM_Try, /*On fail goto*//*Label 172*/ GIMT_Encode4(2354), // Rule ID 1132 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (udiv:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VDIVUD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VDIVUD),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1132,
      GIR_Done,
    // Label 172: @2354
    GIM_Reject,
    // Label 167: @2355
    GIM_Try, /*On fail goto*//*Label 173*/ GIMT_Encode4(2380), // Rule ID 1130 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (udiv:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VDIVUW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VDIVUW),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1130,
      GIR_Done,
    // Label 173: @2380
    GIM_Reject,
    // Label 168: @2381
    GIM_Reject,
    // Label 5: @2382
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(6), /*)*//*default:*//*Label 179*/ GIMT_Encode4(2543),
    /*GILLT_s32*//*Label 174*/ GIMT_Encode4(2413),
    /*GILLT_s64*//*Label 175*/ GIMT_Encode4(2439),
    /*GILLT_s128*//*Label 176*/ GIMT_Encode4(2465),
    /*GILLT_v2s64*//*Label 177*/ GIMT_Encode4(2491),
    /*GILLT_v4s32*//*Label 178*/ GIMT_Encode4(2517),
    // Label 174: @2413
    GIM_Try, /*On fail goto*//*Label 180*/ GIMT_Encode4(2438), // Rule ID 197 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_0),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
      // (srem:{ *:[i32] } i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)  =>  (MODSW:{ *:[i32] } i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::MODSW),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 197,
      GIR_Done,
    // Label 180: @2438
    GIM_Reject,
    // Label 175: @2439
    GIM_Try, /*On fail goto*//*Label 181*/ GIMT_Encode4(2464), // Rule ID 698 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_0),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
      // (srem:{ *:[i64] } i64:{ *:[i64] }:$RA, i64:{ *:[i64] }:$RB)  =>  (MODSD:{ *:[i64] } i64:{ *:[i64] }:$RA, i64:{ *:[i64] }:$RB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::MODSD),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 698,
      GIR_Done,
    // Label 181: @2464
    GIM_Reject,
    // Label 176: @2465
    GIM_Try, /*On fail goto*//*Label 182*/ GIMT_Encode4(2490), // Rule ID 1154 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s128,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s128,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (srem:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)  =>  (VMODSQ:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMODSQ),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1154,
      GIR_Done,
    // Label 182: @2490
    GIM_Reject,
    // Label 177: @2491
    GIM_Try, /*On fail goto*//*Label 183*/ GIMT_Encode4(2516), // Rule ID 1127 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (srem:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VMODSD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMODSD),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1127,
      GIR_Done,
    // Label 183: @2516
    GIM_Reject,
    // Label 178: @2517
    GIM_Try, /*On fail goto*//*Label 184*/ GIMT_Encode4(2542), // Rule ID 1125 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (srem:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VMODSW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMODSW),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1125,
      GIR_Done,
    // Label 184: @2542
    GIM_Reject,
    // Label 179: @2543
    GIM_Reject,
    // Label 6: @2544
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(6), /*)*//*default:*//*Label 190*/ GIMT_Encode4(2705),
    /*GILLT_s32*//*Label 185*/ GIMT_Encode4(2575),
    /*GILLT_s64*//*Label 186*/ GIMT_Encode4(2601),
    /*GILLT_s128*//*Label 187*/ GIMT_Encode4(2627),
    /*GILLT_v2s64*//*Label 188*/ GIMT_Encode4(2653),
    /*GILLT_v4s32*//*Label 189*/ GIMT_Encode4(2679),
    // Label 185: @2575
    GIM_Try, /*On fail goto*//*Label 191*/ GIMT_Encode4(2600), // Rule ID 198 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_0),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
      // (urem:{ *:[i32] } i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)  =>  (MODUW:{ *:[i32] } i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::MODUW),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 198,
      GIR_Done,
    // Label 191: @2600
    GIM_Reject,
    // Label 186: @2601
    GIM_Try, /*On fail goto*//*Label 192*/ GIMT_Encode4(2626), // Rule ID 699 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_0),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
      // (urem:{ *:[i64] } i64:{ *:[i64] }:$RA, i64:{ *:[i64] }:$RB)  =>  (MODUD:{ *:[i64] } i64:{ *:[i64] }:$RA, i64:{ *:[i64] }:$RB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::MODUD),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 699,
      GIR_Done,
    // Label 192: @2626
    GIM_Reject,
    // Label 187: @2627
    GIM_Try, /*On fail goto*//*Label 193*/ GIMT_Encode4(2652), // Rule ID 1155 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s128,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s128,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (urem:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)  =>  (VMODUQ:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMODUQ),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1155,
      GIR_Done,
    // Label 193: @2652
    GIM_Reject,
    // Label 188: @2653
    GIM_Try, /*On fail goto*//*Label 194*/ GIMT_Encode4(2678), // Rule ID 1128 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (urem:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VMODUD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMODUD),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1128,
      GIR_Done,
    // Label 194: @2678
    GIM_Reject,
    // Label 189: @2679
    GIM_Try, /*On fail goto*//*Label 195*/ GIMT_Encode4(2704), // Rule ID 1126 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
      // (urem:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VMODUW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMODUW),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1126,
      GIR_Done,
    // Label 195: @2704
    GIM_Reject,
    // Label 190: @2705
    GIM_Reject,
    // Label 7: @2706
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(0), GIMT_Encode2(6), /*)*//*default:*//*Label 200*/ GIMT_Encode4(5266),
    /*GILLT_s1*//*Label 196*/ GIMT_Encode4(2741),
    /*GILLT_s32*//*Label 197*/ GIMT_Encode4(2850),
    /*GILLT_s64*//*Label 198*/ GIMT_Encode4(2959), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v4s32*//*Label 199*/ GIMT_Encode4(3068),
    // Label 196: @2741
    GIM_Try, /*On fail goto*//*Label 201*/ GIMT_Encode4(2849),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::CRBITRCRegClassID),
      GIM_Try, /*On fail goto*//*Label 202*/ GIMT_Encode4(2796), // Rule ID 4876 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i1] } (xor:{ *:[i1] } i1:{ *:[i1] }:$CRB, -1:{ *:[i1] }), i1:{ *:[i1] }:$CRA)  =>  (CRANDC:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::CRANDC),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[CRD]
        GIR_RootToRootCopy, /*OpIdx*/2, // CRA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // CRB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4876,
        GIR_EraseRootFromParent_Done,
      // Label 202: @2796
      GIM_Try, /*On fail goto*//*Label 203*/ GIMT_Encode4(2836), // Rule ID 182 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i1] } i1:{ *:[i1] }:$CRA, (xor:{ *:[i1] } i1:{ *:[i1] }:$CRB, -1:{ *:[i1] }))  =>  (CRANDC:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::CRANDC),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[CRD]
        GIR_RootToRootCopy, /*OpIdx*/1, // CRA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // CRB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 182,
        GIR_EraseRootFromParent_Done,
      // Label 203: @2836
      GIM_Try, /*On fail goto*//*Label 204*/ GIMT_Encode4(2848), // Rule ID 175 //
        // (and:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)  =>  (CRAND:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::CRAND),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 175,
        GIR_Done,
      // Label 204: @2848
      GIM_Reject,
    // Label 201: @2849
    GIM_Reject,
    // Label 197: @2850
    GIM_Try, /*On fail goto*//*Label 205*/ GIMT_Encode4(2958),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
      GIM_Try, /*On fail goto*//*Label 206*/ GIMT_Encode4(2905), // Rule ID 4870 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$RB, -1:{ *:[i32] }), i32:{ *:[i32] }:$RST)  =>  (ANDC:{ *:[i32] } i32:{ *:[i32] }:$RST, i32:{ *:[i32] }:$RB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::ANDC),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RA]
        GIR_RootToRootCopy, /*OpIdx*/2, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4870,
        GIR_EraseRootFromParent_Done,
      // Label 206: @2905
      GIM_Try, /*On fail goto*//*Label 207*/ GIMT_Encode4(2945), // Rule ID 123 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } i32:{ *:[i32] }:$RST, (xor:{ *:[i32] } i32:{ *:[i32] }:$RB, -1:{ *:[i32] }))  =>  (ANDC:{ *:[i32] } i32:{ *:[i32] }:$RST, i32:{ *:[i32] }:$RB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::ANDC),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RA]
        GIR_RootToRootCopy, /*OpIdx*/1, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 123,
        GIR_EraseRootFromParent_Done,
      // Label 207: @2945
      GIM_Try, /*On fail goto*//*Label 208*/ GIMT_Encode4(2957), // Rule ID 122 //
        // (and:{ *:[i32] } i32:{ *:[i32] }:$RST, i32:{ *:[i32] }:$RB)  =>  (AND:{ *:[i32] } i32:{ *:[i32] }:$RST, i32:{ *:[i32] }:$RB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::AND),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 122,
        GIR_Done,
      // Label 208: @2957
      GIM_Reject,
    // Label 205: @2958
    GIM_Reject,
    // Label 198: @2959
    GIM_Try, /*On fail goto*//*Label 209*/ GIMT_Encode4(3067),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
      GIM_Try, /*On fail goto*//*Label 210*/ GIMT_Encode4(3014), // Rule ID 4883 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i64] } (xor:{ *:[i64] } i64:{ *:[i64] }:$RB, -1:{ *:[i64] }), i64:{ *:[i64] }:$RST)  =>  (ANDC8:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::ANDC8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RA]
        GIR_RootToRootCopy, /*OpIdx*/2, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4883,
        GIR_EraseRootFromParent_Done,
      // Label 210: @3014
      GIM_Try, /*On fail goto*//*Label 211*/ GIMT_Encode4(3054), // Rule ID 643 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i64] } i64:{ *:[i64] }:$RST, (xor:{ *:[i64] } i64:{ *:[i64] }:$RB, -1:{ *:[i64] }))  =>  (ANDC8:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::ANDC8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RA]
        GIR_RootToRootCopy, /*OpIdx*/1, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 643,
        GIR_EraseRootFromParent_Done,
      // Label 211: @3054
      GIM_Try, /*On fail goto*//*Label 212*/ GIMT_Encode4(3066), // Rule ID 642 //
        // (and:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)  =>  (AND8:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::AND8),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 642,
        GIR_Done,
      // Label 212: @3066
      GIM_Reject,
    // Label 209: @3067
    GIM_Reject,
    // Label 199: @3068
    GIM_Try, /*On fail goto*//*Label 213*/ GIMT_Encode4(5265),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 214*/ GIMT_Encode4(3157), // Rule ID 5231 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (and:{ *:[v4i32] } (and:{ *:[v4i32] } (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, immAllOnesV:{ *:[v4i32] }), v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC)  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 16:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vB
        GIR_RootToRootCopy, /*OpIdx*/2, // vC
        GIR_AddImm8, /*InsnID*/0, /*Imm*/16,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5231,
        GIR_EraseRootFromParent_Done,
      // Label 214: @3157
      GIM_Try, /*On fail goto*//*Label 215*/ GIMT_Encode4(3235), // Rule ID 5232 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, immAllOnesV:{ *:[v4i32] })), v4i32:{ *:[v4i32] }:$vC)  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 16:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
        GIR_RootToRootCopy, /*OpIdx*/2, // vC
        GIR_AddImm8, /*InsnID*/0, /*Imm*/16,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5232,
        GIR_EraseRootFromParent_Done,
      // Label 215: @3235
      GIM_Try, /*On fail goto*//*Label 216*/ GIMT_Encode4(3315), // Rule ID 5233 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 16:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vC
        GIR_AddImm8, /*InsnID*/0, /*Imm*/16,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5233,
        GIR_EraseRootFromParent_Done,
      // Label 216: @3315
      GIM_Try, /*On fail goto*//*Label 217*/ GIMT_Encode4(3395), // Rule ID 5236 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (and:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 112:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vC
        GIR_AddImm8, /*InsnID*/0, /*Imm*/112,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5236,
        GIR_EraseRootFromParent_Done,
      // Label 217: @3395
      GIM_Try, /*On fail goto*//*Label 218*/ GIMT_Encode4(3473), // Rule ID 4920 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (and:{ *:[v4i32] } (xor:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }), v4i32:{ *:[v4i32] }:$vA)  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 14:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4920,
        GIR_EraseRootFromParent_Done,
      // Label 218: @3473
      GIM_Try, /*On fail goto*//*Label 219*/ GIMT_Encode4(3551), // Rule ID 4914 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (and:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }), v4i32:{ *:[v4i32] }:$vA)  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 8:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4914,
        GIR_EraseRootFromParent_Done,
      // Label 219: @3551
      GIM_Try, /*On fail goto*//*Label 220*/ GIMT_Encode4(3629), // Rule ID 4918 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (and:{ *:[v4i32] } (xor:{ *:[v4i32] } (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, immAllOnesV:{ *:[v4i32] }), v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA)  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 9:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vC
        GIR_AddImm8, /*InsnID*/0, /*Imm*/9,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4918,
        GIR_EraseRootFromParent_Done,
      // Label 220: @3629
      GIM_Try, /*On fail goto*//*Label 221*/ GIMT_Encode4(3707), // Rule ID 4917 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (and:{ *:[v4i32] } (xor:{ *:[v4i32] } (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }), v4i32:{ *:[v4i32] }:$vA)  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 9:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm8, /*InsnID*/0, /*Imm*/9,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4917,
        GIR_EraseRootFromParent_Done,
      // Label 221: @3707
      GIM_Try, /*On fail goto*//*Label 222*/ GIMT_Encode4(3785), // Rule ID 4919 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (and:{ *:[v4i32] } (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, immAllOnesV:{ *:[v4i32] })), v4i32:{ *:[v4i32] }:$vA)  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 9:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vC
        GIR_AddImm8, /*InsnID*/0, /*Imm*/9,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4919,
        GIR_EraseRootFromParent_Done,
      // Label 222: @3785
      GIM_Try, /*On fail goto*//*Label 223*/ GIMT_Encode4(3865), // Rule ID 3393 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (and:{ *:[v4i32] } (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 16:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
        GIR_AddImm8, /*InsnID*/0, /*Imm*/16,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3393,
        GIR_EraseRootFromParent_Done,
      // Label 223: @3865
      GIM_Try, /*On fail goto*//*Label 224*/ GIMT_Encode4(3945), // Rule ID 3394 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (and:{ *:[v4i32] } (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, immAllOnesV:{ *:[v4i32] }), (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 112:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
        GIR_AddImm8, /*InsnID*/0, /*Imm*/112,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3394,
        GIR_EraseRootFromParent_Done,
      // Label 224: @3945
      GIM_Try, /*On fail goto*//*Label 225*/ GIMT_Encode4(4025), // Rule ID 3392 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (and:{ *:[v4i32] } (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, immAllOnesV:{ *:[v4i32] }), (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 96:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
        GIR_AddImm8, /*InsnID*/0, /*Imm*/96,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3392,
        GIR_EraseRootFromParent_Done,
      // Label 225: @4025
      GIM_Try, /*On fail goto*//*Label 226*/ GIMT_Encode4(4105), // Rule ID 5230 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (and:{ *:[v4i32] } (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 96:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vC
        GIR_AddImm8, /*InsnID*/0, /*Imm*/96,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5230,
        GIR_EraseRootFromParent_Done,
      // Label 226: @4105
      GIM_Try, /*On fail goto*//*Label 227*/ GIMT_Encode4(4183), // Rule ID 5234 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, immAllOnesV:{ *:[v4i32] }), v4i32:{ *:[v4i32] }:$vB))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 16:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vB
        GIR_RootToRootCopy, /*OpIdx*/1, // vC
        GIR_AddImm8, /*InsnID*/0, /*Imm*/16,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5234,
        GIR_EraseRootFromParent_Done,
      // Label 227: @4183
      GIM_Try, /*On fail goto*//*Label 228*/ GIMT_Encode4(4261), // Rule ID 5235 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, immAllOnesV:{ *:[v4i32] })))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 16:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
        GIR_RootToRootCopy, /*OpIdx*/1, // vC
        GIR_AddImm8, /*InsnID*/0, /*Imm*/16,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5235,
        GIR_EraseRootFromParent_Done,
      // Label 228: @4261
      GIM_Try, /*On fail goto*//*Label 229*/ GIMT_Encode4(4339), // Rule ID 3380 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (xor:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 14:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3380,
        GIR_EraseRootFromParent_Done,
      // Label 229: @4339
      GIM_Try, /*On fail goto*//*Label 230*/ GIMT_Encode4(4417), // Rule ID 3378 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 8:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3378,
        GIR_EraseRootFromParent_Done,
      // Label 230: @4417
      GIM_Try, /*On fail goto*//*Label 231*/ GIMT_Encode4(4495), // Rule ID 4915 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (xor:{ *:[v4i32] } (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, immAllOnesV:{ *:[v4i32] }), v4i32:{ *:[v4i32] }:$vC))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 9:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vC
        GIR_AddImm8, /*InsnID*/0, /*Imm*/9,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4915,
        GIR_EraseRootFromParent_Done,
      // Label 231: @4495
      GIM_Try, /*On fail goto*//*Label 232*/ GIMT_Encode4(4573), // Rule ID 3379 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (xor:{ *:[v4i32] } (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 9:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm8, /*InsnID*/0, /*Imm*/9,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3379,
        GIR_EraseRootFromParent_Done,
      // Label 232: @4573
      GIM_Try, /*On fail goto*//*Label 233*/ GIMT_Encode4(4651), // Rule ID 4916 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, immAllOnesV:{ *:[v4i32] })))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 9:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vC
        GIR_AddImm8, /*InsnID*/0, /*Imm*/9,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4916,
        GIR_EraseRootFromParent_Done,
      // Label 233: @4651
      GIM_Try, /*On fail goto*//*Label 234*/ GIMT_Encode4(4706), // Rule ID 4891 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v4i32] } (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XB, immAllOnesV:{ *:[v4i32] }), v4i32:{ *:[v4i32] }:$XA)  =>  (XXLANDC:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXLANDC),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/2, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // XB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4891,
        GIR_EraseRootFromParent_Done,
      // Label 234: @4706
      GIM_Try, /*On fail goto*//*Label 235*/ GIMT_Encode4(4761), // Rule ID 929 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XB, immAllOnesV:{ *:[v4i32] }))  =>  (XXLANDC:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXLANDC),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/1, // XA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // XB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 929,
        GIR_EraseRootFromParent_Done,
      // Label 235: @4761
      GIM_Try, /*On fail goto*//*Label 236*/ GIMT_Encode4(4811), // Rule ID 4911 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC)  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 1:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vB
        GIR_RootToRootCopy, /*OpIdx*/2, // vC
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4911,
        GIR_EraseRootFromParent_Done,
      // Label 236: @4811
      GIM_Try, /*On fail goto*//*Label 237*/ GIMT_Encode4(4861), // Rule ID 4913 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA)  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 7:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vC
        GIR_AddImm8, /*InsnID*/0, /*Imm*/7,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4913,
        GIR_EraseRootFromParent_Done,
      // Label 237: @4861
      GIM_Try, /*On fail goto*//*Label 238*/ GIMT_Encode4(4911), // Rule ID 4912 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[v4i32] } (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA)  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 6:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vC
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4912,
        GIR_EraseRootFromParent_Done,
      // Label 238: @4911
      GIM_Try, /*On fail goto*//*Label 239*/ GIMT_Encode4(4961), // Rule ID 3375 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 1:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vC
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3375,
        GIR_EraseRootFromParent_Done,
      // Label 239: @4961
      GIM_Try, /*On fail goto*//*Label 240*/ GIMT_Encode4(5011), // Rule ID 3377 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 7:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vC
        GIR_AddImm8, /*InsnID*/0, /*Imm*/7,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3377,
        GIR_EraseRootFromParent_Done,
      // Label 240: @5011
      GIM_Try, /*On fail goto*//*Label 241*/ GIMT_Encode4(5061), // Rule ID 3376 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 6:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_RootToRootCopy, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vC
        GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3376,
        GIR_EraseRootFromParent_Done,
      // Label 241: @5061
      GIM_Try, /*On fail goto*//*Label 242*/ GIMT_Encode4(5080), // Rule ID 928 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        // (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)  =>  (XXLAND:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XXLAND),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 928,
        GIR_Done,
      // Label 242: @5080
      GIM_Try, /*On fail goto*//*Label 243*/ GIMT_Encode4(5135), // Rule ID 4879 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v4i32] } (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VB, immAllOnesV:{ *:[v4i32] }), v4i32:{ *:[v4i32] }:$VA)  =>  (VANDC:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VANDC),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/2, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4879,
        GIR_EraseRootFromParent_Done,
      // Label 243: @5135
      GIM_Try, /*On fail goto*//*Label 244*/ GIMT_Encode4(5190), // Rule ID 312 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VB, immAllOnesV:{ *:[v4i32] }))  =>  (VANDC:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VANDC),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/1, // VA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // VB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 312,
        GIR_EraseRootFromParent_Done,
      // Label 244: @5190
      GIM_Try, /*On fail goto*//*Label 245*/ GIMT_Encode4(5245), // Rule ID 1375 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$A, (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$B, immAllOnesV:{ *:[v4i32] }))  =>  (VANDC:{ *:[v4i32] } ?:{ *:[v4i32] }:$A, ?:{ *:[v4i32] }:$B)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VANDC),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
        GIR_RootToRootCopy, /*OpIdx*/1, // A
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // B
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1375,
        GIR_EraseRootFromParent_Done,
      // Label 245: @5245
      GIM_Try, /*On fail goto*//*Label 246*/ GIMT_Encode4(5264), // Rule ID 311 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
        // (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VAND:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VAND),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 311,
        GIR_Done,
      // Label 246: @5264
      GIM_Reject,
    // Label 213: @5265
    GIM_Reject,
    // Label 200: @5266
    GIM_Reject,
    // Label 8: @5267
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(0), GIMT_Encode2(6), /*)*//*default:*//*Label 251*/ GIMT_Encode4(48408),
    /*GILLT_s1*//*Label 247*/ GIMT_Encode4(5302),
    /*GILLT_s32*//*Label 248*/ GIMT_Encode4(5411),
    /*GILLT_s64*//*Label 249*/ GIMT_Encode4(5520), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v4s32*//*Label 250*/ GIMT_Encode4(5629),
    // Label 247: @5302
    GIM_Try, /*On fail goto*//*Label 252*/ GIMT_Encode4(5410),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::CRBITRCRegClassID),
      GIM_Try, /*On fail goto*//*Label 253*/ GIMT_Encode4(5357), // Rule ID 4877 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i1] } (xor:{ *:[i1] } i1:{ *:[i1] }:$CRB, -1:{ *:[i1] }), i1:{ *:[i1] }:$CRA)  =>  (CRORC:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::CRORC),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[CRD]
        GIR_RootToRootCopy, /*OpIdx*/2, // CRA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // CRB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4877,
        GIR_EraseRootFromParent_Done,
      // Label 253: @5357
      GIM_Try, /*On fail goto*//*Label 254*/ GIMT_Encode4(5397), // Rule ID 183 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i1] } i1:{ *:[i1] }:$CRA, (xor:{ *:[i1] } i1:{ *:[i1] }:$CRB, -1:{ *:[i1] }))  =>  (CRORC:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::CRORC),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[CRD]
        GIR_RootToRootCopy, /*OpIdx*/1, // CRA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // CRB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 183,
        GIR_EraseRootFromParent_Done,
      // Label 254: @5397
      GIM_Try, /*On fail goto*//*Label 255*/ GIMT_Encode4(5409), // Rule ID 177 //
        // (or:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)  =>  (CROR:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::CROR),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 177,
        GIR_Done,
      // Label 255: @5409
      GIM_Reject,
    // Label 252: @5410
    GIM_Reject,
    // Label 248: @5411
    GIM_Try, /*On fail goto*//*Label 256*/ GIMT_Encode4(5519),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
      GIM_Try, /*On fail goto*//*Label 257*/ GIMT_Encode4(5466), // Rule ID 4871 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$RB, -1:{ *:[i32] }), i32:{ *:[i32] }:$RST)  =>  (ORC:{ *:[i32] } i32:{ *:[i32] }:$RST, i32:{ *:[i32] }:$RB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::ORC),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RA]
        GIR_RootToRootCopy, /*OpIdx*/2, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4871,
        GIR_EraseRootFromParent_Done,
      // Label 257: @5466
      GIM_Try, /*On fail goto*//*Label 258*/ GIMT_Encode4(5506), // Rule ID 126 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i32] } i32:{ *:[i32] }:$RST, (xor:{ *:[i32] } i32:{ *:[i32] }:$RB, -1:{ *:[i32] }))  =>  (ORC:{ *:[i32] } i32:{ *:[i32] }:$RST, i32:{ *:[i32] }:$RB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::ORC),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RA]
        GIR_RootToRootCopy, /*OpIdx*/1, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 126,
        GIR_EraseRootFromParent_Done,
      // Label 258: @5506
      GIM_Try, /*On fail goto*//*Label 259*/ GIMT_Encode4(5518), // Rule ID 124 //
        // (or:{ *:[i32] } i32:{ *:[i32] }:$RST, i32:{ *:[i32] }:$RB)  =>  (OR:{ *:[i32] } i32:{ *:[i32] }:$RST, i32:{ *:[i32] }:$RB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::OR),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 124,
        GIR_Done,
      // Label 259: @5518
      GIM_Reject,
    // Label 256: @5519
    GIM_Reject,
    // Label 249: @5520
    GIM_Try, /*On fail goto*//*Label 260*/ GIMT_Encode4(5628),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
      GIM_Try, /*On fail goto*//*Label 261*/ GIMT_Encode4(5575), // Rule ID 4884 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i64] } (xor:{ *:[i64] } i64:{ *:[i64] }:$RB, -1:{ *:[i64] }), i64:{ *:[i64] }:$RST)  =>  (ORC8:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::ORC8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RA]
        GIR_RootToRootCopy, /*OpIdx*/2, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4884,
        GIR_EraseRootFromParent_Done,
      // Label 261: @5575
      GIM_Try, /*On fail goto*//*Label 262*/ GIMT_Encode4(5615), // Rule ID 646 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i64] } i64:{ *:[i64] }:$RST, (xor:{ *:[i64] } i64:{ *:[i64] }:$RB, -1:{ *:[i64] }))  =>  (ORC8:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::ORC8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RA]
        GIR_RootToRootCopy, /*OpIdx*/1, // RST
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RB
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 646,
        GIR_EraseRootFromParent_Done,
      // Label 262: @5615
      GIM_Try, /*On fail goto*//*Label 263*/ GIMT_Encode4(5627), // Rule ID 644 //
        // (or:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)  =>  (OR8:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::OR8),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 644,
        GIR_Done,
      // Label 263: @5627
      GIM_Reject,
    // Label 260: @5628
    GIM_Reject,
    // Label 250: @5629
    GIM_Try, /*On fail goto*//*Label 264*/ GIMT_Encode4(48407),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 265*/ GIMT_Encode4(5778), // Rule ID 4931 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[4] vC
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4931,
        GIR_EraseRootFromParent_Done,
      // Label 265: @5778
      GIM_Try, /*On fail goto*//*Label 266*/ GIMT_Encode4(5916), // Rule ID 4932 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[4] vC
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4932,
        GIR_EraseRootFromParent_Done,
      // Label 266: @5916
      GIM_Try, /*On fail goto*//*Label 267*/ GIMT_Encode4(6054), // Rule ID 4933 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[4] vB
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4933,
        GIR_EraseRootFromParent_Done,
      // Label 267: @6054
      GIM_Try, /*On fail goto*//*Label 268*/ GIMT_Encode4(6192), // Rule ID 4934 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[4] vB
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4934,
        GIR_EraseRootFromParent_Done,
      // Label 268: @6192
      GIM_Try, /*On fail goto*//*Label 269*/ GIMT_Encode4(6330), // Rule ID 4935 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[4] vA
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4935,
        GIR_EraseRootFromParent_Done,
      // Label 269: @6330
      GIM_Try, /*On fail goto*//*Label 270*/ GIMT_Encode4(6468), // Rule ID 4936 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[4] vA
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4936,
        GIR_EraseRootFromParent_Done,
      // Label 270: @6468
      GIM_Try, /*On fail goto*//*Label 271*/ GIMT_Encode4(6606), // Rule ID 4943 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[4] vC
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4943,
        GIR_EraseRootFromParent_Done,
      // Label 271: @6606
      GIM_Try, /*On fail goto*//*Label 272*/ GIMT_Encode4(6744), // Rule ID 4944 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[4] vC
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4944,
        GIR_EraseRootFromParent_Done,
      // Label 272: @6744
      GIM_Try, /*On fail goto*//*Label 273*/ GIMT_Encode4(6882), // Rule ID 4945 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[4] vB
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4945,
        GIR_EraseRootFromParent_Done,
      // Label 273: @6882
      GIM_Try, /*On fail goto*//*Label 274*/ GIMT_Encode4(7020), // Rule ID 4946 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[4] vB
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4946,
        GIR_EraseRootFromParent_Done,
      // Label 274: @7020
      GIM_Try, /*On fail goto*//*Label 275*/ GIMT_Encode4(7158), // Rule ID 4947 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[4] vA
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4947,
        GIR_EraseRootFromParent_Done,
      // Label 275: @7158
      GIM_Try, /*On fail goto*//*Label 276*/ GIMT_Encode4(7296), // Rule ID 4948 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[4] vA
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4948,
        GIR_EraseRootFromParent_Done,
      // Label 276: @7296
      GIM_Try, /*On fail goto*//*Label 277*/ GIMT_Encode4(7434), // Rule ID 4955 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[4] vC
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4955,
        GIR_EraseRootFromParent_Done,
      // Label 277: @7434
      GIM_Try, /*On fail goto*//*Label 278*/ GIMT_Encode4(7572), // Rule ID 4956 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[4] vC
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4956,
        GIR_EraseRootFromParent_Done,
      // Label 278: @7572
      GIM_Try, /*On fail goto*//*Label 279*/ GIMT_Encode4(7710), // Rule ID 4957 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[4] vB
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4957,
        GIR_EraseRootFromParent_Done,
      // Label 279: @7710
      GIM_Try, /*On fail goto*//*Label 280*/ GIMT_Encode4(7848), // Rule ID 4958 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[4] vB
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4958,
        GIR_EraseRootFromParent_Done,
      // Label 280: @7848
      GIM_Try, /*On fail goto*//*Label 281*/ GIMT_Encode4(7986), // Rule ID 4959 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[4] vA
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4959,
        GIR_EraseRootFromParent_Done,
      // Label 281: @7986
      GIM_Try, /*On fail goto*//*Label 282*/ GIMT_Encode4(8124), // Rule ID 4960 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[4] vA
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4960,
        GIR_EraseRootFromParent_Done,
      // Label 282: @8124
      GIM_Try, /*On fail goto*//*Label 283*/ GIMT_Encode4(8262), // Rule ID 4967 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[4] vC
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4967,
        GIR_EraseRootFromParent_Done,
      // Label 283: @8262
      GIM_Try, /*On fail goto*//*Label 284*/ GIMT_Encode4(8400), // Rule ID 4968 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[4] vC
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4968,
        GIR_EraseRootFromParent_Done,
      // Label 284: @8400
      GIM_Try, /*On fail goto*//*Label 285*/ GIMT_Encode4(8538), // Rule ID 4969 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[4] vB
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4969,
        GIR_EraseRootFromParent_Done,
      // Label 285: @8538
      GIM_Try, /*On fail goto*//*Label 286*/ GIMT_Encode4(8676), // Rule ID 4970 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[4] vB
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4970,
        GIR_EraseRootFromParent_Done,
      // Label 286: @8676
      GIM_Try, /*On fail goto*//*Label 287*/ GIMT_Encode4(8814), // Rule ID 4971 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[4] vA
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4971,
        GIR_EraseRootFromParent_Done,
      // Label 287: @8814
      GIM_Try, /*On fail goto*//*Label 288*/ GIMT_Encode4(8952), // Rule ID 4972 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[4] vA
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4972,
        GIR_EraseRootFromParent_Done,
      // Label 288: @8952
      GIM_Try, /*On fail goto*//*Label 289*/ GIMT_Encode4(9090), // Rule ID 4979 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[4] vC
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4979,
        GIR_EraseRootFromParent_Done,
      // Label 289: @9090
      GIM_Try, /*On fail goto*//*Label 290*/ GIMT_Encode4(9228), // Rule ID 4980 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[4] vC
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4980,
        GIR_EraseRootFromParent_Done,
      // Label 290: @9228
      GIM_Try, /*On fail goto*//*Label 291*/ GIMT_Encode4(9366), // Rule ID 4981 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[4] vB
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4981,
        GIR_EraseRootFromParent_Done,
      // Label 291: @9366
      GIM_Try, /*On fail goto*//*Label 292*/ GIMT_Encode4(9504), // Rule ID 4982 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[4] vB
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4982,
        GIR_EraseRootFromParent_Done,
      // Label 292: @9504
      GIM_Try, /*On fail goto*//*Label 293*/ GIMT_Encode4(9642), // Rule ID 4983 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[4] vA
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4983,
        GIR_EraseRootFromParent_Done,
      // Label 293: @9642
      GIM_Try, /*On fail goto*//*Label 294*/ GIMT_Encode4(9780), // Rule ID 4984 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[4] vA
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4984,
        GIR_EraseRootFromParent_Done,
      // Label 294: @9780
      GIM_Try, /*On fail goto*//*Label 295*/ GIMT_Encode4(9918), // Rule ID 4991 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[4] vC
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4991,
        GIR_EraseRootFromParent_Done,
      // Label 295: @9918
      GIM_Try, /*On fail goto*//*Label 296*/ GIMT_Encode4(10056), // Rule ID 4992 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[4] vC
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4992,
        GIR_EraseRootFromParent_Done,
      // Label 296: @10056
      GIM_Try, /*On fail goto*//*Label 297*/ GIMT_Encode4(10194), // Rule ID 4993 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[4] vB
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4993,
        GIR_EraseRootFromParent_Done,
      // Label 297: @10194
      GIM_Try, /*On fail goto*//*Label 298*/ GIMT_Encode4(10332), // Rule ID 4994 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[4] vB
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4994,
        GIR_EraseRootFromParent_Done,
      // Label 298: @10332
      GIM_Try, /*On fail goto*//*Label 299*/ GIMT_Encode4(10470), // Rule ID 4995 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[4] vA
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4995,
        GIR_EraseRootFromParent_Done,
      // Label 299: @10470
      GIM_Try, /*On fail goto*//*Label 300*/ GIMT_Encode4(10608), // Rule ID 4996 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[4] vA
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4996,
        GIR_EraseRootFromParent_Done,
      // Label 300: @10608
      GIM_Try, /*On fail goto*//*Label 301*/ GIMT_Encode4(10746), // Rule ID 4937 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vC
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4937,
        GIR_EraseRootFromParent_Done,
      // Label 301: @10746
      GIM_Try, /*On fail goto*//*Label 302*/ GIMT_Encode4(10884), // Rule ID 4938 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vC
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4938,
        GIR_EraseRootFromParent_Done,
      // Label 302: @10884
      GIM_Try, /*On fail goto*//*Label 303*/ GIMT_Encode4(11022), // Rule ID 4939 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vB
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4939,
        GIR_EraseRootFromParent_Done,
      // Label 303: @11022
      GIM_Try, /*On fail goto*//*Label 304*/ GIMT_Encode4(11160), // Rule ID 4940 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vB
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4940,
        GIR_EraseRootFromParent_Done,
      // Label 304: @11160
      GIM_Try, /*On fail goto*//*Label 305*/ GIMT_Encode4(11298), // Rule ID 4941 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vA
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4941,
        GIR_EraseRootFromParent_Done,
      // Label 305: @11298
      GIM_Try, /*On fail goto*//*Label 306*/ GIMT_Encode4(11436), // Rule ID 4942 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vA
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4942,
        GIR_EraseRootFromParent_Done,
      // Label 306: @11436
      GIM_Try, /*On fail goto*//*Label 307*/ GIMT_Encode4(11574), // Rule ID 4949 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vC
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4949,
        GIR_EraseRootFromParent_Done,
      // Label 307: @11574
      GIM_Try, /*On fail goto*//*Label 308*/ GIMT_Encode4(11712), // Rule ID 4950 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vC
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4950,
        GIR_EraseRootFromParent_Done,
      // Label 308: @11712
      GIM_Try, /*On fail goto*//*Label 309*/ GIMT_Encode4(11850), // Rule ID 4951 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vB
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4951,
        GIR_EraseRootFromParent_Done,
      // Label 309: @11850
      GIM_Try, /*On fail goto*//*Label 310*/ GIMT_Encode4(11988), // Rule ID 4952 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vB
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4952,
        GIR_EraseRootFromParent_Done,
      // Label 310: @11988
      GIM_Try, /*On fail goto*//*Label 311*/ GIMT_Encode4(12126), // Rule ID 4953 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vA
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4953,
        GIR_EraseRootFromParent_Done,
      // Label 311: @12126
      GIM_Try, /*On fail goto*//*Label 312*/ GIMT_Encode4(12264), // Rule ID 4954 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vA
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4954,
        GIR_EraseRootFromParent_Done,
      // Label 312: @12264
      GIM_Try, /*On fail goto*//*Label 313*/ GIMT_Encode4(12402), // Rule ID 4961 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vC
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4961,
        GIR_EraseRootFromParent_Done,
      // Label 313: @12402
      GIM_Try, /*On fail goto*//*Label 314*/ GIMT_Encode4(12540), // Rule ID 4962 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vC
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4962,
        GIR_EraseRootFromParent_Done,
      // Label 314: @12540
      GIM_Try, /*On fail goto*//*Label 315*/ GIMT_Encode4(12678), // Rule ID 4963 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vB
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4963,
        GIR_EraseRootFromParent_Done,
      // Label 315: @12678
      GIM_Try, /*On fail goto*//*Label 316*/ GIMT_Encode4(12816), // Rule ID 4964 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vB
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4964,
        GIR_EraseRootFromParent_Done,
      // Label 316: @12816
      GIM_Try, /*On fail goto*//*Label 317*/ GIMT_Encode4(12954), // Rule ID 4965 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vA
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4965,
        GIR_EraseRootFromParent_Done,
      // Label 317: @12954
      GIM_Try, /*On fail goto*//*Label 318*/ GIMT_Encode4(13092), // Rule ID 4966 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vA
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4966,
        GIR_EraseRootFromParent_Done,
      // Label 318: @13092
      GIM_Try, /*On fail goto*//*Label 319*/ GIMT_Encode4(13230), // Rule ID 4973 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vC
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4973,
        GIR_EraseRootFromParent_Done,
      // Label 319: @13230
      GIM_Try, /*On fail goto*//*Label 320*/ GIMT_Encode4(13368), // Rule ID 4974 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vC
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4974,
        GIR_EraseRootFromParent_Done,
      // Label 320: @13368
      GIM_Try, /*On fail goto*//*Label 321*/ GIMT_Encode4(13506), // Rule ID 4975 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vB
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4975,
        GIR_EraseRootFromParent_Done,
      // Label 321: @13506
      GIM_Try, /*On fail goto*//*Label 322*/ GIMT_Encode4(13644), // Rule ID 4976 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vB
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4976,
        GIR_EraseRootFromParent_Done,
      // Label 322: @13644
      GIM_Try, /*On fail goto*//*Label 323*/ GIMT_Encode4(13782), // Rule ID 4977 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vA
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4977,
        GIR_EraseRootFromParent_Done,
      // Label 323: @13782
      GIM_Try, /*On fail goto*//*Label 324*/ GIMT_Encode4(13920), // Rule ID 4978 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vA
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4978,
        GIR_EraseRootFromParent_Done,
      // Label 324: @13920
      GIM_Try, /*On fail goto*//*Label 325*/ GIMT_Encode4(14058), // Rule ID 4985 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vC
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4985,
        GIR_EraseRootFromParent_Done,
      // Label 325: @14058
      GIM_Try, /*On fail goto*//*Label 326*/ GIMT_Encode4(14196), // Rule ID 4986 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vC
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4986,
        GIR_EraseRootFromParent_Done,
      // Label 326: @14196
      GIM_Try, /*On fail goto*//*Label 327*/ GIMT_Encode4(14334), // Rule ID 4987 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vB
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4987,
        GIR_EraseRootFromParent_Done,
      // Label 327: @14334
      GIM_Try, /*On fail goto*//*Label 328*/ GIMT_Encode4(14472), // Rule ID 4988 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vB
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4988,
        GIR_EraseRootFromParent_Done,
      // Label 328: @14472
      GIM_Try, /*On fail goto*//*Label 329*/ GIMT_Encode4(14610), // Rule ID 4989 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vA
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4989,
        GIR_EraseRootFromParent_Done,
      // Label 329: @14610
      GIM_Try, /*On fail goto*//*Label 330*/ GIMT_Encode4(14748), // Rule ID 4990 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vA
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4990,
        GIR_EraseRootFromParent_Done,
      // Label 330: @14748
      GIM_Try, /*On fail goto*//*Label 331*/ GIMT_Encode4(14886), // Rule ID 4997 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vC
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4997,
        GIR_EraseRootFromParent_Done,
      // Label 331: @14886
      GIM_Try, /*On fail goto*//*Label 332*/ GIMT_Encode4(15024), // Rule ID 4998 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vC
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4998,
        GIR_EraseRootFromParent_Done,
      // Label 332: @15024
      GIM_Try, /*On fail goto*//*Label 333*/ GIMT_Encode4(15162), // Rule ID 4999 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vB
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4999,
        GIR_EraseRootFromParent_Done,
      // Label 333: @15162
      GIM_Try, /*On fail goto*//*Label 334*/ GIMT_Encode4(15300), // Rule ID 5000 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vB
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5000,
        GIR_EraseRootFromParent_Done,
      // Label 334: @15300
      GIM_Try, /*On fail goto*//*Label 335*/ GIMT_Encode4(15438), // Rule ID 5001 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vA
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5001,
        GIR_EraseRootFromParent_Done,
      // Label 335: @15438
      GIM_Try, /*On fail goto*//*Label 336*/ GIMT_Encode4(15576), // Rule ID 5002 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vA
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5002,
        GIR_EraseRootFromParent_Done,
      // Label 336: @15576
      GIM_Try, /*On fail goto*//*Label 337*/ GIMT_Encode4(15714), // Rule ID 5003 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[4] vC
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5003,
        GIR_EraseRootFromParent_Done,
      // Label 337: @15714
      GIM_Try, /*On fail goto*//*Label 338*/ GIMT_Encode4(15852), // Rule ID 5004 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[4] vC
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5004,
        GIR_EraseRootFromParent_Done,
      // Label 338: @15852
      GIM_Try, /*On fail goto*//*Label 339*/ GIMT_Encode4(15990), // Rule ID 5005 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[4] vB
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5005,
        GIR_EraseRootFromParent_Done,
      // Label 339: @15990
      GIM_Try, /*On fail goto*//*Label 340*/ GIMT_Encode4(16128), // Rule ID 5006 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[4] vB
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5006,
        GIR_EraseRootFromParent_Done,
      // Label 340: @16128
      GIM_Try, /*On fail goto*//*Label 341*/ GIMT_Encode4(16266), // Rule ID 5007 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[4] vA
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5007,
        GIR_EraseRootFromParent_Done,
      // Label 341: @16266
      GIM_Try, /*On fail goto*//*Label 342*/ GIMT_Encode4(16404), // Rule ID 5008 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[4] vA
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5008,
        GIR_EraseRootFromParent_Done,
      // Label 342: @16404
      GIM_Try, /*On fail goto*//*Label 343*/ GIMT_Encode4(16542), // Rule ID 5015 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[4] vC
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5015,
        GIR_EraseRootFromParent_Done,
      // Label 343: @16542
      GIM_Try, /*On fail goto*//*Label 344*/ GIMT_Encode4(16680), // Rule ID 5016 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[4] vC
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5016,
        GIR_EraseRootFromParent_Done,
      // Label 344: @16680
      GIM_Try, /*On fail goto*//*Label 345*/ GIMT_Encode4(16818), // Rule ID 5017 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[4] vB
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5017,
        GIR_EraseRootFromParent_Done,
      // Label 345: @16818
      GIM_Try, /*On fail goto*//*Label 346*/ GIMT_Encode4(16956), // Rule ID 5018 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[4] vB
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5018,
        GIR_EraseRootFromParent_Done,
      // Label 346: @16956
      GIM_Try, /*On fail goto*//*Label 347*/ GIMT_Encode4(17094), // Rule ID 5019 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[4] vA
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5019,
        GIR_EraseRootFromParent_Done,
      // Label 347: @17094
      GIM_Try, /*On fail goto*//*Label 348*/ GIMT_Encode4(17232), // Rule ID 5020 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[4] vA
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5020,
        GIR_EraseRootFromParent_Done,
      // Label 348: @17232
      GIM_Try, /*On fail goto*//*Label 349*/ GIMT_Encode4(17370), // Rule ID 5027 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[4] vC
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5027,
        GIR_EraseRootFromParent_Done,
      // Label 349: @17370
      GIM_Try, /*On fail goto*//*Label 350*/ GIMT_Encode4(17508), // Rule ID 5028 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[4] vC
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5028,
        GIR_EraseRootFromParent_Done,
      // Label 350: @17508
      GIM_Try, /*On fail goto*//*Label 351*/ GIMT_Encode4(17646), // Rule ID 5029 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[4] vB
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5029,
        GIR_EraseRootFromParent_Done,
      // Label 351: @17646
      GIM_Try, /*On fail goto*//*Label 352*/ GIMT_Encode4(17784), // Rule ID 5030 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[4] vB
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5030,
        GIR_EraseRootFromParent_Done,
      // Label 352: @17784
      GIM_Try, /*On fail goto*//*Label 353*/ GIMT_Encode4(17922), // Rule ID 5031 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[4] vA
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5031,
        GIR_EraseRootFromParent_Done,
      // Label 353: @17922
      GIM_Try, /*On fail goto*//*Label 354*/ GIMT_Encode4(18060), // Rule ID 5032 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[4] vA
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5032,
        GIR_EraseRootFromParent_Done,
      // Label 354: @18060
      GIM_Try, /*On fail goto*//*Label 355*/ GIMT_Encode4(18198), // Rule ID 5039 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[4] vC
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5039,
        GIR_EraseRootFromParent_Done,
      // Label 355: @18198
      GIM_Try, /*On fail goto*//*Label 356*/ GIMT_Encode4(18336), // Rule ID 5040 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[4] vC
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5040,
        GIR_EraseRootFromParent_Done,
      // Label 356: @18336
      GIM_Try, /*On fail goto*//*Label 357*/ GIMT_Encode4(18474), // Rule ID 5041 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[4] vB
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5041,
        GIR_EraseRootFromParent_Done,
      // Label 357: @18474
      GIM_Try, /*On fail goto*//*Label 358*/ GIMT_Encode4(18612), // Rule ID 5042 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[4] vB
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5042,
        GIR_EraseRootFromParent_Done,
      // Label 358: @18612
      GIM_Try, /*On fail goto*//*Label 359*/ GIMT_Encode4(18750), // Rule ID 5043 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[4] vA
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5043,
        GIR_EraseRootFromParent_Done,
      // Label 359: @18750
      GIM_Try, /*On fail goto*//*Label 360*/ GIMT_Encode4(18888), // Rule ID 5044 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[4] vA
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5044,
        GIR_EraseRootFromParent_Done,
      // Label 360: @18888
      GIM_Try, /*On fail goto*//*Label 361*/ GIMT_Encode4(19026), // Rule ID 5051 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[4] vC
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5051,
        GIR_EraseRootFromParent_Done,
      // Label 361: @19026
      GIM_Try, /*On fail goto*//*Label 362*/ GIMT_Encode4(19164), // Rule ID 5052 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[4] vC
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5052,
        GIR_EraseRootFromParent_Done,
      // Label 362: @19164
      GIM_Try, /*On fail goto*//*Label 363*/ GIMT_Encode4(19302), // Rule ID 5053 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[4] vB
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5053,
        GIR_EraseRootFromParent_Done,
      // Label 363: @19302
      GIM_Try, /*On fail goto*//*Label 364*/ GIMT_Encode4(19440), // Rule ID 5054 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[4] vB
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5054,
        GIR_EraseRootFromParent_Done,
      // Label 364: @19440
      GIM_Try, /*On fail goto*//*Label 365*/ GIMT_Encode4(19578), // Rule ID 5055 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[4] vA
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5055,
        GIR_EraseRootFromParent_Done,
      // Label 365: @19578
      GIM_Try, /*On fail goto*//*Label 366*/ GIMT_Encode4(19716), // Rule ID 5056 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[4] vA
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5056,
        GIR_EraseRootFromParent_Done,
      // Label 366: @19716
      GIM_Try, /*On fail goto*//*Label 367*/ GIMT_Encode4(19854), // Rule ID 5062 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[4] vC
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5062,
        GIR_EraseRootFromParent_Done,
      // Label 367: @19854
      GIM_Try, /*On fail goto*//*Label 368*/ GIMT_Encode4(19992), // Rule ID 5063 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[4] vC
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5063,
        GIR_EraseRootFromParent_Done,
      // Label 368: @19992
      GIM_Try, /*On fail goto*//*Label 369*/ GIMT_Encode4(20130), // Rule ID 5064 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[4] vB
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5064,
        GIR_EraseRootFromParent_Done,
      // Label 369: @20130
      GIM_Try, /*On fail goto*//*Label 370*/ GIMT_Encode4(20268), // Rule ID 5065 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[4] vB
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5065,
        GIR_EraseRootFromParent_Done,
      // Label 370: @20268
      GIM_Try, /*On fail goto*//*Label 371*/ GIMT_Encode4(20406), // Rule ID 5066 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[4] vA
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5066,
        GIR_EraseRootFromParent_Done,
      // Label 371: @20406
      GIM_Try, /*On fail goto*//*Label 372*/ GIMT_Encode4(20544), // Rule ID 5067 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[4] vA
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5067,
        GIR_EraseRootFromParent_Done,
      // Label 372: @20544
      GIM_Try, /*On fail goto*//*Label 373*/ GIMT_Encode4(20682), // Rule ID 3387 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vA
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3387,
        GIR_EraseRootFromParent_Done,
      // Label 373: @20682
      GIM_Try, /*On fail goto*//*Label 374*/ GIMT_Encode4(20820), // Rule ID 5009 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vC
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5009,
        GIR_EraseRootFromParent_Done,
      // Label 374: @20820
      GIM_Try, /*On fail goto*//*Label 375*/ GIMT_Encode4(20958), // Rule ID 5010 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vC
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5010,
        GIR_EraseRootFromParent_Done,
      // Label 375: @20958
      GIM_Try, /*On fail goto*//*Label 376*/ GIMT_Encode4(21096), // Rule ID 5011 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vB
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5011,
        GIR_EraseRootFromParent_Done,
      // Label 376: @21096
      GIM_Try, /*On fail goto*//*Label 377*/ GIMT_Encode4(21234), // Rule ID 5012 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vB
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5012,
        GIR_EraseRootFromParent_Done,
      // Label 377: @21234
      GIM_Try, /*On fail goto*//*Label 378*/ GIMT_Encode4(21372), // Rule ID 5013 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vA
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5013,
        GIR_EraseRootFromParent_Done,
      // Label 378: @21372
      GIM_Try, /*On fail goto*//*Label 379*/ GIMT_Encode4(21510), // Rule ID 5014 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vA
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5014,
        GIR_EraseRootFromParent_Done,
      // Label 379: @21510
      GIM_Try, /*On fail goto*//*Label 380*/ GIMT_Encode4(21648), // Rule ID 5021 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vC
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5021,
        GIR_EraseRootFromParent_Done,
      // Label 380: @21648
      GIM_Try, /*On fail goto*//*Label 381*/ GIMT_Encode4(21786), // Rule ID 5022 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vC
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5022,
        GIR_EraseRootFromParent_Done,
      // Label 381: @21786
      GIM_Try, /*On fail goto*//*Label 382*/ GIMT_Encode4(21924), // Rule ID 5023 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vB
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5023,
        GIR_EraseRootFromParent_Done,
      // Label 382: @21924
      GIM_Try, /*On fail goto*//*Label 383*/ GIMT_Encode4(22062), // Rule ID 5024 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vB
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5024,
        GIR_EraseRootFromParent_Done,
      // Label 383: @22062
      GIM_Try, /*On fail goto*//*Label 384*/ GIMT_Encode4(22200), // Rule ID 5025 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vA
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5025,
        GIR_EraseRootFromParent_Done,
      // Label 384: @22200
      GIM_Try, /*On fail goto*//*Label 385*/ GIMT_Encode4(22338), // Rule ID 5026 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vA
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5026,
        GIR_EraseRootFromParent_Done,
      // Label 385: @22338
      GIM_Try, /*On fail goto*//*Label 386*/ GIMT_Encode4(22476), // Rule ID 5033 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vC
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5033,
        GIR_EraseRootFromParent_Done,
      // Label 386: @22476
      GIM_Try, /*On fail goto*//*Label 387*/ GIMT_Encode4(22614), // Rule ID 5034 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vC
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5034,
        GIR_EraseRootFromParent_Done,
      // Label 387: @22614
      GIM_Try, /*On fail goto*//*Label 388*/ GIMT_Encode4(22752), // Rule ID 5035 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vB
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5035,
        GIR_EraseRootFromParent_Done,
      // Label 388: @22752
      GIM_Try, /*On fail goto*//*Label 389*/ GIMT_Encode4(22890), // Rule ID 5036 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vB
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5036,
        GIR_EraseRootFromParent_Done,
      // Label 389: @22890
      GIM_Try, /*On fail goto*//*Label 390*/ GIMT_Encode4(23028), // Rule ID 5037 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vA
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5037,
        GIR_EraseRootFromParent_Done,
      // Label 390: @23028
      GIM_Try, /*On fail goto*//*Label 391*/ GIMT_Encode4(23166), // Rule ID 5038 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vA
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5038,
        GIR_EraseRootFromParent_Done,
      // Label 391: @23166
      GIM_Try, /*On fail goto*//*Label 392*/ GIMT_Encode4(23304), // Rule ID 5045 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vC
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5045,
        GIR_EraseRootFromParent_Done,
      // Label 392: @23304
      GIM_Try, /*On fail goto*//*Label 393*/ GIMT_Encode4(23442), // Rule ID 5046 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vC
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5046,
        GIR_EraseRootFromParent_Done,
      // Label 393: @23442
      GIM_Try, /*On fail goto*//*Label 394*/ GIMT_Encode4(23580), // Rule ID 5047 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vB
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5047,
        GIR_EraseRootFromParent_Done,
      // Label 394: @23580
      GIM_Try, /*On fail goto*//*Label 395*/ GIMT_Encode4(23718), // Rule ID 5048 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vB
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5048,
        GIR_EraseRootFromParent_Done,
      // Label 395: @23718
      GIM_Try, /*On fail goto*//*Label 396*/ GIMT_Encode4(23856), // Rule ID 5049 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vA
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5049,
        GIR_EraseRootFromParent_Done,
      // Label 396: @23856
      GIM_Try, /*On fail goto*//*Label 397*/ GIMT_Encode4(23994), // Rule ID 5050 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vA
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5050,
        GIR_EraseRootFromParent_Done,
      // Label 397: @23994
      GIM_Try, /*On fail goto*//*Label 398*/ GIMT_Encode4(24132), // Rule ID 5057 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vC
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5057,
        GIR_EraseRootFromParent_Done,
      // Label 398: @24132
      GIM_Try, /*On fail goto*//*Label 399*/ GIMT_Encode4(24270), // Rule ID 5058 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vC
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5058,
        GIR_EraseRootFromParent_Done,
      // Label 399: @24270
      GIM_Try, /*On fail goto*//*Label 400*/ GIMT_Encode4(24408), // Rule ID 5059 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vB
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5059,
        GIR_EraseRootFromParent_Done,
      // Label 400: @24408
      GIM_Try, /*On fail goto*//*Label 401*/ GIMT_Encode4(24546), // Rule ID 5060 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vB
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5060,
        GIR_EraseRootFromParent_Done,
      // Label 401: @24546
      GIM_Try, /*On fail goto*//*Label 402*/ GIMT_Encode4(24684), // Rule ID 5061 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vA
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5061,
        GIR_EraseRootFromParent_Done,
      // Label 402: @24684
      GIM_Try, /*On fail goto*//*Label 403*/ GIMT_Encode4(24822), // Rule ID 5068 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vC
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5068,
        GIR_EraseRootFromParent_Done,
      // Label 403: @24822
      GIM_Try, /*On fail goto*//*Label 404*/ GIMT_Encode4(24960), // Rule ID 5069 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vC
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5069,
        GIR_EraseRootFromParent_Done,
      // Label 404: @24960
      GIM_Try, /*On fail goto*//*Label 405*/ GIMT_Encode4(25098), // Rule ID 5070 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vB
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5070,
        GIR_EraseRootFromParent_Done,
      // Label 405: @25098
      GIM_Try, /*On fail goto*//*Label 406*/ GIMT_Encode4(25236), // Rule ID 5071 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vB
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5071,
        GIR_EraseRootFromParent_Done,
      // Label 406: @25236
      GIM_Try, /*On fail goto*//*Label 407*/ GIMT_Encode4(25374), // Rule ID 5072 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vA
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5072,
        GIR_EraseRootFromParent_Done,
      // Label 407: @25374
      GIM_Try, /*On fail goto*//*Label 408*/ GIMT_Encode4(25512), // Rule ID 5073 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] vA
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5073,
        GIR_EraseRootFromParent_Done,
      // Label 408: @25512
      GIM_Try, /*On fail goto*//*Label 409*/ GIMT_Encode4(25650), // Rule ID 5074 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5074,
        GIR_EraseRootFromParent_Done,
      // Label 409: @25650
      GIM_Try, /*On fail goto*//*Label 410*/ GIMT_Encode4(25788), // Rule ID 5075 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5075,
        GIR_EraseRootFromParent_Done,
      // Label 410: @25788
      GIM_Try, /*On fail goto*//*Label 411*/ GIMT_Encode4(25926), // Rule ID 5076 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5076,
        GIR_EraseRootFromParent_Done,
      // Label 411: @25926
      GIM_Try, /*On fail goto*//*Label 412*/ GIMT_Encode4(26064), // Rule ID 5077 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5077,
        GIR_EraseRootFromParent_Done,
      // Label 412: @26064
      GIM_Try, /*On fail goto*//*Label 413*/ GIMT_Encode4(26202), // Rule ID 5078 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5078,
        GIR_EraseRootFromParent_Done,
      // Label 413: @26202
      GIM_Try, /*On fail goto*//*Label 414*/ GIMT_Encode4(26340), // Rule ID 5079 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5079,
        GIR_EraseRootFromParent_Done,
      // Label 414: @26340
      GIM_Try, /*On fail goto*//*Label 415*/ GIMT_Encode4(26478), // Rule ID 5086 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5086,
        GIR_EraseRootFromParent_Done,
      // Label 415: @26478
      GIM_Try, /*On fail goto*//*Label 416*/ GIMT_Encode4(26616), // Rule ID 5087 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5087,
        GIR_EraseRootFromParent_Done,
      // Label 416: @26616
      GIM_Try, /*On fail goto*//*Label 417*/ GIMT_Encode4(26754), // Rule ID 5088 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5088,
        GIR_EraseRootFromParent_Done,
      // Label 417: @26754
      GIM_Try, /*On fail goto*//*Label 418*/ GIMT_Encode4(26892), // Rule ID 5089 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5089,
        GIR_EraseRootFromParent_Done,
      // Label 418: @26892
      GIM_Try, /*On fail goto*//*Label 419*/ GIMT_Encode4(27030), // Rule ID 5090 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5090,
        GIR_EraseRootFromParent_Done,
      // Label 419: @27030
      GIM_Try, /*On fail goto*//*Label 420*/ GIMT_Encode4(27168), // Rule ID 5091 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5091,
        GIR_EraseRootFromParent_Done,
      // Label 420: @27168
      GIM_Try, /*On fail goto*//*Label 421*/ GIMT_Encode4(27306), // Rule ID 5098 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5098,
        GIR_EraseRootFromParent_Done,
      // Label 421: @27306
      GIM_Try, /*On fail goto*//*Label 422*/ GIMT_Encode4(27444), // Rule ID 5099 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5099,
        GIR_EraseRootFromParent_Done,
      // Label 422: @27444
      GIM_Try, /*On fail goto*//*Label 423*/ GIMT_Encode4(27582), // Rule ID 5100 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5100,
        GIR_EraseRootFromParent_Done,
      // Label 423: @27582
      GIM_Try, /*On fail goto*//*Label 424*/ GIMT_Encode4(27720), // Rule ID 5101 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5101,
        GIR_EraseRootFromParent_Done,
      // Label 424: @27720
      GIM_Try, /*On fail goto*//*Label 425*/ GIMT_Encode4(27858), // Rule ID 5102 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5102,
        GIR_EraseRootFromParent_Done,
      // Label 425: @27858
      GIM_Try, /*On fail goto*//*Label 426*/ GIMT_Encode4(27996), // Rule ID 5103 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5103,
        GIR_EraseRootFromParent_Done,
      // Label 426: @27996
      GIM_Try, /*On fail goto*//*Label 427*/ GIMT_Encode4(28134), // Rule ID 5110 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5110,
        GIR_EraseRootFromParent_Done,
      // Label 427: @28134
      GIM_Try, /*On fail goto*//*Label 428*/ GIMT_Encode4(28272), // Rule ID 5111 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5111,
        GIR_EraseRootFromParent_Done,
      // Label 428: @28272
      GIM_Try, /*On fail goto*//*Label 429*/ GIMT_Encode4(28410), // Rule ID 5112 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5112,
        GIR_EraseRootFromParent_Done,
      // Label 429: @28410
      GIM_Try, /*On fail goto*//*Label 430*/ GIMT_Encode4(28548), // Rule ID 5113 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5113,
        GIR_EraseRootFromParent_Done,
      // Label 430: @28548
      GIM_Try, /*On fail goto*//*Label 431*/ GIMT_Encode4(28686), // Rule ID 5114 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5114,
        GIR_EraseRootFromParent_Done,
      // Label 431: @28686
      GIM_Try, /*On fail goto*//*Label 432*/ GIMT_Encode4(28824), // Rule ID 5115 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5115,
        GIR_EraseRootFromParent_Done,
      // Label 432: @28824
      GIM_Try, /*On fail goto*//*Label 433*/ GIMT_Encode4(28962), // Rule ID 5122 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5122,
        GIR_EraseRootFromParent_Done,
      // Label 433: @28962
      GIM_Try, /*On fail goto*//*Label 434*/ GIMT_Encode4(29100), // Rule ID 5123 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5123,
        GIR_EraseRootFromParent_Done,
      // Label 434: @29100
      GIM_Try, /*On fail goto*//*Label 435*/ GIMT_Encode4(29238), // Rule ID 5124 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5124,
        GIR_EraseRootFromParent_Done,
      // Label 435: @29238
      GIM_Try, /*On fail goto*//*Label 436*/ GIMT_Encode4(29376), // Rule ID 5125 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5125,
        GIR_EraseRootFromParent_Done,
      // Label 436: @29376
      GIM_Try, /*On fail goto*//*Label 437*/ GIMT_Encode4(29514), // Rule ID 5126 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5126,
        GIR_EraseRootFromParent_Done,
      // Label 437: @29514
      GIM_Try, /*On fail goto*//*Label 438*/ GIMT_Encode4(29652), // Rule ID 5127 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5127,
        GIR_EraseRootFromParent_Done,
      // Label 438: @29652
      GIM_Try, /*On fail goto*//*Label 439*/ GIMT_Encode4(29790), // Rule ID 5134 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5134,
        GIR_EraseRootFromParent_Done,
      // Label 439: @29790
      GIM_Try, /*On fail goto*//*Label 440*/ GIMT_Encode4(29928), // Rule ID 5135 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5135,
        GIR_EraseRootFromParent_Done,
      // Label 440: @29928
      GIM_Try, /*On fail goto*//*Label 441*/ GIMT_Encode4(30066), // Rule ID 5136 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5136,
        GIR_EraseRootFromParent_Done,
      // Label 441: @30066
      GIM_Try, /*On fail goto*//*Label 442*/ GIMT_Encode4(30204), // Rule ID 5137 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5137,
        GIR_EraseRootFromParent_Done,
      // Label 442: @30204
      GIM_Try, /*On fail goto*//*Label 443*/ GIMT_Encode4(30342), // Rule ID 5138 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5138,
        GIR_EraseRootFromParent_Done,
      // Label 443: @30342
      GIM_Try, /*On fail goto*//*Label 444*/ GIMT_Encode4(30480), // Rule ID 5139 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5139,
        GIR_EraseRootFromParent_Done,
      // Label 444: @30480
      GIM_Try, /*On fail goto*//*Label 445*/ GIMT_Encode4(30618), // Rule ID 5080 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5080,
        GIR_EraseRootFromParent_Done,
      // Label 445: @30618
      GIM_Try, /*On fail goto*//*Label 446*/ GIMT_Encode4(30756), // Rule ID 5081 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5081,
        GIR_EraseRootFromParent_Done,
      // Label 446: @30756
      GIM_Try, /*On fail goto*//*Label 447*/ GIMT_Encode4(30894), // Rule ID 5082 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5082,
        GIR_EraseRootFromParent_Done,
      // Label 447: @30894
      GIM_Try, /*On fail goto*//*Label 448*/ GIMT_Encode4(31032), // Rule ID 5083 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5083,
        GIR_EraseRootFromParent_Done,
      // Label 448: @31032
      GIM_Try, /*On fail goto*//*Label 449*/ GIMT_Encode4(31170), // Rule ID 5084 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5084,
        GIR_EraseRootFromParent_Done,
      // Label 449: @31170
      GIM_Try, /*On fail goto*//*Label 450*/ GIMT_Encode4(31308), // Rule ID 5085 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5085,
        GIR_EraseRootFromParent_Done,
      // Label 450: @31308
      GIM_Try, /*On fail goto*//*Label 451*/ GIMT_Encode4(31446), // Rule ID 5092 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5092,
        GIR_EraseRootFromParent_Done,
      // Label 451: @31446
      GIM_Try, /*On fail goto*//*Label 452*/ GIMT_Encode4(31584), // Rule ID 5093 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5093,
        GIR_EraseRootFromParent_Done,
      // Label 452: @31584
      GIM_Try, /*On fail goto*//*Label 453*/ GIMT_Encode4(31722), // Rule ID 5094 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5094,
        GIR_EraseRootFromParent_Done,
      // Label 453: @31722
      GIM_Try, /*On fail goto*//*Label 454*/ GIMT_Encode4(31860), // Rule ID 5095 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5095,
        GIR_EraseRootFromParent_Done,
      // Label 454: @31860
      GIM_Try, /*On fail goto*//*Label 455*/ GIMT_Encode4(31998), // Rule ID 5096 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5096,
        GIR_EraseRootFromParent_Done,
      // Label 455: @31998
      GIM_Try, /*On fail goto*//*Label 456*/ GIMT_Encode4(32136), // Rule ID 5097 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5097,
        GIR_EraseRootFromParent_Done,
      // Label 456: @32136
      GIM_Try, /*On fail goto*//*Label 457*/ GIMT_Encode4(32274), // Rule ID 5104 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5104,
        GIR_EraseRootFromParent_Done,
      // Label 457: @32274
      GIM_Try, /*On fail goto*//*Label 458*/ GIMT_Encode4(32412), // Rule ID 5105 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5105,
        GIR_EraseRootFromParent_Done,
      // Label 458: @32412
      GIM_Try, /*On fail goto*//*Label 459*/ GIMT_Encode4(32550), // Rule ID 5106 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5106,
        GIR_EraseRootFromParent_Done,
      // Label 459: @32550
      GIM_Try, /*On fail goto*//*Label 460*/ GIMT_Encode4(32688), // Rule ID 5107 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5107,
        GIR_EraseRootFromParent_Done,
      // Label 460: @32688
      GIM_Try, /*On fail goto*//*Label 461*/ GIMT_Encode4(32826), // Rule ID 5108 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5108,
        GIR_EraseRootFromParent_Done,
      // Label 461: @32826
      GIM_Try, /*On fail goto*//*Label 462*/ GIMT_Encode4(32964), // Rule ID 5109 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5109,
        GIR_EraseRootFromParent_Done,
      // Label 462: @32964
      GIM_Try, /*On fail goto*//*Label 463*/ GIMT_Encode4(33102), // Rule ID 5116 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5116,
        GIR_EraseRootFromParent_Done,
      // Label 463: @33102
      GIM_Try, /*On fail goto*//*Label 464*/ GIMT_Encode4(33240), // Rule ID 5117 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5117,
        GIR_EraseRootFromParent_Done,
      // Label 464: @33240
      GIM_Try, /*On fail goto*//*Label 465*/ GIMT_Encode4(33378), // Rule ID 5118 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5118,
        GIR_EraseRootFromParent_Done,
      // Label 465: @33378
      GIM_Try, /*On fail goto*//*Label 466*/ GIMT_Encode4(33516), // Rule ID 5119 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5119,
        GIR_EraseRootFromParent_Done,
      // Label 466: @33516
      GIM_Try, /*On fail goto*//*Label 467*/ GIMT_Encode4(33654), // Rule ID 5120 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5120,
        GIR_EraseRootFromParent_Done,
      // Label 467: @33654
      GIM_Try, /*On fail goto*//*Label 468*/ GIMT_Encode4(33792), // Rule ID 5121 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5121,
        GIR_EraseRootFromParent_Done,
      // Label 468: @33792
      GIM_Try, /*On fail goto*//*Label 469*/ GIMT_Encode4(33930), // Rule ID 5128 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5128,
        GIR_EraseRootFromParent_Done,
      // Label 469: @33930
      GIM_Try, /*On fail goto*//*Label 470*/ GIMT_Encode4(34068), // Rule ID 5129 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5129,
        GIR_EraseRootFromParent_Done,
      // Label 470: @34068
      GIM_Try, /*On fail goto*//*Label 471*/ GIMT_Encode4(34206), // Rule ID 5130 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5130,
        GIR_EraseRootFromParent_Done,
      // Label 471: @34206
      GIM_Try, /*On fail goto*//*Label 472*/ GIMT_Encode4(34344), // Rule ID 5131 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5131,
        GIR_EraseRootFromParent_Done,
      // Label 472: @34344
      GIM_Try, /*On fail goto*//*Label 473*/ GIMT_Encode4(34482), // Rule ID 5132 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5132,
        GIR_EraseRootFromParent_Done,
      // Label 473: @34482
      GIM_Try, /*On fail goto*//*Label 474*/ GIMT_Encode4(34620), // Rule ID 5133 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5133,
        GIR_EraseRootFromParent_Done,
      // Label 474: @34620
      GIM_Try, /*On fail goto*//*Label 475*/ GIMT_Encode4(34758), // Rule ID 5140 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5140,
        GIR_EraseRootFromParent_Done,
      // Label 475: @34758
      GIM_Try, /*On fail goto*//*Label 476*/ GIMT_Encode4(34896), // Rule ID 5141 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5141,
        GIR_EraseRootFromParent_Done,
      // Label 476: @34896
      GIM_Try, /*On fail goto*//*Label 477*/ GIMT_Encode4(35034), // Rule ID 5142 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5142,
        GIR_EraseRootFromParent_Done,
      // Label 477: @35034
      GIM_Try, /*On fail goto*//*Label 478*/ GIMT_Encode4(35172), // Rule ID 5143 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5143,
        GIR_EraseRootFromParent_Done,
      // Label 478: @35172
      GIM_Try, /*On fail goto*//*Label 479*/ GIMT_Encode4(35310), // Rule ID 5144 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5144,
        GIR_EraseRootFromParent_Done,
      // Label 479: @35310
      GIM_Try, /*On fail goto*//*Label 480*/ GIMT_Encode4(35448), // Rule ID 5145 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5145,
        GIR_EraseRootFromParent_Done,
      // Label 480: @35448
      GIM_Try, /*On fail goto*//*Label 481*/ GIMT_Encode4(35586), // Rule ID 5146 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5146,
        GIR_EraseRootFromParent_Done,
      // Label 481: @35586
      GIM_Try, /*On fail goto*//*Label 482*/ GIMT_Encode4(35724), // Rule ID 5147 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5147,
        GIR_EraseRootFromParent_Done,
      // Label 482: @35724
      GIM_Try, /*On fail goto*//*Label 483*/ GIMT_Encode4(35862), // Rule ID 5148 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5148,
        GIR_EraseRootFromParent_Done,
      // Label 483: @35862
      GIM_Try, /*On fail goto*//*Label 484*/ GIMT_Encode4(36000), // Rule ID 5149 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5149,
        GIR_EraseRootFromParent_Done,
      // Label 484: @36000
      GIM_Try, /*On fail goto*//*Label 485*/ GIMT_Encode4(36138), // Rule ID 5150 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5150,
        GIR_EraseRootFromParent_Done,
      // Label 485: @36138
      GIM_Try, /*On fail goto*//*Label 486*/ GIMT_Encode4(36276), // Rule ID 5151 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5151,
        GIR_EraseRootFromParent_Done,
      // Label 486: @36276
      GIM_Try, /*On fail goto*//*Label 487*/ GIMT_Encode4(36414), // Rule ID 5158 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5158,
        GIR_EraseRootFromParent_Done,
      // Label 487: @36414
      GIM_Try, /*On fail goto*//*Label 488*/ GIMT_Encode4(36552), // Rule ID 5159 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5159,
        GIR_EraseRootFromParent_Done,
      // Label 488: @36552
      GIM_Try, /*On fail goto*//*Label 489*/ GIMT_Encode4(36690), // Rule ID 5160 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5160,
        GIR_EraseRootFromParent_Done,
      // Label 489: @36690
      GIM_Try, /*On fail goto*//*Label 490*/ GIMT_Encode4(36828), // Rule ID 5161 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5161,
        GIR_EraseRootFromParent_Done,
      // Label 490: @36828
      GIM_Try, /*On fail goto*//*Label 491*/ GIMT_Encode4(36966), // Rule ID 5162 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5162,
        GIR_EraseRootFromParent_Done,
      // Label 491: @36966
      GIM_Try, /*On fail goto*//*Label 492*/ GIMT_Encode4(37104), // Rule ID 5163 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5163,
        GIR_EraseRootFromParent_Done,
      // Label 492: @37104
      GIM_Try, /*On fail goto*//*Label 493*/ GIMT_Encode4(37242), // Rule ID 5170 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5170,
        GIR_EraseRootFromParent_Done,
      // Label 493: @37242
      GIM_Try, /*On fail goto*//*Label 494*/ GIMT_Encode4(37380), // Rule ID 5171 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5171,
        GIR_EraseRootFromParent_Done,
      // Label 494: @37380
      GIM_Try, /*On fail goto*//*Label 495*/ GIMT_Encode4(37518), // Rule ID 5172 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5172,
        GIR_EraseRootFromParent_Done,
      // Label 495: @37518
      GIM_Try, /*On fail goto*//*Label 496*/ GIMT_Encode4(37656), // Rule ID 5173 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5173,
        GIR_EraseRootFromParent_Done,
      // Label 496: @37656
      GIM_Try, /*On fail goto*//*Label 497*/ GIMT_Encode4(37794), // Rule ID 5174 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5174,
        GIR_EraseRootFromParent_Done,
      // Label 497: @37794
      GIM_Try, /*On fail goto*//*Label 498*/ GIMT_Encode4(37932), // Rule ID 5175 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5175,
        GIR_EraseRootFromParent_Done,
      // Label 498: @37932
      GIM_Try, /*On fail goto*//*Label 499*/ GIMT_Encode4(38070), // Rule ID 5182 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5182,
        GIR_EraseRootFromParent_Done,
      // Label 499: @38070
      GIM_Try, /*On fail goto*//*Label 500*/ GIMT_Encode4(38208), // Rule ID 5183 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5183,
        GIR_EraseRootFromParent_Done,
      // Label 500: @38208
      GIM_Try, /*On fail goto*//*Label 501*/ GIMT_Encode4(38346), // Rule ID 5184 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5184,
        GIR_EraseRootFromParent_Done,
      // Label 501: @38346
      GIM_Try, /*On fail goto*//*Label 502*/ GIMT_Encode4(38484), // Rule ID 5185 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5185,
        GIR_EraseRootFromParent_Done,
      // Label 502: @38484
      GIM_Try, /*On fail goto*//*Label 503*/ GIMT_Encode4(38622), // Rule ID 5186 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5186,
        GIR_EraseRootFromParent_Done,
      // Label 503: @38622
      GIM_Try, /*On fail goto*//*Label 504*/ GIMT_Encode4(38760), // Rule ID 5187 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5187,
        GIR_EraseRootFromParent_Done,
      // Label 504: @38760
      GIM_Try, /*On fail goto*//*Label 505*/ GIMT_Encode4(38898), // Rule ID 5194 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5194,
        GIR_EraseRootFromParent_Done,
      // Label 505: @38898
      GIM_Try, /*On fail goto*//*Label 506*/ GIMT_Encode4(39036), // Rule ID 5195 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5195,
        GIR_EraseRootFromParent_Done,
      // Label 506: @39036
      GIM_Try, /*On fail goto*//*Label 507*/ GIMT_Encode4(39174), // Rule ID 5196 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5196,
        GIR_EraseRootFromParent_Done,
      // Label 507: @39174
      GIM_Try, /*On fail goto*//*Label 508*/ GIMT_Encode4(39312), // Rule ID 5197 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5197,
        GIR_EraseRootFromParent_Done,
      // Label 508: @39312
      GIM_Try, /*On fail goto*//*Label 509*/ GIMT_Encode4(39450), // Rule ID 5198 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5198,
        GIR_EraseRootFromParent_Done,
      // Label 509: @39450
      GIM_Try, /*On fail goto*//*Label 510*/ GIMT_Encode4(39588), // Rule ID 5199 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5199,
        GIR_EraseRootFromParent_Done,
      // Label 510: @39588
      GIM_Try, /*On fail goto*//*Label 511*/ GIMT_Encode4(39726), // Rule ID 5206 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5206,
        GIR_EraseRootFromParent_Done,
      // Label 511: @39726
      GIM_Try, /*On fail goto*//*Label 512*/ GIMT_Encode4(39864), // Rule ID 5207 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5207,
        GIR_EraseRootFromParent_Done,
      // Label 512: @39864
      GIM_Try, /*On fail goto*//*Label 513*/ GIMT_Encode4(40002), // Rule ID 5208 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5208,
        GIR_EraseRootFromParent_Done,
      // Label 513: @40002
      GIM_Try, /*On fail goto*//*Label 514*/ GIMT_Encode4(40140), // Rule ID 5209 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5209,
        GIR_EraseRootFromParent_Done,
      // Label 514: @40140
      GIM_Try, /*On fail goto*//*Label 515*/ GIMT_Encode4(40278), // Rule ID 5210 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5210,
        GIR_EraseRootFromParent_Done,
      // Label 515: @40278
      GIM_Try, /*On fail goto*//*Label 516*/ GIMT_Encode4(40416), // Rule ID 5211 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5211,
        GIR_EraseRootFromParent_Done,
      // Label 516: @40416
      GIM_Try, /*On fail goto*//*Label 517*/ GIMT_Encode4(40554), // Rule ID 5152 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5152,
        GIR_EraseRootFromParent_Done,
      // Label 517: @40554
      GIM_Try, /*On fail goto*//*Label 518*/ GIMT_Encode4(40692), // Rule ID 5153 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5153,
        GIR_EraseRootFromParent_Done,
      // Label 518: @40692
      GIM_Try, /*On fail goto*//*Label 519*/ GIMT_Encode4(40830), // Rule ID 5154 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5154,
        GIR_EraseRootFromParent_Done,
      // Label 519: @40830
      GIM_Try, /*On fail goto*//*Label 520*/ GIMT_Encode4(40968), // Rule ID 5155 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5155,
        GIR_EraseRootFromParent_Done,
      // Label 520: @40968
      GIM_Try, /*On fail goto*//*Label 521*/ GIMT_Encode4(41106), // Rule ID 5156 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5156,
        GIR_EraseRootFromParent_Done,
      // Label 521: @41106
      GIM_Try, /*On fail goto*//*Label 522*/ GIMT_Encode4(41244), // Rule ID 5157 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5157,
        GIR_EraseRootFromParent_Done,
      // Label 522: @41244
      GIM_Try, /*On fail goto*//*Label 523*/ GIMT_Encode4(41382), // Rule ID 5164 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5164,
        GIR_EraseRootFromParent_Done,
      // Label 523: @41382
      GIM_Try, /*On fail goto*//*Label 524*/ GIMT_Encode4(41520), // Rule ID 5165 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5165,
        GIR_EraseRootFromParent_Done,
      // Label 524: @41520
      GIM_Try, /*On fail goto*//*Label 525*/ GIMT_Encode4(41658), // Rule ID 5166 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5166,
        GIR_EraseRootFromParent_Done,
      // Label 525: @41658
      GIM_Try, /*On fail goto*//*Label 526*/ GIMT_Encode4(41796), // Rule ID 5167 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5167,
        GIR_EraseRootFromParent_Done,
      // Label 526: @41796
      GIM_Try, /*On fail goto*//*Label 527*/ GIMT_Encode4(41934), // Rule ID 5168 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5168,
        GIR_EraseRootFromParent_Done,
      // Label 527: @41934
      GIM_Try, /*On fail goto*//*Label 528*/ GIMT_Encode4(42072), // Rule ID 5169 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5169,
        GIR_EraseRootFromParent_Done,
      // Label 528: @42072
      GIM_Try, /*On fail goto*//*Label 529*/ GIMT_Encode4(42210), // Rule ID 5176 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5176,
        GIR_EraseRootFromParent_Done,
      // Label 529: @42210
      GIM_Try, /*On fail goto*//*Label 530*/ GIMT_Encode4(42348), // Rule ID 5177 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5177,
        GIR_EraseRootFromParent_Done,
      // Label 530: @42348
      GIM_Try, /*On fail goto*//*Label 531*/ GIMT_Encode4(42486), // Rule ID 5178 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5178,
        GIR_EraseRootFromParent_Done,
      // Label 531: @42486
      GIM_Try, /*On fail goto*//*Label 532*/ GIMT_Encode4(42624), // Rule ID 5179 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5179,
        GIR_EraseRootFromParent_Done,
      // Label 532: @42624
      GIM_Try, /*On fail goto*//*Label 533*/ GIMT_Encode4(42762), // Rule ID 5180 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5180,
        GIR_EraseRootFromParent_Done,
      // Label 533: @42762
      GIM_Try, /*On fail goto*//*Label 534*/ GIMT_Encode4(42900), // Rule ID 5181 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5181,
        GIR_EraseRootFromParent_Done,
      // Label 534: @42900
      GIM_Try, /*On fail goto*//*Label 535*/ GIMT_Encode4(43038), // Rule ID 5188 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5188,
        GIR_EraseRootFromParent_Done,
      // Label 535: @43038
      GIM_Try, /*On fail goto*//*Label 536*/ GIMT_Encode4(43176), // Rule ID 5189 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5189,
        GIR_EraseRootFromParent_Done,
      // Label 536: @43176
      GIM_Try, /*On fail goto*//*Label 537*/ GIMT_Encode4(43314), // Rule ID 5190 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5190,
        GIR_EraseRootFromParent_Done,
      // Label 537: @43314
      GIM_Try, /*On fail goto*//*Label 538*/ GIMT_Encode4(43452), // Rule ID 5191 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5191,
        GIR_EraseRootFromParent_Done,
      // Label 538: @43452
      GIM_Try, /*On fail goto*//*Label 539*/ GIMT_Encode4(43590), // Rule ID 5192 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5192,
        GIR_EraseRootFromParent_Done,
      // Label 539: @43590
      GIM_Try, /*On fail goto*//*Label 540*/ GIMT_Encode4(43728), // Rule ID 5193 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5193,
        GIR_EraseRootFromParent_Done,
      // Label 540: @43728
      GIM_Try, /*On fail goto*//*Label 541*/ GIMT_Encode4(43866), // Rule ID 5200 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5200,
        GIR_EraseRootFromParent_Done,
      // Label 541: @43866
      GIM_Try, /*On fail goto*//*Label 542*/ GIMT_Encode4(44004), // Rule ID 5201 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5201,
        GIR_EraseRootFromParent_Done,
      // Label 542: @44004
      GIM_Try, /*On fail goto*//*Label 543*/ GIMT_Encode4(44142), // Rule ID 5202 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5202,
        GIR_EraseRootFromParent_Done,
      // Label 543: @44142
      GIM_Try, /*On fail goto*//*Label 544*/ GIMT_Encode4(44280), // Rule ID 5203 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5203,
        GIR_EraseRootFromParent_Done,
      // Label 544: @44280
      GIM_Try, /*On fail goto*//*Label 545*/ GIMT_Encode4(44418), // Rule ID 5204 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5204,
        GIR_EraseRootFromParent_Done,
      // Label 545: @44418
      GIM_Try, /*On fail goto*//*Label 546*/ GIMT_Encode4(44556), // Rule ID 5205 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5205,
        GIR_EraseRootFromParent_Done,
      // Label 546: @44556
      GIM_Try, /*On fail goto*//*Label 547*/ GIMT_Encode4(44694), // Rule ID 5212 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5212,
        GIR_EraseRootFromParent_Done,
      // Label 547: @44694
      GIM_Try, /*On fail goto*//*Label 548*/ GIMT_Encode4(44832), // Rule ID 5213 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vC
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5213,
        GIR_EraseRootFromParent_Done,
      // Label 548: @44832
      GIM_Try, /*On fail goto*//*Label 549*/ GIMT_Encode4(44970), // Rule ID 5214 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5214,
        GIR_EraseRootFromParent_Done,
      // Label 549: @44970
      GIM_Try, /*On fail goto*//*Label 550*/ GIMT_Encode4(45108), // Rule ID 5215 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vB
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[6] vA
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5215,
        GIR_EraseRootFromParent_Done,
      // Label 550: @45108
      GIM_Try, /*On fail goto*//*Label 551*/ GIMT_Encode4(45246), // Rule ID 5216 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5216,
        GIR_EraseRootFromParent_Done,
      // Label 551: @45246
      GIM_Try, /*On fail goto*//*Label 552*/ GIMT_Encode4(45384), // Rule ID 5217 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
        GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[5] vA
        GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
        GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
        // MIs[6] vC
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        // MIs[6] vB
        GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/6,
        // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5217,
        GIR_EraseRootFromParent_Done,
      // Label 552: @45384
      GIM_Try, /*On fail goto*//*Label 553*/ GIMT_Encode4(45478), // Rule ID 4904 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] C
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$C, immAllOnesV:{ *:[v4i32] }), v4i32:{ *:[v4i32] }:$A), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$C, v4i32:{ *:[v4i32] }:$B))  =>  (XXSEL:{ *:[v4i32] } ?:{ *:[v4i32] }:$A, ?:{ *:[v4i32] }:$B, ?:{ *:[v4i32] }:$C)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXSEL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // A
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/2, // B
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // C
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4904,
        GIR_EraseRootFromParent_Done,
      // Label 553: @45478
      GIM_Try, /*On fail goto*//*Label 554*/ GIMT_Encode4(45572), // Rule ID 1578 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        // MIs[4] C
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$C, immAllOnesV:{ *:[v4i32] }), v4i32:{ *:[v4i32] }:$A), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$B, v4i32:{ *:[v4i32] }:$C))  =>  (XXSEL:{ *:[v4i32] } ?:{ *:[v4i32] }:$A, ?:{ *:[v4i32] }:$B, ?:{ *:[v4i32] }:$C)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXSEL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // A
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // B
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // C
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1578,
        GIR_EraseRootFromParent_Done,
      // Label 554: @45572
      GIM_Try, /*On fail goto*//*Label 555*/ GIMT_Encode4(45666), // Rule ID 4906 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[4] C
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$A, (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$C, immAllOnesV:{ *:[v4i32] })), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$C, v4i32:{ *:[v4i32] }:$B))  =>  (XXSEL:{ *:[v4i32] } ?:{ *:[v4i32] }:$A, ?:{ *:[v4i32] }:$B, ?:{ *:[v4i32] }:$C)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXSEL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // A
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/2, // B
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // C
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4906,
        GIR_EraseRootFromParent_Done,
      // Label 555: @45666
      GIM_Try, /*On fail goto*//*Label 556*/ GIMT_Encode4(45760), // Rule ID 4905 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
        // MIs[4] C
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$A, (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$C, immAllOnesV:{ *:[v4i32] })), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$B, v4i32:{ *:[v4i32] }:$C))  =>  (XXSEL:{ *:[v4i32] } ?:{ *:[v4i32] }:$A, ?:{ *:[v4i32] }:$B, ?:{ *:[v4i32] }:$C)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXSEL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // A
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // B
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // C
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4905,
        GIR_EraseRootFromParent_Done,
      // Label 556: @45760
      GIM_Try, /*On fail goto*//*Label 557*/ GIMT_Encode4(45854), // Rule ID 4907 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[3] C
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$B, v4i32:{ *:[v4i32] }:$C), (and:{ *:[v4i32] } (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$C, immAllOnesV:{ *:[v4i32] }), v4i32:{ *:[v4i32] }:$A))  =>  (XXSEL:{ *:[v4i32] } ?:{ *:[v4i32] }:$A, ?:{ *:[v4i32] }:$B, ?:{ *:[v4i32] }:$C)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXSEL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // A
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // B
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // C
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4907,
        GIR_EraseRootFromParent_Done,
      // Label 557: @45854
      GIM_Try, /*On fail goto*//*Label 558*/ GIMT_Encode4(45948), // Rule ID 4909 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[3] C
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$C, v4i32:{ *:[v4i32] }:$B), (and:{ *:[v4i32] } (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$C, immAllOnesV:{ *:[v4i32] }), v4i32:{ *:[v4i32] }:$A))  =>  (XXSEL:{ *:[v4i32] } ?:{ *:[v4i32] }:$A, ?:{ *:[v4i32] }:$B, ?:{ *:[v4i32] }:$C)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXSEL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // A
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // B
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // C
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4909,
        GIR_EraseRootFromParent_Done,
      // Label 558: @45948
      GIM_Try, /*On fail goto*//*Label 559*/ GIMT_Encode4(46042), // Rule ID 4908 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[3] C
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$B, v4i32:{ *:[v4i32] }:$C), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$A, (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$C, immAllOnesV:{ *:[v4i32] })))  =>  (XXSEL:{ *:[v4i32] } ?:{ *:[v4i32] }:$A, ?:{ *:[v4i32] }:$B, ?:{ *:[v4i32] }:$C)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXSEL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // A
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // B
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // C
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4908,
        GIR_EraseRootFromParent_Done,
      // Label 559: @46042
      GIM_Try, /*On fail goto*//*Label 560*/ GIMT_Encode4(46136), // Rule ID 4910 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
        // MIs[3] C
        GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$C, v4i32:{ *:[v4i32] }:$B), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$A, (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$C, immAllOnesV:{ *:[v4i32] })))  =>  (XXSEL:{ *:[v4i32] } ?:{ *:[v4i32] }:$A, ?:{ *:[v4i32] }:$B, ?:{ *:[v4i32] }:$C)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXSEL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // A
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // B
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // C
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4910,
        GIR_EraseRootFromParent_Done,
      // Label 560: @46136
      GIM_Try, /*On fail goto*//*Label 561*/ GIMT_Encode4(46223), // Rule ID 4930 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcodeIsEither, /*MI*/3, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 241:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vC
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(241),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4930,
        GIR_EraseRootFromParent_Done,
      // Label 561: @46223
      GIM_Try, /*On fail goto*//*Label 562*/ GIMT_Encode4(46308), // Rule ID 4924 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
        GIM_RecordInsn, /*Defin