#ifdef GET_MIMGBaseOpcode_DECL
enum MIMGBaseOpcode {
  IMAGE_ATOMIC_ADD = 0,
  IMAGE_ATOMIC_ADD_FLT = 1,
  IMAGE_ATOMIC_AND = 2,
  IMAGE_ATOMIC_CMPSWAP = 3,
  IMAGE_ATOMIC_DEC = 4,
  IMAGE_ATOMIC_FCMPSWAP = 5,
  IMAGE_ATOMIC_FMAX = 6,
  IMAGE_ATOMIC_FMIN = 7,
  IMAGE_ATOMIC_INC = 8,
  IMAGE_ATOMIC_MAX_FLT = 9,
  IMAGE_ATOMIC_MIN_FLT = 10,
  IMAGE_ATOMIC_OR = 11,
  IMAGE_ATOMIC_PK_ADD_BF16 = 12,
  IMAGE_ATOMIC_PK_ADD_F16 = 13,
  IMAGE_ATOMIC_RSUB = 14,
  IMAGE_ATOMIC_SMAX = 15,
  IMAGE_ATOMIC_SMIN = 16,
  IMAGE_ATOMIC_SUB = 17,
  IMAGE_ATOMIC_SWAP = 18,
  IMAGE_ATOMIC_UMAX = 19,
  IMAGE_ATOMIC_UMIN = 20,
  IMAGE_ATOMIC_XOR = 21,
  IMAGE_BVH64_INTERSECT_RAY = 22,
  IMAGE_BVH64_INTERSECT_RAY_a16 = 23,
  IMAGE_BVH_INTERSECT_RAY = 24,
  IMAGE_BVH_INTERSECT_RAY_a16 = 25,
  IMAGE_GATHER4 = 26,
  IMAGE_GATHER4H = 27,
  IMAGE_GATHER4_B = 28,
  IMAGE_GATHER4_B_CL = 29,
  IMAGE_GATHER4_B_CL_O = 30,
  IMAGE_GATHER4_B_O = 31,
  IMAGE_GATHER4_C = 32,
  IMAGE_GATHER4_CL = 33,
  IMAGE_GATHER4_CL_O = 34,
  IMAGE_GATHER4_C_B = 35,
  IMAGE_GATHER4_C_B_CL = 36,
  IMAGE_GATHER4_C_B_CL_O = 37,
  IMAGE_GATHER4_C_B_O = 38,
  IMAGE_GATHER4_C_CL = 39,
  IMAGE_GATHER4_C_CL_O = 40,
  IMAGE_GATHER4_C_L = 41,
  IMAGE_GATHER4_C_LZ = 42,
  IMAGE_GATHER4_C_LZ_O = 43,
  IMAGE_GATHER4_C_L_O = 44,
  IMAGE_GATHER4_C_O = 45,
  IMAGE_GATHER4_L = 46,
  IMAGE_GATHER4_LZ = 47,
  IMAGE_GATHER4_LZ_O = 48,
  IMAGE_GATHER4_L_O = 49,
  IMAGE_GATHER4_O = 50,
  IMAGE_GET_LOD = 51,
  IMAGE_GET_RESINFO = 52,
  IMAGE_LOAD = 53,
  IMAGE_LOAD_MIP = 54,
  IMAGE_LOAD_MIP_PCK = 55,
  IMAGE_LOAD_MIP_PCK_SGN = 56,
  IMAGE_LOAD_PCK = 57,
  IMAGE_LOAD_PCK_SGN = 58,
  IMAGE_MSAA_LOAD = 59,
  IMAGE_MSAA_LOAD_X = 60,
  IMAGE_SAMPLE = 61,
  IMAGE_SAMPLE_B = 62,
  IMAGE_SAMPLE_B_CL = 63,
  IMAGE_SAMPLE_B_CL_O = 64,
  IMAGE_SAMPLE_B_O = 65,
  IMAGE_SAMPLE_C = 66,
  IMAGE_SAMPLE_CD = 67,
  IMAGE_SAMPLE_CD_CL = 68,
  IMAGE_SAMPLE_CD_CL_G16 = 69,
  IMAGE_SAMPLE_CD_CL_O = 70,
  IMAGE_SAMPLE_CD_CL_O_G16 = 71,
  IMAGE_SAMPLE_CD_G16 = 72,
  IMAGE_SAMPLE_CD_O = 73,
  IMAGE_SAMPLE_CD_O_G16 = 74,
  IMAGE_SAMPLE_CL = 75,
  IMAGE_SAMPLE_CL_O = 76,
  IMAGE_SAMPLE_C_B = 77,
  IMAGE_SAMPLE_C_B_CL = 78,
  IMAGE_SAMPLE_C_B_CL_O = 79,
  IMAGE_SAMPLE_C_B_O = 80,
  IMAGE_SAMPLE_C_CD = 81,
  IMAGE_SAMPLE_C_CD_CL = 82,
  IMAGE_SAMPLE_C_CD_CL_G16 = 83,
  IMAGE_SAMPLE_C_CD_CL_O = 84,
  IMAGE_SAMPLE_C_CD_CL_O_G16 = 85,
  IMAGE_SAMPLE_C_CD_G16 = 86,
  IMAGE_SAMPLE_C_CD_O = 87,
  IMAGE_SAMPLE_C_CD_O_G16 = 88,
  IMAGE_SAMPLE_C_CL = 89,
  IMAGE_SAMPLE_C_CL_O = 90,
  IMAGE_SAMPLE_C_D = 91,
  IMAGE_SAMPLE_C_D_CL = 92,
  IMAGE_SAMPLE_C_D_CL_G16 = 93,
  IMAGE_SAMPLE_C_D_CL_O = 94,
  IMAGE_SAMPLE_C_D_CL_O_G16 = 95,
  IMAGE_SAMPLE_C_D_G16 = 96,
  IMAGE_SAMPLE_C_D_O = 97,
  IMAGE_SAMPLE_C_D_O_G16 = 98,
  IMAGE_SAMPLE_C_L = 99,
  IMAGE_SAMPLE_C_LZ = 100,
  IMAGE_SAMPLE_C_LZ_O = 101,
  IMAGE_SAMPLE_C_L_O = 102,
  IMAGE_SAMPLE_C_O = 103,
  IMAGE_SAMPLE_D = 104,
  IMAGE_SAMPLE_D_CL = 105,
  IMAGE_SAMPLE_D_CL_G16 = 106,
  IMAGE_SAMPLE_D_CL_O = 107,
  IMAGE_SAMPLE_D_CL_O_G16 = 108,
  IMAGE_SAMPLE_D_G16 = 109,
  IMAGE_SAMPLE_D_O = 110,
  IMAGE_SAMPLE_D_O_G16 = 111,
  IMAGE_SAMPLE_L = 112,
  IMAGE_SAMPLE_LZ = 113,
  IMAGE_SAMPLE_LZ_O = 114,
  IMAGE_SAMPLE_L_O = 115,
  IMAGE_SAMPLE_O = 116,
  IMAGE_STORE = 117,
  IMAGE_STORE_MIP = 118,
  IMAGE_STORE_MIP_PCK = 119,
  IMAGE_STORE_PCK = 120,
};
#endif

#ifdef GET_MIMGDim_DECL
enum MIMGDim {
  AMDGPUDim1D = 0,
  AMDGPUDim1DArray = 1,
  AMDGPUDim2D = 2,
  AMDGPUDim2DArray = 3,
  AMDGPUDim2DArrayMsaa = 4,
  AMDGPUDim2DMsaa = 5,
  AMDGPUDim3D = 6,
  AMDGPUDimCube = 7,
};
#endif

#ifdef GET_MIMGEncoding_DECL
enum MIMGEncoding {
  MIMGEncGfx10Default = 0,
  MIMGEncGfx10NSA = 1,
  MIMGEncGfx11Default = 2,
  MIMGEncGfx11NSA = 3,
  MIMGEncGfx12 = 4,
  MIMGEncGfx6 = 5,
  MIMGEncGfx8 = 6,
  MIMGEncGfx90a = 7,
};
#endif

#ifdef GET_WMMAOpcode_DECL
enum WMMAOpcode {
  V_DOT2_F32_BF16 = 0,
  V_DOT2_F32_F16 = 1,
  V_DOT2_I32_I16 = 2,
  V_DOT2_U32_U16 = 3,
  V_DOT4_F32_BF8_BF8 = 4,
  V_DOT4_F32_BF8_FP8 = 5,
  V_DOT4_F32_FP8_BF8 = 6,
  V_DOT4_F32_FP8_FP8 = 7,
  V_DOT4_I32_I8 = 8,
  V_DOT4_I32_IU8 = 9,
  V_DOT4_U32_U8 = 10,
  V_DOT8_I32_I4 = 11,
  V_DOT8_I32_IU4 = 12,
  V_DOT8_U32_U4 = 13,
  V_FMA_MIXHI_F16 = 14,
  V_FMA_MIXLO_F16 = 15,
  V_FMA_MIX_F32 = 16,
  V_MAD_MIXHI_F16 = 17,
  V_MAD_MIXLO_F16 = 18,
  V_MAD_MIX_F32 = 19,
  V_PK_ADD_F16 = 20,
  V_PK_ADD_F32 = 21,
  V_PK_ADD_I16 = 22,
  V_PK_ADD_U16 = 23,
  V_PK_ASHRREV_I16 = 24,
  V_PK_FMA_F16 = 25,
  V_PK_FMA_F32 = 26,
  V_PK_LSHLREV_B16 = 27,
  V_PK_LSHRREV_B16 = 28,
  V_PK_MAD_I16 = 29,
  V_PK_MAD_U16 = 30,
  V_PK_MAXIMUM_F16 = 31,
  V_PK_MAX_F16 = 32,
  V_PK_MAX_I16 = 33,
  V_PK_MAX_U16 = 34,
  V_PK_MINIMUM_F16 = 35,
  V_PK_MIN_F16 = 36,
  V_PK_MIN_I16 = 37,
  V_PK_MIN_U16 = 38,
  V_PK_MOV_B32 = 39,
  V_PK_MUL_F16 = 40,
  V_PK_MUL_F32 = 41,
  V_PK_MUL_LO_U16 = 42,
  V_PK_SUB_I16 = 43,
  V_PK_SUB_U16 = 44,
  V_SWMMAC_BF16_16X16X32_BF16_w32_twoaddr = 45,
  V_SWMMAC_BF16_16X16X32_BF16_w64_twoaddr = 46,
  V_SWMMAC_F16_16X16X32_F16_w32_twoaddr = 47,
  V_SWMMAC_F16_16X16X32_F16_w64_twoaddr = 48,
  V_SWMMAC_F32_16X16X32_BF16_w32_twoaddr = 49,
  V_SWMMAC_F32_16X16X32_BF16_w64_twoaddr = 50,
  V_SWMMAC_F32_16X16X32_BF8_BF8_w32_twoaddr = 51,
  V_SWMMAC_F32_16X16X32_BF8_BF8_w64_twoaddr = 52,
  V_SWMMAC_F32_16X16X32_BF8_FP8_w32_twoaddr = 53,
  V_SWMMAC_F32_16X16X32_BF8_FP8_w64_twoaddr = 54,
  V_SWMMAC_F32_16X16X32_F16_w32_twoaddr = 55,
  V_SWMMAC_F32_16X16X32_F16_w64_twoaddr = 56,
  V_SWMMAC_F32_16X16X32_FP8_BF8_w32_twoaddr = 57,
  V_SWMMAC_F32_16X16X32_FP8_BF8_w64_twoaddr = 58,
  V_SWMMAC_F32_16X16X32_FP8_FP8_w32_twoaddr = 59,
  V_SWMMAC_F32_16X16X32_FP8_FP8_w64_twoaddr = 60,
  V_SWMMAC_I32_16X16X32_IU4_w32_twoaddr = 61,
  V_SWMMAC_I32_16X16X32_IU4_w64_twoaddr = 62,
  V_SWMMAC_I32_16X16X32_IU8_w32_twoaddr = 63,
  V_SWMMAC_I32_16X16X32_IU8_w64_twoaddr = 64,
  V_SWMMAC_I32_16X16X64_IU4_w32_twoaddr = 65,
  V_SWMMAC_I32_16X16X64_IU4_w64_twoaddr = 66,
  V_WMMA_BF16_16X16X16_BF16_TIED_twoaddr_w32 = 67,
  V_WMMA_BF16_16X16X16_BF16_TIED_twoaddr_w64 = 68,
  V_WMMA_BF16_16X16X16_BF16_threeaddr_w32 = 69,
  V_WMMA_BF16_16X16X16_BF16_threeaddr_w64 = 70,
  V_WMMA_BF16_16X16X16_BF16_twoaddr_w32 = 71,
  V_WMMA_BF16_16X16X16_BF16_twoaddr_w64 = 72,
  V_WMMA_BF16_16X16X16_BF16_w32_threeaddr = 73,
  V_WMMA_BF16_16X16X16_BF16_w32_twoaddr = 74,
  V_WMMA_BF16_16X16X16_BF16_w64_threeaddr = 75,
  V_WMMA_BF16_16X16X16_BF16_w64_twoaddr = 76,
  V_WMMA_F16_16X16X16_F16_TIED_twoaddr_w32 = 77,
  V_WMMA_F16_16X16X16_F16_TIED_twoaddr_w64 = 78,
  V_WMMA_F16_16X16X16_F16_threeaddr_w32 = 79,
  V_WMMA_F16_16X16X16_F16_threeaddr_w64 = 80,
  V_WMMA_F16_16X16X16_F16_twoaddr_w32 = 81,
  V_WMMA_F16_16X16X16_F16_twoaddr_w64 = 82,
  V_WMMA_F16_16X16X16_F16_w32_threeaddr = 83,
  V_WMMA_F16_16X16X16_F16_w32_twoaddr = 84,
  V_WMMA_F16_16X16X16_F16_w64_threeaddr = 85,
  V_WMMA_F16_16X16X16_F16_w64_twoaddr = 86,
  V_WMMA_F32_16X16X16_BF16_threeaddr_w32 = 87,
  V_WMMA_F32_16X16X16_BF16_threeaddr_w64 = 88,
  V_WMMA_F32_16X16X16_BF16_twoaddr_w32 = 89,
  V_WMMA_F32_16X16X16_BF16_twoaddr_w64 = 90,
  V_WMMA_F32_16X16X16_BF16_w32_threeaddr = 91,
  V_WMMA_F32_16X16X16_BF16_w32_twoaddr = 92,
  V_WMMA_F32_16X16X16_BF16_w64_threeaddr = 93,
  V_WMMA_F32_16X16X16_BF16_w64_twoaddr = 94,
  V_WMMA_F32_16X16X16_BF8_BF8_w32_threeaddr = 95,
  V_WMMA_F32_16X16X16_BF8_BF8_w32_twoaddr = 96,
  V_WMMA_F32_16X16X16_BF8_BF8_w64_threeaddr = 97,
  V_WMMA_F32_16X16X16_BF8_BF8_w64_twoaddr = 98,
  V_WMMA_F32_16X16X16_BF8_FP8_w32_threeaddr = 99,
  V_WMMA_F32_16X16X16_BF8_FP8_w32_twoaddr = 100,
  V_WMMA_F32_16X16X16_BF8_FP8_w64_threeaddr = 101,
  V_WMMA_F32_16X16X16_BF8_FP8_w64_twoaddr = 102,
  V_WMMA_F32_16X16X16_F16_threeaddr_w32 = 103,
  V_WMMA_F32_16X16X16_F16_threeaddr_w64 = 104,
  V_WMMA_F32_16X16X16_F16_twoaddr_w32 = 105,
  V_WMMA_F32_16X16X16_F16_twoaddr_w64 = 106,
  V_WMMA_F32_16X16X16_F16_w32_threeaddr = 107,
  V_WMMA_F32_16X16X16_F16_w32_twoaddr = 108,
  V_WMMA_F32_16X16X16_F16_w64_threeaddr = 109,
  V_WMMA_F32_16X16X16_F16_w64_twoaddr = 110,
  V_WMMA_F32_16X16X16_FP8_BF8_w32_threeaddr = 111,
  V_WMMA_F32_16X16X16_FP8_BF8_w32_twoaddr = 112,
  V_WMMA_F32_16X16X16_FP8_BF8_w64_threeaddr = 113,
  V_WMMA_F32_16X16X16_FP8_BF8_w64_twoaddr = 114,
  V_WMMA_F32_16X16X16_FP8_FP8_w32_threeaddr = 115,
  V_WMMA_F32_16X16X16_FP8_FP8_w32_twoaddr = 116,
  V_WMMA_F32_16X16X16_FP8_FP8_w64_threeaddr = 117,
  V_WMMA_F32_16X16X16_FP8_FP8_w64_twoaddr = 118,
  V_WMMA_I32_16X16X16_IU4_threeaddr_w32 = 119,
  V_WMMA_I32_16X16X16_IU4_threeaddr_w64 = 120,
  V_WMMA_I32_16X16X16_IU4_twoaddr_w32 = 121,
  V_WMMA_I32_16X16X16_IU4_twoaddr_w64 = 122,
  V_WMMA_I32_16X16X16_IU4_w32_threeaddr = 123,
  V_WMMA_I32_16X16X16_IU4_w32_twoaddr = 124,
  V_WMMA_I32_16X16X16_IU4_w64_threeaddr = 125,
  V_WMMA_I32_16X16X16_IU4_w64_twoaddr = 126,
  V_WMMA_I32_16X16X16_IU8_threeaddr_w32 = 127,
  V_WMMA_I32_16X16X16_IU8_threeaddr_w64 = 128,
  V_WMMA_I32_16X16X16_IU8_twoaddr_w32 = 129,
  V_WMMA_I32_16X16X16_IU8_twoaddr_w64 = 130,
  V_WMMA_I32_16X16X16_IU8_w32_threeaddr = 131,
  V_WMMA_I32_16X16X16_IU8_w32_twoaddr = 132,
  V_WMMA_I32_16X16X16_IU8_w64_threeaddr = 133,
  V_WMMA_I32_16X16X16_IU8_w64_twoaddr = 134,
  V_WMMA_I32_16X16X32_IU4_w32_threeaddr = 135,
  V_WMMA_I32_16X16X32_IU4_w32_twoaddr = 136,
  V_WMMA_I32_16X16X32_IU4_w64_threeaddr = 137,
  V_WMMA_I32_16X16X32_IU4_w64_twoaddr = 138,
};
#endif

#ifdef GET_Gfx9BufferFormat_DECL
const GcnBufferFormatInfo *getGfx9BufferFormatInfo(uint8_t BitsPerComp, uint8_t NumComponents, uint8_t NumFormat);
const GcnBufferFormatInfo *getGfx9BufferFormatInfo(uint8_t Format);
#endif

#ifdef GET_Gfx9BufferFormat_IMPL
constexpr GcnBufferFormatInfo Gfx9BufferFormat[] = {
  { 0x1, 0x8, 0x1, 0x0, 0x1 }, // 0
  { 0x11, 0x8, 0x1, 0x1, 0x1 }, // 1
  { 0x21, 0x8, 0x1, 0x2, 0x1 }, // 2
  { 0x31, 0x8, 0x1, 0x3, 0x1 }, // 3
  { 0x41, 0x8, 0x1, 0x4, 0x1 }, // 4
  { 0x51, 0x8, 0x1, 0x5, 0x1 }, // 5
  { 0x3, 0x8, 0x2, 0x0, 0x3 }, // 6
  { 0x13, 0x8, 0x2, 0x1, 0x3 }, // 7
  { 0x23, 0x8, 0x2, 0x2, 0x3 }, // 8
  { 0x33, 0x8, 0x2, 0x3, 0x3 }, // 9
  { 0x43, 0x8, 0x2, 0x4, 0x3 }, // 10
  { 0x53, 0x8, 0x2, 0x5, 0x3 }, // 11
  { 0xA, 0x8, 0x4, 0x0, 0xA }, // 12
  { 0x1A, 0x8, 0x4, 0x1, 0xA }, // 13
  { 0x2A, 0x8, 0x4, 0x2, 0xA }, // 14
  { 0x3A, 0x8, 0x4, 0x3, 0xA }, // 15
  { 0x4A, 0x8, 0x4, 0x4, 0xA }, // 16
  { 0x5A, 0x8, 0x4, 0x5, 0xA }, // 17
  { 0x2, 0x10, 0x1, 0x0, 0x2 }, // 18
  { 0x12, 0x10, 0x1, 0x1, 0x2 }, // 19
  { 0x22, 0x10, 0x1, 0x2, 0x2 }, // 20
  { 0x32, 0x10, 0x1, 0x3, 0x2 }, // 21
  { 0x42, 0x10, 0x1, 0x4, 0x2 }, // 22
  { 0x52, 0x10, 0x1, 0x5, 0x2 }, // 23
  { 0x72, 0x10, 0x1, 0x7, 0x2 }, // 24
  { 0x5, 0x10, 0x2, 0x0, 0x5 }, // 25
  { 0x15, 0x10, 0x2, 0x1, 0x5 }, // 26
  { 0x25, 0x10, 0x2, 0x2, 0x5 }, // 27
  { 0x35, 0x10, 0x2, 0x3, 0x5 }, // 28
  { 0x45, 0x10, 0x2, 0x4, 0x5 }, // 29
  { 0x55, 0x10, 0x2, 0x5, 0x5 }, // 30
  { 0x75, 0x10, 0x2, 0x7, 0x5 }, // 31
  { 0xC, 0x10, 0x4, 0x0, 0xC }, // 32
  { 0x1C, 0x10, 0x4, 0x1, 0xC }, // 33
  { 0x2C, 0x10, 0x4, 0x2, 0xC }, // 34
  { 0x3C, 0x10, 0x4, 0x3, 0xC }, // 35
  { 0x4C, 0x10, 0x4, 0x4, 0xC }, // 36
  { 0x5C, 0x10, 0x4, 0x5, 0xC }, // 37
  { 0x7C, 0x10, 0x4, 0x7, 0xC }, // 38
  { 0x44, 0x20, 0x1, 0x4, 0x4 }, // 39
  { 0x54, 0x20, 0x1, 0x5, 0x4 }, // 40
  { 0x74, 0x20, 0x1, 0x7, 0x4 }, // 41
  { 0x4B, 0x20, 0x2, 0x4, 0xB }, // 42
  { 0x5B, 0x20, 0x2, 0x5, 0xB }, // 43
  { 0x7B, 0x20, 0x2, 0x7, 0xB }, // 44
  { 0x4D, 0x20, 0x3, 0x4, 0xD }, // 45
  { 0x5D, 0x20, 0x3, 0x5, 0xD }, // 46
  { 0x7D, 0x20, 0x3, 0x7, 0xD }, // 47
  { 0x4E, 0x20, 0x4, 0x4, 0xE }, // 48
  { 0x5E, 0x20, 0x4, 0x5, 0xE }, // 49
  { 0x7E, 0x20, 0x4, 0x7, 0xE }, // 50
 };

const GcnBufferFormatInfo *getGfx9BufferFormatInfo(uint8_t BitsPerComp, uint8_t NumComponents, uint8_t NumFormat) {
  struct KeyType {
    uint8_t BitsPerComp;
    uint8_t NumComponents;
    uint8_t NumFormat;
  };
  KeyType Key = {BitsPerComp, NumComponents, NumFormat};
  auto Table = ArrayRef(Gfx9BufferFormat);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const GcnBufferFormatInfo &LHS, const KeyType &RHS) {
      if (LHS.BitsPerComp < RHS.BitsPerComp)
        return true;
      if (LHS.BitsPerComp > RHS.BitsPerComp)
        return false;
      if (LHS.NumComponents < RHS.NumComponents)
        return true;
      if (LHS.NumComponents > RHS.NumComponents)
        return false;
      if (LHS.NumFormat < RHS.NumFormat)
        return true;
      if (LHS.NumFormat > RHS.NumFormat)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.BitsPerComp != Idx->BitsPerComp ||
      Key.NumComponents != Idx->NumComponents ||
      Key.NumFormat != Idx->NumFormat)
    return nullptr;
  return &*Idx;
}

const GcnBufferFormatInfo *getGfx9BufferFormatInfo(uint8_t Format) {
  struct IndexType {
    uint8_t Format;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { 0x1, 0 },
    { 0x2, 18 },
    { 0x3, 6 },
    { 0x5, 25 },
    { 0xA, 12 },
    { 0xC, 32 },
    { 0x11, 1 },
    { 0x12, 19 },
    { 0x13, 7 },
    { 0x15, 26 },
    { 0x1A, 13 },
    { 0x1C, 33 },
    { 0x21, 2 },
    { 0x22, 20 },
    { 0x23, 8 },
    { 0x25, 27 },
    { 0x2A, 14 },
    { 0x2C, 34 },
    { 0x31, 3 },
    { 0x32, 21 },
    { 0x33, 9 },
    { 0x35, 28 },
    { 0x3A, 15 },
    { 0x3C, 35 },
    { 0x41, 4 },
    { 0x42, 22 },
    { 0x43, 10 },
    { 0x44, 39 },
    { 0x45, 29 },
    { 0x4A, 16 },
    { 0x4B, 42 },
    { 0x4C, 36 },
    { 0x4D, 45 },
    { 0x4E, 48 },
    { 0x51, 5 },
    { 0x52, 23 },
    { 0x53, 11 },
    { 0x54, 40 },
    { 0x55, 30 },
    { 0x5A, 17 },
    { 0x5B, 43 },
    { 0x5C, 37 },
    { 0x5D, 46 },
    { 0x5E, 49 },
    { 0x72, 24 },
    { 0x74, 41 },
    { 0x75, 31 },
    { 0x7B, 44 },
    { 0x7C, 38 },
    { 0x7D, 47 },
    { 0x7E, 50 },
  };

  struct KeyType {
    uint8_t Format;
  };
  KeyType Key = {Format};
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      if (LHS.Format < RHS.Format)
        return true;
      if (LHS.Format > RHS.Format)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Format != Idx->Format)
    return nullptr;
  return &Gfx9BufferFormat[Idx->_index];
}
#endif

#ifdef GET_Gfx10BufferFormat_DECL
const GcnBufferFormatInfo *getGfx10BufferFormatInfo(uint8_t BitsPerComp, uint8_t NumComponents, uint8_t NumFormat);
const GcnBufferFormatInfo *getGfx10BufferFormatInfo(uint8_t Format);
#endif

#ifdef GET_Gfx10BufferFormat_IMPL
constexpr GcnBufferFormatInfo Gfx10BufferFormat[] = {
  { 0x1, 0x8, 0x1, 0x0, 0x1 }, // 0
  { 0x2, 0x8, 0x1, 0x1, 0x1 }, // 1
  { 0x3, 0x8, 0x1, 0x2, 0x1 }, // 2
  { 0x4, 0x8, 0x1, 0x3, 0x1 }, // 3
  { 0x5, 0x8, 0x1, 0x4, 0x1 }, // 4
  { 0x6, 0x8, 0x1, 0x5, 0x1 }, // 5
  { 0xE, 0x8, 0x2, 0x0, 0x3 }, // 6
  { 0xF, 0x8, 0x2, 0x1, 0x3 }, // 7
  { 0x10, 0x8, 0x2, 0x2, 0x3 }, // 8
  { 0x11, 0x8, 0x2, 0x3, 0x3 }, // 9
  { 0x12, 0x8, 0x2, 0x4, 0x3 }, // 10
  { 0x13, 0x8, 0x2, 0x5, 0x3 }, // 11
  { 0x38, 0x8, 0x4, 0x0, 0xA }, // 12
  { 0x39, 0x8, 0x4, 0x1, 0xA }, // 13
  { 0x3A, 0x8, 0x4, 0x2, 0xA }, // 14
  { 0x3B, 0x8, 0x4, 0x3, 0xA }, // 15
  { 0x3C, 0x8, 0x4, 0x4, 0xA }, // 16
  { 0x3D, 0x8, 0x4, 0x5, 0xA }, // 17
  { 0x7, 0x10, 0x1, 0x0, 0x2 }, // 18
  { 0x8, 0x10, 0x1, 0x1, 0x2 }, // 19
  { 0x9, 0x10, 0x1, 0x2, 0x2 }, // 20
  { 0xA, 0x10, 0x1, 0x3, 0x2 }, // 21
  { 0xB, 0x10, 0x1, 0x4, 0x2 }, // 22
  { 0xC, 0x10, 0x1, 0x5, 0x2 }, // 23
  { 0xD, 0x10, 0x1, 0x7, 0x2 }, // 24
  { 0x17, 0x10, 0x2, 0x0, 0x5 }, // 25
  { 0x18, 0x10, 0x2, 0x1, 0x5 }, // 26
  { 0x19, 0x10, 0x2, 0x2, 0x5 }, // 27
  { 0x1A, 0x10, 0x2, 0x3, 0x5 }, // 28
  { 0x1B, 0x10, 0x2, 0x4, 0x5 }, // 29
  { 0x1C, 0x10, 0x2, 0x5, 0x5 }, // 30
  { 0x1D, 0x10, 0x2, 0x7, 0x5 }, // 31
  { 0x41, 0x10, 0x4, 0x0, 0xC }, // 32
  { 0x42, 0x10, 0x4, 0x1, 0xC }, // 33
  { 0x43, 0x10, 0x4, 0x2, 0xC }, // 34
  { 0x44, 0x10, 0x4, 0x3, 0xC }, // 35
  { 0x45, 0x10, 0x4, 0x4, 0xC }, // 36
  { 0x46, 0x10, 0x4, 0x5, 0xC }, // 37
  { 0x47, 0x10, 0x4, 0x7, 0xC }, // 38
  { 0x14, 0x20, 0x1, 0x4, 0x4 }, // 39
  { 0x15, 0x20, 0x1, 0x5, 0x4 }, // 40
  { 0x16, 0x20, 0x1, 0x7, 0x4 }, // 41
  { 0x3E, 0x20, 0x2, 0x4, 0xB }, // 42
  { 0x3F, 0x20, 0x2, 0x5, 0xB }, // 43
  { 0x40, 0x20, 0x2, 0x7, 0xB }, // 44
  { 0x48, 0x20, 0x3, 0x4, 0xD }, // 45
  { 0x49, 0x20, 0x3, 0x5, 0xD }, // 46
  { 0x4A, 0x20, 0x3, 0x7, 0xD }, // 47
  { 0x4B, 0x20, 0x4, 0x4, 0xE }, // 48
  { 0x4C, 0x20, 0x4, 0x5, 0xE }, // 49
  { 0x4D, 0x20, 0x4, 0x7, 0xE }, // 50
 };

const GcnBufferFormatInfo *getGfx10BufferFormatInfo(uint8_t BitsPerComp, uint8_t NumComponents, uint8_t NumFormat) {
  struct KeyType {
    uint8_t BitsPerComp;
    uint8_t NumComponents;
    uint8_t NumFormat;
  };
  KeyType Key = {BitsPerComp, NumComponents, NumFormat};
  auto Table = ArrayRef(Gfx10BufferFormat);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const GcnBufferFormatInfo &LHS, const KeyType &RHS) {
      if (LHS.BitsPerComp < RHS.BitsPerComp)
        return true;
      if (LHS.BitsPerComp > RHS.BitsPerComp)
        return false;
      if (LHS.NumComponents < RHS.NumComponents)
        return true;
      if (LHS.NumComponents > RHS.NumComponents)
        return false;
      if (LHS.NumFormat < RHS.NumFormat)
        return true;
      if (LHS.NumFormat > RHS.NumFormat)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.BitsPerComp != Idx->BitsPerComp ||
      Key.NumComponents != Idx->NumComponents ||
      Key.NumFormat != Idx->NumFormat)
    return nullptr;
  return &*Idx;
}

const GcnBufferFormatInfo *getGfx10BufferFormatInfo(uint8_t Format) {
  struct IndexType {
    uint8_t Format;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { 0x1, 0 },
    { 0x2, 1 },
    { 0x3, 2 },
    { 0x4, 3 },
    { 0x5, 4 },
    { 0x6, 5 },
    { 0x7, 18 },
    { 0x8, 19 },
    { 0x9, 20 },
    { 0xA, 21 },
    { 0xB, 22 },
    { 0xC, 23 },
    { 0xD, 24 },
    { 0xE, 6 },
    { 0xF, 7 },
    { 0x10, 8 },
    { 0x11, 9 },
    { 0x12, 10 },
    { 0x13, 11 },
    { 0x14, 39 },
    { 0x15, 40 },
    { 0x16, 41 },
    { 0x17, 25 },
    { 0x18, 26 },
    { 0x19, 27 },
    { 0x1A, 28 },
    { 0x1B, 29 },
    { 0x1C, 30 },
    { 0x1D, 31 },
    { 0x38, 12 },
    { 0x39, 13 },
    { 0x3A, 14 },
    { 0x3B, 15 },
    { 0x3C, 16 },
    { 0x3D, 17 },
    { 0x3E, 42 },
    { 0x3F, 43 },
    { 0x40, 44 },
    { 0x41, 32 },
    { 0x42, 33 },
    { 0x43, 34 },
    { 0x44, 35 },
    { 0x45, 36 },
    { 0x46, 37 },
    { 0x47, 38 },
    { 0x48, 45 },
    { 0x49, 46 },
    { 0x4A, 47 },
    { 0x4B, 48 },
    { 0x4C, 49 },
    { 0x4D, 50 },
  };

  struct KeyType {
    uint8_t Format;
  };
  KeyType Key = {Format};
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      if (LHS.Format < RHS.Format)
        return true;
      if (LHS.Format > RHS.Format)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Format != Idx->Format)
    return nullptr;
  return &Gfx10BufferFormat[Idx->_index];
}
#endif

#ifdef GET_Gfx11PlusBufferFormat_DECL
const GcnBufferFormatInfo *getGfx11PlusBufferFormatInfo(uint8_t BitsPerComp, uint8_t NumComponents, uint8_t NumFormat);
const GcnBufferFormatInfo *getGfx11PlusBufferFormatInfo(uint8_t Format);
#endif

#ifdef GET_Gfx11PlusBufferFormat_IMPL
constexpr GcnBufferFormatInfo Gfx11PlusBufferFormat[] = {
  { 0x1, 0x8, 0x1, 0x0, 0x1 }, // 0
  { 0x2, 0x8, 0x1, 0x1, 0x1 }, // 1
  { 0x3, 0x8, 0x1, 0x2, 0x1 }, // 2
  { 0x4, 0x8, 0x1, 0x3, 0x1 }, // 3
  { 0x5, 0x8, 0x1, 0x4, 0x1 }, // 4
  { 0x6, 0x8, 0x1, 0x5, 0x1 }, // 5
  { 0xE, 0x8, 0x2, 0x0, 0x3 }, // 6
  { 0xF, 0x8, 0x2, 0x1, 0x3 }, // 7
  { 0x10, 0x8, 0x2, 0x2, 0x3 }, // 8
  { 0x11, 0x8, 0x2, 0x3, 0x3 }, // 9
  { 0x12, 0x8, 0x2, 0x4, 0x3 }, // 10
  { 0x13, 0x8, 0x2, 0x5, 0x3 }, // 11
  { 0x2A, 0x8, 0x4, 0x0, 0xA }, // 12
  { 0x2B, 0x8, 0x4, 0x1, 0xA }, // 13
  { 0x2C, 0x8, 0x4, 0x2, 0xA }, // 14
  { 0x2D, 0x8, 0x4, 0x3, 0xA }, // 15
  { 0x2E, 0x8, 0x4, 0x4, 0xA }, // 16
  { 0x2F, 0x8, 0x4, 0x5, 0xA }, // 17
  { 0x7, 0x10, 0x1, 0x0, 0x2 }, // 18
  { 0x8, 0x10, 0x1, 0x1, 0x2 }, // 19
  { 0x9, 0x10, 0x1, 0x2, 0x2 }, // 20
  { 0xA, 0x10, 0x1, 0x3, 0x2 }, // 21
  { 0xB, 0x10, 0x1, 0x4, 0x2 }, // 22
  { 0xC, 0x10, 0x1, 0x5, 0x2 }, // 23
  { 0xD, 0x10, 0x1, 0x7, 0x2 }, // 24
  { 0x17, 0x10, 0x2, 0x0, 0x5 }, // 25
  { 0x18, 0x10, 0x2, 0x1, 0x5 }, // 26
  { 0x19, 0x10, 0x2, 0x2, 0x5 }, // 27
  { 0x1A, 0x10, 0x2, 0x3, 0x5 }, // 28
  { 0x1B, 0x10, 0x2, 0x4, 0x5 }, // 29
  { 0x1C, 0x10, 0x2, 0x5, 0x5 }, // 30
  { 0x1D, 0x10, 0x2, 0x7, 0x5 }, // 31
  { 0x33, 0x10, 0x4, 0x0, 0xC }, // 32
  { 0x34, 0x10, 0x4, 0x1, 0xC }, // 33
  { 0x35, 0x10, 0x4, 0x2, 0xC }, // 34
  { 0x36, 0x10, 0x4, 0x3, 0xC }, // 35
  { 0x37, 0x10, 0x4, 0x4, 0xC }, // 36
  { 0x38, 0x10, 0x4, 0x5, 0xC }, // 37
  { 0x39, 0x10, 0x4, 0x7, 0xC }, // 38
  { 0x14, 0x20, 0x1, 0x4, 0x4 }, // 39
  { 0x15, 0x20, 0x1, 0x5, 0x4 }, // 40
  { 0x16, 0x20, 0x1, 0x7, 0x4 }, // 41
  { 0x30, 0x20, 0x2, 0x4, 0xB }, // 42
  { 0x31, 0x20, 0x2, 0x5, 0xB }, // 43
  { 0x32, 0x20, 0x2, 0x7, 0xB }, // 44
  { 0x3A, 0x20, 0x3, 0x4, 0xD }, // 45
  { 0x3B, 0x20, 0x3, 0x5, 0xD }, // 46
  { 0x3C, 0x20, 0x3, 0x7, 0xD }, // 47
  { 0x3D, 0x20, 0x4, 0x4, 0xE }, // 48
  { 0x3E, 0x20, 0x4, 0x5, 0xE }, // 49
  { 0x3F, 0x20, 0x4, 0x7, 0xE }, // 50
 };

const GcnBufferFormatInfo *getGfx11PlusBufferFormatInfo(uint8_t BitsPerComp, uint8_t NumComponents, uint8_t NumFormat) {
  struct KeyType {
    uint8_t BitsPerComp;
    uint8_t NumComponents;
    uint8_t NumFormat;
  };
  KeyType Key = {BitsPerComp, NumComponents, NumFormat};
  auto Table = ArrayRef(Gfx11PlusBufferFormat);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const GcnBufferFormatInfo &LHS, const KeyType &RHS) {
      if (LHS.BitsPerComp < RHS.BitsPerComp)
        return true;
      if (LHS.BitsPerComp > RHS.BitsPerComp)
        return false;
      if (LHS.NumComponents < RHS.NumComponents)
        return true;
      if (LHS.NumComponents > RHS.NumComponents)
        return false;
      if (LHS.NumFormat < RHS.NumFormat)
        return true;
      if (LHS.NumFormat > RHS.NumFormat)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.BitsPerComp != Idx->BitsPerComp ||
      Key.NumComponents != Idx->NumComponents ||
      Key.NumFormat != Idx->NumFormat)
    return nullptr;
  return &*Idx;
}

const GcnBufferFormatInfo *getGfx11PlusBufferFormatInfo(uint8_t Format) {
  struct IndexType {
    uint8_t Format;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { 0x1, 0 },
    { 0x2, 1 },
    { 0x3, 2 },
    { 0x4, 3 },
    { 0x5, 4 },
    { 0x6, 5 },
    { 0x7, 18 },
    { 0x8, 19 },
    { 0x9, 20 },
    { 0xA, 21 },
    { 0xB, 22 },
    { 0xC, 23 },
    { 0xD, 24 },
    { 0xE, 6 },
    { 0xF, 7 },
    { 0x10, 8 },
    { 0x11, 9 },
    { 0x12, 10 },
    { 0x13, 11 },
    { 0x14, 39 },
    { 0x15, 40 },
    { 0x16, 41 },
    { 0x17, 25 },
    { 0x18, 26 },
    { 0x19, 27 },
    { 0x1A, 28 },
    { 0x1B, 29 },
    { 0x1C, 30 },
    { 0x1D, 31 },
    { 0x2A, 12 },
    { 0x2B, 13 },
    { 0x2C, 14 },
    { 0x2D, 15 },
    { 0x2E, 16 },
    { 0x2F, 17 },
    { 0x30, 42 },
    { 0x31, 43 },
    { 0x32, 44 },
    { 0x33, 32 },
    { 0x34, 33 },
    { 0x35, 34 },
    { 0x36, 35 },
    { 0x37, 36 },
    { 0x38, 37 },
    { 0x39, 38 },
    { 0x3A, 45 },
    { 0x3B, 46 },
    { 0x3C, 47 },
    { 0x3D, 48 },
    { 0x3E, 49 },
    { 0x3F, 50 },
  };

  struct KeyType {
    uint8_t Format;
  };
  KeyType Key = {Format};
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      if (LHS.Format < RHS.Format)
        return true;
      if (LHS.Format > RHS.Format)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Format != Idx->Format)
    return nullptr;
  return &Gfx11PlusBufferFormat[Idx->_index];
}
#endif

#ifdef GET_ImageDimIntrinsicTable_DECL
const ImageDimIntrinsicInfo *getImageDimIntrinsicInfo(unsigned Intr);
const ImageDimIntrinsicInfo *getImageDimIntrinsicByBaseOpcode(unsigned BaseOpcode, unsigned Dim);
#endif

#ifdef GET_ImageDimIntrinsicTable_IMPL
constexpr ImageDimIntrinsicInfo ImageDimIntrinsicTable[] = {
  { Intrinsic::amdgcn_image_atomic_add_1d, IMAGE_ATOMIC_ADD, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 0
  { Intrinsic::amdgcn_image_atomic_add_1darray, IMAGE_ATOMIC_ADD, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 1
  { Intrinsic::amdgcn_image_atomic_add_2d, IMAGE_ATOMIC_ADD, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 2
  { Intrinsic::amdgcn_image_atomic_add_2darray, IMAGE_ATOMIC_ADD, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 3
  { Intrinsic::amdgcn_image_atomic_add_2darraymsaa, IMAGE_ATOMIC_ADD, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 4
  { Intrinsic::amdgcn_image_atomic_add_2dmsaa, IMAGE_ATOMIC_ADD, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 5
  { Intrinsic::amdgcn_image_atomic_add_3d, IMAGE_ATOMIC_ADD, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 6
  { Intrinsic::amdgcn_image_atomic_add_cube, IMAGE_ATOMIC_ADD, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 7
  { Intrinsic::amdgcn_image_atomic_add_flt_1d, IMAGE_ATOMIC_ADD_FLT, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 8
  { Intrinsic::amdgcn_image_atomic_add_flt_1darray, IMAGE_ATOMIC_ADD_FLT, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 9
  { Intrinsic::amdgcn_image_atomic_add_flt_2d, IMAGE_ATOMIC_ADD_FLT, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 10
  { Intrinsic::amdgcn_image_atomic_add_flt_2darray, IMAGE_ATOMIC_ADD_FLT, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 11
  { Intrinsic::amdgcn_image_atomic_add_flt_2darraymsaa, IMAGE_ATOMIC_ADD_FLT, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 12
  { Intrinsic::amdgcn_image_atomic_add_flt_2dmsaa, IMAGE_ATOMIC_ADD_FLT, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 13
  { Intrinsic::amdgcn_image_atomic_add_flt_3d, IMAGE_ATOMIC_ADD_FLT, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 14
  { Intrinsic::amdgcn_image_atomic_add_flt_cube, IMAGE_ATOMIC_ADD_FLT, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 15
  { Intrinsic::amdgcn_image_atomic_and_1d, IMAGE_ATOMIC_AND, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 16
  { Intrinsic::amdgcn_image_atomic_and_1darray, IMAGE_ATOMIC_AND, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 17
  { Intrinsic::amdgcn_image_atomic_and_2d, IMAGE_ATOMIC_AND, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 18
  { Intrinsic::amdgcn_image_atomic_and_2darray, IMAGE_ATOMIC_AND, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 19
  { Intrinsic::amdgcn_image_atomic_and_2darraymsaa, IMAGE_ATOMIC_AND, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 20
  { Intrinsic::amdgcn_image_atomic_and_2dmsaa, IMAGE_ATOMIC_AND, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 21
  { Intrinsic::amdgcn_image_atomic_and_3d, IMAGE_ATOMIC_AND, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 22
  { Intrinsic::amdgcn_image_atomic_and_cube, IMAGE_ATOMIC_AND, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 23
  { Intrinsic::amdgcn_image_atomic_cmpswap_1d, IMAGE_ATOMIC_CMPSWAP, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x1, 0x6, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 24
  { Intrinsic::amdgcn_image_atomic_cmpswap_1darray, IMAGE_ATOMIC_CMPSWAP, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x2, 0x7, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 25
  { Intrinsic::amdgcn_image_atomic_cmpswap_2d, IMAGE_ATOMIC_CMPSWAP, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x2, 0x7, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 26
  { Intrinsic::amdgcn_image_atomic_cmpswap_2darray, IMAGE_ATOMIC_CMPSWAP, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x3, 0x8, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 27
  { Intrinsic::amdgcn_image_atomic_cmpswap_2darraymsaa, IMAGE_ATOMIC_CMPSWAP, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x4, 0x9, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 28
  { Intrinsic::amdgcn_image_atomic_cmpswap_2dmsaa, IMAGE_ATOMIC_CMPSWAP, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x3, 0x8, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 29
  { Intrinsic::amdgcn_image_atomic_cmpswap_3d, IMAGE_ATOMIC_CMPSWAP, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x3, 0x8, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 30
  { Intrinsic::amdgcn_image_atomic_cmpswap_cube, IMAGE_ATOMIC_CMPSWAP, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x3, 0x8, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 31
  { Intrinsic::amdgcn_image_atomic_dec_1d, IMAGE_ATOMIC_DEC, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 32
  { Intrinsic::amdgcn_image_atomic_dec_1darray, IMAGE_ATOMIC_DEC, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 33
  { Intrinsic::amdgcn_image_atomic_dec_2d, IMAGE_ATOMIC_DEC, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 34
  { Intrinsic::amdgcn_image_atomic_dec_2darray, IMAGE_ATOMIC_DEC, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 35
  { Intrinsic::amdgcn_image_atomic_dec_2darraymsaa, IMAGE_ATOMIC_DEC, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 36
  { Intrinsic::amdgcn_image_atomic_dec_2dmsaa, IMAGE_ATOMIC_DEC, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 37
  { Intrinsic::amdgcn_image_atomic_dec_3d, IMAGE_ATOMIC_DEC, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 38
  { Intrinsic::amdgcn_image_atomic_dec_cube, IMAGE_ATOMIC_DEC, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 39
  { Intrinsic::amdgcn_image_atomic_fmax_1d, IMAGE_ATOMIC_FMAX, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 40
  { Intrinsic::amdgcn_image_atomic_fmax_1darray, IMAGE_ATOMIC_FMAX, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 41
  { Intrinsic::amdgcn_image_atomic_fmax_2d, IMAGE_ATOMIC_FMAX, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 42
  { Intrinsic::amdgcn_image_atomic_fmax_2darray, IMAGE_ATOMIC_FMAX, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 43
  { Intrinsic::amdgcn_image_atomic_fmax_2darraymsaa, IMAGE_ATOMIC_FMAX, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 44
  { Intrinsic::amdgcn_image_atomic_fmax_2dmsaa, IMAGE_ATOMIC_FMAX, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 45
  { Intrinsic::amdgcn_image_atomic_fmax_3d, IMAGE_ATOMIC_FMAX, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 46
  { Intrinsic::amdgcn_image_atomic_fmax_cube, IMAGE_ATOMIC_FMAX, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 47
  { Intrinsic::amdgcn_image_atomic_fmin_1d, IMAGE_ATOMIC_FMIN, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 48
  { Intrinsic::amdgcn_image_atomic_fmin_1darray, IMAGE_ATOMIC_FMIN, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 49
  { Intrinsic::amdgcn_image_atomic_fmin_2d, IMAGE_ATOMIC_FMIN, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 50
  { Intrinsic::amdgcn_image_atomic_fmin_2darray, IMAGE_ATOMIC_FMIN, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 51
  { Intrinsic::amdgcn_image_atomic_fmin_2darraymsaa, IMAGE_ATOMIC_FMIN, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 52
  { Intrinsic::amdgcn_image_atomic_fmin_2dmsaa, IMAGE_ATOMIC_FMIN, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 53
  { Intrinsic::amdgcn_image_atomic_fmin_3d, IMAGE_ATOMIC_FMIN, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 54
  { Intrinsic::amdgcn_image_atomic_fmin_cube, IMAGE_ATOMIC_FMIN, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 55
  { Intrinsic::amdgcn_image_atomic_inc_1d, IMAGE_ATOMIC_INC, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 56
  { Intrinsic::amdgcn_image_atomic_inc_1darray, IMAGE_ATOMIC_INC, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 57
  { Intrinsic::amdgcn_image_atomic_inc_2d, IMAGE_ATOMIC_INC, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 58
  { Intrinsic::amdgcn_image_atomic_inc_2darray, IMAGE_ATOMIC_INC, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 59
  { Intrinsic::amdgcn_image_atomic_inc_2darraymsaa, IMAGE_ATOMIC_INC, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 60
  { Intrinsic::amdgcn_image_atomic_inc_2dmsaa, IMAGE_ATOMIC_INC, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 61
  { Intrinsic::amdgcn_image_atomic_inc_3d, IMAGE_ATOMIC_INC, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 62
  { Intrinsic::amdgcn_image_atomic_inc_cube, IMAGE_ATOMIC_INC, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 63
  { Intrinsic::amdgcn_image_atomic_max_flt_1d, IMAGE_ATOMIC_MAX_FLT, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 64
  { Intrinsic::amdgcn_image_atomic_max_flt_1darray, IMAGE_ATOMIC_MAX_FLT, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 65
  { Intrinsic::amdgcn_image_atomic_max_flt_2d, IMAGE_ATOMIC_MAX_FLT, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 66
  { Intrinsic::amdgcn_image_atomic_max_flt_2darray, IMAGE_ATOMIC_MAX_FLT, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 67
  { Intrinsic::amdgcn_image_atomic_max_flt_2darraymsaa, IMAGE_ATOMIC_MAX_FLT, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 68
  { Intrinsic::amdgcn_image_atomic_max_flt_2dmsaa, IMAGE_ATOMIC_MAX_FLT, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 69
  { Intrinsic::amdgcn_image_atomic_max_flt_3d, IMAGE_ATOMIC_MAX_FLT, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 70
  { Intrinsic::amdgcn_image_atomic_max_flt_cube, IMAGE_ATOMIC_MAX_FLT, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 71
  { Intrinsic::amdgcn_image_atomic_min_flt_1d, IMAGE_ATOMIC_MIN_FLT, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 72
  { Intrinsic::amdgcn_image_atomic_min_flt_1darray, IMAGE_ATOMIC_MIN_FLT, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 73
  { Intrinsic::amdgcn_image_atomic_min_flt_2d, IMAGE_ATOMIC_MIN_FLT, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 74
  { Intrinsic::amdgcn_image_atomic_min_flt_2darray, IMAGE_ATOMIC_MIN_FLT, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 75
  { Intrinsic::amdgcn_image_atomic_min_flt_2darraymsaa, IMAGE_ATOMIC_MIN_FLT, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 76
  { Intrinsic::amdgcn_image_atomic_min_flt_2dmsaa, IMAGE_ATOMIC_MIN_FLT, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 77
  { Intrinsic::amdgcn_image_atomic_min_flt_3d, IMAGE_ATOMIC_MIN_FLT, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 78
  { Intrinsic::amdgcn_image_atomic_min_flt_cube, IMAGE_ATOMIC_MIN_FLT, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 79
  { Intrinsic::amdgcn_image_atomic_or_1d, IMAGE_ATOMIC_OR, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 80
  { Intrinsic::amdgcn_image_atomic_or_1darray, IMAGE_ATOMIC_OR, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 81
  { Intrinsic::amdgcn_image_atomic_or_2d, IMAGE_ATOMIC_OR, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 82
  { Intrinsic::amdgcn_image_atomic_or_2darray, IMAGE_ATOMIC_OR, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 83
  { Intrinsic::amdgcn_image_atomic_or_2darraymsaa, IMAGE_ATOMIC_OR, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 84
  { Intrinsic::amdgcn_image_atomic_or_2dmsaa, IMAGE_ATOMIC_OR, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 85
  { Intrinsic::amdgcn_image_atomic_or_3d, IMAGE_ATOMIC_OR, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 86
  { Intrinsic::amdgcn_image_atomic_or_cube, IMAGE_ATOMIC_OR, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 87
  { Intrinsic::amdgcn_image_atomic_pk_add_bf16_1d, IMAGE_ATOMIC_PK_ADD_BF16, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 88
  { Intrinsic::amdgcn_image_atomic_pk_add_bf16_1darray, IMAGE_ATOMIC_PK_ADD_BF16, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 89
  { Intrinsic::amdgcn_image_atomic_pk_add_bf16_2d, IMAGE_ATOMIC_PK_ADD_BF16, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 90
  { Intrinsic::amdgcn_image_atomic_pk_add_bf16_2darray, IMAGE_ATOMIC_PK_ADD_BF16, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 91
  { Intrinsic::amdgcn_image_atomic_pk_add_bf16_2darraymsaa, IMAGE_ATOMIC_PK_ADD_BF16, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 92
  { Intrinsic::amdgcn_image_atomic_pk_add_bf16_2dmsaa, IMAGE_ATOMIC_PK_ADD_BF16, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 93
  { Intrinsic::amdgcn_image_atomic_pk_add_bf16_3d, IMAGE_ATOMIC_PK_ADD_BF16, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 94
  { Intrinsic::amdgcn_image_atomic_pk_add_bf16_cube, IMAGE_ATOMIC_PK_ADD_BF16, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 95
  { Intrinsic::amdgcn_image_atomic_pk_add_f16_1d, IMAGE_ATOMIC_PK_ADD_F16, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 96
  { Intrinsic::amdgcn_image_atomic_pk_add_f16_1darray, IMAGE_ATOMIC_PK_ADD_F16, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 97
  { Intrinsic::amdgcn_image_atomic_pk_add_f16_2d, IMAGE_ATOMIC_PK_ADD_F16, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 98
  { Intrinsic::amdgcn_image_atomic_pk_add_f16_2darray, IMAGE_ATOMIC_PK_ADD_F16, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 99
  { Intrinsic::amdgcn_image_atomic_pk_add_f16_2darraymsaa, IMAGE_ATOMIC_PK_ADD_F16, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 100
  { Intrinsic::amdgcn_image_atomic_pk_add_f16_2dmsaa, IMAGE_ATOMIC_PK_ADD_F16, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 101
  { Intrinsic::amdgcn_image_atomic_pk_add_f16_3d, IMAGE_ATOMIC_PK_ADD_F16, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 102
  { Intrinsic::amdgcn_image_atomic_pk_add_f16_cube, IMAGE_ATOMIC_PK_ADD_F16, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 103
  { Intrinsic::amdgcn_image_atomic_smax_1d, IMAGE_ATOMIC_SMAX, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 104
  { Intrinsic::amdgcn_image_atomic_smax_1darray, IMAGE_ATOMIC_SMAX, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 105
  { Intrinsic::amdgcn_image_atomic_smax_2d, IMAGE_ATOMIC_SMAX, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 106
  { Intrinsic::amdgcn_image_atomic_smax_2darray, IMAGE_ATOMIC_SMAX, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 107
  { Intrinsic::amdgcn_image_atomic_smax_2darraymsaa, IMAGE_ATOMIC_SMAX, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 108
  { Intrinsic::amdgcn_image_atomic_smax_2dmsaa, IMAGE_ATOMIC_SMAX, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 109
  { Intrinsic::amdgcn_image_atomic_smax_3d, IMAGE_ATOMIC_SMAX, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 110
  { Intrinsic::amdgcn_image_atomic_smax_cube, IMAGE_ATOMIC_SMAX, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 111
  { Intrinsic::amdgcn_image_atomic_smin_1d, IMAGE_ATOMIC_SMIN, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 112
  { Intrinsic::amdgcn_image_atomic_smin_1darray, IMAGE_ATOMIC_SMIN, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 113
  { Intrinsic::amdgcn_image_atomic_smin_2d, IMAGE_ATOMIC_SMIN, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 114
  { Intrinsic::amdgcn_image_atomic_smin_2darray, IMAGE_ATOMIC_SMIN, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 115
  { Intrinsic::amdgcn_image_atomic_smin_2darraymsaa, IMAGE_ATOMIC_SMIN, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 116
  { Intrinsic::amdgcn_image_atomic_smin_2dmsaa, IMAGE_ATOMIC_SMIN, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 117
  { Intrinsic::amdgcn_image_atomic_smin_3d, IMAGE_ATOMIC_SMIN, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 118
  { Intrinsic::amdgcn_image_atomic_smin_cube, IMAGE_ATOMIC_SMIN, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 119
  { Intrinsic::amdgcn_image_atomic_sub_1d, IMAGE_ATOMIC_SUB, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 120
  { Intrinsic::amdgcn_image_atomic_sub_1darray, IMAGE_ATOMIC_SUB, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 121
  { Intrinsic::amdgcn_image_atomic_sub_2d, IMAGE_ATOMIC_SUB, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 122
  { Intrinsic::amdgcn_image_atomic_sub_2darray, IMAGE_ATOMIC_SUB, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 123
  { Intrinsic::amdgcn_image_atomic_sub_2darraymsaa, IMAGE_ATOMIC_SUB, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 124
  { Intrinsic::amdgcn_image_atomic_sub_2dmsaa, IMAGE_ATOMIC_SUB, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 125
  { Intrinsic::amdgcn_image_atomic_sub_3d, IMAGE_ATOMIC_SUB, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 126
  { Intrinsic::amdgcn_image_atomic_sub_cube, IMAGE_ATOMIC_SUB, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 127
  { Intrinsic::amdgcn_image_atomic_swap_1d, IMAGE_ATOMIC_SWAP, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 128
  { Intrinsic::amdgcn_image_atomic_swap_1darray, IMAGE_ATOMIC_SWAP, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 129
  { Intrinsic::amdgcn_image_atomic_swap_2d, IMAGE_ATOMIC_SWAP, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 130
  { Intrinsic::amdgcn_image_atomic_swap_2darray, IMAGE_ATOMIC_SWAP, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 131
  { Intrinsic::amdgcn_image_atomic_swap_2darraymsaa, IMAGE_ATOMIC_SWAP, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 132
  { Intrinsic::amdgcn_image_atomic_swap_2dmsaa, IMAGE_ATOMIC_SWAP, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 133
  { Intrinsic::amdgcn_image_atomic_swap_3d, IMAGE_ATOMIC_SWAP, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 134
  { Intrinsic::amdgcn_image_atomic_swap_cube, IMAGE_ATOMIC_SWAP, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 135
  { Intrinsic::amdgcn_image_atomic_umax_1d, IMAGE_ATOMIC_UMAX, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 136
  { Intrinsic::amdgcn_image_atomic_umax_1darray, IMAGE_ATOMIC_UMAX, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 137
  { Intrinsic::amdgcn_image_atomic_umax_2d, IMAGE_ATOMIC_UMAX, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 138
  { Intrinsic::amdgcn_image_atomic_umax_2darray, IMAGE_ATOMIC_UMAX, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 139
  { Intrinsic::amdgcn_image_atomic_umax_2darraymsaa, IMAGE_ATOMIC_UMAX, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 140
  { Intrinsic::amdgcn_image_atomic_umax_2dmsaa, IMAGE_ATOMIC_UMAX, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 141
  { Intrinsic::amdgcn_image_atomic_umax_3d, IMAGE_ATOMIC_UMAX, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 142
  { Intrinsic::amdgcn_image_atomic_umax_cube, IMAGE_ATOMIC_UMAX, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 143
  { Intrinsic::amdgcn_image_atomic_umin_1d, IMAGE_ATOMIC_UMIN, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 144
  { Intrinsic::amdgcn_image_atomic_umin_1darray, IMAGE_ATOMIC_UMIN, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 145
  { Intrinsic::amdgcn_image_atomic_umin_2d, IMAGE_ATOMIC_UMIN, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 146
  { Intrinsic::amdgcn_image_atomic_umin_2darray, IMAGE_ATOMIC_UMIN, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 147
  { Intrinsic::amdgcn_image_atomic_umin_2darraymsaa, IMAGE_ATOMIC_UMIN, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 148
  { Intrinsic::amdgcn_image_atomic_umin_2dmsaa, IMAGE_ATOMIC_UMIN, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 149
  { Intrinsic::amdgcn_image_atomic_umin_3d, IMAGE_ATOMIC_UMIN, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 150
  { Intrinsic::amdgcn_image_atomic_umin_cube, IMAGE_ATOMIC_UMIN, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 151
  { Intrinsic::amdgcn_image_atomic_xor_1d, IMAGE_ATOMIC_XOR, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 152
  { Intrinsic::amdgcn_image_atomic_xor_1darray, IMAGE_ATOMIC_XOR, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 153
  { Intrinsic::amdgcn_image_atomic_xor_2d, IMAGE_ATOMIC_XOR, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 154
  { Intrinsic::amdgcn_image_atomic_xor_2darray, IMAGE_ATOMIC_XOR, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 155
  { Intrinsic::amdgcn_image_atomic_xor_2darraymsaa, IMAGE_ATOMIC_XOR, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 156
  { Intrinsic::amdgcn_image_atomic_xor_2dmsaa, IMAGE_ATOMIC_XOR, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 157
  { Intrinsic::amdgcn_image_atomic_xor_3d, IMAGE_ATOMIC_XOR, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 158
  { Intrinsic::amdgcn_image_atomic_xor_cube, IMAGE_ATOMIC_XOR, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 159
  { Intrinsic::amdgcn_image_gather4_2d, IMAGE_GATHER4, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 160
  { Intrinsic::amdgcn_image_gather4_2darray, IMAGE_GATHER4, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 161
  { Intrinsic::amdgcn_image_gather4_b_2d, IMAGE_GATHER4_B, AMDGPUDim2D, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x2, 0x2 }, // 162
  { Intrinsic::amdgcn_image_gather4_b_2darray, IMAGE_GATHER4_B, AMDGPUDim2DArray, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 163
  { Intrinsic::amdgcn_image_gather4_b_cl_2d, IMAGE_GATHER4_B_CL, AMDGPUDim2D, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 164
  { Intrinsic::amdgcn_image_gather4_b_cl_2darray, IMAGE_GATHER4_B_CL, AMDGPUDim2DArray, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 165
  { Intrinsic::amdgcn_image_gather4_b_cl_cube, IMAGE_GATHER4_B_CL, AMDGPUDimCube, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 166
  { Intrinsic::amdgcn_image_gather4_b_cl_o_2d, IMAGE_GATHER4_B_CL_O, AMDGPUDim2D, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 167
  { Intrinsic::amdgcn_image_gather4_b_cl_o_2darray, IMAGE_GATHER4_B_CL_O, AMDGPUDim2DArray, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 168
  { Intrinsic::amdgcn_image_gather4_b_cl_o_cube, IMAGE_GATHER4_B_CL_O, AMDGPUDimCube, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 169
  { Intrinsic::amdgcn_image_gather4_b_cube, IMAGE_GATHER4_B, AMDGPUDimCube, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 170
  { Intrinsic::amdgcn_image_gather4_b_o_2d, IMAGE_GATHER4_B_O, AMDGPUDim2D, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 171
  { Intrinsic::amdgcn_image_gather4_b_o_2darray, IMAGE_GATHER4_B_O, AMDGPUDim2DArray, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 172
  { Intrinsic::amdgcn_image_gather4_b_o_cube, IMAGE_GATHER4_B_O, AMDGPUDimCube, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 173
  { Intrinsic::amdgcn_image_gather4_c_2d, IMAGE_GATHER4_C, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 174
  { Intrinsic::amdgcn_image_gather4_c_2darray, IMAGE_GATHER4_C, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 175
  { Intrinsic::amdgcn_image_gather4_c_b_2d, IMAGE_GATHER4_C_B, AMDGPUDim2D, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 176
  { Intrinsic::amdgcn_image_gather4_c_b_2darray, IMAGE_GATHER4_C_B, AMDGPUDim2DArray, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 177
  { Intrinsic::amdgcn_image_gather4_c_b_cl_2d, IMAGE_GATHER4_C_B_CL, AMDGPUDim2D, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 178
  { Intrinsic::amdgcn_image_gather4_c_b_cl_2darray, IMAGE_GATHER4_C_B_CL, AMDGPUDim2DArray, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 179
  { Intrinsic::amdgcn_image_gather4_c_b_cl_cube, IMAGE_GATHER4_C_B_CL, AMDGPUDimCube, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 180
  { Intrinsic::amdgcn_image_gather4_c_b_cl_o_2d, IMAGE_GATHER4_C_B_CL_O, AMDGPUDim2D, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 181
  { Intrinsic::amdgcn_image_gather4_c_b_cl_o_2darray, IMAGE_GATHER4_C_B_CL_O, AMDGPUDim2DArray, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x2, 0x2 }, // 182
  { Intrinsic::amdgcn_image_gather4_c_b_cl_o_cube, IMAGE_GATHER4_C_B_CL_O, AMDGPUDimCube, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x2, 0x2 }, // 183
  { Intrinsic::amdgcn_image_gather4_c_b_cube, IMAGE_GATHER4_C_B, AMDGPUDimCube, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 184
  { Intrinsic::amdgcn_image_gather4_c_b_o_2d, IMAGE_GATHER4_C_B_O, AMDGPUDim2D, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 185
  { Intrinsic::amdgcn_image_gather4_c_b_o_2darray, IMAGE_GATHER4_C_B_O, AMDGPUDim2DArray, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 186
  { Intrinsic::amdgcn_image_gather4_c_b_o_cube, IMAGE_GATHER4_C_B_O, AMDGPUDimCube, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 187
  { Intrinsic::amdgcn_image_gather4_c_cl_2d, IMAGE_GATHER4_C_CL, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 188
  { Intrinsic::amdgcn_image_gather4_c_cl_2darray, IMAGE_GATHER4_C_CL, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 189
  { Intrinsic::amdgcn_image_gather4_c_cl_cube, IMAGE_GATHER4_C_CL, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 190
  { Intrinsic::amdgcn_image_gather4_c_cl_o_2d, IMAGE_GATHER4_C_CL_O, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 191
  { Intrinsic::amdgcn_image_gather4_c_cl_o_2darray, IMAGE_GATHER4_C_CL_O, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x1 }, // 192
  { Intrinsic::amdgcn_image_gather4_c_cl_o_cube, IMAGE_GATHER4_C_CL_O, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x1 }, // 193
  { Intrinsic::amdgcn_image_gather4_c_cube, IMAGE_GATHER4_C, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 194
  { Intrinsic::amdgcn_image_gather4_c_l_2d, IMAGE_GATHER4_C_L, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 195
  { Intrinsic::amdgcn_image_gather4_c_l_2darray, IMAGE_GATHER4_C_L, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 196
  { Intrinsic::amdgcn_image_gather4_c_l_cube, IMAGE_GATHER4_C_L, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 197
  { Intrinsic::amdgcn_image_gather4_c_l_o_2d, IMAGE_GATHER4_C_L_O, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 198
  { Intrinsic::amdgcn_image_gather4_c_l_o_2darray, IMAGE_GATHER4_C_L_O, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x1 }, // 199
  { Intrinsic::amdgcn_image_gather4_c_l_o_cube, IMAGE_GATHER4_C_L_O, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x1 }, // 200
  { Intrinsic::amdgcn_image_gather4_c_lz_2d, IMAGE_GATHER4_C_LZ, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 201
  { Intrinsic::amdgcn_image_gather4_c_lz_2darray, IMAGE_GATHER4_C_LZ, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 202
  { Intrinsic::amdgcn_image_gather4_c_lz_cube, IMAGE_GATHER4_C_LZ, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 203
  { Intrinsic::amdgcn_image_gather4_c_lz_o_2d, IMAGE_GATHER4_C_LZ_O, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 204
  { Intrinsic::amdgcn_image_gather4_c_lz_o_2darray, IMAGE_GATHER4_C_LZ_O, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 205
  { Intrinsic::amdgcn_image_gather4_c_lz_o_cube, IMAGE_GATHER4_C_LZ_O, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 206
  { Intrinsic::amdgcn_image_gather4_c_o_2d, IMAGE_GATHER4_C_O, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 207
  { Intrinsic::amdgcn_image_gather4_c_o_2darray, IMAGE_GATHER4_C_O, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 208
  { Intrinsic::amdgcn_image_gather4_c_o_cube, IMAGE_GATHER4_C_O, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 209
  { Intrinsic::amdgcn_image_gather4_cl_2d, IMAGE_GATHER4_CL, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 210
  { Intrinsic::amdgcn_image_gather4_cl_2darray, IMAGE_GATHER4_CL, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 211
  { Intrinsic::amdgcn_image_gather4_cl_cube, IMAGE_GATHER4_CL, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 212
  { Intrinsic::amdgcn_image_gather4_cl_o_2d, IMAGE_GATHER4_CL_O, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 213
  { Intrinsic::amdgcn_image_gather4_cl_o_2darray, IMAGE_GATHER4_CL_O, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 214
  { Intrinsic::amdgcn_image_gather4_cl_o_cube, IMAGE_GATHER4_CL_O, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 215
  { Intrinsic::amdgcn_image_gather4_cube, IMAGE_GATHER4, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 216
  { Intrinsic::amdgcn_image_gather4_l_2d, IMAGE_GATHER4_L, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 217
  { Intrinsic::amdgcn_image_gather4_l_2darray, IMAGE_GATHER4_L, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 218
  { Intrinsic::amdgcn_image_gather4_l_cube, IMAGE_GATHER4_L, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 219
  { Intrinsic::amdgcn_image_gather4_l_o_2d, IMAGE_GATHER4_L_O, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 220
  { Intrinsic::amdgcn_image_gather4_l_o_2darray, IMAGE_GATHER4_L_O, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 221
  { Intrinsic::amdgcn_image_gather4_l_o_cube, IMAGE_GATHER4_L_O, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 222
  { Intrinsic::amdgcn_image_gather4_lz_2d, IMAGE_GATHER4_LZ, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 223
  { Intrinsic::amdgcn_image_gather4_lz_2darray, IMAGE_GATHER4_LZ, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 224
  { Intrinsic::amdgcn_image_gather4_lz_cube, IMAGE_GATHER4_LZ, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 225
  { Intrinsic::amdgcn_image_gather4_lz_o_2d, IMAGE_GATHER4_LZ_O, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 226
  { Intrinsic::amdgcn_image_gather4_lz_o_2darray, IMAGE_GATHER4_LZ_O, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 227
  { Intrinsic::amdgcn_image_gather4_lz_o_cube, IMAGE_GATHER4_LZ_O, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 228
  { Intrinsic::amdgcn_image_gather4_o_2d, IMAGE_GATHER4_O, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 229
  { Intrinsic::amdgcn_image_gather4_o_2darray, IMAGE_GATHER4_O, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 230
  { Intrinsic::amdgcn_image_gather4_o_cube, IMAGE_GATHER4_O, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 231
  { Intrinsic::amdgcn_image_getlod_1d, IMAGE_GET_LOD, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x7, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 232
  { Intrinsic::amdgcn_image_getlod_1darray, IMAGE_GET_LOD, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 233
  { Intrinsic::amdgcn_image_getlod_2d, IMAGE_GET_LOD, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 234
  { Intrinsic::amdgcn_image_getlod_2darray, IMAGE_GET_LOD, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 235
  { Intrinsic::amdgcn_image_getlod_3d, IMAGE_GET_LOD, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 236
  { Intrinsic::amdgcn_image_getlod_cube, IMAGE_GET_LOD, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 237
  { Intrinsic::amdgcn_image_getresinfo_1d, IMAGE_GET_RESINFO, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x5, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 238
  { Intrinsic::amdgcn_image_getresinfo_1darray, IMAGE_GET_RESINFO, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x5, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 239
  { Intrinsic::amdgcn_image_getresinfo_2d, IMAGE_GET_RESINFO, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x5, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 240
  { Intrinsic::amdgcn_image_getresinfo_2darray, IMAGE_GET_RESINFO, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x5, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 241
  { Intrinsic::amdgcn_image_getresinfo_2darraymsaa, IMAGE_GET_RESINFO, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x5, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 242
  { Intrinsic::amdgcn_image_getresinfo_2dmsaa, IMAGE_GET_RESINFO, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x5, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 243
  { Intrinsic::amdgcn_image_getresinfo_3d, IMAGE_GET_RESINFO, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x5, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 244
  { Intrinsic::amdgcn_image_getresinfo_cube, IMAGE_GET_RESINFO, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x5, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 245
  { Intrinsic::amdgcn_image_load_1d, IMAGE_LOAD, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x5, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 246
  { Intrinsic::amdgcn_image_load_1darray, IMAGE_LOAD, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x6, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 247
  { Intrinsic::amdgcn_image_load_2d, IMAGE_LOAD, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x6, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 248
  { Intrinsic::amdgcn_image_load_2darray, IMAGE_LOAD, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x7, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 249
  { Intrinsic::amdgcn_image_load_2darraymsaa, IMAGE_LOAD, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 250
  { Intrinsic::amdgcn_image_load_2dmsaa, IMAGE_LOAD, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x7, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 251
  { Intrinsic::amdgcn_image_load_3d, IMAGE_LOAD, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x7, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 252
  { Intrinsic::amdgcn_image_load_cube, IMAGE_LOAD, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x7, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 253
  { Intrinsic::amdgcn_image_load_mip_1d, IMAGE_LOAD_MIP, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x6, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 254
  { Intrinsic::amdgcn_image_load_mip_1darray, IMAGE_LOAD_MIP, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x7, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 255
  { Intrinsic::amdgcn_image_load_mip_2d, IMAGE_LOAD_MIP, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x7, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 256
  { Intrinsic::amdgcn_image_load_mip_2darray, IMAGE_LOAD_MIP, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 257
  { Intrinsic::amdgcn_image_load_mip_3d, IMAGE_LOAD_MIP, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 258
  { Intrinsic::amdgcn_image_load_mip_cube, IMAGE_LOAD_MIP, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 259
  { Intrinsic::amdgcn_image_msaa_load_2darraymsaa, IMAGE_MSAA_LOAD, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 260
  { Intrinsic::amdgcn_image_msaa_load_2dmsaa, IMAGE_MSAA_LOAD, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x7, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 261
  { Intrinsic::amdgcn_image_msaa_load_x_2darraymsaa, IMAGE_MSAA_LOAD_X, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 262
  { Intrinsic::amdgcn_image_msaa_load_x_2dmsaa, IMAGE_MSAA_LOAD_X, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x7, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 263
  { Intrinsic::amdgcn_image_sample_1d, IMAGE_SAMPLE, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x7, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 264
  { Intrinsic::amdgcn_image_sample_1darray, IMAGE_SAMPLE, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 265
  { Intrinsic::amdgcn_image_sample_2d, IMAGE_SAMPLE, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 266
  { Intrinsic::amdgcn_image_sample_2darray, IMAGE_SAMPLE, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 267
  { Intrinsic::amdgcn_image_sample_3d, IMAGE_SAMPLE, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 268
  { Intrinsic::amdgcn_image_sample_b_1d, IMAGE_SAMPLE_B, AMDGPUDim1D, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x2, 0x2 }, // 269
  { Intrinsic::amdgcn_image_sample_b_1darray, IMAGE_SAMPLE_B, AMDGPUDim1DArray, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x2, 0x2 }, // 270
  { Intrinsic::amdgcn_image_sample_b_2d, IMAGE_SAMPLE_B, AMDGPUDim2D, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x2, 0x2 }, // 271
  { Intrinsic::amdgcn_image_sample_b_2darray, IMAGE_SAMPLE_B, AMDGPUDim2DArray, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 272
  { Intrinsic::amdgcn_image_sample_b_3d, IMAGE_SAMPLE_B, AMDGPUDim3D, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 273
  { Intrinsic::amdgcn_image_sample_b_cl_1d, IMAGE_SAMPLE_B_CL, AMDGPUDim1D, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x2, 0x2 }, // 274
  { Intrinsic::amdgcn_image_sample_b_cl_1darray, IMAGE_SAMPLE_B_CL, AMDGPUDim1DArray, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 275
  { Intrinsic::amdgcn_image_sample_b_cl_2d, IMAGE_SAMPLE_B_CL, AMDGPUDim2D, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 276
  { Intrinsic::amdgcn_image_sample_b_cl_2darray, IMAGE_SAMPLE_B_CL, AMDGPUDim2DArray, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 277
  { Intrinsic::amdgcn_image_sample_b_cl_3d, IMAGE_SAMPLE_B_CL, AMDGPUDim3D, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 278
  { Intrinsic::amdgcn_image_sample_b_cl_cube, IMAGE_SAMPLE_B_CL, AMDGPUDimCube, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 279
  { Intrinsic::amdgcn_image_sample_b_cl_o_1d, IMAGE_SAMPLE_B_CL_O, AMDGPUDim1D, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 280
  { Intrinsic::amdgcn_image_sample_b_cl_o_1darray, IMAGE_SAMPLE_B_CL_O, AMDGPUDim1DArray, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 281
  { Intrinsic::amdgcn_image_sample_b_cl_o_2d, IMAGE_SAMPLE_B_CL_O, AMDGPUDim2D, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 282
  { Intrinsic::amdgcn_image_sample_b_cl_o_2darray, IMAGE_SAMPLE_B_CL_O, AMDGPUDim2DArray, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 283
  { Intrinsic::amdgcn_image_sample_b_cl_o_3d, IMAGE_SAMPLE_B_CL_O, AMDGPUDim3D, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 284
  { Intrinsic::amdgcn_image_sample_b_cl_o_cube, IMAGE_SAMPLE_B_CL_O, AMDGPUDimCube, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 285
  { Intrinsic::amdgcn_image_sample_b_cube, IMAGE_SAMPLE_B, AMDGPUDimCube, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 286
  { Intrinsic::amdgcn_image_sample_b_o_1d, IMAGE_SAMPLE_B_O, AMDGPUDim1D, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x2, 0x2 }, // 287
  { Intrinsic::amdgcn_image_sample_b_o_1darray, IMAGE_SAMPLE_B_O, AMDGPUDim1DArray, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 288
  { Intrinsic::amdgcn_image_sample_b_o_2d, IMAGE_SAMPLE_B_O, AMDGPUDim2D, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 289
  { Intrinsic::amdgcn_image_sample_b_o_2darray, IMAGE_SAMPLE_B_O, AMDGPUDim2DArray, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 290
  { Intrinsic::amdgcn_image_sample_b_o_3d, IMAGE_SAMPLE_B_O, AMDGPUDim3D, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 291
  { Intrinsic::amdgcn_image_sample_b_o_cube, IMAGE_SAMPLE_B_O, AMDGPUDimCube, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 292
  { Intrinsic::amdgcn_image_sample_c_1d, IMAGE_SAMPLE_C, AMDGPUDim1D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 293
  { Intrinsic::amdgcn_image_sample_c_1darray, IMAGE_SAMPLE_C, AMDGPUDim1DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 294
  { Intrinsic::amdgcn_image_sample_c_2d, IMAGE_SAMPLE_C, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 295
  { Intrinsic::amdgcn_image_sample_c_2darray, IMAGE_SAMPLE_C, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 296
  { Intrinsic::amdgcn_image_sample_c_3d, IMAGE_SAMPLE_C, AMDGPUDim3D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 297
  { Intrinsic::amdgcn_image_sample_c_b_1d, IMAGE_SAMPLE_C_B, AMDGPUDim1D, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x2, 0x2 }, // 298
  { Intrinsic::amdgcn_image_sample_c_b_1darray, IMAGE_SAMPLE_C_B, AMDGPUDim1DArray, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 299
  { Intrinsic::amdgcn_image_sample_c_b_2d, IMAGE_SAMPLE_C_B, AMDGPUDim2D, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 300
  { Intrinsic::amdgcn_image_sample_c_b_2darray, IMAGE_SAMPLE_C_B, AMDGPUDim2DArray, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 301
  { Intrinsic::amdgcn_image_sample_c_b_3d, IMAGE_SAMPLE_C_B, AMDGPUDim3D, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 302
  { Intrinsic::amdgcn_image_sample_c_b_cl_1d, IMAGE_SAMPLE_C_B_CL, AMDGPUDim1D, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 303
  { Intrinsic::amdgcn_image_sample_c_b_cl_1darray, IMAGE_SAMPLE_C_B_CL, AMDGPUDim1DArray, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 304
  { Intrinsic::amdgcn_image_sample_c_b_cl_2d, IMAGE_SAMPLE_C_B_CL, AMDGPUDim2D, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 305
  { Intrinsic::amdgcn_image_sample_c_b_cl_2darray, IMAGE_SAMPLE_C_B_CL, AMDGPUDim2DArray, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 306
  { Intrinsic::amdgcn_image_sample_c_b_cl_3d, IMAGE_SAMPLE_C_B_CL, AMDGPUDim3D, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 307
  { Intrinsic::amdgcn_image_sample_c_b_cl_cube, IMAGE_SAMPLE_C_B_CL, AMDGPUDimCube, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 308
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_1d, IMAGE_SAMPLE_C_B_CL_O, AMDGPUDim1D, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 309
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_1darray, IMAGE_SAMPLE_C_B_CL_O, AMDGPUDim1DArray, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 310
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_2d, IMAGE_SAMPLE_C_B_CL_O, AMDGPUDim2D, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 311
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_2darray, IMAGE_SAMPLE_C_B_CL_O, AMDGPUDim2DArray, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x2, 0x2 }, // 312
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_3d, IMAGE_SAMPLE_C_B_CL_O, AMDGPUDim3D, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x2, 0x2 }, // 313
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_cube, IMAGE_SAMPLE_C_B_CL_O, AMDGPUDimCube, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x2, 0x2 }, // 314
  { Intrinsic::amdgcn_image_sample_c_b_cube, IMAGE_SAMPLE_C_B, AMDGPUDimCube, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 315
  { Intrinsic::amdgcn_image_sample_c_b_o_1d, IMAGE_SAMPLE_C_B_O, AMDGPUDim1D, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 316
  { Intrinsic::amdgcn_image_sample_c_b_o_1darray, IMAGE_SAMPLE_C_B_O, AMDGPUDim1DArray, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 317
  { Intrinsic::amdgcn_image_sample_c_b_o_2d, IMAGE_SAMPLE_C_B_O, AMDGPUDim2D, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 318
  { Intrinsic::amdgcn_image_sample_c_b_o_2darray, IMAGE_SAMPLE_C_B_O, AMDGPUDim2DArray, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 319
  { Intrinsic::amdgcn_image_sample_c_b_o_3d, IMAGE_SAMPLE_C_B_O, AMDGPUDim3D, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 320
  { Intrinsic::amdgcn_image_sample_c_b_o_cube, IMAGE_SAMPLE_C_B_O, AMDGPUDimCube, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 321
  { Intrinsic::amdgcn_image_sample_c_cd_1d, IMAGE_SAMPLE_C_CD, AMDGPUDim1D, 0x0, 0x0, 0x1, 0x2, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x4, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x2 }, // 322
  { Intrinsic::amdgcn_image_sample_c_cd_1darray, IMAGE_SAMPLE_C_CD, AMDGPUDim1DArray, 0x0, 0x0, 0x1, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x2 }, // 323
  { Intrinsic::amdgcn_image_sample_c_cd_2d, IMAGE_SAMPLE_C_CD, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x1, 0x2 }, // 324
  { Intrinsic::amdgcn_image_sample_c_cd_2darray, IMAGE_SAMPLE_C_CD, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 325
  { Intrinsic::amdgcn_image_sample_c_cd_3d, IMAGE_SAMPLE_C_CD, AMDGPUDim3D, 0x0, 0x0, 0x1, 0x6, 0x1, 0x0, 0xA, 0x10, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x8, 0xA, 0xA, 0xB, 0xB, 0xC, 0xD, 0xE, 0xF, 0x1, 0x1, 0x2 }, // 326
  { Intrinsic::amdgcn_image_sample_c_cd_cl_1d, IMAGE_SAMPLE_C_CD_CL, AMDGPUDim1D, 0x0, 0x0, 0x1, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x2 }, // 327
  { Intrinsic::amdgcn_image_sample_c_cd_cl_1darray, IMAGE_SAMPLE_C_CD_CL, AMDGPUDim1DArray, 0x0, 0x0, 0x1, 0x2, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x2 }, // 328
  { Intrinsic::amdgcn_image_sample_c_cd_cl_2d, IMAGE_SAMPLE_C_CD_CL, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 329
  { Intrinsic::amdgcn_image_sample_c_cd_cl_2darray, IMAGE_SAMPLE_C_CD_CL, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 330
  { Intrinsic::amdgcn_image_sample_c_cd_cl_3d, IMAGE_SAMPLE_C_CD_CL, AMDGPUDim3D, 0x0, 0x0, 0x1, 0x6, 0x1, 0x0, 0xB, 0x11, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x8, 0xB, 0xB, 0xC, 0xC, 0xD, 0xE, 0xF, 0x10, 0x1, 0x1, 0x2 }, // 331
  { Intrinsic::amdgcn_image_sample_c_cd_cl_cube, IMAGE_SAMPLE_C_CD_CL, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 332
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_1d, IMAGE_SAMPLE_C_CD_CL_O, AMDGPUDim1D, 0x1, 0x0, 0x1, 0x2, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x5, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x2 }, // 333
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_1darray, IMAGE_SAMPLE_C_CD_CL_O, AMDGPUDim1DArray, 0x1, 0x0, 0x1, 0x2, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x5, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x1, 0x2 }, // 334
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_2d, IMAGE_SAMPLE_C_CD_CL_O, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 335
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_2darray, IMAGE_SAMPLE_C_CD_CL_O, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0xA, 0x10, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0xA, 0xA, 0xB, 0xB, 0xC, 0xD, 0xE, 0xF, 0x1, 0x1, 0x2 }, // 336
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_3d, IMAGE_SAMPLE_C_CD_CL_O, AMDGPUDim3D, 0x1, 0x0, 0x1, 0x6, 0x1, 0x0, 0xC, 0x12, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x9, 0xC, 0xC, 0xD, 0xD, 0xE, 0xF, 0x10, 0x11, 0x1, 0x1, 0x2 }, // 337
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_cube, IMAGE_SAMPLE_C_CD_CL_O, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0xA, 0x10, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0xA, 0xA, 0xB, 0xB, 0xC, 0xD, 0xE, 0xF, 0x1, 0x1, 0x2 }, // 338
  { Intrinsic::amdgcn_image_sample_c_cd_cube, IMAGE_SAMPLE_C_CD, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 339
  { Intrinsic::amdgcn_image_sample_c_cd_o_1d, IMAGE_SAMPLE_C_CD_O, AMDGPUDim1D, 0x1, 0x0, 0x1, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x5, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x2 }, // 340
  { Intrinsic::amdgcn_image_sample_c_cd_o_1darray, IMAGE_SAMPLE_C_CD_O, AMDGPUDim1DArray, 0x1, 0x0, 0x1, 0x2, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x5, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x2 }, // 341
  { Intrinsic::amdgcn_image_sample_c_cd_o_2d, IMAGE_SAMPLE_C_CD_O, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 342
  { Intrinsic::amdgcn_image_sample_c_cd_o_2darray, IMAGE_SAMPLE_C_CD_O, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 343
  { Intrinsic::amdgcn_image_sample_c_cd_o_3d, IMAGE_SAMPLE_C_CD_O, AMDGPUDim3D, 0x1, 0x0, 0x1, 0x6, 0x1, 0x0, 0xB, 0x11, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x9, 0xB, 0xB, 0xC, 0xC, 0xD, 0xE, 0xF, 0x10, 0x1, 0x1, 0x2 }, // 344
  { Intrinsic::amdgcn_image_sample_c_cd_o_cube, IMAGE_SAMPLE_C_CD_O, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 345
  { Intrinsic::amdgcn_image_sample_c_cl_1d, IMAGE_SAMPLE_C_CL, AMDGPUDim1D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 346
  { Intrinsic::amdgcn_image_sample_c_cl_1darray, IMAGE_SAMPLE_C_CL, AMDGPUDim1DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 347
  { Intrinsic::amdgcn_image_sample_c_cl_2d, IMAGE_SAMPLE_C_CL, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 348
  { Intrinsic::amdgcn_image_sample_c_cl_2darray, IMAGE_SAMPLE_C_CL, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 349
  { Intrinsic::amdgcn_image_sample_c_cl_3d, IMAGE_SAMPLE_C_CL, AMDGPUDim3D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 350
  { Intrinsic::amdgcn_image_sample_c_cl_cube, IMAGE_SAMPLE_C_CL, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 351
  { Intrinsic::amdgcn_image_sample_c_cl_o_1d, IMAGE_SAMPLE_C_CL_O, AMDGPUDim1D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 352
  { Intrinsic::amdgcn_image_sample_c_cl_o_1darray, IMAGE_SAMPLE_C_CL_O, AMDGPUDim1DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 353
  { Intrinsic::amdgcn_image_sample_c_cl_o_2d, IMAGE_SAMPLE_C_CL_O, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 354
  { Intrinsic::amdgcn_image_sample_c_cl_o_2darray, IMAGE_SAMPLE_C_CL_O, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x1 }, // 355
  { Intrinsic::amdgcn_image_sample_c_cl_o_3d, IMAGE_SAMPLE_C_CL_O, AMDGPUDim3D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x1 }, // 356
  { Intrinsic::amdgcn_image_sample_c_cl_o_cube, IMAGE_SAMPLE_C_CL_O, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x1 }, // 357
  { Intrinsic::amdgcn_image_sample_c_cube, IMAGE_SAMPLE_C, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 358
  { Intrinsic::amdgcn_image_sample_c_d_1d, IMAGE_SAMPLE_C_D, AMDGPUDim1D, 0x0, 0x0, 0x1, 0x2, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x4, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x2 }, // 359
  { Intrinsic::amdgcn_image_sample_c_d_1darray, IMAGE_SAMPLE_C_D, AMDGPUDim1DArray, 0x0, 0x0, 0x1, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x2 }, // 360
  { Intrinsic::amdgcn_image_sample_c_d_2d, IMAGE_SAMPLE_C_D, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x1, 0x2 }, // 361
  { Intrinsic::amdgcn_image_sample_c_d_2darray, IMAGE_SAMPLE_C_D, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 362
  { Intrinsic::amdgcn_image_sample_c_d_3d, IMAGE_SAMPLE_C_D, AMDGPUDim3D, 0x0, 0x0, 0x1, 0x6, 0x1, 0x0, 0xA, 0x10, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x8, 0xA, 0xA, 0xB, 0xB, 0xC, 0xD, 0xE, 0xF, 0x1, 0x1, 0x2 }, // 363
  { Intrinsic::amdgcn_image_sample_c_d_cl_1d, IMAGE_SAMPLE_C_D_CL, AMDGPUDim1D, 0x0, 0x0, 0x1, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x2 }, // 364
  { Intrinsic::amdgcn_image_sample_c_d_cl_1darray, IMAGE_SAMPLE_C_D_CL, AMDGPUDim1DArray, 0x0, 0x0, 0x1, 0x2, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x2 }, // 365
  { Intrinsic::amdgcn_image_sample_c_d_cl_2d, IMAGE_SAMPLE_C_D_CL, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 366
  { Intrinsic::amdgcn_image_sample_c_d_cl_2darray, IMAGE_SAMPLE_C_D_CL, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 367
  { Intrinsic::amdgcn_image_sample_c_d_cl_3d, IMAGE_SAMPLE_C_D_CL, AMDGPUDim3D, 0x0, 0x0, 0x1, 0x6, 0x1, 0x0, 0xB, 0x11, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x8, 0xB, 0xB, 0xC, 0xC, 0xD, 0xE, 0xF, 0x10, 0x1, 0x1, 0x2 }, // 368
  { Intrinsic::amdgcn_image_sample_c_d_cl_cube, IMAGE_SAMPLE_C_D_CL, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 369
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_1d, IMAGE_SAMPLE_C_D_CL_O, AMDGPUDim1D, 0x1, 0x0, 0x1, 0x2, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x5, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x2 }, // 370
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_1darray, IMAGE_SAMPLE_C_D_CL_O, AMDGPUDim1DArray, 0x1, 0x0, 0x1, 0x2, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x5, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x1, 0x2 }, // 371
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_2d, IMAGE_SAMPLE_C_D_CL_O, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 372
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_2darray, IMAGE_SAMPLE_C_D_CL_O, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0xA, 0x10, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0xA, 0xA, 0xB, 0xB, 0xC, 0xD, 0xE, 0xF, 0x1, 0x1, 0x2 }, // 373
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_3d, IMAGE_SAMPLE_C_D_CL_O, AMDGPUDim3D, 0x1, 0x0, 0x1, 0x6, 0x1, 0x0, 0xC, 0x12, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x9, 0xC, 0xC, 0xD, 0xD, 0xE, 0xF, 0x10, 0x11, 0x1, 0x1, 0x2 }, // 374
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_cube, IMAGE_SAMPLE_C_D_CL_O, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0xA, 0x10, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0xA, 0xA, 0xB, 0xB, 0xC, 0xD, 0xE, 0xF, 0x1, 0x1, 0x2 }, // 375
  { Intrinsic::amdgcn_image_sample_c_d_cube, IMAGE_SAMPLE_C_D, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 376
  { Intrinsic::amdgcn_image_sample_c_d_o_1d, IMAGE_SAMPLE_C_D_O, AMDGPUDim1D, 0x1, 0x0, 0x1, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x5, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x2 }, // 377
  { Intrinsic::amdgcn_image_sample_c_d_o_1darray, IMAGE_SAMPLE_C_D_O, AMDGPUDim1DArray, 0x1, 0x0, 0x1, 0x2, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x5, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x2 }, // 378
  { Intrinsic::amdgcn_image_sample_c_d_o_2d, IMAGE_SAMPLE_C_D_O, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 379
  { Intrinsic::amdgcn_image_sample_c_d_o_2darray, IMAGE_SAMPLE_C_D_O, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 380
  { Intrinsic::amdgcn_image_sample_c_d_o_3d, IMAGE_SAMPLE_C_D_O, AMDGPUDim3D, 0x1, 0x0, 0x1, 0x6, 0x1, 0x0, 0xB, 0x11, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x9, 0xB, 0xB, 0xC, 0xC, 0xD, 0xE, 0xF, 0x10, 0x1, 0x1, 0x2 }, // 381
  { Intrinsic::amdgcn_image_sample_c_d_o_cube, IMAGE_SAMPLE_C_D_O, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 382
  { Intrinsic::amdgcn_image_sample_c_l_1d, IMAGE_SAMPLE_C_L, AMDGPUDim1D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 383
  { Intrinsic::amdgcn_image_sample_c_l_1darray, IMAGE_SAMPLE_C_L, AMDGPUDim1DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 384
  { Intrinsic::amdgcn_image_sample_c_l_2d, IMAGE_SAMPLE_C_L, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 385
  { Intrinsic::amdgcn_image_sample_c_l_2darray, IMAGE_SAMPLE_C_L, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 386
  { Intrinsic::amdgcn_image_sample_c_l_3d, IMAGE_SAMPLE_C_L, AMDGPUDim3D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 387
  { Intrinsic::amdgcn_image_sample_c_l_cube, IMAGE_SAMPLE_C_L, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 388
  { Intrinsic::amdgcn_image_sample_c_l_o_1d, IMAGE_SAMPLE_C_L_O, AMDGPUDim1D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 389
  { Intrinsic::amdgcn_image_sample_c_l_o_1darray, IMAGE_SAMPLE_C_L_O, AMDGPUDim1DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 390
  { Intrinsic::amdgcn_image_sample_c_l_o_2d, IMAGE_SAMPLE_C_L_O, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 391
  { Intrinsic::amdgcn_image_sample_c_l_o_2darray, IMAGE_SAMPLE_C_L_O, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x1 }, // 392
  { Intrinsic::amdgcn_image_sample_c_l_o_3d, IMAGE_SAMPLE_C_L_O, AMDGPUDim3D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x1 }, // 393
  { Intrinsic::amdgcn_image_sample_c_l_o_cube, IMAGE_SAMPLE_C_L_O, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x1 }, // 394
  { Intrinsic::amdgcn_image_sample_c_lz_1d, IMAGE_SAMPLE_C_LZ, AMDGPUDim1D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 395
  { Intrinsic::amdgcn_image_sample_c_lz_1darray, IMAGE_SAMPLE_C_LZ, AMDGPUDim1DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 396
  { Intrinsic::amdgcn_image_sample_c_lz_2d, IMAGE_SAMPLE_C_LZ, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 397
  { Intrinsic::amdgcn_image_sample_c_lz_2darray, IMAGE_SAMPLE_C_LZ, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 398
  { Intrinsic::amdgcn_image_sample_c_lz_3d, IMAGE_SAMPLE_C_LZ, AMDGPUDim3D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 399
  { Intrinsic::amdgcn_image_sample_c_lz_cube, IMAGE_SAMPLE_C_LZ, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 400
  { Intrinsic::amdgcn_image_sample_c_lz_o_1d, IMAGE_SAMPLE_C_LZ_O, AMDGPUDim1D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 401
  { Intrinsic::amdgcn_image_sample_c_lz_o_1darray, IMAGE_SAMPLE_C_LZ_O, AMDGPUDim1DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 402
  { Intrinsic::amdgcn_image_sample_c_lz_o_2d, IMAGE_SAMPLE_C_LZ_O, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 403
  { Intrinsic::amdgcn_image_sample_c_lz_o_2darray, IMAGE_SAMPLE_C_LZ_O, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 404
  { Intrinsic::amdgcn_image_sample_c_lz_o_3d, IMAGE_SAMPLE_C_LZ_O, AMDGPUDim3D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 405
  { Intrinsic::amdgcn_image_sample_c_lz_o_cube, IMAGE_SAMPLE_C_LZ_O, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 406
  { Intrinsic::amdgcn_image_sample_c_o_1d, IMAGE_SAMPLE_C_O, AMDGPUDim1D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 407
  { Intrinsic::amdgcn_image_sample_c_o_1darray, IMAGE_SAMPLE_C_O, AMDGPUDim1DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 408
  { Intrinsic::amdgcn_image_sample_c_o_2d, IMAGE_SAMPLE_C_O, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 409
  { Intrinsic::amdgcn_image_sample_c_o_2darray, IMAGE_SAMPLE_C_O, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 410
  { Intrinsic::amdgcn_image_sample_c_o_3d, IMAGE_SAMPLE_C_O, AMDGPUDim3D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 411
  { Intrinsic::amdgcn_image_sample_c_o_cube, IMAGE_SAMPLE_C_O, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 412
  { Intrinsic::amdgcn_image_sample_cd_1d, IMAGE_SAMPLE_CD, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x2, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x2 }, // 413
  { Intrinsic::amdgcn_image_sample_cd_1darray, IMAGE_SAMPLE_CD, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x2, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x2 }, // 414
  { Intrinsic::amdgcn_image_sample_cd_2d, IMAGE_SAMPLE_CD, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x2 }, // 415
  { Intrinsic::amdgcn_image_sample_cd_2darray, IMAGE_SAMPLE_CD, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x1, 0x2 }, // 416
  { Intrinsic::amdgcn_image_sample_cd_3d, IMAGE_SAMPLE_CD, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x6, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x7, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 417
  { Intrinsic::amdgcn_image_sample_cd_cl_1d, IMAGE_SAMPLE_CD_CL, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x2, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x2 }, // 418
  { Intrinsic::amdgcn_image_sample_cd_cl_1darray, IMAGE_SAMPLE_CD_CL, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x2 }, // 419
  { Intrinsic::amdgcn_image_sample_cd_cl_2d, IMAGE_SAMPLE_CD_CL, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x1, 0x2 }, // 420
  { Intrinsic::amdgcn_image_sample_cd_cl_2darray, IMAGE_SAMPLE_CD_CL, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 421
  { Intrinsic::amdgcn_image_sample_cd_cl_3d, IMAGE_SAMPLE_CD_CL, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x6, 0x1, 0x0, 0xA, 0x10, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x7, 0xA, 0xA, 0xB, 0xB, 0xC, 0xD, 0xE, 0xF, 0x1, 0x1, 0x2 }, // 422
  { Intrinsic::amdgcn_image_sample_cd_cl_cube, IMAGE_SAMPLE_CD_CL, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 423
  { Intrinsic::amdgcn_image_sample_cd_cl_o_1d, IMAGE_SAMPLE_CD_CL_O, AMDGPUDim1D, 0x1, 0x0, 0x0, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x2 }, // 424
  { Intrinsic::amdgcn_image_sample_cd_cl_o_1darray, IMAGE_SAMPLE_CD_CL_O, AMDGPUDim1DArray, 0x1, 0x0, 0x0, 0x2, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x2 }, // 425
  { Intrinsic::amdgcn_image_sample_cd_cl_o_2d, IMAGE_SAMPLE_CD_CL_O, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 426
  { Intrinsic::amdgcn_image_sample_cd_cl_o_2darray, IMAGE_SAMPLE_CD_CL_O, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 427
  { Intrinsic::amdgcn_image_sample_cd_cl_o_3d, IMAGE_SAMPLE_CD_CL_O, AMDGPUDim3D, 0x1, 0x0, 0x0, 0x6, 0x1, 0x0, 0xB, 0x11, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x8, 0xB, 0xB, 0xC, 0xC, 0xD, 0xE, 0xF, 0x10, 0x1, 0x1, 0x2 }, // 428
  { Intrinsic::amdgcn_image_sample_cd_cl_o_cube, IMAGE_SAMPLE_CD_CL_O, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 429
  { Intrinsic::amdgcn_image_sample_cd_cube, IMAGE_SAMPLE_CD, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x1, 0x2 }, // 430
  { Intrinsic::amdgcn_image_sample_cd_o_1d, IMAGE_SAMPLE_CD_O, AMDGPUDim1D, 0x1, 0x0, 0x0, 0x2, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x2 }, // 431
  { Intrinsic::amdgcn_image_sample_cd_o_1darray, IMAGE_SAMPLE_CD_O, AMDGPUDim1DArray, 0x1, 0x0, 0x0, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x2 }, // 432
  { Intrinsic::amdgcn_image_sample_cd_o_2d, IMAGE_SAMPLE_CD_O, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x1, 0x2 }, // 433
  { Intrinsic::amdgcn_image_sample_cd_o_2darray, IMAGE_SAMPLE_CD_O, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 434
  { Intrinsic::amdgcn_image_sample_cd_o_3d, IMAGE_SAMPLE_CD_O, AMDGPUDim3D, 0x1, 0x0, 0x0, 0x6, 0x1, 0x0, 0xA, 0x10, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x8, 0xA, 0xA, 0xB, 0xB, 0xC, 0xD, 0xE, 0xF, 0x1, 0x1, 0x2 }, // 435
  { Intrinsic::amdgcn_image_sample_cd_o_cube, IMAGE_SAMPLE_CD_O, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 436
  { Intrinsic::amdgcn_image_sample_cl_1d, IMAGE_SAMPLE_CL, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 437
  { Intrinsic::amdgcn_image_sample_cl_1darray, IMAGE_SAMPLE_CL, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 438
  { Intrinsic::amdgcn_image_sample_cl_2d, IMAGE_SAMPLE_CL, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 439
  { Intrinsic::amdgcn_image_sample_cl_2darray, IMAGE_SAMPLE_CL, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 440
  { Intrinsic::amdgcn_image_sample_cl_3d, IMAGE_SAMPLE_CL, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 441
  { Intrinsic::amdgcn_image_sample_cl_cube, IMAGE_SAMPLE_CL, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 442
  { Intrinsic::amdgcn_image_sample_cl_o_1d, IMAGE_SAMPLE_CL_O, AMDGPUDim1D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 443
  { Intrinsic::amdgcn_image_sample_cl_o_1darray, IMAGE_SAMPLE_CL_O, AMDGPUDim1DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 444
  { Intrinsic::amdgcn_image_sample_cl_o_2d, IMAGE_SAMPLE_CL_O, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 445
  { Intrinsic::amdgcn_image_sample_cl_o_2darray, IMAGE_SAMPLE_CL_O, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 446
  { Intrinsic::amdgcn_image_sample_cl_o_3d, IMAGE_SAMPLE_CL_O, AMDGPUDim3D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 447
  { Intrinsic::amdgcn_image_sample_cl_o_cube, IMAGE_SAMPLE_CL_O, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 448
  { Intrinsic::amdgcn_image_sample_cube, IMAGE_SAMPLE, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 449
  { Intrinsic::amdgcn_image_sample_d_1d, IMAGE_SAMPLE_D, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x2, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x2 }, // 450
  { Intrinsic::amdgcn_image_sample_d_1darray, IMAGE_SAMPLE_D, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x2, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x2 }, // 451
  { Intrinsic::amdgcn_image_sample_d_2d, IMAGE_SAMPLE_D, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x2 }, // 452
  { Intrinsic::amdgcn_image_sample_d_2darray, IMAGE_SAMPLE_D, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x1, 0x2 }, // 453
  { Intrinsic::amdgcn_image_sample_d_3d, IMAGE_SAMPLE_D, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x6, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x7, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 454
  { Intrinsic::amdgcn_image_sample_d_cl_1d, IMAGE_SAMPLE_D_CL, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x2, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x2 }, // 455
  { Intrinsic::amdgcn_image_sample_d_cl_1darray, IMAGE_SAMPLE_D_CL, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x2 }, // 456
  { Intrinsic::amdgcn_image_sample_d_cl_2d, IMAGE_SAMPLE_D_CL, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x1, 0x2 }, // 457
  { Intrinsic::amdgcn_image_sample_d_cl_2darray, IMAGE_SAMPLE_D_CL, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 458
  { Intrinsic::amdgcn_image_sample_d_cl_3d, IMAGE_SAMPLE_D_CL, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x6, 0x1, 0x0, 0xA, 0x10, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x7, 0xA, 0xA, 0xB, 0xB, 0xC, 0xD, 0xE, 0xF, 0x1, 0x1, 0x2 }, // 459
  { Intrinsic::amdgcn_image_sample_d_cl_cube, IMAGE_SAMPLE_D_CL, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 460
  { Intrinsic::amdgcn_image_sample_d_cl_o_1d, IMAGE_SAMPLE_D_CL_O, AMDGPUDim1D, 0x1, 0x0, 0x0, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x2 }, // 461
  { Intrinsic::amdgcn_image_sample_d_cl_o_1darray, IMAGE_SAMPLE_D_CL_O, AMDGPUDim1DArray, 0x1, 0x0, 0x0, 0x2, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x2 }, // 462
  { Intrinsic::amdgcn_image_sample_d_cl_o_2d, IMAGE_SAMPLE_D_CL_O, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 463
  { Intrinsic::amdgcn_image_sample_d_cl_o_2darray, IMAGE_SAMPLE_D_CL_O, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 464
  { Intrinsic::amdgcn_image_sample_d_cl_o_3d, IMAGE_SAMPLE_D_CL_O, AMDGPUDim3D, 0x1, 0x0, 0x0, 0x6, 0x1, 0x0, 0xB, 0x11, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x8, 0xB, 0xB, 0xC, 0xC, 0xD, 0xE, 0xF, 0x10, 0x1, 0x1, 0x2 }, // 465
  { Intrinsic::amdgcn_image_sample_d_cl_o_cube, IMAGE_SAMPLE_D_CL_O, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 466
  { Intrinsic::amdgcn_image_sample_d_cube, IMAGE_SAMPLE_D, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x1, 0x2 }, // 467
  { Intrinsic::amdgcn_image_sample_d_o_1d, IMAGE_SAMPLE_D_O, AMDGPUDim1D, 0x1, 0x0, 0x0, 0x2, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x2 }, // 468
  { Intrinsic::amdgcn_image_sample_d_o_1darray, IMAGE_SAMPLE_D_O, AMDGPUDim1DArray, 0x1, 0x0, 0x0, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x2 }, // 469
  { Intrinsic::amdgcn_image_sample_d_o_2d, IMAGE_SAMPLE_D_O, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x1, 0x2 }, // 470
  { Intrinsic::amdgcn_image_sample_d_o_2darray, IMAGE_SAMPLE_D_O, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 471
  { Intrinsic::amdgcn_image_sample_d_o_3d, IMAGE_SAMPLE_D_O, AMDGPUDim3D, 0x1, 0x0, 0x0, 0x6, 0x1, 0x0, 0xA, 0x10, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x8, 0xA, 0xA, 0xB, 0xB, 0xC, 0xD, 0xE, 0xF, 0x1, 0x1, 0x2 }, // 472
  { Intrinsic::amdgcn_image_sample_d_o_cube, IMAGE_SAMPLE_D_O, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 473
  { Intrinsic::amdgcn_image_sample_l_1d, IMAGE_SAMPLE_L, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 474
  { Intrinsic::amdgcn_image_sample_l_1darray, IMAGE_SAMPLE_L, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 475
  { Intrinsic::amdgcn_image_sample_l_2d, IMAGE_SAMPLE_L, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 476
  { Intrinsic::amdgcn_image_sample_l_2darray, IMAGE_SAMPLE_L, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 477
  { Intrinsic::amdgcn_image_sample_l_3d, IMAGE_SAMPLE_L, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 478
  { Intrinsic::amdgcn_image_sample_l_cube, IMAGE_SAMPLE_L, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 479
  { Intrinsic::amdgcn_image_sample_l_o_1d, IMAGE_SAMPLE_L_O, AMDGPUDim1D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 480
  { Intrinsic::amdgcn_image_sample_l_o_1darray, IMAGE_SAMPLE_L_O, AMDGPUDim1DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 481
  { Intrinsic::amdgcn_image_sample_l_o_2d, IMAGE_SAMPLE_L_O, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 482
  { Intrinsic::amdgcn_image_sample_l_o_2darray, IMAGE_SAMPLE_L_O, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 483
  { Intrinsic::amdgcn_image_sample_l_o_3d, IMAGE_SAMPLE_L_O, AMDGPUDim3D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 484
  { Intrinsic::amdgcn_image_sample_l_o_cube, IMAGE_SAMPLE_L_O, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 485
  { Intrinsic::amdgcn_image_sample_lz_1d, IMAGE_SAMPLE_LZ, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x7, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 486
  { Intrinsic::amdgcn_image_sample_lz_1darray, IMAGE_SAMPLE_LZ, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 487
  { Intrinsic::amdgcn_image_sample_lz_2d, IMAGE_SAMPLE_LZ, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 488
  { Intrinsic::amdgcn_image_sample_lz_2darray, IMAGE_SAMPLE_LZ, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 489
  { Intrinsic::amdgcn_image_sample_lz_3d, IMAGE_SAMPLE_LZ, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 490
  { Intrinsic::amdgcn_image_sample_lz_cube, IMAGE_SAMPLE_LZ, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 491
  { Intrinsic::amdgcn_image_sample_lz_o_1d, IMAGE_SAMPLE_LZ_O, AMDGPUDim1D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 492
  { Intrinsic::amdgcn_image_sample_lz_o_1darray, IMAGE_SAMPLE_LZ_O, AMDGPUDim1DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 493
  { Intrinsic::amdgcn_image_sample_lz_o_2d, IMAGE_SAMPLE_LZ_O, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 494
  { Intrinsic::amdgcn_image_sample_lz_o_2darray, IMAGE_SAMPLE_LZ_O, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 495
  { Intrinsic::amdgcn_image_sample_lz_o_3d, IMAGE_SAMPLE_LZ_O, AMDGPUDim3D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 496
  { Intrinsic::amdgcn_image_sample_lz_o_cube, IMAGE_SAMPLE_LZ_O, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 497
  { Intrinsic::amdgcn_image_sample_o_1d, IMAGE_SAMPLE_O, AMDGPUDim1D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 498
  { Intrinsic::amdgcn_image_sample_o_1darray, IMAGE_SAMPLE_O, AMDGPUDim1DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 499
  { Intrinsic::amdgcn_image_sample_o_2d, IMAGE_SAMPLE_O, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 500
  { Intrinsic::amdgcn_image_sample_o_2darray, IMAGE_SAMPLE_O, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 501
  { Intrinsic::amdgcn_image_sample_o_3d, IMAGE_SAMPLE_O, AMDGPUDim3D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 502
  { Intrinsic::amdgcn_image_sample_o_cube, IMAGE_SAMPLE_O, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 503
  { Intrinsic::amdgcn_image_store_1d, IMAGE_STORE, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x6, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 504
  { Intrinsic::amdgcn_image_store_1darray, IMAGE_STORE, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x2, 0x7, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 505
  { Intrinsic::amdgcn_image_store_2d, IMAGE_STORE, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x2, 0x7, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 506
  { Intrinsic::amdgcn_image_store_2darray, IMAGE_STORE, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x3, 0x8, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 507
  { Intrinsic::amdgcn_image_store_2darraymsaa, IMAGE_STORE, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x4, 0x9, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 508
  { Intrinsic::amdgcn_image_store_2dmsaa, IMAGE_STORE, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x3, 0x8, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 509
  { Intrinsic::amdgcn_image_store_3d, IMAGE_STORE, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x3, 0x8, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 510
  { Intrinsic::amdgcn_image_store_cube, IMAGE_STORE, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x3, 0x8, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 511
  { Intrinsic::amdgcn_image_store_mip_1d, IMAGE_STORE_MIP, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x2, 0x7, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 512
  { Intrinsic::amdgcn_image_store_mip_1darray, IMAGE_STORE_MIP, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x3, 0x8, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 513
  { Intrinsic::amdgcn_image_store_mip_2d, IMAGE_STORE_MIP, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x3, 0x8, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 514
  { Intrinsic::amdgcn_image_store_mip_2darray, IMAGE_STORE_MIP, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x4, 0x9, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 515
  { Intrinsic::amdgcn_image_store_mip_3d, IMAGE_STORE_MIP, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x4, 0x9, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 516
  { Intrinsic::amdgcn_image_store_mip_cube, IMAGE_STORE_MIP, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x4, 0x9, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 517
 };

const ImageDimIntrinsicInfo *getImageDimIntrinsicInfo(unsigned Intr) {
  if ((Intr < Intrinsic::amdgcn_image_atomic_add_1d) ||
      (Intr > Intrinsic::amdgcn_image_store_mip_cube))
    return nullptr;

  struct KeyType {
    unsigned Intr;
  };
  KeyType Key = {Intr};
  auto Table = ArrayRef(ImageDimIntrinsicTable);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const ImageDimIntrinsicInfo &LHS, const KeyType &RHS) {
      if (LHS.Intr < RHS.Intr)
        return true;
      if (LHS.Intr > RHS.Intr)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Intr != Idx->Intr)
    return nullptr;
  return &*Idx;
}

const ImageDimIntrinsicInfo *getImageDimIntrinsicByBaseOpcode(unsigned BaseOpcode, unsigned Dim) {
  struct IndexType {
    unsigned BaseOpcode;
    unsigned Dim;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { IMAGE_ATOMIC_ADD, AMDGPUDim1D, 0 },
    { IMAGE_ATOMIC_ADD, AMDGPUDim1DArray, 1 },
    { IMAGE_ATOMIC_ADD, AMDGPUDim2D, 2 },
    { IMAGE_ATOMIC_ADD, AMDGPUDim2DArray, 3 },
    { IMAGE_ATOMIC_ADD, AMDGPUDim2DArrayMsaa, 4 },
    { IMAGE_ATOMIC_ADD, AMDGPUDim2DMsaa, 5 },
    { IMAGE_ATOMIC_ADD, AMDGPUDim3D, 6 },
    { IMAGE_ATOMIC_ADD, AMDGPUDimCube, 7 },
    { IMAGE_ATOMIC_ADD_FLT, AMDGPUDim1D, 8 },
    { IMAGE_ATOMIC_ADD_FLT, AMDGPUDim1DArray, 9 },
    { IMAGE_ATOMIC_ADD_FLT, AMDGPUDim2D, 10 },
    { IMAGE_ATOMIC_ADD_FLT, AMDGPUDim2DArray, 11 },
    { IMAGE_ATOMIC_ADD_FLT, AMDGPUDim2DArrayMsaa, 12 },
    { IMAGE_ATOMIC_ADD_FLT, AMDGPUDim2DMsaa, 13 },
    { IMAGE_ATOMIC_ADD_FLT, AMDGPUDim3D, 14 },
    { IMAGE_ATOMIC_ADD_FLT, AMDGPUDimCube, 15 },
    { IMAGE_ATOMIC_AND, AMDGPUDim1D, 16 },
    { IMAGE_ATOMIC_AND, AMDGPUDim1DArray, 17 },
    { IMAGE_ATOMIC_AND, AMDGPUDim2D, 18 },
    { IMAGE_ATOMIC_AND, AMDGPUDim2DArray, 19 },
    { IMAGE_ATOMIC_AND, AMDGPUDim2DArrayMsaa, 20 },
    { IMAGE_ATOMIC_AND, AMDGPUDim2DMsaa, 21 },
    { IMAGE_ATOMIC_AND, AMDGPUDim3D, 22 },
    { IMAGE_ATOMIC_AND, AMDGPUDimCube, 23 },
    { IMAGE_ATOMIC_CMPSWAP, AMDGPUDim1D, 24 },
    { IMAGE_ATOMIC_CMPSWAP, AMDGPUDim1DArray, 25 },
    { IMAGE_ATOMIC_CMPSWAP, AMDGPUDim2D, 26 },
    { IMAGE_ATOMIC_CMPSWAP, AMDGPUDim2DArray, 27 },
    { IMAGE_ATOMIC_CMPSWAP, AMDGPUDim2DArrayMsaa, 28 },
    { IMAGE_ATOMIC_CMPSWAP, AMDGPUDim2DMsaa, 29 },
    { IMAGE_ATOMIC_CMPSWAP, AMDGPUDim3D, 30 },
    { IMAGE_ATOMIC_CMPSWAP, AMDGPUDimCube, 31 },
    { IMAGE_ATOMIC_DEC, AMDGPUDim1D, 32 },
    { IMAGE_ATOMIC_DEC, AMDGPUDim1DArray, 33 },
    { IMAGE_ATOMIC_DEC, AMDGPUDim2D, 34 },
    { IMAGE_ATOMIC_DEC, AMDGPUDim2DArray, 35 },
    { IMAGE_ATOMIC_DEC, AMDGPUDim2DArrayMsaa, 36 },
    { IMAGE_ATOMIC_DEC, AMDGPUDim2DMsaa, 37 },
    { IMAGE_ATOMIC_DEC, AMDGPUDim3D, 38 },
    { IMAGE_ATOMIC_DEC, AMDGPUDimCube, 39 },
    { IMAGE_ATOMIC_FMAX, AMDGPUDim1D, 40 },
    { IMAGE_ATOMIC_FMAX, AMDGPUDim1DArray, 41 },
    { IMAGE_ATOMIC_FMAX, AMDGPUDim2D, 42 },
    { IMAGE_ATOMIC_FMAX, AMDGPUDim2DArray, 43 },
    { IMAGE_ATOMIC_FMAX, AMDGPUDim2DArrayMsaa, 44 },
    { IMAGE_ATOMIC_FMAX, AMDGPUDim2DMsaa, 45 },
    { IMAGE_ATOMIC_FMAX, AMDGPUDim3D, 46 },
    { IMAGE_ATOMIC_FMAX, AMDGPUDimCube, 47 },
    { IMAGE_ATOMIC_FMIN, AMDGPUDim1D, 48 },
    { IMAGE_ATOMIC_FMIN, AMDGPUDim1DArray, 49 },
    { IMAGE_ATOMIC_FMIN, AMDGPUDim2D, 50 },
    { IMAGE_ATOMIC_FMIN, AMDGPUDim2DArray, 51 },
    { IMAGE_ATOMIC_FMIN, AMDGPUDim2DArrayMsaa, 52 },
    { IMAGE_ATOMIC_FMIN, AMDGPUDim2DMsaa, 53 },
    { IMAGE_ATOMIC_FMIN, AMDGPUDim3D, 54 },
    { IMAGE_ATOMIC_FMIN, AMDGPUDimCube, 55 },
    { IMAGE_ATOMIC_INC, AMDGPUDim1D, 56 },
    { IMAGE_ATOMIC_INC, AMDGPUDim1DArray, 57 },
    { IMAGE_ATOMIC_INC, AMDGPUDim2D, 58 },
    { IMAGE_ATOMIC_INC, AMDGPUDim2DArray, 59 },
    { IMAGE_ATOMIC_INC, AMDGPUDim2DArrayMsaa, 60 },
    { IMAGE_ATOMIC_INC, AMDGPUDim2DMsaa, 61 },
    { IMAGE_ATOMIC_INC, AMDGPUDim3D, 62 },
    { IMAGE_ATOMIC_INC, AMDGPUDimCube, 63 },
    { IMAGE_ATOMIC_MAX_FLT, AMDGPUDim1D, 64 },
    { IMAGE_ATOMIC_MAX_FLT, AMDGPUDim1DArray, 65 },
    { IMAGE_ATOMIC_MAX_FLT, AMDGPUDim2D, 66 },
    { IMAGE_ATOMIC_MAX_FLT, AMDGPUDim2DArray, 67 },
    { IMAGE_ATOMIC_MAX_FLT, AMDGPUDim2DArrayMsaa, 68 },
    { IMAGE_ATOMIC_MAX_FLT, AMDGPUDim2DMsaa, 69 },
    { IMAGE_ATOMIC_MAX_FLT, AMDGPUDim3D, 70 },
    { IMAGE_ATOMIC_MAX_FLT, AMDGPUDimCube, 71 },
    { IMAGE_ATOMIC_MIN_FLT, AMDGPUDim1D, 72 },
    { IMAGE_ATOMIC_MIN_FLT, AMDGPUDim1DArray, 73 },
    { IMAGE_ATOMIC_MIN_FLT, AMDGPUDim2D, 74 },
    { IMAGE_ATOMIC_MIN_FLT, AMDGPUDim2DArray, 75 },
    { IMAGE_ATOMIC_MIN_FLT, AMDGPUDim2DArrayMsaa, 76 },
    { IMAGE_ATOMIC_MIN_FLT, AMDGPUDim2DMsaa, 77 },
    { IMAGE_ATOMIC_MIN_FLT, AMDGPUDim3D, 78 },
    { IMAGE_ATOMIC_MIN_FLT, AMDGPUDimCube, 79 },
    { IMAGE_ATOMIC_OR, AMDGPUDim1D, 80 },
    { IMAGE_ATOMIC_OR, AMDGPUDim1DArray, 81 },
    { IMAGE_ATOMIC_OR, AMDGPUDim2D, 82 },
    { IMAGE_ATOMIC_OR, AMDGPUDim2DArray, 83 },
    { IMAGE_ATOMIC_OR, AMDGPUDim2DArrayMsaa, 84 },
    { IMAGE_ATOMIC_OR, AMDGPUDim2DMsaa, 85 },
    { IMAGE_ATOMIC_OR, AMDGPUDim3D, 86 },
    { IMAGE_ATOMIC_OR, AMDGPUDimCube, 87 },
    { IMAGE_ATOMIC_PK_ADD_BF16, AMDGPUDim1D, 88 },
    { IMAGE_ATOMIC_PK_ADD_BF16, AMDGPUDim1DArray, 89 },
    { IMAGE_ATOMIC_PK_ADD_BF16, AMDGPUDim2D, 90 },
    { IMAGE_ATOMIC_PK_ADD_BF16, AMDGPUDim2DArray, 91 },
    { IMAGE_ATOMIC_PK_ADD_BF16, AMDGPUDim2DArrayMsaa, 92 },
    { IMAGE_ATOMIC_PK_ADD_BF16, AMDGPUDim2DMsaa, 93 },
    { IMAGE_ATOMIC_PK_ADD_BF16, AMDGPUDim3D, 94 },
    { IMAGE_ATOMIC_PK_ADD_BF16, AMDGPUDimCube, 95 },
    { IMAGE_ATOMIC_PK_ADD_F16, AMDGPUDim1D, 96 },
    { IMAGE_ATOMIC_PK_ADD_F16, AMDGPUDim1DArray, 97 },
    { IMAGE_ATOMIC_PK_ADD_F16, AMDGPUDim2D, 98 },
    { IMAGE_ATOMIC_PK_ADD_F16, AMDGPUDim2DArray, 99 },
    { IMAGE_ATOMIC_PK_ADD_F16, AMDGPUDim2DArrayMsaa, 100 },
    { IMAGE_ATOMIC_PK_ADD_F16, AMDGPUDim2DMsaa, 101 },
    { IMAGE_ATOMIC_PK_ADD_F16, AMDGPUDim3D, 102 },
    { IMAGE_ATOMIC_PK_ADD_F16, AMDGPUDimCube, 103 },
    { IMAGE_ATOMIC_SMAX, AMDGPUDim1D, 104 },
    { IMAGE_ATOMIC_SMAX, AMDGPUDim1DArray, 105 },
    { IMAGE_ATOMIC_SMAX, AMDGPUDim2D, 106 },
    { IMAGE_ATOMIC_SMAX, AMDGPUDim2DArray, 107 },
    { IMAGE_ATOMIC_SMAX, AMDGPUDim2DArrayMsaa, 108 },
    { IMAGE_ATOMIC_SMAX, AMDGPUDim2DMsaa, 109 },
    { IMAGE_ATOMIC_SMAX, AMDGPUDim3D, 110 },
    { IMAGE_ATOMIC_SMAX, AMDGPUDimCube, 111 },
    { IMAGE_ATOMIC_SMIN, AMDGPUDim1D, 112 },
    { IMAGE_ATOMIC_SMIN, AMDGPUDim1DArray, 113 },
    { IMAGE_ATOMIC_SMIN, AMDGPUDim2D, 114 },
    { IMAGE_ATOMIC_SMIN, AMDGPUDim2DArray, 115 },
    { IMAGE_ATOMIC_SMIN, AMDGPUDim2DArrayMsaa, 116 },
    { IMAGE_ATOMIC_SMIN, AMDGPUDim2DMsaa, 117 },
    { IMAGE_ATOMIC_SMIN, AMDGPUDim3D, 118 },
    { IMAGE_ATOMIC_SMIN, AMDGPUDimCube, 119 },
    { IMAGE_ATOMIC_SUB, AMDGPUDim1D, 120 },
    { IMAGE_ATOMIC_SUB, AMDGPUDim1DArray, 121 },
    { IMAGE_ATOMIC_SUB, AMDGPUDim2D, 122 },
    { IMAGE_ATOMIC_SUB, AMDGPUDim2DArray, 123 },
    { IMAGE_ATOMIC_SUB, AMDGPUDim2DArrayMsaa, 124 },
    { IMAGE_ATOMIC_SUB, AMDGPUDim2DMsaa, 125 },
    { IMAGE_ATOMIC_SUB, AMDGPUDim3D, 126 },
    { IMAGE_ATOMIC_SUB, AMDGPUDimCube, 127 },
    { IMAGE_ATOMIC_SWAP, AMDGPUDim1D, 128 },
    { IMAGE_ATOMIC_SWAP, AMDGPUDim1DArray, 129 },
    { IMAGE_ATOMIC_SWAP, AMDGPUDim2D, 130 },
    { IMAGE_ATOMIC_SWAP, AMDGPUDim2DArray, 131 },
    { IMAGE_ATOMIC_SWAP, AMDGPUDim2DArrayMsaa, 132 },
    { IMAGE_ATOMIC_SWAP, AMDGPUDim2DMsaa, 133 },
    { IMAGE_ATOMIC_SWAP, AMDGPUDim3D, 134 },
    { IMAGE_ATOMIC_SWAP, AMDGPUDimCube, 135 },
    { IMAGE_ATOMIC_UMAX, AMDGPUDim1D, 136 },
    { IMAGE_ATOMIC_UMAX, AMDGPUDim1DArray, 137 },
    { IMAGE_ATOMIC_UMAX, AMDGPUDim2D, 138 },
    { IMAGE_ATOMIC_UMAX, AMDGPUDim2DArray, 139 },
    { IMAGE_ATOMIC_UMAX, AMDGPUDim2DArrayMsaa, 140 },
    { IMAGE_ATOMIC_UMAX, AMDGPUDim2DMsaa, 141 },
    { IMAGE_ATOMIC_UMAX, AMDGPUDim3D, 142 },
    { IMAGE_ATOMIC_UMAX, AMDGPUDimCube, 143 },
    { IMAGE_ATOMIC_UMIN, AMDGPUDim1D, 144 },
    { IMAGE_ATOMIC_UMIN, AMDGPUDim1DArray, 145 },
    { IMAGE_ATOMIC_UMIN, AMDGPUDim2D, 146 },
    { IMAGE_ATOMIC_UMIN, AMDGPUDim2DArray, 147 },
    { IMAGE_ATOMIC_UMIN, AMDGPUDim2DArrayMsaa, 148 },
    { IMAGE_ATOMIC_UMIN, AMDGPUDim2DMsaa, 149 },
    { IMAGE_ATOMIC_UMIN, AMDGPUDim3D, 150 },
    { IMAGE_ATOMIC_UMIN, AMDGPUDimCube, 151 },
    { IMAGE_ATOMIC_XOR, AMDGPUDim1D, 152 },
    { IMAGE_ATOMIC_XOR, AMDGPUDim1DArray, 153 },
    { IMAGE_ATOMIC_XOR, AMDGPUDim2D, 154 },
    { IMAGE_ATOMIC_XOR, AMDGPUDim2DArray, 155 },
    { IMAGE_ATOMIC_XOR, AMDGPUDim2DArrayMsaa, 156 },
    { IMAGE_ATOMIC_XOR, AMDGPUDim2DMsaa, 157 },
    { IMAGE_ATOMIC_XOR, AMDGPUDim3D, 158 },
    { IMAGE_ATOMIC_XOR, AMDGPUDimCube, 159 },
    { IMAGE_GATHER4, AMDGPUDim2D, 160 },
    { IMAGE_GATHER4, AMDGPUDim2DArray, 161 },
    { IMAGE_GATHER4, AMDGPUDimCube, 216 },
    { IMAGE_GATHER4_B, AMDGPUDim2D, 162 },
    { IMAGE_GATHER4_B, AMDGPUDim2DArray, 163 },
    { IMAGE_GATHER4_B, AMDGPUDimCube, 170 },
    { IMAGE_GATHER4_B_CL, AMDGPUDim2D, 164 },
    { IMAGE_GATHER4_B_CL, AMDGPUDim2DArray, 165 },
    { IMAGE_GATHER4_B_CL, AMDGPUDimCube, 166 },
    { IMAGE_GATHER4_B_CL_O, AMDGPUDim2D, 167 },
    { IMAGE_GATHER4_B_CL_O, AMDGPUDim2DArray, 168 },
    { IMAGE_GATHER4_B_CL_O, AMDGPUDimCube, 169 },
    { IMAGE_GATHER4_B_O, AMDGPUDim2D, 171 },
    { IMAGE_GATHER4_B_O, AMDGPUDim2DArray, 172 },
    { IMAGE_GATHER4_B_O, AMDGPUDimCube, 173 },
    { IMAGE_GATHER4_C, AMDGPUDim2D, 174 },
    { IMAGE_GATHER4_C, AMDGPUDim2DArray, 175 },
    { IMAGE_GATHER4_C, AMDGPUDimCube, 194 },
    { IMAGE_GATHER4_CL, AMDGPUDim2D, 210 },
    { IMAGE_GATHER4_CL, AMDGPUDim2DArray, 211 },
    { IMAGE_GATHER4_CL, AMDGPUDimCube, 212 },
    { IMAGE_GATHER4_CL_O, AMDGPUDim2D, 213 },
    { IMAGE_GATHER4_CL_O, AMDGPUDim2DArray, 214 },
    { IMAGE_GATHER4_CL_O, AMDGPUDimCube, 215 },
    { IMAGE_GATHER4_C_B, AMDGPUDim2D, 176 },
    { IMAGE_GATHER4_C_B, AMDGPUDim2DArray, 177 },
    { IMAGE_GATHER4_C_B, AMDGPUDimCube, 184 },
    { IMAGE_GATHER4_C_B_CL, AMDGPUDim2D, 178 },
    { IMAGE_GATHER4_C_B_CL, AMDGPUDim2DArray, 179 },
    { IMAGE_GATHER4_C_B_CL, AMDGPUDimCube, 180 },
    { IMAGE_GATHER4_C_B_CL_O, AMDGPUDim2D, 181 },
    { IMAGE_GATHER4_C_B_CL_O, AMDGPUDim2DArray, 182 },
    { IMAGE_GATHER4_C_B_CL_O, AMDGPUDimCube, 183 },
    { IMAGE_GATHER4_C_B_O, AMDGPUDim2D, 185 },
    { IMAGE_GATHER4_C_B_O, AMDGPUDim2DArray, 186 },
    { IMAGE_GATHER4_C_B_O, AMDGPUDimCube, 187 },
    { IMAGE_GATHER4_C_CL, AMDGPUDim2D, 188 },
    { IMAGE_GATHER4_C_CL, AMDGPUDim2DArray, 189 },
    { IMAGE_GATHER4_C_CL, AMDGPUDimCube, 190 },
    { IMAGE_GATHER4_C_CL_O, AMDGPUDim2D, 191 },
    { IMAGE_GATHER4_C_CL_O, AMDGPUDim2DArray, 192 },
    { IMAGE_GATHER4_C_CL_O, AMDGPUDimCube, 193 },
    { IMAGE_GATHER4_C_L, AMDGPUDim2D, 195 },
    { IMAGE_GATHER4_C_L, AMDGPUDim2DArray, 196 },
    { IMAGE_GATHER4_C_L, AMDGPUDimCube, 197 },
    { IMAGE_GATHER4_C_LZ, AMDGPUDim2D, 201 },
    { IMAGE_GATHER4_C_LZ, AMDGPUDim2DArray, 202 },
    { IMAGE_GATHER4_C_LZ, AMDGPUDimCube, 203 },
    { IMAGE_GATHER4_C_LZ_O, AMDGPUDim2D, 204 },
    { IMAGE_GATHER4_C_LZ_O, AMDGPUDim2DArray, 205 },
    { IMAGE_GATHER4_C_LZ_O, AMDGPUDimCube, 206 },
    { IMAGE_GATHER4_C_L_O, AMDGPUDim2D, 198 },
    { IMAGE_GATHER4_C_L_O, AMDGPUDim2DArray, 199 },
    { IMAGE_GATHER4_C_L_O, AMDGPUDimCube, 200 },
    { IMAGE_GATHER4_C_O, AMDGPUDim2D, 207 },
    { IMAGE_GATHER4_C_O, AMDGPUDim2DArray, 208 },
    { IMAGE_GATHER4_C_O, AMDGPUDimCube, 209 },
    { IMAGE_GATHER4_L, AMDGPUDim2D, 217 },
    { IMAGE_GATHER4_L, AMDGPUDim2DArray, 218 },
    { IMAGE_GATHER4_L, AMDGPUDimCube, 219 },
    { IMAGE_GATHER4_LZ, AMDGPUDim2D, 223 },
    { IMAGE_GATHER4_LZ, AMDGPUDim2DArray, 224 },
    { IMAGE_GATHER4_LZ, AMDGPUDimCube, 225 },
    { IMAGE_GATHER4_LZ_O, AMDGPUDim2D, 226 },
    { IMAGE_GATHER4_LZ_O, AMDGPUDim2DArray, 227 },
    { IMAGE_GATHER4_LZ_O, AMDGPUDimCube, 228 },
    { IMAGE_GATHER4_L_O, AMDGPUDim2D, 220 },
    { IMAGE_GATHER4_L_O, AMDGPUDim2DArray, 221 },
    { IMAGE_GATHER4_L_O, AMDGPUDimCube, 222 },
    { IMAGE_GATHER4_O, AMDGPUDim2D, 229 },
    { IMAGE_GATHER4_O, AMDGPUDim2DArray, 230 },
    { IMAGE_GATHER4_O, AMDGPUDimCube, 231 },
    { IMAGE_GET_LOD, AMDGPUDim1D, 232 },
    { IMAGE_GET_LOD, AMDGPUDim1DArray, 233 },
    { IMAGE_GET_LOD, AMDGPUDim2D, 234 },
    { IMAGE_GET_LOD, AMDGPUDim2DArray, 235 },
    { IMAGE_GET_LOD, AMDGPUDim3D, 236 },
    { IMAGE_GET_LOD, AMDGPUDimCube, 237 },
    { IMAGE_GET_RESINFO, AMDGPUDim1D, 238 },
    { IMAGE_GET_RESINFO, AMDGPUDim1DArray, 239 },
    { IMAGE_GET_RESINFO, AMDGPUDim2D, 240 },
    { IMAGE_GET_RESINFO, AMDGPUDim2DArray, 241 },
    { IMAGE_GET_RESINFO, AMDGPUDim2DArrayMsaa, 242 },
    { IMAGE_GET_RESINFO, AMDGPUDim2DMsaa, 243 },
    { IMAGE_GET_RESINFO, AMDGPUDim3D, 244 },
    { IMAGE_GET_RESINFO, AMDGPUDimCube, 245 },
    { IMAGE_LOAD, AMDGPUDim1D, 246 },
    { IMAGE_LOAD, AMDGPUDim1DArray, 247 },
    { IMAGE_LOAD, AMDGPUDim2D, 248 },
    { IMAGE_LOAD, AMDGPUDim2DArray, 249 },
    { IMAGE_LOAD, AMDGPUDim2DArrayMsaa, 250 },
    { IMAGE_LOAD, AMDGPUDim2DMsaa, 251 },
    { IMAGE_LOAD, AMDGPUDim3D, 252 },
    { IMAGE_LOAD, AMDGPUDimCube, 253 },
    { IMAGE_LOAD_MIP, AMDGPUDim1D, 254 },
    { IMAGE_LOAD_MIP, AMDGPUDim1DArray, 255 },
    { IMAGE_LOAD_MIP, AMDGPUDim2D, 256 },
    { IMAGE_LOAD_MIP, AMDGPUDim2DArray, 257 },
    { IMAGE_LOAD_MIP, AMDGPUDim3D, 258 },
    { IMAGE_LOAD_MIP, AMDGPUDimCube, 259 },
    { IMAGE_MSAA_LOAD, AMDGPUDim2DArrayMsaa, 260 },
    { IMAGE_MSAA_LOAD, AMDGPUDim2DMsaa, 261 },
    { IMAGE_MSAA_LOAD_X, AMDGPUDim2DArrayMsaa, 262 },
    { IMAGE_MSAA_LOAD_X, AMDGPUDim2DMsaa, 263 },
    { IMAGE_SAMPLE, AMDGPUDim1D, 264 },
    { IMAGE_SAMPLE, AMDGPUDim1DArray, 265 },
    { IMAGE_SAMPLE, AMDGPUDim2D, 266 },
    { IMAGE_SAMPLE, AMDGPUDim2DArray, 267 },
    { IMAGE_SAMPLE, AMDGPUDim3D, 268 },
    { IMAGE_SAMPLE, AMDGPUDimCube, 449 },
    { IMAGE_SAMPLE_B, AMDGPUDim1D, 269 },
    { IMAGE_SAMPLE_B, AMDGPUDim1DArray, 270 },
    { IMAGE_SAMPLE_B, AMDGPUDim2D, 271 },
    { IMAGE_SAMPLE_B, AMDGPUDim2DArray, 272 },
    { IMAGE_SAMPLE_B, AMDGPUDim3D, 273 },
    { IMAGE_SAMPLE_B, AMDGPUDimCube, 286 },
    { IMAGE_SAMPLE_B_CL, AMDGPUDim1D, 274 },
    { IMAGE_SAMPLE_B_CL, AMDGPUDim1DArray, 275 },
    { IMAGE_SAMPLE_B_CL, AMDGPUDim2D, 276 },
    { IMAGE_SAMPLE_B_CL, AMDGPUDim2DArray, 277 },
    { IMAGE_SAMPLE_B_CL, AMDGPUDim3D, 278 },
    { IMAGE_SAMPLE_B_CL, AMDGPUDimCube, 279 },
    { IMAGE_SAMPLE_B_CL_O, AMDGPUDim1D, 280 },
    { IMAGE_SAMPLE_B_CL_O, AMDGPUDim1DArray, 281 },
    { IMAGE_SAMPLE_B_CL_O, AMDGPUDim2D, 282 },
    { IMAGE_SAMPLE_B_CL_O, AMDGPUDim2DArray, 283 },
    { IMAGE_SAMPLE_B_CL_O, AMDGPUDim3D, 284 },
    { IMAGE_SAMPLE_B_CL_O, AMDGPUDimCube, 285 },
    { IMAGE_SAMPLE_B_O, AMDGPUDim1D, 287 },
    { IMAGE_SAMPLE_B_O, AMDGPUDim1DArray, 288 },
    { IMAGE_SAMPLE_B_O, AMDGPUDim2D, 289 },
    { IMAGE_SAMPLE_B_O, AMDGPUDim2DArray, 290 },
    { IMAGE_SAMPLE_B_O, AMDGPUDim3D, 291 },
    { IMAGE_SAMPLE_B_O, AMDGPUDimCube, 292 },
    { IMAGE_SAMPLE_C, AMDGPUDim1D, 293 },
    { IMAGE_SAMPLE_C, AMDGPUDim1DArray, 294 },
    { IMAGE_SAMPLE_C, AMDGPUDim2D, 295 },
    { IMAGE_SAMPLE_C, AMDGPUDim2DArray, 296 },
    { IMAGE_SAMPLE_C, AMDGPUDim3D, 297 },
    { IMAGE_SAMPLE_C, AMDGPUDimCube, 358 },
    { IMAGE_SAMPLE_CD, AMDGPUDim1D, 413 },
    { IMAGE_SAMPLE_CD, AMDGPUDim1DArray, 414 },
    { IMAGE_SAMPLE_CD, AMDGPUDim2D, 415 },
    { IMAGE_SAMPLE_CD, AMDGPUDim2DArray, 416 },
    { IMAGE_SAMPLE_CD, AMDGPUDim3D, 417 },
    { IMAGE_SAMPLE_CD, AMDGPUDimCube, 430 },
    { IMAGE_SAMPLE_CD_CL, AMDGPUDim1D, 418 },
    { IMAGE_SAMPLE_CD_CL, AMDGPUDim1DArray, 419 },
    { IMAGE_SAMPLE_CD_CL, AMDGPUDim2D, 420 },
    { IMAGE_SAMPLE_CD_CL, AMDGPUDim2DArray, 421 },
    { IMAGE_SAMPLE_CD_CL, AMDGPUDim3D, 422 },
    { IMAGE_SAMPLE_CD_CL, AMDGPUDimCube, 423 },
    { IMAGE_SAMPLE_CD_CL_O, AMDGPUDim1D, 424 },
    { IMAGE_SAMPLE_CD_CL_O, AMDGPUDim1DArray, 425 },
    { IMAGE_SAMPLE_CD_CL_O, AMDGPUDim2D, 426 },
    { IMAGE_SAMPLE_CD_CL_O, AMDGPUDim2DArray, 427 },
    { IMAGE_SAMPLE_CD_CL_O, AMDGPUDim3D, 428 },
    { IMAGE_SAMPLE_CD_CL_O, AMDGPUDimCube, 429 },
    { IMAGE_SAMPLE_CD_O, AMDGPUDim1D, 431 },
    { IMAGE_SAMPLE_CD_O, AMDGPUDim1DArray, 432 },
    { IMAGE_SAMPLE_CD_O, AMDGPUDim2D, 433 },
    { IMAGE_SAMPLE_CD_O, AMDGPUDim2DArray, 434 },
    { IMAGE_SAMPLE_CD_O, AMDGPUDim3D, 435 },
    { IMAGE_SAMPLE_CD_O, AMDGPUDimCube, 436 },
    { IMAGE_SAMPLE_CL, AMDGPUDim1D, 437 },
    { IMAGE_SAMPLE_CL, AMDGPUDim1DArray, 438 },
    { IMAGE_SAMPLE_CL, AMDGPUDim2D, 439 },
    { IMAGE_SAMPLE_CL, AMDGPUDim2DArray, 440 },
    { IMAGE_SAMPLE_CL, AMDGPUDim3D, 441 },
    { IMAGE_SAMPLE_CL, AMDGPUDimCube, 442 },
    { IMAGE_SAMPLE_CL_O, AMDGPUDim1D, 443 },
    { IMAGE_SAMPLE_CL_O, AMDGPUDim1DArray, 444 },
    { IMAGE_SAMPLE_CL_O, AMDGPUDim2D, 445 },
    { IMAGE_SAMPLE_CL_O, AMDGPUDim2DArray, 446 },
    { IMAGE_SAMPLE_CL_O, AMDGPUDim3D, 447 },
    { IMAGE_SAMPLE_CL_O, AMDGPUDimCube, 448 },
    { IMAGE_SAMPLE_C_B, AMDGPUDim1D, 298 },
    { IMAGE_SAMPLE_C_B, AMDGPUDim1DArray, 299 },
    { IMAGE_SAMPLE_C_B, AMDGPUDim2D, 300 },
    { IMAGE_SAMPLE_C_B, AMDGPUDim2DArray, 301 },
    { IMAGE_SAMPLE_C_B, AMDGPUDim3D, 302 },
    { IMAGE_SAMPLE_C_B, AMDGPUDimCube, 315 },
    { IMAGE_SAMPLE_C_B_CL, AMDGPUDim1D, 303 },
    { IMAGE_SAMPLE_C_B_CL, AMDGPUDim1DArray, 304 },
    { IMAGE_SAMPLE_C_B_CL, AMDGPUDim2D, 305 },
    { IMAGE_SAMPLE_C_B_CL, AMDGPUDim2DArray, 306 },
    { IMAGE_SAMPLE_C_B_CL, AMDGPUDim3D, 307 },
    { IMAGE_SAMPLE_C_B_CL, AMDGPUDimCube, 308 },
    { IMAGE_SAMPLE_C_B_CL_O, AMDGPUDim1D, 309 },
    { IMAGE_SAMPLE_C_B_CL_O, AMDGPUDim1DArray, 310 },
    { IMAGE_SAMPLE_C_B_CL_O, AMDGPUDim2D, 311 },
    { IMAGE_SAMPLE_C_B_CL_O, AMDGPUDim2DArray, 312 },
    { IMAGE_SAMPLE_C_B_CL_O, AMDGPUDim3D, 313 },
    { IMAGE_SAMPLE_C_B_CL_O, AMDGPUDimCube, 314 },
    { IMAGE_SAMPLE_C_B_O, AMDGPUDim1D, 316 },
    { IMAGE_SAMPLE_C_B_O, AMDGPUDim1DArray, 317 },
    { IMAGE_SAMPLE_C_B_O, AMDGPUDim2D, 318 },
    { IMAGE_SAMPLE_C_B_O, AMDGPUDim2DArray, 319 },
    { IMAGE_SAMPLE_C_B_O, AMDGPUDim3D, 320 },
    { IMAGE_SAMPLE_C_B_O, AMDGPUDimCube, 321 },
    { IMAGE_SAMPLE_C_CD, AMDGPUDim1D, 322 },
    { IMAGE_SAMPLE_C_CD, AMDGPUDim1DArray, 323 },
    { IMAGE_SAMPLE_C_CD, AMDGPUDim2D, 324 },
    { IMAGE_SAMPLE_C_CD, AMDGPUDim2DArray, 325 },
    { IMAGE_SAMPLE_C_CD, AMDGPUDim3D, 326 },
    { IMAGE_SAMPLE_C_CD, AMDGPUDimCube, 339 },
    { IMAGE_SAMPLE_C_CD_CL, AMDGPUDim1D, 327 },
    { IMAGE_SAMPLE_C_CD_CL, AMDGPUDim1DArray, 328 },
    { IMAGE_SAMPLE_C_CD_CL, AMDGPUDim2D, 329 },
    { IMAGE_SAMPLE_C_CD_CL, AMDGPUDim2DArray, 330 },
    { IMAGE_SAMPLE_C_CD_CL, AMDGPUDim3D, 331 },
    { IMAGE_SAMPLE_C_CD_CL, AMDGPUDimCube, 332 },
    { IMAGE_SAMPLE_C_CD_CL_O, AMDGPUDim1D, 333 },
    { IMAGE_SAMPLE_C_CD_CL_O, AMDGPUDim1DArray, 334 },
    { IMAGE_SAMPLE_C_CD_CL_O, AMDGPUDim2D, 335 },
    { IMAGE_SAMPLE_C_CD_CL_O, AMDGPUDim2DArray, 336 },
    { IMAGE_SAMPLE_C_CD_CL_O, AMDGPUDim3D, 337 },
    { IMAGE_SAMPLE_C_CD_CL_O, AMDGPUDimCube, 338 },
    { IMAGE_SAMPLE_C_CD_O, AMDGPUDim1D, 340 },
    { IMAGE_SAMPLE_C_CD_O, AMDGPUDim1DArray, 341 },
    { IMAGE_SAMPLE_C_CD_O, AMDGPUDim2D, 342 },
    { IMAGE_SAMPLE_C_CD_O, AMDGPUDim2DArray, 343 },
    { IMAGE_SAMPLE_C_CD_O, AMDGPUDim3D, 344 },
    { IMAGE_SAMPLE_C_CD_O, AMDGPUDimCube, 345 },
    { IMAGE_SAMPLE_C_CL, AMDGPUDim1D, 346 },
    { IMAGE_SAMPLE_C_CL, AMDGPUDim1DArray, 347 },
    { IMAGE_SAMPLE_C_CL, AMDGPUDim2D, 348 },
    { IMAGE_SAMPLE_C_CL, AMDGPUDim2DArray, 349 },
    { IMAGE_SAMPLE_C_CL, AMDGPUDim3D, 350 },
    { IMAGE_SAMPLE_C_CL, AMDGPUDimCube, 351 },
    { IMAGE_SAMPLE_C_CL_O, AMDGPUDim1D, 352 },
    { IMAGE_SAMPLE_C_CL_O, AMDGPUDim1DArray, 353 },
    { IMAGE_SAMPLE_C_CL_O, AMDGPUDim2D, 354 },
    { IMAGE_SAMPLE_C_CL_O, AMDGPUDim2DArray, 355 },
    { IMAGE_SAMPLE_C_CL_O, AMDGPUDim3D, 356 },
    { IMAGE_SAMPLE_C_CL_O, AMDGPUDimCube, 357 },
    { IMAGE_SAMPLE_C_D, AMDGPUDim1D, 359 },
    { IMAGE_SAMPLE_C_D, AMDGPUDim1DArray, 360 },
    { IMAGE_SAMPLE_C_D, AMDGPUDim2D, 361 },
    { IMAGE_SAMPLE_C_D, AMDGPUDim2DArray, 362 },
    { IMAGE_SAMPLE_C_D, AMDGPUDim3D, 363 },
    { IMAGE_SAMPLE_C_D, AMDGPUDimCube, 376 },
    { IMAGE_SAMPLE_C_D_CL, AMDGPUDim1D, 364 },
    { IMAGE_SAMPLE_C_D_CL, AMDGPUDim1DArray, 365 },
    { IMAGE_SAMPLE_C_D_CL, AMDGPUDim2D, 366 },
    { IMAGE_SAMPLE_C_D_CL, AMDGPUDim2DArray, 367 },
    { IMAGE_SAMPLE_C_D_CL, AMDGPUDim3D, 368 },
    { IMAGE_SAMPLE_C_D_CL, AMDGPUDimCube, 369 },
    { IMAGE_SAMPLE_C_D_CL_O, AMDGPUDim1D, 370 },
    { IMAGE_SAMPLE_C_D_CL_O, AMDGPUDim1DArray, 371 },
    { IMAGE_SAMPLE_C_D_CL_O, AMDGPUDim2D, 372 },
    { IMAGE_SAMPLE_C_D_CL_O, AMDGPUDim2DArray, 373 },
    { IMAGE_SAMPLE_C_D_CL_O, AMDGPUDim3D, 374 },
    { IMAGE_SAMPLE_C_D_CL_O, AMDGPUDimCube, 375 },
    { IMAGE_SAMPLE_C_D_O, AMDGPUDim1D, 377 },
    { IMAGE_SAMPLE_C_D_O, AMDGPUDim1DArray, 378 },
    { IMAGE_SAMPLE_C_D_O, AMDGPUDim2D, 379 },
    { IMAGE_SAMPLE_C_D_O, AMDGPUDim2DArray, 380 },
    { IMAGE_SAMPLE_C_D_O, AMDGPUDim3D, 381 },
    { IMAGE_SAMPLE_C_D_O, AMDGPUDimCube, 382 },
    { IMAGE_SAMPLE_C_L, AMDGPUDim1D, 383 },
    { IMAGE_SAMPLE_C_L, AMDGPUDim1DArray, 384 },
    { IMAGE_SAMPLE_C_L, AMDGPUDim2D, 385 },
    { IMAGE_SAMPLE_C_L, AMDGPUDim2DArray, 386 },
    { IMAGE_SAMPLE_C_L, AMDGPUDim3D, 387 },
    { IMAGE_SAMPLE_C_L, AMDGPUDimCube, 388 },
    { IMAGE_SAMPLE_C_LZ, AMDGPUDim1D, 395 },
    { IMAGE_SAMPLE_C_LZ, AMDGPUDim1DArray, 396 },
    { IMAGE_SAMPLE_C_LZ, AMDGPUDim2D, 397 },
    { IMAGE_SAMPLE_C_LZ, AMDGPUDim2DArray, 398 },
    { IMAGE_SAMPLE_C_LZ, AMDGPUDim3D, 399 },
    { IMAGE_SAMPLE_C_LZ, AMDGPUDimCube, 400 },
    { IMAGE_SAMPLE_C_LZ_O, AMDGPUDim1D, 401 },
    { IMAGE_SAMPLE_C_LZ_O, AMDGPUDim1DArray, 402 },
    { IMAGE_SAMPLE_C_LZ_O, AMDGPUDim2D, 403 },
    { IMAGE_SAMPLE_C_LZ_O, AMDGPUDim2DArray, 404 },
    { IMAGE_SAMPLE_C_LZ_O, AMDGPUDim3D, 405 },
    { IMAGE_SAMPLE_C_LZ_O, AMDGPUDimCube, 406 },
    { IMAGE_SAMPLE_C_L_O, AMDGPUDim1D, 389 },
    { IMAGE_SAMPLE_C_L_O, AMDGPUDim1DArray, 390 },
    { IMAGE_SAMPLE_C_L_O, AMDGPUDim2D, 391 },
    { IMAGE_SAMPLE_C_L_O, AMDGPUDim2DArray, 392 },
    { IMAGE_SAMPLE_C_L_O, AMDGPUDim3D, 393 },
    { IMAGE_SAMPLE_C_L_O, AMDGPUDimCube, 394 },
    { IMAGE_SAMPLE_C_O, AMDGPUDim1D, 407 },
    { IMAGE_SAMPLE_C_O, AMDGPUDim1DArray, 408 },
    { IMAGE_SAMPLE_C_O, AMDGPUDim2D, 409 },
    { IMAGE_SAMPLE_C_O, AMDGPUDim2DArray, 410 },
    { IMAGE_SAMPLE_C_O, AMDGPUDim3D, 411 },
    { IMAGE_SAMPLE_C_O, AMDGPUDimCube, 412 },
    { IMAGE_SAMPLE_D, AMDGPUDim1D, 450 },
    { IMAGE_SAMPLE_D, AMDGPUDim1DArray, 451 },
    { IMAGE_SAMPLE_D, AMDGPUDim2D, 452 },
    { IMAGE_SAMPLE_D, AMDGPUDim2DArray, 453 },
    { IMAGE_SAMPLE_D, AMDGPUDim3D, 454 },
    { IMAGE_SAMPLE_D, AMDGPUDimCube, 467 },
    { IMAGE_SAMPLE_D_CL, AMDGPUDim1D, 455 },
    { IMAGE_SAMPLE_D_CL, AMDGPUDim1DArray, 456 },
    { IMAGE_SAMPLE_D_CL, AMDGPUDim2D, 457 },
    { IMAGE_SAMPLE_D_CL, AMDGPUDim2DArray, 458 },
    { IMAGE_SAMPLE_D_CL, AMDGPUDim3D, 459 },
    { IMAGE_SAMPLE_D_CL, AMDGPUDimCube, 460 },
    { IMAGE_SAMPLE_D_CL_O, AMDGPUDim1D, 461 },
    { IMAGE_SAMPLE_D_CL_O, AMDGPUDim1DArray, 462 },
    { IMAGE_SAMPLE_D_CL_O, AMDGPUDim2D, 463 },
    { IMAGE_SAMPLE_D_CL_O, AMDGPUDim2DArray, 464 },
    { IMAGE_SAMPLE_D_CL_O, AMDGPUDim3D, 465 },
    { IMAGE_SAMPLE_D_CL_O, AMDGPUDimCube, 466 },
    { IMAGE_SAMPLE_D_O, AMDGPUDim1D, 468 },
    { IMAGE_SAMPLE_D_O, AMDGPUDim1DArray, 469 },
    { IMAGE_SAMPLE_D_O, AMDGPUDim2D, 470 },
    { IMAGE_SAMPLE_D_O, AMDGPUDim2DArray, 471 },
    { IMAGE_SAMPLE_D_O, AMDGPUDim3D, 472 },
    { IMAGE_SAMPLE_D_O, AMDGPUDimCube, 473 },
    { IMAGE_SAMPLE_L, AMDGPUDim1D, 474 },
    { IMAGE_SAMPLE_L, AMDGPUDim1DArray, 475 },
    { IMAGE_SAMPLE_L, AMDGPUDim2D, 476 },
    { IMAGE_SAMPLE_L, AMDGPUDim2DArray, 477 },
    { IMAGE_SAMPLE_L, AMDGPUDim3D, 478 },
    { IMAGE_SAMPLE_L, AMDGPUDimCube, 479 },
    { IMAGE_SAMPLE_LZ, AMDGPUDim1D, 486 },
    { IMAGE_SAMPLE_LZ, AMDGPUDim1DArray, 487 },
    { IMAGE_SAMPLE_LZ, AMDGPUDim2D, 488 },
    { IMAGE_SAMPLE_LZ, AMDGPUDim2DArray, 489 },
    { IMAGE_SAMPLE_LZ, AMDGPUDim3D, 490 },
    { IMAGE_SAMPLE_LZ, AMDGPUDimCube, 491 },
    { IMAGE_SAMPLE_LZ_O, AMDGPUDim1D, 492 },
    { IMAGE_SAMPLE_LZ_O, AMDGPUDim1DArray, 493 },
    { IMAGE_SAMPLE_LZ_O, AMDGPUDim2D, 494 },
    { IMAGE_SAMPLE_LZ_O, AMDGPUDim2DArray, 495 },
    { IMAGE_SAMPLE_LZ_O, AMDGPUDim3D, 496 },
    { IMAGE_SAMPLE_LZ_O, AMDGPUDimCube, 497 },
    { IMAGE_SAMPLE_L_O, AMDGPUDim1D, 480 },
    { IMAGE_SAMPLE_L_O, AMDGPUDim1DArray, 481 },
    { IMAGE_SAMPLE_L_O, AMDGPUDim2D, 482 },
    { IMAGE_SAMPLE_L_O, AMDGPUDim2DArray, 483 },
    { IMAGE_SAMPLE_L_O, AMDGPUDim3D, 484 },
    { IMAGE_SAMPLE_L_O, AMDGPUDimCube, 485 },
    { IMAGE_SAMPLE_O, AMDGPUDim1D, 498 },
    { IMAGE_SAMPLE_O, AMDGPUDim1DArray, 499 },
    { IMAGE_SAMPLE_O, AMDGPUDim2D, 500 },
    { IMAGE_SAMPLE_O, AMDGPUDim2DArray, 501 },
    { IMAGE_SAMPLE_O, AMDGPUDim3D, 502 },
    { IMAGE_SAMPLE_O, AMDGPUDimCube, 503 },
    { IMAGE_STORE, AMDGPUDim1D, 504 },
    { IMAGE_STORE, AMDGPUDim1DArray, 505 },
    { IMAGE_STORE, AMDGPUDim2D, 506 },
    { IMAGE_STORE, AMDGPUDim2DArray, 507 },
    { IMAGE_STORE, AMDGPUDim2DArrayMsaa, 508 },
    { IMAGE_STORE, AMDGPUDim2DMsaa, 509 },
    { IMAGE_STORE, AMDGPUDim3D, 510 },
    { IMAGE_STORE, AMDGPUDimCube, 511 },
    { IMAGE_STORE_MIP, AMDGPUDim1D, 512 },
    { IMAGE_STORE_MIP, AMDGPUDim1DArray, 513 },
    { IMAGE_STORE_MIP, AMDGPUDim2D, 514 },
    { IMAGE_STORE_MIP, AMDGPUDim2DArray, 515 },
    { IMAGE_STORE_MIP, AMDGPUDim3D, 516 },
    { IMAGE_STORE_MIP, AMDGPUDimCube, 517 },
  };

  struct KeyType {
    unsigned BaseOpcode;
    unsigned Dim;
  };
  KeyType Key = {BaseOpcode, Dim};
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      if ((unsigned)LHS.BaseOpcode < (unsigned)RHS.BaseOpcode)
        return true;
      if ((unsigned)LHS.BaseOpcode > (unsigned)RHS.BaseOpcode)
        return false;
      if ((unsigned)LHS.Dim < (unsigned)RHS.Dim)
        return true;
      if ((unsigned)LHS.Dim > (unsigned)RHS.Dim)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.BaseOpcode != Idx->BaseOpcode ||
      Key.Dim != Idx->Dim)
    return nullptr;
  return &ImageDimIntrinsicTable[Idx->_index];
}
#endif

#ifdef GET_MAIInstInfoTable_DECL
const MAIInstInfo *getMAIInstInfoHelper(unsigned Opcode);
#endif

#ifdef GET_MAIInstInfoTable_IMPL
constexpr MAIInstInfo MAIInstInfoTable[] = {
  { V_MFMA_F32_16X16X16BF16_1K_e64, false, true }, // 0
  { V_MFMA_F32_16X16X16BF16_1K_vgprcd_e64, false, true }, // 1
  { V_MFMA_F32_16X16X16F16_e64, false, true }, // 2
  { V_MFMA_F32_16X16X16F16_vgprcd_e64, false, true }, // 3
  { V_MFMA_F32_16X16X1F32_e64, false, false }, // 4
  { V_MFMA_F32_16X16X1F32_mac_e64, false, false }, // 5
  { V_MFMA_F32_16X16X1F32_mac_vgprcd_e64, false, false }, // 6
  { V_MFMA_F32_16X16X1F32_vgprcd_e64, false, false }, // 7
  { V_MFMA_F32_16X16X2BF16_e64, false, false }, // 8
  { V_MFMA_F32_16X16X2BF16_mac_e64, false, false }, // 9
  { V_MFMA_F32_16X16X2BF16_mac_vgprcd_e64, false, false }, // 10
  { V_MFMA_F32_16X16X2BF16_vgprcd_e64, false, false }, // 11
  { V_MFMA_F32_16X16X32_BF8_BF8_e64, false, true }, // 12
  { V_MFMA_F32_16X16X32_BF8_BF8_vgprcd_e64, false, true }, // 13
  { V_MFMA_F32_16X16X32_BF8_FP8_e64, false, true }, // 14
  { V_MFMA_F32_16X16X32_BF8_FP8_vgprcd_e64, false, true }, // 15
  { V_MFMA_F32_16X16X32_FP8_BF8_e64, false, true }, // 16
  { V_MFMA_F32_16X16X32_FP8_BF8_vgprcd_e64, false, true }, // 17
  { V_MFMA_F32_16X16X32_FP8_FP8_e64, false, true }, // 18
  { V_MFMA_F32_16X16X32_FP8_FP8_vgprcd_e64, false, true }, // 19
  { V_MFMA_F32_16X16X4BF16_1K_e64, false, true }, // 20
  { V_MFMA_F32_16X16X4BF16_1K_mac_e64, false, true }, // 21
  { V_MFMA_F32_16X16X4BF16_1K_mac_vgprcd_e64, false, true }, // 22
  { V_MFMA_F32_16X16X4BF16_1K_vgprcd_e64, false, true }, // 23
  { V_MFMA_F32_16X16X4F16_e64, false, true }, // 24
  { V_MFMA_F32_16X16X4F16_mac_e64, false, true }, // 25
  { V_MFMA_F32_16X16X4F16_mac_vgprcd_e64, false, true }, // 26
  { V_MFMA_F32_16X16X4F16_vgprcd_e64, false, true }, // 27
  { V_MFMA_F32_16X16X4F32_e64, false, false }, // 28
  { V_MFMA_F32_16X16X4F32_vgprcd_e64, false, false }, // 29
  { V_MFMA_F32_16X16X8BF16_e64, false, false }, // 30
  { V_MFMA_F32_16X16X8BF16_vgprcd_e64, false, false }, // 31
  { V_MFMA_F32_16X16X8XF32_e64, false, true }, // 32
  { V_MFMA_F32_16X16X8XF32_vgprcd_e64, false, true }, // 33
  { V_MFMA_F32_32X32X16_BF8_BF8_e64, false, true }, // 34
  { V_MFMA_F32_32X32X16_BF8_BF8_mac_e64, false, true }, // 35
  { V_MFMA_F32_32X32X16_BF8_BF8_mac_vgprcd_e64, false, true }, // 36
  { V_MFMA_F32_32X32X16_BF8_BF8_vgprcd_e64, false, true }, // 37
  { V_MFMA_F32_32X32X16_BF8_FP8_e64, false, true }, // 38
  { V_MFMA_F32_32X32X16_BF8_FP8_mac_e64, false, true }, // 39
  { V_MFMA_F32_32X32X16_BF8_FP8_mac_vgprcd_e64, false, true }, // 40
  { V_MFMA_F32_32X32X16_BF8_FP8_vgprcd_e64, false, true }, // 41
  { V_MFMA_F32_32X32X16_FP8_BF8_e64, false, true }, // 42
  { V_MFMA_F32_32X32X16_FP8_BF8_mac_e64, false, true }, // 43
  { V_MFMA_F32_32X32X16_FP8_BF8_mac_vgprcd_e64, false, true }, // 44
  { V_MFMA_F32_32X32X16_FP8_BF8_vgprcd_e64, false, true }, // 45
  { V_MFMA_F32_32X32X16_FP8_FP8_e64, false, true }, // 46
  { V_MFMA_F32_32X32X16_FP8_FP8_mac_e64, false, true }, // 47
  { V_MFMA_F32_32X32X16_FP8_FP8_mac_vgprcd_e64, false, true }, // 48
  { V_MFMA_F32_32X32X16_FP8_FP8_vgprcd_e64, false, true }, // 49
  { V_MFMA_F32_32X32X1F32_e64, false, false }, // 50
  { V_MFMA_F32_32X32X1F32_mac_e64, false, false }, // 51
  { V_MFMA_F32_32X32X1F32_mac_vgprcd_e64, false, false }, // 52
  { V_MFMA_F32_32X32X1F32_vgprcd_e64, false, false }, // 53
  { V_MFMA_F32_32X32X2BF16_e64, false, false }, // 54
  { V_MFMA_F32_32X32X2BF16_mac_e64, false, false }, // 55
  { V_MFMA_F32_32X32X2BF16_mac_vgprcd_e64, false, false }, // 56
  { V_MFMA_F32_32X32X2BF16_vgprcd_e64, false, false }, // 57
  { V_MFMA_F32_32X32X2F32_e64, false, false }, // 58
  { V_MFMA_F32_32X32X2F32_mac_e64, false, false }, // 59
  { V_MFMA_F32_32X32X2F32_mac_vgprcd_e64, false, false }, // 60
  { V_MFMA_F32_32X32X2F32_vgprcd_e64, false, false }, // 61
  { V_MFMA_F32_32X32X4BF16_1K_e64, false, true }, // 62
  { V_MFMA_F32_32X32X4BF16_1K_mac_e64, false, true }, // 63
  { V_MFMA_F32_32X32X4BF16_1K_mac_vgprcd_e64, false, true }, // 64
  { V_MFMA_F32_32X32X4BF16_1K_vgprcd_e64, false, true }, // 65
  { V_MFMA_F32_32X32X4BF16_e64, false, false }, // 66
  { V_MFMA_F32_32X32X4BF16_mac_e64, false, false }, // 67
  { V_MFMA_F32_32X32X4BF16_mac_vgprcd_e64, false, false }, // 68
  { V_MFMA_F32_32X32X4BF16_vgprcd_e64, false, false }, // 69
  { V_MFMA_F32_32X32X4F16_e64, false, true }, // 70
  { V_MFMA_F32_32X32X4F16_mac_e64, false, true }, // 71
  { V_MFMA_F32_32X32X4F16_mac_vgprcd_e64, false, true }, // 72
  { V_MFMA_F32_32X32X4F16_vgprcd_e64, false, true }, // 73
  { V_MFMA_F32_32X32X4XF32_e64, false, true }, // 74
  { V_MFMA_F32_32X32X4XF32_mac_e64, false, true }, // 75
  { V_MFMA_F32_32X32X4XF32_mac_vgprcd_e64, false, true }, // 76
  { V_MFMA_F32_32X32X4XF32_vgprcd_e64, false, true }, // 77
  { V_MFMA_F32_32X32X8BF16_1K_e64, false, true }, // 78
  { V_MFMA_F32_32X32X8BF16_1K_mac_e64, false, true }, // 79
  { V_MFMA_F32_32X32X8BF16_1K_mac_vgprcd_e64, false, true }, // 80
  { V_MFMA_F32_32X32X8BF16_1K_vgprcd_e64, false, true }, // 81
  { V_MFMA_F32_32X32X8F16_e64, false, true }, // 82
  { V_MFMA_F32_32X32X8F16_mac_e64, false, true }, // 83
  { V_MFMA_F32_32X32X8F16_mac_vgprcd_e64, false, true }, // 84
  { V_MFMA_F32_32X32X8F16_vgprcd_e64, false, true }, // 85
  { V_MFMA_F32_4X4X1F32_e64, false, false }, // 86
  { V_MFMA_F32_4X4X1F32_vgprcd_e64, false, false }, // 87
  { V_MFMA_F32_4X4X2BF16_e64, false, false }, // 88
  { V_MFMA_F32_4X4X2BF16_vgprcd_e64, false, false }, // 89
  { V_MFMA_F32_4X4X4BF16_1K_e64, false, true }, // 90
  { V_MFMA_F32_4X4X4BF16_1K_vgprcd_e64, false, true }, // 91
  { V_MFMA_F32_4X4X4F16_e64, false, true }, // 92
  { V_MFMA_F32_4X4X4F16_vgprcd_e64, false, true }, // 93
  { V_MFMA_F64_16X16X4F64_e64, true, false }, // 94
  { V_MFMA_F64_16X16X4F64_mac_e64, true, false }, // 95
  { V_MFMA_F64_16X16X4F64_mac_vgprcd_e64, true, false }, // 96
  { V_MFMA_F64_16X16X4F64_vgprcd_e64, true, false }, // 97
  { V_MFMA_F64_4X4X4F64_e64, true, false }, // 98
  { V_MFMA_F64_4X4X4F64_vgprcd_e64, true, false }, // 99
  { V_MFMA_I32_16X16X16I8_e64, false, false }, // 100
  { V_MFMA_I32_16X16X16I8_vgprcd_e64, false, false }, // 101
  { V_MFMA_I32_16X16X32I8_e64, false, true }, // 102
  { V_MFMA_I32_16X16X32I8_vgprcd_e64, false, true }, // 103
  { V_MFMA_I32_16X16X4I8_e64, false, true }, // 104
  { V_MFMA_I32_16X16X4I8_mac_e64, false, true }, // 105
  { V_MFMA_I32_16X16X4I8_mac_vgprcd_e64, false, true }, // 106
  { V_MFMA_I32_16X16X4I8_vgprcd_e64, false, true }, // 107
  { V_MFMA_I32_32X32X16I8_e64, false, true }, // 108
  { V_MFMA_I32_32X32X16I8_mac_e64, false, true }, // 109
  { V_MFMA_I32_32X32X16I8_mac_vgprcd_e64, false, true }, // 110
  { V_MFMA_I32_32X32X16I8_vgprcd_e64, false, true }, // 111
  { V_MFMA_I32_32X32X4I8_e64, false, true }, // 112
  { V_MFMA_I32_32X32X4I8_mac_e64, false, true }, // 113
  { V_MFMA_I32_32X32X4I8_mac_vgprcd_e64, false, true }, // 114
  { V_MFMA_I32_32X32X4I8_vgprcd_e64, false, true }, // 115
  { V_MFMA_I32_32X32X8I8_e64, false, false }, // 116
  { V_MFMA_I32_32X32X8I8_mac_e64, false, false }, // 117
  { V_MFMA_I32_32X32X8I8_mac_vgprcd_e64, false, false }, // 118
  { V_MFMA_I32_32X32X8I8_vgprcd_e64, false, false }, // 119
  { V_MFMA_I32_4X4X4I8_e64, false, true }, // 120
  { V_MFMA_I32_4X4X4I8_vgprcd_e64, false, true }, // 121
  { V_SMFMAC_F32_16X16X32_BF16_e64, false, true }, // 122
  { V_SMFMAC_F32_16X16X32_F16_e64, false, true }, // 123
  { V_SMFMAC_F32_16X16X64_BF8_BF8_e64, false, true }, // 124
  { V_SMFMAC_F32_16X16X64_BF8_FP8_e64, false, true }, // 125
  { V_SMFMAC_F32_16X16X64_FP8_BF8_e64, false, true }, // 126
  { V_SMFMAC_F32_16X16X64_FP8_FP8_e64, false, true }, // 127
  { V_SMFMAC_F32_32X32X16_BF16_e64, false, true }, // 128
  { V_SMFMAC_F32_32X32X16_F16_e64, false, true }, // 129
  { V_SMFMAC_F32_32X32X32_BF8_BF8_e64, false, true }, // 130
  { V_SMFMAC_F32_32X32X32_BF8_FP8_e64, false, true }, // 131
  { V_SMFMAC_F32_32X32X32_FP8_BF8_e64, false, true }, // 132
  { V_SMFMAC_F32_32X32X32_FP8_FP8_e64, false, true }, // 133
  { V_SMFMAC_I32_16X16X64_I8_e64, false, true }, // 134
  { V_SMFMAC_I32_32X32X32_I8_e64, false, true }, // 135
 };

const MAIInstInfo *getMAIInstInfoHelper(unsigned Opcode) {
  struct KeyType {
    unsigned Opcode;
  };
  KeyType Key = {Opcode};
  auto Table = ArrayRef(MAIInstInfoTable);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const MAIInstInfo &LHS, const KeyType &RHS) {
      if (LHS.Opcode < RHS.Opcode)
        return true;
      if (LHS.Opcode > RHS.Opcode)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Opcode != Idx->Opcode)
    return nullptr;
  return &*Idx;
}
#endif

#ifdef GET_MIMGBaseOpcodesTable_DECL
const MIMGBaseOpcodeInfo *getMIMGBaseOpcodeInfo(unsigned BaseOpcode);
#endif

#ifdef GET_MIMGBaseOpcodesTable_IMPL
constexpr MIMGBaseOpcodeInfo MIMGBaseOpcodesTable[] = {
  { IMAGE_ATOMIC_ADD, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false }, // 0
  { IMAGE_ATOMIC_ADD_FLT, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false }, // 1
  { IMAGE_ATOMIC_AND, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false }, // 2
  { IMAGE_ATOMIC_CMPSWAP, false, true, true, false, false, 0x0, false, false, true, false, false, false, false, false }, // 3
  { IMAGE_ATOMIC_DEC, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false }, // 4
  { IMAGE_ATOMIC_FCMPSWAP, false, true, true, false, false, 0x0, false, false, true, false, false, false, false, false }, // 5
  { IMAGE_ATOMIC_FMAX, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false }, // 6
  { IMAGE_ATOMIC_FMIN, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false }, // 7
  { IMAGE_ATOMIC_INC, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false }, // 8
  { IMAGE_ATOMIC_MAX_FLT, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false }, // 9
  { IMAGE_ATOMIC_MIN_FLT, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false }, // 10
  { IMAGE_ATOMIC_OR, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false }, // 11
  { IMAGE_ATOMIC_PK_ADD_BF16, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false }, // 12
  { IMAGE_ATOMIC_PK_ADD_F16, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false }, // 13
  { IMAGE_ATOMIC_RSUB, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false }, // 14
  { IMAGE_ATOMIC_SMAX, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false }, // 15
  { IMAGE_ATOMIC_SMIN, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false }, // 16
  { IMAGE_ATOMIC_SUB, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false }, // 17
  { IMAGE_ATOMIC_SWAP, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false }, // 18
  { IMAGE_ATOMIC_UMAX, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false }, // 19
  { IMAGE_ATOMIC_UMIN, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false }, // 20
  { IMAGE_ATOMIC_XOR, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false }, // 21
  { IMAGE_BVH64_INTERSECT_RAY, false, false, false, false, false, 0x0, false, false, true, false, false, false, true, false }, // 22
  { IMAGE_BVH64_INTERSECT_RAY_a16, false, false, false, false, false, 0x0, false, false, true, false, false, false, true, true }, // 23
  { IMAGE_BVH_INTERSECT_RAY, false, false, false, false, false, 0x0, false, false, true, false, false, false, true, false }, // 24
  { IMAGE_BVH_INTERSECT_RAY_a16, false, false, false, false, false, 0x0, false, false, true, false, false, false, true, true }, // 25
  { IMAGE_GATHER4, false, false, false, true, true, 0x0, false, false, true, false, true, false, false, false }, // 26
  { IMAGE_GATHER4H, false, false, false, true, true, 0x0, false, false, true, false, true, false, false, false }, // 27
  { IMAGE_GATHER4_B, false, false, false, true, true, 0x1, false, false, true, false, true, false, false, false }, // 28
  { IMAGE_GATHER4_B_CL, false, false, false, true, true, 0x1, false, false, true, true, true, false, false, false }, // 29
  { IMAGE_GATHER4_B_CL_O, false, false, false, true, true, 0x2, false, false, true, true, true, false, false, false }, // 30
  { IMAGE_GATHER4_B_O, false, false, false, true, true, 0x2, false, false, true, false, true, false, false, false }, // 31
  { IMAGE_GATHER4_C, false, false, false, true, true, 0x1, false, false, true, false, true, false, false, false }, // 32
  { IMAGE_GATHER4_CL, false, false, false, true, true, 0x0, false, false, true, true, true, false, false, false }, // 33
  { IMAGE_GATHER4_CL_O, false, false, false, true, true, 0x1, false, false, true, true, true, false, false, false }, // 34
  { IMAGE_GATHER4_C_B, false, false, false, true, true, 0x2, false, false, true, false, true, false, false, false }, // 35
  { IMAGE_GATHER4_C_B_CL, false, false, false, true, true, 0x2, false, false, true, true, true, false, false, false }, // 36
  { IMAGE_GATHER4_C_B_CL_O, false, false, false, true, true, 0x3, false, false, true, true, true, false, false, false }, // 37
  { IMAGE_GATHER4_C_B_O, false, false, false, true, true, 0x3, false, false, true, false, true, false, false, false }, // 38
  { IMAGE_GATHER4_C_CL, false, false, false, true, true, 0x1, false, false, true, true, true, false, false, false }, // 39
  { IMAGE_GATHER4_C_CL_O, false, false, false, true, true, 0x2, false, false, true, true, true, false, false, false }, // 40
  { IMAGE_GATHER4_C_L, false, false, false, true, true, 0x1, false, false, true, true, true, false, false, false }, // 41
  { IMAGE_GATHER4_C_LZ, false, false, false, true, true, 0x1, false, false, true, false, true, false, false, false }, // 42
  { IMAGE_GATHER4_C_LZ_O, false, false, false, true, true, 0x2, false, false, true, false, true, false, false, false }, // 43
  { IMAGE_GATHER4_C_L_O, false, false, false, true, true, 0x2, false, false, true, true, true, false, false, false }, // 44
  { IMAGE_GATHER4_C_O, false, false, false, true, true, 0x2, false, false, true, false, true, false, false, false }, // 45
  { IMAGE_GATHER4_L, false, false, false, true, true, 0x0, false, false, true, true, true, false, false, false }, // 46
  { IMAGE_GATHER4_LZ, false, false, false, true, true, 0x0, false, false, true, false, true, false, false, false }, // 47
  { IMAGE_GATHER4_LZ_O, false, false, false, true, true, 0x1, false, false, true, false, true, false, false, false }, // 48
  { IMAGE_GATHER4_L_O, false, false, false, true, true, 0x1, false, false, true, true, true, false, false, false }, // 49
  { IMAGE_GATHER4_O, false, false, false, true, true, 0x1, false, false, true, false, true, false, false, false }, // 50
  { IMAGE_GET_LOD, false, false, false, true, false, 0x0, false, false, true, false, false, false, false, false }, // 51
  { IMAGE_GET_RESINFO, false, false, false, false, false, 0x0, false, false, false, true, false, false, false, false }, // 52
  { IMAGE_LOAD, false, false, false, false, false, 0x0, false, false, true, false, true, false, false, false }, // 53
  { IMAGE_LOAD_MIP, false, false, false, false, false, 0x0, false, false, true, true, true, false, false, false }, // 54
  { IMAGE_LOAD_MIP_PCK, false, false, false, false, false, 0x0, false, false, true, true, false, false, false, false }, // 55
  { IMAGE_LOAD_MIP_PCK_SGN, false, false, false, false, false, 0x0, false, false, true, true, false, false, false, false }, // 56
  { IMAGE_LOAD_PCK, false, false, false, false, false, 0x0, false, false, true, false, false, false, false, false }, // 57
  { IMAGE_LOAD_PCK_SGN, false, false, false, false, false, 0x0, false, false, true, false, false, false, false, false }, // 58
  { IMAGE_MSAA_LOAD, false, false, false, false, true, 0x0, false, false, true, false, true, true, false, false }, // 59
  { IMAGE_MSAA_LOAD_X, false, false, false, false, false, 0x0, false, false, true, false, true, true, false, false }, // 60
  { IMAGE_SAMPLE, false, false, false, true, false, 0x0, false, false, true, false, true, false, false, false }, // 61
  { IMAGE_SAMPLE_B, false, false, false, true, false, 0x1, false, false, true, false, true, false, false, false }, // 62
  { IMAGE_SAMPLE_B_CL, false, false, false, true, false, 0x1, false, false, true, true, true, false, false, false }, // 63
  { IMAGE_SAMPLE_B_CL_O, false, false, false, true, false, 0x2, false, false, true, true, true, false, false, false }, // 64
  { IMAGE_SAMPLE_B_O, false, false, false, true, false, 0x2, false, false, true, false, true, false, false, false }, // 65
  { IMAGE_SAMPLE_C, false, false, false, true, false, 0x1, false, false, true, false, true, false, false, false }, // 66
  { IMAGE_SAMPLE_CD, false, false, false, true, false, 0x0, true, false, true, false, true, false, false, false }, // 67
  { IMAGE_SAMPLE_CD_CL, false, false, false, true, false, 0x0, true, false, true, true, true, false, false, false }, // 68
  { IMAGE_SAMPLE_CD_CL_G16, false, false, false, true, false, 0x0, true, true, true, true, true, false, false, false }, // 69
  { IMAGE_SAMPLE_CD_CL_O, false, false, false, true, false, 0x1, true, false, true, true, true, false, false, false }, // 70
  { IMAGE_SAMPLE_CD_CL_O_G16, false, false, false, true, false, 0x1, true, true, true, true, true, false, false, false }, // 71
  { IMAGE_SAMPLE_CD_G16, false, false, false, true, false, 0x0, true, true, true, false, true, false, false, false }, // 72
  { IMAGE_SAMPLE_CD_O, false, false, false, true, false, 0x1, true, false, true, false, true, false, false, false }, // 73
  { IMAGE_SAMPLE_CD_O_G16, false, false, false, true, false, 0x1, true, true, true, false, true, false, false, false }, // 74
  { IMAGE_SAMPLE_CL, false, false, false, true, false, 0x0, false, false, true, true, true, false, false, false }, // 75
  { IMAGE_SAMPLE_CL_O, false, false, false, true, false, 0x1, false, false, true, true, true, false, false, false }, // 76
  { IMAGE_SAMPLE_C_B, false, false, false, true, false, 0x2, false, false, true, false, true, false, false, false }, // 77
  { IMAGE_SAMPLE_C_B_CL, false, false, false, true, false, 0x2, false, false, true, true, true, false, false, false }, // 78
  { IMAGE_SAMPLE_C_B_CL_O, false, false, false, true, false, 0x3, false, false, true, true, true, false, false, false }, // 79
  { IMAGE_SAMPLE_C_B_O, false, false, false, true, false, 0x3, false, false, true, false, true, false, false, false }, // 80
  { IMAGE_SAMPLE_C_CD, false, false, false, true, false, 0x1, true, false, true, false, true, false, false, false }, // 81
  { IMAGE_SAMPLE_C_CD_CL, false, false, false, true, false, 0x1, true, false, true, true, true, false, false, false }, // 82
  { IMAGE_SAMPLE_C_CD_CL_G16, false, false, false, true, false, 0x1, true, true, true, true, true, false, false, false }, // 83
  { IMAGE_SAMPLE_C_CD_CL_O, false, false, false, true, false, 0x2, true, false, true, true, true, false, false, false }, // 84
  { IMAGE_SAMPLE_C_CD_CL_O_G16, false, false, false, true, false, 0x2, true, true, true, true, true, false, false, false }, // 85
  { IMAGE_SAMPLE_C_CD_G16, false, false, false, true, false, 0x1, true, true, true, false, true, false, false, false }, // 86
  { IMAGE_SAMPLE_C_CD_O, false, false, false, true, false, 0x2, true, false, true, false, true, false, false, false }, // 87
  { IMAGE_SAMPLE_C_CD_O_G16, false, false, false, true, false, 0x2, true, true, true, false, true, false, false, false }, // 88
  { IMAGE_SAMPLE_C_CL, false, false, false, true, false, 0x1, false, false, true, true, true, false, false, false }, // 89
  { IMAGE_SAMPLE_C_CL_O, false, false, false, true, false, 0x2, false, false, true, true, true, false, false, false }, // 90
  { IMAGE_SAMPLE_C_D, false, false, false, true, false, 0x1, true, false, true, false, true, false, false, false }, // 91
  { IMAGE_SAMPLE_C_D_CL, false, false, false, true, false, 0x1, true, false, true, true, true, false, false, false }, // 92
  { IMAGE_SAMPLE_C_D_CL_G16, false, false, false, true, false, 0x1, true, true, true, true, true, false, false, false }, // 93
  { IMAGE_SAMPLE_C_D_CL_O, false, false, false, true, false, 0x2, true, false, true, true, true, false, false, false }, // 94
  { IMAGE_SAMPLE_C_D_CL_O_G16, false, false, false, true, false, 0x2, true, true, true, true, true, false, false, false }, // 95
  { IMAGE_SAMPLE_C_D_G16, false, false, false, true, false, 0x1, true, true, true, false, true, false, false, false }, // 96
  { IMAGE_SAMPLE_C_D_O, false, false, false, true, false, 0x2, true, false, true, false, true, false, false, false }, // 97
  { IMAGE_SAMPLE_C_D_O_G16, false, false, false, true, false, 0x2, true, true, true, false, true, false, false, false }, // 98
  { IMAGE_SAMPLE_C_L, false, false, false, true, false, 0x1, false, false, true, true, true, false, false, false }, // 99
  { IMAGE_SAMPLE_C_LZ, false, false, false, true, false, 0x1, false, false, true, false, true, false, false, false }, // 100
  { IMAGE_SAMPLE_C_LZ_O, false, false, false, true, false, 0x2, false, false, true, false, true, false, false, false }, // 101
  { IMAGE_SAMPLE_C_L_O, false, false, false, true, false, 0x2, false, false, true, true, true, false, false, false }, // 102
  { IMAGE_SAMPLE_C_O, false, false, false, true, false, 0x2, false, false, true, false, true, false, false, false }, // 103
  { IMAGE_SAMPLE_D, false, false, false, true, false, 0x0, true, false, true, false, true, false, false, false }, // 104
  { IMAGE_SAMPLE_D_CL, false, false, false, true, false, 0x0, true, false, true, true, true, false, false, false }, // 105
  { IMAGE_SAMPLE_D_CL_G16, false, false, false, true, false, 0x0, true, true, true, true, true, false, false, false }, // 106
  { IMAGE_SAMPLE_D_CL_O, false, false, false, true, false, 0x1, true, false, true, true, true, false, false, false }, // 107
  { IMAGE_SAMPLE_D_CL_O_G16, false, false, false, true, false, 0x1, true, true, true, true, true, false, false, false }, // 108
  { IMAGE_SAMPLE_D_G16, false, false, false, true, false, 0x0, true, true, true, false, true, false, false, false }, // 109
  { IMAGE_SAMPLE_D_O, false, false, false, true, false, 0x1, true, false, true, false, true, false, false, false }, // 110
  { IMAGE_SAMPLE_D_O_G16, false, false, false, true, false, 0x1, true, true, true, false, true, false, false, false }, // 111
  { IMAGE_SAMPLE_L, false, false, false, true, false, 0x0, false, false, true, true, true, false, false, false }, // 112
  { IMAGE_SAMPLE_LZ, false, false, false, true, false, 0x0, false, false, true, false, true, false, false, false }, // 113
  { IMAGE_SAMPLE_LZ_O, false, false, false, true, false, 0x1, false, false, true, false, true, false, false, false }, // 114
  { IMAGE_SAMPLE_L_O, false, false, false, true, false, 0x1, false, false, true, true, true, false, false, false }, // 115
  { IMAGE_SAMPLE_O, false, false, false, true, false, 0x1, false, false, true, false, true, false, false, false }, // 116
  { IMAGE_STORE, true, false, false, false, false, 0x0, false, false, true, false, true, false, false, false }, // 117
  { IMAGE_STORE_MIP, true, false, false, false, false, 0x0, false, false, true, true, true, false, false, false }, // 118
  { IMAGE_STORE_MIP_PCK, true, false, false, false, false, 0x0, false, false, true, true, false, false, false, false }, // 119
  { IMAGE_STORE_PCK, true, false, false, false, false, 0x0, false, false, true, false, false, false, false, false }, // 120
 };

const MIMGBaseOpcodeInfo *getMIMGBaseOpcodeInfo(unsigned BaseOpcode) {
  auto Table = ArrayRef(MIMGBaseOpcodesTable);
  size_t Idx = BaseOpcode;
  return Idx >= Table.size() ? nullptr : &Table[Idx];
}
#endif

#ifdef GET_MIMGBiasMappingTable_DECL
const MIMGBiasMappingInfo *getMIMGBiasMappingInfo(unsigned Bias);
#endif

#ifdef GET_MIMGBiasMappingTable_IMPL
constexpr MIMGBiasMappingInfo MIMGBiasMappingTable[] = {
  { IMAGE_GATHER4_B, IMAGE_GATHER4 }, // 0
  { IMAGE_GATHER4_B_CL, IMAGE_GATHER4_CL }, // 1
  { IMAGE_GATHER4_B_CL_O, IMAGE_GATHER4_CL_O }, // 2
  { IMAGE_GATHER4_B_O, IMAGE_GATHER4_O }, // 3
  { IMAGE_GATHER4_C_B, IMAGE_GATHER4_C }, // 4
  { IMAGE_GATHER4_C_B_CL, IMAGE_GATHER4_C_CL }, // 5
  { IMAGE_GATHER4_C_B_CL_O, IMAGE_GATHER4_C_CL_O }, // 6
  { IMAGE_GATHER4_C_B_O, IMAGE_GATHER4_C_O }, // 7
  { IMAGE_SAMPLE_B, IMAGE_SAMPLE }, // 8
  { IMAGE_SAMPLE_B_CL, IMAGE_SAMPLE_CL }, // 9
  { IMAGE_SAMPLE_B_CL_O, IMAGE_SAMPLE_CL_O }, // 10
  { IMAGE_SAMPLE_B_O, IMAGE_SAMPLE_O }, // 11
  { IMAGE_SAMPLE_C_B, IMAGE_SAMPLE_C }, // 12
  { IMAGE_SAMPLE_C_B_CL, IMAGE_SAMPLE_C_CL }, // 13
  { IMAGE_SAMPLE_C_B_CL_O, IMAGE_SAMPLE_C_CL_O }, // 14
  { IMAGE_SAMPLE_C_B_O, IMAGE_SAMPLE_C_O }, // 15
 };

const MIMGBiasMappingInfo *getMIMGBiasMappingInfo(unsigned Bias) {
  struct KeyType {
    unsigned Bias;
  };
  KeyType Key = {Bias};
  auto Table = ArrayRef(MIMGBiasMappingTable);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const MIMGBiasMappingInfo &LHS, const KeyType &RHS) {
      if ((unsigned)LHS.Bias < (unsigned)RHS.Bias)
        return true;
      if ((unsigned)LHS.Bias > (unsigned)RHS.Bias)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Bias != Idx->Bias)
    return nullptr;
  return &*Idx;
}
#endif

#ifdef GET_MIMGDimInfoTable_DECL
const MIMGDimInfo *getMIMGDimInfo(unsigned Dim);
const MIMGDimInfo *getMIMGDimInfoByAsmSuffix(StringRef AsmSuffix);
const MIMGDimInfo *getMIMGDimInfoByEncoding(uint8_t Encoding);
#endif

#ifdef GET_MIMGDimInfoTable_IMPL
constexpr MIMGDimInfo MIMGDimInfoTable[] = {
  { AMDGPUDim1D, 0x1, 0x2, false, false, 0x0, "1D" }, // 0
  { AMDGPUDim1DArray, 0x2, 0x2, false, true, 0x4, "1D_ARRAY" }, // 1
  { AMDGPUDim2D, 0x2, 0x4, false, false, 0x1, "2D" }, // 2
  { AMDGPUDim2DArray, 0x3, 0x4, false, true, 0x5, "2D_ARRAY" }, // 3
  { AMDGPUDim2DArrayMsaa, 0x4, 0x4, true, true, 0x7, "2D_MSAA_ARRAY" }, // 4
  { AMDGPUDim2DMsaa, 0x3, 0x4, true, false, 0x6, "2D_MSAA" }, // 5
  { AMDGPUDim3D, 0x3, 0x6, false, false, 0x2, "3D" }, // 6
  { AMDGPUDimCube, 0x3, 0x4, false, true, 0x3, "CUBE" }, // 7
 };

const MIMGDimInfo *getMIMGDimInfo(unsigned Dim) {
  auto Table = ArrayRef(MIMGDimInfoTable);
  size_t Idx = Dim;
  return Idx >= Table.size() ? nullptr : &Table[Idx];
}

const MIMGDimInfo *getMIMGDimInfoByAsmSuffix(StringRef AsmSuffix) {
  struct IndexType {
    const char * AsmSuffix;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { "1D", 0 },
    { "1D_ARRAY", 1 },
    { "2D", 2 },
    { "2D_ARRAY", 3 },
    { "2D_MSAA", 5 },
    { "2D_MSAA_ARRAY", 4 },
    { "3D", 6 },
    { "CUBE", 7 },
  };

  struct KeyType {
    std::string AsmSuffix;
  };
  KeyType Key = {AsmSuffix.upper()};
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      int CmpAsmSuffix = StringRef(LHS.AsmSuffix).compare(RHS.AsmSuffix);
      if (CmpAsmSuffix < 0) return true;
      if (CmpAsmSuffix > 0) return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.AsmSuffix != Idx->AsmSuffix)
    return nullptr;
  return &MIMGDimInfoTable[Idx->_index];
}

const MIMGDimInfo *getMIMGDimInfoByEncoding(uint8_t Encoding) {
  struct IndexType {
    uint8_t Encoding;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { 0x0, 0 },
    { 0x1, 2 },
    { 0x2, 6 },
    { 0x3, 7 },
    { 0x4, 1 },
    { 0x5, 3 },
    { 0x6, 5 },
    { 0x7, 4 },
  };

  auto Table = ArrayRef(Index);
  size_t Idx = Encoding;
  return Idx >= Table.size() ? nullptr : &MIMGDimInfoTable[Table[Idx]._index];
}
#endif

#ifdef GET_MIMGG16MappingTable_DECL
const MIMGG16MappingInfo *getMIMGG16MappingInfo(unsigned G);
#endif

#ifdef GET_MIMGG16MappingTable_IMPL
constexpr MIMGG16MappingInfo MIMGG16MappingTable[] = {
  { IMAGE_SAMPLE_CD, IMAGE_SAMPLE_CD_G16 }, // 0
  { IMAGE_SAMPLE_CD_CL, IMAGE_SAMPLE_CD_CL_G16 }, // 1
  { IMAGE_SAMPLE_CD_CL_O, IMAGE_SAMPLE_CD_CL_O_G16 }, // 2
  { IMAGE_SAMPLE_CD_O, IMAGE_SAMPLE_CD_O_G16 }, // 3
  { IMAGE_SAMPLE_C_CD, IMAGE_SAMPLE_C_CD_G16 }, // 4
  { IMAGE_SAMPLE_C_CD_CL, IMAGE_SAMPLE_C_CD_CL_G16 }, // 5
  { IMAGE_SAMPLE_C_CD_CL_O, IMAGE_SAMPLE_C_CD_CL_O_G16 }, // 6
  { IMAGE_SAMPLE_C_CD_O, IMAGE_SAMPLE_C_CD_O_G16 }, // 7
  { IMAGE_SAMPLE_C_D, IMAGE_SAMPLE_C_D_G16 }, // 8
  { IMAGE_SAMPLE_C_D_CL, IMAGE_SAMPLE_C_D_CL_G16 }, // 9
  { IMAGE_SAMPLE_C_D_CL_O, IMAGE_SAMPLE_C_D_CL_O_G16 }, // 10
  { IMAGE_SAMPLE_C_D_O, IMAGE_SAMPLE_C_D_O_G16 }, // 11
  { IMAGE_SAMPLE_D, IMAGE_SAMPLE_D_G16 }, // 12
  { IMAGE_SAMPLE_D_CL, IMAGE_SAMPLE_D_CL_G16 }, // 13
  { IMAGE_SAMPLE_D_CL_O, IMAGE_SAMPLE_D_CL_O_G16 }, // 14
  { IMAGE_SAMPLE_D_O, IMAGE_SAMPLE_D_O_G16 }, // 15
 };

const MIMGG16MappingInfo *getMIMGG16MappingInfo(unsigned G) {
  struct KeyType {
    unsigned G;
  };
  KeyType Key = {G};
  auto Table = ArrayRef(MIMGG16MappingTable);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const MIMGG16MappingInfo &LHS, const KeyType &RHS) {
      if ((unsigned)LHS.G < (unsigned)RHS.G)
        return true;
      if ((unsigned)LHS.G > (unsigned)RHS.G)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.G != Idx->G)
    return nullptr;
  return &*Idx;
}
#endif

#ifdef GET_MIMGInfoTable_DECL
const MIMGInfo *getMIMGOpcodeHelper(unsigned BaseOpcode, unsigned MIMGEncoding, uint8_t VDataDwords, uint8_t VAddrDwords);
const MIMGInfo *getMIMGInfo(unsigned Opcode);
#endif

#ifdef GET_MIMGInfoTable_IMPL
constexpr MIMGInfo MIMGInfoTable[] = {
  { IMAGE_ATOMIC_ADD_V1_V1_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 0
  { IMAGE_ATOMIC_ADD_V1_V2_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 1
  { IMAGE_ATOMIC_ADD_V1_V3_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 2
  { IMAGE_ATOMIC_ADD_V1_V4_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 3
  { IMAGE_ATOMIC_ADD_V2_V1_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 4
  { IMAGE_ATOMIC_ADD_V2_V2_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 5
  { IMAGE_ATOMIC_ADD_V2_V3_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 6
  { IMAGE_ATOMIC_ADD_V2_V4_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 7
  { IMAGE_ATOMIC_ADD_V1_V2_nsa_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 8
  { IMAGE_ATOMIC_ADD_V1_V3_nsa_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 9
  { IMAGE_ATOMIC_ADD_V1_V4_nsa_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 10
  { IMAGE_ATOMIC_ADD_V2_V2_nsa_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 11
  { IMAGE_ATOMIC_ADD_V2_V3_nsa_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 12
  { IMAGE_ATOMIC_ADD_V2_V4_nsa_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 13
  { IMAGE_ATOMIC_ADD_V1_V1_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 14
  { IMAGE_ATOMIC_ADD_V1_V2_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 15
  { IMAGE_ATOMIC_ADD_V1_V3_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 16
  { IMAGE_ATOMIC_ADD_V1_V4_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 17
  { IMAGE_ATOMIC_ADD_V2_V1_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 18
  { IMAGE_ATOMIC_ADD_V2_V2_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 19
  { IMAGE_ATOMIC_ADD_V2_V3_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 20
  { IMAGE_ATOMIC_ADD_V2_V4_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 21
  { IMAGE_ATOMIC_ADD_V1_V2_nsa_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 22
  { IMAGE_ATOMIC_ADD_V1_V3_nsa_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 23
  { IMAGE_ATOMIC_ADD_V1_V4_nsa_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 24
  { IMAGE_ATOMIC_ADD_V2_V2_nsa_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 25
  { IMAGE_ATOMIC_ADD_V2_V3_nsa_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 26
  { IMAGE_ATOMIC_ADD_V2_V4_nsa_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 27
  { IMAGE_ATOMIC_ADD_V1_V1_gfx12, IMAGE_ATOMIC_ADD, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 28
  { IMAGE_ATOMIC_ADD_V1_V2_gfx12, IMAGE_ATOMIC_ADD, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 29
  { IMAGE_ATOMIC_ADD_V1_V3_gfx12, IMAGE_ATOMIC_ADD, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 30
  { IMAGE_ATOMIC_ADD_V1_V4_gfx12, IMAGE_ATOMIC_ADD, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 31
  { IMAGE_ATOMIC_ADD_V2_V1_gfx12, IMAGE_ATOMIC_ADD, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 32
  { IMAGE_ATOMIC_ADD_V2_V2_gfx12, IMAGE_ATOMIC_ADD, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 33
  { IMAGE_ATOMIC_ADD_V2_V3_gfx12, IMAGE_ATOMIC_ADD, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 34
  { IMAGE_ATOMIC_ADD_V2_V4_gfx12, IMAGE_ATOMIC_ADD, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 35
  { IMAGE_ATOMIC_ADD_V1_V1_si, IMAGE_ATOMIC_ADD, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 36
  { IMAGE_ATOMIC_ADD_V1_V2_si, IMAGE_ATOMIC_ADD, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 37
  { IMAGE_ATOMIC_ADD_V1_V3_si, IMAGE_ATOMIC_ADD, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 38
  { IMAGE_ATOMIC_ADD_V1_V4_si, IMAGE_ATOMIC_ADD, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 39
  { IMAGE_ATOMIC_ADD_V2_V1_si, IMAGE_ATOMIC_ADD, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 40
  { IMAGE_ATOMIC_ADD_V2_V2_si, IMAGE_ATOMIC_ADD, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 41
  { IMAGE_ATOMIC_ADD_V2_V3_si, IMAGE_ATOMIC_ADD, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 42
  { IMAGE_ATOMIC_ADD_V2_V4_si, IMAGE_ATOMIC_ADD, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 43
  { IMAGE_ATOMIC_ADD_V1_V1_vi, IMAGE_ATOMIC_ADD, MIMGEncGfx8, 0x1, 0x1, 0x1 }, // 44
  { IMAGE_ATOMIC_ADD_V1_V2_vi, IMAGE_ATOMIC_ADD, MIMGEncGfx8, 0x1, 0x2, 0x1 }, // 45
  { IMAGE_ATOMIC_ADD_V1_V3_vi, IMAGE_ATOMIC_ADD, MIMGEncGfx8, 0x1, 0x3, 0x1 }, // 46
  { IMAGE_ATOMIC_ADD_V1_V4_vi, IMAGE_ATOMIC_ADD, MIMGEncGfx8, 0x1, 0x4, 0x1 }, // 47
  { IMAGE_ATOMIC_ADD_V2_V1_vi, IMAGE_ATOMIC_ADD, MIMGEncGfx8, 0x2, 0x1, 0x1 }, // 48
  { IMAGE_ATOMIC_ADD_V2_V2_vi, IMAGE_ATOMIC_ADD, MIMGEncGfx8, 0x2, 0x2, 0x1 }, // 49
  { IMAGE_ATOMIC_ADD_V2_V3_vi, IMAGE_ATOMIC_ADD, MIMGEncGfx8, 0x2, 0x3, 0x1 }, // 50
  { IMAGE_ATOMIC_ADD_V2_V4_vi, IMAGE_ATOMIC_ADD, MIMGEncGfx8, 0x2, 0x4, 0x1 }, // 51
  { IMAGE_ATOMIC_ADD_V1_V1_gfx90a, IMAGE_ATOMIC_ADD, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 52
  { IMAGE_ATOMIC_ADD_V1_V2_gfx90a, IMAGE_ATOMIC_ADD, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 53
  { IMAGE_ATOMIC_ADD_V1_V3_gfx90a, IMAGE_ATOMIC_ADD, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 54
  { IMAGE_ATOMIC_ADD_V1_V4_gfx90a, IMAGE_ATOMIC_ADD, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 55
  { IMAGE_ATOMIC_ADD_V2_V1_gfx90a, IMAGE_ATOMIC_ADD, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 56
  { IMAGE_ATOMIC_ADD_V2_V2_gfx90a, IMAGE_ATOMIC_ADD, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 57
  { IMAGE_ATOMIC_ADD_V2_V3_gfx90a, IMAGE_ATOMIC_ADD, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 58
  { IMAGE_ATOMIC_ADD_V2_V4_gfx90a, IMAGE_ATOMIC_ADD, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 59
  { IMAGE_ATOMIC_ADD_FLT_V1_V1_gfx12, IMAGE_ATOMIC_ADD_FLT, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 60
  { IMAGE_ATOMIC_ADD_FLT_V1_V2_gfx12, IMAGE_ATOMIC_ADD_FLT, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 61
  { IMAGE_ATOMIC_ADD_FLT_V1_V3_gfx12, IMAGE_ATOMIC_ADD_FLT, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 62
  { IMAGE_ATOMIC_ADD_FLT_V1_V4_gfx12, IMAGE_ATOMIC_ADD_FLT, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 63
  { IMAGE_ATOMIC_ADD_FLT_V2_V1_gfx12, IMAGE_ATOMIC_ADD_FLT, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 64
  { IMAGE_ATOMIC_ADD_FLT_V2_V2_gfx12, IMAGE_ATOMIC_ADD_FLT, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 65
  { IMAGE_ATOMIC_ADD_FLT_V2_V3_gfx12, IMAGE_ATOMIC_ADD_FLT, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 66
  { IMAGE_ATOMIC_ADD_FLT_V2_V4_gfx12, IMAGE_ATOMIC_ADD_FLT, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 67
  { IMAGE_ATOMIC_AND_V1_V1_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 68
  { IMAGE_ATOMIC_AND_V1_V2_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 69
  { IMAGE_ATOMIC_AND_V1_V3_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 70
  { IMAGE_ATOMIC_AND_V1_V4_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 71
  { IMAGE_ATOMIC_AND_V2_V1_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 72
  { IMAGE_ATOMIC_AND_V2_V2_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 73
  { IMAGE_ATOMIC_AND_V2_V3_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 74
  { IMAGE_ATOMIC_AND_V2_V4_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 75
  { IMAGE_ATOMIC_AND_V1_V2_nsa_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 76
  { IMAGE_ATOMIC_AND_V1_V3_nsa_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 77
  { IMAGE_ATOMIC_AND_V1_V4_nsa_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 78
  { IMAGE_ATOMIC_AND_V2_V2_nsa_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 79
  { IMAGE_ATOMIC_AND_V2_V3_nsa_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 80
  { IMAGE_ATOMIC_AND_V2_V4_nsa_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 81
  { IMAGE_ATOMIC_AND_V1_V1_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 82
  { IMAGE_ATOMIC_AND_V1_V2_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 83
  { IMAGE_ATOMIC_AND_V1_V3_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 84
  { IMAGE_ATOMIC_AND_V1_V4_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 85
  { IMAGE_ATOMIC_AND_V2_V1_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 86
  { IMAGE_ATOMIC_AND_V2_V2_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 87
  { IMAGE_ATOMIC_AND_V2_V3_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 88
  { IMAGE_ATOMIC_AND_V2_V4_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 89
  { IMAGE_ATOMIC_AND_V1_V2_nsa_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 90
  { IMAGE_ATOMIC_AND_V1_V3_nsa_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 91
  { IMAGE_ATOMIC_AND_V1_V4_nsa_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 92
  { IMAGE_ATOMIC_AND_V2_V2_nsa_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 93
  { IMAGE_ATOMIC_AND_V2_V3_nsa_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 94
  { IMAGE_ATOMIC_AND_V2_V4_nsa_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 95
  { IMAGE_ATOMIC_AND_V1_V1_gfx12, IMAGE_ATOMIC_AND, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 96
  { IMAGE_ATOMIC_AND_V1_V2_gfx12, IMAGE_ATOMIC_AND, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 97
  { IMAGE_ATOMIC_AND_V1_V3_gfx12, IMAGE_ATOMIC_AND, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 98
  { IMAGE_ATOMIC_AND_V1_V4_gfx12, IMAGE_ATOMIC_AND, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 99
  { IMAGE_ATOMIC_AND_V2_V1_gfx12, IMAGE_ATOMIC_AND, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 100
  { IMAGE_ATOMIC_AND_V2_V2_gfx12, IMAGE_ATOMIC_AND, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 101
  { IMAGE_ATOMIC_AND_V2_V3_gfx12, IMAGE_ATOMIC_AND, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 102
  { IMAGE_ATOMIC_AND_V2_V4_gfx12, IMAGE_ATOMIC_AND, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 103
  { IMAGE_ATOMIC_AND_V1_V1_si, IMAGE_ATOMIC_AND, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 104
  { IMAGE_ATOMIC_AND_V1_V2_si, IMAGE_ATOMIC_AND, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 105
  { IMAGE_ATOMIC_AND_V1_V3_si, IMAGE_ATOMIC_AND, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 106
  { IMAGE_ATOMIC_AND_V1_V4_si, IMAGE_ATOMIC_AND, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 107
  { IMAGE_ATOMIC_AND_V2_V1_si, IMAGE_ATOMIC_AND, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 108
  { IMAGE_ATOMIC_AND_V2_V2_si, IMAGE_ATOMIC_AND, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 109
  { IMAGE_ATOMIC_AND_V2_V3_si, IMAGE_ATOMIC_AND, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 110
  { IMAGE_ATOMIC_AND_V2_V4_si, IMAGE_ATOMIC_AND, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 111
  { IMAGE_ATOMIC_AND_V1_V1_vi, IMAGE_ATOMIC_AND, MIMGEncGfx8, 0x1, 0x1, 0x1 }, // 112
  { IMAGE_ATOMIC_AND_V1_V2_vi, IMAGE_ATOMIC_AND, MIMGEncGfx8, 0x1, 0x2, 0x1 }, // 113
  { IMAGE_ATOMIC_AND_V1_V3_vi, IMAGE_ATOMIC_AND, MIMGEncGfx8, 0x1, 0x3, 0x1 }, // 114
  { IMAGE_ATOMIC_AND_V1_V4_vi, IMAGE_ATOMIC_AND, MIMGEncGfx8, 0x1, 0x4, 0x1 }, // 115
  { IMAGE_ATOMIC_AND_V2_V1_vi, IMAGE_ATOMIC_AND, MIMGEncGfx8, 0x2, 0x1, 0x1 }, // 116
  { IMAGE_ATOMIC_AND_V2_V2_vi, IMAGE_ATOMIC_AND, MIMGEncGfx8, 0x2, 0x2, 0x1 }, // 117
  { IMAGE_ATOMIC_AND_V2_V3_vi, IMAGE_ATOMIC_AND, MIMGEncGfx8, 0x2, 0x3, 0x1 }, // 118
  { IMAGE_ATOMIC_AND_V2_V4_vi, IMAGE_ATOMIC_AND, MIMGEncGfx8, 0x2, 0x4, 0x1 }, // 119
  { IMAGE_ATOMIC_AND_V1_V1_gfx90a, IMAGE_ATOMIC_AND, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 120
  { IMAGE_ATOMIC_AND_V1_V2_gfx90a, IMAGE_ATOMIC_AND, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 121
  { IMAGE_ATOMIC_AND_V1_V3_gfx90a, IMAGE_ATOMIC_AND, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 122
  { IMAGE_ATOMIC_AND_V1_V4_gfx90a, IMAGE_ATOMIC_AND, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 123
  { IMAGE_ATOMIC_AND_V2_V1_gfx90a, IMAGE_ATOMIC_AND, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 124
  { IMAGE_ATOMIC_AND_V2_V2_gfx90a, IMAGE_ATOMIC_AND, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 125
  { IMAGE_ATOMIC_AND_V2_V3_gfx90a, IMAGE_ATOMIC_AND, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 126
  { IMAGE_ATOMIC_AND_V2_V4_gfx90a, IMAGE_ATOMIC_AND, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 127
  { IMAGE_ATOMIC_CMPSWAP_V1_V1_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 128
  { IMAGE_ATOMIC_CMPSWAP_V1_V2_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 129
  { IMAGE_ATOMIC_CMPSWAP_V1_V3_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 130
  { IMAGE_ATOMIC_CMPSWAP_V1_V4_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 131
  { IMAGE_ATOMIC_CMPSWAP_V2_V1_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 132
  { IMAGE_ATOMIC_CMPSWAP_V2_V2_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 133
  { IMAGE_ATOMIC_CMPSWAP_V2_V3_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 134
  { IMAGE_ATOMIC_CMPSWAP_V2_V4_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 135
  { IMAGE_ATOMIC_CMPSWAP_V1_V2_nsa_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 136
  { IMAGE_ATOMIC_CMPSWAP_V1_V3_nsa_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 137
  { IMAGE_ATOMIC_CMPSWAP_V1_V4_nsa_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 138
  { IMAGE_ATOMIC_CMPSWAP_V2_V2_nsa_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 139
  { IMAGE_ATOMIC_CMPSWAP_V2_V3_nsa_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 140
  { IMAGE_ATOMIC_CMPSWAP_V2_V4_nsa_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 141
  { IMAGE_ATOMIC_CMPSWAP_V1_V1_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 142
  { IMAGE_ATOMIC_CMPSWAP_V1_V2_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 143
  { IMAGE_ATOMIC_CMPSWAP_V1_V3_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 144
  { IMAGE_ATOMIC_CMPSWAP_V1_V4_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 145
  { IMAGE_ATOMIC_CMPSWAP_V2_V1_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 146
  { IMAGE_ATOMIC_CMPSWAP_V2_V2_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 147
  { IMAGE_ATOMIC_CMPSWAP_V2_V3_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 148
  { IMAGE_ATOMIC_CMPSWAP_V2_V4_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 149
  { IMAGE_ATOMIC_CMPSWAP_V1_V2_nsa_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 150
  { IMAGE_ATOMIC_CMPSWAP_V1_V3_nsa_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 151
  { IMAGE_ATOMIC_CMPSWAP_V1_V4_nsa_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 152
  { IMAGE_ATOMIC_CMPSWAP_V2_V2_nsa_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 153
  { IMAGE_ATOMIC_CMPSWAP_V2_V3_nsa_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 154
  { IMAGE_ATOMIC_CMPSWAP_V2_V4_nsa_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 155
  { IMAGE_ATOMIC_CMPSWAP_V1_V1_gfx12, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 156
  { IMAGE_ATOMIC_CMPSWAP_V1_V2_gfx12, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 157
  { IMAGE_ATOMIC_CMPSWAP_V1_V3_gfx12, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 158
  { IMAGE_ATOMIC_CMPSWAP_V1_V4_gfx12, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 159
  { IMAGE_ATOMIC_CMPSWAP_V2_V1_gfx12, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx12, 0x4, 0x1, 0x1 }, // 160
  { IMAGE_ATOMIC_CMPSWAP_V2_V2_gfx12, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 161
  { IMAGE_ATOMIC_CMPSWAP_V2_V3_gfx12, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 162
  { IMAGE_ATOMIC_CMPSWAP_V2_V4_gfx12, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 163
  { IMAGE_ATOMIC_CMPSWAP_V1_V1_si, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 164
  { IMAGE_ATOMIC_CMPSWAP_V1_V2_si, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 165
  { IMAGE_ATOMIC_CMPSWAP_V1_V3_si, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 166
  { IMAGE_ATOMIC_CMPSWAP_V1_V4_si, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 167
  { IMAGE_ATOMIC_CMPSWAP_V2_V1_si, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 168
  { IMAGE_ATOMIC_CMPSWAP_V2_V2_si, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 169
  { IMAGE_ATOMIC_CMPSWAP_V2_V3_si, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 170
  { IMAGE_ATOMIC_CMPSWAP_V2_V4_si, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 171
  { IMAGE_ATOMIC_CMPSWAP_V1_V1_vi, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx8, 0x2, 0x1, 0x1 }, // 172
  { IMAGE_ATOMIC_CMPSWAP_V1_V2_vi, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx8, 0x2, 0x2, 0x1 }, // 173
  { IMAGE_ATOMIC_CMPSWAP_V1_V3_vi, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx8, 0x2, 0x3, 0x1 }, // 174
  { IMAGE_ATOMIC_CMPSWAP_V1_V4_vi, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx8, 0x2, 0x4, 0x1 }, // 175
  { IMAGE_ATOMIC_CMPSWAP_V2_V1_vi, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx8, 0x4, 0x1, 0x1 }, // 176
  { IMAGE_ATOMIC_CMPSWAP_V2_V2_vi, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx8, 0x4, 0x2, 0x1 }, // 177
  { IMAGE_ATOMIC_CMPSWAP_V2_V3_vi, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx8, 0x4, 0x3, 0x1 }, // 178
  { IMAGE_ATOMIC_CMPSWAP_V2_V4_vi, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx8, 0x4, 0x4, 0x1 }, // 179
  { IMAGE_ATOMIC_CMPSWAP_V1_V1_gfx90a, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 180
  { IMAGE_ATOMIC_CMPSWAP_V1_V2_gfx90a, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 181
  { IMAGE_ATOMIC_CMPSWAP_V1_V3_gfx90a, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 182
  { IMAGE_ATOMIC_CMPSWAP_V1_V4_gfx90a, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 183
  { IMAGE_ATOMIC_CMPSWAP_V2_V1_gfx90a, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx90a, 0x4, 0x1, 0x1 }, // 184
  { IMAGE_ATOMIC_CMPSWAP_V2_V2_gfx90a, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx90a, 0x4, 0x2, 0x1 }, // 185
  { IMAGE_ATOMIC_CMPSWAP_V2_V3_gfx90a, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx90a, 0x4, 0x3, 0x1 }, // 186
  { IMAGE_ATOMIC_CMPSWAP_V2_V4_gfx90a, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx90a, 0x4, 0x4, 0x1 }, // 187
  { IMAGE_ATOMIC_DEC_V1_V1_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 188
  { IMAGE_ATOMIC_DEC_V1_V2_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 189
  { IMAGE_ATOMIC_DEC_V1_V3_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 190
  { IMAGE_ATOMIC_DEC_V1_V4_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 191
  { IMAGE_ATOMIC_DEC_V2_V1_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 192
  { IMAGE_ATOMIC_DEC_V2_V2_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 193
  { IMAGE_ATOMIC_DEC_V2_V3_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 194
  { IMAGE_ATOMIC_DEC_V2_V4_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 195
  { IMAGE_ATOMIC_DEC_V1_V2_nsa_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 196
  { IMAGE_ATOMIC_DEC_V1_V3_nsa_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 197
  { IMAGE_ATOMIC_DEC_V1_V4_nsa_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 198
  { IMAGE_ATOMIC_DEC_V2_V2_nsa_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 199
  { IMAGE_ATOMIC_DEC_V2_V3_nsa_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 200
  { IMAGE_ATOMIC_DEC_V2_V4_nsa_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 201
  { IMAGE_ATOMIC_DEC_V1_V1_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 202
  { IMAGE_ATOMIC_DEC_V1_V2_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 203
  { IMAGE_ATOMIC_DEC_V1_V3_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 204
  { IMAGE_ATOMIC_DEC_V1_V4_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 205
  { IMAGE_ATOMIC_DEC_V2_V1_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 206
  { IMAGE_ATOMIC_DEC_V2_V2_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 207
  { IMAGE_ATOMIC_DEC_V2_V3_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 208
  { IMAGE_ATOMIC_DEC_V2_V4_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 209
  { IMAGE_ATOMIC_DEC_V1_V2_nsa_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 210
  { IMAGE_ATOMIC_DEC_V1_V3_nsa_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 211
  { IMAGE_ATOMIC_DEC_V1_V4_nsa_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 212
  { IMAGE_ATOMIC_DEC_V2_V2_nsa_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 213
  { IMAGE_ATOMIC_DEC_V2_V3_nsa_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 214
  { IMAGE_ATOMIC_DEC_V2_V4_nsa_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 215
  { IMAGE_ATOMIC_DEC_V1_V1_gfx12, IMAGE_ATOMIC_DEC, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 216
  { IMAGE_ATOMIC_DEC_V1_V2_gfx12, IMAGE_ATOMIC_DEC, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 217
  { IMAGE_ATOMIC_DEC_V1_V3_gfx12, IMAGE_ATOMIC_DEC, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 218
  { IMAGE_ATOMIC_DEC_V1_V4_gfx12, IMAGE_ATOMIC_DEC, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 219
  { IMAGE_ATOMIC_DEC_V2_V1_gfx12, IMAGE_ATOMIC_DEC, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 220
  { IMAGE_ATOMIC_DEC_V2_V2_gfx12, IMAGE_ATOMIC_DEC, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 221
  { IMAGE_ATOMIC_DEC_V2_V3_gfx12, IMAGE_ATOMIC_DEC, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 222
  { IMAGE_ATOMIC_DEC_V2_V4_gfx12, IMAGE_ATOMIC_DEC, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 223
  { IMAGE_ATOMIC_DEC_V1_V1_si, IMAGE_ATOMIC_DEC, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 224
  { IMAGE_ATOMIC_DEC_V1_V2_si, IMAGE_ATOMIC_DEC, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 225
  { IMAGE_ATOMIC_DEC_V1_V3_si, IMAGE_ATOMIC_DEC, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 226
  { IMAGE_ATOMIC_DEC_V1_V4_si, IMAGE_ATOMIC_DEC, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 227
  { IMAGE_ATOMIC_DEC_V2_V1_si, IMAGE_ATOMIC_DEC, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 228
  { IMAGE_ATOMIC_DEC_V2_V2_si, IMAGE_ATOMIC_DEC, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 229
  { IMAGE_ATOMIC_DEC_V2_V3_si, IMAGE_ATOMIC_DEC, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 230
  { IMAGE_ATOMIC_DEC_V2_V4_si, IMAGE_ATOMIC_DEC, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 231
  { IMAGE_ATOMIC_DEC_V1_V1_vi, IMAGE_ATOMIC_DEC, MIMGEncGfx8, 0x1, 0x1, 0x1 }, // 232
  { IMAGE_ATOMIC_DEC_V1_V2_vi, IMAGE_ATOMIC_DEC, MIMGEncGfx8, 0x1, 0x2, 0x1 }, // 233
  { IMAGE_ATOMIC_DEC_V1_V3_vi, IMAGE_ATOMIC_DEC, MIMGEncGfx8, 0x1, 0x3, 0x1 }, // 234
  { IMAGE_ATOMIC_DEC_V1_V4_vi, IMAGE_ATOMIC_DEC, MIMGEncGfx8, 0x1, 0x4, 0x1 }, // 235
  { IMAGE_ATOMIC_DEC_V2_V1_vi, IMAGE_ATOMIC_DEC, MIMGEncGfx8, 0x2, 0x1, 0x1 }, // 236
  { IMAGE_ATOMIC_DEC_V2_V2_vi, IMAGE_ATOMIC_DEC, MIMGEncGfx8, 0x2, 0x2, 0x1 }, // 237
  { IMAGE_ATOMIC_DEC_V2_V3_vi, IMAGE_ATOMIC_DEC, MIMGEncGfx8, 0x2, 0x3, 0x1 }, // 238
  { IMAGE_ATOMIC_DEC_V2_V4_vi, IMAGE_ATOMIC_DEC, MIMGEncGfx8, 0x2, 0x4, 0x1 }, // 239
  { IMAGE_ATOMIC_DEC_V1_V1_gfx90a, IMAGE_ATOMIC_DEC, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 240
  { IMAGE_ATOMIC_DEC_V1_V2_gfx90a, IMAGE_ATOMIC_DEC, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 241
  { IMAGE_ATOMIC_DEC_V1_V3_gfx90a, IMAGE_ATOMIC_DEC, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 242
  { IMAGE_ATOMIC_DEC_V1_V4_gfx90a, IMAGE_ATOMIC_DEC, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 243
  { IMAGE_ATOMIC_DEC_V2_V1_gfx90a, IMAGE_ATOMIC_DEC, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 244
  { IMAGE_ATOMIC_DEC_V2_V2_gfx90a, IMAGE_ATOMIC_DEC, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 245
  { IMAGE_ATOMIC_DEC_V2_V3_gfx90a, IMAGE_ATOMIC_DEC, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 246
  { IMAGE_ATOMIC_DEC_V2_V4_gfx90a, IMAGE_ATOMIC_DEC, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 247
  { IMAGE_ATOMIC_FCMPSWAP_V1_V1_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 248
  { IMAGE_ATOMIC_FCMPSWAP_V1_V2_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 249
  { IMAGE_ATOMIC_FCMPSWAP_V1_V3_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 250
  { IMAGE_ATOMIC_FCMPSWAP_V1_V4_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 251
  { IMAGE_ATOMIC_FCMPSWAP_V2_V1_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 252
  { IMAGE_ATOMIC_FCMPSWAP_V2_V2_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 253
  { IMAGE_ATOMIC_FCMPSWAP_V2_V3_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 254
  { IMAGE_ATOMIC_FCMPSWAP_V2_V4_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 255
  { IMAGE_ATOMIC_FCMPSWAP_V1_V2_nsa_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 256
  { IMAGE_ATOMIC_FCMPSWAP_V1_V3_nsa_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 257
  { IMAGE_ATOMIC_FCMPSWAP_V1_V4_nsa_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 258
  { IMAGE_ATOMIC_FCMPSWAP_V2_V2_nsa_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 259
  { IMAGE_ATOMIC_FCMPSWAP_V2_V3_nsa_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 260
  { IMAGE_ATOMIC_FCMPSWAP_V2_V4_nsa_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 261
  { IMAGE_ATOMIC_FCMPSWAP_V1_V1_si, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 262
  { IMAGE_ATOMIC_FCMPSWAP_V1_V2_si, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 263
  { IMAGE_ATOMIC_FCMPSWAP_V1_V3_si, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 264
  { IMAGE_ATOMIC_FCMPSWAP_V1_V4_si, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 265
  { IMAGE_ATOMIC_FCMPSWAP_V2_V1_si, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 266
  { IMAGE_ATOMIC_FCMPSWAP_V2_V2_si, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 267
  { IMAGE_ATOMIC_FCMPSWAP_V2_V3_si, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 268
  { IMAGE_ATOMIC_FCMPSWAP_V2_V4_si, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 269
  { IMAGE_ATOMIC_FMAX_V1_V1_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 270
  { IMAGE_ATOMIC_FMAX_V1_V2_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 271
  { IMAGE_ATOMIC_FMAX_V1_V3_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 272
  { IMAGE_ATOMIC_FMAX_V1_V4_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 273
  { IMAGE_ATOMIC_FMAX_V2_V1_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 274
  { IMAGE_ATOMIC_FMAX_V2_V2_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 275
  { IMAGE_ATOMIC_FMAX_V2_V3_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 276
  { IMAGE_ATOMIC_FMAX_V2_V4_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 277
  { IMAGE_ATOMIC_FMAX_V1_V2_nsa_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 278
  { IMAGE_ATOMIC_FMAX_V1_V3_nsa_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 279
  { IMAGE_ATOMIC_FMAX_V1_V4_nsa_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 280
  { IMAGE_ATOMIC_FMAX_V2_V2_nsa_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 281
  { IMAGE_ATOMIC_FMAX_V2_V3_nsa_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 282
  { IMAGE_ATOMIC_FMAX_V2_V4_nsa_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 283
  { IMAGE_ATOMIC_FMAX_V1_V1_si, IMAGE_ATOMIC_FMAX, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 284
  { IMAGE_ATOMIC_FMAX_V1_V2_si, IMAGE_ATOMIC_FMAX, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 285
  { IMAGE_ATOMIC_FMAX_V1_V3_si, IMAGE_ATOMIC_FMAX, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 286
  { IMAGE_ATOMIC_FMAX_V1_V4_si, IMAGE_ATOMIC_FMAX, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 287
  { IMAGE_ATOMIC_FMAX_V2_V1_si, IMAGE_ATOMIC_FMAX, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 288
  { IMAGE_ATOMIC_FMAX_V2_V2_si, IMAGE_ATOMIC_FMAX, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 289
  { IMAGE_ATOMIC_FMAX_V2_V3_si, IMAGE_ATOMIC_FMAX, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 290
  { IMAGE_ATOMIC_FMAX_V2_V4_si, IMAGE_ATOMIC_FMAX, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 291
  { IMAGE_ATOMIC_FMIN_V1_V1_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 292
  { IMAGE_ATOMIC_FMIN_V1_V2_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 293
  { IMAGE_ATOMIC_FMIN_V1_V3_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 294
  { IMAGE_ATOMIC_FMIN_V1_V4_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 295
  { IMAGE_ATOMIC_FMIN_V2_V1_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 296
  { IMAGE_ATOMIC_FMIN_V2_V2_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 297
  { IMAGE_ATOMIC_FMIN_V2_V3_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 298
  { IMAGE_ATOMIC_FMIN_V2_V4_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 299
  { IMAGE_ATOMIC_FMIN_V1_V2_nsa_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 300
  { IMAGE_ATOMIC_FMIN_V1_V3_nsa_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 301
  { IMAGE_ATOMIC_FMIN_V1_V4_nsa_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 302
  { IMAGE_ATOMIC_FMIN_V2_V2_nsa_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 303
  { IMAGE_ATOMIC_FMIN_V2_V3_nsa_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 304
  { IMAGE_ATOMIC_FMIN_V2_V4_nsa_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 305
  { IMAGE_ATOMIC_FMIN_V1_V1_si, IMAGE_ATOMIC_FMIN, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 306
  { IMAGE_ATOMIC_FMIN_V1_V2_si, IMAGE_ATOMIC_FMIN, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 307
  { IMAGE_ATOMIC_FMIN_V1_V3_si, IMAGE_ATOMIC_FMIN, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 308
  { IMAGE_ATOMIC_FMIN_V1_V4_si, IMAGE_ATOMIC_FMIN, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 309
  { IMAGE_ATOMIC_FMIN_V2_V1_si, IMAGE_ATOMIC_FMIN, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 310
  { IMAGE_ATOMIC_FMIN_V2_V2_si, IMAGE_ATOMIC_FMIN, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 311
  { IMAGE_ATOMIC_FMIN_V2_V3_si, IMAGE_ATOMIC_FMIN, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 312
  { IMAGE_ATOMIC_FMIN_V2_V4_si, IMAGE_ATOMIC_FMIN, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 313
  { IMAGE_ATOMIC_INC_V1_V1_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 314
  { IMAGE_ATOMIC_INC_V1_V2_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 315
  { IMAGE_ATOMIC_INC_V1_V3_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 316
  { IMAGE_ATOMIC_INC_V1_V4_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 317
  { IMAGE_ATOMIC_INC_V2_V1_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 318
  { IMAGE_ATOMIC_INC_V2_V2_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 319
  { IMAGE_ATOMIC_INC_V2_V3_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 320
  { IMAGE_ATOMIC_INC_V2_V4_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 321
  { IMAGE_ATOMIC_INC_V1_V2_nsa_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 322
  { IMAGE_ATOMIC_INC_V1_V3_nsa_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 323
  { IMAGE_ATOMIC_INC_V1_V4_nsa_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 324
  { IMAGE_ATOMIC_INC_V2_V2_nsa_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 325
  { IMAGE_ATOMIC_INC_V2_V3_nsa_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 326
  { IMAGE_ATOMIC_INC_V2_V4_nsa_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 327
  { IMAGE_ATOMIC_INC_V1_V1_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 328
  { IMAGE_ATOMIC_INC_V1_V2_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 329
  { IMAGE_ATOMIC_INC_V1_V3_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 330
  { IMAGE_ATOMIC_INC_V1_V4_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 331
  { IMAGE_ATOMIC_INC_V2_V1_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 332
  { IMAGE_ATOMIC_INC_V2_V2_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 333
  { IMAGE_ATOMIC_INC_V2_V3_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 334
  { IMAGE_ATOMIC_INC_V2_V4_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 335
  { IMAGE_ATOMIC_INC_V1_V2_nsa_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 336
  { IMAGE_ATOMIC_INC_V1_V3_nsa_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 337
  { IMAGE_ATOMIC_INC_V1_V4_nsa_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 338
  { IMAGE_ATOMIC_INC_V2_V2_nsa_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 339
  { IMAGE_ATOMIC_INC_V2_V3_nsa_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 340
  { IMAGE_ATOMIC_INC_V2_V4_nsa_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 341
  { IMAGE_ATOMIC_INC_V1_V1_gfx12, IMAGE_ATOMIC_INC, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 342
  { IMAGE_ATOMIC_INC_V1_V2_gfx12, IMAGE_ATOMIC_INC, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 343
  { IMAGE_ATOMIC_INC_V1_V3_gfx12, IMAGE_ATOMIC_INC, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 344
  { IMAGE_ATOMIC_INC_V1_V4_gfx12, IMAGE_ATOMIC_INC, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 345
  { IMAGE_ATOMIC_INC_V2_V1_gfx12, IMAGE_ATOMIC_INC, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 346
  { IMAGE_ATOMIC_INC_V2_V2_gfx12, IMAGE_ATOMIC_INC, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 347
  { IMAGE_ATOMIC_INC_V2_V3_gfx12, IMAGE_ATOMIC_INC, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 348
  { IMAGE_ATOMIC_INC_V2_V4_gfx12, IMAGE_ATOMIC_INC, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 349
  { IMAGE_ATOMIC_INC_V1_V1_si, IMAGE_ATOMIC_INC, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 350
  { IMAGE_ATOMIC_INC_V1_V2_si, IMAGE_ATOMIC_INC, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 351
  { IMAGE_ATOMIC_INC_V1_V3_si, IMAGE_ATOMIC_INC, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 352
  { IMAGE_ATOMIC_INC_V1_V4_si, IMAGE_ATOMIC_INC, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 353
  { IMAGE_ATOMIC_INC_V2_V1_si, IMAGE_ATOMIC_INC, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 354
  { IMAGE_ATOMIC_INC_V2_V2_si, IMAGE_ATOMIC_INC, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 355
  { IMAGE_ATOMIC_INC_V2_V3_si, IMAGE_ATOMIC_INC, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 356
  { IMAGE_ATOMIC_INC_V2_V4_si, IMAGE_ATOMIC_INC, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 357
  { IMAGE_ATOMIC_INC_V1_V1_vi, IMAGE_ATOMIC_INC, MIMGEncGfx8, 0x1, 0x1, 0x1 }, // 358
  { IMAGE_ATOMIC_INC_V1_V2_vi, IMAGE_ATOMIC_INC, MIMGEncGfx8, 0x1, 0x2, 0x1 }, // 359
  { IMAGE_ATOMIC_INC_V1_V3_vi, IMAGE_ATOMIC_INC, MIMGEncGfx8, 0x1, 0x3, 0x1 }, // 360
  { IMAGE_ATOMIC_INC_V1_V4_vi, IMAGE_ATOMIC_INC, MIMGEncGfx8, 0x1, 0x4, 0x1 }, // 361
  { IMAGE_ATOMIC_INC_V2_V1_vi, IMAGE_ATOMIC_INC, MIMGEncGfx8, 0x2, 0x1, 0x1 }, // 362
  { IMAGE_ATOMIC_INC_V2_V2_vi, IMAGE_ATOMIC_INC, MIMGEncGfx8, 0x2, 0x2, 0x1 }, // 363
  { IMAGE_ATOMIC_INC_V2_V3_vi, IMAGE_ATOMIC_INC, MIMGEncGfx8, 0x2, 0x3, 0x1 }, // 364
  { IMAGE_ATOMIC_INC_V2_V4_vi, IMAGE_ATOMIC_INC, MIMGEncGfx8, 0x2, 0x4, 0x1 }, // 365
  { IMAGE_ATOMIC_INC_V1_V1_gfx90a, IMAGE_ATOMIC_INC, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 366
  { IMAGE_ATOMIC_INC_V1_V2_gfx90a, IMAGE_ATOMIC_INC, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 367
  { IMAGE_ATOMIC_INC_V1_V3_gfx90a, IMAGE_ATOMIC_INC, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 368
  { IMAGE_ATOMIC_INC_V1_V4_gfx90a, IMAGE_ATOMIC_INC, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 369
  { IMAGE_ATOMIC_INC_V2_V1_gfx90a, IMAGE_ATOMIC_INC, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 370
  { IMAGE_ATOMIC_INC_V2_V2_gfx90a, IMAGE_ATOMIC_INC, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 371
  { IMAGE_ATOMIC_INC_V2_V3_gfx90a, IMAGE_ATOMIC_INC, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 372
  { IMAGE_ATOMIC_INC_V2_V4_gfx90a, IMAGE_ATOMIC_INC, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 373
  { IMAGE_ATOMIC_MAX_FLT_V1_V1_gfx12, IMAGE_ATOMIC_MAX_FLT, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 374
  { IMAGE_ATOMIC_MAX_FLT_V1_V2_gfx12, IMAGE_ATOMIC_MAX_FLT, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 375
  { IMAGE_ATOMIC_MAX_FLT_V1_V3_gfx12, IMAGE_ATOMIC_MAX_FLT, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 376
  { IMAGE_ATOMIC_MAX_FLT_V1_V4_gfx12, IMAGE_ATOMIC_MAX_FLT, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 377
  { IMAGE_ATOMIC_MAX_FLT_V2_V1_gfx12, IMAGE_ATOMIC_MAX_FLT, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 378
  { IMAGE_ATOMIC_MAX_FLT_V2_V2_gfx12, IMAGE_ATOMIC_MAX_FLT, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 379
  { IMAGE_ATOMIC_MAX_FLT_V2_V3_gfx12, IMAGE_ATOMIC_MAX_FLT, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 380
  { IMAGE_ATOMIC_MAX_FLT_V2_V4_gfx12, IMAGE_ATOMIC_MAX_FLT, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 381
  { IMAGE_ATOMIC_MIN_FLT_V1_V1_gfx12, IMAGE_ATOMIC_MIN_FLT, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 382
  { IMAGE_ATOMIC_MIN_FLT_V1_V2_gfx12, IMAGE_ATOMIC_MIN_FLT, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 383
  { IMAGE_ATOMIC_MIN_FLT_V1_V3_gfx12, IMAGE_ATOMIC_MIN_FLT, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 384
  { IMAGE_ATOMIC_MIN_FLT_V1_V4_gfx12, IMAGE_ATOMIC_MIN_FLT, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 385
  { IMAGE_ATOMIC_MIN_FLT_V2_V1_gfx12, IMAGE_ATOMIC_MIN_FLT, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 386
  { IMAGE_ATOMIC_MIN_FLT_V2_V2_gfx12, IMAGE_ATOMIC_MIN_FLT, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 387
  { IMAGE_ATOMIC_MIN_FLT_V2_V3_gfx12, IMAGE_ATOMIC_MIN_FLT, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 388
  { IMAGE_ATOMIC_MIN_FLT_V2_V4_gfx12, IMAGE_ATOMIC_MIN_FLT, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 389
  { IMAGE_ATOMIC_OR_V1_V1_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 390
  { IMAGE_ATOMIC_OR_V1_V2_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 391
  { IMAGE_ATOMIC_OR_V1_V3_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 392
  { IMAGE_ATOMIC_OR_V1_V4_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 393
  { IMAGE_ATOMIC_OR_V2_V1_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 394
  { IMAGE_ATOMIC_OR_V2_V2_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 395
  { IMAGE_ATOMIC_OR_V2_V3_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 396
  { IMAGE_ATOMIC_OR_V2_V4_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 397
  { IMAGE_ATOMIC_OR_V1_V2_nsa_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 398
  { IMAGE_ATOMIC_OR_V1_V3_nsa_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 399
  { IMAGE_ATOMIC_OR_V1_V4_nsa_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 400
  { IMAGE_ATOMIC_OR_V2_V2_nsa_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 401
  { IMAGE_ATOMIC_OR_V2_V3_nsa_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 402
  { IMAGE_ATOMIC_OR_V2_V4_nsa_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 403
  { IMAGE_ATOMIC_OR_V1_V1_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 404
  { IMAGE_ATOMIC_OR_V1_V2_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 405
  { IMAGE_ATOMIC_OR_V1_V3_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 406
  { IMAGE_ATOMIC_OR_V1_V4_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 407
  { IMAGE_ATOMIC_OR_V2_V1_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 408
  { IMAGE_ATOMIC_OR_V2_V2_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 409
  { IMAGE_ATOMIC_OR_V2_V3_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 410
  { IMAGE_ATOMIC_OR_V2_V4_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 411
  { IMAGE_ATOMIC_OR_V1_V2_nsa_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 412
  { IMAGE_ATOMIC_OR_V1_V3_nsa_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 413
  { IMAGE_ATOMIC_OR_V1_V4_nsa_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 414
  { IMAGE_ATOMIC_OR_V2_V2_nsa_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 415
  { IMAGE_ATOMIC_OR_V2_V3_nsa_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 416
  { IMAGE_ATOMIC_OR_V2_V4_nsa_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 417
  { IMAGE_ATOMIC_OR_V1_V1_gfx12, IMAGE_ATOMIC_OR, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 418
  { IMAGE_ATOMIC_OR_V1_V2_gfx12, IMAGE_ATOMIC_OR, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 419
  { IMAGE_ATOMIC_OR_V1_V3_gfx12, IMAGE_ATOMIC_OR, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 420
  { IMAGE_ATOMIC_OR_V1_V4_gfx12, IMAGE_ATOMIC_OR, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 421
  { IMAGE_ATOMIC_OR_V2_V1_gfx12, IMAGE_ATOMIC_OR, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 422
  { IMAGE_ATOMIC_OR_V2_V2_gfx12, IMAGE_ATOMIC_OR, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 423
  { IMAGE_ATOMIC_OR_V2_V3_gfx12, IMAGE_ATOMIC_OR, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 424
  { IMAGE_ATOMIC_OR_V2_V4_gfx12, IMAGE_ATOMIC_OR, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 425
  { IMAGE_ATOMIC_OR_V1_V1_si, IMAGE_ATOMIC_OR, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 426
  { IMAGE_ATOMIC_OR_V1_V2_si, IMAGE_ATOMIC_OR, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 427
  { IMAGE_ATOMIC_OR_V1_V3_si, IMAGE_ATOMIC_OR, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 428
  { IMAGE_ATOMIC_OR_V1_V4_si, IMAGE_ATOMIC_OR, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 429
  { IMAGE_ATOMIC_OR_V2_V1_si, IMAGE_ATOMIC_OR, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 430
  { IMAGE_ATOMIC_OR_V2_V2_si, IMAGE_ATOMIC_OR, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 431
  { IMAGE_ATOMIC_OR_V2_V3_si, IMAGE_ATOMIC_OR, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 432
  { IMAGE_ATOMIC_OR_V2_V4_si, IMAGE_ATOMIC_OR, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 433
  { IMAGE_ATOMIC_OR_V1_V1_vi, IMAGE_ATOMIC_OR, MIMGEncGfx8, 0x1, 0x1, 0x1 }, // 434
  { IMAGE_ATOMIC_OR_V1_V2_vi, IMAGE_ATOMIC_OR, MIMGEncGfx8, 0x1, 0x2, 0x1 }, // 435
  { IMAGE_ATOMIC_OR_V1_V3_vi, IMAGE_ATOMIC_OR, MIMGEncGfx8, 0x1, 0x3, 0x1 }, // 436
  { IMAGE_ATOMIC_OR_V1_V4_vi, IMAGE_ATOMIC_OR, MIMGEncGfx8, 0x1, 0x4, 0x1 }, // 437
  { IMAGE_ATOMIC_OR_V2_V1_vi, IMAGE_ATOMIC_OR, MIMGEncGfx8, 0x2, 0x1, 0x1 }, // 438
  { IMAGE_ATOMIC_OR_V2_V2_vi, IMAGE_ATOMIC_OR, MIMGEncGfx8, 0x2, 0x2, 0x1 }, // 439
  { IMAGE_ATOMIC_OR_V2_V3_vi, IMAGE_ATOMIC_OR, MIMGEncGfx8, 0x2, 0x3, 0x1 }, // 440
  { IMAGE_ATOMIC_OR_V2_V4_vi, IMAGE_ATOMIC_OR, MIMGEncGfx8, 0x2, 0x4, 0x1 }, // 441
  { IMAGE_ATOMIC_OR_V1_V1_gfx90a, IMAGE_ATOMIC_OR, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 442
  { IMAGE_ATOMIC_OR_V1_V2_gfx90a, IMAGE_ATOMIC_OR, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 443
  { IMAGE_ATOMIC_OR_V1_V3_gfx90a, IMAGE_ATOMIC_OR, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 444
  { IMAGE_ATOMIC_OR_V1_V4_gfx90a, IMAGE_ATOMIC_OR, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 445
  { IMAGE_ATOMIC_OR_V2_V1_gfx90a, IMAGE_ATOMIC_OR, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 446
  { IMAGE_ATOMIC_OR_V2_V2_gfx90a, IMAGE_ATOMIC_OR, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 447
  { IMAGE_ATOMIC_OR_V2_V3_gfx90a, IMAGE_ATOMIC_OR, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 448
  { IMAGE_ATOMIC_OR_V2_V4_gfx90a, IMAGE_ATOMIC_OR, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 449
  { IMAGE_ATOMIC_PK_ADD_BF16_V1_V1_gfx12, IMAGE_ATOMIC_PK_ADD_BF16, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 450
  { IMAGE_ATOMIC_PK_ADD_BF16_V1_V2_gfx12, IMAGE_ATOMIC_PK_ADD_BF16, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 451
  { IMAGE_ATOMIC_PK_ADD_BF16_V1_V3_gfx12, IMAGE_ATOMIC_PK_ADD_BF16, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 452
  { IMAGE_ATOMIC_PK_ADD_BF16_V1_V4_gfx12, IMAGE_ATOMIC_PK_ADD_BF16, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 453
  { IMAGE_ATOMIC_PK_ADD_BF16_V2_V1_gfx12, IMAGE_ATOMIC_PK_ADD_BF16, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 454
  { IMAGE_ATOMIC_PK_ADD_BF16_V2_V2_gfx12, IMAGE_ATOMIC_PK_ADD_BF16, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 455
  { IMAGE_ATOMIC_PK_ADD_BF16_V2_V3_gfx12, IMAGE_ATOMIC_PK_ADD_BF16, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 456
  { IMAGE_ATOMIC_PK_ADD_BF16_V2_V4_gfx12, IMAGE_ATOMIC_PK_ADD_BF16, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 457
  { IMAGE_ATOMIC_PK_ADD_F16_V1_V1_gfx12, IMAGE_ATOMIC_PK_ADD_F16, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 458
  { IMAGE_ATOMIC_PK_ADD_F16_V1_V2_gfx12, IMAGE_ATOMIC_PK_ADD_F16, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 459
  { IMAGE_ATOMIC_PK_ADD_F16_V1_V3_gfx12, IMAGE_ATOMIC_PK_ADD_F16, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 460
  { IMAGE_ATOMIC_PK_ADD_F16_V1_V4_gfx12, IMAGE_ATOMIC_PK_ADD_F16, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 461
  { IMAGE_ATOMIC_PK_ADD_F16_V2_V1_gfx12, IMAGE_ATOMIC_PK_ADD_F16, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 462
  { IMAGE_ATOMIC_PK_ADD_F16_V2_V2_gfx12, IMAGE_ATOMIC_PK_ADD_F16, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 463
  { IMAGE_ATOMIC_PK_ADD_F16_V2_V3_gfx12, IMAGE_ATOMIC_PK_ADD_F16, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 464
  { IMAGE_ATOMIC_PK_ADD_F16_V2_V4_gfx12, IMAGE_ATOMIC_PK_ADD_F16, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 465
  { IMAGE_ATOMIC_RSUB_V1_V1_si, IMAGE_ATOMIC_RSUB, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 466
  { IMAGE_ATOMIC_RSUB_V1_V2_si, IMAGE_ATOMIC_RSUB, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 467
  { IMAGE_ATOMIC_RSUB_V1_V3_si, IMAGE_ATOMIC_RSUB, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 468
  { IMAGE_ATOMIC_RSUB_V1_V4_si, IMAGE_ATOMIC_RSUB, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 469
  { IMAGE_ATOMIC_RSUB_V2_V1_si, IMAGE_ATOMIC_RSUB, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 470
  { IMAGE_ATOMIC_RSUB_V2_V2_si, IMAGE_ATOMIC_RSUB, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 471
  { IMAGE_ATOMIC_RSUB_V2_V3_si, IMAGE_ATOMIC_RSUB, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 472
  { IMAGE_ATOMIC_RSUB_V2_V4_si, IMAGE_ATOMIC_RSUB, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 473
  { IMAGE_ATOMIC_SMAX_V1_V1_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 474
  { IMAGE_ATOMIC_SMAX_V1_V2_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 475
  { IMAGE_ATOMIC_SMAX_V1_V3_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 476
  { IMAGE_ATOMIC_SMAX_V1_V4_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 477
  { IMAGE_ATOMIC_SMAX_V2_V1_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 478
  { IMAGE_ATOMIC_SMAX_V2_V2_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 479
  { IMAGE_ATOMIC_SMAX_V2_V3_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 480
  { IMAGE_ATOMIC_SMAX_V2_V4_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 481
  { IMAGE_ATOMIC_SMAX_V1_V2_nsa_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 482
  { IMAGE_ATOMIC_SMAX_V1_V3_nsa_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 483
  { IMAGE_ATOMIC_SMAX_V1_V4_nsa_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 484
  { IMAGE_ATOMIC_SMAX_V2_V2_nsa_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 485
  { IMAGE_ATOMIC_SMAX_V2_V3_nsa_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 486
  { IMAGE_ATOMIC_SMAX_V2_V4_nsa_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 487
  { IMAGE_ATOMIC_SMAX_V1_V1_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 488
  { IMAGE_ATOMIC_SMAX_V1_V2_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 489
  { IMAGE_ATOMIC_SMAX_V1_V3_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 490
  { IMAGE_ATOMIC_SMAX_V1_V4_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 491
  { IMAGE_ATOMIC_SMAX_V2_V1_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 492
  { IMAGE_ATOMIC_SMAX_V2_V2_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 493
  { IMAGE_ATOMIC_SMAX_V2_V3_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 494
  { IMAGE_ATOMIC_SMAX_V2_V4_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 495
  { IMAGE_ATOMIC_SMAX_V1_V2_nsa_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 496
  { IMAGE_ATOMIC_SMAX_V1_V3_nsa_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 497
  { IMAGE_ATOMIC_SMAX_V1_V4_nsa_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 498
  { IMAGE_ATOMIC_SMAX_V2_V2_nsa_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 499
  { IMAGE_ATOMIC_SMAX_V2_V3_nsa_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 500
  { IMAGE_ATOMIC_SMAX_V2_V4_nsa_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 501
  { IMAGE_ATOMIC_SMAX_V1_V1_gfx12, IMAGE_ATOMIC_SMAX, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 502
  { IMAGE_ATOMIC_SMAX_V1_V2_gfx12, IMAGE_ATOMIC_SMAX, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 503
  { IMAGE_ATOMIC_SMAX_V1_V3_gfx12, IMAGE_ATOMIC_SMAX, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 504
  { IMAGE_ATOMIC_SMAX_V1_V4_gfx12, IMAGE_ATOMIC_SMAX, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 505
  { IMAGE_ATOMIC_SMAX_V2_V1_gfx12, IMAGE_ATOMIC_SMAX, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 506
  { IMAGE_ATOMIC_SMAX_V2_V2_gfx12, IMAGE_ATOMIC_SMAX, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 507
  { IMAGE_ATOMIC_SMAX_V2_V3_gfx12, IMAGE_ATOMIC_SMAX, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 508
  { IMAGE_ATOMIC_SMAX_V2_V4_gfx12, IMAGE_ATOMIC_SMAX, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 509
  { IMAGE_ATOMIC_SMAX_V1_V1_si, IMAGE_ATOMIC_SMAX, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 510
  { IMAGE_ATOMIC_SMAX_V1_V2_si, IMAGE_ATOMIC_SMAX, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 511
  { IMAGE_ATOMIC_SMAX_V1_V3_si, IMAGE_ATOMIC_SMAX, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 512
  { IMAGE_ATOMIC_SMAX_V1_V4_si, IMAGE_ATOMIC_SMAX, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 513
  { IMAGE_ATOMIC_SMAX_V2_V1_si, IMAGE_ATOMIC_SMAX, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 514
  { IMAGE_ATOMIC_SMAX_V2_V2_si, IMAGE_ATOMIC_SMAX, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 515
  { IMAGE_ATOMIC_SMAX_V2_V3_si, IMAGE_ATOMIC_SMAX, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 516
  { IMAGE_ATOMIC_SMAX_V2_V4_si, IMAGE_ATOMIC_SMAX, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 517
  { IMAGE_ATOMIC_SMAX_V1_V1_vi, IMAGE_ATOMIC_SMAX, MIMGEncGfx8, 0x1, 0x1, 0x1 }, // 518
  { IMAGE_ATOMIC_SMAX_V1_V2_vi, IMAGE_ATOMIC_SMAX, MIMGEncGfx8, 0x1, 0x2, 0x1 }, // 519
  { IMAGE_ATOMIC_SMAX_V1_V3_vi, IMAGE_ATOMIC_SMAX, MIMGEncGfx8, 0x1, 0x3, 0x1 }, // 520
  { IMAGE_ATOMIC_SMAX_V1_V4_vi, IMAGE_ATOMIC_SMAX, MIMGEncGfx8, 0x1, 0x4, 0x1 }, // 521
  { IMAGE_ATOMIC_SMAX_V2_V1_vi, IMAGE_ATOMIC_SMAX, MIMGEncGfx8, 0x2, 0x1, 0x1 }, // 522
  { IMAGE_ATOMIC_SMAX_V2_V2_vi, IMAGE_ATOMIC_SMAX, MIMGEncGfx8, 0x2, 0x2, 0x1 }, // 523
  { IMAGE_ATOMIC_SMAX_V2_V3_vi, IMAGE_ATOMIC_SMAX, MIMGEncGfx8, 0x2, 0x3, 0x1 }, // 524
  { IMAGE_ATOMIC_SMAX_V2_V4_vi, IMAGE_ATOMIC_SMAX, MIMGEncGfx8, 0x2, 0x4, 0x1 }, // 525
  { IMAGE_ATOMIC_SMAX_V1_V1_gfx90a, IMAGE_ATOMIC_SMAX, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 526
  { IMAGE_ATOMIC_SMAX_V1_V2_gfx90a, IMAGE_ATOMIC_SMAX, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 527
  { IMAGE_ATOMIC_SMAX_V1_V3_gfx90a, IMAGE_ATOMIC_SMAX, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 528
  { IMAGE_ATOMIC_SMAX_V1_V4_gfx90a, IMAGE_ATOMIC_SMAX, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 529
  { IMAGE_ATOMIC_SMAX_V2_V1_gfx90a, IMAGE_ATOMIC_SMAX, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 530
  { IMAGE_ATOMIC_SMAX_V2_V2_gfx90a, IMAGE_ATOMIC_SMAX, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 531
  { IMAGE_ATOMIC_SMAX_V2_V3_gfx90a, IMAGE_ATOMIC_SMAX, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 532
  { IMAGE_ATOMIC_SMAX_V2_V4_gfx90a, IMAGE_ATOMIC_SMAX, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 533
  { IMAGE_ATOMIC_SMIN_V1_V1_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 534
  { IMAGE_ATOMIC_SMIN_V1_V2_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 535
  { IMAGE_ATOMIC_SMIN_V1_V3_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 536
  { IMAGE_ATOMIC_SMIN_V1_V4_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 537
  { IMAGE_ATOMIC_SMIN_V2_V1_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 538
  { IMAGE_ATOMIC_SMIN_V2_V2_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 539
  { IMAGE_ATOMIC_SMIN_V2_V3_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 540
  { IMAGE_ATOMIC_SMIN_V2_V4_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 541
  { IMAGE_ATOMIC_SMIN_V1_V2_nsa_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 542
  { IMAGE_ATOMIC_SMIN_V1_V3_nsa_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 543
  { IMAGE_ATOMIC_SMIN_V1_V4_nsa_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 544
  { IMAGE_ATOMIC_SMIN_V2_V2_nsa_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 545
  { IMAGE_ATOMIC_SMIN_V2_V3_nsa_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 546
  { IMAGE_ATOMIC_SMIN_V2_V4_nsa_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 547
  { IMAGE_ATOMIC_SMIN_V1_V1_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 548
  { IMAGE_ATOMIC_SMIN_V1_V2_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 549
  { IMAGE_ATOMIC_SMIN_V1_V3_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 550
  { IMAGE_ATOMIC_SMIN_V1_V4_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 551
  { IMAGE_ATOMIC_SMIN_V2_V1_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 552
  { IMAGE_ATOMIC_SMIN_V2_V2_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 553
  { IMAGE_ATOMIC_SMIN_V2_V3_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 554
  { IMAGE_ATOMIC_SMIN_V2_V4_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 555
  { IMAGE_ATOMIC_SMIN_V1_V2_nsa_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 556
  { IMAGE_ATOMIC_SMIN_V1_V3_nsa_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 557
  { IMAGE_ATOMIC_SMIN_V1_V4_nsa_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 558
  { IMAGE_ATOMIC_SMIN_V2_V2_nsa_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 559
  { IMAGE_ATOMIC_SMIN_V2_V3_nsa_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 560
  { IMAGE_ATOMIC_SMIN_V2_V4_nsa_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 561
  { IMAGE_ATOMIC_SMIN_V1_V1_gfx12, IMAGE_ATOMIC_SMIN, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 562
  { IMAGE_ATOMIC_SMIN_V1_V2_gfx12, IMAGE_ATOMIC_SMIN, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 563
  { IMAGE_ATOMIC_SMIN_V1_V3_gfx12, IMAGE_ATOMIC_SMIN, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 564
  { IMAGE_ATOMIC_SMIN_V1_V4_gfx12, IMAGE_ATOMIC_SMIN, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 565
  { IMAGE_ATOMIC_SMIN_V2_V1_gfx12, IMAGE_ATOMIC_SMIN, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 566
  { IMAGE_ATOMIC_SMIN_V2_V2_gfx12, IMAGE_ATOMIC_SMIN, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 567
  { IMAGE_ATOMIC_SMIN_V2_V3_gfx12, IMAGE_ATOMIC_SMIN, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 568
  { IMAGE_ATOMIC_SMIN_V2_V4_gfx12, IMAGE_ATOMIC_SMIN, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 569
  { IMAGE_ATOMIC_SMIN_V1_V1_si, IMAGE_ATOMIC_SMIN, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 570
  { IMAGE_ATOMIC_SMIN_V1_V2_si, IMAGE_ATOMIC_SMIN, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 571
  { IMAGE_ATOMIC_SMIN_V1_V3_si, IMAGE_ATOMIC_SMIN, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 572
  { IMAGE_ATOMIC_SMIN_V1_V4_si, IMAGE_ATOMIC_SMIN, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 573
  { IMAGE_ATOMIC_SMIN_V2_V1_si, IMAGE_ATOMIC_SMIN, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 574
  { IMAGE_ATOMIC_SMIN_V2_V2_si, IMAGE_ATOMIC_SMIN, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 575
  { IMAGE_ATOMIC_SMIN_V2_V3_si, IMAGE_ATOMIC_SMIN, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 576
  { IMAGE_ATOMIC_SMIN_V2_V4_si, IMAGE_ATOMIC_SMIN, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 577
  { IMAGE_ATOMIC_SMIN_V1_V1_vi, IMAGE_ATOMIC_SMIN, MIMGEncGfx8, 0x1, 0x1, 0x1 }, // 578
  { IMAGE_ATOMIC_SMIN_V1_V2_vi, IMAGE_ATOMIC_SMIN, MIMGEncGfx8, 0x1, 0x2, 0x1 }, // 579
  { IMAGE_ATOMIC_SMIN_V1_V3_vi, IMAGE_ATOMIC_SMIN, MIMGEncGfx8, 0x1, 0x3, 0x1 }, // 580
  { IMAGE_ATOMIC_SMIN_V1_V4_vi, IMAGE_ATOMIC_SMIN, MIMGEncGfx8, 0x1, 0x4, 0x1 }, // 581
  { IMAGE_ATOMIC_SMIN_V2_V1_vi, IMAGE_ATOMIC_SMIN, MIMGEncGfx8, 0x2, 0x1, 0x1 }, // 582
  { IMAGE_ATOMIC_SMIN_V2_V2_vi, IMAGE_ATOMIC_SMIN, MIMGEncGfx8, 0x2, 0x2, 0x1 }, // 583
  { IMAGE_ATOMIC_SMIN_V2_V3_vi, IMAGE_ATOMIC_SMIN, MIMGEncGfx8, 0x2, 0x3, 0x1 }, // 584
  { IMAGE_ATOMIC_SMIN_V2_V4_vi, IMAGE_ATOMIC_SMIN, MIMGEncGfx8, 0x2, 0x4, 0x1 }, // 585
  { IMAGE_ATOMIC_SMIN_V1_V1_gfx90a, IMAGE_ATOMIC_SMIN, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 586
  { IMAGE_ATOMIC_SMIN_V1_V2_gfx90a, IMAGE_ATOMIC_SMIN, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 587
  { IMAGE_ATOMIC_SMIN_V1_V3_gfx90a, IMAGE_ATOMIC_SMIN, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 588
  { IMAGE_ATOMIC_SMIN_V1_V4_gfx90a, IMAGE_ATOMIC_SMIN, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 589
  { IMAGE_ATOMIC_SMIN_V2_V1_gfx90a, IMAGE_ATOMIC_SMIN, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 590
  { IMAGE_ATOMIC_SMIN_V2_V2_gfx90a, IMAGE_ATOMIC_SMIN, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 591
  { IMAGE_ATOMIC_SMIN_V2_V3_gfx90a, IMAGE_ATOMIC_SMIN, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 592
  { IMAGE_ATOMIC_SMIN_V2_V4_gfx90a, IMAGE_ATOMIC_SMIN, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 593
  { IMAGE_ATOMIC_SUB_V1_V1_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 594
  { IMAGE_ATOMIC_SUB_V1_V2_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 595
  { IMAGE_ATOMIC_SUB_V1_V3_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 596
  { IMAGE_ATOMIC_SUB_V1_V4_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 597
  { IMAGE_ATOMIC_SUB_V2_V1_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 598
  { IMAGE_ATOMIC_SUB_V2_V2_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 599
  { IMAGE_ATOMIC_SUB_V2_V3_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 600
  { IMAGE_ATOMIC_SUB_V2_V4_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 601
  { IMAGE_ATOMIC_SUB_V1_V2_nsa_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 602
  { IMAGE_ATOMIC_SUB_V1_V3_nsa_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 603
  { IMAGE_ATOMIC_SUB_V1_V4_nsa_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 604
  { IMAGE_ATOMIC_SUB_V2_V2_nsa_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 605
  { IMAGE_ATOMIC_SUB_V2_V3_nsa_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 606
  { IMAGE_ATOMIC_SUB_V2_V4_nsa_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 607
  { IMAGE_ATOMIC_SUB_V1_V1_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 608
  { IMAGE_ATOMIC_SUB_V1_V2_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 609
  { IMAGE_ATOMIC_SUB_V1_V3_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 610
  { IMAGE_ATOMIC_SUB_V1_V4_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 611
  { IMAGE_ATOMIC_SUB_V2_V1_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 612
  { IMAGE_ATOMIC_SUB_V2_V2_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 613
  { IMAGE_ATOMIC_SUB_V2_V3_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 614
  { IMAGE_ATOMIC_SUB_V2_V4_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 615
  { IMAGE_ATOMIC_SUB_V1_V2_nsa_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 616
  { IMAGE_ATOMIC_SUB_V1_V3_nsa_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 617
  { IMAGE_ATOMIC_SUB_V1_V4_nsa_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 618
  { IMAGE_ATOMIC_SUB_V2_V2_nsa_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 619
  { IMAGE_ATOMIC_SUB_V2_V3_nsa_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 620
  { IMAGE_ATOMIC_SUB_V2_V4_nsa_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 621
  { IMAGE_ATOMIC_SUB_V1_V1_gfx12, IMAGE_ATOMIC_SUB, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 622
  { IMAGE_ATOMIC_SUB_V1_V2_gfx12, IMAGE_ATOMIC_SUB, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 623
  { IMAGE_ATOMIC_SUB_V1_V3_gfx12, IMAGE_ATOMIC_SUB, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 624
  { IMAGE_ATOMIC_SUB_V1_V4_gfx12, IMAGE_ATOMIC_SUB, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 625
  { IMAGE_ATOMIC_SUB_V2_V1_gfx12, IMAGE_ATOMIC_SUB, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 626
  { IMAGE_ATOMIC_SUB_V2_V2_gfx12, IMAGE_ATOMIC_SUB, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 627
  { IMAGE_ATOMIC_SUB_V2_V3_gfx12, IMAGE_ATOMIC_SUB, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 628
  { IMAGE_ATOMIC_SUB_V2_V4_gfx12, IMAGE_ATOMIC_SUB, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 629
  { IMAGE_ATOMIC_SUB_V1_V1_si, IMAGE_ATOMIC_SUB, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 630
  { IMAGE_ATOMIC_SUB_V1_V2_si, IMAGE_ATOMIC_SUB, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 631
  { IMAGE_ATOMIC_SUB_V1_V3_si, IMAGE_ATOMIC_SUB, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 632
  { IMAGE_ATOMIC_SUB_V1_V4_si, IMAGE_ATOMIC_SUB, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 633
  { IMAGE_ATOMIC_SUB_V2_V1_si, IMAGE_ATOMIC_SUB, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 634
  { IMAGE_ATOMIC_SUB_V2_V2_si, IMAGE_ATOMIC_SUB, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 635
  { IMAGE_ATOMIC_SUB_V2_V3_si, IMAGE_ATOMIC_SUB, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 636
  { IMAGE_ATOMIC_SUB_V2_V4_si, IMAGE_ATOMIC_SUB, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 637
  { IMAGE_ATOMIC_SUB_V1_V1_vi, IMAGE_ATOMIC_SUB, MIMGEncGfx8, 0x1, 0x1, 0x1 }, // 638
  { IMAGE_ATOMIC_SUB_V1_V2_vi, IMAGE_ATOMIC_SUB, MIMGEncGfx8, 0x1, 0x2, 0x1 }, // 639
  { IMAGE_ATOMIC_SUB_V1_V3_vi, IMAGE_ATOMIC_SUB, MIMGEncGfx8, 0x1, 0x3, 0x1 }, // 640
  { IMAGE_ATOMIC_SUB_V1_V4_vi, IMAGE_ATOMIC_SUB, MIMGEncGfx8, 0x1, 0x4, 0x1 }, // 641
  { IMAGE_ATOMIC_SUB_V2_V1_vi, IMAGE_ATOMIC_SUB, MIMGEncGfx8, 0x2, 0x1, 0x1 }, // 642
  { IMAGE_ATOMIC_SUB_V2_V2_vi, IMAGE_ATOMIC_SUB, MIMGEncGfx8, 0x2, 0x2, 0x1 }, // 643
  { IMAGE_ATOMIC_SUB_V2_V3_vi, IMAGE_ATOMIC_SUB, MIMGEncGfx8, 0x2, 0x3, 0x1 }, // 644
  { IMAGE_ATOMIC_SUB_V2_V4_vi, IMAGE_ATOMIC_SUB, MIMGEncGfx8, 0x2, 0x4, 0x1 }, // 645
  { IMAGE_ATOMIC_SUB_V1_V1_gfx90a, IMAGE_ATOMIC_SUB, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 646
  { IMAGE_ATOMIC_SUB_V1_V2_gfx90a, IMAGE_ATOMIC_SUB, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 647
  { IMAGE_ATOMIC_SUB_V1_V3_gfx90a, IMAGE_ATOMIC_SUB, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 648
  { IMAGE_ATOMIC_SUB_V1_V4_gfx90a, IMAGE_ATOMIC_SUB, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 649
  { IMAGE_ATOMIC_SUB_V2_V1_gfx90a, IMAGE_ATOMIC_SUB, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 650
  { IMAGE_ATOMIC_SUB_V2_V2_gfx90a, IMAGE_ATOMIC_SUB, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 651
  { IMAGE_ATOMIC_SUB_V2_V3_gfx90a, IMAGE_ATOMIC_SUB, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 652
  { IMAGE_ATOMIC_SUB_V2_V4_gfx90a, IMAGE_ATOMIC_SUB, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 653
  { IMAGE_ATOMIC_SWAP_V1_V1_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 654
  { IMAGE_ATOMIC_SWAP_V1_V2_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 655
  { IMAGE_ATOMIC_SWAP_V1_V3_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 656
  { IMAGE_ATOMIC_SWAP_V1_V4_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 657
  { IMAGE_ATOMIC_SWAP_V2_V1_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 658
  { IMAGE_ATOMIC_SWAP_V2_V2_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 659
  { IMAGE_ATOMIC_SWAP_V2_V3_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 660
  { IMAGE_ATOMIC_SWAP_V2_V4_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 661
  { IMAGE_ATOMIC_SWAP_V1_V2_nsa_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 662
  { IMAGE_ATOMIC_SWAP_V1_V3_nsa_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 663
  { IMAGE_ATOMIC_SWAP_V1_V4_nsa_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 664
  { IMAGE_ATOMIC_SWAP_V2_V2_nsa_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 665
  { IMAGE_ATOMIC_SWAP_V2_V3_nsa_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 666
  { IMAGE_ATOMIC_SWAP_V2_V4_nsa_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 667
  { IMAGE_ATOMIC_SWAP_V1_V1_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 668
  { IMAGE_ATOMIC_SWAP_V1_V2_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 669
  { IMAGE_ATOMIC_SWAP_V1_V3_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 670
  { IMAGE_ATOMIC_SWAP_V1_V4_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 671
  { IMAGE_ATOMIC_SWAP_V2_V1_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 672
  { IMAGE_ATOMIC_SWAP_V2_V2_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 673
  { IMAGE_ATOMIC_SWAP_V2_V3_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 674
  { IMAGE_ATOMIC_SWAP_V2_V4_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 675
  { IMAGE_ATOMIC_SWAP_V1_V2_nsa_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 676
  { IMAGE_ATOMIC_SWAP_V1_V3_nsa_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 677
  { IMAGE_ATOMIC_SWAP_V1_V4_nsa_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 678
  { IMAGE_ATOMIC_SWAP_V2_V2_nsa_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 679
  { IMAGE_ATOMIC_SWAP_V2_V3_nsa_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 680
  { IMAGE_ATOMIC_SWAP_V2_V4_nsa_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 681
  { IMAGE_ATOMIC_SWAP_V1_V1_gfx12, IMAGE_ATOMIC_SWAP, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 682
  { IMAGE_ATOMIC_SWAP_V1_V2_gfx12, IMAGE_ATOMIC_SWAP, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 683
  { IMAGE_ATOMIC_SWAP_V1_V3_gfx12, IMAGE_ATOMIC_SWAP, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 684
  { IMAGE_ATOMIC_SWAP_V1_V4_gfx12, IMAGE_ATOMIC_SWAP, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 685
  { IMAGE_ATOMIC_SWAP_V2_V1_gfx12, IMAGE_ATOMIC_SWAP, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 686
  { IMAGE_ATOMIC_SWAP_V2_V2_gfx12, IMAGE_ATOMIC_SWAP, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 687
  { IMAGE_ATOMIC_SWAP_V2_V3_gfx12, IMAGE_ATOMIC_SWAP, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 688
  { IMAGE_ATOMIC_SWAP_V2_V4_gfx12, IMAGE_ATOMIC_SWAP, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 689
  { IMAGE_ATOMIC_SWAP_V1_V1_si, IMAGE_ATOMIC_SWAP, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 690
  { IMAGE_ATOMIC_SWAP_V1_V2_si, IMAGE_ATOMIC_SWAP, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 691
  { IMAGE_ATOMIC_SWAP_V1_V3_si, IMAGE_ATOMIC_SWAP, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 692
  { IMAGE_ATOMIC_SWAP_V1_V4_si, IMAGE_ATOMIC_SWAP, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 693
  { IMAGE_ATOMIC_SWAP_V2_V1_si, IMAGE_ATOMIC_SWAP, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 694
  { IMAGE_ATOMIC_SWAP_V2_V2_si, IMAGE_ATOMIC_SWAP, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 695
  { IMAGE_ATOMIC_SWAP_V2_V3_si, IMAGE_ATOMIC_SWAP, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 696
  { IMAGE_ATOMIC_SWAP_V2_V4_si, IMAGE_ATOMIC_SWAP, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 697
  { IMAGE_ATOMIC_SWAP_V1_V1_vi, IMAGE_ATOMIC_SWAP, MIMGEncGfx8, 0x1, 0x1, 0x1 }, // 698
  { IMAGE_ATOMIC_SWAP_V1_V2_vi, IMAGE_ATOMIC_SWAP, MIMGEncGfx8, 0x1, 0x2, 0x1 }, // 699
  { IMAGE_ATOMIC_SWAP_V1_V3_vi, IMAGE_ATOMIC_SWAP, MIMGEncGfx8, 0x1, 0x3, 0x1 }, // 700
  { IMAGE_ATOMIC_SWAP_V1_V4_vi, IMAGE_ATOMIC_SWAP, MIMGEncGfx8, 0x1, 0x4, 0x1 }, // 701
  { IMAGE_ATOMIC_SWAP_V2_V1_vi, IMAGE_ATOMIC_SWAP, MIMGEncGfx8, 0x2, 0x1, 0x1 }, // 702
  { IMAGE_ATOMIC_SWAP_V2_V2_vi, IMAGE_ATOMIC_SWAP, MIMGEncGfx8, 0x2, 0x2, 0x1 }, // 703
  { IMAGE_ATOMIC_SWAP_V2_V3_vi, IMAGE_ATOMIC_SWAP, MIMGEncGfx8, 0x2, 0x3, 0x1 }, // 704
  { IMAGE_ATOMIC_SWAP_V2_V4_vi, IMAGE_ATOMIC_SWAP, MIMGEncGfx8, 0x2, 0x4, 0x1 }, // 705
  { IMAGE_ATOMIC_SWAP_V1_V1_gfx90a, IMAGE_ATOMIC_SWAP, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 706
  { IMAGE_ATOMIC_SWAP_V1_V2_gfx90a, IMAGE_ATOMIC_SWAP, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 707
  { IMAGE_ATOMIC_SWAP_V1_V3_gfx90a, IMAGE_ATOMIC_SWAP, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 708
  { IMAGE_ATOMIC_SWAP_V1_V4_gfx90a, IMAGE_ATOMIC_SWAP, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 709
  { IMAGE_ATOMIC_SWAP_V2_V1_gfx90a, IMAGE_ATOMIC_SWAP, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 710
  { IMAGE_ATOMIC_SWAP_V2_V2_gfx90a, IMAGE_ATOMIC_SWAP, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 711
  { IMAGE_ATOMIC_SWAP_V2_V3_gfx90a, IMAGE_ATOMIC_SWAP, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 712
  { IMAGE_ATOMIC_SWAP_V2_V4_gfx90a, IMAGE_ATOMIC_SWAP, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 713
  { IMAGE_ATOMIC_UMAX_V1_V1_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 714
  { IMAGE_ATOMIC_UMAX_V1_V2_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 715
  { IMAGE_ATOMIC_UMAX_V1_V3_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 716
  { IMAGE_ATOMIC_UMAX_V1_V4_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 717
  { IMAGE_ATOMIC_UMAX_V2_V1_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 718
  { IMAGE_ATOMIC_UMAX_V2_V2_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 719
  { IMAGE_ATOMIC_UMAX_V2_V3_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 720
  { IMAGE_ATOMIC_UMAX_V2_V4_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 721
  { IMAGE_ATOMIC_UMAX_V1_V2_nsa_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 722
  { IMAGE_ATOMIC_UMAX_V1_V3_nsa_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 723
  { IMAGE_ATOMIC_UMAX_V1_V4_nsa_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 724
  { IMAGE_ATOMIC_UMAX_V2_V2_nsa_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 725
  { IMAGE_ATOMIC_UMAX_V2_V3_nsa_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 726
  { IMAGE_ATOMIC_UMAX_V2_V4_nsa_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 727
  { IMAGE_ATOMIC_UMAX_V1_V1_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 728
  { IMAGE_ATOMIC_UMAX_V1_V2_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 729
  { IMAGE_ATOMIC_UMAX_V1_V3_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 730
  { IMAGE_ATOMIC_UMAX_V1_V4_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 731
  { IMAGE_ATOMIC_UMAX_V2_V1_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 732
  { IMAGE_ATOMIC_UMAX_V2_V2_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 733
  { IMAGE_ATOMIC_UMAX_V2_V3_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 734
  { IMAGE_ATOMIC_UMAX_V2_V4_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 735
  { IMAGE_ATOMIC_UMAX_V1_V2_nsa_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 736
  { IMAGE_ATOMIC_UMAX_V1_V3_nsa_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 737
  { IMAGE_ATOMIC_UMAX_V1_V4_nsa_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 738
  { IMAGE_ATOMIC_UMAX_V2_V2_nsa_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 739
  { IMAGE_ATOMIC_UMAX_V2_V3_nsa_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 740
  { IMAGE_ATOMIC_UMAX_V2_V4_nsa_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 741
  { IMAGE_ATOMIC_UMAX_V1_V1_gfx12, IMAGE_ATOMIC_UMAX, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 742
  { IMAGE_ATOMIC_UMAX_V1_V2_gfx12, IMAGE_ATOMIC_UMAX, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 743
  { IMAGE_ATOMIC_UMAX_V1_V3_gfx12, IMAGE_ATOMIC_UMAX, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 744
  { IMAGE_ATOMIC_UMAX_V1_V4_gfx12, IMAGE_ATOMIC_UMAX, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 745
  { IMAGE_ATOMIC_UMAX_V2_V1_gfx12, IMAGE_ATOMIC_UMAX, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 746
  { IMAGE_ATOMIC_UMAX_V2_V2_gfx12, IMAGE_ATOMIC_UMAX, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 747
  { IMAGE_ATOMIC_UMAX_V2_V3_gfx12, IMAGE_ATOMIC_UMAX, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 748
  { IMAGE_ATOMIC_UMAX_V2_V4_gfx12, IMAGE_ATOMIC_UMAX, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 749
  { IMAGE_ATOMIC_UMAX_V1_V1_si, IMAGE_ATOMIC_UMAX, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 750
  { IMAGE_ATOMIC_UMAX_V1_V2_si, IMAGE_ATOMIC_UMAX, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 751
  { IMAGE_ATOMIC_UMAX_V1_V3_si, IMAGE_ATOMIC_UMAX, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 752
  { IMAGE_ATOMIC_UMAX_V1_V4_si, IMAGE_ATOMIC_UMAX, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 753
  { IMAGE_ATOMIC_UMAX_V2_V1_si, IMAGE_ATOMIC_UMAX, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 754
  { IMAGE_ATOMIC_UMAX_V2_V2_si, IMAGE_ATOMIC_UMAX, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 755
  { IMAGE_ATOMIC_UMAX_V2_V3_si, IMAGE_ATOMIC_UMAX, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 756
  { IMAGE_ATOMIC_UMAX_V2_V4_si, IMAGE_ATOMIC_UMAX, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 757
  { IMAGE_ATOMIC_UMAX_V1_V1_vi, IMAGE_ATOMIC_UMAX, MIMGEncGfx8, 0x1, 0x1, 0x1 }, // 758
  { IMAGE_ATOMIC_UMAX_V1_V2_vi, IMAGE_ATOMIC_UMAX, MIMGEncGfx8, 0x1, 0x2, 0x1 }, // 759
  { IMAGE_ATOMIC_UMAX_V1_V3_vi, IMAGE_ATOMIC_UMAX, MIMGEncGfx8, 0x1, 0x3, 0x1 }, // 760
  { IMAGE_ATOMIC_UMAX_V1_V4_vi, IMAGE_ATOMIC_UMAX, MIMGEncGfx8, 0x1, 0x4, 0x1 }, // 761
  { IMAGE_ATOMIC_UMAX_V2_V1_vi, IMAGE_ATOMIC_UMAX, MIMGEncGfx8, 0x2, 0x1, 0x1 }, // 762
  { IMAGE_ATOMIC_UMAX_V2_V2_vi, IMAGE_ATOMIC_UMAX, MIMGEncGfx8, 0x2, 0x2, 0x1 }, // 763
  { IMAGE_ATOMIC_UMAX_V2_V3_vi, IMAGE_ATOMIC_UMAX, MIMGEncGfx8, 0x2, 0x3, 0x1 }, // 764
  { IMAGE_ATOMIC_UMAX_V2_V4_vi, IMAGE_ATOMIC_UMAX, MIMGEncGfx8, 0x2, 0x4, 0x1 }, // 765
  { IMAGE_ATOMIC_UMAX_V1_V1_gfx90a, IMAGE_ATOMIC_UMAX, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 766
  { IMAGE_ATOMIC_UMAX_V1_V2_gfx90a, IMAGE_ATOMIC_UMAX, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 767
  { IMAGE_ATOMIC_UMAX_V1_V3_gfx90a, IMAGE_ATOMIC_UMAX, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 768
  { IMAGE_ATOMIC_UMAX_V1_V4_gfx90a, IMAGE_ATOMIC_UMAX, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 769
  { IMAGE_ATOMIC_UMAX_V2_V1_gfx90a, IMAGE_ATOMIC_UMAX, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 770
  { IMAGE_ATOMIC_UMAX_V2_V2_gfx90a, IMAGE_ATOMIC_UMAX, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 771
  { IMAGE_ATOMIC_UMAX_V2_V3_gfx90a, IMAGE_ATOMIC_UMAX, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 772
  { IMAGE_ATOMIC_UMAX_V2_V4_gfx90a, IMAGE_ATOMIC_UMAX, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 773
  { IMAGE_ATOMIC_UMIN_V1_V1_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 774
  { IMAGE_ATOMIC_UMIN_V1_V2_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 775
  { IMAGE_ATOMIC_UMIN_V1_V3_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 776
  { IMAGE_ATOMIC_UMIN_V1_V4_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 777
  { IMAGE_ATOMIC_UMIN_V2_V1_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 778
  { IMAGE_ATOMIC_UMIN_V2_V2_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 779
  { IMAGE_ATOMIC_UMIN_V2_V3_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 780
  { IMAGE_ATOMIC_UMIN_V2_V4_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 781
  { IMAGE_ATOMIC_UMIN_V1_V2_nsa_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 782
  { IMAGE_ATOMIC_UMIN_V1_V3_nsa_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 783
  { IMAGE_ATOMIC_UMIN_V1_V4_nsa_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 784
  { IMAGE_ATOMIC_UMIN_V2_V2_nsa_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 785
  { IMAGE_ATOMIC_UMIN_V2_V3_nsa_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 786
  { IMAGE_ATOMIC_UMIN_V2_V4_nsa_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 787
  { IMAGE_ATOMIC_UMIN_V1_V1_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 788
  { IMAGE_ATOMIC_UMIN_V1_V2_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 789
  { IMAGE_ATOMIC_UMIN_V1_V3_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 790
  { IMAGE_ATOMIC_UMIN_V1_V4_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 791
  { IMAGE_ATOMIC_UMIN_V2_V1_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 792
  { IMAGE_ATOMIC_UMIN_V2_V2_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 793
  { IMAGE_ATOMIC_UMIN_V2_V3_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 794
  { IMAGE_ATOMIC_UMIN_V2_V4_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 795
  { IMAGE_ATOMIC_UMIN_V1_V2_nsa_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 796
  { IMAGE_ATOMIC_UMIN_V1_V3_nsa_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 797
  { IMAGE_ATOMIC_UMIN_V1_V4_nsa_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 798
  { IMAGE_ATOMIC_UMIN_V2_V2_nsa_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 799
  { IMAGE_ATOMIC_UMIN_V2_V3_nsa_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 800
  { IMAGE_ATOMIC_UMIN_V2_V4_nsa_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 801
  { IMAGE_ATOMIC_UMIN_V1_V1_gfx12, IMAGE_ATOMIC_UMIN, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 802
  { IMAGE_ATOMIC_UMIN_V1_V2_gfx12, IMAGE_ATOMIC_UMIN, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 803
  { IMAGE_ATOMIC_UMIN_V1_V3_gfx12, IMAGE_ATOMIC_UMIN, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 804
  { IMAGE_ATOMIC_UMIN_V1_V4_gfx12, IMAGE_ATOMIC_UMIN, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 805
  { IMAGE_ATOMIC_UMIN_V2_V1_gfx12, IMAGE_ATOMIC_UMIN, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 806
  { IMAGE_ATOMIC_UMIN_V2_V2_gfx12, IMAGE_ATOMIC_UMIN, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 807
  { IMAGE_ATOMIC_UMIN_V2_V3_gfx12, IMAGE_ATOMIC_UMIN, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 808
  { IMAGE_ATOMIC_UMIN_V2_V4_gfx12, IMAGE_ATOMIC_UMIN, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 809
  { IMAGE_ATOMIC_UMIN_V1_V1_si, IMAGE_ATOMIC_UMIN, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 810
  { IMAGE_ATOMIC_UMIN_V1_V2_si, IMAGE_ATOMIC_UMIN, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 811
  { IMAGE_ATOMIC_UMIN_V1_V3_si, IMAGE_ATOMIC_UMIN, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 812
  { IMAGE_ATOMIC_UMIN_V1_V4_si, IMAGE_ATOMIC_UMIN, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 813
  { IMAGE_ATOMIC_UMIN_V2_V1_si, IMAGE_ATOMIC_UMIN, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 814
  { IMAGE_ATOMIC_UMIN_V2_V2_si, IMAGE_ATOMIC_UMIN, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 815
  { IMAGE_ATOMIC_UMIN_V2_V3_si, IMAGE_ATOMIC_UMIN, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 816
  { IMAGE_ATOMIC_UMIN_V2_V4_si, IMAGE_ATOMIC_UMIN, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 817
  { IMAGE_ATOMIC_UMIN_V1_V1_vi, IMAGE_ATOMIC_UMIN, MIMGEncGfx8, 0x1, 0x1, 0x1 }, // 818
  { IMAGE_ATOMIC_UMIN_V1_V2_vi, IMAGE_ATOMIC_UMIN, MIMGEncGfx8, 0x1, 0x2, 0x1 }, // 819
  { IMAGE_ATOMIC_UMIN_V1_V3_vi, IMAGE_ATOMIC_UMIN, MIMGEncGfx8, 0x1, 0x3, 0x1 }, // 820
  { IMAGE_ATOMIC_UMIN_V1_V4_vi, IMAGE_ATOMIC_UMIN, MIMGEncGfx8, 0x1, 0x4, 0x1 }, // 821
  { IMAGE_ATOMIC_UMIN_V2_V1_vi, IMAGE_ATOMIC_UMIN, MIMGEncGfx8, 0x2, 0x1, 0x1 }, // 822
  { IMAGE_ATOMIC_UMIN_V2_V2_vi, IMAGE_ATOMIC_UMIN, MIMGEncGfx8, 0x2, 0x2, 0x1 }, // 823
  { IMAGE_ATOMIC_UMIN_V2_V3_vi, IMAGE_ATOMIC_UMIN, MIMGEncGfx8, 0x2, 0x3, 0x1 }, // 824
  { IMAGE_ATOMIC_UMIN_V2_V4_vi, IMAGE_ATOMIC_UMIN, MIMGEncGfx8, 0x2, 0x4, 0x1 }, // 825
  { IMAGE_ATOMIC_UMIN_V1_V1_gfx90a, IMAGE_ATOMIC_UMIN, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 826
  { IMAGE_ATOMIC_UMIN_V1_V2_gfx90a, IMAGE_ATOMIC_UMIN, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 827
  { IMAGE_ATOMIC_UMIN_V1_V3_gfx90a, IMAGE_ATOMIC_UMIN, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 828
  { IMAGE_ATOMIC_UMIN_V1_V4_gfx90a, IMAGE_ATOMIC_UMIN, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 829
  { IMAGE_ATOMIC_UMIN_V2_V1_gfx90a, IMAGE_ATOMIC_UMIN, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 830
  { IMAGE_ATOMIC_UMIN_V2_V2_gfx90a, IMAGE_ATOMIC_UMIN, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 831
  { IMAGE_ATOMIC_UMIN_V2_V3_gfx90a, IMAGE_ATOMIC_UMIN, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 832
  { IMAGE_ATOMIC_UMIN_V2_V4_gfx90a, IMAGE_ATOMIC_UMIN, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 833
  { IMAGE_ATOMIC_XOR_V1_V1_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 834
  { IMAGE_ATOMIC_XOR_V1_V2_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 835
  { IMAGE_ATOMIC_XOR_V1_V3_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 836
  { IMAGE_ATOMIC_XOR_V1_V4_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 837
  { IMAGE_ATOMIC_XOR_V2_V1_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 838
  { IMAGE_ATOMIC_XOR_V2_V2_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 839
  { IMAGE_ATOMIC_XOR_V2_V3_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 840
  { IMAGE_ATOMIC_XOR_V2_V4_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 841
  { IMAGE_ATOMIC_XOR_V1_V2_nsa_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 842
  { IMAGE_ATOMIC_XOR_V1_V3_nsa_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 843
  { IMAGE_ATOMIC_XOR_V1_V4_nsa_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 844
  { IMAGE_ATOMIC_XOR_V2_V2_nsa_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 845
  { IMAGE_ATOMIC_XOR_V2_V3_nsa_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 846
  { IMAGE_ATOMIC_XOR_V2_V4_nsa_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 847
  { IMAGE_ATOMIC_XOR_V1_V1_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 848
  { IMAGE_ATOMIC_XOR_V1_V2_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 849
  { IMAGE_ATOMIC_XOR_V1_V3_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 850
  { IMAGE_ATOMIC_XOR_V1_V4_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 851
  { IMAGE_ATOMIC_XOR_V2_V1_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 852
  { IMAGE_ATOMIC_XOR_V2_V2_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 853
  { IMAGE_ATOMIC_XOR_V2_V3_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 854
  { IMAGE_ATOMIC_XOR_V2_V4_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 855
  { IMAGE_ATOMIC_XOR_V1_V2_nsa_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 856
  { IMAGE_ATOMIC_XOR_V1_V3_nsa_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 857
  { IMAGE_ATOMIC_XOR_V1_V4_nsa_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 858
  { IMAGE_ATOMIC_XOR_V2_V2_nsa_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 859
  { IMAGE_ATOMIC_XOR_V2_V3_nsa_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 860
  { IMAGE_ATOMIC_XOR_V2_V4_nsa_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 861
  { IMAGE_ATOMIC_XOR_V1_V1_gfx12, IMAGE_ATOMIC_XOR, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 862
  { IMAGE_ATOMIC_XOR_V1_V2_gfx12, IMAGE_ATOMIC_XOR, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 863
  { IMAGE_ATOMIC_XOR_V1_V3_gfx12, IMAGE_ATOMIC_XOR, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 864
  { IMAGE_ATOMIC_XOR_V1_V4_gfx12, IMAGE_ATOMIC_XOR, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 865
  { IMAGE_ATOMIC_XOR_V2_V1_gfx12, IMAGE_ATOMIC_XOR, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 866
  { IMAGE_ATOMIC_XOR_V2_V2_gfx12, IMAGE_ATOMIC_XOR, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 867
  { IMAGE_ATOMIC_XOR_V2_V3_gfx12, IMAGE_ATOMIC_XOR, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 868
  { IMAGE_ATOMIC_XOR_V2_V4_gfx12, IMAGE_ATOMIC_XOR, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 869
  { IMAGE_ATOMIC_XOR_V1_V1_si, IMAGE_ATOMIC_XOR, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 870
  { IMAGE_ATOMIC_XOR_V1_V2_si, IMAGE_ATOMIC_XOR, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 871
  { IMAGE_ATOMIC_XOR_V1_V3_si, IMAGE_ATOMIC_XOR, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 872
  { IMAGE_ATOMIC_XOR_V1_V4_si, IMAGE_ATOMIC_XOR, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 873
  { IMAGE_ATOMIC_XOR_V2_V1_si, IMAGE_ATOMIC_XOR, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 874
  { IMAGE_ATOMIC_XOR_V2_V2_si, IMAGE_ATOMIC_XOR, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 875
  { IMAGE_ATOMIC_XOR_V2_V3_si, IMAGE_ATOMIC_XOR, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 876
  { IMAGE_ATOMIC_XOR_V2_V4_si, IMAGE_ATOMIC_XOR, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 877
  { IMAGE_ATOMIC_XOR_V1_V1_vi, IMAGE_ATOMIC_XOR, MIMGEncGfx8, 0x1, 0x1, 0x1 }, // 878
  { IMAGE_ATOMIC_XOR_V1_V2_vi, IMAGE_ATOMIC_XOR, MIMGEncGfx8, 0x1, 0x2, 0x1 }, // 879
  { IMAGE_ATOMIC_XOR_V1_V3_vi, IMAGE_ATOMIC_XOR, MIMGEncGfx8, 0x1, 0x3, 0x1 }, // 880
  { IMAGE_ATOMIC_XOR_V1_V4_vi, IMAGE_ATOMIC_XOR, MIMGEncGfx8, 0x1, 0x4, 0x1 }, // 881
  { IMAGE_ATOMIC_XOR_V2_V1_vi, IMAGE_ATOMIC_XOR, MIMGEncGfx8, 0x2, 0x1, 0x1 }, // 882
  { IMAGE_ATOMIC_XOR_V2_V2_vi, IMAGE_ATOMIC_XOR, MIMGEncGfx8, 0x2, 0x2, 0x1 }, // 883
  { IMAGE_ATOMIC_XOR_V2_V3_vi, IMAGE_ATOMIC_XOR, MIMGEncGfx8, 0x2, 0x3, 0x1 }, // 884
  { IMAGE_ATOMIC_XOR_V2_V4_vi, IMAGE_ATOMIC_XOR, MIMGEncGfx8, 0x2, 0x4, 0x1 }, // 885
  { IMAGE_ATOMIC_XOR_V1_V1_gfx90a, IMAGE_ATOMIC_XOR, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 886
  { IMAGE_ATOMIC_XOR_V1_V2_gfx90a, IMAGE_ATOMIC_XOR, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 887
  { IMAGE_ATOMIC_XOR_V1_V3_gfx90a, IMAGE_ATOMIC_XOR, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 888
  { IMAGE_ATOMIC_XOR_V1_V4_gfx90a, IMAGE_ATOMIC_XOR, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 889
  { IMAGE_ATOMIC_XOR_V2_V1_gfx90a, IMAGE_ATOMIC_XOR, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 890
  { IMAGE_ATOMIC_XOR_V2_V2_gfx90a, IMAGE_ATOMIC_XOR, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 891
  { IMAGE_ATOMIC_XOR_V2_V3_gfx90a, IMAGE_ATOMIC_XOR, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 892
  { IMAGE_ATOMIC_XOR_V2_V4_gfx90a, IMAGE_ATOMIC_XOR, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 893
  { IMAGE_BVH64_INTERSECT_RAY_sa_gfx10, IMAGE_BVH64_INTERSECT_RAY, MIMGEncGfx10Default, 0x4, 0xC, 0x1 }, // 894
  { IMAGE_BVH64_INTERSECT_RAY_nsa_gfx10, IMAGE_BVH64_INTERSECT_RAY, MIMGEncGfx10NSA, 0x4, 0xC, 0xC }, // 895
  { IMAGE_BVH64_INTERSECT_RAY_sa_gfx11, IMAGE_BVH64_INTERSECT_RAY, MIMGEncGfx11Default, 0x4, 0xC, 0x1 }, // 896
  { IMAGE_BVH64_INTERSECT_RAY_nsa_gfx11, IMAGE_BVH64_INTERSECT_RAY, MIMGEncGfx11NSA, 0x4, 0xC, 0x5 }, // 897
  { IMAGE_BVH64_INTERSECT_RAY_gfx12, IMAGE_BVH64_INTERSECT_RAY, MIMGEncGfx12, 0x4, 0xC, 0x5 }, // 898
  { IMAGE_BVH64_INTERSECT_RAY_a16_sa_gfx10, IMAGE_BVH64_INTERSECT_RAY_a16, MIMGEncGfx10Default, 0x4, 0x9, 0x1 }, // 899
  { IMAGE_BVH64_INTERSECT_RAY_a16_nsa_gfx10, IMAGE_BVH64_INTERSECT_RAY_a16, MIMGEncGfx10NSA, 0x4, 0x9, 0x9 }, // 900
  { IMAGE_BVH64_INTERSECT_RAY_a16_sa_gfx11, IMAGE_BVH64_INTERSECT_RAY_a16, MIMGEncGfx11Default, 0x4, 0x9, 0x1 }, // 901
  { IMAGE_BVH64_INTERSECT_RAY_a16_nsa_gfx11, IMAGE_BVH64_INTERSECT_RAY_a16, MIMGEncGfx11NSA, 0x4, 0x9, 0x4 }, // 902
  { IMAGE_BVH64_INTERSECT_RAY_a16_gfx12, IMAGE_BVH64_INTERSECT_RAY_a16, MIMGEncGfx12, 0x4, 0x9, 0x4 }, // 903
  { IMAGE_BVH_INTERSECT_RAY_sa_gfx10, IMAGE_BVH_INTERSECT_RAY, MIMGEncGfx10Default, 0x4, 0xB, 0x1 }, // 904
  { IMAGE_BVH_INTERSECT_RAY_nsa_gfx10, IMAGE_BVH_INTERSECT_RAY, MIMGEncGfx10NSA, 0x4, 0xB, 0xB }, // 905
  { IMAGE_BVH_INTERSECT_RAY_sa_gfx11, IMAGE_BVH_INTERSECT_RAY, MIMGEncGfx11Default, 0x4, 0xB, 0x1 }, // 906
  { IMAGE_BVH_INTERSECT_RAY_nsa_gfx11, IMAGE_BVH_INTERSECT_RAY, MIMGEncGfx11NSA, 0x4, 0xB, 0x5 }, // 907
  { IMAGE_BVH_INTERSECT_RAY_gfx12, IMAGE_BVH_INTERSECT_RAY, MIMGEncGfx12, 0x4, 0xB, 0x5 }, // 908
  { IMAGE_BVH_INTERSECT_RAY_a16_sa_gfx10, IMAGE_BVH_INTERSECT_RAY_a16, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 909
  { IMAGE_BVH_INTERSECT_RAY_a16_nsa_gfx10, IMAGE_BVH_INTERSECT_RAY_a16, MIMGEncGfx10NSA, 0x4, 0x8, 0x8 }, // 910
  { IMAGE_BVH_INTERSECT_RAY_a16_sa_gfx11, IMAGE_BVH_INTERSECT_RAY_a16, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 911
  { IMAGE_BVH_INTERSECT_RAY_a16_nsa_gfx11, IMAGE_BVH_INTERSECT_RAY_a16, MIMGEncGfx11NSA, 0x4, 0x8, 0x4 }, // 912
  { IMAGE_BVH_INTERSECT_RAY_a16_gfx12, IMAGE_BVH_INTERSECT_RAY_a16, MIMGEncGfx12, 0x4, 0x8, 0x4 }, // 913
  { IMAGE_GATHER4_V2_V1_gfx10, IMAGE_GATHER4, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 914
  { IMAGE_GATHER4_V2_V2_gfx10, IMAGE_GATHER4, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 915
  { IMAGE_GATHER4_V2_V3_gfx10, IMAGE_GATHER4, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 916
  { IMAGE_GATHER4_V2_V4_gfx10, IMAGE_GATHER4, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 917
  { IMAGE_GATHER4_V4_V1_gfx10, IMAGE_GATHER4, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 918
  { IMAGE_GATHER4_V4_V2_gfx10, IMAGE_GATHER4, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 919
  { IMAGE_GATHER4_V4_V3_gfx10, IMAGE_GATHER4, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 920
  { IMAGE_GATHER4_V4_V4_gfx10, IMAGE_GATHER4, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 921
  { IMAGE_GATHER4_V5_V1_gfx10, IMAGE_GATHER4, MIMGEncGfx10Default, 0x5, 0x1, 0x1 }, // 922
  { IMAGE_GATHER4_V5_V2_gfx10, IMAGE_GATHER4, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 923
  { IMAGE_GATHER4_V5_V3_gfx10, IMAGE_GATHER4, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 924
  { IMAGE_GATHER4_V5_V4_gfx10, IMAGE_GATHER4, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 925
  { IMAGE_GATHER4_V2_V2_nsa_gfx10, IMAGE_GATHER4, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 926
  { IMAGE_GATHER4_V2_V3_nsa_gfx10, IMAGE_GATHER4, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 927
  { IMAGE_GATHER4_V4_V2_nsa_gfx10, IMAGE_GATHER4, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 928
  { IMAGE_GATHER4_V4_V3_nsa_gfx10, IMAGE_GATHER4, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 929
  { IMAGE_GATHER4_V5_V2_nsa_gfx10, IMAGE_GATHER4, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 930
  { IMAGE_GATHER4_V5_V3_nsa_gfx10, IMAGE_GATHER4, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 931
  { IMAGE_GATHER4_V2_V1_gfx11, IMAGE_GATHER4, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 932
  { IMAGE_GATHER4_V2_V2_gfx11, IMAGE_GATHER4, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 933
  { IMAGE_GATHER4_V2_V3_gfx11, IMAGE_GATHER4, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 934
  { IMAGE_GATHER4_V2_V4_gfx11, IMAGE_GATHER4, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 935
  { IMAGE_GATHER4_V4_V1_gfx11, IMAGE_GATHER4, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 936
  { IMAGE_GATHER4_V4_V2_gfx11, IMAGE_GATHER4, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 937
  { IMAGE_GATHER4_V4_V3_gfx11, IMAGE_GATHER4, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 938
  { IMAGE_GATHER4_V4_V4_gfx11, IMAGE_GATHER4, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 939
  { IMAGE_GATHER4_V5_V1_gfx11, IMAGE_GATHER4, MIMGEncGfx11Default, 0x5, 0x1, 0x1 }, // 940
  { IMAGE_GATHER4_V5_V2_gfx11, IMAGE_GATHER4, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 941
  { IMAGE_GATHER4_V5_V3_gfx11, IMAGE_GATHER4, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 942
  { IMAGE_GATHER4_V5_V4_gfx11, IMAGE_GATHER4, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 943
  { IMAGE_GATHER4_V2_V2_nsa_gfx11, IMAGE_GATHER4, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 944
  { IMAGE_GATHER4_V2_V3_nsa_gfx11, IMAGE_GATHER4, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 945
  { IMAGE_GATHER4_V4_V2_nsa_gfx11, IMAGE_GATHER4, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 946
  { IMAGE_GATHER4_V4_V3_nsa_gfx11, IMAGE_GATHER4, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 947
  { IMAGE_GATHER4_V5_V2_nsa_gfx11, IMAGE_GATHER4, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 948
  { IMAGE_GATHER4_V5_V3_nsa_gfx11, IMAGE_GATHER4, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 949
  { IMAGE_GATHER4_V2_V1_gfx12, IMAGE_GATHER4, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 950
  { IMAGE_GATHER4_V2_V2_gfx12, IMAGE_GATHER4, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 951
  { IMAGE_GATHER4_V2_V3_gfx12, IMAGE_GATHER4, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 952
  { IMAGE_GATHER4_V4_V1_gfx12, IMAGE_GATHER4, MIMGEncGfx12, 0x4, 0x1, 0x1 }, // 953
  { IMAGE_GATHER4_V4_V2_gfx12, IMAGE_GATHER4, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 954
  { IMAGE_GATHER4_V4_V3_gfx12, IMAGE_GATHER4, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 955
  { IMAGE_GATHER4_V5_V1_gfx12, IMAGE_GATHER4, MIMGEncGfx12, 0x5, 0x1, 0x1 }, // 956
  { IMAGE_GATHER4_V5_V2_gfx12, IMAGE_GATHER4, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 957
  { IMAGE_GATHER4_V5_V3_gfx12, IMAGE_GATHER4, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 958
  { IMAGE_GATHER4_V2_V1, IMAGE_GATHER4, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 959
  { IMAGE_GATHER4_V2_V2, IMAGE_GATHER4, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 960
  { IMAGE_GATHER4_V2_V3, IMAGE_GATHER4, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 961
  { IMAGE_GATHER4_V2_V4, IMAGE_GATHER4, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 962
  { IMAGE_GATHER4_V4_V1, IMAGE_GATHER4, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 963
  { IMAGE_GATHER4_V4_V2, IMAGE_GATHER4, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 964
  { IMAGE_GATHER4_V4_V3, IMAGE_GATHER4, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 965
  { IMAGE_GATHER4_V4_V4, IMAGE_GATHER4, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 966
  { IMAGE_GATHER4_V5_V1, IMAGE_GATHER4, MIMGEncGfx6, 0x5, 0x1, 0x1 }, // 967
  { IMAGE_GATHER4_V5_V2, IMAGE_GATHER4, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 968
  { IMAGE_GATHER4_V5_V3, IMAGE_GATHER4, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 969
  { IMAGE_GATHER4_V5_V4, IMAGE_GATHER4, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 970
  { IMAGE_GATHER4H_V2_V1_gfx10, IMAGE_GATHER4H, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 971
  { IMAGE_GATHER4H_V2_V2_gfx10, IMAGE_GATHER4H, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 972
  { IMAGE_GATHER4H_V2_V3_gfx10, IMAGE_GATHER4H, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 973
  { IMAGE_GATHER4H_V2_V4_gfx10, IMAGE_GATHER4H, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 974
  { IMAGE_GATHER4H_V4_V1_gfx10, IMAGE_GATHER4H, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 975
  { IMAGE_GATHER4H_V4_V2_gfx10, IMAGE_GATHER4H, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 976
  { IMAGE_GATHER4H_V4_V3_gfx10, IMAGE_GATHER4H, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 977
  { IMAGE_GATHER4H_V4_V4_gfx10, IMAGE_GATHER4H, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 978
  { IMAGE_GATHER4H_V5_V1_gfx10, IMAGE_GATHER4H, MIMGEncGfx10Default, 0x5, 0x1, 0x1 }, // 979
  { IMAGE_GATHER4H_V5_V2_gfx10, IMAGE_GATHER4H, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 980
  { IMAGE_GATHER4H_V5_V3_gfx10, IMAGE_GATHER4H, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 981
  { IMAGE_GATHER4H_V5_V4_gfx10, IMAGE_GATHER4H, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 982
  { IMAGE_GATHER4H_V2_V2_nsa_gfx10, IMAGE_GATHER4H, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 983
  { IMAGE_GATHER4H_V2_V3_nsa_gfx10, IMAGE_GATHER4H, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 984
  { IMAGE_GATHER4H_V4_V2_nsa_gfx10, IMAGE_GATHER4H, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 985
  { IMAGE_GATHER4H_V4_V3_nsa_gfx10, IMAGE_GATHER4H, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 986
  { IMAGE_GATHER4H_V5_V2_nsa_gfx10, IMAGE_GATHER4H, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 987
  { IMAGE_GATHER4H_V5_V3_nsa_gfx10, IMAGE_GATHER4H, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 988
  { IMAGE_GATHER4H_V2_V1_gfx11, IMAGE_GATHER4H, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 989
  { IMAGE_GATHER4H_V2_V2_gfx11, IMAGE_GATHER4H, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 990
  { IMAGE_GATHER4H_V2_V3_gfx11, IMAGE_GATHER4H, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 991
  { IMAGE_GATHER4H_V2_V4_gfx11, IMAGE_GATHER4H, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 992
  { IMAGE_GATHER4H_V4_V1_gfx11, IMAGE_GATHER4H, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 993
  { IMAGE_GATHER4H_V4_V2_gfx11, IMAGE_GATHER4H, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 994
  { IMAGE_GATHER4H_V4_V3_gfx11, IMAGE_GATHER4H, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 995
  { IMAGE_GATHER4H_V4_V4_gfx11, IMAGE_GATHER4H, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 996
  { IMAGE_GATHER4H_V5_V1_gfx11, IMAGE_GATHER4H, MIMGEncGfx11Default, 0x5, 0x1, 0x1 }, // 997
  { IMAGE_GATHER4H_V5_V2_gfx11, IMAGE_GATHER4H, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 998
  { IMAGE_GATHER4H_V5_V3_gfx11, IMAGE_GATHER4H, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 999
  { IMAGE_GATHER4H_V5_V4_gfx11, IMAGE_GATHER4H, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 1000
  { IMAGE_GATHER4H_V2_V2_nsa_gfx11, IMAGE_GATHER4H, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 1001
  { IMAGE_GATHER4H_V2_V3_nsa_gfx11, IMAGE_GATHER4H, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 1002
  { IMAGE_GATHER4H_V4_V2_nsa_gfx11, IMAGE_GATHER4H, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 1003
  { IMAGE_GATHER4H_V4_V3_nsa_gfx11, IMAGE_GATHER4H, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 1004
  { IMAGE_GATHER4H_V5_V2_nsa_gfx11, IMAGE_GATHER4H, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 1005
  { IMAGE_GATHER4H_V5_V3_nsa_gfx11, IMAGE_GATHER4H, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 1006
  { IMAGE_GATHER4H_V2_V1_gfx12, IMAGE_GATHER4H, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 1007
  { IMAGE_GATHER4H_V2_V2_gfx12, IMAGE_GATHER4H, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 1008
  { IMAGE_GATHER4H_V2_V3_gfx12, IMAGE_GATHER4H, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 1009
  { IMAGE_GATHER4H_V4_V1_gfx12, IMAGE_GATHER4H, MIMGEncGfx12, 0x4, 0x1, 0x1 }, // 1010
  { IMAGE_GATHER4H_V4_V2_gfx12, IMAGE_GATHER4H, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 1011
  { IMAGE_GATHER4H_V4_V3_gfx12, IMAGE_GATHER4H, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 1012
  { IMAGE_GATHER4H_V5_V1_gfx12, IMAGE_GATHER4H, MIMGEncGfx12, 0x5, 0x1, 0x1 }, // 1013
  { IMAGE_GATHER4H_V5_V2_gfx12, IMAGE_GATHER4H, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 1014
  { IMAGE_GATHER4H_V5_V3_gfx12, IMAGE_GATHER4H, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 1015
  { IMAGE_GATHER4H_V2_V1, IMAGE_GATHER4H, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 1016
  { IMAGE_GATHER4H_V2_V2, IMAGE_GATHER4H, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 1017
  { IMAGE_GATHER4H_V2_V3, IMAGE_GATHER4H, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 1018
  { IMAGE_GATHER4H_V2_V4, IMAGE_GATHER4H, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 1019
  { IMAGE_GATHER4H_V4_V1, IMAGE_GATHER4H, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 1020
  { IMAGE_GATHER4H_V4_V2, IMAGE_GATHER4H, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 1021
  { IMAGE_GATHER4H_V4_V3, IMAGE_GATHER4H, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 1022
  { IMAGE_GATHER4H_V4_V4, IMAGE_GATHER4H, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 1023
  { IMAGE_GATHER4H_V5_V1, IMAGE_GATHER4H, MIMGEncGfx6, 0x5, 0x1, 0x1 }, // 1024
  { IMAGE_GATHER4H_V5_V2, IMAGE_GATHER4H, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 1025
  { IMAGE_GATHER4H_V5_V3, IMAGE_GATHER4H, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 1026
  { IMAGE_GATHER4H_V5_V4, IMAGE_GATHER4H, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 1027
  { IMAGE_GATHER4_B_V2_V2_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 1028
  { IMAGE_GATHER4_B_V2_V3_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 1029
  { IMAGE_GATHER4_B_V2_V4_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 1030
  { IMAGE_GATHER4_B_V4_V2_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 1031
  { IMAGE_GATHER4_B_V4_V3_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 1032
  { IMAGE_GATHER4_B_V4_V4_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 1033
  { IMAGE_GATHER4_B_V5_V2_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 1034
  { IMAGE_GATHER4_B_V5_V3_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 1035
  { IMAGE_GATHER4_B_V5_V4_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 1036
  { IMAGE_GATHER4_B_V2_V2_nsa_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 1037
  { IMAGE_GATHER4_B_V2_V3_nsa_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 1038
  { IMAGE_GATHER4_B_V2_V4_nsa_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 1039
  { IMAGE_GATHER4_B_V4_V2_nsa_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 1040
  { IMAGE_GATHER4_B_V4_V3_nsa_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 1041
  { IMAGE_GATHER4_B_V4_V4_nsa_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 1042
  { IMAGE_GATHER4_B_V5_V2_nsa_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 1043
  { IMAGE_GATHER4_B_V5_V3_nsa_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 1044
  { IMAGE_GATHER4_B_V5_V4_nsa_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 1045
  { IMAGE_GATHER4_B_V2_V2_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 1046
  { IMAGE_GATHER4_B_V2_V3_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 1047
  { IMAGE_GATHER4_B_V2_V4_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 1048
  { IMAGE_GATHER4_B_V4_V2_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 1049
  { IMAGE_GATHER4_B_V4_V3_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 1050
  { IMAGE_GATHER4_B_V4_V4_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 1051
  { IMAGE_GATHER4_B_V5_V2_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 1052
  { IMAGE_GATHER4_B_V5_V3_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 1053
  { IMAGE_GATHER4_B_V5_V4_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 1054
  { IMAGE_GATHER4_B_V2_V2_nsa_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 1055
  { IMAGE_GATHER4_B_V2_V3_nsa_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 1056
  { IMAGE_GATHER4_B_V2_V4_nsa_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 1057
  { IMAGE_GATHER4_B_V4_V2_nsa_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 1058
  { IMAGE_GATHER4_B_V4_V3_nsa_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 1059
  { IMAGE_GATHER4_B_V4_V4_nsa_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 1060
  { IMAGE_GATHER4_B_V5_V2_nsa_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 1061
  { IMAGE_GATHER4_B_V5_V3_nsa_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 1062
  { IMAGE_GATHER4_B_V5_V4_nsa_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 1063
  { IMAGE_GATHER4_B_V2_V2_gfx12, IMAGE_GATHER4_B, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 1064
  { IMAGE_GATHER4_B_V2_V3_gfx12, IMAGE_GATHER4_B, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 1065
  { IMAGE_GATHER4_B_V2_V4_gfx12, IMAGE_GATHER4_B, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 1066
  { IMAGE_GATHER4_B_V4_V2_gfx12, IMAGE_GATHER4_B, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 1067
  { IMAGE_GATHER4_B_V4_V3_gfx12, IMAGE_GATHER4_B, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 1068
  { IMAGE_GATHER4_B_V4_V4_gfx12, IMAGE_GATHER4_B, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 1069
  { IMAGE_GATHER4_B_V5_V2_gfx12, IMAGE_GATHER4_B, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 1070
  { IMAGE_GATHER4_B_V5_V3_gfx12, IMAGE_GATHER4_B, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 1071
  { IMAGE_GATHER4_B_V5_V4_gfx12, IMAGE_GATHER4_B, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 1072
  { IMAGE_GATHER4_B_V2_V2, IMAGE_GATHER4_B, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 1073
  { IMAGE_GATHER4_B_V2_V3, IMAGE_GATHER4_B, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 1074
  { IMAGE_GATHER4_B_V2_V4, IMAGE_GATHER4_B, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 1075
  { IMAGE_GATHER4_B_V4_V2, IMAGE_GATHER4_B, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 1076
  { IMAGE_GATHER4_B_V4_V3, IMAGE_GATHER4_B, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 1077
  { IMAGE_GATHER4_B_V4_V4, IMAGE_GATHER4_B, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 1078
  { IMAGE_GATHER4_B_V5_V2, IMAGE_GATHER4_B, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 1079
  { IMAGE_GATHER4_B_V5_V3, IMAGE_GATHER4_B, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 1080
  { IMAGE_GATHER4_B_V5_V4, IMAGE_GATHER4_B, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 1081
  { IMAGE_GATHER4_B_CL_V2_V2_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 1082
  { IMAGE_GATHER4_B_CL_V2_V3_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 1083
  { IMAGE_GATHER4_B_CL_V2_V4_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 1084
  { IMAGE_GATHER4_B_CL_V2_V5_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 1085
  { IMAGE_GATHER4_B_CL_V2_V8_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 1086
  { IMAGE_GATHER4_B_CL_V4_V2_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 1087
  { IMAGE_GATHER4_B_CL_V4_V3_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 1088
  { IMAGE_GATHER4_B_CL_V4_V4_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 1089
  { IMAGE_GATHER4_B_CL_V4_V5_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 1090
  { IMAGE_GATHER4_B_CL_V4_V8_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 1091
  { IMAGE_GATHER4_B_CL_V5_V2_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 1092
  { IMAGE_GATHER4_B_CL_V5_V3_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 1093
  { IMAGE_GATHER4_B_CL_V5_V4_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 1094
  { IMAGE_GATHER4_B_CL_V5_V5_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 1095
  { IMAGE_GATHER4_B_CL_V5_V8_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 1096
  { IMAGE_GATHER4_B_CL_V2_V2_nsa_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 1097
  { IMAGE_GATHER4_B_CL_V2_V3_nsa_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 1098
  { IMAGE_GATHER4_B_CL_V2_V4_nsa_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 1099
  { IMAGE_GATHER4_B_CL_V2_V5_nsa_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 1100
  { IMAGE_GATHER4_B_CL_V4_V2_nsa_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 1101
  { IMAGE_GATHER4_B_CL_V4_V3_nsa_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 1102
  { IMAGE_GATHER4_B_CL_V4_V4_nsa_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 1103
  { IMAGE_GATHER4_B_CL_V4_V5_nsa_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 1104
  { IMAGE_GATHER4_B_CL_V5_V2_nsa_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 1105
  { IMAGE_GATHER4_B_CL_V5_V3_nsa_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 1106
  { IMAGE_GATHER4_B_CL_V5_V4_nsa_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 1107
  { IMAGE_GATHER4_B_CL_V5_V5_nsa_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 1108
  { IMAGE_GATHER4_B_CL_V2_V2_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 1109
  { IMAGE_GATHER4_B_CL_V2_V3_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 1110
  { IMAGE_GATHER4_B_CL_V2_V4_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 1111
  { IMAGE_GATHER4_B_CL_V2_V5_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 1112
  { IMAGE_GATHER4_B_CL_V2_V8_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 1113
  { IMAGE_GATHER4_B_CL_V4_V2_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 1114
  { IMAGE_GATHER4_B_CL_V4_V3_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 1115
  { IMAGE_GATHER4_B_CL_V4_V4_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 1116
  { IMAGE_GATHER4_B_CL_V4_V5_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 1117
  { IMAGE_GATHER4_B_CL_V4_V8_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 1118
  { IMAGE_GATHER4_B_CL_V5_V2_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 1119
  { IMAGE_GATHER4_B_CL_V5_V3_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 1120
  { IMAGE_GATHER4_B_CL_V5_V4_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 1121
  { IMAGE_GATHER4_B_CL_V5_V5_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 1122
  { IMAGE_GATHER4_B_CL_V5_V8_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 1123
  { IMAGE_GATHER4_B_CL_V2_V2_nsa_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 1124
  { IMAGE_GATHER4_B_CL_V2_V3_nsa_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 1125
  { IMAGE_GATHER4_B_CL_V2_V4_nsa_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 1126
  { IMAGE_GATHER4_B_CL_V2_V5_nsa_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 1127
  { IMAGE_GATHER4_B_CL_V4_V2_nsa_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 1128
  { IMAGE_GATHER4_B_CL_V4_V3_nsa_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 1129
  { IMAGE_GATHER4_B_CL_V4_V4_nsa_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 1130
  { IMAGE_GATHER4_B_CL_V4_V5_nsa_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 1131
  { IMAGE_GATHER4_B_CL_V5_V2_nsa_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 1132
  { IMAGE_GATHER4_B_CL_V5_V3_nsa_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 1133
  { IMAGE_GATHER4_B_CL_V5_V4_nsa_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 1134
  { IMAGE_GATHER4_B_CL_V5_V5_nsa_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 1135
  { IMAGE_GATHER4_B_CL_V2_V2_gfx12, IMAGE_GATHER4_B_CL, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 1136
  { IMAGE_GATHER4_B_CL_V2_V3_gfx12, IMAGE_GATHER4_B_CL, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 1137
  { IMAGE_GATHER4_B_CL_V2_V4_gfx12, IMAGE_GATHER4_B_CL, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 1138
  { IMAGE_GATHER4_B_CL_V2_V5_gfx12, IMAGE_GATHER4_B_CL, MIMGEncGfx12, 0x2, 0x5, 0x5 }, // 1139
  { IMAGE_GATHER4_B_CL_V4_V2_gfx12, IMAGE_GATHER4_B_CL, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 1140
  { IMAGE_GATHER4_B_CL_V4_V3_gfx12, IMAGE_GATHER4_B_CL, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 1141
  { IMAGE_GATHER4_B_CL_V4_V4_gfx12, IMAGE_GATHER4_B_CL, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 1142
  { IMAGE_GATHER4_B_CL_V4_V5_gfx12, IMAGE_GATHER4_B_CL, MIMGEncGfx12, 0x4, 0x5, 0x5 }, // 1143
  { IMAGE_GATHER4_B_CL_V5_V2_gfx12, IMAGE_GATHER4_B_CL, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 1144
  { IMAGE_GATHER4_B_CL_V5_V3_gfx12, IMAGE_GATHER4_B_CL, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 1145
  { IMAGE_GATHER4_B_CL_V5_V4_gfx12, IMAGE_GATHER4_B_CL, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 1146
  { IMAGE_GATHER4_B_CL_V5_V5_gfx12, IMAGE_GATHER4_B_CL, MIMGEncGfx12, 0x5, 0x5, 0x5 }, // 1147
  { IMAGE_GATHER4_B_CL_V2_V2, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 1148
  { IMAGE_GATHER4_B_CL_V2_V3, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 1149
  { IMAGE_GATHER4_B_CL_V2_V4, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 1150
  { IMAGE_GATHER4_B_CL_V2_V5, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 1151
  { IMAGE_GATHER4_B_CL_V2_V8, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 1152
  { IMAGE_GATHER4_B_CL_V4_V2, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 1153
  { IMAGE_GATHER4_B_CL_V4_V3, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 1154
  { IMAGE_GATHER4_B_CL_V4_V4, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 1155
  { IMAGE_GATHER4_B_CL_V4_V5, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 1156
  { IMAGE_GATHER4_B_CL_V4_V8, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 1157
  { IMAGE_GATHER4_B_CL_V5_V2, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 1158
  { IMAGE_GATHER4_B_CL_V5_V3, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 1159
  { IMAGE_GATHER4_B_CL_V5_V4, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 1160
  { IMAGE_GATHER4_B_CL_V5_V5, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 1161
  { IMAGE_GATHER4_B_CL_V5_V8, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 1162
  { IMAGE_GATHER4_B_CL_O_V2_V3_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 1163
  { IMAGE_GATHER4_B_CL_O_V2_V4_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 1164
  { IMAGE_GATHER4_B_CL_O_V2_V5_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 1165
  { IMAGE_GATHER4_B_CL_O_V2_V6_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 1166
  { IMAGE_GATHER4_B_CL_O_V2_V8_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 1167
  { IMAGE_GATHER4_B_CL_O_V4_V3_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 1168
  { IMAGE_GATHER4_B_CL_O_V4_V4_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 1169
  { IMAGE_GATHER4_B_CL_O_V4_V5_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 1170
  { IMAGE_GATHER4_B_CL_O_V4_V6_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 1171
  { IMAGE_GATHER4_B_CL_O_V4_V8_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 1172
  { IMAGE_GATHER4_B_CL_O_V5_V3_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 1173
  { IMAGE_GATHER4_B_CL_O_V5_V4_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 1174
  { IMAGE_GATHER4_B_CL_O_V5_V5_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 1175
  { IMAGE_GATHER4_B_CL_O_V5_V6_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 1176
  { IMAGE_GATHER4_B_CL_O_V5_V8_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 1177
  { IMAGE_GATHER4_B_CL_O_V2_V3_nsa_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 1178
  { IMAGE_GATHER4_B_CL_O_V2_V4_nsa_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 1179
  { IMAGE_GATHER4_B_CL_O_V2_V5_nsa_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 1180
  { IMAGE_GATHER4_B_CL_O_V2_V6_nsa_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 1181
  { IMAGE_GATHER4_B_CL_O_V4_V3_nsa_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 1182
  { IMAGE_GATHER4_B_CL_O_V4_V4_nsa_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 1183
  { IMAGE_GATHER4_B_CL_O_V4_V5_nsa_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 1184
  { IMAGE_GATHER4_B_CL_O_V4_V6_nsa_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 1185
  { IMAGE_GATHER4_B_CL_O_V5_V3_nsa_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 1186
  { IMAGE_GATHER4_B_CL_O_V5_V4_nsa_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 1187
  { IMAGE_GATHER4_B_CL_O_V5_V5_nsa_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 1188
  { IMAGE_GATHER4_B_CL_O_V5_V6_nsa_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 1189
  { IMAGE_GATHER4_B_CL_O_V2_V3, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 1190
  { IMAGE_GATHER4_B_CL_O_V2_V4, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 1191
  { IMAGE_GATHER4_B_CL_O_V2_V5, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 1192
  { IMAGE_GATHER4_B_CL_O_V2_V6, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 1193
  { IMAGE_GATHER4_B_CL_O_V2_V8, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 1194
  { IMAGE_GATHER4_B_CL_O_V4_V3, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 1195
  { IMAGE_GATHER4_B_CL_O_V4_V4, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 1196
  { IMAGE_GATHER4_B_CL_O_V4_V5, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 1197
  { IMAGE_GATHER4_B_CL_O_V4_V6, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 1198
  { IMAGE_GATHER4_B_CL_O_V4_V8, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 1199
  { IMAGE_GATHER4_B_CL_O_V5_V3, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 1200
  { IMAGE_GATHER4_B_CL_O_V5_V4, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 1201
  { IMAGE_GATHER4_B_CL_O_V5_V5, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 1202
  { IMAGE_GATHER4_B_CL_O_V5_V6, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 1203
  { IMAGE_GATHER4_B_CL_O_V5_V8, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 1204
  { IMAGE_GATHER4_B_O_V2_V3_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 1205
  { IMAGE_GATHER4_B_O_V2_V4_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 1206
  { IMAGE_GATHER4_B_O_V2_V5_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 1207
  { IMAGE_GATHER4_B_O_V2_V8_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 1208
  { IMAGE_GATHER4_B_O_V4_V3_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 1209
  { IMAGE_GATHER4_B_O_V4_V4_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 1210
  { IMAGE_GATHER4_B_O_V4_V5_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 1211
  { IMAGE_GATHER4_B_O_V4_V8_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 1212
  { IMAGE_GATHER4_B_O_V5_V3_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 1213
  { IMAGE_GATHER4_B_O_V5_V4_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 1214
  { IMAGE_GATHER4_B_O_V5_V5_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 1215
  { IMAGE_GATHER4_B_O_V5_V8_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 1216
  { IMAGE_GATHER4_B_O_V2_V3_nsa_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 1217
  { IMAGE_GATHER4_B_O_V2_V4_nsa_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 1218
  { IMAGE_GATHER4_B_O_V2_V5_nsa_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 1219
  { IMAGE_GATHER4_B_O_V4_V3_nsa_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 1220
  { IMAGE_GATHER4_B_O_V4_V4_nsa_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 1221
  { IMAGE_GATHER4_B_O_V4_V5_nsa_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 1222
  { IMAGE_GATHER4_B_O_V5_V3_nsa_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 1223
  { IMAGE_GATHER4_B_O_V5_V4_nsa_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 1224
  { IMAGE_GATHER4_B_O_V5_V5_nsa_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 1225
  { IMAGE_GATHER4_B_O_V2_V3, IMAGE_GATHER4_B_O, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 1226
  { IMAGE_GATHER4_B_O_V2_V4, IMAGE_GATHER4_B_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 1227
  { IMAGE_GATHER4_B_O_V2_V5, IMAGE_GATHER4_B_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 1228
  { IMAGE_GATHER4_B_O_V2_V8, IMAGE_GATHER4_B_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 1229
  { IMAGE_GATHER4_B_O_V4_V3, IMAGE_GATHER4_B_O, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 1230
  { IMAGE_GATHER4_B_O_V4_V4, IMAGE_GATHER4_B_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 1231
  { IMAGE_GATHER4_B_O_V4_V5, IMAGE_GATHER4_B_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 1232
  { IMAGE_GATHER4_B_O_V4_V8, IMAGE_GATHER4_B_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 1233
  { IMAGE_GATHER4_B_O_V5_V3, IMAGE_GATHER4_B_O, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 1234
  { IMAGE_GATHER4_B_O_V5_V4, IMAGE_GATHER4_B_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 1235
  { IMAGE_GATHER4_B_O_V5_V5, IMAGE_GATHER4_B_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 1236
  { IMAGE_GATHER4_B_O_V5_V8, IMAGE_GATHER4_B_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 1237
  { IMAGE_GATHER4_C_V2_V2_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 1238
  { IMAGE_GATHER4_C_V2_V3_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 1239
  { IMAGE_GATHER4_C_V2_V4_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 1240
  { IMAGE_GATHER4_C_V4_V2_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 1241
  { IMAGE_GATHER4_C_V4_V3_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 1242
  { IMAGE_GATHER4_C_V4_V4_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 1243
  { IMAGE_GATHER4_C_V5_V2_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 1244
  { IMAGE_GATHER4_C_V5_V3_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 1245
  { IMAGE_GATHER4_C_V5_V4_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 1246
  { IMAGE_GATHER4_C_V2_V2_nsa_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 1247
  { IMAGE_GATHER4_C_V2_V3_nsa_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 1248
  { IMAGE_GATHER4_C_V2_V4_nsa_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 1249
  { IMAGE_GATHER4_C_V4_V2_nsa_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 1250
  { IMAGE_GATHER4_C_V4_V3_nsa_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 1251
  { IMAGE_GATHER4_C_V4_V4_nsa_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 1252
  { IMAGE_GATHER4_C_V5_V2_nsa_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 1253
  { IMAGE_GATHER4_C_V5_V3_nsa_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 1254
  { IMAGE_GATHER4_C_V5_V4_nsa_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 1255
  { IMAGE_GATHER4_C_V2_V2_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 1256
  { IMAGE_GATHER4_C_V2_V3_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 1257
  { IMAGE_GATHER4_C_V2_V4_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 1258
  { IMAGE_GATHER4_C_V4_V2_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 1259
  { IMAGE_GATHER4_C_V4_V3_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 1260
  { IMAGE_GATHER4_C_V4_V4_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 1261
  { IMAGE_GATHER4_C_V5_V2_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 1262
  { IMAGE_GATHER4_C_V5_V3_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 1263
  { IMAGE_GATHER4_C_V5_V4_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 1264
  { IMAGE_GATHER4_C_V2_V2_nsa_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 1265
  { IMAGE_GATHER4_C_V2_V3_nsa_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 1266
  { IMAGE_GATHER4_C_V2_V4_nsa_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 1267
  { IMAGE_GATHER4_C_V4_V2_nsa_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 1268
  { IMAGE_GATHER4_C_V4_V3_nsa_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 1269
  { IMAGE_GATHER4_C_V4_V4_nsa_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 1270
  { IMAGE_GATHER4_C_V5_V2_nsa_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 1271
  { IMAGE_GATHER4_C_V5_V3_nsa_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 1272
  { IMAGE_GATHER4_C_V5_V4_nsa_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 1273
  { IMAGE_GATHER4_C_V2_V2_gfx12, IMAGE_GATHER4_C, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 1274
  { IMAGE_GATHER4_C_V2_V3_gfx12, IMAGE_GATHER4_C, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 1275
  { IMAGE_GATHER4_C_V2_V4_gfx12, IMAGE_GATHER4_C, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 1276
  { IMAGE_GATHER4_C_V4_V2_gfx12, IMAGE_GATHER4_C, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 1277
  { IMAGE_GATHER4_C_V4_V3_gfx12, IMAGE_GATHER4_C, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 1278
  { IMAGE_GATHER4_C_V4_V4_gfx12, IMAGE_GATHER4_C, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 1279
  { IMAGE_GATHER4_C_V5_V2_gfx12, IMAGE_GATHER4_C, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 1280
  { IMAGE_GATHER4_C_V5_V3_gfx12, IMAGE_GATHER4_C, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 1281
  { IMAGE_GATHER4_C_V5_V4_gfx12, IMAGE_GATHER4_C, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 1282
  { IMAGE_GATHER4_C_V2_V2, IMAGE_GATHER4_C, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 1283
  { IMAGE_GATHER4_C_V2_V3, IMAGE_GATHER4_C, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 1284
  { IMAGE_GATHER4_C_V2_V4, IMAGE_GATHER4_C, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 1285
  { IMAGE_GATHER4_C_V4_V2, IMAGE_GATHER4_C, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 1286
  { IMAGE_GATHER4_C_V4_V3, IMAGE_GATHER4_C, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 1287
  { IMAGE_GATHER4_C_V4_V4, IMAGE_GATHER4_C, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 1288
  { IMAGE_GATHER4_C_V5_V2, IMAGE_GATHER4_C, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 1289
  { IMAGE_GATHER4_C_V5_V3, IMAGE_GATHER4_C, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 1290
  { IMAGE_GATHER4_C_V5_V4, IMAGE_GATHER4_C, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 1291
  { IMAGE_GATHER4_CL_V2_V1_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 1292
  { IMAGE_GATHER4_CL_V2_V2_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 1293
  { IMAGE_GATHER4_CL_V2_V3_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 1294
  { IMAGE_GATHER4_CL_V2_V4_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 1295
  { IMAGE_GATHER4_CL_V4_V1_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 1296
  { IMAGE_GATHER4_CL_V4_V2_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 1297
  { IMAGE_GATHER4_CL_V4_V3_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 1298
  { IMAGE_GATHER4_CL_V4_V4_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 1299
  { IMAGE_GATHER4_CL_V5_V1_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10Default, 0x5, 0x1, 0x1 }, // 1300
  { IMAGE_GATHER4_CL_V5_V2_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 1301
  { IMAGE_GATHER4_CL_V5_V3_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 1302
  { IMAGE_GATHER4_CL_V5_V4_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 1303
  { IMAGE_GATHER4_CL_V2_V2_nsa_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 1304
  { IMAGE_GATHER4_CL_V2_V3_nsa_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 1305
  { IMAGE_GATHER4_CL_V2_V4_nsa_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 1306
  { IMAGE_GATHER4_CL_V4_V2_nsa_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 1307
  { IMAGE_GATHER4_CL_V4_V3_nsa_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 1308
  { IMAGE_GATHER4_CL_V4_V4_nsa_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 1309
  { IMAGE_GATHER4_CL_V5_V2_nsa_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 1310
  { IMAGE_GATHER4_CL_V5_V3_nsa_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 1311
  { IMAGE_GATHER4_CL_V5_V4_nsa_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 1312
  { IMAGE_GATHER4_CL_V2_V1_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 1313
  { IMAGE_GATHER4_CL_V2_V2_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 1314
  { IMAGE_GATHER4_CL_V2_V3_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 1315
  { IMAGE_GATHER4_CL_V2_V4_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 1316
  { IMAGE_GATHER4_CL_V4_V1_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 1317
  { IMAGE_GATHER4_CL_V4_V2_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 1318
  { IMAGE_GATHER4_CL_V4_V3_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 1319
  { IMAGE_GATHER4_CL_V4_V4_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 1320
  { IMAGE_GATHER4_CL_V5_V1_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11Default, 0x5, 0x1, 0x1 }, // 1321
  { IMAGE_GATHER4_CL_V5_V2_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 1322
  { IMAGE_GATHER4_CL_V5_V3_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 1323
  { IMAGE_GATHER4_CL_V5_V4_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 1324
  { IMAGE_GATHER4_CL_V2_V2_nsa_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 1325
  { IMAGE_GATHER4_CL_V2_V3_nsa_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 1326
  { IMAGE_GATHER4_CL_V2_V4_nsa_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 1327
  { IMAGE_GATHER4_CL_V4_V2_nsa_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 1328
  { IMAGE_GATHER4_CL_V4_V3_nsa_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 1329
  { IMAGE_GATHER4_CL_V4_V4_nsa_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 1330
  { IMAGE_GATHER4_CL_V5_V2_nsa_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 1331
  { IMAGE_GATHER4_CL_V5_V3_nsa_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 1332
  { IMAGE_GATHER4_CL_V5_V4_nsa_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 1333
  { IMAGE_GATHER4_CL_V2_V1_gfx12, IMAGE_GATHER4_CL, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 1334
  { IMAGE_GATHER4_CL_V2_V2_gfx12, IMAGE_GATHER4_CL, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 1335
  { IMAGE_GATHER4_CL_V2_V3_gfx12, IMAGE_GATHER4_CL, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 1336
  { IMAGE_GATHER4_CL_V2_V4_gfx12, IMAGE_GATHER4_CL, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 1337
  { IMAGE_GATHER4_CL_V4_V1_gfx12, IMAGE_GATHER4_CL, MIMGEncGfx12, 0x4, 0x1, 0x1 }, // 1338
  { IMAGE_GATHER4_CL_V4_V2_gfx12, IMAGE_GATHER4_CL, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 1339
  { IMAGE_GATHER4_CL_V4_V3_gfx12, IMAGE_GATHER4_CL, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 1340
  { IMAGE_GATHER4_CL_V4_V4_gfx12, IMAGE_GATHER4_CL, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 1341
  { IMAGE_GATHER4_CL_V5_V1_gfx12, IMAGE_GATHER4_CL, MIMGEncGfx12, 0x5, 0x1, 0x1 }, // 1342
  { IMAGE_GATHER4_CL_V5_V2_gfx12, IMAGE_GATHER4_CL, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 1343
  { IMAGE_GATHER4_CL_V5_V3_gfx12, IMAGE_GATHER4_CL, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 1344
  { IMAGE_GATHER4_CL_V5_V4_gfx12, IMAGE_GATHER4_CL, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 1345
  { IMAGE_GATHER4_CL_V2_V1, IMAGE_GATHER4_CL, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 1346
  { IMAGE_GATHER4_CL_V2_V2, IMAGE_GATHER4_CL, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 1347
  { IMAGE_GATHER4_CL_V2_V3, IMAGE_GATHER4_CL, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 1348
  { IMAGE_GATHER4_CL_V2_V4, IMAGE_GATHER4_CL, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 1349
  { IMAGE_GATHER4_CL_V4_V1, IMAGE_GATHER4_CL, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 1350
  { IMAGE_GATHER4_CL_V4_V2, IMAGE_GATHER4_CL, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 1351
  { IMAGE_GATHER4_CL_V4_V3, IMAGE_GATHER4_CL, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 1352
  { IMAGE_GATHER4_CL_V4_V4, IMAGE_GATHER4_CL, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 1353
  { IMAGE_GATHER4_CL_V5_V1, IMAGE_GATHER4_CL, MIMGEncGfx6, 0x5, 0x1, 0x1 }, // 1354
  { IMAGE_GATHER4_CL_V5_V2, IMAGE_GATHER4_CL, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 1355
  { IMAGE_GATHER4_CL_V5_V3, IMAGE_GATHER4_CL, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 1356
  { IMAGE_GATHER4_CL_V5_V4, IMAGE_GATHER4_CL, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 1357
  { IMAGE_GATHER4_CL_O_V2_V2_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 1358
  { IMAGE_GATHER4_CL_O_V2_V3_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 1359
  { IMAGE_GATHER4_CL_O_V2_V4_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 1360
  { IMAGE_GATHER4_CL_O_V2_V5_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 1361
  { IMAGE_GATHER4_CL_O_V2_V8_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 1362
  { IMAGE_GATHER4_CL_O_V4_V2_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 1363
  { IMAGE_GATHER4_CL_O_V4_V3_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 1364
  { IMAGE_GATHER4_CL_O_V4_V4_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 1365
  { IMAGE_GATHER4_CL_O_V4_V5_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 1366
  { IMAGE_GATHER4_CL_O_V4_V8_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 1367
  { IMAGE_GATHER4_CL_O_V5_V2_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 1368
  { IMAGE_GATHER4_CL_O_V5_V3_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 1369
  { IMAGE_GATHER4_CL_O_V5_V4_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 1370
  { IMAGE_GATHER4_CL_O_V5_V5_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 1371
  { IMAGE_GATHER4_CL_O_V5_V8_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 1372
  { IMAGE_GATHER4_CL_O_V2_V2_nsa_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 1373
  { IMAGE_GATHER4_CL_O_V2_V3_nsa_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 1374
  { IMAGE_GATHER4_CL_O_V2_V4_nsa_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 1375
  { IMAGE_GATHER4_CL_O_V2_V5_nsa_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 1376
  { IMAGE_GATHER4_CL_O_V4_V2_nsa_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 1377
  { IMAGE_GATHER4_CL_O_V4_V3_nsa_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 1378
  { IMAGE_GATHER4_CL_O_V4_V4_nsa_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 1379
  { IMAGE_GATHER4_CL_O_V4_V5_nsa_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 1380
  { IMAGE_GATHER4_CL_O_V5_V2_nsa_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 1381
  { IMAGE_GATHER4_CL_O_V5_V3_nsa_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 1382
  { IMAGE_GATHER4_CL_O_V5_V4_nsa_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 1383
  { IMAGE_GATHER4_CL_O_V5_V5_nsa_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 1384
  { IMAGE_GATHER4_CL_O_V2_V2, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 1385
  { IMAGE_GATHER4_CL_O_V2_V3, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 1386
  { IMAGE_GATHER4_CL_O_V2_V4, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 1387
  { IMAGE_GATHER4_CL_O_V2_V5, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 1388
  { IMAGE_GATHER4_CL_O_V2_V8, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 1389
  { IMAGE_GATHER4_CL_O_V4_V2, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 1390
  { IMAGE_GATHER4_CL_O_V4_V3, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 1391
  { IMAGE_GATHER4_CL_O_V4_V4, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 1392
  { IMAGE_GATHER4_CL_O_V4_V5, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 1393
  { IMAGE_GATHER4_CL_O_V4_V8, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 1394
  { IMAGE_GATHER4_CL_O_V5_V2, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 1395
  { IMAGE_GATHER4_CL_O_V5_V3, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 1396
  { IMAGE_GATHER4_CL_O_V5_V4, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 1397
  { IMAGE_GATHER4_CL_O_V5_V5, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 1398
  { IMAGE_GATHER4_CL_O_V5_V8, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 1399
  { IMAGE_GATHER4_C_B_V2_V3_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 1400
  { IMAGE_GATHER4_C_B_V2_V4_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 1401
  { IMAGE_GATHER4_C_B_V2_V5_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 1402
  { IMAGE_GATHER4_C_B_V2_V8_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 1403
  { IMAGE_GATHER4_C_B_V4_V3_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 1404
  { IMAGE_GATHER4_C_B_V4_V4_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 1405
  { IMAGE_GATHER4_C_B_V4_V5_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 1406
  { IMAGE_GATHER4_C_B_V4_V8_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 1407
  { IMAGE_GATHER4_C_B_V5_V3_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 1408
  { IMAGE_GATHER4_C_B_V5_V4_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 1409
  { IMAGE_GATHER4_C_B_V5_V5_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 1410
  { IMAGE_GATHER4_C_B_V5_V8_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 1411
  { IMAGE_GATHER4_C_B_V2_V3_nsa_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 1412
  { IMAGE_GATHER4_C_B_V2_V4_nsa_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 1413
  { IMAGE_GATHER4_C_B_V2_V5_nsa_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 1414
  { IMAGE_GATHER4_C_B_V4_V3_nsa_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 1415
  { IMAGE_GATHER4_C_B_V4_V4_nsa_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 1416
  { IMAGE_GATHER4_C_B_V4_V5_nsa_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 1417
  { IMAGE_GATHER4_C_B_V5_V3_nsa_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 1418
  { IMAGE_GATHER4_C_B_V5_V4_nsa_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 1419
  { IMAGE_GATHER4_C_B_V5_V5_nsa_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 1420
  { IMAGE_GATHER4_C_B_V2_V3_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 1421
  { IMAGE_GATHER4_C_B_V2_V4_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 1422
  { IMAGE_GATHER4_C_B_V2_V5_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 1423
  { IMAGE_GATHER4_C_B_V2_V8_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 1424
  { IMAGE_GATHER4_C_B_V4_V3_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 1425
  { IMAGE_GATHER4_C_B_V4_V4_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 1426
  { IMAGE_GATHER4_C_B_V4_V5_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 1427
  { IMAGE_GATHER4_C_B_V4_V8_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 1428
  { IMAGE_GATHER4_C_B_V5_V3_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 1429
  { IMAGE_GATHER4_C_B_V5_V4_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 1430
  { IMAGE_GATHER4_C_B_V5_V5_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 1431
  { IMAGE_GATHER4_C_B_V5_V8_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 1432
  { IMAGE_GATHER4_C_B_V2_V3_nsa_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 1433
  { IMAGE_GATHER4_C_B_V2_V4_nsa_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 1434
  { IMAGE_GATHER4_C_B_V2_V5_nsa_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 1435
  { IMAGE_GATHER4_C_B_V4_V3_nsa_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 1436
  { IMAGE_GATHER4_C_B_V4_V4_nsa_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 1437
  { IMAGE_GATHER4_C_B_V4_V5_nsa_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 1438
  { IMAGE_GATHER4_C_B_V5_V3_nsa_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 1439
  { IMAGE_GATHER4_C_B_V5_V4_nsa_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 1440
  { IMAGE_GATHER4_C_B_V5_V5_nsa_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 1441
  { IMAGE_GATHER4_C_B_V2_V3_gfx12, IMAGE_GATHER4_C_B, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 1442
  { IMAGE_GATHER4_C_B_V2_V4_gfx12, IMAGE_GATHER4_C_B, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 1443
  { IMAGE_GATHER4_C_B_V2_V5_gfx12, IMAGE_GATHER4_C_B, MIMGEncGfx12, 0x2, 0x5, 0x5 }, // 1444
  { IMAGE_GATHER4_C_B_V4_V3_gfx12, IMAGE_GATHER4_C_B, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 1445
  { IMAGE_GATHER4_C_B_V4_V4_gfx12, IMAGE_GATHER4_C_B, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 1446
  { IMAGE_GATHER4_C_B_V4_V5_gfx12, IMAGE_GATHER4_C_B, MIMGEncGfx12, 0x4, 0x5, 0x5 }, // 1447
  { IMAGE_GATHER4_C_B_V5_V3_gfx12, IMAGE_GATHER4_C_B, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 1448
  { IMAGE_GATHER4_C_B_V5_V4_gfx12, IMAGE_GATHER4_C_B, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 1449
  { IMAGE_GATHER4_C_B_V5_V5_gfx12, IMAGE_GATHER4_C_B, MIMGEncGfx12, 0x5, 0x5, 0x5 }, // 1450
  { IMAGE_GATHER4_C_B_V2_V3, IMAGE_GATHER4_C_B, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 1451
  { IMAGE_GATHER4_C_B_V2_V4, IMAGE_GATHER4_C_B, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 1452
  { IMAGE_GATHER4_C_B_V2_V5, IMAGE_GATHER4_C_B, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 1453
  { IMAGE_GATHER4_C_B_V2_V8, IMAGE_GATHER4_C_B, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 1454
  { IMAGE_GATHER4_C_B_V4_V3, IMAGE_GATHER4_C_B, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 1455
  { IMAGE_GATHER4_C_B_V4_V4, IMAGE_GATHER4_C_B, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 1456
  { IMAGE_GATHER4_C_B_V4_V5, IMAGE_GATHER4_C_B, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 1457
  { IMAGE_GATHER4_C_B_V4_V8, IMAGE_GATHER4_C_B, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 1458
  { IMAGE_GATHER4_C_B_V5_V3, IMAGE_GATHER4_C_B, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 1459
  { IMAGE_GATHER4_C_B_V5_V4, IMAGE_GATHER4_C_B, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 1460
  { IMAGE_GATHER4_C_B_V5_V5, IMAGE_GATHER4_C_B, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 1461
  { IMAGE_GATHER4_C_B_V5_V8, IMAGE_GATHER4_C_B, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 1462
  { IMAGE_GATHER4_C_B_CL_V2_V3_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 1463
  { IMAGE_GATHER4_C_B_CL_V2_V4_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 1464
  { IMAGE_GATHER4_C_B_CL_V2_V5_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 1465
  { IMAGE_GATHER4_C_B_CL_V2_V6_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 1466
  { IMAGE_GATHER4_C_B_CL_V2_V8_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 1467
  { IMAGE_GATHER4_C_B_CL_V4_V3_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 1468
  { IMAGE_GATHER4_C_B_CL_V4_V4_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 1469
  { IMAGE_GATHER4_C_B_CL_V4_V5_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 1470
  { IMAGE_GATHER4_C_B_CL_V4_V6_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 1471
  { IMAGE_GATHER4_C_B_CL_V4_V8_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 1472
  { IMAGE_GATHER4_C_B_CL_V5_V3_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 1473
  { IMAGE_GATHER4_C_B_CL_V5_V4_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 1474
  { IMAGE_GATHER4_C_B_CL_V5_V5_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 1475
  { IMAGE_GATHER4_C_B_CL_V5_V6_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 1476
  { IMAGE_GATHER4_C_B_CL_V5_V8_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 1477
  { IMAGE_GATHER4_C_B_CL_V2_V3_nsa_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 1478
  { IMAGE_GATHER4_C_B_CL_V2_V4_nsa_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 1479
  { IMAGE_GATHER4_C_B_CL_V2_V5_nsa_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 1480
  { IMAGE_GATHER4_C_B_CL_V2_V6_nsa_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 1481
  { IMAGE_GATHER4_C_B_CL_V4_V3_nsa_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 1482
  { IMAGE_GATHER4_C_B_CL_V4_V4_nsa_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 1483
  { IMAGE_GATHER4_C_B_CL_V4_V5_nsa_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 1484
  { IMAGE_GATHER4_C_B_CL_V4_V6_nsa_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 1485
  { IMAGE_GATHER4_C_B_CL_V5_V3_nsa_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 1486
  { IMAGE_GATHER4_C_B_CL_V5_V4_nsa_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 1487
  { IMAGE_GATHER4_C_B_CL_V5_V5_nsa_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 1488
  { IMAGE_GATHER4_C_B_CL_V5_V6_nsa_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 1489
  { IMAGE_GATHER4_C_B_CL_V2_V3_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 1490
  { IMAGE_GATHER4_C_B_CL_V2_V4_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 1491
  { IMAGE_GATHER4_C_B_CL_V2_V5_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 1492
  { IMAGE_GATHER4_C_B_CL_V2_V6_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11Default, 0x2, 0x6, 0x1 }, // 1493
  { IMAGE_GATHER4_C_B_CL_V2_V8_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 1494
  { IMAGE_GATHER4_C_B_CL_V4_V3_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 1495
  { IMAGE_GATHER4_C_B_CL_V4_V4_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 1496
  { IMAGE_GATHER4_C_B_CL_V4_V5_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 1497
  { IMAGE_GATHER4_C_B_CL_V4_V6_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11Default, 0x4, 0x6, 0x1 }, // 1498
  { IMAGE_GATHER4_C_B_CL_V4_V8_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 1499
  { IMAGE_GATHER4_C_B_CL_V5_V3_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 1500
  { IMAGE_GATHER4_C_B_CL_V5_V4_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 1501
  { IMAGE_GATHER4_C_B_CL_V5_V5_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 1502
  { IMAGE_GATHER4_C_B_CL_V5_V6_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11Default, 0x5, 0x6, 0x1 }, // 1503
  { IMAGE_GATHER4_C_B_CL_V5_V8_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 1504
  { IMAGE_GATHER4_C_B_CL_V2_V3_nsa_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 1505
  { IMAGE_GATHER4_C_B_CL_V2_V4_nsa_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 1506
  { IMAGE_GATHER4_C_B_CL_V2_V5_nsa_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 1507
  { IMAGE_GATHER4_C_B_CL_V2_V6_nsa_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11NSA, 0x2, 0x6, 0x6 }, // 1508
  { IMAGE_GATHER4_C_B_CL_V4_V3_nsa_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 1509
  { IMAGE_GATHER4_C_B_CL_V4_V4_nsa_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 1510
  { IMAGE_GATHER4_C_B_CL_V4_V5_nsa_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 1511
  { IMAGE_GATHER4_C_B_CL_V4_V6_nsa_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11NSA, 0x4, 0x6, 0x6 }, // 1512
  { IMAGE_GATHER4_C_B_CL_V5_V3_nsa_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 1513
  { IMAGE_GATHER4_C_B_CL_V5_V4_nsa_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 1514
  { IMAGE_GATHER4_C_B_CL_V5_V5_nsa_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 1515
  { IMAGE_GATHER4_C_B_CL_V5_V6_nsa_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11NSA, 0x5, 0x6, 0x6 }, // 1516
  { IMAGE_GATHER4_C_B_CL_V2_V3_gfx12, IMAGE_GATHER4_C_B_CL, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 1517
  { IMAGE_GATHER4_C_B_CL_V2_V4_gfx12, IMAGE_GATHER4_C_B_CL, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 1518
  { IMAGE_GATHER4_C_B_CL_V2_V5_gfx12, IMAGE_GATHER4_C_B_CL, MIMGEncGfx12, 0x2, 0x5, 0x5 }, // 1519
  { IMAGE_GATHER4_C_B_CL_V2_V6_gfx12, IMAGE_GATHER4_C_B_CL, MIMGEncGfx12, 0x2, 0x6, 0x6 }, // 1520
  { IMAGE_GATHER4_C_B_CL_V4_V3_gfx12, IMAGE_GATHER4_C_B_CL, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 1521
  { IMAGE_GATHER4_C_B_CL_V4_V4_gfx12, IMAGE_GATHER4_C_B_CL, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 1522
  { IMAGE_GATHER4_C_B_CL_V4_V5_gfx12, IMAGE_GATHER4_C_B_CL, MIMGEncGfx12, 0x4, 0x5, 0x5 }, // 1523
  { IMAGE_GATHER4_C_B_CL_V4_V6_gfx12, IMAGE_GATHER4_C_B_CL, MIMGEncGfx12, 0x4, 0x6, 0x6 }, // 1524
  { IMAGE_GATHER4_C_B_CL_V5_V3_gfx12, IMAGE_GATHER4_C_B_CL, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 1525
  { IMAGE_GATHER4_C_B_CL_V5_V4_gfx12, IMAGE_GATHER4_C_B_CL, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 1526
  { IMAGE_GATHER4_C_B_CL_V5_V5_gfx12, IMAGE_GATHER4_C_B_CL, MIMGEncGfx12, 0x5, 0x5, 0x5 }, // 1527
  { IMAGE_GATHER4_C_B_CL_V5_V6_gfx12, IMAGE_GATHER4_C_B_CL, MIMGEncGfx12, 0x5, 0x6, 0x6 }, // 1528
  { IMAGE_GATHER4_C_B_CL_V2_V3, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 1529
  { IMAGE_GATHER4_C_B_CL_V2_V4, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 1530
  { IMAGE_GATHER4_C_B_CL_V2_V5, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 1531
  { IMAGE_GATHER4_C_B_CL_V2_V6, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 1532
  { IMAGE_GATHER4_C_B_CL_V2_V8, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 1533
  { IMAGE_GATHER4_C_B_CL_V4_V3, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 1534
  { IMAGE_GATHER4_C_B_CL_V4_V4, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 1535
  { IMAGE_GATHER4_C_B_CL_V4_V5, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 1536
  { IMAGE_GATHER4_C_B_CL_V4_V6, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 1537
  { IMAGE_GATHER4_C_B_CL_V4_V8, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 1538
  { IMAGE_GATHER4_C_B_CL_V5_V3, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 1539
  { IMAGE_GATHER4_C_B_CL_V5_V4, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 1540
  { IMAGE_GATHER4_C_B_CL_V5_V5, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 1541
  { IMAGE_GATHER4_C_B_CL_V5_V6, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 1542
  { IMAGE_GATHER4_C_B_CL_V5_V8, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 1543
  { IMAGE_GATHER4_C_B_CL_O_V2_V4_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 1544
  { IMAGE_GATHER4_C_B_CL_O_V2_V5_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 1545
  { IMAGE_GATHER4_C_B_CL_O_V2_V6_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 1546
  { IMAGE_GATHER4_C_B_CL_O_V2_V7_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x2, 0x7, 0x1 }, // 1547
  { IMAGE_GATHER4_C_B_CL_O_V2_V8_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 1548
  { IMAGE_GATHER4_C_B_CL_O_V4_V4_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 1549
  { IMAGE_GATHER4_C_B_CL_O_V4_V5_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 1550
  { IMAGE_GATHER4_C_B_CL_O_V4_V6_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 1551
  { IMAGE_GATHER4_C_B_CL_O_V4_V7_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x4, 0x7, 0x1 }, // 1552
  { IMAGE_GATHER4_C_B_CL_O_V4_V8_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 1553
  { IMAGE_GATHER4_C_B_CL_O_V5_V4_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 1554
  { IMAGE_GATHER4_C_B_CL_O_V5_V5_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 1555
  { IMAGE_GATHER4_C_B_CL_O_V5_V6_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 1556
  { IMAGE_GATHER4_C_B_CL_O_V5_V7_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x5, 0x7, 0x1 }, // 1557
  { IMAGE_GATHER4_C_B_CL_O_V5_V8_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 1558
  { IMAGE_GATHER4_C_B_CL_O_V2_V4_nsa_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 1559
  { IMAGE_GATHER4_C_B_CL_O_V2_V5_nsa_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 1560
  { IMAGE_GATHER4_C_B_CL_O_V2_V6_nsa_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 1561
  { IMAGE_GATHER4_C_B_CL_O_V2_V7_nsa_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x7, 0x7 }, // 1562
  { IMAGE_GATHER4_C_B_CL_O_V4_V4_nsa_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 1563
  { IMAGE_GATHER4_C_B_CL_O_V4_V5_nsa_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 1564
  { IMAGE_GATHER4_C_B_CL_O_V4_V6_nsa_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 1565
  { IMAGE_GATHER4_C_B_CL_O_V4_V7_nsa_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x7, 0x7 }, // 1566
  { IMAGE_GATHER4_C_B_CL_O_V5_V4_nsa_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 1567
  { IMAGE_GATHER4_C_B_CL_O_V5_V5_nsa_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 1568
  { IMAGE_GATHER4_C_B_CL_O_V5_V6_nsa_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 1569
  { IMAGE_GATHER4_C_B_CL_O_V5_V7_nsa_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x7, 0x7 }, // 1570
  { IMAGE_GATHER4_C_B_CL_O_V2_V4, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 1571
  { IMAGE_GATHER4_C_B_CL_O_V2_V5, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 1572
  { IMAGE_GATHER4_C_B_CL_O_V2_V6, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 1573
  { IMAGE_GATHER4_C_B_CL_O_V2_V7, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x2, 0x7, 0x1 }, // 1574
  { IMAGE_GATHER4_C_B_CL_O_V2_V8, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 1575
  { IMAGE_GATHER4_C_B_CL_O_V4_V4, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 1576
  { IMAGE_GATHER4_C_B_CL_O_V4_V5, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 1577
  { IMAGE_GATHER4_C_B_CL_O_V4_V6, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 1578
  { IMAGE_GATHER4_C_B_CL_O_V4_V7, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x4, 0x7, 0x1 }, // 1579
  { IMAGE_GATHER4_C_B_CL_O_V4_V8, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 1580
  { IMAGE_GATHER4_C_B_CL_O_V5_V4, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 1581
  { IMAGE_GATHER4_C_B_CL_O_V5_V5, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 1582
  { IMAGE_GATHER4_C_B_CL_O_V5_V6, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 1583
  { IMAGE_GATHER4_C_B_CL_O_V5_V7, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x5, 0x7, 0x1 }, // 1584
  { IMAGE_GATHER4_C_B_CL_O_V5_V8, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 1585
  { IMAGE_GATHER4_C_B_O_V2_V4_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 1586
  { IMAGE_GATHER4_C_B_O_V2_V5_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 1587
  { IMAGE_GATHER4_C_B_O_V2_V6_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 1588
  { IMAGE_GATHER4_C_B_O_V2_V8_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 1589
  { IMAGE_GATHER4_C_B_O_V4_V4_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 1590
  { IMAGE_GATHER4_C_B_O_V4_V5_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 1591
  { IMAGE_GATHER4_C_B_O_V4_V6_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 1592
  { IMAGE_GATHER4_C_B_O_V4_V8_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 1593
  { IMAGE_GATHER4_C_B_O_V5_V4_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 1594
  { IMAGE_GATHER4_C_B_O_V5_V5_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 1595
  { IMAGE_GATHER4_C_B_O_V5_V6_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 1596
  { IMAGE_GATHER4_C_B_O_V5_V8_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 1597
  { IMAGE_GATHER4_C_B_O_V2_V4_nsa_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 1598
  { IMAGE_GATHER4_C_B_O_V2_V5_nsa_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 1599
  { IMAGE_GATHER4_C_B_O_V2_V6_nsa_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 1600
  { IMAGE_GATHER4_C_B_O_V4_V4_nsa_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 1601
  { IMAGE_GATHER4_C_B_O_V4_V5_nsa_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 1602
  { IMAGE_GATHER4_C_B_O_V4_V6_nsa_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 1603
  { IMAGE_GATHER4_C_B_O_V5_V4_nsa_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 1604
  { IMAGE_GATHER4_C_B_O_V5_V5_nsa_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 1605
  { IMAGE_GATHER4_C_B_O_V5_V6_nsa_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 1606
  { IMAGE_GATHER4_C_B_O_V2_V4, IMAGE_GATHER4_C_B_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 1607
  { IMAGE_GATHER4_C_B_O_V2_V5, IMAGE_GATHER4_C_B_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 1608
  { IMAGE_GATHER4_C_B_O_V2_V6, IMAGE_GATHER4_C_B_O, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 1609
  { IMAGE_GATHER4_C_B_O_V2_V8, IMAGE_GATHER4_C_B_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 1610
  { IMAGE_GATHER4_C_B_O_V4_V4, IMAGE_GATHER4_C_B_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 1611
  { IMAGE_GATHER4_C_B_O_V4_V5, IMAGE_GATHER4_C_B_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 1612
  { IMAGE_GATHER4_C_B_O_V4_V6, IMAGE_GATHER4_C_B_O, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 1613
  { IMAGE_GATHER4_C_B_O_V4_V8, IMAGE_GATHER4_C_B_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 1614
  { IMAGE_GATHER4_C_B_O_V5_V4, IMAGE_GATHER4_C_B_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 1615
  { IMAGE_GATHER4_C_B_O_V5_V5, IMAGE_GATHER4_C_B_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 1616
  { IMAGE_GATHER4_C_B_O_V5_V6, IMAGE_GATHER4_C_B_O, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 1617
  { IMAGE_GATHER4_C_B_O_V5_V8, IMAGE_GATHER4_C_B_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 1618
  { IMAGE_GATHER4_C_CL_V2_V2_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 1619
  { IMAGE_GATHER4_C_CL_V2_V3_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 1620
  { IMAGE_GATHER4_C_CL_V2_V4_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 1621
  { IMAGE_GATHER4_C_CL_V2_V5_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 1622
  { IMAGE_GATHER4_C_CL_V2_V8_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 1623
  { IMAGE_GATHER4_C_CL_V4_V2_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 1624
  { IMAGE_GATHER4_C_CL_V4_V3_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 1625
  { IMAGE_GATHER4_C_CL_V4_V4_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 1626
  { IMAGE_GATHER4_C_CL_V4_V5_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 1627
  { IMAGE_GATHER4_C_CL_V4_V8_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 1628
  { IMAGE_GATHER4_C_CL_V5_V2_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 1629
  { IMAGE_GATHER4_C_CL_V5_V3_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 1630
  { IMAGE_GATHER4_C_CL_V5_V4_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 1631
  { IMAGE_GATHER4_C_CL_V5_V5_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 1632
  { IMAGE_GATHER4_C_CL_V5_V8_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 1633
  { IMAGE_GATHER4_C_CL_V2_V2_nsa_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 1634
  { IMAGE_GATHER4_C_CL_V2_V3_nsa_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 1635
  { IMAGE_GATHER4_C_CL_V2_V4_nsa_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 1636
  { IMAGE_GATHER4_C_CL_V2_V5_nsa_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 1637
  { IMAGE_GATHER4_C_CL_V4_V2_nsa_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 1638
  { IMAGE_GATHER4_C_CL_V4_V3_nsa_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 1639
  { IMAGE_GATHER4_C_CL_V4_V4_nsa_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 1640
  { IMAGE_GATHER4_C_CL_V4_V5_nsa_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 1641
  { IMAGE_GATHER4_C_CL_V5_V2_nsa_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 1642
  { IMAGE_GATHER4_C_CL_V5_V3_nsa_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 1643
  { IMAGE_GATHER4_C_CL_V5_V4_nsa_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 1644
  { IMAGE_GATHER4_C_CL_V5_V5_nsa_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 1645
  { IMAGE_GATHER4_C_CL_V2_V2_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 1646
  { IMAGE_GATHER4_C_CL_V2_V3_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 1647
  { IMAGE_GATHER4_C_CL_V2_V4_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 1648
  { IMAGE_GATHER4_C_CL_V2_V5_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 1649
  { IMAGE_GATHER4_C_CL_V2_V8_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 1650
  { IMAGE_GATHER4_C_CL_V4_V2_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 1651
  { IMAGE_GATHER4_C_CL_V4_V3_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 1652
  { IMAGE_GATHER4_C_CL_V4_V4_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 1653
  { IMAGE_GATHER4_C_CL_V4_V5_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 1654
  { IMAGE_GATHER4_C_CL_V4_V8_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 1655
  { IMAGE_GATHER4_C_CL_V5_V2_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 1656
  { IMAGE_GATHER4_C_CL_V5_V3_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 1657
  { IMAGE_GATHER4_C_CL_V5_V4_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 1658
  { IMAGE_GATHER4_C_CL_V5_V5_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 1659
  { IMAGE_GATHER4_C_CL_V5_V8_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 1660
  { IMAGE_GATHER4_C_CL_V2_V2_nsa_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 1661
  { IMAGE_GATHER4_C_CL_V2_V3_nsa_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 1662
  { IMAGE_GATHER4_C_CL_V2_V4_nsa_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 1663
  { IMAGE_GATHER4_C_CL_V2_V5_nsa_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 1664
  { IMAGE_GATHER4_C_CL_V4_V2_nsa_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 1665
  { IMAGE_GATHER4_C_CL_V4_V3_nsa_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 1666
  { IMAGE_GATHER4_C_CL_V4_V4_nsa_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 1667
  { IMAGE_GATHER4_C_CL_V4_V5_nsa_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 1668
  { IMAGE_GATHER4_C_CL_V5_V2_nsa_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 1669
  { IMAGE_GATHER4_C_CL_V5_V3_nsa_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 1670
  { IMAGE_GATHER4_C_CL_V5_V4_nsa_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 1671
  { IMAGE_GATHER4_C_CL_V5_V5_nsa_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 1672
  { IMAGE_GATHER4_C_CL_V2_V2_gfx12, IMAGE_GATHER4_C_CL, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 1673
  { IMAGE_GATHER4_C_CL_V2_V3_gfx12, IMAGE_GATHER4_C_CL, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 1674
  { IMAGE_GATHER4_C_CL_V2_V4_gfx12, IMAGE_GATHER4_C_CL, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 1675
  { IMAGE_GATHER4_C_CL_V2_V5_gfx12, IMAGE_GATHER4_C_CL, MIMGEncGfx12, 0x2, 0x5, 0x5 }, // 1676
  { IMAGE_GATHER4_C_CL_V4_V2_gfx12, IMAGE_GATHER4_C_CL, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 1677
  { IMAGE_GATHER4_C_CL_V4_V3_gfx12, IMAGE_GATHER4_C_CL, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 1678
  { IMAGE_GATHER4_C_CL_V4_V4_gfx12, IMAGE_GATHER4_C_CL, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 1679
  { IMAGE_GATHER4_C_CL_V4_V5_gfx12, IMAGE_GATHER4_C_CL, MIMGEncGfx12, 0x4, 0x5, 0x5 }, // 1680
  { IMAGE_GATHER4_C_CL_V5_V2_gfx12, IMAGE_GATHER4_C_CL, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 1681
  { IMAGE_GATHER4_C_CL_V5_V3_gfx12, IMAGE_GATHER4_C_CL, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 1682
  { IMAGE_GATHER4_C_CL_V5_V4_gfx12, IMAGE_GATHER4_C_CL, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 1683
  { IMAGE_GATHER4_C_CL_V5_V5_gfx12, IMAGE_GATHER4_C_CL, MIMGEncGfx12, 0x5, 0x5, 0x5 }, // 1684
  { IMAGE_GATHER4_C_CL_V2_V2, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 1685
  { IMAGE_GATHER4_C_CL_V2_V3, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 1686
  { IMAGE_GATHER4_C_CL_V2_V4, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 1687
  { IMAGE_GATHER4_C_CL_V2_V5, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 1688
  { IMAGE_GATHER4_C_CL_V2_V8, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 1689
  { IMAGE_GATHER4_C_CL_V4_V2, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 1690
  { IMAGE_GATHER4_C_CL_V4_V3, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 1691
  { IMAGE_GATHER4_C_CL_V4_V4, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 1692
  { IMAGE_GATHER4_C_CL_V4_V5, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 1693
  { IMAGE_GATHER4_C_CL_V4_V8, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 1694
  { IMAGE_GATHER4_C_CL_V5_V2, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 1695
  { IMAGE_GATHER4_C_CL_V5_V3, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 1696
  { IMAGE_GATHER4_C_CL_V5_V4, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 1697
  { IMAGE_GATHER4_C_CL_V5_V5, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 1698
  { IMAGE_GATHER4_C_CL_V5_V8, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 1699
  { IMAGE_GATHER4_C_CL_O_V2_V3_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 1700
  { IMAGE_GATHER4_C_CL_O_V2_V4_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 1701
  { IMAGE_GATHER4_C_CL_O_V2_V5_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 1702
  { IMAGE_GATHER4_C_CL_O_V2_V6_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 1703
  { IMAGE_GATHER4_C_CL_O_V2_V8_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 1704
  { IMAGE_GATHER4_C_CL_O_V4_V3_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 1705
  { IMAGE_GATHER4_C_CL_O_V4_V4_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 1706
  { IMAGE_GATHER4_C_CL_O_V4_V5_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 1707
  { IMAGE_GATHER4_C_CL_O_V4_V6_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 1708
  { IMAGE_GATHER4_C_CL_O_V4_V8_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 1709
  { IMAGE_GATHER4_C_CL_O_V5_V3_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 1710
  { IMAGE_GATHER4_C_CL_O_V5_V4_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 1711
  { IMAGE_GATHER4_C_CL_O_V5_V5_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 1712
  { IMAGE_GATHER4_C_CL_O_V5_V6_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 1713
  { IMAGE_GATHER4_C_CL_O_V5_V8_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 1714
  { IMAGE_GATHER4_C_CL_O_V2_V3_nsa_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 1715
  { IMAGE_GATHER4_C_CL_O_V2_V4_nsa_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 1716
  { IMAGE_GATHER4_C_CL_O_V2_V5_nsa_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 1717
  { IMAGE_GATHER4_C_CL_O_V2_V6_nsa_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 1718
  { IMAGE_GATHER4_C_CL_O_V4_V3_nsa_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 1719
  { IMAGE_GATHER4_C_CL_O_V4_V4_nsa_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 1720
  { IMAGE_GATHER4_C_CL_O_V4_V5_nsa_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 1721
  { IMAGE_GATHER4_C_CL_O_V4_V6_nsa_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 1722
  { IMAGE_GATHER4_C_CL_O_V5_V3_nsa_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 1723
  { IMAGE_GATHER4_C_CL_O_V5_V4_nsa_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 1724
  { IMAGE_GATHER4_C_CL_O_V5_V5_nsa_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 1725
  { IMAGE_GATHER4_C_CL_O_V5_V6_nsa_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 1726
  { IMAGE_GATHER4_C_CL_O_V2_V3, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 1727
  { IMAGE_GATHER4_C_CL_O_V2_V4, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 1728
  { IMAGE_GATHER4_C_CL_O_V2_V5, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 1729
  { IMAGE_GATHER4_C_CL_O_V2_V6, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 1730
  { IMAGE_GATHER4_C_CL_O_V2_V8, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 1731
  { IMAGE_GATHER4_C_CL_O_V4_V3, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 1732
  { IMAGE_GATHER4_C_CL_O_V4_V4, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 1733
  { IMAGE_GATHER4_C_CL_O_V4_V5, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 1734
  { IMAGE_GATHER4_C_CL_O_V4_V6, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 1735
  { IMAGE_GATHER4_C_CL_O_V4_V8, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 1736
  { IMAGE_GATHER4_C_CL_O_V5_V3, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 1737
  { IMAGE_GATHER4_C_CL_O_V5_V4, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 1738
  { IMAGE_GATHER4_C_CL_O_V5_V5, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 1739
  { IMAGE_GATHER4_C_CL_O_V5_V6, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 1740
  { IMAGE_GATHER4_C_CL_O_V5_V8, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 1741
  { IMAGE_GATHER4_C_L_V2_V2_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 1742
  { IMAGE_GATHER4_C_L_V2_V3_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 1743
  { IMAGE_GATHER4_C_L_V2_V4_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 1744
  { IMAGE_GATHER4_C_L_V2_V5_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 1745
  { IMAGE_GATHER4_C_L_V2_V8_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 1746
  { IMAGE_GATHER4_C_L_V4_V2_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 1747
  { IMAGE_GATHER4_C_L_V4_V3_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 1748
  { IMAGE_GATHER4_C_L_V4_V4_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 1749
  { IMAGE_GATHER4_C_L_V4_V5_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 1750
  { IMAGE_GATHER4_C_L_V4_V8_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 1751
  { IMAGE_GATHER4_C_L_V5_V2_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 1752
  { IMAGE_GATHER4_C_L_V5_V3_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 1753
  { IMAGE_GATHER4_C_L_V5_V4_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 1754
  { IMAGE_GATHER4_C_L_V5_V5_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 1755
  { IMAGE_GATHER4_C_L_V5_V8_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 1756
  { IMAGE_GATHER4_C_L_V2_V2_nsa_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 1757
  { IMAGE_GATHER4_C_L_V2_V3_nsa_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 1758
  { IMAGE_GATHER4_C_L_V2_V4_nsa_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 1759
  { IMAGE_GATHER4_C_L_V2_V5_nsa_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 1760
  { IMAGE_GATHER4_C_L_V4_V2_nsa_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 1761
  { IMAGE_GATHER4_C_L_V4_V3_nsa_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 1762
  { IMAGE_GATHER4_C_L_V4_V4_nsa_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 1763
  { IMAGE_GATHER4_C_L_V4_V5_nsa_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 1764
  { IMAGE_GATHER4_C_L_V5_V2_nsa_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 1765
  { IMAGE_GATHER4_C_L_V5_V3_nsa_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 1766
  { IMAGE_GATHER4_C_L_V5_V4_nsa_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 1767
  { IMAGE_GATHER4_C_L_V5_V5_nsa_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 1768
  { IMAGE_GATHER4_C_L_V2_V2_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 1769
  { IMAGE_GATHER4_C_L_V2_V3_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 1770
  { IMAGE_GATHER4_C_L_V2_V4_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 1771
  { IMAGE_GATHER4_C_L_V2_V5_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 1772
  { IMAGE_GATHER4_C_L_V2_V8_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 1773
  { IMAGE_GATHER4_C_L_V4_V2_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 1774
  { IMAGE_GATHER4_C_L_V4_V3_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 1775
  { IMAGE_GATHER4_C_L_V4_V4_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 1776
  { IMAGE_GATHER4_C_L_V4_V5_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 1777
  { IMAGE_GATHER4_C_L_V4_V8_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 1778
  { IMAGE_GATHER4_C_L_V5_V2_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 1779
  { IMAGE_GATHER4_C_L_V5_V3_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 1780
  { IMAGE_GATHER4_C_L_V5_V4_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 1781
  { IMAGE_GATHER4_C_L_V5_V5_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 1782
  { IMAGE_GATHER4_C_L_V5_V8_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 1783
  { IMAGE_GATHER4_C_L_V2_V2_nsa_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 1784
  { IMAGE_GATHER4_C_L_V2_V3_nsa_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 1785
  { IMAGE_GATHER4_C_L_V2_V4_nsa_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 1786
  { IMAGE_GATHER4_C_L_V2_V5_nsa_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 1787
  { IMAGE_GATHER4_C_L_V4_V2_nsa_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 1788
  { IMAGE_GATHER4_C_L_V4_V3_nsa_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 1789
  { IMAGE_GATHER4_C_L_V4_V4_nsa_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 1790
  { IMAGE_GATHER4_C_L_V4_V5_nsa_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 1791
  { IMAGE_GATHER4_C_L_V5_V2_nsa_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 1792
  { IMAGE_GATHER4_C_L_V5_V3_nsa_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 1793
  { IMAGE_GATHER4_C_L_V5_V4_nsa_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 1794
  { IMAGE_GATHER4_C_L_V5_V5_nsa_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 1795
  { IMAGE_GATHER4_C_L_V2_V2_gfx12, IMAGE_GATHER4_C_L, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 1796
  { IMAGE_GATHER4_C_L_V2_V3_gfx12, IMAGE_GATHER4_C_L, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 1797
  { IMAGE_GATHER4_C_L_V2_V4_gfx12, IMAGE_GATHER4_C_L, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 1798
  { IMAGE_GATHER4_C_L_V2_V5_gfx12, IMAGE_GATHER4_C_L, MIMGEncGfx12, 0x2, 0x5, 0x5 }, // 1799
  { IMAGE_GATHER4_C_L_V4_V2_gfx12, IMAGE_GATHER4_C_L, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 1800
  { IMAGE_GATHER4_C_L_V4_V3_gfx12, IMAGE_GATHER4_C_L, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 1801
  { IMAGE_GATHER4_C_L_V4_V4_gfx12, IMAGE_GATHER4_C_L, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 1802
  { IMAGE_GATHER4_C_L_V4_V5_gfx12, IMAGE_GATHER4_C_L, MIMGEncGfx12, 0x4, 0x5, 0x5 }, // 1803
  { IMAGE_GATHER4_C_L_V5_V2_gfx12, IMAGE_GATHER4_C_L, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 1804
  { IMAGE_GATHER4_C_L_V5_V3_gfx12, IMAGE_GATHER4_C_L, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 1805
  { IMAGE_GATHER4_C_L_V5_V4_gfx12, IMAGE_GATHER4_C_L, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 1806
  { IMAGE_GATHER4_C_L_V5_V5_gfx12, IMAGE_GATHER4_C_L, MIMGEncGfx12, 0x5, 0x5, 0x5 }, // 1807
  { IMAGE_GATHER4_C_L_V2_V2, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 1808
  { IMAGE_GATHER4_C_L_V2_V3, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 1809
  { IMAGE_GATHER4_C_L_V2_V4, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 1810
  { IMAGE_GATHER4_C_L_V2_V5, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 1811
  { IMAGE_GATHER4_C_L_V2_V8, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 1812
  { IMAGE_GATHER4_C_L_V4_V2, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 1813
  { IMAGE_GATHER4_C_L_V4_V3, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 1814
  { IMAGE_GATHER4_C_L_V4_V4, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 1815
  { IMAGE_GATHER4_C_L_V4_V5, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 1816
  { IMAGE_GATHER4_C_L_V4_V8, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 1817
  { IMAGE_GATHER4_C_L_V5_V2, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 1818
  { IMAGE_GATHER4_C_L_V5_V3, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 1819
  { IMAGE_GATHER4_C_L_V5_V4, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 1820
  { IMAGE_GATHER4_C_L_V5_V5, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 1821
  { IMAGE_GATHER4_C_L_V5_V8, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 1822
  { IMAGE_GATHER4_C_LZ_V2_V2_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 1823
  { IMAGE_GATHER4_C_LZ_V2_V3_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 1824
  { IMAGE_GATHER4_C_LZ_V2_V4_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 1825
  { IMAGE_GATHER4_C_LZ_V4_V2_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 1826
  { IMAGE_GATHER4_C_LZ_V4_V3_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 1827
  { IMAGE_GATHER4_C_LZ_V4_V4_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 1828
  { IMAGE_GATHER4_C_LZ_V5_V2_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 1829
  { IMAGE_GATHER4_C_LZ_V5_V3_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 1830
  { IMAGE_GATHER4_C_LZ_V5_V4_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 1831
  { IMAGE_GATHER4_C_LZ_V2_V2_nsa_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 1832
  { IMAGE_GATHER4_C_LZ_V2_V3_nsa_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 1833
  { IMAGE_GATHER4_C_LZ_V2_V4_nsa_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 1834
  { IMAGE_GATHER4_C_LZ_V4_V2_nsa_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 1835
  { IMAGE_GATHER4_C_LZ_V4_V3_nsa_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 1836
  { IMAGE_GATHER4_C_LZ_V4_V4_nsa_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 1837
  { IMAGE_GATHER4_C_LZ_V5_V2_nsa_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 1838
  { IMAGE_GATHER4_C_LZ_V5_V3_nsa_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 1839
  { IMAGE_GATHER4_C_LZ_V5_V4_nsa_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 1840
  { IMAGE_GATHER4_C_LZ_V2_V2_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 1841
  { IMAGE_GATHER4_C_LZ_V2_V3_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 1842
  { IMAGE_GATHER4_C_LZ_V2_V4_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 1843
  { IMAGE_GATHER4_C_LZ_V4_V2_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 1844
  { IMAGE_GATHER4_C_LZ_V4_V3_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 1845
  { IMAGE_GATHER4_C_LZ_V4_V4_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 1846
  { IMAGE_GATHER4_C_LZ_V5_V2_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 1847
  { IMAGE_GATHER4_C_LZ_V5_V3_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 1848
  { IMAGE_GATHER4_C_LZ_V5_V4_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 1849
  { IMAGE_GATHER4_C_LZ_V2_V2_nsa_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 1850
  { IMAGE_GATHER4_C_LZ_V2_V3_nsa_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 1851
  { IMAGE_GATHER4_C_LZ_V2_V4_nsa_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 1852
  { IMAGE_GATHER4_C_LZ_V4_V2_nsa_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 1853
  { IMAGE_GATHER4_C_LZ_V4_V3_nsa_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 1854
  { IMAGE_GATHER4_C_LZ_V4_V4_nsa_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 1855
  { IMAGE_GATHER4_C_LZ_V5_V2_nsa_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 1856
  { IMAGE_GATHER4_C_LZ_V5_V3_nsa_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 1857
  { IMAGE_GATHER4_C_LZ_V5_V4_nsa_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 1858
  { IMAGE_GATHER4_C_LZ_V2_V2_gfx12, IMAGE_GATHER4_C_LZ, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 1859
  { IMAGE_GATHER4_C_LZ_V2_V3_gfx12, IMAGE_GATHER4_C_LZ, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 1860
  { IMAGE_GATHER4_C_LZ_V2_V4_gfx12, IMAGE_GATHER4_C_LZ, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 1861
  { IMAGE_GATHER4_C_LZ_V4_V2_gfx12, IMAGE_GATHER4_C_LZ, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 1862
  { IMAGE_GATHER4_C_LZ_V4_V3_gfx12, IMAGE_GATHER4_C_LZ, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 1863
  { IMAGE_GATHER4_C_LZ_V4_V4_gfx12, IMAGE_GATHER4_C_LZ, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 1864
  { IMAGE_GATHER4_C_LZ_V5_V2_gfx12, IMAGE_GATHER4_C_LZ, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 1865
  { IMAGE_GATHER4_C_LZ_V5_V3_gfx12, IMAGE_GATHER4_C_LZ, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 1866
  { IMAGE_GATHER4_C_LZ_V5_V4_gfx12, IMAGE_GATHER4_C_LZ, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 1867
  { IMAGE_GATHER4_C_LZ_V2_V2, IMAGE_GATHER4_C_LZ, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 1868
  { IMAGE_GATHER4_C_LZ_V2_V3, IMAGE_GATHER4_C_LZ, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 1869
  { IMAGE_GATHER4_C_LZ_V2_V4, IMAGE_GATHER4_C_LZ, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 1870
  { IMAGE_GATHER4_C_LZ_V4_V2, IMAGE_GATHER4_C_LZ, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 1871
  { IMAGE_GATHER4_C_LZ_V4_V3, IMAGE_GATHER4_C_LZ, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 1872
  { IMAGE_GATHER4_C_LZ_V4_V4, IMAGE_GATHER4_C_LZ, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 1873
  { IMAGE_GATHER4_C_LZ_V5_V2, IMAGE_GATHER4_C_LZ, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 1874
  { IMAGE_GATHER4_C_LZ_V5_V3, IMAGE_GATHER4_C_LZ, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 1875
  { IMAGE_GATHER4_C_LZ_V5_V4, IMAGE_GATHER4_C_LZ, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 1876
  { IMAGE_GATHER4_C_LZ_O_V2_V3_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 1877
  { IMAGE_GATHER4_C_LZ_O_V2_V4_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 1878
  { IMAGE_GATHER4_C_LZ_O_V2_V5_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 1879
  { IMAGE_GATHER4_C_LZ_O_V2_V8_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 1880
  { IMAGE_GATHER4_C_LZ_O_V4_V3_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 1881
  { IMAGE_GATHER4_C_LZ_O_V4_V4_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 1882
  { IMAGE_GATHER4_C_LZ_O_V4_V5_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 1883
  { IMAGE_GATHER4_C_LZ_O_V4_V8_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 1884
  { IMAGE_GATHER4_C_LZ_O_V5_V3_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 1885
  { IMAGE_GATHER4_C_LZ_O_V5_V4_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 1886
  { IMAGE_GATHER4_C_LZ_O_V5_V5_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 1887
  { IMAGE_GATHER4_C_LZ_O_V5_V8_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 1888
  { IMAGE_GATHER4_C_LZ_O_V2_V3_nsa_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 1889
  { IMAGE_GATHER4_C_LZ_O_V2_V4_nsa_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 1890
  { IMAGE_GATHER4_C_LZ_O_V2_V5_nsa_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 1891
  { IMAGE_GATHER4_C_LZ_O_V4_V3_nsa_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 1892
  { IMAGE_GATHER4_C_LZ_O_V4_V4_nsa_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 1893
  { IMAGE_GATHER4_C_LZ_O_V4_V5_nsa_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 1894
  { IMAGE_GATHER4_C_LZ_O_V5_V3_nsa_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 1895
  { IMAGE_GATHER4_C_LZ_O_V5_V4_nsa_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 1896
  { IMAGE_GATHER4_C_LZ_O_V5_V5_nsa_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 1897
  { IMAGE_GATHER4_C_LZ_O_V2_V3_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 1898
  { IMAGE_GATHER4_C_LZ_O_V2_V4_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 1899
  { IMAGE_GATHER4_C_LZ_O_V2_V5_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 1900
  { IMAGE_GATHER4_C_LZ_O_V2_V8_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 1901
  { IMAGE_GATHER4_C_LZ_O_V4_V3_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 1902
  { IMAGE_GATHER4_C_LZ_O_V4_V4_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 1903
  { IMAGE_GATHER4_C_LZ_O_V4_V5_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 1904
  { IMAGE_GATHER4_C_LZ_O_V4_V8_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 1905
  { IMAGE_GATHER4_C_LZ_O_V5_V3_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 1906
  { IMAGE_GATHER4_C_LZ_O_V5_V4_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 1907
  { IMAGE_GATHER4_C_LZ_O_V5_V5_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 1908
  { IMAGE_GATHER4_C_LZ_O_V5_V8_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 1909
  { IMAGE_GATHER4_C_LZ_O_V2_V3_nsa_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 1910
  { IMAGE_GATHER4_C_LZ_O_V2_V4_nsa_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 1911
  { IMAGE_GATHER4_C_LZ_O_V2_V5_nsa_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 1912
  { IMAGE_GATHER4_C_LZ_O_V4_V3_nsa_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 1913
  { IMAGE_GATHER4_C_LZ_O_V4_V4_nsa_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 1914
  { IMAGE_GATHER4_C_LZ_O_V4_V5_nsa_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 1915
  { IMAGE_GATHER4_C_LZ_O_V5_V3_nsa_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 1916
  { IMAGE_GATHER4_C_LZ_O_V5_V4_nsa_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 1917
  { IMAGE_GATHER4_C_LZ_O_V5_V5_nsa_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 1918
  { IMAGE_GATHER4_C_LZ_O_V2_V3_gfx12, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 1919
  { IMAGE_GATHER4_C_LZ_O_V2_V4_gfx12, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 1920
  { IMAGE_GATHER4_C_LZ_O_V2_V5_gfx12, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx12, 0x2, 0x5, 0x5 }, // 1921
  { IMAGE_GATHER4_C_LZ_O_V4_V3_gfx12, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 1922
  { IMAGE_GATHER4_C_LZ_O_V4_V4_gfx12, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 1923
  { IMAGE_GATHER4_C_LZ_O_V4_V5_gfx12, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx12, 0x4, 0x5, 0x5 }, // 1924
  { IMAGE_GATHER4_C_LZ_O_V5_V3_gfx12, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 1925
  { IMAGE_GATHER4_C_LZ_O_V5_V4_gfx12, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 1926
  { IMAGE_GATHER4_C_LZ_O_V5_V5_gfx12, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx12, 0x5, 0x5, 0x5 }, // 1927
  { IMAGE_GATHER4_C_LZ_O_V2_V3, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 1928
  { IMAGE_GATHER4_C_LZ_O_V2_V4, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 1929
  { IMAGE_GATHER4_C_LZ_O_V2_V5, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 1930
  { IMAGE_GATHER4_C_LZ_O_V2_V8, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 1931
  { IMAGE_GATHER4_C_LZ_O_V4_V3, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 1932
  { IMAGE_GATHER4_C_LZ_O_V4_V4, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 1933
  { IMAGE_GATHER4_C_LZ_O_V4_V5, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 1934
  { IMAGE_GATHER4_C_LZ_O_V4_V8, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 1935
  { IMAGE_GATHER4_C_LZ_O_V5_V3, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 1936
  { IMAGE_GATHER4_C_LZ_O_V5_V4, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 1937
  { IMAGE_GATHER4_C_LZ_O_V5_V5, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 1938
  { IMAGE_GATHER4_C_LZ_O_V5_V8, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 1939
  { IMAGE_GATHER4_C_L_O_V2_V3_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 1940
  { IMAGE_GATHER4_C_L_O_V2_V4_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 1941
  { IMAGE_GATHER4_C_L_O_V2_V5_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 1942
  { IMAGE_GATHER4_C_L_O_V2_V6_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 1943
  { IMAGE_GATHER4_C_L_O_V2_V8_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 1944
  { IMAGE_GATHER4_C_L_O_V4_V3_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 1945
  { IMAGE_GATHER4_C_L_O_V4_V4_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 1946
  { IMAGE_GATHER4_C_L_O_V4_V5_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 1947
  { IMAGE_GATHER4_C_L_O_V4_V6_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 1948
  { IMAGE_GATHER4_C_L_O_V4_V8_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 1949
  { IMAGE_GATHER4_C_L_O_V5_V3_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 1950
  { IMAGE_GATHER4_C_L_O_V5_V4_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 1951
  { IMAGE_GATHER4_C_L_O_V5_V5_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 1952
  { IMAGE_GATHER4_C_L_O_V5_V6_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 1953
  { IMAGE_GATHER4_C_L_O_V5_V8_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 1954
  { IMAGE_GATHER4_C_L_O_V2_V3_nsa_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 1955
  { IMAGE_GATHER4_C_L_O_V2_V4_nsa_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 1956
  { IMAGE_GATHER4_C_L_O_V2_V5_nsa_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 1957
  { IMAGE_GATHER4_C_L_O_V2_V6_nsa_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 1958
  { IMAGE_GATHER4_C_L_O_V4_V3_nsa_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 1959
  { IMAGE_GATHER4_C_L_O_V4_V4_nsa_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 1960
  { IMAGE_GATHER4_C_L_O_V4_V5_nsa_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 1961
  { IMAGE_GATHER4_C_L_O_V4_V6_nsa_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 1962
  { IMAGE_GATHER4_C_L_O_V5_V3_nsa_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 1963
  { IMAGE_GATHER4_C_L_O_V5_V4_nsa_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 1964
  { IMAGE_GATHER4_C_L_O_V5_V5_nsa_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 1965
  { IMAGE_GATHER4_C_L_O_V5_V6_nsa_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 1966
  { IMAGE_GATHER4_C_L_O_V2_V3, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 1967
  { IMAGE_GATHER4_C_L_O_V2_V4, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 1968
  { IMAGE_GATHER4_C_L_O_V2_V5, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 1969
  { IMAGE_GATHER4_C_L_O_V2_V6, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 1970
  { IMAGE_GATHER4_C_L_O_V2_V8, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 1971
  { IMAGE_GATHER4_C_L_O_V4_V3, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 1972
  { IMAGE_GATHER4_C_L_O_V4_V4, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 1973
  { IMAGE_GATHER4_C_L_O_V4_V5, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 1974
  { IMAGE_GATHER4_C_L_O_V4_V6, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 1975
  { IMAGE_GATHER4_C_L_O_V4_V8, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 1976
  { IMAGE_GATHER4_C_L_O_V5_V3, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 1977
  { IMAGE_GATHER4_C_L_O_V5_V4, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 1978
  { IMAGE_GATHER4_C_L_O_V5_V5, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 1979
  { IMAGE_GATHER4_C_L_O_V5_V6, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 1980
  { IMAGE_GATHER4_C_L_O_V5_V8, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 1981
  { IMAGE_GATHER4_C_O_V2_V3_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 1982
  { IMAGE_GATHER4_C_O_V2_V4_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 1983
  { IMAGE_GATHER4_C_O_V2_V5_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 1984
  { IMAGE_GATHER4_C_O_V2_V8_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 1985
  { IMAGE_GATHER4_C_O_V4_V3_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 1986
  { IMAGE_GATHER4_C_O_V4_V4_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 1987
  { IMAGE_GATHER4_C_O_V4_V5_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 1988
  { IMAGE_GATHER4_C_O_V4_V8_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 1989
  { IMAGE_GATHER4_C_O_V5_V3_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 1990
  { IMAGE_GATHER4_C_O_V5_V4_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 1991
  { IMAGE_GATHER4_C_O_V5_V5_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 1992
  { IMAGE_GATHER4_C_O_V5_V8_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 1993
  { IMAGE_GATHER4_C_O_V2_V3_nsa_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 1994
  { IMAGE_GATHER4_C_O_V2_V4_nsa_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 1995
  { IMAGE_GATHER4_C_O_V2_V5_nsa_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 1996
  { IMAGE_GATHER4_C_O_V4_V3_nsa_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 1997
  { IMAGE_GATHER4_C_O_V4_V4_nsa_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 1998
  { IMAGE_GATHER4_C_O_V4_V5_nsa_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 1999
  { IMAGE_GATHER4_C_O_V5_V3_nsa_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 2000
  { IMAGE_GATHER4_C_O_V5_V4_nsa_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 2001
  { IMAGE_GATHER4_C_O_V5_V5_nsa_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 2002
  { IMAGE_GATHER4_C_O_V2_V3, IMAGE_GATHER4_C_O, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 2003
  { IMAGE_GATHER4_C_O_V2_V4, IMAGE_GATHER4_C_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 2004
  { IMAGE_GATHER4_C_O_V2_V5, IMAGE_GATHER4_C_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 2005
  { IMAGE_GATHER4_C_O_V2_V8, IMAGE_GATHER4_C_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 2006
  { IMAGE_GATHER4_C_O_V4_V3, IMAGE_GATHER4_C_O, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 2007
  { IMAGE_GATHER4_C_O_V4_V4, IMAGE_GATHER4_C_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 2008
  { IMAGE_GATHER4_C_O_V4_V5, IMAGE_GATHER4_C_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 2009
  { IMAGE_GATHER4_C_O_V4_V8, IMAGE_GATHER4_C_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 2010
  { IMAGE_GATHER4_C_O_V5_V3, IMAGE_GATHER4_C_O, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 2011
  { IMAGE_GATHER4_C_O_V5_V4, IMAGE_GATHER4_C_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 2012
  { IMAGE_GATHER4_C_O_V5_V5, IMAGE_GATHER4_C_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 2013
  { IMAGE_GATHER4_C_O_V5_V8, IMAGE_GATHER4_C_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 2014
  { IMAGE_GATHER4_L_V2_V1_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 2015
  { IMAGE_GATHER4_L_V2_V2_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 2016
  { IMAGE_GATHER4_L_V2_V3_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 2017
  { IMAGE_GATHER4_L_V2_V4_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 2018
  { IMAGE_GATHER4_L_V4_V1_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 2019
  { IMAGE_GATHER4_L_V4_V2_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 2020
  { IMAGE_GATHER4_L_V4_V3_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 2021
  { IMAGE_GATHER4_L_V4_V4_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 2022
  { IMAGE_GATHER4_L_V5_V1_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10Default, 0x5, 0x1, 0x1 }, // 2023
  { IMAGE_GATHER4_L_V5_V2_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 2024
  { IMAGE_GATHER4_L_V5_V3_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 2025
  { IMAGE_GATHER4_L_V5_V4_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 2026
  { IMAGE_GATHER4_L_V2_V2_nsa_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 2027
  { IMAGE_GATHER4_L_V2_V3_nsa_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 2028
  { IMAGE_GATHER4_L_V2_V4_nsa_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 2029
  { IMAGE_GATHER4_L_V4_V2_nsa_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 2030
  { IMAGE_GATHER4_L_V4_V3_nsa_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 2031
  { IMAGE_GATHER4_L_V4_V4_nsa_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 2032
  { IMAGE_GATHER4_L_V5_V2_nsa_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 2033
  { IMAGE_GATHER4_L_V5_V3_nsa_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 2034
  { IMAGE_GATHER4_L_V5_V4_nsa_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 2035
  { IMAGE_GATHER4_L_V2_V1_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 2036
  { IMAGE_GATHER4_L_V2_V2_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 2037
  { IMAGE_GATHER4_L_V2_V3_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 2038
  { IMAGE_GATHER4_L_V2_V4_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 2039
  { IMAGE_GATHER4_L_V4_V1_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 2040
  { IMAGE_GATHER4_L_V4_V2_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 2041
  { IMAGE_GATHER4_L_V4_V3_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 2042
  { IMAGE_GATHER4_L_V4_V4_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 2043
  { IMAGE_GATHER4_L_V5_V1_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11Default, 0x5, 0x1, 0x1 }, // 2044
  { IMAGE_GATHER4_L_V5_V2_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 2045
  { IMAGE_GATHER4_L_V5_V3_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 2046
  { IMAGE_GATHER4_L_V5_V4_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 2047
  { IMAGE_GATHER4_L_V2_V2_nsa_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 2048
  { IMAGE_GATHER4_L_V2_V3_nsa_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 2049
  { IMAGE_GATHER4_L_V2_V4_nsa_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 2050
  { IMAGE_GATHER4_L_V4_V2_nsa_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 2051
  { IMAGE_GATHER4_L_V4_V3_nsa_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 2052
  { IMAGE_GATHER4_L_V4_V4_nsa_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 2053
  { IMAGE_GATHER4_L_V5_V2_nsa_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 2054
  { IMAGE_GATHER4_L_V5_V3_nsa_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 2055
  { IMAGE_GATHER4_L_V5_V4_nsa_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 2056
  { IMAGE_GATHER4_L_V2_V1_gfx12, IMAGE_GATHER4_L, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 2057
  { IMAGE_GATHER4_L_V2_V2_gfx12, IMAGE_GATHER4_L, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 2058
  { IMAGE_GATHER4_L_V2_V3_gfx12, IMAGE_GATHER4_L, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 2059
  { IMAGE_GATHER4_L_V2_V4_gfx12, IMAGE_GATHER4_L, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 2060
  { IMAGE_GATHER4_L_V4_V1_gfx12, IMAGE_GATHER4_L, MIMGEncGfx12, 0x4, 0x1, 0x1 }, // 2061
  { IMAGE_GATHER4_L_V4_V2_gfx12, IMAGE_GATHER4_L, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 2062
  { IMAGE_GATHER4_L_V4_V3_gfx12, IMAGE_GATHER4_L, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 2063
  { IMAGE_GATHER4_L_V4_V4_gfx12, IMAGE_GATHER4_L, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 2064
  { IMAGE_GATHER4_L_V5_V1_gfx12, IMAGE_GATHER4_L, MIMGEncGfx12, 0x5, 0x1, 0x1 }, // 2065
  { IMAGE_GATHER4_L_V5_V2_gfx12, IMAGE_GATHER4_L, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 2066
  { IMAGE_GATHER4_L_V5_V3_gfx12, IMAGE_GATHER4_L, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 2067
  { IMAGE_GATHER4_L_V5_V4_gfx12, IMAGE_GATHER4_L, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 2068
  { IMAGE_GATHER4_L_V2_V1, IMAGE_GATHER4_L, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 2069
  { IMAGE_GATHER4_L_V2_V2, IMAGE_GATHER4_L, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 2070
  { IMAGE_GATHER4_L_V2_V3, IMAGE_GATHER4_L, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 2071
  { IMAGE_GATHER4_L_V2_V4, IMAGE_GATHER4_L, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 2072
  { IMAGE_GATHER4_L_V4_V1, IMAGE_GATHER4_L, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 2073
  { IMAGE_GATHER4_L_V4_V2, IMAGE_GATHER4_L, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 2074
  { IMAGE_GATHER4_L_V4_V3, IMAGE_GATHER4_L, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 2075
  { IMAGE_GATHER4_L_V4_V4, IMAGE_GATHER4_L, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 2076
  { IMAGE_GATHER4_L_V5_V1, IMAGE_GATHER4_L, MIMGEncGfx6, 0x5, 0x1, 0x1 }, // 2077
  { IMAGE_GATHER4_L_V5_V2, IMAGE_GATHER4_L, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 2078
  { IMAGE_GATHER4_L_V5_V3, IMAGE_GATHER4_L, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 2079
  { IMAGE_GATHER4_L_V5_V4, IMAGE_GATHER4_L, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 2080
  { IMAGE_GATHER4_LZ_V2_V1_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 2081
  { IMAGE_GATHER4_LZ_V2_V2_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 2082
  { IMAGE_GATHER4_LZ_V2_V3_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 2083
  { IMAGE_GATHER4_LZ_V2_V4_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 2084
  { IMAGE_GATHER4_LZ_V4_V1_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 2085
  { IMAGE_GATHER4_LZ_V4_V2_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 2086
  { IMAGE_GATHER4_LZ_V4_V3_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 2087
  { IMAGE_GATHER4_LZ_V4_V4_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 2088
  { IMAGE_GATHER4_LZ_V5_V1_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10Default, 0x5, 0x1, 0x1 }, // 2089
  { IMAGE_GATHER4_LZ_V5_V2_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 2090
  { IMAGE_GATHER4_LZ_V5_V3_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 2091
  { IMAGE_GATHER4_LZ_V5_V4_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 2092
  { IMAGE_GATHER4_LZ_V2_V2_nsa_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 2093
  { IMAGE_GATHER4_LZ_V2_V3_nsa_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 2094
  { IMAGE_GATHER4_LZ_V4_V2_nsa_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 2095
  { IMAGE_GATHER4_LZ_V4_V3_nsa_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 2096
  { IMAGE_GATHER4_LZ_V5_V2_nsa_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 2097
  { IMAGE_GATHER4_LZ_V5_V3_nsa_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 2098
  { IMAGE_GATHER4_LZ_V2_V1_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 2099
  { IMAGE_GATHER4_LZ_V2_V2_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 2100
  { IMAGE_GATHER4_LZ_V2_V3_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 2101
  { IMAGE_GATHER4_LZ_V2_V4_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 2102
  { IMAGE_GATHER4_LZ_V4_V1_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 2103
  { IMAGE_GATHER4_LZ_V4_V2_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 2104
  { IMAGE_GATHER4_LZ_V4_V3_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 2105
  { IMAGE_GATHER4_LZ_V4_V4_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 2106
  { IMAGE_GATHER4_LZ_V5_V1_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11Default, 0x5, 0x1, 0x1 }, // 2107
  { IMAGE_GATHER4_LZ_V5_V2_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 2108
  { IMAGE_GATHER4_LZ_V5_V3_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 2109
  { IMAGE_GATHER4_LZ_V5_V4_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 2110
  { IMAGE_GATHER4_LZ_V2_V2_nsa_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 2111
  { IMAGE_GATHER4_LZ_V2_V3_nsa_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 2112
  { IMAGE_GATHER4_LZ_V4_V2_nsa_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 2113
  { IMAGE_GATHER4_LZ_V4_V3_nsa_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 2114
  { IMAGE_GATHER4_LZ_V5_V2_nsa_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 2115
  { IMAGE_GATHER4_LZ_V5_V3_nsa_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 2116
  { IMAGE_GATHER4_LZ_V2_V1_gfx12, IMAGE_GATHER4_LZ, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 2117
  { IMAGE_GATHER4_LZ_V2_V2_gfx12, IMAGE_GATHER4_LZ, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 2118
  { IMAGE_GATHER4_LZ_V2_V3_gfx12, IMAGE_GATHER4_LZ, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 2119
  { IMAGE_GATHER4_LZ_V4_V1_gfx12, IMAGE_GATHER4_LZ, MIMGEncGfx12, 0x4, 0x1, 0x1 }, // 2120
  { IMAGE_GATHER4_LZ_V4_V2_gfx12, IMAGE_GATHER4_LZ, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 2121
  { IMAGE_GATHER4_LZ_V4_V3_gfx12, IMAGE_GATHER4_LZ, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 2122
  { IMAGE_GATHER4_LZ_V5_V1_gfx12, IMAGE_GATHER4_LZ, MIMGEncGfx12, 0x5, 0x1, 0x1 }, // 2123
  { IMAGE_GATHER4_LZ_V5_V2_gfx12, IMAGE_GATHER4_LZ, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 2124
  { IMAGE_GATHER4_LZ_V5_V3_gfx12, IMAGE_GATHER4_LZ, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 2125
  { IMAGE_GATHER4_LZ_V2_V1, IMAGE_GATHER4_LZ, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 2126
  { IMAGE_GATHER4_LZ_V2_V2, IMAGE_GATHER4_LZ, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 2127
  { IMAGE_GATHER4_LZ_V2_V3, IMAGE_GATHER4_LZ, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 2128
  { IMAGE_GATHER4_LZ_V2_V4, IMAGE_GATHER4_LZ, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 2129
  { IMAGE_GATHER4_LZ_V4_V1, IMAGE_GATHER4_LZ, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 2130
  { IMAGE_GATHER4_LZ_V4_V2, IMAGE_GATHER4_LZ, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 2131
  { IMAGE_GATHER4_LZ_V4_V3, IMAGE_GATHER4_LZ, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 2132
  { IMAGE_GATHER4_LZ_V4_V4, IMAGE_GATHER4_LZ, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 2133
  { IMAGE_GATHER4_LZ_V5_V1, IMAGE_GATHER4_LZ, MIMGEncGfx6, 0x5, 0x1, 0x1 }, // 2134
  { IMAGE_GATHER4_LZ_V5_V2, IMAGE_GATHER4_LZ, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 2135
  { IMAGE_GATHER4_LZ_V5_V3, IMAGE_GATHER4_LZ, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 2136
  { IMAGE_GATHER4_LZ_V5_V4, IMAGE_GATHER4_LZ, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 2137
  { IMAGE_GATHER4_LZ_O_V2_V2_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 2138
  { IMAGE_GATHER4_LZ_O_V2_V3_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 2139
  { IMAGE_GATHER4_LZ_O_V2_V4_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 2140
  { IMAGE_GATHER4_LZ_O_V4_V2_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 2141
  { IMAGE_GATHER4_LZ_O_V4_V3_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 2142
  { IMAGE_GATHER4_LZ_O_V4_V4_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 2143
  { IMAGE_GATHER4_LZ_O_V5_V2_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 2144
  { IMAGE_GATHER4_LZ_O_V5_V3_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 2145
  { IMAGE_GATHER4_LZ_O_V5_V4_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 2146
  { IMAGE_GATHER4_LZ_O_V2_V2_nsa_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 2147
  { IMAGE_GATHER4_LZ_O_V2_V3_nsa_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 2148
  { IMAGE_GATHER4_LZ_O_V2_V4_nsa_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 2149
  { IMAGE_GATHER4_LZ_O_V4_V2_nsa_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 2150
  { IMAGE_GATHER4_LZ_O_V4_V3_nsa_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 2151
  { IMAGE_GATHER4_LZ_O_V4_V4_nsa_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 2152
  { IMAGE_GATHER4_LZ_O_V5_V2_nsa_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 2153
  { IMAGE_GATHER4_LZ_O_V5_V3_nsa_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 2154
  { IMAGE_GATHER4_LZ_O_V5_V4_nsa_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 2155
  { IMAGE_GATHER4_LZ_O_V2_V2_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 2156
  { IMAGE_GATHER4_LZ_O_V2_V3_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 2157
  { IMAGE_GATHER4_LZ_O_V2_V4_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 2158
  { IMAGE_GATHER4_LZ_O_V4_V2_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 2159
  { IMAGE_GATHER4_LZ_O_V4_V3_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 2160
  { IMAGE_GATHER4_LZ_O_V4_V4_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 2161
  { IMAGE_GATHER4_LZ_O_V5_V2_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 2162
  { IMAGE_GATHER4_LZ_O_V5_V3_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 2163
  { IMAGE_GATHER4_LZ_O_V5_V4_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 2164
  { IMAGE_GATHER4_LZ_O_V2_V2_nsa_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 2165
  { IMAGE_GATHER4_LZ_O_V2_V3_nsa_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 2166
  { IMAGE_GATHER4_LZ_O_V2_V4_nsa_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 2167
  { IMAGE_GATHER4_LZ_O_V4_V2_nsa_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 2168
  { IMAGE_GATHER4_LZ_O_V4_V3_nsa_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 2169
  { IMAGE_GATHER4_LZ_O_V4_V4_nsa_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 2170
  { IMAGE_GATHER4_LZ_O_V5_V2_nsa_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 2171
  { IMAGE_GATHER4_LZ_O_V5_V3_nsa_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 2172
  { IMAGE_GATHER4_LZ_O_V5_V4_nsa_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 2173
  { IMAGE_GATHER4_LZ_O_V2_V2_gfx12, IMAGE_GATHER4_LZ_O, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 2174
  { IMAGE_GATHER4_LZ_O_V2_V3_gfx12, IMAGE_GATHER4_LZ_O, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 2175
  { IMAGE_GATHER4_LZ_O_V2_V4_gfx12, IMAGE_GATHER4_LZ_O, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 2176
  { IMAGE_GATHER4_LZ_O_V4_V2_gfx12, IMAGE_GATHER4_LZ_O, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 2177
  { IMAGE_GATHER4_LZ_O_V4_V3_gfx12, IMAGE_GATHER4_LZ_O, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 2178
  { IMAGE_GATHER4_LZ_O_V4_V4_gfx12, IMAGE_GATHER4_LZ_O, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 2179
  { IMAGE_GATHER4_LZ_O_V5_V2_gfx12, IMAGE_GATHER4_LZ_O, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 2180
  { IMAGE_GATHER4_LZ_O_V5_V3_gfx12, IMAGE_GATHER4_LZ_O, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 2181
  { IMAGE_GATHER4_LZ_O_V5_V4_gfx12, IMAGE_GATHER4_LZ_O, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 2182
  { IMAGE_GATHER4_LZ_O_V2_V2, IMAGE_GATHER4_LZ_O, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 2183
  { IMAGE_GATHER4_LZ_O_V2_V3, IMAGE_GATHER4_LZ_O, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 2184
  { IMAGE_GATHER4_LZ_O_V2_V4, IMAGE_GATHER4_LZ_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 2185
  { IMAGE_GATHER4_LZ_O_V4_V2, IMAGE_GATHER4_LZ_O, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 2186
  { IMAGE_GATHER4_LZ_O_V4_V3, IMAGE_GATHER4_LZ_O, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 2187
  { IMAGE_GATHER4_LZ_O_V4_V4, IMAGE_GATHER4_LZ_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 2188
  { IMAGE_GATHER4_LZ_O_V5_V2, IMAGE_GATHER4_LZ_O, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 2189
  { IMAGE_GATHER4_LZ_O_V5_V3, IMAGE_GATHER4_LZ_O, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 2190
  { IMAGE_GATHER4_LZ_O_V5_V4, IMAGE_GATHER4_LZ_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 2191
  { IMAGE_GATHER4_L_O_V2_V2_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 2192
  { IMAGE_GATHER4_L_O_V2_V3_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 2193
  { IMAGE_GATHER4_L_O_V2_V4_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 2194
  { IMAGE_GATHER4_L_O_V2_V5_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 2195
  { IMAGE_GATHER4_L_O_V2_V8_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 2196
  { IMAGE_GATHER4_L_O_V4_V2_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 2197
  { IMAGE_GATHER4_L_O_V4_V3_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 2198
  { IMAGE_GATHER4_L_O_V4_V4_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 2199
  { IMAGE_GATHER4_L_O_V4_V5_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 2200
  { IMAGE_GATHER4_L_O_V4_V8_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 2201
  { IMAGE_GATHER4_L_O_V5_V2_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 2202
  { IMAGE_GATHER4_L_O_V5_V3_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 2203
  { IMAGE_GATHER4_L_O_V5_V4_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 2204
  { IMAGE_GATHER4_L_O_V5_V5_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 2205
  { IMAGE_GATHER4_L_O_V5_V8_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 2206
  { IMAGE_GATHER4_L_O_V2_V2_nsa_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 2207
  { IMAGE_GATHER4_L_O_V2_V3_nsa_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 2208
  { IMAGE_GATHER4_L_O_V2_V4_nsa_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 2209
  { IMAGE_GATHER4_L_O_V2_V5_nsa_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 2210
  { IMAGE_GATHER4_L_O_V4_V2_nsa_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 2211
  { IMAGE_GATHER4_L_O_V4_V3_nsa_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 2212
  { IMAGE_GATHER4_L_O_V4_V4_nsa_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 2213
  { IMAGE_GATHER4_L_O_V4_V5_nsa_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 2214
  { IMAGE_GATHER4_L_O_V5_V2_nsa_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 2215
  { IMAGE_GATHER4_L_O_V5_V3_nsa_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 2216
  { IMAGE_GATHER4_L_O_V5_V4_nsa_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 2217
  { IMAGE_GATHER4_L_O_V5_V5_nsa_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 2218
  { IMAGE_GATHER4_L_O_V2_V2, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 2219
  { IMAGE_GATHER4_L_O_V2_V3, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 2220
  { IMAGE_GATHER4_L_O_V2_V4, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 2221
  { IMAGE_GATHER4_L_O_V2_V5, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 2222
  { IMAGE_GATHER4_L_O_V2_V8, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 2223
  { IMAGE_GATHER4_L_O_V4_V2, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 2224
  { IMAGE_GATHER4_L_O_V4_V3, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 2225
  { IMAGE_GATHER4_L_O_V4_V4, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 2226
  { IMAGE_GATHER4_L_O_V4_V5, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 2227
  { IMAGE_GATHER4_L_O_V4_V8, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 2228
  { IMAGE_GATHER4_L_O_V5_V2, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 2229
  { IMAGE_GATHER4_L_O_V5_V3, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 2230
  { IMAGE_GATHER4_L_O_V5_V4, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 2231
  { IMAGE_GATHER4_L_O_V5_V5, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 2232
  { IMAGE_GATHER4_L_O_V5_V8, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 2233
  { IMAGE_GATHER4_O_V2_V2_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 2234
  { IMAGE_GATHER4_O_V2_V3_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 2235
  { IMAGE_GATHER4_O_V2_V4_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 2236
  { IMAGE_GATHER4_O_V4_V2_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 2237
  { IMAGE_GATHER4_O_V4_V3_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 2238
  { IMAGE_GATHER4_O_V4_V4_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 2239
  { IMAGE_GATHER4_O_V5_V2_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 2240
  { IMAGE_GATHER4_O_V5_V3_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 2241
  { IMAGE_GATHER4_O_V5_V4_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 2242
  { IMAGE_GATHER4_O_V2_V2_nsa_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 2243
  { IMAGE_GATHER4_O_V2_V3_nsa_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 2244
  { IMAGE_GATHER4_O_V2_V4_nsa_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 2245
  { IMAGE_GATHER4_O_V4_V2_nsa_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 2246
  { IMAGE_GATHER4_O_V4_V3_nsa_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 2247
  { IMAGE_GATHER4_O_V4_V4_nsa_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 2248
  { IMAGE_GATHER4_O_V5_V2_nsa_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 2249
  { IMAGE_GATHER4_O_V5_V3_nsa_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 2250
  { IMAGE_GATHER4_O_V5_V4_nsa_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 2251
  { IMAGE_GATHER4_O_V2_V2_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 2252
  { IMAGE_GATHER4_O_V2_V3_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 2253
  { IMAGE_GATHER4_O_V2_V4_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 2254
  { IMAGE_GATHER4_O_V4_V2_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 2255
  { IMAGE_GATHER4_O_V4_V3_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 2256
  { IMAGE_GATHER4_O_V4_V4_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 2257
  { IMAGE_GATHER4_O_V5_V2_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 2258
  { IMAGE_GATHER4_O_V5_V3_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 2259
  { IMAGE_GATHER4_O_V5_V4_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 2260
  { IMAGE_GATHER4_O_V2_V2_nsa_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 2261
  { IMAGE_GATHER4_O_V2_V3_nsa_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 2262
  { IMAGE_GATHER4_O_V2_V4_nsa_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 2263
  { IMAGE_GATHER4_O_V4_V2_nsa_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 2264
  { IMAGE_GATHER4_O_V4_V3_nsa_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 2265
  { IMAGE_GATHER4_O_V4_V4_nsa_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 2266
  { IMAGE_GATHER4_O_V5_V2_nsa_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 2267
  { IMAGE_GATHER4_O_V5_V3_nsa_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 2268
  { IMAGE_GATHER4_O_V5_V4_nsa_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 2269
  { IMAGE_GATHER4_O_V2_V2_gfx12, IMAGE_GATHER4_O, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 2270
  { IMAGE_GATHER4_O_V2_V3_gfx12, IMAGE_GATHER4_O, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 2271
  { IMAGE_GATHER4_O_V2_V4_gfx12, IMAGE_GATHER4_O, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 2272
  { IMAGE_GATHER4_O_V4_V2_gfx12, IMAGE_GATHER4_O, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 2273
  { IMAGE_GATHER4_O_V4_V3_gfx12, IMAGE_GATHER4_O, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 2274
  { IMAGE_GATHER4_O_V4_V4_gfx12, IMAGE_GATHER4_O, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 2275
  { IMAGE_GATHER4_O_V5_V2_gfx12, IMAGE_GATHER4_O, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 2276
  { IMAGE_GATHER4_O_V5_V3_gfx12, IMAGE_GATHER4_O, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 2277
  { IMAGE_GATHER4_O_V5_V4_gfx12, IMAGE_GATHER4_O, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 2278
  { IMAGE_GATHER4_O_V2_V2, IMAGE_GATHER4_O, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 2279
  { IMAGE_GATHER4_O_V2_V3, IMAGE_GATHER4_O, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 2280
  { IMAGE_GATHER4_O_V2_V4, IMAGE_GATHER4_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 2281
  { IMAGE_GATHER4_O_V4_V2, IMAGE_GATHER4_O, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 2282
  { IMAGE_GATHER4_O_V4_V3, IMAGE_GATHER4_O, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 2283
  { IMAGE_GATHER4_O_V4_V4, IMAGE_GATHER4_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 2284
  { IMAGE_GATHER4_O_V5_V2, IMAGE_GATHER4_O, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 2285
  { IMAGE_GATHER4_O_V5_V3, IMAGE_GATHER4_O, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 2286
  { IMAGE_GATHER4_O_V5_V4, IMAGE_GATHER4_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 2287
  { IMAGE_GET_LOD_V1_V1_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 2288
  { IMAGE_GET_LOD_V1_V2_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 2289
  { IMAGE_GET_LOD_V1_V3_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 2290
  { IMAGE_GET_LOD_V1_V4_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 2291
  { IMAGE_GET_LOD_V2_V1_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 2292
  { IMAGE_GET_LOD_V2_V2_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 2293
  { IMAGE_GET_LOD_V2_V3_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 2294
  { IMAGE_GET_LOD_V2_V4_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 2295
  { IMAGE_GET_LOD_V3_V1_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x3, 0x1, 0x1 }, // 2296
  { IMAGE_GET_LOD_V3_V2_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 2297
  { IMAGE_GET_LOD_V3_V3_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 2298
  { IMAGE_GET_LOD_V3_V4_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 2299
  { IMAGE_GET_LOD_V4_V1_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 2300
  { IMAGE_GET_LOD_V4_V2_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 2301
  { IMAGE_GET_LOD_V4_V3_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 2302
  { IMAGE_GET_LOD_V4_V4_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 2303
  { IMAGE_GET_LOD_V5_V1_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x5, 0x1, 0x1 }, // 2304
  { IMAGE_GET_LOD_V5_V2_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 2305
  { IMAGE_GET_LOD_V5_V3_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 2306
  { IMAGE_GET_LOD_V5_V4_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 2307
  { IMAGE_GET_LOD_V1_V2_nsa_gfx10, IMAGE_GET_LOD, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 2308
  { IMAGE_GET_LOD_V1_V3_nsa_gfx10, IMAGE_GET_LOD, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 2309
  { IMAGE_GET_LOD_V2_V2_nsa_gfx10, IMAGE_GET_LOD, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 2310
  { IMAGE_GET_LOD_V2_V3_nsa_gfx10, IMAGE_GET_LOD, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 2311
  { IMAGE_GET_LOD_V3_V2_nsa_gfx10, IMAGE_GET_LOD, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 2312
  { IMAGE_GET_LOD_V3_V3_nsa_gfx10, IMAGE_GET_LOD, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 2313
  { IMAGE_GET_LOD_V4_V2_nsa_gfx10, IMAGE_GET_LOD, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 2314
  { IMAGE_GET_LOD_V4_V3_nsa_gfx10, IMAGE_GET_LOD, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 2315
  { IMAGE_GET_LOD_V5_V2_nsa_gfx10, IMAGE_GET_LOD, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 2316
  { IMAGE_GET_LOD_V5_V3_nsa_gfx10, IMAGE_GET_LOD, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 2317
  { IMAGE_GET_LOD_V1_V1_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 2318
  { IMAGE_GET_LOD_V1_V2_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 2319
  { IMAGE_GET_LOD_V1_V3_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 2320
  { IMAGE_GET_LOD_V1_V4_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 2321
  { IMAGE_GET_LOD_V2_V1_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 2322
  { IMAGE_GET_LOD_V2_V2_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 2323
  { IMAGE_GET_LOD_V2_V3_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 2324
  { IMAGE_GET_LOD_V2_V4_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 2325
  { IMAGE_GET_LOD_V3_V1_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x3, 0x1, 0x1 }, // 2326
  { IMAGE_GET_LOD_V3_V2_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 2327
  { IMAGE_GET_LOD_V3_V3_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 2328
  { IMAGE_GET_LOD_V3_V4_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 2329
  { IMAGE_GET_LOD_V4_V1_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 2330
  { IMAGE_GET_LOD_V4_V2_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 2331
  { IMAGE_GET_LOD_V4_V3_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 2332
  { IMAGE_GET_LOD_V4_V4_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 2333
  { IMAGE_GET_LOD_V5_V1_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x5, 0x1, 0x1 }, // 2334
  { IMAGE_GET_LOD_V5_V2_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 2335
  { IMAGE_GET_LOD_V5_V3_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 2336
  { IMAGE_GET_LOD_V5_V4_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 2337
  { IMAGE_GET_LOD_V1_V2_nsa_gfx11, IMAGE_GET_LOD, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 2338
  { IMAGE_GET_LOD_V1_V3_nsa_gfx11, IMAGE_GET_LOD, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 2339
  { IMAGE_GET_LOD_V2_V2_nsa_gfx11, IMAGE_GET_LOD, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 2340
  { IMAGE_GET_LOD_V2_V3_nsa_gfx11, IMAGE_GET_LOD, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 2341
  { IMAGE_GET_LOD_V3_V2_nsa_gfx11, IMAGE_GET_LOD, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 2342
  { IMAGE_GET_LOD_V3_V3_nsa_gfx11, IMAGE_GET_LOD, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 2343
  { IMAGE_GET_LOD_V4_V2_nsa_gfx11, IMAGE_GET_LOD, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 2344
  { IMAGE_GET_LOD_V4_V3_nsa_gfx11, IMAGE_GET_LOD, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 2345
  { IMAGE_GET_LOD_V5_V2_nsa_gfx11, IMAGE_GET_LOD, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 2346
  { IMAGE_GET_LOD_V5_V3_nsa_gfx11, IMAGE_GET_LOD, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 2347
  { IMAGE_GET_LOD_V1_V1_gfx12, IMAGE_GET_LOD, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 2348
  { IMAGE_GET_LOD_V1_V2_gfx12, IMAGE_GET_LOD, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 2349
  { IMAGE_GET_LOD_V1_V3_gfx12, IMAGE_GET_LOD, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 2350
  { IMAGE_GET_LOD_V2_V1_gfx12, IMAGE_GET_LOD, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 2351
  { IMAGE_GET_LOD_V2_V2_gfx12, IMAGE_GET_LOD, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 2352
  { IMAGE_GET_LOD_V2_V3_gfx12, IMAGE_GET_LOD, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 2353
  { IMAGE_GET_LOD_V3_V1_gfx12, IMAGE_GET_LOD, MIMGEncGfx12, 0x3, 0x1, 0x1 }, // 2354
  { IMAGE_GET_LOD_V3_V2_gfx12, IMAGE_GET_LOD, MIMGEncGfx12, 0x3, 0x2, 0x2 }, // 2355
  { IMAGE_GET_LOD_V3_V3_gfx12, IMAGE_GET_LOD, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 2356
  { IMAGE_GET_LOD_V4_V1_gfx12, IMAGE_GET_LOD, MIMGEncGfx12, 0x4, 0x1, 0x1 }, // 2357
  { IMAGE_GET_LOD_V4_V2_gfx12, IMAGE_GET_LOD, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 2358
  { IMAGE_GET_LOD_V4_V3_gfx12, IMAGE_GET_LOD, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 2359
  { IMAGE_GET_LOD_V5_V1_gfx12, IMAGE_GET_LOD, MIMGEncGfx12, 0x5, 0x1, 0x1 }, // 2360
  { IMAGE_GET_LOD_V5_V2_gfx12, IMAGE_GET_LOD, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 2361
  { IMAGE_GET_LOD_V5_V3_gfx12, IMAGE_GET_LOD, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 2362
  { IMAGE_GET_LOD_V1_V1, IMAGE_GET_LOD, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 2363
  { IMAGE_GET_LOD_V1_V2, IMAGE_GET_LOD, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 2364
  { IMAGE_GET_LOD_V1_V3, IMAGE_GET_LOD, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 2365
  { IMAGE_GET_LOD_V1_V4, IMAGE_GET_LOD, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 2366
  { IMAGE_GET_LOD_V2_V1, IMAGE_GET_LOD, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 2367
  { IMAGE_GET_LOD_V2_V2, IMAGE_GET_LOD, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 2368
  { IMAGE_GET_LOD_V2_V3, IMAGE_GET_LOD, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 2369
  { IMAGE_GET_LOD_V2_V4, IMAGE_GET_LOD, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 2370
  { IMAGE_GET_LOD_V3_V1, IMAGE_GET_LOD, MIMGEncGfx6, 0x3, 0x1, 0x1 }, // 2371
  { IMAGE_GET_LOD_V3_V2, IMAGE_GET_LOD, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 2372
  { IMAGE_GET_LOD_V3_V3, IMAGE_GET_LOD, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 2373
  { IMAGE_GET_LOD_V3_V4, IMAGE_GET_LOD, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 2374
  { IMAGE_GET_LOD_V4_V1, IMAGE_GET_LOD, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 2375
  { IMAGE_GET_LOD_V4_V2, IMAGE_GET_LOD, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 2376
  { IMAGE_GET_LOD_V4_V3, IMAGE_GET_LOD, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 2377
  { IMAGE_GET_LOD_V4_V4, IMAGE_GET_LOD, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 2378
  { IMAGE_GET_LOD_V5_V1, IMAGE_GET_LOD, MIMGEncGfx6, 0x5, 0x1, 0x1 }, // 2379
  { IMAGE_GET_LOD_V5_V2, IMAGE_GET_LOD, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 2380
  { IMAGE_GET_LOD_V5_V3, IMAGE_GET_LOD, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 2381
  { IMAGE_GET_LOD_V5_V4, IMAGE_GET_LOD, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 2382
  { IMAGE_GET_LOD_V1_V1_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 2383
  { IMAGE_GET_LOD_V1_V2_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 2384
  { IMAGE_GET_LOD_V1_V3_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 2385
  { IMAGE_GET_LOD_V1_V4_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 2386
  { IMAGE_GET_LOD_V2_V1_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 2387
  { IMAGE_GET_LOD_V2_V2_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 2388
  { IMAGE_GET_LOD_V2_V3_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 2389
  { IMAGE_GET_LOD_V2_V4_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 2390
  { IMAGE_GET_LOD_V3_V1_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x3, 0x1, 0x1 }, // 2391
  { IMAGE_GET_LOD_V3_V2_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x3, 0x2, 0x1 }, // 2392
  { IMAGE_GET_LOD_V3_V3_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x3, 0x3, 0x1 }, // 2393
  { IMAGE_GET_LOD_V3_V4_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x3, 0x4, 0x1 }, // 2394
  { IMAGE_GET_LOD_V4_V1_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x4, 0x1, 0x1 }, // 2395
  { IMAGE_GET_LOD_V4_V2_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x4, 0x2, 0x1 }, // 2396
  { IMAGE_GET_LOD_V4_V3_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x4, 0x3, 0x1 }, // 2397
  { IMAGE_GET_LOD_V4_V4_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x4, 0x4, 0x1 }, // 2398
  { IMAGE_GET_LOD_V5_V1_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x5, 0x1, 0x1 }, // 2399
  { IMAGE_GET_LOD_V5_V2_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x5, 0x2, 0x1 }, // 2400
  { IMAGE_GET_LOD_V5_V3_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x5, 0x3, 0x1 }, // 2401
  { IMAGE_GET_LOD_V5_V4_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x5, 0x4, 0x1 }, // 2402
  { IMAGE_GET_RESINFO_V1_V1_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 2403
  { IMAGE_GET_RESINFO_V1_V2_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 2404
  { IMAGE_GET_RESINFO_V1_V3_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 2405
  { IMAGE_GET_RESINFO_V1_V4_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 2406
  { IMAGE_GET_RESINFO_V2_V1_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 2407
  { IMAGE_GET_RESINFO_V2_V2_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 2408
  { IMAGE_GET_RESINFO_V2_V3_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 2409
  { IMAGE_GET_RESINFO_V2_V4_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 2410
  { IMAGE_GET_RESINFO_V3_V1_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x3, 0x1, 0x1 }, // 2411
  { IMAGE_GET_RESINFO_V3_V2_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 2412
  { IMAGE_GET_RESINFO_V3_V3_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 2413
  { IMAGE_GET_RESINFO_V3_V4_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 2414
  { IMAGE_GET_RESINFO_V4_V1_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 2415
  { IMAGE_GET_RESINFO_V4_V2_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 2416
  { IMAGE_GET_RESINFO_V4_V3_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 2417
  { IMAGE_GET_RESINFO_V4_V4_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 2418
  { IMAGE_GET_RESINFO_V5_V1_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x5, 0x1, 0x1 }, // 2419
  { IMAGE_GET_RESINFO_V5_V2_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 2420
  { IMAGE_GET_RESINFO_V5_V3_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 2421
  { IMAGE_GET_RESINFO_V5_V4_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 2422
  { IMAGE_GET_RESINFO_V1_V2_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 2423
  { IMAGE_GET_RESINFO_V1_V3_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 2424
  { IMAGE_GET_RESINFO_V1_V4_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 2425
  { IMAGE_GET_RESINFO_V2_V2_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 2426
  { IMAGE_GET_RESINFO_V2_V3_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 2427
  { IMAGE_GET_RESINFO_V2_V4_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 2428
  { IMAGE_GET_RESINFO_V3_V2_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 2429
  { IMAGE_GET_RESINFO_V3_V3_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 2430
  { IMAGE_GET_RESINFO_V3_V4_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 2431
  { IMAGE_GET_RESINFO_V4_V2_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 2432
  { IMAGE_GET_RESINFO_V4_V3_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 2433
  { IMAGE_GET_RESINFO_V4_V4_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 2434
  { IMAGE_GET_RESINFO_V5_V2_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 2435
  { IMAGE_GET_RESINFO_V5_V3_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 2436
  { IMAGE_GET_RESINFO_V5_V4_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 2437
  { IMAGE_GET_RESINFO_V1_V1_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 2438
  { IMAGE_GET_RESINFO_V1_V2_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 2439
  { IMAGE_GET_RESINFO_V1_V3_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 2440
  { IMAGE_GET_RESINFO_V1_V4_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 2441
  { IMAGE_GET_RESINFO_V2_V1_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 2442
  { IMAGE_GET_RESINFO_V2_V2_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 2443
  { IMAGE_GET_RESINFO_V2_V3_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 2444
  { IMAGE_GET_RESINFO_V2_V4_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 2445
  { IMAGE_GET_RESINFO_V3_V1_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x3, 0x1, 0x1 }, // 2446
  { IMAGE_GET_RESINFO_V3_V2_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 2447
  { IMAGE_GET_RESINFO_V3_V3_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 2448
  { IMAGE_GET_RESINFO_V3_V4_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 2449
  { IMAGE_GET_RESINFO_V4_V1_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 2450
  { IMAGE_GET_RESINFO_V4_V2_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 2451
  { IMAGE_GET_RESINFO_V4_V3_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 2452
  { IMAGE_GET_RESINFO_V4_V4_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 2453
  { IMAGE_GET_RESINFO_V5_V1_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x5, 0x1, 0x1 }, // 2454
  { IMAGE_GET_RESINFO_V5_V2_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 2455
  { IMAGE_GET_RESINFO_V5_V3_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 2456
  { IMAGE_GET_RESINFO_V5_V4_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 2457
  { IMAGE_GET_RESINFO_V1_V2_nsa_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 2458
  { IMAGE_GET_RESINFO_V1_V3_nsa_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 2459
  { IMAGE_GET_RESINFO_V1_V4_nsa_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 2460
  { IMAGE_GET_RESINFO_V2_V2_nsa_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 2461
  { IMAGE_GET_RESINFO_V2_V3_nsa_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 2462
  { IMAGE_GET_RESINFO_V2_V4_nsa_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 2463
  { IMAGE_GET_RESINFO_V3_V2_nsa_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 2464
  { IMAGE_GET_RESINFO_V3_V3_nsa_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 2465
  { IMAGE_GET_RESINFO_V3_V4_nsa_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 2466
  { IMAGE_GET_RESINFO_V4_V2_nsa_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 2467
  { IMAGE_GET_RESINFO_V4_V3_nsa_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 2468
  { IMAGE_GET_RESINFO_V4_V4_nsa_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 2469
  { IMAGE_GET_RESINFO_V5_V2_nsa_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 2470
  { IMAGE_GET_RESINFO_V5_V3_nsa_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 2471
  { IMAGE_GET_RESINFO_V5_V4_nsa_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 2472
  { IMAGE_GET_RESINFO_V1_V1_gfx12, IMAGE_GET_RESINFO, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 2473
  { IMAGE_GET_RESINFO_V1_V2_gfx12, IMAGE_GET_RESINFO, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 2474
  { IMAGE_GET_RESINFO_V1_V3_gfx12, IMAGE_GET_RESINFO, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 2475
  { IMAGE_GET_RESINFO_V1_V4_gfx12, IMAGE_GET_RESINFO, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 2476
  { IMAGE_GET_RESINFO_V2_V1_gfx12, IMAGE_GET_RESINFO, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 2477
  { IMAGE_GET_RESINFO_V2_V2_gfx12, IMAGE_GET_RESINFO, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 2478
  { IMAGE_GET_RESINFO_V2_V3_gfx12, IMAGE_GET_RESINFO, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 2479
  { IMAGE_GET_RESINFO_V2_V4_gfx12, IMAGE_GET_RESINFO, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 2480
  { IMAGE_GET_RESINFO_V3_V1_gfx12, IMAGE_GET_RESINFO, MIMGEncGfx12, 0x3, 0x1, 0x1 }, // 2481
  { IMAGE_GET_RESINFO_V3_V2_gfx12, IMAGE_GET_RESINFO, MIMGEncGfx12, 0x3, 0x2, 0x2 }, // 2482
  { IMAGE_GET_RESINFO_V3_V3_gfx12, IMAGE_GET_RESINFO, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 2483
  { IMAGE_GET_RESINFO_V3_V4_gfx12, IMAGE_GET_RESINFO, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 2484
  { IMAGE_GET_RESINFO_V4_V1_gfx12, IMAGE_GET_RESINFO, MIMGEncGfx12, 0x4, 0x1, 0x1 }, // 2485
  { IMAGE_GET_RESINFO_V4_V2_gfx12, IMAGE_GET_RESINFO, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 2486
  { IMAGE_GET_RESINFO_V4_V3_gfx12, IMAGE_GET_RESINFO, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 2487
  { IMAGE_GET_RESINFO_V4_V4_gfx12, IMAGE_GET_RESINFO, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 2488
  { IMAGE_GET_RESINFO_V5_V1_gfx12, IMAGE_GET_RESINFO, MIMGEncGfx12, 0x5, 0x1, 0x1 }, // 2489
  { IMAGE_GET_RESINFO_V5_V2_gfx12, IMAGE_GET_RESINFO, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 2490
  { IMAGE_GET_RESINFO_V5_V3_gfx12, IMAGE_GET_RESINFO, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 2491
  { IMAGE_GET_RESINFO_V5_V4_gfx12, IMAGE_GET_RESINFO, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 2492
  { IMAGE_GET_RESINFO_V1_V1, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 2493
  { IMAGE_GET_RESINFO_V1_V2, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 2494
  { IMAGE_GET_RESINFO_V1_V3, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 2495
  { IMAGE_GET_RESINFO_V1_V4, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 2496
  { IMAGE_GET_RESINFO_V2_V1, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 2497
  { IMAGE_GET_RESINFO_V2_V2, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 2498
  { IMAGE_GET_RESINFO_V2_V3, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 2499
  { IMAGE_GET_RESINFO_V2_V4, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 2500
  { IMAGE_GET_RESINFO_V3_V1, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x3, 0x1, 0x1 }, // 2501
  { IMAGE_GET_RESINFO_V3_V2, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 2502
  { IMAGE_GET_RESINFO_V3_V3, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 2503
  { IMAGE_GET_RESINFO_V3_V4, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 2504
  { IMAGE_GET_RESINFO_V4_V1, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 2505
  { IMAGE_GET_RESINFO_V4_V2, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 2506
  { IMAGE_GET_RESINFO_V4_V3, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 2507
  { IMAGE_GET_RESINFO_V4_V4, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 2508
  { IMAGE_GET_RESINFO_V5_V1, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x5, 0x1, 0x1 }, // 2509
  { IMAGE_GET_RESINFO_V5_V2, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 2510
  { IMAGE_GET_RESINFO_V5_V3, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 2511
  { IMAGE_GET_RESINFO_V5_V4, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 2512
  { IMAGE_GET_RESINFO_V1_V1_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 2513
  { IMAGE_GET_RESINFO_V1_V2_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 2514
  { IMAGE_GET_RESINFO_V1_V3_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 2515
  { IMAGE_GET_RESINFO_V1_V4_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 2516
  { IMAGE_GET_RESINFO_V2_V1_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 2517
  { IMAGE_GET_RESINFO_V2_V2_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 2518
  { IMAGE_GET_RESINFO_V2_V3_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 2519
  { IMAGE_GET_RESINFO_V2_V4_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 2520
  { IMAGE_GET_RESINFO_V3_V1_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x3, 0x1, 0x1 }, // 2521
  { IMAGE_GET_RESINFO_V3_V2_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x3, 0x2, 0x1 }, // 2522
  { IMAGE_GET_RESINFO_V3_V3_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x3, 0x3, 0x1 }, // 2523
  { IMAGE_GET_RESINFO_V3_V4_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x3, 0x4, 0x1 }, // 2524
  { IMAGE_GET_RESINFO_V4_V1_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x4, 0x1, 0x1 }, // 2525
  { IMAGE_GET_RESINFO_V4_V2_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x4, 0x2, 0x1 }, // 2526
  { IMAGE_GET_RESINFO_V4_V3_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x4, 0x3, 0x1 }, // 2527
  { IMAGE_GET_RESINFO_V4_V4_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x4, 0x4, 0x1 }, // 2528
  { IMAGE_GET_RESINFO_V5_V1_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x5, 0x1, 0x1 }, // 2529
  { IMAGE_GET_RESINFO_V5_V2_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x5, 0x2, 0x1 }, // 2530
  { IMAGE_GET_RESINFO_V5_V3_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x5, 0x3, 0x1 }, // 2531
  { IMAGE_GET_RESINFO_V5_V4_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x5, 0x4, 0x1 }, // 2532
  { IMAGE_LOAD_V1_V1_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 2533
  { IMAGE_LOAD_V1_V2_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 2534
  { IMAGE_LOAD_V1_V3_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 2535
  { IMAGE_LOAD_V1_V4_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 2536
  { IMAGE_LOAD_V2_V1_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 2537
  { IMAGE_LOAD_V2_V2_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 2538
  { IMAGE_LOAD_V2_V3_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 2539
  { IMAGE_LOAD_V2_V4_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 2540
  { IMAGE_LOAD_V3_V1_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x3, 0x1, 0x1 }, // 2541
  { IMAGE_LOAD_V3_V2_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 2542
  { IMAGE_LOAD_V3_V3_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 2543
  { IMAGE_LOAD_V3_V4_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 2544
  { IMAGE_LOAD_V4_V1_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 2545
  { IMAGE_LOAD_V4_V2_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 2546
  { IMAGE_LOAD_V4_V3_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 2547
  { IMAGE_LOAD_V4_V4_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 2548
  { IMAGE_LOAD_V5_V1_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x5, 0x1, 0x1 }, // 2549
  { IMAGE_LOAD_V5_V2_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 2550
  { IMAGE_LOAD_V5_V3_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 2551
  { IMAGE_LOAD_V5_V4_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 2552
  { IMAGE_LOAD_V1_V2_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 2553
  { IMAGE_LOAD_V1_V3_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 2554
  { IMAGE_LOAD_V1_V4_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 2555
  { IMAGE_LOAD_V2_V2_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 2556
  { IMAGE_LOAD_V2_V3_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 2557
  { IMAGE_LOAD_V2_V4_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 2558
  { IMAGE_LOAD_V3_V2_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 2559
  { IMAGE_LOAD_V3_V3_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 2560
  { IMAGE_LOAD_V3_V4_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 2561
  { IMAGE_LOAD_V4_V2_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 2562
  { IMAGE_LOAD_V4_V3_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 2563
  { IMAGE_LOAD_V4_V4_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 2564
  { IMAGE_LOAD_V5_V2_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 2565
  { IMAGE_LOAD_V5_V3_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 2566
  { IMAGE_LOAD_V5_V4_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 2567
  { IMAGE_LOAD_V1_V1_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 2568
  { IMAGE_LOAD_V1_V2_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 2569
  { IMAGE_LOAD_V1_V3_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 2570
  { IMAGE_LOAD_V1_V4_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 2571
  { IMAGE_LOAD_V2_V1_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 2572
  { IMAGE_LOAD_V2_V2_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 2573
  { IMAGE_LOAD_V2_V3_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 2574
  { IMAGE_LOAD_V2_V4_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 2575
  { IMAGE_LOAD_V3_V1_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x3, 0x1, 0x1 }, // 2576
  { IMAGE_LOAD_V3_V2_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 2577
  { IMAGE_LOAD_V3_V3_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 2578
  { IMAGE_LOAD_V3_V4_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 2579
  { IMAGE_LOAD_V4_V1_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 2580
  { IMAGE_LOAD_V4_V2_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 2581
  { IMAGE_LOAD_V4_V3_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 2582
  { IMAGE_LOAD_V4_V4_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 2583
  { IMAGE_LOAD_V5_V1_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x5, 0x1, 0x1 }, // 2584
  { IMAGE_LOAD_V5_V2_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 2585
  { IMAGE_LOAD_V5_V3_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 2586
  { IMAGE_LOAD_V5_V4_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 2587
  { IMAGE_LOAD_V1_V2_nsa_gfx11, IMAGE_LOAD, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 2588
  { IMAGE_LOAD_V1_V3_nsa_gfx11, IMAGE_LOAD, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 2589
  { IMAGE_LOAD_V1_V4_nsa_gfx11, IMAGE_LOAD, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 2590
  { IMAGE_LOAD_V2_V2_nsa_gfx11, IMAGE_LOAD, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 2591
  { IMAGE_LOAD_V2_V3_nsa_gfx11, IMAGE_LOAD, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 2592
  { IMAGE_LOAD_V2_V4_nsa_gfx11, IMAGE_LOAD, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 2593
  { IMAGE_LOAD_V3_V2_nsa_gfx11, IMAGE_LOAD, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 2594
  { IMAGE_LOAD_V3_V3_nsa_gfx11, IMAGE_LOAD, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 2595
  { IMAGE_LOAD_V3_V4_nsa_gfx11, IMAGE_LOAD, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 2596
  { IMAGE_LOAD_V4_V2_nsa_gfx11, IMAGE_LOAD, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 2597
  { IMAGE_LOAD_V4_V3_nsa_gfx11, IMAGE_LOAD, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 2598
  { IMAGE_LOAD_V4_V4_nsa_gfx11, IMAGE_LOAD, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 2599
  { IMAGE_LOAD_V5_V2_nsa_gfx11, IMAGE_LOAD, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 2600
  { IMAGE_LOAD_V5_V3_nsa_gfx11, IMAGE_LOAD, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 2601
  { IMAGE_LOAD_V5_V4_nsa_gfx11, IMAGE_LOAD, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 2602
  { IMAGE_LOAD_V1_V1_gfx12, IMAGE_LOAD, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 2603
  { IMAGE_LOAD_V1_V2_gfx12, IMAGE_LOAD, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 2604
  { IMAGE_LOAD_V1_V3_gfx12, IMAGE_LOAD, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 2605
  { IMAGE_LOAD_V1_V4_gfx12, IMAGE_LOAD, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 2606
  { IMAGE_LOAD_V2_V1_gfx12, IMAGE_LOAD, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 2607
  { IMAGE_LOAD_V2_V2_gfx12, IMAGE_LOAD, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 2608
  { IMAGE_LOAD_V2_V3_gfx12, IMAGE_LOAD, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 2609
  { IMAGE_LOAD_V2_V4_gfx12, IMAGE_LOAD, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 2610
  { IMAGE_LOAD_V3_V1_gfx12, IMAGE_LOAD, MIMGEncGfx12, 0x3, 0x1, 0x1 }, // 2611
  { IMAGE_LOAD_V3_V2_gfx12, IMAGE_LOAD, MIMGEncGfx12, 0x3, 0x2, 0x2 }, // 2612
  { IMAGE_LOAD_V3_V3_gfx12, IMAGE_LOAD, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 2613
  { IMAGE_LOAD_V3_V4_gfx12, IMAGE_LOAD, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 2614
  { IMAGE_LOAD_V4_V1_gfx12, IMAGE_LOAD, MIMGEncGfx12, 0x4, 0x1, 0x1 }, // 2615
  { IMAGE_LOAD_V4_V2_gfx12, IMAGE_LOAD, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 2616
  { IMAGE_LOAD_V4_V3_gfx12, IMAGE_LOAD, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 2617
  { IMAGE_LOAD_V4_V4_gfx12, IMAGE_LOAD, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 2618
  { IMAGE_LOAD_V5_V1_gfx12, IMAGE_LOAD, MIMGEncGfx12, 0x5, 0x1, 0x1 }, // 2619
  { IMAGE_LOAD_V5_V2_gfx12, IMAGE_LOAD, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 2620
  { IMAGE_LOAD_V5_V3_gfx12, IMAGE_LOAD, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 2621
  { IMAGE_LOAD_V5_V4_gfx12, IMAGE_LOAD, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 2622
  { IMAGE_LOAD_V1_V1, IMAGE_LOAD, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 2623
  { IMAGE_LOAD_V1_V2, IMAGE_LOAD, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 2624
  { IMAGE_LOAD_V1_V3, IMAGE_LOAD, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 2625
  { IMAGE_LOAD_V1_V4, IMAGE_LOAD, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 2626
  { IMAGE_LOAD_V2_V1, IMAGE_LOAD, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 2627
  { IMAGE_LOAD_V2_V2, IMAGE_LOAD, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 2628
  { IMAGE_LOAD_V2_V3, IMAGE_LOAD, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 2629
  { IMAGE_LOAD_V2_V4, IMAGE_LOAD, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 2630
  { IMAGE_LOAD_V3_V1, IMAGE_LOAD, MIMGEncGfx6, 0x3, 0x1, 0x1 }, // 2631
  { IMAGE_LOAD_V3_V2, IMAGE_LOAD, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 2632
  { IMAGE_LOAD_V3_V3, IMAGE_LOAD, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 2633
  { IMAGE_LOAD_V3_V4, IMAGE_LOAD, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 2634
  { IMAGE_LOAD_V4_V1, IMAGE_LOAD, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 2635
  { IMAGE_LOAD_V4_V2, IMAGE_LOAD, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 2636
  { IMAGE_LOAD_V4_V3, IMAGE_LOAD, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 2637
  { IMAGE_LOAD_V4_V4, IMAGE_LOAD, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 2638
  { IMAGE_LOAD_V5_V1, IMAGE_LOAD, MIMGEncGfx6, 0x5, 0x1, 0x1 }, // 2639
  { IMAGE_LOAD_V5_V2, IMAGE_LOAD, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 2640
  { IMAGE_LOAD_V5_V3, IMAGE_LOAD, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 2641
  { IMAGE_LOAD_V5_V4, IMAGE_LOAD, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 2642
  { IMAGE_LOAD_V1_V1_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 2643
  { IMAGE_LOAD_V1_V2_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 2644
  { IMAGE_LOAD_V1_V3_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 2645
  { IMAGE_LOAD_V1_V4_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 2646
  { IMAGE_LOAD_V2_V1_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 2647
  { IMAGE_LOAD_V2_V2_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 2648
  { IMAGE_LOAD_V2_V3_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 2649
  { IMAGE_LOAD_V2_V4_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 2650
  { IMAGE_LOAD_V3_V1_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x3, 0x1, 0x1 }, // 2651
  { IMAGE_LOAD_V3_V2_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x3, 0x2, 0x1 }, // 2652
  { IMAGE_LOAD_V3_V3_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x3, 0x3, 0x1 }, // 2653
  { IMAGE_LOAD_V3_V4_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x3, 0x4, 0x1 }, // 2654
  { IMAGE_LOAD_V4_V1_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x4, 0x1, 0x1 }, // 2655
  { IMAGE_LOAD_V4_V2_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x4, 0x2, 0x1 }, // 2656
  { IMAGE_LOAD_V4_V3_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x4, 0x3, 0x1 }, // 2657
  { IMAGE_LOAD_V4_V4_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x4, 0x4, 0x1 }, // 2658
  { IMAGE_LOAD_V5_V1_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x5, 0x1, 0x1 }, // 2659
  { IMAGE_LOAD_V5_V2_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x5, 0x2, 0x1 }, // 2660
  { IMAGE_LOAD_V5_V3_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x5, 0x3, 0x1 }, // 2661
  { IMAGE_LOAD_V5_V4_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x5, 0x4, 0x1 }, // 2662
  { IMAGE_LOAD_MIP_V1_V1_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 2663
  { IMAGE_LOAD_MIP_V1_V2_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 2664
  { IMAGE_LOAD_MIP_V1_V3_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 2665
  { IMAGE_LOAD_MIP_V1_V4_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 2666
  { IMAGE_LOAD_MIP_V2_V1_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 2667
  { IMAGE_LOAD_MIP_V2_V2_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 2668
  { IMAGE_LOAD_MIP_V2_V3_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 2669
  { IMAGE_LOAD_MIP_V2_V4_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 2670
  { IMAGE_LOAD_MIP_V3_V1_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x3, 0x1, 0x1 }, // 2671
  { IMAGE_LOAD_MIP_V3_V2_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 2672
  { IMAGE_LOAD_MIP_V3_V3_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 2673
  { IMAGE_LOAD_MIP_V3_V4_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 2674
  { IMAGE_LOAD_MIP_V4_V1_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 2675
  { IMAGE_LOAD_MIP_V4_V2_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 2676
  { IMAGE_LOAD_MIP_V4_V3_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 2677
  { IMAGE_LOAD_MIP_V4_V4_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 2678
  { IMAGE_LOAD_MIP_V5_V1_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x5, 0x1, 0x1 }, // 2679
  { IMAGE_LOAD_MIP_V5_V2_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 2680
  { IMAGE_LOAD_MIP_V5_V3_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 2681
  { IMAGE_LOAD_MIP_V5_V4_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 2682
  { IMAGE_LOAD_MIP_V1_V2_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 2683
  { IMAGE_LOAD_MIP_V1_V3_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 2684
  { IMAGE_LOAD_MIP_V1_V4_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 2685
  { IMAGE_LOAD_MIP_V2_V2_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 2686
  { IMAGE_LOAD_MIP_V2_V3_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 2687
  { IMAGE_LOAD_MIP_V2_V4_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 2688
  { IMAGE_LOAD_MIP_V3_V2_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 2689
  { IMAGE_LOAD_MIP_V3_V3_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 2690
  { IMAGE_LOAD_MIP_V3_V4_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 2691
  { IMAGE_LOAD_MIP_V4_V2_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 2692
  { IMAGE_LOAD_MIP_V4_V3_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 2693
  { IMAGE_LOAD_MIP_V4_V4_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 2694
  { IMAGE_LOAD_MIP_V5_V2_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 2695
  { IMAGE_LOAD_MIP_V5_V3_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 2696
  { IMAGE_LOAD_MIP_V5_V4_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 2697
  { IMAGE_LOAD_MIP_V1_V1_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 2698
  { IMAGE_LOAD_MIP_V1_V2_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 2699
  { IMAGE_LOAD_MIP_V1_V3_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 2700
  { IMAGE_LOAD_MIP_V1_V4_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 2701
  { IMAGE_LOAD_MIP_V2_V1_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 2702
  { IMAGE_LOAD_MIP_V2_V2_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 2703
  { IMAGE_LOAD_MIP_V2_V3_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 2704
  { IMAGE_LOAD_MIP_V2_V4_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 2705
  { IMAGE_LOAD_MIP_V3_V1_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x3, 0x1, 0x1 }, // 2706
  { IMAGE_LOAD_MIP_V3_V2_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 2707
  { IMAGE_LOAD_MIP_V3_V3_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 2708
  { IMAGE_LOAD_MIP_V3_V4_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 2709
  { IMAGE_LOAD_MIP_V4_V1_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 2710
  { IMAGE_LOAD_MIP_V4_V2_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 2711
  { IMAGE_LOAD_MIP_V4_V3_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 2712
  { IMAGE_LOAD_MIP_V4_V4_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 2713
  { IMAGE_LOAD_MIP_V5_V1_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x5, 0x1, 0x1 }, // 2714
  { IMAGE_LOAD_MIP_V5_V2_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 2715
  { IMAGE_LOAD_MIP_V5_V3_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 2716
  { IMAGE_LOAD_MIP_V5_V4_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 2717
  { IMAGE_LOAD_MIP_V1_V2_nsa_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 2718
  { IMAGE_LOAD_MIP_V1_V3_nsa_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 2719
  { IMAGE_LOAD_MIP_V1_V4_nsa_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 2720
  { IMAGE_LOAD_MIP_V2_V2_nsa_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 2721
  { IMAGE_LOAD_MIP_V2_V3_nsa_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 2722
  { IMAGE_LOAD_MIP_V2_V4_nsa_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 2723
  { IMAGE_LOAD_MIP_V3_V2_nsa_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 2724
  { IMAGE_LOAD_MIP_V3_V3_nsa_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 2725
  { IMAGE_LOAD_MIP_V3_V4_nsa_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 2726
  { IMAGE_LOAD_MIP_V4_V2_nsa_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 2727
  { IMAGE_LOAD_MIP_V4_V3_nsa_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 2728
  { IMAGE_LOAD_MIP_V4_V4_nsa_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 2729
  { IMAGE_LOAD_MIP_V5_V2_nsa_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 2730
  { IMAGE_LOAD_MIP_V5_V3_nsa_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 2731
  { IMAGE_LOAD_MIP_V5_V4_nsa_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 2732
  { IMAGE_LOAD_MIP_V1_V1_gfx12, IMAGE_LOAD_MIP, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 2733
  { IMAGE_LOAD_MIP_V1_V2_gfx12, IMAGE_LOAD_MIP, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 2734
  { IMAGE_LOAD_MIP_V1_V3_gfx12, IMAGE_LOAD_MIP, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 2735
  { IMAGE_LOAD_MIP_V1_V4_gfx12, IMAGE_LOAD_MIP, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 2736
  { IMAGE_LOAD_MIP_V2_V1_gfx12, IMAGE_LOAD_MIP, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 2737
  { IMAGE_LOAD_MIP_V2_V2_gfx12, IMAGE_LOAD_MIP, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 2738
  { IMAGE_LOAD_MIP_V2_V3_gfx12, IMAGE_LOAD_MIP, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 2739
  { IMAGE_LOAD_MIP_V2_V4_gfx12, IMAGE_LOAD_MIP, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 2740
  { IMAGE_LOAD_MIP_V3_V1_gfx12, IMAGE_LOAD_MIP, MIMGEncGfx12, 0x3, 0x1, 0x1 }, // 2741
  { IMAGE_LOAD_MIP_V3_V2_gfx12, IMAGE_LOAD_MIP, MIMGEncGfx12, 0x3, 0x2, 0x2 }, // 2742
  { IMAGE_LOAD_MIP_V3_V3_gfx12, IMAGE_LOAD_MIP, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 2743
  { IMAGE_LOAD_MIP_V3_V4_gfx12, IMAGE_LOAD_MIP, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 2744
  { IMAGE_LOAD_MIP_V4_V1_gfx12, IMAGE_LOAD_MIP, MIMGEncGfx12, 0x4, 0x1, 0x1 }, // 2745
  { IMAGE_LOAD_MIP_V4_V2_gfx12, IMAGE_LOAD_MIP, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 2746
  { IMAGE_LOAD_MIP_V4_V3_gfx12, IMAGE_LOAD_MIP, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 2747
  { IMAGE_LOAD_MIP_V4_V4_gfx12, IMAGE_LOAD_MIP, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 2748
  { IMAGE_LOAD_MIP_V5_V1_gfx12, IMAGE_LOAD_MIP, MIMGEncGfx12, 0x5, 0x1, 0x1 }, // 2749
  { IMAGE_LOAD_MIP_V5_V2_gfx12, IMAGE_LOAD_MIP, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 2750
  { IMAGE_LOAD_MIP_V5_V3_gfx12, IMAGE_LOAD_MIP, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 2751
  { IMAGE_LOAD_MIP_V5_V4_gfx12, IMAGE_LOAD_MIP, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 2752
  { IMAGE_LOAD_MIP_V1_V1, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 2753
  { IMAGE_LOAD_MIP_V1_V2, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 2754
  { IMAGE_LOAD_MIP_V1_V3, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 2755
  { IMAGE_LOAD_MIP_V1_V4, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 2756
  { IMAGE_LOAD_MIP_V2_V1, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 2757
  { IMAGE_LOAD_MIP_V2_V2, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 2758
  { IMAGE_LOAD_MIP_V2_V3, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 2759
  { IMAGE_LOAD_MIP_V2_V4, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 2760
  { IMAGE_LOAD_MIP_V3_V1, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x3, 0x1, 0x1 }, // 2761
  { IMAGE_LOAD_MIP_V3_V2, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 2762
  { IMAGE_LOAD_MIP_V3_V3, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 2763
  { IMAGE_LOAD_MIP_V3_V4, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 2764
  { IMAGE_LOAD_MIP_V4_V1, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 2765
  { IMAGE_LOAD_MIP_V4_V2, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 2766
  { IMAGE_LOAD_MIP_V4_V3, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 2767
  { IMAGE_LOAD_MIP_V4_V4, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 2768
  { IMAGE_LOAD_MIP_V5_V1, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x5, 0x1, 0x1 }, // 2769
  { IMAGE_LOAD_MIP_V5_V2, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 2770
  { IMAGE_LOAD_MIP_V5_V3, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 2771
  { IMAGE_LOAD_MIP_V5_V4, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 2772
  { IMAGE_LOAD_MIP_V1_V1_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 2773
  { IMAGE_LOAD_MIP_V1_V2_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 2774
  { IMAGE_LOAD_MIP_V1_V3_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 2775
  { IMAGE_LOAD_MIP_V1_V4_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 2776
  { IMAGE_LOAD_MIP_V2_V1_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 2777
  { IMAGE_LOAD_MIP_V2_V2_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 2778
  { IMAGE_LOAD_MIP_V2_V3_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 2779
  { IMAGE_LOAD_MIP_V2_V4_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 2780
  { IMAGE_LOAD_MIP_V3_V1_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x3, 0x1, 0x1 }, // 2781
  { IMAGE_LOAD_MIP_V3_V2_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x3, 0x2, 0x1 }, // 2782
  { IMAGE_LOAD_MIP_V3_V3_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x3, 0x3, 0x1 }, // 2783
  { IMAGE_LOAD_MIP_V3_V4_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x3, 0x4, 0x1 }, // 2784
  { IMAGE_LOAD_MIP_V4_V1_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x4, 0x1, 0x1 }, // 2785
  { IMAGE_LOAD_MIP_V4_V2_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x4, 0x2, 0x1 }, // 2786
  { IMAGE_LOAD_MIP_V4_V3_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x4, 0x3, 0x1 }, // 2787
  { IMAGE_LOAD_MIP_V4_V4_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x4, 0x4, 0x1 }, // 2788
  { IMAGE_LOAD_MIP_V5_V1_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x5, 0x1, 0x1 }, // 2789
  { IMAGE_LOAD_MIP_V5_V2_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x5, 0x2, 0x1 }, // 2790
  { IMAGE_LOAD_MIP_V5_V3_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x5, 0x3, 0x1 }, // 2791
  { IMAGE_LOAD_MIP_V5_V4_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x5, 0x4, 0x1 }, // 2792
  { IMAGE_LOAD_MIP_PCK_V1_V1_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 2793
  { IMAGE_LOAD_MIP_PCK_V1_V2_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 2794
  { IMAGE_LOAD_MIP_PCK_V1_V3_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 2795
  { IMAGE_LOAD_MIP_PCK_V1_V4_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 2796
  { IMAGE_LOAD_MIP_PCK_V2_V1_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 2797
  { IMAGE_LOAD_MIP_PCK_V2_V2_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 2798
  { IMAGE_LOAD_MIP_PCK_V2_V3_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 2799
  { IMAGE_LOAD_MIP_PCK_V2_V4_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 2800
  { IMAGE_LOAD_MIP_PCK_V3_V1_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x3, 0x1, 0x1 }, // 2801
  { IMAGE_LOAD_MIP_PCK_V3_V2_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 2802
  { IMAGE_LOAD_MIP_PCK_V3_V3_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 2803
  { IMAGE_LOAD_MIP_PCK_V3_V4_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 2804
  { IMAGE_LOAD_MIP_PCK_V4_V1_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 2805
  { IMAGE_LOAD_MIP_PCK_V4_V2_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 2806
  { IMAGE_LOAD_MIP_PCK_V4_V3_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 2807
  { IMAGE_LOAD_MIP_PCK_V4_V4_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 2808
  { IMAGE_LOAD_MIP_PCK_V5_V1_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x5, 0x1, 0x1 }, // 2809
  { IMAGE_LOAD_MIP_PCK_V5_V2_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 2810
  { IMAGE_LOAD_MIP_PCK_V5_V3_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 2811
  { IMAGE_LOAD_MIP_PCK_V5_V4_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 2812
  { IMAGE_LOAD_MIP_PCK_V1_V2_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 2813
  { IMAGE_LOAD_MIP_PCK_V1_V3_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 2814
  { IMAGE_LOAD_MIP_PCK_V1_V4_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 2815
  { IMAGE_LOAD_MIP_PCK_V2_V2_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 2816
  { IMAGE_LOAD_MIP_PCK_V2_V3_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 2817
  { IMAGE_LOAD_MIP_PCK_V2_V4_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 2818
  { IMAGE_LOAD_MIP_PCK_V3_V2_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 2819
  { IMAGE_LOAD_MIP_PCK_V3_V3_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 2820
  { IMAGE_LOAD_MIP_PCK_V3_V4_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 2821
  { IMAGE_LOAD_MIP_PCK_V4_V2_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 2822
  { IMAGE_LOAD_MIP_PCK_V4_V3_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 2823
  { IMAGE_LOAD_MIP_PCK_V4_V4_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 2824
  { IMAGE_LOAD_MIP_PCK_V5_V2_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 2825
  { IMAGE_LOAD_MIP_PCK_V5_V3_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 2826
  { IMAGE_LOAD_MIP_PCK_V5_V4_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 2827
  { IMAGE_LOAD_MIP_PCK_V1_V1_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 2828
  { IMAGE_LOAD_MIP_PCK_V1_V2_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 2829
  { IMAGE_LOAD_MIP_PCK_V1_V3_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 2830
  { IMAGE_LOAD_MIP_PCK_V1_V4_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 2831
  { IMAGE_LOAD_MIP_PCK_V2_V1_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 2832
  { IMAGE_LOAD_MIP_PCK_V2_V2_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 2833
  { IMAGE_LOAD_MIP_PCK_V2_V3_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 2834
  { IMAGE_LOAD_MIP_PCK_V2_V4_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 2835
  { IMAGE_LOAD_MIP_PCK_V3_V1_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x3, 0x1, 0x1 }, // 2836
  { IMAGE_LOAD_MIP_PCK_V3_V2_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 2837
  { IMAGE_LOAD_MIP_PCK_V3_V3_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 2838
  { IMAGE_LOAD_MIP_PCK_V3_V4_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 2839
  { IMAGE_LOAD_MIP_PCK_V4_V1_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 2840
  { IMAGE_LOAD_MIP_PCK_V4_V2_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 2841
  { IMAGE_LOAD_MIP_PCK_V4_V3_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 2842
  { IMAGE_LOAD_MIP_PCK_V4_V4_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 2843
  { IMAGE_LOAD_MIP_PCK_V5_V1_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x5, 0x1, 0x1 }, // 2844
  { IMAGE_LOAD_MIP_PCK_V5_V2_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 2845
  { IMAGE_LOAD_MIP_PCK_V5_V3_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 2846
  { IMAGE_LOAD_MIP_PCK_V5_V4_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 2847
  { IMAGE_LOAD_MIP_PCK_V1_V2_nsa_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 2848
  { IMAGE_LOAD_MIP_PCK_V1_V3_nsa_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 2849
  { IMAGE_LOAD_MIP_PCK_V1_V4_nsa_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 2850
  { IMAGE_LOAD_MIP_PCK_V2_V2_nsa_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 2851
  { IMAGE_LOAD_MIP_PCK_V2_V3_nsa_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 2852
  { IMAGE_LOAD_MIP_PCK_V2_V4_nsa_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 2853
  { IMAGE_LOAD_MIP_PCK_V3_V2_nsa_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 2854
  { IMAGE_LOAD_MIP_PCK_V3_V3_nsa_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 2855
  { IMAGE_LOAD_MIP_PCK_V3_V4_nsa_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 2856
  { IMAGE_LOAD_MIP_PCK_V4_V2_nsa_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 2857
  { IMAGE_LOAD_MIP_PCK_V4_V3_nsa_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 2858
  { IMAGE_LOAD_MIP_PCK_V4_V4_nsa_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 2859
  { IMAGE_LOAD_MIP_PCK_V5_V2_nsa_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 2860
  { IMAGE_LOAD_MIP_PCK_V5_V3_nsa_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 2861
  { IMAGE_LOAD_MIP_PCK_V5_V4_nsa_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 2862
  { IMAGE_LOAD_MIP_PCK_V1_V1_gfx12, IMAGE_LOAD_MIP_PCK, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 2863
  { IMAGE_LOAD_MIP_PCK_V1_V2_gfx12, IMAGE_LOAD_MIP_PCK, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 2864
  { IMAGE_LOAD_MIP_PCK_V1_V3_gfx12, IMAGE_LOAD_MIP_PCK, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 2865
  { IMAGE_LOAD_MIP_PCK_V1_V4_gfx12, IMAGE_LOAD_MIP_PCK, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 2866
  { IMAGE_LOAD_MIP_PCK_V2_V1_gfx12, IMAGE_LOAD_MIP_PCK, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 2867
  { IMAGE_LOAD_MIP_PCK_V2_V2_gfx12, IMAGE_LOAD_MIP_PCK, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 2868
  { IMAGE_LOAD_MIP_PCK_V2_V3_gfx12, IMAGE_LOAD_MIP_PCK, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 2869
  { IMAGE_LOAD_MIP_PCK_V2_V4_gfx12, IMAGE_LOAD_MIP_PCK, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 2870
  { IMAGE_LOAD_MIP_PCK_V3_V1_gfx12, IMAGE_LOAD_MIP_PCK, MIMGEncGfx12, 0x3, 0x1, 0x1 }, // 2871
  { IMAGE_LOAD_MIP_PCK_V3_V2_gfx12, IMAGE_LOAD_MIP_PCK, MIMGEncGfx12, 0x3, 0x2, 0x2 }, // 2872
  { IMAGE_LOAD_MIP_PCK_V3_V3_gfx12, IMAGE_LOAD_MIP_PCK, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 2873
  { IMAGE_LOAD_MIP_PCK_V3_V4_gfx12, IMAGE_LOAD_MIP_PCK, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 2874
  { IMAGE_LOAD_MIP_PCK_V4_V1_gfx12, IMAGE_LOAD_MIP_PCK, MIMGEncGfx12, 0x4, 0x1, 0x1 }, // 2875
  { IMAGE_LOAD_MIP_PCK_V4_V2_gfx12, IMAGE_LOAD_MIP_PCK, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 2876
  { IMAGE_LOAD_MIP_PCK_V4_V3_gfx12, IMAGE_LOAD_MIP_PCK, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 2877
  { IMAGE_LOAD_MIP_PCK_V4_V4_gfx12, IMAGE_LOAD_MIP_PCK, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 2878
  { IMAGE_LOAD_MIP_PCK_V5_V1_gfx12, IMAGE_LOAD_MIP_PCK, MIMGEncGfx12, 0x5, 0x1, 0x1 }, // 2879
  { IMAGE_LOAD_MIP_PCK_V5_V2_gfx12, IMAGE_LOAD_MIP_PCK, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 2880
  { IMAGE_LOAD_MIP_PCK_V5_V3_gfx12, IMAGE_LOAD_MIP_PCK, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 2881
  { IMAGE_LOAD_MIP_PCK_V5_V4_gfx12, IMAGE_LOAD_MIP_PCK, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 2882
  { IMAGE_LOAD_MIP_PCK_V1_V1, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 2883
  { IMAGE_LOAD_MIP_PCK_V1_V2, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 2884
  { IMAGE_LOAD_MIP_PCK_V1_V3, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 2885
  { IMAGE_LOAD_MIP_PCK_V1_V4, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 2886
  { IMAGE_LOAD_MIP_PCK_V2_V1, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 2887
  { IMAGE_LOAD_MIP_PCK_V2_V2, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 2888
  { IMAGE_LOAD_MIP_PCK_V2_V3, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 2889
  { IMAGE_LOAD_MIP_PCK_V2_V4, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 2890
  { IMAGE_LOAD_MIP_PCK_V3_V1, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x3, 0x1, 0x1 }, // 2891
  { IMAGE_LOAD_MIP_PCK_V3_V2, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 2892
  { IMAGE_LOAD_MIP_PCK_V3_V3, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 2893
  { IMAGE_LOAD_MIP_PCK_V3_V4, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 2894
  { IMAGE_LOAD_MIP_PCK_V4_V1, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 2895
  { IMAGE_LOAD_MIP_PCK_V4_V2, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 2896
  { IMAGE_LOAD_MIP_PCK_V4_V3, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 2897
  { IMAGE_LOAD_MIP_PCK_V4_V4, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 2898
  { IMAGE_LOAD_MIP_PCK_V5_V1, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x5, 0x1, 0x1 }, // 2899
  { IMAGE_LOAD_MIP_PCK_V5_V2, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 2900
  { IMAGE_LOAD_MIP_PCK_V5_V3, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 2901
  { IMAGE_LOAD_MIP_PCK_V5_V4, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 2902
  { IMAGE_LOAD_MIP_PCK_V1_V1_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 2903
  { IMAGE_LOAD_MIP_PCK_V1_V2_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 2904
  { IMAGE_LOAD_MIP_PCK_V1_V3_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 2905
  { IMAGE_LOAD_MIP_PCK_V1_V4_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 2906
  { IMAGE_LOAD_MIP_PCK_V2_V1_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 2907
  { IMAGE_LOAD_MIP_PCK_V2_V2_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 2908
  { IMAGE_LOAD_MIP_PCK_V2_V3_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 2909
  { IMAGE_LOAD_MIP_PCK_V2_V4_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 2910
  { IMAGE_LOAD_MIP_PCK_V3_V1_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x3, 0x1, 0x1 }, // 2911
  { IMAGE_LOAD_MIP_PCK_V3_V2_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x3, 0x2, 0x1 }, // 2912
  { IMAGE_LOAD_MIP_PCK_V3_V3_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x3, 0x3, 0x1 }, // 2913
  { IMAGE_LOAD_MIP_PCK_V3_V4_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x3, 0x4, 0x1 }, // 2914
  { IMAGE_LOAD_MIP_PCK_V4_V1_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x4, 0x1, 0x1 }, // 2915
  { IMAGE_LOAD_MIP_PCK_V4_V2_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x4, 0x2, 0x1 }, // 2916
  { IMAGE_LOAD_MIP_PCK_V4_V3_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x4, 0x3, 0x1 }, // 2917
  { IMAGE_LOAD_MIP_PCK_V4_V4_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x4, 0x4, 0x1 }, // 2918
  { IMAGE_LOAD_MIP_PCK_V5_V1_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x5, 0x1, 0x1 }, // 2919
  { IMAGE_LOAD_MIP_PCK_V5_V2_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x5, 0x2, 0x1 }, // 2920
  { IMAGE_LOAD_MIP_PCK_V5_V3_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x5, 0x3, 0x1 }, // 2921
  { IMAGE_LOAD_MIP_PCK_V5_V4_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x5, 0x4, 0x1 }, // 2922
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V1_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 2923
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V2_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 2924
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V3_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 2925
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V4_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 2926
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V1_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 2927
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V2_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 2928
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V3_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 2929
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V4_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 2930
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V1_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x3, 0x1, 0x1 }, // 2931
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V2_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 2932
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V3_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 2933
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V4_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 2934
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V1_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 2935
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V2_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 2936
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V3_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 2937
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V4_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 2938
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V1_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x5, 0x1, 0x1 }, // 2939
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V2_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 2940
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V3_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 2941
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V4_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 2942
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V2_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 2943
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V3_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 2944
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V4_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 2945
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V2_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 2946
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V3_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 2947
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V4_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 2948
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V2_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 2949
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V3_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 2950
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V4_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 2951
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V2_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 2952
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V3_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 2953
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V4_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 2954
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V2_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 2955
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V3_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 2956
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V4_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 2957
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V1_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 2958
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V2_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 2959
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V3_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 2960
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V4_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 2961
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V1_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 2962
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V2_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 2963
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V3_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 2964
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V4_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 2965
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V1_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x3, 0x1, 0x1 }, // 2966
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V2_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 2967
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V3_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 2968
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V4_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 2969
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V1_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 2970
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V2_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 2971
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V3_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 2972
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V4_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 2973
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V1_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x5, 0x1, 0x1 }, // 2974
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V2_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 2975
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V3_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 2976
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V4_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 2977
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V2_nsa_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 2978
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V3_nsa_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 2979
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V4_nsa_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 2980
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V2_nsa_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 2981
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V3_nsa_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 2982
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V4_nsa_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 2983
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V2_nsa_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 2984
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V3_nsa_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 2985
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V4_nsa_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 2986
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V2_nsa_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 2987
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V3_nsa_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 2988
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V4_nsa_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 2989
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V2_nsa_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 2990
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V3_nsa_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 2991
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V4_nsa_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 2992
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V1_gfx12, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 2993
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V2_gfx12, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 2994
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V3_gfx12, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 2995
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V4_gfx12, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 2996
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V1_gfx12, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 2997
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V2_gfx12, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 2998
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V3_gfx12, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 2999
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V4_gfx12, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 3000
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V1_gfx12, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx12, 0x3, 0x1, 0x1 }, // 3001
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V2_gfx12, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx12, 0x3, 0x2, 0x2 }, // 3002
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V3_gfx12, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 3003
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V4_gfx12, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 3004
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V1_gfx12, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx12, 0x4, 0x1, 0x1 }, // 3005
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V2_gfx12, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 3006
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V3_gfx12, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 3007
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V4_gfx12, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 3008
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V1_gfx12, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx12, 0x5, 0x1, 0x1 }, // 3009
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V2_gfx12, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 3010
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V3_gfx12, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 3011
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V4_gfx12, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 3012
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V1, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 3013
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V2, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 3014
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V3, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 3015
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V4, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 3016
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V1, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 3017
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V2, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 3018
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V3, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 3019
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V4, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 3020
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V1, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x3, 0x1, 0x1 }, // 3021
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V2, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 3022
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V3, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 3023
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V4, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 3024
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V1, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 3025
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V2, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 3026
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V3, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 3027
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V4, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 3028
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V1, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x5, 0x1, 0x1 }, // 3029
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V2, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 3030
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V3, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 3031
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V4, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 3032
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V1_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 3033
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V2_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 3034
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V3_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 3035
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V4_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 3036
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V1_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 3037
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V2_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 3038
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V3_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 3039
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V4_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 3040
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V1_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x3, 0x1, 0x1 }, // 3041
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V2_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x3, 0x2, 0x1 }, // 3042
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V3_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x3, 0x3, 0x1 }, // 3043
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V4_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x3, 0x4, 0x1 }, // 3044
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V1_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x4, 0x1, 0x1 }, // 3045
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V2_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x4, 0x2, 0x1 }, // 3046
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V3_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x4, 0x3, 0x1 }, // 3047
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V4_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x4, 0x4, 0x1 }, // 3048
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V1_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x5, 0x1, 0x1 }, // 3049
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V2_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x5, 0x2, 0x1 }, // 3050
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V3_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x5, 0x3, 0x1 }, // 3051
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V4_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x5, 0x4, 0x1 }, // 3052
  { IMAGE_LOAD_PCK_V1_V1_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 3053
  { IMAGE_LOAD_PCK_V1_V2_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 3054
  { IMAGE_LOAD_PCK_V1_V3_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 3055
  { IMAGE_LOAD_PCK_V1_V4_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 3056
  { IMAGE_LOAD_PCK_V2_V1_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 3057
  { IMAGE_LOAD_PCK_V2_V2_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 3058
  { IMAGE_LOAD_PCK_V2_V3_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 3059
  { IMAGE_LOAD_PCK_V2_V4_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 3060
  { IMAGE_LOAD_PCK_V3_V1_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x3, 0x1, 0x1 }, // 3061
  { IMAGE_LOAD_PCK_V3_V2_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 3062
  { IMAGE_LOAD_PCK_V3_V3_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 3063
  { IMAGE_LOAD_PCK_V3_V4_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 3064
  { IMAGE_LOAD_PCK_V4_V1_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 3065
  { IMAGE_LOAD_PCK_V4_V2_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 3066
  { IMAGE_LOAD_PCK_V4_V3_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 3067
  { IMAGE_LOAD_PCK_V4_V4_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 3068
  { IMAGE_LOAD_PCK_V5_V1_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x5, 0x1, 0x1 }, // 3069
  { IMAGE_LOAD_PCK_V5_V2_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 3070
  { IMAGE_LOAD_PCK_V5_V3_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 3071
  { IMAGE_LOAD_PCK_V5_V4_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 3072
  { IMAGE_LOAD_PCK_V1_V2_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 3073
  { IMAGE_LOAD_PCK_V1_V3_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 3074
  { IMAGE_LOAD_PCK_V1_V4_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 3075
  { IMAGE_LOAD_PCK_V2_V2_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 3076
  { IMAGE_LOAD_PCK_V2_V3_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 3077
  { IMAGE_LOAD_PCK_V2_V4_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 3078
  { IMAGE_LOAD_PCK_V3_V2_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 3079
  { IMAGE_LOAD_PCK_V3_V3_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 3080
  { IMAGE_LOAD_PCK_V3_V4_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 3081
  { IMAGE_LOAD_PCK_V4_V2_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 3082
  { IMAGE_LOAD_PCK_V4_V3_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 3083
  { IMAGE_LOAD_PCK_V4_V4_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 3084
  { IMAGE_LOAD_PCK_V5_V2_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 3085
  { IMAGE_LOAD_PCK_V5_V3_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 3086
  { IMAGE_LOAD_PCK_V5_V4_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 3087
  { IMAGE_LOAD_PCK_V1_V1_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 3088
  { IMAGE_LOAD_PCK_V1_V2_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 3089
  { IMAGE_LOAD_PCK_V1_V3_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 3090
  { IMAGE_LOAD_PCK_V1_V4_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 3091
  { IMAGE_LOAD_PCK_V2_V1_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 3092
  { IMAGE_LOAD_PCK_V2_V2_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 3093
  { IMAGE_LOAD_PCK_V2_V3_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 3094
  { IMAGE_LOAD_PCK_V2_V4_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 3095
  { IMAGE_LOAD_PCK_V3_V1_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x3, 0x1, 0x1 }, // 3096
  { IMAGE_LOAD_PCK_V3_V2_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 3097
  { IMAGE_LOAD_PCK_V3_V3_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 3098
  { IMAGE_LOAD_PCK_V3_V4_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 3099
  { IMAGE_LOAD_PCK_V4_V1_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 3100
  { IMAGE_LOAD_PCK_V4_V2_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 3101
  { IMAGE_LOAD_PCK_V4_V3_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 3102
  { IMAGE_LOAD_PCK_V4_V4_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 3103
  { IMAGE_LOAD_PCK_V5_V1_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x5, 0x1, 0x1 }, // 3104
  { IMAGE_LOAD_PCK_V5_V2_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 3105
  { IMAGE_LOAD_PCK_V5_V3_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 3106
  { IMAGE_LOAD_PCK_V5_V4_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 3107
  { IMAGE_LOAD_PCK_V1_V2_nsa_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 3108
  { IMAGE_LOAD_PCK_V1_V3_nsa_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 3109
  { IMAGE_LOAD_PCK_V1_V4_nsa_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 3110
  { IMAGE_LOAD_PCK_V2_V2_nsa_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 3111
  { IMAGE_LOAD_PCK_V2_V3_nsa_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 3112
  { IMAGE_LOAD_PCK_V2_V4_nsa_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 3113
  { IMAGE_LOAD_PCK_V3_V2_nsa_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 3114
  { IMAGE_LOAD_PCK_V3_V3_nsa_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 3115
  { IMAGE_LOAD_PCK_V3_V4_nsa_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 3116
  { IMAGE_LOAD_PCK_V4_V2_nsa_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 3117
  { IMAGE_LOAD_PCK_V4_V3_nsa_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 3118
  { IMAGE_LOAD_PCK_V4_V4_nsa_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 3119
  { IMAGE_LOAD_PCK_V5_V2_nsa_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 3120
  { IMAGE_LOAD_PCK_V5_V3_nsa_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 3121
  { IMAGE_LOAD_PCK_V5_V4_nsa_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 3122
  { IMAGE_LOAD_PCK_V1_V1_gfx12, IMAGE_LOAD_PCK, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 3123
  { IMAGE_LOAD_PCK_V1_V2_gfx12, IMAGE_LOAD_PCK, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 3124
  { IMAGE_LOAD_PCK_V1_V3_gfx12, IMAGE_LOAD_PCK, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 3125
  { IMAGE_LOAD_PCK_V1_V4_gfx12, IMAGE_LOAD_PCK, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 3126
  { IMAGE_LOAD_PCK_V2_V1_gfx12, IMAGE_LOAD_PCK, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 3127
  { IMAGE_LOAD_PCK_V2_V2_gfx12, IMAGE_LOAD_PCK, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 3128
  { IMAGE_LOAD_PCK_V2_V3_gfx12, IMAGE_LOAD_PCK, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 3129
  { IMAGE_LOAD_PCK_V2_V4_gfx12, IMAGE_LOAD_PCK, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 3130
  { IMAGE_LOAD_PCK_V3_V1_gfx12, IMAGE_LOAD_PCK, MIMGEncGfx12, 0x3, 0x1, 0x1 }, // 3131
  { IMAGE_LOAD_PCK_V3_V2_gfx12, IMAGE_LOAD_PCK, MIMGEncGfx12, 0x3, 0x2, 0x2 }, // 3132
  { IMAGE_LOAD_PCK_V3_V3_gfx12, IMAGE_LOAD_PCK, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 3133
  { IMAGE_LOAD_PCK_V3_V4_gfx12, IMAGE_LOAD_PCK, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 3134
  { IMAGE_LOAD_PCK_V4_V1_gfx12, IMAGE_LOAD_PCK, MIMGEncGfx12, 0x4, 0x1, 0x1 }, // 3135
  { IMAGE_LOAD_PCK_V4_V2_gfx12, IMAGE_LOAD_PCK, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 3136
  { IMAGE_LOAD_PCK_V4_V3_gfx12, IMAGE_LOAD_PCK, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 3137
  { IMAGE_LOAD_PCK_V4_V4_gfx12, IMAGE_LOAD_PCK, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 3138
  { IMAGE_LOAD_PCK_V5_V1_gfx12, IMAGE_LOAD_PCK, MIMGEncGfx12, 0x5, 0x1, 0x1 }, // 3139
  { IMAGE_LOAD_PCK_V5_V2_gfx12, IMAGE_LOAD_PCK, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 3140
  { IMAGE_LOAD_PCK_V5_V3_gfx12, IMAGE_LOAD_PCK, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 3141
  { IMAGE_LOAD_PCK_V5_V4_gfx12, IMAGE_LOAD_PCK, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 3142
  { IMAGE_LOAD_PCK_V1_V1, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 3143
  { IMAGE_LOAD_PCK_V1_V2, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 3144
  { IMAGE_LOAD_PCK_V1_V3, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 3145
  { IMAGE_LOAD_PCK_V1_V4, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 3146
  { IMAGE_LOAD_PCK_V2_V1, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 3147
  { IMAGE_LOAD_PCK_V2_V2, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 3148
  { IMAGE_LOAD_PCK_V2_V3, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 3149
  { IMAGE_LOAD_PCK_V2_V4, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 3150
  { IMAGE_LOAD_PCK_V3_V1, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x3, 0x1, 0x1 }, // 3151
  { IMAGE_LOAD_PCK_V3_V2, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 3152
  { IMAGE_LOAD_PCK_V3_V3, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 3153
  { IMAGE_LOAD_PCK_V3_V4, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 3154
  { IMAGE_LOAD_PCK_V4_V1, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 3155
  { IMAGE_LOAD_PCK_V4_V2, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 3156
  { IMAGE_LOAD_PCK_V4_V3, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 3157
  { IMAGE_LOAD_PCK_V4_V4, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 3158
  { IMAGE_LOAD_PCK_V5_V1, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x5, 0x1, 0x1 }, // 3159
  { IMAGE_LOAD_PCK_V5_V2, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 3160
  { IMAGE_LOAD_PCK_V5_V3, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 3161
  { IMAGE_LOAD_PCK_V5_V4, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 3162
  { IMAGE_LOAD_PCK_V1_V1_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 3163
  { IMAGE_LOAD_PCK_V1_V2_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 3164
  { IMAGE_LOAD_PCK_V1_V3_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 3165
  { IMAGE_LOAD_PCK_V1_V4_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 3166
  { IMAGE_LOAD_PCK_V2_V1_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 3167
  { IMAGE_LOAD_PCK_V2_V2_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 3168
  { IMAGE_LOAD_PCK_V2_V3_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 3169
  { IMAGE_LOAD_PCK_V2_V4_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 3170
  { IMAGE_LOAD_PCK_V3_V1_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x3, 0x1, 0x1 }, // 3171
  { IMAGE_LOAD_PCK_V3_V2_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x3, 0x2, 0x1 }, // 3172
  { IMAGE_LOAD_PCK_V3_V3_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x3, 0x3, 0x1 }, // 3173
  { IMAGE_LOAD_PCK_V3_V4_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x3, 0x4, 0x1 }, // 3174
  { IMAGE_LOAD_PCK_V4_V1_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x4, 0x1, 0x1 }, // 3175
  { IMAGE_LOAD_PCK_V4_V2_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x4, 0x2, 0x1 }, // 3176
  { IMAGE_LOAD_PCK_V4_V3_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x4, 0x3, 0x1 }, // 3177
  { IMAGE_LOAD_PCK_V4_V4_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x4, 0x4, 0x1 }, // 3178
  { IMAGE_LOAD_PCK_V5_V1_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x5, 0x1, 0x1 }, // 3179
  { IMAGE_LOAD_PCK_V5_V2_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x5, 0x2, 0x1 }, // 3180
  { IMAGE_LOAD_PCK_V5_V3_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x5, 0x3, 0x1 }, // 3181
  { IMAGE_LOAD_PCK_V5_V4_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x5, 0x4, 0x1 }, // 3182
  { IMAGE_LOAD_PCK_SGN_V1_V1_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 3183
  { IMAGE_LOAD_PCK_SGN_V1_V2_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 3184
  { IMAGE_LOAD_PCK_SGN_V1_V3_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 3185
  { IMAGE_LOAD_PCK_SGN_V1_V4_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 3186
  { IMAGE_LOAD_PCK_SGN_V2_V1_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 3187
  { IMAGE_LOAD_PCK_SGN_V2_V2_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 3188
  { IMAGE_LOAD_PCK_SGN_V2_V3_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 3189
  { IMAGE_LOAD_PCK_SGN_V2_V4_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 3190
  { IMAGE_LOAD_PCK_SGN_V3_V1_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x3, 0x1, 0x1 }, // 3191
  { IMAGE_LOAD_PCK_SGN_V3_V2_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 3192
  { IMAGE_LOAD_PCK_SGN_V3_V3_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 3193
  { IMAGE_LOAD_PCK_SGN_V3_V4_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 3194
  { IMAGE_LOAD_PCK_SGN_V4_V1_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 3195
  { IMAGE_LOAD_PCK_SGN_V4_V2_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 3196
  { IMAGE_LOAD_PCK_SGN_V4_V3_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 3197
  { IMAGE_LOAD_PCK_SGN_V4_V4_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 3198
  { IMAGE_LOAD_PCK_SGN_V5_V1_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x5, 0x1, 0x1 }, // 3199
  { IMAGE_LOAD_PCK_SGN_V5_V2_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 3200
  { IMAGE_LOAD_PCK_SGN_V5_V3_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 3201
  { IMAGE_LOAD_PCK_SGN_V5_V4_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 3202
  { IMAGE_LOAD_PCK_SGN_V1_V2_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 3203
  { IMAGE_LOAD_PCK_SGN_V1_V3_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 3204
  { IMAGE_LOAD_PCK_SGN_V1_V4_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 3205
  { IMAGE_LOAD_PCK_SGN_V2_V2_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 3206
  { IMAGE_LOAD_PCK_SGN_V2_V3_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 3207
  { IMAGE_LOAD_PCK_SGN_V2_V4_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 3208
  { IMAGE_LOAD_PCK_SGN_V3_V2_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 3209
  { IMAGE_LOAD_PCK_SGN_V3_V3_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 3210
  { IMAGE_LOAD_PCK_SGN_V3_V4_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 3211
  { IMAGE_LOAD_PCK_SGN_V4_V2_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 3212
  { IMAGE_LOAD_PCK_SGN_V4_V3_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 3213
  { IMAGE_LOAD_PCK_SGN_V4_V4_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 3214
  { IMAGE_LOAD_PCK_SGN_V5_V2_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 3215
  { IMAGE_LOAD_PCK_SGN_V5_V3_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 3216
  { IMAGE_LOAD_PCK_SGN_V5_V4_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 3217
  { IMAGE_LOAD_PCK_SGN_V1_V1_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 3218
  { IMAGE_LOAD_PCK_SGN_V1_V2_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 3219
  { IMAGE_LOAD_PCK_SGN_V1_V3_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 3220
  { IMAGE_LOAD_PCK_SGN_V1_V4_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 3221
  { IMAGE_LOAD_PCK_SGN_V2_V1_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 3222
  { IMAGE_LOAD_PCK_SGN_V2_V2_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 3223
  { IMAGE_LOAD_PCK_SGN_V2_V3_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 3224
  { IMAGE_LOAD_PCK_SGN_V2_V4_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 3225
  { IMAGE_LOAD_PCK_SGN_V3_V1_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x3, 0x1, 0x1 }, // 3226
  { IMAGE_LOAD_PCK_SGN_V3_V2_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 3227
  { IMAGE_LOAD_PCK_SGN_V3_V3_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 3228
  { IMAGE_LOAD_PCK_SGN_V3_V4_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 3229
  { IMAGE_LOAD_PCK_SGN_V4_V1_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 3230
  { IMAGE_LOAD_PCK_SGN_V4_V2_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 3231
  { IMAGE_LOAD_PCK_SGN_V4_V3_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 3232
  { IMAGE_LOAD_PCK_SGN_V4_V4_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 3233
  { IMAGE_LOAD_PCK_SGN_V5_V1_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x5, 0x1, 0x1 }, // 3234
  { IMAGE_LOAD_PCK_SGN_V5_V2_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 3235
  { IMAGE_LOAD_PCK_SGN_V5_V3_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 3236
  { IMAGE_LOAD_PCK_SGN_V5_V4_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 3237
  { IMAGE_LOAD_PCK_SGN_V1_V2_nsa_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 3238
  { IMAGE_LOAD_PCK_SGN_V1_V3_nsa_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 3239
  { IMAGE_LOAD_PCK_SGN_V1_V4_nsa_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 3240
  { IMAGE_LOAD_PCK_SGN_V2_V2_nsa_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 3241
  { IMAGE_LOAD_PCK_SGN_V2_V3_nsa_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 3242
  { IMAGE_LOAD_PCK_SGN_V2_V4_nsa_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 3243
  { IMAGE_LOAD_PCK_SGN_V3_V2_nsa_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 3244
  { IMAGE_LOAD_PCK_SGN_V3_V3_nsa_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 3245
  { IMAGE_LOAD_PCK_SGN_V3_V4_nsa_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 3246
  { IMAGE_LOAD_PCK_SGN_V4_V2_nsa_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 3247
  { IMAGE_LOAD_PCK_SGN_V4_V3_nsa_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 3248
  { IMAGE_LOAD_PCK_SGN_V4_V4_nsa_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 3249
  { IMAGE_LOAD_PCK_SGN_V5_V2_nsa_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 3250
  { IMAGE_LOAD_PCK_SGN_V5_V3_nsa_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 3251
  { IMAGE_LOAD_PCK_SGN_V5_V4_nsa_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 3252
  { IMAGE_LOAD_PCK_SGN_V1_V1_gfx12, IMAGE_LOAD_PCK_SGN, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 3253
  { IMAGE_LOAD_PCK_SGN_V1_V2_gfx12, IMAGE_LOAD_PCK_SGN, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 3254
  { IMAGE_LOAD_PCK_SGN_V1_V3_gfx12, IMAGE_LOAD_PCK_SGN, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 3255
  { IMAGE_LOAD_PCK_SGN_V1_V4_gfx12, IMAGE_LOAD_PCK_SGN, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 3256
  { IMAGE_LOAD_PCK_SGN_V2_V1_gfx12, IMAGE_LOAD_PCK_SGN, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 3257
  { IMAGE_LOAD_PCK_SGN_V2_V2_gfx12, IMAGE_LOAD_PCK_SGN, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 3258
  { IMAGE_LOAD_PCK_SGN_V2_V3_gfx12, IMAGE_LOAD_PCK_SGN, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 3259
  { IMAGE_LOAD_PCK_SGN_V2_V4_gfx12, IMAGE_LOAD_PCK_SGN, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 3260
  { IMAGE_LOAD_PCK_SGN_V3_V1_gfx12, IMAGE_LOAD_PCK_SGN, MIMGEncGfx12, 0x3, 0x1, 0x1 }, // 3261
  { IMAGE_LOAD_PCK_SGN_V3_V2_gfx12, IMAGE_LOAD_PCK_SGN, MIMGEncGfx12, 0x3, 0x2, 0x2 }, // 3262
  { IMAGE_LOAD_PCK_SGN_V3_V3_gfx12, IMAGE_LOAD_PCK_SGN, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 3263
  { IMAGE_LOAD_PCK_SGN_V3_V4_gfx12, IMAGE_LOAD_PCK_SGN, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 3264
  { IMAGE_LOAD_PCK_SGN_V4_V1_gfx12, IMAGE_LOAD_PCK_SGN, MIMGEncGfx12, 0x4, 0x1, 0x1 }, // 3265
  { IMAGE_LOAD_PCK_SGN_V4_V2_gfx12, IMAGE_LOAD_PCK_SGN, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 3266
  { IMAGE_LOAD_PCK_SGN_V4_V3_gfx12, IMAGE_LOAD_PCK_SGN, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 3267
  { IMAGE_LOAD_PCK_SGN_V4_V4_gfx12, IMAGE_LOAD_PCK_SGN, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 3268
  { IMAGE_LOAD_PCK_SGN_V5_V1_gfx12, IMAGE_LOAD_PCK_SGN, MIMGEncGfx12, 0x5, 0x1, 0x1 }, // 3269
  { IMAGE_LOAD_PCK_SGN_V5_V2_gfx12, IMAGE_LOAD_PCK_SGN, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 3270
  { IMAGE_LOAD_PCK_SGN_V5_V3_gfx12, IMAGE_LOAD_PCK_SGN, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 3271
  { IMAGE_LOAD_PCK_SGN_V5_V4_gfx12, IMAGE_LOAD_PCK_SGN, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 3272
  { IMAGE_LOAD_PCK_SGN_V1_V1, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 3273
  { IMAGE_LOAD_PCK_SGN_V1_V2, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 3274
  { IMAGE_LOAD_PCK_SGN_V1_V3, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 3275
  { IMAGE_LOAD_PCK_SGN_V1_V4, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 3276
  { IMAGE_LOAD_PCK_SGN_V2_V1, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 3277
  { IMAGE_LOAD_PCK_SGN_V2_V2, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 3278
  { IMAGE_LOAD_PCK_SGN_V2_V3, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 3279
  { IMAGE_LOAD_PCK_SGN_V2_V4, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 3280
  { IMAGE_LOAD_PCK_SGN_V3_V1, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x3, 0x1, 0x1 }, // 3281
  { IMAGE_LOAD_PCK_SGN_V3_V2, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 3282
  { IMAGE_LOAD_PCK_SGN_V3_V3, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 3283
  { IMAGE_LOAD_PCK_SGN_V3_V4, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 3284
  { IMAGE_LOAD_PCK_SGN_V4_V1, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 3285
  { IMAGE_LOAD_PCK_SGN_V4_V2, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 3286
  { IMAGE_LOAD_PCK_SGN_V4_V3, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 3287
  { IMAGE_LOAD_PCK_SGN_V4_V4, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 3288
  { IMAGE_LOAD_PCK_SGN_V5_V1, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x5, 0x1, 0x1 }, // 3289
  { IMAGE_LOAD_PCK_SGN_V5_V2, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 3290
  { IMAGE_LOAD_PCK_SGN_V5_V3, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 3291
  { IMAGE_LOAD_PCK_SGN_V5_V4, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 3292
  { IMAGE_LOAD_PCK_SGN_V1_V1_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 3293
  { IMAGE_LOAD_PCK_SGN_V1_V2_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 3294
  { IMAGE_LOAD_PCK_SGN_V1_V3_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 3295
  { IMAGE_LOAD_PCK_SGN_V1_V4_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 3296
  { IMAGE_LOAD_PCK_SGN_V2_V1_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 3297
  { IMAGE_LOAD_PCK_SGN_V2_V2_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 3298
  { IMAGE_LOAD_PCK_SGN_V2_V3_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 3299
  { IMAGE_LOAD_PCK_SGN_V2_V4_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 3300
  { IMAGE_LOAD_PCK_SGN_V3_V1_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x3, 0x1, 0x1 }, // 3301
  { IMAGE_LOAD_PCK_SGN_V3_V2_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x3, 0x2, 0x1 }, // 3302
  { IMAGE_LOAD_PCK_SGN_V3_V3_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x3, 0x3, 0x1 }, // 3303
  { IMAGE_LOAD_PCK_SGN_V3_V4_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x3, 0x4, 0x1 }, // 3304
  { IMAGE_LOAD_PCK_SGN_V4_V1_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x4, 0x1, 0x1 }, // 3305
  { IMAGE_LOAD_PCK_SGN_V4_V2_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x4, 0x2, 0x1 }, // 3306
  { IMAGE_LOAD_PCK_SGN_V4_V3_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x4, 0x3, 0x1 }, // 3307
  { IMAGE_LOAD_PCK_SGN_V4_V4_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x4, 0x4, 0x1 }, // 3308
  { IMAGE_LOAD_PCK_SGN_V5_V1_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x5, 0x1, 0x1 }, // 3309
  { IMAGE_LOAD_PCK_SGN_V5_V2_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x5, 0x2, 0x1 }, // 3310
  { IMAGE_LOAD_PCK_SGN_V5_V3_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x5, 0x3, 0x1 }, // 3311
  { IMAGE_LOAD_PCK_SGN_V5_V4_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x5, 0x4, 0x1 }, // 3312
  { IMAGE_MSAA_LOAD_V2_V1_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 3313
  { IMAGE_MSAA_LOAD_V2_V2_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 3314
  { IMAGE_MSAA_LOAD_V2_V3_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 3315
  { IMAGE_MSAA_LOAD_V2_V4_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 3316
  { IMAGE_MSAA_LOAD_V3_V1_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11Default, 0x3, 0x1, 0x1 }, // 3317
  { IMAGE_MSAA_LOAD_V3_V2_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 3318
  { IMAGE_MSAA_LOAD_V3_V3_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 3319
  { IMAGE_MSAA_LOAD_V3_V4_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 3320
  { IMAGE_MSAA_LOAD_V4_V1_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 3321
  { IMAGE_MSAA_LOAD_V4_V2_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 3322
  { IMAGE_MSAA_LOAD_V4_V3_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 3323
  { IMAGE_MSAA_LOAD_V4_V4_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 3324
  { IMAGE_MSAA_LOAD_V5_V1_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11Default, 0x5, 0x1, 0x1 }, // 3325
  { IMAGE_MSAA_LOAD_V5_V2_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 3326
  { IMAGE_MSAA_LOAD_V5_V3_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 3327
  { IMAGE_MSAA_LOAD_V5_V4_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 3328
  { IMAGE_MSAA_LOAD_V2_V2_nsa_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 3329
  { IMAGE_MSAA_LOAD_V2_V3_nsa_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 3330
  { IMAGE_MSAA_LOAD_V2_V4_nsa_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 3331
  { IMAGE_MSAA_LOAD_V3_V2_nsa_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 3332
  { IMAGE_MSAA_LOAD_V3_V3_nsa_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 3333
  { IMAGE_MSAA_LOAD_V3_V4_nsa_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 3334
  { IMAGE_MSAA_LOAD_V4_V2_nsa_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 3335
  { IMAGE_MSAA_LOAD_V4_V3_nsa_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 3336
  { IMAGE_MSAA_LOAD_V4_V4_nsa_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 3337
  { IMAGE_MSAA_LOAD_V5_V2_nsa_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 3338
  { IMAGE_MSAA_LOAD_V5_V3_nsa_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 3339
  { IMAGE_MSAA_LOAD_V5_V4_nsa_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 3340
  { IMAGE_MSAA_LOAD_V2_V1_gfx12, IMAGE_MSAA_LOAD, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 3341
  { IMAGE_MSAA_LOAD_V2_V2_gfx12, IMAGE_MSAA_LOAD, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 3342
  { IMAGE_MSAA_LOAD_V2_V3_gfx12, IMAGE_MSAA_LOAD, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 3343
  { IMAGE_MSAA_LOAD_V2_V4_gfx12, IMAGE_MSAA_LOAD, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 3344
  { IMAGE_MSAA_LOAD_V3_V1_gfx12, IMAGE_MSAA_LOAD, MIMGEncGfx12, 0x3, 0x1, 0x1 }, // 3345
  { IMAGE_MSAA_LOAD_V3_V2_gfx12, IMAGE_MSAA_LOAD, MIMGEncGfx12, 0x3, 0x2, 0x2 }, // 3346
  { IMAGE_MSAA_LOAD_V3_V3_gfx12, IMAGE_MSAA_LOAD, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 3347
  { IMAGE_MSAA_LOAD_V3_V4_gfx12, IMAGE_MSAA_LOAD, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 3348
  { IMAGE_MSAA_LOAD_V4_V1_gfx12, IMAGE_MSAA_LOAD, MIMGEncGfx12, 0x4, 0x1, 0x1 }, // 3349
  { IMAGE_MSAA_LOAD_V4_V2_gfx12, IMAGE_MSAA_LOAD, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 3350
  { IMAGE_MSAA_LOAD_V4_V3_gfx12, IMAGE_MSAA_LOAD, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 3351
  { IMAGE_MSAA_LOAD_V4_V4_gfx12, IMAGE_MSAA_LOAD, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 3352
  { IMAGE_MSAA_LOAD_V5_V1_gfx12, IMAGE_MSAA_LOAD, MIMGEncGfx12, 0x5, 0x1, 0x1 }, // 3353
  { IMAGE_MSAA_LOAD_V5_V2_gfx12, IMAGE_MSAA_LOAD, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 3354
  { IMAGE_MSAA_LOAD_V5_V3_gfx12, IMAGE_MSAA_LOAD, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 3355
  { IMAGE_MSAA_LOAD_V5_V4_gfx12, IMAGE_MSAA_LOAD, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 3356
  { IMAGE_MSAA_LOAD_X_V1_V1_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 3357
  { IMAGE_MSAA_LOAD_X_V1_V2_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 3358
  { IMAGE_MSAA_LOAD_X_V1_V3_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 3359
  { IMAGE_MSAA_LOAD_X_V1_V4_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 3360
  { IMAGE_MSAA_LOAD_X_V2_V1_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 3361
  { IMAGE_MSAA_LOAD_X_V2_V2_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 3362
  { IMAGE_MSAA_LOAD_X_V2_V3_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 3363
  { IMAGE_MSAA_LOAD_X_V2_V4_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 3364
  { IMAGE_MSAA_LOAD_X_V3_V1_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x3, 0x1, 0x1 }, // 3365
  { IMAGE_MSAA_LOAD_X_V3_V2_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 3366
  { IMAGE_MSAA_LOAD_X_V3_V3_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 3367
  { IMAGE_MSAA_LOAD_X_V3_V4_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 3368
  { IMAGE_MSAA_LOAD_X_V4_V1_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 3369
  { IMAGE_MSAA_LOAD_X_V4_V2_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 3370
  { IMAGE_MSAA_LOAD_X_V4_V3_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 3371
  { IMAGE_MSAA_LOAD_X_V4_V4_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 3372
  { IMAGE_MSAA_LOAD_X_V5_V1_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x5, 0x1, 0x1 }, // 3373
  { IMAGE_MSAA_LOAD_X_V5_V2_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 3374
  { IMAGE_MSAA_LOAD_X_V5_V3_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 3375
  { IMAGE_MSAA_LOAD_X_V5_V4_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 3376
  { IMAGE_MSAA_LOAD_X_V1_V2_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 3377
  { IMAGE_MSAA_LOAD_X_V1_V3_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 3378
  { IMAGE_MSAA_LOAD_X_V1_V4_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 3379
  { IMAGE_MSAA_LOAD_X_V2_V2_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 3380
  { IMAGE_MSAA_LOAD_X_V2_V3_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 3381
  { IMAGE_MSAA_LOAD_X_V2_V4_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 3382
  { IMAGE_MSAA_LOAD_X_V3_V2_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 3383
  { IMAGE_MSAA_LOAD_X_V3_V3_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 3384
  { IMAGE_MSAA_LOAD_X_V3_V4_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 3385
  { IMAGE_MSAA_LOAD_X_V4_V2_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 3386
  { IMAGE_MSAA_LOAD_X_V4_V3_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 3387
  { IMAGE_MSAA_LOAD_X_V4_V4_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 3388
  { IMAGE_MSAA_LOAD_X_V5_V2_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 3389
  { IMAGE_MSAA_LOAD_X_V5_V3_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 3390
  { IMAGE_MSAA_LOAD_X_V5_V4_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 3391
  { IMAGE_MSAA_LOAD_X_V1_V1, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 3392
  { IMAGE_MSAA_LOAD_X_V1_V2, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 3393
  { IMAGE_MSAA_LOAD_X_V1_V3, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 3394
  { IMAGE_MSAA_LOAD_X_V1_V4, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 3395
  { IMAGE_MSAA_LOAD_X_V2_V1, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 3396
  { IMAGE_MSAA_LOAD_X_V2_V2, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 3397
  { IMAGE_MSAA_LOAD_X_V2_V3, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 3398
  { IMAGE_MSAA_LOAD_X_V2_V4, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 3399
  { IMAGE_MSAA_LOAD_X_V3_V1, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x3, 0x1, 0x1 }, // 3400
  { IMAGE_MSAA_LOAD_X_V3_V2, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 3401
  { IMAGE_MSAA_LOAD_X_V3_V3, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 3402
  { IMAGE_MSAA_LOAD_X_V3_V4, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 3403
  { IMAGE_MSAA_LOAD_X_V4_V1, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 3404
  { IMAGE_MSAA_LOAD_X_V4_V2, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 3405
  { IMAGE_MSAA_LOAD_X_V4_V3, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 3406
  { IMAGE_MSAA_LOAD_X_V4_V4, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 3407
  { IMAGE_MSAA_LOAD_X_V5_V1, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x5, 0x1, 0x1 }, // 3408
  { IMAGE_MSAA_LOAD_X_V5_V2, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 3409
  { IMAGE_MSAA_LOAD_X_V5_V3, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 3410
  { IMAGE_MSAA_LOAD_X_V5_V4, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 3411
  { IMAGE_SAMPLE_V1_V1_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 3412
  { IMAGE_SAMPLE_V1_V2_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 3413
  { IMAGE_SAMPLE_V1_V3_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 3414
  { IMAGE_SAMPLE_V1_V4_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 3415
  { IMAGE_SAMPLE_V2_V1_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 3416
  { IMAGE_SAMPLE_V2_V2_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 3417
  { IMAGE_SAMPLE_V2_V3_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 3418
  { IMAGE_SAMPLE_V2_V4_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 3419
  { IMAGE_SAMPLE_V3_V1_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x3, 0x1, 0x1 }, // 3420
  { IMAGE_SAMPLE_V3_V2_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 3421
  { IMAGE_SAMPLE_V3_V3_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 3422
  { IMAGE_SAMPLE_V3_V4_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 3423
  { IMAGE_SAMPLE_V4_V1_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 3424
  { IMAGE_SAMPLE_V4_V2_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 3425
  { IMAGE_SAMPLE_V4_V3_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 3426
  { IMAGE_SAMPLE_V4_V4_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 3427
  { IMAGE_SAMPLE_V5_V1_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x5, 0x1, 0x1 }, // 3428
  { IMAGE_SAMPLE_V5_V2_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 3429
  { IMAGE_SAMPLE_V5_V3_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 3430
  { IMAGE_SAMPLE_V5_V4_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 3431
  { IMAGE_SAMPLE_V1_V2_nsa_gfx10, IMAGE_SAMPLE, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 3432
  { IMAGE_SAMPLE_V1_V3_nsa_gfx10, IMAGE_SAMPLE, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 3433
  { IMAGE_SAMPLE_V2_V2_nsa_gfx10, IMAGE_SAMPLE, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 3434
  { IMAGE_SAMPLE_V2_V3_nsa_gfx10, IMAGE_SAMPLE, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 3435
  { IMAGE_SAMPLE_V3_V2_nsa_gfx10, IMAGE_SAMPLE, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 3436
  { IMAGE_SAMPLE_V3_V3_nsa_gfx10, IMAGE_SAMPLE, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 3437
  { IMAGE_SAMPLE_V4_V2_nsa_gfx10, IMAGE_SAMPLE, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 3438
  { IMAGE_SAMPLE_V4_V3_nsa_gfx10, IMAGE_SAMPLE, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 3439
  { IMAGE_SAMPLE_V5_V2_nsa_gfx10, IMAGE_SAMPLE, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 3440
  { IMAGE_SAMPLE_V5_V3_nsa_gfx10, IMAGE_SAMPLE, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 3441
  { IMAGE_SAMPLE_V1_V1_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 3442
  { IMAGE_SAMPLE_V1_V2_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 3443
  { IMAGE_SAMPLE_V1_V3_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 3444
  { IMAGE_SAMPLE_V1_V4_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 3445
  { IMAGE_SAMPLE_V2_V1_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 3446
  { IMAGE_SAMPLE_V2_V2_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 3447
  { IMAGE_SAMPLE_V2_V3_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 3448
  { IMAGE_SAMPLE_V2_V4_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 3449
  { IMAGE_SAMPLE_V3_V1_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x3, 0x1, 0x1 }, // 3450
  { IMAGE_SAMPLE_V3_V2_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 3451
  { IMAGE_SAMPLE_V3_V3_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 3452
  { IMAGE_SAMPLE_V3_V4_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 3453
  { IMAGE_SAMPLE_V4_V1_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 3454
  { IMAGE_SAMPLE_V4_V2_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 3455
  { IMAGE_SAMPLE_V4_V3_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 3456
  { IMAGE_SAMPLE_V4_V4_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 3457
  { IMAGE_SAMPLE_V5_V1_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x5, 0x1, 0x1 }, // 3458
  { IMAGE_SAMPLE_V5_V2_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 3459
  { IMAGE_SAMPLE_V5_V3_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 3460
  { IMAGE_SAMPLE_V5_V4_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 3461
  { IMAGE_SAMPLE_V1_V2_nsa_gfx11, IMAGE_SAMPLE, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 3462
  { IMAGE_SAMPLE_V1_V3_nsa_gfx11, IMAGE_SAMPLE, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 3463
  { IMAGE_SAMPLE_V2_V2_nsa_gfx11, IMAGE_SAMPLE, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 3464
  { IMAGE_SAMPLE_V2_V3_nsa_gfx11, IMAGE_SAMPLE, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 3465
  { IMAGE_SAMPLE_V3_V2_nsa_gfx11, IMAGE_SAMPLE, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 3466
  { IMAGE_SAMPLE_V3_V3_nsa_gfx11, IMAGE_SAMPLE, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 3467
  { IMAGE_SAMPLE_V4_V2_nsa_gfx11, IMAGE_SAMPLE, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 3468
  { IMAGE_SAMPLE_V4_V3_nsa_gfx11, IMAGE_SAMPLE, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 3469
  { IMAGE_SAMPLE_V5_V2_nsa_gfx11, IMAGE_SAMPLE, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 3470
  { IMAGE_SAMPLE_V5_V3_nsa_gfx11, IMAGE_SAMPLE, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 3471
  { IMAGE_SAMPLE_V1_V1_gfx12, IMAGE_SAMPLE, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 3472
  { IMAGE_SAMPLE_V1_V2_gfx12, IMAGE_SAMPLE, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 3473
  { IMAGE_SAMPLE_V1_V3_gfx12, IMAGE_SAMPLE, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 3474
  { IMAGE_SAMPLE_V2_V1_gfx12, IMAGE_SAMPLE, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 3475
  { IMAGE_SAMPLE_V2_V2_gfx12, IMAGE_SAMPLE, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 3476
  { IMAGE_SAMPLE_V2_V3_gfx12, IMAGE_SAMPLE, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 3477
  { IMAGE_SAMPLE_V3_V1_gfx12, IMAGE_SAMPLE, MIMGEncGfx12, 0x3, 0x1, 0x1 }, // 3478
  { IMAGE_SAMPLE_V3_V2_gfx12, IMAGE_SAMPLE, MIMGEncGfx12, 0x3, 0x2, 0x2 }, // 3479
  { IMAGE_SAMPLE_V3_V3_gfx12, IMAGE_SAMPLE, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 3480
  { IMAGE_SAMPLE_V4_V1_gfx12, IMAGE_SAMPLE, MIMGEncGfx12, 0x4, 0x1, 0x1 }, // 3481
  { IMAGE_SAMPLE_V4_V2_gfx12, IMAGE_SAMPLE, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 3482
  { IMAGE_SAMPLE_V4_V3_gfx12, IMAGE_SAMPLE, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 3483
  { IMAGE_SAMPLE_V5_V1_gfx12, IMAGE_SAMPLE, MIMGEncGfx12, 0x5, 0x1, 0x1 }, // 3484
  { IMAGE_SAMPLE_V5_V2_gfx12, IMAGE_SAMPLE, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 3485
  { IMAGE_SAMPLE_V5_V3_gfx12, IMAGE_SAMPLE, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 3486
  { IMAGE_SAMPLE_V1_V1, IMAGE_SAMPLE, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 3487
  { IMAGE_SAMPLE_V1_V2, IMAGE_SAMPLE, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 3488
  { IMAGE_SAMPLE_V1_V3, IMAGE_SAMPLE, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 3489
  { IMAGE_SAMPLE_V1_V4, IMAGE_SAMPLE, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 3490
  { IMAGE_SAMPLE_V2_V1, IMAGE_SAMPLE, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 3491
  { IMAGE_SAMPLE_V2_V2, IMAGE_SAMPLE, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 3492
  { IMAGE_SAMPLE_V2_V3, IMAGE_SAMPLE, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 3493
  { IMAGE_SAMPLE_V2_V4, IMAGE_SAMPLE, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 3494
  { IMAGE_SAMPLE_V3_V1, IMAGE_SAMPLE, MIMGEncGfx6, 0x3, 0x1, 0x1 }, // 3495
  { IMAGE_SAMPLE_V3_V2, IMAGE_SAMPLE, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 3496
  { IMAGE_SAMPLE_V3_V3, IMAGE_SAMPLE, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 3497
  { IMAGE_SAMPLE_V3_V4, IMAGE_SAMPLE, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 3498
  { IMAGE_SAMPLE_V4_V1, IMAGE_SAMPLE, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 3499
  { IMAGE_SAMPLE_V4_V2, IMAGE_SAMPLE, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 3500
  { IMAGE_SAMPLE_V4_V3, IMAGE_SAMPLE, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 3501
  { IMAGE_SAMPLE_V4_V4, IMAGE_SAMPLE, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 3502
  { IMAGE_SAMPLE_V5_V1, IMAGE_SAMPLE, MIMGEncGfx6, 0x5, 0x1, 0x1 }, // 3503
  { IMAGE_SAMPLE_V5_V2, IMAGE_SAMPLE, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 3504
  { IMAGE_SAMPLE_V5_V3, IMAGE_SAMPLE, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 3505
  { IMAGE_SAMPLE_V5_V4, IMAGE_SAMPLE, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 3506
  { IMAGE_SAMPLE_V1_V1_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 3507
  { IMAGE_SAMPLE_V1_V2_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 3508
  { IMAGE_SAMPLE_V1_V3_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 3509
  { IMAGE_SAMPLE_V1_V4_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 3510
  { IMAGE_SAMPLE_V2_V1_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 3511
  { IMAGE_SAMPLE_V2_V2_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 3512
  { IMAGE_SAMPLE_V2_V3_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 3513
  { IMAGE_SAMPLE_V2_V4_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 3514
  { IMAGE_SAMPLE_V3_V1_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x3, 0x1, 0x1 }, // 3515
  { IMAGE_SAMPLE_V3_V2_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x3, 0x2, 0x1 }, // 3516
  { IMAGE_SAMPLE_V3_V3_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x3, 0x3, 0x1 }, // 3517
  { IMAGE_SAMPLE_V3_V4_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x3, 0x4, 0x1 }, // 3518
  { IMAGE_SAMPLE_V4_V1_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x4, 0x1, 0x1 }, // 3519
  { IMAGE_SAMPLE_V4_V2_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x4, 0x2, 0x1 }, // 3520
  { IMAGE_SAMPLE_V4_V3_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x4, 0x3, 0x1 }, // 3521
  { IMAGE_SAMPLE_V4_V4_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x4, 0x4, 0x1 }, // 3522
  { IMAGE_SAMPLE_V5_V1_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x5, 0x1, 0x1 }, // 3523
  { IMAGE_SAMPLE_V5_V2_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x5, 0x2, 0x1 }, // 3524
  { IMAGE_SAMPLE_V5_V3_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x5, 0x3, 0x1 }, // 3525
  { IMAGE_SAMPLE_V5_V4_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x5, 0x4, 0x1 }, // 3526
  { IMAGE_SAMPLE_B_V1_V2_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 3527
  { IMAGE_SAMPLE_B_V1_V3_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 3528
  { IMAGE_SAMPLE_B_V1_V4_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 3529
  { IMAGE_SAMPLE_B_V2_V2_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 3530
  { IMAGE_SAMPLE_B_V2_V3_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 3531
  { IMAGE_SAMPLE_B_V2_V4_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 3532
  { IMAGE_SAMPLE_B_V3_V2_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 3533
  { IMAGE_SAMPLE_B_V3_V3_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 3534
  { IMAGE_SAMPLE_B_V3_V4_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 3535
  { IMAGE_SAMPLE_B_V4_V2_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 3536
  { IMAGE_SAMPLE_B_V4_V3_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 3537
  { IMAGE_SAMPLE_B_V4_V4_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 3538
  { IMAGE_SAMPLE_B_V5_V2_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 3539
  { IMAGE_SAMPLE_B_V5_V3_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 3540
  { IMAGE_SAMPLE_B_V5_V4_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 3541
  { IMAGE_SAMPLE_B_V1_V2_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 3542
  { IMAGE_SAMPLE_B_V1_V3_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 3543
  { IMAGE_SAMPLE_B_V1_V4_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 3544
  { IMAGE_SAMPLE_B_V2_V2_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 3545
  { IMAGE_SAMPLE_B_V2_V3_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 3546
  { IMAGE_SAMPLE_B_V2_V4_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 3547
  { IMAGE_SAMPLE_B_V3_V2_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 3548
  { IMAGE_SAMPLE_B_V3_V3_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 3549
  { IMAGE_SAMPLE_B_V3_V4_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 3550
  { IMAGE_SAMPLE_B_V4_V2_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 3551
  { IMAGE_SAMPLE_B_V4_V3_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 3552
  { IMAGE_SAMPLE_B_V4_V4_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 3553
  { IMAGE_SAMPLE_B_V5_V2_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 3554
  { IMAGE_SAMPLE_B_V5_V3_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 3555
  { IMAGE_SAMPLE_B_V5_V4_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 3556
  { IMAGE_SAMPLE_B_V1_V2_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 3557
  { IMAGE_SAMPLE_B_V1_V3_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 3558
  { IMAGE_SAMPLE_B_V1_V4_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 3559
  { IMAGE_SAMPLE_B_V2_V2_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 3560
  { IMAGE_SAMPLE_B_V2_V3_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 3561
  { IMAGE_SAMPLE_B_V2_V4_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 3562
  { IMAGE_SAMPLE_B_V3_V2_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 3563
  { IMAGE_SAMPLE_B_V3_V3_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 3564
  { IMAGE_SAMPLE_B_V3_V4_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 3565
  { IMAGE_SAMPLE_B_V4_V2_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 3566
  { IMAGE_SAMPLE_B_V4_V3_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 3567
  { IMAGE_SAMPLE_B_V4_V4_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 3568
  { IMAGE_SAMPLE_B_V5_V2_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 3569
  { IMAGE_SAMPLE_B_V5_V3_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 3570
  { IMAGE_SAMPLE_B_V5_V4_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 3571
  { IMAGE_SAMPLE_B_V1_V2_nsa_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 3572
  { IMAGE_SAMPLE_B_V1_V3_nsa_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 3573
  { IMAGE_SAMPLE_B_V1_V4_nsa_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 3574
  { IMAGE_SAMPLE_B_V2_V2_nsa_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 3575
  { IMAGE_SAMPLE_B_V2_V3_nsa_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 3576
  { IMAGE_SAMPLE_B_V2_V4_nsa_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 3577
  { IMAGE_SAMPLE_B_V3_V2_nsa_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 3578
  { IMAGE_SAMPLE_B_V3_V3_nsa_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 3579
  { IMAGE_SAMPLE_B_V3_V4_nsa_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 3580
  { IMAGE_SAMPLE_B_V4_V2_nsa_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 3581
  { IMAGE_SAMPLE_B_V4_V3_nsa_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 3582
  { IMAGE_SAMPLE_B_V4_V4_nsa_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 3583
  { IMAGE_SAMPLE_B_V5_V2_nsa_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 3584
  { IMAGE_SAMPLE_B_V5_V3_nsa_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 3585
  { IMAGE_SAMPLE_B_V5_V4_nsa_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 3586
  { IMAGE_SAMPLE_B_V1_V2_gfx12, IMAGE_SAMPLE_B, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 3587
  { IMAGE_SAMPLE_B_V1_V3_gfx12, IMAGE_SAMPLE_B, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 3588
  { IMAGE_SAMPLE_B_V1_V4_gfx12, IMAGE_SAMPLE_B, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 3589
  { IMAGE_SAMPLE_B_V2_V2_gfx12, IMAGE_SAMPLE_B, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 3590
  { IMAGE_SAMPLE_B_V2_V3_gfx12, IMAGE_SAMPLE_B, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 3591
  { IMAGE_SAMPLE_B_V2_V4_gfx12, IMAGE_SAMPLE_B, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 3592
  { IMAGE_SAMPLE_B_V3_V2_gfx12, IMAGE_SAMPLE_B, MIMGEncGfx12, 0x3, 0x2, 0x2 }, // 3593
  { IMAGE_SAMPLE_B_V3_V3_gfx12, IMAGE_SAMPLE_B, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 3594
  { IMAGE_SAMPLE_B_V3_V4_gfx12, IMAGE_SAMPLE_B, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 3595
  { IMAGE_SAMPLE_B_V4_V2_gfx12, IMAGE_SAMPLE_B, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 3596
  { IMAGE_SAMPLE_B_V4_V3_gfx12, IMAGE_SAMPLE_B, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 3597
  { IMAGE_SAMPLE_B_V4_V4_gfx12, IMAGE_SAMPLE_B, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 3598
  { IMAGE_SAMPLE_B_V5_V2_gfx12, IMAGE_SAMPLE_B, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 3599
  { IMAGE_SAMPLE_B_V5_V3_gfx12, IMAGE_SAMPLE_B, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 3600
  { IMAGE_SAMPLE_B_V5_V4_gfx12, IMAGE_SAMPLE_B, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 3601
  { IMAGE_SAMPLE_B_V1_V2, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 3602
  { IMAGE_SAMPLE_B_V1_V3, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 3603
  { IMAGE_SAMPLE_B_V1_V4, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 3604
  { IMAGE_SAMPLE_B_V2_V2, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 3605
  { IMAGE_SAMPLE_B_V2_V3, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 3606
  { IMAGE_SAMPLE_B_V2_V4, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 3607
  { IMAGE_SAMPLE_B_V3_V2, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 3608
  { IMAGE_SAMPLE_B_V3_V3, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 3609
  { IMAGE_SAMPLE_B_V3_V4, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 3610
  { IMAGE_SAMPLE_B_V4_V2, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 3611
  { IMAGE_SAMPLE_B_V4_V3, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 3612
  { IMAGE_SAMPLE_B_V4_V4, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 3613
  { IMAGE_SAMPLE_B_V5_V2, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 3614
  { IMAGE_SAMPLE_B_V5_V3, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 3615
  { IMAGE_SAMPLE_B_V5_V4, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 3616
  { IMAGE_SAMPLE_B_CL_V1_V2_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 3617
  { IMAGE_SAMPLE_B_CL_V1_V3_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 3618
  { IMAGE_SAMPLE_B_CL_V1_V4_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 3619
  { IMAGE_SAMPLE_B_CL_V1_V5_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 3620
  { IMAGE_SAMPLE_B_CL_V1_V8_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 3621
  { IMAGE_SAMPLE_B_CL_V2_V2_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 3622
  { IMAGE_SAMPLE_B_CL_V2_V3_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 3623
  { IMAGE_SAMPLE_B_CL_V2_V4_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 3624
  { IMAGE_SAMPLE_B_CL_V2_V5_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 3625
  { IMAGE_SAMPLE_B_CL_V2_V8_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 3626
  { IMAGE_SAMPLE_B_CL_V3_V2_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 3627
  { IMAGE_SAMPLE_B_CL_V3_V3_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 3628
  { IMAGE_SAMPLE_B_CL_V3_V4_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 3629
  { IMAGE_SAMPLE_B_CL_V3_V5_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 3630
  { IMAGE_SAMPLE_B_CL_V3_V8_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 3631
  { IMAGE_SAMPLE_B_CL_V4_V2_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 3632
  { IMAGE_SAMPLE_B_CL_V4_V3_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 3633
  { IMAGE_SAMPLE_B_CL_V4_V4_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 3634
  { IMAGE_SAMPLE_B_CL_V4_V5_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 3635
  { IMAGE_SAMPLE_B_CL_V4_V8_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 3636
  { IMAGE_SAMPLE_B_CL_V5_V2_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 3637
  { IMAGE_SAMPLE_B_CL_V5_V3_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 3638
  { IMAGE_SAMPLE_B_CL_V5_V4_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 3639
  { IMAGE_SAMPLE_B_CL_V5_V5_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 3640
  { IMAGE_SAMPLE_B_CL_V5_V8_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 3641
  { IMAGE_SAMPLE_B_CL_V1_V2_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 3642
  { IMAGE_SAMPLE_B_CL_V1_V3_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 3643
  { IMAGE_SAMPLE_B_CL_V1_V4_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 3644
  { IMAGE_SAMPLE_B_CL_V1_V5_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 3645
  { IMAGE_SAMPLE_B_CL_V2_V2_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 3646
  { IMAGE_SAMPLE_B_CL_V2_V3_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 3647
  { IMAGE_SAMPLE_B_CL_V2_V4_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 3648
  { IMAGE_SAMPLE_B_CL_V2_V5_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 3649
  { IMAGE_SAMPLE_B_CL_V3_V2_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 3650
  { IMAGE_SAMPLE_B_CL_V3_V3_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 3651
  { IMAGE_SAMPLE_B_CL_V3_V4_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 3652
  { IMAGE_SAMPLE_B_CL_V3_V5_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 3653
  { IMAGE_SAMPLE_B_CL_V4_V2_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 3654
  { IMAGE_SAMPLE_B_CL_V4_V3_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 3655
  { IMAGE_SAMPLE_B_CL_V4_V4_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 3656
  { IMAGE_SAMPLE_B_CL_V4_V5_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 3657
  { IMAGE_SAMPLE_B_CL_V5_V2_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 3658
  { IMAGE_SAMPLE_B_CL_V5_V3_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 3659
  { IMAGE_SAMPLE_B_CL_V5_V4_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 3660
  { IMAGE_SAMPLE_B_CL_V5_V5_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 3661
  { IMAGE_SAMPLE_B_CL_V1_V2_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 3662
  { IMAGE_SAMPLE_B_CL_V1_V3_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 3663
  { IMAGE_SAMPLE_B_CL_V1_V4_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 3664
  { IMAGE_SAMPLE_B_CL_V1_V5_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x1, 0x5, 0x1 }, // 3665
  { IMAGE_SAMPLE_B_CL_V1_V8_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x1, 0x8, 0x1 }, // 3666
  { IMAGE_SAMPLE_B_CL_V2_V2_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 3667
  { IMAGE_SAMPLE_B_CL_V2_V3_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 3668
  { IMAGE_SAMPLE_B_CL_V2_V4_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 3669
  { IMAGE_SAMPLE_B_CL_V2_V5_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 3670
  { IMAGE_SAMPLE_B_CL_V2_V8_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 3671
  { IMAGE_SAMPLE_B_CL_V3_V2_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 3672
  { IMAGE_SAMPLE_B_CL_V3_V3_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 3673
  { IMAGE_SAMPLE_B_CL_V3_V4_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 3674
  { IMAGE_SAMPLE_B_CL_V3_V5_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x3, 0x5, 0x1 }, // 3675
  { IMAGE_SAMPLE_B_CL_V3_V8_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x3, 0x8, 0x1 }, // 3676
  { IMAGE_SAMPLE_B_CL_V4_V2_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 3677
  { IMAGE_SAMPLE_B_CL_V4_V3_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 3678
  { IMAGE_SAMPLE_B_CL_V4_V4_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 3679
  { IMAGE_SAMPLE_B_CL_V4_V5_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 3680
  { IMAGE_SAMPLE_B_CL_V4_V8_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 3681
  { IMAGE_SAMPLE_B_CL_V5_V2_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 3682
  { IMAGE_SAMPLE_B_CL_V5_V3_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 3683
  { IMAGE_SAMPLE_B_CL_V5_V4_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 3684
  { IMAGE_SAMPLE_B_CL_V5_V5_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 3685
  { IMAGE_SAMPLE_B_CL_V5_V8_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 3686
  { IMAGE_SAMPLE_B_CL_V1_V2_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 3687
  { IMAGE_SAMPLE_B_CL_V1_V3_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 3688
  { IMAGE_SAMPLE_B_CL_V1_V4_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 3689
  { IMAGE_SAMPLE_B_CL_V1_V5_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x1, 0x5, 0x5 }, // 3690
  { IMAGE_SAMPLE_B_CL_V2_V2_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 3691
  { IMAGE_SAMPLE_B_CL_V2_V3_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 3692
  { IMAGE_SAMPLE_B_CL_V2_V4_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 3693
  { IMAGE_SAMPLE_B_CL_V2_V5_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 3694
  { IMAGE_SAMPLE_B_CL_V3_V2_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 3695
  { IMAGE_SAMPLE_B_CL_V3_V3_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 3696
  { IMAGE_SAMPLE_B_CL_V3_V4_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 3697
  { IMAGE_SAMPLE_B_CL_V3_V5_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x3, 0x5, 0x5 }, // 3698
  { IMAGE_SAMPLE_B_CL_V4_V2_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 3699
  { IMAGE_SAMPLE_B_CL_V4_V3_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 3700
  { IMAGE_SAMPLE_B_CL_V4_V4_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 3701
  { IMAGE_SAMPLE_B_CL_V4_V5_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 3702
  { IMAGE_SAMPLE_B_CL_V5_V2_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 3703
  { IMAGE_SAMPLE_B_CL_V5_V3_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 3704
  { IMAGE_SAMPLE_B_CL_V5_V4_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 3705
  { IMAGE_SAMPLE_B_CL_V5_V5_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 3706
  { IMAGE_SAMPLE_B_CL_V1_V2_gfx12, IMAGE_SAMPLE_B_CL, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 3707
  { IMAGE_SAMPLE_B_CL_V1_V3_gfx12, IMAGE_SAMPLE_B_CL, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 3708
  { IMAGE_SAMPLE_B_CL_V1_V4_gfx12, IMAGE_SAMPLE_B_CL, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 3709
  { IMAGE_SAMPLE_B_CL_V1_V5_gfx12, IMAGE_SAMPLE_B_CL, MIMGEncGfx12, 0x1, 0x5, 0x5 }, // 3710
  { IMAGE_SAMPLE_B_CL_V2_V2_gfx12, IMAGE_SAMPLE_B_CL, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 3711
  { IMAGE_SAMPLE_B_CL_V2_V3_gfx12, IMAGE_SAMPLE_B_CL, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 3712
  { IMAGE_SAMPLE_B_CL_V2_V4_gfx12, IMAGE_SAMPLE_B_CL, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 3713
  { IMAGE_SAMPLE_B_CL_V2_V5_gfx12, IMAGE_SAMPLE_B_CL, MIMGEncGfx12, 0x2, 0x5, 0x5 }, // 3714
  { IMAGE_SAMPLE_B_CL_V3_V2_gfx12, IMAGE_SAMPLE_B_CL, MIMGEncGfx12, 0x3, 0x2, 0x2 }, // 3715
  { IMAGE_SAMPLE_B_CL_V3_V3_gfx12, IMAGE_SAMPLE_B_CL, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 3716
  { IMAGE_SAMPLE_B_CL_V3_V4_gfx12, IMAGE_SAMPLE_B_CL, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 3717
  { IMAGE_SAMPLE_B_CL_V3_V5_gfx12, IMAGE_SAMPLE_B_CL, MIMGEncGfx12, 0x3, 0x5, 0x5 }, // 3718
  { IMAGE_SAMPLE_B_CL_V4_V2_gfx12, IMAGE_SAMPLE_B_CL, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 3719
  { IMAGE_SAMPLE_B_CL_V4_V3_gfx12, IMAGE_SAMPLE_B_CL, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 3720
  { IMAGE_SAMPLE_B_CL_V4_V4_gfx12, IMAGE_SAMPLE_B_CL, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 3721
  { IMAGE_SAMPLE_B_CL_V4_V5_gfx12, IMAGE_SAMPLE_B_CL, MIMGEncGfx12, 0x4, 0x5, 0x5 }, // 3722
  { IMAGE_SAMPLE_B_CL_V5_V2_gfx12, IMAGE_SAMPLE_B_CL, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 3723
  { IMAGE_SAMPLE_B_CL_V5_V3_gfx12, IMAGE_SAMPLE_B_CL, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 3724
  { IMAGE_SAMPLE_B_CL_V5_V4_gfx12, IMAGE_SAMPLE_B_CL, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 3725
  { IMAGE_SAMPLE_B_CL_V5_V5_gfx12, IMAGE_SAMPLE_B_CL, MIMGEncGfx12, 0x5, 0x5, 0x5 }, // 3726
  { IMAGE_SAMPLE_B_CL_V1_V2, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 3727
  { IMAGE_SAMPLE_B_CL_V1_V3, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 3728
  { IMAGE_SAMPLE_B_CL_V1_V4, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 3729
  { IMAGE_SAMPLE_B_CL_V1_V5, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 3730
  { IMAGE_SAMPLE_B_CL_V1_V8, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 3731
  { IMAGE_SAMPLE_B_CL_V2_V2, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 3732
  { IMAGE_SAMPLE_B_CL_V2_V3, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 3733
  { IMAGE_SAMPLE_B_CL_V2_V4, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 3734
  { IMAGE_SAMPLE_B_CL_V2_V5, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 3735
  { IMAGE_SAMPLE_B_CL_V2_V8, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 3736
  { IMAGE_SAMPLE_B_CL_V3_V2, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 3737
  { IMAGE_SAMPLE_B_CL_V3_V3, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 3738
  { IMAGE_SAMPLE_B_CL_V3_V4, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 3739
  { IMAGE_SAMPLE_B_CL_V3_V5, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 3740
  { IMAGE_SAMPLE_B_CL_V3_V8, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 3741
  { IMAGE_SAMPLE_B_CL_V4_V2, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 3742
  { IMAGE_SAMPLE_B_CL_V4_V3, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 3743
  { IMAGE_SAMPLE_B_CL_V4_V4, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 3744
  { IMAGE_SAMPLE_B_CL_V4_V5, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 3745
  { IMAGE_SAMPLE_B_CL_V4_V8, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 3746
  { IMAGE_SAMPLE_B_CL_V5_V2, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 3747
  { IMAGE_SAMPLE_B_CL_V5_V3, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 3748
  { IMAGE_SAMPLE_B_CL_V5_V4, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 3749
  { IMAGE_SAMPLE_B_CL_V5_V5, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 3750
  { IMAGE_SAMPLE_B_CL_V5_V8, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 3751
  { IMAGE_SAMPLE_B_CL_O_V1_V3_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 3752
  { IMAGE_SAMPLE_B_CL_O_V1_V4_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 3753
  { IMAGE_SAMPLE_B_CL_O_V1_V5_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 3754
  { IMAGE_SAMPLE_B_CL_O_V1_V6_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 3755
  { IMAGE_SAMPLE_B_CL_O_V1_V8_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 3756
  { IMAGE_SAMPLE_B_CL_O_V2_V3_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 3757
  { IMAGE_SAMPLE_B_CL_O_V2_V4_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 3758
  { IMAGE_SAMPLE_B_CL_O_V2_V5_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 3759
  { IMAGE_SAMPLE_B_CL_O_V2_V6_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 3760
  { IMAGE_SAMPLE_B_CL_O_V2_V8_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 3761
  { IMAGE_SAMPLE_B_CL_O_V3_V3_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 3762
  { IMAGE_SAMPLE_B_CL_O_V3_V4_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 3763
  { IMAGE_SAMPLE_B_CL_O_V3_V5_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 3764
  { IMAGE_SAMPLE_B_CL_O_V3_V6_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 3765
  { IMAGE_SAMPLE_B_CL_O_V3_V8_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 3766
  { IMAGE_SAMPLE_B_CL_O_V4_V3_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 3767
  { IMAGE_SAMPLE_B_CL_O_V4_V4_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 3768
  { IMAGE_SAMPLE_B_CL_O_V4_V5_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 3769
  { IMAGE_SAMPLE_B_CL_O_V4_V6_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 3770
  { IMAGE_SAMPLE_B_CL_O_V4_V8_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 3771
  { IMAGE_SAMPLE_B_CL_O_V5_V3_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 3772
  { IMAGE_SAMPLE_B_CL_O_V5_V4_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 3773
  { IMAGE_SAMPLE_B_CL_O_V5_V5_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 3774
  { IMAGE_SAMPLE_B_CL_O_V5_V6_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 3775
  { IMAGE_SAMPLE_B_CL_O_V5_V8_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 3776
  { IMAGE_SAMPLE_B_CL_O_V1_V3_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 3777
  { IMAGE_SAMPLE_B_CL_O_V1_V4_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 3778
  { IMAGE_SAMPLE_B_CL_O_V1_V5_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 3779
  { IMAGE_SAMPLE_B_CL_O_V1_V6_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 3780
  { IMAGE_SAMPLE_B_CL_O_V2_V3_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 3781
  { IMAGE_SAMPLE_B_CL_O_V2_V4_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 3782
  { IMAGE_SAMPLE_B_CL_O_V2_V5_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 3783
  { IMAGE_SAMPLE_B_CL_O_V2_V6_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 3784
  { IMAGE_SAMPLE_B_CL_O_V3_V3_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 3785
  { IMAGE_SAMPLE_B_CL_O_V3_V4_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 3786
  { IMAGE_SAMPLE_B_CL_O_V3_V5_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 3787
  { IMAGE_SAMPLE_B_CL_O_V3_V6_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 3788
  { IMAGE_SAMPLE_B_CL_O_V4_V3_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 3789
  { IMAGE_SAMPLE_B_CL_O_V4_V4_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 3790
  { IMAGE_SAMPLE_B_CL_O_V4_V5_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 3791
  { IMAGE_SAMPLE_B_CL_O_V4_V6_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 3792
  { IMAGE_SAMPLE_B_CL_O_V5_V3_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 3793
  { IMAGE_SAMPLE_B_CL_O_V5_V4_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 3794
  { IMAGE_SAMPLE_B_CL_O_V5_V5_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 3795
  { IMAGE_SAMPLE_B_CL_O_V5_V6_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 3796
  { IMAGE_SAMPLE_B_CL_O_V1_V3_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 3797
  { IMAGE_SAMPLE_B_CL_O_V1_V4_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 3798
  { IMAGE_SAMPLE_B_CL_O_V1_V5_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x1, 0x5, 0x1 }, // 3799
  { IMAGE_SAMPLE_B_CL_O_V1_V6_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x1, 0x6, 0x1 }, // 3800
  { IMAGE_SAMPLE_B_CL_O_V1_V8_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x1, 0x8, 0x1 }, // 3801
  { IMAGE_SAMPLE_B_CL_O_V2_V3_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 3802
  { IMAGE_SAMPLE_B_CL_O_V2_V4_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 3803
  { IMAGE_SAMPLE_B_CL_O_V2_V5_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 3804
  { IMAGE_SAMPLE_B_CL_O_V2_V6_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x2, 0x6, 0x1 }, // 3805
  { IMAGE_SAMPLE_B_CL_O_V2_V8_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 3806
  { IMAGE_SAMPLE_B_CL_O_V3_V3_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 3807
  { IMAGE_SAMPLE_B_CL_O_V3_V4_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 3808
  { IMAGE_SAMPLE_B_CL_O_V3_V5_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x3, 0x5, 0x1 }, // 3809
  { IMAGE_SAMPLE_B_CL_O_V3_V6_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x3, 0x6, 0x1 }, // 3810
  { IMAGE_SAMPLE_B_CL_O_V3_V8_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x3, 0x8, 0x1 }, // 3811
  { IMAGE_SAMPLE_B_CL_O_V4_V3_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 3812
  { IMAGE_SAMPLE_B_CL_O_V4_V4_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 3813
  { IMAGE_SAMPLE_B_CL_O_V4_V5_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 3814
  { IMAGE_SAMPLE_B_CL_O_V4_V6_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x4, 0x6, 0x1 }, // 3815
  { IMAGE_SAMPLE_B_CL_O_V4_V8_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 3816
  { IMAGE_SAMPLE_B_CL_O_V5_V3_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 3817
  { IMAGE_SAMPLE_B_CL_O_V5_V4_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 3818
  { IMAGE_SAMPLE_B_CL_O_V5_V5_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 3819
  { IMAGE_SAMPLE_B_CL_O_V5_V6_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x5, 0x6, 0x1 }, // 3820
  { IMAGE_SAMPLE_B_CL_O_V5_V8_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 3821
  { IMAGE_SAMPLE_B_CL_O_V1_V3_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 3822
  { IMAGE_SAMPLE_B_CL_O_V1_V4_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 3823
  { IMAGE_SAMPLE_B_CL_O_V1_V5_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x1, 0x5, 0x5 }, // 3824
  { IMAGE_SAMPLE_B_CL_O_V1_V6_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x1, 0x6, 0x6 }, // 3825
  { IMAGE_SAMPLE_B_CL_O_V2_V3_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 3826
  { IMAGE_SAMPLE_B_CL_O_V2_V4_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 3827
  { IMAGE_SAMPLE_B_CL_O_V2_V5_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 3828
  { IMAGE_SAMPLE_B_CL_O_V2_V6_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x2, 0x6, 0x6 }, // 3829
  { IMAGE_SAMPLE_B_CL_O_V3_V3_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 3830
  { IMAGE_SAMPLE_B_CL_O_V3_V4_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 3831
  { IMAGE_SAMPLE_B_CL_O_V3_V5_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x3, 0x5, 0x5 }, // 3832
  { IMAGE_SAMPLE_B_CL_O_V3_V6_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x3, 0x6, 0x6 }, // 3833
  { IMAGE_SAMPLE_B_CL_O_V4_V3_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 3834
  { IMAGE_SAMPLE_B_CL_O_V4_V4_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 3835
  { IMAGE_SAMPLE_B_CL_O_V4_V5_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 3836
  { IMAGE_SAMPLE_B_CL_O_V4_V6_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x4, 0x6, 0x6 }, // 3837
  { IMAGE_SAMPLE_B_CL_O_V5_V3_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 3838
  { IMAGE_SAMPLE_B_CL_O_V5_V4_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 3839
  { IMAGE_SAMPLE_B_CL_O_V5_V5_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 3840
  { IMAGE_SAMPLE_B_CL_O_V5_V6_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x5, 0x6, 0x6 }, // 3841
  { IMAGE_SAMPLE_B_CL_O_V1_V3_gfx12, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 3842
  { IMAGE_SAMPLE_B_CL_O_V1_V4_gfx12, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 3843
  { IMAGE_SAMPLE_B_CL_O_V1_V5_gfx12, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx12, 0x1, 0x5, 0x5 }, // 3844
  { IMAGE_SAMPLE_B_CL_O_V1_V6_gfx12, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx12, 0x1, 0x6, 0x6 }, // 3845
  { IMAGE_SAMPLE_B_CL_O_V2_V3_gfx12, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 3846
  { IMAGE_SAMPLE_B_CL_O_V2_V4_gfx12, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 3847
  { IMAGE_SAMPLE_B_CL_O_V2_V5_gfx12, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx12, 0x2, 0x5, 0x5 }, // 3848
  { IMAGE_SAMPLE_B_CL_O_V2_V6_gfx12, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx12, 0x2, 0x6, 0x6 }, // 3849
  { IMAGE_SAMPLE_B_CL_O_V3_V3_gfx12, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 3850
  { IMAGE_SAMPLE_B_CL_O_V3_V4_gfx12, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 3851
  { IMAGE_SAMPLE_B_CL_O_V3_V5_gfx12, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx12, 0x3, 0x5, 0x5 }, // 3852
  { IMAGE_SAMPLE_B_CL_O_V3_V6_gfx12, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx12, 0x3, 0x6, 0x6 }, // 3853
  { IMAGE_SAMPLE_B_CL_O_V4_V3_gfx12, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 3854
  { IMAGE_SAMPLE_B_CL_O_V4_V4_gfx12, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 3855
  { IMAGE_SAMPLE_B_CL_O_V4_V5_gfx12, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx12, 0x4, 0x5, 0x5 }, // 3856
  { IMAGE_SAMPLE_B_CL_O_V4_V6_gfx12, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx12, 0x4, 0x6, 0x6 }, // 3857
  { IMAGE_SAMPLE_B_CL_O_V5_V3_gfx12, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 3858
  { IMAGE_SAMPLE_B_CL_O_V5_V4_gfx12, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 3859
  { IMAGE_SAMPLE_B_CL_O_V5_V5_gfx12, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx12, 0x5, 0x5, 0x5 }, // 3860
  { IMAGE_SAMPLE_B_CL_O_V5_V6_gfx12, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx12, 0x5, 0x6, 0x6 }, // 3861
  { IMAGE_SAMPLE_B_CL_O_V1_V3, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 3862
  { IMAGE_SAMPLE_B_CL_O_V1_V4, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 3863
  { IMAGE_SAMPLE_B_CL_O_V1_V5, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 3864
  { IMAGE_SAMPLE_B_CL_O_V1_V6, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 3865
  { IMAGE_SAMPLE_B_CL_O_V1_V8, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 3866
  { IMAGE_SAMPLE_B_CL_O_V2_V3, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 3867
  { IMAGE_SAMPLE_B_CL_O_V2_V4, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 3868
  { IMAGE_SAMPLE_B_CL_O_V2_V5, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 3869
  { IMAGE_SAMPLE_B_CL_O_V2_V6, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 3870
  { IMAGE_SAMPLE_B_CL_O_V2_V8, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 3871
  { IMAGE_SAMPLE_B_CL_O_V3_V3, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 3872
  { IMAGE_SAMPLE_B_CL_O_V3_V4, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 3873
  { IMAGE_SAMPLE_B_CL_O_V3_V5, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 3874
  { IMAGE_SAMPLE_B_CL_O_V3_V6, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 3875
  { IMAGE_SAMPLE_B_CL_O_V3_V8, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 3876
  { IMAGE_SAMPLE_B_CL_O_V4_V3, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 3877
  { IMAGE_SAMPLE_B_CL_O_V4_V4, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 3878
  { IMAGE_SAMPLE_B_CL_O_V4_V5, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 3879
  { IMAGE_SAMPLE_B_CL_O_V4_V6, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 3880
  { IMAGE_SAMPLE_B_CL_O_V4_V8, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 3881
  { IMAGE_SAMPLE_B_CL_O_V5_V3, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 3882
  { IMAGE_SAMPLE_B_CL_O_V5_V4, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 3883
  { IMAGE_SAMPLE_B_CL_O_V5_V5, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 3884
  { IMAGE_SAMPLE_B_CL_O_V5_V6, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 3885
  { IMAGE_SAMPLE_B_CL_O_V5_V8, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 3886
  { IMAGE_SAMPLE_B_O_V1_V3_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 3887
  { IMAGE_SAMPLE_B_O_V1_V4_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 3888
  { IMAGE_SAMPLE_B_O_V1_V5_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 3889
  { IMAGE_SAMPLE_B_O_V1_V8_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 3890
  { IMAGE_SAMPLE_B_O_V2_V3_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 3891
  { IMAGE_SAMPLE_B_O_V2_V4_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 3892
  { IMAGE_SAMPLE_B_O_V2_V5_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 3893
  { IMAGE_SAMPLE_B_O_V2_V8_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 3894
  { IMAGE_SAMPLE_B_O_V3_V3_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 3895
  { IMAGE_SAMPLE_B_O_V3_V4_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 3896
  { IMAGE_SAMPLE_B_O_V3_V5_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 3897
  { IMAGE_SAMPLE_B_O_V3_V8_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 3898
  { IMAGE_SAMPLE_B_O_V4_V3_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 3899
  { IMAGE_SAMPLE_B_O_V4_V4_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 3900
  { IMAGE_SAMPLE_B_O_V4_V5_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 3901
  { IMAGE_SAMPLE_B_O_V4_V8_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 3902
  { IMAGE_SAMPLE_B_O_V5_V3_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 3903
  { IMAGE_SAMPLE_B_O_V5_V4_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 3904
  { IMAGE_SAMPLE_B_O_V5_V5_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 3905
  { IMAGE_SAMPLE_B_O_V5_V8_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 3906
  { IMAGE_SAMPLE_B_O_V1_V3_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 3907
  { IMAGE_SAMPLE_B_O_V1_V4_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 3908
  { IMAGE_SAMPLE_B_O_V1_V5_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 3909
  { IMAGE_SAMPLE_B_O_V2_V3_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 3910
  { IMAGE_SAMPLE_B_O_V2_V4_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 3911
  { IMAGE_SAMPLE_B_O_V2_V5_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 3912
  { IMAGE_SAMPLE_B_O_V3_V3_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 3913
  { IMAGE_SAMPLE_B_O_V3_V4_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 3914
  { IMAGE_SAMPLE_B_O_V3_V5_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 3915
  { IMAGE_SAMPLE_B_O_V4_V3_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 3916
  { IMAGE_SAMPLE_B_O_V4_V4_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 3917
  { IMAGE_SAMPLE_B_O_V4_V5_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 3918
  { IMAGE_SAMPLE_B_O_V5_V3_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 3919
  { IMAGE_SAMPLE_B_O_V5_V4_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 3920
  { IMAGE_SAMPLE_B_O_V5_V5_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 3921
  { IMAGE_SAMPLE_B_O_V1_V3_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 3922
  { IMAGE_SAMPLE_B_O_V1_V4_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 3923
  { IMAGE_SAMPLE_B_O_V1_V5_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x1, 0x5, 0x1 }, // 3924
  { IMAGE_SAMPLE_B_O_V1_V8_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x1, 0x8, 0x1 }, // 3925
  { IMAGE_SAMPLE_B_O_V2_V3_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 3926
  { IMAGE_SAMPLE_B_O_V2_V4_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 3927
  { IMAGE_SAMPLE_B_O_V2_V5_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 3928
  { IMAGE_SAMPLE_B_O_V2_V8_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 3929
  { IMAGE_SAMPLE_B_O_V3_V3_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 3930
  { IMAGE_SAMPLE_B_O_V3_V4_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 3931
  { IMAGE_SAMPLE_B_O_V3_V5_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x3, 0x5, 0x1 }, // 3932
  { IMAGE_SAMPLE_B_O_V3_V8_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x3, 0x8, 0x1 }, // 3933
  { IMAGE_SAMPLE_B_O_V4_V3_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 3934
  { IMAGE_SAMPLE_B_O_V4_V4_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 3935
  { IMAGE_SAMPLE_B_O_V4_V5_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 3936
  { IMAGE_SAMPLE_B_O_V4_V8_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 3937
  { IMAGE_SAMPLE_B_O_V5_V3_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 3938
  { IMAGE_SAMPLE_B_O_V5_V4_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 3939
  { IMAGE_SAMPLE_B_O_V5_V5_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 3940
  { IMAGE_SAMPLE_B_O_V5_V8_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 3941
  { IMAGE_SAMPLE_B_O_V1_V3_nsa_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 3942
  { IMAGE_SAMPLE_B_O_V1_V4_nsa_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 3943
  { IMAGE_SAMPLE_B_O_V1_V5_nsa_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11NSA, 0x1, 0x5, 0x5 }, // 3944
  { IMAGE_SAMPLE_B_O_V2_V3_nsa_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 3945
  { IMAGE_SAMPLE_B_O_V2_V4_nsa_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 3946
  { IMAGE_SAMPLE_B_O_V2_V5_nsa_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 3947
  { IMAGE_SAMPLE_B_O_V3_V3_nsa_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 3948
  { IMAGE_SAMPLE_B_O_V3_V4_nsa_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 3949
  { IMAGE_SAMPLE_B_O_V3_V5_nsa_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11NSA, 0x3, 0x5, 0x5 }, // 3950
  { IMAGE_SAMPLE_B_O_V4_V3_nsa_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 3951
  { IMAGE_SAMPLE_B_O_V4_V4_nsa_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 3952
  { IMAGE_SAMPLE_B_O_V4_V5_nsa_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 3953
  { IMAGE_SAMPLE_B_O_V5_V3_nsa_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 3954
  { IMAGE_SAMPLE_B_O_V5_V4_nsa_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 3955
  { IMAGE_SAMPLE_B_O_V5_V5_nsa_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 3956
  { IMAGE_SAMPLE_B_O_V1_V3_gfx12, IMAGE_SAMPLE_B_O, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 3957
  { IMAGE_SAMPLE_B_O_V1_V4_gfx12, IMAGE_SAMPLE_B_O, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 3958
  { IMAGE_SAMPLE_B_O_V1_V5_gfx12, IMAGE_SAMPLE_B_O, MIMGEncGfx12, 0x1, 0x5, 0x5 }, // 3959
  { IMAGE_SAMPLE_B_O_V2_V3_gfx12, IMAGE_SAMPLE_B_O, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 3960
  { IMAGE_SAMPLE_B_O_V2_V4_gfx12, IMAGE_SAMPLE_B_O, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 3961
  { IMAGE_SAMPLE_B_O_V2_V5_gfx12, IMAGE_SAMPLE_B_O, MIMGEncGfx12, 0x2, 0x5, 0x5 }, // 3962
  { IMAGE_SAMPLE_B_O_V3_V3_gfx12, IMAGE_SAMPLE_B_O, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 3963
  { IMAGE_SAMPLE_B_O_V3_V4_gfx12, IMAGE_SAMPLE_B_O, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 3964
  { IMAGE_SAMPLE_B_O_V3_V5_gfx12, IMAGE_SAMPLE_B_O, MIMGEncGfx12, 0x3, 0x5, 0x5 }, // 3965
  { IMAGE_SAMPLE_B_O_V4_V3_gfx12, IMAGE_SAMPLE_B_O, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 3966
  { IMAGE_SAMPLE_B_O_V4_V4_gfx12, IMAGE_SAMPLE_B_O, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 3967
  { IMAGE_SAMPLE_B_O_V4_V5_gfx12, IMAGE_SAMPLE_B_O, MIMGEncGfx12, 0x4, 0x5, 0x5 }, // 3968
  { IMAGE_SAMPLE_B_O_V5_V3_gfx12, IMAGE_SAMPLE_B_O, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 3969
  { IMAGE_SAMPLE_B_O_V5_V4_gfx12, IMAGE_SAMPLE_B_O, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 3970
  { IMAGE_SAMPLE_B_O_V5_V5_gfx12, IMAGE_SAMPLE_B_O, MIMGEncGfx12, 0x5, 0x5, 0x5 }, // 3971
  { IMAGE_SAMPLE_B_O_V1_V3, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 3972
  { IMAGE_SAMPLE_B_O_V1_V4, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 3973
  { IMAGE_SAMPLE_B_O_V1_V5, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 3974
  { IMAGE_SAMPLE_B_O_V1_V8, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 3975
  { IMAGE_SAMPLE_B_O_V2_V3, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 3976
  { IMAGE_SAMPLE_B_O_V2_V4, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 3977
  { IMAGE_SAMPLE_B_O_V2_V5, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 3978
  { IMAGE_SAMPLE_B_O_V2_V8, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 3979
  { IMAGE_SAMPLE_B_O_V3_V3, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 3980
  { IMAGE_SAMPLE_B_O_V3_V4, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 3981
  { IMAGE_SAMPLE_B_O_V3_V5, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 3982
  { IMAGE_SAMPLE_B_O_V3_V8, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 3983
  { IMAGE_SAMPLE_B_O_V4_V3, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 3984
  { IMAGE_SAMPLE_B_O_V4_V4, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 3985
  { IMAGE_SAMPLE_B_O_V4_V5, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 3986
  { IMAGE_SAMPLE_B_O_V4_V8, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 3987
  { IMAGE_SAMPLE_B_O_V5_V3, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 3988
  { IMAGE_SAMPLE_B_O_V5_V4, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 3989
  { IMAGE_SAMPLE_B_O_V5_V5, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 3990
  { IMAGE_SAMPLE_B_O_V5_V8, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 3991
  { IMAGE_SAMPLE_C_V1_V2_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 3992
  { IMAGE_SAMPLE_C_V1_V3_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 3993
  { IMAGE_SAMPLE_C_V1_V4_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 3994
  { IMAGE_SAMPLE_C_V2_V2_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 3995
  { IMAGE_SAMPLE_C_V2_V3_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 3996
  { IMAGE_SAMPLE_C_V2_V4_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 3997
  { IMAGE_SAMPLE_C_V3_V2_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 3998
  { IMAGE_SAMPLE_C_V3_V3_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 3999
  { IMAGE_SAMPLE_C_V3_V4_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 4000
  { IMAGE_SAMPLE_C_V4_V2_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 4001
  { IMAGE_SAMPLE_C_V4_V3_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 4002
  { IMAGE_SAMPLE_C_V4_V4_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 4003
  { IMAGE_SAMPLE_C_V5_V2_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 4004
  { IMAGE_SAMPLE_C_V5_V3_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 4005
  { IMAGE_SAMPLE_C_V5_V4_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 4006
  { IMAGE_SAMPLE_C_V1_V2_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 4007
  { IMAGE_SAMPLE_C_V1_V3_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 4008
  { IMAGE_SAMPLE_C_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 4009
  { IMAGE_SAMPLE_C_V2_V2_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 4010
  { IMAGE_SAMPLE_C_V2_V3_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 4011
  { IMAGE_SAMPLE_C_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 4012
  { IMAGE_SAMPLE_C_V3_V2_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 4013
  { IMAGE_SAMPLE_C_V3_V3_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 4014
  { IMAGE_SAMPLE_C_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 4015
  { IMAGE_SAMPLE_C_V4_V2_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 4016
  { IMAGE_SAMPLE_C_V4_V3_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 4017
  { IMAGE_SAMPLE_C_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 4018
  { IMAGE_SAMPLE_C_V5_V2_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 4019
  { IMAGE_SAMPLE_C_V5_V3_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 4020
  { IMAGE_SAMPLE_C_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 4021
  { IMAGE_SAMPLE_C_V1_V2_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 4022
  { IMAGE_SAMPLE_C_V1_V3_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 4023
  { IMAGE_SAMPLE_C_V1_V4_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 4024
  { IMAGE_SAMPLE_C_V2_V2_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 4025
  { IMAGE_SAMPLE_C_V2_V3_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 4026
  { IMAGE_SAMPLE_C_V2_V4_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 4027
  { IMAGE_SAMPLE_C_V3_V2_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 4028
  { IMAGE_SAMPLE_C_V3_V3_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 4029
  { IMAGE_SAMPLE_C_V3_V4_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 4030
  { IMAGE_SAMPLE_C_V4_V2_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 4031
  { IMAGE_SAMPLE_C_V4_V3_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 4032
  { IMAGE_SAMPLE_C_V4_V4_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 4033
  { IMAGE_SAMPLE_C_V5_V2_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 4034
  { IMAGE_SAMPLE_C_V5_V3_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 4035
  { IMAGE_SAMPLE_C_V5_V4_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 4036
  { IMAGE_SAMPLE_C_V1_V2_nsa_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 4037
  { IMAGE_SAMPLE_C_V1_V3_nsa_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 4038
  { IMAGE_SAMPLE_C_V1_V4_nsa_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 4039
  { IMAGE_SAMPLE_C_V2_V2_nsa_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 4040
  { IMAGE_SAMPLE_C_V2_V3_nsa_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 4041
  { IMAGE_SAMPLE_C_V2_V4_nsa_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 4042
  { IMAGE_SAMPLE_C_V3_V2_nsa_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 4043
  { IMAGE_SAMPLE_C_V3_V3_nsa_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 4044
  { IMAGE_SAMPLE_C_V3_V4_nsa_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 4045
  { IMAGE_SAMPLE_C_V4_V2_nsa_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 4046
  { IMAGE_SAMPLE_C_V4_V3_nsa_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 4047
  { IMAGE_SAMPLE_C_V4_V4_nsa_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 4048
  { IMAGE_SAMPLE_C_V5_V2_nsa_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 4049
  { IMAGE_SAMPLE_C_V5_V3_nsa_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 4050
  { IMAGE_SAMPLE_C_V5_V4_nsa_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 4051
  { IMAGE_SAMPLE_C_V1_V2_gfx12, IMAGE_SAMPLE_C, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 4052
  { IMAGE_SAMPLE_C_V1_V3_gfx12, IMAGE_SAMPLE_C, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 4053
  { IMAGE_SAMPLE_C_V1_V4_gfx12, IMAGE_SAMPLE_C, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 4054
  { IMAGE_SAMPLE_C_V2_V2_gfx12, IMAGE_SAMPLE_C, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 4055
  { IMAGE_SAMPLE_C_V2_V3_gfx12, IMAGE_SAMPLE_C, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 4056
  { IMAGE_SAMPLE_C_V2_V4_gfx12, IMAGE_SAMPLE_C, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 4057
  { IMAGE_SAMPLE_C_V3_V2_gfx12, IMAGE_SAMPLE_C, MIMGEncGfx12, 0x3, 0x2, 0x2 }, // 4058
  { IMAGE_SAMPLE_C_V3_V3_gfx12, IMAGE_SAMPLE_C, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 4059
  { IMAGE_SAMPLE_C_V3_V4_gfx12, IMAGE_SAMPLE_C, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 4060
  { IMAGE_SAMPLE_C_V4_V2_gfx12, IMAGE_SAMPLE_C, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 4061
  { IMAGE_SAMPLE_C_V4_V3_gfx12, IMAGE_SAMPLE_C, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 4062
  { IMAGE_SAMPLE_C_V4_V4_gfx12, IMAGE_SAMPLE_C, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 4063
  { IMAGE_SAMPLE_C_V5_V2_gfx12, IMAGE_SAMPLE_C, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 4064
  { IMAGE_SAMPLE_C_V5_V3_gfx12, IMAGE_SAMPLE_C, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 4065
  { IMAGE_SAMPLE_C_V5_V4_gfx12, IMAGE_SAMPLE_C, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 4066
  { IMAGE_SAMPLE_C_V1_V2, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 4067
  { IMAGE_SAMPLE_C_V1_V3, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 4068
  { IMAGE_SAMPLE_C_V1_V4, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 4069
  { IMAGE_SAMPLE_C_V2_V2, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 4070
  { IMAGE_SAMPLE_C_V2_V3, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 4071
  { IMAGE_SAMPLE_C_V2_V4, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 4072
  { IMAGE_SAMPLE_C_V3_V2, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 4073
  { IMAGE_SAMPLE_C_V3_V3, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 4074
  { IMAGE_SAMPLE_C_V3_V4, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 4075
  { IMAGE_SAMPLE_C_V4_V2, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 4076
  { IMAGE_SAMPLE_C_V4_V3, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 4077
  { IMAGE_SAMPLE_C_V4_V4, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 4078
  { IMAGE_SAMPLE_C_V5_V2, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 4079
  { IMAGE_SAMPLE_C_V5_V3, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 4080
  { IMAGE_SAMPLE_C_V5_V4, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 4081
  { IMAGE_SAMPLE_CD_V1_V2_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 4082
  { IMAGE_SAMPLE_CD_V1_V3_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 4083
  { IMAGE_SAMPLE_CD_V1_V4_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 4084
  { IMAGE_SAMPLE_CD_V1_V5_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 4085
  { IMAGE_SAMPLE_CD_V1_V6_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 4086
  { IMAGE_SAMPLE_CD_V1_V7_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x1, 0x7, 0x1 }, // 4087
  { IMAGE_SAMPLE_CD_V1_V8_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 4088
  { IMAGE_SAMPLE_CD_V1_V9_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x1, 0x9, 0x1 }, // 4089
  { IMAGE_SAMPLE_CD_V2_V2_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 4090
  { IMAGE_SAMPLE_CD_V2_V3_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 4091
  { IMAGE_SAMPLE_CD_V2_V4_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 4092
  { IMAGE_SAMPLE_CD_V2_V5_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 4093
  { IMAGE_SAMPLE_CD_V2_V6_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 4094
  { IMAGE_SAMPLE_CD_V2_V7_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x2, 0x7, 0x1 }, // 4095
  { IMAGE_SAMPLE_CD_V2_V8_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 4096
  { IMAGE_SAMPLE_CD_V2_V9_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x2, 0x9, 0x1 }, // 4097
  { IMAGE_SAMPLE_CD_V3_V2_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 4098
  { IMAGE_SAMPLE_CD_V3_V3_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 4099
  { IMAGE_SAMPLE_CD_V3_V4_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 4100
  { IMAGE_SAMPLE_CD_V3_V5_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 4101
  { IMAGE_SAMPLE_CD_V3_V6_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 4102
  { IMAGE_SAMPLE_CD_V3_V7_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x3, 0x7, 0x1 }, // 4103
  { IMAGE_SAMPLE_CD_V3_V8_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 4104
  { IMAGE_SAMPLE_CD_V3_V9_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x3, 0x9, 0x1 }, // 4105
  { IMAGE_SAMPLE_CD_V4_V2_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 4106
  { IMAGE_SAMPLE_CD_V4_V3_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 4107
  { IMAGE_SAMPLE_CD_V4_V4_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 4108
  { IMAGE_SAMPLE_CD_V4_V5_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 4109
  { IMAGE_SAMPLE_CD_V4_V6_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 4110
  { IMAGE_SAMPLE_CD_V4_V7_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x4, 0x7, 0x1 }, // 4111
  { IMAGE_SAMPLE_CD_V4_V8_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 4112
  { IMAGE_SAMPLE_CD_V4_V9_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x4, 0x9, 0x1 }, // 4113
  { IMAGE_SAMPLE_CD_V5_V2_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 4114
  { IMAGE_SAMPLE_CD_V5_V3_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 4115
  { IMAGE_SAMPLE_CD_V5_V4_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 4116
  { IMAGE_SAMPLE_CD_V5_V5_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 4117
  { IMAGE_SAMPLE_CD_V5_V6_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 4118
  { IMAGE_SAMPLE_CD_V5_V7_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x5, 0x7, 0x1 }, // 4119
  { IMAGE_SAMPLE_CD_V5_V8_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 4120
  { IMAGE_SAMPLE_CD_V5_V9_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x5, 0x9, 0x1 }, // 4121
  { IMAGE_SAMPLE_CD_V1_V2_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 4122
  { IMAGE_SAMPLE_CD_V1_V3_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 4123
  { IMAGE_SAMPLE_CD_V1_V4_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 4124
  { IMAGE_SAMPLE_CD_V1_V5_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 4125
  { IMAGE_SAMPLE_CD_V1_V6_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 4126
  { IMAGE_SAMPLE_CD_V1_V7_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x1, 0x7, 0x7 }, // 4127
  { IMAGE_SAMPLE_CD_V1_V8_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x1, 0x8, 0x8 }, // 4128
  { IMAGE_SAMPLE_CD_V1_V9_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x1, 0x9, 0x9 }, // 4129
  { IMAGE_SAMPLE_CD_V2_V2_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 4130
  { IMAGE_SAMPLE_CD_V2_V3_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 4131
  { IMAGE_SAMPLE_CD_V2_V4_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 4132
  { IMAGE_SAMPLE_CD_V2_V5_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 4133
  { IMAGE_SAMPLE_CD_V2_V6_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 4134
  { IMAGE_SAMPLE_CD_V2_V7_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x2, 0x7, 0x7 }, // 4135
  { IMAGE_SAMPLE_CD_V2_V8_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x2, 0x8, 0x8 }, // 4136
  { IMAGE_SAMPLE_CD_V2_V9_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x2, 0x9, 0x9 }, // 4137
  { IMAGE_SAMPLE_CD_V3_V2_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 4138
  { IMAGE_SAMPLE_CD_V3_V3_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 4139
  { IMAGE_SAMPLE_CD_V3_V4_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 4140
  { IMAGE_SAMPLE_CD_V3_V5_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 4141
  { IMAGE_SAMPLE_CD_V3_V6_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 4142
  { IMAGE_SAMPLE_CD_V3_V7_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x3, 0x7, 0x7 }, // 4143
  { IMAGE_SAMPLE_CD_V3_V8_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x3, 0x8, 0x8 }, // 4144
  { IMAGE_SAMPLE_CD_V3_V9_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x3, 0x9, 0x9 }, // 4145
  { IMAGE_SAMPLE_CD_V4_V2_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 4146
  { IMAGE_SAMPLE_CD_V4_V3_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 4147
  { IMAGE_SAMPLE_CD_V4_V4_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 4148
  { IMAGE_SAMPLE_CD_V4_V5_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 4149
  { IMAGE_SAMPLE_CD_V4_V6_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 4150
  { IMAGE_SAMPLE_CD_V4_V7_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x4, 0x7, 0x7 }, // 4151
  { IMAGE_SAMPLE_CD_V4_V8_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x4, 0x8, 0x8 }, // 4152
  { IMAGE_SAMPLE_CD_V4_V9_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x4, 0x9, 0x9 }, // 4153
  { IMAGE_SAMPLE_CD_V5_V2_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 4154
  { IMAGE_SAMPLE_CD_V5_V3_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 4155
  { IMAGE_SAMPLE_CD_V5_V4_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 4156
  { IMAGE_SAMPLE_CD_V5_V5_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 4157
  { IMAGE_SAMPLE_CD_V5_V6_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 4158
  { IMAGE_SAMPLE_CD_V5_V7_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x5, 0x7, 0x7 }, // 4159
  { IMAGE_SAMPLE_CD_V5_V8_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x5, 0x8, 0x8 }, // 4160
  { IMAGE_SAMPLE_CD_V5_V9_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x5, 0x9, 0x9 }, // 4161
  { IMAGE_SAMPLE_CD_V1_V2, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 4162
  { IMAGE_SAMPLE_CD_V1_V3, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 4163
  { IMAGE_SAMPLE_CD_V1_V4, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 4164
  { IMAGE_SAMPLE_CD_V1_V5, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 4165
  { IMAGE_SAMPLE_CD_V1_V6, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 4166
  { IMAGE_SAMPLE_CD_V1_V7, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x1, 0x7, 0x1 }, // 4167
  { IMAGE_SAMPLE_CD_V1_V8, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 4168
  { IMAGE_SAMPLE_CD_V1_V9, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x1, 0x9, 0x1 }, // 4169
  { IMAGE_SAMPLE_CD_V2_V2, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 4170
  { IMAGE_SAMPLE_CD_V2_V3, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 4171
  { IMAGE_SAMPLE_CD_V2_V4, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 4172
  { IMAGE_SAMPLE_CD_V2_V5, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 4173
  { IMAGE_SAMPLE_CD_V2_V6, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 4174
  { IMAGE_SAMPLE_CD_V2_V7, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x2, 0x7, 0x1 }, // 4175
  { IMAGE_SAMPLE_CD_V2_V8, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 4176
  { IMAGE_SAMPLE_CD_V2_V9, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x2, 0x9, 0x1 }, // 4177
  { IMAGE_SAMPLE_CD_V3_V2, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 4178
  { IMAGE_SAMPLE_CD_V3_V3, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 4179
  { IMAGE_SAMPLE_CD_V3_V4, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 4180
  { IMAGE_SAMPLE_CD_V3_V5, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 4181
  { IMAGE_SAMPLE_CD_V3_V6, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 4182
  { IMAGE_SAMPLE_CD_V3_V7, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x3, 0x7, 0x1 }, // 4183
  { IMAGE_SAMPLE_CD_V3_V8, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 4184
  { IMAGE_SAMPLE_CD_V3_V9, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x3, 0x9, 0x1 }, // 4185
  { IMAGE_SAMPLE_CD_V4_V2, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 4186
  { IMAGE_SAMPLE_CD_V4_V3, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 4187
  { IMAGE_SAMPLE_CD_V4_V4, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 4188
  { IMAGE_SAMPLE_CD_V4_V5, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 4189
  { IMAGE_SAMPLE_CD_V4_V6, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 4190
  { IMAGE_SAMPLE_CD_V4_V7, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x4, 0x7, 0x1 }, // 4191
  { IMAGE_SAMPLE_CD_V4_V8, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 4192
  { IMAGE_SAMPLE_CD_V4_V9, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x4, 0x9, 0x1 }, // 4193
  { IMAGE_SAMPLE_CD_V5_V2, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 4194
  { IMAGE_SAMPLE_CD_V5_V3, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 4195
  { IMAGE_SAMPLE_CD_V5_V4, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 4196
  { IMAGE_SAMPLE_CD_V5_V5, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 4197
  { IMAGE_SAMPLE_CD_V5_V6, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 4198
  { IMAGE_SAMPLE_CD_V5_V7, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x5, 0x7, 0x1 }, // 4199
  { IMAGE_SAMPLE_CD_V5_V8, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 4200
  { IMAGE_SAMPLE_CD_V5_V9, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x5, 0x9, 0x1 }, // 4201
  { IMAGE_SAMPLE_CD_CL_V1_V2_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 4202
  { IMAGE_SAMPLE_CD_CL_V1_V3_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 4203
  { IMAGE_SAMPLE_CD_CL_V1_V4_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 4204
  { IMAGE_SAMPLE_CD_CL_V1_V5_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 4205
  { IMAGE_SAMPLE_CD_CL_V1_V6_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 4206
  { IMAGE_SAMPLE_CD_CL_V1_V7_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x1, 0x7, 0x1 }, // 4207
  { IMAGE_SAMPLE_CD_CL_V1_V8_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 4208
  { IMAGE_SAMPLE_CD_CL_V1_V9_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x1, 0x9, 0x1 }, // 4209
  { IMAGE_SAMPLE_CD_CL_V1_V10_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x1, 0xA, 0x1 }, // 4210
  { IMAGE_SAMPLE_CD_CL_V2_V2_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 4211
  { IMAGE_SAMPLE_CD_CL_V2_V3_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 4212
  { IMAGE_SAMPLE_CD_CL_V2_V4_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 4213
  { IMAGE_SAMPLE_CD_CL_V2_V5_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 4214
  { IMAGE_SAMPLE_CD_CL_V2_V6_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 4215
  { IMAGE_SAMPLE_CD_CL_V2_V7_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x2, 0x7, 0x1 }, // 4216
  { IMAGE_SAMPLE_CD_CL_V2_V8_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 4217
  { IMAGE_SAMPLE_CD_CL_V2_V9_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x2, 0x9, 0x1 }, // 4218
  { IMAGE_SAMPLE_CD_CL_V2_V10_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x2, 0xA, 0x1 }, // 4219
  { IMAGE_SAMPLE_CD_CL_V3_V2_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 4220
  { IMAGE_SAMPLE_CD_CL_V3_V3_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 4221
  { IMAGE_SAMPLE_CD_CL_V3_V4_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 4222
  { IMAGE_SAMPLE_CD_CL_V3_V5_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 4223
  { IMAGE_SAMPLE_CD_CL_V3_V6_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 4224
  { IMAGE_SAMPLE_CD_CL_V3_V7_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x3, 0x7, 0x1 }, // 4225
  { IMAGE_SAMPLE_CD_CL_V3_V8_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 4226
  { IMAGE_SAMPLE_CD_CL_V3_V9_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x3, 0x9, 0x1 }, // 4227
  { IMAGE_SAMPLE_CD_CL_V3_V10_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x3, 0xA, 0x1 }, // 4228
  { IMAGE_SAMPLE_CD_CL_V4_V2_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 4229
  { IMAGE_SAMPLE_CD_CL_V4_V3_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 4230
  { IMAGE_SAMPLE_CD_CL_V4_V4_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 4231
  { IMAGE_SAMPLE_CD_CL_V4_V5_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 4232
  { IMAGE_SAMPLE_CD_CL_V4_V6_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 4233
  { IMAGE_SAMPLE_CD_CL_V4_V7_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x4, 0x7, 0x1 }, // 4234
  { IMAGE_SAMPLE_CD_CL_V4_V8_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 4235
  { IMAGE_SAMPLE_CD_CL_V4_V9_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x4, 0x9, 0x1 }, // 4236
  { IMAGE_SAMPLE_CD_CL_V4_V10_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x4, 0xA, 0x1 }, // 4237
  { IMAGE_SAMPLE_CD_CL_V5_V2_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 4238
  { IMAGE_SAMPLE_CD_CL_V5_V3_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 4239
  { IMAGE_SAMPLE_CD_CL_V5_V4_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 4240
  { IMAGE_SAMPLE_CD_CL_V5_V5_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 4241
  { IMAGE_SAMPLE_CD_CL_V5_V6_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 4242
  { IMAGE_SAMPLE_CD_CL_V5_V7_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x5, 0x7, 0x1 }, // 4243
  { IMAGE_SAMPLE_CD_CL_V5_V8_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 4244
  { IMAGE_SAMPLE_CD_CL_V5_V9_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x5, 0x9, 0x1 }, // 4245
  { IMAGE_SAMPLE_CD_CL_V5_V10_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x5, 0xA, 0x1 }, // 4246
  { IMAGE_SAMPLE_CD_CL_V1_V2_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 4247
  { IMAGE_SAMPLE_CD_CL_V1_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 4248
  { IMAGE_SAMPLE_CD_CL_V1_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 4249
  { IMAGE_SAMPLE_CD_CL_V1_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 4250
  { IMAGE_SAMPLE_CD_CL_V1_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 4251
  { IMAGE_SAMPLE_CD_CL_V1_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x1, 0x7, 0x7 }, // 4252
  { IMAGE_SAMPLE_CD_CL_V1_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x1, 0x8, 0x8 }, // 4253
  { IMAGE_SAMPLE_CD_CL_V1_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x1, 0x9, 0x9 }, // 4254
  { IMAGE_SAMPLE_CD_CL_V1_V10_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x1, 0xA, 0xA }, // 4255
  { IMAGE_SAMPLE_CD_CL_V2_V2_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 4256
  { IMAGE_SAMPLE_CD_CL_V2_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 4257
  { IMAGE_SAMPLE_CD_CL_V2_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 4258
  { IMAGE_SAMPLE_CD_CL_V2_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 4259
  { IMAGE_SAMPLE_CD_CL_V2_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 4260
  { IMAGE_SAMPLE_CD_CL_V2_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x2, 0x7, 0x7 }, // 4261
  { IMAGE_SAMPLE_CD_CL_V2_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x2, 0x8, 0x8 }, // 4262
  { IMAGE_SAMPLE_CD_CL_V2_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x2, 0x9, 0x9 }, // 4263
  { IMAGE_SAMPLE_CD_CL_V2_V10_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x2, 0xA, 0xA }, // 4264
  { IMAGE_SAMPLE_CD_CL_V3_V2_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 4265
  { IMAGE_SAMPLE_CD_CL_V3_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 4266
  { IMAGE_SAMPLE_CD_CL_V3_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 4267
  { IMAGE_SAMPLE_CD_CL_V3_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 4268
  { IMAGE_SAMPLE_CD_CL_V3_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 4269
  { IMAGE_SAMPLE_CD_CL_V3_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x3, 0x7, 0x7 }, // 4270
  { IMAGE_SAMPLE_CD_CL_V3_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x3, 0x8, 0x8 }, // 4271
  { IMAGE_SAMPLE_CD_CL_V3_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x3, 0x9, 0x9 }, // 4272
  { IMAGE_SAMPLE_CD_CL_V3_V10_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x3, 0xA, 0xA }, // 4273
  { IMAGE_SAMPLE_CD_CL_V4_V2_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 4274
  { IMAGE_SAMPLE_CD_CL_V4_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 4275
  { IMAGE_SAMPLE_CD_CL_V4_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 4276
  { IMAGE_SAMPLE_CD_CL_V4_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 4277
  { IMAGE_SAMPLE_CD_CL_V4_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 4278
  { IMAGE_SAMPLE_CD_CL_V4_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x4, 0x7, 0x7 }, // 4279
  { IMAGE_SAMPLE_CD_CL_V4_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x4, 0x8, 0x8 }, // 4280
  { IMAGE_SAMPLE_CD_CL_V4_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x4, 0x9, 0x9 }, // 4281
  { IMAGE_SAMPLE_CD_CL_V4_V10_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x4, 0xA, 0xA }, // 4282
  { IMAGE_SAMPLE_CD_CL_V5_V2_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 4283
  { IMAGE_SAMPLE_CD_CL_V5_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 4284
  { IMAGE_SAMPLE_CD_CL_V5_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 4285
  { IMAGE_SAMPLE_CD_CL_V5_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 4286
  { IMAGE_SAMPLE_CD_CL_V5_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 4287
  { IMAGE_SAMPLE_CD_CL_V5_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x5, 0x7, 0x7 }, // 4288
  { IMAGE_SAMPLE_CD_CL_V5_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x5, 0x8, 0x8 }, // 4289
  { IMAGE_SAMPLE_CD_CL_V5_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x5, 0x9, 0x9 }, // 4290
  { IMAGE_SAMPLE_CD_CL_V5_V10_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x5, 0xA, 0xA }, // 4291
  { IMAGE_SAMPLE_CD_CL_V1_V2, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 4292
  { IMAGE_SAMPLE_CD_CL_V1_V3, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 4293
  { IMAGE_SAMPLE_CD_CL_V1_V4, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 4294
  { IMAGE_SAMPLE_CD_CL_V1_V5, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 4295
  { IMAGE_SAMPLE_CD_CL_V1_V6, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 4296
  { IMAGE_SAMPLE_CD_CL_V1_V7, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x1, 0x7, 0x1 }, // 4297
  { IMAGE_SAMPLE_CD_CL_V1_V8, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 4298
  { IMAGE_SAMPLE_CD_CL_V1_V9, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x1, 0x9, 0x1 }, // 4299
  { IMAGE_SAMPLE_CD_CL_V1_V10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x1, 0xA, 0x1 }, // 4300
  { IMAGE_SAMPLE_CD_CL_V2_V2, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 4301
  { IMAGE_SAMPLE_CD_CL_V2_V3, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 4302
  { IMAGE_SAMPLE_CD_CL_V2_V4, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 4303
  { IMAGE_SAMPLE_CD_CL_V2_V5, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 4304
  { IMAGE_SAMPLE_CD_CL_V2_V6, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 4305
  { IMAGE_SAMPLE_CD_CL_V2_V7, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x2, 0x7, 0x1 }, // 4306
  { IMAGE_SAMPLE_CD_CL_V2_V8, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 4307
  { IMAGE_SAMPLE_CD_CL_V2_V9, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x2, 0x9, 0x1 }, // 4308
  { IMAGE_SAMPLE_CD_CL_V2_V10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x2, 0xA, 0x1 }, // 4309
  { IMAGE_SAMPLE_CD_CL_V3_V2, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 4310
  { IMAGE_SAMPLE_CD_CL_V3_V3, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 4311
  { IMAGE_SAMPLE_CD_CL_V3_V4, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 4312
  { IMAGE_SAMPLE_CD_CL_V3_V5, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 4313
  { IMAGE_SAMPLE_CD_CL_V3_V6, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 4314
  { IMAGE_SAMPLE_CD_CL_V3_V7, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x3, 0x7, 0x1 }, // 4315
  { IMAGE_SAMPLE_CD_CL_V3_V8, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 4316
  { IMAGE_SAMPLE_CD_CL_V3_V9, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x3, 0x9, 0x1 }, // 4317
  { IMAGE_SAMPLE_CD_CL_V3_V10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x3, 0xA, 0x1 }, // 4318
  { IMAGE_SAMPLE_CD_CL_V4_V2, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 4319
  { IMAGE_SAMPLE_CD_CL_V4_V3, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 4320
  { IMAGE_SAMPLE_CD_CL_V4_V4, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 4321
  { IMAGE_SAMPLE_CD_CL_V4_V5, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 4322
  { IMAGE_SAMPLE_CD_CL_V4_V6, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 4323
  { IMAGE_SAMPLE_CD_CL_V4_V7, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x4, 0x7, 0x1 }, // 4324
  { IMAGE_SAMPLE_CD_CL_V4_V8, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 4325
  { IMAGE_SAMPLE_CD_CL_V4_V9, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x4, 0x9, 0x1 }, // 4326
  { IMAGE_SAMPLE_CD_CL_V4_V10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x4, 0xA, 0x1 }, // 4327
  { IMAGE_SAMPLE_CD_CL_V5_V2, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 4328
  { IMAGE_SAMPLE_CD_CL_V5_V3, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 4329
  { IMAGE_SAMPLE_CD_CL_V5_V4, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 4330
  { IMAGE_SAMPLE_CD_CL_V5_V5, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 4331
  { IMAGE_SAMPLE_CD_CL_V5_V6, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 4332
  { IMAGE_SAMPLE_CD_CL_V5_V7, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x5, 0x7, 0x1 }, // 4333
  { IMAGE_SAMPLE_CD_CL_V5_V8, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 4334
  { IMAGE_SAMPLE_CD_CL_V5_V9, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x5, 0x9, 0x1 }, // 4335
  { IMAGE_SAMPLE_CD_CL_V5_V10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x5, 0xA, 0x1 }, // 4336
  { IMAGE_SAMPLE_CD_CL_G16_V1_V2_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 4337
  { IMAGE_SAMPLE_CD_CL_G16_V1_V3_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 4338
  { IMAGE_SAMPLE_CD_CL_G16_V1_V4_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 4339
  { IMAGE_SAMPLE_CD_CL_G16_V1_V5_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 4340
  { IMAGE_SAMPLE_CD_CL_G16_V1_V6_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 4341
  { IMAGE_SAMPLE_CD_CL_G16_V1_V7_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x1, 0x7, 0x1 }, // 4342
  { IMAGE_SAMPLE_CD_CL_G16_V1_V8_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 4343
  { IMAGE_SAMPLE_CD_CL_G16_V2_V2_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 4344
  { IMAGE_SAMPLE_CD_CL_G16_V2_V3_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 4345
  { IMAGE_SAMPLE_CD_CL_G16_V2_V4_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 4346
  { IMAGE_SAMPLE_CD_CL_G16_V2_V5_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 4347
  { IMAGE_SAMPLE_CD_CL_G16_V2_V6_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 4348
  { IMAGE_SAMPLE_CD_CL_G16_V2_V7_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x2, 0x7, 0x1 }, // 4349
  { IMAGE_SAMPLE_CD_CL_G16_V2_V8_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 4350
  { IMAGE_SAMPLE_CD_CL_G16_V3_V2_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 4351
  { IMAGE_SAMPLE_CD_CL_G16_V3_V3_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 4352
  { IMAGE_SAMPLE_CD_CL_G16_V3_V4_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 4353
  { IMAGE_SAMPLE_CD_CL_G16_V3_V5_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 4354
  { IMAGE_SAMPLE_CD_CL_G16_V3_V6_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 4355
  { IMAGE_SAMPLE_CD_CL_G16_V3_V7_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x3, 0x7, 0x1 }, // 4356
  { IMAGE_SAMPLE_CD_CL_G16_V3_V8_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 4357
  { IMAGE_SAMPLE_CD_CL_G16_V4_V2_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 4358
  { IMAGE_SAMPLE_CD_CL_G16_V4_V3_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 4359
  { IMAGE_SAMPLE_CD_CL_G16_V4_V4_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 4360
  { IMAGE_SAMPLE_CD_CL_G16_V4_V5_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 4361
  { IMAGE_SAMPLE_CD_CL_G16_V4_V6_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 4362
  { IMAGE_SAMPLE_CD_CL_G16_V4_V7_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x4, 0x7, 0x1 }, // 4363
  { IMAGE_SAMPLE_CD_CL_G16_V4_V8_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 4364
  { IMAGE_SAMPLE_CD_CL_G16_V5_V2_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 4365
  { IMAGE_SAMPLE_CD_CL_G16_V5_V3_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 4366
  { IMAGE_SAMPLE_CD_CL_G16_V5_V4_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 4367
  { IMAGE_SAMPLE_CD_CL_G16_V5_V5_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 4368
  { IMAGE_SAMPLE_CD_CL_G16_V5_V6_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 4369
  { IMAGE_SAMPLE_CD_CL_G16_V5_V7_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x5, 0x7, 0x1 }, // 4370
  { IMAGE_SAMPLE_CD_CL_G16_V5_V8_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 4371
  { IMAGE_SAMPLE_CD_CL_G16_V1_V2_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 4372
  { IMAGE_SAMPLE_CD_CL_G16_V1_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 4373
  { IMAGE_SAMPLE_CD_CL_G16_V1_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 4374
  { IMAGE_SAMPLE_CD_CL_G16_V1_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 4375
  { IMAGE_SAMPLE_CD_CL_G16_V1_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 4376
  { IMAGE_SAMPLE_CD_CL_G16_V1_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x1, 0x7, 0x7 }, // 4377
  { IMAGE_SAMPLE_CD_CL_G16_V1_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x1, 0x8, 0x8 }, // 4378
  { IMAGE_SAMPLE_CD_CL_G16_V2_V2_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 4379
  { IMAGE_SAMPLE_CD_CL_G16_V2_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 4380
  { IMAGE_SAMPLE_CD_CL_G16_V2_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 4381
  { IMAGE_SAMPLE_CD_CL_G16_V2_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 4382
  { IMAGE_SAMPLE_CD_CL_G16_V2_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 4383
  { IMAGE_SAMPLE_CD_CL_G16_V2_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x2, 0x7, 0x7 }, // 4384
  { IMAGE_SAMPLE_CD_CL_G16_V2_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x2, 0x8, 0x8 }, // 4385
  { IMAGE_SAMPLE_CD_CL_G16_V3_V2_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 4386
  { IMAGE_SAMPLE_CD_CL_G16_V3_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 4387
  { IMAGE_SAMPLE_CD_CL_G16_V3_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 4388
  { IMAGE_SAMPLE_CD_CL_G16_V3_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 4389
  { IMAGE_SAMPLE_CD_CL_G16_V3_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 4390
  { IMAGE_SAMPLE_CD_CL_G16_V3_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x3, 0x7, 0x7 }, // 4391
  { IMAGE_SAMPLE_CD_CL_G16_V3_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x3, 0x8, 0x8 }, // 4392
  { IMAGE_SAMPLE_CD_CL_G16_V4_V2_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 4393
  { IMAGE_SAMPLE_CD_CL_G16_V4_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 4394
  { IMAGE_SAMPLE_CD_CL_G16_V4_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 4395
  { IMAGE_SAMPLE_CD_CL_G16_V4_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 4396
  { IMAGE_SAMPLE_CD_CL_G16_V4_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 4397
  { IMAGE_SAMPLE_CD_CL_G16_V4_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x4, 0x7, 0x7 }, // 4398
  { IMAGE_SAMPLE_CD_CL_G16_V4_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x4, 0x8, 0x8 }, // 4399
  { IMAGE_SAMPLE_CD_CL_G16_V5_V2_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 4400
  { IMAGE_SAMPLE_CD_CL_G16_V5_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 4401
  { IMAGE_SAMPLE_CD_CL_G16_V5_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 4402
  { IMAGE_SAMPLE_CD_CL_G16_V5_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 4403
  { IMAGE_SAMPLE_CD_CL_G16_V5_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 4404
  { IMAGE_SAMPLE_CD_CL_G16_V5_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x5, 0x7, 0x7 }, // 4405
  { IMAGE_SAMPLE_CD_CL_G16_V5_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x5, 0x8, 0x8 }, // 4406
  { IMAGE_SAMPLE_CD_CL_G16_V1_V2, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 4407
  { IMAGE_SAMPLE_CD_CL_G16_V1_V3, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 4408
  { IMAGE_SAMPLE_CD_CL_G16_V1_V4, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 4409
  { IMAGE_SAMPLE_CD_CL_G16_V1_V5, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 4410
  { IMAGE_SAMPLE_CD_CL_G16_V1_V6, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 4411
  { IMAGE_SAMPLE_CD_CL_G16_V1_V7, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x1, 0x7, 0x1 }, // 4412
  { IMAGE_SAMPLE_CD_CL_G16_V1_V8, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 4413
  { IMAGE_SAMPLE_CD_CL_G16_V2_V2, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 4414
  { IMAGE_SAMPLE_CD_CL_G16_V2_V3, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 4415
  { IMAGE_SAMPLE_CD_CL_G16_V2_V4, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 4416
  { IMAGE_SAMPLE_CD_CL_G16_V2_V5, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 4417
  { IMAGE_SAMPLE_CD_CL_G16_V2_V6, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 4418
  { IMAGE_SAMPLE_CD_CL_G16_V2_V7, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x2, 0x7, 0x1 }, // 4419
  { IMAGE_SAMPLE_CD_CL_G16_V2_V8, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 4420
  { IMAGE_SAMPLE_CD_CL_G16_V3_V2, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 4421
  { IMAGE_SAMPLE_CD_CL_G16_V3_V3, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 4422
  { IMAGE_SAMPLE_CD_CL_G16_V3_V4, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 4423
  { IMAGE_SAMPLE_CD_CL_G16_V3_V5, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 4424
  { IMAGE_SAMPLE_CD_CL_G16_V3_V6, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 4425
  { IMAGE_SAMPLE_CD_CL_G16_V3_V7, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x3, 0x7, 0x1 }, // 4426
  { IMAGE_SAMPLE_CD_CL_G16_V3_V8, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 4427
  { IMAGE_SAMPLE_CD_CL_G16_V4_V2, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 4428
  { IMAGE_SAMPLE_CD_CL_G16_V4_V3, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 4429
  { IMAGE_SAMPLE_CD_CL_G16_V4_V4, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 4430
  { IMAGE_SAMPLE_CD_CL_G16_V4_V5, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 4431
  { IMAGE_SAMPLE_CD_CL_G16_V4_V6, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 4432
  { IMAGE_SAMPLE_CD_CL_G16_V4_V7, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x4, 0x7, 0x1 }, // 4433
  { IMAGE_SAMPLE_CD_CL_G16_V4_V8, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 4434
  { IMAGE_SAMPLE_CD_CL_G16_V5_V2, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 4435
  { IMAGE_SAMPLE_CD_CL_G16_V5_V3, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 4436
  { IMAGE_SAMPLE_CD_CL_G16_V5_V4, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 4437
  { IMAGE_SAMPLE_CD_CL_G16_V5_V5, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 4438
  { IMAGE_SAMPLE_CD_CL_G16_V5_V6, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 4439
  { IMAGE_SAMPLE_CD_CL_G16_V5_V7, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x5, 0x7, 0x1 }, // 4440
  { IMAGE_SAMPLE_CD_CL_G16_V5_V8, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 4441
  { IMAGE_SAMPLE_CD_CL_O_V1_V3_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 4442
  { IMAGE_SAMPLE_CD_CL_O_V1_V4_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 4443
  { IMAGE_SAMPLE_CD_CL_O_V1_V5_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 4444
  { IMAGE_SAMPLE_CD_CL_O_V1_V6_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 4445
  { IMAGE_SAMPLE_CD_CL_O_V1_V7_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x1, 0x7, 0x1 }, // 4446
  { IMAGE_SAMPLE_CD_CL_O_V1_V8_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 4447
  { IMAGE_SAMPLE_CD_CL_O_V1_V9_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x1, 0x9, 0x1 }, // 4448
  { IMAGE_SAMPLE_CD_CL_O_V1_V10_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x1, 0xA, 0x1 }, // 4449
  { IMAGE_SAMPLE_CD_CL_O_V1_V11_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x1, 0xB, 0x1 }, // 4450
  { IMAGE_SAMPLE_CD_CL_O_V2_V3_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 4451
  { IMAGE_SAMPLE_CD_CL_O_V2_V4_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 4452
  { IMAGE_SAMPLE_CD_CL_O_V2_V5_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 4453
  { IMAGE_SAMPLE_CD_CL_O_V2_V6_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 4454
  { IMAGE_SAMPLE_CD_CL_O_V2_V7_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x2, 0x7, 0x1 }, // 4455
  { IMAGE_SAMPLE_CD_CL_O_V2_V8_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 4456
  { IMAGE_SAMPLE_CD_CL_O_V2_V9_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x2, 0x9, 0x1 }, // 4457
  { IMAGE_SAMPLE_CD_CL_O_V2_V10_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x2, 0xA, 0x1 }, // 4458
  { IMAGE_SAMPLE_CD_CL_O_V2_V11_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x2, 0xB, 0x1 }, // 4459
  { IMAGE_SAMPLE_CD_CL_O_V3_V3_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 4460
  { IMAGE_SAMPLE_CD_CL_O_V3_V4_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 4461
  { IMAGE_SAMPLE_CD_CL_O_V3_V5_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 4462
  { IMAGE_SAMPLE_CD_CL_O_V3_V6_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 4463
  { IMAGE_SAMPLE_CD_CL_O_V3_V7_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x3, 0x7, 0x1 }, // 4464
  { IMAGE_SAMPLE_CD_CL_O_V3_V8_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 4465
  { IMAGE_SAMPLE_CD_CL_O_V3_V9_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x3, 0x9, 0x1 }, // 4466
  { IMAGE_SAMPLE_CD_CL_O_V3_V10_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x3, 0xA, 0x1 }, // 4467
  { IMAGE_SAMPLE_CD_CL_O_V3_V11_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x3, 0xB, 0x1 }, // 4468
  { IMAGE_SAMPLE_CD_CL_O_V4_V3_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 4469
  { IMAGE_SAMPLE_CD_CL_O_V4_V4_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 4470
  { IMAGE_SAMPLE_CD_CL_O_V4_V5_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 4471
  { IMAGE_SAMPLE_CD_CL_O_V4_V6_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 4472
  { IMAGE_SAMPLE_CD_CL_O_V4_V7_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x4, 0x7, 0x1 }, // 4473
  { IMAGE_SAMPLE_CD_CL_O_V4_V8_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 4474
  { IMAGE_SAMPLE_CD_CL_O_V4_V9_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x4, 0x9, 0x1 }, // 4475
  { IMAGE_SAMPLE_CD_CL_O_V4_V10_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x4, 0xA, 0x1 }, // 4476
  { IMAGE_SAMPLE_CD_CL_O_V4_V11_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x4, 0xB, 0x1 }, // 4477
  { IMAGE_SAMPLE_CD_CL_O_V5_V3_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 4478
  { IMAGE_SAMPLE_CD_CL_O_V5_V4_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 4479
  { IMAGE_SAMPLE_CD_CL_O_V5_V5_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 4480
  { IMAGE_SAMPLE_CD_CL_O_V5_V6_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 4481
  { IMAGE_SAMPLE_CD_CL_O_V5_V7_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x5, 0x7, 0x1 }, // 4482
  { IMAGE_SAMPLE_CD_CL_O_V5_V8_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 4483
  { IMAGE_SAMPLE_CD_CL_O_V5_V9_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x5, 0x9, 0x1 }, // 4484
  { IMAGE_SAMPLE_CD_CL_O_V5_V10_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x5, 0xA, 0x1 }, // 4485
  { IMAGE_SAMPLE_CD_CL_O_V5_V11_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x5, 0xB, 0x1 }, // 4486
  { IMAGE_SAMPLE_CD_CL_O_V1_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 4487
  { IMAGE_SAMPLE_CD_CL_O_V1_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 4488
  { IMAGE_SAMPLE_CD_CL_O_V1_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 4489
  { IMAGE_SAMPLE_CD_CL_O_V1_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 4490
  { IMAGE_SAMPLE_CD_CL_O_V1_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0x7, 0x7 }, // 4491
  { IMAGE_SAMPLE_CD_CL_O_V1_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0x8, 0x8 }, // 4492
  { IMAGE_SAMPLE_CD_CL_O_V1_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0x9, 0x9 }, // 4493
  { IMAGE_SAMPLE_CD_CL_O_V1_V10_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0xA, 0xA }, // 4494
  { IMAGE_SAMPLE_CD_CL_O_V1_V11_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0xB, 0xB }, // 4495
  { IMAGE_SAMPLE_CD_CL_O_V2_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 4496
  { IMAGE_SAMPLE_CD_CL_O_V2_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 4497
  { IMAGE_SAMPLE_CD_CL_O_V2_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 4498
  { IMAGE_SAMPLE_CD_CL_O_V2_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 4499
  { IMAGE_SAMPLE_CD_CL_O_V2_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0x7, 0x7 }, // 4500
  { IMAGE_SAMPLE_CD_CL_O_V2_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0x8, 0x8 }, // 4501
  { IMAGE_SAMPLE_CD_CL_O_V2_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0x9, 0x9 }, // 4502
  { IMAGE_SAMPLE_CD_CL_O_V2_V10_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0xA, 0xA }, // 4503
  { IMAGE_SAMPLE_CD_CL_O_V2_V11_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0xB, 0xB }, // 4504
  { IMAGE_SAMPLE_CD_CL_O_V3_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 4505
  { IMAGE_SAMPLE_CD_CL_O_V3_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 4506
  { IMAGE_SAMPLE_CD_CL_O_V3_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 4507
  { IMAGE_SAMPLE_CD_CL_O_V3_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 4508
  { IMAGE_SAMPLE_CD_CL_O_V3_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0x7, 0x7 }, // 4509
  { IMAGE_SAMPLE_CD_CL_O_V3_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0x8, 0x8 }, // 4510
  { IMAGE_SAMPLE_CD_CL_O_V3_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0x9, 0x9 }, // 4511
  { IMAGE_SAMPLE_CD_CL_O_V3_V10_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0xA, 0xA }, // 4512
  { IMAGE_SAMPLE_CD_CL_O_V3_V11_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0xB, 0xB }, // 4513
  { IMAGE_SAMPLE_CD_CL_O_V4_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 4514
  { IMAGE_SAMPLE_CD_CL_O_V4_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 4515
  { IMAGE_SAMPLE_CD_CL_O_V4_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 4516
  { IMAGE_SAMPLE_CD_CL_O_V4_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 4517
  { IMAGE_SAMPLE_CD_CL_O_V4_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0x7, 0x7 }, // 4518
  { IMAGE_SAMPLE_CD_CL_O_V4_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0x8, 0x8 }, // 4519
  { IMAGE_SAMPLE_CD_CL_O_V4_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0x9, 0x9 }, // 4520
  { IMAGE_SAMPLE_CD_CL_O_V4_V10_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0xA, 0xA }, // 4521
  { IMAGE_SAMPLE_CD_CL_O_V4_V11_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0xB, 0xB }, // 4522
  { IMAGE_SAMPLE_CD_CL_O_V5_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 4523
  { IMAGE_SAMPLE_CD_CL_O_V5_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 4524
  { IMAGE_SAMPLE_CD_CL_O_V5_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 4525
  { IMAGE_SAMPLE_CD_CL_O_V5_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 4526
  { IMAGE_SAMPLE_CD_CL_O_V5_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0x7, 0x7 }, // 4527
  { IMAGE_SAMPLE_CD_CL_O_V5_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0x8, 0x8 }, // 4528
  { IMAGE_SAMPLE_CD_CL_O_V5_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0x9, 0x9 }, // 4529
  { IMAGE_SAMPLE_CD_CL_O_V5_V10_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0xA, 0xA }, // 4530
  { IMAGE_SAMPLE_CD_CL_O_V5_V11_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0xB, 0xB }, // 4531
  { IMAGE_SAMPLE_CD_CL_O_V1_V3, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 4532
  { IMAGE_SAMPLE_CD_CL_O_V1_V4, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 4533
  { IMAGE_SAMPLE_CD_CL_O_V1_V5, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 4534
  { IMAGE_SAMPLE_CD_CL_O_V1_V6, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 4535
  { IMAGE_SAMPLE_CD_CL_O_V1_V7, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x1, 0x7, 0x1 }, // 4536
  { IMAGE_SAMPLE_CD_CL_O_V1_V8, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 4537
  { IMAGE_SAMPLE_CD_CL_O_V1_V9, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x1, 0x9, 0x1 }, // 4538
  { IMAGE_SAMPLE_CD_CL_O_V1_V10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x1, 0xA, 0x1 }, // 4539
  { IMAGE_SAMPLE_CD_CL_O_V1_V11, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x1, 0xB, 0x1 }, // 4540
  { IMAGE_SAMPLE_CD_CL_O_V2_V3, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 4541
  { IMAGE_SAMPLE_CD_CL_O_V2_V4, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 4542
  { IMAGE_SAMPLE_CD_CL_O_V2_V5, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 4543
  { IMAGE_SAMPLE_CD_CL_O_V2_V6, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 4544
  { IMAGE_SAMPLE_CD_CL_O_V2_V7, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x2, 0x7, 0x1 }, // 4545
  { IMAGE_SAMPLE_CD_CL_O_V2_V8, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 4546
  { IMAGE_SAMPLE_CD_CL_O_V2_V9, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x2, 0x9, 0x1 }, // 4547
  { IMAGE_SAMPLE_CD_CL_O_V2_V10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x2, 0xA, 0x1 }, // 4548
  { IMAGE_SAMPLE_CD_CL_O_V2_V11, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x2, 0xB, 0x1 }, // 4549
  { IMAGE_SAMPLE_CD_CL_O_V3_V3, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 4550
  { IMAGE_SAMPLE_CD_CL_O_V3_V4, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 4551
  { IMAGE_SAMPLE_CD_CL_O_V3_V5, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 4552
  { IMAGE_SAMPLE_CD_CL_O_V3_V6, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 4553
  { IMAGE_SAMPLE_CD_CL_O_V3_V7, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x3, 0x7, 0x1 }, // 4554
  { IMAGE_SAMPLE_CD_CL_O_V3_V8, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 4555
  { IMAGE_SAMPLE_CD_CL_O_V3_V9, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x3, 0x9, 0x1 }, // 4556
  { IMAGE_SAMPLE_CD_CL_O_V3_V10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x3, 0xA, 0x1 }, // 4557
  { IMAGE_SAMPLE_CD_CL_O_V3_V11, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x3, 0xB, 0x1 }, // 4558
  { IMAGE_SAMPLE_CD_CL_O_V4_V3, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 4559
  { IMAGE_SAMPLE_CD_CL_O_V4_V4, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 4560
  { IMAGE_SAMPLE_CD_CL_O_V4_V5, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 4561
  { IMAGE_SAMPLE_CD_CL_O_V4_V6, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 4562
  { IMAGE_SAMPLE_CD_CL_O_V4_V7, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x4, 0x7, 0x1 }, // 4563
  { IMAGE_SAMPLE_CD_CL_O_V4_V8, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 4564
  { IMAGE_SAMPLE_CD_CL_O_V4_V9, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x4, 0x9, 0x1 }, // 4565
  { IMAGE_SAMPLE_CD_CL_O_V4_V10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x4, 0xA, 0x1 }, // 4566
  { IMAGE_SAMPLE_CD_CL_O_V4_V11, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x4, 0xB, 0x1 }, // 4567
  { IMAGE_SAMPLE_CD_CL_O_V5_V3, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 4568
  { IMAGE_SAMPLE_CD_CL_O_V5_V4, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 4569
  { IMAGE_SAMPLE_CD_CL_O_V5_V5, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 4570
  { IMAGE_SAMPLE_CD_CL_O_V5_V6, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 4571
  { IMAGE_SAMPLE_CD_CL_O_V5_V7, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x5, 0x7, 0x1 }, // 4572
  { IMAGE_SAMPLE_CD_CL_O_V5_V8, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 4573
  { IMAGE_SAMPLE_CD_CL_O_V5_V9, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x5, 0x9, 0x1 }, // 4574
  { IMAGE_SAMPLE_CD_CL_O_V5_V10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x5, 0xA, 0x1 }, // 4575
  { IMAGE_SAMPLE_CD_CL_O_V5_V11, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x5, 0xB, 0x1 }, // 4576
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V3_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 4577
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V4_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 4578
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V5_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 4579
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V6_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 4580
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V7_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x7, 0x1 }, // 4581
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V8_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 4582
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V9_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x9, 0x1 }, // 4583
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V3_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 4584
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V4_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 4585
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V5_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 4586
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V6_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 4587
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V7_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x7, 0x1 }, // 4588
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V8_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 4589
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V9_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x9, 0x1 }, // 4590
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V3_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 4591
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V4_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 4592
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V5_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 4593
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V6_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 4594
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V7_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x7, 0x1 }, // 4595
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V8_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 4596
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V9_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x9, 0x1 }, // 4597
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V3_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 4598
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V4_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 4599
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V5_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 4600
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V6_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 4601
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V7_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x7, 0x1 }, // 4602
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V8_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 4603
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V9_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x9, 0x1 }, // 4604
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V3_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 4605
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V4_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 4606
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V5_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 4607
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V6_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 4608
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V7_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x7, 0x1 }, // 4609
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V8_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 4610
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V9_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x9, 0x1 }, // 4611
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 4612
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 4613
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 4614
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 4615
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x7, 0x7 }, // 4616
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x8, 0x8 }, // 4617
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x9, 0x9 }, // 4618
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 4619
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 4620
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 4621
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 4622
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x7, 0x7 }, // 4623
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x8, 0x8 }, // 4624
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x9, 0x9 }, // 4625
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 4626
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 4627
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 4628
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 4629
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x7, 0x7 }, // 4630
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x8, 0x8 }, // 4631
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x9, 0x9 }, // 4632
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 4633
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 4634
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 4635
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 4636
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x7, 0x7 }, // 4637
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x8, 0x8 }, // 4638
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x9, 0x9 }, // 4639
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 4640
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 4641
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 4642
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 4643
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x7, 0x7 }, // 4644
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x8, 0x8 }, // 4645
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x9, 0x9 }, // 4646
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V3, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 4647
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V4, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 4648
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V5, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 4649
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V6, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 4650
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V7, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x1, 0x7, 0x1 }, // 4651
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V8, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 4652
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V9, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x1, 0x9, 0x1 }, // 4653
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V3, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 4654
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V4, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 4655
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V5, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 4656
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V6, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 4657
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V7, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x2, 0x7, 0x1 }, // 4658
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V8, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 4659
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V9, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x2, 0x9, 0x1 }, // 4660
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V3, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 4661
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V4, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 4662
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V5, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 4663
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V6, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 4664
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V7, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x3, 0x7, 0x1 }, // 4665
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V8, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 4666
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V9, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x3, 0x9, 0x1 }, // 4667
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V3, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 4668
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V4, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 4669
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V5, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 4670
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V6, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 4671
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V7, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x4, 0x7, 0x1 }, // 4672
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V8, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 4673
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V9, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x4, 0x9, 0x1 }, // 4674
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V3, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 4675
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V4, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 4676
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V5, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 4677
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V6, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 4678
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V7, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x5, 0x7, 0x1 }, // 4679
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V8, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 4680
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V9, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x5, 0x9, 0x1 }, // 4681
  { IMAGE_SAMPLE_CD_G16_V1_V2_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 4682
  { IMAGE_SAMPLE_CD_G16_V1_V3_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 4683
  { IMAGE_SAMPLE_CD_G16_V1_V4_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 4684
  { IMAGE_SAMPLE_CD_G16_V1_V5_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 4685
  { IMAGE_SAMPLE_CD_G16_V1_V6_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 4686
  { IMAGE_SAMPLE_CD_G16_V1_V7_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x1, 0x7, 0x1 }, // 4687
  { IMAGE_SAMPLE_CD_G16_V1_V8_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 4688
  { IMAGE_SAMPLE_CD_G16_V2_V2_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 4689
  { IMAGE_SAMPLE_CD_G16_V2_V3_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 4690
  { IMAGE_SAMPLE_CD_G16_V2_V4_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 4691
  { IMAGE_SAMPLE_CD_G16_V2_V5_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 4692
  { IMAGE_SAMPLE_CD_G16_V2_V6_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 4693
  { IMAGE_SAMPLE_CD_G16_V2_V7_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x2, 0x7, 0x1 }, // 4694
  { IMAGE_SAMPLE_CD_G16_V2_V8_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 4695
  { IMAGE_SAMPLE_CD_G16_V3_V2_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 4696
  { IMAGE_SAMPLE_CD_G16_V3_V3_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 4697
  { IMAGE_SAMPLE_CD_G16_V3_V4_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 4698
  { IMAGE_SAMPLE_CD_G16_V3_V5_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 4699
  { IMAGE_SAMPLE_CD_G16_V3_V6_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 4700
  { IMAGE_SAMPLE_CD_G16_V3_V7_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x3, 0x7, 0x1 }, // 4701
  { IMAGE_SAMPLE_CD_G16_V3_V8_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 4702
  { IMAGE_SAMPLE_CD_G16_V4_V2_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 4703
  { IMAGE_SAMPLE_CD_G16_V4_V3_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 4704
  { IMAGE_SAMPLE_CD_G16_V4_V4_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 4705
  { IMAGE_SAMPLE_CD_G16_V4_V5_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 4706
  { IMAGE_SAMPLE_CD_G16_V4_V6_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 4707
  { IMAGE_SAMPLE_CD_G16_V4_V7_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x4, 0x7, 0x1 }, // 4708
  { IMAGE_SAMPLE_CD_G16_V4_V8_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 4709
  { IMAGE_SAMPLE_CD_G16_V5_V2_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 4710
  { IMAGE_SAMPLE_CD_G16_V5_V3_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 4711
  { IMAGE_SAMPLE_CD_G16_V5_V4_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 4712
  { IMAGE_SAMPLE_CD_G16_V5_V5_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 4713
  { IMAGE_SAMPLE_CD_G16_V5_V6_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 4714
  { IMAGE_SAMPLE_CD_G16_V5_V7_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x5, 0x7, 0x1 }, // 4715
  { IMAGE_SAMPLE_CD_G16_V5_V8_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 4716
  { IMAGE_SAMPLE_CD_G16_V1_V2_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 4717
  { IMAGE_SAMPLE_CD_G16_V1_V3_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 4718
  { IMAGE_SAMPLE_CD_G16_V1_V4_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 4719
  { IMAGE_SAMPLE_CD_G16_V1_V5_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 4720
  { IMAGE_SAMPLE_CD_G16_V1_V6_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 4721
  { IMAGE_SAMPLE_CD_G16_V1_V7_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x1, 0x7, 0x7 }, // 4722
  { IMAGE_SAMPLE_CD_G16_V2_V2_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 4723
  { IMAGE_SAMPLE_CD_G16_V2_V3_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 4724
  { IMAGE_SAMPLE_CD_G16_V2_V4_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 4725
  { IMAGE_SAMPLE_CD_G16_V2_V5_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 4726
  { IMAGE_SAMPLE_CD_G16_V2_V6_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 4727
  { IMAGE_SAMPLE_CD_G16_V2_V7_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x2, 0x7, 0x7 }, // 4728
  { IMAGE_SAMPLE_CD_G16_V3_V2_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 4729
  { IMAGE_SAMPLE_CD_G16_V3_V3_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 4730
  { IMAGE_SAMPLE_CD_G16_V3_V4_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 4731
  { IMAGE_SAMPLE_CD_G16_V3_V5_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 4732
  { IMAGE_SAMPLE_CD_G16_V3_V6_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 4733
  { IMAGE_SAMPLE_CD_G16_V3_V7_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x3, 0x7, 0x7 }, // 4734
  { IMAGE_SAMPLE_CD_G16_V4_V2_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 4735
  { IMAGE_SAMPLE_CD_G16_V4_V3_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 4736
  { IMAGE_SAMPLE_CD_G16_V4_V4_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 4737
  { IMAGE_SAMPLE_CD_G16_V4_V5_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 4738
  { IMAGE_SAMPLE_CD_G16_V4_V6_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 4739
  { IMAGE_SAMPLE_CD_G16_V4_V7_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x4, 0x7, 0x7 }, // 4740
  { IMAGE_SAMPLE_CD_G16_V5_V2_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 4741
  { IMAGE_SAMPLE_CD_G16_V5_V3_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 4742
  { IMAGE_SAMPLE_CD_G16_V5_V4_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 4743
  { IMAGE_SAMPLE_CD_G16_V5_V5_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 4744
  { IMAGE_SAMPLE_CD_G16_V5_V6_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 4745
  { IMAGE_SAMPLE_CD_G16_V5_V7_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x5, 0x7, 0x7 }, // 4746
  { IMAGE_SAMPLE_CD_G16_V1_V2, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 4747
  { IMAGE_SAMPLE_CD_G16_V1_V3, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 4748
  { IMAGE_SAMPLE_CD_G16_V1_V4, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 4749
  { IMAGE_SAMPLE_CD_G16_V1_V5, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 4750
  { IMAGE_SAMPLE_CD_G16_V1_V6, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 4751
  { IMAGE_SAMPLE_CD_G16_V1_V7, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x1, 0x7, 0x1 }, // 4752
  { IMAGE_SAMPLE_CD_G16_V1_V8, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 4753
  { IMAGE_SAMPLE_CD_G16_V2_V2, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 4754
  { IMAGE_SAMPLE_CD_G16_V2_V3, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 4755
  { IMAGE_SAMPLE_CD_G16_V2_V4, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 4756
  { IMAGE_SAMPLE_CD_G16_V2_V5, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 4757
  { IMAGE_SAMPLE_CD_G16_V2_V6, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 4758
  { IMAGE_SAMPLE_CD_G16_V2_V7, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x2, 0x7, 0x1 }, // 4759
  { IMAGE_SAMPLE_CD_G16_V2_V8, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 4760
  { IMAGE_SAMPLE_CD_G16_V3_V2, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 4761
  { IMAGE_SAMPLE_CD_G16_V3_V3, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 4762
  { IMAGE_SAMPLE_CD_G16_V3_V4, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 4763
  { IMAGE_SAMPLE_CD_G16_V3_V5, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 4764
  { IMAGE_SAMPLE_CD_G16_V3_V6, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 4765
  { IMAGE_SAMPLE_CD_G16_V3_V7, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x3, 0x7, 0x1 }, // 4766
  { IMAGE_SAMPLE_CD_G16_V3_V8, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 4767
  { IMAGE_SAMPLE_CD_G16_V4_V2, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 4768
  { IMAGE_SAMPLE_CD_G16_V4_V3, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 4769
  { IMAGE_SAMPLE_CD_G16_V4_V4, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 4770
  { IMAGE_SAMPLE_CD_G16_V4_V5, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 4771
  { IMAGE_SAMPLE_CD_G16_V4_V6, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 4772
  { IMAGE_SAMPLE_CD_G16_V4_V7, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x4, 0x7, 0x1 }, // 4773
  { IMAGE_SAMPLE_CD_G16_V4_V8, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 4774
  { IMAGE_SAMPLE_CD_G16_V5_V2, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 4775
  { IMAGE_SAMPLE_CD_G16_V5_V3, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 4776
  { IMAGE_SAMPLE_CD_G16_V5_V4, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 4777
  { IMAGE_SAMPLE_CD_G16_V5_V5, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 4778
  { IMAGE_SAMPLE_CD_G16_V5_V6, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 4779
  { IMAGE_SAMPLE_CD_G16_V5_V7, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x5, 0x7, 0x1 }, // 4780
  { IMAGE_SAMPLE_CD_G16_V5_V8, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 4781
  { IMAGE_SAMPLE_CD_O_V1_V3_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 4782
  { IMAGE_SAMPLE_CD_O_V1_V4_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 4783
  { IMAGE_SAMPLE_CD_O_V1_V5_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 4784
  { IMAGE_SAMPLE_CD_O_V1_V6_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 4785
  { IMAGE_SAMPLE_CD_O_V1_V7_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x1, 0x7, 0x1 }, // 4786
  { IMAGE_SAMPLE_CD_O_V1_V8_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 4787
  { IMAGE_SAMPLE_CD_O_V1_V9_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x1, 0x9, 0x1 }, // 4788
  { IMAGE_SAMPLE_CD_O_V1_V10_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x1, 0xA, 0x1 }, // 4789
  { IMAGE_SAMPLE_CD_O_V2_V3_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 4790
  { IMAGE_SAMPLE_CD_O_V2_V4_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 4791
  { IMAGE_SAMPLE_CD_O_V2_V5_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 4792
  { IMAGE_SAMPLE_CD_O_V2_V6_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 4793
  { IMAGE_SAMPLE_CD_O_V2_V7_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x2, 0x7, 0x1 }, // 4794
  { IMAGE_SAMPLE_CD_O_V2_V8_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 4795
  { IMAGE_SAMPLE_CD_O_V2_V9_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x2, 0x9, 0x1 }, // 4796
  { IMAGE_SAMPLE_CD_O_V2_V10_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x2, 0xA, 0x1 }, // 4797
  { IMAGE_SAMPLE_CD_O_V3_V3_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 4798
  { IMAGE_SAMPLE_CD_O_V3_V4_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 4799
  { IMAGE_SAMPLE_CD_O_V3_V5_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 4800
  { IMAGE_SAMPLE_CD_O_V3_V6_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 4801
  { IMAGE_SAMPLE_CD_O_V3_V7_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x3, 0x7, 0x1 }, // 4802
  { IMAGE_SAMPLE_CD_O_V3_V8_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 4803
  { IMAGE_SAMPLE_CD_O_V3_V9_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x3, 0x9, 0x1 }, // 4804
  { IMAGE_SAMPLE_CD_O_V3_V10_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x3, 0xA, 0x1 }, // 4805
  { IMAGE_SAMPLE_CD_O_V4_V3_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 4806
  { IMAGE_SAMPLE_CD_O_V4_V4_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 4807
  { IMAGE_SAMPLE_CD_O_V4_V5_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 4808
  { IMAGE_SAMPLE_CD_O_V4_V6_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 4809
  { IMAGE_SAMPLE_CD_O_V4_V7_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x4, 0x7, 0x1 }, // 4810
  { IMAGE_SAMPLE_CD_O_V4_V8_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 4811
  { IMAGE_SAMPLE_CD_O_V4_V9_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x4, 0x9, 0x1 }, // 4812
  { IMAGE_SAMPLE_CD_O_V4_V10_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x4, 0xA, 0x1 }, // 4813
  { IMAGE_SAMPLE_CD_O_V5_V3_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 4814
  { IMAGE_SAMPLE_CD_O_V5_V4_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 4815
  { IMAGE_SAMPLE_CD_O_V5_V5_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 4816
  { IMAGE_SAMPLE_CD_O_V5_V6_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 4817
  { IMAGE_SAMPLE_CD_O_V5_V7_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x5, 0x7, 0x1 }, // 4818
  { IMAGE_SAMPLE_CD_O_V5_V8_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 4819
  { IMAGE_SAMPLE_CD_O_V5_V9_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x5, 0x9, 0x1 }, // 4820
  { IMAGE_SAMPLE_CD_O_V5_V10_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x5, 0xA, 0x1 }, // 4821
  { IMAGE_SAMPLE_CD_O_V1_V3_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 4822
  { IMAGE_SAMPLE_CD_O_V1_V4_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 4823
  { IMAGE_SAMPLE_CD_O_V1_V5_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 4824
  { IMAGE_SAMPLE_CD_O_V1_V6_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 4825
  { IMAGE_SAMPLE_CD_O_V1_V7_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x1, 0x7, 0x7 }, // 4826
  { IMAGE_SAMPLE_CD_O_V1_V8_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x1, 0x8, 0x8 }, // 4827
  { IMAGE_SAMPLE_CD_O_V1_V9_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x1, 0x9, 0x9 }, // 4828
  { IMAGE_SAMPLE_CD_O_V1_V10_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x1, 0xA, 0xA }, // 4829
  { IMAGE_SAMPLE_CD_O_V2_V3_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 4830
  { IMAGE_SAMPLE_CD_O_V2_V4_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 4831
  { IMAGE_SAMPLE_CD_O_V2_V5_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 4832
  { IMAGE_SAMPLE_CD_O_V2_V6_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 4833
  { IMAGE_SAMPLE_CD_O_V2_V7_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x2, 0x7, 0x7 }, // 4834
  { IMAGE_SAMPLE_CD_O_V2_V8_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x2, 0x8, 0x8 }, // 4835
  { IMAGE_SAMPLE_CD_O_V2_V9_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x2, 0x9, 0x9 }, // 4836
  { IMAGE_SAMPLE_CD_O_V2_V10_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x2, 0xA, 0xA }, // 4837
  { IMAGE_SAMPLE_CD_O_V3_V3_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 4838
  { IMAGE_SAMPLE_CD_O_V3_V4_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 4839
  { IMAGE_SAMPLE_CD_O_V3_V5_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 4840
  { IMAGE_SAMPLE_CD_O_V3_V6_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 4841
  { IMAGE_SAMPLE_CD_O_V3_V7_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x3, 0x7, 0x7 }, // 4842
  { IMAGE_SAMPLE_CD_O_V3_V8_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x3, 0x8, 0x8 }, // 4843
  { IMAGE_SAMPLE_CD_O_V3_V9_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x3, 0x9, 0x9 }, // 4844
  { IMAGE_SAMPLE_CD_O_V3_V10_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x3, 0xA, 0xA }, // 4845
  { IMAGE_SAMPLE_CD_O_V4_V3_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 4846
  { IMAGE_SAMPLE_CD_O_V4_V4_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 4847
  { IMAGE_SAMPLE_CD_O_V4_V5_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 4848
  { IMAGE_SAMPLE_CD_O_V4_V6_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 4849
  { IMAGE_SAMPLE_CD_O_V4_V7_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x4, 0x7, 0x7 }, // 4850
  { IMAGE_SAMPLE_CD_O_V4_V8_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x4, 0x8, 0x8 }, // 4851
  { IMAGE_SAMPLE_CD_O_V4_V9_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x4, 0x9, 0x9 }, // 4852
  { IMAGE_SAMPLE_CD_O_V4_V10_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x4, 0xA, 0xA }, // 4853
  { IMAGE_SAMPLE_CD_O_V5_V3_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 4854
  { IMAGE_SAMPLE_CD_O_V5_V4_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 4855
  { IMAGE_SAMPLE_CD_O_V5_V5_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 4856
  { IMAGE_SAMPLE_CD_O_V5_V6_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 4857
  { IMAGE_SAMPLE_CD_O_V5_V7_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x5, 0x7, 0x7 }, // 4858
  { IMAGE_SAMPLE_CD_O_V5_V8_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x5, 0x8, 0x8 }, // 4859
  { IMAGE_SAMPLE_CD_O_V5_V9_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x5, 0x9, 0x9 }, // 4860
  { IMAGE_SAMPLE_CD_O_V5_V10_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x5, 0xA, 0xA }, // 4861
  { IMAGE_SAMPLE_CD_O_V1_V3, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 4862
  { IMAGE_SAMPLE_CD_O_V1_V4, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 4863
  { IMAGE_SAMPLE_CD_O_V1_V5, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 4864
  { IMAGE_SAMPLE_CD_O_V1_V6, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 4865
  { IMAGE_SAMPLE_CD_O_V1_V7, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x1, 0x7, 0x1 }, // 4866
  { IMAGE_SAMPLE_CD_O_V1_V8, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 4867
  { IMAGE_SAMPLE_CD_O_V1_V9, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x1, 0x9, 0x1 }, // 4868
  { IMAGE_SAMPLE_CD_O_V1_V10, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x1, 0xA, 0x1 }, // 4869
  { IMAGE_SAMPLE_CD_O_V2_V3, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 4870
  { IMAGE_SAMPLE_CD_O_V2_V4, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 4871
  { IMAGE_SAMPLE_CD_O_V2_V5, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 4872
  { IMAGE_SAMPLE_CD_O_V2_V6, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 4873
  { IMAGE_SAMPLE_CD_O_V2_V7, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x2, 0x7, 0x1 }, // 4874
  { IMAGE_SAMPLE_CD_O_V2_V8, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 4875
  { IMAGE_SAMPLE_CD_O_V2_V9, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x2, 0x9, 0x1 }, // 4876
  { IMAGE_SAMPLE_CD_O_V2_V10, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x2, 0xA, 0x1 }, // 4877
  { IMAGE_SAMPLE_CD_O_V3_V3, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 4878
  { IMAGE_SAMPLE_CD_O_V3_V4, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 4879
  { IMAGE_SAMPLE_CD_O_V3_V5, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 4880
  { IMAGE_SAMPLE_CD_O_V3_V6, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 4881
  { IMAGE_SAMPLE_CD_O_V3_V7, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x3, 0x7, 0x1 }, // 4882
  { IMAGE_SAMPLE_CD_O_V3_V8, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 4883
  { IMAGE_SAMPLE_CD_O_V3_V9, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x3, 0x9, 0x1 }, // 4884
  { IMAGE_SAMPLE_CD_O_V3_V10, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x3, 0xA, 0x1 }, // 4885
  { IMAGE_SAMPLE_CD_O_V4_V3, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 4886
  { IMAGE_SAMPLE_CD_O_V4_V4, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 4887
  { IMAGE_SAMPLE_CD_O_V4_V5, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 4888
  { IMAGE_SAMPLE_CD_O_V4_V6, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 4889
  { IMAGE_SAMPLE_CD_O_V4_V7, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x4, 0x7, 0x1 }, // 4890
  { IMAGE_SAMPLE_CD_O_V4_V8, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 4891
  { IMAGE_SAMPLE_CD_O_V4_V9, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x4, 0x9, 0x1 }, // 4892
  { IMAGE_SAMPLE_CD_O_V4_V10, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x4, 0xA, 0x1 }, // 4893
  { IMAGE_SAMPLE_CD_O_V5_V3, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 4894
  { IMAGE_SAMPLE_CD_O_V5_V4, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 4895
  { IMAGE_SAMPLE_CD_O_V5_V5, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 4896
  { IMAGE_SAMPLE_CD_O_V5_V6, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 4897
  { IMAGE_SAMPLE_CD_O_V5_V7, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x5, 0x7, 0x1 }, // 4898
  { IMAGE_SAMPLE_CD_O_V5_V8, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 4899
  { IMAGE_SAMPLE_CD_O_V5_V9, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x5, 0x9, 0x1 }, // 4900
  { IMAGE_SAMPLE_CD_O_V5_V10, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x5, 0xA, 0x1 }, // 4901
  { IMAGE_SAMPLE_CD_O_G16_V1_V3_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 4902
  { IMAGE_SAMPLE_CD_O_G16_V1_V4_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 4903
  { IMAGE_SAMPLE_CD_O_G16_V1_V5_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 4904
  { IMAGE_SAMPLE_CD_O_G16_V1_V6_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 4905
  { IMAGE_SAMPLE_CD_O_G16_V1_V7_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x1, 0x7, 0x1 }, // 4906
  { IMAGE_SAMPLE_CD_O_G16_V1_V8_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 4907
  { IMAGE_SAMPLE_CD_O_G16_V2_V3_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 4908
  { IMAGE_SAMPLE_CD_O_G16_V2_V4_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 4909
  { IMAGE_SAMPLE_CD_O_G16_V2_V5_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 4910
  { IMAGE_SAMPLE_CD_O_G16_V2_V6_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 4911
  { IMAGE_SAMPLE_CD_O_G16_V2_V7_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x2, 0x7, 0x1 }, // 4912
  { IMAGE_SAMPLE_CD_O_G16_V2_V8_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 4913
  { IMAGE_SAMPLE_CD_O_G16_V3_V3_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 4914
  { IMAGE_SAMPLE_CD_O_G16_V3_V4_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 4915
  { IMAGE_SAMPLE_CD_O_G16_V3_V5_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 4916
  { IMAGE_SAMPLE_CD_O_G16_V3_V6_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 4917
  { IMAGE_SAMPLE_CD_O_G16_V3_V7_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x3, 0x7, 0x1 }, // 4918
  { IMAGE_SAMPLE_CD_O_G16_V3_V8_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 4919
  { IMAGE_SAMPLE_CD_O_G16_V4_V3_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 4920
  { IMAGE_SAMPLE_CD_O_G16_V4_V4_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 4921
  { IMAGE_SAMPLE_CD_O_G16_V4_V5_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 4922
  { IMAGE_SAMPLE_CD_O_G16_V4_V6_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 4923
  { IMAGE_SAMPLE_CD_O_G16_V4_V7_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x4, 0x7, 0x1 }, // 4924
  { IMAGE_SAMPLE_CD_O_G16_V4_V8_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 4925
  { IMAGE_SAMPLE_CD_O_G16_V5_V3_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 4926
  { IMAGE_SAMPLE_CD_O_G16_V5_V4_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 4927
  { IMAGE_SAMPLE_CD_O_G16_V5_V5_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 4928
  { IMAGE_SAMPLE_CD_O_G16_V5_V6_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 4929
  { IMAGE_SAMPLE_CD_O_G16_V5_V7_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x5, 0x7, 0x1 }, // 4930
  { IMAGE_SAMPLE_CD_O_G16_V5_V8_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 4931
  { IMAGE_SAMPLE_CD_O_G16_V1_V3_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 4932
  { IMAGE_SAMPLE_CD_O_G16_V1_V4_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 4933
  { IMAGE_SAMPLE_CD_O_G16_V1_V5_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 4934
  { IMAGE_SAMPLE_CD_O_G16_V1_V6_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 4935
  { IMAGE_SAMPLE_CD_O_G16_V1_V7_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x1, 0x7, 0x7 }, // 4936
  { IMAGE_SAMPLE_CD_O_G16_V1_V8_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x1, 0x8, 0x8 }, // 4937
  { IMAGE_SAMPLE_CD_O_G16_V2_V3_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 4938
  { IMAGE_SAMPLE_CD_O_G16_V2_V4_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 4939
  { IMAGE_SAMPLE_CD_O_G16_V2_V5_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 4940
  { IMAGE_SAMPLE_CD_O_G16_V2_V6_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 4941
  { IMAGE_SAMPLE_CD_O_G16_V2_V7_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x2, 0x7, 0x7 }, // 4942
  { IMAGE_SAMPLE_CD_O_G16_V2_V8_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x2, 0x8, 0x8 }, // 4943
  { IMAGE_SAMPLE_CD_O_G16_V3_V3_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 4944
  { IMAGE_SAMPLE_CD_O_G16_V3_V4_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 4945
  { IMAGE_SAMPLE_CD_O_G16_V3_V5_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 4946
  { IMAGE_SAMPLE_CD_O_G16_V3_V6_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 4947
  { IMAGE_SAMPLE_CD_O_G16_V3_V7_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x3, 0x7, 0x7 }, // 4948
  { IMAGE_SAMPLE_CD_O_G16_V3_V8_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x3, 0x8, 0x8 }, // 4949
  { IMAGE_SAMPLE_CD_O_G16_V4_V3_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 4950
  { IMAGE_SAMPLE_CD_O_G16_V4_V4_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 4951
  { IMAGE_SAMPLE_CD_O_G16_V4_V5_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 4952
  { IMAGE_SAMPLE_CD_O_G16_V4_V6_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 4953
  { IMAGE_SAMPLE_CD_O_G16_V4_V7_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x4, 0x7, 0x7 }, // 4954
  { IMAGE_SAMPLE_CD_O_G16_V4_V8_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x4, 0x8, 0x8 }, // 4955
  { IMAGE_SAMPLE_CD_O_G16_V5_V3_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 4956
  { IMAGE_SAMPLE_CD_O_G16_V5_V4_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 4957
  { IMAGE_SAMPLE_CD_O_G16_V5_V5_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 4958
  { IMAGE_SAMPLE_CD_O_G16_V5_V6_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 4959
  { IMAGE_SAMPLE_CD_O_G16_V5_V7_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x5, 0x7, 0x7 }, // 4960
  { IMAGE_SAMPLE_CD_O_G16_V5_V8_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x5, 0x8, 0x8 }, // 4961
  { IMAGE_SAMPLE_CD_O_G16_V1_V3, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 4962
  { IMAGE_SAMPLE_CD_O_G16_V1_V4, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 4963
  { IMAGE_SAMPLE_CD_O_G16_V1_V5, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 4964
  { IMAGE_SAMPLE_CD_O_G16_V1_V6, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 4965
  { IMAGE_SAMPLE_CD_O_G16_V1_V7, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x1, 0x7, 0x1 }, // 4966
  { IMAGE_SAMPLE_CD_O_G16_V1_V8, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 4967
  { IMAGE_SAMPLE_CD_O_G16_V2_V3, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 4968
  { IMAGE_SAMPLE_CD_O_G16_V2_V4, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 4969
  { IMAGE_SAMPLE_CD_O_G16_V2_V5, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 4970
  { IMAGE_SAMPLE_CD_O_G16_V2_V6, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 4971
  { IMAGE_SAMPLE_CD_O_G16_V2_V7, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x2, 0x7, 0x1 }, // 4972
  { IMAGE_SAMPLE_CD_O_G16_V2_V8, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 4973
  { IMAGE_SAMPLE_CD_O_G16_V3_V3, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 4974
  { IMAGE_SAMPLE_CD_O_G16_V3_V4, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 4975
  { IMAGE_SAMPLE_CD_O_G16_V3_V5, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 4976
  { IMAGE_SAMPLE_CD_O_G16_V3_V6, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 4977
  { IMAGE_SAMPLE_CD_O_G16_V3_V7, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x3, 0x7, 0x1 }, // 4978
  { IMAGE_SAMPLE_CD_O_G16_V3_V8, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 4979
  { IMAGE_SAMPLE_CD_O_G16_V4_V3, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 4980
  { IMAGE_SAMPLE_CD_O_G16_V4_V4, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 4981
  { IMAGE_SAMPLE_CD_O_G16_V4_V5, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 4982
  { IMAGE_SAMPLE_CD_O_G16_V4_V6, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 4983
  { IMAGE_SAMPLE_CD_O_G16_V4_V7, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x4, 0x7, 0x1 }, // 4984
  { IMAGE_SAMPLE_CD_O_G16_V4_V8, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 4985
  { IMAGE_SAMPLE_CD_O_G16_V5_V3, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 4986
  { IMAGE_SAMPLE_CD_O_G16_V5_V4, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 4987
  { IMAGE_SAMPLE_CD_O_G16_V5_V5, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 4988
  { IMAGE_SAMPLE_CD_O_G16_V5_V6, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 4989
  { IMAGE_SAMPLE_CD_O_G16_V5_V7, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x5, 0x7, 0x1 }, // 4990
  { IMAGE_SAMPLE_CD_O_G16_V5_V8, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 4991
  { IMAGE_SAMPLE_CL_V1_V1_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 4992
  { IMAGE_SAMPLE_CL_V1_V2_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 4993
  { IMAGE_SAMPLE_CL_V1_V3_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 4994
  { IMAGE_SAMPLE_CL_V1_V4_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 4995
  { IMAGE_SAMPLE_CL_V2_V1_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 4996
  { IMAGE_SAMPLE_CL_V2_V2_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 4997
  { IMAGE_SAMPLE_CL_V2_V3_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 4998
  { IMAGE_SAMPLE_CL_V2_V4_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 4999
  { IMAGE_SAMPLE_CL_V3_V1_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x3, 0x1, 0x1 }, // 5000
  { IMAGE_SAMPLE_CL_V3_V2_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 5001
  { IMAGE_SAMPLE_CL_V3_V3_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 5002
  { IMAGE_SAMPLE_CL_V3_V4_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 5003
  { IMAGE_SAMPLE_CL_V4_V1_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 5004
  { IMAGE_SAMPLE_CL_V4_V2_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 5005
  { IMAGE_SAMPLE_CL_V4_V3_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 5006
  { IMAGE_SAMPLE_CL_V4_V4_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 5007
  { IMAGE_SAMPLE_CL_V5_V1_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x5, 0x1, 0x1 }, // 5008
  { IMAGE_SAMPLE_CL_V5_V2_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 5009
  { IMAGE_SAMPLE_CL_V5_V3_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 5010
  { IMAGE_SAMPLE_CL_V5_V4_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 5011
  { IMAGE_SAMPLE_CL_V1_V2_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 5012
  { IMAGE_SAMPLE_CL_V1_V3_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 5013
  { IMAGE_SAMPLE_CL_V1_V4_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 5014
  { IMAGE_SAMPLE_CL_V2_V2_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 5015
  { IMAGE_SAMPLE_CL_V2_V3_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 5016
  { IMAGE_SAMPLE_CL_V2_V4_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 5017
  { IMAGE_SAMPLE_CL_V3_V2_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 5018
  { IMAGE_SAMPLE_CL_V3_V3_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 5019
  { IMAGE_SAMPLE_CL_V3_V4_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 5020
  { IMAGE_SAMPLE_CL_V4_V2_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 5021
  { IMAGE_SAMPLE_CL_V4_V3_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 5022
  { IMAGE_SAMPLE_CL_V4_V4_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 5023
  { IMAGE_SAMPLE_CL_V5_V2_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 5024
  { IMAGE_SAMPLE_CL_V5_V3_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 5025
  { IMAGE_SAMPLE_CL_V5_V4_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 5026
  { IMAGE_SAMPLE_CL_V1_V1_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 5027
  { IMAGE_SAMPLE_CL_V1_V2_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 5028
  { IMAGE_SAMPLE_CL_V1_V3_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 5029
  { IMAGE_SAMPLE_CL_V1_V4_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 5030
  { IMAGE_SAMPLE_CL_V2_V1_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 5031
  { IMAGE_SAMPLE_CL_V2_V2_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 5032
  { IMAGE_SAMPLE_CL_V2_V3_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 5033
  { IMAGE_SAMPLE_CL_V2_V4_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 5034
  { IMAGE_SAMPLE_CL_V3_V1_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x3, 0x1, 0x1 }, // 5035
  { IMAGE_SAMPLE_CL_V3_V2_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 5036
  { IMAGE_SAMPLE_CL_V3_V3_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 5037
  { IMAGE_SAMPLE_CL_V3_V4_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 5038
  { IMAGE_SAMPLE_CL_V4_V1_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 5039
  { IMAGE_SAMPLE_CL_V4_V2_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 5040
  { IMAGE_SAMPLE_CL_V4_V3_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 5041
  { IMAGE_SAMPLE_CL_V4_V4_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 5042
  { IMAGE_SAMPLE_CL_V5_V1_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x5, 0x1, 0x1 }, // 5043
  { IMAGE_SAMPLE_CL_V5_V2_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 5044
  { IMAGE_SAMPLE_CL_V5_V3_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 5045
  { IMAGE_SAMPLE_CL_V5_V4_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 5046
  { IMAGE_SAMPLE_CL_V1_V2_nsa_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 5047
  { IMAGE_SAMPLE_CL_V1_V3_nsa_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 5048
  { IMAGE_SAMPLE_CL_V1_V4_nsa_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 5049
  { IMAGE_SAMPLE_CL_V2_V2_nsa_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 5050
  { IMAGE_SAMPLE_CL_V2_V3_nsa_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 5051
  { IMAGE_SAMPLE_CL_V2_V4_nsa_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 5052
  { IMAGE_SAMPLE_CL_V3_V2_nsa_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 5053
  { IMAGE_SAMPLE_CL_V3_V3_nsa_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 5054
  { IMAGE_SAMPLE_CL_V3_V4_nsa_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 5055
  { IMAGE_SAMPLE_CL_V4_V2_nsa_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 5056
  { IMAGE_SAMPLE_CL_V4_V3_nsa_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 5057
  { IMAGE_SAMPLE_CL_V4_V4_nsa_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 5058
  { IMAGE_SAMPLE_CL_V5_V2_nsa_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 5059
  { IMAGE_SAMPLE_CL_V5_V3_nsa_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 5060
  { IMAGE_SAMPLE_CL_V5_V4_nsa_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 5061
  { IMAGE_SAMPLE_CL_V1_V1_gfx12, IMAGE_SAMPLE_CL, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 5062
  { IMAGE_SAMPLE_CL_V1_V2_gfx12, IMAGE_SAMPLE_CL, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 5063
  { IMAGE_SAMPLE_CL_V1_V3_gfx12, IMAGE_SAMPLE_CL, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 5064
  { IMAGE_SAMPLE_CL_V1_V4_gfx12, IMAGE_SAMPLE_CL, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 5065
  { IMAGE_SAMPLE_CL_V2_V1_gfx12, IMAGE_SAMPLE_CL, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 5066
  { IMAGE_SAMPLE_CL_V2_V2_gfx12, IMAGE_SAMPLE_CL, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 5067
  { IMAGE_SAMPLE_CL_V2_V3_gfx12, IMAGE_SAMPLE_CL, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 5068
  { IMAGE_SAMPLE_CL_V2_V4_gfx12, IMAGE_SAMPLE_CL, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 5069
  { IMAGE_SAMPLE_CL_V3_V1_gfx12, IMAGE_SAMPLE_CL, MIMGEncGfx12, 0x3, 0x1, 0x1 }, // 5070
  { IMAGE_SAMPLE_CL_V3_V2_gfx12, IMAGE_SAMPLE_CL, MIMGEncGfx12, 0x3, 0x2, 0x2 }, // 5071
  { IMAGE_SAMPLE_CL_V3_V3_gfx12, IMAGE_SAMPLE_CL, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 5072
  { IMAGE_SAMPLE_CL_V3_V4_gfx12, IMAGE_SAMPLE_CL, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 5073
  { IMAGE_SAMPLE_CL_V4_V1_gfx12, IMAGE_SAMPLE_CL, MIMGEncGfx12, 0x4, 0x1, 0x1 }, // 5074
  { IMAGE_SAMPLE_CL_V4_V2_gfx12, IMAGE_SAMPLE_CL, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 5075
  { IMAGE_SAMPLE_CL_V4_V3_gfx12, IMAGE_SAMPLE_CL, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 5076
  { IMAGE_SAMPLE_CL_V4_V4_gfx12, IMAGE_SAMPLE_CL, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 5077
  { IMAGE_SAMPLE_CL_V5_V1_gfx12, IMAGE_SAMPLE_CL, MIMGEncGfx12, 0x5, 0x1, 0x1 }, // 5078
  { IMAGE_SAMPLE_CL_V5_V2_gfx12, IMAGE_SAMPLE_CL, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 5079
  { IMAGE_SAMPLE_CL_V5_V3_gfx12, IMAGE_SAMPLE_CL, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 5080
  { IMAGE_SAMPLE_CL_V5_V4_gfx12, IMAGE_SAMPLE_CL, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 5081
  { IMAGE_SAMPLE_CL_V1_V1, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 5082
  { IMAGE_SAMPLE_CL_V1_V2, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 5083
  { IMAGE_SAMPLE_CL_V1_V3, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 5084
  { IMAGE_SAMPLE_CL_V1_V4, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 5085
  { IMAGE_SAMPLE_CL_V2_V1, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 5086
  { IMAGE_SAMPLE_CL_V2_V2, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 5087
  { IMAGE_SAMPLE_CL_V2_V3, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 5088
  { IMAGE_SAMPLE_CL_V2_V4, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 5089
  { IMAGE_SAMPLE_CL_V3_V1, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x3, 0x1, 0x1 }, // 5090
  { IMAGE_SAMPLE_CL_V3_V2, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 5091
  { IMAGE_SAMPLE_CL_V3_V3, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 5092
  { IMAGE_SAMPLE_CL_V3_V4, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 5093
  { IMAGE_SAMPLE_CL_V4_V1, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 5094
  { IMAGE_SAMPLE_CL_V4_V2, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 5095
  { IMAGE_SAMPLE_CL_V4_V3, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 5096
  { IMAGE_SAMPLE_CL_V4_V4, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 5097
  { IMAGE_SAMPLE_CL_V5_V1, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x5, 0x1, 0x1 }, // 5098
  { IMAGE_SAMPLE_CL_V5_V2, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 5099
  { IMAGE_SAMPLE_CL_V5_V3, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 5100
  { IMAGE_SAMPLE_CL_V5_V4, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 5101
  { IMAGE_SAMPLE_CL_O_V1_V2_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 5102
  { IMAGE_SAMPLE_CL_O_V1_V3_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 5103
  { IMAGE_SAMPLE_CL_O_V1_V4_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 5104
  { IMAGE_SAMPLE_CL_O_V1_V5_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 5105
  { IMAGE_SAMPLE_CL_O_V1_V8_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 5106
  { IMAGE_SAMPLE_CL_O_V2_V2_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 5107
  { IMAGE_SAMPLE_CL_O_V2_V3_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 5108
  { IMAGE_SAMPLE_CL_O_V2_V4_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 5109
  { IMAGE_SAMPLE_CL_O_V2_V5_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 5110
  { IMAGE_SAMPLE_CL_O_V2_V8_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 5111
  { IMAGE_SAMPLE_CL_O_V3_V2_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 5112
  { IMAGE_SAMPLE_CL_O_V3_V3_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 5113
  { IMAGE_SAMPLE_CL_O_V3_V4_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 5114
  { IMAGE_SAMPLE_CL_O_V3_V5_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 5115
  { IMAGE_SAMPLE_CL_O_V3_V8_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 5116
  { IMAGE_SAMPLE_CL_O_V4_V2_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 5117
  { IMAGE_SAMPLE_CL_O_V4_V3_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 5118
  { IMAGE_SAMPLE_CL_O_V4_V4_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 5119
  { IMAGE_SAMPLE_CL_O_V4_V5_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 5120
  { IMAGE_SAMPLE_CL_O_V4_V8_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 5121
  { IMAGE_SAMPLE_CL_O_V5_V2_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 5122
  { IMAGE_SAMPLE_CL_O_V5_V3_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 5123
  { IMAGE_SAMPLE_CL_O_V5_V4_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 5124
  { IMAGE_SAMPLE_CL_O_V5_V5_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 5125
  { IMAGE_SAMPLE_CL_O_V5_V8_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 5126
  { IMAGE_SAMPLE_CL_O_V1_V2_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 5127
  { IMAGE_SAMPLE_CL_O_V1_V3_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 5128
  { IMAGE_SAMPLE_CL_O_V1_V4_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 5129
  { IMAGE_SAMPLE_CL_O_V1_V5_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 5130
  { IMAGE_SAMPLE_CL_O_V2_V2_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 5131
  { IMAGE_SAMPLE_CL_O_V2_V3_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 5132
  { IMAGE_SAMPLE_CL_O_V2_V4_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 5133
  { IMAGE_SAMPLE_CL_O_V2_V5_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 5134
  { IMAGE_SAMPLE_CL_O_V3_V2_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 5135
  { IMAGE_SAMPLE_CL_O_V3_V3_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 5136
  { IMAGE_SAMPLE_CL_O_V3_V4_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 5137
  { IMAGE_SAMPLE_CL_O_V3_V5_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 5138
  { IMAGE_SAMPLE_CL_O_V4_V2_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 5139
  { IMAGE_SAMPLE_CL_O_V4_V3_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 5140
  { IMAGE_SAMPLE_CL_O_V4_V4_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 5141
  { IMAGE_SAMPLE_CL_O_V4_V5_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 5142
  { IMAGE_SAMPLE_CL_O_V5_V2_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 5143
  { IMAGE_SAMPLE_CL_O_V5_V3_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 5144
  { IMAGE_SAMPLE_CL_O_V5_V4_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 5145
  { IMAGE_SAMPLE_CL_O_V5_V5_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 5146
  { IMAGE_SAMPLE_CL_O_V1_V2_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 5147
  { IMAGE_SAMPLE_CL_O_V1_V3_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 5148
  { IMAGE_SAMPLE_CL_O_V1_V4_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 5149
  { IMAGE_SAMPLE_CL_O_V1_V5_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x1, 0x5, 0x1 }, // 5150
  { IMAGE_SAMPLE_CL_O_V1_V8_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x1, 0x8, 0x1 }, // 5151
  { IMAGE_SAMPLE_CL_O_V2_V2_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 5152
  { IMAGE_SAMPLE_CL_O_V2_V3_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 5153
  { IMAGE_SAMPLE_CL_O_V2_V4_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 5154
  { IMAGE_SAMPLE_CL_O_V2_V5_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 5155
  { IMAGE_SAMPLE_CL_O_V2_V8_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 5156
  { IMAGE_SAMPLE_CL_O_V3_V2_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 5157
  { IMAGE_SAMPLE_CL_O_V3_V3_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 5158
  { IMAGE_SAMPLE_CL_O_V3_V4_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 5159
  { IMAGE_SAMPLE_CL_O_V3_V5_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x3, 0x5, 0x1 }, // 5160
  { IMAGE_SAMPLE_CL_O_V3_V8_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x3, 0x8, 0x1 }, // 5161
  { IMAGE_SAMPLE_CL_O_V4_V2_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 5162
  { IMAGE_SAMPLE_CL_O_V4_V3_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 5163
  { IMAGE_SAMPLE_CL_O_V4_V4_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 5164
  { IMAGE_SAMPLE_CL_O_V4_V5_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 5165
  { IMAGE_SAMPLE_CL_O_V4_V8_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 5166
  { IMAGE_SAMPLE_CL_O_V5_V2_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 5167
  { IMAGE_SAMPLE_CL_O_V5_V3_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 5168
  { IMAGE_SAMPLE_CL_O_V5_V4_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 5169
  { IMAGE_SAMPLE_CL_O_V5_V5_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 5170
  { IMAGE_SAMPLE_CL_O_V5_V8_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 5171
  { IMAGE_SAMPLE_CL_O_V1_V2_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 5172
  { IMAGE_SAMPLE_CL_O_V1_V3_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 5173
  { IMAGE_SAMPLE_CL_O_V1_V4_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 5174
  { IMAGE_SAMPLE_CL_O_V1_V5_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x1, 0x5, 0x5 }, // 5175
  { IMAGE_SAMPLE_CL_O_V2_V2_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 5176
  { IMAGE_SAMPLE_CL_O_V2_V3_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 5177
  { IMAGE_SAMPLE_CL_O_V2_V4_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 5178
  { IMAGE_SAMPLE_CL_O_V2_V5_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 5179
  { IMAGE_SAMPLE_CL_O_V3_V2_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 5180
  { IMAGE_SAMPLE_CL_O_V3_V3_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 5181
  { IMAGE_SAMPLE_CL_O_V3_V4_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 5182
  { IMAGE_SAMPLE_CL_O_V3_V5_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x3, 0x5, 0x5 }, // 5183
  { IMAGE_SAMPLE_CL_O_V4_V2_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 5184
  { IMAGE_SAMPLE_CL_O_V4_V3_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 5185
  { IMAGE_SAMPLE_CL_O_V4_V4_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 5186
  { IMAGE_SAMPLE_CL_O_V4_V5_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 5187
  { IMAGE_SAMPLE_CL_O_V5_V2_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 5188
  { IMAGE_SAMPLE_CL_O_V5_V3_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 5189
  { IMAGE_SAMPLE_CL_O_V5_V4_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 5190
  { IMAGE_SAMPLE_CL_O_V5_V5_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 5191
  { IMAGE_SAMPLE_CL_O_V1_V2_gfx12, IMAGE_SAMPLE_CL_O, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 5192
  { IMAGE_SAMPLE_CL_O_V1_V3_gfx12, IMAGE_SAMPLE_CL_O, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 5193
  { IMAGE_SAMPLE_CL_O_V1_V4_gfx12, IMAGE_SAMPLE_CL_O, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 5194
  { IMAGE_SAMPLE_CL_O_V1_V5_gfx12, IMAGE_SAMPLE_CL_O, MIMGEncGfx12, 0x1, 0x5, 0x5 }, // 5195
  { IMAGE_SAMPLE_CL_O_V2_V2_gfx12, IMAGE_SAMPLE_CL_O, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 5196
  { IMAGE_SAMPLE_CL_O_V2_V3_gfx12, IMAGE_SAMPLE_CL_O, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 5197
  { IMAGE_SAMPLE_CL_O_V2_V4_gfx12, IMAGE_SAMPLE_CL_O, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 5198
  { IMAGE_SAMPLE_CL_O_V2_V5_gfx12, IMAGE_SAMPLE_CL_O, MIMGEncGfx12, 0x2, 0x5, 0x5 }, // 5199
  { IMAGE_SAMPLE_CL_O_V3_V2_gfx12, IMAGE_SAMPLE_CL_O, MIMGEncGfx12, 0x3, 0x2, 0x2 }, // 5200
  { IMAGE_SAMPLE_CL_O_V3_V3_gfx12, IMAGE_SAMPLE_CL_O, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 5201
  { IMAGE_SAMPLE_CL_O_V3_V4_gfx12, IMAGE_SAMPLE_CL_O, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 5202
  { IMAGE_SAMPLE_CL_O_V3_V5_gfx12, IMAGE_SAMPLE_CL_O, MIMGEncGfx12, 0x3, 0x5, 0x5 }, // 5203
  { IMAGE_SAMPLE_CL_O_V4_V2_gfx12, IMAGE_SAMPLE_CL_O, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 5204
  { IMAGE_SAMPLE_CL_O_V4_V3_gfx12, IMAGE_SAMPLE_CL_O, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 5205
  { IMAGE_SAMPLE_CL_O_V4_V4_gfx12, IMAGE_SAMPLE_CL_O, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 5206
  { IMAGE_SAMPLE_CL_O_V4_V5_gfx12, IMAGE_SAMPLE_CL_O, MIMGEncGfx12, 0x4, 0x5, 0x5 }, // 5207
  { IMAGE_SAMPLE_CL_O_V5_V2_gfx12, IMAGE_SAMPLE_CL_O, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 5208
  { IMAGE_SAMPLE_CL_O_V5_V3_gfx12, IMAGE_SAMPLE_CL_O, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 5209
  { IMAGE_SAMPLE_CL_O_V5_V4_gfx12, IMAGE_SAMPLE_CL_O, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 5210
  { IMAGE_SAMPLE_CL_O_V5_V5_gfx12, IMAGE_SAMPLE_CL_O, MIMGEncGfx12, 0x5, 0x5, 0x5 }, // 5211
  { IMAGE_SAMPLE_CL_O_V1_V2, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 5212
  { IMAGE_SAMPLE_CL_O_V1_V3, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 5213
  { IMAGE_SAMPLE_CL_O_V1_V4, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 5214
  { IMAGE_SAMPLE_CL_O_V1_V5, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 5215
  { IMAGE_SAMPLE_CL_O_V1_V8, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 5216
  { IMAGE_SAMPLE_CL_O_V2_V2, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 5217
  { IMAGE_SAMPLE_CL_O_V2_V3, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 5218
  { IMAGE_SAMPLE_CL_O_V2_V4, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 5219
  { IMAGE_SAMPLE_CL_O_V2_V5, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 5220
  { IMAGE_SAMPLE_CL_O_V2_V8, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 5221
  { IMAGE_SAMPLE_CL_O_V3_V2, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 5222
  { IMAGE_SAMPLE_CL_O_V3_V3, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 5223
  { IMAGE_SAMPLE_CL_O_V3_V4, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 5224
  { IMAGE_SAMPLE_CL_O_V3_V5, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 5225
  { IMAGE_SAMPLE_CL_O_V3_V8, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 5226
  { IMAGE_SAMPLE_CL_O_V4_V2, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 5227
  { IMAGE_SAMPLE_CL_O_V4_V3, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 5228
  { IMAGE_SAMPLE_CL_O_V4_V4, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 5229
  { IMAGE_SAMPLE_CL_O_V4_V5, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 5230
  { IMAGE_SAMPLE_CL_O_V4_V8, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 5231
  { IMAGE_SAMPLE_CL_O_V5_V2, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 5232
  { IMAGE_SAMPLE_CL_O_V5_V3, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 5233
  { IMAGE_SAMPLE_CL_O_V5_V4, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 5234
  { IMAGE_SAMPLE_CL_O_V5_V5, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 5235
  { IMAGE_SAMPLE_CL_O_V5_V8, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 5236
  { IMAGE_SAMPLE_C_B_V1_V3_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 5237
  { IMAGE_SAMPLE_C_B_V1_V4_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 5238
  { IMAGE_SAMPLE_C_B_V1_V5_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 5239
  { IMAGE_SAMPLE_C_B_V1_V8_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 5240
  { IMAGE_SAMPLE_C_B_V2_V3_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 5241
  { IMAGE_SAMPLE_C_B_V2_V4_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 5242
  { IMAGE_SAMPLE_C_B_V2_V5_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 5243
  { IMAGE_SAMPLE_C_B_V2_V8_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 5244
  { IMAGE_SAMPLE_C_B_V3_V3_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 5245
  { IMAGE_SAMPLE_C_B_V3_V4_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 5246
  { IMAGE_SAMPLE_C_B_V3_V5_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 5247
  { IMAGE_SAMPLE_C_B_V3_V8_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 5248
  { IMAGE_SAMPLE_C_B_V4_V3_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 5249
  { IMAGE_SAMPLE_C_B_V4_V4_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 5250
  { IMAGE_SAMPLE_C_B_V4_V5_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 5251
  { IMAGE_SAMPLE_C_B_V4_V8_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 5252
  { IMAGE_SAMPLE_C_B_V5_V3_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 5253
  { IMAGE_SAMPLE_C_B_V5_V4_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 5254
  { IMAGE_SAMPLE_C_B_V5_V5_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 5255
  { IMAGE_SAMPLE_C_B_V5_V8_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 5256
  { IMAGE_SAMPLE_C_B_V1_V3_nsa_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 5257
  { IMAGE_SAMPLE_C_B_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 5258
  { IMAGE_SAMPLE_C_B_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 5259
  { IMAGE_SAMPLE_C_B_V2_V3_nsa_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 5260
  { IMAGE_SAMPLE_C_B_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 5261
  { IMAGE_SAMPLE_C_B_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 5262
  { IMAGE_SAMPLE_C_B_V3_V3_nsa_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 5263
  { IMAGE_SAMPLE_C_B_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 5264
  { IMAGE_SAMPLE_C_B_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 5265
  { IMAGE_SAMPLE_C_B_V4_V3_nsa_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 5266
  { IMAGE_SAMPLE_C_B_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 5267
  { IMAGE_SAMPLE_C_B_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 5268
  { IMAGE_SAMPLE_C_B_V5_V3_nsa_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 5269
  { IMAGE_SAMPLE_C_B_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 5270
  { IMAGE_SAMPLE_C_B_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_B, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 5271
  { IMAGE_SAMPLE_C_B_V1_V3_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 5272
  { IMAGE_SAMPLE_C_B_V1_V4_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 5273
  { IMAGE_SAMPLE_C_B_V1_V5_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11Default, 0x1, 0x5, 0x1 }, // 5274
  { IMAGE_SAMPLE_C_B_V1_V8_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11Default, 0x1, 0x8, 0x1 }, // 5275
  { IMAGE_SAMPLE_C_B_V2_V3_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 5276
  { IMAGE_SAMPLE_C_B_V2_V4_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 5277
  { IMAGE_SAMPLE_C_B_V2_V5_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 5278
  { IMAGE_SAMPLE_C_B_V2_V8_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 5279
  { IMAGE_SAMPLE_C_B_V3_V3_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 5280
  { IMAGE_SAMPLE_C_B_V3_V4_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 5281
  { IMAGE_SAMPLE_C_B_V3_V5_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11Default, 0x3, 0x5, 0x1 }, // 5282
  { IMAGE_SAMPLE_C_B_V3_V8_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11Default, 0x3, 0x8, 0x1 }, // 5283
  { IMAGE_SAMPLE_C_B_V4_V3_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 5284
  { IMAGE_SAMPLE_C_B_V4_V4_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 5285
  { IMAGE_SAMPLE_C_B_V4_V5_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 5286
  { IMAGE_SAMPLE_C_B_V4_V8_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 5287
  { IMAGE_SAMPLE_C_B_V5_V3_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 5288
  { IMAGE_SAMPLE_C_B_V5_V4_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 5289
  { IMAGE_SAMPLE_C_B_V5_V5_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 5290
  { IMAGE_SAMPLE_C_B_V5_V8_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 5291
  { IMAGE_SAMPLE_C_B_V1_V3_nsa_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 5292
  { IMAGE_SAMPLE_C_B_V1_V4_nsa_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 5293
  { IMAGE_SAMPLE_C_B_V1_V5_nsa_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11NSA, 0x1, 0x5, 0x5 }, // 5294
  { IMAGE_SAMPLE_C_B_V2_V3_nsa_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 5295
  { IMAGE_SAMPLE_C_B_V2_V4_nsa_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 5296
  { IMAGE_SAMPLE_C_B_V2_V5_nsa_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 5297
  { IMAGE_SAMPLE_C_B_V3_V3_nsa_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 5298
  { IMAGE_SAMPLE_C_B_V3_V4_nsa_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 5299
  { IMAGE_SAMPLE_C_B_V3_V5_nsa_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11NSA, 0x3, 0x5, 0x5 }, // 5300
  { IMAGE_SAMPLE_C_B_V4_V3_nsa_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 5301
  { IMAGE_SAMPLE_C_B_V4_V4_nsa_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 5302
  { IMAGE_SAMPLE_C_B_V4_V5_nsa_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 5303
  { IMAGE_SAMPLE_C_B_V5_V3_nsa_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 5304
  { IMAGE_SAMPLE_C_B_V5_V4_nsa_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 5305
  { IMAGE_SAMPLE_C_B_V5_V5_nsa_gfx11, IMAGE_SAMPLE_C_B, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 5306
  { IMAGE_SAMPLE_C_B_V1_V3_gfx12, IMAGE_SAMPLE_C_B, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 5307
  { IMAGE_SAMPLE_C_B_V1_V4_gfx12, IMAGE_SAMPLE_C_B, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 5308
  { IMAGE_SAMPLE_C_B_V1_V5_gfx12, IMAGE_SAMPLE_C_B, MIMGEncGfx12, 0x1, 0x5, 0x5 }, // 5309
  { IMAGE_SAMPLE_C_B_V2_V3_gfx12, IMAGE_SAMPLE_C_B, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 5310
  { IMAGE_SAMPLE_C_B_V2_V4_gfx12, IMAGE_SAMPLE_C_B, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 5311
  { IMAGE_SAMPLE_C_B_V2_V5_gfx12, IMAGE_SAMPLE_C_B, MIMGEncGfx12, 0x2, 0x5, 0x5 }, // 5312
  { IMAGE_SAMPLE_C_B_V3_V3_gfx12, IMAGE_SAMPLE_C_B, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 5313
  { IMAGE_SAMPLE_C_B_V3_V4_gfx12, IMAGE_SAMPLE_C_B, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 5314
  { IMAGE_SAMPLE_C_B_V3_V5_gfx12, IMAGE_SAMPLE_C_B, MIMGEncGfx12, 0x3, 0x5, 0x5 }, // 5315
  { IMAGE_SAMPLE_C_B_V4_V3_gfx12, IMAGE_SAMPLE_C_B, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 5316
  { IMAGE_SAMPLE_C_B_V4_V4_gfx12, IMAGE_SAMPLE_C_B, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 5317
  { IMAGE_SAMPLE_C_B_V4_V5_gfx12, IMAGE_SAMPLE_C_B, MIMGEncGfx12, 0x4, 0x5, 0x5 }, // 5318
  { IMAGE_SAMPLE_C_B_V5_V3_gfx12, IMAGE_SAMPLE_C_B, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 5319
  { IMAGE_SAMPLE_C_B_V5_V4_gfx12, IMAGE_SAMPLE_C_B, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 5320
  { IMAGE_SAMPLE_C_B_V5_V5_gfx12, IMAGE_SAMPLE_C_B, MIMGEncGfx12, 0x5, 0x5, 0x5 }, // 5321
  { IMAGE_SAMPLE_C_B_V1_V3, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 5322
  { IMAGE_SAMPLE_C_B_V1_V4, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 5323
  { IMAGE_SAMPLE_C_B_V1_V5, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 5324
  { IMAGE_SAMPLE_C_B_V1_V8, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 5325
  { IMAGE_SAMPLE_C_B_V2_V3, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 5326
  { IMAGE_SAMPLE_C_B_V2_V4, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 5327
  { IMAGE_SAMPLE_C_B_V2_V5, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 5328
  { IMAGE_SAMPLE_C_B_V2_V8, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 5329
  { IMAGE_SAMPLE_C_B_V3_V3, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 5330
  { IMAGE_SAMPLE_C_B_V3_V4, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 5331
  { IMAGE_SAMPLE_C_B_V3_V5, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 5332
  { IMAGE_SAMPLE_C_B_V3_V8, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 5333
  { IMAGE_SAMPLE_C_B_V4_V3, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 5334
  { IMAGE_SAMPLE_C_B_V4_V4, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 5335
  { IMAGE_SAMPLE_C_B_V4_V5, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 5336
  { IMAGE_SAMPLE_C_B_V4_V8, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 5337
  { IMAGE_SAMPLE_C_B_V5_V3, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 5338
  { IMAGE_SAMPLE_C_B_V5_V4, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 5339
  { IMAGE_SAMPLE_C_B_V5_V5, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 5340
  { IMAGE_SAMPLE_C_B_V5_V8, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 5341
  { IMAGE_SAMPLE_C_B_CL_V1_V3_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 5342
  { IMAGE_SAMPLE_C_B_CL_V1_V4_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 5343
  { IMAGE_SAMPLE_C_B_CL_V1_V5_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 5344
  { IMAGE_SAMPLE_C_B_CL_V1_V6_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 5345
  { IMAGE_SAMPLE_C_B_CL_V1_V8_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 5346
  { IMAGE_SAMPLE_C_B_CL_V2_V3_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 5347
  { IMAGE_SAMPLE_C_B_CL_V2_V4_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 5348
  { IMAGE_SAMPLE_C_B_CL_V2_V5_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 5349
  { IMAGE_SAMPLE_C_B_CL_V2_V6_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 5350
  { IMAGE_SAMPLE_C_B_CL_V2_V8_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 5351
  { IMAGE_SAMPLE_C_B_CL_V3_V3_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 5352
  { IMAGE_SAMPLE_C_B_CL_V3_V4_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 5353
  { IMAGE_SAMPLE_C_B_CL_V3_V5_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 5354
  { IMAGE_SAMPLE_C_B_CL_V3_V6_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 5355
  { IMAGE_SAMPLE_C_B_CL_V3_V8_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 5356
  { IMAGE_SAMPLE_C_B_CL_V4_V3_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 5357
  { IMAGE_SAMPLE_C_B_CL_V4_V4_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 5358
  { IMAGE_SAMPLE_C_B_CL_V4_V5_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 5359
  { IMAGE_SAMPLE_C_B_CL_V4_V6_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 5360
  { IMAGE_SAMPLE_C_B_CL_V4_V8_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 5361
  { IMAGE_SAMPLE_C_B_CL_V5_V3_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 5362
  { IMAGE_SAMPLE_C_B_CL_V5_V4_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 5363
  { IMAGE_SAMPLE_C_B_CL_V5_V5_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 5364
  { IMAGE_SAMPLE_C_B_CL_V5_V6_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 5365
  { IMAGE_SAMPLE_C_B_CL_V5_V8_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 5366
  { IMAGE_SAMPLE_C_B_CL_V1_V3_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 5367
  { IMAGE_SAMPLE_C_B_CL_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 5368
  { IMAGE_SAMPLE_C_B_CL_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 5369
  { IMAGE_SAMPLE_C_B_CL_V1_V6_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 5370
  { IMAGE_SAMPLE_C_B_CL_V2_V3_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 5371
  { IMAGE_SAMPLE_C_B_CL_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 5372
  { IMAGE_SAMPLE_C_B_CL_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 5373
  { IMAGE_SAMPLE_C_B_CL_V2_V6_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 5374
  { IMAGE_SAMPLE_C_B_CL_V3_V3_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 5375
  { IMAGE_SAMPLE_C_B_CL_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 5376
  { IMAGE_SAMPLE_C_B_CL_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 5377
  { IMAGE_SAMPLE_C_B_CL_V3_V6_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 5378
  { IMAGE_SAMPLE_C_B_CL_V4_V3_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 5379
  { IMAGE_SAMPLE_C_B_CL_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 5380
  { IMAGE_SAMPLE_C_B_CL_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 5381
  { IMAGE_SAMPLE_C_B_CL_V4_V6_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 5382
  { IMAGE_SAMPLE_C_B_CL_V5_V3_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 5383
  { IMAGE_SAMPLE_C_B_CL_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 5384
  { IMAGE_SAMPLE_C_B_CL_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 5385
  { IMAGE_SAMPLE_C_B_CL_V5_V6_nsa_gfx10, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 5386
  { IMAGE_SAMPLE_C_B_CL_V1_V3_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 5387
  { IMAGE_SAMPLE_C_B_CL_V1_V4_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 5388
  { IMAGE_SAMPLE_C_B_CL_V1_V5_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x1, 0x5, 0x1 }, // 5389
  { IMAGE_SAMPLE_C_B_CL_V1_V6_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x1, 0x6, 0x1 }, // 5390
  { IMAGE_SAMPLE_C_B_CL_V1_V8_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x1, 0x8, 0x1 }, // 5391
  { IMAGE_SAMPLE_C_B_CL_V2_V3_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 5392
  { IMAGE_SAMPLE_C_B_CL_V2_V4_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 5393
  { IMAGE_SAMPLE_C_B_CL_V2_V5_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 5394
  { IMAGE_SAMPLE_C_B_CL_V2_V6_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x2, 0x6, 0x1 }, // 5395
  { IMAGE_SAMPLE_C_B_CL_V2_V8_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 5396
  { IMAGE_SAMPLE_C_B_CL_V3_V3_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 5397
  { IMAGE_SAMPLE_C_B_CL_V3_V4_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 5398
  { IMAGE_SAMPLE_C_B_CL_V3_V5_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x3, 0x5, 0x1 }, // 5399
  { IMAGE_SAMPLE_C_B_CL_V3_V6_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x3, 0x6, 0x1 }, // 5400
  { IMAGE_SAMPLE_C_B_CL_V3_V8_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x3, 0x8, 0x1 }, // 5401
  { IMAGE_SAMPLE_C_B_CL_V4_V3_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 5402
  { IMAGE_SAMPLE_C_B_CL_V4_V4_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 5403
  { IMAGE_SAMPLE_C_B_CL_V4_V5_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 5404
  { IMAGE_SAMPLE_C_B_CL_V4_V6_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x4, 0x6, 0x1 }, // 5405
  { IMAGE_SAMPLE_C_B_CL_V4_V8_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 5406
  { IMAGE_SAMPLE_C_B_CL_V5_V3_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 5407
  { IMAGE_SAMPLE_C_B_CL_V5_V4_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 5408
  { IMAGE_SAMPLE_C_B_CL_V5_V5_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 5409
  { IMAGE_SAMPLE_C_B_CL_V5_V6_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x5, 0x6, 0x1 }, // 5410
  { IMAGE_SAMPLE_C_B_CL_V5_V8_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 5411
  { IMAGE_SAMPLE_C_B_CL_V1_V3_nsa_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 5412
  { IMAGE_SAMPLE_C_B_CL_V1_V4_nsa_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 5413
  { IMAGE_SAMPLE_C_B_CL_V1_V5_nsa_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11NSA, 0x1, 0x5, 0x5 }, // 5414
  { IMAGE_SAMPLE_C_B_CL_V1_V6_nsa_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11NSA, 0x1, 0x6, 0x6 }, // 5415
  { IMAGE_SAMPLE_C_B_CL_V2_V3_nsa_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 5416
  { IMAGE_SAMPLE_C_B_CL_V2_V4_nsa_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 5417
  { IMAGE_SAMPLE_C_B_CL_V2_V5_nsa_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 5418
  { IMAGE_SAMPLE_C_B_CL_V2_V6_nsa_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11NSA, 0x2, 0x6, 0x6 }, // 5419
  { IMAGE_SAMPLE_C_B_CL_V3_V3_nsa_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 5420
  { IMAGE_SAMPLE_C_B_CL_V3_V4_nsa_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 5421
  { IMAGE_SAMPLE_C_B_CL_V3_V5_nsa_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11NSA, 0x3, 0x5, 0x5 }, // 5422
  { IMAGE_SAMPLE_C_B_CL_V3_V6_nsa_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11NSA, 0x3, 0x6, 0x6 }, // 5423
  { IMAGE_SAMPLE_C_B_CL_V4_V3_nsa_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 5424
  { IMAGE_SAMPLE_C_B_CL_V4_V4_nsa_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 5425
  { IMAGE_SAMPLE_C_B_CL_V4_V5_nsa_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 5426
  { IMAGE_SAMPLE_C_B_CL_V4_V6_nsa_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11NSA, 0x4, 0x6, 0x6 }, // 5427
  { IMAGE_SAMPLE_C_B_CL_V5_V3_nsa_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 5428
  { IMAGE_SAMPLE_C_B_CL_V5_V4_nsa_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 5429
  { IMAGE_SAMPLE_C_B_CL_V5_V5_nsa_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 5430
  { IMAGE_SAMPLE_C_B_CL_V5_V6_nsa_gfx11, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx11NSA, 0x5, 0x6, 0x6 }, // 5431
  { IMAGE_SAMPLE_C_B_CL_V1_V3_gfx12, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 5432
  { IMAGE_SAMPLE_C_B_CL_V1_V4_gfx12, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 5433
  { IMAGE_SAMPLE_C_B_CL_V1_V5_gfx12, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx12, 0x1, 0x5, 0x5 }, // 5434
  { IMAGE_SAMPLE_C_B_CL_V1_V6_gfx12, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx12, 0x1, 0x6, 0x6 }, // 5435
  { IMAGE_SAMPLE_C_B_CL_V2_V3_gfx12, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 5436
  { IMAGE_SAMPLE_C_B_CL_V2_V4_gfx12, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 5437
  { IMAGE_SAMPLE_C_B_CL_V2_V5_gfx12, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx12, 0x2, 0x5, 0x5 }, // 5438
  { IMAGE_SAMPLE_C_B_CL_V2_V6_gfx12, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx12, 0x2, 0x6, 0x6 }, // 5439
  { IMAGE_SAMPLE_C_B_CL_V3_V3_gfx12, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 5440
  { IMAGE_SAMPLE_C_B_CL_V3_V4_gfx12, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 5441
  { IMAGE_SAMPLE_C_B_CL_V3_V5_gfx12, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx12, 0x3, 0x5, 0x5 }, // 5442
  { IMAGE_SAMPLE_C_B_CL_V3_V6_gfx12, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx12, 0x3, 0x6, 0x6 }, // 5443
  { IMAGE_SAMPLE_C_B_CL_V4_V3_gfx12, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 5444
  { IMAGE_SAMPLE_C_B_CL_V4_V4_gfx12, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 5445
  { IMAGE_SAMPLE_C_B_CL_V4_V5_gfx12, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx12, 0x4, 0x5, 0x5 }, // 5446
  { IMAGE_SAMPLE_C_B_CL_V4_V6_gfx12, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx12, 0x4, 0x6, 0x6 }, // 5447
  { IMAGE_SAMPLE_C_B_CL_V5_V3_gfx12, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 5448
  { IMAGE_SAMPLE_C_B_CL_V5_V4_gfx12, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 5449
  { IMAGE_SAMPLE_C_B_CL_V5_V5_gfx12, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx12, 0x5, 0x5, 0x5 }, // 5450
  { IMAGE_SAMPLE_C_B_CL_V5_V6_gfx12, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx12, 0x5, 0x6, 0x6 }, // 5451
  { IMAGE_SAMPLE_C_B_CL_V1_V3, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 5452
  { IMAGE_SAMPLE_C_B_CL_V1_V4, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 5453
  { IMAGE_SAMPLE_C_B_CL_V1_V5, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 5454
  { IMAGE_SAMPLE_C_B_CL_V1_V6, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 5455
  { IMAGE_SAMPLE_C_B_CL_V1_V8, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 5456
  { IMAGE_SAMPLE_C_B_CL_V2_V3, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 5457
  { IMAGE_SAMPLE_C_B_CL_V2_V4, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 5458
  { IMAGE_SAMPLE_C_B_CL_V2_V5, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 5459
  { IMAGE_SAMPLE_C_B_CL_V2_V6, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 5460
  { IMAGE_SAMPLE_C_B_CL_V2_V8, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 5461
  { IMAGE_SAMPLE_C_B_CL_V3_V3, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 5462
  { IMAGE_SAMPLE_C_B_CL_V3_V4, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 5463
  { IMAGE_SAMPLE_C_B_CL_V3_V5, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 5464
  { IMAGE_SAMPLE_C_B_CL_V3_V6, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 5465
  { IMAGE_SAMPLE_C_B_CL_V3_V8, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 5466
  { IMAGE_SAMPLE_C_B_CL_V4_V3, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 5467
  { IMAGE_SAMPLE_C_B_CL_V4_V4, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 5468
  { IMAGE_SAMPLE_C_B_CL_V4_V5, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 5469
  { IMAGE_SAMPLE_C_B_CL_V4_V6, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 5470
  { IMAGE_SAMPLE_C_B_CL_V4_V8, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 5471
  { IMAGE_SAMPLE_C_B_CL_V5_V3, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 5472
  { IMAGE_SAMPLE_C_B_CL_V5_V4, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 5473
  { IMAGE_SAMPLE_C_B_CL_V5_V5, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 5474
  { IMAGE_SAMPLE_C_B_CL_V5_V6, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 5475
  { IMAGE_SAMPLE_C_B_CL_V5_V8, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 5476
  { IMAGE_SAMPLE_C_B_CL_O_V1_V4_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 5477
  { IMAGE_SAMPLE_C_B_CL_O_V1_V5_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 5478
  { IMAGE_SAMPLE_C_B_CL_O_V1_V6_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 5479
  { IMAGE_SAMPLE_C_B_CL_O_V1_V7_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x1, 0x7, 0x1 }, // 5480
  { IMAGE_SAMPLE_C_B_CL_O_V1_V8_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 5481
  { IMAGE_SAMPLE_C_B_CL_O_V2_V4_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 5482
  { IMAGE_SAMPLE_C_B_CL_O_V2_V5_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 5483
  { IMAGE_SAMPLE_C_B_CL_O_V2_V6_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 5484
  { IMAGE_SAMPLE_C_B_CL_O_V2_V7_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x2, 0x7, 0x1 }, // 5485
  { IMAGE_SAMPLE_C_B_CL_O_V2_V8_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 5486
  { IMAGE_SAMPLE_C_B_CL_O_V3_V4_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 5487
  { IMAGE_SAMPLE_C_B_CL_O_V3_V5_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 5488
  { IMAGE_SAMPLE_C_B_CL_O_V3_V6_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 5489
  { IMAGE_SAMPLE_C_B_CL_O_V3_V7_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x3, 0x7, 0x1 }, // 5490
  { IMAGE_SAMPLE_C_B_CL_O_V3_V8_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 5491
  { IMAGE_SAMPLE_C_B_CL_O_V4_V4_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 5492
  { IMAGE_SAMPLE_C_B_CL_O_V4_V5_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 5493
  { IMAGE_SAMPLE_C_B_CL_O_V4_V6_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 5494
  { IMAGE_SAMPLE_C_B_CL_O_V4_V7_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x4, 0x7, 0x1 }, // 5495
  { IMAGE_SAMPLE_C_B_CL_O_V4_V8_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 5496
  { IMAGE_SAMPLE_C_B_CL_O_V5_V4_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 5497
  { IMAGE_SAMPLE_C_B_CL_O_V5_V5_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 5498
  { IMAGE_SAMPLE_C_B_CL_O_V5_V6_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 5499
  { IMAGE_SAMPLE_C_B_CL_O_V5_V7_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x5, 0x7, 0x1 }, // 5500
  { IMAGE_SAMPLE_C_B_CL_O_V5_V8_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 5501
  { IMAGE_SAMPLE_C_B_CL_O_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 5502
  { IMAGE_SAMPLE_C_B_CL_O_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 5503
  { IMAGE_SAMPLE_C_B_CL_O_V1_V6_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 5504
  { IMAGE_SAMPLE_C_B_CL_O_V1_V7_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x1, 0x7, 0x7 }, // 5505
  { IMAGE_SAMPLE_C_B_CL_O_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 5506
  { IMAGE_SAMPLE_C_B_CL_O_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 5507
  { IMAGE_SAMPLE_C_B_CL_O_V2_V6_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 5508
  { IMAGE_SAMPLE_C_B_CL_O_V2_V7_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x7, 0x7 }, // 5509
  { IMAGE_SAMPLE_C_B_CL_O_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 5510
  { IMAGE_SAMPLE_C_B_CL_O_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 5511
  { IMAGE_SAMPLE_C_B_CL_O_V3_V6_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 5512
  { IMAGE_SAMPLE_C_B_CL_O_V3_V7_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x3, 0x7, 0x7 }, // 5513
  { IMAGE_SAMPLE_C_B_CL_O_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 5514
  { IMAGE_SAMPLE_C_B_CL_O_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 5515
  { IMAGE_SAMPLE_C_B_CL_O_V4_V6_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 5516
  { IMAGE_SAMPLE_C_B_CL_O_V4_V7_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x7, 0x7 }, // 5517
  { IMAGE_SAMPLE_C_B_CL_O_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 5518
  { IMAGE_SAMPLE_C_B_CL_O_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 5519
  { IMAGE_SAMPLE_C_B_CL_O_V5_V6_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 5520
  { IMAGE_SAMPLE_C_B_CL_O_V5_V7_nsa_gfx10, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x7, 0x7 }, // 5521
  { IMAGE_SAMPLE_C_B_CL_O_V1_V4_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 5522
  { IMAGE_SAMPLE_C_B_CL_O_V1_V5_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x1, 0x5, 0x1 }, // 5523
  { IMAGE_SAMPLE_C_B_CL_O_V1_V6_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x1, 0x6, 0x1 }, // 5524
  { IMAGE_SAMPLE_C_B_CL_O_V1_V7_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x1, 0x7, 0x1 }, // 5525
  { IMAGE_SAMPLE_C_B_CL_O_V1_V8_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x1, 0x8, 0x1 }, // 5526
  { IMAGE_SAMPLE_C_B_CL_O_V2_V4_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 5527
  { IMAGE_SAMPLE_C_B_CL_O_V2_V5_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 5528
  { IMAGE_SAMPLE_C_B_CL_O_V2_V6_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x2, 0x6, 0x1 }, // 5529
  { IMAGE_SAMPLE_C_B_CL_O_V2_V7_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x2, 0x7, 0x1 }, // 5530
  { IMAGE_SAMPLE_C_B_CL_O_V2_V8_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 5531
  { IMAGE_SAMPLE_C_B_CL_O_V3_V4_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 5532
  { IMAGE_SAMPLE_C_B_CL_O_V3_V5_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x3, 0x5, 0x1 }, // 5533
  { IMAGE_SAMPLE_C_B_CL_O_V3_V6_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x3, 0x6, 0x1 }, // 5534
  { IMAGE_SAMPLE_C_B_CL_O_V3_V7_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x3, 0x7, 0x1 }, // 5535
  { IMAGE_SAMPLE_C_B_CL_O_V3_V8_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x3, 0x8, 0x1 }, // 5536
  { IMAGE_SAMPLE_C_B_CL_O_V4_V4_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 5537
  { IMAGE_SAMPLE_C_B_CL_O_V4_V5_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 5538
  { IMAGE_SAMPLE_C_B_CL_O_V4_V6_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x4, 0x6, 0x1 }, // 5539
  { IMAGE_SAMPLE_C_B_CL_O_V4_V7_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x4, 0x7, 0x1 }, // 5540
  { IMAGE_SAMPLE_C_B_CL_O_V4_V8_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 5541
  { IMAGE_SAMPLE_C_B_CL_O_V5_V4_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 5542
  { IMAGE_SAMPLE_C_B_CL_O_V5_V5_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 5543
  { IMAGE_SAMPLE_C_B_CL_O_V5_V6_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x5, 0x6, 0x1 }, // 5544
  { IMAGE_SAMPLE_C_B_CL_O_V5_V7_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x5, 0x7, 0x1 }, // 5545
  { IMAGE_SAMPLE_C_B_CL_O_V5_V8_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 5546
  { IMAGE_SAMPLE_C_B_CL_O_V1_V4_nsa_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 5547
  { IMAGE_SAMPLE_C_B_CL_O_V1_V5_nsa_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11NSA, 0x1, 0x5, 0x5 }, // 5548
  { IMAGE_SAMPLE_C_B_CL_O_V1_V6_nsa_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11NSA, 0x1, 0x6, 0x6 }, // 5549
  { IMAGE_SAMPLE_C_B_CL_O_V1_V7_nsa_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11NSA, 0x1, 0x7, 0x7 }, // 5550
  { IMAGE_SAMPLE_C_B_CL_O_V2_V4_nsa_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 5551
  { IMAGE_SAMPLE_C_B_CL_O_V2_V5_nsa_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 5552
  { IMAGE_SAMPLE_C_B_CL_O_V2_V6_nsa_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11NSA, 0x2, 0x6, 0x6 }, // 5553
  { IMAGE_SAMPLE_C_B_CL_O_V2_V7_nsa_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11NSA, 0x2, 0x7, 0x7 }, // 5554
  { IMAGE_SAMPLE_C_B_CL_O_V3_V4_nsa_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 5555
  { IMAGE_SAMPLE_C_B_CL_O_V3_V5_nsa_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11NSA, 0x3, 0x5, 0x5 }, // 5556
  { IMAGE_SAMPLE_C_B_CL_O_V3_V6_nsa_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11NSA, 0x3, 0x6, 0x6 }, // 5557
  { IMAGE_SAMPLE_C_B_CL_O_V3_V7_nsa_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11NSA, 0x3, 0x7, 0x7 }, // 5558
  { IMAGE_SAMPLE_C_B_CL_O_V4_V4_nsa_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 5559
  { IMAGE_SAMPLE_C_B_CL_O_V4_V5_nsa_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 5560
  { IMAGE_SAMPLE_C_B_CL_O_V4_V6_nsa_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11NSA, 0x4, 0x6, 0x6 }, // 5561
  { IMAGE_SAMPLE_C_B_CL_O_V4_V7_nsa_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11NSA, 0x4, 0x7, 0x7 }, // 5562
  { IMAGE_SAMPLE_C_B_CL_O_V5_V4_nsa_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 5563
  { IMAGE_SAMPLE_C_B_CL_O_V5_V5_nsa_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 5564
  { IMAGE_SAMPLE_C_B_CL_O_V5_V6_nsa_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11NSA, 0x5, 0x6, 0x6 }, // 5565
  { IMAGE_SAMPLE_C_B_CL_O_V5_V7_nsa_gfx11, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx11NSA, 0x5, 0x7, 0x7 }, // 5566
  { IMAGE_SAMPLE_C_B_CL_O_V1_V4_gfx12, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 5567
  { IMAGE_SAMPLE_C_B_CL_O_V1_V5_gfx12, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx12, 0x1, 0x5, 0x5 }, // 5568
  { IMAGE_SAMPLE_C_B_CL_O_V1_V6_gfx12, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx12, 0x1, 0x6, 0x6 }, // 5569
  { IMAGE_SAMPLE_C_B_CL_O_V1_V7_gfx12, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx12, 0x1, 0x7, 0x7 }, // 5570
  { IMAGE_SAMPLE_C_B_CL_O_V2_V4_gfx12, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 5571
  { IMAGE_SAMPLE_C_B_CL_O_V2_V5_gfx12, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx12, 0x2, 0x5, 0x5 }, // 5572
  { IMAGE_SAMPLE_C_B_CL_O_V2_V6_gfx12, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx12, 0x2, 0x6, 0x6 }, // 5573
  { IMAGE_SAMPLE_C_B_CL_O_V2_V7_gfx12, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx12, 0x2, 0x7, 0x7 }, // 5574
  { IMAGE_SAMPLE_C_B_CL_O_V3_V4_gfx12, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 5575
  { IMAGE_SAMPLE_C_B_CL_O_V3_V5_gfx12, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx12, 0x3, 0x5, 0x5 }, // 5576
  { IMAGE_SAMPLE_C_B_CL_O_V3_V6_gfx12, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx12, 0x3, 0x6, 0x6 }, // 5577
  { IMAGE_SAMPLE_C_B_CL_O_V3_V7_gfx12, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx12, 0x3, 0x7, 0x7 }, // 5578
  { IMAGE_SAMPLE_C_B_CL_O_V4_V4_gfx12, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 5579
  { IMAGE_SAMPLE_C_B_CL_O_V4_V5_gfx12, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx12, 0x4, 0x5, 0x5 }, // 5580
  { IMAGE_SAMPLE_C_B_CL_O_V4_V6_gfx12, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx12, 0x4, 0x6, 0x6 }, // 5581
  { IMAGE_SAMPLE_C_B_CL_O_V4_V7_gfx12, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx12, 0x4, 0x7, 0x7 }, // 5582
  { IMAGE_SAMPLE_C_B_CL_O_V5_V4_gfx12, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 5583
  { IMAGE_SAMPLE_C_B_CL_O_V5_V5_gfx12, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx12, 0x5, 0x5, 0x5 }, // 5584
  { IMAGE_SAMPLE_C_B_CL_O_V5_V6_gfx12, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx12, 0x5, 0x6, 0x6 }, // 5585
  { IMAGE_SAMPLE_C_B_CL_O_V5_V7_gfx12, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx12, 0x5, 0x7, 0x7 }, // 5586
  { IMAGE_SAMPLE_C_B_CL_O_V1_V4, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 5587
  { IMAGE_SAMPLE_C_B_CL_O_V1_V5, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 5588
  { IMAGE_SAMPLE_C_B_CL_O_V1_V6, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 5589
  { IMAGE_SAMPLE_C_B_CL_O_V1_V7, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x1, 0x7, 0x1 }, // 5590
  { IMAGE_SAMPLE_C_B_CL_O_V1_V8, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 5591
  { IMAGE_SAMPLE_C_B_CL_O_V2_V4, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 5592
  { IMAGE_SAMPLE_C_B_CL_O_V2_V5, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 5593
  { IMAGE_SAMPLE_C_B_CL_O_V2_V6, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 5594
  { IMAGE_SAMPLE_C_B_CL_O_V2_V7, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x2, 0x7, 0x1 }, // 5595
  { IMAGE_SAMPLE_C_B_CL_O_V2_V8, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 5596
  { IMAGE_SAMPLE_C_B_CL_O_V3_V4, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 5597
  { IMAGE_SAMPLE_C_B_CL_O_V3_V5, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 5598
  { IMAGE_SAMPLE_C_B_CL_O_V3_V6, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 5599
  { IMAGE_SAMPLE_C_B_CL_O_V3_V7, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x3, 0x7, 0x1 }, // 5600
  { IMAGE_SAMPLE_C_B_CL_O_V3_V8, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 5601
  { IMAGE_SAMPLE_C_B_CL_O_V4_V4, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 5602
  { IMAGE_SAMPLE_C_B_CL_O_V4_V5, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 5603
  { IMAGE_SAMPLE_C_B_CL_O_V4_V6, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 5604
  { IMAGE_SAMPLE_C_B_CL_O_V4_V7, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x4, 0x7, 0x1 }, // 5605
  { IMAGE_SAMPLE_C_B_CL_O_V4_V8, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 5606
  { IMAGE_SAMPLE_C_B_CL_O_V5_V4, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 5607
  { IMAGE_SAMPLE_C_B_CL_O_V5_V5, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 5608
  { IMAGE_SAMPLE_C_B_CL_O_V5_V6, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 5609
  { IMAGE_SAMPLE_C_B_CL_O_V5_V7, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x5, 0x7, 0x1 }, // 5610
  { IMAGE_SAMPLE_C_B_CL_O_V5_V8, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 5611
  { IMAGE_SAMPLE_C_B_O_V1_V4_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 5612
  { IMAGE_SAMPLE_C_B_O_V1_V5_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 5613
  { IMAGE_SAMPLE_C_B_O_V1_V6_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 5614
  { IMAGE_SAMPLE_C_B_O_V1_V8_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 5615
  { IMAGE_SAMPLE_C_B_O_V2_V4_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 5616
  { IMAGE_SAMPLE_C_B_O_V2_V5_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 5617
  { IMAGE_SAMPLE_C_B_O_V2_V6_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 5618
  { IMAGE_SAMPLE_C_B_O_V2_V8_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 5619
  { IMAGE_SAMPLE_C_B_O_V3_V4_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 5620
  { IMAGE_SAMPLE_C_B_O_V3_V5_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 5621
  { IMAGE_SAMPLE_C_B_O_V3_V6_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 5622
  { IMAGE_SAMPLE_C_B_O_V3_V8_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 5623
  { IMAGE_SAMPLE_C_B_O_V4_V4_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 5624
  { IMAGE_SAMPLE_C_B_O_V4_V5_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 5625
  { IMAGE_SAMPLE_C_B_O_V4_V6_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 5626
  { IMAGE_SAMPLE_C_B_O_V4_V8_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 5627
  { IMAGE_SAMPLE_C_B_O_V5_V4_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 5628
  { IMAGE_SAMPLE_C_B_O_V5_V5_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 5629
  { IMAGE_SAMPLE_C_B_O_V5_V6_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 5630
  { IMAGE_SAMPLE_C_B_O_V5_V8_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 5631
  { IMAGE_SAMPLE_C_B_O_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 5632
  { IMAGE_SAMPLE_C_B_O_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 5633
  { IMAGE_SAMPLE_C_B_O_V1_V6_nsa_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 5634
  { IMAGE_SAMPLE_C_B_O_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 5635
  { IMAGE_SAMPLE_C_B_O_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 5636
  { IMAGE_SAMPLE_C_B_O_V2_V6_nsa_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 5637
  { IMAGE_SAMPLE_C_B_O_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 5638
  { IMAGE_SAMPLE_C_B_O_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 5639
  { IMAGE_SAMPLE_C_B_O_V3_V6_nsa_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 5640
  { IMAGE_SAMPLE_C_B_O_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 5641
  { IMAGE_SAMPLE_C_B_O_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 5642
  { IMAGE_SAMPLE_C_B_O_V4_V6_nsa_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 5643
  { IMAGE_SAMPLE_C_B_O_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 5644
  { IMAGE_SAMPLE_C_B_O_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 5645
  { IMAGE_SAMPLE_C_B_O_V5_V6_nsa_gfx10, IMAGE_SAMPLE_C_B_O, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 5646
  { IMAGE_SAMPLE_C_B_O_V1_V4_gfx11, IMAGE_SAMPLE_C_B_O, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 5647
  { IMAGE_SAMPLE_C_B_O_V1_V5_gfx11, IMAGE_SAMPLE_C_B_O, MIMGEncGfx11Default, 0x1, 0x5, 0x1 }, // 5648
  { IMAGE_SAMPLE_C_B_O_V1_V6_gfx11, IMAGE_SAMPLE_C_B_O, MIMGEncGfx11Default, 0x1, 0x6, 0x1 }, // 5649
  { IMAGE_SAMPLE_C_B_O_V1_V8_gfx11, IMAGE_SAMPLE_C_B_O, MIMGEncGfx11Default, 0x1, 0x8, 0x1 }, // 5650
  { IMAGE_SAMPLE_C_B_O_V2_V4_gfx11, IMAGE_SAMPLE_C_B_O, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 5651
  { IMAGE_SAMPLE_C_B_O_V2_V5_gfx11, IMAGE_SAMPLE_C_B_O, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 5652
  { IMAGE_SAMPLE_C_B_O_V2_V6_gfx11, IMAGE_SAMPLE_C_B_O, MIMGEncGfx11Default, 0x2, 0x6, 0x1 }, // 5653
  { IMAGE_SAMPLE_C_B_O_V2_V8_gfx11, IMAGE_SAMPLE_C_B_O, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 5654
  { IMAGE_SAMPLE_C_B_O_V3_V4_gfx11, IMAGE_SAMPLE_C_B_O, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 5655
  { IMAGE_SAMPLE_C_B_O_V3_V5_gfx11, IMAGE_SAMPLE_C_B_O, MIMGEncGfx11Default, 0x3, 0x5, 0x1 }, // 5656
  { IMAGE_SAMPLE_C_B_O_V3_V6_gfx11, IMAGE_SAMPLE_C_B_O, MIMGEncGfx11Default, 0x3, 0x6, 0x1 }, // 5657
  { IMAGE_SAMPLE_C_B_O_V3_V8_gfx11, IMAGE_SAMPLE_C_B_O, MIMGEncGfx11Default, 0x3, 0x8, 0x1 }, // 5658
  { IMAGE_SAMPLE_C_B_O_V4_V4_gfx11, IMAGE_SAMPLE_C_B_O, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 5659
  { IMAGE_SAMPLE_C_B_O_V4_V5_gfx11, IMAGE_SAMPLE_C_B_O, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 5660
  { IMAGE_SAMPLE_C_B_O_V4_V6_gfx11, IMAGE_SAMPLE_C_B_O, MIMGEncGfx11Default, 0x4, 0x6, 0x1 }, // 5661
  { IMAGE_SAMPLE_C_B_O_V4_V8_gfx11, IMAGE_SAMPLE_C_B_O, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 5662
  { IMAGE_SAMPLE_C_B_O_V5_V4_gfx11, IMAGE_SAMPLE_C_B_O, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 5663
  { IMAGE_SAMPLE_C_B_O_V5_V5_gfx11, IMAGE_SAMPLE_C_B_O, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 5664
  { IMAGE_SAMPLE_C_B_O_V5_V6_gfx11, IMAGE_SAMPLE_C_B_O, MIMGEncGfx11Default, 0x5, 0x6, 0x1 }, // 5665
  { IMAGE_SAMPLE_C_B_O_V5_V8_gfx11, IMAGE_SAMPLE_C_B_O, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 5666
  { IMAGE_SAMPLE_C_B_O_V1_V4_nsa_gfx11, IMAGE_SAMPLE_C_B_O, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 5667
  { IMAGE_SAMPLE_C_B_O_V1_V5_nsa_gfx11, IMAGE_SAMPLE_C_B_O, MIMGEncGfx11NSA, 0x1, 0x5, 0x5 }, // 5668
  { IMAGE_SAMPLE_C_B_O_V1_V6_nsa_gfx11, IMAGE_SAMPLE_C_B_O, MIMGEncGfx11NSA, 0x1, 0x6, 0x6 }, // 5669
  { IMAGE_SAMPLE_C_B_O_V2_V4_nsa_gfx11, IMAGE_SAMPLE_C_B_O, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 5670
  { IMAGE_SAMPLE_C_B_O_V2_V5_nsa_gfx11, IMAGE_SAMPLE_C_B_O, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 5671
  { IMAGE_SAMPLE_C_B_O_V2_V6_nsa_gfx11, IMAGE_SAMPLE_C_B_O, MIMGEncGfx11NSA, 0x2, 0x6, 0x6 }, // 5672
  { IMAGE_SAMPLE_C_B_O_V3_V4_nsa_gfx11, IMAGE_SAMPLE_C_B_O, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 5673
  { IMAGE_SAMPLE_C_B_O_V3_V5_nsa_gfx11, IMAGE_SAMPLE_C_B_O, MIMGEncGfx11NSA, 0x3, 0x5, 0x5 }, // 5674
  { IMAGE_SAMPLE_C_B_O_V3_V6_nsa_gfx11, IMAGE_SAMPLE_C_B_O, MIMGEncGfx11NSA, 0x3, 0x6, 0x6 }, // 5675
  { IMAGE_SAMPLE_C_B_O_V4_V4_nsa_gfx11, IMAGE_SAMPLE_C_B_O, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 5676
  { IMAGE_SAMPLE_C_B_O_V4_V5_nsa_gfx11, IMAGE_SAMPLE_C_B_O, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 5677
  { IMAGE_SAMPLE_C_B_O_V4_V6_nsa_gfx11, IMAGE_SAMPLE_C_B_O, MIMGEncGfx11NSA, 0x4, 0x6, 0x6 }, // 5678
  { IMAGE_SAMPLE_C_B_O_V5_V4_nsa_gfx11, IMAGE_SAMPLE_C_B_O, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 5679
  { IMAGE_SAMPLE_C_B_O_V5_V5_nsa_gfx11, IMAGE_SAMPLE_C_B_O, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 5680
  { IMAGE_SAMPLE_C_B_O_V5_V6_nsa_gfx11, IMAGE_SAMPLE_C_B_O, MIMGEncGfx11NSA, 0x5, 0x6, 0x6 }, // 5681
  { IMAGE_SAMPLE_C_B_O_V1_V4_gfx12, IMAGE_SAMPLE_C_B_O, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 5682
  { IMAGE_SAMPLE_C_B_O_V1_V5_gfx12, IMAGE_SAMPLE_C_B_O, MIMGEncGfx12, 0x1, 0x5, 0x5 }, // 5683
  { IMAGE_SAMPLE_C_B_O_V1_V6_gfx12, IMAGE_SAMPLE_C_B_O, MIMGEncGfx12, 0x1, 0x6, 0x6 }, // 5684
  { IMAGE_SAMPLE_C_B_O_V2_V4_gfx12, IMAGE_SAMPLE_C_B_O, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 5685
  { IMAGE_SAMPLE_C_B_O_V2_V5_gfx12, IMAGE_SAMPLE_C_B_O, MIMGEncGfx12, 0x2, 0x5, 0x5 }, // 5686
  { IMAGE_SAMPLE_C_B_O_V2_V6_gfx12, IMAGE_SAMPLE_C_B_O, MIMGEncGfx12, 0x2, 0x6, 0x6 }, // 5687
  { IMAGE_SAMPLE_C_B_O_V3_V4_gfx12, IMAGE_SAMPLE_C_B_O, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 5688
  { IMAGE_SAMPLE_C_B_O_V3_V5_gfx12, IMAGE_SAMPLE_C_B_O, MIMGEncGfx12, 0x3, 0x5, 0x5 }, // 5689
  { IMAGE_SAMPLE_C_B_O_V3_V6_gfx12, IMAGE_SAMPLE_C_B_O, MIMGEncGfx12, 0x3, 0x6, 0x6 }, // 5690
  { IMAGE_SAMPLE_C_B_O_V4_V4_gfx12, IMAGE_SAMPLE_C_B_O, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 5691
  { IMAGE_SAMPLE_C_B_O_V4_V5_gfx12, IMAGE_SAMPLE_C_B_O, MIMGEncGfx12, 0x4, 0x5, 0x5 }, // 5692
  { IMAGE_SAMPLE_C_B_O_V4_V6_gfx12, IMAGE_SAMPLE_C_B_O, MIMGEncGfx12, 0x4, 0x6, 0x6 }, // 5693
  { IMAGE_SAMPLE_C_B_O_V5_V4_gfx12, IMAGE_SAMPLE_C_B_O, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 5694
  { IMAGE_SAMPLE_C_B_O_V5_V5_gfx12, IMAGE_SAMPLE_C_B_O, MIMGEncGfx12, 0x5, 0x5, 0x5 }, // 5695
  { IMAGE_SAMPLE_C_B_O_V5_V6_gfx12, IMAGE_SAMPLE_C_B_O, MIMGEncGfx12, 0x5, 0x6, 0x6 }, // 5696
  { IMAGE_SAMPLE_C_B_O_V1_V4, IMAGE_SAMPLE_C_B_O, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 5697
  { IMAGE_SAMPLE_C_B_O_V1_V5, IMAGE_SAMPLE_C_B_O, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 5698
  { IMAGE_SAMPLE_C_B_O_V1_V6, IMAGE_SAMPLE_C_B_O, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 5699
  { IMAGE_SAMPLE_C_B_O_V1_V8, IMAGE_SAMPLE_C_B_O, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 5700
  { IMAGE_SAMPLE_C_B_O_V2_V4, IMAGE_SAMPLE_C_B_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 5701
  { IMAGE_SAMPLE_C_B_O_V2_V5, IMAGE_SAMPLE_C_B_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 5702
  { IMAGE_SAMPLE_C_B_O_V2_V6, IMAGE_SAMPLE_C_B_O, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 5703
  { IMAGE_SAMPLE_C_B_O_V2_V8, IMAGE_SAMPLE_C_B_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 5704
  { IMAGE_SAMPLE_C_B_O_V3_V4, IMAGE_SAMPLE_C_B_O, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 5705
  { IMAGE_SAMPLE_C_B_O_V3_V5, IMAGE_SAMPLE_C_B_O, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 5706
  { IMAGE_SAMPLE_C_B_O_V3_V6, IMAGE_SAMPLE_C_B_O, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 5707
  { IMAGE_SAMPLE_C_B_O_V3_V8, IMAGE_SAMPLE_C_B_O, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 5708
  { IMAGE_SAMPLE_C_B_O_V4_V4, IMAGE_SAMPLE_C_B_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 5709
  { IMAGE_SAMPLE_C_B_O_V4_V5, IMAGE_SAMPLE_C_B_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 5710
  { IMAGE_SAMPLE_C_B_O_V4_V6, IMAGE_SAMPLE_C_B_O, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 5711
  { IMAGE_SAMPLE_C_B_O_V4_V8, IMAGE_SAMPLE_C_B_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 5712
  { IMAGE_SAMPLE_C_B_O_V5_V4, IMAGE_SAMPLE_C_B_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 5713
  { IMAGE_SAMPLE_C_B_O_V5_V5, IMAGE_SAMPLE_C_B_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 5714
  { IMAGE_SAMPLE_C_B_O_V5_V6, IMAGE_SAMPLE_C_B_O, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 5715
  { IMAGE_SAMPLE_C_B_O_V5_V8, IMAGE_SAMPLE_C_B_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 5716
  { IMAGE_SAMPLE_C_CD_V1_V3_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 5717
  { IMAGE_SAMPLE_C_CD_V1_V4_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 5718
  { IMAGE_SAMPLE_C_CD_V1_V5_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 5719
  { IMAGE_SAMPLE_C_CD_V1_V6_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 5720
  { IMAGE_SAMPLE_C_CD_V1_V7_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x1, 0x7, 0x1 }, // 5721
  { IMAGE_SAMPLE_C_CD_V1_V8_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 5722
  { IMAGE_SAMPLE_C_CD_V1_V9_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x1, 0x9, 0x1 }, // 5723
  { IMAGE_SAMPLE_C_CD_V1_V10_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x1, 0xA, 0x1 }, // 5724
  { IMAGE_SAMPLE_C_CD_V2_V3_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 5725
  { IMAGE_SAMPLE_C_CD_V2_V4_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 5726
  { IMAGE_SAMPLE_C_CD_V2_V5_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 5727
  { IMAGE_SAMPLE_C_CD_V2_V6_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 5728
  { IMAGE_SAMPLE_C_CD_V2_V7_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x2, 0x7, 0x1 }, // 5729
  { IMAGE_SAMPLE_C_CD_V2_V8_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 5730
  { IMAGE_SAMPLE_C_CD_V2_V9_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x2, 0x9, 0x1 }, // 5731
  { IMAGE_SAMPLE_C_CD_V2_V10_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x2, 0xA, 0x1 }, // 5732
  { IMAGE_SAMPLE_C_CD_V3_V3_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 5733
  { IMAGE_SAMPLE_C_CD_V3_V4_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 5734
  { IMAGE_SAMPLE_C_CD_V3_V5_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 5735
  { IMAGE_SAMPLE_C_CD_V3_V6_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 5736
  { IMAGE_SAMPLE_C_CD_V3_V7_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x3, 0x7, 0x1 }, // 5737
  { IMAGE_SAMPLE_C_CD_V3_V8_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 5738
  { IMAGE_SAMPLE_C_CD_V3_V9_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x3, 0x9, 0x1 }, // 5739
  { IMAGE_SAMPLE_C_CD_V3_V10_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x3, 0xA, 0x1 }, // 5740
  { IMAGE_SAMPLE_C_CD_V4_V3_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 5741
  { IMAGE_SAMPLE_C_CD_V4_V4_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 5742
  { IMAGE_SAMPLE_C_CD_V4_V5_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 5743
  { IMAGE_SAMPLE_C_CD_V4_V6_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 5744
  { IMAGE_SAMPLE_C_CD_V4_V7_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x4, 0x7, 0x1 }, // 5745
  { IMAGE_SAMPLE_C_CD_V4_V8_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 5746
  { IMAGE_SAMPLE_C_CD_V4_V9_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x4, 0x9, 0x1 }, // 5747
  { IMAGE_SAMPLE_C_CD_V4_V10_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x4, 0xA, 0x1 }, // 5748
  { IMAGE_SAMPLE_C_CD_V5_V3_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 5749
  { IMAGE_SAMPLE_C_CD_V5_V4_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 5750
  { IMAGE_SAMPLE_C_CD_V5_V5_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 5751
  { IMAGE_SAMPLE_C_CD_V5_V6_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 5752
  { IMAGE_SAMPLE_C_CD_V5_V7_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x5, 0x7, 0x1 }, // 5753
  { IMAGE_SAMPLE_C_CD_V5_V8_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 5754
  { IMAGE_SAMPLE_C_CD_V5_V9_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x5, 0x9, 0x1 }, // 5755
  { IMAGE_SAMPLE_C_CD_V5_V10_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10Default, 0x5, 0xA, 0x1 }, // 5756
  { IMAGE_SAMPLE_C_CD_V1_V3_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 5757
  { IMAGE_SAMPLE_C_CD_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 5758
  { IMAGE_SAMPLE_C_CD_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 5759
  { IMAGE_SAMPLE_C_CD_V1_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 5760
  { IMAGE_SAMPLE_C_CD_V1_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x1, 0x7, 0x7 }, // 5761
  { IMAGE_SAMPLE_C_CD_V1_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x1, 0x8, 0x8 }, // 5762
  { IMAGE_SAMPLE_C_CD_V1_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x1, 0x9, 0x9 }, // 5763
  { IMAGE_SAMPLE_C_CD_V1_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x1, 0xA, 0xA }, // 5764
  { IMAGE_SAMPLE_C_CD_V2_V3_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 5765
  { IMAGE_SAMPLE_C_CD_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 5766
  { IMAGE_SAMPLE_C_CD_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 5767
  { IMAGE_SAMPLE_C_CD_V2_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 5768
  { IMAGE_SAMPLE_C_CD_V2_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x2, 0x7, 0x7 }, // 5769
  { IMAGE_SAMPLE_C_CD_V2_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x2, 0x8, 0x8 }, // 5770
  { IMAGE_SAMPLE_C_CD_V2_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x2, 0x9, 0x9 }, // 5771
  { IMAGE_SAMPLE_C_CD_V2_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x2, 0xA, 0xA }, // 5772
  { IMAGE_SAMPLE_C_CD_V3_V3_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 5773
  { IMAGE_SAMPLE_C_CD_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 5774
  { IMAGE_SAMPLE_C_CD_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 5775
  { IMAGE_SAMPLE_C_CD_V3_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 5776
  { IMAGE_SAMPLE_C_CD_V3_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x3, 0x7, 0x7 }, // 5777
  { IMAGE_SAMPLE_C_CD_V3_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x3, 0x8, 0x8 }, // 5778
  { IMAGE_SAMPLE_C_CD_V3_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x3, 0x9, 0x9 }, // 5779
  { IMAGE_SAMPLE_C_CD_V3_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x3, 0xA, 0xA }, // 5780
  { IMAGE_SAMPLE_C_CD_V4_V3_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 5781
  { IMAGE_SAMPLE_C_CD_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 5782
  { IMAGE_SAMPLE_C_CD_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 5783
  { IMAGE_SAMPLE_C_CD_V4_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 5784
  { IMAGE_SAMPLE_C_CD_V4_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x4, 0x7, 0x7 }, // 5785
  { IMAGE_SAMPLE_C_CD_V4_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x4, 0x8, 0x8 }, // 5786
  { IMAGE_SAMPLE_C_CD_V4_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x4, 0x9, 0x9 }, // 5787
  { IMAGE_SAMPLE_C_CD_V4_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x4, 0xA, 0xA }, // 5788
  { IMAGE_SAMPLE_C_CD_V5_V3_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 5789
  { IMAGE_SAMPLE_C_CD_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 5790
  { IMAGE_SAMPLE_C_CD_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 5791
  { IMAGE_SAMPLE_C_CD_V5_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 5792
  { IMAGE_SAMPLE_C_CD_V5_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x5, 0x7, 0x7 }, // 5793
  { IMAGE_SAMPLE_C_CD_V5_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x5, 0x8, 0x8 }, // 5794
  { IMAGE_SAMPLE_C_CD_V5_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x5, 0x9, 0x9 }, // 5795
  { IMAGE_SAMPLE_C_CD_V5_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD, MIMGEncGfx10NSA, 0x5, 0xA, 0xA }, // 5796
  { IMAGE_SAMPLE_C_CD_V1_V3, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 5797
  { IMAGE_SAMPLE_C_CD_V1_V4, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 5798
  { IMAGE_SAMPLE_C_CD_V1_V5, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 5799
  { IMAGE_SAMPLE_C_CD_V1_V6, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 5800
  { IMAGE_SAMPLE_C_CD_V1_V7, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x1, 0x7, 0x1 }, // 5801
  { IMAGE_SAMPLE_C_CD_V1_V8, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 5802
  { IMAGE_SAMPLE_C_CD_V1_V9, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x1, 0x9, 0x1 }, // 5803
  { IMAGE_SAMPLE_C_CD_V1_V10, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x1, 0xA, 0x1 }, // 5804
  { IMAGE_SAMPLE_C_CD_V2_V3, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 5805
  { IMAGE_SAMPLE_C_CD_V2_V4, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 5806
  { IMAGE_SAMPLE_C_CD_V2_V5, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 5807
  { IMAGE_SAMPLE_C_CD_V2_V6, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 5808
  { IMAGE_SAMPLE_C_CD_V2_V7, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x2, 0x7, 0x1 }, // 5809
  { IMAGE_SAMPLE_C_CD_V2_V8, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 5810
  { IMAGE_SAMPLE_C_CD_V2_V9, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x2, 0x9, 0x1 }, // 5811
  { IMAGE_SAMPLE_C_CD_V2_V10, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x2, 0xA, 0x1 }, // 5812
  { IMAGE_SAMPLE_C_CD_V3_V3, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 5813
  { IMAGE_SAMPLE_C_CD_V3_V4, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 5814
  { IMAGE_SAMPLE_C_CD_V3_V5, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 5815
  { IMAGE_SAMPLE_C_CD_V3_V6, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 5816
  { IMAGE_SAMPLE_C_CD_V3_V7, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x3, 0x7, 0x1 }, // 5817
  { IMAGE_SAMPLE_C_CD_V3_V8, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 5818
  { IMAGE_SAMPLE_C_CD_V3_V9, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x3, 0x9, 0x1 }, // 5819
  { IMAGE_SAMPLE_C_CD_V3_V10, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x3, 0xA, 0x1 }, // 5820
  { IMAGE_SAMPLE_C_CD_V4_V3, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 5821
  { IMAGE_SAMPLE_C_CD_V4_V4, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 5822
  { IMAGE_SAMPLE_C_CD_V4_V5, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 5823
  { IMAGE_SAMPLE_C_CD_V4_V6, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 5824
  { IMAGE_SAMPLE_C_CD_V4_V7, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x4, 0x7, 0x1 }, // 5825
  { IMAGE_SAMPLE_C_CD_V4_V8, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 5826
  { IMAGE_SAMPLE_C_CD_V4_V9, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x4, 0x9, 0x1 }, // 5827
  { IMAGE_SAMPLE_C_CD_V4_V10, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x4, 0xA, 0x1 }, // 5828
  { IMAGE_SAMPLE_C_CD_V5_V3, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 5829
  { IMAGE_SAMPLE_C_CD_V5_V4, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 5830
  { IMAGE_SAMPLE_C_CD_V5_V5, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 5831
  { IMAGE_SAMPLE_C_CD_V5_V6, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 5832
  { IMAGE_SAMPLE_C_CD_V5_V7, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x5, 0x7, 0x1 }, // 5833
  { IMAGE_SAMPLE_C_CD_V5_V8, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 5834
  { IMAGE_SAMPLE_C_CD_V5_V9, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x5, 0x9, 0x1 }, // 5835
  { IMAGE_SAMPLE_C_CD_V5_V10, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x5, 0xA, 0x1 }, // 5836
  { IMAGE_SAMPLE_C_CD_CL_V1_V3_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 5837
  { IMAGE_SAMPLE_C_CD_CL_V1_V4_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 5838
  { IMAGE_SAMPLE_C_CD_CL_V1_V5_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 5839
  { IMAGE_SAMPLE_C_CD_CL_V1_V6_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 5840
  { IMAGE_SAMPLE_C_CD_CL_V1_V7_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x1, 0x7, 0x1 }, // 5841
  { IMAGE_SAMPLE_C_CD_CL_V1_V8_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 5842
  { IMAGE_SAMPLE_C_CD_CL_V1_V9_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x1, 0x9, 0x1 }, // 5843
  { IMAGE_SAMPLE_C_CD_CL_V1_V10_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x1, 0xA, 0x1 }, // 5844
  { IMAGE_SAMPLE_C_CD_CL_V1_V11_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x1, 0xB, 0x1 }, // 5845
  { IMAGE_SAMPLE_C_CD_CL_V2_V3_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 5846
  { IMAGE_SAMPLE_C_CD_CL_V2_V4_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 5847
  { IMAGE_SAMPLE_C_CD_CL_V2_V5_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 5848
  { IMAGE_SAMPLE_C_CD_CL_V2_V6_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 5849
  { IMAGE_SAMPLE_C_CD_CL_V2_V7_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x2, 0x7, 0x1 }, // 5850
  { IMAGE_SAMPLE_C_CD_CL_V2_V8_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 5851
  { IMAGE_SAMPLE_C_CD_CL_V2_V9_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x2, 0x9, 0x1 }, // 5852
  { IMAGE_SAMPLE_C_CD_CL_V2_V10_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x2, 0xA, 0x1 }, // 5853
  { IMAGE_SAMPLE_C_CD_CL_V2_V11_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x2, 0xB, 0x1 }, // 5854
  { IMAGE_SAMPLE_C_CD_CL_V3_V3_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 5855
  { IMAGE_SAMPLE_C_CD_CL_V3_V4_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 5856
  { IMAGE_SAMPLE_C_CD_CL_V3_V5_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 5857
  { IMAGE_SAMPLE_C_CD_CL_V3_V6_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 5858
  { IMAGE_SAMPLE_C_CD_CL_V3_V7_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x3, 0x7, 0x1 }, // 5859
  { IMAGE_SAMPLE_C_CD_CL_V3_V8_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 5860
  { IMAGE_SAMPLE_C_CD_CL_V3_V9_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x3, 0x9, 0x1 }, // 5861
  { IMAGE_SAMPLE_C_CD_CL_V3_V10_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x3, 0xA, 0x1 }, // 5862
  { IMAGE_SAMPLE_C_CD_CL_V3_V11_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x3, 0xB, 0x1 }, // 5863
  { IMAGE_SAMPLE_C_CD_CL_V4_V3_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 5864
  { IMAGE_SAMPLE_C_CD_CL_V4_V4_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 5865
  { IMAGE_SAMPLE_C_CD_CL_V4_V5_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 5866
  { IMAGE_SAMPLE_C_CD_CL_V4_V6_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 5867
  { IMAGE_SAMPLE_C_CD_CL_V4_V7_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x4, 0x7, 0x1 }, // 5868
  { IMAGE_SAMPLE_C_CD_CL_V4_V8_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 5869
  { IMAGE_SAMPLE_C_CD_CL_V4_V9_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x4, 0x9, 0x1 }, // 5870
  { IMAGE_SAMPLE_C_CD_CL_V4_V10_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x4, 0xA, 0x1 }, // 5871
  { IMAGE_SAMPLE_C_CD_CL_V4_V11_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x4, 0xB, 0x1 }, // 5872
  { IMAGE_SAMPLE_C_CD_CL_V5_V3_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 5873
  { IMAGE_SAMPLE_C_CD_CL_V5_V4_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 5874
  { IMAGE_SAMPLE_C_CD_CL_V5_V5_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 5875
  { IMAGE_SAMPLE_C_CD_CL_V5_V6_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 5876
  { IMAGE_SAMPLE_C_CD_CL_V5_V7_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x5, 0x7, 0x1 }, // 5877
  { IMAGE_SAMPLE_C_CD_CL_V5_V8_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 5878
  { IMAGE_SAMPLE_C_CD_CL_V5_V9_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x5, 0x9, 0x1 }, // 5879
  { IMAGE_SAMPLE_C_CD_CL_V5_V10_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x5, 0xA, 0x1 }, // 5880
  { IMAGE_SAMPLE_C_CD_CL_V5_V11_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10Default, 0x5, 0xB, 0x1 }, // 5881
  { IMAGE_SAMPLE_C_CD_CL_V1_V3_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 5882
  { IMAGE_SAMPLE_C_CD_CL_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 5883
  { IMAGE_SAMPLE_C_CD_CL_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 5884
  { IMAGE_SAMPLE_C_CD_CL_V1_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 5885
  { IMAGE_SAMPLE_C_CD_CL_V1_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x1, 0x7, 0x7 }, // 5886
  { IMAGE_SAMPLE_C_CD_CL_V1_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x1, 0x8, 0x8 }, // 5887
  { IMAGE_SAMPLE_C_CD_CL_V1_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x1, 0x9, 0x9 }, // 5888
  { IMAGE_SAMPLE_C_CD_CL_V1_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x1, 0xA, 0xA }, // 5889
  { IMAGE_SAMPLE_C_CD_CL_V1_V11_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x1, 0xB, 0xB }, // 5890
  { IMAGE_SAMPLE_C_CD_CL_V2_V3_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 5891
  { IMAGE_SAMPLE_C_CD_CL_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 5892
  { IMAGE_SAMPLE_C_CD_CL_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 5893
  { IMAGE_SAMPLE_C_CD_CL_V2_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 5894
  { IMAGE_SAMPLE_C_CD_CL_V2_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x2, 0x7, 0x7 }, // 5895
  { IMAGE_SAMPLE_C_CD_CL_V2_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x2, 0x8, 0x8 }, // 5896
  { IMAGE_SAMPLE_C_CD_CL_V2_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x2, 0x9, 0x9 }, // 5897
  { IMAGE_SAMPLE_C_CD_CL_V2_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x2, 0xA, 0xA }, // 5898
  { IMAGE_SAMPLE_C_CD_CL_V2_V11_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x2, 0xB, 0xB }, // 5899
  { IMAGE_SAMPLE_C_CD_CL_V3_V3_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 5900
  { IMAGE_SAMPLE_C_CD_CL_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 5901
  { IMAGE_SAMPLE_C_CD_CL_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 5902
  { IMAGE_SAMPLE_C_CD_CL_V3_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 5903
  { IMAGE_SAMPLE_C_CD_CL_V3_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x3, 0x7, 0x7 }, // 5904
  { IMAGE_SAMPLE_C_CD_CL_V3_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x3, 0x8, 0x8 }, // 5905
  { IMAGE_SAMPLE_C_CD_CL_V3_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x3, 0x9, 0x9 }, // 5906
  { IMAGE_SAMPLE_C_CD_CL_V3_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x3, 0xA, 0xA }, // 5907
  { IMAGE_SAMPLE_C_CD_CL_V3_V11_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x3, 0xB, 0xB }, // 5908
  { IMAGE_SAMPLE_C_CD_CL_V4_V3_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 5909
  { IMAGE_SAMPLE_C_CD_CL_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 5910
  { IMAGE_SAMPLE_C_CD_CL_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 5911
  { IMAGE_SAMPLE_C_CD_CL_V4_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 5912
  { IMAGE_SAMPLE_C_CD_CL_V4_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x4, 0x7, 0x7 }, // 5913
  { IMAGE_SAMPLE_C_CD_CL_V4_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x4, 0x8, 0x8 }, // 5914
  { IMAGE_SAMPLE_C_CD_CL_V4_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x4, 0x9, 0x9 }, // 5915
  { IMAGE_SAMPLE_C_CD_CL_V4_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x4, 0xA, 0xA }, // 5916
  { IMAGE_SAMPLE_C_CD_CL_V4_V11_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x4, 0xB, 0xB }, // 5917
  { IMAGE_SAMPLE_C_CD_CL_V5_V3_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 5918
  { IMAGE_SAMPLE_C_CD_CL_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 5919
  { IMAGE_SAMPLE_C_CD_CL_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 5920
  { IMAGE_SAMPLE_C_CD_CL_V5_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 5921
  { IMAGE_SAMPLE_C_CD_CL_V5_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x5, 0x7, 0x7 }, // 5922
  { IMAGE_SAMPLE_C_CD_CL_V5_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x5, 0x8, 0x8 }, // 5923
  { IMAGE_SAMPLE_C_CD_CL_V5_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x5, 0x9, 0x9 }, // 5924
  { IMAGE_SAMPLE_C_CD_CL_V5_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x5, 0xA, 0xA }, // 5925
  { IMAGE_SAMPLE_C_CD_CL_V5_V11_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx10NSA, 0x5, 0xB, 0xB }, // 5926
  { IMAGE_SAMPLE_C_CD_CL_V1_V3, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 5927
  { IMAGE_SAMPLE_C_CD_CL_V1_V4, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 5928
  { IMAGE_SAMPLE_C_CD_CL_V1_V5, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 5929
  { IMAGE_SAMPLE_C_CD_CL_V1_V6, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 5930
  { IMAGE_SAMPLE_C_CD_CL_V1_V7, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x1, 0x7, 0x1 }, // 5931
  { IMAGE_SAMPLE_C_CD_CL_V1_V8, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 5932
  { IMAGE_SAMPLE_C_CD_CL_V1_V9, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x1, 0x9, 0x1 }, // 5933
  { IMAGE_SAMPLE_C_CD_CL_V1_V10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x1, 0xA, 0x1 }, // 5934
  { IMAGE_SAMPLE_C_CD_CL_V1_V11, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x1, 0xB, 0x1 }, // 5935
  { IMAGE_SAMPLE_C_CD_CL_V2_V3, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 5936
  { IMAGE_SAMPLE_C_CD_CL_V2_V4, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 5937
  { IMAGE_SAMPLE_C_CD_CL_V2_V5, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 5938
  { IMAGE_SAMPLE_C_CD_CL_V2_V6, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 5939
  { IMAGE_SAMPLE_C_CD_CL_V2_V7, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x2, 0x7, 0x1 }, // 5940
  { IMAGE_SAMPLE_C_CD_CL_V2_V8, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 5941
  { IMAGE_SAMPLE_C_CD_CL_V2_V9, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x2, 0x9, 0x1 }, // 5942
  { IMAGE_SAMPLE_C_CD_CL_V2_V10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x2, 0xA, 0x1 }, // 5943
  { IMAGE_SAMPLE_C_CD_CL_V2_V11, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x2, 0xB, 0x1 }, // 5944
  { IMAGE_SAMPLE_C_CD_CL_V3_V3, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 5945
  { IMAGE_SAMPLE_C_CD_CL_V3_V4, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 5946
  { IMAGE_SAMPLE_C_CD_CL_V3_V5, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 5947
  { IMAGE_SAMPLE_C_CD_CL_V3_V6, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 5948
  { IMAGE_SAMPLE_C_CD_CL_V3_V7, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x3, 0x7, 0x1 }, // 5949
  { IMAGE_SAMPLE_C_CD_CL_V3_V8, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 5950
  { IMAGE_SAMPLE_C_CD_CL_V3_V9, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x3, 0x9, 0x1 }, // 5951
  { IMAGE_SAMPLE_C_CD_CL_V3_V10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x3, 0xA, 0x1 }, // 5952
  { IMAGE_SAMPLE_C_CD_CL_V3_V11, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x3, 0xB, 0x1 }, // 5953
  { IMAGE_SAMPLE_C_CD_CL_V4_V3, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 5954
  { IMAGE_SAMPLE_C_CD_CL_V4_V4, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 5955
  { IMAGE_SAMPLE_C_CD_CL_V4_V5, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 5956
  { IMAGE_SAMPLE_C_CD_CL_V4_V6, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 5957
  { IMAGE_SAMPLE_C_CD_CL_V4_V7, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x4, 0x7, 0x1 }, // 5958
  { IMAGE_SAMPLE_C_CD_CL_V4_V8, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 5959
  { IMAGE_SAMPLE_C_CD_CL_V4_V9, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x4, 0x9, 0x1 }, // 5960
  { IMAGE_SAMPLE_C_CD_CL_V4_V10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x4, 0xA, 0x1 }, // 5961
  { IMAGE_SAMPLE_C_CD_CL_V4_V11, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x4, 0xB, 0x1 }, // 5962
  { IMAGE_SAMPLE_C_CD_CL_V5_V3, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 5963
  { IMAGE_SAMPLE_C_CD_CL_V5_V4, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 5964
  { IMAGE_SAMPLE_C_CD_CL_V5_V5, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 5965
  { IMAGE_SAMPLE_C_CD_CL_V5_V6, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 5966
  { IMAGE_SAMPLE_C_CD_CL_V5_V7, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x5, 0x7, 0x1 }, // 5967
  { IMAGE_SAMPLE_C_CD_CL_V5_V8, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 5968
  { IMAGE_SAMPLE_C_CD_CL_V5_V9, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x5, 0x9, 0x1 }, // 5969
  { IMAGE_SAMPLE_C_CD_CL_V5_V10, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x5, 0xA, 0x1 }, // 5970
  { IMAGE_SAMPLE_C_CD_CL_V5_V11, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x5, 0xB, 0x1 }, // 5971
  { IMAGE_SAMPLE_C_CD_CL_G16_V1_V3_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 5972
  { IMAGE_SAMPLE_C_CD_CL_G16_V1_V4_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 5973
  { IMAGE_SAMPLE_C_CD_CL_G16_V1_V5_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 5974
  { IMAGE_SAMPLE_C_CD_CL_G16_V1_V6_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 5975
  { IMAGE_SAMPLE_C_CD_CL_G16_V1_V7_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x1, 0x7, 0x1 }, // 5976
  { IMAGE_SAMPLE_C_CD_CL_G16_V1_V8_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 5977
  { IMAGE_SAMPLE_C_CD_CL_G16_V1_V9_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x1, 0x9, 0x1 }, // 5978
  { IMAGE_SAMPLE_C_CD_CL_G16_V2_V3_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 5979
  { IMAGE_SAMPLE_C_CD_CL_G16_V2_V4_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 5980
  { IMAGE_SAMPLE_C_CD_CL_G16_V2_V5_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 5981
  { IMAGE_SAMPLE_C_CD_CL_G16_V2_V6_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 5982
  { IMAGE_SAMPLE_C_CD_CL_G16_V2_V7_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x2, 0x7, 0x1 }, // 5983
  { IMAGE_SAMPLE_C_CD_CL_G16_V2_V8_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 5984
  { IMAGE_SAMPLE_C_CD_CL_G16_V2_V9_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x2, 0x9, 0x1 }, // 5985
  { IMAGE_SAMPLE_C_CD_CL_G16_V3_V3_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 5986
  { IMAGE_SAMPLE_C_CD_CL_G16_V3_V4_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 5987
  { IMAGE_SAMPLE_C_CD_CL_G16_V3_V5_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 5988
  { IMAGE_SAMPLE_C_CD_CL_G16_V3_V6_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 5989
  { IMAGE_SAMPLE_C_CD_CL_G16_V3_V7_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x3, 0x7, 0x1 }, // 5990
  { IMAGE_SAMPLE_C_CD_CL_G16_V3_V8_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 5991
  { IMAGE_SAMPLE_C_CD_CL_G16_V3_V9_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x3, 0x9, 0x1 }, // 5992
  { IMAGE_SAMPLE_C_CD_CL_G16_V4_V3_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 5993
  { IMAGE_SAMPLE_C_CD_CL_G16_V4_V4_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 5994
  { IMAGE_SAMPLE_C_CD_CL_G16_V4_V5_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 5995
  { IMAGE_SAMPLE_C_CD_CL_G16_V4_V6_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 5996
  { IMAGE_SAMPLE_C_CD_CL_G16_V4_V7_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x4, 0x7, 0x1 }, // 5997
  { IMAGE_SAMPLE_C_CD_CL_G16_V4_V8_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 5998
  { IMAGE_SAMPLE_C_CD_CL_G16_V4_V9_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x4, 0x9, 0x1 }, // 5999
  { IMAGE_SAMPLE_C_CD_CL_G16_V5_V3_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 6000
  { IMAGE_SAMPLE_C_CD_CL_G16_V5_V4_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 6001
  { IMAGE_SAMPLE_C_CD_CL_G16_V5_V5_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 6002
  { IMAGE_SAMPLE_C_CD_CL_G16_V5_V6_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 6003
  { IMAGE_SAMPLE_C_CD_CL_G16_V5_V7_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x5, 0x7, 0x1 }, // 6004
  { IMAGE_SAMPLE_C_CD_CL_G16_V5_V8_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 6005
  { IMAGE_SAMPLE_C_CD_CL_G16_V5_V9_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10Default, 0x5, 0x9, 0x1 }, // 6006
  { IMAGE_SAMPLE_C_CD_CL_G16_V1_V3_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 6007
  { IMAGE_SAMPLE_C_CD_CL_G16_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 6008
  { IMAGE_SAMPLE_C_CD_CL_G16_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 6009
  { IMAGE_SAMPLE_C_CD_CL_G16_V1_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 6010
  { IMAGE_SAMPLE_C_CD_CL_G16_V1_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x1, 0x7, 0x7 }, // 6011
  { IMAGE_SAMPLE_C_CD_CL_G16_V1_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x1, 0x8, 0x8 }, // 6012
  { IMAGE_SAMPLE_C_CD_CL_G16_V1_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x1, 0x9, 0x9 }, // 6013
  { IMAGE_SAMPLE_C_CD_CL_G16_V2_V3_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 6014
  { IMAGE_SAMPLE_C_CD_CL_G16_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 6015
  { IMAGE_SAMPLE_C_CD_CL_G16_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 6016
  { IMAGE_SAMPLE_C_CD_CL_G16_V2_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 6017
  { IMAGE_SAMPLE_C_CD_CL_G16_V2_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x2, 0x7, 0x7 }, // 6018
  { IMAGE_SAMPLE_C_CD_CL_G16_V2_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x2, 0x8, 0x8 }, // 6019
  { IMAGE_SAMPLE_C_CD_CL_G16_V2_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x2, 0x9, 0x9 }, // 6020
  { IMAGE_SAMPLE_C_CD_CL_G16_V3_V3_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 6021
  { IMAGE_SAMPLE_C_CD_CL_G16_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 6022
  { IMAGE_SAMPLE_C_CD_CL_G16_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 6023
  { IMAGE_SAMPLE_C_CD_CL_G16_V3_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 6024
  { IMAGE_SAMPLE_C_CD_CL_G16_V3_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x3, 0x7, 0x7 }, // 6025
  { IMAGE_SAMPLE_C_CD_CL_G16_V3_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x3, 0x8, 0x8 }, // 6026
  { IMAGE_SAMPLE_C_CD_CL_G16_V3_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x3, 0x9, 0x9 }, // 6027
  { IMAGE_SAMPLE_C_CD_CL_G16_V4_V3_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 6028
  { IMAGE_SAMPLE_C_CD_CL_G16_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 6029
  { IMAGE_SAMPLE_C_CD_CL_G16_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 6030
  { IMAGE_SAMPLE_C_CD_CL_G16_V4_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 6031
  { IMAGE_SAMPLE_C_CD_CL_G16_V4_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x4, 0x7, 0x7 }, // 6032
  { IMAGE_SAMPLE_C_CD_CL_G16_V4_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x4, 0x8, 0x8 }, // 6033
  { IMAGE_SAMPLE_C_CD_CL_G16_V4_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x4, 0x9, 0x9 }, // 6034
  { IMAGE_SAMPLE_C_CD_CL_G16_V5_V3_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 6035
  { IMAGE_SAMPLE_C_CD_CL_G16_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 6036
  { IMAGE_SAMPLE_C_CD_CL_G16_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 6037
  { IMAGE_SAMPLE_C_CD_CL_G16_V5_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 6038
  { IMAGE_SAMPLE_C_CD_CL_G16_V5_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x5, 0x7, 0x7 }, // 6039
  { IMAGE_SAMPLE_C_CD_CL_G16_V5_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x5, 0x8, 0x8 }, // 6040
  { IMAGE_SAMPLE_C_CD_CL_G16_V5_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx10NSA, 0x5, 0x9, 0x9 }, // 6041
  { IMAGE_SAMPLE_C_CD_CL_G16_V1_V3, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 6042
  { IMAGE_SAMPLE_C_CD_CL_G16_V1_V4, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 6043
  { IMAGE_SAMPLE_C_CD_CL_G16_V1_V5, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 6044
  { IMAGE_SAMPLE_C_CD_CL_G16_V1_V6, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 6045
  { IMAGE_SAMPLE_C_CD_CL_G16_V1_V7, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x1, 0x7, 0x1 }, // 6046
  { IMAGE_SAMPLE_C_CD_CL_G16_V1_V8, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 6047
  { IMAGE_SAMPLE_C_CD_CL_G16_V1_V9, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x1, 0x9, 0x1 }, // 6048
  { IMAGE_SAMPLE_C_CD_CL_G16_V2_V3, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 6049
  { IMAGE_SAMPLE_C_CD_CL_G16_V2_V4, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 6050
  { IMAGE_SAMPLE_C_CD_CL_G16_V2_V5, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 6051
  { IMAGE_SAMPLE_C_CD_CL_G16_V2_V6, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 6052
  { IMAGE_SAMPLE_C_CD_CL_G16_V2_V7, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x2, 0x7, 0x1 }, // 6053
  { IMAGE_SAMPLE_C_CD_CL_G16_V2_V8, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 6054
  { IMAGE_SAMPLE_C_CD_CL_G16_V2_V9, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x2, 0x9, 0x1 }, // 6055
  { IMAGE_SAMPLE_C_CD_CL_G16_V3_V3, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 6056
  { IMAGE_SAMPLE_C_CD_CL_G16_V3_V4, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 6057
  { IMAGE_SAMPLE_C_CD_CL_G16_V3_V5, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 6058
  { IMAGE_SAMPLE_C_CD_CL_G16_V3_V6, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 6059
  { IMAGE_SAMPLE_C_CD_CL_G16_V3_V7, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x3, 0x7, 0x1 }, // 6060
  { IMAGE_SAMPLE_C_CD_CL_G16_V3_V8, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 6061
  { IMAGE_SAMPLE_C_CD_CL_G16_V3_V9, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x3, 0x9, 0x1 }, // 6062
  { IMAGE_SAMPLE_C_CD_CL_G16_V4_V3, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 6063
  { IMAGE_SAMPLE_C_CD_CL_G16_V4_V4, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 6064
  { IMAGE_SAMPLE_C_CD_CL_G16_V4_V5, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 6065
  { IMAGE_SAMPLE_C_CD_CL_G16_V4_V6, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 6066
  { IMAGE_SAMPLE_C_CD_CL_G16_V4_V7, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x4, 0x7, 0x1 }, // 6067
  { IMAGE_SAMPLE_C_CD_CL_G16_V4_V8, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 6068
  { IMAGE_SAMPLE_C_CD_CL_G16_V4_V9, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x4, 0x9, 0x1 }, // 6069
  { IMAGE_SAMPLE_C_CD_CL_G16_V5_V3, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 6070
  { IMAGE_SAMPLE_C_CD_CL_G16_V5_V4, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 6071
  { IMAGE_SAMPLE_C_CD_CL_G16_V5_V5, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 6072
  { IMAGE_SAMPLE_C_CD_CL_G16_V5_V6, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 6073
  { IMAGE_SAMPLE_C_CD_CL_G16_V5_V7, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x5, 0x7, 0x1 }, // 6074
  { IMAGE_SAMPLE_C_CD_CL_G16_V5_V8, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 6075
  { IMAGE_SAMPLE_C_CD_CL_G16_V5_V9, IMAGE_SAMPLE_C_CD_CL_G16, MIMGEncGfx6, 0x5, 0x9, 0x1 }, // 6076
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V4_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 6077
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V5_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 6078
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V6_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 6079
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V7_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x1, 0x7, 0x1 }, // 6080
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V8_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 6081
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V9_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x1, 0x9, 0x1 }, // 6082
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V10_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x1, 0xA, 0x1 }, // 6083
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V11_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x1, 0xB, 0x1 }, // 6084
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V12_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x1, 0xC, 0x1 }, // 6085
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V4_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 6086
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V5_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 6087
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V6_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 6088
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V7_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x2, 0x7, 0x1 }, // 6089
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V8_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 6090
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V9_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x2, 0x9, 0x1 }, // 6091
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V10_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x2, 0xA, 0x1 }, // 6092
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V11_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x2, 0xB, 0x1 }, // 6093
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V12_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x2, 0xC, 0x1 }, // 6094
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V4_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 6095
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V5_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 6096
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V6_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 6097
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V7_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x3, 0x7, 0x1 }, // 6098
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V8_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 6099
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V9_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x3, 0x9, 0x1 }, // 6100
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V10_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x3, 0xA, 0x1 }, // 6101
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V11_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x3, 0xB, 0x1 }, // 6102
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V12_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x3, 0xC, 0x1 }, // 6103
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V4_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 6104
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V5_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 6105
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V6_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 6106
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V7_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x4, 0x7, 0x1 }, // 6107
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V8_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 6108
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V9_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x4, 0x9, 0x1 }, // 6109
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V10_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x4, 0xA, 0x1 }, // 6110
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V11_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x4, 0xB, 0x1 }, // 6111
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V12_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x4, 0xC, 0x1 }, // 6112
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V4_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 6113
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V5_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 6114
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V6_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 6115
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V7_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x5, 0x7, 0x1 }, // 6116
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V8_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 6117
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V9_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x5, 0x9, 0x1 }, // 6118
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V10_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x5, 0xA, 0x1 }, // 6119
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V11_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x5, 0xB, 0x1 }, // 6120
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V12_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10Default, 0x5, 0xC, 0x1 }, // 6121
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 6122
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 6123
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 6124
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0x7, 0x7 }, // 6125
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0x8, 0x8 }, // 6126
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0x9, 0x9 }, // 6127
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0xA, 0xA }, // 6128
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V11_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0xB, 0xB }, // 6129
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V12_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0xC, 0xC }, // 6130
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 6131
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 6132
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 6133
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0x7, 0x7 }, // 6134
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0x8, 0x8 }, // 6135
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0x9, 0x9 }, // 6136
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0xA, 0xA }, // 6137
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V11_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0xB, 0xB }, // 6138
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V12_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0xC, 0xC }, // 6139
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 6140
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 6141
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 6142
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0x7, 0x7 }, // 6143
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0x8, 0x8 }, // 6144
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0x9, 0x9 }, // 6145
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0xA, 0xA }, // 6146
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V11_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0xB, 0xB }, // 6147
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V12_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0xC, 0xC }, // 6148
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 6149
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 6150
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 6151
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0x7, 0x7 }, // 6152
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0x8, 0x8 }, // 6153
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0x9, 0x9 }, // 6154
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0xA, 0xA }, // 6155
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V11_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0xB, 0xB }, // 6156
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V12_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0xC, 0xC }, // 6157
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 6158
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 6159
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 6160
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0x7, 0x7 }, // 6161
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0x8, 0x8 }, // 6162
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0x9, 0x9 }, // 6163
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0xA, 0xA }, // 6164
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V11_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0xB, 0xB }, // 6165
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V12_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0xC, 0xC }, // 6166
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V4, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 6167
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V5, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 6168
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V6, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 6169
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V7, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x1, 0x7, 0x1 }, // 6170
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V8, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 6171
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V9, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x1, 0x9, 0x1 }, // 6172
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x1, 0xA, 0x1 }, // 6173
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V11, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x1, 0xB, 0x1 }, // 6174
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V12, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x1, 0xC, 0x1 }, // 6175
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V4, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 6176
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V5, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 6177
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V6, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 6178
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V7, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x2, 0x7, 0x1 }, // 6179
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V8, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 6180
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V9, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x2, 0x9, 0x1 }, // 6181
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x2, 0xA, 0x1 }, // 6182
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V11, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x2, 0xB, 0x1 }, // 6183
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V12, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x2, 0xC, 0x1 }, // 6184
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V4, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 6185
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V5, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 6186
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V6, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 6187
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V7, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x3, 0x7, 0x1 }, // 6188
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V8, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 6189
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V9, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x3, 0x9, 0x1 }, // 6190
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x3, 0xA, 0x1 }, // 6191
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V11, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x3, 0xB, 0x1 }, // 6192
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V12, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x3, 0xC, 0x1 }, // 6193
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V4, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 6194
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V5, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 6195
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V6, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 6196
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V7, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x4, 0x7, 0x1 }, // 6197
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V8, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 6198
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V9, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x4, 0x9, 0x1 }, // 6199
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x4, 0xA, 0x1 }, // 6200
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V11, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x4, 0xB, 0x1 }, // 6201
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V12, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x4, 0xC, 0x1 }, // 6202
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V4, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 6203
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V5, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 6204
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V6, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 6205
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V7, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x5, 0x7, 0x1 }, // 6206
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V8, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 6207
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V9, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x5, 0x9, 0x1 }, // 6208
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V10, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x5, 0xA, 0x1 }, // 6209
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V11, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x5, 0xB, 0x1 }, // 6210
  { IMAGE_SAMPLE_C_CD_CL_O_V5_V12, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x5, 0xC, 0x1 }, // 6211
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V1_V4_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 6212
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V1_V5_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 6213
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V1_V6_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 6214
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V1_V7_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x7, 0x1 }, // 6215
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V1_V8_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 6216
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V1_V9_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x9, 0x1 }, // 6217
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V1_V10_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x1, 0xA, 0x1 }, // 6218
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V2_V4_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 6219
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V2_V5_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 6220
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V2_V6_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 6221
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V2_V7_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x7, 0x1 }, // 6222
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V2_V8_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 6223
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V2_V9_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x9, 0x1 }, // 6224
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V2_V10_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x2, 0xA, 0x1 }, // 6225
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V3_V4_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 6226
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V3_V5_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 6227
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V3_V6_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 6228
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V3_V7_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x7, 0x1 }, // 6229
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V3_V8_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 6230
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V3_V9_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x9, 0x1 }, // 6231
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V3_V10_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x3, 0xA, 0x1 }, // 6232
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V4_V4_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 6233
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V4_V5_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 6234
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V4_V6_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 6235
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V4_V7_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x7, 0x1 }, // 6236
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V4_V8_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 6237
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V4_V9_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x9, 0x1 }, // 6238
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V4_V10_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x4, 0xA, 0x1 }, // 6239
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V5_V4_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 6240
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V5_V5_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 6241
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V5_V6_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 6242
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V5_V7_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x7, 0x1 }, // 6243
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V5_V8_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 6244
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V5_V9_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x9, 0x1 }, // 6245
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V5_V10_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10Default, 0x5, 0xA, 0x1 }, // 6246
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 6247
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 6248
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V1_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 6249
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V1_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x7, 0x7 }, // 6250
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V1_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x8, 0x8 }, // 6251
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V1_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x9, 0x9 }, // 6252
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V1_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0xA, 0xA }, // 6253
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 6254
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 6255
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V2_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 6256
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V2_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x7, 0x7 }, // 6257
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V2_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x8, 0x8 }, // 6258
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V2_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x9, 0x9 }, // 6259
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V2_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0xA, 0xA }, // 6260
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 6261
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 6262
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V3_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 6263
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V3_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x7, 0x7 }, // 6264
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V3_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x8, 0x8 }, // 6265
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V3_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x9, 0x9 }, // 6266
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V3_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0xA, 0xA }, // 6267
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 6268
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 6269
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V4_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 6270
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V4_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x7, 0x7 }, // 6271
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V4_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x8, 0x8 }, // 6272
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V4_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x9, 0x9 }, // 6273
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V4_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0xA, 0xA }, // 6274
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 6275
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 6276
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V5_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 6277
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V5_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x7, 0x7 }, // 6278
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V5_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x8, 0x8 }, // 6279
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V5_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x9, 0x9 }, // 6280
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V5_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0xA, 0xA }, // 6281
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V1_V4, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 6282
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V1_V5, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 6283
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V1_V6, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 6284
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V1_V7, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x1, 0x7, 0x1 }, // 6285
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V1_V8, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 6286
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V1_V9, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x1, 0x9, 0x1 }, // 6287
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V1_V10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x1, 0xA, 0x1 }, // 6288
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V2_V4, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 6289
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V2_V5, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 6290
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V2_V6, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 6291
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V2_V7, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x2, 0x7, 0x1 }, // 6292
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V2_V8, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 6293
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V2_V9, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x2, 0x9, 0x1 }, // 6294
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V2_V10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x2, 0xA, 0x1 }, // 6295
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V3_V4, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 6296
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V3_V5, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 6297
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V3_V6, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 6298
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V3_V7, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x3, 0x7, 0x1 }, // 6299
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V3_V8, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 6300
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V3_V9, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x3, 0x9, 0x1 }, // 6301
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V3_V10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x3, 0xA, 0x1 }, // 6302
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V4_V4, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 6303
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V4_V5, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 6304
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V4_V6, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 6305
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V4_V7, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x4, 0x7, 0x1 }, // 6306
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V4_V8, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 6307
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V4_V9, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x4, 0x9, 0x1 }, // 6308
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V4_V10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x4, 0xA, 0x1 }, // 6309
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V5_V4, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 6310
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V5_V5, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 6311
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V5_V6, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 6312
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V5_V7, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x5, 0x7, 0x1 }, // 6313
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V5_V8, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 6314
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V5_V9, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x5, 0x9, 0x1 }, // 6315
  { IMAGE_SAMPLE_C_CD_CL_O_G16_V5_V10, IMAGE_SAMPLE_C_CD_CL_O_G16, MIMGEncGfx6, 0x5, 0xA, 0x1 }, // 6316
  { IMAGE_SAMPLE_C_CD_G16_V1_V3_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 6317
  { IMAGE_SAMPLE_C_CD_G16_V1_V4_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 6318
  { IMAGE_SAMPLE_C_CD_G16_V1_V5_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 6319
  { IMAGE_SAMPLE_C_CD_G16_V1_V6_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 6320
  { IMAGE_SAMPLE_C_CD_G16_V1_V7_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x1, 0x7, 0x1 }, // 6321
  { IMAGE_SAMPLE_C_CD_G16_V1_V8_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 6322
  { IMAGE_SAMPLE_C_CD_G16_V2_V3_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 6323
  { IMAGE_SAMPLE_C_CD_G16_V2_V4_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 6324
  { IMAGE_SAMPLE_C_CD_G16_V2_V5_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 6325
  { IMAGE_SAMPLE_C_CD_G16_V2_V6_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 6326
  { IMAGE_SAMPLE_C_CD_G16_V2_V7_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x2, 0x7, 0x1 }, // 6327
  { IMAGE_SAMPLE_C_CD_G16_V2_V8_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 6328
  { IMAGE_SAMPLE_C_CD_G16_V3_V3_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 6329
  { IMAGE_SAMPLE_C_CD_G16_V3_V4_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 6330
  { IMAGE_SAMPLE_C_CD_G16_V3_V5_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 6331
  { IMAGE_SAMPLE_C_CD_G16_V3_V6_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 6332
  { IMAGE_SAMPLE_C_CD_G16_V3_V7_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x3, 0x7, 0x1 }, // 6333
  { IMAGE_SAMPLE_C_CD_G16_V3_V8_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 6334
  { IMAGE_SAMPLE_C_CD_G16_V4_V3_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 6335
  { IMAGE_SAMPLE_C_CD_G16_V4_V4_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 6336
  { IMAGE_SAMPLE_C_CD_G16_V4_V5_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 6337
  { IMAGE_SAMPLE_C_CD_G16_V4_V6_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 6338
  { IMAGE_SAMPLE_C_CD_G16_V4_V7_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x4, 0x7, 0x1 }, // 6339
  { IMAGE_SAMPLE_C_CD_G16_V4_V8_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 6340
  { IMAGE_SAMPLE_C_CD_G16_V5_V3_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 6341
  { IMAGE_SAMPLE_C_CD_G16_V5_V4_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 6342
  { IMAGE_SAMPLE_C_CD_G16_V5_V5_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 6343
  { IMAGE_SAMPLE_C_CD_G16_V5_V6_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 6344
  { IMAGE_SAMPLE_C_CD_G16_V5_V7_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x5, 0x7, 0x1 }, // 6345
  { IMAGE_SAMPLE_C_CD_G16_V5_V8_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 6346
  { IMAGE_SAMPLE_C_CD_G16_V1_V3_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 6347
  { IMAGE_SAMPLE_C_CD_G16_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 6348
  { IMAGE_SAMPLE_C_CD_G16_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 6349
  { IMAGE_SAMPLE_C_CD_G16_V1_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 6350
  { IMAGE_SAMPLE_C_CD_G16_V1_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x1, 0x7, 0x7 }, // 6351
  { IMAGE_SAMPLE_C_CD_G16_V1_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x1, 0x8, 0x8 }, // 6352
  { IMAGE_SAMPLE_C_CD_G16_V2_V3_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 6353
  { IMAGE_SAMPLE_C_CD_G16_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 6354
  { IMAGE_SAMPLE_C_CD_G16_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 6355
  { IMAGE_SAMPLE_C_CD_G16_V2_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 6356
  { IMAGE_SAMPLE_C_CD_G16_V2_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x2, 0x7, 0x7 }, // 6357
  { IMAGE_SAMPLE_C_CD_G16_V2_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x2, 0x8, 0x8 }, // 6358
  { IMAGE_SAMPLE_C_CD_G16_V3_V3_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 6359
  { IMAGE_SAMPLE_C_CD_G16_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 6360
  { IMAGE_SAMPLE_C_CD_G16_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 6361
  { IMAGE_SAMPLE_C_CD_G16_V3_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 6362
  { IMAGE_SAMPLE_C_CD_G16_V3_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x3, 0x7, 0x7 }, // 6363
  { IMAGE_SAMPLE_C_CD_G16_V3_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x3, 0x8, 0x8 }, // 6364
  { IMAGE_SAMPLE_C_CD_G16_V4_V3_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 6365
  { IMAGE_SAMPLE_C_CD_G16_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 6366
  { IMAGE_SAMPLE_C_CD_G16_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 6367
  { IMAGE_SAMPLE_C_CD_G16_V4_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 6368
  { IMAGE_SAMPLE_C_CD_G16_V4_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x4, 0x7, 0x7 }, // 6369
  { IMAGE_SAMPLE_C_CD_G16_V4_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x4, 0x8, 0x8 }, // 6370
  { IMAGE_SAMPLE_C_CD_G16_V5_V3_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 6371
  { IMAGE_SAMPLE_C_CD_G16_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 6372
  { IMAGE_SAMPLE_C_CD_G16_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 6373
  { IMAGE_SAMPLE_C_CD_G16_V5_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 6374
  { IMAGE_SAMPLE_C_CD_G16_V5_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x5, 0x7, 0x7 }, // 6375
  { IMAGE_SAMPLE_C_CD_G16_V5_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx10NSA, 0x5, 0x8, 0x8 }, // 6376
  { IMAGE_SAMPLE_C_CD_G16_V1_V3, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 6377
  { IMAGE_SAMPLE_C_CD_G16_V1_V4, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 6378
  { IMAGE_SAMPLE_C_CD_G16_V1_V5, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 6379
  { IMAGE_SAMPLE_C_CD_G16_V1_V6, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 6380
  { IMAGE_SAMPLE_C_CD_G16_V1_V7, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x1, 0x7, 0x1 }, // 6381
  { IMAGE_SAMPLE_C_CD_G16_V1_V8, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 6382
  { IMAGE_SAMPLE_C_CD_G16_V2_V3, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 6383
  { IMAGE_SAMPLE_C_CD_G16_V2_V4, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 6384
  { IMAGE_SAMPLE_C_CD_G16_V2_V5, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 6385
  { IMAGE_SAMPLE_C_CD_G16_V2_V6, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 6386
  { IMAGE_SAMPLE_C_CD_G16_V2_V7, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x2, 0x7, 0x1 }, // 6387
  { IMAGE_SAMPLE_C_CD_G16_V2_V8, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 6388
  { IMAGE_SAMPLE_C_CD_G16_V3_V3, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 6389
  { IMAGE_SAMPLE_C_CD_G16_V3_V4, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 6390
  { IMAGE_SAMPLE_C_CD_G16_V3_V5, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 6391
  { IMAGE_SAMPLE_C_CD_G16_V3_V6, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 6392
  { IMAGE_SAMPLE_C_CD_G16_V3_V7, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x3, 0x7, 0x1 }, // 6393
  { IMAGE_SAMPLE_C_CD_G16_V3_V8, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 6394
  { IMAGE_SAMPLE_C_CD_G16_V4_V3, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 6395
  { IMAGE_SAMPLE_C_CD_G16_V4_V4, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 6396
  { IMAGE_SAMPLE_C_CD_G16_V4_V5, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 6397
  { IMAGE_SAMPLE_C_CD_G16_V4_V6, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 6398
  { IMAGE_SAMPLE_C_CD_G16_V4_V7, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x4, 0x7, 0x1 }, // 6399
  { IMAGE_SAMPLE_C_CD_G16_V4_V8, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 6400
  { IMAGE_SAMPLE_C_CD_G16_V5_V3, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 6401
  { IMAGE_SAMPLE_C_CD_G16_V5_V4, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 6402
  { IMAGE_SAMPLE_C_CD_G16_V5_V5, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 6403
  { IMAGE_SAMPLE_C_CD_G16_V5_V6, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 6404
  { IMAGE_SAMPLE_C_CD_G16_V5_V7, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x5, 0x7, 0x1 }, // 6405
  { IMAGE_SAMPLE_C_CD_G16_V5_V8, IMAGE_SAMPLE_C_CD_G16, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 6406
  { IMAGE_SAMPLE_C_CD_O_V1_V4_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 6407
  { IMAGE_SAMPLE_C_CD_O_V1_V5_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 6408
  { IMAGE_SAMPLE_C_CD_O_V1_V6_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 6409
  { IMAGE_SAMPLE_C_CD_O_V1_V7_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x1, 0x7, 0x1 }, // 6410
  { IMAGE_SAMPLE_C_CD_O_V1_V8_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 6411
  { IMAGE_SAMPLE_C_CD_O_V1_V9_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x1, 0x9, 0x1 }, // 6412
  { IMAGE_SAMPLE_C_CD_O_V1_V10_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x1, 0xA, 0x1 }, // 6413
  { IMAGE_SAMPLE_C_CD_O_V1_V11_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x1, 0xB, 0x1 }, // 6414
  { IMAGE_SAMPLE_C_CD_O_V2_V4_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 6415
  { IMAGE_SAMPLE_C_CD_O_V2_V5_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 6416
  { IMAGE_SAMPLE_C_CD_O_V2_V6_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 6417
  { IMAGE_SAMPLE_C_CD_O_V2_V7_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x2, 0x7, 0x1 }, // 6418
  { IMAGE_SAMPLE_C_CD_O_V2_V8_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 6419
  { IMAGE_SAMPLE_C_CD_O_V2_V9_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x2, 0x9, 0x1 }, // 6420
  { IMAGE_SAMPLE_C_CD_O_V2_V10_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x2, 0xA, 0x1 }, // 6421
  { IMAGE_SAMPLE_C_CD_O_V2_V11_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x2, 0xB, 0x1 }, // 6422
  { IMAGE_SAMPLE_C_CD_O_V3_V4_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 6423
  { IMAGE_SAMPLE_C_CD_O_V3_V5_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 6424
  { IMAGE_SAMPLE_C_CD_O_V3_V6_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 6425
  { IMAGE_SAMPLE_C_CD_O_V3_V7_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x3, 0x7, 0x1 }, // 6426
  { IMAGE_SAMPLE_C_CD_O_V3_V8_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 6427
  { IMAGE_SAMPLE_C_CD_O_V3_V9_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x3, 0x9, 0x1 }, // 6428
  { IMAGE_SAMPLE_C_CD_O_V3_V10_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x3, 0xA, 0x1 }, // 6429
  { IMAGE_SAMPLE_C_CD_O_V3_V11_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x3, 0xB, 0x1 }, // 6430
  { IMAGE_SAMPLE_C_CD_O_V4_V4_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 6431
  { IMAGE_SAMPLE_C_CD_O_V4_V5_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 6432
  { IMAGE_SAMPLE_C_CD_O_V4_V6_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 6433
  { IMAGE_SAMPLE_C_CD_O_V4_V7_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x4, 0x7, 0x1 }, // 6434
  { IMAGE_SAMPLE_C_CD_O_V4_V8_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 6435
  { IMAGE_SAMPLE_C_CD_O_V4_V9_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x4, 0x9, 0x1 }, // 6436
  { IMAGE_SAMPLE_C_CD_O_V4_V10_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x4, 0xA, 0x1 }, // 6437
  { IMAGE_SAMPLE_C_CD_O_V4_V11_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x4, 0xB, 0x1 }, // 6438
  { IMAGE_SAMPLE_C_CD_O_V5_V4_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 6439
  { IMAGE_SAMPLE_C_CD_O_V5_V5_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 6440
  { IMAGE_SAMPLE_C_CD_O_V5_V6_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 6441
  { IMAGE_SAMPLE_C_CD_O_V5_V7_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x5, 0x7, 0x1 }, // 6442
  { IMAGE_SAMPLE_C_CD_O_V5_V8_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 6443
  { IMAGE_SAMPLE_C_CD_O_V5_V9_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x5, 0x9, 0x1 }, // 6444
  { IMAGE_SAMPLE_C_CD_O_V5_V10_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x5, 0xA, 0x1 }, // 6445
  { IMAGE_SAMPLE_C_CD_O_V5_V11_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10Default, 0x5, 0xB, 0x1 }, // 6446
  { IMAGE_SAMPLE_C_CD_O_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 6447
  { IMAGE_SAMPLE_C_CD_O_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 6448
  { IMAGE_SAMPLE_C_CD_O_V1_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 6449
  { IMAGE_SAMPLE_C_CD_O_V1_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x1, 0x7, 0x7 }, // 6450
  { IMAGE_SAMPLE_C_CD_O_V1_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x1, 0x8, 0x8 }, // 6451
  { IMAGE_SAMPLE_C_CD_O_V1_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x1, 0x9, 0x9 }, // 6452
  { IMAGE_SAMPLE_C_CD_O_V1_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x1, 0xA, 0xA }, // 6453
  { IMAGE_SAMPLE_C_CD_O_V1_V11_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x1, 0xB, 0xB }, // 6454
  { IMAGE_SAMPLE_C_CD_O_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 6455
  { IMAGE_SAMPLE_C_CD_O_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 6456
  { IMAGE_SAMPLE_C_CD_O_V2_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 6457
  { IMAGE_SAMPLE_C_CD_O_V2_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x2, 0x7, 0x7 }, // 6458
  { IMAGE_SAMPLE_C_CD_O_V2_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x2, 0x8, 0x8 }, // 6459
  { IMAGE_SAMPLE_C_CD_O_V2_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x2, 0x9, 0x9 }, // 6460
  { IMAGE_SAMPLE_C_CD_O_V2_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x2, 0xA, 0xA }, // 6461
  { IMAGE_SAMPLE_C_CD_O_V2_V11_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x2, 0xB, 0xB }, // 6462
  { IMAGE_SAMPLE_C_CD_O_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 6463
  { IMAGE_SAMPLE_C_CD_O_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 6464
  { IMAGE_SAMPLE_C_CD_O_V3_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 6465
  { IMAGE_SAMPLE_C_CD_O_V3_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x3, 0x7, 0x7 }, // 6466
  { IMAGE_SAMPLE_C_CD_O_V3_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x3, 0x8, 0x8 }, // 6467
  { IMAGE_SAMPLE_C_CD_O_V3_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x3, 0x9, 0x9 }, // 6468
  { IMAGE_SAMPLE_C_CD_O_V3_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x3, 0xA, 0xA }, // 6469
  { IMAGE_SAMPLE_C_CD_O_V3_V11_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x3, 0xB, 0xB }, // 6470
  { IMAGE_SAMPLE_C_CD_O_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 6471
  { IMAGE_SAMPLE_C_CD_O_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 6472
  { IMAGE_SAMPLE_C_CD_O_V4_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 6473
  { IMAGE_SAMPLE_C_CD_O_V4_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x4, 0x7, 0x7 }, // 6474
  { IMAGE_SAMPLE_C_CD_O_V4_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x4, 0x8, 0x8 }, // 6475
  { IMAGE_SAMPLE_C_CD_O_V4_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x4, 0x9, 0x9 }, // 6476
  { IMAGE_SAMPLE_C_CD_O_V4_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x4, 0xA, 0xA }, // 6477
  { IMAGE_SAMPLE_C_CD_O_V4_V11_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x4, 0xB, 0xB }, // 6478
  { IMAGE_SAMPLE_C_CD_O_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 6479
  { IMAGE_SAMPLE_C_CD_O_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 6480
  { IMAGE_SAMPLE_C_CD_O_V5_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 6481
  { IMAGE_SAMPLE_C_CD_O_V5_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x5, 0x7, 0x7 }, // 6482
  { IMAGE_SAMPLE_C_CD_O_V5_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x5, 0x8, 0x8 }, // 6483
  { IMAGE_SAMPLE_C_CD_O_V5_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x5, 0x9, 0x9 }, // 6484
  { IMAGE_SAMPLE_C_CD_O_V5_V10_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x5, 0xA, 0xA }, // 6485
  { IMAGE_SAMPLE_C_CD_O_V5_V11_nsa_gfx10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx10NSA, 0x5, 0xB, 0xB }, // 6486
  { IMAGE_SAMPLE_C_CD_O_V1_V4, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 6487
  { IMAGE_SAMPLE_C_CD_O_V1_V5, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 6488
  { IMAGE_SAMPLE_C_CD_O_V1_V6, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 6489
  { IMAGE_SAMPLE_C_CD_O_V1_V7, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x1, 0x7, 0x1 }, // 6490
  { IMAGE_SAMPLE_C_CD_O_V1_V8, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 6491
  { IMAGE_SAMPLE_C_CD_O_V1_V9, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x1, 0x9, 0x1 }, // 6492
  { IMAGE_SAMPLE_C_CD_O_V1_V10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x1, 0xA, 0x1 }, // 6493
  { IMAGE_SAMPLE_C_CD_O_V1_V11, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x1, 0xB, 0x1 }, // 6494
  { IMAGE_SAMPLE_C_CD_O_V2_V4, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 6495
  { IMAGE_SAMPLE_C_CD_O_V2_V5, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 6496
  { IMAGE_SAMPLE_C_CD_O_V2_V6, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 6497
  { IMAGE_SAMPLE_C_CD_O_V2_V7, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x2, 0x7, 0x1 }, // 6498
  { IMAGE_SAMPLE_C_CD_O_V2_V8, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 6499
  { IMAGE_SAMPLE_C_CD_O_V2_V9, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x2, 0x9, 0x1 }, // 6500
  { IMAGE_SAMPLE_C_CD_O_V2_V10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x2, 0xA, 0x1 }, // 6501
  { IMAGE_SAMPLE_C_CD_O_V2_V11, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x2, 0xB, 0x1 }, // 6502
  { IMAGE_SAMPLE_C_CD_O_V3_V4, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 6503
  { IMAGE_SAMPLE_C_CD_O_V3_V5, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 6504
  { IMAGE_SAMPLE_C_CD_O_V3_V6, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 6505
  { IMAGE_SAMPLE_C_CD_O_V3_V7, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x3, 0x7, 0x1 }, // 6506
  { IMAGE_SAMPLE_C_CD_O_V3_V8, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 6507
  { IMAGE_SAMPLE_C_CD_O_V3_V9, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x3, 0x9, 0x1 }, // 6508
  { IMAGE_SAMPLE_C_CD_O_V3_V10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x3, 0xA, 0x1 }, // 6509
  { IMAGE_SAMPLE_C_CD_O_V3_V11, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x3, 0xB, 0x1 }, // 6510
  { IMAGE_SAMPLE_C_CD_O_V4_V4, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 6511
  { IMAGE_SAMPLE_C_CD_O_V4_V5, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 6512
  { IMAGE_SAMPLE_C_CD_O_V4_V6, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 6513
  { IMAGE_SAMPLE_C_CD_O_V4_V7, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x4, 0x7, 0x1 }, // 6514
  { IMAGE_SAMPLE_C_CD_O_V4_V8, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 6515
  { IMAGE_SAMPLE_C_CD_O_V4_V9, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x4, 0x9, 0x1 }, // 6516
  { IMAGE_SAMPLE_C_CD_O_V4_V10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x4, 0xA, 0x1 }, // 6517
  { IMAGE_SAMPLE_C_CD_O_V4_V11, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x4, 0xB, 0x1 }, // 6518
  { IMAGE_SAMPLE_C_CD_O_V5_V4, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 6519
  { IMAGE_SAMPLE_C_CD_O_V5_V5, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 6520
  { IMAGE_SAMPLE_C_CD_O_V5_V6, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 6521
  { IMAGE_SAMPLE_C_CD_O_V5_V7, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x5, 0x7, 0x1 }, // 6522
  { IMAGE_SAMPLE_C_CD_O_V5_V8, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 6523
  { IMAGE_SAMPLE_C_CD_O_V5_V9, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x5, 0x9, 0x1 }, // 6524
  { IMAGE_SAMPLE_C_CD_O_V5_V10, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x5, 0xA, 0x1 }, // 6525
  { IMAGE_SAMPLE_C_CD_O_V5_V11, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x5, 0xB, 0x1 }, // 6526
  { IMAGE_SAMPLE_C_CD_O_G16_V1_V4_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 6527
  { IMAGE_SAMPLE_C_CD_O_G16_V1_V5_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 6528
  { IMAGE_SAMPLE_C_CD_O_G16_V1_V6_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 6529
  { IMAGE_SAMPLE_C_CD_O_G16_V1_V7_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x1, 0x7, 0x1 }, // 6530
  { IMAGE_SAMPLE_C_CD_O_G16_V1_V8_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 6531
  { IMAGE_SAMPLE_C_CD_O_G16_V1_V9_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x1, 0x9, 0x1 }, // 6532
  { IMAGE_SAMPLE_C_CD_O_G16_V2_V4_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 6533
  { IMAGE_SAMPLE_C_CD_O_G16_V2_V5_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 6534
  { IMAGE_SAMPLE_C_CD_O_G16_V2_V6_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 6535
  { IMAGE_SAMPLE_C_CD_O_G16_V2_V7_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x2, 0x7, 0x1 }, // 6536
  { IMAGE_SAMPLE_C_CD_O_G16_V2_V8_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 6537
  { IMAGE_SAMPLE_C_CD_O_G16_V2_V9_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x2, 0x9, 0x1 }, // 6538
  { IMAGE_SAMPLE_C_CD_O_G16_V3_V4_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 6539
  { IMAGE_SAMPLE_C_CD_O_G16_V3_V5_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 6540
  { IMAGE_SAMPLE_C_CD_O_G16_V3_V6_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 6541
  { IMAGE_SAMPLE_C_CD_O_G16_V3_V7_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x3, 0x7, 0x1 }, // 6542
  { IMAGE_SAMPLE_C_CD_O_G16_V3_V8_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 6543
  { IMAGE_SAMPLE_C_CD_O_G16_V3_V9_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x3, 0x9, 0x1 }, // 6544
  { IMAGE_SAMPLE_C_CD_O_G16_V4_V4_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 6545
  { IMAGE_SAMPLE_C_CD_O_G16_V4_V5_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 6546
  { IMAGE_SAMPLE_C_CD_O_G16_V4_V6_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 6547
  { IMAGE_SAMPLE_C_CD_O_G16_V4_V7_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x4, 0x7, 0x1 }, // 6548
  { IMAGE_SAMPLE_C_CD_O_G16_V4_V8_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 6549
  { IMAGE_SAMPLE_C_CD_O_G16_V4_V9_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x4, 0x9, 0x1 }, // 6550
  { IMAGE_SAMPLE_C_CD_O_G16_V5_V4_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 6551
  { IMAGE_SAMPLE_C_CD_O_G16_V5_V5_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 6552
  { IMAGE_SAMPLE_C_CD_O_G16_V5_V6_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 6553
  { IMAGE_SAMPLE_C_CD_O_G16_V5_V7_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x5, 0x7, 0x1 }, // 6554
  { IMAGE_SAMPLE_C_CD_O_G16_V5_V8_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 6555
  { IMAGE_SAMPLE_C_CD_O_G16_V5_V9_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10Default, 0x5, 0x9, 0x1 }, // 6556
  { IMAGE_SAMPLE_C_CD_O_G16_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 6557
  { IMAGE_SAMPLE_C_CD_O_G16_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 6558
  { IMAGE_SAMPLE_C_CD_O_G16_V1_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 6559
  { IMAGE_SAMPLE_C_CD_O_G16_V1_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x1, 0x7, 0x7 }, // 6560
  { IMAGE_SAMPLE_C_CD_O_G16_V1_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x1, 0x8, 0x8 }, // 6561
  { IMAGE_SAMPLE_C_CD_O_G16_V1_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x1, 0x9, 0x9 }, // 6562
  { IMAGE_SAMPLE_C_CD_O_G16_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 6563
  { IMAGE_SAMPLE_C_CD_O_G16_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 6564
  { IMAGE_SAMPLE_C_CD_O_G16_V2_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 6565
  { IMAGE_SAMPLE_C_CD_O_G16_V2_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x2, 0x7, 0x7 }, // 6566
  { IMAGE_SAMPLE_C_CD_O_G16_V2_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x2, 0x8, 0x8 }, // 6567
  { IMAGE_SAMPLE_C_CD_O_G16_V2_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x2, 0x9, 0x9 }, // 6568
  { IMAGE_SAMPLE_C_CD_O_G16_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 6569
  { IMAGE_SAMPLE_C_CD_O_G16_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 6570
  { IMAGE_SAMPLE_C_CD_O_G16_V3_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 6571
  { IMAGE_SAMPLE_C_CD_O_G16_V3_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x3, 0x7, 0x7 }, // 6572
  { IMAGE_SAMPLE_C_CD_O_G16_V3_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x3, 0x8, 0x8 }, // 6573
  { IMAGE_SAMPLE_C_CD_O_G16_V3_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x3, 0x9, 0x9 }, // 6574
  { IMAGE_SAMPLE_C_CD_O_G16_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 6575
  { IMAGE_SAMPLE_C_CD_O_G16_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 6576
  { IMAGE_SAMPLE_C_CD_O_G16_V4_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 6577
  { IMAGE_SAMPLE_C_CD_O_G16_V4_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x4, 0x7, 0x7 }, // 6578
  { IMAGE_SAMPLE_C_CD_O_G16_V4_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x4, 0x8, 0x8 }, // 6579
  { IMAGE_SAMPLE_C_CD_O_G16_V4_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x4, 0x9, 0x9 }, // 6580
  { IMAGE_SAMPLE_C_CD_O_G16_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 6581
  { IMAGE_SAMPLE_C_CD_O_G16_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 6582
  { IMAGE_SAMPLE_C_CD_O_G16_V5_V6_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 6583
  { IMAGE_SAMPLE_C_CD_O_G16_V5_V7_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x5, 0x7, 0x7 }, // 6584
  { IMAGE_SAMPLE_C_CD_O_G16_V5_V8_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x5, 0x8, 0x8 }, // 6585
  { IMAGE_SAMPLE_C_CD_O_G16_V5_V9_nsa_gfx10, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx10NSA, 0x5, 0x9, 0x9 }, // 6586
  { IMAGE_SAMPLE_C_CD_O_G16_V1_V4, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 6587
  { IMAGE_SAMPLE_C_CD_O_G16_V1_V5, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 6588
  { IMAGE_SAMPLE_C_CD_O_G16_V1_V6, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 6589
  { IMAGE_SAMPLE_C_CD_O_G16_V1_V7, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x1, 0x7, 0x1 }, // 6590
  { IMAGE_SAMPLE_C_CD_O_G16_V1_V8, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 6591
  { IMAGE_SAMPLE_C_CD_O_G16_V1_V9, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x1, 0x9, 0x1 }, // 6592
  { IMAGE_SAMPLE_C_CD_O_G16_V2_V4, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 6593
  { IMAGE_SAMPLE_C_CD_O_G16_V2_V5, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 6594
  { IMAGE_SAMPLE_C_CD_O_G16_V2_V6, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 6595
  { IMAGE_SAMPLE_C_CD_O_G16_V2_V7, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x2, 0x7, 0x1 }, // 6596
  { IMAGE_SAMPLE_C_CD_O_G16_V2_V8, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 6597
  { IMAGE_SAMPLE_C_CD_O_G16_V2_V9, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x2, 0x9, 0x1 }, // 6598
  { IMAGE_SAMPLE_C_CD_O_G16_V3_V4, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 6599
  { IMAGE_SAMPLE_C_CD_O_G16_V3_V5, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 6600
  { IMAGE_SAMPLE_C_CD_O_G16_V3_V6, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 6601
  { IMAGE_SAMPLE_C_CD_O_G16_V3_V7, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x3, 0x7, 0x1 }, // 6602
  { IMAGE_SAMPLE_C_CD_O_G16_V3_V8, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 6603
  { IMAGE_SAMPLE_C_CD_O_G16_V3_V9, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x3, 0x9, 0x1 }, // 6604
  { IMAGE_SAMPLE_C_CD_O_G16_V4_V4, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 6605
  { IMAGE_SAMPLE_C_CD_O_G16_V4_V5, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 6606
  { IMAGE_SAMPLE_C_CD_O_G16_V4_V6, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 6607
  { IMAGE_SAMPLE_C_CD_O_G16_V4_V7, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x4, 0x7, 0x1 }, // 6608
  { IMAGE_SAMPLE_C_CD_O_G16_V4_V8, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 6609
  { IMAGE_SAMPLE_C_CD_O_G16_V4_V9, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x4, 0x9, 0x1 }, // 6610
  { IMAGE_SAMPLE_C_CD_O_G16_V5_V4, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 6611
  { IMAGE_SAMPLE_C_CD_O_G16_V5_V5, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 6612
  { IMAGE_SAMPLE_C_CD_O_G16_V5_V6, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 6613
  { IMAGE_SAMPLE_C_CD_O_G16_V5_V7, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x5, 0x7, 0x1 }, // 6614
  { IMAGE_SAMPLE_C_CD_O_G16_V5_V8, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 6615
  { IMAGE_SAMPLE_C_CD_O_G16_V5_V9, IMAGE_SAMPLE_C_CD_O_G16, MIMGEncGfx6, 0x5, 0x9, 0x1 }, // 6616
  { IMAGE_SAMPLE_C_CL_V1_V2_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 6617
  { IMAGE_SAMPLE_C_CL_V1_V3_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 6618
  { IMAGE_SAMPLE_C_CL_V1_V4_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 6619
  { IMAGE_SAMPLE_C_CL_V1_V5_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 6620
  { IMAGE_SAMPLE_C_CL_V1_V8_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 6621
  { IMAGE_SAMPLE_C_CL_V2_V2_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 6622
  { IMAGE_SAMPLE_C_CL_V2_V3_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 6623
  { IMAGE_SAMPLE_C_CL_V2_V4_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 6624
  { IMAGE_SAMPLE_C_CL_V2_V5_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 6625
  { IMAGE_SAMPLE_C_CL_V2_V8_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 6626
  { IMAGE_SAMPLE_C_CL_V3_V2_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 6627
  { IMAGE_SAMPLE_C_CL_V3_V3_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 6628
  { IMAGE_SAMPLE_C_CL_V3_V4_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 6629
  { IMAGE_SAMPLE_C_CL_V3_V5_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 6630
  { IMAGE_SAMPLE_C_CL_V3_V8_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 6631
  { IMAGE_SAMPLE_C_CL_V4_V2_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 6632
  { IMAGE_SAMPLE_C_CL_V4_V3_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 6633
  { IMAGE_SAMPLE_C_CL_V4_V4_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 6634
  { IMAGE_SAMPLE_C_CL_V4_V5_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 6635
  { IMAGE_SAMPLE_C_CL_V4_V8_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 6636
  { IMAGE_SAMPLE_C_CL_V5_V2_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 6637
  { IMAGE_SAMPLE_C_CL_V5_V3_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 6638
  { IMAGE_SAMPLE_C_CL_V5_V4_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 6639
  { IMAGE_SAMPLE_C_CL_V5_V5_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 6640
  { IMAGE_SAMPLE_C_CL_V5_V8_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 6641
  { IMAGE_SAMPLE_C_CL_V1_V2_nsa_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 6642
  { IMAGE_SAMPLE_C_CL_V1_V3_nsa_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 6643
  { IMAGE_SAMPLE_C_CL_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 6644
  { IMAGE_SAMPLE_C_CL_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 6645
  { IMAGE_SAMPLE_C_CL_V2_V2_nsa_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 6646
  { IMAGE_SAMPLE_C_CL_V2_V3_nsa_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 6647
  { IMAGE_SAMPLE_C_CL_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 6648
  { IMAGE_SAMPLE_C_CL_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 6649
  { IMAGE_SAMPLE_C_CL_V3_V2_nsa_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 6650
  { IMAGE_SAMPLE_C_CL_V3_V3_nsa_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 6651
  { IMAGE_SAMPLE_C_CL_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 6652
  { IMAGE_SAMPLE_C_CL_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 6653
  { IMAGE_SAMPLE_C_CL_V4_V2_nsa_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 6654
  { IMAGE_SAMPLE_C_CL_V4_V3_nsa_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 6655
  { IMAGE_SAMPLE_C_CL_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 6656
  { IMAGE_SAMPLE_C_CL_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 6657
  { IMAGE_SAMPLE_C_CL_V5_V2_nsa_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 6658
  { IMAGE_SAMPLE_C_CL_V5_V3_nsa_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 6659
  { IMAGE_SAMPLE_C_CL_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 6660
  { IMAGE_SAMPLE_C_CL_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_CL, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 6661
  { IMAGE_SAMPLE_C_CL_V1_V2_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 6662
  { IMAGE_SAMPLE_C_CL_V1_V3_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 6663
  { IMAGE_SAMPLE_C_CL_V1_V4_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 6664
  { IMAGE_SAMPLE_C_CL_V1_V5_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11Default, 0x1, 0x5, 0x1 }, // 6665
  { IMAGE_SAMPLE_C_CL_V1_V8_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11Default, 0x1, 0x8, 0x1 }, // 6666
  { IMAGE_SAMPLE_C_CL_V2_V2_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 6667
  { IMAGE_SAMPLE_C_CL_V2_V3_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 6668
  { IMAGE_SAMPLE_C_CL_V2_V4_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 6669
  { IMAGE_SAMPLE_C_CL_V2_V5_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 6670
  { IMAGE_SAMPLE_C_CL_V2_V8_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 6671
  { IMAGE_SAMPLE_C_CL_V3_V2_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 6672
  { IMAGE_SAMPLE_C_CL_V3_V3_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 6673
  { IMAGE_SAMPLE_C_CL_V3_V4_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 6674
  { IMAGE_SAMPLE_C_CL_V3_V5_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11Default, 0x3, 0x5, 0x1 }, // 6675
  { IMAGE_SAMPLE_C_CL_V3_V8_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11Default, 0x3, 0x8, 0x1 }, // 6676
  { IMAGE_SAMPLE_C_CL_V4_V2_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 6677
  { IMAGE_SAMPLE_C_CL_V4_V3_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 6678
  { IMAGE_SAMPLE_C_CL_V4_V4_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 6679
  { IMAGE_SAMPLE_C_CL_V4_V5_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 6680
  { IMAGE_SAMPLE_C_CL_V4_V8_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 6681
  { IMAGE_SAMPLE_C_CL_V5_V2_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 6682
  { IMAGE_SAMPLE_C_CL_V5_V3_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 6683
  { IMAGE_SAMPLE_C_CL_V5_V4_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 6684
  { IMAGE_SAMPLE_C_CL_V5_V5_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 6685
  { IMAGE_SAMPLE_C_CL_V5_V8_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 6686
  { IMAGE_SAMPLE_C_CL_V1_V2_nsa_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 6687
  { IMAGE_SAMPLE_C_CL_V1_V3_nsa_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 6688
  { IMAGE_SAMPLE_C_CL_V1_V4_nsa_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 6689
  { IMAGE_SAMPLE_C_CL_V1_V5_nsa_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11NSA, 0x1, 0x5, 0x5 }, // 6690
  { IMAGE_SAMPLE_C_CL_V2_V2_nsa_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 6691
  { IMAGE_SAMPLE_C_CL_V2_V3_nsa_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 6692
  { IMAGE_SAMPLE_C_CL_V2_V4_nsa_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 6693
  { IMAGE_SAMPLE_C_CL_V2_V5_nsa_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 6694
  { IMAGE_SAMPLE_C_CL_V3_V2_nsa_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 6695
  { IMAGE_SAMPLE_C_CL_V3_V3_nsa_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 6696
  { IMAGE_SAMPLE_C_CL_V3_V4_nsa_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 6697
  { IMAGE_SAMPLE_C_CL_V3_V5_nsa_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11NSA, 0x3, 0x5, 0x5 }, // 6698
  { IMAGE_SAMPLE_C_CL_V4_V2_nsa_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 6699
  { IMAGE_SAMPLE_C_CL_V4_V3_nsa_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 6700
  { IMAGE_SAMPLE_C_CL_V4_V4_nsa_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 6701
  { IMAGE_SAMPLE_C_CL_V4_V5_nsa_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 6702
  { IMAGE_SAMPLE_C_CL_V5_V2_nsa_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 6703
  { IMAGE_SAMPLE_C_CL_V5_V3_nsa_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 6704
  { IMAGE_SAMPLE_C_CL_V5_V4_nsa_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 6705
  { IMAGE_SAMPLE_C_CL_V5_V5_nsa_gfx11, IMAGE_SAMPLE_C_CL, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 6706
  { IMAGE_SAMPLE_C_CL_V1_V2_gfx12, IMAGE_SAMPLE_C_CL, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 6707
  { IMAGE_SAMPLE_C_CL_V1_V3_gfx12, IMAGE_SAMPLE_C_CL, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 6708
  { IMAGE_SAMPLE_C_CL_V1_V4_gfx12, IMAGE_SAMPLE_C_CL, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 6709
  { IMAGE_SAMPLE_C_CL_V1_V5_gfx12, IMAGE_SAMPLE_C_CL, MIMGEncGfx12, 0x1, 0x5, 0x5 }, // 6710
  { IMAGE_SAMPLE_C_CL_V2_V2_gfx12, IMAGE_SAMPLE_C_CL, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 6711
  { IMAGE_SAMPLE_C_CL_V2_V3_gfx12, IMAGE_SAMPLE_C_CL, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 6712
  { IMAGE_SAMPLE_C_CL_V2_V4_gfx12, IMAGE_SAMPLE_C_CL, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 6713
  { IMAGE_SAMPLE_C_CL_V2_V5_gfx12, IMAGE_SAMPLE_C_CL, MIMGEncGfx12, 0x2, 0x5, 0x5 }, // 6714
  { IMAGE_SAMPLE_C_CL_V3_V2_gfx12, IMAGE_SAMPLE_C_CL, MIMGEncGfx12, 0x3, 0x2, 0x2 }, // 6715
  { IMAGE_SAMPLE_C_CL_V3_V3_gfx12, IMAGE_SAMPLE_C_CL, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 6716
  { IMAGE_SAMPLE_C_CL_V3_V4_gfx12, IMAGE_SAMPLE_C_CL, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 6717
  { IMAGE_SAMPLE_C_CL_V3_V5_gfx12, IMAGE_SAMPLE_C_CL, MIMGEncGfx12, 0x3, 0x5, 0x5 }, // 6718
  { IMAGE_SAMPLE_C_CL_V4_V2_gfx12, IMAGE_SAMPLE_C_CL, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 6719
  { IMAGE_SAMPLE_C_CL_V4_V3_gfx12, IMAGE_SAMPLE_C_CL, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 6720
  { IMAGE_SAMPLE_C_CL_V4_V4_gfx12, IMAGE_SAMPLE_C_CL, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 6721
  { IMAGE_SAMPLE_C_CL_V4_V5_gfx12, IMAGE_SAMPLE_C_CL, MIMGEncGfx12, 0x4, 0x5, 0x5 }, // 6722
  { IMAGE_SAMPLE_C_CL_V5_V2_gfx12, IMAGE_SAMPLE_C_CL, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 6723
  { IMAGE_SAMPLE_C_CL_V5_V3_gfx12, IMAGE_SAMPLE_C_CL, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 6724
  { IMAGE_SAMPLE_C_CL_V5_V4_gfx12, IMAGE_SAMPLE_C_CL, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 6725
  { IMAGE_SAMPLE_C_CL_V5_V5_gfx12, IMAGE_SAMPLE_C_CL, MIMGEncGfx12, 0x5, 0x5, 0x5 }, // 6726
  { IMAGE_SAMPLE_C_CL_V1_V2, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 6727
  { IMAGE_SAMPLE_C_CL_V1_V3, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 6728
  { IMAGE_SAMPLE_C_CL_V1_V4, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 6729
  { IMAGE_SAMPLE_C_CL_V1_V5, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 6730
  { IMAGE_SAMPLE_C_CL_V1_V8, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 6731
  { IMAGE_SAMPLE_C_CL_V2_V2, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 6732
  { IMAGE_SAMPLE_C_CL_V2_V3, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 6733
  { IMAGE_SAMPLE_C_CL_V2_V4, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 6734
  { IMAGE_SAMPLE_C_CL_V2_V5, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 6735
  { IMAGE_SAMPLE_C_CL_V2_V8, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 6736
  { IMAGE_SAMPLE_C_CL_V3_V2, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 6737
  { IMAGE_SAMPLE_C_CL_V3_V3, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 6738
  { IMAGE_SAMPLE_C_CL_V3_V4, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 6739
  { IMAGE_SAMPLE_C_CL_V3_V5, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 6740
  { IMAGE_SAMPLE_C_CL_V3_V8, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 6741
  { IMAGE_SAMPLE_C_CL_V4_V2, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 6742
  { IMAGE_SAMPLE_C_CL_V4_V3, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 6743
  { IMAGE_SAMPLE_C_CL_V4_V4, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 6744
  { IMAGE_SAMPLE_C_CL_V4_V5, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 6745
  { IMAGE_SAMPLE_C_CL_V4_V8, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 6746
  { IMAGE_SAMPLE_C_CL_V5_V2, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 6747
  { IMAGE_SAMPLE_C_CL_V5_V3, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 6748
  { IMAGE_SAMPLE_C_CL_V5_V4, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 6749
  { IMAGE_SAMPLE_C_CL_V5_V5, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 6750
  { IMAGE_SAMPLE_C_CL_V5_V8, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 6751
  { IMAGE_SAMPLE_C_CL_O_V1_V3_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 6752
  { IMAGE_SAMPLE_C_CL_O_V1_V4_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 6753
  { IMAGE_SAMPLE_C_CL_O_V1_V5_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 6754
  { IMAGE_SAMPLE_C_CL_O_V1_V6_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 6755
  { IMAGE_SAMPLE_C_CL_O_V1_V8_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 6756
  { IMAGE_SAMPLE_C_CL_O_V2_V3_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 6757
  { IMAGE_SAMPLE_C_CL_O_V2_V4_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 6758
  { IMAGE_SAMPLE_C_CL_O_V2_V5_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 6759
  { IMAGE_SAMPLE_C_CL_O_V2_V6_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 6760
  { IMAGE_SAMPLE_C_CL_O_V2_V8_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 6761
  { IMAGE_SAMPLE_C_CL_O_V3_V3_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 6762
  { IMAGE_SAMPLE_C_CL_O_V3_V4_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 6763
  { IMAGE_SAMPLE_C_CL_O_V3_V5_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 6764
  { IMAGE_SAMPLE_C_CL_O_V3_V6_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 6765
  { IMAGE_SAMPLE_C_CL_O_V3_V8_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 6766
  { IMAGE_SAMPLE_C_CL_O_V4_V3_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 6767
  { IMAGE_SAMPLE_C_CL_O_V4_V4_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 6768
  { IMAGE_SAMPLE_C_CL_O_V4_V5_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 6769
  { IMAGE_SAMPLE_C_CL_O_V4_V6_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 6770
  { IMAGE_SAMPLE_C_CL_O_V4_V8_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 6771
  { IMAGE_SAMPLE_C_CL_O_V5_V3_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 6772
  { IMAGE_SAMPLE_C_CL_O_V5_V4_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 6773
  { IMAGE_SAMPLE_C_CL_O_V5_V5_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 6774
  { IMAGE_SAMPLE_C_CL_O_V5_V6_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 6775
  { IMAGE_SAMPLE_C_CL_O_V5_V8_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 6776
  { IMAGE_SAMPLE_C_CL_O_V1_V3_nsa_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 6777
  { IMAGE_SAMPLE_C_CL_O_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 6778
  { IMAGE_SAMPLE_C_CL_O_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 6779
  { IMAGE_SAMPLE_C_CL_O_V1_V6_nsa_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 6780
  { IMAGE_SAMPLE_C_CL_O_V2_V3_nsa_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 6781
  { IMAGE_SAMPLE_C_CL_O_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 6782
  { IMAGE_SAMPLE_C_CL_O_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 6783
  { IMAGE_SAMPLE_C_CL_O_V2_V6_nsa_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 6784
  { IMAGE_SAMPLE_C_CL_O_V3_V3_nsa_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 6785
  { IMAGE_SAMPLE_C_CL_O_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 6786
  { IMAGE_SAMPLE_C_CL_O_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 6787
  { IMAGE_SAMPLE_C_CL_O_V3_V6_nsa_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 6788
  { IMAGE_SAMPLE_C_CL_O_V4_V3_nsa_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 6789
  { IMAGE_SAMPLE_C_CL_O_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 6790
  { IMAGE_SAMPLE_C_CL_O_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 6791
  { IMAGE_SAMPLE_C_CL_O_V4_V6_nsa_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 6792
  { IMAGE_SAMPLE_C_CL_O_V5_V3_nsa_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 6793
  { IMAGE_SAMPLE_C_CL_O_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 6794
  { IMAGE_SAMPLE_C_CL_O_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 6795
  { IMAGE_SAMPLE_C_CL_O_V5_V6_nsa_gfx10, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 6796
  { IMAGE_SAMPLE_C_CL_O_V1_V3_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 6797
  { IMAGE_SAMPLE_C_CL_O_V1_V4_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 6798
  { IMAGE_SAMPLE_C_CL_O_V1_V5_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11Default, 0x1, 0x5, 0x1 }, // 6799
  { IMAGE_SAMPLE_C_CL_O_V1_V6_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11Default, 0x1, 0x6, 0x1 }, // 6800
  { IMAGE_SAMPLE_C_CL_O_V1_V8_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11Default, 0x1, 0x8, 0x1 }, // 6801
  { IMAGE_SAMPLE_C_CL_O_V2_V3_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 6802
  { IMAGE_SAMPLE_C_CL_O_V2_V4_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 6803
  { IMAGE_SAMPLE_C_CL_O_V2_V5_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 6804
  { IMAGE_SAMPLE_C_CL_O_V2_V6_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11Default, 0x2, 0x6, 0x1 }, // 6805
  { IMAGE_SAMPLE_C_CL_O_V2_V8_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 6806
  { IMAGE_SAMPLE_C_CL_O_V3_V3_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 6807
  { IMAGE_SAMPLE_C_CL_O_V3_V4_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 6808
  { IMAGE_SAMPLE_C_CL_O_V3_V5_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11Default, 0x3, 0x5, 0x1 }, // 6809
  { IMAGE_SAMPLE_C_CL_O_V3_V6_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11Default, 0x3, 0x6, 0x1 }, // 6810
  { IMAGE_SAMPLE_C_CL_O_V3_V8_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11Default, 0x3, 0x8, 0x1 }, // 6811
  { IMAGE_SAMPLE_C_CL_O_V4_V3_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 6812
  { IMAGE_SAMPLE_C_CL_O_V4_V4_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 6813
  { IMAGE_SAMPLE_C_CL_O_V4_V5_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 6814
  { IMAGE_SAMPLE_C_CL_O_V4_V6_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11Default, 0x4, 0x6, 0x1 }, // 6815
  { IMAGE_SAMPLE_C_CL_O_V4_V8_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 6816
  { IMAGE_SAMPLE_C_CL_O_V5_V3_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 6817
  { IMAGE_SAMPLE_C_CL_O_V5_V4_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 6818
  { IMAGE_SAMPLE_C_CL_O_V5_V5_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 6819
  { IMAGE_SAMPLE_C_CL_O_V5_V6_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11Default, 0x5, 0x6, 0x1 }, // 6820
  { IMAGE_SAMPLE_C_CL_O_V5_V8_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 6821
  { IMAGE_SAMPLE_C_CL_O_V1_V3_nsa_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 6822
  { IMAGE_SAMPLE_C_CL_O_V1_V4_nsa_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 6823
  { IMAGE_SAMPLE_C_CL_O_V1_V5_nsa_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11NSA, 0x1, 0x5, 0x5 }, // 6824
  { IMAGE_SAMPLE_C_CL_O_V1_V6_nsa_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11NSA, 0x1, 0x6, 0x6 }, // 6825
  { IMAGE_SAMPLE_C_CL_O_V2_V3_nsa_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 6826
  { IMAGE_SAMPLE_C_CL_O_V2_V4_nsa_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 6827
  { IMAGE_SAMPLE_C_CL_O_V2_V5_nsa_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 6828
  { IMAGE_SAMPLE_C_CL_O_V2_V6_nsa_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11NSA, 0x2, 0x6, 0x6 }, // 6829
  { IMAGE_SAMPLE_C_CL_O_V3_V3_nsa_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 6830
  { IMAGE_SAMPLE_C_CL_O_V3_V4_nsa_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 6831
  { IMAGE_SAMPLE_C_CL_O_V3_V5_nsa_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11NSA, 0x3, 0x5, 0x5 }, // 6832
  { IMAGE_SAMPLE_C_CL_O_V3_V6_nsa_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11NSA, 0x3, 0x6, 0x6 }, // 6833
  { IMAGE_SAMPLE_C_CL_O_V4_V3_nsa_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 6834
  { IMAGE_SAMPLE_C_CL_O_V4_V4_nsa_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 6835
  { IMAGE_SAMPLE_C_CL_O_V4_V5_nsa_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 6836
  { IMAGE_SAMPLE_C_CL_O_V4_V6_nsa_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11NSA, 0x4, 0x6, 0x6 }, // 6837
  { IMAGE_SAMPLE_C_CL_O_V5_V3_nsa_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 6838
  { IMAGE_SAMPLE_C_CL_O_V5_V4_nsa_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 6839
  { IMAGE_SAMPLE_C_CL_O_V5_V5_nsa_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 6840
  { IMAGE_SAMPLE_C_CL_O_V5_V6_nsa_gfx11, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx11NSA, 0x5, 0x6, 0x6 }, // 6841
  { IMAGE_SAMPLE_C_CL_O_V1_V3_gfx12, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 6842
  { IMAGE_SAMPLE_C_CL_O_V1_V4_gfx12, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 6843
  { IMAGE_SAMPLE_C_CL_O_V1_V5_gfx12, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx12, 0x1, 0x5, 0x5 }, // 6844
  { IMAGE_SAMPLE_C_CL_O_V1_V6_gfx12, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx12, 0x1, 0x6, 0x6 }, // 6845
  { IMAGE_SAMPLE_C_CL_O_V2_V3_gfx12, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 6846
  { IMAGE_SAMPLE_C_CL_O_V2_V4_gfx12, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 6847
  { IMAGE_SAMPLE_C_CL_O_V2_V5_gfx12, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx12, 0x2, 0x5, 0x5 }, // 6848
  { IMAGE_SAMPLE_C_CL_O_V2_V6_gfx12, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx12, 0x2, 0x6, 0x6 }, // 6849
  { IMAGE_SAMPLE_C_CL_O_V3_V3_gfx12, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 6850
  { IMAGE_SAMPLE_C_CL_O_V3_V4_gfx12, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 6851
  { IMAGE_SAMPLE_C_CL_O_V3_V5_gfx12, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx12, 0x3, 0x5, 0x5 }, // 6852
  { IMAGE_SAMPLE_C_CL_O_V3_V6_gfx12, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx12, 0x3, 0x6, 0x6 }, // 6853
  { IMAGE_SAMPLE_C_CL_O_V4_V3_gfx12, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 6854
  { IMAGE_SAMPLE_C_CL_O_V4_V4_gfx12, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 6855
  { IMAGE_SAMPLE_C_CL_O_V4_V5_gfx12, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx12, 0x4, 0x5, 0x5 }, // 6856
  { IMAGE_SAMPLE_C_CL_O_V4_V6_gfx12, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx12, 0x4, 0x6, 0x6 }, // 6857
  { IMAGE_SAMPLE_C_CL_O_V5_V3_gfx12, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 6858
  { IMAGE_SAMPLE_C_CL_O_V5_V4_gfx12, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 6859
  { IMAGE_SAMPLE_C_CL_O_V5_V5_gfx12, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx12, 0x5, 0x5, 0x5 }, // 6860
  { IMAGE_SAMPLE_C_CL_O_V5_V6_gfx12, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx12, 0x5, 0x6, 0x6 }, // 6861
  { IMAGE_SAMPLE_C_CL_O_V1_V3, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 6862
  { IMAGE_SAMPLE_C_CL_O_V1_V4, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 6863
  { IMAGE_SAMPLE_C_CL_O_V1_V5, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 6864
  { IMAGE_SAMPLE_C_CL_O_V1_V6, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 6865
  { IMAGE_SAMPLE_C_CL_O_V1_V8, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 6866
  { IMAGE_SAMPLE_C_CL_O_V2_V3, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 6867
  { IMAGE_SAMPLE_C_CL_O_V2_V4, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 6868
  { IMAGE_SAMPLE_C_CL_O_V2_V5, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 6869
  { IMAGE_SAMPLE_C_CL_O_V2_V6, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 6870
  { IMAGE_SAMPLE_C_CL_O_V2_V8, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 6871
  { IMAGE_SAMPLE_C_CL_O_V3_V3, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 6872
  { IMAGE_SAMPLE_C_CL_O_V3_V4, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 6873
  { IMAGE_SAMPLE_C_CL_O_V3_V5, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 6874
  { IMAGE_SAMPLE_C_CL_O_V3_V6, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 6875
  { IMAGE_SAMPLE_C_CL_O_V3_V8, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 6876
  { IMAGE_SAMPLE_C_CL_O_V4_V3, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 6877
  { IMAGE_SAMPLE_C_CL_O_V4_V4, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 6878
  { IMAGE_SAMPLE_C_CL_O_V4_V5, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 6879
  { IMAGE_SAMPLE_C_CL_O_V4_V6, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 6880
  { IMAGE_SAMPLE_C_CL_O_V4_V8, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 6881
  { IMAGE_SAMPLE_C_CL_O_V5_V3, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 6882
  { IMAGE_SAMPLE_C_CL_O_V5_V4, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 6883
  { IMAGE_SAMPLE_C_CL_O_V5_V5, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 6884
  { IMAGE_SAMPLE_C_CL_O_V5_V6, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 6885
  { IMAGE_SAMPLE_C_CL_O_V5_V8, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 6886
  { IMAGE_SAMPLE_C_D_V1_V3_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 6887
  { IMAGE_SAMPLE_C_D_V1_V4_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 6888
  { IMAGE_SAMPLE_C_D_V1_V5_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 6889
  { IMAGE_SAMPLE_C_D_V1_V6_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 6890
  { IMAGE_SAMPLE_C_D_V1_V7_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x1, 0x7, 0x1 }, // 6891
  { IMAGE_SAMPLE_C_D_V1_V8_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 6892
  { IMAGE_SAMPLE_C_D_V1_V9_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x1, 0x9, 0x1 }, // 6893
  { IMAGE_SAMPLE_C_D_V1_V10_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x1, 0xA, 0x1 }, // 6894
  { IMAGE_SAMPLE_C_D_V2_V3_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 6895
  { IMAGE_SAMPLE_C_D_V2_V4_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 6896
  { IMAGE_SAMPLE_C_D_V2_V5_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 6897
  { IMAGE_SAMPLE_C_D_V2_V6_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 6898
  { IMAGE_SAMPLE_C_D_V2_V7_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x2, 0x7, 0x1 }, // 6899
  { IMAGE_SAMPLE_C_D_V2_V8_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 6900
  { IMAGE_SAMPLE_C_D_V2_V9_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x2, 0x9, 0x1 }, // 6901
  { IMAGE_SAMPLE_C_D_V2_V10_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x2, 0xA, 0x1 }, // 6902
  { IMAGE_SAMPLE_C_D_V3_V3_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 6903
  { IMAGE_SAMPLE_C_D_V3_V4_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 6904
  { IMAGE_SAMPLE_C_D_V3_V5_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 6905
  { IMAGE_SAMPLE_C_D_V3_V6_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 6906
  { IMAGE_SAMPLE_C_D_V3_V7_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x3, 0x7, 0x1 }, // 6907
  { IMAGE_SAMPLE_C_D_V3_V8_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 6908
  { IMAGE_SAMPLE_C_D_V3_V9_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x3, 0x9, 0x1 }, // 6909
  { IMAGE_SAMPLE_C_D_V3_V10_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x3, 0xA, 0x1 }, // 6910
  { IMAGE_SAMPLE_C_D_V4_V3_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 6911
  { IMAGE_SAMPLE_C_D_V4_V4_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 6912
  { IMAGE_SAMPLE_C_D_V4_V5_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 6913
  { IMAGE_SAMPLE_C_D_V4_V6_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 6914
  { IMAGE_SAMPLE_C_D_V4_V7_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x4, 0x7, 0x1 }, // 6915
  { IMAGE_SAMPLE_C_D_V4_V8_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 6916
  { IMAGE_SAMPLE_C_D_V4_V9_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x4, 0x9, 0x1 }, // 6917
  { IMAGE_SAMPLE_C_D_V4_V10_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x4, 0xA, 0x1 }, // 6918
  { IMAGE_SAMPLE_C_D_V5_V3_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 6919
  { IMAGE_SAMPLE_C_D_V5_V4_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 6920
  { IMAGE_SAMPLE_C_D_V5_V5_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 6921
  { IMAGE_SAMPLE_C_D_V5_V6_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 6922
  { IMAGE_SAMPLE_C_D_V5_V7_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x5, 0x7, 0x1 }, // 6923
  { IMAGE_SAMPLE_C_D_V5_V8_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 6924
  { IMAGE_SAMPLE_C_D_V5_V9_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x5, 0x9, 0x1 }, // 6925
  { IMAGE_SAMPLE_C_D_V5_V10_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10Default, 0x5, 0xA, 0x1 }, // 6926
  { IMAGE_SAMPLE_C_D_V1_V3_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 6927
  { IMAGE_SAMPLE_C_D_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 6928
  { IMAGE_SAMPLE_C_D_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 6929
  { IMAGE_SAMPLE_C_D_V1_V6_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 6930
  { IMAGE_SAMPLE_C_D_V1_V7_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x1, 0x7, 0x7 }, // 6931
  { IMAGE_SAMPLE_C_D_V1_V8_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x1, 0x8, 0x8 }, // 6932
  { IMAGE_SAMPLE_C_D_V1_V9_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x1, 0x9, 0x9 }, // 6933
  { IMAGE_SAMPLE_C_D_V1_V10_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x1, 0xA, 0xA }, // 6934
  { IMAGE_SAMPLE_C_D_V2_V3_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 6935
  { IMAGE_SAMPLE_C_D_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 6936
  { IMAGE_SAMPLE_C_D_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 6937
  { IMAGE_SAMPLE_C_D_V2_V6_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 6938
  { IMAGE_SAMPLE_C_D_V2_V7_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x2, 0x7, 0x7 }, // 6939
  { IMAGE_SAMPLE_C_D_V2_V8_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x2, 0x8, 0x8 }, // 6940
  { IMAGE_SAMPLE_C_D_V2_V9_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x2, 0x9, 0x9 }, // 6941
  { IMAGE_SAMPLE_C_D_V2_V10_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x2, 0xA, 0xA }, // 6942
  { IMAGE_SAMPLE_C_D_V3_V3_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 6943
  { IMAGE_SAMPLE_C_D_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 6944
  { IMAGE_SAMPLE_C_D_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 6945
  { IMAGE_SAMPLE_C_D_V3_V6_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 6946
  { IMAGE_SAMPLE_C_D_V3_V7_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x3, 0x7, 0x7 }, // 6947
  { IMAGE_SAMPLE_C_D_V3_V8_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x3, 0x8, 0x8 }, // 6948
  { IMAGE_SAMPLE_C_D_V3_V9_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x3, 0x9, 0x9 }, // 6949
  { IMAGE_SAMPLE_C_D_V3_V10_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x3, 0xA, 0xA }, // 6950
  { IMAGE_SAMPLE_C_D_V4_V3_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 6951
  { IMAGE_SAMPLE_C_D_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 6952
  { IMAGE_SAMPLE_C_D_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 6953
  { IMAGE_SAMPLE_C_D_V4_V6_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 6954
  { IMAGE_SAMPLE_C_D_V4_V7_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x4, 0x7, 0x7 }, // 6955
  { IMAGE_SAMPLE_C_D_V4_V8_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x4, 0x8, 0x8 }, // 6956
  { IMAGE_SAMPLE_C_D_V4_V9_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x4, 0x9, 0x9 }, // 6957
  { IMAGE_SAMPLE_C_D_V4_V10_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x4, 0xA, 0xA }, // 6958
  { IMAGE_SAMPLE_C_D_V5_V3_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 6959
  { IMAGE_SAMPLE_C_D_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 6960
  { IMAGE_SAMPLE_C_D_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 6961
  { IMAGE_SAMPLE_C_D_V5_V6_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 6962
  { IMAGE_SAMPLE_C_D_V5_V7_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x5, 0x7, 0x7 }, // 6963
  { IMAGE_SAMPLE_C_D_V5_V8_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x5, 0x8, 0x8 }, // 6964
  { IMAGE_SAMPLE_C_D_V5_V9_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x5, 0x9, 0x9 }, // 6965
  { IMAGE_SAMPLE_C_D_V5_V10_nsa_gfx10, IMAGE_SAMPLE_C_D, MIMGEncGfx10NSA, 0x5, 0xA, 0xA }, // 6966
  { IMAGE_SAMPLE_C_D_V1_V3_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 6967
  { IMAGE_SAMPLE_C_D_V1_V4_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 6968
  { IMAGE_SAMPLE_C_D_V1_V5_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x1, 0x5, 0x1 }, // 6969
  { IMAGE_SAMPLE_C_D_V1_V6_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x1, 0x6, 0x1 }, // 6970
  { IMAGE_SAMPLE_C_D_V1_V7_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x1, 0x7, 0x1 }, // 6971
  { IMAGE_SAMPLE_C_D_V1_V8_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x1, 0x8, 0x1 }, // 6972
  { IMAGE_SAMPLE_C_D_V1_V9_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x1, 0x9, 0x1 }, // 6973
  { IMAGE_SAMPLE_C_D_V1_V10_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x1, 0xA, 0x1 }, // 6974
  { IMAGE_SAMPLE_C_D_V2_V3_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 6975
  { IMAGE_SAMPLE_C_D_V2_V4_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 6976
  { IMAGE_SAMPLE_C_D_V2_V5_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 6977
  { IMAGE_SAMPLE_C_D_V2_V6_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x2, 0x6, 0x1 }, // 6978
  { IMAGE_SAMPLE_C_D_V2_V7_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x2, 0x7, 0x1 }, // 6979
  { IMAGE_SAMPLE_C_D_V2_V8_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 6980
  { IMAGE_SAMPLE_C_D_V2_V9_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x2, 0x9, 0x1 }, // 6981
  { IMAGE_SAMPLE_C_D_V2_V10_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x2, 0xA, 0x1 }, // 6982
  { IMAGE_SAMPLE_C_D_V3_V3_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 6983
  { IMAGE_SAMPLE_C_D_V3_V4_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 6984
  { IMAGE_SAMPLE_C_D_V3_V5_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x3, 0x5, 0x1 }, // 6985
  { IMAGE_SAMPLE_C_D_V3_V6_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x3, 0x6, 0x1 }, // 6986
  { IMAGE_SAMPLE_C_D_V3_V7_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x3, 0x7, 0x1 }, // 6987
  { IMAGE_SAMPLE_C_D_V3_V8_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x3, 0x8, 0x1 }, // 6988
  { IMAGE_SAMPLE_C_D_V3_V9_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x3, 0x9, 0x1 }, // 6989
  { IMAGE_SAMPLE_C_D_V3_V10_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x3, 0xA, 0x1 }, // 6990
  { IMAGE_SAMPLE_C_D_V4_V3_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 6991
  { IMAGE_SAMPLE_C_D_V4_V4_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 6992
  { IMAGE_SAMPLE_C_D_V4_V5_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 6993
  { IMAGE_SAMPLE_C_D_V4_V6_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x4, 0x6, 0x1 }, // 6994
  { IMAGE_SAMPLE_C_D_V4_V7_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x4, 0x7, 0x1 }, // 6995
  { IMAGE_SAMPLE_C_D_V4_V8_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 6996
  { IMAGE_SAMPLE_C_D_V4_V9_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x4, 0x9, 0x1 }, // 6997
  { IMAGE_SAMPLE_C_D_V4_V10_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x4, 0xA, 0x1 }, // 6998
  { IMAGE_SAMPLE_C_D_V5_V3_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 6999
  { IMAGE_SAMPLE_C_D_V5_V4_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 7000
  { IMAGE_SAMPLE_C_D_V5_V5_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 7001
  { IMAGE_SAMPLE_C_D_V5_V6_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x5, 0x6, 0x1 }, // 7002
  { IMAGE_SAMPLE_C_D_V5_V7_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x5, 0x7, 0x1 }, // 7003
  { IMAGE_SAMPLE_C_D_V5_V8_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 7004
  { IMAGE_SAMPLE_C_D_V5_V9_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x5, 0x9, 0x1 }, // 7005
  { IMAGE_SAMPLE_C_D_V5_V10_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11Default, 0x5, 0xA, 0x1 }, // 7006
  { IMAGE_SAMPLE_C_D_V1_V3_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 7007
  { IMAGE_SAMPLE_C_D_V1_V4_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 7008
  { IMAGE_SAMPLE_C_D_V1_V5_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x1, 0x5, 0x5 }, // 7009
  { IMAGE_SAMPLE_C_D_V1_V6_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x1, 0x6, 0x6 }, // 7010
  { IMAGE_SAMPLE_C_D_V1_V7_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x1, 0x7, 0x7 }, // 7011
  { IMAGE_SAMPLE_C_D_V1_V8_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x1, 0x8, 0x8 }, // 7012
  { IMAGE_SAMPLE_C_D_V1_V9_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x1, 0x9, 0x9 }, // 7013
  { IMAGE_SAMPLE_C_D_V1_V10_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x1, 0xA, 0xA }, // 7014
  { IMAGE_SAMPLE_C_D_V2_V3_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 7015
  { IMAGE_SAMPLE_C_D_V2_V4_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 7016
  { IMAGE_SAMPLE_C_D_V2_V5_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 7017
  { IMAGE_SAMPLE_C_D_V2_V6_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x2, 0x6, 0x6 }, // 7018
  { IMAGE_SAMPLE_C_D_V2_V7_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x2, 0x7, 0x7 }, // 7019
  { IMAGE_SAMPLE_C_D_V2_V8_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x2, 0x8, 0x8 }, // 7020
  { IMAGE_SAMPLE_C_D_V2_V9_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x2, 0x9, 0x9 }, // 7021
  { IMAGE_SAMPLE_C_D_V2_V10_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x2, 0xA, 0xA }, // 7022
  { IMAGE_SAMPLE_C_D_V3_V3_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 7023
  { IMAGE_SAMPLE_C_D_V3_V4_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 7024
  { IMAGE_SAMPLE_C_D_V3_V5_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x3, 0x5, 0x5 }, // 7025
  { IMAGE_SAMPLE_C_D_V3_V6_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x3, 0x6, 0x6 }, // 7026
  { IMAGE_SAMPLE_C_D_V3_V7_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x3, 0x7, 0x7 }, // 7027
  { IMAGE_SAMPLE_C_D_V3_V8_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x3, 0x8, 0x8 }, // 7028
  { IMAGE_SAMPLE_C_D_V3_V9_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x3, 0x9, 0x9 }, // 7029
  { IMAGE_SAMPLE_C_D_V3_V10_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x3, 0xA, 0xA }, // 7030
  { IMAGE_SAMPLE_C_D_V4_V3_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 7031
  { IMAGE_SAMPLE_C_D_V4_V4_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 7032
  { IMAGE_SAMPLE_C_D_V4_V5_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 7033
  { IMAGE_SAMPLE_C_D_V4_V6_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x4, 0x6, 0x6 }, // 7034
  { IMAGE_SAMPLE_C_D_V4_V7_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x4, 0x7, 0x7 }, // 7035
  { IMAGE_SAMPLE_C_D_V4_V8_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x4, 0x8, 0x8 }, // 7036
  { IMAGE_SAMPLE_C_D_V4_V9_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x4, 0x9, 0x9 }, // 7037
  { IMAGE_SAMPLE_C_D_V4_V10_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x4, 0xA, 0xA }, // 7038
  { IMAGE_SAMPLE_C_D_V5_V3_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 7039
  { IMAGE_SAMPLE_C_D_V5_V4_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 7040
  { IMAGE_SAMPLE_C_D_V5_V5_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 7041
  { IMAGE_SAMPLE_C_D_V5_V6_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x5, 0x6, 0x6 }, // 7042
  { IMAGE_SAMPLE_C_D_V5_V7_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x5, 0x7, 0x7 }, // 7043
  { IMAGE_SAMPLE_C_D_V5_V8_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x5, 0x8, 0x8 }, // 7044
  { IMAGE_SAMPLE_C_D_V5_V9_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x5, 0x9, 0x9 }, // 7045
  { IMAGE_SAMPLE_C_D_V5_V10_nsa_gfx11, IMAGE_SAMPLE_C_D, MIMGEncGfx11NSA, 0x5, 0xA, 0xA }, // 7046
  { IMAGE_SAMPLE_C_D_V1_V3_gfx12, IMAGE_SAMPLE_C_D, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 7047
  { IMAGE_SAMPLE_C_D_V1_V4_gfx12, IMAGE_SAMPLE_C_D, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 7048
  { IMAGE_SAMPLE_C_D_V1_V5_gfx12, IMAGE_SAMPLE_C_D, MIMGEncGfx12, 0x1, 0x5, 0x5 }, // 7049
  { IMAGE_SAMPLE_C_D_V1_V6_gfx12, IMAGE_SAMPLE_C_D, MIMGEncGfx12, 0x1, 0x6, 0x6 }, // 7050
  { IMAGE_SAMPLE_C_D_V1_V7_gfx12, IMAGE_SAMPLE_C_D, MIMGEncGfx12, 0x1, 0x7, 0x7 }, // 7051
  { IMAGE_SAMPLE_C_D_V1_V8_gfx12, IMAGE_SAMPLE_C_D, MIMGEncGfx12, 0x1, 0x8, 0x8 }, // 7052
  { IMAGE_SAMPLE_C_D_V1_V9_gfx12, IMAGE_SAMPLE_C_D, MIMGEncGfx12, 0x1, 0x9, 0x9 }, // 7053
  { IMAGE_SAMPLE_C_D_V1_V10_gfx12, IMAGE_SAMPLE_C_D, MIMGEncGfx12, 0x1, 0xA, 0xA }, // 7054
  { IMAGE_SAMPLE_C_D_V2_V3_gfx12, IMAGE_SAMPLE_C_D, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 7055
  { IMAGE_SAMPLE_C_D_V2_V4_gfx12, IMAGE_SAMPLE_C_D, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 7056
  { IMAGE_SAMPLE_C_D_V2_V5_gfx12, IMAGE_SAMPLE_C_D, MIMGEncGfx12, 0x2, 0x5, 0x5 }, // 7057
  { IMAGE_SAMPLE_C_D_V2_V6_gfx12, IMAGE_SAMPLE_C_D, MIMGEncGfx12, 0x2, 0x6, 0x6 }, // 7058
  { IMAGE_SAMPLE_C_D_V2_V7_gfx12, IMAGE_SAMPLE_C_D, MIMGEncGfx12, 0x2, 0x7, 0x7 }, // 7059
  { IMAGE_SAMPLE_C_D_V2_V8_gfx12, IMAGE_SAMPLE_C_D, MIMGEncGfx12, 0x2, 0x8, 0x8 }, // 7060
  { IMAGE_SAMPLE_C_D_V2_V9_gfx12, IMAGE_SAMPLE_C_D, MIMGEncGfx12, 0x2, 0x9, 0x9 }, // 7061
  { IMAGE_SAMPLE_C_D_V2_V10_gfx12, IMAGE_SAMPLE_C_D, MIMGEncGfx12, 0x2, 0xA, 0xA }, // 7062
  { IMAGE_SAMPLE_C_D_V3_V3_gfx12, IMAGE_SAMPLE_C_D, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 7063
  { IMAGE_SAMPLE_C_D_V3_V4_gfx12, IMAGE_SAMPLE_C_D, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 7064
  { IMAGE_SAMPLE_C_D_V3_V5_gfx12, IMAGE_SAMPLE_C_D, MIMGEncGfx12, 0x3, 0x5, 0x5 }, // 7065
  { IMAGE_SAMPLE_C_D_V3_V6_gfx12, IMAGE_SAMPLE_C_D, MIMGEncGfx12, 0x3, 0x6, 0x6 }, // 7066
  { IMAGE_SAMPLE_C_D_V3_V7_gfx12, IMAGE_SAMPLE_C_D, MIMGEncGfx12, 0x3, 0x7, 0x7 }, // 7067
  { IMAGE_SAMPLE_C_D_V3_V8_gfx12, IMAGE_SAMPLE_C_D, MIMGEncGfx12, 0x3, 0x8, 0x8 }, // 7068
  { IMAGE_SAMPLE_C_D_V3_V9_gfx12, IMAGE_SAMPLE_C_D, MIMGEncGfx12, 0x3, 0x9, 0x9 }, // 7069
  { IMAGE_SAMPLE_C_D_V3_V10_gfx12, IMAGE_SAMPLE_C_D, MIMGEncGfx12, 0x3, 0xA, 0xA }, // 7070
  { IMAGE_SAMPLE_C_D_V4_V3_gfx12, IMAGE_SAMPLE_C_D, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 7071
  { IMAGE_SAMPLE_C_D_V4_V4_gfx12, IMAGE_SAMPLE_C_D, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 7072
  { IMAGE_SAMPLE_C_D_V4_V5_gfx12, IMAGE_SAMPLE_C_D, MIMGEncGfx12, 0x4, 0x5, 0x5 }, // 7073
  { IMAGE_SAMPLE_C_D_V4_V6_gfx12, IMAGE_SAMPLE_C_D, MIMGEncGfx12, 0x4, 0x6, 0x6 }, // 7074
  { IMAGE_SAMPLE_C_D_V4_V7_gfx12, IMAGE_SAMPLE_C_D, MIMGEncGfx12, 0x4, 0x7, 0x7 }, // 7075
  { IMAGE_SAMPLE_C_D_V4_V8_gfx12, IMAGE_SAMPLE_C_D, MIMGEncGfx12, 0x4, 0x8, 0x8 }, // 7076
  { IMAGE_SAMPLE_C_D_V4_V9_gfx12, IMAGE_SAMPLE_C_D, MIMGEncGfx12, 0x4, 0x9, 0x9 }, // 7077
  { IMAGE_SAMPLE_C_D_V4_V10_gfx12, IMAGE_SAMPLE_C_D, MIMGEncGfx12, 0x4, 0xA, 0xA }, // 7078
  { IMAGE_SAMPLE_C_D_V5_V3_gfx12, IMAGE_SAMPLE_C_D, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 7079
  { IMAGE_SAMPLE_C_D_V5_V4_gfx12, IMAGE_SAMPLE_C_D, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 7080
  { IMAGE_SAMPLE_C_D_V5_V5_gfx12, IMAGE_SAMPLE_C_D, MIMGEncGfx12, 0x5, 0x5, 0x5 }, // 7081
  { IMAGE_SAMPLE_C_D_V5_V6_gfx12, IMAGE_SAMPLE_C_D, MIMGEncGfx12, 0x5, 0x6, 0x6 }, // 7082
  { IMAGE_SAMPLE_C_D_V5_V7_gfx12, IMAGE_SAMPLE_C_D, MIMGEncGfx12, 0x5, 0x7, 0x7 }, // 7083
  { IMAGE_SAMPLE_C_D_V5_V8_gfx12, IMAGE_SAMPLE_C_D, MIMGEncGfx12, 0x5, 0x8, 0x8 }, // 7084
  { IMAGE_SAMPLE_C_D_V5_V9_gfx12, IMAGE_SAMPLE_C_D, MIMGEncGfx12, 0x5, 0x9, 0x9 }, // 7085
  { IMAGE_SAMPLE_C_D_V5_V10_gfx12, IMAGE_SAMPLE_C_D, MIMGEncGfx12, 0x5, 0xA, 0xA }, // 7086
  { IMAGE_SAMPLE_C_D_V1_V3, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 7087
  { IMAGE_SAMPLE_C_D_V1_V4, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 7088
  { IMAGE_SAMPLE_C_D_V1_V5, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 7089
  { IMAGE_SAMPLE_C_D_V1_V6, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 7090
  { IMAGE_SAMPLE_C_D_V1_V7, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x1, 0x7, 0x1 }, // 7091
  { IMAGE_SAMPLE_C_D_V1_V8, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 7092
  { IMAGE_SAMPLE_C_D_V1_V9, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x1, 0x9, 0x1 }, // 7093
  { IMAGE_SAMPLE_C_D_V1_V10, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x1, 0xA, 0x1 }, // 7094
  { IMAGE_SAMPLE_C_D_V2_V3, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 7095
  { IMAGE_SAMPLE_C_D_V2_V4, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 7096
  { IMAGE_SAMPLE_C_D_V2_V5, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 7097
  { IMAGE_SAMPLE_C_D_V2_V6, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 7098
  { IMAGE_SAMPLE_C_D_V2_V7, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x2, 0x7, 0x1 }, // 7099
  { IMAGE_SAMPLE_C_D_V2_V8, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 7100
  { IMAGE_SAMPLE_C_D_V2_V9, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x2, 0x9, 0x1 }, // 7101
  { IMAGE_SAMPLE_C_D_V2_V10, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x2, 0xA, 0x1 }, // 7102
  { IMAGE_SAMPLE_C_D_V3_V3, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 7103
  { IMAGE_SAMPLE_C_D_V3_V4, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 7104
  { IMAGE_SAMPLE_C_D_V3_V5, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 7105
  { IMAGE_SAMPLE_C_D_V3_V6, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 7106
  { IMAGE_SAMPLE_C_D_V3_V7, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x3, 0x7, 0x1 }, // 7107
  { IMAGE_SAMPLE_C_D_V3_V8, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 7108
  { IMAGE_SAMPLE_C_D_V3_V9, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x3, 0x9, 0x1 }, // 7109
  { IMAGE_SAMPLE_C_D_V3_V10, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x3, 0xA, 0x1 }, // 7110
  { IMAGE_SAMPLE_C_D_V4_V3, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 7111
  { IMAGE_SAMPLE_C_D_V4_V4, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 7112
  { IMAGE_SAMPLE_C_D_V4_V5, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 7113
  { IMAGE_SAMPLE_C_D_V4_V6, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 7114
  { IMAGE_SAMPLE_C_D_V4_V7, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x4, 0x7, 0x1 }, // 7115
  { IMAGE_SAMPLE_C_D_V4_V8, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 7116
  { IMAGE_SAMPLE_C_D_V4_V9, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x4, 0x9, 0x1 }, // 7117
  { IMAGE_SAMPLE_C_D_V4_V10, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x4, 0xA, 0x1 }, // 7118
  { IMAGE_SAMPLE_C_D_V5_V3, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 7119
  { IMAGE_SAMPLE_C_D_V5_V4, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 7120
  { IMAGE_SAMPLE_C_D_V5_V5, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 7121
  { IMAGE_SAMPLE_C_D_V5_V6, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 7122
  { IMAGE_SAMPLE_C_D_V5_V7, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x5, 0x7, 0x1 }, // 7123
  { IMAGE_SAMPLE_C_D_V5_V8, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 7124
  { IMAGE_SAMPLE_C_D_V5_V9, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x5, 0x9, 0x1 }, // 7125
  { IMAGE_SAMPLE_C_D_V5_V10, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x5, 0xA, 0x1 }, // 7126
  { IMAGE_SAMPLE_C_D_CL_V1_V3_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 7127
  { IMAGE_SAMPLE_C_D_CL_V1_V4_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 7128
  { IMAGE_SAMPLE_C_D_CL_V1_V5_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 7129
  { IMAGE_SAMPLE_C_D_CL_V1_V6_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 7130
  { IMAGE_SAMPLE_C_D_CL_V1_V7_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x1, 0x7, 0x1 }, // 7131
  { IMAGE_SAMPLE_C_D_CL_V1_V8_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 7132
  { IMAGE_SAMPLE_C_D_CL_V1_V9_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x1, 0x9, 0x1 }, // 7133
  { IMAGE_SAMPLE_C_D_CL_V1_V10_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x1, 0xA, 0x1 }, // 7134
  { IMAGE_SAMPLE_C_D_CL_V1_V11_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x1, 0xB, 0x1 }, // 7135
  { IMAGE_SAMPLE_C_D_CL_V2_V3_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 7136
  { IMAGE_SAMPLE_C_D_CL_V2_V4_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 7137
  { IMAGE_SAMPLE_C_D_CL_V2_V5_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 7138
  { IMAGE_SAMPLE_C_D_CL_V2_V6_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 7139
  { IMAGE_SAMPLE_C_D_CL_V2_V7_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x2, 0x7, 0x1 }, // 7140
  { IMAGE_SAMPLE_C_D_CL_V2_V8_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 7141
  { IMAGE_SAMPLE_C_D_CL_V2_V9_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x2, 0x9, 0x1 }, // 7142
  { IMAGE_SAMPLE_C_D_CL_V2_V10_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x2, 0xA, 0x1 }, // 7143
  { IMAGE_SAMPLE_C_D_CL_V2_V11_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x2, 0xB, 0x1 }, // 7144
  { IMAGE_SAMPLE_C_D_CL_V3_V3_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 7145
  { IMAGE_SAMPLE_C_D_CL_V3_V4_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 7146
  { IMAGE_SAMPLE_C_D_CL_V3_V5_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 7147
  { IMAGE_SAMPLE_C_D_CL_V3_V6_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 7148
  { IMAGE_SAMPLE_C_D_CL_V3_V7_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x3, 0x7, 0x1 }, // 7149
  { IMAGE_SAMPLE_C_D_CL_V3_V8_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 7150
  { IMAGE_SAMPLE_C_D_CL_V3_V9_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x3, 0x9, 0x1 }, // 7151
  { IMAGE_SAMPLE_C_D_CL_V3_V10_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x3, 0xA, 0x1 }, // 7152
  { IMAGE_SAMPLE_C_D_CL_V3_V11_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x3, 0xB, 0x1 }, // 7153
  { IMAGE_SAMPLE_C_D_CL_V4_V3_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 7154
  { IMAGE_SAMPLE_C_D_CL_V4_V4_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 7155
  { IMAGE_SAMPLE_C_D_CL_V4_V5_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 7156
  { IMAGE_SAMPLE_C_D_CL_V4_V6_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 7157
  { IMAGE_SAMPLE_C_D_CL_V4_V7_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x4, 0x7, 0x1 }, // 7158
  { IMAGE_SAMPLE_C_D_CL_V4_V8_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 7159
  { IMAGE_SAMPLE_C_D_CL_V4_V9_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x4, 0x9, 0x1 }, // 7160
  { IMAGE_SAMPLE_C_D_CL_V4_V10_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x4, 0xA, 0x1 }, // 7161
  { IMAGE_SAMPLE_C_D_CL_V4_V11_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x4, 0xB, 0x1 }, // 7162
  { IMAGE_SAMPLE_C_D_CL_V5_V3_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 7163
  { IMAGE_SAMPLE_C_D_CL_V5_V4_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 7164
  { IMAGE_SAMPLE_C_D_CL_V5_V5_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 7165
  { IMAGE_SAMPLE_C_D_CL_V5_V6_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 7166
  { IMAGE_SAMPLE_C_D_CL_V5_V7_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x5, 0x7, 0x1 }, // 7167
  { IMAGE_SAMPLE_C_D_CL_V5_V8_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 7168
  { IMAGE_SAMPLE_C_D_CL_V5_V9_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x5, 0x9, 0x1 }, // 7169
  { IMAGE_SAMPLE_C_D_CL_V5_V10_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x5, 0xA, 0x1 }, // 7170
  { IMAGE_SAMPLE_C_D_CL_V5_V11_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10Default, 0x5, 0xB, 0x1 }, // 7171
  { IMAGE_SAMPLE_C_D_CL_V1_V3_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 7172
  { IMAGE_SAMPLE_C_D_CL_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 7173
  { IMAGE_SAMPLE_C_D_CL_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 7174
  { IMAGE_SAMPLE_C_D_CL_V1_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 7175
  { IMAGE_SAMPLE_C_D_CL_V1_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x1, 0x7, 0x7 }, // 7176
  { IMAGE_SAMPLE_C_D_CL_V1_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x1, 0x8, 0x8 }, // 7177
  { IMAGE_SAMPLE_C_D_CL_V1_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x1, 0x9, 0x9 }, // 7178
  { IMAGE_SAMPLE_C_D_CL_V1_V10_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x1, 0xA, 0xA }, // 7179
  { IMAGE_SAMPLE_C_D_CL_V1_V11_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x1, 0xB, 0xB }, // 7180
  { IMAGE_SAMPLE_C_D_CL_V2_V3_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 7181
  { IMAGE_SAMPLE_C_D_CL_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 7182
  { IMAGE_SAMPLE_C_D_CL_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 7183
  { IMAGE_SAMPLE_C_D_CL_V2_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 7184
  { IMAGE_SAMPLE_C_D_CL_V2_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x2, 0x7, 0x7 }, // 7185
  { IMAGE_SAMPLE_C_D_CL_V2_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x2, 0x8, 0x8 }, // 7186
  { IMAGE_SAMPLE_C_D_CL_V2_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x2, 0x9, 0x9 }, // 7187
  { IMAGE_SAMPLE_C_D_CL_V2_V10_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x2, 0xA, 0xA }, // 7188
  { IMAGE_SAMPLE_C_D_CL_V2_V11_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x2, 0xB, 0xB }, // 7189
  { IMAGE_SAMPLE_C_D_CL_V3_V3_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 7190
  { IMAGE_SAMPLE_C_D_CL_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 7191
  { IMAGE_SAMPLE_C_D_CL_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 7192
  { IMAGE_SAMPLE_C_D_CL_V3_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 7193
  { IMAGE_SAMPLE_C_D_CL_V3_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x3, 0x7, 0x7 }, // 7194
  { IMAGE_SAMPLE_C_D_CL_V3_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x3, 0x8, 0x8 }, // 7195
  { IMAGE_SAMPLE_C_D_CL_V3_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x3, 0x9, 0x9 }, // 7196
  { IMAGE_SAMPLE_C_D_CL_V3_V10_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x3, 0xA, 0xA }, // 7197
  { IMAGE_SAMPLE_C_D_CL_V3_V11_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x3, 0xB, 0xB }, // 7198
  { IMAGE_SAMPLE_C_D_CL_V4_V3_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 7199
  { IMAGE_SAMPLE_C_D_CL_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 7200
  { IMAGE_SAMPLE_C_D_CL_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 7201
  { IMAGE_SAMPLE_C_D_CL_V4_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 7202
  { IMAGE_SAMPLE_C_D_CL_V4_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x4, 0x7, 0x7 }, // 7203
  { IMAGE_SAMPLE_C_D_CL_V4_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x4, 0x8, 0x8 }, // 7204
  { IMAGE_SAMPLE_C_D_CL_V4_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x4, 0x9, 0x9 }, // 7205
  { IMAGE_SAMPLE_C_D_CL_V4_V10_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x4, 0xA, 0xA }, // 7206
  { IMAGE_SAMPLE_C_D_CL_V4_V11_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x4, 0xB, 0xB }, // 7207
  { IMAGE_SAMPLE_C_D_CL_V5_V3_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 7208
  { IMAGE_SAMPLE_C_D_CL_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 7209
  { IMAGE_SAMPLE_C_D_CL_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 7210
  { IMAGE_SAMPLE_C_D_CL_V5_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 7211
  { IMAGE_SAMPLE_C_D_CL_V5_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x5, 0x7, 0x7 }, // 7212
  { IMAGE_SAMPLE_C_D_CL_V5_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x5, 0x8, 0x8 }, // 7213
  { IMAGE_SAMPLE_C_D_CL_V5_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x5, 0x9, 0x9 }, // 7214
  { IMAGE_SAMPLE_C_D_CL_V5_V10_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x5, 0xA, 0xA }, // 7215
  { IMAGE_SAMPLE_C_D_CL_V5_V11_nsa_gfx10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx10NSA, 0x5, 0xB, 0xB }, // 7216
  { IMAGE_SAMPLE_C_D_CL_V1_V3_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 7217
  { IMAGE_SAMPLE_C_D_CL_V1_V4_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 7218
  { IMAGE_SAMPLE_C_D_CL_V1_V5_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x1, 0x5, 0x1 }, // 7219
  { IMAGE_SAMPLE_C_D_CL_V1_V6_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x1, 0x6, 0x1 }, // 7220
  { IMAGE_SAMPLE_C_D_CL_V1_V7_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x1, 0x7, 0x1 }, // 7221
  { IMAGE_SAMPLE_C_D_CL_V1_V8_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x1, 0x8, 0x1 }, // 7222
  { IMAGE_SAMPLE_C_D_CL_V1_V9_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x1, 0x9, 0x1 }, // 7223
  { IMAGE_SAMPLE_C_D_CL_V1_V10_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x1, 0xA, 0x1 }, // 7224
  { IMAGE_SAMPLE_C_D_CL_V1_V11_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x1, 0xB, 0x1 }, // 7225
  { IMAGE_SAMPLE_C_D_CL_V2_V3_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 7226
  { IMAGE_SAMPLE_C_D_CL_V2_V4_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 7227
  { IMAGE_SAMPLE_C_D_CL_V2_V5_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 7228
  { IMAGE_SAMPLE_C_D_CL_V2_V6_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x2, 0x6, 0x1 }, // 7229
  { IMAGE_SAMPLE_C_D_CL_V2_V7_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x2, 0x7, 0x1 }, // 7230
  { IMAGE_SAMPLE_C_D_CL_V2_V8_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 7231
  { IMAGE_SAMPLE_C_D_CL_V2_V9_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x2, 0x9, 0x1 }, // 7232
  { IMAGE_SAMPLE_C_D_CL_V2_V10_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x2, 0xA, 0x1 }, // 7233
  { IMAGE_SAMPLE_C_D_CL_V2_V11_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x2, 0xB, 0x1 }, // 7234
  { IMAGE_SAMPLE_C_D_CL_V3_V3_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 7235
  { IMAGE_SAMPLE_C_D_CL_V3_V4_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 7236
  { IMAGE_SAMPLE_C_D_CL_V3_V5_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x3, 0x5, 0x1 }, // 7237
  { IMAGE_SAMPLE_C_D_CL_V3_V6_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x3, 0x6, 0x1 }, // 7238
  { IMAGE_SAMPLE_C_D_CL_V3_V7_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x3, 0x7, 0x1 }, // 7239
  { IMAGE_SAMPLE_C_D_CL_V3_V8_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x3, 0x8, 0x1 }, // 7240
  { IMAGE_SAMPLE_C_D_CL_V3_V9_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x3, 0x9, 0x1 }, // 7241
  { IMAGE_SAMPLE_C_D_CL_V3_V10_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x3, 0xA, 0x1 }, // 7242
  { IMAGE_SAMPLE_C_D_CL_V3_V11_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x3, 0xB, 0x1 }, // 7243
  { IMAGE_SAMPLE_C_D_CL_V4_V3_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 7244
  { IMAGE_SAMPLE_C_D_CL_V4_V4_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 7245
  { IMAGE_SAMPLE_C_D_CL_V4_V5_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 7246
  { IMAGE_SAMPLE_C_D_CL_V4_V6_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x4, 0x6, 0x1 }, // 7247
  { IMAGE_SAMPLE_C_D_CL_V4_V7_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x4, 0x7, 0x1 }, // 7248
  { IMAGE_SAMPLE_C_D_CL_V4_V8_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 7249
  { IMAGE_SAMPLE_C_D_CL_V4_V9_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x4, 0x9, 0x1 }, // 7250
  { IMAGE_SAMPLE_C_D_CL_V4_V10_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x4, 0xA, 0x1 }, // 7251
  { IMAGE_SAMPLE_C_D_CL_V4_V11_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x4, 0xB, 0x1 }, // 7252
  { IMAGE_SAMPLE_C_D_CL_V5_V3_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 7253
  { IMAGE_SAMPLE_C_D_CL_V5_V4_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 7254
  { IMAGE_SAMPLE_C_D_CL_V5_V5_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 7255
  { IMAGE_SAMPLE_C_D_CL_V5_V6_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x5, 0x6, 0x1 }, // 7256
  { IMAGE_SAMPLE_C_D_CL_V5_V7_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x5, 0x7, 0x1 }, // 7257
  { IMAGE_SAMPLE_C_D_CL_V5_V8_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 7258
  { IMAGE_SAMPLE_C_D_CL_V5_V9_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x5, 0x9, 0x1 }, // 7259
  { IMAGE_SAMPLE_C_D_CL_V5_V10_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x5, 0xA, 0x1 }, // 7260
  { IMAGE_SAMPLE_C_D_CL_V5_V11_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11Default, 0x5, 0xB, 0x1 }, // 7261
  { IMAGE_SAMPLE_C_D_CL_V1_V3_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 7262
  { IMAGE_SAMPLE_C_D_CL_V1_V4_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 7263
  { IMAGE_SAMPLE_C_D_CL_V1_V5_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x1, 0x5, 0x5 }, // 7264
  { IMAGE_SAMPLE_C_D_CL_V1_V6_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x1, 0x6, 0x6 }, // 7265
  { IMAGE_SAMPLE_C_D_CL_V1_V7_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x1, 0x7, 0x7 }, // 7266
  { IMAGE_SAMPLE_C_D_CL_V1_V8_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x1, 0x8, 0x8 }, // 7267
  { IMAGE_SAMPLE_C_D_CL_V1_V9_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x1, 0x9, 0x9 }, // 7268
  { IMAGE_SAMPLE_C_D_CL_V1_V10_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x1, 0xA, 0xA }, // 7269
  { IMAGE_SAMPLE_C_D_CL_V1_V11_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x1, 0xB, 0xB }, // 7270
  { IMAGE_SAMPLE_C_D_CL_V2_V3_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 7271
  { IMAGE_SAMPLE_C_D_CL_V2_V4_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 7272
  { IMAGE_SAMPLE_C_D_CL_V2_V5_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 7273
  { IMAGE_SAMPLE_C_D_CL_V2_V6_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x2, 0x6, 0x6 }, // 7274
  { IMAGE_SAMPLE_C_D_CL_V2_V7_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x2, 0x7, 0x7 }, // 7275
  { IMAGE_SAMPLE_C_D_CL_V2_V8_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x2, 0x8, 0x8 }, // 7276
  { IMAGE_SAMPLE_C_D_CL_V2_V9_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x2, 0x9, 0x9 }, // 7277
  { IMAGE_SAMPLE_C_D_CL_V2_V10_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x2, 0xA, 0xA }, // 7278
  { IMAGE_SAMPLE_C_D_CL_V2_V11_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x2, 0xB, 0xB }, // 7279
  { IMAGE_SAMPLE_C_D_CL_V3_V3_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 7280
  { IMAGE_SAMPLE_C_D_CL_V3_V4_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 7281
  { IMAGE_SAMPLE_C_D_CL_V3_V5_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x3, 0x5, 0x5 }, // 7282
  { IMAGE_SAMPLE_C_D_CL_V3_V6_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x3, 0x6, 0x6 }, // 7283
  { IMAGE_SAMPLE_C_D_CL_V3_V7_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x3, 0x7, 0x7 }, // 7284
  { IMAGE_SAMPLE_C_D_CL_V3_V8_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x3, 0x8, 0x8 }, // 7285
  { IMAGE_SAMPLE_C_D_CL_V3_V9_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x3, 0x9, 0x9 }, // 7286
  { IMAGE_SAMPLE_C_D_CL_V3_V10_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x3, 0xA, 0xA }, // 7287
  { IMAGE_SAMPLE_C_D_CL_V3_V11_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x3, 0xB, 0xB }, // 7288
  { IMAGE_SAMPLE_C_D_CL_V4_V3_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 7289
  { IMAGE_SAMPLE_C_D_CL_V4_V4_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 7290
  { IMAGE_SAMPLE_C_D_CL_V4_V5_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 7291
  { IMAGE_SAMPLE_C_D_CL_V4_V6_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x4, 0x6, 0x6 }, // 7292
  { IMAGE_SAMPLE_C_D_CL_V4_V7_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x4, 0x7, 0x7 }, // 7293
  { IMAGE_SAMPLE_C_D_CL_V4_V8_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x4, 0x8, 0x8 }, // 7294
  { IMAGE_SAMPLE_C_D_CL_V4_V9_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x4, 0x9, 0x9 }, // 7295
  { IMAGE_SAMPLE_C_D_CL_V4_V10_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x4, 0xA, 0xA }, // 7296
  { IMAGE_SAMPLE_C_D_CL_V4_V11_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x4, 0xB, 0xB }, // 7297
  { IMAGE_SAMPLE_C_D_CL_V5_V3_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 7298
  { IMAGE_SAMPLE_C_D_CL_V5_V4_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 7299
  { IMAGE_SAMPLE_C_D_CL_V5_V5_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 7300
  { IMAGE_SAMPLE_C_D_CL_V5_V6_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x5, 0x6, 0x6 }, // 7301
  { IMAGE_SAMPLE_C_D_CL_V5_V7_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x5, 0x7, 0x7 }, // 7302
  { IMAGE_SAMPLE_C_D_CL_V5_V8_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x5, 0x8, 0x8 }, // 7303
  { IMAGE_SAMPLE_C_D_CL_V5_V9_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x5, 0x9, 0x9 }, // 7304
  { IMAGE_SAMPLE_C_D_CL_V5_V10_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x5, 0xA, 0xA }, // 7305
  { IMAGE_SAMPLE_C_D_CL_V5_V11_nsa_gfx11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx11NSA, 0x5, 0xB, 0xB }, // 7306
  { IMAGE_SAMPLE_C_D_CL_V1_V3_gfx12, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 7307
  { IMAGE_SAMPLE_C_D_CL_V1_V4_gfx12, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 7308
  { IMAGE_SAMPLE_C_D_CL_V1_V5_gfx12, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx12, 0x1, 0x5, 0x5 }, // 7309
  { IMAGE_SAMPLE_C_D_CL_V1_V6_gfx12, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx12, 0x1, 0x6, 0x6 }, // 7310
  { IMAGE_SAMPLE_C_D_CL_V1_V7_gfx12, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx12, 0x1, 0x7, 0x7 }, // 7311
  { IMAGE_SAMPLE_C_D_CL_V1_V8_gfx12, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx12, 0x1, 0x8, 0x8 }, // 7312
  { IMAGE_SAMPLE_C_D_CL_V1_V9_gfx12, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx12, 0x1, 0x9, 0x9 }, // 7313
  { IMAGE_SAMPLE_C_D_CL_V1_V10_gfx12, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx12, 0x1, 0xA, 0xA }, // 7314
  { IMAGE_SAMPLE_C_D_CL_V1_V11_gfx12, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx12, 0x1, 0xB, 0xB }, // 7315
  { IMAGE_SAMPLE_C_D_CL_V2_V3_gfx12, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 7316
  { IMAGE_SAMPLE_C_D_CL_V2_V4_gfx12, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 7317
  { IMAGE_SAMPLE_C_D_CL_V2_V5_gfx12, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx12, 0x2, 0x5, 0x5 }, // 7318
  { IMAGE_SAMPLE_C_D_CL_V2_V6_gfx12, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx12, 0x2, 0x6, 0x6 }, // 7319
  { IMAGE_SAMPLE_C_D_CL_V2_V7_gfx12, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx12, 0x2, 0x7, 0x7 }, // 7320
  { IMAGE_SAMPLE_C_D_CL_V2_V8_gfx12, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx12, 0x2, 0x8, 0x8 }, // 7321
  { IMAGE_SAMPLE_C_D_CL_V2_V9_gfx12, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx12, 0x2, 0x9, 0x9 }, // 7322
  { IMAGE_SAMPLE_C_D_CL_V2_V10_gfx12, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx12, 0x2, 0xA, 0xA }, // 7323
  { IMAGE_SAMPLE_C_D_CL_V2_V11_gfx12, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx12, 0x2, 0xB, 0xB }, // 7324
  { IMAGE_SAMPLE_C_D_CL_V3_V3_gfx12, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 7325
  { IMAGE_SAMPLE_C_D_CL_V3_V4_gfx12, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 7326
  { IMAGE_SAMPLE_C_D_CL_V3_V5_gfx12, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx12, 0x3, 0x5, 0x5 }, // 7327
  { IMAGE_SAMPLE_C_D_CL_V3_V6_gfx12, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx12, 0x3, 0x6, 0x6 }, // 7328
  { IMAGE_SAMPLE_C_D_CL_V3_V7_gfx12, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx12, 0x3, 0x7, 0x7 }, // 7329
  { IMAGE_SAMPLE_C_D_CL_V3_V8_gfx12, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx12, 0x3, 0x8, 0x8 }, // 7330
  { IMAGE_SAMPLE_C_D_CL_V3_V9_gfx12, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx12, 0x3, 0x9, 0x9 }, // 7331
  { IMAGE_SAMPLE_C_D_CL_V3_V10_gfx12, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx12, 0x3, 0xA, 0xA }, // 7332
  { IMAGE_SAMPLE_C_D_CL_V3_V11_gfx12, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx12, 0x3, 0xB, 0xB }, // 7333
  { IMAGE_SAMPLE_C_D_CL_V4_V3_gfx12, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 7334
  { IMAGE_SAMPLE_C_D_CL_V4_V4_gfx12, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 7335
  { IMAGE_SAMPLE_C_D_CL_V4_V5_gfx12, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx12, 0x4, 0x5, 0x5 }, // 7336
  { IMAGE_SAMPLE_C_D_CL_V4_V6_gfx12, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx12, 0x4, 0x6, 0x6 }, // 7337
  { IMAGE_SAMPLE_C_D_CL_V4_V7_gfx12, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx12, 0x4, 0x7, 0x7 }, // 7338
  { IMAGE_SAMPLE_C_D_CL_V4_V8_gfx12, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx12, 0x4, 0x8, 0x8 }, // 7339
  { IMAGE_SAMPLE_C_D_CL_V4_V9_gfx12, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx12, 0x4, 0x9, 0x9 }, // 7340
  { IMAGE_SAMPLE_C_D_CL_V4_V10_gfx12, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx12, 0x4, 0xA, 0xA }, // 7341
  { IMAGE_SAMPLE_C_D_CL_V4_V11_gfx12, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx12, 0x4, 0xB, 0xB }, // 7342
  { IMAGE_SAMPLE_C_D_CL_V5_V3_gfx12, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 7343
  { IMAGE_SAMPLE_C_D_CL_V5_V4_gfx12, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 7344
  { IMAGE_SAMPLE_C_D_CL_V5_V5_gfx12, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx12, 0x5, 0x5, 0x5 }, // 7345
  { IMAGE_SAMPLE_C_D_CL_V5_V6_gfx12, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx12, 0x5, 0x6, 0x6 }, // 7346
  { IMAGE_SAMPLE_C_D_CL_V5_V7_gfx12, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx12, 0x5, 0x7, 0x7 }, // 7347
  { IMAGE_SAMPLE_C_D_CL_V5_V8_gfx12, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx12, 0x5, 0x8, 0x8 }, // 7348
  { IMAGE_SAMPLE_C_D_CL_V5_V9_gfx12, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx12, 0x5, 0x9, 0x9 }, // 7349
  { IMAGE_SAMPLE_C_D_CL_V5_V10_gfx12, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx12, 0x5, 0xA, 0xA }, // 7350
  { IMAGE_SAMPLE_C_D_CL_V5_V11_gfx12, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx12, 0x5, 0xB, 0xB }, // 7351
  { IMAGE_SAMPLE_C_D_CL_V1_V3, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 7352
  { IMAGE_SAMPLE_C_D_CL_V1_V4, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 7353
  { IMAGE_SAMPLE_C_D_CL_V1_V5, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 7354
  { IMAGE_SAMPLE_C_D_CL_V1_V6, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 7355
  { IMAGE_SAMPLE_C_D_CL_V1_V7, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x1, 0x7, 0x1 }, // 7356
  { IMAGE_SAMPLE_C_D_CL_V1_V8, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 7357
  { IMAGE_SAMPLE_C_D_CL_V1_V9, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x1, 0x9, 0x1 }, // 7358
  { IMAGE_SAMPLE_C_D_CL_V1_V10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x1, 0xA, 0x1 }, // 7359
  { IMAGE_SAMPLE_C_D_CL_V1_V11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x1, 0xB, 0x1 }, // 7360
  { IMAGE_SAMPLE_C_D_CL_V2_V3, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 7361
  { IMAGE_SAMPLE_C_D_CL_V2_V4, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 7362
  { IMAGE_SAMPLE_C_D_CL_V2_V5, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 7363
  { IMAGE_SAMPLE_C_D_CL_V2_V6, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 7364
  { IMAGE_SAMPLE_C_D_CL_V2_V7, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x2, 0x7, 0x1 }, // 7365
  { IMAGE_SAMPLE_C_D_CL_V2_V8, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 7366
  { IMAGE_SAMPLE_C_D_CL_V2_V9, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x2, 0x9, 0x1 }, // 7367
  { IMAGE_SAMPLE_C_D_CL_V2_V10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x2, 0xA, 0x1 }, // 7368
  { IMAGE_SAMPLE_C_D_CL_V2_V11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x2, 0xB, 0x1 }, // 7369
  { IMAGE_SAMPLE_C_D_CL_V3_V3, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 7370
  { IMAGE_SAMPLE_C_D_CL_V3_V4, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 7371
  { IMAGE_SAMPLE_C_D_CL_V3_V5, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 7372
  { IMAGE_SAMPLE_C_D_CL_V3_V6, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 7373
  { IMAGE_SAMPLE_C_D_CL_V3_V7, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x3, 0x7, 0x1 }, // 7374
  { IMAGE_SAMPLE_C_D_CL_V3_V8, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 7375
  { IMAGE_SAMPLE_C_D_CL_V3_V9, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x3, 0x9, 0x1 }, // 7376
  { IMAGE_SAMPLE_C_D_CL_V3_V10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x3, 0xA, 0x1 }, // 7377
  { IMAGE_SAMPLE_C_D_CL_V3_V11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x3, 0xB, 0x1 }, // 7378
  { IMAGE_SAMPLE_C_D_CL_V4_V3, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 7379
  { IMAGE_SAMPLE_C_D_CL_V4_V4, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 7380
  { IMAGE_SAMPLE_C_D_CL_V4_V5, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 7381
  { IMAGE_SAMPLE_C_D_CL_V4_V6, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 7382
  { IMAGE_SAMPLE_C_D_CL_V4_V7, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x4, 0x7, 0x1 }, // 7383
  { IMAGE_SAMPLE_C_D_CL_V4_V8, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 7384
  { IMAGE_SAMPLE_C_D_CL_V4_V9, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x4, 0x9, 0x1 }, // 7385
  { IMAGE_SAMPLE_C_D_CL_V4_V10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x4, 0xA, 0x1 }, // 7386
  { IMAGE_SAMPLE_C_D_CL_V4_V11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x4, 0xB, 0x1 }, // 7387
  { IMAGE_SAMPLE_C_D_CL_V5_V3, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 7388
  { IMAGE_SAMPLE_C_D_CL_V5_V4, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 7389
  { IMAGE_SAMPLE_C_D_CL_V5_V5, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 7390
  { IMAGE_SAMPLE_C_D_CL_V5_V6, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 7391
  { IMAGE_SAMPLE_C_D_CL_V5_V7, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x5, 0x7, 0x1 }, // 7392
  { IMAGE_SAMPLE_C_D_CL_V5_V8, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 7393
  { IMAGE_SAMPLE_C_D_CL_V5_V9, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x5, 0x9, 0x1 }, // 7394
  { IMAGE_SAMPLE_C_D_CL_V5_V10, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x5, 0xA, 0x1 }, // 7395
  { IMAGE_SAMPLE_C_D_CL_V5_V11, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x5, 0xB, 0x1 }, // 7396
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V3_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 7397
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V4_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 7398
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V5_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 7399
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V6_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 7400
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V7_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x1, 0x7, 0x1 }, // 7401
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V8_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 7402
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V9_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x1, 0x9, 0x1 }, // 7403
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V3_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 7404
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V4_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 7405
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V5_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 7406
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V6_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 7407
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V7_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x2, 0x7, 0x1 }, // 7408
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V8_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 7409
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V9_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x2, 0x9, 0x1 }, // 7410
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V3_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 7411
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V4_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 7412
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V5_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 7413
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V6_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 7414
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V7_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x3, 0x7, 0x1 }, // 7415
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V8_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 7416
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V9_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x3, 0x9, 0x1 }, // 7417
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V3_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 7418
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V4_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 7419
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V5_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 7420
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V6_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 7421
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V7_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x4, 0x7, 0x1 }, // 7422
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V8_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 7423
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V9_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x4, 0x9, 0x1 }, // 7424
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V3_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 7425
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V4_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 7426
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V5_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 7427
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V6_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 7428
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V7_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x5, 0x7, 0x1 }, // 7429
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V8_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 7430
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V9_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10Default, 0x5, 0x9, 0x1 }, // 7431
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V3_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 7432
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 7433
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 7434
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 7435
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x1, 0x7, 0x7 }, // 7436
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x1, 0x8, 0x8 }, // 7437
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x1, 0x9, 0x9 }, // 7438
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V3_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 7439
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 7440
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 7441
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 7442
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x2, 0x7, 0x7 }, // 7443
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x2, 0x8, 0x8 }, // 7444
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x2, 0x9, 0x9 }, // 7445
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V3_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 7446
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 7447
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 7448
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 7449
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x3, 0x7, 0x7 }, // 7450
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x3, 0x8, 0x8 }, // 7451
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x3, 0x9, 0x9 }, // 7452
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V3_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 7453
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 7454
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 7455
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 7456
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x4, 0x7, 0x7 }, // 7457
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x4, 0x8, 0x8 }, // 7458
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x4, 0x9, 0x9 }, // 7459
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V3_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 7460
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 7461
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 7462
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 7463
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x5, 0x7, 0x7 }, // 7464
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x5, 0x8, 0x8 }, // 7465
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx10NSA, 0x5, 0x9, 0x9 }, // 7466
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V3_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 7467
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V4_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 7468
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V5_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11Default, 0x1, 0x5, 0x1 }, // 7469
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V6_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11Default, 0x1, 0x6, 0x1 }, // 7470
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V7_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11Default, 0x1, 0x7, 0x1 }, // 7471
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V8_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11Default, 0x1, 0x8, 0x1 }, // 7472
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V9_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11Default, 0x1, 0x9, 0x1 }, // 7473
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V3_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 7474
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V4_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 7475
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V5_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 7476
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V6_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11Default, 0x2, 0x6, 0x1 }, // 7477
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V7_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11Default, 0x2, 0x7, 0x1 }, // 7478
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V8_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 7479
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V9_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11Default, 0x2, 0x9, 0x1 }, // 7480
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V3_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 7481
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V4_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 7482
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V5_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11Default, 0x3, 0x5, 0x1 }, // 7483
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V6_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11Default, 0x3, 0x6, 0x1 }, // 7484
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V7_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11Default, 0x3, 0x7, 0x1 }, // 7485
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V8_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11Default, 0x3, 0x8, 0x1 }, // 7486
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V9_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11Default, 0x3, 0x9, 0x1 }, // 7487
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V3_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 7488
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V4_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 7489
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V5_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 7490
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V6_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11Default, 0x4, 0x6, 0x1 }, // 7491
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V7_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11Default, 0x4, 0x7, 0x1 }, // 7492
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V8_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 7493
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V9_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11Default, 0x4, 0x9, 0x1 }, // 7494
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V3_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 7495
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V4_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 7496
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V5_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 7497
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V6_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11Default, 0x5, 0x6, 0x1 }, // 7498
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V7_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11Default, 0x5, 0x7, 0x1 }, // 7499
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V8_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 7500
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V9_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11Default, 0x5, 0x9, 0x1 }, // 7501
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V3_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 7502
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V4_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 7503
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V5_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11NSA, 0x1, 0x5, 0x5 }, // 7504
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V6_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11NSA, 0x1, 0x6, 0x6 }, // 7505
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V7_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11NSA, 0x1, 0x7, 0x7 }, // 7506
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V8_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11NSA, 0x1, 0x8, 0x8 }, // 7507
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V9_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11NSA, 0x1, 0x9, 0x9 }, // 7508
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V3_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 7509
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V4_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 7510
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V5_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 7511
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V6_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11NSA, 0x2, 0x6, 0x6 }, // 7512
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V7_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11NSA, 0x2, 0x7, 0x7 }, // 7513
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V8_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11NSA, 0x2, 0x8, 0x8 }, // 7514
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V9_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11NSA, 0x2, 0x9, 0x9 }, // 7515
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V3_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 7516
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V4_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 7517
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V5_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11NSA, 0x3, 0x5, 0x5 }, // 7518
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V6_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11NSA, 0x3, 0x6, 0x6 }, // 7519
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V7_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11NSA, 0x3, 0x7, 0x7 }, // 7520
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V8_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11NSA, 0x3, 0x8, 0x8 }, // 7521
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V9_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11NSA, 0x3, 0x9, 0x9 }, // 7522
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V3_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 7523
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V4_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 7524
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V5_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 7525
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V6_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11NSA, 0x4, 0x6, 0x6 }, // 7526
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V7_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11NSA, 0x4, 0x7, 0x7 }, // 7527
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V8_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11NSA, 0x4, 0x8, 0x8 }, // 7528
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V9_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11NSA, 0x4, 0x9, 0x9 }, // 7529
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V3_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 7530
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V4_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 7531
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V5_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 7532
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V6_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11NSA, 0x5, 0x6, 0x6 }, // 7533
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V7_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11NSA, 0x5, 0x7, 0x7 }, // 7534
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V8_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11NSA, 0x5, 0x8, 0x8 }, // 7535
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V9_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx11NSA, 0x5, 0x9, 0x9 }, // 7536
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V3_gfx12, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 7537
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V4_gfx12, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 7538
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V5_gfx12, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx12, 0x1, 0x5, 0x5 }, // 7539
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V6_gfx12, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx12, 0x1, 0x6, 0x6 }, // 7540
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V7_gfx12, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx12, 0x1, 0x7, 0x7 }, // 7541
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V8_gfx12, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx12, 0x1, 0x8, 0x8 }, // 7542
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V9_gfx12, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx12, 0x1, 0x9, 0x9 }, // 7543
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V3_gfx12, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 7544
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V4_gfx12, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 7545
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V5_gfx12, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx12, 0x2, 0x5, 0x5 }, // 7546
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V6_gfx12, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx12, 0x2, 0x6, 0x6 }, // 7547
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V7_gfx12, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx12, 0x2, 0x7, 0x7 }, // 7548
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V8_gfx12, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx12, 0x2, 0x8, 0x8 }, // 7549
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V9_gfx12, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx12, 0x2, 0x9, 0x9 }, // 7550
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V3_gfx12, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 7551
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V4_gfx12, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 7552
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V5_gfx12, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx12, 0x3, 0x5, 0x5 }, // 7553
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V6_gfx12, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx12, 0x3, 0x6, 0x6 }, // 7554
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V7_gfx12, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx12, 0x3, 0x7, 0x7 }, // 7555
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V8_gfx12, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx12, 0x3, 0x8, 0x8 }, // 7556
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V9_gfx12, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx12, 0x3, 0x9, 0x9 }, // 7557
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V3_gfx12, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 7558
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V4_gfx12, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 7559
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V5_gfx12, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx12, 0x4, 0x5, 0x5 }, // 7560
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V6_gfx12, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx12, 0x4, 0x6, 0x6 }, // 7561
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V7_gfx12, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx12, 0x4, 0x7, 0x7 }, // 7562
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V8_gfx12, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx12, 0x4, 0x8, 0x8 }, // 7563
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V9_gfx12, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx12, 0x4, 0x9, 0x9 }, // 7564
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V3_gfx12, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 7565
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V4_gfx12, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 7566
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V5_gfx12, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx12, 0x5, 0x5, 0x5 }, // 7567
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V6_gfx12, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx12, 0x5, 0x6, 0x6 }, // 7568
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V7_gfx12, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx12, 0x5, 0x7, 0x7 }, // 7569
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V8_gfx12, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx12, 0x5, 0x8, 0x8 }, // 7570
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V9_gfx12, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx12, 0x5, 0x9, 0x9 }, // 7571
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V3, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 7572
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V4, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 7573
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V5, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 7574
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V6, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 7575
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V7, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x1, 0x7, 0x1 }, // 7576
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V8, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 7577
  { IMAGE_SAMPLE_C_D_CL_G16_V1_V9, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x1, 0x9, 0x1 }, // 7578
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V3, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 7579
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V4, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 7580
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V5, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 7581
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V6, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 7582
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V7, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x2, 0x7, 0x1 }, // 7583
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V8, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 7584
  { IMAGE_SAMPLE_C_D_CL_G16_V2_V9, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x2, 0x9, 0x1 }, // 7585
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V3, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 7586
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V4, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 7587
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V5, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 7588
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V6, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 7589
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V7, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x3, 0x7, 0x1 }, // 7590
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V8, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 7591
  { IMAGE_SAMPLE_C_D_CL_G16_V3_V9, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x3, 0x9, 0x1 }, // 7592
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V3, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 7593
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V4, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 7594
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V5, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 7595
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V6, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 7596
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V7, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x4, 0x7, 0x1 }, // 7597
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V8, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 7598
  { IMAGE_SAMPLE_C_D_CL_G16_V4_V9, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x4, 0x9, 0x1 }, // 7599
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V3, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 7600
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V4, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 7601
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V5, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 7602
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V6, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 7603
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V7, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x5, 0x7, 0x1 }, // 7604
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V8, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 7605
  { IMAGE_SAMPLE_C_D_CL_G16_V5_V9, IMAGE_SAMPLE_C_D_CL_G16, MIMGEncGfx6, 0x5, 0x9, 0x1 }, // 7606
  { IMAGE_SAMPLE_C_D_CL_O_V1_V4_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 7607
  { IMAGE_SAMPLE_C_D_CL_O_V1_V5_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 7608
  { IMAGE_SAMPLE_C_D_CL_O_V1_V6_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 7609
  { IMAGE_SAMPLE_C_D_CL_O_V1_V7_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x1, 0x7, 0x1 }, // 7610
  { IMAGE_SAMPLE_C_D_CL_O_V1_V8_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 7611
  { IMAGE_SAMPLE_C_D_CL_O_V1_V9_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x1, 0x9, 0x1 }, // 7612
  { IMAGE_SAMPLE_C_D_CL_O_V1_V10_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x1, 0xA, 0x1 }, // 7613
  { IMAGE_SAMPLE_C_D_CL_O_V1_V11_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x1, 0xB, 0x1 }, // 7614
  { IMAGE_SAMPLE_C_D_CL_O_V1_V12_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x1, 0xC, 0x1 }, // 7615
  { IMAGE_SAMPLE_C_D_CL_O_V2_V4_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 7616
  { IMAGE_SAMPLE_C_D_CL_O_V2_V5_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 7617
  { IMAGE_SAMPLE_C_D_CL_O_V2_V6_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 7618
  { IMAGE_SAMPLE_C_D_CL_O_V2_V7_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x2, 0x7, 0x1 }, // 7619
  { IMAGE_SAMPLE_C_D_CL_O_V2_V8_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 7620
  { IMAGE_SAMPLE_C_D_CL_O_V2_V9_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x2, 0x9, 0x1 }, // 7621
  { IMAGE_SAMPLE_C_D_CL_O_V2_V10_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x2, 0xA, 0x1 }, // 7622
  { IMAGE_SAMPLE_C_D_CL_O_V2_V11_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x2, 0xB, 0x1 }, // 7623
  { IMAGE_SAMPLE_C_D_CL_O_V2_V12_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x2, 0xC, 0x1 }, // 7624
  { IMAGE_SAMPLE_C_D_CL_O_V3_V4_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 7625
  { IMAGE_SAMPLE_C_D_CL_O_V3_V5_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 7626
  { IMAGE_SAMPLE_C_D_CL_O_V3_V6_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 7627
  { IMAGE_SAMPLE_C_D_CL_O_V3_V7_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x3, 0x7, 0x1 }, // 7628
  { IMAGE_SAMPLE_C_D_CL_O_V3_V8_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 7629
  { IMAGE_SAMPLE_C_D_CL_O_V3_V9_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x3, 0x9, 0x1 }, // 7630
  { IMAGE_SAMPLE_C_D_CL_O_V3_V10_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x3, 0xA, 0x1 }, // 7631
  { IMAGE_SAMPLE_C_D_CL_O_V3_V11_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x3, 0xB, 0x1 }, // 7632
  { IMAGE_SAMPLE_C_D_CL_O_V3_V12_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x3, 0xC, 0x1 }, // 7633
  { IMAGE_SAMPLE_C_D_CL_O_V4_V4_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 7634
  { IMAGE_SAMPLE_C_D_CL_O_V4_V5_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 7635
  { IMAGE_SAMPLE_C_D_CL_O_V4_V6_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 7636
  { IMAGE_SAMPLE_C_D_CL_O_V4_V7_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x4, 0x7, 0x1 }, // 7637
  { IMAGE_SAMPLE_C_D_CL_O_V4_V8_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 7638
  { IMAGE_SAMPLE_C_D_CL_O_V4_V9_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x4, 0x9, 0x1 }, // 7639
  { IMAGE_SAMPLE_C_D_CL_O_V4_V10_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x4, 0xA, 0x1 }, // 7640
  { IMAGE_SAMPLE_C_D_CL_O_V4_V11_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x4, 0xB, 0x1 }, // 7641
  { IMAGE_SAMPLE_C_D_CL_O_V4_V12_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x4, 0xC, 0x1 }, // 7642
  { IMAGE_SAMPLE_C_D_CL_O_V5_V4_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 7643
  { IMAGE_SAMPLE_C_D_CL_O_V5_V5_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 7644
  { IMAGE_SAMPLE_C_D_CL_O_V5_V6_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 7645
  { IMAGE_SAMPLE_C_D_CL_O_V5_V7_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x5, 0x7, 0x1 }, // 7646
  { IMAGE_SAMPLE_C_D_CL_O_V5_V8_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 7647
  { IMAGE_SAMPLE_C_D_CL_O_V5_V9_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x5, 0x9, 0x1 }, // 7648
  { IMAGE_SAMPLE_C_D_CL_O_V5_V10_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x5, 0xA, 0x1 }, // 7649
  { IMAGE_SAMPLE_C_D_CL_O_V5_V11_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x5, 0xB, 0x1 }, // 7650
  { IMAGE_SAMPLE_C_D_CL_O_V5_V12_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10Default, 0x5, 0xC, 0x1 }, // 7651
  { IMAGE_SAMPLE_C_D_CL_O_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 7652
  { IMAGE_SAMPLE_C_D_CL_O_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 7653
  { IMAGE_SAMPLE_C_D_CL_O_V1_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 7654
  { IMAGE_SAMPLE_C_D_CL_O_V1_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x1, 0x7, 0x7 }, // 7655
  { IMAGE_SAMPLE_C_D_CL_O_V1_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x1, 0x8, 0x8 }, // 7656
  { IMAGE_SAMPLE_C_D_CL_O_V1_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x1, 0x9, 0x9 }, // 7657
  { IMAGE_SAMPLE_C_D_CL_O_V1_V10_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x1, 0xA, 0xA }, // 7658
  { IMAGE_SAMPLE_C_D_CL_O_V1_V11_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x1, 0xB, 0xB }, // 7659
  { IMAGE_SAMPLE_C_D_CL_O_V1_V12_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x1, 0xC, 0xC }, // 7660
  { IMAGE_SAMPLE_C_D_CL_O_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 7661
  { IMAGE_SAMPLE_C_D_CL_O_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 7662
  { IMAGE_SAMPLE_C_D_CL_O_V2_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 7663
  { IMAGE_SAMPLE_C_D_CL_O_V2_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x2, 0x7, 0x7 }, // 7664
  { IMAGE_SAMPLE_C_D_CL_O_V2_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x2, 0x8, 0x8 }, // 7665
  { IMAGE_SAMPLE_C_D_CL_O_V2_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x2, 0x9, 0x9 }, // 7666
  { IMAGE_SAMPLE_C_D_CL_O_V2_V10_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x2, 0xA, 0xA }, // 7667
  { IMAGE_SAMPLE_C_D_CL_O_V2_V11_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x2, 0xB, 0xB }, // 7668
  { IMAGE_SAMPLE_C_D_CL_O_V2_V12_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x2, 0xC, 0xC }, // 7669
  { IMAGE_SAMPLE_C_D_CL_O_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 7670
  { IMAGE_SAMPLE_C_D_CL_O_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 7671
  { IMAGE_SAMPLE_C_D_CL_O_V3_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 7672
  { IMAGE_SAMPLE_C_D_CL_O_V3_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x3, 0x7, 0x7 }, // 7673
  { IMAGE_SAMPLE_C_D_CL_O_V3_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x3, 0x8, 0x8 }, // 7674
  { IMAGE_SAMPLE_C_D_CL_O_V3_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x3, 0x9, 0x9 }, // 7675
  { IMAGE_SAMPLE_C_D_CL_O_V3_V10_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x3, 0xA, 0xA }, // 7676
  { IMAGE_SAMPLE_C_D_CL_O_V3_V11_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x3, 0xB, 0xB }, // 7677
  { IMAGE_SAMPLE_C_D_CL_O_V3_V12_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x3, 0xC, 0xC }, // 7678
  { IMAGE_SAMPLE_C_D_CL_O_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 7679
  { IMAGE_SAMPLE_C_D_CL_O_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 7680
  { IMAGE_SAMPLE_C_D_CL_O_V4_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 7681
  { IMAGE_SAMPLE_C_D_CL_O_V4_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x4, 0x7, 0x7 }, // 7682
  { IMAGE_SAMPLE_C_D_CL_O_V4_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x4, 0x8, 0x8 }, // 7683
  { IMAGE_SAMPLE_C_D_CL_O_V4_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x4, 0x9, 0x9 }, // 7684
  { IMAGE_SAMPLE_C_D_CL_O_V4_V10_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x4, 0xA, 0xA }, // 7685
  { IMAGE_SAMPLE_C_D_CL_O_V4_V11_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x4, 0xB, 0xB }, // 7686
  { IMAGE_SAMPLE_C_D_CL_O_V4_V12_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x4, 0xC, 0xC }, // 7687
  { IMAGE_SAMPLE_C_D_CL_O_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 7688
  { IMAGE_SAMPLE_C_D_CL_O_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 7689
  { IMAGE_SAMPLE_C_D_CL_O_V5_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 7690
  { IMAGE_SAMPLE_C_D_CL_O_V5_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x5, 0x7, 0x7 }, // 7691
  { IMAGE_SAMPLE_C_D_CL_O_V5_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x5, 0x8, 0x8 }, // 7692
  { IMAGE_SAMPLE_C_D_CL_O_V5_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x5, 0x9, 0x9 }, // 7693
  { IMAGE_SAMPLE_C_D_CL_O_V5_V10_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x5, 0xA, 0xA }, // 7694
  { IMAGE_SAMPLE_C_D_CL_O_V5_V11_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x5, 0xB, 0xB }, // 7695
  { IMAGE_SAMPLE_C_D_CL_O_V5_V12_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx10NSA, 0x5, 0xC, 0xC }, // 7696
  { IMAGE_SAMPLE_C_D_CL_O_V1_V4_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 7697
  { IMAGE_SAMPLE_C_D_CL_O_V1_V5_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x1, 0x5, 0x1 }, // 7698
  { IMAGE_SAMPLE_C_D_CL_O_V1_V6_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x1, 0x6, 0x1 }, // 7699
  { IMAGE_SAMPLE_C_D_CL_O_V1_V7_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x1, 0x7, 0x1 }, // 7700
  { IMAGE_SAMPLE_C_D_CL_O_V1_V8_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x1, 0x8, 0x1 }, // 7701
  { IMAGE_SAMPLE_C_D_CL_O_V1_V9_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x1, 0x9, 0x1 }, // 7702
  { IMAGE_SAMPLE_C_D_CL_O_V1_V10_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x1, 0xA, 0x1 }, // 7703
  { IMAGE_SAMPLE_C_D_CL_O_V1_V11_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x1, 0xB, 0x1 }, // 7704
  { IMAGE_SAMPLE_C_D_CL_O_V1_V12_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x1, 0xC, 0x1 }, // 7705
  { IMAGE_SAMPLE_C_D_CL_O_V2_V4_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 7706
  { IMAGE_SAMPLE_C_D_CL_O_V2_V5_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 7707
  { IMAGE_SAMPLE_C_D_CL_O_V2_V6_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x2, 0x6, 0x1 }, // 7708
  { IMAGE_SAMPLE_C_D_CL_O_V2_V7_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x2, 0x7, 0x1 }, // 7709
  { IMAGE_SAMPLE_C_D_CL_O_V2_V8_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 7710
  { IMAGE_SAMPLE_C_D_CL_O_V2_V9_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x2, 0x9, 0x1 }, // 7711
  { IMAGE_SAMPLE_C_D_CL_O_V2_V10_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x2, 0xA, 0x1 }, // 7712
  { IMAGE_SAMPLE_C_D_CL_O_V2_V11_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x2, 0xB, 0x1 }, // 7713
  { IMAGE_SAMPLE_C_D_CL_O_V2_V12_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x2, 0xC, 0x1 }, // 7714
  { IMAGE_SAMPLE_C_D_CL_O_V3_V4_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 7715
  { IMAGE_SAMPLE_C_D_CL_O_V3_V5_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x3, 0x5, 0x1 }, // 7716
  { IMAGE_SAMPLE_C_D_CL_O_V3_V6_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x3, 0x6, 0x1 }, // 7717
  { IMAGE_SAMPLE_C_D_CL_O_V3_V7_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x3, 0x7, 0x1 }, // 7718
  { IMAGE_SAMPLE_C_D_CL_O_V3_V8_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x3, 0x8, 0x1 }, // 7719
  { IMAGE_SAMPLE_C_D_CL_O_V3_V9_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x3, 0x9, 0x1 }, // 7720
  { IMAGE_SAMPLE_C_D_CL_O_V3_V10_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x3, 0xA, 0x1 }, // 7721
  { IMAGE_SAMPLE_C_D_CL_O_V3_V11_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x3, 0xB, 0x1 }, // 7722
  { IMAGE_SAMPLE_C_D_CL_O_V3_V12_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x3, 0xC, 0x1 }, // 7723
  { IMAGE_SAMPLE_C_D_CL_O_V4_V4_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 7724
  { IMAGE_SAMPLE_C_D_CL_O_V4_V5_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 7725
  { IMAGE_SAMPLE_C_D_CL_O_V4_V6_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x4, 0x6, 0x1 }, // 7726
  { IMAGE_SAMPLE_C_D_CL_O_V4_V7_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x4, 0x7, 0x1 }, // 7727
  { IMAGE_SAMPLE_C_D_CL_O_V4_V8_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 7728
  { IMAGE_SAMPLE_C_D_CL_O_V4_V9_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x4, 0x9, 0x1 }, // 7729
  { IMAGE_SAMPLE_C_D_CL_O_V4_V10_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x4, 0xA, 0x1 }, // 7730
  { IMAGE_SAMPLE_C_D_CL_O_V4_V11_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x4, 0xB, 0x1 }, // 7731
  { IMAGE_SAMPLE_C_D_CL_O_V4_V12_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x4, 0xC, 0x1 }, // 7732
  { IMAGE_SAMPLE_C_D_CL_O_V5_V4_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 7733
  { IMAGE_SAMPLE_C_D_CL_O_V5_V5_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 7734
  { IMAGE_SAMPLE_C_D_CL_O_V5_V6_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x5, 0x6, 0x1 }, // 7735
  { IMAGE_SAMPLE_C_D_CL_O_V5_V7_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x5, 0x7, 0x1 }, // 7736
  { IMAGE_SAMPLE_C_D_CL_O_V5_V8_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 7737
  { IMAGE_SAMPLE_C_D_CL_O_V5_V9_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x5, 0x9, 0x1 }, // 7738
  { IMAGE_SAMPLE_C_D_CL_O_V5_V10_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x5, 0xA, 0x1 }, // 7739
  { IMAGE_SAMPLE_C_D_CL_O_V5_V11_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x5, 0xB, 0x1 }, // 7740
  { IMAGE_SAMPLE_C_D_CL_O_V5_V12_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11Default, 0x5, 0xC, 0x1 }, // 7741
  { IMAGE_SAMPLE_C_D_CL_O_V1_V4_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 7742
  { IMAGE_SAMPLE_C_D_CL_O_V1_V5_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x1, 0x5, 0x5 }, // 7743
  { IMAGE_SAMPLE_C_D_CL_O_V1_V6_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x1, 0x6, 0x6 }, // 7744
  { IMAGE_SAMPLE_C_D_CL_O_V1_V7_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x1, 0x7, 0x7 }, // 7745
  { IMAGE_SAMPLE_C_D_CL_O_V1_V8_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x1, 0x8, 0x8 }, // 7746
  { IMAGE_SAMPLE_C_D_CL_O_V1_V9_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x1, 0x9, 0x9 }, // 7747
  { IMAGE_SAMPLE_C_D_CL_O_V1_V10_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x1, 0xA, 0xA }, // 7748
  { IMAGE_SAMPLE_C_D_CL_O_V1_V11_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x1, 0xB, 0xB }, // 7749
  { IMAGE_SAMPLE_C_D_CL_O_V1_V12_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x1, 0xC, 0xC }, // 7750
  { IMAGE_SAMPLE_C_D_CL_O_V2_V4_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 7751
  { IMAGE_SAMPLE_C_D_CL_O_V2_V5_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 7752
  { IMAGE_SAMPLE_C_D_CL_O_V2_V6_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x2, 0x6, 0x6 }, // 7753
  { IMAGE_SAMPLE_C_D_CL_O_V2_V7_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x2, 0x7, 0x7 }, // 7754
  { IMAGE_SAMPLE_C_D_CL_O_V2_V8_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x2, 0x8, 0x8 }, // 7755
  { IMAGE_SAMPLE_C_D_CL_O_V2_V9_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x2, 0x9, 0x9 }, // 7756
  { IMAGE_SAMPLE_C_D_CL_O_V2_V10_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x2, 0xA, 0xA }, // 7757
  { IMAGE_SAMPLE_C_D_CL_O_V2_V11_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x2, 0xB, 0xB }, // 7758
  { IMAGE_SAMPLE_C_D_CL_O_V2_V12_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x2, 0xC, 0xC }, // 7759
  { IMAGE_SAMPLE_C_D_CL_O_V3_V4_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 7760
  { IMAGE_SAMPLE_C_D_CL_O_V3_V5_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x3, 0x5, 0x5 }, // 7761
  { IMAGE_SAMPLE_C_D_CL_O_V3_V6_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x3, 0x6, 0x6 }, // 7762
  { IMAGE_SAMPLE_C_D_CL_O_V3_V7_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x3, 0x7, 0x7 }, // 7763
  { IMAGE_SAMPLE_C_D_CL_O_V3_V8_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x3, 0x8, 0x8 }, // 7764
  { IMAGE_SAMPLE_C_D_CL_O_V3_V9_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x3, 0x9, 0x9 }, // 7765
  { IMAGE_SAMPLE_C_D_CL_O_V3_V10_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x3, 0xA, 0xA }, // 7766
  { IMAGE_SAMPLE_C_D_CL_O_V3_V11_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x3, 0xB, 0xB }, // 7767
  { IMAGE_SAMPLE_C_D_CL_O_V3_V12_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x3, 0xC, 0xC }, // 7768
  { IMAGE_SAMPLE_C_D_CL_O_V4_V4_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 7769
  { IMAGE_SAMPLE_C_D_CL_O_V4_V5_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 7770
  { IMAGE_SAMPLE_C_D_CL_O_V4_V6_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x4, 0x6, 0x6 }, // 7771
  { IMAGE_SAMPLE_C_D_CL_O_V4_V7_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x4, 0x7, 0x7 }, // 7772
  { IMAGE_SAMPLE_C_D_CL_O_V4_V8_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x4, 0x8, 0x8 }, // 7773
  { IMAGE_SAMPLE_C_D_CL_O_V4_V9_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x4, 0x9, 0x9 }, // 7774
  { IMAGE_SAMPLE_C_D_CL_O_V4_V10_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x4, 0xA, 0xA }, // 7775
  { IMAGE_SAMPLE_C_D_CL_O_V4_V11_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x4, 0xB, 0xB }, // 7776
  { IMAGE_SAMPLE_C_D_CL_O_V4_V12_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x4, 0xC, 0xC }, // 7777
  { IMAGE_SAMPLE_C_D_CL_O_V5_V4_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 7778
  { IMAGE_SAMPLE_C_D_CL_O_V5_V5_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 7779
  { IMAGE_SAMPLE_C_D_CL_O_V5_V6_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x5, 0x6, 0x6 }, // 7780
  { IMAGE_SAMPLE_C_D_CL_O_V5_V7_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x5, 0x7, 0x7 }, // 7781
  { IMAGE_SAMPLE_C_D_CL_O_V5_V8_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x5, 0x8, 0x8 }, // 7782
  { IMAGE_SAMPLE_C_D_CL_O_V5_V9_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x5, 0x9, 0x9 }, // 7783
  { IMAGE_SAMPLE_C_D_CL_O_V5_V10_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x5, 0xA, 0xA }, // 7784
  { IMAGE_SAMPLE_C_D_CL_O_V5_V11_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x5, 0xB, 0xB }, // 7785
  { IMAGE_SAMPLE_C_D_CL_O_V5_V12_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx11NSA, 0x5, 0xC, 0xC }, // 7786
  { IMAGE_SAMPLE_C_D_CL_O_V1_V4_gfx12, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 7787
  { IMAGE_SAMPLE_C_D_CL_O_V1_V5_gfx12, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx12, 0x1, 0x5, 0x5 }, // 7788
  { IMAGE_SAMPLE_C_D_CL_O_V1_V6_gfx12, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx12, 0x1, 0x6, 0x6 }, // 7789
  { IMAGE_SAMPLE_C_D_CL_O_V1_V7_gfx12, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx12, 0x1, 0x7, 0x7 }, // 7790
  { IMAGE_SAMPLE_C_D_CL_O_V1_V8_gfx12, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx12, 0x1, 0x8, 0x8 }, // 7791
  { IMAGE_SAMPLE_C_D_CL_O_V1_V9_gfx12, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx12, 0x1, 0x9, 0x9 }, // 7792
  { IMAGE_SAMPLE_C_D_CL_O_V1_V10_gfx12, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx12, 0x1, 0xA, 0xA }, // 7793
  { IMAGE_SAMPLE_C_D_CL_O_V1_V11_gfx12, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx12, 0x1, 0xB, 0xB }, // 7794
  { IMAGE_SAMPLE_C_D_CL_O_V1_V12_gfx12, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx12, 0x1, 0xC, 0xC }, // 7795
  { IMAGE_SAMPLE_C_D_CL_O_V2_V4_gfx12, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 7796
  { IMAGE_SAMPLE_C_D_CL_O_V2_V5_gfx12, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx12, 0x2, 0x5, 0x5 }, // 7797
  { IMAGE_SAMPLE_C_D_CL_O_V2_V6_gfx12, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx12, 0x2, 0x6, 0x6 }, // 7798
  { IMAGE_SAMPLE_C_D_CL_O_V2_V7_gfx12, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx12, 0x2, 0x7, 0x7 }, // 7799
  { IMAGE_SAMPLE_C_D_CL_O_V2_V8_gfx12, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx12, 0x2, 0x8, 0x8 }, // 7800
  { IMAGE_SAMPLE_C_D_CL_O_V2_V9_gfx12, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx12, 0x2, 0x9, 0x9 }, // 7801
  { IMAGE_SAMPLE_C_D_CL_O_V2_V10_gfx12, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx12, 0x2, 0xA, 0xA }, // 7802
  { IMAGE_SAMPLE_C_D_CL_O_V2_V11_gfx12, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx12, 0x2, 0xB, 0xB }, // 7803
  { IMAGE_SAMPLE_C_D_CL_O_V2_V12_gfx12, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx12, 0x2, 0xC, 0xC }, // 7804
  { IMAGE_SAMPLE_C_D_CL_O_V3_V4_gfx12, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 7805
  { IMAGE_SAMPLE_C_D_CL_O_V3_V5_gfx12, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx12, 0x3, 0x5, 0x5 }, // 7806
  { IMAGE_SAMPLE_C_D_CL_O_V3_V6_gfx12, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx12, 0x3, 0x6, 0x6 }, // 7807
  { IMAGE_SAMPLE_C_D_CL_O_V3_V7_gfx12, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx12, 0x3, 0x7, 0x7 }, // 7808
  { IMAGE_SAMPLE_C_D_CL_O_V3_V8_gfx12, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx12, 0x3, 0x8, 0x8 }, // 7809
  { IMAGE_SAMPLE_C_D_CL_O_V3_V9_gfx12, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx12, 0x3, 0x9, 0x9 }, // 7810
  { IMAGE_SAMPLE_C_D_CL_O_V3_V10_gfx12, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx12, 0x3, 0xA, 0xA }, // 7811
  { IMAGE_SAMPLE_C_D_CL_O_V3_V11_gfx12, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx12, 0x3, 0xB, 0xB }, // 7812
  { IMAGE_SAMPLE_C_D_CL_O_V3_V12_gfx12, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx12, 0x3, 0xC, 0xC }, // 7813
  { IMAGE_SAMPLE_C_D_CL_O_V4_V4_gfx12, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 7814
  { IMAGE_SAMPLE_C_D_CL_O_V4_V5_gfx12, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx12, 0x4, 0x5, 0x5 }, // 7815
  { IMAGE_SAMPLE_C_D_CL_O_V4_V6_gfx12, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx12, 0x4, 0x6, 0x6 }, // 7816
  { IMAGE_SAMPLE_C_D_CL_O_V4_V7_gfx12, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx12, 0x4, 0x7, 0x7 }, // 7817
  { IMAGE_SAMPLE_C_D_CL_O_V4_V8_gfx12, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx12, 0x4, 0x8, 0x8 }, // 7818
  { IMAGE_SAMPLE_C_D_CL_O_V4_V9_gfx12, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx12, 0x4, 0x9, 0x9 }, // 7819
  { IMAGE_SAMPLE_C_D_CL_O_V4_V10_gfx12, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx12, 0x4, 0xA, 0xA }, // 7820
  { IMAGE_SAMPLE_C_D_CL_O_V4_V11_gfx12, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx12, 0x4, 0xB, 0xB }, // 7821
  { IMAGE_SAMPLE_C_D_CL_O_V4_V12_gfx12, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx12, 0x4, 0xC, 0xC }, // 7822
  { IMAGE_SAMPLE_C_D_CL_O_V5_V4_gfx12, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 7823
  { IMAGE_SAMPLE_C_D_CL_O_V5_V5_gfx12, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx12, 0x5, 0x5, 0x5 }, // 7824
  { IMAGE_SAMPLE_C_D_CL_O_V5_V6_gfx12, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx12, 0x5, 0x6, 0x6 }, // 7825
  { IMAGE_SAMPLE_C_D_CL_O_V5_V7_gfx12, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx12, 0x5, 0x7, 0x7 }, // 7826
  { IMAGE_SAMPLE_C_D_CL_O_V5_V8_gfx12, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx12, 0x5, 0x8, 0x8 }, // 7827
  { IMAGE_SAMPLE_C_D_CL_O_V5_V9_gfx12, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx12, 0x5, 0x9, 0x9 }, // 7828
  { IMAGE_SAMPLE_C_D_CL_O_V5_V10_gfx12, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx12, 0x5, 0xA, 0xA }, // 7829
  { IMAGE_SAMPLE_C_D_CL_O_V5_V11_gfx12, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx12, 0x5, 0xB, 0xB }, // 7830
  { IMAGE_SAMPLE_C_D_CL_O_V5_V12_gfx12, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx12, 0x5, 0xC, 0xC }, // 7831
  { IMAGE_SAMPLE_C_D_CL_O_V1_V4, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 7832
  { IMAGE_SAMPLE_C_D_CL_O_V1_V5, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 7833
  { IMAGE_SAMPLE_C_D_CL_O_V1_V6, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 7834
  { IMAGE_SAMPLE_C_D_CL_O_V1_V7, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x1, 0x7, 0x1 }, // 7835
  { IMAGE_SAMPLE_C_D_CL_O_V1_V8, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 7836
  { IMAGE_SAMPLE_C_D_CL_O_V1_V9, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x1, 0x9, 0x1 }, // 7837
  { IMAGE_SAMPLE_C_D_CL_O_V1_V10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x1, 0xA, 0x1 }, // 7838
  { IMAGE_SAMPLE_C_D_CL_O_V1_V11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x1, 0xB, 0x1 }, // 7839
  { IMAGE_SAMPLE_C_D_CL_O_V1_V12, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x1, 0xC, 0x1 }, // 7840
  { IMAGE_SAMPLE_C_D_CL_O_V2_V4, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 7841
  { IMAGE_SAMPLE_C_D_CL_O_V2_V5, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 7842
  { IMAGE_SAMPLE_C_D_CL_O_V2_V6, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 7843
  { IMAGE_SAMPLE_C_D_CL_O_V2_V7, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x2, 0x7, 0x1 }, // 7844
  { IMAGE_SAMPLE_C_D_CL_O_V2_V8, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 7845
  { IMAGE_SAMPLE_C_D_CL_O_V2_V9, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x2, 0x9, 0x1 }, // 7846
  { IMAGE_SAMPLE_C_D_CL_O_V2_V10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x2, 0xA, 0x1 }, // 7847
  { IMAGE_SAMPLE_C_D_CL_O_V2_V11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x2, 0xB, 0x1 }, // 7848
  { IMAGE_SAMPLE_C_D_CL_O_V2_V12, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x2, 0xC, 0x1 }, // 7849
  { IMAGE_SAMPLE_C_D_CL_O_V3_V4, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 7850
  { IMAGE_SAMPLE_C_D_CL_O_V3_V5, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 7851
  { IMAGE_SAMPLE_C_D_CL_O_V3_V6, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 7852
  { IMAGE_SAMPLE_C_D_CL_O_V3_V7, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x3, 0x7, 0x1 }, // 7853
  { IMAGE_SAMPLE_C_D_CL_O_V3_V8, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 7854
  { IMAGE_SAMPLE_C_D_CL_O_V3_V9, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x3, 0x9, 0x1 }, // 7855
  { IMAGE_SAMPLE_C_D_CL_O_V3_V10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x3, 0xA, 0x1 }, // 7856
  { IMAGE_SAMPLE_C_D_CL_O_V3_V11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x3, 0xB, 0x1 }, // 7857
  { IMAGE_SAMPLE_C_D_CL_O_V3_V12, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x3, 0xC, 0x1 }, // 7858
  { IMAGE_SAMPLE_C_D_CL_O_V4_V4, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 7859
  { IMAGE_SAMPLE_C_D_CL_O_V4_V5, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 7860
  { IMAGE_SAMPLE_C_D_CL_O_V4_V6, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 7861
  { IMAGE_SAMPLE_C_D_CL_O_V4_V7, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x4, 0x7, 0x1 }, // 7862
  { IMAGE_SAMPLE_C_D_CL_O_V4_V8, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 7863
  { IMAGE_SAMPLE_C_D_CL_O_V4_V9, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x4, 0x9, 0x1 }, // 7864
  { IMAGE_SAMPLE_C_D_CL_O_V4_V10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x4, 0xA, 0x1 }, // 7865
  { IMAGE_SAMPLE_C_D_CL_O_V4_V11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x4, 0xB, 0x1 }, // 7866
  { IMAGE_SAMPLE_C_D_CL_O_V4_V12, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x4, 0xC, 0x1 }, // 7867
  { IMAGE_SAMPLE_C_D_CL_O_V5_V4, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 7868
  { IMAGE_SAMPLE_C_D_CL_O_V5_V5, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 7869
  { IMAGE_SAMPLE_C_D_CL_O_V5_V6, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 7870
  { IMAGE_SAMPLE_C_D_CL_O_V5_V7, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x5, 0x7, 0x1 }, // 7871
  { IMAGE_SAMPLE_C_D_CL_O_V5_V8, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 7872
  { IMAGE_SAMPLE_C_D_CL_O_V5_V9, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x5, 0x9, 0x1 }, // 7873
  { IMAGE_SAMPLE_C_D_CL_O_V5_V10, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x5, 0xA, 0x1 }, // 7874
  { IMAGE_SAMPLE_C_D_CL_O_V5_V11, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x5, 0xB, 0x1 }, // 7875
  { IMAGE_SAMPLE_C_D_CL_O_V5_V12, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x5, 0xC, 0x1 }, // 7876
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V4_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 7877
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V5_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 7878
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V6_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 7879
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V7_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x7, 0x1 }, // 7880
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V8_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 7881
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V9_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x9, 0x1 }, // 7882
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V10_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x1, 0xA, 0x1 }, // 7883
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V4_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 7884
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V5_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 7885
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V6_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 7886
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V7_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x7, 0x1 }, // 7887
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V8_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 7888
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V9_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x9, 0x1 }, // 7889
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V10_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x2, 0xA, 0x1 }, // 7890
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V4_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 7891
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V5_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 7892
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V6_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 7893
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V7_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x7, 0x1 }, // 7894
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V8_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 7895
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V9_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x9, 0x1 }, // 7896
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V10_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x3, 0xA, 0x1 }, // 7897
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V4_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 7898
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V5_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 7899
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V6_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 7900
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V7_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x7, 0x1 }, // 7901
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V8_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 7902
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V9_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x9, 0x1 }, // 7903
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V10_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x4, 0xA, 0x1 }, // 7904
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V4_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 7905
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V5_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 7906
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V6_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 7907
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V7_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x7, 0x1 }, // 7908
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V8_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 7909
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V9_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x9, 0x1 }, // 7910
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V10_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10Default, 0x5, 0xA, 0x1 }, // 7911
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 7912
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 7913
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 7914
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x7, 0x7 }, // 7915
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x8, 0x8 }, // 7916
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x9, 0x9 }, // 7917
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V10_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0xA, 0xA }, // 7918
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 7919
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 7920
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 7921
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x7, 0x7 }, // 7922
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x8, 0x8 }, // 7923
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x9, 0x9 }, // 7924
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V10_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0xA, 0xA }, // 7925
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 7926
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 7927
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 7928
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x7, 0x7 }, // 7929
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x8, 0x8 }, // 7930
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x9, 0x9 }, // 7931
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V10_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0xA, 0xA }, // 7932
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 7933
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 7934
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 7935
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x7, 0x7 }, // 7936
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x8, 0x8 }, // 7937
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x9, 0x9 }, // 7938
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V10_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0xA, 0xA }, // 7939
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 7940
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 7941
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 7942
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x7, 0x7 }, // 7943
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x8, 0x8 }, // 7944
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V9_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x9, 0x9 }, // 7945
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V10_nsa_gfx10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0xA, 0xA }, // 7946
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V4_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 7947
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V5_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11Default, 0x1, 0x5, 0x1 }, // 7948
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V6_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11Default, 0x1, 0x6, 0x1 }, // 7949
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V7_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11Default, 0x1, 0x7, 0x1 }, // 7950
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V8_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11Default, 0x1, 0x8, 0x1 }, // 7951
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V9_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11Default, 0x1, 0x9, 0x1 }, // 7952
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V10_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11Default, 0x1, 0xA, 0x1 }, // 7953
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V4_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 7954
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V5_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 7955
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V6_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11Default, 0x2, 0x6, 0x1 }, // 7956
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V7_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11Default, 0x2, 0x7, 0x1 }, // 7957
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V8_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 7958
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V9_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11Default, 0x2, 0x9, 0x1 }, // 7959
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V10_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11Default, 0x2, 0xA, 0x1 }, // 7960
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V4_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 7961
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V5_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11Default, 0x3, 0x5, 0x1 }, // 7962
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V6_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11Default, 0x3, 0x6, 0x1 }, // 7963
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V7_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11Default, 0x3, 0x7, 0x1 }, // 7964
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V8_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11Default, 0x3, 0x8, 0x1 }, // 7965
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V9_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11Default, 0x3, 0x9, 0x1 }, // 7966
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V10_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11Default, 0x3, 0xA, 0x1 }, // 7967
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V4_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 7968
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V5_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 7969
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V6_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11Default, 0x4, 0x6, 0x1 }, // 7970
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V7_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11Default, 0x4, 0x7, 0x1 }, // 7971
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V8_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 7972
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V9_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11Default, 0x4, 0x9, 0x1 }, // 7973
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V10_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11Default, 0x4, 0xA, 0x1 }, // 7974
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V4_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 7975
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V5_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 7976
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V6_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11Default, 0x5, 0x6, 0x1 }, // 7977
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V7_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11Default, 0x5, 0x7, 0x1 }, // 7978
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V8_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 7979
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V9_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11Default, 0x5, 0x9, 0x1 }, // 7980
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V10_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11Default, 0x5, 0xA, 0x1 }, // 7981
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V4_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 7982
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V5_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11NSA, 0x1, 0x5, 0x5 }, // 7983
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V6_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11NSA, 0x1, 0x6, 0x6 }, // 7984
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V7_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11NSA, 0x1, 0x7, 0x7 }, // 7985
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V8_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11NSA, 0x1, 0x8, 0x8 }, // 7986
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V9_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11NSA, 0x1, 0x9, 0x9 }, // 7987
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V10_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11NSA, 0x1, 0xA, 0xA }, // 7988
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V4_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 7989
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V5_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 7990
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V6_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11NSA, 0x2, 0x6, 0x6 }, // 7991
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V7_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11NSA, 0x2, 0x7, 0x7 }, // 7992
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V8_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11NSA, 0x2, 0x8, 0x8 }, // 7993
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V9_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11NSA, 0x2, 0x9, 0x9 }, // 7994
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V10_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11NSA, 0x2, 0xA, 0xA }, // 7995
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V4_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 7996
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V5_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11NSA, 0x3, 0x5, 0x5 }, // 7997
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V6_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11NSA, 0x3, 0x6, 0x6 }, // 7998
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V7_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11NSA, 0x3, 0x7, 0x7 }, // 7999
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V8_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11NSA, 0x3, 0x8, 0x8 }, // 8000
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V9_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11NSA, 0x3, 0x9, 0x9 }, // 8001
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V10_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11NSA, 0x3, 0xA, 0xA }, // 8002
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V4_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 8003
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V5_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 8004
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V6_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11NSA, 0x4, 0x6, 0x6 }, // 8005
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V7_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11NSA, 0x4, 0x7, 0x7 }, // 8006
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V8_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11NSA, 0x4, 0x8, 0x8 }, // 8007
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V9_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11NSA, 0x4, 0x9, 0x9 }, // 8008
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V10_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11NSA, 0x4, 0xA, 0xA }, // 8009
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V4_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 8010
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V5_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 8011
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V6_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11NSA, 0x5, 0x6, 0x6 }, // 8012
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V7_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11NSA, 0x5, 0x7, 0x7 }, // 8013
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V8_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11NSA, 0x5, 0x8, 0x8 }, // 8014
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V9_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11NSA, 0x5, 0x9, 0x9 }, // 8015
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V10_nsa_gfx11, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx11NSA, 0x5, 0xA, 0xA }, // 8016
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V4_gfx12, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 8017
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V5_gfx12, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx12, 0x1, 0x5, 0x5 }, // 8018
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V6_gfx12, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx12, 0x1, 0x6, 0x6 }, // 8019
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V7_gfx12, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx12, 0x1, 0x7, 0x7 }, // 8020
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V8_gfx12, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx12, 0x1, 0x8, 0x8 }, // 8021
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V9_gfx12, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx12, 0x1, 0x9, 0x9 }, // 8022
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V10_gfx12, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx12, 0x1, 0xA, 0xA }, // 8023
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V4_gfx12, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 8024
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V5_gfx12, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx12, 0x2, 0x5, 0x5 }, // 8025
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V6_gfx12, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx12, 0x2, 0x6, 0x6 }, // 8026
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V7_gfx12, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx12, 0x2, 0x7, 0x7 }, // 8027
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V8_gfx12, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx12, 0x2, 0x8, 0x8 }, // 8028
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V9_gfx12, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx12, 0x2, 0x9, 0x9 }, // 8029
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V10_gfx12, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx12, 0x2, 0xA, 0xA }, // 8030
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V4_gfx12, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 8031
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V5_gfx12, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx12, 0x3, 0x5, 0x5 }, // 8032
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V6_gfx12, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx12, 0x3, 0x6, 0x6 }, // 8033
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V7_gfx12, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx12, 0x3, 0x7, 0x7 }, // 8034
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V8_gfx12, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx12, 0x3, 0x8, 0x8 }, // 8035
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V9_gfx12, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx12, 0x3, 0x9, 0x9 }, // 8036
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V10_gfx12, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx12, 0x3, 0xA, 0xA }, // 8037
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V4_gfx12, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 8038
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V5_gfx12, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx12, 0x4, 0x5, 0x5 }, // 8039
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V6_gfx12, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx12, 0x4, 0x6, 0x6 }, // 8040
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V7_gfx12, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx12, 0x4, 0x7, 0x7 }, // 8041
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V8_gfx12, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx12, 0x4, 0x8, 0x8 }, // 8042
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V9_gfx12, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx12, 0x4, 0x9, 0x9 }, // 8043
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V10_gfx12, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx12, 0x4, 0xA, 0xA }, // 8044
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V4_gfx12, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 8045
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V5_gfx12, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx12, 0x5, 0x5, 0x5 }, // 8046
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V6_gfx12, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx12, 0x5, 0x6, 0x6 }, // 8047
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V7_gfx12, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx12, 0x5, 0x7, 0x7 }, // 8048
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V8_gfx12, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx12, 0x5, 0x8, 0x8 }, // 8049
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V9_gfx12, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx12, 0x5, 0x9, 0x9 }, // 8050
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V10_gfx12, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx12, 0x5, 0xA, 0xA }, // 8051
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V4, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 8052
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V5, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 8053
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V6, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 8054
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V7, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x1, 0x7, 0x1 }, // 8055
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V8, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 8056
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V9, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x1, 0x9, 0x1 }, // 8057
  { IMAGE_SAMPLE_C_D_CL_O_G16_V1_V10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x1, 0xA, 0x1 }, // 8058
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V4, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 8059
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V5, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 8060
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V6, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 8061
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V7, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x2, 0x7, 0x1 }, // 8062
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V8, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 8063
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V9, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x2, 0x9, 0x1 }, // 8064
  { IMAGE_SAMPLE_C_D_CL_O_G16_V2_V10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x2, 0xA, 0x1 }, // 8065
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V4, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 8066
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V5, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 8067
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V6, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 8068
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V7, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x3, 0x7, 0x1 }, // 8069
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V8, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 8070
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V9, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x3, 0x9, 0x1 }, // 8071
  { IMAGE_SAMPLE_C_D_CL_O_G16_V3_V10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x3, 0xA, 0x1 }, // 8072
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V4, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 8073
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V5, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 8074
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V6, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 8075
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V7, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x4, 0x7, 0x1 }, // 8076
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V8, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 8077
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V9, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x4, 0x9, 0x1 }, // 8078
  { IMAGE_SAMPLE_C_D_CL_O_G16_V4_V10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x4, 0xA, 0x1 }, // 8079
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V4, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 8080
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V5, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 8081
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V6, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 8082
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V7, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x5, 0x7, 0x1 }, // 8083
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V8, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 8084
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V9, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x5, 0x9, 0x1 }, // 8085
  { IMAGE_SAMPLE_C_D_CL_O_G16_V5_V10, IMAGE_SAMPLE_C_D_CL_O_G16, MIMGEncGfx6, 0x5, 0xA, 0x1 }, // 8086
  { IMAGE_SAMPLE_C_D_G16_V1_V3_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 8087
  { IMAGE_SAMPLE_C_D_G16_V1_V4_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 8088
  { IMAGE_SAMPLE_C_D_G16_V1_V5_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 8089
  { IMAGE_SAMPLE_C_D_G16_V1_V6_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 8090
  { IMAGE_SAMPLE_C_D_G16_V1_V7_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x1, 0x7, 0x1 }, // 8091
  { IMAGE_SAMPLE_C_D_G16_V1_V8_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 8092
  { IMAGE_SAMPLE_C_D_G16_V2_V3_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 8093
  { IMAGE_SAMPLE_C_D_G16_V2_V4_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 8094
  { IMAGE_SAMPLE_C_D_G16_V2_V5_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 8095
  { IMAGE_SAMPLE_C_D_G16_V2_V6_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 8096
  { IMAGE_SAMPLE_C_D_G16_V2_V7_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x2, 0x7, 0x1 }, // 8097
  { IMAGE_SAMPLE_C_D_G16_V2_V8_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 8098
  { IMAGE_SAMPLE_C_D_G16_V3_V3_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 8099
  { IMAGE_SAMPLE_C_D_G16_V3_V4_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 8100
  { IMAGE_SAMPLE_C_D_G16_V3_V5_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 8101
  { IMAGE_SAMPLE_C_D_G16_V3_V6_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 8102
  { IMAGE_SAMPLE_C_D_G16_V3_V7_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x3, 0x7, 0x1 }, // 8103
  { IMAGE_SAMPLE_C_D_G16_V3_V8_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 8104
  { IMAGE_SAMPLE_C_D_G16_V4_V3_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 8105
  { IMAGE_SAMPLE_C_D_G16_V4_V4_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 8106
  { IMAGE_SAMPLE_C_D_G16_V4_V5_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 8107
  { IMAGE_SAMPLE_C_D_G16_V4_V6_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 8108
  { IMAGE_SAMPLE_C_D_G16_V4_V7_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x4, 0x7, 0x1 }, // 8109
  { IMAGE_SAMPLE_C_D_G16_V4_V8_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 8110
  { IMAGE_SAMPLE_C_D_G16_V5_V3_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 8111
  { IMAGE_SAMPLE_C_D_G16_V5_V4_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 8112
  { IMAGE_SAMPLE_C_D_G16_V5_V5_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 8113
  { IMAGE_SAMPLE_C_D_G16_V5_V6_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 8114
  { IMAGE_SAMPLE_C_D_G16_V5_V7_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x5, 0x7, 0x1 }, // 8115
  { IMAGE_SAMPLE_C_D_G16_V5_V8_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 8116
  { IMAGE_SAMPLE_C_D_G16_V1_V3_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 8117
  { IMAGE_SAMPLE_C_D_G16_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 8118
  { IMAGE_SAMPLE_C_D_G16_V1_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 8119
  { IMAGE_SAMPLE_C_D_G16_V1_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 8120
  { IMAGE_SAMPLE_C_D_G16_V1_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x1, 0x7, 0x7 }, // 8121
  { IMAGE_SAMPLE_C_D_G16_V1_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x1, 0x8, 0x8 }, // 8122
  { IMAGE_SAMPLE_C_D_G16_V2_V3_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 8123
  { IMAGE_SAMPLE_C_D_G16_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 8124
  { IMAGE_SAMPLE_C_D_G16_V2_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 8125
  { IMAGE_SAMPLE_C_D_G16_V2_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 8126
  { IMAGE_SAMPLE_C_D_G16_V2_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x2, 0x7, 0x7 }, // 8127
  { IMAGE_SAMPLE_C_D_G16_V2_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x2, 0x8, 0x8 }, // 8128
  { IMAGE_SAMPLE_C_D_G16_V3_V3_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 8129
  { IMAGE_SAMPLE_C_D_G16_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 8130
  { IMAGE_SAMPLE_C_D_G16_V3_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 8131
  { IMAGE_SAMPLE_C_D_G16_V3_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 8132
  { IMAGE_SAMPLE_C_D_G16_V3_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x3, 0x7, 0x7 }, // 8133
  { IMAGE_SAMPLE_C_D_G16_V3_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x3, 0x8, 0x8 }, // 8134
  { IMAGE_SAMPLE_C_D_G16_V4_V3_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 8135
  { IMAGE_SAMPLE_C_D_G16_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 8136
  { IMAGE_SAMPLE_C_D_G16_V4_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 8137
  { IMAGE_SAMPLE_C_D_G16_V4_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 8138
  { IMAGE_SAMPLE_C_D_G16_V4_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x4, 0x7, 0x7 }, // 8139
  { IMAGE_SAMPLE_C_D_G16_V4_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x4, 0x8, 0x8 }, // 8140
  { IMAGE_SAMPLE_C_D_G16_V5_V3_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 8141
  { IMAGE_SAMPLE_C_D_G16_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 8142
  { IMAGE_SAMPLE_C_D_G16_V5_V5_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 8143
  { IMAGE_SAMPLE_C_D_G16_V5_V6_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 8144
  { IMAGE_SAMPLE_C_D_G16_V5_V7_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x5, 0x7, 0x7 }, // 8145
  { IMAGE_SAMPLE_C_D_G16_V5_V8_nsa_gfx10, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx10NSA, 0x5, 0x8, 0x8 }, // 8146
  { IMAGE_SAMPLE_C_D_G16_V1_V3_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 8147
  { IMAGE_SAMPLE_C_D_G16_V1_V4_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 8148
  { IMAGE_SAMPLE_C_D_G16_V1_V5_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11Default, 0x1, 0x5, 0x1 }, // 8149
  { IMAGE_SAMPLE_C_D_G16_V1_V6_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11Default, 0x1, 0x6, 0x1 }, // 8150
  { IMAGE_SAMPLE_C_D_G16_V1_V7_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11Default, 0x1, 0x7, 0x1 }, // 8151
  { IMAGE_SAMPLE_C_D_G16_V1_V8_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11Default, 0x1, 0x8, 0x1 }, // 8152
  { IMAGE_SAMPLE_C_D_G16_V2_V3_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 8153
  { IMAGE_SAMPLE_C_D_G16_V2_V4_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 8154
  { IMAGE_SAMPLE_C_D_G16_V2_V5_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 8155
  { IMAGE_SAMPLE_C_D_G16_V2_V6_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11Default, 0x2, 0x6, 0x1 }, // 8156
  { IMAGE_SAMPLE_C_D_G16_V2_V7_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11Default, 0x2, 0x7, 0x1 }, // 8157
  { IMAGE_SAMPLE_C_D_G16_V2_V8_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 8158
  { IMAGE_SAMPLE_C_D_G16_V3_V3_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 8159
  { IMAGE_SAMPLE_C_D_G16_V3_V4_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 8160
  { IMAGE_SAMPLE_C_D_G16_V3_V5_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11Default, 0x3, 0x5, 0x1 }, // 8161
  { IMAGE_SAMPLE_C_D_G16_V3_V6_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11Default, 0x3, 0x6, 0x1 }, // 8162
  { IMAGE_SAMPLE_C_D_G16_V3_V7_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11Default, 0x3, 0x7, 0x1 }, // 8163
  { IMAGE_SAMPLE_C_D_G16_V3_V8_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11Default, 0x3, 0x8, 0x1 }, // 8164
  { IMAGE_SAMPLE_C_D_G16_V4_V3_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 8165
  { IMAGE_SAMPLE_C_D_G16_V4_V4_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 8166
  { IMAGE_SAMPLE_C_D_G16_V4_V5_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 8167
  { IMAGE_SAMPLE_C_D_G16_V4_V6_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11Default, 0x4, 0x6, 0x1 }, // 8168
  { IMAGE_SAMPLE_C_D_G16_V4_V7_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11Default, 0x4, 0x7, 0x1 }, // 8169
  { IMAGE_SAMPLE_C_D_G16_V4_V8_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 8170
  { IMAGE_SAMPLE_C_D_G16_V5_V3_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 8171
  { IMAGE_SAMPLE_C_D_G16_V5_V4_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 8172
  { IMAGE_SAMPLE_C_D_G16_V5_V5_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 8173
  { IMAGE_SAMPLE_C_D_G16_V5_V6_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11Default, 0x5, 0x6, 0x1 }, // 8174
  { IMAGE_SAMPLE_C_D_G16_V5_V7_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11Default, 0x5, 0x7, 0x1 }, // 8175
  { IMAGE_SAMPLE_C_D_G16_V5_V8_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 8176
  { IMAGE_SAMPLE_C_D_G16_V1_V3_nsa_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 8177
  { IMAGE_SAMPLE_C_D_G16_V1_V4_nsa_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 8178
  { IMAGE_SAMPLE_C_D_G16_V1_V5_nsa_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11NSA, 0x1, 0x5, 0x5 }, // 8179
  { IMAGE_SAMPLE_C_D_G16_V1_V6_nsa_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11NSA, 0x1, 0x6, 0x6 }, // 8180
  { IMAGE_SAMPLE_C_D_G16_V1_V7_nsa_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11NSA, 0x1, 0x7, 0x7 }, // 8181
  { IMAGE_SAMPLE_C_D_G16_V1_V8_nsa_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11NSA, 0x1, 0x8, 0x8 }, // 8182
  { IMAGE_SAMPLE_C_D_G16_V2_V3_nsa_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 8183
  { IMAGE_SAMPLE_C_D_G16_V2_V4_nsa_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 8184
  { IMAGE_SAMPLE_C_D_G16_V2_V5_nsa_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 8185
  { IMAGE_SAMPLE_C_D_G16_V2_V6_nsa_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11NSA, 0x2, 0x6, 0x6 }, // 8186
  { IMAGE_SAMPLE_C_D_G16_V2_V7_nsa_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11NSA, 0x2, 0x7, 0x7 }, // 8187
  { IMAGE_SAMPLE_C_D_G16_V2_V8_nsa_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11NSA, 0x2, 0x8, 0x8 }, // 8188
  { IMAGE_SAMPLE_C_D_G16_V3_V3_nsa_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 8189
  { IMAGE_SAMPLE_C_D_G16_V3_V4_nsa_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 8190
  { IMAGE_SAMPLE_C_D_G16_V3_V5_nsa_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11NSA, 0x3, 0x5, 0x5 }, // 8191
  { IMAGE_SAMPLE_C_D_G16_V3_V6_nsa_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11NSA, 0x3, 0x6, 0x6 }, // 8192
  { IMAGE_SAMPLE_C_D_G16_V3_V7_nsa_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11NSA, 0x3, 0x7, 0x7 }, // 8193
  { IMAGE_SAMPLE_C_D_G16_V3_V8_nsa_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11NSA, 0x3, 0x8, 0x8 }, // 8194
  { IMAGE_SAMPLE_C_D_G16_V4_V3_nsa_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 8195
  { IMAGE_SAMPLE_C_D_G16_V4_V4_nsa_gfx11, IMAGE_SAMPLE_C_D_G16, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 8196
  