/**
 * @file    LangHungarianModel.cpp
 * @brief   LangHungarianModel
 * @license GPL 2.0/LGPL 2.1
 */

#include "nsSBCharSetProber.h"
/****************************************************************
255: Control characters that usually does not exist in any text
254: Carriage/Return
253: symbol (punctuation) that does not belong to word
252: 0 - 9

*****************************************************************/

//Character Mapping Table:
static const unsigned char Latin2_HungarianCharToOrderMap[] =
{
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255, 30, 47, 46, 43, 34, 50, 52, 38, 41, 49, 36, 44, 33, 35, 53,
 51,180, 45, 37, 42, 56, 39, 62, 64, 59, 54,255,255,255,255,255,
255,  2, 18, 27, 17,  1, 24, 12, 20,  9, 23,  7,  5, 13,  4,  8,
 26, 65, 10,  6,  3, 21, 19, 67, 63, 16, 11,255,255,255,255,255,
179,178,177,176,175,174,173,172,171,170,169,168,167,166,165,164,
163,162,161,160,159,158,157,156,155,154,153,152,151,150,149,148,
147,146,145,144,143,142,141,140,139,138,137,136,135,134,133,132,
131,130,129,128,127,126,125,124,123,122,121,120,119,118,117,116,
115, 55,114,113,112,111,110,109,108, 48,107,106,105, 66,104,103,
102,101,100, 60, 99, 61, 57, 98, 97, 96, 58, 68, 69, 95, 94, 93,
 92, 14, 91, 90, 89, 88, 87, 86, 85, 15, 84, 70, 83, 31, 82, 81,
 80, 79, 78, 25, 77, 28, 22, 76, 75, 74, 32, 40, 29, 73, 72, 71,
};

static const unsigned char win1250HungarianCharToOrderMap[] =
{
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
255, 30, 47, 46, 43, 34, 50, 52, 38, 41, 49, 36, 44, 33, 35, 53,
 51,180, 45, 37, 42, 56, 39, 63, 65, 60, 54,255,255,255,255,255,
255,  2, 18, 27, 17,  1, 24, 12, 20,  9, 23,  7,  5, 13,  4,  8,
 26, 67, 10,  6,  3, 21, 19, 70, 64, 16, 11,255,255,255,255,255,
179,178,177,176, 59,175,174,173,172,171,170,169,168,167,166,165,
164,163,162,161,160,159,158,157,156,155,154,153,152,151,150,149,
148,147,146,145,144,143,142,141,140,139,138, 69,137,136,135,134,
133,132,131,130,129,128,127,126,125,124,123, 66,122,121,120,119,
118, 55,117,116,115,114,113,112,111, 48,110,109,108, 68,107,106,
105,104,103, 61,102, 62, 57,101,100, 99, 58, 71, 72, 98, 97, 96,
 95, 14, 94, 93, 92, 91, 90, 89, 88, 15, 87, 73, 86, 31, 85, 84,
 83, 82, 81, 25, 80, 28, 22, 79, 78, 77, 32, 40, 29, 76, 75, 74,
};

//Model Table: 
//total sequences: 100%
//first 512 sequences: 94.7368%
//first 1024 sequences:5.2623%
//rest  sequences:     0.8894%
//negative sequences:  0.0009% 
static const PRUint8 HungarianLangModel[] = 
{
2,2,3,3,3,3,3,2,3,3,3,3,3,3,2,2,3,3,3,3,2,0,3,3,0,3,3,0,2,0,2,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,
3,2,3,3,3,3,3,0,3,3,3,3,3,2,2,3,3,3,3,3,3,0,3,3,2,3,3,0,2,0,0,2,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
3,3,3,3,3,3,3,3,3,3,2,2,2,3,3,3,0,3,3,3,3,3,3,2,3,2,3,3,3,0,2,2,
0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
3,3,3,3,2,3,3,3,3,2,2,3,2,3,3,3,3,3,2,3,3,3,3,2,2,2,3,3,3,0,2,0,
0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,2,0,3,2,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
3,3,3,3,2,3,3,3,3,3,3,2,3,3,3,2,2,3,2,3,3,3,0,2,3,2,2,3,3,0,3,3,
0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
3,3,3,3,3,3,3,3,3,3,2,0,2,3,3,2,2,3,2,3,3,3,2,2,3,2,0,2,3,0,2,2,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
2,2,3,3,3,3,3,0,2,3,3,3,3,0,2,2,3,3,3,3,2,0,2,2,0,3,3,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
3,3,3,3,3,3,3,2,2,3,3,3,3,3,3,0,3,3,3,3,3,2,2,3,3,3,3,0,2,0,0,2,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,
3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,3,3,3,3,3,3,2,3,2,3,3,3,0,2,2,
0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
3,3,3,3,3,3,3,3,3,2,3,3,2,3,3,2,3,3,3,2,3,3,2,2,3,2,0,3,3,0,3,2,
0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
3,3,3,3,3,3,3,3,3,3,2,3,2,3,3,3,2,3,3,3,3,3,3,2,3,2,2,2,2,0,2,2,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
3,3,2,2,3,3,2,3,3,2,2,0,3,3,3,0,2,3,2,2,3,3,2,2,2,3,2,0,2,0,3,2,
0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,3,3,3,3,3,0,3,3,3,3,3,0,2,0,3,3,3,3,2,0,3,2,0,2,3,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
2,0,3,3,3,3,3,0,2,3,3,3,3,0,2,0,3,3,3,3,0,0,3,2,0,3,2,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
3,3,3,3,2,3,3,3,3,3,2,2,3,3,3,0,0,3,3,3,3,3,2,2,3,2,2,2,3,0,2,3,
0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
3,3,3,3,2,3,2,3,3,3,2,2,2,3,3,2,3,2,3,2,3,3,3,2,3,0,0,3,2,0,3,2,
0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
3,3,2,2,3,2,2,3,3,3,0,0,0,3,3,0,2,3,2,2,3,3,2,0,3,0,0,3,2,0,2,2,
0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
3,3,2,2,0,2,0,3,3,2,0,0,0,3,3,0,0,2,2,0,2,3,2,0,2,0,0,2,2,0,2,0,
0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
3,3,0,2,2,2,0,3,3,0,0,0,0,3,3,0,0,0,0,2,3,3,0,0,3,0,0,2,2,0,3,3,
0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
2,2,3,3,3,3,3,0,2,3,3,3,3,2,0,0,3,2,2,2,0,0,3,2,0,2,2,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,3,3,3,3,3,0,0,3,3,3,3,0,0,0,2,3,3,2,0,0,2,2,0,2,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
3,3,3,2,2,3,2,3,2,2,2,0,2,3,3,0,3,2,2,2,3,3,3,2,3,0,2,0,2,0,0,2,
0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
3,3,2,2,2,0,0,3,3,2,0,0,2,3,3,2,0,0,0,0,3,3,3,2,2,0,0,3,3,0,0,2,
0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
2,2,3,3,3,3,3,0,2,3,3,2,2,0,2,0,3,3,3,2,0,0,2,2,0,2,2,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
3,3,3,2,2,2,2,3,3,3,2,0,0,3,3,0,2,2,2,2,3,2,3,2,2,3,2,2,2,0,2,2,
0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
3,3,2,0,2,3,3,3,3,2,2,0,0,3,2,2,0,2,2,3,2,0,0,0,0,0,2,0,0,0,2,2,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
2,2,3,3,3,3,3,0,2,3,2,2,2,2,0,0,3,3,2,2,0,0,2,2,0,2,2,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
2,0,3,3,3,3,3,0,0,3,2,3,0,0,0,0,2,2,2,2,0,0,2,0,0,2,2,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
2,0,2,2,2,0,3,0,0,2,3,0,3,0,0,0,2,2,0,2,2,0,0,2,0,2,0,0,0,0,0,0,
0,2,2,2,2,0,2,0,2,2,0,2,2,0,0,0,0,0,2,0,0,2,0,2,0,0,0,0,0,0,0,0,
0,0,3,3,2,2,2,0,0,3,3,3,2,0,0,0,2,2,3,0,0,0,2,0,0,2,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,2,3,2,3,3,2,0,0,3,3,3,0,0,0,0,2,0,2,0,0,0,3,2,0,0,2,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
3,3,0,0,0,0,0,3,3,0,0,0,0,3,2,0,0,0,0,0,2,2,0,0,0,0,0,0,2,0,2,0,
0,2,0,0,0,0,0,0,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,2,3,2,2,0,0,2,3,3,2,0,0,0,2,2,0,2,2,0,2,0,0,0,0,0,0,0,0,0,
2,0,2,2,2,0,0,0,0,2,2,0,2,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,
3,2,0,0,0,0,0,3,2,0,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,
0,2,0,2,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,2,0,0,2,0,0,0,0,2,0,0,0,0,
3,2,0,0,0,0,0,2,3,2,0,0,0,3,3,0,0,0,0,0,2,2,0,0,0,0,0,0,2,0,2,0,
0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,2,0,2,0,0,0,2,0,0,0,
2,2,2,0,0,0,0,2,2,0,3,0,0,2,0,2,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,
2,2,0,0,0,0,0,2,0,2,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,
2,3,0,0,0,0,0,3,2,0,0,0,0,3,2,0,0,0,0,0,2,0,2,0,0,0,0,0,0,2,0,0,
0,2,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
2,3,0,0,0,0,0,2,3,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
2,0,2,2,2,2,2,0,2,2,2,0,0,0,0,0,0,2,2,0,0,0,2,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,2,2,2,3,0,0,0,2,2,3,0,0,0,0,2,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,
0,0,2,0,2,2,2,0,2,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
3,2,0,0,0,0,0,2,2,2,0,0,0,2,2,0,0,0,0,2,2,0,0,0,0,0,0,0,0,2,0,0,
0,2,0,0,2,0,0,0,2,0,0,0,0,0,0,2,0,2,0,0,0,0,2,0,2,0,0,0,0,0,0,0,
3,2,0,0,0,0,0,2,0,2,0,0,0,2,2,0,0,0,0,0,2,0,0,0,0,0,0,0,0,2,0,0,
0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,2,0,2,0,0,0,0,0,0,0,0,0,
3,2,0,0,0,0,0,3,2,0,0,0,0,2,0,0,0,0,0,0,2,0,0,0,2,0,0,0,0,2,0,0,
0,0,0,0,0,0,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,0,0,0,
2,3,0,0,0,0,0,2,2,0,0,0,0,2,2,0,0,0,0,2,2,2,0,0,2,0,0,0,0,2,0,0,
0,2,0,2,2,0,0,0,2,2,2,0,0,0,0,2,0,0,2,0,0,0,0,0,0,0,0,0,2,0,0,0,
0,3,0,0,0,3,0,2,3,2,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,
3,2,0,0,2,0,0,2,2,2,0,0,0,2,2,0,0,0,0,0,2,0,0,0,0,0,0,2,0,2,0,0,
0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,
0,0,0,3,2,3,0,0,0,2,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,
0,0,2,0,2,0,0,0,0,0,0,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
2,2,0,0,0,0,0,2,0,0,0,0,0,2,0,0,0,0,0,0,3,0,0,0,3,0,0,0,0,2,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
3,2,0,0,0,0,0,2,0,2,0,0,0,0,2,0,0,0,0,0,2,2,0,0,0,0,0,0,2,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
2,2,0,0,0,0,0,2,2,0,0,0,0,2,2,0,0,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,
0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,
2,2,0,0,0,0,0,2,2,2,0,0,0,0,2,2,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,
0,0,2,0,3,0,2,0,0,2,0,0,0,0,0,0,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,
2,0,0,0,0,0,0,0,0,0,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
3,2,0,0,0,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,
0,2,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,
0,0,2,0,2,0,0,0,0,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,2,0,0,0,2,0,0,2,0,0,2,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,2,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,2,0,0,0,0,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,2,2,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,2,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,
0,0,2,0,0,0,2,0,2,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,
0,2,0,0,0,0,2,0,2,0,0,0,0,0,0,2,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,2,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,2,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
};

const SequenceModel Latin2HungarianModel = 
{
  Latin2_HungarianCharToOrderMap,
  HungarianLangModel,
  (float)0.965178,
  true,
  "ISO-8859-2",
  "hungarian"
};

const SequenceModel Win1250HungarianModel = 
{
  win1250HungarianCharToOrderMap,
  HungarianLangModel,
  (float)0.965178,
  true,
  "windows-1250",
  "hungarian"
};
