{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- An event related to a key-based device.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Objects.KeyEvent
    ( 

-- * Exported types
    KeyEvent(..)                            ,
    IsKeyEvent                              ,
    toKeyEvent                              ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [isModifier]("GI.Gdk.Objects.KeyEvent#g:method:isModifier"), [matches]("GI.Gdk.Objects.KeyEvent#g:method:matches"), [ref]("GI.Gdk.Objects.Event#g:method:ref"), [triggersContextMenu]("GI.Gdk.Objects.Event#g:method:triggersContextMenu"), [unref]("GI.Gdk.Objects.Event#g:method:unref").
-- 
-- ==== Getters
-- [getAxes]("GI.Gdk.Objects.Event#g:method:getAxes"), [getAxis]("GI.Gdk.Objects.Event#g:method:getAxis"), [getConsumedModifiers]("GI.Gdk.Objects.KeyEvent#g:method:getConsumedModifiers"), [getDevice]("GI.Gdk.Objects.Event#g:method:getDevice"), [getDeviceTool]("GI.Gdk.Objects.Event#g:method:getDeviceTool"), [getDisplay]("GI.Gdk.Objects.Event#g:method:getDisplay"), [getEventSequence]("GI.Gdk.Objects.Event#g:method:getEventSequence"), [getEventType]("GI.Gdk.Objects.Event#g:method:getEventType"), [getHistory]("GI.Gdk.Objects.Event#g:method:getHistory"), [getKeycode]("GI.Gdk.Objects.KeyEvent#g:method:getKeycode"), [getKeyval]("GI.Gdk.Objects.KeyEvent#g:method:getKeyval"), [getLayout]("GI.Gdk.Objects.KeyEvent#g:method:getLayout"), [getLevel]("GI.Gdk.Objects.KeyEvent#g:method:getLevel"), [getMatch]("GI.Gdk.Objects.KeyEvent#g:method:getMatch"), [getModifierState]("GI.Gdk.Objects.Event#g:method:getModifierState"), [getPointerEmulated]("GI.Gdk.Objects.Event#g:method:getPointerEmulated"), [getPosition]("GI.Gdk.Objects.Event#g:method:getPosition"), [getSeat]("GI.Gdk.Objects.Event#g:method:getSeat"), [getSurface]("GI.Gdk.Objects.Event#g:method:getSurface"), [getTime]("GI.Gdk.Objects.Event#g:method:getTime").
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveKeyEventMethod                   ,
#endif

-- ** getConsumedModifiers #method:getConsumedModifiers#

#if defined(ENABLE_OVERLOADING)
    KeyEventGetConsumedModifiersMethodInfo  ,
#endif
    keyEventGetConsumedModifiers            ,


-- ** getKeycode #method:getKeycode#

#if defined(ENABLE_OVERLOADING)
    KeyEventGetKeycodeMethodInfo            ,
#endif
    keyEventGetKeycode                      ,


-- ** getKeyval #method:getKeyval#

#if defined(ENABLE_OVERLOADING)
    KeyEventGetKeyvalMethodInfo             ,
#endif
    keyEventGetKeyval                       ,


-- ** getLayout #method:getLayout#

#if defined(ENABLE_OVERLOADING)
    KeyEventGetLayoutMethodInfo             ,
#endif
    keyEventGetLayout                       ,


-- ** getLevel #method:getLevel#

#if defined(ENABLE_OVERLOADING)
    KeyEventGetLevelMethodInfo              ,
#endif
    keyEventGetLevel                        ,


-- ** getMatch #method:getMatch#

#if defined(ENABLE_OVERLOADING)
    KeyEventGetMatchMethodInfo              ,
#endif
    keyEventGetMatch                        ,


-- ** isModifier #method:isModifier#

#if defined(ENABLE_OVERLOADING)
    KeyEventIsModifierMethodInfo            ,
#endif
    keyEventIsModifier                      ,


-- ** matches #method:matches#

#if defined(ENABLE_OVERLOADING)
    KeyEventMatchesMethodInfo               ,
#endif
    keyEventMatches                         ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Enums as Cairo.Enums
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.Cairo.Structs.Surface as Cairo.Surface
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.String as GLib.String
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Callbacks as Gdk.Callbacks
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import {-# SOURCE #-} qualified GI.Gdk.Objects.AppLaunchContext as Gdk.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.CairoContext as Gdk.CairoContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.CicpParams as Gdk.CicpParams
import {-# SOURCE #-} qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import {-# SOURCE #-} qualified GI.Gdk.Objects.ContentProvider as Gdk.ContentProvider
import {-# SOURCE #-} qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceTool as Gdk.DeviceTool
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gdk.Objects.DrawContext as Gdk.DrawContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Event as Gdk.Event
import {-# SOURCE #-} qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import {-# SOURCE #-} qualified GI.Gdk.Objects.GLContext as Gdk.GLContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Seat as Gdk.Seat
import {-# SOURCE #-} qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import {-# SOURCE #-} qualified GI.Gdk.Objects.Surface as Gdk.Surface
import {-# SOURCE #-} qualified GI.Gdk.Objects.Texture as Gdk.Texture
import {-# SOURCE #-} qualified GI.Gdk.Objects.VulkanContext as Gdk.VulkanContext
import {-# SOURCE #-} qualified GI.Gdk.Structs.ColorState as Gdk.ColorState
import {-# SOURCE #-} qualified GI.Gdk.Structs.ContentFormats as Gdk.ContentFormats
import {-# SOURCE #-} qualified GI.Gdk.Structs.DmabufFormats as Gdk.DmabufFormats
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSequence as Gdk.EventSequence
import {-# SOURCE #-} qualified GI.Gdk.Structs.FrameTimings as Gdk.FrameTimings
import {-# SOURCE #-} qualified GI.Gdk.Structs.KeymapKey as Gdk.KeymapKey
import {-# SOURCE #-} qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import {-# SOURCE #-} qualified GI.Gdk.Structs.TimeCoord as Gdk.TimeCoord
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Callbacks as Gio.Callbacks
import qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import qualified GI.Gio.Interfaces.File as Gio.File
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Gio.Interfaces.LoadableIcon as Gio.LoadableIcon
import qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext
import qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import qualified GI.Gio.Objects.InputStream as Gio.InputStream
import qualified GI.Gio.Objects.OutputStream as Gio.OutputStream
import qualified GI.Pango.Enums as Pango.Enums

#else
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Objects.Event as Gdk.Event

#endif

-- | Memory-managed wrapper type.
newtype KeyEvent = KeyEvent (SP.ManagedPtr KeyEvent)
    deriving (Eq)

instance SP.ManagedPtrNewtype KeyEvent where
    toManagedPtr (KeyEvent p) = p

foreign import ccall "gdk_key_event_get_type"
    c_gdk_key_event_get_type :: IO B.Types.GType

instance B.Types.TypedObject KeyEvent where
    glibType = c_gdk_key_event_get_type

-- | Type class for types which can be safely cast to t'KeyEvent', for instance with `toKeyEvent`.
class (SP.BoxedPtr o, SP.TypedObject o, O.IsDescendantOf KeyEvent o) => IsKeyEvent o
instance (SP.BoxedPtr o, SP.TypedObject o, O.IsDescendantOf KeyEvent o) => IsKeyEvent o

instance O.HasParentTypes KeyEvent
type instance O.ParentTypes KeyEvent = '[Gdk.Event.Event]

-- | Cast to t'KeyEvent', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toKeyEvent :: (MIO.MonadIO m, IsKeyEvent o) => o -> m KeyEvent
toKeyEvent = MIO.liftIO . B.ManagedPtr.unsafeCastTo KeyEvent

--- XXX Missing getter and/or setter, so no GValue instance could be generated.
#if defined(ENABLE_OVERLOADING)
type family ResolveKeyEventMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveKeyEventMethod "isModifier" o = KeyEventIsModifierMethodInfo
    ResolveKeyEventMethod "matches" o = KeyEventMatchesMethodInfo
    ResolveKeyEventMethod "ref" o = Gdk.Event.EventRefMethodInfo
    ResolveKeyEventMethod "triggersContextMenu" o = Gdk.Event.EventTriggersContextMenuMethodInfo
    ResolveKeyEventMethod "unref" o = Gdk.Event.EventUnrefMethodInfo
    ResolveKeyEventMethod "getAxes" o = Gdk.Event.EventGetAxesMethodInfo
    ResolveKeyEventMethod "getAxis" o = Gdk.Event.EventGetAxisMethodInfo
    ResolveKeyEventMethod "getConsumedModifiers" o = KeyEventGetConsumedModifiersMethodInfo
    ResolveKeyEventMethod "getDevice" o = Gdk.Event.EventGetDeviceMethodInfo
    ResolveKeyEventMethod "getDeviceTool" o = Gdk.Event.EventGetDeviceToolMethodInfo
    ResolveKeyEventMethod "getDisplay" o = Gdk.Event.EventGetDisplayMethodInfo
    ResolveKeyEventMethod "getEventSequence" o = Gdk.Event.EventGetEventSequenceMethodInfo
    ResolveKeyEventMethod "getEventType" o = Gdk.Event.EventGetEventTypeMethodInfo
    ResolveKeyEventMethod "getHistory" o = Gdk.Event.EventGetHistoryMethodInfo
    ResolveKeyEventMethod "getKeycode" o = KeyEventGetKeycodeMethodInfo
    ResolveKeyEventMethod "getKeyval" o = KeyEventGetKeyvalMethodInfo
    ResolveKeyEventMethod "getLayout" o = KeyEventGetLayoutMethodInfo
    ResolveKeyEventMethod "getLevel" o = KeyEventGetLevelMethodInfo
    ResolveKeyEventMethod "getMatch" o = KeyEventGetMatchMethodInfo
    ResolveKeyEventMethod "getModifierState" o = Gdk.Event.EventGetModifierStateMethodInfo
    ResolveKeyEventMethod "getPointerEmulated" o = Gdk.Event.EventGetPointerEmulatedMethodInfo
    ResolveKeyEventMethod "getPosition" o = Gdk.Event.EventGetPositionMethodInfo
    ResolveKeyEventMethod "getSeat" o = Gdk.Event.EventGetSeatMethodInfo
    ResolveKeyEventMethod "getSurface" o = Gdk.Event.EventGetSurfaceMethodInfo
    ResolveKeyEventMethod "getTime" o = Gdk.Event.EventGetTimeMethodInfo
    ResolveKeyEventMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveKeyEventMethod t KeyEvent, O.OverloadedMethod info KeyEvent p) => OL.IsLabel t (KeyEvent -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveKeyEventMethod t KeyEvent, O.OverloadedMethod info KeyEvent p, R.HasField t KeyEvent p) => R.HasField t KeyEvent p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveKeyEventMethod t KeyEvent, O.OverloadedMethodInfo info KeyEvent) => OL.IsLabel t (O.MethodProxy info KeyEvent) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- XXX Wrapping a foreign struct/union with no known destructor or size, leak?
instance BoxedPtr KeyEvent where
    boxedPtrCopy = return
    boxedPtrFree = \_x -> return ()


-- method KeyEvent::get_consumed_modifiers
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "event"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "KeyEvent" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a key event" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gdk" , name = "ModifierType" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_key_event_get_consumed_modifiers" gdk_key_event_get_consumed_modifiers :: 
    Ptr KeyEvent ->                         -- event : TInterface (Name {namespace = "Gdk", name = "KeyEvent"})
    IO CUInt

-- | Extracts the consumed modifiers from a key event.
keyEventGetConsumedModifiers ::
    (B.CallStack.HasCallStack, MonadIO m, IsKeyEvent a) =>
    a
    -- ^ /@event@/: a key event
    -> m [Gdk.Flags.ModifierType]
    -- ^ __Returns:__ the consumed modifiers or /@event@/
keyEventGetConsumedModifiers event = liftIO $ do
    event' <- unsafeManagedPtrCastPtr event
    result <- gdk_key_event_get_consumed_modifiers event'
    let result' = wordToGFlags result
    touchManagedPtr event
    return result'

#if defined(ENABLE_OVERLOADING)
data KeyEventGetConsumedModifiersMethodInfo
instance (signature ~ (m [Gdk.Flags.ModifierType]), MonadIO m, IsKeyEvent a) => O.OverloadedMethod KeyEventGetConsumedModifiersMethodInfo a signature where
    overloadedMethod = keyEventGetConsumedModifiers

instance O.OverloadedMethodInfo KeyEventGetConsumedModifiersMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.KeyEvent.keyEventGetConsumedModifiers",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-KeyEvent.html#v:keyEventGetConsumedModifiers"
        })


#endif

-- method KeyEvent::get_keycode
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "event"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "KeyEvent" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a key event" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_key_event_get_keycode" gdk_key_event_get_keycode :: 
    Ptr KeyEvent ->                         -- event : TInterface (Name {namespace = "Gdk", name = "KeyEvent"})
    IO Word32

-- | Extracts the keycode from a key event.
keyEventGetKeycode ::
    (B.CallStack.HasCallStack, MonadIO m, IsKeyEvent a) =>
    a
    -- ^ /@event@/: a key event
    -> m Word32
    -- ^ __Returns:__ the keycode of /@event@/
keyEventGetKeycode event = liftIO $ do
    event' <- unsafeManagedPtrCastPtr event
    result <- gdk_key_event_get_keycode event'
    touchManagedPtr event
    return result

#if defined(ENABLE_OVERLOADING)
data KeyEventGetKeycodeMethodInfo
instance (signature ~ (m Word32), MonadIO m, IsKeyEvent a) => O.OverloadedMethod KeyEventGetKeycodeMethodInfo a signature where
    overloadedMethod = keyEventGetKeycode

instance O.OverloadedMethodInfo KeyEventGetKeycodeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.KeyEvent.keyEventGetKeycode",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-KeyEvent.html#v:keyEventGetKeycode"
        })


#endif

-- method KeyEvent::get_keyval
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "event"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "KeyEvent" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a key event" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_key_event_get_keyval" gdk_key_event_get_keyval :: 
    Ptr KeyEvent ->                         -- event : TInterface (Name {namespace = "Gdk", name = "KeyEvent"})
    IO Word32

-- | Extracts the keyval from a key event.
keyEventGetKeyval ::
    (B.CallStack.HasCallStack, MonadIO m, IsKeyEvent a) =>
    a
    -- ^ /@event@/: a key event
    -> m Word32
    -- ^ __Returns:__ the keyval of /@event@/
keyEventGetKeyval event = liftIO $ do
    event' <- unsafeManagedPtrCastPtr event
    result <- gdk_key_event_get_keyval event'
    touchManagedPtr event
    return result

#if defined(ENABLE_OVERLOADING)
data KeyEventGetKeyvalMethodInfo
instance (signature ~ (m Word32), MonadIO m, IsKeyEvent a) => O.OverloadedMethod KeyEventGetKeyvalMethodInfo a signature where
    overloadedMethod = keyEventGetKeyval

instance O.OverloadedMethodInfo KeyEventGetKeyvalMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.KeyEvent.keyEventGetKeyval",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-KeyEvent.html#v:keyEventGetKeyval"
        })


#endif

-- method KeyEvent::get_layout
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "event"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "KeyEvent" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a key event" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_key_event_get_layout" gdk_key_event_get_layout :: 
    Ptr KeyEvent ->                         -- event : TInterface (Name {namespace = "Gdk", name = "KeyEvent"})
    IO Word32

-- | Extracts the layout from a key event.
keyEventGetLayout ::
    (B.CallStack.HasCallStack, MonadIO m, IsKeyEvent a) =>
    a
    -- ^ /@event@/: a key event
    -> m Word32
    -- ^ __Returns:__ the layout of /@event@/
keyEventGetLayout event = liftIO $ do
    event' <- unsafeManagedPtrCastPtr event
    result <- gdk_key_event_get_layout event'
    touchManagedPtr event
    return result

#if defined(ENABLE_OVERLOADING)
data KeyEventGetLayoutMethodInfo
instance (signature ~ (m Word32), MonadIO m, IsKeyEvent a) => O.OverloadedMethod KeyEventGetLayoutMethodInfo a signature where
    overloadedMethod = keyEventGetLayout

instance O.OverloadedMethodInfo KeyEventGetLayoutMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.KeyEvent.keyEventGetLayout",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-KeyEvent.html#v:keyEventGetLayout"
        })


#endif

-- method KeyEvent::get_level
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "event"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "KeyEvent" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a key event" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_key_event_get_level" gdk_key_event_get_level :: 
    Ptr KeyEvent ->                         -- event : TInterface (Name {namespace = "Gdk", name = "KeyEvent"})
    IO Word32

-- | Extracts the shift level from a key event.
keyEventGetLevel ::
    (B.CallStack.HasCallStack, MonadIO m, IsKeyEvent a) =>
    a
    -- ^ /@event@/: a key event
    -> m Word32
    -- ^ __Returns:__ the shift level of /@event@/
keyEventGetLevel event = liftIO $ do
    event' <- unsafeManagedPtrCastPtr event
    result <- gdk_key_event_get_level event'
    touchManagedPtr event
    return result

#if defined(ENABLE_OVERLOADING)
data KeyEventGetLevelMethodInfo
instance (signature ~ (m Word32), MonadIO m, IsKeyEvent a) => O.OverloadedMethod KeyEventGetLevelMethodInfo a signature where
    overloadedMethod = keyEventGetLevel

instance O.OverloadedMethodInfo KeyEventGetLevelMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.KeyEvent.keyEventGetLevel",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-KeyEvent.html#v:keyEventGetLevel"
        })


#endif

-- method KeyEvent::get_match
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "event"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "KeyEvent" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a key `GdkEvent`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "keyval"
--           , argType = TBasicType TUInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for a keyval"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "modifiers"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ModifierType" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for modifiers"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_key_event_get_match" gdk_key_event_get_match :: 
    Ptr KeyEvent ->                         -- event : TInterface (Name {namespace = "Gdk", name = "KeyEvent"})
    Ptr Word32 ->                           -- keyval : TBasicType TUInt
    Ptr CUInt ->                            -- modifiers : TInterface (Name {namespace = "Gdk", name = "ModifierType"})
    IO CInt

-- | Gets a keyval and modifier combination that will match
-- the event.
-- 
-- See 'GI.Gdk.Objects.KeyEvent.keyEventMatches'.
keyEventGetMatch ::
    (B.CallStack.HasCallStack, MonadIO m, IsKeyEvent a) =>
    a
    -- ^ /@event@/: a key @GdkEvent@
    -> m ((Bool, Word32, [Gdk.Flags.ModifierType]))
    -- ^ __Returns:__ 'P.True' on success
keyEventGetMatch event = liftIO $ do
    event' <- unsafeManagedPtrCastPtr event
    keyval <- allocMem :: IO (Ptr Word32)
    modifiers <- allocMem :: IO (Ptr CUInt)
    result <- gdk_key_event_get_match event' keyval modifiers
    let result' = (/= 0) result
    keyval' <- peek keyval
    modifiers' <- peek modifiers
    let modifiers'' = wordToGFlags modifiers'
    touchManagedPtr event
    freeMem keyval
    freeMem modifiers
    return (result', keyval', modifiers'')

#if defined(ENABLE_OVERLOADING)
data KeyEventGetMatchMethodInfo
instance (signature ~ (m ((Bool, Word32, [Gdk.Flags.ModifierType]))), MonadIO m, IsKeyEvent a) => O.OverloadedMethod KeyEventGetMatchMethodInfo a signature where
    overloadedMethod = keyEventGetMatch

instance O.OverloadedMethodInfo KeyEventGetMatchMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.KeyEvent.keyEventGetMatch",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-KeyEvent.html#v:keyEventGetMatch"
        })


#endif

-- method KeyEvent::is_modifier
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "event"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "KeyEvent" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a key event" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_key_event_is_modifier" gdk_key_event_is_modifier :: 
    Ptr KeyEvent ->                         -- event : TInterface (Name {namespace = "Gdk", name = "KeyEvent"})
    IO CInt

-- | Extracts whether the key event is for a modifier key.
keyEventIsModifier ::
    (B.CallStack.HasCallStack, MonadIO m, IsKeyEvent a) =>
    a
    -- ^ /@event@/: a key event
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the /@event@/ is for a modifier key
keyEventIsModifier event = liftIO $ do
    event' <- unsafeManagedPtrCastPtr event
    result <- gdk_key_event_is_modifier event'
    let result' = (/= 0) result
    touchManagedPtr event
    return result'

#if defined(ENABLE_OVERLOADING)
data KeyEventIsModifierMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsKeyEvent a) => O.OverloadedMethod KeyEventIsModifierMethodInfo a signature where
    overloadedMethod = keyEventIsModifier

instance O.OverloadedMethodInfo KeyEventIsModifierMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.KeyEvent.keyEventIsModifier",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-KeyEvent.html#v:keyEventIsModifier"
        })


#endif

-- method KeyEvent::matches
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "event"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "KeyEvent" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a key `GdkEvent`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "keyval"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the keyval to match"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "modifiers"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ModifierType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the modifiers to match"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "KeyMatch" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_key_event_matches" gdk_key_event_matches :: 
    Ptr KeyEvent ->                         -- event : TInterface (Name {namespace = "Gdk", name = "KeyEvent"})
    Word32 ->                               -- keyval : TBasicType TUInt
    CUInt ->                                -- modifiers : TInterface (Name {namespace = "Gdk", name = "ModifierType"})
    IO CUInt

-- | Matches a key event against a keyval and modifiers.
-- 
-- This is typically used to trigger keyboard shortcuts such as Ctrl-C.
-- 
-- Partial matches are possible where the combination matches
-- if the currently active group is ignored.
-- 
-- Note that we ignore Caps Lock for matching.
keyEventMatches ::
    (B.CallStack.HasCallStack, MonadIO m, IsKeyEvent a) =>
    a
    -- ^ /@event@/: a key @GdkEvent@
    -> Word32
    -- ^ /@keyval@/: the keyval to match
    -> [Gdk.Flags.ModifierType]
    -- ^ /@modifiers@/: the modifiers to match
    -> m Gdk.Enums.KeyMatch
    -- ^ __Returns:__ a @GdkKeyMatch@ value describing whether /@event@/ matches
keyEventMatches event keyval modifiers = liftIO $ do
    event' <- unsafeManagedPtrCastPtr event
    let modifiers' = gflagsToWord modifiers
    result <- gdk_key_event_matches event' keyval modifiers'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr event
    return result'

#if defined(ENABLE_OVERLOADING)
data KeyEventMatchesMethodInfo
instance (signature ~ (Word32 -> [Gdk.Flags.ModifierType] -> m Gdk.Enums.KeyMatch), MonadIO m, IsKeyEvent a) => O.OverloadedMethod KeyEventMatchesMethodInfo a signature where
    overloadedMethod = keyEventMatches

instance O.OverloadedMethodInfo KeyEventMatchesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.KeyEvent.keyEventMatches",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-KeyEvent.html#v:keyEventMatches"
        })


#endif


