

-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Flags
    ( 

 -- * Flags


-- ** AnchorHints #flag:AnchorHints#

    AnchorHints(..)                         ,


-- ** AxisFlags #flag:AxisFlags#

    AxisFlags(..)                           ,


-- ** DragAction #flag:DragAction#

    DragAction(..)                          ,


-- ** FrameClockPhase #flag:FrameClockPhase#

    FrameClockPhase(..)                     ,


-- ** GLAPI #flag:GLAPI#

    GLAPI(..)                               ,


-- ** ModifierType #flag:ModifierType#

    ModifierType(..)                        ,


-- ** PaintableFlags #flag:PaintableFlags#

    PaintableFlags(..)                      ,


-- ** SeatCapabilities #flag:SeatCapabilities#

    SeatCapabilities(..)                    ,


-- ** ToplevelCapabilities #flag:ToplevelCapabilities#

    ToplevelCapabilities(..)                ,


-- ** ToplevelState #flag:ToplevelState#

    ToplevelState(..)                       ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- Flags ToplevelState
-- | Specifies the state of a toplevel surface.
-- 
-- On platforms that support information about individual edges, the
-- 'GI.Gdk.Flags.ToplevelStateTiled' state will be set whenever any of the individual
-- tiled states is set. On platforms that lack that support, the tiled state
-- will give an indication of tiledness without any of the per-edge states
-- being set.
data ToplevelState = 
      ToplevelStateMinimized
    -- ^ the surface is minimized
    | ToplevelStateMaximized
    -- ^ the surface is maximized
    | ToplevelStateSticky
    -- ^ the surface is sticky
    | ToplevelStateFullscreen
    -- ^ the surface is maximized without decorations
    | ToplevelStateAbove
    -- ^ the surface is kept above other surfaces
    | ToplevelStateBelow
    -- ^ the surface is kept below other surfaces
    | ToplevelStateFocused
    -- ^ the surface is presented as focused (with active decorations)
    | ToplevelStateTiled
    -- ^ the surface is in a tiled state
    | ToplevelStateTopTiled
    -- ^ whether the top edge is tiled
    | ToplevelStateTopResizable
    -- ^ whether the top edge is resizable
    | ToplevelStateRightTiled
    -- ^ whether the right edge is tiled
    | ToplevelStateRightResizable
    -- ^ whether the right edge is resizable
    | ToplevelStateBottomTiled
    -- ^ whether the bottom edge is tiled
    | ToplevelStateBottomResizable
    -- ^ whether the bottom edge is resizable
    | ToplevelStateLeftTiled
    -- ^ whether the left edge is tiled
    | ToplevelStateLeftResizable
    -- ^ whether the left edge is resizable
    | ToplevelStateSuspended
    -- ^ The surface is not visible to the user.
    -- 
    -- /Since: 4.12/
    | AnotherToplevelState Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum ToplevelState where
    fromEnum ToplevelStateMinimized = 1
    fromEnum ToplevelStateMaximized = 2
    fromEnum ToplevelStateSticky = 4
    fromEnum ToplevelStateFullscreen = 8
    fromEnum ToplevelStateAbove = 16
    fromEnum ToplevelStateBelow = 32
    fromEnum ToplevelStateFocused = 64
    fromEnum ToplevelStateTiled = 128
    fromEnum ToplevelStateTopTiled = 256
    fromEnum ToplevelStateTopResizable = 512
    fromEnum ToplevelStateRightTiled = 1024
    fromEnum ToplevelStateRightResizable = 2048
    fromEnum ToplevelStateBottomTiled = 4096
    fromEnum ToplevelStateBottomResizable = 8192
    fromEnum ToplevelStateLeftTiled = 16384
    fromEnum ToplevelStateLeftResizable = 32768
    fromEnum ToplevelStateSuspended = 65536
    fromEnum (AnotherToplevelState k) = k

    toEnum 1 = ToplevelStateMinimized
    toEnum 2 = ToplevelStateMaximized
    toEnum 4 = ToplevelStateSticky
    toEnum 8 = ToplevelStateFullscreen
    toEnum 16 = ToplevelStateAbove
    toEnum 32 = ToplevelStateBelow
    toEnum 64 = ToplevelStateFocused
    toEnum 128 = ToplevelStateTiled
    toEnum 256 = ToplevelStateTopTiled
    toEnum 512 = ToplevelStateTopResizable
    toEnum 1024 = ToplevelStateRightTiled
    toEnum 2048 = ToplevelStateRightResizable
    toEnum 4096 = ToplevelStateBottomTiled
    toEnum 8192 = ToplevelStateBottomResizable
    toEnum 16384 = ToplevelStateLeftTiled
    toEnum 32768 = ToplevelStateLeftResizable
    toEnum 65536 = ToplevelStateSuspended
    toEnum k = AnotherToplevelState k

instance P.Ord ToplevelState where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes ToplevelState = '[]
instance O.HasParentTypes ToplevelState

foreign import ccall "gdk_toplevel_state_get_type" c_gdk_toplevel_state_get_type :: 
    IO GType

instance B.Types.TypedObject ToplevelState where
    glibType = c_gdk_toplevel_state_get_type

instance B.Types.BoxedFlags ToplevelState

instance IsGFlag ToplevelState

-- Flags ToplevelCapabilities
-- | Reflects what features a @GdkToplevel@ supports.
-- 
-- /Since: 4.20/
data ToplevelCapabilities = 
      ToplevelCapabilitiesEdgeConstraints
    -- ^ Whether tiled window states are supported.
    -- 
    -- /Since: 4.20/
    | ToplevelCapabilitiesInhibitShortcuts
    -- ^ Whether inhibiting system shortcuts is supported.
    -- See 'GI.Gdk.Interfaces.Toplevel.toplevelInhibitSystemShortcuts'.
    -- 
    -- /Since: 4.20/
    | ToplevelCapabilitiesTitlebarGestures
    -- ^ Whether titlebar gestures are supported.
    -- See 'GI.Gdk.Interfaces.Toplevel.toplevelTitlebarGesture'.
    -- 
    -- /Since: 4.20/
    | ToplevelCapabilitiesWindowMenu
    -- ^ Whether showing the window menu is supported.
    -- See 'GI.Gdk.Interfaces.Toplevel.toplevelShowWindowMenu'.
    -- 
    -- /Since: 4.20/
    | ToplevelCapabilitiesMaximize
    -- ^ Whether the toplevel can be maximized.
    -- 
    -- /Since: 4.20/
    | ToplevelCapabilitiesFullscreen
    -- ^ Whether the toplevel can be made fullscreen.
    -- 
    -- /Since: 4.20/
    | ToplevelCapabilitiesMinimize
    -- ^ Whether the toplevel can be minimized.
    -- See 'GI.Gdk.Interfaces.Toplevel.toplevelMinimize'.
    -- 
    -- /Since: 4.20/
    | ToplevelCapabilitiesLower
    -- ^ Whether the toplevel can be lowered.
    -- See 'GI.Gdk.Interfaces.Toplevel.toplevelLower'.
    -- 
    -- /Since: 4.20/
    | AnotherToplevelCapabilities Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum ToplevelCapabilities where
    fromEnum ToplevelCapabilitiesEdgeConstraints = 1
    fromEnum ToplevelCapabilitiesInhibitShortcuts = 2
    fromEnum ToplevelCapabilitiesTitlebarGestures = 4
    fromEnum ToplevelCapabilitiesWindowMenu = 8
    fromEnum ToplevelCapabilitiesMaximize = 16
    fromEnum ToplevelCapabilitiesFullscreen = 32
    fromEnum ToplevelCapabilitiesMinimize = 64
    fromEnum ToplevelCapabilitiesLower = 128
    fromEnum (AnotherToplevelCapabilities k) = k

    toEnum 1 = ToplevelCapabilitiesEdgeConstraints
    toEnum 2 = ToplevelCapabilitiesInhibitShortcuts
    toEnum 4 = ToplevelCapabilitiesTitlebarGestures
    toEnum 8 = ToplevelCapabilitiesWindowMenu
    toEnum 16 = ToplevelCapabilitiesMaximize
    toEnum 32 = ToplevelCapabilitiesFullscreen
    toEnum 64 = ToplevelCapabilitiesMinimize
    toEnum 128 = ToplevelCapabilitiesLower
    toEnum k = AnotherToplevelCapabilities k

instance P.Ord ToplevelCapabilities where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes ToplevelCapabilities = '[]
instance O.HasParentTypes ToplevelCapabilities

foreign import ccall "gdk_toplevel_capabilities_get_type" c_gdk_toplevel_capabilities_get_type :: 
    IO GType

instance B.Types.TypedObject ToplevelCapabilities where
    glibType = c_gdk_toplevel_capabilities_get_type

instance B.Types.BoxedFlags ToplevelCapabilities

instance IsGFlag ToplevelCapabilities

-- Flags SeatCapabilities
-- | Flags describing the seat capabilities.
data SeatCapabilities = 
      SeatCapabilitiesNone
    -- ^ No input capabilities
    | SeatCapabilitiesPointer
    -- ^ The seat has a pointer (e.g. mouse)
    | SeatCapabilitiesTouch
    -- ^ The seat has touchscreen(s) attached
    | SeatCapabilitiesTabletStylus
    -- ^ The seat has drawing tablet(s) attached
    | SeatCapabilitiesKeyboard
    -- ^ The seat has keyboard(s) attached
    | SeatCapabilitiesTabletPad
    -- ^ The seat has drawing tablet pad(s) attached
    | SeatCapabilitiesAllPointing
    -- ^ The union of all pointing capabilities
    | SeatCapabilitiesAll
    -- ^ The union of all capabilities
    | AnotherSeatCapabilities Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum SeatCapabilities where
    fromEnum SeatCapabilitiesNone = 0
    fromEnum SeatCapabilitiesPointer = 1
    fromEnum SeatCapabilitiesTouch = 2
    fromEnum SeatCapabilitiesTabletStylus = 4
    fromEnum SeatCapabilitiesKeyboard = 8
    fromEnum SeatCapabilitiesTabletPad = 16
    fromEnum SeatCapabilitiesAllPointing = 7
    fromEnum SeatCapabilitiesAll = 31
    fromEnum (AnotherSeatCapabilities k) = k

    toEnum 0 = SeatCapabilitiesNone
    toEnum 1 = SeatCapabilitiesPointer
    toEnum 2 = SeatCapabilitiesTouch
    toEnum 4 = SeatCapabilitiesTabletStylus
    toEnum 8 = SeatCapabilitiesKeyboard
    toEnum 16 = SeatCapabilitiesTabletPad
    toEnum 7 = SeatCapabilitiesAllPointing
    toEnum 31 = SeatCapabilitiesAll
    toEnum k = AnotherSeatCapabilities k

instance P.Ord SeatCapabilities where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes SeatCapabilities = '[]
instance O.HasParentTypes SeatCapabilities

foreign import ccall "gdk_seat_capabilities_get_type" c_gdk_seat_capabilities_get_type :: 
    IO GType

instance B.Types.TypedObject SeatCapabilities where
    glibType = c_gdk_seat_capabilities_get_type

instance B.Types.BoxedFlags SeatCapabilities

instance IsGFlag SeatCapabilities

-- Flags PaintableFlags
-- | Flags about a paintable object.
-- 
-- Implementations use these for optimizations such as caching.
data PaintableFlags = 
      PaintableFlagsSize
    -- ^ The size is immutable.
    --   The [Paintable::invalidateSize]("GI.Gdk.Interfaces.Paintable#g:signal:invalidateSize") signal will never be
    --   emitted.
    | PaintableFlagsContents
    -- ^ The content is immutable.
    --   The [Paintable::invalidateContents]("GI.Gdk.Interfaces.Paintable#g:signal:invalidateContents") signal will never be
    --   emitted.
    | AnotherPaintableFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum PaintableFlags where
    fromEnum PaintableFlagsSize = 1
    fromEnum PaintableFlagsContents = 2
    fromEnum (AnotherPaintableFlags k) = k

    toEnum 1 = PaintableFlagsSize
    toEnum 2 = PaintableFlagsContents
    toEnum k = AnotherPaintableFlags k

instance P.Ord PaintableFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes PaintableFlags = '[]
instance O.HasParentTypes PaintableFlags

foreign import ccall "gdk_paintable_flags_get_type" c_gdk_paintable_flags_get_type :: 
    IO GType

instance B.Types.TypedObject PaintableFlags where
    glibType = c_gdk_paintable_flags_get_type

instance B.Types.BoxedFlags PaintableFlags

instance IsGFlag PaintableFlags

-- Flags ModifierType
-- | Flags to indicate the state of modifier keys and mouse buttons
-- in events.
-- 
-- Typical modifier keys are Shift, Control, Meta, Super, Hyper, Alt, Compose,
-- Apple, CapsLock or ShiftLock.
-- 
-- Note that GDK may add internal values to events which include values outside
-- of this enumeration. Your code should preserve and ignore them. You can use
-- 'GI.Gdk.Constants.MODIFIER_MASK' to remove all private values.
data ModifierType = 
      ModifierTypeNoModifierMask
    -- ^ No modifier.
    -- 
    -- /Since: 4.14/
    | ModifierTypeShiftMask
    -- ^ the Shift key.
    | ModifierTypeLockMask
    -- ^ a Lock key (depending on the Windowing System configuration,
    --    this may either be \<kbd>CapsLock\<\/kbd> or \<kbd>ShiftLock\<\/kbd>).
    | ModifierTypeControlMask
    -- ^ the Control key.
    | ModifierTypeAltMask
    -- ^ the fourth modifier key (it depends on the Windowing System
    --    configuration which key is interpreted as this modifier, but normally it
    --    is the \<kbd>Alt\<\/kbd> key).
    | ModifierTypeButton1Mask
    -- ^ the first mouse button.
    | ModifierTypeButton2Mask
    -- ^ the second mouse button.
    | ModifierTypeButton3Mask
    -- ^ the third mouse button.
    | ModifierTypeButton4Mask
    -- ^ the fourth mouse button.
    | ModifierTypeButton5Mask
    -- ^ the fifth mouse button.
    | ModifierTypeSuperMask
    -- ^ the Super modifier.
    | ModifierTypeHyperMask
    -- ^ the Hyper modifier.
    | ModifierTypeMetaMask
    -- ^ the Meta modifier. Maps to Command on macOS.
    | AnotherModifierType Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum ModifierType where
    fromEnum ModifierTypeNoModifierMask = 0
    fromEnum ModifierTypeShiftMask = 1
    fromEnum ModifierTypeLockMask = 2
    fromEnum ModifierTypeControlMask = 4
    fromEnum ModifierTypeAltMask = 8
    fromEnum ModifierTypeButton1Mask = 256
    fromEnum ModifierTypeButton2Mask = 512
    fromEnum ModifierTypeButton3Mask = 1024
    fromEnum ModifierTypeButton4Mask = 2048
    fromEnum ModifierTypeButton5Mask = 4096
    fromEnum ModifierTypeSuperMask = 67108864
    fromEnum ModifierTypeHyperMask = 134217728
    fromEnum ModifierTypeMetaMask = 268435456
    fromEnum (AnotherModifierType k) = k

    toEnum 0 = ModifierTypeNoModifierMask
    toEnum 1 = ModifierTypeShiftMask
    toEnum 2 = ModifierTypeLockMask
    toEnum 4 = ModifierTypeControlMask
    toEnum 8 = ModifierTypeAltMask
    toEnum 256 = ModifierTypeButton1Mask
    toEnum 512 = ModifierTypeButton2Mask
    toEnum 1024 = ModifierTypeButton3Mask
    toEnum 2048 = ModifierTypeButton4Mask
    toEnum 4096 = ModifierTypeButton5Mask
    toEnum 67108864 = ModifierTypeSuperMask
    toEnum 134217728 = ModifierTypeHyperMask
    toEnum 268435456 = ModifierTypeMetaMask
    toEnum k = AnotherModifierType k

instance P.Ord ModifierType where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes ModifierType = '[]
instance O.HasParentTypes ModifierType

foreign import ccall "gdk_modifier_type_get_type" c_gdk_modifier_type_get_type :: 
    IO GType

instance B.Types.TypedObject ModifierType where
    glibType = c_gdk_modifier_type_get_type

instance B.Types.BoxedFlags ModifierType

instance IsGFlag ModifierType

-- Flags GLAPI
-- | The list of the different APIs that GdkGLContext can potentially support.
-- 
-- /Since: 4.6/
data GLAPI = 
      GLAPIGl
    -- ^ The OpenGL API
    | GLAPIGles
    -- ^ The OpenGL ES API
    | AnotherGLAPI Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum GLAPI where
    fromEnum GLAPIGl = 1
    fromEnum GLAPIGles = 2
    fromEnum (AnotherGLAPI k) = k

    toEnum 1 = GLAPIGl
    toEnum 2 = GLAPIGles
    toEnum k = AnotherGLAPI k

instance P.Ord GLAPI where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes GLAPI = '[]
instance O.HasParentTypes GLAPI

foreign import ccall "gdk_gl_api_get_type" c_gdk_gl_api_get_type :: 
    IO GType

instance B.Types.TypedObject GLAPI where
    glibType = c_gdk_gl_api_get_type

instance B.Types.BoxedFlags GLAPI

instance IsGFlag GLAPI

-- Flags FrameClockPhase
-- | Used to represent the different paint clock phases that can be requested.
-- 
-- The elements of the enumeration correspond to the signals of @GdkFrameClock@.
data FrameClockPhase = 
      FrameClockPhaseNone
    -- ^ no phase
    | FrameClockPhaseFlushEvents
    -- ^ corresponds to GdkFrameClock[flushEvents](#g:signal:flushEvents). Should not be handled by applications.
    | FrameClockPhaseBeforePaint
    -- ^ corresponds to GdkFrameClock[beforePaint](#g:signal:beforePaint). Should not be handled by applications.
    | FrameClockPhaseUpdate
    -- ^ corresponds to GdkFrameClock[update](#g:signal:update).
    | FrameClockPhaseLayout
    -- ^ corresponds to GdkFrameClock[layout](#g:signal:layout). Should not be handled by applications.
    | FrameClockPhasePaint
    -- ^ corresponds to GdkFrameClock[paint](#g:signal:paint).
    | FrameClockPhaseResumeEvents
    -- ^ corresponds to GdkFrameClock[resumeEvents](#g:signal:resumeEvents). Should not be handled by applications.
    | FrameClockPhaseAfterPaint
    -- ^ corresponds to GdkFrameClock[afterPaint](#g:signal:afterPaint). Should not be handled by applications.
    | AnotherFrameClockPhase Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum FrameClockPhase where
    fromEnum FrameClockPhaseNone = 0
    fromEnum FrameClockPhaseFlushEvents = 1
    fromEnum FrameClockPhaseBeforePaint = 2
    fromEnum FrameClockPhaseUpdate = 4
    fromEnum FrameClockPhaseLayout = 8
    fromEnum FrameClockPhasePaint = 16
    fromEnum FrameClockPhaseResumeEvents = 32
    fromEnum FrameClockPhaseAfterPaint = 64
    fromEnum (AnotherFrameClockPhase k) = k

    toEnum 0 = FrameClockPhaseNone
    toEnum 1 = FrameClockPhaseFlushEvents
    toEnum 2 = FrameClockPhaseBeforePaint
    toEnum 4 = FrameClockPhaseUpdate
    toEnum 8 = FrameClockPhaseLayout
    toEnum 16 = FrameClockPhasePaint
    toEnum 32 = FrameClockPhaseResumeEvents
    toEnum 64 = FrameClockPhaseAfterPaint
    toEnum k = AnotherFrameClockPhase k

instance P.Ord FrameClockPhase where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes FrameClockPhase = '[]
instance O.HasParentTypes FrameClockPhase

foreign import ccall "gdk_frame_clock_phase_get_type" c_gdk_frame_clock_phase_get_type :: 
    IO GType

instance B.Types.TypedObject FrameClockPhase where
    glibType = c_gdk_frame_clock_phase_get_type

instance B.Types.BoxedFlags FrameClockPhase

instance IsGFlag FrameClockPhase

-- Flags DragAction
-- | Used in @GdkDrop@ and @GdkDrag@ to indicate the actions that the
-- destination can and should do with the dropped data.
data DragAction = 
      DragActionNone
    -- ^ No action.
    -- 
    -- /Since: 4.20/
    | DragActionCopy
    -- ^ Copy the data.
    | DragActionMove
    -- ^ Move the data, i.e. first copy it, then delete
    --   it from the source using the DELETE target of the X selection protocol.
    | DragActionLink
    -- ^ Add a link to the data. Note that this is only
    --   useful if source and destination agree on what it means, and is not
    --   supported on all platforms.
    | DragActionAsk
    -- ^ Ask the user what to do with the data.
    | AnotherDragAction Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum DragAction where
    fromEnum DragActionNone = 0
    fromEnum DragActionCopy = 1
    fromEnum DragActionMove = 2
    fromEnum DragActionLink = 4
    fromEnum DragActionAsk = 8
    fromEnum (AnotherDragAction k) = k

    toEnum 0 = DragActionNone
    toEnum 1 = DragActionCopy
    toEnum 2 = DragActionMove
    toEnum 4 = DragActionLink
    toEnum 8 = DragActionAsk
    toEnum k = AnotherDragAction k

instance P.Ord DragAction where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes DragAction = '[]
instance O.HasParentTypes DragAction

foreign import ccall "gdk_drag_action_get_type" c_gdk_drag_action_get_type :: 
    IO GType

instance B.Types.TypedObject DragAction where
    glibType = c_gdk_drag_action_get_type

instance B.Types.BoxedFlags DragAction

instance IsGFlag DragAction

-- Flags AxisFlags
-- | Flags describing the current capabilities of a device\/tool.
data AxisFlags = 
      AxisFlagsX
    -- ^ X axis is present
    | AxisFlagsY
    -- ^ Y axis is present
    | AxisFlagsDeltaX
    -- ^ Scroll X delta axis is present
    | AxisFlagsDeltaY
    -- ^ Scroll Y delta axis is present
    | AxisFlagsPressure
    -- ^ Pressure axis is present
    | AxisFlagsXtilt
    -- ^ X tilt axis is present
    | AxisFlagsYtilt
    -- ^ Y tilt axis is present
    | AxisFlagsWheel
    -- ^ Wheel axis is present
    | AxisFlagsDistance
    -- ^ Distance axis is present
    | AxisFlagsRotation
    -- ^ Z-axis rotation is present
    | AxisFlagsSlider
    -- ^ Slider axis is present
    | AnotherAxisFlags Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum AxisFlags where
    fromEnum AxisFlagsX = 2
    fromEnum AxisFlagsY = 4
    fromEnum AxisFlagsDeltaX = 8
    fromEnum AxisFlagsDeltaY = 16
    fromEnum AxisFlagsPressure = 32
    fromEnum AxisFlagsXtilt = 64
    fromEnum AxisFlagsYtilt = 128
    fromEnum AxisFlagsWheel = 256
    fromEnum AxisFlagsDistance = 512
    fromEnum AxisFlagsRotation = 1024
    fromEnum AxisFlagsSlider = 2048
    fromEnum (AnotherAxisFlags k) = k

    toEnum 2 = AxisFlagsX
    toEnum 4 = AxisFlagsY
    toEnum 8 = AxisFlagsDeltaX
    toEnum 16 = AxisFlagsDeltaY
    toEnum 32 = AxisFlagsPressure
    toEnum 64 = AxisFlagsXtilt
    toEnum 128 = AxisFlagsYtilt
    toEnum 256 = AxisFlagsWheel
    toEnum 512 = AxisFlagsDistance
    toEnum 1024 = AxisFlagsRotation
    toEnum 2048 = AxisFlagsSlider
    toEnum k = AnotherAxisFlags k

instance P.Ord AxisFlags where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes AxisFlags = '[]
instance O.HasParentTypes AxisFlags

foreign import ccall "gdk_axis_flags_get_type" c_gdk_axis_flags_get_type :: 
    IO GType

instance B.Types.TypedObject AxisFlags where
    glibType = c_gdk_axis_flags_get_type

instance B.Types.BoxedFlags AxisFlags

instance IsGFlag AxisFlags

-- Flags AnchorHints
-- | Positioning hints for aligning a surface relative to a rectangle.
-- 
-- These hints determine how the surface should be positioned in the case that
-- the surface would fall off-screen if placed in its ideal position.
-- 
-- For example, 'GI.Gdk.Flags.AnchorHintsFlipX' will replace 'GI.Gdk.Enums.GravityNorthWest' with
-- 'GI.Gdk.Enums.GravityNorthEast' and vice versa if the surface extends beyond the left
-- or right edges of the monitor.
-- 
-- If 'GI.Gdk.Flags.AnchorHintsSlideX' is set, the surface can be shifted horizontally to fit
-- on-screen. If 'GI.Gdk.Flags.AnchorHintsResizeX' is set, the surface can be shrunken
-- horizontally to fit.
-- 
-- In general, when multiple flags are set, flipping should take precedence over
-- sliding, which should take precedence over resizing.
data AnchorHints = 
      AnchorHintsFlipX
    -- ^ allow flipping anchors horizontally
    | AnchorHintsFlipY
    -- ^ allow flipping anchors vertically
    | AnchorHintsSlideX
    -- ^ allow sliding surface horizontally
    | AnchorHintsSlideY
    -- ^ allow sliding surface vertically
    | AnchorHintsResizeX
    -- ^ allow resizing surface horizontally
    | AnchorHintsResizeY
    -- ^ allow resizing surface vertically
    | AnchorHintsFlip
    -- ^ allow flipping anchors on both axes
    | AnchorHintsSlide
    -- ^ allow sliding surface on both axes
    | AnchorHintsResize
    -- ^ allow resizing surface on both axes
    | AnotherAnchorHints Int
    -- ^ Catch-all for unknown values
    deriving (Show, Eq)

instance P.Enum AnchorHints where
    fromEnum AnchorHintsFlipX = 1
    fromEnum AnchorHintsFlipY = 2
    fromEnum AnchorHintsSlideX = 4
    fromEnum AnchorHintsSlideY = 8
    fromEnum AnchorHintsResizeX = 16
    fromEnum AnchorHintsResizeY = 32
    fromEnum AnchorHintsFlip = 3
    fromEnum AnchorHintsSlide = 12
    fromEnum AnchorHintsResize = 48
    fromEnum (AnotherAnchorHints k) = k

    toEnum 1 = AnchorHintsFlipX
    toEnum 2 = AnchorHintsFlipY
    toEnum 4 = AnchorHintsSlideX
    toEnum 8 = AnchorHintsSlideY
    toEnum 16 = AnchorHintsResizeX
    toEnum 32 = AnchorHintsResizeY
    toEnum 3 = AnchorHintsFlip
    toEnum 12 = AnchorHintsSlide
    toEnum 48 = AnchorHintsResize
    toEnum k = AnotherAnchorHints k

instance P.Ord AnchorHints where
    compare a b = P.compare (P.fromEnum a) (P.fromEnum b)

type instance O.ParentTypes AnchorHints = '[]
instance O.HasParentTypes AnchorHints

foreign import ccall "gdk_anchor_hints_get_type" c_gdk_anchor_hints_get_type :: 
    IO GType

instance B.Types.TypedObject AnchorHints where
    glibType = c_gdk_anchor_hints_get_type

instance B.Types.BoxedFlags AnchorHints

instance IsGFlag AnchorHints


