/*
 * JIS X 0212 implementation for libcharset. (This is the character
 * set itself, not any particular multibyte encoding of it.
 * Multibyte encodings of this character set are handled
 * separately.)
 */

#include <assert.h>

#include "charset.h"
#include "internal.h"

/*
 * These tables are generated from the JIS X 0212 <-> Unicode
 * character mapping found at
 * 
 * http://www.unicode.org/Public/MAPPINGS/OBSOLETE/EASTASIA/JIS/JIS0212.TXT
 */

/*
 * Mapping from JIS X 0212 to Unicode. For these purposes JIS X
 * 0212 is considered to be a 94x94 square array, with coordinates
 * running from (0,0) to (93,93).
 * 
 * Generated by running the following sh+Perl over JIS0212.TXT:

cat JIS0212.TXT | \
perl -ne '$a{hex$1,hex$2}=$3 if /^0x(\S\S)(\S\S)\s+(0x\S+)\s/;' \
      -e 'END {for $r (0..93) { $o="    {"; for $c (0..93) {' \
      -e '$k=$a{$r+33,$c+33}; $k=" ERROR" unless defined $k;' \
      -e '$o .= ", " if $c > 0; (print "$o\n"), $o="    " if length $o > 70;' \
      -e '$o .= $k; } print "$o},\n"; }}'

 */

static const unsigned short jisx0212_forward[94][94] = {
    { ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    { ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 0x02D8, 0x02C7, 0x00B8, 0x02D9, 
    0x02DD, 0x00AF, 0x02DB, 0x02DA, 0x007E, 0x0384, 0x0385,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 0x00A1, 0x00A6, 0x00BF, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR, 0x00BA, 0x00AA, 0x00A9, 0x00AE, 0x2122, 0x00A4, 0x2116, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    { ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    { ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    { ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    { ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR, 0x0386, 0x0388, 0x0389, 0x038A, 0x03AA,  ERROR, 0x038C,  ERROR, 
    0x038E, 0x03AB,  ERROR, 0x038F,  ERROR,  ERROR,  ERROR,  ERROR, 0x03AC, 
    0x03AD, 0x03AE, 0x03AF, 0x03CA, 0x0390, 0x03CC, 0x03C2, 0x03CD, 0x03CB, 
    0x03B0, 0x03CE,  ERROR,  ERROR},
    { ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 0x0402, 0x0403, 0x0404, 
    0x0405, 0x0406, 0x0407, 0x0408, 0x0409, 0x040A, 0x040B, 0x040C, 0x040E, 
    0x040F,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
    0x0452, 0x0453, 0x0454, 0x0455, 0x0456, 0x0457, 0x0458, 0x0459, 0x045A, 
    0x045B, 0x045C, 0x045E, 0x045F},
    { ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    {0x00C6, 0x0110,  ERROR, 0x0126,  ERROR, 0x0132,  ERROR, 0x0141, 0x013F, 
     ERROR, 0x014A, 0x00D8, 0x0152,  ERROR, 0x0166, 0x00DE,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 0x00E6, 0x0111, 0x00F0, 0x0127, 
    0x0131, 0x0133, 0x0138, 0x0142, 0x0140, 0x0149, 0x014B, 0x00F8, 0x0153, 
    0x00DF, 0x0167, 0x00FE,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    {0x00C1, 0x00C0, 0x00C4, 0x00C2, 0x0102, 0x01CD, 0x0100, 0x0104, 0x00C5, 
    0x00C3, 0x0106, 0x0108, 0x010C, 0x00C7, 0x010A, 0x010E, 0x00C9, 0x00C8, 
    0x00CB, 0x00CA, 0x011A, 0x0116, 0x0112, 0x0118,  ERROR, 0x011C, 0x011E, 
    0x0122, 0x0120, 0x0124, 0x00CD, 0x00CC, 0x00CF, 0x00CE, 0x01CF, 0x0130, 
    0x012A, 0x012E, 0x0128, 0x0134, 0x0136, 0x0139, 0x013D, 0x013B, 0x0143, 
    0x0147, 0x0145, 0x00D1, 0x00D3, 0x00D2, 0x00D6, 0x00D4, 0x01D1, 0x0150, 
    0x014C, 0x00D5, 0x0154, 0x0158, 0x0156, 0x015A, 0x015C, 0x0160, 0x015E, 
    0x0164, 0x0162, 0x00DA, 0x00D9, 0x00DC, 0x00DB, 0x016C, 0x01D3, 0x0170, 
    0x016A, 0x0172, 0x016E, 0x0168, 0x01D7, 0x01DB, 0x01D9, 0x01D5, 0x0174, 
    0x00DD, 0x0178, 0x0176, 0x0179, 0x017D, 0x017B,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    {0x00E1, 0x00E0, 0x00E4, 0x00E2, 0x0103, 0x01CE, 0x0101, 0x0105, 0x00E5, 
    0x00E3, 0x0107, 0x0109, 0x010D, 0x00E7, 0x010B, 0x010F, 0x00E9, 0x00E8, 
    0x00EB, 0x00EA, 0x011B, 0x0117, 0x0113, 0x0119, 0x01F5, 0x011D, 0x011F, 
     ERROR, 0x0121, 0x0125, 0x00ED, 0x00EC, 0x00EF, 0x00EE, 0x01D0,  ERROR, 
    0x012B, 0x012F, 0x0129, 0x0135, 0x0137, 0x013A, 0x013E, 0x013C, 0x0144, 
    0x0148, 0x0146, 0x00F1, 0x00F3, 0x00F2, 0x00F6, 0x00F4, 0x01D2, 0x0151, 
    0x014D, 0x00F5, 0x0155, 0x0159, 0x0157, 0x015B, 0x015D, 0x0161, 0x015F, 
    0x0165, 0x0163, 0x00FA, 0x00F9, 0x00FC, 0x00FB, 0x016D, 0x01D4, 0x0171, 
    0x016B, 0x0173, 0x016F, 0x0169, 0x01D8, 0x01DC, 0x01DA, 0x01D6, 0x0175, 
    0x00FD, 0x00FF, 0x0177, 0x017A, 0x017E, 0x017C,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    { ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    { ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    { ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    { ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    {0x4E02, 0x4E04, 0x4E05, 0x4E0C, 0x4E12, 0x4E1F, 0x4E23, 0x4E24, 0x4E28, 
    0x4E2B, 0x4E2E, 0x4E2F, 0x4E30, 0x4E35, 0x4E40, 0x4E41, 0x4E44, 0x4E47, 
    0x4E51, 0x4E5A, 0x4E5C, 0x4E63, 0x4E68, 0x4E69, 0x4E74, 0x4E75, 0x4E79, 
    0x4E7F, 0x4E8D, 0x4E96, 0x4E97, 0x4E9D, 0x4EAF, 0x4EB9, 0x4EC3, 0x4ED0, 
    0x4EDA, 0x4EDB, 0x4EE0, 0x4EE1, 0x4EE2, 0x4EE8, 0x4EEF, 0x4EF1, 0x4EF3, 
    0x4EF5, 0x4EFD, 0x4EFE, 0x4EFF, 0x4F00, 0x4F02, 0x4F03, 0x4F08, 0x4F0B, 
    0x4F0C, 0x4F12, 0x4F15, 0x4F16, 0x4F17, 0x4F19, 0x4F2E, 0x4F31, 0x4F60, 
    0x4F33, 0x4F35, 0x4F37, 0x4F39, 0x4F3B, 0x4F3E, 0x4F40, 0x4F42, 0x4F48, 
    0x4F49, 0x4F4B, 0x4F4C, 0x4F52, 0x4F54, 0x4F56, 0x4F58, 0x4F5F, 0x4F63, 
    0x4F6A, 0x4F6C, 0x4F6E, 0x4F71, 0x4F77, 0x4F78, 0x4F79, 0x4F7A, 0x4F7D, 
    0x4F7E, 0x4F81, 0x4F82, 0x4F84},
    {0x4F85, 0x4F89, 0x4F8A, 0x4F8C, 0x4F8E, 0x4F90, 0x4F92, 0x4F93, 0x4F94, 
    0x4F97, 0x4F99, 0x4F9A, 0x4F9E, 0x4F9F, 0x4FB2, 0x4FB7, 0x4FB9, 0x4FBB, 
    0x4FBC, 0x4FBD, 0x4FBE, 0x4FC0, 0x4FC1, 0x4FC5, 0x4FC6, 0x4FC8, 0x4FC9, 
    0x4FCB, 0x4FCC, 0x4FCD, 0x4FCF, 0x4FD2, 0x4FDC, 0x4FE0, 0x4FE2, 0x4FF0, 
    0x4FF2, 0x4FFC, 0x4FFD, 0x4FFF, 0x5000, 0x5001, 0x5004, 0x5007, 0x500A, 
    0x500C, 0x500E, 0x5010, 0x5013, 0x5017, 0x5018, 0x501B, 0x501C, 0x501D, 
    0x501E, 0x5022, 0x5027, 0x502E, 0x5030, 0x5032, 0x5033, 0x5035, 0x5040, 
    0x5041, 0x5042, 0x5045, 0x5046, 0x504A, 0x504C, 0x504E, 0x5051, 0x5052, 
    0x5053, 0x5057, 0x5059, 0x505F, 0x5060, 0x5062, 0x5063, 0x5066, 0x5067, 
    0x506A, 0x506D, 0x5070, 0x5071, 0x503B, 0x5081, 0x5083, 0x5084, 0x5086, 
    0x508A, 0x508E, 0x508F, 0x5090},
    {0x5092, 0x5093, 0x5094, 0x5096, 0x509B, 0x509C, 0x509E, 0x509F, 0x50A0, 
    0x50A1, 0x50A2, 0x50AA, 0x50AF, 0x50B0, 0x50B9, 0x50BA, 0x50BD, 0x50C0, 
    0x50C3, 0x50C4, 0x50C7, 0x50CC, 0x50CE, 0x50D0, 0x50D3, 0x50D4, 0x50D8, 
    0x50DC, 0x50DD, 0x50DF, 0x50E2, 0x50E4, 0x50E6, 0x50E8, 0x50E9, 0x50EF, 
    0x50F1, 0x50F6, 0x50FA, 0x50FE, 0x5103, 0x5106, 0x5107, 0x5108, 0x510B, 
    0x510C, 0x510D, 0x510E, 0x50F2, 0x5110, 0x5117, 0x5119, 0x511B, 0x511C, 
    0x511D, 0x511E, 0x5123, 0x5127, 0x5128, 0x512C, 0x512D, 0x512F, 0x5131, 
    0x5133, 0x5134, 0x5135, 0x5138, 0x5139, 0x5142, 0x514A, 0x514F, 0x5153, 
    0x5155, 0x5157, 0x5158, 0x515F, 0x5164, 0x5166, 0x517E, 0x5183, 0x5184, 
    0x518B, 0x518E, 0x5198, 0x519D, 0x51A1, 0x51A3, 0x51AD, 0x51B8, 0x51BA, 
    0x51BC, 0x51BE, 0x51BF, 0x51C2},
    {0x51C8, 0x51CF, 0x51D1, 0x51D2, 0x51D3, 0x51D5, 0x51D8, 0x51DE, 0x51E2, 
    0x51E5, 0x51EE, 0x51F2, 0x51F3, 0x51F4, 0x51F7, 0x5201, 0x5202, 0x5205, 
    0x5212, 0x5213, 0x5215, 0x5216, 0x5218, 0x5222, 0x5228, 0x5231, 0x5232, 
    0x5235, 0x523C, 0x5245, 0x5249, 0x5255, 0x5257, 0x5258, 0x525A, 0x525C, 
    0x525F, 0x5260, 0x5261, 0x5266, 0x526E, 0x5277, 0x5278, 0x5279, 0x5280, 
    0x5282, 0x5285, 0x528A, 0x528C, 0x5293, 0x5295, 0x5296, 0x5297, 0x5298, 
    0x529A, 0x529C, 0x52A4, 0x52A5, 0x52A6, 0x52A7, 0x52AF, 0x52B0, 0x52B6, 
    0x52B7, 0x52B8, 0x52BA, 0x52BB, 0x52BD, 0x52C0, 0x52C4, 0x52C6, 0x52C8, 
    0x52CC, 0x52CF, 0x52D1, 0x52D4, 0x52D6, 0x52DB, 0x52DC, 0x52E1, 0x52E5, 
    0x52E8, 0x52E9, 0x52EA, 0x52EC, 0x52F0, 0x52F1, 0x52F4, 0x52F6, 0x52F7, 
    0x5300, 0x5303, 0x530A, 0x530B},
    {0x530C, 0x5311, 0x5313, 0x5318, 0x531B, 0x531C, 0x531E, 0x531F, 0x5325, 
    0x5327, 0x5328, 0x5329, 0x532B, 0x532C, 0x532D, 0x5330, 0x5332, 0x5335, 
    0x533C, 0x533D, 0x533E, 0x5342, 0x534C, 0x534B, 0x5359, 0x535B, 0x5361, 
    0x5363, 0x5365, 0x536C, 0x536D, 0x5372, 0x5379, 0x537E, 0x5383, 0x5387, 
    0x5388, 0x538E, 0x5393, 0x5394, 0x5399, 0x539D, 0x53A1, 0x53A4, 0x53AA, 
    0x53AB, 0x53AF, 0x53B2, 0x53B4, 0x53B5, 0x53B7, 0x53B8, 0x53BA, 0x53BD, 
    0x53C0, 0x53C5, 0x53CF, 0x53D2, 0x53D3, 0x53D5, 0x53DA, 0x53DD, 0x53DE, 
    0x53E0, 0x53E6, 0x53E7, 0x53F5, 0x5402, 0x5413, 0x541A, 0x5421, 0x5427, 
    0x5428, 0x542A, 0x542F, 0x5431, 0x5434, 0x5435, 0x5443, 0x5444, 0x5447, 
    0x544D, 0x544F, 0x545E, 0x5462, 0x5464, 0x5466, 0x5467, 0x5469, 0x546B, 
    0x546D, 0x546E, 0x5474, 0x547F},
    {0x5481, 0x5483, 0x5485, 0x5488, 0x5489, 0x548D, 0x5491, 0x5495, 0x5496, 
    0x549C, 0x549F, 0x54A1, 0x54A6, 0x54A7, 0x54A9, 0x54AA, 0x54AD, 0x54AE, 
    0x54B1, 0x54B7, 0x54B9, 0x54BA, 0x54BB, 0x54BF, 0x54C6, 0x54CA, 0x54CD, 
    0x54CE, 0x54E0, 0x54EA, 0x54EC, 0x54EF, 0x54F6, 0x54FC, 0x54FE, 0x54FF, 
    0x5500, 0x5501, 0x5505, 0x5508, 0x5509, 0x550C, 0x550D, 0x550E, 0x5515, 
    0x552A, 0x552B, 0x5532, 0x5535, 0x5536, 0x553B, 0x553C, 0x553D, 0x5541, 
    0x5547, 0x5549, 0x554A, 0x554D, 0x5550, 0x5551, 0x5558, 0x555A, 0x555B, 
    0x555E, 0x5560, 0x5561, 0x5564, 0x5566, 0x557F, 0x5581, 0x5582, 0x5586, 
    0x5588, 0x558E, 0x558F, 0x5591, 0x5592, 0x5593, 0x5594, 0x5597, 0x55A3, 
    0x55A4, 0x55AD, 0x55B2, 0x55BF, 0x55C1, 0x55C3, 0x55C6, 0x55C9, 0x55CB, 
    0x55CC, 0x55CE, 0x55D1, 0x55D2},
    {0x55D3, 0x55D7, 0x55D8, 0x55DB, 0x55DE, 0x55E2, 0x55E9, 0x55F6, 0x55FF, 
    0x5605, 0x5608, 0x560A, 0x560D, 0x560E, 0x560F, 0x5610, 0x5611, 0x5612, 
    0x5619, 0x562C, 0x5630, 0x5633, 0x5635, 0x5637, 0x5639, 0x563B, 0x563C, 
    0x563D, 0x563F, 0x5640, 0x5641, 0x5643, 0x5644, 0x5646, 0x5649, 0x564B, 
    0x564D, 0x564F, 0x5654, 0x565E, 0x5660, 0x5661, 0x5662, 0x5663, 0x5666, 
    0x5669, 0x566D, 0x566F, 0x5671, 0x5672, 0x5675, 0x5684, 0x5685, 0x5688, 
    0x568B, 0x568C, 0x5695, 0x5699, 0x569A, 0x569D, 0x569E, 0x569F, 0x56A6, 
    0x56A7, 0x56A8, 0x56A9, 0x56AB, 0x56AC, 0x56AD, 0x56B1, 0x56B3, 0x56B7, 
    0x56BE, 0x56C5, 0x56C9, 0x56CA, 0x56CB, 0x56CF, 0x56D0, 0x56CC, 0x56CD, 
    0x56D9, 0x56DC, 0x56DD, 0x56DF, 0x56E1, 0x56E4, 0x56E5, 0x56E6, 0x56E7, 
    0x56E8, 0x56F1, 0x56EB, 0x56ED},
    {0x56F6, 0x56F7, 0x5701, 0x5702, 0x5707, 0x570A, 0x570C, 0x5711, 0x5715, 
    0x571A, 0x571B, 0x571D, 0x5720, 0x5722, 0x5723, 0x5724, 0x5725, 0x5729, 
    0x572A, 0x572C, 0x572E, 0x572F, 0x5733, 0x5734, 0x573D, 0x573E, 0x573F, 
    0x5745, 0x5746, 0x574C, 0x574D, 0x5752, 0x5762, 0x5765, 0x5767, 0x5768, 
    0x576B, 0x576D, 0x576E, 0x576F, 0x5770, 0x5771, 0x5773, 0x5774, 0x5775, 
    0x5777, 0x5779, 0x577A, 0x577B, 0x577C, 0x577E, 0x5781, 0x5783, 0x578C, 
    0x5794, 0x5797, 0x5799, 0x579A, 0x579C, 0x579D, 0x579E, 0x579F, 0x57A1, 
    0x5795, 0x57A7, 0x57A8, 0x57A9, 0x57AC, 0x57B8, 0x57BD, 0x57C7, 0x57C8, 
    0x57CC, 0x57CF, 0x57D5, 0x57DD, 0x57DE, 0x57E4, 0x57E6, 0x57E7, 0x57E9, 
    0x57ED, 0x57F0, 0x57F5, 0x57F6, 0x57F8, 0x57FD, 0x57FE, 0x57FF, 0x5803, 
    0x5804, 0x5808, 0x5809, 0x57E1},
    {0x580C, 0x580D, 0x581B, 0x581E, 0x581F, 0x5820, 0x5826, 0x5827, 0x582D, 
    0x5832, 0x5839, 0x583F, 0x5849, 0x584C, 0x584D, 0x584F, 0x5850, 0x5855, 
    0x585F, 0x5861, 0x5864, 0x5867, 0x5868, 0x5878, 0x587C, 0x587F, 0x5880, 
    0x5881, 0x5887, 0x5888, 0x5889, 0x588A, 0x588C, 0x588D, 0x588F, 0x5890, 
    0x5894, 0x5896, 0x589D, 0x58A0, 0x58A1, 0x58A2, 0x58A6, 0x58A9, 0x58B1, 
    0x58B2, 0x58C4, 0x58BC, 0x58C2, 0x58C8, 0x58CD, 0x58CE, 0x58D0, 0x58D2, 
    0x58D4, 0x58D6, 0x58DA, 0x58DD, 0x58E1, 0x58E2, 0x58E9, 0x58F3, 0x5905, 
    0x5906, 0x590B, 0x590C, 0x5912, 0x5913, 0x5914, 0x8641, 0x591D, 0x5921, 
    0x5923, 0x5924, 0x5928, 0x592F, 0x5930, 0x5933, 0x5935, 0x5936, 0x593F, 
    0x5943, 0x5946, 0x5952, 0x5953, 0x5959, 0x595B, 0x595D, 0x595E, 0x595F, 
    0x5961, 0x5963, 0x596B, 0x596D},
    {0x596F, 0x5972, 0x5975, 0x5976, 0x5979, 0x597B, 0x597C, 0x598B, 0x598C, 
    0x598E, 0x5992, 0x5995, 0x5997, 0x599F, 0x59A4, 0x59A7, 0x59AD, 0x59AE, 
    0x59AF, 0x59B0, 0x59B3, 0x59B7, 0x59BA, 0x59BC, 0x59C1, 0x59C3, 0x59C4, 
    0x59C8, 0x59CA, 0x59CD, 0x59D2, 0x59DD, 0x59DE, 0x59DF, 0x59E3, 0x59E4, 
    0x59E7, 0x59EE, 0x59EF, 0x59F1, 0x59F2, 0x59F4, 0x59F7, 0x5A00, 0x5A04, 
    0x5A0C, 0x5A0D, 0x5A0E, 0x5A12, 0x5A13, 0x5A1E, 0x5A23, 0x5A24, 0x5A27, 
    0x5A28, 0x5A2A, 0x5A2D, 0x5A30, 0x5A44, 0x5A45, 0x5A47, 0x5A48, 0x5A4C, 
    0x5A50, 0x5A55, 0x5A5E, 0x5A63, 0x5A65, 0x5A67, 0x5A6D, 0x5A77, 0x5A7A, 
    0x5A7B, 0x5A7E, 0x5A8B, 0x5A90, 0x5A93, 0x5A96, 0x5A99, 0x5A9C, 0x5A9E, 
    0x5A9F, 0x5AA0, 0x5AA2, 0x5AA7, 0x5AAC, 0x5AB1, 0x5AB2, 0x5AB3, 0x5AB5, 
    0x5AB8, 0x5ABA, 0x5ABB, 0x5ABF},
    {0x5AC4, 0x5AC6, 0x5AC8, 0x5ACF, 0x5ADA, 0x5ADC, 0x5AE0, 0x5AE5, 0x5AEA, 
    0x5AEE, 0x5AF5, 0x5AF6, 0x5AFD, 0x5B00, 0x5B01, 0x5B08, 0x5B17, 0x5B34, 
    0x5B19, 0x5B1B, 0x5B1D, 0x5B21, 0x5B25, 0x5B2D, 0x5B38, 0x5B41, 0x5B4B, 
    0x5B4C, 0x5B52, 0x5B56, 0x5B5E, 0x5B68, 0x5B6E, 0x5B6F, 0x5B7C, 0x5B7D, 
    0x5B7E, 0x5B7F, 0x5B81, 0x5B84, 0x5B86, 0x5B8A, 0x5B8E, 0x5B90, 0x5B91, 
    0x5B93, 0x5B94, 0x5B96, 0x5BA8, 0x5BA9, 0x5BAC, 0x5BAD, 0x5BAF, 0x5BB1, 
    0x5BB2, 0x5BB7, 0x5BBA, 0x5BBC, 0x5BC0, 0x5BC1, 0x5BCD, 0x5BCF, 0x5BD6, 
    0x5BD7, 0x5BD8, 0x5BD9, 0x5BDA, 0x5BE0, 0x5BEF, 0x5BF1, 0x5BF4, 0x5BFD, 
    0x5C0C, 0x5C17, 0x5C1E, 0x5C1F, 0x5C23, 0x5C26, 0x5C29, 0x5C2B, 0x5C2C, 
    0x5C2E, 0x5C30, 0x5C32, 0x5C35, 0x5C36, 0x5C59, 0x5C5A, 0x5C5C, 0x5C62, 
    0x5C63, 0x5C67, 0x5C68, 0x5C69},
    {0x5C6D, 0x5C70, 0x5C74, 0x5C75, 0x5C7A, 0x5C7B, 0x5C7C, 0x5C7D, 0x5C87, 
    0x5C88, 0x5C8A, 0x5C8F, 0x5C92, 0x5C9D, 0x5C9F, 0x5CA0, 0x5CA2, 0x5CA3, 
    0x5CA6, 0x5CAA, 0x5CB2, 0x5CB4, 0x5CB5, 0x5CBA, 0x5CC9, 0x5CCB, 0x5CD2, 
    0x5CDD, 0x5CD7, 0x5CEE, 0x5CF1, 0x5CF2, 0x5CF4, 0x5D01, 0x5D06, 0x5D0D, 
    0x5D12, 0x5D2B, 0x5D23, 0x5D24, 0x5D26, 0x5D27, 0x5D31, 0x5D34, 0x5D39, 
    0x5D3D, 0x5D3F, 0x5D42, 0x5D43, 0x5D46, 0x5D48, 0x5D55, 0x5D51, 0x5D59, 
    0x5D4A, 0x5D5F, 0x5D60, 0x5D61, 0x5D62, 0x5D64, 0x5D6A, 0x5D6D, 0x5D70, 
    0x5D79, 0x5D7A, 0x5D7E, 0x5D7F, 0x5D81, 0x5D83, 0x5D88, 0x5D8A, 0x5D92, 
    0x5D93, 0x5D94, 0x5D95, 0x5D99, 0x5D9B, 0x5D9F, 0x5DA0, 0x5DA7, 0x5DAB, 
    0x5DB0, 0x5DB4, 0x5DB8, 0x5DB9, 0x5DC3, 0x5DC7, 0x5DCB, 0x5DD0, 0x5DCE, 
    0x5DD8, 0x5DD9, 0x5DE0, 0x5DE4},
    {0x5DE9, 0x5DF8, 0x5DF9, 0x5E00, 0x5E07, 0x5E0D, 0x5E12, 0x5E14, 0x5E15, 
    0x5E18, 0x5E1F, 0x5E20, 0x5E2E, 0x5E28, 0x5E32, 0x5E35, 0x5E3E, 0x5E4B, 
    0x5E50, 0x5E49, 0x5E51, 0x5E56, 0x5E58, 0x5E5B, 0x5E5C, 0x5E5E, 0x5E68, 
    0x5E6A, 0x5E6B, 0x5E6C, 0x5E6D, 0x5E6E, 0x5E70, 0x5E80, 0x5E8B, 0x5E8E, 
    0x5EA2, 0x5EA4, 0x5EA5, 0x5EA8, 0x5EAA, 0x5EAC, 0x5EB1, 0x5EB3, 0x5EBD, 
    0x5EBE, 0x5EBF, 0x5EC6, 0x5ECC, 0x5ECB, 0x5ECE, 0x5ED1, 0x5ED2, 0x5ED4, 
    0x5ED5, 0x5EDC, 0x5EDE, 0x5EE5, 0x5EEB, 0x5F02, 0x5F06, 0x5F07, 0x5F08, 
    0x5F0E, 0x5F19, 0x5F1C, 0x5F1D, 0x5F21, 0x5F22, 0x5F23, 0x5F24, 0x5F28, 
    0x5F2B, 0x5F2C, 0x5F2E, 0x5F30, 0x5F34, 0x5F36, 0x5F3B, 0x5F3D, 0x5F3F, 
    0x5F40, 0x5F44, 0x5F45, 0x5F47, 0x5F4D, 0x5F50, 0x5F54, 0x5F58, 0x5F5B, 
    0x5F60, 0x5F63, 0x5F64, 0x5F67},
    {0x5F6F, 0x5F72, 0x5F74, 0x5F75, 0x5F78, 0x5F7A, 0x5F7D, 0x5F7E, 0x5F89, 
    0x5F8D, 0x5F8F, 0x5F96, 0x5F9C, 0x5F9D, 0x5FA2, 0x5FA7, 0x5FAB, 0x5FA4, 
    0x5FAC, 0x5FAF, 0x5FB0, 0x5FB1, 0x5FB8, 0x5FC4, 0x5FC7, 0x5FC8, 0x5FC9, 
    0x5FCB, 0x5FD0, 0x5FD1, 0x5FD2, 0x5FD3, 0x5FD4, 0x5FDE, 0x5FE1, 0x5FE2, 
    0x5FE8, 0x5FE9, 0x5FEA, 0x5FEC, 0x5FED, 0x5FEE, 0x5FEF, 0x5FF2, 0x5FF3, 
    0x5FF6, 0x5FFA, 0x5FFC, 0x6007, 0x600A, 0x600D, 0x6013, 0x6014, 0x6017, 
    0x6018, 0x601A, 0x601F, 0x6024, 0x602D, 0x6033, 0x6035, 0x6040, 0x6047, 
    0x6048, 0x6049, 0x604C, 0x6051, 0x6054, 0x6056, 0x6057, 0x605D, 0x6061, 
    0x6067, 0x6071, 0x607E, 0x607F, 0x6082, 0x6086, 0x6088, 0x608A, 0x608E, 
    0x6091, 0x6093, 0x6095, 0x6098, 0x609D, 0x609E, 0x60A2, 0x60A4, 0x60A5, 
    0x60A8, 0x60B0, 0x60B1, 0x60B7},
    {0x60BB, 0x60BE, 0x60C2, 0x60C4, 0x60C8, 0x60C9, 0x60CA, 0x60CB, 0x60CE, 
    0x60CF, 0x60D4, 0x60D5, 0x60D9, 0x60DB, 0x60DD, 0x60DE, 0x60E2, 0x60E5, 
    0x60F2, 0x60F5, 0x60F8, 0x60FC, 0x60FD, 0x6102, 0x6107, 0x610A, 0x610C, 
    0x6110, 0x6111, 0x6112, 0x6113, 0x6114, 0x6116, 0x6117, 0x6119, 0x611C, 
    0x611E, 0x6122, 0x612A, 0x612B, 0x6130, 0x6131, 0x6135, 0x6136, 0x6137, 
    0x6139, 0x6141, 0x6145, 0x6146, 0x6149, 0x615E, 0x6160, 0x616C, 0x6172, 
    0x6178, 0x617B, 0x617C, 0x617F, 0x6180, 0x6181, 0x6183, 0x6184, 0x618B, 
    0x618D, 0x6192, 0x6193, 0x6197, 0x6198, 0x619C, 0x619D, 0x619F, 0x61A0, 
    0x61A5, 0x61A8, 0x61AA, 0x61AD, 0x61B8, 0x61B9, 0x61BC, 0x61C0, 0x61C1, 
    0x61C2, 0x61CE, 0x61CF, 0x61D5, 0x61DC, 0x61DD, 0x61DE, 0x61DF, 0x61E1, 
    0x61E2, 0x61E7, 0x61E9, 0x61E5},
    {0x61EC, 0x61ED, 0x61EF, 0x6201, 0x6203, 0x6204, 0x6207, 0x6213, 0x6215, 
    0x621C, 0x6220, 0x6222, 0x6223, 0x6227, 0x6229, 0x622B, 0x6239, 0x623D, 
    0x6242, 0x6243, 0x6244, 0x6246, 0x624C, 0x6250, 0x6251, 0x6252, 0x6254, 
    0x6256, 0x625A, 0x625C, 0x6264, 0x626D, 0x626F, 0x6273, 0x627A, 0x627D, 
    0x628D, 0x628E, 0x628F, 0x6290, 0x62A6, 0x62A8, 0x62B3, 0x62B6, 0x62B7, 
    0x62BA, 0x62BE, 0x62BF, 0x62C4, 0x62CE, 0x62D5, 0x62D6, 0x62DA, 0x62EA, 
    0x62F2, 0x62F4, 0x62FC, 0x62FD, 0x6303, 0x6304, 0x630A, 0x630B, 0x630D, 
    0x6310, 0x6313, 0x6316, 0x6318, 0x6329, 0x632A, 0x632D, 0x6335, 0x6336, 
    0x6339, 0x633C, 0x6341, 0x6342, 0x6343, 0x6344, 0x6346, 0x634A, 0x634B, 
    0x634E, 0x6352, 0x6353, 0x6354, 0x6358, 0x635B, 0x6365, 0x6366, 0x636C, 
    0x636D, 0x6371, 0x6374, 0x6375},
    {0x6378, 0x637C, 0x637D, 0x637F, 0x6382, 0x6384, 0x6387, 0x638A, 0x6390, 
    0x6394, 0x6395, 0x6399, 0x639A, 0x639E, 0x63A4, 0x63A6, 0x63AD, 0x63AE, 
    0x63AF, 0x63BD, 0x63C1, 0x63C5, 0x63C8, 0x63CE, 0x63D1, 0x63D3, 0x63D4, 
    0x63D5, 0x63DC, 0x63E0, 0x63E5, 0x63EA, 0x63EC, 0x63F2, 0x63F3, 0x63F5, 
    0x63F8, 0x63F9, 0x6409, 0x640A, 0x6410, 0x6412, 0x6414, 0x6418, 0x641E, 
    0x6420, 0x6422, 0x6424, 0x6425, 0x6429, 0x642A, 0x642F, 0x6430, 0x6435, 
    0x643D, 0x643F, 0x644B, 0x644F, 0x6451, 0x6452, 0x6453, 0x6454, 0x645A, 
    0x645B, 0x645C, 0x645D, 0x645F, 0x6460, 0x6461, 0x6463, 0x646D, 0x6473, 
    0x6474, 0x647B, 0x647D, 0x6485, 0x6487, 0x648F, 0x6490, 0x6491, 0x6498, 
    0x6499, 0x649B, 0x649D, 0x649F, 0x64A1, 0x64A3, 0x64A6, 0x64A8, 0x64AC, 
    0x64B3, 0x64BD, 0x64BE, 0x64BF},
    {0x64C4, 0x64C9, 0x64CA, 0x64CB, 0x64CC, 0x64CE, 0x64D0, 0x64D1, 0x64D5, 
    0x64D7, 0x64E4, 0x64E5, 0x64E9, 0x64EA, 0x64ED, 0x64F0, 0x64F5, 0x64F7, 
    0x64FB, 0x64FF, 0x6501, 0x6504, 0x6508, 0x6509, 0x650A, 0x650F, 0x6513, 
    0x6514, 0x6516, 0x6519, 0x651B, 0x651E, 0x651F, 0x6522, 0x6526, 0x6529, 
    0x652E, 0x6531, 0x653A, 0x653C, 0x653D, 0x6543, 0x6547, 0x6549, 0x6550, 
    0x6552, 0x6554, 0x655F, 0x6560, 0x6567, 0x656B, 0x657A, 0x657D, 0x6581, 
    0x6585, 0x658A, 0x6592, 0x6595, 0x6598, 0x659D, 0x65A0, 0x65A3, 0x65A6, 
    0x65AE, 0x65B2, 0x65B3, 0x65B4, 0x65BF, 0x65C2, 0x65C8, 0x65C9, 0x65CE, 
    0x65D0, 0x65D4, 0x65D6, 0x65D8, 0x65DF, 0x65F0, 0x65F2, 0x65F4, 0x65F5, 
    0x65F9, 0x65FE, 0x65FF, 0x6600, 0x6604, 0x6608, 0x6609, 0x660D, 0x6611, 
    0x6612, 0x6615, 0x6616, 0x661D},
    {0x661E, 0x6621, 0x6622, 0x6623, 0x6624, 0x6626, 0x6629, 0x662A, 0x662B, 
    0x662C, 0x662E, 0x6630, 0x6631, 0x6633, 0x6639, 0x6637, 0x6640, 0x6645, 
    0x6646, 0x664A, 0x664C, 0x6651, 0x664E, 0x6657, 0x6658, 0x6659, 0x665B, 
    0x665C, 0x6660, 0x6661, 0x66FB, 0x666A, 0x666B, 0x666C, 0x667E, 0x6673, 
    0x6675, 0x667F, 0x6677, 0x6678, 0x6679, 0x667B, 0x6680, 0x667C, 0x668B, 
    0x668C, 0x668D, 0x6690, 0x6692, 0x6699, 0x669A, 0x669B, 0x669C, 0x669F, 
    0x66A0, 0x66A4, 0x66AD, 0x66B1, 0x66B2, 0x66B5, 0x66BB, 0x66BF, 0x66C0, 
    0x66C2, 0x66C3, 0x66C8, 0x66CC, 0x66CE, 0x66CF, 0x66D4, 0x66DB, 0x66DF, 
    0x66E8, 0x66EB, 0x66EC, 0x66EE, 0x66FA, 0x6705, 0x6707, 0x670E, 0x6713, 
    0x6719, 0x671C, 0x6720, 0x6722, 0x6733, 0x673E, 0x6745, 0x6747, 0x6748, 
    0x674C, 0x6754, 0x6755, 0x675D},
    {0x6766, 0x676C, 0x676E, 0x6774, 0x6776, 0x677B, 0x6781, 0x6784, 0x678E, 
    0x678F, 0x6791, 0x6793, 0x6796, 0x6798, 0x6799, 0x679B, 0x67B0, 0x67B1, 
    0x67B2, 0x67B5, 0x67BB, 0x67BC, 0x67BD, 0x67F9, 0x67C0, 0x67C2, 0x67C3, 
    0x67C5, 0x67C8, 0x67C9, 0x67D2, 0x67D7, 0x67D9, 0x67DC, 0x67E1, 0x67E6, 
    0x67F0, 0x67F2, 0x67F6, 0x67F7, 0x6852, 0x6814, 0x6819, 0x681D, 0x681F, 
    0x6828, 0x6827, 0x682C, 0x682D, 0x682F, 0x6830, 0x6831, 0x6833, 0x683B, 
    0x683F, 0x6844, 0x6845, 0x684A, 0x684C, 0x6855, 0x6857, 0x6858, 0x685B, 
    0x686B, 0x686E, 0x686F, 0x6870, 0x6871, 0x6872, 0x6875, 0x6879, 0x687A, 
    0x687B, 0x687C, 0x6882, 0x6884, 0x6886, 0x6888, 0x6896, 0x6898, 0x689A, 
    0x689C, 0x68A1, 0x68A3, 0x68A5, 0x68A9, 0x68AA, 0x68AE, 0x68B2, 0x68BB, 
    0x68C5, 0x68C8, 0x68CC, 0x68CF},
    {0x68D0, 0x68D1, 0x68D3, 0x68D6, 0x68D9, 0x68DC, 0x68DD, 0x68E5, 0x68E8, 
    0x68EA, 0x68EB, 0x68EC, 0x68ED, 0x68F0, 0x68F1, 0x68F5, 0x68F6, 0x68FB, 
    0x68FC, 0x68FD, 0x6906, 0x6909, 0x690A, 0x6910, 0x6911, 0x6913, 0x6916, 
    0x6917, 0x6931, 0x6933, 0x6935, 0x6938, 0x693B, 0x6942, 0x6945, 0x6949, 
    0x694E, 0x6957, 0x695B, 0x6963, 0x6964, 0x6965, 0x6966, 0x6968, 0x6969, 
    0x696C, 0x6970, 0x6971, 0x6972, 0x697A, 0x697B, 0x697F, 0x6980, 0x698D, 
    0x6992, 0x6996, 0x6998, 0x69A1, 0x69A5, 0x69A6, 0x69A8, 0x69AB, 0x69AD, 
    0x69AF, 0x69B7, 0x69B8, 0x69BA, 0x69BC, 0x69C5, 0x69C8, 0x69D1, 0x69D6, 
    0x69D7, 0x69E2, 0x69E5, 0x69EE, 0x69EF, 0x69F1, 0x69F3, 0x69F5, 0x69FE, 
    0x6A00, 0x6A01, 0x6A03, 0x6A0F, 0x6A11, 0x6A15, 0x6A1A, 0x6A1D, 0x6A20, 
    0x6A24, 0x6A28, 0x6A30, 0x6A32},
    {0x6A34, 0x6A37, 0x6A3B, 0x6A3E, 0x6A3F, 0x6A45, 0x6A46, 0x6A49, 0x6A4A, 
    0x6A4E, 0x6A50, 0x6A51, 0x6A52, 0x6A55, 0x6A56, 0x6A5B, 0x6A64, 0x6A67, 
    0x6A6A, 0x6A71, 0x6A73, 0x6A7E, 0x6A81, 0x6A83, 0x6A86, 0x6A87, 0x6A89, 
    0x6A8B, 0x6A91, 0x6A9B, 0x6A9D, 0x6A9E, 0x6A9F, 0x6AA5, 0x6AAB, 0x6AAF, 
    0x6AB0, 0x6AB1, 0x6AB4, 0x6ABD, 0x6ABE, 0x6ABF, 0x6AC6, 0x6AC9, 0x6AC8, 
    0x6ACC, 0x6AD0, 0x6AD4, 0x6AD5, 0x6AD6, 0x6ADC, 0x6ADD, 0x6AE4, 0x6AE7, 
    0x6AEC, 0x6AF0, 0x6AF1, 0x6AF2, 0x6AFC, 0x6AFD, 0x6B02, 0x6B03, 0x6B06, 
    0x6B07, 0x6B09, 0x6B0F, 0x6B10, 0x6B11, 0x6B17, 0x6B1B, 0x6B1E, 0x6B24, 
    0x6B28, 0x6B2B, 0x6B2C, 0x6B2F, 0x6B35, 0x6B36, 0x6B3B, 0x6B3F, 0x6B46, 
    0x6B4A, 0x6B4D, 0x6B52, 0x6B56, 0x6B58, 0x6B5D, 0x6B60, 0x6B67, 0x6B6B, 
    0x6B6E, 0x6B70, 0x6B75, 0x6B7D},
    {0x6B7E, 0x6B82, 0x6B85, 0x6B97, 0x6B9B, 0x6B9F, 0x6BA0, 0x6BA2, 0x6BA3, 
    0x6BA8, 0x6BA9, 0x6BAC, 0x6BAD, 0x6BAE, 0x6BB0, 0x6BB8, 0x6BB9, 0x6BBD, 
    0x6BBE, 0x6BC3, 0x6BC4, 0x6BC9, 0x6BCC, 0x6BD6, 0x6BDA, 0x6BE1, 0x6BE3, 
    0x6BE6, 0x6BE7, 0x6BEE, 0x6BF1, 0x6BF7, 0x6BF9, 0x6BFF, 0x6C02, 0x6C04, 
    0x6C05, 0x6C09, 0x6C0D, 0x6C0E, 0x6C10, 0x6C12, 0x6C19, 0x6C1F, 0x6C26, 
    0x6C27, 0x6C28, 0x6C2C, 0x6C2E, 0x6C33, 0x6C35, 0x6C36, 0x6C3A, 0x6C3B, 
    0x6C3F, 0x6C4A, 0x6C4B, 0x6C4D, 0x6C4F, 0x6C52, 0x6C54, 0x6C59, 0x6C5B, 
    0x6C5C, 0x6C6B, 0x6C6D, 0x6C6F, 0x6C74, 0x6C76, 0x6C78, 0x6C79, 0x6C7B, 
    0x6C85, 0x6C86, 0x6C87, 0x6C89, 0x6C94, 0x6C95, 0x6C97, 0x6C98, 0x6C9C, 
    0x6C9F, 0x6CB0, 0x6CB2, 0x6CB4, 0x6CC2, 0x6CC6, 0x6CCD, 0x6CCF, 0x6CD0, 
    0x6CD1, 0x6CD2, 0x6CD4, 0x6CD6},
    {0x6CDA, 0x6CDC, 0x6CE0, 0x6CE7, 0x6CE9, 0x6CEB, 0x6CEC, 0x6CEE, 0x6CF2, 
    0x6CF4, 0x6D04, 0x6D07, 0x6D0A, 0x6D0E, 0x6D0F, 0x6D11, 0x6D13, 0x6D1A, 
    0x6D26, 0x6D27, 0x6D28, 0x6C67, 0x6D2E, 0x6D2F, 0x6D31, 0x6D39, 0x6D3C, 
    0x6D3F, 0x6D57, 0x6D5E, 0x6D5F, 0x6D61, 0x6D65, 0x6D67, 0x6D6F, 0x6D70, 
    0x6D7C, 0x6D82, 0x6D87, 0x6D91, 0x6D92, 0x6D94, 0x6D96, 0x6D97, 0x6D98, 
    0x6DAA, 0x6DAC, 0x6DB4, 0x6DB7, 0x6DB9, 0x6DBD, 0x6DBF, 0x6DC4, 0x6DC8, 
    0x6DCA, 0x6DCE, 0x6DCF, 0x6DD6, 0x6DDB, 0x6DDD, 0x6DDF, 0x6DE0, 0x6DE2, 
    0x6DE5, 0x6DE9, 0x6DEF, 0x6DF0, 0x6DF4, 0x6DF6, 0x6DFC, 0x6E00, 0x6E04, 
    0x6E1E, 0x6E22, 0x6E27, 0x6E32, 0x6E36, 0x6E39, 0x6E3B, 0x6E3C, 0x6E44, 
    0x6E45, 0x6E48, 0x6E49, 0x6E4B, 0x6E4F, 0x6E51, 0x6E52, 0x6E53, 0x6E54, 
    0x6E57, 0x6E5C, 0x6E5D, 0x6E5E},
    {0x6E62, 0x6E63, 0x6E68, 0x6E73, 0x6E7B, 0x6E7D, 0x6E8D, 0x6E93, 0x6E99, 
    0x6EA0, 0x6EA7, 0x6EAD, 0x6EAE, 0x6EB1, 0x6EB3, 0x6EBB, 0x6EBF, 0x6EC0, 
    0x6EC1, 0x6EC3, 0x6EC7, 0x6EC8, 0x6ECA, 0x6ECD, 0x6ECE, 0x6ECF, 0x6EEB, 
    0x6EED, 0x6EEE, 0x6EF9, 0x6EFB, 0x6EFD, 0x6F04, 0x6F08, 0x6F0A, 0x6F0C, 
    0x6F0D, 0x6F16, 0x6F18, 0x6F1A, 0x6F1B, 0x6F26, 0x6F29, 0x6F2A, 0x6F2F, 
    0x6F30, 0x6F33, 0x6F36, 0x6F3B, 0x6F3C, 0x6F2D, 0x6F4F, 0x6F51, 0x6F52, 
    0x6F53, 0x6F57, 0x6F59, 0x6F5A, 0x6F5D, 0x6F5E, 0x6F61, 0x6F62, 0x6F68, 
    0x6F6C, 0x6F7D, 0x6F7E, 0x6F83, 0x6F87, 0x6F88, 0x6F8B, 0x6F8C, 0x6F8D, 
    0x6F90, 0x6F92, 0x6F93, 0x6F94, 0x6F96, 0x6F9A, 0x6F9F, 0x6FA0, 0x6FA5, 
    0x6FA6, 0x6FA7, 0x6FA8, 0x6FAE, 0x6FAF, 0x6FB0, 0x6FB5, 0x6FB6, 0x6FBC, 
    0x6FC5, 0x6FC7, 0x6FC8, 0x6FCA},
    {0x6FDA, 0x6FDE, 0x6FE8, 0x6FE9, 0x6FF0, 0x6FF5, 0x6FF9, 0x6FFC, 0x6FFD, 
    0x7000, 0x7005, 0x7006, 0x7007, 0x700D, 0x7017, 0x7020, 0x7023, 0x702F, 
    0x7034, 0x7037, 0x7039, 0x703C, 0x7043, 0x7044, 0x7048, 0x7049, 0x704A, 
    0x704B, 0x7054, 0x7055, 0x705D, 0x705E, 0x704E, 0x7064, 0x7065, 0x706C, 
    0x706E, 0x7075, 0x7076, 0x707E, 0x7081, 0x7085, 0x7086, 0x7094, 0x7095, 
    0x7096, 0x7097, 0x7098, 0x709B, 0x70A4, 0x70AB, 0x70B0, 0x70B1, 0x70B4, 
    0x70B7, 0x70CA, 0x70D1, 0x70D3, 0x70D4, 0x70D5, 0x70D6, 0x70D8, 0x70DC, 
    0x70E4, 0x70FA, 0x7103, 0x7104, 0x7105, 0x7106, 0x7107, 0x710B, 0x710C, 
    0x710F, 0x711E, 0x7120, 0x712B, 0x712D, 0x712F, 0x7130, 0x7131, 0x7138, 
    0x7141, 0x7145, 0x7146, 0x7147, 0x714A, 0x714B, 0x7150, 0x7152, 0x7157, 
    0x715A, 0x715C, 0x715E, 0x7160},
    {0x7168, 0x7179, 0x7180, 0x7185, 0x7187, 0x718C, 0x7192, 0x719A, 0x719B, 
    0x71A0, 0x71A2, 0x71AF, 0x71B0, 0x71B2, 0x71B3, 0x71BA, 0x71BF, 0x71C0, 
    0x71C1, 0x71C4, 0x71CB, 0x71CC, 0x71D3, 0x71D6, 0x71D9, 0x71DA, 0x71DC, 
    0x71F8, 0x71FE, 0x7200, 0x7207, 0x7208, 0x7209, 0x7213, 0x7217, 0x721A, 
    0x721D, 0x721F, 0x7224, 0x722B, 0x722F, 0x7234, 0x7238, 0x7239, 0x7241, 
    0x7242, 0x7243, 0x7245, 0x724E, 0x724F, 0x7250, 0x7253, 0x7255, 0x7256, 
    0x725A, 0x725C, 0x725E, 0x7260, 0x7263, 0x7268, 0x726B, 0x726E, 0x726F, 
    0x7271, 0x7277, 0x7278, 0x727B, 0x727C, 0x727F, 0x7284, 0x7289, 0x728D, 
    0x728E, 0x7293, 0x729B, 0x72A8, 0x72AD, 0x72AE, 0x72B1, 0x72B4, 0x72BE, 
    0x72C1, 0x72C7, 0x72C9, 0x72CC, 0x72D5, 0x72D6, 0x72D8, 0x72DF, 0x72E5, 
    0x72F3, 0x72F4, 0x72FA, 0x72FB},
    {0x72FE, 0x7302, 0x7304, 0x7305, 0x7307, 0x730B, 0x730D, 0x7312, 0x7313, 
    0x7318, 0x7319, 0x731E, 0x7322, 0x7324, 0x7327, 0x7328, 0x732C, 0x7331, 
    0x7332, 0x7335, 0x733A, 0x733B, 0x733D, 0x7343, 0x734D, 0x7350, 0x7352, 
    0x7356, 0x7358, 0x735D, 0x735E, 0x735F, 0x7360, 0x7366, 0x7367, 0x7369, 
    0x736B, 0x736C, 0x736E, 0x736F, 0x7371, 0x7377, 0x7379, 0x737C, 0x7380, 
    0x7381, 0x7383, 0x7385, 0x7386, 0x738E, 0x7390, 0x7393, 0x7395, 0x7397, 
    0x7398, 0x739C, 0x739E, 0x739F, 0x73A0, 0x73A2, 0x73A5, 0x73A6, 0x73AA, 
    0x73AB, 0x73AD, 0x73B5, 0x73B7, 0x73B9, 0x73BC, 0x73BD, 0x73BF, 0x73C5, 
    0x73C6, 0x73C9, 0x73CB, 0x73CC, 0x73CF, 0x73D2, 0x73D3, 0x73D6, 0x73D9, 
    0x73DD, 0x73E1, 0x73E3, 0x73E6, 0x73E7, 0x73E9, 0x73F4, 0x73F5, 0x73F7, 
    0x73F9, 0x73FA, 0x73FB, 0x73FD},
    {0x73FF, 0x7400, 0x7401, 0x7404, 0x7407, 0x740A, 0x7411, 0x741A, 0x741B, 
    0x7424, 0x7426, 0x7428, 0x7429, 0x742A, 0x742B, 0x742C, 0x742D, 0x742E, 
    0x742F, 0x7430, 0x7431, 0x7439, 0x7440, 0x7443, 0x7444, 0x7446, 0x7447, 
    0x744B, 0x744D, 0x7451, 0x7452, 0x7457, 0x745D, 0x7462, 0x7466, 0x7467, 
    0x7468, 0x746B, 0x746D, 0x746E, 0x7471, 0x7472, 0x7480, 0x7481, 0x7485, 
    0x7486, 0x7487, 0x7489, 0x748F, 0x7490, 0x7491, 0x7492, 0x7498, 0x7499, 
    0x749A, 0x749C, 0x749F, 0x74A0, 0x74A1, 0x74A3, 0x74A6, 0x74A8, 0x74A9, 
    0x74AA, 0x74AB, 0x74AE, 0x74AF, 0x74B1, 0x74B2, 0x74B5, 0x74B9, 0x74BB, 
    0x74BF, 0x74C8, 0x74C9, 0x74CC, 0x74D0, 0x74D3, 0x74D8, 0x74DA, 0x74DB, 
    0x74DE, 0x74DF, 0x74E4, 0x74E8, 0x74EA, 0x74EB, 0x74EF, 0x74F4, 0x74FA, 
    0x74FB, 0x74FC, 0x74FF, 0x7506},
    {0x7512, 0x7516, 0x7517, 0x7520, 0x7521, 0x7524, 0x7527, 0x7529, 0x752A, 
    0x752F, 0x7536, 0x7539, 0x753D, 0x753E, 0x753F, 0x7540, 0x7543, 0x7547, 
    0x7548, 0x754E, 0x7550, 0x7552, 0x7557, 0x755E, 0x755F, 0x7561, 0x756F, 
    0x7571, 0x7579, 0x757A, 0x757B, 0x757C, 0x757D, 0x757E, 0x7581, 0x7585, 
    0x7590, 0x7592, 0x7593, 0x7595, 0x7599, 0x759C, 0x75A2, 0x75A4, 0x75B4, 
    0x75BA, 0x75BF, 0x75C0, 0x75C1, 0x75C4, 0x75C6, 0x75CC, 0x75CE, 0x75CF, 
    0x75D7, 0x75DC, 0x75DF, 0x75E0, 0x75E1, 0x75E4, 0x75E7, 0x75EC, 0x75EE, 
    0x75EF, 0x75F1, 0x75F9, 0x7600, 0x7602, 0x7603, 0x7604, 0x7607, 0x7608, 
    0x760A, 0x760C, 0x760F, 0x7612, 0x7613, 0x7615, 0x7616, 0x7619, 0x761B, 
    0x761C, 0x761D, 0x761E, 0x7623, 0x7625, 0x7626, 0x7629, 0x762D, 0x7632, 
    0x7633, 0x7635, 0x7638, 0x7639},
    {0x763A, 0x763C, 0x764A, 0x7640, 0x7641, 0x7643, 0x7644, 0x7645, 0x7649, 
    0x764B, 0x7655, 0x7659, 0x765F, 0x7664, 0x7665, 0x766D, 0x766E, 0x766F, 
    0x7671, 0x7674, 0x7681, 0x7685, 0x768C, 0x768D, 0x7695, 0x769B, 0x769C, 
    0x769D, 0x769F, 0x76A0, 0x76A2, 0x76A3, 0x76A4, 0x76A5, 0x76A6, 0x76A7, 
    0x76A8, 0x76AA, 0x76AD, 0x76BD, 0x76C1, 0x76C5, 0x76C9, 0x76CB, 0x76CC, 
    0x76CE, 0x76D4, 0x76D9, 0x76E0, 0x76E6, 0x76E8, 0x76EC, 0x76F0, 0x76F1, 
    0x76F6, 0x76F9, 0x76FC, 0x7700, 0x7706, 0x770A, 0x770E, 0x7712, 0x7714, 
    0x7715, 0x7717, 0x7719, 0x771A, 0x771C, 0x7722, 0x7728, 0x772D, 0x772E, 
    0x772F, 0x7734, 0x7735, 0x7736, 0x7739, 0x773D, 0x773E, 0x7742, 0x7745, 
    0x7746, 0x774A, 0x774D, 0x774E, 0x774F, 0x7752, 0x7756, 0x7757, 0x775C, 
    0x775E, 0x775F, 0x7760, 0x7762},
    {0x7764, 0x7767, 0x776A, 0x776C, 0x7770, 0x7772, 0x7773, 0x7774, 0x777A, 
    0x777D, 0x7780, 0x7784, 0x778C, 0x778D, 0x7794, 0x7795, 0x7796, 0x779A, 
    0x779F, 0x77A2, 0x77A7, 0x77AA, 0x77AE, 0x77AF, 0x77B1, 0x77B5, 0x77BE, 
    0x77C3, 0x77C9, 0x77D1, 0x77D2, 0x77D5, 0x77D9, 0x77DE, 0x77DF, 0x77E0, 
    0x77E4, 0x77E6, 0x77EA, 0x77EC, 0x77F0, 0x77F1, 0x77F4, 0x77F8, 0x77FB, 
    0x7805, 0x7806, 0x7809, 0x780D, 0x780E, 0x7811, 0x781D, 0x7821, 0x7822, 
    0x7823, 0x782D, 0x782E, 0x7830, 0x7835, 0x7837, 0x7843, 0x7844, 0x7847, 
    0x7848, 0x784C, 0x784E, 0x7852, 0x785C, 0x785E, 0x7860, 0x7861, 0x7863, 
    0x7864, 0x7868, 0x786A, 0x786E, 0x787A, 0x787E, 0x788A, 0x788F, 0x7894, 
    0x7898, 0x78A1, 0x789D, 0x789E, 0x789F, 0x78A4, 0x78A8, 0x78AC, 0x78AD, 
    0x78B0, 0x78B1, 0x78B2, 0x78B3},
    {0x78BB, 0x78BD, 0x78BF, 0x78C7, 0x78C8, 0x78C9, 0x78CC, 0x78CE, 0x78D2, 
    0x78D3, 0x78D5, 0x78D6, 0x78E4, 0x78DB, 0x78DF, 0x78E0, 0x78E1, 0x78E6, 
    0x78EA, 0x78F2, 0x78F3, 0x7900, 0x78F6, 0x78F7, 0x78FA, 0x78FB, 0x78FF, 
    0x7906, 0x790C, 0x7910, 0x791A, 0x791C, 0x791E, 0x791F, 0x7920, 0x7925, 
    0x7927, 0x7929, 0x792D, 0x7931, 0x7934, 0x7935, 0x793B, 0x793D, 0x793F, 
    0x7944, 0x7945, 0x7946, 0x794A, 0x794B, 0x794F, 0x7951, 0x7954, 0x7958, 
    0x795B, 0x795C, 0x7967, 0x7969, 0x796B, 0x7972, 0x7979, 0x797B, 0x797C, 
    0x797E, 0x798B, 0x798C, 0x7991, 0x7993, 0x7994, 0x7995, 0x7996, 0x7998, 
    0x799B, 0x799C, 0x79A1, 0x79A8, 0x79A9, 0x79AB, 0x79AF, 0x79B1, 0x79B4, 
    0x79B8, 0x79BB, 0x79C2, 0x79C4, 0x79C7, 0x79C8, 0x79CA, 0x79CF, 0x79D4, 
    0x79D6, 0x79DA, 0x79DD, 0x79DE},
    {0x79E0, 0x79E2, 0x79E5, 0x79EA, 0x79EB, 0x79ED, 0x79F1, 0x79F8, 0x79FC, 
    0x7A02, 0x7A03, 0x7A07, 0x7A09, 0x7A0A, 0x7A0C, 0x7A11, 0x7A15, 0x7A1B, 
    0x7A1E, 0x7A21, 0x7A27, 0x7A2B, 0x7A2D, 0x7A2F, 0x7A30, 0x7A34, 0x7A35, 
    0x7A38, 0x7A39, 0x7A3A, 0x7A44, 0x7A45, 0x7A47, 0x7A48, 0x7A4C, 0x7A55, 
    0x7A56, 0x7A59, 0x7A5C, 0x7A5D, 0x7A5F, 0x7A60, 0x7A65, 0x7A67, 0x7A6A, 
    0x7A6D, 0x7A75, 0x7A78, 0x7A7E, 0x7A80, 0x7A82, 0x7A85, 0x7A86, 0x7A8A, 
    0x7A8B, 0x7A90, 0x7A91, 0x7A94, 0x7A9E, 0x7AA0, 0x7AA3, 0x7AAC, 0x7AB3, 
    0x7AB5, 0x7AB9, 0x7ABB, 0x7ABC, 0x7AC6, 0x7AC9, 0x7ACC, 0x7ACE, 0x7AD1, 
    0x7ADB, 0x7AE8, 0x7AE9, 0x7AEB, 0x7AEC, 0x7AF1, 0x7AF4, 0x7AFB, 0x7AFD, 
    0x7AFE, 0x7B07, 0x7B14, 0x7B1F, 0x7B23, 0x7B27, 0x7B29, 0x7B2A, 0x7B2B, 
    0x7B2D, 0x7B2E, 0x7B2F, 0x7B30},
    {0x7B31, 0x7B34, 0x7B3D, 0x7B3F, 0x7B40, 0x7B41, 0x7B47, 0x7B4E, 0x7B55, 
    0x7B60, 0x7B64, 0x7B66, 0x7B69, 0x7B6A, 0x7B6D, 0x7B6F, 0x7B72, 0x7B73, 
    0x7B77, 0x7B84, 0x7B89, 0x7B8E, 0x7B90, 0x7B91, 0x7B96, 0x7B9B, 0x7B9E, 
    0x7BA0, 0x7BA5, 0x7BAC, 0x7BAF, 0x7BB0, 0x7BB2, 0x7BB5, 0x7BB6, 0x7BBA, 
    0x7BBB, 0x7BBC, 0x7BBD, 0x7BC2, 0x7BC5, 0x7BC8, 0x7BCA, 0x7BD4, 0x7BD6, 
    0x7BD7, 0x7BD9, 0x7BDA, 0x7BDB, 0x7BE8, 0x7BEA, 0x7BF2, 0x7BF4, 0x7BF5, 
    0x7BF8, 0x7BF9, 0x7BFA, 0x7BFC, 0x7BFE, 0x7C01, 0x7C02, 0x7C03, 0x7C04, 
    0x7C06, 0x7C09, 0x7C0B, 0x7C0C, 0x7C0E, 0x7C0F, 0x7C19, 0x7C1B, 0x7C20, 
    0x7C25, 0x7C26, 0x7C28, 0x7C2C, 0x7C31, 0x7C33, 0x7C34, 0x7C36, 0x7C39, 
    0x7C3A, 0x7C46, 0x7C4A, 0x7C55, 0x7C51, 0x7C52, 0x7C53, 0x7C59, 0x7C5A, 
    0x7C5B, 0x7C5C, 0x7C5D, 0x7C5E},
    {0x7C61, 0x7C63, 0x7C67, 0x7C69, 0x7C6D, 0x7C6E, 0x7C70, 0x7C72, 0x7C79, 
    0x7C7C, 0x7C7D, 0x7C86, 0x7C87, 0x7C8F, 0x7C94, 0x7C9E, 0x7CA0, 0x7CA6, 
    0x7CB0, 0x7CB6, 0x7CB7, 0x7CBA, 0x7CBB, 0x7CBC, 0x7CBF, 0x7CC4, 0x7CC7, 
    0x7CC8, 0x7CC9, 0x7CCD, 0x7CCF, 0x7CD3, 0x7CD4, 0x7CD5, 0x7CD7, 0x7CD9, 
    0x7CDA, 0x7CDD, 0x7CE6, 0x7CE9, 0x7CEB, 0x7CF5, 0x7D03, 0x7D07, 0x7D08, 
    0x7D09, 0x7D0F, 0x7D11, 0x7D12, 0x7D13, 0x7D16, 0x7D1D, 0x7D1E, 0x7D23, 
    0x7D26, 0x7D2A, 0x7D2D, 0x7D31, 0x7D3C, 0x7D3D, 0x7D3E, 0x7D40, 0x7D41, 
    0x7D47, 0x7D48, 0x7D4D, 0x7D51, 0x7D53, 0x7D57, 0x7D59, 0x7D5A, 0x7D5C, 
    0x7D5D, 0x7D65, 0x7D67, 0x7D6A, 0x7D70, 0x7D78, 0x7D7A, 0x7D7B, 0x7D7F, 
    0x7D81, 0x7D82, 0x7D83, 0x7D85, 0x7D86, 0x7D88, 0x7D8B, 0x7D8C, 0x7D8D, 
    0x7D91, 0x7D96, 0x7D97, 0x7D9D},
    {0x7D9E, 0x7DA6, 0x7DA7, 0x7DAA, 0x7DB3, 0x7DB6, 0x7DB7, 0x7DB9, 0x7DC2, 
    0x7DC3, 0x7DC4, 0x7DC5, 0x7DC6, 0x7DCC, 0x7DCD, 0x7DCE, 0x7DD7, 0x7DD9, 
    0x7E00, 0x7DE2, 0x7DE5, 0x7DE6, 0x7DEA, 0x7DEB, 0x7DED, 0x7DF1, 0x7DF5, 
    0x7DF6, 0x7DF9, 0x7DFA, 0x7E08, 0x7E10, 0x7E11, 0x7E15, 0x7E17, 0x7E1C, 
    0x7E1D, 0x7E20, 0x7E27, 0x7E28, 0x7E2C, 0x7E2D, 0x7E2F, 0x7E33, 0x7E36, 
    0x7E3F, 0x7E44, 0x7E45, 0x7E47, 0x7E4E, 0x7E50, 0x7E52, 0x7E58, 0x7E5F, 
    0x7E61, 0x7E62, 0x7E65, 0x7E6B, 0x7E6E, 0x7E6F, 0x7E73, 0x7E78, 0x7E7E, 
    0x7E81, 0x7E86, 0x7E87, 0x7E8A, 0x7E8D, 0x7E91, 0x7E95, 0x7E98, 0x7E9A, 
    0x7E9D, 0x7E9E, 0x7F3C, 0x7F3B, 0x7F3D, 0x7F3E, 0x7F3F, 0x7F43, 0x7F44, 
    0x7F47, 0x7F4F, 0x7F52, 0x7F53, 0x7F5B, 0x7F5C, 0x7F5D, 0x7F61, 0x7F63, 
    0x7F64, 0x7F65, 0x7F66, 0x7F6D},
    {0x7F71, 0x7F7D, 0x7F7E, 0x7F7F, 0x7F80, 0x7F8B, 0x7F8D, 0x7F8F, 0x7F90, 
    0x7F91, 0x7F96, 0x7F97, 0x7F9C, 0x7FA1, 0x7FA2, 0x7FA6, 0x7FAA, 0x7FAD, 
    0x7FB4, 0x7FBC, 0x7FBF, 0x7FC0, 0x7FC3, 0x7FC8, 0x7FCE, 0x7FCF, 0x7FDB, 
    0x7FDF, 0x7FE3, 0x7FE5, 0x7FE8, 0x7FEC, 0x7FEE, 0x7FEF, 0x7FF2, 0x7FFA, 
    0x7FFD, 0x7FFE, 0x7FFF, 0x8007, 0x8008, 0x800A, 0x800D, 0x800E, 0x800F, 
    0x8011, 0x8013, 0x8014, 0x8016, 0x801D, 0x801E, 0x801F, 0x8020, 0x8024, 
    0x8026, 0x802C, 0x802E, 0x8030, 0x8034, 0x8035, 0x8037, 0x8039, 0x803A, 
    0x803C, 0x803E, 0x8040, 0x8044, 0x8060, 0x8064, 0x8066, 0x806D, 0x8071, 
    0x8075, 0x8081, 0x8088, 0x808E, 0x809C, 0x809E, 0x80A6, 0x80A7, 0x80AB, 
    0x80B8, 0x80B9, 0x80C8, 0x80CD, 0x80CF, 0x80D2, 0x80D4, 0x80D5, 0x80D7, 
    0x80D8, 0x80E0, 0x80ED, 0x80EE},
    {0x80F0, 0x80F2, 0x80F3, 0x80F6, 0x80F9, 0x80FA, 0x80FE, 0x8103, 0x810B, 
    0x8116, 0x8117, 0x8118, 0x811C, 0x811E, 0x8120, 0x8124, 0x8127, 0x812C, 
    0x8130, 0x8135, 0x813A, 0x813C, 0x8145, 0x8147, 0x814A, 0x814C, 0x8152, 
    0x8157, 0x8160, 0x8161, 0x8167, 0x8168, 0x8169, 0x816D, 0x816F, 0x8177, 
    0x8181, 0x8190, 0x8184, 0x8185, 0x8186, 0x818B, 0x818E, 0x8196, 0x8198, 
    0x819B, 0x819E, 0x81A2, 0x81AE, 0x81B2, 0x81B4, 0x81BB, 0x81CB, 0x81C3, 
    0x81C5, 0x81CA, 0x81CE, 0x81CF, 0x81D5, 0x81D7, 0x81DB, 0x81DD, 0x81DE, 
    0x81E1, 0x81E4, 0x81EB, 0x81EC, 0x81F0, 0x81F1, 0x81F2, 0x81F5, 0x81F6, 
    0x81F8, 0x81F9, 0x81FD, 0x81FF, 0x8200, 0x8203, 0x820F, 0x8213, 0x8214, 
    0x8219, 0x821A, 0x821D, 0x8221, 0x8222, 0x8228, 0x8232, 0x8234, 0x823A, 
    0x8243, 0x8244, 0x8245, 0x8246},
    {0x824B, 0x824E, 0x824F, 0x8251, 0x8256, 0x825C, 0x8260, 0x8263, 0x8267, 
    0x826D, 0x8274, 0x827B, 0x827D, 0x827F, 0x8280, 0x8281, 0x8283, 0x8284, 
    0x8287, 0x8289, 0x828A, 0x828E, 0x8291, 0x8294, 0x8296, 0x8298, 0x829A, 
    0x829B, 0x82A0, 0x82A1, 0x82A3, 0x82A4, 0x82A7, 0x82A8, 0x82A9, 0x82AA, 
    0x82AE, 0x82B0, 0x82B2, 0x82B4, 0x82B7, 0x82BA, 0x82BC, 0x82BE, 0x82BF, 
    0x82C6, 0x82D0, 0x82D5, 0x82DA, 0x82E0, 0x82E2, 0x82E4, 0x82E8, 0x82EA, 
    0x82ED, 0x82EF, 0x82F6, 0x82F7, 0x82FD, 0x82FE, 0x8300, 0x8301, 0x8307, 
    0x8308, 0x830A, 0x830B, 0x8354, 0x831B, 0x831D, 0x831E, 0x831F, 0x8321, 
    0x8322, 0x832C, 0x832D, 0x832E, 0x8330, 0x8333, 0x8337, 0x833A, 0x833C, 
    0x833D, 0x8342, 0x8343, 0x8344, 0x8347, 0x834D, 0x834E, 0x8351, 0x8355, 
    0x8356, 0x8357, 0x8370, 0x8378},
    {0x837D, 0x837F, 0x8380, 0x8382, 0x8384, 0x8386, 0x838D, 0x8392, 0x8394, 
    0x8395, 0x8398, 0x8399, 0x839B, 0x839C, 0x839D, 0x83A6, 0x83A7, 0x83A9, 
    0x83AC, 0x83BE, 0x83BF, 0x83C0, 0x83C7, 0x83C9, 0x83CF, 0x83D0, 0x83D1, 
    0x83D4, 0x83DD, 0x8353, 0x83E8, 0x83EA, 0x83F6, 0x83F8, 0x83F9, 0x83FC, 
    0x8401, 0x8406, 0x840A, 0x840F, 0x8411, 0x8415, 0x8419, 0x83AD, 0x842F, 
    0x8439, 0x8445, 0x8447, 0x8448, 0x844A, 0x844D, 0x844F, 0x8451, 0x8452, 
    0x8456, 0x8458, 0x8459, 0x845A, 0x845C, 0x8460, 0x8464, 0x8465, 0x8467, 
    0x846A, 0x8470, 0x8473, 0x8474, 0x8476, 0x8478, 0x847C, 0x847D, 0x8481, 
    0x8485, 0x8492, 0x8493, 0x8495, 0x849E, 0x84A6, 0x84A8, 0x84A9, 0x84AA, 
    0x84AF, 0x84B1, 0x84B4, 0x84BA, 0x84BD, 0x84BE, 0x84C0, 0x84C2, 0x84C7, 
    0x84C8, 0x84CC, 0x84CF, 0x84D3},
    {0x84DC, 0x84E7, 0x84EA, 0x84EF, 0x84F0, 0x84F1, 0x84F2, 0x84F7, 0x8532, 
    0x84FA, 0x84FB, 0x84FD, 0x8502, 0x8503, 0x8507, 0x850C, 0x850E, 0x8510, 
    0x851C, 0x851E, 0x8522, 0x8523, 0x8524, 0x8525, 0x8527, 0x852A, 0x852B, 
    0x852F, 0x8533, 0x8534, 0x8536, 0x853F, 0x8546, 0x854F, 0x8550, 0x8551, 
    0x8552, 0x8553, 0x8556, 0x8559, 0x855C, 0x855D, 0x855E, 0x855F, 0x8560, 
    0x8561, 0x8562, 0x8564, 0x856B, 0x856F, 0x8579, 0x857A, 0x857B, 0x857D, 
    0x857F, 0x8581, 0x8585, 0x8586, 0x8589, 0x858B, 0x858C, 0x858F, 0x8593, 
    0x8598, 0x859D, 0x859F, 0x85A0, 0x85A2, 0x85A5, 0x85A7, 0x85B4, 0x85B6, 
    0x85B7, 0x85B8, 0x85BC, 0x85BD, 0x85BE, 0x85BF, 0x85C2, 0x85C7, 0x85CA, 
    0x85CB, 0x85CE, 0x85AD, 0x85D8, 0x85DA, 0x85DF, 0x85E0, 0x85E6, 0x85E8, 
    0x85ED, 0x85F3, 0x85F6, 0x85FC},
    {0x85FF, 0x8600, 0x8604, 0x8605, 0x860D, 0x860E, 0x8610, 0x8611, 0x8612, 
    0x8618, 0x8619, 0x861B, 0x861E, 0x8621, 0x8627, 0x8629, 0x8636, 0x8638, 
    0x863A, 0x863C, 0x863D, 0x8640, 0x8642, 0x8646, 0x8652, 0x8653, 0x8656, 
    0x8657, 0x8658, 0x8659, 0x865D, 0x8660, 0x8661, 0x8662, 0x8663, 0x8664, 
    0x8669, 0x866C, 0x866F, 0x8675, 0x8676, 0x8677, 0x867A, 0x868D, 0x8691, 
    0x8696, 0x8698, 0x869A, 0x869C, 0x86A1, 0x86A6, 0x86A7, 0x86A8, 0x86AD, 
    0x86B1, 0x86B3, 0x86B4, 0x86B5, 0x86B7, 0x86B8, 0x86B9, 0x86BF, 0x86C0, 
    0x86C1, 0x86C3, 0x86C5, 0x86D1, 0x86D2, 0x86D5, 0x86D7, 0x86DA, 0x86DC, 
    0x86E0, 0x86E3, 0x86E5, 0x86E7, 0x8688, 0x86FA, 0x86FC, 0x86FD, 0x8704, 
    0x8705, 0x8707, 0x870B, 0x870E, 0x870F, 0x8710, 0x8713, 0x8714, 0x8719, 
    0x871E, 0x871F, 0x8721, 0x8723},
    {0x8728, 0x872E, 0x872F, 0x8731, 0x8732, 0x8739, 0x873A, 0x873C, 0x873D, 
    0x873E, 0x8740, 0x8743, 0x8745, 0x874D, 0x8758, 0x875D, 0x8761, 0x8764, 
    0x8765, 0x876F, 0x8771, 0x8772, 0x877B, 0x8783, 0x8784, 0x8785, 0x8786, 
    0x8787, 0x8788, 0x8789, 0x878B, 0x878C, 0x8790, 0x8793, 0x8795, 0x8797, 
    0x8798, 0x8799, 0x879E, 0x87A0, 0x87A3, 0x87A7, 0x87AC, 0x87AD, 0x87AE, 
    0x87B1, 0x87B5, 0x87BE, 0x87BF, 0x87C1, 0x87C8, 0x87C9, 0x87CA, 0x87CE, 
    0x87D5, 0x87D6, 0x87D9, 0x87DA, 0x87DC, 0x87DF, 0x87E2, 0x87E3, 0x87E4, 
    0x87EA, 0x87EB, 0x87ED, 0x87F1, 0x87F3, 0x87F8, 0x87FA, 0x87FF, 0x8801, 
    0x8803, 0x8806, 0x8809, 0x880A, 0x880B, 0x8810, 0x8819, 0x8812, 0x8813, 
    0x8814, 0x8818, 0x881A, 0x881B, 0x881C, 0x881E, 0x881F, 0x8828, 0x882D, 
    0x882E, 0x8830, 0x8832, 0x8835},
    {0x883A, 0x883C, 0x8841, 0x8843, 0x8845, 0x8848, 0x8849, 0x884A, 0x884B, 
    0x884E, 0x8851, 0x8855, 0x8856, 0x8858, 0x885A, 0x885C, 0x885F, 0x8860, 
    0x8864, 0x8869, 0x8871, 0x8879, 0x887B, 0x8880, 0x8898, 0x889A, 0x889B, 
    0x889C, 0x889F, 0x88A0, 0x88A8, 0x88AA, 0x88BA, 0x88BD, 0x88BE, 0x88C0, 
    0x88CA, 0x88CB, 0x88CC, 0x88CD, 0x88CE, 0x88D1, 0x88D2, 0x88D3, 0x88DB, 
    0x88DE, 0x88E7, 0x88EF, 0x88F0, 0x88F1, 0x88F5, 0x88F7, 0x8901, 0x8906, 
    0x890D, 0x890E, 0x890F, 0x8915, 0x8916, 0x8918, 0x8919, 0x891A, 0x891C, 
    0x8920, 0x8926, 0x8927, 0x8928, 0x8930, 0x8931, 0x8932, 0x8935, 0x8939, 
    0x893A, 0x893E, 0x8940, 0x8942, 0x8945, 0x8946, 0x8949, 0x894F, 0x8952, 
    0x8957, 0x895A, 0x895B, 0x895C, 0x8961, 0x8962, 0x8963, 0x896B, 0x896E, 
    0x8970, 0x8973, 0x8975, 0x897A},
    {0x897B, 0x897C, 0x897D, 0x8989, 0x898D, 0x8990, 0x8994, 0x8995, 0x899B, 
    0x899C, 0x899F, 0x89A0, 0x89A5, 0x89B0, 0x89B4, 0x89B5, 0x89B6, 0x89B7, 
    0x89BC, 0x89D4, 0x89D5, 0x89D6, 0x89D7, 0x89D8, 0x89E5, 0x89E9, 0x89EB, 
    0x89ED, 0x89F1, 0x89F3, 0x89F6, 0x89F9, 0x89FD, 0x89FF, 0x8A04, 0x8A05, 
    0x8A07, 0x8A0F, 0x8A11, 0x8A12, 0x8A14, 0x8A15, 0x8A1E, 0x8A20, 0x8A22, 
    0x8A24, 0x8A26, 0x8A2B, 0x8A2C, 0x8A2F, 0x8A35, 0x8A37, 0x8A3D, 0x8A3E, 
    0x8A40, 0x8A43, 0x8A45, 0x8A47, 0x8A49, 0x8A4D, 0x8A4E, 0x8A53, 0x8A56, 
    0x8A57, 0x8A58, 0x8A5C, 0x8A5D, 0x8A61, 0x8A65, 0x8A67, 0x8A75, 0x8A76, 
    0x8A77, 0x8A79, 0x8A7A, 0x8A7B, 0x8A7E, 0x8A7F, 0x8A80, 0x8A83, 0x8A86, 
    0x8A8B, 0x8A8F, 0x8A90, 0x8A92, 0x8A96, 0x8A97, 0x8A99, 0x8A9F, 0x8AA7, 
    0x8AA9, 0x8AAE, 0x8AAF, 0x8AB3},
    {0x8AB6, 0x8AB7, 0x8ABB, 0x8ABE, 0x8AC3, 0x8AC6, 0x8AC8, 0x8AC9, 0x8ACA, 
    0x8AD1, 0x8AD3, 0x8AD4, 0x8AD5, 0x8AD7, 0x8ADD, 0x8ADF, 0x8AEC, 0x8AF0, 
    0x8AF4, 0x8AF5, 0x8AF6, 0x8AFC, 0x8AFF, 0x8B05, 0x8B06, 0x8B0B, 0x8B11, 
    0x8B1C, 0x8B1E, 0x8B1F, 0x8B0A, 0x8B2D, 0x8B30, 0x8B37, 0x8B3C, 0x8B42, 
    0x8B43, 0x8B44, 0x8B45, 0x8B46, 0x8B48, 0x8B52, 0x8B53, 0x8B54, 0x8B59, 
    0x8B4D, 0x8B5E, 0x8B63, 0x8B6D, 0x8B76, 0x8B78, 0x8B79, 0x8B7C, 0x8B7E, 
    0x8B81, 0x8B84, 0x8B85, 0x8B8B, 0x8B8D, 0x8B8F, 0x8B94, 0x8B95, 0x8B9C, 
    0x8B9E, 0x8B9F, 0x8C38, 0x8C39, 0x8C3D, 0x8C3E, 0x8C45, 0x8C47, 0x8C49, 
    0x8C4B, 0x8C4F, 0x8C51, 0x8C53, 0x8C54, 0x8C57, 0x8C58, 0x8C5B, 0x8C5D, 
    0x8C59, 0x8C63, 0x8C64, 0x8C66, 0x8C68, 0x8C69, 0x8C6D, 0x8C73, 0x8C75, 
    0x8C76, 0x8C7B, 0x8C7E, 0x8C86},
    {0x8C87, 0x8C8B, 0x8C90, 0x8C92, 0x8C93, 0x8C99, 0x8C9B, 0x8C9C, 0x8CA4, 
    0x8CB9, 0x8CBA, 0x8CC5, 0x8CC6, 0x8CC9, 0x8CCB, 0x8CCF, 0x8CD6, 0x8CD5, 
    0x8CD9, 0x8CDD, 0x8CE1, 0x8CE8, 0x8CEC, 0x8CEF, 0x8CF0, 0x8CF2, 0x8CF5, 
    0x8CF7, 0x8CF8, 0x8CFE, 0x8CFF, 0x8D01, 0x8D03, 0x8D09, 0x8D12, 0x8D17, 
    0x8D1B, 0x8D65, 0x8D69, 0x8D6C, 0x8D6E, 0x8D7F, 0x8D82, 0x8D84, 0x8D88, 
    0x8D8D, 0x8D90, 0x8D91, 0x8D95, 0x8D9E, 0x8D9F, 0x8DA0, 0x8DA6, 0x8DAB, 
    0x8DAC, 0x8DAF, 0x8DB2, 0x8DB5, 0x8DB7, 0x8DB9, 0x8DBB, 0x8DC0, 0x8DC5, 
    0x8DC6, 0x8DC7, 0x8DC8, 0x8DCA, 0x8DCE, 0x8DD1, 0x8DD4, 0x8DD5, 0x8DD7, 
    0x8DD9, 0x8DE4, 0x8DE5, 0x8DE7, 0x8DEC, 0x8DF0, 0x8DBC, 0x8DF1, 0x8DF2, 
    0x8DF4, 0x8DFD, 0x8E01, 0x8E04, 0x8E05, 0x8E06, 0x8E0B, 0x8E11, 0x8E14, 
    0x8E16, 0x8E20, 0x8E21, 0x8E22},
    {0x8E23, 0x8E26, 0x8E27, 0x8E31, 0x8E33, 0x8E36, 0x8E37, 0x8E38, 0x8E39, 
    0x8E3D, 0x8E40, 0x8E41, 0x8E4B, 0x8E4D, 0x8E4E, 0x8E4F, 0x8E54, 0x8E5B, 
    0x8E5C, 0x8E5D, 0x8E5E, 0x8E61, 0x8E62, 0x8E69, 0x8E6C, 0x8E6D, 0x8E6F, 
    0x8E70, 0x8E71, 0x8E79, 0x8E7A, 0x8E7B, 0x8E82, 0x8E83, 0x8E89, 0x8E90, 
    0x8E92, 0x8E95, 0x8E9A, 0x8E9B, 0x8E9D, 0x8E9E, 0x8EA2, 0x8EA7, 0x8EA9, 
    0x8EAD, 0x8EAE, 0x8EB3, 0x8EB5, 0x8EBA, 0x8EBB, 0x8EC0, 0x8EC1, 0x8EC3, 
    0x8EC4, 0x8EC7, 0x8ECF, 0x8ED1, 0x8ED4, 0x8EDC, 0x8EE8, 0x8EEE, 0x8EF0, 
    0x8EF1, 0x8EF7, 0x8EF9, 0x8EFA, 0x8EED, 0x8F00, 0x8F02, 0x8F07, 0x8F08, 
    0x8F0F, 0x8F10, 0x8F16, 0x8F17, 0x8F18, 0x8F1E, 0x8F20, 0x8F21, 0x8F23, 
    0x8F25, 0x8F27, 0x8F28, 0x8F2C, 0x8F2D, 0x8F2E, 0x8F34, 0x8F35, 0x8F36, 
    0x8F37, 0x8F3A, 0x8F40, 0x8F41},
    {0x8F43, 0x8F47, 0x8F4F, 0x8F51, 0x8F52, 0x8F53, 0x8F54, 0x8F55, 0x8F58, 
    0x8F5D, 0x8F5E, 0x8F65, 0x8F9D, 0x8FA0, 0x8FA1, 0x8FA4, 0x8FA5, 0x8FA6, 
    0x8FB5, 0x8FB6, 0x8FB8, 0x8FBE, 0x8FC0, 0x8FC1, 0x8FC6, 0x8FCA, 0x8FCB, 
    0x8FCD, 0x8FD0, 0x8FD2, 0x8FD3, 0x8FD5, 0x8FE0, 0x8FE3, 0x8FE4, 0x8FE8, 
    0x8FEE, 0x8FF1, 0x8FF5, 0x8FF6, 0x8FFB, 0x8FFE, 0x9002, 0x9004, 0x9008, 
    0x900C, 0x9018, 0x901B, 0x9028, 0x9029, 0x902F, 0x902A, 0x902C, 0x902D, 
    0x9033, 0x9034, 0x9037, 0x903F, 0x9043, 0x9044, 0x904C, 0x905B, 0x905D, 
    0x9062, 0x9066, 0x9067, 0x906C, 0x9070, 0x9074, 0x9079, 0x9085, 0x9088, 
    0x908B, 0x908C, 0x908E, 0x9090, 0x9095, 0x9097, 0x9098, 0x9099, 0x909B, 
    0x90A0, 0x90A1, 0x90A2, 0x90A5, 0x90B0, 0x90B2, 0x90B3, 0x90B4, 0x90B6, 
    0x90BD, 0x90CC, 0x90BE, 0x90C3},
    {0x90C4, 0x90C5, 0x90C7, 0x90C8, 0x90D5, 0x90D7, 0x90D8, 0x90D9, 0x90DC, 
    0x90DD, 0x90DF, 0x90E5, 0x90D2, 0x90F6, 0x90EB, 0x90EF, 0x90F0, 0x90F4, 
    0x90FE, 0x90FF, 0x9100, 0x9104, 0x9105, 0x9106, 0x9108, 0x910D, 0x9110, 
    0x9114, 0x9116, 0x9117, 0x9118, 0x911A, 0x911C, 0x911E, 0x9120, 0x9125, 
    0x9122, 0x9123, 0x9127, 0x9129, 0x912E, 0x912F, 0x9131, 0x9134, 0x9136, 
    0x9137, 0x9139, 0x913A, 0x913C, 0x913D, 0x9143, 0x9147, 0x9148, 0x914F, 
    0x9153, 0x9157, 0x9159, 0x915A, 0x915B, 0x9161, 0x9164, 0x9167, 0x916D, 
    0x9174, 0x9179, 0x917A, 0x917B, 0x9181, 0x9183, 0x9185, 0x9186, 0x918A, 
    0x918E, 0x9191, 0x9193, 0x9194, 0x9195, 0x9198, 0x919E, 0x91A1, 0x91A6, 
    0x91A8, 0x91AC, 0x91AD, 0x91AE, 0x91B0, 0x91B1, 0x91B2, 0x91B3, 0x91B6, 
    0x91BB, 0x91BC, 0x91BD, 0x91BF},
    {0x91C2, 0x91C3, 0x91C5, 0x91D3, 0x91D4, 0x91D7, 0x91D9, 0x91DA, 0x91DE, 
    0x91E4, 0x91E5, 0x91E9, 0x91EA, 0x91EC, 0x91ED, 0x91EE, 0x91EF, 0x91F0, 
    0x91F1, 0x91F7, 0x91F9, 0x91FB, 0x91FD, 0x9200, 0x9201, 0x9204, 0x9205, 
    0x9206, 0x9207, 0x9209, 0x920A, 0x920C, 0x9210, 0x9212, 0x9213, 0x9216, 
    0x9218, 0x921C, 0x921D, 0x9223, 0x9224, 0x9225, 0x9226, 0x9228, 0x922E, 
    0x922F, 0x9230, 0x9233, 0x9235, 0x9236, 0x9238, 0x9239, 0x923A, 0x923C, 
    0x923E, 0x9240, 0x9242, 0x9243, 0x9246, 0x9247, 0x924A, 0x924D, 0x924E, 
    0x924F, 0x9251, 0x9258, 0x9259, 0x925C, 0x925D, 0x9260, 0x9261, 0x9265, 
    0x9267, 0x9268, 0x9269, 0x926E, 0x926F, 0x9270, 0x9275, 0x9276, 0x9277, 
    0x9278, 0x9279, 0x927B, 0x927C, 0x927D, 0x927F, 0x9288, 0x9289, 0x928A, 
    0x928D, 0x928E, 0x9292, 0x9297},
    {0x9299, 0x929F, 0x92A0, 0x92A4, 0x92A5, 0x92A7, 0x92A8, 0x92AB, 0x92AF, 
    0x92B2, 0x92B6, 0x92B8, 0x92BA, 0x92BB, 0x92BC, 0x92BD, 0x92BF, 0x92C0, 
    0x92C1, 0x92C2, 0x92C3, 0x92C5, 0x92C6, 0x92C7, 0x92C8, 0x92CB, 0x92CC, 
    0x92CD, 0x92CE, 0x92D0, 0x92D3, 0x92D5, 0x92D7, 0x92D8, 0x92D9, 0x92DC, 
    0x92DD, 0x92DF, 0x92E0, 0x92E1, 0x92E3, 0x92E5, 0x92E7, 0x92E8, 0x92EC, 
    0x92EE, 0x92F0, 0x92F9, 0x92FB, 0x92FF, 0x9300, 0x9302, 0x9308, 0x930D, 
    0x9311, 0x9314, 0x9315, 0x931C, 0x931D, 0x931E, 0x931F, 0x9321, 0x9324, 
    0x9325, 0x9327, 0x9329, 0x932A, 0x9333, 0x9334, 0x9336, 0x9337, 0x9347, 
    0x9348, 0x9349, 0x9350, 0x9351, 0x9352, 0x9355, 0x9357, 0x9358, 0x935A, 
    0x935E, 0x9364, 0x9365, 0x9367, 0x9369, 0x936A, 0x936D, 0x936F, 0x9370, 
    0x9371, 0x9373, 0x9374, 0x9376},
    {0x937A, 0x937D, 0x937F, 0x9380, 0x9381, 0x9382, 0x9388, 0x938A, 0x938B, 
    0x938D, 0x938F, 0x9392, 0x9395, 0x9398, 0x939B, 0x939E, 0x93A1, 0x93A3, 
    0x93A4, 0x93A6, 0x93A8, 0x93AB, 0x93B4, 0x93B5, 0x93B6, 0x93BA, 0x93A9, 
    0x93C1, 0x93C4, 0x93C5, 0x93C6, 0x93C7, 0x93C9, 0x93CA, 0x93CB, 0x93CC, 
    0x93CD, 0x93D3, 0x93D9, 0x93DC, 0x93DE, 0x93DF, 0x93E2, 0x93E6, 0x93E7, 
    0x93F9, 0x93F7, 0x93F8, 0x93FA, 0x93FB, 0x93FD, 0x9401, 0x9402, 0x9404, 
    0x9408, 0x9409, 0x940D, 0x940E, 0x940F, 0x9415, 0x9416, 0x9417, 0x941F, 
    0x942E, 0x942F, 0x9431, 0x9432, 0x9433, 0x9434, 0x943B, 0x943F, 0x943D, 
    0x9443, 0x9445, 0x9448, 0x944A, 0x944C, 0x9455, 0x9459, 0x945C, 0x945F, 
    0x9461, 0x9463, 0x9468, 0x946B, 0x946D, 0x946E, 0x946F, 0x9471, 0x9472, 
    0x9484, 0x9483, 0x9578, 0x9579},
    {0x957E, 0x9584, 0x9588, 0x958C, 0x958D, 0x958E, 0x959D, 0x959E, 0x959F, 
    0x95A1, 0x95A6, 0x95A9, 0x95AB, 0x95AC, 0x95B4, 0x95B6, 0x95BA, 0x95BD, 
    0x95BF, 0x95C6, 0x95C8, 0x95C9, 0x95CB, 0x95D0, 0x95D1, 0x95D2, 0x95D3, 
    0x95D9, 0x95DA, 0x95DD, 0x95DE, 0x95DF, 0x95E0, 0x95E4, 0x95E6, 0x961D, 
    0x961E, 0x9622, 0x9624, 0x9625, 0x9626, 0x962C, 0x9631, 0x9633, 0x9637, 
    0x9638, 0x9639, 0x963A, 0x963C, 0x963D, 0x9641, 0x9652, 0x9654, 0x9656, 
    0x9657, 0x9658, 0x9661, 0x966E, 0x9674, 0x967B, 0x967C, 0x967E, 0x967F, 
    0x9681, 0x9682, 0x9683, 0x9684, 0x9689, 0x9691, 0x9696, 0x969A, 0x969D, 
    0x969F, 0x96A4, 0x96A5, 0x96A6, 0x96A9, 0x96AE, 0x96AF, 0x96B3, 0x96BA, 
    0x96CA, 0x96D2, 0x5DB2, 0x96D8, 0x96DA, 0x96DD, 0x96DE, 0x96DF, 0x96E9, 
    0x96EF, 0x96F1, 0x96FA, 0x9702},
    {0x9703, 0x9705, 0x9709, 0x971A, 0x971B, 0x971D, 0x9721, 0x9722, 0x9723, 
    0x9728, 0x9731, 0x9733, 0x9741, 0x9743, 0x974A, 0x974E, 0x974F, 0x9755, 
    0x9757, 0x9758, 0x975A, 0x975B, 0x9763, 0x9767, 0x976A, 0x976E, 0x9773, 
    0x9776, 0x9777, 0x9778, 0x977B, 0x977D, 0x977F, 0x9780, 0x9789, 0x9795, 
    0x9796, 0x9797, 0x9799, 0x979A, 0x979E, 0x979F, 0x97A2, 0x97AC, 0x97AE, 
    0x97B1, 0x97B2, 0x97B5, 0x97B6, 0x97B8, 0x97B9, 0x97BA, 0x97BC, 0x97BE, 
    0x97BF, 0x97C1, 0x97C4, 0x97C5, 0x97C7, 0x97C9, 0x97CA, 0x97CC, 0x97CD, 
    0x97CE, 0x97D0, 0x97D1, 0x97D4, 0x97D7, 0x97D8, 0x97D9, 0x97DD, 0x97DE, 
    0x97E0, 0x97DB, 0x97E1, 0x97E4, 0x97EF, 0x97F1, 0x97F4, 0x97F7, 0x97F8, 
    0x97FA, 0x9807, 0x980A, 0x9819, 0x980D, 0x980E, 0x9814, 0x9816, 0x981C, 
    0x981E, 0x9820, 0x9823, 0x9826},
    {0x982B, 0x982E, 0x982F, 0x9830, 0x9832, 0x9833, 0x9835, 0x9825, 0x983E, 
    0x9844, 0x9847, 0x984A, 0x9851, 0x9852, 0x9853, 0x9856, 0x9857, 0x9859, 
    0x985A, 0x9862, 0x9863, 0x9865, 0x9866, 0x986A, 0x986C, 0x98AB, 0x98AD, 
    0x98AE, 0x98B0, 0x98B4, 0x98B7, 0x98B8, 0x98BA, 0x98BB, 0x98BF, 0x98C2, 
    0x98C5, 0x98C8, 0x98CC, 0x98E1, 0x98E3, 0x98E5, 0x98E6, 0x98E7, 0x98EA, 
    0x98F3, 0x98F6, 0x9902, 0x9907, 0x9908, 0x9911, 0x9915, 0x9916, 0x9917, 
    0x991A, 0x991B, 0x991C, 0x991F, 0x9922, 0x9926, 0x9927, 0x992B, 0x9931, 
    0x9932, 0x9933, 0x9934, 0x9935, 0x9939, 0x993A, 0x993B, 0x993C, 0x9940, 
    0x9941, 0x9946, 0x9947, 0x9948, 0x994D, 0x994E, 0x9954, 0x9958, 0x9959, 
    0x995B, 0x995C, 0x995E, 0x995F, 0x9960, 0x999B, 0x999D, 0x999F, 0x99A6, 
    0x99B0, 0x99B1, 0x99B2, 0x99B5},
    {0x99B9, 0x99BA, 0x99BD, 0x99BF, 0x99C3, 0x99C9, 0x99D3, 0x99D4, 0x99D9, 
    0x99DA, 0x99DC, 0x99DE, 0x99E7, 0x99EA, 0x99EB, 0x99EC, 0x99F0, 0x99F4, 
    0x99F5, 0x99F9, 0x99FD, 0x99FE, 0x9A02, 0x9A03, 0x9A04, 0x9A0B, 0x9A0C, 
    0x9A10, 0x9A11, 0x9A16, 0x9A1E, 0x9A20, 0x9A22, 0x9A23, 0x9A24, 0x9A27, 
    0x9A2D, 0x9A2E, 0x9A33, 0x9A35, 0x9A36, 0x9A38, 0x9A47, 0x9A41, 0x9A44, 
    0x9A4A, 0x9A4B, 0x9A4C, 0x9A4E, 0x9A51, 0x9A54, 0x9A56, 0x9A5D, 0x9AAA, 
    0x9AAC, 0x9AAE, 0x9AAF, 0x9AB2, 0x9AB4, 0x9AB5, 0x9AB6, 0x9AB9, 0x9ABB, 
    0x9ABE, 0x9ABF, 0x9AC1, 0x9AC3, 0x9AC6, 0x9AC8, 0x9ACE, 0x9AD0, 0x9AD2, 
    0x9AD5, 0x9AD6, 0x9AD7, 0x9ADB, 0x9ADC, 0x9AE0, 0x9AE4, 0x9AE5, 0x9AE7, 
    0x9AE9, 0x9AEC, 0x9AF2, 0x9AF3, 0x9AF5, 0x9AF9, 0x9AFA, 0x9AFD, 0x9AFF, 
    0x9B00, 0x9B01, 0x9B02, 0x9B03},
    {0x9B04, 0x9B05, 0x9B08, 0x9B09, 0x9B0B, 0x9B0C, 0x9B0D, 0x9B0E, 0x9B10, 
    0x9B12, 0x9B16, 0x9B19, 0x9B1B, 0x9B1C, 0x9B20, 0x9B26, 0x9B2B, 0x9B2D, 
    0x9B33, 0x9B34, 0x9B35, 0x9B37, 0x9B39, 0x9B3A, 0x9B3D, 0x9B48, 0x9B4B, 
    0x9B4C, 0x9B55, 0x9B56, 0x9B57, 0x9B5B, 0x9B5E, 0x9B61, 0x9B63, 0x9B65, 
    0x9B66, 0x9B68, 0x9B6A, 0x9B6B, 0x9B6C, 0x9B6D, 0x9B6E, 0x9B73, 0x9B75, 
    0x9B77, 0x9B78, 0x9B79, 0x9B7F, 0x9B80, 0x9B84, 0x9B85, 0x9B86, 0x9B87, 
    0x9B89, 0x9B8A, 0x9B8B, 0x9B8D, 0x9B8F, 0x9B90, 0x9B94, 0x9B9A, 0x9B9D, 
    0x9B9E, 0x9BA6, 0x9BA7, 0x9BA9, 0x9BAC, 0x9BB0, 0x9BB1, 0x9BB2, 0x9BB7, 
    0x9BB8, 0x9BBB, 0x9BBC, 0x9BBE, 0x9BBF, 0x9BC1, 0x9BC7, 0x9BC8, 0x9BCE, 
    0x9BD0, 0x9BD7, 0x9BD8, 0x9BDD, 0x9BDF, 0x9BE5, 0x9BE7, 0x9BEA, 0x9BEB, 
    0x9BEF, 0x9BF3, 0x9BF7, 0x9BF8},
    {0x9BF9, 0x9BFA, 0x9BFD, 0x9BFF, 0x9C00, 0x9C02, 0x9C0B, 0x9C0F, 0x9C11, 
    0x9C16, 0x9C18, 0x9C19, 0x9C1A, 0x9C1C, 0x9C1E, 0x9C22, 0x9C23, 0x9C26, 
    0x9C27, 0x9C28, 0x9C29, 0x9C2A, 0x9C31, 0x9C35, 0x9C36, 0x9C37, 0x9C3D, 
    0x9C41, 0x9C43, 0x9C44, 0x9C45, 0x9C49, 0x9C4A, 0x9C4E, 0x9C4F, 0x9C50, 
    0x9C53, 0x9C54, 0x9C56, 0x9C58, 0x9C5B, 0x9C5D, 0x9C5E, 0x9C5F, 0x9C63, 
    0x9C69, 0x9C6A, 0x9C5C, 0x9C6B, 0x9C68, 0x9C6E, 0x9C70, 0x9C72, 0x9C75, 
    0x9C77, 0x9C7B, 0x9CE6, 0x9CF2, 0x9CF7, 0x9CF9, 0x9D0B, 0x9D02, 0x9D11, 
    0x9D17, 0x9D18, 0x9D1C, 0x9D1D, 0x9D1E, 0x9D2F, 0x9D30, 0x9D32, 0x9D33, 
    0x9D34, 0x9D3A, 0x9D3C, 0x9D45, 0x9D3D, 0x9D42, 0x9D43, 0x9D47, 0x9D4A, 
    0x9D53, 0x9D54, 0x9D5F, 0x9D63, 0x9D62, 0x9D65, 0x9D69, 0x9D6A, 0x9D6B, 
    0x9D70, 0x9D76, 0x9D77, 0x9D7B},
    {0x9D7C, 0x9D7E, 0x9D83, 0x9D84, 0x9D86, 0x9D8A, 0x9D8D, 0x9D8E, 0x9D92, 
    0x9D93, 0x9D95, 0x9D96, 0x9D97, 0x9D98, 0x9DA1, 0x9DAA, 0x9DAC, 0x9DAE, 
    0x9DB1, 0x9DB5, 0x9DB9, 0x9DBC, 0x9DBF, 0x9DC3, 0x9DC7, 0x9DC9, 0x9DCA, 
    0x9DD4, 0x9DD5, 0x9DD6, 0x9DD7, 0x9DDA, 0x9DDE, 0x9DDF, 0x9DE0, 0x9DE5, 
    0x9DE7, 0x9DE9, 0x9DEB, 0x9DEE, 0x9DF0, 0x9DF3, 0x9DF4, 0x9DFE, 0x9E0A, 
    0x9E02, 0x9E07, 0x9E0E, 0x9E10, 0x9E11, 0x9E12, 0x9E15, 0x9E16, 0x9E19, 
    0x9E1C, 0x9E1D, 0x9E7A, 0x9E7B, 0x9E7C, 0x9E80, 0x9E82, 0x9E83, 0x9E84, 
    0x9E85, 0x9E87, 0x9E8E, 0x9E8F, 0x9E96, 0x9E98, 0x9E9B, 0x9E9E, 0x9EA4, 
    0x9EA8, 0x9EAC, 0x9EAE, 0x9EAF, 0x9EB0, 0x9EB3, 0x9EB4, 0x9EB5, 0x9EC6, 
    0x9EC8, 0x9ECB, 0x9ED5, 0x9EDF, 0x9EE4, 0x9EE7, 0x9EEC, 0x9EED, 0x9EEE, 
    0x9EF0, 0x9EF1, 0x9EF2, 0x9EF5},
    {0x9EF8, 0x9EFF, 0x9F02, 0x9F03, 0x9F09, 0x9F0F, 0x9F10, 0x9F11, 0x9F12, 
    0x9F14, 0x9F16, 0x9F17, 0x9F19, 0x9F1A, 0x9F1B, 0x9F1F, 0x9F22, 0x9F26, 
    0x9F2A, 0x9F2B, 0x9F2F, 0x9F31, 0x9F32, 0x9F34, 0x9F37, 0x9F39, 0x9F3A, 
    0x9F3C, 0x9F3D, 0x9F3F, 0x9F41, 0x9F43, 0x9F44, 0x9F45, 0x9F46, 0x9F47, 
    0x9F53, 0x9F55, 0x9F56, 0x9F57, 0x9F58, 0x9F5A, 0x9F5D, 0x9F5E, 0x9F68, 
    0x9F69, 0x9F6D, 0x9F6E, 0x9F6F, 0x9F70, 0x9F71, 0x9F73, 0x9F75, 0x9F7A, 
    0x9F7D, 0x9F8F, 0x9F90, 0x9F91, 0x9F92, 0x9F94, 0x9F96, 0x9F97, 0x9F9E, 
    0x9FA1, 0x9FA2, 0x9FA3, 0x9FA5,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    { ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    { ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    { ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    { ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    { ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    { ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    { ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    { ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    { ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    { ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    { ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    { ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    { ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    { ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    { ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    { ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
    { ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR,  ERROR, 
     ERROR,  ERROR,  ERROR,  ERROR},
};

/*
 * Mapping from Unicode back to JIS X 0212.
 * 
 * This inverse is done the same way the SBCS ones are done: I
 * provide a list of JIS X 0212 positions, sorted into ascending
 * order of their Unicode values. Then we can binary-search through
 * this list, referring to the above table for each comparison, to
 * find the coordinates for a given code point.
 * 
 * Generated by running the following sh+Perl over JIS0212.TXT:

cat JIS0212.TXT | \
perl -ne '$a{$3}=[hex$1,hex$2] if /^0x(\S\S)(\S\S)\s+(0x\S+)\s/;' \
      -e 'END {$o="    ";for $k (sort keys %a) { ($r,$c) = @{$a{$k}}; ' \
      -e '$o .= $C; $C = ", "; (print "$o\n"), $o="    " if length $o > 70;' \
      -e '$o .= sprintf "{%d,%d}", $r-33,$c-33; } print "$o\n"; }'

 */

static const struct { unsigned char r, c; } jisx0212_backward[] = {
    {1,22}, {1,33}, {1,79}, {1,34}, {1,76}, {1,75}, {1,77}, {1,19}, {1,16}, 
    {1,74}, {1,35}, {9,1}, {9,0}, {9,3}, {9,9}, {9,2}, {9,8}, {8,0}, {9,13}, 
    {9,17}, {9,16}, {9,19}, {9,18}, {9,31}, {9,30}, {9,33}, {9,32}, {9,47}, 
    {9,49}, {9,48}, {9,51}, {9,55}, {9,50}, {8,11}, {9,66}, {9,65}, {9,68}, 
    {9,67}, {9,81}, {8,15}, {8,45}, {10,1}, {10,0}, {10,3}, {10,9}, {10,2}, 
    {10,8}, {8,32}, {10,13}, {10,17}, {10,16}, {10,19}, {10,18}, {10,31}, 
    {10,30}, {10,33}, {10,32}, {8,34}, {10,47}, {10,49}, {10,48}, {10,51}, 
    {10,55}, {10,50}, {8,43}, {10,66}, {10,65}, {10,68}, {10,67}, {10,81}, 
    {8,47}, {10,82}, {9,6}, {10,6}, {9,4}, {10,4}, {9,7}, {10,7}, {9,10}, 
    {10,10}, {9,11}, {10,11}, {9,14}, {10,14}, {9,12}, {10,12}, {9,15}, 
    {10,15}, {8,1}, {8,33}, {9,22}, {10,22}, {9,21}, {10,21}, {9,23}, {10,23}, 
    {9,20}, {10,20}, {9,25}, {10,25}, {9,26}, {10,26}, {9,28}, {10,28}, 
    {9,27}, {9,29}, {10,29}, {8,3}, {8,35}, {9,38}, {10,38}, {9,36}, {10,36}, 
    {9,37}, {10,37}, {9,35}, {8,36}, {8,5}, {8,37}, {9,39}, {10,39}, {9,40}, 
    {10,40}, {8,38}, {9,41}, {10,41}, {9,43}, {10,43}, {9,42}, {10,42}, 
    {8,8}, {8,40}, {8,7}, {8,39}, {9,44}, {10,44}, {9,46}, {10,46}, {9,45}, 
    {10,45}, {8,41}, {8,10}, {8,42}, {9,54}, {10,54}, {9,53}, {10,53}, 
    {8,12}, {8,44}, {9,56}, {10,56}, {9,58}, {10,58}, {9,57}, {10,57}, 
    {9,59}, {10,59}, {9,60}, {10,60}, {9,62}, {10,62}, {9,61}, {10,61}, 
    {9,64}, {10,64}, {9,63}, {10,63}, {8,14}, {8,46}, {9,75}, {10,75}, 
    {9,72}, {10,72}, {9,69}, {10,69}, {9,74}, {10,74}, {9,71}, {10,71}, 
    {9,73}, {10,73}, {9,80}, {10,80}, {9,83}, {10,83}, {9,82}, {9,84}, 
    {10,84}, {9,86}, {10,86}, {9,85}, {10,85}, {9,5}, {10,5}, {9,34}, {10,34}, 
    {9,52}, {10,52}, {9,70}, {10,70}, {9,79}, {10,79}, {9,76}, {10,76}, 
    {9,78}, {10,78}, {9,77}, {10,77}, {10,24}, {1,15}, {1,14}, {1,17}, 
    {1,21}, {1,20}, {1,18}, {1,23}, {1,24}, {5,64}, {5,65}, {5,66}, {5,67}, 
    {5,70}, {5,72}, {5,75}, {5,85}, {5,68}, {5,73}, {5,80}, {5,81}, {5,82}, 
    {5,83}, {5,90}, {5,87}, {5,84}, {5,89}, {5,86}, {5,88}, {5,91}, {6,33}, 
    {6,34}, {6,35}, {6,36}, {6,37}, {6,38}, {6,39}, {6,40}, {6,41}, {6,42}, 
    {6,43}, {6,44}, {6,45}, {6,81}, {6,82}, {6,83}, {6,84}, {6,85}, {6,86}, 
    {6,87}, {6,88}, {6,89}, {6,90}, {6,91}, {6,92}, {6,93}, {1,80}, {1,78}, 
    {15,0}, {15,1}, {15,2}, {15,3}, {15,4}, {15,5}, {15,6}, {15,7}, {15,8}, 
    {15,9}, {15,10}, {15,11}, {15,12}, {15,13}, {15,14}, {15,15}, {15,16}, 
    {15,17}, {15,18}, {15,19}, {15,20}, {15,21}, {15,22}, {15,23}, {15,24}, 
    {15,25}, {15,26}, {15,27}, {15,28}, {15,29}, {15,30}, {15,31}, {15,32}, 
    {15,33}, {15,34}, {15,35}, {15,36}, {15,37}, {15,38}, {15,39}, {15,40}, 
    {15,41}, {15,42}, {15,43}, {15,44}, {15,45}, {15,46}, {15,47}, {15,48}, 
    {15,49}, {15,50}, {15,51}, {15,52}, {15,53}, {15,54}, {15,55}, {15,56}, 
    {15,57}, {15,58}, {15,59}, {15,60}, {15,61}, {15,63}, {15,64}, {15,65}, 
    {15,66}, {15,67}, {15,68}, {15,69}, {15,70}, {15,71}, {15,72}, {15,73}, 
    {15,74}, {15,75}, {15,76}, {15,77}, {15,78}, {15,79}, {15,62}, {15,80}, 
    {15,81}, {15,82}, {15,83}, {15,84}, {15,85}, {15,86}, {15,87}, {15,88}, 
    {15,89}, {15,90}, {15,91}, {15,92}, {15,93}, {16,0}, {16,1}, {16,2}, 
    {16,3}, {16,4}, {16,5}, {16,6}, {16,7}, {16,8}, {16,9}, {16,10}, {16,11}, 
    {16,12}, {16,13}, {16,14}, {16,15}, {16,16}, {16,17}, {16,18}, {16,19}, 
    {16,20}, {16,21}, {16,22}, {16,23}, {16,24}, {16,25}, {16,26}, {16,27}, 
    {16,28}, {16,29}, {16,30}, {16,31}, {16,32}, {16,33}, {16,34}, {16,35}, 
    {16,36}, {16,37}, {16,38}, {16,39}, {16,40}, {16,41}, {16,42}, {16,43}, 
    {16,44}, {16,45}, {16,46}, {16,47}, {16,48}, {16,49}, {16,50}, {16,51}, 
    {16,52}, {16,53}, {16,54}, {16,55}, {16,56}, {16,57}, {16,58}, {16,59}, 
    {16,60}, {16,61}, {16,85}, {16,62}, {16,63}, {16,64}, {16,65}, {16,66}, 
    {16,67}, {16,68}, {16,69}, {16,70}, {16,71}, {16,72}, {16,73}, {16,74}, 
    {16,75}, {16,76}, {16,77}, {16,78}, {16,79}, {16,80}, {16,81}, {16,82}, 
    {16,83}, {16,84}, {16,86}, {16,87}, {16,88}, {16,89}, {16,90}, {16,91}, 
    {16,92}, {16,93}, {17,0}, {17,1}, {17,2}, {17,3}, {17,4}, {17,5}, {17,6}, 
    {17,7}, {17,8}, {17,9}, {17,10}, {17,11}, {17,12}, {17,13}, {17,14}, 
    {17,15}, {17,16}, {17,17}, {17,18}, {17,19}, {17,20}, {17,21}, {17,22}, 
    {17,23}, {17,24}, {17,25}, {17,26}, {17,27}, {17,28}, {17,29}, {17,30}, 
    {17,31}, {17,32}, {17,33}, {17,34}, {17,35}, {17,36}, {17,48}, {17,37}, 
    {17,38}, {17,39}, {17,40}, {17,41}, {17,42}, {17,43}, {17,44}, {17,45}, 
    {17,46}, {17,47}, {17,49}, {17,50}, {17,51}, {17,52}, {17,53}, {17,54}, 
    {17,55}, {17,56}, {17,57}, {17,58}, {17,59}, {17,60}, {17,61}, {17,62}, 
    {17,63}, {17,64}, {17,65}, {17,66}, {17,67}, {17,68}, {17,69}, {17,70}, 
    {17,71}, {17,72}, {17,73}, {17,74}, {17,75}, {17,76}, {17,77}, {17,78}, 
    {17,79}, {17,80}, {17,81}, {17,82}, {17,83}, {17,84}, {17,85}, {17,86}, 
    {17,87}, {17,88}, {17,89}, {17,90}, {17,91}, {17,92}, {17,93}, {18,0}, 
    {18,1}, {18,2}, {18,3}, {18,4}, {18,5}, {18,6}, {18,7}, {18,8}, {18,9}, 
    {18,10}, {18,11}, {18,12}, {18,13}, {18,14}, {18,15}, {18,16}, {18,17}, 
    {18,18}, {18,19}, {18,20}, {18,21}, {18,22}, {18,23}, {18,24}, {18,25}, 
    {18,26}, {18,27}, {18,28}, {18,29}, {18,30}, {18,31}, {18,32}, {18,33}, 
    {18,34}, {18,35}, {18,36}, {18,37}, {18,38}, {18,39}, {18,40}, {18,41}, 
    {18,42}, {18,43}, {18,44}, {18,45}, {18,46}, {18,47}, {18,48}, {18,49}, 
    {18,50}, {18,51}, {18,52}, {18,53}, {18,54}, {18,55}, {18,56}, {18,57}, 
    {18,58}, {18,59}, {18,60}, {18,61}, {18,62}, {18,63}, {18,64}, {18,65}, 
    {18,66}, {18,67}, {18,68}, {18,69}, {18,70}, {18,71}, {18,72}, {18,73}, 
    {18,74}, {18,75}, {18,76}, {18,77}, {18,78}, {18,79}, {18,80}, {18,81}, 
    {18,82}, {18,83}, {18,84}, {18,85}, {18,86}, {18,87}, {18,88}, {18,89}, 
    {18,90}, {18,91}, {18,92}, {18,93}, {19,0}, {19,1}, {19,2}, {19,3}, 
    {19,4}, {19,5}, {19,6}, {19,7}, {19,8}, {19,9}, {19,10}, {19,11}, {19,12}, 
    {19,13}, {19,14}, {19,15}, {19,16}, {19,17}, {19,18}, {19,19}, {19,20}, 
    {19,21}, {19,23}, {19,22}, {19,24}, {19,25}, {19,26}, {19,27}, {19,28}, 
    {19,29}, {19,30}, {19,31}, {19,32}, {19,33}, {19,34}, {19,35}, {19,36}, 
    {19,37}, {19,38}, {19,39}, {19,40}, {19,41}, {19,42}, {19,43}, {19,44}, 
    {19,45}, {19,46}, {19,47}, {19,48}, {19,49}, {19,50}, {19,51}, {19,52}, 
    {19,53}, {19,54}, {19,55}, {19,56}, {19,57}, {19,58}, {19,59}, {19,60}, 
    {19,61}, {19,62}, {19,63}, {19,64}, {19,65}, {19,66}, {19,67}, {19,68}, 
    {19,69}, {19,70}, {19,71}, {19,72}, {19,73}, {19,74}, {19,75}, {19,76}, 
    {19,77}, {19,78}, {19,79}, {19,80}, {19,81}, {19,82}, {19,83}, {19,84}, 
    {19,85}, {19,86}, {19,87}, {19,88}, {19,89}, {19,90}, {19,91}, {19,92}, 
    {19,93}, {20,0}, {20,1}, {20,2}, {20,3}, {20,4}, {20,5}, {20,6}, {20,7}, 
    {20,8}, {20,9}, {20,10}, {20,11}, {20,12}, {20,13}, {20,14}, {20,15}, 
    {20,16}, {20,17}, {20,18}, {20,19}, {20,20}, {20,21}, {20,22}, {20,23}, 
    {20,24}, {20,25}, {20,26}, {20,27}, {20,28}, {20,29}, {20,30}, {20,31}, 
    {20,32}, {20,33}, {20,34}, {20,35}, {20,36}, {20,37}, {20,38}, {20,39}, 
    {20,40}, {20,41}, {20,42}, {20,43}, {20,44}, {20,45}, {20,46}, {20,47}, 
    {20,48}, {20,49}, {20,50}, {20,51}, {20,52}, {20,53}, {20,54}, {20,55}, 
    {20,56}, {20,57}, {20,58}, {20,59}, {20,60}, {20,61}, {20,62}, {20,63}, 
    {20,64}, {20,65}, {20,66}, {20,67}, {20,68}, {20,69}, {20,70}, {20,71}, 
    {20,72}, {20,73}, {20,74}, {20,75}, {20,76}, {20,77}, {20,78}, {20,79}, 
    {20,80}, {20,81}, {20,82}, {20,83}, {20,84}, {20,85}, {20,86}, {20,87}, 
    {20,88}, {20,89}, {20,90}, {20,91}, {20,92}, {20,93}, {21,0}, {21,1}, 
    {21,2}, {21,3}, {21,4}, {21,5}, {21,6}, {21,7}, {21,8}, {21,9}, {21,10}, 
    {21,11}, {21,12}, {21,13}, {21,14}, {21,15}, {21,16}, {21,17}, {21,18}, 
    {21,19}, {21,20}, {21,21}, {21,22}, {21,23}, {21,24}, {21,25}, {21,26}, 
    {21,27}, {21,28}, {21,29}, {21,30}, {21,31}, {21,32}, {21,33}, {21,34}, 
    {21,35}, {21,36}, {21,37}, {21,38}, {21,39}, {21,40}, {21,41}, {21,42}, 
    {21,43}, {21,44}, {21,45}, {21,46}, {21,47}, {21,48}, {21,49}, {21,50}, 
    {21,51}, {21,52}, {21,53}, {21,54}, {21,55}, {21,56}, {21,57}, {21,58}, 
    {21,59}, {21,60}, {21,61}, {21,62}, {21,63}, {21,64}, {21,65}, {21,66}, 
    {21,67}, {21,68}, {21,69}, {21,70}, {21,71}, {21,72}, {21,73}, {21,74}, 
    {21,75}, {21,76}, {21,79}, {21,80}, {21,77}, {21,78}, {21,81}, {21,82}, 
    {21,83}, {21,84}, {21,85}, {21,86}, {21,87}, {21,88}, {21,89}, {21,90}, 
    {21,92}, {21,93}, {21,91}, {22,0}, {22,1}, {22,2}, {22,3}, {22,4}, 
    {22,5}, {22,6}, {22,7}, {22,8}, {22,9}, {22,10}, {22,11}, {22,12}, 
    {22,13}, {22,14}, {22,15}, {22,16}, {22,17}, {22,18}, {22,19}, {22,20}, 
    {22,21}, {22,22}, {22,23}, {22,24}, {22,25}, {22,26}, {22,27}, {22,28}, 
    {22,29}, {22,30}, {22,31}, {22,32}, {22,33}, {22,34}, {22,35}, {22,36}, 
    {22,37}, {22,38}, {22,39}, {22,40}, {22,41}, {22,42}, {22,43}, {22,44}, 
    {22,45}, {22,46}, {22,47}, {22,48}, {22,49}, {22,50}, {22,51}, {22,52}, 
    {22,53}, {22,54}, {22,63}, {22,55}, {22,56}, {22,57}, {22,58}, {22,59}, 
    {22,60}, {22,61}, {22,62}, {22,64}, {22,65}, {22,66}, {22,67}, {22,68}, 
    {22,69}, {22,70}, {22,71}, {22,72}, {22,73}, {22,74}, {22,75}, {22,76}, 
    {22,93}, {22,77}, {22,78}, {22,79}, {22,80}, {22,81}, {22,82}, {22,83}, 
    {22,84}, {22,85}, {22,86}, {22,87}, {22,88}, {22,89}, {22,90}, {22,91}, 
    {22,92}, {23,0}, {23,1}, {23,2}, {23,3}, {23,4}, {23,5}, {23,6}, {23,7}, 
    {23,8}, {23,9}, {23,10}, {23,11}, {23,12}, {23,13}, {23,14}, {23,15}, 
    {23,16}, {23,17}, {23,18}, {23,19}, {23,20}, {23,21}, {23,22}, {23,23}, 
    {23,24}, {23,25}, {23,26}, {23,27}, {23,28}, {23,29}, {23,30}, {23,31}, 
    {23,32}, {23,33}, {23,34}, {23,35}, {23,36}, {23,37}, {23,38}, {23,39}, 
    {23,40}, {23,41}, {23,42}, {23,43}, {23,44}, {23,45}, {23,47}, {23,48}, 
    {23,46}, {23,49}, {23,50}, {23,51}, {23,52}, {23,53}, {23,54}, {23,55}, 
    {23,56}, {23,57}, {23,58}, {23,59}, {23,60}, {23,61}, {23,62}, {23,63}, 
    {23,64}, {23,65}, {23,66}, {23,67}, {23,68}, {23,70}, {23,71}, {23,72}, 
    {23,73}, {23,74}, {23,75}, {23,76}, {23,77}, {23,78}, {23,79}, {23,80}, 
    {23,81}, {23,82}, {23,83}, {23,84}, {23,85}, {23,86}, {23,87}, {23,88}, 
    {23,89}, {23,90}, {23,91}, {23,92}, {23,93}, {24,0}, {24,1}, {24,2}, 
    {24,3}, {24,4}, {24,5}, {24,6}, {24,7}, {24,8}, {24,9}, {24,10}, {24,11}, 
    {24,12}, {24,13}, {24,14}, {24,15}, {24,16}, {24,17}, {24,18}, {24,19}, 
    {24,20}, {24,21}, {24,22}, {24,23}, {24,24}, {24,25}, {24,26}, {24,27}, 
    {24,28}, {24,29}, {24,30}, {24,31}, {24,32}, {24,33}, {24,34}, {24,35}, 
    {24,36}, {24,37}, {24,38}, {24,39}, {24,40}, {24,41}, {24,42}, {24,43}, 
    {24,44}, {24,45}, {24,46}, {24,47}, {24,48}, {24,49}, {24,50}, {24,51}, 
    {24,52}, {24,53}, {24,54}, {24,55}, {24,56}, {24,57}, {24,58}, {24,59}, 
    {24,60}, {24,61}, {24,62}, {24,63}, {24,64}, {24,65}, {24,66}, {24,67}, 
    {24,68}, {24,69}, {24,70}, {24,71}, {24,72}, {24,73}, {24,74}, {24,75}, 
    {24,76}, {24,77}, {24,78}, {24,79}, {24,80}, {24,81}, {24,82}, {24,83}, 
    {24,84}, {24,85}, {24,86}, {24,87}, {24,88}, {24,89}, {24,90}, {24,91}, 
    {24,92}, {24,93}, {25,0}, {25,1}, {25,2}, {25,3}, {25,4}, {25,5}, {25,6}, 
    {25,7}, {25,8}, {25,9}, {25,10}, {25,11}, {25,12}, {25,13}, {25,14}, 
    {25,15}, {25,16}, {25,18}, {25,19}, {25,20}, {25,21}, {25,22}, {25,23}, 
    {25,17}, {25,24}, {25,25}, {25,26}, {25,27}, {25,28}, {25,29}, {25,30}, 
    {25,31}, {25,32}, {25,33}, {25,34}, {25,35}, {25,36}, {25,37}, {25,38}, 
    {25,39}, {25,40}, {25,41}, {25,42}, {25,43}, {25,44}, {25,45}, {25,46}, 
    {25,47}, {25,48}, {25,49}, {25,50}, {25,51}, {25,52}, {25,53}, {25,54}, 
    {25,55}, {25,56}, {25,57}, {25,58}, {25,59}, {25,60}, {25,61}, {25,62}, 
    {25,63}, {25,64}, {25,65}, {25,66}, {25,67}, {25,68}, {25,69}, {25,70}, 
    {25,71}, {25,72}, {25,73}, {25,74}, {25,75}, {25,76}, {25,77}, {25,78}, 
    {25,79}, {25,80}, {25,81}, {25,82}, {25,83}, {25,84}, {25,85}, {25,86}, 
    {25,87}, {25,88}, {25,89}, {25,90}, {25,91}, {25,92}, {25,93}, {26,0}, 
    {26,1}, {26,2}, {26,3}, {26,4}, {26,5}, {26,6}, {26,7}, {26,8}, {26,9}, 
    {26,10}, {26,11}, {26,12}, {26,13}, {26,14}, {26,15}, {26,16}, {26,17}, 
    {26,18}, {26,19}, {26,20}, {26,21}, {26,22}, {26,23}, {26,24}, {26,25}, 
    {26,26}, {26,28}, {26,27}, {26,29}, {26,30}, {26,31}, {26,32}, {26,33}, 
    {26,34}, {26,35}, {26,36}, {26,38}, {26,39}, {26,40}, {26,41}, {26,37}, 
    {26,42}, {26,43}, {26,44}, {26,45}, {26,46}, {26,47}, {26,48}, {26,49}, 
    {26,50}, {26,54}, {26,52}, {26,51}, {26,53}, {26,55}, {26,56}, {26,57}, 
    {26,58}, {26,59}, {26,60}, {26,61}, {26,62}, {26,63}, {26,64}, {26,65}, 
    {26,66}, {26,67}, {26,68}, {26,69}, {26,70}, {26,71}, {26,72}, {26,73}, 
    {26,74}, {26,75}, {26,76}, {26,77}, {26,78}, {26,79}, {26,80}, {26,81}, 
    {69,83}, {26,82}, {26,83}, {26,84}, {26,85}, {26,86}, {26,87}, {26,89}, 
    {26,88}, {26,90}, {26,91}, {26,92}, {26,93}, {27,0}, {27,1}, {27,2}, 
    {27,3}, {27,4}, {27,5}, {27,6}, {27,7}, {27,8}, {27,9}, {27,10}, {27,11}, 
    {27,13}, {27,12}, {27,14}, {27,15}, {27,16}, {27,19}, {27,17}, {27,18}, 
    {27,20}, {27,21}, {27,22}, {27,23}, {27,24}, {27,25}, {27,26}, {27,27}, 
    {27,28}, {27,29}, {27,30}, {27,31}, {27,32}, {27,33}, {27,34}, {27,35}, 
    {27,36}, {27,37}, {27,38}, {27,39}, {27,40}, {27,41}, {27,42}, {27,43}, 
    {27,44}, {27,45}, {27,46}, {27,47}, {27,49}, {27,48}, {27,50}, {27,51}, 
    {27,52}, {27,53}, {27,54}, {27,55}, {27,56}, {27,57}, {27,58}, {27,59}, 
    {27,60}, {27,61}, {27,62}, {27,63}, {27,64}, {27,65}, {27,66}, {27,67}, 
    {27,68}, {27,69}, {27,70}, {27,71}, {27,72}, {27,73}, {27,74}, {27,75}, 
    {27,76}, {27,77}, {27,78}, {27,79}, {27,80}, {27,81}, {27,82}, {27,83}, 
    {27,84}, {27,85}, {27,86}, {27,87}, {27,88}, {27,89}, {27,90}, {27,91}, 
    {27,92}, {27,93}, {28,0}, {28,1}, {28,2}, {28,3}, {28,4}, {28,5}, {28,6}, 
    {28,7}, {28,8}, {28,9}, {28,10}, {28,11}, {28,12}, {28,13}, {28,14}, 
    {28,17}, {28,15}, {28,16}, {28,18}, {28,19}, {28,20}, {28,21}, {28,22}, 
    {28,23}, {28,24}, {28,25}, {28,26}, {28,27}, {28,28}, {28,29}, {28,30}, 
    {28,31}, {28,32}, {28,33}, {28,34}, {28,35}, {28,36}, {28,37}, {28,38}, 
    {28,39}, {28,40}, {28,41}, {28,42}, {28,43}, {28,44}, {28,45}, {28,46}, 
    {28,47}, {28,48}, {28,49}, {28,50}, {28,51}, {28,52}, {28,53}, {28,54}, 
    {28,55}, {28,56}, {28,57}, {28,58}, {28,59}, {28,60}, {28,61}, {28,62}, 
    {28,63}, {28,64}, {28,65}, {28,66}, {28,67}, {28,68}, {28,69}, {28,70}, 
    {28,71}, {28,72}, {28,73}, {28,74}, {28,75}, {28,76}, {28,77}, {28,78}, 
    {28,79}, {28,80}, {28,81}, {28,82}, {28,83}, {28,84}, {28,85}, {28,86}, 
    {28,87}, {28,88}, {28,89}, {28,90}, {28,91}, {28,92}, {28,93}, {29,0}, 
    {29,1}, {29,2}, {29,3}, {29,4}, {29,5}, {29,6}, {29,7}, {29,8}, {29,9}, 
    {29,10}, {29,11}, {29,12}, {29,13}, {29,14}, {29,15}, {29,16}, {29,17}, 
    {29,18}, {29,19}, {29,20}, {29,21}, {29,22}, {29,23}, {29,24}, {29,25}, 
    {29,26}, {29,27}, {29,28}, {29,29}, {29,30}, {29,31}, {29,32}, {29,33}, 
    {29,34}, {29,35}, {29,36}, {29,37}, {29,38}, {29,39}, {29,40}, {29,41}, 
    {29,42}, {29,43}, {29,44}, {29,45}, {29,46}, {29,47}, {29,48}, {29,49}, 
    {29,50}, {29,51}, {29,52}, {29,53}, {29,54}, {29,55}, {29,56}, {29,57}, 
    {29,58}, {29,59}, {29,60}, {29,61}, {29,62}, {29,63}, {29,64}, {29,65}, 
    {29,66}, {29,67}, {29,68}, {29,69}, {29,70}, {29,71}, {29,72}, {29,73}, 
    {29,74}, {29,75}, {29,76}, {29,77}, {29,78}, {29,79}, {29,80}, {29,81}, 
    {29,82}, {29,83}, {29,84}, {29,85}, {29,86}, {29,87}, {29,88}, {29,89}, 
    {29,90}, {29,93}, {29,91}, {29,92}, {30,0}, {30,1}, {30,2}, {30,3}, 
    {30,4}, {30,5}, {30,6}, {30,7}, {30,8}, {30,9}, {30,10}, {30,11}, {30,12}, 
    {30,13}, {30,14}, {30,15}, {30,16}, {30,17}, {30,18}, {30,19}, {30,20}, 
    {30,21}, {30,22}, {30,23}, {30,24}, {30,25}, {30,26}, {30,27}, {30,28}, 
    {30,29}, {30,30}, {30,31}, {30,32}, {30,33}, {30,34}, {30,35}, {30,36}, 
    {30,37}, {30,38}, {30,39}, {30,40}, {30,41}, {30,42}, {30,43}, {30,44}, 
    {30,45}, {30,46}, {30,47}, {30,48}, {30,49}, {30,50}, {30,51}, {30,52}, 
    {30,53}, {30,54}, {30,55}, {30,56}, {30,57}, {30,58}, {30,59}, {30,60}, 
    {30,61}, {30,62}, {30,63}, {30,64}, {30,65}, {30,66}, {30,67}, {30,68}, 
    {30,69}, {30,70}, {30,71}, {30,72}, {30,73}, {30,74}, {30,75}, {30,76}, 
    {30,77}, {30,78}, {30,79}, {30,80}, {30,81}, {30,82}, {30,83}, {30,84}, 
    {30,85}, {30,86}, {30,87}, {30,88}, {30,89}, {30,90}, {30,91}, {30,92}, 
    {30,93}, {31,0}, {31,1}, {31,2}, {31,3}, {31,4}, {31,5}, {31,6}, {31,7}, 
    {31,8}, {31,9}, {31,10}, {31,11}, {31,12}, {31,13}, {31,14}, {31,15}, 
    {31,16}, {31,17}, {31,18}, {31,19}, {31,20}, {31,21}, {31,22}, {31,23}, 
    {31,24}, {31,25}, {31,26}, {31,27}, {31,28}, {31,29}, {31,30}, {31,31}, 
    {31,32}, {31,33}, {31,34}, {31,35}, {31,36}, {31,37}, {31,38}, {31,39}, 
    {31,40}, {31,41}, {31,42}, {31,43}, {31,44}, {31,45}, {31,46}, {31,47}, 
    {31,48}, {31,49}, {31,50}, {31,51}, {31,52}, {31,53}, {31,54}, {31,55}, 
    {31,56}, {31,57}, {31,58}, {31,59}, {31,60}, {31,61}, {31,62}, {31,63}, 
    {31,64}, {31,65}, {31,66}, {31,67}, {31,68}, {31,69}, {31,70}, {31,71}, 
    {31,72}, {31,73}, {31,74}, {31,75}, {31,76}, {31,77}, {31,78}, {31,79}, 
    {31,80}, {31,81}, {31,82}, {31,83}, {31,84}, {31,85}, {31,86}, {31,87}, 
    {31,88}, {31,89}, {31,90}, {31,91}, {31,92}, {31,93}, {32,0}, {32,1}, 
    {32,2}, {32,3}, {32,4}, {32,5}, {32,6}, {32,7}, {32,8}, {32,9}, {32,10}, 
    {32,11}, {32,12}, {32,13}, {32,14}, {32,15}, {32,16}, {32,17}, {32,18}, 
    {32,19}, {32,20}, {32,21}, {32,22}, {32,23}, {32,24}, {32,25}, {32,26}, 
    {32,27}, {32,28}, {32,29}, {32,30}, {32,31}, {32,32}, {32,33}, {32,34}, 
    {32,35}, {32,36}, {32,37}, {32,38}, {32,39}, {32,40}, {32,41}, {32,42}, 
    {32,43}, {32,44}, {32,45}, {32,46}, {32,47}, {32,48}, {32,49}, {32,50}, 
    {32,51}, {32,52}, {32,53}, {32,54}, {32,55}, {32,56}, {32,57}, {32,58}, 
    {32,59}, {32,60}, {32,61}, {32,62}, {32,63}, {32,64}, {32,65}, {32,66}, 
    {32,67}, {32,68}, {32,69}, {32,70}, {32,71}, {32,72}, {32,73}, {32,74}, 
    {32,75}, {32,76}, {32,77}, {32,78}, {32,79}, {32,80}, {32,81}, {32,82}, 
    {32,83}, {32,84}, {32,85}, {32,86}, {32,87}, {32,88}, {32,89}, {32,90}, 
    {32,91}, {32,92}, {32,93}, {33,0}, {33,1}, {33,2}, {33,3}, {33,4}, 
    {33,5}, {33,6}, {33,7}, {33,8}, {33,9}, {33,10}, {33,11}, {33,12}, 
    {33,13}, {33,15}, {33,14}, {33,16}, {33,17}, {33,18}, {33,19}, {33,20}, 
    {33,22}, {33,21}, {33,23}, {33,24}, {33,25}, {33,26}, {33,27}, {33,28}, 
    {33,29}, {33,31}, {33,32}, {33,33}, {33,35}, {33,36}, {33,38}, {33,39}, 
    {33,40}, {33,41}, {33,43}, {33,34}, {33,37}, {33,42}, {33,44}, {33,45}, 
    {33,46}, {33,47}, {33,48}, {33,49}, {33,50}, {33,51}, {33,52}, {33,53}, 
    {33,54}, {33,55}, {33,56}, {33,57}, {33,58}, {33,59}, {33,60}, {33,61}, 
    {33,62}, {33,63}, {33,64}, {33,65}, {33,66}, {33,67}, {33,68}, {33,69}, 
    {33,70}, {33,71}, {33,72}, {33,73}, {33,74}, {33,75}, {33,76}, {33,30}, 
    {33,77}, {33,78}, {33,79}, {33,80}, {33,81}, {33,82}, {33,83}, {33,84}, 
    {33,85}, {33,86}, {33,87}, {33,88}, {33,89}, {33,90}, {33,91}, {33,92}, 
    {33,93}, {34,0}, {34,1}, {34,2}, {34,3}, {34,4}, {34,5}, {34,6}, {34,7}, 
    {34,8}, {34,9}, {34,10}, {34,11}, {34,12}, {34,13}, {34,14}, {34,15}, 
    {34,16}, {34,17}, {34,18}, {34,19}, {34,20}, {34,21}, {34,22}, {34,24}, 
    {34,25}, {34,26}, {34,27}, {34,28}, {34,29}, {34,30}, {34,31}, {34,32}, 
    {34,33}, {34,34}, {34,35}, {34,36}, {34,37}, {34,38}, {34,39}, {34,23}, 
    {34,41}, {34,42}, {34,43}, {34,44}, {34,46}, {34,45}, {34,47}, {34,48}, 
    {34,49}, {34,50}, {34,51}, {34,52}, {34,53}, {34,54}, {34,55}, {34,56}, 
    {34,57}, {34,58}, {34,40}, {34,59}, {34,60}, {34,61}, {34,62}, {34,63}, 
    {34,64}, {34,65}, {34,66}, {34,67}, {34,68}, {34,69}, {34,70}, {34,71}, 
    {34,72}, {34,73}, {34,74}, {34,75}, {34,76}, {34,77}, {34,78}, {34,79}, 
    {34,80}, {34,81}, {34,82}, {34,83}, {34,84}, {34,85}, {34,86}, {34,87}, 
    {34,88}, {34,89}, {34,90}, {34,91}, {34,92}, {34,93}, {35,0}, {35,1}, 
    {35,2}, {35,3}, {35,4}, {35,5}, {35,6}, {35,7}, {35,8}, {35,9}, {35,10}, 
    {35,11}, {35,12}, {35,13}, {35,14}, {35,15}, {35,16}, {35,17}, {35,18}, 
    {35,19}, {35,20}, {35,21}, {35,22}, {35,23}, {35,24}, {35,25}, {35,26}, 
    {35,27}, {35,28}, {35,29}, {35,30}, {35,31}, {35,32}, {35,33}, {35,34}, 
    {35,35}, {35,36}, {35,37}, {35,38}, {35,39}, {35,40}, {35,41}, {35,42}, 
    {35,43}, {35,44}, {35,45}, {35,46}, {35,47}, {35,48}, {35,49}, {35,50}, 
    {35,51}, {35,52}, {35,53}, {35,54}, {35,55}, {35,56}, {35,57}, {35,58}, 
    {35,59}, {35,60}, {35,61}, {35,62}, {35,63}, {35,64}, {35,65}, {35,66}, 
    {35,67}, {35,68}, {35,69}, {35,70}, {35,71}, {35,72}, {35,73}, {35,74}, 
    {35,75}, {35,76}, {35,77}, {35,78}, {35,79}, {35,80}, {35,81}, {35,82}, 
    {35,83}, {35,84}, {35,85}, {35,86}, {35,87}, {35,88}, {35,89}, {35,90}, 
    {35,91}, {35,92}, {35,93}, {36,0}, {36,1}, {36,2}, {36,3}, {36,4}, 
    {36,5}, {36,6}, {36,7}, {36,8}, {36,9}, {36,10}, {36,11}, {36,12}, 
    {36,13}, {36,14}, {36,15}, {36,16}, {36,17}, {36,18}, {36,19}, {36,20}, 
    {36,21}, {36,22}, {36,23}, {36,24}, {36,25}, {36,26}, {36,27}, {36,28}, 
    {36,29}, {36,30}, {36,31}, {36,32}, {36,33}, {36,34}, {36,35}, {36,36}, 
    {36,37}, {36,38}, {36,39}, {36,40}, {36,41}, {36,42}, {36,44}, {36,43}, 
    {36,45}, {36,46}, {36,47}, {36,48}, {36,49}, {36,50}, {36,51}, {36,52}, 
    {36,53}, {36,54}, {36,55}, {36,56}, {36,57}, {36,58}, {36,59}, {36,60}, 
    {36,61}, {36,62}, {36,63}, {36,64}, {36,65}, {36,66}, {36,67}, {36,68}, 
    {36,69}, {36,70}, {36,71}, {36,72}, {36,73}, {36,74}, {36,75}, {36,76}, 
    {36,77}, {36,78}, {36,79}, {36,80}, {36,81}, {36,82}, {36,83}, {36,84}, 
    {36,85}, {36,86}, {36,87}, {36,88}, {36,89}, {36,90}, {36,91}, {36,92}, 
    {36,93}, {37,0}, {37,1}, {37,2}, {37,3}, {37,4}, {37,5}, {37,6}, {37,7}, 
    {37,8}, {37,9}, {37,10}, {37,11}, {37,12}, {37,13}, {37,14}, {37,15}, 
    {37,16}, {37,17}, {37,18}, {37,19}, {37,20}, {37,21}, {37,22}, {37,23}, 
    {37,24}, {37,25}, {37,26}, {37,27}, {37,28}, {37,29}, {37,30}, {37,31}, 
    {37,32}, {37,33}, {37,34}, {37,35}, {37,36}, {37,37}, {37,38}, {37,39}, 
    {37,40}, {37,41}, {37,42}, {37,43}, {37,44}, {37,45}, {37,46}, {37,47}, 
    {37,48}, {37,49}, {37,50}, {37,51}, {37,52}, {37,53}, {37,54}, {37,55}, 
    {37,56}, {37,57}, {37,58}, {37,59}, {37,60}, {37,61}, {37,62}, {37,63}, 
    {38,21}, {37,64}, {37,65}, {37,66}, {37,67}, {37,68}, {37,69}, {37,70}, 
    {37,71}, {37,72}, {37,73}, {37,74}, {37,75}, {37,76}, {37,77}, {37,78}, 
    {37,79}, {37,80}, {37,81}, {37,82}, {37,83}, {37,84}, {37,85}, {37,86}, 
    {37,87}, {37,88}, {37,89}, {37,90}, {37,91}, {37,92}, {37,93}, {38,0}, 
    {38,1}, {38,2}, {38,3}, {38,4}, {38,5}, {38,6}, {38,7}, {38,8}, {38,9}, 
    {38,10}, {38,11}, {38,12}, {38,13}, {38,14}, {38,15}, {38,16}, {38,17}, 
    {38,18}, {38,19}, {38,20}, {38,22}, {38,23}, {38,24}, {38,25}, {38,26}, 
    {38,27}, {38,28}, {38,29}, {38,30}, {38,31}, {38,32}, {38,33}, {38,34}, 
    {38,35}, {38,36}, {38,37}, {38,38}, {38,39}, {38,40}, {38,41}, {38,42}, 
    {38,43}, {38,44}, {38,45}, {38,46}, {38,47}, {38,48}, {38,49}, {38,50}, 
    {38,51}, {38,52}, {38,53}, {38,54}, {38,55}, {38,56}, {38,57}, {38,58}, 
    {38,59}, {38,60}, {38,61}, {38,62}, {38,63}, {38,64}, {38,65}, {38,66}, 
    {38,67}, {38,68}, {38,69}, {38,70}, {38,71}, {38,72}, {38,73}, {38,74}, 
    {38,75}, {38,76}, {38,77}, {38,78}, {38,79}, {38,80}, {38,81}, {38,82}, 
    {38,83}, {38,84}, {38,85}, {38,86}, {38,87}, {38,88}, {38,89}, {38,90}, 
    {38,91}, {38,92}, {38,93}, {39,0}, {39,1}, {39,2}, {39,3}, {39,4}, 
    {39,5}, {39,6}, {39,7}, {39,8}, {39,9}, {39,10}, {39,11}, {39,12}, 
    {39,13}, {39,14}, {39,15}, {39,16}, {39,17}, {39,18}, {39,19}, {39,20}, 
    {39,21}, {39,22}, {39,23}, {39,24}, {39,25}, {39,26}, {39,27}, {39,28}, 
    {39,29}, {39,30}, {39,31}, {39,32}, {39,33}, {39,34}, {39,35}, {39,36}, 
    {39,37}, {39,38}, {39,39}, {39,40}, {39,41}, {39,42}, {39,43}, {39,50}, 
    {39,44}, {39,45}, {39,46}, {39,47}, {39,48}, {39,49}, {39,51}, {39,52}, 
    {39,53}, {39,54}, {39,55}, {39,56}, {39,57}, {39,58}, {39,59}, {39,60}, 
    {39,61}, {39,62}, {39,63}, {39,64}, {39,65}, {39,66}, {39,67}, {39,68}, 
    {39,69}, {39,70}, {39,71}, {39,72}, {39,73}, {39,74}, {39,75}, {39,76}, 
    {39,77}, {39,78}, {39,79}, {39,80}, {39,81}, {39,82}, {39,83}, {39,84}, 
    {39,85}, {39,86}, {39,87}, {39,88}, {39,89}, {39,90}, {39,91}, {39,92}, 
    {39,93}, {40,0}, {40,1}, {40,2}, {40,3}, {40,4}, {40,5}, {40,6}, {40,7}, 
    {40,8}, {40,9}, {40,10}, {40,11}, {40,12}, {40,13}, {40,14}, {40,15}, 
    {40,16}, {40,17}, {40,18}, {40,19}, {40,20}, {40,21}, {40,22}, {40,23}, 
    {40,24}, {40,25}, {40,26}, {40,27}, {40,32}, {40,28}, {40,29}, {40,30}, 
    {40,31}, {40,33}, {40,34}, {40,35}, {40,36}, {40,37}, {40,38}, {40,39}, 
    {40,40}, {40,41}, {40,42}, {40,43}, {40,44}, {40,45}, {40,46}, {40,47}, 
    {40,48}, {40,49}, {40,50}, {40,51}, {40,52}, {40,53}, {40,54}, {40,55}, 
    {40,56}, {40,57}, {40,58}, {40,59}, {40,60}, {40,61}, {40,62}, {40,63}, 
    {40,64}, {40,65}, {40,66}, {40,67}, {40,68}, {40,69}, {40,70}, {40,71}, 
    {40,72}, {40,73}, {40,74}, {40,75}, {40,76}, {40,77}, {40,78}, {40,79}, 
    {40,80}, {40,81}, {40,82}, {40,83}, {40,84}, {40,85}, {40,86}, {40,87}, 
    {40,88}, {40,89}, {40,90}, {40,91}, {40,92}, {40,93}, {41,0}, {41,1}, 
    {41,2}, {41,3}, {41,4}, {41,5}, {41,6}, {41,7}, {41,8}, {41,9}, {41,10}, 
    {41,11}, {41,12}, {41,13}, {41,14}, {41,15}, {41,16}, {41,17}, {41,18}, 
    {41,19}, {41,20}, {41,21}, {41,22}, {41,23}, {41,24}, {41,25}, {41,26}, 
    {41,27}, {41,28}, {41,29}, {41,30}, {41,31}, {41,32}, {41,33}, {41,34}, 
    {41,35}, {41,36}, {41,37}, {41,38}, {41,39}, {41,40}, {41,41}, {41,42}, 
    {41,43}, {41,44}, {41,45}, {41,46}, {41,47}, {41,48}, {41,49}, {41,50}, 
    {41,51}, {41,52}, {41,53}, {41,54}, {41,55}, {41,56}, {41,57}, {41,58}, 
    {41,59}, {41,60}, {41,61}, {41,62}, {41,63}, {41,64}, {41,65}, {41,66}, 
    {41,67}, {41,68}, {41,69}, {41,70}, {41,71}, {41,72}, {41,73}, {41,74}, 
    {41,75}, {41,76}, {41,77}, {41,78}, {41,79}, {41,80}, {41,81}, {41,82}, 
    {41,83}, {41,84}, {41,85}, {41,86}, {41,87}, {41,88}, {41,89}, {41,90}, 
    {41,91}, {41,92}, {41,93}, {42,0}, {42,1}, {42,2}, {42,3}, {42,4}, 
    {42,5}, {42,6}, {42,7}, {42,8}, {42,9}, {42,10}, {42,11}, {42,12}, 
    {42,13}, {42,14}, {42,15}, {42,16}, {42,17}, {42,18}, {42,19}, {42,20}, 
    {42,21}, {42,22}, {42,23}, {42,24}, {42,25}, {42,26}, {42,27}, {42,28}, 
    {42,29}, {42,30}, {42,31}, {42,32}, {42,33}, {42,34}, {42,35}, {42,36}, 
    {42,37}, {42,38}, {42,39}, {42,40}, {42,41}, {42,42}, {42,43}, {42,44}, 
    {42,45}, {42,46}, {42,47}, {42,48}, {42,49}, {42,50}, {42,51}, {42,52}, 
    {42,53}, {42,54}, {42,55}, {42,56}, {42,57}, {42,58}, {42,59}, {42,60}, 
    {42,61}, {42,62}, {42,63}, {42,64}, {42,65}, {42,66}, {42,67}, {42,68}, 
    {42,69}, {42,70}, {42,71}, {42,72}, {42,73}, {42,74}, {42,75}, {42,76}, 
    {42,77}, {42,78}, {42,79}, {42,80}, {42,81}, {42,82}, {42,83}, {42,84}, 
    {42,85}, {42,86}, {42,87}, {42,88}, {42,89}, {42,90}, {42,91}, {42,92}, 
    {42,93}, {43,0}, {43,1}, {43,2}, {43,3}, {43,4}, {43,5}, {43,6}, {43,7}, 
    {43,8}, {43,9}, {43,10}, {43,11}, {43,12}, {43,13}, {43,14}, {43,15}, 
    {43,16}, {43,17}, {43,18}, {43,19}, {43,20}, {43,21}, {43,22}, {43,23}, 
    {43,24}, {43,25}, {43,26}, {43,27}, {43,28}, {43,29}, {43,30}, {43,31}, 
    {43,32}, {43,33}, {43,34}, {43,35}, {43,36}, {43,37}, {43,38}, {43,39}, 
    {43,40}, {43,41}, {43,42}, {43,43}, {43,44}, {43,45}, {43,46}, {43,47}, 
    {43,48}, {43,49}, {43,50}, {43,51}, {43,52}, {43,53}, {43,54}, {43,55}, 
    {43,56}, {43,57}, {43,58}, {43,59}, {43,60}, {43,61}, {43,62}, {43,63}, 
    {43,64}, {43,65}, {43,66}, {43,67}, {43,68}, {43,69}, {43,70}, {43,71}, 
    {43,72}, {43,73}, {43,74}, {43,75}, {43,76}, {43,77}, {43,78}, {43,79}, 
    {43,80}, {43,81}, {43,82}, {43,83}, {43,84}, {43,85}, {43,86}, {43,87}, 
    {43,88}, {43,89}, {43,90}, {43,91}, {43,92}, {43,93}, {44,0}, {44,1}, 
    {44,2}, {44,3}, {44,4}, {44,5}, {44,6}, {44,7}, {44,8}, {44,9}, {44,10}, 
    {44,11}, {44,12}, {44,13}, {44,14}, {44,15}, {44,16}, {44,17}, {44,18}, 
    {44,19}, {44,20}, {44,21}, {44,22}, {44,23}, {44,24}, {44,25}, {44,26}, 
    {44,27}, {44,28}, {44,29}, {44,30}, {44,31}, {44,32}, {44,33}, {44,34}, 
    {44,35}, {44,36}, {44,37}, {44,38}, {44,39}, {44,40}, {44,41}, {44,42}, 
    {44,43}, {44,44}, {44,45}, {44,46}, {44,47}, {44,48}, {44,49}, {44,50}, 
    {44,51}, {44,52}, {44,53}, {44,54}, {44,55}, {44,56}, {44,57}, {44,58}, 
    {44,59}, {44,60}, {44,61}, {44,62}, {44,63}, {44,64}, {44,65}, {44,66}, 
    {44,67}, {44,68}, {44,69}, {44,70}, {44,71}, {44,72}, {44,73}, {44,74}, 
    {44,75}, {44,76}, {44,77}, {44,78}, {44,79}, {44,80}, {44,81}, {44,82}, 
    {44,83}, {44,84}, {44,85}, {44,86}, {44,87}, {44,88}, {44,89}, {44,90}, 
    {44,91}, {44,92}, {44,93}, {45,0}, {45,1}, {45,3}, {45,4}, {45,5}, 
    {45,6}, {45,7}, {45,8}, {45,2}, {45,9}, {45,10}, {45,11}, {45,12}, 
    {45,13}, {45,14}, {45,15}, {45,16}, {45,17}, {45,18}, {45,19}, {45,20}, 
    {45,21}, {45,22}, {45,23}, {45,24}, {45,25}, {45,26}, {45,27}, {45,28}, 
    {45,29}, {45,30}, {45,31}, {45,32}, {45,33}, {45,34}, {45,35}, {45,36}, 
    {45,37}, {45,38}, {45,39}, {45,40}, {45,41}, {45,42}, {45,43}, {45,44}, 
    {45,45}, {45,46}, {45,47}, {45,48}, {45,49}, {45,50}, {45,51}, {45,52}, 
    {45,53}, {45,54}, {45,55}, {45,56}, {45,57}, {45,58}, {45,59}, {45,60}, 
    {45,61}, {45,62}, {45,63}, {45,64}, {45,65}, {45,66}, {45,67}, {45,68}, 
    {45,69}, {45,70}, {45,71}, {45,72}, {45,73}, {45,74}, {45,75}, {45,76}, 
    {45,77}, {45,78}, {45,79}, {45,80}, {45,81}, {45,82}, {45,83}, {45,84}, 
    {45,85}, {45,86}, {45,87}, {45,88}, {45,89}, {45,90}, {45,91}, {45,92}, 
    {45,93}, {46,0}, {46,1}, {46,2}, {46,3}, {46,4}, {46,5}, {46,6}, {46,7}, 
    {46,8}, {46,9}, {46,10}, {46,11}, {46,12}, {46,13}, {46,14}, {46,15}, 
    {46,16}, {46,17}, {46,18}, {46,19}, {46,20}, {46,21}, {46,22}, {46,23}, 
    {46,24}, {46,25}, {46,26}, {46,27}, {46,28}, {46,29}, {46,30}, {46,31}, 
    {46,32}, {46,33}, {46,34}, {46,35}, {46,36}, {46,37}, {46,38}, {46,39}, 
    {46,40}, {46,41}, {46,42}, {46,43}, {46,44}, {46,45}, {46,46}, {46,47}, 
    {46,48}, {46,49}, {46,50}, {46,51}, {46,52}, {46,53}, {46,54}, {46,55}, 
    {46,56}, {46,57}, {46,58}, {46,59}, {46,60}, {46,61}, {46,62}, {46,63}, 
    {46,64}, {46,65}, {46,66}, {46,67}, {46,68}, {46,69}, {46,70}, {46,71}, 
    {46,72}, {46,73}, {46,74}, {46,75}, {46,76}, {46,77}, {46,78}, {46,79}, 
    {46,80}, {46,81}, {46,83}, {46,84}, {46,85}, {46,82}, {46,86}, {46,87}, 
    {46,88}, {46,89}, {46,90}, {46,91}, {46,92}, {46,93}, {47,0}, {47,1}, 
    {47,2}, {47,3}, {47,4}, {47,5}, {47,6}, {47,7}, {47,8}, {47,9}, {47,10}, 
    {47,11}, {47,13}, {47,14}, {47,15}, {47,16}, {47,12}, {47,17}, {47,18}, 
    {47,19}, {47,20}, {47,22}, {47,23}, {47,24}, {47,25}, {47,26}, {47,21}, 
    {47,27}, {47,28}, {47,29}, {47,30}, {47,31}, {47,32}, {47,33}, {47,34}, 
    {47,35}, {47,36}, {47,37}, {47,38}, {47,39}, {47,40}, {47,41}, {47,42}, 
    {47,43}, {47,44}, {47,45}, {47,46}, {47,47}, {47,48}, {47,49}, {47,50}, 
    {47,51}, {47,52}, {47,53}, {47,54}, {47,55}, {47,56}, {47,57}, {47,58}, 
    {47,59}, {47,60}, {47,61}, {47,62}, {47,63}, {47,64}, {47,65}, {47,66}, 
    {47,67}, {47,68}, {47,69}, {47,70}, {47,71}, {47,72}, {47,73}, {47,74}, 
    {47,75}, {47,76}, {47,77}, {47,78}, {47,79}, {47,80}, {47,81}, {47,82}, 
    {47,83}, {47,84}, {47,85}, {47,86}, {47,87}, {47,88}, {47,89}, {47,90}, 
    {47,91}, {47,92}, {47,93}, {48,0}, {48,1}, {48,2}, {48,3}, {48,4}, 
    {48,5}, {48,6}, {48,7}, {48,8}, {48,9}, {48,10}, {48,11}, {48,12}, 
    {48,13}, {48,14}, {48,15}, {48,16}, {48,17}, {48,18}, {48,19}, {48,20}, 
    {48,21}, {48,22}, {48,23}, {48,24}, {48,25}, {48,26}, {48,27}, {48,28}, 
    {48,29}, {48,30}, {48,31}, {48,32}, {48,33}, {48,34}, {48,35}, {48,36}, 
    {48,37}, {48,38}, {48,39}, {48,40}, {48,41}, {48,42}, {48,43}, {48,44}, 
    {48,45}, {48,46}, {48,47}, {48,48}, {48,49}, {48,50}, {48,51}, {48,52}, 
    {48,53}, {48,54}, {48,55}, {48,56}, {48,57}, {48,58}, {48,59}, {48,60}, 
    {48,61}, {48,62}, {48,63}, {48,64}, {48,65}, {48,66}, {48,67}, {48,68}, 
    {48,69}, {48,70}, {48,71}, {48,72}, {48,73}, {48,74}, {48,75}, {48,76}, 
    {48,77}, {48,78}, {48,79}, {48,80}, {48,81}, {48,82}, {48,83}, {48,84}, 
    {48,85}, {48,86}, {48,87}, {48,88}, {48,89}, {48,90}, {48,91}, {48,92}, 
    {48,93}, {49,0}, {49,1}, {49,2}, {49,3}, {49,4}, {49,5}, {49,6}, {49,7}, 
    {49,8}, {49,9}, {49,10}, {49,11}, {49,12}, {49,13}, {49,14}, {49,15}, 
    {49,16}, {49,17}, {49,18}, {49,19}, {49,20}, {49,21}, {49,22}, {49,23}, 
    {49,24}, {49,25}, {49,26}, {49,27}, {49,28}, {49,29}, {49,30}, {49,31}, 
    {49,32}, {49,33}, {49,34}, {49,35}, {49,36}, {49,37}, {49,38}, {49,39}, 
    {49,40}, {49,41}, {49,42}, {49,43}, {49,44}, {49,45}, {49,46}, {49,47}, 
    {49,48}, {49,49}, {49,50}, {49,51}, {49,52}, {49,53}, {49,54}, {49,55}, 
    {49,56}, {49,57}, {49,58}, {49,59}, {49,60}, {49,61}, {49,62}, {49,63}, 
    {49,64}, {49,65}, {49,66}, {49,67}, {49,68}, {49,69}, {49,70}, {49,71}, 
    {49,72}, {49,73}, {49,74}, {49,75}, {49,76}, {49,77}, {49,78}, {49,79}, 
    {49,80}, {49,81}, {49,82}, {49,83}, {49,85}, {49,86}, {49,87}, {49,84}, 
    {49,88}, {49,89}, {49,90}, {49,91}, {49,92}, {49,93}, {50,0}, {50,1}, 
    {50,2}, {50,3}, {50,4}, {50,5}, {50,6}, {50,7}, {50,8}, {50,9}, {50,10}, 
    {50,11}, {50,12}, {50,13}, {50,14}, {50,15}, {50,16}, {50,17}, {50,18}, 
    {50,19}, {50,20}, {50,21}, {50,22}, {50,23}, {50,24}, {50,25}, {50,26}, 
    {50,27}, {50,28}, {50,29}, {50,30}, {50,31}, {50,32}, {50,33}, {50,34}, 
    {50,35}, {50,36}, {50,37}, {50,38}, {50,39}, {50,40}, {50,41}, {50,42}, 
    {50,43}, {50,44}, {50,45}, {50,46}, {50,47}, {50,48}, {50,49}, {50,50}, 
    {50,51}, {50,52}, {50,53}, {50,54}, {50,55}, {50,56}, {50,57}, {50,58}, 
    {50,59}, {50,60}, {50,61}, {50,62}, {50,63}, {50,64}, {50,65}, {50,66}, 
    {50,67}, {50,68}, {50,69}, {50,70}, {50,71}, {50,72}, {50,73}, {50,74}, 
    {50,75}, {50,76}, {50,77}, {50,78}, {50,79}, {50,80}, {50,81}, {50,82}, 
    {50,83}, {50,84}, {50,85}, {50,86}, {50,87}, {50,88}, {50,89}, {50,90}, 
    {50,91}, {50,92}, {50,93}, {51,0}, {51,1}, {51,2}, {51,3}, {51,4}, 
    {51,5}, {51,6}, {51,7}, {51,8}, {51,9}, {51,10}, {51,11}, {51,12}, 
    {51,13}, {51,14}, {51,15}, {51,16}, {51,17}, {51,19}, {51,20}, {51,21}, 
    {51,22}, {51,23}, {51,24}, {51,25}, {51,26}, {51,27}, {51,28}, {51,29}, 
    {51,18}, {51,30}, {51,31}, {51,32}, {51,33}, {51,34}, {51,35}, {51,36}, 
    {51,37}, {51,38}, {51,39}, {51,40}, {51,41}, {51,42}, {51,43}, {51,44}, 
    {51,45}, {51,46}, {51,47}, {51,48}, {51,49}, {51,50}, {51,51}, {51,52}, 
    {51,53}, {51,54}, {51,55}, {51,56}, {51,57}, {51,58}, {51,59}, {51,60}, 
    {51,61}, {51,62}, {51,63}, {51,64}, {51,65}, {51,66}, {51,67}, {51,68}, 
    {51,69}, {51,70}, {51,71}, {51,72}, {51,73}, {51,75}, {51,74}, {51,76}, 
    {51,77}, {51,78}, {51,79}, {51,80}, {51,81}, {51,82}, {51,83}, {51,84}, 
    {51,85}, {51,86}, {51,87}, {51,88}, {51,89}, {51,90}, {51,91}, {51,92}, 
    {51,93}, {52,0}, {52,1}, {52,2}, {52,3}, {52,4}, {52,5}, {52,6}, {52,7}, 
    {52,8}, {52,9}, {52,10}, {52,11}, {52,12}, {52,13}, {52,14}, {52,15}, 
    {52,16}, {52,17}, {52,18}, {52,19}, {52,20}, {52,21}, {52,22}, {52,23}, 
    {52,24}, {52,25}, {52,26}, {52,27}, {52,28}, {52,29}, {52,30}, {52,31}, 
    {52,32}, {52,33}, {52,34}, {52,35}, {52,36}, {52,37}, {52,38}, {52,39}, 
    {52,40}, {52,41}, {52,42}, {52,43}, {52,44}, {52,45}, {52,46}, {52,47}, 
    {52,48}, {52,49}, {52,50}, {52,51}, {52,52}, {52,53}, {52,54}, {52,55}, 
    {52,56}, {52,57}, {52,58}, {52,59}, {52,60}, {52,61}, {52,62}, {52,63}, 
    {52,64}, {52,65}, {52,66}, {52,67}, {52,68}, {52,69}, {52,70}, {52,71}, 
    {52,72}, {52,73}, {52,74}, {52,75}, {52,76}, {52,77}, {52,78}, {52,79}, 
    {52,80}, {52,81}, {52,82}, {52,83}, {52,84}, {52,85}, {52,86}, {52,87}, 
    {52,88}, {52,89}, {52,90}, {52,91}, {52,92}, {52,93}, {53,0}, {53,1}, 
    {53,2}, {53,3}, {53,4}, {53,5}, {53,6}, {53,7}, {53,8}, {53,9}, {53,10}, 
    {53,11}, {53,12}, {53,13}, {53,14}, {53,15}, {53,16}, {53,17}, {53,18}, 
    {53,19}, {53,20}, {53,21}, {53,22}, {53,23}, {53,24}, {53,25}, {53,26}, 
    {53,27}, {53,28}, {53,29}, {53,30}, {53,31}, {53,32}, {53,33}, {53,34}, 
    {53,35}, {53,36}, {53,38}, {53,39}, {53,40}, {53,41}, {53,42}, {53,37}, 
    {53,43}, {53,44}, {53,45}, {53,46}, {53,47}, {53,48}, {53,49}, {53,50}, 
    {53,51}, {53,53}, {53,54}, {53,55}, {53,52}, {53,56}, {53,57}, {53,58}, 
    {53,59}, {53,60}, {53,61}, {53,62}, {53,63}, {53,64}, {53,65}, {53,66}, 
    {53,67}, {53,68}, {53,69}, {53,70}, {53,71}, {53,72}, {53,73}, {53,74}, 
    {53,75}, {53,76}, {53,77}, {53,78}, {53,79}, {53,80}, {53,81}, {53,82}, 
    {53,83}, {53,84}, {53,85}, {53,86}, {53,87}, {53,88}, {53,89}, {53,90}, 
    {53,91}, {53,92}, {53,93}, {54,0}, {54,1}, {54,2}, {54,3}, {54,4}, 
    {54,5}, {54,6}, {54,7}, {54,8}, {54,9}, {54,10}, {54,11}, {54,12}, 
    {54,13}, {54,14}, {54,15}, {54,16}, {54,17}, {54,18}, {54,19}, {54,20}, 
    {54,21}, {54,22}, {54,23}, {54,24}, {54,25}, {54,26}, {54,27}, {54,28}, 
    {54,29}, {54,30}, {54,31}, {54,32}, {54,33}, {54,34}, {54,35}, {54,36}, 
    {54,37}, {54,38}, {54,39}, {54,40}, {54,41}, {54,42}, {54,43}, {54,44}, 
    {54,45}, {54,46}, {54,47}, {54,48}, {54,49}, {54,50}, {54,51}, {54,52}, 
    {54,53}, {54,54}, {54,55}, {54,56}, {54,57}, {54,58}, {54,59}, {54,60}, 
    {54,61}, {54,62}, {54,63}, {54,64}, {54,65}, {54,67}, {54,68}, {54,69}, 
    {54,70}, {54,71}, {54,72}, {54,73}, {54,74}, {54,75}, {54,76}, {54,77}, 
    {54,78}, {54,79}, {54,80}, {54,81}, {54,82}, {54,83}, {54,84}, {54,85}, 
    {54,86}, {54,87}, {54,88}, {55,29}, {54,66}, {54,89}, {54,90}, {54,91}, 
    {54,92}, {54,93}, {55,0}, {55,1}, {55,2}, {55,3}, {55,4}, {55,5}, {55,6}, 
    {55,7}, {55,8}, {55,9}, {55,10}, {55,11}, {55,12}, {55,13}, {55,14}, 
    {55,15}, {55,16}, {55,17}, {55,18}, {55,43}, {55,19}, {55,20}, {55,21}, 
    {55,22}, {55,23}, {55,24}, {55,25}, {55,26}, {55,27}, {55,28}, {55,30}, 
    {55,31}, {55,32}, {55,33}, {55,34}, {55,35}, {55,36}, {55,37}, {55,38}, 
    {55,39}, {55,40}, {55,41}, {55,42}, {55,44}, {55,45}, {55,46}, {55,47}, 
    {55,48}, {55,49}, {55,50}, {55,51}, {55,52}, {55,53}, {55,54}, {55,55}, 
    {55,56}, {55,57}, {55,58}, {55,59}, {55,60}, {55,61}, {55,62}, {55,63}, 
    {55,64}, {55,65}, {55,66}, {55,67}, {55,68}, {55,69}, {55,70}, {55,71}, 
    {55,72}, {55,73}, {55,74}, {55,75}, {55,76}, {55,77}, {55,78}, {55,79}, 
    {55,80}, {55,81}, {55,82}, {55,83}, {55,84}, {55,85}, {55,86}, {55,87}, 
    {55,88}, {55,89}, {55,90}, {55,91}, {55,92}, {55,93}, {56,0}, {56,1}, 
    {56,2}, {56,3}, {56,4}, {56,5}, {56,6}, {56,7}, {56,9}, {56,10}, {56,11}, 
    {56,12}, {56,13}, {56,14}, {56,15}, {56,16}, {56,17}, {56,18}, {56,19}, 
    {56,20}, {56,21}, {56,22}, {56,23}, {56,24}, {56,25}, {56,26}, {56,27}, 
    {56,8}, {56,28}, {56,29}, {56,30}, {56,31}, {56,32}, {56,33}, {56,34}, 
    {56,35}, {56,36}, {56,37}, {56,38}, {56,39}, {56,40}, {56,41}, {56,42}, 
    {56,43}, {56,44}, {56,45}, {56,46}, {56,47}, {56,48}, {56,49}, {56,50}, 
    {56,51}, {56,52}, {56,53}, {56,54}, {56,55}, {56,56}, {56,57}, {56,58}, 
    {56,59}, {56,60}, {56,61}, {56,62}, {56,63}, {56,64}, {56,65}, {56,66}, 
    {56,67}, {56,68}, {56,69}, {56,83}, {56,70}, {56,71}, {56,72}, {56,73}, 
    {56,74}, {56,75}, {56,76}, {56,77}, {56,78}, {56,79}, {56,80}, {56,81}, 
    {56,82}, {56,84}, {56,85}, {56,86}, {56,87}, {56,88}, {56,89}, {56,90}, 
    {56,91}, {56,92}, {56,93}, {57,0}, {57,1}, {57,2}, {57,3}, {57,4}, 
    {57,5}, {57,6}, {57,7}, {57,8}, {57,9}, {57,10}, {57,11}, {57,12}, 
    {57,13}, {57,14}, {57,15}, {57,16}, {57,17}, {57,18}, {57,19}, {57,20}, 
    {57,21}, {23,69}, {57,22}, {57,23}, {57,24}, {57,25}, {57,26}, {57,27}, 
    {57,28}, {57,29}, {57,30}, {57,31}, {57,32}, {57,33}, {57,34}, {57,35}, 
    {57,36}, {57,37}, {57,38}, {57,39}, {57,40}, {57,41}, {57,42}, {57,76}, 
    {57,43}, {57,44}, {57,45}, {57,46}, {57,47}, {57,48}, {57,49}, {57,50}, 
    {57,51}, {57,52}, {57,53}, {57,54}, {57,55}, {57,56}, {57,57}, {57,58}, 
    {57,59}, {57,60}, {57,61}, {57,62}, {57,63}, {57,64}, {57,65}, {57,66}, 
    {57,67}, {57,68}, {57,69}, {57,70}, {57,71}, {57,72}, {57,73}, {57,74}, 
    {57,75}, {57,77}, {57,78}, {57,79}, {57,80}, {57,81}, {57,82}, {57,83}, 
    {57,84}, {57,85}, {57,86}, {57,87}, {57,88}, {57,89}, {57,90}, {57,91}, 
    {57,92}, {57,93}, {58,0}, {58,1}, {58,2}, {58,3}, {58,4}, {58,5}, {58,6}, 
    {58,7}, {58,8}, {58,9}, {58,10}, {58,11}, {58,12}, {58,13}, {58,14}, 
    {58,15}, {58,16}, {58,17}, {58,18}, {58,19}, {58,20}, {58,21}, {58,22}, 
    {58,23}, {58,24}, {58,25}, {58,26}, {58,27}, {58,28}, {58,29}, {58,30}, 
    {58,31}, {58,32}, {58,33}, {58,34}, {58,35}, {58,36}, {58,37}, {58,38}, 
    {58,39}, {58,40}, {58,41}, {58,42}, {58,43}, {58,44}, {58,45}, {58,46}, 
    {58,47}, {58,48}, {58,49}, {58,50}, {58,51}, {58,52}, {58,53}, {58,54}, 
    {58,55}, {58,56}, {58,57}, {58,58}, {58,59}, {58,60}, {58,61}, {58,62}, 
    {58,63}, {58,64}, {58,65}, {58,66}, {58,67}, {58,68}, {58,69}, {58,70}, 
    {58,71}, {58,72}, {58,73}, {58,74}, {58,75}, {58,76}, {58,77}, {58,79}, 
    {58,80}, {58,81}, {58,82}, {58,78}, {58,83}, {58,84}, {58,85}, {58,86}, 
    {58,87}, {58,88}, {58,89}, {58,90}, {58,91}, {58,92}, {58,93}, {59,0}, 
    {59,1}, {59,2}, {59,3}, {59,4}, {59,5}, {59,6}, {59,7}, {59,8}, {59,9}, 
    {59,10}, {59,11}, {59,12}, {59,13}, {59,14}, {59,15}, {59,16}, {59,17}, 
    {59,18}, {59,19}, {59,20}, {59,21}, {59,22}, {59,23}, {59,24}, {59,25}, 
    {59,26}, {59,27}, {59,28}, {59,29}, {59,30}, {59,31}, {59,32}, {59,33}, 
    {59,34}, {59,35}, {59,36}, {59,37}, {59,38}, {59,39}, {59,40}, {59,41}, 
    {59,42}, {59,43}, {59,44}, {59,45}, {59,46}, {59,47}, {59,48}, {59,49}, 
    {59,50}, {59,51}, {59,52}, {59,53}, {59,54}, {59,55}, {59,56}, {59,57}, 
    {59,58}, {59,59}, {59,60}, {59,61}, {59,62}, {59,63}, {59,64}, {59,65}, 
    {59,66}, {59,67}, {59,68}, {59,69}, {59,70}, {59,71}, {59,72}, {59,73}, 
    {59,74}, {59,75}, {59,76}, {59,77}, {59,78}, {59,79}, {59,80}, {59,81}, 
    {59,82}, {59,83}, {59,84}, {59,85}, {59,86}, {59,87}, {59,88}, {59,89}, 
    {59,90}, {59,91}, {59,92}, {59,93}, {60,0}, {60,1}, {60,2}, {60,3}, 
    {60,4}, {60,5}, {60,6}, {60,7}, {60,8}, {60,9}, {60,10}, {60,11}, {60,12}, 
    {60,13}, {60,14}, {60,15}, {60,16}, {60,17}, {60,18}, {60,19}, {60,20}, 
    {60,21}, {60,22}, {60,23}, {60,24}, {60,25}, {60,26}, {60,27}, {60,28}, 
    {60,29}, {60,30}, {60,31}, {60,32}, {60,33}, {60,34}, {60,35}, {60,36}, 
    {60,37}, {60,38}, {60,39}, {60,40}, {60,41}, {60,42}, {60,43}, {60,44}, 
    {60,45}, {60,46}, {60,47}, {60,48}, {60,49}, {60,50}, {60,51}, {60,52}, 
    {60,53}, {60,54}, {60,55}, {60,56}, {60,57}, {60,58}, {60,59}, {60,60}, 
    {60,61}, {60,62}, {60,63}, {60,64}, {60,65}, {60,66}, {60,67}, {60,68}, 
    {60,69}, {60,70}, {60,71}, {60,72}, {60,73}, {60,74}, {60,75}, {60,76}, 
    {60,77}, {60,78}, {60,79}, {60,80}, {60,81}, {60,82}, {60,83}, {60,84}, 
    {60,85}, {60,86}, {60,87}, {60,88}, {60,89}, {60,90}, {60,91}, {60,92}, 
    {60,93}, {61,0}, {61,1}, {61,2}, {61,3}, {61,4}, {61,5}, {61,6}, {61,7}, 
    {61,8}, {61,9}, {61,10}, {61,11}, {61,12}, {61,13}, {61,14}, {61,15}, 
    {61,16}, {61,17}, {61,18}, {61,19}, {61,20}, {61,21}, {61,22}, {61,23}, 
    {61,24}, {61,30}, {61,25}, {61,26}, {61,27}, {61,28}, {61,29}, {61,31}, 
    {61,32}, {61,33}, {61,34}, {61,35}, {61,36}, {61,37}, {61,38}, {61,39}, 
    {61,40}, {61,45}, {61,41}, {61,42}, {61,43}, {61,44}, {61,46}, {61,47}, 
    {61,48}, {61,49}, {61,50}, {61,51}, {61,52}, {61,53}, {61,54}, {61,55}, 
    {61,56}, {61,57}, {61,58}, {61,59}, {61,60}, {61,61}, {61,62}, {61,63}, 
    {61,64}, {61,65}, {61,66}, {61,67}, {61,68}, {61,69}, {61,70}, {61,71}, 
    {61,72}, {61,73}, {61,74}, {61,75}, {61,76}, {61,77}, {61,78}, {61,81}, 
    {61,79}, {61,80}, {61,82}, {61,83}, {61,84}, {61,85}, {61,86}, {61,87}, 
    {61,88}, {61,89}, {61,90}, {61,91}, {61,92}, {61,93}, {62,0}, {62,1}, 
    {62,2}, {62,3}, {62,4}, {62,5}, {62,6}, {62,7}, {62,8}, {62,9}, {62,10}, 
    {62,11}, {62,12}, {62,13}, {62,14}, {62,15}, {62,17}, {62,16}, {62,18}, 
    {62,19}, {62,20}, {62,21}, {62,22}, {62,23}, {62,24}, {62,25}, {62,26}, 
    {62,27}, {62,28}, {62,29}, {62,30}, {62,31}, {62,32}, {62,33}, {62,34}, 
    {62,35}, {62,36}, {62,37}, {62,38}, {62,39}, {62,40}, {62,41}, {62,42}, 
    {62,43}, {62,44}, {62,45}, {62,46}, {62,47}, {62,48}, {62,49}, {62,50}, 
    {62,51}, {62,52}, {62,53}, {62,54}, {62,55}, {62,56}, {62,57}, {62,58}, 
    {62,59}, {62,60}, {62,78}, {62,61}, {62,62}, {62,63}, {62,64}, {62,65}, 
    {62,66}, {62,67}, {62,68}, {62,69}, {62,70}, {62,71}, {62,72}, {62,73}, 
    {62,74}, {62,75}, {62,76}, {62,77}, {62,79}, {62,80}, {62,81}, {62,82}, 
    {62,83}, {62,84}, {62,85}, {62,86}, {62,87}, {62,88}, {62,89}, {62,90}, 
    {62,91}, {62,92}, {62,93}, {63,0}, {63,1}, {63,2}, {63,3}, {63,4}, 
    {63,5}, {63,6}, {63,7}, {63,8}, {63,9}, {63,10}, {63,11}, {63,12}, 
    {63,13}, {63,14}, {63,15}, {63,16}, {63,17}, {63,18}, {63,19}, {63,20}, 
    {63,21}, {63,22}, {63,23}, {63,24}, {63,25}, {63,26}, {63,27}, {63,28}, 
    {63,29}, {63,30}, {63,31}, {63,32}, {63,33}, {63,34}, {63,35}, {63,36}, 
    {63,37}, {63,38}, {63,39}, {63,40}, {63,41}, {63,42}, {63,43}, {63,44}, 
    {63,45}, {63,46}, {63,47}, {63,48}, {63,49}, {63,50}, {63,51}, {63,52}, 
    {63,53}, {63,54}, {63,55}, {63,56}, {63,57}, {63,58}, {63,59}, {63,60}, 
    {63,67}, {63,61}, {63,62}, {63,63}, {63,64}, {63,65}, {63,66}, {63,68}, 
    {63,69}, {63,70}, {63,71}, {63,72}, {63,73}, {63,74}, {63,75}, {63,76}, 
    {63,77}, {63,78}, {63,79}, {63,80}, {63,81}, {63,82}, {63,83}, {63,84}, 
    {63,85}, {63,86}, {63,87}, {63,88}, {63,89}, {63,90}, {63,91}, {63,92}, 
    {63,93}, {64,0}, {64,1}, {64,2}, {64,3}, {64,4}, {64,5}, {64,6}, {64,7}, 
    {64,8}, {64,9}, {64,10}, {64,11}, {64,12}, {64,13}, {64,14}, {64,15}, 
    {64,16}, {64,17}, {64,18}, {64,19}, {64,20}, {64,21}, {64,22}, {64,23}, 
    {64,24}, {64,25}, {64,26}, {64,27}, {64,28}, {64,29}, {64,30}, {64,31}, 
    {64,32}, {64,33}, {64,34}, {64,35}, {64,36}, {64,37}, {64,38}, {64,39}, 
    {64,40}, {64,41}, {64,42}, {64,43}, {64,44}, {64,45}, {64,46}, {64,47}, 
    {64,48}, {64,49}, {64,51}, {64,52}, {64,53}, {64,50}, {64,54}, {64,55}, 
    {64,56}, {64,57}, {64,58}, {64,59}, {64,60}, {64,61}, {64,62}, {64,63}, 
    {64,64}, {64,65}, {64,66}, {64,67}, {64,68}, {64,69}, {64,70}, {64,71}, 
    {64,72}, {64,73}, {64,74}, {64,75}, {64,76}, {64,77}, {64,78}, {64,79}, 
    {64,80}, {64,81}, {64,82}, {64,83}, {64,84}, {64,85}, {64,86}, {64,87}, 
    {64,88}, {64,89}, {64,90}, {64,92}, {64,93}, {65,0}, {65,1}, {65,2}, 
    {65,3}, {64,91}, {65,12}, {65,4}, {65,5}, {65,6}, {65,7}, {65,8}, {65,9}, 
    {65,10}, {65,11}, {65,14}, {65,15}, {65,16}, {65,17}, {65,13}, {65,18}, 
    {65,19}, {65,20}, {65,21}, {65,22}, {65,23}, {65,24}, {65,25}, {65,26}, 
    {65,27}, {65,28}, {65,29}, {65,30}, {65,31}, {65,32}, {65,33}, {65,34}, 
    {65,36}, {65,37}, {65,35}, {65,38}, {65,39}, {65,40}, {65,41}, {65,42}, 
    {65,43}, {65,44}, {65,45}, {65,46}, {65,47}, {65,48}, {65,49}, {65,50}, 
    {65,51}, {65,52}, {65,53}, {65,54}, {65,55}, {65,56}, {65,57}, {65,58}, 
    {65,59}, {65,60}, {65,61}, {65,62}, {65,63}, {65,64}, {65,65}, {65,66}, 
    {65,67}, {65,68}, {65,69}, {65,70}, {65,71}, {65,72}, {65,73}, {65,74}, 
    {65,75}, {65,76}, {65,77}, {65,78}, {65,79}, {65,80}, {65,81}, {65,82}, 
    {65,83}, {65,84}, {65,85}, {65,86}, {65,87}, {65,88}, {65,89}, {65,90}, 
    {65,91}, {65,92}, {65,93}, {66,0}, {66,1}, {66,2}, {66,3}, {66,4}, 
    {66,5}, {66,6}, {66,7}, {66,8}, {66,9}, {66,10}, {66,11}, {66,12}, 
    {66,13}, {66,14}, {66,15}, {66,16}, {66,17}, {66,18}, {66,19}, {66,20}, 
    {66,21}, {66,22}, {66,23}, {66,24}, {66,25}, {66,26}, {66,27}, {66,28}, 
    {66,29}, {66,30}, {66,31}, {66,32}, {66,33}, {66,34}, {66,35}, {66,36}, 
    {66,37}, {66,38}, {66,39}, {66,40}, {66,41}, {66,42}, {66,43}, {66,44}, 
    {66,45}, {66,46}, {66,47}, {66,48}, {66,49}, {66,50}, {66,51}, {66,52}, 
    {66,53}, {66,54}, {66,55}, {66,56}, {66,57}, {66,58}, {66,59}, {66,60}, 
    {66,61}, {66,62}, {66,63}, {66,64}, {66,65}, {66,66}, {66,67}, {66,68}, 
    {66,69}, {66,70}, {66,71}, {66,72}, {66,73}, {66,74}, {66,75}, {66,76}, 
    {66,77}, {66,78}, {66,79}, {66,80}, {66,81}, {66,82}, {66,83}, {66,84}, 
    {66,85}, {66,86}, {66,87}, {66,88}, {66,89}, {66,90}, {66,91}, {66,92}, 
    {66,93}, {67,0}, {67,1}, {67,2}, {67,3}, {67,4}, {67,5}, {67,6}, {67,7}, 
    {67,8}, {67,9}, {67,10}, {67,11}, {67,12}, {67,13}, {67,14}, {67,15}, 
    {67,16}, {67,17}, {67,18}, {67,19}, {67,20}, {67,21}, {67,22}, {67,23}, 
    {67,24}, {67,25}, {67,26}, {67,27}, {67,28}, {67,29}, {67,30}, {67,31}, 
    {67,32}, {67,33}, {67,34}, {67,35}, {67,36}, {67,37}, {67,38}, {67,39}, 
    {67,40}, {67,41}, {67,42}, {67,43}, {67,44}, {67,45}, {67,46}, {67,47}, 
    {67,48}, {67,49}, {67,50}, {67,51}, {67,52}, {67,53}, {67,54}, {67,55}, 
    {67,56}, {67,57}, {67,58}, {67,59}, {67,60}, {67,61}, {67,62}, {67,63}, 
    {67,64}, {67,65}, {67,66}, {67,67}, {67,68}, {67,69}, {67,70}, {67,71}, 
    {67,72}, {67,73}, {67,74}, {67,75}, {67,76}, {67,77}, {67,78}, {67,79}, 
    {67,80}, {67,81}, {67,82}, {67,83}, {67,84}, {67,85}, {67,86}, {67,87}, 
    {67,88}, {67,89}, {67,90}, {67,91}, {67,92}, {67,93}, {68,0}, {68,1}, 
    {68,2}, {68,3}, {68,4}, {68,5}, {68,6}, {68,7}, {68,8}, {68,9}, {68,10}, 
    {68,11}, {68,12}, {68,13}, {68,14}, {68,15}, {68,16}, {68,17}, {68,18}, 
    {68,19}, {68,20}, {68,26}, {68,21}, {68,22}, {68,23}, {68,24}, {68,25}, 
    {68,27}, {68,28}, {68,29}, {68,30}, {68,31}, {68,32}, {68,33}, {68,34}, 
    {68,35}, {68,36}, {68,37}, {68,38}, {68,39}, {68,40}, {68,41}, {68,42}, 
    {68,43}, {68,44}, {68,46}, {68,47}, {68,45}, {68,48}, {68,49}, {68,50}, 
    {68,51}, {68,52}, {68,53}, {68,54}, {68,55}, {68,56}, {68,57}, {68,58}, 
    {68,59}, {68,60}, {68,61}, {68,62}, {68,63}, {68,64}, {68,65}, {68,66}, 
    {68,67}, {68,68}, {68,69}, {68,71}, {68,70}, {68,72}, {68,73}, {68,74}, 
    {68,75}, {68,76}, {68,77}, {68,78}, {68,79}, {68,80}, {68,81}, {68,82}, 
    {68,83}, {68,84}, {68,85}, {68,86}, {68,87}, {68,88}, {68,89}, {68,91}, 
    {68,90}, {68,92}, {68,93}, {69,0}, {69,1}, {69,2}, {69,3}, {69,4}, 
    {69,5}, {69,6}, {69,7}, {69,8}, {69,9}, {69,10}, {69,11}, {69,12}, 
    {69,13}, {69,14}, {69,15}, {69,16}, {69,17}, {69,18}, {69,19}, {69,20}, 
    {69,21}, {69,22}, {69,23}, {69,24}, {69,25}, {69,26}, {69,27}, {69,28}, 
    {69,29}, {69,30}, {69,31}, {69,32}, {69,33}, {69,34}, {69,35}, {69,36}, 
    {69,37}, {69,38}, {69,39}, {69,40}, {69,41}, {69,42}, {69,43}, {69,44}, 
    {69,45}, {69,46}, {69,47}, {69,48}, {69,49}, {69,50}, {69,51}, {69,52}, 
    {69,53}, {69,54}, {69,55}, {69,56}, {69,57}, {69,58}, {69,59}, {69,60}, 
    {69,61}, {69,62}, {69,63}, {69,64}, {69,65}, {69,66}, {69,67}, {69,68}, 
    {69,69}, {69,70}, {69,71}, {69,72}, {69,73}, {69,74}, {69,75}, {69,76}, 
    {69,77}, {69,78}, {69,79}, {69,80}, {69,81}, {69,82}, {69,84}, {69,85}, 
    {69,86}, {69,87}, {69,88}, {69,89}, {69,90}, {69,91}, {69,92}, {69,93}, 
    {70,0}, {70,1}, {70,2}, {70,3}, {70,4}, {70,5}, {70,6}, {70,7}, {70,8}, 
    {70,9}, {70,10}, {70,11}, {70,12}, {70,13}, {70,14}, {70,15}, {70,16}, 
    {70,17}, {70,18}, {70,19}, {70,20}, {70,21}, {70,22}, {70,23}, {70,24}, 
    {70,25}, {70,26}, {70,27}, {70,28}, {70,29}, {70,30}, {70,31}, {70,32}, 
    {70,33}, {70,34}, {70,35}, {70,36}, {70,37}, {70,38}, {70,39}, {70,40}, 
    {70,41}, {70,42}, {70,43}, {70,44}, {70,45}, {70,46}, {70,47}, {70,48}, 
    {70,49}, {70,50}, {70,51}, {70,52}, {70,53}, {70,54}, {70,55}, {70,56}, 
    {70,57}, {70,58}, {70,59}, {70,60}, {70,61}, {70,62}, {70,63}, {70,64}, 
    {70,65}, {70,66}, {70,67}, {70,68}, {70,69}, {70,73}, {70,70}, {70,71}, 
    {70,72}, {70,74}, {70,75}, {70,76}, {70,77}, {70,78}, {70,79}, {70,80}, 
    {70,81}, {70,82}, {70,83}, {70,85}, {70,86}, {70,87}, {70,88}, {70,84}, 
    {70,89}, {70,90}, {70,91}, {70,92}, {71,7}, {70,93}, {71,0}, {71,1}, 
    {71,2}, {71,3}, {71,4}, {71,5}, {71,6}, {71,8}, {71,9}, {71,10}, {71,11}, 
    {71,12}, {71,13}, {71,14}, {71,15}, {71,16}, {71,17}, {71,18}, {71,19}, 
    {71,20}, {71,21}, {71,22}, {71,23}, {71,24}, {71,25}, {71,26}, {71,27}, 
    {71,28}, {71,29}, {71,30}, {71,31}, {71,32}, {71,33}, {71,34}, {71,35}, 
    {71,36}, {71,37}, {71,38}, {71,39}, {71,40}, {71,41}, {71,42}, {71,43}, 
    {71,44}, {71,45}, {71,46}, {71,47}, {71,48}, {71,49}, {71,50}, {71,51}, 
    {71,52}, {71,53}, {71,54}, {71,55}, {71,56}, {71,57}, {71,58}, {71,59}, 
    {71,60}, {71,61}, {71,62}, {71,63}, {71,64}, {71,65}, {71,66}, {71,67}, 
    {71,68}, {71,69}, {71,70}, {71,71}, {71,72}, {71,73}, {71,74}, {71,75}, 
    {71,76}, {71,77}, {71,78}, {71,79}, {71,80}, {71,81}, {71,82}, {71,83}, 
    {71,84}, {71,85}, {71,86}, {71,87}, {71,88}, {71,89}, {71,90}, {71,91}, 
    {71,92}, {71,93}, {72,0}, {72,1}, {72,2}, {72,3}, {72,4}, {72,5}, {72,6}, 
    {72,7}, {72,8}, {72,9}, {72,10}, {72,11}, {72,12}, {72,13}, {72,14}, 
    {72,15}, {72,16}, {72,17}, {72,18}, {72,19}, {72,20}, {72,21}, {72,22}, 
    {72,23}, {72,24}, {72,25}, {72,26}, {72,27}, {72,28}, {72,29}, {72,30}, 
    {72,31}, {72,32}, {72,33}, {72,34}, {72,35}, {72,36}, {72,37}, {72,38}, 
    {72,39}, {72,40}, {72,41}, {72,43}, {72,44}, {72,42}, {72,45}, {72,46}, 
    {72,47}, {72,48}, {72,49}, {72,50}, {72,51}, {72,52}, {72,53}, {72,54}, 
    {72,55}, {72,56}, {72,57}, {72,58}, {72,59}, {72,60}, {72,61}, {72,62}, 
    {72,63}, {72,64}, {72,65}, {72,66}, {72,67}, {72,68}, {72,69}, {72,70}, 
    {72,71}, {72,72}, {72,73}, {72,74}, {72,75}, {72,76}, {72,77}, {72,78}, 
    {72,79}, {72,80}, {72,81}, {72,82}, {72,83}, {72,84}, {72,85}, {72,86}, 
    {72,87}, {72,88}, {72,89}, {72,90}, {72,91}, {72,92}, {72,93}, {73,0}, 
    {73,1}, {73,2}, {73,3}, {73,4}, {73,5}, {73,6}, {73,7}, {73,8}, {73,9}, 
    {73,10}, {73,11}, {73,12}, {73,13}, {73,14}, {73,15}, {73,16}, {73,17}, 
    {73,18}, {73,19}, {73,20}, {73,21}, {73,22}, {73,23}, {73,24}, {73,25}, 
    {73,26}, {73,27}, {73,28}, {73,29}, {73,30}, {73,31}, {73,32}, {73,33}, 
    {73,34}, {73,35}, {73,36}, {73,37}, {73,38}, {73,39}, {73,40}, {73,41}, 
    {73,42}, {73,43}, {73,44}, {73,45}, {73,46}, {73,47}, {73,48}, {73,49}, 
    {73,50}, {73,51}, {73,52}, {73,53}, {73,54}, {73,55}, {73,56}, {73,57}, 
    {73,58}, {73,59}, {73,60}, {73,61}, {73,62}, {73,63}, {73,64}, {73,65}, 
    {73,66}, {73,67}, {73,68}, {73,69}, {73,70}, {73,71}, {73,72}, {73,73}, 
    {73,74}, {73,75}, {73,76}, {73,77}, {73,78}, {73,79}, {73,80}, {73,81}, 
    {73,82}, {73,83}, {73,84}, {73,85}, {73,86}, {73,87}, {73,88}, {73,89}, 
    {73,90}, {73,91}, {73,92}, {73,93}, {74,0}, {74,1}, {74,2}, {74,3}, 
    {74,4}, {74,5}, {74,6}, {74,7}, {74,8}, {74,9}, {74,10}, {74,11}, {74,12}, 
    {74,13}, {74,14}, {74,15}, {74,16}, {74,17}, {74,18}, {74,19}, {74,20}, 
    {74,21}, {74,22}, {74,23}, {74,24}, {74,25}, {74,26}, {74,27}, {74,28}, 
    {74,29}, {74,30}, {74,31}, {74,32}, {74,33}, {74,34}, {74,35}, {74,36}, 
    {74,37}, {74,38}, {74,39}, {74,40}, {74,47}, {74,41}, {74,42}, {74,43}, 
    {74,44}, {74,49}, {74,45}, {74,46}, {74,48}, {74,50}, {74,51}, {74,52}, 
    {74,53}, {74,54}, {74,55}, {74,56}, {74,57}, {74,58}, {74,59}, {74,61}, 
    {74,60}, {74,62}, {74,63}, {74,64}, {74,65}, {74,66}, {74,67}, {74,68}, 
    {74,69}, {74,70}, {74,71}, {74,72}, {74,73}, {74,74}, {74,76}, {74,77}, 
    {74,78}, {74,75}, {74,79}, {74,80}, {74,81}, {74,82}, {74,83}, {74,85}, 
    {74,84}, {74,86}, {74,87}, {74,88}, {74,89}, {74,90}, {74,91}, {74,92}, 
    {74,93}, {75,0}, {75,1}, {75,2}, {75,3}, {75,4}, {75,5}, {75,6}, {75,7}, 
    {75,8}, {75,9}, {75,10}, {75,11}, {75,12}, {75,13}, {75,14}, {75,15}, 
    {75,16}, {75,17}, {75,18}, {75,19}, {75,20}, {75,21}, {75,22}, {75,23}, 
    {75,24}, {75,25}, {75,26}, {75,27}, {75,28}, {75,29}, {75,30}, {75,31}, 
    {75,32}, {75,33}, {75,34}, {75,35}, {75,36}, {75,37}, {75,38}, {75,39}, 
    {75,40}, {75,41}, {75,42}, {75,43}, {75,45}, {75,46}, {75,44}, {75,47}, 
    {75,48}, {75,49}, {75,50}, {75,51}, {75,52}, {75,53}, {75,54}, {75,55}, 
    {75,56}, {75,57}, {75,58}, {75,59}, {75,60}, {75,61}, {75,62}, {75,63}, 
    {75,64}, {75,65}, {75,66}, {75,67}, {75,68}, {75,69}, {75,70}, {75,71}, 
    {75,72}, {75,73}, {75,74}, {75,75}, {75,76}, {75,77}, {75,78}, {75,79}, 
    {75,80}, {75,81}, {75,82}, {75,83}, {75,84}, {75,85}, {75,86}, {75,87}, 
    {75,88}, {75,89}, {75,90}, {75,91}, {75,92}, {75,93}, {76,0}, {76,1}, 
    {76,2}, {76,3}, {76,4}, {76,5}, {76,6}, {76,7}, {76,8}, {76,9}, {76,10}, 
    {76,11}, {76,12}, {76,13}, {76,14}, {76,15}, {76,16}, {76,17}, {76,18}, 
    {76,19}, {76,20}, {76,21}, {76,22}, {76,23}, {76,24}, {76,25}, {76,26}, 
    {76,27}, {76,28}, {76,29}, {76,30}, {76,31}, {76,32}, {76,33}, {76,34}, 
    {76,35}, {76,36}, {76,37}, {76,38}, {76,39}, {76,40}, {76,41}, {76,42}, 
    {76,43}, {76,44}, {76,45}, {76,46}, {76,47}, {76,48}, {76,49}, {76,50}, 
    {76,51}, {76,52}, {76,53}, {76,54}, {76,55}, {76,56}, {76,57}, {76,58}, 
    {76,59}, {76,60}, {76,61}, {76,62}, {76,63}, {76,64}, {76,65}, {76,66}
};

/* This returns ERROR if the code point doesn't exist. */
long int jisx0212_to_unicode(int r, int c)
{
    assert(r >= 0 && r < 94);
    assert(c >= 0 && c < 94);
    return jisx0212_forward[r][c];
}

/* This one returns true on success, false if the code point doesn't exist. */
bool unicode_to_jisx0212(long int unicode, int *r, int *c)
{
    int rr, cc;
    long int uu;
    int i, j, k;

    i = -1;
    j = lenof(jisx0212_backward);
    while (j - i > 1) {
	k = (i + j) / 2;
	rr = jisx0212_backward[k].r;
	cc = jisx0212_backward[k].c;
	uu = jisx0212_forward[rr][cc];
	if (unicode > uu)
	    i = k;
	else if (unicode < uu)
	    j = k;
	else {
	    *r = rr;
	    *c = cc;
	    return true;
	}
    }
    return false;
}

#ifdef TESTMODE

#include <stdio.h>

int main(void)
{
    int r, c, rr, cc, ret;
    long int u, uu;

    for (r = 0; r < 94; r++) {
	for (c = 0; c < 94; c++) {
	    u = jisx0212_to_unicode(r, c);
	    if (u != ERROR) {
		ret = unicode_to_jisx0212(u, &rr, &cc);
		if (!ret)
		    printf("(%d,%d) -> U-%08lx but didn't convert back\n",
			   r, c, u);
		else if (rr != r || cc != c)
		    printf("(%d,%d) -> U-%08lx -> (%d,%d)\n",
			   r, c, u, rr, cc);
	    }
	}
    }

    for (u = 0; u < 0x10000L; u++) {
	ret = unicode_to_jisx0212(u, &r, &c);
	if (ret) {
	    uu = jisx0212_to_unicode(r, c);
	    if (uu == ERROR)
		printf("U-%08lx -> (%d,%d) but didn't convert back\n",
		       u, r, c);
	    else if (uu != u)
		printf("U-%08lx -> (%d,%d) -> U-%08lx\n", u, r, c, uu);
	}
    }

    return 0;
}

#endif
