/* network-view.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from network-view.vala, do not modify */

/* network-view.vala
 *
 * Copyright (C) 2023–2025 Markus Göllnitz
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Markus Göllnitz <camelcasenick@bewares.it>
 */

#include <adwaita.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <NetworkManager.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>

#define USAGE_NETWORK_VIEW_DAY ((gint64) ((24 * 60) * 60))
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define USAGE_TYPE_VIEW (usage_view_get_type ())
#define USAGE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_VIEW, UsageView))
#define USAGE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_VIEW, UsageViewClass))
#define USAGE_IS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_VIEW))
#define USAGE_IS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_VIEW))
#define USAGE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_VIEW, UsageViewClass))

typedef struct _UsageView UsageView;
typedef struct _UsageViewClass UsageViewClass;
typedef struct _UsageViewPrivate UsageViewPrivate;

#define USAGE_TYPE_NETWORK_VIEW (usage_network_view_get_type ())
#define USAGE_NETWORK_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_NETWORK_VIEW, UsageNetworkView))
#define USAGE_NETWORK_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_NETWORK_VIEW, UsageNetworkViewClass))
#define USAGE_IS_NETWORK_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_NETWORK_VIEW))
#define USAGE_IS_NETWORK_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_NETWORK_VIEW))
#define USAGE_NETWORK_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_NETWORK_VIEW, UsageNetworkViewClass))

typedef struct _UsageNetworkView UsageNetworkView;
typedef struct _UsageNetworkViewClass UsageNetworkViewClass;
typedef struct _UsageNetworkViewPrivate UsageNetworkViewPrivate;
enum  {
	USAGE_NETWORK_VIEW_0_PROPERTY,
	USAGE_NETWORK_VIEW_NUM_PROPERTIES
};
static GParamSpec* usage_network_view_properties[USAGE_NETWORK_VIEW_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define VNSTAT_TYPE_INTERFACE (vnstat_interface_get_type ())
#define VNSTAT_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VNSTAT_TYPE_INTERFACE, VnstatInterface))
#define VNSTAT_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VNSTAT_TYPE_INTERFACE, VnstatInterfaceClass))
#define VNSTAT_IS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VNSTAT_TYPE_INTERFACE))
#define VNSTAT_IS_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VNSTAT_TYPE_INTERFACE))
#define VNSTAT_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VNSTAT_TYPE_INTERFACE, VnstatInterfaceClass))

typedef struct _VnstatInterface VnstatInterface;
typedef struct _VnstatInterfaceClass VnstatInterfaceClass;

#define VNSTAT_TYPE_TRAFFIC_DATA_POINT (vnstat_traffic_data_point_get_type ())
typedef struct _VnstatTrafficDataPoint VnstatTrafficDataPoint;
typedef enum  {
	VNSTAT_MODE_HOURLY = 'h',
	VNSTAT_MODE_DAILY = 'd',
	VNSTAT_MODE_MONTHLY = 'm',
	VNSTAT_MODE_TOP = 't'
} VnstatMode;

#define VNSTAT_TYPE_MODE (vnstat_mode_get_type ())
#define _vnstat_interface_unref0(var) ((var == NULL) ? NULL : (var = (vnstat_interface_unref (var), NULL)))

#define USAGE_TYPE_NETWORK_INTERFACE_GRAPH (usage_network_interface_graph_get_type ())
#define USAGE_NETWORK_INTERFACE_GRAPH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_NETWORK_INTERFACE_GRAPH, UsageNetworkInterfaceGraph))
#define USAGE_NETWORK_INTERFACE_GRAPH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_NETWORK_INTERFACE_GRAPH, UsageNetworkInterfaceGraphClass))
#define USAGE_IS_NETWORK_INTERFACE_GRAPH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_NETWORK_INTERFACE_GRAPH))
#define USAGE_IS_NETWORK_INTERFACE_GRAPH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_NETWORK_INTERFACE_GRAPH))
#define USAGE_NETWORK_INTERFACE_GRAPH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_NETWORK_INTERFACE_GRAPH, UsageNetworkInterfaceGraphClass))

typedef struct _UsageNetworkInterfaceGraph UsageNetworkInterfaceGraph;
typedef struct _UsageNetworkInterfaceGraphClass UsageNetworkInterfaceGraphClass;
#define _vnstat_traffic_data_point_free0(var) ((var == NULL) ? NULL : (var = (vnstat_traffic_data_point_free (var), NULL)))

#define USAGE_TYPE_GRAPH_POINT (usage_graph_point_get_type ())
typedef struct _UsageGraphPoint UsageGraphPoint;

#define USAGE_TYPE_GRAPH (usage_graph_get_type ())
#define USAGE_GRAPH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_GRAPH, UsageGraph))
#define USAGE_GRAPH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_GRAPH, UsageGraphClass))
#define USAGE_IS_GRAPH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_GRAPH))
#define USAGE_IS_GRAPH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_GRAPH))
#define USAGE_GRAPH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_GRAPH, UsageGraphClass))

typedef struct _UsageGraph UsageGraph;
typedef struct _UsageGraphClass UsageGraphClass;

struct _UsageView {
	AdwBreakpointBin parent_instance;
	UsageViewPrivate * priv;
	gchar* title;
	gchar* icon_name;
	GtkWidget* switcher_widget;
	gboolean search_available;
};

struct _UsageViewClass {
	AdwBreakpointBinClass parent_class;
	void (*set_search_text) (UsageView* self, const gchar* query);
	gboolean (*prerequisite_fulfilled) (UsageView* self);
};

struct _UsageNetworkView {
	UsageView parent_instance;
	UsageNetworkViewPrivate * priv;
};

struct _UsageNetworkViewClass {
	UsageViewClass parent_class;
};

struct _UsageNetworkViewPrivate {
	AdwViewStack* interface_graphs;
};

struct _VnstatTrafficDataPoint {
	gint64 timestamp;
	gdouble download;
	gdouble upload;
};

struct _UsageGraphPoint {
	gint64 timestamp;
	gdouble level;
};

static gint UsageNetworkView_private_offset;
static gpointer usage_network_view_parent_class = NULL;

VALA_EXTERN GType usage_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageView, g_object_unref)
VALA_EXTERN GType usage_network_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageNetworkView, g_object_unref)
VALA_EXTERN gboolean usage_view_prerequisite_fulfilled (UsageView* self);
VALA_EXTERN UsageNetworkView* usage_network_view_new (void);
VALA_EXTERN UsageNetworkView* usage_network_view_construct (GType object_type);
VALA_EXTERN UsageView* usage_view_construct (GType object_type);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
VALA_EXTERN gpointer vnstat_interface_ref (gpointer instance);
VALA_EXTERN void vnstat_interface_unref (gpointer instance);
VALA_EXTERN GParamSpec* vnstat_param_spec_interface (const gchar* name,
                                         const gchar* nick,
                                         const gchar* blurb,
                                         GType object_type,
                                         GParamFlags flags);
VALA_EXTERN void vnstat_value_set_interface (GValue* value,
                                 gpointer v_object);
VALA_EXTERN void vnstat_value_take_interface (GValue* value,
                                  gpointer v_object);
VALA_EXTERN gpointer vnstat_value_get_interface (const GValue* value);
VALA_EXTERN GType vnstat_interface_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VnstatInterface, vnstat_interface_unref)
VALA_EXTERN VnstatInterface** vnstat_list_interfaces (gint* result_length1);
VALA_EXTERN GType vnstat_traffic_data_point_get_type (void) G_GNUC_CONST ;
VALA_EXTERN VnstatTrafficDataPoint* vnstat_traffic_data_point_dup (const VnstatTrafficDataPoint* self);
VALA_EXTERN void vnstat_traffic_data_point_free (VnstatTrafficDataPoint* self);
VALA_EXTERN GType vnstat_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GList* vnstat_interface_get_traffic (VnstatInterface* self,
                                     VnstatMode mode);
VALA_EXTERN gboolean vnstat_interface_get_recently_used (VnstatInterface* self);
static void _vnstat_traffic_data_point_free0_ (gpointer var);
static inline void _g_list_free__vnstat_traffic_data_point_free0_ (GList* self);
VALA_EXTERN const gchar* vnstat_interface_get_name (VnstatInterface* self);
VALA_EXTERN GType usage_network_interface_graph_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageNetworkInterfaceGraph, g_object_unref)
VALA_EXTERN UsageNetworkInterfaceGraph* usage_network_interface_graph_new (void);
VALA_EXTERN UsageNetworkInterfaceGraph* usage_network_interface_graph_construct (GType object_type);
VALA_EXTERN GType usage_graph_point_get_type (void) G_GNUC_CONST ;
VALA_EXTERN UsageGraphPoint* usage_graph_point_dup (const UsageGraphPoint* self);
VALA_EXTERN void usage_graph_point_free (UsageGraphPoint* self);
VALA_EXTERN void usage_graph_point_init (UsageGraphPoint *self,
                             gint64 timestamp,
                             gdouble level);
VALA_EXTERN gpointer usage_graph_ref (gpointer instance);
VALA_EXTERN void usage_graph_unref (gpointer instance);
VALA_EXTERN GParamSpec* usage_param_spec_graph (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
VALA_EXTERN void usage_value_set_graph (GValue* value,
                            gpointer v_object);
VALA_EXTERN void usage_value_take_graph (GValue* value,
                             gpointer v_object);
VALA_EXTERN gpointer usage_value_get_graph (const GValue* value);
VALA_EXTERN GType usage_graph_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageGraph, usage_graph_unref)
VALA_EXTERN UsageGraph* usage_network_interface_graph_get_download_graph (UsageNetworkInterfaceGraph* self);
VALA_EXTERN void usage_graph_push_point (UsageGraph* self,
                             UsageGraphPoint* point);
VALA_EXTERN UsageGraph* usage_network_interface_graph_get_upload_graph (UsageNetworkInterfaceGraph* self);
VALA_EXTERN void usage_network_interface_graph_set_ranges (UsageNetworkInterfaceGraph* self,
                                               gint64 min_timestamp,
                                               gint64 max_timestamp,
                                               gint64 max_val);
static gboolean usage_network_view_real_prerequisite_fulfilled (UsageView* base);
VALA_EXTERN gboolean vnstat_test_exists (void);
static GObject * usage_network_view_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties);
static void usage_network_view_finalize (GObject * obj);
static GType usage_network_view_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
usage_network_view_get_instance_private (UsageNetworkView* self)
{
	return G_STRUCT_MEMBER_P (self, UsageNetworkView_private_offset);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gpointer
_vnstat_interface_ref0 (gpointer self)
{
	return self ? vnstat_interface_ref (self) : NULL;
}

static void
_vnstat_traffic_data_point_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (vnstat_traffic_data_point_free (var), NULL));
}

static inline void
_g_list_free__vnstat_traffic_data_point_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _vnstat_traffic_data_point_free0_);
}

static gpointer
_vnstat_traffic_data_point_dup0 (gpointer self)
{
	return self ? vnstat_traffic_data_point_dup (self) : NULL;
}

UsageNetworkView*
usage_network_view_construct (GType object_type)
{
	UsageNetworkView * self = NULL;
	GHashTable* devices = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	guint ethernet_count = 0U;
	guint wifi_count = 0U;
	guint p2p_count = 0U;
	guint modem_count = 0U;
	guint bt_count = 0U;
	gint _tmp54_ = 0;
	VnstatInterface** _tmp55_;
	GError* _inner_error0_ = NULL;
	self = (UsageNetworkView*) usage_view_construct (object_type);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_object_unref0_);
	devices = _tmp2_;
	ethernet_count = (guint) 0;
	wifi_count = (guint) 0;
	p2p_count = (guint) 0;
	modem_count = (guint) 0;
	bt_count = (guint) 0;
	{
		NMClient* nm_client = NULL;
		NMClient* _tmp3_;
		NMClient* _tmp4_;
		GPtrArray* _tmp5_;
		GPtrArray* _tmp6_;
		_tmp3_ = nm_client_new (NULL, &_inner_error0_);
		nm_client = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp4_ = nm_client;
		_tmp5_ = nm_client_get_devices (_tmp4_);
		_tmp6_ = _tmp5_;
		{
			GPtrArray* device_collection = NULL;
			guint device_index = 0U;
			device_collection = _tmp6_;
			for (device_index = 0; device_index < device_collection->len; device_index = device_index + 1) {
				NMDevice* _tmp7_;
				NMDevice* device = NULL;
				_tmp7_ = _g_object_ref0 ((NMDevice*) g_ptr_array_index (device_collection, device_index));
				device = _tmp7_;
				{
					gboolean _tmp8_ = FALSE;
					NMDevice* _tmp9_;
					gchar* _tmp10_;
					gchar* _tmp11_;
					gchar* _tmp12_;
					gboolean _tmp13_;
					gboolean _tmp30_ = FALSE;
					NMDevice* _tmp31_;
					gchar* _tmp32_;
					gchar* _tmp33_;
					gchar* _tmp34_;
					gboolean _tmp35_;
					_tmp9_ = device;
					g_object_get (_tmp9_, "interface", &_tmp10_, NULL);
					_tmp11_ = _tmp10_;
					_tmp12_ = _tmp11_;
					_tmp13_ = _tmp12_ != NULL;
					_g_free0 (_tmp12_);
					if (_tmp13_) {
						gboolean _tmp14_ = FALSE;
						GHashTable* _tmp15_;
						NMDevice* _tmp16_;
						gchar* _tmp17_;
						gchar* _tmp18_;
						gchar* _tmp19_;
						gboolean _tmp20_;
						_tmp15_ = devices;
						_tmp16_ = device;
						g_object_get (_tmp16_, "interface", &_tmp17_, NULL);
						_tmp18_ = _tmp17_;
						_tmp19_ = _tmp18_;
						_tmp20_ = !g_hash_table_contains (_tmp15_, _tmp19_);
						_g_free0 (_tmp19_);
						if (_tmp20_) {
							_tmp14_ = TRUE;
						} else {
							NMDevice* _tmp21_;
							gboolean _tmp22_;
							gboolean _tmp23_;
							_tmp21_ = device;
							_tmp22_ = nm_device_get_managed (_tmp21_);
							_tmp23_ = _tmp22_;
							_tmp14_ = _tmp23_;
						}
						_tmp8_ = _tmp14_;
					} else {
						_tmp8_ = FALSE;
					}
					if (_tmp8_) {
						GHashTable* _tmp24_;
						NMDevice* _tmp25_;
						gchar* _tmp26_;
						gchar* _tmp27_;
						NMDevice* _tmp28_;
						NMDevice* _tmp29_;
						_tmp24_ = devices;
						_tmp25_ = device;
						g_object_get (_tmp25_, "interface", &_tmp26_, NULL);
						_tmp27_ = _tmp26_;
						_tmp28_ = device;
						_tmp29_ = _g_object_ref0 (_tmp28_);
						g_hash_table_insert (_tmp24_, _tmp27_, _tmp29_);
					}
					_tmp31_ = device;
					g_object_get (_tmp31_, "ip-interface", &_tmp32_, NULL);
					_tmp33_ = _tmp32_;
					_tmp34_ = _tmp33_;
					_tmp35_ = _tmp34_ != NULL;
					_g_free0 (_tmp34_);
					if (_tmp35_) {
						gboolean _tmp36_ = FALSE;
						GHashTable* _tmp37_;
						NMDevice* _tmp38_;
						gchar* _tmp39_;
						gchar* _tmp40_;
						gchar* _tmp41_;
						gboolean _tmp42_;
						_tmp37_ = devices;
						_tmp38_ = device;
						g_object_get (_tmp38_, "ip-interface", &_tmp39_, NULL);
						_tmp40_ = _tmp39_;
						_tmp41_ = _tmp40_;
						_tmp42_ = !g_hash_table_contains (_tmp37_, _tmp41_);
						_g_free0 (_tmp41_);
						if (_tmp42_) {
							_tmp36_ = TRUE;
						} else {
							NMDevice* _tmp43_;
							gboolean _tmp44_;
							gboolean _tmp45_;
							_tmp43_ = device;
							_tmp44_ = nm_device_get_managed (_tmp43_);
							_tmp45_ = _tmp44_;
							_tmp36_ = _tmp45_;
						}
						_tmp30_ = _tmp36_;
					} else {
						_tmp30_ = FALSE;
					}
					if (_tmp30_) {
						GHashTable* _tmp46_;
						NMDevice* _tmp47_;
						gchar* _tmp48_;
						gchar* _tmp49_;
						NMDevice* _tmp50_;
						NMDevice* _tmp51_;
						_tmp46_ = devices;
						_tmp47_ = device;
						g_object_get (_tmp47_, "ip-interface", &_tmp48_, NULL);
						_tmp49_ = _tmp48_;
						_tmp50_ = device;
						_tmp51_ = _g_object_ref0 (_tmp50_);
						g_hash_table_insert (_tmp46_, _tmp49_, _tmp51_);
					}
					_g_object_unref0 (device);
				}
			}
		}
		_g_object_unref0 (nm_client);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp52_;
		const gchar* _tmp53_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp52_ = _error_;
		_tmp53_ = _tmp52_->message;
		g_info ("network-view.vala:52: Error with NetworkManager: %s\n", _tmp53_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_hash_table_unref0 (devices);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp55_ = vnstat_list_interfaces (&_tmp54_);
	{
		VnstatInterface** iface_collection = NULL;
		gint iface_collection_length1 = 0;
		gint _iface_collection_size_ = 0;
		gint iface_it = 0;
		iface_collection = _tmp55_;
		iface_collection_length1 = _tmp54_;
		for (iface_it = 0; iface_it < iface_collection_length1; iface_it = iface_it + 1) {
			VnstatInterface* _tmp56_;
			VnstatInterface* iface = NULL;
			_tmp56_ = _vnstat_interface_ref0 (iface_collection[iface_it]);
			iface = _tmp56_;
			{
				GList* interface_daily_data = NULL;
				VnstatInterface* _tmp57_;
				GList* _tmp58_;
				VnstatInterface* _tmp59_;
				gboolean _tmp60_;
				gboolean _tmp61_;
				gchar* interface_name = NULL;
				VnstatInterface* _tmp62_;
				const gchar* _tmp63_;
				const gchar* _tmp64_;
				gchar* _tmp65_;
				NMDevice* device = NULL;
				GHashTable* _tmp66_;
				const gchar* _tmp67_;
				gconstpointer _tmp68_;
				NMDevice* _tmp69_;
				UsageNetworkInterfaceGraph* interface_view = NULL;
				UsageNetworkInterfaceGraph* _tmp70_;
				gchar* title = NULL;
				const gchar* _tmp71_;
				gchar* _tmp72_;
				NMDevice* _tmp73_;
				gint64 start_timestamp = 0LL;
				gdouble max_val = 0.0;
				GList* _tmp122_;
				AdwViewStack* _tmp141_;
				UsageNetworkInterfaceGraph* _tmp142_;
				const gchar* _tmp143_;
				const gchar* _tmp144_;
				UsageNetworkInterfaceGraph* _tmp145_;
				_tmp57_ = iface;
				_tmp58_ = vnstat_interface_get_traffic (_tmp57_, VNSTAT_MODE_DAILY);
				interface_daily_data = _tmp58_;
				_tmp59_ = iface;
				_tmp60_ = vnstat_interface_get_recently_used (_tmp59_);
				_tmp61_ = _tmp60_;
				if (!_tmp61_) {
					(interface_daily_data == NULL) ? NULL : (interface_daily_data = (_g_list_free__vnstat_traffic_data_point_free0_ (interface_daily_data), NULL));
					_vnstat_interface_unref0 (iface);
					continue;
				}
				_tmp62_ = iface;
				_tmp63_ = vnstat_interface_get_name (_tmp62_);
				_tmp64_ = _tmp63_;
				_tmp65_ = g_strdup (_tmp64_);
				interface_name = _tmp65_;
				_tmp66_ = devices;
				_tmp67_ = interface_name;
				_tmp68_ = g_hash_table_lookup (_tmp66_, _tmp67_);
				_tmp69_ = _g_object_ref0 ((NMDevice*) _tmp68_);
				device = _tmp69_;
				_tmp70_ = usage_network_interface_graph_new ();
				g_object_ref_sink (_tmp70_);
				interface_view = _tmp70_;
				_tmp71_ = interface_name;
				_tmp72_ = g_strdup (_tmp71_);
				title = _tmp72_;
				_tmp73_ = device;
				if (_tmp73_ == NULL) {
					const gchar* _tmp74_;
					_tmp74_ = interface_name;
					g_warning ("network-view.vala:69: skipping unknown interface “%s”", _tmp74_);
					_g_free0 (title);
					_g_object_unref0 (interface_view);
					_g_object_unref0 (device);
					_g_free0 (interface_name);
					(interface_daily_data == NULL) ? NULL : (interface_daily_data = (_g_list_free__vnstat_traffic_data_point_free0_ (interface_daily_data), NULL));
					_vnstat_interface_unref0 (iface);
					continue;
				} else {
					NMDevice* _tmp75_;
					NMDeviceType _tmp76_;
					NMDeviceType _tmp77_;
					_tmp75_ = device;
					_tmp76_ = nm_device_get_device_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp75_, nm_device_get_type (), NMDevice));
					_tmp77_ = _tmp76_;
					switch (_tmp77_) {
						case NM_DEVICE_TYPE_ETHERNET:
						{
							guint _tmp78_;
							gchar* _tmp79_;
							_tmp78_ = ethernet_count;
							ethernet_count = _tmp78_ + 1;
							_tmp79_ = g_strdup (_ ("Wired"));
							_g_free0 (title);
							title = _tmp79_;
							if (ethernet_count > ((guint) 1)) {
								const gchar* _tmp80_;
								gchar* _tmp81_;
								gchar* _tmp82_;
								gchar* _tmp83_;
								gchar* _tmp84_;
								gchar* _tmp85_;
								_tmp80_ = title;
								_tmp81_ = g_strdup_printf ("%u", ethernet_count);
								_tmp82_ = _tmp81_;
								_tmp83_ = g_strconcat (" ", _tmp82_, NULL);
								_tmp84_ = _tmp83_;
								_tmp85_ = g_strconcat (_tmp80_, _tmp84_, NULL);
								_g_free0 (title);
								title = _tmp85_;
								_g_free0 (_tmp84_);
								_g_free0 (_tmp82_);
							}
							break;
						}
						case NM_DEVICE_TYPE_WIFI:
						{
							guint _tmp86_;
							gchar* _tmp87_;
							_tmp86_ = wifi_count;
							wifi_count = _tmp86_ + 1;
							_tmp87_ = g_strdup (_ ("WiFi"));
							_g_free0 (title);
							title = _tmp87_;
							if (wifi_count > ((guint) 1)) {
								const gchar* _tmp88_;
								gchar* _tmp89_;
								gchar* _tmp90_;
								gchar* _tmp91_;
								gchar* _tmp92_;
								gchar* _tmp93_;
								_tmp88_ = title;
								_tmp89_ = g_strdup_printf ("%u", wifi_count);
								_tmp90_ = _tmp89_;
								_tmp91_ = g_strconcat (" ", _tmp90_, NULL);
								_tmp92_ = _tmp91_;
								_tmp93_ = g_strconcat (_tmp88_, _tmp92_, NULL);
								_g_free0 (title);
								title = _tmp93_;
								_g_free0 (_tmp92_);
								_g_free0 (_tmp90_);
							}
							break;
						}
						case NM_DEVICE_TYPE_WIFI_P2P:
						{
							guint _tmp94_;
							gchar* _tmp95_;
							_tmp94_ = p2p_count;
							p2p_count = _tmp94_ + 1;
							_tmp95_ = g_strdup (_ ("WiFi (Peer to Peer)"));
							_g_free0 (title);
							title = _tmp95_;
							if (p2p_count > ((guint) 1)) {
								const gchar* _tmp96_;
								gchar* _tmp97_;
								gchar* _tmp98_;
								gchar* _tmp99_;
								gchar* _tmp100_;
								gchar* _tmp101_;
								_tmp96_ = title;
								_tmp97_ = g_strdup_printf ("%u", p2p_count);
								_tmp98_ = _tmp97_;
								_tmp99_ = g_strconcat (" ", _tmp98_, NULL);
								_tmp100_ = _tmp99_;
								_tmp101_ = g_strconcat (_tmp96_, _tmp100_, NULL);
								_g_free0 (title);
								title = _tmp101_;
								_g_free0 (_tmp100_);
								_g_free0 (_tmp98_);
							}
							break;
						}
						case NM_DEVICE_TYPE_MODEM:
						{
							guint _tmp102_;
							gchar* _tmp103_;
							_tmp102_ = modem_count;
							modem_count = _tmp102_ + 1;
							_tmp103_ = g_strdup (_ ("Mobile Connection"));
							_g_free0 (title);
							title = _tmp103_;
							if (modem_count > ((guint) 1)) {
								const gchar* _tmp104_;
								gchar* _tmp105_;
								gchar* _tmp106_;
								gchar* _tmp107_;
								gchar* _tmp108_;
								gchar* _tmp109_;
								_tmp104_ = title;
								_tmp105_ = g_strdup_printf ("%u", modem_count);
								_tmp106_ = _tmp105_;
								_tmp107_ = g_strconcat (" ", _tmp106_, NULL);
								_tmp108_ = _tmp107_;
								_tmp109_ = g_strconcat (_tmp104_, _tmp108_, NULL);
								_g_free0 (title);
								title = _tmp109_;
								_g_free0 (_tmp108_);
								_g_free0 (_tmp106_);
							}
							break;
						}
						case NM_DEVICE_TYPE_BT:
						{
							guint _tmp110_;
							gchar* _tmp111_;
							_tmp110_ = bt_count;
							bt_count = _tmp110_ + 1;
							_tmp111_ = g_strdup (_ ("Bluetooth Hotspot"));
							_g_free0 (title);
							title = _tmp111_;
							if (bt_count > ((guint) 1)) {
								const gchar* _tmp112_;
								gchar* _tmp113_;
								gchar* _tmp114_;
								gchar* _tmp115_;
								gchar* _tmp116_;
								gchar* _tmp117_;
								_tmp112_ = title;
								_tmp113_ = g_strdup_printf ("%u", bt_count);
								_tmp114_ = _tmp113_;
								_tmp115_ = g_strconcat (" ", _tmp114_, NULL);
								_tmp116_ = _tmp115_;
								_tmp117_ = g_strconcat (_tmp112_, _tmp116_, NULL);
								_g_free0 (title);
								title = _tmp117_;
								_g_free0 (_tmp116_);
								_g_free0 (_tmp114_);
							}
							break;
						}
						default:
						{
							const gchar* _tmp118_;
							NMDevice* _tmp119_;
							NMDeviceType _tmp120_;
							NMDeviceType _tmp121_;
							_tmp118_ = interface_name;
							_tmp119_ = device;
							_tmp120_ = nm_device_get_device_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp119_, nm_device_get_type (), NMDevice));
							_tmp121_ = _tmp120_;
							g_info ("network-view.vala:110: including interface “%s” of unknown type %i", _tmp118_, (gint) _tmp121_);
							break;
						}
					}
				}
				start_timestamp = USAGE_NETWORK_VIEW_DAY * (((gint64) ((g_get_real_time () / 1000000) / USAGE_NETWORK_VIEW_DAY)) - 30);
				max_val = (gdouble) 1;
				_tmp122_ = interface_daily_data;
				{
					GList* nullable_data_point_collection = NULL;
					GList* nullable_data_point_it = NULL;
					nullable_data_point_collection = _tmp122_;
					for (nullable_data_point_it = nullable_data_point_collection; nullable_data_point_it != NULL; nullable_data_point_it = nullable_data_point_it->next) {
						VnstatTrafficDataPoint* _tmp123_;
						VnstatTrafficDataPoint* nullable_data_point = NULL;
						_tmp123_ = _vnstat_traffic_data_point_dup0 ((VnstatTrafficDataPoint*) nullable_data_point_it->data);
						nullable_data_point = _tmp123_;
						{
							VnstatTrafficDataPoint* _tmp124_;
							VnstatTrafficDataPoint data_point = {0};
							VnstatTrafficDataPoint* _tmp125_;
							UsageGraphPoint download_point = {0};
							VnstatTrafficDataPoint _tmp126_;
							VnstatTrafficDataPoint _tmp127_;
							UsageGraphPoint upload_point = {0};
							VnstatTrafficDataPoint _tmp128_;
							VnstatTrafficDataPoint _tmp129_;
							UsageNetworkInterfaceGraph* _tmp130_;
							UsageGraph* _tmp131_;
							UsageGraph* _tmp132_;
							UsageGraphPoint _tmp133_;
							UsageNetworkInterfaceGraph* _tmp134_;
							UsageGraph* _tmp135_;
							UsageGraph* _tmp136_;
							UsageGraphPoint _tmp137_;
							VnstatTrafficDataPoint _tmp138_;
							_tmp124_ = nullable_data_point;
							if (_tmp124_ == NULL) {
								_vnstat_traffic_data_point_free0 (nullable_data_point);
								continue;
							}
							_tmp125_ = nullable_data_point;
							data_point = (VnstatTrafficDataPoint) (*_tmp125_);
							_tmp126_ = data_point;
							_tmp127_ = data_point;
							usage_graph_point_init (&download_point, _tmp126_.timestamp, _tmp127_.download);
							_tmp128_ = data_point;
							_tmp129_ = data_point;
							usage_graph_point_init (&upload_point, _tmp128_.timestamp, _tmp129_.upload);
							_tmp130_ = interface_view;
							_tmp131_ = usage_network_interface_graph_get_download_graph (_tmp130_);
							_tmp132_ = _tmp131_;
							_tmp133_ = download_point;
							usage_graph_push_point (_tmp132_, &_tmp133_);
							_tmp134_ = interface_view;
							_tmp135_ = usage_network_interface_graph_get_upload_graph (_tmp134_);
							_tmp136_ = _tmp135_;
							_tmp137_ = upload_point;
							usage_graph_push_point (_tmp136_, &_tmp137_);
							_tmp138_ = data_point;
							if (_tmp138_.timestamp >= start_timestamp) {
								VnstatTrafficDataPoint _tmp139_;
								VnstatTrafficDataPoint _tmp140_;
								_tmp139_ = data_point;
								_tmp140_ = data_point;
								max_val = fmax (fmax (_tmp139_.download, _tmp140_.upload), max_val);
							}
							_vnstat_traffic_data_point_free0 (nullable_data_point);
						}
					}
				}
				_tmp141_ = self->priv->interface_graphs;
				_tmp142_ = interface_view;
				_tmp143_ = interface_name;
				_tmp144_ = title;
				adw_view_stack_add_titled_with_icon (_tmp141_, (GtkWidget*) _tmp142_, _tmp143_, _tmp144_, "network-transmit-receive-symbolic");
				_tmp145_ = interface_view;
				usage_network_interface_graph_set_ranges (_tmp145_, start_timestamp, start_timestamp + (30 * USAGE_NETWORK_VIEW_DAY), (gint64) max_val);
				_g_free0 (title);
				_g_object_unref0 (interface_view);
				_g_object_unref0 (device);
				_g_free0 (interface_name);
				(interface_daily_data == NULL) ? NULL : (interface_daily_data = (_g_list_free__vnstat_traffic_data_point_free0_ (interface_daily_data), NULL));
				_vnstat_interface_unref0 (iface);
			}
		}
		iface_collection = (_vala_array_free (iface_collection, iface_collection_length1, (GDestroyNotify) vnstat_interface_unref), NULL);
	}
	_g_hash_table_unref0 (devices);
	return self;
}

UsageNetworkView*
usage_network_view_new (void)
{
	return usage_network_view_construct (USAGE_TYPE_NETWORK_VIEW);
}

static gboolean
usage_network_view_real_prerequisite_fulfilled (UsageView* base)
{
	UsageNetworkView * self;
	gboolean result;
	self = (UsageNetworkView*) base;
	result = vnstat_test_exists ();
	return result;
}

static GObject *
usage_network_view_constructor (GType type,
                                guint n_construct_properties,
                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	UsageNetworkView * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	parent_class = G_OBJECT_CLASS (usage_network_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, USAGE_TYPE_NETWORK_VIEW, UsageNetworkView);
	gtk_widget_set_name ((GtkWidget*) self, "NETWORK");
	_tmp0_ = g_strdup (_ ("Network"));
	_g_free0 (((UsageView*) self)->title);
	((UsageView*) self)->title = _tmp0_;
	_tmp1_ = g_strdup ("network-transmit-receive-symbolic");
	_g_free0 (((UsageView*) self)->icon_name);
	((UsageView*) self)->icon_name = _tmp1_;
	((UsageView*) self)->search_available = FALSE;
	_g_object_unref0 (((UsageView*) self)->switcher_widget);
	((UsageView*) self)->switcher_widget = NULL;
	return obj;
}

static void
usage_network_view_class_init (UsageNetworkViewClass * klass,
                               gpointer klass_data)
{
	usage_network_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &UsageNetworkView_private_offset);
	((UsageViewClass *) klass)->prerequisite_fulfilled = (gboolean (*) (UsageView*)) usage_network_view_real_prerequisite_fulfilled;
	G_OBJECT_CLASS (klass)->constructor = usage_network_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = usage_network_view_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Usage/ui/network-view.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "interface_graphs", FALSE, UsageNetworkView_private_offset + G_STRUCT_OFFSET (UsageNetworkViewPrivate, interface_graphs));
}

static void
usage_network_view_instance_init (UsageNetworkView * self,
                                  gpointer klass)
{
	self->priv = usage_network_view_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
usage_network_view_finalize (GObject * obj)
{
	UsageNetworkView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, USAGE_TYPE_NETWORK_VIEW, UsageNetworkView);
	G_OBJECT_CLASS (usage_network_view_parent_class)->finalize (obj);
}

static GType
usage_network_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (UsageNetworkViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) usage_network_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UsageNetworkView), 0, (GInstanceInitFunc) usage_network_view_instance_init, NULL };
	GType usage_network_view_type_id;
	usage_network_view_type_id = g_type_register_static (USAGE_TYPE_VIEW, "UsageNetworkView", &g_define_type_info, 0);
	UsageNetworkView_private_offset = g_type_add_instance_private (usage_network_view_type_id, sizeof (UsageNetworkViewPrivate));
	return usage_network_view_type_id;
}

GType
usage_network_view_get_type (void)
{
	static volatile gsize usage_network_view_type_id__once = 0;
	if (g_once_init_enter (&usage_network_view_type_id__once)) {
		GType usage_network_view_type_id;
		usage_network_view_type_id = usage_network_view_get_type_once ();
		g_once_init_leave (&usage_network_view_type_id__once, usage_network_view_type_id);
	}
	return usage_network_view_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

