/* Countdown.c generated by valac 0.56.17, the Vala compiler
 * generated from Countdown.vala, do not modify */

/* Countdown.vala
 *
 * Copyright 2020 Dylan McCall <dylan@dylanmccall.ca>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include "daemon.h"
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include "common.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

typedef enum  {
	BREAK_TIMER_DAEMON_UTIL_COUNTDOWN_STATE_STOPPED,
	BREAK_TIMER_DAEMON_UTIL_COUNTDOWN_STATE_PAUSED,
	BREAK_TIMER_DAEMON_UTIL_COUNTDOWN_STATE_COUNTING
} BreakTimerDaemonUtilCountdownState;

#define BREAK_TIMER_DAEMON_UTIL_COUNTDOWN_TYPE_STATE (break_timer_daemon_util_countdown_state_get_type ())
enum  {
	BREAK_TIMER_DAEMON_UTIL_COUNTDOWN_0_PROPERTY,
	BREAK_TIMER_DAEMON_UTIL_COUNTDOWN_NUM_PROPERTIES
};
static GParamSpec* break_timer_daemon_util_countdown_properties[BREAK_TIMER_DAEMON_UTIL_COUNTDOWN_NUM_PROPERTIES];

struct _BreakTimerDaemonUtilCountdownPrivate {
	BreakTimerDaemonUtilCountdownState state;
	gint base_duration;
	gint64 start_time;
	gint stop_time_elapsed;
	gint penalty;
};

static gint BreakTimerDaemonUtilCountdown_private_offset;
static gpointer break_timer_daemon_util_countdown_parent_class = NULL;

static GType break_timer_daemon_util_countdown_state_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void break_timer_daemon_util_countdown_finalize (GObject * obj);
static GType break_timer_daemon_util_countdown_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
break_timer_daemon_util_countdown_get_instance_private (BreakTimerDaemonUtilCountdown* self)
{
	return G_STRUCT_MEMBER_P (self, BreakTimerDaemonUtilCountdown_private_offset);
}

static GType
break_timer_daemon_util_countdown_state_get_type_once (void)
{
	static const GEnumValue values[] = {{BREAK_TIMER_DAEMON_UTIL_COUNTDOWN_STATE_STOPPED, "BREAK_TIMER_DAEMON_UTIL_COUNTDOWN_STATE_STOPPED", "stopped"}, {BREAK_TIMER_DAEMON_UTIL_COUNTDOWN_STATE_PAUSED, "BREAK_TIMER_DAEMON_UTIL_COUNTDOWN_STATE_PAUSED", "paused"}, {BREAK_TIMER_DAEMON_UTIL_COUNTDOWN_STATE_COUNTING, "BREAK_TIMER_DAEMON_UTIL_COUNTDOWN_STATE_COUNTING", "counting"}, {0, NULL, NULL}};
	GType break_timer_daemon_util_countdown_state_type_id;
	break_timer_daemon_util_countdown_state_type_id = g_enum_register_static ("BreakTimerDaemonUtilCountdownState", values);
	return break_timer_daemon_util_countdown_state_type_id;
}

static GType
break_timer_daemon_util_countdown_state_get_type (void)
{
	static volatile gsize break_timer_daemon_util_countdown_state_type_id__once = 0;
	if (g_once_init_enter (&break_timer_daemon_util_countdown_state_type_id__once)) {
		GType break_timer_daemon_util_countdown_state_type_id;
		break_timer_daemon_util_countdown_state_type_id = break_timer_daemon_util_countdown_state_get_type_once ();
		g_once_init_leave (&break_timer_daemon_util_countdown_state_type_id__once, break_timer_daemon_util_countdown_state_type_id);
	}
	return break_timer_daemon_util_countdown_state_type_id__once;
}

BreakTimerDaemonUtilCountdown*
break_timer_daemon_util_countdown_construct (GType object_type,
                                             gint base_duration)
{
	BreakTimerDaemonUtilCountdown * self = NULL;
	self = (BreakTimerDaemonUtilCountdown*) g_object_new (object_type, NULL);
	self->priv->base_duration = base_duration;
	break_timer_daemon_util_countdown_reset (self);
	return self;
}

BreakTimerDaemonUtilCountdown*
break_timer_daemon_util_countdown_new (gint base_duration)
{
	return break_timer_daemon_util_countdown_construct (BREAK_TIMER_DAEMON_UTIL_TYPE_COUNTDOWN, base_duration);
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

gchar*
break_timer_daemon_util_countdown_serialize (BreakTimerDaemonUtilCountdown* self)
{
	gint serialized_time_counted = 0;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	serialized_time_counted = (gint) (break_timer_common_time_unit_get_real_time_seconds () - self->priv->start_time);
	serialized_time_counted = MAX (0, serialized_time_counted);
	_tmp0_ = g_strdup_printf ("%i", (gint) self->priv->state);
	_tmp1_ = g_strdup_printf ("%" G_GINT64_FORMAT, self->priv->start_time);
	_tmp2_ = g_strdup_printf ("%i", self->priv->stop_time_elapsed);
	_tmp3_ = g_strdup_printf ("%i", self->priv->penalty);
	_tmp4_ = g_strdup_printf ("%i", serialized_time_counted);
	_tmp5_ = g_new0 (gchar*, 5 + 1);
	_tmp5_[0] = _tmp0_;
	_tmp5_[1] = _tmp1_;
	_tmp5_[2] = _tmp2_;
	_tmp5_[3] = _tmp3_;
	_tmp5_[4] = _tmp4_;
	_tmp6_ = _tmp5_;
	_tmp6__length1 = 5;
	_tmp7_ = _vala_g_strjoinv (",", _tmp6_, (gint) 5);
	_tmp8_ = _tmp7_;
	_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_free), NULL);
	result = _tmp8_;
	return result;
}

static gint64
int64_parse (const gchar* str,
             guint _base)
{
	gint64 result;
	g_return_val_if_fail (str != NULL, 0LL);
	result = g_ascii_strtoll (str, NULL, _base);
	return result;
}

void
break_timer_daemon_util_countdown_deserialize (BreakTimerDaemonUtilCountdown* self,
                                               const gchar* data,
                                               gboolean persistent)
{
	gchar** data_parts = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint data_parts_length1;
	gint _data_parts_size_;
	BreakTimerDaemonUtilCountdownState serialized_state = 0;
	gchar** _tmp2_;
	gint _tmp2__length1;
	const gchar* _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	const gchar* _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	const gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (data != NULL);
	_tmp1_ = _tmp0_ = g_strsplit (data, ",", 0);
	data_parts = _tmp1_;
	data_parts_length1 = _vala_array_length (_tmp0_);
	_data_parts_size_ = data_parts_length1;
	_tmp2_ = data_parts;
	_tmp2__length1 = data_parts_length1;
	_tmp3_ = _tmp2_[0];
	serialized_state = (BreakTimerDaemonUtilCountdownState) atoi (_tmp3_);
	switch (serialized_state) {
		case BREAK_TIMER_DAEMON_UTIL_COUNTDOWN_STATE_STOPPED:
		{
			break_timer_daemon_util_countdown_reset (self);
			break;
		}
		case BREAK_TIMER_DAEMON_UTIL_COUNTDOWN_STATE_PAUSED:
		{
			break_timer_daemon_util_countdown_pause (self);
			break;
		}
		case BREAK_TIMER_DAEMON_UTIL_COUNTDOWN_STATE_COUNTING:
		{
			break_timer_daemon_util_countdown_start (self);
			break;
		}
		default:
		break;
	}
	_tmp4_ = data_parts;
	_tmp4__length1 = data_parts_length1;
	_tmp5_ = _tmp4_[2];
	self->priv->stop_time_elapsed = atoi (_tmp5_);
	_tmp6_ = data_parts;
	_tmp6__length1 = data_parts_length1;
	_tmp7_ = _tmp6_[3];
	self->priv->penalty = atoi (_tmp7_);
	if (persistent) {
		gchar** _tmp8_;
		gint _tmp8__length1;
		const gchar* _tmp9_;
		_tmp8_ = data_parts;
		_tmp8__length1 = data_parts_length1;
		_tmp9_ = _tmp8_[1];
		self->priv->start_time = int64_parse (_tmp9_, (guint) 0);
	} else {
		if (serialized_state == BREAK_TIMER_DAEMON_UTIL_COUNTDOWN_STATE_COUNTING) {
			gint serialized_time_counted = 0;
			gchar** _tmp10_;
			gint _tmp10__length1;
			const gchar* _tmp11_;
			_tmp10_ = data_parts;
			_tmp10__length1 = data_parts_length1;
			_tmp11_ = _tmp10_[4];
			serialized_time_counted = atoi (_tmp11_);
			break_timer_daemon_util_countdown_advance_time (self, serialized_time_counted);
		}
	}
	data_parts = (_vala_array_free (data_parts, data_parts_length1, (GDestroyNotify) g_free), NULL);
}

/**
     * Stop the countdown and forget its current position.
     * This is the same as calling Countdown.start (), except the countdown
     * will not advance.
     */
void
break_timer_daemon_util_countdown_reset (BreakTimerDaemonUtilCountdown* self)
{
	g_return_if_fail (self != NULL);
	self->priv->penalty = 0;
	self->priv->stop_time_elapsed = 0;
	self->priv->state = BREAK_TIMER_DAEMON_UTIL_COUNTDOWN_STATE_STOPPED;
}

/**
     * Start counting down from the time set with set_base_duration.
     * This is the same as calling Countdown.stop () followed by
     * Countdown.continue ().
     */
void
break_timer_daemon_util_countdown_start (BreakTimerDaemonUtilCountdown* self)
{
	g_return_if_fail (self != NULL);
	break_timer_daemon_util_countdown_start_from (self, 0);
}

/**
     * Start counting with the time offset by the given number of seconds.
     * Useful if the countdown should have started in the past.
     * @param start_offset the number of seconds to offset the start time,
     *                     where a negative value brings the countdown closer
     *                     to being finished.
     */
void
break_timer_daemon_util_countdown_start_from (BreakTimerDaemonUtilCountdown* self,
                                              gint start_offset)
{
	g_return_if_fail (self != NULL);
	break_timer_daemon_util_countdown_reset (self);
	break_timer_daemon_util_countdown_continue_from (self, start_offset);
}

/**
     * Pause the countdown, keeping its current position.
     */
void
break_timer_daemon_util_countdown_pause (BreakTimerDaemonUtilCountdown* self)
{
	g_return_if_fail (self != NULL);
	self->priv->stop_time_elapsed = break_timer_daemon_util_countdown_get_time_elapsed (self);
	self->priv->state = BREAK_TIMER_DAEMON_UTIL_COUNTDOWN_STATE_PAUSED;
}

/**
     * Start the countdown, continuing from the current position if
     * possible.
     */
void
break_timer_daemon_util_countdown_continue (BreakTimerDaemonUtilCountdown* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->state < BREAK_TIMER_DAEMON_UTIL_COUNTDOWN_STATE_COUNTING) {
		break_timer_daemon_util_countdown_continue_from (self, 0);
	}
}

/**
     * If not already counting, start counting with the time offset by the
     * given number of seconds. This is like start_from, but it never resets
     * the countdown.
     * @param start_offset the number of seconds to offset the start time,
     *                     where a negative value brings the countdown closer
     *                     to being finished.
     */
void
break_timer_daemon_util_countdown_continue_from (BreakTimerDaemonUtilCountdown* self,
                                                 gint start_offset)
{
	g_return_if_fail (self != NULL);
	if (self->priv->state < BREAK_TIMER_DAEMON_UTIL_COUNTDOWN_STATE_COUNTING) {
		gint64 now = 0LL;
		now = break_timer_common_time_unit_get_real_time_seconds ();
		self->priv->start_time = now + start_offset;
		self->priv->state = BREAK_TIMER_DAEMON_UTIL_COUNTDOWN_STATE_COUNTING;
	}
}

/**
     * If the countdown is paused, continue as if that never happened. This
     * has the effect of the countdown advancing by the time for which it was
     * paused.
     */
void
break_timer_daemon_util_countdown_cancel_pause (BreakTimerDaemonUtilCountdown* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->state == BREAK_TIMER_DAEMON_UTIL_COUNTDOWN_STATE_PAUSED) {
		self->priv->stop_time_elapsed = 0;
		self->priv->state = BREAK_TIMER_DAEMON_UTIL_COUNTDOWN_STATE_COUNTING;
	}
}

/**
     * Advance the countdown by the number of seconds, regardless of its
     * present state. If the countdown is currently paused, calling continue
     * will take into account the given offset.
     * @param seconds_off the number of seconds to advance the countdown,
     *                    where a positive value brings it closer to being
     *                    finished.
     */
void
break_timer_daemon_util_countdown_advance_time (BreakTimerDaemonUtilCountdown* self,
                                                gint seconds_off)
{
	gint64 now = 0LL;
	g_return_if_fail (self != NULL);
	now = break_timer_common_time_unit_get_real_time_seconds ();
	if (self->priv->state == BREAK_TIMER_DAEMON_UTIL_COUNTDOWN_STATE_COUNTING) {
		self->priv->start_time = now - seconds_off;
	} else {
		self->priv->stop_time_elapsed = self->priv->stop_time_elapsed + seconds_off;
	}
}

/**
     * Sets a temporary time penalty. This increases the countdown's duration
     * until it is reset.
     * @param penalty the number of seconds extra the countdown will last.
     */
void
break_timer_daemon_util_countdown_set_penalty (BreakTimerDaemonUtilCountdown* self,
                                               gint penalty)
{
	g_return_if_fail (self != NULL);
	self->priv->penalty = penalty;
}

/**
     * @return the current time penalty for the countdown.
     * @see set_penalty
     */
gint
break_timer_daemon_util_countdown_get_penalty (BreakTimerDaemonUtilCountdown* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->penalty;
	return result;
}

/**
     * @return true if the countdown is currently counting, or false if it is
     *         either stopped or paused.
     */
gboolean
break_timer_daemon_util_countdown_is_counting (BreakTimerDaemonUtilCountdown* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->state == BREAK_TIMER_DAEMON_UTIL_COUNTDOWN_STATE_COUNTING;
	return result;
}

/**
     * Sets the base duration for the countdown. This is how long the
     * countdown will last from when it is freshly started.
     *
     * The base duration can be changed while the countdown is counting. The
     * elapsed time will not change, while the remaining time will increase or
     * decrease based on that elapsed time, the new base duration, and the
     * current penalty.
     *
     * @param base_duration the new base duration for the countdown
     */
void
break_timer_daemon_util_countdown_set_base_duration (BreakTimerDaemonUtilCountdown* self,
                                                     gint base_duration)
{
	g_return_if_fail (self != NULL);
	self->priv->base_duration = base_duration;
}

/**
     * Returns the current duration for the countdown. This is not the same as
     * the base duration: it takes into account the penalty, as well. The
     * return value will change as the time penalty changes.
     * @return the countdown's duration
     */
gint
break_timer_daemon_util_countdown_get_duration (BreakTimerDaemonUtilCountdown* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = MAX (0, self->priv->base_duration + self->priv->penalty);
	return result;
}

/**
     * Returns the amount of time that the countdown has been counting, if at
     * all. If the countdown is paused, this will return the elapsed time from
     * the point when it was paused.
     * @return the countdown's current elapsed time, or 0
     */
gint
break_timer_daemon_util_countdown_get_time_elapsed (BreakTimerDaemonUtilCountdown* self)
{
	gint time_elapsed = 0;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	time_elapsed = self->priv->stop_time_elapsed;
	if (self->priv->state == BREAK_TIMER_DAEMON_UTIL_COUNTDOWN_STATE_COUNTING) {
		gint64 now = 0LL;
		now = break_timer_common_time_unit_get_real_time_seconds ();
		time_elapsed += (gint) (now - self->priv->start_time);
	}
	result = MAX (0, time_elapsed);
	return result;
}

/**
     * Returns the time remaining until the countdown will be finished, or 0
     * if the countdown is already finished. If the countdown is not counting,
     * this will return its current duration.
     * @return the time the countdown needs to count until it is finished
     */
gint
break_timer_daemon_util_countdown_get_time_remaining (BreakTimerDaemonUtilCountdown* self)
{
	gint time_remaining = 0;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	time_remaining = break_timer_daemon_util_countdown_get_duration (self) - break_timer_daemon_util_countdown_get_time_elapsed (self);
	result = MAX (0, time_remaining);
	return result;
}

/**
     * Returns true if the countdown is finished; if its elapsed time meets or
     * exceeds its duration. This is equivalent to checking if the remaining
     * time is 0.
     * @return true if the countdown is finished.
     */
gboolean
break_timer_daemon_util_countdown_is_finished (BreakTimerDaemonUtilCountdown* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = break_timer_daemon_util_countdown_get_time_remaining (self) == 0;
	return result;
}

static void
break_timer_daemon_util_countdown_class_init (BreakTimerDaemonUtilCountdownClass * klass,
                                              gpointer klass_data)
{
	break_timer_daemon_util_countdown_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BreakTimerDaemonUtilCountdown_private_offset);
	G_OBJECT_CLASS (klass)->finalize = break_timer_daemon_util_countdown_finalize;
}

static void
break_timer_daemon_util_countdown_instance_init (BreakTimerDaemonUtilCountdown * self,
                                                 gpointer klass)
{
	self->priv = break_timer_daemon_util_countdown_get_instance_private (self);
}

static void
break_timer_daemon_util_countdown_finalize (GObject * obj)
{
	BreakTimerDaemonUtilCountdown * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BREAK_TIMER_DAEMON_UTIL_TYPE_COUNTDOWN, BreakTimerDaemonUtilCountdown);
	G_OBJECT_CLASS (break_timer_daemon_util_countdown_parent_class)->finalize (obj);
}

/**
 * A countdown timer that counts seconds from a start time down to 0. Uses
 * "wall-clock" time instead of monotonic time, so it will count regardless
 * of system state. The countdown can be paused, and its duration can be
 * adjusted at any time using penalty and bonus time.
 */
static GType
break_timer_daemon_util_countdown_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BreakTimerDaemonUtilCountdownClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) break_timer_daemon_util_countdown_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BreakTimerDaemonUtilCountdown), 0, (GInstanceInitFunc) break_timer_daemon_util_countdown_instance_init, NULL };
	GType break_timer_daemon_util_countdown_type_id;
	break_timer_daemon_util_countdown_type_id = g_type_register_static (G_TYPE_OBJECT, "BreakTimerDaemonUtilCountdown", &g_define_type_info, 0);
	BreakTimerDaemonUtilCountdown_private_offset = g_type_add_instance_private (break_timer_daemon_util_countdown_type_id, sizeof (BreakTimerDaemonUtilCountdownPrivate));
	return break_timer_daemon_util_countdown_type_id;
}

GType
break_timer_daemon_util_countdown_get_type (void)
{
	static volatile gsize break_timer_daemon_util_countdown_type_id__once = 0;
	if (g_once_init_enter (&break_timer_daemon_util_countdown_type_id__once)) {
		GType break_timer_daemon_util_countdown_type_id;
		break_timer_daemon_util_countdown_type_id = break_timer_daemon_util_countdown_get_type_once ();
		g_once_init_leave (&break_timer_daemon_util_countdown_type_id__once, break_timer_daemon_util_countdown_type_id);
	}
	return break_timer_daemon_util_countdown_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

