/* Dialogs.c generated by valac 0.56.18, the Vala compiler
 * generated from Dialogs.vala, do not modify */

/* Dialogs.vala
 *
 * Copyright (C) 2009-2025 Jerry Casiano
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.
 *
 * If not, see <http://www.gnu.org/licenses/gpl-3.0.txt>.
*/

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include "config.h"
#include "font-manager.h"
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <json-glib/json-glib.h>
#include <sqlite3.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define FONT_MANAGER_TYPE_PREFERENCE_LIST (font_manager_preference_list_get_type ())
#define FONT_MANAGER_PREFERENCE_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_PREFERENCE_LIST, FontManagerPreferenceList))
#define FONT_MANAGER_PREFERENCE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_PREFERENCE_LIST, FontManagerPreferenceListClass))
#define FONT_MANAGER_IS_PREFERENCE_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_PREFERENCE_LIST))
#define FONT_MANAGER_IS_PREFERENCE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_PREFERENCE_LIST))
#define FONT_MANAGER_PREFERENCE_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_PREFERENCE_LIST, FontManagerPreferenceListClass))

typedef struct _FontManagerPreferenceList FontManagerPreferenceList;
typedef struct _FontManagerPreferenceListClass FontManagerPreferenceListClass;
typedef struct _FontManagerPreferenceListPrivate FontManagerPreferenceListPrivate;

#define FONT_MANAGER_TYPE_BASE_CONTROLS (font_manager_base_controls_get_type ())
#define FONT_MANAGER_BASE_CONTROLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_BASE_CONTROLS, FontManagerBaseControls))
#define FONT_MANAGER_BASE_CONTROLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_BASE_CONTROLS, FontManagerBaseControlsClass))
#define FONT_MANAGER_IS_BASE_CONTROLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_BASE_CONTROLS))
#define FONT_MANAGER_IS_BASE_CONTROLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_BASE_CONTROLS))
#define FONT_MANAGER_BASE_CONTROLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_BASE_CONTROLS, FontManagerBaseControlsClass))

typedef struct _FontManagerBaseControls FontManagerBaseControls;
typedef struct _FontManagerBaseControlsClass FontManagerBaseControlsClass;

#define FONT_MANAGER_USER_DATA_TYPE_EXPORT_SETTINGS (font_manager_user_data_export_settings_get_type ())
#define FONT_MANAGER_USER_DATA_EXPORT_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_USER_DATA_TYPE_EXPORT_SETTINGS, FontManagerUserDataExportSettings))
#define FONT_MANAGER_USER_DATA_EXPORT_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_USER_DATA_TYPE_EXPORT_SETTINGS, FontManagerUserDataExportSettingsClass))
#define FONT_MANAGER_USER_DATA_IS_EXPORT_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_USER_DATA_TYPE_EXPORT_SETTINGS))
#define FONT_MANAGER_USER_DATA_IS_EXPORT_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_USER_DATA_TYPE_EXPORT_SETTINGS))
#define FONT_MANAGER_USER_DATA_EXPORT_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_USER_DATA_TYPE_EXPORT_SETTINGS, FontManagerUserDataExportSettingsClass))

typedef struct _FontManagerUserDataExportSettings FontManagerUserDataExportSettings;
typedef struct _FontManagerUserDataExportSettingsClass FontManagerUserDataExportSettingsClass;
typedef struct _FontManagerUserDataExportSettingsPrivate FontManagerUserDataExportSettingsPrivate;
enum  {
	FONT_MANAGER_USER_DATA_EXPORT_SETTINGS_0_PROPERTY,
	FONT_MANAGER_USER_DATA_EXPORT_SETTINGS_SETTINGS_PROPERTY,
	FONT_MANAGER_USER_DATA_EXPORT_SETTINGS_COLLECTIONS_PROPERTY,
	FONT_MANAGER_USER_DATA_EXPORT_SETTINGS_SOURCES_PROPERTY,
	FONT_MANAGER_USER_DATA_EXPORT_SETTINGS_FONTS_PROPERTY,
	FONT_MANAGER_USER_DATA_EXPORT_SETTINGS_ACTIONS_PROPERTY,
	FONT_MANAGER_USER_DATA_EXPORT_SETTINGS_NUM_PROPERTIES
};
static GParamSpec* font_manager_user_data_export_settings_properties[FONT_MANAGER_USER_DATA_EXPORT_SETTINGS_NUM_PROPERTIES];

#define FONT_MANAGER_USER_DATA_TYPE_EXPORT_DIALOG (font_manager_user_data_export_dialog_get_type ())
#define FONT_MANAGER_USER_DATA_EXPORT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_USER_DATA_TYPE_EXPORT_DIALOG, FontManagerUserDataExportDialog))
#define FONT_MANAGER_USER_DATA_EXPORT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_USER_DATA_TYPE_EXPORT_DIALOG, FontManagerUserDataExportDialogClass))
#define FONT_MANAGER_USER_DATA_IS_EXPORT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_USER_DATA_TYPE_EXPORT_DIALOG))
#define FONT_MANAGER_USER_DATA_IS_EXPORT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_USER_DATA_TYPE_EXPORT_DIALOG))
#define FONT_MANAGER_USER_DATA_EXPORT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_USER_DATA_TYPE_EXPORT_DIALOG, FontManagerUserDataExportDialogClass))

typedef struct _FontManagerUserDataExportDialog FontManagerUserDataExportDialog;
typedef struct _FontManagerUserDataExportDialogClass FontManagerUserDataExportDialogClass;
typedef struct _FontManagerUserDataExportDialogPrivate FontManagerUserDataExportDialogPrivate;
enum  {
	FONT_MANAGER_USER_DATA_EXPORT_DIALOG_0_PROPERTY,
	FONT_MANAGER_USER_DATA_EXPORT_DIALOG_EXPORT_SETTINGS_PROPERTY,
	FONT_MANAGER_USER_DATA_EXPORT_DIALOG_NUM_PROPERTIES
};
static GParamSpec* font_manager_user_data_export_dialog_properties[FONT_MANAGER_USER_DATA_EXPORT_DIALOG_NUM_PROPERTIES];
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

#define FONT_MANAGER_USER_DATA_TYPE_IMPORT_DIALOG (font_manager_user_data_import_dialog_get_type ())
#define FONT_MANAGER_USER_DATA_IMPORT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_USER_DATA_TYPE_IMPORT_DIALOG, FontManagerUserDataImportDialog))
#define FONT_MANAGER_USER_DATA_IMPORT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_USER_DATA_TYPE_IMPORT_DIALOG, FontManagerUserDataImportDialogClass))
#define FONT_MANAGER_USER_DATA_IS_IMPORT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_USER_DATA_TYPE_IMPORT_DIALOG))
#define FONT_MANAGER_USER_DATA_IS_IMPORT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_USER_DATA_TYPE_IMPORT_DIALOG))
#define FONT_MANAGER_USER_DATA_IMPORT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_USER_DATA_TYPE_IMPORT_DIALOG, FontManagerUserDataImportDialogClass))

typedef struct _FontManagerUserDataImportDialog FontManagerUserDataImportDialog;
typedef struct _FontManagerUserDataImportDialogClass FontManagerUserDataImportDialogClass;
typedef struct _FontManagerUserDataImportDialogPrivate FontManagerUserDataImportDialogPrivate;
enum  {
	FONT_MANAGER_USER_DATA_IMPORT_DIALOG_0_PROPERTY,
	FONT_MANAGER_USER_DATA_IMPORT_DIALOG_NUM_PROPERTIES
};
static GParamSpec* font_manager_user_data_import_dialog_properties[FONT_MANAGER_USER_DATA_IMPORT_DIALOG_NUM_PROPERTIES];

#define FONT_MANAGER_TYPE_APPLICATION (font_manager_application_get_type ())
#define FONT_MANAGER_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_APPLICATION, FontManagerApplication))
#define FONT_MANAGER_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_APPLICATION, FontManagerApplicationClass))
#define FONT_MANAGER_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_APPLICATION))
#define FONT_MANAGER_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_APPLICATION))
#define FONT_MANAGER_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_APPLICATION, FontManagerApplicationClass))

typedef struct _FontManagerApplication FontManagerApplication;
typedef struct _FontManagerApplicationClass FontManagerApplicationClass;

#define FONT_MANAGER_TYPE_LANGUAGE_SETTINGS_DIALOG (font_manager_language_settings_dialog_get_type ())
#define FONT_MANAGER_LANGUAGE_SETTINGS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_LANGUAGE_SETTINGS_DIALOG, FontManagerLanguageSettingsDialog))
#define FONT_MANAGER_LANGUAGE_SETTINGS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_LANGUAGE_SETTINGS_DIALOG, FontManagerLanguageSettingsDialogClass))
#define FONT_MANAGER_IS_LANGUAGE_SETTINGS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_LANGUAGE_SETTINGS_DIALOG))
#define FONT_MANAGER_IS_LANGUAGE_SETTINGS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_LANGUAGE_SETTINGS_DIALOG))
#define FONT_MANAGER_LANGUAGE_SETTINGS_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_LANGUAGE_SETTINGS_DIALOG, FontManagerLanguageSettingsDialogClass))

typedef struct _FontManagerLanguageSettingsDialog FontManagerLanguageSettingsDialog;
typedef struct _FontManagerLanguageSettingsDialogClass FontManagerLanguageSettingsDialogClass;
typedef struct _FontManagerLanguageSettingsDialogPrivate FontManagerLanguageSettingsDialogPrivate;

#define FONT_MANAGER_TYPE_LANGUAGE_FILTER_SETTINGS (font_manager_language_filter_settings_get_type ())
#define FONT_MANAGER_LANGUAGE_FILTER_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_LANGUAGE_FILTER_SETTINGS, FontManagerLanguageFilterSettings))
#define FONT_MANAGER_LANGUAGE_FILTER_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_LANGUAGE_FILTER_SETTINGS, FontManagerLanguageFilterSettingsClass))
#define FONT_MANAGER_IS_LANGUAGE_FILTER_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_LANGUAGE_FILTER_SETTINGS))
#define FONT_MANAGER_IS_LANGUAGE_FILTER_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_LANGUAGE_FILTER_SETTINGS))
#define FONT_MANAGER_LANGUAGE_FILTER_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_LANGUAGE_FILTER_SETTINGS, FontManagerLanguageFilterSettingsClass))

typedef struct _FontManagerLanguageFilterSettings FontManagerLanguageFilterSettings;
typedef struct _FontManagerLanguageFilterSettingsClass FontManagerLanguageFilterSettingsClass;
enum  {
	FONT_MANAGER_LANGUAGE_SETTINGS_DIALOG_0_PROPERTY,
	FONT_MANAGER_LANGUAGE_SETTINGS_DIALOG_SETTINGS_PROPERTY,
	FONT_MANAGER_LANGUAGE_SETTINGS_DIALOG_NUM_PROPERTIES
};
static GParamSpec* font_manager_language_settings_dialog_properties[FONT_MANAGER_LANGUAGE_SETTINGS_DIALOG_NUM_PROPERTIES];

#define FONT_MANAGER_TYPE_PROGRESS_DIALOG (font_manager_progress_dialog_get_type ())
#define FONT_MANAGER_PROGRESS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_PROGRESS_DIALOG, FontManagerProgressDialog))
#define FONT_MANAGER_PROGRESS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_PROGRESS_DIALOG, FontManagerProgressDialogClass))
#define FONT_MANAGER_IS_PROGRESS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_PROGRESS_DIALOG))
#define FONT_MANAGER_IS_PROGRESS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_PROGRESS_DIALOG))
#define FONT_MANAGER_PROGRESS_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_PROGRESS_DIALOG, FontManagerProgressDialogClass))

typedef struct _FontManagerProgressDialog FontManagerProgressDialog;
typedef struct _FontManagerProgressDialogClass FontManagerProgressDialogClass;
typedef struct _FontManagerProgressDialogPrivate FontManagerProgressDialogPrivate;
enum  {
	FONT_MANAGER_PROGRESS_DIALOG_0_PROPERTY,
	FONT_MANAGER_PROGRESS_DIALOG_SHOW_APP_ICON_PROPERTY,
	FONT_MANAGER_PROGRESS_DIALOG_TITLE_LABEL_PROPERTY,
	FONT_MANAGER_PROGRESS_DIALOG_MESSAGE_LABEL_PROPERTY,
	FONT_MANAGER_PROGRESS_DIALOG_OVERLAY_PROPERTY,
	FONT_MANAGER_PROGRESS_DIALOG_PROGRESS_BAR_PROPERTY,
	FONT_MANAGER_PROGRESS_DIALOG_NUM_PROPERTIES
};
static GParamSpec* font_manager_progress_dialog_properties[FONT_MANAGER_PROGRESS_DIALOG_NUM_PROPERTIES];

#define FONT_MANAGER_TYPE_REMOVE_DIALOG (font_manager_remove_dialog_get_type ())
#define FONT_MANAGER_REMOVE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_REMOVE_DIALOG, FontManagerRemoveDialog))
#define FONT_MANAGER_REMOVE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_REMOVE_DIALOG, FontManagerRemoveDialogClass))
#define FONT_MANAGER_IS_REMOVE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_REMOVE_DIALOG))
#define FONT_MANAGER_IS_REMOVE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_REMOVE_DIALOG))
#define FONT_MANAGER_REMOVE_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_REMOVE_DIALOG, FontManagerRemoveDialogClass))

typedef struct _FontManagerRemoveDialog FontManagerRemoveDialog;
typedef struct _FontManagerRemoveDialogClass FontManagerRemoveDialogClass;
typedef struct _FontManagerRemoveDialogPrivate FontManagerRemoveDialogPrivate;

#define FONT_MANAGER_TYPE_FONT_LIST_BASE (font_manager_font_list_base_get_type ())
#define FONT_MANAGER_FONT_LIST_BASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_FONT_LIST_BASE, FontManagerFontListBase))
#define FONT_MANAGER_FONT_LIST_BASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_FONT_LIST_BASE, FontManagerFontListBaseClass))
#define FONT_MANAGER_IS_FONT_LIST_BASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_FONT_LIST_BASE))
#define FONT_MANAGER_IS_FONT_LIST_BASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_FONT_LIST_BASE))
#define FONT_MANAGER_FONT_LIST_BASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_FONT_LIST_BASE, FontManagerFontListBaseClass))

typedef struct _FontManagerFontListBase FontManagerFontListBase;
typedef struct _FontManagerFontListBaseClass FontManagerFontListBaseClass;

#define FONT_MANAGER_TYPE_BASE_FONT_LIST_VIEW (font_manager_base_font_list_view_get_type ())
#define FONT_MANAGER_BASE_FONT_LIST_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_BASE_FONT_LIST_VIEW, FontManagerBaseFontListView))
#define FONT_MANAGER_BASE_FONT_LIST_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_BASE_FONT_LIST_VIEW, FontManagerBaseFontListViewClass))
#define FONT_MANAGER_IS_BASE_FONT_LIST_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_BASE_FONT_LIST_VIEW))
#define FONT_MANAGER_IS_BASE_FONT_LIST_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_BASE_FONT_LIST_VIEW))
#define FONT_MANAGER_BASE_FONT_LIST_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_BASE_FONT_LIST_VIEW, FontManagerBaseFontListViewClass))

typedef struct _FontManagerBaseFontListView FontManagerBaseFontListView;
typedef struct _FontManagerBaseFontListViewClass FontManagerBaseFontListViewClass;

#define FONT_MANAGER_TYPE_REMOVE_LIST_VIEW (font_manager_remove_list_view_get_type ())
#define FONT_MANAGER_REMOVE_LIST_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_REMOVE_LIST_VIEW, FontManagerRemoveListView))
#define FONT_MANAGER_REMOVE_LIST_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_REMOVE_LIST_VIEW, FontManagerRemoveListViewClass))
#define FONT_MANAGER_IS_REMOVE_LIST_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_REMOVE_LIST_VIEW))
#define FONT_MANAGER_IS_REMOVE_LIST_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_REMOVE_LIST_VIEW))
#define FONT_MANAGER_REMOVE_LIST_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_REMOVE_LIST_VIEW, FontManagerRemoveListViewClass))

typedef struct _FontManagerRemoveListView FontManagerRemoveListView;
typedef struct _FontManagerRemoveListViewClass FontManagerRemoveListViewClass;
enum  {
	FONT_MANAGER_REMOVE_DIALOG_0_PROPERTY,
	FONT_MANAGER_REMOVE_DIALOG_CANCEL_BUTTON_PROPERTY,
	FONT_MANAGER_REMOVE_DIALOG_DELETE_BUTTON_PROPERTY,
	FONT_MANAGER_REMOVE_DIALOG_SEARCH_TOGGLE_PROPERTY,
	FONT_MANAGER_REMOVE_DIALOG_REMOVE_LIST_PROPERTY,
	FONT_MANAGER_REMOVE_DIALOG_SEARCH_BAR_PROPERTY,
	FONT_MANAGER_REMOVE_DIALOG_ENTRY_PROPERTY,
	FONT_MANAGER_REMOVE_DIALOG_NUM_PROPERTIES
};
static GParamSpec* font_manager_remove_dialog_properties[FONT_MANAGER_REMOVE_DIALOG_NUM_PROPERTIES];
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))

#define FONT_MANAGER_TYPE_BASE_FONT_MODEL (font_manager_base_font_model_get_type ())
#define FONT_MANAGER_BASE_FONT_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FONT_MANAGER_TYPE_BASE_FONT_MODEL, FontManagerBaseFontModel))
#define FONT_MANAGER_BASE_FONT_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FONT_MANAGER_TYPE_BASE_FONT_MODEL, FontManagerBaseFontModelClass))
#define FONT_MANAGER_IS_BASE_FONT_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FONT_MANAGER_TYPE_BASE_FONT_MODEL))
#define FONT_MANAGER_IS_BASE_FONT_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FONT_MANAGER_TYPE_BASE_FONT_MODEL))
#define FONT_MANAGER_BASE_FONT_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FONT_MANAGER_TYPE_BASE_FONT_MODEL, FontManagerBaseFontModelClass))

typedef struct _FontManagerBaseFontModel FontManagerBaseFontModel;
typedef struct _FontManagerBaseFontModelClass FontManagerBaseFontModelClass;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
enum  {
	FONT_MANAGER_REMOVE_DIALOG_START_REMOVAL_SIGNAL,
	FONT_MANAGER_REMOVE_DIALOG_END_REMOVAL_SIGNAL,
	FONT_MANAGER_REMOVE_DIALOG_NUM_SIGNALS
};
static guint font_manager_remove_dialog_signals[FONT_MANAGER_REMOVE_DIALOG_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _FontManagerPreferenceList {
	GtkBox parent_instance;
	FontManagerPreferenceListPrivate * priv;
	GtkListBox* list;
	FontManagerBaseControls* controls;
	GtkSeparator* separator;
};

struct _FontManagerPreferenceListClass {
	GtkBoxClass parent_class;
	void (*on_add_selected) (FontManagerPreferenceList* self);
	void (*on_list_row_selected) (FontManagerPreferenceList* self, GtkListBox* box, GtkListBoxRow* row);
	void (*on_map) (FontManagerPreferenceList* self);
	void (*on_remove_selected) (FontManagerPreferenceList* self);
	void (*on_unmap) (FontManagerPreferenceList* self);
};

struct _FontManagerUserDataExportSettings {
	FontManagerPreferenceList parent_instance;
	FontManagerUserDataExportSettingsPrivate * priv;
};

struct _FontManagerUserDataExportSettingsClass {
	FontManagerPreferenceListClass parent_class;
};

struct _FontManagerUserDataExportSettingsPrivate {
	GtkSwitch* _settings;
	GtkSwitch* _collections;
	GtkSwitch* _sources;
	GtkSwitch* _fonts;
	GtkSwitch* _actions;
};

struct _FontManagerUserDataExportDialog {
	GtkWindow parent_instance;
	FontManagerUserDataExportDialogPrivate * priv;
};

struct _FontManagerUserDataExportDialogClass {
	GtkWindowClass parent_class;
};

struct _FontManagerUserDataExportDialogPrivate {
	FontManagerUserDataExportSettings* _export_settings;
};

struct _FontManagerUserDataImportDialog {
	GObject parent_instance;
	FontManagerUserDataImportDialogPrivate * priv;
};

struct _FontManagerUserDataImportDialogClass {
	GObjectClass parent_class;
};

struct _FontManagerUserDataImportDialogPrivate {
	GtkWindow* parent;
	GtkFileDialog* file_dialog;
};

struct _FontManagerLanguageSettingsDialog {
	GtkWindow parent_instance;
	FontManagerLanguageSettingsDialogPrivate * priv;
};

struct _FontManagerLanguageSettingsDialogClass {
	GtkWindowClass parent_class;
};

struct _FontManagerLanguageSettingsDialogPrivate {
	FontManagerLanguageFilterSettings* _settings;
	GtkToggleButton* search_toggle;
};

struct _FontManagerProgressDialog {
	GtkWindow parent_instance;
	FontManagerProgressDialogPrivate * priv;
};

struct _FontManagerProgressDialogClass {
	GtkWindowClass parent_class;
};

struct _FontManagerProgressDialogPrivate {
	GtkLabel* _title_label;
	GtkLabel* _message_label;
	GtkOverlay* _overlay;
	GtkProgressBar* _progress_bar;
	GtkImage* app_icon;
};

struct _FontManagerRemoveDialog {
	GtkWindow parent_instance;
	FontManagerRemoveDialogPrivate * priv;
};

struct _FontManagerRemoveDialogClass {
	GtkWindowClass parent_class;
};

struct _FontManagerRemoveDialogPrivate {
	GtkButton* _cancel_button;
	GtkButton* _delete_button;
	GtkToggleButton* _search_toggle;
	FontManagerRemoveListView* _remove_list;
	GtkSearchBar* _search_bar;
	GtkSearchEntry* _entry;
	GtkStack* stack;
};

static gint FontManagerUserDataExportSettings_private_offset;
static gpointer font_manager_user_data_export_settings_parent_class = NULL;
static gint FontManagerUserDataExportDialog_private_offset;
static gpointer font_manager_user_data_export_dialog_parent_class = NULL;
static gint FontManagerUserDataImportDialog_private_offset;
static gpointer font_manager_user_data_import_dialog_parent_class = NULL;
static gint FontManagerLanguageSettingsDialog_private_offset;
static gpointer font_manager_language_settings_dialog_parent_class = NULL;
static gint FontManagerProgressDialog_private_offset;
static gpointer font_manager_progress_dialog_parent_class = NULL;
static gint FontManagerRemoveDialog_private_offset;
static gpointer font_manager_remove_dialog_parent_class = NULL;

VALA_EXTERN void font_manager_set_default_dialog_size (GtkWindow* parent,
                                           GtkWindow* dialog,
                                           gint w_percentage,
                                           gint h_percentage);
VALA_EXTERN GtkFileDialog* font_manager_file_selector_get_executable (void);
VALA_EXTERN GtkFileDialog* font_manager_file_selector_get_target_directory (void);
VALA_EXTERN GtkFileDialog* font_manager_file_selector_get_selections (void);
VALA_EXTERN GtkFileDialog* font_manager_file_selector_get_selected_sources (void);
VALA_EXTERN void font_manager_user_data_copy_config (const gchar* config_name,
                                         const gchar* destdir,
                                         GFileCopyFlags flags);
VALA_EXTERN GType font_manager_preference_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerPreferenceList, g_object_unref)
VALA_EXTERN GType font_manager_base_controls_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerBaseControls, g_object_unref)
VALA_EXTERN GType font_manager_user_data_export_settings_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerUserDataExportSettings, g_object_unref)
VALA_EXTERN FontManagerUserDataExportSettings* font_manager_user_data_export_settings_new (void);
VALA_EXTERN FontManagerUserDataExportSettings* font_manager_user_data_export_settings_construct (GType object_type);
VALA_EXTERN FontManagerPreferenceList* font_manager_preference_list_new (void);
VALA_EXTERN FontManagerPreferenceList* font_manager_preference_list_construct (GType object_type);
VALA_EXTERN GtkSwitch* font_manager_preference_list_add_preference_switch (FontManagerPreferenceList* self,
                                                               const gchar* name,
                                                               const gchar* tooltip);
static void font_manager_user_data_export_settings_set_settings (FontManagerUserDataExportSettings* self,
                                                          GtkSwitch* value);
static void font_manager_user_data_export_settings_set_collections (FontManagerUserDataExportSettings* self,
                                                             GtkSwitch* value);
static void font_manager_user_data_export_settings_set_sources (FontManagerUserDataExportSettings* self,
                                                         GtkSwitch* value);
static void font_manager_user_data_export_settings_set_fonts (FontManagerUserDataExportSettings* self,
                                                       GtkSwitch* value);
static void font_manager_user_data_export_settings_set_actions (FontManagerUserDataExportSettings* self,
                                                         GtkSwitch* value);
VALA_EXTERN GtkSwitch* font_manager_user_data_export_settings_get_settings (FontManagerUserDataExportSettings* self);
VALA_EXTERN GtkSwitch* font_manager_user_data_export_settings_get_collections (FontManagerUserDataExportSettings* self);
VALA_EXTERN GtkSwitch* font_manager_user_data_export_settings_get_sources (FontManagerUserDataExportSettings* self);
VALA_EXTERN GtkSwitch* font_manager_user_data_export_settings_get_fonts (FontManagerUserDataExportSettings* self);
VALA_EXTERN GtkSwitch* font_manager_user_data_export_settings_get_actions (FontManagerUserDataExportSettings* self);
static void font_manager_user_data_export_settings_finalize (GObject * obj);
static GType font_manager_user_data_export_settings_get_type_once (void);
static void _vala_font_manager_user_data_export_settings_get_property (GObject * object,
                                                                guint property_id,
                                                                GValue * value,
                                                                GParamSpec * pspec);
static void _vala_font_manager_user_data_export_settings_set_property (GObject * object,
                                                                guint property_id,
                                                                const GValue * value,
                                                                GParamSpec * pspec);
VALA_EXTERN GType font_manager_user_data_export_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerUserDataExportDialog, g_object_unref)
VALA_EXTERN FontManagerUserDataExportDialog* font_manager_user_data_export_dialog_new (GtkWindow* parent);
VALA_EXTERN FontManagerUserDataExportDialog* font_manager_user_data_export_dialog_construct (GType object_type,
                                                                                 GtkWindow* parent);
static void font_manager_user_data_export_dialog_set_export_settings (FontManagerUserDataExportDialog* self,
                                                               FontManagerUserDataExportSettings* value);
VALA_EXTERN FontManagerUserDataExportSettings* font_manager_user_data_export_dialog_get_export_settings (FontManagerUserDataExportDialog* self);
static void font_manager_user_data_export_dialog_on_cancel_clicked (FontManagerUserDataExportDialog* self);
static void _font_manager_user_data_export_dialog_on_cancel_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                                 gpointer self);
static void font_manager_user_data_export_dialog_on_export_clicked (FontManagerUserDataExportDialog* self);
static void font_manager_user_data_export_dialog_on_directory_selected (FontManagerUserDataExportDialog* self,
                                                                 GObject* object,
                                                                 GAsyncResult* _result_);
static void _font_manager_user_data_export_dialog_on_directory_selected_gasync_ready_callback (GObject* source_object,
                                                                                        GAsyncResult* res,
                                                                                        gpointer self);
static void _font_manager_user_data_export_dialog_on_export_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                                 gpointer self);
static void font_manager_user_data_export_dialog_export_to (FontManagerUserDataExportDialog* self,
                                                     GFile* target_directory);
VALA_EXTERN gboolean font_manager_copy_directory (GFile* source,
                                      GFile* destination,
                                      GFileCopyFlags flags);
static void font_manager_user_data_export_dialog_finalize (GObject * obj);
static GType font_manager_user_data_export_dialog_get_type_once (void);
static void _vala_font_manager_user_data_export_dialog_get_property (GObject * object,
                                                              guint property_id,
                                                              GValue * value,
                                                              GParamSpec * pspec);
static void _vala_font_manager_user_data_export_dialog_set_property (GObject * object,
                                                              guint property_id,
                                                              const GValue * value,
                                                              GParamSpec * pspec);
VALA_EXTERN GType font_manager_user_data_import_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerUserDataImportDialog, g_object_unref)
VALA_EXTERN FontManagerUserDataImportDialog* font_manager_user_data_import_dialog_new (GtkWindow* parent);
VALA_EXTERN FontManagerUserDataImportDialog* font_manager_user_data_import_dialog_construct (GType object_type,
                                                                                 GtkWindow* parent);
VALA_EXTERN void font_manager_user_data_import_dialog_present (FontManagerUserDataImportDialog* self);
static void font_manager_user_data_import_dialog_on_directory_selected (FontManagerUserDataImportDialog* self,
                                                                 GObject* object,
                                                                 GAsyncResult* _result_);
static void _font_manager_user_data_import_dialog_on_directory_selected_gasync_ready_callback (GObject* source_object,
                                                                                        GAsyncResult* res,
                                                                                        gpointer self);
static void font_manager_user_data_import_dialog_import_from (FontManagerUserDataImportDialog* self,
                                                       GFile* target_directory);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
static gboolean ___lambda211_ (FontManagerUserDataImportDialog* self);
VALA_EXTERN GType font_manager_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerApplication, g_object_unref)
VALA_EXTERN guint font_manager_application_register_object (void* object,
                                                GDBusConnection* connection,
                                                const gchar* path,
                                                GError** error);
VALA_EXTERN FontManagerApplication* font_manager_get_default_application (void);
VALA_EXTERN void font_manager_application_reload (FontManagerApplication* self);
static gboolean ____lambda211__gsource_func (gpointer self);
static void font_manager_user_data_import_dialog_finalize (GObject * obj);
static GType font_manager_user_data_import_dialog_get_type_once (void);
VALA_EXTERN GType font_manager_language_settings_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerLanguageSettingsDialog, g_object_unref)
VALA_EXTERN GType font_manager_language_filter_settings_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerLanguageFilterSettings, g_object_unref)
VALA_EXTERN FontManagerLanguageSettingsDialog* font_manager_language_settings_dialog_new (GtkWindow* parent,
                                                                              FontManagerLanguageFilterSettings* settings);
VALA_EXTERN FontManagerLanguageSettingsDialog* font_manager_language_settings_dialog_construct (GType object_type,
                                                                                    GtkWindow* parent,
                                                                                    FontManagerLanguageFilterSettings* settings);
VALA_EXTERN GtkSearchBar* font_manager_language_filter_settings_get_search_bar (FontManagerLanguageFilterSettings* self);
VALA_EXTERN FontManagerLanguageFilterSettings* font_manager_language_settings_dialog_get_settings (FontManagerLanguageSettingsDialog* self);
VALA_EXTERN void font_manager_language_settings_dialog_set_settings (FontManagerLanguageSettingsDialog* self,
                                                         FontManagerLanguageFilterSettings* value);
static void font_manager_language_settings_dialog_finalize (GObject * obj);
static GType font_manager_language_settings_dialog_get_type_once (void);
static void _vala_font_manager_language_settings_dialog_get_property (GObject * object,
                                                               guint property_id,
                                                               GValue * value,
                                                               GParamSpec * pspec);
static void _vala_font_manager_language_settings_dialog_set_property (GObject * object,
                                                               guint property_id,
                                                               const GValue * value,
                                                               GParamSpec * pspec);
VALA_EXTERN GType font_manager_progress_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerProgressDialog, g_object_unref)
VALA_EXTERN FontManagerProgressDialog* font_manager_progress_dialog_new (GtkWindow* parent,
                                                             const gchar* title);
VALA_EXTERN FontManagerProgressDialog* font_manager_progress_dialog_construct (GType object_type,
                                                                   GtkWindow* parent,
                                                                   const gchar* title);
VALA_EXTERN GtkProgressBar* font_manager_progress_dialog_get_progress_bar (FontManagerProgressDialog* self);
VALA_EXTERN GtkLabel* font_manager_progress_dialog_get_title_label (FontManagerProgressDialog* self);
VALA_EXTERN void font_manager_progress_dialog_update (FontManagerProgressDialog* self,
                                          FontManagerProgressData* data);
VALA_EXTERN GtkLabel* font_manager_progress_dialog_get_message_label (FontManagerProgressDialog* self);
VALA_EXTERN gboolean font_manager_progress_dialog_get_show_app_icon (FontManagerProgressDialog* self);
VALA_EXTERN void font_manager_progress_dialog_set_show_app_icon (FontManagerProgressDialog* self,
                                                     gboolean value);
VALA_EXTERN GtkOverlay* font_manager_progress_dialog_get_overlay (FontManagerProgressDialog* self);
static void font_manager_progress_dialog_finalize (GObject * obj);
static GType font_manager_progress_dialog_get_type_once (void);
static void _vala_font_manager_progress_dialog_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec);
static void _vala_font_manager_progress_dialog_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec);
VALA_EXTERN GType font_manager_remove_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerRemoveDialog, g_object_unref)
VALA_EXTERN GType font_manager_font_list_base_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerFontListBase, g_object_unref)
VALA_EXTERN GType font_manager_base_font_list_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerBaseFontListView, g_object_unref)
VALA_EXTERN GType font_manager_remove_list_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerRemoveListView, g_object_unref)
VALA_EXTERN FontManagerRemoveDialog* font_manager_remove_dialog_new (GtkWindow* parent);
VALA_EXTERN FontManagerRemoveDialog* font_manager_remove_dialog_construct (GType object_type,
                                                               GtkWindow* parent);
static void __lambda204_ (FontManagerRemoveDialog* self,
                   JsonArray* a,
                   guint i,
                   JsonNode* n);
static void __lambda205_ (FontManagerRemoveDialog* self,
                   JsonArray* a,
                   guint i,
                   JsonNode* n);
static void ___lambda205__json_array_foreach (JsonArray* array,
                                       guint index_,
                                       JsonNode* element_node,
                                       gpointer self);
static void ___lambda204__json_array_foreach (JsonArray* array,
                                       guint index_,
                                       JsonNode* element_node,
                                       gpointer self);
VALA_EXTERN void font_manager_update_item_preview_text (JsonArray* available_fonts);
VALA_EXTERN FontManagerRemoveListView* font_manager_remove_dialog_get_remove_list (FontManagerRemoveDialog* self);
VALA_EXTERN void font_manager_remove_list_view_set_search_entry (FontManagerRemoveListView* self,
                                                     GtkSearchEntry* entry);
VALA_EXTERN GtkSearchEntry* font_manager_remove_dialog_get_entry (FontManagerRemoveDialog* self);
VALA_EXTERN void font_manager_font_list_base_set_available_fonts (FontManagerFontListBase* self,
                                                      JsonArray* value);
VALA_EXTERN GtkButton* font_manager_remove_dialog_get_delete_button (FontManagerRemoveDialog* self);
static void __lambda208_ (FontManagerRemoveDialog* self);
VALA_EXTERN FontManagerStringSet* font_manager_remove_list_view_get_selected_files (FontManagerRemoveListView* self);
VALA_EXTERN GtkButton* font_manager_remove_dialog_get_cancel_button (FontManagerRemoveDialog* self);
static void ___lambda208__font_manager_remove_list_view_changed (FontManagerRemoveListView* _sender,
                                                          gpointer self);
VALA_EXTERN GType font_manager_base_font_model_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FontManagerBaseFontModel, g_object_unref)
VALA_EXTERN FontManagerBaseFontModel* font_manager_font_list_base_get_model (FontManagerFontListBase* self);
VALA_EXTERN guint font_manager_base_font_model_get_n_items (FontManagerBaseFontModel* self);
VALA_EXTERN GtkToggleButton* font_manager_remove_dialog_get_search_toggle (FontManagerRemoveDialog* self);
VALA_EXTERN GtkSearchBar* font_manager_remove_dialog_get_search_bar (FontManagerRemoveDialog* self);
static void font_manager_remove_dialog_on_cancel_clicked (FontManagerRemoveDialog* self);
static void _font_manager_remove_dialog_on_cancel_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                       gpointer self);
static void font_manager_remove_dialog_purge_selections (GTask* task,
                                                  GObject* source,
                                                  void* data,
                                                  GCancellable* cancellable);
VALA_EXTERN gboolean font_manager_remove_directory_tree_if_empty (GFile* dir);
VALA_EXTERN FontManagerDatabase* font_manager_database_proxy_get_default_db (void);
static void font_manager_remove_dialog_on_remove_finished (GObject* source,
                                                    GTask* task);
static void font_manager_remove_dialog_on_delete_clicked (FontManagerRemoveDialog* self);
static void _font_manager_remove_dialog_on_remove_finished_gasync_ready_callback (GObject* source_object,
                                                                           GTask* task,
                                                                           gpointer self);
static void _font_manager_remove_dialog_purge_selections_gtask_thread_func (GTask* task,
                                                                     GObject* source_object,
                                                                     void* task_data,
                                                                     GCancellable* cancellable);
static void _font_manager_remove_dialog_on_delete_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                       gpointer self);
static void font_manager_remove_dialog_finalize (GObject * obj);
static GType font_manager_remove_dialog_get_type_once (void);
static void _vala_font_manager_remove_dialog_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

const gchar* FONT_MANAGER_FONT_MIMETYPES[7] = {"application/x-font-ttf", "application/x-font-ttc", "application/x-font-otf", "font/ttf", "font/ttc", "font/otf", "font/collection"};
VALA_EXTERN const gchar* FONT_MANAGER_LIBARCHIVE_MIME_TYPES[26];

void
font_manager_set_default_dialog_size (GtkWindow* parent,
                                      GtkWindow* dialog,
                                      gint w_percentage,
                                      gint h_percentage)
{
	gint width = 0;
	gint height = 0;
	g_return_if_fail (parent != NULL);
	g_return_if_fail (dialog != NULL);
	width = (gint) ((gtk_widget_get_width ((GtkWidget*) parent) / 10) * (w_percentage / 10));
	height = (gint) ((gtk_widget_get_height ((GtkWidget*) parent) / 10) * (h_percentage / 10));
	gtk_window_set_default_size (dialog, width, height);
	return;
}

GtkFileDialog*
font_manager_file_selector_get_executable (void)
{
	GtkFileDialog* dialog = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GtkFileDialog* _tmp2_ = NULL;
	GFile* bindir = NULL;
	GFile* _tmp3_;
	GtkFileDialog* result;
	_tmp0_ = g_strdup (_ ("_Select"));
	_tmp1_ = g_strdup (_ ("Select Executable"));
	_tmp2_ = gtk_file_dialog_new ();
	gtk_file_dialog_set_modal (_tmp2_, TRUE);
	gtk_file_dialog_set_accept_label (_tmp2_, _tmp0_);
	_g_free0 (_tmp0_);
	gtk_file_dialog_set_title (_tmp2_, _tmp1_);
	_g_free0 (_tmp1_);
	dialog = _tmp2_;
	_tmp3_ = g_file_new_for_path (BINDIR);
	bindir = _tmp3_;
	gtk_file_dialog_set_initial_folder (dialog, bindir);
	result = dialog;
	_g_object_unref0 (bindir);
	return result;
}

GtkFileDialog*
font_manager_file_selector_get_target_directory (void)
{
	GtkFileDialog* dialog = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GtkFileDialog* _tmp2_ = NULL;
	GtkFileDialog* result;
	_tmp0_ = g_strdup (_ ("_Select"));
	_tmp1_ = g_strdup (_ ("Select a Directory"));
	_tmp2_ = gtk_file_dialog_new ();
	gtk_file_dialog_set_modal (_tmp2_, TRUE);
	gtk_file_dialog_set_accept_label (_tmp2_, _tmp0_);
	_g_free0 (_tmp0_);
	gtk_file_dialog_set_title (_tmp2_, _tmp1_);
	_g_free0 (_tmp1_);
	dialog = _tmp2_;
	result = dialog;
	return result;
}

GtkFileDialog*
font_manager_file_selector_get_selections (void)
{
	GtkFileFilter* filter = NULL;
	GtkFileFilter* _tmp0_;
	GString* filter_name = NULL;
	GString* _tmp1_;
	GString* _tmp2_;
	GString* _tmp3_;
	GString* _tmp4_;
	GString* _tmp5_;
	GString* _tmp6_;
	GtkFileDialog* dialog = NULL;
	gchar* _tmp12_;
	GtkFileDialog* _tmp13_ = NULL;
	GtkFileFilter* _tmp14_;
	GtkFileFilter* _tmp15_;
	GString* _tmp16_;
	const gchar* _tmp17_;
	GtkFileDialog* result;
	_tmp0_ = gtk_file_filter_new ();
	filter = _tmp0_;
	_tmp1_ = g_string_new ("");
	filter_name = _tmp1_;
	_tmp2_ = filter_name;
	g_string_append (_tmp2_, _ ("TrueType"));
	_tmp3_ = filter_name;
	g_string_append (_tmp3_, ", ");
	_tmp4_ = filter_name;
	g_string_append (_tmp4_, _ ("OpenType"));
	_tmp5_ = filter_name;
	g_string_append (_tmp5_, ", ");
	_tmp6_ = filter_name;
	g_string_append (_tmp6_, _ ("Archive Files"));
	{
		const gchar** mimetype_collection = NULL;
		gint mimetype_collection_length1 = 0;
		gint _mimetype_collection_size_ = 0;
		gint mimetype_it = 0;
		mimetype_collection = FONT_MANAGER_LIBARCHIVE_MIME_TYPES;
		mimetype_collection_length1 = G_N_ELEMENTS (FONT_MANAGER_LIBARCHIVE_MIME_TYPES);
		for (mimetype_it = 0; mimetype_it < mimetype_collection_length1; mimetype_it = mimetype_it + 1) {
			gchar* _tmp7_;
			gchar* mimetype = NULL;
			_tmp7_ = g_strdup (mimetype_collection[mimetype_it]);
			mimetype = _tmp7_;
			{
				GtkFileFilter* _tmp8_;
				const gchar* _tmp9_;
				_tmp8_ = filter;
				_tmp9_ = mimetype;
				gtk_file_filter_add_mime_type (_tmp8_, _tmp9_);
				_g_free0 (mimetype);
			}
		}
	}
	{
		const gchar** mimetype_collection = NULL;
		gint mimetype_collection_length1 = 0;
		gint _mimetype_collection_size_ = 0;
		gint mimetype_it = 0;
		mimetype_collection = FONT_MANAGER_FONT_MIMETYPES;
		mimetype_collection_length1 = G_N_ELEMENTS (FONT_MANAGER_FONT_MIMETYPES);
		for (mimetype_it = 0; mimetype_it < mimetype_collection_length1; mimetype_it = mimetype_it + 1) {
			const gchar* mimetype = NULL;
			mimetype = mimetype_collection[mimetype_it];
			{
				GtkFileFilter* _tmp10_;
				const gchar* _tmp11_;
				_tmp10_ = filter;
				_tmp11_ = mimetype;
				gtk_file_filter_add_mime_type (_tmp10_, _tmp11_);
			}
		}
	}
	_tmp12_ = g_strdup (_ ("Select Files to Install"));
	_tmp13_ = gtk_file_dialog_new ();
	gtk_file_dialog_set_modal (_tmp13_, TRUE);
	gtk_file_dialog_set_title (_tmp13_, _tmp12_);
	_g_free0 (_tmp12_);
	dialog = _tmp13_;
	_tmp14_ = filter;
	gtk_file_dialog_set_default_filter (dialog, _tmp14_);
	_tmp15_ = filter;
	_tmp16_ = filter_name;
	_tmp17_ = _tmp16_->str;
	g_object_set (_tmp15_, "name", _tmp17_, NULL);
	result = dialog;
	_g_string_free0 (filter_name);
	_g_object_unref0 (filter);
	return result;
}

GtkFileDialog*
font_manager_file_selector_get_selected_sources (void)
{
	GtkFileDialog* dialog = NULL;
	gchar* _tmp0_;
	GtkFileDialog* _tmp1_ = NULL;
	GtkFileDialog* result;
	_tmp0_ = g_strdup (_ ("Select Source Directories"));
	_tmp1_ = gtk_file_dialog_new ();
	gtk_file_dialog_set_modal (_tmp1_, TRUE);
	gtk_file_dialog_set_title (_tmp1_, _tmp0_);
	_g_free0 (_tmp0_);
	dialog = _tmp1_;
	result = dialog;
	return result;
}

void
font_manager_user_data_copy_config (const gchar* config_name,
                                    const gchar* destdir,
                                    GFileCopyFlags flags)
{
	gchar* config_dir = NULL;
	gchar* _tmp0_;
	gchar* filepath = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GFile* config = NULL;
	const gchar* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (config_name != NULL);
	g_return_if_fail (destdir != NULL);
	_tmp0_ = font_manager_get_package_config_directory ();
	config_dir = _tmp0_;
	_tmp1_ = config_dir;
	_tmp2_ = g_build_filename (_tmp1_, config_name, NULL);
	filepath = _tmp2_;
	_tmp3_ = filepath;
	_tmp4_ = g_file_new_for_path (_tmp3_);
	config = _tmp4_;
	_tmp5_ = config;
	if (g_file_query_exists (_tmp5_, NULL)) {
		GFile* target = NULL;
		gchar* _tmp6_;
		gchar* _tmp7_;
		GFile* _tmp8_;
		GFile* _tmp9_;
		_tmp6_ = g_build_filename (destdir, config_name, NULL);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_file_new_for_path (_tmp7_);
		_tmp9_ = _tmp8_;
		_g_free0 (_tmp7_);
		target = _tmp9_;
		{
			GFile* _tmp10_;
			GFile* _tmp11_;
			_tmp10_ = config;
			_tmp11_ = target;
			g_file_copy (_tmp10_, _tmp11_, flags, NULL, NULL, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp12_;
			const gchar* _tmp13_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp12_ = e;
			_tmp13_ = _tmp12_->message;
			g_critical ("Dialogs.vala:109: %s", _tmp13_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (target);
			_g_object_unref0 (config);
			_g_free0 (filepath);
			_g_free0 (config_dir);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_g_object_unref0 (target);
	}
	_g_object_unref0 (config);
	_g_free0 (filepath);
	_g_free0 (config_dir);
	return;
}

static inline gpointer
font_manager_user_data_export_settings_get_instance_private (FontManagerUserDataExportSettings* self)
{
	return G_STRUCT_MEMBER_P (self, FontManagerUserDataExportSettings_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

FontManagerUserDataExportSettings*
font_manager_user_data_export_settings_construct (GType object_type)
{
	FontManagerUserDataExportSettings * self = NULL;
	FontManagerBaseControls* _tmp0_;
	GtkSwitch* _tmp1_;
	GtkSwitch* _tmp2_;
	GtkSwitch* _tmp3_;
	GtkSwitch* _tmp4_;
	GtkSwitch* _tmp5_;
	GtkSwitch* _tmp6_;
	GtkSwitch* _tmp7_;
	GtkSwitch* _tmp8_;
	GtkSwitch* _tmp9_;
	GtkSwitch* _tmp10_;
	GtkSwitch** switches = NULL;
	GtkSwitch* _tmp11_;
	GtkSwitch* _tmp12_;
	GtkSwitch* _tmp13_;
	GtkSwitch* _tmp14_;
	GtkSwitch* _tmp15_;
	GtkSwitch* _tmp16_;
	GtkSwitch* _tmp17_;
	GtkSwitch* _tmp18_;
	GtkSwitch* _tmp19_;
	GtkSwitch* _tmp20_;
	GtkSwitch** _tmp21_;
	gint switches_length1;
	gint _switches_size_;
	GtkSwitch** _tmp22_;
	gint _tmp22__length1;
	self = (FontManagerUserDataExportSettings*) font_manager_preference_list_construct (object_type);
	_tmp0_ = ((FontManagerPreferenceList*) self)->controls;
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, FALSE);
	_tmp1_ = font_manager_preference_list_add_preference_switch ((FontManagerPreferenceList*) self, _ ("Font Configuration"), NULL);
	_tmp2_ = _tmp1_;
	font_manager_user_data_export_settings_set_settings (self, _tmp2_);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = font_manager_preference_list_add_preference_switch ((FontManagerPreferenceList*) self, _ ("Font Collections"), NULL);
	_tmp4_ = _tmp3_;
	font_manager_user_data_export_settings_set_collections (self, _tmp4_);
	_g_object_unref0 (_tmp4_);
	_tmp5_ = font_manager_preference_list_add_preference_switch ((FontManagerPreferenceList*) self, _ ("Font Sources"), NULL);
	_tmp6_ = _tmp5_;
	font_manager_user_data_export_settings_set_sources (self, _tmp6_);
	_g_object_unref0 (_tmp6_);
	_tmp7_ = font_manager_preference_list_add_preference_switch ((FontManagerPreferenceList*) self, _ ("Installed Fonts"), NULL);
	_tmp8_ = _tmp7_;
	font_manager_user_data_export_settings_set_fonts (self, _tmp8_);
	_g_object_unref0 (_tmp8_);
	_tmp9_ = font_manager_preference_list_add_preference_switch ((FontManagerPreferenceList*) self, _ ("Custom Actions"), NULL);
	_tmp10_ = _tmp9_;
	font_manager_user_data_export_settings_set_actions (self, _tmp10_);
	_g_object_unref0 (_tmp10_);
	_tmp11_ = self->priv->_settings;
	_tmp12_ = _g_object_ref0 (_tmp11_);
	_tmp13_ = self->priv->_collections;
	_tmp14_ = _g_object_ref0 (_tmp13_);
	_tmp15_ = self->priv->_sources;
	_tmp16_ = _g_object_ref0 (_tmp15_);
	_tmp17_ = self->priv->_fonts;
	_tmp18_ = _g_object_ref0 (_tmp17_);
	_tmp19_ = self->priv->_actions;
	_tmp20_ = _g_object_ref0 (_tmp19_);
	_tmp21_ = g_new0 (GtkSwitch*, 5 + 1);
	_tmp21_[0] = _tmp12_;
	_tmp21_[1] = _tmp14_;
	_tmp21_[2] = _tmp16_;
	_tmp21_[3] = _tmp18_;
	_tmp21_[4] = _tmp20_;
	switches = _tmp21_;
	switches_length1 = 5;
	_switches_size_ = switches_length1;
	_tmp22_ = switches;
	_tmp22__length1 = switches_length1;
	{
		GtkSwitch** widget_collection = NULL;
		gint widget_collection_length1 = 0;
		gint _widget_collection_size_ = 0;
		gint widget_it = 0;
		widget_collection = _tmp22_;
		widget_collection_length1 = _tmp22__length1;
		for (widget_it = 0; widget_it < widget_collection_length1; widget_it = widget_it + 1) {
			GtkSwitch* _tmp23_;
			GtkSwitch* widget = NULL;
			_tmp23_ = _g_object_ref0 (widget_collection[widget_it]);
			widget = _tmp23_;
			{
				GtkSwitch* _tmp24_;
				_tmp24_ = widget;
				gtk_switch_set_active (_tmp24_, TRUE);
				_g_object_unref0 (widget);
			}
		}
	}
	switches = (_vala_array_free (switches, switches_length1, (GDestroyNotify) g_object_unref), NULL);
	return self;
}

FontManagerUserDataExportSettings*
font_manager_user_data_export_settings_new (void)
{
	return font_manager_user_data_export_settings_construct (FONT_MANAGER_USER_DATA_TYPE_EXPORT_SETTINGS);
}

GtkSwitch*
font_manager_user_data_export_settings_get_settings (FontManagerUserDataExportSettings* self)
{
	GtkSwitch* result;
	GtkSwitch* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_settings;
	result = _tmp0_;
	return result;
}

static void
font_manager_user_data_export_settings_set_settings (FontManagerUserDataExportSettings* self,
                                                     GtkSwitch* value)
{
	GtkSwitch* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_user_data_export_settings_get_settings (self);
	if (old_value != value) {
		GtkSwitch* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_settings);
		self->priv->_settings = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_user_data_export_settings_properties[FONT_MANAGER_USER_DATA_EXPORT_SETTINGS_SETTINGS_PROPERTY]);
	}
}

GtkSwitch*
font_manager_user_data_export_settings_get_collections (FontManagerUserDataExportSettings* self)
{
	GtkSwitch* result;
	GtkSwitch* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_collections;
	result = _tmp0_;
	return result;
}

static void
font_manager_user_data_export_settings_set_collections (FontManagerUserDataExportSettings* self,
                                                        GtkSwitch* value)
{
	GtkSwitch* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_user_data_export_settings_get_collections (self);
	if (old_value != value) {
		GtkSwitch* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_collections);
		self->priv->_collections = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_user_data_export_settings_properties[FONT_MANAGER_USER_DATA_EXPORT_SETTINGS_COLLECTIONS_PROPERTY]);
	}
}

GtkSwitch*
font_manager_user_data_export_settings_get_sources (FontManagerUserDataExportSettings* self)
{
	GtkSwitch* result;
	GtkSwitch* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_sources;
	result = _tmp0_;
	return result;
}

static void
font_manager_user_data_export_settings_set_sources (FontManagerUserDataExportSettings* self,
                                                    GtkSwitch* value)
{
	GtkSwitch* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_user_data_export_settings_get_sources (self);
	if (old_value != value) {
		GtkSwitch* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_sources);
		self->priv->_sources = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_user_data_export_settings_properties[FONT_MANAGER_USER_DATA_EXPORT_SETTINGS_SOURCES_PROPERTY]);
	}
}

GtkSwitch*
font_manager_user_data_export_settings_get_fonts (FontManagerUserDataExportSettings* self)
{
	GtkSwitch* result;
	GtkSwitch* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_fonts;
	result = _tmp0_;
	return result;
}

static void
font_manager_user_data_export_settings_set_fonts (FontManagerUserDataExportSettings* self,
                                                  GtkSwitch* value)
{
	GtkSwitch* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_user_data_export_settings_get_fonts (self);
	if (old_value != value) {
		GtkSwitch* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_fonts);
		self->priv->_fonts = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_user_data_export_settings_properties[FONT_MANAGER_USER_DATA_EXPORT_SETTINGS_FONTS_PROPERTY]);
	}
}

GtkSwitch*
font_manager_user_data_export_settings_get_actions (FontManagerUserDataExportSettings* self)
{
	GtkSwitch* result;
	GtkSwitch* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_actions;
	result = _tmp0_;
	return result;
}

static void
font_manager_user_data_export_settings_set_actions (FontManagerUserDataExportSettings* self,
                                                    GtkSwitch* value)
{
	GtkSwitch* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_user_data_export_settings_get_actions (self);
	if (old_value != value) {
		GtkSwitch* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_actions);
		self->priv->_actions = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_user_data_export_settings_properties[FONT_MANAGER_USER_DATA_EXPORT_SETTINGS_ACTIONS_PROPERTY]);
	}
}

static void
font_manager_user_data_export_settings_class_init (FontManagerUserDataExportSettingsClass * klass,
                                                   gpointer klass_data)
{
	font_manager_user_data_export_settings_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FontManagerUserDataExportSettings_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_font_manager_user_data_export_settings_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_font_manager_user_data_export_settings_set_property;
	G_OBJECT_CLASS (klass)->finalize = font_manager_user_data_export_settings_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_USER_DATA_EXPORT_SETTINGS_SETTINGS_PROPERTY, font_manager_user_data_export_settings_properties[FONT_MANAGER_USER_DATA_EXPORT_SETTINGS_SETTINGS_PROPERTY] = g_param_spec_object ("settings", "settings", "settings", gtk_switch_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_USER_DATA_EXPORT_SETTINGS_COLLECTIONS_PROPERTY, font_manager_user_data_export_settings_properties[FONT_MANAGER_USER_DATA_EXPORT_SETTINGS_COLLECTIONS_PROPERTY] = g_param_spec_object ("collections", "collections", "collections", gtk_switch_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_USER_DATA_EXPORT_SETTINGS_SOURCES_PROPERTY, font_manager_user_data_export_settings_properties[FONT_MANAGER_USER_DATA_EXPORT_SETTINGS_SOURCES_PROPERTY] = g_param_spec_object ("sources", "sources", "sources", gtk_switch_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_USER_DATA_EXPORT_SETTINGS_FONTS_PROPERTY, font_manager_user_data_export_settings_properties[FONT_MANAGER_USER_DATA_EXPORT_SETTINGS_FONTS_PROPERTY] = g_param_spec_object ("fonts", "fonts", "fonts", gtk_switch_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_USER_DATA_EXPORT_SETTINGS_ACTIONS_PROPERTY, font_manager_user_data_export_settings_properties[FONT_MANAGER_USER_DATA_EXPORT_SETTINGS_ACTIONS_PROPERTY] = g_param_spec_object ("actions", "actions", "actions", gtk_switch_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
font_manager_user_data_export_settings_instance_init (FontManagerUserDataExportSettings * self,
                                                      gpointer klass)
{
	self->priv = font_manager_user_data_export_settings_get_instance_private (self);
}

static void
font_manager_user_data_export_settings_finalize (GObject * obj)
{
	FontManagerUserDataExportSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FONT_MANAGER_USER_DATA_TYPE_EXPORT_SETTINGS, FontManagerUserDataExportSettings);
	_g_object_unref0 (self->priv->_settings);
	_g_object_unref0 (self->priv->_collections);
	_g_object_unref0 (self->priv->_sources);
	_g_object_unref0 (self->priv->_fonts);
	_g_object_unref0 (self->priv->_actions);
	G_OBJECT_CLASS (font_manager_user_data_export_settings_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
font_manager_user_data_export_settings_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FontManagerUserDataExportSettingsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) font_manager_user_data_export_settings_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FontManagerUserDataExportSettings), 0, (GInstanceInitFunc) font_manager_user_data_export_settings_instance_init, NULL };
	GType font_manager_user_data_export_settings_type_id;
	font_manager_user_data_export_settings_type_id = g_type_register_static (FONT_MANAGER_TYPE_PREFERENCE_LIST, "FontManagerUserDataExportSettings", &g_define_type_info, 0);
	FontManagerUserDataExportSettings_private_offset = g_type_add_instance_private (font_manager_user_data_export_settings_type_id, sizeof (FontManagerUserDataExportSettingsPrivate));
	return font_manager_user_data_export_settings_type_id;
}

GType
font_manager_user_data_export_settings_get_type (void)
{
	static volatile gsize font_manager_user_data_export_settings_type_id__once = 0;
	if (g_once_init_enter (&font_manager_user_data_export_settings_type_id__once)) {
		GType font_manager_user_data_export_settings_type_id;
		font_manager_user_data_export_settings_type_id = font_manager_user_data_export_settings_get_type_once ();
		g_once_init_leave (&font_manager_user_data_export_settings_type_id__once, font_manager_user_data_export_settings_type_id);
	}
	return font_manager_user_data_export_settings_type_id__once;
}

static void
_vala_font_manager_user_data_export_settings_get_property (GObject * object,
                                                           guint property_id,
                                                           GValue * value,
                                                           GParamSpec * pspec)
{
	FontManagerUserDataExportSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_USER_DATA_TYPE_EXPORT_SETTINGS, FontManagerUserDataExportSettings);
	switch (property_id) {
		case FONT_MANAGER_USER_DATA_EXPORT_SETTINGS_SETTINGS_PROPERTY:
		g_value_set_object (value, font_manager_user_data_export_settings_get_settings (self));
		break;
		case FONT_MANAGER_USER_DATA_EXPORT_SETTINGS_COLLECTIONS_PROPERTY:
		g_value_set_object (value, font_manager_user_data_export_settings_get_collections (self));
		break;
		case FONT_MANAGER_USER_DATA_EXPORT_SETTINGS_SOURCES_PROPERTY:
		g_value_set_object (value, font_manager_user_data_export_settings_get_sources (self));
		break;
		case FONT_MANAGER_USER_DATA_EXPORT_SETTINGS_FONTS_PROPERTY:
		g_value_set_object (value, font_manager_user_data_export_settings_get_fonts (self));
		break;
		case FONT_MANAGER_USER_DATA_EXPORT_SETTINGS_ACTIONS_PROPERTY:
		g_value_set_object (value, font_manager_user_data_export_settings_get_actions (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_font_manager_user_data_export_settings_set_property (GObject * object,
                                                           guint property_id,
                                                           const GValue * value,
                                                           GParamSpec * pspec)
{
	FontManagerUserDataExportSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_USER_DATA_TYPE_EXPORT_SETTINGS, FontManagerUserDataExportSettings);
	switch (property_id) {
		case FONT_MANAGER_USER_DATA_EXPORT_SETTINGS_SETTINGS_PROPERTY:
		font_manager_user_data_export_settings_set_settings (self, g_value_get_object (value));
		break;
		case FONT_MANAGER_USER_DATA_EXPORT_SETTINGS_COLLECTIONS_PROPERTY:
		font_manager_user_data_export_settings_set_collections (self, g_value_get_object (value));
		break;
		case FONT_MANAGER_USER_DATA_EXPORT_SETTINGS_SOURCES_PROPERTY:
		font_manager_user_data_export_settings_set_sources (self, g_value_get_object (value));
		break;
		case FONT_MANAGER_USER_DATA_EXPORT_SETTINGS_FONTS_PROPERTY:
		font_manager_user_data_export_settings_set_fonts (self, g_value_get_object (value));
		break;
		case FONT_MANAGER_USER_DATA_EXPORT_SETTINGS_ACTIONS_PROPERTY:
		font_manager_user_data_export_settings_set_actions (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
font_manager_user_data_export_dialog_get_instance_private (FontManagerUserDataExportDialog* self)
{
	return G_STRUCT_MEMBER_P (self, FontManagerUserDataExportDialog_private_offset);
}

FontManagerUserDataExportDialog*
font_manager_user_data_export_dialog_construct (GType object_type,
                                                GtkWindow* parent)
{
	FontManagerUserDataExportDialog * self = NULL;
	FontManagerUserDataExportSettings* _tmp0_;
	FontManagerUserDataExportSettings* _tmp1_;
	FontManagerUserDataExportSettings* _tmp2_;
	self = (FontManagerUserDataExportDialog*) g_object_new (object_type, NULL);
	gtk_window_set_transient_for ((GtkWindow*) self, parent);
	font_manager_set_default_dialog_size (parent, (GtkWindow*) self, 50, 70);
	_tmp0_ = font_manager_user_data_export_settings_new ();
	g_object_ref_sink (_tmp0_);
	_tmp1_ = _tmp0_;
	font_manager_user_data_export_dialog_set_export_settings (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = self->priv->_export_settings;
	gtk_window_set_child ((GtkWindow*) self, (GtkWidget*) _tmp2_);
	return self;
}

FontManagerUserDataExportDialog*
font_manager_user_data_export_dialog_new (GtkWindow* parent)
{
	return font_manager_user_data_export_dialog_construct (FONT_MANAGER_USER_DATA_TYPE_EXPORT_DIALOG, parent);
}

static void
font_manager_user_data_export_dialog_on_cancel_clicked (FontManagerUserDataExportDialog* self)
{
	g_return_if_fail (self != NULL);
	gtk_window_destroy ((GtkWindow*) self);
	return;
}

static void
_font_manager_user_data_export_dialog_on_cancel_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                            gpointer self)
{
	font_manager_user_data_export_dialog_on_cancel_clicked ((FontManagerUserDataExportDialog*) self);
}

static void
_font_manager_user_data_export_dialog_on_directory_selected_gasync_ready_callback (GObject* source_object,
                                                                                   GAsyncResult* res,
                                                                                   gpointer self)
{
	font_manager_user_data_export_dialog_on_directory_selected ((FontManagerUserDataExportDialog*) self, source_object, res);
	g_object_unref (self);
}

static void
font_manager_user_data_export_dialog_on_export_clicked (FontManagerUserDataExportDialog* self)
{
	GtkFileDialog* dialog = NULL;
	GtkFileDialog* _tmp0_;
	GtkWindow* _tmp1_;
	g_return_if_fail (self != NULL);
	gtk_widget_hide ((GtkWidget*) self);
	_tmp0_ = font_manager_file_selector_get_target_directory ();
	dialog = _tmp0_;
	_tmp1_ = gtk_window_get_transient_for ((GtkWindow*) self);
	gtk_file_dialog_select_folder (dialog, _tmp1_, NULL, _font_manager_user_data_export_dialog_on_directory_selected_gasync_ready_callback, g_object_ref (self));
	_g_object_unref0 (dialog);
	return;
}

static void
_font_manager_user_data_export_dialog_on_export_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                            gpointer self)
{
	font_manager_user_data_export_dialog_on_export_clicked ((FontManagerUserDataExportDialog*) self);
}

static void
font_manager_user_data_export_dialog_export_to (FontManagerUserDataExportDialog* self,
                                                GFile* target_directory)
{
	GFileCopyFlags flags = 0U;
	GDateTime* date = NULL;
	GDateTime* _tmp0_;
	gchar* dirname = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* dest = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GFile* destination = NULL;
	GFile* _tmp9_;
	FontManagerUserDataExportSettings* _tmp12_;
	GtkSwitch* _tmp13_;
	GtkSwitch* _tmp14_;
	gboolean _tmp15_;
	gboolean _tmp16_;
	FontManagerUserDataExportSettings* _tmp19_;
	GtkSwitch* _tmp20_;
	GtkSwitch* _tmp21_;
	gboolean _tmp22_;
	gboolean _tmp23_;
	FontManagerUserDataExportSettings* _tmp26_;
	GtkSwitch* _tmp27_;
	GtkSwitch* _tmp28_;
	gboolean _tmp29_;
	gboolean _tmp30_;
	FontManagerUserDataExportSettings* _tmp35_;
	GtkSwitch* _tmp36_;
	GtkSwitch* _tmp37_;
	gboolean _tmp38_;
	gboolean _tmp39_;
	FontManagerUserDataExportSettings* _tmp51_;
	GtkSwitch* _tmp52_;
	GtkSwitch* _tmp53_;
	gboolean _tmp54_;
	gboolean _tmp55_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (target_directory != NULL);
	flags = (G_FILE_COPY_OVERWRITE | G_FILE_COPY_ALL_METADATA) | G_FILE_COPY_TARGET_DEFAULT_PERMS;
	_tmp0_ = g_date_time_new_now_local ();
	date = _tmp0_;
	_tmp1_ = g_date_time_format (date, "%F");
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf ("%s_%s", PACKAGE_NAME, _tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	dirname = _tmp4_;
	_tmp5_ = g_file_get_path (target_directory);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_build_filename (_tmp6_, dirname, NULL);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	dest = _tmp8_;
	_tmp9_ = g_file_new_for_path (dest);
	destination = _tmp9_;
	{
		g_file_make_directory_with_parents (destination, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		g_critical ("Dialogs.vala:174: %s", _tmp11_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (destination);
		_g_free0 (dest);
		_g_free0 (dirname);
		_g_date_time_unref0 (date);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp12_ = self->priv->_export_settings;
	_tmp13_ = font_manager_user_data_export_settings_get_actions (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = gtk_switch_get_active (_tmp14_);
	_tmp16_ = _tmp15_;
	if (_tmp16_) {
		gchar* _tmp17_;
		gchar* _tmp18_;
		_tmp17_ = g_file_get_path (destination);
		_tmp18_ = _tmp17_;
		font_manager_user_data_copy_config ("Actions.json", _tmp18_, flags);
		_g_free0 (_tmp18_);
	}
	_tmp19_ = self->priv->_export_settings;
	_tmp20_ = font_manager_user_data_export_settings_get_sources (_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = gtk_switch_get_active (_tmp21_);
	_tmp23_ = _tmp22_;
	if (_tmp23_) {
		gchar* _tmp24_;
		gchar* _tmp25_;
		_tmp24_ = g_file_get_path (destination);
		_tmp25_ = _tmp24_;
		font_manager_user_data_copy_config ("Sources.xml", _tmp25_, flags);
		_g_free0 (_tmp25_);
	}
	_tmp26_ = self->priv->_export_settings;
	_tmp27_ = font_manager_user_data_export_settings_get_collections (_tmp26_);
	_tmp28_ = _tmp27_;
	_tmp29_ = gtk_switch_get_active (_tmp28_);
	_tmp30_ = _tmp29_;
	if (_tmp30_) {
		gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		_tmp31_ = g_file_get_path (destination);
		_tmp32_ = _tmp31_;
		font_manager_user_data_copy_config ("Collections.json", _tmp32_, flags);
		_g_free0 (_tmp32_);
		_tmp33_ = g_file_get_path (destination);
		_tmp34_ = _tmp33_;
		font_manager_user_data_copy_config ("Comparisons.json", _tmp34_, flags);
		_g_free0 (_tmp34_);
	}
	_tmp35_ = self->priv->_export_settings;
	_tmp36_ = font_manager_user_data_export_settings_get_settings (_tmp35_);
	_tmp37_ = _tmp36_;
	_tmp38_ = gtk_switch_get_active (_tmp37_);
	_tmp39_ = _tmp38_;
	if (_tmp39_) {
		gchar* settings_dir = NULL;
		gchar* _tmp40_;
		gchar* dest_dir = NULL;
		gchar* _tmp41_;
		gchar* _tmp42_;
		gchar* _tmp43_;
		gchar* _tmp44_;
		const gchar* _tmp45_;
		GFile* _tmp46_;
		GFile* _tmp47_;
		const gchar* _tmp48_;
		GFile* _tmp49_;
		GFile* _tmp50_;
		_tmp40_ = font_manager_get_user_fontconfig_directory ();
		settings_dir = _tmp40_;
		_tmp41_ = g_file_get_path (destination);
		_tmp42_ = _tmp41_;
		_tmp43_ = g_build_filename (_tmp42_, "fontconfig", "conf.d", NULL);
		_tmp44_ = _tmp43_;
		_g_free0 (_tmp42_);
		dest_dir = _tmp44_;
		_tmp45_ = settings_dir;
		_tmp46_ = g_file_new_for_path (_tmp45_);
		_tmp47_ = _tmp46_;
		_tmp48_ = dest_dir;
		_tmp49_ = g_file_new_for_path (_tmp48_);
		_tmp50_ = _tmp49_;
		font_manager_copy_directory (_tmp47_, _tmp50_, flags);
		_g_object_unref0 (_tmp50_);
		_g_object_unref0 (_tmp47_);
		_g_free0 (dest_dir);
		_g_free0 (settings_dir);
	}
	_tmp51_ = self->priv->_export_settings;
	_tmp52_ = font_manager_user_data_export_settings_get_fonts (_tmp51_);
	_tmp53_ = _tmp52_;
	_tmp54_ = gtk_switch_get_active (_tmp53_);
	_tmp55_ = _tmp54_;
	if (_tmp55_) {
		gchar* font_dir = NULL;
		gchar* _tmp56_;
		gchar* dest_dir = NULL;
		gchar* _tmp57_;
		gchar* _tmp58_;
		gchar* _tmp59_;
		gchar* _tmp60_;
		const gchar* _tmp61_;
		GFile* _tmp62_;
		GFile* _tmp63_;
		const gchar* _tmp64_;
		GFile* _tmp65_;
		GFile* _tmp66_;
		_tmp56_ = font_manager_get_user_font_directory ();
		font_dir = _tmp56_;
		_tmp57_ = g_file_get_path (destination);
		_tmp58_ = _tmp57_;
		_tmp59_ = g_build_filename (_tmp58_, "fonts", NULL);
		_tmp60_ = _tmp59_;
		_g_free0 (_tmp58_);
		dest_dir = _tmp60_;
		_tmp61_ = font_dir;
		_tmp62_ = g_file_new_for_path (_tmp61_);
		_tmp63_ = _tmp62_;
		_tmp64_ = dest_dir;
		_tmp65_ = g_file_new_for_path (_tmp64_);
		_tmp66_ = _tmp65_;
		font_manager_copy_directory (_tmp63_, _tmp66_, flags);
		_g_object_unref0 (_tmp66_);
		_g_object_unref0 (_tmp63_);
		_g_free0 (dest_dir);
		_g_free0 (font_dir);
	}
	_g_object_unref0 (destination);
	_g_free0 (dest);
	_g_free0 (dirname);
	_g_date_time_unref0 (date);
	return;
}

static void
font_manager_user_data_export_dialog_on_directory_selected (FontManagerUserDataExportDialog* self,
                                                            GObject* object,
                                                            GAsyncResult* _result_)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_result_ != NULL);
	{
		GtkFileDialog* dialog = NULL;
		GtkFileDialog* _tmp0_;
		GFile* target_directory = NULL;
		GFile* _tmp1_;
		_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (object, gtk_file_dialog_get_type (), GtkFileDialog));
		dialog = _tmp0_;
		_tmp1_ = gtk_file_dialog_select_folder_finish (dialog, _result_, &_inner_error0_);
		target_directory = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (dialog);
			goto __catch0_g_error;
		}
		font_manager_user_data_export_dialog_export_to (self, target_directory);
		_g_object_unref0 (target_directory);
		_g_object_unref0 (dialog);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		if (_tmp2_->code == GTK_DIALOG_ERROR_FAILED) {
			GError* _tmp3_;
			const gchar* _tmp4_;
			_tmp3_ = e;
			_tmp4_ = _tmp3_->message;
			g_warning ("Dialogs.vala:204: FileDialog : %s", _tmp4_);
		}
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	return;
}

FontManagerUserDataExportSettings*
font_manager_user_data_export_dialog_get_export_settings (FontManagerUserDataExportDialog* self)
{
	FontManagerUserDataExportSettings* result;
	FontManagerUserDataExportSettings* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_export_settings;
	result = _tmp0_;
	return result;
}

static void
font_manager_user_data_export_dialog_set_export_settings (FontManagerUserDataExportDialog* self,
                                                          FontManagerUserDataExportSettings* value)
{
	FontManagerUserDataExportSettings* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_user_data_export_dialog_get_export_settings (self);
	if (old_value != value) {
		FontManagerUserDataExportSettings* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_export_settings);
		self->priv->_export_settings = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_user_data_export_dialog_properties[FONT_MANAGER_USER_DATA_EXPORT_DIALOG_EXPORT_SETTINGS_PROPERTY]);
	}
}

static void
font_manager_user_data_export_dialog_class_init (FontManagerUserDataExportDialogClass * klass,
                                                 gpointer klass_data)
{
	font_manager_user_data_export_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FontManagerUserDataExportDialog_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_font_manager_user_data_export_dialog_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_font_manager_user_data_export_dialog_set_property;
	G_OBJECT_CLASS (klass)->finalize = font_manager_user_data_export_dialog_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_USER_DATA_EXPORT_DIALOG_EXPORT_SETTINGS_PROPERTY, font_manager_user_data_export_dialog_properties[FONT_MANAGER_USER_DATA_EXPORT_DIALOG_EXPORT_SETTINGS_PROPERTY] = g_param_spec_object ("export-settings", "export-settings", "export-settings", FONT_MANAGER_USER_DATA_TYPE_EXPORT_SETTINGS, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/com/github/FontManager/FontManager/ui/font-manager-export-dialog.ui");
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_cancel_clicked", G_CALLBACK(_font_manager_user_data_export_dialog_on_cancel_clicked_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_export_clicked", G_CALLBACK(_font_manager_user_data_export_dialog_on_export_clicked_gtk_button_clicked));
}

static void
font_manager_user_data_export_dialog_instance_init (FontManagerUserDataExportDialog * self,
                                                    gpointer klass)
{
	self->priv = font_manager_user_data_export_dialog_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
font_manager_user_data_export_dialog_finalize (GObject * obj)
{
	FontManagerUserDataExportDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FONT_MANAGER_USER_DATA_TYPE_EXPORT_DIALOG, FontManagerUserDataExportDialog);
	_g_object_unref0 (self->priv->_export_settings);
	G_OBJECT_CLASS (font_manager_user_data_export_dialog_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
font_manager_user_data_export_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FontManagerUserDataExportDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) font_manager_user_data_export_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FontManagerUserDataExportDialog), 0, (GInstanceInitFunc) font_manager_user_data_export_dialog_instance_init, NULL };
	GType font_manager_user_data_export_dialog_type_id;
	font_manager_user_data_export_dialog_type_id = g_type_register_static (gtk_window_get_type (), "FontManagerUserDataExportDialog", &g_define_type_info, 0);
	FontManagerUserDataExportDialog_private_offset = g_type_add_instance_private (font_manager_user_data_export_dialog_type_id, sizeof (FontManagerUserDataExportDialogPrivate));
	return font_manager_user_data_export_dialog_type_id;
}

GType
font_manager_user_data_export_dialog_get_type (void)
{
	static volatile gsize font_manager_user_data_export_dialog_type_id__once = 0;
	if (g_once_init_enter (&font_manager_user_data_export_dialog_type_id__once)) {
		GType font_manager_user_data_export_dialog_type_id;
		font_manager_user_data_export_dialog_type_id = font_manager_user_data_export_dialog_get_type_once ();
		g_once_init_leave (&font_manager_user_data_export_dialog_type_id__once, font_manager_user_data_export_dialog_type_id);
	}
	return font_manager_user_data_export_dialog_type_id__once;
}

static void
_vala_font_manager_user_data_export_dialog_get_property (GObject * object,
                                                         guint property_id,
                                                         GValue * value,
                                                         GParamSpec * pspec)
{
	FontManagerUserDataExportDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_USER_DATA_TYPE_EXPORT_DIALOG, FontManagerUserDataExportDialog);
	switch (property_id) {
		case FONT_MANAGER_USER_DATA_EXPORT_DIALOG_EXPORT_SETTINGS_PROPERTY:
		g_value_set_object (value, font_manager_user_data_export_dialog_get_export_settings (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_font_manager_user_data_export_dialog_set_property (GObject * object,
                                                         guint property_id,
                                                         const GValue * value,
                                                         GParamSpec * pspec)
{
	FontManagerUserDataExportDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_USER_DATA_TYPE_EXPORT_DIALOG, FontManagerUserDataExportDialog);
	switch (property_id) {
		case FONT_MANAGER_USER_DATA_EXPORT_DIALOG_EXPORT_SETTINGS_PROPERTY:
		font_manager_user_data_export_dialog_set_export_settings (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
font_manager_user_data_import_dialog_get_instance_private (FontManagerUserDataImportDialog* self)
{
	return G_STRUCT_MEMBER_P (self, FontManagerUserDataImportDialog_private_offset);
}

FontManagerUserDataImportDialog*
font_manager_user_data_import_dialog_construct (GType object_type,
                                                GtkWindow* parent)
{
	FontManagerUserDataImportDialog * self = NULL;
	GtkFileDialog* _tmp0_;
	GtkWindow* _tmp1_;
	self = (FontManagerUserDataImportDialog*) g_object_new (object_type, NULL);
	_tmp0_ = font_manager_file_selector_get_target_directory ();
	_g_object_unref0 (self->priv->file_dialog);
	self->priv->file_dialog = _tmp0_;
	_tmp1_ = _g_object_ref0 (parent);
	_g_object_unref0 (self->priv->parent);
	self->priv->parent = _tmp1_;
	return self;
}

FontManagerUserDataImportDialog*
font_manager_user_data_import_dialog_new (GtkWindow* parent)
{
	return font_manager_user_data_import_dialog_construct (FONT_MANAGER_USER_DATA_TYPE_IMPORT_DIALOG, parent);
}

static void
_font_manager_user_data_import_dialog_on_directory_selected_gasync_ready_callback (GObject* source_object,
                                                                                   GAsyncResult* res,
                                                                                   gpointer self)
{
	font_manager_user_data_import_dialog_on_directory_selected ((FontManagerUserDataImportDialog*) self, source_object, res);
	g_object_unref (self);
}

void
font_manager_user_data_import_dialog_present (FontManagerUserDataImportDialog* self)
{
	GtkFileDialog* _tmp0_;
	GtkWindow* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->file_dialog;
	_tmp1_ = self->priv->parent;
	gtk_file_dialog_select_folder (_tmp0_, _tmp1_, NULL, _font_manager_user_data_import_dialog_on_directory_selected_gasync_ready_callback, g_object_ref (self));
	return;
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static gboolean
___lambda211_ (FontManagerUserDataImportDialog* self)
{
	FontManagerApplication* _tmp0_;
	FontManagerApplication* _tmp1_;
	gboolean result;
	_tmp0_ = font_manager_get_default_application ();
	_tmp1_ = _tmp0_;
	font_manager_application_reload (_tmp1_);
	_g_object_unref0 (_tmp1_);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
____lambda211__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda211_ ((FontManagerUserDataImportDialog*) self);
	return result;
}

static void
font_manager_user_data_import_dialog_import_from (FontManagerUserDataImportDialog* self,
                                                  GFile* target_directory)
{
	GFileCopyFlags flags = 0U;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (target_directory != NULL);
	flags = (G_FILE_COPY_OVERWRITE | G_FILE_COPY_ALL_METADATA) | G_FILE_COPY_TARGET_DEFAULT_PERMS;
	{
		GFileInfo* fileinfo = NULL;
		GFileEnumerator* enumerator = NULL;
		GFileEnumerator* _tmp0_;
		gchar* root = NULL;
		gchar* _tmp1_;
		_tmp0_ = g_file_enumerate_children (target_directory, G_FILE_ATTRIBUTE_STANDARD_NAME, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
		enumerator = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (fileinfo);
			goto __catch0_g_error;
		}
		_tmp1_ = g_file_get_path (target_directory);
		root = _tmp1_;
		while (TRUE) {
			GFileInfo* _tmp2_ = NULL;
			GFileEnumerator* _tmp3_;
			GFileInfo* _tmp4_;
			GFileInfo* _tmp5_;
			GFileInfo* _tmp6_;
			GFileType source_type = 0;
			GFileInfo* _tmp7_;
			gchar* name = NULL;
			GFileInfo* _tmp8_;
			const gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp3_ = enumerator;
			_tmp4_ = g_file_enumerator_next_file (_tmp3_, NULL, &_inner_error0_);
			_tmp2_ = _tmp4_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (root);
				_g_object_unref0 (enumerator);
				_g_object_unref0 (fileinfo);
				goto __catch0_g_error;
			}
			_tmp5_ = _tmp2_;
			_tmp2_ = NULL;
			_g_object_unref0 (fileinfo);
			fileinfo = _tmp5_;
			_tmp6_ = fileinfo;
			if (!(_tmp6_ != NULL)) {
				_g_object_unref0 (_tmp2_);
				break;
			}
			_tmp7_ = fileinfo;
			source_type = g_file_info_get_file_type (_tmp7_);
			_tmp8_ = fileinfo;
			_tmp9_ = g_file_info_get_name (_tmp8_);
			_tmp10_ = g_strdup (_tmp9_);
			name = _tmp10_;
			if (source_type == G_FILE_TYPE_DIRECTORY) {
				const gchar* _tmp11_;
				_tmp11_ = name;
				if (g_strcmp0 (_tmp11_, "fontconfig") == 0) {
					gchar* confd = NULL;
					const gchar* _tmp12_;
					const gchar* _tmp13_;
					gchar* _tmp14_;
					GFile* config_files = NULL;
					const gchar* _tmp15_;
					GFile* _tmp16_;
					GFile* config_dir = NULL;
					gchar* _tmp17_;
					gchar* _tmp18_;
					GFile* _tmp19_;
					GFile* _tmp20_;
					GFile* _tmp21_;
					GFile* _tmp22_;
					_tmp12_ = root;
					_tmp13_ = name;
					_tmp14_ = g_build_filename (_tmp12_, _tmp13_, "conf.d", NULL);
					confd = _tmp14_;
					_tmp15_ = confd;
					_tmp16_ = g_file_new_for_path (_tmp15_);
					config_files = _tmp16_;
					_tmp17_ = font_manager_get_user_fontconfig_directory ();
					_tmp18_ = _tmp17_;
					_tmp19_ = g_file_new_for_path (_tmp18_);
					_tmp20_ = _tmp19_;
					_g_free0 (_tmp18_);
					config_dir = _tmp20_;
					_tmp21_ = config_files;
					_tmp22_ = config_dir;
					font_manager_copy_directory (_tmp21_, _tmp22_, flags);
					_g_object_unref0 (config_dir);
					_g_object_unref0 (config_files);
					_g_free0 (confd);
				} else {
					const gchar* _tmp23_;
					_tmp23_ = name;
					if (g_strcmp0 (_tmp23_, "fonts") == 0) {
						gchar* font_dir = NULL;
						gchar* _tmp24_;
						GFile* user_font_dir = NULL;
						const gchar* _tmp25_;
						GFile* _tmp26_;
						GFile* backup = NULL;
						const gchar* _tmp27_;
						const gchar* _tmp28_;
						gchar* _tmp29_;
						gchar* _tmp30_;
						GFile* _tmp31_;
						GFile* _tmp32_;
						GFile* _tmp33_;
						GFile* _tmp34_;
						_tmp24_ = font_manager_get_user_font_directory ();
						font_dir = _tmp24_;
						_tmp25_ = font_dir;
						_tmp26_ = g_file_new_for_path (_tmp25_);
						user_font_dir = _tmp26_;
						_tmp27_ = root;
						_tmp28_ = name;
						_tmp29_ = g_build_filename (_tmp27_, _tmp28_, NULL);
						_tmp30_ = _tmp29_;
						_tmp31_ = g_file_new_for_path (_tmp30_);
						_tmp32_ = _tmp31_;
						_g_free0 (_tmp30_);
						backup = _tmp32_;
						_tmp33_ = backup;
						_tmp34_ = user_font_dir;
						font_manager_copy_directory (_tmp33_, _tmp34_, flags);
						_g_object_unref0 (backup);
						_g_object_unref0 (user_font_dir);
						_g_free0 (font_dir);
					}
				}
			} else {
				if (source_type == G_FILE_TYPE_REGULAR) {
					gchar** config_files = NULL;
					gchar* _tmp35_;
					gchar* _tmp36_;
					gchar* _tmp37_;
					gchar* _tmp38_;
					gchar** _tmp39_;
					gint config_files_length1;
					gint _config_files_size_;
					const gchar* _tmp40_;
					gchar** _tmp41_;
					gint _tmp41__length1;
					_tmp35_ = g_strdup ("Collections.json");
					_tmp36_ = g_strdup ("Comparisons.json");
					_tmp37_ = g_strdup ("Sources.xml");
					_tmp38_ = g_strdup ("Actions.json");
					_tmp39_ = g_new0 (gchar*, 4 + 1);
					_tmp39_[0] = _tmp35_;
					_tmp39_[1] = _tmp36_;
					_tmp39_[2] = _tmp37_;
					_tmp39_[3] = _tmp38_;
					config_files = _tmp39_;
					config_files_length1 = 4;
					_config_files_size_ = config_files_length1;
					_tmp40_ = name;
					_tmp41_ = config_files;
					_tmp41__length1 = config_files_length1;
					if (_vala_string_array_contains (_tmp41_, _tmp41__length1, _tmp40_)) {
						GFile* config = NULL;
						const gchar* _tmp42_;
						const gchar* _tmp43_;
						gchar* _tmp44_;
						gchar* _tmp45_;
						GFile* _tmp46_;
						GFile* _tmp47_;
						gchar* config_dir = NULL;
						gchar* _tmp48_;
						GFile* target = NULL;
						const gchar* _tmp49_;
						const gchar* _tmp50_;
						gchar* _tmp51_;
						gchar* _tmp52_;
						GFile* _tmp53_;
						GFile* _tmp54_;
						GFile* _tmp55_;
						GFile* _tmp56_;
						_tmp42_ = root;
						_tmp43_ = name;
						_tmp44_ = g_build_filename (_tmp42_, _tmp43_, NULL);
						_tmp45_ = _tmp44_;
						_tmp46_ = g_file_new_for_path (_tmp45_);
						_tmp47_ = _tmp46_;
						_g_free0 (_tmp45_);
						config = _tmp47_;
						_tmp48_ = font_manager_get_package_config_directory ();
						config_dir = _tmp48_;
						_tmp49_ = config_dir;
						_tmp50_ = name;
						_tmp51_ = g_build_filename (_tmp49_, _tmp50_, NULL);
						_tmp52_ = _tmp51_;
						_tmp53_ = g_file_new_for_path (_tmp52_);
						_tmp54_ = _tmp53_;
						_g_free0 (_tmp52_);
						target = _tmp54_;
						_tmp55_ = config;
						_tmp56_ = target;
						g_file_copy (_tmp55_, _tmp56_, flags, NULL, NULL, NULL, &_inner_error0_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							_g_object_unref0 (target);
							_g_free0 (config_dir);
							_g_object_unref0 (config);
							config_files = (_vala_array_free (config_files, config_files_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (name);
							_g_object_unref0 (_tmp2_);
							_g_free0 (root);
							_g_object_unref0 (enumerator);
							_g_object_unref0 (fileinfo);
							goto __catch0_g_error;
						}
						_g_object_unref0 (target);
						_g_free0 (config_dir);
						_g_object_unref0 (config);
					}
					config_files = (_vala_array_free (config_files, config_files_length1, (GDestroyNotify) g_free), NULL);
				}
			}
			_g_free0 (name);
			_g_object_unref0 (_tmp2_);
		}
		g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 4, ____lambda211__gsource_func, g_object_ref (self), g_object_unref);
		_g_free0 (root);
		_g_object_unref0 (enumerator);
		_g_object_unref0 (fileinfo);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp57_;
		const gchar* _tmp58_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp57_ = e;
		_tmp58_ = _tmp57_->message;
		g_critical ("Dialogs.vala:264: %s", _tmp58_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	return;
}

static void
font_manager_user_data_import_dialog_on_directory_selected (FontManagerUserDataImportDialog* self,
                                                            GObject* object,
                                                            GAsyncResult* _result_)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_result_ != NULL);
	{
		GtkFileDialog* dialog = NULL;
		GtkFileDialog* _tmp0_;
		GFile* target_directory = NULL;
		GFile* _tmp1_;
		_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (object, gtk_file_dialog_get_type (), GtkFileDialog));
		dialog = _tmp0_;
		_tmp1_ = gtk_file_dialog_select_folder_finish (dialog, _result_, &_inner_error0_);
		target_directory = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (dialog);
			goto __catch0_g_error;
		}
		font_manager_user_data_import_dialog_import_from (self, target_directory);
		_g_object_unref0 (target_directory);
		_g_object_unref0 (dialog);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		if (_tmp2_->code == GTK_DIALOG_ERROR_FAILED) {
			GError* _tmp3_;
			const gchar* _tmp4_;
			_tmp3_ = e;
			_tmp4_ = _tmp3_->message;
			g_warning ("Dialogs.vala:276: FileDialog : %s", _tmp4_);
		}
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	return;
}

static void
font_manager_user_data_import_dialog_class_init (FontManagerUserDataImportDialogClass * klass,
                                                 gpointer klass_data)
{
	font_manager_user_data_import_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FontManagerUserDataImportDialog_private_offset);
	G_OBJECT_CLASS (klass)->finalize = font_manager_user_data_import_dialog_finalize;
}

static void
font_manager_user_data_import_dialog_instance_init (FontManagerUserDataImportDialog * self,
                                                    gpointer klass)
{
	self->priv = font_manager_user_data_import_dialog_get_instance_private (self);
}

static void
font_manager_user_data_import_dialog_finalize (GObject * obj)
{
	FontManagerUserDataImportDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FONT_MANAGER_USER_DATA_TYPE_IMPORT_DIALOG, FontManagerUserDataImportDialog);
	_g_object_unref0 (self->priv->parent);
	_g_object_unref0 (self->priv->file_dialog);
	G_OBJECT_CLASS (font_manager_user_data_import_dialog_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
font_manager_user_data_import_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FontManagerUserDataImportDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) font_manager_user_data_import_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FontManagerUserDataImportDialog), 0, (GInstanceInitFunc) font_manager_user_data_import_dialog_instance_init, NULL };
	GType font_manager_user_data_import_dialog_type_id;
	font_manager_user_data_import_dialog_type_id = g_type_register_static (G_TYPE_OBJECT, "FontManagerUserDataImportDialog", &g_define_type_info, 0);
	FontManagerUserDataImportDialog_private_offset = g_type_add_instance_private (font_manager_user_data_import_dialog_type_id, sizeof (FontManagerUserDataImportDialogPrivate));
	return font_manager_user_data_import_dialog_type_id;
}

GType
font_manager_user_data_import_dialog_get_type (void)
{
	static volatile gsize font_manager_user_data_import_dialog_type_id__once = 0;
	if (g_once_init_enter (&font_manager_user_data_import_dialog_type_id__once)) {
		GType font_manager_user_data_import_dialog_type_id;
		font_manager_user_data_import_dialog_type_id = font_manager_user_data_import_dialog_get_type_once ();
		g_once_init_leave (&font_manager_user_data_import_dialog_type_id__once, font_manager_user_data_import_dialog_type_id);
	}
	return font_manager_user_data_import_dialog_type_id__once;
}

static inline gpointer
font_manager_language_settings_dialog_get_instance_private (FontManagerLanguageSettingsDialog* self)
{
	return G_STRUCT_MEMBER_P (self, FontManagerLanguageSettingsDialog_private_offset);
}

FontManagerLanguageSettingsDialog*
font_manager_language_settings_dialog_construct (GType object_type,
                                                 GtkWindow* parent,
                                                 FontManagerLanguageFilterSettings* settings)
{
	FontManagerLanguageSettingsDialog * self = NULL;
	GBindingFlags flags = 0U;
	GtkToggleButton* _tmp0_;
	GtkSearchBar* _tmp1_;
	GtkSearchBar* _tmp2_;
	g_return_val_if_fail (settings != NULL, NULL);
	self = (FontManagerLanguageSettingsDialog*) g_object_new (object_type, "settings", settings, NULL);
	gtk_window_set_transient_for ((GtkWindow*) self, parent);
	gtk_window_set_child ((GtkWindow*) self, (GtkWidget*) settings);
	if (parent != NULL) {
		font_manager_set_default_dialog_size (parent, (GtkWindow*) self, 60, 80);
	}
	flags = G_BINDING_BIDIRECTIONAL;
	_tmp0_ = self->priv->search_toggle;
	_tmp1_ = font_manager_language_filter_settings_get_search_bar (settings);
	_tmp2_ = _tmp1_;
	g_object_bind_property_with_closures ((GObject*) _tmp0_, "active", (GObject*) _tmp2_, "search-mode-enabled", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	return self;
}

FontManagerLanguageSettingsDialog*
font_manager_language_settings_dialog_new (GtkWindow* parent,
                                           FontManagerLanguageFilterSettings* settings)
{
	return font_manager_language_settings_dialog_construct (FONT_MANAGER_TYPE_LANGUAGE_SETTINGS_DIALOG, parent, settings);
}

FontManagerLanguageFilterSettings*
font_manager_language_settings_dialog_get_settings (FontManagerLanguageSettingsDialog* self)
{
	FontManagerLanguageFilterSettings* result;
	FontManagerLanguageFilterSettings* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_settings;
	result = _tmp0_;
	return result;
}

void
font_manager_language_settings_dialog_set_settings (FontManagerLanguageSettingsDialog* self,
                                                    FontManagerLanguageFilterSettings* value)
{
	FontManagerLanguageFilterSettings* old_value;
	g_return_if_fail (self != NULL);
	old_value = font_manager_language_settings_dialog_get_settings (self);
	if (old_value != value) {
		FontManagerLanguageFilterSettings* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_settings);
		self->priv->_settings = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, font_manager_language_settings_dialog_properties[FONT_MANAGER_LANGUAGE_SETTINGS_DIALOG_SETTINGS_PROPERTY]);
	}
}

static void
font_manager_language_settings_dialog_class_init (FontManagerLanguageSettingsDialogClass * klass,
                                                  gpointer klass_data)
{
	font_manager_language_settings_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FontManagerLanguageSettingsDialog_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_font_manager_language_settings_dialog_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_font_manager_language_settings_dialog_set_property;
	G_OBJECT_CLASS (klass)->finalize = font_manager_language_settings_dialog_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_LANGUAGE_SETTINGS_DIALOG_SETTINGS_PROPERTY, font_manager_language_settings_dialog_properties[FONT_MANAGER_LANGUAGE_SETTINGS_DIALOG_SETTINGS_PROPERTY] = g_param_spec_object ("settings", "settings", "settings", FONT_MANAGER_TYPE_LANGUAGE_FILTER_SETTINGS, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/com/github/FontManager/FontManager/ui/font-manager-language-settings-dialog.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "search_toggle", FALSE, FontManagerLanguageSettingsDialog_private_offset + G_STRUCT_OFFSET (FontManagerLanguageSettingsDialogPrivate, search_toggle));
}

static void
font_manager_language_settings_dialog_instance_init (FontManagerLanguageSettingsDialog * self,
                                                     gpointer klass)
{
	self->priv = font_manager_language_settings_dialog_get_instance_private (self);
	self->priv->_settings = NULL;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
font_manager_language_settings_dialog_finalize (GObject * obj)
{
	FontManagerLanguageSettingsDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FONT_MANAGER_TYPE_LANGUAGE_SETTINGS_DIALOG, FontManagerLanguageSettingsDialog);
	_g_object_unref0 (self->priv->_settings);
	G_OBJECT_CLASS (font_manager_language_settings_dialog_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
font_manager_language_settings_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FontManagerLanguageSettingsDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) font_manager_language_settings_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FontManagerLanguageSettingsDialog), 0, (GInstanceInitFunc) font_manager_language_settings_dialog_instance_init, NULL };
	GType font_manager_language_settings_dialog_type_id;
	font_manager_language_settings_dialog_type_id = g_type_register_static (gtk_window_get_type (), "FontManagerLanguageSettingsDialog", &g_define_type_info, 0);
	FontManagerLanguageSettingsDialog_private_offset = g_type_add_instance_private (font_manager_language_settings_dialog_type_id, sizeof (FontManagerLanguageSettingsDialogPrivate));
	return font_manager_language_settings_dialog_type_id;
}

GType
font_manager_language_settings_dialog_get_type (void)
{
	static volatile gsize font_manager_language_settings_dialog_type_id__once = 0;
	if (g_once_init_enter (&font_manager_language_settings_dialog_type_id__once)) {
		GType font_manager_language_settings_dialog_type_id;
		font_manager_language_settings_dialog_type_id = font_manager_language_settings_dialog_get_type_once ();
		g_once_init_leave (&font_manager_language_settings_dialog_type_id__once, font_manager_language_settings_dialog_type_id);
	}
	return font_manager_language_settings_dialog_type_id__once;
}

static void
_vala_font_manager_language_settings_dialog_get_property (GObject * object,
                                                          guint property_id,
                                                          GValue * value,
                                                          GParamSpec * pspec)
{
	FontManagerLanguageSettingsDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_TYPE_LANGUAGE_SETTINGS_DIALOG, FontManagerLanguageSettingsDialog);
	switch (property_id) {
		case FONT_MANAGER_LANGUAGE_SETTINGS_DIALOG_SETTINGS_PROPERTY:
		g_value_set_object (value, font_manager_language_settings_dialog_get_settings (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_font_manager_language_settings_dialog_set_property (GObject * object,
                                                          guint property_id,
                                                          const GValue * value,
                                                          GParamSpec * pspec)
{
	FontManagerLanguageSettingsDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_TYPE_LANGUAGE_SETTINGS_DIALOG, FontManagerLanguageSettingsDialog);
	switch (property_id) {
		case FONT_MANAGER_LANGUAGE_SETTINGS_DIALOG_SETTINGS_PROPERTY:
		font_manager_language_settings_dialog_set_settings (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
font_manager_progress_dialog_get_instance_private (FontManagerProgressDialog* self)
{
	return G_STRUCT_MEMBER_P (self, FontManagerProgressDialog_private_offset);
}

FontManagerProgressDialog*
font_manager_progress_dialog_construct (GType object_type,
                                        GtkWindow* parent,
                                        const gchar* title)
{
	FontManagerProgressDialog * self = NULL;
	GtkProgressBar* _tmp0_;
	const gchar* _tmp1_ = NULL;
	GtkLabel* _tmp2_;
	self = (FontManagerProgressDialog*) g_object_new (object_type, NULL);
	gtk_window_set_transient_for ((GtkWindow*) self, parent);
	font_manager_widget_set_name ((GtkWidget*) self, "FontManagerProgressDialog");
	_tmp0_ = self->priv->_progress_bar;
	font_manager_widget_set_expand ((GtkWidget*) _tmp0_, TRUE);
	gtk_widget_add_css_class ((GtkWidget*) self, "dialog");
	if (title != NULL) {
		_tmp1_ = title;
	} else {
		_tmp1_ = "";
	}
	_tmp2_ = self->priv->_title_label;
	gtk_label_set_label (_tmp2_, _tmp1_);
	if (parent != NULL) {
		font_manager_set_default_dialog_size (parent, (GtkWindow*) self, 50, 20);
	}
	return self;
}

FontManagerProgressDialog*
font_manager_progress_dialog_new (GtkWindow* parent,
                                  const gchar* title)
{
	return font_manager_progress_dialog_construct (FONT_MANAGER_TYPE_PROGRESS_DIALOG, parent, title);
}

void
font_manager_progress_dialog_update (FontManagerProgressDialog* self,
                                     FontManagerProgressData* data)
{
	GtkLabel* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GtkProgressBar* _tmp4_;
	gdouble _tmp5_;
	gdouble _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (data != NULL);
	_tmp0_ = self->priv->_message_label;
	g_object_get (data, "message", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	gtk_label_set_label (_tmp0_, _tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = self->priv->_progress_bar;
	g_object_get (data, "progress", &_tmp5_, NULL);
	_tmp6_ = _tmp5_;
	gtk_progress_bar_set_fraction (_tmp4_, _tmp6_);
	return;
}

gboolean
font_manager_progress_dialog_get_show_app_icon (FontManagerProgressDialog* self)
{
	gboolean result;
	GtkImage* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->app_icon;
	_tmp1_ = gtk_widget_get_visible ((GtkWidget*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
font_manager_progress_dialog_set_show_app_icon (FontManagerProgressDialog* self,
                                                gboolean value)
{
	GtkImage* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->app_icon;
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, font_manager_progress_dialog_properties[FONT_MANAGER_PROGRESS_DIALOG_SHOW_APP_ICON_PROPERTY]);
}

GtkLabel*
font_manager_progress_dialog_get_title_label (FontManagerProgressDialog* self)
{
	GtkLabel* result;
	GtkLabel* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_title_label;
	result = _tmp0_;
	return result;
}

GtkLabel*
font_manager_progress_dialog_get_message_label (FontManagerProgressDialog* self)
{
	GtkLabel* result;
	GtkLabel* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_message_label;
	result = _tmp0_;
	return result;
}

GtkOverlay*
font_manager_progress_dialog_get_overlay (FontManagerProgressDialog* self)
{
	GtkOverlay* result;
	GtkOverlay* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_overlay;
	result = _tmp0_;
	return result;
}

GtkProgressBar*
font_manager_progress_dialog_get_progress_bar (FontManagerProgressDialog* self)
{
	GtkProgressBar* result;
	GtkProgressBar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_progress_bar;
	result = _tmp0_;
	return result;
}

static void
font_manager_progress_dialog_class_init (FontManagerProgressDialogClass * klass,
                                         gpointer klass_data)
{
	font_manager_progress_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FontManagerProgressDialog_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_font_manager_progress_dialog_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_font_manager_progress_dialog_set_property;
	G_OBJECT_CLASS (klass)->finalize = font_manager_progress_dialog_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_PROGRESS_DIALOG_SHOW_APP_ICON_PROPERTY, font_manager_progress_dialog_properties[FONT_MANAGER_PROGRESS_DIALOG_SHOW_APP_ICON_PROPERTY] = g_param_spec_boolean ("show-app-icon", "show-app-icon", "show-app-icon", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_PROGRESS_DIALOG_TITLE_LABEL_PROPERTY, font_manager_progress_dialog_properties[FONT_MANAGER_PROGRESS_DIALOG_TITLE_LABEL_PROPERTY] = g_param_spec_object ("title-label", "title-label", "title-label", gtk_label_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_PROGRESS_DIALOG_MESSAGE_LABEL_PROPERTY, font_manager_progress_dialog_properties[FONT_MANAGER_PROGRESS_DIALOG_MESSAGE_LABEL_PROPERTY] = g_param_spec_object ("message-label", "message-label", "message-label", gtk_label_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_PROGRESS_DIALOG_OVERLAY_PROPERTY, font_manager_progress_dialog_properties[FONT_MANAGER_PROGRESS_DIALOG_OVERLAY_PROPERTY] = g_param_spec_object ("overlay", "overlay", "overlay", gtk_overlay_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_PROGRESS_DIALOG_PROGRESS_BAR_PROPERTY, font_manager_progress_dialog_properties[FONT_MANAGER_PROGRESS_DIALOG_PROGRESS_BAR_PROPERTY] = g_param_spec_object ("progress-bar", "progress-bar", "progress-bar", gtk_progress_bar_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/com/github/FontManager/FontManager/ui/font-manager-progress-dialog.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "title_label", FALSE, FontManagerProgressDialog_private_offset + G_STRUCT_OFFSET (FontManagerProgressDialogPrivate, _title_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "message_label", FALSE, FontManagerProgressDialog_private_offset + G_STRUCT_OFFSET (FontManagerProgressDialogPrivate, _message_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "overlay", FALSE, FontManagerProgressDialog_private_offset + G_STRUCT_OFFSET (FontManagerProgressDialogPrivate, _overlay));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "progress_bar", FALSE, FontManagerProgressDialog_private_offset + G_STRUCT_OFFSET (FontManagerProgressDialogPrivate, _progress_bar));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "app_icon", FALSE, FontManagerProgressDialog_private_offset + G_STRUCT_OFFSET (FontManagerProgressDialogPrivate, app_icon));
}

static void
font_manager_progress_dialog_instance_init (FontManagerProgressDialog * self,
                                            gpointer klass)
{
	self->priv = font_manager_progress_dialog_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
font_manager_progress_dialog_finalize (GObject * obj)
{
	FontManagerProgressDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FONT_MANAGER_TYPE_PROGRESS_DIALOG, FontManagerProgressDialog);
	G_OBJECT_CLASS (font_manager_progress_dialog_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
font_manager_progress_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FontManagerProgressDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) font_manager_progress_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FontManagerProgressDialog), 0, (GInstanceInitFunc) font_manager_progress_dialog_instance_init, NULL };
	GType font_manager_progress_dialog_type_id;
	font_manager_progress_dialog_type_id = g_type_register_static (gtk_window_get_type (), "FontManagerProgressDialog", &g_define_type_info, 0);
	FontManagerProgressDialog_private_offset = g_type_add_instance_private (font_manager_progress_dialog_type_id, sizeof (FontManagerProgressDialogPrivate));
	return font_manager_progress_dialog_type_id;
}

GType
font_manager_progress_dialog_get_type (void)
{
	static volatile gsize font_manager_progress_dialog_type_id__once = 0;
	if (g_once_init_enter (&font_manager_progress_dialog_type_id__once)) {
		GType font_manager_progress_dialog_type_id;
		font_manager_progress_dialog_type_id = font_manager_progress_dialog_get_type_once ();
		g_once_init_leave (&font_manager_progress_dialog_type_id__once, font_manager_progress_dialog_type_id);
	}
	return font_manager_progress_dialog_type_id__once;
}

static void
_vala_font_manager_progress_dialog_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec)
{
	FontManagerProgressDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_TYPE_PROGRESS_DIALOG, FontManagerProgressDialog);
	switch (property_id) {
		case FONT_MANAGER_PROGRESS_DIALOG_SHOW_APP_ICON_PROPERTY:
		g_value_set_boolean (value, font_manager_progress_dialog_get_show_app_icon (self));
		break;
		case FONT_MANAGER_PROGRESS_DIALOG_TITLE_LABEL_PROPERTY:
		g_value_set_object (value, font_manager_progress_dialog_get_title_label (self));
		break;
		case FONT_MANAGER_PROGRESS_DIALOG_MESSAGE_LABEL_PROPERTY:
		g_value_set_object (value, font_manager_progress_dialog_get_message_label (self));
		break;
		case FONT_MANAGER_PROGRESS_DIALOG_OVERLAY_PROPERTY:
		g_value_set_object (value, font_manager_progress_dialog_get_overlay (self));
		break;
		case FONT_MANAGER_PROGRESS_DIALOG_PROGRESS_BAR_PROPERTY:
		g_value_set_object (value, font_manager_progress_dialog_get_progress_bar (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_font_manager_progress_dialog_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec)
{
	FontManagerProgressDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_TYPE_PROGRESS_DIALOG, FontManagerProgressDialog);
	switch (property_id) {
		case FONT_MANAGER_PROGRESS_DIALOG_SHOW_APP_ICON_PROPERTY:
		font_manager_progress_dialog_set_show_app_icon (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
font_manager_remove_dialog_get_instance_private (FontManagerRemoveDialog* self)
{
	return G_STRUCT_MEMBER_P (self, FontManagerRemoveDialog_private_offset);
}

static gpointer
_json_object_ref0 (gpointer self)
{
	return self ? json_object_ref (self) : NULL;
}

static gpointer
_json_array_ref0 (gpointer self)
{
	return self ? json_array_ref (self) : NULL;
}

static void
__lambda205_ (FontManagerRemoveDialog* self,
              JsonArray* a,
              guint i,
              JsonNode* n)
{
	JsonObject* _tmp0_;
	g_return_if_fail (a != NULL);
	g_return_if_fail (n != NULL);
	_tmp0_ = json_node_get_object (n);
	json_object_set_boolean_member (_tmp0_, "active", FALSE);
}

static void
___lambda205__json_array_foreach (JsonArray* array,
                                  guint index_,
                                  JsonNode* element_node,
                                  gpointer self)
{
	__lambda205_ ((FontManagerRemoveDialog*) self, array, index_, element_node);
}

static void
__lambda204_ (FontManagerRemoveDialog* self,
              JsonArray* a,
              guint i,
              JsonNode* n)
{
	JsonObject* family = NULL;
	JsonObject* _tmp0_;
	JsonObject* _tmp1_;
	JsonArray* variations = NULL;
	JsonArray* _tmp2_;
	JsonArray* _tmp3_;
	g_return_if_fail (a != NULL);
	g_return_if_fail (n != NULL);
	_tmp0_ = json_node_get_object (n);
	_tmp1_ = _json_object_ref0 (_tmp0_);
	family = _tmp1_;
	json_object_set_boolean_member (family, "active", FALSE);
	_tmp2_ = json_object_get_array_member (family, "variations");
	_tmp3_ = _json_array_ref0 (_tmp2_);
	variations = _tmp3_;
	json_array_foreach_element (variations, ___lambda205__json_array_foreach, self);
	_json_array_unref0 (variations);
	_json_object_unref0 (family);
}

static void
___lambda204__json_array_foreach (JsonArray* array,
                                  guint index_,
                                  JsonNode* element_node,
                                  gpointer self)
{
	__lambda204_ ((FontManagerRemoveDialog*) self, array, index_, element_node);
}

static void
__lambda208_ (FontManagerRemoveDialog* self)
{
	gboolean sensitive = FALSE;
	FontManagerRemoveListView* _tmp0_;
	FontManagerStringSet* _tmp1_;
	FontManagerStringSet* _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	GtkButton* _tmp5_;
	_tmp0_ = self->priv->_remove_list;
	_tmp1_ = font_manager_remove_list_view_get_selected_files (_tmp0_);
	_tmp2_ = _tmp1_;
	g_object_get (_tmp2_, "size", &_tmp3_, NULL);
	_tmp4_ = _tmp3_;
	sensitive = _tmp4_ > ((guint) 0);
	_tmp5_ = self->priv->_delete_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, sensitive);
	if (sensitive) {
		GtkButton* _tmp6_;
		GtkButton* _tmp7_;
		_tmp6_ = self->priv->_cancel_button;
		gtk_widget_add_css_class ((GtkWidget*) _tmp6_, FONT_MANAGER_STYLE_CLASS_SUGGESTED_ACTION);
		_tmp7_ = self->priv->_delete_button;
		gtk_widget_add_css_class ((GtkWidget*) _tmp7_, FONT_MANAGER_STYLE_CLASS_DESTRUCTIVE_ACTION);
	} else {
		GtkButton* _tmp8_;
		GtkButton* _tmp9_;
		_tmp8_ = self->priv->_cancel_button;
		gtk_widget_remove_css_class ((GtkWidget*) _tmp8_, FONT_MANAGER_STYLE_CLASS_SUGGESTED_ACTION);
		_tmp9_ = self->priv->_delete_button;
		gtk_widget_remove_css_class ((GtkWidget*) _tmp9_, FONT_MANAGER_STYLE_CLASS_DESTRUCTIVE_ACTION);
	}
}

static void
___lambda208__font_manager_remove_list_view_changed (FontManagerRemoveListView* _sender,
                                                     gpointer self)
{
	__lambda208_ ((FontManagerRemoveDialog*) self);
}

FontManagerRemoveDialog*
font_manager_remove_dialog_construct (GType object_type,
                                      GtkWindow* parent)
{
	FontManagerRemoveDialog * self = NULL;
	JsonObject* fonts = NULL;
	JsonObject* _tmp0_;
	JsonArray* sorted_fonts = NULL;
	JsonObject* _tmp1_;
	JsonArray* _tmp2_;
	JsonArray* _tmp3_;
	JsonArray* _tmp4_;
	FontManagerRemoveListView* _tmp5_;
	GtkSearchEntry* _tmp6_;
	FontManagerRemoveListView* _tmp7_;
	JsonArray* _tmp8_;
	GtkButton* _tmp9_;
	FontManagerRemoveListView* _tmp10_;
	FontManagerRemoveListView* _tmp11_;
	FontManagerBaseFontModel* _tmp12_;
	FontManagerBaseFontModel* _tmp13_;
	guint _tmp14_;
	guint _tmp15_;
	GBindingFlags flags = 0U;
	GtkToggleButton* _tmp22_;
	GtkSearchBar* _tmp23_;
	GtkSearchBar* _tmp24_;
	GtkSearchEntry* _tmp25_;
	GtkSearchBar* _tmp26_;
	FontManagerRemoveListView* _tmp27_;
	FontManagerRemoveListView* _tmp28_;
	self = (FontManagerRemoveDialog*) g_object_new (object_type, NULL);
	gtk_window_set_transient_for ((GtkWindow*) self, parent);
	font_manager_set_default_dialog_size (parent, (GtkWindow*) self, 60, 70);
	_tmp0_ = font_manager_get_available_fonts (NULL);
	fonts = _tmp0_;
	_tmp1_ = fonts;
	_tmp2_ = font_manager_sort_json_font_listing (_tmp1_);
	sorted_fonts = _tmp2_;
	_tmp3_ = sorted_fonts;
	json_array_foreach_element (_tmp3_, ___lambda204__json_array_foreach, self);
	_tmp4_ = sorted_fonts;
	font_manager_update_item_preview_text (_tmp4_);
	_tmp5_ = self->priv->_remove_list;
	_tmp6_ = self->priv->_entry;
	font_manager_remove_list_view_set_search_entry (_tmp5_, _tmp6_);
	_tmp7_ = self->priv->_remove_list;
	_tmp8_ = sorted_fonts;
	font_manager_font_list_base_set_available_fonts ((FontManagerFontListBase*) _tmp7_, _tmp8_);
	_tmp9_ = self->priv->_delete_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp9_, FALSE);
	_tmp10_ = self->priv->_remove_list;
	g_signal_connect_object (_tmp10_, "changed", (GCallback) ___lambda208__font_manager_remove_list_view_changed, self, 0);
	_tmp11_ = self->priv->_remove_list;
	_tmp12_ = font_manager_font_list_base_get_model ((FontManagerFontListBase*) _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = font_manager_base_font_model_get_n_items (_tmp13_);
	_tmp15_ = _tmp14_;
	if (_tmp15_ < ((guint) 1)) {
		gchar* msg = NULL;
		gchar* _tmp16_;
		FontManagerPlaceHolder* empty = NULL;
		const gchar* _tmp17_;
		FontManagerPlaceHolder* _tmp18_;
		GtkStack* _tmp19_;
		FontManagerPlaceHolder* _tmp20_;
		GtkStack* _tmp21_;
		_tmp16_ = g_strdup (_ ("Fonts installed in your home directory will appear here."));
		msg = _tmp16_;
		_tmp17_ = msg;
		_tmp18_ = (FontManagerPlaceHolder*) font_manager_place_holder_new (NULL, NULL, _tmp17_, "go-home-symbolic");
		g_object_ref_sink (_tmp18_);
		empty = _tmp18_;
		_tmp19_ = self->priv->stack;
		_tmp20_ = empty;
		gtk_stack_add_named (_tmp19_, (GtkWidget*) _tmp20_, "empty");
		_tmp21_ = self->priv->stack;
		gtk_stack_set_visible_child_name (_tmp21_, "empty");
		_g_object_unref0 (empty);
		_g_free0 (msg);
	}
	flags = G_BINDING_BIDIRECTIONAL | G_BINDING_SYNC_CREATE;
	_tmp22_ = self->priv->_search_toggle;
	_tmp23_ = self->priv->_search_bar;
	g_object_bind_property_with_closures ((GObject*) _tmp22_, "active", (GObject*) _tmp23_, "search-mode-enabled", flags, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp24_ = self->priv->_search_bar;
	_tmp25_ = self->priv->_entry;
	gtk_search_bar_connect_entry (_tmp24_, (GtkEditable*) _tmp25_);
	_tmp26_ = self->priv->_search_bar;
	_tmp27_ = self->priv->_remove_list;
	gtk_search_bar_set_key_capture_widget (_tmp26_, (GtkWidget*) _tmp27_);
	_tmp28_ = self->priv->_remove_list;
	gtk_widget_grab_focus ((GtkWidget*) _tmp28_);
	_json_array_unref0 (sorted_fonts);
	_json_object_unref0 (fonts);
	return self;
}

FontManagerRemoveDialog*
font_manager_remove_dialog_new (GtkWindow* parent)
{
	return font_manager_remove_dialog_construct (FONT_MANAGER_TYPE_REMOVE_DIALOG, parent);
}

static void
font_manager_remove_dialog_on_cancel_clicked (FontManagerRemoveDialog* self)
{
	g_return_if_fail (self != NULL);
	gtk_window_destroy ((GtkWindow*) self);
	return;
}

static void
_font_manager_remove_dialog_on_cancel_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                  gpointer self)
{
	font_manager_remove_dialog_on_cancel_clicked ((FontManagerRemoveDialog*) self);
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
font_manager_remove_dialog_purge_selections (GTask* task,
                                             GObject* source,
                                             void* data,
                                             GCancellable* cancellable)
{
	gboolean return_val = FALSE;
	FontManagerStringSet* selections = NULL;
	FontManagerRemoveListView* _tmp0_;
	FontManagerStringSet* _tmp1_;
	FontManagerStringSet* _tmp2_;
	FontManagerStringSet* _tmp3_;
	FontManagerStringSet* removed = NULL;
	FontManagerStringSet* _tmp4_;
	FontManagerStringSet* _tmp59_;
	FontManagerStringSet* _tmp60_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (task != NULL);
	g_return_if_fail (source != NULL);
	_vala_assert (FONT_MANAGER_IS_REMOVE_DIALOG (source), "source is RemoveDialog");
	return_val = TRUE;
	_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (source, FONT_MANAGER_TYPE_REMOVE_DIALOG, FontManagerRemoveDialog)->priv->_remove_list;
	_tmp1_ = font_manager_remove_list_view_get_selected_files (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	selections = _tmp3_;
	_tmp4_ = font_manager_string_set_new ();
	removed = _tmp4_;
	{
		FontManagerStringSet* _path_list = NULL;
		FontManagerStringSet* _tmp5_;
		guint _path_size = 0U;
		FontManagerStringSet* _tmp6_;
		guint _tmp7_;
		guint _tmp8_;
		gint _path_index = 0;
		_tmp5_ = selections;
		_path_list = _tmp5_;
		_tmp6_ = _path_list;
		g_object_get (_tmp6_, "size", &_tmp7_, NULL);
		_tmp8_ = _tmp7_;
		_path_size = _tmp8_;
		_path_index = -1;
		while (TRUE) {
			gint _tmp9_;
			guint _tmp10_;
			gchar* path = NULL;
			FontManagerStringSet* _tmp11_;
			const gchar* _tmp12_;
			gchar* _tmp13_;
			_path_index = _path_index + 1;
			_tmp9_ = _path_index;
			_tmp10_ = _path_size;
			if (!(((guint) _tmp9_) < _tmp10_)) {
				break;
			}
			_tmp11_ = _path_list;
			_tmp12_ = font_manager_string_set_get (_tmp11_, (guint) _path_index);
			_tmp13_ = g_strdup (_tmp12_);
			path = _tmp13_;
			{
				GFile* file = NULL;
				const gchar* _tmp14_;
				GFile* _tmp15_;
				GFile* _tmp16_;
				GFile* parent = NULL;
				GFile* _tmp17_;
				GFile* _tmp18_;
				gboolean _tmp19_ = FALSE;
				GFile* _tmp20_;
				GFile* _tmp22_;
				FontManagerStringSet* _tmp23_;
				const gchar* _tmp24_;
				_tmp14_ = path;
				_tmp15_ = g_file_new_for_path (_tmp14_);
				file = _tmp15_;
				_tmp16_ = file;
				if (!g_file_query_exists (_tmp16_, NULL)) {
					_g_object_unref0 (file);
					_g_free0 (path);
					continue;
				}
				_tmp17_ = file;
				_tmp18_ = g_file_get_parent (_tmp17_);
				parent = _tmp18_;
				_tmp20_ = file;
				_tmp19_ = g_file_delete (_tmp20_, NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (parent);
					_g_object_unref0 (file);
					goto __catch0_g_error;
				}
				if (!_tmp19_) {
					const gchar* _tmp21_;
					_tmp21_ = path;
					g_warning ("Dialogs.vala:415: Failed to remove %s", _tmp21_);
					return_val = FALSE;
				}
				_tmp22_ = parent;
				font_manager_remove_directory_tree_if_empty (_tmp22_);
				_tmp23_ = removed;
				_tmp24_ = path;
				font_manager_string_set_add (_tmp23_, _tmp24_);
				_g_object_unref0 (parent);
				_g_object_unref0 (file);
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				GError* _tmp25_;
				const gchar* _tmp26_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp25_ = e;
				_tmp26_ = _tmp25_->message;
				g_warning ("Dialogs.vala:421: %s", _tmp26_);
				_g_error_free0 (e);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (path);
				_g_object_unref0 (removed);
				_g_object_unref0 (selections);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_g_free0 (path);
		}
	}
	{
		FontManagerDatabase* db = NULL;
		FontManagerDatabase* _tmp27_;
		gchar** tables = NULL;
		gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		gchar** _tmp32_;
		gint tables_length1;
		gint _tables_size_;
		gchar** _tmp33_;
		gint _tmp33__length1;
		FontManagerDatabase* _tmp56_;
		_tmp27_ = font_manager_database_proxy_get_default_db ();
		db = _tmp27_;
		_tmp28_ = g_strdup ("Fonts");
		_tmp29_ = g_strdup ("Metadata");
		_tmp30_ = g_strdup ("Orthography");
		_tmp31_ = g_strdup ("Panose");
		_tmp32_ = g_new0 (gchar*, 4 + 1);
		_tmp32_[0] = _tmp28_;
		_tmp32_[1] = _tmp29_;
		_tmp32_[2] = _tmp30_;
		_tmp32_[3] = _tmp31_;
		tables = _tmp32_;
		tables_length1 = 4;
		_tables_size_ = tables_length1;
		_tmp33_ = tables;
		_tmp33__length1 = tables_length1;
		{
			gchar** table_collection = NULL;
			gint table_collection_length1 = 0;
			gint _table_collection_size_ = 0;
			gint table_it = 0;
			table_collection = _tmp33_;
			table_collection_length1 = _tmp33__length1;
			for (table_it = 0; table_it < table_collection_length1; table_it = table_it + 1) {
				gchar* _tmp34_;
				gchar* table = NULL;
				_tmp34_ = g_strdup (table_collection[table_it]);
				table = _tmp34_;
				{
					{
						FontManagerStringSet* _path_list = NULL;
						FontManagerStringSet* _tmp35_;
						guint _path_size = 0U;
						FontManagerStringSet* _tmp36_;
						guint _tmp37_;
						guint _tmp38_;
						gint _path_index = 0;
						_tmp35_ = removed;
						_path_list = _tmp35_;
						_tmp36_ = _path_list;
						g_object_get (_tmp36_, "size", &_tmp37_, NULL);
						_tmp38_ = _tmp37_;
						_path_size = _tmp38_;
						_path_index = -1;
						while (TRUE) {
							gint _tmp39_;
							guint _tmp40_;
							gchar* path = NULL;
							FontManagerStringSet* _tmp41_;
							const gchar* _tmp42_;
							gchar* _tmp43_;
							const gchar* _tmp44_;
							gchar* _tmp45_;
							FontManagerDatabase* _tmp46_;
							const gchar* _tmp47_;
							const gchar* _tmp48_;
							const gchar* _tmp49_;
							const gchar* _tmp50_;
							gchar* _tmp51_;
							gchar* _tmp52_;
							FontManagerDatabase* _tmp53_;
							sqlite3_stmt* _tmp54_;
							FontManagerDatabase* _tmp55_;
							_path_index = _path_index + 1;
							_tmp39_ = _path_index;
							_tmp40_ = _path_size;
							if (!(((guint) _tmp39_) < _tmp40_)) {
								break;
							}
							_tmp41_ = _path_list;
							_tmp42_ = font_manager_string_set_get (_tmp41_, (guint) _path_index);
							_tmp43_ = g_strdup (_tmp42_);
							path = _tmp43_;
							_tmp44_ = path;
							_tmp45_ = string_replace (_tmp44_, "'", "''");
							_g_free0 (path);
							path = _tmp45_;
							_tmp46_ = db;
							_tmp47_ = table;
							_tmp48_ = string_to_string (_tmp47_);
							_tmp49_ = path;
							_tmp50_ = string_to_string (_tmp49_);
							_tmp51_ = g_strconcat ("DELETE FROM ", _tmp48_, " WHERE filepath LIKE '%", _tmp50_, "%'", NULL);
							_tmp52_ = _tmp51_;
							font_manager_database_execute_query (_tmp46_, _tmp52_, &_inner_error0_);
							_g_free0 (_tmp52_);
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								_g_free0 (path);
								_g_free0 (table);
								tables = (_vala_array_free (tables, tables_length1, (GDestroyNotify) g_free), NULL);
								_g_object_unref0 (db);
								goto __catch1_g_error;
							}
							_tmp53_ = db;
							_tmp54_ = font_manager_database_get_cursor (_tmp53_);
							sqlite3_step (_tmp54_);
							_tmp55_ = db;
							font_manager_database_end_query (_tmp55_);
							_g_free0 (path);
						}
					}
					_g_free0 (table);
				}
			}
		}
		_tmp56_ = db;
		font_manager_database_vacuum (_tmp56_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			tables = (_vala_array_free (tables, tables_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (db);
			goto __catch1_g_error;
		}
		tables = (_vala_array_free (tables, tables_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (db);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp57_;
		const gchar* _tmp58_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp57_ = e;
		_tmp58_ = _tmp57_->message;
		g_warning ("Dialogs.vala:437: %s", _tmp58_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (removed);
		_g_object_unref0 (selections);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp59_ = selections;
	_tmp60_ = removed;
	font_manager_string_set_remove_all (_tmp59_, _tmp60_);
	g_task_return_boolean (task, return_val);
	_g_object_unref0 (removed);
	_g_object_unref0 (selections);
	return;
}

static void
font_manager_remove_dialog_on_remove_finished (GObject* source,
                                               GTask* task)
{
	FontManagerRemoveDialog* _self_ = NULL;
	FontManagerRemoveDialog* _tmp0_;
	gboolean removed = FALSE;
	FontManagerApplication* _tmp4_;
	FontManagerApplication* _tmp5_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (task != NULL);
	g_return_if_fail (FONT_MANAGER_IS_REMOVE_DIALOG (source));
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (source, FONT_MANAGER_TYPE_REMOVE_DIALOG, FontManagerRemoveDialog));
	_self_ = _tmp0_;
	removed = FALSE;
	{
		gboolean _tmp1_ = FALSE;
		_tmp1_ = g_task_propagate_boolean (task, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		removed = _tmp1_;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("Dialogs.vala:451: Library.remove : Failed to complete task : %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (_self_);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	g_signal_emit (_self_, font_manager_remove_dialog_signals[FONT_MANAGER_REMOVE_DIALOG_END_REMOVAL_SIGNAL], 0);
	gtk_window_destroy ((GtkWindow*) _self_);
	_tmp4_ = font_manager_get_default_application ();
	_tmp5_ = _tmp4_;
	font_manager_application_reload (_tmp5_);
	_g_object_unref0 (_tmp5_);
	if (!removed) {
		{
			FontManagerStringSet* _path_list = NULL;
			FontManagerRemoveListView* _tmp6_;
			FontManagerStringSet* _tmp7_;
			FontManagerStringSet* _tmp8_;
			guint _path_size = 0U;
			FontManagerStringSet* _tmp9_;
			guint _tmp10_;
			guint _tmp11_;
			gint _path_index = 0;
			_tmp6_ = _self_->priv->_remove_list;
			_tmp7_ = font_manager_remove_list_view_get_selected_files (_tmp6_);
			_tmp8_ = _tmp7_;
			_path_list = _tmp8_;
			_tmp9_ = _path_list;
			g_object_get (_tmp9_, "size", &_tmp10_, NULL);
			_tmp11_ = _tmp10_;
			_path_size = _tmp11_;
			_path_index = -1;
			while (TRUE) {
				gint _tmp12_;
				guint _tmp13_;
				gchar* path = NULL;
				FontManagerStringSet* _tmp14_;
				const gchar* _tmp15_;
				gchar* _tmp16_;
				const gchar* _tmp17_;
				_path_index = _path_index + 1;
				_tmp12_ = _path_index;
				_tmp13_ = _path_size;
				if (!(((guint) _tmp12_) < _tmp13_)) {
					break;
				}
				_tmp14_ = _path_list;
				_tmp15_ = font_manager_string_set_get (_tmp14_, (guint) _path_index);
				_tmp16_ = g_strdup (_tmp15_);
				path = _tmp16_;
				_tmp17_ = path;
				g_warning ("Dialogs.vala:458: Failed to remove : %s", _tmp17_);
				_g_free0 (path);
			}
		}
	}
	_g_object_unref0 (_self_);
	return;
}

static void
_font_manager_remove_dialog_on_remove_finished_gasync_ready_callback (GObject* source_object,
                                                                      GTask* task,
                                                                      gpointer self)
{
	font_manager_remove_dialog_on_remove_finished (source_object, task);
}

static void
_font_manager_remove_dialog_purge_selections_gtask_thread_func (GTask* task,
                                                                GObject* source_object,
                                                                void* task_data,
                                                                GCancellable* cancellable)
{
	font_manager_remove_dialog_purge_selections (task, source_object, task_data, cancellable);
}

static void
font_manager_remove_dialog_on_delete_clicked (FontManagerRemoveDialog* self)
{
	GTask* task = NULL;
	GTask* _tmp0_;
	g_return_if_fail (self != NULL);
	gtk_widget_hide ((GtkWidget*) self);
	g_signal_emit (self, font_manager_remove_dialog_signals[FONT_MANAGER_REMOVE_DIALOG_START_REMOVAL_SIGNAL], 0);
	_tmp0_ = g_task_new ((GObject*) self, NULL, _font_manager_remove_dialog_on_remove_finished_gasync_ready_callback, NULL);
	task = _tmp0_;
	g_task_run_in_thread (task, _font_manager_remove_dialog_purge_selections_gtask_thread_func);
	_g_object_unref0 (task);
	return;
}

static void
_font_manager_remove_dialog_on_delete_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                  gpointer self)
{
	font_manager_remove_dialog_on_delete_clicked ((FontManagerRemoveDialog*) self);
}

GtkButton*
font_manager_remove_dialog_get_cancel_button (FontManagerRemoveDialog* self)
{
	GtkButton* result;
	GtkButton* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_cancel_button;
	result = _tmp0_;
	return result;
}

GtkButton*
font_manager_remove_dialog_get_delete_button (FontManagerRemoveDialog* self)
{
	GtkButton* result;
	GtkButton* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_delete_button;
	result = _tmp0_;
	return result;
}

GtkToggleButton*
font_manager_remove_dialog_get_search_toggle (FontManagerRemoveDialog* self)
{
	GtkToggleButton* result;
	GtkToggleButton* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_search_toggle;
	result = _tmp0_;
	return result;
}

FontManagerRemoveListView*
font_manager_remove_dialog_get_remove_list (FontManagerRemoveDialog* self)
{
	FontManagerRemoveListView* result;
	FontManagerRemoveListView* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_remove_list;
	result = _tmp0_;
	return result;
}

GtkSearchBar*
font_manager_remove_dialog_get_search_bar (FontManagerRemoveDialog* self)
{
	GtkSearchBar* result;
	GtkSearchBar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_search_bar;
	result = _tmp0_;
	return result;
}

GtkSearchEntry*
font_manager_remove_dialog_get_entry (FontManagerRemoveDialog* self)
{
	GtkSearchEntry* result;
	GtkSearchEntry* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_entry;
	result = _tmp0_;
	return result;
}

static void
font_manager_remove_dialog_class_init (FontManagerRemoveDialogClass * klass,
                                       gpointer klass_data)
{
	font_manager_remove_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FontManagerRemoveDialog_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_font_manager_remove_dialog_get_property;
	G_OBJECT_CLASS (klass)->finalize = font_manager_remove_dialog_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_REMOVE_DIALOG_CANCEL_BUTTON_PROPERTY, font_manager_remove_dialog_properties[FONT_MANAGER_REMOVE_DIALOG_CANCEL_BUTTON_PROPERTY] = g_param_spec_object ("cancel-button", "cancel-button", "cancel-button", gtk_button_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_REMOVE_DIALOG_DELETE_BUTTON_PROPERTY, font_manager_remove_dialog_properties[FONT_MANAGER_REMOVE_DIALOG_DELETE_BUTTON_PROPERTY] = g_param_spec_object ("delete-button", "delete-button", "delete-button", gtk_button_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_REMOVE_DIALOG_SEARCH_TOGGLE_PROPERTY, font_manager_remove_dialog_properties[FONT_MANAGER_REMOVE_DIALOG_SEARCH_TOGGLE_PROPERTY] = g_param_spec_object ("search-toggle", "search-toggle", "search-toggle", gtk_toggle_button_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_REMOVE_DIALOG_REMOVE_LIST_PROPERTY, font_manager_remove_dialog_properties[FONT_MANAGER_REMOVE_DIALOG_REMOVE_LIST_PROPERTY] = g_param_spec_object ("remove-list", "remove-list", "remove-list", FONT_MANAGER_TYPE_REMOVE_LIST_VIEW, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_REMOVE_DIALOG_SEARCH_BAR_PROPERTY, font_manager_remove_dialog_properties[FONT_MANAGER_REMOVE_DIALOG_SEARCH_BAR_PROPERTY] = g_param_spec_object ("search-bar", "search-bar", "search-bar", gtk_search_bar_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FONT_MANAGER_REMOVE_DIALOG_ENTRY_PROPERTY, font_manager_remove_dialog_properties[FONT_MANAGER_REMOVE_DIALOG_ENTRY_PROPERTY] = g_param_spec_object ("entry", "entry", "entry", gtk_search_entry_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/com/github/FontManager/FontManager/ui/font-manager-remove-dialog.ui");
	font_manager_remove_dialog_signals[FONT_MANAGER_REMOVE_DIALOG_START_REMOVAL_SIGNAL] = g_signal_new ("start-removal", FONT_MANAGER_TYPE_REMOVE_DIALOG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	font_manager_remove_dialog_signals[FONT_MANAGER_REMOVE_DIALOG_END_REMOVAL_SIGNAL] = g_signal_new ("end-removal", FONT_MANAGER_TYPE_REMOVE_DIALOG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "cancel_button", FALSE, FontManagerRemoveDialog_private_offset + G_STRUCT_OFFSET (FontManagerRemoveDialogPrivate, _cancel_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "delete_button", FALSE, FontManagerRemoveDialog_private_offset + G_STRUCT_OFFSET (FontManagerRemoveDialogPrivate, _delete_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "search_toggle", FALSE, FontManagerRemoveDialog_private_offset + G_STRUCT_OFFSET (FontManagerRemoveDialogPrivate, _search_toggle));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "remove_list", FALSE, FontManagerRemoveDialog_private_offset + G_STRUCT_OFFSET (FontManagerRemoveDialogPrivate, _remove_list));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "search_bar", FALSE, FontManagerRemoveDialog_private_offset + G_STRUCT_OFFSET (FontManagerRemoveDialogPrivate, _search_bar));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "entry", FALSE, FontManagerRemoveDialog_private_offset + G_STRUCT_OFFSET (FontManagerRemoveDialogPrivate, _entry));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "stack", FALSE, FontManagerRemoveDialog_private_offset + G_STRUCT_OFFSET (FontManagerRemoveDialogPrivate, stack));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_cancel_clicked", G_CALLBACK(_font_manager_remove_dialog_on_cancel_clicked_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_delete_clicked", G_CALLBACK(_font_manager_remove_dialog_on_delete_clicked_gtk_button_clicked));
}

static void
font_manager_remove_dialog_instance_init (FontManagerRemoveDialog * self,
                                          gpointer klass)
{
	self->priv = font_manager_remove_dialog_get_instance_private (self);
	g_type_ensure (FONT_MANAGER_TYPE_REMOVE_LIST_VIEW);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
font_manager_remove_dialog_finalize (GObject * obj)
{
	FontManagerRemoveDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FONT_MANAGER_TYPE_REMOVE_DIALOG, FontManagerRemoveDialog);
	G_OBJECT_CLASS (font_manager_remove_dialog_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
font_manager_remove_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FontManagerRemoveDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) font_manager_remove_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FontManagerRemoveDialog), 0, (GInstanceInitFunc) font_manager_remove_dialog_instance_init, NULL };
	GType font_manager_remove_dialog_type_id;
	font_manager_remove_dialog_type_id = g_type_register_static (gtk_window_get_type (), "FontManagerRemoveDialog", &g_define_type_info, 0);
	FontManagerRemoveDialog_private_offset = g_type_add_instance_private (font_manager_remove_dialog_type_id, sizeof (FontManagerRemoveDialogPrivate));
	return font_manager_remove_dialog_type_id;
}

GType
font_manager_remove_dialog_get_type (void)
{
	static volatile gsize font_manager_remove_dialog_type_id__once = 0;
	if (g_once_init_enter (&font_manager_remove_dialog_type_id__once)) {
		GType font_manager_remove_dialog_type_id;
		font_manager_remove_dialog_type_id = font_manager_remove_dialog_get_type_once ();
		g_once_init_leave (&font_manager_remove_dialog_type_id__once, font_manager_remove_dialog_type_id);
	}
	return font_manager_remove_dialog_type_id__once;
}

static void
_vala_font_manager_remove_dialog_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec)
{
	FontManagerRemoveDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FONT_MANAGER_TYPE_REMOVE_DIALOG, FontManagerRemoveDialog);
	switch (property_id) {
		case FONT_MANAGER_REMOVE_DIALOG_CANCEL_BUTTON_PROPERTY:
		g_value_set_object (value, font_manager_remove_dialog_get_cancel_button (self));
		break;
		case FONT_MANAGER_REMOVE_DIALOG_DELETE_BUTTON_PROPERTY:
		g_value_set_object (value, font_manager_remove_dialog_get_delete_button (self));
		break;
		case FONT_MANAGER_REMOVE_DIALOG_SEARCH_TOGGLE_PROPERTY:
		g_value_set_object (value, font_manager_remove_dialog_get_search_toggle (self));
		break;
		case FONT_MANAGER_REMOVE_DIALOG_REMOVE_LIST_PROPERTY:
		g_value_set_object (value, font_manager_remove_dialog_get_remove_list (self));
		break;
		case FONT_MANAGER_REMOVE_DIALOG_SEARCH_BAR_PROPERTY:
		g_value_set_object (value, font_manager_remove_dialog_get_search_bar (self));
		break;
		case FONT_MANAGER_REMOVE_DIALOG_ENTRY_PROPERTY:
		g_value_set_object (value, font_manager_remove_dialog_get_entry (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

