/* The contents of this file was automatically generated by dump_modes.c
   with arguments: 48000 960 96000 1920
   It contains static definitions for some pre-defined modes. */
#include "modes.h"
#include "rate.h"

#ifdef HAVE_ARM_NE10
#define OVERRIDE_FFT 1
#include "static_modes_float_arm_ne10.h"
#endif

#ifndef DEF_WINDOW120
#define DEF_WINDOW120
static const celt_coef window120[120] = {
6.7286966e-05f, 0.00060551348f, 0.0016815970f, 0.0032947962f, 0.0054439943f,
0.0081276923f, 0.011344001f, 0.015090633f, 0.019364886f, 0.024163635f,
0.029483315f, 0.035319905f, 0.041668911f, 0.048525347f, 0.055883718f,
0.063737999f, 0.072081616f, 0.080907428f, 0.090207705f, 0.099974111f,
0.11019769f, 0.12086883f, 0.13197729f, 0.14351214f, 0.15546177f,
0.16781389f, 0.18055550f, 0.19367290f, 0.20715171f, 0.22097682f,
0.23513243f, 0.24960208f, 0.26436860f, 0.27941419f, 0.29472040f,
0.31026818f, 0.32603788f, 0.34200931f, 0.35816177f, 0.37447407f,
0.39092462f, 0.40749142f, 0.42415215f, 0.44088423f, 0.45766484f,
0.47447104f, 0.49127978f, 0.50806798f, 0.52481261f, 0.54149077f,
0.55807973f, 0.57455701f, 0.59090049f, 0.60708841f, 0.62309951f,
0.63891306f, 0.65450896f, 0.66986776f, 0.68497077f, 0.69980010f,
0.71433873f, 0.72857055f, 0.74248043f, 0.75605425f, 0.76927895f,
0.78214257f, 0.79463430f, 0.80674445f, 0.81846456f, 0.82978733f,
0.84070669f, 0.85121779f, 0.86131698f, 0.87100183f, 0.88027111f,
0.88912479f, 0.89756398f, 0.90559094f, 0.91320904f, 0.92042270f,
0.92723738f, 0.93365955f, 0.93969656f, 0.94535671f, 0.95064907f,
0.95558353f, 0.96017067f, 0.96442171f, 0.96834849f, 0.97196334f,
0.97527906f, 0.97830883f, 0.98106616f, 0.98356480f, 0.98581869f,
0.98784191f, 0.98964856f, 0.99125274f, 0.99266849f, 0.99390969f,
0.99499004f, 0.99592297f, 0.99672162f, 0.99739874f, 0.99796667f,
0.99843728f, 0.99882195f, 0.99913147f, 0.99937606f, 0.99956527f,
0.99970802f, 0.99981248f, 0.99988613f, 0.99993565f, 0.99996697f,
0.99998518f, 0.99999457f, 0.99999859f, 0.99999982f, 1.0000000f,
};
#endif

#ifndef DEF_LOGN400
#define DEF_LOGN400
static const opus_int16 logN400[21] = {
0, 0, 0, 0, 0, 0, 0, 0, 8, 8, 8, 8, 16, 16, 16, 21, 21, 24, 29, 34, 36, };
#endif

#ifndef DEF_PULSE_CACHE50
#define DEF_PULSE_CACHE50
static const opus_int16 cache_index50[105] = {
-1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 41, 41, 41,
82, 82, 123, 164, 200, 222, 0, 0, 0, 0, 0, 0, 0, 0, 41,
41, 41, 41, 123, 123, 123, 164, 164, 240, 266, 283, 295, 41, 41, 41,
41, 41, 41, 41, 41, 123, 123, 123, 123, 240, 240, 240, 266, 266, 305,
318, 328, 336, 123, 123, 123, 123, 123, 123, 123, 123, 240, 240, 240, 240,
305, 305, 305, 318, 318, 343, 351, 358, 364, 240, 240, 240, 240, 240, 240,
240, 240, 305, 305, 305, 305, 343, 343, 343, 351, 351, 370, 376, 382, 387,
};
static const unsigned char cache_bits50[392] = {
40, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 40, 15, 23, 28,
31, 34, 36, 38, 39, 41, 42, 43, 44, 45, 46, 47, 47, 49, 50,
51, 52, 53, 54, 55, 55, 57, 58, 59, 60, 61, 62, 63, 63, 65,
66, 67, 68, 69, 70, 71, 71, 40, 20, 33, 41, 48, 53, 57, 61,
64, 66, 69, 71, 73, 75, 76, 78, 80, 82, 85, 87, 89, 91, 92,
94, 96, 98, 101, 103, 105, 107, 108, 110, 112, 114, 117, 119, 121, 123,
124, 126, 128, 40, 23, 39, 51, 60, 67, 73, 79, 83, 87, 91, 94,
97, 100, 102, 105, 107, 111, 115, 118, 121, 124, 126, 129, 131, 135, 139,
142, 145, 148, 150, 153, 155, 159, 163, 166, 169, 172, 174, 177, 179, 35,
28, 49, 65, 78, 89, 99, 107, 114, 120, 126, 132, 136, 141, 145, 149,
153, 159, 165, 171, 176, 180, 185, 189, 192, 199, 205, 211, 216, 220, 225,
229, 232, 239, 245, 251, 21, 33, 58, 79, 97, 112, 125, 137, 148, 157,
166, 174, 182, 189, 195, 201, 207, 217, 227, 235, 243, 251, 17, 35, 63,
86, 106, 123, 139, 152, 165, 177, 187, 197, 206, 214, 222, 230, 237, 250,
25, 31, 55, 75, 91, 105, 117, 128, 138, 146, 154, 161, 168, 174, 180,
185, 190, 200, 208, 215, 222, 229, 235, 240, 245, 255, 16, 36, 65, 89,
110, 128, 144, 159, 173, 185, 196, 207, 217, 226, 234, 242, 250, 11, 41,
74, 103, 128, 151, 172, 191, 209, 225, 241, 255, 9, 43, 79, 110, 138,
163, 186, 207, 227, 246, 12, 39, 71, 99, 123, 144, 164, 182, 198, 214,
228, 241, 253, 9, 44, 81, 113, 142, 168, 192, 214, 235, 255, 7, 49,
90, 127, 160, 191, 220, 247, 6, 51, 95, 134, 170, 203, 234, 7, 47,
87, 123, 155, 184, 212, 237, 6, 52, 97, 137, 174, 208, 240, 5, 57,
106, 151, 192, 231, 5, 59, 111, 158, 202, 243, 5, 55, 103, 147, 187,
224, 5, 60, 113, 161, 206, 248, 4, 65, 122, 175, 224, 4, 67, 127,
182, 234, };
static const unsigned char cache_caps50[168] = {
224, 224, 224, 224, 224, 224, 224, 224, 160, 160, 160, 160, 185, 185, 185,
178, 178, 168, 134, 61, 37, 224, 224, 224, 224, 224, 224, 224, 224, 240,
240, 240, 240, 207, 207, 207, 198, 198, 183, 144, 66, 40, 160, 160, 160,
160, 160, 160, 160, 160, 185, 185, 185, 185, 193, 193, 193, 183, 183, 172,
138, 64, 38, 240, 240, 240, 240, 240, 240, 240, 240, 207, 207, 207, 207,
204, 204, 204, 193, 193, 180, 143, 66, 40, 185, 185, 185, 185, 185, 185,
185, 185, 193, 193, 193, 193, 193, 193, 193, 183, 183, 172, 138, 65, 39,
207, 207, 207, 207, 207, 207, 207, 207, 204, 204, 204, 204, 201, 201, 201,
188, 188, 176, 141, 66, 40, 193, 193, 193, 193, 193, 193, 193, 193, 193,
193, 193, 193, 194, 194, 194, 184, 184, 173, 139, 65, 39, 204, 204, 204,
204, 204, 204, 204, 204, 201, 201, 201, 201, 198, 198, 198, 187, 187, 175,
140, 66, 40, };
#endif

#ifdef ENABLE_QEXT
# ifndef DEF_QEXT_PULSE_CACHE50
# define DEF_QEXT_PULSE_CACHE50
static const opus_int16 qext_cache_index50[70] = {
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 41,
41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 61, 61,
61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 72, 72, 72,
72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 80, 80, 80, 80,
80, 80, 80, 80, 80, 80, 80, 80, 80, 80, };
static const unsigned char qext_cache_bits50[86] = {
40, 26, 45, 59, 70, 79, 87, 94, 100, 105, 110, 114, 118, 122, 125,
128, 131, 136, 141, 146, 150, 153, 157, 160, 163, 168, 173, 178, 182, 185,
189, 192, 195, 200, 205, 210, 214, 217, 221, 224, 227, 19, 34, 61, 83,
101, 118, 132, 145, 157, 167, 177, 186, 194, 202, 209, 216, 222, 234, 245,
254, 10, 42, 77, 107, 133, 157, 179, 200, 219, 236, 253, 7, 50, 93,
131, 165, 197, 227, 255, 5, 58, 109, 155, 197, 237, };
static const unsigned char qext_cache_caps50[112] = {
159, 159, 159, 159, 159, 159, 159, 159, 159, 159, 159, 159, 159, 159, 171,
171, 171, 171, 171, 171, 171, 171, 171, 171, 171, 171, 171, 171, 163, 163,
163, 163, 163, 163, 163, 163, 163, 163, 163, 163, 163, 163, 167, 167, 167,
167, 167, 167, 167, 167, 167, 167, 167, 167, 167, 167, 163, 163, 163, 163,
163, 163, 163, 163, 163, 163, 163, 163, 163, 163, 166, 166, 166, 166, 166,
166, 166, 166, 166, 166, 166, 166, 166, 166, 163, 163, 163, 163, 163, 163,
163, 163, 163, 163, 163, 163, 163, 163, 165, 165, 165, 165, 165, 165, 165,
165, 165, 165, 165, 165, 165, 165, };
# endif
#endif

#ifndef FFT_TWIDDLES48000_960
#define FFT_TWIDDLES48000_960
static const kiss_twiddle_cpx fft_twiddles48000_960[480] = {
{1.0000000f, -0.0000000f}, {0.99991433f, -0.013089596f},
{0.99965732f, -0.026176948f}, {0.99922904f, -0.039259816f},
{0.99862953f, -0.052335956f}, {0.99785892f, -0.065403129f},
{0.99691733f, -0.078459096f}, {0.99580493f, -0.091501619f},
{0.99452190f, -0.10452846f}, {0.99306846f, -0.11753740f},
{0.99144486f, -0.13052619f}, {0.98965139f, -0.14349262f},
{0.98768834f, -0.15643447f}, {0.98555606f, -0.16934950f},
{0.98325491f, -0.18223553f}, {0.98078528f, -0.19509032f},
{0.97814760f, -0.20791169f}, {0.97534232f, -0.22069744f},
{0.97236992f, -0.23344536f}, {0.96923091f, -0.24615329f},
{0.96592583f, -0.25881905f}, {0.96245524f, -0.27144045f},
{0.95881973f, -0.28401534f}, {0.95501994f, -0.29654157f},
{0.95105652f, -0.30901699f}, {0.94693013f, -0.32143947f},
{0.94264149f, -0.33380686f}, {0.93819134f, -0.34611706f},
{0.93358043f, -0.35836795f}, {0.92880955f, -0.37055744f},
{0.92387953f, -0.38268343f}, {0.91879121f, -0.39474386f},
{0.91354546f, -0.40673664f}, {0.90814317f, -0.41865974f},
{0.90258528f, -0.43051110f}, {0.89687274f, -0.44228869f},
{0.89100652f, -0.45399050f}, {0.88498764f, -0.46561452f},
{0.87881711f, -0.47715876f}, {0.87249601f, -0.48862124f},
{0.86602540f, -0.50000000f}, {0.85940641f, -0.51129309f},
{0.85264016f, -0.52249856f}, {0.84572782f, -0.53361452f},
{0.83867057f, -0.54463904f}, {0.83146961f, -0.55557023f},
{0.82412619f, -0.56640624f}, {0.81664156f, -0.57714519f},
{0.80901699f, -0.58778525f}, {0.80125381f, -0.59832460f},
{0.79335334f, -0.60876143f}, {0.78531693f, -0.61909395f},
{0.77714596f, -0.62932039f}, {0.76884183f, -0.63943900f},
{0.76040597f, -0.64944805f}, {0.75183981f, -0.65934582f},
{0.74314483f, -0.66913061f}, {0.73432251f, -0.67880075f},
{0.72537437f, -0.68835458f}, {0.71630194f, -0.69779046f},
{0.70710678f, -0.70710678f}, {0.69779046f, -0.71630194f},
{0.68835458f, -0.72537437f}, {0.67880075f, -0.73432251f},
{0.66913061f, -0.74314483f}, {0.65934582f, -0.75183981f},
{0.64944805f, -0.76040597f}, {0.63943900f, -0.76884183f},
{0.62932039f, -0.77714596f}, {0.61909395f, -0.78531693f},
{0.60876143f, -0.79335334f}, {0.59832460f, -0.80125381f},
{0.58778525f, -0.80901699f}, {0.57714519f, -0.81664156f},
{0.56640624f, -0.82412619f}, {0.55557023f, -0.83146961f},
{0.54463904f, -0.83867057f}, {0.53361452f, -0.84572782f},
{0.52249856f, -0.85264016f}, {0.51129309f, -0.85940641f},
{0.50000000f, -0.86602540f}, {0.48862124f, -0.87249601f},
{0.47715876f, -0.87881711f}, {0.46561452f, -0.88498764f},
{0.45399050f, -0.89100652f}, {0.44228869f, -0.89687274f},
{0.43051110f, -0.90258528f}, {0.41865974f, -0.90814317f},
{0.40673664f, -0.91354546f}, {0.39474386f, -0.91879121f},
{0.38268343f, -0.92387953f}, {0.37055744f, -0.92880955f},
{0.35836795f, -0.93358043f}, {0.34611706f, -0.93819134f},
{0.33380686f, -0.94264149f}, {0.32143947f, -0.94693013f},
{0.30901699f, -0.95105652f}, {0.29654157f, -0.95501994f},
{0.28401534f, -0.95881973f}, {0.27144045f, -0.96245524f},
{0.25881905f, -0.96592583f}, {0.24615329f, -0.96923091f},
{0.23344536f, -0.97236992f}, {0.22069744f, -0.97534232f},
{0.20791169f, -0.97814760f}, {0.19509032f, -0.98078528f},
{0.18223553f, -0.98325491f}, {0.16934950f, -0.98555606f},
{0.15643447f, -0.98768834f}, {0.14349262f, -0.98965139f},
{0.13052619f, -0.99144486f}, {0.11753740f, -0.99306846f},
{0.10452846f, -0.99452190f}, {0.091501619f, -0.99580493f},
{0.078459096f, -0.99691733f}, {0.065403129f, -0.99785892f},
{0.052335956f, -0.99862953f}, {0.039259816f, -0.99922904f},
{0.026176948f, -0.99965732f}, {0.013089596f, -0.99991433f},
{6.1232340e-17f, -1.0000000f}, {-0.013089596f, -0.99991433f},
{-0.026176948f, -0.99965732f}, {-0.039259816f, -0.99922904f},
{-0.052335956f, -0.99862953f}, {-0.065403129f, -0.99785892f},
{-0.078459096f, -0.99691733f}, {-0.091501619f, -0.99580493f},
{-0.10452846f, -0.99452190f}, {-0.11753740f, -0.99306846f},
{-0.13052619f, -0.99144486f}, {-0.14349262f, -0.98965139f},
{-0.15643447f, -0.98768834f}, {-0.16934950f, -0.98555606f},
{-0.18223553f, -0.98325491f}, {-0.19509032f, -0.98078528f},
{-0.20791169f, -0.97814760f}, {-0.22069744f, -0.97534232f},
{-0.23344536f, -0.97236992f}, {-0.24615329f, -0.96923091f},
{-0.25881905f, -0.96592583f}, {-0.27144045f, -0.96245524f},
{-0.28401534f, -0.95881973f}, {-0.29654157f, -0.95501994f},
{-0.30901699f, -0.95105652f}, {-0.32143947f, -0.94693013f},
{-0.33380686f, -0.94264149f}, {-0.34611706f, -0.93819134f},
{-0.35836795f, -0.93358043f}, {-0.37055744f, -0.92880955f},
{-0.38268343f, -0.92387953f}, {-0.39474386f, -0.91879121f},
{-0.40673664f, -0.91354546f}, {-0.41865974f, -0.90814317f},
{-0.43051110f, -0.90258528f}, {-0.44228869f, -0.89687274f},
{-0.45399050f, -0.89100652f}, {-0.46561452f, -0.88498764f},
{-0.47715876f, -0.87881711f}, {-0.48862124f, -0.87249601f},
{-0.50000000f, -0.86602540f}, {-0.51129309f, -0.85940641f},
{-0.52249856f, -0.85264016f}, {-0.53361452f, -0.84572782f},
{-0.54463904f, -0.83867057f}, {-0.55557023f, -0.83146961f},
{-0.56640624f, -0.82412619f}, {-0.57714519f, -0.81664156f},
{-0.58778525f, -0.80901699f}, {-0.59832460f, -0.80125381f},
{-0.60876143f, -0.79335334f}, {-0.61909395f, -0.78531693f},
{-0.62932039f, -0.77714596f}, {-0.63943900f, -0.76884183f},
{-0.64944805f, -0.76040597f}, {-0.65934582f, -0.75183981f},
{-0.66913061f, -0.74314483f}, {-0.67880075f, -0.73432251f},
{-0.68835458f, -0.72537437f}, {-0.69779046f, -0.71630194f},
{-0.70710678f, -0.70710678f}, {-0.71630194f, -0.69779046f},
{-0.72537437f, -0.68835458f}, {-0.73432251f, -0.67880075f},
{-0.74314483f, -0.66913061f}, {-0.75183981f, -0.65934582f},
{-0.76040597f, -0.64944805f}, {-0.76884183f, -0.63943900f},
{-0.77714596f, -0.62932039f}, {-0.78531693f, -0.61909395f},
{-0.79335334f, -0.60876143f}, {-0.80125381f, -0.59832460f},
{-0.80901699f, -0.58778525f}, {-0.81664156f, -0.57714519f},
{-0.82412619f, -0.56640624f}, {-0.83146961f, -0.55557023f},
{-0.83867057f, -0.54463904f}, {-0.84572782f, -0.53361452f},
{-0.85264016f, -0.52249856f}, {-0.85940641f, -0.51129309f},
{-0.86602540f, -0.50000000f}, {-0.87249601f, -0.48862124f},
{-0.87881711f, -0.47715876f}, {-0.88498764f, -0.46561452f},
{-0.89100652f, -0.45399050f}, {-0.89687274f, -0.44228869f},
{-0.90258528f, -0.43051110f}, {-0.90814317f, -0.41865974f},
{-0.91354546f, -0.40673664f}, {-0.91879121f, -0.39474386f},
{-0.92387953f, -0.38268343f}, {-0.92880955f, -0.37055744f},
{-0.93358043f, -0.35836795f}, {-0.93819134f, -0.34611706f},
{-0.94264149f, -0.33380686f}, {-0.94693013f, -0.32143947f},
{-0.95105652f, -0.30901699f}, {-0.95501994f, -0.29654157f},
{-0.95881973f, -0.28401534f}, {-0.96245524f, -0.27144045f},
{-0.96592583f, -0.25881905f}, {-0.96923091f, -0.24615329f},
{-0.97236992f, -0.23344536f}, {-0.97534232f, -0.22069744f},
{-0.97814760f, -0.20791169f}, {-0.98078528f, -0.19509032f},
{-0.98325491f, -0.18223553f}, {-0.98555606f, -0.16934950f},
{-0.98768834f, -0.15643447f}, {-0.98965139f, -0.14349262f},
{-0.99144486f, -0.13052619f}, {-0.99306846f, -0.11753740f},
{-0.99452190f, -0.10452846f}, {-0.99580493f, -0.091501619f},
{-0.99691733f, -0.078459096f}, {-0.99785892f, -0.065403129f},
{-0.99862953f, -0.052335956f}, {-0.99922904f, -0.039259816f},
{-0.99965732f, -0.026176948f}, {-0.99991433f, -0.013089596f},
{-1.0000000f, -1.2246468e-16f}, {-0.99991433f, 0.013089596f},
{-0.99965732f, 0.026176948f}, {-0.99922904f, 0.039259816f},
{-0.99862953f, 0.052335956f}, {-0.99785892f, 0.065403129f},
{-0.99691733f, 0.078459096f}, {-0.99580493f, 0.091501619f},
{-0.99452190f, 0.10452846f}, {-0.99306846f, 0.11753740f},
{-0.99144486f, 0.13052619f}, {-0.98965139f, 0.14349262f},
{-0.98768834f, 0.15643447f}, {-0.98555606f, 0.16934950f},
{-0.98325491f, 0.18223553f}, {-0.98078528f, 0.19509032f},
{-0.97814760f, 0.20791169f}, {-0.97534232f, 0.22069744f},
{-0.97236992f, 0.23344536f}, {-0.96923091f, 0.24615329f},
{-0.96592583f, 0.25881905f}, {-0.96245524f, 0.27144045f},
{-0.95881973f, 0.28401534f}, {-0.95501994f, 0.29654157f},
{-0.95105652f, 0.30901699f}, {-0.94693013f, 0.32143947f},
{-0.94264149f, 0.33380686f}, {-0.93819134f, 0.34611706f},
{-0.93358043f, 0.35836795f}, {-0.92880955f, 0.37055744f},
{-0.92387953f, 0.38268343f}, {-0.91879121f, 0.39474386f},
{-0.91354546f, 0.40673664f}, {-0.90814317f, 0.41865974f},
{-0.90258528f, 0.43051110f}, {-0.89687274f, 0.44228869f},
{-0.89100652f, 0.45399050f}, {-0.88498764f, 0.46561452f},
{-0.87881711f, 0.47715876f}, {-0.87249601f, 0.48862124f},
{-0.86602540f, 0.50000000f}, {-0.85940641f, 0.51129309f},
{-0.85264016f, 0.52249856f}, {-0.84572782f, 0.53361452f},
{-0.83867057f, 0.54463904f}, {-0.83146961f, 0.55557023f},
{-0.82412619f, 0.56640624f}, {-0.81664156f, 0.57714519f},
{-0.80901699f, 0.58778525f}, {-0.80125381f, 0.59832460f},
{-0.79335334f, 0.60876143f}, {-0.78531693f, 0.61909395f},
{-0.77714596f, 0.62932039f}, {-0.76884183f, 0.63943900f},
{-0.76040597f, 0.64944805f}, {-0.75183981f, 0.65934582f},
{-0.74314483f, 0.66913061f}, {-0.73432251f, 0.67880075f},
{-0.72537437f, 0.68835458f}, {-0.71630194f, 0.69779046f},
{-0.70710678f, 0.70710678f}, {-0.69779046f, 0.71630194f},
{-0.68835458f, 0.72537437f}, {-0.67880075f, 0.73432251f},
{-0.66913061f, 0.74314483f}, {-0.65934582f, 0.75183981f},
{-0.64944805f, 0.76040597f}, {-0.63943900f, 0.76884183f},
{-0.62932039f, 0.77714596f}, {-0.61909395f, 0.78531693f},
{-0.60876143f, 0.79335334f}, {-0.59832460f, 0.80125381f},
{-0.58778525f, 0.80901699f}, {-0.57714519f, 0.81664156f},
{-0.56640624f, 0.82412619f}, {-0.55557023f, 0.83146961f},
{-0.54463904f, 0.83867057f}, {-0.53361452f, 0.84572782f},
{-0.52249856f, 0.85264016f}, {-0.51129309f, 0.85940641f},
{-0.50000000f, 0.86602540f}, {-0.48862124f, 0.87249601f},
{-0.47715876f, 0.87881711f}, {-0.46561452f, 0.88498764f},
{-0.45399050f, 0.89100652f}, {-0.44228869f, 0.89687274f},
{-0.43051110f, 0.90258528f}, {-0.41865974f, 0.90814317f},
{-0.40673664f, 0.91354546f}, {-0.39474386f, 0.91879121f},
{-0.38268343f, 0.92387953f}, {-0.37055744f, 0.92880955f},
{-0.35836795f, 0.93358043f}, {-0.34611706f, 0.93819134f},
{-0.33380686f, 0.94264149f}, {-0.32143947f, 0.94693013f},
{-0.30901699f, 0.95105652f}, {-0.29654157f, 0.95501994f},
{-0.28401534f, 0.95881973f}, {-0.27144045f, 0.96245524f},
{-0.25881905f, 0.96592583f}, {-0.24615329f, 0.96923091f},
{-0.23344536f, 0.97236992f}, {-0.22069744f, 0.97534232f},
{-0.20791169f, 0.97814760f}, {-0.19509032f, 0.98078528f},
{-0.18223553f, 0.98325491f}, {-0.16934950f, 0.98555606f},
{-0.15643447f, 0.98768834f}, {-0.14349262f, 0.98965139f},
{-0.13052619f, 0.99144486f}, {-0.11753740f, 0.99306846f},
{-0.10452846f, 0.99452190f}, {-0.091501619f, 0.99580493f},
{-0.078459096f, 0.99691733f}, {-0.065403129f, 0.99785892f},
{-0.052335956f, 0.99862953f}, {-0.039259816f, 0.99922904f},
{-0.026176948f, 0.99965732f}, {-0.013089596f, 0.99991433f},
{-1.8369702e-16f, 1.0000000f}, {0.013089596f, 0.99991433f},
{0.026176948f, 0.99965732f}, {0.039259816f, 0.99922904f},
{0.052335956f, 0.99862953f}, {0.065403129f, 0.99785892f},
{0.078459096f, 0.99691733f}, {0.091501619f, 0.99580493f},
{0.10452846f, 0.99452190f}, {0.11753740f, 0.99306846f},
{0.13052619f, 0.99144486f}, {0.14349262f, 0.98965139f},
{0.15643447f, 0.98768834f}, {0.16934950f, 0.98555606f},
{0.18223553f, 0.98325491f}, {0.19509032f, 0.98078528f},
{0.20791169f, 0.97814760f}, {0.22069744f, 0.97534232f},
{0.23344536f, 0.97236992f}, {0.24615329f, 0.96923091f},
{0.25881905f, 0.96592583f}, {0.27144045f, 0.96245524f},
{0.28401534f, 0.95881973f}, {0.29654157f, 0.95501994f},
{0.30901699f, 0.95105652f}, {0.32143947f, 0.94693013f},
{0.33380686f, 0.94264149f}, {0.34611706f, 0.93819134f},
{0.35836795f, 0.93358043f}, {0.37055744f, 0.92880955f},
{0.38268343f, 0.92387953f}, {0.39474386f, 0.91879121f},
{0.40673664f, 0.91354546f}, {0.41865974f, 0.90814317f},
{0.43051110f, 0.90258528f}, {0.44228869f, 0.89687274f},
{0.45399050f, 0.89100652f}, {0.46561452f, 0.88498764f},
{0.47715876f, 0.87881711f}, {0.48862124f, 0.87249601f},
{0.50000000f, 0.86602540f}, {0.51129309f, 0.85940641f},
{0.52249856f, 0.85264016f}, {0.53361452f, 0.84572782f},
{0.54463904f, 0.83867057f}, {0.55557023f, 0.83146961f},
{0.56640624f, 0.82412619f}, {0.57714519f, 0.81664156f},
{0.58778525f, 0.80901699f}, {0.59832460f, 0.80125381f},
{0.60876143f, 0.79335334f}, {0.61909395f, 0.78531693f},
{0.62932039f, 0.77714596f}, {0.63943900f, 0.76884183f},
{0.64944805f, 0.76040597f}, {0.65934582f, 0.75183981f},
{0.66913061f, 0.74314483f}, {0.67880075f, 0.73432251f},
{0.68835458f, 0.72537437f}, {0.69779046f, 0.71630194f},
{0.70710678f, 0.70710678f}, {0.71630194f, 0.69779046f},
{0.72537437f, 0.68835458f}, {0.73432251f, 0.67880075f},
{0.74314483f, 0.66913061f}, {0.75183981f, 0.65934582f},
{0.76040597f, 0.64944805f}, {0.76884183f, 0.63943900f},
{0.77714596f, 0.62932039f}, {0.78531693f, 0.61909395f},
{0.79335334f, 0.60876143f}, {0.80125381f, 0.59832460f},
{0.80901699f, 0.58778525f}, {0.81664156f, 0.57714519f},
{0.82412619f, 0.56640624f}, {0.83146961f, 0.55557023f},
{0.83867057f, 0.54463904f}, {0.84572782f, 0.53361452f},
{0.85264016f, 0.52249856f}, {0.85940641f, 0.51129309f},
{0.86602540f, 0.50000000f}, {0.87249601f, 0.48862124f},
{0.87881711f, 0.47715876f}, {0.88498764f, 0.46561452f},
{0.89100652f, 0.45399050f}, {0.89687274f, 0.44228869f},
{0.90258528f, 0.43051110f}, {0.90814317f, 0.41865974f},
{0.91354546f, 0.40673664f}, {0.91879121f, 0.39474386f},
{0.92387953f, 0.38268343f}, {0.92880955f, 0.37055744f},
{0.93358043f, 0.35836795f}, {0.93819134f, 0.34611706f},
{0.94264149f, 0.33380686f}, {0.94693013f, 0.32143947f},
{0.95105652f, 0.30901699f}, {0.95501994f, 0.29654157f},
{0.95881973f, 0.28401534f}, {0.96245524f, 0.27144045f},
{0.96592583f, 0.25881905f}, {0.96923091f, 0.24615329f},
{0.97236992f, 0.23344536f}, {0.97534232f, 0.22069744f},
{0.97814760f, 0.20791169f}, {0.98078528f, 0.19509032f},
{0.98325491f, 0.18223553f}, {0.98555606f, 0.16934950f},
{0.98768834f, 0.15643447f}, {0.98965139f, 0.14349262f},
{0.99144486f, 0.13052619f}, {0.99306846f, 0.11753740f},
{0.99452190f, 0.10452846f}, {0.99580493f, 0.091501619f},
{0.99691733f, 0.078459096f}, {0.99785892f, 0.065403129f},
{0.99862953f, 0.052335956f}, {0.99922904f, 0.039259816f},
{0.99965732f, 0.026176948f}, {0.99991433f, 0.013089596f},
};
#ifndef FFT_BITREV480
#define FFT_BITREV480
static const opus_int16 fft_bitrev480[480] = {
0, 96, 192, 288, 384, 32, 128, 224, 320, 416, 64, 160, 256, 352, 448,
8, 104, 200, 296, 392, 40, 136, 232, 328, 424, 72, 168, 264, 360, 456,
16, 112, 208, 304, 400, 48, 144, 240, 336, 432, 80, 176, 272, 368, 464,
24, 120, 216, 312, 408, 56, 152, 248, 344, 440, 88, 184, 280, 376, 472,
4, 100, 196, 292, 388, 36, 132, 228, 324, 420, 68, 164, 260, 356, 452,
12, 108, 204, 300, 396, 44, 140, 236, 332, 428, 76, 172, 268, 364, 460,
20, 116, 212, 308, 404, 52, 148, 244, 340, 436, 84, 180, 276, 372, 468,
28, 124, 220, 316, 412, 60, 156, 252, 348, 444, 92, 188, 284, 380, 476,
1, 97, 193, 289, 385, 33, 129, 225, 321, 417, 65, 161, 257, 353, 449,
9, 105, 201, 297, 393, 41, 137, 233, 329, 425, 73, 169, 265, 361, 457,
17, 113, 209, 305, 401, 49, 145, 241, 337, 433, 81, 177, 273, 369, 465,
25, 121, 217, 313, 409, 57, 153, 249, 345, 441, 89, 185, 281, 377, 473,
5, 101, 197, 293, 389, 37, 133, 229, 325, 421, 69, 165, 261, 357, 453,
13, 109, 205, 301, 397, 45, 141, 237, 333, 429, 77, 173, 269, 365, 461,
21, 117, 213, 309, 405, 53, 149, 245, 341, 437, 85, 181, 277, 373, 469,
29, 125, 221, 317, 413, 61, 157, 253, 349, 445, 93, 189, 285, 381, 477,
2, 98, 194, 290, 386, 34, 130, 226, 322, 418, 66, 162, 258, 354, 450,
10, 106, 202, 298, 394, 42, 138, 234, 330, 426, 74, 170, 266, 362, 458,
18, 114, 210, 306, 402, 50, 146, 242, 338, 434, 82, 178, 274, 370, 466,
26, 122, 218, 314, 410, 58, 154, 250, 346, 442, 90, 186, 282, 378, 474,
6, 102, 198, 294, 390, 38, 134, 230, 326, 422, 70, 166, 262, 358, 454,
14, 110, 206, 302, 398, 46, 142, 238, 334, 430, 78, 174, 270, 366, 462,
22, 118, 214, 310, 406, 54, 150, 246, 342, 438, 86, 182, 278, 374, 470,
30, 126, 222, 318, 414, 62, 158, 254, 350, 446, 94, 190, 286, 382, 478,
3, 99, 195, 291, 387, 35, 131, 227, 323, 419, 67, 163, 259, 355, 451,
11, 107, 203, 299, 395, 43, 139, 235, 331, 427, 75, 171, 267, 363, 459,
19, 115, 211, 307, 403, 51, 147, 243, 339, 435, 83, 179, 275, 371, 467,
27, 123, 219, 315, 411, 59, 155, 251, 347, 443, 91, 187, 283, 379, 475,
7, 103, 199, 295, 391, 39, 135, 231, 327, 423, 71, 167, 263, 359, 455,
15, 111, 207, 303, 399, 47, 143, 239, 335, 431, 79, 175, 271, 367, 463,
23, 119, 215, 311, 407, 55, 151, 247, 343, 439, 87, 183, 279, 375, 471,
31, 127, 223, 319, 415, 63, 159, 255, 351, 447, 95, 191, 287, 383, 479,
};
#endif

#ifndef FFT_BITREV240
#define FFT_BITREV240
static const opus_int16 fft_bitrev240[240] = {
0, 48, 96, 144, 192, 16, 64, 112, 160, 208, 32, 80, 128, 176, 224,
4, 52, 100, 148, 196, 20, 68, 116, 164, 212, 36, 84, 132, 180, 228,
8, 56, 104, 152, 200, 24, 72, 120, 168, 216, 40, 88, 136, 184, 232,
12, 60, 108, 156, 204, 28, 76, 124, 172, 220, 44, 92, 140, 188, 236,
1, 49, 97, 145, 193, 17, 65, 113, 161, 209, 33, 81, 129, 177, 225,
5, 53, 101, 149, 197, 21, 69, 117, 165, 213, 37, 85, 133, 181, 229,
9, 57, 105, 153, 201, 25, 73, 121, 169, 217, 41, 89, 137, 185, 233,
13, 61, 109, 157, 205, 29, 77, 125, 173, 221, 45, 93, 141, 189, 237,
2, 50, 98, 146, 194, 18, 66, 114, 162, 210, 34, 82, 130, 178, 226,
6, 54, 102, 150, 198, 22, 70, 118, 166, 214, 38, 86, 134, 182, 230,
10, 58, 106, 154, 202, 26, 74, 122, 170, 218, 42, 90, 138, 186, 234,
14, 62, 110, 158, 206, 30, 78, 126, 174, 222, 46, 94, 142, 190, 238,
3, 51, 99, 147, 195, 19, 67, 115, 163, 211, 35, 83, 131, 179, 227,
7, 55, 103, 151, 199, 23, 71, 119, 167, 215, 39, 87, 135, 183, 231,
11, 59, 107, 155, 203, 27, 75, 123, 171, 219, 43, 91, 139, 187, 235,
15, 63, 111, 159, 207, 31, 79, 127, 175, 223, 47, 95, 143, 191, 239,
};
#endif

#ifndef FFT_BITREV120
#define FFT_BITREV120
static const opus_int16 fft_bitrev120[120] = {
0, 24, 48, 72, 96, 8, 32, 56, 80, 104, 16, 40, 64, 88, 112,
4, 28, 52, 76, 100, 12, 36, 60, 84, 108, 20, 44, 68, 92, 116,
1, 25, 49, 73, 97, 9, 33, 57, 81, 105, 17, 41, 65, 89, 113,
5, 29, 53, 77, 101, 13, 37, 61, 85, 109, 21, 45, 69, 93, 117,
2, 26, 50, 74, 98, 10, 34, 58, 82, 106, 18, 42, 66, 90, 114,
6, 30, 54, 78, 102, 14, 38, 62, 86, 110, 22, 46, 70, 94, 118,
3, 27, 51, 75, 99, 11, 35, 59, 83, 107, 19, 43, 67, 91, 115,
7, 31, 55, 79, 103, 15, 39, 63, 87, 111, 23, 47, 71, 95, 119,
};
#endif

#ifndef FFT_BITREV60
#define FFT_BITREV60
static const opus_int16 fft_bitrev60[60] = {
0, 12, 24, 36, 48, 4, 16, 28, 40, 52, 8, 20, 32, 44, 56,
1, 13, 25, 37, 49, 5, 17, 29, 41, 53, 9, 21, 33, 45, 57,
2, 14, 26, 38, 50, 6, 18, 30, 42, 54, 10, 22, 34, 46, 58,
3, 15, 27, 39, 51, 7, 19, 31, 43, 55, 11, 23, 35, 47, 59,
};
#endif

#ifndef FFT_STATE48000_960_0
#define FFT_STATE48000_960_0
static const kiss_fft_state fft_state48000_960_0 = {
480,    /* nfft */
0.0020833334f,    /* scale */
-1,    /* shift */
{5, 96, 3, 32, 4, 8, 2, 4, 4, 1, 0, 0, 0, 0, 0, 0, },    /* factors */
fft_bitrev480,    /* bitrev */
fft_twiddles48000_960,    /* bitrev */
#ifdef OVERRIDE_FFT
(arch_fft_state *)&cfg_arch_480,
#else
NULL,
#endif
};
#endif

#ifndef FFT_STATE48000_960_1
#define FFT_STATE48000_960_1
static const kiss_fft_state fft_state48000_960_1 = {
240,    /* nfft */
0.0041666669f,    /* scale */
1,    /* shift */
{5, 48, 3, 16, 4, 4, 4, 1, 0, 0, 0, 0, 0, 0, 0, 0, },    /* factors */
fft_bitrev240,    /* bitrev */
fft_twiddles48000_960,    /* bitrev */
#ifdef OVERRIDE_FFT
(arch_fft_state *)&cfg_arch_240,
#else
NULL,
#endif
};
#endif

#ifndef FFT_STATE48000_960_2
#define FFT_STATE48000_960_2
static const kiss_fft_state fft_state48000_960_2 = {
120,    /* nfft */
0.0083333338f,    /* scale */
2,    /* shift */
{5, 24, 3, 8, 2, 4, 4, 1, 0, 0, 0, 0, 0, 0, 0, 0, },    /* factors */
fft_bitrev120,    /* bitrev */
fft_twiddles48000_960,    /* bitrev */
#ifdef OVERRIDE_FFT
(arch_fft_state *)&cfg_arch_120,
#else
NULL,
#endif
};
#endif

#ifndef FFT_STATE48000_960_3
#define FFT_STATE48000_960_3
static const kiss_fft_state fft_state48000_960_3 = {
60,    /* nfft */
0.016666668f,    /* scale */
3,    /* shift */
{5, 12, 3, 4, 4, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, },    /* factors */
fft_bitrev60,    /* bitrev */
fft_twiddles48000_960,    /* bitrev */
#ifdef OVERRIDE_FFT
(arch_fft_state *)&cfg_arch_60,
#else
NULL,
#endif
};
#endif

#endif

#ifndef MDCT_TWIDDLES960
#define MDCT_TWIDDLES960
static const celt_coef mdct_twiddles960[1800] = {
0.99999992f, 0.99999322f, 0.99997582f, 0.99994771f, 0.99990889f,
0.99985936f, 0.99979913f, 0.99972818f, 0.99964653f, 0.99955418f,
0.99945112f, 0.99933736f, 0.99921289f, 0.99907773f, 0.99893186f,
0.99877530f, 0.99860804f, 0.99843009f, 0.99824144f, 0.99804211f,
0.99783209f, 0.99761138f, 0.99737998f, 0.99713791f, 0.99688516f,
0.99662173f, 0.99634763f, 0.99606285f, 0.99576741f, 0.99546131f,
0.99514455f, 0.99481713f, 0.99447905f, 0.99413033f, 0.99377096f,
0.99340095f, 0.99302029f, 0.99262901f, 0.99222709f, 0.99181455f,
0.99139139f, 0.99095760f, 0.99051321f, 0.99005821f, 0.98959261f,
0.98911641f, 0.98862961f, 0.98813223f, 0.98762427f, 0.98710573f,
0.98657662f, 0.98603694f, 0.98548670f, 0.98492591f, 0.98435457f,
0.98377269f, 0.98318028f, 0.98257734f, 0.98196387f, 0.98133989f,
0.98070539f, 0.98006040f, 0.97940491f, 0.97873893f, 0.97806247f,
0.97737554f, 0.97667813f, 0.97597027f, 0.97525196f, 0.97452320f,
0.97378401f, 0.97303439f, 0.97227435f, 0.97150389f, 0.97072303f,
0.96993178f, 0.96913014f, 0.96831812f, 0.96749573f, 0.96666298f,
0.96581987f, 0.96496643f, 0.96410265f, 0.96322854f, 0.96234412f,
0.96144939f, 0.96054437f, 0.95962906f, 0.95870347f, 0.95776762f,
0.95682151f, 0.95586515f, 0.95489856f, 0.95392174f, 0.95293471f,
0.95193746f, 0.95093003f, 0.94991241f, 0.94888462f, 0.94784667f,
0.94679856f, 0.94574032f, 0.94467195f, 0.94359346f, 0.94250486f,
0.94140618f, 0.94029741f, 0.93917857f, 0.93804967f, 0.93691073f,
0.93576176f, 0.93460276f, 0.93343375f, 0.93225475f, 0.93106577f,
0.92986681f, 0.92865789f, 0.92743903f, 0.92621024f, 0.92497153f,
0.92372291f, 0.92246440f, 0.92119602f, 0.91991776f, 0.91862966f,
0.91733172f, 0.91602395f, 0.91470637f, 0.91337900f, 0.91204185f,
0.91069493f, 0.90933825f, 0.90797184f, 0.90659570f, 0.90520986f,
0.90381432f, 0.90240910f, 0.90099422f, 0.89956969f, 0.89813553f,
0.89669174f, 0.89523836f, 0.89377538f, 0.89230284f, 0.89082074f,
0.88932910f, 0.88782793f, 0.88631726f, 0.88479710f, 0.88326746f,
0.88172836f, 0.88017982f, 0.87862185f, 0.87705448f, 0.87547771f,
0.87389156f, 0.87229606f, 0.87069121f, 0.86907704f, 0.86745357f,
0.86582080f, 0.86417876f, 0.86252747f, 0.86086694f, 0.85919719f,
0.85751824f, 0.85583010f, 0.85413281f, 0.85242636f, 0.85071078f,
0.84898610f, 0.84725232f, 0.84550947f, 0.84375756f, 0.84199662f,
0.84022666f, 0.83844771f, 0.83665977f, 0.83486287f, 0.83305704f,
0.83124228f, 0.82941862f, 0.82758608f, 0.82574467f, 0.82389442f,
0.82203535f, 0.82016748f, 0.81829082f, 0.81640540f, 0.81451123f,
0.81260835f, 0.81069676f, 0.80877649f, 0.80684755f, 0.80490998f,
0.80296379f, 0.80100899f, 0.79904562f, 0.79707370f, 0.79509323f,
0.79310425f, 0.79110678f, 0.78910084f, 0.78708644f, 0.78506362f,
0.78303239f, 0.78099277f, 0.77894479f, 0.77688847f, 0.77482382f,
0.77275088f, 0.77066967f, 0.76858020f, 0.76648250f, 0.76437659f,
0.76226250f, 0.76014024f, 0.75800984f, 0.75587132f, 0.75372471f,
0.75157003f, 0.74940730f, 0.74723654f, 0.74505779f, 0.74287105f,
0.74067635f, 0.73847373f, 0.73626320f, 0.73404478f, 0.73181850f,
0.72958438f, 0.72734245f, 0.72509273f, 0.72283525f, 0.72057002f,
0.71829708f, 0.71601644f, 0.71372814f, 0.71143220f, 0.70912863f,
0.70681747f, 0.70449874f, 0.70217247f, 0.69983868f, 0.69749739f,
0.69514863f, 0.69279243f, 0.69042881f, 0.68805780f, 0.68567941f,
0.68329369f, 0.68090064f, 0.67850031f, 0.67609270f, 0.67367786f,
0.67125580f, 0.66882656f, 0.66639015f, 0.66394661f, 0.66149595f,
0.65903821f, 0.65657341f, 0.65410159f, 0.65162275f, 0.64913694f,
0.64664418f, 0.64414449f, 0.64163790f, 0.63912444f, 0.63660414f,
0.63407702f, 0.63154311f, 0.62900244f, 0.62645503f, 0.62390091f,
0.62134011f, 0.61877265f, 0.61619857f, 0.61361789f, 0.61103064f,
0.60843685f, 0.60583654f, 0.60322974f, 0.60061648f, 0.59799679f,
0.59537069f, 0.59273822f, 0.59009940f, 0.58745427f, 0.58480284f,
0.58214514f, 0.57948122f, 0.57681109f, 0.57413478f, 0.57145232f,
0.56876374f, 0.56606907f, 0.56336834f, 0.56066158f, 0.55794881f,
0.55523006f, 0.55250537f, 0.54977477f, 0.54703827f, 0.54429592f,
0.54154774f, 0.53879376f, 0.53603401f, 0.53326852f, 0.53049731f,
0.52772043f, 0.52493790f, 0.52214974f, 0.51935599f, 0.51655668f,
0.51375184f, 0.51094149f, 0.50812568f, 0.50530442f, 0.50247775f,
0.49964570f, 0.49680830f, 0.49396558f, 0.49111757f, 0.48826430f,
0.48540580f, 0.48254210f, 0.47967323f, 0.47679923f, 0.47392012f,
0.47103594f, 0.46814671f, 0.46525247f, 0.46235324f, 0.45944907f,
0.45653997f, 0.45362599f, 0.45070714f, 0.44778347f, 0.44485501f,
0.44192178f, 0.43898381f, 0.43604115f, 0.43309382f, 0.43014185f,
0.42718527f, 0.42422412f, 0.42125842f, 0.41828822f, 0.41531353f,
0.41233440f, 0.40935085f, 0.40636291f, 0.40337063f, 0.40037402f,
0.39737313f, 0.39436798f, 0.39135861f, 0.38834505f, 0.38532733f,
0.38230548f, 0.37927953f, 0.37624953f, 0.37321550f, 0.37017747f,
0.36713547f, 0.36408955f, 0.36103972f, 0.35798603f, 0.35492850f,
0.35186718f, 0.34880208f, 0.34573325f, 0.34266072f, 0.33958451f,
0.33650468f, 0.33342123f, 0.33033422f, 0.32724367f, 0.32414961f,
0.32105209f, 0.31795112f, 0.31484675f, 0.31173901f, 0.30862793f,
0.30551354f, 0.30239588f, 0.29927499f, 0.29615089f, 0.29302362f,
0.28989321f, 0.28675969f, 0.28362310f, 0.28048348f, 0.27734085f,
0.27419526f, 0.27104672f, 0.26789529f, 0.26474098f, 0.26158384f,
0.25842390f, 0.25526119f, 0.25209575f, 0.24892761f, 0.24575680f,
0.24258336f, 0.23940732f, 0.23622872f, 0.23304759f, 0.22986396f,
0.22667787f, 0.22348935f, 0.22029844f, 0.21710517f, 0.21390958f,
0.21071169f, 0.20751155f, 0.20430919f, 0.20110463f, 0.19789793f,
0.19468910f, 0.19147819f, 0.18826523f, 0.18505026f, 0.18183330f,
0.17861439f, 0.17539357f, 0.17217088f, 0.16894634f, 0.16571999f,
0.16249186f, 0.15926200f, 0.15603043f, 0.15279719f, 0.14956231f,
0.14632583f, 0.14308778f, 0.13984820f, 0.13660713f, 0.13336459f,
0.13012062f, 0.12687526f, 0.12362854f, 0.12038049f, 0.11713116f,
0.11388057f, 0.11062877f, 0.10737578f, 0.10412163f, 0.10086638f,
0.097610040f, 0.094352658f, 0.091094266f, 0.087834897f, 0.084574589f,
0.081313374f, 0.078051289f, 0.074788367f, 0.071524645f, 0.068260157f,
0.064994938f, 0.061729023f, 0.058462447f, 0.055195244f, 0.051927451f,
0.048659101f, 0.045390231f, 0.042120874f, 0.038851066f, 0.035580842f,
0.032310238f, 0.029039287f, 0.025768025f, 0.022496487f, 0.019224708f,
0.015952723f, 0.012680568f, 0.0094082767f, 0.0061358846f, 0.0028634269f,
-0.00040906153f, -0.0036815456f, -0.0069539902f, -0.010226360f, -0.013498621f,
-0.016770737f, -0.020042673f, -0.023314395f, -0.026585867f, -0.029857055f,
-0.033127923f, -0.036398436f, -0.039668559f, -0.042938257f, -0.046207495f,
-0.049476239f, -0.052744453f, -0.056012102f, -0.059279151f, -0.062545565f,
-0.065811309f, -0.069076349f, -0.072340649f, -0.075604174f, -0.078866890f,
-0.082128761f, -0.085389752f, -0.088649829f, -0.091908956f, -0.095167100f,
-0.098424224f, -0.10168029f, -0.10493528f, -0.10818913f, -0.11144183f,
-0.11469334f, -0.11794361f, -0.12119263f, -0.12444034f, -0.12768673f,
-0.13093174f, -0.13417536f, -0.13741753f, -0.14065824f, -0.14389744f,
-0.14713510f, -0.15037118f, -0.15360565f, -0.15683848f, -0.16006962f,
-0.16329906f, -0.16652674f, -0.16975264f, -0.17297673f, -0.17619896f,
-0.17941930f, -0.18263772f, -0.18585419f, -0.18906866f, -0.19228112f,
-0.19549151f, -0.19869981f, -0.20190598f, -0.20510998f, -0.20831180f,
-0.21151138f, -0.21470869f, -0.21790371f, -0.22109639f, -0.22428671f,
-0.22747462f, -0.23066010f, -0.23384310f, -0.23702361f, -0.24020157f,
-0.24337696f, -0.24654975f, -0.24971989f, -0.25288736f, -0.25605213f,
-0.25921415f, -0.26237339f, -0.26552983f, -0.26868342f, -0.27183413f,
-0.27498193f, -0.27812679f, -0.28126867f, -0.28440754f, -0.28754336f,
-0.29067610f, -0.29380573f, -0.29693221f, -0.30005551f, -0.30317560f,
-0.30629245f, -0.30940601f, -0.31251626f, -0.31562316f, -0.31872668f,
-0.32182679f, -0.32492345f, -0.32801664f, -0.33110631f, -0.33419243f,
-0.33727497f, -0.34035391f, -0.34342920f, -0.34650081f, -0.34956871f,
-0.35263286f, -0.35569324f, -0.35874981f, -0.36180254f, -0.36485139f,
-0.36789634f, -0.37093735f, -0.37397438f, -0.37700741f, -0.38003640f,
-0.38306132f, -0.38608214f, -0.38909883f, -0.39211135f, -0.39511967f,
-0.39812375f, -0.40112358f, -0.40411910f, -0.40711031f, -0.41009715f,
-0.41307959f, -0.41605762f, -0.41903119f, -0.42200027f, -0.42496483f,
-0.42792484f, -0.43088027f, -0.43383109f, -0.43677726f, -0.43971875f,
-0.44265553f, -0.44558757f, -0.44851484f, -0.45143731f, -0.45435494f,
-0.45726770f, -0.46017557f, -0.46307851f, -0.46597650f, -0.46886949f,
-0.47175746f, -0.47464038f, -0.47751821f, -0.48039093f, -0.48325851f,
-0.48612091f, -0.48897811f, -0.49183006f, -0.49467676f, -0.49751815f,
-0.50035422f, -0.50318492f, -0.50601024f, -0.50883014f, -0.51164459f,
-0.51445356f, -0.51725703f, -0.52005495f, -0.52284730f, -0.52563406f,
-0.52841518f, -0.53119065f, -0.53396043f, -0.53672449f, -0.53948280f,
-0.54223533f, -0.54498206f, -0.54772295f, -0.55045797f, -0.55318710f,
-0.55591031f, -0.55862756f, -0.56133883f, -0.56404409f, -0.56674331f,
-0.56943646f, -0.57212351f, -0.57480443f, -0.57747920f, -0.58014778f,
-0.58281015f, -0.58546628f, -0.58811614f, -0.59075970f, -0.59339694f,
-0.59602782f, -0.59865231f, -0.60127040f, -0.60388204f, -0.60648722f,
-0.60908591f, -0.61167807f, -0.61426368f, -0.61684271f, -0.61941514f,
-0.62198093f, -0.62454007f, -0.62709251f, -0.62963824f, -0.63217722f,
-0.63470944f, -0.63723486f, -0.63975345f, -0.64226519f, -0.64477006f,
-0.64726802f, -0.64975905f, -0.65224312f, -0.65472020f, -0.65719027f,
-0.65965331f, -0.66210928f, -0.66455816f, -0.66699992f, -0.66943454f,
-0.67186199f, -0.67428225f, -0.67669528f, -0.67910107f, -0.68149959f,
-0.68389080f, -0.68627470f, -0.68865124f, -0.69102041f, -0.69338218f,
-0.69573652f, -0.69808341f, -0.70042283f, -0.70275474f, -0.70507913f,
-0.70739597f, -0.70970524f, -0.71200690f, -0.71430093f, -0.71658732f,
-0.71886604f, -0.72113705f, -0.72340034f, -0.72565589f, -0.72790366f,
-0.73014364f, -0.73237580f, -0.73460012f, -0.73681657f, -0.73902513f,
-0.74122577f, -0.74341848f, -0.74560322f, -0.74777998f, -0.74994874f,
-0.75210946f, -0.75426212f, -0.75640671f, -0.75854320f, -0.76067157f,
-0.76279178f, -0.76490383f, -0.76700769f, -0.76910334f, -0.77119075f,
-0.77326989f, -0.77534076f, -0.77740333f, -0.77945757f, -0.78150346f,
-0.78354098f, -0.78557011f, -0.78759083f, -0.78960312f, -0.79160694f,
-0.79360229f, -0.79558915f, -0.79756748f, -0.79953727f, -0.80149850f,
-0.80345114f, -0.80539518f, -0.80733060f, -0.80925737f, -0.81117547f,
-0.81308489f, -0.81498559f, -0.81687757f, -0.81876081f, -0.82063527f,
-0.82250095f, -0.82435781f, -0.82620585f, -0.82804505f, -0.82987537f,
-0.83169681f, -0.83350933f, -0.83531294f, -0.83710760f, -0.83889329f,
-0.84067000f, -0.84243770f, -0.84419639f, -0.84594603f, -0.84768662f,
-0.84941812f, -0.85114053f, -0.85285383f, -0.85455799f, -0.85625300f,
-0.85793884f, -0.85961549f, -0.86128294f, -0.86294116f, -0.86459014f,
-0.86622986f, -0.86786031f, -0.86948146f, -0.87109330f, -0.87269581f,
-0.87428898f, -0.87587278f, -0.87744720f, -0.87901223f, -0.88056784f,
-0.88211402f, -0.88365076f, -0.88517803f, -0.88669582f, -0.88820412f,
-0.88970290f, -0.89119216f, -0.89267187f, -0.89414203f, -0.89560260f,
-0.89705359f, -0.89849497f, -0.89992673f, -0.90134885f, -0.90276131f,
-0.90416411f, -0.90555723f, -0.90694065f, -0.90831436f, -0.90967833f,
-0.91103257f, -0.91237705f, -0.91371176f, -0.91503669f, -0.91635181f,
-0.91765712f, -0.91895261f, -0.92023825f, -0.92151404f, -0.92277996f,
-0.92403600f, -0.92528214f, -0.92651837f, -0.92774468f, -0.92896106f,
-0.93016748f, -0.93136395f, -0.93255044f, -0.93372694f, -0.93489345f,
-0.93604994f, -0.93719641f, -0.93833284f, -0.93945922f, -0.94057555f,
-0.94168180f, -0.94277796f, -0.94386403f, -0.94493999f, -0.94600583f,
-0.94706154f, -0.94810711f, -0.94914252f, -0.95016777f, -0.95118284f,
-0.95218773f, -0.95318242f, -0.95416690f, -0.95514117f, -0.95610520f,
-0.95705900f, -0.95800255f, -0.95893583f, -0.95985885f, -0.96077159f,
-0.96167404f, -0.96256619f, -0.96344803f, -0.96431956f, -0.96518076f,
-0.96603162f, -0.96687213f, -0.96770230f, -0.96852209f, -0.96933152f,
-0.97013057f, -0.97091922f, -0.97169748f, -0.97246533f, -0.97322277f,
-0.97396979f, -0.97470637f, -0.97543252f, -0.97614822f, -0.97685347f,
-0.97754825f, -0.97823257f, -0.97890641f, -0.97956977f, -0.98022263f,
-0.98086500f, -0.98149687f, -0.98211822f, -0.98272906f, -0.98332937f,
-0.98391915f, -0.98449840f, -0.98506710f, -0.98562525f, -0.98617285f,
-0.98670988f, -0.98723635f, -0.98775225f, -0.98825757f, -0.98875230f,
-0.98923645f, -0.98971000f, -0.99017295f, -0.99062530f, -0.99106704f,
-0.99149817f, -0.99191868f, -0.99232857f, -0.99272783f, -0.99311645f,
-0.99349445f, -0.99386180f, -0.99421851f, -0.99456457f, -0.99489998f,
-0.99522474f, -0.99553884f, -0.99584227f, -0.99613505f, -0.99641715f,
-0.99668858f, -0.99694934f, -0.99719943f, -0.99743883f, -0.99766756f,
-0.99788559f, -0.99809295f, -0.99828961f, -0.99847558f, -0.99865086f,
-0.99881544f, -0.99896933f, -0.99911252f, -0.99924501f, -0.99936680f,
-0.99947789f, -0.99957827f, -0.99966795f, -0.99974692f, -0.99981519f,
-0.99987275f, -0.99991960f, -0.99995574f, -0.99998118f, -0.99999590f,
0.99999967f, 0.99997289f, 0.99990328f, 0.99979084f, 0.99963557f,
0.99943748f, 0.99919658f, 0.99891288f, 0.99858638f, 0.99821711f,
0.99780508f, 0.99735031f, 0.99685281f, 0.99631261f, 0.99572973f,
0.99510420f, 0.99443605f, 0.99372529f, 0.99297196f, 0.99217610f,
0.99133774f, 0.99045692f, 0.98953366f, 0.98856802f, 0.98756003f,
0.98650973f, 0.98541718f, 0.98428242f, 0.98310549f, 0.98188645f,
0.98062534f, 0.97932224f, 0.97797718f, 0.97659022f, 0.97516144f,
0.97369088f, 0.97217861f, 0.97062469f, 0.96902920f, 0.96739220f,
0.96571376f, 0.96399395f, 0.96223284f, 0.96043052f, 0.95858705f,
0.95670253f, 0.95477702f, 0.95281061f, 0.95080338f, 0.94875543f,
0.94666684f, 0.94453769f, 0.94236808f, 0.94015810f, 0.93790786f,
0.93561743f, 0.93328693f, 0.93091644f, 0.92850608f, 0.92605595f,
0.92356614f, 0.92103677f, 0.91846795f, 0.91585979f, 0.91321239f,
0.91052587f, 0.90780035f, 0.90503595f, 0.90223277f, 0.89939095f,
0.89651059f, 0.89359184f, 0.89063481f, 0.88763962f, 0.88460641f,
0.88153531f, 0.87842644f, 0.87527995f, 0.87209596f, 0.86887462f,
0.86561605f, 0.86232041f, 0.85898782f, 0.85561844f, 0.85221241f,
0.84876987f, 0.84529098f, 0.84177587f, 0.83822471f, 0.83463763f,
0.83101481f, 0.82735639f, 0.82366252f, 0.81993338f, 0.81616911f,
0.81236987f, 0.80853584f, 0.80466718f, 0.80076404f, 0.79682660f,
0.79285503f, 0.78884950f, 0.78481017f, 0.78073723f, 0.77663084f,
0.77249118f, 0.76831844f, 0.76411277f, 0.75987438f, 0.75560344f,
0.75130013f, 0.74696464f, 0.74259715f, 0.73819784f, 0.73376692f,
0.72930457f, 0.72481097f, 0.72028632f, 0.71573083f, 0.71114467f,
0.70652804f, 0.70188116f, 0.69720420f, 0.69249738f, 0.68776090f,
0.68299495f, 0.67819975f, 0.67337550f, 0.66852240f, 0.66364066f,
0.65873050f, 0.65379211f, 0.64882573f, 0.64383154f, 0.63880978f,
0.63376065f, 0.62868438f, 0.62358117f, 0.61845126f, 0.61329485f,
0.60811216f, 0.60290343f, 0.59766888f, 0.59240872f, 0.58712318f,
0.58181249f, 0.57647688f, 0.57111658f, 0.56573181f, 0.56032281f,
0.55488980f, 0.54943303f, 0.54395272f, 0.53844911f, 0.53292243f,
0.52737292f, 0.52180083f, 0.51620638f, 0.51058981f, 0.50495138f,
0.49929132f, 0.49360987f, 0.48790727f, 0.48218377f, 0.47643962f,
0.47067506f, 0.46489034f, 0.45908570f, 0.45326139f, 0.44741768f,
0.44155479f, 0.43567299f, 0.42977253f, 0.42385365f, 0.41791662f,
0.41196169f, 0.40598911f, 0.39999914f, 0.39399204f, 0.38796806f,
0.38192746f, 0.37587050f, 0.36979743f, 0.36370853f, 0.35760405f,
0.35148424f, 0.34534939f, 0.33919973f, 0.33303555f, 0.32685710f,
0.32066465f, 0.31445847f, 0.30823881f, 0.30200595f, 0.29576015f,
0.28950169f, 0.28323082f, 0.27694782f, 0.27065295f, 0.26434649f,
0.25802871f, 0.25169988f, 0.24536026f, 0.23901013f, 0.23264977f,
0.22627944f, 0.21989941f, 0.21350997f, 0.20711138f, 0.20070391f,
0.19428785f, 0.18786347f, 0.18143104f, 0.17499084f, 0.16854314f,
0.16208822f, 0.15562636f, 0.14915783f, 0.14268292f, 0.13620189f,
0.12971502f, 0.12322260f, 0.11672491f, 0.11022221f, 0.10371479f,
0.097202924f, 0.090686897f, 0.084166986f, 0.077643468f, 0.071116625f,
0.064586736f, 0.058054080f, 0.051518937f, 0.044981587f, 0.038442310f,
0.031901387f, 0.025359097f, 0.018815721f, 0.012271538f, 0.0057268303f,
-0.00081812300f, -0.0073630412f, -0.013907644f, -0.020451651f, -0.026994782f,
-0.033536757f, -0.040077295f, -0.046616116f, -0.053152941f, -0.059687488f,
-0.066219479f, -0.072748633f, -0.079274670f, -0.085797312f, -0.092316279f,
-0.098831291f, -0.10534207f, -0.11184834f, -0.11834981f, -0.12484622f,
-0.13133727f, -0.13782270f, -0.14430223f, -0.15077558f, -0.15724246f,
-0.16370261f, -0.17015575f, -0.17660160f, -0.18303989f, -0.18947033f,
-0.19589266f, -0.20230660f, -0.20871187f, -0.21510820f, -0.22149531f,
-0.22787294f, -0.23424080f, -0.24059864f, -0.24694616f, -0.25328311f,
-0.25960920f, -0.26592418f, -0.27222777f, -0.27851969f, -0.28479968f,
-0.29106748f, -0.29732280f, -0.30356539f, -0.30979497f, -0.31601129f,
-0.32221406f, -0.32840304f, -0.33457794f, -0.34073852f, -0.34688450f,
-0.35301562f, -0.35913161f, -0.36523223f, -0.37131719f, -0.37738626f,
-0.38343915f, -0.38947562f, -0.39549541f, -0.40149825f, -0.40748390f,
-0.41345209f, -0.41940257f, -0.42533508f, -0.43124938f, -0.43714520f,
-0.44302229f, -0.44888041f, -0.45471930f, -0.46053871f, -0.46633839f,
-0.47211810f, -0.47787758f, -0.48361659f, -0.48933489f, -0.49503222f,
-0.50070835f, -0.50636303f, -0.51199602f, -0.51760707f, -0.52319595f,
-0.52876243f, -0.53430625f, -0.53982718f, -0.54532499f, -0.55079944f,
-0.55625029f, -0.56167732f, -0.56708028f, -0.57245896f, -0.57781311f,
-0.58314251f, -0.58844693f, -0.59372614f, -0.59897992f, -0.60420805f,
-0.60941029f, -0.61458642f, -0.61973623f, -0.62485949f, -0.62995598f,
-0.63502549f, -0.64006780f, -0.64508268f, -0.65006994f, -0.65502934f,
-0.65996069f, -0.66486377f, -0.66973837f, -0.67458427f, -0.67940128f,
-0.68418919f, -0.68894779f, -0.69367688f, -0.69837625f, -0.70304571f,
-0.70768504f, -0.71229407f, -0.71687258f, -0.72142039f, -0.72593729f,
-0.73042309f, -0.73487761f, -0.73930064f, -0.74369201f, -0.74805152f,
-0.75237898f, -0.75667422f, -0.76093704f, -0.76516727f, -0.76936471f,
-0.77352921f, -0.77766056f, -0.78175861f, -0.78582316f, -0.78985406f,
-0.79385112f, -0.79781417f, -0.80174305f, -0.80563758f, -0.80949760f,
-0.81332295f, -0.81711346f, -0.82086896f, -0.82458930f, -0.82827432f,
-0.83192386f, -0.83553776f, -0.83911587f, -0.84265803f, -0.84616410f,
-0.84963392f, -0.85306735f, -0.85646423f, -0.85982442f, -0.86314779f,
-0.86643418f, -0.86968345f, -0.87289547f, -0.87607009f, -0.87920719f,
-0.88230663f, -0.88536827f, -0.88839199f, -0.89137765f, -0.89432512f,
-0.89723429f, -0.90010502f, -0.90293719f, -0.90573069f, -0.90848539f,
-0.91120117f, -0.91387791f, -0.91651551f, -0.91911385f, -0.92167282f,
-0.92419231f, -0.92667220f, -0.92911240f, -0.93151280f, -0.93387330f,
-0.93619380f, -0.93847419f, -0.94071438f, -0.94291427f, -0.94507377f,
-0.94719279f, -0.94927123f, -0.95130901f, -0.95330604f, -0.95526223f,
-0.95717750f, -0.95905177f, -0.96088496f, -0.96267699f, -0.96442777f,
-0.96613725f, -0.96780534f, -0.96943197f, -0.97101707f, -0.97256058f,
-0.97406243f, -0.97552255f, -0.97694089f, -0.97831737f, -0.97965195f,
-0.98094456f, -0.98219515f, -0.98340367f, -0.98457006f, -0.98569428f,
-0.98677627f, -0.98781599f, -0.98881340f, -0.98976845f, -0.99068110f,
-0.99155132f, -0.99237906f, -0.99316428f, -0.99390697f, -0.99460708f,
-0.99526458f, -0.99587945f, -0.99645166f, -0.99698119f, -0.99746801f,
-0.99791210f, -0.99831344f, -0.99867202f, -0.99898782f, -0.99926082f,
-0.99949102f, -0.99967841f, -0.99982297f, -0.99992470f, -0.99998360f,
0.99999866f, 0.99989157f, 0.99961315f, 0.99916346f, 0.99854256f,
0.99775057f, 0.99678762f, 0.99565388f, 0.99434953f, 0.99287481f,
0.99122996f, 0.98941527f, 0.98743105f, 0.98527764f, 0.98295541f,
0.98046475f, 0.97780610f, 0.97497990f, 0.97198664f, 0.96882685f,
0.96550104f, 0.96200980f, 0.95835373f, 0.95453345f, 0.95054962f,
0.94640291f, 0.94209404f, 0.93762375f, 0.93299280f, 0.92820199f,
0.92325213f, 0.91814408f, 0.91287871f, 0.90745693f, 0.90187965f,
0.89614785f, 0.89026249f, 0.88422459f, 0.87803519f, 0.87169533f,
0.86520612f, 0.85856866f, 0.85178409f, 0.84485357f, 0.83777828f,
0.83055945f, 0.82319831f, 0.81569611f, 0.80805415f, 0.80027373f,
0.79235620f, 0.78430289f, 0.77611520f, 0.76779452f, 0.75934229f,
0.75075995f, 0.74204897f, 0.73321084f, 0.72424708f, 0.71515923f,
0.70594883f, 0.69661748f, 0.68716676f, 0.67759830f, 0.66791374f,
0.65811474f, 0.64820297f, 0.63818013f, 0.62804795f, 0.61780815f,
0.60746249f, 0.59701275f, 0.58646072f, 0.57580819f, 0.56505701f,
0.55420900f, 0.54326604f, 0.53222998f, 0.52110274f, 0.50988620f,
0.49858230f, 0.48719297f, 0.47572016f, 0.46416584f, 0.45253199f,
0.44082059f, 0.42903367f, 0.41717323f, 0.40524131f, 0.39323996f,
0.38117123f, 0.36903718f, 0.35683990f, 0.34458148f, 0.33226402f,
0.31988962f, 0.30746042f, 0.29497853f, 0.28244610f, 0.26986527f,
0.25723821f, 0.24456706f, 0.23185402f, 0.21910124f, 0.20631092f,
0.19348526f, 0.18062644f, 0.16773667f, 0.15481816f, 0.14187312f,
0.12890377f, 0.11591234f, 0.10290104f, 0.089872115f, 0.076827789f,
0.063770300f, 0.050701883f, 0.037624779f, 0.024541229f, 0.011453473f,
-0.0016362454f, -0.014725683f, -0.027812598f, -0.040894747f, -0.053969889f,
-0.067035784f, -0.080090192f, -0.093130877f, -0.10615561f, -0.11916214f,
-0.13214826f, -0.14511174f, -0.15805036f, -0.17096189f, -0.18384413f,
-0.19669487f, -0.20951190f, -0.22229304f, -0.23503609f, -0.24773886f,
-0.26039919f, -0.27301490f, -0.28558383f, -0.29810383f, -0.31057274f,
-0.32298845f, -0.33534881f, -0.34765171f, -0.35989504f, -0.37207670f,
-0.38419461f, -0.39624670f, -0.40823088f, -0.42014512f, -0.43198737f,
-0.44375560f, -0.45544780f, -0.46706195f, -0.47859608f, -0.49004821f,
-0.50141636f, -0.51269860f, -0.52389299f, -0.53499762f, -0.54601058f,
-0.55692998f, -0.56775395f, -0.57848064f, -0.58910822f, -0.59963485f,
-0.61005873f, -0.62037809f, -0.63059115f, -0.64069616f, -0.65069139f,
-0.66057513f, -0.67034568f, -0.68000137f, -0.68954054f, -0.69896157f,
-0.70826283f, -0.71744274f, -0.72649972f, -0.73543221f, -0.74423869f,
-0.75291765f, -0.76146760f, -0.76988708f, -0.77817464f, -0.78632887f,
-0.79434836f, -0.80223175f, -0.80997767f, -0.81758481f, -0.82505187f,
-0.83237755f, -0.83956061f, -0.84659981f, -0.85349396f, -0.86024186f,
-0.86684237f, -0.87329434f, -0.87959669f, -0.88574831f, -0.89174817f,
-0.89759523f, -0.90328850f, -0.90882699f, -0.91420976f, -0.91943588f,
-0.92450446f, -0.92941463f, -0.93416555f, -0.93875641f, -0.94318642f,
-0.94745482f, -0.95156087f, -0.95550388f, -0.95928317f, -0.96289809f,
-0.96634802f, -0.96963238f, -0.97275059f, -0.97570213f, -0.97848649f,
-0.98110318f, -0.98355177f, -0.98583184f, -0.98794298f, -0.98988485f,
-0.99165711f, -0.99325945f, -0.99469160f, -0.99595331f, -0.99704438f,
-0.99796460f, -0.99871383f, -0.99929194f, -0.99969882f, -0.99993441f,
0.99999465f, 0.99956631f, 0.99845292f, 0.99665524f, 0.99417450f,
0.99101241f, 0.98717112f, 0.98265328f, 0.97746197f, 0.97160077f,
0.96507367f, 0.95788516f, 0.95004017f, 0.94154407f, 0.93240267f,
0.92262226f, 0.91220953f, 0.90117161f, 0.88951608f, 0.87725091f,
0.86438452f, 0.85092573f, 0.83688375f, 0.82226822f, 0.80708914f,
0.79135693f, 0.77508236f, 0.75827658f, 0.74095113f, 0.72311786f,
0.70478900f, 0.68597711f, 0.66669509f, 0.64695615f, 0.62677382f,
0.60616193f, 0.58513461f, 0.56370626f, 0.54189158f, 0.51970551f,
0.49716327f, 0.47428029f, 0.45107226f, 0.42755509f, 0.40374490f,
0.37965800f, 0.35531090f, 0.33072029f, 0.30590302f, 0.28087610f,
0.25565668f, 0.23026205f, 0.20470960f, 0.17901686f, 0.15320143f,
0.12728100f, 0.10127334f, 0.075196277f, 0.049067674f, 0.022905443f,
-0.0032724865f, -0.029448173f, -0.055603678f, -0.081721074f, -0.10778246f,
-0.13376998f, -0.15966582f, -0.18545224f, -0.21111155f, -0.23662618f,
-0.26197864f, -0.28715155f, -0.31212766f, -0.33688985f, -0.36142116f,
-0.38570477f, -0.40972403f, -0.43346249f, -0.45690388f, -0.48003212f,
-0.50283138f, -0.52528602f, -0.54738066f, -0.56910015f, -0.59042960f,
-0.61135441f, -0.63186022f, -0.65193299f, -0.67155895f, -0.69072467f,
-0.70941699f, -0.72762312f, -0.74533057f, -0.76252720f, -0.77920124f,
-0.79534126f, -0.81093618f, -0.82597533f, -0.84044840f, -0.85434547f,
-0.86765701f, -0.88037390f, -0.89248743f, -0.90398929f, -0.91487161f,
-0.92512691f, -0.93474818f, -0.94372882f, -0.95206268f, -0.95974404f,
-0.96676764f, -0.97312866f, -0.97882275f, -0.98384601f, -0.98819498f,
-0.99186670f, -0.99485864f, -0.99716875f, -0.99879546f, -0.99973764f,
};
#endif

static const CELTMode mode48000_960_120 = {
48000,    /* Fs */
120,    /* overlap */
21,    /* nbEBands */
21,    /* effEBands */
{0.85000610f, 0.0000000f, 1.0000000f, 1.0000000f, },    /* preemph */
eband5ms,    /* eBands */
3,    /* maxLM */
8,    /* nbShortMdcts */
120,    /* shortMdctSize */
11,    /* nbAllocVectors */
band_allocation,    /* allocVectors */
logN400,    /* logN */
window120,    /* window */
{1920, 3, {&fft_state48000_960_0, &fft_state48000_960_1, &fft_state48000_960_2, &fft_state48000_960_3, }, mdct_twiddles960},    /* mdct */
{392, cache_index50, cache_bits50, cache_caps50},    /* cache */
#ifdef ENABLE_QEXT
{86, qext_cache_index50, qext_cache_bits50, qext_cache_caps50},    /* qext_cache */
#endif
};

#ifdef ENABLE_QEXT
#ifndef DEF_WINDOW240
#define DEF_WINDOW240
static const celt_coef window240[240] = {
1.6821922e-05f, 0.00015139297f, 0.00042051200f, 0.00082413284f, 0.0013621862f,
0.0020345793f, 0.0028411964f, 0.0037818978f, 0.0048565203f, 0.0060648765f,
0.0074067550f, 0.0088819198f, 0.010490110f, 0.012231040f, 0.014104398f,
0.016109846f, 0.018247021f, 0.020515533f, 0.022914963f, 0.025444867f,
0.028104770f, 0.030894170f, 0.033812535f, 0.036859304f, 0.040033885f,
0.043335654f, 0.046763958f, 0.050318110f, 0.053997389f, 0.057801044f,
0.061728287f, 0.065778297f, 0.069950217f, 0.074243155f, 0.078656182f,
0.083188331f, 0.087838600f, 0.092605946f, 0.097489289f, 0.10248751f,
0.10759945f, 0.11282390f, 0.11815964f, 0.12360536f, 0.12915977f,
0.13482147f, 0.14058908f, 0.14646113f, 0.15243614f, 0.15851256f,
0.16468882f, 0.17096330f, 0.17733432f, 0.18380017f, 0.19035910f,
0.19700930f, 0.20374894f, 0.21057612f, 0.21748892f, 0.22448537f,
0.23156343f, 0.23872106f, 0.24595615f, 0.25326656f, 0.26065010f,
0.26810455f, 0.27562763f, 0.28321704f, 0.29087045f, 0.29858546f,
0.30635965f, 0.31419058f, 0.32207574f, 0.33001263f, 0.33799866f,
0.34603127f, 0.35410783f, 0.36222570f, 0.37038219f, 0.37857460f,
0.38680022f, 0.39505629f, 0.40334003f, 0.41164867f, 0.41997939f,
0.42832937f, 0.43669576f, 0.44507572f, 0.45346639f, 0.46186489f,
0.47026835f, 0.47867389f, 0.48707862f, 0.49547965f, 0.50387411f,
0.51225912f, 0.52063179f, 0.52898927f, 0.53732871f, 0.54564725f,
0.55394208f, 0.56221039f, 0.57044938f, 0.57865628f, 0.58682836f,
0.59496289f, 0.60305718f, 0.61110858f, 0.61911445f, 0.62707221f,
0.63497931f, 0.64283322f, 0.65063147f, 0.65837163f, 0.66605132f,
0.67366820f, 0.68121999f, 0.68870444f, 0.69611937f, 0.70346266f,
0.71073222f, 0.71792606f, 0.72504220f, 0.73207877f, 0.73903393f,
0.74590592f, 0.75269303f, 0.75939364f, 0.76600617f, 0.77252915f,
0.77896113f, 0.78530077f, 0.79154678f, 0.79769796f, 0.80375317f,
0.80971135f, 0.81557152f, 0.82133276f, 0.82699424f, 0.83255520f,
0.83801496f, 0.84337291f, 0.84862851f, 0.85378132f, 0.85883095f,
0.86377710f, 0.86861954f, 0.87335813f, 0.87799277f, 0.88252347f,
0.88695029f, 0.89127338f, 0.89549294f, 0.89960926f, 0.90362268f,
0.90753364f, 0.91134262f, 0.91505017f, 0.91865692f, 0.92216354f,
0.92557078f, 0.92887945f, 0.93209042f, 0.93520460f, 0.93822298f,
0.94114659f, 0.94397652f, 0.94671390f, 0.94935993f, 0.95191584f,
0.95438290f, 0.95676245f, 0.95905584f, 0.96126449f, 0.96338982f,
0.96543334f, 0.96739653f, 0.96928096f, 0.97108818f, 0.97281981f,
0.97447746f, 0.97606279f, 0.97757746f, 0.97902317f, 0.98040162f,
0.98171453f, 0.98296363f, 0.98415067f, 0.98527740f, 0.98634557f,
0.98735696f, 0.98831332f, 0.98921643f, 0.99006803f, 0.99086991f,
0.99162380f, 0.99233145f, 0.99299461f, 0.99361500f, 0.99419433f,
0.99473429f, 0.99523657f, 0.99570284f, 0.99613472f, 0.99653384f,
0.99690180f, 0.99724017f, 0.99755048f, 0.99783426f, 0.99809299f,
0.99832812f, 0.99854108f, 0.99873324f, 0.99890597f, 0.99906057f,
0.99919832f, 0.99932046f, 0.99942819f, 0.99952266f, 0.99960498f,
0.99967623f, 0.99973742f, 0.99978953f, 0.99983351f, 0.99987023f,
0.99990053f, 0.99992520f, 0.99994498f, 0.99996055f, 0.99997257f,
0.99998161f, 0.99998821f, 0.99999285f, 0.99999596f, 0.99999793f,
0.99999907f, 0.99999966f, 0.99999991f, 0.99999999f, 1.0000000f,
};
#endif

#ifndef DEF_LOGN400
#define DEF_LOGN400
static const opus_int16 logN400[21] = {
0, 0, 0, 0, 0, 0, 0, 0, 8, 8, 8, 8, 16, 16, 16, 21, 21, 24, 29, 34, 36, };
#endif

#ifndef DEF_PULSE_CACHE50
#define DEF_PULSE_CACHE50
static const opus_int16 cache_index50[105] = {
-1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 41, 41, 41,
82, 82, 123, 164, 200, 222, 0, 0, 0, 0, 0, 0, 0, 0, 41,
41, 41, 41, 123, 123, 123, 164, 164, 240, 266, 283, 295, 41, 41, 41,
41, 41, 41, 41, 41, 123, 123, 123, 123, 240, 240, 240, 266, 266, 305,
318, 328, 336, 123, 123, 123, 123, 123, 123, 123, 123, 240, 240, 240, 240,
305, 305, 305, 318, 318, 343, 351, 358, 364, 240, 240, 240, 240, 240, 240,
240, 240, 305, 305, 305, 305, 343, 343, 343, 351, 351, 370, 376, 382, 387,
};
static const unsigned char cache_bits50[392] = {
40, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 40, 15, 23, 28,
31, 34, 36, 38, 39, 41, 42, 43, 44, 45, 46, 47, 47, 49, 50,
51, 52, 53, 54, 55, 55, 57, 58, 59, 60, 61, 62, 63, 63, 65,
66, 67, 68, 69, 70, 71, 71, 40, 20, 33, 41, 48, 53, 57, 61,
64, 66, 69, 71, 73, 75, 76, 78, 80, 82, 85, 87, 89, 91, 92,
94, 96, 98, 101, 103, 105, 107, 108, 110, 112, 114, 117, 119, 121, 123,
124, 126, 128, 40, 23, 39, 51, 60, 67, 73, 79, 83, 87, 91, 94,
97, 100, 102, 105, 107, 111, 115, 118, 121, 124, 126, 129, 131, 135, 139,
142, 145, 148, 150, 153, 155, 159, 163, 166, 169, 172, 174, 177, 179, 35,
28, 49, 65, 78, 89, 99, 107, 114, 120, 126, 132, 136, 141, 145, 149,
153, 159, 165, 171, 176, 180, 185, 189, 192, 199, 205, 211, 216, 220, 225,
229, 232, 239, 245, 251, 21, 33, 58, 79, 97, 112, 125, 137, 148, 157,
166, 174, 182, 189, 195, 201, 207, 217, 227, 235, 243, 251, 17, 35, 63,
86, 106, 123, 139, 152, 165, 177, 187, 197, 206, 214, 222, 230, 237, 250,
25, 31, 55, 75, 91, 105, 117, 128, 138, 146, 154, 161, 168, 174, 180,
185, 190, 200, 208, 215, 222, 229, 235, 240, 245, 255, 16, 36, 65, 89,
110, 128, 144, 159, 173, 185, 196, 207, 217, 226, 234, 242, 250, 11, 41,
74, 103, 128, 151, 172, 191, 209, 225, 241, 255, 9, 43, 79, 110, 138,
163, 186, 207, 227, 246, 12, 39, 71, 99, 123, 144, 164, 182, 198, 214,
228, 241, 253, 9, 44, 81, 113, 142, 168, 192, 214, 235, 255, 7, 49,
90, 127, 160, 191, 220, 247, 6, 51, 95, 134, 170, 203, 234, 7, 47,
87, 123, 155, 184, 212, 237, 6, 52, 97, 137, 174, 208, 240, 5, 57,
106, 151, 192, 231, 5, 59, 111, 158, 202, 243, 5, 55, 103, 147, 187,
224, 5, 60, 113, 161, 206, 248, 4, 65, 122, 175, 224, 4, 67, 127,
182, 234, };
static const unsigned char cache_caps50[168] = {
224, 224, 224, 224, 224, 224, 224, 224, 160, 160, 160, 160, 185, 185, 185,
178, 178, 168, 134, 61, 37, 224, 224, 224, 224, 224, 224, 224, 224, 240,
240, 240, 240, 207, 207, 207, 198, 198, 183, 144, 66, 40, 160, 160, 160,
160, 160, 160, 160, 160, 185, 185, 185, 185, 193, 193, 193, 183, 183, 172,
138, 64, 38, 240, 240, 240, 240, 240, 240, 240, 240, 207, 207, 207, 207,
204, 204, 204, 193, 193, 180, 143, 66, 40, 185, 185, 185, 185, 185, 185,
185, 185, 193, 193, 193, 193, 193, 193, 193, 183, 183, 172, 138, 65, 39,
207, 207, 207, 207, 207, 207, 207, 207, 204, 204, 204, 204, 201, 201, 201,
188, 188, 176, 141, 66, 40, 193, 193, 193, 193, 193, 193, 193, 193, 193,
193, 193, 193, 194, 194, 194, 184, 184, 173, 139, 65, 39, 204, 204, 204,
204, 204, 204, 204, 204, 201, 201, 201, 201, 198, 198, 198, 187, 187, 175,
140, 66, 40, };
#endif

#ifdef ENABLE_QEXT
# ifndef DEF_QEXT_PULSE_CACHE50
# define DEF_QEXT_PULSE_CACHE50
static const opus_int16 qext_cache_index50[70] = {
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 41,
41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 61, 61,
61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 72, 72, 72,
72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 80, 80, 80, 80,
80, 80, 80, 80, 80, 80, 80, 80, 80, 80, };
static const unsigned char qext_cache_bits50[86] = {
40, 26, 45, 59, 70, 79, 87, 94, 100, 105, 110, 114, 118, 122, 125,
128, 131, 136, 141, 146, 150, 153, 157, 160, 163, 168, 173, 178, 182, 185,
189, 192, 195, 200, 205, 210, 214, 217, 221, 224, 227, 19, 34, 61, 83,
101, 118, 132, 145, 157, 167, 177, 186, 194, 202, 209, 216, 222, 234, 245,
254, 10, 42, 77, 107, 133, 157, 179, 200, 219, 236, 253, 7, 50, 93,
131, 165, 197, 227, 255, 5, 58, 109, 155, 197, 237, };
static const unsigned char qext_cache_caps50[112] = {
159, 159, 159, 159, 159, 159, 159, 159, 159, 159, 159, 159, 159, 159, 171,
171, 171, 171, 171, 171, 171, 171, 171, 171, 171, 171, 171, 171, 163, 163,
163, 163, 163, 163, 163, 163, 163, 163, 163, 163, 163, 163, 167, 167, 167,
167, 167, 167, 167, 167, 167, 167, 167, 167, 167, 167, 163, 163, 163, 163,
163, 163, 163, 163, 163, 163, 163, 163, 163, 163, 166, 166, 166, 166, 166,
166, 166, 166, 166, 166, 166, 166, 166, 166, 163, 163, 163, 163, 163, 163,
163, 163, 163, 163, 163, 163, 163, 163, 165, 165, 165, 165, 165, 165, 165,
165, 165, 165, 165, 165, 165, 165, };
# endif
#endif

#ifndef FFT_TWIDDLES96000_1920
#define FFT_TWIDDLES96000_1920
static const kiss_twiddle_cpx fft_twiddles96000_1920[960] = {
{1.0000000f, -0.0000000f}, {0.99997858f, -0.0065449380f},
{0.99991433f, -0.013089596f}, {0.99980724f, -0.019633692f},
{0.99965732f, -0.026176948f}, {0.99946459f, -0.032719083f},
{0.99922904f, -0.039259816f}, {0.99895068f, -0.045798867f},
{0.99862953f, -0.052335956f}, {0.99826561f, -0.058870804f},
{0.99785892f, -0.065403129f}, {0.99740949f, -0.071932653f},
{0.99691733f, -0.078459096f}, {0.99638247f, -0.084982177f},
{0.99580493f, -0.091501619f}, {0.99518473f, -0.098017140f},
{0.99452190f, -0.10452846f}, {0.99381646f, -0.11103531f},
{0.99306846f, -0.11753740f}, {0.99227791f, -0.12403445f},
{0.99144486f, -0.13052619f}, {0.99056934f, -0.13701234f},
{0.98965139f, -0.14349262f}, {0.98869104f, -0.14996676f},
{0.98768834f, -0.15643447f}, {0.98664333f, -0.16289547f},
{0.98555606f, -0.16934950f}, {0.98442657f, -0.17579628f},
{0.98325491f, -0.18223553f}, {0.98204113f, -0.18866696f},
{0.98078528f, -0.19509032f}, {0.97948742f, -0.20150532f},
{0.97814760f, -0.20791169f}, {0.97676588f, -0.21430915f},
{0.97534232f, -0.22069744f}, {0.97387698f, -0.22707626f},
{0.97236992f, -0.23344536f}, {0.97082121f, -0.23980446f},
{0.96923091f, -0.24615329f}, {0.96759909f, -0.25249158f},
{0.96592583f, -0.25881905f}, {0.96421118f, -0.26513543f},
{0.96245524f, -0.27144045f}, {0.96065806f, -0.27773385f},
{0.95881973f, -0.28401534f}, {0.95694034f, -0.29028468f},
{0.95501994f, -0.29654157f}, {0.95305864f, -0.30278577f},
{0.95105652f, -0.30901699f}, {0.94901365f, -0.31523498f},
{0.94693013f, -0.32143947f}, {0.94480605f, -0.32763018f},
{0.94264149f, -0.33380686f}, {0.94043656f, -0.33996924f},
{0.93819134f, -0.34611706f}, {0.93590593f, -0.35225005f},
{0.93358043f, -0.35836795f}, {0.93121493f, -0.36447050f},
{0.92880955f, -0.37055744f}, {0.92636438f, -0.37662850f},
{0.92387953f, -0.38268343f}, {0.92135511f, -0.38872197f},
{0.91879121f, -0.39474386f}, {0.91618796f, -0.40074883f},
{0.91354546f, -0.40673664f}, {0.91086382f, -0.41270703f},
{0.90814317f, -0.41865974f}, {0.90538362f, -0.42459451f},
{0.90258528f, -0.43051110f}, {0.89974828f, -0.43640924f},
{0.89687274f, -0.44228869f}, {0.89395878f, -0.44814919f},
{0.89100652f, -0.45399050f}, {0.88801610f, -0.45981236f},
{0.88498764f, -0.46561452f}, {0.88192126f, -0.47139674f},
{0.87881711f, -0.47715876f}, {0.87567532f, -0.48290034f},
{0.87249601f, -0.48862124f}, {0.86927932f, -0.49432121f},
{0.86602540f, -0.50000000f}, {0.86273439f, -0.50565737f},
{0.85940641f, -0.51129309f}, {0.85604162f, -0.51690690f},
{0.85264016f, -0.52249856f}, {0.84920218f, -0.52806785f},
{0.84572782f, -0.53361452f}, {0.84221723f, -0.53913832f},
{0.83867057f, -0.54463904f}, {0.83508798f, -0.55011642f},
{0.83146961f, -0.55557023f}, {0.82781563f, -0.56100025f},
{0.82412619f, -0.56640624f}, {0.82040144f, -0.57178796f},
{0.81664156f, -0.57714519f}, {0.81284668f, -0.58247770f},
{0.80901699f, -0.58778525f}, {0.80515265f, -0.59306763f},
{0.80125381f, -0.59832460f}, {0.79732065f, -0.60355594f},
{0.79335334f, -0.60876143f}, {0.78935204f, -0.61394084f},
{0.78531693f, -0.61909395f}, {0.78124818f, -0.62422054f},
{0.77714596f, -0.62932039f}, {0.77301045f, -0.63439328f},
{0.76884183f, -0.63943900f}, {0.76464028f, -0.64445733f},
{0.76040597f, -0.64944805f}, {0.75613908f, -0.65441095f},
{0.75183981f, -0.65934582f}, {0.74750833f, -0.66425244f},
{0.74314483f, -0.66913061f}, {0.73874949f, -0.67398011f},
{0.73432251f, -0.67880075f}, {0.72986407f, -0.68359230f},
{0.72537437f, -0.68835458f}, {0.72085360f, -0.69308736f},
{0.71630194f, -0.69779046f}, {0.71171961f, -0.70246367f},
{0.70710678f, -0.70710678f}, {0.70246367f, -0.71171961f},
{0.69779046f, -0.71630194f}, {0.69308736f, -0.72085360f},
{0.68835458f, -0.72537437f}, {0.68359230f, -0.72986407f},
{0.67880075f, -0.73432251f}, {0.67398011f, -0.73874949f},
{0.66913061f, -0.74314483f}, {0.66425244f, -0.74750833f},
{0.65934582f, -0.75183981f}, {0.65441095f, -0.75613908f},
{0.64944805f, -0.76040597f}, {0.64445733f, -0.76464028f},
{0.63943900f, -0.76884183f}, {0.63439328f, -0.77301045f},
{0.62932039f, -0.77714596f}, {0.62422054f, -0.78124818f},
{0.61909395f, -0.78531693f}, {0.61394084f, -0.78935204f},
{0.60876143f, -0.79335334f}, {0.60355594f, -0.79732065f},
{0.59832460f, -0.80125381f}, {0.59306763f, -0.80515265f},
{0.58778525f, -0.80901699f}, {0.58247770f, -0.81284668f},
{0.57714519f, -0.81664156f}, {0.57178796f, -0.82040144f},
{0.56640624f, -0.82412619f}, {0.56100025f, -0.82781563f},
{0.55557023f, -0.83146961f}, {0.55011642f, -0.83508798f},
{0.54463904f, -0.83867057f}, {0.53913832f, -0.84221723f},
{0.53361452f, -0.84572782f}, {0.52806785f, -0.84920218f},
{0.52249856f, -0.85264016f}, {0.51690690f, -0.85604162f},
{0.51129309f, -0.85940641f}, {0.50565737f, -0.86273439f},
{0.50000000f, -0.86602540f}, {0.49432121f, -0.86927932f},
{0.48862124f, -0.87249601f}, {0.48290034f, -0.87567532f},
{0.47715876f, -0.87881711f}, {0.47139674f, -0.88192126f},
{0.46561452f, -0.88498764f}, {0.45981236f, -0.88801610f},
{0.45399050f, -0.89100652f}, {0.44814919f, -0.89395878f},
{0.44228869f, -0.89687274f}, {0.43640924f, -0.89974828f},
{0.43051110f, -0.90258528f}, {0.42459451f, -0.90538362f},
{0.41865974f, -0.90814317f}, {0.41270703f, -0.91086382f},
{0.40673664f, -0.91354546f}, {0.40074883f, -0.91618796f},
{0.39474386f, -0.91879121f}, {0.38872197f, -0.92135511f},
{0.38268343f, -0.92387953f}, {0.37662850f, -0.92636438f},
{0.37055744f, -0.92880955f}, {0.36447050f, -0.93121493f},
{0.35836795f, -0.93358043f}, {0.35225005f, -0.93590593f},
{0.34611706f, -0.93819134f}, {0.33996924f, -0.94043656f},
{0.33380686f, -0.94264149f}, {0.32763018f, -0.94480605f},
{0.32143947f, -0.94693013f}, {0.31523498f, -0.94901365f},
{0.30901699f, -0.95105652f}, {0.30278577f, -0.95305864f},
{0.29654157f, -0.95501994f}, {0.29028468f, -0.95694034f},
{0.28401534f, -0.95881973f}, {0.27773385f, -0.96065806f},
{0.27144045f, -0.96245524f}, {0.26513543f, -0.96421118f},
{0.25881905f, -0.96592583f}, {0.25249158f, -0.96759909f},
{0.24615329f, -0.96923091f}, {0.23980446f, -0.97082121f},
{0.23344536f, -0.97236992f}, {0.22707626f, -0.97387698f},
{0.22069744f, -0.97534232f}, {0.21430915f, -0.97676588f},
{0.20791169f, -0.97814760f}, {0.20150532f, -0.97948742f},
{0.19509032f, -0.98078528f}, {0.18866696f, -0.98204113f},
{0.18223553f, -0.98325491f}, {0.17579628f, -0.98442657f},
{0.16934950f, -0.98555606f}, {0.16289547f, -0.98664333f},
{0.15643447f, -0.98768834f}, {0.14996676f, -0.98869104f},
{0.14349262f, -0.98965139f}, {0.13701234f, -0.99056934f},
{0.13052619f, -0.99144486f}, {0.12403445f, -0.99227791f},
{0.11753740f, -0.99306846f}, {0.11103531f, -0.99381646f},
{0.10452846f, -0.99452190f}, {0.098017140f, -0.99518473f},
{0.091501619f, -0.99580493f}, {0.084982177f, -0.99638247f},
{0.078459096f, -0.99691733f}, {0.071932653f, -0.99740949f},
{0.065403129f, -0.99785892f}, {0.058870804f, -0.99826561f},
{0.052335956f, -0.99862953f}, {0.045798867f, -0.99895068f},
{0.039259816f, -0.99922904f}, {0.032719083f, -0.99946459f},
{0.026176948f, -0.99965732f}, {0.019633692f, -0.99980724f},
{0.013089596f, -0.99991433f}, {0.0065449380f, -0.99997858f},
{6.1232340e-17f, -1.0000000f}, {-0.0065449380f, -0.99997858f},
{-0.013089596f, -0.99991433f}, {-0.019633692f, -0.99980724f},
{-0.026176948f, -0.99965732f}, {-0.032719083f, -0.99946459f},
{-0.039259816f, -0.99922904f}, {-0.045798867f, -0.99895068f},
{-0.052335956f, -0.99862953f}, {-0.058870804f, -0.99826561f},
{-0.065403129f, -0.99785892f}, {-0.071932653f, -0.99740949f},
{-0.078459096f, -0.99691733f}, {-0.084982177f, -0.99638247f},
{-0.091501619f, -0.99580493f}, {-0.098017140f, -0.99518473f},
{-0.10452846f, -0.99452190f}, {-0.11103531f, -0.99381646f},
{-0.11753740f, -0.99306846f}, {-0.12403445f, -0.99227791f},
{-0.13052619f, -0.99144486f}, {-0.13701234f, -0.99056934f},
{-0.14349262f, -0.98965139f}, {-0.14996676f, -0.98869104f},
{-0.15643447f, -0.98768834f}, {-0.16289547f, -0.98664333f},
{-0.16934950f, -0.98555606f}, {-0.17579628f, -0.98442657f},
{-0.18223553f, -0.98325491f}, {-0.18866696f, -0.98204113f},
{-0.19509032f, -0.98078528f}, {-0.20150532f, -0.97948742f},
{-0.20791169f, -0.97814760f}, {-0.21430915f, -0.97676588f},
{-0.22069744f, -0.97534232f}, {-0.22707626f, -0.97387698f},
{-0.23344536f, -0.97236992f}, {-0.23980446f, -0.97082121f},
{-0.24615329f, -0.96923091f}, {-0.25249158f, -0.96759909f},
{-0.25881905f, -0.96592583f}, {-0.26513543f, -0.96421118f},
{-0.27144045f, -0.96245524f}, {-0.27773385f, -0.96065806f},
{-0.28401534f, -0.95881973f}, {-0.29028468f, -0.95694034f},
{-0.29654157f, -0.95501994f}, {-0.30278577f, -0.95305864f},
{-0.30901699f, -0.95105652f}, {-0.31523498f, -0.94901365f},
{-0.32143947f, -0.94693013f}, {-0.32763018f, -0.94480605f},
{-0.33380686f, -0.94264149f}, {-0.33996924f, -0.94043656f},
{-0.34611706f, -0.93819134f}, {-0.35225005f, -0.93590593f},
{-0.35836795f, -0.93358043f}, {-0.36447050f, -0.93121493f},
{-0.37055744f, -0.92880955f}, {-0.37662850f, -0.92636438f},
{-0.38268343f, -0.92387953f}, {-0.38872197f, -0.92135511f},
{-0.39474386f, -0.91879121f}, {-0.40074883f, -0.91618796f},
{-0.40673664f, -0.91354546f}, {-0.41270703f, -0.91086382f},
{-0.41865974f, -0.90814317f}, {-0.42459451f, -0.90538362f},
{-0.43051110f, -0.90258528f}, {-0.43640924f, -0.89974828f},
{-0.44228869f, -0.89687274f}, {-0.44814919f, -0.89395878f},
{-0.45399050f, -0.89100652f}, {-0.45981236f, -0.88801610f},
{-0.46561452f, -0.88498764f}, {-0.47139674f, -0.88192126f},
{-0.47715876f, -0.87881711f}, {-0.48290034f, -0.87567532f},
{-0.48862124f, -0.87249601f}, {-0.49432121f, -0.86927932f},
{-0.50000000f, -0.86602540f}, {-0.50565737f, -0.86273439f},
{-0.51129309f, -0.85940641f}, {-0.51690690f, -0.85604162f},
{-0.52249856f, -0.85264016f}, {-0.52806785f, -0.84920218f},
{-0.53361452f, -0.84572782f}, {-0.53913832f, -0.84221723f},
{-0.54463904f, -0.83867057f}, {-0.55011642f, -0.83508798f},
{-0.55557023f, -0.83146961f}, {-0.56100025f, -0.82781563f},
{-0.56640624f, -0.82412619f}, {-0.57178796f, -0.82040144f},
{-0.57714519f, -0.81664156f}, {-0.58247770f, -0.81284668f},
{-0.58778525f, -0.80901699f}, {-0.59306763f, -0.80515265f},
{-0.59832460f, -0.80125381f}, {-0.60355594f, -0.79732065f},
{-0.60876143f, -0.79335334f}, {-0.61394084f, -0.78935204f},
{-0.61909395f, -0.78531693f}, {-0.62422054f, -0.78124818f},
{-0.62932039f, -0.77714596f}, {-0.63439328f, -0.77301045f},
{-0.63943900f, -0.76884183f}, {-0.64445733f, -0.76464028f},
{-0.64944805f, -0.76040597f}, {-0.65441095f, -0.75613908f},
{-0.65934582f, -0.75183981f}, {-0.66425244f, -0.74750833f},
{-0.66913061f, -0.74314483f}, {-0.67398011f, -0.73874949f},
{-0.67880075f, -0.73432251f}, {-0.68359230f, -0.72986407f},
{-0.68835458f, -0.72537437f}, {-0.69308736f, -0.72085360f},
{-0.69779046f, -0.71630194f}, {-0.70246367f, -0.71171961f},
{-0.70710678f, -0.70710678f}, {-0.71171961f, -0.70246367f},
{-0.71630194f, -0.69779046f}, {-0.72085360f, -0.69308736f},
{-0.72537437f, -0.68835458f}, {-0.72986407f, -0.68359230f},
{-0.73432251f, -0.67880075f}, {-0.73874949f, -0.67398011f},
{-0.74314483f, -0.66913061f}, {-0.74750833f, -0.66425244f},
{-0.75183981f, -0.65934582f}, {-0.75613908f, -0.65441095f},
{-0.76040597f, -0.64944805f}, {-0.76464028f, -0.64445733f},
{-0.76884183f, -0.63943900f}, {-0.77301045f, -0.63439328f},
{-0.77714596f, -0.62932039f}, {-0.78124818f, -0.62422054f},
{-0.78531693f, -0.61909395f}, {-0.78935204f, -0.61394084f},
{-0.79335334f, -0.60876143f}, {-0.79732065f, -0.60355594f},
{-0.80125381f, -0.59832460f}, {-0.80515265f, -0.59306763f},
{-0.80901699f, -0.58778525f}, {-0.81284668f, -0.58247770f},
{-0.81664156f, -0.57714519f}, {-0.82040144f, -0.57178796f},
{-0.82412619f, -0.56640624f}, {-0.82781563f, -0.56100025f},
{-0.83146961f, -0.55557023f}, {-0.83508798f, -0.55011642f},
{-0.83867057f, -0.54463904f}, {-0.84221723f, -0.53913832f},
{-0.84572782f, -0.53361452f}, {-0.84920218f, -0.52806785f},
{-0.85264016f, -0.52249856f}, {-0.85604162f, -0.51690690f},
{-0.85940641f, -0.51129309f}, {-0.86273439f, -0.50565737f},
{-0.86602540f, -0.50000000f}, {-0.86927932f, -0.49432121f},
{-0.87249601f, -0.48862124f}, {-0.87567532f, -0.48290034f},
{-0.87881711f, -0.47715876f}, {-0.88192126f, -0.47139674f},
{-0.88498764f, -0.46561452f}, {-0.88801610f, -0.45981236f},
{-0.89100652f, -0.45399050f}, {-0.89395878f, -0.44814919f},
{-0.89687274f, -0.44228869f}, {-0.89974828f, -0.43640924f},
{-0.90258528f, -0.43051110f}, {-0.90538362f, -0.42459451f},
{-0.90814317f, -0.41865974f}, {-0.91086382f, -0.41270703f},
{-0.91354546f, -0.40673664f}, {-0.91618796f, -0.40074883f},
{-0.91879121f, -0.39474386f}, {-0.92135511f, -0.38872197f},
{-0.92387953f, -0.38268343f}, {-0.92636438f, -0.37662850f},
{-0.92880955f, -0.37055744f}, {-0.93121493f, -0.36447050f},
{-0.93358043f, -0.35836795f}, {-0.93590593f, -0.35225005f},
{-0.93819134f, -0.34611706f}, {-0.94043656f, -0.33996924f},
{-0.94264149f, -0.33380686f}, {-0.94480605f, -0.32763018f},
{-0.94693013f, -0.32143947f}, {-0.94901365f, -0.31523498f},
{-0.95105652f, -0.30901699f}, {-0.95305864f, -0.30278577f},
{-0.95501994f, -0.29654157f}, {-0.95694034f, -0.29028468f},
{-0.95881973f, -0.28401534f}, {-0.96065806f, -0.27773385f},
{-0.96245524f, -0.27144045f}, {-0.96421118f, -0.26513543f},
{-0.96592583f, -0.25881905f}, {-0.96759909f, -0.25249158f},
{-0.96923091f, -0.24615329f}, {-0.97082121f, -0.23980446f},
{-0.97236992f, -0.23344536f}, {-0.97387698f, -0.22707626f},
{-0.97534232f, -0.22069744f}, {-0.97676588f, -0.21430915f},
{-0.97814760f, -0.20791169f}, {-0.97948742f, -0.20150532f},
{-0.98078528f, -0.19509032f}, {-0.98204113f, -0.18866696f},
{-0.98325491f, -0.18223553f}, {-0.98442657f, -0.17579628f},
{-0.98555606f, -0.16934950f}, {-0.98664333f, -0.16289547f},
{-0.98768834f, -0.15643447f}, {-0.98869104f, -0.14996676f},
{-0.98965139f, -0.14349262f}, {-0.99056934f, -0.13701234f},
{-0.99144486f, -0.13052619f}, {-0.99227791f, -0.12403445f},
{-0.99306846f, -0.11753740f}, {-0.99381646f, -0.11103531f},
{-0.99452190f, -0.10452846f}, {-0.99518473f, -0.098017140f},
{-0.99580493f, -0.091501619f}, {-0.99638247f, -0.084982177f},
{-0.99691733f, -0.078459096f}, {-0.99740949f, -0.071932653f},
{-0.99785892f, -0.065403129f}, {-0.99826561f, -0.058870804f},
{-0.99862953f, -0.052335956f}, {-0.99895068f, -0.045798867f},
{-0.99922904f, -0.039259816f}, {-0.99946459f, -0.032719083f},
{-0.99965732f, -0.026176948f}, {-0.99980724f, -0.019633692f},
{-0.99991433f, -0.013089596f}, {-0.99997858f, -0.0065449380f},
{-1.0000000f, -1.2246468e-16f}, {-0.99997858f, 0.0065449380f},
{-0.99991433f, 0.013089596f}, {-0.99980724f, 0.019633692f},
{-0.99965732f, 0.026176948f}, {-0.99946459f, 0.032719083f},
{-0.99922904f, 0.039259816f}, {-0.99895068f, 0.045798867f},
{-0.99862953f, 0.052335956f}, {-0.99826561f, 0.058870804f},
{-0.99785892f, 0.065403129f}, {-0.99740949f, 0.071932653f},
{-0.99691733f, 0.078459096f}, {-0.99638247f, 0.084982177f},
{-0.99580493f, 0.091501619f}, {-0.99518473f, 0.098017140f},
{-0.99452190f, 0.10452846f}, {-0.99381646f, 0.11103531f},
{-0.99306846f, 0.11753740f}, {-0.99227791f, 0.12403445f},
{-0.99144486f, 0.13052619f}, {-0.99056934f, 0.13701234f},
{-0.98965139f, 0.14349262f}, {-0.98869104f, 0.14996676f},
{-0.98768834f, 0.15643447f}, {-0.98664333f, 0.16289547f},
{-0.98555606f, 0.16934950f}, {-0.98442657f, 0.17579628f},
{-0.98325491f, 0.18223553f}, {-0.98204113f, 0.18866696f},
{-0.98078528f, 0.19509032f}, {-0.97948742f, 0.20150532f},
{-0.97814760f, 0.20791169f}, {-0.97676588f, 0.21430915f},
{-0.97534232f, 0.22069744f}, {-0.97387698f, 0.22707626f},
{-0.97236992f, 0.23344536f}, {-0.97082121f, 0.23980446f},
{-0.96923091f, 0.24615329f}, {-0.96759909f, 0.25249158f},
{-0.96592583f, 0.25881905f}, {-0.96421118f, 0.26513543f},
{-0.96245524f, 0.27144045f}, {-0.96065806f, 0.27773385f},
{-0.95881973f, 0.28401534f}, {-0.95694034f, 0.29028468f},
{-0.95501994f, 0.29654157f}, {-0.95305864f, 0.30278577f},
{-0.95105652f, 0.30901699f}, {-0.94901365f, 0.31523498f},
{-0.94693013f, 0.32143947f}, {-0.94480605f, 0.32763018f},
{-0.94264149f, 0.33380686f}, {-0.94043656f, 0.33996924f},
{-0.93819134f, 0.34611706f}, {-0.93590593f, 0.35225005f},
{-0.93358043f, 0.35836795f}, {-0.93121493f, 0.36447050f},
{-0.92880955f, 0.37055744f}, {-0.92636438f, 0.37662850f},
{-0.92387953f, 0.38268343f}, {-0.92135511f, 0.38872197f},
{-0.91879121f, 0.39474386f}, {-0.91618796f, 0.40074883f},
{-0.91354546f, 0.40673664f}, {-0.91086382f, 0.41270703f},
{-0.90814317f, 0.41865974f}, {-0.90538362f, 0.42459451f},
{-0.90258528f, 0.43051110f}, {-0.89974828f, 0.43640924f},
{-0.89687274f, 0.44228869f}, {-0.89395878f, 0.44814919f},
{-0.89100652f, 0.45399050f}, {-0.88801610f, 0.45981236f},
{-0.88498764f, 0.46561452f}, {-0.88192126f, 0.47139674f},
{-0.87881711f, 0.47715876f}, {-0.87567532f, 0.48290034f},
{-0.87249601f, 0.48862124f}, {-0.86927932f, 0.49432121f},
{-0.86602540f, 0.50000000f}, {-0.86273439f, 0.50565737f},
{-0.85940641f, 0.51129309f}, {-0.85604162f, 0.51690690f},
{-0.85264016f, 0.52249856f}, {-0.84920218f, 0.52806785f},
{-0.84572782f, 0.53361452f}, {-0.84221723f, 0.53913832f},
{-0.83867057f, 0.54463904f}, {-0.83508798f, 0.55011642f},
{-0.83146961f, 0.55557023f}, {-0.82781563f, 0.56100025f},
{-0.82412619f, 0.56640624f}, {-0.82040144f, 0.57178796f},
{-0.81664156f, 0.57714519f}, {-0.81284668f, 0.58247770f},
{-0.80901699f, 0.58778525f}, {-0.80515265f, 0.59306763f},
{-0.80125381f, 0.59832460f}, {-0.79732065f, 0.60355594f},
{-0.79335334f, 0.60876143f}, {-0.78935204f, 0.61394084f},
{-0.78531693f, 0.61909395f}, {-0.78124818f, 0.62422054f},
{-0.77714596f, 0.62932039f}, {-0.77301045f, 0.63439328f},
{-0.76884183f, 0.63943900f}, {-0.76464028f, 0.64445733f},
{-0.76040597f, 0.64944805f}, {-0.75613908f, 0.65441095f},
{-0.75183981f, 0.65934582f}, {-0.74750833f, 0.66425244f},
{-0.74314483f, 0.66913061f}, {-0.73874949f, 0.67398011f},
{-0.73432251f, 0.67880075f}, {-0.72986407f, 0.68359230f},
{-0.72537437f, 0.68835458f}, {-0.72085360f, 0.69308736f},
{-0.71630194f, 0.69779046f}, {-0.71171961f, 0.70246367f},
{-0.70710678f, 0.70710678f}, {-0.70246367f, 0.71171961f},
{-0.69779046f, 0.71630194f}, {-0.69308736f, 0.72085360f},
{-0.68835458f, 0.72537437f}, {-0.68359230f, 0.72986407f},
{-0.67880075f, 0.73432251f}, {-0.67398011f, 0.73874949f},
{-0.66913061f, 0.74314483f}, {-0.66425244f, 0.74750833f},
{-0.65934582f, 0.75183981f}, {-0.65441095f, 0.75613908f},
{-0.64944805f, 0.76040597f}, {-0.64445733f, 0.76464028f},
{-0.63943900f, 0.76884183f}, {-0.63439328f, 0.77301045f},
{-0.62932039f, 0.77714596f}, {-0.62422054f, 0.78124818f},
{-0.61909395f, 0.78531693f}, {-0.61394084f, 0.78935204f},
{-0.60876143f, 0.79335334f}, {-0.60355594f, 0.79732065f},
{-0.59832460f, 0.80125381f}, {-0.59306763f, 0.80515265f},
{-0.58778525f, 0.80901699f}, {-0.58247770f, 0.81284668f},
{-0.57714519f, 0.81664156f}, {-0.57178796f, 0.82040144f},
{-0.56640624f, 0.82412619f}, {-0.56100025f, 0.82781563f},
{-0.55557023f, 0.83146961f}, {-0.55011642f, 0.83508798f},
{-0.54463904f, 0.83867057f}, {-0.53913832f, 0.84221723f},
{-0.53361452f, 0.84572782f}, {-0.52806785f, 0.84920218f},
{-0.52249856f, 0.85264016f}, {-0.51690690f, 0.85604162f},
{-0.51129309f, 0.85940641f}, {-0.50565737f, 0.86273439f},
{-0.50000000f, 0.86602540f}, {-0.49432121f, 0.86927932f},
{-0.48862124f, 0.87249601f}, {-0.48290034f, 0.87567532f},
{-0.47715876f, 0.87881711f}, {-0.47139674f, 0.88192126f},
{-0.46561452f, 0.88498764f}, {-0.45981236f, 0.88801610f},
{-0.45399050f, 0.89100652f}, {-0.44814919f, 0.89395878f},
{-0.44228869f, 0.89687274f}, {-0.43640924f, 0.89974828f},
{-0.43051110f, 0.90258528f}, {-0.42459451f, 0.90538362f},
{-0.41865974f, 0.90814317f}, {-0.41270703f, 0.91086382f},
{-0.40673664f, 0.91354546f}, {-0.40074883f, 0.91618796f},
{-0.39474386f, 0.91879121f}, {-0.38872197f, 0.92135511f},
{-0.38268343f, 0.92387953f}, {-0.37662850f, 0.92636438f},
{-0.37055744f, 0.92880955f}, {-0.36447050f, 0.93121493f},
{-0.35836795f, 0.93358043f}, {-0.35225005f, 0.93590593f},
{-0.34611706f, 0.93819134f}, {-0.33996924f, 0.94043656f},
{-0.33380686f, 0.94264149f}, {-0.32763018f, 0.94480605f},
{-0.32143947f, 0.94693013f}, {-0.31523498f, 0.94901365f},
{-0.30901699f, 0.95105652f}, {-0.30278577f, 0.95305864f},
{-0.29654157f, 0.95501994f}, {-0.29028468f, 0.95694034f},
{-0.28401534f, 0.95881973f}, {-0.27773385f, 0.96065806f},
{-0.27144045f, 0.96245524f}, {-0.26513543f, 0.96421118f},
{-0.25881905f, 0.96592583f}, {-0.25249158f, 0.96759909f},
{-0.24615329f, 0.96923091f}, {-0.23980446f, 0.97082121f},
{-0.23344536f, 0.97236992f}, {-0.22707626f, 0.97387698f},
{-0.22069744f, 0.97534232f}, {-0.21430915f, 0.97676588f},
{-0.20791169f, 0.97814760f}, {-0.20150532f, 0.97948742f},
{-0.19509032f, 0.98078528f}, {-0.18866696f, 0.98204113f},
{-0.18223553f, 0.98325491f}, {-0.17579628f, 0.98442657f},
{-0.16934950f, 0.98555606f}, {-0.16289547f, 0.98664333f},
{-0.15643447f, 0.98768834f}, {-0.14996676f, 0.98869104f},
{-0.14349262f, 0.98965139f}, {-0.13701234f, 0.99056934f},
{-0.13052619f, 0.99144486f}, {-0.12403445f, 0.99227791f},
{-0.11753740f, 0.99306846f}, {-0.11103531f, 0.99381646f},
{-0.10452846f, 0.99452190f}, {-0.098017140f, 0.99518473f},
{-0.091501619f, 0.99580493f}, {-0.084982177f, 0.99638247f},
{-0.078459096f, 0.99691733f}, {-0.071932653f, 0.99740949f},
{-0.065403129f, 0.99785892f}, {-0.058870804f, 0.99826561f},
{-0.052335956f, 0.99862953f}, {-0.045798867f, 0.99895068f},
{-0.039259816f, 0.99922904f}, {-0.032719083f, 0.99946459f},
{-0.026176948f, 0.99965732f}, {-0.019633692f, 0.99980724f},
{-0.013089596f, 0.99991433f}, {-0.0065449380f, 0.99997858f},
{-1.8369702e-16f, 1.0000000f}, {0.0065449380f, 0.99997858f},
{0.013089596f, 0.99991433f}, {0.019633692f, 0.99980724f},
{0.026176948f, 0.99965732f}, {0.032719083f, 0.99946459f},
{0.039259816f, 0.99922904f}, {0.045798867f, 0.99895068f},
{0.052335956f, 0.99862953f}, {0.058870804f, 0.99826561f},
{0.065403129f, 0.99785892f}, {0.071932653f, 0.99740949f},
{0.078459096f, 0.99691733f}, {0.084982177f, 0.99638247f},
{0.091501619f, 0.99580493f}, {0.098017140f, 0.99518473f},
{0.10452846f, 0.99452190f}, {0.11103531f, 0.99381646f},
{0.11753740f, 0.99306846f}, {0.12403445f, 0.99227791f},
{0.13052619f, 0.99144486f}, {0.13701234f, 0.99056934f},
{0.14349262f, 0.98965139f}, {0.14996676f, 0.98869104f},
{0.15643447f, 0.98768834f}, {0.16289547f, 0.98664333f},
{0.16934950f, 0.98555606f}, {0.17579628f, 0.98442657f},
{0.18223553f, 0.98325491f}, {0.18866696f, 0.98204113f},
{0.19509032f, 0.98078528f}, {0.20150532f, 0.97948742f},
{0.20791169f, 0.97814760f}, {0.21430915f, 0.97676588f},
{0.22069744f, 0.97534232f}, {0.22707626f, 0.97387698f},
{0.23344536f, 0.97236992f}, {0.23980446f, 0.97082121f},
{0.24615329f, 0.96923091f}, {0.25249158f, 0.96759909f},
{0.25881905f, 0.96592583f}, {0.26513543f, 0.96421118f},
{0.27144045f, 0.96245524f}, {0.27773385f, 0.96065806f},
{0.28401534f, 0.95881973f}, {0.29028468f, 0.95694034f},
{0.29654157f, 0.95501994f}, {0.30278577f, 0.95305864f},
{0.30901699f, 0.95105652f}, {0.31523498f, 0.94901365f},
{0.32143947f, 0.94693013f}, {0.32763018f, 0.94480605f},
{0.33380686f, 0.94264149f}, {0.33996924f, 0.94043656f},
{0.34611706f, 0.93819134f}, {0.35225005f, 0.93590593f},
{0.35836795f, 0.93358043f}, {0.36447050f, 0.93121493f},
{0.37055744f, 0.92880955f}, {0.37662850f, 0.92636438f},
{0.38268343f, 0.92387953f}, {0.38872197f, 0.92135511f},
{0.39474386f, 0.91879121f}, {0.40074883f, 0.91618796f},
{0.40673664f, 0.91354546f}, {0.41270703f, 0.91086382f},
{0.41865974f, 0.90814317f}, {0.42459451f, 0.90538362f},
{0.43051110f, 0.90258528f}, {0.43640924f, 0.89974828f},
{0.44228869f, 0.89687274f}, {0.44814919f, 0.89395878f},
{0.45399050f, 0.89100652f}, {0.45981236f, 0.88801610f},
{0.46561452f, 0.88498764f}, {0.47139674f, 0.88192126f},
{0.47715876f, 0.87881711f}, {0.48290034f, 0.87567532f},
{0.48862124f, 0.87249601f}, {0.49432121f, 0.86927932f},
{0.50000000f, 0.86602540f}, {0.50565737f, 0.86273439f},
{0.51129309f, 0.85940641f}, {0.51690690f, 0.85604162f},
{0.52249856f, 0.85264016f}, {0.52806785f, 0.84920218f},
{0.53361452f, 0.84572782f}, {0.53913832f, 0.84221723f},
{0.54463904f, 0.83867057f}, {0.55011642f, 0.83508798f},
{0.55557023f, 0.83146961f}, {0.56100025f, 0.82781563f},
{0.56640624f, 0.82412619f}, {0.57178796f, 0.82040144f},
{0.57714519f, 0.81664156f}, {0.58247770f, 0.81284668f},
{0.58778525f, 0.80901699f}, {0.59306763f, 0.80515265f},
{0.59832460f, 0.80125381f}, {0.60355594f, 0.79732065f},
{0.60876143f, 0.79335334f}, {0.61394084f, 0.78935204f},
{0.61909395f, 0.78531693f}, {0.62422054f, 0.78124818f},
{0.62932039f, 0.77714596f}, {0.63439328f, 0.77301045f},
{0.63943900f, 0.76884183f}, {0.64445733f, 0.76464028f},
{0.64944805f, 0.76040597f}, {0.65441095f, 0.75613908f},
{0.65934582f, 0.75183981f}, {0.66425244f, 0.74750833f},
{0.66913061f, 0.74314483f}, {0.67398011f, 0.73874949f},
{0.67880075f, 0.73432251f}, {0.68359230f, 0.72986407f},
{0.68835458f, 0.72537437f}, {0.69308736f, 0.72085360f},
{0.69779046f, 0.71630194f}, {0.70246367f, 0.71171961f},
{0.70710678f, 0.70710678f}, {0.71171961f, 0.70246367f},
{0.71630194f, 0.69779046f}, {0.72085360f, 0.69308736f},
{0.72537437f, 0.68835458f}, {0.72986407f, 0.68359230f},
{0.73432251f, 0.67880075f}, {0.73874949f, 0.67398011f},
{0.74314483f, 0.66913061f}, {0.74750833f, 0.66425244f},
{0.75183981f, 0.65934582f}, {0.75613908f, 0.65441095f},
{0.76040597f, 0.64944805f}, {0.76464028f, 0.64445733f},
{0.76884183f, 0.63943900f}, {0.77301045f, 0.63439328f},
{0.77714596f, 0.62932039f}, {0.78124818f, 0.62422054f},
{0.78531693f, 0.61909395f}, {0.78935204f, 0.61394084f},
{0.79335334f, 0.60876143f}, {0.79732065f, 0.60355594f},
{0.80125381f, 0.59832460f}, {0.80515265f, 0.59306763f},
{0.80901699f, 0.58778525f}, {0.81284668f, 0.58247770f},
{0.81664156f, 0.57714519f}, {0.82040144f, 0.57178796f},
{0.82412619f, 0.56640624f}, {0.82781563f, 0.56100025f},
{0.83146961f, 0.55557023f}, {0.83508798f, 0.55011642f},
{0.83867057f, 0.54463904f}, {0.84221723f, 0.53913832f},
{0.84572782f, 0.53361452f}, {0.84920218f, 0.52806785f},
{0.85264016f, 0.52249856f}, {0.85604162f, 0.51690690f},
{0.85940641f, 0.51129309f}, {0.86273439f, 0.50565737f},
{0.86602540f, 0.50000000f}, {0.86927932f, 0.49432121f},
{0.87249601f, 0.48862124f}, {0.87567532f, 0.48290034f},
{0.87881711f, 0.47715876f}, {0.88192126f, 0.47139674f},
{0.88498764f, 0.46561452f}, {0.88801610f, 0.45981236f},
{0.89100652f, 0.45399050f}, {0.89395878f, 0.44814919f},
{0.89687274f, 0.44228869f}, {0.89974828f, 0.43640924f},
{0.90258528f, 0.43051110f}, {0.90538362f, 0.42459451f},
{0.90814317f, 0.41865974f}, {0.91086382f, 0.41270703f},
{0.91354546f, 0.40673664f}, {0.91618796f, 0.40074883f},
{0.91879121f, 0.39474386f}, {0.92135511f, 0.38872197f},
{0.92387953f, 0.38268343f}, {0.92636438f, 0.37662850f},
{0.92880955f, 0.37055744f}, {0.93121493f, 0.36447050f},
{0.93358043f, 0.35836795f}, {0.93590593f, 0.35225005f},
{0.93819134f, 0.34611706f}, {0.94043656f, 0.33996924f},
{0.94264149f, 0.33380686f}, {0.94480605f, 0.32763018f},
{0.94693013f, 0.32143947f}, {0.94901365f, 0.31523498f},
{0.95105652f, 0.30901699f}, {0.95305864f, 0.30278577f},
{0.95501994f, 0.29654157f}, {0.95694034f, 0.29028468f},
{0.95881973f, 0.28401534f}, {0.96065806f, 0.27773385f},
{0.96245524f, 0.27144045f}, {0.96421118f, 0.26513543f},
{0.96592583f, 0.25881905f}, {0.96759909f, 0.25249158f},
{0.96923091f, 0.24615329f}, {0.97082121f, 0.23980446f},
{0.97236992f, 0.23344536f}, {0.97387698f, 0.22707626f},
{0.97534232f, 0.22069744f}, {0.97676588f, 0.21430915f},
{0.97814760f, 0.20791169f}, {0.97948742f, 0.20150532f},
{0.98078528f, 0.19509032f}, {0.98204113f, 0.18866696f},
{0.98325491f, 0.18223553f}, {0.98442657f, 0.17579628f},
{0.98555606f, 0.16934950f}, {0.98664333f, 0.16289547f},
{0.98768834f, 0.15643447f}, {0.98869104f, 0.14996676f},
{0.98965139f, 0.14349262f}, {0.99056934f, 0.13701234f},
{0.99144486f, 0.13052619f}, {0.99227791f, 0.12403445f},
{0.99306846f, 0.11753740f}, {0.99381646f, 0.11103531f},
{0.99452190f, 0.10452846f}, {0.99518473f, 0.098017140f},
{0.99580493f, 0.091501619f}, {0.99638247f, 0.084982177f},
{0.99691733f, 0.078459096f}, {0.99740949f, 0.071932653f},
{0.99785892f, 0.065403129f}, {0.99826561f, 0.058870804f},
{0.99862953f, 0.052335956f}, {0.99895068f, 0.045798867f},
{0.99922904f, 0.039259816f}, {0.99946459f, 0.032719083f},
{0.99965732f, 0.026176948f}, {0.99980724f, 0.019633692f},
{0.99991433f, 0.013089596f}, {0.99997858f, 0.0065449380f},
};
#ifndef FFT_BITREV960
#define FFT_BITREV960
static const opus_int16 fft_bitrev960[960] = {
0, 192, 384, 576, 768, 64, 256, 448, 640, 832, 128, 320, 512, 704, 896,
16, 208, 400, 592, 784, 80, 272, 464, 656, 848, 144, 336, 528, 720, 912,
32, 224, 416, 608, 800, 96, 288, 480, 672, 864, 160, 352, 544, 736, 928,
48, 240, 432, 624, 816, 112, 304, 496, 688, 880, 176, 368, 560, 752, 944,
4, 196, 388, 580, 772, 68, 260, 452, 644, 836, 132, 324, 516, 708, 900,
20, 212, 404, 596, 788, 84, 276, 468, 660, 852, 148, 340, 532, 724, 916,
36, 228, 420, 612, 804, 100, 292, 484, 676, 868, 164, 356, 548, 740, 932,
52, 244, 436, 628, 820, 116, 308, 500, 692, 884, 180, 372, 564, 756, 948,
8, 200, 392, 584, 776, 72, 264, 456, 648, 840, 136, 328, 520, 712, 904,
24, 216, 408, 600, 792, 88, 280, 472, 664, 856, 152, 344, 536, 728, 920,
40, 232, 424, 616, 808, 104, 296, 488, 680, 872, 168, 360, 552, 744, 936,
56, 248, 440, 632, 824, 120, 312, 504, 696, 888, 184, 376, 568, 760, 952,
12, 204, 396, 588, 780, 76, 268, 460, 652, 844, 140, 332, 524, 716, 908,
28, 220, 412, 604, 796, 92, 284, 476, 668, 860, 156, 348, 540, 732, 924,
44, 236, 428, 620, 812, 108, 300, 492, 684, 876, 172, 364, 556, 748, 940,
60, 252, 444, 636, 828, 124, 316, 508, 700, 892, 188, 380, 572, 764, 956,
1, 193, 385, 577, 769, 65, 257, 449, 641, 833, 129, 321, 513, 705, 897,
17, 209, 401, 593, 785, 81, 273, 465, 657, 849, 145, 337, 529, 721, 913,
33, 225, 417, 609, 801, 97, 289, 481, 673, 865, 161, 353, 545, 737, 929,
49, 241, 433, 625, 817, 113, 305, 497, 689, 881, 177, 369, 561, 753, 945,
5, 197, 389, 581, 773, 69, 261, 453, 645, 837, 133, 325, 517, 709, 901,
21, 213, 405, 597, 789, 85, 277, 469, 661, 853, 149, 341, 533, 725, 917,
37, 229, 421, 613, 805, 101, 293, 485, 677, 869, 165, 357, 549, 741, 933,
53, 245, 437, 629, 821, 117, 309, 501, 693, 885, 181, 373, 565, 757, 949,
9, 201, 393, 585, 777, 73, 265, 457, 649, 841, 137, 329, 521, 713, 905,
25, 217, 409, 601, 793, 89, 281, 473, 665, 857, 153, 345, 537, 729, 921,
41, 233, 425, 617, 809, 105, 297, 489, 681, 873, 169, 361, 553, 745, 937,
57, 249, 441, 633, 825, 121, 313, 505, 697, 889, 185, 377, 569, 761, 953,
13, 205, 397, 589, 781, 77, 269, 461, 653, 845, 141, 333, 525, 717, 909,
29, 221, 413, 605, 797, 93, 285, 477, 669, 861, 157, 349, 541, 733, 925,
45, 237, 429, 621, 813, 109, 301, 493, 685, 877, 173, 365, 557, 749, 941,
61, 253, 445, 637, 829, 125, 317, 509, 701, 893, 189, 381, 573, 765, 957,
2, 194, 386, 578, 770, 66, 258, 450, 642, 834, 130, 322, 514, 706, 898,
18, 210, 402, 594, 786, 82, 274, 466, 658, 850, 146, 338, 530, 722, 914,
34, 226, 418, 610, 802, 98, 290, 482, 674, 866, 162, 354, 546, 738, 930,
50, 242, 434, 626, 818, 114, 306, 498, 690, 882, 178, 370, 562, 754, 946,
6, 198, 390, 582, 774, 70, 262, 454, 646, 838, 134, 326, 518, 710, 902,
22, 214, 406, 598, 790, 86, 278, 470, 662, 854, 150, 342, 534, 726, 918,
38, 230, 422, 614, 806, 102, 294, 486, 678, 870, 166, 358, 550, 742, 934,
54, 246, 438, 630, 822, 118, 310, 502, 694, 886, 182, 374, 566, 758, 950,
10, 202, 394, 586, 778, 74, 266, 458, 650, 842, 138, 330, 522, 714, 906,
26, 218, 410, 602, 794, 90, 282, 474, 666, 858, 154, 346, 538, 730, 922,
42, 234, 426, 618, 810, 106, 298, 490, 682, 874, 170, 362, 554, 746, 938,
58, 250, 442, 634, 826, 122, 314, 506, 698, 890, 186, 378, 570, 762, 954,
14, 206, 398, 590, 782, 78, 270, 462, 654, 846, 142, 334, 526, 718, 910,
30, 222, 414, 606, 798, 94, 286, 478, 670, 862, 158, 350, 542, 734, 926,
46, 238, 430, 622, 814, 110, 302, 494, 686, 878, 174, 366, 558, 750, 942,
62, 254, 446, 638, 830, 126, 318, 510, 702, 894, 190, 382, 574, 766, 958,
3, 195, 387, 579, 771, 67, 259, 451, 643, 835, 131, 323, 515, 707, 899,
19, 211, 403, 595, 787, 83, 275, 467, 659, 851, 147, 339, 531, 723, 915,
35, 227, 419, 611, 803, 99, 291, 483, 675, 867, 163, 355, 547, 739, 931,
51, 243, 435, 627, 819, 115, 307, 499, 691, 883, 179, 371, 563, 755, 947,
7, 199, 391, 583, 775, 71, 263, 455, 647, 839, 135, 327, 519, 711, 903,
23, 215, 407, 599, 791, 87, 279, 471, 663, 855, 151, 343, 535, 727, 919,
39, 231, 423, 615, 807, 103, 295, 487, 679, 871, 167, 359, 551, 743, 935,
55, 247, 439, 631, 823, 119, 311, 503, 695, 887, 183, 375, 567, 759, 951,
11, 203, 395, 587, 779, 75, 267, 459, 651, 843, 139, 331, 523, 715, 907,
27, 219, 411, 603, 795, 91, 283, 475, 667, 859, 155, 347, 539, 731, 923,
43, 235, 427, 619, 811, 107, 299, 491, 683, 875, 171, 363, 555, 747, 939,
59, 251, 443, 635, 827, 123, 315, 507, 699, 891, 187, 379, 571, 763, 955,
15, 207, 399, 591, 783, 79, 271, 463, 655, 847, 143, 335, 527, 719, 911,
31, 223, 415, 607, 799, 95, 287, 479, 671, 863, 159, 351, 543, 735, 927,
47, 239, 431, 623, 815, 111, 303, 495, 687, 879, 175, 367, 559, 751, 943,
63, 255, 447, 639, 831, 127, 319, 511, 703, 895, 191, 383, 575, 767, 959,
};
#endif

#ifndef FFT_BITREV480
#define FFT_BITREV480
static const opus_int16 fft_bitrev480[480] = {
0, 96, 192, 288, 384, 32, 128, 224, 320, 416, 64, 160, 256, 352, 448,
8, 104, 200, 296, 392, 40, 136, 232, 328, 424, 72, 168, 264, 360, 456,
16, 112, 208, 304, 400, 48, 144, 240, 336, 432, 80, 176, 272, 368, 464,
24, 120, 216, 312, 408, 56, 152, 248, 344, 440, 88, 184, 280, 376, 472,
4, 100, 196, 292, 388, 36, 132, 228, 324, 420, 68, 164, 260, 356, 452,
12, 108, 204, 300, 396, 44, 140, 236, 332, 428, 76, 172, 268, 364, 460,
20, 116, 212, 308, 404, 52, 148, 244, 340, 436, 84, 180, 276, 372, 468,
28, 124, 220, 316, 412, 60, 156, 252, 348, 444, 92, 188, 284, 380, 476,
1, 97, 193, 289, 385, 33, 129, 225, 321, 417, 65, 161, 257, 353, 449,
9, 105, 201, 297, 393, 41, 137, 233, 329, 425, 73, 169, 265, 361, 457,
17, 113, 209, 305, 401, 49, 145, 241, 337, 433, 81, 177, 273, 369, 465,
25, 121, 217, 313, 409, 57, 153, 249, 345, 441, 89, 185, 281, 377, 473,
5, 101, 197, 293, 389, 37, 133, 229, 325, 421, 69, 165, 261, 357, 453,
13, 109, 205, 301, 397, 45, 141, 237, 333, 429, 77, 173, 269, 365, 461,
21, 117, 213, 309, 405, 53, 149, 245, 341, 437, 85, 181, 277, 373, 469,
29, 125, 221, 317, 413, 61, 157, 253, 349, 445, 93, 189, 285, 381, 477,
2, 98, 194, 290, 386, 34, 130, 226, 322, 418, 66, 162, 258, 354, 450,
10, 106, 202, 298, 394, 42, 138, 234, 330, 426, 74, 170, 266, 362, 458,
18, 114, 210, 306, 402, 50, 146, 242, 338, 434, 82, 178, 274, 370, 466,
26, 122, 218, 314, 410, 58, 154, 250, 346, 442, 90, 186, 282, 378, 474,
6, 102, 198, 294, 390, 38, 134, 230, 326, 422, 70, 166, 262, 358, 454,
14, 110, 206, 302, 398, 46, 142, 238, 334, 430, 78, 174, 270, 366, 462,
22, 118, 214, 310, 406, 54, 150, 246, 342, 438, 86, 182, 278, 374, 470,
30, 126, 222, 318, 414, 62, 158, 254, 350, 446, 94, 190, 286, 382, 478,
3, 99, 195, 291, 387, 35, 131, 227, 323, 419, 67, 163, 259, 355, 451,
11, 107, 203, 299, 395, 43, 139, 235, 331, 427, 75, 171, 267, 363, 459,
19, 115, 211, 307, 403, 51, 147, 243, 339, 435, 83, 179, 275, 371, 467,
27, 123, 219, 315, 411, 59, 155, 251, 347, 443, 91, 187, 283, 379, 475,
7, 103, 199, 295, 391, 39, 135, 231, 327, 423, 71, 167, 263, 359, 455,
15, 111, 207, 303, 399, 47, 143, 239, 335, 431, 79, 175, 271, 367, 463,
23, 119, 215, 311, 407, 55, 151, 247, 343, 439, 87, 183, 279, 375, 471,
31, 127, 223, 319, 415, 63, 159, 255, 351, 447, 95, 191, 287, 383, 479,
};
#endif

#ifndef FFT_BITREV240
#define FFT_BITREV240
static const opus_int16 fft_bitrev240[240] = {
0, 48, 96, 144, 192, 16, 64, 112, 160, 208, 32, 80, 128, 176, 224,
4, 52, 100, 148, 196, 20, 68, 116, 164, 212, 36, 84, 132, 180, 228,
8, 56, 104, 152, 200, 24, 72, 120, 168, 216, 40, 88, 136, 184, 232,
12, 60, 108, 156, 204, 28, 76, 124, 172, 220, 44, 92, 140, 188, 236,
1, 49, 97, 145, 193, 17, 65, 113, 161, 209, 33, 81, 129, 177, 225,
5, 53, 101, 149, 197, 21, 69, 117, 165, 213, 37, 85, 133, 181, 229,
9, 57, 105, 153, 201, 25, 73, 121, 169, 217, 41, 89, 137, 185, 233,
13, 61, 109, 157, 205, 29, 77, 125, 173, 221, 45, 93, 141, 189, 237,
2, 50, 98, 146, 194, 18, 66, 114, 162, 210, 34, 82, 130, 178, 226,
6, 54, 102, 150, 198, 22, 70, 118, 166, 214, 38, 86, 134, 182, 230,
10, 58, 106, 154, 202, 26, 74, 122, 170, 218, 42, 90, 138, 186, 234,
14, 62, 110, 158, 206, 30, 78, 126, 174, 222, 46, 94, 142, 190, 238,
3, 51, 99, 147, 195, 19, 67, 115, 163, 211, 35, 83, 131, 179, 227,
7, 55, 103, 151, 199, 23, 71, 119, 167, 215, 39, 87, 135, 183, 231,
11, 59, 107, 155, 203, 27, 75, 123, 171, 219, 43, 91, 139, 187, 235,
15, 63, 111, 159, 207, 31, 79, 127, 175, 223, 47, 95, 143, 191, 239,
};
#endif

#ifndef FFT_BITREV120
#define FFT_BITREV120
static const opus_int16 fft_bitrev120[120] = {
0, 24, 48, 72, 96, 8, 32, 56, 80, 104, 16, 40, 64, 88, 112,
4, 28, 52, 76, 100, 12, 36, 60, 84, 108, 20, 44, 68, 92, 116,
1, 25, 49, 73, 97, 9, 33, 57, 81, 105, 17, 41, 65, 89, 113,
5, 29, 53, 77, 101, 13, 37, 61, 85, 109, 21, 45, 69, 93, 117,
2, 26, 50, 74, 98, 10, 34, 58, 82, 106, 18, 42, 66, 90, 114,
6, 30, 54, 78, 102, 14, 38, 62, 86, 110, 22, 46, 70, 94, 118,
3, 27, 51, 75, 99, 11, 35, 59, 83, 107, 19, 43, 67, 91, 115,
7, 31, 55, 79, 103, 15, 39, 63, 87, 111, 23, 47, 71, 95, 119,
};
#endif

#ifndef FFT_STATE96000_1920_0
#define FFT_STATE96000_1920_0
static const kiss_fft_state fft_state96000_1920_0 = {
960,    /* nfft */
0.0010416667f,    /* scale */
-1,    /* shift */
{5, 192, 3, 64, 4, 16, 4, 4, 4, 1, 0, 0, 0, 0, 0, 0, },    /* factors */
fft_bitrev960,    /* bitrev */
fft_twiddles96000_1920,    /* bitrev */
#ifdef OVERRIDE_FFT
(arch_fft_state *)&cfg_arch_960,
#else
NULL,
#endif
};
#endif

#ifndef FFT_STATE96000_1920_1
#define FFT_STATE96000_1920_1
static const kiss_fft_state fft_state96000_1920_1 = {
480,    /* nfft */
0.0020833334f,    /* scale */
1,    /* shift */
{5, 96, 3, 32, 4, 8, 2, 4, 4, 1, 0, 0, 0, 0, 0, 0, },    /* factors */
fft_bitrev480,    /* bitrev */
fft_twiddles96000_1920,    /* bitrev */
#ifdef OVERRIDE_FFT
(arch_fft_state *)&cfg_arch_480,
#else
NULL,
#endif
};
#endif

#ifndef FFT_STATE96000_1920_2
#define FFT_STATE96000_1920_2
static const kiss_fft_state fft_state96000_1920_2 = {
240,    /* nfft */
0.0041666669f,    /* scale */
2,    /* shift */
{5, 48, 3, 16, 4, 4, 4, 1, 0, 0, 0, 0, 0, 0, 0, 0, },    /* factors */
fft_bitrev240,    /* bitrev */
fft_twiddles96000_1920,    /* bitrev */
#ifdef OVERRIDE_FFT
(arch_fft_state *)&cfg_arch_240,
#else
NULL,
#endif
};
#endif

#ifndef FFT_STATE96000_1920_3
#define FFT_STATE96000_1920_3
static const kiss_fft_state fft_state96000_1920_3 = {
120,    /* nfft */
0.0083333338f,    /* scale */
3,    /* shift */
{5, 24, 3, 8, 2, 4, 4, 1, 0, 0, 0, 0, 0, 0, 0, 0, },    /* factors */
fft_bitrev120,    /* bitrev */
fft_twiddles96000_1920,    /* bitrev */
#ifdef OVERRIDE_FFT
(arch_fft_state *)&cfg_arch_120,
#else
NULL,
#endif
};
#endif

#endif

#ifndef MDCT_TWIDDLES1920
#define MDCT_TWIDDLES1920
static const celt_coef mdct_twiddles1920[3600] = {
0.99999998f, 0.99999831f, 0.99999396f, 0.99998693f, 0.99997722f,
0.99996484f, 0.99994978f, 0.99993204f, 0.99991163f, 0.99988854f,
0.99986277f, 0.99983433f, 0.99980320f, 0.99976941f, 0.99973293f,
0.99969378f, 0.99965195f, 0.99960745f, 0.99956026f, 0.99951041f,
0.99945787f, 0.99940267f, 0.99934478f, 0.99928422f, 0.99922099f,
0.99915507f, 0.99908649f, 0.99901523f, 0.99894129f, 0.99886468f,
0.99878540f, 0.99870344f, 0.99861881f, 0.99853150f, 0.99844153f,
0.99834887f, 0.99825355f, 0.99815555f, 0.99805488f, 0.99795154f,
0.99784553f, 0.99773684f, 0.99762548f, 0.99751146f, 0.99739476f,
0.99727539f, 0.99715335f, 0.99702864f, 0.99690127f, 0.99677122f,
0.99663850f, 0.99650312f, 0.99636507f, 0.99622435f, 0.99608096f,
0.99593491f, 0.99578619f, 0.99563481f, 0.99548076f, 0.99532404f,
0.99516466f, 0.99500261f, 0.99483790f, 0.99467053f, 0.99450050f,
0.99432780f, 0.99415244f, 0.99397441f, 0.99379373f, 0.99361039f,
0.99342438f, 0.99323572f, 0.99304440f, 0.99285041f, 0.99265377f,
0.99245448f, 0.99225252f, 0.99204791f, 0.99184064f, 0.99163072f,
0.99141814f, 0.99120291f, 0.99098503f, 0.99076449f, 0.99054130f,
0.99031545f, 0.99008696f, 0.98985581f, 0.98962202f, 0.98938557f,
0.98914648f, 0.98890474f, 0.98866035f, 0.98841331f, 0.98816363f,
0.98791130f, 0.98765632f, 0.98739871f, 0.98713845f, 0.98687554f,
0.98660999f, 0.98634181f, 0.98607098f, 0.98579751f, 0.98552140f,
0.98524265f, 0.98496127f, 0.98467725f, 0.98439059f, 0.98410130f,
0.98380937f, 0.98351481f, 0.98321761f, 0.98291779f, 0.98261533f,
0.98231024f, 0.98200252f, 0.98169217f, 0.98137919f, 0.98106359f,
0.98074536f, 0.98042450f, 0.98010102f, 0.97977491f, 0.97944619f,
0.97911483f, 0.97878086f, 0.97844427f, 0.97810506f, 0.97776322f,
0.97741878f, 0.97707171f, 0.97672203f, 0.97636973f, 0.97601482f,
0.97565730f, 0.97529716f, 0.97493441f, 0.97456906f, 0.97420109f,
0.97383051f, 0.97345733f, 0.97308154f, 0.97270315f, 0.97232215f,
0.97193855f, 0.97155235f, 0.97116355f, 0.97077214f, 0.97037814f,
0.96998154f, 0.96958234f, 0.96918054f, 0.96877615f, 0.96836917f,
0.96795960f, 0.96754743f, 0.96713267f, 0.96671533f, 0.96629539f,
0.96587287f, 0.96544776f, 0.96502007f, 0.96458979f, 0.96415693f,
0.96372149f, 0.96328347f, 0.96284288f, 0.96239970f, 0.96195394f,
0.96150562f, 0.96105471f, 0.96060124f, 0.96014519f, 0.95968657f,
0.95922538f, 0.95876162f, 0.95829530f, 0.95782641f, 0.95735496f,
0.95688094f, 0.95640437f, 0.95592523f, 0.95544353f, 0.95495927f,
0.95447246f, 0.95398309f, 0.95349117f, 0.95299669f, 0.95249967f,
0.95200009f, 0.95149797f, 0.95099329f, 0.95048607f, 0.94997631f,
0.94946400f, 0.94894915f, 0.94843176f, 0.94791184f, 0.94738937f,
0.94686437f, 0.94633683f, 0.94580676f, 0.94527415f, 0.94473902f,
0.94420135f, 0.94366116f, 0.94311844f, 0.94257320f, 0.94202543f,
0.94147514f, 0.94092233f, 0.94036700f, 0.93980916f, 0.93924879f,
0.93868592f, 0.93812052f, 0.93755262f, 0.93698221f, 0.93640929f,
0.93583386f, 0.93525593f, 0.93467549f, 0.93409255f, 0.93350711f,
0.93291917f, 0.93232873f, 0.93173580f, 0.93114037f, 0.93054245f,
0.92994204f, 0.92933913f, 0.92873374f, 0.92812587f, 0.92751550f,
0.92690266f, 0.92628733f, 0.92566953f, 0.92504924f, 0.92442648f,
0.92380124f, 0.92317353f, 0.92254335f, 0.92191070f, 0.92127558f,
0.92063799f, 0.91999794f, 0.91935543f, 0.91871045f, 0.91806302f,
0.91741313f, 0.91676078f, 0.91610597f, 0.91544872f, 0.91478901f,
0.91412685f, 0.91346225f, 0.91279520f, 0.91212571f, 0.91145377f,
0.91077939f, 0.91010258f, 0.90942333f, 0.90874164f, 0.90805753f,
0.90737098f, 0.90668200f, 0.90599059f, 0.90529676f, 0.90460050f,
0.90390183f, 0.90320073f, 0.90249721f, 0.90179128f, 0.90108293f,
0.90037218f, 0.89965901f, 0.89894343f, 0.89822544f, 0.89750505f,
0.89678226f, 0.89605707f, 0.89532948f, 0.89459949f, 0.89386710f,
0.89313232f, 0.89239515f, 0.89165560f, 0.89091365f, 0.89016932f,
0.88942261f, 0.88867351f, 0.88792204f, 0.88716818f, 0.88641196f,
0.88565336f, 0.88489239f, 0.88412905f, 0.88336334f, 0.88259527f,
0.88182483f, 0.88105203f, 0.88027688f, 0.87949937f, 0.87871950f,
0.87793728f, 0.87715271f, 0.87636579f, 0.87557653f, 0.87478492f,
0.87399097f, 0.87319468f, 0.87239605f, 0.87159509f, 0.87079179f,
0.86998616f, 0.86917820f, 0.86836792f, 0.86755531f, 0.86674037f,
0.86592312f, 0.86510355f, 0.86428166f, 0.86345746f, 0.86263095f,
0.86180212f, 0.86097099f, 0.86013756f, 0.85930182f, 0.85846378f,
0.85762344f, 0.85678081f, 0.85593588f, 0.85508866f, 0.85423915f,
0.85338736f, 0.85253328f, 0.85167692f, 0.85081827f, 0.84995735f,
0.84909416f, 0.84822869f, 0.84736095f, 0.84649094f, 0.84561866f,
0.84474412f, 0.84386732f, 0.84298826f, 0.84210695f, 0.84122337f,
0.84033755f, 0.83944948f, 0.83855915f, 0.83766659f, 0.83677178f,
0.83587473f, 0.83497544f, 0.83407392f, 0.83317016f, 0.83226418f,
0.83135596f, 0.83044552f, 0.82953286f, 0.82861797f, 0.82770087f,
0.82678155f, 0.82586002f, 0.82493628f, 0.82401032f, 0.82308217f,
0.82215180f, 0.82121924f, 0.82028448f, 0.81934752f, 0.81840837f,
0.81746703f, 0.81652349f, 0.81557778f, 0.81462988f, 0.81367979f,
0.81272753f, 0.81177310f, 0.81081649f, 0.80985771f, 0.80889676f,
0.80793364f, 0.80696837f, 0.80600093f, 0.80503133f, 0.80405958f,
0.80308568f, 0.80210962f, 0.80113142f, 0.80015107f, 0.79916858f,
0.79818396f, 0.79719719f, 0.79620829f, 0.79521726f, 0.79422410f,
0.79322881f, 0.79223140f, 0.79123187f, 0.79023022f, 0.78922646f,
0.78822058f, 0.78721259f, 0.78620249f, 0.78519029f, 0.78417599f,
0.78315958f, 0.78214108f, 0.78112049f, 0.78009781f, 0.77907303f,
0.77804617f, 0.77701723f, 0.77598621f, 0.77495311f, 0.77391793f,
0.77288068f, 0.77184137f, 0.77079998f, 0.76975654f, 0.76871103f,
0.76766347f, 0.76661384f, 0.76556217f, 0.76450845f, 0.76345268f,
0.76239487f, 0.76133501f, 0.76027312f, 0.75920919f, 0.75814323f,
0.75707524f, 0.75600522f, 0.75493318f, 0.75385911f, 0.75278303f,
0.75170494f, 0.75062483f, 0.74954271f, 0.74845858f, 0.74737245f,
0.74628432f, 0.74519419f, 0.74410207f, 0.74300795f, 0.74191185f,
0.74081376f, 0.73971368f, 0.73861163f, 0.73750759f, 0.73640158f,
0.73529361f, 0.73418366f, 0.73307175f, 0.73195787f, 0.73084203f,
0.72972424f, 0.72860450f, 0.72748280f, 0.72635916f, 0.72523357f,
0.72410604f, 0.72297657f, 0.72184516f, 0.72071182f, 0.71957656f,
0.71843936f, 0.71730025f, 0.71615921f, 0.71501625f, 0.71387138f,
0.71272460f, 0.71157592f, 0.71042532f, 0.70927283f, 0.70811843f,
0.70696214f, 0.70580396f, 0.70464389f, 0.70348193f, 0.70231808f,
0.70115236f, 0.69998476f, 0.69881528f, 0.69764394f, 0.69647073f,
0.69529565f, 0.69411871f, 0.69293991f, 0.69175926f, 0.69057675f,
0.68939240f, 0.68820620f, 0.68701816f, 0.68582828f, 0.68463656f,
0.68344301f, 0.68224763f, 0.68105042f, 0.67985139f, 0.67865054f,
0.67744787f, 0.67624339f, 0.67503710f, 0.67382900f, 0.67261910f,
0.67140739f, 0.67019389f, 0.66897860f, 0.66776151f, 0.66654264f,
0.66532198f, 0.66409954f, 0.66287532f, 0.66164932f, 0.66042156f,
0.65919203f, 0.65796073f, 0.65672767f, 0.65549285f, 0.65425628f,
0.65301796f, 0.65177788f, 0.65053607f, 0.64929251f, 0.64804721f,
0.64680018f, 0.64555141f, 0.64430092f, 0.64304871f, 0.64179477f,
0.64053911f, 0.63928174f, 0.63802265f, 0.63676186f, 0.63549936f,
0.63423517f, 0.63296927f, 0.63170168f, 0.63043240f, 0.62916143f,
0.62788877f, 0.62661444f, 0.62533842f, 0.62406074f, 0.62278138f,
0.62150035f, 0.62021766f, 0.61893331f, 0.61764731f, 0.61635965f,
0.61507034f, 0.61377938f, 0.61248678f, 0.61119254f, 0.60989666f,
0.60859915f, 0.60730001f, 0.60599925f, 0.60469686f, 0.60339285f,
0.60208723f, 0.60078000f, 0.59947115f, 0.59816071f, 0.59684866f,
0.59553501f, 0.59421977f, 0.59290294f, 0.59158452f, 0.59026452f,
0.58894293f, 0.58761977f, 0.58629504f, 0.58496873f, 0.58364086f,
0.58231143f, 0.58098044f, 0.57964789f, 0.57831380f, 0.57697815f,
0.57564096f, 0.57430223f, 0.57296196f, 0.57162015f, 0.57027682f,
0.56893195f, 0.56758557f, 0.56623767f, 0.56488825f, 0.56353731f,
0.56218487f, 0.56083093f, 0.55947548f, 0.55811853f, 0.55676009f,
0.55540016f, 0.55403874f, 0.55267584f, 0.55131146f, 0.54994560f,
0.54857827f, 0.54720948f, 0.54583921f, 0.54446749f, 0.54309431f,
0.54171967f, 0.54034359f, 0.53896605f, 0.53758708f, 0.53620666f,
0.53482481f, 0.53344153f, 0.53205682f, 0.53067068f, 0.52928312f,
0.52789415f, 0.52650377f, 0.52511197f, 0.52371877f, 0.52232416f,
0.52092816f, 0.51953076f, 0.51813197f, 0.51673180f, 0.51533024f,
0.51392730f, 0.51252299f, 0.51111730f, 0.50971025f, 0.50830183f,
0.50689204f, 0.50548091f, 0.50406842f, 0.50265458f, 0.50123939f,
0.49982286f, 0.49840499f, 0.49698579f, 0.49556526f, 0.49414340f,
0.49272022f, 0.49129572f, 0.48986991f, 0.48844278f, 0.48701434f,
0.48558461f, 0.48415357f, 0.48272123f, 0.48128760f, 0.47985269f,
0.47841649f, 0.47697901f, 0.47554025f, 0.47410021f, 0.47265891f,
0.47121635f, 0.46977252f, 0.46832743f, 0.46688109f, 0.46543350f,
0.46398467f, 0.46253459f, 0.46108327f, 0.45963072f, 0.45817694f,
0.45672193f, 0.45526570f, 0.45380825f, 0.45234959f, 0.45088971f,
0.44942863f, 0.44796634f, 0.44650286f, 0.44503818f, 0.44357230f,
0.44210524f, 0.44063700f, 0.43916758f, 0.43769698f, 0.43622521f,
0.43475227f, 0.43327816f, 0.43180290f, 0.43032648f, 0.42884891f,
0.42737019f, 0.42589033f, 0.42440932f, 0.42292718f, 0.42144391f,
0.41995951f, 0.41847399f, 0.41698734f, 0.41549958f, 0.41401070f,
0.41252072f, 0.41102963f, 0.40953745f, 0.40804416f, 0.40654979f,
0.40505432f, 0.40355777f, 0.40206014f, 0.40056144f, 0.39906166f,
0.39756081f, 0.39605890f, 0.39455593f, 0.39305190f, 0.39154682f,
0.39004069f, 0.38853352f, 0.38702530f, 0.38551605f, 0.38400577f,
0.38249446f, 0.38098213f, 0.37946878f, 0.37795441f, 0.37643902f,
0.37492263f, 0.37340524f, 0.37188685f, 0.37036746f, 0.36884708f,
0.36732571f, 0.36580336f, 0.36428003f, 0.36275572f, 0.36123045f,
0.35970420f, 0.35817700f, 0.35664883f, 0.35511971f, 0.35358964f,
0.35205862f, 0.35052666f, 0.34899376f, 0.34745992f, 0.34592516f,
0.34438947f, 0.34285286f, 0.34131533f, 0.33977688f, 0.33823753f,
0.33669727f, 0.33515611f, 0.33361405f, 0.33207110f, 0.33052726f,
0.32898254f, 0.32743693f, 0.32589045f, 0.32434309f, 0.32279487f,
0.32124578f, 0.31969583f, 0.31814503f, 0.31659338f, 0.31504087f,
0.31348753f, 0.31193334f, 0.31037832f, 0.30882247f, 0.30726579f,
0.30570829f, 0.30414997f, 0.30259083f, 0.30103089f, 0.29947014f,
0.29790859f, 0.29634624f, 0.29478309f, 0.29321916f, 0.29165445f,
0.29008895f, 0.28852267f, 0.28695563f, 0.28538781f, 0.28381923f,
0.28224989f, 0.28067980f, 0.27910895f, 0.27753736f, 0.27596502f,
0.27439194f, 0.27281813f, 0.27124359f, 0.26966833f, 0.26809234f,
0.26651563f, 0.26493821f, 0.26336008f, 0.26178125f, 0.26020171f,
0.25862148f, 0.25704055f, 0.25545894f, 0.25387664f, 0.25229367f,
0.25071002f, 0.24912569f, 0.24754070f, 0.24595505f, 0.24436874f,
0.24278177f, 0.24119416f, 0.23960590f, 0.23801699f, 0.23642745f,
0.23483728f, 0.23324648f, 0.23165505f, 0.23006301f, 0.22847034f,
0.22687707f, 0.22528319f, 0.22368870f, 0.22209362f, 0.22049794f,
0.21890167f, 0.21730482f, 0.21570738f, 0.21410937f, 0.21251078f,
0.21091163f, 0.20931191f, 0.20771163f, 0.20611079f, 0.20450940f,
0.20290746f, 0.20130498f, 0.19970196f, 0.19809841f, 0.19649433f,
0.19488972f, 0.19328459f, 0.19167894f, 0.19007277f, 0.18846610f,
0.18685893f, 0.18525125f, 0.18364308f, 0.18203442f, 0.18042526f,
0.17881563f, 0.17720552f, 0.17559493f, 0.17398387f, 0.17237235f,
0.17076037f, 0.16914792f, 0.16753503f, 0.16592169f, 0.16430790f,
0.16269367f, 0.16107901f, 0.15946391f, 0.15784839f, 0.15623245f,
0.15461609f, 0.15299931f, 0.15138213f, 0.14976453f, 0.14814654f,
0.14652815f, 0.14490937f, 0.14329020f, 0.14167065f, 0.14005072f,
0.13843041f, 0.13680974f, 0.13518869f, 0.13356729f, 0.13194552f,
0.13032341f, 0.12870094f, 0.12707813f, 0.12545498f, 0.12383150f,
0.12220768f, 0.12058354f, 0.11895907f, 0.11733428f, 0.11570918f,
0.11408377f, 0.11245806f, 0.11083204f, 0.10920573f, 0.10757912f,
0.10595223f, 0.10432505f, 0.10269759f, 0.10106986f, 0.099441861f,
0.097813592f, 0.096185062f, 0.094556275f, 0.092927234f, 0.091297944f,
0.089668410f, 0.088038636f, 0.086408626f, 0.084778385f, 0.083147917f,
0.081517226f, 0.079886317f, 0.078255194f, 0.076623861f, 0.074992324f,
0.073360585f, 0.071728651f, 0.070096524f, 0.068464209f, 0.066831712f,
0.065199035f, 0.063566184f, 0.061933162f, 0.060299975f, 0.058666626f,
0.057033121f, 0.055399462f, 0.053765655f, 0.052131705f, 0.050497614f,
0.048863389f, 0.047229033f, 0.045594550f, 0.043959945f, 0.042325222f,
0.040690387f, 0.039055442f, 0.037420393f, 0.035785243f, 0.034149998f,
0.032514661f, 0.030879237f, 0.029243731f, 0.027608146f, 0.025972487f,
0.024336759f, 0.022700965f, 0.021065111f, 0.019429201f, 0.017793238f,
0.016157228f, 0.014521174f, 0.012885082f, 0.011248955f, 0.0096127982f,
0.0079766155f, 0.0063404114f, 0.0047041904f, 0.0030679568f, 0.0014317149f,
-0.00020453077f, -0.0018407759f, -0.0034770161f, -0.0051132470f, -0.0067494642f,
-0.0083856634f, -0.010021840f, -0.011657990f, -0.013294109f, -0.014930192f,
-0.016566235f, -0.018202233f, -0.019838183f, -0.021474080f, -0.023109920f,
-0.024745697f, -0.026381408f, -0.028017049f, -0.029652615f, -0.031288101f,
-0.032923503f, -0.034558818f, -0.036194040f, -0.037829164f, -0.039464188f,
-0.041099106f, -0.042733914f, -0.044368607f, -0.046003182f, -0.047637634f,
-0.049271958f, -0.050906150f, -0.052540206f, -0.054174121f, -0.055807891f,
-0.057441512f, -0.059074978f, -0.060708287f, -0.062341433f, -0.063974413f,
-0.065607221f, -0.067239853f, -0.068872305f, -0.070504573f, -0.072136653f,
-0.073768539f, -0.075400227f, -0.077031714f, -0.078662994f, -0.080294064f,
-0.081924919f, -0.083555555f, -0.085185966f, -0.086816150f, -0.088446102f,
-0.090075816f, -0.091705289f, -0.093334517f, -0.094963495f, -0.096592219f,
-0.098220684f, -0.099848886f, -0.10147682f, -0.10310448f, -0.10473187f,
-0.10635898f, -0.10798580f, -0.10961233f, -0.11123857f, -0.11286451f,
-0.11449015f, -0.11611549f, -0.11774051f, -0.11936521f, -0.12098960f,
-0.12261367f, -0.12423740f, -0.12586080f, -0.12748387f, -0.12910659f,
-0.13072897f, -0.13235100f, -0.13397267f, -0.13559399f, -0.13721494f,
-0.13883553f, -0.14045574f, -0.14207558f, -0.14369503f, -0.14531411f,
-0.14693279f, -0.14855108f, -0.15016897f, -0.15178646f, -0.15340354f,
-0.15502022f, -0.15663647f, -0.15825231f, -0.15986773f, -0.16148271f,
-0.16309727f, -0.16471139f, -0.16632506f, -0.16793829f, -0.16955108f,
-0.17116340f, -0.17277527f, -0.17438668f, -0.17599762f, -0.17760809f,
-0.17921808f, -0.18082760f, -0.18243663f, -0.18404517f, -0.18565322f,
-0.18726077f, -0.18886782f, -0.19047436f, -0.19208040f, -0.19368592f,
-0.19529092f, -0.19689540f, -0.19849935f, -0.20010277f, -0.20170565f,
-0.20330800f, -0.20490980f, -0.20651105f, -0.20811175f, -0.20971189f,
-0.21131147f, -0.21291048f, -0.21450893f, -0.21610680f, -0.21770409f,
-0.21930080f, -0.22089692f, -0.22249245f, -0.22408738f, -0.22568172f,
-0.22727545f, -0.22886857f, -0.23046108f, -0.23205297f, -0.23364424f,
-0.23523488f, -0.23682490f, -0.23841428f, -0.24000302f, -0.24159112f,
-0.24317858f, -0.24476538f, -0.24635153f, -0.24793701f, -0.24952184f,
-0.25110599f, -0.25268948f, -0.25427228f, -0.25585441f, -0.25743585f,
-0.25901660f, -0.26059666f, -0.26217602f, -0.26375468f, -0.26533263f,
-0.26690987f, -0.26848640f, -0.27006221f, -0.27163730f, -0.27321165f,
-0.27478528f, -0.27635817f, -0.27793032f, -0.27950173f, -0.28107239f,
-0.28264230f, -0.28421145f, -0.28577984f, -0.28734746f, -0.28891431f,
-0.29048039f, -0.29204570f, -0.29361022f, -0.29517395f, -0.29673690f,
-0.29829905f, -0.29986040f, -0.30142095f, -0.30298069f, -0.30453962f,
-0.30609774f, -0.30765504f, -0.30921151f, -0.31076715f, -0.31232197f,
-0.31387594f, -0.31542908f, -0.31698137f, -0.31853281f, -0.32008340f,
-0.32163313f, -0.32318201f, -0.32473001f, -0.32627715f, -0.32782341f,
-0.32936880f, -0.33091330f, -0.33245692f, -0.33399965f, -0.33554149f,
-0.33708242f, -0.33862245f, -0.34016158f, -0.34169980f, -0.34323710f,
-0.34477348f, -0.34630894f, -0.34784347f, -0.34937707f, -0.35090974f,
-0.35244146f, -0.35397224f, -0.35550208f, -0.35703096f, -0.35855889f,
-0.36008585f, -0.36161186f, -0.36313689f, -0.36466095f, -0.36618404f,
-0.36770615f, -0.36922727f, -0.37074740f, -0.37226654f, -0.37378468f,
-0.37530183f, -0.37681796f, -0.37833309f, -0.37984721f, -0.38136031f,
-0.38287239f, -0.38438344f, -0.38589346f, -0.38740245f, -0.38891041f,
-0.39041732f, -0.39192319f, -0.39342800f, -0.39493177f, -0.39643448f,
-0.39793612f, -0.39943670f, -0.40093621f, -0.40243465f, -0.40393201f,
-0.40542829f, -0.40692348f, -0.40841759f, -0.40991060f, -0.41140251f,
-0.41289332f, -0.41438303f, -0.41587162f, -0.41735911f, -0.41884547f,
-0.42033072f, -0.42181484f, -0.42329782f, -0.42477968f, -0.42626040f,
-0.42773998f, -0.42921841f, -0.43069569f, -0.43217182f, -0.43364680f,
-0.43512061f, -0.43659326f, -0.43806474f, -0.43953504f, -0.44100417f,
-0.44247212f, -0.44393888f, -0.44540446f, -0.44686884f, -0.44833203f,
-0.44979401f, -0.45125479f, -0.45271437f, -0.45417273f, -0.45562987f,
-0.45708580f, -0.45854050f, -0.45999398f, -0.46144622f, -0.46289723f,
-0.46434699f, -0.46579552f, -0.46724280f, -0.46868882f, -0.47013359f,
-0.47157711f, -0.47301936f, -0.47446034f, -0.47590006f, -0.47733850f,
-0.47877566f, -0.48021154f, -0.48164613f, -0.48307944f, -0.48451145f,
-0.48594216f, -0.48737158f, -0.48879968f, -0.49022648f, -0.49165197f,
-0.49307614f, -0.49449899f, -0.49592052f, -0.49734072f, -0.49875959f,
-0.50017712f, -0.50159331f, -0.50300816f, -0.50442167f, -0.50583382f,
-0.50724462f, -0.50865406f, -0.51006214f, -0.51146885f, -0.51287419f,
-0.51427817f, -0.51568076f, -0.51708197f, -0.51848180f, -0.51988024f,
-0.52127729f, -0.52267294f, -0.52406720f, -0.52546005f, -0.52685149f,
-0.52824153f, -0.52963015f, -0.53101735f, -0.53240313f, -0.53378748f,
-0.53517041f, -0.53655190f, -0.53793196f, -0.53931057f, -0.54068774f,
-0.54206347f, -0.54343774f, -0.54481056f, -0.54618192f, -0.54755181f,
-0.54892024f, -0.55028721f, -0.55165269f, -0.55301671f, -0.55437924f,
-0.55574028f, -0.55709984f, -0.55845791f, -0.55981448f, -0.56116955f,
-0.56252312f, -0.56387519f, -0.56522574f, -0.56657478f, -0.56792231f,
-0.56926831f, -0.57061279f, -0.57195575f, -0.57329717f, -0.57463705f,
-0.57597540f, -0.57731221f, -0.57864747f, -0.57998118f, -0.58131334f,
-0.58264394f, -0.58397298f, -0.58530046f, -0.58662637f, -0.58795071f,
-0.58927348f, -0.59059466f, -0.59191427f, -0.59323230f, -0.59454873f,
-0.59586357f, -0.59717682f, -0.59848847f, -0.59979852f, -0.60110696f,
-0.60241379f, -0.60371901f, -0.60502261f, -0.60632459f, -0.60762495f,
-0.60892368f, -0.61022078f, -0.61151625f, -0.61281008f, -0.61410227f,
-0.61539282f, -0.61668172f, -0.61796896f, -0.61925456f, -0.62053849f,
-0.62182077f, -0.62310138f, -0.62438032f, -0.62565759f, -0.62693318f,
-0.62820709f, -0.62947933f, -0.63074988f, -0.63201874f, -0.63328590f,
-0.63455138f, -0.63581515f, -0.63707722f, -0.63833758f, -0.63959624f,
-0.64085318f, -0.64210841f, -0.64336192f, -0.64461371f, -0.64586377f,
-0.64711210f, -0.64835870f, -0.64960356f, -0.65084668f, -0.65208807f,
-0.65332770f, -0.65456559f, -0.65580172f, -0.65703610f, -0.65826872f,
-0.65949958f, -0.66072867f, -0.66195599f, -0.66318154f, -0.66440531f,
-0.66562731f, -0.66684752f, -0.66806595f, -0.66928259f, -0.67049744f,
-0.67171049f, -0.67292174f, -0.67413119f, -0.67533884f, -0.67654468f,
-0.67774871f, -0.67895092f, -0.68015132f, -0.68134989f, -0.68254664f,
-0.68374157f, -0.68493466f, -0.68612592f, -0.68731534f, -0.68850292f,
-0.68968866f, -0.69087255f, -0.69205460f, -0.69323478f, -0.69441312f,
-0.69558959f, -0.69676420f, -0.69793695f, -0.69910783f, -0.70027684f,
-0.70144397f, -0.70260922f, -0.70377259f, -0.70493408f, -0.70609368f,
-0.70725139f, -0.70840721f, -0.70956113f, -0.71071315f, -0.71186327f,
-0.71301148f, -0.71415778f, -0.71530217f, -0.71644465f, -0.71758521f,
-0.71872384f, -0.71986055f, -0.72099534f, -0.72212819f, -0.72325912f,
-0.72438810f, -0.72551515f, -0.72664025f, -0.72776341f, -0.72888462f,
-0.73000387f, -0.73112118f, -0.73223652f, -0.73334991f, -0.73446133f,
-0.73557079f, -0.73667827f, -0.73778379f, -0.73888732f, -0.73998888f,
-0.74108846f, -0.74218606f, -0.74328167f, -0.74437529f, -0.74546691f,
-0.74655654f, -0.74764417f, -0.74872980f, -0.74981342f, -0.75089504f,
-0.75197465f, -0.75305224f, -0.75412782f, -0.75520138f, -0.75627291f,
-0.75734242f, -0.75840991f, -0.75947536f, -0.76053878f, -0.76160017f,
-0.76265951f, -0.76371681f, -0.76477207f, -0.76582528f, -0.76687644f,
-0.76792555f, -0.76897260f, -0.77001759f, -0.77106052f, -0.77210139f,
-0.77314019f, -0.77417692f, -0.77521158f, -0.77624416f, -0.77727466f,
-0.77830308f, -0.77932942f, -0.78035367f, -0.78137584f, -0.78239591f,
-0.78341388f, -0.78442976f, -0.78544354f, -0.78645521f, -0.78746478f,
-0.78847224f, -0.78947760f, -0.79048083f, -0.79148195f, -0.79248095f,
-0.79347783f, -0.79447259f, -0.79546522f, -0.79645572f, -0.79744408f,
-0.79843031f, -0.79941441f, -0.80039636f, -0.80137617f, -0.80235384f,
-0.80332935f, -0.80430272f, -0.80527393f, -0.80624299f, -0.80720989f,
-0.80817462f, -0.80913720f, -0.81009760f, -0.81105584f, -0.81201191f,
-0.81296580f, -0.81391752f, -0.81486706f, -0.81581441f, -0.81675958f,
-0.81770257f, -0.81864336f, -0.81958197f, -0.82051837f, -0.82145259f,
-0.82238460f, -0.82331441f, -0.82424202f, -0.82516742f, -0.82609061f,
-0.82701159f, -0.82793036f, -0.82884690f, -0.82976123f, -0.83067334f,
-0.83158323f, -0.83249088f, -0.83339631f, -0.83429951f, -0.83520047f,
-0.83609920f, -0.83699569f, -0.83788994f, -0.83878195f, -0.83967171f,
-0.84055922f, -0.84144448f, -0.84232749f, -0.84320824f, -0.84408674f,
-0.84496297f, -0.84583694f, -0.84670865f, -0.84757810f, -0.84844527f,
-0.84931017f, -0.85017280f, -0.85103315f, -0.85189122f, -0.85274701f,
-0.85360052f, -0.85445175f, -0.85530068f, -0.85614733f, -0.85699168f,
-0.85783374f, -0.85867350f, -0.85951097f, -0.86034613f, -0.86117899f,
-0.86200954f, -0.86283779f, -0.86366373f, -0.86448735f, -0.86530866f,
-0.86612765f, -0.86694432f, -0.86775868f, -0.86857071f, -0.86938041f,
-0.87018779f, -0.87099283f, -0.87179555f, -0.87259593f, -0.87339397f,
-0.87418968f, -0.87498304f, -0.87577407f, -0.87656274f, -0.87734907f,
-0.87813306f, -0.87891469f, -0.87969397f, -0.88047089f, -0.88124545f,
-0.88201766f, -0.88278751f, -0.88355499f, -0.88432010f, -0.88508285f,
-0.88584323f, -0.88660124f, -0.88735687f, -0.88811013f, -0.88886101f,
-0.88960951f, -0.89035563f, -0.89109936f, -0.89184071f, -0.89257967f,
-0.89331624f, -0.89405042f, -0.89478221f, -0.89551160f, -0.89623859f,
-0.89696318f, -0.89768538f, -0.89840516f, -0.89912255f, -0.89983752f,
-0.90055009f, -0.90126025f, -0.90196799f, -0.90267332f, -0.90337623f,
-0.90407672f, -0.90477479f, -0.90547044f, -0.90616367f, -0.90685447f,
-0.90754284f, -0.90822878f, -0.90891229f, -0.90959337f, -0.91027201f,
-0.91094822f, -0.91162198f, -0.91229331f, -0.91296219f, -0.91362863f,
-0.91429262f, -0.91495417f, -0.91561326f, -0.91626990f, -0.91692409f,
-0.91757583f, -0.91822511f, -0.91887193f, -0.91951629f, -0.92015819f,
-0.92079762f, -0.92143459f, -0.92206909f, -0.92270113f, -0.92333069f,
-0.92395778f, -0.92458240f, -0.92520454f, -0.92582421f, -0.92644140f,
-0.92705610f, -0.92766833f, -0.92827807f, -0.92888532f, -0.92949009f,
-0.93009237f, -0.93069216f, -0.93128946f, -0.93188427f, -0.93247658f,
-0.93306639f, -0.93365370f, -0.93423852f, -0.93482083f, -0.93540065f,
-0.93597795f, -0.93655275f, -0.93712505f, -0.93769483f, -0.93826211f,
-0.93882687f, -0.93938912f, -0.93994885f, -0.94050607f, -0.94106077f,
-0.94161295f, -0.94216261f, -0.94270975f, -0.94325436f, -0.94379644f,
-0.94433601f, -0.94487304f, -0.94540754f, -0.94593951f, -0.94646895f,
-0.94699585f, -0.94752022f, -0.94804206f, -0.94856135f, -0.94907810f,
-0.94959232f, -0.95010399f, -0.95061312f, -0.95111970f, -0.95162374f,
-0.95212522f, -0.95262416f, -0.95312055f, -0.95361439f, -0.95410567f,
-0.95459440f, -0.95508058f, -0.95556419f, -0.95604525f, -0.95652375f,
-0.95699969f, -0.95747306f, -0.95794388f, -0.95841212f, -0.95887780f,
-0.95934092f, -0.95980146f, -0.96025944f, -0.96071485f, -0.96116768f,
-0.96161794f, -0.96206562f, -0.96251073f, -0.96295327f, -0.96339322f,
-0.96383060f, -0.96426539f, -0.96469760f, -0.96512723f, -0.96555428f,
-0.96597874f, -0.96640062f, -0.96681991f, -0.96723660f, -0.96765071f,
-0.96806223f, -0.96847116f, -0.96887749f, -0.96928124f, -0.96968238f,
-0.97008093f, -0.97047688f, -0.97087024f, -0.97126099f, -0.97164914f,
-0.97203470f, -0.97241765f, -0.97279799f, -0.97317574f, -0.97355087f,
-0.97392340f, -0.97429333f, -0.97466064f, -0.97502535f, -0.97538744f,
-0.97574692f, -0.97610379f, -0.97645805f, -0.97680969f, -0.97715872f,
-0.97750513f, -0.97784893f, -0.97819010f, -0.97852866f, -0.97886460f,
-0.97919792f, -0.97952861f, -0.97985669f, -0.98018214f, -0.98050496f,
-0.98082516f, -0.98114274f, -0.98145768f, -0.98177000f, -0.98207970f,
-0.98238676f, -0.98269119f, -0.98299299f, -0.98329216f, -0.98358870f,
-0.98388260f, -0.98417387f, -0.98446250f, -0.98474850f, -0.98503186f,
-0.98531259f, -0.98559068f, -0.98586612f, -0.98613893f, -0.98640910f,
-0.98667663f, -0.98694151f, -0.98720376f, -0.98746336f, -0.98772032f,
-0.98797463f, -0.98822630f, -0.98847532f, -0.98872169f, -0.98896542f,
-0.98920650f, -0.98944493f, -0.98968071f, -0.98991385f, -0.99014433f,
-0.99037216f, -0.99059734f, -0.99081987f, -0.99103975f, -0.99125697f,
-0.99147154f, -0.99168345f, -0.99189271f, -0.99209931f, -0.99230326f,
-0.99250455f, -0.99270318f, -0.99289916f, -0.99309248f, -0.99328313f,
-0.99347113f, -0.99365647f, -0.99383915f, -0.99401917f, -0.99419653f,
-0.99437122f, -0.99454325f, -0.99471262f, -0.99487933f, -0.99504337f,
-0.99520475f, -0.99536347f, -0.99551952f, -0.99567290f, -0.99582362f,
-0.99597167f, -0.99611706f, -0.99625978f, -0.99639983f, -0.99653722f,
-0.99667193f, -0.99680398f, -0.99693336f, -0.99706007f, -0.99718411f,
-0.99730548f, -0.99742418f, -0.99754021f, -0.99765357f, -0.99776426f,
-0.99787228f, -0.99797763f, -0.99808030f, -0.99818030f, -0.99827763f,
-0.99837229f, -0.99846427f, -0.99855358f, -0.99864022f, -0.99872418f,
-0.99880547f, -0.99888409f, -0.99896003f, -0.99903329f, -0.99910389f,
-0.99917180f, -0.99923705f, -0.99929961f, -0.99935950f, -0.99941672f,
-0.99947126f, -0.99952312f, -0.99957231f, -0.99961882f, -0.99966266f,
-0.99970382f, -0.99974230f, -0.99977811f, -0.99981124f, -0.99984169f,
-0.99986946f, -0.99989456f, -0.99991698f, -0.99993673f, -0.99995380f,
-0.99996819f, -0.99997990f, -0.99998894f, -0.99999529f, -0.99999898f,
0.99999992f, 0.99999322f, 0.99997582f, 0.99994771f, 0.99990889f,
0.99985936f, 0.99979913f, 0.99972818f, 0.99964653f, 0.99955418f,
0.99945112f, 0.99933736f, 0.99921289f, 0.99907773f, 0.99893186f,
0.99877530f, 0.99860804f, 0.99843009f, 0.99824144f, 0.99804211f,
0.99783209f, 0.99761138f, 0.99737998f, 0.99713791f, 0.99688516f,
0.99662173f, 0.99634763f, 0.99606285f, 0.99576741f, 0.99546131f,
0.99514455f, 0.99481713f, 0.99447905f, 0.99413033f, 0.99377096f,
0.99340095f, 0.99302029f, 0.99262901f, 0.99222709f, 0.99181455f,
0.99139139f, 0.99095760f, 0.99051321f, 0.99005821f, 0.98959261f,
0.98911641f, 0.98862961f, 0.98813223f, 0.98762427f, 0.98710573f,
0.98657662f, 0.98603694f, 0.98548670f, 0.98492591f, 0.98435457f,
0.98377269f, 0.98318028f, 0.98257734f, 0.98196387f, 0.98133989f,
0.98070539f, 0.98006040f, 0.97940491f, 0.97873893f, 0.97806247f,
0.97737554f, 0.97667813f, 0.97597027f, 0.97525196f, 0.97452320f,
0.97378401f, 0.97303439f, 0.97227435f, 0.97150389f, 0.97072303f,
0.96993178f, 0.96913014f, 0.96831812f, 0.96749573f, 0.96666298f,
0.96581987f, 0.96496643f, 0.96410265f, 0.96322854f, 0.96234412f,
0.96144939f, 0.96054437f, 0.95962906f, 0.95870347f, 0.95776762f,
0.95682151f, 0.95586515f, 0.95489856f, 0.95392174f, 0.95293471f,
0.95193746f, 0.95093003f, 0.94991241f, 0.94888462f, 0.94784667f,
0.94679856f, 0.94574032f, 0.94467195f, 0.94359346f, 0.94250486f,
0.94140618f, 0.94029741f, 0.93917857f, 0.93804967f, 0.93691073f,
0.93576176f, 0.93460276f, 0.93343375f, 0.93225475f, 0.93106577f,
0.92986681f, 0.92865789f, 0.92743903f, 0.92621024f, 0.92497153f,
0.92372291f, 0.92246440f, 0.92119602f, 0.91991776f, 0.91862966f,
0.91733172f, 0.91602395f, 0.91470637f, 0.91337900f, 0.91204185f,
0.91069493f, 0.90933825f, 0.90797184f, 0.90659570f, 0.90520986f,
0.90381432f, 0.90240910f, 0.90099422f, 0.89956969f, 0.89813553f,
0.89669174f, 0.89523836f, 0.89377538f, 0.89230284f, 0.89082074f,
0.88932910f, 0.88782793f, 0.88631726f, 0.88479710f, 0.88326746f,
0.88172836f, 0.88017982f, 0.87862185f, 0.87705448f, 0.87547771f,
0.87389156f, 0.87229606f, 0.87069121f, 0.86907704f, 0.86745357f,
0.86582080f, 0.86417876f, 0.86252747f, 0.86086694f, 0.85919719f,
0.85751824f, 0.85583010f, 0.85413281f, 0.85242636f, 0.85071078f,
0.84898610f, 0.84725232f, 0.84550947f, 0.84375756f, 0.84199662f,
0.84022666f, 0.83844771f, 0.83665977f, 0.83486287f, 0.83305704f,
0.83124228f, 0.82941862f, 0.82758608f, 0.82574467f, 0.82389442f,
0.82203535f, 0.82016748f, 0.81829082f, 0.81640540f, 0.81451123f,
0.81260835f, 0.81069676f, 0.80877649f, 0.80684755f, 0.80490998f,
0.80296379f, 0.80100899f, 0.79904562f, 0.79707370f, 0.79509323f,
0.79310425f, 0.79110678f, 0.78910084f, 0.78708644f, 0.78506362f,
0.78303239f, 0.78099277f, 0.77894479f, 0.77688847f, 0.77482382f,
0.77275088f, 0.77066967f, 0.76858020f, 0.76648250f, 0.76437659f,
0.76226250f, 0.76014024f, 0.75800984f, 0.75587132f, 0.75372471f,
0.75157003f, 0.74940730f, 0.74723654f, 0.74505779f, 0.74287105f,
0.74067635f, 0.73847373f, 0.73626320f, 0.73404478f, 0.73181850f,
0.72958438f, 0.72734245f, 0.72509273f, 0.72283525f, 0.72057002f,
0.71829708f, 0.71601644f, 0.71372814f, 0.71143220f, 0.70912863f,
0.70681747f, 0.70449874f, 0.70217247f, 0.69983868f, 0.69749739f,
0.69514863f, 0.69279243f, 0.69042881f, 0.68805780f, 0.68567941f,
0.68329369f, 0.68090064f, 0.67850031f, 0.67609270f, 0.67367786f,
0.67125580f, 0.66882656f, 0.66639015f, 0.66394661f, 0.66149595f,
0.65903821f, 0.65657341f, 0.65410159f, 0.65162275f, 0.64913694f,
0.64664418f, 0.64414449f, 0.64163790f, 0.63912444f, 0.63660414f,
0.63407702f, 0.63154311f, 0.62900244f, 0.62645503f, 0.62390091f,
0.62134011f, 0.61877265f, 0.61619857f, 0.61361789f, 0.61103064f,
0.60843685f, 0.60583654f, 0.60322974f, 0.60061648f, 0.59799679f,
0.59537069f, 0.59273822f, 0.59009940f, 0.58745427f, 0.58480284f,
0.58214514f, 0.57948122f, 0.57681109f, 0.57413478f, 0.57145232f,
0.56876374f, 0.56606907f, 0.56336834f, 0.56066158f, 0.55794881f,
0.55523006f, 0.55250537f, 0.54977477f, 0.54703827f, 0.54429592f,
0.54154774f, 0.53879376f, 0.53603401f, 0.53326852f, 0.53049731f,
0.52772043f, 0.52493790f, 0.52214974f, 0.51935599f, 0.51655668f,
0.51375184f, 0.51094149f, 0.50812568f, 0.50530442f, 0.50247775f,
0.49964570f, 0.49680830f, 0.49396558f, 0.49111757f, 0.48826430f,
0.48540580f, 0.48254210f, 0.47967323f, 0.47679923f, 0.47392012f,
0.47103594f, 0.46814671f, 0.46525247f, 0.46235324f, 0.45944907f,
0.45653997f, 0.45362599f, 0.45070714f, 0.44778347f, 0.44485501f,
0.44192178f, 0.43898381f, 0.43604115f, 0.43309382f, 0.43014185f,
0.42718527f, 0.42422412f, 0.42125842f, 0.41828822f, 0.41531353f,
0.41233440f, 0.40935085f, 0.40636291f, 0.40337063f, 0.40037402f,
0.39737313f, 0.39436798f, 0.39135861f, 0.38834505f, 0.38532733f,
0.38230548f, 0.37927953f, 0.37624953f, 0.37321550f, 0.37017747f,
0.36713547f, 0.36408955f, 0.36103972f, 0.35798603f, 0.35492850f,
0.35186718f, 0.34880208f, 0.34573325f, 0.34266072f, 0.33958451f,
0.33650468f, 0.33342123f, 0.33033422f, 0.32724367f, 0.32414961f,
0.32105209f, 0.31795112f, 0.31484675f, 0.31173901f, 0.30862793f,
0.30551354f, 0.30239588f, 0.29927499f, 0.29615089f, 0.29302362f,
0.28989321f, 0.28675969f, 0.28362310f, 0.28048348f, 0.27734085f,
0.27419526f, 0.27104672f, 0.26789529f, 0.26474098f, 0.26158384f,
0.25842390f, 0.25526119f, 0.25209575f, 0.24892761f, 0.24575680f,
0.24258336f, 0.23940732f, 0.23622872f, 0.23304759f, 0.22986396f,
0.22667787f, 0.22348935f, 0.22029844f, 0.21710517f, 0.21390958f,
0.21071169f, 0.20751155f, 0.20430919f, 0.20110463f, 0.19789793f,
0.19468910f, 0.19147819f, 0.18826523f, 0.18505026f, 0.18183330f,
0.17861439f, 0.17539357f, 0.17217088f, 0.16894634f, 0.16571999f,
0.16249186f, 0.15926200f, 0.15603043f, 0.15279719f, 0.14956231f,
0.14632583f, 0.14308778f, 0.13984820f, 0.13660713f, 0.13336459f,
0.13012062f, 0.12687526f, 0.12362854f, 0.12038049f, 0.11713116f,
0.11388057f, 0.11062877f, 0.10737578f, 0.10412163f, 0.10086638f,
0.097610040f, 0.094352658f, 0.091094266f, 0.087834897f, 0.084574589f,
0.081313374f, 0.078051289f, 0.074788367f, 0.071524645f, 0.068260157f,
0.064994938f, 0.061729023f, 0.058462447f, 0.055195244f, 0.051927451f,
0.048659101f, 0.045390231f, 0.042120874f, 0.038851066f, 0.035580842f,
0.032310238f, 0.029039287f, 0.025768025f, 0.022496487f, 0.019224708f,
0.015952723f, 0.012680568f, 0.0094082767f, 0.0061358846f, 0.0028634269f,
-0.00040906153f, -0.0036815456f, -0.0069539902f, -0.010226360f, -0.013498621f,
-0.016770737f, -0.020042673f, -0.023314395f, -0.026585867f, -0.029857055f,
-0.033127923f, -0.036398436f, -0.039668559f, -0.042938257f, -0.046207495f,
-0.049476239f, -0.052744453f, -0.056012102f, -0.059279151f, -0.062545565f,
-0.065811309f, -0.069076349f, -0.072340649f, -0.075604174f, -0.078866890f,
-0.082128761f, -0.085389752f, -0.088649829f, -0.091908956f, -0.095167100f,
-0.098424224f, -0.10168029f, -0.10493528f, -0.10818913f, -0.11144183f,
-0.11469334f, -0.11794361f, -0.12119263f, -0.12444034f, -0.12768673f,
-0.13093174f, -0.13417536f, -0.13741753f, -0.14065824f, -0.14389744f,
-0.14713510f, -0.15037118f, -0.15360565f, -0.15683848f, -0.16006962f,
-0.16329906f, -0.16652674f, -0.16975264f, -0.17297673f, -0.17619896f,
-0.17941930f, -0.18263772f, -0.18585419f, -0.18906866f, -0.19228112f,
-0.19549151f, -0.19869981f, -0.20190598f, -0.20510998f, -0.20831180f,
-0.21151138f, -0.21470869f, -0.21790371f, -0.22109639f, -0.22428671f,
-0.22747462f, -0.23066010f, -0.23384310f, -0.23702361f, -0.24020157f,
-0.24337696f, -0.24654975f, -0.24971989f, -0.25288736f, -0.25605213f,
-0.25921415f, -0.26237339f, -0.26552983f, -0.26868342f, -0.27183413f,
-0.27498193f, -0.27812679f, -0.28126867f, -0.28440754f, -0.28754336f,
-0.29067610f, -0.29380573f, -0.29693221f, -0.30005551f, -0.30317560f,
-0.30629245f, -0.30940601f, -0.31251626f, -0.31562316f, -0.31872668f,
-0.32182679f, -0.32492345f, -0.32801664f, -0.33110631f, -0.33419243f,
-0.33727497f, -0.34035391f, -0.34342920f, -0.34650081f, -0.34956871f,
-0.35263286f, -0.35569324f, -0.35874981f, -0.36180254f, -0.36485139f,
-0.36789634f, -0.37093735f, -0.37397438f, -0.37700741f, -0.38003640f,
-0.38306132f, -0.38608214f, -0.38909883f, -0.39211135f, -0.39511967f,
-0.39812375f, -0.40112358f, -0.40411910f, -0.40711031f, -0.41009715f,
-0.41307959f, -0.41605762f, -0.41903119f, -0.42200027f, -0.42496483f,
-0.42792484f, -0.43088027f, -0.43383109f, -0.43677726f, -0.43971875f,
-0.44265553f, -0.44558757f, -0.44851484f, -0.45143731f, -0.45435494f,
-0.45726770f, -0.46017557f, -0.46307851f, -0.46597650f, -0.46886949f,
-0.47175746f, -0.47464038f, -0.47751821f, -0.48039093f, -0.48325851f,
-0.48612091f, -0.48897811f, -0.49183006f, -0.49467676f, -0.49751815f,
-0.50035422f, -0.50318492f, -0.50601024f, -0.50883014f, -0.51164459f,
-0.51445356f, -0.51725703f, -0.52005495f, -0.52284730f, -0.52563406f,
-0.52841518f, -0.53119065f, -0.53396043f, -0.53672449f, -0.53948280f,
-0.54223533f, -0.54498206f, -0.54772295f, -0.55045797f, -0.55318710f,
-0.55591031f, -0.55862756f, -0.56133883f, -0.56404409f, -0.56674331f,
-0.56943646f, -0.57212351f, -0.57480443f, -0.57747920f, -0.58014778f,
-0.58281015f, -0.58546628f, -0.58811614f, -0.59075970f, -0.59339694f,
-0.59602782f, -0.59865231f, -0.60127040f, -0.60388204f, -0.60648722f,
-0.60908591f, -0.61167807f, -0.61426368f, -0.61684271f, -0.61941514f,
-0.62198093f, -0.62454007f, -0.62709251f, -0.62963824f, -0.63217722f,
-0.63470944f, -0.63723486f, -0.63975345f, -0.64226519f, -0.64477006f,
-0.64726802f, -0.64975905f, -0.65224312f, -0.65472020f, -0.65719027f,
-0.65965331f, -0.66210928f, -0.66455816f, -0.66699992f, -0.66943454f,
-0.67186199f, -0.67428225f, -0.67669528f, -0.67910107f, -0.68149959f,
-0.68389080f, -0.68627470f, -0.68865124f, -0.69102041f, -0.69338218f,
-0.69573652f, -0.69808341f, -0.70042283f, -0.70275474f, -0.70507913f,
-0.70739597f, -0.70970524f, -0.71200690f, -0.71430093f, -0.71658732f,
-0.71886604f, -0.72113705f, -0.72340034f, -0.72565589f, -0.72790366f,
-0.73014364f, -0.73237580f, -0.73460012f, -0.73681657f, -0.73902513f,
-0.74122577f, -0.74341848f, -0.74560322f, -0.74777998f, -0.74994874f,
-0.75210946f, -0.75426212f, -0.75640671f, -0.75854320f, -0.76067157f,
-0.76279178f, -0.76490383f, -0.76700769f, -0.76910334f, -0.77119075f,
-0.77326989f, -0.77534076f, -0.77740333f, -0.77945757f, -0.78150346f,
-0.78354098f, -0.78557011f, -0.78759083f, -0.78960312f, -0.79160694f,
-0.79360229f, -0.79558915f, -0.79756748f, -0.79953727f, -0.80149850f,
-0.80345114f, -0.80539518f, -0.80733060f, -0.80925737f, -0.81117547f,
-0.81308489f, -0.81498559f, -0.81687757f, -0.81876081f, -0.82063527f,
-0.82250095f, -0.82435781f, -0.82620585f, -0.82804505f, -0.82987537f,
-0.83169681f, -0.83350933f, -0.83531294f, -0.83710760f, -0.83889329f,
-0.84067000f, -0.84243770f, -0.84419639f, -0.84594603f, -0.84768662f,
-0.84941812f, -0.85114053f, -0.85285383f, -0.85455799f, -0.85625300f,
-0.85793884f, -0.85961549f, -0.86128294f, -0.86294116f, -0.86459014f,
-0.86622986f, -0.86786031f, -0.86948146f, -0.87109330f, -0.87269581f,
-0.87428898f, -0.87587278f, -0.87744720f, -0.87901223f, -0.88056784f,
-0.88211402f, -0.88365076f, -0.88517803f, -0.88669582f, -0.88820412f,
-0.88970290f, -0.89119216f, -0.89267187f, -0.89414203f, -0.89560260f,
-0.89705359f, -0.89849497f, -0.89992673f, -0.90134885f, -0.90276131f,
-0.90416411f, -0.90555723f, -0.90694065f, -0.90831436f, -0.90967833f,
-0.91103257f, -0.91237705f, -0.91371176f, -0.91503669f, -0.91635181f,
-0.91765712f, -0.91895261f, -0.92023825f, -0.92151404f, -0.92277996f,
-0.92403600f, -0.92528214f, -0.92651837f, -0.92774468f, -0.92896106f,
-0.93016748f, -0.93136395f, -0.93255044f, -0.93372694f, -0.93489345f,
-0.93604994f, -0.93719641f, -0.93833284f, -0.93945922f, -0.94057555f,
-0.94168180f, -0.94277796f, -0.94386403f, -0.94493999f, -0.94600583f,
-0.94706154f, -0.94810711f, -0.94914252f, -0.95016777f, -0.95118284f,
-0.95218773f, -0.95318242f, -0.95416690f, -0.95514117f, -0.95610520f,
-0.95705900f, -0.95800255f, -0.95893583f, -0.95985885f, -0.96077159f,
-0.96167404f, -0.96256619f, -0.96344803f, -0.96431956f, -0.96518076f,
-0.96603162f, -0.96687213f, -0.96770230f, -0.96852209f, -0.96933152f,
-0.97013057f, -0.97091922f, -0.97169748f, -0.97246533f, -0.97322277f,
-0.97396979f, -0.97470637f, -0.97543252f, -0.97614822f, -0.97685347f,
-0.97754825f, -0.97823257f, -0.97890641f, -0.97956977f, -0.98022263f,
-0.98086500f, -0.98149687f, -0.98211822f, -0.98272906f, -0.98332937f,
-0.98391915f, -0.98449840f, -0.98506710f, -0.98562525f, -0.98617285f,
-0.98670988f, -0.98723635f, -0.98775225f, -0.98825757f, -0.98875230f,
-0.98923645f, -0.98971000f, -0.99017295f, -0.99062530f, -0.99106704f,
-0.99149817f, -0.99191868f, -0.99232857f, -0.99272783f, -0.99311645f,
-0.99349445f, -0.99386180f, -0.99421851f, -0.99456457f, -0.99489998f,
-0.99522474f, -0.99553884f, -0.99584227f, -0.99613505f, -0.99641715f,
-0.99668858f, -0.99694934f, -0.99719943f, -0.99743883f, -0.99766756f,
-0.99788559f, -0.99809295f, -0.99828961f, -0.99847558f, -0.99865086f,
-0.99881544f, -0.99896933f, -0.99911252f, -0.99924501f, -0.99936680f,
-0.99947789f, -0.99957827f, -0.99966795f, -0.99974692f, -0.99981519f,
-0.99987275f, -0.99991960f, -0.99995574f, -0.99998118f, -0.99999590f,
0.99999967f, 0.99997289f, 0.99990328f, 0.99979084f, 0.99963557f,
0.99943748f, 0.99919658f, 0.99891288f, 0.99858638f, 0.99821711f,
0.99780508f, 0.99735031f, 0.99685281f, 0.99631261f, 0.99572973f,
0.99510420f, 0.99443605f, 0.99372529f, 0.99297196f, 0.99217610f,
0.99133774f, 0.99045692f, 0.98953366f, 0.98856802f, 0.98756003f,
0.98650973f, 0.98541718f, 0.98428242f, 0.98310549f, 0.98188645f,
0.98062534f, 0.97932224f, 0.97797718f, 0.97659022f, 0.97516144f,
0.97369088f, 0.97217861f, 0.97062469f, 0.96902920f, 0.96739220f,
0.96571376f, 0.96399395f, 0.96223284f, 0.96043052f, 0.95858705f,
0.95670253f, 0.95477702f, 0.95281061f, 0.95080338f, 0.94875543f,
0.94666684f, 0.94453769f, 0.94236808f, 0.94015810f, 0.93790786f,
0.93561743f, 0.93328693f, 0.93091644f, 0.92850608f, 0.92605595f,
0.92356614f, 0.92103677f, 0.91846795f, 0.91585979f, 0.91321239f,
0.91052587f, 0.90780035f, 0.90503595f, 0.90223277f, 0.89939095f,
0.89651059f, 0.89359184f, 0.89063481f, 0.88763962f, 0.88460641f,
0.88153531f, 0.87842644f, 0.87527995f, 0.87209596f, 0.86887462f,
0.86561605f, 0.86232041f, 0.85898782f, 0.85561844f, 0.85221241f,
0.84876987f, 0.84529098f, 0.84177587f, 0.83822471f, 0.83463763f,
0.83101481f, 0.82735639f, 0.82366252f, 0.81993338f, 0.81616911f,
0.81236987f, 0.80853584f, 0.80466718f, 0.80076404f, 0.79682660f,
0.79285503f, 0.78884950f, 0.78481017f, 0.78073723f, 0.77663084f,
0.77249118f, 0.76831844f, 0.76411277f, 0.75987438f, 0.75560344f,
0.75130013f, 0.74696464f, 0.74259715f, 0.73819784f, 0.73376692f,
0.72930457f, 0.72481097f, 0.72028632f, 0.71573083f, 0.71114467f,
0.70652804f, 0.70188116f, 0.69720420f, 0.69249738f, 0.68776090f,
0.68299495f, 0.67819975f, 0.67337550f, 0.66852240f, 0.66364066f,
0.65873050f, 0.65379211f, 0.64882573f, 0.64383154f, 0.63880978f,
0.63376065f, 0.62868438f, 0.62358117f, 0.61845126f, 0.61329485f,
0.60811216f, 0.60290343f, 0.59766888f, 0.59240872f, 0.58712318f,
0.58181249f, 0.57647688f, 0.57111658f, 0.56573181f, 0.56032281f,
0.55488980f, 0.54943303f, 0.54395272f, 0.53844911f, 0.53292243f,
0.52737292f, 0.52180083f, 0.51620638f, 0.51058981f, 0.50495138f,
0.49929132f, 0.49360987f, 0.48790727f, 0.48218377f, 0.47643962f,
0.47067506f, 0.46489034f, 0.45908570f, 0.45326139f, 0.44741768f,
0.44155479f, 0.43567299f, 0.42977253f, 0.42385365f, 0.41791662f,
0.41196169f, 0.40598911f, 0.39999914f, 0.39399204f, 0.38796806f,
0.38192746f, 0.37587050f, 0.36979743f, 0.36370853f, 0.35760405f,
0.35148424f, 0.34534939f, 0.33919973f, 0.33303555f, 0.32685710f,
0.32066465f, 0.31445847f, 0.30823881f, 0.30200595f, 0.29576015f,
0.28950169f, 0.28323082f, 0.27694782f, 0.27065295f, 0.26434649f,
0.25802871f, 0.25169988f, 0.24536026f, 0.23901013f, 0.23264977f,
0.22627944f, 0.21989941f, 0.21350997f, 0.20711138f, 0.20070391f,
0.19428785f, 0.18786347f, 0.18143104f, 0.17499084f, 0.16854314f,
0.16208822f, 0.15562636f, 0.14915783f, 0.14268292f, 0.13620189f,
0.12971502f, 0.12322260f, 0.11672491f, 0.11022221f, 0.10371479f,
0.097202924f, 0.090686897f, 0.084166986f, 0.077643468f, 0.071116625f,
0.064586736f, 0.058054080f, 0.051518937f, 0.044981587f, 0.038442310f,
0.031901387f, 0.025359097f, 0.018815721f, 0.012271538f, 0.0057268303f,
-0.00081812300f, -0.0073630412f, -0.013907644f, -0.020451651f, -0.026994782f,
-0.033536757f, -0.040077295f, -0.046616116f, -0.053152941f, -0.059687488f,
-0.066219479f, -0.072748633f, -0.079274670f, -0.085797312f, -0.092316279f,
-0.098831291f, -0.10534207f, -0.11184834f, -0.11834981f, -0.12484622f,
-0.13133727f, -0.13782270f, -0.14430223f, -0.15077558f, -0.15724246f,
-0.16370261f, -0.17015575f, -0.17660160f, -0.18303989f, -0.18947033f,
-0.19589266f, -0.20230660f, -0.20871187f, -0.21510820f, -0.22149531f,
-0.22787294f, -0.23424080f, -0.24059864f, -0.24694616f, -0.25328311f,
-0.25960920f, -0.26592418f, -0.27222777f, -0.27851969f, -0.28479968f,
-0.29106748f, -0.29732280f, -0.30356539f, -0.30979497f, -0.31601129f,
-0.32221406f, -0.32840304f, -0.33457794f, -0.34073852f, -0.34688450f,
-0.35301562f, -0.35913161f, -0.36523223f, -0.37131719f, -0.37738626f,
-0.38343915f, -0.38947562f, -0.39549541f, -0.40149825f, -0.40748390f,
-0.41345209f, -0.41940257f, -0.42533508f, -0.43124938f, -0.43714520f,
-0.44302229f, -0.44888041f, -0.45471930f, -0.46053871f, -0.46633839f,
-0.47211810f, -0.47787758f, -0.48361659f, -0.48933489f, -0.49503222f,
-0.50070835f, -0.50636303f, -0.51199602f, -0.51760707f, -0.52319595f,
-0.52876243f, -0.53430625f, -0.53982718f, -0.54532499f, -0.55079944f,
-0.55625029f, -0.56167732f, -0.56708028f, -0.57245896f, -0.57781311f,
-0.58314251f, -0.58844693f, -0.59372614f, -0.59897992f, -0.60420805f,
-0.60941029f, -0.61458642f, -0.61973623f, -0.62485949f, -0.62995598f,
-0.63502549f, -0.64006780f, -0.64508268f, -0.65006994f, -0.65502934f,
-0.65996069f, -0.66486377f, -0.66973837f, -0.67458427f, -0.67940128f,
-0.68418919f, -0.68894779f, -0.69367688f, -0.69837625f, -0.70304571f,
-0.70768504f, -0.71229407f, -0.71687258f, -0.72142039f, -0.72593729f,
-0.73042309f, -0.73487761f, -0.73930064f, -0.74369201f, -0.74805152f,
-0.75237898f, -0.75667422f, -0.76093704f, -0.76516727f, -0.76936471f,
-0.77352921f, -0.77766056f, -0.78175861f, -0.78582316f, -0.78985406f,
-0.79385112f, -0.79781417f, -0.80174305f, -0.80563758f, -0.80949760f,
-0.81332295f, -0.81711346f, -0.82086896f, -0.82458930f, -0.82827432f,
-0.83192386f, -0.83553776f, -0.83911587f, -0.84265803f, -0.84616410f,
-0.84963392f, -0.85306735f, -0.85646423f, -0.85982442f, -0.86314779f,
-0.86643418f, -0.86968345f, -0.87289547f, -0.87607009f, -0.87920719f,
-0.88230663f, -0.88536827f, -0.88839199f, -0.89137765f, -0.89432512f,
-0.89723429f, -0.90010502f, -0.90293719f, -0.90573069f, -0.90848539f,
-0.91120117f, -0.91387791f, -0.91651551f, -0.91911385f, -0.92167282f,
-0.92419231f, -0.92667220f, -0.92911240f, -0.93151280f, -0.93387330f,
-0.93619380f, -0.93847419f, -0.94071438f, -0.94291427f, -0.94507377f,
-0.94719279f, -0.94927123f, -0.95130901f, -0.95330604f, -0.95526223f,
-0.95717750f, -0.95905177f, -0.96088496f, -0.96267699f, -0.96442777f,
-0.96613725f, -0.96780534f, -0.96943197f, -0.97101707f, -0.97256058f,
-0.97406243f, -0.97552255f, -0.97694089f, -0.97831737f, -0.97965195f,
-0.98094456f, -0.98219515f, -0.98340367f, -0.98457006f, -0.98569428f,
-0.98677627f, -0.98781599f, -0.98881340f, -0.98976845f, -0.99068110f,
-0.99155132f, -0.99237906f, -0.99316428f, -0.99390697f, -0.99460708f,
-0.99526458f, -0.99587945f, -0.99645166f, -0.99698119f, -0.99746801f,
-0.99791210f, -0.99831344f, -0.99867202f, -0.99898782f, -0.99926082f,
-0.99949102f, -0.99967841f, -0.99982297f, -0.99992470f, -0.99998360f,
0.99999866f, 0.99989157f, 0.99961315f, 0.99916346f, 0.99854256f,
0.99775057f, 0.99678762f, 0.99565388f, 0.99434953f, 0.99287481f,
0.99122996f, 0.98941527f, 0.98743105f, 0.98527764f, 0.98295541f,
0.98046475f, 0.97780610f, 0.97497990f, 0.97198664f, 0.96882685f,
0.96550104f, 0.96200980f, 0.95835373f, 0.95453345f, 0.95054962f,
0.94640291f, 0.94209404f, 0.93762375f, 0.93299280f, 0.92820199f,
0.92325213f, 0.91814408f, 0.91287871f, 0.90745693f, 0.90187965f,
0.89614785f, 0.89026249f, 0.88422459f, 0.87803519f, 0.87169533f,
0.86520612f, 0.85856866f, 0.85178409f, 0.84485357f, 0.83777828f,
0.83055945f, 0.82319831f, 0.81569611f, 0.80805415f, 0.80027373f,
0.79235620f, 0.78430289f, 0.77611520f, 0.76779452f, 0.75934229f,
0.75075995f, 0.74204897f, 0.73321084f, 0.72424708f, 0.71515923f,
0.70594883f, 0.69661748f, 0.68716676f, 0.67759830f, 0.66791374f,
0.65811474f, 0.64820297f, 0.63818013f, 0.62804795f, 0.61780815f,
0.60746249f, 0.59701275f, 0.58646072f, 0.57580819f, 0.56505701f,
0.55420900f, 0.54326604f, 0.53222998f, 0.52110274f, 0.50988620f,
0.49858230f, 0.48719297f, 0.47572016f, 0.46416584f, 0.45253199f,
0.44082059f, 0.42903367f, 0.41717323f, 0.40524131f, 0.39323996f,
0.38117123f, 0.36903718f, 0.35683990f, 0.34458148f, 0.33226402f,
0.31988962f, 0.30746042f, 0.29497853f, 0.28244610f, 0.26986527f,
0.25723821f, 0.24456706f, 0.23185402f, 0.21910124f, 0.20631092f,
0.19348526f, 0.18062644f, 0.16773667f, 0.15481816f, 0.14187312f,
0.12890377f, 0.11591234f, 0.10290104f, 0.089872115f, 0.076827789f,
0.063770300f, 0.050701883f, 0.037624779f, 0.024541229f, 0.011453473f,
-0.0016362454f, -0.014725683f, -0.027812598f, -0.040894747f, -0.053969889f,
-0.067035784f, -0.080090192f, -0.093130877f, -0.10615561f, -0.11916214f,
-0.13214826f, -0.14511174f, -0.15805036f, -0.17096189f, -0.18384413f,
-0.19669487f, -0.20951190f, -0.22229304f, -0.23503609f, -0.24773886f,
-0.26039919f, -0.27301490f, -0.28558383f, -0.29810383f, -0.31057274f,
-0.32298845f, -0.33534881f, -0.34765171f, -0.35989504f, -0.37207670f,
-0.38419461f, -0.39624670f, -0.40823088f, -0.42014512f, -0.43198737f,
-0.44375560f, -0.45544780f, -0.46706195f, -0.47859608f, -0.49004821f,
-0.50141636f, -0.51269860f, -0.52389299f, -0.53499762f, -0.54601058f,
-0.55692998f, -0.56775395f, -0.57848064f, -0.58910822f, -0.59963485f,
-0.61005873f, -0.62037809f, -0.63059115f, -0.64069616f, -0.65069139f,
-0.66057513f, -0.67034568f, -0.68000137f, -0.68954054f, -0.69896157f,
-0.70826283f, -0.71744274f, -0.72649972f, -0.73543221f, -0.74423869f,
-0.75291765f, -0.76146760f, -0.76988708f, -0.77817464f, -0.78632887f,
-0.79434836f, -0.80223175f, -0.80997767f, -0.81758481f, -0.82505187f,
-0.83237755f, -0.83956061f, -0.84659981f, -0.85349396f, -0.86024186f,
-0.86684237f, -0.87329434f, -0.87959669f, -0.88574831f, -0.89174817f,
-0.89759523f, -0.90328850f, -0.90882699f, -0.91420976f, -0.91943588f,
-0.92450446f, -0.92941463f, -0.93416555f, -0.93875641f, -0.94318642f,
-0.94745482f, -0.95156087f, -0.95550388f, -0.95928317f, -0.96289809f,
-0.96634802f, -0.96963238f, -0.97275059f, -0.97570213f, -0.97848649f,
-0.98110318f, -0.98355177f, -0.98583184f, -0.98794298f, -0.98988485f,
-0.99165711f, -0.99325945f, -0.99469160f, -0.99595331f, -0.99704438f,
-0.99796460f, -0.99871383f, -0.99929194f, -0.99969882f, -0.99993441f,
};
#endif

static const CELTMode mode96000_1920_240 = {
96000,    /* Fs */
240,    /* overlap */
21,    /* nbEBands */
21,    /* effEBands */
{0.92300415f, 0.22000122f, 1.5128347f, 0.66101074f, },    /* preemph */
eband5ms,    /* eBands */
3,    /* maxLM */
8,    /* nbShortMdcts */
240,    /* shortMdctSize */
11,    /* nbAllocVectors */
band_allocation,    /* allocVectors */
logN400,    /* logN */
window240,    /* window */
{3840, 3, {&fft_state96000_1920_0, &fft_state96000_1920_1, &fft_state96000_1920_2, &fft_state96000_1920_3, }, mdct_twiddles1920},    /* mdct */
{392, cache_index50, cache_bits50, cache_caps50},    /* cache */
#ifdef ENABLE_QEXT
{86, qext_cache_index50, qext_cache_bits50, qext_cache_caps50},    /* qext_cache */
#endif
};
#endif /* ENABLE_QEXT */

/* List of all the available modes */
#ifdef ENABLE_QEXT
#define TOTAL_MODES 2
static const CELTMode * const static_mode_list[TOTAL_MODES] = {
&mode48000_960_120,
&mode96000_1920_240,
};
#else
#define TOTAL_MODES 1
static const CELTMode * const static_mode_list[TOTAL_MODES] = {
&mode48000_960_120,
};
#endif
