
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "autosaver_wrapper.h"

// Wrappers providing overrides
#include "webview_wrapper.h"

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_AutoSaver_Type = nullptr;
static PyTypeObject *Sbk_AutoSaver_TypeF(void)
{
    return _Sbk_AutoSaver_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void AutoSaverWrapper::pysideInitQtMetaTypes()
{
}

void AutoSaverWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

AutoSaverWrapper::AutoSaverWrapper(::QObject * parent) : AutoSaver(parent)
{
}

void AutoSaverWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_AutoSaver_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    WebViewWrapper::sbk_o_childEvent("AutoSaver", funcName, gil, pyOverride, event);
}

void AutoSaverWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_AutoSaver_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("AutoSaver", funcName, gil, pyOverride, signal);
}

void AutoSaverWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_AutoSaver_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    WebViewWrapper::sbk_o_customEvent("AutoSaver", funcName, gil, pyOverride, event);
}

void AutoSaverWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_AutoSaver_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("AutoSaver", funcName, gil, pyOverride, signal);
}

bool AutoSaverWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_AutoSaver_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::event(event);
    }
    return WebViewWrapper::sbk_o_event("AutoSaver", funcName, gil, pyOverride, event);
}

bool AutoSaverWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_AutoSaver_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return WebViewWrapper::sbk_o_eventFilter("AutoSaver", funcName, gil, pyOverride, watched, event);
}

const QMetaObject *AutoSaverWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return AutoSaver::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int AutoSaverWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = AutoSaver::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *AutoSaverWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< AutoSaverWrapper *>(this));
    }
    return AutoSaver::qt_metacast(_clname);
}

AutoSaverWrapper::~AutoSaverWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_AutoSaver_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_AutoSaver_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::AutoSaver >()))
        return -1;

    AutoSaverWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|O:AutoSaver", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: AutoSaver::AutoSaver(QObject*=)
    if (numArgs == 0) {
        overloadId = 0; // AutoSaver(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))) {
        overloadId = 0; // AutoSaver(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_AutoSaver_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkPyFalkonTypeStructs[SBK_AutoSaver_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_AutoSaver_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // AutoSaver(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) AutoSaverWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new AutoSaverWrapper(cppArg0);
            }

            // Ownership transferences (constructor heuristics).
            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< AutoSaver >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_AutoSaver_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_AutoSaver_IDX]);
    };


    return 1;
}

static PyObject *Sbk_AutoSaverFunc_changeOccurred(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<AutoSaverWrapper *>(reinterpret_cast< ::AutoSaver *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_AutoSaver_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // changeOccurred()
        cppSelf->changeOccurred();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_AutoSaverFunc_saveIfNecessary(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<AutoSaverWrapper *>(reinterpret_cast< ::AutoSaver *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_AutoSaver_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // saveIfNecessary()
        cppSelf->saveIfNecessary();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_AutoSaverFunc_timerEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<AutoSaverWrapper *>(reinterpret_cast< ::AutoSaver *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_AutoSaver_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QObject::timerEvent(QTimerEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QTimerEvent_IDX]), (pyArg)))) {
        overloadId = 0; // timerEvent(QTimerEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "timerEvent", errInfo, SbkPyFalkonTypeStructs[SBK_AutoSaver_IDX]);

    // Call function/method
    {
        Shiboken::Errors::setPrivateMethod("timerEvent(QTimerEvent *event)");
        return {};
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_AutoSaver_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_AutoSaver_methods[] = {
    {"changeOccurred", reinterpret_cast<PyCFunction>(Sbk_AutoSaverFunc_changeOccurred), METH_NOARGS, nullptr},
    {"saveIfNecessary", reinterpret_cast<PyCFunction>(Sbk_AutoSaverFunc_saveIfNecessary), METH_NOARGS, nullptr},
    {"timerEvent", reinterpret_cast<PyCFunction>(Sbk_AutoSaverFunc_timerEvent), METH_O, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_AutoSaver_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::AutoSaver *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_AutoSaver_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<AutoSaverWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_AutoSaver_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_AutoSaver_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_AutoSaver_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_AutoSaver_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_AutoSaver_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_AutoSaver_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_AutoSaver_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_AutoSaver_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_AutoSaver_spec = {
    "1:PyFalkon.AutoSaver",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_AutoSaver_slots
};

} //extern "C"

static void *Sbk_AutoSaver_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::AutoSaver *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void AutoSaver_PythonToCpp_AutoSaver_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_AutoSaver_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_AutoSaver_PythonToCpp_AutoSaver_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_AutoSaver_TypeF()))
        return AutoSaver_PythonToCpp_AutoSaver_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *AutoSaver_PTR_CppToPython_AutoSaver(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::AutoSaver *>(const_cast<void *>(cppIn)), Sbk_AutoSaver_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *AutoSaver_SignatureStrings[] = {
    "PyFalkon.AutoSaver(self,parent:PySide6.QtCore.QObject=nullptr)",
    "PyFalkon.AutoSaver.changeOccurred(self)",
    "PyFalkon.AutoSaver.saveIfNecessary(self)",
    "PyFalkon.AutoSaver.timerEvent(self,event:PySide6.QtCore.QTimerEvent)",
    nullptr}; // Sentinel
#else
static constexpr size_t AutoSaver_SignatureByteSize = 130;
static constexpr uint8_t AutoSaver_SignatureBytes[130] = {
    0x78, 0xda, 0x0b, 0xa8, 0x74, 0x4b, 0xcc, 0xc9, 0xce, 0xcf, 0xd3, 0x73, 0x2c, 0x2d, 0xc9, 0x0f,
    0x4e, 0x2c, 0x4b, 0x2d, 0xd2, 0x28, 0x4e, 0xcd, 0x49, 0xd3, 0x29, 0x48, 0x2c, 0x4a, 0xcd, 0x2b,
    0xb1, 0x0a, 0xa8, 0x0c, 0xce, 0x4c, 0x49, 0x35, 0xd3, 0x0b, 0x2c, 0x71, 0xce, 0x2f, 0x4a, 0xd5,
    0x0b, 0xf4, 0x4f, 0xca, 0x4a, 0x4d, 0x2e, 0xb1, 0xcd, 0x2b, 0xcd, 0xc9, 0x29, 0x28, 0x29, 0xd2,
    0xe4, 0x0a, 0xc0, 0xd0, 0xae, 0x97, 0x9c, 0x91, 0x98, 0x97, 0x9e, 0xea, 0x9f, 0x9c, 0x5c, 0x5a,
    0x54, 0x94, 0x9a, 0x02, 0x36, 0x0d, 0xab, 0xba, 0x62, 0x20, 0xe9, 0x99, 0xe6, 0x97, 0x9a, 0x9c,
    0x5a, 0x5c, 0x9c, 0x58, 0x54, 0x89, 0x5b, 0x61, 0x49, 0x66, 0x6e, 0x6a, 0x91, 0x6b, 0x19, 0xd0,
    0x39, 0x10, 0xa7, 0xa5, 0x96, 0x61, 0x73, 0x59, 0x08, 0x5c, 0x95, 0x26, 0x17, 0x00, 0xdf, 0xbd,
    0x4e, 0x38
};
#endif

PyTypeObject *init_AutoSaver(PyObject *module)
{
    if (SbkPyFalkonTypeStructs[SBK_AutoSaver_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_AutoSaver_IDX].type;

    Shiboken::AutoDecRef Sbk_AutoSaver_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))));

    _Sbk_AutoSaver_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "AutoSaver",
        "AutoSaver*",
        &Sbk_AutoSaver_spec,
        &Shiboken::callCppDestructor< AutoSaver >,
        Sbk_AutoSaver_Type_bases.object(),
        0);
    auto *pyType = _Sbk_AutoSaver_Type; // references _Sbk_AutoSaver_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, AutoSaver_SignatureStrings);
#else
    InitSignatureBytes(pyType, AutoSaver_SignatureBytes, AutoSaver_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_AutoSaver_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_AutoSaver_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        AutoSaver_PythonToCpp_AutoSaver_PTR,
        is_AutoSaver_PythonToCpp_AutoSaver_PTR_Convertible,
        AutoSaver_PTR_CppToPython_AutoSaver);

    Shiboken::Conversions::registerConverterName(converter, "AutoSaver");
    Shiboken::Conversions::registerConverterName(converter, "AutoSaver*");
    Shiboken::Conversions::registerConverterName(converter, "AutoSaver&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::AutoSaver).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(AutoSaverWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_AutoSaver_TypeF(), &Sbk_AutoSaver_typeDiscovery);

    PySide::Signal::registerSignals(pyType, &::AutoSaver::staticMetaObject);
    AutoSaverWrapper::pysideInitQtMetaTypes();
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::AutoSaver::staticMetaObject, sizeof(AutoSaverWrapper));

    return pyType;
}
