// Code generated by smithy-go-codegen DO NOT EDIT.

package cloudformation

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cloudformation/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Retrieves detailed information and remediation guidance for a Hook invocation
// result.
//
// If the Hook uses a KMS key to encrypt annotations, callers of the GetHookResult
// operation must have kms:Decrypt permissions. For more information, see [KMS key policy and permissions for encrypting CloudFormation Hooks results at rest] in the
// CloudFormation Hooks User Guide.
//
// [KMS key policy and permissions for encrypting CloudFormation Hooks results at rest]: https://docs.aws.amazon.com/cloudformation-cli/latest/hooks-userguide/hooks-kms-key-policy.html
func (c *Client) GetHookResult(ctx context.Context, params *GetHookResultInput, optFns ...func(*Options)) (*GetHookResultOutput, error) {
	if params == nil {
		params = &GetHookResultInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetHookResult", params, optFns, c.addOperationGetHookResultMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetHookResultOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetHookResultInput struct {

	// The unique identifier (ID) of the Hook invocation result that you want details
	// about. You can get the ID from the [ListHookResults]operation.
	//
	// [ListHookResults]: https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ListHookResults.html
	HookResultId *string

	noSmithyDocumentSerde
}

type GetHookResultOutput struct {

	// A list of objects with additional information and guidance that can help you
	// resolve a failed Hook invocation.
	Annotations []types.Annotation

	// The failure mode of the invocation.
	FailureMode types.HookFailureMode

	// The unique identifier of the Hook result.
	HookResultId *string

	// A message that provides additional details about the Hook invocation status.
	HookStatusReason *string

	// The specific point in the provisioning process where the Hook is invoked.
	InvocationPoint types.HookInvocationPoint

	// The timestamp when the Hook was invoked.
	InvokedAt *time.Time

	// The original public type name of the Hook when an alias is used.
	//
	// For example, if you activate AWS::Hooks::GuardHook with alias
	// MyCompany::Custom::GuardHook , then TypeName will be
	// MyCompany::Custom::GuardHook and OriginalTypeName will be AWS::Hooks::GuardHook
	// .
	OriginalTypeName *string

	// The status of the Hook invocation. The following statuses are possible:
	//
	//   - HOOK_IN_PROGRESS : The Hook is currently running.
	//
	//   - HOOK_COMPLETE_SUCCEEDED : The Hook completed successfully.
	//
	//   - HOOK_COMPLETE_FAILED : The Hook completed but failed validation.
	//
	//   - HOOK_FAILED : The Hook encountered an error during execution.
	Status types.HookStatus

	// Information about the target of the Hook invocation.
	Target *types.HookTarget

	// The Amazon Resource Name (ARN) of the Hook.
	TypeArn *string

	// The version identifier of the Hook configuration data that was used during
	// invocation.
	TypeConfigurationVersionId *string

	// The name of the Hook that was invoked.
	TypeName *string

	// The version identifier of the Hook that was invoked.
	TypeVersionId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetHookResultMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsquery_serializeOpGetHookResult{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsquery_deserializeOpGetHookResult{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetHookResult"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetHookResult(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetHookResult(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetHookResult",
	}
}
