/* bookmarks-window.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from bookmarks-window.vala, do not modify */

/*
  This file is part of Dconf Editor

  Dconf Editor is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  Dconf Editor is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with Dconf Editor.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gdk/gdk.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_ADAPTATIVE_WINDOW (adaptative_window_get_type ())
#define ADAPTATIVE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ADAPTATIVE_WINDOW, AdaptativeWindow))
#define ADAPTATIVE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ADAPTATIVE_WINDOW, AdaptativeWindowClass))
#define IS_ADAPTATIVE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ADAPTATIVE_WINDOW))
#define IS_ADAPTATIVE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ADAPTATIVE_WINDOW))
#define ADAPTATIVE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ADAPTATIVE_WINDOW, AdaptativeWindowClass))

typedef struct _AdaptativeWindow AdaptativeWindow;
typedef struct _AdaptativeWindowClass AdaptativeWindowClass;
typedef struct _AdaptativeWindowPrivate AdaptativeWindowPrivate;

#define TYPE_ADAPTATIVE_WIDGET (adaptative_widget_get_type ())
#define ADAPTATIVE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ADAPTATIVE_WIDGET, AdaptativeWidget))
#define IS_ADAPTATIVE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ADAPTATIVE_WIDGET))
#define ADAPTATIVE_WIDGET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ADAPTATIVE_WIDGET, AdaptativeWidgetIface))

typedef struct _AdaptativeWidget AdaptativeWidget;
typedef struct _AdaptativeWidgetIface AdaptativeWidgetIface;
typedef enum  {
	ADAPTATIVE_WIDGET_WINDOW_SIZE_START_SIZE,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_USUAL_SIZE,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_QUITE_THIN,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_VERT,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_HZTL,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_BOTH,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_EXTRA_THIN,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_EXTRA_FLAT
} AdaptativeWidgetWindowSize;

#define ADAPTATIVE_WIDGET_TYPE_WINDOW_SIZE (adaptative_widget_window_size_get_type ())

#define TYPE_BASE_WINDOW (base_window_get_type ())
#define BASE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BASE_WINDOW, BaseWindow))
#define BASE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BASE_WINDOW, BaseWindowClass))
#define IS_BASE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BASE_WINDOW))
#define IS_BASE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BASE_WINDOW))
#define BASE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BASE_WINDOW, BaseWindowClass))

typedef struct _BaseWindow BaseWindow;
typedef struct _BaseWindowClass BaseWindowClass;
typedef struct _BaseWindowPrivate BaseWindowPrivate;

#define TYPE_BROWSER_WINDOW (browser_window_get_type ())
#define BROWSER_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BROWSER_WINDOW, BrowserWindow))
#define BROWSER_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BROWSER_WINDOW, BrowserWindowClass))
#define IS_BROWSER_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BROWSER_WINDOW))
#define IS_BROWSER_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BROWSER_WINDOW))
#define BROWSER_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BROWSER_WINDOW, BrowserWindowClass))

typedef struct _BrowserWindow BrowserWindow;
typedef struct _BrowserWindowClass BrowserWindowClass;
typedef struct _BrowserWindowPrivate BrowserWindowPrivate;
typedef enum  {
	VIEW_TYPE_OBJECT,
	VIEW_TYPE_FOLDER,
	VIEW_TYPE_SEARCH,
	VIEW_TYPE_CONFIG
} ViewType;

#define TYPE_VIEW_TYPE (view_type_get_type ())

#define TYPE_BOOKMARKS_WINDOW (bookmarks_window_get_type ())
#define BOOKMARKS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOKMARKS_WINDOW, BookmarksWindow))
#define BOOKMARKS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOKMARKS_WINDOW, BookmarksWindowClass))
#define IS_BOOKMARKS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOKMARKS_WINDOW))
#define IS_BOOKMARKS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOKMARKS_WINDOW))
#define BOOKMARKS_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOKMARKS_WINDOW, BookmarksWindowClass))

typedef struct _BookmarksWindow BookmarksWindow;
typedef struct _BookmarksWindowClass BookmarksWindowClass;
typedef struct _BookmarksWindowPrivate BookmarksWindowPrivate;
typedef enum  {
	BOOKMARK_ICON_VALID_FOLDER,
	BOOKMARK_ICON_SEARCH,
	BOOKMARK_ICON_DCONF_OBJECT,
	BOOKMARK_ICON_KEY_DEFAULTS,
	BOOKMARK_ICON_EDITED_VALUE,
	BOOKMARK_ICON_EMPTY_FOLDER,
	BOOKMARK_ICON_EMPTY_OBJECT
} BookmarkIcon;

#define TYPE_BOOKMARK_ICON (bookmark_icon_get_type ())

#define TYPE_BASE_HEADER_BAR (base_header_bar_get_type ())
#define BASE_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BASE_HEADER_BAR, BaseHeaderBar))
#define BASE_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BASE_HEADER_BAR, BaseHeaderBarClass))
#define IS_BASE_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BASE_HEADER_BAR))
#define IS_BASE_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BASE_HEADER_BAR))
#define BASE_HEADER_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BASE_HEADER_BAR, BaseHeaderBarClass))

typedef struct _BaseHeaderBar BaseHeaderBar;
typedef struct _BaseHeaderBarClass BaseHeaderBarClass;

#define TYPE_BROWSER_HEADER_BAR (browser_header_bar_get_type ())
#define BROWSER_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BROWSER_HEADER_BAR, BrowserHeaderBar))
#define BROWSER_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BROWSER_HEADER_BAR, BrowserHeaderBarClass))
#define IS_BROWSER_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BROWSER_HEADER_BAR))
#define IS_BROWSER_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BROWSER_HEADER_BAR))
#define BROWSER_HEADER_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BROWSER_HEADER_BAR, BrowserHeaderBarClass))

typedef struct _BrowserHeaderBar BrowserHeaderBar;
typedef struct _BrowserHeaderBarClass BrowserHeaderBarClass;

#define TYPE_BOOKMARKS_HEADER_BAR (bookmarks_header_bar_get_type ())
#define BOOKMARKS_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOKMARKS_HEADER_BAR, BookmarksHeaderBar))
#define BOOKMARKS_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOKMARKS_HEADER_BAR, BookmarksHeaderBarClass))
#define IS_BOOKMARKS_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOKMARKS_HEADER_BAR))
#define IS_BOOKMARKS_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOKMARKS_HEADER_BAR))
#define BOOKMARKS_HEADER_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOKMARKS_HEADER_BAR, BookmarksHeaderBarClass))

typedef struct _BookmarksHeaderBar BookmarksHeaderBar;
typedef struct _BookmarksHeaderBarClass BookmarksHeaderBarClass;

#define TYPE_BASE_VIEW (base_view_get_type ())
#define BASE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BASE_VIEW, BaseView))
#define BASE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BASE_VIEW, BaseViewClass))
#define IS_BASE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BASE_VIEW))
#define IS_BASE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BASE_VIEW))
#define BASE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BASE_VIEW, BaseViewClass))

typedef struct _BaseView BaseView;
typedef struct _BaseViewClass BaseViewClass;

#define TYPE_BROWSER_VIEW (browser_view_get_type ())
#define BROWSER_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BROWSER_VIEW, BrowserView))
#define BROWSER_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BROWSER_VIEW, BrowserViewClass))
#define IS_BROWSER_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BROWSER_VIEW))
#define IS_BROWSER_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BROWSER_VIEW))
#define BROWSER_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BROWSER_VIEW, BrowserViewClass))

typedef struct _BrowserView BrowserView;
typedef struct _BrowserViewClass BrowserViewClass;

#define TYPE_BOOKMARKS_VIEW (bookmarks_view_get_type ())
#define BOOKMARKS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOKMARKS_VIEW, BookmarksView))
#define BOOKMARKS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOKMARKS_VIEW, BookmarksViewClass))
#define IS_BOOKMARKS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOKMARKS_VIEW))
#define IS_BOOKMARKS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOKMARKS_VIEW))
#define BOOKMARKS_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOKMARKS_VIEW, BookmarksViewClass))

typedef struct _BookmarksView BookmarksView;
typedef struct _BookmarksViewClass BookmarksViewClass;
enum  {
	BOOKMARKS_WINDOW_0_PROPERTY,
	BOOKMARKS_WINDOW_NUM_PROPERTIES
};
static GParamSpec* bookmarks_window_properties[BOOKMARKS_WINDOW_NUM_PROPERTIES];
typedef void (*GSimpleActionActivateCallback) (GSimpleAction* action, GVariant* parameter, gpointer user_data);
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef enum  {
	OVERLAYED_LIST_SELECTION_STATE_EMPTY,
	OVERLAYED_LIST_SELECTION_STATE_UNIQUE,
	OVERLAYED_LIST_SELECTION_STATE_FIRST,
	OVERLAYED_LIST_SELECTION_STATE_LAST,
	OVERLAYED_LIST_SELECTION_STATE_MIDDLE,
	OVERLAYED_LIST_SELECTION_STATE_MULTIPLE,
	OVERLAYED_LIST_SELECTION_STATE_MULTIPLE_FIRST,
	OVERLAYED_LIST_SELECTION_STATE_MULTIPLE_LAST,
	OVERLAYED_LIST_SELECTION_STATE_ALL
} OverlayedListSelectionState;

#define OVERLAYED_LIST_TYPE_SELECTION_STATE (overlayed_list_selection_state_get_type ())
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _AdaptativeWindow {
	GtkApplicationWindow parent_instance;
	AdaptativeWindowPrivate * priv;
};

struct _AdaptativeWindowClass {
	GtkApplicationWindowClass parent_class;
	void (*before_destroy) (AdaptativeWindow* self);
};

struct _AdaptativeWidgetIface {
	GTypeInterface parent_iface;
	void (*set_window_size) (AdaptativeWidget* self, AdaptativeWidgetWindowSize new_size);
};

struct _BaseWindow {
	AdaptativeWindow parent_instance;
	BaseWindowPrivate * priv;
};

struct _BaseWindowClass {
	AdaptativeWindowClass parent_class;
	gboolean (*handle_copy_text) (BaseWindow* self, gchar** copy_text);
	gboolean (*get_alt_copy_text) (BaseWindow* self, gchar** copy_text);
	void (*paste_text) (BaseWindow* self, const gchar* text);
	void (*menu_pressed) (BaseWindow* self);
	gboolean (*on_key_press_event) (BaseWindow* self, GtkWidget* widget, GdkEventKey* event);
	void (*set_window_size) (BaseWindow* self, AdaptativeWidgetWindowSize new_size);
	void (*close_in_window_panels) (BaseWindow* self);
	gboolean (*escape_pressed) (BaseWindow* self);
	void (*show_default_view) (BaseWindow* self);
};

struct _BrowserWindow {
	BaseWindow parent_instance;
	BrowserWindowPrivate * priv;
	gchar* current_path;
	ViewType current_type;
	ViewType saved_type;
	gchar* saved_view;
	gchar* saved_selection;
	GSimpleAction* reload_search_action;
};

struct _BrowserWindowClass {
	BaseWindowClass parent_class;
	void (*request_folder) (BrowserWindow* self, const gchar* full_name, const gchar* selected_or_empty, gboolean notify_missing);
	void (*request_object) (BrowserWindow* self, const gchar* full_name, guint16 context_id, gboolean notify_missing, const gchar* schema_id);
	void (*request_config) (BrowserWindow* self, const gchar* full_name);
	void (*reconfigure_search) (BrowserWindow* self, gboolean local_search);
	gboolean (*intercept_next_match) (BrowserWindow* self, gboolean* interception_result);
	gboolean (*intercept_previous_match) (BrowserWindow* self, gboolean* interception_result);
};

struct _BookmarksWindow {
	BrowserWindow parent_instance;
	BookmarksWindowPrivate * priv;
};

struct _BookmarksWindowClass {
	BrowserWindowClass parent_class;
	BookmarkIcon (*get_bookmark_icon) (BookmarksWindow* self, gchar** bookmark);
	void (*toggle_bookmark_called) (BookmarksWindow* self);
};

struct _BookmarksWindowPrivate {
	BookmarksHeaderBar* headerbar;
	BookmarksView* main_view;
	gulong bookmarks_selection_changed_handler;
	gulong headerbar_update_bookmarks_icons_handler;
	gulong main_view_update_bookmarks_icons_handler;
	gboolean disable_popovers;
	gboolean actions_init_done;
	GSimpleAction* move_top_action;
	GSimpleAction* move_up_action;
	GSimpleAction* move_down_action;
	GSimpleAction* move_bottom_action;
	GSimpleAction* trash_bookmark_action;
	GSimpleAction* edit_mode_state_action;
};

static gint BookmarksWindow_private_offset;
static gpointer bookmarks_window_parent_class = NULL;
static AdaptativeWidgetIface * bookmarks_window_adaptative_widget_parent_iface = NULL;

VALA_EXTERN GType adaptative_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AdaptativeWindow, g_object_unref)
VALA_EXTERN GType adaptative_widget_window_size_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType adaptative_widget_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AdaptativeWidget, g_object_unref)
VALA_EXTERN GType base_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BaseWindow, g_object_unref)
VALA_EXTERN GType browser_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BrowserWindow, g_object_unref)
VALA_EXTERN GType view_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType bookmarks_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookmarksWindow, g_object_unref)
VALA_EXTERN GType bookmark_icon_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType base_header_bar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BaseHeaderBar, g_object_unref)
VALA_EXTERN GType browser_header_bar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BrowserHeaderBar, g_object_unref)
VALA_EXTERN GType bookmarks_header_bar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookmarksHeaderBar, g_object_unref)
VALA_EXTERN GType base_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BaseView, g_object_unref)
VALA_EXTERN GType browser_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BrowserView, g_object_unref)
VALA_EXTERN GType bookmarks_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookmarksView, g_object_unref)
VALA_EXTERN void adaptative_window_before_destroy (AdaptativeWindow* self);
VALA_EXTERN gboolean base_window_escape_pressed (BaseWindow* self);
VALA_EXTERN void base_window_show_default_view (BaseWindow* self);
VALA_EXTERN BookmarkIcon bookmarks_window_get_bookmark_icon (BookmarksWindow* self,
                                                 gchar** bookmark);
VALA_EXTERN void base_window_set_window_size (BaseWindow* self,
                                  AdaptativeWidgetWindowSize new_size);
VALA_EXTERN void bookmarks_window_toggle_bookmark_called (BookmarksWindow* self);
VALA_EXTERN gboolean browser_window_intercept_next_match (BrowserWindow* self,
                                              gboolean* interception_result);
VALA_EXTERN gboolean browser_window_intercept_previous_match (BrowserWindow* self,
                                                  gboolean* interception_result);
static void bookmarks_window_show_use_bookmarks_view (BookmarksWindow* self);
static void _bookmarks_window_show_use_bookmarks_view_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                 GVariant* parameter,
                                                                                 gpointer self);
static void bookmarks_window_update_bookmarks_icons (BookmarksWindow* self,
                                              GSimpleAction* action,
                                              GVariant* bookmarks_variant);
static void _bookmarks_window_update_bookmarks_icons_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                GVariant* parameter,
                                                                                gpointer self);
static void bookmarks_window_toggle_bookmark (BookmarksWindow* self);
static void _bookmarks_window_toggle_bookmark_gsimple_action_activate_callback (GSimpleAction* action,
                                                                         GVariant* parameter,
                                                                         gpointer self);
static void bookmarks_window_bookmark (BookmarksWindow* self);
static void _bookmarks_window_bookmark_gsimple_action_activate_callback (GSimpleAction* action,
                                                                  GVariant* parameter,
                                                                  gpointer self);
static void bookmarks_window_unbookmark (BookmarksWindow* self);
static void _bookmarks_window_unbookmark_gsimple_action_activate_callback (GSimpleAction* action,
                                                                    GVariant* parameter,
                                                                    gpointer self);
static void bookmarks_window_set_edit_mode (BookmarksWindow* self,
                                     GSimpleAction* action,
                                     GVariant* variant);
static void _bookmarks_window_set_edit_mode_gsimple_action_activate_callback (GSimpleAction* action,
                                                                       GVariant* parameter,
                                                                       gpointer self);
static void bookmarks_window_trash_bookmark (BookmarksWindow* self);
static void _bookmarks_window_trash_bookmark_gsimple_action_activate_callback (GSimpleAction* action,
                                                                        GVariant* parameter,
                                                                        gpointer self);
static void bookmarks_window_move_top (BookmarksWindow* self);
static void _bookmarks_window_move_top_gsimple_action_activate_callback (GSimpleAction* action,
                                                                  GVariant* parameter,
                                                                  gpointer self);
static void bookmarks_window_move_up (BookmarksWindow* self);
static void _bookmarks_window_move_up_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self);
static void bookmarks_window_move_down (BookmarksWindow* self);
static void _bookmarks_window_move_down_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self);
static void bookmarks_window_move_bottom (BookmarksWindow* self);
static void _bookmarks_window_move_bottom_gsimple_action_activate_callback (GSimpleAction* action,
                                                                     GVariant* parameter,
                                                                     gpointer self);
static void bookmarks_window_real_before_destroy (AdaptativeWindow* base);
static void bookmarks_window_install_bw_action_entries (BookmarksWindow* self);
static gboolean bookmarks_window_real_escape_pressed (BaseWindow* base);
VALA_EXTERN gboolean bookmarks_view_get_in_window_bookmarks (BookmarksView* self);
VALA_EXTERN gboolean bookmarks_view_get_in_window_bookmarks_edit_mode (BookmarksView* self);
static void bookmarks_window_leave_edit_mode (BookmarksWindow* self);
static void bookmarks_window_real_show_default_view (BaseWindow* base);
VALA_EXTERN void base_header_bar_show_default_view (BaseHeaderBar* self);
VALA_EXTERN void base_view_show_default_view (BaseView* self);
VALA_EXTERN void browser_window_request_folder (BrowserWindow* self,
                                    const gchar* full_name,
                                    const gchar* selected_or_empty,
                                    gboolean notify_missing);
VALA_EXTERN void base_window_close_in_window_panels (BaseWindow* self);
VALA_EXTERN void bookmarks_header_bar_show_use_bookmarks_view (BookmarksHeaderBar* self);
VALA_EXTERN gchar** bookmarks_header_bar_get_bookmarks (BookmarksHeaderBar* self,
                                            gint* result_length1);
VALA_EXTERN void bookmarks_view_show_bookmarks_view (BookmarksView* self,
                                         gchar** bookmarks,
                                         gint bookmarks_length1);
static void bookmarks_window_update_bookmarks_icons_from_array (BookmarksWindow* self,
                                                         gchar** bookmarks,
                                                         gint bookmarks_length1);
static void bookmarks_window_update_bookmarks_icons_from_variant (BookmarksWindow* self,
                                                           GVariant* variant);
static void bookmarks_window_update_bookmark_icon (BookmarksWindow* self,
                                            const gchar* bookmark,
                                            BookmarkIcon icon);
VALA_EXTERN gboolean browser_window_is_path_invalid (const gchar* path);
static BookmarkIcon bookmarks_window_real_get_bookmark_icon (BookmarksWindow* self,
                                                      gchar** bookmark);
VALA_EXTERN void bookmarks_view_update_bookmark_icon (BookmarksView* self,
                                          const gchar* bookmark,
                                          BookmarkIcon icon);
VALA_EXTERN void bookmarks_header_bar_update_bookmark_icon (BookmarksHeaderBar* self,
                                                const gchar* bookmark,
                                                BookmarkIcon icon);
static void bookmarks_window_real_set_window_size (AdaptativeWidget* base,
                                            AdaptativeWidgetWindowSize new_size);
VALA_EXTERN gboolean adaptative_widget_window_size_is_phone_size (AdaptativeWidgetWindowSize window_size);
VALA_EXTERN gboolean adaptative_widget_window_size_is_extra_thin (AdaptativeWidgetWindowSize window_size);
VALA_EXTERN void base_view_close_popovers (BaseView* self);
VALA_EXTERN void bookmarks_header_bar_click_bookmarks_button (BookmarksHeaderBar* self);
static void bookmarks_window_real_toggle_bookmark_called (BookmarksWindow* self);
VALA_EXTERN gboolean browser_window_is_in_in_window_mode (BrowserWindow* self);
VALA_EXTERN void bookmarks_header_bar_bookmark_current_path (BookmarksHeaderBar* self);
VALA_EXTERN void bookmarks_header_bar_unbookmark_current_path (BookmarksHeaderBar* self);
static gboolean bookmarks_window_real_intercept_next_match (BrowserWindow* base,
                                                     gboolean* interception_result);
VALA_EXTERN gboolean base_header_bar_has_popover (BaseHeaderBar* self);
VALA_EXTERN gboolean bookmarks_header_bar_next_match (BookmarksHeaderBar* self);
static gboolean bookmarks_window_real_intercept_previous_match (BrowserWindow* base,
                                                         gboolean* interception_result);
VALA_EXTERN gboolean bookmarks_header_bar_previous_match (BookmarksHeaderBar* self);
static void bookmarks_window_update_actions (BookmarksWindow* self);
VALA_EXTERN GType overlayed_list_selection_state_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void _bookmarks_update_actions (OverlayedListSelectionState selection_state,
                                GSimpleAction** move_top_action,
                                GSimpleAction** move_up_action,
                                GSimpleAction** move_down_action,
                                GSimpleAction** move_bottom_action,
                                GSimpleAction** trash_bookmark_action);
VALA_EXTERN OverlayedListSelectionState bookmarks_view_get_bookmarks_selection_state (BookmarksView* self);
static void bookmarks_window_install_bmk_action_entries (BookmarksWindow* self);
static GVariant* _variant_new6 (gboolean value);
static void bookmarks_window_enter_edit_mode (BookmarksWindow* self);
VALA_EXTERN void bookmarks_header_bar_show_edit_bookmarks_view (BookmarksHeaderBar* self);
VALA_EXTERN void bookmarks_view_enter_bookmarks_edit_mode (BookmarksView* self);
static GVariant* _variant_new7 (gboolean value);
VALA_EXTERN gboolean bookmarks_view_leave_bookmarks_edit_mode (BookmarksView* self);
VALA_EXTERN void bookmarks_view_trash_bookmark (BookmarksView* self);
VALA_EXTERN void bookmarks_view_move_top (BookmarksView* self);
VALA_EXTERN void bookmarks_view_move_up (BookmarksView* self);
VALA_EXTERN void bookmarks_view_move_down (BookmarksView* self);
VALA_EXTERN void bookmarks_view_move_bottom (BookmarksView* self);
static void bookmarks_window_on_bookmarks_selection_changed (BookmarksWindow* self);
VALA_EXTERN BookmarksWindow* bookmarks_window_construct (GType object_type);
VALA_EXTERN BrowserWindow* browser_window_construct (GType object_type);
static GObject * bookmarks_window_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties);
VALA_EXTERN BaseHeaderBar* adaptative_window_get_nta_headerbar (AdaptativeWindow* self);
VALA_EXTERN BaseView* base_window_get_base_view (BaseWindow* self);
static void _bookmarks_window_on_bookmarks_selection_changed_bookmarks_view_bookmarks_selection_changed (BookmarksView* _sender,
                                                                                                  gpointer self);
static void _bookmarks_window_update_bookmarks_icons_from_variant_bookmarks_header_bar_update_bookmarks_icons (BookmarksHeaderBar* _sender,
                                                                                                        GVariant* bookmarks_variant,
                                                                                                        gpointer self);
static void _bookmarks_window_update_bookmarks_icons_from_variant_bookmarks_view_update_bookmarks_icons (BookmarksView* _sender,
                                                                                                  GVariant* bookmarks_variant,
                                                                                                  gpointer self);
VALA_EXTERN void adaptative_widget_set_window_size (AdaptativeWidget* self,
                                        AdaptativeWidgetWindowSize new_size);
static void bookmarks_window_finalize (GObject * obj);
static GType bookmarks_window_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GActionEntry BOOKMARKS_WINDOW_bw_action_entries[5] = {{"show-in-window-bookmarks", _bookmarks_window_show_use_bookmarks_view_gsimple_action_activate_callback}, {"update-bookmarks-icons", _bookmarks_window_update_bookmarks_icons_gsimple_action_activate_callback, "as"}, {"toggle-bookmark", _bookmarks_window_toggle_bookmark_gsimple_action_activate_callback}, {"bookmark", _bookmarks_window_bookmark_gsimple_action_activate_callback}, {"unbookmark", _bookmarks_window_unbookmark_gsimple_action_activate_callback}};
static const GActionEntry BOOKMARKS_WINDOW_bmk_action_entries[6] = {{"set-edit-mode", _bookmarks_window_set_edit_mode_gsimple_action_activate_callback, "b", "false"}, {"trash-bookmark", _bookmarks_window_trash_bookmark_gsimple_action_activate_callback}, {"move-top", _bookmarks_window_move_top_gsimple_action_activate_callback}, {"move-up", _bookmarks_window_move_up_gsimple_action_activate_callback}, {"move-down", _bookmarks_window_move_down_gsimple_action_activate_callback}, {"move-bottom", _bookmarks_window_move_bottom_gsimple_action_activate_callback}};

static inline gpointer
bookmarks_window_get_instance_private (BookmarksWindow* self)
{
	return G_STRUCT_MEMBER_P (self, BookmarksWindow_private_offset);
}

static void
_bookmarks_window_show_use_bookmarks_view_gsimple_action_activate_callback (GSimpleAction* action,
                                                                            GVariant* parameter,
                                                                            gpointer self)
{
	bookmarks_window_show_use_bookmarks_view ((BookmarksWindow*) self);
}

static void
_bookmarks_window_update_bookmarks_icons_gsimple_action_activate_callback (GSimpleAction* action,
                                                                           GVariant* parameter,
                                                                           gpointer self)
{
	bookmarks_window_update_bookmarks_icons ((BookmarksWindow*) self, action, parameter);
}

static void
_bookmarks_window_toggle_bookmark_gsimple_action_activate_callback (GSimpleAction* action,
                                                                    GVariant* parameter,
                                                                    gpointer self)
{
	bookmarks_window_toggle_bookmark ((BookmarksWindow*) self);
}

static void
_bookmarks_window_bookmark_gsimple_action_activate_callback (GSimpleAction* action,
                                                             GVariant* parameter,
                                                             gpointer self)
{
	bookmarks_window_bookmark ((BookmarksWindow*) self);
}

static void
_bookmarks_window_unbookmark_gsimple_action_activate_callback (GSimpleAction* action,
                                                               GVariant* parameter,
                                                               gpointer self)
{
	bookmarks_window_unbookmark ((BookmarksWindow*) self);
}

static void
_bookmarks_window_set_edit_mode_gsimple_action_activate_callback (GSimpleAction* action,
                                                                  GVariant* parameter,
                                                                  gpointer self)
{
	bookmarks_window_set_edit_mode ((BookmarksWindow*) self, action, parameter);
}

static void
_bookmarks_window_trash_bookmark_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self)
{
	bookmarks_window_trash_bookmark ((BookmarksWindow*) self);
}

static void
_bookmarks_window_move_top_gsimple_action_activate_callback (GSimpleAction* action,
                                                             GVariant* parameter,
                                                             gpointer self)
{
	bookmarks_window_move_top ((BookmarksWindow*) self);
}

static void
_bookmarks_window_move_up_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self)
{
	bookmarks_window_move_up ((BookmarksWindow*) self);
}

static void
_bookmarks_window_move_down_gsimple_action_activate_callback (GSimpleAction* action,
                                                              GVariant* parameter,
                                                              gpointer self)
{
	bookmarks_window_move_down ((BookmarksWindow*) self);
}

static void
_bookmarks_window_move_bottom_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self)
{
	bookmarks_window_move_bottom ((BookmarksWindow*) self);
}

static void
bookmarks_window_real_before_destroy (AdaptativeWindow* base)
{
	BookmarksWindow * self;
	BookmarksView* _tmp0_;
	BookmarksHeaderBar* _tmp1_;
	BookmarksView* _tmp2_;
	self = (BookmarksWindow*) base;
	ADAPTATIVE_WINDOW_CLASS (bookmarks_window_parent_class)->before_destroy ((AdaptativeWindow*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_BROWSER_WINDOW, BrowserWindow));
	_tmp0_ = self->priv->main_view;
	g_signal_handler_disconnect ((GObject*) _tmp0_, self->priv->bookmarks_selection_changed_handler);
	_tmp1_ = self->priv->headerbar;
	g_signal_handler_disconnect ((GObject*) _tmp1_, self->priv->headerbar_update_bookmarks_icons_handler);
	_tmp2_ = self->priv->main_view;
	g_signal_handler_disconnect ((GObject*) _tmp2_, self->priv->main_view_update_bookmarks_icons_handler);
}

static void
bookmarks_window_install_bw_action_entries (BookmarksWindow* self)
{
	GSimpleActionGroup* action_group = NULL;
	GSimpleActionGroup* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_simple_action_group_new ();
	action_group = _tmp0_;
	g_action_map_add_action_entries ((GActionMap*) action_group, BOOKMARKS_WINDOW_bw_action_entries, (gint) G_N_ELEMENTS (BOOKMARKS_WINDOW_bw_action_entries), self);
	gtk_widget_insert_action_group ((GtkWidget*) self, "bw", (GActionGroup*) action_group);
	_g_object_unref0 (action_group);
}

static gboolean
bookmarks_window_real_escape_pressed (BaseWindow* base)
{
	BookmarksWindow * self;
	BookmarksView* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	self = (BookmarksWindow*) base;
	_tmp0_ = self->priv->main_view;
	_tmp1_ = bookmarks_view_get_in_window_bookmarks (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		BookmarksView* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = self->priv->main_view;
		_tmp4_ = bookmarks_view_get_in_window_bookmarks_edit_mode (_tmp3_);
		_tmp5_ = _tmp4_;
		if (_tmp5_) {
			bookmarks_window_leave_edit_mode (self);
		} else {
			base_window_show_default_view ((BaseWindow*) self);
		}
		result = TRUE;
		return result;
	}
	result = BASE_WINDOW_CLASS (bookmarks_window_parent_class)->escape_pressed ((BaseWindow*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_BROWSER_WINDOW, BrowserWindow));
	return result;
}

static void
bookmarks_window_real_show_default_view (BaseWindow* base)
{
	BookmarksWindow * self;
	BookmarksView* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	self = (BookmarksWindow*) base;
	_tmp0_ = self->priv->main_view;
	_tmp1_ = bookmarks_view_get_in_window_bookmarks (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		BookmarksView* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		BookmarksHeaderBar* _tmp6_;
		BookmarksView* _tmp7_;
		_tmp3_ = self->priv->main_view;
		_tmp4_ = bookmarks_view_get_in_window_bookmarks_edit_mode (_tmp3_);
		_tmp5_ = _tmp4_;
		if (_tmp5_) {
			bookmarks_window_leave_edit_mode (self);
		}
		_tmp6_ = self->priv->headerbar;
		base_header_bar_show_default_view ((BaseHeaderBar*) _tmp6_);
		_tmp7_ = self->priv->main_view;
		base_view_show_default_view ((BaseView*) _tmp7_);
		if (((BrowserWindow*) self)->current_type == VIEW_TYPE_CONFIG) {
			const gchar* _tmp8_;
			_tmp8_ = ((BrowserWindow*) self)->current_path;
			browser_window_request_folder ((BrowserWindow*) self, _tmp8_, "", TRUE);
		}
	} else {
		BASE_WINDOW_CLASS (bookmarks_window_parent_class)->show_default_view ((BaseWindow*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_BROWSER_WINDOW, BrowserWindow));
	}
}

static void
bookmarks_window_show_use_bookmarks_view (BookmarksWindow* self)
{
	BookmarksHeaderBar* _tmp0_;
	gchar** bookmarks = NULL;
	BookmarksHeaderBar* _tmp1_;
	gint _tmp2_ = 0;
	gchar** _tmp3_;
	gint bookmarks_length1;
	gint _bookmarks_size_;
	BookmarksView* _tmp4_;
	g_return_if_fail (self != NULL);
	base_window_close_in_window_panels ((BaseWindow*) self);
	_tmp0_ = self->priv->headerbar;
	bookmarks_header_bar_show_use_bookmarks_view (_tmp0_);
	_tmp1_ = self->priv->headerbar;
	_tmp3_ = bookmarks_header_bar_get_bookmarks (_tmp1_, &_tmp2_);
	bookmarks = _tmp3_;
	bookmarks_length1 = _tmp2_;
	_bookmarks_size_ = bookmarks_length1;
	_tmp4_ = self->priv->main_view;
	bookmarks_view_show_bookmarks_view (_tmp4_, bookmarks, (gint) bookmarks_length1);
	bookmarks_window_update_bookmarks_icons_from_array (self, bookmarks, (gint) bookmarks_length1);
	bookmarks = (_vala_array_free (bookmarks, bookmarks_length1, (GDestroyNotify) g_free), NULL);
}

static void
bookmarks_window_update_bookmarks_icons (BookmarksWindow* self,
                                         GSimpleAction* action,
                                         GVariant* bookmarks_variant)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_vala_return_if_fail (bookmarks_variant != NULL, "bookmarks_variant != null");
	bookmarks_window_update_bookmarks_icons_from_variant (self, (GVariant*) bookmarks_variant);
}

static void
bookmarks_window_update_bookmarks_icons_from_variant (BookmarksWindow* self,
                                                      GVariant* variant)
{
	gsize _tmp0_ = 0;
	const gchar** _tmp1_;
	const gchar** _tmp2_;
	gint _tmp2__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (variant != NULL);
	_tmp1_ = g_variant_get_strv (variant, &_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp0_;
	bookmarks_window_update_bookmarks_icons_from_array (self, _tmp2_, (gint) _tmp0_);
	_tmp2_ = (g_free (_tmp2_), NULL);
}

static void
bookmarks_window_update_bookmarks_icons_from_array (BookmarksWindow* self,
                                                    gchar** bookmarks,
                                                    gint bookmarks_length1)
{
	g_return_if_fail (self != NULL);
	if (bookmarks_length1 == 0) {
		return;
	}
	{
		gchar** bookmark_collection = NULL;
		gint bookmark_collection_length1 = 0;
		gint _bookmark_collection_size_ = 0;
		gint bookmark_it = 0;
		bookmark_collection = bookmarks;
		bookmark_collection_length1 = bookmarks_length1;
		for (bookmark_it = 0; bookmark_it < bookmark_collection_length1; bookmark_it = bookmark_it + 1) {
			gchar* _tmp0_;
			gchar* bookmark = NULL;
			_tmp0_ = g_strdup (bookmark_collection[bookmark_it]);
			bookmark = _tmp0_;
			{
				const gchar* _tmp1_;
				const gchar* _tmp3_;
				const gchar* _tmp4_;
				BookmarkIcon _tmp5_;
				_tmp1_ = bookmark;
				if (g_str_has_prefix (_tmp1_, "?")) {
					const gchar* _tmp2_;
					_tmp2_ = bookmark;
					bookmarks_window_update_bookmark_icon (self, _tmp2_, BOOKMARK_ICON_SEARCH);
					_g_free0 (bookmark);
					continue;
				}
				_tmp3_ = bookmark;
				if (browser_window_is_path_invalid (_tmp3_)) {
					_g_free0 (bookmark);
					continue;
				}
				_tmp4_ = bookmark;
				_tmp5_ = bookmarks_window_get_bookmark_icon (self, &bookmark);
				bookmarks_window_update_bookmark_icon (self, _tmp4_, _tmp5_);
				_g_free0 (bookmark);
			}
		}
	}
}

static BookmarkIcon
bookmarks_window_real_get_bookmark_icon (BookmarksWindow* self,
                                         gchar** bookmark)
{
	g_critical ("Type `%s' does not implement abstract method `bookmarks_window_get_bookmark_icon'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return 0;
}

BookmarkIcon
bookmarks_window_get_bookmark_icon (BookmarksWindow* self,
                                    gchar** bookmark)
{
	BookmarksWindowClass* _klass_;
	g_return_val_if_fail (self != NULL, 0);
	_klass_ = BOOKMARKS_WINDOW_GET_CLASS (self);
	if (_klass_->get_bookmark_icon) {
		return _klass_->get_bookmark_icon (self, bookmark);
	}
	return 0;
}

static void
bookmarks_window_update_bookmark_icon (BookmarksWindow* self,
                                       const gchar* bookmark,
                                       BookmarkIcon icon)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (bookmark != NULL);
	if (self->priv->disable_popovers) {
		BookmarksView* _tmp0_;
		_tmp0_ = self->priv->main_view;
		bookmarks_view_update_bookmark_icon (_tmp0_, bookmark, icon);
	} else {
		BookmarksHeaderBar* _tmp1_;
		_tmp1_ = self->priv->headerbar;
		bookmarks_header_bar_update_bookmark_icon (_tmp1_, bookmark, icon);
	}
}

static void
bookmarks_window_real_set_window_size (AdaptativeWidget* base,
                                       AdaptativeWidgetWindowSize new_size)
{
	BookmarksWindow * self;
	gboolean _tmp0_ = FALSE;
	gboolean _disable_popovers = FALSE;
	self = (BookmarksWindow*) base;
	BASE_WINDOW_CLASS (bookmarks_window_parent_class)->set_window_size ((BaseWindow*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_BROWSER_WINDOW, BrowserWindow), new_size);
	if (adaptative_widget_window_size_is_phone_size (new_size)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = adaptative_widget_window_size_is_extra_thin (new_size);
	}
	_disable_popovers = _tmp0_;
	if (self->priv->disable_popovers != _disable_popovers) {
		BookmarksView* _tmp1_;
		gboolean _tmp2_;
		gboolean _tmp3_;
		self->priv->disable_popovers = _disable_popovers;
		_tmp1_ = self->priv->main_view;
		_tmp2_ = bookmarks_view_get_in_window_bookmarks (_tmp1_);
		_tmp3_ = _tmp2_;
		if (_tmp3_) {
			base_window_show_default_view ((BaseWindow*) self);
		}
	}
}

static void
bookmarks_window_toggle_bookmark (BookmarksWindow* self)
{
	BookmarksView* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->main_view;
	base_view_close_popovers ((BaseView*) _tmp0_);
	if (!self->priv->disable_popovers) {
		BookmarksHeaderBar* _tmp1_;
		bookmarks_window_toggle_bookmark_called (self);
		_tmp1_ = self->priv->headerbar;
		bookmarks_header_bar_click_bookmarks_button (_tmp1_);
	} else {
		BookmarksView* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp2_ = self->priv->main_view;
		_tmp3_ = bookmarks_view_get_in_window_bookmarks (_tmp2_);
		_tmp4_ = _tmp3_;
		if (_tmp4_) {
			base_window_show_default_view ((BaseWindow*) self);
		} else {
			bookmarks_window_show_use_bookmarks_view (self);
		}
	}
}

static void
bookmarks_window_real_toggle_bookmark_called (BookmarksWindow* self)
{
	g_critical ("Type `%s' does not implement abstract method `bookmarks_window_toggle_bookmark_called'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
bookmarks_window_toggle_bookmark_called (BookmarksWindow* self)
{
	BookmarksWindowClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = BOOKMARKS_WINDOW_GET_CLASS (self);
	if (_klass_->toggle_bookmark_called) {
		_klass_->toggle_bookmark_called (self);
	}
}

static void
bookmarks_window_bookmark (BookmarksWindow* self)
{
	BookmarksView* _tmp0_;
	BookmarksHeaderBar* _tmp1_;
	g_return_if_fail (self != NULL);
	if (browser_window_is_in_in_window_mode ((BrowserWindow*) self)) {
		return;
	}
	_tmp0_ = self->priv->main_view;
	base_view_close_popovers ((BaseView*) _tmp0_);
	_tmp1_ = self->priv->headerbar;
	bookmarks_header_bar_bookmark_current_path (_tmp1_);
}

static void
bookmarks_window_unbookmark (BookmarksWindow* self)
{
	BookmarksView* _tmp0_;
	BookmarksHeaderBar* _tmp1_;
	g_return_if_fail (self != NULL);
	if (browser_window_is_in_in_window_mode ((BrowserWindow*) self)) {
		return;
	}
	_tmp0_ = self->priv->main_view;
	base_view_close_popovers ((BaseView*) _tmp0_);
	_tmp1_ = self->priv->headerbar;
	bookmarks_header_bar_unbookmark_current_path (_tmp1_);
}

static gboolean
bookmarks_window_real_intercept_next_match (BrowserWindow* base,
                                            gboolean* interception_result)
{
	BookmarksWindow * self;
	gboolean _vala_interception_result = FALSE;
	BookmarksHeaderBar* _tmp0_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	gboolean result;
	self = (BookmarksWindow*) base;
	_tmp0_ = self->priv->headerbar;
	if (base_header_bar_has_popover ((BaseHeaderBar*) _tmp0_)) {
		BookmarksHeaderBar* _tmp1_;
		_tmp1_ = self->priv->headerbar;
		_vala_interception_result = bookmarks_header_bar_next_match (_tmp1_);
		result = TRUE;
		if (interception_result) {
			*interception_result = _vala_interception_result;
		}
		return result;
	}
	_tmp3_ = BROWSER_WINDOW_CLASS (bookmarks_window_parent_class)->intercept_next_match (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_BROWSER_WINDOW, BrowserWindow), &_tmp2_);
	_vala_interception_result = _tmp2_;
	result = _tmp3_;
	if (interception_result) {
		*interception_result = _vala_interception_result;
	}
	return result;
}

static gboolean
bookmarks_window_real_intercept_previous_match (BrowserWindow* base,
                                                gboolean* interception_result)
{
	BookmarksWindow * self;
	gboolean _vala_interception_result = FALSE;
	BookmarksHeaderBar* _tmp0_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	gboolean result;
	self = (BookmarksWindow*) base;
	_tmp0_ = self->priv->headerbar;
	if (base_header_bar_has_popover ((BaseHeaderBar*) _tmp0_)) {
		BookmarksHeaderBar* _tmp1_;
		_tmp1_ = self->priv->headerbar;
		_vala_interception_result = bookmarks_header_bar_previous_match (_tmp1_);
		result = TRUE;
		if (interception_result) {
			*interception_result = _vala_interception_result;
		}
		return result;
	}
	_tmp3_ = BROWSER_WINDOW_CLASS (bookmarks_window_parent_class)->intercept_previous_match (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_BROWSER_WINDOW, BrowserWindow), &_tmp2_);
	_vala_interception_result = _tmp2_;
	result = _tmp3_;
	if (interception_result) {
		*interception_result = _vala_interception_result;
	}
	return result;
}

static void
bookmarks_window_update_actions (BookmarksWindow* self)
{
	BookmarksView* _tmp0_;
	g_return_if_fail (self != NULL);
	_vala_return_if_fail (self->priv->actions_init_done, "actions_init_done");
	_tmp0_ = self->priv->main_view;
	_bookmarks_update_actions (bookmarks_view_get_bookmarks_selection_state (_tmp0_), &self->priv->move_top_action, &self->priv->move_up_action, &self->priv->move_down_action, &self->priv->move_bottom_action, &self->priv->trash_bookmark_action);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
bookmarks_window_install_bmk_action_entries (BookmarksWindow* self)
{
	GSimpleActionGroup* action_group = NULL;
	GSimpleActionGroup* _tmp0_;
	GAction* _tmp1_;
	GSimpleAction* _tmp2_;
	GAction* _tmp3_;
	GSimpleAction* _tmp4_;
	GAction* _tmp5_;
	GSimpleAction* _tmp6_;
	GAction* _tmp7_;
	GSimpleAction* _tmp8_;
	GAction* _tmp9_;
	GSimpleAction* _tmp10_;
	GAction* _tmp11_;
	GSimpleAction* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_simple_action_group_new ();
	action_group = _tmp0_;
	g_action_map_add_action_entries ((GActionMap*) action_group, BOOKMARKS_WINDOW_bmk_action_entries, (gint) G_N_ELEMENTS (BOOKMARKS_WINDOW_bmk_action_entries), self);
	gtk_widget_insert_action_group ((GtkWidget*) self, "bmk", (GActionGroup*) action_group);
	_tmp1_ = g_action_map_lookup_action ((GActionMap*) action_group, "move-top");
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->move_top_action);
	self->priv->move_top_action = _tmp2_;
	_tmp3_ = g_action_map_lookup_action ((GActionMap*) action_group, "move-up");
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->move_up_action);
	self->priv->move_up_action = _tmp4_;
	_tmp5_ = g_action_map_lookup_action ((GActionMap*) action_group, "move-down");
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->move_down_action);
	self->priv->move_down_action = _tmp6_;
	_tmp7_ = g_action_map_lookup_action ((GActionMap*) action_group, "move-bottom");
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->move_bottom_action);
	self->priv->move_bottom_action = _tmp8_;
	_tmp9_ = g_action_map_lookup_action ((GActionMap*) action_group, "trash-bookmark");
	_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->trash_bookmark_action);
	self->priv->trash_bookmark_action = _tmp10_;
	_tmp11_ = g_action_map_lookup_action ((GActionMap*) action_group, "set-edit-mode");
	_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->edit_mode_state_action);
	self->priv->edit_mode_state_action = _tmp12_;
	self->priv->actions_init_done = TRUE;
	_g_object_unref0 (action_group);
}

static GVariant*
_variant_new6 (gboolean value)
{
	return g_variant_ref_sink (g_variant_new_boolean (value));
}

static void
bookmarks_window_set_edit_mode (BookmarksWindow* self,
                                GSimpleAction* action,
                                GVariant* variant)
{
	gboolean new_state = FALSE;
	GVariant* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_vala_return_if_fail (variant != NULL, "variant != null");
	new_state = g_variant_get_boolean ((GVariant*) variant);
	_tmp0_ = _variant_new6 (new_state);
	g_simple_action_set_state (action, _tmp0_);
	_g_variant_unref0 (_tmp0_);
	if (new_state) {
		bookmarks_window_enter_edit_mode (self);
	} else {
		bookmarks_window_leave_edit_mode (self);
	}
}

static void
bookmarks_window_enter_edit_mode (BookmarksWindow* self)
{
	BookmarksHeaderBar* _tmp0_;
	BookmarksView* _tmp1_;
	g_return_if_fail (self != NULL);
	bookmarks_window_update_actions (self);
	_tmp0_ = self->priv->headerbar;
	bookmarks_header_bar_show_edit_bookmarks_view (_tmp0_);
	_tmp1_ = self->priv->main_view;
	bookmarks_view_enter_bookmarks_edit_mode (_tmp1_);
}

static GVariant*
_variant_new7 (gboolean value)
{
	return g_variant_ref_sink (g_variant_new_boolean (value));
}

static void
bookmarks_window_leave_edit_mode (BookmarksWindow* self)
{
	GSimpleAction* _tmp0_;
	GVariant* _tmp1_;
	gboolean give_focus_to_info_button = FALSE;
	BookmarksView* _tmp2_;
	BookmarksHeaderBar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->edit_mode_state_action;
	_tmp1_ = _variant_new7 (FALSE);
	g_simple_action_set_state (_tmp0_, _tmp1_);
	_g_variant_unref0 (_tmp1_);
	_tmp2_ = self->priv->main_view;
	give_focus_to_info_button = bookmarks_view_leave_bookmarks_edit_mode (_tmp2_);
	_tmp3_ = self->priv->headerbar;
	bookmarks_header_bar_show_use_bookmarks_view (_tmp3_);
}

static void
bookmarks_window_trash_bookmark (BookmarksWindow* self)
{
	BookmarksView* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->main_view;
	bookmarks_view_trash_bookmark (_tmp0_);
}

static void
bookmarks_window_move_top (BookmarksWindow* self)
{
	BookmarksView* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->main_view;
	bookmarks_view_move_top (_tmp0_);
}

static void
bookmarks_window_move_up (BookmarksWindow* self)
{
	BookmarksView* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->main_view;
	bookmarks_view_move_up (_tmp0_);
}

static void
bookmarks_window_move_down (BookmarksWindow* self)
{
	BookmarksView* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->main_view;
	bookmarks_view_move_down (_tmp0_);
}

static void
bookmarks_window_move_bottom (BookmarksWindow* self)
{
	BookmarksView* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->main_view;
	bookmarks_view_move_bottom (_tmp0_);
}

static void
bookmarks_window_on_bookmarks_selection_changed (BookmarksWindow* self)
{
	g_return_if_fail (self != NULL);
	bookmarks_window_update_actions (self);
}

BookmarksWindow*
bookmarks_window_construct (GType object_type)
{
	BookmarksWindow * self = NULL;
	self = (BookmarksWindow*) browser_window_construct (object_type);
	return self;
}

static void
_bookmarks_window_on_bookmarks_selection_changed_bookmarks_view_bookmarks_selection_changed (BookmarksView* _sender,
                                                                                             gpointer self)
{
	bookmarks_window_on_bookmarks_selection_changed ((BookmarksWindow*) self);
}

static void
_bookmarks_window_update_bookmarks_icons_from_variant_bookmarks_header_bar_update_bookmarks_icons (BookmarksHeaderBar* _sender,
                                                                                                   GVariant* bookmarks_variant,
                                                                                                   gpointer self)
{
	bookmarks_window_update_bookmarks_icons_from_variant ((BookmarksWindow*) self, bookmarks_variant);
}

static void
_bookmarks_window_update_bookmarks_icons_from_variant_bookmarks_view_update_bookmarks_icons (BookmarksView* _sender,
                                                                                             GVariant* bookmarks_variant,
                                                                                             gpointer self)
{
	bookmarks_window_update_bookmarks_icons_from_variant ((BookmarksWindow*) self, bookmarks_variant);
}

static GObject *
bookmarks_window_constructor (GType type,
                              guint n_construct_properties,
                              GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	BookmarksWindow * self;
	BaseHeaderBar* _tmp0_;
	BaseHeaderBar* _tmp1_;
	BookmarksHeaderBar* _tmp2_;
	BaseView* _tmp3_;
	BaseView* _tmp4_;
	BookmarksView* _tmp5_;
	BookmarksView* _tmp6_;
	gulong _tmp7_;
	BookmarksHeaderBar* _tmp8_;
	gulong _tmp9_;
	BookmarksView* _tmp10_;
	gulong _tmp11_;
	parent_class = G_OBJECT_CLASS (bookmarks_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BOOKMARKS_WINDOW, BookmarksWindow);
	_tmp0_ = adaptative_window_get_nta_headerbar ((AdaptativeWindow*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_BOOKMARKS_HEADER_BAR, BookmarksHeaderBar));
	_g_object_unref0 (self->priv->headerbar);
	self->priv->headerbar = _tmp2_;
	_tmp3_ = base_window_get_base_view ((BaseWindow*) self);
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_BOOKMARKS_VIEW, BookmarksView));
	_g_object_unref0 (self->priv->main_view);
	self->priv->main_view = _tmp5_;
	bookmarks_window_install_bw_action_entries (self);
	bookmarks_window_install_bmk_action_entries (self);
	_tmp6_ = self->priv->main_view;
	_tmp7_ = g_signal_connect_object (_tmp6_, "bookmarks-selection-changed", (GCallback) _bookmarks_window_on_bookmarks_selection_changed_bookmarks_view_bookmarks_selection_changed, self, 0);
	self->priv->bookmarks_selection_changed_handler = _tmp7_;
	_tmp8_ = self->priv->headerbar;
	_tmp9_ = g_signal_connect_object (_tmp8_, "update-bookmarks-icons", (GCallback) _bookmarks_window_update_bookmarks_icons_from_variant_bookmarks_header_bar_update_bookmarks_icons, self, 0);
	self->priv->headerbar_update_bookmarks_icons_handler = _tmp9_;
	_tmp10_ = self->priv->main_view;
	_tmp11_ = g_signal_connect_object (_tmp10_, "update-bookmarks-icons", (GCallback) _bookmarks_window_update_bookmarks_icons_from_variant_bookmarks_view_update_bookmarks_icons, self, 0);
	self->priv->main_view_update_bookmarks_icons_handler = _tmp11_;
	return obj;
}

static void
bookmarks_window_class_init (BookmarksWindowClass * klass,
                             gpointer klass_data)
{
	bookmarks_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BookmarksWindow_private_offset);
	((AdaptativeWindowClass *) klass)->before_destroy = (void (*) (AdaptativeWindow*)) bookmarks_window_real_before_destroy;
	((BaseWindowClass *) klass)->escape_pressed = (gboolean (*) (BaseWindow*)) bookmarks_window_real_escape_pressed;
	((BaseWindowClass *) klass)->show_default_view = (void (*) (BaseWindow*)) bookmarks_window_real_show_default_view;
	((BookmarksWindowClass *) klass)->get_bookmark_icon = (BookmarkIcon (*) (BookmarksWindow*, gchar**)) bookmarks_window_real_get_bookmark_icon;
	((BaseWindowClass *) klass)->set_window_size = (void (*) (BaseWindow*, AdaptativeWidgetWindowSize)) bookmarks_window_real_set_window_size;
	((BookmarksWindowClass *) klass)->toggle_bookmark_called = (void (*) (BookmarksWindow*)) bookmarks_window_real_toggle_bookmark_called;
	((BrowserWindowClass *) klass)->intercept_next_match = (gboolean (*) (BrowserWindow*, gboolean*)) bookmarks_window_real_intercept_next_match;
	((BrowserWindowClass *) klass)->intercept_previous_match = (gboolean (*) (BrowserWindow*, gboolean*)) bookmarks_window_real_intercept_previous_match;
	G_OBJECT_CLASS (klass)->constructor = bookmarks_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = bookmarks_window_finalize;
}

static void
bookmarks_window_adaptative_widget_interface_init (AdaptativeWidgetIface * iface,
                                                   gpointer iface_data)
{
	bookmarks_window_adaptative_widget_parent_iface = g_type_interface_peek_parent (iface);
	iface->set_window_size = (void (*) (AdaptativeWidget*, AdaptativeWidgetWindowSize)) bookmarks_window_real_set_window_size;
}

static void
bookmarks_window_instance_init (BookmarksWindow * self,
                                gpointer klass)
{
	self->priv = bookmarks_window_get_instance_private (self);
	self->priv->bookmarks_selection_changed_handler = (gulong) 0;
	self->priv->headerbar_update_bookmarks_icons_handler = (gulong) 0;
	self->priv->main_view_update_bookmarks_icons_handler = (gulong) 0;
	self->priv->disable_popovers = FALSE;
	self->priv->actions_init_done = FALSE;
}

static void
bookmarks_window_finalize (GObject * obj)
{
	BookmarksWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BOOKMARKS_WINDOW, BookmarksWindow);
	_g_object_unref0 (self->priv->headerbar);
	_g_object_unref0 (self->priv->main_view);
	_g_object_unref0 (self->priv->move_top_action);
	_g_object_unref0 (self->priv->move_up_action);
	_g_object_unref0 (self->priv->move_down_action);
	_g_object_unref0 (self->priv->move_bottom_action);
	_g_object_unref0 (self->priv->trash_bookmark_action);
	_g_object_unref0 (self->priv->edit_mode_state_action);
	G_OBJECT_CLASS (bookmarks_window_parent_class)->finalize (obj);
}

static GType
bookmarks_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BookmarksWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bookmarks_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BookmarksWindow), 0, (GInstanceInitFunc) bookmarks_window_instance_init, NULL };
	static const GInterfaceInfo adaptative_widget_info = { (GInterfaceInitFunc) bookmarks_window_adaptative_widget_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType bookmarks_window_type_id;
	bookmarks_window_type_id = g_type_register_static (TYPE_BROWSER_WINDOW, "BookmarksWindow", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	g_type_add_interface_static (bookmarks_window_type_id, TYPE_ADAPTATIVE_WIDGET, &adaptative_widget_info);
	BookmarksWindow_private_offset = g_type_add_instance_private (bookmarks_window_type_id, sizeof (BookmarksWindowPrivate));
	return bookmarks_window_type_id;
}

GType
bookmarks_window_get_type (void)
{
	static volatile gsize bookmarks_window_type_id__once = 0;
	if (g_once_init_enter (&bookmarks_window_type_id__once)) {
		GType bookmarks_window_type_id;
		bookmarks_window_type_id = bookmarks_window_get_type_once ();
		g_once_init_leave (&bookmarks_window_type_id__once, bookmarks_window_type_id);
	}
	return bookmarks_window_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

