// -*- C++ -*-
//
// This file was generated by CLI, a command line interface
// compiler for C++.
//

// Begin prologue.
//
#include <bdep/types-parsers.hxx>
//
// End prologue.

#include <bdep/sync-options.hxx>

#include <map>
#include <set>
#include <string>
#include <vector>
#include <utility>
#include <ostream>
#include <sstream>
#include <cstring>

namespace bdep
{
  namespace cli
  {
    template <typename X>
    struct parser
    {
      static void
      parse (X& x, bool& xs, scanner& s)
      {
        using namespace std;

        const char* o (s.next ());
        if (s.more ())
        {
          string v (s.next ());
          istringstream is (v);
          if (!(is >> x && is.peek () == istringstream::traits_type::eof ()))
            throw invalid_value (o, v);
        }
        else
          throw missing_value (o);

        xs = true;
      }

      static void
      merge (X& b, const X& a)
      {
        b = a;
      }
    };

    template <>
    struct parser<bool>
    {
      static void
      parse (bool& x, bool& xs, scanner& s)
      {
        const char* o (s.next ());

        if (s.more ())
        {
          const char* v (s.next ());

          if (std::strcmp (v, "1")    == 0 ||
              std::strcmp (v, "true") == 0 ||
              std::strcmp (v, "TRUE") == 0 ||
              std::strcmp (v, "True") == 0)
            x = true;
          else if (std::strcmp (v, "0")     == 0 ||
                   std::strcmp (v, "false") == 0 ||
                   std::strcmp (v, "FALSE") == 0 ||
                   std::strcmp (v, "False") == 0)
            x = false;
          else
            throw invalid_value (o, v);
        }
        else
          throw missing_value (o);

        xs = true;
      }

      static void
      merge (bool& b, const bool&)
      {
        b = true;
      }
    };

    template <>
    struct parser<std::string>
    {
      static void
      parse (std::string& x, bool& xs, scanner& s)
      {
        const char* o (s.next ());

        if (s.more ())
          x = s.next ();
        else
          throw missing_value (o);

        xs = true;
      }

      static void
      merge (std::string& b, const std::string& a)
      {
        b = a;
      }
    };

    template <typename X>
    struct parser<std::pair<X, std::size_t> >
    {
      static void
      parse (std::pair<X, std::size_t>& x, bool& xs, scanner& s)
      {
        x.second = s.position ();
        parser<X>::parse (x.first, xs, s);
      }

      static void
      merge (std::pair<X, std::size_t>& b, const std::pair<X, std::size_t>& a)
      {
        b = a;
      }
    };

    template <typename X>
    struct parser<std::vector<X> >
    {
      static void
      parse (std::vector<X>& c, bool& xs, scanner& s)
      {
        X x;
        bool dummy;
        parser<X>::parse (x, dummy, s);
        c.push_back (x);
        xs = true;
      }

      static void
      merge (std::vector<X>& b, const std::vector<X>& a)
      {
        b.insert (b.end (), a.begin (), a.end ());
      }
    };

    template <typename X, typename C>
    struct parser<std::set<X, C> >
    {
      static void
      parse (std::set<X, C>& c, bool& xs, scanner& s)
      {
        X x;
        bool dummy;
        parser<X>::parse (x, dummy, s);
        c.insert (x);
        xs = true;
      }

      static void
      merge (std::set<X, C>& b, const std::set<X, C>& a)
      {
        b.insert (a.begin (), a.end ());
      }
    };

    template <typename K, typename V, typename C>
    struct parser<std::map<K, V, C> >
    {
      static void
      parse (std::map<K, V, C>& m, bool& xs, scanner& s)
      {
        const char* o (s.next ());

        if (s.more ())
        {
          std::size_t pos (s.position ());
          std::string ov (s.next ());
          std::string::size_type p = ov.find ('=');

          K k = K ();
          V v = V ();
          std::string kstr (ov, 0, p);
          std::string vstr (ov, (p != std::string::npos ? p + 1 : ov.size ()));

          int ac (2);
          char* av[] =
          {
            const_cast<char*> (o),
            0
          };

          bool dummy;
          if (!kstr.empty ())
          {
            av[1] = const_cast<char*> (kstr.c_str ());
            argv_scanner s (0, ac, av, false, pos);
            parser<K>::parse (k, dummy, s);
          }

          if (!vstr.empty ())
          {
            av[1] = const_cast<char*> (vstr.c_str ());
            argv_scanner s (0, ac, av, false, pos);
            parser<V>::parse (v, dummy, s);
          }

          m[k] = v;
        }
        else
          throw missing_value (o);

        xs = true;
      }

      static void
      merge (std::map<K, V, C>& b, const std::map<K, V, C>& a)
      {
        for (typename std::map<K, V, C>::const_iterator i (a.begin ()); 
             i != a.end (); 
             ++i)
          b[i->first] = i->second;
      }
    };

    template <typename K, typename V, typename C>
    struct parser<std::multimap<K, V, C> >
    {
      static void
      parse (std::multimap<K, V, C>& m, bool& xs, scanner& s)
      {
        const char* o (s.next ());

        if (s.more ())
        {
          std::size_t pos (s.position ());
          std::string ov (s.next ());
          std::string::size_type p = ov.find ('=');

          K k = K ();
          V v = V ();
          std::string kstr (ov, 0, p);
          std::string vstr (ov, (p != std::string::npos ? p + 1 : ov.size ()));

          int ac (2);
          char* av[] =
          {
            const_cast<char*> (o),
            0
          };

          bool dummy;
          if (!kstr.empty ())
          {
            av[1] = const_cast<char*> (kstr.c_str ());
            argv_scanner s (0, ac, av, false, pos);
            parser<K>::parse (k, dummy, s);
          }

          if (!vstr.empty ())
          {
            av[1] = const_cast<char*> (vstr.c_str ());
            argv_scanner s (0, ac, av, false, pos);
            parser<V>::parse (v, dummy, s);
          }

          m.insert (typename std::multimap<K, V, C>::value_type (k, v));
        }
        else
          throw missing_value (o);

        xs = true;
      }

      static void
      merge (std::multimap<K, V, C>& b, const std::multimap<K, V, C>& a)
      {
        for (typename std::multimap<K, V, C>::const_iterator i (a.begin ()); 
             i != a.end (); 
             ++i)
          b.insert (typename std::multimap<K, V, C>::value_type (i->first,
                                                                 i->second));
      }
    };

    template <typename X, typename T, T X::*M>
    void
    thunk (X& x, scanner& s)
    {
      parser<T>::parse (x.*M, s);
    }

    template <typename X, bool X::*M>
    void
    thunk (X& x, scanner& s)
    {
      s.next ();
      x.*M = true;
    }

    template <typename X, typename T, T X::*M, bool X::*S>
    void
    thunk (X& x, scanner& s)
    {
      parser<T>::parse (x.*M, x.*S, s);
    }
  }
}

#include <map>

namespace bdep
{
  // cmd_sync_options
  //

  cmd_sync_options::
  cmd_sync_options ()
  : upgrade_ (),
    patch_ (),
    immediate_ (),
    recursive_ (),
    yes_ (),
    disfigure_ (),
    fetch_ (),
    fetch_full_ (),
    sys_no_query_ (),
    sys_install_ (),
    sys_no_fetch_ (),
    sys_no_stub_ (),
    sys_yes_ (),
    sys_sudo_ ("sudo"),
    sys_sudo_specified_ (false),
    create_host_config_ (),
    create_build2_config_ (),
    implicit_ (),
    hook_ (0),
    hook_specified_ (false)
  {
  }

  bool cmd_sync_options::
  parse (int& argc,
         char** argv,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool cmd_sync_options::
  parse (int start,
         int& argc,
         char** argv,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool cmd_sync_options::
  parse (int& argc,
         char** argv,
         int& end,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool cmd_sync_options::
  parse (int start,
         int& argc,
         char** argv,
         int& end,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool cmd_sync_options::
  parse (::bdep::cli::scanner& s,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    bool r = _parse (s, opt, arg);
    return r;
  }

  void cmd_sync_options::
  merge (const cmd_sync_options& a)
  {
    CLI_POTENTIALLY_UNUSED (a);

    // project_options base
    //
    ::bdep::project_options::merge (a);

    if (a.upgrade_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->upgrade_, a.upgrade_);
    }

    if (a.patch_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->patch_, a.patch_);
    }

    if (a.immediate_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->immediate_, a.immediate_);
    }

    if (a.recursive_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->recursive_, a.recursive_);
    }

    if (a.yes_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->yes_, a.yes_);
    }

    if (a.disfigure_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->disfigure_, a.disfigure_);
    }

    if (a.fetch_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->fetch_, a.fetch_);
    }

    if (a.fetch_full_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->fetch_full_, a.fetch_full_);
    }

    if (a.sys_no_query_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->sys_no_query_, a.sys_no_query_);
    }

    if (a.sys_install_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->sys_install_, a.sys_install_);
    }

    if (a.sys_no_fetch_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->sys_no_fetch_, a.sys_no_fetch_);
    }

    if (a.sys_no_stub_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->sys_no_stub_, a.sys_no_stub_);
    }

    if (a.sys_yes_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->sys_yes_, a.sys_yes_);
    }

    if (a.sys_sudo_specified_)
    {
      ::bdep::cli::parser< string>::merge (
        this->sys_sudo_, a.sys_sudo_);
      this->sys_sudo_specified_ = true;
    }

    if (a.create_host_config_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->create_host_config_, a.create_host_config_);
    }

    if (a.create_build2_config_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->create_build2_config_, a.create_build2_config_);
    }

    if (a.implicit_)
    {
      ::bdep::cli::parser< bool>::merge (
        this->implicit_, a.implicit_);
    }

    if (a.hook_specified_)
    {
      ::bdep::cli::parser< uint16_t>::merge (
        this->hook_, a.hook_);
      this->hook_specified_ = true;
    }
  }

  ::bdep::cli::usage_para cmd_sync_options::
  print_usage (::std::ostream& os, ::bdep::cli::usage_para p)
  {
    CLI_POTENTIALLY_UNUSED (os);

    if (p != ::bdep::cli::usage_para::none)
      os << ::std::endl;

    os << "\033[1mSYNC OPTIONS\033[0m" << ::std::endl;

    os << std::endl
       << "\033[1m--upgrade\033[0m|\033[1m-u\033[0m              Upgrade dependencies to the latest available version" << ::std::endl
       << "                          that satisfies all the constraints." << ::std::endl;

    os << std::endl
       << "\033[1m--patch\033[0m|\033[1m-p\033[0m                Upgrade dependencies to the latest available patch" << ::std::endl
       << "                          version that satisfies all the constraints." << ::std::endl;

    os << std::endl
       << "\033[1m--immediate\033[0m|\033[1m-i\033[0m            Also upgrade or patch immediate dependencies." << ::std::endl;

    os << std::endl
       << "\033[1m--recursive\033[0m|\033[1m-r\033[0m            Also upgrade or patch all dependencies, recursively." << ::std::endl;

    os << std::endl
       << "\033[1m--yes\033[0m|\033[1m-y\033[0m                  Don't prompt for confirmation when up/down-grading" << ::std::endl
       << "                          dependencies." << ::std::endl;

    os << std::endl
       << "\033[1m--disfigure\033[0m               Disfigure project packages during synchronization" << ::std::endl
       << "                          effectively causing their from-scratch" << ::std::endl
       << "                          reconfiguration." << ::std::endl;

    os << std::endl
       << "\033[1m--fetch\033[0m|\033[1m-f\033[0m                Perform the \033[1mfetch\033[0m command prior to synchronization." << ::std::endl;

    os << std::endl
       << "\033[1m--fetch-full\033[0m|\033[1m-F\033[0m           Perform the \033[1mfetch --full\033[0m command prior to" << ::std::endl
       << "                          synchronization." << ::std::endl;

    os << std::endl
       << "\033[1m--sys-no-query\033[0m            Do not query the system package manager for the" << ::std::endl
       << "                          installed versions of packages specified with the" << ::std::endl
       << "                          \033[1msys\033[0m scheme. See the corresponding \033[1mbpkg-pkg-build(1)\033[0m" << ::std::endl
       << "                          option for details." << ::std::endl;

    os << std::endl
       << "\033[1m--sys-install\033[0m             Instruct the system package manager to install" << ::std::endl
       << "                          available versions of packages specified with the" << ::std::endl
       << "                          \033[1msys\033[0m scheme that are not already installed. See the" << ::std::endl
       << "                          corresponding \033[1mbpkg-pkg-build(1)\033[0m option for details." << ::std::endl;

    os << std::endl
       << "\033[1m--sys-no-fetch\033[0m            Do not fetch the system package manager metadata" << ::std::endl
       << "                          before querying for available versions of packages" << ::std::endl
       << "                          specified with the \033[1msys\033[0m scheme. See the corresponding" << ::std::endl
       << "                          \033[1mbpkg-pkg-build(1)\033[0m option for details." << ::std::endl;

    os << std::endl
       << "\033[1m--sys-no-stub\033[0m             Do no require a stub for packages specified with the" << ::std::endl
       << "                          \033[1msys\033[0m scheme. See the corresponding \033[1mbpkg-pkg-build(1)\033[0m" << ::std::endl
       << "                          option for details." << ::std::endl;

    os << std::endl
       << "\033[1m--sys-yes\033[0m                 Assume the answer to the system package manager" << ::std::endl
       << "                          prompts is \033[1myes\033[0m. See the corresponding" << ::std::endl
       << "                          \033[1mbpkg-pkg-build(1)\033[0m option for details." << ::std::endl;

    os << std::endl
       << "\033[1m--sys-sudo\033[0m \033[4mprog\033[0m           The \033[1msudo\033[0m program to use for system package manager" << ::std::endl
       << "                          interactions that normally require administrative" << ::std::endl
       << "                          privileges (fetch package metadata, install packages," << ::std::endl
       << "                          etc). See the corresponding \033[1mbpkg-pkg-build(1)\033[0m option" << ::std::endl
       << "                          for details." << ::std::endl;

    os << std::endl
       << "\033[1m--create-host-config\033[0m      Create a configuration for build-time dependencies" << ::std::endl
       << "                          without prompt." << ::std::endl;

    os << std::endl
       << "\033[1m--create-build2-config\033[0m    Create a configuration for build system module" << ::std::endl
       << "                          dependencies without prompt." << ::std::endl;

    os << std::endl
       << "\033[1m--implicit\033[0m                Perform implicit synchronization. This mode is" << ::std::endl
       << "                          normally used by other tools (for example, a build" << ::std::endl
       << "                          system hook) to ensure projects and configurations" << ::std::endl
       << "                          are synchronized. To improve performance, especially" << ::std::endl
       << "                          for the \"everything is already synchronized\" case," << ::std::endl
       << "                          \033[1msync\033[0m executed in this mode assumes that no" << ::std::endl
       << "                          configuration flags (see \033[1mbdep-config(1)\033[0m) have changed" << ::std::endl
       << "                          since the last explicit synchronization. It also does" << ::std::endl
       << "                          not search for a project in the current working" << ::std::endl
       << "                          directory -- if any, its directory should be" << ::std::endl
       << "                          specified explicitly with \033[1m--config\033[0m|\033[1m-c\033[0m\033[0m." << ::std::endl;

    p = ::bdep::cli::usage_para::option;

    // project_options base
    //
    p = ::bdep::project_options::print_usage (os, p);

    return p;
  }

  struct _cli_cmd_sync_options_desc_type: ::bdep::cli::options
  {
    _cli_cmd_sync_options_desc_type ()
    {
      ::bdep::cmd_sync_options::fill (*this);
    }
  };

  void cmd_sync_options::
  fill (::bdep::cli::options& os)
  {
    // project_options base
    //
    ::bdep::project_options::fill (os);

    // --upgrade
    //
    {
      ::bdep::cli::option_names a;
      a.push_back ("-u");
      std::string dv;
      ::bdep::cli::option o ("--upgrade", a, true, dv);
      os.push_back (o);
    }

    // --patch
    //
    {
      ::bdep::cli::option_names a;
      a.push_back ("-p");
      std::string dv;
      ::bdep::cli::option o ("--patch", a, true, dv);
      os.push_back (o);
    }

    // --immediate
    //
    {
      ::bdep::cli::option_names a;
      a.push_back ("-i");
      std::string dv;
      ::bdep::cli::option o ("--immediate", a, true, dv);
      os.push_back (o);
    }

    // --recursive
    //
    {
      ::bdep::cli::option_names a;
      a.push_back ("-r");
      std::string dv;
      ::bdep::cli::option o ("--recursive", a, true, dv);
      os.push_back (o);
    }

    // --yes
    //
    {
      ::bdep::cli::option_names a;
      a.push_back ("-y");
      std::string dv;
      ::bdep::cli::option o ("--yes", a, true, dv);
      os.push_back (o);
    }

    // --disfigure
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("--disfigure", a, true, dv);
      os.push_back (o);
    }

    // --fetch
    //
    {
      ::bdep::cli::option_names a;
      a.push_back ("-f");
      std::string dv;
      ::bdep::cli::option o ("--fetch", a, true, dv);
      os.push_back (o);
    }

    // --fetch-full
    //
    {
      ::bdep::cli::option_names a;
      a.push_back ("-F");
      std::string dv;
      ::bdep::cli::option o ("--fetch-full", a, true, dv);
      os.push_back (o);
    }

    // --sys-no-query
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("--sys-no-query", a, true, dv);
      os.push_back (o);
    }

    // --sys-install
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("--sys-install", a, true, dv);
      os.push_back (o);
    }

    // --sys-no-fetch
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("--sys-no-fetch", a, true, dv);
      os.push_back (o);
    }

    // --sys-no-stub
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("--sys-no-stub", a, true, dv);
      os.push_back (o);
    }

    // --sys-yes
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("--sys-yes", a, true, dv);
      os.push_back (o);
    }

    // --sys-sudo
    //
    {
      ::bdep::cli::option_names a;
      std::string dv ("sudo");
      ::bdep::cli::option o ("--sys-sudo", a, false, dv);
      os.push_back (o);
    }

    // --create-host-config
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("--create-host-config", a, true, dv);
      os.push_back (o);
    }

    // --create-build2-config
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("--create-build2-config", a, true, dv);
      os.push_back (o);
    }

    // --implicit
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("--implicit", a, true, dv);
      os.push_back (o);
    }

    // --hook
    //
    {
      ::bdep::cli::option_names a;
      std::string dv ("0");
      ::bdep::cli::option o ("--hook", a, false, dv);
      os.push_back (o);
    }
  }

  const ::bdep::cli::options& cmd_sync_options::
  description ()
  {
    static _cli_cmd_sync_options_desc_type _cli_cmd_sync_options_desc_;
    return _cli_cmd_sync_options_desc_;
  }

  typedef
  std::map<std::string, void (*) (cmd_sync_options&, ::bdep::cli::scanner&)>
  _cli_cmd_sync_options_map;

  static _cli_cmd_sync_options_map _cli_cmd_sync_options_map_;

  struct _cli_cmd_sync_options_map_init
  {
    _cli_cmd_sync_options_map_init ()
    {
      _cli_cmd_sync_options_map_["--upgrade"] =
      &::bdep::cli::thunk< cmd_sync_options, &cmd_sync_options::upgrade_ >;
      _cli_cmd_sync_options_map_["-u"] =
      &::bdep::cli::thunk< cmd_sync_options, &cmd_sync_options::upgrade_ >;
      _cli_cmd_sync_options_map_["--patch"] =
      &::bdep::cli::thunk< cmd_sync_options, &cmd_sync_options::patch_ >;
      _cli_cmd_sync_options_map_["-p"] =
      &::bdep::cli::thunk< cmd_sync_options, &cmd_sync_options::patch_ >;
      _cli_cmd_sync_options_map_["--immediate"] =
      &::bdep::cli::thunk< cmd_sync_options, &cmd_sync_options::immediate_ >;
      _cli_cmd_sync_options_map_["-i"] =
      &::bdep::cli::thunk< cmd_sync_options, &cmd_sync_options::immediate_ >;
      _cli_cmd_sync_options_map_["--recursive"] =
      &::bdep::cli::thunk< cmd_sync_options, &cmd_sync_options::recursive_ >;
      _cli_cmd_sync_options_map_["-r"] =
      &::bdep::cli::thunk< cmd_sync_options, &cmd_sync_options::recursive_ >;
      _cli_cmd_sync_options_map_["--yes"] =
      &::bdep::cli::thunk< cmd_sync_options, &cmd_sync_options::yes_ >;
      _cli_cmd_sync_options_map_["-y"] =
      &::bdep::cli::thunk< cmd_sync_options, &cmd_sync_options::yes_ >;
      _cli_cmd_sync_options_map_["--disfigure"] =
      &::bdep::cli::thunk< cmd_sync_options, &cmd_sync_options::disfigure_ >;
      _cli_cmd_sync_options_map_["--fetch"] =
      &::bdep::cli::thunk< cmd_sync_options, &cmd_sync_options::fetch_ >;
      _cli_cmd_sync_options_map_["-f"] =
      &::bdep::cli::thunk< cmd_sync_options, &cmd_sync_options::fetch_ >;
      _cli_cmd_sync_options_map_["--fetch-full"] =
      &::bdep::cli::thunk< cmd_sync_options, &cmd_sync_options::fetch_full_ >;
      _cli_cmd_sync_options_map_["-F"] =
      &::bdep::cli::thunk< cmd_sync_options, &cmd_sync_options::fetch_full_ >;
      _cli_cmd_sync_options_map_["--sys-no-query"] =
      &::bdep::cli::thunk< cmd_sync_options, &cmd_sync_options::sys_no_query_ >;
      _cli_cmd_sync_options_map_["--sys-install"] =
      &::bdep::cli::thunk< cmd_sync_options, &cmd_sync_options::sys_install_ >;
      _cli_cmd_sync_options_map_["--sys-no-fetch"] =
      &::bdep::cli::thunk< cmd_sync_options, &cmd_sync_options::sys_no_fetch_ >;
      _cli_cmd_sync_options_map_["--sys-no-stub"] =
      &::bdep::cli::thunk< cmd_sync_options, &cmd_sync_options::sys_no_stub_ >;
      _cli_cmd_sync_options_map_["--sys-yes"] =
      &::bdep::cli::thunk< cmd_sync_options, &cmd_sync_options::sys_yes_ >;
      _cli_cmd_sync_options_map_["--sys-sudo"] =
      &::bdep::cli::thunk< cmd_sync_options, string, &cmd_sync_options::sys_sudo_,
        &cmd_sync_options::sys_sudo_specified_ >;
      _cli_cmd_sync_options_map_["--create-host-config"] =
      &::bdep::cli::thunk< cmd_sync_options, &cmd_sync_options::create_host_config_ >;
      _cli_cmd_sync_options_map_["--create-build2-config"] =
      &::bdep::cli::thunk< cmd_sync_options, &cmd_sync_options::create_build2_config_ >;
      _cli_cmd_sync_options_map_["--implicit"] =
      &::bdep::cli::thunk< cmd_sync_options, &cmd_sync_options::implicit_ >;
      _cli_cmd_sync_options_map_["--hook"] =
      &::bdep::cli::thunk< cmd_sync_options, uint16_t, &cmd_sync_options::hook_,
        &cmd_sync_options::hook_specified_ >;
    }
  };

  static _cli_cmd_sync_options_map_init _cli_cmd_sync_options_map_init_;

  bool cmd_sync_options::
  _parse (const char* o, ::bdep::cli::scanner& s)
  {
    _cli_cmd_sync_options_map::const_iterator i (_cli_cmd_sync_options_map_.find (o));

    if (i != _cli_cmd_sync_options_map_.end ())
    {
      (*(i->second)) (*this, s);
      return true;
    }

    // project_options base
    //
    if (::bdep::project_options::_parse (o, s))
      return true;

    return false;
  }

  bool cmd_sync_options::
  _parse (::bdep::cli::scanner& s,
          ::bdep::cli::unknown_mode opt_mode,
          ::bdep::cli::unknown_mode arg_mode)
  {
    // Can't skip combined flags (--no-combined-flags).
    //
    assert (opt_mode != ::bdep::cli::unknown_mode::skip);

    bool r = false;
    bool opt = true;

    while (s.more ())
    {
      const char* o = s.peek ();

      if (std::strcmp (o, "--") == 0)
      {
        opt = false;
      }

      if (opt)
      {
        if (_parse (o, s))
        {
          r = true;
          continue;
        }

        if (std::strncmp (o, "-", 1) == 0 && o[1] != '\0')
        {
          // Handle combined option values.
          //
          std::string co;
          if (const char* v = std::strchr (o, '='))
          {
            co.assign (o, 0, v - o);
            ++v;

            int ac (2);
            char* av[] =
            {
              const_cast<char*> (co.c_str ()),
              const_cast<char*> (v)
            };

            ::bdep::cli::argv_scanner ns (0, ac, av);

            if (_parse (co.c_str (), ns))
            {
              // Parsed the option but not its value?
              //
              if (ns.end () != 2)
                throw ::bdep::cli::invalid_value (co, v);

              s.next ();
              r = true;
              continue;
            }
            else
            {
              // Set the unknown option and fall through.
              //
              o = co.c_str ();
            }
          }

          // Handle combined flags.
          //
          char cf[3];
          {
            const char* p = o + 1;
            for (; *p != '\0'; ++p)
            {
              if (!((*p >= 'a' && *p <= 'z') ||
                    (*p >= 'A' && *p <= 'Z') ||
                    (*p >= '0' && *p <= '9')))
                break;
            }

            if (*p == '\0')
            {
              for (p = o + 1; *p != '\0'; ++p)
              {
                std::strcpy (cf, "-");
                cf[1] = *p;
                cf[2] = '\0';

                int ac (1);
                char* av[] =
                {
                  cf
                };

                ::bdep::cli::argv_scanner ns (0, ac, av);

                if (!_parse (cf, ns))
                  break;
              }

              if (*p == '\0')
              {
                // All handled.
                //
                s.next ();
                r = true;
                continue;
              }
              else
              {
                // Set the unknown option and fall through.
                //
                o = cf;
              }
            }
          }

          switch (opt_mode)
          {
            case ::bdep::cli::unknown_mode::skip:
            {
              s.skip ();
              r = true;
              continue;
            }
            case ::bdep::cli::unknown_mode::stop:
            {
              break;
            }
            case ::bdep::cli::unknown_mode::fail:
            {
              throw ::bdep::cli::unknown_option (o);
            }
          }

          break;
        }
      }

      switch (arg_mode)
      {
        case ::bdep::cli::unknown_mode::skip:
        {
          s.skip ();
          r = true;
          continue;
        }
        case ::bdep::cli::unknown_mode::stop:
        {
          break;
        }
        case ::bdep::cli::unknown_mode::fail:
        {
          throw ::bdep::cli::unknown_argument (o);
        }
      }

      break;
    }

    return r;
  }

  // cmd_sync_pkg_options
  //

  cmd_sync_pkg_options::
  cmd_sync_pkg_options ()
  : config_name_ (),
    config_name_specified_ (false),
    config_id_ (),
    config_id_specified_ (false),
    config_ (),
    config_specified_ (false)
  {
  }

  bool cmd_sync_pkg_options::
  parse (int& argc,
         char** argv,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool cmd_sync_pkg_options::
  parse (int start,
         int& argc,
         char** argv,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    return r;
  }

  bool cmd_sync_pkg_options::
  parse (int& argc,
         char** argv,
         int& end,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool cmd_sync_pkg_options::
  parse (int start,
         int& argc,
         char** argv,
         int& end,
         bool erase,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    ::bdep::cli::argv_scanner s (start, argc, argv, erase);
    bool r = _parse (s, opt, arg);
    end = s.end ();
    return r;
  }

  bool cmd_sync_pkg_options::
  parse (::bdep::cli::scanner& s,
         ::bdep::cli::unknown_mode opt,
         ::bdep::cli::unknown_mode arg)
  {
    bool r = _parse (s, opt, arg);
    return r;
  }

  void cmd_sync_pkg_options::
  merge (const cmd_sync_pkg_options& a)
  {
    CLI_POTENTIALLY_UNUSED (a);

    if (a.config_name_specified_)
    {
      ::bdep::cli::parser< vector<string>>::merge (
        this->config_name_, a.config_name_);
      this->config_name_specified_ = true;
    }

    if (a.config_id_specified_)
    {
      ::bdep::cli::parser< vector<uint64_t>>::merge (
        this->config_id_, a.config_id_);
      this->config_id_specified_ = true;
    }

    if (a.config_specified_)
    {
      ::bdep::cli::parser< vector<dir_path>>::merge (
        this->config_, a.config_);
      this->config_specified_ = true;
    }
  }

  ::bdep::cli::usage_para cmd_sync_pkg_options::
  print_usage (::std::ostream& os, ::bdep::cli::usage_para p)
  {
    CLI_POTENTIALLY_UNUSED (os);

    return p;
  }

  struct _cli_cmd_sync_pkg_options_desc_type: ::bdep::cli::options
  {
    _cli_cmd_sync_pkg_options_desc_type ()
    {
      ::bdep::cmd_sync_pkg_options::fill (*this);
    }
  };

  void cmd_sync_pkg_options::
  fill (::bdep::cli::options& os)
  {
    // --config-name
    //
    {
      ::bdep::cli::option_names a;
      a.push_back ("-n");
      std::string dv;
      ::bdep::cli::option o ("--config-name", a, false, dv);
      os.push_back (o);
    }

    // --config-id
    //
    {
      ::bdep::cli::option_names a;
      std::string dv;
      ::bdep::cli::option o ("--config-id", a, false, dv);
      os.push_back (o);
    }

    // --config
    //
    {
      ::bdep::cli::option_names a;
      a.push_back ("-c");
      std::string dv;
      ::bdep::cli::option o ("--config", a, false, dv);
      os.push_back (o);
    }
  }

  const ::bdep::cli::options& cmd_sync_pkg_options::
  description ()
  {
    static _cli_cmd_sync_pkg_options_desc_type _cli_cmd_sync_pkg_options_desc_;
    return _cli_cmd_sync_pkg_options_desc_;
  }

  typedef
  std::map<std::string, void (*) (cmd_sync_pkg_options&, ::bdep::cli::scanner&)>
  _cli_cmd_sync_pkg_options_map;

  static _cli_cmd_sync_pkg_options_map _cli_cmd_sync_pkg_options_map_;

  struct _cli_cmd_sync_pkg_options_map_init
  {
    _cli_cmd_sync_pkg_options_map_init ()
    {
      _cli_cmd_sync_pkg_options_map_["--config-name"] =
      &::bdep::cli::thunk< cmd_sync_pkg_options, vector<string>, &cmd_sync_pkg_options::config_name_,
        &cmd_sync_pkg_options::config_name_specified_ >;
      _cli_cmd_sync_pkg_options_map_["-n"] =
      &::bdep::cli::thunk< cmd_sync_pkg_options, vector<string>, &cmd_sync_pkg_options::config_name_,
        &cmd_sync_pkg_options::config_name_specified_ >;
      _cli_cmd_sync_pkg_options_map_["--config-id"] =
      &::bdep::cli::thunk< cmd_sync_pkg_options, vector<uint64_t>, &cmd_sync_pkg_options::config_id_,
        &cmd_sync_pkg_options::config_id_specified_ >;
      _cli_cmd_sync_pkg_options_map_["--config"] =
      &::bdep::cli::thunk< cmd_sync_pkg_options, vector<dir_path>, &cmd_sync_pkg_options::config_,
        &cmd_sync_pkg_options::config_specified_ >;
      _cli_cmd_sync_pkg_options_map_["-c"] =
      &::bdep::cli::thunk< cmd_sync_pkg_options, vector<dir_path>, &cmd_sync_pkg_options::config_,
        &cmd_sync_pkg_options::config_specified_ >;
    }
  };

  static _cli_cmd_sync_pkg_options_map_init _cli_cmd_sync_pkg_options_map_init_;

  bool cmd_sync_pkg_options::
  _parse (const char* o, ::bdep::cli::scanner& s)
  {
    _cli_cmd_sync_pkg_options_map::const_iterator i (_cli_cmd_sync_pkg_options_map_.find (o));

    if (i != _cli_cmd_sync_pkg_options_map_.end ())
    {
      (*(i->second)) (*this, s);
      return true;
    }

    return false;
  }

  bool cmd_sync_pkg_options::
  _parse (::bdep::cli::scanner& s,
          ::bdep::cli::unknown_mode opt_mode,
          ::bdep::cli::unknown_mode arg_mode)
  {
    // Can't skip combined flags (--no-combined-flags).
    //
    assert (opt_mode != ::bdep::cli::unknown_mode::skip);

    bool r = false;
    bool opt = true;

    while (s.more ())
    {
      const char* o = s.peek ();

      if (std::strcmp (o, "--") == 0)
      {
        opt = false;
      }

      if (opt)
      {
        if (_parse (o, s))
        {
          r = true;
          continue;
        }

        if (std::strncmp (o, "-", 1) == 0 && o[1] != '\0')
        {
          // Handle combined option values.
          //
          std::string co;
          if (const char* v = std::strchr (o, '='))
          {
            co.assign (o, 0, v - o);
            ++v;

            int ac (2);
            char* av[] =
            {
              const_cast<char*> (co.c_str ()),
              const_cast<char*> (v)
            };

            ::bdep::cli::argv_scanner ns (0, ac, av);

            if (_parse (co.c_str (), ns))
            {
              // Parsed the option but not its value?
              //
              if (ns.end () != 2)
                throw ::bdep::cli::invalid_value (co, v);

              s.next ();
              r = true;
              continue;
            }
            else
            {
              // Set the unknown option and fall through.
              //
              o = co.c_str ();
            }
          }

          // Handle combined flags.
          //
          char cf[3];
          {
            const char* p = o + 1;
            for (; *p != '\0'; ++p)
            {
              if (!((*p >= 'a' && *p <= 'z') ||
                    (*p >= 'A' && *p <= 'Z') ||
                    (*p >= '0' && *p <= '9')))
                break;
            }

            if (*p == '\0')
            {
              for (p = o + 1; *p != '\0'; ++p)
              {
                std::strcpy (cf, "-");
                cf[1] = *p;
                cf[2] = '\0';

                int ac (1);
                char* av[] =
                {
                  cf
                };

                ::bdep::cli::argv_scanner ns (0, ac, av);

                if (!_parse (cf, ns))
                  break;
              }

              if (*p == '\0')
              {
                // All handled.
                //
                s.next ();
                r = true;
                continue;
              }
              else
              {
                // Set the unknown option and fall through.
                //
                o = cf;
              }
            }
          }

          switch (opt_mode)
          {
            case ::bdep::cli::unknown_mode::skip:
            {
              s.skip ();
              r = true;
              continue;
            }
            case ::bdep::cli::unknown_mode::stop:
            {
              break;
            }
            case ::bdep::cli::unknown_mode::fail:
            {
              throw ::bdep::cli::unknown_option (o);
            }
          }

          break;
        }
      }

      switch (arg_mode)
      {
        case ::bdep::cli::unknown_mode::skip:
        {
          s.skip ();
          r = true;
          continue;
        }
        case ::bdep::cli::unknown_mode::stop:
        {
          break;
        }
        case ::bdep::cli::unknown_mode::fail:
        {
          throw ::bdep::cli::unknown_argument (o);
        }
      }

      break;
    }

    return r;
  }
}

namespace bdep
{
  ::bdep::cli::usage_para
  print_bdep_sync_usage (::std::ostream& os, ::bdep::cli::usage_para p)
  {
    CLI_POTENTIALLY_UNUSED (os);

    if (p != ::bdep::cli::usage_para::none)
      os << ::std::endl;

    os << "\033[1mSYNOPSIS\033[0m" << ::std::endl
       << ::std::endl
       << "\033[1mbdep sync\033[0m [\033[4moptions\033[0m] [\033[4mpkg-spec\033[0m] [\033[4mcfg-spec\033[0m] [\033[4mpkg-args\033[0m]" << ::std::endl
       << "\033[1mbdep sync\033[0m [\033[4moptions\033[0m] [\033[4mpkg-spec\033[0m] [\033[4mcfg-spec\033[0m]  \033[1m--upgrade\033[0m|\033[1m-u\033[0m | \033[1m--patch\033[0m|\033[1m-p\033[0m" << ::std::endl
       << "\033[1mbdep sync\033[0m [\033[4moptions\033[0m] [\033[4mpkg-spec\033[0m] [\033[4mcfg-spec\033[0m] [\033[1m--upgrade\033[0m|\033[1m-u\033[0m | \033[1m--patch\033[0m|\033[1m-p\033[0m]" << ::std::endl
       << "          \033[4mdep-spec\033[0m... [\033[4mcfg-var\033[0m...] \033[0m" << ::std::endl
       << ::std::endl
       << "\033[4mdep-spec\033[0m = \033[4mpkg\033[0m[\033[1m/\033[0m\033[4mver\033[0m]" << ::std::endl
       << "\033[4mcfg-spec\033[0m = (\033[1m@\033[0m\033[4mcfg-name\033[0m | \033[1m--config\033[0m|\033[1m-c\033[0m \033[4mcfg-dir\033[0m)... | \033[1m--all\033[0m|\033[1m-a\033[0m" << ::std::endl
       << "\033[4mpkg-spec\033[0m = (\033[1m--directory\033[0m|\033[1m-d\033[0m \033[4mpkg-dir\033[0m)... | \033[4mprj-spec\033[0m" << ::std::endl
       << "\033[4mprj-spec\033[0m = \033[1m--directory\033[0m|\033[1m-d\033[0m \033[4mprj-dir\033[0m" << ::std::endl
       << "\033[4mpkg-args\033[0m = (\033[1m?\033[0m\033[4mpkg\033[0m | \033[4mcfg-var\033[0m)...\033[0m" << ::std::endl
       << ::std::endl
       << "\033[1mDESCRIPTION\033[0m" << ::std::endl
       << ::std::endl
       << "The \033[1msync\033[0m command synchronizes a project with its build configurations. The" << ::std::endl
       << "first form (no \033[1m--upgrade\033[0m or \033[1m--patch\033[0m and only \033[4mpkg-args\033[0m arguments, if any, are" << ::std::endl
       << "specified) upgrades the project packages to the latest version/iteration," << ::std::endl
       << "adjusts their dependencies according to the latest manifest information, and" << ::std::endl
       << "updates the lockfile." << ::std::endl
       << ::std::endl
       << "If no project or package directory is specified, then the current working" << ::std::endl
       << "directory is assumed. If no configuration is specified, then the default" << ::std::endl
       << "configurations are assumed. See \033[1mbdep-projects-configs(1)\033[0m for details on" << ::std::endl
       << "specifying projects and configurations. Optional \033[4mpkg-args\033[0m are the additional" << ::std::endl
       << "dependency packages and/or configuration variables to pass to the underlying" << ::std::endl
       << "\033[1mbpkg-pkg-build(1)\033[0m command." << ::std::endl
       << ::std::endl
       << "The second form (no arguments but either \033[1m--upgrade\033[0m or \033[1m--patch\033[0m is specified), in" << ::std::endl
       << "addition to the first form's functionality, also upgrades or patches immediate" << ::std::endl
       << "(by default or if \033[1m--immediate\033[0m|\033[1m-i\033[0m\033[0m is specified) or all (if \033[1m--recursive\033[0m|\033[1m-r\033[0m\033[0m is" << ::std::endl
       << "specified) dependencies of the specified project packages. If no project" << ::std::endl
       << "packages are specified explicitly, then this form upgrades or patches" << ::std::endl
       << "dependencies of all the initialized packages in a project." << ::std::endl
       << ::std::endl
       << "The third form (one or more \033[4mdep-spec\033[0m arguments are specified), in addition to" << ::std::endl
       << "the first form's functionality, also upgrades (by default or if \033[1m--upgrade\033[0m is" << ::std::endl
       << "specified) or patches (if \033[1m--patch\033[0m is specified) the specified dependencies. If" << ::std::endl
       << "\033[1m--immediate\033[0m|\033[1m-i\033[0m\033[0m or \033[1m--recursive\033[0m|\033[1m-r\033[0m\033[0m is specified, then it also upgrades or patches" << ::std::endl
       << "the immediate or all dependencies of the specified dependencies, respectively." << ::std::endl
       << "Alternative to \033[1m--upgrade\033[0m and \033[1m--patch\033[0m, the desired upgrade (or downgrade)" << ::std::endl
       << "version can be specified explicitly." << ::std::endl
       << ::std::endl
       << "Note also that \033[1m--immediate\033[0m|\033[1m-i\033[0m\033[0m or \033[1m--recursive\033[0m|\033[1m-r\033[0m\033[0m can only be specified with an" << ::std::endl
       << "explicit \033[1m--upgrade\033[0m or \033[1m--patch\033[0m." << ::std::endl
       << ::std::endl
       << "Configuration variables can be specified to only apply to specific packages in" << ::std::endl
       << "\033[4mpkg-args\033[0m and \033[4mdep-spec\033[0m using the argument grouping mechanism" << ::std::endl
       << "(\033[1mbdep-argument-grouping(1)\033[0m). Additionally, packages in \033[4mpkg-args\033[0m can be placed" << ::std::endl
       << "into specific linked configurations by specifying the configuration with one of" << ::std::endl
       << "the \033[1m--config*\033[0m options (or \033[1m@\033[0m notation) using the same grouping mechanism." << ::std::endl
       << ::std::endl
       << "If during synchronization a build-time dependency is encountered and there is" << ::std::endl
       << "no build configuration of a suitable type associated with the project, then the" << ::std::endl
       << "user is prompted (unless the respective \033[1m--create-*-config\033[0m option is specified)" << ::std::endl
       << "to automatically create such a configuration and associate it with the project." << ::std::endl
       << "See \033[1mbpkg-cfg-create(1)\033[0m for background on configuration types." << ::std::endl
       << ::std::endl
       << "\033[1mEXAMPLES\033[0m" << ::std::endl
       << ::std::endl
       << "As an example, consider project \033[1mprj\033[0m with two packages, \033[1mfoo\033[0m and \033[1mlibfoo\033[0m:" << ::std::endl
       << ::std::endl
       << "prj/" << ::std::endl
       << "|-- foo/" << ::std::endl
       << "`-- libfoo/" << ::std::endl
       << ::std::endl
       << "Assuming \033[1mfoo\033[0m and \033[1mlibfoo\033[0m have been initialized in the default build" << ::std::endl
       << "configuration, the following invocations illustrate the common \033[1msync\033[0m use cases" << ::std::endl
       << "(the current working directory is shown before the shell prompt)." << ::std::endl
       << ::std::endl
       << "Synchronize \033[1mfoo\033[0m and \033[1mlibfoo\033[0m with the default configuration:" << ::std::endl
       << ::std::endl
       << "prj/$ bdep sync" << ::std::endl
       << ::std::endl
       << "The same (all initialized packages in a project are always synchronized at" << ::std::endl
       << "once):" << ::std::endl
       << ::std::endl
       << "prj/$ cd foo" << ::std::endl
       << "foo/$ bdep sync" << ::std::endl
       << ::std::endl
       << "Add a dependency on \033[1mlibx\033[0m with \033[1msync\033[0m fetching and configuring a suitable version:" << ::std::endl
       << ::std::endl
       << "foo/$ edit manifest  # Add 'depends: libx ^1.0.0'" << ::std::endl
       << "foo/$ bdep sync" << ::std::endl
       << ::std::endl
       << "Upgrade all the immediate dependencies of \033[1mfoo\033[0m:" << ::std::endl
       << ::std::endl
       << "foo/$ bdep sync -u" << ::std::endl
       << ::std::endl
       << "Upgrade all the dependencies of all the initialized packages in a project" << ::std::endl
       << "recursively:" << ::std::endl
       << ::std::endl
       << "foo/$ cd ../" << ::std::endl
       << "prj/$ bdep sync -u -r" << ::std::endl
       << ::std::endl
       << "Upgrade \033[1mlibx\033[0m to the latest version:" << ::std::endl
       << ::std::endl
       << "prj/$ bdep sync libx" << ::std::endl
       << ::std::endl
       << "Upgrade \033[1mlibx\033[0m and its immediate dependencies to the latest version:" << ::std::endl
       << ::std::endl
       << "prj/$ bdep sync -u -i libx" << ::std::endl
       << ::std::endl
       << "Upgrade \033[1mlibx\033[0m to the latest patch version:" << ::std::endl
       << ::std::endl
       << "prj/$ bdep sync -p libx" << ::std::endl
       << ::std::endl
       << "Upgrade \033[1mlibx\033[0m and all its dependencies recursively to the latest patch version." << ::std::endl
       << ::std::endl
       << "prj/$ bdep sync -p -r libx" << ::std::endl
       << ::std::endl
       << "Upgrade \033[1mlibx\033[0m to version \033[1m1.2.3\033[0m." << ::std::endl
       << ::std::endl
       << "prj/$ bdep sync libx/1.2.3" << ::std::endl
       << ::std::endl
       << "Upgrade \033[1mlibx\033[0m to version \033[1m1.2.3\033[0m and patch all its dependencies, recursively:" << ::std::endl
       << ::std::endl
       << "prj/$ bdep sync -p -r libx/1.2.3" << ::std::endl;

    p = ::bdep::cmd_sync_options::print_usage (os, ::bdep::cli::usage_para::text);

    p = ::bdep::cmd_sync_pkg_options::print_usage (os, p);

    if (p != ::bdep::cli::usage_para::none)
      os << ::std::endl;

    os << "\033[1mDEFAULT OPTIONS FILES\033[0m" << ::std::endl
       << ::std::endl
       << "See \033[1mbdep-default-options-files(1)\033[0m for an overview of the default options files." << ::std::endl
       << "For the \033[1msync\033[0m command the search start directory is the project directory," << ::std::endl
       << "except for the implicit mode for which only the predefined directories (system," << ::std::endl
       << "etc) are searched in. The following options files are searched for in each" << ::std::endl
       << "directory and, if found, loaded in the order listed:" << ::std::endl
       << ::std::endl
       << "bdep.options" << ::std::endl
       << "bdep-{sync|sync-implicit}.options # (mode-dependent)" << ::std::endl
       << ::std::endl
       << "The following \033[1msync\033[0m command options cannot be specified in the default options" << ::std::endl
       << "files:" << ::std::endl
       << ::std::endl
       << "--directory|-d" << ::std::endl
       << "--implicit" << ::std::endl
       << "--config|-c" << ::std::endl
       << ::std::endl
       << "\033[1mENVIRONMENT\033[0m" << ::std::endl
       << ::std::endl
       << "The \033[1mBDEP_SYNC\033[0m environment variable can be used to suppress automatic" << ::std::endl
       << "synchronization on build system invocation. If set, auto-synchronization will" << ::std::endl
       << "only be performed if the variable's value is \033[1mtrue\033[0m or \033[1m1\033[0m. The ability to suppress" << ::std::endl
       << "auto-synchronization can be useful when you don't have usable \033[1mbdep\033[0m and/or \033[1mbpkg\033[0m." << ::std::endl
       << ::std::endl
       << "To avoid recursive re-synchronization, the \033[1msync\033[0m command also maintains the" << ::std::endl
       << "\033[1mBDEP_SYNCED_CONFIGS\033[0m environment variable. It contains a space-separated," << ::std::endl
       << "\033[1m\"\033[0m-quoted list of configuration paths that have been or are being synchronized" << ::std::endl
       << "by the current \033[1mbdep\033[0m invocation chain. The \033[1msync\033[0m command examines this variable" << ::std::endl
       << "and silently ignores synchronization requests that have been or are already" << ::std::endl
       << "being performed." << ::std::endl;

    p = ::bdep::cli::usage_para::text;

    return p;
  }
}

// Begin epilogue.
//
//
// End epilogue.

